namespace HKLib.hk2018;

public static class IdentityTypeMap
{
    public static Dictionary<string, Type> Map { get; } = new()
    {
        { "hkImageFormat::Enum", typeof(hkImageFormat.Enum) },
        { "hkImageAddressMode::Enum", typeof(hkImageAddressMode.Enum) },
        { "hkEnum<hclOperatorType, unsigned int>", typeof(hclOperatorType) },
        { "hkEnum<CustomManualSelectorGenerator::RideSync, unsigned char>", typeof(CustomManualSelectorGenerator.RideSync) },
        { "hkEnum<CustomManualSelectorGenerator::ReplanningAI, unsigned char>", typeof(CustomManualSelectorGenerator.ReplanningAI) },
        { "hkEnum<CustomManualSelectorGenerator::ChangeTypeOfSelectedIndexAfterActivate, unsigned char>", typeof(CustomManualSelectorGenerator.ChangeTypeOfSelectedIndexAfterActivate) },
        { "hkEnum<CustomManualSelectorGenerator::AnimeEndEventType, int>", typeof(CustomManualSelectorGenerator.AnimeEndEventType) },
        { "hkEnum<CustomManualSelectorGenerator::OffsetType, int>", typeof(CustomManualSelectorGenerator.OffsetType) },
        { "hkEnum<CustomLookAtTwistModifier::GainState, signed char>", typeof(CustomLookAtTwistModifier.GainState) },
        { "hkEnum<CustomLookAtTwistModifier::SetAngleMethod, signed char>", typeof(CustomLookAtTwistModifier.SetAngleMethod) },
        { "hkEnum<CustomLookAtTwistModifier::MultiRotationAxisType, signed char>", typeof(CustomLookAtTwistModifier.MultiRotationAxisType) },
        { "hkEnum<CustomBoneFixModifier::GainState, signed char>", typeof(CustomBoneFixModifier.GainState) },
        { "hkEnum<CustomManualSelectorGenerator::RideSync, hkUint8>", typeof(CustomManualSelectorGenerator.RideSync) },
        { "hkEnum<CustomManualSelectorGenerator::ReplanningAI, hkUint8>", typeof(CustomManualSelectorGenerator.ReplanningAI) },
        { "hkEnum<CustomManualSelectorGenerator::ChangeTypeOfSelectedIndexAfterActivate, hkUint8>", typeof(CustomManualSelectorGenerator.ChangeTypeOfSelectedIndexAfterActivate) },
        { "hkEnum<CustomManualSelectorGenerator::AnimeEndEventType, hkInt32>", typeof(CustomManualSelectorGenerator.AnimeEndEventType) },
        { "hkEnum<CustomManualSelectorGenerator::OffsetType, hkInt32>", typeof(CustomManualSelectorGenerator.OffsetType) },
        { "hkEnum<CustomLookAtTwistModifier::GainState, hkInt8>", typeof(CustomLookAtTwistModifier.GainState) },
        { "hkEnum<CustomLookAtTwistModifier::SetAngleMethod, hkInt8>", typeof(CustomLookAtTwistModifier.SetAngleMethod) },
        { "hkEnum<CustomLookAtTwistModifier::MultiRotationAxisType, hkInt8>", typeof(CustomLookAtTwistModifier.MultiRotationAxisType) },
        { "hkEnum<CustomBoneFixModifier::GainState, hkInt8>", typeof(CustomBoneFixModifier.GainState) },
        { "CustomManualSelectorGenerator::ChangeTypeOfSelectedIndexAfterActivate", typeof(CustomManualSelectorGenerator.ChangeTypeOfSelectedIndexAfterActivate) },
        { "CustomManualSelectorGenerator::RideSync", typeof(CustomManualSelectorGenerator.RideSync) },
        { "CustomManualSelectorGenerator::ReplanningAI", typeof(CustomManualSelectorGenerator.ReplanningAI) },
        { "CustomManualSelectorGenerator::AnimeEndEventType", typeof(CustomManualSelectorGenerator.AnimeEndEventType) },
        { "CustomManualSelectorGenerator::OffsetType", typeof(CustomManualSelectorGenerator.OffsetType) },
        { "CustomLookAtTwistModifier::GainState", typeof(CustomLookAtTwistModifier.GainState) },
        { "CustomLookAtTwistModifier::SetAngleMethod", typeof(CustomLookAtTwistModifier.SetAngleMethod) },
        { "CustomLookAtTwistModifier::MultiRotationAxisType", typeof(CustomLookAtTwistModifier.MultiRotationAxisType) },
        { "CustomBoneFixModifier::GainState", typeof(CustomBoneFixModifier.GainState) },
        { "hkFlags<hknpManifoldViewerBase::ManifoldWeldingEvent::WeldingStatusEnum, unsigned char>", typeof(hknpManifoldViewerBase.ManifoldWeldingEvent.WeldingStatusEnum) },
        { "hkFlags<hknpManifoldViewerBase::VdbManifold::StatusEnum, unsigned short>", typeof(hknpManifoldViewerBase.VdbManifold.StatusEnum) },
        { "hkEnum<hknpVehicleWheelCollide::WheelCollideType, unsigned char>", typeof(hknpVehicleWheelCollide.WheelCollideType) },
        { "hkEnum<hknpCharacterSurfaceInfo::SupportedState, unsigned char>", typeof(hknpCharacterSurfaceInfo.SupportedState) },
        { "hkEnum<hknpFirstPersonGun::KeyboardKey, unsigned char>", typeof(hknpFirstPersonGun.KeyboardKey) },
        { "hkEnum<hknpFirstPersonGun::Type, unsigned char>", typeof(hknpFirstPersonGun.Type) },
        { "hkEnum<hknpActivationControl::Enum, unsigned char>", typeof(hknpActivationControl.Enum) },
        { "hkEnum<hknpActivationState::Enum, unsigned char>", typeof(hknpActivationState.Enum) },
        { "hkEnum<hknpWorld::UpdateCachesMode, unsigned char>", typeof(hknpWorld.UpdateCachesMode) },
        { "hkEnum<hknpMotionType::Enum, unsigned char>", typeof(hknpMotionType.Enum) },
        { "hkEnum<hknpWorld::PivotLocation, unsigned char>", typeof(hknpWorld.PivotLocation) },
        { "hkEnum<hknpWorld::UpdateMotionMode, unsigned char>", typeof(hknpWorld.UpdateMotionMode) },
        { "hkEnum<hknpWorld::AdditionMode, unsigned char>", typeof(hknpWorld.AdditionMode) },
        { "hkEnum<hknpWorld::ActivationMode, unsigned char>", typeof(hknpWorld.ActivationMode) },
        { "hkEnum<hknpContactImpulseEvent::Status, unsigned char>", typeof(hknpContactImpulseEvent.Status) },
        { "hkEnum<hknpLinearSurfaceVelocity::ProjectMethod, unsigned char>", typeof(hknpLinearSurfaceVelocity.ProjectMethod) },
        { "hkEnum<hknpSurfaceVelocity::Space, unsigned char>", typeof(hknpSurfaceVelocity.Space) },
        { "hkEnum<hknpMaterial::MassChangerCategory, unsigned char>", typeof(hknpMaterial.MassChangerCategory) },
        { "hkEnum<hknpMaterial::CombinePolicy, unsigned char>", typeof(hknpMaterial.CombinePolicy) },
        { "hkEnum<hknpMaterial::TriggerType, unsigned char>", typeof(hknpMaterial.TriggerType) },
        { "hkFlags<hknpConstraintGroup::FlagsEnum, unsigned short>", typeof(hknpConstraintGroup.FlagsEnum) },
        { "hkFlags<hknpConstraint::FlagsEnum, unsigned short>", typeof(hknpConstraint.FlagsEnum) },
        { "hkFlags<hknpBodyQuality::FlagsEnum, unsigned int>", typeof(hknpBodyQuality.FlagsEnum) },
        { "hkFlags<hknpLodBodyFlags::Enum, unsigned char>", typeof(hknpLodBodyFlags.Enum) },
        { "hkEnum<hknpCollisionDispatchType::Enum, unsigned char>", typeof(hknpCollisionDispatchType.Enum) },
        { "hkEnum<hknpShapeType::Enum, unsigned char>", typeof(hknpShapeType.Enum) },
        { "hkFlags<hknpShape::FlagsEnum, unsigned short>", typeof(hknpShape.FlagsEnum) },
        { "hkEnum<hknpShapeTagCodec::Type, unsigned char>", typeof(hknpShapeTagCodec.Type) },
        { "hkFlags<hknpShapeTagCodec::Hints, unsigned int>", typeof(hknpShapeTagCodec.Hints) },
        { "hkEnum<hknpCompoundShapeBoundingVolumeType::Enum, unsigned char>", typeof(hknpCompoundShapeBoundingVolumeType.Enum) },
        { "hkEnum<hknpCollisionFilter::Type, unsigned char>", typeof(hknpCollisionFilter.Type) },
        { "hkEnum<hknpTriggerEvent::Status, unsigned char>", typeof(hknpTriggerEvent.Status) },
        { "hkEnum<hknpManifoldEvent::Status, unsigned char>", typeof(hknpManifoldEvent.Status) },
        { "hkFlags<hknpManifoldViewerBase::ManifoldWeldingEvent::WeldingStatusEnum, hkUint8>", typeof(hknpManifoldViewerBase.ManifoldWeldingEvent.WeldingStatusEnum) },
        { "hkFlags<hknpManifoldViewerBase::VdbManifold::StatusEnum, hkUint16>", typeof(hknpManifoldViewerBase.VdbManifold.StatusEnum) },
        { "hkEnum<hknpVehicleWheelCollide::WheelCollideType, hkUint8>", typeof(hknpVehicleWheelCollide.WheelCollideType) },
        { "hkEnum<hknpCharacterSurfaceInfo::SupportedState, hkUint8>", typeof(hknpCharacterSurfaceInfo.SupportedState) },
        { "hkEnum<hknpFirstPersonGun::KeyboardKey, hkUint8>", typeof(hknpFirstPersonGun.KeyboardKey) },
        { "hkEnum<hknpFirstPersonGun::Type, hkUint8>", typeof(hknpFirstPersonGun.Type) },
        { "hkEnum<hknpActivationControl::Enum, hkUint8>", typeof(hknpActivationControl.Enum) },
        { "hkEnum<hknpActivationState::Enum, hkUint8>", typeof(hknpActivationState.Enum) },
        { "hkEnum<hknpWorld::UpdateCachesMode, hkUint8>", typeof(hknpWorld.UpdateCachesMode) },
        { "hkEnum<hknpMotionType::Enum, hkUint8>", typeof(hknpMotionType.Enum) },
        { "hkEnum<hknpWorld::PivotLocation, hkUint8>", typeof(hknpWorld.PivotLocation) },
        { "hkEnum<hknpWorld::UpdateMotionMode, hkUint8>", typeof(hknpWorld.UpdateMotionMode) },
        { "hkEnum<hknpWorld::AdditionMode, hkUint8>", typeof(hknpWorld.AdditionMode) },
        { "hkEnum<hknpWorld::ActivationMode, hkUint8>", typeof(hknpWorld.ActivationMode) },
        { "hkEnum<hknpContactImpulseEvent::Status, hkUint8>", typeof(hknpContactImpulseEvent.Status) },
        { "hkEnum<hknpLinearSurfaceVelocity::ProjectMethod, hkUint8>", typeof(hknpLinearSurfaceVelocity.ProjectMethod) },
        { "hkEnum<hknpSurfaceVelocity::Space, hkUint8>", typeof(hknpSurfaceVelocity.Space) },
        { "hkEnum<hknpMaterial::MassChangerCategory, hkUint8>", typeof(hknpMaterial.MassChangerCategory) },
        { "hkEnum<hknpMaterial::CombinePolicy, hkUint8>", typeof(hknpMaterial.CombinePolicy) },
        { "hkEnum<hknpMaterial::TriggerType, hkUint8>", typeof(hknpMaterial.TriggerType) },
        { "hkFlags<hknpConstraintGroup::FlagsEnum, hkUint16>", typeof(hknpConstraintGroup.FlagsEnum) },
        { "hkFlags<hknpConstraint::FlagsEnum, hkUint16>", typeof(hknpConstraint.FlagsEnum) },
        { "hkFlags<hknpBodyQuality::FlagsEnum, hkUint32>", typeof(hknpBodyQuality.FlagsEnum) },
        { "hkFlags<hknpLodBodyFlags::Enum, hkUint8>", typeof(hknpLodBodyFlags.Enum) },
        { "hkEnum<hknpCollisionDispatchType::Enum, hkUint8>", typeof(hknpCollisionDispatchType.Enum) },
        { "hkEnum<hknpShapeType::Enum, hkUint8>", typeof(hknpShapeType.Enum) },
        { "hkFlags<hknpShape::FlagsEnum, hkUint16>", typeof(hknpShape.FlagsEnum) },
        { "hkEnum<hknpShapeTagCodec::Type, hkUint8>", typeof(hknpShapeTagCodec.Type) },
        { "hkFlags<hknpShapeTagCodec::Hints, hkUint32>", typeof(hknpShapeTagCodec.Hints) },
        { "hkEnum<hknpCompoundShapeBoundingVolumeType::Enum, hkUint8>", typeof(hknpCompoundShapeBoundingVolumeType.Enum) },
        { "hkEnum<hknpCollisionFilter::Type, hkUint8>", typeof(hknpCollisionFilter.Type) },
        { "hkEnum<hknpTriggerEvent::Status, hkUint8>", typeof(hknpTriggerEvent.Status) },
        { "hkEnum<hknpManifoldEvent::Status, hkUint8>", typeof(hknpManifoldEvent.Status) },
        { "hknpLodBodyFlags::Enum", typeof(hknpLodBodyFlags.Enum) },
        { "hknpLevelOfDetail::Enum", typeof(hknpLevelOfDetail.Enum) },
        { "hknpManifoldType::Enum", typeof(hknpManifoldType.Enum) },
        { "hknpBroadPhaseType::Enum", typeof(hknpBroadPhaseType.Enum) },
        { "hknpSimulationType::Enum", typeof(hknpSimulationType.Enum) },
        { "hknpMotionRangeBreachPolicy::Enum", typeof(hknpMotionRangeBreachPolicy.Enum) },
        { "hknpActivationControl::Enum", typeof(hknpActivationControl.Enum) },
        { "hknpActivationState::Enum", typeof(hknpActivationState.Enum) },
        { "hknpMotionType::Enum", typeof(hknpMotionType.Enum) },
        { "hknpManifoldViewerBase::ManifoldWeldingEvent::WeldingStatusEnum", typeof(hknpManifoldViewerBase.ManifoldWeldingEvent.WeldingStatusEnum) },
        { "hknpManifoldViewerBase::VdbManifold::StatusEnum", typeof(hknpManifoldViewerBase.VdbManifold.StatusEnum) },
        { "hknpVehicleWheelCollide::WheelCollideType", typeof(hknpVehicleWheelCollide.WheelCollideType) },
        { "hknpRagdollPenetrationUtil::ResolveModeFlagsEnum", typeof(hknpRagdollPenetrationUtil.ResolveModeFlagsEnum) },
        { "hknpRagdollPenetrationUtil::PenetrationStatusFlagsEnum", typeof(hknpRagdollPenetrationUtil.PenetrationStatusFlagsEnum) },
        { "hknpRagdollState::ConstraintEasingMode", typeof(hknpRagdollState.ConstraintEasingMode) },
        { "hknpRagdollState::StateId", typeof(hknpRagdollState.StateId) },
        { "hknpCharacterSurfaceInfo::SupportedState", typeof(hknpCharacterSurfaceInfo.SupportedState) },
        { "hknpCharacterState::hknpCharacterStateType", typeof(hknpCharacterState.hknpCharacterStateType) },
        { "hknpFirstPersonCharacter::ControlFlags", typeof(hknpFirstPersonCharacter.ControlFlags) },
        { "hknpFirstPersonGun::KeyboardKey", typeof(hknpFirstPersonGun.KeyboardKey) },
        { "hknpFirstPersonGun::Type", typeof(hknpFirstPersonGun.Type) },
        { "hknpWorldCinfo::SolverType", typeof(hknpWorldCinfo.SolverType) },
        { "hknpWorld::PivotLocation", typeof(hknpWorld.PivotLocation) },
        { "hknpWorld::UpdateMotionMode", typeof(hknpWorld.UpdateMotionMode) },
        { "hknpWorld::UpdateCachesMode", typeof(hknpWorld.UpdateCachesMode) },
        { "hknpWorld::ActivationMode", typeof(hknpWorld.ActivationMode) },
        { "hknpWorld::AdditionMode", typeof(hknpWorld.AdditionMode) },
        { "hknpContactImpulseEvent::Status", typeof(hknpContactImpulseEvent.Status) },
        { "hknpMotionPropertiesId::Preset", typeof(hknpMotionPropertiesId.Preset) },
        { "hknpMotionProperties::DeactivationSettings::Strategy", typeof(hknpMotionProperties.DeactivationSettings.Strategy) },
        { "hknpMotionProperties::SolverStabilizationType", typeof(hknpMotionProperties.SolverStabilizationType) },
        { "hknpSurfaceVelocity::Space", typeof(hknpSurfaceVelocity.Space) },
        { "hknpLinearSurfaceVelocity::ProjectMethod", typeof(hknpLinearSurfaceVelocity.ProjectMethod) },
        { "hknpMaterial::MassChangerCategory", typeof(hknpMaterial.MassChangerCategory) },
        { "hknpMaterial::CombinePolicy", typeof(hknpMaterial.CombinePolicy) },
        { "hknpMaterial::TriggerType", typeof(hknpMaterial.TriggerType) },
        { "hknpConstraintGroup::FlagsEnum", typeof(hknpConstraintGroup.FlagsEnum) },
        { "hknpConstraint::FlagsEnum", typeof(hknpConstraint.FlagsEnum) },
        { "hknpBodyQualityId::Preset", typeof(hknpBodyQualityId.Preset) },
        { "hknpBodyQuality::FlagsEnum", typeof(hknpBodyQuality.FlagsEnum) },
        { "hknpCollisionDispatchType::Enum", typeof(hknpCollisionDispatchType.Enum) },
        { "hknpShapeType::Enum", typeof(hknpShapeType.Enum) },
        { "hknpShape::MassConfig::Quality", typeof(hknpShape.MassConfig.Quality) },
        { "hknpShape::ConvexRadiusDisplayMode", typeof(hknpShape.ConvexRadiusDisplayMode) },
        { "hknpShape::FlagsEnum", typeof(hknpShape.FlagsEnum) },
        { "hknpShapeTagCodec::Hints", typeof(hknpShapeTagCodec.Hints) },
        { "hknpShapeTagCodec::Type", typeof(hknpShapeTagCodec.Type) },
        { "hknpHeightFieldGeometry::Fold", typeof(hknpHeightFieldGeometry.Fold) },
        { "hknpCompoundShapeBoundingVolumeType::Enum", typeof(hknpCompoundShapeBoundingVolumeType.Enum) },
        { "hknpCollisionFilter::Type", typeof(hknpCollisionFilter.Type) },
        { "hknpTriggerEvent::Status", typeof(hknpTriggerEvent.Status) },
        { "hknpManifoldEvent::Status", typeof(hknpManifoldEvent.Status) },
        { "hkDebugDisplayMarker::Type", typeof(hkDebugDisplayMarker.Type) },
        { "hkEnum<hkxSpline::ControlType, unsigned char>", typeof(hkxSpline.ControlType) },
        { "hkEnum<hkxVertexDescription::DataType, unsigned short>", typeof(hkxVertexDescription.DataType) },
        { "hkEnum<hkxVertexDescription::DataUsage, unsigned short>", typeof(hkxVertexDescription.DataUsage) },
        { "hkEnum<hkxIndexBuffer::IndexType, signed char>", typeof(hkxIndexBuffer.IndexType) },
        { "hkEnum<hkxVertexFloatDataChannel::VertexFloatDimensions, unsigned char>", typeof(hkxVertexFloatDataChannel.VertexFloatDimensions) },
        { "hkEnum<hkxMaterialShader::ShaderType, unsigned char>", typeof(hkxMaterialShader.ShaderType) },
        { "hkEnum<hkxMaterialEffect::EffectType, unsigned char>", typeof(hkxMaterialEffect.EffectType) },
        { "hkEnum<hkxMaterial::TextureType, int>", typeof(hkxMaterial.TextureType) },
        { "hkEnum<hkxMaterial::Transparency, unsigned char>", typeof(hkxMaterial.Transparency) },
        { "hkEnum<hkxMaterial::UVMappingAlgorithm, unsigned int>", typeof(hkxMaterial.UVMappingAlgorithm) },
        { "hkEnum<hkxLight::LightType, signed char>", typeof(hkxLight.LightType) },
        { "hkEnum<hkxAttribute::Hint, unsigned char>", typeof(hkxAttribute.Hint) },
        { "hkEnum<hkxSpline::ControlType, hkUint8>", typeof(hkxSpline.ControlType) },
        { "hkEnum<hkxVertexDescription::DataType, hkUint16>", typeof(hkxVertexDescription.DataType) },
        { "hkEnum<hkxVertexDescription::DataUsage, hkUint16>", typeof(hkxVertexDescription.DataUsage) },
        { "hkEnum<hkxIndexBuffer::IndexType, hkInt8>", typeof(hkxIndexBuffer.IndexType) },
        { "hkEnum<hkxVertexFloatDataChannel::VertexFloatDimensions, hkUint8>", typeof(hkxVertexFloatDataChannel.VertexFloatDimensions) },
        { "hkEnum<hkxMaterialShader::ShaderType, hkUint8>", typeof(hkxMaterialShader.ShaderType) },
        { "hkEnum<hkxMaterialEffect::EffectType, hkUint8>", typeof(hkxMaterialEffect.EffectType) },
        { "hkEnum<hkxMaterial::TextureType, hkInt32>", typeof(hkxMaterial.TextureType) },
        { "hkEnum<hkxMaterial::Transparency, hkUint8>", typeof(hkxMaterial.Transparency) },
        { "hkEnum<hkxMaterial::UVMappingAlgorithm, hkUint32>", typeof(hkxMaterial.UVMappingAlgorithm) },
        { "hkEnum<hkxLight::LightType, hkInt8>", typeof(hkxLight.LightType) },
        { "hkEnum<hkxAttribute::Hint, hkUint8>", typeof(hkxAttribute.Hint) },
        { "hkxSpline::ControlType", typeof(hkxSpline.ControlType) },
        { "hkxVertexDescription::DataUsage", typeof(hkxVertexDescription.DataUsage) },
        { "hkxVertexDescription::DataType", typeof(hkxVertexDescription.DataType) },
        { "hkxIndexBuffer::IndexType", typeof(hkxIndexBuffer.IndexType) },
        { "hkxVertexFloatDataChannel::VertexFloatDimensions", typeof(hkxVertexFloatDataChannel.VertexFloatDimensions) },
        { "hkxMaterialShader::ShaderType", typeof(hkxMaterialShader.ShaderType) },
        { "hkxMaterialEffect::EffectType", typeof(hkxMaterialEffect.EffectType) },
        { "hkxMaterial::Transparency", typeof(hkxMaterial.Transparency) },
        { "hkxMaterial::UVMappingAlgorithm", typeof(hkxMaterial.UVMappingAlgorithm) },
        { "hkxMaterial::TextureType", typeof(hkxMaterial.TextureType) },
        { "hkxLight::LightType", typeof(hkxLight.LightType) },
        { "hkxAttribute::Hint", typeof(hkxAttribute.Hint) },
        { "hkEnum<hkp6DofConstraintData::AxisMode, unsigned char>", typeof(hkp6DofConstraintData.AxisMode) },
        { "hkEnum<hkpConstraintMotor::MotorType, signed char>", typeof(hkpConstraintMotor.MotorType) },
        { "hkEnum<hkpCallbackConstraintMotor::CallbackType, unsigned int>", typeof(hkpCallbackConstraintMotor.CallbackType) },
        { "hkEnum<hkpPointToPathConstraintData::OrientationConstraintType, signed char>", typeof(hkpPointToPathConstraintData.OrientationConstraintType) },
        { "hkEnum<hkpConeLimitConstraintAtom::MeasurementMode, unsigned char>", typeof(hkpConeLimitConstraintAtom.MeasurementMode) },
        { "hkEnum<hkpConstraintAtom::SolvingMethod, unsigned char>", typeof(hkpConstraintAtom.SolvingMethod) },
        { "hkEnum<hkpConstraintAtom::AtomType, unsigned short>", typeof(hkpConstraintAtom.AtomType) },
        { "hkEnum<hkp6DofConstraintData::AxisMode, hkUint8>", typeof(hkp6DofConstraintData.AxisMode) },
        { "hkEnum<hkpConstraintMotor::MotorType, hkInt8>", typeof(hkpConstraintMotor.MotorType) },
        { "hkEnum<hkpCallbackConstraintMotor::CallbackType, hkUint32>", typeof(hkpCallbackConstraintMotor.CallbackType) },
        { "hkEnum<hkpPointToPathConstraintData::OrientationConstraintType, hkInt8>", typeof(hkpPointToPathConstraintData.OrientationConstraintType) },
        { "hkEnum<hkpConeLimitConstraintAtom::MeasurementMode, hkUint8>", typeof(hkpConeLimitConstraintAtom.MeasurementMode) },
        { "hkEnum<hkpConstraintAtom::SolvingMethod, hkUint8>", typeof(hkpConstraintAtom.SolvingMethod) },
        { "hkEnum<hkpConstraintAtom::AtomType, hkUint16>", typeof(hkpConstraintAtom.AtomType) },
        { "hkpConstraintMotor::MotorType", typeof(hkpConstraintMotor.MotorType) },
        { "hkpCallbackConstraintMotor::CallbackType", typeof(hkpCallbackConstraintMotor.CallbackType) },
        { "hkpConstraintData::ConstraintType", typeof(hkpConstraintData.ConstraintType) },
        { "hkpPointToPathConstraintData::OrientationConstraintType", typeof(hkpPointToPathConstraintData.OrientationConstraintType) },
        { "hkp6DofConstraintData::AxisMode", typeof(hkp6DofConstraintData.AxisMode) },
        { "hkpConeLimitConstraintAtom::MeasurementMode", typeof(hkpConeLimitConstraintAtom.MeasurementMode) },
        { "hkpConstraintAtom::SolvingMethod", typeof(hkpConstraintAtom.SolvingMethod) },
        { "hkpConstraintAtom::AtomType", typeof(hkpConstraintAtom.AtomType) },
        { "hkgpCgo::Config::SolverAccuracy", typeof(hkgpCgo.Config.SolverAccuracy) },
        { "hkgpCgo::Config::VertexCombinator", typeof(hkgpCgo.Config.VertexCombinator) },
        { "hkgpCgo::Config::VertexSemantic", typeof(hkgpCgo.Config.VertexSemantic) },
        { "hkFlags<hkVertexFormat::HintFlags, unsigned char>", typeof(hkVertexFormat.HintFlags) },
        { "hkEnum<hkVertexFormat::ComponentUsage, unsigned char>", typeof(hkVertexFormat.ComponentUsage) },
        { "hkEnum<hkVertexFormat::ComponentType, unsigned char>", typeof(hkVertexFormat.ComponentType) },
        { "hkEnum<hkMeshTexture::TextureUsageType, signed char>", typeof(hkMeshTexture.TextureUsageType) },
        { "hkEnum<hkMeshTexture::FilterMode, signed char>", typeof(hkMeshTexture.FilterMode) },
        { "hkEnum<hkMeshTexture::Format, signed char>", typeof(hkMeshTexture.Format) },
        { "hkEnum<hkMeshSection::MeshSectionIndexType, unsigned char>", typeof(hkMeshSection.MeshSectionIndexType) },
        { "hkEnum<hkMeshSection::PrimitiveType, unsigned char>", typeof(hkMeshSection.PrimitiveType) },
        { "hkFlags<hkVertexFormat::HintFlags, hkUint8>", typeof(hkVertexFormat.HintFlags) },
        { "hkEnum<hkVertexFormat::ComponentUsage, hkUint8>", typeof(hkVertexFormat.ComponentUsage) },
        { "hkEnum<hkVertexFormat::ComponentType, hkUint8>", typeof(hkVertexFormat.ComponentType) },
        { "hkEnum<hkMeshTexture::TextureUsageType, hkInt8>", typeof(hkMeshTexture.TextureUsageType) },
        { "hkEnum<hkMeshTexture::FilterMode, hkInt8>", typeof(hkMeshTexture.FilterMode) },
        { "hkEnum<hkMeshTexture::Format, hkInt8>", typeof(hkMeshTexture.Format) },
        { "hkEnum<hkMeshSection::MeshSectionIndexType, hkUint8>", typeof(hkMeshSection.MeshSectionIndexType) },
        { "hkEnum<hkMeshSection::PrimitiveType, hkUint8>", typeof(hkMeshSection.PrimitiveType) },
        { "hkVertexFormat::HintFlags", typeof(hkVertexFormat.HintFlags) },
        { "hkVertexFormat::ComponentUsage", typeof(hkVertexFormat.ComponentUsage) },
        { "hkVertexFormat::ComponentType", typeof(hkVertexFormat.ComponentType) },
        { "hkMeshTexture::TextureUsageType", typeof(hkMeshTexture.TextureUsageType) },
        { "hkMeshTexture::FilterMode", typeof(hkMeshTexture.FilterMode) },
        { "hkMeshTexture::Format", typeof(hkMeshTexture.Format) },
        { "hkMeshSection::PrimitiveType", typeof(hkMeshSection.PrimitiveType) },
        { "hkMeshSection::MeshSectionIndexType", typeof(hkMeshSection.MeshSectionIndexType) },
        { "hkcdRayCastResult::Enum", typeof(hkcdRayCastResult.Enum) },
        { "hkUint64Be", typeof(ulong) },
        { "hkUint64Le", typeof(ulong) },
        { "hkUint32Be", typeof(uint) },
        { "hkUint32Le", typeof(uint) },
        { "hkUint16Be", typeof(ushort) },
        { "hkUint16Le", typeof(ushort) },
        { "hkUint8Be", typeof(byte) },
        { "hkUint8Le", typeof(byte) },
        { "hkInt64Be", typeof(long) },
        { "hkInt64Le", typeof(long) },
        { "hkInt32Be", typeof(int) },
        { "hkInt32Le", typeof(int) },
        { "hkInt16Be", typeof(short) },
        { "hkInt16Le", typeof(short) },
        { "hkInt8Be", typeof(sbyte) },
        { "hkInt8Le", typeof(sbyte) },
        { "char", typeof(byte) },
        { "unsigned long long", typeof(ulong) },
        { "long long", typeof(long) },
        { "unsigned long", typeof(uint) },
        { "long", typeof(int) },
        { "unsigned int", typeof(uint) },
        { "int", typeof(int) },
        { "unsigned short", typeof(ushort) },
        { "short", typeof(short) },
        { "unsigned char", typeof(byte) },
        { "signed char", typeof(sbyte) },
        { "hkFlags<hkPropertyFlags::Enum, unsigned int>", typeof(hkPropertyFlags.Enum) },
        { "hkEnum<hctAttributeDescription20151::Hint, signed char>", typeof(hctAttributeDescription20151.Hint) },
        { "hkEnum<hctAttributeDescription20151::ForcedType, signed char>", typeof(hctAttributeDescription20151.ForcedType) },
        { "hkFlags<hk::ExposeBase::ScopeValues, unsigned char>", typeof(hk.ExposeBase.ScopeValues) },
        { "hkFlags<hk::ExposeBase::AccessValues, unsigned char>", typeof(hk.ExposeBase.AccessValues) },
        { "hkEnum<hkSemanticsAttribute::Semantics, signed char>", typeof(hkSemanticsAttribute.Semantics) },
        { "hkEnum<hkLinkAttribute::Link, signed char>", typeof(hkLinkAttribute.Link) },
        { "hkEnum<hkModelerNodeTypeAttribute::ModelerType, signed char>", typeof(hkModelerNodeTypeAttribute.ModelerType) },
        { "hkEnum<hkGizmoAttribute::GizmoType, signed char>", typeof(hkGizmoAttribute.GizmoType) },
        { "hkEnum<hkAttributeHideCriteria::Types, signed char>", typeof(hkAttributeHideCriteria.Types) },
        { "hkEnum<hk::PreferredSerializationFormat::Format, unsigned int>", typeof(hk.PreferredSerializationFormat.Format) },
        { "hkEnum<hkGpuTraceResult::ScopeType, unsigned short>", typeof(hkGpuTraceResult.ScopeType) },
        { "hkEnum<hkMonitorStreamFrameInfo::AbsoluteTimeCounter, unsigned int>", typeof(hkMonitorStreamFrameInfo.AbsoluteTimeCounter) },
        { "hkEnum<hkCommand::PrimaryType, unsigned char>", typeof(hkCommand.PrimaryType) },
        { "hkFlags<hkPropertyFlags::Enum, hkUint32>", typeof(hkPropertyFlags.Enum) },
        { "hkEnum<hctAttributeDescription20151::Hint, hkInt8>", typeof(hctAttributeDescription20151.Hint) },
        { "hkEnum<hctAttributeDescription20151::ForcedType, hkInt8>", typeof(hctAttributeDescription20151.ForcedType) },
        { "hkFlags<hkReflect::Decl::DeclFlagBits, int>", typeof(hkReflect.Decl.DeclFlagBits) },
        { "hkFlags<hk::ExposeBase::ScopeValues, hkUint8>", typeof(hk.ExposeBase.ScopeValues) },
        { "hkFlags<hk::ExposeBase::AccessValues, hkUint8>", typeof(hk.ExposeBase.AccessValues) },
        { "hkEnum<hkSemanticsAttribute::Semantics, hkInt8>", typeof(hkSemanticsAttribute.Semantics) },
        { "hkEnum<hkLinkAttribute::Link, hkInt8>", typeof(hkLinkAttribute.Link) },
        { "hkEnum<hkModelerNodeTypeAttribute::ModelerType, hkInt8>", typeof(hkModelerNodeTypeAttribute.ModelerType) },
        { "hkEnum<hkGizmoAttribute::GizmoType, hkInt8>", typeof(hkGizmoAttribute.GizmoType) },
        { "hkEnum<hkAttributeHideCriteria::Types, hkInt8>", typeof(hkAttributeHideCriteria.Types) },
        { "hkEnum<hk::PreferredSerializationFormat::Format, hkUint32>", typeof(hk.PreferredSerializationFormat.Format) },
        { "hkEnum<hkGpuTraceResult::ScopeType, hkUint16>", typeof(hkGpuTraceResult.ScopeType) },
        { "hkEnum<hkMonitorStreamFrameInfo::AbsoluteTimeCounter, hkUint32>", typeof(hkMonitorStreamFrameInfo.AbsoluteTimeCounter) },
        { "hkEnum<hkCommand::PrimaryType, hkUint8>", typeof(hkCommand.PrimaryType) },
        { "TypeRegistryTest::B", typeof(TypeRegistryTest.B) },
        { "TypeRegistryTest::A", typeof(TypeRegistryTest.A) },
        { "hkUintReal", typeof(uint) },
        { "hkLong", typeof(long) },
        { "hkUlong", typeof(ulong) },
        { "hkUint32", typeof(uint) },
        { "hkUint16", typeof(ushort) },
        { "hkUint8", typeof(byte) },
        { "hkInt32", typeof(int) },
        { "hkInt16", typeof(short) },
        { "hkInt8", typeof(sbyte) },
        { "hkInt64", typeof(long) },
        { "hkUint64", typeof(ulong) },
        { "hkPropertyFlags::Enum", typeof(hkPropertyFlags.Enum) },
        { "hkColor::Argb", typeof(Color) },
        { "hkJobType", typeof(hkJobType) },
        { "hkAsyncThreadPool::HardwareThreadBinding", typeof(hkAsyncThreadPool.HardwareThreadBinding) },
        { "hkAsyncThreadPool::ThreadPriority", typeof(hkAsyncThreadPool.ThreadPriority) },
        { "hkLog::Level::Enum", typeof(hkLog.Level.Enum) },
        { "hkFileSystem::Watcher::Change::ChangeType", typeof(hkFileSystem.Watcher.Change.ChangeType) },
        { "hkTypeVm::Program::InstructionType", typeof(hkTypeVm.Program.InstructionType) },
        { "hkReflect::Decl::DeclFlags", typeof(int) },
        { "hkReflect::Decl::DeclFlagBits", typeof(hkReflect.Decl.DeclFlagBits) },
        { "hkReflect::Type::FlagBits", typeof(hkReflect.Type.FlagBits) },
        { "hkReflect::Kind", typeof(hkReflect.Kind) },
        { "hkReflect::Opt::Values", typeof(hkReflect.Opt.Values) },
        { "hk::EditingTypeEnum", typeof(hk.EditingTypeEnum) },
        { "hk::UiTypeEnum", typeof(hk.UiTypeEnum) },
        { "hk::ExposeBase::ScopeValues", typeof(hk.ExposeBase.ScopeValues) },
        { "hk::ExposeBase::AccessValues", typeof(hk.ExposeBase.AccessValues) },
        { "hk::ComponentDisplayUpdateOnChangeOptions::Enum", typeof(hk.ComponentDisplayUpdateOnChangeOptions.Enum) },
        { "hk::ComponentDisplayOptions::Enum", typeof(hk.ComponentDisplayOptions.Enum) },
        { "hke::PublicFieldPin::Enum", typeof(hke.PublicFieldPin.Enum) },
        { "hke::ConstTypes::Enum", typeof(hke.ConstTypes.Enum) },
        { "hkSemanticsAttribute::Semantics", typeof(hkSemanticsAttribute.Semantics) },
        { "hkLinkAttribute::Link", typeof(hkLinkAttribute.Link) },
        { "hkModelerNodeTypeAttribute::ModelerType", typeof(hkModelerNodeTypeAttribute.ModelerType) },
        { "hkGizmoAttribute::GizmoType", typeof(hkGizmoAttribute.GizmoType) },
        { "hkAttributeHideCriteria::Types", typeof(hkAttributeHideCriteria.Types) },
        { "hk::PreferredSerializationFormat::Format", typeof(hk.PreferredSerializationFormat.Format) },
        { "hkGpuTraceResult::ScopeType", typeof(hkGpuTraceResult.ScopeType) },
        { "hkms::AccumulateOp::Enum", typeof(hkms.AccumulateOp.Enum) },
        { "hkMonitorStreamFrameInfo::AbsoluteTimeCounter", typeof(hkMonitorStreamFrameInfo.AbsoluteTimeCounter) },
        { "hkCommand::PrimaryType", typeof(hkCommand.PrimaryType) },
        { "hkEnum<hkaAnimatedReferenceFrame::hkaReferenceFrameTypeEnum, signed char>", typeof(hkaAnimatedReferenceFrame.hkaReferenceFrameTypeEnum) },
        { "hkEnum<hkaSkeletonMapperData::MappingType, int>", typeof(hkaSkeletonMapperData.MappingType) },
        { "hkEnum<hkaAnimationBinding::BlendHint, signed char>", typeof(hkaAnimationBinding.BlendHint) },
        { "hkEnum<hkaAnimation::AnimationType, int>", typeof(hkaAnimation.AnimationType) },
        { "hkEnum<hkaSplineCompressedAnimation::TrackCompressionParams::ScalarQuantization, unsigned char>", typeof(hkaSplineCompressedAnimation.TrackCompressionParams.ScalarQuantization) },
        { "hkEnum<hkaSplineCompressedAnimation::TrackCompressionParams::RotationQuantization, unsigned char>", typeof(hkaSplineCompressedAnimation.TrackCompressionParams.RotationQuantization) },
        { "hkEnum<hkaAnimatedReferenceFrame::hkaReferenceFrameTypeEnum, hkInt8>", typeof(hkaAnimatedReferenceFrame.hkaReferenceFrameTypeEnum) },
        { "hkEnum<hkaSkeletonMapperData::MappingType, hkInt32>", typeof(hkaSkeletonMapperData.MappingType) },
        { "hkEnum<hkaAnimationBinding::BlendHint, hkInt8>", typeof(hkaAnimationBinding.BlendHint) },
        { "hkEnum<hkaAnimation::AnimationType, hkInt32>", typeof(hkaAnimation.AnimationType) },
        { "hkEnum<hkaSplineCompressedAnimation::TrackCompressionParams::ScalarQuantization, hkUint8>", typeof(hkaSplineCompressedAnimation.TrackCompressionParams.ScalarQuantization) },
        { "hkEnum<hkaSplineCompressedAnimation::TrackCompressionParams::RotationQuantization, hkUint8>", typeof(hkaSplineCompressedAnimation.TrackCompressionParams.RotationQuantization) },
        { "hkaAnimatedReferenceFrame::hkaReferenceFrameTypeEnum", typeof(hkaAnimatedReferenceFrame.hkaReferenceFrameTypeEnum) },
        { "hkaSkeletonMapperUtils::ExtractedMotionParams::ExtractedMotionMode", typeof(hkaSkeletonMapperUtils.ExtractedMotionParams.ExtractedMotionMode) },
        { "hkaSkeletonMapperData::MappingType", typeof(hkaSkeletonMapperData.MappingType) },
        { "hkaAnimationBinding::BlendHint", typeof(hkaAnimationBinding.BlendHint) },
        { "hkaAnimation::AnimationType", typeof(hkaAnimation.AnimationType) },
        { "hkaSplineCompressedAnimation::TrackCompressionParams::ScalarQuantization", typeof(hkaSplineCompressedAnimation.TrackCompressionParams.ScalarQuantization) },
        { "hkaSplineCompressedAnimation::TrackCompressionParams::RotationQuantization", typeof(hkaSplineCompressedAnimation.TrackCompressionParams.RotationQuantization) },
        { "hkEnum<hclVertexSelectionInput::VertexSelectionType, unsigned int>", typeof(hclVertexSelectionInput.VertexSelectionType) },
        { "hkEnum<hclVertexFloatInput::VertexFloatType, unsigned int>", typeof(hclVertexFloatInput.VertexFloatType) },
        { "hkEnum<hclTriangleSelectionInput::TriangleSelectionType, unsigned int>", typeof(hclTriangleSelectionInput.TriangleSelectionType) },
        { "hkEnum<hclEdgeSelectionInput::EdgeSelectionType, unsigned int>", typeof(hclEdgeSelectionInput.EdgeSelectionType) },
        { "hkEnum<hclSetupMesh::TriangleChannelType, unsigned int>", typeof(hclSetupMesh.TriangleChannelType) },
        { "hkEnum<hclSetupMesh::EdgeChannelType, unsigned int>", typeof(hclSetupMesh.EdgeChannelType) },
        { "hkEnum<hclSetupMesh::VertexChannelType, unsigned int>", typeof(hclSetupMesh.VertexChannelType) },
        { "hkEnum<hclVertexGatherSetupObject::Direction, unsigned int>", typeof(hclVertexGatherSetupObject.Direction) },
        { "hkEnum<hclMeshMeshDeformSetupObject::TriangleWeightMode, unsigned int>", typeof(hclMeshMeshDeformSetupObject.TriangleWeightMode) },
        { "hkEnum<hclSimClothBufferSetupObject::Type, unsigned int>", typeof(hclSimClothBufferSetupObject.Type) },
        { "hkEnum<hclVertexSelectionInput::VertexSelectionType, hkUint32>", typeof(hclVertexSelectionInput.VertexSelectionType) },
        { "hkEnum<hclVertexFloatInput::VertexFloatType, hkUint32>", typeof(hclVertexFloatInput.VertexFloatType) },
        { "hkEnum<hclTriangleSelectionInput::TriangleSelectionType, hkUint32>", typeof(hclTriangleSelectionInput.TriangleSelectionType) },
        { "hkEnum<hclEdgeSelectionInput::EdgeSelectionType, hkUint32>", typeof(hclEdgeSelectionInput.EdgeSelectionType) },
        { "hkEnum<hclSetupMesh::TriangleChannelType, hkUint32>", typeof(hclSetupMesh.TriangleChannelType) },
        { "hkEnum<hclSetupMesh::EdgeChannelType, hkUint32>", typeof(hclSetupMesh.EdgeChannelType) },
        { "hkEnum<hclSetupMesh::VertexChannelType, hkUint32>", typeof(hclSetupMesh.VertexChannelType) },
        { "hkEnum<hclVertexGatherSetupObject::Direction, hkUint32>", typeof(hclVertexGatherSetupObject.Direction) },
        { "hkEnum<hclMeshMeshDeformSetupObject::TriangleWeightMode, hkUint32>", typeof(hclMeshMeshDeformSetupObject.TriangleWeightMode) },
        { "hkEnum<hclSimClothBufferSetupObject::Type, hkUint32>", typeof(hclSimClothBufferSetupObject.Type) },
        { "hclVertexSelectionInput::VertexSelectionType", typeof(hclVertexSelectionInput.VertexSelectionType) },
        { "hclVertexFloatInput::VertexFloatType", typeof(hclVertexFloatInput.VertexFloatType) },
        { "hclTriangleSelectionInput::TriangleSelectionType", typeof(hclTriangleSelectionInput.TriangleSelectionType) },
        { "hclEdgeSelectionInput::EdgeSelectionType", typeof(hclEdgeSelectionInput.EdgeSelectionType) },
        { "hclSetupMesh::EdgeChannelType", typeof(hclSetupMesh.EdgeChannelType) },
        { "hclSetupMesh::TriangleChannelType", typeof(hclSetupMesh.TriangleChannelType) },
        { "hclSetupMesh::VertexChannelType", typeof(hclSetupMesh.VertexChannelType) },
        { "hclVertexGatherSetupObject::Direction", typeof(hclVertexGatherSetupObject.Direction) },
        { "hclMeshMeshDeformSetupObject::TriangleWeightMode", typeof(hclMeshMeshDeformSetupObject.TriangleWeightMode) },
        { "hclSimClothBufferSetupObject::Type", typeof(hclSimClothBufferSetupObject.Type) },
        { "hkEnum<hclStateTransition::TransitionType, unsigned int>", typeof(hclStateTransition.TransitionType) },
        { "hkEnum<hclObjectSpaceMeshMeshDeformOperator::ScaleNormalBehaviour, unsigned int>", typeof(hclObjectSpaceMeshMeshDeformOperator.ScaleNormalBehaviour) },
        { "hkEnum<hclMeshMeshDeformOperator::ScaleNormalBehaviour, unsigned int>", typeof(hclMeshMeshDeformOperator.ScaleNormalBehaviour) },
        { "hkEnum<hclBoneSpaceMeshMeshDeformOperator::ScaleNormalBehaviour, unsigned int>", typeof(hclBoneSpaceMeshMeshDeformOperator.ScaleNormalBehaviour) },
        { "hkEnum<hclLocalRangeConstraintSet::ShapeType, unsigned int>", typeof(hclLocalRangeConstraintSet.ShapeType) },
        { "hkEnum<hclClothData::Platform, unsigned int>", typeof(hclClothData.Platform) },
        { "hkEnum<hclBufferLayout::SlotFlags, unsigned char>", typeof(hclBufferLayout.SlotFlags) },
        { "hkEnum<hclRuntimeConversionInfo::VectorConversion, unsigned char>", typeof(hclRuntimeConversionInfo.VectorConversion) },
        { "hkEnum<hclBufferLayout::TriangleFormat, unsigned char>", typeof(hclBufferLayout.TriangleFormat) },
        { "hkEnum<hclStateTransition::TransitionType, hkUint32>", typeof(hclStateTransition.TransitionType) },
        { "hkEnum<hclObjectSpaceMeshMeshDeformOperator::ScaleNormalBehaviour, hkUint32>", typeof(hclObjectSpaceMeshMeshDeformOperator.ScaleNormalBehaviour) },
        { "hkEnum<hclMeshMeshDeformOperator::ScaleNormalBehaviour, hkUint32>", typeof(hclMeshMeshDeformOperator.ScaleNormalBehaviour) },
        { "hkEnum<hclBoneSpaceMeshMeshDeformOperator::ScaleNormalBehaviour, hkUint32>", typeof(hclBoneSpaceMeshMeshDeformOperator.ScaleNormalBehaviour) },
        { "hkEnum<hclLocalRangeConstraintSet::ShapeType, hkUint32>", typeof(hclLocalRangeConstraintSet.ShapeType) },
        { "hkEnum<hclClothData::Platform, hkUint32>", typeof(hclClothData.Platform) },
        { "hkEnum<hclBufferLayout::SlotFlags, hkUint8>", typeof(hclBufferLayout.SlotFlags) },
        { "hkEnum<hclRuntimeConversionInfo::VectorConversion, hkUint8>", typeof(hclRuntimeConversionInfo.VectorConversion) },
        { "hkEnum<hclBufferLayout::TriangleFormat, hkUint8>", typeof(hclBufferLayout.TriangleFormat) },
        { "hclStateTransition::TransitionType", typeof(hclStateTransition.TransitionType) },
        { "hclConstraintStiffnessDispatcher::Type", typeof(hclConstraintStiffnessDispatcher.Type) },
        { "hclOperatorType", typeof(hclOperatorType) },
        { "hclObjectSpaceMeshMeshDeformOperator::ScaleNormalBehaviour", typeof(hclObjectSpaceMeshMeshDeformOperator.ScaleNormalBehaviour) },
        { "hclMeshMeshDeformOperator::ScaleNormalBehaviour", typeof(hclMeshMeshDeformOperator.ScaleNormalBehaviour) },
        { "hclRuntimeConversionInfo::VectorConversion", typeof(hclRuntimeConversionInfo.VectorConversion) },
        { "hclBoneSpaceMeshMeshDeformOperator::ScaleNormalBehaviour", typeof(hclBoneSpaceMeshMeshDeformOperator.ScaleNormalBehaviour) },
        { "hclBlendSomeVerticesOperator::BlendWeightType", typeof(hclBlendSomeVerticesOperator.BlendWeightType) },
        { "hclConstraintSetType", typeof(hclConstraintSetType) },
        { "hclTransitionConstraintInstanceData::State", typeof(hclTransitionConstraintInstanceData.State) },
        { "hclLocalRangeConstraintSet::ShapeType", typeof(hclLocalRangeConstraintSet.ShapeType) },
        { "hclShapeType", typeof(hclShapeType) },
        { "hclClothData::Platform", typeof(hclClothData.Platform) },
        { "hclBufferLayout::TriangleFormat", typeof(hclBufferLayout.TriangleFormat) },
        { "hclBufferLayout::SlotFlags", typeof(hclBufferLayout.SlotFlags) },
        { "hclBufferUsage::Component", typeof(hclBufferUsage.Component) },
        { "hkEnum<hkbWorldEnums::SimulationState, unsigned char>", typeof(hkbWorldEnums.SimulationState) },
        { "hkEnum<hkbToolNodeType::NodeType, unsigned short>", typeof(hkbToolNodeType.NodeType) },
        { "hkEnum<hkbCharacterInfo::Event, unsigned char>", typeof(hkbCharacterInfo.Event) },
        { "hkEnum<hkbVariableInfo::VariableType, unsigned char>", typeof(hkbVariableInfo.VariableType) },
        { "hkEnum<hkbCharacterControlCommand::CharacterControlCommand, unsigned char>", typeof(hkbCharacterControlCommand.CharacterControlCommand) },
        { "hkEnum<hkbSimulationControlCommand::SimulationControlCommand, unsigned char>", typeof(hkbSimulationControlCommand.SimulationControlCommand) },
        { "hkEnum<hkbAssetBundle::BundleType, signed char>", typeof(hkbAssetBundle.BundleType) },
        { "hkEnum<hkbRigidBodySetup::Type, signed char>", typeof(hkbRigidBodySetup.Type) },
        { "hkEnum<hkbShapeSetup::Type, signed char>", typeof(hkbShapeSetup.Type) },
        { "hkEnum<hkbRagdollControllerSetup::Type, signed char>", typeof(hkbRagdollControllerSetup.Type) },
        { "hkEnum<hkbConstraintSetup::Type, signed char>", typeof(hkbConstraintSetup.Type) },
        { "hkEnum<hkbParticleSystemEventPayload::SystemType, unsigned char>", typeof(hkbParticleSystemEventPayload.SystemType) },
        { "hkEnum<hkbAlignBoneModifier::AlignTargetMode, signed char>", typeof(hkbAlignBoneModifier.AlignTargetMode) },
        { "hkEnum<hkbAlignBoneModifier::AlignModeABAM, signed char>", typeof(hkbAlignBoneModifier.AlignModeABAM) },
        { "hkFlags<hkbCustomTestGeneratorComplexTypes::CustomFlag, unsigned int>", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkFlags<hkbCustomTestGeneratorComplexTypes::CustomFlag, unsigned short>", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkFlags<hkbCustomTestGeneratorComplexTypes::CustomFlag, unsigned char>", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkFlags<hkbCustomTestGeneratorComplexTypes::CustomFlag, int>", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkFlags<hkbCustomTestGeneratorComplexTypes::CustomFlag, short>", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkFlags<hkbCustomTestGeneratorComplexTypes::CustomFlag, signed char>", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkEnum<hkbCustomTestGeneratorComplexTypes::CustomEnum, unsigned int>", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkEnum<hkbCustomTestGeneratorComplexTypes::CustomEnum, unsigned short>", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkEnum<hkbCustomTestGeneratorComplexTypes::CustomEnum, unsigned char>", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkEnum<hkbCustomTestGeneratorComplexTypes::CustomEnum, int>", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkEnum<hkbCustomTestGeneratorComplexTypes::CustomEnum, short>", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkEnum<hkbCustomTestGeneratorComplexTypes::CustomEnum, signed char>", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkEnum<hkbBodyIkControlPriority::Enum, signed char>", typeof(hkbBodyIkControlPriority.Enum) },
        { "hkFlags<hkbBodyIkControlBits::Enum, short>", typeof(hkbBodyIkControlBits.Enum) },
        { "hkEnum<hkbWorldEnums::SimulationState, hkUint8>", typeof(hkbWorldEnums.SimulationState) },
        { "hkEnum<hkbToolNodeType::NodeType, hkUint16>", typeof(hkbToolNodeType.NodeType) },
        { "hkEnum<hkbCharacterInfo::Event, hkUint8>", typeof(hkbCharacterInfo.Event) },
        { "hkEnum<hkbVariableInfo::VariableType, hkUint8>", typeof(hkbVariableInfo.VariableType) },
        { "hkEnum<hkbCharacterControlCommand::CharacterControlCommand, hkUint8>", typeof(hkbCharacterControlCommand.CharacterControlCommand) },
        { "hkEnum<hkbSimulationControlCommand::SimulationControlCommand, hkUint8>", typeof(hkbSimulationControlCommand.SimulationControlCommand) },
        { "hkEnum<hkbAssetBundle::BundleType, hkInt8>", typeof(hkbAssetBundle.BundleType) },
        { "hkEnum<hkbRigidBodySetup::Type, hkInt8>", typeof(hkbRigidBodySetup.Type) },
        { "hkEnum<hkbShapeSetup::Type, hkInt8>", typeof(hkbShapeSetup.Type) },
        { "hkEnum<hkbRagdollControllerSetup::Type, hkInt8>", typeof(hkbRagdollControllerSetup.Type) },
        { "hkEnum<hkbConstraintSetup::Type, hkInt8>", typeof(hkbConstraintSetup.Type) },
        { "hkEnum<hkbParticleSystemEventPayload::SystemType, hkUint8>", typeof(hkbParticleSystemEventPayload.SystemType) },
        { "hkEnum<hkbAlignBoneModifier::AlignTargetMode, hkInt8>", typeof(hkbAlignBoneModifier.AlignTargetMode) },
        { "hkEnum<hkbAlignBoneModifier::AlignModeABAM, hkInt8>", typeof(hkbAlignBoneModifier.AlignModeABAM) },
        { "hkFlags<hkbCustomTestGeneratorComplexTypes::CustomFlag, hkUint32>", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkFlags<hkbCustomTestGeneratorComplexTypes::CustomFlag, hkUint16>", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkFlags<hkbCustomTestGeneratorComplexTypes::CustomFlag, hkUint8>", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkFlags<hkbCustomTestGeneratorComplexTypes::CustomFlag, hkInt32>", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkFlags<hkbCustomTestGeneratorComplexTypes::CustomFlag, hkInt16>", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkFlags<hkbCustomTestGeneratorComplexTypes::CustomFlag, hkInt8>", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkEnum<hkbCustomTestGeneratorComplexTypes::CustomEnum, hkUint32>", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkEnum<hkbCustomTestGeneratorComplexTypes::CustomEnum, hkUint16>", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkEnum<hkbCustomTestGeneratorComplexTypes::CustomEnum, hkUint8>", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkEnum<hkbCustomTestGeneratorComplexTypes::CustomEnum, hkInt32>", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkEnum<hkbCustomTestGeneratorComplexTypes::CustomEnum, hkInt16>", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkEnum<hkbCustomTestGeneratorComplexTypes::CustomEnum, hkInt8>", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkEnum<hkbBodyIkControlPriority::Enum, hkInt8>", typeof(hkbBodyIkControlPriority.Enum) },
        { "hkFlags<hkbBodyIkControlBits::Enum, hkInt16>", typeof(hkbBodyIkControlBits.Enum) },
        { "hkbCharacterInfo::Event", typeof(hkbCharacterInfo.Event) },
        { "hkbToolNodeType::NodeType", typeof(hkbToolNodeType.NodeType) },
        { "hkbCharacterControlCommand::CharacterControlCommand", typeof(hkbCharacterControlCommand.CharacterControlCommand) },
        { "hkbSimulationControlCommand::SimulationControlCommand", typeof(hkbSimulationControlCommand.SimulationControlCommand) },
        { "hkbAssetBundle::BundleType", typeof(hkbAssetBundle.BundleType) },
        { "hkbRigidBodySetup::Type", typeof(hkbRigidBodySetup.Type) },
        { "hkbShapeSetup::Type", typeof(hkbShapeSetup.Type) },
        { "hkbRagdollControllerSetup::Type", typeof(hkbRagdollControllerSetup.Type) },
        { "hkbConstraintSetup::Type", typeof(hkbConstraintSetup.Type) },
        { "hkbParticleSystemEventPayload::SystemType", typeof(hkbParticleSystemEventPayload.SystemType) },
        { "hkbAlignBoneModifier::AlignTargetMode", typeof(hkbAlignBoneModifier.AlignTargetMode) },
        { "hkbAlignBoneModifier::AlignModeABAM", typeof(hkbAlignBoneModifier.AlignModeABAM) },
        { "hkbCustomTestGeneratorComplexTypes::CustomFlag", typeof(hkbCustomTestGeneratorComplexTypes.CustomFlag) },
        { "hkbCustomTestGeneratorComplexTypes::CustomEnum", typeof(hkbCustomTestGeneratorComplexTypes.CustomEnum) },
        { "hkbBodyIkControlPriority::Enum", typeof(hkbBodyIkControlPriority.Enum) },
        { "hkbBodyIkControlBits::Enum", typeof(hkbBodyIkControlBits.Enum) },
        { "hkEnum<hkbVariableInfo::VariableType, signed char>", typeof(hkbVariableInfo.VariableType) },
        { "hkFlags<hkbVariableBindingSet::Binding::InternalBindingFlags, signed char>", typeof(hkbVariableBindingSet.Binding.InternalBindingFlags) },
        { "hkEnum<hkbVariableBindingSet::Binding::BindingType, signed char>", typeof(hkbVariableBindingSet.Binding.BindingType) },
        { "hkEnum<hkbEventDrivenBlendingObject::InternalState::FadingState, signed char>", typeof(hkbEventDrivenBlendingObject.InternalState.FadingState) },
        { "hkEnum<hkbCompiledExpressionSet::Token::Operator, signed char>", typeof(hkbCompiledExpressionSet.Token.Operator) },
        { "hkEnum<hkbCompiledExpressionSet::Token::TokenType, signed char>", typeof(hkbCompiledExpressionSet.Token.TokenType) },
        { "hkEnum<hkbGeneratorTransitionEffect::Stage, signed char>", typeof(hkbGeneratorTransitionEffect.Stage) },
        { "hkEnum<hkbGeneratorTransitionEffect::ToGeneratorState, signed char>", typeof(hkbGeneratorTransitionEffect.ToGeneratorState) },
        { "hkEnum<hkbTransitionEffect::SelfTransitionMode, signed char>", typeof(hkbTransitionEffect.SelfTransitionMode) },
        { "hkEnum<hkbBlendingTransitionEffect::EndMode, signed char>", typeof(hkbBlendingTransitionEffect.EndMode) },
        { "hkFlags<hkbBlendingTransitionEffect::FlagBits, unsigned short>", typeof(hkbBlendingTransitionEffect.FlagBits) },
        { "hkFlags<hkbStateMachine::TransitionInfo::TransitionFlags, short>", typeof(hkbStateMachine.TransitionInfo.TransitionFlags) },
        { "hkEnum<hkbStateMachine::StateMachineSelfTransitionMode, signed char>", typeof(hkbStateMachine.StateMachineSelfTransitionMode) },
        { "hkEnum<hkbStateMachine::StartStateMode, signed char>", typeof(hkbStateMachine.StartStateMode) },
        { "hkEnum<hkbTransitionEffect::EventMode, signed char>", typeof(hkbTransitionEffect.EventMode) },
        { "hkEnum<hkbNodeType, unsigned char>", typeof(hkbNodeType) },
        { "hkEnum<hkbNode::CloneState, signed char>", typeof(hkbNode.CloneState) },
        { "hkEnum<hkbTwistModifier::RotationAxisCoordinates, signed char>", typeof(hkbTwistModifier.RotationAxisCoordinates) },
        { "hkEnum<hkbTwistModifier::SetAngleMethod, signed char>", typeof(hkbTwistModifier.SetAngleMethod) },
        { "hkEnum<hkbSenseHandleModifier::SensingMode, signed char>", typeof(hkbSenseHandleModifier.SensingMode) },
        { "hkEnum<hkbWorldFromModelModeData::WorldFromModelMode, signed char>", typeof(hkbWorldFromModelModeData.WorldFromModelMode) },
        { "hkEnum<hkbJigglerModifier::JiggleCoordinates, signed char>", typeof(hkbJigglerModifier.JiggleCoordinates) },
        { "hkEnum<hkbHandIkControlData::HandleChangeMode, signed char>", typeof(hkbHandIkControlData.HandleChangeMode) },
        { "hkEnum<hkbFootIkModifier::AlignMode, signed char>", typeof(hkbFootIkModifier.AlignMode) },
        { "hkEnum<hkbEventRangeData::EventRangeMode, signed char>", typeof(hkbEventRangeData.EventRangeMode) },
        { "hkEnum<hkbEvaluateHandleModifier::HandleChangeMode, signed char>", typeof(hkbEvaluateHandleModifier.HandleChangeMode) },
        { "hkEnum<hkbExpressionData::ExpressionEventMode, signed char>", typeof(hkbExpressionData.ExpressionEventMode) },
        { "hkEnum<hkbCharacterControllerModifier::MotionMode, signed char>", typeof(hkbCharacterControllerModifier.MotionMode) },
        { "hkEnum<hkbCharacterControllerModifier::InitialVelocityCoordinates, signed char>", typeof(hkbCharacterControllerModifier.InitialVelocityCoordinates) },
        { "hkFlags<hkbBodyIkControlBits::Enum, unsigned short>", typeof(hkbBodyIkControlBits.Enum) },
        { "hkEnum<hkbBodyIkControlsModifier::PosePredictionMode, signed char>", typeof(hkbBodyIkControlsModifier.PosePredictionMode) },
        { "hkEnum<hkbRigidBodySetup::Type, unsigned char>", typeof(hkbRigidBodySetup.Type) },
        { "hkEnum<hkbPoseMatchingGenerator::Mode, signed char>", typeof(hkbPoseMatchingGenerator.Mode) },
        { "hkEnum<hkbParametricMotionGenerator::MotionSpaceType, signed char>", typeof(hkbParametricMotionGenerator.MotionSpaceType) },
        { "hkFlags<hkbDockingGenerator::DockingFlagBits, unsigned short>", typeof(hkbDockingGenerator.DockingFlagBits) },
        { "hkEnum<hkbDockingGenerator::BlendType, signed char>", typeof(hkbDockingGenerator.BlendType) },
        { "hkEnum<hkbClipGenerator::PlaybackMode, signed char>", typeof(hkbClipGenerator.PlaybackMode) },
        { "hkFlags<hkbLayerGenerator::LayerFlagBits, unsigned short>", typeof(hkbLayerGenerator.LayerFlagBits) },
        { "hkFlags<hkbEventInfo::Flags, unsigned int>", typeof(hkbEventInfo.Flags) },
        { "hkEnum<hkbBlendCurveUtils::BlendCurve, signed char>", typeof(hkbBlendCurveUtils.BlendCurve) },
        { "hkEnum<hkbBehaviorGraph::VariableMode, signed char>", typeof(hkbBehaviorGraph.VariableMode) },
        { "hkFlags<hkbRoleAttribute::RoleFlags, short>", typeof(hkbRoleAttribute.RoleFlags) },
        { "hkEnum<hkbRoleAttribute::Role, short>", typeof(hkbRoleAttribute.Role) },
        { "hkEnum<hkbAttachmentSetup::AttachmentType, signed char>", typeof(hkbAttachmentSetup.AttachmentType) },
        { "hkEnum<hkbVariableInfo::VariableType, hkInt8>", typeof(hkbVariableInfo.VariableType) },
        { "hkFlags<hkbVariableBindingSet::Binding::InternalBindingFlags, hkInt8>", typeof(hkbVariableBindingSet.Binding.InternalBindingFlags) },
        { "hkEnum<hkbVariableBindingSet::Binding::BindingType, hkInt8>", typeof(hkbVariableBindingSet.Binding.BindingType) },
        { "hkEnum<hkbEventDrivenBlendingObject::InternalState::FadingState, hkInt8>", typeof(hkbEventDrivenBlendingObject.InternalState.FadingState) },
        { "hkEnum<hkbCompiledExpressionSet::Token::Operator, hkInt8>", typeof(hkbCompiledExpressionSet.Token.Operator) },
        { "hkEnum<hkbCompiledExpressionSet::Token::TokenType, hkInt8>", typeof(hkbCompiledExpressionSet.Token.TokenType) },
        { "hkEnum<hkbGeneratorTransitionEffect::Stage, hkInt8>", typeof(hkbGeneratorTransitionEffect.Stage) },
        { "hkEnum<hkbGeneratorTransitionEffect::ToGeneratorState, hkInt8>", typeof(hkbGeneratorTransitionEffect.ToGeneratorState) },
        { "hkEnum<hkbTransitionEffect::SelfTransitionMode, hkInt8>", typeof(hkbTransitionEffect.SelfTransitionMode) },
        { "hkEnum<hkbBlendingTransitionEffect::EndMode, hkInt8>", typeof(hkbBlendingTransitionEffect.EndMode) },
        { "hkFlags<hkbBlendingTransitionEffect::FlagBits, hkUint16>", typeof(hkbBlendingTransitionEffect.FlagBits) },
        { "hkFlags<hkbStateMachine::TransitionInfo::TransitionFlags, hkInt16>", typeof(hkbStateMachine.TransitionInfo.TransitionFlags) },
        { "hkEnum<hkbStateMachine::StateMachineSelfTransitionMode, hkInt8>", typeof(hkbStateMachine.StateMachineSelfTransitionMode) },
        { "hkEnum<hkbStateMachine::StartStateMode, hkInt8>", typeof(hkbStateMachine.StartStateMode) },
        { "hkEnum<hkbTransitionEffect::EventMode, hkInt8>", typeof(hkbTransitionEffect.EventMode) },
        { "hkEnum<hkbNodeType, hkUint8>", typeof(hkbNodeType) },
        { "hkEnum<hkbNode::CloneState, hkInt8>", typeof(hkbNode.CloneState) },
        { "hkEnum<hkbTwistModifier::RotationAxisCoordinates, hkInt8>", typeof(hkbTwistModifier.RotationAxisCoordinates) },
        { "hkEnum<hkbTwistModifier::SetAngleMethod, hkInt8>", typeof(hkbTwistModifier.SetAngleMethod) },
        { "hkEnum<hkbSenseHandleModifier::SensingMode, hkInt8>", typeof(hkbSenseHandleModifier.SensingMode) },
        { "hkEnum<hkbWorldFromModelModeData::WorldFromModelMode, hkInt8>", typeof(hkbWorldFromModelModeData.WorldFromModelMode) },
        { "hkEnum<hkbJigglerModifier::JiggleCoordinates, hkInt8>", typeof(hkbJigglerModifier.JiggleCoordinates) },
        { "hkEnum<hkbHandIkControlData::HandleChangeMode, hkInt8>", typeof(hkbHandIkControlData.HandleChangeMode) },
        { "hkEnum<hkbFootIkModifier::AlignMode, hkInt8>", typeof(hkbFootIkModifier.AlignMode) },
        { "hkEnum<hkbEventRangeData::EventRangeMode, hkInt8>", typeof(hkbEventRangeData.EventRangeMode) },
        { "hkEnum<hkbEvaluateHandleModifier::HandleChangeMode, hkInt8>", typeof(hkbEvaluateHandleModifier.HandleChangeMode) },
        { "hkEnum<hkbExpressionData::ExpressionEventMode, hkInt8>", typeof(hkbExpressionData.ExpressionEventMode) },
        { "hkEnum<hkbCharacterControllerModifier::MotionMode, hkInt8>", typeof(hkbCharacterControllerModifier.MotionMode) },
        { "hkEnum<hkbCharacterControllerModifier::InitialVelocityCoordinates, hkInt8>", typeof(hkbCharacterControllerModifier.InitialVelocityCoordinates) },
        { "hkFlags<hkbBodyIkControlBits::Enum, hkUint16>", typeof(hkbBodyIkControlBits.Enum) },
        { "hkEnum<hkbBodyIkControlsModifier::PosePredictionMode, hkInt8>", typeof(hkbBodyIkControlsModifier.PosePredictionMode) },
        { "hkEnum<hkbRigidBodySetup::Type, hkUint8>", typeof(hkbRigidBodySetup.Type) },
        { "hkEnum<hkbPoseMatchingGenerator::Mode, hkInt8>", typeof(hkbPoseMatchingGenerator.Mode) },
        { "hkEnum<hkbParametricMotionGenerator::MotionSpaceType, hkInt8>", typeof(hkbParametricMotionGenerator.MotionSpaceType) },
        { "hkFlags<hkbDockingGenerator::DockingFlagBits, hkUint16>", typeof(hkbDockingGenerator.DockingFlagBits) },
        { "hkEnum<hkbDockingGenerator::BlendType, hkInt8>", typeof(hkbDockingGenerator.BlendType) },
        { "hkEnum<hkbClipGenerator::PlaybackMode, hkInt8>", typeof(hkbClipGenerator.PlaybackMode) },
        { "hkFlags<hkbLayerGenerator::LayerFlagBits, hkUint16>", typeof(hkbLayerGenerator.LayerFlagBits) },
        { "hkFlags<hkbEventInfo::Flags, hkUint32>", typeof(hkbEventInfo.Flags) },
        { "hkEnum<hkbBlendCurveUtils::BlendCurve, hkInt8>", typeof(hkbBlendCurveUtils.BlendCurve) },
        { "hkEnum<hkbBehaviorGraph::VariableMode, hkInt8>", typeof(hkbBehaviorGraph.VariableMode) },
        { "hkFlags<hkbRoleAttribute::RoleFlags, hkInt16>", typeof(hkbRoleAttribute.RoleFlags) },
        { "hkEnum<hkbRoleAttribute::Role, hkInt16>", typeof(hkbRoleAttribute.Role) },
        { "hkEnum<hkbAttachmentSetup::AttachmentType, hkInt8>", typeof(hkbAttachmentSetup.AttachmentType) },
        { "hkbWorldEnums::AccumulateMotionState", typeof(hkbWorldEnums.AccumulateMotionState) },
        { "hkbWorldEnums::SimulationState", typeof(hkbWorldEnums.SimulationState) },
        { "hkbVariableInfo::VariableType", typeof(hkbVariableInfo.VariableType) },
        { "hkbVariableBindingSet::Binding::InternalBindingFlags", typeof(hkbVariableBindingSet.Binding.InternalBindingFlags) },
        { "hkbVariableBindingSet::Binding::BindingType", typeof(hkbVariableBindingSet.Binding.BindingType) },
        { "hkbEventDrivenBlendingObject::InternalState::FadingState", typeof(hkbEventDrivenBlendingObject.InternalState.FadingState) },
        { "hkbCompiledExpressionSet::Token::Operator", typeof(hkbCompiledExpressionSet.Token.Operator) },
        { "hkbCompiledExpressionSet::Token::TokenType", typeof(hkbCompiledExpressionSet.Token.TokenType) },
        { "hkbBlendCurveUtils::BlendCurve", typeof(hkbBlendCurveUtils.BlendCurve) },
        { "hkbTransitionEffect::EventMode", typeof(hkbTransitionEffect.EventMode) },
        { "hkbTransitionEffect::SelfTransitionMode", typeof(hkbTransitionEffect.SelfTransitionMode) },
        { "hkbGeneratorTransitionEffect::Stage", typeof(hkbGeneratorTransitionEffect.Stage) },
        { "hkbGeneratorTransitionEffect::ToGeneratorState", typeof(hkbGeneratorTransitionEffect.ToGeneratorState) },
        { "hkbBlendingTransitionEffect::EndMode", typeof(hkbBlendingTransitionEffect.EndMode) },
        { "hkbBlendingTransitionEffect::FlagBits", typeof(hkbBlendingTransitionEffect.FlagBits) },
        { "hkbStateMachine::StateMachineSelfTransitionMode", typeof(hkbStateMachine.StateMachineSelfTransitionMode) },
        { "hkbStateMachine::StartStateMode", typeof(hkbStateMachine.StartStateMode) },
        { "hkbStateMachine::TransitionInfo::TransitionFlags", typeof(hkbStateMachine.TransitionInfo.TransitionFlags) },
        { "hkbNode::CloneState", typeof(hkbNode.CloneState) },
        { "hkbNodeType", typeof(hkbNodeType) },
        { "hkbTwistModifier::RotationAxisCoordinates", typeof(hkbTwistModifier.RotationAxisCoordinates) },
        { "hkbTwistModifier::SetAngleMethod", typeof(hkbTwistModifier.SetAngleMethod) },
        { "hkbSenseHandleModifier::SensingMode", typeof(hkbSenseHandleModifier.SensingMode) },
        { "hkbWorldFromModelModeData::WorldFromModelMode", typeof(hkbWorldFromModelModeData.WorldFromModelMode) },
        { "hkbJigglerModifier::JiggleCoordinates", typeof(hkbJigglerModifier.JiggleCoordinates) },
        { "hkbHandIkControlData::HandleChangeMode", typeof(hkbHandIkControlData.HandleChangeMode) },
        { "hkbFootIkModifier::AlignMode", typeof(hkbFootIkModifier.AlignMode) },
        { "hkbEventRangeData::EventRangeMode", typeof(hkbEventRangeData.EventRangeMode) },
        { "hkbEvaluateHandleModifier::HandleChangeMode", typeof(hkbEvaluateHandleModifier.HandleChangeMode) },
        { "hkbExpressionData::ExpressionEventMode", typeof(hkbExpressionData.ExpressionEventMode) },
        { "hkbCharacterControllerModifier::MotionMode", typeof(hkbCharacterControllerModifier.MotionMode) },
        { "hkbCharacterControllerModifier::InitialVelocityCoordinates", typeof(hkbCharacterControllerModifier.InitialVelocityCoordinates) },
        { "hkbBodyIkControlsModifier::PosePredictionMode", typeof(hkbBodyIkControlsModifier.PosePredictionMode) },
        { "hkbPoseMatchingGenerator::Mode", typeof(hkbPoseMatchingGenerator.Mode) },
        { "hkbParametricMotionGenerator::MotionSpaceType", typeof(hkbParametricMotionGenerator.MotionSpaceType) },
        { "hkbDockingGenerator::DockingFlagBits", typeof(hkbDockingGenerator.DockingFlagBits) },
        { "hkbDockingGenerator::BlendType", typeof(hkbDockingGenerator.BlendType) },
        { "hkbClipGenerator::ClipFlags", typeof(hkbClipGenerator.ClipFlags) },
        { "hkbClipGenerator::PlaybackMode", typeof(hkbClipGenerator.PlaybackMode) },
        { "hkbBlenderGenerator::BlenderFlags", typeof(hkbBlenderGenerator.BlenderFlags) },
        { "hkbLayerGenerator::LayerFlagBits", typeof(hkbLayerGenerator.LayerFlagBits) },
        { "hkbEventInfo::Flags", typeof(hkbEventInfo.Flags) },
        { "hkbBehaviorGraph::NodeIdRanges", typeof(hkbBehaviorGraph.NodeIdRanges) },
        { "hkbBehaviorGraph::VariableMode", typeof(hkbBehaviorGraph.VariableMode) },
        { "hkbRoleAttribute::RoleFlags", typeof(hkbRoleAttribute.RoleFlags) },
        { "hkbRoleAttribute::Role", typeof(hkbRoleAttribute.Role) },
        { "hkbAttachmentSetup::AttachmentType", typeof(hkbAttachmentSetup.AttachmentType) },
        { "hkaiIndex<int>", typeof(int) },
        { "hkaiPackedKey_<hkaiIndex<int>, hkaiIndex<int>>", typeof(uint) },
        { "hkEnum<hkaiWorld::CharacterCallbackType, unsigned char>", typeof(hkaiWorld.CharacterCallbackType) },
        { "hkEnum<hkaiSplitGenerationUtils::SplitMethod, unsigned char>", typeof(hkaiSplitGenerationUtils.SplitMethod) },
        { "hkEnum<hkaiSplitGenerationUtils::SplitAndGenerateOptions, unsigned char>", typeof(hkaiSplitGenerationUtils.SplitAndGenerateOptions) },
        { "hkEnum<hkaiOverlappingTriangles::WalkableTriangleSettings, unsigned char>", typeof(hkaiOverlappingTriangles.WalkableTriangleSettings) },
        { "hkFlags<hkaiLineOfSightUtil::UserEdgeFlagBits, unsigned char>", typeof(hkaiLineOfSightUtil.UserEdgeFlagBits) },
        { "hkEnum<hkaiLineOfSightUtil::InputBase::QueryMode, unsigned char>", typeof(hkaiLineOfSightUtil.InputBase.QueryMode) },
        { "hkFlags<hkaiVolumeNavigator::PathQualityBits, unsigned char>", typeof(hkaiVolumeNavigator.PathQualityBits) },
        { "hkFlags<hkaiNavigator::PathQualityBits, unsigned char>", typeof(hkaiNavigator.PathQualityBits) },
        { "hkFlags<hkaiNavVolumePathSearchParameters::LineOfSightFlags, unsigned char>", typeof(hkaiNavVolumePathSearchParameters.LineOfSightFlags) },
        { "hkFlags<hkaiNavVolume::CellEdgeFlagBits, unsigned char>", typeof(hkaiNavVolume.CellEdgeFlagBits) },
        { "hkFlags<hkaiNavMeshPathSearchParameters::LineOfSightFlags, unsigned char>", typeof(hkaiNavMeshPathSearchParameters.LineOfSightFlags) },
        { "hkFlags<hkaiNavMeshPathSearchParameters::OutputPathFlags, unsigned char>", typeof(hkaiNavMeshPathSearchParameters.OutputPathFlags) },
        { "hkEnum<hkaiUserEdgeUtils::UserEdgeSetupSpace, unsigned char>", typeof(hkaiUserEdgeUtils.UserEdgeSetupSpace) },
        { "hkEnum<hkaiUserEdgeUtils::UserEdgeDirection, unsigned char>", typeof(hkaiUserEdgeUtils.UserEdgeDirection) },
        { "hkEnum<hkaiAnnotatedStreamingSet::Side, unsigned char>", typeof(hkaiAnnotatedStreamingSet.Side) },
        { "hkFlags<hkaiStreamingCollectionInstanceInfo::Flags, unsigned char>", typeof(hkaiStreamingCollectionInstanceInfo.Flags) },
        { "hkFlags<hkaiDirectedGraphExplicitCost::EdgeBits, unsigned short>", typeof(hkaiDirectedGraphExplicitCost.EdgeBits) },
        { "hkEnum<hkaiSilhouetteMerger::MergeType, unsigned char>", typeof(hkaiSilhouetteMerger.MergeType) },
        { "hkFlags<hkaiPointCloudSilhouetteGenerator::PointCloudFlagBits, unsigned char>", typeof(hkaiPointCloudSilhouetteGenerator.PointCloudFlagBits) },
        { "hkEnum<hkaiPointCloudSilhouetteGenerator::DetailLevel, unsigned char>", typeof(hkaiPointCloudSilhouetteGenerator.DetailLevel) },
        { "hkEnum<hkaiReferenceFrameAndExtrusion::UpVectorTransformMethod, unsigned char>", typeof(hkaiReferenceFrameAndExtrusion.UpVectorTransformMethod) },
        { "hkFlags<hkaiModifiedSections::SectionBits, unsigned char>", typeof(hkaiModifiedSections.SectionBits) },
        { "hkEnum<hkaiWorld::ClearanceResetMethod, unsigned char>", typeof(hkaiWorld.ClearanceResetMethod) },
        { "hkEnum<hkaiNavMeshCompactUtils::CompactingPhase, unsigned char>", typeof(hkaiNavMeshCompactUtils.CompactingPhase) },
        { "hkFlags<hkaiCarver::FlagBits, unsigned int>", typeof(hkaiCarver.FlagBits) },
        { "hkFlags<hkaiPath::PathPointBits, unsigned char>", typeof(hkaiPath.PathPointBits) },
        { "hkEnum<hkaiPath::ReferenceFrame, unsigned char>", typeof(hkaiPath.ReferenceFrame) },
        { "hkFlags<hkaiCharacter::AvoidanceEnabledMaskBits, unsigned char>", typeof(hkaiCharacter.AvoidanceEnabledMaskBits) },
        { "hkEnum<hkaiMovementProperties::KinematicConstraintType, unsigned char>", typeof(hkaiMovementProperties.KinematicConstraintType) },
        { "hkEnum<hkaiAvoidanceProperties::NearbyBoundariesSearchType, unsigned char>", typeof(hkaiAvoidanceProperties.NearbyBoundariesSearchType) },
        { "hkFlags<hkaiNavMesh::EdgeFlagBits, unsigned char>", typeof(hkaiNavMesh.EdgeFlagBits) },
        { "hkEnum<hkaiCharacter::State, unsigned char>", typeof(hkaiCharacter.State) },
        { "hkEnum<hkaiPathFollowingBehavior::PathType, unsigned char>", typeof(hkaiPathFollowingBehavior.PathType) },
        { "hkEnum<hkaiGatePathUtil::GateTypeValues, unsigned char>", typeof(hkaiGatePathUtil.GateTypeValues) },
        { "hkFlags<hkaiGatePath::BoundarySegmentBits, unsigned char>", typeof(hkaiGatePath.BoundarySegmentBits) },
        { "hkEnum<hkaiAstarOutputParameters::TerminationCause, unsigned char>", typeof(hkaiAstarOutputParameters.TerminationCause) },
        { "hkEnum<hkaiAstarOutputParameters::SearchStatus, unsigned char>", typeof(hkaiAstarOutputParameters.SearchStatus) },
        { "hkaiIndex<hkUint16>", typeof(ushort) },
        { "hkEnum<hkaiWorld::CharacterCallbackType, hkUint8>", typeof(hkaiWorld.CharacterCallbackType) },
        { "hkEnum<hkaiSplitGenerationUtils::SplitMethod, hkUint8>", typeof(hkaiSplitGenerationUtils.SplitMethod) },
        { "hkEnum<hkaiSplitGenerationUtils::SplitAndGenerateOptions, hkUint8>", typeof(hkaiSplitGenerationUtils.SplitAndGenerateOptions) },
        { "hkEnum<hkaiOverlappingTriangles::WalkableTriangleSettings, hkUint8>", typeof(hkaiOverlappingTriangles.WalkableTriangleSettings) },
        { "hkFlags<hkaiLineOfSightUtil::UserEdgeFlagBits, hkUint8>", typeof(hkaiLineOfSightUtil.UserEdgeFlagBits) },
        { "hkEnum<hkaiLineOfSightUtil::InputBase::QueryMode, hkUint8>", typeof(hkaiLineOfSightUtil.InputBase.QueryMode) },
        { "hkFlags<hkaiVolumeNavigator::PathQualityBits, hkUint8>", typeof(hkaiVolumeNavigator.PathQualityBits) },
        { "hkFlags<hkaiNavigator::PathQualityBits, hkUint8>", typeof(hkaiNavigator.PathQualityBits) },
        { "hkFlags<hkaiNavVolumePathSearchParameters::LineOfSightFlags, hkUint8>", typeof(hkaiNavVolumePathSearchParameters.LineOfSightFlags) },
        { "hkFlags<hkaiNavVolume::CellEdgeFlagBits, hkUint8>", typeof(hkaiNavVolume.CellEdgeFlagBits) },
        { "hkFlags<hkaiNavMeshPathSearchParameters::LineOfSightFlags, hkUint8>", typeof(hkaiNavMeshPathSearchParameters.LineOfSightFlags) },
        { "hkFlags<hkaiNavMeshPathSearchParameters::OutputPathFlags, hkUint8>", typeof(hkaiNavMeshPathSearchParameters.OutputPathFlags) },
        { "hkEnum<hkaiUserEdgeUtils::UserEdgeSetupSpace, hkUint8>", typeof(hkaiUserEdgeUtils.UserEdgeSetupSpace) },
        { "hkEnum<hkaiUserEdgeUtils::UserEdgeDirection, hkUint8>", typeof(hkaiUserEdgeUtils.UserEdgeDirection) },
        { "hkEnum<hkaiAnnotatedStreamingSet::Side, hkUint8>", typeof(hkaiAnnotatedStreamingSet.Side) },
        { "hkFlags<hkaiStreamingCollectionInstanceInfo::Flags, hkUint8>", typeof(hkaiStreamingCollectionInstanceInfo.Flags) },
        { "hkEnum<hkaiNavMeshClearanceCacheManager::DefaultCachingOption, int>", typeof(hkaiNavMeshClearanceCacheManager.DefaultCachingOption) },
        { "hkFlags<hkaiDirectedGraphExplicitCost::EdgeBits, hkUint16>", typeof(hkaiDirectedGraphExplicitCost.EdgeBits) },
        { "hkEnum<hkaiSilhouetteMerger::MergeType, hkUint8>", typeof(hkaiSilhouetteMerger.MergeType) },
        { "hkFlags<hkaiPointCloudSilhouetteGenerator::PointCloudFlagBits, hkUint8>", typeof(hkaiPointCloudSilhouetteGenerator.PointCloudFlagBits) },
        { "hkEnum<hkaiPointCloudSilhouetteGenerator::DetailLevel, hkUint8>", typeof(hkaiPointCloudSilhouetteGenerator.DetailLevel) },
        { "hkEnum<hkaiReferenceFrameAndExtrusion::UpVectorTransformMethod, hkUint8>", typeof(hkaiReferenceFrameAndExtrusion.UpVectorTransformMethod) },
        { "hkFlags<hkaiModifiedSections::SectionBits, hkUint8>", typeof(hkaiModifiedSections.SectionBits) },
        { "hkEnum<hkaiWorld::ClearanceResetMethod, hkUint8>", typeof(hkaiWorld.ClearanceResetMethod) },
        { "hkEnum<hkaiNavMeshCompactUtils::CompactingPhase, hkUint8>", typeof(hkaiNavMeshCompactUtils.CompactingPhase) },
        { "hkFlags<hkaiCarver::FlagBits, hkUint32>", typeof(hkaiCarver.FlagBits) },
        { "hkFlags<hkaiPath::PathPointBits, hkUint8>", typeof(hkaiPath.PathPointBits) },
        { "hkEnum<hkaiPath::ReferenceFrame, hkUint8>", typeof(hkaiPath.ReferenceFrame) },
        { "hkFlags<hkaiCharacter::AvoidanceEnabledMaskBits, hkUint8>", typeof(hkaiCharacter.AvoidanceEnabledMaskBits) },
        { "hkaiIndex<hkInt32>", typeof(int) },
        { "hkEnum<hkaiMovementProperties::KinematicConstraintType, hkUint8>", typeof(hkaiMovementProperties.KinematicConstraintType) },
        { "hkEnum<hkaiAvoidanceProperties::NearbyBoundariesSearchType, hkUint8>", typeof(hkaiAvoidanceProperties.NearbyBoundariesSearchType) },
        { "hkFlags<hkaiNavMesh::EdgeFlagBits, hkUint8>", typeof(hkaiNavMesh.EdgeFlagBits) },
        { "hkEnum<hkaiCharacterUtil::CallbackType, int>", typeof(hkaiCharacterUtil.CallbackType) },
        { "hkEnum<hkaiCharacter::State, hkUint8>", typeof(hkaiCharacter.State) },
        { "hkEnum<hkaiPathFollowingBehavior::PathType, hkUint8>", typeof(hkaiPathFollowingBehavior.PathType) },
        { "hkEnum<hkaiCharacter::State, int>", typeof(hkaiCharacter.State) },
        { "hkEnum<hkaiGatePathUtil::GateTypeValues, hkUint8>", typeof(hkaiGatePathUtil.GateTypeValues) },
        { "hkaiPackedKey_<hkaiIndex<hkInt32>, hkaiIndex<hkInt32>>", typeof(uint) },
        { "hkFlags<hkaiGatePath::BoundarySegmentBits, hkUint8>", typeof(hkaiGatePath.BoundarySegmentBits) },
        { "hkEnum<hkaiAstarOutputParameters::TerminationCause, hkUint8>", typeof(hkaiAstarOutputParameters.TerminationCause) },
        { "hkEnum<hkaiAstarOutputParameters::SearchStatus, hkUint8>", typeof(hkaiAstarOutputParameters.SearchStatus) },
        { "hkaiWorld::CharacterSystem", typeof(hkaiWorld.CharacterSystem) },
        { "hkaiWorld::CharacterCallbackType", typeof(hkaiWorld.CharacterCallbackType) },
        { "hkaiWorld::StepThreading", typeof(hkaiWorld.StepThreading) },
        { "hkaiWorld::ClearanceResetMethod", typeof(hkaiWorld.ClearanceResetMethod) },
        { "hkaiPathRequestBase::RequestState", typeof(hkaiPathRequestBase.RequestState) },
        { "hkaiSplitGenerationUtils::SplitMethod", typeof(hkaiSplitGenerationUtils.SplitMethod) },
        { "hkaiSplitGenerationUtils::SplitAndGenerateOptions", typeof(hkaiSplitGenerationUtils.SplitAndGenerateOptions) },
        { "hkaiOverlappingTriangles::WalkableTriangleSettings", typeof(hkaiOverlappingTriangles.WalkableTriangleSettings) },
        { "hkaiLineOfSightUtil::InputBase::QueryMode", typeof(hkaiLineOfSightUtil.InputBase.QueryMode) },
        { "hkaiLineOfSightUtil::UserEdgeFlagBits", typeof(hkaiLineOfSightUtil.UserEdgeFlagBits) },
        { "hkaiVolumeNavigatorStalenessChecker::State", typeof(hkaiVolumeNavigatorStalenessChecker.State) },
        { "hkaiVolumeNavigator::NavigationOutput::Result", typeof(hkaiVolumeNavigator.NavigationOutput.Result) },
        { "hkaiVolumeNavigator::PathQualityBits", typeof(hkaiVolumeNavigator.PathQualityBits) },
        { "hkaiNavigatorStalenessChecker::State", typeof(hkaiNavigatorStalenessChecker.State) },
        { "hkaiNavigator::NavigationOutput::Result", typeof(hkaiNavigator.NavigationOutput.Result) },
        { "hkaiNavigator::PathQualityBits", typeof(hkaiNavigator.PathQualityBits) },
        { "hkaiNavVolumePathSearchParameters::LineOfSightFlags", typeof(hkaiNavVolumePathSearchParameters.LineOfSightFlags) },
        { "hkaiNavVolume::CellEdgeFlagBits", typeof(hkaiNavVolume.CellEdgeFlagBits) },
        { "hkaiNavMeshPathSearchParameters::LineOfSightFlags", typeof(hkaiNavMeshPathSearchParameters.LineOfSightFlags) },
        { "hkaiNavMeshPathSearchParameters::OutputPathFlags", typeof(hkaiNavMeshPathSearchParameters.OutputPathFlags) },
        { "hkaiNavMeshEdgePairInfo::QueryType", typeof(hkaiNavMeshEdgePairInfo.QueryType) },
        { "hkaiNavMesh::EdgeFlagBits", typeof(hkaiNavMesh.EdgeFlagBits) },
        { "hkaiUserEdgeUtils::UserEdgeSetupSpace", typeof(hkaiUserEdgeUtils.UserEdgeSetupSpace) },
        { "hkaiUserEdgeUtils::UserEdgeDirection", typeof(hkaiUserEdgeUtils.UserEdgeDirection) },
        { "hkaiAnnotatedStreamingSet::Side", typeof(hkaiAnnotatedStreamingSet.Side) },
        { "hkaiStreamingCollectionInstanceInfo::Flags", typeof(hkaiStreamingCollectionInstanceInfo.Flags) },
        { "hkaiNavMeshClearanceCacheManager::DefaultCachingOption", typeof(hkaiNavMeshClearanceCacheManager.DefaultCachingOption) },
        { "hkaiNavMeshClearanceCacheManager::CachingOption", typeof(hkaiNavMeshClearanceCacheManager.CachingOption) },
        { "hkaiDirectedGraphExplicitCost::EdgeBits", typeof(hkaiDirectedGraphExplicitCost.EdgeBits) },
        { "hkaiSilhouetteMerger::MergeType", typeof(hkaiSilhouetteMerger.MergeType) },
        { "hkaiPointCloudSilhouetteGenerator::PointCloudFlagBits", typeof(hkaiPointCloudSilhouetteGenerator.PointCloudFlagBits) },
        { "hkaiPointCloudSilhouetteGenerator::DetailLevel", typeof(hkaiPointCloudSilhouetteGenerator.DetailLevel) },
        { "hkaiReferenceFrameAndExtrusion::UpVectorTransformMethod", typeof(hkaiReferenceFrameAndExtrusion.UpVectorTransformMethod) },
        { "hkaiModifiedSections::SectionBits", typeof(hkaiModifiedSections.SectionBits) },
        { "hkaiNavMeshCompactUtils::CompactingPhase", typeof(hkaiNavMeshCompactUtils.CompactingPhase) },
        { "hkaiCarver::FlagBits", typeof(hkaiCarver.FlagBits) },
        { "hkaiPath::ReferenceFrame", typeof(hkaiPath.ReferenceFrame) },
        { "hkaiPath::PathPointBits", typeof(hkaiPath.PathPointBits) },
        { "hkaiCharacter::AvoidanceState", typeof(hkaiCharacter.AvoidanceState) },
        { "hkaiCharacter::AvoidanceEnabledMaskBits", typeof(hkaiCharacter.AvoidanceEnabledMaskBits) },
        { "hkaiCharacter::State", typeof(hkaiCharacter.State) },
        { "hkaiCharacterUtil::CallbackType", typeof(hkaiCharacterUtil.CallbackType) },
        { "hkaiMovementProperties::KinematicConstraintType", typeof(hkaiMovementProperties.KinematicConstraintType) },
        { "hkaiAvoidanceProperties::NearbyBoundariesSearchType", typeof(hkaiAvoidanceProperties.NearbyBoundariesSearchType) },
        { "hkaiCornerPredictor::StepForwardResult", typeof(hkaiCornerPredictor.StepForwardResult) },
        { "hkaiPathFollowingBehavior::PathType", typeof(hkaiPathFollowingBehavior.PathType) },
        { "hkaiGatePathUtil::GateTypeValues", typeof(hkaiGatePathUtil.GateTypeValues) },
        { "hkaiGatePath::BoundarySegmentBits", typeof(hkaiGatePath.BoundarySegmentBits) },
        { "hkaiAstarOutputParameters::TerminationCause", typeof(hkaiAstarOutputParameters.TerminationCause) },
        { "hkaiAstarOutputParameters::SearchStatus", typeof(hkaiAstarOutputParameters.SearchStatus) },
        { "hkFlags<hkaiNavVolumeGenerationSettings::MaterialFlagsBits, unsigned int>", typeof(hkaiNavVolumeGenerationSettings.MaterialFlagsBits) },
        { "hkEnum<hkaiNavVolumeGenerationSettings::CellWidthToResolutionRounding, unsigned char>", typeof(hkaiNavVolumeGenerationSettings.CellWidthToResolutionRounding) },
        { "hkEnum<hkaiNavMeshSimplificationUtils::ExtraVertexSettings::VertexSelectionMethod, unsigned char>", typeof(hkaiNavMeshSimplificationUtils.ExtraVertexSettings.VertexSelectionMethod) },
        { "hkEnum<hkaiNavMeshGenerationUtilsSettings::CharacterWidthUsage, unsigned char>", typeof(hkaiNavMeshGenerationUtilsSettings.CharacterWidthUsage) },
        { "hkFlags<hkaiNavMeshGenerationUtilsSettings::ConstructionFlagsBits, unsigned int>", typeof(hkaiNavMeshGenerationUtilsSettings.ConstructionFlagsBits) },
        { "hkEnum<hkaiNavMeshGenerationUtilsSettings::EdgeMatchingMetric, unsigned int>", typeof(hkaiNavMeshGenerationUtilsSettings.EdgeMatchingMetric) },
        { "hkEnum<hkaiNavMeshGenerationUtilsSettings::TriangleWinding, unsigned char>", typeof(hkaiNavMeshGenerationUtilsSettings.TriangleWinding) },
        { "hkFlags<hkaiEdgeGeometry::FaceFlagBits, unsigned char>", typeof(hkaiEdgeGeometry.FaceFlagBits) },
        { "hkFlags<hkaiNavVolumeGenerationSettings::MaterialFlagsBits, hkUint32>", typeof(hkaiNavVolumeGenerationSettings.MaterialFlagsBits) },
        { "hkEnum<hkaiNavVolumeGenerationSettings::CellWidthToResolutionRounding, hkUint8>", typeof(hkaiNavVolumeGenerationSettings.CellWidthToResolutionRounding) },
        { "hkEnum<hkaiNavMeshSimplificationUtils::ExtraVertexSettings::VertexSelectionMethod, hkUint8>", typeof(hkaiNavMeshSimplificationUtils.ExtraVertexSettings.VertexSelectionMethod) },
        { "hkEnum<hkaiNavMeshGenerationUtilsSettings::CharacterWidthUsage, hkUint8>", typeof(hkaiNavMeshGenerationUtilsSettings.CharacterWidthUsage) },
        { "hkFlags<hkaiNavMeshGenerationUtilsSettings::ConstructionFlagsBits, hkUint32>", typeof(hkaiNavMeshGenerationUtilsSettings.ConstructionFlagsBits) },
        { "hkEnum<hkaiNavMeshGenerationUtilsSettings::EdgeMatchingMetric, hkUint32>", typeof(hkaiNavMeshGenerationUtilsSettings.EdgeMatchingMetric) },
        { "hkEnum<hkaiNavMeshGenerationUtilsSettings::TriangleWinding, hkUint8>", typeof(hkaiNavMeshGenerationUtilsSettings.TriangleWinding) },
        { "hkFlags<hkaiEdgeGeometry::FaceFlagBits, hkUint8>", typeof(hkaiEdgeGeometry.FaceFlagBits) },
        { "hkaiNavVolumeGenerationSettings::CellWidthToResolutionRounding", typeof(hkaiNavVolumeGenerationSettings.CellWidthToResolutionRounding) },
        { "hkaiNavVolumeGenerationSettings::MaterialFlagsBits", typeof(hkaiNavVolumeGenerationSettings.MaterialFlagsBits) },
        { "hkaiNavMeshSimplificationUtils::ExtraVertexSettings::VertexSelectionMethod", typeof(hkaiNavMeshSimplificationUtils.ExtraVertexSettings.VertexSelectionMethod) },
        { "hkaiNavMeshGenerationUtilsSettings::EdgeMatchingMetric", typeof(hkaiNavMeshGenerationUtilsSettings.EdgeMatchingMetric) },
        { "hkaiNavMeshGenerationUtilsSettings::TriangleWinding", typeof(hkaiNavMeshGenerationUtilsSettings.TriangleWinding) },
        { "hkaiNavMeshGenerationUtilsSettings::CharacterWidthUsage", typeof(hkaiNavMeshGenerationUtilsSettings.CharacterWidthUsage) },
        { "hkaiNavMeshGenerationUtilsSettings::ConstructionFlagsBits", typeof(hkaiNavMeshGenerationUtilsSettings.ConstructionFlagsBits) },
        { "hkaiEdgeGeometry::FaceFlagBits", typeof(hkaiEdgeGeometry.FaceFlagBits) },
        { "hctAttributeDescription20151::Hint", typeof(hctAttributeDescription20151.Hint) },
        { "hctAttributeDescription20151::ForcedType", typeof(hctAttributeDescription20151.ForcedType) },
        { "hkImageHeader", typeof(hkImageHeader) },
        { "hkMinHeapDefaultOperations<hkaiMinArrayEntry<hkViewPtr<hkaiCollisionAvoidance::Character>>>", typeof(hkMinHeapDefaultOperations) },
        { "hkaiMinArrayEntry<hkViewPtr<hkaiCollisionAvoidance::Character>>", typeof(hkaiMinArrayEntry<hkaiCollisionAvoidance.Character?>) },
        { "hkMinHeap<hkaiMinArrayEntry<hkViewPtr<hkaiCollisionAvoidance::Character>>, hkMinHeapDefaultOperations<hkaiMinArrayEntry<hkViewPtr<hkaiCollisionAvoidance::Character>>>>", typeof(hkMinHeap<hkaiMinArrayEntry<hkaiCollisionAvoidance.Character?>>) },
        { "hkaiMinArray<hkViewPtr<hkaiCollisionAvoidance::Character>>", typeof(hkaiMinArray<hkaiCollisionAvoidance.Character?>) },
        { "hkaiCollisionAvoidance::System", typeof(hkaiCollisionAvoidance.System) },
        { "hkaiCollisionAvoidance::Solver::Output", typeof(hkaiCollisionAvoidance.Solver.Output) },
        { "hkaiCollisionAvoidance::Solver::Input", typeof(hkaiCollisionAvoidance.Solver.Input) },
        { "hkaiCollisionAvoidance::ReferencedScoreModifier", typeof(hkaiCollisionAvoidance.ReferencedScoreModifier) },
        { "hkaiCollisionAvoidance::ScoreModifier", typeof(hkaiCollisionAvoidance.ScoreModifier) },
        { "hkaiCollisionAvoidance::SimpleObstacleGenerator", typeof(hkaiCollisionAvoidance.SimpleObstacleGenerator) },
        { "hkaiCollisionAvoidance::ObstacleGenerator", typeof(hkaiCollisionAvoidance.ObstacleGenerator) },
        { "hkaiCollisionAvoidance::NeighborCollector", typeof(hkaiCollisionAvoidance.NeighborCollector) },
        { "hkaiCollisionAvoidance::LineSegmentObstacle", typeof(hkaiCollisionAvoidance.LineSegmentObstacle) },
        { "hkaiCollisionAvoidance::SphereObstacle", typeof(hkaiCollisionAvoidance.SphereObstacle) },
        { "hkaiCollisionAvoidance::SteeringProperties", typeof(hkaiCollisionAvoidance.SteeringProperties) },
        { "hkaiCollisionAvoidance::Filter", typeof(hkaiCollisionAvoidance.Filter) },
        { "hkaiCollisionAvoidance::Character::SensorSize", typeof(hkaiCollisionAvoidance.Character.SensorSize) },
        { "hkaiCollisionAvoidance::Character", typeof(hkaiCollisionAvoidance.Character) },
        { "hkaiCollisionAvoidance::MediatorBoundaryGatherer", typeof(hkaiCollisionAvoidance.MediatorBoundaryGatherer) },
        { "hkaiCollisionAvoidance::DefaultBoundaryGatherer", typeof(hkaiCollisionAvoidance.DefaultBoundaryGatherer) },
        { "hkaiCollisionAvoidance::BoundaryGatherer", typeof(hkaiCollisionAvoidance.BoundaryGatherer) },
        { "fsnpCustomParamCompressedMeshShape", typeof(fsnpCustomParamCompressedMeshShape) },
        { "fsnpCustomMeshParameter::TriangleData", typeof(fsnpCustomMeshParameter.TriangleData) },
        { "fsnpCustomMeshParameter::PrimitiveData", typeof(fsnpCustomMeshParameter.PrimitiveData) },
        { "fsnpCustomMeshParameter", typeof(fsnpCustomMeshParameter) },
        { "CustomTransitionEffect", typeof(CustomTransitionEffect) },
        { "CustomPreDeleteIndexSelector", typeof(CustomPreDeleteIndexSelector) },
        { "CustomManualSelectorGeneratorInternalState", typeof(CustomManualSelectorGeneratorInternalState) },
        { "CustomManualSelectorGenerator", typeof(CustomManualSelectorGenerator) },
        { "CustomLookAtTwistModifier::TwistParam", typeof(CustomLookAtTwistModifier.TwistParam) },
        { "CustomLookAtTwistModifier", typeof(CustomLookAtTwistModifier) },
        { "CustomBoneFixModifier", typeof(CustomBoneFixModifier) },
        { "hkbnpRagdollInterface", typeof(hkbnpRagdollInterface) },
        { "hkFreeListArrayElement<hknpMotionProperties>", typeof(hkFreeListArrayElementHknpMotionProperties) },
        { "hkFreeListArrayElement<hknpMaterial>", typeof(hkFreeListArrayElementHknpMaterial) },
        { "hkFreeListArrayElement<hknpShapeInstance>", typeof(hkFreeListArrayElementHknpShapeInstance) },
        { "hkHandle<unsigned int, 2147483647>", typeof(hkHandle<uint>) },
        { "hkHandle<unsigned short, 65535>", typeof(hkHandle<ushort>) },
        { "hkHandle<short, 32767>", typeof(hkHandle<short>) },
        { "hkHandle<unsigned int, -1>", typeof(hkHandle<uint>) },
        { "hkHandle<hkInt16, 32767>", typeof(hkHandle<short>) },
        { "hkHandle<hkUint32, 2147483647>", typeof(hkHandle<uint>) },
        { "hkHandle<hkUint16, 65535>", typeof(hkHandle<ushort>) },
        { "hkHandle<hkUint8, 255>", typeof(hkHandle<byte>) },
        { "hkHandle<hkUint32, -1>", typeof(hkHandle<uint>) },
        { "hkHandle<unsigned char, 255>", typeof(hkHandle<byte>) },
        { "hkFreeListArray<hknpShapeInstance, 8>", typeof(hkFreeListArrayHknpShapeInstance) },
        { "hkFreeListArray<hknpMotionProperties, 8>", typeof(hkFreeListArrayHknpMotionProperties) },
        { "hkFreeListArray<hknpMaterial, 8>", typeof(hkFreeListArrayHknpMaterial) },
        { "hknpWeldingConfig", typeof(hknpWeldingConfig) },
        { "hknpParticleCacheMoveInfo", typeof(hknpParticleCacheMoveInfo) },
        { "hknpParticleCollisionPair", typeof(hknpParticleCollisionPair) },
        { "hknpParticleParticleContact", typeof(hknpParticleParticleContact) },
        { "hknpParticleBodyContact", typeof(hknpParticleBodyContact) },
        { "hknpShapeInstanceId", typeof(hknpShapeInstanceId) },
        { "hknpConstraintGroupId", typeof(hknpConstraintGroupId) },
        { "hknpConstraintId", typeof(hknpConstraintId) },
        { "hknpParticlesColliderId", typeof(hknpParticlesColliderId) },
        { "hknpParticleShapeProperties", typeof(hknpParticleShapeProperties) },
        { "hknpParticleFaceVerticesWithEffMass", typeof(hknpParticleFaceVerticesWithEffMass) },
        { "hknpParticle4Faces", typeof(hknpParticle4Faces) },
        { "hknpParticleShapeLibrary", typeof(hknpParticleShapeLibrary) },
        { "hknpWorldSnapshot::ConstraintGroupInfo", typeof(hknpWorldSnapshot.ConstraintGroupInfo) },
        { "hknpWorldSnapshot", typeof(hknpWorldSnapshot) },
        { "hknpStorageParticleSystem", typeof(hknpStorageParticleSystem) },
        { "hknpVdbBody", typeof(hknpVdbBody) },
        { "hknpVdbBodies", typeof(hknpVdbBodies) },
        { "hknpVdbWorld", typeof(hknpVdbWorld) },
        { "hknpVdbApiCommands", typeof(hknpVdbApiCommands) },
        { "hknpVdbShapeDisplayMarker", typeof(hknpVdbShapeDisplayMarker) },
        { "hknpShapeViewer::Options::ConvexRadiusDisplayMode", typeof(hknpShapeViewer.Options.ConvexRadiusDisplayMode) },
        { "hknpShapeViewer::Options::LevelOfDetail", typeof(hknpShapeViewer.Options.LevelOfDetail) },
        { "hknpShapeViewer::Options", typeof(hknpShapeViewer.Options) },
        { "hknpWorldQueryViewer::Options", typeof(hknpWorldQueryViewer.Options) },
        { "hknpShapeCastViewer::ShapeCastOptions", typeof(hknpShapeCastViewer.ShapeCastOptions) },
        { "hknpVdbParticlesShapeDisplay", typeof(hknpVdbParticlesShapeDisplay) },
        { "hknpParticleCacheViewer::Options", typeof(hknpParticleCacheViewer.Options) },
        { "hknpVdbMassProperties", typeof(hknpVdbMassProperties) },
        { "hknpVdbManifoldDisplay", typeof(hknpVdbManifoldDisplay) },
        { "hknpManifoldViewerBase::ManifoldWeldingEvent", typeof(hknpManifoldViewerBase.ManifoldWeldingEvent) },
        { "hknpManifoldViewerBase::VdbManifold", typeof(hknpManifoldViewerBase.VdbManifold) },
        { "hknpManifoldViewer::Options", typeof(hknpManifoldViewer.Options) },
        { "hknpHeatMapViewer::Options", typeof(hknpHeatMapViewer.Options) },
        { "hknpVdbEvents", typeof(hknpVdbEvents) },
        { "hknpDeactivationViewer::Options", typeof(hknpDeactivationViewer.Options) },
        { "hknpVdbImmediateConstraint", typeof(hknpVdbImmediateConstraint) },
        { "hknpConstraintViewer::Options", typeof(hknpConstraintViewer.Options) },
        { "hknpVdbCharacterDisplayMarker", typeof(hknpVdbCharacterDisplayMarker) },
        { "hknpVdbCharacterProxies", typeof(hknpVdbCharacterProxies) },
        { "hknpBroadPhaseViewer::Options", typeof(hknpBroadPhaseViewer.Options) },
        { "hknpVehicleInstance::WheelInfo", typeof(hknpVehicleInstance.WheelInfo) },
        { "hknpVehicleInstance", typeof(hknpVehicleInstance) },
        { "hknpVehicleData::WheelComponentParams", typeof(hknpVehicleData.WheelComponentParams) },
        { "hknpVehicleData", typeof(hknpVehicleData) },
        { "hknpVehicleWheelCollide", typeof(hknpVehicleWheelCollide) },
        { "hknpVehicleRayCastWheelCollide", typeof(hknpVehicleRayCastWheelCollide) },
        { "hknpVehicleLinearCastWheelCollide::WheelState", typeof(hknpVehicleLinearCastWheelCollide.WheelState) },
        { "hknpVehicleLinearCastWheelCollide", typeof(hknpVehicleLinearCastWheelCollide) },
        { "hknpVehicleVelocityDamper", typeof(hknpVehicleVelocityDamper) },
        { "hknpVehicleDefaultVelocityDamper", typeof(hknpVehicleDefaultVelocityDamper) },
        { "hknpTyremarksInfo", typeof(hknpTyremarksInfo) },
        { "hknpTyremarksWheel", typeof(hknpTyremarksWheel) },
        { "hknpTyremarkPoint", typeof(hknpTyremarkPoint) },
        { "hknpVehicleTransmission", typeof(hknpVehicleTransmission) },
        { "hknpVehicleDefaultTransmission", typeof(hknpVehicleDefaultTransmission) },
        { "hknpVehicleSuspension::SuspensionWheelParameters", typeof(hknpVehicleSuspension.SuspensionWheelParameters) },
        { "hknpVehicleSuspension", typeof(hknpVehicleSuspension) },
        { "hknpVehicleDefaultSuspension::WheelSpringSuspensionParameters", typeof(hknpVehicleDefaultSuspension.WheelSpringSuspensionParameters) },
        { "hknpVehicleDefaultSuspension", typeof(hknpVehicleDefaultSuspension) },
        { "hknpVehicleSteering", typeof(hknpVehicleSteering) },
        { "hknpVehicleDefaultSteering", typeof(hknpVehicleDefaultSteering) },
        { "hknpVehicleEngine", typeof(hknpVehicleEngine) },
        { "hknpVehicleDefaultEngine", typeof(hknpVehicleDefaultEngine) },
        { "hknpVehicleDriverInput", typeof(hknpVehicleDriverInput) },
        { "hknpVehicleDriverInputStatus", typeof(hknpVehicleDriverInputStatus) },
        { "hknpVehicleDefaultAnalogDriverInput", typeof(hknpVehicleDefaultAnalogDriverInput) },
        { "hknpVehicleDriverInputAnalogStatus", typeof(hknpVehicleDriverInputAnalogStatus) },
        { "hknp1dAngularFollowCamCinfo::CameraSet", typeof(hknp1dAngularFollowCamCinfo.CameraSet) },
        { "hknp1dAngularFollowCamCinfo", typeof(hknp1dAngularFollowCamCinfo) },
        { "hknpVehicleBrake", typeof(hknpVehicleBrake) },
        { "hknpVehicleDefaultBrake::WheelBrakingProperties", typeof(hknpVehicleDefaultBrake.WheelBrakingProperties) },
        { "hknpVehicleDefaultBrake", typeof(hknpVehicleDefaultBrake) },
        { "hknpVehicleAerodynamics", typeof(hknpVehicleAerodynamics) },
        { "hknpVehicleDefaultAerodynamics", typeof(hknpVehicleDefaultAerodynamics) },
        { "hknpRagdoll", typeof(hknpRagdoll) },
        { "hknpRagdollData", typeof(hknpRagdollData) },
        { "hknpRagdollKeyFrameHierarchyUtility::ControlData", typeof(hknpRagdollKeyFrameHierarchyUtility.ControlData) },
        { "hknpPhysicsSystem", typeof(hknpPhysicsSystem) },
        { "hknpPhysicsSystemData::bodyCinfoWithAttachment", typeof(hknpPhysicsSystemData.bodyCinfoWithAttachment) },
        { "hknpPhysicsSystemData", typeof(hknpPhysicsSystemData) },
        { "hknpPhysicsSceneData", typeof(hknpPhysicsSceneData) },
        { "hknpRefWorldCinfo", typeof(hknpRefWorldCinfo) },
        { "hknpBodyData", typeof(hknpBodyData) },
        { "hknpMotionPropertiesData", typeof(hknpMotionPropertiesData) },
        { "hknpMaterialData", typeof(hknpMaterialData) },
        { "hknpDestructionShapeProperties", typeof(hknpDestructionShapeProperties) },
        { "hknpCharacterSurfaceInfo", typeof(hknpCharacterSurfaceInfo) },
        { "hknpCharacterRigidBodyCinfo", typeof(hknpCharacterRigidBodyCinfo) },
        { "hknpCharacterProxyCinfo", typeof(hknpCharacterProxyCinfo) },
        { "hknpCharacterProxy", typeof(hknpCharacterProxy) },
        { "hknpFirstPersonCharacterCinfo", typeof(hknpFirstPersonCharacterCinfo) },
        { "hknpFirstPersonCharacter", typeof(hknpFirstPersonCharacter) },
        { "hknpProjectileGun", typeof(hknpProjectileGun) },
        { "hknpMountedBallGun", typeof(hknpMountedBallGun) },
        { "hknpGravityGun", typeof(hknpGravityGun) },
        { "hknpFirstPersonGun", typeof(hknpFirstPersonGun) },
        { "hknpBallGun", typeof(hknpBallGun) },
        { "hknpArrayAction", typeof(hknpArrayAction) },
        { "hknpBinaryAction", typeof(hknpBinaryAction) },
        { "hknpUnaryAction", typeof(hknpUnaryAction) },
        { "hknpAction", typeof(hknpAction) },
        { "hknpSpringAction", typeof(hknpSpringAction) },
        { "hknpWorldCinfo", typeof(hknpWorldCinfo) },
        { "hknpStepInput", typeof(hknpStepInput) },
        { "hknpLodManagerCinfo", typeof(hknpLodManagerCinfo) },
        { "hknpBinaryBodyDebugEvent", typeof(hknpBinaryBodyDebugEvent) },
        { "hknpUnaryBodyDebugEvent", typeof(hknpUnaryBodyDebugEvent) },
        { "hknpReserved1Event", typeof(hknpReserved1Event) },
        { "hknpReserved0Event", typeof(hknpReserved0Event) },
        { "hknpParticlesExitedBroadPhaseEvent", typeof(hknpParticlesExitedBroadPhaseEvent) },
        { "hknpParticleParticleImpulseAppliedEvent", typeof(hknpParticleParticleImpulseAppliedEvent) },
        { "hknpParticleBodyImpulseAppliedEvent", typeof(hknpParticleBodyImpulseAppliedEvent) },
        { "hknpParticlesCollidedWithParticlesEvent", typeof(hknpParticlesCollidedWithParticlesEvent) },
        { "hknpParticlesCollidedWithBodiesEvent", typeof(hknpParticlesCollidedWithBodiesEvent) },
        { "hknpBodyExitedBroadPhaseEvent", typeof(hknpBodyExitedBroadPhaseEvent) },
        { "hknpBinaryBodyEvent", typeof(hknpBinaryBodyEvent) },
        { "hknpUnaryBodyEvent", typeof(hknpUnaryBodyEvent) },
        { "hknpEmptyEvent", typeof(hknpEmptyEvent) },
        { "hknpEvent", typeof(hknpEvent) },
        { "hknpStepAllParticlesCollidersTrace", typeof(hknpStepAllParticlesCollidersTrace) },
        { "hknpRebuildParticleCollisionCachesCommand", typeof(hknpRebuildParticleCollisionCachesCommand) },
        { "hknpDisableParticlesCommand", typeof(hknpDisableParticlesCommand) },
        { "hknpEnableParticlesCommand", typeof(hknpEnableParticlesCommand) },
        { "hknpRemoveParticlesCommand", typeof(hknpRemoveParticlesCommand) },
        { "hknpAddParticlesCommand", typeof(hknpAddParticlesCommand) },
        { "hknpDestroyParticlesColliderCommand", typeof(hknpDestroyParticlesColliderCommand) },
        { "hknpParticlesColliderAllocatedTrace", typeof(hknpParticlesColliderAllocatedTrace) },
        { "hknpDefragmentInactiveCacheStreamsCommand", typeof(hknpDefragmentInactiveCacheStreamsCommand) },
        { "hknpMotionAllocatedTrace", typeof(hknpMotionAllocatedTrace) },
        { "hknpRebuildMotionMassPropertiesCommand", typeof(hknpRebuildMotionMassPropertiesCommand) },
        { "hknpDestroyMotionsCommand", typeof(hknpDestroyMotionsCommand) },
        { "hknpApplyHardKeyFrameCommand", typeof(hknpApplyHardKeyFrameCommand) },
        { "hknpShiftBroadphaseCommand", typeof(hknpShiftBroadphaseCommand) },
        { "hknpShiftWorldCommand", typeof(hknpShiftWorldCommand) },
        { "hknpSetEventDispatcherCommand", typeof(hknpSetEventDispatcherCommand) },
        { "hknpDeleteAllCachesCommand", typeof(hknpDeleteAllCachesCommand) },
        { "hknpAddCollisionCachesCommand", typeof(hknpAddCollisionCachesCommand) },
        { "hknpActivateBodiesInAabbCommand", typeof(hknpActivateBodiesInAabbCommand) },
        { "hknpCommitAddBodiesCommand", typeof(hknpCommitAddBodiesCommand) },
        { "hknpUpdateBroadphaseCommand", typeof(hknpUpdateBroadphaseCommand) },
        { "hknpEnableConstraintCommand", typeof(hknpEnableConstraintCommand) },
        { "hknpDisableConstraintCommand", typeof(hknpDisableConstraintCommand) },
        { "hknpDestroyConstraintsCommand", typeof(hknpDestroyConstraintsCommand) },
        { "hknpSetWorldShapeTagCodecCommand", typeof(hknpSetWorldShapeTagCodecCommand) },
        { "hknpSetWorldCollisionFilterCommand", typeof(hknpSetWorldCollisionFilterCommand) },
        { "hknpSetConstraintGroupCommand", typeof(hknpSetConstraintGroupCommand) },
        { "hknpConstraintAllocatedTrace", typeof(hknpConstraintAllocatedTrace) },
        { "hknpStepSolveTrace", typeof(hknpStepSolveTrace) },
        { "hknpStepCollideTrace", typeof(hknpStepCollideTrace) },
        { "hknpClearBodyDragPropertiesCommand", typeof(hknpClearBodyDragPropertiesCommand) },
        { "hknpSetBodyDragPropertiesCommand", typeof(hknpSetBodyDragPropertiesCommand) },
        { "hknpSetBodyCollisionLookAheadDistanceCommand", typeof(hknpSetBodyCollisionLookAheadDistanceCommand) },
        { "hknpSetWorldAirDensityCommand", typeof(hknpSetWorldAirDensityCommand) },
        { "hknpSetWorldGravityCommand", typeof(hknpSetWorldGravityCommand) },
        { "hknpSetBodyActivationControlCommand", typeof(hknpSetBodyActivationControlCommand) },
        { "hknpUpdateBodyCollisionCachesCommand", typeof(hknpUpdateBodyCollisionCachesCommand) },
        { "hknpRebuildBodyCollisionCachesCommand", typeof(hknpRebuildBodyCollisionCachesCommand) },
        { "hknpUpdateBodyFlagsCommand", typeof(hknpUpdateBodyFlagsCommand) },
        { "hknpSetBodyCollisionFilterInfoCommand", typeof(hknpSetBodyCollisionFilterInfoCommand) },
        { "hknpSetBodyActivationPriorityCommand", typeof(hknpSetBodyActivationPriorityCommand) },
        { "hknpSetBodyActivationStateCommand", typeof(hknpSetBodyActivationStateCommand) },
        { "hknpSetBodyQualityCommand", typeof(hknpSetBodyQualityCommand) },
        { "hknpSetBodyMaterialCommand", typeof(hknpSetBodyMaterialCommand) },
        { "hknpSetBodyMotionPropertiesCommand", typeof(hknpSetBodyMotionPropertiesCommand) },
        { "hknpSetBodyShapeCommand", typeof(hknpSetBodyShapeCommand) },
        { "hknpSetMotionInertiaCommand", typeof(hknpSetMotionInertiaCommand) },
        { "hknpSetMotionCenterOfMassCommand", typeof(hknpSetMotionCenterOfMassCommand) },
        { "hknpClearBodyMassDistributionCommand", typeof(hknpClearBodyMassDistributionCommand) },
        { "hknpSetBodyMassDistributionCommand", typeof(hknpSetBodyMassDistributionCommand) },
        { "hknpSetBodyMotionCommand", typeof(hknpSetBodyMotionCommand) },
        { "hknpSetBodyMotionTypeCommand", typeof(hknpSetBodyMotionTypeCommand) },
        { "hknpSetBodyMassCommand", typeof(hknpSetBodyMassCommand) },
        { "hknpSetPointVelocityCommand", typeof(hknpSetPointVelocityCommand) },
        { "hknpApplyPointImpulseCommand", typeof(hknpApplyPointImpulseCommand) },
        { "hknpApplyAngularImpulseCommand", typeof(hknpApplyAngularImpulseCommand) },
        { "hknpApplyLinearImpulseCommand", typeof(hknpApplyLinearImpulseCommand) },
        { "hknpReintegrateMotionCommand", typeof(hknpReintegrateMotionCommand) },
        { "hknpSetBodyAngularVelocityCommand", typeof(hknpSetBodyAngularVelocityCommand) },
        { "hknpSetBodyLinearVelocityCommand", typeof(hknpSetBodyLinearVelocityCommand) },
        { "hknpSetBodyVelocityCommand", typeof(hknpSetBodyVelocityCommand) },
        { "hknpSetBodyOrientationCommand", typeof(hknpSetBodyOrientationCommand) },
        { "hknpSetBodyPositionCommand", typeof(hknpSetBodyPositionCommand) },
        { "hknpSetBodyTransformCommand", typeof(hknpSetBodyTransformCommand) },
        { "hknpAttachBodyCommand", typeof(hknpAttachBodyCommand) },
        { "hknpDetachBodyCommand", typeof(hknpDetachBodyCommand) },
        { "hknpRemoveBodyCommand", typeof(hknpRemoveBodyCommand) },
        { "hknpAddBodyCommand", typeof(hknpAddBodyCommand) },
        { "hknpDestroyBodyCommand", typeof(hknpDestroyBodyCommand) },
        { "hknpBodyAllocatedAttachedTrace", typeof(hknpBodyAllocatedAttachedTrace) },
        { "hknpBodyAllocatedTrace", typeof(hknpBodyAllocatedTrace) },
        { "hknpUnaryBodyApiCommand", typeof(hknpUnaryBodyApiCommand) },
        { "hknpApiCommand", typeof(hknpApiCommand) },
        { "hknpBodyIntegrator", typeof(hknpBodyIntegrator) },
        { "hknpLinearIntegrationClippedEvent", typeof(hknpLinearIntegrationClippedEvent) },
        { "hknpConstraintForceExceededEvent", typeof(hknpConstraintForceExceededEvent) },
        { "hknpConstraintForceEvent", typeof(hknpConstraintForceEvent) },
        { "hknpFullCastCollisionEvent", typeof(hknpFullCastCollisionEvent) },
        { "hknpDeflectedLinearCastCollisionEvent", typeof(hknpDeflectedLinearCastCollisionEvent) },
        { "hknpContactImpulseClippedEvent", typeof(hknpContactImpulseClippedEvent) },
        { "hknpContactImpulseEvent", typeof(hknpContactImpulseEvent) },
        { "hknpContactSolverEvent", typeof(hknpContactSolverEvent) },
        { "hknpMotionPropertiesLibrary", typeof(hknpMotionPropertiesLibrary) },
        { "hknpMotionPropertiesId", typeof(hknpMotionPropertiesId) },
        { "hknpMotionPropertiesIdBase", typeof(hknpMotionPropertiesIdBase) },
        { "hknpMotionProperties::FullCastSettings", typeof(hknpMotionProperties.FullCastSettings) },
        { "hknpMotionProperties::DeactivationSettings", typeof(hknpMotionProperties.DeactivationSettings) },
        { "hknpMotionProperties", typeof(hknpMotionProperties) },
        { "hknpMotionId", typeof(hknpMotionId) },
        { "hknpMotionIdBase", typeof(hknpMotionIdBase) },
        { "hknpMotionCinfo", typeof(hknpMotionCinfo) },
        { "hknpMotion", typeof(hknpMotion) },
        { "hknpSurfaceVelocity", typeof(hknpSurfaceVelocity) },
        { "hknpLinearSurfaceVelocity", typeof(hknpLinearSurfaceVelocity) },
        { "hknpCircularSurfaceVelocity", typeof(hknpCircularSurfaceVelocity) },
        { "hknpMaterialPalette", typeof(hknpMaterialPalette) },
        { "hknpMaterialLibrary", typeof(hknpMaterialLibrary) },
        { "hknpMaterialId", typeof(hknpMaterialId) },
        { "hknpMaterialIdBase", typeof(hknpMaterialIdBase) },
        { "hknpMaterialDescriptor", typeof(hknpMaterialDescriptor) },
        { "hknpRefMaterial", typeof(hknpRefMaterial) },
        { "hknpMaterial", typeof(hknpMaterial) },
        { "hknpConstraintGroup", typeof(hknpConstraintGroup) },
        { "hknpConstraintCinfo", typeof(hknpConstraintCinfo) },
        { "hknpConstraint", typeof(hknpConstraint) },
        { "hknpMalleableConstraintData", typeof(hknpMalleableConstraintData) },
        { "hknpBridgeConstraintAtom", typeof(hknpBridgeConstraintAtom) },
        { "hknpBreakableConstraintData", typeof(hknpBreakableConstraintData) },
        { "hknpBodyQualityLibrary", typeof(hknpBodyQualityLibrary) },
        { "hknpBodyQualityId", typeof(hknpBodyQualityId) },
        { "hknpBodyQuality", typeof(hknpBodyQuality) },
        { "hknpBodyIdPair", typeof(hknpBodyIdPair) },
        { "hknpBodyReference", typeof(hknpBodyReference) },
        { "hknpBodyId", typeof(hknpBodyId) },
        { "hknpBodyCinfo", typeof(hknpBodyCinfo) },
        { "hknpBody", typeof(hknpBody) },
        { "hknpCollisionDispatchType", typeof(hknpCollisionDispatchType) },
        { "hknpShapeType", typeof(hknpShapeType) },
        { "hknpShapeSignals", typeof(hknpShapeSignals) },
        { "hknpShapeKeyMask", typeof(hknpShapeKeyMask) },
        { "hknpLodShapeIndex", typeof(hknpLodShapeIndex) },
        { "hknpShapeMassProperties", typeof(hknpShapeMassProperties) },
        { "hknpShape::MassConfig", typeof(hknpShape.MassConfig) },
        { "hknpShape", typeof(hknpShape) },
        { "hknpShapeTagCodec", typeof(hknpShapeTagCodec) },
        { "hknpParticlesColliderShape", typeof(hknpParticlesColliderShape) },
        { "hknpDummyShape", typeof(hknpDummyShape) },
        { "hknpDecoratorShape", typeof(hknpDecoratorShape) },
        { "hknpScaledConvexShape", typeof(hknpScaledConvexShape) },
        { "hknpScaledConvexShapeBase", typeof(hknpScaledConvexShapeBase) },
        { "hknpMaskedShape::MaskWrapper", typeof(hknpMaskedShape.MaskWrapper) },
        { "hknpMaskedShape", typeof(hknpMaskedShape) },
        { "hknpMaskedCompoundShape", typeof(hknpMaskedCompoundShape) },
        { "hknpConvexShape", typeof(hknpConvexShape) },
        { "hknpTriangleShape", typeof(hknpTriangleShape) },
        { "hknpSphereShape", typeof(hknpSphereShape) },
        { "hknpConvexPolytopeShape::Connectivity::Edge", typeof(hknpConvexPolytopeShape.Connectivity.Edge) },
        { "hknpConvexPolytopeShape::Connectivity", typeof(hknpConvexPolytopeShape.Connectivity) },
        { "hknpConvexPolytopeShape::Face", typeof(hknpConvexPolytopeShape.Face) },
        { "hknpConvexPolytopeShape", typeof(hknpConvexPolytopeShape) },
        { "hknpCylinderShape", typeof(hknpCylinderShape) },
        { "hknpCapsuleShape", typeof(hknpCapsuleShape) },
        { "hknpBoxShape", typeof(hknpBoxShape) },
        { "hknpCompositeShape", typeof(hknpCompositeShape) },
        { "hknpExternMeshShapeData", typeof(hknpExternMeshShapeData) },
        { "hknpExternMeshShape", typeof(hknpExternMeshShape) },
        { "hknpExternMeshShapeGeometry", typeof(hknpExternMeshShapeGeometry) },
        { "hknpExtendedExternMeshShapeGeometry::Quad", typeof(hknpExtendedExternMeshShapeGeometry.Quad) },
        { "hknpExtendedExternMeshShapeGeometry::Triangle", typeof(hknpExtendedExternMeshShapeGeometry.Triangle) },
        { "hknpExtendedExternMeshShapeGeometry", typeof(hknpExtendedExternMeshShapeGeometry) },
        { "hknpDefaultExternMeshShapeGeometry", typeof(hknpDefaultExternMeshShapeGeometry) },
        { "hknpCompressedMeshShape", typeof(hknpCompressedMeshShape) },
        { "hknpLodShape", typeof(hknpLodShape) },
        { "hknpLodMeshShape::LevelOfDetailInfo", typeof(hknpLodMeshShape.LevelOfDetailInfo) },
        { "hknpLodMeshShape", typeof(hknpLodMeshShape) },
        { "hknpMinMaxQuadTree::MinMaxLevel", typeof(hknpMinMaxQuadTree.MinMaxLevel) },
        { "hknpMinMaxQuadTree", typeof(hknpMinMaxQuadTree) },
        { "hknpHeightFieldShape", typeof(hknpHeightFieldShape) },
        { "hknpHeightFieldBoundingVolume", typeof(hknpHeightFieldBoundingVolume) },
        { "hknpHeightFieldGeometry", typeof(hknpHeightFieldGeometry) },
        { "hknpDefaultHeightFieldGeometry", typeof(hknpDefaultHeightFieldGeometry) },
        { "hknpShapeInstance", typeof(hknpShapeInstance) },
        { "hknpCompoundShapeInternalsCdDynamicTreeKeyMask", typeof(hknpCompoundShapeInternalsCdDynamicTreeKeyMask) },
        { "hknpCompoundShapeInternalsSimdTreeKeyMask", typeof(hknpCompoundShapeInternalsSimdTreeKeyMask) },
        { "hknpCompoundShapeData", typeof(hknpCompoundShapeData) },
        { "hknpCompoundShapeCdDynamicTree", typeof(hknpCompoundShapeCdDynamicTree) },
        { "hknpCompoundShapeSimdTree", typeof(hknpCompoundShapeSimdTree) },
        { "hknpCompoundShapeKeyMask", typeof(hknpCompoundShapeKeyMask) },
        { "hknpCompoundShape::VelocityInfo", typeof(hknpCompoundShape.VelocityInfo) },
        { "hknpCompoundShape", typeof(hknpCompoundShape) },
        { "hknpCollisionFilter", typeof(hknpCollisionFilter) },
        { "hknpPairCollisionFilter::MapPairFilterKeyOverrideType", typeof(hknpPairCollisionFilter.MapPairFilterKeyOverrideType) },
        { "hknpPairCollisionFilter", typeof(hknpPairCollisionFilter) },
        { "hknpGroupCollisionFilter", typeof(hknpGroupCollisionFilter) },
        { "hknpDisableCollisionFilter", typeof(hknpDisableCollisionFilter) },
        { "hknpConstraintCollisionFilter", typeof(hknpConstraintCollisionFilter) },
        { "hknpTriggerEvent", typeof(hknpTriggerEvent) },
        { "hknpManifoldEvent", typeof(hknpManifoldEvent) },
        { "hknpDefaultBroadPhaseConfig", typeof(hknpDefaultBroadPhaseConfig) },
        { "hknpBroadPhaseConfig::Layer", typeof(hknpBroadPhaseConfig.Layer) },
        { "hknpBroadPhaseConfig", typeof(hknpBroadPhaseConfig) },
        { "hknpRefMassDistribution", typeof(hknpRefMassDistribution) },
        { "hknpMassDistribution", typeof(hknpMassDistribution) },
        { "hknpRefDragProperties", typeof(hknpRefDragProperties) },
        { "hknpDragProperties", typeof(hknpDragProperties) },
        { "hknpCompressedMeshShapeInternals::KeyMask", typeof(hknpCompressedMeshShapeInternals.KeyMask) },
        { "hknpCompressedMeshShapeData", typeof(hknpCompressedMeshShapeData) },
        { "hknpCompressedMeshShapeTree", typeof(hknpCompressedMeshShapeTree) },
        { "hkProcessOptionsMarker", typeof(hkProcessOptionsMarker) },
        { "hkDebugDisplayMarker", typeof(hkDebugDisplayMarker) },
        { "TestComplexContainerRecord", typeof(TestComplexContainerRecord) },
        { "TestComplexExRecord", typeof(TestComplexExRecord) },
        { "TestComplexRecord", typeof(TestComplexRecord) },
        { "TestSimpleContainerExRecord", typeof(TestSimpleContainerExRecord) },
        { "TestSimpleContainerRecord", typeof(TestSimpleContainerRecord) },
        { "TestSimpleExRecord::Nested", typeof(TestSimpleExRecord.Nested) },
        { "TestSimpleExRecord", typeof(TestSimpleExRecord) },
        { "TestSimpleRecord", typeof(TestSimpleRecord) },
        { "hkVdb::Detail::ToString", typeof(hkVdb.Detail.ToString) },
        { "hkVdb::Detail::PtrOffsetIndex", typeof(hkVdb.Detail.PtrOffsetIndex) },
        { "hkVdb::Tweakable", typeof(hkVdb.Tweakable) },
        { "hkxSpline::ControlPoint", typeof(hkxSpline.ControlPoint) },
        { "hkxSpline", typeof(hkxSpline) },
        { "hkxSkinBinding", typeof(hkxSkinBinding) },
        { "hkxNodeSelectionSet", typeof(hkxNodeSelectionSet) },
        { "hkxScene", typeof(hkxScene) },
        { "hkxVertexDescription::ElementDecl", typeof(hkxVertexDescription.ElementDecl) },
        { "hkxVertexDescription", typeof(hkxVertexDescription) },
        { "hkxVertexBuffer::VertexData", typeof(hkxVertexBuffer.VertexData) },
        { "hkxVertexBuffer", typeof(hkxVertexBuffer) },
        { "hkxVertexAnimation::UsageMap", typeof(hkxVertexAnimation.UsageMap) },
        { "hkxVertexAnimation", typeof(hkxVertexAnimation) },
        { "hkxMeshSection", typeof(hkxMeshSection) },
        { "hkxMesh::UserChannelInfo", typeof(hkxMesh.UserChannelInfo) },
        { "hkxMesh", typeof(hkxMesh) },
        { "hkxIndexBuffer", typeof(hkxIndexBuffer) },
        { "hkxVertexVectorDataChannel", typeof(hkxVertexVectorDataChannel) },
        { "hkxVertexSelectionChannel", typeof(hkxVertexSelectionChannel) },
        { "hkxVertexIntDataChannel", typeof(hkxVertexIntDataChannel) },
        { "hkxVertexFloatDataChannel", typeof(hkxVertexFloatDataChannel) },
        { "hkxTriangleSelectionChannel", typeof(hkxTriangleSelectionChannel) },
        { "hkxEdgeSelectionChannel", typeof(hkxEdgeSelectionChannel) },
        { "hkxBlendShapeCollectionChannel::BlendShape", typeof(hkxBlendShapeCollectionChannel.BlendShape) },
        { "hkxBlendShapeCollectionChannel::Channel", typeof(hkxBlendShapeCollectionChannel.Channel) },
        { "hkxBlendShapeCollectionChannel::FloatCurve", typeof(hkxBlendShapeCollectionChannel.FloatCurve) },
        { "hkxBlendShapeCollectionChannel::FloatCurveKey", typeof(hkxBlendShapeCollectionChannel.FloatCurveKey) },
        { "hkxBlendShapeCollectionChannel::KeyFrame", typeof(hkxBlendShapeCollectionChannel.KeyFrame) },
        { "hkxBlendShapeCollectionChannel", typeof(hkxBlendShapeCollectionChannel) },
        { "hkxTextureInplace", typeof(hkxTextureInplace) },
        { "hkxTextureFile", typeof(hkxTextureFile) },
        { "hkxMaterialShaderSet", typeof(hkxMaterialShaderSet) },
        { "hkxMaterialShader", typeof(hkxMaterialShader) },
        { "hkxMaterialEffect", typeof(hkxMaterialEffect) },
        { "hkxMaterial::Property", typeof(hkxMaterial.Property) },
        { "hkxMaterial::TextureStage", typeof(hkxMaterial.TextureStage) },
        { "hkxMaterial", typeof(hkxMaterial) },
        { "hkxLight", typeof(hkxLight) },
        { "hkxNode::AnnotationData", typeof(hkxNode.AnnotationData) },
        { "hkxNode", typeof(hkxNode) },
        { "hkxEnvironment::Variable", typeof(hkxEnvironment.Variable) },
        { "hkxEnvironment", typeof(hkxEnvironment) },
        { "hkxCamera", typeof(hkxCamera) },
        { "hkxBlobMeshShape", typeof(hkxBlobMeshShape) },
        { "hkxBlob", typeof(hkxBlob) },
        { "hkxSparselyAnimatedString", typeof(hkxSparselyAnimatedString) },
        { "hkxSparselyAnimatedInt", typeof(hkxSparselyAnimatedInt) },
        { "hkxSparselyAnimatedEnum", typeof(hkxSparselyAnimatedEnum) },
        { "hkxEnum::Item", typeof(hkxEnum.Item) },
        { "hkxEnum", typeof(hkxEnum) },
        { "hkxSparselyAnimatedBool", typeof(hkxSparselyAnimatedBool) },
        { "hkxAttributeHolder", typeof(hkxAttributeHolder) },
        { "hkxAttributeGroup", typeof(hkxAttributeGroup) },
        { "hkxAttribute", typeof(hkxAttribute) },
        { "hkxAnimatedVector", typeof(hkxAnimatedVector) },
        { "hkxAnimatedQuaternion", typeof(hkxAnimatedQuaternion) },
        { "hkxAnimatedMatrix", typeof(hkxAnimatedMatrix) },
        { "hkxAnimatedFloat", typeof(hkxAnimatedFloat) },
        { "hkAlignSceneToNodeOptions", typeof(hkAlignSceneToNodeOptions) },
        { "hkpVehicleFrictionStatus::AxisStatus", typeof(hkpVehicleFrictionStatus.AxisStatus) },
        { "hkpVehicleFrictionStatus", typeof(hkpVehicleFrictionStatus) },
        { "hkpVehicleFrictionDescription::AxisDescription", typeof(hkpVehicleFrictionDescription.AxisDescription) },
        { "hkpVehicleFrictionDescription", typeof(hkpVehicleFrictionDescription) },
        { "hkpConstraintMotor", typeof(hkpConstraintMotor) },
        { "hkpVelocityConstraintMotor", typeof(hkpVelocityConstraintMotor) },
        { "hkpSpringDamperConstraintMotor", typeof(hkpSpringDamperConstraintMotor) },
        { "hkpPositionConstraintMotor", typeof(hkpPositionConstraintMotor) },
        { "hkpLimitedForceConstraintMotor", typeof(hkpLimitedForceConstraintMotor) },
        { "hkpCallbackConstraintMotor", typeof(hkpCallbackConstraintMotor) },
        { "hkpConstraintData", typeof(hkpConstraintData) },
        { "hkpWrappedConstraintData", typeof(hkpWrappedConstraintData) },
        { "hkpWheelConstraintData::Atoms", typeof(hkpWheelConstraintData.Atoms) },
        { "hkpWheelConstraintData", typeof(hkpWheelConstraintData) },
        { "hkpWheelFrictionConstraintData::Atoms", typeof(hkpWheelFrictionConstraintData.Atoms) },
        { "hkpWheelFrictionConstraintData::Runtime", typeof(hkpWheelFrictionConstraintData.Runtime) },
        { "hkpWheelFrictionConstraintData", typeof(hkpWheelFrictionConstraintData) },
        { "hkpStiffSpringConstraintData::Atoms", typeof(hkpStiffSpringConstraintData.Atoms) },
        { "hkpStiffSpringConstraintData", typeof(hkpStiffSpringConstraintData) },
        { "hkpRotationalConstraintData::Atoms", typeof(hkpRotationalConstraintData.Atoms) },
        { "hkpRotationalConstraintData", typeof(hkpRotationalConstraintData) },
        { "hkpRagdollConstraintData::Atoms", typeof(hkpRagdollConstraintData.Atoms) },
        { "hkpRagdollConstraintData", typeof(hkpRagdollConstraintData) },
        { "hkpRagdollLimitsData::Atoms", typeof(hkpRagdollLimitsData.Atoms) },
        { "hkpRagdollLimitsData", typeof(hkpRagdollLimitsData) },
        { "hkpRackAndPinionConstraintData::Atoms", typeof(hkpRackAndPinionConstraintData.Atoms) },
        { "hkpRackAndPinionConstraintData", typeof(hkpRackAndPinionConstraintData) },
        { "hkpPulleyConstraintData::Atoms", typeof(hkpPulleyConstraintData.Atoms) },
        { "hkpPulleyConstraintData", typeof(hkpPulleyConstraintData) },
        { "hkpPrismaticConstraintData::Atoms", typeof(hkpPrismaticConstraintData.Atoms) },
        { "hkpPrismaticConstraintData", typeof(hkpPrismaticConstraintData) },
        { "hkpPointToPlaneConstraintData::Atoms", typeof(hkpPointToPlaneConstraintData.Atoms) },
        { "hkpPointToPlaneConstraintData", typeof(hkpPointToPlaneConstraintData) },
        { "hkpPointToPathConstraintData", typeof(hkpPointToPathConstraintData) },
        { "hkpParametricCurve", typeof(hkpParametricCurve) },
        { "hkpLinearParametricCurve", typeof(hkpLinearParametricCurve) },
        { "hkpLimitedHingeConstraintData::Atoms", typeof(hkpLimitedHingeConstraintData.Atoms) },
        { "hkpLimitedHingeConstraintData", typeof(hkpLimitedHingeConstraintData) },
        { "hkpHingeConstraintData::Atoms", typeof(hkpHingeConstraintData.Atoms) },
        { "hkpHingeConstraintData", typeof(hkpHingeConstraintData) },
        { "hkpHingeLimitsData::Atoms", typeof(hkpHingeLimitsData.Atoms) },
        { "hkpHingeLimitsData", typeof(hkpHingeLimitsData) },
        { "hkpFixedConstraintData::Atoms", typeof(hkpFixedConstraintData.Atoms) },
        { "hkpFixedConstraintData", typeof(hkpFixedConstraintData) },
        { "hkpDeformableFixedConstraintData::Atoms", typeof(hkpDeformableFixedConstraintData.Atoms) },
        { "hkpDeformableFixedConstraintData", typeof(hkpDeformableFixedConstraintData) },
        { "hkpCogWheelConstraintData::Atoms", typeof(hkpCogWheelConstraintData.Atoms) },
        { "hkpCogWheelConstraintData", typeof(hkpCogWheelConstraintData) },
        { "hkpLinearClearanceConstraintData::Atoms", typeof(hkpLinearClearanceConstraintData.Atoms) },
        { "hkpLinearClearanceConstraintData", typeof(hkpLinearClearanceConstraintData) },
        { "hkpBallAndSocketConstraintData::Atoms", typeof(hkpBallAndSocketConstraintData.Atoms) },
        { "hkpBallAndSocketConstraintData", typeof(hkpBallAndSocketConstraintData) },
        { "hkp6DofConstraintData::Blueprints", typeof(hkp6DofConstraintData.Blueprints) },
        { "hkp6DofConstraintData", typeof(hkp6DofConstraintData) },
        { "hkpCogWheelConstraintAtom", typeof(hkpCogWheelConstraintAtom) },
        { "hkpRackAndPinionConstraintAtom", typeof(hkpRackAndPinionConstraintAtom) },
        { "hkpPulleyConstraintAtom", typeof(hkpPulleyConstraintAtom) },
        { "hkpLinMotorConstraintAtom", typeof(hkpLinMotorConstraintAtom) },
        { "hkpWheelFrictionConstraintAtom::Axle", typeof(hkpWheelFrictionConstraintAtom.Axle) },
        { "hkpWheelFrictionConstraintAtom", typeof(hkpWheelFrictionConstraintAtom) },
        { "hkpLinFrictionConstraintAtom", typeof(hkpLinFrictionConstraintAtom) },
        { "hkpRagdollMotorConstraintAtom", typeof(hkpRagdollMotorConstraintAtom) },
        { "hkpAngMotorConstraintAtom", typeof(hkpAngMotorConstraintAtom) },
        { "hkpAngFrictionConstraintAtom", typeof(hkpAngFrictionConstraintAtom) },
        { "hkpEllipticalLimitConstraintAtom", typeof(hkpEllipticalLimitConstraintAtom) },
        { "hkpConeLimitConstraintAtom", typeof(hkpConeLimitConstraintAtom) },
        { "hkpTwistLimitConstraintAtom", typeof(hkpTwistLimitConstraintAtom) },
        { "hkpAngLimitConstraintAtom", typeof(hkpAngLimitConstraintAtom) },
        { "hkpAngConstraintAtom", typeof(hkpAngConstraintAtom) },
        { "hkp2dAngConstraintAtom", typeof(hkp2dAngConstraintAtom) },
        { "hkpLinLimitConstraintAtom", typeof(hkpLinLimitConstraintAtom) },
        { "hkpLinSoftConstraintAtom", typeof(hkpLinSoftConstraintAtom) },
        { "hkpLinConstraintAtom", typeof(hkpLinConstraintAtom) },
        { "hkpOverwritePivotConstraintAtom", typeof(hkpOverwritePivotConstraintAtom) },
        { "hkpSetLocalRotationsConstraintAtom", typeof(hkpSetLocalRotationsConstraintAtom) },
        { "hkpSetLocalTranslationsConstraintAtom", typeof(hkpSetLocalTranslationsConstraintAtom) },
        { "hkpSetLocalTransformsConstraintAtom", typeof(hkpSetLocalTransformsConstraintAtom) },
        { "hkpStiffSpringConstraintAtom", typeof(hkpStiffSpringConstraintAtom) },
        { "hkpBallSocketConstraintAtom", typeof(hkpBallSocketConstraintAtom) },
        { "hkpDeformableAngConstraintAtom", typeof(hkpDeformableAngConstraintAtom) },
        { "hkpDeformableLinConstraintAtom", typeof(hkpDeformableLinConstraintAtom) },
        { "hkp3dAngConstraintAtom", typeof(hkp3dAngConstraintAtom) },
        { "hkpSetupStabilizationAtom", typeof(hkpSetupStabilizationAtom) },
        { "hkpConstraintAtom", typeof(hkpConstraintAtom) },
        { "hkpBridgeAtoms", typeof(hkpBridgeAtoms) },
        { "hkpBridgeConstraintAtom", typeof(hkpBridgeConstraintAtom) },
        { "hkgpCgo::Config", typeof(hkgpCgo.Config) },
        { "hkaSkeleton::Partition", typeof(hkaSkeleton.Partition) },
        { "hkaSkeleton::LocalFrameOnBone", typeof(hkaSkeleton.LocalFrameOnBone) },
        { "hkaSkeleton", typeof(hkaSkeleton) },
        { "hkaBone", typeof(hkaBone) },
        { "hkMeshVertexBuffer", typeof(hkMeshVertexBuffer) },
        { "hkVertexFormat::Element", typeof(hkVertexFormat.Element) },
        { "hkVertexFormat", typeof(hkVertexFormat) },
        { "hkMeshTexture::RawBufferDescriptor", typeof(hkMeshTexture.RawBufferDescriptor) },
        { "hkMeshTexture", typeof(hkMeshTexture) },
        { "hkMeshSystem", typeof(hkMeshSystem) },
        { "hkMeshShape", typeof(hkMeshShape) },
        { "hkMeshSectionCinfo", typeof(hkMeshSectionCinfo) },
        { "hkMeshSection", typeof(hkMeshSection) },
        { "hkMeshMaterial", typeof(hkMeshMaterial) },
        { "hkMeshBody", typeof(hkMeshBody) },
        { "hkSkinnedRefMeshShape", typeof(hkSkinnedRefMeshShape) },
        { "hkStorageSkinnedMeshShape", typeof(hkStorageSkinnedMeshShape) },
        { "hkSkinnedMeshShape::Part", typeof(hkSkinnedMeshShape.Part) },
        { "hkSkinnedMeshShape::BoneSection", typeof(hkSkinnedMeshShape.BoneSection) },
        { "hkSkinnedMeshShape::BoneSet", typeof(hkSkinnedMeshShape.BoneSet) },
        { "hkSkinnedMeshShape", typeof(hkSkinnedMeshShape) },
        { "hkSkinBinding", typeof(hkSkinBinding) },
        { "hkMultipleVertexBuffer::LockedElement", typeof(hkMultipleVertexBuffer.LockedElement) },
        { "hkMultipleVertexBuffer::ElementInfo", typeof(hkMultipleVertexBuffer.ElementInfo) },
        { "hkMultipleVertexBuffer::VertexBufferInfo", typeof(hkMultipleVertexBuffer.VertexBufferInfo) },
        { "hkMultipleVertexBuffer", typeof(hkMultipleVertexBuffer) },
        { "hkMemoryMeshVertexBuffer", typeof(hkMemoryMeshVertexBuffer) },
        { "hkMemoryMeshTexture", typeof(hkMemoryMeshTexture) },
        { "hkMemoryMeshSystem", typeof(hkMemoryMeshSystem) },
        { "hkMemoryMeshShape::Section", typeof(hkMemoryMeshShape.Section) },
        { "hkMemoryMeshShape", typeof(hkMemoryMeshShape) },
        { "hkMemoryMeshMaterial", typeof(hkMemoryMeshMaterial) },
        { "hkMemoryMeshBody", typeof(hkMemoryMeshBody) },
        { "hkIndexedTransformSet", typeof(hkIndexedTransformSet) },
        { "hkMeshBoneIndexMapping", typeof(hkMeshBoneIndexMapping) },
        { "hkDefaultCompoundMeshBody", typeof(hkDefaultCompoundMeshBody) },
        { "hkDefaultCompoundMeshShape::MeshSection", typeof(hkDefaultCompoundMeshShape.MeshSection) },
        { "hkDefaultCompoundMeshShape", typeof(hkDefaultCompoundMeshShape) },
        { "hkMassProperties", typeof(hkMassProperties) },
        { "hkCompressedMassProperties", typeof(hkCompressedMassProperties) },
        { "hkDiagonalizedMassProperties", typeof(hkDiagonalizedMassProperties) },
        { "hkcdDynamicTree::DynamicStorage<0, hkcdDynamicTree::AnisotropicMetric, hkcdDynamicTree::CodecRawUint>", typeof(hkcdDynamicTree.DynamicStorageAnisotropicMetricCodecRawUint) },
        { "hkcdDynamicTree::DynamicStorage<0, hkcdDynamicTree::AnisotropicMetric, hkcdDynamicTree::CodecRawUlong>", typeof(hkcdDynamicTree.DynamicStorageAnisotropicMetricCodecRawUlong) },
        { "hkcdDynamicTree::DynamicStorage<0, hkcdDynamicTree::AnisotropicMetric, hkcdDynamicTree::CodecInt16>", typeof(hkcdDynamicTree.DynamicStorageAnisotropicMetricCodecInt16) },
        { "hkcdDynamicTree::DynamicStorage<0, hkcdDynamicTree::AnisotropicMetric, hkcdDynamicTree::Codec32>", typeof(hkcdDynamicTree.DynamicStorageAnisotropicMetricCodec32) },
        { "hkcdDynamicTree::DynamicStorage<0, hkcdDynamicTree::AnisotropicMetric, hkcdDynamicTree::CodecRaw<unsigned int>>", typeof(hkcdDynamicTree.DynamicStorageAnisotropicMetricCodecRaw_Uint) },
        { "hkcdDynamicTree::DynamicStorage<0, hkcdDynamicTree::AnisotropicMetric, hkcdDynamicTree::CodecRaw<unsigned long long>>", typeof(hkcdDynamicTree.DynamicStorageAnisotropicMetricCodecRaw_Ulong) },
        { "hkcdDynamicTree::DefaultDynamicStorage<hkcdDynamicTree::CodecRaw<unsigned long long>>", typeof(hkcdDynamicTree.DefaultDynamicStorageCodecRaw_Ulong) },
        { "hkcdDynamicTree::DefaultDynamicStorage<hkcdDynamicTree::CodecRaw<unsigned int>>", typeof(hkcdDynamicTree.DefaultDynamicStorageCodecRaw_Uint) },
        { "hkcdDynamicTree::DefaultDynamicStorage<hkcdDynamicTree::Codec32>", typeof(hkcdDynamicTree.DefaultDynamicStorageCodec32) },
        { "hkcdDynamicTree::DefaultDynamicStorage<hkcdDynamicTree::CodecInt16>", typeof(hkcdDynamicTree.DefaultDynamicStorageCodecInt16) },
        { "hkcdDynamicTree::DefaultDynamicStorage<hkcdDynamicTree::CodecRawUlong>", typeof(hkcdDynamicTree.DefaultDynamicStorageCodecRawUlong) },
        { "hkcdDynamicTree::DefaultDynamicStorage<hkcdDynamicTree::CodecRawUint>", typeof(hkcdDynamicTree.DefaultDynamicStorageCodecRawUint) },
        { "hkcdDynamicTree::CodecRaw<hkUlong>", typeof(hkcdDynamicTree.CodecRaw<ulong>) },
        { "hkcdDynamicTree::CodecRaw<unsigned int>", typeof(hkcdDynamicTree.CodecRaw<uint>) },
        { "hkcdDynamicTree::CodecRaw<unsigned long long>", typeof(hkcdDynamicTree.CodecRaw<ulong>) },
        { "hkcdFourAabb", typeof(hkcdFourAabb) },
        { "hkcdCompressedAabbCodecs::UncompressedAabbCodec", typeof(hkcdCompressedAabbCodecs.UncompressedAabbCodec) },
        { "hkcdCompressedAabbCodecs::Aabb6BytesCodec", typeof(hkcdCompressedAabbCodecs.Aabb6BytesCodec) },
        { "hkcdCompressedAabbCodecs::Aabb5BytesCodec", typeof(hkcdCompressedAabbCodecs.Aabb5BytesCodec) },
        { "hkcdCompressedAabbCodecs::Aabb4BytesCodec", typeof(hkcdCompressedAabbCodecs.Aabb4BytesCodec) },
        { "hkcdCompressedAabbCodecs::CompressedAabbCodec", typeof(hkcdCompressedAabbCodecs.CompressedAabbCodec) },
        { "hkcdCompressedAabbCodecs::AabbCodecBase", typeof(hkcdCompressedAabbCodecs.AabbCodecBase) },
        { "hkcdStaticAabbTree", typeof(hkcdStaticAabbTree) },
        { "hkcdHiResStaticMeshTree::PrimitiveDataRun", typeof(hkcdHiResStaticMeshTree.PrimitiveDataRun) },
        { "hkcdDefaultStaticMeshTree::PrimitiveDataRun", typeof(hkcdDefaultStaticMeshTree.PrimitiveDataRun) },
        { "hkcdDefaultStaticMeshTree", typeof(hkcdDefaultStaticMeshTree) },
        { "hkcdDynamicTree::DynamicStorageInt16", typeof(hkcdDynamicTree.DynamicStorageInt16) },
        { "hkcdDynamicTree::DynamicStorage16", typeof(hkcdDynamicTree.DynamicStorage16) },
        { "hkcdDynamicTree::DynamicStorage32", typeof(hkcdDynamicTree.DynamicStorage32) },
        { "hkcdDynamicTree::DynamicStoragePtr", typeof(hkcdDynamicTree.DynamicStoragePtr) },
        { "hkcdDynamicTree::AnisotropicMetric", typeof(hkcdDynamicTree.AnisotropicMetric) },
        { "hkcdDynamicTree::BalanceMetric", typeof(hkcdDynamicTree.BalanceMetric) },
        { "hkcdDynamicTree::CentroidMetric", typeof(hkcdDynamicTree.CentroidMetric) },
        { "hkcdDynamicTree::CodecInt16::IntAabb", typeof(hkcdDynamicTree.CodecInt16.IntAabb) },
        { "hkcdDynamicTree::CodecInt16", typeof(hkcdDynamicTree.CodecInt16) },
        { "hkcdDynamicTree::CodecRawUint", typeof(hkcdDynamicTree.CodecRawUint) },
        { "hkcdDynamicTree::CodecRawUlong", typeof(hkcdDynamicTree.CodecRawUlong) },
        { "hkcdDynamicTree::Codec18", typeof(hkcdDynamicTree.Codec18) },
        { "hkcdDynamicTree::Codec32", typeof(hkcdDynamicTree.Codec32) },
        { "hkcdDynamicAabbTree", typeof(hkcdDynamicAabbTree) },
        { "hkcdDynamicAabbTree::Impl", typeof(hkcdDynamicAabbTree.Impl) },
        { "hkcdStaticAabbTree::Impl", typeof(hkcdStaticAabbTree.Impl) },
        { "hkTuple<unsigned int, unsigned int, void, void, void, void, void, void>", typeof(hkTuple2<uint, uint>) },
        { "hkTuple<hkUint32, hkUint32, void, void, void, void, void, void>", typeof(hkTuple2<uint, uint>) },
        { "hkTuple<hkPropertyId, hkReflect::Any, void, void, void, void, void, void>", typeof(hkTuple2<hkPropertyId, object>) },
        { "hkTuple<T*<hkReflect::Type>, T*<void>, void, void, void, void, void, void>", typeof(hkTuple2<IHavokObject?, object?>) },
        { "hkTuple<unsigned long long, T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>, void, void, void, void, void, void>", typeof(hkTuple2<ulong, hkHashMap<IHavokObject?, object?>?>) },
        { "hkTuple<hkUlong, T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>, void, void, void, void, void, void>", typeof(hkTuple2<ulong, hkHashMap<IHavokObject?, object?>?>) },
        { "hkTuple<int, hkaiNavMeshInstanceData::FaceDynUserEdgeBases, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiNavMeshInstanceData.FaceDynUserEdgeBases>) },
        { "hkTuple<int, hkaiDefaultDynamicUserEdgeSetInfo::Section, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiDefaultDynamicUserEdgeSetInfo.Section>) },
        { "hkTuple<int, hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiDynamicUserEdgeSetInfo.ExternalEdges?>) },
        { "hkTuple<int, hkaiDynamicUserEdgeSetInfo::Section, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiDynamicUserEdgeSetInfo.Section>) },
        { "hkTuple<int, hkRefPtr<hkaiStreamingSet>, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiStreamingSet?>) },
        { "hkTuple<int, int, void, void, void, void, void, void>", typeof(hkTuple2<int, int>) },
        { "hkTuple<int, hkaiModifiedSections::Section, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiModifiedSections.Section>) },
        { "hkTuple<hkHandle<unsigned int, -1>, hkaiDynamicUserEdgeSetInfo, void, void, void, void, void, void>", typeof(hkTuple2<hkHandle<uint>, hkaiDynamicUserEdgeSetInfo>) },
        { "hkTuple<int, hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>, void, void, void, void, void, void>", typeof(hkTuple2<int, List<hkaiNavMeshCutConfiguration.DynamicUserEdge>>) },
        { "hkTuple<int, hkaiNavMeshCutConfiguration::BigFaceInfo, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiNavMeshCutConfiguration.BigFaceInfo>) },
        { "hkTuple<int, hkaiNavMeshCutConfiguration::FaceInfo, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiNavMeshCutConfiguration.FaceInfo>) },
        { "hkTuple<hkaiIndex<hkInt32>, hkaiNavMeshInstanceData::FaceDynUserEdgeBases, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiNavMeshInstanceData.FaceDynUserEdgeBases>) },
        { "hkTuple<hkaiIndex<hkInt32>, hkaiDefaultDynamicUserEdgeSetInfo::Section, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiDefaultDynamicUserEdgeSetInfo.Section>) },
        { "hkTuple<hkaiIndex<hkInt32>, hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiDynamicUserEdgeSetInfo.ExternalEdges?>) },
        { "hkTuple<hkaiDynamicUserEdgeSetInfoBase::ClusterGraphEdge, int, void, void, void, void, void, void>", typeof(hkTuple2<hkaiDynamicUserEdgeSetInfoBase.ClusterGraphEdge, int>) },
        { "hkTuple<hkaiIndex<hkInt32>, hkaiDynamicUserEdgeSetInfo::Section, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiDynamicUserEdgeSetInfo.Section>) },
        { "hkTuple<hkaiIndex<hkInt32>, hkRefPtr<hkaiStreamingSet>, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiStreamingSet?>) },
        { "hkTuple<hkaiIndex<hkInt32>, int, void, void, void, void, void, void>", typeof(hkTuple2<int, int>) },
        { "hkTuple<hkaiIndex<hkInt32>, hkaiModifiedSections::Section, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiModifiedSections.Section>) },
        { "hkTuple<hkHandle<hkUint32, -1>, hkaiDynamicUserEdgeSetInfo, void, void, void, void, void, void>", typeof(hkTuple2<hkHandle<uint>, hkaiDynamicUserEdgeSetInfo>) },
        { "hkTuple<hkaiIndex<hkInt32>, hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>, void, void, void, void, void, void>", typeof(hkTuple2<int, List<hkaiNavMeshCutConfiguration.DynamicUserEdge>>) },
        { "hkTuple<hkaiIndex<hkInt32>, hkaiNavMeshCutConfiguration::BigFaceInfo, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiNavMeshCutConfiguration.BigFaceInfo>) },
        { "hkTuple<hkaiIndex<hkInt32>, hkaiNavMeshCutConfiguration::FaceInfo, void, void, void, void, void, void>", typeof(hkTuple2<int, hkaiNavMeshCutConfiguration.FaceInfo>) },
        { "hkTuple<void, void, void, void, void, void, void, void>", typeof(hkTuple0) },
        { "hkcdDynamicTree::Tree<hkcdDynamicTree::DefaultDynamicStorage<hkcdDynamicTree::CodecInt16>>", typeof(hkcdDynamicTree.TreeDefaultDynamicStorageCodecInt16) },
        { "hkcdDynamicTree::Tree<hkcdDynamicTree::DefaultDynamicStorage<hkcdDynamicTree::Codec32>>", typeof(hkcdDynamicTree.TreeDefaultDynamicStorageCodec32) },
        { "hkcdDynamicTree::Tree<hkcdDynamicTree::DefaultDynamicStorage<hkcdDynamicTree::CodecRaw<unsigned int>>>", typeof(hkcdDynamicTree.TreeDefaultDynamicStorageCodecRaw_Uint) },
        { "hkcdDynamicTree::Tree<hkcdDynamicTree::DefaultDynamicStorage<hkcdDynamicTree::CodecRaw<unsigned long long>>>", typeof(hkcdDynamicTree.TreeDefaultDynamicStorageCodecRaw_Ulong) },
        { "hkcdDynamicTree::Tree<hkcdDynamicTree::DynamicStorageInt16>", typeof(hkcdDynamicTree.TreeDynamicStorageInt16) },
        { "hkcdDynamicTree::Tree<hkcdDynamicTree::DynamicStorage16>", typeof(hkcdDynamicTree.TreeDynamicStorage16) },
        { "hkcdDynamicTree::Tree<hkcdDynamicTree::DynamicStorage32>", typeof(hkcdDynamicTree.TreeDynamicStorage32) },
        { "hkcdDynamicTree::Tree<hkcdDynamicTree::DynamicStoragePtr>", typeof(hkcdDynamicTree.TreeDynamicStoragePtr) },
        { "hkcdStaticTree::AabbTree<hkcdCompressedAabbCodecs::UncompressedAabbCodec>", typeof(hkcdStaticTree.AabbTree<hkcdCompressedAabbCodecs.UncompressedAabbCodec>) },
        { "hkcdStaticTree::AabbTree<hkcdCompressedAabbCodecs::Aabb6BytesCodec>", typeof(hkcdStaticTree.AabbTree<hkcdCompressedAabbCodecs.Aabb6BytesCodec>) },
        { "hkcdStaticTree::AabbTree<hkcdCompressedAabbCodecs::Aabb5BytesCodec>", typeof(hkcdStaticTree.AabbTree<hkcdCompressedAabbCodecs.Aabb5BytesCodec>) },
        { "hkcdStaticTree::AabbTree<hkcdCompressedAabbCodecs::Aabb4BytesCodec>", typeof(hkcdStaticTree.AabbTree<hkcdCompressedAabbCodecs.Aabb4BytesCodec>) },
        { "hkcdPlanarGeometryPrimitives::Collection<28>", typeof(hkcdPlanarGeometryPrimitives.Collection) },
        { "hkcdObb", typeof(hkcdObb) },
        { "hkcdManifold4", typeof(hkcdManifold4) },
        { "hkcdStaticTree::AabbUncompressedTree", typeof(hkcdStaticTree.AabbUncompressedTree) },
        { "hkcdStaticTree::Aabb6BytesTree", typeof(hkcdStaticTree.Aabb6BytesTree) },
        { "hkcdStaticTree::Aabb5BytesTree", typeof(hkcdStaticTree.Aabb5BytesTree) },
        { "hkcdStaticTree::Aabb4BytesTree", typeof(hkcdStaticTree.Aabb4BytesTree) },
        { "hkcdStaticTree::AabbTreeBase", typeof(hkcdStaticTree.AabbTreeBase) },
        { "hkcdStaticMeshTree::Base", typeof(hkcdStaticMeshTree.Base) },
        { "hkcdStaticMeshTree::Connectivity::SectionHeader", typeof(hkcdStaticMeshTree.Connectivity.SectionHeader) },
        { "hkcdStaticMeshTree::Connectivity", typeof(hkcdStaticMeshTree.Connectivity) },
        { "hkcdStaticMeshTree::Primitive", typeof(hkcdStaticMeshTree.Primitive) },
        { "hkcdStaticMeshTree::Section", typeof(hkcdStaticMeshTree.Section) },
        { "hkcdSimdTree::Dynamic::NodeData", typeof(hkcdSimdTree.Dynamic.NodeData) },
        { "hkcdSimdTree::Dynamic", typeof(hkcdSimdTree.Dynamic) },
        { "hkcdSimdTree::Node", typeof(hkcdSimdTree.Node) },
        { "hkcdSimdTree", typeof(hkcdSimdTree) },
        { "hkcdPlanarEntity::PlanesCollection", typeof(hkcdPlanarEntity.PlanesCollection) },
        { "hkcdPlanarEntity", typeof(hkcdPlanarEntity) },
        { "hkcdPlanarSolid::Node", typeof(hkcdPlanarSolid.Node) },
        { "hkcdPlanarSolid::NodeStorage", typeof(hkcdPlanarSolid.NodeStorage) },
        { "hkcdPlanarSolid", typeof(hkcdPlanarSolid) },
        { "hkcdPlanarGeometryPrimitives::Plane::Int64Vector4", typeof(hkcdPlanarGeometryPrimitives.Plane.Int64Vector4) },
        { "hkcdPlanarGeometryPrimitives::Plane", typeof(hkcdPlanarGeometryPrimitives.Plane) },
        { "hkcdPlanarGeometryPolygonCollection::Material", typeof(hkcdPlanarGeometryPolygonCollection.Material) },
        { "hkcdPlanarGeometryPolygonCollection", typeof(hkcdPlanarGeometryPolygonCollection) },
        { "hkcdPlanarGeometryPlanesCollection", typeof(hkcdPlanarGeometryPlanesCollection) },
        { "hkcdPlanarGeometry", typeof(hkcdPlanarGeometry) },
        { "hkcdPlanarCsgOperand", typeof(hkcdPlanarCsgOperand) },
        { "hkcdDynamicTree::DefaultTreeInt16", typeof(hkcdDynamicTree.DefaultTreeInt16) },
        { "hkcdDynamicTree::DefaultTree32", typeof(hkcdDynamicTree.DefaultTree32) },
        { "hkcdDynamicTree::DefaultTree48", typeof(hkcdDynamicTree.DefaultTree48) },
        { "hkcdDynamicTree::DefaultTreePtr", typeof(hkcdDynamicTree.DefaultTreePtr) },
        { "hkcdFractureEngine", typeof(hkcdFractureEngine) },
        { "hkMapOperations<unsigned long long>", typeof(hkMapOperations) },
        { "hkMapOperations<unsigned int>", typeof(hkMapOperations) },
        { "hkMapOperations<hkUint64>", typeof(hkMapOperations) },
        { "hkMapOperations<hkUint32>", typeof(hkMapOperations) },
        { "hkMapOperations<hkIntRealPair>", typeof(hkMapOperations) },
        { "hkOffsetBitFieldStorage<hkArray<unsigned int, hkContainerHeapAllocator>>", typeof(hkOffsetBitFieldStorage<List<uint>>) },
        { "hkOffsetBitFieldStorage<hkArray<hkUint32, hkContainerHeapAllocator>>", typeof(hkOffsetBitFieldStorage<List<uint>>) },
        { "hkBitFieldStorage<hkArray<unsigned int, hkContainerHeapAllocator>>", typeof(hkBitFieldStorage<List<uint>>) },
        { "hkBitFieldStorage<hkArray<hkUint32, hkContainerHeapAllocator>>", typeof(hkBitFieldStorage<List<uint>>) },
        { "hkHashMapDetail::MapTuple<hkPropertyId, hkReflect::Any>", typeof(hkHashMapDetail.MapTuple<hkPropertyId, object>) },
        { "hkHashMapDetail::MapTuple<T*<hkReflect::Type>, T*<void>>", typeof(hkHashMapDetail.MapTuple<IHavokObject?, object?>) },
        { "hkHashMapDetail::MapTuple<unsigned long long, T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>>", typeof(hkHashMapDetail.MapTuple<ulong, hkHashMap<IHavokObject?, object?>?>) },
        { "hkHashMapDetail::MapTuple<hkUlong, T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>>", typeof(hkHashMapDetail.MapTuple<ulong, hkHashMap<IHavokObject?, object?>?>) },
        { "hkHashMapDetail::MapTuple<int, hkaiNavMeshInstanceData::FaceDynUserEdgeBases>", typeof(hkHashMapDetail.MapTuple<int, hkaiNavMeshInstanceData.FaceDynUserEdgeBases>) },
        { "hkHashMapDetail::MapTuple<int, hkaiDefaultDynamicUserEdgeSetInfo::Section>", typeof(hkHashMapDetail.MapTuple<int, hkaiDefaultDynamicUserEdgeSetInfo.Section>) },
        { "hkHashMapDetail::MapTuple<int, hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>>", typeof(hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.ExternalEdges?>) },
        { "hkHashMapDetail::MapTuple<int, hkaiDynamicUserEdgeSetInfo::Section>", typeof(hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.Section>) },
        { "hkHashMapDetail::MapTuple<int, hkRefPtr<hkaiStreamingSet>>", typeof(hkHashMapDetail.MapTuple<int, hkaiStreamingSet?>) },
        { "hkHashMapDetail::MapTuple<int, int>", typeof(hkHashMapDetail.MapTuple<int, int>) },
        { "hkHashMapDetail::MapTuple<int, hkaiModifiedSections::Section>", typeof(hkHashMapDetail.MapTuple<int, hkaiModifiedSections.Section>) },
        { "hkHashMapDetail::MapTuple<hkHandle<unsigned int, -1>, hkaiDynamicUserEdgeSetInfo>", typeof(hkHashMapDetail.MapTuple<hkHandle<uint>, hkaiDynamicUserEdgeSetInfo>) },
        { "hkHashMapDetail::MapTuple<int, hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>>", typeof(hkHashMapDetail.MapTuple<int, List<hkaiNavMeshCutConfiguration.DynamicUserEdge>>) },
        { "hkHashMapDetail::MapTuple<int, hkaiNavMeshCutConfiguration::BigFaceInfo>", typeof(hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.BigFaceInfo>) },
        { "hkHashMapDetail::MapTuple<int, hkaiNavMeshCutConfiguration::FaceInfo>", typeof(hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.FaceInfo>) },
        { "hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiNavMeshInstanceData::FaceDynUserEdgeBases>", typeof(hkHashMapDetail.MapTuple<int, hkaiNavMeshInstanceData.FaceDynUserEdgeBases>) },
        { "hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiDefaultDynamicUserEdgeSetInfo::Section>", typeof(hkHashMapDetail.MapTuple<int, hkaiDefaultDynamicUserEdgeSetInfo.Section>) },
        { "hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>>", typeof(hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.ExternalEdges?>) },
        { "hkHashMapDetail::MapTuple<hkaiDynamicUserEdgeSetInfoBase::ClusterGraphEdge, int>", typeof(hkHashMapDetail.MapTuple<hkaiDynamicUserEdgeSetInfoBase.ClusterGraphEdge, int>) },
        { "hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiDynamicUserEdgeSetInfo::Section>", typeof(hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.Section>) },
        { "hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkRefPtr<hkaiStreamingSet>>", typeof(hkHashMapDetail.MapTuple<int, hkaiStreamingSet?>) },
        { "hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, int>", typeof(hkHashMapDetail.MapTuple<int, int>) },
        { "hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiModifiedSections::Section>", typeof(hkHashMapDetail.MapTuple<int, hkaiModifiedSections.Section>) },
        { "hkHashMapDetail::MapTuple<hkHandle<hkUint32, -1>, hkaiDynamicUserEdgeSetInfo>", typeof(hkHashMapDetail.MapTuple<hkHandle<uint>, hkaiDynamicUserEdgeSetInfo>) },
        { "hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>>", typeof(hkHashMapDetail.MapTuple<int, List<hkaiNavMeshCutConfiguration.DynamicUserEdge>>) },
        { "hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiNavMeshCutConfiguration::BigFaceInfo>", typeof(hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.BigFaceInfo>) },
        { "hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiNavMeshCutConfiguration::FaceInfo>", typeof(hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.FaceInfo>) },
        { "TestContainerThingEnd<float, 2>", typeof(TestContainerThingEnd<float>) },
        { "TestContainerThingEnd<int, 2>", typeof(TestContainerThingEnd<int>) },
        { "TestContainerThingEnd<hkReal, 2>", typeof(TestContainerThingEnd<float>) },
        { "TestContainerThingEnd<hkInt32, 2>", typeof(TestContainerThingEnd<int>) },
        { "TestContainerThingStart<int>", typeof(TestContainerThingStart<int>) },
        { "TestContainerThingStart<hkInt32>", typeof(TestContainerThingStart<int>) },
        { "hk::ValueAttribute<unsigned long long>", typeof(hk.ValueAttribute<ulong>) },
        { "hk::ValueAttribute<unsigned short>", typeof(hk.ValueAttribute<ushort>) },
        { "hk::ValueAttribute<T*<unsigned short>>", typeof(hk.ValueAttribute<ushort?>) },
        { "hk::ValueAttribute<unsigned int>", typeof(hk.ValueAttribute<uint>) },
        { "hk::ValueAttribute<hk::UiTypeEnum>", typeof(hk.ValueAttribute<hk.UiTypeEnum>) },
        { "hk::ValueAttribute<hkColor::Argb>", typeof(hk.ValueAttribute<Color>) },
        { "hk::ValueAttribute<hk::ValueArray<hk::FileDialogFilter>>", typeof(hk.ValueAttribute<List<hk.FileDialogFilter>>) },
        { "hk::ValueAttribute<hk::EditingTypeEnum>", typeof(hk.ValueAttribute<hk.EditingTypeEnum>) },
        { "hk::ValueAttribute<hk::ComponentDisplayUpdateOnChangeOptions::Enum>", typeof(hk.ValueAttribute<hk.ComponentDisplayUpdateOnChangeOptions.Enum>) },
        { "hk::ValueAttribute<float>", typeof(hk.ValueAttribute<float>) },
        { "hk::ValueAttribute<hkReflect::QualifiedType<hkReflect::Type>>", typeof(hk.ValueAttribute<IHavokObject?>) },
        { "hk::ValueAttribute<bool>", typeof(hk.ValueAttribute<bool>) },
        { "hk::ValueAttribute<hke::PublicFieldPin::Enum>", typeof(hk.ValueAttribute<hke.PublicFieldPin.Enum>) },
        { "hk::ValueAttribute<hke::ConstTypes::Enum>", typeof(hk.ValueAttribute<hke.ConstTypes.Enum>) },
        { "hk::ValueAttribute<hkUlong>", typeof(hk.ValueAttribute<ulong>) },
        { "hk::ValueAttribute<T*<hkBaseObject>>", typeof(hk.ValueAttribute<hkBaseObject?>) },
        { "hk::ValueAttribute<hkUint16>", typeof(hk.ValueAttribute<ushort>) },
        { "hk::ValueAttribute<int>", typeof(hk.ValueAttribute<int>) },
        { "hk::ValueAttribute<T*<hkReflect::Type>>", typeof(hk.ValueAttribute<IHavokObject?>) },
        { "hk::ValueAttribute<T*<hkUint16>>", typeof(hk.ValueAttribute<ushort?>) },
        { "hk::ValueAttribute<hk::ValueArray<const char*>>", typeof(hk.ValueAttribute<List<string?>>) },
        { "hk::ValueAttribute<hkms::AccumulateOp::Enum>", typeof(hk.ValueAttribute<hkms.AccumulateOp.Enum>) },
        { "hk::ValueAttribute<double>", typeof(hk.ValueAttribute<double>) },
        { "hk::ValueAttribute<const char*>", typeof(hk.ValueAttribute<string?>) },
        { "hk::ValueAttribute<hkUint32>", typeof(hk.ValueAttribute<uint>) },
        { "hkSet<unsigned long long, hkContainerHeapAllocator, hkMapOperations<unsigned long long>>", typeof(hkSet<ulong, hkContainerHeapAllocator>) },
        { "hkSet<unsigned int, hkContainerHeapAllocator, hkMapOperations<unsigned int>>", typeof(hkSet<uint, hkContainerHeapAllocator>) },
        { "hkSet<hkIntRealPair, hkContainerHeapAllocator, hkMapOperations<hkIntRealPair>>", typeof(hkSet<hkIntRealPair, hkContainerHeapAllocator>) },
        { "hkSet<hkUint64, hkContainerHeapAllocator, hkMapOperations<hkUint64>>", typeof(hkSet<ulong, hkContainerHeapAllocator>) },
        { "hkSet<hkUint32, hkContainerHeapAllocator, hkMapOperations<hkUint32>>", typeof(hkSet<uint, hkContainerHeapAllocator>) },
        { "hkBitFieldBase<hkOffsetBitFieldStorage<hkArray<unsigned int, hkContainerHeapAllocator>>>", typeof(hkBitFieldBase<hkOffsetBitFieldStorage<List<uint>>>) },
        { "hkBitFieldBase<hkBitFieldStorage<hkArray<unsigned int, hkContainerHeapAllocator>>>", typeof(hkBitFieldBase<hkBitFieldStorage<List<uint>>>) },
        { "hkBitFieldBase<hkOffsetBitFieldStorage<hkArray<hkUint32, hkContainerHeapAllocator>>>", typeof(hkBitFieldBase<hkOffsetBitFieldStorage<List<uint>>>) },
        { "hkBitFieldBase<hkBitFieldStorage<hkArray<hkUint32, hkContainerHeapAllocator>>>", typeof(hkBitFieldBase<hkBitFieldStorage<List<uint>>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkPropertyId, hkReflect::Any>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<hkPropertyId, object>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<T*<hkReflect::Type>, T*<void>>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<IHavokObject?, object?>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<unsigned long long, T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<ulong, hkHashMap<IHavokObject?, object?>?>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkUlong, T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<ulong, hkHashMap<IHavokObject?, object?>?>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<int, hkaiNavMeshInstanceData::FaceDynUserEdgeBases>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiNavMeshInstanceData.FaceDynUserEdgeBases>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<int, hkaiDefaultDynamicUserEdgeSetInfo::Section>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiDefaultDynamicUserEdgeSetInfo.Section>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<int, hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.ExternalEdges?>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<int, hkaiDynamicUserEdgeSetInfo::Section>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.Section>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<int, hkRefPtr<hkaiStreamingSet>>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiStreamingSet?>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<int, int>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, int>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<int, hkaiModifiedSections::Section>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiModifiedSections.Section>>) },
        { "hkHashBase<int>", typeof(hkHashBase<int>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkHandle<unsigned int, -1>, hkaiDynamicUserEdgeSetInfo>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<hkHandle<uint>, hkaiDynamicUserEdgeSetInfo>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<int, hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, List<hkaiNavMeshCutConfiguration.DynamicUserEdge>>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<int, hkaiNavMeshCutConfiguration::BigFaceInfo>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.BigFaceInfo>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<int, hkaiNavMeshCutConfiguration::FaceInfo>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.FaceInfo>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiNavMeshInstanceData::FaceDynUserEdgeBases>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiNavMeshInstanceData.FaceDynUserEdgeBases>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiDefaultDynamicUserEdgeSetInfo::Section>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiDefaultDynamicUserEdgeSetInfo.Section>>) },
        { "hkHashBase<hkaiDynamicUserEdgeSetInfo::UserEdgePair>", typeof(hkHashBase<hkaiDynamicUserEdgeSetInfo.UserEdgePair>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.ExternalEdges?>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkaiDynamicUserEdgeSetInfoBase::ClusterGraphEdge, int>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<hkaiDynamicUserEdgeSetInfoBase.ClusterGraphEdge, int>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiDynamicUserEdgeSetInfo::Section>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.Section>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkRefPtr<hkaiStreamingSet>>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiStreamingSet?>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, int>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, int>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiModifiedSections::Section>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiModifiedSections.Section>>) },
        { "hkHashBase<hkaiIndex<hkInt32>>", typeof(hkHashBase<int>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkHandle<hkUint32, -1>, hkaiDynamicUserEdgeSetInfo>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<hkHandle<uint>, hkaiDynamicUserEdgeSetInfo>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, List<hkaiNavMeshCutConfiguration.DynamicUserEdge>>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiNavMeshCutConfiguration::BigFaceInfo>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.BigFaceInfo>>) },
        { "hkHashBase<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiNavMeshCutConfiguration::FaceInfo>>", typeof(hkHashBase<hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.FaceInfo>>) },
        { "hkPtrAndInt<hkPropertyDesc, unsigned int, 1>", typeof(hkPtrAndInt<hkPropertyDesc>) },
        { "hkHashMap<hkPropertyId, hkReflect::Any>", typeof(hkHashMap<hkPropertyId, object>) },
        { "hkHashMap<T*<hkReflect::Type>, T*<void>>", typeof(hkHashMap<IHavokObject?, object?>) },
        { "hkHashMap<unsigned long long, T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>>", typeof(hkHashMap<ulong, hkHashMap<IHavokObject?, object?>?>) },
        { "hkHashMap<hkUlong, T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>>", typeof(hkHashMap<ulong, hkHashMap<IHavokObject?, object?>?>) },
        { "hkHashMap<int, hkaiNavMeshInstanceData::FaceDynUserEdgeBases>", typeof(hkHashMap<int, hkaiNavMeshInstanceData.FaceDynUserEdgeBases>) },
        { "hkHashMap<int, hkaiDefaultDynamicUserEdgeSetInfo::Section>", typeof(hkHashMap<int, hkaiDefaultDynamicUserEdgeSetInfo.Section>) },
        { "hkHashMap<int, hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>>", typeof(hkHashMap<int, hkaiDynamicUserEdgeSetInfo.ExternalEdges?>) },
        { "hkHashMap<int, hkaiDynamicUserEdgeSetInfo::Section>", typeof(hkHashMap<int, hkaiDynamicUserEdgeSetInfo.Section>) },
        { "hkHashMap<int, hkRefPtr<hkaiStreamingSet>>", typeof(hkHashMap<int, hkaiStreamingSet?>) },
        { "hkHashMap<int, int>", typeof(hkHashMap<int, int>) },
        { "hkHashMap<int, hkaiModifiedSections::Section>", typeof(hkHashMap<int, hkaiModifiedSections.Section>) },
        { "hkHashMap<hkHandle<unsigned int, -1>, hkaiDynamicUserEdgeSetInfo>", typeof(hkHashMap<hkHandle<uint>, hkaiDynamicUserEdgeSetInfo>) },
        { "hkHashMap<int, hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>>", typeof(hkHashMap<int, List<hkaiNavMeshCutConfiguration.DynamicUserEdge>>) },
        { "hkHashMap<int, hkaiNavMeshCutConfiguration::BigFaceInfo>", typeof(hkHashMap<int, hkaiNavMeshCutConfiguration.BigFaceInfo>) },
        { "hkHashMap<int, hkaiNavMeshCutConfiguration::FaceInfo>", typeof(hkHashMap<int, hkaiNavMeshCutConfiguration.FaceInfo>) },
        { "hkHashMap<hkaiIndex<hkInt32>, hkaiNavMeshInstanceData::FaceDynUserEdgeBases>", typeof(hkHashMap<int, hkaiNavMeshInstanceData.FaceDynUserEdgeBases>) },
        { "hkHashMap<hkaiIndex<hkInt32>, hkaiDefaultDynamicUserEdgeSetInfo::Section>", typeof(hkHashMap<int, hkaiDefaultDynamicUserEdgeSetInfo.Section>) },
        { "hkHashMap<hkaiIndex<hkInt32>, hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>>", typeof(hkHashMap<int, hkaiDynamicUserEdgeSetInfo.ExternalEdges?>) },
        { "hkHashMap<hkaiDynamicUserEdgeSetInfoBase::ClusterGraphEdge, int>", typeof(hkHashMap<hkaiDynamicUserEdgeSetInfoBase.ClusterGraphEdge, int>) },
        { "hkHashMap<hkaiIndex<hkInt32>, hkaiDynamicUserEdgeSetInfo::Section>", typeof(hkHashMap<int, hkaiDynamicUserEdgeSetInfo.Section>) },
        { "hkHashMap<hkaiIndex<hkInt32>, hkRefPtr<hkaiStreamingSet>>", typeof(hkHashMap<int, hkaiStreamingSet?>) },
        { "hkHashMap<hkaiIndex<hkInt32>, int>", typeof(hkHashMap<int, int>) },
        { "hkHashMap<hkaiIndex<hkInt32>, hkaiModifiedSections::Section>", typeof(hkHashMap<int, hkaiModifiedSections.Section>) },
        { "hkHashMap<hkHandle<hkUint32, -1>, hkaiDynamicUserEdgeSetInfo>", typeof(hkHashMap<hkHandle<uint>, hkaiDynamicUserEdgeSetInfo>) },
        { "hkHashMap<hkaiIndex<hkInt32>, hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>>", typeof(hkHashMap<int, List<hkaiNavMeshCutConfiguration.DynamicUserEdge>>) },
        { "hkHashMap<hkaiIndex<hkInt32>, hkaiNavMeshCutConfiguration::BigFaceInfo>", typeof(hkHashMap<int, hkaiNavMeshCutConfiguration.BigFaceInfo>) },
        { "hkHashMap<hkaiIndex<hkInt32>, hkaiNavMeshCutConfiguration::FaceInfo>", typeof(hkHashMap<int, hkaiNavMeshCutConfiguration.FaceInfo>) },
        { "hkFourTransposedPointsImpl<double>", typeof(hkFourTransposedPointsImplDouble) },
        { "hkFourTransposedPointsImpl<float>", typeof(hkFourTransposedPointsImplFloat) },
        { "hkWeakPtrTest::Bar", typeof(hkWeakPtrTest.Bar) },
        { "hkWeakPtrTest::Foo", typeof(hkWeakPtrTest.Foo) },
        { "hkScopedPtrTest::Foo", typeof(hkScopedPtrTest.Foo) },
        { "PropertyBagTest::ComplexProperty", typeof(PropertyBagTest.ComplexProperty) },
        { "PropertyBagTest::GraphObject", typeof(PropertyBagTest.GraphObject) },
        { "AfterReflectNewTestObj", typeof(AfterReflectNewTestObj) },
        { "TestTemplateTopLevelEnd", typeof(TestTemplateTopLevelEnd) },
        { "TestTemplateTopLevelStart", typeof(TestTemplateTopLevelStart) },
        { "castTest::WithInterfaces", typeof(castTest.WithInterfaces) },
        { "castTest::Interface2", typeof(castTest.Interface2) },
        { "castTest::Interface1", typeof(castTest.Interface1) },
        { "castTest::Interface0", typeof(castTest.Interface0) },
        { "castTest::InterfaceOtherBase", typeof(castTest.InterfaceOtherBase) },
        { "castTest::InterfaceBase", typeof(castTest.InterfaceBase) },
        { "castTest::NonLeaf", typeof(castTest.NonLeaf) },
        { "castTest::OtherLeaf", typeof(castTest.OtherLeaf) },
        { "castTest::Leaf", typeof(castTest.Leaf) },
        { "castTest::Root", typeof(castTest.Root) },
        { "TypeRegistryTest::TypedefChild", typeof(TypeRegistryTest.TypedefChild) },
        { "TypeRegistryTest::TypedefTest", typeof(TypeRegistryTest.TypedefTest) },
        { "TypeRegistryTest::Ref", typeof(TypeRegistryTest.Ref) },
        { "hkUFloat8", typeof(hkUFloat8) },
        { "hkResult", typeof(hkResult) },
        { "hkFloat16", typeof(hkFloat16) },
        { "hkViewport", typeof(hkViewport) },
        { "hkUuidObject", typeof(hkUuidObject) },
        { "hkUuid", typeof(hkUuid) },
        { "hkTrait::Divides<hkVector4f>", typeof(hkTrait.Divides) },
        { "hkSimpleProperty", typeof(hkSimpleProperty) },
        { "hkSimplePropertyValue", typeof(hkSimplePropertyValue) },
        { "hkRefCountedProperties::Entry", typeof(hkRefCountedProperties.Entry) },
        { "hkRefCountedProperties", typeof(hkRefCountedProperties) },
        { "hkPropertyId", typeof(hkPropertyId) },
        { "hkPropertyDesc", typeof(hkPropertyDesc) },
        { "hkPropertyFlags", typeof(hkPropertyFlags) },
        { "hkDefaultPropertyBag", typeof(hkDefaultPropertyBag) },
        { "hkContactPoint", typeof(hkContactPoint) },
        { "hkGeometry::Triangle", typeof(hkGeometry.Triangle) },
        { "hkGeometry", typeof(hkGeometry) },
        { "hkSphere", typeof(hkSphere) },
        { "hkPlane", typeof(hkPlane) },
        { "hkSimpleLocalFrame", typeof(hkSimpleLocalFrame) },
        { "hkLocalFrameGroup", typeof(hkLocalFrameGroup) },
        { "hkLocalFrame", typeof(hkLocalFrame) },
        { "hkFrustum", typeof(hkFrustum) },
        { "hkAabbHalf", typeof(hkAabbHalf) },
        { "hkAabbUint32", typeof(hkAabbUint32) },
        { "hkAabb", typeof(hkAabb) },
        { "hkAabb24_16_24", typeof(hkAabb24_16_24) },
        { "hkAabb16", typeof(hkAabb16) },
        { "hkColorUbLinear", typeof(hkColorUbLinear) },
        { "hkColorUbGamma", typeof(hkColorUbGamma) },
        { "hkColorUbBase", typeof(hkColorUbBase) },
        { "hkColor", typeof(hkColor) },
        { "hkReferencedTask", typeof(hkReferencedTask) },
        { "hkTask", typeof(hkTask) },
        { "hkThreadPool", typeof(hkThreadPool) },
        { "hkCpuThreadPool", typeof(hkCpuThreadPool) },
        { "hkAsyncThreadPool::Cinfo", typeof(hkAsyncThreadPool.Cinfo) },
        { "hkInetAddr", typeof(hkInetAddr) },
        { "hkDllModule", typeof(hkDllModule) },
        { "hkSerialize::CompatTypeParentInfo::Parent", typeof(hkSerialize.CompatTypeParentInfo.Parent) },
        { "hkSerialize::CompatTypeParentInfo", typeof(hkSerialize.CompatTypeParentInfo) },
        { "hkRootLevelContainer::NamedVariant", typeof(hkRootLevelContainer.NamedVariant) },
        { "hkRootLevelContainer", typeof(hkRootLevelContainer) },
        { "hkResource", typeof(hkResource) },
        { "hkObjectResource", typeof(hkObjectResource) },
        { "hkMemoryResourceContainer", typeof(hkMemoryResourceContainer) },
        { "hkMemoryResourceHandle::ExternalLink", typeof(hkMemoryResourceHandle.ExternalLink) },
        { "hkMemoryResourceHandle", typeof(hkMemoryResourceHandle) },
        { "hkResourceContainer", typeof(hkResourceContainer) },
        { "hkResourceHandle", typeof(hkResourceHandle) },
        { "hkResourceBase", typeof(hkResourceBase) },
        { "hkSerialize::PersistentIdProvider", typeof(hkSerialize.PersistentIdProvider) },
        { "hkSerialize::Detail::IdFromPointer", typeof(hkSerialize.Detail.IdFromPointer) },
        { "hkSerialize::Note::Export", typeof(hkSerialize.Note.Export) },
        { "hkSerialize::Note::Import", typeof(hkSerialize.Note.Import) },
        { "hkReflect::Detail::SyntheticUtil", typeof(hkReflect.Detail.SyntheticUtil) },
        { "hkReflect::PropertyFieldDecl", typeof(hkReflect.PropertyFieldDecl) },
        { "hkReflect::DataFieldDecl", typeof(hkReflect.DataFieldDecl) },
        { "hkReflect::FieldDecl", typeof(hkReflect.FieldDecl) },
        { "hkReflect::Decl", typeof(hkReflect.Decl) },
        { "hkReflect::TypeName", typeof(hkReflect.TypeName) },
        { "hkReflect::Detail::SizeAlign", typeof(hkReflect.Detail.SizeAlign) },
        { "hk::Ui_NullValidation", typeof(hk.Ui_NullValidation) },
        { "hk::Ui_Order", typeof(hk.Ui_Order) },
        { "hk::Ui_InGroupHeader", typeof(hk.Ui_InGroupHeader) },
        { "hk::Ui_CombinedEditor", typeof(hk.Ui_CombinedEditor) },
        { "hk::Ui_PackedGroup", typeof(hk.Ui_PackedGroup) },
        { "hk::Ui_HorizontalGroup", typeof(hk.Ui_HorizontalGroup) },
        { "hk::Ui_ShowForSharedWorld", typeof(hk.Ui_ShowForSharedWorld) },
        { "hk::Ui_RequiredRendererFeatures", typeof(hk.Ui_RequiredRendererFeatures) },
        { "hk::Ui_Expert", typeof(hk.Ui_Expert) },
        { "hk::Ui_ConstTarget", typeof(hk.Ui_ConstTarget) },
        { "hk::Ui_ReadOnly", typeof(hk.Ui_ReadOnly) },
        { "hk::Ui_MinInterval", typeof(hk.Ui_MinInterval) },
        { "hk::TagSuggestionCallback", typeof(hk.TagSuggestionCallback) },
        { "hk::Ui_NumSliderSteps", typeof(hk.Ui_NumSliderSteps) },
        { "hk::Ui_ShowManipulator", typeof(hk.Ui_ShowManipulator) },
        { "hk::Ui_DefineFieldOrder", typeof(hk.Ui_DefineFieldOrder) },
        { "hk::Ui_Group", typeof(hk.Ui_Group) },
        { "hk::CanCreateInRuleEditor", typeof(hk.CanCreateInRuleEditor) },
        { "hk::CanCreateInToolAsAsset", typeof(hk.CanCreateInToolAsAsset) },
        { "hk::VisibleIfFunc", typeof(hk.VisibleIfFunc) },
        { "hk::ComponentAppliesToScenesOnly", typeof(hk.ComponentAppliesToScenesOnly) },
        { "hk::ComponentAppliesToScenes", typeof(hk.ComponentAppliesToScenes) },
        { "hk::NoDefaultNodeCreator", typeof(hk.NoDefaultNodeCreator) },
        { "hk::NoDefaultComponentCreator", typeof(hk.NoDefaultComponentCreator) },
        { "hk::VisibleIf", typeof(hk.VisibleIf) },
        { "hk::EditableIf", typeof(hk.EditableIf) },
        { "hk::IdentityValue", typeof(hk.IdentityValue) },
        { "hk::StepPerPixel", typeof(hk.StepPerPixel) },
        { "hk::Format", typeof(hk.Format) },
        { "hk::Ui_UnitOfMeasure", typeof(hk.Ui_UnitOfMeasure) },
        { "hk::Ui_FixedSize", typeof(hk.Ui_FixedSize) },
        { "hk::Ui_DerivedAsset", typeof(hk.Ui_DerivedAsset) },
        { "hk::Ui_Show", typeof(hk.Ui_Show) },
        { "hk::Ui_Type", typeof(hk.Ui_Type) },
        { "hk::Ui_Name_SiblingFieldName", typeof(hk.Ui_Name_SiblingFieldName) },
        { "hk::Ui_Name_FieldName", typeof(hk.Ui_Name_FieldName) },
        { "hk::Ui_VectorComponentName", typeof(hk.Ui_VectorComponentName) },
        { "hk::Ui_SuppressContinuousUpdate", typeof(hk.Ui_SuppressContinuousUpdate) },
        { "hk::Ui_Tooltip", typeof(hk.Ui_Tooltip) },
        { "hk::Ui_FieldName", typeof(hk.Ui_FieldName) },
        { "hk::Ui_TypeNameIsSameAs", typeof(hk.Ui_TypeNameIsSameAs) },
        { "hk::Ui_TypeName", typeof(hk.Ui_TypeName) },
        { "hk::Ui_DisplayColor", typeof(hk.Ui_DisplayColor) },
        { "hk::Ui_Category", typeof(hk.Ui_Category) },
        { "hk::Ui_Icon", typeof(hk.Ui_Icon) },
        { "hk::Ui_CanSelectComponent", typeof(hk.Ui_CanSelectComponent) },
        { "hk::Ui_CanSelectNode", typeof(hk.Ui_CanSelectNode) },
        { "hk::Ui_LocalComponentReference", typeof(hk.Ui_LocalComponentReference) },
        { "hk::Ui_PathToFile", typeof(hk.Ui_PathToFile) },
        { "hk::Ui_PathToFolder", typeof(hk.Ui_PathToFolder) },
        { "hk::Ui_LocalReference", typeof(hk.Ui_LocalReference) },
        { "hk::Ui_Nullable", typeof(hk.Ui_Nullable) },
        { "hk::Ui_EditingType", typeof(hk.Ui_EditingType) },
        { "hk::Ui_Navigable", typeof(hk.Ui_Navigable) },
        { "hk::Ui_NotExpandable", typeof(hk.Ui_NotExpandable) },
        { "hk::Ui_Hidden", typeof(hk.Ui_Hidden) },
        { "hk::Ui_Inlined", typeof(hk.Ui_Inlined) },
        { "hk::FileDialogFilter", typeof(hk.FileDialogFilter) },
        { "hk::Ui_NoLocalCopy", typeof(hk.Ui_NoLocalCopy) },
        { "hk::Key", typeof(hk.Key) },
        { "hk::ExposeAsFlags", typeof(hk.ExposeAsFlags) },
        { "hk::ExposeAsMap", typeof(hk.ExposeAsMap) },
        { "hk::Expose", typeof(hk.Expose) },
        { "hk::ExposeBase::Dynamic", typeof(hk.ExposeBase.Dynamic) },
        { "hk::ExposeBase", typeof(hk.ExposeBase) },
        { "hk::UpdateComponentDisplayOnChange", typeof(hk.UpdateComponentDisplayOnChange) },
        { "hk::ComponentDisplayDefault", typeof(hk.ComponentDisplayDefault) },
        { "hk::ComponentDisplay", typeof(hk.ComponentDisplay) },
        { "hk::MaxWorldSpaceIconSize", typeof(hk.MaxWorldSpaceIconSize) },
        { "hk::IconSize", typeof(hk.IconSize) },
        { "hk::Icon", typeof(hk.Icon) },
        { "hk::SceneProperty", typeof(hk.SceneProperty) },
        { "hk::RPC::OnAfterSerialize", typeof(hk.RPC.OnAfterSerialize) },
        { "hk::RPC::PublisherType", typeof(hk.RPC.PublisherType) },
        { "hk::RPC::ExecutionFlags", typeof(hk.RPC.ExecutionFlags) },
        { "hk::RPC::Allowed", typeof(hk.RPC.Allowed) },
        { "hke::CanAddToNode", typeof(hke.CanAddToNode) },
        { "hke::CanAddToParent", typeof(hke.CanAddToParent) },
        { "hke::NoThumbnail", typeof(hke.NoThumbnail) },
        { "hke::ComponentWithNativeVisualization", typeof(hke.ComponentWithNativeVisualization) },
        { "hke::ComponentWithRenderRepresentation", typeof(hke.ComponentWithRenderRepresentation) },
        { "hke::Output", typeof(hke.Output) },
        { "hke::Input", typeof(hke.Input) },
        { "hke::AddPropertyIfMissing", typeof(hke.AddPropertyIfMissing) },
        { "hke::RequiredProperty", typeof(hke.RequiredProperty) },
        { "hke::TempBuffer", typeof(hke.TempBuffer) },
        { "hke::TriggerOutputData", typeof(hke.TriggerOutputData) },
        { "hke::PublicFieldPinBehavior", typeof(hke.PublicFieldPinBehavior) },
        { "hke::RuleOutputBase", typeof(hke.RuleOutputBase) },
        { "hke::WiredNodeOutput", typeof(hke.WiredNodeOutput) },
        { "hke::WiredNodeInput", typeof(hke.WiredNodeInput) },
        { "hke::ReferencedWiredArray", typeof(hke.ReferencedWiredArray) },
        { "hke::WireableStruct", typeof(hke.WireableStruct) },
        { "hke::VisualScriptClassPinName", typeof(hke.VisualScriptClassPinName) },
        { "hke::VisualScriptOutputName", typeof(hke.VisualScriptOutputName) },
        { "hke::VisualScriptUiName", typeof(hke.VisualScriptUiName) },
        { "hke::VisualScriptCategory", typeof(hke.VisualScriptCategory) },
        { "hke::VisualScriptTrigger", typeof(hke.VisualScriptTrigger) },
        { "hke::VisualScriptFunction", typeof(hke.VisualScriptFunction) },
        { "hke::ExposeReflectedFunctionInVisualScript", typeof(hke.ExposeReflectedFunctionInVisualScript) },
        { "hke::RuleOutput", typeof(hke.RuleOutput) },
        { "hke::RuleInput", typeof(hke.RuleInput) },
        { "hke::LocalService", typeof(hke.LocalService) },
        { "hke::IndexedArrayInitializer", typeof(hke.IndexedArrayInitializer) },
        { "hke::SerializeCallback", typeof(hke.SerializeCallback) },
        { "hke::Derived", typeof(hke.Derived) },
        { "hke::CachedData", typeof(hke.CachedData) },
        { "hke::ConstantData", typeof(hke.ConstantData) },
        { "hke::RuntimeDataSection", typeof(hke.RuntimeDataSection) },
        { "hke::EngineNode", typeof(hke.EngineNode) },
        { "hkDocumentationAttribute", typeof(hkDocumentationAttribute) },
        { "hkDescriptionAttribute", typeof(hkDescriptionAttribute) },
        { "hkSemanticsAttribute", typeof(hkSemanticsAttribute) },
        { "hkLinkAttribute", typeof(hkLinkAttribute) },
        { "hkModelerNodeTypeAttribute", typeof(hkModelerNodeTypeAttribute) },
        { "hkGizmoAttribute", typeof(hkGizmoAttribute) },
        { "hkUiAttribute", typeof(hkUiAttribute) },
        { "hkRangeInt32Attribute", typeof(hkRangeInt32Attribute) },
        { "hkRangeRealAttribute", typeof(hkRangeRealAttribute) },
        { "hkAttributeHideCriteria", typeof(hkAttributeHideCriteria) },
        { "hk::NonNull", typeof(hk.NonNull) },
        { "hk::Normalized", typeof(hk.Normalized) },
        { "hk::SetsField", typeof(hk.SetsField) },
        { "hk::HasCustomValidation", typeof(hk.HasCustomValidation) },
        { "hk::Validate", typeof(hk.Validate) },
        { "hk::GenerateValidationForAttribute", typeof(hk.GenerateValidationForAttribute) },
        { "hk::WeakImport", typeof(hk.WeakImport) },
        { "hk::PreferredSerializationFormat", typeof(hk.PreferredSerializationFormat) },
        { "hk::IncludeInMgd", typeof(hk.IncludeInMgd) },
        { "hk::ManualTypeRegistration", typeof(hk.ManualTypeRegistration) },
        { "hk::ExcludeFromVersionCheck", typeof(hk.ExcludeFromVersionCheck) },
        { "hk::DependsOn", typeof(hk.DependsOn) },
        { "hk::IgnoreSettersOnDiff", typeof(hk.IgnoreSettersOnDiff) },
        { "hk::SetCompare", typeof(hk.SetCompare) },
        { "hk::SetArrayRemoveOp", typeof(hk.SetArrayRemoveOp) },
        { "hk::SetArrayAddOp", typeof(hk.SetArrayAddOp) },
        { "hk::SetArrayKey", typeof(hk.SetArrayKey) },
        { "hk::DiffArraySemantics", typeof(hk.DiffArraySemantics) },
        { "hk::DiffAtomic", typeof(hk.DiffAtomic) },
        { "hk::ApplyDiff", typeof(hk.ApplyDiff) },
        { "hk::Diff", typeof(hk.Diff) },
        { "hk::Backup", typeof(hk.Backup) },
        { "hk::Untracked", typeof(hk.Untracked) },
        { "hk::LeafObject", typeof(hk.LeafObject) },
        { "hk::WeakRef", typeof(hk.WeakRef) },
        { "hk::StrongRef", typeof(hk.StrongRef) },
        { "hk::ForeignBase", typeof(hk.ForeignBase) },
        { "hk::SyntheticBase", typeof(hk.SyntheticBase) },
        { "hk::DefaultStringType", typeof(hk.DefaultStringType) },
        { "hk::ToString", typeof(hk.ToString) },
        { "hk::TypeOwner", typeof(hk.TypeOwner) },
        { "hk::DynamicFieldsOffset", typeof(hk.DynamicFieldsOffset) },
        { "hk::DeleteTypeInfo", typeof(hk.DeleteTypeInfo) },
        { "hk::Presets::ParsingDecl", typeof(hk.Presets.ParsingDecl) },
        { "hk::Presets", typeof(hk.Presets) },
        { "hk::ParsingDecl", typeof(hk.ParsingDecl) },
        { "hk::DependentUUID", typeof(hk.DependentUUID) },
        { "hk::Implements", typeof(hk.Implements) },
        { "hk::DocString", typeof(hk.DocString) },
        { "hk::AttachDocString", typeof(hk.AttachDocString) },
        { "hk::AbsMin", typeof(hk.AbsMin) },
        { "hk::AbsMax", typeof(hk.AbsMax) },
        { "hk::ContainsRelArrays", typeof(hk.ContainsRelArrays) },
        { "hk::FixupReflectedMethods", typeof(hk.FixupReflectedMethods) },
        { "hk::ExternalReflection", typeof(hk.ExternalReflection) },
        { "hk::Allocatable", typeof(hk.Allocatable) },
        { "hk::StringOut", typeof(hk.StringOut) },
        { "hk::IgnoreTemplateParams", typeof(hk.IgnoreTemplateParams) },
        { "hk::Default", typeof(hk.Default) },
        { "hk::ReflectionImpl", typeof(hk.ReflectionImpl) },
        { "hk::TypeLayout", typeof(hk.TypeLayout) },
        { "hk::ExactTypeFunction", typeof(hk.ExactTypeFunction) },
        { "hk::Rename", typeof(hk.Rename) },
        { "hk::Type", typeof(hk.Type) },
        { "hk::Feature", typeof(hk.Feature) },
        { "hk::Version", typeof(hk.Version) },
        { "hk::AlignReal", typeof(hk.AlignReal) },
        { "hk::ReflectChildren", typeof(hk.ReflectChildren) },
        { "hk::MemoryTracker", typeof(hk.MemoryTracker) },
        { "hk::RegisterType", typeof(hk.RegisterType) },
        { "hk::GenerateExactTypeMethod", typeof(hk.GenerateExactTypeMethod) },
        { "hk::HandledMessage", typeof(hk.HandledMessage) },
        { "hk::MessageHandler", typeof(hk.MessageHandler) },
        { "hk::MessageType", typeof(hk.MessageType) },
        { "hk::GenerateBypassCtor", typeof(hk.GenerateBypassCtor) },
        { "hk::Pod", typeof(hk.Pod) },
        { "hk::Retargetable", typeof(hk.Retargetable) },
        { "hk::Serialize", typeof(hk.Serialize) },
        { "hk::OpaqueType", typeof(hk.OpaqueType) },
        { "hk::ReflectDetails", typeof(hk.ReflectDetails) },
        { "hk::Reflect", typeof(hk.Reflect) },
        { "hk::Cast", typeof(hk.Cast) },
        { "hk::Optional", typeof(hk.Optional) },
        { "hk::AutoType", typeof(hk.AutoType) },
        { "hk::IsValueArray", typeof(hk.IsValueArray) },
        { "hkReferencedObject", typeof(hkReferencedObject) },
        { "hkBaseObject", typeof(hkBaseObject) },
        { "hkTimerVolumeTag", typeof(hkTimerVolumeTag) },
        { "hkTimerVolume", typeof(hkTimerVolume) },
        { "hkTimerProvider", typeof(hkTimerProvider) },
        { "hkGpuTraceResult", typeof(hkGpuTraceResult) },
        { "hkMonitorStreamColorTable::ColorPair", typeof(hkMonitorStreamColorTable.ColorPair) },
        { "hkMonitorStreamColorTable", typeof(hkMonitorStreamColorTable) },
        { "hkMonitorStreamTypeMap::TypeMap", typeof(hkMonitorStreamTypeMap.TypeMap) },
        { "hkMonitorStreamTypeMap", typeof(hkMonitorStreamTypeMap) },
        { "hkMonitorStreamStringMap::StringMap", typeof(hkMonitorStreamStringMap.StringMap) },
        { "hkMonitorStreamStringMap", typeof(hkMonitorStreamStringMap) },
        { "hkMonitorStreamContainer", typeof(hkMonitorStreamContainer) },
        { "hkms::Accumulate", typeof(hkms.Accumulate) },
        { "hkMonitorStreamFrameInfo", typeof(hkMonitorStreamFrameInfo) },
        { "hkQTransform", typeof(hkQTransform) },
        { "hkVector2f", typeof(hkVector2f) },
        { "hkVector2d", typeof(hkVector2d) },
        { "hkVector2", typeof(hkVector2) },
        { "hkPackedVector4_6", typeof(hkPackedVector4_6) },
        { "hkPackedVector8_3", typeof(hkPackedVector8_3) },
        { "hkPackedVector3", typeof(hkPackedVector3) },
        { "hkFourTransposedPointsd", typeof(hkFourTransposedPointsd) },
        { "hkFourTransposedPointsf", typeof(hkFourTransposedPointsf) },
        { "hkRadians", typeof(hkRadians) },
        { "hkQsTransform", typeof(hkQsTransform) },
        { "hkQsTransformf", typeof(hkQsTransformf) },
        { "hkQsTransformd", typeof(hkQsTransformd) },
        { "hkQTransformf", typeof(hkQTransformf) },
        { "hkQTransformd", typeof(hkQTransformd) },
        { "hkFloat3", typeof(hkFloat3) },
        { "hkFloat16Transform", typeof(hkFloat16Transform) },
        { "hkMpRational", typeof(hkMpRational) },
        { "hkMpUint", typeof(hkMpUint) },
        { "hkAxialTransform", typeof(hkAxialTransform) },
        { "hkAxialRotation", typeof(hkAxialRotation) },
        { "hkRemoteUi::_Step", typeof(hkRemoteUi._Step) },
        { "hkRemoteUi::_Max", typeof(hkRemoteUi._Max) },
        { "hkRemoteUi::_Min", typeof(hkRemoteUi._Min) },
        { "hkRemoteUi::_Label", typeof(hkRemoteUi._Label) },
        { "hkRemoteUi::_Help", typeof(hkRemoteUi._Help) },
        { "hkRemoteUi::_Color", typeof(hkRemoteUi._Color) },
        { "hkRemoteUi::_BkColor", typeof(hkRemoteUi._BkColor) },
        { "hkMultiThreadCheck", typeof(hkMultiThreadCheck) },
        { "hkContainerDebugAllocator", typeof(hkContainerDebugAllocator) },
        { "hkContainerHeapAllocator", typeof(hkContainerHeapAllocator) },
        { "hkContainerTempAllocator", typeof(hkContainerTempAllocator) },
        { "hkStringObject", typeof(hkStringObject) },
        { "hkSetIntFloatPair", typeof(hkSetIntFloatPair) },
        { "hkSetUint64", typeof(hkSetUint64) },
        { "hkSetUint32", typeof(hkSetUint32) },
        { "hkIntRealPair", typeof(hkIntRealPair) },
        { "hkHashMapDetail::Index", typeof(hkHashMapDetail.Index) },
        { "hkCommand", typeof(hkCommand) },
        { "hkOffsetBitField", typeof(hkOffsetBitField) },
        { "hkBitField", typeof(hkBitField) },
        { "hkPseudoRandomGenerator", typeof(hkPseudoRandomGenerator) },
        { "hkaAnimationContainer", typeof(hkaAnimationContainer) },
        { "hkaBoneAttachment", typeof(hkaBoneAttachment) },
        { "hkaAnimatedReferenceFrame", typeof(hkaAnimatedReferenceFrame) },
        { "hkaParameterizedReferenceFrame", typeof(hkaParameterizedReferenceFrame) },
        { "hkaParameterizedAnimationReferenceFrame", typeof(hkaParameterizedAnimationReferenceFrame) },
        { "hkaDirectionalReferenceFrame", typeof(hkaDirectionalReferenceFrame) },
        { "hkaAngularReferenceFrame", typeof(hkaAngularReferenceFrame) },
        { "hkaDefaultAnimatedReferenceFrame", typeof(hkaDefaultAnimatedReferenceFrame) },
        { "hkaFootstepAnalysisInfoContainer", typeof(hkaFootstepAnalysisInfoContainer) },
        { "hkaFootstepAnalysisInfo", typeof(hkaFootstepAnalysisInfo) },
        { "hkaSkeletonMapperData::PartitionMappingRange", typeof(hkaSkeletonMapperData.PartitionMappingRange) },
        { "hkaSkeletonMapperData::ChainMapping", typeof(hkaSkeletonMapperData.ChainMapping) },
        { "hkaSkeletonMapperData::SimpleMapping", typeof(hkaSkeletonMapperData.SimpleMapping) },
        { "hkaSkeletonMapperData", typeof(hkaSkeletonMapperData) },
        { "hkaSkeletonMapper", typeof(hkaSkeletonMapper) },
        { "hkaMeshBinding::Mapping", typeof(hkaMeshBinding.Mapping) },
        { "hkaMeshBinding", typeof(hkaMeshBinding) },
        { "hkaAnnotationTrack::Annotation", typeof(hkaAnnotationTrack.Annotation) },
        { "hkaAnnotationTrack", typeof(hkaAnnotationTrack) },
        { "hkaAnimationBinding", typeof(hkaAnimationBinding) },
        { "hkaAnimation", typeof(hkaAnimation) },
        { "hkaAnimationPreviewColorContainer", typeof(hkaAnimationPreviewColorContainer) },
        { "hkaSplineCompressedAnimation::AnimationCompressionParams", typeof(hkaSplineCompressedAnimation.AnimationCompressionParams) },
        { "hkaSplineCompressedAnimation::TrackCompressionParams", typeof(hkaSplineCompressedAnimation.TrackCompressionParams) },
        { "hkaSplineCompressedAnimation", typeof(hkaSplineCompressedAnimation) },
        { "hkaReferencePoseAnimation", typeof(hkaReferencePoseAnimation) },
        { "hkaQuantizedAnimation::TrackCompressionParams", typeof(hkaQuantizedAnimation.TrackCompressionParams) },
        { "hkaQuantizedAnimation", typeof(hkaQuantizedAnimation) },
        { "hkaPredictiveCompressedAnimation::TrackCompressionParams", typeof(hkaPredictiveCompressedAnimation.TrackCompressionParams) },
        { "hkaPredictiveCompressedAnimation", typeof(hkaPredictiveCompressedAnimation) },
        { "hkaInterleavedUncompressedAnimation", typeof(hkaInterleavedUncompressedAnimation) },
        { "hclVertexSelectionInput", typeof(hclVertexSelectionInput) },
        { "hclVertexFloatInput", typeof(hclVertexFloatInput) },
        { "hclTriangleSelectionInput", typeof(hclTriangleSelectionInput) },
        { "hclToolNamedObjectReference", typeof(hclToolNamedObjectReference) },
        { "hclEdgeSelectionInput", typeof(hclEdgeSelectionInput) },
        { "hclTransformSetSetupObject", typeof(hclTransformSetSetupObject) },
        { "hclNamedTransformSetSetupObject", typeof(hclNamedTransformSetSetupObject) },
        { "hclClothStateSetupObject", typeof(hclClothStateSetupObject) },
        { "hclStateTransitionSetupObject", typeof(hclStateTransitionSetupObject) },
        { "hclSimClothSetupObject::PerInstanceCollidable", typeof(hclSimClothSetupObject.PerInstanceCollidable) },
        { "hclSimClothSetupObject::TransferMotionSetupData", typeof(hclSimClothSetupObject.TransferMotionSetupData) },
        { "hclSimClothSetupObject", typeof(hclSimClothSetupObject) },
        { "hclSetupMeshSection::Triangle", typeof(hclSetupMeshSection.Triangle) },
        { "hclSetupMeshSection", typeof(hclSetupMeshSection) },
        { "hclSetupMesh", typeof(hclSetupMesh) },
        { "hclStorageSetupMeshSection::BoneInfluences", typeof(hclStorageSetupMeshSection.BoneInfluences) },
        { "hclStorageSetupMeshSection::SectionTriangleSelectionChannel", typeof(hclStorageSetupMeshSection.SectionTriangleSelectionChannel) },
        { "hclStorageSetupMeshSection::SectionEdgeSelectionChannel", typeof(hclStorageSetupMeshSection.SectionEdgeSelectionChannel) },
        { "hclStorageSetupMeshSection::SectionVertexFloatChannel", typeof(hclStorageSetupMeshSection.SectionVertexFloatChannel) },
        { "hclStorageSetupMeshSection::SectionVertexSelectionChannel", typeof(hclStorageSetupMeshSection.SectionVertexSelectionChannel) },
        { "hclStorageSetupMeshSection::SectionVertexChannel", typeof(hclStorageSetupMeshSection.SectionVertexChannel) },
        { "hclStorageSetupMeshSection", typeof(hclStorageSetupMeshSection) },
        { "hclStorageSetupMesh::Bone", typeof(hclStorageSetupMesh.Bone) },
        { "hclStorageSetupMesh::TriangleChannel", typeof(hclStorageSetupMesh.TriangleChannel) },
        { "hclStorageSetupMesh::EdgeChannel", typeof(hclStorageSetupMesh.EdgeChannel) },
        { "hclStorageSetupMesh::VertexChannel", typeof(hclStorageSetupMesh.VertexChannel) },
        { "hclStorageSetupMesh", typeof(hclStorageSetupMesh) },
        { "hclSimulationSetupMeshMapOptions", typeof(hclSimulationSetupMeshMapOptions) },
        { "hclSimulationSetupMesh", typeof(hclSimulationSetupMesh) },
        { "hclSceneDataSetupMeshSection", typeof(hclSceneDataSetupMeshSection) },
        { "hclSceneDataSetupMesh", typeof(hclSceneDataSetupMesh) },
        { "hclNamedSetupMesh", typeof(hclNamedSetupMesh) },
        { "hclOperatorSetupObject", typeof(hclOperatorSetupObject) },
        { "hclVertexGatherSetupObject", typeof(hclVertexGatherSetupObject) },
        { "hclVertexCopySetupObject", typeof(hclVertexCopySetupObject) },
        { "hclUpdateVertexFramesSetupObject", typeof(hclUpdateVertexFramesSetupObject) },
        { "hclSkinSetupObject", typeof(hclSkinSetupObject) },
        { "hclSimulateSetupObject::Config", typeof(hclSimulateSetupObject.Config) },
        { "hclSimulateSetupObject", typeof(hclSimulateSetupObject) },
        { "hclMoveFixedParticlesSetupObject", typeof(hclMoveFixedParticlesSetupObject) },
        { "hclMeshMeshDeformSetupObject", typeof(hclMeshMeshDeformSetupObject) },
        { "hclMeshBoneDeformSetupObject", typeof(hclMeshBoneDeformSetupObject) },
        { "hclBlendSetupObject", typeof(hclBlendSetupObject) },
        { "hclClothSetupContainer", typeof(hclClothSetupContainer) },
        { "hclConstraintSetSetupObject", typeof(hclConstraintSetSetupObject) },
        { "hclVolumeConstraintSetupObject", typeof(hclVolumeConstraintSetupObject) },
        { "hclTransitionSetupObject", typeof(hclTransitionSetupObject) },
        { "hclStretchLinkSetupObject", typeof(hclStretchLinkSetupObject) },
        { "hclStandardLinkSetupObject", typeof(hclStandardLinkSetupObject) },
        { "hclLocalRangeSetupObject", typeof(hclLocalRangeSetupObject) },
        { "hclBonePlanesSetupObject::PerParticleAngle", typeof(hclBonePlanesSetupObject.PerParticleAngle) },
        { "hclBonePlanesSetupObject::GlobalPlane", typeof(hclBonePlanesSetupObject.GlobalPlane) },
        { "hclBonePlanesSetupObject::PerParticlePlane", typeof(hclBonePlanesSetupObject.PerParticlePlane) },
        { "hclBonePlanesSetupObject", typeof(hclBonePlanesSetupObject) },
        { "hclBendStiffnessSetupObject", typeof(hclBendStiffnessSetupObject) },
        { "hclBendLinkSetupObject", typeof(hclBendLinkSetupObject) },
        { "hclClothSetupObject", typeof(hclClothSetupObject) },
        { "hclBufferSetupObject", typeof(hclBufferSetupObject) },
        { "hclStaticDisplayBufferSetupObject", typeof(hclStaticDisplayBufferSetupObject) },
        { "hclSimClothBufferSetupObject", typeof(hclSimClothBufferSetupObject) },
        { "hclScratchBufferSetupObject", typeof(hclScratchBufferSetupObject) },
        { "hclDisplayBufferSetupObject", typeof(hclDisplayBufferSetupObject) },
        { "hclVdbConstraintSets", typeof(hclVdbConstraintSets) },
        { "hclVdbConstraintGeometry", typeof(hclVdbConstraintGeometry) },
        { "hclVdbConstraintImmediate", typeof(hclVdbConstraintImmediate) },
        { "hclVdbConstraintSet", typeof(hclVdbConstraintSet) },
        { "hclVdbSimCloth", typeof(hclVdbSimCloth) },
        { "hclVdbCloth", typeof(hclVdbCloth) },
        { "hclVdbSimClothParticleVelocity", typeof(hclVdbSimClothParticleVelocity) },
        { "hclVdbSimClothParticleNormal", typeof(hclVdbSimClothParticleNormal) },
        { "hclVdbSimClothParticlePosition", typeof(hclVdbSimClothParticlePosition) },
        { "hclVdbSimClothParticleRadius", typeof(hclVdbSimClothParticleRadius) },
        { "hclVdbWorld", typeof(hclVdbWorld) },
        { "hclVdbSimCloths", typeof(hclVdbSimCloths) },
        { "hclVdbWorldCloths", typeof(hclVdbWorldCloths) },
        { "hclVdbVCPGeometry", typeof(hclVdbVCPGeometry) },
        { "hclVdbVCP", typeof(hclVdbVCP) },
        { "hclVdbParticleVCPs", typeof(hclVdbParticleVCPs) },
        { "hclVdbLandscapeVCPs", typeof(hclVdbLandscapeVCPs) },
        { "hclVdbVCPs", typeof(hclVdbVCPs) },
        { "hclVdbTransitionConstraint", typeof(hclVdbTransitionConstraint) },
        { "hclVdbConstraintLink", typeof(hclVdbConstraintLink) },
        { "hclVdbCompressibleLinkConstraintBatch", typeof(hclVdbCompressibleLinkConstraintBatch) },
        { "hclVdbVolumeConstraintBatch", typeof(hclVdbVolumeConstraintBatch) },
        { "hclVdbStretchLinkConstraintBatch", typeof(hclVdbStretchLinkConstraintBatch) },
        { "hclVdbBendStiffnessLinkConstraintBatch", typeof(hclVdbBendStiffnessLinkConstraintBatch) },
        { "hclVdbBendLinkConstraintBatch", typeof(hclVdbBendLinkConstraintBatch) },
        { "hclVdbStandardLinkConstraintBatch", typeof(hclVdbStandardLinkConstraintBatch) },
        { "hclVdbCompressibleLinkConstraint", typeof(hclVdbCompressibleLinkConstraint) },
        { "hclVdbVolumeConstraint", typeof(hclVdbVolumeConstraint) },
        { "hclVdbStretchLinkConstraint", typeof(hclVdbStretchLinkConstraint) },
        { "hclVdbBendStiffnessLinkConstraint", typeof(hclVdbBendStiffnessLinkConstraint) },
        { "hclVdbBendLinkConstraint", typeof(hclVdbBendLinkConstraint) },
        { "hclVdbStandardLinkConstraint", typeof(hclVdbStandardLinkConstraint) },
        { "hclVdbParticleTextId", typeof(hclVdbParticleTextId) },
        { "hclVdbParticleId", typeof(hclVdbParticleId) },
        { "hclVdbParticleIds", typeof(hclVdbParticleIds) },
        { "hclVdbLocalRangeConstraint", typeof(hclVdbLocalRangeConstraint) },
        { "hclVDBLandscapeShape", typeof(hclVDBLandscapeShape) },
        { "hclVdbSimClothGeometryDisplay", typeof(hclVdbSimClothGeometryDisplay) },
        { "hclVdbSimClothGeometry", typeof(hclVdbSimClothGeometry) },
        { "hclVdbCollidable", typeof(hclVdbCollidable) },
        { "hclVdbCollidableDisplay", typeof(hclVdbCollidableDisplay) },
        { "hclVdbActiveWorldCollidables", typeof(hclVdbActiveWorldCollidables) },
        { "hclVdbActiveSimClothCollidables", typeof(hclVdbActiveSimClothCollidables) },
        { "hclVdbConfigConstraintSet", typeof(hclVdbConfigConstraintSet) },
        { "hclVdbConstraintExecution", typeof(hclVdbConstraintExecution) },
        { "hclVdbOperator", typeof(hclVdbOperator) },
        { "hclVdbClothState", typeof(hclVdbClothState) },
        { "hclVdbTransitionConstraintInstanceData", typeof(hclVdbTransitionConstraintInstanceData) },
        { "hclVdbBlendOperatorInstanceData", typeof(hclVdbBlendOperatorInstanceData) },
        { "hclVdbSimulateOperatorInstanceData", typeof(hclVdbSimulateOperatorInstanceData) },
        { "hclVdbConstraintInstanceData", typeof(hclVdbConstraintInstanceData) },
        { "hclVdbStateOperatorInstanceData", typeof(hclVdbStateOperatorInstanceData) },
        { "hclVdbOperatorInstanceData", typeof(hclVdbOperatorInstanceData) },
        { "hclVdbInstanceData", typeof(hclVdbInstanceData) },
        { "hclVdbLandscapeCollisionData", typeof(hclVdbLandscapeCollisionData) },
        { "hclVdbTransferMotionData", typeof(hclVdbTransferMotionData) },
        { "hclVdbSimulationInfo", typeof(hclVdbSimulationInfo) },
        { "hclVDBSimClothAABB", typeof(hclVDBSimClothAABB) },
        { "hclVdbBonePlaneConstraint", typeof(hclVdbBonePlaneConstraint) },
        { "hclTransformSetDefinition", typeof(hclTransformSetDefinition) },
        { "hclTransformSetUsage::TransformTracker", typeof(hclTransformSetUsage.TransformTracker) },
        { "hclTransformSetUsage", typeof(hclTransformSetUsage) },
        { "hclClothState::TransformSetAccess", typeof(hclClothState.TransformSetAccess) },
        { "hclClothState::BufferAccess", typeof(hclClothState.BufferAccess) },
        { "hclClothState", typeof(hclClothState) },
        { "hclStateTransition::StateTransitionData", typeof(hclStateTransition.StateTransitionData) },
        { "hclStateTransition::BlendOpTransitionData", typeof(hclStateTransition.BlendOpTransitionData) },
        { "hclStateTransition::SimClothTransitionData", typeof(hclStateTransition.SimClothTransitionData) },
        { "hclStateTransition", typeof(hclStateTransition) },
        { "hclStateDependencyGraph::Branch", typeof(hclStateDependencyGraph.Branch) },
        { "hclStateDependencyGraph", typeof(hclStateDependencyGraph) },
        { "hclSimClothPose", typeof(hclSimClothPose) },
        { "hclSimClothInstance", typeof(hclSimClothInstance) },
        { "hclSimClothData::CollidablePinchingData", typeof(hclSimClothData.CollidablePinchingData) },
        { "hclSimClothData::TransferMotionData", typeof(hclSimClothData.TransferMotionData) },
        { "hclSimClothData::CollidableTransformMap", typeof(hclSimClothData.CollidableTransformMap) },
        { "hclSimClothData::ParticleData", typeof(hclSimClothData.ParticleData) },
        { "hclSimClothData::OverridableSimulationInfo", typeof(hclSimClothData.OverridableSimulationInfo) },
        { "hclSimClothData::LandscapeCollisionData", typeof(hclSimClothData.LandscapeCollisionData) },
        { "hclSimClothData", typeof(hclSimClothData) },
        { "hclVirtualCollisionPointsData::BarycentricPair", typeof(hclVirtualCollisionPointsData.BarycentricPair) },
        { "hclVirtualCollisionPointsData::EdgeFanLandscape", typeof(hclVirtualCollisionPointsData.EdgeFanLandscape) },
        { "hclVirtualCollisionPointsData::EdgeFan", typeof(hclVirtualCollisionPointsData.EdgeFan) },
        { "hclVirtualCollisionPointsData::EdgeFanSection", typeof(hclVirtualCollisionPointsData.EdgeFanSection) },
        { "hclVirtualCollisionPointsData::TriangleFanLandscape", typeof(hclVirtualCollisionPointsData.TriangleFanLandscape) },
        { "hclVirtualCollisionPointsData::TriangleFan", typeof(hclVirtualCollisionPointsData.TriangleFan) },
        { "hclVirtualCollisionPointsData::TriangleFanSection", typeof(hclVirtualCollisionPointsData.TriangleFanSection) },
        { "hclVirtualCollisionPointsData::BarycentricDictionaryEntry", typeof(hclVirtualCollisionPointsData.BarycentricDictionaryEntry) },
        { "hclVirtualCollisionPointsData::Block", typeof(hclVirtualCollisionPointsData.Block) },
        { "hclVirtualCollisionPointsData", typeof(hclVirtualCollisionPointsData) },
        { "hclOperator", typeof(hclOperator) },
        { "hclGatherSomeVerticesOperator::VertexPair", typeof(hclGatherSomeVerticesOperator.VertexPair) },
        { "hclGatherSomeVerticesOperator", typeof(hclGatherSomeVerticesOperator) },
        { "hclGatherAllVerticesOperator", typeof(hclGatherAllVerticesOperator) },
        { "hclCopyVerticesOperator", typeof(hclCopyVerticesOperator) },
        { "hclUpdateSomeVertexFramesOperator::Triangle", typeof(hclUpdateSomeVertexFramesOperator.Triangle) },
        { "hclUpdateSomeVertexFramesOperator", typeof(hclUpdateSomeVertexFramesOperator) },
        { "hclUpdateAllVertexFramesOperator", typeof(hclUpdateAllVertexFramesOperator) },
        { "hclSkinOperator::BoneInfluence", typeof(hclSkinOperator.BoneInfluence) },
        { "hclSkinOperator", typeof(hclSkinOperator) },
        { "hclSimulateOperator::Config", typeof(hclSimulateOperator.Config) },
        { "hclSimulateOperator", typeof(hclSimulateOperator) },
        { "hclSimulateOperatorInstanceData", typeof(hclSimulateOperatorInstanceData) },
        { "hclObjectSpaceSkinPOperator", typeof(hclObjectSpaceSkinPOperator) },
        { "hclObjectSpaceSkinPNTOperator", typeof(hclObjectSpaceSkinPNTOperator) },
        { "hclObjectSpaceSkinPNTBOperator", typeof(hclObjectSpaceSkinPNTBOperator) },
        { "hclObjectSpaceSkinPNOperator", typeof(hclObjectSpaceSkinPNOperator) },
        { "hclObjectSpaceSkinOperator", typeof(hclObjectSpaceSkinOperator) },
        { "hclObjectSpaceTransferSimulationOperator", typeof(hclObjectSpaceTransferSimulationOperator) },
        { "hclObjectSpaceMeshMeshDeformPOperator", typeof(hclObjectSpaceMeshMeshDeformPOperator) },
        { "hclObjectSpaceMeshMeshDeformPNTOperator", typeof(hclObjectSpaceMeshMeshDeformPNTOperator) },
        { "hclObjectSpaceMeshMeshDeformPNTBOperator", typeof(hclObjectSpaceMeshMeshDeformPNTBOperator) },
        { "hclObjectSpaceMeshMeshDeformPNOperator", typeof(hclObjectSpaceMeshMeshDeformPNOperator) },
        { "hclObjectSpaceMeshMeshDeformOperator", typeof(hclObjectSpaceMeshMeshDeformOperator) },
        { "hclMoveParticlesOperator::VertexParticlePair", typeof(hclMoveParticlesOperator.VertexParticlePair) },
        { "hclMoveParticlesOperator", typeof(hclMoveParticlesOperator) },
        { "hclMeshMeshDeformOperator::TriangleVertexPair", typeof(hclMeshMeshDeformOperator.TriangleVertexPair) },
        { "hclMeshMeshDeformOperator", typeof(hclMeshMeshDeformOperator) },
        { "hclSimpleMeshBoneDeformOperator::TriangleBonePair", typeof(hclSimpleMeshBoneDeformOperator.TriangleBonePair) },
        { "hclSimpleMeshBoneDeformOperator", typeof(hclSimpleMeshBoneDeformOperator) },
        { "hclMeshBoneDeformOperator::TriangleBonePair", typeof(hclMeshBoneDeformOperator.TriangleBonePair) },
        { "hclMeshBoneDeformOperator", typeof(hclMeshBoneDeformOperator) },
        { "hclObjectSpaceDeformer::LocalBlockUnpackedPNTB", typeof(hclObjectSpaceDeformer.LocalBlockUnpackedPNTB) },
        { "hclObjectSpaceDeformer::LocalBlockUnpackedPNT", typeof(hclObjectSpaceDeformer.LocalBlockUnpackedPNT) },
        { "hclObjectSpaceDeformer::LocalBlockUnpackedPN", typeof(hclObjectSpaceDeformer.LocalBlockUnpackedPN) },
        { "hclObjectSpaceDeformer::LocalBlockUnpackedP", typeof(hclObjectSpaceDeformer.LocalBlockUnpackedP) },
        { "hclObjectSpaceDeformer::LocalBlockPNTB", typeof(hclObjectSpaceDeformer.LocalBlockPNTB) },
        { "hclObjectSpaceDeformer::LocalBlockPNT", typeof(hclObjectSpaceDeformer.LocalBlockPNT) },
        { "hclObjectSpaceDeformer::LocalBlockPN", typeof(hclObjectSpaceDeformer.LocalBlockPN) },
        { "hclObjectSpaceDeformer::LocalBlockP", typeof(hclObjectSpaceDeformer.LocalBlockP) },
        { "hclObjectSpaceDeformer::OneBlendEntryBlock", typeof(hclObjectSpaceDeformer.OneBlendEntryBlock) },
        { "hclObjectSpaceDeformer::TwoBlendEntryBlock", typeof(hclObjectSpaceDeformer.TwoBlendEntryBlock) },
        { "hclObjectSpaceDeformer::ThreeBlendEntryBlock", typeof(hclObjectSpaceDeformer.ThreeBlendEntryBlock) },
        { "hclObjectSpaceDeformer::FourBlendEntryBlock", typeof(hclObjectSpaceDeformer.FourBlendEntryBlock) },
        { "hclObjectSpaceDeformer::FiveBlendEntryBlock", typeof(hclObjectSpaceDeformer.FiveBlendEntryBlock) },
        { "hclObjectSpaceDeformer::SixBlendEntryBlock", typeof(hclObjectSpaceDeformer.SixBlendEntryBlock) },
        { "hclObjectSpaceDeformer::SevenBlendEntryBlock", typeof(hclObjectSpaceDeformer.SevenBlendEntryBlock) },
        { "hclObjectSpaceDeformer::EightBlendEntryBlock", typeof(hclObjectSpaceDeformer.EightBlendEntryBlock) },
        { "hclObjectSpaceDeformer", typeof(hclObjectSpaceDeformer) },
        { "hclBoneSpaceDeformer::LocalBlockUnpackedPNTB", typeof(hclBoneSpaceDeformer.LocalBlockUnpackedPNTB) },
        { "hclBoneSpaceDeformer::LocalBlockUnpackedPNT", typeof(hclBoneSpaceDeformer.LocalBlockUnpackedPNT) },
        { "hclBoneSpaceDeformer::LocalBlockUnpackedPN", typeof(hclBoneSpaceDeformer.LocalBlockUnpackedPN) },
        { "hclBoneSpaceDeformer::LocalBlockUnpackedP", typeof(hclBoneSpaceDeformer.LocalBlockUnpackedP) },
        { "hclBoneSpaceDeformer::LocalBlockPNTB", typeof(hclBoneSpaceDeformer.LocalBlockPNTB) },
        { "hclBoneSpaceDeformer::LocalBlockPNT", typeof(hclBoneSpaceDeformer.LocalBlockPNT) },
        { "hclBoneSpaceDeformer::LocalBlockPN", typeof(hclBoneSpaceDeformer.LocalBlockPN) },
        { "hclBoneSpaceDeformer::LocalBlockP", typeof(hclBoneSpaceDeformer.LocalBlockP) },
        { "hclBoneSpaceDeformer::OneBlendEntryBlock", typeof(hclBoneSpaceDeformer.OneBlendEntryBlock) },
        { "hclBoneSpaceDeformer::TwoBlendEntryBlock", typeof(hclBoneSpaceDeformer.TwoBlendEntryBlock) },
        { "hclBoneSpaceDeformer::ThreeBlendEntryBlock", typeof(hclBoneSpaceDeformer.ThreeBlendEntryBlock) },
        { "hclBoneSpaceDeformer::FourBlendEntryBlock", typeof(hclBoneSpaceDeformer.FourBlendEntryBlock) },
        { "hclBoneSpaceDeformer", typeof(hclBoneSpaceDeformer) },
        { "hclRuntimeConversionInfo::ElementConversion", typeof(hclRuntimeConversionInfo.ElementConversion) },
        { "hclRuntimeConversionInfo::SlotConversion", typeof(hclRuntimeConversionInfo.SlotConversion) },
        { "hclRuntimeConversionInfo", typeof(hclRuntimeConversionInfo) },
        { "hclOutputConvertOperator", typeof(hclOutputConvertOperator) },
        { "hclInputConvertOperator", typeof(hclInputConvertOperator) },
        { "hclBoneSpaceSkinPOperator", typeof(hclBoneSpaceSkinPOperator) },
        { "hclBoneSpaceSkinPNTOperator", typeof(hclBoneSpaceSkinPNTOperator) },
        { "hclBoneSpaceSkinPNTBOperator", typeof(hclBoneSpaceSkinPNTBOperator) },
        { "hclBoneSpaceSkinPNOperator", typeof(hclBoneSpaceSkinPNOperator) },
        { "hclBoneSpaceSkinOperator", typeof(hclBoneSpaceSkinOperator) },
        { "hclBoneSpaceTransferSimulationOperator", typeof(hclBoneSpaceTransferSimulationOperator) },
        { "hclBoneSpaceMeshMeshDeformPOperator", typeof(hclBoneSpaceMeshMeshDeformPOperator) },
        { "hclBoneSpaceMeshMeshDeformPNTOperator", typeof(hclBoneSpaceMeshMeshDeformPNTOperator) },
        { "hclBoneSpaceMeshMeshDeformPNTBOperator", typeof(hclBoneSpaceMeshMeshDeformPNTBOperator) },
        { "hclBoneSpaceMeshMeshDeformPNOperator", typeof(hclBoneSpaceMeshMeshDeformPNOperator) },
        { "hclBoneSpaceMeshMeshDeformOperator", typeof(hclBoneSpaceMeshMeshDeformOperator) },
        { "hclBlendOperatorInstanceData", typeof(hclBlendOperatorInstanceData) },
        { "hclBlendSomeVerticesOperator::DynamicBlendData", typeof(hclBlendSomeVerticesOperator.DynamicBlendData) },
        { "hclBlendSomeVerticesOperator::BlendVertices", typeof(hclBlendSomeVerticesOperator.BlendVertices) },
        { "hclBlendSomeVerticesOperator::BlendEntry", typeof(hclBlendSomeVerticesOperator.BlendEntry) },
        { "hclBlendSomeVerticesOperator", typeof(hclBlendSomeVerticesOperator) },
        { "hclClothContainer", typeof(hclClothContainer) },
        { "hclConstraintSet", typeof(hclConstraintSet) },
        { "hclVolumeConstraintMx::ApplySingleData", typeof(hclVolumeConstraintMx.ApplySingleData) },
        { "hclVolumeConstraintMx::ApplyBatchData", typeof(hclVolumeConstraintMx.ApplyBatchData) },
        { "hclVolumeConstraintMx::FrameSingleData", typeof(hclVolumeConstraintMx.FrameSingleData) },
        { "hclVolumeConstraintMx::FrameBatchData", typeof(hclVolumeConstraintMx.FrameBatchData) },
        { "hclVolumeConstraintMx", typeof(hclVolumeConstraintMx) },
        { "hclVolumeConstraint::ApplyData", typeof(hclVolumeConstraint.ApplyData) },
        { "hclVolumeConstraint::FrameData", typeof(hclVolumeConstraint.FrameData) },
        { "hclVolumeConstraint", typeof(hclVolumeConstraint) },
        { "hclTransitionConstraintSet::PerParticle", typeof(hclTransitionConstraintSet.PerParticle) },
        { "hclTransitionConstraintSet", typeof(hclTransitionConstraintSet) },
        { "hclTransitionConstraintInstanceData", typeof(hclTransitionConstraintInstanceData) },
        { "hclStretchLinkConstraintSetMx::Single", typeof(hclStretchLinkConstraintSetMx.Single) },
        { "hclStretchLinkConstraintSetMx::Batch", typeof(hclStretchLinkConstraintSetMx.Batch) },
        { "hclStretchLinkConstraintSetMx", typeof(hclStretchLinkConstraintSetMx) },
        { "hclStretchLinkConstraintSet::Link", typeof(hclStretchLinkConstraintSet.Link) },
        { "hclStretchLinkConstraintSet", typeof(hclStretchLinkConstraintSet) },
        { "hclStandardLinkConstraintSetMx::Single", typeof(hclStandardLinkConstraintSetMx.Single) },
        { "hclStandardLinkConstraintSetMx::Batch", typeof(hclStandardLinkConstraintSetMx.Batch) },
        { "hclStandardLinkConstraintSetMx", typeof(hclStandardLinkConstraintSetMx) },
        { "hclStandardLinkConstraintSet::Link", typeof(hclStandardLinkConstraintSet.Link) },
        { "hclStandardLinkConstraintSet", typeof(hclStandardLinkConstraintSet) },
        { "hclLocalRangeConstraintSet::LocalConstraint", typeof(hclLocalRangeConstraintSet.LocalConstraint) },
        { "hclLocalRangeConstraintSet", typeof(hclLocalRangeConstraintSet) },
        { "hclCompressibleLinkConstraintSetMx::Single", typeof(hclCompressibleLinkConstraintSetMx.Single) },
        { "hclCompressibleLinkConstraintSetMx::Batch", typeof(hclCompressibleLinkConstraintSetMx.Batch) },
        { "hclCompressibleLinkConstraintSetMx", typeof(hclCompressibleLinkConstraintSetMx) },
        { "hclCompressibleLinkConstraintSet::Link", typeof(hclCompressibleLinkConstraintSet.Link) },
        { "hclCompressibleLinkConstraintSet", typeof(hclCompressibleLinkConstraintSet) },
        { "hclBonePlanesConstraintSet::BonePlane", typeof(hclBonePlanesConstraintSet.BonePlane) },
        { "hclBonePlanesConstraintSet", typeof(hclBonePlanesConstraintSet) },
        { "hclBendStiffnessConstraintSetMx::Single", typeof(hclBendStiffnessConstraintSetMx.Single) },
        { "hclBendStiffnessConstraintSetMx::Batch", typeof(hclBendStiffnessConstraintSetMx.Batch) },
        { "hclBendStiffnessConstraintSetMx", typeof(hclBendStiffnessConstraintSetMx) },
        { "hclBendStiffnessConstraintSet::Link", typeof(hclBendStiffnessConstraintSet.Link) },
        { "hclBendStiffnessConstraintSet", typeof(hclBendStiffnessConstraintSet) },
        { "hclBendLinkConstraintSetMx::Single", typeof(hclBendLinkConstraintSetMx.Single) },
        { "hclBendLinkConstraintSetMx::Batch", typeof(hclBendLinkConstraintSetMx.Batch) },
        { "hclBendLinkConstraintSetMx", typeof(hclBendLinkConstraintSetMx) },
        { "hclBendLinkConstraintSet::Link", typeof(hclBendLinkConstraintSet.Link) },
        { "hclBendLinkConstraintSet", typeof(hclBendLinkConstraintSet) },
        { "hclAntiPinchConstraintSet::PerParticle", typeof(hclAntiPinchConstraintSet.PerParticle) },
        { "hclAntiPinchConstraintSet", typeof(hclAntiPinchConstraintSet) },
        { "hclCollidable", typeof(hclCollidable) },
        { "hclShape", typeof(hclShape) },
        { "hclTaperedCapsuleShape", typeof(hclTaperedCapsuleShape) },
        { "hclSphereShape", typeof(hclSphereShape) },
        { "hclPlaneShape", typeof(hclPlaneShape) },
        { "hclConvexPlanesShape", typeof(hclConvexPlanesShape) },
        { "hclConvexHeightFieldShape", typeof(hclConvexHeightFieldShape) },
        { "hclConvexGeometryShape", typeof(hclConvexGeometryShape) },
        { "hclCapsuleShape", typeof(hclCapsuleShape) },
        { "hclClothInstance", typeof(hclClothInstance) },
        { "hclStateTransitionId", typeof(hclStateTransitionId) },
        { "hclClothData", typeof(hclClothData) },
        { "hclBufferLayout::Slot", typeof(hclBufferLayout.Slot) },
        { "hclBufferLayout::BufferElement", typeof(hclBufferLayout.BufferElement) },
        { "hclBufferLayout", typeof(hclBufferLayout) },
        { "hclBufferDefinition", typeof(hclBufferDefinition) },
        { "hclBufferUsage", typeof(hclBufferUsage) },
        { "hclStaticShadowBufferDefinition", typeof(hclStaticShadowBufferDefinition) },
        { "hclShadowBufferDefinition", typeof(hclShadowBufferDefinition) },
        { "hclScratchBufferDefinition", typeof(hclScratchBufferDefinition) },
        { "hclAction", typeof(hclAction) },
        { "hclSimpleWindAction", typeof(hclSimpleWindAction) },
        { "hclSkeletonTransformSetSetupObject", typeof(hclSkeletonTransformSetSetupObject) },
        { "hkbCharacterSelectedInfo", typeof(hkbCharacterSelectedInfo) },
        { "hkbBehaviorGraphInternalStateInfo", typeof(hkbBehaviorGraphInternalStateInfo) },
        { "hkbAuxiliaryNodeInfo", typeof(hkbAuxiliaryNodeInfo) },
        { "hkbLinkedSymbolInfo", typeof(hkbLinkedSymbolInfo) },
        { "hkbSimulationStateInfo", typeof(hkbSimulationStateInfo) },
        { "hkbEventRaisedInfo", typeof(hkbEventRaisedInfo) },
        { "hkbBehaviorEventsInfo", typeof(hkbBehaviorEventsInfo) },
        { "hkbBehaviorInfo::IdToNamePair", typeof(hkbBehaviorInfo.IdToNamePair) },
        { "hkbBehaviorInfo", typeof(hkbBehaviorInfo) },
        { "hkbCharacterSkinInfo", typeof(hkbCharacterSkinInfo) },
        { "hkbCharacterSteppedInfo", typeof(hkbCharacterSteppedInfo) },
        { "hkbCharacterInfo", typeof(hkbCharacterInfo) },
        { "hkbCharacterAddedInfo", typeof(hkbCharacterAddedInfo) },
        { "hkbToolNodeType", typeof(hkbToolNodeType) },
        { "hkbAiControlCancelPathCommand", typeof(hkbAiControlCancelPathCommand) },
        { "hkbAiControlPathToCommand", typeof(hkbAiControlPathToCommand) },
        { "hkbCharacterSkeletonChangedCommand", typeof(hkbCharacterSkeletonChangedCommand) },
        { "hkbCameraVariablesChangedCommand", typeof(hkbCameraVariablesChangedCommand) },
        { "hkbRebuildScriptsCommand", typeof(hkbRebuildScriptsCommand) },
        { "hkbSetNodePropertyCommand", typeof(hkbSetNodePropertyCommand) },
        { "hkbSetBehaviorCommand", typeof(hkbSetBehaviorCommand) },
        { "hkbSetLocalTimeOfClipGeneratorCommand", typeof(hkbSetLocalTimeOfClipGeneratorCommand) },
        { "hkbSetWordVariableCommand", typeof(hkbSetWordVariableCommand) },
        { "hkbSetSelectedCharacterCommand", typeof(hkbSetSelectedCharacterCommand) },
        { "hkbRaiseEventCommand", typeof(hkbRaiseEventCommand) },
        { "hkbCharacterControlCommand", typeof(hkbCharacterControlCommand) },
        { "hkbSimulationControlCommand", typeof(hkbSimulationControlCommand) },
        { "hkbClientCharacterState", typeof(hkbClientCharacterState) },
        { "hkVariableTweakingHelper::Vector4VariableInfo", typeof(hkVariableTweakingHelper.Vector4VariableInfo) },
        { "hkVariableTweakingHelper::RealVariableInfo", typeof(hkVariableTweakingHelper.RealVariableInfo) },
        { "hkVariableTweakingHelper::IntVariableInfo", typeof(hkVariableTweakingHelper.IntVariableInfo) },
        { "hkVariableTweakingHelper::BoolVariableInfo", typeof(hkVariableTweakingHelper.BoolVariableInfo) },
        { "hkVariableTweakingHelper", typeof(hkVariableTweakingHelper) },
        { "hkbTestIdSelector", typeof(hkbTestIdSelector) },
        { "hkbAssetBundle", typeof(hkbAssetBundle) },
        { "hkbAssetBundleStringData", typeof(hkbAssetBundleStringData) },
        { "hkbHoldFromBlendingTransitionEffect", typeof(hkbHoldFromBlendingTransitionEffect) },
        { "hkbCharacterControllerSetup", typeof(hkbCharacterControllerSetup) },
        { "hkbRigidBodySetup", typeof(hkbRigidBodySetup) },
        { "hkbShapeSetup", typeof(hkbShapeSetup) },
        { "hkbRagdollControllerSetup", typeof(hkbRagdollControllerSetup) },
        { "hkbConstraintSetup", typeof(hkbConstraintSetup) },
        { "hkbRagdollInterface", typeof(hkbRagdollInterface) },
        { "hkbParticleSystemEventPayload", typeof(hkbParticleSystemEventPayload) },
        { "hkbCameraShakeEventPayload", typeof(hkbCameraShakeEventPayload) },
        { "hkbStateDependentModifier", typeof(hkbStateDependentModifier) },
        { "hkbGravityModifier", typeof(hkbGravityModifier) },
        { "hkbComputeWorldFromModelModifier", typeof(hkbComputeWorldFromModelModifier) },
        { "hkbAlignBoneModifier", typeof(hkbAlignBoneModifier) },
        { "hkbRadialSelectorGenerator::GeneratorPair", typeof(hkbRadialSelectorGenerator.GeneratorPair) },
        { "hkbRadialSelectorGenerator::GeneratorInfo", typeof(hkbRadialSelectorGenerator.GeneratorInfo) },
        { "hkbRadialSelectorGenerator", typeof(hkbRadialSelectorGenerator) },
        { "hkbPinBonesGenerator", typeof(hkbPinBonesGenerator) },
        { "hkbPoseStoringGeneratorOutputListener::StoredPose", typeof(hkbPoseStoringGeneratorOutputListener.StoredPose) },
        { "hkbPoseStoringGeneratorOutputListener", typeof(hkbPoseStoringGeneratorOutputListener) },
        { "hkbCustomTestGenerator", typeof(hkbCustomTestGenerator) },
        { "hkbCustomTestGeneratorAnnotatedTypes", typeof(hkbCustomTestGeneratorAnnotatedTypes) },
        { "hkbCustomTestGeneratorBoneTypes", typeof(hkbCustomTestGeneratorBoneTypes) },
        { "hkbCustomTestGeneratorNestedTypes", typeof(hkbCustomTestGeneratorNestedTypes) },
        { "hkbCustomTestGeneratorNestedTypesBase", typeof(hkbCustomTestGeneratorNestedTypesBase) },
        { "hkbCustomTestGeneratorComplexTypes", typeof(hkbCustomTestGeneratorComplexTypes) },
        { "hkbCustomTestGeneratorSimpleTypes", typeof(hkbCustomTestGeneratorSimpleTypes) },
        { "hkbCustomTestGeneratorHiddenTypes", typeof(hkbCustomTestGeneratorHiddenTypes) },
        { "hkbAnimatedSkeletonGenerator", typeof(hkbAnimatedSkeletonGenerator) },
        { "hkbBodyIkControlPoint", typeof(hkbBodyIkControlPoint) },
        { "hkbBodyIkControlPin", typeof(hkbBodyIkControlPin) },
        { "hkbBodyIkControl", typeof(hkbBodyIkControl) },
        { "hkbBodyIkControllerProfile", typeof(hkbBodyIkControllerProfile) },
        { "hkbBodyIkControllerCinfo", typeof(hkbBodyIkControllerCinfo) },
        { "hkAssetRefPtr<hkbBehaviorGraph>", typeof(hkAssetRefPtr<hkbBehaviorGraph>) },
        { "hkbWorldEnums", typeof(hkbWorldEnums) },
        { "hkbVariableValueSet", typeof(hkbVariableValueSet) },
        { "hkbVariableBounds", typeof(hkbVariableBounds) },
        { "hkbVariableValue", typeof(hkbVariableValue) },
        { "hkbVariableInfo", typeof(hkbVariableInfo) },
        { "hkbVariableBindingSet::Binding", typeof(hkbVariableBindingSet.Binding) },
        { "hkbVariableBindingSet", typeof(hkbVariableBindingSet) },
        { "hkbVerifiable", typeof(hkbVerifiable) },
        { "hkbMessageLog", typeof(hkbMessageLog) },
        { "hkbHandle", typeof(hkbHandle) },
        { "hkbEventDrivenBlendingObject::InternalState", typeof(hkbEventDrivenBlendingObject.InternalState) },
        { "hkbEventDrivenBlendingObject", typeof(hkbEventDrivenBlendingObject) },
        { "hkbDefaultMessageLog", typeof(hkbDefaultMessageLog) },
        { "hkbCustomPropertySheet", typeof(hkbCustomPropertySheet) },
        { "hkbCustomIdSelector", typeof(hkbCustomIdSelector) },
        { "hkbCompiledExpressionSet::Token", typeof(hkbCompiledExpressionSet.Token) },
        { "hkbCompiledExpressionSet", typeof(hkbCompiledExpressionSet) },
        { "hkbBlendCurveUtils", typeof(hkbBlendCurveUtils) },
        { "hkbTransitionEffect", typeof(hkbTransitionEffect) },
        { "hkbManualSelectorTransitionEffectInternalState", typeof(hkbManualSelectorTransitionEffectInternalState) },
        { "hkbManualSelectorTransitionEffect", typeof(hkbManualSelectorTransitionEffect) },
        { "hkbGeneratorTransitionEffectInternalState", typeof(hkbGeneratorTransitionEffectInternalState) },
        { "hkbGeneratorTransitionEffect", typeof(hkbGeneratorTransitionEffect) },
        { "hkbBlendingTransitionEffectInternalState", typeof(hkbBlendingTransitionEffectInternalState) },
        { "hkbBlendingTransitionEffect", typeof(hkbBlendingTransitionEffect) },
        { "hkbExtrapolatingTransitionEffectInternalState", typeof(hkbExtrapolatingTransitionEffectInternalState) },
        { "hkbExtrapolatingTransitionEffect", typeof(hkbExtrapolatingTransitionEffect) },
        { "hkbStateMachineInternalState", typeof(hkbStateMachineInternalState) },
        { "hkbStateMachine::DelayedTransitionInfo", typeof(hkbStateMachine.DelayedTransitionInfo) },
        { "hkbStateMachine::NestedStateMachineData", typeof(hkbStateMachine.NestedStateMachineData) },
        { "hkbStateMachine::StateInfo", typeof(hkbStateMachine.StateInfo) },
        { "hkbStateMachine::EventPropertyArray", typeof(hkbStateMachine.EventPropertyArray) },
        { "hkbStateMachine::TransitionInfoArray", typeof(hkbStateMachine.TransitionInfoArray) },
        { "hkbStateMachine::ProspectiveTransitionInfo", typeof(hkbStateMachine.ProspectiveTransitionInfo) },
        { "hkbStateMachine::ActiveTransitionInfo", typeof(hkbStateMachine.ActiveTransitionInfo) },
        { "hkbStateMachine::TransitionInfoReference", typeof(hkbStateMachine.TransitionInfoReference) },
        { "hkbStateMachine::TransitionInfo", typeof(hkbStateMachine.TransitionInfo) },
        { "hkbStateMachine::TimeInterval", typeof(hkbStateMachine.TimeInterval) },
        { "hkbStateMachine", typeof(hkbStateMachine) },
        { "hkbStateListener", typeof(hkbStateListener) },
        { "hkbStateChooserWrapper", typeof(hkbStateChooserWrapper) },
        { "hkbStateChooser", typeof(hkbStateChooser) },
        { "hkbIntVariableSequencedData::Sample", typeof(hkbIntVariableSequencedData.Sample) },
        { "hkbIntVariableSequencedData", typeof(hkbIntVariableSequencedData) },
        { "hkbBoolVariableSequencedData::Sample", typeof(hkbBoolVariableSequencedData.Sample) },
        { "hkbBoolVariableSequencedData", typeof(hkbBoolVariableSequencedData) },
        { "hkbRealVariableSequencedData::Sample", typeof(hkbRealVariableSequencedData.Sample) },
        { "hkbRealVariableSequencedData", typeof(hkbRealVariableSequencedData) },
        { "hkbEventSequencedData::SequencedEvent", typeof(hkbEventSequencedData.SequencedEvent) },
        { "hkbEventSequencedData", typeof(hkbEventSequencedData) },
        { "hkbSequencedData", typeof(hkbSequencedData) },
        { "hkbSequenceStringData", typeof(hkbSequenceStringData) },
        { "hkbSequenceInternalState", typeof(hkbSequenceInternalState) },
        { "hkbSequence", typeof(hkbSequence) },
        { "hkbProjectStringData", typeof(hkbProjectStringData) },
        { "hkbProjectData", typeof(hkbProjectData) },
        { "hkbNode", typeof(hkbNode) },
        { "hkbBindable", typeof(hkbBindable) },
        { "hkbModifier", typeof(hkbModifier) },
        { "hkbModifierWrapper", typeof(hkbModifierWrapper) },
        { "hkbTwistModifier", typeof(hkbTwistModifier) },
        { "hkbTransformVectorModifierInternalState", typeof(hkbTransformVectorModifierInternalState) },
        { "hkbTransformVectorModifier", typeof(hkbTransformVectorModifier) },
        { "hkbTimerModifierInternalState", typeof(hkbTimerModifierInternalState) },
        { "hkbTimerModifier", typeof(hkbTimerModifier) },
        { "hkbSetWorldFromModelModifier", typeof(hkbSetWorldFromModelModifier) },
        { "hkbSenseHandleModifier::Range", typeof(hkbSenseHandleModifier.Range) },
        { "hkbSenseHandleModifier", typeof(hkbSenseHandleModifier) },
        { "hkbRotateCharacterModifierInternalState", typeof(hkbRotateCharacterModifierInternalState) },
        { "hkbRotateCharacterModifier", typeof(hkbRotateCharacterModifier) },
        { "hkbWorldFromModelModeData", typeof(hkbWorldFromModelModeData) },
        { "hkbRigidBodyRagdollControlsModifier", typeof(hkbRigidBodyRagdollControlsModifier) },
        { "hkbRigidBodyRagdollControlData", typeof(hkbRigidBodyRagdollControlData) },
        { "hkbKeyFrameControlData", typeof(hkbKeyFrameControlData) },
        { "hkbPoweredRagdollControlsModifier", typeof(hkbPoweredRagdollControlsModifier) },
        { "hkbPoweredRagdollControlData", typeof(hkbPoweredRagdollControlData) },
        { "hkbKeyframeBonesModifier::KeyframeInfo", typeof(hkbKeyframeBonesModifier.KeyframeInfo) },
        { "hkbKeyframeBonesModifier", typeof(hkbKeyframeBonesModifier) },
        { "hkbExtractRagdollPoseModifier", typeof(hkbExtractRagdollPoseModifier) },
        { "hkbMoveCharacterModifierInternalState", typeof(hkbMoveCharacterModifierInternalState) },
        { "hkbMoveCharacterModifier", typeof(hkbMoveCharacterModifier) },
        { "hkbMirrorModifier", typeof(hkbMirrorModifier) },
        { "hkbLookAtModifierInternalState", typeof(hkbLookAtModifierInternalState) },
        { "hkbLookAtModifier", typeof(hkbLookAtModifier) },
        { "hkbModifierList", typeof(hkbModifierList) },
        { "hkbJigglerModifierInternalState", typeof(hkbJigglerModifierInternalState) },
        { "hkbJigglerModifier", typeof(hkbJigglerModifier) },
        { "hkbJigglerGroup", typeof(hkbJigglerGroup) },
        { "hkbHandIkModifier::Hand", typeof(hkbHandIkModifier.Hand) },
        { "hkbHandIkModifier", typeof(hkbHandIkModifier) },
        { "hkbHandIkControlsModifier::Hand", typeof(hkbHandIkControlsModifier.Hand) },
        { "hkbHandIkControlsModifier", typeof(hkbHandIkControlsModifier) },
        { "hkbHandIkControlData", typeof(hkbHandIkControlData) },
        { "hkbGetWorldFromModelModifierInternalState", typeof(hkbGetWorldFromModelModifierInternalState) },
        { "hkbGetWorldFromModelModifier", typeof(hkbGetWorldFromModelModifier) },
        { "hkbGetUpModifierInternalState", typeof(hkbGetUpModifierInternalState) },
        { "hkbGetUpModifier", typeof(hkbGetUpModifier) },
        { "hkbGetHandleOnBoneModifier", typeof(hkbGetHandleOnBoneModifier) },
        { "hkbFootIkModifier::InternalLegData", typeof(hkbFootIkModifier.InternalLegData) },
        { "hkbFootIkModifier::Leg", typeof(hkbFootIkModifier.Leg) },
        { "hkbFootIkModifier", typeof(hkbFootIkModifier) },
        { "hkbFootIkGains", typeof(hkbFootIkGains) },
        { "hkbFootIkControlsModifier::Leg", typeof(hkbFootIkControlsModifier.Leg) },
        { "hkbFootIkControlsModifier", typeof(hkbFootIkControlsModifier) },
        { "hkbFootIkControlData", typeof(hkbFootIkControlData) },
        { "hkbEventsFromRangeModifierInternalState", typeof(hkbEventsFromRangeModifierInternalState) },
        { "hkbEventsFromRangeModifier", typeof(hkbEventsFromRangeModifier) },
        { "hkbEventRangeDataArray", typeof(hkbEventRangeDataArray) },
        { "hkbEventRangeData", typeof(hkbEventRangeData) },
        { "hkbEventDrivenModifierInternalState", typeof(hkbEventDrivenModifierInternalState) },
        { "hkbEventDrivenModifier", typeof(hkbEventDrivenModifier) },
        { "hkbEvaluateHandleModifier", typeof(hkbEvaluateHandleModifier) },
        { "hkbEvaluateExpressionModifierInternalState", typeof(hkbEvaluateExpressionModifierInternalState) },
        { "hkbEvaluateExpressionModifier::InternalExpressionData", typeof(hkbEvaluateExpressionModifier.InternalExpressionData) },
        { "hkbEvaluateExpressionModifier", typeof(hkbEvaluateExpressionModifier) },
        { "hkbExpressionDataArray", typeof(hkbExpressionDataArray) },
        { "hkbExpressionData", typeof(hkbExpressionData) },
        { "hkbDetectCloseToGroundModifierInternalState", typeof(hkbDetectCloseToGroundModifierInternalState) },
        { "hkbDetectCloseToGroundModifier", typeof(hkbDetectCloseToGroundModifier) },
        { "hkbDelayedModifierInternalState", typeof(hkbDelayedModifierInternalState) },
        { "hkbDelayedModifier", typeof(hkbDelayedModifier) },
        { "hkbDampingModifierInternalState", typeof(hkbDampingModifierInternalState) },
        { "hkbDampingModifier", typeof(hkbDampingModifier) },
        { "hkbComputeRotationToTargetModifierInternalState", typeof(hkbComputeRotationToTargetModifierInternalState) },
        { "hkbComputeRotationToTargetModifier", typeof(hkbComputeRotationToTargetModifier) },
        { "hkbComputeRotationFromAxisAngleModifierInternalState", typeof(hkbComputeRotationFromAxisAngleModifierInternalState) },
        { "hkbComputeRotationFromAxisAngleModifier", typeof(hkbComputeRotationFromAxisAngleModifier) },
        { "hkbComputeDirectionModifierInternalState", typeof(hkbComputeDirectionModifierInternalState) },
        { "hkbComputeDirectionModifier", typeof(hkbComputeDirectionModifier) },
        { "hkbCombineTransformsModifierInternalState", typeof(hkbCombineTransformsModifierInternalState) },
        { "hkbCombineTransformsModifier", typeof(hkbCombineTransformsModifier) },
        { "hkbCharacterControllerModifierInternalState", typeof(hkbCharacterControllerModifierInternalState) },
        { "hkbCharacterControllerModifier", typeof(hkbCharacterControllerModifier) },
        { "hkbCharacterControllerModifierControlData", typeof(hkbCharacterControllerModifierControlData) },
        { "hkbBodyIkControlsModifierInternalState", typeof(hkbBodyIkControlsModifierInternalState) },
        { "hkbBodyIkControlsModifier::PrecomputeData", typeof(hkbBodyIkControlsModifier.PrecomputeData) },
        { "hkbBodyIkControlsModifier::ControlData", typeof(hkbBodyIkControlsModifier.ControlData) },
        { "hkbBodyIkControlsModifier", typeof(hkbBodyIkControlsModifier) },
        { "hkbAttributeModifier::Assignment", typeof(hkbAttributeModifier.Assignment) },
        { "hkbAttributeModifier", typeof(hkbAttributeModifier) },
        { "hkbMoveBoneAttachmentModifier", typeof(hkbMoveBoneAttachmentModifier) },
        { "hkbAttachmentModifier", typeof(hkbAttachmentModifier) },
        { "hkbAiControlControlData", typeof(hkbAiControlControlData) },
        { "hkbAiControlControlDataNonBlendable", typeof(hkbAiControlControlDataNonBlendable) },
        { "hkbAiControlControlDataBlendable", typeof(hkbAiControlControlDataBlendable) },
        { "hkbReferencedGeneratorSyncInfo", typeof(hkbReferencedGeneratorSyncInfo) },
        { "hkbGeneratorSyncInfo::ActiveInterval", typeof(hkbGeneratorSyncInfo.ActiveInterval) },
        { "hkbGeneratorSyncInfo::SyncPoint", typeof(hkbGeneratorSyncInfo.SyncPoint) },
        { "hkbGeneratorSyncInfo", typeof(hkbGeneratorSyncInfo) },
        { "hkbGeneratorPartitionInfo", typeof(hkbGeneratorPartitionInfo) },
        { "hkbGeneratorOutputListener", typeof(hkbGeneratorOutputListener) },
        { "hkbGenerator", typeof(hkbGenerator) },
        { "hkbScriptGenerator", typeof(hkbScriptGenerator) },
        { "hkbReferencePoseGenerator", typeof(hkbReferencePoseGenerator) },
        { "hkbPoseMatchingGeneratorInternalState", typeof(hkbPoseMatchingGeneratorInternalState) },
        { "hkbPoseMatchingGenerator", typeof(hkbPoseMatchingGenerator) },
        { "hkbProceduralBlenderGenerator", typeof(hkbProceduralBlenderGenerator) },
        { "hkbParametricMotionGenerator::PrecomputeData", typeof(hkbParametricMotionGenerator.PrecomputeData) },
        { "hkbParametricMotionGenerator", typeof(hkbParametricMotionGenerator) },
        { "hkbModifierGenerator", typeof(hkbModifierGenerator) },
        { "hkbManualSelectorGeneratorInternalState", typeof(hkbManualSelectorGeneratorInternalState) },
        { "hkbManualSelectorGenerator", typeof(hkbManualSelectorGenerator) },
        { "hkbDockingGeneratorInternalState", typeof(hkbDockingGeneratorInternalState) },
        { "hkbDockingGenerator", typeof(hkbDockingGenerator) },
        { "hkbClipGeneratorInternalState", typeof(hkbClipGeneratorInternalState) },
        { "hkbClipGenerator::Echo", typeof(hkbClipGenerator.Echo) },
        { "hkbClipGenerator", typeof(hkbClipGenerator) },
        { "hkbClipTriggerArray", typeof(hkbClipTriggerArray) },
        { "hkbClipTrigger", typeof(hkbClipTrigger) },
        { "hkbBlenderGeneratorInternalState", typeof(hkbBlenderGeneratorInternalState) },
        { "hkbBlenderGeneratorChild", typeof(hkbBlenderGeneratorChild) },
        { "hkbBlenderGenerator::ChildInternalState", typeof(hkbBlenderGenerator.ChildInternalState) },
        { "hkbBlenderGenerator", typeof(hkbBlenderGenerator) },
        { "hkbLayerGeneratorInternalState", typeof(hkbLayerGeneratorInternalState) },
        { "hkbLayerGenerator::LayerInternalState", typeof(hkbLayerGenerator.LayerInternalState) },
        { "hkbLayerGenerator", typeof(hkbLayerGenerator) },
        { "hkbLayer", typeof(hkbLayer) },
        { "hkbBehaviorReferenceGenerator", typeof(hkbBehaviorReferenceGenerator) },
        { "hkbEventPayloadList", typeof(hkbEventPayloadList) },
        { "hkbNamedStringEventPayload", typeof(hkbNamedStringEventPayload) },
        { "hkbNamedIntEventPayload", typeof(hkbNamedIntEventPayload) },
        { "hkbNamedRealEventPayload", typeof(hkbNamedRealEventPayload) },
        { "hkbNamedEventPayload", typeof(hkbNamedEventPayload) },
        { "hkbStringEventPayload", typeof(hkbStringEventPayload) },
        { "hkbIntEventPayload", typeof(hkbIntEventPayload) },
        { "hkbRealEventPayload", typeof(hkbRealEventPayload) },
        { "hkbEventPayload", typeof(hkbEventPayload) },
        { "hkbEventInfo", typeof(hkbEventInfo) },
        { "hkbEventProperty", typeof(hkbEventProperty) },
        { "hkbEvent", typeof(hkbEvent) },
        { "hkbEventBase", typeof(hkbEventBase) },
        { "hkbHandIkDriverInfo::Hand", typeof(hkbHandIkDriverInfo.Hand) },
        { "hkbHandIkDriverInfo", typeof(hkbHandIkDriverInfo) },
        { "hkbFootIkDriverInfo::Leg", typeof(hkbFootIkDriverInfo.Leg) },
        { "hkbFootIkDriverInfo", typeof(hkbFootIkDriverInfo) },
        { "hkbDockingTarget", typeof(hkbDockingTarget) },
        { "hkbPlaneDockingTarget", typeof(hkbPlaneDockingTarget) },
        { "hkbLineDockingTarget", typeof(hkbLineDockingTarget) },
        { "hkbAiDriverInfo", typeof(hkbAiDriverInfo) },
        { "hkbContext", typeof(hkbContext) },
        { "hkbCondition", typeof(hkbCondition) },
        { "hkbStringCondition", typeof(hkbStringCondition) },
        { "hkbScriptCondition", typeof(hkbScriptCondition) },
        { "hkbExpressionCondition", typeof(hkbExpressionCondition) },
        { "hkbMirroredSkeletonInfo", typeof(hkbMirroredSkeletonInfo) },
        { "hkbCharacterStringData::FileNameMeshNamePair", typeof(hkbCharacterStringData.FileNameMeshNamePair) },
        { "hkbCharacterStringData", typeof(hkbCharacterStringData) },
        { "hkbCharacterSetup", typeof(hkbCharacterSetup) },
        { "hkbCharacterData", typeof(hkbCharacterData) },
        { "hkbCharacter", typeof(hkbCharacter) },
        { "hkbBoneWeightArray", typeof(hkbBoneWeightArray) },
        { "hkbBoneIndexArray", typeof(hkbBoneIndexArray) },
        { "hkbBehaviorGraphStringData", typeof(hkbBehaviorGraphStringData) },
        { "hkbBehaviorGraphInternalState", typeof(hkbBehaviorGraphInternalState) },
        { "hkbNodeInternalStateInfo", typeof(hkbNodeInternalStateInfo) },
        { "hkbBehaviorGraphData", typeof(hkbBehaviorGraphData) },
        { "hkbBehaviorGraph", typeof(hkbBehaviorGraph) },
        { "hkbRoleAttribute", typeof(hkbRoleAttribute) },
        { "hkbAttachmentSetup", typeof(hkbAttachmentSetup) },
        { "hkaiWorldReplayViewer::SilhouetteGeneratorsOverrideRecord", typeof(hkaiWorldReplayViewer.SilhouetteGeneratorsOverrideRecord) },
        { "hkaiWorldReplayViewer::ConnectedWorld", typeof(hkaiWorldReplayViewer.ConnectedWorld) },
        { "hkaiNavVolumeViewer::ReflectedClass", typeof(hkaiNavVolumeViewer.ReflectedClass) },
        { "hkaiNavMeshGeometryViewer::ReflectedClass", typeof(hkaiNavMeshGeometryViewer.ReflectedClass) },
        { "hkaiNavVolumeDebugUtils::GeometryDisplaySettings", typeof(hkaiNavVolumeDebugUtils.GeometryDisplaySettings) },
        { "hkaiNavVolumeDebugUtils::GeometryBuildSettings", typeof(hkaiNavVolumeDebugUtils.GeometryBuildSettings) },
        { "hkaiNavVolumeDebugUtils::DebugInfo", typeof(hkaiNavVolumeDebugUtils.DebugInfo) },
        { "hkaiNavMeshDebugUtils::DebugInfo", typeof(hkaiNavMeshDebugUtils.DebugInfo) },
        { "hkaiNavMeshDebugUtils::FaceNormalSettings", typeof(hkaiNavMeshDebugUtils.FaceNormalSettings) },
        { "hkaiNavMeshDebugUtils::NonplanarFacesSettings", typeof(hkaiNavMeshDebugUtils.NonplanarFacesSettings) },
        { "hkaiNavMeshDebugUtils::SmallEdgeSettings", typeof(hkaiNavMeshDebugUtils.SmallEdgeSettings) },
        { "hkaiGraphDebugUtils::DebugInfo", typeof(hkaiGraphDebugUtils.DebugInfo) },
        { "hkaiReferencedArray<hkaiIndex<int>>", typeof(hkaiReferencedArray<int>) },
        { "hkaiReferencedArray<hkaiPackedKey_<hkaiIndex<int>, hkaiIndex<int>>>", typeof(hkaiReferencedArray<uint>) },
        { "hkaiReferencedArray<int>", typeof(hkaiReferencedArray<int>) },
        { "hkaiReferencedArray<hkVector4f>", typeof(hkaiReferencedArray<Vector4>) },
        { "hkaiReferencedArray<unsigned int>", typeof(hkaiReferencedArray<uint>) },
        { "hkaiReferencedArray<hkaiIndex<hkInt32>>", typeof(hkaiReferencedArray<int>) },
        { "hkaiReferencedArray<hkVector4>", typeof(hkaiReferencedArray<Vector4>) },
        { "hkaiReferencedArray<hkaiReferenceFrame>", typeof(hkaiReferencedArray<hkaiReferenceFrame>) },
        { "hkaiReferencedArray<hkQTransform>", typeof(hkaiReferencedArray<hkQTransform>) },
        { "hkaiReferencedArray<hkaiPackedKey_<hkaiIndex<hkInt32>, hkaiIndex<hkInt32>>>", typeof(hkaiReferencedArray<uint>) },
        { "hkaiReferencedArray<hkaiUserEdgeUtils::UserEdgeSetup>", typeof(hkaiReferencedArray<hkaiUserEdgeUtils.UserEdgeSetup>) },
        { "hkaiReferencedArray<hkaiUserEdgeUtils::UserEdgePair>", typeof(hkaiReferencedArray<hkaiUserEdgeUtils.UserEdgePair>) },
        { "hkaiReferencedArray<T*<hkaiStreamingSet>>", typeof(hkaiReferencedArray<hkaiStreamingSet?>) },
        { "hkAtomic::Variable<unsigned char>", typeof(hkAtomic.Variable<byte>) },
        { "hkAtomic::Variable<hkUint8>", typeof(hkAtomic.Variable<byte>) },
        { "hkAtomic::Variable<hkaiPathRequestBase::RequestState>", typeof(hkAtomic.Variable<hkaiPathRequestBase.RequestState>) },
        { "hkAtomic::Variable<hkaiVolumeNavigatorStalenessChecker::State>", typeof(hkAtomic.Variable<hkaiVolumeNavigatorStalenessChecker.State>) },
        { "hkAtomic::Variable<hkaiNavigatorStalenessChecker::State>", typeof(hkAtomic.Variable<hkaiNavigatorStalenessChecker.State>) },
        { "hkaiCopyOnWriteDefaultTraits<hkaiNavMeshClearanceCache>", typeof(hkaiCopyOnWriteDefaultTraits) },
        { "hkaiCopyOnWriteDefaultTraits<hkaiStreamingSetInstance>", typeof(hkaiCopyOnWriteDefaultTraits) },
        { "hkaiCopyOnWriteDefaultTraits<hkaiNavVolumeInstanceData>", typeof(hkaiCopyOnWriteDefaultTraits) },
        { "hkaiCopyOnWriteDefaultTraits<hkaiNavMeshInstanceData>", typeof(hkaiCopyOnWriteDefaultTraits) },
        { "hkaiCopyOnWriteDefaultTraits<hkcdDynamicAabbTree>", typeof(hkaiCopyOnWriteDefaultTraits) },
        { "hkaiCopyOnWriteDefaultTraits<hkaiDirectedGraphInstanceData>", typeof(hkaiCopyOnWriteDefaultTraits) },
        { "hkHashSet<int>", typeof(hkHashSet<int>) },
        { "hkHashSet<hkaiDynamicUserEdgeSetInfo::UserEdgePair>", typeof(hkHashSet<hkaiDynamicUserEdgeSetInfo.UserEdgePair>) },
        { "hkHashSet<hkaiIndex<hkInt32>>", typeof(hkHashSet<int>) },
        { "hkaiCopyOnWritePtr<hkaiNavMeshClearanceCache, hkaiCopyOnWriteDefaultTraits<hkaiNavMeshClearanceCache>>", typeof(hkaiCopyOnWritePtr<hkaiNavMeshClearanceCache>) },
        { "hkaiCopyOnWritePtr<hkaiStreamingSetInstance, hkaiCopyOnWriteDefaultTraits<hkaiStreamingSetInstance>>", typeof(hkaiCopyOnWritePtr<hkaiStreamingSetInstance>) },
        { "hkaiCopyOnWritePtr<hkaiNavVolumeInstanceData, hkaiCopyOnWriteDefaultTraits<hkaiNavVolumeInstanceData>>", typeof(hkaiCopyOnWritePtr<hkaiNavVolumeInstanceData>) },
        { "hkaiCopyOnWritePtr<hkaiNavMeshInstanceData, hkaiCopyOnWriteDefaultTraits<hkaiNavMeshInstanceData>>", typeof(hkaiCopyOnWritePtr<hkaiNavMeshInstanceData>) },
        { "hkaiCopyOnWritePtr<hkcdDynamicAabbTree, hkaiCopyOnWriteDefaultTraits<hkcdDynamicAabbTree>>", typeof(hkaiCopyOnWritePtr<hkcdDynamicAabbTree>) },
        { "hkaiCopyOnWritePtr<hkaiDirectedGraphInstanceData, hkaiCopyOnWriteDefaultTraits<hkaiDirectedGraphInstanceData>>", typeof(hkaiCopyOnWritePtr<hkaiDirectedGraphInstanceData>) },
        { "hkaiWorldSignals", typeof(hkaiWorldSignals) },
        { "hkaiWorldProcessingSettings", typeof(hkaiWorldProcessingSettings) },
        { "hkaiWorldCommands::VolumeNavigatorNavigateImmediate", typeof(hkaiWorldCommands.VolumeNavigatorNavigateImmediate) },
        { "hkaiWorldCommands::VolumeNavigatorReset", typeof(hkaiWorldCommands.VolumeNavigatorReset) },
        { "hkaiWorldCommands::VolumeNavigatorRepathImmediate", typeof(hkaiWorldCommands.VolumeNavigatorRepathImmediate) },
        { "hkaiWorldCommands::VolumeNavigatorRequestRepath", typeof(hkaiWorldCommands.VolumeNavigatorRequestRepath) },
        { "hkaiWorldCommands::VolumeNavigatorSetAcceptablePathQualities", typeof(hkaiWorldCommands.VolumeNavigatorSetAcceptablePathQualities) },
        { "hkaiWorldCommands::VolumeNavigatorSetPosition", typeof(hkaiWorldCommands.VolumeNavigatorSetPosition) },
        { "hkaiWorldCommands::VolumeNavigatorSetGoals", typeof(hkaiWorldCommands.VolumeNavigatorSetGoals) },
        { "hkaiWorldCommands::VolumeNavigatorSetUserEdgeEnteredDistance", typeof(hkaiWorldCommands.VolumeNavigatorSetUserEdgeEnteredDistance) },
        { "hkaiWorldCommands::VolumeNavigatorSetGoalReachedDistance", typeof(hkaiWorldCommands.VolumeNavigatorSetGoalReachedDistance) },
        { "hkaiWorldCommands::VolumeNavigatorSetSearchRadius", typeof(hkaiWorldCommands.VolumeNavigatorSetSearchRadius) },
        { "hkaiWorldCommands::VolumeNavigatorClearIterationLimit", typeof(hkaiWorldCommands.VolumeNavigatorClearIterationLimit) },
        { "hkaiWorldCommands::VolumeNavigatorSetIterationLimit", typeof(hkaiWorldCommands.VolumeNavigatorSetIterationLimit) },
        { "hkaiWorldCommands::VolumeNavigatorSetLayerIndex", typeof(hkaiWorldCommands.VolumeNavigatorSetLayerIndex) },
        { "hkaiWorldCommands::VolumeNavigatorSetFilterInfo", typeof(hkaiWorldCommands.VolumeNavigatorSetFilterInfo) },
        { "hkaiWorldCommands::VolumeNavigatorClearCostModifier", typeof(hkaiWorldCommands.VolumeNavigatorClearCostModifier) },
        { "hkaiWorldCommands::VolumeNavigatorSetCostModifier", typeof(hkaiWorldCommands.VolumeNavigatorSetCostModifier) },
        { "hkaiWorldCommands::VolumeNavigatorClearEdgeFilter", typeof(hkaiWorldCommands.VolumeNavigatorClearEdgeFilter) },
        { "hkaiWorldCommands::VolumeNavigatorSetEdgeFilter", typeof(hkaiWorldCommands.VolumeNavigatorSetEdgeFilter) },
        { "hkaiWorldCommands::VolumeNavigatorRemove", typeof(hkaiWorldCommands.VolumeNavigatorRemove) },
        { "hkaiWorldCommands::VolumeNavigatorAdd", typeof(hkaiWorldCommands.VolumeNavigatorAdd) },
        { "hkaiWorldCommands::NavigatorNavigateImmediate", typeof(hkaiWorldCommands.NavigatorNavigateImmediate) },
        { "hkaiWorldCommands::NavigatorReset", typeof(hkaiWorldCommands.NavigatorReset) },
        { "hkaiWorldCommands::NavigatorRepathImmediate", typeof(hkaiWorldCommands.NavigatorRepathImmediate) },
        { "hkaiWorldCommands::NavigatorRequestRepath", typeof(hkaiWorldCommands.NavigatorRequestRepath) },
        { "hkaiWorldCommands::NavigatorSetAcceptablePathQualities", typeof(hkaiWorldCommands.NavigatorSetAcceptablePathQualities) },
        { "hkaiWorldCommands::NavigatorSetPosition", typeof(hkaiWorldCommands.NavigatorSetPosition) },
        { "hkaiWorldCommands::NavigatorSetGoals", typeof(hkaiWorldCommands.NavigatorSetGoals) },
        { "hkaiWorldCommands::NavigatorSetTurningRadiusMultipliers", typeof(hkaiWorldCommands.NavigatorSetTurningRadiusMultipliers) },
        { "hkaiWorldCommands::NavigatorSetUserEdgeEnteredDistance", typeof(hkaiWorldCommands.NavigatorSetUserEdgeEnteredDistance) },
        { "hkaiWorldCommands::NavigatorSetGoalReachedDistance", typeof(hkaiWorldCommands.NavigatorSetGoalReachedDistance) },
        { "hkaiWorldCommands::NavigatorSetInternalVertexPullingEnabled", typeof(hkaiWorldCommands.NavigatorSetInternalVertexPullingEnabled) },
        { "hkaiWorldCommands::NavigatorSetHeuristicWeight", typeof(hkaiWorldCommands.NavigatorSetHeuristicWeight) },
        { "hkaiWorldCommands::NavigatorDisableHierarchicalHeuristic", typeof(hkaiWorldCommands.NavigatorDisableHierarchicalHeuristic) },
        { "hkaiWorldCommands::NavigatorEnableHierarchicalHeuristic", typeof(hkaiWorldCommands.NavigatorEnableHierarchicalHeuristic) },
        { "hkaiWorldCommands::NavigatorSetVerticalTolerance", typeof(hkaiWorldCommands.NavigatorSetVerticalTolerance) },
        { "hkaiWorldCommands::NavigatorSetHorizontalTolerance", typeof(hkaiWorldCommands.NavigatorSetHorizontalTolerance) },
        { "hkaiWorldCommands::NavigatorSetSearchRadius", typeof(hkaiWorldCommands.NavigatorSetSearchRadius) },
        { "hkaiWorldCommands::NavigatorClearIterationLimit", typeof(hkaiWorldCommands.NavigatorClearIterationLimit) },
        { "hkaiWorldCommands::NavigatorSetIterationLimit", typeof(hkaiWorldCommands.NavigatorSetIterationLimit) },
        { "hkaiWorldCommands::NavigatorClearLengthLimit", typeof(hkaiWorldCommands.NavigatorClearLengthLimit) },
        { "hkaiWorldCommands::NavigatorSetLengthLimit", typeof(hkaiWorldCommands.NavigatorSetLengthLimit) },
        { "hkaiWorldCommands::NavigatorClearCapsuleLimit", typeof(hkaiWorldCommands.NavigatorClearCapsuleLimit) },
        { "hkaiWorldCommands::NavigatorSetCapsuleLimit", typeof(hkaiWorldCommands.NavigatorSetCapsuleLimit) },
        { "hkaiWorldCommands::NavigatorSetLayerIndex", typeof(hkaiWorldCommands.NavigatorSetLayerIndex) },
        { "hkaiWorldCommands::NavigatorSetFilterInfo", typeof(hkaiWorldCommands.NavigatorSetFilterInfo) },
        { "hkaiWorldCommands::NavigatorClearCostModifier", typeof(hkaiWorldCommands.NavigatorClearCostModifier) },
        { "hkaiWorldCommands::NavigatorSetCostModifier", typeof(hkaiWorldCommands.NavigatorSetCostModifier) },
        { "hkaiWorldCommands::NavigatorClearEdgeFilter", typeof(hkaiWorldCommands.NavigatorClearEdgeFilter) },
        { "hkaiWorldCommands::NavigatorSetEdgeFilter", typeof(hkaiWorldCommands.NavigatorSetEdgeFilter) },
        { "hkaiWorldCommands::NavigatorSetCharacterRadius", typeof(hkaiWorldCommands.NavigatorSetCharacterRadius) },
        { "hkaiWorldCommands::NavigatorRemove", typeof(hkaiWorldCommands.NavigatorRemove) },
        { "hkaiWorldCommands::NavigatorAdd", typeof(hkaiWorldCommands.NavigatorAdd) },
        { "hkaiWorldCommands::ForceSectionReferenceFrames", typeof(hkaiWorldCommands.ForceSectionReferenceFrames) },
        { "hkaiWorldCommands::ForceSilhouetteTransforms", typeof(hkaiWorldCommands.ForceSilhouetteTransforms) },
        { "hkaiWorldCommands::AddPathRequestQueue", typeof(hkaiWorldCommands.AddPathRequestQueue) },
        { "hkaiWorldCommands::SetClearanceFillFacesPerStep", typeof(hkaiWorldCommands.SetClearanceFillFacesPerStep) },
        { "hkaiWorldCommands::ResetClearanceNearFaces", typeof(hkaiWorldCommands.ResetClearanceNearFaces) },
        { "hkaiWorldCommands::SetDefaultClearanceOption", typeof(hkaiWorldCommands.SetDefaultClearanceOption) },
        { "hkaiWorldCommands::UnregisterFilter", typeof(hkaiWorldCommands.UnregisterFilter) },
        { "hkaiWorldCommands::RegisterFilter", typeof(hkaiWorldCommands.RegisterFilter) },
        { "hkaiWorldCommands::SetClearanceCeiling", typeof(hkaiWorldCommands.SetClearanceCeiling) },
        { "hkaiWorldCommands::ShiftWorldSpace", typeof(hkaiWorldCommands.ShiftWorldSpace) },
        { "hkaiWorldCommands::StepSingleThreaded", typeof(hkaiWorldCommands.StepSingleThreaded) },
        { "hkaiWorldCommands::DoSynchronousProcessingRun", typeof(hkaiWorldCommands.DoSynchronousProcessingRun) },
        { "hkaiWorldCommands::CommitAsyncProcessingRun", typeof(hkaiWorldCommands.CommitAsyncProcessingRun) },
        { "hkaiWorldCommands::CompleteAsyncProcessingRunImmediately", typeof(hkaiWorldCommands.CompleteAsyncProcessingRunImmediately) },
        { "hkaiWorldCommands::AbortAsyncProcessingRun", typeof(hkaiWorldCommands.AbortAsyncProcessingRun) },
        { "hkaiWorldCommands::StartAsyncProcessingRun", typeof(hkaiWorldCommands.StartAsyncProcessingRun) },
        { "hkaiWorldCommands::DisableAsyncProcessing", typeof(hkaiWorldCommands.DisableAsyncProcessing) },
        { "hkaiWorldCommands::EnableAsyncProcessing", typeof(hkaiWorldCommands.EnableAsyncProcessing) },
        { "hkaiWorldCommands::SetPriorityThreshold", typeof(hkaiWorldCommands.SetPriorityThreshold) },
        { "hkaiWorldCommands::SetMaxIterationsPerStep", typeof(hkaiWorldCommands.SetMaxIterationsPerStep) },
        { "hkaiWorldCommands::SetMaxRequestsPerStep", typeof(hkaiWorldCommands.SetMaxRequestsPerStep) },
        { "hkaiWorldCommands::SetDefaultVolumePathfindingInput", typeof(hkaiWorldCommands.SetDefaultVolumePathfindingInput) },
        { "hkaiWorldCommands::SetDefaultPathfindingInput", typeof(hkaiWorldCommands.SetDefaultPathfindingInput) },
        { "hkaiWorldCommands::SetAvoidancePairProperties", typeof(hkaiWorldCommands.SetAvoidancePairProperties) },
        { "hkaiWorldCommands::RemoveObstacleGenerator", typeof(hkaiWorldCommands.RemoveObstacleGenerator) },
        { "hkaiWorldCommands::AddObstacleGenerator", typeof(hkaiWorldCommands.AddObstacleGenerator) },
        { "hkaiWorldCommands::UpdateOverlapManager", typeof(hkaiWorldCommands.UpdateOverlapManager) },
        { "hkaiWorldCommands::InvalidateAllSilhouettes", typeof(hkaiWorldCommands.InvalidateAllSilhouettes) },
        { "hkaiWorldCommands::SetPerformValidationChecks", typeof(hkaiWorldCommands.SetPerformValidationChecks) },
        { "hkaiWorldCommands::SetForceSilhouetteUpdates", typeof(hkaiWorldCommands.SetForceSilhouetteUpdates) },
        { "hkaiWorldCommands::SetSilhouetteExtrusionForLayer", typeof(hkaiWorldCommands.SetSilhouetteExtrusionForLayer) },
        { "hkaiWorldCommands::SetSilhouetteExtrusionForAllLayers", typeof(hkaiWorldCommands.SetSilhouetteExtrusionForAllLayers) },
        { "hkaiWorldCommands::RemoveSilhouetteGenerator", typeof(hkaiWorldCommands.RemoveSilhouetteGenerator) },
        { "hkaiWorldCommands::AddSilhouetteGenerator", typeof(hkaiWorldCommands.AddSilhouetteGenerator) },
        { "hkaiWorldCommands::RemoveDynamicUserEdgeSet", typeof(hkaiWorldCommands.RemoveDynamicUserEdgeSet) },
        { "hkaiWorldCommands::AddDynamicUserEdgeSetups", typeof(hkaiWorldCommands.AddDynamicUserEdgeSetups) },
        { "hkaiWorldCommands::AddDynamicUserEdges", typeof(hkaiWorldCommands.AddDynamicUserEdges) },
        { "hkaiWorldCommands::CreateDynamicUserEdgeSet", typeof(hkaiWorldCommands.CreateDynamicUserEdgeSet) },
        { "hkaiWorldCommands::UnloadNavVolume", typeof(hkaiWorldCommands.UnloadNavVolume) },
        { "hkaiWorldCommands::LoadNavVolume", typeof(hkaiWorldCommands.LoadNavVolume) },
        { "hkaiWorldCommands::UnloadNavMeshGraph", typeof(hkaiWorldCommands.UnloadNavMeshGraph) },
        { "hkaiWorldCommands::LoadNavMeshGraph", typeof(hkaiWorldCommands.LoadNavMeshGraph) },
        { "hkaiWorldCommands::UnloadNavMeshInstance", typeof(hkaiWorldCommands.UnloadNavMeshInstance) },
        { "hkaiWorldCommands::LoadNavMeshInstance", typeof(hkaiWorldCommands.LoadNavMeshInstance) },
        { "hkaiWorldCommands::WorldUpdate", typeof(hkaiWorldCommands.WorldUpdate) },
        { "hkaiWorldCommands::ApiCommand", typeof(hkaiWorldCommands.ApiCommand) },
        { "hkaiWorld::Listener", typeof(hkaiWorld.Listener) },
        { "hkaiWorld::CharacterStepSerializableContext", typeof(hkaiWorld.CharacterStepSerializableContext) },
        { "hkaiWorld", typeof(hkaiWorld) },
        { "hkaiPathRequestManager", typeof(hkaiPathRequestManager) },
        { "hkaiPathRequestQueue", typeof(hkaiPathRequestQueue) },
        { "hkaiNavVolumePathRequestInfo", typeof(hkaiNavVolumePathRequestInfo) },
        { "hkaiNavVolumePathRequest", typeof(hkaiNavVolumePathRequest) },
        { "hkaiNavMeshPathRequestInfo", typeof(hkaiNavMeshPathRequestInfo) },
        { "hkaiNavMeshPathRequest", typeof(hkaiNavMeshPathRequest) },
        { "hkaiPathRequestBase", typeof(hkaiPathRequestBase) },
        { "hkaiPathRequestInfoOwner", typeof(hkaiPathRequestInfoOwner) },
        { "hkaiVolumePathfindingUtil::FindPathOutput", typeof(hkaiVolumePathfindingUtil.FindPathOutput) },
        { "hkaiVolumePathfindingUtil::FindPathInput", typeof(hkaiVolumePathfindingUtil.FindPathInput) },
        { "hkaiPathfindingUtil::FindGraphPathInput", typeof(hkaiPathfindingUtil.FindGraphPathInput) },
        { "hkaiPathfindingUtil::FindPathOutput", typeof(hkaiPathfindingUtil.FindPathOutput) },
        { "hkaiPathfindingUtil::FindPathInput", typeof(hkaiPathfindingUtil.FindPathInput) },
        { "hkaiAsyncLatencyMonitor", typeof(hkaiAsyncLatencyMonitor) },
        { "hkaiSplitGenerationUtils::Settings", typeof(hkaiSplitGenerationUtils.Settings) },
        { "hkaiSplitGenerationUtils", typeof(hkaiSplitGenerationUtils) },
        { "hkaiCuttingGeometryInfo", typeof(hkaiCuttingGeometryInfo) },
        { "hkaiSplitGenerationSnapshot", typeof(hkaiSplitGenerationSnapshot) },
        { "hkaiNavVolumeGenerationSnapshot", typeof(hkaiNavVolumeGenerationSnapshot) },
        { "hkaiNavMeshSimplificationSnapshot", typeof(hkaiNavMeshSimplificationSnapshot) },
        { "hkaiNavMeshGenerationSnapshot", typeof(hkaiNavMeshGenerationSnapshot) },
        { "hkaiSearchExpansionRecord::hkaiSingleExpansionRecord", typeof(hkaiSearchExpansionRecord.hkaiSingleExpansionRecord) },
        { "hkaiSearchExpansionRecord", typeof(hkaiSearchExpansionRecord) },
        { "hkaiOverlappingTriangles::Settings", typeof(hkaiOverlappingTriangles.Settings) },
        { "hkaiOverlappingTriangles", typeof(hkaiOverlappingTriangles) },
        { "hkaiLineOfSightUtil::LineOfSightOutput", typeof(hkaiLineOfSightUtil.LineOfSightOutput) },
        { "hkaiLineOfSightUtil::DirectPathInput", typeof(hkaiLineOfSightUtil.DirectPathInput) },
        { "hkaiLineOfSightUtil::LineOfSightInput", typeof(hkaiLineOfSightUtil.LineOfSightInput) },
        { "hkaiLineOfSightUtil::InputBase", typeof(hkaiLineOfSightUtil.InputBase) },
        { "hkaiLineOfSightUtil", typeof(hkaiLineOfSightUtil) },
        { "hkaiHierarchyUtils::ClusterSettings", typeof(hkaiHierarchyUtils.ClusterSettings) },
        { "PolygonSetup2d", typeof(PolygonSetup2d) },
        { "hkaiVolumeNavigatorStalenessChecker", typeof(hkaiVolumeNavigatorStalenessChecker) },
        { "hkaiVolumeNavigatorSignals", typeof(hkaiVolumeNavigatorSignals) },
        { "hkaiVolumeNavigatorManager", typeof(hkaiVolumeNavigatorManager) },
        { "hkaiVolumeNavigator::PathRequest", typeof(hkaiVolumeNavigator.PathRequest) },
        { "hkaiVolumeNavigator::PathRequestInput", typeof(hkaiVolumeNavigator.PathRequestInput) },
        { "hkaiVolumeNavigator::NavigatorSettings", typeof(hkaiVolumeNavigator.NavigatorSettings) },
        { "hkaiVolumeNavigator::Goal", typeof(hkaiVolumeNavigator.Goal) },
        { "hkaiVolumeNavigator::NavigationOutput", typeof(hkaiVolumeNavigator.NavigationOutput) },
        { "hkaiVolumeNavigator", typeof(hkaiVolumeNavigator) },
        { "hkaiNavigatorStalenessChecker", typeof(hkaiNavigatorStalenessChecker) },
        { "hkaiNavigatorSignals", typeof(hkaiNavigatorSignals) },
        { "hkaiNavigatorManager", typeof(hkaiNavigatorManager) },
        { "hkaiNavigatorLengthLimit", typeof(hkaiNavigatorLengthLimit) },
        { "hkaiNavigatorCapsuleLimit", typeof(hkaiNavigatorCapsuleLimit) },
        { "hkaiNavigator::PathRequest", typeof(hkaiNavigator.PathRequest) },
        { "hkaiNavigator::CornerPredictorInitInfo", typeof(hkaiNavigator.CornerPredictorInitInfo) },
        { "hkaiNavigator::PathRequestInput", typeof(hkaiNavigator.PathRequestInput) },
        { "hkaiNavigator::NavigatorSettings", typeof(hkaiNavigator.NavigatorSettings) },
        { "hkaiNavigator::Goal", typeof(hkaiNavigator.Goal) },
        { "hkaiNavigator::NavigationOutput", typeof(hkaiNavigator.NavigationOutput) },
        { "hkaiNavigator", typeof(hkaiNavigator) },
        { "hkaiNavVolumePathSearchParameters", typeof(hkaiNavVolumePathSearchParameters) },
        { "hkaiNavVolumeInstanceData::CellInstance", typeof(hkaiNavVolumeInstanceData.CellInstance) },
        { "hkaiNavVolumeInstanceData", typeof(hkaiNavVolumeInstanceData) },
        { "hkaiNavVolumeInstance", typeof(hkaiNavVolumeInstance) },
        { "hkaiNavVolume::UserEdgeInfo", typeof(hkaiNavVolume.UserEdgeInfo) },
        { "hkaiNavVolume::AxisPermutation", typeof(hkaiNavVolume.AxisPermutation) },
        { "hkaiNavVolume::Edge", typeof(hkaiNavVolume.Edge) },
        { "hkaiNavVolume::Cell", typeof(hkaiNavVolume.Cell) },
        { "hkaiNavVolume", typeof(hkaiNavVolume) },
        { "hkaiVolumeUserEdgeUtils::UserEdgeSetup::Portal", typeof(hkaiVolumeUserEdgeUtils.UserEdgeSetup.Portal) },
        { "hkaiVolumeUserEdgeUtils::UserEdgeSetup", typeof(hkaiVolumeUserEdgeUtils.UserEdgeSetup) },
        { "hkaiNavMeshUtils::ResolveEdgePenetrationsInput", typeof(hkaiNavMeshUtils.ResolveEdgePenetrationsInput) },
        { "hkaiNavMeshPathSearchParameters", typeof(hkaiNavMeshPathSearchParameters) },
        { "hkaiNavMeshInstanceData::FaceDynUserEdgeBases", typeof(hkaiNavMeshInstanceData.FaceDynUserEdgeBases) },
        { "hkaiNavMeshInstanceData", typeof(hkaiNavMeshInstanceData) },
        { "hkaiNavMeshInstance", typeof(hkaiNavMeshInstance) },
        { "hkaiNavMesh::Edge", typeof(hkaiNavMesh.Edge) },
        { "hkaiNavMesh::Face", typeof(hkaiNavMesh.Face) },
        { "hkaiNavMesh", typeof(hkaiNavMesh) },
        { "hkaiFaceEdgePair", typeof(hkaiFaceEdgePair) },
        { "hkaiFaceEdgeIndexPair", typeof(hkaiFaceEdgeIndexPair) },
        { "hkaiUserEdgePairArray", typeof(hkaiUserEdgePairArray) },
        { "hkaiUserEdgeSetupArray", typeof(hkaiUserEdgeSetupArray) },
        { "hkaiUserEdgeUtils::UserEdgePair", typeof(hkaiUserEdgeUtils.UserEdgePair) },
        { "hkaiUserEdgeUtils::UserEdgeSetup", typeof(hkaiUserEdgeUtils.UserEdgeSetup) },
        { "hkaiUserEdgeUtils::Obb", typeof(hkaiUserEdgeUtils.Obb) },
        { "hkaiUserEdgeUtils", typeof(hkaiUserEdgeUtils) },
        { "hkaiDefaultDynamicUserEdgeSetInfo::Section", typeof(hkaiDefaultDynamicUserEdgeSetInfo.Section) },
        { "hkaiDefaultDynamicUserEdgeSetInfo", typeof(hkaiDefaultDynamicUserEdgeSetInfo) },
        { "hkaiDynamicUserEdgeSetInfo::ExternalEdges", typeof(hkaiDynamicUserEdgeSetInfo.ExternalEdges) },
        { "hkaiDynamicUserEdgeSetInfo::Section", typeof(hkaiDynamicUserEdgeSetInfo.Section) },
        { "hkaiDynamicUserEdgeSetInfo::UserEdgePair", typeof(hkaiDynamicUserEdgeSetInfo.UserEdgePair) },
        { "hkaiDynamicUserEdgeSetInfo", typeof(hkaiDynamicUserEdgeSetInfo) },
        { "hkaiDynamicUserEdgeSetInfoBase::ClusterGraphEdgeAndCount", typeof(hkaiDynamicUserEdgeSetInfoBase.ClusterGraphEdgeAndCount) },
        { "hkaiDynamicUserEdgeSetInfoBase::ClusterGraphEdge", typeof(hkaiDynamicUserEdgeSetInfoBase.ClusterGraphEdge) },
        { "hkaiDynamicUserEdgeSetInfoBase::SectionIdxPair", typeof(hkaiDynamicUserEdgeSetInfoBase.SectionIdxPair) },
        { "hkaiDynamicUserEdgeSetInfoBase", typeof(hkaiDynamicUserEdgeSetInfoBase) },
        { "hkaiStreamingSetInstance::DynUserEdgeConnection", typeof(hkaiStreamingSetInstance.DynUserEdgeConnection) },
        { "hkaiStreamingSetInstance", typeof(hkaiStreamingSetInstance) },
        { "hkaiAnnotatedStreamingSet", typeof(hkaiAnnotatedStreamingSet) },
        { "hkaiStreamingSet::VolumeConnection", typeof(hkaiStreamingSet.VolumeConnection) },
        { "hkaiStreamingSet::GraphConnection", typeof(hkaiStreamingSet.GraphConnection) },
        { "hkaiStreamingSet::NavMeshConnection", typeof(hkaiStreamingSet.NavMeshConnection) },
        { "hkaiStreamingSet", typeof(hkaiStreamingSet) },
        { "hkaiStreamingCollectionInstanceInfo", typeof(hkaiStreamingCollectionInstanceInfo) },
        { "hkaiStreamingCollection", typeof(hkaiStreamingCollection) },
        { "hkaiPersistentEdgeKey", typeof(hkaiPersistentEdgeKey) },
        { "hkaiPersistentFaceKey", typeof(hkaiPersistentFaceKey) },
        { "hkaiAffineMap1D", typeof(hkaiAffineMap1D) },
        { "hkaiPolygon2D", typeof(hkaiPolygon2D) },
        { "hkaiNavMeshClearanceCacheSeeding::CacheDataSet", typeof(hkaiNavMeshClearanceCacheSeeding.CacheDataSet) },
        { "hkaiNavMeshClearanceCacheSeeding::CacheData", typeof(hkaiNavMeshClearanceCacheSeeding.CacheData) },
        { "hkaiNavMeshClearanceCacheManager::LayerData", typeof(hkaiNavMeshClearanceCacheManager.LayerData) },
        { "hkaiNavMeshClearanceCacheManager::CacheInfo", typeof(hkaiNavMeshClearanceCacheManager.CacheInfo) },
        { "hkaiNavMeshClearanceCacheManager::Registration", typeof(hkaiNavMeshClearanceCacheManager.Registration) },
        { "hkaiNavMeshClearanceCacheManager", typeof(hkaiNavMeshClearanceCacheManager) },
        { "hkaiNavMeshClearanceCache::McpDataInteger", typeof(hkaiNavMeshClearanceCache.McpDataInteger) },
        { "hkaiNavMeshClearanceCache", typeof(hkaiNavMeshClearanceCache) },
        { "hkaiGraphPathSearchParameters", typeof(hkaiGraphPathSearchParameters) },
        { "hkaiDirectedGraphInstanceData::FreeBlockList", typeof(hkaiDirectedGraphInstanceData.FreeBlockList) },
        { "hkaiDirectedGraphInstanceData", typeof(hkaiDirectedGraphInstanceData) },
        { "hkaiDirectedGraphInstance", typeof(hkaiDirectedGraphInstance) },
        { "hkaiDirectedGraphExplicitCost::Edge", typeof(hkaiDirectedGraphExplicitCost.Edge) },
        { "hkaiDirectedGraphExplicitCost::Node", typeof(hkaiDirectedGraphExplicitCost.Node) },
        { "hkaiDirectedGraphExplicitCost", typeof(hkaiDirectedGraphExplicitCost) },
        { "hkaiAgentTraversalInfo", typeof(hkaiAgentTraversalInfo) },
        { "hkaiConvexSilhouetteSet", typeof(hkaiConvexSilhouetteSet) },
        { "hkaiSilhouetteReferenceFrame", typeof(hkaiSilhouetteReferenceFrame) },
        { "hkaiSilhouetteGenerator", typeof(hkaiSilhouetteGenerator) },
        { "hkaiConvexHullSilhouetteMerger", typeof(hkaiConvexHullSilhouetteMerger) },
        { "hkaiSimpleSilhouetteMerger", typeof(hkaiSimpleSilhouetteMerger) },
        { "hkaiSilhouetteMerger", typeof(hkaiSilhouetteMerger) },
        { "hkaiSilhouetteGenerationParameters", typeof(hkaiSilhouetteGenerationParameters) },
        { "hkaiPointCloudSilhouetteGenerator", typeof(hkaiPointCloudSilhouetteGenerator) },
        { "hkaiPhysicsBodySilhouetteGeneratorBase", typeof(hkaiPhysicsBodySilhouetteGeneratorBase) },
        { "hkaiSilhouetteGeneratorSectionContext", typeof(hkaiSilhouetteGeneratorSectionContext) },
        { "hkaiReferenceFrameAndExtrusion", typeof(hkaiReferenceFrameAndExtrusion) },
        { "hkaiOverlapManager::Overlap", typeof(hkaiOverlapManager.Overlap) },
        { "hkaiOverlapManager::Generator", typeof(hkaiOverlapManager.Generator) },
        { "hkaiOverlapManager::Section", typeof(hkaiOverlapManager.Section) },
        { "hkaiOverlapManager::PendingUpdate", typeof(hkaiOverlapManager.PendingUpdate) },
        { "hkaiOverlapManager", typeof(hkaiOverlapManager) },
        { "hkaiAabbOverlapManager::Overlap", typeof(hkaiAabbOverlapManager.Overlap) },
        { "hkaiAabbOverlapManager::Node", typeof(hkaiAabbOverlapManager.Node) },
        { "hkaiAabbOverlapManager", typeof(hkaiAabbOverlapManager) },
        { "hkaiNavMeshSilhouetteSelector", typeof(hkaiNavMeshSilhouetteSelector) },
        { "hkaiModifiedSections::Section", typeof(hkaiModifiedSections.Section) },
        { "hkaiModifiedSections", typeof(hkaiModifiedSections) },
        { "hkaiNavMeshModifiedAabbs", typeof(hkaiNavMeshModifiedAabbs) },
        { "hkaiNavMeshModifiedFaces", typeof(hkaiNavMeshModifiedFaces) },
        { "hkaiNavMeshInstanceCutter", typeof(hkaiNavMeshInstanceCutter) },
        { "hkaiNavMeshEdgeZipper::BaseEdgeOverlapRemap", typeof(hkaiNavMeshEdgeZipper.BaseEdgeOverlapRemap) },
        { "hkaiNavMeshEdgeZipper::BaseEdge", typeof(hkaiNavMeshEdgeZipper.BaseEdge) },
        { "hkaiNavMeshEdgeZipper::ZipEdgesSettings", typeof(hkaiNavMeshEdgeZipper.ZipEdgesSettings) },
        { "hkaiNavMeshEdgeZipper::ZippedInterval", typeof(hkaiNavMeshEdgeZipper.ZippedInterval) },
        { "hkaiNavMeshEdgeZipper::Interval", typeof(hkaiNavMeshEdgeZipper.Interval) },
        { "hkaiNavMeshCutter", typeof(hkaiNavMeshCutter) },
        { "hkaiNavMeshCutConfiguration::DynamicUserEdge", typeof(hkaiNavMeshCutConfiguration.DynamicUserEdge) },
        { "hkaiNavMeshCutConfiguration::BigFaceInfo", typeof(hkaiNavMeshCutConfiguration.BigFaceInfo) },
        { "hkaiNavMeshCutConfiguration::FaceInfo", typeof(hkaiNavMeshCutConfiguration.FaceInfo) },
        { "hkaiNavMeshCutConfiguration", typeof(hkaiNavMeshCutConfiguration) },
        { "hkaiNavMeshCompactUtils::CompactingState", typeof(hkaiNavMeshCompactUtils.CompactingState) },
        { "hkaiNavMeshCompactUtils", typeof(hkaiNavMeshCompactUtils) },
        { "hkaiVolume", typeof(hkaiVolume) },
        { "hkaiReferenceFrame", typeof(hkaiReferenceFrame) },
        { "hkaiPlaneVolume", typeof(hkaiPlaneVolume) },
        { "hkaiMaterialPainter", typeof(hkaiMaterialPainter) },
        { "hkaiInvertedAabbVolume", typeof(hkaiInvertedAabbVolume) },
        { "hkaiIntersectionVolume", typeof(hkaiIntersectionVolume) },
        { "hkaiCarver", typeof(hkaiCarver) },
        { "hkaiNavVolumeMediator", typeof(hkaiNavVolumeMediator) },
        { "hkaiDynamicNavVolumeMediator", typeof(hkaiDynamicNavVolumeMediator) },
        { "hkaiAabbTreeNavVolumeMediator", typeof(hkaiAabbTreeNavVolumeMediator) },
        { "hkaiStaticTreeNavMeshQueryMediator", typeof(hkaiStaticTreeNavMeshQueryMediator) },
        { "hkaiNavMeshQueryMediator", typeof(hkaiNavMeshQueryMediator) },
        { "hkaiDynamicNavMeshQueryMediator", typeof(hkaiDynamicNavMeshQueryMediator) },
        { "hkaiPath::PathPoint", typeof(hkaiPath.PathPoint) },
        { "hkaiPath", typeof(hkaiPath) },
        { "hkaiCharacter", typeof(hkaiCharacter) },
        { "hkaiPathFollowingProperties", typeof(hkaiPathFollowingProperties) },
        { "hkaiCharacterUtil", typeof(hkaiCharacterUtil) },
        { "hkaiBlockedCharacterDetector", typeof(hkaiBlockedCharacterDetector) },
        { "hkaiBehaviorBlockedDetector", typeof(hkaiBehaviorBlockedDetector) },
        { "hkaiAdaptiveRanger", typeof(hkaiAdaptiveRanger) },
        { "hkaiMovementProperties", typeof(hkaiMovementProperties) },
        { "hkaiLocalSteeringInput", typeof(hkaiLocalSteeringInput) },
        { "hkaiAvoidanceSolver::BoundaryObstacle", typeof(hkaiAvoidanceSolver.BoundaryObstacle) },
        { "hkaiAvoidanceSolver::SphereObstacle", typeof(hkaiAvoidanceSolver.SphereObstacle) },
        { "hkaiAvoidancePairProperties::PairData", typeof(hkaiAvoidancePairProperties.PairData) },
        { "hkaiAvoidancePairProperties", typeof(hkaiAvoidancePairProperties) },
        { "hkaiAvoidanceProperties", typeof(hkaiAvoidanceProperties) },
        { "hkaiSimpleObstacleGenerator", typeof(hkaiSimpleObstacleGenerator) },
        { "hkaiObstacleGenerator", typeof(hkaiObstacleGenerator) },
        { "hkaiEdgePath::TraversalState", typeof(hkaiEdgePath.TraversalState) },
        { "hkaiEdgePath::Edge", typeof(hkaiEdgePath.Edge) },
        { "hkaiEdgePath::FollowingCornerInfo", typeof(hkaiEdgePath.FollowingCornerInfo) },
        { "hkaiEdgePath", typeof(hkaiEdgePath) },
        { "hkaiCornerPredictor::UserEdgeTraversal", typeof(hkaiCornerPredictor.UserEdgeTraversal) },
        { "hkaiCornerPredictor", typeof(hkaiCornerPredictor) },
        { "hkaiSingleCharacterBehavior::RequestedGoalPoint", typeof(hkaiSingleCharacterBehavior.RequestedGoalPoint) },
        { "hkaiSingleCharacterBehavior", typeof(hkaiSingleCharacterBehavior) },
        { "hkaiPathFollowingBehavior", typeof(hkaiPathFollowingBehavior) },
        { "hkaiEdgeFollowingBehavior::CornerPredictorInitInfo", typeof(hkaiEdgeFollowingBehavior.CornerPredictorInitInfo) },
        { "hkaiEdgeFollowingBehavior", typeof(hkaiEdgeFollowingBehavior) },
        { "hkaiBehavior", typeof(hkaiBehavior) },
        { "hkaiGatePathUtil::ExponentialSchedule", typeof(hkaiGatePathUtil.ExponentialSchedule) },
        { "hkaiGatePathUtil::Gate", typeof(hkaiGatePathUtil.Gate) },
        { "hkaiGatePath::PathGate", typeof(hkaiGatePath.PathGate) },
        { "hkaiGatePath::SmoothOptions", typeof(hkaiGatePath.SmoothOptions) },
        { "hkaiGatePath::TraversalState", typeof(hkaiGatePath.TraversalState) },
        { "hkaiGatePath", typeof(hkaiGatePath) },
        { "hkaiAstarOutputParameters", typeof(hkaiAstarOutputParameters) },
        { "hkaiSearchParameters::SearchBuffers", typeof(hkaiSearchParameters.SearchBuffers) },
        { "hkaiSearchParameters::BufferSizes", typeof(hkaiSearchParameters.BufferSizes) },
        { "hkaiSearchParameters", typeof(hkaiSearchParameters) },
        { "hkaiDefaultAstarEdgeFilter", typeof(hkaiDefaultAstarEdgeFilter) },
        { "hkaiAstarEdgeFilter", typeof(hkaiAstarEdgeFilter) },
        { "hkaiDefaultAstarCostModifier", typeof(hkaiDefaultAstarCostModifier) },
        { "hkaiAstarCostModifier", typeof(hkaiAstarCostModifier) },
        { "hkaiPhysicsBodySilhouetteGenerator", typeof(hkaiPhysicsBodySilhouetteGenerator) },
        { "hkaiPhysicsBodyObstacleGenerator", typeof(hkaiPhysicsBodyObstacleGenerator) },
        { "hkaiPhysicsBodyObstacleGenerator_old", typeof(hkaiPhysicsBodyObstacleGenerator_old) },
        { "hkaiPhysicsShapeVolume", typeof(hkaiPhysicsShapeVolume) },
        { "hkaiNavVolumeGenerationSettings::MergingSettings", typeof(hkaiNavVolumeGenerationSettings.MergingSettings) },
        { "hkaiNavVolumeGenerationSettings::ChunkSettings", typeof(hkaiNavVolumeGenerationSettings.ChunkSettings) },
        { "hkaiNavVolumeGenerationSettings::MaterialConstructionInfo", typeof(hkaiNavVolumeGenerationSettings.MaterialConstructionInfo) },
        { "hkaiNavVolumeGenerationSettings", typeof(hkaiNavVolumeGenerationSettings) },
        { "hkaiNavMeshSimplificationUtils::Settings", typeof(hkaiNavMeshSimplificationUtils.Settings) },
        { "hkaiNavMeshSimplificationUtils::ExtraVertexSettings", typeof(hkaiNavMeshSimplificationUtils.ExtraVertexSettings) },
        { "hkaiNavMeshGenerationUtilsSettings::WallClimbingSettings", typeof(hkaiNavMeshGenerationUtilsSettings.WallClimbingSettings) },
        { "hkaiNavMeshGenerationUtilsSettings::RegionPruningSettings::RegionConnection", typeof(hkaiNavMeshGenerationUtilsSettings.RegionPruningSettings.RegionConnection) },
        { "hkaiNavMeshGenerationUtilsSettings::RegionPruningSettings", typeof(hkaiNavMeshGenerationUtilsSettings.RegionPruningSettings) },
        { "hkaiNavMeshGenerationUtilsSettings::OverrideSettings", typeof(hkaiNavMeshGenerationUtilsSettings.OverrideSettings) },
        { "hkaiNavMeshGenerationUtilsSettings::MaterialConstructionPair", typeof(hkaiNavMeshGenerationUtilsSettings.MaterialConstructionPair) },
        { "hkaiNavMeshGenerationUtilsSettings", typeof(hkaiNavMeshGenerationUtilsSettings) },
        { "hkaiNavMeshEdgeMatchingParameters", typeof(hkaiNavMeshEdgeMatchingParameters) },
        { "hkaiNavMeshGeneration::SimpleGeometrySource", typeof(hkaiNavMeshGeneration.SimpleGeometrySource) },
        { "hkaiNavMeshGeneration::Settings", typeof(hkaiNavMeshGeneration.Settings) },
        { "hkaiNavMeshGeneration::OverlappingMaterialCombiner", typeof(hkaiNavMeshGeneration.OverlappingMaterialCombiner) },
        { "hkaiNavMeshGeneration::GeometrySource", typeof(hkaiNavMeshGeneration.GeometrySource) },
        { "hkaiNavMeshGeneration::Snapshot", typeof(hkaiNavMeshGeneration.Snapshot) },
        { "hkaiEdgeGeometry::Face", typeof(hkaiEdgeGeometry.Face) },
        { "hkaiEdgeGeometry::Edge", typeof(hkaiEdgeGeometry.Edge) },
        { "hkaiEdgeGeometry", typeof(hkaiEdgeGeometry) },
        { "hknpGroupCollisionFilterTypes::Config<5, 5, 5, 16>", typeof(hknpGroupCollisionFilterTypes.Config) },
        { "hknpGroupCollisionFilterBase<hknpGroupCollisionFilterTypes::Config<5, 5, 5, 16>>", typeof(hknpGroupCollisionFilterBase) },
        { "hctFilterConfigurationSet::FilterStage", typeof(hctFilterConfigurationSet.FilterStage) },
        { "hctFilterConfigurationSet::Configuration", typeof(hctFilterConfigurationSet.Configuration) },
        { "hctAttributeGroupDescription", typeof(hctAttributeGroupDescription) },
        { "hctAttributeDescription", typeof(hctAttributeDescription) },
        { "hctAttributeDescription::Enum::Item", typeof(hctAttributeDescription.Enum.Item) },
        { "hctAttributeDescription::Enum", typeof(hctAttributeDescription.Enum) },
        { "hctClothSetupObjectData", typeof(hctClothSetupObjectData) },
        { "hctClothSetupClothData20141Options", typeof(hctClothSetupClothData20141Options) },
        { "T*<hkaiMinArrayEntry<hkViewPtr<hkaiCollisionAvoidance::Character>>>", typeof(hkaiMinArrayEntry<hkaiCollisionAvoidance.Character?>) },
        { "T*<hkaiCollisionAvoidance::ObstacleGenerator>", typeof(hkaiCollisionAvoidance.ObstacleGenerator) },
        { "T*<hkaiCollisionAvoidance::ReferencedScoreModifier>", typeof(hkaiCollisionAvoidance.ReferencedScoreModifier) },
        { "T*<hkaiCollisionAvoidance::Filter>", typeof(hkaiCollisionAvoidance.Filter) },
        { "T*<hkRefPtr<hkaiCollisionAvoidance::ObstacleGenerator>>", typeof(hkaiCollisionAvoidance.ObstacleGenerator) },
        { "T*<hkViewPtr<hkaiCollisionAvoidance::Character>>", typeof(hkaiCollisionAvoidance.Character) },
        { "T*<hkRefPtr<hkaiCollisionAvoidance::Character>>", typeof(hkaiCollisionAvoidance.Character) },
        { "T*<hkaiCollisionAvoidance::SphereObstacle>", typeof(hkaiCollisionAvoidance.SphereObstacle) },
        { "T*<hkaiCollisionAvoidance::LineSegmentObstacle>", typeof(hkaiCollisionAvoidance.LineSegmentObstacle) },
        { "T*<hkaiCollisionAvoidance::System>", typeof(hkaiCollisionAvoidance.System) },
        { "T*<hkRefPtr<hkaiCollisionAvoidance::ReferencedScoreModifier>>", typeof(hkaiCollisionAvoidance.ReferencedScoreModifier) },
        { "T*<hkaiCollisionAvoidance::BoundaryGatherer>", typeof(hkaiCollisionAvoidance.BoundaryGatherer) },
        { "T*<hkaiCollisionAvoidance::NeighborCollector>", typeof(hkaiCollisionAvoidance.NeighborCollector) },
        { "T*<hkaiCollisionAvoidance::Character>", typeof(hkaiCollisionAvoidance.Character) },
        { "T*<fsnpCustomMeshParameter::PrimitiveData>", typeof(fsnpCustomMeshParameter.PrimitiveData) },
        { "T*<fsnpCustomMeshParameter::TriangleData>", typeof(fsnpCustomMeshParameter.TriangleData) },
        { "T*<fsnpCustomMeshParameter>", typeof(fsnpCustomMeshParameter) },
        { "T*<CustomLookAtTwistModifier::TwistParam>", typeof(CustomLookAtTwistModifier.TwistParam) },
        { "T*<hkFreeListArrayElement<hknpMotionProperties>>", typeof(hkFreeListArrayElementHknpMotionProperties) },
        { "T*<hkFreeListArrayElement<hknpMaterial>>", typeof(hkFreeListArrayElementHknpMaterial) },
        { "T*<hkFreeListArrayElement<hknpShapeInstance>>", typeof(hkFreeListArrayElementHknpShapeInstance) },
        { "T*<hkHandle<short, 32767>>", typeof(hkHandle<short>) },
        { "T*<hknpParticleShapeProperties>", typeof(hknpParticleShapeProperties) },
        { "T*<hknpPhysicsSystemData>", typeof(hknpPhysicsSystemData) },
        { "T*<hknpParticleFaceVerticesWithEffMass>", typeof(hknpParticleFaceVerticesWithEffMass) },
        { "T*<hknpParticle4Faces>", typeof(hknpParticle4Faces) },
        { "T*<hkScopedPtr<hknpParticleShapeProperties>>", typeof(hknpParticleShapeProperties) },
        { "T*<hknpStorageParticleSystem>", typeof(hknpStorageParticleSystem) },
        { "T*<hknpWorldSnapshot::ConstraintGroupInfo>", typeof(hknpWorldSnapshot.ConstraintGroupInfo) },
        { "T*<hknpMotion>", typeof(hknpMotion) },
        { "T*<hknpBody>", typeof(hknpBody) },
        { "T*<hkRefPtr<hknpConvexShape>>", typeof(hknpConvexShape) },
        { "T*<hknpConvexShape>", typeof(hknpConvexShape) },
        { "T*<hknpVehicleInstance::WheelInfo>", typeof(hknpVehicleInstance.WheelInfo) },
        { "T*<hknpVehicleData::WheelComponentParams>", typeof(hknpVehicleData.WheelComponentParams) },
        { "T*<hknpVehicleLinearCastWheelCollide::WheelState>", typeof(hknpVehicleLinearCastWheelCollide.WheelState) },
        { "T*<T*<hknpTyremarksWheel>>", typeof(hknpTyremarksWheel) },
        { "T*<hknpTyremarkPoint>", typeof(hknpTyremarkPoint) },
        { "T*<hknpVehicleSuspension::SuspensionWheelParameters>", typeof(hknpVehicleSuspension.SuspensionWheelParameters) },
        { "T*<hknpVehicleDefaultSuspension::WheelSpringSuspensionParameters>", typeof(hknpVehicleDefaultSuspension.WheelSpringSuspensionParameters) },
        { "T*<hknp1dAngularFollowCamCinfo::CameraSet>", typeof(hknp1dAngularFollowCamCinfo.CameraSet) },
        { "T*<hknpVehicleDefaultBrake::WheelBrakingProperties>", typeof(hknpVehicleDefaultBrake.WheelBrakingProperties) },
        { "T*<hknpConstraintCinfo>", typeof(hknpConstraintCinfo) },
        { "T*<hknpPhysicsSystemData::bodyCinfoWithAttachment>", typeof(hknpPhysicsSystemData.bodyCinfoWithAttachment) },
        { "T*<hknpMotionProperties>", typeof(hknpMotionProperties) },
        { "T*<hkRefPtr<hknpPhysicsSystemData>>", typeof(hknpPhysicsSystemData) },
        { "T*<hknpMaterial>", typeof(hknpMaterial) },
        { "T*<hknpMotionPropertiesData>", typeof(hknpMotionPropertiesData) },
        { "T*<hknpBodyQuality>", typeof(hknpBodyQuality) },
        { "T*<hknpBodyIntegrator>", typeof(hknpBodyIntegrator) },
        { "T*<hknpBroadPhaseConfig>", typeof(hknpBroadPhaseConfig) },
        { "T*<hknpBodyQualityLibrary>", typeof(hknpBodyQualityLibrary) },
        { "T*<hknpMotionPropertiesLibrary>", typeof(hknpMotionPropertiesLibrary) },
        { "T*<hknpMaterialLibrary>", typeof(hknpMaterialLibrary) },
        { "T*<hknpParticleCollisionPair>", typeof(hknpParticleCollisionPair) },
        { "T*<hknpParticleCacheMoveInfo>", typeof(hknpParticleCacheMoveInfo) },
        { "T*<hknpMaterialDescriptor>", typeof(hknpMaterialDescriptor) },
        { "T*<hknpRefMaterial>", typeof(hknpRefMaterial) },
        { "T*<hknpRefDragProperties>", typeof(hknpRefDragProperties) },
        { "T*<hknpRefMassDistribution>", typeof(hknpRefMassDistribution) },
        { "T*<hkRefCountedProperties>", typeof(hkRefCountedProperties) },
        { "T*<hknpShapeInstanceId>", typeof(hknpShapeInstanceId) },
        { "T*<hknpConvexPolytopeShape::Connectivity::Edge>", typeof(hknpConvexPolytopeShape.Connectivity.Edge) },
        { "T*<hknpConvexPolytopeShape::Connectivity>", typeof(hknpConvexPolytopeShape.Connectivity) },
        { "T*<hknpExtendedExternMeshShapeGeometry::Quad>", typeof(hknpExtendedExternMeshShapeGeometry.Quad) },
        { "T*<hknpExtendedExternMeshShapeGeometry::Triangle>", typeof(hknpExtendedExternMeshShapeGeometry.Triangle) },
        { "T*<hknpShapeInstance>", typeof(hknpShapeInstance) },
        { "T*<hknpMinMaxQuadTree::MinMaxLevel>", typeof(hknpMinMaxQuadTree.MinMaxLevel) },
        { "T*<hknpHeightFieldBoundingVolume>", typeof(hknpHeightFieldBoundingVolume) },
        { "T*<hknpHeightFieldGeometry>", typeof(hknpHeightFieldGeometry) },
        { "T*<T*<hknpShapeKeyMask>>", typeof(hknpShapeKeyMask) },
        { "T*<hknpCompoundShape::VelocityInfo>", typeof(hknpCompoundShape.VelocityInfo) },
        { "T*<hknpTyremarksWheel>", typeof(hknpTyremarksWheel) },
        { "T*<hknpVehicleDriverInputStatus>", typeof(hknpVehicleDriverInputStatus) },
        { "T*<hknpVehicleVelocityDamper>", typeof(hknpVehicleVelocityDamper) },
        { "T*<hknpTyremarksInfo>", typeof(hknpTyremarksInfo) },
        { "T*<hknpVehicleWheelCollide>", typeof(hknpVehicleWheelCollide) },
        { "T*<hknpVehicleAerodynamics>", typeof(hknpVehicleAerodynamics) },
        { "T*<hknpVehicleSuspension>", typeof(hknpVehicleSuspension) },
        { "T*<hknpVehicleBrake>", typeof(hknpVehicleBrake) },
        { "T*<hknpVehicleTransmission>", typeof(hknpVehicleTransmission) },
        { "T*<hknpVehicleEngine>", typeof(hknpVehicleEngine) },
        { "T*<hknpVehicleSteering>", typeof(hknpVehicleSteering) },
        { "T*<hknpVehicleDriverInput>", typeof(hknpVehicleDriverInput) },
        { "T*<hknpVehicleData>", typeof(hknpVehicleData) },
        { "T*<hknpRefWorldCinfo>", typeof(hknpRefWorldCinfo) },
        { "T*<hknpFirstPersonGun>", typeof(hknpFirstPersonGun) },
        { "T*<hknpShapeTagCodec>", typeof(hknpShapeTagCodec) },
        { "T*<hknpCollisionFilter>", typeof(hknpCollisionFilter) },
        { "T*<hknpSurfaceVelocity>", typeof(hknpSurfaceVelocity) },
        { "T*<hknpExternMeshShapeGeometry>", typeof(hknpExternMeshShapeGeometry) },
        { "T*<hknpCompoundShape>", typeof(hknpCompoundShape) },
        { "T*<hknpShapeKeyMask>", typeof(hknpShapeKeyMask) },
        { "T*<hkcdDefaultStaticMeshTree>", typeof(hkcdDefaultStaticMeshTree) },
        { "T*<hknpCompressedMeshShape>", typeof(hknpCompressedMeshShape) },
        { "T*<hkxSpline>", typeof(hkxSpline) },
        { "T*<hkxTextureFile>", typeof(hkxTextureFile) },
        { "T*<hkxTextureInplace>", typeof(hkxTextureInplace) },
        { "T*<hkxLight>", typeof(hkxLight) },
        { "T*<hkxCamera>", typeof(hkxCamera) },
        { "T*<hkxNodeSelectionSet>", typeof(hkxNodeSelectionSet) },
        { "T*<hkxVertexAnimation>", typeof(hkxVertexAnimation) },
        { "T*<hkxIndexBuffer>", typeof(hkxIndexBuffer) },
        { "T*<hkxMesh::UserChannelInfo>", typeof(hkxMesh.UserChannelInfo) },
        { "T*<hkxMaterialShader>", typeof(hkxMaterialShader) },
        { "T*<hkxSpline::ControlPoint>", typeof(hkxSpline.ControlPoint) },
        { "T*<hkRefPtr<hkxSpline>>", typeof(hkxSpline) },
        { "T*<hkRefPtr<hkxSkinBinding>>", typeof(hkxSkinBinding) },
        { "T*<hkRefPtr<hkxTextureFile>>", typeof(hkxTextureFile) },
        { "T*<hkRefPtr<hkxTextureInplace>>", typeof(hkxTextureInplace) },
        { "T*<hkRefPtr<hkxMesh>>", typeof(hkxMesh) },
        { "T*<hkRefPtr<hkxLight>>", typeof(hkxLight) },
        { "T*<hkRefPtr<hkxCamera>>", typeof(hkxCamera) },
        { "T*<hkRefPtr<hkxNodeSelectionSet>>", typeof(hkxNodeSelectionSet) },
        { "T*<hkxVertexDescription::ElementDecl>", typeof(hkxVertexDescription.ElementDecl) },
        { "T*<hkxVertexAnimation::UsageMap>", typeof(hkxVertexAnimation.UsageMap) },
        { "T*<hkRefPtr<hkxVertexAnimation>>", typeof(hkxVertexAnimation) },
        { "T*<hkRefPtr<hkxIndexBuffer>>", typeof(hkxIndexBuffer) },
        { "T*<hkxVertexBuffer>", typeof(hkxVertexBuffer) },
        { "T*<hkRefPtr<hkxMesh::UserChannelInfo>>", typeof(hkxMesh.UserChannelInfo) },
        { "T*<hkRefPtr<hkxMeshSection>>", typeof(hkxMeshSection) },
        { "T*<hkxBlendShapeCollectionChannel::Channel>", typeof(hkxBlendShapeCollectionChannel.Channel) },
        { "T*<hkxBlendShapeCollectionChannel::FloatCurve>", typeof(hkxBlendShapeCollectionChannel.FloatCurve) },
        { "T*<hkxBlendShapeCollectionChannel::KeyFrame>", typeof(hkxBlendShapeCollectionChannel.KeyFrame) },
        { "T*<hkxBlendShapeCollectionChannel::FloatCurveKey>", typeof(hkxBlendShapeCollectionChannel.FloatCurveKey) },
        { "T*<hkxBlendShapeCollectionChannel::BlendShape>", typeof(hkxBlendShapeCollectionChannel.BlendShape) },
        { "T*<hkRefPtr<hkxMaterialShader>>", typeof(hkxMaterialShader) },
        { "T*<hkxMaterial::Property>", typeof(hkxMaterial.Property) },
        { "T*<hkxMaterial>", typeof(hkxMaterial) },
        { "T*<hkRefPtr<hkxMaterial>>", typeof(hkxMaterial) },
        { "T*<hkxMaterial::TextureStage>", typeof(hkxMaterial.TextureStage) },
        { "T*<hkxNode::AnnotationData>", typeof(hkxNode.AnnotationData) },
        { "T*<hkRefPtr<hkxNode>>", typeof(hkxNode) },
        { "T*<hkxEnvironment::Variable>", typeof(hkxEnvironment.Variable) },
        { "T*<hkxEnum>", typeof(hkxEnum) },
        { "T*<hkxEnum::Item>", typeof(hkxEnum.Item) },
        { "T*<hkxAttributeGroup>", typeof(hkxAttributeGroup) },
        { "T*<hkxAttribute>", typeof(hkxAttribute) },
        { "T*<hkpConstraintData>", typeof(hkpConstraintData) },
        { "T*<hkpParametricCurve>", typeof(hkpParametricCurve) },
        { "T*<hkpWheelFrictionConstraintAtom::Axle>", typeof(hkpWheelFrictionConstraintAtom.Axle) },
        { "T*<hkpConstraintMotor>", typeof(hkpConstraintMotor) },
        { "T*<hkMeshTexture>", typeof(hkMeshTexture) },
        { "T*<hkaSkeleton::Partition>", typeof(hkaSkeleton.Partition) },
        { "T*<hkaSkeleton::LocalFrameOnBone>", typeof(hkaSkeleton.LocalFrameOnBone) },
        { "T*<hkaBone>", typeof(hkaBone) },
        { "T*<hkSkinnedMeshShape>", typeof(hkSkinnedMeshShape) },
        { "T*<hkSkinnedMeshShape::Part>", typeof(hkSkinnedMeshShape.Part) },
        { "T*<hkSkinnedMeshShape::BoneSection>", typeof(hkSkinnedMeshShape.BoneSection) },
        { "T*<hkSkinnedMeshShape::BoneSet>", typeof(hkSkinnedMeshShape.BoneSet) },
        { "T*<hkMultipleVertexBuffer::VertexBufferInfo>", typeof(hkMultipleVertexBuffer.VertexBufferInfo) },
        { "T*<hkMultipleVertexBuffer::ElementInfo>", typeof(hkMultipleVertexBuffer.ElementInfo) },
        { "T*<hkMemoryMeshVertexBuffer>", typeof(hkMemoryMeshVertexBuffer) },
        { "T*<hkMultipleVertexBuffer::LockedElement>", typeof(hkMultipleVertexBuffer.LockedElement) },
        { "T*<hkMeshMaterial>", typeof(hkMeshMaterial) },
        { "T*<hkMemoryMeshShape::Section>", typeof(hkMemoryMeshShape.Section) },
        { "T*<hkRefPtr<hkMeshTexture>>", typeof(hkMeshTexture) },
        { "T*<T*<hkMeshVertexBuffer>>", typeof(hkMeshVertexBuffer) },
        { "T*<hkIndexedTransformSet>", typeof(hkIndexedTransformSet) },
        { "T*<T*<hkMeshBody>>", typeof(hkMeshBody) },
        { "T*<hkDefaultCompoundMeshShape::MeshSection>", typeof(hkDefaultCompoundMeshShape.MeshSection) },
        { "T*<T*<hkMeshShape>>", typeof(hkMeshShape) },
        { "T*<hkMeshVertexBuffer>", typeof(hkMeshVertexBuffer) },
        { "T*<hkMeshBody>", typeof(hkMeshBody) },
        { "T*<hkMeshShape>", typeof(hkMeshShape) },
        { "T*<hkMeshBoneIndexMapping>", typeof(hkMeshBoneIndexMapping) },
        { "T*<hkDefaultCompoundMeshShape>", typeof(hkDefaultCompoundMeshShape) },
        { "T*<hkcdDynamicTree::CodecRawUint>", typeof(hkcdDynamicTree.CodecRawUint) },
        { "T*<hkcdDynamicTree::CodecRawUlong>", typeof(hkcdDynamicTree.CodecRawUlong) },
        { "T*<hkcdStaticAabbTree::Impl>", typeof(hkcdStaticAabbTree.Impl) },
        { "T*<hkcdDefaultStaticMeshTree::PrimitiveDataRun>", typeof(hkcdDefaultStaticMeshTree.PrimitiveDataRun) },
        { "T*<hkcdDynamicAabbTree::Impl>", typeof(hkcdDynamicAabbTree.Impl) },
        { "T*<hkcdDynamicTree::CodecInt16>", typeof(hkcdDynamicTree.CodecInt16) },
        { "T*<hkcdDynamicTree::Codec32>", typeof(hkcdDynamicTree.Codec32) },
        { "T*<hkcdDynamicTree::CodecRaw<unsigned int>>", typeof(hkcdDynamicTree.CodecRaw<uint>) },
        { "T*<hkcdDynamicTree::CodecRaw<unsigned long long>>", typeof(hkcdDynamicTree.CodecRaw<ulong>) },
        { "T*<hkcdCompressedAabbCodecs::UncompressedAabbCodec>", typeof(hkcdCompressedAabbCodecs.UncompressedAabbCodec) },
        { "T*<hkcdCompressedAabbCodecs::Aabb6BytesCodec>", typeof(hkcdCompressedAabbCodecs.Aabb6BytesCodec) },
        { "T*<hkcdCompressedAabbCodecs::Aabb5BytesCodec>", typeof(hkcdCompressedAabbCodecs.Aabb5BytesCodec) },
        { "T*<hkcdCompressedAabbCodecs::Aabb4BytesCodec>", typeof(hkcdCompressedAabbCodecs.Aabb4BytesCodec) },
        { "T*<hkHandle<unsigned int, -1>>", typeof(hkHandle<uint>) },
        { "T*<hkTuple<unsigned int, unsigned int, void, void, void, void, void, void>>", typeof(hkTuple2<uint, uint>) },
        { "T*<hkcdPlanarGeometryPlanesCollection>", typeof(hkcdPlanarGeometryPlanesCollection) },
        { "T*<hkcdStaticMeshTree::Primitive>", typeof(hkcdStaticMeshTree.Primitive) },
        { "T*<hkcdStaticMeshTree::Section>", typeof(hkcdStaticMeshTree.Section) },
        { "T*<hkHandle<hkUint32, -1>>", typeof(hkHandle<uint>) },
        { "T*<hkcdStaticMeshTree::Connectivity::SectionHeader>", typeof(hkcdStaticMeshTree.Connectivity.SectionHeader) },
        { "T*<hkTuple<hkUint32, hkUint32, void, void, void, void, void, void>>", typeof(hkTuple2<uint, uint>) },
        { "T*<hkcdSimdTree::Dynamic::NodeData>", typeof(hkcdSimdTree.Dynamic.NodeData) },
        { "T*<hkcdSimdTree::Node>", typeof(hkcdSimdTree.Node) },
        { "T*<hkcdPlanarSolid::Node>", typeof(hkcdPlanarSolid.Node) },
        { "T*<hkcdPlanarSolid::NodeStorage>", typeof(hkcdPlanarSolid.NodeStorage) },
        { "T*<hkcdPlanarGeometryPrimitives::Plane>", typeof(hkcdPlanarGeometryPrimitives.Plane) },
        { "T*<hkcdPlanarGeometryPolygonCollection>", typeof(hkcdPlanarGeometryPolygonCollection) },
        { "T*<hkcdPlanarEntity::PlanesCollection>", typeof(hkcdPlanarEntity.PlanesCollection) },
        { "T*<hkcdPlanarGeometry>", typeof(hkcdPlanarGeometry) },
        { "T*<hkcdPlanarSolid>", typeof(hkcdPlanarSolid) },
        { "T*<hkReflect::ArrayType>", typeof(IHavokObject) },
        { "T*<hkReflect::RecordType>", typeof(IHavokObject) },
        { "T*<hkReflect::OpaqueType>", typeof(IHavokObject) },
        { "T*<hkReflect::VoidType>", typeof(IHavokObject) },
        { "T*<hkReflect::BoolType>", typeof(IHavokObject) },
        { "T*<hkReflect::StringType>", typeof(IHavokObject) },
        { "T*<hkReflect::FloatType>", typeof(IHavokObject) },
        { "T*<hkReflect::IntType>", typeof(IHavokObject) },
        { "T*<hkReflect::PointerType>", typeof(IHavokObject) },
        { "T*<void>", typeof(object) },
        { "T*<hkHashMapDetail::MapTuple<hkPropertyId, hkReflect::Any>>", typeof(hkHashMapDetail.MapTuple<hkPropertyId, object>) },
        { "T*<hkIntRealPair>", typeof(hkIntRealPair) },
        { "T*<T*<hkLocalFrame>>", typeof(hkLocalFrame) },
        { "T*<hkMemoryResourceHandle>", typeof(hkMemoryResourceHandle) },
        { "T*<hkWeakPtrTest::Foo>", typeof(hkWeakPtrTest.Foo) },
        { "T*<PropertyBagTest::GraphObject>", typeof(PropertyBagTest.GraphObject) },
        { "T*<T*<hkReflect::Type>>", typeof(IHavokObject) },
        { "T*<hkRefCountedProperties::Entry>", typeof(hkRefCountedProperties.Entry) },
        { "T*<hkPropertyDesc>", typeof(hkPropertyDesc) },
        { "T*<hkGeometry::Triangle>", typeof(hkGeometry.Triangle) },
        { "T*<hkSimpleLocalFrame::ChildPointer>", typeof(hkLocalFrame) },
        { "T*<hkAsyncThreadPool::ThreadPriority>", typeof(hkAsyncThreadPool.ThreadPriority?) },
        { "T*<hkRootLevelContainer::NamedVariant>", typeof(hkRootLevelContainer.NamedVariant) },
        { "T*<hkRefPtr<hkMemoryResourceContainer>>", typeof(hkMemoryResourceContainer) },
        { "T*<hkRefPtr<hkMemoryResourceHandle>>", typeof(hkMemoryResourceHandle) },
        { "T*<hkMemoryResourceHandle::ExternalLink>", typeof(hkMemoryResourceHandle.ExternalLink) },
        { "T*<hctFilterConfigurationSet::FilterStage>", typeof(hctFilterConfigurationSet.FilterStage) },
        { "T*<hctFilterConfigurationSet::Configuration>", typeof(hctFilterConfigurationSet.Configuration) },
        { "T*<T*<hctClothSetupObjectData>>", typeof(hctClothSetupObjectData) },
        { "T*<T*<hctClothSetupClothData20141Options>>", typeof(hctClothSetupClothData20141Options) },
        { "T*<hctAttributeGroupDescription>", typeof(hctAttributeGroupDescription) },
        { "T*<hctAttributeDescription>", typeof(hctAttributeDescription) },
        { "T*<hctAttributeDescription::Enum::Item>", typeof(hctAttributeDescription.Enum.Item) },
        { "T*<hctAttributeDescription::Enum>", typeof(hctAttributeDescription.Enum) },
        { "T*<hkMonitorStreamColorTable::ColorPair>", typeof(hkMonitorStreamColorTable.ColorPair) },
        { "T*<hkMonitorStreamTypeMap::TypeMap>", typeof(hkMonitorStreamTypeMap.TypeMap) },
        { "T*<hkMonitorStreamStringMap::StringMap>", typeof(hkMonitorStreamStringMap.StringMap) },
        { "T*<hkGpuTraceResult>", typeof(hkGpuTraceResult) },
        { "T*<hkBaseObject>", typeof(hkBaseObject) },
        { "T*<hctClothSetupObjectData>", typeof(hctClothSetupObjectData) },
        { "T*<hctClothSetupClothData20141Options>", typeof(hctClothSetupClothData20141Options) },
        { "T*<hkDefaultPropertyBag>", typeof(hkDefaultPropertyBag) },
        { "T*<hkLocalFrameGroup>", typeof(hkLocalFrameGroup) },
        { "T*<hkSerialize::CompatTypeParentInfo::Parent>", typeof(hkSerialize.CompatTypeParentInfo.Parent) },
        { "T*<hkMemoryResourceContainer>", typeof(hkMemoryResourceContainer) },
        { "T*<hkQuaternionf>", typeof(Quaternion) },
        { "T*<hkQTransformf>", typeof(hkQTransformf) },
        { "T*<hkStringBuf>", typeof(string) },
        { "T*<hkTransformf>", typeof(Matrix4x4) },
        { "T*<hkaMeshBinding>", typeof(hkaMeshBinding) },
        { "T*<hkaBoneAttachment>", typeof(hkaBoneAttachment) },
        { "T*<hkaAnimationBinding>", typeof(hkaAnimationBinding) },
        { "T*<hkaFootstepAnalysisInfo>", typeof(hkaFootstepAnalysisInfo) },
        { "T*<hkRefPtr<hkaMeshBinding>>", typeof(hkaMeshBinding) },
        { "T*<hkRefPtr<hkaBoneAttachment>>", typeof(hkaBoneAttachment) },
        { "T*<hkRefPtr<hkaAnimationBinding>>", typeof(hkaAnimationBinding) },
        { "T*<hkRefPtr<hkaAnimation>>", typeof(hkaAnimation) },
        { "T*<hkRefPtr<hkaSkeleton>>", typeof(hkaSkeleton) },
        { "T*<hkRefPtr<hkaFootstepAnalysisInfo>>", typeof(hkaFootstepAnalysisInfo) },
        { "T*<hkaSkeletonMapperData::ChainMapping>", typeof(hkaSkeletonMapperData.ChainMapping) },
        { "T*<hkaSkeletonMapperData::SimpleMapping>", typeof(hkaSkeletonMapperData.SimpleMapping) },
        { "T*<hkaSkeletonMapperData::PartitionMappingRange>", typeof(hkaSkeletonMapperData.PartitionMappingRange) },
        { "T*<hkTransform>", typeof(Matrix4x4) },
        { "T*<hkaMeshBinding::Mapping>", typeof(hkaMeshBinding.Mapping) },
        { "T*<hkaAnnotationTrack::Annotation>", typeof(hkaAnnotationTrack.Annotation) },
        { "T*<hkaAnimation>", typeof(hkaAnimation) },
        { "T*<hkaAnnotationTrack>", typeof(hkaAnnotationTrack) },
        { "T*<hkaAnimatedReferenceFrame>", typeof(hkaAnimatedReferenceFrame) },
        { "T*<hclNamedTransformSetSetupObject>", typeof(hclNamedTransformSetSetupObject) },
        { "T*<hclNamedSetupMesh>", typeof(hclNamedSetupMesh) },
        { "T*<hclClothSetupObject>", typeof(hclClothSetupObject) },
        { "T*<hclSimClothSetupObject::PerInstanceCollidable>", typeof(hclSimClothSetupObject.PerInstanceCollidable) },
        { "T*<hclSetupMeshSection::Triangle>", typeof(hclSetupMeshSection.Triangle) },
        { "T*<T*<hclStorageSetupMeshSection::BoneInfluences>>", typeof(hclStorageSetupMeshSection.BoneInfluences) },
        { "T*<T*<hclStorageSetupMeshSection::SectionTriangleSelectionChannel>>", typeof(hclStorageSetupMeshSection.SectionTriangleSelectionChannel) },
        { "T*<T*<hclStorageSetupMeshSection::SectionEdgeSelectionChannel>>", typeof(hclStorageSetupMeshSection.SectionEdgeSelectionChannel) },
        { "T*<T*<hclStorageSetupMeshSection::SectionVertexChannel>>", typeof(hclStorageSetupMeshSection.SectionVertexChannel) },
        { "T*<hclStorageSetupMesh::Bone>", typeof(hclStorageSetupMesh.Bone) },
        { "T*<hclStorageSetupMesh::TriangleChannel>", typeof(hclStorageSetupMesh.TriangleChannel) },
        { "T*<hclStorageSetupMesh::EdgeChannel>", typeof(hclStorageSetupMesh.EdgeChannel) },
        { "T*<hclStorageSetupMesh::VertexChannel>", typeof(hclStorageSetupMesh.VertexChannel) },
        { "T*<T*<hclStorageSetupMeshSection>>", typeof(hclStorageSetupMeshSection) },
        { "T*<T*<hclSceneDataSetupMeshSection>>", typeof(hclSceneDataSetupMeshSection) },
        { "T*<hclSimClothBufferSetupObject>", typeof(hclSimClothBufferSetupObject) },
        { "T*<T*<hclConstraintSetSetupObject>>", typeof(hclConstraintSetSetupObject) },
        { "T*<hclSimulateSetupObject::Config>", typeof(hclSimulateSetupObject.Config) },
        { "T*<hkRefPtr<hclNamedTransformSetSetupObject>>", typeof(hclNamedTransformSetSetupObject) },
        { "T*<hkRefPtr<hclNamedSetupMesh>>", typeof(hclNamedSetupMesh) },
        { "T*<hkRefPtr<hclClothSetupObject>>", typeof(hclClothSetupObject) },
        { "T*<hclBonePlanesSetupObject::PerParticleAngle>", typeof(hclBonePlanesSetupObject.PerParticleAngle) },
        { "T*<hclBonePlanesSetupObject::GlobalPlane>", typeof(hclBonePlanesSetupObject.GlobalPlane) },
        { "T*<hclBonePlanesSetupObject::PerParticlePlane>", typeof(hclBonePlanesSetupObject.PerParticlePlane) },
        { "T*<hclSimulationSetupMesh>", typeof(hclSimulationSetupMesh) },
        { "T*<T*<hclStateTransitionSetupObject>>", typeof(hclStateTransitionSetupObject) },
        { "T*<T*<hclClothStateSetupObject>>", typeof(hclClothStateSetupObject) },
        { "T*<T*<hclOperatorSetupObject>>", typeof(hclOperatorSetupObject) },
        { "T*<T*<hclSimClothSetupObject>>", typeof(hclSimClothSetupObject) },
        { "T*<T*<hclTransformSetSetupObject>>", typeof(hclTransformSetSetupObject) },
        { "T*<T*<hclBufferSetupObject>>", typeof(hclBufferSetupObject) },
        { "T*<hclStorageSetupMeshSection::BoneInfluences>", typeof(hclStorageSetupMeshSection.BoneInfluences) },
        { "T*<hclStorageSetupMeshSection::SectionTriangleSelectionChannel>", typeof(hclStorageSetupMeshSection.SectionTriangleSelectionChannel) },
        { "T*<hclStorageSetupMeshSection::SectionEdgeSelectionChannel>", typeof(hclStorageSetupMeshSection.SectionEdgeSelectionChannel) },
        { "T*<hclStorageSetupMeshSection::SectionVertexChannel>", typeof(hclStorageSetupMeshSection.SectionVertexChannel) },
        { "T*<hclStorageSetupMeshSection>", typeof(hclStorageSetupMeshSection) },
        { "T*<hclSceneDataSetupMeshSection>", typeof(hclSceneDataSetupMeshSection) },
        { "T*<hclConstraintSetSetupObject>", typeof(hclConstraintSetSetupObject) },
        { "T*<hclStateTransitionSetupObject>", typeof(hclStateTransitionSetupObject) },
        { "T*<hclClothStateSetupObject>", typeof(hclClothStateSetupObject) },
        { "T*<hclOperatorSetupObject>", typeof(hclOperatorSetupObject) },
        { "T*<hclSimClothSetupObject>", typeof(hclSimClothSetupObject) },
        { "T*<hclTransformSetSetupObject>", typeof(hclTransformSetSetupObject) },
        { "T*<hclBufferSetupObject>", typeof(hclBufferSetupObject) },
        { "T*<hkxMeshSection>", typeof(hkxMeshSection) },
        { "T*<hclSceneDataSetupMesh>", typeof(hclSceneDataSetupMesh) },
        { "T*<hkxSkinBinding>", typeof(hkxSkinBinding) },
        { "T*<hkxMesh>", typeof(hkxMesh) },
        { "T*<hkxNode>", typeof(hkxNode) },
        { "T*<hclSetupMesh>", typeof(hclSetupMesh) },
        { "T*<hkHandle<unsigned int, 2147483647>>", typeof(hkHandle<uint>) },
        { "T*<hkArray<hkHandle<unsigned int, 2147483647>, hkContainerHeapAllocator>>", typeof(List<hkHandle<uint>>) },
        { "T*<hclClothData>", typeof(hclClothData) },
        { "T*<hclTransformSetUsage::TransformTracker>", typeof(hclTransformSetUsage.TransformTracker) },
        { "T*<hclStateTransition::BlendOpTransitionData>", typeof(hclStateTransition.BlendOpTransitionData) },
        { "T*<hclStateTransition::SimClothTransitionData>", typeof(hclStateTransition.SimClothTransitionData) },
        { "T*<hkHandle<hkUint32, 2147483647>>", typeof(hkHandle<uint>) },
        { "T*<hkArray<hkHandle<hkUint32, 2147483647>, hkContainerHeapAllocator>>", typeof(List<hkHandle<uint>>) },
        { "T*<hclStateTransition::StateTransitionData>", typeof(hclStateTransition.StateTransitionData) },
        { "T*<hclStateDependencyGraph::Branch>", typeof(hclStateDependencyGraph.Branch) },
        { "T*<hclSimClothData::CollidablePinchingData>", typeof(hclSimClothData.CollidablePinchingData) },
        { "T*<T*<hclCollidable>>", typeof(hclCollidable) },
        { "T*<T*<hclConstraintSet>>", typeof(hclConstraintSet) },
        { "T*<T*<hclSimClothPose>>", typeof(hclSimClothPose) },
        { "T*<hclSimClothData::ParticleData>", typeof(hclSimClothData.ParticleData) },
        { "T*<hclVirtualCollisionPointsData::TriangleFanLandscape>", typeof(hclVirtualCollisionPointsData.TriangleFanLandscape) },
        { "T*<hclVirtualCollisionPointsData::EdgeFanLandscape>", typeof(hclVirtualCollisionPointsData.EdgeFanLandscape) },
        { "T*<hclVirtualCollisionPointsData::TriangleFan>", typeof(hclVirtualCollisionPointsData.TriangleFan) },
        { "T*<hclVirtualCollisionPointsData::TriangleFanSection>", typeof(hclVirtualCollisionPointsData.TriangleFanSection) },
        { "T*<hclVirtualCollisionPointsData::EdgeFan>", typeof(hclVirtualCollisionPointsData.EdgeFan) },
        { "T*<hclVirtualCollisionPointsData::EdgeFanSection>", typeof(hclVirtualCollisionPointsData.EdgeFanSection) },
        { "T*<hclVirtualCollisionPointsData::BarycentricPair>", typeof(hclVirtualCollisionPointsData.BarycentricPair) },
        { "T*<hclVirtualCollisionPointsData::BarycentricDictionaryEntry>", typeof(hclVirtualCollisionPointsData.BarycentricDictionaryEntry) },
        { "T*<hclVirtualCollisionPointsData::Block>", typeof(hclVirtualCollisionPointsData.Block) },
        { "T*<hclClothState::TransformSetAccess>", typeof(hclClothState.TransformSetAccess) },
        { "T*<hclClothState::BufferAccess>", typeof(hclClothState.BufferAccess) },
        { "T*<hclGatherSomeVerticesOperator::VertexPair>", typeof(hclGatherSomeVerticesOperator.VertexPair) },
        { "T*<hclUpdateSomeVertexFramesOperator::Triangle>", typeof(hclUpdateSomeVertexFramesOperator.Triangle) },
        { "T*<hclSkinOperator::BoneInfluence>", typeof(hclSkinOperator.BoneInfluence) },
        { "T*<hclSimulateOperator::Config>", typeof(hclSimulateOperator.Config) },
        { "T*<hclObjectSpaceDeformer::LocalBlockUnpackedP>", typeof(hclObjectSpaceDeformer.LocalBlockUnpackedP) },
        { "T*<hclObjectSpaceDeformer::LocalBlockP>", typeof(hclObjectSpaceDeformer.LocalBlockP) },
        { "T*<hclObjectSpaceDeformer::LocalBlockUnpackedPNT>", typeof(hclObjectSpaceDeformer.LocalBlockUnpackedPNT) },
        { "T*<hclObjectSpaceDeformer::LocalBlockPNT>", typeof(hclObjectSpaceDeformer.LocalBlockPNT) },
        { "T*<hclObjectSpaceDeformer::LocalBlockUnpackedPNTB>", typeof(hclObjectSpaceDeformer.LocalBlockUnpackedPNTB) },
        { "T*<hclObjectSpaceDeformer::LocalBlockPNTB>", typeof(hclObjectSpaceDeformer.LocalBlockPNTB) },
        { "T*<hclObjectSpaceDeformer::LocalBlockUnpackedPN>", typeof(hclObjectSpaceDeformer.LocalBlockUnpackedPN) },
        { "T*<hclObjectSpaceDeformer::LocalBlockPN>", typeof(hclObjectSpaceDeformer.LocalBlockPN) },
        { "T*<hclMoveParticlesOperator::VertexParticlePair>", typeof(hclMoveParticlesOperator.VertexParticlePair) },
        { "T*<hclMeshMeshDeformOperator::TriangleVertexPair>", typeof(hclMeshMeshDeformOperator.TriangleVertexPair) },
        { "T*<hclSimpleMeshBoneDeformOperator::TriangleBonePair>", typeof(hclSimpleMeshBoneDeformOperator.TriangleBonePair) },
        { "T*<hclMeshBoneDeformOperator::TriangleBonePair>", typeof(hclMeshBoneDeformOperator.TriangleBonePair) },
        { "T*<hclObjectSpaceDeformer::OneBlendEntryBlock>", typeof(hclObjectSpaceDeformer.OneBlendEntryBlock) },
        { "T*<hclObjectSpaceDeformer::TwoBlendEntryBlock>", typeof(hclObjectSpaceDeformer.TwoBlendEntryBlock) },
        { "T*<hclObjectSpaceDeformer::ThreeBlendEntryBlock>", typeof(hclObjectSpaceDeformer.ThreeBlendEntryBlock) },
        { "T*<hclObjectSpaceDeformer::FourBlendEntryBlock>", typeof(hclObjectSpaceDeformer.FourBlendEntryBlock) },
        { "T*<hclObjectSpaceDeformer::FiveBlendEntryBlock>", typeof(hclObjectSpaceDeformer.FiveBlendEntryBlock) },
        { "T*<hclObjectSpaceDeformer::SixBlendEntryBlock>", typeof(hclObjectSpaceDeformer.SixBlendEntryBlock) },
        { "T*<hclObjectSpaceDeformer::SevenBlendEntryBlock>", typeof(hclObjectSpaceDeformer.SevenBlendEntryBlock) },
        { "T*<hclObjectSpaceDeformer::EightBlendEntryBlock>", typeof(hclObjectSpaceDeformer.EightBlendEntryBlock) },
        { "T*<hclBoneSpaceDeformer::OneBlendEntryBlock>", typeof(hclBoneSpaceDeformer.OneBlendEntryBlock) },
        { "T*<hclBoneSpaceDeformer::TwoBlendEntryBlock>", typeof(hclBoneSpaceDeformer.TwoBlendEntryBlock) },
        { "T*<hclBoneSpaceDeformer::ThreeBlendEntryBlock>", typeof(hclBoneSpaceDeformer.ThreeBlendEntryBlock) },
        { "T*<hclBoneSpaceDeformer::FourBlendEntryBlock>", typeof(hclBoneSpaceDeformer.FourBlendEntryBlock) },
        { "T*<hclBoneSpaceDeformer::LocalBlockUnpackedP>", typeof(hclBoneSpaceDeformer.LocalBlockUnpackedP) },
        { "T*<hclBoneSpaceDeformer::LocalBlockP>", typeof(hclBoneSpaceDeformer.LocalBlockP) },
        { "T*<hclBoneSpaceDeformer::LocalBlockUnpackedPNT>", typeof(hclBoneSpaceDeformer.LocalBlockUnpackedPNT) },
        { "T*<hclBoneSpaceDeformer::LocalBlockPNT>", typeof(hclBoneSpaceDeformer.LocalBlockPNT) },
        { "T*<hclBoneSpaceDeformer::LocalBlockUnpackedPNTB>", typeof(hclBoneSpaceDeformer.LocalBlockUnpackedPNTB) },
        { "T*<hclBoneSpaceDeformer::LocalBlockPNTB>", typeof(hclBoneSpaceDeformer.LocalBlockPNTB) },
        { "T*<hclBoneSpaceDeformer::LocalBlockUnpackedPN>", typeof(hclBoneSpaceDeformer.LocalBlockUnpackedPN) },
        { "T*<hclBoneSpaceDeformer::LocalBlockPN>", typeof(hclBoneSpaceDeformer.LocalBlockPN) },
        { "T*<hclBlendSomeVerticesOperator::BlendEntry>", typeof(hclBlendSomeVerticesOperator.BlendEntry) },
        { "T*<hkRefPtr<hclClothData>>", typeof(hclClothData) },
        { "T*<hkRefPtr<hclCollidable>>", typeof(hclCollidable) },
        { "T*<hclVolumeConstraintMx::ApplySingleData>", typeof(hclVolumeConstraintMx.ApplySingleData) },
        { "T*<hclVolumeConstraintMx::ApplyBatchData>", typeof(hclVolumeConstraintMx.ApplyBatchData) },
        { "T*<hclVolumeConstraintMx::FrameSingleData>", typeof(hclVolumeConstraintMx.FrameSingleData) },
        { "T*<hclVolumeConstraintMx::FrameBatchData>", typeof(hclVolumeConstraintMx.FrameBatchData) },
        { "T*<hclVolumeConstraint::ApplyData>", typeof(hclVolumeConstraint.ApplyData) },
        { "T*<hclVolumeConstraint::FrameData>", typeof(hclVolumeConstraint.FrameData) },
        { "T*<hclTransitionConstraintSet::PerParticle>", typeof(hclTransitionConstraintSet.PerParticle) },
        { "T*<hclStretchLinkConstraintSetMx::Single>", typeof(hclStretchLinkConstraintSetMx.Single) },
        { "T*<hclStretchLinkConstraintSetMx::Batch>", typeof(hclStretchLinkConstraintSetMx.Batch) },
        { "T*<hclStretchLinkConstraintSet::Link>", typeof(hclStretchLinkConstraintSet.Link) },
        { "T*<hclStandardLinkConstraintSetMx::Single>", typeof(hclStandardLinkConstraintSetMx.Single) },
        { "T*<hclStandardLinkConstraintSetMx::Batch>", typeof(hclStandardLinkConstraintSetMx.Batch) },
        { "T*<hclStandardLinkConstraintSet::Link>", typeof(hclStandardLinkConstraintSet.Link) },
        { "T*<hclLocalRangeConstraintSet::LocalConstraint>", typeof(hclLocalRangeConstraintSet.LocalConstraint) },
        { "T*<hclCompressibleLinkConstraintSetMx::Single>", typeof(hclCompressibleLinkConstraintSetMx.Single) },
        { "T*<hclCompressibleLinkConstraintSetMx::Batch>", typeof(hclCompressibleLinkConstraintSetMx.Batch) },
        { "T*<hclCompressibleLinkConstraintSet::Link>", typeof(hclCompressibleLinkConstraintSet.Link) },
        { "T*<hclBonePlanesConstraintSet::BonePlane>", typeof(hclBonePlanesConstraintSet.BonePlane) },
        { "T*<hclBendStiffnessConstraintSetMx::Single>", typeof(hclBendStiffnessConstraintSetMx.Single) },
        { "T*<hclBendStiffnessConstraintSetMx::Batch>", typeof(hclBendStiffnessConstraintSetMx.Batch) },
        { "T*<hclBendStiffnessConstraintSet::Link>", typeof(hclBendStiffnessConstraintSet.Link) },
        { "T*<hclBendLinkConstraintSetMx::Single>", typeof(hclBendLinkConstraintSetMx.Single) },
        { "T*<hclBendLinkConstraintSetMx::Batch>", typeof(hclBendLinkConstraintSetMx.Batch) },
        { "T*<hclBendLinkConstraintSet::Link>", typeof(hclBendLinkConstraintSet.Link) },
        { "T*<hclAntiPinchConstraintSet::PerParticle>", typeof(hclAntiPinchConstraintSet.PerParticle) },
        { "T*<T*<hclAction>>", typeof(hclAction) },
        { "T*<T*<hclStateTransition>>", typeof(hclStateTransition) },
        { "T*<T*<hclClothState>>", typeof(hclClothState) },
        { "T*<T*<hclOperator>>", typeof(hclOperator) },
        { "T*<T*<hclTransformSetDefinition>>", typeof(hclTransformSetDefinition) },
        { "T*<T*<hclBufferDefinition>>", typeof(hclBufferDefinition) },
        { "T*<T*<hclSimClothData>>", typeof(hclSimClothData) },
        { "T*<hclCollidable>", typeof(hclCollidable) },
        { "T*<hclConstraintSet>", typeof(hclConstraintSet) },
        { "T*<hclSimClothPose>", typeof(hclSimClothPose) },
        { "T*<hclAction>", typeof(hclAction) },
        { "T*<hclStateTransition>", typeof(hclStateTransition) },
        { "T*<hclClothState>", typeof(hclClothState) },
        { "T*<hclOperator>", typeof(hclOperator) },
        { "T*<hclTransformSetDefinition>", typeof(hclTransformSetDefinition) },
        { "T*<hclBufferDefinition>", typeof(hclBufferDefinition) },
        { "T*<hclSimClothData>", typeof(hclSimClothData) },
        { "T*<hclStateDependencyGraph>", typeof(hclStateDependencyGraph) },
        { "T*<hclShape>", typeof(hclShape) },
        { "T*<unsigned long long>", typeof(ulong?) },
        { "T*<signed char>", typeof(sbyte?) },
        { "T*<hkbAuxiliaryNodeInfo>", typeof(hkbAuxiliaryNodeInfo) },
        { "T*<hkbBehaviorInfo::IdToNamePair>", typeof(hkbBehaviorInfo.IdToNamePair) },
        { "T*<hkRefPtr<hkbBehaviorGraph>>", typeof(hkbBehaviorGraph) },
        { "T*<hkbBehaviorGraphInternalState>", typeof(hkbBehaviorGraphInternalState) },
        { "T*<hkRefPtr<hkbAuxiliaryNodeInfo>>", typeof(hkbAuxiliaryNodeInfo) },
        { "T*<hkUint64>", typeof(ulong?) },
        { "T*<hkVariableTweakingHelper::Vector4VariableInfo>", typeof(hkVariableTweakingHelper.Vector4VariableInfo) },
        { "T*<hkVariableTweakingHelper::RealVariableInfo>", typeof(hkVariableTweakingHelper.RealVariableInfo) },
        { "T*<hkVariableTweakingHelper::IntVariableInfo>", typeof(hkVariableTweakingHelper.IntVariableInfo) },
        { "T*<hkVariableTweakingHelper::BoolVariableInfo>", typeof(hkVariableTweakingHelper.BoolVariableInfo) },
        { "T*<hkbShapeSetup>", typeof(hkbShapeSetup) },
        { "T*<hkbRadialSelectorGenerator::GeneratorPair>", typeof(hkbRadialSelectorGenerator.GeneratorPair) },
        { "T*<T*<hkbPoseStoringGeneratorOutputListener::StoredPose>>", typeof(hkbPoseStoringGeneratorOutputListener.StoredPose) },
        { "T*<hkbCustomTestGeneratorNestedTypesBase>", typeof(hkbCustomTestGeneratorNestedTypesBase) },
        { "T*<hkRefPtr<hkbCustomIdSelector>>", typeof(hkbCustomIdSelector) },
        { "T*<T*<hkbCustomIdSelector>>", typeof(hkbCustomIdSelector) },
        { "T*<hkRefPtr<hkbModifier>>", typeof(hkbModifier) },
        { "T*<hkUint16>", typeof(ushort?) },
        { "T*<hkInt8>", typeof(sbyte?) },
        { "T*<const char*>", typeof(string) },
        { "T*<bool>", typeof(bool?) },
        { "T*<hkbBodyIkControlPoint>", typeof(hkbBodyIkControlPoint) },
        { "T*<hkbBodyIkControlPin>", typeof(hkbBodyIkControlPin) },
        { "T*<hkbBodyIkControllerProfile>", typeof(hkbBodyIkControllerProfile) },
        { "T*<hkbPoseStoringGeneratorOutputListener::StoredPose>", typeof(hkbPoseStoringGeneratorOutputListener.StoredPose) },
        { "T*<hkbStateMachine>", typeof(hkbStateMachine) },
        { "T*<hkbNode>", typeof(hkbNode) },
        { "T*<hkHashMapDetail::MapTuple<T*<hkReflect::Type>, T*<void>>>", typeof(hkHashMapDetail.MapTuple<IHavokObject?, object?>) },
        { "T*<hkHashMapDetail::MapTuple<unsigned long long, T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>>>", typeof(hkHashMapDetail.MapTuple<ulong, hkHashMap<IHavokObject?, object?>?>) },
        { "T*<hkHashMapDetail::MapTuple<hkUlong, T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>>>", typeof(hkHashMapDetail.MapTuple<ulong, hkHashMap<IHavokObject?, object?>?>) },
        { "T*<hkQsTransformf>", typeof(hkQsTransformf) },
        { "T*<short>", typeof(short?) },
        { "T*<hkReflect::Type>", typeof(IHavokObject) },
        { "T*<hkbCustomPropertySheet>", typeof(hkbCustomPropertySheet) },
        { "T*<hkRefVariant>", typeof(hkReferencedObject) },
        { "T*<hkbVariableValue>", typeof(hkbVariableValue) },
        { "T*<hkbVariableBindingSet::Binding>", typeof(hkbVariableBindingSet.Binding) },
        { "T*<hkbCompiledExpressionSet::Token>", typeof(hkbCompiledExpressionSet.Token) },
        { "T*<T*<hkbTransitionEffect>>", typeof(hkbTransitionEffect) },
        { "T*<hkQsTransform>", typeof(hkQsTransform) },
        { "T*<hkbStateMachine::DelayedTransitionInfo>", typeof(hkbStateMachine.DelayedTransitionInfo) },
        { "T*<hkbStateMachine::EventPropertyArray>", typeof(hkbStateMachine.EventPropertyArray) },
        { "T*<T*<hkbStateListener>>", typeof(hkbStateListener) },
        { "T*<hkbEventProperty>", typeof(hkbEventProperty) },
        { "T*<hkbStateMachine::TransitionInfo>", typeof(hkbStateMachine.TransitionInfo) },
        { "T*<hkbCondition>", typeof(hkbCondition) },
        { "T*<T*<hkbStateMachine::StateInfo>>", typeof(hkbStateMachine.StateInfo) },
        { "T*<hkbIntVariableSequencedData::Sample>", typeof(hkbIntVariableSequencedData.Sample) },
        { "T*<hkbBoolVariableSequencedData::Sample>", typeof(hkbBoolVariableSequencedData.Sample) },
        { "T*<hkbRealVariableSequencedData::Sample>", typeof(hkbRealVariableSequencedData.Sample) },
        { "T*<hkbEventSequencedData::SequencedEvent>", typeof(hkbEventSequencedData.SequencedEvent) },
        { "T*<hkbSequenceStringData>", typeof(hkbSequenceStringData) },
        { "T*<T*<hkbIntVariableSequencedData>>", typeof(hkbIntVariableSequencedData) },
        { "T*<T*<hkbBoolVariableSequencedData>>", typeof(hkbBoolVariableSequencedData) },
        { "T*<T*<hkbRealVariableSequencedData>>", typeof(hkbRealVariableSequencedData) },
        { "T*<T*<hkbEventSequencedData>>", typeof(hkbEventSequencedData) },
        { "T*<hkbProjectStringData>", typeof(hkbProjectStringData) },
        { "T*<hkbVariableBindingSet>", typeof(hkbVariableBindingSet) },
        { "T*<hkbSenseHandleModifier::Range>", typeof(hkbSenseHandleModifier.Range) },
        { "T*<hkbKeyframeBonesModifier::KeyframeInfo>", typeof(hkbKeyframeBonesModifier.KeyframeInfo) },
        { "T*<T*<hkbModifier>>", typeof(hkbModifier) },
        { "T*<T*<hkbJigglerGroup>>", typeof(hkbJigglerGroup) },
        { "T*<hkbBoneIndexArray>", typeof(hkbBoneIndexArray) },
        { "T*<hkbHandIkModifier::Hand>", typeof(hkbHandIkModifier.Hand) },
        { "T*<hkbHandIkControlsModifier::Hand>", typeof(hkbHandIkControlsModifier.Hand) },
        { "T*<hkbFootIkModifier::InternalLegData>", typeof(hkbFootIkModifier.InternalLegData) },
        { "T*<hkbFootIkModifier::Leg>", typeof(hkbFootIkModifier.Leg) },
        { "T*<hkbFootIkControlsModifier::Leg>", typeof(hkbFootIkControlsModifier.Leg) },
        { "T*<hkBool>", typeof(bool?) },
        { "T*<hkbEventRangeDataArray>", typeof(hkbEventRangeDataArray) },
        { "T*<hkbEventRangeData>", typeof(hkbEventRangeData) },
        { "T*<hkbEvaluateExpressionModifier::InternalExpressionData>", typeof(hkbEvaluateExpressionModifier.InternalExpressionData) },
        { "T*<hkbExpressionDataArray>", typeof(hkbExpressionDataArray) },
        { "T*<hkbExpressionData>", typeof(hkbExpressionData) },
        { "T*<hkbBodyIkControlsModifier::ControlData>", typeof(hkbBodyIkControlsModifier.ControlData) },
        { "T*<hkbAttributeModifier::Assignment>", typeof(hkbAttributeModifier.Assignment) },
        { "T*<hkbAttachmentSetup>", typeof(hkbAttachmentSetup) },
        { "T*<hkRefPtr<hkbGenerator>>", typeof(hkbGenerator) },
        { "T*<hkbStateMachine::ActiveTransitionInfo>", typeof(hkbStateMachine.ActiveTransitionInfo) },
        { "T*<hkbCustomIdSelector>", typeof(hkbCustomIdSelector) },
        { "T*<T*<hkbGenerator>>", typeof(hkbGenerator) },
        { "T*<hkbClipGenerator::Echo>", typeof(hkbClipGenerator.Echo) },
        { "T*<hkbClipTriggerArray>", typeof(hkbClipTriggerArray) },
        { "T*<hkbClipTrigger>", typeof(hkbClipTrigger) },
        { "T*<hkbBlenderGenerator::ChildInternalState>", typeof(hkbBlenderGenerator.ChildInternalState) },
        { "T*<T*<hkbBlenderGeneratorChild>>", typeof(hkbBlenderGeneratorChild) },
        { "T*<hkbEventDrivenBlendingObject::InternalState>", typeof(hkbEventDrivenBlendingObject.InternalState) },
        { "T*<hkbLayerGenerator::LayerInternalState>", typeof(hkbLayerGenerator.LayerInternalState) },
        { "T*<T*<hkbLayer>>", typeof(hkbLayer) },
        { "T*<hkbBoneWeightArray>", typeof(hkbBoneWeightArray) },
        { "T*<T*<hkbEventPayload>>", typeof(hkbEventPayload) },
        { "T*<hkbHandIkDriverInfo::Hand>", typeof(hkbHandIkDriverInfo.Hand) },
        { "T*<hkbFootIkDriverInfo::Leg>", typeof(hkbFootIkDriverInfo.Leg) },
        { "T*<hkbAssetBundleStringData>", typeof(hkbAssetBundleStringData) },
        { "T*<hkbCharacterStringData::FileNameMeshNamePair>", typeof(hkbCharacterStringData.FileNameMeshNamePair) },
        { "T*<hkbCharacterData>", typeof(hkbCharacterData) },
        { "T*<hkaSkeleton>", typeof(hkaSkeleton) },
        { "T*<hkaSkeletonMapper>", typeof(hkaSkeletonMapper) },
        { "T*<hkRefPtr<hkaSkeletonMapper>>", typeof(hkaSkeletonMapper) },
        { "T*<hkRefPtr<hkbCustomPropertySheet>>", typeof(hkbCustomPropertySheet) },
        { "T*<hkMatrix4>", typeof(Matrix4x4) },
        { "T*<hkbCharacterStringData>", typeof(hkbCharacterStringData) },
        { "T*<hkbProjectData>", typeof(hkbProjectData) },
        { "T*<hkbCharacterSetup>", typeof(hkbCharacterSetup) },
        { "T*<T*<hkbCharacter>>", typeof(hkbCharacter) },
        { "T*<hkInt16>", typeof(short?) },
        { "T*<hkStringPtr>", typeof(string) },
        { "T*<hkRefPtr<hkbNodeInternalStateInfo>>", typeof(hkbNodeInternalStateInfo) },
        { "T*<hkReferencedObject>", typeof(hkReferencedObject) },
        { "T*<hkbReferencedGeneratorSyncInfo>", typeof(hkbReferencedGeneratorSyncInfo) },
        { "T*<hkbBehaviorGraphStringData>", typeof(hkbBehaviorGraphStringData) },
        { "T*<hkbVariableBounds>", typeof(hkbVariableBounds) },
        { "T*<hkbEventInfo>", typeof(hkbEventInfo) },
        { "T*<hkbVariableInfo>", typeof(hkbVariableInfo) },
        { "T*<hkbBehaviorGraphData>", typeof(hkbBehaviorGraphData) },
        { "T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>", typeof(hkHashMap<IHavokObject?, object?>) },
        { "T*<hkbStateListener>", typeof(hkbStateListener) },
        { "T*<hkbStateMachine::StateInfo>", typeof(hkbStateMachine.StateInfo) },
        { "T*<hkbIntVariableSequencedData>", typeof(hkbIntVariableSequencedData) },
        { "T*<hkbBoolVariableSequencedData>", typeof(hkbBoolVariableSequencedData) },
        { "T*<hkbRealVariableSequencedData>", typeof(hkbRealVariableSequencedData) },
        { "T*<hkbEventSequencedData>", typeof(hkbEventSequencedData) },
        { "T*<hkbModifier>", typeof(hkbModifier) },
        { "T*<hkbJigglerGroup>", typeof(hkbJigglerGroup) },
        { "T*<hkbBlenderGeneratorChild>", typeof(hkbBlenderGeneratorChild) },
        { "T*<hkbLayer>", typeof(hkbLayer) },
        { "T*<hkLocalFrame>", typeof(hkLocalFrame) },
        { "T*<hkbNodeInternalStateInfo>", typeof(hkbNodeInternalStateInfo) },
        { "T*<hkbStateMachine::TransitionInfoArray>", typeof(hkbStateMachine.TransitionInfoArray) },
        { "T*<hkbStateChooser>", typeof(hkbStateChooser) },
        { "T*<hkbHandle>", typeof(hkbHandle) },
        { "T*<hkbTransitionEffect>", typeof(hkbTransitionEffect) },
        { "T*<hkbGenerator>", typeof(hkbGenerator) },
        { "T*<hkbEventPayload>", typeof(hkbEventPayload) },
        { "T*<hkbGeneratorOutputListener>", typeof(hkbGeneratorOutputListener) },
        { "T*<hkbBehaviorGraph>", typeof(hkbBehaviorGraph) },
        { "T*<hkbCharacter>", typeof(hkbCharacter) },
        { "T*<hkbVariableValueSet>", typeof(hkbVariableValueSet) },
        { "T*<hkRefPtr<hkaiVolumeNavigator>>", typeof(hkaiVolumeNavigator) },
        { "T*<hkRefPtr<hkaiNavigator>>", typeof(hkaiNavigator) },
        { "T*<hkColor::Argb>", typeof(Color?) },
        { "T*<hkaiIndex<int>>", typeof(int?) },
        { "T*<hkaiPackedKey_<hkaiIndex<int>, hkaiIndex<int>>>", typeof(uint?) },
        { "T*<hkHashMapDetail::MapTuple<int, hkaiNavMeshInstanceData::FaceDynUserEdgeBases>>", typeof(hkHashMapDetail.MapTuple<int, hkaiNavMeshInstanceData.FaceDynUserEdgeBases>) },
        { "T*<hkHashMapDetail::MapTuple<int, hkaiDefaultDynamicUserEdgeSetInfo::Section>>", typeof(hkHashMapDetail.MapTuple<int, hkaiDefaultDynamicUserEdgeSetInfo.Section>) },
        { "T*<hkHashMapDetail::MapTuple<int, hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>>>", typeof(hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.ExternalEdges?>) },
        { "T*<hkHashMapDetail::MapTuple<int, hkaiDynamicUserEdgeSetInfo::Section>>", typeof(hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.Section>) },
        { "T*<hkHashMapDetail::MapTuple<int, hkRefPtr<hkaiStreamingSet>>>", typeof(hkHashMapDetail.MapTuple<int, hkaiStreamingSet?>) },
        { "T*<hkHashMapDetail::MapTuple<int, int>>", typeof(hkHashMapDetail.MapTuple<int, int>) },
        { "T*<hkHashMapDetail::MapTuple<int, hkaiModifiedSections::Section>>", typeof(hkHashMapDetail.MapTuple<int, hkaiModifiedSections.Section>) },
        { "T*<hkHashMapDetail::MapTuple<hkHandle<unsigned int, -1>, hkaiDynamicUserEdgeSetInfo>>", typeof(hkHashMapDetail.MapTuple<hkHandle<uint>, hkaiDynamicUserEdgeSetInfo>) },
        { "T*<hkHashMapDetail::MapTuple<int, hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>>>", typeof(hkHashMapDetail.MapTuple<int, List<hkaiNavMeshCutConfiguration.DynamicUserEdge>>) },
        { "T*<hkHashMapDetail::MapTuple<int, hkaiNavMeshCutConfiguration::BigFaceInfo>>", typeof(hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.BigFaceInfo>) },
        { "T*<hkHashMapDetail::MapTuple<int, hkaiNavMeshCutConfiguration::FaceInfo>>", typeof(hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.FaceInfo>) },
        { "T*<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiNavMeshInstanceData::FaceDynUserEdgeBases>>", typeof(hkHashMapDetail.MapTuple<int, hkaiNavMeshInstanceData.FaceDynUserEdgeBases>) },
        { "T*<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiDefaultDynamicUserEdgeSetInfo::Section>>", typeof(hkHashMapDetail.MapTuple<int, hkaiDefaultDynamicUserEdgeSetInfo.Section>) },
        { "T*<hkaiDynamicUserEdgeSetInfo::UserEdgePair>", typeof(hkaiDynamicUserEdgeSetInfo.UserEdgePair) },
        { "T*<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>>>", typeof(hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.ExternalEdges?>) },
        { "T*<hkHashMapDetail::MapTuple<hkaiDynamicUserEdgeSetInfoBase::ClusterGraphEdge, int>>", typeof(hkHashMapDetail.MapTuple<hkaiDynamicUserEdgeSetInfoBase.ClusterGraphEdge, int>) },
        { "T*<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiDynamicUserEdgeSetInfo::Section>>", typeof(hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.Section>) },
        { "T*<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkRefPtr<hkaiStreamingSet>>>", typeof(hkHashMapDetail.MapTuple<int, hkaiStreamingSet?>) },
        { "T*<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, int>>", typeof(hkHashMapDetail.MapTuple<int, int>) },
        { "T*<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiModifiedSections::Section>>", typeof(hkHashMapDetail.MapTuple<int, hkaiModifiedSections.Section>) },
        { "T*<hkHashMapDetail::MapTuple<hkHandle<hkUint32, -1>, hkaiDynamicUserEdgeSetInfo>>", typeof(hkHashMapDetail.MapTuple<hkHandle<uint>, hkaiDynamicUserEdgeSetInfo>) },
        { "T*<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>>>", typeof(hkHashMapDetail.MapTuple<int, List<hkaiNavMeshCutConfiguration.DynamicUserEdge>>) },
        { "T*<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiNavMeshCutConfiguration::BigFaceInfo>>", typeof(hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.BigFaceInfo>) },
        { "T*<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiNavMeshCutConfiguration::FaceInfo>>", typeof(hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.FaceInfo>) },
        { "T*<hkaiReferenceFrame>", typeof(hkaiReferenceFrame) },
        { "T*<hkQTransform>", typeof(hkQTransform) },
        { "T*<T*<hkaiStreamingSet>>", typeof(hkaiStreamingSet) },
        { "T*<hkaiStreamingSetInstance>", typeof(hkaiStreamingSetInstance) },
        { "T*<hkaiNavVolumeInstanceData>", typeof(hkaiNavVolumeInstanceData) },
        { "T*<hkaiNavMeshInstanceData>", typeof(hkaiNavMeshInstanceData) },
        { "T*<hkcdDynamicAabbTree>", typeof(hkcdDynamicAabbTree) },
        { "T*<hkaiDirectedGraphInstanceData>", typeof(hkaiDirectedGraphInstanceData) },
        { "T*<float>", typeof(float?) },
        { "T*<unsigned short>", typeof(ushort?) },
        { "T*<hkVector2f>", typeof(hkVector2f) },
        { "T*<unsigned int>", typeof(uint?) },
        { "T*<hkHashSet<int>>", typeof(hkHashSet<int>) },
        { "T*<hkaiDynamicUserEdgeSetInfo::ExternalEdges>", typeof(hkaiDynamicUserEdgeSetInfo.ExternalEdges) },
        { "T*<hkaiNavMeshCutConfiguration::DynamicUserEdge>", typeof(hkaiNavMeshCutConfiguration.DynamicUserEdge) },
        { "T*<hkaiPathRequestQueue>", typeof(hkaiPathRequestQueue) },
        { "T*<hkaiNavVolumePathRequest>", typeof(hkaiNavVolumePathRequest) },
        { "T*<hkaiNavMeshPathRequest>", typeof(hkaiNavMeshPathRequest) },
        { "T*<hkaiNavMeshInstanceCutter>", typeof(hkaiNavMeshInstanceCutter) },
        { "T*<hkaiLocalSteeringInput>", typeof(hkaiLocalSteeringInput) },
        { "T*<hkRefPtr<hkaiCharacter>>", typeof(hkaiCharacter) },
        { "T*<hkaiVolumeNavigatorManager>", typeof(hkaiVolumeNavigatorManager) },
        { "T*<hkaiNavigatorManager>", typeof(hkaiNavigatorManager) },
        { "T*<hkaiPathRequestManager>", typeof(hkaiPathRequestManager) },
        { "T*<hkRefPtr<hkaiObstacleGenerator>>", typeof(hkaiObstacleGenerator) },
        { "T*<hkRefPtr<hkaiSilhouetteGenerator>>", typeof(hkaiSilhouetteGenerator) },
        { "T*<hkaiOverlapManager>", typeof(hkaiOverlapManager) },
        { "T*<hkaiNavMeshCutter>", typeof(hkaiNavMeshCutter) },
        { "T*<hkRefPtr<hkaiPathRequestQueue>>", typeof(hkaiPathRequestQueue) },
        { "T*<hkRefPtr<hkaiNavVolumePathRequest>>", typeof(hkaiNavVolumePathRequest) },
        { "T*<hkRefPtr<hkaiNavMeshPathRequest>>", typeof(hkaiNavMeshPathRequest) },
        { "T*<hkaiVolumePathfindingUtil::FindPathOutput>", typeof(hkaiVolumePathfindingUtil.FindPathOutput) },
        { "T*<hkaiVolumePathfindingUtil::FindPathInput>", typeof(hkaiVolumePathfindingUtil.FindPathInput) },
        { "T*<hkaiPathfindingUtil::FindPathOutput>", typeof(hkaiPathfindingUtil.FindPathOutput) },
        { "T*<hkaiPathfindingUtil::FindPathInput>", typeof(hkaiPathfindingUtil.FindPathInput) },
        { "T*<hkaiPackedKey_<hkaiIndex<hkInt32>, hkaiIndex<hkInt32>>>", typeof(uint?) },
        { "T*<hkaiSearchExpansionRecord::hkaiSingleExpansionRecord>", typeof(hkaiSearchExpansionRecord.hkaiSingleExpansionRecord) },
        { "T*<hkReal>", typeof(float?) },
        { "T*<hkViewPtr<hkaiVolumeNavigator>>", typeof(hkaiVolumeNavigator) },
        { "T*<hkaiVolumeNavigator::PathRequestInput>", typeof(hkaiVolumeNavigator.PathRequestInput) },
        { "T*<hkaiVolumeNavigator::NavigatorSettings>", typeof(hkaiVolumeNavigator.NavigatorSettings) },
        { "T*<hkaiVolumeNavigatorStalenessChecker>", typeof(hkaiVolumeNavigatorStalenessChecker) },
        { "T*<hkaiGatePath>", typeof(hkaiGatePath) },
        { "T*<hkaiVolumeNavigator::PathRequest>", typeof(hkaiVolumeNavigator.PathRequest) },
        { "T*<hkaiVolumeNavigator::Goal>", typeof(hkaiVolumeNavigator.Goal) },
        { "T*<hkViewPtr<hkaiNavigator>>", typeof(hkaiNavigator) },
        { "T*<hkaiNavigator::PathRequestInput>", typeof(hkaiNavigator.PathRequestInput) },
        { "T*<hkaiNavigator::NavigatorSettings>", typeof(hkaiNavigator.NavigatorSettings) },
        { "T*<hkaiNavigatorStalenessChecker>", typeof(hkaiNavigatorStalenessChecker) },
        { "T*<hkaiNavigator::PathRequest>", typeof(hkaiNavigator.PathRequest) },
        { "T*<hkaiNavigator::Goal>", typeof(hkaiNavigator.Goal) },
        { "T*<hkaiNavVolumeInstanceData::CellInstance>", typeof(hkaiNavVolumeInstanceData.CellInstance) },
        { "T*<hkaiNavVolume::UserEdgeInfo>", typeof(hkaiNavVolume.UserEdgeInfo) },
        { "T*<hkaiNavVolume::Edge>", typeof(hkaiNavVolume.Edge) },
        { "T*<hkaiNavVolume::Cell>", typeof(hkaiNavVolume.Cell) },
        { "T*<hkaiIndex<hkUint16>>", typeof(ushort?) },
        { "T*<unsigned char>", typeof(byte?) },
        { "T*<hkaiCopyOnWritePtr<hkaiNavMeshClearanceCache, hkaiCopyOnWriteDefaultTraits<hkaiNavMeshClearanceCache>>>", typeof(hkaiCopyOnWritePtr<hkaiNavMeshClearanceCache>) },
        { "T*<hkaiNavMeshClearanceCacheSeeding::CacheDataSet>", typeof(hkaiNavMeshClearanceCacheSeeding.CacheDataSet) },
        { "T*<hkaiNavMesh::Edge>", typeof(hkaiNavMesh.Edge) },
        { "T*<hkaiNavMesh::Face>", typeof(hkaiNavMesh.Face) },
        { "T*<hkaiUserEdgeUtils::UserEdgePair>", typeof(hkaiUserEdgeUtils.UserEdgePair) },
        { "T*<hkaiUserEdgeUtils::UserEdgeSetup>", typeof(hkaiUserEdgeUtils.UserEdgeSetup) },
        { "T*<hkaiStreamingSetInstance::DynUserEdgeConnection>", typeof(hkaiStreamingSetInstance.DynUserEdgeConnection) },
        { "T*<hkaiStreamingSet::VolumeConnection>", typeof(hkaiStreamingSet.VolumeConnection) },
        { "T*<hkaiStreamingSet::GraphConnection>", typeof(hkaiStreamingSet.GraphConnection) },
        { "T*<hkaiStreamingSet::NavMeshConnection>", typeof(hkaiStreamingSet.NavMeshConnection) },
        { "T*<hkaiDynamicNavVolumeMediator>", typeof(hkaiDynamicNavVolumeMediator) },
        { "T*<hkaiDynamicNavMeshQueryMediator>", typeof(hkaiDynamicNavMeshQueryMediator) },
        { "T*<hkaiNavMeshClearanceCacheManager>", typeof(hkaiNavMeshClearanceCacheManager) },
        { "T*<hkaiCopyOnWritePtr<hkaiStreamingSetInstance, hkaiCopyOnWriteDefaultTraits<hkaiStreamingSetInstance>>>", typeof(hkaiCopyOnWritePtr<hkaiStreamingSetInstance>) },
        { "T*<hkaiStreamingCollectionInstanceInfo>", typeof(hkaiStreamingCollectionInstanceInfo) },
        { "T*<hkVector2>", typeof(hkVector2) },
        { "T*<hkaiNavMeshClearanceCacheSeeding::CacheData>", typeof(hkaiNavMeshClearanceCacheSeeding.CacheData) },
        { "T*<hkaiNavMeshClearanceCache>", typeof(hkaiNavMeshClearanceCache) },
        { "T*<hkaiNavMeshClearanceCacheManager::CacheInfo>", typeof(hkaiNavMeshClearanceCacheManager.CacheInfo) },
        { "T*<hkaiNavMeshClearanceCacheManager::Registration>", typeof(hkaiNavMeshClearanceCacheManager.Registration) },
        { "T*<hkaiNavMeshClearanceCacheManager::LayerData>", typeof(hkaiNavMeshClearanceCacheManager.LayerData) },
        { "T*<hkaiNavMeshClearanceCache::McpDataInteger>", typeof(hkaiNavMeshClearanceCache.McpDataInteger) },
        { "T*<hkUint8>", typeof(byte?) },
        { "T*<hkaiDirectedGraphInstanceData::FreeBlockList>", typeof(hkaiDirectedGraphInstanceData.FreeBlockList) },
        { "T*<hkaiDirectedGraphExplicitCost>", typeof(hkaiDirectedGraphExplicitCost) },
        { "T*<hkaiAnnotatedStreamingSet>", typeof(hkaiAnnotatedStreamingSet) },
        { "T*<hkUint32>", typeof(uint?) },
        { "T*<hkaiDirectedGraphExplicitCost::Edge>", typeof(hkaiDirectedGraphExplicitCost.Edge) },
        { "T*<hkaiDirectedGraphExplicitCost::Node>", typeof(hkaiDirectedGraphExplicitCost.Node) },
        { "T*<hkaiConvexSilhouetteSet>", typeof(hkaiConvexSilhouetteSet) },
        { "T*<hkaiOverlapManager::PendingUpdate>", typeof(hkaiOverlapManager.PendingUpdate) },
        { "T*<hkArray<int, hkContainerHeapAllocator>>", typeof(List<int>) },
        { "T*<hkaiOverlapManager::Overlap>", typeof(hkaiOverlapManager.Overlap) },
        { "T*<hkaiOverlapManager::Generator>", typeof(hkaiOverlapManager.Generator) },
        { "T*<hkaiOverlapManager::Section>", typeof(hkaiOverlapManager.Section) },
        { "T*<hkaiAabbOverlapManager::Overlap>", typeof(hkaiAabbOverlapManager.Overlap) },
        { "T*<hkaiAabbOverlapManager::Node>", typeof(hkaiAabbOverlapManager.Node) },
        { "T*<hkArray<hkAabb, hkContainerHeapAllocator>>", typeof(List<hkAabb>) },
        { "T*<hkHashSet<hkaiIndex<hkInt32>>>", typeof(hkHashSet<int>) },
        { "T*<hkAabb>", typeof(hkAabb) },
        { "T*<hkaiIndex<hkInt32>>", typeof(int?) },
        { "T*<hkaiModifiedSections>", typeof(hkaiModifiedSections) },
        { "T*<hkRefPtr<hkaiNavMeshInstanceCutter>>", typeof(hkaiNavMeshInstanceCutter) },
        { "T*<hkRefPtr<hkaiVolume>>", typeof(hkaiVolume) },
        { "T*<hkaiNavVolume>", typeof(hkaiNavVolume) },
        { "T*<hkaiNavMesh>", typeof(hkaiNavMesh) },
        { "T*<hkcdStaticAabbTree>", typeof(hkcdStaticAabbTree) },
        { "T*<hkaiPath::PathPoint>", typeof(hkaiPath.PathPoint) },
        { "T*<hkaiAvoidanceProperties>", typeof(hkaiAvoidanceProperties) },
        { "T*<hkaiEdgeFollowingBehavior>", typeof(hkaiEdgeFollowingBehavior) },
        { "T*<hkaiAvoidancePairProperties::PairData>", typeof(hkaiAvoidancePairProperties.PairData) },
        { "T*<hkaiAvoidanceSolver::BoundaryObstacle>", typeof(hkaiAvoidanceSolver.BoundaryObstacle) },
        { "T*<hkaiAvoidanceSolver::SphereObstacle>", typeof(hkaiAvoidanceSolver.SphereObstacle) },
        { "T*<hkaiEdgePath::Edge>", typeof(hkaiEdgePath.Edge) },
        { "T*<hkaiStreamingCollection>", typeof(hkaiStreamingCollection) },
        { "T*<hkaiCornerPredictor::UserEdgeTraversal>", typeof(hkaiCornerPredictor.UserEdgeTraversal) },
        { "T*<hkaiSingleCharacterBehavior::RequestedGoalPoint>", typeof(hkaiSingleCharacterBehavior.RequestedGoalPoint) },
        { "T*<hkaiNavVolumePathRequestInfo>", typeof(hkaiNavVolumePathRequestInfo) },
        { "T*<hkaiNavMeshPathRequestInfo>", typeof(hkaiNavMeshPathRequestInfo) },
        { "T*<hkaiCharacter>", typeof(hkaiCharacter) },
        { "T*<hkaiPath>", typeof(hkaiPath) },
        { "T*<hkaiPathFollowingProperties>", typeof(hkaiPathFollowingProperties) },
        { "T*<hkaiEdgePath>", typeof(hkaiEdgePath) },
        { "T*<hkaiWorld>", typeof(hkaiWorld) },
        { "T*<hkaiGatePath::PathGate>", typeof(hkaiGatePath.PathGate) },
        { "T*<hkaiStreamingSet>", typeof(hkaiStreamingSet) },
        { "T*<hkaiReferencedArray<int>>", typeof(hkaiReferencedArray<int>) },
        { "T*<hkaiReferencedArray<hkVector4f>>", typeof(hkaiReferencedArray<Vector4>) },
        { "T*<hkaiReferencedArray<unsigned int>>", typeof(hkaiReferencedArray<uint>) },
        { "T*<hkaiReferencedArray<hkaiIndex<hkInt32>>>", typeof(hkaiReferencedArray<int>) },
        { "T*<hkaiReferencedArray<hkVector4>>", typeof(hkaiReferencedArray<Vector4>) },
        { "T*<hkaiReferencedArray<hkaiReferenceFrame>>", typeof(hkaiReferencedArray<hkaiReferenceFrame>) },
        { "T*<hkaiReferencedArray<hkQTransform>>", typeof(hkaiReferencedArray<hkQTransform>) },
        { "T*<hkaiReferencedArray<hkaiPackedKey_<hkaiIndex<hkInt32>, hkaiIndex<hkInt32>>>>", typeof(hkaiReferencedArray<uint>) },
        { "T*<hkaiAvoidancePairProperties>", typeof(hkaiAvoidancePairProperties) },
        { "T*<hkaiObstacleGenerator>", typeof(hkaiObstacleGenerator) },
        { "T*<hkaiSilhouetteGenerator>", typeof(hkaiSilhouetteGenerator) },
        { "T*<hkaiReferencedArray<hkaiUserEdgeUtils::UserEdgeSetup>>", typeof(hkaiReferencedArray<hkaiUserEdgeUtils.UserEdgeSetup>) },
        { "T*<hkaiReferencedArray<hkaiUserEdgeUtils::UserEdgePair>>", typeof(hkaiReferencedArray<hkaiUserEdgeUtils.UserEdgePair>) },
        { "T*<hkaiNavVolumeMediator>", typeof(hkaiNavVolumeMediator) },
        { "T*<hkaiNavVolumeInstance>", typeof(hkaiNavVolumeInstance) },
        { "T*<hkaiDirectedGraphInstance>", typeof(hkaiDirectedGraphInstance) },
        { "T*<hkaiReferencedArray<T*<hkaiStreamingSet>>>", typeof(hkaiReferencedArray<hkaiStreamingSet?>) },
        { "T*<hkaiNavMeshQueryMediator>", typeof(hkaiNavMeshQueryMediator) },
        { "T*<hkaiNavMeshInstance>", typeof(hkaiNavMeshInstance) },
        { "T*<hkaiAstarCostModifier>", typeof(hkaiAstarCostModifier) },
        { "T*<hkaiVolumeNavigator>", typeof(hkaiVolumeNavigator) },
        { "T*<hkaiNavigator>", typeof(hkaiNavigator) },
        { "T*<hkaiAstarEdgeFilter>", typeof(hkaiAstarEdgeFilter) },
        { "T*<hknpShape>", typeof(hknpShape) },
        { "T*<hkArray<hkVector4f, hkContainerHeapAllocator>>", typeof(List<Vector4>) },
        { "T*<int>", typeof(int?) },
        { "T*<hkVector4f>", typeof(Vector4) },
        { "T*<hkaiMaterialPainter>", typeof(hkaiMaterialPainter) },
        { "T*<hkaiCarver>", typeof(hkaiCarver) },
        { "T*<hkaiNavVolumeGenerationSettings::MaterialConstructionInfo>", typeof(hkaiNavVolumeGenerationSettings.MaterialConstructionInfo) },
        { "T*<hkaiNavMeshGenerationUtilsSettings::RegionPruningSettings::RegionConnection>", typeof(hkaiNavMeshGenerationUtilsSettings.RegionPruningSettings.RegionConnection) },
        { "T*<hkaiVolume>", typeof(hkaiVolume) },
        { "T*<hkaiNavMeshGenerationUtilsSettings::OverrideSettings>", typeof(hkaiNavMeshGenerationUtilsSettings.OverrideSettings) },
        { "T*<hkaiNavMeshGenerationUtilsSettings::MaterialConstructionPair>", typeof(hkaiNavMeshGenerationUtilsSettings.MaterialConstructionPair) },
        { "T*<hkRefPtr<hkaiMaterialPainter>>", typeof(hkaiMaterialPainter) },
        { "T*<hkRefPtr<hkaiCarver>>", typeof(hkaiCarver) },
        { "T*<hkArray<hkVector4, hkContainerHeapAllocator>>", typeof(List<Vector4>) },
        { "T*<hkInt32>", typeof(int?) },
        { "T*<hkRefPtr<hkGeometry>>", typeof(hkGeometry) },
        { "T*<hkGeometry>", typeof(hkGeometry) },
        { "T*<hkaiNavMeshGeneration::OverlappingMaterialCombiner>", typeof(hkaiNavMeshGeneration.OverlappingMaterialCombiner) },
        { "T*<hkaiNavMeshGeneration::GeometrySource>", typeof(hkaiNavMeshGeneration.GeometrySource) },
        { "T*<hkVector4>", typeof(Vector4) },
        { "T*<hkaiEdgeGeometry::Face>", typeof(hkaiEdgeGeometry.Face) },
        { "T*<hkaiEdgeGeometry::Edge>", typeof(hkaiEdgeGeometry.Edge) },
        { "T*<hkReflect::Detail::Opaque>", typeof(IHavokObject) },
        { "hkViewPtr<hkaiCollisionAvoidance::Character>", typeof(hkaiCollisionAvoidance.Character) },
        { "hkViewPtr<hkaiCollisionAvoidance::System>", typeof(hkaiCollisionAvoidance.System) },
        { "hkViewPtr<hknpCompoundShape>", typeof(hknpCompoundShape) },
        { "hkViewPtr<hknpCompressedMeshShape>", typeof(hknpCompressedMeshShape) },
        { "hkViewPtr<hkpConstraintData>", typeof(hkpConstraintData) },
        { "hkViewPtr<hkReferencedObject>", typeof(hkReferencedObject) },
        { "hkViewPtr<hkLocalFrame>", typeof(hkLocalFrame) },
        { "hkViewPtr<hkReflect::Detail::Opaque>", typeof(IHavokObject) },
        { "hkViewPtr<hkaiVolumeNavigator>", typeof(hkaiVolumeNavigator) },
        { "hkViewPtr<hkaiNavigator>", typeof(hkaiNavigator) },
        { "hkViewPtr<hkaiWorld>", typeof(hkaiWorld) },
        { "hkViewPtr<hkaiStreamingCollection>", typeof(hkaiStreamingCollection) },
        { "hkRefPtr<hkaiCollisionAvoidance::ObstacleGenerator>", typeof(hkaiCollisionAvoidance.ObstacleGenerator) },
        { "hkRefPtr<hkaiCollisionAvoidance::Character>", typeof(hkaiCollisionAvoidance.Character) },
        { "hkRefPtr<hkaiCollisionAvoidance::ReferencedScoreModifier>", typeof(hkaiCollisionAvoidance.ReferencedScoreModifier) },
        { "hkRefPtr<hkaiCollisionAvoidance::Filter>", typeof(hkaiCollisionAvoidance.Filter) },
        { "hkRefPtr<hkaiCollisionAvoidance::BoundaryGatherer>", typeof(hkaiCollisionAvoidance.BoundaryGatherer) },
        { "hkRefPtr<hkaiWorld>", typeof(hkaiWorld) },
        { "hkRefPtr<hknpPhysicsSystemData>", typeof(hknpPhysicsSystemData) },
        { "hkRefPtr<hknpConvexShape>", typeof(hknpConvexShape) },
        { "hkRefPtr<hknpMaterial>", typeof(hknpMaterial) },
        { "hkRefPtr<hknpMotionPropertiesData>", typeof(hknpMotionPropertiesData) },
        { "hkRefPtr<hknpBodyQuality>", typeof(hknpBodyQuality) },
        { "hkRefPtr<hknpSurfaceVelocity>", typeof(hknpSurfaceVelocity) },
        { "hkRefPtr<hknpBodyIntegrator>", typeof(hknpBodyIntegrator) },
        { "hkRefPtr<hknpShapeTagCodec>", typeof(hknpShapeTagCodec) },
        { "hkRefPtr<hknpCollisionFilter>", typeof(hknpCollisionFilter) },
        { "hkRefPtr<hknpBroadPhaseConfig>", typeof(hknpBroadPhaseConfig) },
        { "hkRefPtr<hknpBodyQualityLibrary>", typeof(hknpBodyQualityLibrary) },
        { "hkRefPtr<hknpMotionPropertiesLibrary>", typeof(hknpMotionPropertiesLibrary) },
        { "hkRefPtr<hknpMaterialLibrary>", typeof(hknpMaterialLibrary) },
        { "hkRefPtr<hknpRefMaterial>", typeof(hknpRefMaterial) },
        { "hkRefPtr<hknpRefDragProperties>", typeof(hknpRefDragProperties) },
        { "hkRefPtr<hknpRefMassDistribution>", typeof(hknpRefMassDistribution) },
        { "hkRefPtr<hkRefCountedProperties>", typeof(hkRefCountedProperties) },
        { "hkRefPtr<hknpConvexPolytopeShape::Connectivity>", typeof(hknpConvexPolytopeShape.Connectivity) },
        { "hkRefPtr<hkGeometry>", typeof(hkGeometry) },
        { "hkRefPtr<hknpHeightFieldBoundingVolume>", typeof(hknpHeightFieldBoundingVolume) },
        { "hkRefPtr<hknpHeightFieldGeometry>", typeof(hknpHeightFieldGeometry) },
        { "hkRefPtr<hkxSpline>", typeof(hkxSpline) },
        { "hkRefPtr<hkxSkinBinding>", typeof(hkxSkinBinding) },
        { "hkRefPtr<hkxTextureFile>", typeof(hkxTextureFile) },
        { "hkRefPtr<hkxTextureInplace>", typeof(hkxTextureInplace) },
        { "hkRefPtr<hkxLight>", typeof(hkxLight) },
        { "hkRefPtr<hkxCamera>", typeof(hkxCamera) },
        { "hkRefPtr<hkxNodeSelectionSet>", typeof(hkxNodeSelectionSet) },
        { "hkRefPtr<hkxVertexAnimation>", typeof(hkxVertexAnimation) },
        { "hkRefPtr<hkxIndexBuffer>", typeof(hkxIndexBuffer) },
        { "hkRefPtr<hkxMesh::UserChannelInfo>", typeof(hkxMesh.UserChannelInfo) },
        { "hkRefPtr<hkxMeshSection>", typeof(hkxMeshSection) },
        { "hkRefPtr<hkxMaterialShader>", typeof(hkxMaterialShader) },
        { "hkRefPtr<hkxVertexBuffer>", typeof(hkxVertexBuffer) },
        { "hkRefPtr<hkxMaterial>", typeof(hkxMaterial) },
        { "hkRefPtr<hkxNode>", typeof(hkxNode) },
        { "hkRefPtr<hkxEnum>", typeof(hkxEnum) },
        { "hkRefPtr<hkpConstraintData>", typeof(hkpConstraintData) },
        { "hkRefPtr<hkMeshTexture>", typeof(hkMeshTexture) },
        { "hkRefPtr<hkLocalFrame>", typeof(hkLocalFrame) },
        { "hkRefPtr<hkSkinnedMeshShape>", typeof(hkSkinnedMeshShape) },
        { "hkRefPtr<hkMeshShape>", typeof(hkMeshShape) },
        { "hkRefPtr<hkMemoryMeshVertexBuffer>", typeof(hkMemoryMeshVertexBuffer) },
        { "hkRefPtr<hkMeshMaterial>", typeof(hkMeshMaterial) },
        { "hkRefPtr<hkMeshVertexBuffer>", typeof(hkMeshVertexBuffer) },
        { "hkRefPtr<hkIndexedTransformSet>", typeof(hkIndexedTransformSet) },
        { "hkRefPtr<hkcdStaticAabbTree::Impl>", typeof(hkcdStaticAabbTree.Impl) },
        { "hkRefPtr<hkcdDynamicAabbTree::Impl>", typeof(hkcdDynamicAabbTree.Impl) },
        { "hkRefPtr<hkcdPlanarGeometryPlanesCollection>", typeof(hkcdPlanarGeometryPlanesCollection) },
        { "hkRefPtr<hkcdPlanarSolid::NodeStorage>", typeof(hkcdPlanarSolid.NodeStorage) },
        { "hkRefPtr<hkcdPlanarGeometryPolygonCollection>", typeof(hkcdPlanarGeometryPolygonCollection) },
        { "hkRefPtr<hkcdPlanarEntity::PlanesCollection>", typeof(hkcdPlanarEntity.PlanesCollection) },
        { "hkRefPtr<hkcdPlanarGeometry>", typeof(hkcdPlanarGeometry) },
        { "hkRefPtr<hkcdPlanarSolid>", typeof(hkcdPlanarSolid) },
        { "hkRefPtr<hkMemoryResourceContainer>", typeof(hkMemoryResourceContainer) },
        { "hkRefPtr<hkMemoryResourceHandle>", typeof(hkMemoryResourceHandle) },
        { "hkRefPtr<hkWeakPtrTest::Foo>", typeof(hkWeakPtrTest.Foo) },
        { "hkRefPtr<PropertyBagTest::GraphObject>", typeof(PropertyBagTest.GraphObject) },
        { "hkRefPtr<hkaMeshBinding>", typeof(hkaMeshBinding) },
        { "hkRefPtr<hkaBoneAttachment>", typeof(hkaBoneAttachment) },
        { "hkRefPtr<hkaAnimationBinding>", typeof(hkaAnimationBinding) },
        { "hkRefPtr<hkaFootstepAnalysisInfo>", typeof(hkaFootstepAnalysisInfo) },
        { "hkRefPtr<hkxMesh>", typeof(hkxMesh) },
        { "hkRefPtr<hkaAnimation>", typeof(hkaAnimation) },
        { "hkRefPtr<hkaAnimatedReferenceFrame>", typeof(hkaAnimatedReferenceFrame) },
        { "hkRefPtr<hclNamedTransformSetSetupObject>", typeof(hclNamedTransformSetSetupObject) },
        { "hkRefPtr<hclNamedSetupMesh>", typeof(hclNamedSetupMesh) },
        { "hkRefPtr<hclClothSetupObject>", typeof(hclClothSetupObject) },
        { "hkRefPtr<hclSimClothBufferSetupObject>", typeof(hclSimClothBufferSetupObject) },
        { "hkRefPtr<hclBufferSetupObject>", typeof(hclBufferSetupObject) },
        { "hkRefPtr<hclTransformSetSetupObject>", typeof(hclTransformSetSetupObject) },
        { "hkRefPtr<hclSimulationSetupMesh>", typeof(hclSimulationSetupMesh) },
        { "hkRefPtr<hclSimClothSetupObject>", typeof(hclSimClothSetupObject) },
        { "hkRefPtr<hclSetupMesh>", typeof(hclSetupMesh) },
        { "hkRefPtr<hclClothData>", typeof(hclClothData) },
        { "hkRefPtr<hclCollidable>", typeof(hclCollidable) },
        { "hkRefPtr<hkbAuxiliaryNodeInfo>", typeof(hkbAuxiliaryNodeInfo) },
        { "hkRefPtr<hkaSkeleton>", typeof(hkaSkeleton) },
        { "hkRefPtr<hkbBehaviorGraphInternalState>", typeof(hkbBehaviorGraphInternalState) },
        { "hkRefPtr<hkbCustomPropertySheet>", typeof(hkbCustomPropertySheet) },
        { "hkRefPtr<hkbNodeInternalStateInfo>", typeof(hkbNodeInternalStateInfo) },
        { "hkRefPtr<hkbStateMachine::TransitionInfoArray>", typeof(hkbStateMachine.TransitionInfoArray) },
        { "hkRefPtr<hkbStateMachine::EventPropertyArray>", typeof(hkbStateMachine.EventPropertyArray) },
        { "hkRefPtr<hkbCondition>", typeof(hkbCondition) },
        { "hkRefPtr<hkbTransitionEffect>", typeof(hkbTransitionEffect) },
        { "hkRefPtr<hkbSequenceStringData>", typeof(hkbSequenceStringData) },
        { "hkRefPtr<hkbProjectStringData>", typeof(hkbProjectStringData) },
        { "hkRefPtr<hkbVariableBindingSet>", typeof(hkbVariableBindingSet) },
        { "hkRefPtr<hkbBoneIndexArray>", typeof(hkbBoneIndexArray) },
        { "hkRefPtr<hkbEventRangeDataArray>", typeof(hkbEventRangeDataArray) },
        { "hkRefPtr<hkbHandle>", typeof(hkbHandle) },
        { "hkRefPtr<hkbExpressionDataArray>", typeof(hkbExpressionDataArray) },
        { "hkRefPtr<hkbAttachmentSetup>", typeof(hkbAttachmentSetup) },
        { "hkRefPtr<hkbModifier>", typeof(hkbModifier) },
        { "hkRefPtr<hkbCustomIdSelector>", typeof(hkbCustomIdSelector) },
        { "hkRefPtr<hkbClipTriggerArray>", typeof(hkbClipTriggerArray) },
        { "hkRefPtr<hkbBoneWeightArray>", typeof(hkbBoneWeightArray) },
        { "hkRefPtr<hkbCharacterData>", typeof(hkbCharacterData) },
        { "hkRefPtr<hkaSkeletonMapper>", typeof(hkaSkeletonMapper) },
        { "hkRefPtr<hkbCharacterStringData>", typeof(hkbCharacterStringData) },
        { "hkRefPtr<hkbProjectData>", typeof(hkbProjectData) },
        { "hkRefPtr<hkbBehaviorGraph>", typeof(hkbBehaviorGraph) },
        { "hkRefPtr<hkbCharacterSetup>", typeof(hkbCharacterSetup) },
        { "hkRefPtr<hkbVariableValueSet>", typeof(hkbVariableValueSet) },
        { "hkRefPtr<hkReferencedObject>", typeof(hkReferencedObject) },
        { "hkRefPtr<hkbReferencedGeneratorSyncInfo>", typeof(hkbReferencedGeneratorSyncInfo) },
        { "hkRefPtr<hkbBehaviorGraphStringData>", typeof(hkbBehaviorGraphStringData) },
        { "hkRefPtr<hkbBehaviorGraphData>", typeof(hkbBehaviorGraphData) },
        { "hkRefPtr<hkbGenerator>", typeof(hkbGenerator) },
        { "hkRefPtr<hkaiVolumeNavigator>", typeof(hkaiVolumeNavigator) },
        { "hkRefPtr<hkaiNavigator>", typeof(hkaiNavigator) },
        { "hkRefPtr<hkaiStreamingSetInstance>", typeof(hkaiStreamingSetInstance) },
        { "hkRefPtr<hkaiNavVolumeInstanceData>", typeof(hkaiNavVolumeInstanceData) },
        { "hkRefPtr<hkaiNavMeshInstanceData>", typeof(hkaiNavMeshInstanceData) },
        { "hkRefPtr<hkcdDynamicAabbTree>", typeof(hkcdDynamicAabbTree) },
        { "hkRefPtr<hkaiDirectedGraphInstanceData>", typeof(hkaiDirectedGraphInstanceData) },
        { "hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>", typeof(hkaiDynamicUserEdgeSetInfo.ExternalEdges) },
        { "hkRefPtr<hkaiObstacleGenerator>", typeof(hkaiObstacleGenerator) },
        { "hkRefPtr<hkaiPathRequestQueue>", typeof(hkaiPathRequestQueue) },
        { "hkRefPtr<hkaiNavVolumePathRequest>", typeof(hkaiNavVolumePathRequest) },
        { "hkRefPtr<hkaiNavMeshPathRequest>", typeof(hkaiNavMeshPathRequest) },
        { "hkRefPtr<hkaiNavMeshInstanceCutter>", typeof(hkaiNavMeshInstanceCutter) },
        { "hkRefPtr<hkaiVolumeNavigatorManager>", typeof(hkaiVolumeNavigatorManager) },
        { "hkRefPtr<hkaiNavigatorManager>", typeof(hkaiNavigatorManager) },
        { "hkRefPtr<hkaiPathRequestManager>", typeof(hkaiPathRequestManager) },
        { "hkRefPtr<hkaiAvoidancePairProperties>", typeof(hkaiAvoidancePairProperties) },
        { "hkRefPtr<hkaiOverlapManager>", typeof(hkaiOverlapManager) },
        { "hkRefPtr<hkaiNavMeshClearanceCacheManager>", typeof(hkaiNavMeshClearanceCacheManager) },
        { "hkRefPtr<hkaiNavMeshCutter>", typeof(hkaiNavMeshCutter) },
        { "hkRefPtr<hkaiVolumePathfindingUtil::FindPathOutput>", typeof(hkaiVolumePathfindingUtil.FindPathOutput) },
        { "hkRefPtr<hkaiVolumePathfindingUtil::FindPathInput>", typeof(hkaiVolumePathfindingUtil.FindPathInput) },
        { "hkRefPtr<hkaiPathfindingUtil::FindPathOutput>", typeof(hkaiPathfindingUtil.FindPathOutput) },
        { "hkRefPtr<hkaiPathfindingUtil::FindPathInput>", typeof(hkaiPathfindingUtil.FindPathInput) },
        { "hkRefPtr<hkaiVolumeNavigator::PathRequestInput>", typeof(hkaiVolumeNavigator.PathRequestInput) },
        { "hkRefPtr<hkaiVolumeNavigator::NavigatorSettings>", typeof(hkaiVolumeNavigator.NavigatorSettings) },
        { "hkRefPtr<hkaiVolumeNavigatorStalenessChecker>", typeof(hkaiVolumeNavigatorStalenessChecker) },
        { "hkRefPtr<hkaiGatePath>", typeof(hkaiGatePath) },
        { "hkRefPtr<hkaiVolumeNavigator::PathRequest>", typeof(hkaiVolumeNavigator.PathRequest) },
        { "hkRefPtr<hkaiNavigator::PathRequestInput>", typeof(hkaiNavigator.PathRequestInput) },
        { "hkRefPtr<hkaiNavigator::NavigatorSettings>", typeof(hkaiNavigator.NavigatorSettings) },
        { "hkRefPtr<hkaiNavigatorStalenessChecker>", typeof(hkaiNavigatorStalenessChecker) },
        { "hkRefPtr<hkaiNavigator::PathRequest>", typeof(hkaiNavigator.PathRequest) },
        { "hkRefPtr<hkaiNavMeshClearanceCacheSeeding::CacheDataSet>", typeof(hkaiNavMeshClearanceCacheSeeding.CacheDataSet) },
        { "hkRefPtr<hkaiStreamingSet>", typeof(hkaiStreamingSet) },
        { "hkRefPtr<hkaiNavVolumeMediator>", typeof(hkaiNavVolumeMediator) },
        { "hkRefPtr<hkaiDirectedGraphInstance>", typeof(hkaiDirectedGraphInstance) },
        { "hkRefPtr<hkaiNavVolumeInstance>", typeof(hkaiNavVolumeInstance) },
        { "hkRefPtr<hkaiNavMeshInstance>", typeof(hkaiNavMeshInstance) },
        { "hkRefPtr<hkaiDynamicNavVolumeMediator>", typeof(hkaiDynamicNavVolumeMediator) },
        { "hkRefPtr<hkaiDynamicNavMeshQueryMediator>", typeof(hkaiDynamicNavMeshQueryMediator) },
        { "hkRefPtr<hkaiNavMeshClearanceCache>", typeof(hkaiNavMeshClearanceCache) },
        { "hkRefPtr<hkaiDirectedGraphExplicitCost>", typeof(hkaiDirectedGraphExplicitCost) },
        { "hkRefPtr<hkaiConvexSilhouetteSet>", typeof(hkaiConvexSilhouetteSet) },
        { "hkRefPtr<hkaiSilhouetteGenerator>", typeof(hkaiSilhouetteGenerator) },
        { "hkRefPtr<hkaiNavMeshQueryMediator>", typeof(hkaiNavMeshQueryMediator) },
        { "hkRefPtr<hkaiModifiedSections>", typeof(hkaiModifiedSections) },
        { "hkRefPtr<hkaiNavVolume>", typeof(hkaiNavVolume) },
        { "hkRefPtr<hkaiNavMesh>", typeof(hkaiNavMesh) },
        { "hkRefPtr<hkcdStaticAabbTree>", typeof(hkcdStaticAabbTree) },
        { "hkRefPtr<hkaiAvoidanceProperties>", typeof(hkaiAvoidanceProperties) },
        { "hkRefPtr<hkaiAstarEdgeFilter>", typeof(hkaiAstarEdgeFilter) },
        { "hkRefPtr<hkaiAstarCostModifier>", typeof(hkaiAstarCostModifier) },
        { "hkRefPtr<hkaiEdgeFollowingBehavior>", typeof(hkaiEdgeFollowingBehavior) },
        { "hkRefPtr<hkaiStreamingCollection>", typeof(hkaiStreamingCollection) },
        { "hkRefPtr<hkaiNavVolumePathRequestInfo>", typeof(hkaiNavVolumePathRequestInfo) },
        { "hkRefPtr<hkaiNavMeshPathRequestInfo>", typeof(hkaiNavMeshPathRequestInfo) },
        { "hkRefPtr<hkaiCharacter>", typeof(hkaiCharacter) },
        { "hkRefPtr<hkaiPath>", typeof(hkaiPath) },
        { "hkRefPtr<hkaiPathFollowingProperties>", typeof(hkaiPathFollowingProperties) },
        { "hkRefPtr<hkaiEdgePath>", typeof(hkaiEdgePath) },
        { "hkRefPtr<hkReflect::Detail::Opaque>", typeof(IHavokObject) },
        { "hkRefPtr<hknpShape>", typeof(hknpShape) },
        { "hkRefPtr<hkaiMaterialPainter>", typeof(hkaiMaterialPainter) },
        { "hkRefPtr<hkaiCarver>", typeof(hkaiCarver) },
        { "hkRefPtr<hkaiVolume>", typeof(hkaiVolume) },
        { "hkRefPtr<hkaiNavMeshGeneration::OverlappingMaterialCombiner>", typeof(hkaiNavMeshGeneration.OverlappingMaterialCombiner) },
        { "hkRefPtr<hkaiNavMeshGeneration::GeometrySource>", typeof(hkaiNavMeshGeneration.GeometrySource) },
        { "hkScopedPtr<hknpParticleShapeProperties>", typeof(hknpParticleShapeProperties) },
        { "hkScopedPtr<hctAttributeDescription::Enum>", typeof(hctAttributeDescription.Enum) },
        { "T&<hkQTransformf>", typeof(hkQTransformf) },
        { "T&<hkTransformf>", typeof(Matrix4x4) },
        { "T&<hkVector4f>", typeof(Vector4) },
        { "T&<hkQuaternionf>", typeof(Quaternion) },
        { "T&<hkStringBuf>", typeof(string) },
        { "hkReflect::QualifiedType<hkReflect::ArrayType>", typeof(IHavokObject) },
        { "hkReflect::QualifiedType<hkReflect::RecordType>", typeof(IHavokObject) },
        { "hkReflect::QualifiedType<hkReflect::OpaqueType>", typeof(IHavokObject) },
        { "hkReflect::QualifiedType<hkReflect::VoidType>", typeof(IHavokObject) },
        { "hkReflect::QualifiedType<hkReflect::BoolType>", typeof(IHavokObject) },
        { "hkReflect::QualifiedType<hkReflect::StringType>", typeof(IHavokObject) },
        { "hkReflect::QualifiedType<hkReflect::FloatType>", typeof(IHavokObject) },
        { "hkReflect::QualifiedType<hkReflect::IntType>", typeof(IHavokObject) },
        { "hkReflect::QualifiedType<hkReflect::PointerType>", typeof(IHavokObject) },
        { "hkReflect::QualifiedType<hkReflect::Type>", typeof(IHavokObject) },
        { "hkWeakPtr<hkWeakPtrTest::Foo>", typeof(hkWeakPtrTest.Foo) },
        { "hkRefVariant", typeof(hkReferencedObject) },
        { "hkSimpleLocalFrame::ChildPointer", typeof(hkLocalFrame) },
        { "hkArray<hkaiMinArrayEntry<hkViewPtr<hkaiCollisionAvoidance::Character>>, hkContainerHeapAllocator>", typeof(List<hkaiMinArrayEntry<hkaiCollisionAvoidance.Character?>>) },
        { "hkArray<hkRefPtr<hkaiCollisionAvoidance::ObstacleGenerator>, hkContainerHeapAllocator>", typeof(List<hkaiCollisionAvoidance.ObstacleGenerator?>) },
        { "hkArray<hkViewPtr<hkaiCollisionAvoidance::Character>, hkContainerHeapAllocator>", typeof(List<hkaiCollisionAvoidance.Character?>) },
        { "hkArray<hkRefPtr<hkaiCollisionAvoidance::Character>, hkContainerHeapAllocator>", typeof(List<hkaiCollisionAvoidance.Character?>) },
        { "hkArray<hkaiCollisionAvoidance::SphereObstacle, hkContainerHeapAllocator>", typeof(List<hkaiCollisionAvoidance.SphereObstacle>) },
        { "hkArray<hkaiCollisionAvoidance::LineSegmentObstacle, hkContainerHeapAllocator>", typeof(List<hkaiCollisionAvoidance.LineSegmentObstacle>) },
        { "hkArray<hkRefPtr<hkaiCollisionAvoidance::ReferencedScoreModifier>, hkContainerHeapAllocator>", typeof(List<hkaiCollisionAvoidance.ReferencedScoreModifier?>) },
        { "hkArray<fsnpCustomMeshParameter::PrimitiveData, hkContainerHeapAllocator>", typeof(List<fsnpCustomMeshParameter.PrimitiveData>) },
        { "hkArray<fsnpCustomMeshParameter::TriangleData, hkContainerHeapAllocator>", typeof(List<fsnpCustomMeshParameter.TriangleData>) },
        { "hkArray<CustomLookAtTwistModifier::TwistParam, hkContainerHeapAllocator>", typeof(List<CustomLookAtTwistModifier.TwistParam>) },
        { "hkArray<hkFreeListArrayElement<hknpMotionProperties>, hkContainerHeapAllocator>", typeof(List<hkFreeListArrayElementHknpMotionProperties>) },
        { "hkArray<hkFreeListArrayElement<hknpMaterial>, hkContainerHeapAllocator>", typeof(List<hkFreeListArrayElementHknpMaterial>) },
        { "hkArray<hkFreeListArrayElement<hknpShapeInstance>, hkContainerHeapAllocator>", typeof(List<hkFreeListArrayElementHknpShapeInstance>) },
        { "hkArray<hkHandle<short, 32767>, hkContainerHeapAllocator>", typeof(List<hkHandle<short>>) },
        { "hkArray<hknpParticleFaceVerticesWithEffMass, hkContainerHeapAllocator>", typeof(List<hknpParticleFaceVerticesWithEffMass>) },
        { "hkArray<hknpParticle4Faces, hkContainerHeapAllocator>", typeof(List<hknpParticle4Faces>) },
        { "hkArray<hkScopedPtr<hknpParticleShapeProperties>, hkContainerHeapAllocator>", typeof(List<hknpParticleShapeProperties?>) },
        { "hkArray<hknpStorageParticleSystem, hkContainerHeapAllocator>", typeof(List<hknpStorageParticleSystem>) },
        { "hkArray<hknpWorldSnapshot::ConstraintGroupInfo, hkContainerHeapAllocator>", typeof(List<hknpWorldSnapshot.ConstraintGroupInfo>) },
        { "hkArray<hknpMotion, hkContainerHeapAllocator>", typeof(List<hknpMotion>) },
        { "hkArray<hknpBody, hkContainerHeapAllocator>", typeof(List<hknpBody>) },
        { "hkArray<hkRefPtr<hknpConvexShape>, hkContainerHeapAllocator>", typeof(List<hknpConvexShape?>) },
        { "hkArray<hknpVehicleInstance::WheelInfo, hkContainerHeapAllocator>", typeof(List<hknpVehicleInstance.WheelInfo>) },
        { "hkArray<hknpVehicleData::WheelComponentParams, hkContainerHeapAllocator>", typeof(List<hknpVehicleData.WheelComponentParams>) },
        { "hkArray<hknpVehicleLinearCastWheelCollide::WheelState, hkContainerHeapAllocator>", typeof(List<hknpVehicleLinearCastWheelCollide.WheelState>) },
        { "hkArray<T*<hknpTyremarksWheel>, hkContainerHeapAllocator>", typeof(List<hknpTyremarksWheel?>) },
        { "hkArray<hknpTyremarkPoint, hkContainerHeapAllocator>", typeof(List<hknpTyremarkPoint>) },
        { "hkArray<hknpVehicleSuspension::SuspensionWheelParameters, hkContainerHeapAllocator>", typeof(List<hknpVehicleSuspension.SuspensionWheelParameters>) },
        { "hkArray<hknpVehicleDefaultSuspension::WheelSpringSuspensionParameters, hkContainerHeapAllocator>", typeof(List<hknpVehicleDefaultSuspension.WheelSpringSuspensionParameters>) },
        { "hkArray<hknp1dAngularFollowCamCinfo::CameraSet, hkContainerHeapAllocator>", typeof(List<hknp1dAngularFollowCamCinfo.CameraSet>) },
        { "hkArray<hknpVehicleDefaultBrake::WheelBrakingProperties, hkContainerHeapAllocator>", typeof(List<hknpVehicleDefaultBrake.WheelBrakingProperties>) },
        { "hkArray<hknpConstraintCinfo, hkContainerHeapAllocator>", typeof(List<hknpConstraintCinfo>) },
        { "hkArray<hknpPhysicsSystemData::bodyCinfoWithAttachment, hkContainerHeapAllocator>", typeof(List<hknpPhysicsSystemData.bodyCinfoWithAttachment>) },
        { "hkArray<hknpMotionProperties, hkContainerHeapAllocator>", typeof(List<hknpMotionProperties>) },
        { "hkArray<hknpMaterial, hkContainerHeapAllocator>", typeof(List<hknpMaterial>) },
        { "hkArray<hkRefPtr<hknpPhysicsSystemData>, hkContainerHeapAllocator>", typeof(List<hknpPhysicsSystemData?>) },
        { "hkArray<hknpParticleCacheMoveInfo, hkContainerHeapAllocator>", typeof(List<hknpParticleCacheMoveInfo>) },
        { "hkArray<hknpMaterialDescriptor, hkContainerHeapAllocator>", typeof(List<hknpMaterialDescriptor>) },
        { "hkArray<hknpShapeInstanceId, hkContainerHeapAllocator>", typeof(List<hknpShapeInstanceId>) },
        { "hkArray<hknpConvexPolytopeShape::Connectivity::Edge, hkContainerHeapAllocator>", typeof(List<hknpConvexPolytopeShape.Connectivity.Edge>) },
        { "hkArray<hknpExtendedExternMeshShapeGeometry::Quad, hkContainerHeapAllocator>", typeof(List<hknpExtendedExternMeshShapeGeometry.Quad>) },
        { "hkArray<hknpExtendedExternMeshShapeGeometry::Triangle, hkContainerHeapAllocator>", typeof(List<hknpExtendedExternMeshShapeGeometry.Triangle>) },
        { "hkArray<hknpShapeInstance, hkContainerHeapAllocator>", typeof(List<hknpShapeInstance>) },
        { "hkArray<hknpMinMaxQuadTree::MinMaxLevel, hkContainerHeapAllocator>", typeof(List<hknpMinMaxQuadTree.MinMaxLevel>) },
        { "hkArray<T*<hknpShapeKeyMask>, hkContainerHeapAllocator>", typeof(List<hknpShapeKeyMask?>) },
        { "hkArray<hknpCompoundShape::VelocityInfo, hkContainerHeapAllocator>", typeof(List<hknpCompoundShape.VelocityInfo>) },
        { "hkArray<hkxSpline::ControlPoint, hkContainerHeapAllocator>", typeof(List<hkxSpline.ControlPoint>) },
        { "hkArray<hkRefPtr<hkxSpline>, hkContainerHeapAllocator>", typeof(List<hkxSpline?>) },
        { "hkArray<hkRefPtr<hkxSkinBinding>, hkContainerHeapAllocator>", typeof(List<hkxSkinBinding?>) },
        { "hkArray<hkRefPtr<hkxTextureFile>, hkContainerHeapAllocator>", typeof(List<hkxTextureFile?>) },
        { "hkArray<hkRefPtr<hkxTextureInplace>, hkContainerHeapAllocator>", typeof(List<hkxTextureInplace?>) },
        { "hkArray<hkRefPtr<hkxMesh>, hkContainerHeapAllocator>", typeof(List<hkxMesh?>) },
        { "hkArray<hkRefPtr<hkxLight>, hkContainerHeapAllocator>", typeof(List<hkxLight?>) },
        { "hkArray<hkRefPtr<hkxCamera>, hkContainerHeapAllocator>", typeof(List<hkxCamera?>) },
        { "hkArray<hkRefPtr<hkxNodeSelectionSet>, hkContainerHeapAllocator>", typeof(List<hkxNodeSelectionSet?>) },
        { "hkArray<hkxVertexDescription::ElementDecl, hkContainerHeapAllocator>", typeof(List<hkxVertexDescription.ElementDecl>) },
        { "hkArray<hkxVertexAnimation::UsageMap, hkContainerHeapAllocator>", typeof(List<hkxVertexAnimation.UsageMap>) },
        { "hkArray<hkRefPtr<hkxVertexAnimation>, hkContainerHeapAllocator>", typeof(List<hkxVertexAnimation?>) },
        { "hkArray<hkRefPtr<hkxIndexBuffer>, hkContainerHeapAllocator>", typeof(List<hkxIndexBuffer?>) },
        { "hkArray<hkRefPtr<hkxMesh::UserChannelInfo>, hkContainerHeapAllocator>", typeof(List<hkxMesh.UserChannelInfo?>) },
        { "hkArray<hkRefPtr<hkxMeshSection>, hkContainerHeapAllocator>", typeof(List<hkxMeshSection?>) },
        { "hkArray<hkxBlendShapeCollectionChannel::Channel, hkContainerHeapAllocator>", typeof(List<hkxBlendShapeCollectionChannel.Channel>) },
        { "hkArray<hkxBlendShapeCollectionChannel::FloatCurve, hkContainerHeapAllocator>", typeof(List<hkxBlendShapeCollectionChannel.FloatCurve>) },
        { "hkArray<hkxBlendShapeCollectionChannel::KeyFrame, hkContainerHeapAllocator>", typeof(List<hkxBlendShapeCollectionChannel.KeyFrame>) },
        { "hkArray<hkxBlendShapeCollectionChannel::FloatCurveKey, hkContainerHeapAllocator>", typeof(List<hkxBlendShapeCollectionChannel.FloatCurveKey>) },
        { "hkArray<hkxBlendShapeCollectionChannel::BlendShape, hkContainerHeapAllocator>", typeof(List<hkxBlendShapeCollectionChannel.BlendShape>) },
        { "hkArray<hkRefPtr<hkxMaterialShader>, hkContainerHeapAllocator>", typeof(List<hkxMaterialShader?>) },
        { "hkArray<hkxMaterial::Property, hkContainerHeapAllocator>", typeof(List<hkxMaterial.Property>) },
        { "hkArray<hkRefPtr<hkxMaterial>, hkContainerHeapAllocator>", typeof(List<hkxMaterial?>) },
        { "hkArray<hkxMaterial::TextureStage, hkContainerHeapAllocator>", typeof(List<hkxMaterial.TextureStage>) },
        { "hkArray<hkxNode::AnnotationData, hkContainerHeapAllocator>", typeof(List<hkxNode.AnnotationData>) },
        { "hkArray<hkRefPtr<hkxNode>, hkContainerHeapAllocator>", typeof(List<hkxNode?>) },
        { "hkArray<hkxEnvironment::Variable, hkContainerHeapAllocator>", typeof(List<hkxEnvironment.Variable>) },
        { "hkArray<hkxEnum::Item, hkContainerHeapAllocator>", typeof(List<hkxEnum.Item>) },
        { "hkArray<hkxAttributeGroup, hkContainerHeapAllocator>", typeof(List<hkxAttributeGroup>) },
        { "hkArray<hkxAttribute, hkContainerHeapAllocator>", typeof(List<hkxAttribute>) },
        { "hkArray<hkaSkeleton::Partition, hkContainerHeapAllocator>", typeof(List<hkaSkeleton.Partition>) },
        { "hkArray<hkaSkeleton::LocalFrameOnBone, hkContainerHeapAllocator>", typeof(List<hkaSkeleton.LocalFrameOnBone>) },
        { "hkArray<hkaBone, hkContainerHeapAllocator>", typeof(List<hkaBone>) },
        { "hkArray<hkSkinnedMeshShape::Part, hkContainerHeapAllocator>", typeof(List<hkSkinnedMeshShape.Part>) },
        { "hkArray<hkSkinnedMeshShape::BoneSection, hkContainerHeapAllocator>", typeof(List<hkSkinnedMeshShape.BoneSection>) },
        { "hkArray<hkSkinnedMeshShape::BoneSet, hkContainerHeapAllocator>", typeof(List<hkSkinnedMeshShape.BoneSet>) },
        { "hkArray<hkMultipleVertexBuffer::VertexBufferInfo, hkContainerHeapAllocator>", typeof(List<hkMultipleVertexBuffer.VertexBufferInfo>) },
        { "hkArray<hkMultipleVertexBuffer::ElementInfo, hkContainerHeapAllocator>", typeof(List<hkMultipleVertexBuffer.ElementInfo>) },
        { "hkArray<hkMultipleVertexBuffer::LockedElement, hkContainerHeapAllocator>", typeof(List<hkMultipleVertexBuffer.LockedElement>) },
        { "hkArray<hkMemoryMeshShape::Section, hkContainerHeapAllocator>", typeof(List<hkMemoryMeshShape.Section>) },
        { "hkArray<hkRefPtr<hkMeshTexture>, hkContainerHeapAllocator>", typeof(List<hkMeshTexture?>) },
        { "hkArray<T*<hkMeshVertexBuffer>, hkContainerHeapAllocator>", typeof(List<hkMeshVertexBuffer?>) },
        { "hkArray<hkMeshBoneIndexMapping, hkContainerHeapAllocator>", typeof(List<hkMeshBoneIndexMapping>) },
        { "hkArray<T*<hkMeshBody>, hkContainerHeapAllocator>", typeof(List<hkMeshBody?>) },
        { "hkArray<hkDefaultCompoundMeshShape::MeshSection, hkContainerHeapAllocator>", typeof(List<hkDefaultCompoundMeshShape.MeshSection>) },
        { "hkArray<T*<hkMeshShape>, hkContainerHeapAllocator>", typeof(List<hkMeshShape?>) },
        { "hkArray<hkcdDynamicTree::CodecRawUint, hkContainerHeapAllocator>", typeof(List<hkcdDynamicTree.CodecRawUint>) },
        { "hkArray<hkcdDynamicTree::CodecRawUlong, hkContainerHeapAllocator>", typeof(List<hkcdDynamicTree.CodecRawUlong>) },
        { "hkArray<hkcdDefaultStaticMeshTree::PrimitiveDataRun, hkContainerHeapAllocator>", typeof(List<hkcdDefaultStaticMeshTree.PrimitiveDataRun>) },
        { "hkArray<hkcdDynamicTree::CodecInt16, hkContainerHeapAllocator>", typeof(List<hkcdDynamicTree.CodecInt16>) },
        { "hkArray<hkcdDynamicTree::Codec32, hkContainerHeapAllocator>", typeof(List<hkcdDynamicTree.Codec32>) },
        { "hkArray<hkcdDynamicTree::CodecRaw<unsigned int>, hkContainerHeapAllocator>", typeof(List<hkcdDynamicTree.CodecRaw<uint>>) },
        { "hkArray<hkcdDynamicTree::CodecRaw<unsigned long long>, hkContainerHeapAllocator>", typeof(List<hkcdDynamicTree.CodecRaw<ulong>>) },
        { "hkArray<hkcdCompressedAabbCodecs::UncompressedAabbCodec, hkContainerHeapAllocator>", typeof(List<hkcdCompressedAabbCodecs.UncompressedAabbCodec>) },
        { "hkArray<hkcdCompressedAabbCodecs::Aabb6BytesCodec, hkContainerHeapAllocator>", typeof(List<hkcdCompressedAabbCodecs.Aabb6BytesCodec>) },
        { "hkArray<hkcdCompressedAabbCodecs::Aabb5BytesCodec, hkContainerHeapAllocator>", typeof(List<hkcdCompressedAabbCodecs.Aabb5BytesCodec>) },
        { "hkArray<hkcdCompressedAabbCodecs::Aabb4BytesCodec, hkContainerHeapAllocator>", typeof(List<hkcdCompressedAabbCodecs.Aabb4BytesCodec>) },
        { "hkArray<hkTuple<unsigned int, unsigned int, void, void, void, void, void, void>, hkContainerHeapAllocator>", typeof(List<hkTuple2<uint, uint>>) },
        { "hkArray<hkcdStaticMeshTree::Primitive, hkContainerHeapAllocator>", typeof(List<hkcdStaticMeshTree.Primitive>) },
        { "hkArray<hkcdStaticMeshTree::Section, hkContainerHeapAllocator>", typeof(List<hkcdStaticMeshTree.Section>) },
        { "hkArray<hkHandle<hkUint32, -1>, hkContainerHeapAllocator>", typeof(List<hkHandle<uint>>) },
        { "hkArray<hkcdStaticMeshTree::Connectivity::SectionHeader, hkContainerHeapAllocator>", typeof(List<hkcdStaticMeshTree.Connectivity.SectionHeader>) },
        { "hkArray<hkTuple<hkUint32, hkUint32, void, void, void, void, void, void>, hkContainerHeapAllocator>", typeof(List<hkTuple2<uint, uint>>) },
        { "hkArray<hkcdSimdTree::Dynamic::NodeData, hkContainerHeapAllocator>", typeof(List<hkcdSimdTree.Dynamic.NodeData>) },
        { "hkArray<hkcdSimdTree::Node, hkContainerHeapAllocator>", typeof(List<hkcdSimdTree.Node>) },
        { "hkArray<hkcdPlanarSolid::Node, hkContainerHeapAllocator>", typeof(List<hkcdPlanarSolid.Node>) },
        { "hkArray<hkcdPlanarGeometryPrimitives::Plane, hkContainerHeapAllocator>", typeof(List<hkcdPlanarGeometryPrimitives.Plane>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkPropertyId, hkReflect::Any>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<hkPropertyId, object>>) },
        { "hkArray<hkIntRealPair, hkContainerHeapAllocator>", typeof(List<hkIntRealPair>) },
        { "hkArray<T*<hkLocalFrame>, hkContainerHeapAllocator>", typeof(List<hkLocalFrame?>) },
        { "hkArray<T*<hkReflect::Type>, hkContainerHeapAllocator>", typeof(List<IHavokObject?>) },
        { "hkArray<hkRefCountedProperties::Entry, hkContainerHeapAllocator>", typeof(List<hkRefCountedProperties.Entry>) },
        { "hkArray<hkGeometry::Triangle, hkContainerHeapAllocator>", typeof(List<hkGeometry.Triangle>) },
        { "hkArray<hkSimpleLocalFrame::ChildPointer, hkContainerHeapAllocator>", typeof(List<hkLocalFrame?>) },
        { "hkArray<hkAsyncThreadPool::ThreadPriority, hkContainerHeapAllocator>", typeof(List<hkAsyncThreadPool.ThreadPriority>) },
        { "hkArray<hkRootLevelContainer::NamedVariant, hkContainerHeapAllocator>", typeof(List<hkRootLevelContainer.NamedVariant>) },
        { "hkArray<hkRefPtr<hkMemoryResourceContainer>, hkContainerHeapAllocator>", typeof(List<hkMemoryResourceContainer?>) },
        { "hkArray<hkRefPtr<hkMemoryResourceHandle>, hkContainerHeapAllocator>", typeof(List<hkMemoryResourceHandle?>) },
        { "hkArray<hkMemoryResourceHandle::ExternalLink, hkContainerHeapAllocator>", typeof(List<hkMemoryResourceHandle.ExternalLink>) },
        { "hkArray<hctFilterConfigurationSet::FilterStage, hkContainerHeapAllocator>", typeof(List<hctFilterConfigurationSet.FilterStage>) },
        { "hkArray<hctFilterConfigurationSet::Configuration, hkContainerHeapAllocator>", typeof(List<hctFilterConfigurationSet.Configuration>) },
        { "hkArray<T*<hctClothSetupObjectData>, hkContainerHeapAllocator>", typeof(List<hctClothSetupObjectData?>) },
        { "hkArray<T*<hctClothSetupClothData20141Options>, hkContainerHeapAllocator>", typeof(List<hctClothSetupClothData20141Options?>) },
        { "hkArray<hctAttributeGroupDescription, hkContainerHeapAllocator>", typeof(List<hctAttributeGroupDescription>) },
        { "hkArray<hctAttributeDescription, hkContainerHeapAllocator>", typeof(List<hctAttributeDescription>) },
        { "hkArray<hctAttributeDescription::Enum::Item, hkContainerHeapAllocator>", typeof(List<hctAttributeDescription.Enum.Item>) },
        { "hkArray<hkMonitorStreamColorTable::ColorPair, hkContainerHeapAllocator>", typeof(List<hkMonitorStreamColorTable.ColorPair>) },
        { "hkArray<hkMonitorStreamTypeMap::TypeMap, hkContainerHeapAllocator>", typeof(List<hkMonitorStreamTypeMap.TypeMap>) },
        { "hkArray<hkMonitorStreamStringMap::StringMap, hkContainerHeapAllocator>", typeof(List<hkMonitorStreamStringMap.StringMap>) },
        { "hkArray<hkGpuTraceResult, hkContainerHeapAllocator>", typeof(List<hkGpuTraceResult>) },
        { "hkArray<hkTransformf, hkContainerHeapAllocator>", typeof(List<Matrix4x4>) },
        { "hkArray<hkRefPtr<hkaMeshBinding>, hkContainerHeapAllocator>", typeof(List<hkaMeshBinding?>) },
        { "hkArray<hkRefPtr<hkaBoneAttachment>, hkContainerHeapAllocator>", typeof(List<hkaBoneAttachment?>) },
        { "hkArray<hkRefPtr<hkaAnimationBinding>, hkContainerHeapAllocator>", typeof(List<hkaAnimationBinding?>) },
        { "hkArray<hkRefPtr<hkaAnimation>, hkContainerHeapAllocator>", typeof(List<hkaAnimation?>) },
        { "hkArray<hkRefPtr<hkaSkeleton>, hkContainerHeapAllocator>", typeof(List<hkaSkeleton?>) },
        { "hkArray<hkRefPtr<hkaFootstepAnalysisInfo>, hkContainerHeapAllocator>", typeof(List<hkaFootstepAnalysisInfo?>) },
        { "hkArray<char, hkContainerHeapAllocator>", typeof(List<byte>) },
        { "hkArray<hkaSkeletonMapperData::ChainMapping, hkContainerHeapAllocator>", typeof(List<hkaSkeletonMapperData.ChainMapping>) },
        { "hkArray<hkaSkeletonMapperData::SimpleMapping, hkContainerHeapAllocator>", typeof(List<hkaSkeletonMapperData.SimpleMapping>) },
        { "hkArray<hkaSkeletonMapperData::PartitionMappingRange, hkContainerHeapAllocator>", typeof(List<hkaSkeletonMapperData.PartitionMappingRange>) },
        { "hkArray<hkTransform, hkContainerHeapAllocator>", typeof(List<Matrix4x4>) },
        { "hkArray<hkaMeshBinding::Mapping, hkContainerHeapAllocator>", typeof(List<hkaMeshBinding.Mapping>) },
        { "hkArray<hkaAnnotationTrack::Annotation, hkContainerHeapAllocator>", typeof(List<hkaAnnotationTrack.Annotation>) },
        { "hkArray<hkaAnnotationTrack, hkContainerHeapAllocator>", typeof(List<hkaAnnotationTrack>) },
        { "hkArray<hclSimClothSetupObject::PerInstanceCollidable, hkContainerHeapAllocator>", typeof(List<hclSimClothSetupObject.PerInstanceCollidable>) },
        { "hkArray<hclSetupMeshSection::Triangle, hkContainerHeapAllocator>", typeof(List<hclSetupMeshSection.Triangle>) },
        { "hkArray<T*<hclStorageSetupMeshSection::BoneInfluences>, hkContainerHeapAllocator>", typeof(List<hclStorageSetupMeshSection.BoneInfluences?>) },
        { "hkArray<T*<hclStorageSetupMeshSection::SectionTriangleSelectionChannel>, hkContainerHeapAllocator>", typeof(List<hclStorageSetupMeshSection.SectionTriangleSelectionChannel?>) },
        { "hkArray<T*<hclStorageSetupMeshSection::SectionEdgeSelectionChannel>, hkContainerHeapAllocator>", typeof(List<hclStorageSetupMeshSection.SectionEdgeSelectionChannel?>) },
        { "hkArray<T*<hclStorageSetupMeshSection::SectionVertexChannel>, hkContainerHeapAllocator>", typeof(List<hclStorageSetupMeshSection.SectionVertexChannel?>) },
        { "hkArray<hclStorageSetupMesh::Bone, hkContainerHeapAllocator>", typeof(List<hclStorageSetupMesh.Bone>) },
        { "hkArray<hclStorageSetupMesh::TriangleChannel, hkContainerHeapAllocator>", typeof(List<hclStorageSetupMesh.TriangleChannel>) },
        { "hkArray<hclStorageSetupMesh::EdgeChannel, hkContainerHeapAllocator>", typeof(List<hclStorageSetupMesh.EdgeChannel>) },
        { "hkArray<hclStorageSetupMesh::VertexChannel, hkContainerHeapAllocator>", typeof(List<hclStorageSetupMesh.VertexChannel>) },
        { "hkArray<T*<hclStorageSetupMeshSection>, hkContainerHeapAllocator>", typeof(List<hclStorageSetupMeshSection?>) },
        { "hkArray<T*<hclSceneDataSetupMeshSection>, hkContainerHeapAllocator>", typeof(List<hclSceneDataSetupMeshSection?>) },
        { "hkArray<T*<hclConstraintSetSetupObject>, hkContainerHeapAllocator>", typeof(List<hclConstraintSetSetupObject?>) },
        { "hkArray<hclSimulateSetupObject::Config, hkContainerHeapAllocator>", typeof(List<hclSimulateSetupObject.Config>) },
        { "hkArray<hkRefPtr<hclNamedTransformSetSetupObject>, hkContainerHeapAllocator>", typeof(List<hclNamedTransformSetSetupObject?>) },
        { "hkArray<hkRefPtr<hclNamedSetupMesh>, hkContainerHeapAllocator>", typeof(List<hclNamedSetupMesh?>) },
        { "hkArray<hkRefPtr<hclClothSetupObject>, hkContainerHeapAllocator>", typeof(List<hclClothSetupObject?>) },
        { "hkArray<hclBonePlanesSetupObject::PerParticleAngle, hkContainerHeapAllocator>", typeof(List<hclBonePlanesSetupObject.PerParticleAngle>) },
        { "hkArray<hclBonePlanesSetupObject::GlobalPlane, hkContainerHeapAllocator>", typeof(List<hclBonePlanesSetupObject.GlobalPlane>) },
        { "hkArray<hclBonePlanesSetupObject::PerParticlePlane, hkContainerHeapAllocator>", typeof(List<hclBonePlanesSetupObject.PerParticlePlane>) },
        { "hkArray<T*<hclStateTransitionSetupObject>, hkContainerHeapAllocator>", typeof(List<hclStateTransitionSetupObject?>) },
        { "hkArray<T*<hclClothStateSetupObject>, hkContainerHeapAllocator>", typeof(List<hclClothStateSetupObject?>) },
        { "hkArray<T*<hclOperatorSetupObject>, hkContainerHeapAllocator>", typeof(List<hclOperatorSetupObject?>) },
        { "hkArray<T*<hclSimClothSetupObject>, hkContainerHeapAllocator>", typeof(List<hclSimClothSetupObject?>) },
        { "hkArray<T*<hclTransformSetSetupObject>, hkContainerHeapAllocator>", typeof(List<hclTransformSetSetupObject?>) },
        { "hkArray<T*<hclBufferSetupObject>, hkContainerHeapAllocator>", typeof(List<hclBufferSetupObject?>) },
        { "hkArray<hkHandle<unsigned int, 2147483647>, hkContainerHeapAllocator>", typeof(List<hkHandle<uint>>) },
        { "hkArray<hkArray<hkHandle<unsigned int, 2147483647>, hkContainerHeapAllocator>, hkContainerHeapAllocator>", typeof(List<List<hkHandle<uint>>>) },
        { "hkArray<hclTransformSetUsage::TransformTracker, hkContainerHeapAllocator>", typeof(List<hclTransformSetUsage.TransformTracker>) },
        { "hkArray<hclStateTransition::BlendOpTransitionData, hkContainerHeapAllocator>", typeof(List<hclStateTransition.BlendOpTransitionData>) },
        { "hkArray<hclStateTransition::SimClothTransitionData, hkContainerHeapAllocator>", typeof(List<hclStateTransition.SimClothTransitionData>) },
        { "hkArray<hkHandle<hkUint32, 2147483647>, hkContainerHeapAllocator>", typeof(List<hkHandle<uint>>) },
        { "hkArray<hkArray<hkHandle<hkUint32, 2147483647>, hkContainerHeapAllocator>, hkContainerHeapAllocator>", typeof(List<List<hkHandle<uint>>>) },
        { "hkArray<hclStateTransition::StateTransitionData, hkContainerHeapAllocator>", typeof(List<hclStateTransition.StateTransitionData>) },
        { "hkArray<hclStateDependencyGraph::Branch, hkContainerHeapAllocator>", typeof(List<hclStateDependencyGraph.Branch>) },
        { "hkArray<hclSimClothData::CollidablePinchingData, hkContainerHeapAllocator>", typeof(List<hclSimClothData.CollidablePinchingData>) },
        { "hkArray<T*<hclCollidable>, hkContainerHeapAllocator>", typeof(List<hclCollidable?>) },
        { "hkArray<T*<hclConstraintSet>, hkContainerHeapAllocator>", typeof(List<hclConstraintSet?>) },
        { "hkArray<T*<hclSimClothPose>, hkContainerHeapAllocator>", typeof(List<hclSimClothPose?>) },
        { "hkArray<hclSimClothData::ParticleData, hkContainerHeapAllocator>", typeof(List<hclSimClothData.ParticleData>) },
        { "hkArray<hclVirtualCollisionPointsData::TriangleFanLandscape, hkContainerHeapAllocator>", typeof(List<hclVirtualCollisionPointsData.TriangleFanLandscape>) },
        { "hkArray<hclVirtualCollisionPointsData::EdgeFanLandscape, hkContainerHeapAllocator>", typeof(List<hclVirtualCollisionPointsData.EdgeFanLandscape>) },
        { "hkArray<hclVirtualCollisionPointsData::TriangleFan, hkContainerHeapAllocator>", typeof(List<hclVirtualCollisionPointsData.TriangleFan>) },
        { "hkArray<hclVirtualCollisionPointsData::TriangleFanSection, hkContainerHeapAllocator>", typeof(List<hclVirtualCollisionPointsData.TriangleFanSection>) },
        { "hkArray<hclVirtualCollisionPointsData::EdgeFan, hkContainerHeapAllocator>", typeof(List<hclVirtualCollisionPointsData.EdgeFan>) },
        { "hkArray<hclVirtualCollisionPointsData::EdgeFanSection, hkContainerHeapAllocator>", typeof(List<hclVirtualCollisionPointsData.EdgeFanSection>) },
        { "hkArray<hclVirtualCollisionPointsData::BarycentricPair, hkContainerHeapAllocator>", typeof(List<hclVirtualCollisionPointsData.BarycentricPair>) },
        { "hkArray<hclVirtualCollisionPointsData::BarycentricDictionaryEntry, hkContainerHeapAllocator>", typeof(List<hclVirtualCollisionPointsData.BarycentricDictionaryEntry>) },
        { "hkArray<hclVirtualCollisionPointsData::Block, hkContainerHeapAllocator>", typeof(List<hclVirtualCollisionPointsData.Block>) },
        { "hkArray<hclClothState::TransformSetAccess, hkContainerHeapAllocator>", typeof(List<hclClothState.TransformSetAccess>) },
        { "hkArray<hclClothState::BufferAccess, hkContainerHeapAllocator>", typeof(List<hclClothState.BufferAccess>) },
        { "hkArray<hclGatherSomeVerticesOperator::VertexPair, hkContainerHeapAllocator>", typeof(List<hclGatherSomeVerticesOperator.VertexPair>) },
        { "hkArray<hclUpdateSomeVertexFramesOperator::Triangle, hkContainerHeapAllocator>", typeof(List<hclUpdateSomeVertexFramesOperator.Triangle>) },
        { "hkArray<hclSkinOperator::BoneInfluence, hkContainerHeapAllocator>", typeof(List<hclSkinOperator.BoneInfluence>) },
        { "hkArray<hclSimulateOperator::Config, hkContainerHeapAllocator>", typeof(List<hclSimulateOperator.Config>) },
        { "hkArray<hclObjectSpaceDeformer::LocalBlockUnpackedP, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.LocalBlockUnpackedP>) },
        { "hkArray<hclObjectSpaceDeformer::LocalBlockP, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.LocalBlockP>) },
        { "hkArray<hclObjectSpaceDeformer::LocalBlockUnpackedPNT, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.LocalBlockUnpackedPNT>) },
        { "hkArray<hclObjectSpaceDeformer::LocalBlockPNT, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.LocalBlockPNT>) },
        { "hkArray<hclObjectSpaceDeformer::LocalBlockUnpackedPNTB, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.LocalBlockUnpackedPNTB>) },
        { "hkArray<hclObjectSpaceDeformer::LocalBlockPNTB, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.LocalBlockPNTB>) },
        { "hkArray<hclObjectSpaceDeformer::LocalBlockUnpackedPN, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.LocalBlockUnpackedPN>) },
        { "hkArray<hclObjectSpaceDeformer::LocalBlockPN, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.LocalBlockPN>) },
        { "hkArray<hclMoveParticlesOperator::VertexParticlePair, hkContainerHeapAllocator>", typeof(List<hclMoveParticlesOperator.VertexParticlePair>) },
        { "hkArray<hclMeshMeshDeformOperator::TriangleVertexPair, hkContainerHeapAllocator>", typeof(List<hclMeshMeshDeformOperator.TriangleVertexPair>) },
        { "hkArray<hclSimpleMeshBoneDeformOperator::TriangleBonePair, hkContainerHeapAllocator>", typeof(List<hclSimpleMeshBoneDeformOperator.TriangleBonePair>) },
        { "hkArray<hclMeshBoneDeformOperator::TriangleBonePair, hkContainerHeapAllocator>", typeof(List<hclMeshBoneDeformOperator.TriangleBonePair>) },
        { "hkArray<hclObjectSpaceDeformer::OneBlendEntryBlock, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.OneBlendEntryBlock>) },
        { "hkArray<hclObjectSpaceDeformer::TwoBlendEntryBlock, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.TwoBlendEntryBlock>) },
        { "hkArray<hclObjectSpaceDeformer::ThreeBlendEntryBlock, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.ThreeBlendEntryBlock>) },
        { "hkArray<hclObjectSpaceDeformer::FourBlendEntryBlock, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.FourBlendEntryBlock>) },
        { "hkArray<hclObjectSpaceDeformer::FiveBlendEntryBlock, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.FiveBlendEntryBlock>) },
        { "hkArray<hclObjectSpaceDeformer::SixBlendEntryBlock, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.SixBlendEntryBlock>) },
        { "hkArray<hclObjectSpaceDeformer::SevenBlendEntryBlock, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.SevenBlendEntryBlock>) },
        { "hkArray<hclObjectSpaceDeformer::EightBlendEntryBlock, hkContainerHeapAllocator>", typeof(List<hclObjectSpaceDeformer.EightBlendEntryBlock>) },
        { "hkArray<hclBoneSpaceDeformer::OneBlendEntryBlock, hkContainerHeapAllocator>", typeof(List<hclBoneSpaceDeformer.OneBlendEntryBlock>) },
        { "hkArray<hclBoneSpaceDeformer::TwoBlendEntryBlock, hkContainerHeapAllocator>", typeof(List<hclBoneSpaceDeformer.TwoBlendEntryBlock>) },
        { "hkArray<hclBoneSpaceDeformer::ThreeBlendEntryBlock, hkContainerHeapAllocator>", typeof(List<hclBoneSpaceDeformer.ThreeBlendEntryBlock>) },
        { "hkArray<hclBoneSpaceDeformer::FourBlendEntryBlock, hkContainerHeapAllocator>", typeof(List<hclBoneSpaceDeformer.FourBlendEntryBlock>) },
        { "hkArray<hclBoneSpaceDeformer::LocalBlockUnpackedP, hkContainerHeapAllocator>", typeof(List<hclBoneSpaceDeformer.LocalBlockUnpackedP>) },
        { "hkArray<hclBoneSpaceDeformer::LocalBlockP, hkContainerHeapAllocator>", typeof(List<hclBoneSpaceDeformer.LocalBlockP>) },
        { "hkArray<hclBoneSpaceDeformer::LocalBlockUnpackedPNT, hkContainerHeapAllocator>", typeof(List<hclBoneSpaceDeformer.LocalBlockUnpackedPNT>) },
        { "hkArray<hclBoneSpaceDeformer::LocalBlockPNT, hkContainerHeapAllocator>", typeof(List<hclBoneSpaceDeformer.LocalBlockPNT>) },
        { "hkArray<hclBoneSpaceDeformer::LocalBlockUnpackedPNTB, hkContainerHeapAllocator>", typeof(List<hclBoneSpaceDeformer.LocalBlockUnpackedPNTB>) },
        { "hkArray<hclBoneSpaceDeformer::LocalBlockPNTB, hkContainerHeapAllocator>", typeof(List<hclBoneSpaceDeformer.LocalBlockPNTB>) },
        { "hkArray<hclBoneSpaceDeformer::LocalBlockUnpackedPN, hkContainerHeapAllocator>", typeof(List<hclBoneSpaceDeformer.LocalBlockUnpackedPN>) },
        { "hkArray<hclBoneSpaceDeformer::LocalBlockPN, hkContainerHeapAllocator>", typeof(List<hclBoneSpaceDeformer.LocalBlockPN>) },
        { "hkArray<hclBlendSomeVerticesOperator::BlendEntry, hkContainerHeapAllocator>", typeof(List<hclBlendSomeVerticesOperator.BlendEntry>) },
        { "hkArray<hkRefPtr<hclClothData>, hkContainerHeapAllocator>", typeof(List<hclClothData?>) },
        { "hkArray<hkRefPtr<hclCollidable>, hkContainerHeapAllocator>", typeof(List<hclCollidable?>) },
        { "hkArray<hclVolumeConstraintMx::ApplySingleData, hkContainerHeapAllocator>", typeof(List<hclVolumeConstraintMx.ApplySingleData>) },
        { "hkArray<hclVolumeConstraintMx::ApplyBatchData, hkContainerHeapAllocator>", typeof(List<hclVolumeConstraintMx.ApplyBatchData>) },
        { "hkArray<hclVolumeConstraintMx::FrameSingleData, hkContainerHeapAllocator>", typeof(List<hclVolumeConstraintMx.FrameSingleData>) },
        { "hkArray<hclVolumeConstraintMx::FrameBatchData, hkContainerHeapAllocator>", typeof(List<hclVolumeConstraintMx.FrameBatchData>) },
        { "hkArray<hclVolumeConstraint::ApplyData, hkContainerHeapAllocator>", typeof(List<hclVolumeConstraint.ApplyData>) },
        { "hkArray<hclVolumeConstraint::FrameData, hkContainerHeapAllocator>", typeof(List<hclVolumeConstraint.FrameData>) },
        { "hkArray<hclTransitionConstraintSet::PerParticle, hkContainerHeapAllocator>", typeof(List<hclTransitionConstraintSet.PerParticle>) },
        { "hkArray<hclStretchLinkConstraintSetMx::Single, hkContainerHeapAllocator>", typeof(List<hclStretchLinkConstraintSetMx.Single>) },
        { "hkArray<hclStretchLinkConstraintSetMx::Batch, hkContainerHeapAllocator>", typeof(List<hclStretchLinkConstraintSetMx.Batch>) },
        { "hkArray<hclStretchLinkConstraintSet::Link, hkContainerHeapAllocator>", typeof(List<hclStretchLinkConstraintSet.Link>) },
        { "hkArray<hclStandardLinkConstraintSetMx::Single, hkContainerHeapAllocator>", typeof(List<hclStandardLinkConstraintSetMx.Single>) },
        { "hkArray<hclStandardLinkConstraintSetMx::Batch, hkContainerHeapAllocator>", typeof(List<hclStandardLinkConstraintSetMx.Batch>) },
        { "hkArray<hclStandardLinkConstraintSet::Link, hkContainerHeapAllocator>", typeof(List<hclStandardLinkConstraintSet.Link>) },
        { "hkArray<hclLocalRangeConstraintSet::LocalConstraint, hkContainerHeapAllocator>", typeof(List<hclLocalRangeConstraintSet.LocalConstraint>) },
        { "hkArray<hclCompressibleLinkConstraintSetMx::Single, hkContainerHeapAllocator>", typeof(List<hclCompressibleLinkConstraintSetMx.Single>) },
        { "hkArray<hclCompressibleLinkConstraintSetMx::Batch, hkContainerHeapAllocator>", typeof(List<hclCompressibleLinkConstraintSetMx.Batch>) },
        { "hkArray<hclCompressibleLinkConstraintSet::Link, hkContainerHeapAllocator>", typeof(List<hclCompressibleLinkConstraintSet.Link>) },
        { "hkArray<hclBonePlanesConstraintSet::BonePlane, hkContainerHeapAllocator>", typeof(List<hclBonePlanesConstraintSet.BonePlane>) },
        { "hkArray<hclBendStiffnessConstraintSetMx::Single, hkContainerHeapAllocator>", typeof(List<hclBendStiffnessConstraintSetMx.Single>) },
        { "hkArray<hclBendStiffnessConstraintSetMx::Batch, hkContainerHeapAllocator>", typeof(List<hclBendStiffnessConstraintSetMx.Batch>) },
        { "hkArray<hclBendStiffnessConstraintSet::Link, hkContainerHeapAllocator>", typeof(List<hclBendStiffnessConstraintSet.Link>) },
        { "hkArray<hclBendLinkConstraintSetMx::Single, hkContainerHeapAllocator>", typeof(List<hclBendLinkConstraintSetMx.Single>) },
        { "hkArray<hclBendLinkConstraintSetMx::Batch, hkContainerHeapAllocator>", typeof(List<hclBendLinkConstraintSetMx.Batch>) },
        { "hkArray<hclBendLinkConstraintSet::Link, hkContainerHeapAllocator>", typeof(List<hclBendLinkConstraintSet.Link>) },
        { "hkArray<hclAntiPinchConstraintSet::PerParticle, hkContainerHeapAllocator>", typeof(List<hclAntiPinchConstraintSet.PerParticle>) },
        { "hkArray<T*<hclAction>, hkContainerHeapAllocator>", typeof(List<hclAction?>) },
        { "hkArray<T*<hclStateTransition>, hkContainerHeapAllocator>", typeof(List<hclStateTransition?>) },
        { "hkArray<T*<hclClothState>, hkContainerHeapAllocator>", typeof(List<hclClothState?>) },
        { "hkArray<T*<hclOperator>, hkContainerHeapAllocator>", typeof(List<hclOperator?>) },
        { "hkArray<T*<hclTransformSetDefinition>, hkContainerHeapAllocator>", typeof(List<hclTransformSetDefinition?>) },
        { "hkArray<T*<hclBufferDefinition>, hkContainerHeapAllocator>", typeof(List<hclBufferDefinition?>) },
        { "hkArray<T*<hclSimClothData>, hkContainerHeapAllocator>", typeof(List<hclSimClothData?>) },
        { "hkArray<unsigned long long, hkContainerHeapAllocator>", typeof(List<ulong>) },
        { "hkArray<signed char, hkContainerHeapAllocator>", typeof(List<sbyte>) },
        { "hkArray<hkbBehaviorInfo::IdToNamePair, hkContainerHeapAllocator>", typeof(List<hkbBehaviorInfo.IdToNamePair>) },
        { "hkArray<hkRefPtr<hkbBehaviorGraph>, hkContainerHeapAllocator>", typeof(List<hkbBehaviorGraph?>) },
        { "hkArray<hkRefPtr<hkbAuxiliaryNodeInfo>, hkContainerHeapAllocator>", typeof(List<hkbAuxiliaryNodeInfo?>) },
        { "hkArray<hkUint64, hkContainerHeapAllocator>", typeof(List<ulong>) },
        { "hkArray<hkVariableTweakingHelper::Vector4VariableInfo, hkContainerHeapAllocator>", typeof(List<hkVariableTweakingHelper.Vector4VariableInfo>) },
        { "hkArray<hkVariableTweakingHelper::RealVariableInfo, hkContainerHeapAllocator>", typeof(List<hkVariableTweakingHelper.RealVariableInfo>) },
        { "hkArray<hkVariableTweakingHelper::IntVariableInfo, hkContainerHeapAllocator>", typeof(List<hkVariableTweakingHelper.IntVariableInfo>) },
        { "hkArray<hkVariableTweakingHelper::BoolVariableInfo, hkContainerHeapAllocator>", typeof(List<hkVariableTweakingHelper.BoolVariableInfo>) },
        { "hkArray<hkbShapeSetup, hkContainerHeapAllocator>", typeof(List<hkbShapeSetup>) },
        { "hkArray<hkbRadialSelectorGenerator::GeneratorPair, hkContainerHeapAllocator>", typeof(List<hkbRadialSelectorGenerator.GeneratorPair>) },
        { "hkArray<T*<hkbPoseStoringGeneratorOutputListener::StoredPose>, hkContainerHeapAllocator>", typeof(List<hkbPoseStoringGeneratorOutputListener.StoredPose?>) },
        { "hkArray<hkbCustomTestGeneratorNestedTypesBase, hkContainerHeapAllocator>", typeof(List<hkbCustomTestGeneratorNestedTypesBase>) },
        { "hkArray<hkRefPtr<hkbCustomIdSelector>, hkContainerHeapAllocator>", typeof(List<hkbCustomIdSelector?>) },
        { "hkArray<T*<hkbCustomIdSelector>, hkContainerHeapAllocator>", typeof(List<hkbCustomIdSelector?>) },
        { "hkArray<hkRefPtr<hkbModifier>, hkContainerHeapAllocator>", typeof(List<hkbModifier?>) },
        { "hkArray<hkUint16, hkContainerHeapAllocator>", typeof(List<ushort>) },
        { "hkArray<hkInt8, hkContainerHeapAllocator>", typeof(List<sbyte>) },
        { "hkArray<const char*, hkContainerHeapAllocator>", typeof(List<string?>) },
        { "hkArray<bool, hkContainerHeapAllocator>", typeof(List<bool>) },
        { "hkArray<hkbBodyIkControlPoint, hkContainerHeapAllocator>", typeof(List<hkbBodyIkControlPoint>) },
        { "hkArray<hkbBodyIkControlPin, hkContainerHeapAllocator>", typeof(List<hkbBodyIkControlPin>) },
        { "hkArray<hkbBodyIkControllerProfile, hkContainerHeapAllocator>", typeof(List<hkbBodyIkControllerProfile>) },
        { "hkArray<hkHashMapDetail::MapTuple<T*<hkReflect::Type>, T*<void>>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<IHavokObject?, object?>>) },
        { "hkArray<hkHashMapDetail::MapTuple<unsigned long long, T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<ulong, hkHashMap<IHavokObject?, object?>?>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkUlong, T*<hkHashMap<T*<hkReflect::Type>, T*<void>>>>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<ulong, hkHashMap<IHavokObject?, object?>?>>) },
        { "hkArray<hkQsTransformf, hkContainerHeapAllocator>", typeof(List<hkQsTransformf>) },
        { "hkArray<short, hkContainerHeapAllocator>", typeof(List<short>) },
        { "hkArray<hkRefVariant, hkContainerHeapAllocator>", typeof(List<hkReferencedObject?>) },
        { "hkArray<hkbVariableValue, hkContainerHeapAllocator>", typeof(List<hkbVariableValue>) },
        { "hkArray<hkbVariableBindingSet::Binding, hkContainerHeapAllocator>", typeof(List<hkbVariableBindingSet.Binding>) },
        { "hkArray<hkbCompiledExpressionSet::Token, hkContainerHeapAllocator>", typeof(List<hkbCompiledExpressionSet.Token>) },
        { "hkArray<T*<hkbTransitionEffect>, hkContainerHeapAllocator>", typeof(List<hkbTransitionEffect?>) },
        { "hkArray<hkQsTransform, hkContainerHeapAllocator>", typeof(List<hkQsTransform>) },
        { "hkArray<hkbStateMachine::DelayedTransitionInfo, hkContainerHeapAllocator>", typeof(List<hkbStateMachine.DelayedTransitionInfo>) },
        { "hkArray<T*<hkbStateListener>, hkContainerHeapAllocator>", typeof(List<hkbStateListener?>) },
        { "hkArray<hkbEventProperty, hkContainerHeapAllocator>", typeof(List<hkbEventProperty>) },
        { "hkArray<hkbStateMachine::TransitionInfo, hkContainerHeapAllocator>", typeof(List<hkbStateMachine.TransitionInfo>) },
        { "hkArray<T*<hkbStateMachine::StateInfo>, hkContainerHeapAllocator>", typeof(List<hkbStateMachine.StateInfo?>) },
        { "hkArray<hkbIntVariableSequencedData::Sample, hkContainerHeapAllocator>", typeof(List<hkbIntVariableSequencedData.Sample>) },
        { "hkArray<hkbBoolVariableSequencedData::Sample, hkContainerHeapAllocator>", typeof(List<hkbBoolVariableSequencedData.Sample>) },
        { "hkArray<hkbRealVariableSequencedData::Sample, hkContainerHeapAllocator>", typeof(List<hkbRealVariableSequencedData.Sample>) },
        { "hkArray<hkbEventSequencedData::SequencedEvent, hkContainerHeapAllocator>", typeof(List<hkbEventSequencedData.SequencedEvent>) },
        { "hkArray<T*<hkbIntVariableSequencedData>, hkContainerHeapAllocator>", typeof(List<hkbIntVariableSequencedData?>) },
        { "hkArray<T*<hkbBoolVariableSequencedData>, hkContainerHeapAllocator>", typeof(List<hkbBoolVariableSequencedData?>) },
        { "hkArray<T*<hkbRealVariableSequencedData>, hkContainerHeapAllocator>", typeof(List<hkbRealVariableSequencedData?>) },
        { "hkArray<T*<hkbEventSequencedData>, hkContainerHeapAllocator>", typeof(List<hkbEventSequencedData?>) },
        { "hkArray<hkbSenseHandleModifier::Range, hkContainerHeapAllocator>", typeof(List<hkbSenseHandleModifier.Range>) },
        { "hkArray<hkbKeyframeBonesModifier::KeyframeInfo, hkContainerHeapAllocator>", typeof(List<hkbKeyframeBonesModifier.KeyframeInfo>) },
        { "hkArray<T*<hkbModifier>, hkContainerHeapAllocator>", typeof(List<hkbModifier?>) },
        { "hkArray<T*<hkbJigglerGroup>, hkContainerHeapAllocator>", typeof(List<hkbJigglerGroup?>) },
        { "hkArray<hkbHandIkModifier::Hand, hkContainerHeapAllocator>", typeof(List<hkbHandIkModifier.Hand>) },
        { "hkArray<hkbHandIkControlsModifier::Hand, hkContainerHeapAllocator>", typeof(List<hkbHandIkControlsModifier.Hand>) },
        { "hkArray<hkbFootIkModifier::InternalLegData, hkContainerHeapAllocator>", typeof(List<hkbFootIkModifier.InternalLegData>) },
        { "hkArray<hkbFootIkModifier::Leg, hkContainerHeapAllocator>", typeof(List<hkbFootIkModifier.Leg>) },
        { "hkArray<hkbFootIkControlsModifier::Leg, hkContainerHeapAllocator>", typeof(List<hkbFootIkControlsModifier.Leg>) },
        { "hkArray<hkBool, hkContainerHeapAllocator>", typeof(List<bool>) },
        { "hkArray<hkbEventRangeData, hkContainerHeapAllocator>", typeof(List<hkbEventRangeData>) },
        { "hkArray<hkbEvaluateExpressionModifier::InternalExpressionData, hkContainerHeapAllocator>", typeof(List<hkbEvaluateExpressionModifier.InternalExpressionData>) },
        { "hkArray<hkbExpressionData, hkContainerHeapAllocator>", typeof(List<hkbExpressionData>) },
        { "hkArray<hkbBodyIkControlsModifier::ControlData, hkContainerHeapAllocator>", typeof(List<hkbBodyIkControlsModifier.ControlData>) },
        { "hkArray<hkbAttributeModifier::Assignment, hkContainerHeapAllocator>", typeof(List<hkbAttributeModifier.Assignment>) },
        { "hkArray<hkRefPtr<hkbGenerator>, hkContainerHeapAllocator>", typeof(List<hkbGenerator?>) },
        { "hkArray<hkbStateMachine::ActiveTransitionInfo, hkContainerHeapAllocator>", typeof(List<hkbStateMachine.ActiveTransitionInfo>) },
        { "hkArray<T*<hkbGenerator>, hkContainerHeapAllocator>", typeof(List<hkbGenerator?>) },
        { "hkArray<hkbClipGenerator::Echo, hkContainerHeapAllocator>", typeof(List<hkbClipGenerator.Echo>) },
        { "hkArray<hkbClipTrigger, hkContainerHeapAllocator>", typeof(List<hkbClipTrigger>) },
        { "hkArray<hkbBlenderGenerator::ChildInternalState, hkContainerHeapAllocator>", typeof(List<hkbBlenderGenerator.ChildInternalState>) },
        { "hkArray<T*<hkbBlenderGeneratorChild>, hkContainerHeapAllocator>", typeof(List<hkbBlenderGeneratorChild?>) },
        { "hkArray<hkbEventDrivenBlendingObject::InternalState, hkContainerHeapAllocator>", typeof(List<hkbEventDrivenBlendingObject.InternalState>) },
        { "hkArray<hkbLayerGenerator::LayerInternalState, hkContainerHeapAllocator>", typeof(List<hkbLayerGenerator.LayerInternalState>) },
        { "hkArray<T*<hkbLayer>, hkContainerHeapAllocator>", typeof(List<hkbLayer?>) },
        { "hkArray<T*<hkbEventPayload>, hkContainerHeapAllocator>", typeof(List<hkbEventPayload?>) },
        { "hkArray<hkbHandIkDriverInfo::Hand, hkContainerHeapAllocator>", typeof(List<hkbHandIkDriverInfo.Hand>) },
        { "hkArray<hkbFootIkDriverInfo::Leg, hkContainerHeapAllocator>", typeof(List<hkbFootIkDriverInfo.Leg>) },
        { "hkArray<hkbAssetBundleStringData, hkContainerHeapAllocator>", typeof(List<hkbAssetBundleStringData>) },
        { "hkArray<hkbCharacterStringData::FileNameMeshNamePair, hkContainerHeapAllocator>", typeof(List<hkbCharacterStringData.FileNameMeshNamePair>) },
        { "hkArray<hkRefPtr<hkaSkeletonMapper>, hkContainerHeapAllocator>", typeof(List<hkaSkeletonMapper?>) },
        { "hkArray<hkRefPtr<hkbCustomPropertySheet>, hkContainerHeapAllocator>", typeof(List<hkbCustomPropertySheet?>) },
        { "hkArray<hkMatrix4, hkContainerHeapAllocator>", typeof(List<Matrix4x4>) },
        { "hkArray<T*<hkbCharacter>, hkContainerHeapAllocator>", typeof(List<hkbCharacter?>) },
        { "hkArray<hkInt16, hkContainerHeapAllocator>", typeof(List<short>) },
        { "hkArray<hkStringPtr, hkContainerHeapAllocator>", typeof(List<string?>) },
        { "hkArray<hkRefPtr<hkbNodeInternalStateInfo>, hkContainerHeapAllocator>", typeof(List<hkbNodeInternalStateInfo?>) },
        { "hkArray<hkbVariableBounds, hkContainerHeapAllocator>", typeof(List<hkbVariableBounds>) },
        { "hkArray<hkbEventInfo, hkContainerHeapAllocator>", typeof(List<hkbEventInfo>) },
        { "hkArray<hkbVariableInfo, hkContainerHeapAllocator>", typeof(List<hkbVariableInfo>) },
        { "hkArray<hkRefPtr<hkaiVolumeNavigator>, hkContainerHeapAllocator>", typeof(List<hkaiVolumeNavigator?>) },
        { "hkArray<hkRefPtr<hkaiNavigator>, hkContainerHeapAllocator>", typeof(List<hkaiNavigator?>) },
        { "hkArray<hkColor::Argb, hkContainerHeapAllocator>", typeof(List<Color>) },
        { "hkArray<hkaiIndex<int>, hkContainerHeapAllocator>", typeof(List<int>) },
        { "hkArray<hkaiPackedKey_<hkaiIndex<int>, hkaiIndex<int>>, hkContainerHeapAllocator>", typeof(List<uint>) },
        { "hkArray<hkHashMapDetail::MapTuple<int, hkaiNavMeshInstanceData::FaceDynUserEdgeBases>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiNavMeshInstanceData.FaceDynUserEdgeBases>>) },
        { "hkArray<hkHashMapDetail::MapTuple<int, hkaiDefaultDynamicUserEdgeSetInfo::Section>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiDefaultDynamicUserEdgeSetInfo.Section>>) },
        { "hkArray<hkHashMapDetail::MapTuple<int, hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.ExternalEdges?>>) },
        { "hkArray<hkHashMapDetail::MapTuple<int, hkaiDynamicUserEdgeSetInfo::Section>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.Section>>) },
        { "hkArray<hkHashMapDetail::MapTuple<int, hkRefPtr<hkaiStreamingSet>>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiStreamingSet?>>) },
        { "hkArray<hkHashMapDetail::MapTuple<int, int>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, int>>) },
        { "hkArray<hkHashMapDetail::MapTuple<int, hkaiModifiedSections::Section>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiModifiedSections.Section>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkHandle<unsigned int, -1>, hkaiDynamicUserEdgeSetInfo>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<hkHandle<uint>, hkaiDynamicUserEdgeSetInfo>>) },
        { "hkArray<hkHashMapDetail::MapTuple<int, hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, List<hkaiNavMeshCutConfiguration.DynamicUserEdge>>>) },
        { "hkArray<hkHashMapDetail::MapTuple<int, hkaiNavMeshCutConfiguration::BigFaceInfo>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.BigFaceInfo>>) },
        { "hkArray<hkHashMapDetail::MapTuple<int, hkaiNavMeshCutConfiguration::FaceInfo>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.FaceInfo>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiNavMeshInstanceData::FaceDynUserEdgeBases>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiNavMeshInstanceData.FaceDynUserEdgeBases>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiDefaultDynamicUserEdgeSetInfo::Section>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiDefaultDynamicUserEdgeSetInfo.Section>>) },
        { "hkArray<hkaiDynamicUserEdgeSetInfo::UserEdgePair, hkContainerHeapAllocator>", typeof(List<hkaiDynamicUserEdgeSetInfo.UserEdgePair>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkRefPtr<hkaiDynamicUserEdgeSetInfo::ExternalEdges>>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.ExternalEdges?>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkaiDynamicUserEdgeSetInfoBase::ClusterGraphEdge, int>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<hkaiDynamicUserEdgeSetInfoBase.ClusterGraphEdge, int>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiDynamicUserEdgeSetInfo::Section>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiDynamicUserEdgeSetInfo.Section>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkRefPtr<hkaiStreamingSet>>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiStreamingSet?>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, int>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, int>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiModifiedSections::Section>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiModifiedSections.Section>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkHandle<hkUint32, -1>, hkaiDynamicUserEdgeSetInfo>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<hkHandle<uint>, hkaiDynamicUserEdgeSetInfo>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, List<hkaiNavMeshCutConfiguration.DynamicUserEdge>>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiNavMeshCutConfiguration::BigFaceInfo>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.BigFaceInfo>>) },
        { "hkArray<hkHashMapDetail::MapTuple<hkaiIndex<hkInt32>, hkaiNavMeshCutConfiguration::FaceInfo>, hkContainerHeapAllocator>", typeof(List<hkHashMapDetail.MapTuple<int, hkaiNavMeshCutConfiguration.FaceInfo>>) },
        { "hkArray<hkaiIndex<hkInt32>, hkContainerHeapAllocator>", typeof(List<int>) },
        { "hkArray<hkaiReferenceFrame, hkContainerHeapAllocator>", typeof(List<hkaiReferenceFrame>) },
        { "hkArray<hkQTransform, hkContainerHeapAllocator>", typeof(List<hkQTransform>) },
        { "hkArray<T*<hkaiStreamingSet>, hkContainerHeapAllocator>", typeof(List<hkaiStreamingSet?>) },
        { "hkArray<float, hkContainerHeapAllocator>", typeof(List<float>) },
        { "hkArray<hkHandle<unsigned int, -1>, hkContainerHeapAllocator>", typeof(List<hkHandle<uint>>) },
        { "hkArray<unsigned short, hkContainerHeapAllocator>", typeof(List<ushort>) },
        { "hkArray<hkVector2f, hkContainerHeapAllocator>", typeof(List<hkVector2f>) },
        { "hkArray<unsigned int, hkContainerHeapAllocator>", typeof(List<uint>) },
        { "hkArray<hkHashSet<int>, hkContainerHeapAllocator>", typeof(List<hkHashSet<int>>) },
        { "hkArray<hkaiNavMeshCutConfiguration::DynamicUserEdge, hkContainerHeapAllocator>", typeof(List<hkaiNavMeshCutConfiguration.DynamicUserEdge>) },
        { "hkArray<hkaiLocalSteeringInput, hkContainerHeapAllocator>", typeof(List<hkaiLocalSteeringInput>) },
        { "hkArray<hkRefPtr<hkaiCharacter>, hkContainerHeapAllocator>", typeof(List<hkaiCharacter?>) },
        { "hkArray<hkRefPtr<hkaiObstacleGenerator>, hkContainerHeapAllocator>", typeof(List<hkaiObstacleGenerator?>) },
        { "hkArray<hkRefPtr<hkaiSilhouetteGenerator>, hkContainerHeapAllocator>", typeof(List<hkaiSilhouetteGenerator?>) },
        { "hkArray<hkRefPtr<hkaiPathRequestQueue>, hkContainerHeapAllocator>", typeof(List<hkaiPathRequestQueue?>) },
        { "hkArray<hkRefPtr<hkaiNavVolumePathRequest>, hkContainerHeapAllocator>", typeof(List<hkaiNavVolumePathRequest?>) },
        { "hkArray<hkRefPtr<hkaiNavMeshPathRequest>, hkContainerHeapAllocator>", typeof(List<hkaiNavMeshPathRequest?>) },
        { "hkArray<hkaiNavVolumePathRequestInfo, hkContainerHeapAllocator>", typeof(List<hkaiNavVolumePathRequestInfo>) },
        { "hkArray<hkaiNavMeshPathRequestInfo, hkContainerHeapAllocator>", typeof(List<hkaiNavMeshPathRequestInfo>) },
        { "hkArray<hkaiPackedKey_<hkaiIndex<hkInt32>, hkaiIndex<hkInt32>>, hkContainerHeapAllocator>", typeof(List<uint>) },
        { "hkArray<hkaiSearchExpansionRecord::hkaiSingleExpansionRecord, hkContainerHeapAllocator>", typeof(List<hkaiSearchExpansionRecord.hkaiSingleExpansionRecord>) },
        { "hkArray<hkReal, hkContainerHeapAllocator>", typeof(List<float>) },
        { "hkArray<hkViewPtr<hkaiVolumeNavigator>, hkContainerHeapAllocator>", typeof(List<hkaiVolumeNavigator?>) },
        { "hkArray<hkaiVolumeNavigator::Goal, hkContainerHeapAllocator>", typeof(List<hkaiVolumeNavigator.Goal>) },
        { "hkArray<hkViewPtr<hkaiNavigator>, hkContainerHeapAllocator>", typeof(List<hkaiNavigator?>) },
        { "hkArray<hkaiNavigator::Goal, hkContainerHeapAllocator>", typeof(List<hkaiNavigator.Goal>) },
        { "hkArray<hkaiNavVolumeInstanceData::CellInstance, hkContainerHeapAllocator>", typeof(List<hkaiNavVolumeInstanceData.CellInstance>) },
        { "hkArray<hkaiNavVolume::UserEdgeInfo, hkContainerHeapAllocator>", typeof(List<hkaiNavVolume.UserEdgeInfo>) },
        { "hkArray<hkaiNavVolume::Edge, hkContainerHeapAllocator>", typeof(List<hkaiNavVolume.Edge>) },
        { "hkArray<hkaiNavVolume::Cell, hkContainerHeapAllocator>", typeof(List<hkaiNavVolume.Cell>) },
        { "hkArray<hkaiIndex<hkUint16>, hkContainerHeapAllocator>", typeof(List<ushort>) },
        { "hkArray<unsigned char, hkContainerHeapAllocator>", typeof(List<byte>) },
        { "hkArray<hkaiCopyOnWritePtr<hkaiNavMeshClearanceCache, hkaiCopyOnWriteDefaultTraits<hkaiNavMeshClearanceCache>>, hkContainerHeapAllocator>", typeof(List<hkaiCopyOnWritePtr<hkaiNavMeshClearanceCache>>) },
        { "hkArray<hkaiNavMesh::Edge, hkContainerHeapAllocator>", typeof(List<hkaiNavMesh.Edge>) },
        { "hkArray<hkaiNavMesh::Face, hkContainerHeapAllocator>", typeof(List<hkaiNavMesh.Face>) },
        { "hkArray<hkaiUserEdgeUtils::UserEdgePair, hkContainerHeapAllocator>", typeof(List<hkaiUserEdgeUtils.UserEdgePair>) },
        { "hkArray<hkaiUserEdgeUtils::UserEdgeSetup, hkContainerHeapAllocator>", typeof(List<hkaiUserEdgeUtils.UserEdgeSetup>) },
        { "hkArray<hkaiStreamingSetInstance::DynUserEdgeConnection, hkContainerHeapAllocator>", typeof(List<hkaiStreamingSetInstance.DynUserEdgeConnection>) },
        { "hkArray<hkaiStreamingSet::VolumeConnection, hkContainerHeapAllocator>", typeof(List<hkaiStreamingSet.VolumeConnection>) },
        { "hkArray<hkaiStreamingSet::GraphConnection, hkContainerHeapAllocator>", typeof(List<hkaiStreamingSet.GraphConnection>) },
        { "hkArray<hkaiStreamingSet::NavMeshConnection, hkContainerHeapAllocator>", typeof(List<hkaiStreamingSet.NavMeshConnection>) },
        { "hkArray<hkaiCopyOnWritePtr<hkaiStreamingSetInstance, hkaiCopyOnWriteDefaultTraits<hkaiStreamingSetInstance>>, hkContainerHeapAllocator>", typeof(List<hkaiCopyOnWritePtr<hkaiStreamingSetInstance>>) },
        { "hkArray<hkaiStreamingCollectionInstanceInfo, hkContainerHeapAllocator>", typeof(List<hkaiStreamingCollectionInstanceInfo>) },
        { "hkArray<hkVector2, hkContainerHeapAllocator>", typeof(List<hkVector2>) },
        { "hkArray<hkaiNavMeshClearanceCacheSeeding::CacheData, hkContainerHeapAllocator>", typeof(List<hkaiNavMeshClearanceCacheSeeding.CacheData>) },
        { "hkArray<hkaiNavMeshClearanceCacheManager::CacheInfo, hkContainerHeapAllocator>", typeof(List<hkaiNavMeshClearanceCacheManager.CacheInfo>) },
        { "hkArray<hkaiNavMeshClearanceCacheManager::Registration, hkContainerHeapAllocator>", typeof(List<hkaiNavMeshClearanceCacheManager.Registration>) },
        { "hkArray<hkaiNavMeshClearanceCacheManager::LayerData, hkContainerHeapAllocator>", typeof(List<hkaiNavMeshClearanceCacheManager.LayerData>) },
        { "hkArray<hkaiNavMeshClearanceCache::McpDataInteger, hkContainerHeapAllocator>", typeof(List<hkaiNavMeshClearanceCache.McpDataInteger>) },
        { "hkArray<hkUint8, hkContainerHeapAllocator>", typeof(List<byte>) },
        { "hkArray<hkaiDirectedGraphInstanceData::FreeBlockList, hkContainerHeapAllocator>", typeof(List<hkaiDirectedGraphInstanceData.FreeBlockList>) },
        { "hkArray<hkaiAnnotatedStreamingSet, hkContainerHeapAllocator>", typeof(List<hkaiAnnotatedStreamingSet>) },
        { "hkArray<hkUint32, hkContainerHeapAllocator>", typeof(List<uint>) },
        { "hkArray<hkaiDirectedGraphExplicitCost::Edge, hkContainerHeapAllocator>", typeof(List<hkaiDirectedGraphExplicitCost.Edge>) },
        { "hkArray<hkaiDirectedGraphExplicitCost::Node, hkContainerHeapAllocator>", typeof(List<hkaiDirectedGraphExplicitCost.Node>) },
        { "hkArray<hkaiOverlapManager::PendingUpdate, hkContainerHeapAllocator>", typeof(List<hkaiOverlapManager.PendingUpdate>) },
        { "hkArray<hkArray<int, hkContainerHeapAllocator>, hkContainerHeapAllocator>", typeof(List<List<int>>) },
        { "hkArray<hkaiOverlapManager::Overlap, hkContainerHeapAllocator>", typeof(List<hkaiOverlapManager.Overlap>) },
        { "hkArray<hkaiOverlapManager::Generator, hkContainerHeapAllocator>", typeof(List<hkaiOverlapManager.Generator>) },
        { "hkArray<hkaiOverlapManager::Section, hkContainerHeapAllocator>", typeof(List<hkaiOverlapManager.Section>) },
        { "hkArray<hkaiAabbOverlapManager::Overlap, hkContainerHeapAllocator>", typeof(List<hkaiAabbOverlapManager.Overlap>) },
        { "hkArray<hkaiAabbOverlapManager::Node, hkContainerHeapAllocator>", typeof(List<hkaiAabbOverlapManager.Node>) },
        { "hkArray<hkArray<hkAabb, hkContainerHeapAllocator>, hkContainerHeapAllocator>", typeof(List<List<hkAabb>>) },
        { "hkArray<hkHashSet<hkaiIndex<hkInt32>>, hkContainerHeapAllocator>", typeof(List<hkHashSet<int>>) },
        { "hkArray<hkAabb, hkContainerHeapAllocator>", typeof(List<hkAabb>) },
        { "hkArray<hkRefPtr<hkaiNavMeshInstanceCutter>, hkContainerHeapAllocator>", typeof(List<hkaiNavMeshInstanceCutter?>) },
        { "hkArray<hkRefPtr<hkaiVolume>, hkContainerHeapAllocator>", typeof(List<hkaiVolume?>) },
        { "hkArray<hkaiPath::PathPoint, hkContainerHeapAllocator>", typeof(List<hkaiPath.PathPoint>) },
        { "hkArray<hkReflect::Detail::Opaque, hkContainerHeapAllocator>", typeof(List<IHavokObject>) },
        { "hkArray<hkaiAvoidancePairProperties::PairData, hkContainerHeapAllocator>", typeof(List<hkaiAvoidancePairProperties.PairData>) },
        { "hkArray<hkaiAvoidanceSolver::BoundaryObstacle, hkContainerHeapAllocator>", typeof(List<hkaiAvoidanceSolver.BoundaryObstacle>) },
        { "hkArray<hkaiAvoidanceSolver::SphereObstacle, hkContainerHeapAllocator>", typeof(List<hkaiAvoidanceSolver.SphereObstacle>) },
        { "hkArray<hkaiEdgePath::Edge, hkContainerHeapAllocator>", typeof(List<hkaiEdgePath.Edge>) },
        { "hkArray<hkaiCornerPredictor::UserEdgeTraversal, hkContainerHeapAllocator>", typeof(List<hkaiCornerPredictor.UserEdgeTraversal>) },
        { "hkArray<hkaiSingleCharacterBehavior::RequestedGoalPoint, hkContainerHeapAllocator>", typeof(List<hkaiSingleCharacterBehavior.RequestedGoalPoint>) },
        { "hkArray<hkaiGatePath::PathGate, hkContainerHeapAllocator>", typeof(List<hkaiGatePath.PathGate>) },
        { "hkArray<hkArray<hkVector4f, hkContainerHeapAllocator>, hkContainerHeapAllocator>", typeof(List<List<Vector4>>) },
        { "hkArray<int, hkContainerHeapAllocator>", typeof(List<int>) },
        { "hkArray<hkVector4f, hkContainerHeapAllocator>", typeof(List<Vector4>) },
        { "hkArray<hkaiNavVolumeGenerationSettings::MaterialConstructionInfo, hkContainerHeapAllocator>", typeof(List<hkaiNavVolumeGenerationSettings.MaterialConstructionInfo>) },
        { "hkArray<hkaiNavMeshGenerationUtilsSettings::RegionPruningSettings::RegionConnection, hkContainerHeapAllocator>", typeof(List<hkaiNavMeshGenerationUtilsSettings.RegionPruningSettings.RegionConnection>) },
        { "hkArray<hkaiNavMeshGenerationUtilsSettings::OverrideSettings, hkContainerHeapAllocator>", typeof(List<hkaiNavMeshGenerationUtilsSettings.OverrideSettings>) },
        { "hkArray<hkaiNavMeshGenerationUtilsSettings::MaterialConstructionPair, hkContainerHeapAllocator>", typeof(List<hkaiNavMeshGenerationUtilsSettings.MaterialConstructionPair>) },
        { "hkArray<hkRefPtr<hkaiMaterialPainter>, hkContainerHeapAllocator>", typeof(List<hkaiMaterialPainter?>) },
        { "hkArray<hkRefPtr<hkaiCarver>, hkContainerHeapAllocator>", typeof(List<hkaiCarver?>) },
        { "hkArray<hkArray<hkVector4, hkContainerHeapAllocator>, hkContainerHeapAllocator>", typeof(List<List<Vector4>>) },
        { "hkArray<hkInt32, hkContainerHeapAllocator>", typeof(List<int>) },
        { "hkArray<hkRefPtr<hkGeometry>, hkContainerHeapAllocator>", typeof(List<hkGeometry?>) },
        { "hkArray<hkVector4, hkContainerHeapAllocator>", typeof(List<Vector4>) },
        { "hkArray<hkaiEdgeGeometry::Face, hkContainerHeapAllocator>", typeof(List<hkaiEdgeGeometry.Face>) },
        { "hkArray<hkaiEdgeGeometry::Edge, hkContainerHeapAllocator>", typeof(List<hkaiEdgeGeometry.Edge>) },
        { "hkRelArray<unsigned char>", typeof(List<byte>) },
        { "hkRelArray<hkVector4f>", typeof(List<Vector4>) },
        { "hkRelArray<hkUint8>", typeof(List<byte>) },
        { "hkRelArray<hknpConvexPolytopeShape::Face>", typeof(List<hknpConvexPolytopeShape.Face>) },
        { "hkRelArray<hkVector4>", typeof(List<Vector4>) },
        { "hkRelArray<char>", typeof(List<byte>) },
        { "T[N]<hkHandle<unsigned int, -1>, 2>", typeof(hkHandle<uint>[]) },
        { "T[N]<float, 12>", typeof(float[]) },
        { "T[N]<hkVector4f, 6>", typeof(Vector4[]) },
        { "T[N]<hknpBodyId, 2>", typeof(hknpBodyId[]) },
        { "T[N]<hkHalf16, 3>", typeof(float[]) },
        { "T[N]<hkHalf16, 4>", typeof(float[]) },
        { "T[N]<hknpBodyQuality, 32>", typeof(hknpBodyQuality[]) },
        { "T[N]<hknpLodShapeIndex, 8>", typeof(hknpLodShapeIndex[]) },
        { "T[N]<hkRefPtr<hknpShape>, 8>", typeof(hknpShape?[]) },
        { "T[N]<hknpLodMeshShape::LevelOfDetailInfo, 8>", typeof(hknpLodMeshShape.LevelOfDetailInfo[]) },
        { "T[N]<hkHandle<hkUint32, -1>, 2>", typeof(hkHandle<uint>[]) },
        { "T[N]<hkReal, 12>", typeof(float[]) },
        { "T[N]<hkVector4, 6>", typeof(Vector4[]) },
        { "T[N]<hkVector4, 3>", typeof(Vector4[]) },
        { "T[N]<long long, 10>", typeof(long[]) },
        { "T[N]<unsigned long long, 10>", typeof(ulong[]) },
        { "T[N]<int, 10>", typeof(int[]) },
        { "T[N]<unsigned int, 10>", typeof(uint[]) },
        { "T[N]<short, 10>", typeof(short[]) },
        { "T[N]<unsigned short, 10>", typeof(ushort[]) },
        { "T[N]<signed char, 10>", typeof(sbyte[]) },
        { "T[N]<unsigned char, 10>", typeof(byte[]) },
        { "T[N]<long long, 1>", typeof(long[]) },
        { "T[N]<unsigned long long, 1>", typeof(ulong[]) },
        { "T[N]<int, 1>", typeof(int[]) },
        { "T[N]<short, 1>", typeof(short[]) },
        { "T[N]<unsigned short, 1>", typeof(ushort[]) },
        { "T[N]<signed char, 1>", typeof(sbyte[]) },
        { "T[N]<unsigned char, 1>", typeof(byte[]) },
        { "T[N]<TestComplexRecord, 10>", typeof(TestComplexRecord[]) },
        { "T[N]<hkStringPtr, 10>", typeof(string?[]) },
        { "T[N]<const char*, 10>", typeof(string?[]) },
        { "T[N]<TestComplexRecord, 1>", typeof(TestComplexRecord[]) },
        { "T[N]<hkStringPtr, 1>", typeof(string?[]) },
        { "T[N]<const char*, 1>", typeof(string?[]) },
        { "T[N]<TestSimpleExRecord, 10>", typeof(TestSimpleExRecord[]) },
        { "T[N]<TestSimpleRecord, 10>", typeof(TestSimpleRecord[]) },
        { "T[N]<TestSimpleExRecord, 1>", typeof(TestSimpleExRecord[]) },
        { "T[N]<TestSimpleRecord, 1>", typeof(TestSimpleRecord[]) },
        { "T[N]<hkArray<bool, hkContainerHeapAllocator>, 10>", typeof(List<bool>[]) },
        { "T[N]<hkRefPtr<hkReferencedObject>, 10>", typeof(hkReferencedObject?[]) },
        { "T[N]<hkReal, 10>", typeof(float[]) },
        { "T[N]<float, 10>", typeof(float[]) },
        { "T[N]<double, 10>", typeof(double[]) },
        { "T[N]<hkInt64, 10>", typeof(long[]) },
        { "T[N]<hkUint64, 10>", typeof(ulong[]) },
        { "T[N]<hkInt32, 10>", typeof(int[]) },
        { "T[N]<hkUint32, 10>", typeof(uint[]) },
        { "T[N]<hkInt16, 10>", typeof(short[]) },
        { "T[N]<hkUint16, 10>", typeof(ushort[]) },
        { "T[N]<hkInt8, 10>", typeof(sbyte[]) },
        { "T[N]<hkUint8, 10>", typeof(byte[]) },
        { "T[N]<hkBool, 10>", typeof(bool[]) },
        { "T[N]<bool, 10>", typeof(bool[]) },
        { "T[N]<hkArray<bool, hkContainerHeapAllocator>, 1>", typeof(List<bool>[]) },
        { "T[N]<hkRefPtr<hkReferencedObject>, 1>", typeof(hkReferencedObject?[]) },
        { "T[N]<hkReal, 1>", typeof(float[]) },
        { "T[N]<float, 1>", typeof(float[]) },
        { "T[N]<double, 1>", typeof(double[]) },
        { "T[N]<hkInt64, 1>", typeof(long[]) },
        { "T[N]<hkUint64, 1>", typeof(ulong[]) },
        { "T[N]<hkInt32, 1>", typeof(int[]) },
        { "T[N]<hkInt16, 1>", typeof(short[]) },
        { "T[N]<hkUint16, 1>", typeof(ushort[]) },
        { "T[N]<hkInt8, 1>", typeof(sbyte[]) },
        { "T[N]<hkUint8, 1>", typeof(byte[]) },
        { "T[N]<hkBool, 1>", typeof(bool[]) },
        { "T[N]<bool, 1>", typeof(bool[]) },
        { "T[N]<hkTransformf, 2>", typeof(Matrix4x4[]) },
        { "T[N]<hkEnum<hkp6DofConstraintData::AxisMode, unsigned char>, 6>", typeof(hkp6DofConstraintData.AxisMode[]) },
        { "T[N]<hkpVehicleFrictionStatus::AxisStatus, 2>", typeof(hkpVehicleFrictionStatus.AxisStatus[]) },
        { "T[N]<hkpVehicleFrictionDescription::AxisDescription, 2>", typeof(hkpVehicleFrictionDescription.AxisDescription[]) },
        { "T[N]<hkTransform, 2>", typeof(Matrix4x4[]) },
        { "T[N]<hkpLinFrictionConstraintAtom, 3>", typeof(hkpLinFrictionConstraintAtom[]) },
        { "T[N]<hkpLinLimitConstraintAtom, 3>", typeof(hkpLinLimitConstraintAtom[]) },
        { "T[N]<hkpAngFrictionConstraintAtom, 3>", typeof(hkpAngFrictionConstraintAtom[]) },
        { "T[N]<hkEnum<hkp6DofConstraintData::AxisMode, hkUint8>, 6>", typeof(hkp6DofConstraintData.AxisMode[]) },
        { "T[N]<int, 19>", typeof(int[]) },
        { "T[N]<T*<hkpConstraintMotor>, 3>", typeof(hkpConstraintMotor?[]) },
        { "T[N]<hkVertexFormat::Element, 32>", typeof(hkVertexFormat.Element[]) },
        { "T[N]<int, 32>", typeof(int[]) },
        { "T[N]<hkReal, 2>", typeof(float[]) },
        { "T[N]<hkUlong, 2>", typeof(ulong[]) },
        { "T[N]<hkUint32, 2>", typeof(uint[]) },
        { "T[N]<unsigned int, 2>", typeof(uint[]) },
        { "T[N]<unsigned long long, 2>", typeof(ulong[]) },
        { "T[N]<unsigned int, 26>", typeof(uint[]) },
        { "T[N]<hkUint32, 26>", typeof(uint[]) },
        { "T[N]<hkVector4f, 4>", typeof(Vector4[]) },
        { "T[N]<float, 4>", typeof(float[]) },
        { "T[N]<float, 6>", typeof(float[]) },
        { "T[N]<long long, 4>", typeof(long[]) },
        { "T[N]<hkVector4, 4>", typeof(Vector4[]) },
        { "T[N]<hkReal, 4>", typeof(float[]) },
        { "T[N]<hkReal, 6>", typeof(float[]) },
        { "T[N]<hkInt64, 4>", typeof(long[]) },
        { "T[N]<float, 8>", typeof(float[]) },
        { "T[N]<hkVector4d, 3>", typeof(Vector4[]) },
        { "T[N]<hkVector4f, 3>", typeof(Vector4[]) },
        { "T[N]<unsigned int, 4>", typeof(uint[]) },
        { "T[N]<short, 4>", typeof(short[]) },
        { "T[N]<float, 2>", typeof(float[]) },
        { "T[N]<hkUint32, 4>", typeof(uint[]) },
        { "T[N]<hkPlane, 6>", typeof(hkPlane[]) },
        { "T[N]<hkUintReal, 4>", typeof(uint[]) },
        { "T[N]<hkInt16, 4>", typeof(short[]) },
        { "T[N]<hkFloat16, 12>", typeof(hkFloat16[]) },
        { "T[N]<int, 9>", typeof(int[]) },
        { "T[N]<hkInt32, 3>", typeof(int[]) },
        { "T[N]<hkInt32, 9>", typeof(int[]) },
        { "T[N]<unsigned int, 3>", typeof(uint[]) },
        { "T[N]<hkUint32, 3>", typeof(uint[]) },
        { "T[N]<unsigned char, 32>", typeof(byte[]) },
        { "T[N]<unsigned short, 32>", typeof(ushort[]) },
        { "T[N]<unsigned char, 48>", typeof(byte[]) },
        { "T[N]<unsigned short, 48>", typeof(ushort[]) },
        { "T[N]<unsigned char, 64>", typeof(byte[]) },
        { "T[N]<unsigned short, 64>", typeof(ushort[]) },
        { "T[N]<unsigned short, 80>", typeof(ushort[]) },
        { "T[N]<unsigned short, 96>", typeof(ushort[]) },
        { "T[N]<unsigned short, 112>", typeof(ushort[]) },
        { "T[N]<unsigned short, 128>", typeof(ushort[]) },
        { "T[N]<unsigned short, 8>", typeof(ushort[]) },
        { "T[N]<unsigned short, 15>", typeof(ushort[]) },
        { "T[N]<unsigned short, 5>", typeof(ushort[]) },
        { "T[N]<unsigned char, 8>", typeof(byte[]) },
        { "T[N]<unsigned short, 4>", typeof(ushort[]) },
        { "T[N]<hkVector4f, 16>", typeof(Vector4[]) },
        { "T[N]<unsigned short, 16>", typeof(ushort[]) },
        { "T[N]<float, 16>", typeof(float[]) },
        { "T[N]<unsigned char, 4>", typeof(byte[]) },
        { "T[N]<hkUint8, 2>", typeof(byte[]) },
        { "T[N]<hkUint16, 2>", typeof(ushort[]) },
        { "T[N]<hkUint8, 32>", typeof(byte[]) },
        { "T[N]<hkUint16, 32>", typeof(ushort[]) },
        { "T[N]<hkUint8, 48>", typeof(byte[]) },
        { "T[N]<hkUint16, 48>", typeof(ushort[]) },
        { "T[N]<hkUint8, 64>", typeof(byte[]) },
        { "T[N]<hkUint16, 64>", typeof(ushort[]) },
        { "T[N]<hkUint16, 80>", typeof(ushort[]) },
        { "T[N]<hkUint16, 96>", typeof(ushort[]) },
        { "T[N]<hkUint16, 112>", typeof(ushort[]) },
        { "T[N]<hkUint16, 128>", typeof(ushort[]) },
        { "T[N]<hkPackedVector3, 16>", typeof(hkPackedVector3[]) },
        { "T[N]<hkUint16, 8>", typeof(ushort[]) },
        { "T[N]<hkUint16, 15>", typeof(ushort[]) },
        { "T[N]<hkUint16, 5>", typeof(ushort[]) },
        { "T[N]<hkUint8, 8>", typeof(byte[]) },
        { "T[N]<hkUint16, 4>", typeof(ushort[]) },
        { "T[N]<hclRuntimeConversionInfo::ElementConversion, 4>", typeof(hclRuntimeConversionInfo.ElementConversion[]) },
        { "T[N]<hclRuntimeConversionInfo::SlotConversion, 4>", typeof(hclRuntimeConversionInfo.SlotConversion[]) },
        { "T[N]<hkVector4, 16>", typeof(Vector4[]) },
        { "T[N]<hkUint16, 16>", typeof(ushort[]) },
        { "T[N]<hkReal, 16>", typeof(float[]) },
        { "T[N]<int, 6>", typeof(int[]) },
        { "T[N]<hclBufferLayout::Slot, 4>", typeof(hclBufferLayout.Slot[]) },
        { "T[N]<hclBufferLayout::BufferElement, 4>", typeof(hclBufferLayout.BufferElement[]) },
        { "T[N]<hkUint8, 4>", typeof(byte[]) },
        { "T[N]<hkbRadialSelectorGenerator::GeneratorInfo, 2>", typeof(hkbRadialSelectorGenerator.GeneratorInfo[]) },
        { "T[N]<unsigned char, 3>", typeof(byte[]) },
        { "T[N]<unsigned int, 1>", typeof(uint[]) },
        { "T[N]<unsigned int, 8>", typeof(uint[]) },
        { "T[N]<signed char, 4>", typeof(sbyte[]) },
        { "T[N]<unsigned char, 2>", typeof(byte[]) },
        { "T[N]<hkBool, 3>", typeof(bool[]) },
        { "T[N]<hkBool, 5>", typeof(bool[]) },
        { "T[N]<hkUint8, 3>", typeof(byte[]) },
        { "T[N]<hkbGeneratorSyncInfo::SyncPoint, 2>", typeof(hkbGeneratorSyncInfo.SyncPoint[]) },
        { "T[N]<hkbGeneratorSyncInfo::SyncPoint, 16>", typeof(hkbGeneratorSyncInfo.SyncPoint[]) },
        { "T[N]<hkUint32, 1>", typeof(uint[]) },
        { "T[N]<hkUint32, 8>", typeof(uint[]) },
        { "T[N]<hkInt8, 4>", typeof(sbyte[]) },
        { "T[N]<unsigned short, 3>", typeof(ushort[]) },
        { "T[N]<unsigned short, 2>", typeof(ushort[]) },
        { "T[N]<int, 2>", typeof(int[]) },
        { "T[N]<float, 32>", typeof(float[]) },
        { "T[N]<hkUint16, 3>", typeof(ushort[]) },
        { "T[N]<int, 3>", typeof(int[]) },
        { "T[N]<hkaiIndex<hkUint16>, 2>", typeof(ushort[]) },
        { "T[N]<hkaiIndex<hkInt32>, 2>", typeof(int[]) },
        { "T[N]<hkReal, 32>", typeof(float[]) },
        { "T[N]<hkUint32, 32>", typeof(uint[]) },
        { "T[N]<hkHalf16, 32>", typeof(float[]) },
        { "T[N]<unsigned int, 32>", typeof(uint[]) },
        { "T[N]<T[N]<unsigned int, 26>, 32>", typeof(uint[,]) },
        { "T[N]<T[N]<hkUint32, 26>, 32>", typeof(uint[,]) },
        { "hkArrayView<hknpParticleCollisionPair>", typeof(ArraySegment<hknpParticleCollisionPair>) },
        { "hkArrayView<int>", typeof(ArraySegment<int>) },
        { "hk::ValueArray<hk::FileDialogFilter>", typeof(List<hk.FileDialogFilter>) },
        { "hk::ValueArray<const char*>", typeof(List<string?>) },
        { "hkPropertyBag", typeof(hkPropertyBag) },
        { "hkColorfAlpha", typeof(Vector4) },
        { "hkColorf", typeof(Vector4) },
        { "hkReflect::Any", typeof(object) },
        { "hkVector4f", typeof(Vector4) },
        { "hkVector4", typeof(Vector4) },
        { "hkVector4d", typeof(Vector4) },
        { "hkQuaternion", typeof(Quaternion) },
        { "hkQuaternionf", typeof(Quaternion) },
        { "hkQuaterniond", typeof(Quaternion) },
        { "hkTransformf", typeof(Matrix4x4) },
        { "hkTransform", typeof(Matrix4x4) },
        { "hkRotation", typeof(Matrix3x3) },
        { "hkMatrix4", typeof(Matrix4x4) },
        { "hkMatrix3", typeof(Matrix3x3) },
        { "char[N]<128>", typeof(string) },
        { "char[N]<65>", typeof(string) },
        { "char[N]<1024>", typeof(string) },
        { "char[N]<2>", typeof(string) },
        { "char[N]<41>", typeof(string) },
        { "char[N]<31>", typeof(string) },
        { "char[N]<5>", typeof(string) },
        { "const char*", typeof(string) },
        { "char*", typeof(string) },
        { "char[N]<9>", typeof(string) },
        { "hkReflect::Detail::StringOut", typeof(string) },
        { "hkStringPtr", typeof(string) },
        { "hkStringBuf", typeof(string) },
        { "hkStringView", typeof(string) },
        { "hkFloat64Be", typeof(double) },
        { "hkFloat64Le", typeof(double) },
        { "hkFloat32Be", typeof(float) },
        { "hkFloat32Le", typeof(float) },
        { "hkHalf16Be", typeof(float) },
        { "hkHalf16Le", typeof(float) },
        { "double", typeof(double) },
        { "float", typeof(float) },
        { "hkHalf32", typeof(float) },
        { "hkHalf16", typeof(float) },
        { "hkReal", typeof(float) },
        { "hkSimdReal", typeof(Vector128<float>) },
        { "hkSimdFloat32", typeof(Vector128<float>) },
        { "hkSimdDouble64", typeof(Vector128<double>) },
        { "bool", typeof(bool) },
        { "hkBool32Be", typeof(bool) },
        { "hkBool32Le", typeof(bool) },
        { "hkBool8Be", typeof(bool) },
        { "hkBool8Le", typeof(bool) },
        { "hkBool", typeof(bool) },
    };
}
;
