using System.Collections.Generic;
using SoapstoneLib.Proto;

#pragma warning disable CS1591 // Missing XML comment for publicly visible type or member

// This file is autogenerated by TestConsoleApp.
// DO NOT MANUALLY EDIT THIS FILE.

namespace SoapstoneLib
{
    public static partial class SoulsFmg
    {
        /// <summary>
        /// The language categorization for any FMG in any supported game.
        /// 
        /// This corresponds to a language folder in the game files.
        /// 
        /// Do not rely on the integer value of this enum, as it may change over time. Only use the name.
        /// </summary>
        public enum FmgLanguage
        {
            Unspecified,
            Arabic,
            AsiaEnglish,
            BrazilPortuguese,
            BritishEnglish,
            Danish,
            Dutch,
            English,
            Finnish,
            French,
            German,
            Italian,
            Japanese,
            Korean,
            Norwegian,
            Polish,
            PortugalPortuguese,
            Russian,
            SimplifiedChinese,
            SpainSpanish,
            Spanish,
            Swedish,
            Thai,
            TraditionalChinese,
            Turkish,
        }

        /// <summary>
        /// Type specifier for any item or menu FMG in any supported game.
        /// 
        /// Each FMG file within a game has a unique type, within any given language.
        /// 
        /// Do not rely on the integer value of this enum, as it may change over time. Only use the name.
        /// </summary>
        public enum FmgType
        {
            Unspecified,
            AccessoryCaption,
            AccessoryCaption_DLC1,
            AccessoryCaption_DLC2,
            AccessoryCaption_Patch,
            AccessoryInfo,
            AccessoryInfo_DLC1,
            AccessoryInfo_DLC2,
            AccessoryInfo_Patch,
            AccessoryName,
            AccessoryName_DLC1,
            AccessoryName_DLC2,
            AccessoryName_Patch,
            ActionButtonText,
            ActionButtonText_DLC1,
            ActionButtonText_DLC2,
            AntiqueCaption,
            AntiqueInfo,
            AntiqueName,
            ArchiveContent,
            ArchiveName,
            ArtsCaption,
            ArtsCaption_DLC1,
            ArtsCaption_DLC2,
            ArtsInfo,
            ArtsName,
            ArtsName_DLC1,
            ArtsName_DLC2,
            AttachEffectInfo,
            AttachEffectName,
            BloodMsg,
            BloodMsg_DLC1,
            BloodMsg_DLC2,
            BloodMsg_Patch,
            BloodMsgConjunction,
            BloodMsgSentence,
            BloodMsgWord,
            BloodMsgWordCategory,
            BonfireMenu,
            BonfireName,
            BoosterInfo,
            BoosterName,
            CauseOfDeath,
            CharaMaking,
            CharaName,
            Dialogues,
            Dialogues_Patch,
            DS2Common,
            DS2Shop,
            EventText,
            EventText_DLC1,
            EventText_DLC2,
            EventText_Patch,
            EventTextForMap,
            EventTextForMap_DLC1,
            EventTextForMap_DLC2,
            EventTextForTalk,
            EventTextForTalk_DLC1,
            EventTextForTalk_DLC2,
            FCSInfo,
            FCSName,
            FeatureCaption,
            FeatureInfo,
            FeatureName,
            GameDialogues,
            GameDialogues_DLC1,
            GameDialogues_DLC2,
            GameKeyGuide,
            GameKeyGuide_DLC1,
            GameKeyGuide_DLC2,
            GameLineHelp,
            GameLineHelp_DLC1,
            GameLineHelp_DLC2,
            GameMenuText,
            GameMenuText_DLC1,
            GameMenuText_DLC2,
            GameSystemMessagePS4,
            GameSystemMessagePS4_DLC1,
            GameSystemMessagePS4_DLC2,
            GameSystemMessageWindows,
            GameSystemMessageWindows_DLC1,
            GameSystemMessageWindows_DLC2,
            GameSystemMessageXboxOne,
            GameSystemMessageXboxOne_DLC1,
            GameSystemMessageXboxOne_DLC2,
            GemCaption,
            GemCaption_DLC1,
            GemCaption_DLC2,
            GemEffect,
            GemEffect_DLC1,
            GemEffect_DLC2,
            GemInfo,
            GemInfo_DLC1,
            GemInfo_DLC2,
            GemName,
            GemName_DLC1,
            GemName_DLC2,
            GemPrefix,
            GeneratorInfo,
            GeneratorName,
            GoodsCaption,
            GoodsCaption_DLC1,
            GoodsCaption_DLC2,
            GoodsCaption_Patch,
            GoodsDialog,
            GoodsDialog_DLC1,
            GoodsDialog_DLC2,
            GoodsInfo,
            GoodsInfo_DLC1,
            GoodsInfo_DLC2,
            GoodsInfo_Patch,
            GoodsInfo2,
            GoodsInfo2_DLC1,
            GoodsInfo2_DLC2,
            GoodsName,
            GoodsName_DLC1,
            GoodsName_DLC2,
            GoodsName_Patch,
            IconHelp,
            InGameMenu,
            InGameSystem,
            ItemCaption,
            ItemInfo,
            ItemName,
            KeyGuide,
            KeyGuide_Patch,
            LineHelp,
            LineHelp_Patch,
            LoadingText,
            LoadingText_DLC1,
            LoadingText_DLC2,
            LoadingTitle,
            LoadingTitle_DLC1,
            LoadingTitle_DLC2,
            MagicCaption,
            MagicCaption_DLC1,
            MagicCaption_DLC2,
            MagicCaption_Patch,
            MagicInfo,
            MagicInfo_DLC1,
            MagicInfo_DLC2,
            MagicName,
            MagicName_DLC1,
            MagicName_DLC2,
            MagicName_Patch,
            MenuContext,
            MenuGeneralText,
            MenuGeneralText_Patch,
            MenuOther,
            MenuOther_Patch,
            MissionName,
            MissionObjective,
            MissionPlaceName,
            MissionSummary,
            MovieSubtitle,
            MovieSubtitle_DLC1,
            MovieSubtitle_DLC2,
            NetworkMessage,
            NetworkMessage_DLC1,
            NetworkMessage_DLC2,
            NpcMenu,
            NpcName,
            NpcName_DLC1,
            NpcName_DLC2,
            NpcName_Patch,
            PermanentBuffCaption,
            PermanentBuffInfo,
            PermanentBuffName,
            PersonalScenarioBody,
            PersonalScenarioObjective,
            PersonalScenarioTitle,
            PlaceName,
            PlaceName_DLC1,
            PlaceName_DLC2,
            PlaceName_Patch,
            PluralSelect,
            Prologue,
            ProtectorCaption,
            ProtectorCaption_DLC1,
            ProtectorCaption_DLC2,
            ProtectorCaption_Patch,
            ProtectorInfo,
            ProtectorInfo_DLC1,
            ProtectorInfo_DLC2,
            ProtectorInfo_Patch,
            ProtectorName,
            ProtectorName_DLC1,
            ProtectorName_DLC2,
            ProtectorName_Patch,
            RankerProfile,
            Skills,
            SpEffectCaption,
            SpEffectInfo,
            SpEffectName,
            StaffRoll,
            SystemMessageDC,
            SystemMessageWindows,
            SystemMessageWindows_Patch,
            SystemTagsWindows,
            TalkMsg,
            TalkMsg_DLC1,
            TalkMsg_DLC2,
            TalkMsg_Patch,
            TalkMsgFemalePCAlt,
            TalkMsgFemalePCAlt_DLC1,
            TalkMsgFemalePCAlt_DLC2,
            TextDisplayTagList,
            TextEmbedImageNameWindows,
            TitleFlow,
            TitleMenu,
            TosWindows,
            TutorialBody,
            TutorialBody_DLC1,
            TutorialBody_DLC2,
            TutorialTitle,
            TutorialTitle_DLC1,
            TutorialTitle_DLC2,
            WeaponCaption,
            WeaponCaption_DLC1,
            WeaponCaption_DLC2,
            WeaponCaption_Patch,
            WeaponEffect,
            WeaponEffect_DLC1,
            WeaponEffect_DLC2,
            WeaponInfo,
            WeaponInfo_DLC1,
            WeaponInfo_DLC2,
            WeaponInfo_Patch,
            WeaponName,
            WeaponName_DLC1,
            WeaponName_DLC2,
            WeaponName_Patch,
            WeaponType,
        }

        internal static bool TryGetFmgGameInfo(FromSoftGame game, out FmgGameInfo info)
        {
            if (fmgGames == null)
            {
                fmgGames = MakeFmgGames();
            }
            return fmgGames.TryGetValue(game, out info);
        }

        // Lazily initialize this to keep things lightweight if FMG is not needed.
        // Not synchronizing initialization should be fine.
        private static Dictionary<FromSoftGame, FmgGameInfo> fmgGames;
        private static Dictionary<FromSoftGame, FmgGameInfo> MakeFmgGames() => new()
        {
            [FromSoftGame.DemonsSouls] = new FmgGameInfo
            {
                ByType = new()
                {
                    [FmgType.AccessoryCaption] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.AccessoryCaption, FmgType.AccessoryCaption, "アクセサリうんちく", 27),
                    [FmgType.AccessoryInfo] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.AccessoryInfo, FmgType.AccessoryInfo, "アクセサリ説明", 23),
                    [FmgType.AccessoryName] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.AccessoryName, FmgType.AccessoryName, "アクセサリ名", 13),
                    [FmgType.BloodMsg] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Menu, FmgType.BloodMsg, FmgType.BloodMsg, "血文字", 2),
                    [FmgType.Dialogues] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Menu, FmgType.Dialogues, FmgType.Dialogues, "ダイアログ", 78),
                    [FmgType.EventText] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Menu, FmgType.EventText, FmgType.EventText, "イベントテキスト", 30),
                    [FmgType.FeatureCaption] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.FeatureCaption, FmgType.FeatureCaption, "特徴うんちく", 17),
                    [FmgType.FeatureInfo] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.FeatureInfo, FmgType.FeatureInfo, "特徴説明", 16),
                    [FmgType.FeatureName] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.FeatureName, FmgType.FeatureName, "特徴名", 15),
                    [FmgType.GoodsCaption] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.GoodsCaption, FmgType.GoodsCaption, "アイテムうんちく", 24),
                    [FmgType.GoodsInfo] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.GoodsInfo, FmgType.GoodsInfo, "アイテム説明", 20),
                    [FmgType.GoodsName] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.GoodsName, FmgType.GoodsName, "アイテム名", 10),
                    [FmgType.InGameMenu] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Menu, FmgType.InGameMenu, FmgType.InGameMenu, "インゲームメニュー", 70),
                    [FmgType.KeyGuide] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Menu, FmgType.KeyGuide, FmgType.KeyGuide, "キーガイド", 79),
                    [FmgType.LineHelp] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Menu, FmgType.LineHelp, FmgType.LineHelp, "一行ヘルプ", 80),
                    [FmgType.MagicCaption] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.MagicCaption, FmgType.MagicCaption, "魔法うんちく", 29),
                    [FmgType.MagicInfo] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.MagicInfo, FmgType.MagicInfo, "魔法説明", 28),
                    [FmgType.MagicName] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.MagicName, FmgType.MagicName, "魔法名", 14),
                    [FmgType.MenuContext] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Menu, FmgType.MenuContext, FmgType.MenuContext, "項目ヘルプ", 81),
                    [FmgType.MenuGeneralText] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Menu, FmgType.MenuGeneralText, FmgType.MenuGeneralText, "メニュー共通テキスト", 76),
                    [FmgType.MenuOther] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Menu, FmgType.MenuOther, FmgType.MenuOther, "メニューその他", 77),
                    [FmgType.MovieSubtitle] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Menu, FmgType.MovieSubtitle, FmgType.MovieSubtitle, "ムービー字幕", 3),
                    [FmgType.NpcName] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.NpcName, FmgType.NpcName, "NPC名", 18),
                    [FmgType.PlaceName] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.PlaceName, FmgType.PlaceName, "地名", 19),
                    [FmgType.ProtectorCaption] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.ProtectorCaption, FmgType.ProtectorCaption, "防具うんちく", 26),
                    [FmgType.ProtectorInfo] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.ProtectorInfo, FmgType.ProtectorInfo, "防具説明", 22),
                    [FmgType.ProtectorName] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.ProtectorName, FmgType.ProtectorName, "防具名", 12),
                    [FmgType.TalkMsg] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Menu, FmgType.TalkMsg, FmgType.TalkMsg, "会話", 1),
                    [FmgType.TextDisplayTagList] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Menu, FmgType.TextDisplayTagList, FmgType.TextDisplayTagList, "テキスト表示用タグ一覧", 90),
                    [FmgType.WeaponCaption] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.WeaponCaption, FmgType.WeaponCaption, "武器うんちく", 25),
                    [FmgType.WeaponInfo] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.WeaponInfo, FmgType.WeaponInfo, "武器説明", 21),
                    [FmgType.WeaponName] = new FmgKeyInfo(FromSoftGame.DemonsSouls, FmgCategory.Item, FmgType.WeaponName, FmgType.WeaponName, "武器名", 11),
                },
                Overrides = new()
                {

                },
                ByFmgName = new()
                {
                    ["NPC名"] = new List<FmgType> { FmgType.NpcName },
                    ["アイテムうんちく"] = new List<FmgType> { FmgType.GoodsCaption },
                    ["アイテム名"] = new List<FmgType> { FmgType.GoodsName },
                    ["アイテム説明"] = new List<FmgType> { FmgType.GoodsInfo },
                    ["アクセサリうんちく"] = new List<FmgType> { FmgType.AccessoryCaption },
                    ["アクセサリ名"] = new List<FmgType> { FmgType.AccessoryName },
                    ["アクセサリ説明"] = new List<FmgType> { FmgType.AccessoryInfo },
                    ["イベントテキスト"] = new List<FmgType> { FmgType.EventText },
                    ["インゲームメニュー"] = new List<FmgType> { FmgType.InGameMenu },
                    ["キーガイド"] = new List<FmgType> { FmgType.KeyGuide },
                    ["ダイアログ"] = new List<FmgType> { FmgType.Dialogues },
                    ["テキスト表示用タグ一覧"] = new List<FmgType> { FmgType.TextDisplayTagList },
                    ["ムービー字幕"] = new List<FmgType> { FmgType.MovieSubtitle },
                    ["メニューその他"] = new List<FmgType> { FmgType.MenuOther },
                    ["メニュー共通テキスト"] = new List<FmgType> { FmgType.MenuGeneralText },
                    ["一行ヘルプ"] = new List<FmgType> { FmgType.LineHelp },
                    ["会話"] = new List<FmgType> { FmgType.TalkMsg },
                    ["地名"] = new List<FmgType> { FmgType.PlaceName },
                    ["武器うんちく"] = new List<FmgType> { FmgType.WeaponCaption },
                    ["武器名"] = new List<FmgType> { FmgType.WeaponName },
                    ["武器説明"] = new List<FmgType> { FmgType.WeaponInfo },
                    ["特徴うんちく"] = new List<FmgType> { FmgType.FeatureCaption },
                    ["特徴名"] = new List<FmgType> { FmgType.FeatureName },
                    ["特徴説明"] = new List<FmgType> { FmgType.FeatureInfo },
                    ["血文字"] = new List<FmgType> { FmgType.BloodMsg },
                    ["防具うんちく"] = new List<FmgType> { FmgType.ProtectorCaption },
                    ["防具名"] = new List<FmgType> { FmgType.ProtectorName },
                    ["防具説明"] = new List<FmgType> { FmgType.ProtectorInfo },
                    ["項目ヘルプ"] = new List<FmgType> { FmgType.MenuContext },
                    ["魔法うんちく"] = new List<FmgType> { FmgType.MagicCaption },
                    ["魔法名"] = new List<FmgType> { FmgType.MagicName },
                    ["魔法説明"] = new List<FmgType> { FmgType.MagicInfo },
                },
                ByBinderID = new()
                {
                    [1] = new List<FmgType> { FmgType.TalkMsg },
                    [2] = new List<FmgType> { FmgType.BloodMsg },
                    [3] = new List<FmgType> { FmgType.MovieSubtitle },
                    [10] = new List<FmgType> { FmgType.GoodsName },
                    [11] = new List<FmgType> { FmgType.WeaponName },
                    [12] = new List<FmgType> { FmgType.ProtectorName },
                    [13] = new List<FmgType> { FmgType.AccessoryName },
                    [14] = new List<FmgType> { FmgType.MagicName },
                    [15] = new List<FmgType> { FmgType.FeatureName },
                    [16] = new List<FmgType> { FmgType.FeatureInfo },
                    [17] = new List<FmgType> { FmgType.FeatureCaption },
                    [18] = new List<FmgType> { FmgType.NpcName },
                    [19] = new List<FmgType> { FmgType.PlaceName },
                    [20] = new List<FmgType> { FmgType.GoodsInfo },
                    [21] = new List<FmgType> { FmgType.WeaponInfo },
                    [22] = new List<FmgType> { FmgType.ProtectorInfo },
                    [23] = new List<FmgType> { FmgType.AccessoryInfo },
                    [24] = new List<FmgType> { FmgType.GoodsCaption },
                    [25] = new List<FmgType> { FmgType.WeaponCaption },
                    [26] = new List<FmgType> { FmgType.ProtectorCaption },
                    [27] = new List<FmgType> { FmgType.AccessoryCaption },
                    [28] = new List<FmgType> { FmgType.MagicInfo },
                    [29] = new List<FmgType> { FmgType.MagicCaption },
                    [30] = new List<FmgType> { FmgType.EventText },
                    [70] = new List<FmgType> { FmgType.InGameMenu },
                    [76] = new List<FmgType> { FmgType.MenuGeneralText },
                    [77] = new List<FmgType> { FmgType.MenuOther },
                    [78] = new List<FmgType> { FmgType.Dialogues },
                    [79] = new List<FmgType> { FmgType.KeyGuide },
                    [80] = new List<FmgType> { FmgType.LineHelp },
                    [81] = new List<FmgType> { FmgType.MenuContext },
                    [90] = new List<FmgType> { FmgType.TextDisplayTagList },
                },
                ToLanguageEnum = new()
                {
                    ["asia_english"] = FmgLanguage.AsiaEnglish,
                    ["french"] = FmgLanguage.French,
                    ["german"] = FmgLanguage.German,
                    ["italian"] = FmgLanguage.Italian,
                    ["japanese"] = FmgLanguage.Japanese,
                    ["korean"] = FmgLanguage.Korean,
                    ["na_english"] = FmgLanguage.English,
                    ["spanish"] = FmgLanguage.SpainSpanish,
                    ["tchinese"] = FmgLanguage.TraditionalChinese,
                    ["uk_english"] = FmgLanguage.BritishEnglish,
                },
                FromLanguageEnum = new()
                {
                    [FmgLanguage.AsiaEnglish] = "asia_english",
                    [FmgLanguage.French] = "french",
                    [FmgLanguage.German] = "german",
                    [FmgLanguage.Italian] = "italian",
                    [FmgLanguage.Japanese] = "japanese",
                    [FmgLanguage.Korean] = "korean",
                    [FmgLanguage.English] = "na_english",
                    [FmgLanguage.SpainSpanish] = "spanish",
                    [FmgLanguage.TraditionalChinese] = "tchinese",
                    [FmgLanguage.BritishEnglish] = "uk_english",
                },
            },
            [FromSoftGame.DarkSoulsPtde] = new FmgGameInfo
            {
                ByType = new()
                {
                    [FmgType.AccessoryCaption] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.AccessoryCaption, FmgType.AccessoryCaption, "アクセサリうんちく", 27),
                    [FmgType.AccessoryCaption_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.AccessoryCaption_Patch, FmgType.AccessoryCaption, "アクセサリうんちくパッチ", 109),
                    [FmgType.AccessoryInfo] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.AccessoryInfo, FmgType.AccessoryInfo, "アクセサリ説明", 23),
                    [FmgType.AccessoryInfo_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.AccessoryInfo_Patch, FmgType.AccessoryInfo, "アクセサリ説明パッチ", 112),
                    [FmgType.AccessoryName] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.AccessoryName, FmgType.AccessoryName, "アクセサリ名", 13),
                    [FmgType.AccessoryName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.AccessoryName_Patch, FmgType.AccessoryName, "アクセサリ名パッチ", 113),
                    [FmgType.BloodMsg] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.BloodMsg, FmgType.BloodMsg, "血文字", 2),
                    [FmgType.BloodMsg_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.BloodMsg_Patch, FmgType.BloodMsg, "血文字パッチ", 107),
                    [FmgType.Dialogues] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.Dialogues, FmgType.Dialogues, "ダイアログ", 78),
                    [FmgType.Dialogues_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.Dialogues_Patch, FmgType.Dialogues, "ダイアログパッチ", 102),
                    [FmgType.EventText] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.EventText, FmgType.EventText, "イベントテキスト", 30),
                    [FmgType.EventText_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.EventText_Patch, FmgType.EventText, "イベントテキストパッチ", 101),
                    [FmgType.FeatureCaption] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.FeatureCaption, FmgType.FeatureCaption, "特徴うんちく", 17),
                    [FmgType.FeatureInfo] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.FeatureInfo, FmgType.FeatureInfo, "特徴説明", 16),
                    [FmgType.FeatureName] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.FeatureName, FmgType.FeatureName, "特徴名", 15),
                    [FmgType.GoodsCaption] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.GoodsCaption, FmgType.GoodsCaption, "アイテムうんちく", 24),
                    [FmgType.GoodsCaption_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.GoodsCaption_Patch, FmgType.GoodsCaption, "アイテムうんちくパッチ", 100),
                    [FmgType.GoodsInfo] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.GoodsInfo, FmgType.GoodsInfo, "アイテム説明", 20),
                    [FmgType.GoodsInfo_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.GoodsInfo_Patch, FmgType.GoodsInfo, "アイテム説明パッチ", 110),
                    [FmgType.GoodsName] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.GoodsName, FmgType.GoodsName, "アイテム名", 10),
                    [FmgType.GoodsName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.GoodsName_Patch, FmgType.GoodsName, "アイテム名パッチ", 111),
                    [FmgType.InGameMenu] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.InGameMenu, FmgType.InGameMenu, "インゲームメニュー", 70),
                    [FmgType.KeyGuide] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.KeyGuide, FmgType.KeyGuide, "キーガイド", 79),
                    [FmgType.KeyGuide_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.KeyGuide_Patch, FmgType.KeyGuide, "キーガイドパッチ", 122),
                    [FmgType.LineHelp] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.LineHelp, FmgType.LineHelp, "一行ヘルプ", 80),
                    [FmgType.LineHelp_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.LineHelp_Patch, FmgType.LineHelp, "一行ヘルプパッチ", 121),
                    [FmgType.MagicCaption] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.MagicCaption, FmgType.MagicCaption, "魔法うんちく", 29),
                    [FmgType.MagicCaption_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.MagicCaption_Patch, FmgType.MagicCaption, "魔法うんちくパッチ", 105),
                    [FmgType.MagicInfo] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.MagicInfo, FmgType.MagicInfo, "魔法説明", 28),
                    [FmgType.MagicName] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.MagicName, FmgType.MagicName, "魔法名", 14),
                    [FmgType.MagicName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.MagicName_Patch, FmgType.MagicName, "魔法名パッチ", 118),
                    [FmgType.MenuContext] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.MenuContext, FmgType.MenuContext, "項目ヘルプ", 81),
                    [FmgType.MenuGeneralText] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.MenuGeneralText, FmgType.MenuGeneralText, "メニュー共通テキスト", 76),
                    [FmgType.MenuGeneralText_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.MenuGeneralText_Patch, FmgType.MenuGeneralText, "メニュー共通テキストパッチ", 124),
                    [FmgType.MenuOther] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.MenuOther, FmgType.MenuOther, "メニューその他", 77),
                    [FmgType.MenuOther_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.MenuOther_Patch, FmgType.MenuOther, "メニューその他パッチ", 123),
                    [FmgType.MovieSubtitle] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.MovieSubtitle, FmgType.MovieSubtitle, "ムービー字幕", 3),
                    [FmgType.NpcName] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.NpcName, FmgType.NpcName, "NPC名", 18),
                    [FmgType.NpcName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.NpcName_Patch, FmgType.NpcName, "NPC名パッチ", 119),
                    [FmgType.PlaceName] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.PlaceName, FmgType.PlaceName, "地名", 19),
                    [FmgType.PlaceName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.PlaceName_Patch, FmgType.PlaceName, "地名パッチ", 120),
                    [FmgType.ProtectorCaption] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.ProtectorCaption, FmgType.ProtectorCaption, "防具うんちく", 26),
                    [FmgType.ProtectorCaption_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.ProtectorCaption_Patch, FmgType.ProtectorCaption, "防具うんちくパッチ", 108),
                    [FmgType.ProtectorInfo] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.ProtectorInfo, FmgType.ProtectorInfo, "防具説明", 22),
                    [FmgType.ProtectorInfo_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.ProtectorInfo_Patch, FmgType.ProtectorInfo, "防具説明パッチ", 116),
                    [FmgType.ProtectorName] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.ProtectorName, FmgType.ProtectorName, "防具名", 12),
                    [FmgType.ProtectorName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.ProtectorName_Patch, FmgType.ProtectorName, "防具名パッチ", 117),
                    [FmgType.SystemMessageWindows] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.SystemMessageWindows, FmgType.SystemMessageWindows, "システムメッセージ_win32", 92),
                    [FmgType.SystemMessageWindows_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.SystemMessageWindows_Patch, FmgType.SystemMessageWindows, "システムメッセージ_win32パッチ", 103),
                    [FmgType.SystemTagsWindows] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.SystemTagsWindows, FmgType.SystemTagsWindows, "機種別タグ_win32", 91),
                    [FmgType.TalkMsg] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.TalkMsg, FmgType.TalkMsg, "会話", 1),
                    [FmgType.TalkMsg_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.TalkMsg_Patch, FmgType.TalkMsg, "会話パッチ", 104),
                    [FmgType.TextDisplayTagList] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.TextDisplayTagList, FmgType.TextDisplayTagList, "テキスト表示用タグ一覧", 90),
                    [FmgType.WeaponCaption] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.WeaponCaption, FmgType.WeaponCaption, "武器うんちく", 25),
                    [FmgType.WeaponCaption_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.WeaponCaption_Patch, FmgType.WeaponCaption, "武器うんちくパッチ", 106),
                    [FmgType.WeaponInfo] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.WeaponInfo, FmgType.WeaponInfo, "武器説明", 21),
                    [FmgType.WeaponInfo_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.WeaponInfo_Patch, FmgType.WeaponInfo, "武器説明パッチ", 114),
                    [FmgType.WeaponName] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Item, FmgType.WeaponName, FmgType.WeaponName, "武器名", 11),
                    [FmgType.WeaponName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsPtde, FmgCategory.Menu, FmgType.WeaponName_Patch, FmgType.WeaponName, "武器名パッチ", 115),
                },
                Overrides = new()
                {
                    [FmgType.AccessoryCaption] = new List<FmgType> { FmgType.AccessoryCaption_Patch },
                    [FmgType.AccessoryInfo] = new List<FmgType> { FmgType.AccessoryInfo_Patch },
                    [FmgType.AccessoryName] = new List<FmgType> { FmgType.AccessoryName_Patch },
                    [FmgType.BloodMsg] = new List<FmgType> { FmgType.BloodMsg_Patch },
                    [FmgType.Dialogues] = new List<FmgType> { FmgType.Dialogues_Patch },
                    [FmgType.EventText] = new List<FmgType> { FmgType.EventText_Patch },
                    [FmgType.GoodsCaption] = new List<FmgType> { FmgType.GoodsCaption_Patch },
                    [FmgType.GoodsInfo] = new List<FmgType> { FmgType.GoodsInfo_Patch },
                    [FmgType.GoodsName] = new List<FmgType> { FmgType.GoodsName_Patch },
                    [FmgType.KeyGuide] = new List<FmgType> { FmgType.KeyGuide_Patch },
                    [FmgType.LineHelp] = new List<FmgType> { FmgType.LineHelp_Patch },
                    [FmgType.MagicCaption] = new List<FmgType> { FmgType.MagicCaption_Patch },
                    [FmgType.MagicName] = new List<FmgType> { FmgType.MagicName_Patch },
                    [FmgType.MenuGeneralText] = new List<FmgType> { FmgType.MenuGeneralText_Patch },
                    [FmgType.MenuOther] = new List<FmgType> { FmgType.MenuOther_Patch },
                    [FmgType.NpcName] = new List<FmgType> { FmgType.NpcName_Patch },
                    [FmgType.PlaceName] = new List<FmgType> { FmgType.PlaceName_Patch },
                    [FmgType.ProtectorCaption] = new List<FmgType> { FmgType.ProtectorCaption_Patch },
                    [FmgType.ProtectorInfo] = new List<FmgType> { FmgType.ProtectorInfo_Patch },
                    [FmgType.ProtectorName] = new List<FmgType> { FmgType.ProtectorName_Patch },
                    [FmgType.SystemMessageWindows] = new List<FmgType> { FmgType.SystemMessageWindows_Patch },
                    [FmgType.TalkMsg] = new List<FmgType> { FmgType.TalkMsg_Patch },
                    [FmgType.WeaponCaption] = new List<FmgType> { FmgType.WeaponCaption_Patch },
                    [FmgType.WeaponInfo] = new List<FmgType> { FmgType.WeaponInfo_Patch },
                    [FmgType.WeaponName] = new List<FmgType> { FmgType.WeaponName_Patch },
                },
                ByFmgName = new()
                {
                    ["NPC名"] = new List<FmgType> { FmgType.NpcName },
                    ["NPC名パッチ"] = new List<FmgType> { FmgType.NpcName_Patch },
                    ["アイテムうんちく"] = new List<FmgType> { FmgType.GoodsCaption },
                    ["アイテムうんちくパッチ"] = new List<FmgType> { FmgType.GoodsCaption_Patch },
                    ["アイテム名"] = new List<FmgType> { FmgType.GoodsName },
                    ["アイテム名パッチ"] = new List<FmgType> { FmgType.GoodsName_Patch },
                    ["アイテム説明"] = new List<FmgType> { FmgType.GoodsInfo },
                    ["アイテム説明パッチ"] = new List<FmgType> { FmgType.GoodsInfo_Patch },
                    ["アクセサリうんちく"] = new List<FmgType> { FmgType.AccessoryCaption },
                    ["アクセサリうんちくパッチ"] = new List<FmgType> { FmgType.AccessoryCaption_Patch },
                    ["アクセサリ名"] = new List<FmgType> { FmgType.AccessoryName },
                    ["アクセサリ名パッチ"] = new List<FmgType> { FmgType.AccessoryName_Patch },
                    ["アクセサリ説明"] = new List<FmgType> { FmgType.AccessoryInfo },
                    ["アクセサリ説明パッチ"] = new List<FmgType> { FmgType.AccessoryInfo_Patch },
                    ["イベントテキスト"] = new List<FmgType> { FmgType.EventText },
                    ["イベントテキストパッチ"] = new List<FmgType> { FmgType.EventText_Patch },
                    ["インゲームメニュー"] = new List<FmgType> { FmgType.InGameMenu },
                    ["キーガイド"] = new List<FmgType> { FmgType.KeyGuide },
                    ["キーガイドパッチ"] = new List<FmgType> { FmgType.KeyGuide_Patch },
                    ["システムメッセージ_win32"] = new List<FmgType> { FmgType.SystemMessageWindows },
                    ["システムメッセージ_win32パッチ"] = new List<FmgType> { FmgType.SystemMessageWindows_Patch },
                    ["ダイアログ"] = new List<FmgType> { FmgType.Dialogues },
                    ["ダイアログパッチ"] = new List<FmgType> { FmgType.Dialogues_Patch },
                    ["テキスト表示用タグ一覧"] = new List<FmgType> { FmgType.TextDisplayTagList },
                    ["ムービー字幕"] = new List<FmgType> { FmgType.MovieSubtitle },
                    ["メニューその他"] = new List<FmgType> { FmgType.MenuOther },
                    ["メニューその他パッチ"] = new List<FmgType> { FmgType.MenuOther_Patch },
                    ["メニュー共通テキスト"] = new List<FmgType> { FmgType.MenuGeneralText },
                    ["メニュー共通テキストパッチ"] = new List<FmgType> { FmgType.MenuGeneralText_Patch },
                    ["一行ヘルプ"] = new List<FmgType> { FmgType.LineHelp },
                    ["一行ヘルプパッチ"] = new List<FmgType> { FmgType.LineHelp_Patch },
                    ["会話"] = new List<FmgType> { FmgType.TalkMsg },
                    ["会話パッチ"] = new List<FmgType> { FmgType.TalkMsg_Patch },
                    ["地名"] = new List<FmgType> { FmgType.PlaceName },
                    ["地名パッチ"] = new List<FmgType> { FmgType.PlaceName_Patch },
                    ["機種別タグ_win32"] = new List<FmgType> { FmgType.SystemTagsWindows },
                    ["武器うんちく"] = new List<FmgType> { FmgType.WeaponCaption },
                    ["武器うんちくパッチ"] = new List<FmgType> { FmgType.WeaponCaption_Patch },
                    ["武器名"] = new List<FmgType> { FmgType.WeaponName },
                    ["武器名パッチ"] = new List<FmgType> { FmgType.WeaponName_Patch },
                    ["武器説明"] = new List<FmgType> { FmgType.WeaponInfo },
                    ["武器説明パッチ"] = new List<FmgType> { FmgType.WeaponInfo_Patch },
                    ["特徴うんちく"] = new List<FmgType> { FmgType.FeatureCaption },
                    ["特徴名"] = new List<FmgType> { FmgType.FeatureName },
                    ["特徴説明"] = new List<FmgType> { FmgType.FeatureInfo },
                    ["血文字"] = new List<FmgType> { FmgType.BloodMsg },
                    ["血文字パッチ"] = new List<FmgType> { FmgType.BloodMsg_Patch },
                    ["防具うんちく"] = new List<FmgType> { FmgType.ProtectorCaption },
                    ["防具うんちくパッチ"] = new List<FmgType> { FmgType.ProtectorCaption_Patch },
                    ["防具名"] = new List<FmgType> { FmgType.ProtectorName },
                    ["防具名パッチ"] = new List<FmgType> { FmgType.ProtectorName_Patch },
                    ["防具説明"] = new List<FmgType> { FmgType.ProtectorInfo },
                    ["防具説明パッチ"] = new List<FmgType> { FmgType.ProtectorInfo_Patch },
                    ["項目ヘルプ"] = new List<FmgType> { FmgType.MenuContext },
                    ["魔法うんちく"] = new List<FmgType> { FmgType.MagicCaption },
                    ["魔法うんちくパッチ"] = new List<FmgType> { FmgType.MagicCaption_Patch },
                    ["魔法名"] = new List<FmgType> { FmgType.MagicName },
                    ["魔法名パッチ"] = new List<FmgType> { FmgType.MagicName_Patch },
                    ["魔法説明"] = new List<FmgType> { FmgType.MagicInfo },
                },
                ByBinderID = new()
                {
                    [1] = new List<FmgType> { FmgType.TalkMsg },
                    [2] = new List<FmgType> { FmgType.BloodMsg },
                    [3] = new List<FmgType> { FmgType.MovieSubtitle },
                    [10] = new List<FmgType> { FmgType.GoodsName },
                    [11] = new List<FmgType> { FmgType.WeaponName },
                    [12] = new List<FmgType> { FmgType.ProtectorName },
                    [13] = new List<FmgType> { FmgType.AccessoryName },
                    [14] = new List<FmgType> { FmgType.MagicName },
                    [15] = new List<FmgType> { FmgType.FeatureName },
                    [16] = new List<FmgType> { FmgType.FeatureInfo },
                    [17] = new List<FmgType> { FmgType.FeatureCaption },
                    [18] = new List<FmgType> { FmgType.NpcName },
                    [19] = new List<FmgType> { FmgType.PlaceName },
                    [20] = new List<FmgType> { FmgType.GoodsInfo },
                    [21] = new List<FmgType> { FmgType.WeaponInfo },
                    [22] = new List<FmgType> { FmgType.ProtectorInfo },
                    [23] = new List<FmgType> { FmgType.AccessoryInfo },
                    [24] = new List<FmgType> { FmgType.GoodsCaption },
                    [25] = new List<FmgType> { FmgType.WeaponCaption },
                    [26] = new List<FmgType> { FmgType.ProtectorCaption },
                    [27] = new List<FmgType> { FmgType.AccessoryCaption },
                    [28] = new List<FmgType> { FmgType.MagicInfo },
                    [29] = new List<FmgType> { FmgType.MagicCaption },
                    [30] = new List<FmgType> { FmgType.EventText },
                    [70] = new List<FmgType> { FmgType.InGameMenu },
                    [76] = new List<FmgType> { FmgType.MenuGeneralText },
                    [77] = new List<FmgType> { FmgType.MenuOther },
                    [78] = new List<FmgType> { FmgType.Dialogues },
                    [79] = new List<FmgType> { FmgType.KeyGuide },
                    [80] = new List<FmgType> { FmgType.LineHelp },
                    [81] = new List<FmgType> { FmgType.MenuContext },
                    [90] = new List<FmgType> { FmgType.TextDisplayTagList },
                    [91] = new List<FmgType> { FmgType.SystemTagsWindows },
                    [92] = new List<FmgType> { FmgType.SystemMessageWindows },
                    [100] = new List<FmgType> { FmgType.GoodsCaption_Patch },
                    [101] = new List<FmgType> { FmgType.EventText_Patch },
                    [102] = new List<FmgType> { FmgType.Dialogues_Patch },
                    [103] = new List<FmgType> { FmgType.SystemMessageWindows_Patch },
                    [104] = new List<FmgType> { FmgType.TalkMsg_Patch },
                    [105] = new List<FmgType> { FmgType.MagicCaption_Patch },
                    [106] = new List<FmgType> { FmgType.WeaponCaption_Patch },
                    [107] = new List<FmgType> { FmgType.BloodMsg_Patch },
                    [108] = new List<FmgType> { FmgType.ProtectorCaption_Patch },
                    [109] = new List<FmgType> { FmgType.AccessoryCaption_Patch },
                    [110] = new List<FmgType> { FmgType.GoodsInfo_Patch },
                    [111] = new List<FmgType> { FmgType.GoodsName_Patch },
                    [112] = new List<FmgType> { FmgType.AccessoryInfo_Patch },
                    [113] = new List<FmgType> { FmgType.AccessoryName_Patch },
                    [114] = new List<FmgType> { FmgType.WeaponInfo_Patch },
                    [115] = new List<FmgType> { FmgType.WeaponName_Patch },
                    [116] = new List<FmgType> { FmgType.ProtectorInfo_Patch },
                    [117] = new List<FmgType> { FmgType.ProtectorName_Patch },
                    [118] = new List<FmgType> { FmgType.MagicName_Patch },
                    [119] = new List<FmgType> { FmgType.NpcName_Patch },
                    [120] = new List<FmgType> { FmgType.PlaceName_Patch },
                    [121] = new List<FmgType> { FmgType.LineHelp_Patch },
                    [122] = new List<FmgType> { FmgType.KeyGuide_Patch },
                    [123] = new List<FmgType> { FmgType.MenuOther_Patch },
                    [124] = new List<FmgType> { FmgType.MenuGeneralText_Patch },
                },
                ToLanguageEnum = new()
                {
                    ["english"] = FmgLanguage.English,
                    ["french"] = FmgLanguage.French,
                    ["german"] = FmgLanguage.German,
                    ["italian"] = FmgLanguage.Italian,
                    ["japanese"] = FmgLanguage.Japanese,
                    ["korean"] = FmgLanguage.Korean,
                    ["polish"] = FmgLanguage.Polish,
                    ["russian"] = FmgLanguage.Russian,
                    ["spanish"] = FmgLanguage.SpainSpanish,
                    ["tchinese"] = FmgLanguage.TraditionalChinese,
                },
                FromLanguageEnum = new()
                {
                    [FmgLanguage.English] = "english",
                    [FmgLanguage.French] = "french",
                    [FmgLanguage.German] = "german",
                    [FmgLanguage.Italian] = "italian",
                    [FmgLanguage.Japanese] = "japanese",
                    [FmgLanguage.Korean] = "korean",
                    [FmgLanguage.Polish] = "polish",
                    [FmgLanguage.Russian] = "russian",
                    [FmgLanguage.SpainSpanish] = "spanish",
                    [FmgLanguage.TraditionalChinese] = "tchinese",
                },
            },
            [FromSoftGame.DarkSoulsRemastered] = new FmgGameInfo
            {
                ByType = new()
                {
                    [FmgType.AccessoryCaption] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.AccessoryCaption, FmgType.AccessoryCaption, "Accessory_long_desc_", 27),
                    [FmgType.AccessoryCaption_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.AccessoryCaption_Patch, FmgType.AccessoryCaption, "Accessory_long_desc_", 109),
                    [FmgType.AccessoryInfo] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.AccessoryInfo, FmgType.AccessoryInfo, "Accessory_description_", 23),
                    [FmgType.AccessoryInfo_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.AccessoryInfo_Patch, FmgType.AccessoryInfo, "Accessory_description_", 112),
                    [FmgType.AccessoryName] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.AccessoryName, FmgType.AccessoryName, "Accessory_name_", 13),
                    [FmgType.AccessoryName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.AccessoryName_Patch, FmgType.AccessoryName, "Accessory_name_", 113),
                    [FmgType.BloodMsg] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.BloodMsg, FmgType.BloodMsg, "Blood_writing_", 2),
                    [FmgType.BloodMsg_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.BloodMsg_Patch, FmgType.BloodMsg, "Blood_writing_", 107),
                    [FmgType.Dialogues] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.Dialogues, FmgType.Dialogues, "Dialogue_", 78),
                    [FmgType.Dialogues_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.Dialogues_Patch, FmgType.Dialogues, "Dialogue_", 102),
                    [FmgType.EventText] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.EventText, FmgType.EventText, "Event_text_", 30),
                    [FmgType.EventText_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.EventText_Patch, FmgType.EventText, "Event_text_", 101),
                    [FmgType.FeatureCaption] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.FeatureCaption, FmgType.FeatureCaption, "Feature_long_desc_", 17),
                    [FmgType.FeatureInfo] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.FeatureInfo, FmgType.FeatureInfo, "Feature_description_", 16),
                    [FmgType.FeatureName] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.FeatureName, FmgType.FeatureName, "Feature_name_", 15),
                    [FmgType.GoodsCaption] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.GoodsCaption, FmgType.GoodsCaption, "Item_long_desc_", 24),
                    [FmgType.GoodsCaption_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.GoodsCaption_Patch, FmgType.GoodsCaption, "Item_long_desc_", 100),
                    [FmgType.GoodsInfo] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.GoodsInfo, FmgType.GoodsInfo, "Item_description_", 20),
                    [FmgType.GoodsInfo_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.GoodsInfo_Patch, FmgType.GoodsInfo, "Item_description_", 110),
                    [FmgType.GoodsName] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.GoodsName, FmgType.GoodsName, "Item_name_", 10),
                    [FmgType.GoodsName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.GoodsName_Patch, FmgType.GoodsName, "Item_name_", 111),
                    [FmgType.InGameMenu] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.InGameMenu, FmgType.InGameMenu, "Ingame_menu_", 70),
                    [FmgType.KeyGuide] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.KeyGuide, FmgType.KeyGuide, "Key_guide_", 79),
                    [FmgType.KeyGuide_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.KeyGuide_Patch, FmgType.KeyGuide, "Key_guide_", 122),
                    [FmgType.LineHelp] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.LineHelp, FmgType.LineHelp, "Single_line_help_", 80),
                    [FmgType.LineHelp_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.LineHelp_Patch, FmgType.LineHelp, "Single_line_help_", 121),
                    [FmgType.MagicCaption] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.MagicCaption, FmgType.MagicCaption, "Magic_long_desc_", 29),
                    [FmgType.MagicCaption_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.MagicCaption_Patch, FmgType.MagicCaption, "Magic_long_desc_", 105),
                    [FmgType.MagicInfo] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.MagicInfo, FmgType.MagicInfo, "Magic_description_", 28),
                    [FmgType.MagicName] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.MagicName, FmgType.MagicName, "Magic_name_", 14),
                    [FmgType.MagicName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.MagicName_Patch, FmgType.MagicName, "Magic_name_", 118),
                    [FmgType.MenuContext] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.MenuContext, FmgType.MenuContext, "Item_help_", 81),
                    [FmgType.MenuGeneralText] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.MenuGeneralText, FmgType.MenuGeneralText, "Menu_general_text_", 76),
                    [FmgType.MenuGeneralText_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.MenuGeneralText_Patch, FmgType.MenuGeneralText, "Menu_general_text_", 124),
                    [FmgType.MenuOther] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.MenuOther, FmgType.MenuOther, "Menu_others_", 77),
                    [FmgType.MenuOther_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.MenuOther_Patch, FmgType.MenuOther, "Menu_others_", 123),
                    [FmgType.MovieSubtitle] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.MovieSubtitle, FmgType.MovieSubtitle, "Movie_subtitles_", 3),
                    [FmgType.NpcName] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.NpcName, FmgType.NpcName, "NPC_name_", 18),
                    [FmgType.NpcName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.NpcName_Patch, FmgType.NpcName, "NPC_name_", 119),
                    [FmgType.PlaceName] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.PlaceName, FmgType.PlaceName, "Place_name_", 19),
                    [FmgType.PlaceName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.PlaceName_Patch, FmgType.PlaceName, "Place_name_", 120),
                    [FmgType.ProtectorCaption] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.ProtectorCaption, FmgType.ProtectorCaption, "Armor_long_desc_", 26),
                    [FmgType.ProtectorCaption_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.ProtectorCaption_Patch, FmgType.ProtectorCaption, "Armor_long_desc_", 108),
                    [FmgType.ProtectorInfo] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.ProtectorInfo, FmgType.ProtectorInfo, "Armor_description_", 22),
                    [FmgType.ProtectorInfo_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.ProtectorInfo_Patch, FmgType.ProtectorInfo, "Armor_description_", 116),
                    [FmgType.ProtectorName] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.ProtectorName, FmgType.ProtectorName, "Armor_name_", 12),
                    [FmgType.ProtectorName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.ProtectorName_Patch, FmgType.ProtectorName, "Armor_name_", 117),
                    [FmgType.SystemMessageWindows] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.SystemMessageWindows, FmgType.SystemMessageWindows, "System_message_win32_", 92),
                    [FmgType.SystemMessageWindows_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.SystemMessageWindows_Patch, FmgType.SystemMessageWindows, "System_message_win32_", 103),
                    [FmgType.SystemTagsWindows] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.SystemTagsWindows, FmgType.SystemTagsWindows, "System_specific_tags_win32_", 91),
                    [FmgType.TalkMsg] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.TalkMsg, FmgType.TalkMsg, "Conversation_", 1),
                    [FmgType.TalkMsg_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.TalkMsg_Patch, FmgType.TalkMsg, "Conversation_", 104),
                    [FmgType.TextDisplayTagList] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Menu, FmgType.TextDisplayTagList, FmgType.TextDisplayTagList, "Text_display_tag_list_", 90),
                    [FmgType.WeaponCaption] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.WeaponCaption, FmgType.WeaponCaption, "Weapon_long_desc_", 25),
                    [FmgType.WeaponCaption_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.WeaponCaption_Patch, FmgType.WeaponCaption, "Weapon_long_desc_", 106),
                    [FmgType.WeaponInfo] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.WeaponInfo, FmgType.WeaponInfo, "Weapon_description_", 21),
                    [FmgType.WeaponInfo_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.WeaponInfo_Patch, FmgType.WeaponInfo, "Weapon_description_", 114),
                    [FmgType.WeaponName] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.WeaponName, FmgType.WeaponName, "Weapon_name_", 11),
                    [FmgType.WeaponName_Patch] = new FmgKeyInfo(FromSoftGame.DarkSoulsRemastered, FmgCategory.Item, FmgType.WeaponName_Patch, FmgType.WeaponName, "Weapon_name_", 115),
                },
                Overrides = new()
                {
                    [FmgType.AccessoryCaption] = new List<FmgType> { FmgType.AccessoryCaption_Patch },
                    [FmgType.AccessoryInfo] = new List<FmgType> { FmgType.AccessoryInfo_Patch },
                    [FmgType.AccessoryName] = new List<FmgType> { FmgType.AccessoryName_Patch },
                    [FmgType.BloodMsg] = new List<FmgType> { FmgType.BloodMsg_Patch },
                    [FmgType.Dialogues] = new List<FmgType> { FmgType.Dialogues_Patch },
                    [FmgType.EventText] = new List<FmgType> { FmgType.EventText_Patch },
                    [FmgType.GoodsCaption] = new List<FmgType> { FmgType.GoodsCaption_Patch },
                    [FmgType.GoodsInfo] = new List<FmgType> { FmgType.GoodsInfo_Patch },
                    [FmgType.GoodsName] = new List<FmgType> { FmgType.GoodsName_Patch },
                    [FmgType.KeyGuide] = new List<FmgType> { FmgType.KeyGuide_Patch },
                    [FmgType.LineHelp] = new List<FmgType> { FmgType.LineHelp_Patch },
                    [FmgType.MagicCaption] = new List<FmgType> { FmgType.MagicCaption_Patch },
                    [FmgType.MagicName] = new List<FmgType> { FmgType.MagicName_Patch },
                    [FmgType.MenuGeneralText] = new List<FmgType> { FmgType.MenuGeneralText_Patch },
                    [FmgType.MenuOther] = new List<FmgType> { FmgType.MenuOther_Patch },
                    [FmgType.NpcName] = new List<FmgType> { FmgType.NpcName_Patch },
                    [FmgType.PlaceName] = new List<FmgType> { FmgType.PlaceName_Patch },
                    [FmgType.ProtectorCaption] = new List<FmgType> { FmgType.ProtectorCaption_Patch },
                    [FmgType.ProtectorInfo] = new List<FmgType> { FmgType.ProtectorInfo_Patch },
                    [FmgType.ProtectorName] = new List<FmgType> { FmgType.ProtectorName_Patch },
                    [FmgType.SystemMessageWindows] = new List<FmgType> { FmgType.SystemMessageWindows_Patch },
                    [FmgType.TalkMsg] = new List<FmgType> { FmgType.TalkMsg_Patch },
                    [FmgType.WeaponCaption] = new List<FmgType> { FmgType.WeaponCaption_Patch },
                    [FmgType.WeaponInfo] = new List<FmgType> { FmgType.WeaponInfo_Patch },
                    [FmgType.WeaponName] = new List<FmgType> { FmgType.WeaponName_Patch },
                },
                ByFmgName = new()
                {
                    ["Accessory_description_"] = new List<FmgType> { FmgType.AccessoryInfo, FmgType.AccessoryInfo_Patch },
                    ["Accessory_long_desc_"] = new List<FmgType> { FmgType.AccessoryCaption, FmgType.AccessoryCaption_Patch },
                    ["Accessory_name_"] = new List<FmgType> { FmgType.AccessoryName, FmgType.AccessoryName_Patch },
                    ["Armor_description_"] = new List<FmgType> { FmgType.ProtectorInfo, FmgType.ProtectorInfo_Patch },
                    ["Armor_long_desc_"] = new List<FmgType> { FmgType.ProtectorCaption, FmgType.ProtectorCaption_Patch },
                    ["Armor_name_"] = new List<FmgType> { FmgType.ProtectorName, FmgType.ProtectorName_Patch },
                    ["Blood_writing_"] = new List<FmgType> { FmgType.BloodMsg, FmgType.BloodMsg_Patch },
                    ["Conversation_"] = new List<FmgType> { FmgType.TalkMsg, FmgType.TalkMsg_Patch },
                    ["Dialogue_"] = new List<FmgType> { FmgType.Dialogues, FmgType.Dialogues_Patch },
                    ["Event_text_"] = new List<FmgType> { FmgType.EventText, FmgType.EventText_Patch },
                    ["Feature_description_"] = new List<FmgType> { FmgType.FeatureInfo },
                    ["Feature_long_desc_"] = new List<FmgType> { FmgType.FeatureCaption },
                    ["Feature_name_"] = new List<FmgType> { FmgType.FeatureName },
                    ["Ingame_menu_"] = new List<FmgType> { FmgType.InGameMenu },
                    ["Item_description_"] = new List<FmgType> { FmgType.GoodsInfo, FmgType.GoodsInfo_Patch },
                    ["Item_help_"] = new List<FmgType> { FmgType.MenuContext },
                    ["Item_long_desc_"] = new List<FmgType> { FmgType.GoodsCaption, FmgType.GoodsCaption_Patch },
                    ["Item_name_"] = new List<FmgType> { FmgType.GoodsName, FmgType.GoodsName_Patch },
                    ["Key_guide_"] = new List<FmgType> { FmgType.KeyGuide, FmgType.KeyGuide_Patch },
                    ["Magic_description_"] = new List<FmgType> { FmgType.MagicInfo },
                    ["Magic_long_desc_"] = new List<FmgType> { FmgType.MagicCaption, FmgType.MagicCaption_Patch },
                    ["Magic_name_"] = new List<FmgType> { FmgType.MagicName, FmgType.MagicName_Patch },
                    ["Menu_general_text_"] = new List<FmgType> { FmgType.MenuGeneralText, FmgType.MenuGeneralText_Patch },
                    ["Menu_others_"] = new List<FmgType> { FmgType.MenuOther, FmgType.MenuOther_Patch },
                    ["Movie_subtitles_"] = new List<FmgType> { FmgType.MovieSubtitle },
                    ["NPC_name_"] = new List<FmgType> { FmgType.NpcName, FmgType.NpcName_Patch },
                    ["Place_name_"] = new List<FmgType> { FmgType.PlaceName, FmgType.PlaceName_Patch },
                    ["Single_line_help_"] = new List<FmgType> { FmgType.LineHelp, FmgType.LineHelp_Patch },
                    ["System_message_win32_"] = new List<FmgType> { FmgType.SystemMessageWindows, FmgType.SystemMessageWindows_Patch },
                    ["System_specific_tags_win32_"] = new List<FmgType> { FmgType.SystemTagsWindows },
                    ["Text_display_tag_list_"] = new List<FmgType> { FmgType.TextDisplayTagList },
                    ["Weapon_description_"] = new List<FmgType> { FmgType.WeaponInfo, FmgType.WeaponInfo_Patch },
                    ["Weapon_long_desc_"] = new List<FmgType> { FmgType.WeaponCaption, FmgType.WeaponCaption_Patch },
                    ["Weapon_name_"] = new List<FmgType> { FmgType.WeaponName, FmgType.WeaponName_Patch },
                },
                ByBinderID = new()
                {
                    [1] = new List<FmgType> { FmgType.TalkMsg },
                    [2] = new List<FmgType> { FmgType.BloodMsg },
                    [3] = new List<FmgType> { FmgType.MovieSubtitle },
                    [10] = new List<FmgType> { FmgType.GoodsName },
                    [11] = new List<FmgType> { FmgType.WeaponName },
                    [12] = new List<FmgType> { FmgType.ProtectorName },
                    [13] = new List<FmgType> { FmgType.AccessoryName },
                    [14] = new List<FmgType> { FmgType.MagicName },
                    [15] = new List<FmgType> { FmgType.FeatureName },
                    [16] = new List<FmgType> { FmgType.FeatureInfo },
                    [17] = new List<FmgType> { FmgType.FeatureCaption },
                    [18] = new List<FmgType> { FmgType.NpcName },
                    [19] = new List<FmgType> { FmgType.PlaceName },
                    [20] = new List<FmgType> { FmgType.GoodsInfo },
                    [21] = new List<FmgType> { FmgType.WeaponInfo },
                    [22] = new List<FmgType> { FmgType.ProtectorInfo },
                    [23] = new List<FmgType> { FmgType.AccessoryInfo },
                    [24] = new List<FmgType> { FmgType.GoodsCaption },
                    [25] = new List<FmgType> { FmgType.WeaponCaption },
                    [26] = new List<FmgType> { FmgType.ProtectorCaption },
                    [27] = new List<FmgType> { FmgType.AccessoryCaption },
                    [28] = new List<FmgType> { FmgType.MagicInfo },
                    [29] = new List<FmgType> { FmgType.MagicCaption },
                    [30] = new List<FmgType> { FmgType.EventText },
                    [70] = new List<FmgType> { FmgType.InGameMenu },
                    [76] = new List<FmgType> { FmgType.MenuGeneralText },
                    [77] = new List<FmgType> { FmgType.MenuOther },
                    [78] = new List<FmgType> { FmgType.Dialogues },
                    [79] = new List<FmgType> { FmgType.KeyGuide },
                    [80] = new List<FmgType> { FmgType.LineHelp },
                    [81] = new List<FmgType> { FmgType.MenuContext },
                    [90] = new List<FmgType> { FmgType.TextDisplayTagList },
                    [91] = new List<FmgType> { FmgType.SystemTagsWindows },
                    [92] = new List<FmgType> { FmgType.SystemMessageWindows },
                    [100] = new List<FmgType> { FmgType.GoodsCaption_Patch },
                    [101] = new List<FmgType> { FmgType.EventText_Patch },
                    [102] = new List<FmgType> { FmgType.Dialogues_Patch },
                    [103] = new List<FmgType> { FmgType.SystemMessageWindows_Patch },
                    [104] = new List<FmgType> { FmgType.TalkMsg_Patch },
                    [105] = new List<FmgType> { FmgType.MagicCaption_Patch },
                    [106] = new List<FmgType> { FmgType.WeaponCaption_Patch },
                    [107] = new List<FmgType> { FmgType.BloodMsg_Patch },
                    [108] = new List<FmgType> { FmgType.ProtectorCaption_Patch },
                    [109] = new List<FmgType> { FmgType.AccessoryCaption_Patch },
                    [110] = new List<FmgType> { FmgType.GoodsInfo_Patch },
                    [111] = new List<FmgType> { FmgType.GoodsName_Patch },
                    [112] = new List<FmgType> { FmgType.AccessoryInfo_Patch },
                    [113] = new List<FmgType> { FmgType.AccessoryName_Patch },
                    [114] = new List<FmgType> { FmgType.WeaponInfo_Patch },
                    [115] = new List<FmgType> { FmgType.WeaponName_Patch },
                    [116] = new List<FmgType> { FmgType.ProtectorInfo_Patch },
                    [117] = new List<FmgType> { FmgType.ProtectorName_Patch },
                    [118] = new List<FmgType> { FmgType.MagicName_Patch },
                    [119] = new List<FmgType> { FmgType.NpcName_Patch },
                    [120] = new List<FmgType> { FmgType.PlaceName_Patch },
                    [121] = new List<FmgType> { FmgType.LineHelp_Patch },
                    [122] = new List<FmgType> { FmgType.KeyGuide_Patch },
                    [123] = new List<FmgType> { FmgType.MenuOther_Patch },
                    [124] = new List<FmgType> { FmgType.MenuGeneralText_Patch },
                },
                ToLanguageEnum = new()
                {
                    ["english"] = FmgLanguage.English,
                    ["french"] = FmgLanguage.French,
                    ["german"] = FmgLanguage.German,
                    ["italian"] = FmgLanguage.Italian,
                    ["japanese"] = FmgLanguage.Japanese,
                    ["korean"] = FmgLanguage.Korean,
                    ["nspanish"] = FmgLanguage.Spanish,
                    ["polish"] = FmgLanguage.Polish,
                    ["portuguese"] = FmgLanguage.BrazilPortuguese,
                    ["russian"] = FmgLanguage.Russian,
                    ["schinese"] = FmgLanguage.SimplifiedChinese,
                    ["spanish"] = FmgLanguage.SpainSpanish,
                    ["tchinese"] = FmgLanguage.TraditionalChinese,
                },
                FromLanguageEnum = new()
                {
                    [FmgLanguage.English] = "english",
                    [FmgLanguage.French] = "french",
                    [FmgLanguage.German] = "german",
                    [FmgLanguage.Italian] = "italian",
                    [FmgLanguage.Japanese] = "japanese",
                    [FmgLanguage.Korean] = "korean",
                    [FmgLanguage.Spanish] = "nspanish",
                    [FmgLanguage.Polish] = "polish",
                    [FmgLanguage.BrazilPortuguese] = "portuguese",
                    [FmgLanguage.Russian] = "russian",
                    [FmgLanguage.SimplifiedChinese] = "schinese",
                    [FmgLanguage.SpainSpanish] = "spanish",
                    [FmgLanguage.TraditionalChinese] = "tchinese",
                },
            },
            [FromSoftGame.DarkSouls2] = new FmgGameInfo
            {
                ByType = new()
                {
                    [FmgType.BloodMsgConjunction] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.BloodMsgConjunction, FmgType.BloodMsgConjunction, "bloodmessageconjunction", -1),
                    [FmgType.BloodMsgSentence] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.BloodMsgSentence, FmgType.BloodMsgSentence, "bloodmessagesentence", -1),
                    [FmgType.BloodMsgWord] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.BloodMsgWord, FmgType.BloodMsgWord, "bloodmessageword", -1),
                    [FmgType.BloodMsgWordCategory] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.BloodMsgWordCategory, FmgType.BloodMsgWordCategory, "bloodmessagewordcategory", -1),
                    [FmgType.BonfireMenu] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.BonfireMenu, FmgType.BonfireMenu, "bofire", -1),
                    [FmgType.BonfireName] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.BonfireName, FmgType.BonfireName, "bonfirename", -1),
                    [FmgType.CharaMaking] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.CharaMaking, FmgType.CharaMaking, "charamaking", -1),
                    [FmgType.CharaName] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.CharaName, FmgType.CharaName, "charaname", -1),
                    [FmgType.DS2Common] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.DS2Common, FmgType.DS2Common, "common", -1),
                    [FmgType.DS2Shop] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.DS2Shop, FmgType.DS2Shop, "shop", -1),
                    [FmgType.EventTextForMap] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.EventTextForMap, FmgType.EventTextForMap, "mapevent", -1),
                    [FmgType.IconHelp] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.IconHelp, FmgType.IconHelp, "iconhelp", -1),
                    [FmgType.InGameMenu] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.InGameMenu, FmgType.InGameMenu, "ingamemenu", -1),
                    [FmgType.InGameSystem] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.InGameSystem, FmgType.InGameSystem, "ingamesystem", -1),
                    [FmgType.ItemCaption] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.ItemCaption, FmgType.ItemCaption, "detailedexplanation", -1),
                    [FmgType.ItemInfo] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.ItemInfo, FmgType.ItemInfo, "simpleexplanation", -1),
                    [FmgType.ItemName] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.ItemName, FmgType.ItemName, "itemname", -1),
                    [FmgType.KeyGuide] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.KeyGuide, FmgType.KeyGuide, "keyguide", -1),
                    [FmgType.NpcMenu] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.NpcMenu, FmgType.NpcMenu, "npcmenu", -1),
                    [FmgType.PlaceName] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.PlaceName, FmgType.PlaceName, "mapname", -1),
                    [FmgType.PluralSelect] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.PluralSelect, FmgType.PluralSelect, "pluralselect", -1),
                    [FmgType.Prologue] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.Prologue, FmgType.Prologue, "prologue", -1),
                    [FmgType.StaffRoll] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.StaffRoll, FmgType.StaffRoll, "staffroll", -1),
                    [FmgType.SystemMessageWindows] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.SystemMessageWindows, FmgType.SystemMessageWindows, "win32onlymessage", -1),
                    [FmgType.TitleFlow] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.TitleFlow, FmgType.TitleFlow, "titleflow", -1),
                    [FmgType.TitleMenu] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.TitleMenu, FmgType.TitleMenu, "titlemenu", -1),
                    [FmgType.WeaponType] = new FmgKeyInfo(FromSoftGame.DarkSouls2, FmgCategory.None, FmgType.WeaponType, FmgType.WeaponType, "weapontype", -1),
                },
                Overrides = new()
                {

                },
                ByFmgName = new()
                {
                    ["bloodmessageconjunction"] = new List<FmgType> { FmgType.BloodMsgConjunction },
                    ["bloodmessagesentence"] = new List<FmgType> { FmgType.BloodMsgSentence },
                    ["bloodmessageword"] = new List<FmgType> { FmgType.BloodMsgWord },
                    ["bloodmessagewordcategory"] = new List<FmgType> { FmgType.BloodMsgWordCategory },
                    ["bofire"] = new List<FmgType> { FmgType.BonfireMenu },
                    ["bonfirename"] = new List<FmgType> { FmgType.BonfireName },
                    ["charamaking"] = new List<FmgType> { FmgType.CharaMaking },
                    ["charaname"] = new List<FmgType> { FmgType.CharaName },
                    ["common"] = new List<FmgType> { FmgType.DS2Common },
                    ["detailedexplanation"] = new List<FmgType> { FmgType.ItemCaption },
                    ["iconhelp"] = new List<FmgType> { FmgType.IconHelp },
                    ["ingamemenu"] = new List<FmgType> { FmgType.InGameMenu },
                    ["ingamesystem"] = new List<FmgType> { FmgType.InGameSystem },
                    ["itemname"] = new List<FmgType> { FmgType.ItemName },
                    ["keyguide"] = new List<FmgType> { FmgType.KeyGuide },
                    ["mapevent"] = new List<FmgType> { FmgType.EventTextForMap },
                    ["mapname"] = new List<FmgType> { FmgType.PlaceName },
                    ["npcmenu"] = new List<FmgType> { FmgType.NpcMenu },
                    ["pluralselect"] = new List<FmgType> { FmgType.PluralSelect },
                    ["prologue"] = new List<FmgType> { FmgType.Prologue },
                    ["shop"] = new List<FmgType> { FmgType.DS2Shop },
                    ["simpleexplanation"] = new List<FmgType> { FmgType.ItemInfo },
                    ["staffroll"] = new List<FmgType> { FmgType.StaffRoll },
                    ["titleflow"] = new List<FmgType> { FmgType.TitleFlow },
                    ["titlemenu"] = new List<FmgType> { FmgType.TitleMenu },
                    ["weapontype"] = new List<FmgType> { FmgType.WeaponType },
                    ["win32onlymessage"] = new List<FmgType> { FmgType.SystemMessageWindows },
                },
                ByBinderID = new()
                {

                },
                ToLanguageEnum = new()
                {
                    ["chinese"] = FmgLanguage.TraditionalChinese,
                    ["english"] = FmgLanguage.English,
                    ["french"] = FmgLanguage.French,
                    ["germany"] = FmgLanguage.German,
                    ["italian"] = FmgLanguage.Italian,
                    ["japanese"] = FmgLanguage.Japanese,
                    ["korean"] = FmgLanguage.Korean,
                    ["polish"] = FmgLanguage.Polish,
                    ["portuguese"] = FmgLanguage.BrazilPortuguese,
                    ["russian"] = FmgLanguage.Russian,
                    ["spanish"] = FmgLanguage.SpainSpanish,
                },
                FromLanguageEnum = new()
                {
                    [FmgLanguage.TraditionalChinese] = "chinese",
                    [FmgLanguage.English] = "english",
                    [FmgLanguage.French] = "french",
                    [FmgLanguage.German] = "germany",
                    [FmgLanguage.Italian] = "italian",
                    [FmgLanguage.Japanese] = "japanese",
                    [FmgLanguage.Korean] = "korean",
                    [FmgLanguage.Polish] = "polish",
                    [FmgLanguage.BrazilPortuguese] = "portuguese",
                    [FmgLanguage.Russian] = "russian",
                    [FmgLanguage.SpainSpanish] = "spanish",
                },
            },
            [FromSoftGame.DarkSouls2Sotfs] = new FmgGameInfo
            {
                ByType = new()
                {
                    [FmgType.BloodMsgConjunction] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.BloodMsgConjunction, FmgType.BloodMsgConjunction, "bloodmessageconjunction", -1),
                    [FmgType.BloodMsgSentence] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.BloodMsgSentence, FmgType.BloodMsgSentence, "bloodmessagesentence", -1),
                    [FmgType.BloodMsgWord] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.BloodMsgWord, FmgType.BloodMsgWord, "bloodmessageword", -1),
                    [FmgType.BloodMsgWordCategory] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.BloodMsgWordCategory, FmgType.BloodMsgWordCategory, "bloodmessagewordcategory", -1),
                    [FmgType.BonfireMenu] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.BonfireMenu, FmgType.BonfireMenu, "bofire", -1),
                    [FmgType.BonfireName] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.BonfireName, FmgType.BonfireName, "bonfirename", -1),
                    [FmgType.CharaMaking] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.CharaMaking, FmgType.CharaMaking, "charamaking", -1),
                    [FmgType.CharaName] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.CharaName, FmgType.CharaName, "charaname", -1),
                    [FmgType.DS2Common] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.DS2Common, FmgType.DS2Common, "common", -1),
                    [FmgType.DS2Shop] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.DS2Shop, FmgType.DS2Shop, "shop", -1),
                    [FmgType.EventTextForMap] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.EventTextForMap, FmgType.EventTextForMap, "mapevent", -1),
                    [FmgType.IconHelp] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.IconHelp, FmgType.IconHelp, "iconhelp", -1),
                    [FmgType.InGameMenu] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.InGameMenu, FmgType.InGameMenu, "ingamemenu", -1),
                    [FmgType.InGameSystem] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.InGameSystem, FmgType.InGameSystem, "ingamesystem", -1),
                    [FmgType.ItemCaption] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.ItemCaption, FmgType.ItemCaption, "detailedexplanation", -1),
                    [FmgType.ItemInfo] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.ItemInfo, FmgType.ItemInfo, "simpleexplanation", -1),
                    [FmgType.ItemName] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.ItemName, FmgType.ItemName, "itemname", -1),
                    [FmgType.KeyGuide] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.KeyGuide, FmgType.KeyGuide, "keyguide", -1),
                    [FmgType.NpcMenu] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.NpcMenu, FmgType.NpcMenu, "npcmenu", -1),
                    [FmgType.PlaceName] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.PlaceName, FmgType.PlaceName, "mapname", -1),
                    [FmgType.PluralSelect] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.PluralSelect, FmgType.PluralSelect, "pluralselect", -1),
                    [FmgType.Prologue] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.Prologue, FmgType.Prologue, "prologue", -1),
                    [FmgType.StaffRoll] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.StaffRoll, FmgType.StaffRoll, "staffroll", -1),
                    [FmgType.SystemMessageDC] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.SystemMessageDC, FmgType.SystemMessageDC, "dconlymessage", -1),
                    [FmgType.SystemMessageWindows] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.SystemMessageWindows, FmgType.SystemMessageWindows, "win32onlymessage", -1),
                    [FmgType.TitleFlow] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.TitleFlow, FmgType.TitleFlow, "titleflow", -1),
                    [FmgType.TitleMenu] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.TitleMenu, FmgType.TitleMenu, "titlemenu", -1),
                    [FmgType.WeaponType] = new FmgKeyInfo(FromSoftGame.DarkSouls2Sotfs, FmgCategory.None, FmgType.WeaponType, FmgType.WeaponType, "weapontype", -1),
                },
                Overrides = new()
                {

                },
                ByFmgName = new()
                {
                    ["bloodmessageconjunction"] = new List<FmgType> { FmgType.BloodMsgConjunction },
                    ["bloodmessagesentence"] = new List<FmgType> { FmgType.BloodMsgSentence },
                    ["bloodmessageword"] = new List<FmgType> { FmgType.BloodMsgWord },
                    ["bloodmessagewordcategory"] = new List<FmgType> { FmgType.BloodMsgWordCategory },
                    ["bofire"] = new List<FmgType> { FmgType.BonfireMenu },
                    ["bonfirename"] = new List<FmgType> { FmgType.BonfireName },
                    ["charamaking"] = new List<FmgType> { FmgType.CharaMaking },
                    ["charaname"] = new List<FmgType> { FmgType.CharaName },
                    ["common"] = new List<FmgType> { FmgType.DS2Common },
                    ["dconlymessage"] = new List<FmgType> { FmgType.SystemMessageDC },
                    ["detailedexplanation"] = new List<FmgType> { FmgType.ItemCaption },
                    ["iconhelp"] = new List<FmgType> { FmgType.IconHelp },
                    ["ingamemenu"] = new List<FmgType> { FmgType.InGameMenu },
                    ["ingamesystem"] = new List<FmgType> { FmgType.InGameSystem },
                    ["itemname"] = new List<FmgType> { FmgType.ItemName },
                    ["keyguide"] = new List<FmgType> { FmgType.KeyGuide },
                    ["mapevent"] = new List<FmgType> { FmgType.EventTextForMap },
                    ["mapname"] = new List<FmgType> { FmgType.PlaceName },
                    ["npcmenu"] = new List<FmgType> { FmgType.NpcMenu },
                    ["pluralselect"] = new List<FmgType> { FmgType.PluralSelect },
                    ["prologue"] = new List<FmgType> { FmgType.Prologue },
                    ["shop"] = new List<FmgType> { FmgType.DS2Shop },
                    ["simpleexplanation"] = new List<FmgType> { FmgType.ItemInfo },
                    ["staffroll"] = new List<FmgType> { FmgType.StaffRoll },
                    ["titleflow"] = new List<FmgType> { FmgType.TitleFlow },
                    ["titlemenu"] = new List<FmgType> { FmgType.TitleMenu },
                    ["weapontype"] = new List<FmgType> { FmgType.WeaponType },
                    ["win32onlymessage"] = new List<FmgType> { FmgType.SystemMessageWindows },
                },
                ByBinderID = new()
                {

                },
                ToLanguageEnum = new()
                {
                    ["chinese"] = FmgLanguage.TraditionalChinese,
                    ["english"] = FmgLanguage.English,
                    ["french"] = FmgLanguage.French,
                    ["germany"] = FmgLanguage.German,
                    ["italian"] = FmgLanguage.Italian,
                    ["japanese"] = FmgLanguage.Japanese,
                    ["korean"] = FmgLanguage.Korean,
                    ["neutralspanish"] = FmgLanguage.Spanish,
                    ["polish"] = FmgLanguage.Polish,
                    ["portuguese"] = FmgLanguage.BrazilPortuguese,
                    ["russian"] = FmgLanguage.Russian,
                    ["spanish"] = FmgLanguage.SpainSpanish,
                },
                FromLanguageEnum = new()
                {
                    [FmgLanguage.TraditionalChinese] = "chinese",
                    [FmgLanguage.English] = "english",
                    [FmgLanguage.French] = "french",
                    [FmgLanguage.German] = "germany",
                    [FmgLanguage.Italian] = "italian",
                    [FmgLanguage.Japanese] = "japanese",
                    [FmgLanguage.Korean] = "korean",
                    [FmgLanguage.Spanish] = "neutralspanish",
                    [FmgLanguage.Polish] = "polish",
                    [FmgLanguage.BrazilPortuguese] = "portuguese",
                    [FmgLanguage.Russian] = "russian",
                    [FmgLanguage.SpainSpanish] = "spanish",
                },
            },
            [FromSoftGame.Bloodborne] = new FmgGameInfo
            {
                ByType = new()
                {
                    [FmgType.AccessoryCaption] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.AccessoryCaption, FmgType.AccessoryCaption, "アクセサリうんちく", 27),
                    [FmgType.AccessoryInfo] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.AccessoryInfo, FmgType.AccessoryInfo, "アクセサリ説明", 23),
                    [FmgType.AccessoryName] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.AccessoryName, FmgType.AccessoryName, "アクセサリ名", 13),
                    [FmgType.BloodMsg] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.BloodMsg, FmgType.BloodMsg, "血文字", 2),
                    [FmgType.CauseOfDeath] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.CauseOfDeath, FmgType.CauseOfDeath, "死因", 4),
                    [FmgType.Dialogues] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.Dialogues, FmgType.Dialogues, "ダイアログ", 78),
                    [FmgType.EventText] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.EventText, FmgType.EventText, "イベントテキスト", 30),
                    [FmgType.GameDialogues] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.GameDialogues, FmgType.GameDialogues, "SP_ダイアログ", 204),
                    [FmgType.GameKeyGuide] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.GameKeyGuide, FmgType.GameKeyGuide, "SP_キーガイド", 202),
                    [FmgType.GameLineHelp] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.GameLineHelp, FmgType.GameLineHelp, "SP_一行ヘルプ", 201),
                    [FmgType.GameMenuText] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.GameMenuText, FmgType.GameMenuText, "SP_メニューテキスト", 200),
                    [FmgType.GameSystemMessageWindows] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.GameSystemMessageWindows, FmgType.GameSystemMessageWindows, "SP_システムメッセージ_win64", 203),
                    [FmgType.GemCaption] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.GemCaption, FmgType.GemCaption, "魔石うんちく", 33),
                    [FmgType.GemEffect] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.GemEffect, FmgType.GemEffect, "魔石効果", 35),
                    [FmgType.GemInfo] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.GemInfo, FmgType.GemInfo, "魔石説明", 32),
                    [FmgType.GemName] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.GemName, FmgType.GemName, "魔石名", 31),
                    [FmgType.GemPrefix] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.GemPrefix, FmgType.GemPrefix, "魔石接頭語", 34),
                    [FmgType.GoodsCaption] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.GoodsCaption, FmgType.GoodsCaption, "アイテムうんちく", 24),
                    [FmgType.GoodsInfo] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.GoodsInfo, FmgType.GoodsInfo, "アイテム説明", 20),
                    [FmgType.GoodsName] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.GoodsName, FmgType.GoodsName, "アイテム名", 10),
                    [FmgType.InGameMenu] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.InGameMenu, FmgType.InGameMenu, "インゲームメニュー", 70),
                    [FmgType.KeyGuide] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.KeyGuide, FmgType.KeyGuide, "キーガイド", 79),
                    [FmgType.LineHelp] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.LineHelp, FmgType.LineHelp, "一行ヘルプ", 80),
                    [FmgType.MagicCaption] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.MagicCaption, FmgType.MagicCaption, "魔法うんちく", 29),
                    [FmgType.MagicInfo] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.MagicInfo, FmgType.MagicInfo, "魔法説明", 28),
                    [FmgType.MagicName] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.MagicName, FmgType.MagicName, "魔法名", 14),
                    [FmgType.MenuGeneralText] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.MenuGeneralText, FmgType.MenuGeneralText, "メニュー共通テキスト", 76),
                    [FmgType.MenuOther] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.MenuOther, FmgType.MenuOther, "メニューその他", 77),
                    [FmgType.MovieSubtitle] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.MovieSubtitle, FmgType.MovieSubtitle, "ムービー字幕", 3),
                    [FmgType.NpcName] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.NpcName, FmgType.NpcName, "NPC名", 18),
                    [FmgType.PlaceName] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.PlaceName, FmgType.PlaceName, "地名", 19),
                    [FmgType.ProtectorCaption] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.ProtectorCaption, FmgType.ProtectorCaption, "防具うんちく", 26),
                    [FmgType.ProtectorInfo] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.ProtectorInfo, FmgType.ProtectorInfo, "防具説明", 22),
                    [FmgType.ProtectorName] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.ProtectorName, FmgType.ProtectorName, "防具名", 12),
                    [FmgType.SystemMessageWindows] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.SystemMessageWindows, FmgType.SystemMessageWindows, "システムメッセージ_win64", 92),
                    [FmgType.SystemTagsWindows] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.SystemTagsWindows, FmgType.SystemTagsWindows, "機種別タグ_win64", 91),
                    [FmgType.TalkMsg] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.TalkMsg, FmgType.TalkMsg, "会話", 1),
                    [FmgType.TextDisplayTagList] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Menu, FmgType.TextDisplayTagList, FmgType.TextDisplayTagList, "テキスト表示用タグ一覧", 90),
                    [FmgType.WeaponCaption] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.WeaponCaption, FmgType.WeaponCaption, "武器うんちく", 25),
                    [FmgType.WeaponInfo] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.WeaponInfo, FmgType.WeaponInfo, "武器説明", 21),
                    [FmgType.WeaponName] = new FmgKeyInfo(FromSoftGame.Bloodborne, FmgCategory.Item, FmgType.WeaponName, FmgType.WeaponName, "武器名", 11),
                },
                Overrides = new()
                {

                },
                ByFmgName = new()
                {
                    ["NPC名"] = new List<FmgType> { FmgType.NpcName },
                    ["SP_キーガイド"] = new List<FmgType> { FmgType.GameKeyGuide },
                    ["SP_システムメッセージ_win64"] = new List<FmgType> { FmgType.GameSystemMessageWindows },
                    ["SP_ダイアログ"] = new List<FmgType> { FmgType.GameDialogues },
                    ["SP_メニューテキスト"] = new List<FmgType> { FmgType.GameMenuText },
                    ["SP_一行ヘルプ"] = new List<FmgType> { FmgType.GameLineHelp },
                    ["アイテムうんちく"] = new List<FmgType> { FmgType.GoodsCaption },
                    ["アイテム名"] = new List<FmgType> { FmgType.GoodsName },
                    ["アイテム説明"] = new List<FmgType> { FmgType.GoodsInfo },
                    ["アクセサリうんちく"] = new List<FmgType> { FmgType.AccessoryCaption },
                    ["アクセサリ名"] = new List<FmgType> { FmgType.AccessoryName },
                    ["アクセサリ説明"] = new List<FmgType> { FmgType.AccessoryInfo },
                    ["イベントテキスト"] = new List<FmgType> { FmgType.EventText },
                    ["インゲームメニュー"] = new List<FmgType> { FmgType.InGameMenu },
                    ["キーガイド"] = new List<FmgType> { FmgType.KeyGuide },
                    ["システムメッセージ_win64"] = new List<FmgType> { FmgType.SystemMessageWindows },
                    ["ダイアログ"] = new List<FmgType> { FmgType.Dialogues },
                    ["テキスト表示用タグ一覧"] = new List<FmgType> { FmgType.TextDisplayTagList },
                    ["ムービー字幕"] = new List<FmgType> { FmgType.MovieSubtitle },
                    ["メニューその他"] = new List<FmgType> { FmgType.MenuOther },
                    ["メニュー共通テキスト"] = new List<FmgType> { FmgType.MenuGeneralText },
                    ["一行ヘルプ"] = new List<FmgType> { FmgType.LineHelp },
                    ["会話"] = new List<FmgType> { FmgType.TalkMsg },
                    ["地名"] = new List<FmgType> { FmgType.PlaceName },
                    ["機種別タグ_win64"] = new List<FmgType> { FmgType.SystemTagsWindows },
                    ["武器うんちく"] = new List<FmgType> { FmgType.WeaponCaption },
                    ["武器名"] = new List<FmgType> { FmgType.WeaponName },
                    ["武器説明"] = new List<FmgType> { FmgType.WeaponInfo },
                    ["死因"] = new List<FmgType> { FmgType.CauseOfDeath },
                    ["血文字"] = new List<FmgType> { FmgType.BloodMsg },
                    ["防具うんちく"] = new List<FmgType> { FmgType.ProtectorCaption },
                    ["防具名"] = new List<FmgType> { FmgType.ProtectorName },
                    ["防具説明"] = new List<FmgType> { FmgType.ProtectorInfo },
                    ["魔法うんちく"] = new List<FmgType> { FmgType.MagicCaption },
                    ["魔法名"] = new List<FmgType> { FmgType.MagicName },
                    ["魔法説明"] = new List<FmgType> { FmgType.MagicInfo },
                    ["魔石うんちく"] = new List<FmgType> { FmgType.GemCaption },
                    ["魔石効果"] = new List<FmgType> { FmgType.GemEffect },
                    ["魔石名"] = new List<FmgType> { FmgType.GemName },
                    ["魔石接頭語"] = new List<FmgType> { FmgType.GemPrefix },
                    ["魔石説明"] = new List<FmgType> { FmgType.GemInfo },
                },
                ByBinderID = new()
                {
                    [1] = new List<FmgType> { FmgType.TalkMsg },
                    [2] = new List<FmgType> { FmgType.BloodMsg },
                    [3] = new List<FmgType> { FmgType.MovieSubtitle },
                    [4] = new List<FmgType> { FmgType.CauseOfDeath },
                    [10] = new List<FmgType> { FmgType.GoodsName },
                    [11] = new List<FmgType> { FmgType.WeaponName },
                    [12] = new List<FmgType> { FmgType.ProtectorName },
                    [13] = new List<FmgType> { FmgType.AccessoryName },
                    [14] = new List<FmgType> { FmgType.MagicName },
                    [18] = new List<FmgType> { FmgType.NpcName },
                    [19] = new List<FmgType> { FmgType.PlaceName },
                    [20] = new List<FmgType> { FmgType.GoodsInfo },
                    [21] = new List<FmgType> { FmgType.WeaponInfo },
                    [22] = new List<FmgType> { FmgType.ProtectorInfo },
                    [23] = new List<FmgType> { FmgType.AccessoryInfo },
                    [24] = new List<FmgType> { FmgType.GoodsCaption },
                    [25] = new List<FmgType> { FmgType.WeaponCaption },
                    [26] = new List<FmgType> { FmgType.ProtectorCaption },
                    [27] = new List<FmgType> { FmgType.AccessoryCaption },
                    [28] = new List<FmgType> { FmgType.MagicInfo },
                    [29] = new List<FmgType> { FmgType.MagicCaption },
                    [30] = new List<FmgType> { FmgType.EventText },
                    [31] = new List<FmgType> { FmgType.GemName },
                    [32] = new List<FmgType> { FmgType.GemInfo },
                    [33] = new List<FmgType> { FmgType.GemCaption },
                    [34] = new List<FmgType> { FmgType.GemPrefix },
                    [35] = new List<FmgType> { FmgType.GemEffect },
                    [70] = new List<FmgType> { FmgType.InGameMenu },
                    [76] = new List<FmgType> { FmgType.MenuGeneralText },
                    [77] = new List<FmgType> { FmgType.MenuOther },
                    [78] = new List<FmgType> { FmgType.Dialogues },
                    [79] = new List<FmgType> { FmgType.KeyGuide },
                    [80] = new List<FmgType> { FmgType.LineHelp },
                    [90] = new List<FmgType> { FmgType.TextDisplayTagList },
                    [91] = new List<FmgType> { FmgType.SystemTagsWindows },
                    [92] = new List<FmgType> { FmgType.SystemMessageWindows },
                    [200] = new List<FmgType> { FmgType.GameMenuText },
                    [201] = new List<FmgType> { FmgType.GameLineHelp },
                    [202] = new List<FmgType> { FmgType.GameKeyGuide },
                    [203] = new List<FmgType> { FmgType.GameSystemMessageWindows },
                    [204] = new List<FmgType> { FmgType.GameDialogues },
                },
                ToLanguageEnum = new()
                {
                    ["dandk"] = FmgLanguage.Danish,
                    ["deude"] = FmgLanguage.German,
                    ["enggb"] = FmgLanguage.BritishEnglish,
                    ["engus"] = FmgLanguage.English,
                    ["finfi"] = FmgLanguage.Finnish,
                    ["frafr"] = FmgLanguage.French,
                    ["itait"] = FmgLanguage.Italian,
                    ["jpnjp"] = FmgLanguage.Japanese,
                    ["korkr"] = FmgLanguage.Korean,
                    ["nldnl"] = FmgLanguage.Dutch,
                    ["norno"] = FmgLanguage.Norwegian,
                    ["polpl"] = FmgLanguage.Polish,
                    ["porbr"] = FmgLanguage.BrazilPortuguese,
                    ["porpt"] = FmgLanguage.PortugalPortuguese,
                    ["rusru"] = FmgLanguage.Russian,
                    ["spaar"] = FmgLanguage.Spanish,
                    ["spaes"] = FmgLanguage.SpainSpanish,
                    ["swese"] = FmgLanguage.Swedish,
                    ["turtr"] = FmgLanguage.Turkish,
                    ["zhocn"] = FmgLanguage.SimplifiedChinese,
                    ["zhotw"] = FmgLanguage.TraditionalChinese,
                },
                FromLanguageEnum = new()
                {
                    [FmgLanguage.Danish] = "dandk",
                    [FmgLanguage.German] = "deude",
                    [FmgLanguage.BritishEnglish] = "enggb",
                    [FmgLanguage.English] = "engus",
                    [FmgLanguage.Finnish] = "finfi",
                    [FmgLanguage.French] = "frafr",
                    [FmgLanguage.Italian] = "itait",
                    [FmgLanguage.Japanese] = "jpnjp",
                    [FmgLanguage.Korean] = "korkr",
                    [FmgLanguage.Dutch] = "nldnl",
                    [FmgLanguage.Norwegian] = "norno",
                    [FmgLanguage.Polish] = "polpl",
                    [FmgLanguage.BrazilPortuguese] = "porbr",
                    [FmgLanguage.PortugalPortuguese] = "porpt",
                    [FmgLanguage.Russian] = "rusru",
                    [FmgLanguage.Spanish] = "spaar",
                    [FmgLanguage.SpainSpanish] = "spaes",
                    [FmgLanguage.Swedish] = "swese",
                    [FmgLanguage.Turkish] = "turtr",
                    [FmgLanguage.SimplifiedChinese] = "zhocn",
                    [FmgLanguage.TraditionalChinese] = "zhotw",
                },
            },
            [FromSoftGame.DarkSouls3] = new FmgGameInfo
            {
                ByType = new()
                {
                    [FmgType.AccessoryCaption] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.AccessoryCaption, FmgType.AccessoryCaption, "アクセサリうんちく", 27),
                    [FmgType.AccessoryCaption_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.AccessoryCaption_DLC1, FmgType.AccessoryCaption, "アクセサリうんちく_dlc1", 224),
                    [FmgType.AccessoryCaption_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.AccessoryCaption_DLC2, FmgType.AccessoryCaption, "アクセサリうんちく_dlc2", 264),
                    [FmgType.AccessoryInfo] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.AccessoryInfo, FmgType.AccessoryInfo, "アクセサリ説明", 23),
                    [FmgType.AccessoryInfo_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.AccessoryInfo_DLC1, FmgType.AccessoryInfo, "アクセサリ説明_dlc1", 220),
                    [FmgType.AccessoryInfo_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.AccessoryInfo_DLC2, FmgType.AccessoryInfo, "アクセサリ説明_dlc2", 260),
                    [FmgType.AccessoryName] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.AccessoryName, FmgType.AccessoryName, "アクセサリ名", 13),
                    [FmgType.AccessoryName_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.AccessoryName_DLC1, FmgType.AccessoryName, "アクセサリ名_dlc1", 213),
                    [FmgType.AccessoryName_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.AccessoryName_DLC2, FmgType.AccessoryName, "アクセサリ名_dlc2", 253),
                    [FmgType.BloodMsg] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.BloodMsg, FmgType.BloodMsg, "血文字", 2),
                    [FmgType.BloodMsg_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.BloodMsg_DLC1, FmgType.BloodMsg, "血文字_dlc1", 239),
                    [FmgType.BloodMsg_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.BloodMsg_DLC2, FmgType.BloodMsg, "血文字_dlc2", 279),
                    [FmgType.Dialogues] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.Dialogues, FmgType.Dialogues, "ダイアログ", 78),
                    [FmgType.EventText] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.EventText, FmgType.EventText, "イベントテキスト", 30),
                    [FmgType.EventText_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.EventText_DLC1, FmgType.EventText, "イベントテキスト_dlc1", 231),
                    [FmgType.EventText_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.EventText_DLC2, FmgType.EventText, "イベントテキスト_dlc2", 271),
                    [FmgType.GameDialogues] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameDialogues, FmgType.GameDialogues, "FDP_ダイアログ", 204),
                    [FmgType.GameDialogues_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameDialogues_DLC1, FmgType.GameDialogues, "FDP_ダイアログ_dlc1", 236),
                    [FmgType.GameDialogues_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameDialogues_DLC2, FmgType.GameDialogues, "FDP_ダイアログ_dlc2", 276),
                    [FmgType.GameKeyGuide] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameKeyGuide, FmgType.GameKeyGuide, "FDP_キーガイド", 202),
                    [FmgType.GameLineHelp] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameLineHelp, FmgType.GameLineHelp, "FDP_一行ヘルプ", 201),
                    [FmgType.GameLineHelp_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameLineHelp_DLC1, FmgType.GameLineHelp, "FDP_一行ヘルプ_dlc1", 233),
                    [FmgType.GameLineHelp_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameLineHelp_DLC2, FmgType.GameLineHelp, "FDP_一行ヘルプ_dlc2", 273),
                    [FmgType.GameMenuText] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameMenuText, FmgType.GameMenuText, "FDP_メニューテキスト", 200),
                    [FmgType.GameMenuText_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameMenuText_DLC1, FmgType.GameMenuText, "FDP_メニューテキスト_dlc1", 232),
                    [FmgType.GameMenuText_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameMenuText_DLC2, FmgType.GameMenuText, "FDP_メニューテキスト_dlc2", 272),
                    [FmgType.GameSystemMessagePS4] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameSystemMessagePS4, FmgType.GameSystemMessagePS4, "FDP_システムメッセージ_ps4", 205),
                    [FmgType.GameSystemMessagePS4_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameSystemMessagePS4_DLC1, FmgType.GameSystemMessagePS4, "FDP_システムメッセージ_ps4_dlc1", 237),
                    [FmgType.GameSystemMessagePS4_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameSystemMessagePS4_DLC2, FmgType.GameSystemMessagePS4, "FDP_システムメッセージ_ps4_dlc2", 277),
                    [FmgType.GameSystemMessageWindows] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameSystemMessageWindows, FmgType.GameSystemMessageWindows, "FDP_システムメッセージ_win64", 203),
                    [FmgType.GameSystemMessageWindows_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameSystemMessageWindows_DLC1, FmgType.GameSystemMessageWindows, "FDP_システムメッセージ_win64_dlc1", 235),
                    [FmgType.GameSystemMessageWindows_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameSystemMessageWindows_DLC2, FmgType.GameSystemMessageWindows, "FDP_システムメッセージ_win64_dlc2", 275),
                    [FmgType.GameSystemMessageXboxOne] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameSystemMessageXboxOne, FmgType.GameSystemMessageXboxOne, "FDP_システムメッセージ_xboxone", 206),
                    [FmgType.GameSystemMessageXboxOne_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameSystemMessageXboxOne_DLC1, FmgType.GameSystemMessageXboxOne, "FDP_システムメッセージ_xboxone_dlc1", 238),
                    [FmgType.GameSystemMessageXboxOne_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.GameSystemMessageXboxOne_DLC2, FmgType.GameSystemMessageXboxOne, "FDP_システムメッセージ_xboxone_dlc2", 278),
                    [FmgType.GoodsCaption] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.GoodsCaption, FmgType.GoodsCaption, "アイテムうんちく", 24),
                    [FmgType.GoodsCaption_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.GoodsCaption_DLC1, FmgType.GoodsCaption, "アイテムうんちく_dlc1", 221),
                    [FmgType.GoodsCaption_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.GoodsCaption_DLC2, FmgType.GoodsCaption, "アイテムうんちく_dlc2", 261),
                    [FmgType.GoodsInfo] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.GoodsInfo, FmgType.GoodsInfo, "アイテム説明", 20),
                    [FmgType.GoodsInfo_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.GoodsInfo_DLC1, FmgType.GoodsInfo, "アイテム説明_dlc1", 217),
                    [FmgType.GoodsInfo_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.GoodsInfo_DLC2, FmgType.GoodsInfo, "アイテム説明_dlc2", 257),
                    [FmgType.GoodsName] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.GoodsName, FmgType.GoodsName, "アイテム名", 10),
                    [FmgType.GoodsName_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.GoodsName_DLC1, FmgType.GoodsName, "アイテム名_dlc1", 210),
                    [FmgType.GoodsName_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.GoodsName_DLC2, FmgType.GoodsName, "アイテム名_dlc2", 250),
                    [FmgType.InGameMenu] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.InGameMenu, FmgType.InGameMenu, "インゲームメニュー", 70),
                    [FmgType.KeyGuide] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.KeyGuide, FmgType.KeyGuide, "キーガイド", 79),
                    [FmgType.LineHelp] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.LineHelp, FmgType.LineHelp, "一行ヘルプ", 80),
                    [FmgType.MagicCaption] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.MagicCaption, FmgType.MagicCaption, "魔法うんちく", 29),
                    [FmgType.MagicCaption_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.MagicCaption_DLC1, FmgType.MagicCaption, "魔法うんちく_dlc1", 226),
                    [FmgType.MagicCaption_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.MagicCaption_DLC2, FmgType.MagicCaption, "魔法うんちく_dlc2", 266),
                    [FmgType.MagicInfo] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.MagicInfo, FmgType.MagicInfo, "魔法説明", 28),
                    [FmgType.MagicInfo_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.MagicInfo_DLC1, FmgType.MagicInfo, "魔法説明_dlc1", 225),
                    [FmgType.MagicInfo_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.MagicInfo_DLC2, FmgType.MagicInfo, "魔法説明_dlc2", 265),
                    [FmgType.MagicName] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.MagicName, FmgType.MagicName, "魔法名", 14),
                    [FmgType.MagicName_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.MagicName_DLC1, FmgType.MagicName, "魔法名_dlc1", 214),
                    [FmgType.MagicName_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.MagicName_DLC2, FmgType.MagicName, "魔法名_dlc2", 254),
                    [FmgType.MenuContext] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.MenuContext, FmgType.MenuContext, "項目ヘルプ", 81),
                    [FmgType.MenuGeneralText] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.MenuGeneralText, FmgType.MenuGeneralText, "メニュー共通テキスト", 76),
                    [FmgType.MenuOther] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.MenuOther, FmgType.MenuOther, "メニューその他", 77),
                    [FmgType.MovieSubtitle] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.MovieSubtitle, FmgType.MovieSubtitle, "ムービー字幕", 3),
                    [FmgType.NpcName] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.NpcName, FmgType.NpcName, "NPC名", 18),
                    [FmgType.NpcName_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.NpcName_DLC1, FmgType.NpcName, "NPC名_dlc1", 215),
                    [FmgType.NpcName_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.NpcName_DLC2, FmgType.NpcName, "NPC名_dlc2", 255),
                    [FmgType.PlaceName] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.PlaceName, FmgType.PlaceName, "地名", 19),
                    [FmgType.PlaceName_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.PlaceName_DLC1, FmgType.PlaceName, "地名_dlc1", 216),
                    [FmgType.PlaceName_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.PlaceName_DLC2, FmgType.PlaceName, "地名_dlc2", 256),
                    [FmgType.ProtectorCaption] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.ProtectorCaption, FmgType.ProtectorCaption, "防具うんちく", 26),
                    [FmgType.ProtectorCaption_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.ProtectorCaption_DLC1, FmgType.ProtectorCaption, "防具うんちく_dlc1", 223),
                    [FmgType.ProtectorCaption_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.ProtectorCaption_DLC2, FmgType.ProtectorCaption, "防具うんちく_dlc2", 263),
                    [FmgType.ProtectorInfo] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.ProtectorInfo, FmgType.ProtectorInfo, "防具説明", 22),
                    [FmgType.ProtectorName] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.ProtectorName, FmgType.ProtectorName, "防具名", 12),
                    [FmgType.ProtectorName_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.ProtectorName_DLC1, FmgType.ProtectorName, "防具名_dlc1", 212),
                    [FmgType.ProtectorName_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.ProtectorName_DLC2, FmgType.ProtectorName, "防具名_dlc2", 252),
                    [FmgType.Skills] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.Skills, FmgType.Skills, "戦技種別", 40),
                    [FmgType.TalkMsg] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.TalkMsg, FmgType.TalkMsg, "会話", 1),
                    [FmgType.TalkMsg_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.TalkMsg_DLC1, FmgType.TalkMsg, "会話_dlc1", 230),
                    [FmgType.TalkMsg_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.TalkMsg_DLC2, FmgType.TalkMsg, "会話_dlc2", 270),
                    [FmgType.TextDisplayTagList] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Menu, FmgType.TextDisplayTagList, FmgType.TextDisplayTagList, "テキスト表示用タグ一覧", 90),
                    [FmgType.WeaponCaption] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.WeaponCaption, FmgType.WeaponCaption, "武器うんちく", 25),
                    [FmgType.WeaponCaption_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.WeaponCaption_DLC1, FmgType.WeaponCaption, "武器うんちく_dlc1", 222),
                    [FmgType.WeaponCaption_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.WeaponCaption_DLC2, FmgType.WeaponCaption, "武器うんちく_dlc2", 262),
                    [FmgType.WeaponInfo] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.WeaponInfo, FmgType.WeaponInfo, "武器説明", 21),
                    [FmgType.WeaponName] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.WeaponName, FmgType.WeaponName, "武器名", 11),
                    [FmgType.WeaponName_DLC1] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.WeaponName_DLC1, FmgType.WeaponName, "武器名_dlc1", 211),
                    [FmgType.WeaponName_DLC2] = new FmgKeyInfo(FromSoftGame.DarkSouls3, FmgCategory.Item, FmgType.WeaponName_DLC2, FmgType.WeaponName, "武器名_dlc2", 251),
                },
                Overrides = new()
                {
                    [FmgType.AccessoryCaption] = new List<FmgType> { FmgType.AccessoryCaption_DLC2, FmgType.AccessoryCaption_DLC1 },
                    [FmgType.AccessoryInfo] = new List<FmgType> { FmgType.AccessoryInfo_DLC2, FmgType.AccessoryInfo_DLC1 },
                    [FmgType.AccessoryName] = new List<FmgType> { FmgType.AccessoryName_DLC2, FmgType.AccessoryName_DLC1 },
                    [FmgType.BloodMsg] = new List<FmgType> { FmgType.BloodMsg_DLC2, FmgType.BloodMsg_DLC1 },
                    [FmgType.EventText] = new List<FmgType> { FmgType.EventText_DLC2, FmgType.EventText_DLC1 },
                    [FmgType.GameDialogues] = new List<FmgType> { FmgType.GameDialogues_DLC2, FmgType.GameDialogues_DLC1 },
                    [FmgType.GameLineHelp] = new List<FmgType> { FmgType.GameLineHelp_DLC2, FmgType.GameLineHelp_DLC1 },
                    [FmgType.GameMenuText] = new List<FmgType> { FmgType.GameMenuText_DLC2, FmgType.GameMenuText_DLC1 },
                    [FmgType.GameSystemMessagePS4] = new List<FmgType> { FmgType.GameSystemMessagePS4_DLC2, FmgType.GameSystemMessagePS4_DLC1 },
                    [FmgType.GameSystemMessageWindows] = new List<FmgType> { FmgType.GameSystemMessageWindows_DLC2, FmgType.GameSystemMessageWindows_DLC1 },
                    [FmgType.GameSystemMessageXboxOne] = new List<FmgType> { FmgType.GameSystemMessageXboxOne_DLC2, FmgType.GameSystemMessageXboxOne_DLC1 },
                    [FmgType.GoodsCaption] = new List<FmgType> { FmgType.GoodsCaption_DLC2, FmgType.GoodsCaption_DLC1 },
                    [FmgType.GoodsInfo] = new List<FmgType> { FmgType.GoodsInfo_DLC2, FmgType.GoodsInfo_DLC1 },
                    [FmgType.GoodsName] = new List<FmgType> { FmgType.GoodsName_DLC2, FmgType.GoodsName_DLC1 },
                    [FmgType.MagicCaption] = new List<FmgType> { FmgType.MagicCaption_DLC2, FmgType.MagicCaption_DLC1 },
                    [FmgType.MagicInfo] = new List<FmgType> { FmgType.MagicInfo_DLC2, FmgType.MagicInfo_DLC1 },
                    [FmgType.MagicName] = new List<FmgType> { FmgType.MagicName_DLC2, FmgType.MagicName_DLC1 },
                    [FmgType.NpcName] = new List<FmgType> { FmgType.NpcName_DLC2, FmgType.NpcName_DLC1 },
                    [FmgType.PlaceName] = new List<FmgType> { FmgType.PlaceName_DLC2, FmgType.PlaceName_DLC1 },
                    [FmgType.ProtectorCaption] = new List<FmgType> { FmgType.ProtectorCaption_DLC2, FmgType.ProtectorCaption_DLC1 },
                    [FmgType.ProtectorName] = new List<FmgType> { FmgType.ProtectorName_DLC2, FmgType.ProtectorName_DLC1 },
                    [FmgType.TalkMsg] = new List<FmgType> { FmgType.TalkMsg_DLC2, FmgType.TalkMsg_DLC1 },
                    [FmgType.WeaponCaption] = new List<FmgType> { FmgType.WeaponCaption_DLC2, FmgType.WeaponCaption_DLC1 },
                    [FmgType.WeaponName] = new List<FmgType> { FmgType.WeaponName_DLC2, FmgType.WeaponName_DLC1 },
                },
                ByFmgName = new()
                {
                    ["FDP_キーガイド"] = new List<FmgType> { FmgType.GameKeyGuide },
                    ["FDP_システムメッセージ_ps4_dlc1"] = new List<FmgType> { FmgType.GameSystemMessagePS4_DLC1 },
                    ["FDP_システムメッセージ_ps4_dlc2"] = new List<FmgType> { FmgType.GameSystemMessagePS4_DLC2 },
                    ["FDP_システムメッセージ_ps4"] = new List<FmgType> { FmgType.GameSystemMessagePS4 },
                    ["FDP_システムメッセージ_win64_dlc1"] = new List<FmgType> { FmgType.GameSystemMessageWindows_DLC1 },
                    ["FDP_システムメッセージ_win64_dlc2"] = new List<FmgType> { FmgType.GameSystemMessageWindows_DLC2 },
                    ["FDP_システムメッセージ_win64"] = new List<FmgType> { FmgType.GameSystemMessageWindows },
                    ["FDP_システムメッセージ_xboxone_dlc1"] = new List<FmgType> { FmgType.GameSystemMessageXboxOne_DLC1 },
                    ["FDP_システムメッセージ_xboxone_dlc2"] = new List<FmgType> { FmgType.GameSystemMessageXboxOne_DLC2 },
                    ["FDP_システムメッセージ_xboxone"] = new List<FmgType> { FmgType.GameSystemMessageXboxOne },
                    ["FDP_ダイアログ_dlc1"] = new List<FmgType> { FmgType.GameDialogues_DLC1 },
                    ["FDP_ダイアログ_dlc2"] = new List<FmgType> { FmgType.GameDialogues_DLC2 },
                    ["FDP_ダイアログ"] = new List<FmgType> { FmgType.GameDialogues },
                    ["FDP_メニューテキスト_dlc1"] = new List<FmgType> { FmgType.GameMenuText_DLC1 },
                    ["FDP_メニューテキスト_dlc2"] = new List<FmgType> { FmgType.GameMenuText_DLC2 },
                    ["FDP_メニューテキスト"] = new List<FmgType> { FmgType.GameMenuText },
                    ["FDP_一行ヘルプ_dlc1"] = new List<FmgType> { FmgType.GameLineHelp_DLC1 },
                    ["FDP_一行ヘルプ_dlc2"] = new List<FmgType> { FmgType.GameLineHelp_DLC2 },
                    ["FDP_一行ヘルプ"] = new List<FmgType> { FmgType.GameLineHelp },
                    ["NPC名_dlc1"] = new List<FmgType> { FmgType.NpcName_DLC1 },
                    ["NPC名_dlc2"] = new List<FmgType> { FmgType.NpcName_DLC2 },
                    ["NPC名"] = new List<FmgType> { FmgType.NpcName },
                    ["アイテムうんちく_dlc1"] = new List<FmgType> { FmgType.GoodsCaption_DLC1 },
                    ["アイテムうんちく_dlc2"] = new List<FmgType> { FmgType.GoodsCaption_DLC2 },
                    ["アイテムうんちく"] = new List<FmgType> { FmgType.GoodsCaption },
                    ["アイテム名_dlc1"] = new List<FmgType> { FmgType.GoodsName_DLC1 },
                    ["アイテム名_dlc2"] = new List<FmgType> { FmgType.GoodsName_DLC2 },
                    ["アイテム名"] = new List<FmgType> { FmgType.GoodsName },
                    ["アイテム説明_dlc1"] = new List<FmgType> { FmgType.GoodsInfo_DLC1 },
                    ["アイテム説明_dlc2"] = new List<FmgType> { FmgType.GoodsInfo_DLC2 },
                    ["アイテム説明"] = new List<FmgType> { FmgType.GoodsInfo },
                    ["アクセサリうんちく_dlc1"] = new List<FmgType> { FmgType.AccessoryCaption_DLC1 },
                    ["アクセサリうんちく_dlc2"] = new List<FmgType> { FmgType.AccessoryCaption_DLC2 },
                    ["アクセサリうんちく"] = new List<FmgType> { FmgType.AccessoryCaption },
                    ["アクセサリ名_dlc1"] = new List<FmgType> { FmgType.AccessoryName_DLC1 },
                    ["アクセサリ名_dlc2"] = new List<FmgType> { FmgType.AccessoryName_DLC2 },
                    ["アクセサリ名"] = new List<FmgType> { FmgType.AccessoryName },
                    ["アクセサリ説明_dlc1"] = new List<FmgType> { FmgType.AccessoryInfo_DLC1 },
                    ["アクセサリ説明_dlc2"] = new List<FmgType> { FmgType.AccessoryInfo_DLC2 },
                    ["アクセサリ説明"] = new List<FmgType> { FmgType.AccessoryInfo },
                    ["イベントテキスト_dlc1"] = new List<FmgType> { FmgType.EventText_DLC1 },
                    ["イベントテキスト_dlc2"] = new List<FmgType> { FmgType.EventText_DLC2 },
                    ["イベントテキスト"] = new List<FmgType> { FmgType.EventText },
                    ["インゲームメニュー"] = new List<FmgType> { FmgType.InGameMenu },
                    ["キーガイド"] = new List<FmgType> { FmgType.KeyGuide },
                    ["ダイアログ"] = new List<FmgType> { FmgType.Dialogues },
                    ["テキスト表示用タグ一覧"] = new List<FmgType> { FmgType.TextDisplayTagList },
                    ["ムービー字幕"] = new List<FmgType> { FmgType.MovieSubtitle },
                    ["メニューその他"] = new List<FmgType> { FmgType.MenuOther },
                    ["メニュー共通テキスト"] = new List<FmgType> { FmgType.MenuGeneralText },
                    ["一行ヘルプ"] = new List<FmgType> { FmgType.LineHelp },
                    ["会話_dlc1"] = new List<FmgType> { FmgType.TalkMsg_DLC1 },
                    ["会話_dlc2"] = new List<FmgType> { FmgType.TalkMsg_DLC2 },
                    ["会話"] = new List<FmgType> { FmgType.TalkMsg },
                    ["地名_dlc1"] = new List<FmgType> { FmgType.PlaceName_DLC1 },
                    ["地名_dlc2"] = new List<FmgType> { FmgType.PlaceName_DLC2 },
                    ["地名"] = new List<FmgType> { FmgType.PlaceName },
                    ["戦技種別"] = new List<FmgType> { FmgType.Skills },
                    ["武器うんちく_dlc1"] = new List<FmgType> { FmgType.WeaponCaption_DLC1 },
                    ["武器うんちく_dlc2"] = new List<FmgType> { FmgType.WeaponCaption_DLC2 },
                    ["武器うんちく"] = new List<FmgType> { FmgType.WeaponCaption },
                    ["武器名_dlc1"] = new List<FmgType> { FmgType.WeaponName_DLC1 },
                    ["武器名_dlc2"] = new List<FmgType> { FmgType.WeaponName_DLC2 },
                    ["武器名"] = new List<FmgType> { FmgType.WeaponName },
                    ["武器説明"] = new List<FmgType> { FmgType.WeaponInfo },
                    ["血文字_dlc1"] = new List<FmgType> { FmgType.BloodMsg_DLC1 },
                    ["血文字_dlc2"] = new List<FmgType> { FmgType.BloodMsg_DLC2 },
                    ["血文字"] = new List<FmgType> { FmgType.BloodMsg },
                    ["防具うんちく_dlc1"] = new List<FmgType> { FmgType.ProtectorCaption_DLC1 },
                    ["防具うんちく_dlc2"] = new List<FmgType> { FmgType.ProtectorCaption_DLC2 },
                    ["防具うんちく"] = new List<FmgType> { FmgType.ProtectorCaption },
                    ["防具名_dlc1"] = new List<FmgType> { FmgType.ProtectorName_DLC1 },
                    ["防具名_dlc2"] = new List<FmgType> { FmgType.ProtectorName_DLC2 },
                    ["防具名"] = new List<FmgType> { FmgType.ProtectorName },
                    ["防具説明"] = new List<FmgType> { FmgType.ProtectorInfo },
                    ["項目ヘルプ"] = new List<FmgType> { FmgType.MenuContext },
                    ["魔法うんちく_dlc1"] = new List<FmgType> { FmgType.MagicCaption_DLC1 },
                    ["魔法うんちく_dlc2"] = new List<FmgType> { FmgType.MagicCaption_DLC2 },
                    ["魔法うんちく"] = new List<FmgType> { FmgType.MagicCaption },
                    ["魔法名_dlc1"] = new List<FmgType> { FmgType.MagicName_DLC1 },
                    ["魔法名_dlc2"] = new List<FmgType> { FmgType.MagicName_DLC2 },
                    ["魔法名"] = new List<FmgType> { FmgType.MagicName },
                    ["魔法説明_dlc1"] = new List<FmgType> { FmgType.MagicInfo_DLC1 },
                    ["魔法説明_dlc2"] = new List<FmgType> { FmgType.MagicInfo_DLC2 },
                    ["魔法説明"] = new List<FmgType> { FmgType.MagicInfo },
                },
                ByBinderID = new()
                {
                    [1] = new List<FmgType> { FmgType.TalkMsg },
                    [2] = new List<FmgType> { FmgType.BloodMsg },
                    [3] = new List<FmgType> { FmgType.MovieSubtitle },
                    [10] = new List<FmgType> { FmgType.GoodsName },
                    [11] = new List<FmgType> { FmgType.WeaponName },
                    [12] = new List<FmgType> { FmgType.ProtectorName },
                    [13] = new List<FmgType> { FmgType.AccessoryName },
                    [14] = new List<FmgType> { FmgType.MagicName },
                    [18] = new List<FmgType> { FmgType.NpcName },
                    [19] = new List<FmgType> { FmgType.PlaceName },
                    [20] = new List<FmgType> { FmgType.GoodsInfo },
                    [21] = new List<FmgType> { FmgType.WeaponInfo },
                    [22] = new List<FmgType> { FmgType.ProtectorInfo },
                    [23] = new List<FmgType> { FmgType.AccessoryInfo },
                    [24] = new List<FmgType> { FmgType.GoodsCaption },
                    [25] = new List<FmgType> { FmgType.WeaponCaption },
                    [26] = new List<FmgType> { FmgType.ProtectorCaption },
                    [27] = new List<FmgType> { FmgType.AccessoryCaption },
                    [28] = new List<FmgType> { FmgType.MagicInfo },
                    [29] = new List<FmgType> { FmgType.MagicCaption },
                    [30] = new List<FmgType> { FmgType.EventText },
                    [40] = new List<FmgType> { FmgType.Skills },
                    [70] = new List<FmgType> { FmgType.InGameMenu },
                    [76] = new List<FmgType> { FmgType.MenuGeneralText },
                    [77] = new List<FmgType> { FmgType.MenuOther },
                    [78] = new List<FmgType> { FmgType.Dialogues },
                    [79] = new List<FmgType> { FmgType.KeyGuide },
                    [80] = new List<FmgType> { FmgType.LineHelp },
                    [81] = new List<FmgType> { FmgType.MenuContext },
                    [90] = new List<FmgType> { FmgType.TextDisplayTagList },
                    [200] = new List<FmgType> { FmgType.GameMenuText },
                    [201] = new List<FmgType> { FmgType.GameLineHelp },
                    [202] = new List<FmgType> { FmgType.GameKeyGuide },
                    [203] = new List<FmgType> { FmgType.GameSystemMessageWindows },
                    [204] = new List<FmgType> { FmgType.GameDialogues },
                    [205] = new List<FmgType> { FmgType.GameSystemMessagePS4 },
                    [206] = new List<FmgType> { FmgType.GameSystemMessageXboxOne },
                    [210] = new List<FmgType> { FmgType.GoodsName_DLC1 },
                    [211] = new List<FmgType> { FmgType.WeaponName_DLC1 },
                    [212] = new List<FmgType> { FmgType.ProtectorName_DLC1 },
                    [213] = new List<FmgType> { FmgType.AccessoryName_DLC1 },
                    [214] = new List<FmgType> { FmgType.MagicName_DLC1 },
                    [215] = new List<FmgType> { FmgType.NpcName_DLC1 },
                    [216] = new List<FmgType> { FmgType.PlaceName_DLC1 },
                    [217] = new List<FmgType> { FmgType.GoodsInfo_DLC1 },
                    [220] = new List<FmgType> { FmgType.AccessoryInfo_DLC1 },
                    [221] = new List<FmgType> { FmgType.GoodsCaption_DLC1 },
                    [222] = new List<FmgType> { FmgType.WeaponCaption_DLC1 },
                    [223] = new List<FmgType> { FmgType.ProtectorCaption_DLC1 },
                    [224] = new List<FmgType> { FmgType.AccessoryCaption_DLC1 },
                    [225] = new List<FmgType> { FmgType.MagicInfo_DLC1 },
                    [226] = new List<FmgType> { FmgType.MagicCaption_DLC1 },
                    [230] = new List<FmgType> { FmgType.TalkMsg_DLC1 },
                    [231] = new List<FmgType> { FmgType.EventText_DLC1 },
                    [232] = new List<FmgType> { FmgType.GameMenuText_DLC1 },
                    [233] = new List<FmgType> { FmgType.GameLineHelp_DLC1 },
                    [235] = new List<FmgType> { FmgType.GameSystemMessageWindows_DLC1 },
                    [236] = new List<FmgType> { FmgType.GameDialogues_DLC1 },
                    [237] = new List<FmgType> { FmgType.GameSystemMessagePS4_DLC1 },
                    [238] = new List<FmgType> { FmgType.GameSystemMessageXboxOne_DLC1 },
                    [239] = new List<FmgType> { FmgType.BloodMsg_DLC1 },
                    [250] = new List<FmgType> { FmgType.GoodsName_DLC2 },
                    [251] = new List<FmgType> { FmgType.WeaponName_DLC2 },
                    [252] = new List<FmgType> { FmgType.ProtectorName_DLC2 },
                    [253] = new List<FmgType> { FmgType.AccessoryName_DLC2 },
                    [254] = new List<FmgType> { FmgType.MagicName_DLC2 },
                    [255] = new List<FmgType> { FmgType.NpcName_DLC2 },
                    [256] = new List<FmgType> { FmgType.PlaceName_DLC2 },
                    [257] = new List<FmgType> { FmgType.GoodsInfo_DLC2 },
                    [260] = new List<FmgType> { FmgType.AccessoryInfo_DLC2 },
                    [261] = new List<FmgType> { FmgType.GoodsCaption_DLC2 },
                    [262] = new List<FmgType> { FmgType.WeaponCaption_DLC2 },
                    [263] = new List<FmgType> { FmgType.ProtectorCaption_DLC2 },
                    [264] = new List<FmgType> { FmgType.AccessoryCaption_DLC2 },
                    [265] = new List<FmgType> { FmgType.MagicInfo_DLC2 },
                    [266] = new List<FmgType> { FmgType.MagicCaption_DLC2 },
                    [270] = new List<FmgType> { FmgType.TalkMsg_DLC2 },
                    [271] = new List<FmgType> { FmgType.EventText_DLC2 },
                    [272] = new List<FmgType> { FmgType.GameMenuText_DLC2 },
                    [273] = new List<FmgType> { FmgType.GameLineHelp_DLC2 },
                    [275] = new List<FmgType> { FmgType.GameSystemMessageWindows_DLC2 },
                    [276] = new List<FmgType> { FmgType.GameDialogues_DLC2 },
                    [277] = new List<FmgType> { FmgType.GameSystemMessagePS4_DLC2 },
                    [278] = new List<FmgType> { FmgType.GameSystemMessageXboxOne_DLC2 },
                    [279] = new List<FmgType> { FmgType.BloodMsg_DLC2 },
                },
                ToLanguageEnum = new()
                {
                    ["deude"] = FmgLanguage.German,
                    ["engus"] = FmgLanguage.English,
                    ["frafr"] = FmgLanguage.French,
                    ["itait"] = FmgLanguage.Italian,
                    ["jpnjp"] = FmgLanguage.Japanese,
                    ["korkr"] = FmgLanguage.Korean,
                    ["polpl"] = FmgLanguage.Polish,
                    ["porbr"] = FmgLanguage.BrazilPortuguese,
                    ["rusru"] = FmgLanguage.Russian,
                    ["spaar"] = FmgLanguage.Spanish,
                    ["spaes"] = FmgLanguage.SpainSpanish,
                    ["zhocn"] = FmgLanguage.SimplifiedChinese,
                    ["zhotw"] = FmgLanguage.TraditionalChinese,
                },
                FromLanguageEnum = new()
                {
                    [FmgLanguage.German] = "deude",
                    [FmgLanguage.English] = "engus",
                    [FmgLanguage.French] = "frafr",
                    [FmgLanguage.Italian] = "itait",
                    [FmgLanguage.Japanese] = "jpnjp",
                    [FmgLanguage.Korean] = "korkr",
                    [FmgLanguage.Polish] = "polpl",
                    [FmgLanguage.BrazilPortuguese] = "porbr",
                    [FmgLanguage.Russian] = "rusru",
                    [FmgLanguage.Spanish] = "spaar",
                    [FmgLanguage.SpainSpanish] = "spaes",
                    [FmgLanguage.SimplifiedChinese] = "zhocn",
                    [FmgLanguage.TraditionalChinese] = "zhotw",
                },
            },
            [FromSoftGame.Sekiro] = new FmgGameInfo
            {
                ByType = new()
                {
                    [FmgType.AccessoryCaption] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.AccessoryCaption, FmgType.AccessoryCaption, "アクセサリうんちく", 27),
                    [FmgType.AccessoryInfo] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.AccessoryInfo, FmgType.AccessoryInfo, "アクセサリ説明", 23),
                    [FmgType.AccessoryName] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.AccessoryName, FmgType.AccessoryName, "アクセサリ名", 13),
                    [FmgType.BloodMsg] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.BloodMsg, FmgType.BloodMsg, "血文字", 2),
                    [FmgType.Dialogues] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.Dialogues, FmgType.Dialogues, "ダイアログ", 78),
                    [FmgType.EventText] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.EventText, FmgType.EventText, "イベントテキスト", 30),
                    [FmgType.GameDialogues] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.GameDialogues, FmgType.GameDialogues, "NTC_ダイアログ", 204),
                    [FmgType.GameKeyGuide] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.GameKeyGuide, FmgType.GameKeyGuide, "NTC_キーガイド", 202),
                    [FmgType.GameLineHelp] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.GameLineHelp, FmgType.GameLineHelp, "NTC_一行ヘルプ", 201),
                    [FmgType.GameMenuText] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.GameMenuText, FmgType.GameMenuText, "NTC_メニューテキスト", 200),
                    [FmgType.GameSystemMessageWindows] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.GameSystemMessageWindows, FmgType.GameSystemMessageWindows, "NTC_システムメッセージ_win64", 203),
                    [FmgType.GoodsCaption] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.GoodsCaption, FmgType.GoodsCaption, "アイテムうんちく", 24),
                    [FmgType.GoodsInfo] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.GoodsInfo, FmgType.GoodsInfo, "アイテム説明", 20),
                    [FmgType.GoodsName] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.GoodsName, FmgType.GoodsName, "アイテム名", 10),
                    [FmgType.InGameMenu] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.InGameMenu, FmgType.InGameMenu, "インゲームメニュー", 70),
                    [FmgType.KeyGuide] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.KeyGuide, FmgType.KeyGuide, "キーガイド", 79),
                    [FmgType.LineHelp] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.LineHelp, FmgType.LineHelp, "一行ヘルプ", 80),
                    [FmgType.LoadingText] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.LoadingText, FmgType.LoadingText, "ローディングテキスト", 205),
                    [FmgType.LoadingTitle] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.LoadingTitle, FmgType.LoadingTitle, "ローディングタイトル", 206),
                    [FmgType.MagicCaption] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.MagicCaption, FmgType.MagicCaption, "魔法うんちく", 29),
                    [FmgType.MagicInfo] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.MagicInfo, FmgType.MagicInfo, "魔法説明", 28),
                    [FmgType.MagicName] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.MagicName, FmgType.MagicName, "魔法名", 14),
                    [FmgType.MenuContext] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.MenuContext, FmgType.MenuContext, "項目ヘルプ", 81),
                    [FmgType.MenuGeneralText] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.MenuGeneralText, FmgType.MenuGeneralText, "メニュー共通テキスト", 76),
                    [FmgType.MenuOther] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.MenuOther, FmgType.MenuOther, "メニューその他", 77),
                    [FmgType.MovieSubtitle] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.MovieSubtitle, FmgType.MovieSubtitle, "ムービー字幕", 3),
                    [FmgType.NpcName] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.NpcName, FmgType.NpcName, "NPC名", 18),
                    [FmgType.PlaceName] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.PlaceName, FmgType.PlaceName, "地名", 19),
                    [FmgType.ProtectorCaption] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.ProtectorCaption, FmgType.ProtectorCaption, "防具うんちく", 26),
                    [FmgType.ProtectorInfo] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.ProtectorInfo, FmgType.ProtectorInfo, "防具説明", 22),
                    [FmgType.ProtectorName] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.ProtectorName, FmgType.ProtectorName, "防具名", 12),
                    [FmgType.Skills] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.Skills, FmgType.Skills, "戦技種別", 40),
                    [FmgType.TalkMsg] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.TalkMsg, FmgType.TalkMsg, "会話", 1),
                    [FmgType.TextDisplayTagList] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Menu, FmgType.TextDisplayTagList, FmgType.TextDisplayTagList, "テキスト表示用タグ一覧", 90),
                    [FmgType.WeaponCaption] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.WeaponCaption, FmgType.WeaponCaption, "武器うんちく", 25),
                    [FmgType.WeaponInfo] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.WeaponInfo, FmgType.WeaponInfo, "武器説明", 21),
                    [FmgType.WeaponName] = new FmgKeyInfo(FromSoftGame.Sekiro, FmgCategory.Item, FmgType.WeaponName, FmgType.WeaponName, "武器名", 11),
                },
                Overrides = new()
                {

                },
                ByFmgName = new()
                {
                    ["NPC名"] = new List<FmgType> { FmgType.NpcName },
                    ["NTC_キーガイド"] = new List<FmgType> { FmgType.GameKeyGuide },
                    ["NTC_システムメッセージ_win64"] = new List<FmgType> { FmgType.GameSystemMessageWindows },
                    ["NTC_ダイアログ"] = new List<FmgType> { FmgType.GameDialogues },
                    ["NTC_メニューテキスト"] = new List<FmgType> { FmgType.GameMenuText },
                    ["NTC_一行ヘルプ"] = new List<FmgType> { FmgType.GameLineHelp },
                    ["アイテムうんちく"] = new List<FmgType> { FmgType.GoodsCaption },
                    ["アイテム名"] = new List<FmgType> { FmgType.GoodsName },
                    ["アイテム説明"] = new List<FmgType> { FmgType.GoodsInfo },
                    ["アクセサリうんちく"] = new List<FmgType> { FmgType.AccessoryCaption },
                    ["アクセサリ名"] = new List<FmgType> { FmgType.AccessoryName },
                    ["アクセサリ説明"] = new List<FmgType> { FmgType.AccessoryInfo },
                    ["イベントテキスト"] = new List<FmgType> { FmgType.EventText },
                    ["インゲームメニュー"] = new List<FmgType> { FmgType.InGameMenu },
                    ["キーガイド"] = new List<FmgType> { FmgType.KeyGuide },
                    ["ダイアログ"] = new List<FmgType> { FmgType.Dialogues },
                    ["テキスト表示用タグ一覧"] = new List<FmgType> { FmgType.TextDisplayTagList },
                    ["ムービー字幕"] = new List<FmgType> { FmgType.MovieSubtitle },
                    ["メニューその他"] = new List<FmgType> { FmgType.MenuOther },
                    ["メニュー共通テキスト"] = new List<FmgType> { FmgType.MenuGeneralText },
                    ["ローディングタイトル"] = new List<FmgType> { FmgType.LoadingTitle },
                    ["ローディングテキスト"] = new List<FmgType> { FmgType.LoadingText },
                    ["一行ヘルプ"] = new List<FmgType> { FmgType.LineHelp },
                    ["会話"] = new List<FmgType> { FmgType.TalkMsg },
                    ["地名"] = new List<FmgType> { FmgType.PlaceName },
                    ["戦技種別"] = new List<FmgType> { FmgType.Skills },
                    ["武器うんちく"] = new List<FmgType> { FmgType.WeaponCaption },
                    ["武器名"] = new List<FmgType> { FmgType.WeaponName },
                    ["武器説明"] = new List<FmgType> { FmgType.WeaponInfo },
                    ["血文字"] = new List<FmgType> { FmgType.BloodMsg },
                    ["防具うんちく"] = new List<FmgType> { FmgType.ProtectorCaption },
                    ["防具名"] = new List<FmgType> { FmgType.ProtectorName },
                    ["防具説明"] = new List<FmgType> { FmgType.ProtectorInfo },
                    ["項目ヘルプ"] = new List<FmgType> { FmgType.MenuContext },
                    ["魔法うんちく"] = new List<FmgType> { FmgType.MagicCaption },
                    ["魔法名"] = new List<FmgType> { FmgType.MagicName },
                    ["魔法説明"] = new List<FmgType> { FmgType.MagicInfo },
                },
                ByBinderID = new()
                {
                    [1] = new List<FmgType> { FmgType.TalkMsg },
                    [2] = new List<FmgType> { FmgType.BloodMsg },
                    [3] = new List<FmgType> { FmgType.MovieSubtitle },
                    [10] = new List<FmgType> { FmgType.GoodsName },
                    [11] = new List<FmgType> { FmgType.WeaponName },
                    [12] = new List<FmgType> { FmgType.ProtectorName },
                    [13] = new List<FmgType> { FmgType.AccessoryName },
                    [14] = new List<FmgType> { FmgType.MagicName },
                    [18] = new List<FmgType> { FmgType.NpcName },
                    [19] = new List<FmgType> { FmgType.PlaceName },
                    [20] = new List<FmgType> { FmgType.GoodsInfo },
                    [21] = new List<FmgType> { FmgType.WeaponInfo },
                    [22] = new List<FmgType> { FmgType.ProtectorInfo },
                    [23] = new List<FmgType> { FmgType.AccessoryInfo },
                    [24] = new List<FmgType> { FmgType.GoodsCaption },
                    [25] = new List<FmgType> { FmgType.WeaponCaption },
                    [26] = new List<FmgType> { FmgType.ProtectorCaption },
                    [27] = new List<FmgType> { FmgType.AccessoryCaption },
                    [28] = new List<FmgType> { FmgType.MagicInfo },
                    [29] = new List<FmgType> { FmgType.MagicCaption },
                    [30] = new List<FmgType> { FmgType.EventText },
                    [40] = new List<FmgType> { FmgType.Skills },
                    [70] = new List<FmgType> { FmgType.InGameMenu },
                    [76] = new List<FmgType> { FmgType.MenuGeneralText },
                    [77] = new List<FmgType> { FmgType.MenuOther },
                    [78] = new List<FmgType> { FmgType.Dialogues },
                    [79] = new List<FmgType> { FmgType.KeyGuide },
                    [80] = new List<FmgType> { FmgType.LineHelp },
                    [81] = new List<FmgType> { FmgType.MenuContext },
                    [90] = new List<FmgType> { FmgType.TextDisplayTagList },
                    [200] = new List<FmgType> { FmgType.GameMenuText },
                    [201] = new List<FmgType> { FmgType.GameLineHelp },
                    [202] = new List<FmgType> { FmgType.GameKeyGuide },
                    [203] = new List<FmgType> { FmgType.GameSystemMessageWindows },
                    [204] = new List<FmgType> { FmgType.GameDialogues },
                    [205] = new List<FmgType> { FmgType.LoadingText },
                    [206] = new List<FmgType> { FmgType.LoadingTitle },
                },
                ToLanguageEnum = new()
                {
                    ["deude"] = FmgLanguage.German,
                    ["engus"] = FmgLanguage.English,
                    ["frafr"] = FmgLanguage.French,
                    ["itait"] = FmgLanguage.Italian,
                    ["jpnjp"] = FmgLanguage.Japanese,
                    ["korkr"] = FmgLanguage.Korean,
                    ["polpl"] = FmgLanguage.Polish,
                    ["porbr"] = FmgLanguage.BrazilPortuguese,
                    ["rusru"] = FmgLanguage.Russian,
                    ["spaar"] = FmgLanguage.Spanish,
                    ["spaes"] = FmgLanguage.SpainSpanish,
                    ["thath"] = FmgLanguage.Thai,
                    ["zhocn"] = FmgLanguage.SimplifiedChinese,
                    ["zhotw"] = FmgLanguage.TraditionalChinese,
                },
                FromLanguageEnum = new()
                {
                    [FmgLanguage.German] = "deude",
                    [FmgLanguage.English] = "engus",
                    [FmgLanguage.French] = "frafr",
                    [FmgLanguage.Italian] = "itait",
                    [FmgLanguage.Japanese] = "jpnjp",
                    [FmgLanguage.Korean] = "korkr",
                    [FmgLanguage.Polish] = "polpl",
                    [FmgLanguage.BrazilPortuguese] = "porbr",
                    [FmgLanguage.Russian] = "rusru",
                    [FmgLanguage.Spanish] = "spaar",
                    [FmgLanguage.SpainSpanish] = "spaes",
                    [FmgLanguage.Thai] = "thath",
                    [FmgLanguage.SimplifiedChinese] = "zhocn",
                    [FmgLanguage.TraditionalChinese] = "zhotw",
                },
            },
            [FromSoftGame.EldenRing] = new FmgGameInfo
            {
                ByType = new()
                {
                    [FmgType.AccessoryCaption] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.AccessoryCaption, FmgType.AccessoryCaption, "AccessoryCaption", 27),
                    [FmgType.AccessoryCaption_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.AccessoryCaption_DLC1, FmgType.AccessoryCaption, "AccessoryCaption_dlc01", 318),
                    [FmgType.AccessoryCaption_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.AccessoryCaption_DLC2, FmgType.AccessoryCaption, "AccessoryCaption_dlc02", 418),
                    [FmgType.AccessoryInfo] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.AccessoryInfo, FmgType.AccessoryInfo, "AccessoryInfo", 23),
                    [FmgType.AccessoryInfo_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.AccessoryInfo_DLC1, FmgType.AccessoryInfo, "AccessoryInfo_dlc01", 317),
                    [FmgType.AccessoryInfo_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.AccessoryInfo_DLC2, FmgType.AccessoryInfo, "AccessoryInfo_dlc02", 417),
                    [FmgType.AccessoryName] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.AccessoryName, FmgType.AccessoryName, "AccessoryName", 13),
                    [FmgType.AccessoryName_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.AccessoryName_DLC1, FmgType.AccessoryName, "AccessoryName_dlc01", 316),
                    [FmgType.AccessoryName_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.AccessoryName_DLC2, FmgType.AccessoryName, "AccessoryName_dlc02", 416),
                    [FmgType.ActionButtonText] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.ActionButtonText, FmgType.ActionButtonText, "ActionButtonText", 32),
                    [FmgType.ActionButtonText_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.ActionButtonText_DLC1, FmgType.ActionButtonText, "ActionButtonText_dlc01", 365),
                    [FmgType.ActionButtonText_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.ActionButtonText_DLC2, FmgType.ActionButtonText, "ActionButtonText_dlc02", 465),
                    [FmgType.ArtsCaption] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ArtsCaption, FmgType.ArtsCaption, "ArtsCaption", 43),
                    [FmgType.ArtsCaption_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ArtsCaption_DLC1, FmgType.ArtsCaption, "ArtsCaption_dlc01", 332),
                    [FmgType.ArtsCaption_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ArtsCaption_DLC2, FmgType.ArtsCaption, "ArtsCaption_dlc02", 432),
                    [FmgType.ArtsName] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ArtsName, FmgType.ArtsName, "ArtsName", 42),
                    [FmgType.ArtsName_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ArtsName_DLC1, FmgType.ArtsName, "ArtsName_dlc01", 331),
                    [FmgType.ArtsName_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ArtsName_DLC2, FmgType.ArtsName, "ArtsName_dlc02", 431),
                    [FmgType.BloodMsg] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.BloodMsg, FmgType.BloodMsg, "BloodMsg", 2),
                    [FmgType.BloodMsg_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.BloodMsg_DLC1, FmgType.BloodMsg, "BloodMsg_dlc01", 361),
                    [FmgType.BloodMsg_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.BloodMsg_DLC2, FmgType.BloodMsg, "BloodMsg_dlc02", 461),
                    [FmgType.EventTextForMap] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.EventTextForMap, FmgType.EventTextForMap, "EventTextForMap", 34),
                    [FmgType.EventTextForMap_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.EventTextForMap_DLC1, FmgType.EventTextForMap, "EventTextForMap_dlc01", 367),
                    [FmgType.EventTextForMap_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.EventTextForMap_DLC2, FmgType.EventTextForMap, "EventTextForMap_dlc02", 467),
                    [FmgType.EventTextForTalk] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.EventTextForTalk, FmgType.EventTextForTalk, "EventTextForTalk", 33),
                    [FmgType.EventTextForTalk_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.EventTextForTalk_DLC1, FmgType.EventTextForTalk, "EventTextForTalk_dlc01", 366),
                    [FmgType.EventTextForTalk_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.EventTextForTalk_DLC2, FmgType.EventTextForTalk, "EventTextForTalk_dlc02", 466),
                    [FmgType.GameDialogues] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameDialogues, FmgType.GameDialogues, "GR_Dialogues", 204),
                    [FmgType.GameDialogues_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameDialogues_DLC1, FmgType.GameDialogues, "GR_Dialogues_dlc01", 372),
                    [FmgType.GameDialogues_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameDialogues_DLC2, FmgType.GameDialogues, "GR_Dialogues_dlc02", 472),
                    [FmgType.GameKeyGuide] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameKeyGuide, FmgType.GameKeyGuide, "GR_KeyGuide", 202),
                    [FmgType.GameKeyGuide_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameKeyGuide_DLC1, FmgType.GameKeyGuide, "GR_KeyGuide_dlc01", 370),
                    [FmgType.GameKeyGuide_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameKeyGuide_DLC2, FmgType.GameKeyGuide, "GR_KeyGuide_dlc02", 470),
                    [FmgType.GameLineHelp] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameLineHelp, FmgType.GameLineHelp, "GR_LineHelp", 201),
                    [FmgType.GameLineHelp_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameLineHelp_DLC1, FmgType.GameLineHelp, "GR_LineHelp_dlc01", 369),
                    [FmgType.GameLineHelp_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameLineHelp_DLC2, FmgType.GameLineHelp, "GR_LineHelp_dlc02", 469),
                    [FmgType.GameMenuText] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameMenuText, FmgType.GameMenuText, "GR_MenuText", 200),
                    [FmgType.GameMenuText_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameMenuText_DLC1, FmgType.GameMenuText, "GR_MenuText_dlc01", 368),
                    [FmgType.GameMenuText_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameMenuText_DLC2, FmgType.GameMenuText, "GR_MenuText_dlc02", 468),
                    [FmgType.GameSystemMessageWindows] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameSystemMessageWindows, FmgType.GameSystemMessageWindows, "GR_System_Message_win64", 203),
                    [FmgType.GameSystemMessageWindows_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameSystemMessageWindows_DLC1, FmgType.GameSystemMessageWindows, "GR_System_Message_win64_dlc01", 371),
                    [FmgType.GameSystemMessageWindows_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.GameSystemMessageWindows_DLC2, FmgType.GameSystemMessageWindows, "GR_System_Message_win64_dlc02", 471),
                    [FmgType.GemCaption] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GemCaption, FmgType.GemCaption, "GemCaption", 37),
                    [FmgType.GemCaption_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GemCaption_DLC1, FmgType.GemCaption, "GemCaption_dlc01", 324),
                    [FmgType.GemCaption_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GemCaption_DLC2, FmgType.GemCaption, "GemCaption_dlc02", 424),
                    [FmgType.GemEffect] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GemEffect, FmgType.GemEffect, "GemEffect", 45),
                    [FmgType.GemEffect_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GemEffect_DLC1, FmgType.GemEffect, "GemEffect_dlc01", 334),
                    [FmgType.GemEffect_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GemEffect_DLC2, FmgType.GemEffect, "GemEffect_dlc02", 434),
                    [FmgType.GemInfo] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GemInfo, FmgType.GemInfo, "GemInfo", 36),
                    [FmgType.GemInfo_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GemInfo_DLC1, FmgType.GemInfo, "GemInfo_dlc01", 323),
                    [FmgType.GemInfo_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GemInfo_DLC2, FmgType.GemInfo, "GemInfo_dlc02", 423),
                    [FmgType.GemName] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GemName, FmgType.GemName, "GemName", 35),
                    [FmgType.GemName_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GemName_DLC1, FmgType.GemName, "GemName_dlc01", 322),
                    [FmgType.GemName_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GemName_DLC2, FmgType.GemName, "GemName_dlc02", 422),
                    [FmgType.GoodsCaption] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsCaption, FmgType.GoodsCaption, "GoodsCaption", 24),
                    [FmgType.GoodsCaption_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsCaption_DLC1, FmgType.GoodsCaption, "GoodsCaption_dlc01", 321),
                    [FmgType.GoodsCaption_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsCaption_DLC2, FmgType.GoodsCaption, "GoodsCaption_dlc02", 421),
                    [FmgType.GoodsDialog] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsDialog, FmgType.GoodsDialog, "GoodsDialog", 41),
                    [FmgType.GoodsDialog_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsDialog_DLC1, FmgType.GoodsDialog, "GoodsDialog_dlc01", 330),
                    [FmgType.GoodsDialog_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsDialog_DLC2, FmgType.GoodsDialog, "GoodsDialog_dlc02", 430),
                    [FmgType.GoodsInfo] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsInfo, FmgType.GoodsInfo, "GoodsInfo", 20),
                    [FmgType.GoodsInfo_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsInfo_DLC1, FmgType.GoodsInfo, "GoodsInfo_dlc01", 320),
                    [FmgType.GoodsInfo_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsInfo_DLC2, FmgType.GoodsInfo, "GoodsInfo_dlc02", 420),
                    [FmgType.GoodsInfo2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsInfo2, FmgType.GoodsInfo2, "GoodsInfo2", 46),
                    [FmgType.GoodsInfo2_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsInfo2_DLC1, FmgType.GoodsInfo2, "GoodsInfo2_dlc01", 335),
                    [FmgType.GoodsInfo2_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsInfo2_DLC2, FmgType.GoodsInfo2, "GoodsInfo2_dlc02", 435),
                    [FmgType.GoodsName] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsName, FmgType.GoodsName, "GoodsName", 10),
                    [FmgType.GoodsName_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsName_DLC1, FmgType.GoodsName, "GoodsName_dlc01", 319),
                    [FmgType.GoodsName_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.GoodsName_DLC2, FmgType.GoodsName, "GoodsName_dlc02", 419),
                    [FmgType.LoadingText] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.LoadingText, FmgType.LoadingText, "LoadingText", 206),
                    [FmgType.LoadingText_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.LoadingText_DLC1, FmgType.LoadingText, "LoadingText_dlc01", 374),
                    [FmgType.LoadingText_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.LoadingText_DLC2, FmgType.LoadingText, "LoadingText_dlc02", 474),
                    [FmgType.LoadingTitle] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.LoadingTitle, FmgType.LoadingTitle, "LoadingTitle", 205),
                    [FmgType.LoadingTitle_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.LoadingTitle_DLC1, FmgType.LoadingTitle, "LoadingTitle_dlc01", 373),
                    [FmgType.LoadingTitle_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.LoadingTitle_DLC2, FmgType.LoadingTitle, "LoadingTitle_dlc02", 473),
                    [FmgType.MagicCaption] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.MagicCaption, FmgType.MagicCaption, "MagicCaption", 29),
                    [FmgType.MagicCaption_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.MagicCaption_DLC1, FmgType.MagicCaption, "MagicCaption_dlc01", 327),
                    [FmgType.MagicCaption_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.MagicCaption_DLC2, FmgType.MagicCaption, "MagicCaption_dlc02", 427),
                    [FmgType.MagicInfo] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.MagicInfo, FmgType.MagicInfo, "MagicInfo", 28),
                    [FmgType.MagicInfo_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.MagicInfo_DLC1, FmgType.MagicInfo, "MagicInfo_dlc01", 326),
                    [FmgType.MagicInfo_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.MagicInfo_DLC2, FmgType.MagicInfo, "MagicInfo_dlc02", 426),
                    [FmgType.MagicName] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.MagicName, FmgType.MagicName, "MagicName", 14),
                    [FmgType.MagicName_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.MagicName_DLC1, FmgType.MagicName, "MagicName_dlc01", 325),
                    [FmgType.MagicName_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.MagicName_DLC2, FmgType.MagicName, "MagicName_dlc02", 425),
                    [FmgType.MovieSubtitle] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.MovieSubtitle, FmgType.MovieSubtitle, "MovieSubtitle", 3),
                    [FmgType.MovieSubtitle_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.MovieSubtitle_DLC1, FmgType.MovieSubtitle, "MovieSubtitle_dlc01", 362),
                    [FmgType.MovieSubtitle_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.MovieSubtitle_DLC2, FmgType.MovieSubtitle, "MovieSubtitle_dlc02", 462),
                    [FmgType.NetworkMessage] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.NetworkMessage, FmgType.NetworkMessage, "NetworkMessage", 31),
                    [FmgType.NetworkMessage_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.NetworkMessage_DLC1, FmgType.NetworkMessage, "NetworkMessage_dlc01", 364),
                    [FmgType.NetworkMessage_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.NetworkMessage_DLC2, FmgType.NetworkMessage, "NetworkMessage_dlc02", 464),
                    [FmgType.NpcName] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.NpcName, FmgType.NpcName, "NpcName", 18),
                    [FmgType.NpcName_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.NpcName_DLC1, FmgType.NpcName, "NpcName_dlc01", 328),
                    [FmgType.NpcName_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.NpcName_DLC2, FmgType.NpcName, "NpcName_dlc02", 428),
                    [FmgType.PlaceName] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.PlaceName, FmgType.PlaceName, "PlaceName", 19),
                    [FmgType.PlaceName_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.PlaceName_DLC1, FmgType.PlaceName, "PlaceName_dlc01", 329),
                    [FmgType.PlaceName_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.PlaceName_DLC2, FmgType.PlaceName, "PlaceName_dlc02", 429),
                    [FmgType.ProtectorCaption] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ProtectorCaption, FmgType.ProtectorCaption, "ProtectorCaption", 26),
                    [FmgType.ProtectorCaption_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ProtectorCaption_DLC1, FmgType.ProtectorCaption, "ProtectorCaption_dlc01", 315),
                    [FmgType.ProtectorCaption_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ProtectorCaption_DLC2, FmgType.ProtectorCaption, "ProtectorCaption_dlc02", 415),
                    [FmgType.ProtectorInfo] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ProtectorInfo, FmgType.ProtectorInfo, "ProtectorInfo", 22),
                    [FmgType.ProtectorInfo_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ProtectorInfo_DLC1, FmgType.ProtectorInfo, "ProtectorInfo_dlc01", 314),
                    [FmgType.ProtectorInfo_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ProtectorInfo_DLC2, FmgType.ProtectorInfo, "ProtectorInfo_dlc02", 414),
                    [FmgType.ProtectorName] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ProtectorName, FmgType.ProtectorName, "ProtectorName", 12),
                    [FmgType.ProtectorName_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ProtectorName_DLC1, FmgType.ProtectorName, "ProtectorName_dlc01", 313),
                    [FmgType.ProtectorName_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.ProtectorName_DLC2, FmgType.ProtectorName, "ProtectorName_dlc02", 413),
                    [FmgType.TalkMsg] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TalkMsg, FmgType.TalkMsg, "TalkMsg", 1),
                    [FmgType.TalkMsg_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TalkMsg_DLC1, FmgType.TalkMsg, "TalkMsg_dlc01", 360),
                    [FmgType.TalkMsg_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TalkMsg_DLC2, FmgType.TalkMsg, "TalkMsg_dlc02", 460),
                    [FmgType.TalkMsgFemalePCAlt] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TalkMsgFemalePCAlt, FmgType.TalkMsgFemalePCAlt, "TalkMsg_FemalePC_Alt", 4),
                    [FmgType.TalkMsgFemalePCAlt_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TalkMsgFemalePCAlt_DLC1, FmgType.TalkMsgFemalePCAlt, "TalkMsg_FemalePC_Alt_dlc01", 363),
                    [FmgType.TalkMsgFemalePCAlt_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TalkMsgFemalePCAlt_DLC2, FmgType.TalkMsgFemalePCAlt, "TalkMsg_FemalePC_Alt_dlc02", 463),
                    [FmgType.TextEmbedImageNameWindows] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TextEmbedImageNameWindows, FmgType.TextEmbedImageNameWindows, "TextEmbedImageName_win64", 209),
                    [FmgType.TosWindows] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TosWindows, FmgType.TosWindows, "ToS_win64", 210),
                    [FmgType.TutorialBody] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TutorialBody, FmgType.TutorialBody, "TutorialBody", 208),
                    [FmgType.TutorialBody_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TutorialBody_DLC1, FmgType.TutorialBody, "TutorialBody_dlc01", 376),
                    [FmgType.TutorialBody_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TutorialBody_DLC2, FmgType.TutorialBody, "TutorialBody_dlc02", 476),
                    [FmgType.TutorialTitle] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TutorialTitle, FmgType.TutorialTitle, "TutorialTitle", 207),
                    [FmgType.TutorialTitle_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TutorialTitle_DLC1, FmgType.TutorialTitle, "TutorialTitle_dlc01", 375),
                    [FmgType.TutorialTitle_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Menu, FmgType.TutorialTitle_DLC2, FmgType.TutorialTitle, "TutorialTitle_dlc02", 475),
                    [FmgType.WeaponCaption] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.WeaponCaption, FmgType.WeaponCaption, "WeaponCaption", 25),
                    [FmgType.WeaponCaption_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.WeaponCaption_DLC1, FmgType.WeaponCaption, "WeaponCaption_dlc01", 312),
                    [FmgType.WeaponCaption_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.WeaponCaption_DLC2, FmgType.WeaponCaption, "WeaponCaption_dlc02", 412),
                    [FmgType.WeaponEffect] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.WeaponEffect, FmgType.WeaponEffect, "WeaponEffect", 44),
                    [FmgType.WeaponEffect_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.WeaponEffect_DLC1, FmgType.WeaponEffect, "WeaponEffect_dlc01", 333),
                    [FmgType.WeaponEffect_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.WeaponEffect_DLC2, FmgType.WeaponEffect, "WeaponEffect_dlc02", 433),
                    [FmgType.WeaponInfo] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.WeaponInfo, FmgType.WeaponInfo, "WeaponInfo", 21),
                    [FmgType.WeaponInfo_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.WeaponInfo_DLC1, FmgType.WeaponInfo, "WeaponInfo_dlc01", 311),
                    [FmgType.WeaponInfo_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.WeaponInfo_DLC2, FmgType.WeaponInfo, "WeaponInfo_dlc02", 411),
                    [FmgType.WeaponName] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.WeaponName, FmgType.WeaponName, "WeaponName", 11),
                    [FmgType.WeaponName_DLC1] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.WeaponName_DLC1, FmgType.WeaponName, "WeaponName_dlc01", 310),
                    [FmgType.WeaponName_DLC2] = new FmgKeyInfo(FromSoftGame.EldenRing, FmgCategory.Item, FmgType.WeaponName_DLC2, FmgType.WeaponName, "WeaponName_dlc02", 410),
                },
                Overrides = new()
                {
                    [FmgType.AccessoryCaption] = new List<FmgType> { FmgType.AccessoryCaption_DLC2, FmgType.AccessoryCaption_DLC1 },
                    [FmgType.AccessoryInfo] = new List<FmgType> { FmgType.AccessoryInfo_DLC2, FmgType.AccessoryInfo_DLC1 },
                    [FmgType.AccessoryName] = new List<FmgType> { FmgType.AccessoryName_DLC2, FmgType.AccessoryName_DLC1 },
                    [FmgType.ActionButtonText] = new List<FmgType> { FmgType.ActionButtonText_DLC2, FmgType.ActionButtonText_DLC1 },
                    [FmgType.ArtsCaption] = new List<FmgType> { FmgType.ArtsCaption_DLC2, FmgType.ArtsCaption_DLC1 },
                    [FmgType.ArtsName] = new List<FmgType> { FmgType.ArtsName_DLC2, FmgType.ArtsName_DLC1 },
                    [FmgType.BloodMsg] = new List<FmgType> { FmgType.BloodMsg_DLC2, FmgType.BloodMsg_DLC1 },
                    [FmgType.EventTextForMap] = new List<FmgType> { FmgType.EventTextForMap_DLC2, FmgType.EventTextForMap_DLC1 },
                    [FmgType.EventTextForTalk] = new List<FmgType> { FmgType.EventTextForTalk_DLC2, FmgType.EventTextForTalk_DLC1 },
                    [FmgType.GameDialogues] = new List<FmgType> { FmgType.GameDialogues_DLC2, FmgType.GameDialogues_DLC1 },
                    [FmgType.GameKeyGuide] = new List<FmgType> { FmgType.GameKeyGuide_DLC2, FmgType.GameKeyGuide_DLC1 },
                    [FmgType.GameLineHelp] = new List<FmgType> { FmgType.GameLineHelp_DLC2, FmgType.GameLineHelp_DLC1 },
                    [FmgType.GameMenuText] = new List<FmgType> { FmgType.GameMenuText_DLC2, FmgType.GameMenuText_DLC1 },
                    [FmgType.GameSystemMessageWindows] = new List<FmgType> { FmgType.GameSystemMessageWindows_DLC2, FmgType.GameSystemMessageWindows_DLC1 },
                    [FmgType.GemCaption] = new List<FmgType> { FmgType.GemCaption_DLC2, FmgType.GemCaption_DLC1 },
                    [FmgType.GemEffect] = new List<FmgType> { FmgType.GemEffect_DLC2, FmgType.GemEffect_DLC1 },
                    [FmgType.GemInfo] = new List<FmgType> { FmgType.GemInfo_DLC2, FmgType.GemInfo_DLC1 },
                    [FmgType.GemName] = new List<FmgType> { FmgType.GemName_DLC2, FmgType.GemName_DLC1 },
                    [FmgType.GoodsCaption] = new List<FmgType> { FmgType.GoodsCaption_DLC2, FmgType.GoodsCaption_DLC1 },
                    [FmgType.GoodsDialog] = new List<FmgType> { FmgType.GoodsDialog_DLC2, FmgType.GoodsDialog_DLC1 },
                    [FmgType.GoodsInfo] = new List<FmgType> { FmgType.GoodsInfo_DLC2, FmgType.GoodsInfo_DLC1 },
                    [FmgType.GoodsInfo2] = new List<FmgType> { FmgType.GoodsInfo2_DLC2, FmgType.GoodsInfo2_DLC1 },
                    [FmgType.GoodsName] = new List<FmgType> { FmgType.GoodsName_DLC2, FmgType.GoodsName_DLC1 },
                    [FmgType.LoadingText] = new List<FmgType> { FmgType.LoadingText_DLC2, FmgType.LoadingText_DLC1 },
                    [FmgType.LoadingTitle] = new List<FmgType> { FmgType.LoadingTitle_DLC2, FmgType.LoadingTitle_DLC1 },
                    [FmgType.MagicCaption] = new List<FmgType> { FmgType.MagicCaption_DLC2, FmgType.MagicCaption_DLC1 },
                    [FmgType.MagicInfo] = new List<FmgType> { FmgType.MagicInfo_DLC2, FmgType.MagicInfo_DLC1 },
                    [FmgType.MagicName] = new List<FmgType> { FmgType.MagicName_DLC2, FmgType.MagicName_DLC1 },
                    [FmgType.MovieSubtitle] = new List<FmgType> { FmgType.MovieSubtitle_DLC2, FmgType.MovieSubtitle_DLC1 },
                    [FmgType.NetworkMessage] = new List<FmgType> { FmgType.NetworkMessage_DLC2, FmgType.NetworkMessage_DLC1 },
                    [FmgType.NpcName] = new List<FmgType> { FmgType.NpcName_DLC2, FmgType.NpcName_DLC1 },
                    [FmgType.PlaceName] = new List<FmgType> { FmgType.PlaceName_DLC2, FmgType.PlaceName_DLC1 },
                    [FmgType.ProtectorCaption] = new List<FmgType> { FmgType.ProtectorCaption_DLC2, FmgType.ProtectorCaption_DLC1 },
                    [FmgType.ProtectorInfo] = new List<FmgType> { FmgType.ProtectorInfo_DLC2, FmgType.ProtectorInfo_DLC1 },
                    [FmgType.ProtectorName] = new List<FmgType> { FmgType.ProtectorName_DLC2, FmgType.ProtectorName_DLC1 },
                    [FmgType.TalkMsg] = new List<FmgType> { FmgType.TalkMsg_DLC2, FmgType.TalkMsg_DLC1 },
                    [FmgType.TalkMsgFemalePCAlt] = new List<FmgType> { FmgType.TalkMsgFemalePCAlt_DLC2, FmgType.TalkMsgFemalePCAlt_DLC1 },
                    [FmgType.TutorialBody] = new List<FmgType> { FmgType.TutorialBody_DLC2, FmgType.TutorialBody_DLC1 },
                    [FmgType.TutorialTitle] = new List<FmgType> { FmgType.TutorialTitle_DLC2, FmgType.TutorialTitle_DLC1 },
                    [FmgType.WeaponCaption] = new List<FmgType> { FmgType.WeaponCaption_DLC2, FmgType.WeaponCaption_DLC1 },
                    [FmgType.WeaponEffect] = new List<FmgType> { FmgType.WeaponEffect_DLC2, FmgType.WeaponEffect_DLC1 },
                    [FmgType.WeaponInfo] = new List<FmgType> { FmgType.WeaponInfo_DLC2, FmgType.WeaponInfo_DLC1 },
                    [FmgType.WeaponName] = new List<FmgType> { FmgType.WeaponName_DLC2, FmgType.WeaponName_DLC1 },
                },
                ByFmgName = new()
                {
                    ["AccessoryCaption_dlc01"] = new List<FmgType> { FmgType.AccessoryCaption_DLC1 },
                    ["AccessoryCaption_dlc02"] = new List<FmgType> { FmgType.AccessoryCaption_DLC2 },
                    ["AccessoryCaption"] = new List<FmgType> { FmgType.AccessoryCaption },
                    ["AccessoryInfo_dlc01"] = new List<FmgType> { FmgType.AccessoryInfo_DLC1 },
                    ["AccessoryInfo_dlc02"] = new List<FmgType> { FmgType.AccessoryInfo_DLC2 },
                    ["AccessoryInfo"] = new List<FmgType> { FmgType.AccessoryInfo },
                    ["AccessoryName_dlc01"] = new List<FmgType> { FmgType.AccessoryName_DLC1 },
                    ["AccessoryName_dlc02"] = new List<FmgType> { FmgType.AccessoryName_DLC2 },
                    ["AccessoryName"] = new List<FmgType> { FmgType.AccessoryName },
                    ["ActionButtonText_dlc01"] = new List<FmgType> { FmgType.ActionButtonText_DLC1 },
                    ["ActionButtonText_dlc02"] = new List<FmgType> { FmgType.ActionButtonText_DLC2 },
                    ["ActionButtonText"] = new List<FmgType> { FmgType.ActionButtonText },
                    ["ArtsCaption_dlc01"] = new List<FmgType> { FmgType.ArtsCaption_DLC1 },
                    ["ArtsCaption_dlc02"] = new List<FmgType> { FmgType.ArtsCaption_DLC2 },
                    ["ArtsCaption"] = new List<FmgType> { FmgType.ArtsCaption },
                    ["ArtsName_dlc01"] = new List<FmgType> { FmgType.ArtsName_DLC1 },
                    ["ArtsName_dlc02"] = new List<FmgType> { FmgType.ArtsName_DLC2 },
                    ["ArtsName"] = new List<FmgType> { FmgType.ArtsName },
                    ["BloodMsg_dlc01"] = new List<FmgType> { FmgType.BloodMsg_DLC1 },
                    ["BloodMsg_dlc02"] = new List<FmgType> { FmgType.BloodMsg_DLC2 },
                    ["BloodMsg"] = new List<FmgType> { FmgType.BloodMsg },
                    ["EventTextForMap_dlc01"] = new List<FmgType> { FmgType.EventTextForMap_DLC1 },
                    ["EventTextForMap_dlc02"] = new List<FmgType> { FmgType.EventTextForMap_DLC2 },
                    ["EventTextForMap"] = new List<FmgType> { FmgType.EventTextForMap },
                    ["EventTextForTalk_dlc01"] = new List<FmgType> { FmgType.EventTextForTalk_DLC1 },
                    ["EventTextForTalk_dlc02"] = new List<FmgType> { FmgType.EventTextForTalk_DLC2 },
                    ["EventTextForTalk"] = new List<FmgType> { FmgType.EventTextForTalk },
                    ["GemCaption_dlc01"] = new List<FmgType> { FmgType.GemCaption_DLC1 },
                    ["GemCaption_dlc02"] = new List<FmgType> { FmgType.GemCaption_DLC2 },
                    ["GemCaption"] = new List<FmgType> { FmgType.GemCaption },
                    ["GemEffect_dlc01"] = new List<FmgType> { FmgType.GemEffect_DLC1 },
                    ["GemEffect_dlc02"] = new List<FmgType> { FmgType.GemEffect_DLC2 },
                    ["GemEffect"] = new List<FmgType> { FmgType.GemEffect },
                    ["GemInfo_dlc01"] = new List<FmgType> { FmgType.GemInfo_DLC1 },
                    ["GemInfo_dlc02"] = new List<FmgType> { FmgType.GemInfo_DLC2 },
                    ["GemInfo"] = new List<FmgType> { FmgType.GemInfo },
                    ["GemName_dlc01"] = new List<FmgType> { FmgType.GemName_DLC1 },
                    ["GemName_dlc02"] = new List<FmgType> { FmgType.GemName_DLC2 },
                    ["GemName"] = new List<FmgType> { FmgType.GemName },
                    ["GoodsCaption_dlc01"] = new List<FmgType> { FmgType.GoodsCaption_DLC1 },
                    ["GoodsCaption_dlc02"] = new List<FmgType> { FmgType.GoodsCaption_DLC2 },
                    ["GoodsCaption"] = new List<FmgType> { FmgType.GoodsCaption },
                    ["GoodsDialog_dlc01"] = new List<FmgType> { FmgType.GoodsDialog_DLC1 },
                    ["GoodsDialog_dlc02"] = new List<FmgType> { FmgType.GoodsDialog_DLC2 },
                    ["GoodsDialog"] = new List<FmgType> { FmgType.GoodsDialog },
                    ["GoodsInfo_dlc01"] = new List<FmgType> { FmgType.GoodsInfo_DLC1 },
                    ["GoodsInfo_dlc02"] = new List<FmgType> { FmgType.GoodsInfo_DLC2 },
                    ["GoodsInfo"] = new List<FmgType> { FmgType.GoodsInfo },
                    ["GoodsInfo2_dlc01"] = new List<FmgType> { FmgType.GoodsInfo2_DLC1 },
                    ["GoodsInfo2_dlc02"] = new List<FmgType> { FmgType.GoodsInfo2_DLC2 },
                    ["GoodsInfo2"] = new List<FmgType> { FmgType.GoodsInfo2 },
                    ["GoodsName_dlc01"] = new List<FmgType> { FmgType.GoodsName_DLC1 },
                    ["GoodsName_dlc02"] = new List<FmgType> { FmgType.GoodsName_DLC2 },
                    ["GoodsName"] = new List<FmgType> { FmgType.GoodsName },
                    ["GR_Dialogues_dlc01"] = new List<FmgType> { FmgType.GameDialogues_DLC1 },
                    ["GR_Dialogues_dlc02"] = new List<FmgType> { FmgType.GameDialogues_DLC2 },
                    ["GR_Dialogues"] = new List<FmgType> { FmgType.GameDialogues },
                    ["GR_KeyGuide_dlc01"] = new List<FmgType> { FmgType.GameKeyGuide_DLC1 },
                    ["GR_KeyGuide_dlc02"] = new List<FmgType> { FmgType.GameKeyGuide_DLC2 },
                    ["GR_KeyGuide"] = new List<FmgType> { FmgType.GameKeyGuide },
                    ["GR_LineHelp_dlc01"] = new List<FmgType> { FmgType.GameLineHelp_DLC1 },
                    ["GR_LineHelp_dlc02"] = new List<FmgType> { FmgType.GameLineHelp_DLC2 },
                    ["GR_LineHelp"] = new List<FmgType> { FmgType.GameLineHelp },
                    ["GR_MenuText_dlc01"] = new List<FmgType> { FmgType.GameMenuText_DLC1 },
                    ["GR_MenuText_dlc02"] = new List<FmgType> { FmgType.GameMenuText_DLC2 },
                    ["GR_MenuText"] = new List<FmgType> { FmgType.GameMenuText },
                    ["GR_System_Message_win64_dlc01"] = new List<FmgType> { FmgType.GameSystemMessageWindows_DLC1 },
                    ["GR_System_Message_win64_dlc02"] = new List<FmgType> { FmgType.GameSystemMessageWindows_DLC2 },
                    ["GR_System_Message_win64"] = new List<FmgType> { FmgType.GameSystemMessageWindows },
                    ["LoadingText_dlc01"] = new List<FmgType> { FmgType.LoadingText_DLC1 },
                    ["LoadingText_dlc02"] = new List<FmgType> { FmgType.LoadingText_DLC2 },
                    ["LoadingText"] = new List<FmgType> { FmgType.LoadingText },
                    ["LoadingTitle_dlc01"] = new List<FmgType> { FmgType.LoadingTitle_DLC1 },
                    ["LoadingTitle_dlc02"] = new List<FmgType> { FmgType.LoadingTitle_DLC2 },
                    ["LoadingTitle"] = new List<FmgType> { FmgType.LoadingTitle },
                    ["MagicCaption_dlc01"] = new List<FmgType> { FmgType.MagicCaption_DLC1 },
                    ["MagicCaption_dlc02"] = new List<FmgType> { FmgType.MagicCaption_DLC2 },
                    ["MagicCaption"] = new List<FmgType> { FmgType.MagicCaption },
                    ["MagicInfo_dlc01"] = new List<FmgType> { FmgType.MagicInfo_DLC1 },
                    ["MagicInfo_dlc02"] = new List<FmgType> { FmgType.MagicInfo_DLC2 },
                    ["MagicInfo"] = new List<FmgType> { FmgType.MagicInfo },
                    ["MagicName_dlc01"] = new List<FmgType> { FmgType.MagicName_DLC1 },
                    ["MagicName_dlc02"] = new List<FmgType> { FmgType.MagicName_DLC2 },
                    ["MagicName"] = new List<FmgType> { FmgType.MagicName },
                    ["MovieSubtitle_dlc01"] = new List<FmgType> { FmgType.MovieSubtitle_DLC1 },
                    ["MovieSubtitle_dlc02"] = new List<FmgType> { FmgType.MovieSubtitle_DLC2 },
                    ["MovieSubtitle"] = new List<FmgType> { FmgType.MovieSubtitle },
                    ["NetworkMessage_dlc01"] = new List<FmgType> { FmgType.NetworkMessage_DLC1 },
                    ["NetworkMessage_dlc02"] = new List<FmgType> { FmgType.NetworkMessage_DLC2 },
                    ["NetworkMessage"] = new List<FmgType> { FmgType.NetworkMessage },
                    ["NpcName_dlc01"] = new List<FmgType> { FmgType.NpcName_DLC1 },
                    ["NpcName_dlc02"] = new List<FmgType> { FmgType.NpcName_DLC2 },
                    ["NpcName"] = new List<FmgType> { FmgType.NpcName },
                    ["PlaceName_dlc01"] = new List<FmgType> { FmgType.PlaceName_DLC1 },
                    ["PlaceName_dlc02"] = new List<FmgType> { FmgType.PlaceName_DLC2 },
                    ["PlaceName"] = new List<FmgType> { FmgType.PlaceName },
                    ["ProtectorCaption_dlc01"] = new List<FmgType> { FmgType.ProtectorCaption_DLC1 },
                    ["ProtectorCaption_dlc02"] = new List<FmgType> { FmgType.ProtectorCaption_DLC2 },
                    ["ProtectorCaption"] = new List<FmgType> { FmgType.ProtectorCaption },
                    ["ProtectorInfo_dlc01"] = new List<FmgType> { FmgType.ProtectorInfo_DLC1 },
                    ["ProtectorInfo_dlc02"] = new List<FmgType> { FmgType.ProtectorInfo_DLC2 },
                    ["ProtectorInfo"] = new List<FmgType> { FmgType.ProtectorInfo },
                    ["ProtectorName_dlc01"] = new List<FmgType> { FmgType.ProtectorName_DLC1 },
                    ["ProtectorName_dlc02"] = new List<FmgType> { FmgType.ProtectorName_DLC2 },
                    ["ProtectorName"] = new List<FmgType> { FmgType.ProtectorName },
                    ["TalkMsg_dlc01"] = new List<FmgType> { FmgType.TalkMsg_DLC1 },
                    ["TalkMsg_dlc02"] = new List<FmgType> { FmgType.TalkMsg_DLC2 },
                    ["TalkMsg_FemalePC_Alt_dlc01"] = new List<FmgType> { FmgType.TalkMsgFemalePCAlt_DLC1 },
                    ["TalkMsg_FemalePC_Alt_dlc02"] = new List<FmgType> { FmgType.TalkMsgFemalePCAlt_DLC2 },
                    ["TalkMsg_FemalePC_Alt"] = new List<FmgType> { FmgType.TalkMsgFemalePCAlt },
                    ["TalkMsg"] = new List<FmgType> { FmgType.TalkMsg },
                    ["TextEmbedImageName_win64"] = new List<FmgType> { FmgType.TextEmbedImageNameWindows },
                    ["ToS_win64"] = new List<FmgType> { FmgType.TosWindows },
                    ["TutorialBody_dlc01"] = new List<FmgType> { FmgType.TutorialBody_DLC1 },
                    ["TutorialBody_dlc02"] = new List<FmgType> { FmgType.TutorialBody_DLC2 },
                    ["TutorialBody"] = new List<FmgType> { FmgType.TutorialBody },
                    ["TutorialTitle_dlc01"] = new List<FmgType> { FmgType.TutorialTitle_DLC1 },
                    ["TutorialTitle_dlc02"] = new List<FmgType> { FmgType.TutorialTitle_DLC2 },
                    ["TutorialTitle"] = new List<FmgType> { FmgType.TutorialTitle },
                    ["WeaponCaption_dlc01"] = new List<FmgType> { FmgType.WeaponCaption_DLC1 },
                    ["WeaponCaption_dlc02"] = new List<FmgType> { FmgType.WeaponCaption_DLC2 },
                    ["WeaponCaption"] = new List<FmgType> { FmgType.WeaponCaption },
                    ["WeaponEffect_dlc01"] = new List<FmgType> { FmgType.WeaponEffect_DLC1 },
                    ["WeaponEffect_dlc02"] = new List<FmgType> { FmgType.WeaponEffect_DLC2 },
                    ["WeaponEffect"] = new List<FmgType> { FmgType.WeaponEffect },
                    ["WeaponInfo_dlc01"] = new List<FmgType> { FmgType.WeaponInfo_DLC1 },
                    ["WeaponInfo_dlc02"] = new List<FmgType> { FmgType.WeaponInfo_DLC2 },
                    ["WeaponInfo"] = new List<FmgType> { FmgType.WeaponInfo },
                    ["WeaponName_dlc01"] = new List<FmgType> { FmgType.WeaponName_DLC1 },
                    ["WeaponName_dlc02"] = new List<FmgType> { FmgType.WeaponName_DLC2 },
                    ["WeaponName"] = new List<FmgType> { FmgType.WeaponName },
                },
                ByBinderID = new()
                {
                    [1] = new List<FmgType> { FmgType.TalkMsg },
                    [2] = new List<FmgType> { FmgType.BloodMsg },
                    [3] = new List<FmgType> { FmgType.MovieSubtitle },
                    [4] = new List<FmgType> { FmgType.TalkMsgFemalePCAlt },
                    [10] = new List<FmgType> { FmgType.GoodsName },
                    [11] = new List<FmgType> { FmgType.WeaponName },
                    [12] = new List<FmgType> { FmgType.ProtectorName },
                    [13] = new List<FmgType> { FmgType.AccessoryName },
                    [14] = new List<FmgType> { FmgType.MagicName },
                    [18] = new List<FmgType> { FmgType.NpcName },
                    [19] = new List<FmgType> { FmgType.PlaceName },
                    [20] = new List<FmgType> { FmgType.GoodsInfo },
                    [21] = new List<FmgType> { FmgType.WeaponInfo },
                    [22] = new List<FmgType> { FmgType.ProtectorInfo },
                    [23] = new List<FmgType> { FmgType.AccessoryInfo },
                    [24] = new List<FmgType> { FmgType.GoodsCaption },
                    [25] = new List<FmgType> { FmgType.WeaponCaption },
                    [26] = new List<FmgType> { FmgType.ProtectorCaption },
                    [27] = new List<FmgType> { FmgType.AccessoryCaption },
                    [28] = new List<FmgType> { FmgType.MagicInfo },
                    [29] = new List<FmgType> { FmgType.MagicCaption },
                    [31] = new List<FmgType> { FmgType.NetworkMessage },
                    [32] = new List<FmgType> { FmgType.ActionButtonText },
                    [33] = new List<FmgType> { FmgType.EventTextForTalk },
                    [34] = new List<FmgType> { FmgType.EventTextForMap },
                    [35] = new List<FmgType> { FmgType.GemName },
                    [36] = new List<FmgType> { FmgType.GemInfo },
                    [37] = new List<FmgType> { FmgType.GemCaption },
                    [41] = new List<FmgType> { FmgType.GoodsDialog },
                    [42] = new List<FmgType> { FmgType.ArtsName },
                    [43] = new List<FmgType> { FmgType.ArtsCaption },
                    [44] = new List<FmgType> { FmgType.WeaponEffect },
                    [45] = new List<FmgType> { FmgType.GemEffect },
                    [46] = new List<FmgType> { FmgType.GoodsInfo2 },
                    [200] = new List<FmgType> { FmgType.GameMenuText },
                    [201] = new List<FmgType> { FmgType.GameLineHelp },
                    [202] = new List<FmgType> { FmgType.GameKeyGuide },
                    [203] = new List<FmgType> { FmgType.GameSystemMessageWindows },
                    [204] = new List<FmgType> { FmgType.GameDialogues },
                    [205] = new List<FmgType> { FmgType.LoadingTitle },
                    [206] = new List<FmgType> { FmgType.LoadingText },
                    [207] = new List<FmgType> { FmgType.TutorialTitle },
                    [208] = new List<FmgType> { FmgType.TutorialBody },
                    [209] = new List<FmgType> { FmgType.TextEmbedImageNameWindows },
                    [210] = new List<FmgType> { FmgType.TosWindows },
                    [310] = new List<FmgType> { FmgType.WeaponName_DLC1 },
                    [311] = new List<FmgType> { FmgType.WeaponInfo_DLC1 },
                    [312] = new List<FmgType> { FmgType.WeaponCaption_DLC1 },
                    [313] = new List<FmgType> { FmgType.ProtectorName_DLC1 },
                    [314] = new List<FmgType> { FmgType.ProtectorInfo_DLC1 },
                    [315] = new List<FmgType> { FmgType.ProtectorCaption_DLC1 },
                    [316] = new List<FmgType> { FmgType.AccessoryName_DLC1 },
                    [317] = new List<FmgType> { FmgType.AccessoryInfo_DLC1 },
                    [318] = new List<FmgType> { FmgType.AccessoryCaption_DLC1 },
                    [319] = new List<FmgType> { FmgType.GoodsName_DLC1 },
                    [320] = new List<FmgType> { FmgType.GoodsInfo_DLC1 },
                    [321] = new List<FmgType> { FmgType.GoodsCaption_DLC1 },
                    [322] = new List<FmgType> { FmgType.GemName_DLC1 },
                    [323] = new List<FmgType> { FmgType.GemInfo_DLC1 },
                    [324] = new List<FmgType> { FmgType.GemCaption_DLC1 },
                    [325] = new List<FmgType> { FmgType.MagicName_DLC1 },
                    [326] = new List<FmgType> { FmgType.MagicInfo_DLC1 },
                    [327] = new List<FmgType> { FmgType.MagicCaption_DLC1 },
                    [328] = new List<FmgType> { FmgType.NpcName_DLC1 },
                    [329] = new List<FmgType> { FmgType.PlaceName_DLC1 },
                    [330] = new List<FmgType> { FmgType.GoodsDialog_DLC1 },
                    [331] = new List<FmgType> { FmgType.ArtsName_DLC1 },
                    [332] = new List<FmgType> { FmgType.ArtsCaption_DLC1 },
                    [333] = new List<FmgType> { FmgType.WeaponEffect_DLC1 },
                    [334] = new List<FmgType> { FmgType.GemEffect_DLC1 },
                    [335] = new List<FmgType> { FmgType.GoodsInfo2_DLC1 },
                    [360] = new List<FmgType> { FmgType.TalkMsg_DLC1 },
                    [361] = new List<FmgType> { FmgType.BloodMsg_DLC1 },
                    [362] = new List<FmgType> { FmgType.MovieSubtitle_DLC1 },
                    [363] = new List<FmgType> { FmgType.TalkMsgFemalePCAlt_DLC1 },
                    [364] = new List<FmgType> { FmgType.NetworkMessage_DLC1 },
                    [365] = new List<FmgType> { FmgType.ActionButtonText_DLC1 },
                    [366] = new List<FmgType> { FmgType.EventTextForTalk_DLC1 },
                    [367] = new List<FmgType> { FmgType.EventTextForMap_DLC1 },
                    [368] = new List<FmgType> { FmgType.GameMenuText_DLC1 },
                    [369] = new List<FmgType> { FmgType.GameLineHelp_DLC1 },
                    [370] = new List<FmgType> { FmgType.GameKeyGuide_DLC1 },
                    [371] = new List<FmgType> { FmgType.GameSystemMessageWindows_DLC1 },
                    [372] = new List<FmgType> { FmgType.GameDialogues_DLC1 },
                    [373] = new List<FmgType> { FmgType.LoadingTitle_DLC1 },
                    [374] = new List<FmgType> { FmgType.LoadingText_DLC1 },
                    [375] = new List<FmgType> { FmgType.TutorialTitle_DLC1 },
                    [376] = new List<FmgType> { FmgType.TutorialBody_DLC1 },
                    [410] = new List<FmgType> { FmgType.WeaponName_DLC2 },
                    [411] = new List<FmgType> { FmgType.WeaponInfo_DLC2 },
                    [412] = new List<FmgType> { FmgType.WeaponCaption_DLC2 },
                    [413] = new List<FmgType> { FmgType.ProtectorName_DLC2 },
                    [414] = new List<FmgType> { FmgType.ProtectorInfo_DLC2 },
                    [415] = new List<FmgType> { FmgType.ProtectorCaption_DLC2 },
                    [416] = new List<FmgType> { FmgType.AccessoryName_DLC2 },
                    [417] = new List<FmgType> { FmgType.AccessoryInfo_DLC2 },
                    [418] = new List<FmgType> { FmgType.AccessoryCaption_DLC2 },
                    [419] = new List<FmgType> { FmgType.GoodsName_DLC2 },
                    [420] = new List<FmgType> { FmgType.GoodsInfo_DLC2 },
                    [421] = new List<FmgType> { FmgType.GoodsCaption_DLC2 },
                    [422] = new List<FmgType> { FmgType.GemName_DLC2 },
                    [423] = new List<FmgType> { FmgType.GemInfo_DLC2 },
                    [424] = new List<FmgType> { FmgType.GemCaption_DLC2 },
                    [425] = new List<FmgType> { FmgType.MagicName_DLC2 },
                    [426] = new List<FmgType> { FmgType.MagicInfo_DLC2 },
                    [427] = new List<FmgType> { FmgType.MagicCaption_DLC2 },
                    [428] = new List<FmgType> { FmgType.NpcName_DLC2 },
                    [429] = new List<FmgType> { FmgType.PlaceName_DLC2 },
                    [430] = new List<FmgType> { FmgType.GoodsDialog_DLC2 },
                    [431] = new List<FmgType> { FmgType.ArtsName_DLC2 },
                    [432] = new List<FmgType> { FmgType.ArtsCaption_DLC2 },
                    [433] = new List<FmgType> { FmgType.WeaponEffect_DLC2 },
                    [434] = new List<FmgType> { FmgType.GemEffect_DLC2 },
                    [435] = new List<FmgType> { FmgType.GoodsInfo2_DLC2 },
                    [460] = new List<FmgType> { FmgType.TalkMsg_DLC2 },
                    [461] = new List<FmgType> { FmgType.BloodMsg_DLC2 },
                    [462] = new List<FmgType> { FmgType.MovieSubtitle_DLC2 },
                    [463] = new List<FmgType> { FmgType.TalkMsgFemalePCAlt_DLC2 },
                    [464] = new List<FmgType> { FmgType.NetworkMessage_DLC2 },
                    [465] = new List<FmgType> { FmgType.ActionButtonText_DLC2 },
                    [466] = new List<FmgType> { FmgType.EventTextForTalk_DLC2 },
                    [467] = new List<FmgType> { FmgType.EventTextForMap_DLC2 },
                    [468] = new List<FmgType> { FmgType.GameMenuText_DLC2 },
                    [469] = new List<FmgType> { FmgType.GameLineHelp_DLC2 },
                    [470] = new List<FmgType> { FmgType.GameKeyGuide_DLC2 },
                    [471] = new List<FmgType> { FmgType.GameSystemMessageWindows_DLC2 },
                    [472] = new List<FmgType> { FmgType.GameDialogues_DLC2 },
                    [473] = new List<FmgType> { FmgType.LoadingTitle_DLC2 },
                    [474] = new List<FmgType> { FmgType.LoadingText_DLC2 },
                    [475] = new List<FmgType> { FmgType.TutorialTitle_DLC2 },
                    [476] = new List<FmgType> { FmgType.TutorialBody_DLC2 },
                },
                ToLanguageEnum = new()
                {
                    ["araae"] = FmgLanguage.Arabic,
                    ["deude"] = FmgLanguage.German,
                    ["engus"] = FmgLanguage.English,
                    ["frafr"] = FmgLanguage.French,
                    ["itait"] = FmgLanguage.Italian,
                    ["jpnjp"] = FmgLanguage.Japanese,
                    ["korkr"] = FmgLanguage.Korean,
                    ["polpl"] = FmgLanguage.Polish,
                    ["porbr"] = FmgLanguage.BrazilPortuguese,
                    ["rusru"] = FmgLanguage.Russian,
                    ["spaar"] = FmgLanguage.Spanish,
                    ["spaes"] = FmgLanguage.SpainSpanish,
                    ["thath"] = FmgLanguage.Thai,
                    ["zhocn"] = FmgLanguage.SimplifiedChinese,
                    ["zhotw"] = FmgLanguage.TraditionalChinese,
                },
                FromLanguageEnum = new()
                {
                    [FmgLanguage.Arabic] = "araae",
                    [FmgLanguage.German] = "deude",
                    [FmgLanguage.English] = "engus",
                    [FmgLanguage.French] = "frafr",
                    [FmgLanguage.Italian] = "itait",
                    [FmgLanguage.Japanese] = "jpnjp",
                    [FmgLanguage.Korean] = "korkr",
                    [FmgLanguage.Polish] = "polpl",
                    [FmgLanguage.BrazilPortuguese] = "porbr",
                    [FmgLanguage.Russian] = "rusru",
                    [FmgLanguage.Spanish] = "spaar",
                    [FmgLanguage.SpainSpanish] = "spaes",
                    [FmgLanguage.Thai] = "thath",
                    [FmgLanguage.SimplifiedChinese] = "zhocn",
                    [FmgLanguage.TraditionalChinese] = "zhotw",
                },
            },
            [FromSoftGame.ArmoredCore6] = new FmgGameInfo
            {
                ByType = new()
                {
                    [FmgType.ArchiveContent] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.ArchiveContent, FmgType.ArchiveContent, "アーカイブ内容", 66),
                    [FmgType.ArchiveName] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.ArchiveName, FmgType.ArchiveName, "アーカイブ名", 65),
                    [FmgType.BoosterInfo] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Item, FmgType.BoosterInfo, FmgType.BoosterInfo, "ブースター説明", 39),
                    [FmgType.BoosterName] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Item, FmgType.BoosterName, FmgType.BoosterName, "ブースター名", 38),
                    [FmgType.EventText] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.EventText, FmgType.EventText, "イベントテキスト", 30),
                    [FmgType.FCSInfo] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Item, FmgType.FCSInfo, FmgType.FCSInfo, "FCS説明", 42),
                    [FmgType.FCSName] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Item, FmgType.FCSName, FmgType.FCSName, "FCS名", 41),
                    [FmgType.GameDialogues] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.GameDialogues, FmgType.GameDialogues, "FNR_ダイアログ", 204),
                    [FmgType.GameKeyGuide] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.GameKeyGuide, FmgType.GameKeyGuide, "FNR_キーガイド", 202),
                    [FmgType.GameLineHelp] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.GameLineHelp, FmgType.GameLineHelp, "FNR_一行ヘルプ", 201),
                    [FmgType.GameMenuText] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.GameMenuText, FmgType.GameMenuText, "FNR_メニューテキスト", 200),
                    [FmgType.GameSystemMessageWindows] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.GameSystemMessageWindows, FmgType.GameSystemMessageWindows, "FNR_システムメッセージ_win64", 203),
                    [FmgType.GeneratorInfo] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Item, FmgType.GeneratorInfo, FmgType.GeneratorInfo, "ジェネレーター説明", 36),
                    [FmgType.GeneratorName] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Item, FmgType.GeneratorName, FmgType.GeneratorName, "ジェネレーター名", 35),
                    [FmgType.GoodsName] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Item, FmgType.GoodsName, FmgType.GoodsName, "アイテム名", 10),
                    [FmgType.LoadingText] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.LoadingText, FmgType.LoadingText, "ローディングテキスト", 208),
                    [FmgType.LoadingTitle] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.LoadingTitle, FmgType.LoadingTitle, "ローディングタイトル", 207),
                    [FmgType.MenuContext] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.MenuContext, FmgType.MenuContext, "項目ヘルプ", 205),
                    [FmgType.MissionName] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.MissionName, FmgType.MissionName, "ミッション名", 60),
                    [FmgType.MissionObjective] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.MissionObjective, FmgType.MissionObjective, "ミッション目標", 62),
                    [FmgType.MissionPlaceName] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.MissionPlaceName, FmgType.MissionPlaceName, "ミッション地点名", 63),
                    [FmgType.MissionSummary] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.MissionSummary, FmgType.MissionSummary, "ミッション概要", 61),
                    [FmgType.MovieSubtitle] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.MovieSubtitle, FmgType.MovieSubtitle, "ムービー字幕", 3),
                    [FmgType.NpcName] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Item, FmgType.NpcName, FmgType.NpcName, "NPC名", 18),
                    [FmgType.ProtectorInfo] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Item, FmgType.ProtectorInfo, FmgType.ProtectorInfo, "防具説明", 22),
                    [FmgType.ProtectorName] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Item, FmgType.ProtectorName, FmgType.ProtectorName, "防具名", 12),
                    [FmgType.RankerProfile] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.RankerProfile, FmgType.RankerProfile, "ランカープロフィール", 50),
                    [FmgType.TalkMsg] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.TalkMsg, FmgType.TalkMsg, "会話", 1),
                    [FmgType.TextEmbedImageNameWindows] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.TextEmbedImageNameWindows, FmgType.TextEmbedImageNameWindows, "テキスト埋込イメージ名_win64", 210),
                    [FmgType.TutorialBody] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.TutorialBody, FmgType.TutorialBody, "チュートリアル本文", 74),
                    [FmgType.TutorialTitle] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Menu, FmgType.TutorialTitle, FmgType.TutorialTitle, "チュートリアルタイトル", 73),
                    [FmgType.WeaponInfo] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Item, FmgType.WeaponInfo, FmgType.WeaponInfo, "武器説明", 21),
                    [FmgType.WeaponName] = new FmgKeyInfo(FromSoftGame.ArmoredCore6, FmgCategory.Item, FmgType.WeaponName, FmgType.WeaponName, "武器名", 11),
                },
                Overrides = new()
                {

                },
                ByFmgName = new()
                {
                    ["FCS名"] = new List<FmgType> { FmgType.FCSName },
                    ["FCS説明"] = new List<FmgType> { FmgType.FCSInfo },
                    ["FNR_キーガイド"] = new List<FmgType> { FmgType.GameKeyGuide },
                    ["FNR_システムメッセージ_win64"] = new List<FmgType> { FmgType.GameSystemMessageWindows },
                    ["FNR_ダイアログ"] = new List<FmgType> { FmgType.GameDialogues },
                    ["FNR_メニューテキスト"] = new List<FmgType> { FmgType.GameMenuText },
                    ["FNR_一行ヘルプ"] = new List<FmgType> { FmgType.GameLineHelp },
                    ["NPC名"] = new List<FmgType> { FmgType.NpcName },
                    ["アーカイブ内容"] = new List<FmgType> { FmgType.ArchiveContent },
                    ["アーカイブ名"] = new List<FmgType> { FmgType.ArchiveName },
                    ["アイテム名"] = new List<FmgType> { FmgType.GoodsName },
                    ["イベントテキスト"] = new List<FmgType> { FmgType.EventText },
                    ["ジェネレーター名"] = new List<FmgType> { FmgType.GeneratorName },
                    ["ジェネレーター説明"] = new List<FmgType> { FmgType.GeneratorInfo },
                    ["チュートリアルタイトル"] = new List<FmgType> { FmgType.TutorialTitle },
                    ["チュートリアル本文"] = new List<FmgType> { FmgType.TutorialBody },
                    ["テキスト埋込イメージ名_win64"] = new List<FmgType> { FmgType.TextEmbedImageNameWindows },
                    ["ブースター名"] = new List<FmgType> { FmgType.BoosterName },
                    ["ブースター説明"] = new List<FmgType> { FmgType.BoosterInfo },
                    ["ミッション名"] = new List<FmgType> { FmgType.MissionName },
                    ["ミッション地点名"] = new List<FmgType> { FmgType.MissionPlaceName },
                    ["ミッション概要"] = new List<FmgType> { FmgType.MissionSummary },
                    ["ミッション目標"] = new List<FmgType> { FmgType.MissionObjective },
                    ["ムービー字幕"] = new List<FmgType> { FmgType.MovieSubtitle },
                    ["ランカープロフィール"] = new List<FmgType> { FmgType.RankerProfile },
                    ["ローディングタイトル"] = new List<FmgType> { FmgType.LoadingTitle },
                    ["ローディングテキスト"] = new List<FmgType> { FmgType.LoadingText },
                    ["会話"] = new List<FmgType> { FmgType.TalkMsg },
                    ["武器名"] = new List<FmgType> { FmgType.WeaponName },
                    ["武器説明"] = new List<FmgType> { FmgType.WeaponInfo },
                    ["防具名"] = new List<FmgType> { FmgType.ProtectorName },
                    ["防具説明"] = new List<FmgType> { FmgType.ProtectorInfo },
                    ["項目ヘルプ"] = new List<FmgType> { FmgType.MenuContext },
                },
                ByBinderID = new()
                {
                    [1] = new List<FmgType> { FmgType.TalkMsg },
                    [3] = new List<FmgType> { FmgType.MovieSubtitle },
                    [10] = new List<FmgType> { FmgType.GoodsName },
                    [11] = new List<FmgType> { FmgType.WeaponName },
                    [12] = new List<FmgType> { FmgType.ProtectorName },
                    [18] = new List<FmgType> { FmgType.NpcName },
                    [21] = new List<FmgType> { FmgType.WeaponInfo },
                    [22] = new List<FmgType> { FmgType.ProtectorInfo },
                    [30] = new List<FmgType> { FmgType.EventText },
                    [35] = new List<FmgType> { FmgType.GeneratorName },
                    [36] = new List<FmgType> { FmgType.GeneratorInfo },
                    [38] = new List<FmgType> { FmgType.BoosterName },
                    [39] = new List<FmgType> { FmgType.BoosterInfo },
                    [41] = new List<FmgType> { FmgType.FCSName },
                    [42] = new List<FmgType> { FmgType.FCSInfo },
                    [50] = new List<FmgType> { FmgType.RankerProfile },
                    [60] = new List<FmgType> { FmgType.MissionName },
                    [61] = new List<FmgType> { FmgType.MissionSummary },
                    [62] = new List<FmgType> { FmgType.MissionObjective },
                    [63] = new List<FmgType> { FmgType.MissionPlaceName },
                    [65] = new List<FmgType> { FmgType.ArchiveName },
                    [66] = new List<FmgType> { FmgType.ArchiveContent },
                    [73] = new List<FmgType> { FmgType.TutorialTitle },
                    [74] = new List<FmgType> { FmgType.TutorialBody },
                    [200] = new List<FmgType> { FmgType.GameMenuText },
                    [201] = new List<FmgType> { FmgType.GameLineHelp },
                    [202] = new List<FmgType> { FmgType.GameKeyGuide },
                    [203] = new List<FmgType> { FmgType.GameSystemMessageWindows },
                    [204] = new List<FmgType> { FmgType.GameDialogues },
                    [205] = new List<FmgType> { FmgType.MenuContext },
                    [207] = new List<FmgType> { FmgType.LoadingTitle },
                    [208] = new List<FmgType> { FmgType.LoadingText },
                    [210] = new List<FmgType> { FmgType.TextEmbedImageNameWindows },
                },
                ToLanguageEnum = new()
                {
                    ["araae"] = FmgLanguage.Arabic,
                    ["deude"] = FmgLanguage.German,
                    ["engus"] = FmgLanguage.English,
                    ["frafr"] = FmgLanguage.French,
                    ["itait"] = FmgLanguage.Italian,
                    ["jpnjp"] = FmgLanguage.Japanese,
                    ["korkr"] = FmgLanguage.Korean,
                    ["polpl"] = FmgLanguage.Polish,
                    ["porbr"] = FmgLanguage.BrazilPortuguese,
                    ["rusru"] = FmgLanguage.Russian,
                    ["spaar"] = FmgLanguage.Spanish,
                    ["spaes"] = FmgLanguage.SpainSpanish,
                    ["thath"] = FmgLanguage.Thai,
                    ["zhocn"] = FmgLanguage.SimplifiedChinese,
                    ["zhotw"] = FmgLanguage.TraditionalChinese,
                },
                FromLanguageEnum = new()
                {
                    [FmgLanguage.Arabic] = "araae",
                    [FmgLanguage.German] = "deude",
                    [FmgLanguage.English] = "engus",
                    [FmgLanguage.French] = "frafr",
                    [FmgLanguage.Italian] = "itait",
                    [FmgLanguage.Japanese] = "jpnjp",
                    [FmgLanguage.Korean] = "korkr",
                    [FmgLanguage.Polish] = "polpl",
                    [FmgLanguage.BrazilPortuguese] = "porbr",
                    [FmgLanguage.Russian] = "rusru",
                    [FmgLanguage.Spanish] = "spaar",
                    [FmgLanguage.SpainSpanish] = "spaes",
                    [FmgLanguage.Thai] = "thath",
                    [FmgLanguage.SimplifiedChinese] = "zhocn",
                    [FmgLanguage.TraditionalChinese] = "zhotw",
                },
            },
            [FromSoftGame.Nightreign] = new FmgGameInfo
            {
                ByType = new()
                {
                    [FmgType.AccessoryCaption] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.AccessoryCaption, FmgType.AccessoryCaption, "AccessoryCaption", 27),
                    [FmgType.AccessoryInfo] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.AccessoryInfo, FmgType.AccessoryInfo, "AccessoryInfo", 23),
                    [FmgType.AccessoryName] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.AccessoryName, FmgType.AccessoryName, "AccessoryName", 13),
                    [FmgType.ActionButtonText] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.ActionButtonText, FmgType.ActionButtonText, "ActionButtonText", 32),
                    [FmgType.AntiqueCaption] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.AntiqueCaption, FmgType.AntiqueCaption, "AntiqueCaption", 49),
                    [FmgType.AntiqueInfo] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.AntiqueInfo, FmgType.AntiqueInfo, "AntiqueInfo", 48),
                    [FmgType.AntiqueName] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.AntiqueName, FmgType.AntiqueName, "AntiqueName", 47),
                    [FmgType.ArtsCaption] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.ArtsCaption, FmgType.ArtsCaption, "ArtsCaption", 43),
                    [FmgType.ArtsInfo] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.ArtsInfo, FmgType.ArtsInfo, "ArtsInfo", 45),
                    [FmgType.ArtsName] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.ArtsName, FmgType.ArtsName, "ArtsName", 42),
                    [FmgType.AttachEffectInfo] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.AttachEffectInfo, FmgType.AttachEffectInfo, "AttachEffectInfo", 50),
                    [FmgType.AttachEffectName] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.AttachEffectName, FmgType.AttachEffectName, "AttachEffectName", 44),
                    [FmgType.BloodMsg] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.BloodMsg, FmgType.BloodMsg, "BloodMsg", 2),
                    [FmgType.EventTextForMap] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.EventTextForMap, FmgType.EventTextForMap, "EventTextForMap", 34),
                    [FmgType.EventTextForTalk] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.EventTextForTalk, FmgType.EventTextForTalk, "EventTextForTalk", 33),
                    [FmgType.GameDialogues] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.GameDialogues, FmgType.GameDialogues, "CL_Dialogues", 204),
                    [FmgType.GameKeyGuide] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.GameKeyGuide, FmgType.GameKeyGuide, "CL_KeyGuide", 202),
                    [FmgType.GameLineHelp] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.GameLineHelp, FmgType.GameLineHelp, "CL_LineHelp", 201),
                    [FmgType.GameMenuText] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.GameMenuText, FmgType.GameMenuText, "CL_MenuText", 200),
                    [FmgType.GameSystemMessageWindows] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.GameSystemMessageWindows, FmgType.GameSystemMessageWindows, "CL_System_Message_win64", 203),
                    [FmgType.GoodsCaption] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.GoodsCaption, FmgType.GoodsCaption, "GoodsCaption", 24),
                    [FmgType.GoodsDialog] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.GoodsDialog, FmgType.GoodsDialog, "GoodsDialog", 41),
                    [FmgType.GoodsInfo] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.GoodsInfo, FmgType.GoodsInfo, "GoodsInfo", 20),
                    [FmgType.GoodsInfo2] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.GoodsInfo2, FmgType.GoodsInfo2, "GoodsInfo2", 46),
                    [FmgType.GoodsName] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.GoodsName, FmgType.GoodsName, "GoodsName", 10),
                    [FmgType.LoadingText] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.LoadingText, FmgType.LoadingText, "LoadingText", 206),
                    [FmgType.LoadingTitle] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.LoadingTitle, FmgType.LoadingTitle, "LoadingTitle", 205),
                    [FmgType.MagicCaption] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.MagicCaption, FmgType.MagicCaption, "MagicCaption", 29),
                    [FmgType.MagicInfo] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.MagicInfo, FmgType.MagicInfo, "MagicInfo", 28),
                    [FmgType.MagicName] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.MagicName, FmgType.MagicName, "MagicName", 14),
                    [FmgType.MovieSubtitle] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.MovieSubtitle, FmgType.MovieSubtitle, "MovieSubtitle", 3),
                    [FmgType.NetworkMessage] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.NetworkMessage, FmgType.NetworkMessage, "NetworkMessage", 31),
                    [FmgType.NpcName] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.NpcName, FmgType.NpcName, "NpcName", 18),
                    [FmgType.PermanentBuffCaption] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.PermanentBuffCaption, FmgType.PermanentBuffCaption, "PermanentBuffCaption", 53),
                    [FmgType.PermanentBuffInfo] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.PermanentBuffInfo, FmgType.PermanentBuffInfo, "PermanentBuffInfo", 52),
                    [FmgType.PermanentBuffName] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.PermanentBuffName, FmgType.PermanentBuffName, "PermanentBuffName", 51),
                    [FmgType.PersonalScenarioBody] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.PersonalScenarioBody, FmgType.PersonalScenarioBody, "PersonalScenarioBody", 213),
                    [FmgType.PersonalScenarioObjective] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.PersonalScenarioObjective, FmgType.PersonalScenarioObjective, "PersonalScenarioObjective", 211),
                    [FmgType.PersonalScenarioTitle] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.PersonalScenarioTitle, FmgType.PersonalScenarioTitle, "PersonalScenarioTitle", 212),
                    [FmgType.PlaceName] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.PlaceName, FmgType.PlaceName, "PlaceName", 19),
                    [FmgType.ProtectorCaption] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.ProtectorCaption, FmgType.ProtectorCaption, "ProtectorCaption", 26),
                    [FmgType.ProtectorInfo] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.ProtectorInfo, FmgType.ProtectorInfo, "ProtectorInfo", 22),
                    [FmgType.ProtectorName] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.ProtectorName, FmgType.ProtectorName, "ProtectorName", 12),
                    [FmgType.SpEffectCaption] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.SpEffectCaption, FmgType.SpEffectCaption, "SpEffectCaption", 216),
                    [FmgType.SpEffectInfo] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.SpEffectInfo, FmgType.SpEffectInfo, "SpEffectInfo", 215),
                    [FmgType.SpEffectName] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.SpEffectName, FmgType.SpEffectName, "SpEffectName", 214),
                    [FmgType.TalkMsg] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.TalkMsg, FmgType.TalkMsg, "TalkMsg", 1),
                    [FmgType.TalkMsgFemalePCAlt] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.TalkMsgFemalePCAlt, FmgType.TalkMsgFemalePCAlt, "TalkMsg_FemalePC_Alt", 4),
                    [FmgType.TextEmbedImageNameWindows] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.TextEmbedImageNameWindows, FmgType.TextEmbedImageNameWindows, "TextEmbedImageName_win64", 209),
                    [FmgType.TosWindows] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.TosWindows, FmgType.TosWindows, "ToS_win64", 210),
                    [FmgType.TutorialBody] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.TutorialBody, FmgType.TutorialBody, "TutorialBody", 208),
                    [FmgType.TutorialTitle] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Menu, FmgType.TutorialTitle, FmgType.TutorialTitle, "TutorialTitle", 207),
                    [FmgType.WeaponCaption] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.WeaponCaption, FmgType.WeaponCaption, "WeaponCaption", 25),
                    [FmgType.WeaponInfo] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.WeaponInfo, FmgType.WeaponInfo, "WeaponInfo", 21),
                    [FmgType.WeaponName] = new FmgKeyInfo(FromSoftGame.Nightreign, FmgCategory.Item, FmgType.WeaponName, FmgType.WeaponName, "WeaponName", 11),
                },
                Overrides = new()
                {

                },
                ByFmgName = new()
                {
                    ["AccessoryCaption"] = new List<FmgType> { FmgType.AccessoryCaption },
                    ["AccessoryInfo"] = new List<FmgType> { FmgType.AccessoryInfo },
                    ["AccessoryName"] = new List<FmgType> { FmgType.AccessoryName },
                    ["ActionButtonText"] = new List<FmgType> { FmgType.ActionButtonText },
                    ["AntiqueCaption"] = new List<FmgType> { FmgType.AntiqueCaption },
                    ["AntiqueInfo"] = new List<FmgType> { FmgType.AntiqueInfo },
                    ["AntiqueName"] = new List<FmgType> { FmgType.AntiqueName },
                    ["ArtsCaption"] = new List<FmgType> { FmgType.ArtsCaption },
                    ["ArtsInfo"] = new List<FmgType> { FmgType.ArtsInfo },
                    ["ArtsName"] = new List<FmgType> { FmgType.ArtsName },
                    ["AttachEffectInfo"] = new List<FmgType> { FmgType.AttachEffectInfo },
                    ["AttachEffectName"] = new List<FmgType> { FmgType.AttachEffectName },
                    ["BloodMsg"] = new List<FmgType> { FmgType.BloodMsg },
                    ["CL_Dialogues"] = new List<FmgType> { FmgType.GameDialogues },
                    ["CL_KeyGuide"] = new List<FmgType> { FmgType.GameKeyGuide },
                    ["CL_LineHelp"] = new List<FmgType> { FmgType.GameLineHelp },
                    ["CL_MenuText"] = new List<FmgType> { FmgType.GameMenuText },
                    ["CL_System_Message_win64"] = new List<FmgType> { FmgType.GameSystemMessageWindows },
                    ["EventTextForMap"] = new List<FmgType> { FmgType.EventTextForMap },
                    ["EventTextForTalk"] = new List<FmgType> { FmgType.EventTextForTalk },
                    ["GoodsCaption"] = new List<FmgType> { FmgType.GoodsCaption },
                    ["GoodsDialog"] = new List<FmgType> { FmgType.GoodsDialog },
                    ["GoodsInfo"] = new List<FmgType> { FmgType.GoodsInfo },
                    ["GoodsInfo2"] = new List<FmgType> { FmgType.GoodsInfo2 },
                    ["GoodsName"] = new List<FmgType> { FmgType.GoodsName },
                    ["LoadingText"] = new List<FmgType> { FmgType.LoadingText },
                    ["LoadingTitle"] = new List<FmgType> { FmgType.LoadingTitle },
                    ["MagicCaption"] = new List<FmgType> { FmgType.MagicCaption },
                    ["MagicInfo"] = new List<FmgType> { FmgType.MagicInfo },
                    ["MagicName"] = new List<FmgType> { FmgType.MagicName },
                    ["MovieSubtitle"] = new List<FmgType> { FmgType.MovieSubtitle },
                    ["NetworkMessage"] = new List<FmgType> { FmgType.NetworkMessage },
                    ["NpcName"] = new List<FmgType> { FmgType.NpcName },
                    ["PermanentBuffCaption"] = new List<FmgType> { FmgType.PermanentBuffCaption },
                    ["PermanentBuffInfo"] = new List<FmgType> { FmgType.PermanentBuffInfo },
                    ["PermanentBuffName"] = new List<FmgType> { FmgType.PermanentBuffName },
                    ["PersonalScenarioBody"] = new List<FmgType> { FmgType.PersonalScenarioBody },
                    ["PersonalScenarioObjective"] = new List<FmgType> { FmgType.PersonalScenarioObjective },
                    ["PersonalScenarioTitle"] = new List<FmgType> { FmgType.PersonalScenarioTitle },
                    ["PlaceName"] = new List<FmgType> { FmgType.PlaceName },
                    ["ProtectorCaption"] = new List<FmgType> { FmgType.ProtectorCaption },
                    ["ProtectorInfo"] = new List<FmgType> { FmgType.ProtectorInfo },
                    ["ProtectorName"] = new List<FmgType> { FmgType.ProtectorName },
                    ["SpEffectCaption"] = new List<FmgType> { FmgType.SpEffectCaption },
                    ["SpEffectInfo"] = new List<FmgType> { FmgType.SpEffectInfo },
                    ["SpEffectName"] = new List<FmgType> { FmgType.SpEffectName },
                    ["TalkMsg_FemalePC_Alt"] = new List<FmgType> { FmgType.TalkMsgFemalePCAlt },
                    ["TalkMsg"] = new List<FmgType> { FmgType.TalkMsg },
                    ["TextEmbedImageName_win64"] = new List<FmgType> { FmgType.TextEmbedImageNameWindows },
                    ["ToS_win64"] = new List<FmgType> { FmgType.TosWindows },
                    ["TutorialBody"] = new List<FmgType> { FmgType.TutorialBody },
                    ["TutorialTitle"] = new List<FmgType> { FmgType.TutorialTitle },
                    ["WeaponCaption"] = new List<FmgType> { FmgType.WeaponCaption },
                    ["WeaponInfo"] = new List<FmgType> { FmgType.WeaponInfo },
                    ["WeaponName"] = new List<FmgType> { FmgType.WeaponName },
                },
                ByBinderID = new()
                {
                    [1] = new List<FmgType> { FmgType.TalkMsg },
                    [2] = new List<FmgType> { FmgType.BloodMsg },
                    [3] = new List<FmgType> { FmgType.MovieSubtitle },
                    [4] = new List<FmgType> { FmgType.TalkMsgFemalePCAlt },
                    [10] = new List<FmgType> { FmgType.GoodsName },
                    [11] = new List<FmgType> { FmgType.WeaponName },
                    [12] = new List<FmgType> { FmgType.ProtectorName },
                    [13] = new List<FmgType> { FmgType.AccessoryName },
                    [14] = new List<FmgType> { FmgType.MagicName },
                    [18] = new List<FmgType> { FmgType.NpcName },
                    [19] = new List<FmgType> { FmgType.PlaceName },
                    [20] = new List<FmgType> { FmgType.GoodsInfo },
                    [21] = new List<FmgType> { FmgType.WeaponInfo },
                    [22] = new List<FmgType> { FmgType.ProtectorInfo },
                    [23] = new List<FmgType> { FmgType.AccessoryInfo },
                    [24] = new List<FmgType> { FmgType.GoodsCaption },
                    [25] = new List<FmgType> { FmgType.WeaponCaption },
                    [26] = new List<FmgType> { FmgType.ProtectorCaption },
                    [27] = new List<FmgType> { FmgType.AccessoryCaption },
                    [28] = new List<FmgType> { FmgType.MagicInfo },
                    [29] = new List<FmgType> { FmgType.MagicCaption },
                    [31] = new List<FmgType> { FmgType.NetworkMessage },
                    [32] = new List<FmgType> { FmgType.ActionButtonText },
                    [33] = new List<FmgType> { FmgType.EventTextForTalk },
                    [34] = new List<FmgType> { FmgType.EventTextForMap },
                    [41] = new List<FmgType> { FmgType.GoodsDialog },
                    [42] = new List<FmgType> { FmgType.ArtsName },
                    [43] = new List<FmgType> { FmgType.ArtsCaption },
                    [44] = new List<FmgType> { FmgType.AttachEffectName },
                    [45] = new List<FmgType> { FmgType.ArtsInfo },
                    [46] = new List<FmgType> { FmgType.GoodsInfo2 },
                    [47] = new List<FmgType> { FmgType.AntiqueName },
                    [48] = new List<FmgType> { FmgType.AntiqueInfo },
                    [49] = new List<FmgType> { FmgType.AntiqueCaption },
                    [50] = new List<FmgType> { FmgType.AttachEffectInfo },
                    [51] = new List<FmgType> { FmgType.PermanentBuffName },
                    [52] = new List<FmgType> { FmgType.PermanentBuffInfo },
                    [53] = new List<FmgType> { FmgType.PermanentBuffCaption },
                    [200] = new List<FmgType> { FmgType.GameMenuText },
                    [201] = new List<FmgType> { FmgType.GameLineHelp },
                    [202] = new List<FmgType> { FmgType.GameKeyGuide },
                    [203] = new List<FmgType> { FmgType.GameSystemMessageWindows },
                    [204] = new List<FmgType> { FmgType.GameDialogues },
                    [205] = new List<FmgType> { FmgType.LoadingTitle },
                    [206] = new List<FmgType> { FmgType.LoadingText },
                    [207] = new List<FmgType> { FmgType.TutorialTitle },
                    [208] = new List<FmgType> { FmgType.TutorialBody },
                    [209] = new List<FmgType> { FmgType.TextEmbedImageNameWindows },
                    [210] = new List<FmgType> { FmgType.TosWindows },
                    [211] = new List<FmgType> { FmgType.PersonalScenarioObjective },
                    [212] = new List<FmgType> { FmgType.PersonalScenarioTitle },
                    [213] = new List<FmgType> { FmgType.PersonalScenarioBody },
                    [214] = new List<FmgType> { FmgType.SpEffectName },
                    [215] = new List<FmgType> { FmgType.SpEffectInfo },
                    [216] = new List<FmgType> { FmgType.SpEffectCaption },
                },
                ToLanguageEnum = new()
                {
                    ["araae"] = FmgLanguage.Arabic,
                    ["deude"] = FmgLanguage.German,
                    ["engus"] = FmgLanguage.English,
                    ["frafr"] = FmgLanguage.French,
                    ["itait"] = FmgLanguage.Italian,
                    ["jpnjp"] = FmgLanguage.Japanese,
                    ["korkr"] = FmgLanguage.Korean,
                    ["polpl"] = FmgLanguage.Polish,
                    ["porbr"] = FmgLanguage.BrazilPortuguese,
                    ["rusru"] = FmgLanguage.Russian,
                    ["spaar"] = FmgLanguage.Spanish,
                    ["spaes"] = FmgLanguage.SpainSpanish,
                    ["thath"] = FmgLanguage.Thai,
                    ["zhocn"] = FmgLanguage.SimplifiedChinese,
                    ["zhotw"] = FmgLanguage.TraditionalChinese,
                },
                FromLanguageEnum = new()
                {
                    [FmgLanguage.Arabic] = "araae",
                    [FmgLanguage.German] = "deude",
                    [FmgLanguage.English] = "engus",
                    [FmgLanguage.French] = "frafr",
                    [FmgLanguage.Italian] = "itait",
                    [FmgLanguage.Japanese] = "jpnjp",
                    [FmgLanguage.Korean] = "korkr",
                    [FmgLanguage.Polish] = "polpl",
                    [FmgLanguage.BrazilPortuguese] = "porbr",
                    [FmgLanguage.Russian] = "rusru",
                    [FmgLanguage.Spanish] = "spaar",
                    [FmgLanguage.SpainSpanish] = "spaes",
                    [FmgLanguage.Thai] = "thath",
                    [FmgLanguage.SimplifiedChinese] = "zhocn",
                    [FmgLanguage.TraditionalChinese] = "zhotw",
                },
            },
        };
    }
}
