/*
 * Copyright (c) 2024 Nordic Semiconductor ASA
 *
 * SPDX-License-Identifier: LicenseRef-Nordic-5-Clause
 */

#include <stdint.h>
#include <stddef.h>

#if defined(CONFIG_SOC_SERIES_NRF54HX)
#define SAMPLE_FW_ADDRESS	   0x0E0AA000
#define SAMPLE_RECOVERY_FW_ADDRESS 0x0E0AB000
#else /* CONFIG_SOC_SERIES_NRF54HX */
#define SAMPLE_FW_ADDRESS	   0x80000
#define SAMPLE_RECOVERY_FW_ADDRESS 0x81000
#endif /* CONFIG_SOC_SERIES_NRF54HX */

/** @brief Sample firmware payload, attached as file.bin during manifest generation.
 *
 * @details This is a bunch of random bytes. Do not try to interpret it as a valid ARM code.
 */
const uint8_t sample_fw_buf[] = {
	0xC7, 0x9C, 0xAB, 0x9D, 0xE8, 0x33, 0x7F, 0x30, 0x14, 0xEB, 0xAC, 0x02, 0xAF, 0x26, 0x01,
	0x5E, 0x80, 0x6D, 0x88, 0xA1, 0xDB, 0x11, 0xA7, 0x31, 0xDF, 0xA6, 0xEC, 0xCB, 0x9B, 0x48,
	0x0D, 0xC8, 0x34, 0x40, 0x6D, 0x30, 0x86, 0x7D, 0xE8, 0x1B, 0xEC, 0x3C, 0xF5, 0x40, 0xD0,
	0x48, 0x18, 0x82, 0x11, 0x9D, 0x7C, 0x3F, 0x6C, 0xE5, 0x8F, 0xF1, 0xD3, 0x5D, 0xE1, 0x51,
	0xF7, 0x6A, 0x0F, 0xAF, 0x0B, 0xBD, 0x4C, 0x5F, 0xA5, 0x34, 0x1A, 0x66, 0xDB, 0x22, 0xEC,
	0x63, 0xED, 0x4B, 0xAB, 0xC7, 0xC8, 0xF7, 0x59, 0xD8, 0xD6, 0x9E, 0xEC, 0x71, 0x1B, 0x24,
	0x20, 0xB9, 0xAE, 0xE1, 0x3B, 0xFC, 0xAE, 0xB8, 0x77, 0xAC, 0xA4, 0x57, 0x34, 0x97, 0x84,
	0x4F, 0x58, 0xD5, 0x68, 0x08, 0x6F, 0xE3, 0x9C, 0x7E, 0x1B, 0xD7, 0x38, 0x22, 0x98, 0x48,
	0xF8, 0x7A, 0x67, 0xB2, 0xD9, 0xAC, 0xC5, 0x34, 0xC1, 0x27, 0x82, 0x8E, 0x42, 0x79, 0x84,
	0x21, 0x37, 0x4C, 0x41, 0x4A, 0x0F, 0xE2, 0x7F, 0xA0, 0x6A, 0x19, 0x13, 0x3D, 0x52, 0x22,
	0x7F, 0xD6, 0x2F, 0x71, 0x12, 0x76, 0xAB, 0x25, 0x9C, 0xFC, 0x67, 0x08, 0x03, 0x7C, 0xDB,
	0x18, 0xE6, 0x45, 0xF8, 0x99, 0xC2, 0x9E, 0x2C, 0xE3, 0x9B, 0x25, 0xA9, 0x7B, 0x09, 0xFF,
	0x00, 0x57, 0x26, 0x08, 0x0A, 0x11, 0x42, 0xCF, 0x82, 0xA2, 0x6B, 0x2A, 0x99, 0xF9, 0x71,
	0x9D, 0x14, 0x19, 0x5C, 0x5C, 0x78, 0x31, 0x60, 0x42, 0x4A, 0x18, 0x1F, 0xEC, 0x78, 0x6A,
	0x9A, 0x7C, 0x4F, 0xCF, 0xE8, 0x5A, 0x29, 0x65, 0xCD, 0x01, 0x3B, 0x6D, 0x53, 0xBB, 0xC6,
	0xDB, 0xDA, 0xD5, 0x8F, 0xF7, 0xF4, 0xD9, 0xB9, 0x0A, 0x03, 0x4B, 0xFF, 0x33, 0xAB, 0x3B,
	0xC5, 0xAF, 0xD0, 0xB8, 0x2C, 0x0F, 0x6A, 0xA9, 0x11, 0xB0, 0xE8, 0x57, 0x8C, 0x92, 0x53,
	0x81};

const size_t sample_fw_len = sizeof(sample_fw_buf);
const uintptr_t sample_fw_address = SAMPLE_FW_ADDRESS;
const uintptr_t sample_recovery_fw_address = SAMPLE_RECOVERY_FW_ADDRESS;
