/*
 * Copyright (c) 2022 Nordic Semiconductor ASA
 *
 * SPDX-License-Identifier: LicenseRef-Nordic-5-Clause
 */

#include "sensor_sim_ctrl.h"

/* This configuration file is included only once from sensor_sim_ctrl module and holds
 * information about wave signals that should be generated by simulated sensor.
 */

/* This structure enforces the header file is included only once in the build.
 * Violating this requirement triggers a multiple definition error at link time.
 */
const struct {} sensor_sim_ctrl_def_include_once;

static const struct sim_wave sim_wave = {
		.label = "sine",
		.wave_param = {
			.type = WAVE_GEN_TYPE_SINE,
			.period_ms = 2000,
			.offset = 0.0,
			.amplitude = 0.5,
			.noise = 0.1,
		},
};

static const struct sim_signal_params sim_signal_params = {
	.chan = SENSOR_CHAN_ACCEL_XYZ,
	.wave = sim_wave,
};
