/*
 * Copyright (c) 2020 Nordic Semiconductor ASA
 *
 * SPDX-License-Identifier: LicenseRef-Nordic-5-Clause
 */

#include <zephyr/ztest.h>
#include <zephyr/tc_util.h>

#include "sw_codec_lc3.h"

static const int16_t sample_sine_100hz[] = {
	0x0000, 0x0157, 0x02AE, 0x0405, 0x055D, 0x06B1, 0x080A, 0x095F, 0x0AB2, 0x0C0C, 0x0D5B,
	0x0EB4, 0x1002, 0x115C, 0x12A3, 0x1401, 0x1543, 0x16A1, 0x17E2, 0x1938, 0x1A7F, 0x1BCC,
	0x1D17, 0x1E5C, 0x1FA7, 0x20E6, 0x2233, 0x236F, 0x24B3, 0x25F3, 0x272E, 0x286D, 0x29A5,
	0x2AE0, 0x2C16, 0x2D4A, 0x2E7D, 0x2FAD, 0x30DE, 0x3206, 0x3337, 0x3458, 0x3583, 0x36A5,
	0x37C2, 0x38E8, 0x39FD, 0x3B1B, 0x3C31, 0x3D42, 0x3E5A, 0x3F62, 0x4073, 0x4179, 0x4282,
	0x4384, 0x4485, 0x4583, 0x467B, 0x4776, 0x4868, 0x4959, 0x4A49, 0x4B2F, 0x4C1C, 0x4CFA,
	0x4DE0, 0x4EB9, 0x4F96, 0x5068, 0x5140, 0x520A, 0x52D9, 0x53A0, 0x5463, 0x5526, 0x55DF,
	0x569D, 0x574D, 0x5803, 0x58AD, 0x5958, 0x59FE, 0x5AA0, 0x5B3C, 0x5BD8, 0x5C6D, 0x5CFD,
	0x5D8D, 0x5E16, 0x5E99, 0x5F20, 0x5F96, 0x6013, 0x6089, 0x60F3, 0x6168, 0x61C9, 0x622F,
	0x628F, 0x62E9, 0x6340, 0x6392, 0x63DE, 0x642D, 0x646A, 0x64B5, 0x64E7, 0x6526, 0x6556,
	0x6587, 0x65AE, 0x65DB, 0x65F4, 0x6619, 0x662C, 0x6644, 0x6650, 0x6660, 0x6662, 0x6668,
	0x6664, 0x665C, 0x6654, 0x6640, 0x6632, 0x6612, 0x65FC, 0x65D4, 0x65B1, 0x6588, 0x6555,
	0x6525, 0x64EC, 0x64AE, 0x6470, 0x6429, 0x63DF, 0x6394, 0x633F, 0x62E8, 0x6291, 0x622B,
	0x61CF, 0x6161, 0x60F7, 0x6089, 0x6010, 0x5F9B, 0x5F1A, 0x5E9C, 0x5E15, 0x5D8E, 0x5CFB,
	0x5C71, 0x5BD2, 0x5B43, 0x5A9A, 0x5A01, 0x5957, 0x58AE, 0x5802, 0x574F, 0x5698, 0x55E5,
	0x5522, 0x5465, 0x53A0, 0x52D6, 0x520E, 0x513D, 0x506A, 0x4F96, 0x4EBA, 0x4DDC, 0x4D00,
	0x4C15, 0x4B36, 0x4A44, 0x495C, 0x4866, 0x4776, 0x467B, 0x4583, 0x4486, 0x4383, 0x4282,
	0x4179, 0x4072, 0x3F65, 0x3E58, 0x3D43, 0x3C32, 0x3B16, 0x3A05, 0x38DF, 0x37CA, 0x36A2,
	0x3580, 0x345E, 0x3331, 0x3209, 0x30DE, 0x2FAD, 0x2E7C, 0x2D4D, 0x2C12, 0x2AE2, 0x29A5,
	0x286D, 0x272F, 0x25F2, 0x24B1, 0x2375, 0x2229, 0x20F1, 0x1F9E, 0x1E62, 0x1D13, 0x1BCD,
	0x1A81, 0x1934, 0x17E9, 0x1697, 0x154C, 0x13FB, 0x12A7, 0x115A, 0x1002, 0x0EB4, 0x0D5C,
	0x0C0A, 0x0AB4, 0x095E, 0x080A, 0x06B1, 0x055D, 0x0405, 0x02AE, 0x0157, 0x0001, 0xFEA6,
	0xFD57, 0xFBF5, 0xFAA8, 0xF94C, 0xF7F7, 0xF6A2, 0xF54B, 0xF3F9, 0xF29F, 0xF152, 0xEFF8,
	0xEEA9, 0xED5A, 0xEC01, 0xEABC, 0xE95F, 0xE820, 0xE6C3, 0xE587, 0xE42E, 0xE2F0, 0xE19E,
	0xE05E, 0xDF15, 0xDDD0, 0xDC91, 0xDB4A, 0xDA13, 0xD8CD, 0xD795, 0xD658, 0xD522, 0xD3EB,
	0xD2B6, 0xD181, 0xD054, 0xCF22, 0xCDF9, 0xCCCC, 0xCBA4, 0xCA81, 0xC958, 0xC83F, 0xC719,
	0xC602, 0xC4E6, 0xC3CD, 0xC2C0, 0xC1A5, 0xC09E, 0xBF8E, 0xBE84, 0xBD82, 0xBC7A, 0xBB7A,
	0xBA80, 0xB982, 0xB88C, 0xB798, 0xB6A5, 0xB5BB, 0xB4CD, 0xB3E9, 0xB2FF, 0xB227, 0xB140,
	0xB070, 0xAF94, 0xAEC2, 0xADF6, 0xAD25, 0xAC62, 0xAB9B, 0xAADC, 0xAA1E, 0xA969, 0xA8AC,
	0xA804, 0xA74C, 0xA6AD, 0xA5FF, 0xA562, 0xA4C3, 0xA429, 0xA392, 0xA305, 0xA26E, 0xA1F0,
	0xA161, 0xA0E8, 0xA063, 0x9FF1, 0x9F76, 0x9F0B, 0x9E9C, 0x9E33, 0x9DD5, 0x9D6D, 0x9D1B,
	0x9CBD, 0x9C6F, 0x9C22, 0x9BD2, 0x9B96, 0x9B4D, 0x9B17, 0x9ADC, 0x9AA6, 0x9A7E, 0x9A4C,
	0x9A2C, 0x9A05, 0x99ED, 0x99CF, 0x99C1, 0x99A9, 0x99A7, 0x9999, 0x999B, 0x999C, 0x99A1,
	0x99B0, 0x99BC, 0x99D2, 0x99EA, 0x9A09, 0x9A28, 0x9A50, 0x9A79, 0x9AAA, 0x9ADB, 0x9B15,
	0x9B50, 0x9B92, 0x9BD6, 0x9C20, 0x9C6F, 0x9CBD, 0x9D1C, 0x9D6C, 0x9DD7, 0x9E32, 0x9E9B,
	0x9F0C, 0x9F77, 0x9FEF, 0xA067, 0xA0E3, 0xA165, 0xA1EC, 0xA272, 0xA303, 0xA391, 0xA42D,
	0xA4BD, 0xA567, 0xA5FE, 0xA6A9, 0xA754, 0xA7FA, 0xA8B7, 0xA960, 0xAA23, 0xAAD9, 0xAB9D,
	0xAC60, 0xAD28, 0xADF4, 0xAEC2, 0xAF96, 0xB06B, 0xB146, 0xB221, 0xB304, 0xB3E6, 0xB4CF,
	0xB5B9, 0xB6A6, 0xB797, 0xB88E, 0xB980, 0xBA81, 0xBB78, 0xBC7F, 0xBD7D, 0xBE87, 0xBF8D,
	0xC09C, 0xC1AA, 0xC2BA, 0xC3D0, 0xC4E7, 0xC5FF, 0xC71D, 0xC83B, 0xC959, 0xCA83, 0xCB9F,
	0xCCD4, 0xCDEF, 0xCF2C, 0xD04B, 0xD188, 0xD2B3, 0xD3EB, 0xD521, 0xD65B, 0xD791, 0xD8D5,
	0xDA08, 0xDB55, 0xDC87, 0xDDD9, 0xDF0F, 0xE060, 0xE19F, 0xE2EE, 0xE432, 0xE581, 0xE6CA,
	0xE817, 0xE96A, 0xEAB3, 0xEC08, 0xED54, 0xEEAB, 0xEFF9, 0xF150, 0xF2A3, 0xF3F4, 0xF54E,
	0xF6A1, 0xF7F5, 0xF952, 0xFA9F, 0xFBFF, 0xFD4F, 0xFEAA, 0x0000, 0x0157, 0x02AF, 0x0404,
	0x055D, 0x06B2, 0x080A, 0x095C, 0x0AB7, 0x0C07, 0x0D5F, 0x0EB3, 0x1000, 0x115C, 0x12A7,
	0x13FA, 0x154C, 0x1697, 0x17EA, 0x1933, 0x1A82, 0x1BCA, 0x1D17, 0x1E5D, 0x1FA5, 0x20E9,
	0x2230, 0x2371, 0x24B3, 0x25F2, 0x272E, 0x286E, 0x29A5, 0x2AE1, 0x2C13, 0x2D4D, 0x2E7B,
	0x2FAF, 0x30DD, 0x3207, 0x3336, 0x3459, 0x3583, 0x36A3, 0x37C7, 0x38E1, 0x3A04, 0x3B16,
	0x3C33, 0x3D43, 0x3E57, 0x3F65, 0x4072, 0x4179, 0x4282, 0x4384, 0x4485, 0x4582, 0x467D,
	0x4774, 0x4869, 0x4958, 0x4A49, 0x4B30, 0x4C1B, 0x4CFB, 0x4DDF, 0x4EBA, 0x4F95, 0x506B,
	0x513C, 0x520F, 0x52D4, 0x53A4, 0x5461, 0x5527, 0x55DF, 0x569D, 0x574C, 0x5804, 0x58AC,
	0x5958, 0x5A00, 0x5A9D, 0x5B3F, 0x5BD5, 0x5C6E, 0x5CFF, 0x5D8B, 0x5E16, 0x5E9B, 0x5F1D,
	0x5F98, 0x6013, 0x6087, 0x60F6, 0x6165, 0x61C9, 0x6230, 0x628F, 0x62E8, 0x6340, 0x6392,
	0x63DF, 0x642D, 0x646A, 0x64B3, 0x64EA, 0x6525, 0x6555, 0x6589, 0x65AD, 0x65DB, 0x65F5,
	0x6618, 0x662C, 0x6645, 0x664F, 0x6660, 0x6663, 0x6668, 0x6662, 0x665F, 0x6651, 0x6642,
	0x662F, 0x6616, 0x65F7, 0x65DB, 0x65AA, 0x658C, 0x6553, 0x6526, 0x64EA, 0x64B2, 0x646B,
	0x642E, 0x63DC, 0x6395, 0x633D, 0x62EB, 0x628D, 0x6230, 0x61CA, 0x6165, 0x60F5, 0x6089,
	0x6011, 0x5F98, 0x5F20, 0x5E96, 0x5E1B, 0x5D87, 0x5D01, 0x5C6C, 0x5BD6, 0x5B41, 0x5A9A,
	0x5A02, 0x5955, 0x58AF, 0x5804, 0x574B, 0x569E, 0x55DE, 0x5526, 0x5465, 0x539F, 0x52D8,
	0x520B, 0x5140, 0x5067, 0x4F98, 0x4EB8, 0x4DDE, 0x4CFE, 0x4C17, 0x4B33, 0x4A48, 0x4957,
	0x486C, 0x4770, 0x4680, 0x4580, 0x4488, 0x4381, 0x4285, 0x4176, 0x4076, 0x3F60, 0x3E5B,
	0x3D41, 0x3C35, 0x3B15, 0x3A03, 0x38E1, 0x37C8, 0x36A4, 0x3581, 0x345A, 0x3334, 0x320A,
	0x30DB, 0x2FAE, 0x2E7F, 0x2D48, 0x2C16, 0x2AE2, 0x29A1, 0x2872, 0x272B, 0x25F5, 0x24B0,
	0x2373, 0x222E, 0x20E9, 0x1FA7, 0x1E5B, 0x1D18, 0x1BC9, 0x1A83, 0x1932, 0x17EB, 0x1696,
	0x154F, 0x13F5, 0x12AD, 0x1155, 0x1006, 0x0EB1, 0x0D5F, 0x0C08, 0x0AB4, 0x0960, 0x0807,
	0x06B4, 0x055C, 0x0404, 0x02B0, 0x0155, 0x0002, 0xFEA7, 0xFD54, 0xFBF9, 0xFAA4, 0xF94F,
	0xF7F5, 0xF6A3, 0xF54C, 0xF3F5, 0xF2A4, 0xF14E, 0xEFFA, 0xEEAC, 0xED52, 0xEC0A, 0xEAB2,
	0xE96A, 0xE816, 0xE6CD, 0xE57E, 0xE433, 0xE2ED, 0xE1A0, 0xE05F, 0xDF13, 0xDDD1, 0xDC91,
	0xDB49, 0xDA15, 0xD8CB, 0xD795, 0xD65C, 0xD51C, 0xD3EF, 0xD2B3, 0xD185, 0xD052, 0xCF22,
	0xCDF9, 0xCCCA, 0xCBA8, 0xCA7E, 0xC95B, 0xC83D, 0xC718, 0xC603, 0xC4E5, 0xC3D0, 0xC2BC,
	0xC1A9, 0xC09A, 0xBF91, 0xBE83, 0xBD81, 0xBC7B, 0xBB7B, 0xBA7E, 0xB983, 0xB88B, 0xB79A,
	0xB6A4, 0xB5BA, 0xB4CD, 0xB3E8, 0xB303, 0xB223, 0xB142, 0xB071, 0xAF90, 0xAEC7, 0xADF1,
	0xAD29, 0xAC61, 0xAB9B, 0xAADB, 0xAA21, 0xA964, 0xA8B1, 0xA7FF, 0xA752, 0xA6A8, 0xA603,
	0xA55F, 0xA4C4, 0xA42A, 0xA391, 0xA304, 0xA272, 0xA1ED, 0xA163, 0xA0E5, 0xA065, 0x9FEF,
	0x9F7B, 0x9F07, 0x9E9C, 0x9E36, 0x9DD0, 0x9D74, 0x9D15, 0x9CC0, 0x9C6F, 0x9C1E, 0x9BDA,
	0x9B8D, 0x9B55, 0x9B10, 0x9ADF, 0x9AA7, 0x9A7B, 0x9A4F, 0x9A29, 0x9A08, 0x99E9, 0x99D4,
	0x99BB, 0x99AF, 0x99A2, 0x999C, 0x9999, 0x999E, 0x999F, 0x99B1, 0x99BC, 0x99D1, 0x99ED,
	0x9A03, 0x9A2F, 0x9A4B, 0x9A7C, 0x9AA9, 0x9AD9, 0x9B1A, 0x9B4A, 0x9B97, 0x9BD2, 0x9C24,
	0x9C6A, 0x9CC4, 0x9D13, 0x9D75, 0x9DCF, 0x9E37, 0x9E9A, 0x9F0C, 0x9F74, 0x9FF4, 0xA062,
	0xA0E7, 0xA164, 0xA1E9, 0xA276, 0xA300, 0xA394, 0xA429, 0xA4C4, 0xA55E, 0xA605, 0xA6A6,
	0xA752, 0xA801, 0xA8AE, 0xA967, 0xAA20, 0xAAD7, 0xABA3, 0xAC59, 0xAD2D, 0xADF2, 0xAEC3,
	0xAF95, 0xB06C, 0xB145, 0xB222, 0xB305, 0xB3E4, 0xB4D1, 0xB5B6, 0xB6AB, 0xB791, 0xB894,
	0xB97C, 0xBA82, 0xBB7A, 0xBC7A, 0xBD82, 0xBE83, 0xBF90, 0xC09B, 0xC1A8, 0xC2BE, 0xC3CD,
	0xC4E8, 0xC5FF, 0xC71D, 0xC83B, 0xC95A, 0xCA81, 0xCBA3, 0xCCCD, 0xCDFA, 0xCF1F, 0xD055,
	0xD183, 0xD2B3, 0xD3EF, 0xD51D, 0xD65D, 0xD78F, 0xD8D5, 0xDA0B, 0xDB50, 0xDC8D, 0xDDD1,
	0xDF16, 0xE05C, 0xE1A1, 0xE2EC, 0xE434, 0xE57F, 0xE6CB, 0xE818, 0xE968, 0xEAB5, 0xEC06,
	0xED56, 0xEEA9, 0xEFFC, 0xF14E, 0xF2A1, 0xF3FA, 0xF548, 0xF6A4, 0xF7F6, 0xF94D, 0xFAA6,
	0xFBF9, 0xFD54, 0xFEA6, 0x0003, 0x0155, 0x02AE, 0x0408, 0x0558, 0x06B7, 0x0805, 0x0960,
	0x0AB5, 0x0C07, 0x0D5F, 0x0EB2, 0x1003, 0x115B, 0x12A4, 0x13FF, 0x1546, 0x169F, 0x17E3,
	0x1937, 0x1A7F, 0x1BCD, 0x1D16, 0x1E5C, 0x1FA7, 0x20E6, 0x2233, 0x236F, 0x24B3, 0x25F3,
	0x272D, 0x286F, 0x29A3, 0x2AE3, 0x2C12, 0x2D4E, 0x2E78, 0x2FB2, 0x30DA, 0x320B, 0x3332,
	0x345A, 0x3582, 0x36A5, 0x37C5, 0x38E5, 0x39FC, 0x3B20, 0x3C2A, 0x3D4B, 0x3E52, 0x3F66,
	0x4072, 0x417A, 0x4281, 0x4386, 0x4483, 0x4582, 0x467E, 0x4772, 0x486C, 0x4956, 0x4A4A,
	0x4B2F, 0x4C1C, 0x4CFA, 0x4DE0, 0x4EB8, 0x4F98, 0x5067, 0x5140, 0x520A, 0x52D9, 0x539F,
	0x5466, 0x5522, 0x55E2, 0x569A, 0x574E, 0x5805, 0x58A9, 0x595E, 0x59F8, 0x5AA3, 0x5B3B,
	0x5BD9, 0x5C6B, 0x5D01, 0x5D89, 0x5E18, 0x5E9A, 0x5F1B, 0x5F9C, 0x600F, 0x6089, 0x60F6,
	0x6163, 0x61CC, 0x622E, 0x6290, 0x62E7, 0x6341, 0x6392, 0x63DF, 0x642C, 0x646C, 0x64B2,
	0x64EA, 0x6526, 0x6554, 0x6589, 0x65AF, 0x65D6, 0x65FD, 0x660E, 0x6636, 0x663D, 0x6654,
	0x665E, 0x6662, 0x6668, 0x6664, 0x665D, 0x6652, 0x6643, 0x662E, 0x6615, 0x65FA, 0x65D6,
	0x65AF, 0x658B, 0x6550, 0x652B, 0x64E6, 0x64B2, 0x6470, 0x6427, 0x63E1, 0x6392, 0x633F,
	0x62EC, 0x628C, 0x622F, 0x61CB, 0x6165, 0x60F6, 0x6087, 0x6011, 0x5F9B, 0x5F1B, 0x5E9C,
	0x5E14, 0x5D8E, 0x5CFB, 0x5C70, 0x5BD5, 0x5B3E, 0x5AA0, 0x59FE, 0x5955, 0x58B2, 0x57FE,
	0x5751, 0x5699, 0x55E2, 0x5524, 0x5465, 0x539F, 0x52D7, 0x520D, 0x513E, 0x5069, 0x4F97,
	0x4EB9, 0x4DDE, 0x4CFC, 0x4C1B, 0x4B30, 0x4A4A, 0x4957, 0x4869, 0x4773, 0x467F, 0x4580,
	0x4487, 0x4382, 0x4283, 0x4178, 0x4074, 0x3F62, 0x3E59, 0x3D43, 0x3C32, 0x3B17, 0x3A03,
	0x38E2, 0x37C7, 0x36A2, 0x3583, 0x345A, 0x3335, 0x3207, 0x30DE, 0x2FAC, 0x2E7E, 0x2D4B,
	0x2C13, 0x2AE4, 0x29A0, 0x2871, 0x272C, 0x25F6, 0x24AF, 0x2375, 0x222A, 0x20EE, 0x1FA3,
	0x1E5E, 0x1D17, 0x1BC8, 0x1A84, 0x1933, 0x17E8, 0x169B, 0x1548, 0x13FB, 0x12A9, 0x1159,
	0x1003, 0x0EB4, 0x0D5B, 0x0C0B, 0x0AB3, 0x0960, 0x0808, 0x06B3, 0x055C, 0x0405, 0x02AD,
	0x0159, 0xFFFE, 0xFEAC, 0xFD4E, 0xFBFF, 0xFA9F, 0xF953, 0xF7F2, 0xF6A5, 0xF54A, 0xF3F8,
	0xF2A3, 0xF14D, 0xEFFA, 0xEEAB, 0xED55, 0xEC08, 0xEAB4, 0xE967, 0xE817, 0xE6CE, 0xE57D,
	0xE435, 0xE2EB, 0xE1A2, 0xE05B, 0xDF16, 0xDDD1, 0xDC90, 0xDB4C, 0xDA0F, 0xD8D0, 0xD795,
	0xD657, 0xD525, 0xD3E5, 0xD2BB, 0xD181, 0xD052, 0xCF24, 0xCDF7, 0xCCCB, 0xCBA8, 0xCA7C,
	0xC95F, 0xC837, 0xC71F, 0xC5FC, 0xC4EB, 0xC3CD, 0xC2BD, 0xC1A7, 0xC09C, 0xBF8E, 0xBE88,
	0xBD7C, 0xBC7E, 0xBB79, 0xBA7F, 0xB983, 0xB88C, 0xB797, 0xB6A7, 0xB5B9, 0xB4CD, 0xB3E8,
	0xB303, 0xB221, 0xB147, 0xB06A, 0xAF96, 0xAEC2, 0xADF5, 0xAD27, 0xAC61, 0xAB9C, 0xAADA,
	0xAA21, 0xA963, 0xA8B5, 0xA7FA, 0xA756, 0xA6A5, 0xA604, 0xA561, 0xA4C1, 0xA42C, 0xA390,
	0xA305, 0xA271, 0xA1EC, 0xA165, 0xA0E5, 0xA064, 0x9FF1, 0x9F76, 0x9F0B, 0x9E9D, 0x9E32,
	0x9DD5, 0x9D6D, 0x9D1B, 0x9CBD, 0x9C71, 0x9C1E, 0x9BD6, 0x9B92, 0x9B50, 0x9B15, 0x9ADD,
	0x9AA7, 0x9A7C, 0x9A4D, 0x9A2C, 0x9A05, 0x99ED, 0x99D1, 0x99BC, 0x99B1, 0x999E, 0x99A1,
	0x9994, 0x99A2, 0x999D, 0x99B1, 0x99BD, 0x99CF, 0x99EE, 0x9A05, 0x9A2B, 0x9A4E, 0x9A7A,
	0x9AA8, 0x9ADE, 0x9B13, 0x9B52, 0x9B8F, 0x9BD7, 0x9C21, 0x9C6E, 0x9CC0, 0x9D18, 0x9D6D,
	0x9DD8, 0x9E2E, 0x9EA3, 0x9F03, 0x9F7F, 0x9FE7, 0xA06D, 0xA0E0, 0xA166, 0xA1EB, 0xA273,
	0xA303, 0xA393, 0xA427, 0xA4C7, 0xA55A, 0xA609, 0xA6A3, 0xA755, 0xA7FF, 0xA8AE, 0xA968,
	0xAA1C, 0xAADF, 0xAB99, 0xAC64, 0xAD25, 0xADF5, 0xAEC2, 0xAF96, 0xB06B, 0xB147, 0xB220,
	0xB305, 0xB3E6, 0xB4CE, 0xB5B9, 0xB6A7, 0xB797, 0xB88B, 0xB986, 0xBA7A, 0xBB7F, 0xBC79,
	0xBD7F, 0xBE88, 0xBF8C, 0xC09D, 0xC1A9, 0xC2BA, 0xC3D3, 0xC4E1, 0xC607, 0xC715, 0xC840,
	0xC959, 0xCA7E, 0xCBA8, 0xCCC9, 0xCDFB, 0xCF20, 0xD055, 0xD181, 0xD2B6, 0xD3EC, 0xD51F,
	0xD65B, 0xD794, 0xD8CF, 0xDA10, 0xDB4C, 0xDC8F, 0xDDD3, 0xDF13, 0xE05F, 0xE19E, 0xE2EF,
	0xE430, 0xE585, 0xE6C5, 0xE81E, 0xE962, 0xEAB8, 0xEC06, 0xED56, 0xEEA9, 0xEFFC, 0xF14C,
	0xF2A6, 0xF3F1, 0xF554, 0xF699, 0xF7FF, 0xF948, 0xFAA5, 0xFBFD, 0xFD4F, 0xFEAB, 0xFFFF,
	0x0157, 0x02AF, 0x0405, 0x055A, 0x06B6, 0x0805, 0x0962, 0x0AB3, 0x0C08, 0x0D60, 0x0EAD,
	0x100B, 0x1153, 0x12AD, 0x13F7, 0x154A, 0x169B, 0x17E8, 0x1933, 0x1A84, 0x1BC7, 0x1D1A,
	0x1E5B, 0x1FA4, 0x20ED, 0x222C, 0x2372, 0x24B5, 0x25ED, 0x2734, 0x286A, 0x29A6, 0x2AE1,
	0x2C13, 0x2D4C, 0x2E7C, 0x2FAF, 0x30DD, 0x3206, 0x3336, 0x3459, 0x3584, 0x36A2, 0x37C7,
	0x38E2, 0x3A01, 0x3B1A, 0x3C30, 0x3D45, 0x3E55, 0x3F67, 0x406E, 0x417F, 0x427D, 0x4387,
	0x4482, 0x4586, 0x4679, 0x4777, 0x4868, 0x4958, 0x4A4A, 0x4B2E, 0x4C1C, 0x4CFD, 0x4DDC,
	0x4EBC, 0x4F94, 0x506A, 0x513F, 0x520A, 0x52D9, 0x53A0, 0x5464, 0x5523, 0x55E4, 0x5696,
	0x5754, 0x57FD, 0x58B1, 0x5957, 0x59FD, 0x5AA1, 0x5B3C, 0x5BD8, 0x5C6D, 0x5CFC, 0x5D90,
	0x5E13, 0x5E9C, 0x5F1C, 0x5F98, 0x6014, 0x6086, 0x60F7, 0x6165, 0x61C8, 0x6232, 0x628C,
	0x62EB, 0x633F, 0x6393, 0x63DE, 0x642C, 0x646C, 0x64B2, 0x64EA, 0x6524, 0x6558, 0x6584,
	0x65B4, 0x65D2, 0x65FD, 0x6613, 0x662F, 0x6644, 0x664E, 0x6663, 0x6660, 0x6668, 0x6665,
	0x665B, 0x6655, 0x6640, 0x6630, 0x6615, 0x65F9, 0x65D6, 0x65B1, 0x6586, 0x6558, 0x6522,
	0x64EE, 0x64AE, 0x646E, 0x642E, 0x63D9, 0x6398, 0x633D, 0x62E9, 0x6291, 0x622A, 0x61D1,
	0x615F, 0x60FA, 0x6084, 0x6014, 0x5F99, 0x5F1C, 0x5E9C, 0x5E13, 0x5D8E, 0x5CFF, 0x5C6A,
	0x5BDA, 0x5B3A, 0x5AA1, 0x59FF, 0x5955, 0x58B2, 0x57FD, 0x5752, 0x5699, 0x55E1, 0x5528,
	0x545E, 0x53A6, 0x52D2, 0x5211, 0x513A, 0x506D, 0x4F92, 0x4EBE, 0x4DDB, 0x4CFE, 0x4C19,
	0x4B31, 0x4A48, 0x495A, 0x4867, 0x4777, 0x4679, 0x4586, 0x4481, 0x4388, 0x4280, 0x4179,
	0x4075, 0x3F5F, 0x3E5C, 0x3D41, 0x3C34, 0x3B17, 0x3A00, 0x38E4, 0x37C5, 0x36A6, 0x3581,
	0x3458, 0x3338, 0x3205, 0x30DE, 0x2FAF, 0x2E7B, 0x2D4B, 0x2C19, 0x2AD8, 0x29AE, 0x2866,
	0x2733, 0x25F0, 0x24B4, 0x2370, 0x2230, 0x20E8, 0x1FA8, 0x1E59, 0x1D1B, 0x1BC6, 0x1A85,
	0x1933, 0x17E8, 0x1699, 0x154C, 0x13F7, 0x12AD, 0x1154, 0x1007, 0x0EB0, 0x0D60, 0x0C06,
	0x0AB8, 0x095B, 0x080B, 0x06B1, 0x055E, 0x0402, 0x02B3, 0x0152, 0x0003, 0xFEA9, 0xFD50,
	0xFBFD, 0xFAA3, 0xF94D, 0xF7F8, 0xF6A2, 0xF54A, 0xF3F8, 0xF2A2, 0xF14E, 0xEFFC, 0xEEA8,
	0xED56, 0xEC07, 0xEAB5, 0xE968, 0xE816, 0xE6CE, 0xE57C, 0xE438, 0xE2E8, 0xE1A4, 0xE05A,
	0xDF16, 0xDDD2, 0xDC8F, 0xDB4C, 0xDA10, 0xD8CE, 0xD797, 0xD657, 0xD523, 0xD3E8, 0xD2B9,
	0xD181, 0xD052, 0xCF26, 0xCDF3, 0xCCD1, 0xCBA1, 0xCA82, 0xC95A, 0xC83D, 0xC719, 0xC602,
	0xC4E5, 0xC3D2, 0xC2B9, 0xC1AC, 0xC098, 0xBF90, 0xBE86, 0xBD7E, 0xBC7E, 0xBB78, 0xBA80,
	0xB981, 0xB88E, 0xB795, 0xB6AB, 0xB5B3, 0xB4D3, 0xB3E3, 0xB307, 0xB21E, 0xB14A, 0xB066,
	0xAF9B, 0xAEBF, 0xADF5, 0xAD29, 0xAC5E, 0xAB9E, 0xAADC, 0xAA1D, 0xA968, 0xA8AD, 0xA803,
	0xA74F, 0xA6AA, 0xA602, 0xA55F, 0xA4C5, 0xA427, 0xA395, 0xA2FF, 0xA277, 0xA1E8, 0xA165,
	0xA0E7, 0xA062, 0x9FF2, 0x9F76, 0x9F0A, 0x9E9C, 0x9E36, 0x9DD0, 0x9D72, 0x9D17, 0x9CC0,
	0x9C6E, 0x9C20, 0x9BD7, 0x9B91, 0x9B50, 0x9B15, 0x9ADD, 0x9AA7, 0x9A7D, 0x9A4B, 0x9A2D,
	0x9A07, 0x99E9, 0x99D3, 0x99BC, 0x99AF, 0x99A4, 0x999A, 0x999B, 0x999B, 0x99A2, 0x99B1,
	0x99B9, 0x99D6, 0x99E7, 0x9A0A, 0x9A28, 0x9A50, 0x9A79, 0x9AA9, 0x9ADD, 0x9B13, 0x9B51,
	0x9B92, 0x9BD5, 0x9C21, 0x9C6E, 0x9CBF, 0x9D18, 0x9D71, 0x9DD1, 0x9E35, 0x9E9E, 0x9F05,
	0x9F7E, 0x9FE9, 0xA06B, 0xA0E1, 0xA166, 0xA1EB, 0xA272, 0xA305, 0xA38F, 0xA42D, 0xA4C0,
	0xA564, 0xA5FE, 0xA6AC, 0xA74E, 0xA802, 0xA8B0, 0xA965, 0xAA1F, 0xAADC, 0xAB9B, 0xAC62,
	0xAD25, 0xADF8, 0xAEBF, 0xAF97, 0xB06C, 0xB143, 0xB226, 0xB2FF, 0xB3EB, 0xB4C9, 0xB5BF,
	0xB6A0, 0xB79E, 0xB886, 0xB988, 0xBA7B, 0xBB7B, 0xBC7D, 0xBD80, 0xBE83, 0xBF92, 0xC097,
	0xC1AB, 0xC2BD, 0xC3CD, 0xC4E9, 0xC5FE, 0xC71C, 0xC83B, 0xC95C, 0xCA7F, 0xCBA5, 0xCCCB,
	0xCDF9, 0xCF23, 0xD051, 0xD186, 0xD2B2, 0xD3EC, 0xD521, 0xD659, 0xD794, 0xD8D2, 0xDA0B,
	0xDB50, 0xDC8F, 0xDDCF, 0xDF1A, 0xE056, 0xE1A8, 0xE2E6, 0xE439, 0xE57A, 0xE6D1, 0xE813,
	0xE96B, 0xEAB4, 0xEC05, 0xED58, 0xEEA8, 0xEFFA, 0xF151, 0xF2A0, 0xF3F9, 0xF54A, 0xF6A2,
	0xF7F6, 0xF94F, 0xFAA4, 0xFBF9, 0xFD55, 0xFEA6, 0x0001, 0x0157, 0x02AE, 0x0406, 0x055C,
	0x06B1, 0x0809, 0x095F, 0x0AB4, 0x0C0A, 0x0D5D, 0x0EB1, 0x1005, 0x1158, 0x12A9, 0x13FB,
	0x1548, 0x169C, 0x17E5, 0x1939, 0x1A7C, 0x1BD0, 0x1D12, 0x1E5E, 0x1FA7, 0x20E7, 0x2232,
	0x236E, 0x24B5, 0x25F1, 0x272E, 0x286F, 0x29A4, 0x2AE0, 0x2C16, 0x2D49, 0x2E7F, 0x2FAC,
	0x30DF, 0x3205, 0x3337, 0x345A, 0x3581, 0x36A4, 0x37C6, 0x38E3, 0x3A03, 0x3B16, 0x3C32,
	0x3D44, 0x3E57, 0x3F64, 0x4073, 0x4178, 0x4284, 0x4382, 0x4486, 0x4581, 0x467E, 0x4774,
	0x4869, 0x4958, 0x4A49, 0x4B30, 0x4C1A, 0x4CFD, 0x4DDD, 0x4EBD, 0x4F91, 0x506C, 0x513D,
	0x520E, 0x52D6, 0x53A1, 0x5463, 0x5524, 0x55E4, 0x5697, 0x5753, 0x57FD, 0x58B2, 0x5954,
	0x5A02, 0x5A9C, 0x5B40, 0x5BD4, 0x5C71, 0x5CFA, 0x5D8F, 0x5E14, 0x5E9B, 0x5F1F, 0x5F95,
	0x6016, 0x6083, 0x60FA, 0x6163, 0x61C9, 0x6233, 0x6289, 0x62EE, 0x633C, 0x6395, 0x63DE,
	0x642B, 0x646C, 0x64B5, 0x64E5, 0x6529, 0x6554, 0x6587, 0x65B2, 0x65D5, 0x65F8, 0x6619,
	0x6629, 0x6648, 0x664D, 0x6661, 0x6663, 0x6665, 0x6668, 0x6659, 0x6656, 0x6640, 0x662E,
	0x6619, 0x65F5, 0x65D9, 0x65B1, 0x6584, 0x6559, 0x6523, 0x64EA, 0x64B4, 0x6469, 0x642F,
	0x63DC, 0x6393, 0x6342, 0x62E5, 0x6293, 0x622C, 0x61CC, 0x6164, 0x60F6, 0x6087, 0x6013,
	0x5F98, 0x5F1D, 0x5E9B, 0x5E15, 0x5D8C, 0x5CFF, 0x5C6C, 0x5BD8, 0x5B3C, 0x5AA1, 0x59FC,
	0x5959, 0x58AE, 0x5801, 0x574F, 0x569B, 0x55DF, 0x5527, 0x5463, 0x539F, 0x52D9, 0x520C,
	0x513C, 0x506E, 0x4F8F, 0x4EBF, 0x4DDD, 0x4CFB, 0x4C1C, 0x4B2F, 0x4A49, 0x4959, 0x4869,
	0x4772, 0x4680, 0x4580, 0x4486, 0x4385, 0x4280, 0x417A, 0x4072, 0x3F65, 0x3E57, 0x3D44,
	0x3C31, 0x3B17, 0x3A04, 0x38E1, 0x37C7, 0x36A4, 0x3580, 0x345E, 0x3330, 0x320C, 0x30DA,
	0x2FAF, 0x2E7E, 0x2D49, 0x2C16, 0x2ADF, 0x29A5, 0x286E, 0x2730, 0x25F0, 0x24B4, 0x236F,
	0x2231, 0x20E9, 0x1FA6, 0x1E5D, 0x1D15, 0x1BCC, 0x1A81, 0x1936, 0x17E5, 0x169D, 0x1546,
	0x13FF, 0x12A5, 0x115A, 0x1003, 0x0EB2, 0x0D5F, 0x0C08, 0x0AB4, 0x0960, 0x0805, 0x06B9,
	0x0555, 0x040C, 0x02A8, 0x015D, 0xFFFA, 0xFEAF, 0xFD4D, 0xFBFD, 0xFAA5, 0xF94C, 0xF7F9,
	0xF69E, 0xF54E, 0xF3F7, 0xF2A2, 0xF150, 0xEFF7, 0xEEAC, 0xED55, 0xEC06, 0xEAB7, 0xE966,
	0xE817, 0xE6CD, 0xE57D, 0xE436, 0xE2EB, 0xE1A1, 0xE05D, 0xDF13, 0xDDD4, 0xDC8D, 0xDB4F,
	0xDA0D, 0xD8D0, 0xD795, 0xD657, 0xD525, 0xD3E6, 0xD2B9, 0xD181, 0xD052, 0xCF26, 0xCDF2,
	0xCCD1, 0xCBA3, 0xCA80, 0xC95A, 0xC83D, 0xC717, 0xC607, 0xC4E0, 0xC3D5, 0xC2B7, 0xC1AD,
	0xC099, 0xBF8E, 0xBE88, 0xBD7C, 0xBC80, 0xBB77, 0xBA80, 0xB982, 0xB88C, 0xB798, 0xB6A6,
	0xB5B9, 0xB4CE, 0xB3E7, 0xB304, 0xB220, 0xB148, 0xB069, 0xAF98, 0xAEC0, 0xADF7, 0xAD24,
	0xAC63, 0xAB9C, 0xAADA, 0xAA21, 0xA963, 0xA8B3, 0xA7FD, 0xA754, 0xA6A6, 0xA605, 0xA55D,
	0xA4C6, 0xA426, 0xA395, 0xA303, 0xA270, 0xA1EE, 0xA163, 0xA0E4, 0xA068, 0x9FED, 0x9F78,
	0x9F0B, 0x9E9C, 0x9E33, 0x9DD5, 0x9D6C, 0x9D1C, 0x9CBD, 0x9C70, 0x9C1E, 0x9BD7, 0x9B91,
	0x9B51, 0x9B16, 0x9AD8, 0x9AAD, 0x9A77, 0x9A52, 0x9A28, 0x9A07, 0x99EB, 0x99D2, 0x99BE,
	0x99AD, 0x99A2, 0x999D, 0x9999, 0x999C, 0x99A4, 0x99AB, 0x99C0, 0x99D0, 0x99EC, 0x9A06,
	0x9A2B, 0x9A4D, 0x9A7C, 0x9AA8, 0x9ADB, 0x9B17, 0x9B4D, 0x9B95, 0x9BD4, 0x9C20, 0x9C6F,
	0x9CBF, 0x9D18, 0x9D72, 0x9DD0, 0x9E34, 0x9E9F, 0x9F06, 0x9F7E, 0x9FE9, 0xA06A, 0xA0E0,
	0xA169, 0xA1E9, 0xA274, 0xA301, 0xA394, 0xA427, 0xA4C6, 0xA55E, 0xA603, 0xA6A9, 0xA750,
	0xA800, 0xA8B1, 0xA966, 0xAA1E, 0xAADC, 0xAB9B, 0xAC62, 0xAD28, 0xADF2, 0xAEC5, 0xAF91,
	0xB072, 0xB13F, 0xB228, 0xB2FF, 0xB3E9, 0xB4CD, 0xB5BA, 0xB6A5, 0xB79A, 0xB88A, 0xB985,
	0xBA7B, 0xBB7E, 0xBC79, 0xBD82, 0xBE83, 0xBF90, 0xC09B, 0xC1A9, 0xC2BC, 0xC3CE, 0xC4E8,
	0xC600, 0xC71B, 0xC83C, 0xC95A, 0xCA80, 0xCBA4, 0xCCCE, 0xCDF6, 0xCF25, 0xD051, 0xD183,
	0xD2B7, 0xD3E7, 0xD525, 0xD657, 0xD796, 0xD8CF, 0xDA0E, 0xDB4D, 0xDC91, 0xDDCF, 0xDF18,
	0xE059, 0xE1A4, 0xE2EA, 0xE435, 0xE57F, 0xE6CA, 0xE81A, 0xE965, 0xEAB7, 0xEC06, 0xED54,
	0xEEAD, 0xEFF7, 0xF151, 0xF2A2, 0xF3F7, 0xF54B, 0xF6A3, 0xF7F5, 0xF94F, 0xFAA3, 0xFBFD,
	0xFD4F, 0xFEAB, 0xFFFF, 0x0157, 0x02AE, 0x0407, 0x0558, 0x06B8, 0x0803, 0x0964, 0x0AB0,
	0x0C0C, 0x0D5C, 0x0EB1, 0x1007, 0x1155, 0x12AC, 0x13F7, 0x154C, 0x1698, 0x17E9, 0x1936,
	0x1A7D, 0x1BCE, 0x1D14, 0x1E5F, 0x1FA5, 0x20EA, 0x222C, 0x2376, 0x24AD, 0x25F8, 0x272B,
	0x286F, 0x29A4, 0x2AE1, 0x2C14, 0x2D4C, 0x2E7B, 0x2FAF, 0x30DC, 0x3209, 0x3333, 0x345C,
	0x3580, 0x36A6, 0x37C3, 0x38E6, 0x39FF, 0x3B19, 0x3C33, 0x3D41, 0x3E5A, 0x3F63, 0x4071,
	0x417C, 0x427F, 0x4386, 0x4484, 0x4583, 0x467D, 0x4773, 0x4869, 0x495A, 0x4A46, 0x4B33,
	0x4C18, 0x4CFE, 0x4DDC, 0x4EBE, 0x4F90, 0x506E, 0x513B, 0x520F, 0x52D5, 0x53A3, 0x5460,
	0x5529, 0x55DD, 0x569F, 0x574B, 0x5804, 0x58AC, 0x595A, 0x59FC, 0x5AA1, 0x5B3C, 0x5BD7,
	0x5C6E, 0x5CFD, 0x5D8D, 0x5E15, 0x5E9C, 0x5F1A, 0x5F9D, 0x600E, 0x608B, 0x60F5, 0x6162,
	0x61CF, 0x622A, 0x6293, 0x62E6, 0x6340, 0x6393, 0x63E0, 0x6428, 0x6471, 0x64AD, 0x64ED,
	0x6525, 0x6554, 0x658A, 0x65AD, 0x65D9, 0x65F7, 0x6617, 0x662E, 0x6642, 0x6652, 0x665D,
	0x6665, 0x6666, 0x6664, 0x665D, 0x6653, 0x6641, 0x6630, 0x6614, 0x65F9, 0x65D7, 0x65B0,
	0x6588, 0x6555, 0x6526, 0x64E9, 0x64B2, 0x646E, 0x6429, 0x63E1, 0x6391, 0x6340, 0x62E9,
	0x628F, 0x622D, 0x61CD, 0x6161, 0x60FA, 0x6084, 0x6016, 0x5F93, 0x5F22, 0x5E97, 0x5E17,
	0x5D8E, 0x5CFA, 0x5C70, 0x5BD7, 0x5B3B, 0x5AA2, 0x59FB, 0x5959, 0x58AE, 0x5803, 0x574D,
	0x569C, 0x55DF, 0x5527, 0x5460, 0x53A6, 0x52D0, 0x5215, 0x5137, 0x506D, 0x4F93, 0x4EBC,
	0x4DDD, 0x4CFE, 0x4C17, 0x4B34, 0x4A45, 0x495D, 0x4864, 0x4777, 0x467C, 0x4583, 0x4484,
	0x4386, 0x427E, 0x417D, 0x4071, 0x3F64, 0x3E58, 0x3D42, 0x3C34, 0x3B16, 0x3A03, 0x38E2,
	0x37C5, 0x36A7, 0x357F, 0x345B, 0x3334, 0x3207, 0x30DF, 0x2FAD, 0x2E7D, 0x2D4A, 0x2C14,
	0x2AE2, 0x29A4, 0x286F, 0x272B, 0x25F6, 0x24B0, 0x2373, 0x222E, 0x20E9, 0x1FA5, 0x1E5F,
	0x1D13, 0x1BD0, 0x1A7A, 0x193B, 0x17E3, 0x169D, 0x1548, 0x13FB, 0x12A8, 0x115A, 0x1002,
	0x0EB5, 0x0D5A, 0x0C0B, 0x0AB5, 0x095C, 0x080D, 0x06AE, 0x055F, 0x0403, 0x02B1, 0x0155,
	0x0000, 0xFEAA, 0xFD50, 0xFBFE, 0xFAA2, 0xF94D, 0xF7F8, 0xF6A1, 0xF54D, 0xF3F5, 0xF2A3,
	0xF14E, 0xEFFC, 0xEEA9, 0xED54, 0xEC09, 0xEAB2, 0xE96B, 0xE815, 0xE6CE, 0xE57C, 0xE437,
	0xE2E9, 0xE1A3, 0xE05D, 0xDF12, 0xDDD5, 0xDC8C, 0xDB50, 0xDA0B, 0xD8D4, 0xD790, 0xD65D,
	0xD51F, 0xD3EA, 0xD2B8, 0xD180, 0xD055, 0xCF21, 0xCDF8, 0xCCCE, 0xCBA3, 0xCA82, 0xC957,
	0xC840, 0xC717, 0xC605, 0xC4E2, 0xC3D3, 0xC2B9, 0xC1AC, 0xC098, 0xBF91, 0xBE84, 0xBD81,
	0xBC78, 0xBB81, 0xBA77, 0xB988, 0xB889, 0xB798, 0xB6A8, 0xB5B9, 0xB4CC, 0xB3E9, 0xB300,
	0xB224, 0xB146, 0xB06B, 0xAF96, 0xAEC1, 0xADF5, 0xAD27, 0xAC61, 0xAB9C, 0xAADA, 0xAA22,
	0xA961, 0xA8B7, 0xA7F8, 0xA759, 0xA6A2, 0xA607, 0xA55D, 0xA4C5, 0xA429, 0xA392, 0xA303,
	0xA273, 0xA1EA, 0xA167, 0xA0E0, 0xA06B, 0x9FEB, 0x9F7C, 0x9F06, 0x9E9E, 0x9E35, 0x9DD1,
	0x9D73, 0x9D14, 0x9CC4, 0x9C6A, 0x9C23, 0x9BD4, 0x9B93, 0x9B51, 0x9B12, 0x9AE0, 0x9AA2,
	0x9A83, 0x9A47, 0x9A2F, 0x9A05, 0x99EA, 0x99D4, 0x99BB, 0x99B0, 0x99A1, 0x999C, 0x999B,
	0x999A, 0x99A4, 0x99AE, 0x99BD, 0x99D0, 0x99EE, 0x9A03, 0x9A2E, 0x9A4C, 0x9A7C, 0x9AA6,
	0x9ADF, 0x9B13, 0x9B50, 0x9B94, 0x9BD4, 0x9C20, 0x9C70, 0x9CBC, 0x9D1C, 0x9D6E, 0x9DD3,
	0x9E34, 0x9E9C, 0x9F0B, 0x9F78, 0x9FED, 0xA068, 0xA0E3, 0xA166, 0xA1EB, 0xA272, 0xA304,
	0xA390, 0xA42E, 0xA4BD, 0xA565, 0xA5FF, 0xA6AA, 0xA751, 0xA800, 0xA8AF, 0xA966, 0xAA20,
	0xAADA, 0xAB9D, 0xAC60, 0xAD27, 0xADF5, 0xAEC3, 0xAF93, 0xB070, 0xB13E, 0xB22A, 0xB2FD,
	0xB3EC, 0xB4C9, 0xB5BD, 0xB6A4, 0xB799, 0xB88B, 0xB983, 0xBA7E, 0xBB7D, 0xBC79, 0xBD82,
	0xBE82, 0xBF92, 0xC098, 0xC1AD, 0xC2B8, 0xC3D4, 0xC4E1, 0xC604, 0xC71A, 0xC83B, 0xC95D,
	0xCA7D, 0xCBA7, 0xCCCA, 0xCDFB, 0xCF20, 0xD054, 0xD183, 0xD2B4, 0xD3EE, 0xD51E, 0xD65B,
	0xD793, 0xD8D1, 0xDA0E, 0xDB4F, 0xDC8B, 0xDDD5, 0xDF14, 0xE05C, 0xE1A2, 0xE2EB, 0xE434,
	0xE580, 0xE6CA, 0xE819, 0xE967, 0xEAB5, 0xEC07, 0xED54, 0xEEAD, 0xEFF6, 0xF154, 0xF29D,
	0xF3FA, 0xF54C, 0xF69E, 0xF7FC, 0xF949, 0xFAA7, 0xFBFA, 0xFD51, 0xFEAA, 0x0000, 0x0156,
	0x02B0, 0x0404, 0x055C, 0x06B4, 0x0807, 0x0960, 0x0AB4, 0x0C08, 0x0D60, 0x0EAE, 0x100A,
	0x1151, 0x12B0, 0x13F4, 0x154D, 0x169A, 0x17E6, 0x1937, 0x1A7D, 0x1BCE, 0x1D15, 0x1E5F,
	0x1FA3, 0x20EB, 0x222E, 0x2370, 0x24B7, 0x25EC, 0x2735, 0x2869, 0x29A7, 0x2ADF, 0x2C15,
	0x2D4B, 0x2E7D, 0x2FAF, 0x30D9, 0x320C, 0x3331, 0x345E, 0x357E, 0x36A7, 0x37C3, 0x38E5,
	0x3A01, 0x3B17, 0x3C33, 0x3D44, 0x3E56, 0x3F65, 0x4072, 0x417A, 0x4282, 0x4383, 0x4487,
	0x457F, 0x4681, 0x4770, 0x486B, 0x495A, 0x4A44, 0x4B36, 0x4C14, 0x4D02, 0x4DDA, 0x4EBD,
	0x4F92, 0x506D, 0x513C, 0x520D, 0x52D8, 0x539E, 0x5466, 0x5525, 0x55E0, 0x569B, 0x574F,
	0x5800, 0x58B0, 0x5958, 0x59FC, 0x5AA2, 0x5B3B, 0x5BD6, 0x5C71, 0x5CF9, 0x5D91, 0x5E13,
	0x5E9A, 0x5F1E, 0x5F99, 0x6010, 0x608B, 0x60F3, 0x6167, 0x61C7, 0x6233, 0x628A, 0x62EF,
	0x633A, 0x6396, 0x63DD, 0x642B, 0x646E, 0x64B2, 0x64E7, 0x6528, 0x6554, 0x6587, 0x65B2,
	0x65D4, 0x65FC, 0x6613, 0x662F, 0x6642, 0x6651, 0x6661, 0x6661, 0x6669, 0x6661, 0x665F,
	0x6653, 0x6642, 0x662D, 0x6619, 0x65F3, 0x65DC, 0x65AC, 0x658A, 0x6556, 0x6523, 0x64EC,
	0x64B0, 0x646C, 0x642E, 0x63DC, 0x6396, 0x633D, 0x62EC, 0x6289, 0x6235, 0x61C6, 0x6168,
	0x60F3, 0x608B, 0x600E, 0x5F9C, 0x5F1A, 0x5E9D, 0x5E14, 0x5D8F, 0x5CF9, 0x5C73, 0x5BD1,
	0x5B43, 0x5A9B, 0x5A00, 0x5957, 0x58AE, 0x5804, 0x5749, 0x56A2, 0x55DB, 0x5528, 0x5463,
	0x539F, 0x52D9, 0x520C, 0x513E, 0x5069, 0x4F96, 0x4EB9, 0x4DDF, 0x4CFD, 0x4C17, 0x4B36,
	0x4A42, 0x495E, 0x4866, 0x4774, 0x467F, 0x4580, 0x4487, 0x4383, 0x4282, 0x417A, 0x4070,
	0x3F68, 0x3E53, 0x3D49, 0x3C2C, 0x3B1D, 0x39FD, 0x38E5, 0x37C6, 0x36A3, 0x3583, 0x345A,
	0x3332, 0x320B, 0x30DA, 0x2FB0, 0x2E7B, 0x2D4E, 0x2C11, 0x2AE2, 0x29A6, 0x2869, 0x2735,
	0x25EC, 0x24B8, 0x236C, 0x2233, 0x20E6, 0x1FA8, 0x1E5B, 0x1D18, 0x1BC8, 0x1A86, 0x192F,
	0x17EC, 0x1698, 0x154A, 0x13FB, 0x12A8, 0x1159, 0x1003, 0x0EB3, 0x0D5D, 0x0C09, 0x0AB5,
	0x095E, 0x0809, 0x06B1, 0x0560, 0x03FF, 0x02B5, 0x0152, 0x0003, 0xFEA8, 0xFD51, 0xFBFD,
	0xFAA1, 0xF950, 0xF7F6, 0xF6A2, 0xF54D, 0xF3F5, 0xF2A2, 0xF151, 0xEFF9, 0xEEAA, 0xED56,
	0xEC06, 0xEAB6, 0xE967, 0xE816, 0xE6CE, 0xE57E, 0xE434, 0xE2EC, 0xE1A0, 0xE05D, 0xDF16,
	0xDDD0, 0xDC91, 0xDB4C, 0xDA0D, 0xD8D4, 0xD78F, 0xD65F, 0xD51C, 0xD3EE, 0xD2B4, 0xD184,
	0xD051, 0xCF24, 0xCDF7, 0xCCCD, 0xCBA5, 0xCA7E, 0xC95E, 0xC837, 0xC720, 0xC5FC, 0xC4EA,
	0xC3CD, 0xC2BD, 0xC1A9, 0xC09A, 0xBF91, 0xBE83, 0xBD81, 0xBC7A, 0xBB7C, 0xBA7E, 0xB983,
	0xB88C, 0xB796, 0xB6A8, 0xB5B8, 0xB4CF, 0xB3E6, 0xB304, 0xB221, 0xB147, 0xB06A, 0xAF96,
	0xAEC3, 0xADF2, 0xAD2B, 0xAC5E, 0xAB9D, 0xAADC, 0xAA1C, 0xA969, 0xA8AF, 0xA7FF, 0xA753,
	0xA6A6, 0xA605, 0xA55D, 0xA4C7, 0xA425, 0xA396, 0xA300, 0xA274, 0xA1EA, 0xA167, 0xA0E3,
	0xA065, 0x9FF0, 0x9F77, 0x9F0B, 0x9E9C, 0x9E35, 0x9DD1, 0x9D72, 0x9D15, 0x9CC3, 0x9C6D,
	0x9C20, 0x9BD6, 0x9B90, 0x9B52, 0x9B15, 0x9ADB, 0x9AAA, 0x9A77, 0x9A53, 0x9A26, 0x9A0A,
	0x99EA, 0x99D1, 0x99BF, 0x99AC, 0x99A3, 0x999D, 0x9998, 0x999D, 0x99A1, 0x99AF, 0x99BF,
	0x99CD, 0x99F0, 0x9A02, 0x9A2E, 0x9A4D, 0x9A7B, 0x9AA8, 0x9ADC, 0x9B15, 0x9B51, 0x9B90,
	0x9BDA, 0x9C1B, 0x9C72, 0x9CBE, 0x9D17, 0x9D74, 0x9DCF, 0x9E37, 0x9E9A, 0x9F0B, 0x9F77,
	0x9FF1, 0xA064, 0xA0E6, 0xA162, 0xA1EF, 0xA270, 0xA304, 0xA392, 0xA428, 0xA4C6, 0xA55D,
	0xA606, 0xA6A5, 0xA752, 0xA801, 0xA8AF, 0xA965, 0xAA23, 0xAAD6, 0xABA0, 0xAC5E, 0xAD28,
	0xADF5, 0xAEC3, 0xAF92, 0xB070, 0xB142, 0xB224, 0xB303, 0xB3E6, 0xB4CF, 0xB5B8, 0xB6A9,
	0xB793, 0xB891, 0xB980, 0xBA7F, 0xBB7B, 0xBC7A, 0xBD81, 0xBE85, 0xBF8F, 0xC09B, 0xC1A8,
	0xC2BE, 0xC3CC, 0xC4EB, 0xC5FB, 0xC721, 0xC835, 0xC962, 0xCA78, 0xCBAB, 0xCCC9, 0xCDF9,
	0xCF23, 0xD052, 0xD182, 0xD2B8, 0xD3E9, 0xD521, 0xD65A, 0xD793, 0xD8D2, 0xDA0B, 0xDB51,
	0xDC8C, 0xDDD4, 0xDF13, 0xE05F, 0xE19D, 0xE2F0, 0xE433, 0xE57D, 0xE6D0, 0xE812, 0xE96C,
	0xEAB4, 0xEC06, 0xED57, 0xEEA8, 0xEFFC, 0xF14E, 0xF2A4, 0xF3F4, 0xF550, 0xF69D, 0xF7FA,
	0xF94D, 0xFAA4, 0xFBFA, 0xFD53, 0xFEA7, 0x0003, 0x0154, 0x02B0, 0x0405, 0x055A, 0x06B7,
	0x0803, 0x0964, 0x0AB0, 0x0C0C, 0x0D5D, 0x0EB0, 0x1008, 0x1152, 0x12B0, 0x13F5, 0x154C,
	0x169B, 0x17E4, 0x1939, 0x1A7E, 0x1BCC, 0x1D17, 0x1E5C, 0x1FA5, 0x20EB, 0x222C, 0x2377,
	0x24AC, 0x25F7, 0x272D, 0x286B, 0x29AA, 0x2ADC, 0x2C18, 0x2D48, 0x2E7F, 0x2FAC, 0x30DE,
	0x3209, 0x3331, 0x345E, 0x3580, 0x36A5, 0x37C5, 0x38E3, 0x3A01, 0x3B19, 0x3C33, 0x3D42,
	0x3E57, 0x3F66, 0x406F, 0x417E, 0x427D, 0x4387, 0x4484, 0x4582, 0x467F, 0x4771, 0x486A,
	0x495A, 0x4A46, 0x4B33, 0x4C19, 0x4CFD, 0x4DDD, 0x4EBC, 0x4F93, 0x506B, 0x513E, 0x520B,
	0x52D9, 0x539F, 0x5465, 0x5522, 0x55E4, 0x5698, 0x5751, 0x57FF, 0x58B1, 0x5954, 0x5A01,
	0x5A9E, 0x5B3D, 0x5BD9, 0x5C6A, 0x5D01, 0x5D8A, 0x5E17, 0x5E9B, 0x5F1A, 0x5F9E, 0x600D,
	0x608B, 0x60F4, 0x6164, 0x61CD, 0x622D, 0x628F, 0x62E9, 0x633F, 0x6394, 0x63DD, 0x642E,
	0x6468, 0x64B8, 0x64E3, 0x652B, 0x6553, 0x6588, 0x65AF, 0x65D8, 0x65F8, 0x6616, 0x662F,
	0x6641, 0x6653, 0x665E, 0x6662, 0x6669, 0x6662, 0x665F, 0x6652, 0x6641, 0x6630, 0x6613,
	0x65FC, 0x65D3, 0x65B5, 0x6581, 0x655C, 0x651F, 0x64F0, 0x64AD, 0x6470, 0x6429, 0x63E0,
	0x6392, 0x6340, 0x62E9, 0x628E, 0x6230, 0x61CB, 0x6162, 0x60F9, 0x6085, 0x6014, 0x5F98,
	0x5F1D, 0x5E9B, 0x5E14, 0x5D8E, 0x5CFD, 0x5C6D, 0x5BD8, 0x5B3C, 0x5A9F, 0x59FE, 0x5959,
	0x58AD, 0x5801, 0x5750, 0x5699, 0x55E3, 0x5523, 0x5464, 0x53A0, 0x52D8, 0x520E, 0x513A,
	0x506D, 0x4F93, 0x4EBB, 0x4DE0, 0x4CF9, 0x4C1C, 0x4B30, 0x4A49, 0x4958, 0x4869, 0x4774,
	0x467E, 0x4580, 0x4488, 0x4380, 0x4285, 0x4178, 0x4073, 0x3F63, 0x3E59, 0x3D42, 0x3C31,
	0x3B1B, 0x39FE, 0x38E6, 0x37C3, 0x36A7, 0x357E, 0x3460, 0x332E, 0x320C, 0x30DB, 0x2FAF,
	0x2E7E, 0x2D48, 0x2C16, 0x2AE0, 0x29A5, 0x286F, 0x272C, 0x25F4, 0x24B2, 0x2371, 0x2230,
	0x20E8, 0x1FA6, 0x1E5D, 0x1D16, 0x1BCD, 0x1A7D, 0x1939, 0x17E4, 0x169C, 0x154A, 0x13F9,
	0x12AB, 0x1155, 0x1006, 0x0EB1, 0x0D5F, 0x0C09, 0x0AB2, 0x0961, 0x0805, 0x06B8, 0x0558,
	0x0407, 0x02AE, 0x0155, 0x0004, 0xFEA5, 0xFD54, 0xFBFB, 0xFAA2, 0xF950, 0xF7F5, 0xF6A2,
	0xF54D, 0xF3F5, 0xF2A5, 0xF14B, 0xEFFF, 0xEEA5, 0xED59, 0xEC05, 0xEAB6, 0xE965, 0xE81C,
	0xE6C6, 0xE584, 0xE431, 0xE2EC, 0xE1A3, 0xE05A, 0xDF17, 0xDDCF, 0xDC92, 0xDB4A, 0xDA12,
	0xD8CD, 0xD796, 0xD658, 0xD521, 0xD3EC, 0xD2B5, 0xD183, 0xD051, 0xCF25, 0xCDF6, 0xCCCF,
	0xCBA2, 0xCA81, 0xC95A, 0xC83C, 0xC71C, 0xC5FF, 0xC4E7, 0xC3D0, 0xC2BB, 0xC1A9, 0xC09D,
	0xBF8C, 0xBE88, 0xBD7E, 0xBC7B, 0xBB7D, 0xBA7C, 0xB984, 0xB88C, 0xB796, 0xB6A9, 0xB5B7,
	0xB4CF, 0xB3E6, 0xB303, 0xB224, 0xB142, 0xB071, 0xAF8F, 0xAEC8, 0xADF1, 0xAD28, 0xAC61,
	0xAB9D, 0xAAD8, 0xAA23, 0xA963, 0xA8B0, 0xA803, 0xA74D, 0xA6AA, 0xA604, 0xA55C, 0xA4CA,
	0xA421, 0xA39A, 0xA2FB, 0xA27A, 0xA1E6, 0xA169, 0xA0E1, 0xA067, 0x9FED, 0x9F7C, 0x9F05,
	0x9EA2, 0x9E2F, 0x9DD4, 0x9D71, 0x9D17, 0x9CC0, 0x9C6F, 0x9C1E, 0x9BD8, 0x9B90, 0x9B53,
	0x9B11, 0x9ADF, 0x9AA8, 0x9A78, 0x9A54, 0x9A24, 0x9A0C, 0x99E6, 0x99D6, 0x99BA, 0x99B1,
	0x99A0, 0x999C, 0x999B, 0x999B, 0x99A3, 0x99AD, 0x99BF, 0x99CF, 0x99EE, 0x9A05, 0x9A29,
	0x9A52, 0x9A76, 0x9AAD, 0x9ADA, 0x9B14, 0x9B51, 0x9B91, 0x9BD7, 0x9C21, 0x9C6C, 0x9CC2,
	0x9D14, 0x9D76, 0x9DCD, 0x9E38, 0x9E9A, 0x9F09, 0x9F7C, 0x9FEB, 0xA068, 0xA0E4, 0xA163,
	0xA1ED, 0xA273, 0xA302, 0xA392, 0xA42B, 0xA4C0, 0xA565, 0xA5FE, 0xA6AB, 0xA74F, 0xA801,
	0xA8B0, 0xA967, 0xAA1C, 0xAADF, 0xAB98, 0xAC64, 0xAD27, 0xADF3, 0xAEC3, 0xAF95, 0xB06B,
	0xB147, 0xB222, 0xB302, 0xB3E9, 0xB4CA, 0xB5BE, 0xB6A1, 0xB79D, 0xB887, 0xB987, 0xBA7C,
	0xBB7A, 0xBC7F, 0xBD7B, 0xBE89, 0xBF8D, 0xC09A, 0xC1AC, 0xC2BA, 0xC3D0, 0xC4E5, 0xC602,
	0xC71A, 0xC83D, 0xC959, 0xCA80, 0xCBA5, 0xCCCC, 0xCDFA, 0xCF1F, 0xD055, 0xD182, 0xD2B6,
	0xD3EC, 0xD51F, 0xD65A, 0xD794, 0xD8D1, 0xDA0D, 0xDB50, 0xDC8C, 0xDDD3, 0xDF15, 0xE05B,
	0xE1A4, 0xE2E9, 0xE435, 0xE57F, 0xE6CC, 0xE817, 0xE968, 0xEAB4, 0xEC08, 0xED55, 0xEEA9,
	0xEFFC, 0xF14E, 0xF2A3, 0xF3F6, 0xF54B, 0xF6A4, 0xF7F4, 0xF952, 0xFA9E, 0xFC00, 0xFD4F,
	0xFEAA, 0x0000, 0x0156, 0x02B0, 0x0403, 0x055F, 0x06AF, 0x080B, 0x095E, 0x0AB3, 0x0C0B,
	0x0D5D, 0x0EB1, 0x1007, 0x1153, 0x12AE, 0x13F6, 0x154E, 0x1698, 0x17E8, 0x1934, 0x1A81,
	0x1BCC, 0x1D15, 0x1E60, 0x1FA0, 0x20EF, 0x222B, 0x2373, 0x24B3, 0x25F1, 0x2730, 0x286D,
	0x29A3, 0x2AE4, 0x2C11, 0x2D4E, 0x2E7B, 0x2FAE, 0x30DD, 0x320A, 0x3331, 0x345D, 0x357F,
	0x36A6, 0x37C5, 0x38E5, 0x39FE, 0x3B1B, 0x3C2F, 0x3D45, 0x3E57, 0x3F65, 0x4071, 0x417B,
	0x4280, 0x4385, 0x4485, 0x4582, 0x467D, 0x4775, 0x4867, 0x495A, 0x4A48, 0x4B31, 0x4C19,
	0x4CFD, 0x4DDD, 0x4EBC, 0x4F95, 0x5067, 0x5142, 0x5206, 0x52E0, 0x5399, 0x5468, 0x5523,
	0x55E0, 0x569E, 0x574C, 0x5802, 0x58B0, 0x5955, 0x5A02, 0x5A9C, 0x5B3D, 0x5BD9, 0x5C6B,
	0x5D01, 0x5D89, 0x5E18, 0x5E99, 0x5F1D, 0x5F9A, 0x6010, 0x6089, 0x60F6, 0x6165, 0x61C8,
	0x6233, 0x6289, 0x62EE, 0x633D, 0x6393, 0x63E1, 0x6426, 0x6473, 0x64AB, 0x64F0, 0x6520,
	0x655B, 0x6582, 0x65B3, 0x65D5, 0x65FA, 0x6615, 0x662E, 0x6643, 0x6651, 0x665F, 0x6662,
	0x6669, 0x6661, 0x6662, 0x664D, 0x6646, 0x662D, 0x6614, 0x65FC, 0x65D3, 0x65B3, 0x6586,
	0x6556, 0x6524, 0x64ED, 0x64AD, 0x6471, 0x6428, 0x63E0, 0x6394, 0x633D, 0x62EB, 0x628D,
	0x622F, 0x61CC, 0x6161, 0x60FA, 0x6085, 0x6013, 0x5F99, 0x5F1B, 0x5E9D, 0x5E14, 0x5D8D,
	0x5CFE, 0x5C6D, 0x5BD6, 0x5B3F, 0x5A9D, 0x5A00, 0x5956, 0x58B0, 0x57FF, 0x5752, 0x5697,
	0x55E3, 0x5526, 0x5461, 0x53A2, 0x52D7, 0x520C, 0x513E, 0x506B, 0x4F94, 0x4EBA, 0x4DE0,
	0x4CF9, 0x4C1E, 0x4B2E, 0x4A4A, 0x4957, 0x486A, 0x4773, 0x467F, 0x457F, 0x4487, 0x4383,
	0x4281, 0x417D, 0x406E, 0x3F66, 0x3E57, 0x3D43, 0x3C33, 0x3B18, 0x3A01, 0x38E2, 0x37C9,
	0x369E, 0x358A, 0x3452, 0x333C, 0x3200, 0x30E5, 0x2FA7, 0x2E82, 0x2D47, 0x2C16, 0x2AE1,
	0x29A4, 0x286E, 0x272E, 0x25F3, 0x24B2, 0x2372, 0x222D, 0x20EC, 0x1FA3, 0x1E5F, 0x1D15,
	0x1BCB, 0x1A83, 0x1931, 0x17EB, 0x1697, 0x154D, 0x13F8, 0x12AB, 0x1155, 0x1007, 0x0EB0,
	0x0D60, 0x0C06, 0x0AB7, 0x095C, 0x080B, 0x06B2, 0x055C, 0x0404, 0x02AF, 0x0156, 0x0002,
	0xFEA7, 0xFD53, 0xFBFB, 0xFAA3, 0xF94E, 0xF7F7, 0xF6A1, 0xF54E, 0xF3F5, 0xF2A2, 0xF150,
	0xEFF9, 0xEEAB, 0xED55, 0xEC07, 0xEAB4, 0xE969, 0xE816, 0xE6CD, 0xE57F, 0xE433, 0xE2EC,
	0xE1A2, 0xE05A, 0xDF19, 0xDDCD, 0xDC92, 0xDB4C, 0xDA0E, 0xD8D2, 0xD791, 0xD65C, 0xD520,
	0xD3EB, 0xD2B6, 0xD182, 0xD053, 0xCF23, 0xCDF8, 0xCCCD, 0xCBA2, 0xCA84, 0xC955, 0xC842,
	0xC717, 0xC602, 0xC4E6, 0xC3CF, 0xC2BC, 0xC1AA, 0xC09B, 0xBF8D, 0xBE88, 0xBD7C, 0xBC7F,
	0xBB78, 0xBA80, 0xB982, 0xB88C, 0xB799, 0xB6A5, 0xB5BA, 0xB4CD, 0xB3E8, 0xB303, 0xB222,
	0xB146, 0xB06B, 0xAF95, 0xAEC5, 0xADF0, 0xAD2C, 0xAC5D, 0xAB9E, 0xAADB, 0xAA1D, 0xA969,
	0xA8AE, 0xA800, 0xA753, 0xA6A5, 0xA605, 0xA561, 0xA4BF, 0xA42F, 0xA38D, 0xA306, 0xA273,
	0xA1E9, 0xA167, 0xA0E3, 0xA065, 0x9FF1, 0x9F76, 0x9F0C, 0x9E9B, 0x9E34, 0x9DD2, 0x9D71,
	0x9D1A, 0x9CBC, 0x9C73, 0x9C19, 0x9BDD, 0x9B8E, 0x9B51, 0x9B15, 0x9ADA, 0x9AAB, 0x9A79,
	0x9A4F, 0x9A2A, 0x9A05, 0x99ED, 0x99D1, 0x99BC, 0x99B1, 0x999F, 0x999F, 0x9997, 0x999E,
	0x99A1, 0x99AF, 0x99BD, 0x99D2, 0x99E9, 0x9A0B, 0x9A25, 0x9A52, 0x9A7A, 0x9AA7, 0x9ADD,
	0x9B17, 0x9B4B, 0x9B98, 0x9BD1, 0x9C23, 0x9C6D, 0x9CC0, 0x9D17, 0x9D72, 0x9DD1, 0x9E35,
	0x9E9D, 0x9F06, 0x9F7E, 0x9FE9, 0xA06B, 0xA0E0, 0xA168, 0xA1E9, 0xA275, 0xA2FF, 0xA397,
	0xA424, 0xA4CA, 0xA558, 0xA60A, 0xA6A3, 0xA754, 0xA7FF, 0xA8B0, 0xA965, 0xAA21, 0xAAD8,
	0xABA1, 0xAC5B, 0xAD2B, 0xADF3, 0xAEC2, 0xAF96, 0xB06D, 0xB142, 0xB226, 0xB300, 0xB3E9,
	0xB4CD, 0xB5BA, 0xB6A6, 0xB798, 0xB88C, 0xB982, 0xBA7F, 0xBB7B, 0xBC7B, 0xBD80, 0xBE86,
	0xBF8B, 0xC0A1, 0xC1A3, 0xC2C1, 0xC3CC, 0xC4E8, 0xC5FF, 0xC71E, 0xC838, 0xC95E, 0xCA7D,
	0xCBA7, 0xCCCB, 0xCDF9, 0xCF21, 0xD055, 0xD180, 0xD2B9, 0xD3E7, 0xD524, 0xD659, 0xD793,
	0xD8D0, 0xDA10, 0xDB4A, 0xDC94, 0xDDCB, 0xDF1B, 0xE058, 0xE1A5, 0xE2E8, 0xE437, 0xE57D,
	0xE6CD, 0xE818, 0xE965, 0xEAB8, 0xEC05, 0xED56, 0xEEAA, 0xEFF9, 0xF151, 0xF2A1, 0xF3F7,
	0xF54C, 0xF6A1, 0xF7F7, 0xF94F, 0xFAA2, 0xFBFD, 0xFD51, 0xFEA8, 0x0000, 0x0158, 0x02AE,
	0x0406, 0x055A, 0x06B4, 0x0809, 0x095E, 0x0AB5, 0x0C07, 0x0D61, 0x0EAE, 0x1009, 0x1153,
	0x12AC, 0x13F9, 0x154B, 0x1697, 0x17EB, 0x1933, 0x1A81, 0x1BCC, 0x1D15, 0x1E5D, 0x1FA6,
	0x20EA, 0x222E, 0x2373, 0x24B0, 0x25F3, 0x2730, 0x286C, 0x29A6, 0x2AE0, 0x2C12, 0x2D51,
	0x2E76, 0x2FB5, 0x30D5, 0x3210, 0x332D, 0x3461, 0x357D, 0x36A6, 0x37C5, 0x38E4, 0x3A00,
	0x3B19, 0x3C31, 0x3D44, 0x3E57, 0x3F65, 0x4070, 0x417D, 0x427F, 0x4384, 0x4488, 0x457E,
	0x4681, 0x4771, 0x4869, 0x495C, 0x4A44, 0x4B34, 0x4C18, 0x4CFC, 0x4DDF, 0x4EBC, 0x4F91,
	0x506E, 0x513A, 0x520E, 0x52D9, 0x539E, 0x5465, 0x5523, 0x55E3, 0x569A, 0x574E, 0x5802,
	0x58AE, 0x5959, 0x59FD, 0x5A9E, 0x5B3F, 0x5BD6, 0x5C6E, 0x5CFE, 0x5D8B, 0x5E16, 0x5E9D,
	0x5F18, 0x5F9E, 0x600E, 0x608A, 0x60F7, 0x6160, 0x61D0, 0x6229, 0x6295, 0x62E3, 0x6346,
	0x638C, 0x63E5, 0x6425, 0x6472, 0x64AE, 0x64ED, 0x6522, 0x6558, 0x6585, 0x65B1, 0x65DA,
	0x65F2, 0x661C, 0x662A, 0x6644, 0x6653, 0x665B, 0x6665, 0x6668, 0x6662, 0x665F, 0x664F,
	0x6647, 0x6629, 0x661A, 0x65F5, 0x65D8, 0x65B1, 0x6586, 0x6557, 0x6523, 0x64EC, 0x64B0,
	0x646F, 0x6428, 0x63E2, 0x638F, 0x6344, 0x62E6, 0x628F, 0x622E, 0x61CD, 0x6163, 0x60F7,
	0x6086, 0x6012, 0x5F9A, 0x5F1C, 0x5E9C, 0x5E14, 0x5D8C, 0x5D00, 0x5C6A, 0x5BDB, 0x5B3A,
	0x5AA0, 0x59FE, 0x5958, 0x58AF, 0x5800, 0x5751, 0x5698, 0x55E3, 0x5523, 0x5464, 0x53A2,
	0x52D6, 0x520E, 0x513C, 0x506B, 0x4F94, 0x4EBB, 0x4DDE, 0x4CFD, 0x4C1A, 0x4B2F, 0x4A4A,
	0x4957, 0x486B, 0x4773, 0x467D, 0x4581, 0x4487, 0x4381, 0x4285, 0x4179, 0x4070, 0x3F67,
	0x3E55, 0x3D44, 0x3C33, 0x3B17, 0x3A02, 0x38E4, 0x37C5, 0x36A3, 0x3583, 0x345A, 0x3334,
	0x3209, 0x30DC, 0x2FAD, 0x2E80, 0x2D46, 0x2C1A, 0x2ADB, 0x29A8, 0x286E, 0x272B, 0x25F7,
	0x24AE, 0x2374, 0x222E, 0x20E9, 0x1FA7, 0x1E5B, 0x1D18, 0x1BC9, 0x1A83, 0x1934, 0x17E7,
	0x169A, 0x154A, 0x13FB, 0x12A9, 0x1157, 0x1003, 0x0EB5, 0x0D5A, 0x0C0E, 0x0AAF, 0x0963,
	0x0805, 0x06B6, 0x0559, 0x0408, 0x02AC, 0x0159, 0xFFFE, 0xFEAB, 0xFD50, 0xFBFD, 0xFAA1,
	0xF951, 0xF7F4, 0xF6A4, 0xF54A, 0xF3F7, 0xF2A4, 0xF14D, 0xEFFB, 0xEEA9, 0xED55, 0xEC0B,
	0xEAB0, 0xE96A, 0xE816, 0xE6CC, 0xE582, 0xE430, 0xE2EE, 0xE1A0, 0xE05D, 0xDF15, 0xDDD2,
	0xDC8E, 0xDB4E, 0xDA0E, 0xD8D0, 0xD793, 0xD65C, 0xD51F, 0xD3EC, 0xD2B4, 0xD183, 0xD055,
	0xCF20, 0xCDFB, 0xCCC9, 0xCBA7, 0xCA7F, 0xC95B, 0xC83B, 0xC71C, 0xC600, 0xC4E7, 0xC3CF,
	0xC2BB, 0xC1AA, 0xC09B, 0xBF8F, 0xBE85, 0xBD81, 0xBC78, 0xBB7F, 0xBA7B, 0xB986, 0xB889,
	0xB79A, 0xB6A4, 0xB5BB, 0xB4CE, 0xB3E6, 0xB304, 0xB221, 0xB146, 0xB06C, 0xAF94, 0xAEC4,
	0xADF3, 0xAD2A, 0xAC5E, 0xAB9C, 0xAADE, 0xAA1B, 0xA96B, 0xA8AB, 0xA802, 0xA752, 0xA6A6,
	0xA606, 0xA55C, 0xA4C6, 0xA427, 0xA395, 0xA301, 0xA273, 0xA1EC, 0xA164, 0xA0E4, 0xA068,
	0x9FEB, 0x9F7C, 0x9F08, 0x9E9C, 0x9E36, 0x9DD0, 0x9D72, 0x9D18, 0x9CBE, 0x9C6F, 0x9C21,
	0x9BD5, 0x9B93, 0x9B4D, 0x9B18, 0x9ADA, 0x9AAB, 0x9A79, 0x9A4E, 0x9A2B, 0x9A07, 0x99EA,
	0x99D3, 0x99BC, 0x99AD, 0x99A6, 0x9999, 0x999C, 0x9999, 0x99A4, 0x99AC, 0x99C1, 0x99CF,
	0x99EC, 0x9A05, 0x9A2C, 0x9A4D, 0x9A7D, 0x9AA4, 0x9AE2, 0x9B0F, 0x9B55, 0x9B8E, 0x9BD8,
	0x9C20, 0x9C6E, 0x9CC0, 0x9D15, 0x9D74, 0x9DD0, 0x9E36, 0x9E9C, 0x9F09, 0x9F78, 0x9FF1,
	0xA063, 0xA0E7, 0xA163, 0xA1EB, 0xA275, 0xA301, 0xA392, 0xA42A, 0xA4C2, 0xA562, 0xA600,
	0xA6AC, 0xA74C, 0xA803, 0xA8B0, 0xA964, 0xAA22, 0xAAD8, 0xAB9D, 0xAC62, 0xAD27, 0xADF3,
	0xAEC3, 0xAF95, 0xB06E, 0xB142, 0xB225, 0xB301, 0xB3E8, 0xB4CE, 0xB5B8, 0xB6A8, 0xB797,
	0xB88C, 0xB982, 0xBA80, 0xBB78, 0xBC7F, 0xBD7C, 0xBE89, 0xBF8B, 0xC09F, 0xC1A4, 0xC2C0,
	0xC3CD, 0xC4E8, 0xC600, 0xC71B, 0xC83B, 0xC95A, 0xCA81, 0xCBA4, 0xCCCD, 0xCDF7, 0xCF24,
	0xD051, 0xD184, 0xD2B5, 0xD3EA, 0xD524, 0xD656, 0xD796, 0xD8CF, 0xDA0F, 0xDB4E, 0xDC8E,
	0xDDD1, 0xDF18, 0xE057, 0xE1A7, 0xE2E7, 0xE437, 0xE57E, 0xE6CB, 0xE818, 0xE968, 0xEAB4,
	0xEC07, 0xED56, 0xEEA9, 0xEFFB, 0xF14E, 0xF2A3, 0xF3F7, 0xF54A, 0xF6A5, 0xF7F2, 0xF953,
	0xFA9F, 0xFBFF, 0xFD50, 0xFEA8};

#define ENC_BUF_SIZE	  120
#define DEC_BUF_SIZE	  960
#define PCM_SAMPLE_RATE	  48000
#define PCM_BIT_DEPTH	  16
#define LC3_BITRATE	  96000
#define LC3_FRAME_SIZE_US 10000
#define LC3_NUM_CHANNELS  2
#define AUDIO_CH_L	  0
#define AUDIO_CH_R	  1

static uint8_t audio_encoded_l[ENC_BUF_SIZE];
static uint8_t audio_encoded_r[ENC_BUF_SIZE];
static uint16_t audio_decoded_l[DEC_BUF_SIZE];
static uint16_t audio_decoded_r[DEC_BUF_SIZE];

static uint16_t pcm_bytes_req_enc;
static uint16_t encoded_bytes_written_l;
static uint16_t encoded_bytes_written_r;
static uint16_t decoded_bytes_written_l;
static uint16_t decoded_bytes_written_r;

static void *test_sw_codec_lc3_init(void)
{
	int ret;

	sw_codec_lc3_init(NULL, NULL, LC3_FRAME_SIZE_US);

	ret = sw_codec_lc3_enc_init(PCM_SAMPLE_RATE, PCM_BIT_DEPTH, LC3_FRAME_SIZE_US, LC3_BITRATE,
				    LC3_NUM_CHANNELS, &pcm_bytes_req_enc);
	zassert_equal(ret, 0, "lc3_enc_init did not return zero");

	ret = sw_codec_lc3_dec_init(PCM_SAMPLE_RATE, PCM_BIT_DEPTH, LC3_FRAME_SIZE_US,
				    LC3_NUM_CHANNELS);
	zassert_equal(ret, 0, "lc3_dec_init did not return zero");

	return NULL;
}

ZTEST(suite_sw_codec_lc3, test_sw_codec_lc3_enc_dec)
{
	int ret;

	ret = sw_codec_lc3_enc_run(sample_sine_100hz, sizeof(sample_sine_100hz),
				   LC3_USE_BITRATE_FROM_INIT, AUDIO_CH_L, sizeof(audio_encoded_l),
				   audio_encoded_l, &encoded_bytes_written_l);
	zassert_equal(ret, 0, "sw_codec_lc3_enc_run did not return zero");

	ret = sw_codec_lc3_enc_run(sample_sine_100hz, sizeof(sample_sine_100hz),
				   LC3_USE_BITRATE_FROM_INIT, AUDIO_CH_R, sizeof(audio_encoded_r),
				   audio_encoded_r, &encoded_bytes_written_r);
	zassert_equal(ret, 0, "sw_codec_lc3_enc_run did not return zero");

	zassert_equal(encoded_bytes_written_l, encoded_bytes_written_r,
		      "ENC num bytes left and right are not equal");
	zassert_equal(memcmp(audio_encoded_l, audio_encoded_r, encoded_bytes_written_l), 0,
		      "Left encoded data does not match right encoded data");

	ret = sw_codec_lc3_dec_run(audio_encoded_l, encoded_bytes_written_l, DEC_BUF_SIZE,
				   AUDIO_CH_L, audio_decoded_l, &decoded_bytes_written_l, false);
	zassert_equal(ret, 0, "sw_codec_lc3_dec_run did not return zero");

	ret = sw_codec_lc3_dec_run(audio_encoded_r, encoded_bytes_written_r, DEC_BUF_SIZE,
				   AUDIO_CH_R, audio_decoded_r, &decoded_bytes_written_r, false);
	zassert_equal(ret, 0, "sw_codec_lc3_dec_run did not return zero");

	zassert_equal(decoded_bytes_written_l, decoded_bytes_written_r,
		      "DEC num bytes left and right are not equal");
	zassert_equal(memcmp(audio_decoded_l, audio_decoded_r, decoded_bytes_written_l), 0,
		      "Left PCM data does not match right PCM data");
}

ZTEST_SUITE(suite_sw_codec_lc3, NULL, test_sw_codec_lc3_init, NULL, NULL, NULL);
