#
# Copyright (c) 2024 Nordic Semiconductor
#
# SPDX-License-Identifier: LicenseRef-Nordic-5-Clause
#
# Convert all standard Kconfig variables for mbed TLS (strip CONFIG_)


# All PSA_WANT_ symbols in alphabetical order */
kconfig_check_and_set_base_to_one(PSA_WANT_AES_KEY_SIZE_128)
kconfig_check_and_set_base_to_one(PSA_WANT_AES_KEY_SIZE_192)
kconfig_check_and_set_base_to_one(PSA_WANT_AES_KEY_SIZE_256)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_CBC_MAC)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_CBC_NO_PADDING)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_CBC_PKCS7)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_CCM)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_CCM_STAR_NO_TAG)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_CFB)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_CHACHA20_POLY1305)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_CMAC)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_CTR)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_CTR_DRBG)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_DETERMINISTIC_ECDSA)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_ECB_NO_PADDING)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_ECDH)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_ECDSA)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_ECDSA_ANY)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_ED25519PH)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_ED448PH)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_FFDH)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_GCM)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_HKDF)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_HKDF_EXPAND)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_HKDF_EXTRACT)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_HMAC)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_HMAC_DRBG)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_JPAKE)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_MD2)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_MD4)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_MD5)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_OFB)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_PBKDF2_AES_CMAC_PRF_128)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_PBKDF2_HMAC)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_PURE_EDDSA)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_RIPEMD160)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_RSA_OAEP)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_RSA_PKCS1V15_CRYPT)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_RSA_PKCS1V15_SIGN)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_RSA_PKCS1V15_SIGN_RAW)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_RSA_PSS)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_RSA_PSS_ANY_SALT)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SHA3_224)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SHA3_256)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SHA3_384)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SHA3_512)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SHAKE256_512)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SHA_1)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SHA_224)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SHA_256)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SHA_384)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SHA_512)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SHA_512_224)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SHA_512_256)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SM3)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SPAKE2P_CMAC)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SPAKE2P_HMAC)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SPAKE2P_MATTER)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SRP_6)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SRP_PASSWORD_HASH)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_STREAM_CIPHER)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_TLS12_ECJPAKE_TO_PMS)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_TLS12_PRF)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_TLS12_PSK_TO_MS)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_XTS)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_BRAINPOOL_P_R1_160)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_BRAINPOOL_P_R1_192)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_BRAINPOOL_P_R1_224)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_BRAINPOOL_P_R1_256)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_BRAINPOOL_P_R1_320)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_BRAINPOOL_P_R1_384)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_BRAINPOOL_P_R1_512)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_FRP_V1_256)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_MONTGOMERY_255)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_MONTGOMERY_448)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECP_K1_192)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECP_K1_224)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECP_K1_256)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECP_R1_192)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECP_R1_224)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECP_R1_256)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECP_R1_384)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECP_R1_521)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECP_R2_160)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECT_K1_163)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECT_K1_233)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECT_K1_239)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECT_K1_283)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECT_K1_409)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECT_K1_571)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECT_R1_163)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECT_R1_233)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECT_R1_283)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECT_R1_409)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECT_R1_571)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_SECT_R2_163)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_TWISTED_EDWARDS_255)
kconfig_check_and_set_base_to_one(PSA_WANT_ECC_TWISTED_EDWARDS_448)
kconfig_check_and_set_base_to_one(PSA_WANT_GENERATE_RANDOM)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_AES)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_ARC4)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_ARIA)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_CAMELLIA)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_CHACHA20)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_DERIVE)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_DES)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_DH_KEY_PAIR)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_DH_PUBLIC_KEY)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_ECC_KEY_PAIR)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_ECC_KEY_PAIR_BASIC)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_ECC_KEY_PAIR_DERIVE)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_ECC_KEY_PAIR_EXPORT)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_ECC_KEY_PAIR_GENERATE)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_ECC_KEY_PAIR_IMPORT)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_ECC_PUBLIC_KEY)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_HMAC)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_PASSWORD)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_PASSWORD_HASH)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_PEPPER)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_RAW_DATA)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_RSA_KEY_PAIR)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_RSA_KEY_PAIR_BASIC)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_RSA_KEY_PAIR_EXPORT)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_RSA_KEY_PAIR_GENERATE)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_RSA_KEY_PAIR_IMPORT)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_RSA_PUBLIC_KEY)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SM4)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SPAKE2P_KEY_PAIR)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SPAKE2P_KEY_PAIR_BASIC)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SPAKE2P_KEY_PAIR_DERIVE)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SPAKE2P_KEY_PAIR_EXPORT)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SPAKE2P_KEY_PAIR_IMPORT)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SPAKE2P_PUBLIC_KEY)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SRP_KEY_PAIR)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SRP_KEY_PAIR_BASIC)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SRP_KEY_PAIR_DERIVE)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SRP_KEY_PAIR_EXPORT)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SRP_KEY_PAIR_IMPORT)
kconfig_check_and_set_base_to_one(PSA_WANT_KEY_TYPE_SRP_PUBLIC_KEY)
kconfig_check_and_set_base_to_one(PSA_WANT_RSA_KEY_SIZE_1024)
kconfig_check_and_set_base_to_one(PSA_WANT_RSA_KEY_SIZE_1536)
kconfig_check_and_set_base_to_one(PSA_WANT_RSA_KEY_SIZE_2048)
kconfig_check_and_set_base_to_one(PSA_WANT_RSA_KEY_SIZE_3072)
kconfig_check_and_set_base_to_one(PSA_WANT_RSA_KEY_SIZE_4096)
kconfig_check_and_set_base_to_one(PSA_WANT_RSA_KEY_SIZE_6144)
kconfig_check_and_set_base_to_one(PSA_WANT_RSA_KEY_SIZE_8192)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SP800_108_COUNTER_CMAC)
kconfig_check_and_set_base_to_one(PSA_WANT_ALG_SP800_108_COUNTER_HMAC)

kconfig_check_and_set_base_int(PSA_MAX_RSA_KEY_BITS)


if(CONFIG_GENERATE_MBEDTLS_CFG_FILE)
  # Create the mbed TLS PSA config file that contains all the PSA_WANT definitions
  configure_file(${NRF_SECURITY_ROOT}/configs/psa_crypto_want_config.h.template
    ${generated_include_path}/${CONFIG_MBEDTLS_PSA_CRYPTO_CONFIG_FILE}
  )
endif()
