/*
 * Copyright (c) 2024 Nordic Semiconductor ASA
 *
 * SPDX-License-Identifier: LicenseRef-Nordic-5-Clause
 */

/*
 * $ openssl genpkey -algorithm RSA -outform DER -out private_key.der -pkeyopt rsa_keygen_bits:4096
 * $ openssl rsa -in private_key.der -inform DER -pubout -outform DER -out public_key.der
 */
const unsigned char private_key_der[] = {
	0x30, 0x82, 0x09, 0x28, 0x02, 0x01, 0x00, 0x02, 0x82, 0x02, 0x01, 0x00, 0xb7, 0xe5, 0xa6,
	0x58, 0x69, 0x16, 0xda, 0x73, 0xa1, 0x2c, 0x8f, 0x71, 0x91, 0x67, 0x41, 0x02, 0xfa, 0x5d,
	0x58, 0x95, 0x08, 0x2b, 0xdd, 0xc3, 0xd0, 0xbd, 0x6c, 0x41, 0xc9, 0x17, 0x97, 0xf1, 0xf4,
	0x34, 0xcb, 0x37, 0xdc, 0xc5, 0xb9, 0x57, 0x63, 0x16, 0xf7, 0xce, 0x6c, 0xf6, 0x89, 0xda,
	0xf4, 0xa8, 0x0f, 0x37, 0x8f, 0x1a, 0x66, 0x7c, 0x1e, 0x93, 0x5e, 0x0e, 0x63, 0xa7, 0x5f,
	0x1b, 0x90, 0x48, 0x21, 0xac, 0x02, 0x13, 0xf9, 0x36, 0x44, 0x53, 0x07, 0x77, 0x45, 0x9c,
	0xdc, 0xc1, 0x08, 0x51, 0xb7, 0xa6, 0x73, 0x26, 0x32, 0x93, 0xb2, 0x9c, 0x7e, 0xba, 0x39,
	0x67, 0x59, 0xf1, 0x01, 0xdb, 0xc6, 0xfa, 0x4c, 0x2a, 0xac, 0x43, 0x44, 0xb7, 0x6b, 0x42,
	0xe6, 0xb1, 0x20, 0xf4, 0x5a, 0xc0, 0x6d, 0x22, 0x1f, 0x64, 0x8d, 0x1d, 0xb5, 0x04, 0x10,
	0x57, 0x51, 0x12, 0x8d, 0xcd, 0x5d, 0xd9, 0xb1, 0x06, 0xd7, 0x47, 0x8b, 0x18, 0x5f, 0x1e,
	0x96, 0xd2, 0x0d, 0xa9, 0x8e, 0xf5, 0x5c, 0x80, 0xdb, 0xc5, 0xaf, 0xe2, 0x2a, 0x23, 0x2e,
	0xfd, 0x43, 0x6e, 0x66, 0x0d, 0x2d, 0x45, 0x12, 0xa4, 0xcb, 0x47, 0x12, 0xc2, 0xe8, 0xba,
	0xfb, 0x99, 0xec, 0x05, 0x57, 0x6d, 0xd6, 0xa0, 0x66, 0x3a, 0x9a, 0x63, 0x6f, 0x58, 0x9f,
	0x72, 0xf6, 0x0a, 0x47, 0xb7, 0xea, 0x8e, 0xae, 0xb1, 0x52, 0x28, 0xfd, 0xe9, 0x16, 0x14,
	0x46, 0x8b, 0x1b, 0x2e, 0x85, 0xc6, 0x7e, 0x99, 0x85, 0x22, 0x16, 0x23, 0x14, 0x49, 0x22,
	0x53, 0x1e, 0x7b, 0x04, 0x6c, 0xb9, 0x75, 0xe8, 0xdb, 0xba, 0x96, 0x8a, 0x63, 0x38, 0xcc,
	0x9f, 0x59, 0xeb, 0xcf, 0x27, 0x3b, 0x66, 0x21, 0xfe, 0x4b, 0xa3, 0x76, 0x5c, 0xb0, 0x64,
	0x40, 0xfb, 0x93, 0x25, 0x68, 0xb9, 0xa1, 0xc4, 0x9b, 0x80, 0x5e, 0x25, 0xee, 0xc6, 0xa8,
	0xd3, 0x9c, 0x3a, 0xfe, 0x71, 0xef, 0x56, 0xaa, 0xef, 0x4a, 0x33, 0x47, 0xd6, 0xbe, 0x7b,
	0x77, 0x9b, 0x66, 0x49, 0xaa, 0x58, 0x67, 0xef, 0xb8, 0xe8, 0x5b, 0x84, 0xa0, 0x9f, 0xdc,
	0xcf, 0x38, 0x62, 0x05, 0x6d, 0x5b, 0x88, 0xd5, 0x1b, 0xc7, 0x3a, 0xd0, 0x3a, 0xd3, 0x58,
	0x04, 0xa0, 0x5b, 0x8b, 0x60, 0x82, 0x28, 0x44, 0xbf, 0x89, 0xbf, 0xe1, 0xbc, 0x0e, 0x6e,
	0xf7, 0x98, 0x38, 0xd4, 0x90, 0x38, 0xa1, 0xd6, 0x5a, 0x52, 0x95, 0x4a, 0xdf, 0xf1, 0x06,
	0x94, 0x81, 0x95, 0x53, 0xe8, 0xb7, 0x4b, 0xa4, 0x3f, 0x0a, 0x0e, 0xbd, 0x53, 0x38, 0x67,
	0x64, 0x3c, 0x86, 0x1e, 0xa5, 0x5d, 0xb7, 0x9d, 0xc8, 0x9b, 0x76, 0xea, 0xde, 0x3a, 0x45,
	0x95, 0x7f, 0xb0, 0xb6, 0x6b, 0xc3, 0x25, 0x32, 0x0a, 0xbd, 0x6a, 0x05, 0x23, 0x76, 0x1d,
	0x9f, 0xb9, 0xe1, 0xe8, 0x47, 0xbf, 0xb4, 0x0f, 0x67, 0xeb, 0x64, 0xfc, 0xdd, 0x8c, 0xda,
	0x14, 0xf5, 0x55, 0x7b, 0xce, 0x8d, 0x7d, 0xb2, 0x6f, 0xab, 0x51, 0xbf, 0x62, 0xa1, 0x99,
	0x52, 0x92, 0x99, 0xca, 0xdf, 0x2f, 0x18, 0x9e, 0x29, 0x94, 0x42, 0xe4, 0x77, 0x3c, 0x59,
	0x04, 0x03, 0x1f, 0xc7, 0x82, 0x13, 0x93, 0x01, 0xbc, 0xf7, 0x2b, 0x0f, 0xf9, 0x46, 0xbc,
	0x44, 0xcf, 0xb7, 0x2f, 0xa1, 0x91, 0x68, 0x25, 0xa7, 0x1d, 0x7e, 0x8a, 0x98, 0x88, 0x63,
	0x8a, 0xba, 0xef, 0xed, 0x90, 0x7b, 0xc0, 0x91, 0x79, 0x72, 0x41, 0xf3, 0x15, 0x8e, 0xc7,
	0x12, 0x5c, 0xdd, 0xf9, 0x20, 0x92, 0x2d, 0x7c, 0x4e, 0x01, 0x67, 0xce, 0x97, 0x61, 0xf4,
	0xff, 0x64, 0x4a, 0xf0, 0x1a, 0xf7, 0x14, 0xf9, 0x71, 0x97, 0xc6, 0x07, 0x91, 0xe9, 0xbd,
	0xf0, 0xa0, 0x3c, 0xc3, 0x7b, 0x91, 0xb0, 0x36, 0x10, 0x3a, 0xc9, 0x65, 0x97, 0x17, 0x02,
	0x03, 0x01, 0x00, 0x01, 0x02, 0x82, 0x01, 0xff, 0x71, 0x3b, 0xdd, 0xa0, 0xa3, 0xe1, 0xbb,
	0x5d, 0x44, 0x83, 0x45, 0x47, 0xb1, 0x5a, 0x51, 0xd8, 0x58, 0xeb, 0x10, 0x75, 0xc5, 0x01,
	0x3d, 0xc8, 0x08, 0x73, 0x89, 0xd7, 0x80, 0xae, 0x86, 0x72, 0x28, 0xc2, 0x37, 0x2c, 0x8c,
	0x77, 0xbb, 0xf5, 0x0a, 0x9f, 0xde, 0x29, 0xdf, 0x87, 0xef, 0x27, 0x74, 0xa0, 0xb1, 0xcf,
	0x15, 0x35, 0x23, 0xd4, 0xd2, 0x0f, 0xfd, 0x05, 0x12, 0x68, 0xc1, 0x2f, 0xea, 0xf4, 0x7f,
	0x60, 0xea, 0xd5, 0x94, 0xda, 0x44, 0x5a, 0x0f, 0x03, 0x15, 0x6b, 0x45, 0x93, 0xfd, 0x2d,
	0x87, 0x67, 0xdd, 0x08, 0x06, 0x0b, 0x85, 0xa2, 0xc6, 0x21, 0x6d, 0x8c, 0xa4, 0xff, 0xca,
	0x4f, 0xd6, 0xb5, 0xae, 0xec, 0x75, 0x9d, 0x5c, 0x87, 0xfa, 0xd0, 0xc8, 0x19, 0xd1, 0xd3,
	0x0a, 0xfd, 0x60, 0xbe, 0x33, 0x2f, 0xf2, 0xc5, 0xb5, 0xec, 0x28, 0x8a, 0x24, 0x03, 0xb7,
	0xa2, 0x5f, 0x1f, 0x0a, 0x2f, 0x12, 0x93, 0x58, 0xe8, 0x06, 0xbb, 0x0a, 0xdf, 0x08, 0x46,
	0x57, 0x40, 0xac, 0xce, 0x89, 0x73, 0xd2, 0xbf, 0xac, 0x10, 0x75, 0x80, 0xc1, 0x84, 0xa7,
	0xeb, 0xa8, 0x63, 0x4e, 0xb9, 0xb2, 0xd8, 0x08, 0x24, 0x51, 0x5c, 0xf3, 0x7e, 0xba, 0x22,
	0xd4, 0x21, 0xd6, 0x97, 0x87, 0x4a, 0x17, 0x0a, 0xf0, 0x04, 0xee, 0xb2, 0x16, 0xbc, 0xf9,
	0x7d, 0x4e, 0x5f, 0xaf, 0x42, 0xc4, 0xb2, 0x45, 0xc8, 0x9e, 0x3e, 0xbb, 0xb9, 0xc9, 0xe9,
	0x5b, 0x98, 0x3b, 0xa0, 0x5d, 0x51, 0x53, 0x0b, 0xf1, 0x47, 0x17, 0x17, 0x5b, 0x82, 0xb9,
	0x72, 0x7d, 0x6a, 0xf2, 0x66, 0x38, 0x0f, 0x58, 0x05, 0x04, 0xeb, 0xe9, 0x55, 0x4a, 0x91,
	0x4c, 0x39, 0x1c, 0x5d, 0x9e, 0xeb, 0x05, 0x4d, 0x29, 0x4e, 0x40, 0xb1, 0x5c, 0x59, 0x58,
	0x62, 0xc5, 0xeb, 0x00, 0xc7, 0x03, 0xb2, 0xf5, 0x2f, 0xfd, 0xa7, 0xd5, 0x04, 0x6f, 0xff,
	0xeb, 0xca, 0x78, 0x96, 0x09, 0xd7, 0x52, 0x48, 0xb3, 0xa8, 0x33, 0xab, 0x99, 0x1c, 0x87,
	0x99, 0x9d, 0x9b, 0x9f, 0xa5, 0x32, 0x58, 0xcd, 0xd1, 0x97, 0x5d, 0xa5, 0x12, 0x18, 0xe8,
	0x3f, 0x7b, 0x17, 0x92, 0x74, 0x98, 0xd4, 0xc0, 0x6c, 0x65, 0x98, 0x9b, 0xec, 0x23, 0xd4,
	0xb4, 0x86, 0x4c, 0x2c, 0x61, 0x22, 0x50, 0xf9, 0x4f, 0x8e, 0xf3, 0x5d, 0x61, 0x34, 0x0e,
	0x41, 0x50, 0xfb, 0x67, 0x5e, 0xdd, 0x4e, 0x29, 0x57, 0x4a, 0xe5, 0xbf, 0x1e, 0x92, 0xaf,
	0x1d, 0x37, 0x97, 0x84, 0xc7, 0xc5, 0xa8, 0x01, 0x7c, 0x90, 0x92, 0x37, 0xd4, 0x5b, 0x86,
	0x30, 0xdd, 0x59, 0x53, 0x32, 0xd5, 0x90, 0xff, 0xe3, 0xb9, 0x87, 0x0f, 0x41, 0x29, 0x6a,
	0xd3, 0x91, 0xf5, 0x2b, 0xd3, 0x33, 0xaa, 0x26, 0xd9, 0xf6, 0x22, 0xe8, 0x73, 0xdf, 0x45,
	0x83, 0x3b, 0xa4, 0x25, 0xb7, 0x61, 0x2c, 0x30, 0x43, 0x25, 0xbb, 0xb6, 0xb5, 0xf6, 0x0b,
	0x89, 0xda, 0x7d, 0x63, 0x86, 0x47, 0x25, 0xf4, 0x58, 0xa5, 0x82, 0xba, 0x68, 0xda, 0xc7,
	0xb9, 0x22, 0xd6, 0x08, 0xf3, 0x13, 0x49, 0x23, 0x29, 0x7e, 0x96, 0xca, 0x27, 0xb7, 0x5f,
	0x51, 0x6a, 0x31, 0xcb, 0xde, 0xbc, 0xe5, 0x9e, 0x4e, 0x47, 0xf9, 0x74, 0x2b, 0x50, 0xff,
	0x24, 0x20, 0x0f, 0x10, 0x85, 0xce, 0x7c, 0x9c, 0xd1, 0x7f, 0xa8, 0x5a, 0x5b, 0xfe, 0x19,
	0x18, 0x58, 0xaf, 0xcf, 0xd9, 0xa9, 0xc1, 0xe0, 0xd9, 0xe0, 0x68, 0x67, 0x1a, 0x01, 0x36,
	0x2b, 0x4d, 0x8c, 0xc2, 0xa4, 0x16, 0x6d, 0x32, 0xf1, 0xa2, 0x02, 0xa2, 0x4b, 0x3e, 0xf6,
	0x21, 0x05, 0xca, 0xbf, 0xe7, 0x53, 0x01, 0x6d, 0x48, 0xb0, 0xfa, 0x27, 0x9a, 0x07, 0xa9,
	0x64, 0xbb, 0x43, 0xc8, 0x75, 0xfb, 0x57, 0x9d, 0x59, 0x02, 0x82, 0x01, 0x01, 0x00, 0xcc,
	0x64, 0x0c, 0x1f, 0x0f, 0xa4, 0xa4, 0xcb, 0x02, 0x41, 0xd0, 0x86, 0x45, 0x18, 0xe6, 0xc9,
	0x4b, 0xe0, 0xcf, 0x89, 0xcb, 0x91, 0x93, 0x1d, 0x4c, 0x75, 0x13, 0x6f, 0x96, 0x0c, 0x71,
	0x0a, 0x0c, 0x9c, 0x0e, 0xb9, 0x3f, 0x3c, 0x65, 0x68, 0xd0, 0xaa, 0x3a, 0x74, 0xa7, 0xbc,
	0x5d, 0x98, 0x81, 0xb2, 0x4d, 0x74, 0x85, 0x68, 0xbd, 0xe6, 0xb8, 0xc3, 0x8a, 0xdc, 0x57,
	0xb1, 0x96, 0x50, 0x13, 0xae, 0x25, 0x90, 0x43, 0x91, 0xc2, 0x3e, 0x85, 0x36, 0x45, 0x0e,
	0xcf, 0x68, 0x97, 0x25, 0x91, 0x51, 0xc2, 0x8a, 0x1e, 0xea, 0xae, 0xd4, 0x8b, 0xf7, 0x4d,
	0xf1, 0x20, 0x36, 0xd8, 0x53, 0xd6, 0x36, 0xba, 0xa9, 0x38, 0x7e, 0x53, 0x96, 0x73, 0x1b,
	0x12, 0xe7, 0x90, 0x35, 0x38, 0xfb, 0x55, 0xc0, 0x54, 0x25, 0x7a, 0xbe, 0x01, 0xbc, 0x1e,
	0x46, 0x66, 0x03, 0x3a, 0xa3, 0xa1, 0x70, 0x06, 0x3d, 0x9a, 0xb2, 0xd2, 0x96, 0x0f, 0x4e,
	0x12, 0x33, 0x23, 0x9b, 0x17, 0x85, 0x18, 0x4a, 0xf1, 0xac, 0xbd, 0x35, 0x51, 0x75, 0x08,
	0x83, 0x32, 0x51, 0xd7, 0x45, 0x82, 0x30, 0xb7, 0xef, 0x17, 0xea, 0x24, 0x44, 0x71, 0xc0,
	0x7e, 0xc1, 0xc0, 0x7e, 0xfa, 0x5d, 0x7f, 0xb5, 0x3c, 0xc9, 0x6f, 0x11, 0x42, 0x77, 0x14,
	0xa2, 0xc6, 0xdf, 0xda, 0xea, 0x7b, 0x12, 0xee, 0xee, 0x52, 0x17, 0x22, 0xd2, 0xa0, 0x5d,
	0x2d, 0x81, 0x68, 0x49, 0xf4, 0xfe, 0x17, 0x5a, 0xd3, 0x63, 0x4e, 0x77, 0x0c, 0xe6, 0xdd,
	0x33, 0x6f, 0x8d, 0xa7, 0x57, 0x23, 0x84, 0x94, 0x56, 0xc9, 0xaa, 0x5c, 0xfa, 0x2b, 0xd7,
	0x30, 0xe5, 0x67, 0x4a, 0x9c, 0xbf, 0xf1, 0x56, 0x06, 0x01, 0x46, 0x88, 0x48, 0x7c, 0x2f,
	0x25, 0x0a, 0x6f, 0xd5, 0x04, 0x3e, 0x71, 0x3f, 0x73, 0x2e, 0xd7, 0x65, 0xde, 0xf0, 0x6f,
	0x02, 0x82, 0x01, 0x01, 0x00, 0xe6, 0x54, 0xdf, 0xbb, 0x18, 0x0d, 0x29, 0x21, 0x87, 0x10,
	0x37, 0x75, 0xe1, 0x50, 0x15, 0x75, 0xcd, 0x74, 0x26, 0x90, 0xc4, 0x9d, 0x61, 0x2f, 0x4a,
	0x58, 0x35, 0x13, 0x8e, 0x99, 0xd2, 0x10, 0x09, 0x16, 0x8b, 0xbd, 0xbb, 0xeb, 0x0c, 0xec,
	0xf2, 0x70, 0x10, 0xa0, 0x8f, 0xa7, 0x97, 0xb9, 0xef, 0x36, 0xd2, 0xfc, 0xe5, 0x32, 0x06,
	0x0b, 0x95, 0x03, 0x17, 0xdf, 0x3a, 0x74, 0xdb, 0x5b, 0xe6, 0xd6, 0xa2, 0xe4, 0xf0, 0x20,
	0x66, 0xb4, 0x9c, 0x07, 0x6d, 0xeb, 0x31, 0x88, 0x3d, 0xb7, 0x97, 0x24, 0x14, 0xe6, 0xde,
	0x88, 0x8e, 0x7c, 0xa6, 0xb4, 0xcc, 0x37, 0x2c, 0x5d, 0x4e, 0xb3, 0x20, 0xcd, 0xfb, 0x2f,
	0x8b, 0xcb, 0x8f, 0x8b, 0x00, 0xc3, 0x5b, 0xd8, 0xc8, 0xd9, 0x9e, 0xe9, 0xc3, 0x1d, 0x2e,
	0x26, 0x7b, 0x50, 0x1d, 0x6a, 0x83, 0xfa, 0xd7, 0x50, 0xce, 0x26, 0xbc, 0xfc, 0x71, 0x0f,
	0x18, 0xa3, 0xe2, 0x31, 0x5f, 0x6d, 0xb8, 0xe5, 0x5f, 0xec, 0xce, 0xe0, 0xa8, 0x17, 0xab,
	0xe5, 0x85, 0x91, 0x78, 0x01, 0x84, 0x88, 0x02, 0xd3, 0x46, 0x4c, 0xc6, 0x6b, 0xa1, 0xda,
	0xab, 0x9a, 0xe7, 0xa8, 0x8d, 0x17, 0x91, 0x41, 0xf8, 0xd5, 0x6d, 0xdd, 0x85, 0x3a, 0xce,
	0xc0, 0xc0, 0x9d, 0xbe, 0x90, 0x29, 0xbd, 0xad, 0x8e, 0xe6, 0x8e, 0x92, 0x2f, 0x70, 0x15,
	0x87, 0x41, 0x06, 0x35, 0xb6, 0xeb, 0x43, 0x7c, 0x70, 0x3d, 0x66, 0x28, 0xc2, 0x2f, 0xe4,
	0x84, 0x04, 0xb5, 0x11, 0xe8, 0xb7, 0xa6, 0xfe, 0xd2, 0x73, 0x06, 0x65, 0x3c, 0xd3, 0x90,
	0x11, 0x55, 0xe7, 0x72, 0xa5, 0xd8, 0xcb, 0x23, 0x82, 0x4f, 0xdd, 0xec, 0xe2, 0xaf, 0xe4,
	0x81, 0x3f, 0xe7, 0x43, 0xf2, 0x67, 0x66, 0xf7, 0x8b, 0xdc, 0xd8, 0x28, 0x14, 0x61, 0xd9,
	0xca, 0xa7, 0xa5, 0x93, 0x47, 0xd9, 0x02, 0x82, 0x01, 0x00, 0x1e, 0xc2, 0x83, 0xcc, 0x7c,
	0xe7, 0x33, 0x61, 0xd6, 0x02, 0x1f, 0xa6, 0xc5, 0x69, 0x5c, 0xfa, 0x38, 0x70, 0x29, 0xeb,
	0xbb, 0xf6, 0x39, 0xa4, 0xb4, 0x27, 0xfe, 0x77, 0xd1, 0xa6, 0x27, 0xb0, 0xf2, 0x7a, 0xde,
	0x00, 0x65, 0x12, 0xea, 0xd4, 0x1e, 0x6b, 0x30, 0x06, 0xf4, 0x63, 0x75, 0xd6, 0x88, 0xd6,
	0x53, 0xaf, 0xd0, 0x90, 0x15, 0xdc, 0x4e, 0x3c, 0x27, 0x7e, 0xc7, 0xb7, 0xd3, 0x3e, 0x53,
	0xe7, 0xe6, 0x81, 0x52, 0x99, 0xf2, 0x18, 0xc4, 0xa5, 0x89, 0x39, 0x14, 0x5f, 0xd2, 0x37,
	0x76, 0x2a, 0x4e, 0xd3, 0xc8, 0x99, 0x5b, 0x1c, 0x63, 0xc0, 0x21, 0x3b, 0xc3, 0xb4, 0x5d,
	0x54, 0x28, 0xad, 0xed, 0xe3, 0x9f, 0xbb, 0xeb, 0x4a, 0x7e, 0x22, 0x39, 0xf3, 0x1d, 0x91,
	0xd4, 0xf4, 0x86, 0x50, 0x3e, 0x99, 0xb1, 0x62, 0x3d, 0x12, 0x99, 0x9f, 0xd0, 0xa4, 0x75,
	0xc3, 0xc0, 0x7d, 0x02, 0x83, 0x6c, 0xef, 0xb2, 0x9f, 0xa0, 0xc8, 0x08, 0x17, 0x28, 0x29,
	0xa4, 0x1d, 0x84, 0xad, 0x6a, 0xb7, 0xab, 0x76, 0x05, 0xbf, 0x4e, 0x3b, 0xa8, 0x6c, 0x06,
	0xb0, 0xd0, 0x4a, 0x12, 0xb4, 0x69, 0xed, 0xf3, 0xed, 0x55, 0x0d, 0x3a, 0x46, 0x60, 0x78,
	0xfb, 0xa6, 0xec, 0x9c, 0x52, 0xfc, 0xa1, 0xb9, 0x80, 0x3e, 0x39, 0x9d, 0xd1, 0xbe, 0x48,
	0xcc, 0xf7, 0x1e, 0xbf, 0x54, 0xa0, 0x88, 0x18, 0xd6, 0x88, 0x09, 0xdd, 0xda, 0x56, 0xde,
	0xa2, 0x7f, 0x46, 0xf6, 0x85, 0x4f, 0xb1, 0xb4, 0x5a, 0xfd, 0xb7, 0x96, 0x91, 0x18, 0x49,
	0x71, 0xe4, 0xc7, 0x84, 0x27, 0x97, 0x8c, 0x0b, 0x18, 0x1f, 0x56, 0xf0, 0x65, 0xe5, 0xe8,
	0xa5, 0xb4, 0x81, 0x56, 0x87, 0xea, 0xd3, 0x39, 0x99, 0x67, 0x0f, 0x15, 0x4c, 0xff, 0xcd,
	0x98, 0x28, 0xe9, 0x94, 0x39, 0xfa, 0x77, 0xb2, 0x3e, 0x1e, 0x03, 0x02, 0x82, 0x01, 0x01,
	0x00, 0x95, 0xde, 0xb5, 0xf1, 0x14, 0x16, 0x44, 0x24, 0x17, 0xb0, 0xfa, 0x95, 0x4e, 0x35,
	0x00, 0xb1, 0xb5, 0x2c, 0x95, 0x87, 0x6f, 0x17, 0x84, 0x4b, 0xf4, 0x10, 0xef, 0x00, 0x39,
	0xb2, 0x66, 0xd7, 0x9e, 0x42, 0x38, 0x4d, 0x0d, 0x80, 0x44, 0xd9, 0xcc, 0x6a, 0x14, 0xb7,
	0x94, 0xa1, 0x94, 0xfd, 0x1b, 0xe4, 0xcd, 0x66, 0x56, 0x6f, 0xb5, 0x35, 0x46, 0x11, 0x4c,
	0x30, 0x28, 0xe6, 0x2e, 0x71, 0x5f, 0x03, 0x5b, 0xdc, 0xa1, 0x4e, 0x43, 0xe5, 0xd2, 0xfc,
	0x96, 0x8e, 0x09, 0x9d, 0xbf, 0xa2, 0xbc, 0xca, 0x72, 0x7b, 0x42, 0x63, 0x12, 0x6b, 0x93,
	0x41, 0x62, 0xfb, 0xa7, 0x77, 0x53, 0x25, 0x04, 0xfc, 0x62, 0x2b, 0xae, 0xc7, 0x96, 0x2f,
	0xf9, 0x20, 0x24, 0x9c, 0x2b, 0x1c, 0x46, 0xe5, 0x8d, 0xda, 0x67, 0xd4, 0x0c, 0x3a, 0xb5,
	0xd9, 0x3f, 0xe5, 0x30, 0xc2, 0xd8, 0x50, 0xa6, 0x79, 0x8f, 0xcb, 0x25, 0xda, 0x44, 0xec,
	0xa1, 0x4e, 0x50, 0x97, 0x97, 0x52, 0x0b, 0xce, 0x6c, 0x31, 0x72, 0xdd, 0x16, 0x8a, 0xef,
	0xcd, 0xf5, 0x01, 0x56, 0xed, 0x47, 0xf9, 0xde, 0xc5, 0xdb, 0xfb, 0xdf, 0xdb, 0x1c, 0x4f,
	0x34, 0xf7, 0x17, 0xc2, 0x18, 0x7a, 0x2f, 0x51, 0x8b, 0x46, 0x17, 0x8f, 0x9e, 0x05, 0x46,
	0x20, 0xa1, 0xb8, 0x54, 0xbc, 0xfd, 0xd1, 0xd8, 0xd6, 0xdb, 0x14, 0x76, 0xfc, 0x5d, 0x61,
	0x08, 0x13, 0x8e, 0xc6, 0xe2, 0x75, 0x61, 0x0a, 0xb6, 0x47, 0xd9, 0x65, 0xf9, 0x76, 0x24,
	0x20, 0x0b, 0x97, 0xb2, 0x89, 0x16, 0xe5, 0x1b, 0x6c, 0x77, 0xb0, 0x6f, 0x47, 0x39, 0x21,
	0x05, 0x3e, 0xc9, 0xf6, 0xe1, 0xec, 0xbb, 0xd7, 0x4e, 0x2c, 0xea, 0xff, 0x1a, 0xa8, 0x8d,
	0x32, 0xa6, 0x0b, 0x7e, 0x99, 0x57, 0xea, 0xa2, 0x31, 0x98, 0xf5, 0xd0, 0x82, 0x43, 0x1f,
	0x51, 0x09, 0x02, 0x82, 0x01, 0x01, 0x00, 0xbc, 0x01, 0x10, 0x53, 0x17, 0x77, 0xd7, 0xad,
	0x24, 0xff, 0xe4, 0xe8, 0x89, 0x0a, 0x25, 0x61, 0x8c, 0x0e, 0xaf, 0xa8, 0xa1, 0xbd, 0x95,
	0x2d, 0x9b, 0xe9, 0xdc, 0xbc, 0xe5, 0x15, 0xe8, 0x9e, 0xd2, 0xa5, 0x8b, 0x9e, 0xce, 0x35,
	0xa2, 0x15, 0x2d, 0x36, 0xc5, 0x93, 0x8d, 0xfe, 0x0d, 0xb1, 0x44, 0xb4, 0xd4, 0x0a, 0x44,
	0x65, 0x0f, 0x27, 0x63, 0xe8, 0xdd, 0x17, 0x80, 0x8f, 0x72, 0xae, 0xc7, 0x5a, 0x35, 0x9d,
	0x74, 0xee, 0x61, 0xc6, 0x26, 0xc3, 0x45, 0x55, 0x66, 0xe7, 0x76, 0x75, 0x47, 0x68, 0x69,
	0x33, 0xcb, 0xe9, 0x39, 0x68, 0x04, 0x89, 0xfc, 0x9a, 0xe0, 0xeb, 0xee, 0x41, 0x80, 0xe2,
	0xf6, 0x98, 0x59, 0x6d, 0xab, 0xcb, 0x22, 0xaf, 0x12, 0xb7, 0xf4, 0x48, 0x75, 0x52, 0x94,
	0xcd, 0x94, 0xd6, 0xf7, 0x78, 0xeb, 0x8b, 0x97, 0xbe, 0x79, 0xec, 0x62, 0xe2, 0xbf, 0x3a,
	0x3e, 0xe4, 0xad, 0x04, 0xb0, 0x53, 0x4a, 0xc3, 0xe1, 0x27, 0xb6, 0xc0, 0xa9, 0xa7, 0x43,
	0x55, 0xc9, 0xcc, 0xc3, 0x26, 0xed, 0xdd, 0x23, 0xfb, 0x4b, 0xa4, 0x2c, 0xd8, 0x2e, 0xf9,
	0x3c, 0xbc, 0x9a, 0xb3, 0xdd, 0x8a, 0xb2, 0xda, 0xfc, 0x61, 0x6e, 0xa2, 0x41, 0x34, 0x1b,
	0x16, 0x2f, 0xbe, 0xfb, 0x3b, 0xcb, 0x51, 0x45, 0xdc, 0x12, 0x57, 0x09, 0xf8, 0xe1, 0x33,
	0x5a, 0x1e, 0x5e, 0x06, 0x86, 0x01, 0xdd, 0x82, 0x54, 0x4a, 0xf0, 0x9b, 0x92, 0x7e, 0xbe,
	0x63, 0x55, 0x6e, 0xd5, 0x5c, 0xaf, 0xbb, 0x36, 0x5a, 0x50, 0x7d, 0x1e, 0xbf, 0xd9, 0x69,
	0xc5, 0xef, 0x9d, 0xe5, 0x7d, 0x40, 0xef, 0xe0, 0xe9, 0x07, 0x6c, 0x6f, 0xf6, 0xe9, 0x23,
	0xb5, 0xf1, 0x85, 0x87, 0x5e, 0x9e, 0x5b, 0xae, 0x8d, 0x29, 0x8d, 0xf6, 0x17, 0x83, 0x91,
	0x16, 0x12, 0xcb, 0x6b, 0x6c, 0x13, 0x12, 0xda};

const unsigned char public_key_der[] = {
	0x30, 0x82, 0x02, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01,
	0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x02, 0x0f, 0x00, 0x30, 0x82, 0x02, 0x0a, 0x02, 0x82,
	0x02, 0x01, 0x00, 0xb7, 0xe5, 0xa6, 0x58, 0x69, 0x16, 0xda, 0x73, 0xa1, 0x2c, 0x8f, 0x71,
	0x91, 0x67, 0x41, 0x02, 0xfa, 0x5d, 0x58, 0x95, 0x08, 0x2b, 0xdd, 0xc3, 0xd0, 0xbd, 0x6c,
	0x41, 0xc9, 0x17, 0x97, 0xf1, 0xf4, 0x34, 0xcb, 0x37, 0xdc, 0xc5, 0xb9, 0x57, 0x63, 0x16,
	0xf7, 0xce, 0x6c, 0xf6, 0x89, 0xda, 0xf4, 0xa8, 0x0f, 0x37, 0x8f, 0x1a, 0x66, 0x7c, 0x1e,
	0x93, 0x5e, 0x0e, 0x63, 0xa7, 0x5f, 0x1b, 0x90, 0x48, 0x21, 0xac, 0x02, 0x13, 0xf9, 0x36,
	0x44, 0x53, 0x07, 0x77, 0x45, 0x9c, 0xdc, 0xc1, 0x08, 0x51, 0xb7, 0xa6, 0x73, 0x26, 0x32,
	0x93, 0xb2, 0x9c, 0x7e, 0xba, 0x39, 0x67, 0x59, 0xf1, 0x01, 0xdb, 0xc6, 0xfa, 0x4c, 0x2a,
	0xac, 0x43, 0x44, 0xb7, 0x6b, 0x42, 0xe6, 0xb1, 0x20, 0xf4, 0x5a, 0xc0, 0x6d, 0x22, 0x1f,
	0x64, 0x8d, 0x1d, 0xb5, 0x04, 0x10, 0x57, 0x51, 0x12, 0x8d, 0xcd, 0x5d, 0xd9, 0xb1, 0x06,
	0xd7, 0x47, 0x8b, 0x18, 0x5f, 0x1e, 0x96, 0xd2, 0x0d, 0xa9, 0x8e, 0xf5, 0x5c, 0x80, 0xdb,
	0xc5, 0xaf, 0xe2, 0x2a, 0x23, 0x2e, 0xfd, 0x43, 0x6e, 0x66, 0x0d, 0x2d, 0x45, 0x12, 0xa4,
	0xcb, 0x47, 0x12, 0xc2, 0xe8, 0xba, 0xfb, 0x99, 0xec, 0x05, 0x57, 0x6d, 0xd6, 0xa0, 0x66,
	0x3a, 0x9a, 0x63, 0x6f, 0x58, 0x9f, 0x72, 0xf6, 0x0a, 0x47, 0xb7, 0xea, 0x8e, 0xae, 0xb1,
	0x52, 0x28, 0xfd, 0xe9, 0x16, 0x14, 0x46, 0x8b, 0x1b, 0x2e, 0x85, 0xc6, 0x7e, 0x99, 0x85,
	0x22, 0x16, 0x23, 0x14, 0x49, 0x22, 0x53, 0x1e, 0x7b, 0x04, 0x6c, 0xb9, 0x75, 0xe8, 0xdb,
	0xba, 0x96, 0x8a, 0x63, 0x38, 0xcc, 0x9f, 0x59, 0xeb, 0xcf, 0x27, 0x3b, 0x66, 0x21, 0xfe,
	0x4b, 0xa3, 0x76, 0x5c, 0xb0, 0x64, 0x40, 0xfb, 0x93, 0x25, 0x68, 0xb9, 0xa1, 0xc4, 0x9b,
	0x80, 0x5e, 0x25, 0xee, 0xc6, 0xa8, 0xd3, 0x9c, 0x3a, 0xfe, 0x71, 0xef, 0x56, 0xaa, 0xef,
	0x4a, 0x33, 0x47, 0xd6, 0xbe, 0x7b, 0x77, 0x9b, 0x66, 0x49, 0xaa, 0x58, 0x67, 0xef, 0xb8,
	0xe8, 0x5b, 0x84, 0xa0, 0x9f, 0xdc, 0xcf, 0x38, 0x62, 0x05, 0x6d, 0x5b, 0x88, 0xd5, 0x1b,
	0xc7, 0x3a, 0xd0, 0x3a, 0xd3, 0x58, 0x04, 0xa0, 0x5b, 0x8b, 0x60, 0x82, 0x28, 0x44, 0xbf,
	0x89, 0xbf, 0xe1, 0xbc, 0x0e, 0x6e, 0xf7, 0x98, 0x38, 0xd4, 0x90, 0x38, 0xa1, 0xd6, 0x5a,
	0x52, 0x95, 0x4a, 0xdf, 0xf1, 0x06, 0x94, 0x81, 0x95, 0x53, 0xe8, 0xb7, 0x4b, 0xa4, 0x3f,
	0x0a, 0x0e, 0xbd, 0x53, 0x38, 0x67, 0x64, 0x3c, 0x86, 0x1e, 0xa5, 0x5d, 0xb7, 0x9d, 0xc8,
	0x9b, 0x76, 0xea, 0xde, 0x3a, 0x45, 0x95, 0x7f, 0xb0, 0xb6, 0x6b, 0xc3, 0x25, 0x32, 0x0a,
	0xbd, 0x6a, 0x05, 0x23, 0x76, 0x1d, 0x9f, 0xb9, 0xe1, 0xe8, 0x47, 0xbf, 0xb4, 0x0f, 0x67,
	0xeb, 0x64, 0xfc, 0xdd, 0x8c, 0xda, 0x14, 0xf5, 0x55, 0x7b, 0xce, 0x8d, 0x7d, 0xb2, 0x6f,
	0xab, 0x51, 0xbf, 0x62, 0xa1, 0x99, 0x52, 0x92, 0x99, 0xca, 0xdf, 0x2f, 0x18, 0x9e, 0x29,
	0x94, 0x42, 0xe4, 0x77, 0x3c, 0x59, 0x04, 0x03, 0x1f, 0xc7, 0x82, 0x13, 0x93, 0x01, 0xbc,
	0xf7, 0x2b, 0x0f, 0xf9, 0x46, 0xbc, 0x44, 0xcf, 0xb7, 0x2f, 0xa1, 0x91, 0x68, 0x25, 0xa7,
	0x1d, 0x7e, 0x8a, 0x98, 0x88, 0x63, 0x8a, 0xba, 0xef, 0xed, 0x90, 0x7b, 0xc0, 0x91, 0x79,
	0x72, 0x41, 0xf3, 0x15, 0x8e, 0xc7, 0x12, 0x5c, 0xdd, 0xf9, 0x20, 0x92, 0x2d, 0x7c, 0x4e,
	0x01, 0x67, 0xce, 0x97, 0x61, 0xf4, 0xff, 0x64, 0x4a, 0xf0, 0x1a, 0xf7, 0x14, 0xf9, 0x71,
	0x97, 0xc6, 0x07, 0x91, 0xe9, 0xbd, 0xf0, 0xa0, 0x3c, 0xc3, 0x7b, 0x91, 0xb0, 0x36, 0x10,
	0x3a, 0xc9, 0x65, 0x97, 0x17, 0x02, 0x03, 0x01, 0x00, 0x01};
