/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TransactionalValidationListener
extends MetaStorePreEventListener {
    public static final Logger LOG = LoggerFactory.getLogger(TransactionalValidationListener.class);
    public static final Pattern COPY_N_PATTERN = Pattern.compile("[0-9]+_[0-9]+_copy_[0-9]+");

    TransactionalValidationListener(Configuration conf) {
        super(conf);
    }

    @Override
    public void onEvent(PreEventContext context) throws MetaException, NoSuchObjectException, InvalidOperationException {
        switch (context.getEventType()) {
            case CREATE_TABLE: {
                this.handle((PreCreateTableEvent)context);
                break;
            }
            case ALTER_TABLE: {
                this.handle((PreAlterTableEvent)context);
                break;
            }
        }
    }

    private void handle(PreAlterTableEvent context) throws MetaException {
        this.handleAlterTableTransactionalProp(context);
    }

    private void handle(PreCreateTableEvent context) throws MetaException {
        this.handleCreateTableTransactionalProp(context);
    }

    private void handleAlterTableTransactionalProp(PreAlterTableEvent context) throws MetaException {
        Table newTable = context.getNewTable();
        Map<String, String> parameters = newTable.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        HashSet<String> keys = new HashSet<String>(parameters.keySet());
        String transactionalValue = null;
        boolean transactionalValuePresent = false;
        for (String key : keys) {
            if (!"transactional".equalsIgnoreCase(key)) continue;
            transactionalValuePresent = true;
            transactionalValue = parameters.get(key);
            parameters.remove(key);
        }
        if (transactionalValuePresent) {
            parameters.put("transactional", transactionalValue);
        }
        Table oldTable = context.getOldTable();
        String oldTransactionalValue = null;
        for (String key : oldTable.getParameters().keySet()) {
            if (!"transactional".equalsIgnoreCase(key)) continue;
            oldTransactionalValue = oldTable.getParameters().get(key);
        }
        if ("true".equalsIgnoreCase(transactionalValue) && !"true".equalsIgnoreCase(oldTransactionalValue)) {
            if (!this.conformToAcid(newTable)) {
                throw new MetaException("The table must be bucketed and stored using an ACID compliant format (such as ORC)");
            }
            if (newTable.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
                throw new MetaException(newTable.getDbName() + "." + newTable.getTableName() + " cannot be declared transactional because it's an external table");
            }
            if (this.containsCopyNFiles(context.getHandler(), newTable)) {
                throw new MetaException(newTable.getDbName() + "." + newTable.getTableName() + " cannot be declared transactional because it has _COPY_N files.");
            }
            return;
        }
        if (oldTransactionalValue == null ? transactionalValue == null : oldTransactionalValue.equalsIgnoreCase(transactionalValue)) {
            return;
        }
        throw new MetaException("TBLPROPERTIES with 'transactional'='true' cannot be unset");
    }

    private void handleCreateTableTransactionalProp(PreCreateTableEvent context) throws MetaException {
        Table newTable = context.getTable();
        Map<String, String> parameters = newTable.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        String transactionalValue = null;
        boolean transactionalPropFound = false;
        HashSet<String> keys = new HashSet<String>(parameters.keySet());
        for (String key : keys) {
            if (!"transactional".equalsIgnoreCase(key)) continue;
            transactionalPropFound = true;
            transactionalValue = parameters.get(key);
            parameters.remove(key);
        }
        if (!transactionalPropFound) {
            return;
        }
        if ("false".equalsIgnoreCase(transactionalValue)) {
            LOG.info("'transactional'='false' is no longer a valid property and will be ignored");
            return;
        }
        if ("true".equalsIgnoreCase(transactionalValue)) {
            if (!this.conformToAcid(newTable)) {
                throw new MetaException("The table must be bucketed and stored using an ACID compliant format (such as ORC)");
            }
            if (newTable.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
                throw new MetaException(newTable.getDbName() + "." + newTable.getTableName() + " cannot be declared transactional because it's an external table");
            }
            parameters.put("transactional", Boolean.TRUE.toString());
            return;
        }
        throw new MetaException("'transactional' property of TBLPROPERTIES may only have value 'true'");
    }

    private boolean conformToAcid(Table table) throws MetaException {
        StorageDescriptor sd = table.getSd();
        if (sd.getBucketColsSize() < 1) {
            return false;
        }
        try {
            Class<?> inputFormatClass = Class.forName(sd.getInputFormat());
            Class<?> outputFormatClass = Class.forName(sd.getOutputFormat());
            if (inputFormatClass == null || outputFormatClass == null || !Class.forName("org.apache.hadoop.hive.ql.io.AcidInputFormat").isAssignableFrom(inputFormatClass) || !Class.forName("org.apache.hadoop.hive.ql.io.AcidOutputFormat").isAssignableFrom(outputFormatClass)) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            throw new MetaException("Invalid input/output format for table");
        }
        return true;
    }

    boolean containsCopyNFiles(HiveMetaStore.HMSHandler handler, Table table) throws MetaException {
        Warehouse wh = handler.getWh();
        RawStore ms = handler.getMS();
        try {
            Path tablePath = table.getSd().getLocation() == null || table.getSd().getLocation().isEmpty() ? wh.getDefaultTablePath(ms.getDatabase(table.getDbName()), table.getTableName()) : wh.getDnsPath(new Path(table.getSd().getLocation()));
            FileSystem fs = wh.getFs(tablePath);
            return this.containsCopyNFiles(fs, tablePath);
        }
        catch (IOException e) {
            String errorMessage = "Unable to list files for " + table.getDbName() + "." + table.getTableName();
            LOG.error("IOException during listing copyNFiles: ", e);
            throw new MetaException(errorMessage);
        }
        catch (NoSuchObjectException e) {
            String errorMessage = "Unable to get location for " + table.getDbName() + "." + table.getTableName();
            LOG.error(errorMessage, e);
            throw new MetaException(errorMessage);
        }
    }

    boolean containsCopyNFiles(FileSystem fs, Path rootPath) throws IOException {
        if (!fs.isDirectory(rootPath)) {
            return COPY_N_PATTERN.matcher(rootPath.getName()).matches();
        }
        Stack<FileStatus> stack = new Stack<FileStatus>();
        stack.push(fs.getFileStatus(rootPath));
        while (!stack.isEmpty()) {
            FileStatus dir = (FileStatus)stack.pop();
            for (FileStatus child : fs.listStatus(dir.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                if (child.isDirectory()) {
                    stack.push(child);
                    continue;
                }
                if (!COPY_N_PATTERN.matcher(child.getPath().getName()).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

