/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMSMetricsListener
extends MetaStoreEventListener {
    public static final Logger LOGGER = LoggerFactory.getLogger(HMSMetricsListener.class);
    private Metrics metrics;

    public HMSMetricsListener(Configuration config, Metrics metrics) {
        super(config);
        this.metrics = metrics;
    }

    @Override
    public void onCreateDatabase(CreateDatabaseEvent dbEvent) throws MetaException {
        if (this.metrics != null) {
            try {
                this.metrics.incrementCounter("create_total_count_dbs");
            }
            catch (IOException e) {
                LOGGER.warn("Error updating metadata metrics", e);
            }
        }
    }

    @Override
    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        if (this.metrics != null) {
            try {
                this.metrics.incrementCounter("delete_total_count_dbs");
            }
            catch (IOException e) {
                LOGGER.warn("Error updating metadata metrics", e);
            }
        }
    }

    @Override
    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        if (this.metrics != null) {
            try {
                this.metrics.incrementCounter("create_total_count_tables");
            }
            catch (IOException e) {
                LOGGER.warn("Error updating metadata metrics", e);
            }
        }
    }

    @Override
    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        if (this.metrics != null) {
            try {
                this.metrics.incrementCounter("delete_total_count_tables");
            }
            catch (IOException e) {
                LOGGER.warn("Error updating metadata metrics", e);
            }
        }
    }

    @Override
    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
        if (this.metrics != null) {
            try {
                this.metrics.incrementCounter("delete_total_count_partitions");
            }
            catch (IOException e) {
                LOGGER.warn("Error updating metadata metrics", e);
            }
        }
    }

    @Override
    public void onAddPartition(AddPartitionEvent partitionEvent) throws MetaException {
        if (this.metrics != null) {
            try {
                this.metrics.incrementCounter("create_total_count_partitions");
            }
            catch (IOException e) {
                LOGGER.warn("Error updating metadata metrics", e);
            }
        }
    }
}

