/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;

public class BlobStorageUtils {
    public static boolean isBlobStoragePath(Configuration conf, Path path) {
        return path != null && BlobStorageUtils.isBlobStorageScheme(conf, path.toUri().getScheme());
    }

    public static boolean isBlobStorageFileSystem(Configuration conf, FileSystem fs) {
        return fs != null && BlobStorageUtils.isBlobStorageScheme(conf, fs.getScheme());
    }

    public static boolean isBlobStorageScheme(Configuration conf, String scheme) {
        Collection<String> supportedBlobStoreSchemes = conf.getStringCollection(HiveConf.ConfVars.HIVE_BLOBSTORE_SUPPORTED_SCHEMES.varname);
        return supportedBlobStoreSchemes.contains(scheme);
    }
}

