# Ultralytics DOTA8-Multispectral Dataset

Ultralytics DOTA8-Multispectral is a small, but versatile oriented object detection dataset composed of 8 multispectral images derived from the DOTAv1 set—4 for training and 4 for validation. This dataset is ideal for testing and debugging oriented object detection models in the multispectral domain or for experimenting with new detection techniques.

The original DOTAv1 imagery has been converted to multispectral format with 10 spectral bands using spectral interpolation across the visible light spectrum (450–700nm). Each band captures a specific wavelength, offering richer spectral details than traditional RGB images. With only 8 images, this dataset is lightweight enough for rapid prototyping, pipeline validation, and sanity checks before scaling to larger multispectral datasets.

This dataset is intended for use with Ultralytics YOLO and provides a foundation for developing models capable of handling oriented object detection in multispectral imagery.

- 📄 Docs: https://docs.ultralytics.com  
- 💬 Community: https://community.ultralytics.com  
- 💻 GitHub: https://github.com/ultralytics/ultralytics  
