/**
  ******************************************************************************
  * @file    stm32u5g7xx.h
  * @author  MCD Application Team
  * @brief   CMSIS STM32U5G7xx Device Peripheral Access Layer Header File.
  *
  *          This file contains:
  *           - Data structures and the address mapping for all peripherals
  *           - Peripheral's registers declarations and bits definition
  *           - Macros to access peripheral's registers hardware
  *
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */

#ifndef STM32U5G7xx_H
#define STM32U5G7xx_H

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup ST
  * @{
  */


/** @addtogroup STM32U5G7xx
  * @{
  */


/** @addtogroup Configuration_of_CMSIS
  * @{
  */


/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum
{
/* =======================================  ARM Cortex-M33 Specific Interrupt Numbers  ======================================= */
  Reset_IRQn                = -15,    /*!< -15 Reset Vector, invoked on Power up and warm reset              */
  NonMaskableInt_IRQn       = -14,    /*!< -14 Non maskable Interrupt, cannot be stopped or preempted        */
  HardFault_IRQn            = -13,    /*!< -13 Hard Fault, all classes of Fault                              */
  MemoryManagement_IRQn     = -12,    /*!< -12 Memory Management, MPU mismatch, including Access Violation
                                               and No Match                                                  */
  BusFault_IRQn             = -11,    /*!< -11 Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                               related Fault                                                 */
  UsageFault_IRQn           = -10,    /*!< -10 Usage Fault, i.e. Undef Instruction, Illegal State Transition */
  SecureFault_IRQn          =  -9,    /*!< -9  Secure Fault                                                  */
  SVCall_IRQn               =  -5,    /*!< -5  System Service Call via SVC instruction                       */
  DebugMonitor_IRQn         =  -4,    /*!< -4  Debug Monitor                                                 */
  PendSV_IRQn               =  -2,    /*!< -2  Pendable request for system service                           */
  SysTick_IRQn              =  -1,    /*!< -1  System Tick Timer                                             */

/* ===========================================  STM32U5G7xx Specific Interrupt Numbers  ================================= */
  WWDG_IRQn                 = 0,      /*!< Window WatchDog interrupt                                         */
  PVD_PVM_IRQn              = 1,      /*!< PVD/PVM through EXTI Line detection Interrupt                     */
  RTC_IRQn                  = 2,      /*!< RTC non-secure interrupt                                          */
  RTC_S_IRQn                = 3,      /*!< RTC secure interrupt                                              */
  TAMP_IRQn                 = 4,      /*!< Tamper global interrupt                                           */
  RAMCFG_IRQn               = 5,      /*!< RAMCFG global interrupt                                           */
  FLASH_IRQn                = 6,      /*!< FLASH non-secure global interrupt                                 */
  FLASH_S_IRQn              = 7,      /*!< FLASH secure global interrupt                                     */
  GTZC_IRQn                 = 8,      /*!< Global TrustZone Controller interrupt                             */
  RCC_IRQn                  = 9,      /*!< RCC non secure global interrupt                                   */
  RCC_S_IRQn                = 10,     /*!< RCC secure global interrupt                                       */
  EXTI0_IRQn                = 11,     /*!< EXTI Line0 interrupt                                              */
  EXTI1_IRQn                = 12,     /*!< EXTI Line1 interrupt                                              */
  EXTI2_IRQn                = 13,     /*!< EXTI Line2 interrupt                                              */
  EXTI3_IRQn                = 14,     /*!< EXTI Line3 interrupt                                              */
  EXTI4_IRQn                = 15,     /*!< EXTI Line4 interrupt                                              */
  EXTI5_IRQn                = 16,     /*!< EXTI Line5 interrupt                                              */
  EXTI6_IRQn                = 17,     /*!< EXTI Line6 interrupt                                              */
  EXTI7_IRQn                = 18,     /*!< EXTI Line7 interrupt                                              */
  EXTI8_IRQn                = 19,     /*!< EXTI Line8 interrupt                                              */
  EXTI9_IRQn                = 20,     /*!< EXTI Line9 interrupt                                              */
  EXTI10_IRQn               = 21,     /*!< EXTI Line10 interrupt                                             */
  EXTI11_IRQn               = 22,     /*!< EXTI Line11 interrupt                                             */
  EXTI12_IRQn               = 23,     /*!< EXTI Line12 interrupt                                             */
  EXTI13_IRQn               = 24,     /*!< EXTI Line13 interrupt                                             */
  EXTI14_IRQn               = 25,     /*!< EXTI Line14 interrupt                                             */
  EXTI15_IRQn               = 26,     /*!< EXTI Line15 interrupt                                             */
  IWDG_IRQn                 = 27,     /*!< IWDG global interrupt                                             */
  SAES_IRQn                 = 28,     /*!< Secure AES global interrupt                                       */
  GPDMA1_Channel0_IRQn      = 29,     /*!< GPDMA1 Channel 0 global interrupt                                 */
  GPDMA1_Channel1_IRQn      = 30,     /*!< GPDMA1 Channel 1 global interrupt                                 */
  GPDMA1_Channel2_IRQn      = 31,     /*!< GPDMA1 Channel 2 global interrupt                                 */
  GPDMA1_Channel3_IRQn      = 32,     /*!< GPDMA1 Channel 3 global interrupt                                 */
  GPDMA1_Channel4_IRQn      = 33,     /*!< GPDMA1 Channel 4 global interrupt                                 */
  GPDMA1_Channel5_IRQn      = 34,     /*!< GPDMA1 Channel 5 global interrupt                                 */
  GPDMA1_Channel6_IRQn      = 35,     /*!< GPDMA1 Channel 6 global interrupt                                 */
  GPDMA1_Channel7_IRQn      = 36,     /*!< GPDMA1 Channel 7 global interrupt                                 */
  ADC1_2_IRQn               = 37,     /*!< ADC1_2 global interrupt                                           */
  DAC1_IRQn                 = 38,     /*!< DAC1 global interrupt                                             */
  FDCAN1_IT0_IRQn           = 39,     /*!< FDCAN1 interrupt 0                                                */
  FDCAN1_IT1_IRQn           = 40,     /*!< FDCAN1 interrupt 1                                                */
  TIM1_BRK_IRQn             = 41,     /*!< TIM1 Break interrupt                                              */
  TIM1_UP_IRQn              = 42,     /*!< TIM1 Update interrupt                                             */
  TIM1_TRG_COM_IRQn         = 43,     /*!< TIM1 Trigger and Commutation interrupt                            */
  TIM1_CC_IRQn              = 44,     /*!< TIM1 Capture Compare interrupt                                    */
  TIM2_IRQn                 = 45,     /*!< TIM2 global interrupt                                             */
  TIM3_IRQn                 = 46,     /*!< TIM3 global interrupt                                             */
  TIM4_IRQn                 = 47,     /*!< TIM4 global interrupt                                             */
  TIM5_IRQn                 = 48,     /*!< TIM5 global interrupt                                             */
  TIM6_IRQn                 = 49,     /*!< TIM6 global interrupt                                             */
  TIM7_IRQn                 = 50,     /*!< TIM7 global interrupt                                             */
  TIM8_BRK_IRQn             = 51,     /*!< TIM8 Break interrupt                                              */
  TIM8_UP_IRQn              = 52,     /*!< TIM8 Update interrupt                                             */
  TIM8_TRG_COM_IRQn         = 53,     /*!< TIM8 Trigger and Commutation interrupt                            */
  TIM8_CC_IRQn              = 54,     /*!< TIM8 Capture Compare interrupt                                    */
  I2C1_EV_IRQn              = 55,     /*!< I2C1 Event interrupt                                              */
  I2C1_ER_IRQn              = 56,     /*!< I2C1 Error interrupt                                              */
  I2C2_EV_IRQn              = 57,     /*!< I2C2 Event interrupt                                              */
  I2C2_ER_IRQn              = 58,     /*!< I2C2 Error interrupt                                              */
  SPI1_IRQn                 = 59,     /*!< SPI1 global interrupt                                             */
  SPI2_IRQn                 = 60,     /*!< SPI2 global interrupt                                             */
  USART1_IRQn               = 61,     /*!< USART1 global interrupt                                           */
  USART2_IRQn               = 62,     /*!< USART2 global interrupt                                           */
  USART3_IRQn               = 63,     /*!< USART3 global interrupt                                           */
  UART4_IRQn                = 64,     /*!< UART4 global interrupt                                            */
  UART5_IRQn                = 65,     /*!< UART5 global interrupt                                            */
  LPUART1_IRQn              = 66,     /*!< LPUART1 global interrupt                                          */
  LPTIM1_IRQn               = 67,     /*!< LPTIM1 global interrupt                                           */
  LPTIM2_IRQn               = 68,     /*!< LPTIM2 global interrupt                                           */
  TIM15_IRQn                = 69,     /*!< TIM15 global interrupt                                            */
  TIM16_IRQn                = 70,     /*!< TIM16 global interrupt                                            */
  TIM17_IRQn                = 71,     /*!< TIM17 global interrupt                                            */
  COMP_IRQn                 = 72,     /*!< COMP1 and COMP2 through EXTI Lines interrupts                     */
  OTG_HS_IRQn               = 73,     /*!< USB OTG HS global interrupt                                       */
  CRS_IRQn                  = 74,     /*!< CRS global interrupt                                              */
  FMC_IRQn                  = 75,     /*!< FSMC global interrupt                                             */
  OCTOSPI1_IRQn             = 76,     /*!< OctoSPI1 global interrupt                                         */
  PWR_S3WU_IRQn             = 77,     /*!< PWR wake up from Stop3 interrupt                                  */
  SDMMC1_IRQn               = 78,     /*!< SDMMC1 global interrupt                                           */
  SDMMC2_IRQn               = 79,     /*!< SDMMC2 global interrupt                                           */
  GPDMA1_Channel8_IRQn      = 80,     /*!< GPDMA1 Channel 8 global interrupt                                 */
  GPDMA1_Channel9_IRQn      = 81,     /*!< GPDMA1 Channel 9 global interrupt                                 */
  GPDMA1_Channel10_IRQn     = 82,     /*!< GPDMA1 Channel 10 global interrupt                                */
  GPDMA1_Channel11_IRQn     = 83,     /*!< GPDMA1 Channel 11 global interrupt                                */
  GPDMA1_Channel12_IRQn     = 84,     /*!< GPDMA1 Channel 12 global interrupt                                */
  GPDMA1_Channel13_IRQn     = 85,     /*!< GPDMA1 Channel 13 global interrupt                                */
  GPDMA1_Channel14_IRQn     = 86,     /*!< GPDMA1 Channel 14 global interrupt                                */
  GPDMA1_Channel15_IRQn     = 87,     /*!< GPDMA1 Channel 15 global interrupt                                */
  I2C3_EV_IRQn              = 88,     /*!< I2C3 event interrupt                                              */
  I2C3_ER_IRQn              = 89,     /*!< I2C3 error interrupt                                              */
  SAI1_IRQn                 = 90,     /*!< Serial Audio Interface 1 global interrupt                         */
  SAI2_IRQn                 = 91,     /*!< Serial Audio Interface 2 global interrupt                         */
  TSC_IRQn                  = 92,     /*!< Touch Sense Controller global interrupt                           */
  AES_IRQn                  = 93,     /*!< AES global interrupt                                              */
  RNG_IRQn                  = 94,     /*!< RNG global interrupt                                              */
  FPU_IRQn                  = 95,     /*!< FPU global interrupt                                              */
  HASH_IRQn                 = 96,     /*!< HASH global interrupt                                             */
  PKA_IRQn                  = 97,     /*!< PKA global interrupt                                              */
  LPTIM3_IRQn               = 98,     /*!< LPTIM3 global interrupt                                           */
  SPI3_IRQn                 = 99,     /*!< SPI3 global interrupt                                             */
  I2C4_ER_IRQn              = 100,    /*!< I2C4 Error interrupt                                              */
  I2C4_EV_IRQn              = 101,    /*!< I2C4 Event interrupt                                              */
  MDF1_FLT0_IRQn            = 102,    /*!< MDF1 Filter 0 global interrupt                                    */
  MDF1_FLT1_IRQn            = 103,    /*!< MDF1 Filter 1 global interrupt                                    */
  MDF1_FLT2_IRQn            = 104,    /*!< MDF1 Filter 2 global interrupt                                    */
  MDF1_FLT3_IRQn            = 105,    /*!< MDF1 Filter 3 global interrupt                                    */
  UCPD1_IRQn                = 106,    /*!< UCPD1 global interrupt                                            */
  ICACHE_IRQn               = 107,    /*!< Instruction cache global interrupt                                */
  OTFDEC1_IRQn              = 108,    /*!< OTFDEC1 global interrupt                                          */
  OTFDEC2_IRQn              = 109,    /*!< OTFDEC2 global interrupt                                          */
  LPTIM4_IRQn               = 110,    /*!< LPTIM4 global interrupt                                           */
  DCACHE1_IRQn              = 111,    /*!< Data cache global interrupt                                       */
  ADF1_IRQn                 = 112,    /*!< ADF interrupt                                                     */
  ADC4_IRQn                 = 113,    /*!< ADC4 (12bits) global interrupt                                    */
  LPDMA1_Channel0_IRQn      = 114,    /*!< LPDMA1 SmartRun Channel 0 global interrupt                        */
  LPDMA1_Channel1_IRQn      = 115,    /*!< LPDMA1 SmartRun Channel 1 global interrupt                        */
  LPDMA1_Channel2_IRQn      = 116,    /*!< LPDMA1 SmartRun Channel 2 global interrupt                        */
  LPDMA1_Channel3_IRQn      = 117,    /*!< LPDMA1 SmartRun Channel 3 global interrupt                        */
  DMA2D_IRQn                = 118,    /*!< DMA2D global interrupt                                            */
  DCMI_PSSI_IRQn            = 119,    /*!< DCMI/PSSI global interrupt                                        */
  OCTOSPI2_IRQn             = 120,    /*!< OCTOSPI2 global interrupt                                         */
  MDF1_FLT4_IRQn            = 121,    /*!< MDF1 Filter 4 global interrupt                                    */
  MDF1_FLT5_IRQn            = 122,    /*!< MDF1 Filter 5 global interrupt                                    */
  CORDIC_IRQn               = 123,    /*!< CORDIC global interrupt                                           */
  FMAC_IRQn                 = 124,    /*!< FMAC global interrupt                                             */
  LSECSSD_IRQn              = 125,    /*!< LSECSSD and MSI_PLL_UNLOCK global interrupts                      */
  USART6_IRQn               = 126,    /*!< USART6 global interrupt                                           */
  I2C5_ER_IRQn              = 127,    /*!< I2C5 Error interrupt                                              */
  I2C5_EV_IRQn              = 128,    /*!< I2C5 Event interrupt                                              */
  I2C6_ER_IRQn              = 129,    /*!< I2C6 Error interrupt                                              */
  I2C6_EV_IRQn              = 130,    /*!< I2C6 Error interrupt                                              */
  HSPI1_IRQn                = 131,    /*!< HSPI1 global interrupt                                            */
  GPU2D_IRQn                = 132,    /*!< GPU2D global interrupt                                            */
  GPU2D_ER_IRQn             = 133,    /*!< GPU2D Error interrupt                                             */
  GFXMMU_IRQn               = 134,    /*!< GFXMMU global interrupt                                           */
  LTDC_IRQn                 = 135,    /*!< LCD-TFT global interrupt                                          */
  LTDC_ER_IRQn              = 136,    /*!< LCD-TFT Error interrupt                                           */
  DCACHE2_IRQn              = 138,    /*!< DCACHE2 Data cache global interrupt                               */
  GFXTIM_IRQn               = 139,    /*!< GFXTIM global interrupt                                           */
  JPEG_IRQn                 = 140     /*!< JPEG sync interrupt                                               */
} IRQn_Type;

/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* -------  Start of section using anonymous unions and disabling warnings  ------- */
#if   defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif

/* --------  Configuration of the Cortex-M33 Processor and Core Peripherals  ------ */
#define __CM33_REV                0x0000U   /* Core revision r0p1 */
#define __SAUREGION_PRESENT       1U        /* SAU regions present */
#define __MPU_PRESENT             1U        /* MPU present */
#define __VTOR_PRESENT            1U        /* VTOR present */
#define __NVIC_PRIO_BITS          4U        /* Number of Bits used for Priority Levels */
#define __Vendor_SysTickConfig    0U        /* Set to 1 if different SysTick Config is used */
#define __FPU_PRESENT             1U        /* FPU present */
#define __DSP_PRESENT             1U        /* DSP extension present */

/** @} */ /* End of group Configuration_of_CMSIS */

#include <core_cm33.h>                       /*!< ARM Cortex-M33 processor and core peripherals */
#include "system_stm32u5xx.h"                /*!< STM32U5xx System */


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup STM32U5xx_peripherals
  * @{
  */

/**
  * @brief CRC calculation unit
  */
typedef struct
{
  __IO uint32_t DR;             /*!< CRC Data register,                           Address offset: 0x00 */
  __IO uint32_t IDR;            /*!< CRC Independent data register,               Address offset: 0x04 */
  __IO uint32_t CR;             /*!< CRC Control register,                        Address offset: 0x08 */
       uint32_t RESERVED2;      /*!< Reserved,                                                    0x0C */
  __IO uint32_t INIT;           /*!< Initial CRC value register,                  Address offset: 0x10 */
  __IO uint32_t POL;            /*!< CRC polynomial register,                     Address offset: 0x14 */
       uint32_t RESERVED3[246]; /*!< Reserved,                                                         */
  __IO uint32_t HWCFGR;         /*!< CRC IP HWCFGR register,                     Address offset: 0x3F0 */
  __IO uint32_t VERR;           /*!< CRC IP version register,                    Address offset: 0x3F4 */
  __IO uint32_t PIDR;           /*!< CRC IP type identification register,        Address offset: 0x3F8 */
  __IO uint32_t SIDR;           /*!< CRC IP map Size ID register,                Address offset: 0x3FC */
} CRC_TypeDef;

/**
  * @brief Inter-integrated Circuit Interface
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< I2C Control register 1,            Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< I2C Control register 2,            Address offset: 0x04 */
  __IO uint32_t OAR1;        /*!< I2C Own address 1 register,        Address offset: 0x08 */
  __IO uint32_t OAR2;        /*!< I2C Own address 2 register,        Address offset: 0x0C */
  __IO uint32_t TIMINGR;     /*!< I2C Timing register,               Address offset: 0x10 */
  __IO uint32_t TIMEOUTR;    /*!< I2C Timeout register,              Address offset: 0x14 */
  __IO uint32_t ISR;         /*!< I2C Interrupt and status register, Address offset: 0x18 */
  __IO uint32_t ICR;         /*!< I2C Interrupt clear register,      Address offset: 0x1C */
  __IO uint32_t PECR;        /*!< I2C PEC register,                  Address offset: 0x20 */
  __IO uint32_t RXDR;        /*!< I2C Receive data register,         Address offset: 0x24 */
  __IO uint32_t TXDR;        /*!< I2C Transmit data register,        Address offset: 0x28 */
  __IO uint32_t AUTOCR;
} I2C_TypeDef;

/**
  * @brief DAC
  */
typedef struct
{
  __IO uint32_t CR;       /*!< DAC control register,                                    Address offset: 0x00 */
  __IO uint32_t SWTRIGR;  /*!< DAC software trigger register,                           Address offset: 0x04 */
  __IO uint32_t DHR12R1;  /*!< DAC channel1 12-bit right-aligned data holding register, Address offset: 0x08 */
  __IO uint32_t DHR12L1;  /*!< DAC channel1 12-bit left aligned data holding register,  Address offset: 0x0C */
  __IO uint32_t DHR8R1;   /*!< DAC channel1 8-bit right aligned data holding register,  Address offset: 0x10 */
  __IO uint32_t DHR12R2;  /*!< DAC channel2 12-bit right aligned data holding register, Address offset: 0x14 */
  __IO uint32_t DHR12L2;  /*!< DAC channel2 12-bit left aligned data holding register,  Address offset: 0x18 */
  __IO uint32_t DHR8R2;   /*!< DAC channel2 8-bit right-aligned data holding register,  Address offset: 0x1C */
  __IO uint32_t DHR12RD;  /*!< Dual DAC 12-bit right-aligned data holding register,     Address offset: 0x20 */
  __IO uint32_t DHR12LD;  /*!< DUAL DAC 12-bit left aligned data holding register,      Address offset: 0x24 */
  __IO uint32_t DHR8RD;   /*!< DUAL DAC 8-bit right aligned data holding register,      Address offset: 0x28 */
  __IO uint32_t DOR1;     /*!< DAC channel1 data output register,                       Address offset: 0x2C */
  __IO uint32_t DOR2;     /*!< DAC channel2 data output register,                       Address offset: 0x30 */
  __IO uint32_t SR;       /*!< DAC status register,                                     Address offset: 0x34 */
  __IO uint32_t CCR;      /*!< DAC calibration control register,                        Address offset: 0x38 */
  __IO uint32_t MCR;      /*!< DAC mode control register,                               Address offset: 0x3C */
  __IO uint32_t SHSR1;    /*!< DAC Sample and Hold sample time register 1,              Address offset: 0x40 */
  __IO uint32_t SHSR2;    /*!< DAC Sample and Hold sample time register 2,              Address offset: 0x44 */
  __IO uint32_t SHHR;     /*!< DAC Sample and Hold hold time register,                  Address offset: 0x48 */
  __IO uint32_t SHRR;     /*!< DAC Sample and Hold refresh time register,               Address offset: 0x4C */
  __IO uint32_t RESERVED[1];
  __IO uint32_t AUTOCR;      /*!< DAC Autonomous mode register,                         Address offset: 0x54 */
} DAC_TypeDef;

/**
  * @brief Clock Recovery System
  */
typedef struct
{
__IO uint32_t CR;            /*!< CRS ccontrol register,              Address offset: 0x00 */
__IO uint32_t CFGR;          /*!< CRS configuration register,         Address offset: 0x04 */
__IO uint32_t ISR;           /*!< CRS interrupt and status register,  Address offset: 0x08 */
__IO uint32_t ICR;           /*!< CRS interrupt flag clear register,  Address offset: 0x0C */
} CRS_TypeDef;

/**
  * @brief AES hardware accelerator
  */
typedef struct
{
  __IO uint32_t CR;          /*!< AES control register,                        Address offset: 0x00 */
  __IO uint32_t SR;          /*!< AES status register,                         Address offset: 0x04 */
  __IO uint32_t DINR;        /*!< AES data input register,                     Address offset: 0x08 */
  __IO uint32_t DOUTR;       /*!< AES data output register,                    Address offset: 0x0C */
  __IO uint32_t KEYR0;       /*!< AES key register 0,                          Address offset: 0x10 */
  __IO uint32_t KEYR1;       /*!< AES key register 1,                          Address offset: 0x14 */
  __IO uint32_t KEYR2;       /*!< AES key register 2,                          Address offset: 0x18 */
  __IO uint32_t KEYR3;       /*!< AES key register 3,                          Address offset: 0x1C */
  __IO uint32_t IVR0;        /*!< AES initialization vector register 0,        Address offset: 0x20 */
  __IO uint32_t IVR1;        /*!< AES initialization vector register 1,        Address offset: 0x24 */
  __IO uint32_t IVR2;        /*!< AES initialization vector register 2,        Address offset: 0x28 */
  __IO uint32_t IVR3;        /*!< AES initialization vector register 3,        Address offset: 0x2C */
  __IO uint32_t KEYR4;       /*!< AES key register 4,                          Address offset: 0x30 */
  __IO uint32_t KEYR5;       /*!< AES key register 5,                          Address offset: 0x34 */
  __IO uint32_t KEYR6;       /*!< AES key register 6,                          Address offset: 0x38 */
  __IO uint32_t KEYR7;       /*!< AES key register 7,                          Address offset: 0x3C */
  __IO uint32_t SUSP0R;      /*!< AES Suspend register 0,                      Address offset: 0x40 */
  __IO uint32_t SUSP1R;      /*!< AES Suspend register 1,                      Address offset: 0x44 */
  __IO uint32_t SUSP2R;      /*!< AES Suspend register 2,                      Address offset: 0x48 */
  __IO uint32_t SUSP3R;      /*!< AES Suspend register 3,                      Address offset: 0x4C */
  __IO uint32_t SUSP4R;      /*!< AES Suspend register 4,                      Address offset: 0x50 */
  __IO uint32_t SUSP5R;      /*!< AES Suspend register 5,                      Address offset: 0x54 */
  __IO uint32_t SUSP6R;      /*!< AES Suspend register 6,                      Address offset: 0x58 */
  __IO uint32_t SUSP7R;      /*!< AES Suspend register 7,                      Address offset: 0x5C */
       uint32_t RESERVED1[168];/*!< Reserved,                                   Address offset: 0x60 -- 0x2FC */
  __IO uint32_t IER;          /*!< AES Interrupt Enable Register,              Address offset: 0x300 */
  __IO uint32_t ISR;          /*!< AES Interrupt Status Register,              Address offset: 0x304 */
  __IO uint32_t ICR;          /*!< AES Interrupt Clear Register,               Address offset: 0x308 */
} AES_TypeDef;

/**
  * @brief HASH
  */
typedef struct
{
  __IO uint32_t CR;               /*!< HASH control register,          Address offset: 0x00        */
  __IO uint32_t DIN;              /*!< HASH data input register,       Address offset: 0x04        */
  __IO uint32_t STR;              /*!< HASH start register,            Address offset: 0x08        */
  __IO uint32_t HR[5];            /*!< HASH digest registers,          Address offset: 0x0C-0x1C   */
  __IO uint32_t IMR;              /*!< HASH interrupt enable register, Address offset: 0x20        */
  __IO uint32_t SR;               /*!< HASH status register,           Address offset: 0x24        */
       uint32_t RESERVED[52];     /*!< Reserved, 0x28-0xF4                                         */
  __IO uint32_t CSR[54];          /*!< HASH context swap registers,    Address offset: 0x0F8-0x1CC */
} HASH_TypeDef;

/**
  * @brief HASH_DIGEST
  */
typedef struct
{
  __IO uint32_t HR[8];     /*!< HASH digest registers,          Address offset: 0x310-0x32C */
} HASH_DIGEST_TypeDef;

/**
  * @brief RNG
  */
typedef struct
{
  __IO uint32_t CR;  /*!< RNG control register, Address offset: 0x00 */
  __IO uint32_t SR;  /*!< RNG status register,  Address offset: 0x04 */
  __IO uint32_t DR;  /*!< RNG data register,    Address offset: 0x08 */
  uint32_t RESERVED;
  __IO uint32_t HTCR;  /*!< RNG health test configuration register, Address offset: 0x10 */
} RNG_TypeDef;

/**
  * @brief Debug MCU
  */
typedef struct
{
  __IO uint32_t IDCODE;      /*!< MCU device ID code,                 Address offset: 0x00 */
  __IO uint32_t CR;          /*!< Debug MCU configuration register,   Address offset: 0x04 */
  __IO uint32_t APB1FZR1;    /*!< Debug MCU APB1 freeze register 1,   Address offset: 0x08 */
  __IO uint32_t APB1FZR2;    /*!< Debug MCU APB1 freeze register 2,   Address offset: 0x0C */
  __IO uint32_t APB2FZR;     /*!< Debug MCU APB2 freeze register,     Address offset: 0x10 */
  __IO uint32_t APB3FZR;     /*!< Debug MCU APB3 freeze register,     Address offset: 0x14 */
       uint32_t RESERVED1[2];/*!< Reserved,                                    0x18 - 0x1C */
  __IO uint32_t AHB1FZR;     /*!< Debug MCU AHB1 freeze register,     Address offset: 0x20 */
       uint32_t RESERVED2;   /*!< Reserved,                                           0x24 */
  __IO uint32_t AHB3FZR;     /*!< Debug MCU AHB3 freeze register,     Address offset: 0x28 */
} DBGMCU_TypeDef;

/**
  * @brief DCMI
  */
typedef struct
{
  __IO uint32_t CR;       /*!< DCMI control register 1,                       Address offset: 0x00 */
  __IO uint32_t SR;       /*!< DCMI status register,                          Address offset: 0x04 */
  __IO uint32_t RISR;     /*!< DCMI raw interrupt status register,            Address offset: 0x08 */
  __IO uint32_t IER;      /*!< DCMI interrupt enable register,                Address offset: 0x0C */
  __IO uint32_t MISR;     /*!< DCMI masked interrupt status register,         Address offset: 0x10 */
  __IO uint32_t ICR;      /*!< DCMI interrupt clear register,                 Address offset: 0x14 */
  __IO uint32_t ESCR;     /*!< DCMI embedded synchronization code register,   Address offset: 0x18 */
  __IO uint32_t ESUR;     /*!< DCMI embedded synchronization unmask register, Address offset: 0x1C */
  __IO uint32_t CWSTRTR;  /*!< DCMI crop window start,                        Address offset: 0x20 */
  __IO uint32_t CWSIZER;  /*!< DCMI crop window size,                         Address offset: 0x24 */
  __IO uint32_t DR;       /*!< DCMI data register,                            Address offset: 0x28 */
} DCMI_TypeDef;

/**
  * @brief DMA Controller
  */
typedef struct
{
  __IO uint32_t SECCFGR;     /*!< DMA secure configuration register,               Address offset: 0x00  */
  __IO uint32_t PRIVCFGR;    /*!< DMA privileged configuration register,           Address offset: 0x04  */
  __IO uint32_t RCFGLOCKR;   /*!< DMA lock configuration register,                 Address offset: 0x08  */
  __IO uint32_t MISR;        /*!< DMA non secure masked interrupt status register, Address offset: 0x0C  */
  __IO uint32_t SMISR;       /*!< DMA secure masked interrupt status register,     Address offset: 0x10  */
} DMA_TypeDef;

typedef struct
{
  __IO uint32_t CLBAR;        /*!< DMA channel x linked-list base address register, Address offset: 0x50 + (x * 0x80) */
       uint32_t RESERVED1[2]; /*!< Reserved 1,                                      Address offset: 0x54 -- 0x58      */
  __IO uint32_t CFCR;         /*!< DMA channel x flag clear register,               Address offset: 0x5C + (x * 0x80) */
  __IO uint32_t CSR;          /*!< DMA channel x flag status register,              Address offset: 0x60 + (x * 0x80) */
  __IO uint32_t CCR;          /*!< DMA channel x control register,                  Address offset: 0x64 + (x * 0x80) */
       uint32_t RESERVED2[10];/*!< Reserved 2,                                      Address offset: 0x68 -- 0x8C      */
  __IO uint32_t CTR1;         /*!< DMA channel x transfer register 1,               Address offset: 0x90 + (x * 0x80) */
  __IO uint32_t CTR2;         /*!< DMA channel x transfer register 2,               Address offset: 0x94 + (x * 0x80) */
  __IO uint32_t CBR1;         /*!< DMA channel x block register 1,                  Address offset: 0x98 + (x * 0x80) */
  __IO uint32_t CSAR;         /*!< DMA channel x source address register,           Address offset: 0x9C + (x * 0x80) */
  __IO uint32_t CDAR;         /*!< DMA channel x destination address register,      Address offset: 0xA0 + (x * 0x80) */
  __IO uint32_t CTR3;         /*!< DMA channel x transfer register 3,               Address offset: 0xA4 + (x * 0x80) */
  __IO uint32_t CBR2;         /*!< DMA channel x block register 2,                  Address offset: 0xA8 + (x * 0x80) */
       uint32_t RESERVED3[8]; /*!< Reserved 3,                                      Address offset: 0xAC -- 0xC8      */
  __IO uint32_t CLLR;         /*!< DMA channel x linked-list address register,      Address offset: 0xCC + (x * 0x80) */
} DMA_Channel_TypeDef;

/**
  * @brief DMA2D Controller
  */
typedef struct
{
  __IO uint32_t CR;            /*!< DMA2D Control Register,                         Address offset: 0x00 */
  __IO uint32_t ISR;           /*!< DMA2D Interrupt Status Register,                Address offset: 0x04 */
  __IO uint32_t IFCR;          /*!< DMA2D Interrupt Flag Clear Register,            Address offset: 0x08 */
  __IO uint32_t FGMAR;         /*!< DMA2D Foreground Memory Address Register,       Address offset: 0x0C */
  __IO uint32_t FGOR;          /*!< DMA2D Foreground Offset Register,               Address offset: 0x10 */
  __IO uint32_t BGMAR;         /*!< DMA2D Background Memory Address Register,       Address offset: 0x14 */
  __IO uint32_t BGOR;          /*!< DMA2D Background Offset Register,               Address offset: 0x18 */
  __IO uint32_t FGPFCCR;       /*!< DMA2D Foreground PFC Control Register,          Address offset: 0x1C */
  __IO uint32_t FGCOLR;        /*!< DMA2D Foreground Color Register,                Address offset: 0x20 */
  __IO uint32_t BGPFCCR;       /*!< DMA2D Background PFC Control Register,          Address offset: 0x24 */
  __IO uint32_t BGCOLR;        /*!< DMA2D Background Color Register,                Address offset: 0x28 */
  __IO uint32_t FGCMAR;        /*!< DMA2D Foreground CLUT Memory Address Register,  Address offset: 0x2C */
  __IO uint32_t BGCMAR;        /*!< DMA2D Background CLUT Memory Address Register,  Address offset: 0x30 */
  __IO uint32_t OPFCCR;        /*!< DMA2D Output PFC Control Register,              Address offset: 0x34 */
  __IO uint32_t OCOLR;         /*!< DMA2D Output Color Register,                    Address offset: 0x38 */
  __IO uint32_t OMAR;          /*!< DMA2D Output Memory Address Register,           Address offset: 0x3C */
  __IO uint32_t OOR;           /*!< DMA2D Output Offset Register,                   Address offset: 0x40 */
  __IO uint32_t NLR;           /*!< DMA2D Number of Line Register,                  Address offset: 0x44 */
  __IO uint32_t LWR;           /*!< DMA2D Line Watermark Register,                  Address offset: 0x48 */
  __IO uint32_t AMTCR;         /*!< DMA2D AHB Master Timer Configuration Register,  Address offset: 0x4C */
  uint32_t      RESERVED[236]; /*!< Reserved, 0x50-0x3FC */
  __IO uint32_t FGCLUT[256];   /*!< DMA2D Foreground CLUT,                          Address offset:400-7FC */
  __IO uint32_t BGCLUT[256];   /*!< DMA2D Background CLUT,                          Address offset:800-BFC */
} DMA2D_TypeDef;

/**
  * @brief Asynch Interrupt/Event Controller (EXTI)
  */
typedef struct
{
  __IO uint32_t RTSR1;          /*!< EXTI Rising Trigger Selection Register 1,        Address offset:   0x00 */
  __IO uint32_t FTSR1;          /*!< EXTI Falling Trigger Selection Register 1,       Address offset:   0x04 */
  __IO uint32_t SWIER1;         /*!< EXTI Software Interrupt event Register 1,        Address offset:   0x08 */
  __IO uint32_t RPR1;           /*!< EXTI Rising Pending Register 1,                  Address offset:   0x0C */
  __IO uint32_t FPR1;           /*!< EXTI Falling Pending Register 1,                 Address offset:   0x10 */
  __IO uint32_t SECCFGR1;       /*!< EXTI Security Configuration Register 1,          Address offset:   0x14 */
  __IO uint32_t PRIVCFGR1;      /*!< EXTI Privilege Configuration Register 1,         Address offset:   0x18 */
       uint32_t RESERVED1[17];  /*!< Reserved 1,                                                0x1C -- 0x5C */
  __IO uint32_t EXTICR[4];      /*!< EXIT External Interrupt Configuration Register,            0x60 -- 0x6C */
  __IO uint32_t LOCKR;          /*!< EXTI Lock Register,                              Address offset:   0x70 */
       uint32_t RESERVED2[3];   /*!< Reserved 2,                                                0x74 -- 0x7C */
  __IO uint32_t IMR1;           /*!< EXTI Interrupt Mask Register 1,                  Address offset:   0x80 */
  __IO uint32_t EMR1;           /*!< EXTI Event Mask Register 1,                      Address offset:   0x84 */
} EXTI_TypeDef;

/**
  * @brief FLASH Registers
  */
typedef struct
{
  __IO uint32_t ACR;              /*!< FLASH access control register,                  Address offset: 0x00 */
       uint32_t RESERVED1;        /*!< Reserved1,                                      Address offset: 0x04 */
  __IO uint32_t NSKEYR;           /*!< FLASH non-secure key register,                  Address offset: 0x08 */
  __IO uint32_t SECKEYR;          /*!< FLASH secure key register,                      Address offset: 0x0C */
  __IO uint32_t OPTKEYR;          /*!< FLASH option key register,                      Address offset: 0x10 */
  __IO uint32_t RESERVED2;        /*!< Reserved2,                                      Address offset: 0x14 */
  __IO uint32_t PDKEY1R;          /*!< FLASH Bank 1 power-down key register,           Address offset: 0x18 */
  __IO uint32_t PDKEY2R;          /*!< FLASH Bank 2 power-down key register,           Address offset: 0x1C */
  __IO uint32_t NSSR;             /*!< FLASH non-secure status register,               Address offset: 0x20 */
  __IO uint32_t SECSR;            /*!< FLASH secure status register,                   Address offset: 0x24 */
  __IO uint32_t NSCR;             /*!< FLASH non-secure control register,              Address offset: 0x28 */
  __IO uint32_t SECCR;            /*!< FLASH secure control register,                  Address offset: 0x2C */
  __IO uint32_t ECCR;             /*!< FLASH ECC register,                             Address offset: 0x30 */
  __IO uint32_t OPSR;             /*!< FLASH OPSR register,                            Address offset: 0x34 */
       uint32_t RESERVED3[2];     /*!< Reserved3,                                      Address offset: 0x38-0x3C */
  __IO uint32_t OPTR;             /*!< FLASH option control register,                  Address offset: 0x40 */
  __IO uint32_t NSBOOTADD0R;      /*!< FLASH non-secure boot address 0 register,       Address offset: 0x44 */
  __IO uint32_t NSBOOTADD1R;      /*!< FLASH non-secure boot address 1 register,       Address offset: 0x48 */
  __IO uint32_t SECBOOTADD0R;     /*!< FLASH secure boot address 0 register,           Address offset: 0x4C */
  __IO uint32_t SECWM1R1;         /*!< FLASH secure watermark1 register 1,             Address offset: 0x50 */
  __IO uint32_t SECWM1R2;         /*!< FLASH secure watermark1 register 2,             Address offset: 0x54 */
  __IO uint32_t WRP1AR;           /*!< FLASH WRP1 area A address register,             Address offset: 0x58 */
  __IO uint32_t WRP1BR;           /*!< FLASH WRP1 area B address register,             Address offset: 0x5C */
  __IO uint32_t SECWM2R1;         /*!< FLASH secure watermark2 register 1,             Address offset: 0x60 */
  __IO uint32_t SECWM2R2;         /*!< FLASH secure watermark2 register 2,             Address offset: 0x64 */
  __IO uint32_t WRP2AR;           /*!< FLASH WRP2 area A address register,             Address offset: 0x68 */
  __IO uint32_t WRP2BR;           /*!< FLASH WRP2 area B address register,             Address offset: 0x6C */
  __IO uint32_t OEM1KEYR1;        /*!< FLASH OEM1 key register 1,                      Address offset: 0x70 */
  __IO uint32_t OEM1KEYR2;        /*!< FLASH OEM1 key register 2,                      Address offset: 0x74 */
  __IO uint32_t OEM2KEYR1;        /*!< FLASH OEM2 key register 1,                      Address offset: 0x78 */
  __IO uint32_t OEM2KEYR2;        /*!< FLASH OEM2 key register 2,                      Address offset: 0x7C */
  __IO uint32_t SECBB1R1;         /*!< FLASH secure block-based bank 1 register 1,     Address offset: 0x80 */
  __IO uint32_t SECBB1R2;         /*!< FLASH secure block-based bank 1 register 2,     Address offset: 0x84 */
  __IO uint32_t SECBB1R3;         /*!< FLASH secure block-based bank 1 register 3,     Address offset: 0x88 */
  __IO uint32_t SECBB1R4;         /*!< FLASH secure block-based bank 1 register 4,     Address offset: 0x8C */
  __IO uint32_t SECBB1R5;         /*!< FLASH secure block-based bank 1 register 5,     Address offset: 0x90 */
  __IO uint32_t SECBB1R6;         /*!< FLASH secure block-based bank 1 register 6,     Address offset: 0x94 */
  __IO uint32_t SECBB1R7;         /*!< FLASH secure block-based bank 1 register 7,     Address offset: 0x98 */
  __IO uint32_t SECBB1R8;         /*!< FLASH secure block-based bank 1 register 8,     Address offset: 0x9C */
  __IO uint32_t SECBB2R1;         /*!< FLASH secure block-based bank 2 register 1,     Address offset: 0xA0 */
  __IO uint32_t SECBB2R2;         /*!< FLASH secure block-based bank 2 register 2,     Address offset: 0xA4 */
  __IO uint32_t SECBB2R3;         /*!< FLASH secure block-based bank 2 register 3,     Address offset: 0xA8 */
  __IO uint32_t SECBB2R4;         /*!< FLASH secure block-based bank 2 register 4,     Address offset: 0xAC */
  __IO uint32_t SECBB2R5;         /*!< FLASH secure block-based bank 2 register 5,     Address offset: 0xB0 */
  __IO uint32_t SECBB2R6;         /*!< FLASH secure block-based bank 2 register 6,     Address offset: 0xB4 */
  __IO uint32_t SECBB2R7;         /*!< FLASH secure block-based bank 2 register 7,     Address offset: 0xB8 */
  __IO uint32_t SECBB2R8;         /*!< FLASH secure block-based bank 2 register 8,     Address offset: 0xBC */
  __IO uint32_t SECHDPCR;         /*!< FLASH secure HDP control register,              Address offset: 0xC0 */
  __IO uint32_t PRIVCFGR;         /*!< FLASH privilege configuration register,         Address offset: 0xC4 */
       uint32_t RESERVED6[2];     /*!< Reserved6,                                      Address offset: 0xC8-0xCC */
  __IO uint32_t PRIVBB1R1;        /*!< FLASH privilege block-based bank 1 register 1,  Address offset: 0xD0 */
  __IO uint32_t PRIVBB1R2;        /*!< FLASH privilege block-based bank 1 register 2,  Address offset: 0xD4 */
  __IO uint32_t PRIVBB1R3;        /*!< FLASH privilege block-based bank 1 register 3,  Address offset: 0xD8 */
  __IO uint32_t PRIVBB1R4;        /*!< FLASH privilege block-based bank 1 register 4,  Address offset: 0xDC */
  __IO uint32_t PRIVBB1R5;        /*!< FLASH privilege block-based bank 1 register 5,  Address offset: 0xE0 */
  __IO uint32_t PRIVBB1R6;        /*!< FLASH privilege block-based bank 1 register 6,  Address offset: 0xE4 */
  __IO uint32_t PRIVBB1R7;        /*!< FLASH privilege block-based bank 1 register 7,  Address offset: 0xE8 */
  __IO uint32_t PRIVBB1R8;        /*!< FLASH privilege block-based bank 1 register 8,  Address offset: 0xEC */
  __IO uint32_t PRIVBB2R1;        /*!< FLASH privilege block-based bank 2 register 1,  Address offset: 0xF0 */
  __IO uint32_t PRIVBB2R2;        /*!< FLASH privilege block-based bank 2 register 2,  Address offset: 0xF4 */
  __IO uint32_t PRIVBB2R3;        /*!< FLASH privilege block-based bank 2 register 3,  Address offset: 0xF8 */
  __IO uint32_t PRIVBB2R4;        /*!< FLASH privilege block-based bank 2 register 4,  Address offset: 0xFC */
  __IO uint32_t PRIVBB2R5;        /*!< FLASH privilege block-based bank 2 register 5,  Address offset: 0x100 */
  __IO uint32_t PRIVBB2R6;        /*!< FLASH privilege block-based bank 2 register 6,  Address offset: 0x104 */
  __IO uint32_t PRIVBB2R7;        /*!< FLASH privilege block-based bank 2 register 7,  Address offset: 0x108 */
  __IO uint32_t PRIVBB2R8;        /*!< FLASH privilege block-based bank 2 register 8,  Address offset: 0x10C */
} FLASH_TypeDef;

/**
  * @brief FMAC
  */
typedef struct
{
  __IO uint32_t X1BUFCFG;        /*!< FMAC X1 Buffer Configuration register, Address offset: 0x00          */
  __IO uint32_t X2BUFCFG;        /*!< FMAC X2 Buffer Configuration register, Address offset: 0x04          */
  __IO uint32_t YBUFCFG;         /*!< FMAC Y Buffer Configuration register,  Address offset: 0x08          */
  __IO uint32_t PARAM;           /*!< FMAC Parameter register,               Address offset: 0x0C          */
  __IO uint32_t CR;              /*!< FMAC Control register,                 Address offset: 0x10          */
  __IO uint32_t SR;              /*!< FMAC Status register,                  Address offset: 0x14          */
  __IO uint32_t WDATA;           /*!< FMAC Write Data register,              Address offset: 0x18          */
  __IO uint32_t RDATA;           /*!< FMAC Read Data register,               Address offset: 0x1C          */
} FMAC_TypeDef;

/**
  * @brief GFXMMU registers
  */
typedef struct
{
  __IO uint32_t CR;              /*!< GFXMMU configuration register,                     Address offset: 0x00 */
  __IO uint32_t SR;              /*!< GFXMMU status register,                            Address offset: 0x04 */
  __IO uint32_t FCR;             /*!< GFXMMU flag clear register,                        Address offset: 0x08 */
  __IO uint32_t CCR;             /*!< GFXMMU Cache Control Register,                     Address offset: 0x0C */
  __IO uint32_t DVR;             /*!< GFXMMU default value register,                     Address offset: 0x10 */
       uint32_t RESERVED1[3];    /*!< Reserved1,                                         Address offset: 0x14 to 0x1C */
  __IO uint32_t B0CR;            /*!< GFXMMU buffer 0 configuration register,            Address offset: 0x20 */
  __IO uint32_t B1CR;            /*!< GFXMMU buffer 1 configuration register,            Address offset: 0x24 */
  __IO uint32_t B2CR;            /*!< GFXMMU buffer 2 configuration register,            Address offset: 0x28 */
  __IO uint32_t B3CR;            /*!< GFXMMU buffer 3 configuration register,            Address offset: 0x2C */
       uint32_t RESERVED2[1008]; /*!< Reserved2,                                         Address offset: 0x30 to 0xFEC */
  __IO uint32_t HWCFGR;          /*!< GFXMMU hardware configuration register,            Address offset: 0xFF0 */
  __IO uint32_t VERR;            /*!< GFXMMU version register,                           Address offset: 0xFF4 */
  __IO uint32_t IPIDR;           /*!< GFXMMU identification register,                    Address offset: 0xFF8 */
  __IO uint32_t SIDR;            /*!< GFXMMU size identification register,               Address offset: 0xFFC */
  __IO uint32_t LUT[2048];       /*!< GFXMMU LUT registers,                              Address offset: 0x1000 to 0x2FFC
                                      For LUT line i, LUTiL = LUT[2*i] and LUTiH = LUT[(2*i)+1] */
} GFXMMU_TypeDef;

/**
  * @brief General Purpose I/O
  */
typedef struct
{
  __IO uint32_t MODER;       /*!< GPIO port mode register,               Address offset: 0x00      */
  __IO uint32_t OTYPER;      /*!< GPIO port output type register,        Address offset: 0x04      */
  __IO uint32_t OSPEEDR;     /*!< GPIO port output speed register,       Address offset: 0x08      */
  __IO uint32_t PUPDR;       /*!< GPIO port pull-up/pull-down register,  Address offset: 0x0C      */
  __IO uint32_t IDR;         /*!< GPIO port input data register,         Address offset: 0x10      */
  __IO uint32_t ODR;         /*!< GPIO port output data register,        Address offset: 0x14      */
  __IO uint32_t BSRR;        /*!< GPIO port bit set/reset  register,     Address offset: 0x18      */
  __IO uint32_t LCKR;        /*!< GPIO port configuration lock register, Address offset: 0x1C      */
  __IO uint32_t AFR[2];      /*!< GPIO alternate function registers,     Address offset: 0x20-0x24 */
  __IO uint32_t BRR;         /*!< GPIO Bit Reset register,               Address offset: 0x28      */
  __IO uint32_t HSLVR;       /*!< GPIO high-speed low voltage register,  Address offset: 0x2C      */
  __IO uint32_t SECCFGR;     /*!< GPIO secure configuration register,    Address offset: 0x30      */
} GPIO_TypeDef;

/**
  * @brief Global TrustZone Controller
  */
typedef struct
{
  __IO uint32_t CR;             /*!< TZSC control register,                                                Address offset: 0x00      */
       uint32_t RESERVED1[3];   /*!< Reserved1,                                                            Address offset: 0x04-0x0C */
  __IO uint32_t SECCFGR1;       /*!< TZSC secure configuration register 1,                                 Address offset: 0x10      */
  __IO uint32_t SECCFGR2;       /*!< TZSC secure configuration register 2,                                 Address offset: 0x14      */
  __IO uint32_t SECCFGR3;       /*!< TZSC secure configuration register 3,                                 Address offset: 0x18      */
       uint32_t RESERVED2;      /*!< Reserved2,                                                            Address offset: 0x1C      */
  __IO uint32_t PRIVCFGR1;      /*!< TZSC privilege configuration register 1,                              Address offset: 0x20      */
  __IO uint32_t PRIVCFGR2;      /*!< TZSC privilege configuration register 2,                              Address offset: 0x24      */
  __IO uint32_t PRIVCFGR3;      /*!< TZSC privilege configuration register 3,                              Address offset: 0x28      */
       uint32_t RESERVED3[5];   /*!< Reserved3,                                                            Address offset: 0x2C-0x3C */
  __IO uint32_t MPCWM1ACFGR;    /*!< TZSC memory 1 sub-region A watermark configuration register,          Address offset: 0x40      */
  __IO uint32_t MPCWM1AR;       /*!< TZSC memory 1 sub-region A watermark register,                        Address offset: 0x44      */
  __IO uint32_t MPCWM1BCFGR;    /*!< TZSC memory 1 sub-region B watermark configuration register,          Address offset: 0x48      */
  __IO uint32_t MPCWM1BR;       /*!< TZSC memory 1 sub-region B watermark register,                        Address offset: 0x4C      */
  __IO uint32_t MPCWM2ACFGR;    /*!< TZSC memory 2 sub-region A watermark configuration register,          Address offset: 0x50      */
  __IO uint32_t MPCWM2AR;       /*!< TZSC memory 2 sub-region A watermark register,                        Address offset: 0x54      */
  __IO uint32_t MPCWM2BCFGR;    /*!< TZSC memory 2 sub-region B watermark configuration register,          Address offset: 0x58      */
  __IO uint32_t MPCWM2BR;       /*!< TZSC memory 2 sub-region B watermark register,                        Address offset: 0x5C      */
  __IO uint32_t MPCWM3ACFGR;    /*!< TZSC memory 3 sub-region A watermark configuration register,          Address offset: 0x60      */
  __IO uint32_t MPCWM3AR;       /*!< TZSC memory 3 sub-region A watermark register,                        Address offset: 0x64      */
       uint32_t RESERVED4[2];   /*!< Reserved4,                                                            Address offset: 0x68-0x6C */
  __IO uint32_t MPCWM4ACFGR;    /*!< TZSC memory 4 sub-region A watermark configuration register,          Address offset: 0x70      */
  __IO uint32_t MPCWM4AR;       /*!< TZSC memory 4 sub-region A watermark register,                        Address offset: 0x74      */
       uint32_t RESERVED5[2];   /*!< Reserved5,                                                            Address offset: 0x78-0x7C */
  __IO uint32_t MPCWM5ACFGR;    /*!< TZSC memory 5 sub-region A watermark configuration register,          Address offset: 0x80      */
  __IO uint32_t MPCWM5AR;       /*!< TZSC memory 5 sub-region A watermark register,                        Address offset: 0x84      */
  __IO uint32_t MPCWM5BCFGR;    /*!< TZSC memory 5 sub-region B watermark configuration register,          Address offset: 0x88      */
  __IO uint32_t MPCWM5BR;       /*!< TZSC memory 5 sub-region B watermark register,                        Address offset: 0x8C      */
  __IO uint32_t MPCWM6ACFGR;    /*!< TZSC memory 6 sub-region A watermark configuration register,          Address offset: 0x90      */
  __IO uint32_t MPCWM6AR;       /*!< TZSC memory 6 sub-region A watermark register,                        Address offset: 0x94      */
  __IO uint32_t MPCWM6BCFGR;    /*!< TZSC memory 6 sub-region B watermark configuration register,          Address offset: 0x98      */
  __IO uint32_t MPCWM6BR;       /*!< TZSC memory 6 sub-region B watermark register,                        Address offset: 0x9C      */
} GTZC_TZSC_TypeDef;

typedef struct
{
  __IO uint32_t CR;             /*!< MPCBBx control register,                  Address offset: 0x00        */
  uint32_t RESERVED1[3];        /*!< Reserved1,                                Address offset: 0x04-0x0C   */
  __IO uint32_t CFGLOCKR1;      /*!< MPCBBx Configuration lock register 1,     Address offset: 0x10        */
  __IO uint32_t CFGLOCKR2;      /*!< MPCBBx Configuration lock register 2,     Address offset: 0x14        */
  uint32_t RESERVED2[58];       /*!< Reserved2,                                Address offset: 0x18-0xFC   */
  __IO uint32_t SECCFGR[52];    /*!< MPCBBx security configuration registers,  Address offset: 0x100-0x1CC */
  uint32_t RESERVED3[12];       /*!< Reserved3,                                Address offset: 0x1D0-0x1FC */
  __IO uint32_t PRIVCFGR[52];   /*!< MPCBBx privilege configuration registers, Address offset: 0x200-0x2CC */
} GTZC_MPCBB_TypeDef;

typedef struct
{
  __IO uint32_t IER1;           /*!< TZIC interrupt enable register 1, Address offset: 0x00 */
  __IO uint32_t IER2;           /*!< TZIC interrupt enable register 2, Address offset: 0x04 */
  __IO uint32_t IER3;           /*!< TZIC interrupt enable register 3, Address offset: 0x08 */
  __IO uint32_t IER4;           /*!< TZIC interrupt enable register 4, Address offset: 0x0C */
  __IO uint32_t SR1;            /*!< TZIC status register 1,           Address offset: 0x10 */
  __IO uint32_t SR2;            /*!< TZIC status register 2,           Address offset: 0x14 */
  __IO uint32_t SR3;            /*!< TZIC status register 3,           Address offset: 0x18 */
  __IO uint32_t SR4;            /*!< TZIC status register 4,           Address offset: 0x1C */
  __IO uint32_t FCR1;           /*!< TZIC flag clear register 1,       Address offset: 0x20 */
  __IO uint32_t FCR2;           /*!< TZIC flag clear register 2,       Address offset: 0x24 */
  __IO uint32_t FCR3;           /*!< TZIC flag clear register 3,       Address offset: 0x28 */
  __IO uint32_t FCR4;           /*!< TZIC flag clear register 3,       Address offset: 0x2C */
} GTZC_TZIC_TypeDef;

/**
  * @brief GFXTIM
  */
typedef struct
{
  __IO uint32_t CR;            /*!< GFXTIM configuration register,                    Address offset: 0x00 */
  __IO uint32_t CGCR;          /*!< GFXTIM clock generator configuration register,    Address offset: 0x04 */
  __IO uint32_t TCR;           /*!< GFXTIM timers configuration register,             Address offset: 0x08 */
  __IO uint32_t TDR;           /*!< GFXTIM timers disable register,                   Address offset: 0x0C */
  __IO uint32_t EVCR;          /*!< GFXTIM events control register,                   Address offset: 0x10 */
  __IO uint32_t EVSR;          /*!< GFXTIM events selection register,                 Address offset: 0x14 */
  uint32_t RESERVED1[2];       /*!< Reserved,                                         Address offset: 0x18-0x1C */
  __IO uint32_t WDGTCR;        /*!< GFXTIM watchdog timer configuration register,     Address offset: 0x20 */
  uint32_t RESERVED2[3];       /*!< Reserved,                                         Address offset: 0x24-0x2C */
  __IO uint32_t ISR;           /*!< GFXTIM interrupt status register,                 Address offset: 0x30 */
  __IO uint32_t ICR;           /*!< GFXTIM interrupt clear register,                  Address offset: 0x34 */
  __IO uint32_t IER;           /*!< GFXTIM interrupt enable register,                 Address offset: 0x38 */
  __IO uint32_t TSR;           /*!< GFXTIM timers status register,                    Address offset: 0x3C */
  __IO uint32_t LCCRR;         /*!< GFXTIM line clock counter reload register,        Address offset: 0x40 */
  __IO uint32_t FCCRR;         /*!< GFXTIM frame clock counter reload register,       Address offset: 0x44 */
  uint32_t RESERVED3[2];       /*!< Reserved,                                         Address offset: 0x48-0x4C */
  __IO uint32_t ATR;           /*!< GFXTIM absolute time register,                    Address offset: 0x50 */
  __IO uint32_t AFCR;          /*!< GFXTIM absolute frame counter register,           Address offset: 0x54 */
  __IO uint32_t ALCR;          /*!< GFXTIM absolute line counter register,            Address offset: 0x58 */
  uint32_t RESERVED4[1];       /*!< Reserved,                                         Address offset: 0x5C */
  __IO uint32_t AFCC1R;        /*!< GFXTIM absolute frame counter compare 1 register, Address offset: 0x60 */
  uint32_t RESERVED5[3];       /*!< Reserved,                                         Address offset: 0x64-0X6C */
  __IO uint32_t ALCC1R;        /*!< GFXTIM absolute line counter compare 1 register,  Address offset: 0x70 */
  __IO uint32_t ALCC2R;        /*!< GFXTIM absolute line counter compare 2 register,  Address offset: 0x74 */
  uint32_t RESERVED6[2];       /*!< Reserved,                                         Address offset: 0x78-0X7C */
  __IO uint32_t RFC1R;         /*!< GFXTIM relative frame counter 1 register,         Address offset: 0x80 */
  __IO uint32_t RFC1RR;        /*!< GFXTIM relative frame counter 1 reload register,  Address offset: 0x84 */
  __IO uint32_t RFC2R;         /*!< GFXTIM relative frame counter 2 register,         Address offset: 0x88 */
  __IO uint32_t RFC2RR;        /*!< GFXTIM relative frame counter 2 reload register,  Address offset: 0x8C */
  uint32_t RESERVED7[4];       /*!< Reserved,                                         Address offset: 0x90-0X9C */
  __IO uint32_t WDGCR;         /*!< GFXTIM watchdog counter register,                 Address offset: 0xA0 */
  __IO uint32_t WDGRR;         /*!< GFXTIM watchdog reload register,                  Address offset: 0xA4 */
  __IO uint32_t WDGPAR;        /*!< GFXTIM watchdog pre-alarm register,               Address offset: 0xA8 */
  uint32_t RESERVED8[209];     /*!< Reserved,                                         Address offset: 0xAC-0X3EC */
  __IO uint32_t HWCFGR;        /*!< GFXTIM HW configuration register,                 Address offset: 0x3F0 */
  __IO uint32_t VERR;          /*!< GFXTIM version register,                          Address offset: 0x3F4 */
  __IO uint32_t IPIDR;         /*!< GFXTIM identification register,                   Address offset: 0x3F8 */
  __IO uint32_t SIDR;          /*!< GFXTIM size identification register,              Address offset: 0x3FC */
} GFXTIM_TypeDef;

/**
  * @brief JPEG Codec
  */
typedef struct
{
  __IO uint32_t CONFR0;          /*!< JPEG Codec Control Register (JPEG_CONFR0),        Address offset: 00h       */
  __IO uint32_t CONFR1;          /*!< JPEG Codec Control Register (JPEG_CONFR1),        Address offset: 04h       */
  __IO uint32_t CONFR2;          /*!< JPEG Codec Control Register (JPEG_CONFR2),        Address offset: 08h       */
  __IO uint32_t CONFR3;          /*!< JPEG Codec Control Register (JPEG_CONFR3),        Address offset: 0Ch       */
  __IO uint32_t CONFR4;          /*!< JPEG Codec Control Register (JPEG_CONFR4),        Address offset: 10h       */
  __IO uint32_t CONFR5;          /*!< JPEG Codec Control Register (JPEG_CONFR5),        Address offset: 14h       */
  __IO uint32_t CONFR6;          /*!< JPEG Codec Control Register (JPEG_CONFR6),        Address offset: 18h       */
  __IO uint32_t CONFR7;          /*!< JPEG Codec Control Register (JPEG_CONFR7),        Address offset: 1Ch       */
  uint32_t  Reserved20[4];       /* Reserved                                            Address offset: 20h-2Ch   */
  __IO uint32_t CR;              /*!< JPEG Control Register (JPEG_CR),                  Address offset: 30h       */
  __IO uint32_t SR;              /*!< JPEG Status Register (JPEG_SR),                   Address offset: 34h       */
  __IO uint32_t CFR;             /*!< JPEG Clear Flag Register (JPEG_CFR),              Address offset: 38h       */
  uint32_t  Reserved3c;          /* Reserved                                            Address offset: 3Ch       */
  __IO uint32_t DIR;             /*!< JPEG Data Input Register (JPEG_DIR),              Address offset: 40h       */
  __IO uint32_t DOR;             /*!< JPEG Data Output Register (JPEG_DOR),             Address offset: 44h       */
  uint32_t  Reserved48[2];       /* Reserved                                            Address offset: 48h-4Ch   */
  __IO uint32_t QMEM0[16];       /*!< JPEG quantization tables 0,                       Address offset: 50h-8Ch   */
  __IO uint32_t QMEM1[16];       /*!< JPEG quantization tables 1,                       Address offset: 90h-CCh   */
  __IO uint32_t QMEM2[16];       /*!< JPEG quantization tables 2,                       Address offset: D0h-10Ch  */
  __IO uint32_t QMEM3[16];       /*!< JPEG quantization tables 3,                       Address offset: 110h-14Ch */
  __IO uint32_t HUFFMIN[16];     /*!< JPEG HuffMin tables,                              Address offset: 150h-18Ch */
  __IO uint32_t HUFFBASE[32];    /*!< JPEG HuffSymb tables,                             Address offset: 190h-20Ch */
  __IO uint32_t HUFFSYMB[84];    /*!< JPEG HUFFSYMB tables,                             Address offset: 210h-35Ch */
  __IO uint32_t DHTMEM[103];     /*!< JPEG DHTMem tables,                               Address offset: 360h-4F8h */
  uint32_t  Reserved4FC;         /* Reserved                                            Address offset: 4FCh      */
  __IO uint32_t HUFFENC_AC0[88]; /*!< JPEG encodor, AC Huffman table 0,                 Address offset: 500h-65Ch */
  __IO uint32_t HUFFENC_AC1[88]; /*!< JPEG encodor, AC Huffman table 1,                 Address offset: 660h-7BCh */
  __IO uint32_t HUFFENC_DC0[8];  /*!< JPEG encodor, DC Huffman table 0,                 Address offset: 7C0h-7DCh */
  __IO uint32_t HUFFENC_DC1[8];  /*!< JPEG encodor, DC Huffman table 1,                 Address offset: 7E0h-7FCh */

} JPEG_TypeDef;

/**
  * @brief LCD-TFT Display Controller
  */
typedef struct
{
  uint32_t      RESERVED0[2];  /*!< Reserved, 0x00-0x04 */
  __IO uint32_t SSCR;          /*!< LTDC Synchronization Size Configuration Register,    Address offset: 0x08 */
  __IO uint32_t BPCR;          /*!< LTDC Back Porch Configuration Register,              Address offset: 0x0C */
  __IO uint32_t AWCR;          /*!< LTDC Active Width Configuration Register,            Address offset: 0x10 */
  __IO uint32_t TWCR;          /*!< LTDC Total Width Configuration Register,             Address offset: 0x14 */
  __IO uint32_t GCR;           /*!< LTDC Global Control Register,                        Address offset: 0x18 */
  uint32_t      RESERVED1[2];  /*!< Reserved, 0x1C-0x20 */
  __IO uint32_t SRCR;          /*!< LTDC Shadow Reload Configuration Register,           Address offset: 0x24 */
  uint32_t      RESERVED2[1];  /*!< Reserved, 0x28 */
  __IO uint32_t BCCR;          /*!< LTDC Background Color Configuration Register,        Address offset: 0x2C */
  uint32_t      RESERVED3[1];  /*!< Reserved, 0x30 */
  __IO uint32_t IER;           /*!< LTDC Interrupt Enable Register,                      Address offset: 0x34 */
  __IO uint32_t ISR;           /*!< LTDC Interrupt Status Register,                      Address offset: 0x38 */
  __IO uint32_t ICR;           /*!< LTDC Interrupt Clear Register,                       Address offset: 0x3C */
  __IO uint32_t LIPCR;         /*!< LTDC Line Interrupt Position Configuration Register, Address offset: 0x40 */
  __IO uint32_t CPSR;          /*!< LTDC Current Position Status Register,               Address offset: 0x44 */
  __IO uint32_t CDSR;         /*!< LTDC Current Display Status Register,                 Address offset: 0x48 */
} LTDC_TypeDef;

/**
  * @brief LCD-TFT Display layer x Controller
  */

typedef struct
{
  __IO uint32_t CR;            /*!< LTDC Layerx Control Register                                  Address offset: 0x84 */
  __IO uint32_t WHPCR;         /*!< LTDC Layerx Window Horizontal Position Configuration Register Address offset: 0x88 */
  __IO uint32_t WVPCR;         /*!< LTDC Layerx Window Vertical Position Configuration Register   Address offset: 0x8C */
  __IO uint32_t CKCR;          /*!< LTDC Layerx Color Keying Configuration Register               Address offset: 0x90 */
  __IO uint32_t PFCR;          /*!< LTDC Layerx Pixel Format Configuration Register               Address offset: 0x94 */
  __IO uint32_t CACR;          /*!< LTDC Layerx Constant Alpha Configuration Register             Address offset: 0x98 */
  __IO uint32_t DCCR;          /*!< LTDC Layerx Default Color Configuration Register              Address offset: 0x9C */
  __IO uint32_t BFCR;          /*!< LTDC Layerx Blending Factors Configuration Register           Address offset: 0xA0 */
  uint32_t      RESERVED0[2];  /*!< Reserved */
  __IO uint32_t CFBAR;         /*!< LTDC Layerx Color Frame Buffer Address Register               Address offset: 0xAC */
  __IO uint32_t CFBLR;         /*!< LTDC Layerx Color Frame Buffer Length Register                Address offset: 0xB0 */
  __IO uint32_t CFBLNR;        /*!< LTDC Layerx ColorFrame Buffer Line Number Register            Address offset: 0xB4 */
  uint32_t      RESERVED1[3];  /*!< Reserved */
  __IO uint32_t CLUTWR;        /*!< LTDC Layerx CLUT Write Register                               Address offset: 0x144 */

} LTDC_Layer_TypeDef;

/**
  * @brief Instruction Cache
  */
typedef struct
{
  __IO uint32_t CR;             /*!< ICACHE control register,                Address offset: 0x00 */
  __IO uint32_t SR;             /*!< ICACHE status register,                 Address offset: 0x04 */
  __IO uint32_t IER;            /*!< ICACHE interrupt enable register,       Address offset: 0x08 */
  __IO uint32_t FCR;            /*!< ICACHE Flag clear register,             Address offset: 0x0C */
  __IO uint32_t HMONR;          /*!< ICACHE hit monitor register,            Address offset: 0x10 */
  __IO uint32_t MMONR;          /*!< ICACHE miss monitor register,           Address offset: 0x14 */
       uint32_t RESERVED1[2];   /*!< Reserved,                               Address offset: 0x018-0x01C */
  __IO uint32_t CRR0;           /*!< ICACHE region 0 configuration register, Address offset: 0x20 */
  __IO uint32_t CRR1;           /*!< ICACHE region 1 configuration register, Address offset: 0x24 */
  __IO uint32_t CRR2;           /*!< ICACHE region 2 configuration register, Address offset: 0x28 */
  __IO uint32_t CRR3;           /*!< ICACHE region 3 configuration register, Address offset: 0x2C */
       uint32_t RESERVED2[240]; /*!< Reserved,                               Address offset: 0x30-0x3EC */
  __IO uint32_t HWCFGR;         /*!< ICACHE HW configuration register,       Address offset: 0x3F0 */
  __IO uint32_t VERR;           /*!< ICACHE version register,                Address offset: 0x3F4 */
  __IO uint32_t IPIDR;          /*!< ICACHE IP identification register,      Address offset: 0x3F8 */
  __IO uint32_t SIDR;           /*!< ICACHE size identification register,    Address offset: 0x3FC */
} ICACHE_TypeDef;

/**
  * @brief Data Cache
  */
typedef struct
{
  __IO uint32_t CR;             /*!< DCACHE control register,               Address offset: 0x00 */
  __IO uint32_t SR;             /*!< DCACHE status register,                Address offset: 0x04 */
  __IO uint32_t IER;            /*!< DCACHE interrupt enable register,      Address offset: 0x08 */
  __IO uint32_t FCR;            /*!< DCACHE Flag clear register,            Address offset: 0x0C */
  __IO uint32_t RHMONR;         /*!< DCACHE Read hit monitor register,      Address offset: 0x10 */
  __IO uint32_t RMMONR;         /*!< DCACHE Read miss monitor register,     Address offset: 0x14 */
       uint32_t RESERVED1[2];   /*!< Reserved,                              Address offset: 0x18-0x1C */
  __IO uint32_t WHMONR;         /*!< DCACHE Write hit monitor register,     Address offset: 0x20 */
  __IO uint32_t WMMONR;         /*!< DCACHE Write miss monitor register,    Address offset: 0x24 */
  __IO uint32_t CMDRSADDRR;     /*!< DCACHE Command Start Address register, Address offset: 0x28 */
  __IO uint32_t CMDREADDRR;     /*!< DCACHE Command End Address register,   Address offset: 0x2C */
} DCACHE_TypeDef;

/**
  * @brief PSSI
  */
typedef struct
{
  __IO uint32_t CR;             /*!< PSSI control register,                 Address offset: 0x000 */
  __IO uint32_t SR;             /*!< PSSI status register,                  Address offset: 0x004 */
  __IO uint32_t RIS;            /*!< PSSI raw interrupt status register,    Address offset: 0x008 */
  __IO uint32_t IER;            /*!< PSSI interrupt enable register,        Address offset: 0x00C */
  __IO uint32_t MIS;            /*!< PSSI masked interrupt status register, Address offset: 0x010 */
  __IO uint32_t ICR;            /*!< PSSI interrupt clear register,         Address offset: 0x014 */
  __IO uint32_t RESERVED1[4];   /*!< Reserved,                                      0x018 - 0x024 */
  __IO uint32_t DR;             /*!< PSSI data register,                    Address offset: 0x028 */
} PSSI_TypeDef;

/**
  * @brief TIM
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< TIM control register 1,                   Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< TIM control register 2,                   Address offset: 0x04 */
  __IO uint32_t SMCR;        /*!< TIM slave mode control register,          Address offset: 0x08 */
  __IO uint32_t DIER;        /*!< TIM DMA/interrupt enable register,        Address offset: 0x0C */
  __IO uint32_t SR;          /*!< TIM status register,                      Address offset: 0x10 */
  __IO uint32_t EGR;         /*!< TIM event generation register,            Address offset: 0x14 */
  __IO uint32_t CCMR1;       /*!< TIM capture/compare mode register 1,      Address offset: 0x18 */
  __IO uint32_t CCMR2;       /*!< TIM capture/compare mode register 2,      Address offset: 0x1C */
  __IO uint32_t CCER;        /*!< TIM capture/compare enable register,      Address offset: 0x20 */
  __IO uint32_t CNT;         /*!< TIM counter register,                     Address offset: 0x24 */
  __IO uint32_t PSC;         /*!< TIM prescaler,                            Address offset: 0x28 */
  __IO uint32_t ARR;         /*!< TIM auto-reload register,                 Address offset: 0x2C */
  __IO uint32_t RCR;         /*!< TIM repetition counter register,          Address offset: 0x30 */
  __IO uint32_t CCR1;        /*!< TIM capture/compare register 1,           Address offset: 0x34 */
  __IO uint32_t CCR2;        /*!< TIM capture/compare register 2,           Address offset: 0x38 */
  __IO uint32_t CCR3;        /*!< TIM capture/compare register 3,           Address offset: 0x3C */
  __IO uint32_t CCR4;        /*!< TIM capture/compare register 4,           Address offset: 0x40 */
  __IO uint32_t BDTR;        /*!< TIM break and dead-time register,         Address offset: 0x44 */
  __IO uint32_t CCR5;        /*!< TIM capture/compare register 5,           Address offset: 0x48 */
  __IO uint32_t CCR6;        /*!< TIM capture/compare register 6,           Address offset: 0x4C */
  __IO uint32_t CCMR3;       /*!< TIM capture/compare mode register 3,      Address offset: 0x50 */
  __IO uint32_t DTR2;        /*!< TIM deadtime register 2,                  Address offset: 0x54 */
  __IO uint32_t ECR;         /*!< TIM encoder control register,             Address offset: 0x58 */
  __IO uint32_t TISEL;       /*!< TIM Input Selection register,             Address offset: 0x5C */
  __IO uint32_t AF1;         /*!< TIM alternate function option register 1, Address offset: 0x60 */
  __IO uint32_t AF2;         /*!< TIM alternate function option register 2, Address offset: 0x64 */
  __IO uint32_t OR1 ;        /*!< TIM option register,                      Address offset: 0x68 */
       uint32_t RESERVED0[220];/*!< Reserved,                               Address offset: 0x6C */
  __IO uint32_t DCR;         /*!< TIM DMA control register,                 Address offset: 0x3DC */
  __IO uint32_t DMAR;        /*!< TIM DMA address for full transfer,        Address offset: 0x3E0 */
} TIM_TypeDef;

/**
  * @brief LPTIMER
  */
typedef struct
{
  __IO uint32_t ISR;            /*!< LPTIM Interrupt and Status register,    Address offset: 0x00 */
  __IO uint32_t ICR;            /*!< LPTIM Interrupt Clear register,         Address offset: 0x04 */
  __IO uint32_t DIER;           /*!< LPTIM Interrupt Enable register,        Address offset: 0x08 */
  __IO uint32_t CFGR;           /*!< LPTIM Configuration register,           Address offset: 0x0C */
  __IO uint32_t CR;             /*!< LPTIM Control register,                 Address offset: 0x10 */
  __IO uint32_t CCR1;           /*!< LPTIM Capture/Compare register 1,       Address offset: 0x14 */
  __IO uint32_t ARR;            /*!< LPTIM Autoreload register,              Address offset: 0x18 */
  __IO uint32_t CNT;            /*!< LPTIM Counter register,                 Address offset: 0x1C */
  __IO uint32_t RESERVED0;      /*!< Reserved,                               Address offset: 0x20 */
  __IO uint32_t CFGR2;          /*!< LPTIM Configuration register 2,         Address offset: 0x24 */
  __IO uint32_t RCR;            /*!< LPTIM Repetition register,              Address offset: 0x28 */
  __IO uint32_t CCMR1;          /*!< LPTIM Capture/Compare mode register,    Address offset: 0x2C */
  __IO uint32_t RESERVED1;      /*!< Reserved,                               Address offset: 0x30 */
  __IO uint32_t CCR2;           /*!< LPTIM Capture/Compare register 2,       Address offset: 0x34 */
} LPTIM_TypeDef;

/**
  * @brief Comparator
  */
typedef struct
{
  __IO uint32_t CSR;            /*!< Comparator control and status register, Address offset: 0x00 */
} COMP_TypeDef;

typedef struct
{
  __IO uint32_t CSR_ODD;        /*!< COMP control and status register located in register of comparator instance odd, used for bits common to several COMP instances, Address offset: 0x00 */
  __IO uint32_t CSR_EVEN;       /*!< COMP control and status register located in register of comparator instance even, used for bits common to several COMP instances, Address offset: 0x04 */
} COMP_Common_TypeDef;

/**
  * @brief Operational Amplifier (OPAMP)
  */
typedef struct
{
  __IO uint32_t CSR;         /*!< OPAMP control/status register,                     Address offset: 0x00 */
  __IO uint32_t OTR;         /*!< OPAMP offset trimming register for normal mode,    Address offset: 0x04 */
  __IO uint32_t LPOTR;       /*!< OPAMP offset trimming register for low power mode, Address offset: 0x08 */
} OPAMP_TypeDef;

typedef struct
{
  __IO uint32_t CSR;         /*!< OPAMP control/status register, used for bits common to
                                  several OPAMP instances, Address offset: 0x00         */
} OPAMP_Common_TypeDef;


/**
  * @brief MDF/ADF
  */
typedef struct
{
 __IO uint32_t GCR;            /*!< MDF Global Control register,             Address offset: 0x00  */
 __IO uint32_t CKGCR;          /*!< MDF Clock Generator Control Register,    Address offset: 0x04  */
 uint32_t     RESERVED1[6];    /*!< Reserved, 0x08-0x1C                                            */
 __IO uint32_t OR;             /*!< MDF  Option Register,                    Address offset: 0x20  */
}MDF_TypeDef;

/**
  * @brief MDF/ADF filter
  */
typedef struct
{
 __IO uint32_t SITFCR;         /*!< MDF Serial Interface Control Register,          Address offset: 0x80 */
 __IO uint32_t BSMXCR;         /*!< MDF Bitstream Matrix Control Register,          Address offset: 0x84 */
 __IO uint32_t DFLTCR;         /*!< MDF Digital Filter Control Register,            Address offset: 0x88 */
 __IO uint32_t DFLTCICR;       /*!< MDF MCIC Configuration Register,                Address offset: 0x8C */
 __IO uint32_t DFLTRSFR;       /*!< MDF Reshape Filter Configuration Register,      Address offset: 0x90 */
 __IO uint32_t DFLTINTR;       /*!< MDF Integrator Configuration Register,          Address offset: 0x94 */
 __IO uint32_t OLDCR;          /*!< MDF Out-Of Limit Detector Control Register,     Address offset: 0x98 */
 __IO uint32_t OLDTHLR;        /*!< MDF OLD Threshold Low Register,                 Address offset: 0x9C */
 __IO uint32_t OLDTHHR;        /*!< MDF OLD Threshold High Register,                Address offset: 0xA0 */
 __IO uint32_t DLYCR;          /*!< MDF Delay control Register,                     Address offset: 0xA4 */
 __IO uint32_t SCDCR;          /*!< MDF short circuit detector control Register,    Address offset: 0xA8 */
 __IO uint32_t DFLTIER;        /*!< MDF DFLT Interrupt enable Register,             Address offset: 0xAC */
 __IO uint32_t DFLTISR;        /*!< MDF DFLT Interrupt status Register,             Address offset: 0xB0 */
 __IO uint32_t OECCR;          /*!< MDF Offset Error Compensation Control Register, Address offset: 0xB4 */
 __IO uint32_t SADCR;          /*!< MDF SAD Control Register,                       Address offset: 0xB8 */
 __IO uint32_t SADCFGR;        /*!< MDF SAD configuration register,                 Address offset: 0xBC */
 __IO uint32_t SADSDLVR;       /*!< MDF SAD Sound level Register,                   Address offset: 0xC0 */
 __IO uint32_t SADANLVR;       /*!< MDF SAD Ambient Noise level Register,           Address offset: 0xC4 */
 uint32_t     RESERVED1[9];    /*!< Reserved, 0xC8-0xE8                                                  */
 __IO uint32_t SNPSDR;         /*!< MDF Snapshot Data Register,                     Address offset: 0xEC */
 __IO uint32_t DFLTDR;         /*!< MDF Digital Filter Data Register,               Address offset: 0xF0 */
} MDF_Filter_TypeDef;

/**
  * @brief HEXA and OCTO Serial Peripheral Interface
  */

typedef struct
{
  __IO uint32_t CR;          /*!< XSPI Control register,                            Address offset: 0x000 */
  uint32_t RESERVED;         /*!< Reserved,                                         Address offset: 0x004 */
  __IO uint32_t DCR1;        /*!< XSPI Device Configuration register 1,             Address offset: 0x008 */
  __IO uint32_t DCR2;        /*!< XSPI Device Configuration register 2,             Address offset: 0x00C */
  __IO uint32_t DCR3;        /*!< XSPI Device Configuration register 3,             Address offset: 0x010 */
  __IO uint32_t DCR4;        /*!< XSPI Device Configuration register 4,             Address offset: 0x014 */
  uint32_t RESERVED1[2];     /*!< Reserved,                                         Address offset: 0x018-0x01C */
  __IO uint32_t SR;          /*!< XSPI Status register,                             Address offset: 0x020 */
  __IO uint32_t FCR;         /*!< XSPI Flag Clear register,                         Address offset: 0x024 */
  uint32_t RESERVED2[6];     /*!< Reserved,                                         Address offset: 0x028-0x03C */
  __IO uint32_t DLR;         /*!< XSPI Data Length register,                        Address offset: 0x040 */
  uint32_t RESERVED3;        /*!< Reserved,                                         Address offset: 0x044 */
  __IO uint32_t AR;          /*!< XSPI Address register,                            Address offset: 0x048 */
  uint32_t RESERVED4;        /*!< Reserved,                                         Address offset: 0x04C */
  __IO uint32_t DR;          /*!< XSPI Data register,                               Address offset: 0x050 */
  uint32_t RESERVED5[11];    /*!< Reserved,                                         Address offset: 0x054-0x07C */
  __IO uint32_t PSMKR;       /*!< XSPI Polling Status Mask register,                Address offset: 0x080 */
  uint32_t RESERVED6;        /*!< Reserved,                                         Address offset: 0x084 */
  __IO uint32_t PSMAR;       /*!< XSPI Polling Status Match register,               Address offset: 0x088 */
  uint32_t RESERVED7;        /*!< Reserved,                                         Address offset: 0x08C */
  __IO uint32_t PIR;         /*!< XSPI Polling Interval register,                   Address offset: 0x090 */
  uint32_t RESERVED8[27];    /*!< Reserved,                                         Address offset: 0x094-0x0FC */
  __IO uint32_t CCR;         /*!< XSPI Communication Configuration register,        Address offset: 0x100 */
  uint32_t RESERVED9;        /*!< Reserved,                                         Address offset: 0x104 */
  __IO uint32_t TCR;         /*!< XSPI Timing Configuration register,               Address offset: 0x108 */
  uint32_t RESERVED10;       /*!< Reserved,                                         Address offset: 0x10C */
  __IO uint32_t IR;          /*!< XSPI Instruction register,                        Address offset: 0x110 */
  uint32_t RESERVED11[3];    /*!< Reserved,                                         Address offset: 0x114-0x11C */
  __IO uint32_t ABR;         /*!< XSPI Alternate Bytes register,                    Address offset: 0x120 */
  uint32_t RESERVED12[3];    /*!< Reserved,                                         Address offset: 0x124-0x12C */
  __IO uint32_t LPTR;        /*!< XSPI Low Power Timeout register,                  Address offset: 0x130 */
  uint32_t RESERVED13[3];    /*!< Reserved,                                         Address offset: 0x134-0x13C */
  __IO uint32_t WPCCR;       /*!< XSPI Wrap Communication Configuration register,   Address offset: 0x140 */
  uint32_t RESERVED14;       /*!< Reserved,                                         Address offset: 0x144 */
  __IO uint32_t WPTCR;       /*!< XSPI Wrap Timing Configuration register,          Address offset: 0x148 */
  uint32_t RESERVED15;       /*!< Reserved,                                         Address offset: 0x14C */
  __IO uint32_t WPIR;        /*!< XSPI Wrap Instruction register,                   Address offset: 0x150 */
  uint32_t RESERVED16[3];    /*!< Reserved,                                         Address offset: 0x154-0x15C */
  __IO uint32_t WPABR;       /*!< XSPI Wrap Alternate Bytes register,               Address offset: 0x160 */
  uint32_t RESERVED17[7];    /*!< Reserved,                                         Address offset: 0x164-0x17C */
  __IO uint32_t WCCR;        /*!< XSPI Write Communication Configuration register,  Address offset: 0x180 */
  uint32_t RESERVED18;       /*!< Reserved,                                         Address offset: 0x184 */
  __IO uint32_t WTCR;        /*!< XSPI Write Timing Configuration register,         Address offset: 0x188 */
  uint32_t RESERVED19;       /*!< Reserved,                                         Address offset: 0x18C */
  __IO uint32_t WIR;         /*!< XSPI Write Instruction register,                  Address offset: 0x190 */
  uint32_t RESERVED20[3];    /*!< Reserved,                                         Address offset: 0x194-0x19C */
  __IO uint32_t WABR;        /*!< XSPI Write Alternate Bytes register,              Address offset: 0x1A0 */
  uint32_t RESERVED21[23];   /*!< Reserved,                                         Address offset: 0x1A4-0x1FC */
  __IO uint32_t HLCR;        /*!< XSPI Hyperbus Latency Configuration register,     Address offset: 0x200 */
  uint32_t RESERVED22[3];    /*!< Reserved,                                         Address offset: 0x204-0x20C */
  __IO uint32_t CALFCR;      /*!< XSPI Full-cycle calibration configuration
                                  HSPI only, invalid for OCTOSPI,                   Address offset: 0x210 */
  uint32_t RESERVED23;       /*!< Reserved,                                         Address offset: 0x214 */
  __IO uint32_t CALMR;       /*!< XSPI DLL master calibration configuration
                                  HSPI only, invalid for OCTOSPI,                   Address offset: 0x218 */
  uint32_t RESERVED24;       /*!< Reserved,                                         Address offset: 0x21C */
  __IO uint32_t CALSOR;      /*!< XSPI slave output calibration configuration
                                  HSPI only, invalid for OCTOSPI,                   Address offset: 0x220 */
  uint32_t RESERVED25;       /*!< Reserved,                                         Address offset: 0x224 */
  __IO uint32_t CALSIR;      /*!< XSPI slave input calibration configuration
                                  HSPI only, invalid for OCTOSPI,                   Address offset: 0x228 */
} XSPI_TypeDef;

typedef  XSPI_TypeDef OCTOSPI_TypeDef;

typedef  XSPI_TypeDef HSPI_TypeDef;

/**
  * @brief OTFDEC register
  */
typedef struct
{
  __IO uint32_t REG_CONFIGR;      /*!< OTFDEC Region Configuration register,          Address offset: 0x20 + 0x30 * (x -1) (x = 1 to 4) */
  __IO uint32_t REG_START_ADDR;   /*!< OTFDEC Region Start Address register,          Address offset: 0x24 + 0x30 * (x -1) (x = 1 to 4) */
  __IO uint32_t REG_END_ADDR;     /*!< OTFDEC Region End Address register,            Address offset: 0x28 + 0x30 * (x -1) (x = 1 to 4) */
  __IO uint32_t REG_NONCER0;      /*!< OTFDEC Region Nonce register 0,                Address offset: 0x2C + 0x30 * (x -1) (x = 1 to 4) */
  __IO uint32_t REG_NONCER1;      /*!< OTFDEC Region Nonce register 1,                Address offset: 0x30 + 0x30 * (x -1) (x = 1 to 4) */
  __IO uint32_t REG_KEYR0;        /*!< OTFDEC Region Key register 0,                  Address offset: 0x34 + 0x30 * (x -1) (x = 1 to 4) */
  __IO uint32_t REG_KEYR1;        /*!< OTFDEC Region Key register 1,                  Address offset: 0x38 + 0x30 * (x -1) (x = 1 to 4) */
  __IO uint32_t REG_KEYR2;        /*!< OTFDEC Region Key register 2,                  Address offset: 0x3C + 0x30 * (x -1) (x = 1 to 4) */
  __IO uint32_t REG_KEYR3;        /*!< OTFDEC Region Key register 3,                  Address offset: 0x40 + 0x30 * (x -1) (x = 1 to 4) */
} OTFDEC_Region_TypeDef;

typedef struct
{
  __IO uint32_t CR;               /*!< OTFDEC Control register,                                 Address offset: 0x000 */
  uint32_t RESERVED1[3];          /*!< Reserved,                                                Address offset: 0x004-0x00C */
  __IO uint32_t PRIVCFGR;         /*!< OTFDEC Privileged access control Configuration register, Address offset: 0x010 */
  uint32_t RESERVED2[187];        /*!< Reserved,                                                Address offset: 0x014-0x2FC */
  __IO uint32_t ISR;              /*!< OTFDEC Interrupt Status register,                        Address offset: 0x300 */
  __IO uint32_t ICR;              /*!< OTFDEC Interrupt Clear register,                         Address offset: 0x304 */
  __IO uint32_t IER;              /*!< OTFDEC Interrupt Enable register,                        Address offset: 0x308 */
} OTFDEC_TypeDef;


/**
  * @brief Serial Peripheral Interface IO Manager
  */
typedef struct
{
  __IO uint32_t CR;          /*!< OCTOSPIM IO Manager Control register,                 Address offset: 0x00 */
  __IO uint32_t PCR[8];      /*!< OCTOSPIM IO Manager Port[1:8] Configuration register, Address offset: 0x04-0x20 */
} XSPIM_TypeDef;

typedef  XSPIM_TypeDef OCTOSPIM_TypeDef;

/**
  * @brief Power Control
  */
typedef struct
{
  __IO uint32_t CR1;      /*!< Power control register 1,                          Address offset: 0x00 */
  __IO uint32_t CR2;      /*!< Power control register 2,                          Address offset: 0x04 */
  __IO uint32_t CR3;      /*!< Power control register 3,                          Address offset: 0x08 */
  __IO uint32_t VOSR;     /*!< Power voltage scaling register,                    Address offset: 0x0C */
  __IO uint32_t SVMCR;    /*!< Power supply voltage monitoring control register,  Address offset: 0x10 */
  __IO uint32_t WUCR1;    /*!< Power wakeup control register 1,                   Address offset: 0x14 */
  __IO uint32_t WUCR2;    /*!< Power wakeup control register 2,                   Address offset: 0x18 */
  __IO uint32_t WUCR3;    /*!< Power wakeup control register 3,                   Address offset: 0x1C */
  __IO uint32_t BDCR1;    /*!< Power backup domain control register 1,            Address offset: 0x20 */
  __IO uint32_t BDCR2;    /*!< Power backup domain control register 2,            Address offset: 0x24 */
  __IO uint32_t DBPR;     /*!< Power disable backup domain register,              Address offset: 0x28 */
  __IO uint32_t UCPDR;    /*!< Power USB Type-C and Power Delivery register,      Address offset: 0x2C */
  __IO uint32_t SECCFGR;  /*!< Power Security configuration register,             Address offset: 0x30 */
  __IO uint32_t PRIVCFGR; /*!< Power privilege control register,                  Address offset: 0x34 */
  __IO uint32_t SR;       /*!< Power status register,                             Address offset: 0x38 */
  __IO uint32_t SVMSR;    /*!< Power supply voltage monitoring status register,   Address offset: 0x3C */
  __IO uint32_t BDSR;     /*!< Power backup domain status register,               Address offset: 0x40 */
  __IO uint32_t WUSR;     /*!< Power wakeup status register,                      Address offset: 0x44 */
  __IO uint32_t WUSCR;    /*!< Power wakeup status clear register,                Address offset: 0x48 */
  __IO uint32_t APCR;     /*!< Power apply pull configuration register,           Address offset: 0x4C */
  __IO uint32_t PUCRA;    /*!< Power Port A pull-up control register,             Address offset: 0x50 */
  __IO uint32_t PDCRA;    /*!< Power Port A pull-down control register,           Address offset: 0x54 */
  __IO uint32_t PUCRB;    /*!< Power Port B pull-up control register,             Address offset: 0x58 */
  __IO uint32_t PDCRB;    /*!< Power Port B pull-down control register,           Address offset: 0x5C */
  __IO uint32_t PUCRC;    /*!< Power Port C pull-up control register,             Address offset: 0x60 */
  __IO uint32_t PDCRC;    /*!< Power Port C pull-down control register,           Address offset: 0x64 */
  __IO uint32_t PUCRD;    /*!< Power Port D pull-up control register,             Address offset: 0x68 */
  __IO uint32_t PDCRD;    /*!< Power Port D pull-down control register,           Address offset: 0x6C */
  __IO uint32_t PUCRE;    /*!< Power Port E pull-up control register,             Address offset: 0x70 */
  __IO uint32_t PDCRE;    /*!< Power Port E pull-down control register,           Address offset: 0x74 */
  __IO uint32_t PUCRF;    /*!< Power Port F pull-up control register,             Address offset: 0x78 */
  __IO uint32_t PDCRF;    /*!< Power Port F pull-down control register,           Address offset: 0x7C */
  __IO uint32_t PUCRG;    /*!< Power Port G pull-up control register,             Address offset: 0x80 */
  __IO uint32_t PDCRG;    /*!< Power Port G pull-down control register,           Address offset: 0x84 */
  __IO uint32_t PUCRH;    /*!< Power Port H pull-up control register,             Address offset: 0x88 */
  __IO uint32_t PDCRH;    /*!< Power Port H pull-down control register,           Address offset: 0x8C */
  __IO uint32_t PUCRI;    /*!< Power Port I pull-up control register,             Address offset: 0x90 */
  __IO uint32_t PDCRI;    /*!< Power Port I pull-down control register,           Address offset: 0x94 */
  __IO uint32_t PUCRJ;    /*!< Power Port J pull-up control register,             Address offset: 0x98        */
  __IO uint32_t PDCRJ;    /*!< Power Port J pull-down control register,           Address offset: 0x9C        */
       uint32_t RESERVED3[2];  /*!< Reserved3,                                    Address offset: 0x0A0-0x0A4 */
  __IO uint32_t CR4;      /*!< Power power control register 4,                    Address offset: 0xA8        */
  __IO uint32_t CR5;      /*!< Power power control register 5,                    Address offset: 0xAC        */
} PWR_TypeDef;

/**
  * @brief SRAMs configuration controller
  */
typedef struct
{
  __IO uint32_t CR;       /*!< Control Register,                  Address offset: 0x00 */
  __IO uint32_t IER;      /*!< Interrupt Enable Register,         Address offset: 0x04 */
  __IO uint32_t ISR;      /*!< Interrupt Status Register,         Address offset: 0x08 */
  __IO uint32_t SEAR;     /*!< ECC Single Error Address Register, Address offset: 0x0C */
  __IO uint32_t DEAR;     /*!< ECC Double Error Address Register, Address offset: 0x10 */
  __IO uint32_t ICR;      /*!< Interrupt Clear Register,          Address offset: 0x14 */
  __IO uint32_t WPR1;     /*!< SRAM Write Protection Register 1,  Address offset: 0x18 */
  __IO uint32_t WPR2;     /*!< SRAM Write Protection Register 2,  Address offset: 0x1C */
  uint32_t      RESERVED; /*!< Reserved,                          Address offset: 0x20 */
  __IO uint32_t ECCKEY;   /*!< SRAM ECC Key Register,             Address offset: 0x24 */
  __IO uint32_t ERKEYR;   /*!< SRAM Erase Key Register,           Address offset: 0x28 */
}RAMCFG_TypeDef;

/**
  * @brief Reset and Clock Control
  */
typedef struct
{
  __IO uint32_t CR;            /*!< RCC clock control register                                               Address offset: 0x00 */
  uint32_t      RESERVED0;     /*!< Reserved                                                                 Address offset: 0x04 */
  __IO uint32_t ICSCR1;        /*!< RCC internal clock sources calibration register 1                        Address offset: 0x08 */
  __IO uint32_t ICSCR2;        /*!< RCC internal clock sources calibration register 2                        Address offset: 0x0C */
  __IO uint32_t ICSCR3;        /*!< RCC internal clock sources calibration register 3                        Address offset: 0x10 */
  __IO uint32_t CRRCR;         /*!< RCC Clock Recovery RC Register                                           Address offset: 0x14 */
  uint32_t      RESERVED1;     /*!< Reserved                                                                 Address offset: 0x18 */
  __IO uint32_t CFGR1;         /*!< RCC clock configuration register 1                                       Address offset: 0x1C */
  __IO uint32_t CFGR2;         /*!< RCC clock configuration register 2                                       Address offset: 0x20 */
  __IO uint32_t CFGR3;         /*!< RCC clock configuration register 3                                       Address offset: 0x24 */
  __IO uint32_t PLL1CFGR;      /*!< PLL1 Configuration Register                                              Address offset: 0x28 */
  __IO uint32_t PLL2CFGR;      /*!< PLL2 Configuration Register                                              Address offset: 0x2C */
  __IO uint32_t PLL3CFGR;      /*!< PLL3 Configuration Register                                              Address offset: 0x30 */
  __IO uint32_t PLL1DIVR;      /*!< PLL1 Dividers Configuration Register                                     Address offset: 0x34 */
  __IO uint32_t PLL1FRACR;     /*!< PLL1 Fractional Divider Configuration Register                           Address offset: 0x38 */
  __IO uint32_t PLL2DIVR;      /*!< PLL2 Dividers Configuration Register                                     Address offset: 0x3C */
  __IO uint32_t PLL2FRACR;     /*!< PLL2 Fractional Divider Configuration Register                           Address offset: 0x40 */
  __IO uint32_t PLL3DIVR;      /*!< PLL3 Dividers Configuration Register                                     Address offset: 0x44 */
  __IO uint32_t PLL3FRACR;     /*!< PLL3 Fractional Divider Configuration Register                           Address offset: 0x48 */
  uint32_t      RESERVED2;     /*!< Reserved                                                                 Address offset: 0x4C */
  __IO uint32_t CIER;          /*!< Clock Interrupt Enable Register                                          Address offset: 0x50 */
  __IO uint32_t CIFR;          /*!< Clock Interrupt Flag Register                                            Address offset: 0x54 */
  __IO uint32_t CICR;          /*!< Clock Interrupt Clear Register                                           Address offset: 0x58 */
  uint32_t      RESERVED3;     /*!< Reserved                                                                 Address offset: 0x5C */
  __IO uint32_t AHB1RSTR;      /*!< AHB1 Peripherals Reset Register                                          Address offset: 0x60 */
  __IO uint32_t AHB2RSTR1;     /*!< AHB2 Peripherals Reset Register 1                                        Address offset: 0x64 */
  __IO uint32_t AHB2RSTR2;     /*!< AHB2 Peripherals Reset Register 2                                        Address offset: 0x68 */
  __IO uint32_t AHB3RSTR;      /*!< AHB3 Peripherals Reset Register                                          Address offset: 0x6C */
  uint32_t      RESERVED4;     /*!< Reserved                                                                 Address offset: 0x70 */
  __IO uint32_t APB1RSTR1;     /*!< APB1 Peripherals Reset Register 1                                        Address offset: 0x74 */
  __IO uint32_t APB1RSTR2;     /*!< APB1 Peripherals Reset Register 2                                        Address offset: 0x78 */
  __IO uint32_t APB2RSTR;      /*!< APB2 Peripherals Reset Register                                          Address offset: 0x7C */
  __IO uint32_t APB3RSTR;      /*!< APB3 Peripherals Reset Register                                          Address offset: 0x80 */
  uint32_t      RESERVED5;     /*!< Reserved                                                                 Address offset: 0x84 */
  __IO uint32_t AHB1ENR;       /*!< AHB1 Peripherals Clock Enable Register                                   Address offset: 0x88 */
  __IO uint32_t AHB2ENR1;      /*!< AHB2 Peripherals Clock Enable Register 1                                 Address offset: 0x8C */
  __IO uint32_t AHB2ENR2;      /*!< AHB2 Peripherals Clock Enable Register 2                                 Address offset: 0x90 */
  __IO uint32_t AHB3ENR;       /*!< AHB3 Peripherals Clock Enable Register                                   Address offset: 0x94 */
  uint32_t      RESERVED6;     /*!< Reserved                                                                 Address offset: 0x98 */
  __IO uint32_t APB1ENR1;      /*!< APB1 Peripherals Clock Enable Register 1                                 Address offset: 0x9C */
  __IO uint32_t APB1ENR2;      /*!< APB1 Peripherals Clock Enable Register 2                                 Address offset: 0xA0 */
  __IO uint32_t APB2ENR;       /*!< APB2 Peripherals Clock Enable Register                                   Address offset: 0xA4 */
  __IO uint32_t APB3ENR;       /*!< APB3 Peripherals Clock Enable Register                                   Address offset: 0xA8 */
  uint32_t      RESERVED7;     /*!< Reserved                                                                 Address offset: 0xAC */
  __IO uint32_t AHB1SMENR;     /*!< AHB1 Peripherals Clock Enable in Sleep and Stop Modes Register           Address offset: 0xB0 */
  __IO uint32_t AHB2SMENR1;    /*!< AHB2 Peripherals Clock Enable in Sleep and Stop Modes Register 1         Address offset: 0xB4 */
  __IO uint32_t AHB2SMENR2;    /*!< AHB2 Peripherals Clock Enable in Sleep and Stop Modes Register 2         Address offset: 0xB8 */
  __IO uint32_t AHB3SMENR;     /*!< AHB3 Peripherals Clock Enable in Sleep and Stop Modes Register           Address offset: 0xBC */
  uint32_t      RESERVED8;     /*!< Reserved                                                                 Address offset: 0xC0 */
  __IO uint32_t APB1SMENR1;    /*!< APB1 Peripherals Clock Enable in Sleep and Stop Modes Register 1         Address offset: 0xC4 */
  __IO uint32_t APB1SMENR2;    /*!< APB1 Peripherals Clock Enable in Sleep and Stop Modes Register 2         Address offset: 0xC8 */
  __IO uint32_t APB2SMENR;     /*!< APB2 Peripherals Clock Enable in Sleep and Stop Modes Register 1         Address offset: 0xCC */
  __IO uint32_t APB3SMENR;     /*!< APB3 Peripherals Clock Enable in Sleep and Stop Modes Register 2         Address offset: 0xD0 */
  uint32_t      RESERVED9;     /*!< Reserved                                                                 Address offset: 0xD4 */
  __IO uint32_t SRDAMR;        /*!< SRD Autonomous Mode Register                                             Address offset: 0xD8 */
  uint32_t      RESERVED10;    /*!< Reserved,                                                                Address offset: 0xDC */
  __IO uint32_t CCIPR1;        /*!< IPs Clocks Configuration Register 1                                      Address offset: 0xE0 */
  __IO uint32_t CCIPR2;        /*!< IPs Clocks Configuration Register 2                                      Address offset: 0xE4 */
  __IO uint32_t CCIPR3;        /*!< IPs Clocks Configuration Register 3                                      Address offset: 0xE8 */
  uint32_t      RESERVED11;    /*!< Reserved,                                                                Address offset: 0xEC */
  __IO uint32_t BDCR;          /*!< Backup Domain Control Register                                           Address offset: 0xF0 */
  __IO uint32_t CSR;           /*!< V33 Clock Control & Status Register                                      Address offset: 0xF4 */
  uint32_t      RESERVED[6];   /*!< Reserved                                                                 Address offset: 0xF8 */
  __IO uint32_t SECCFGR;       /*!< RCC secure configuration register                                        Address offset: 0x110 */
  __IO uint32_t PRIVCFGR;      /*!< RCC privilege configuration register                                     Address offset: 0x114 */
} RCC_TypeDef;

/**
  * @brief PKA
  */
typedef struct
{
  __IO uint32_t CR;            /*!< PKA control register,             Address offset: 0x00 */
  __IO uint32_t SR;            /*!< PKA status register,              Address offset: 0x04 */
  __IO uint32_t CLRFR;         /*!< PKA clear flag register,          Address offset: 0x08 */
  uint32_t Reserved[253];      /*!< Reserved memory area              Address offset: 0x0C  -> 0x03FC */
  __IO uint32_t RAM[1334];     /*!< PKA RAM                           Address offset: 0x400 -> 0x18D4 */
} PKA_TypeDef;

/*
* @brief RTC Specific device feature definitions
*/
#define RTC_BKP_NB         32U
#define RTC_TAMP_NB        8U

/**
  * @brief Real-Time Clock
  */
typedef struct
{
  __IO uint32_t TR;          /*!< RTC time register,                              Address offset: 0x00 */
  __IO uint32_t DR;          /*!< RTC date register,                              Address offset: 0x04 */
  __IO uint32_t SSR;         /*!< RTC sub second register,                        Address offset: 0x08 */
  __IO uint32_t ICSR;        /*!< RTC initialization control and status register, Address offset: 0x0C */
  __IO uint32_t PRER;        /*!< RTC prescaler register,                         Address offset: 0x10 */
  __IO uint32_t WUTR;        /*!< RTC wakeup timer register,                      Address offset: 0x14 */
  __IO uint32_t CR;          /*!< RTC control register,                           Address offset: 0x18 */
  __IO uint32_t PRIVCFGR;    /*!< RTC privilege mode control register,            Address offset: 0x1C */
  __IO uint32_t SECCFGR;     /*!< RTC secure mode control register,               Address offset: 0x20 */
  __IO uint32_t WPR;         /*!< RTC write protection register,                  Address offset: 0x24 */
  __IO uint32_t CALR;        /*!< RTC calibration register,                       Address offset: 0x28 */
  __IO uint32_t SHIFTR;      /*!< RTC shift control register,                     Address offset: 0x2C */
  __IO uint32_t TSTR;        /*!< RTC time stamp time register,                   Address offset: 0x30 */
  __IO uint32_t TSDR;        /*!< RTC time stamp date register,                   Address offset: 0x34 */
  __IO uint32_t TSSSR;       /*!< RTC time-stamp sub second register,             Address offset: 0x38 */
       uint32_t RESERVED0;   /*!< Reserved,                                       Address offset: 0x3C */
  __IO uint32_t ALRMAR;      /*!< RTC alarm A register,                           Address offset: 0x40 */
  __IO uint32_t ALRMASSR;    /*!< RTC alarm A sub second register,                Address offset: 0x44 */
  __IO uint32_t ALRMBR;      /*!< RTC alarm B register,                           Address offset: 0x48 */
  __IO uint32_t ALRMBSSR;    /*!< RTC alarm B sub second register,                Address offset: 0x4C */
  __IO uint32_t SR;          /*!< RTC Status register,                            Address offset: 0x50 */
  __IO uint32_t MISR;        /*!< RTC masked interrupt status register,           Address offset: 0x54 */
  __IO uint32_t SMISR;       /*!< RTC secure masked interrupt status register,    Address offset: 0x58 */
  __IO uint32_t SCR;         /*!< RTC status Clear register,                      Address offset: 0x5C */
       uint32_t RESERVED4[4];/*!< Reserved,                                       Address offset: 0x58 */
  __IO uint32_t ALRABINR;    /*!< RTC alarm A binary mode register,               Address offset: 0x70 */
  __IO uint32_t ALRBBINR;    /*!< RTC alarm B binary mode register,               Address offset: 0x74 */
} RTC_TypeDef;

/**
  * @brief Tamper and backup registers
  */
typedef struct
{
  __IO uint32_t CR1;           /*!< TAMP configuration register 1,               Address offset: 0x00 */
  __IO uint32_t CR2;           /*!< TAMP configuration register 2,               Address offset: 0x04 */
  __IO uint32_t CR3;           /*!< TAMP configuration register 3,               Address offset: 0x08 */
  __IO uint32_t FLTCR;         /*!< TAMP filter control register,                Address offset: 0x0C */
  __IO uint32_t ATCR1;         /*!< TAMP filter control register 1               Address offset: 0x10 */
  __IO uint32_t ATSEEDR;       /*!< TAMP active tamper seed register,            Address offset: 0x14 */
  __IO uint32_t ATOR;          /*!< TAMP active tamper output register,          Address offset: 0x18 */
  __IO uint32_t ATCR2;         /*!< TAMP filter control register 2,              Address offset: 0x1C */
  __IO uint32_t SECCFGR;       /*!< TAMP secure mode control register,           Address offset: 0x20 */
  __IO uint32_t PRIVCFGR;      /*!< TAMP privilege mode control register,        Address offset: 0x24 */
       uint32_t RESERVED0;     /*!< Reserved,                                    Address offset: 0x28 */
  __IO uint32_t IER;           /*!< TAMP interrupt enable register,              Address offset: 0x2C */
  __IO uint32_t SR;            /*!< TAMP status register,                        Address offset: 0x30 */
  __IO uint32_t MISR;          /*!< TAMP masked interrupt status register,       Address offset: 0x34 */
  __IO uint32_t SMISR;         /*!< TAMP secure masked interrupt status register,Address offset: 0x38 */
  __IO uint32_t SCR;           /*!< TAMP status clear register,                  Address offset: 0x3C */
  __IO uint32_t COUNTR;        /*!< TAMP monotonic counter register,             Address offset: 0x40 */
       uint32_t RESERVED1[4];  /*!< Reserved,                                    Address offset: 0x43 -- 0x50 */
  __IO uint32_t ERCFGR;        /*!< TAMP erase configuration register,           Address offset: 0x54 */
       uint32_t RESERVED2[42]; /*!< Reserved,                                    Address offset: 0x58 -- 0xFC */
  __IO uint32_t BKP0R;         /*!< TAMP backup register 0,                      Address offset: 0x100 */
  __IO uint32_t BKP1R;         /*!< TAMP backup register 1,                      Address offset: 0x104 */
  __IO uint32_t BKP2R;         /*!< TAMP backup register 2,                      Address offset: 0x108 */
  __IO uint32_t BKP3R;         /*!< TAMP backup register 3,                      Address offset: 0x10C */
  __IO uint32_t BKP4R;         /*!< TAMP backup register 4,                      Address offset: 0x110 */
  __IO uint32_t BKP5R;         /*!< TAMP backup register 5,                      Address offset: 0x114 */
  __IO uint32_t BKP6R;         /*!< TAMP backup register 6,                      Address offset: 0x118 */
  __IO uint32_t BKP7R;         /*!< TAMP backup register 7,                      Address offset: 0x11C */
  __IO uint32_t BKP8R;         /*!< TAMP backup register 8,                      Address offset: 0x120 */
  __IO uint32_t BKP9R;         /*!< TAMP backup register 9,                      Address offset: 0x124 */
  __IO uint32_t BKP10R;        /*!< TAMP backup register 10,                     Address offset: 0x128 */
  __IO uint32_t BKP11R;        /*!< TAMP backup register 11,                     Address offset: 0x12C */
  __IO uint32_t BKP12R;        /*!< TAMP backup register 12,                     Address offset: 0x130 */
  __IO uint32_t BKP13R;        /*!< TAMP backup register 13,                     Address offset: 0x134 */
  __IO uint32_t BKP14R;        /*!< TAMP backup register 14,                     Address offset: 0x138 */
  __IO uint32_t BKP15R;        /*!< TAMP backup register 15,                     Address offset: 0x13C */
  __IO uint32_t BKP16R;        /*!< TAMP backup register 16,                     Address offset: 0x140 */
  __IO uint32_t BKP17R;        /*!< TAMP backup register 17,                     Address offset: 0x144 */
  __IO uint32_t BKP18R;        /*!< TAMP backup register 18,                     Address offset: 0x148 */
  __IO uint32_t BKP19R;        /*!< TAMP backup register 19,                     Address offset: 0x14C */
  __IO uint32_t BKP20R;        /*!< TAMP backup register 20,                     Address offset: 0x150 */
  __IO uint32_t BKP21R;        /*!< TAMP backup register 21,                     Address offset: 0x154 */
  __IO uint32_t BKP22R;        /*!< TAMP backup register 22,                     Address offset: 0x158 */
  __IO uint32_t BKP23R;        /*!< TAMP backup register 23,                     Address offset: 0x15C */
  __IO uint32_t BKP24R;        /*!< TAMP backup register 24,                     Address offset: 0x160 */
  __IO uint32_t BKP25R;        /*!< TAMP backup register 25,                     Address offset: 0x164 */
  __IO uint32_t BKP26R;        /*!< TAMP backup register 26,                     Address offset: 0x168 */
  __IO uint32_t BKP27R;        /*!< TAMP backup register 27,                     Address offset: 0x16C */
  __IO uint32_t BKP28R;        /*!< TAMP backup register 28,                     Address offset: 0x170 */
  __IO uint32_t BKP29R;        /*!< TAMP backup register 29,                     Address offset: 0x174 */
  __IO uint32_t BKP30R;        /*!< TAMP backup register 30,                     Address offset: 0x178 */
  __IO uint32_t BKP31R;        /*!< TAMP backup register 31,                     Address offset: 0x17C */
} TAMP_TypeDef;

/**
  * @brief Universal Synchronous Asynchronous Receiver Transmitter
  */
typedef struct
{
  __IO uint32_t CR1;         /*!< USART Control register 1,                 Address offset: 0x00  */
  __IO uint32_t CR2;         /*!< USART Control register 2,                 Address offset: 0x04  */
  __IO uint32_t CR3;         /*!< USART Control register 3,                 Address offset: 0x08  */
  __IO uint32_t BRR;         /*!< USART Baud rate register,                 Address offset: 0x0C  */
  __IO uint32_t GTPR;        /*!< USART Guard time and prescaler register,  Address offset: 0x10  */
  __IO uint32_t RTOR;        /*!< USART Receiver Time Out register,         Address offset: 0x14  */
  __IO uint32_t RQR;         /*!< USART Request register,                   Address offset: 0x18  */
  __IO uint32_t ISR;         /*!< USART Interrupt and status register,      Address offset: 0x1C  */
  __IO uint32_t ICR;         /*!< USART Interrupt flag Clear register,      Address offset: 0x20  */
  __IO uint32_t RDR;         /*!< USART Receive Data register,              Address offset: 0x24  */
  __IO uint32_t TDR;         /*!< USART Transmit Data register,             Address offset: 0x28  */
  __IO uint32_t PRESC;       /*!< USART Prescaler register,                 Address offset: 0x2C  */
  __IO uint32_t AUTOCR;      /*!< USART Autonomous mode control register    Address offset: 0x30  */
} USART_TypeDef;

/**
  * @brief Serial Audio Interface
  */
typedef struct
{
  __IO uint32_t GCR;          /*!< SAI global configuration register,        Address offset: 0x00 */
  uint32_t      RESERVED[16]; /*!< Reserved,                         Address offset: 0x04 to 0x40 */
  __IO uint32_t PDMCR;        /*!< SAI PDM control register,                 Address offset: 0x44 */
  __IO uint32_t PDMDLY;       /*!< SAI PDM delay register,                   Address offset: 0x48 */
} SAI_TypeDef;

typedef struct
{
  __IO uint32_t CR1;         /*!< SAI block x configuration register 1,     Address offset: 0x04 */
  __IO uint32_t CR2;         /*!< SAI block x configuration register 2,     Address offset: 0x08 */
  __IO uint32_t FRCR;        /*!< SAI block x frame configuration register, Address offset: 0x0C */
  __IO uint32_t SLOTR;       /*!< SAI block x slot register,                Address offset: 0x10 */
  __IO uint32_t IMR;         /*!< SAI block x interrupt mask register,      Address offset: 0x14 */
  __IO uint32_t SR;          /*!< SAI block x status register,              Address offset: 0x18 */
  __IO uint32_t CLRFR;       /*!< SAI block x clear flag register,          Address offset: 0x1C */
  __IO uint32_t DR;          /*!< SAI block x data register,                Address offset: 0x20 */
} SAI_Block_TypeDef;

/**
  * @brief System configuration controller
  */
typedef struct
{
  __IO uint32_t SECCFGR;      /*!< SYSCFG secure configuration register,            Address offset: 0x00 */
  __IO uint32_t CFGR1;        /*!< SYSCFG configuration register 1,                 Address offset: 0x04 */
  __IO uint32_t FPUIMR;       /*!< SYSCFG FPU interrupt mask register,              Address offset: 0x08 */
  __IO uint32_t CNSLCKR;      /*!< SYSCFG CPU non-secure lock register,             Address offset: 0x0C */
  __IO uint32_t CSLCKR;       /*!< SYSCFG CPU secure lock register,                 Address offset: 0x10 */
  __IO uint32_t CFGR2;        /*!< SYSCFG configuration register 2,                 Address offset: 0x14 */
  __IO uint32_t MESR;         /*!< SYSCFG Memory Erase Status register,             Address offset: 0x18 */
  __IO uint32_t CCCSR;        /*!< SYSCFG Conpensaion Cell Control&Status register, Address offset: 0x1C */
  __IO uint32_t CCVR;         /*!< SYSCFG Conpensaion Cell value register,          Address offset: 0x20 */
  __IO uint32_t CCCR;         /*!< SYSCFG Conpensaion Cell Code register,           Address offset: 0x24 */
       uint32_t RESERVED1;    /*!< RESERVED1,                                       Address offset: 0x28 */
  __IO uint32_t RSSCMDR;      /*!< SYSCFG RSS command mode register,                Address offset: 0x2C */
       uint32_t RESERVED2[17];/*!< RESERVED2,                                       Address offset: 0x30 - 0x70 */
  __IO uint32_t OTGHSPHYCR;   /*!< SYSCFG USB OTG_HS PHY register                   Address offset: 0x74 */
       uint32_t RESERVED3;    /*!< RESERVED3,                                       Address offset: 0x78 */
  __IO uint32_t OTGHSPHYTUNER2;/*!< SYSCFG USB OTG_HS PHY tune register 2            Address offset: 0x7C */
} SYSCFG_TypeDef;

/**
  * @brief Secure digital input/output Interface
  */
typedef struct
{
  __IO uint32_t POWER;          /*!< SDMMC power control register,             Address offset: 0x00  */
  __IO uint32_t CLKCR;          /*!< SDMMC clock control register,             Address offset: 0x04  */
  __IO uint32_t ARG;            /*!< SDMMC argument register,                  Address offset: 0x08  */
  __IO uint32_t CMD;            /*!< SDMMC command register,                   Address offset: 0x0C  */
  __I uint32_t  RESPCMD;        /*!< SDMMC command response register,          Address offset: 0x10  */
  __I uint32_t  RESP1;          /*!< SDMMC response 1 register,                Address offset: 0x14  */
  __I uint32_t  RESP2;          /*!< SDMMC response 2 register,                Address offset: 0x18  */
  __I uint32_t  RESP3;          /*!< SDMMC response 3 register,                Address offset: 0x1C  */
  __I uint32_t  RESP4;          /*!< SDMMC response 4 register,                Address offset: 0x20  */
  __IO uint32_t DTIMER;         /*!< SDMMC data timer register,                Address offset: 0x24  */
  __IO uint32_t DLEN;           /*!< SDMMC data length register,               Address offset: 0x28  */
  __IO uint32_t DCTRL;          /*!< SDMMC data control register,              Address offset: 0x2C  */
  __I uint32_t  DCOUNT;         /*!< SDMMC data counter register,              Address offset: 0x30  */
  __I uint32_t  STA;            /*!< SDMMC status register,                    Address offset: 0x34  */
  __IO uint32_t ICR;            /*!< SDMMC interrupt clear register,           Address offset: 0x38  */
  __IO uint32_t MASK;           /*!< SDMMC mask register,                      Address offset: 0x3C  */
  __IO uint32_t ACKTIME;        /*!< SDMMC Acknowledgement timer register,     Address offset: 0x40  */
  uint32_t      RESERVED0[3];   /*!< Reserved, 0x44 - 0x4C - 0x4C                                    */
  __IO uint32_t IDMACTRL;       /*!< SDMMC DMA control register,               Address offset: 0x50  */
  __IO uint32_t IDMABSIZE;      /*!< SDMMC DMA buffer size register,           Address offset: 0x54  */
  __IO uint32_t IDMABASER;      /*!< SDMMC DMA buffer base address register,   Address offset: 0x58  */
  uint32_t      RESERVED1[2];   /*!< Reserved, 0x60                                             */
  __IO uint32_t IDMALAR;        /*!< SDMMC DMA linked list address register,   Address offset: 0x64  */
  __IO uint32_t IDMABAR;        /*!< SDMMC DMA linked list memory base register,Address offset: 0x68 */
  uint32_t      RESERVED2[5];   /*!< Reserved, 0x6C-0x7C                                             */
  __IO uint32_t FIFO;           /*!< SDMMC data FIFO register,                 Address offset: 0x80  */
} SDMMC_TypeDef;



/**
  * @brief Delay Block DLYB
  */
typedef struct
{
  __IO uint32_t CR;          /*!< DELAY BLOCK control register,  Address offset: 0x00 */
  __IO uint32_t CFGR;        /*!< DELAY BLOCK configuration register,  Address offset: 0x04 */
} DLYB_TypeDef;

/**
  * @brief UCPD
  */
typedef struct
{
  __IO uint32_t CFG1;         /*!< UCPD configuration register 1,             Address offset: 0x00 */
  __IO uint32_t CFG2;         /*!< UCPD configuration register 2,             Address offset: 0x04 */
  __IO uint32_t CFG3;         /*!< UCPD configuration register 3,             Address offset: 0x08 */
  __IO uint32_t CR;           /*!< UCPD control register,                     Address offset: 0x0C */
  __IO uint32_t IMR;          /*!< UCPD interrupt mask register,              Address offset: 0x10 */
  __IO uint32_t SR;           /*!< UCPD status register,                      Address offset: 0x14 */
  __IO uint32_t ICR;          /*!< UCPD interrupt flag clear register         Address offset: 0x18 */
  __IO uint32_t TX_ORDSET;    /*!< UCPD Tx ordered set type register,         Address offset: 0x1C */
  __IO uint32_t TX_PAYSZ;     /*!< UCPD Tx payload size register,             Address offset: 0x20 */
  __IO uint32_t TXDR;         /*!< UCPD Tx data register,                     Address offset: 0x24 */
  __IO uint32_t RX_ORDSET;    /*!< UCPD Rx ordered set type register,         Address offset: 0x28 */
  __IO uint32_t RX_PAYSZ;     /*!< UCPD Rx payload size register,             Address offset: 0x2C */
  __IO uint32_t RXDR;         /*!< UCPD Rx data register,                     Address offset: 0x30 */
  __IO uint32_t RX_ORDEXT1;   /*!< UCPD Rx ordered set extension 1 register,  Address offset: 0x34 */
  __IO uint32_t RX_ORDEXT2;   /*!< UCPD Rx ordered set extension 2 register,  Address offset: 0x38 */
} UCPD_TypeDef;

/**
  * @brief USB_OTG_Core_register
  */
typedef struct
{
  __IO uint32_t GOTGCTL;             /*!< USB_OTG Control and Status Register,       Address offset: 000h */
  __IO uint32_t GOTGINT;             /*!< USB_OTG Interrupt Register,                Address offset: 004h */
  __IO uint32_t GAHBCFG;             /*!< Core AHB Configuration Register,           Address offset: 008h */
  __IO uint32_t GUSBCFG;             /*!< Core USB Configuration Register,           Address offset: 00Ch */
  __IO uint32_t GRSTCTL;             /*!< Core Reset Register,                       Address offset: 010h */
  __IO uint32_t GINTSTS;             /*!< Core Interrupt Register,                   Address offset: 014h */
  __IO uint32_t GINTMSK;             /*!< Core Interrupt Mask Register,              Address offset: 018h */
  __IO uint32_t GRXSTSR;             /*!< Receive Sts Q Read Register,               Address offset: 01Ch */
  __IO uint32_t GRXSTSP;             /*!< Receive Sts Q Read & POP Register,         Address offset: 020h */
  __IO uint32_t GRXFSIZ;             /*!< Receive FIFO Size Register,                Address offset: 024h */
  __IO uint32_t DIEPTXF0_HNPTXFSIZ;  /*!< EP0 / Non Periodic Tx FIFO Size Register,  Address offset: 028h */
  __IO uint32_t HNPTXSTS;            /*!< Non Periodic Tx FIFO/Queue Sts reg,        Address offset: 02Ch */
  __IO uint32_t Reserved30[2];       /*!< Reserved,                                  Address offset: 030h */
  __IO uint32_t GCCFG;               /*!< General Purpose IO Register,               Address offset: 038h */
  __IO uint32_t CID;                 /*!< User ID Register,                          Address offset: 03Ch */
  __IO uint32_t GSNPSID;             /*!< USB_OTG core ID,                           Address offset: 040h */
  __IO uint32_t GHWCFG1;             /*!< User HW config1,                           Address offset: 044h */
  __IO uint32_t GHWCFG2;             /*!< User HW config2,                           Address offset: 048h */
  __IO uint32_t GHWCFG3;             /*!< User HW config3,                           Address offset: 04Ch */
  __IO uint32_t  Reserved6;          /*!< Reserved,                                  Address offset: 050h */
  __IO uint32_t GLPMCFG;             /*!< LPM Register,                              Address offset: 054h */
  __IO uint32_t GPWRDN;              /*!< Power Down Register,                       Address offset: 058h */
  __IO uint32_t GDFIFOCFG;           /*!< DFIFO Software Config Register,            Address offset: 05Ch */
  __IO uint32_t GADPCTL;             /*!< ADP Timer, Control and Status Register,    Address offset: 60Ch */
  __IO uint32_t  Reserved43[39];     /*!< Reserved,                                  Address offset: 058h */
  __IO uint32_t HPTXFSIZ;            /*!< Host Periodic Tx FIFO Size Reg,            Address offset: 100h */
  __IO uint32_t DIEPTXF[0x0F];       /*!< dev Periodic Transmit FIFO                 Address offset: 104h */
} USB_OTG_GlobalTypeDef;

/**
  * @brief USB_OTG_device_Registers
  */
typedef struct
{
  __IO uint32_t DCFG;                /*!< dev Configuration Register,   Address offset: 800h */
  __IO uint32_t DCTL;                /*!< dev Control Register,         Address offset: 804h */
  __IO uint32_t DSTS;                /*!< dev Status Register (RO),     Address offset: 808h */
  uint32_t Reserved0C;               /*!< Reserved,                     Address offset: 80Ch */
  __IO uint32_t DIEPMSK;             /*!< dev IN Endpoint Mask,         Address offset: 810h */
  __IO uint32_t DOEPMSK;             /*!< dev OUT Endpoint Mask,        Address offset: 814h */
  __IO uint32_t DAINT;               /*!< dev All Endpoints Itr Reg,    Address offset: 818h */
  __IO uint32_t DAINTMSK;            /*!< dev All Endpoints Itr Mask,   Address offset: 81Ch */
  uint32_t  Reserved20;              /*!< Reserved,                     Address offset: 820h */
  uint32_t Reserved9;                /*!< Reserved,                     Address offset: 824h */
  __IO uint32_t DVBUSDIS;            /*!< dev VBUS discharge Register,  Address offset: 828h */
  __IO uint32_t DVBUSPULSE;          /*!< dev VBUS Pulse Register,      Address offset: 82Ch */
  __IO uint32_t DTHRCTL;             /*!< dev threshold,                Address offset: 830h */
  __IO uint32_t DIEPEMPMSK;          /*!< dev empty msk,                Address offset: 834h */
  __IO uint32_t DEACHINT;            /*!< dedicated EP interrupt,       Address offset: 838h */
  __IO uint32_t DEACHMSK;            /*!< dedicated EP msk,             Address offset: 83Ch */
  uint32_t Reserved40;               /*!< dedicated EP mask,            Address offset: 840h */
  __IO uint32_t DINEP1MSK;           /*!< dedicated EP mask,            Address offset: 844h */
  uint32_t  Reserved44[15];          /*!< Reserved,                     Address offset: 844-87Ch */
  __IO uint32_t DOUTEP1MSK;          /*!< dedicated EP msk,             Address offset: 884h */
} USB_OTG_DeviceTypeDef;


/**
  * @brief USB_OTG_IN_Endpoint-Specific_Register
  */
typedef struct
{
  __IO uint32_t DIEPCTL;             /*!< dev IN Endpoint Control Register,          Address offset: 900h + (ep_num * 20h) + 00h */
  __IO uint32_t Reserved04;          /*!< Reserved,                                  Address offset: 900h + (ep_num * 20h) + 04h */
  __IO uint32_t DIEPINT;             /*!< dev IN Endpoint Itr Register,              Address offset: 900h + (ep_num * 20h) + 08h */
  __IO uint32_t Reserved0C;          /*!< Reserved,                                  Address offset: 900h + (ep_num * 20h) + 0Ch */
  __IO uint32_t DIEPTSIZ;            /*!< IN Endpoint Txfer Size Register,           Address offset: 900h + (ep_num * 20h) + 10h */
  __IO uint32_t DIEPDMA;             /*!< IN Endpoint DMA Address Register,          Address offset: 900h + (ep_num * 20h) + 14h */
  __IO uint32_t DTXFSTS;             /*!< IN Endpoint Tx FIFO Status Register,       Address offset: 900h + (ep_num * 20h) + 18h */
  __IO uint32_t Reserved18;          /*!< Reserved,                                  Address offset: 900h + (ep_num * 20h) + 1Ch */
} USB_OTG_INEndpointTypeDef;

/**
  * @brief USB_OTG_OUT_Endpoint-Specific_Registers
  */
typedef struct
{
  __IO uint32_t DOEPCTL;             /*!< dev OUT Endpoint Control Register,         Address offset: B00h + (ep_num * 20h) + 00h */
  __IO uint32_t Reserved04;          /*!< Reserved,                                  Address offset: B00h + (ep_num * 20h) + 04h */
  __IO uint32_t DOEPINT;             /*!< dev OUT Endpoint Itr Register,             Address offset: B00h + (ep_num * 20h) + 08h */
  __IO uint32_t Reserved0C;          /*!< Reserved,                                  Address offset: B00h + (ep_num * 20h) + 0Ch */
  __IO uint32_t DOEPTSIZ;            /*!< dev OUT Endpoint Txfer Size Register,      Address offset: B00h + (ep_num * 20h) + 10h */
  __IO uint32_t DOEPDMA;             /*!< dev OUT Endpoint DMA Address Register,     Address offset: B00h + (ep_num * 20h) + 14h */
  __IO uint32_t Reserved18[2];       /*!< Reserved,                                  Address offset: B00h + (ep_num * 20h) + 18h */
} USB_OTG_OUTEndpointTypeDef;

/**
  * @brief USB_OTG_Host_Mode_Register_Structures
  */
typedef struct
{
  __IO uint32_t HCFG;                 /*!< Host Configuration Register,              Address offset: 400h */
  __IO uint32_t HFIR;                 /*!< Host Frame Interval Register,             Address offset: 404h */
  __IO uint32_t HFNUM;                /*!< Host Frame Nbr/Frame Remaining,           Address offset: 408h */
  uint32_t Reserved40C;               /*!< Reserved,                                 Address offset: 40Ch */
  __IO uint32_t HPTXSTS;              /*!< Host Periodic Tx FIFO/ Queue Status,      Address offset: 410h */
  __IO uint32_t HAINT;                /*!< Host All Channels Interrupt Register,     Address offset: 414h */
  __IO uint32_t HAINTMSK;             /*!< Host All Channels Interrupt Mask,         Address offset: 418h */
} USB_OTG_HostTypeDef;

/**
  * @brief USB_OTG_Host_Channel_Specific_Registers
  */
typedef struct
{
  __IO uint32_t HCCHAR;               /*!< Host Channel Characteristics Register,    Address offset: 500h */
  __IO uint32_t HCSPLT;               /*!< Host Channel Split Control Register,      Address offset: 504h */
  __IO uint32_t HCINT;                /*!< Host Channel Interrupt Register,          Address offset: 508h */
  __IO uint32_t HCINTMSK;             /*!< Host Channel Interrupt Mask Register,     Address offset: 50Ch */
  __IO uint32_t HCTSIZ;               /*!< Host Channel Transfer Size Register,      Address offset: 510h */
  __IO uint32_t HCDMA;                /*!< Host Channel DMA Address Register,        Address offset: 514h */
  uint32_t Reserved[2];               /*!< Reserved,                                 Address offset: 518h */
} USB_OTG_HostChannelTypeDef;

/**
  * @brief FD Controller Area Network
  */
typedef struct
{
  __IO uint32_t CREL;         /*!< FDCAN Core Release register,                                     Address offset: 0x000 */
  __IO uint32_t ENDN;         /*!< FDCAN Endian register,                                           Address offset: 0x004 */
       uint32_t RESERVED1;    /*!< Reserved,                                                                        0x008 */
  __IO uint32_t DBTP;         /*!< FDCAN Data Bit Timing & Prescaler register,                      Address offset: 0x00C */
  __IO uint32_t TEST;         /*!< FDCAN Test register,                                             Address offset: 0x010 */
  __IO uint32_t RWD;          /*!< FDCAN RAM Watchdog register,                                     Address offset: 0x014 */
  __IO uint32_t CCCR;         /*!< FDCAN CC Control register,                                       Address offset: 0x018 */
  __IO uint32_t NBTP;         /*!< FDCAN Nominal Bit Timing & Prescaler register,                   Address offset: 0x01C */
  __IO uint32_t TSCC;         /*!< FDCAN Timestamp Counter Configuration register,                  Address offset: 0x020 */
  __IO uint32_t TSCV;         /*!< FDCAN Timestamp Counter Value register,                          Address offset: 0x024 */
  __IO uint32_t TOCC;         /*!< FDCAN Timeout Counter Configuration register,                    Address offset: 0x028 */
  __IO uint32_t TOCV;         /*!< FDCAN Timeout Counter Value register,                            Address offset: 0x02C */
       uint32_t RESERVED2[4]; /*!< Reserved,                                                                0x030 - 0x03C */
  __IO uint32_t ECR;          /*!< FDCAN Error Counter register,                                    Address offset: 0x040 */
  __IO uint32_t PSR;          /*!< FDCAN Protocol Status register,                                  Address offset: 0x044 */
  __IO uint32_t TDCR;         /*!< FDCAN Transmitter Delay Compensation register,                   Address offset: 0x048 */
       uint32_t RESERVED3;    /*!< Reserved,                                                                        0x04C */
  __IO uint32_t IR;           /*!< FDCAN Interrupt register,                                        Address offset: 0x050 */
  __IO uint32_t IE;           /*!< FDCAN Interrupt Enable register,                                 Address offset: 0x054 */
  __IO uint32_t ILS;          /*!< FDCAN Interrupt Line Select register,                            Address offset: 0x058 */
  __IO uint32_t ILE;          /*!< FDCAN Interrupt Line Enable register,                            Address offset: 0x05C */
       uint32_t RESERVED4[8]; /*!< Reserved,                                                                0x060 - 0x07C */
  __IO uint32_t RXGFC;        /*!< FDCAN Global Filter Configuration register,                      Address offset: 0x080 */
  __IO uint32_t XIDAM;        /*!< FDCAN Extended ID AND Mask register,                             Address offset: 0x084 */
  __IO uint32_t HPMS;         /*!< FDCAN High Priority Message Status register,                     Address offset: 0x088 */
       uint32_t RESERVED5;    /*!< Reserved,                                                                        0x08C */
  __IO uint32_t RXF0S;        /*!< FDCAN Rx FIFO 0 Status register,                                 Address offset: 0x090 */
  __IO uint32_t RXF0A;        /*!< FDCAN Rx FIFO 0 Acknowledge register,                            Address offset: 0x094 */
  __IO uint32_t RXF1S;        /*!< FDCAN Rx FIFO 1 Status register,                                 Address offset: 0x098 */
  __IO uint32_t RXF1A;        /*!< FDCAN Rx FIFO 1 Acknowledge register,                            Address offset: 0x09C */
       uint32_t RESERVED6[8]; /*!< Reserved,                                                                0x0A0 - 0x0BC */
  __IO uint32_t TXBC;         /*!< FDCAN Tx Buffer Configuration register,                          Address offset: 0x0C0 */
  __IO uint32_t TXFQS;        /*!< FDCAN Tx FIFO/Queue Status register,                             Address offset: 0x0C4 */
  __IO uint32_t TXBRP;        /*!< FDCAN Tx Buffer Request Pending register,                        Address offset: 0x0C8 */
  __IO uint32_t TXBAR;        /*!< FDCAN Tx Buffer Add Request register,                            Address offset: 0x0CC */
  __IO uint32_t TXBCR;        /*!< FDCAN Tx Buffer Cancellation Request register,                   Address offset: 0x0D0 */
  __IO uint32_t TXBTO;        /*!< FDCAN Tx Buffer Transmission Occurred register,                  Address offset: 0x0D4 */
  __IO uint32_t TXBCF;        /*!< FDCAN Tx Buffer Cancellation Finished register,                  Address offset: 0x0D8 */
  __IO uint32_t TXBTIE;       /*!< FDCAN Tx Buffer Transmission Interrupt Enable register,          Address offset: 0x0DC */
  __IO uint32_t TXBCIE;       /*!< FDCAN Tx Buffer Cancellation Finished Interrupt Enable register, Address offset: 0x0E0 */
  __IO uint32_t TXEFS;        /*!< FDCAN Tx Event FIFO Status register,                             Address offset: 0x0E4 */
  __IO uint32_t TXEFA;        /*!< FDCAN Tx Event FIFO Acknowledge register,                        Address offset: 0x0E8 */
} FDCAN_GlobalTypeDef;

/**
  * @brief FD Controller Area Network Configuration
  */
typedef struct
{
  __IO uint32_t CKDIV;        /*!< FDCAN clock divider register,                            Address offset: 0x100 + 0x000 */
       uint32_t RESERVED1[128];/*!< Reserved,                                               0x100 + 0x004 - 0x100 + 0x200 */
  __IO uint32_t OPTR;         /*!< FDCAN option register,                                   Address offset: 0x100 + 0x204 */
       uint32_t RESERVED2[58];/*!< Reserved,                                                0x100 + 0x208 - 0x100 + 0x2EC */
  __IO uint32_t HWCFG;        /*!< FDCAN hardware configuration register,                   Address offset: 0x100 + 0x2F0 */
  __IO uint32_t VERR;         /*!< FDCAN IP version register,                               Address offset: 0x100 + 0x2F4 */
  __IO uint32_t IPIDR;        /*!< FDCAN IP ID register,                                    Address offset: 0x100 + 0x2F8 */
  __IO uint32_t SIDR;         /*!< FDCAN size ID register,                                  Address offset: 0x100 + 0x2FC */
} FDCAN_Config_TypeDef;

/**
  * @brief Flexible Memory Controller
  */
typedef struct
{
  __IO uint32_t BTCR[8];     /*!< NOR/PSRAM chip-select control register(BCR) and chip-select timing register(BTR), Address offset: 0x00-1C */
  __IO uint32_t PCSCNTR;     /*!< PSRAM chip-select counter register,                                               Address offset:    0x20 */
} FMC_Bank1_TypeDef;

/**
  * @brief Flexible Memory Controller Bank1E
  */
typedef struct
{
  __IO uint32_t BWTR[7];     /*!< NOR/PSRAM write timing registers, Address offset: 0x104-0x11C */
} FMC_Bank1E_TypeDef;

/**
  * @brief Flexible Memory Controller Bank3
  */
typedef struct
{
  __IO uint32_t PCR;        /*!< NAND Flash control register,                       Address offset: 0x80 */
  __IO uint32_t SR;         /*!< NAND Flash FIFO status and interrupt register,     Address offset: 0x84 */
  __IO uint32_t PMEM;       /*!< NAND Flash Common memory space timing register,    Address offset: 0x88 */
  __IO uint32_t PATT;       /*!< NAND Flash Attribute memory space timing register, Address offset: 0x8C */
  uint32_t      RESERVED0;  /*!< Reserved, 0x90                                                            */
  __IO uint32_t ECCR;       /*!< NAND Flash ECC result registers,                   Address offset: 0x94 */
} FMC_Bank3_TypeDef;

/**
  * @brief VREFBUF
  */
typedef struct
{
  __IO uint32_t CSR;         /*!< VREFBUF control and status register,         Address offset: 0x00 */
  __IO uint32_t CCR;         /*!< VREFBUF calibration and control register,    Address offset: 0x04 */
} VREFBUF_TypeDef;

/**
  * @brief ADC
  */
typedef struct
{
  __IO uint32_t ISR;              /*!< ADC Interrupt and Status Register,                 Address offset: 0x00 */
  __IO uint32_t IER;              /*!< ADC Interrupt Enable Register,                     Address offset: 0x04 */
  __IO uint32_t CR;               /*!< ADC control register,                              Address offset: 0x08 */
  __IO uint32_t CFGR1;            /*!< ADC Configuration register,                        Address offset: 0x0C */
  __IO uint32_t CFGR2;            /*!< ADC Configuration register 2,                      Address offset: 0x10 */
  __IO uint32_t SMPR1;            /*!< ADC sample time register 1,                        Address offset: 0x14 */
  __IO uint32_t SMPR2;            /*!< ADC sample time register 2,                        Address offset: 0x18 */ /* Specific to ADC 14Bits*/
  __IO uint32_t PCSEL;            /*!< ADC pre-channel selection,                         Address offset: 0x1C */
  __IO uint32_t AWD1TR;           /*!< ADC watchdog threshold register,                   Address offset: 0x20 */ /* Specific to ADC 12Bits*/
  __IO uint32_t AWD2TR;           /*!< ADC watchdog threshold register,                   Address offset: 0x24 */ /* Specific to ADC 12Bits*/
  __IO uint32_t CHSELR;           /*!< ADC channel select register,                       Address offset: 0x28 */ /* Specific to ADC 12Bits*/
  __IO uint32_t AWD3TR;           /*!< ADC watchdog threshold register,                   Address offset: 0x2C */ /* Specific to ADC 12Bits*/
  __IO uint32_t SQR1;             /*!< ADC regular sequence register 1,                   Address offset: 0x30 */ /* Specific to ADC 14Bits*/
  __IO uint32_t SQR2;             /*!< ADC regular sequence register 2,                   Address offset: 0x34 */ /* Specific to ADC 14Bits*/
  __IO uint32_t SQR3;             /*!< ADC regular sequence register 3,                   Address offset: 0x38 */ /* Specific to ADC 14Bits*/
  __IO uint32_t SQR4;             /*!< ADC regular sequence register 4,                   Address offset: 0x3C */ /* Specific to ADC 14Bits*/
  __IO uint32_t DR;               /*!< ADC regular data register,                         Address offset: 0x40 */
  __IO uint32_t PWRR;             /*!< ADC power register,                                Address offset: 0x44 */
  uint32_t      RESERVED1;        /*!< Reserved, 0x048                                                         */
  __IO uint32_t JSQR;             /*!< ADC injected sequence register,                    Address offset: 0x4C */ /* Specific to ADC 14Bits*/
  uint32_t      RESERVED2[4];     /*!< Reserved, 0x050 - 0x05C                                                 */
  __IO uint32_t OFR1;             /*!< ADC offset register 1,                             Address offset: 0x60 */ /* Specific to ADC 14Bits*/
  __IO uint32_t OFR2;             /*!< ADC offset register 2,                             Address offset: 0x64 */ /* Specific to ADC 14Bits*/
  __IO uint32_t OFR3;             /*!< ADC offset register 3,                             Address offset: 0x68 */ /* Specific to ADC 14Bits*/
  __IO uint32_t OFR4;             /*!< ADC offset register 4,                             Address offset: 0x6C */ /* Specific to ADC 14Bits*/
  __IO uint32_t GCOMP;            /*!< ADC gain compensation register,                    Address offset: 0x70 */ /* Specific to ADC 14Bits*/
  uint32_t      RESERVED3[3];     /*!< Reserved, 0x074 - 0x07C                                                 */
  __IO uint32_t JDR1;             /*!< ADC injected data register 1,                      Address offset: 0x80 */ /* Specific to ADC 14Bits*/
  __IO uint32_t JDR2;             /*!< ADC injected data register 2,                      Address offset: 0x84 */ /* Specific to ADC 14Bits*/
  __IO uint32_t JDR3;             /*!< ADC injected data register 3,                      Address offset: 0x88 */ /* Specific to ADC 14Bits*/
  __IO uint32_t JDR4;             /*!< ADC injected data register 4,                      Address offset: 0x8C */ /* Specific to ADC 14Bits*/
  uint32_t      RESERVED4[4];     /*!< Reserved, 0x090 - 0x09C                                                 */
  __IO uint32_t AWD2CR;           /*!< ADC  Analog Watchdog 2 Configuration Register,     Address offset: 0xA0 */
  __IO uint32_t AWD3CR;           /*!< ADC  Analog Watchdog 3 Configuration Register,     Address offset: 0xA4 */
  __IO uint32_t LTR1;             /*!< ADC watchdog Lower threshold register 1,           Address offset: 0xA8 */ /* Specific to ADC 14Bits*/
  __IO uint32_t HTR1;             /*!< ADC watchdog higher threshold register 1,          Address offset: 0xAC */ /* Specific to ADC 14Bits*/
  __IO uint32_t LTR2;             /*!< ADC watchdog Lower threshold register 2,           Address offset: 0xB0 */ /* Specific to ADC 14Bits*/
  __IO uint32_t HTR2;             /*!< ADC watchdog Higher threshold register 2,          Address offset: 0xB4 */ /* Specific to ADC 14Bits*/
  __IO uint32_t LTR3;             /*!< ADC watchdog Lower threshold register 3,           Address offset: 0xB8 */ /* Specific to ADC 14Bits*/
  __IO uint32_t HTR3;             /*!< ADC watchdog Higher threshold register 3,          Address offset: 0xBC */ /* Specific to ADC 14Bits*/
  __IO uint32_t DIFSEL;           /*!< ADC  Differential Mode Selection Register,         Address offset: 0xC0 */ /* Specific to ADC 14Bits*/
  __IO uint32_t CALFACT;          /*!< ADC  Calibration Factors,                          Address offset: 0xC4 */
  __IO uint32_t CALFACT2;         /*!< ADC  Linearity Calibration Factors,                Address offset: 0xC8 */ /* Specific to ADC 14Bits*/
  uint32_t      RESERVED5;        /*!< Reserved, 0x0CC                                                         */
  __IO uint32_t OR;               /*!< ADC  Option Register,                              Address offset: 0xD0 */  /* Specific to ADC 12Bits*/
} ADC_TypeDef;

typedef struct
{
  __IO uint32_t CSR;            /*!< ADC common status register,                         Address offset: 0x300 */
  uint32_t RESERVED;            /*!< Reserved,                                           Address offset: 0x304 */
  __IO uint32_t CCR;            /*!< ADC common control register,                        Address offset: 0x308 */
  __IO uint32_t CDR;            /*!< ADC common regular data register for dual mode,         Address offset: 0x30C */
  __IO uint32_t CDR2;           /*!< ADC common regular data register for 32-bit dual mode,  Address offset: 0x310 */
} ADC_Common_TypeDef;


/* Legacy registers naming */
#define PW      PWRR

/**
  * @brief CORDIC
  */
typedef struct
{
  __IO uint32_t CSR;           /*!< CORDIC control and status register,        Address offset: 0x00 */
  __IO uint32_t WDATA;         /*!< CORDIC argument register,                  Address offset: 0x04 */
  __IO uint32_t RDATA;         /*!< CORDIC result register,                    Address offset: 0x08 */
} CORDIC_TypeDef;

/**
  * @brief IWDG
  */
typedef struct
{
  __IO uint32_t KR;            /*!< IWDG Key register,          Address offset: 0x00 */
  __IO uint32_t PR;            /*!< IWDG Prescaler register,    Address offset: 0x04 */
  __IO uint32_t RLR;           /*!< IWDG Reload register,       Address offset: 0x08 */
  __IO uint32_t SR;            /*!< IWDG Status register,       Address offset: 0x0C */
  __IO uint32_t WINR;          /*!< IWDG Window register,       Address offset: 0x10 */
  __IO uint32_t EWCR;          /*!< IWDG Early Wakeup register, Address offset: 0x14 */
} IWDG_TypeDef;

/**
  * @brief SPI
  */
typedef struct
{
  __IO uint32_t CR1;           /*!< SPI/I2S Control register 1,                      Address offset: 0x00 */
  __IO uint32_t CR2;           /*!< SPI Control register 2,                          Address offset: 0x04 */
  __IO uint32_t CFG1;          /*!< SPI Configuration register 1,                    Address offset: 0x08 */
  __IO uint32_t CFG2;          /*!< SPI Configuration register 2,                    Address offset: 0x0C */
  __IO uint32_t IER;           /*!< SPI Interrupt Enable register,                   Address offset: 0x10 */
  __IO uint32_t SR;            /*!< SPI Status register,                             Address offset: 0x14 */
  __IO uint32_t IFCR;          /*!< SPI Interrupt/Status Flags Clear register,       Address offset: 0x18 */
  __IO uint32_t AUTOCR;        /*!< SPI Autonomous Mode Control register,            Address offset: 0x1C */
  __IO uint32_t TXDR;          /*!< SPI Transmit data register,                      Address offset: 0x20 */
  uint32_t      RESERVED1[3];  /*!< Reserved, 0x24-0x2C                                                   */
  __IO uint32_t RXDR;          /*!< SPI/I2S data register,                           Address offset: 0x30 */
  uint32_t      RESERVED2[3];  /*!< Reserved, 0x34-0x3C                                                   */
  __IO uint32_t CRCPOLY;       /*!< SPI CRC Polynomial register,                     Address offset: 0x40 */
  __IO uint32_t TXCRC;         /*!< SPI Transmitter CRC register,                    Address offset: 0x44 */
  __IO uint32_t RXCRC;         /*!< SPI Receiver CRC register,                       Address offset: 0x48 */
  __IO uint32_t UDRDR;         /*!< SPI Underrun data register,                      Address offset: 0x4C */
} SPI_TypeDef;

/**
  * @brief Touch Sensing Controller (TSC)
  */

typedef struct
{
  __IO uint32_t CR;          /*!< TSC control register,                                     Address offset: 0x00 */
  __IO uint32_t IER;         /*!< TSC interrupt enable register,                            Address offset: 0x04 */
  __IO uint32_t ICR;         /*!< TSC interrupt clear register,                             Address offset: 0x08 */
  __IO uint32_t ISR;         /*!< TSC interrupt status register,                            Address offset: 0x0C */
  __IO uint32_t IOHCR;       /*!< TSC I/O hysteresis control register,                      Address offset: 0x10 */
  uint32_t      RESERVED1;   /*!< Reserved,                                                 Address offset: 0x14 */
  __IO uint32_t IOASCR;      /*!< TSC I/O analog switch control register,                   Address offset: 0x18 */
  uint32_t      RESERVED2;   /*!< Reserved,                                                 Address offset: 0x1C */
  __IO uint32_t IOSCR;       /*!< TSC I/O sampling control register,                        Address offset: 0x20 */
  uint32_t      RESERVED3;   /*!< Reserved,                                                 Address offset: 0x24 */
  __IO uint32_t IOCCR;       /*!< TSC I/O channel control register,                         Address offset: 0x28 */
  uint32_t      RESERVED4;   /*!< Reserved,                                                 Address offset: 0x2C */
  __IO uint32_t IOGCSR;      /*!< TSC I/O group control status register,                    Address offset: 0x30 */
  __IO uint32_t IOGXCR[8];   /*!< TSC I/O group x counter register,                         Address offset: 0x34-50 */
} TSC_TypeDef;

/**
  * @brief WWDG
  */
typedef struct
{
  __IO uint32_t CR;          /*!< WWDG Control register,       Address offset: 0x00 */
  __IO uint32_t CFR;         /*!< WWDG Configuration register, Address offset: 0x04 */
  __IO uint32_t SR;          /*!< WWDG Status register,        Address offset: 0x08 */
} WWDG_TypeDef;

/*@}*/ /* end of group STM32U5xx_peripherals */


/* --------  End of section using anonymous unions and disabling warnings  -------- */
#if   defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup STM32U5xx_Peripheral_peripheralAddr
  * @{
  */

/* Internal SRAMs size */
#define SRAM1_SIZE               (0xC0000UL)    /*!< SRAM1=768k */
#define SRAM2_SIZE               (0x10000UL)    /*!< SRAM2=64k  */
#define SRAM3_SIZE               (0xD0000UL)    /*!< SRAM3=832k */
#define SRAM4_SIZE               (0x04000UL)    /*!< SRAM4=16k  */
#define SRAM5_SIZE               (0xD0000UL)    /*!< SRAM5=832k */
#define SRAM6_SIZE               (0x80000UL)    /*!< SRAM6=512k */

/* External memories base addresses - Not aliased */
#define FMC_BASE                 (0x60000000UL) /*!< FMC base address                                   */
#define OCTOSPI2_BASE            (0x70000000UL) /*!< OCTOSPI2 memories accessible over AHB base address */
#define OCTOSPI1_BASE            (0x90000000UL) /*!< OCTOSPI1 memories accessible over AHB base address */
#define HSPI1_BASE               (0xA0000000UL) /*!< HSPI1 memories accessible over AHB base address    */

#define FMC_BANK1                FMC_BASE
#define FMC_BANK1_1              FMC_BANK1
#define FMC_BANK1_2              (FMC_BANK1 + 0x04000000UL)
#define FMC_BANK1_3              (FMC_BANK1 + 0x08000000UL)
#define FMC_BANK1_4              (FMC_BANK1 + 0x0C000000UL)
#define FMC_BANK3                (FMC_BASE  + 0x20000000UL)

/* Flash, Peripheral and internal SRAMs base addresses - Non secure */
#define FLASH_BASE_NS            (0x08000000UL) /*!< FLASH (4 MB) non-secure base address               */
#define SRAM1_BASE_NS            (0x20000000UL) /*!< SRAM1 (768 KB) non-secure base address             */
#define SRAM2_BASE_NS            (0x200C0000UL) /*!< SRAM2 (64 KB) non-secure base address              */
#define SRAM3_BASE_NS            (0x200D0000UL) /*!< SRAM3 (832 KB) non-secure base address             */
#define SRAM4_BASE_NS            (0x28000000UL) /*!< SRAM4 (16 KB) non-secure base address              */
#define SRAM5_BASE_NS            (0x201A0000UL) /*!< SRAM5 (832 KB) non-secure base address             */
#define SRAM6_BASE_NS            (0x20270000UL) /*!< SRAM6 (512 KB) non-secure base address             */
#define PERIPH_BASE_NS           (0x40000000UL) /*!< Peripheral non-secure base address                 */

/* Peripheral memory map - Non secure */
#define APB1PERIPH_BASE_NS       PERIPH_BASE_NS
#define APB2PERIPH_BASE_NS       (PERIPH_BASE_NS + 0x00010000UL)
#define AHB1PERIPH_BASE_NS       (PERIPH_BASE_NS + 0x00020000UL)
#define AHB2PERIPH_BASE_NS       (PERIPH_BASE_NS + 0x02020000UL)
#define APB3PERIPH_BASE_NS       (PERIPH_BASE_NS + 0x06000000UL)
#define AHB3PERIPH_BASE_NS       (PERIPH_BASE_NS + 0x06020000UL)

/*!< APB1 Non secure peripherals */
#define TIM2_BASE_NS             (APB1PERIPH_BASE_NS + 0x0000UL)
#define TIM3_BASE_NS             (APB1PERIPH_BASE_NS + 0x0400UL)
#define TIM4_BASE_NS             (APB1PERIPH_BASE_NS + 0x0800UL)
#define TIM5_BASE_NS             (APB1PERIPH_BASE_NS + 0x0C00UL)
#define TIM6_BASE_NS             (APB1PERIPH_BASE_NS + 0x1000UL)
#define TIM7_BASE_NS             (APB1PERIPH_BASE_NS + 0x1400UL)
#define WWDG_BASE_NS             (APB1PERIPH_BASE_NS + 0x2C00UL)
#define IWDG_BASE_NS             (APB1PERIPH_BASE_NS + 0x3000UL)
#define SPI2_BASE_NS             (APB1PERIPH_BASE_NS + 0x3800UL)
#define USART2_BASE_NS           (APB1PERIPH_BASE_NS + 0x4400UL)
#define USART3_BASE_NS           (APB1PERIPH_BASE_NS + 0x4800UL)
#define UART4_BASE_NS            (APB1PERIPH_BASE_NS + 0x4C00UL)
#define UART5_BASE_NS            (APB1PERIPH_BASE_NS + 0x5000UL)
#define I2C1_BASE_NS             (APB1PERIPH_BASE_NS + 0x5400UL)
#define I2C2_BASE_NS             (APB1PERIPH_BASE_NS + 0x5800UL)
#define CRS_BASE_NS              (APB1PERIPH_BASE_NS + 0x6000UL)
#define USART6_BASE_NS           (APB1PERIPH_BASE_NS + 0x6400UL)
#define I2C4_BASE_NS             (APB1PERIPH_BASE_NS + 0x8400UL)
#define LPTIM2_BASE_NS           (APB1PERIPH_BASE_NS + 0x9400UL)
#define I2C5_BASE_NS             (APB1PERIPH_BASE_NS + 0x9800UL)
#define I2C6_BASE_NS             (APB1PERIPH_BASE_NS + 0x9C00UL)
#define FDCAN1_BASE_NS           (APB1PERIPH_BASE_NS + 0xA400UL)
#define FDCAN_CONFIG_BASE_NS     (APB1PERIPH_BASE_NS + 0xA500UL)
#define SRAMCAN_BASE_NS          (APB1PERIPH_BASE_NS + 0xAC00UL)
#define UCPD1_BASE_NS            (APB1PERIPH_BASE_NS + 0xDC00UL)

/*!< APB2 Non secure peripherals */
#define TIM1_BASE_NS             (APB2PERIPH_BASE_NS + 0x2C00UL)
#define SPI1_BASE_NS             (APB2PERIPH_BASE_NS + 0x3000UL)
#define TIM8_BASE_NS             (APB2PERIPH_BASE_NS + 0x3400UL)
#define USART1_BASE_NS           (APB2PERIPH_BASE_NS + 0x3800UL)
#define TIM15_BASE_NS            (APB2PERIPH_BASE_NS + 0x4000UL)
#define TIM16_BASE_NS            (APB2PERIPH_BASE_NS + 0x4400UL)
#define TIM17_BASE_NS            (APB2PERIPH_BASE_NS + 0x4800UL)
#define SAI1_BASE_NS             (APB2PERIPH_BASE_NS + 0x5400UL)
#define SAI1_Block_A_BASE_NS     (SAI1_BASE_NS + 0x004UL)
#define SAI1_Block_B_BASE_NS     (SAI1_BASE_NS + 0x024UL)
#define SAI2_BASE_NS             (APB2PERIPH_BASE_NS + 0x5800UL)
#define SAI2_Block_A_BASE_NS     (SAI2_BASE_NS + 0x004UL)
#define SAI2_Block_B_BASE_NS     (SAI2_BASE_NS + 0x024UL)
#define LTDC_BASE_NS             (APB2PERIPH_BASE_NS + 0x6800UL)
#define LTDC_Layer1_BASE_NS      (LTDC_BASE_NS + 0x0084UL)
#define LTDC_Layer2_BASE_NS      (LTDC_BASE_NS + 0x0104UL)
#define GFXTIM_BASE_NS           (APB2PERIPH_BASE_NS + 0x6400UL)

/*!< APB3 Non secure peripherals */
#define SYSCFG_BASE_NS           (APB3PERIPH_BASE_NS + 0x0400UL)
#define SPI3_BASE_NS             (APB3PERIPH_BASE_NS + 0x2000UL)
#define LPUART1_BASE_NS          (APB3PERIPH_BASE_NS + 0x2400UL)
#define I2C3_BASE_NS             (APB3PERIPH_BASE_NS + 0x2800UL)
#define LPTIM1_BASE_NS           (APB3PERIPH_BASE_NS + 0x4400UL)
#define LPTIM3_BASE_NS           (APB3PERIPH_BASE_NS + 0x4800UL)
#define LPTIM4_BASE_NS           (APB3PERIPH_BASE_NS + 0x4C00UL)
#define OPAMP_BASE_NS            (APB3PERIPH_BASE_NS + 0x5000UL)
#define OPAMP1_BASE_NS           (APB3PERIPH_BASE_NS + 0x5000UL)
#define OPAMP2_BASE_NS           (APB3PERIPH_BASE_NS + 0x5010UL)
#define COMP12_BASE_NS           (APB3PERIPH_BASE_NS + 0x5400UL)
#define COMP1_BASE_NS            (COMP12_BASE_NS)
#define COMP2_BASE_NS            (COMP12_BASE_NS + 0x04UL)
#define VREFBUF_BASE_NS          (APB3PERIPH_BASE_NS + 0x7400UL)
#define RTC_BASE_NS              (APB3PERIPH_BASE_NS + 0x7800UL)
#define TAMP_BASE_NS             (APB3PERIPH_BASE_NS + 0x7C00UL)

/*!< AHB1 Non secure peripherals */
#define GPDMA1_BASE_NS           (AHB1PERIPH_BASE_NS)
#define GPDMA1_Channel0_BASE_NS  (GPDMA1_BASE_NS + 0x0050UL)
#define GPDMA1_Channel1_BASE_NS  (GPDMA1_BASE_NS + 0x00D0UL)
#define GPDMA1_Channel2_BASE_NS  (GPDMA1_BASE_NS + 0x0150UL)
#define GPDMA1_Channel3_BASE_NS  (GPDMA1_BASE_NS + 0x01D0UL)
#define GPDMA1_Channel4_BASE_NS  (GPDMA1_BASE_NS + 0x0250UL)
#define GPDMA1_Channel5_BASE_NS  (GPDMA1_BASE_NS + 0x02D0UL)
#define GPDMA1_Channel6_BASE_NS  (GPDMA1_BASE_NS + 0x0350UL)
#define GPDMA1_Channel7_BASE_NS  (GPDMA1_BASE_NS + 0x03D0UL)
#define GPDMA1_Channel8_BASE_NS  (GPDMA1_BASE_NS + 0x0450UL)
#define GPDMA1_Channel9_BASE_NS  (GPDMA1_BASE_NS + 0x04D0UL)
#define GPDMA1_Channel10_BASE_NS (GPDMA1_BASE_NS + 0x0550UL)
#define GPDMA1_Channel11_BASE_NS (GPDMA1_BASE_NS + 0x05D0UL)
#define GPDMA1_Channel12_BASE_NS (GPDMA1_BASE_NS + 0x0650UL)
#define GPDMA1_Channel13_BASE_NS (GPDMA1_BASE_NS + 0x06D0UL)
#define GPDMA1_Channel14_BASE_NS (GPDMA1_BASE_NS + 0x0750UL)
#define GPDMA1_Channel15_BASE_NS (GPDMA1_BASE_NS + 0x07D0UL)
#define CORDIC_BASE_NS           (AHB1PERIPH_BASE_NS + 0x01000UL)
#define FMAC_BASE_NS             (AHB1PERIPH_BASE_NS + 0x01400UL)
#define FLASH_R_BASE_NS          (AHB1PERIPH_BASE_NS + 0x02000UL)
#define CRC_BASE_NS              (AHB1PERIPH_BASE_NS + 0x03000UL)
#define TSC_BASE_NS              (AHB1PERIPH_BASE_NS + 0x04000UL)
#define MDF1_BASE_NS             (AHB1PERIPH_BASE_NS + 0x05000UL)
#define MDF1_Filter0_BASE_NS     (MDF1_BASE_NS + 0x80UL)
#define MDF1_Filter1_BASE_NS     (MDF1_BASE_NS + 0x100UL)
#define MDF1_Filter2_BASE_NS     (MDF1_BASE_NS + 0x180UL)
#define MDF1_Filter3_BASE_NS     (MDF1_BASE_NS + 0x200UL)
#define MDF1_Filter4_BASE_NS     (MDF1_BASE_NS + 0x280UL)
#define MDF1_Filter5_BASE_NS     (MDF1_BASE_NS + 0x300UL)
#define RAMCFG_BASE_NS           (AHB1PERIPH_BASE_NS + 0x06000UL)
#define RAMCFG_SRAM1_BASE_NS     (RAMCFG_BASE_NS)
#define RAMCFG_SRAM2_BASE_NS     (RAMCFG_BASE_NS + 0x0040UL)
#define RAMCFG_SRAM3_BASE_NS     (RAMCFG_BASE_NS + 0x0080UL)
#define RAMCFG_SRAM4_BASE_NS     (RAMCFG_BASE_NS + 0x00C0UL)
#define RAMCFG_BKPRAM_BASE_NS    (RAMCFG_BASE_NS + 0x0100UL)
#define RAMCFG_SRAM5_BASE_NS     (RAMCFG_BASE_NS + 0x0140UL)
#define RAMCFG_SRAM6_BASE_NS     (RAMCFG_BASE_NS + 0x0180UL)
#define JPEG_BASE_NS             (AHB1PERIPH_BASE_NS + 0x0A000UL)
#define DMA2D_BASE_NS            (AHB1PERIPH_BASE_NS + 0x0B000UL)
#define GFXMMU_BASE_NS           (AHB1PERIPH_BASE_NS + 0x0C000UL)
#define GPU2D_BASE_NS            (AHB1PERIPH_BASE_NS + 0x0F000UL)
#define ICACHE_BASE_NS           (AHB1PERIPH_BASE_NS + 0x10400UL)
#define DCACHE1_BASE_NS          (AHB1PERIPH_BASE_NS + 0x11400UL)
#define DCACHE2_BASE_NS          (AHB1PERIPH_BASE_NS + 0x11800UL)
#define GTZC_TZSC1_BASE_NS       (AHB1PERIPH_BASE_NS + 0x12400UL)
#define GTZC_TZIC1_BASE_NS       (AHB1PERIPH_BASE_NS + 0x12800UL)
#define GTZC_MPCBB1_BASE_NS      (AHB1PERIPH_BASE_NS + 0x12C00UL)
#define GTZC_MPCBB2_BASE_NS      (AHB1PERIPH_BASE_NS + 0x13000UL)
#define GTZC_MPCBB3_BASE_NS      (AHB1PERIPH_BASE_NS + 0x13400UL)
#define GTZC_MPCBB5_BASE_NS      (AHB1PERIPH_BASE_NS + 0x13800UL)
#define GTZC_MPCBB6_BASE_NS      (AHB1PERIPH_BASE_NS + 0x13C00UL)
#define BKPSRAM_BASE_NS          (AHB1PERIPH_BASE_NS + 0x16400UL)

/*!< AHB2 Non secure peripherals */
#define GPIOA_BASE_NS            (AHB2PERIPH_BASE_NS + 0x00000UL)
#define GPIOB_BASE_NS            (AHB2PERIPH_BASE_NS + 0x00400UL)
#define GPIOC_BASE_NS            (AHB2PERIPH_BASE_NS + 0x00800UL)
#define GPIOD_BASE_NS            (AHB2PERIPH_BASE_NS + 0x00C00UL)
#define GPIOE_BASE_NS            (AHB2PERIPH_BASE_NS + 0x01000UL)
#define GPIOF_BASE_NS            (AHB2PERIPH_BASE_NS + 0x01400UL)
#define GPIOG_BASE_NS            (AHB2PERIPH_BASE_NS + 0x01800UL)
#define GPIOH_BASE_NS            (AHB2PERIPH_BASE_NS + 0x01C00UL)
#define GPIOI_BASE_NS            (AHB2PERIPH_BASE_NS + 0x02000UL)
#define GPIOJ_BASE_NS            (AHB2PERIPH_BASE_NS + 0x02400UL)
#define ADC1_BASE_NS             (AHB2PERIPH_BASE_NS + 0x08000UL)
#define ADC2_BASE_NS             (AHB2PERIPH_BASE_NS + 0x08100UL)
#define ADC12_COMMON_BASE_NS     (AHB2PERIPH_BASE_NS + 0x08300UL)
#define DCMI_BASE_NS             (AHB2PERIPH_BASE_NS + 0x0C000UL)
#define PSSI_BASE_NS             (AHB2PERIPH_BASE_NS + 0x0C400UL)
#define USB_OTG_HS_BASE_NS       (AHB2PERIPH_BASE_NS + 0x20000UL)
#define AES_BASE_NS              (AHB2PERIPH_BASE_NS + 0xA0000UL)
#define HASH_BASE_NS             (AHB2PERIPH_BASE_NS + 0xA0400UL)
#define HASH_DIGEST_BASE_NS      (AHB2PERIPH_BASE_NS + 0xA0710UL)
#define RNG_BASE_NS              (AHB2PERIPH_BASE_NS + 0xA0800UL)
#define SAES_BASE_NS             (AHB2PERIPH_BASE_NS + 0xA0C00UL)
#define PKA_BASE_NS              (AHB2PERIPH_BASE_NS + 0xA2000UL)
#define PKA_RAM_BASE_NS          (AHB2PERIPH_BASE_NS + 0xA2400UL)
#define OCTOSPIM_R_BASE_NS       (AHB2PERIPH_BASE_NS + 0xA4000UL) /*!< OCTOSPIO Manager control registers base address */
#define OTFDEC1_BASE_NS          (AHB2PERIPH_BASE_NS + 0xA5000UL)
#define OTFDEC1_REGION1_BASE_NS  (OTFDEC1_BASE_NS + 0x20UL)
#define OTFDEC1_REGION2_BASE_NS  (OTFDEC1_BASE_NS + 0x50UL)
#define OTFDEC1_REGION3_BASE_NS  (OTFDEC1_BASE_NS + 0x80UL)
#define OTFDEC1_REGION4_BASE_NS  (OTFDEC1_BASE_NS + 0xB0UL)
#define OTFDEC2_BASE_NS          (AHB2PERIPH_BASE_NS + 0xA5400UL)
#define OTFDEC2_REGION1_BASE_NS  (OTFDEC2_BASE_NS + 0x20UL)
#define OTFDEC2_REGION2_BASE_NS  (OTFDEC2_BASE_NS + 0x50UL)
#define OTFDEC2_REGION3_BASE_NS  (OTFDEC2_BASE_NS + 0x80UL)
#define OTFDEC2_REGION4_BASE_NS  (OTFDEC2_BASE_NS + 0xB0UL)
#define SDMMC1_BASE_NS           (AHB2PERIPH_BASE_NS + 0xA8000UL)
#define SDMMC2_BASE_NS           (AHB2PERIPH_BASE_NS + 0xA8C00UL)
#define DLYB_SDMMC1_BASE_NS      (AHB2PERIPH_BASE_NS + 0xA8400UL)
#define DLYB_SDMMC2_BASE_NS      (AHB2PERIPH_BASE_NS + 0xA8800UL)
#define DLYB_OCTOSPI1_BASE_NS    (AHB2PERIPH_BASE_NS + 0xAF000UL)
#define DLYB_OCTOSPI2_BASE_NS    (AHB2PERIPH_BASE_NS + 0xAF400UL)
#define FMC_R_BASE_NS            (AHB2PERIPH_BASE_NS + 0xB0400UL) /*!< FMC control registers base address              */
/*!< FMC Banks Non secure registers base address */
#define FMC_Bank1_R_BASE_NS      (FMC_R_BASE_NS + 0x0000UL)
#define FMC_Bank1E_R_BASE_NS     (FMC_R_BASE_NS + 0x0104UL)
#define FMC_Bank3_R_BASE_NS      (FMC_R_BASE_NS + 0x0080UL)
#define OCTOSPI1_R_BASE_NS       (AHB2PERIPH_BASE_NS + 0xB1400UL) /*!< OCTOSPI1 control registers base address         */
#define OCTOSPI2_R_BASE_NS       (AHB2PERIPH_BASE_NS + 0xB2400UL) /*!< OCTOSPI2 control registers base address         */
#define HSPI1_R_BASE_NS          (AHB2PERIPH_BASE_NS + 0xB3400UL)

/*!< AHB3 Non secure peripherals */
#define LPGPIO1_BASE_NS          (AHB3PERIPH_BASE_NS)
#define PWR_BASE_NS              (AHB3PERIPH_BASE_NS + 0x0800UL)
#define RCC_BASE_NS              (AHB3PERIPH_BASE_NS + 0x0C00UL)
#define ADC4_BASE_NS             (AHB3PERIPH_BASE_NS + 0x1000UL)
#define ADC4_COMMON_BASE_NS      (AHB3PERIPH_BASE_NS + 0x1300UL)
#define DAC1_BASE_NS             (AHB3PERIPH_BASE_NS + 0x1800UL)
#define EXTI_BASE_NS             (AHB3PERIPH_BASE_NS + 0x2000UL)
#define GTZC_TZSC2_BASE_NS       (AHB3PERIPH_BASE_NS + 0x3000UL)
#define GTZC_TZIC2_BASE_NS       (AHB3PERIPH_BASE_NS + 0x3400UL)
#define GTZC_MPCBB4_BASE_NS      (AHB3PERIPH_BASE_NS + 0x3800UL)
#define ADF1_BASE_NS             (AHB3PERIPH_BASE_NS + 0x4000UL)
#define ADF1_Filter0_BASE_NS     (ADF1_BASE_NS + 0x80UL)
#define LPDMA1_BASE_NS           (AHB3PERIPH_BASE_NS + 0x5000UL)
#define LPDMA1_Channel0_BASE_NS  (LPDMA1_BASE_NS + 0x0050UL)
#define LPDMA1_Channel1_BASE_NS  (LPDMA1_BASE_NS + 0x00D0UL)
#define LPDMA1_Channel2_BASE_NS  (LPDMA1_BASE_NS + 0x0150UL)
#define LPDMA1_Channel3_BASE_NS  (LPDMA1_BASE_NS + 0x01D0UL)
/* GFXMMU non secure virtual buffers base address */
#define GFXMMU_VIRTUAL_BUFFERS_BASE_NS  (0x24000000UL)
#define GFXMMU_VIRTUAL_BUFFER0_BASE_NS  (GFXMMU_VIRTUAL_BUFFERS_BASE_NS)
#define GFXMMU_VIRTUAL_BUFFER1_BASE_NS  (GFXMMU_VIRTUAL_BUFFERS_BASE_NS + 0x400000UL)
#define GFXMMU_VIRTUAL_BUFFER2_BASE_NS  (GFXMMU_VIRTUAL_BUFFERS_BASE_NS + 0x800000UL)
#define GFXMMU_VIRTUAL_BUFFER3_BASE_NS  (GFXMMU_VIRTUAL_BUFFERS_BASE_NS + 0xC00000UL)

/* Flash, Peripheral and internal SRAMs base addresses - Secure */
#define FLASH_BASE_S            (0x0C000000UL) /*!< FLASH (4 MB) secure base address       */
#define SRAM1_BASE_S            (0x30000000UL) /*!< SRAM1 (768 KB) secure base address     */
#define SRAM2_BASE_S            (0x300C0000UL) /*!< SRAM2 (64 KB) secure base address      */
#define SRAM3_BASE_S            (0x300D0000UL) /*!< SRAM3 (832 KB) secure base address     */
#define SRAM4_BASE_S            (0x38000000UL) /*!< SRAM4 (16 KB) secure base address      */
#define SRAM5_BASE_S            (0x301A0000UL) /*!< SRAM5 (832 KB) secure base address     */
#define PERIPH_BASE_S           (0x50000000UL) /*!< Peripheral secure base address         */
#define SRAM6_BASE_S            (0x30270000UL) /*!< SRAM6 (512 KB) secure base address     */

/* Peripheral memory map - Secure */
#define APB1PERIPH_BASE_S       PERIPH_BASE_S
#define APB2PERIPH_BASE_S       (PERIPH_BASE_S + 0x00010000UL)
#define AHB1PERIPH_BASE_S       (PERIPH_BASE_S + 0x00020000UL)
#define AHB2PERIPH_BASE_S       (PERIPH_BASE_S + 0x02020000UL)
#define APB3PERIPH_BASE_S       (PERIPH_BASE_S + 0x06000000UL)
#define AHB3PERIPH_BASE_S       (PERIPH_BASE_S + 0x06020000UL)

/*!< APB1 Secure peripherals */
#define TIM2_BASE_S             (APB1PERIPH_BASE_S + 0x0000UL)
#define TIM3_BASE_S             (APB1PERIPH_BASE_S + 0x0400UL)
#define TIM4_BASE_S             (APB1PERIPH_BASE_S + 0x0800UL)
#define TIM5_BASE_S             (APB1PERIPH_BASE_S + 0x0C00UL)
#define TIM6_BASE_S             (APB1PERIPH_BASE_S + 0x1000UL)
#define TIM7_BASE_S             (APB1PERIPH_BASE_S + 0x1400UL)
#define WWDG_BASE_S             (APB1PERIPH_BASE_S + 0x2C00UL)
#define IWDG_BASE_S             (APB1PERIPH_BASE_S + 0x3000UL)
#define SPI2_BASE_S             (APB1PERIPH_BASE_S + 0x3800UL)
#define USART2_BASE_S           (APB1PERIPH_BASE_S + 0x4400UL)
#define USART3_BASE_S           (APB1PERIPH_BASE_S + 0x4800UL)
#define UART4_BASE_S            (APB1PERIPH_BASE_S + 0x4C00UL)
#define UART5_BASE_S            (APB1PERIPH_BASE_S + 0x5000UL)
#define I2C1_BASE_S             (APB1PERIPH_BASE_S + 0x5400UL)
#define I2C2_BASE_S             (APB1PERIPH_BASE_S + 0x5800UL)
#define USART6_BASE_S           (APB1PERIPH_BASE_S + 0x6400UL)
#define I2C4_BASE_S             (APB1PERIPH_BASE_S + 0x8400UL)
#define CRS_BASE_S              (APB1PERIPH_BASE_S + 0x6000UL)
#define LPTIM2_BASE_S           (APB1PERIPH_BASE_S + 0x9400UL)
#define I2C5_BASE_S             (APB1PERIPH_BASE_S + 0x9800UL)
#define I2C6_BASE_S             (APB1PERIPH_BASE_S + 0x9C00UL)
#define FDCAN1_BASE_S           (APB1PERIPH_BASE_S + 0xA400UL)
#define FDCAN_CONFIG_BASE_S     (APB1PERIPH_BASE_S + 0xA500UL)
#define SRAMCAN_BASE_S          (APB1PERIPH_BASE_S + 0xAC00UL)
#define UCPD1_BASE_S            (APB1PERIPH_BASE_S + 0xDC00UL)

/*!< APB2 Secure peripherals */
#define TIM1_BASE_S             (APB2PERIPH_BASE_S + 0x2C00UL)
#define SPI1_BASE_S             (APB2PERIPH_BASE_S + 0x3000UL)
#define TIM8_BASE_S             (APB2PERIPH_BASE_S + 0x3400UL)
#define USART1_BASE_S           (APB2PERIPH_BASE_S + 0x3800UL)
#define TIM15_BASE_S            (APB2PERIPH_BASE_S + 0x4000UL)
#define TIM16_BASE_S            (APB2PERIPH_BASE_S + 0x4400UL)
#define TIM17_BASE_S            (APB2PERIPH_BASE_S + 0x4800UL)
#define SAI1_BASE_S             (APB2PERIPH_BASE_S + 0x5400UL)
#define SAI1_Block_A_BASE_S     (SAI1_BASE_S + 0x004UL)
#define SAI1_Block_B_BASE_S     (SAI1_BASE_S + 0x024UL)
#define SAI2_BASE_S             (APB2PERIPH_BASE_S + 0x5800UL)
#define SAI2_Block_A_BASE_S     (SAI2_BASE_S + 0x004UL)
#define SAI2_Block_B_BASE_S     (SAI2_BASE_S + 0x024UL)
#define GFXTIM_BASE_S             (APB2PERIPH_BASE_S + 0x6400UL)
#define LTDC_BASE_S             (APB2PERIPH_BASE_S + 0x6800UL)
#define LTDC_Layer1_BASE_S      (LTDC_BASE_S + 0x0084UL)
#define LTDC_Layer2_BASE_S      (LTDC_BASE_S + 0x0104UL)

/*!< APB3 Secure peripherals */
#define SYSCFG_BASE_S           (APB3PERIPH_BASE_S + 0x0400UL)
#define SPI3_BASE_S             (APB3PERIPH_BASE_S + 0x2000UL)
#define LPUART1_BASE_S          (APB3PERIPH_BASE_S + 0x2400UL)
#define I2C3_BASE_S             (APB3PERIPH_BASE_S + 0x2800UL)
#define LPTIM1_BASE_S           (APB3PERIPH_BASE_S + 0x4400UL)
#define LPTIM3_BASE_S           (APB3PERIPH_BASE_S + 0x4800UL)
#define LPTIM4_BASE_S           (APB3PERIPH_BASE_S + 0x4C00UL)
#define OPAMP_BASE_S            (APB3PERIPH_BASE_S + 0x5000UL)
#define OPAMP1_BASE_S           (APB3PERIPH_BASE_S + 0x5000UL)
#define OPAMP2_BASE_S           (APB3PERIPH_BASE_S + 0x5010UL)
#define COMP12_BASE_S           (APB3PERIPH_BASE_S + 0x5400UL)
#define COMP1_BASE_S            (COMP12_BASE_S)
#define COMP2_BASE_S            (COMP12_BASE_S + 0x04UL)
#define VREFBUF_BASE_S          (APB3PERIPH_BASE_S + 0x7400UL)
#define RTC_BASE_S              (APB3PERIPH_BASE_S + 0x7800UL)
#define TAMP_BASE_S             (APB3PERIPH_BASE_S + 0x7C00UL)

/*!< AHB1 Secure peripherals */
#define GPDMA1_BASE_S           (AHB1PERIPH_BASE_S)
#define GPDMA1_Channel0_BASE_S  (GPDMA1_BASE_S + 0x0050UL)
#define GPDMA1_Channel1_BASE_S  (GPDMA1_BASE_S + 0x00D0UL)
#define GPDMA1_Channel2_BASE_S  (GPDMA1_BASE_S + 0x0150UL)
#define GPDMA1_Channel3_BASE_S  (GPDMA1_BASE_S + 0x01D0UL)
#define GPDMA1_Channel4_BASE_S  (GPDMA1_BASE_S + 0x0250UL)
#define GPDMA1_Channel5_BASE_S  (GPDMA1_BASE_S + 0x02D0UL)
#define GPDMA1_Channel6_BASE_S  (GPDMA1_BASE_S + 0x0350UL)
#define GPDMA1_Channel7_BASE_S  (GPDMA1_BASE_S + 0x03D0UL)
#define GPDMA1_Channel8_BASE_S  (GPDMA1_BASE_S + 0x0450UL)
#define GPDMA1_Channel9_BASE_S  (GPDMA1_BASE_S + 0x04D0UL)
#define GPDMA1_Channel10_BASE_S (GPDMA1_BASE_S + 0x0550UL)
#define GPDMA1_Channel11_BASE_S (GPDMA1_BASE_S + 0x05D0UL)
#define GPDMA1_Channel12_BASE_S (GPDMA1_BASE_S + 0x0650UL)
#define GPDMA1_Channel13_BASE_S (GPDMA1_BASE_S + 0x06D0UL)
#define GPDMA1_Channel14_BASE_S (GPDMA1_BASE_S + 0x0750UL)
#define GPDMA1_Channel15_BASE_S (GPDMA1_BASE_S + 0x07D0UL)
#define CORDIC_BASE_S           (AHB1PERIPH_BASE_S + 0x01000UL)
#define FMAC_BASE_S             (AHB1PERIPH_BASE_S + 0x01400UL)
#define FLASH_R_BASE_S          (AHB1PERIPH_BASE_S + 0x02000UL)
#define CRC_BASE_S              (AHB1PERIPH_BASE_S + 0x03000UL)
#define TSC_BASE_S              (AHB1PERIPH_BASE_S + 0x04000UL)
#define MDF1_BASE_S             (AHB1PERIPH_BASE_S + 0x05000UL)
#define MDF1_Filter0_BASE_S     (MDF1_BASE_S + 0x80UL)
#define MDF1_Filter1_BASE_S     (MDF1_BASE_S + 0x100UL)
#define MDF1_Filter2_BASE_S     (MDF1_BASE_S + 0x180UL)
#define MDF1_Filter3_BASE_S     (MDF1_BASE_S + 0x200UL)
#define MDF1_Filter4_BASE_S     (MDF1_BASE_S + 0x280UL)
#define MDF1_Filter5_BASE_S     (MDF1_BASE_S + 0x300UL)
#define RAMCFG_BASE_S           (AHB1PERIPH_BASE_S + 0x06000UL)
#define RAMCFG_SRAM1_BASE_S     (RAMCFG_BASE_S)
#define RAMCFG_SRAM2_BASE_S     (RAMCFG_BASE_S + 0x0040UL)
#define RAMCFG_SRAM3_BASE_S     (RAMCFG_BASE_S + 0x0080UL)
#define RAMCFG_SRAM4_BASE_S     (RAMCFG_BASE_S + 0x00C0UL)
#define RAMCFG_BKPRAM_BASE_S    (RAMCFG_BASE_S + 0x0100UL)
#define RAMCFG_SRAM5_BASE_S     (RAMCFG_BASE_S + 0x0140UL)
#define RAMCFG_SRAM6_BASE_S     (RAMCFG_BASE_S + 0x0180UL)
#define JPEG_BASE_S             (AHB1PERIPH_BASE_S + 0x0A00UL)
#define DMA2D_BASE_S            (AHB1PERIPH_BASE_S + 0x0B000UL)
#define GFXMMU_BASE_S           (AHB1PERIPH_BASE_S + 0x0C000UL)
#define GPU2D_BASE_S            (AHB1PERIPH_BASE_S + 0x0F000UL)
#define ICACHE_BASE_S           (AHB1PERIPH_BASE_S + 0x10400UL)
#define DCACHE1_BASE_S          (AHB1PERIPH_BASE_S + 0x11400UL)
#define DCACHE2_BASE_S           (AHB1PERIPH_BASE_S + 0x11800UL)
#define GTZC_TZSC1_BASE_S       (AHB1PERIPH_BASE_S + 0x12400UL)
#define GTZC_TZIC1_BASE_S       (AHB1PERIPH_BASE_S + 0x12800UL)
#define GTZC_MPCBB1_BASE_S      (AHB1PERIPH_BASE_S + 0x12C00UL)
#define GTZC_MPCBB2_BASE_S      (AHB1PERIPH_BASE_S + 0x13000UL)
#define GTZC_MPCBB3_BASE_S      (AHB1PERIPH_BASE_S + 0x13400UL)
#define GTZC_MPCBB5_BASE_S      (AHB1PERIPH_BASE_S + 0x13800UL)
#define GTZC_MPCBB6_BASE_S      (AHB1PERIPH_BASE_S + 0x13C00UL)
#define BKPSRAM_BASE_S          (AHB1PERIPH_BASE_S + 0x16400UL)

/*!< AHB2 Secure peripherals */
#define GPIOA_BASE_S            (AHB2PERIPH_BASE_S + 0x00000UL)
#define GPIOB_BASE_S            (AHB2PERIPH_BASE_S + 0x00400UL)
#define GPIOC_BASE_S            (AHB2PERIPH_BASE_S + 0x00800UL)
#define GPIOD_BASE_S            (AHB2PERIPH_BASE_S + 0x00C00UL)
#define GPIOE_BASE_S            (AHB2PERIPH_BASE_S + 0x01000UL)
#define GPIOF_BASE_S            (AHB2PERIPH_BASE_S + 0x01400UL)
#define GPIOG_BASE_S            (AHB2PERIPH_BASE_S + 0x01800UL)
#define GPIOH_BASE_S            (AHB2PERIPH_BASE_S + 0x01C00UL)
#define GPIOI_BASE_S            (AHB2PERIPH_BASE_S + 0x02000UL)
#define GPIOJ_BASE_S            (AHB2PERIPH_BASE_S + 0x02400UL)
#define ADC1_BASE_S             (AHB2PERIPH_BASE_S + 0x08000UL)
#define ADC2_BASE_S             (AHB2PERIPH_BASE_S + 0x08100UL)
#define ADC12_COMMON_BASE_S     (AHB2PERIPH_BASE_S + 0x08300UL)
#define DCMI_BASE_S             (AHB2PERIPH_BASE_S + 0x0C000UL)
#define PSSI_BASE_S             (AHB2PERIPH_BASE_S + 0x0C400UL)
#define USB_OTG_HS_BASE_S       (AHB2PERIPH_BASE_S + 0x20000UL)
#define AES_BASE_S              (AHB2PERIPH_BASE_S + 0xA0000UL)
#define HASH_BASE_S             (AHB2PERIPH_BASE_S + 0xA0400UL)
#define HASH_DIGEST_BASE_S      (AHB2PERIPH_BASE_S + 0xA0710UL)
#define RNG_BASE_S              (AHB2PERIPH_BASE_S + 0xA0800UL)
#define SAES_BASE_S             (AHB2PERIPH_BASE_S + 0xA0C00UL)
#define PKA_BASE_S              (AHB2PERIPH_BASE_S + 0xA2000UL)
#define PKA_RAM_BASE_S          (AHB2PERIPH_BASE_S + 0xA2400UL)
#define OTFDEC1_BASE_S          (AHB2PERIPH_BASE_S + 0xA5000UL)
#define OTFDEC1_REGION1_BASE_S  (OTFDEC1_BASE_S + 0x20UL)
#define OTFDEC1_REGION2_BASE_S  (OTFDEC1_BASE_S + 0x50UL)
#define OTFDEC1_REGION3_BASE_S  (OTFDEC1_BASE_S + 0x80UL)
#define OTFDEC1_REGION4_BASE_S  (OTFDEC1_BASE_S + 0xB0UL)
#define OTFDEC2_BASE_S          (AHB2PERIPH_BASE_S + 0xA5400UL)
#define OTFDEC2_REGION1_BASE_S  (OTFDEC2_BASE_S + 0x20UL)
#define OTFDEC2_REGION2_BASE_S  (OTFDEC2_BASE_S + 0x50UL)
#define OTFDEC2_REGION3_BASE_S  (OTFDEC2_BASE_S + 0x80UL)
#define OTFDEC2_REGION4_BASE_S  (OTFDEC2_BASE_S + 0xB0UL)
#define OCTOSPIM_R_BASE_S       (AHB2PERIPH_BASE_S + 0xA4000UL) /*!< OCTOSPIM control registers base address */
#define SDMMC1_BASE_S           (AHB2PERIPH_BASE_S + 0xA8000UL)
#define SDMMC2_BASE_S           (AHB2PERIPH_BASE_S + 0xA8C00UL)
#define DLYB_SDMMC1_BASE_S      (AHB2PERIPH_BASE_S + 0xA8400UL)
#define DLYB_SDMMC2_BASE_S      (AHB2PERIPH_BASE_S + 0xA8800UL)
#define DLYB_OCTOSPI1_BASE_S    (AHB2PERIPH_BASE_S + 0xAF000UL)
#define DLYB_OCTOSPI2_BASE_S    (AHB2PERIPH_BASE_S + 0xAF400UL)
#define FMC_R_BASE_S            (AHB2PERIPH_BASE_S + 0xB0400UL) /*!< FMC  control registers base address     */
#define HSPI1_R_BASE_S          (AHB2PERIPH_BASE_S + 0xB3400UL)
#define FMC_Bank1_R_BASE_S      (FMC_R_BASE_S + 0x0000UL)
#define FMC_Bank1E_R_BASE_S     (FMC_R_BASE_S + 0x0104UL)
#define FMC_Bank3_R_BASE_S      (FMC_R_BASE_S + 0x0080UL)
#define OCTOSPI1_R_BASE_S       (AHB2PERIPH_BASE_S + 0xB1400UL) /*!< OCTOSPI1 control registers base address */
#define OCTOSPI2_R_BASE_S       (AHB2PERIPH_BASE_S + 0xB2400UL) /*!< OCTOSPI2 control registers base address */

/*!< AHB3 Secure peripherals */
#define LPGPIO1_BASE_S          (AHB3PERIPH_BASE_S)
#define PWR_BASE_S              (AHB3PERIPH_BASE_S + 0x0800UL)
#define RCC_BASE_S              (AHB3PERIPH_BASE_S + 0x0C00UL)
#define ADC4_BASE_S             (AHB3PERIPH_BASE_S + 0x1000UL)
#define ADC4_COMMON_BASE_S      (AHB3PERIPH_BASE_S + 0x1300UL)
#define DAC1_BASE_S             (AHB3PERIPH_BASE_S + 0x1800UL)
#define EXTI_BASE_S             (AHB3PERIPH_BASE_S + 0x2000UL)
#define GTZC_TZSC2_BASE_S       (AHB3PERIPH_BASE_S + 0x3000UL)
#define GTZC_TZIC2_BASE_S       (AHB3PERIPH_BASE_S + 0x3400UL)
#define GTZC_MPCBB4_BASE_S      (AHB3PERIPH_BASE_S + 0x3800UL)
#define ADF1_BASE_S             (AHB3PERIPH_BASE_S + 0x4000UL)
#define ADF1_Filter0_BASE_S     (ADF1_BASE_S + 0x80UL)
#define LPDMA1_BASE_S           (AHB3PERIPH_BASE_S + 0x5000UL)
#define LPDMA1_Channel0_BASE_S  (LPDMA1_BASE_S + 0x0050UL)
#define LPDMA1_Channel1_BASE_S  (LPDMA1_BASE_S + 0x00D0UL)
#define LPDMA1_Channel2_BASE_S  (LPDMA1_BASE_S + 0x0150UL)
#define LPDMA1_Channel3_BASE_S  (LPDMA1_BASE_S + 0x01D0UL)

/* GFXMMU secure virtual buffers base address */
#define GFXMMU_VIRTUAL_BUFFERS_BASE_S  (0x34000000UL)
#define GFXMMU_VIRTUAL_BUFFER0_BASE_S  (GFXMMU_VIRTUAL_BUFFERS_BASE_S)
#define GFXMMU_VIRTUAL_BUFFER1_BASE_S  (GFXMMU_VIRTUAL_BUFFERS_BASE_S + 0x400000UL)
#define GFXMMU_VIRTUAL_BUFFER2_BASE_S  (GFXMMU_VIRTUAL_BUFFERS_BASE_S + 0x800000UL)
#define GFXMMU_VIRTUAL_BUFFER3_BASE_S  (GFXMMU_VIRTUAL_BUFFERS_BASE_S + 0xC00000UL)

/* Debug MCU registers base address */
#define DBGMCU_BASE             (0xE0044000UL)
#define PACKAGE_BASE            (0x0BFA0500UL) /*!< Package data register base address     */
#define UID_BASE                (0x0BFA0700UL) /*!< Unique device ID register base address */
#define FLASHSIZE_BASE          (0x0BFA07A0UL) /*!< Flash size data register base address  */

/* Internal Flash OTP Area */
#define FLASH_OTP_BASE          (0x0BFA0000UL) /*!< FLASH OTP (one-time programmable) base address */
#define FLASH_OTP_SIZE          (0x200U)       /*!< 512 bytes OTP (one-time programmable)          */

/* USB OTG registers Base address */
#define USB_OTG_GLOBAL_BASE                  (0x0000UL)
#define USB_OTG_DEVICE_BASE                  (0x0800UL)
#define USB_OTG_IN_ENDPOINT_BASE             (0x0900UL)
#define USB_OTG_OUT_ENDPOINT_BASE            (0x0B00UL)
#define USB_OTG_EP_REG_SIZE                  (0x0020UL)
#define USB_OTG_HOST_BASE                    (0x0400UL)
#define USB_OTG_HOST_PORT_BASE               (0x0440UL)
#define USB_OTG_HOST_CHANNEL_BASE            (0x0500UL)
#define USB_OTG_HOST_CHANNEL_SIZE            (0x0020UL)
#define USB_OTG_PCGCCTL_BASE                 (0x0E00UL)
#define USB_OTG_FIFO_BASE                    (0x1000UL)
#define USB_OTG_FIFO_SIZE                    (0x1000UL)

/*!< Root Secure Service Library */
/************ RSSLIB SAU system Flash region definition constants *************/
#define RSSLIB_SYS_FLASH_NS_PFUNC_START   (0x0BF99E40UL)
#define RSSLIB_SYS_FLASH_NS_PFUNC_END     (0x0BF99EFFUL)

/************ RSSLIB function return constants ********************************/
#define RSSLIB_ERROR   (0xF5F5F5F5UL)
#define RSSLIB_SUCCESS (0xEAEAEAEAUL)

/*!< RSSLIB  pointer function structure address definition */
#define RSSLIB_PFUNC_BASE RSSLIB_SYS_FLASH_NS_PFUNC_START
#define RSSLIB_PFUNC      ((RSSLIB_pFunc_TypeDef *)RSSLIB_PFUNC_BASE)

/*!< HDP Area constant definition */
#define RSSLIB_HDP_AREA_Pos  (0U)
#define RSSLIB_HDP_AREA_Msk  (0x3UL << RSSLIB_HDP_AREA_Pos )
#define RSSLIB_HDP_AREA1_Pos (0U)
#define RSSLIB_HDP_AREA1_Msk (0x1UL << RSSLIB_HDP_AREA1_Pos )
#define RSSLIB_HDP_AREA2_Pos (1U)
#define RSSLIB_HDP_AREA2_Msk (0x1UL << RSSLIB_HDP_AREA2_Pos )

/**
  * @brief  Prototype of RSSLIB Close and exit HDP Function
  * @detail This function close the requested hdp area passed in input
  *         parameter and jump to the reset handler present within the
  *         Vector table. The function does not return on successful execution.
  * @param  HdpArea notifies which hdp area to close, can be a combination of
  *         hdpa area 1 and hdp area 2
  * @param  pointer on the vector table containing the reset handler the function
  *         jumps to.
  * @retval RSSLIB_RSS_ERROR on error on input parameter, otherwise does not return.
  */
typedef uint32_t ( *RSSLIB_S_CloseExitHDP_TypeDef)( uint32_t HdpArea, uint32_t VectorTableAddr );


/**
  * @brief RSSLib non-secure callable function pointer structure
  */
typedef struct
{
  __IM uint32_t Reserved[8];
}NSC_pFuncTypeDef;

/**
  * @brief RSSLib secure callable function pointer structure
  */
typedef struct
{
  __IM uint32_t Reserved2[2];
  __IM RSSLIB_S_CloseExitHDP_TypeDef CloseExitHDP;        /*!< RSSLIB Bootloader Close and exit HDP  Address offset: 0x28 */
}S_pFuncTypeDef;

/**
  * @brief RSSLib function pointer structure
  */
typedef struct
{
  NSC_pFuncTypeDef NSC;
  S_pFuncTypeDef S;
}RSSLIB_pFunc_TypeDef;

/** @} */ /* End of group STM32U5xx_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup STM32U5xx_Peripheral_declaration
  * @{
  */

/*!< APB1 Non secure peripherals */
#define TIM2_NS                ((TIM_TypeDef *) TIM2_BASE_NS)
#define TIM3_NS                ((TIM_TypeDef *) TIM3_BASE_NS)
#define TIM4_NS                ((TIM_TypeDef *) TIM4_BASE_NS)
#define TIM5_NS                ((TIM_TypeDef *) TIM5_BASE_NS)
#define TIM6_NS                ((TIM_TypeDef *) TIM6_BASE_NS)
#define TIM7_NS                ((TIM_TypeDef *) TIM7_BASE_NS)
#define WWDG_NS                ((WWDG_TypeDef *) WWDG_BASE_NS)
#define IWDG_NS                ((IWDG_TypeDef *) IWDG_BASE_NS)
#define SPI2_NS                ((SPI_TypeDef *) SPI2_BASE_NS)
#define USART2_NS              ((USART_TypeDef *) USART2_BASE_NS)
#define USART3_NS              ((USART_TypeDef *) USART3_BASE_NS)
#define UART4_NS               ((USART_TypeDef *) UART4_BASE_NS)
#define UART5_NS               ((USART_TypeDef *) UART5_BASE_NS)
#define I2C1_NS                ((I2C_TypeDef *) I2C1_BASE_NS)
#define I2C2_NS                ((I2C_TypeDef *) I2C2_BASE_NS)
#define CRS_NS                 ((CRS_TypeDef *) CRS_BASE_NS)
#define USART6_NS              ((USART_TypeDef *) USART6_BASE_NS)
#define I2C5_NS                ((I2C_TypeDef *) I2C5_BASE_NS)
#define I2C6_NS                ((I2C_TypeDef *) I2C6_BASE_NS)
#define I2C4_NS                ((I2C_TypeDef *) I2C4_BASE_NS)
#define LPTIM2_NS              ((LPTIM_TypeDef *) LPTIM2_BASE_NS)
#define FDCAN1_NS              ((FDCAN_GlobalTypeDef *) FDCAN1_BASE_NS)
#define FDCAN_CONFIG_NS        ((FDCAN_Config_TypeDef *) FDCAN_CONFIG_BASE_NS)
#define UCPD1_NS               ((UCPD_TypeDef *) UCPD1_BASE_NS)

/*!< APB2 Non secure peripherals */
#define TIM1_NS                ((TIM_TypeDef *) TIM1_BASE_NS)
#define SPI1_NS                ((SPI_TypeDef *) SPI1_BASE_NS)
#define TIM8_NS                ((TIM_TypeDef *) TIM8_BASE_NS)
#define USART1_NS              ((USART_TypeDef *) USART1_BASE_NS)
#define TIM15_NS               ((TIM_TypeDef *) TIM15_BASE_NS)
#define TIM16_NS               ((TIM_TypeDef *) TIM16_BASE_NS)
#define TIM17_NS               ((TIM_TypeDef *) TIM17_BASE_NS)
#define SAI1_NS                ((SAI_TypeDef *) SAI1_BASE_NS)
#define SAI1_Block_A_NS        ((SAI_Block_TypeDef *)SAI1_Block_A_BASE_NS)
#define SAI1_Block_B_NS        ((SAI_Block_TypeDef *)SAI1_Block_B_BASE_NS)
#define SAI2_NS                ((SAI_TypeDef *) SAI2_BASE_NS)
#define SAI2_Block_A_NS        ((SAI_Block_TypeDef *)SAI2_Block_A_BASE_NS)
#define SAI2_Block_B_NS        ((SAI_Block_TypeDef *)SAI2_Block_B_BASE_NS)
#define LTDC_NS                ((LTDC_TypeDef *) LTDC_BASE_NS)
#define LTDC_Layer1_NS         ((LTDC_Layer_TypeDef *) LTDC_Layer1_BASE_NS)
#define LTDC_Layer2_NS         ((LTDC_Layer_TypeDef *) LTDC_Layer2_BASE_NS)
#define GFXTIM_NS                 ((GFXTIM_TypeDef *) GFXTIM_BASE_NS)

/*!< APB3 Non secure peripherals */
#define SYSCFG_NS              ((SYSCFG_TypeDef *) SYSCFG_BASE_NS)
#define SPI3_NS                ((SPI_TypeDef *) SPI3_BASE_NS)
#define LPUART1_NS             ((USART_TypeDef *) LPUART1_BASE_NS)
#define I2C3_NS                ((I2C_TypeDef *) I2C3_BASE_NS)
#define LPTIM1_NS              ((LPTIM_TypeDef *) LPTIM1_BASE_NS)
#define LPTIM3_NS              ((LPTIM_TypeDef *) LPTIM3_BASE_NS)
#define LPTIM4_NS              ((LPTIM_TypeDef *) LPTIM4_BASE_NS)
#define OPAMP_NS               ((OPAMP_TypeDef *) OPAMP_BASE_NS)
#define OPAMP1_NS              ((OPAMP_TypeDef *) OPAMP1_BASE_NS)
#define OPAMP2_NS              ((OPAMP_TypeDef *) OPAMP2_BASE_NS)
#define OPAMP12_COMMON_NS      ((OPAMP_Common_TypeDef *) OPAMP1_BASE_NS)
#define COMP12_NS              ((COMP_TypeDef *) COMP12_BASE_NS)
#define COMP1_NS               ((COMP_TypeDef *) COMP1_BASE_NS)
#define COMP2_NS               ((COMP_TypeDef *) COMP2_BASE_NS)
#define COMP12_COMMON_NS       ((COMP_Common_TypeDef *) COMP1_BASE_NS)
#define VREFBUF_NS             ((VREFBUF_TypeDef *) VREFBUF_BASE_NS)
#define RTC_NS                 ((RTC_TypeDef *) RTC_BASE_NS)
#define TAMP_NS                ((TAMP_TypeDef *) TAMP_BASE_NS)

/*!< AHB1 Non secure peripherals */
#define GPDMA1_NS              ((DMA_TypeDef *) GPDMA1_BASE_NS)
#define GPDMA1_Channel0_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel0_BASE_NS)
#define GPDMA1_Channel1_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel1_BASE_NS)
#define GPDMA1_Channel2_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel2_BASE_NS)
#define GPDMA1_Channel3_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel3_BASE_NS)
#define GPDMA1_Channel4_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel4_BASE_NS)
#define GPDMA1_Channel5_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel5_BASE_NS)
#define GPDMA1_Channel6_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel6_BASE_NS)
#define GPDMA1_Channel7_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel7_BASE_NS)
#define GPDMA1_Channel8_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel8_BASE_NS)
#define GPDMA1_Channel9_NS     ((DMA_Channel_TypeDef *) GPDMA1_Channel9_BASE_NS)
#define GPDMA1_Channel10_NS    ((DMA_Channel_TypeDef *) GPDMA1_Channel10_BASE_NS)
#define GPDMA1_Channel11_NS    ((DMA_Channel_TypeDef *) GPDMA1_Channel11_BASE_NS)
#define GPDMA1_Channel12_NS    ((DMA_Channel_TypeDef *) GPDMA1_Channel12_BASE_NS)
#define GPDMA1_Channel13_NS    ((DMA_Channel_TypeDef *) GPDMA1_Channel13_BASE_NS)
#define GPDMA1_Channel14_NS    ((DMA_Channel_TypeDef *) GPDMA1_Channel14_BASE_NS)
#define GPDMA1_Channel15_NS    ((DMA_Channel_TypeDef *) GPDMA1_Channel15_BASE_NS)
#define CORDIC_NS              ((CORDIC_TypeDef *) CORDIC_BASE_NS)
#define FMAC_NS                ((FMAC_TypeDef *) FMAC_BASE_NS)
#define FLASH_NS               ((FLASH_TypeDef *) FLASH_R_BASE_NS)
#define CRC_NS                 ((CRC_TypeDef *) CRC_BASE_NS)
#define TSC_NS                 ((TSC_TypeDef *) TSC_BASE_NS)
#define MDF1_NS                ((MDF_TypeDef *) MDF1_BASE_NS)
#define MDF1_Filter0_NS        ((MDF_Filter_TypeDef*) MDF1_Filter0_BASE_NS)
#define MDF1_Filter1_NS        ((MDF_Filter_TypeDef*) MDF1_Filter1_BASE_NS)
#define MDF1_Filter2_NS        ((MDF_Filter_TypeDef*) MDF1_Filter2_BASE_NS)
#define MDF1_Filter3_NS        ((MDF_Filter_TypeDef*) MDF1_Filter3_BASE_NS)
#define MDF1_Filter4_NS        ((MDF_Filter_TypeDef*) MDF1_Filter4_BASE_NS)
#define MDF1_Filter5_NS        ((MDF_Filter_TypeDef*) MDF1_Filter5_BASE_NS)
#define RAMCFG_SRAM1_NS        ((RAMCFG_TypeDef *) RAMCFG_SRAM1_BASE_NS)
#define RAMCFG_SRAM2_NS        ((RAMCFG_TypeDef *) RAMCFG_SRAM2_BASE_NS)
#define RAMCFG_SRAM3_NS        ((RAMCFG_TypeDef *) RAMCFG_SRAM3_BASE_NS)
#define RAMCFG_SRAM4_NS        ((RAMCFG_TypeDef *) RAMCFG_SRAM4_BASE_NS)
#define RAMCFG_SRAM5_NS        ((RAMCFG_TypeDef *) RAMCFG_SRAM5_BASE_NS)
#define RAMCFG_SRAM6_NS        ((RAMCFG_TypeDef *) RAMCFG_SRAM6_BASE_NS)
#define JPEG_NS                 ((JPEG_TypeDef *) JPEG_BASE_NS)
#define RAMCFG_BKPRAM_NS       ((RAMCFG_TypeDef *) RAMCFG_BKPRAM_BASE_NS)
#define DMA2D_NS               ((DMA2D_TypeDef *) DMA2D_BASE_NS)
#define ICACHE_NS              ((ICACHE_TypeDef *) ICACHE_BASE_NS)
#define DCACHE1_NS             ((DCACHE_TypeDef *) DCACHE1_BASE_NS)
#define DCACHE2_NS              ((DCACHE_TypeDef *) DCACHE2_BASE_NS)
#define GTZC_TZSC1_NS          ((GTZC_TZSC_TypeDef *) GTZC_TZSC1_BASE_NS)
#define GTZC_TZIC1_NS          ((GTZC_TZIC_TypeDef *) GTZC_TZIC1_BASE_NS)
#define GTZC_MPCBB1_NS         ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB1_BASE_NS)
#define GTZC_MPCBB2_NS         ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB2_BASE_NS)
#define GTZC_MPCBB3_NS         ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB3_BASE_NS)
#define GTZC_MPCBB5_NS         ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB5_BASE_NS)
#define GTZC_MPCBB6_NS         ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB6_BASE_NS)
#define GFXMMU_NS              ((GFXMMU_TypeDef *) GFXMMU_BASE_NS)

/*!< AHB2 Non secure peripherals */
#define GPIOA_NS               ((GPIO_TypeDef *) GPIOA_BASE_NS)
#define GPIOB_NS               ((GPIO_TypeDef *) GPIOB_BASE_NS)
#define GPIOC_NS               ((GPIO_TypeDef *) GPIOC_BASE_NS)
#define GPIOD_NS               ((GPIO_TypeDef *) GPIOD_BASE_NS)
#define GPIOE_NS               ((GPIO_TypeDef *) GPIOE_BASE_NS)
#define GPIOF_NS               ((GPIO_TypeDef *) GPIOF_BASE_NS)
#define GPIOG_NS               ((GPIO_TypeDef *) GPIOG_BASE_NS)
#define GPIOH_NS               ((GPIO_TypeDef *) GPIOH_BASE_NS)
#define GPIOI_NS               ((GPIO_TypeDef *) GPIOI_BASE_NS)
#define GPIOJ_NS               ((GPIO_TypeDef *) GPIOJ_BASE_NS)
#define ADC1_NS                ((ADC_TypeDef *) ADC1_BASE_NS)
#define ADC2_NS                ((ADC_TypeDef *) ADC2_BASE_NS)
#define ADC12_COMMON_NS        ((ADC_Common_TypeDef *) ADC12_COMMON_BASE_NS)
#define DCMI_NS                ((DCMI_TypeDef *) DCMI_BASE_NS)
#define PSSI_NS                ((PSSI_TypeDef *) PSSI_BASE_NS)
#define USB_OTG_HS_NS          ((USB_OTG_GlobalTypeDef *) USB_OTG_HS_BASE_NS)
#define AES_NS                 ((AES_TypeDef *) AES_BASE_NS)
#define HASH_NS                ((HASH_TypeDef *) HASH_BASE_NS)
#define HASH_DIGEST_NS         ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE_NS)
#define RNG_NS                 ((RNG_TypeDef *) RNG_BASE_NS)
#define SAES_NS                ((AES_TypeDef *) SAES_BASE_NS)
#define PKA_NS                 ((PKA_TypeDef *) PKA_BASE_NS)
#define OTFDEC1_NS             ((OTFDEC_TypeDef *) OTFDEC1_BASE_NS)
#define OTFDEC1_REGION1_NS     ((OTFDEC_Region_TypeDef *) OTFDEC1_REGION1_BASE_NS)
#define OTFDEC1_REGION2_NS     ((OTFDEC_Region_TypeDef *) OTFDEC1_REGION2_BASE_NS)
#define OTFDEC1_REGION3_NS     ((OTFDEC_Region_TypeDef *) OTFDEC1_REGION3_BASE_NS)
#define OTFDEC1_REGION4_NS     ((OTFDEC_Region_TypeDef *) OTFDEC1_REGION4_BASE_NS)
#define OTFDEC2_NS             ((OTFDEC_TypeDef *) OTFDEC2_BASE_NS)
#define OTFDEC2_REGION1_NS     ((OTFDEC_Region_TypeDef *) OTFDEC2_REGION1_BASE_NS)
#define OTFDEC2_REGION2_NS     ((OTFDEC_Region_TypeDef *) OTFDEC2_REGION2_BASE_NS)
#define OTFDEC2_REGION3_NS     ((OTFDEC_Region_TypeDef *) OTFDEC2_REGION3_BASE_NS)
#define OTFDEC2_REGION4_NS     ((OTFDEC_Region_TypeDef *) OTFDEC2_REGION4_BASE_NS)
#define SDMMC1_NS              ((SDMMC_TypeDef *) SDMMC1_BASE_NS)
#define SDMMC2_NS              ((SDMMC_TypeDef *) SDMMC2_BASE_NS)
#define DLYB_SDMMC1_NS         ((DLYB_TypeDef *) DLYB_SDMMC1_BASE_NS)
#define DLYB_SDMMC2_NS         ((DLYB_TypeDef *) DLYB_SDMMC2_BASE_NS)
#define DLYB_OCTOSPI1_NS       ((DLYB_TypeDef *) DLYB_OCTOSPI1_BASE_NS)
#define DLYB_OCTOSPI2_NS       ((DLYB_TypeDef *) DLYB_OCTOSPI2_BASE_NS)
#define FMC_Bank1_R_NS         ((FMC_Bank1_TypeDef *) FMC_Bank1_R_BASE_NS)
#define FMC_Bank1E_R_NS        ((FMC_Bank1E_TypeDef *) FMC_Bank1E_R_BASE_NS)
#define FMC_Bank3_R_NS         ((FMC_Bank3_TypeDef *) FMC_Bank3_R_BASE_NS)
#define OCTOSPIM_NS            ((OCTOSPIM_TypeDef *) OCTOSPIM_R_BASE_NS)
#define OCTOSPI1_NS            ((OCTOSPI_TypeDef *) OCTOSPI1_R_BASE_NS)
#define OCTOSPI2_NS            ((OCTOSPI_TypeDef *) OCTOSPI2_R_BASE_NS)
#define HSPI1_NS               ((HSPI_TypeDef *) HSPI1_R_BASE_NS)

/*!< AHB3 Non secure peripherals */
#define LPGPIO1_NS             ((GPIO_TypeDef *) LPGPIO1_BASE_NS)
#define PWR_NS                 ((PWR_TypeDef *) PWR_BASE_NS)
#define RCC_NS                 ((RCC_TypeDef *) RCC_BASE_NS)
#define ADC4_NS                ((ADC_TypeDef *) ADC4_BASE_NS)
#define ADC4_COMMON_NS         ((ADC_Common_TypeDef *) ADC4_COMMON_BASE_NS)
#define DAC1_NS                ((DAC_TypeDef *) DAC1_BASE_NS)
#define EXTI_NS                ((EXTI_TypeDef *) EXTI_BASE_NS)
#define GTZC_TZSC2_NS          ((GTZC_TZSC_TypeDef *) GTZC_TZSC2_BASE_NS)
#define GTZC_TZIC2_NS          ((GTZC_TZIC_TypeDef *) GTZC_TZIC2_BASE_NS)
#define GTZC_MPCBB4_NS         ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB4_BASE_NS)
#define ADF1_NS                ((MDF_TypeDef *) ADF1_BASE_NS)
#define ADF1_Filter0_NS        ((MDF_Filter_TypeDef*) ADF1_Filter0_BASE_NS)
#define LPDMA1_NS              ((DMA_TypeDef *) LPDMA1_BASE_NS)
#define LPDMA1_Channel0_NS     ((DMA_Channel_TypeDef *) LPDMA1_Channel0_BASE_NS)
#define LPDMA1_Channel1_NS     ((DMA_Channel_TypeDef *) LPDMA1_Channel1_BASE_NS)
#define LPDMA1_Channel2_NS     ((DMA_Channel_TypeDef *) LPDMA1_Channel2_BASE_NS)
#define LPDMA1_Channel3_NS     ((DMA_Channel_TypeDef *) LPDMA1_Channel3_BASE_NS)

/*!< APB1 Secure peripherals */
#define TIM2_S                 ((TIM_TypeDef *) TIM2_BASE_S)
#define TIM3_S                 ((TIM_TypeDef *) TIM3_BASE_S)
#define TIM4_S                 ((TIM_TypeDef *) TIM4_BASE_S)
#define TIM5_S                 ((TIM_TypeDef *) TIM5_BASE_S)
#define TIM6_S                 ((TIM_TypeDef *) TIM6_BASE_S)
#define TIM7_S                 ((TIM_TypeDef *) TIM7_BASE_S)
#define WWDG_S                 ((WWDG_TypeDef *) WWDG_BASE_S)
#define IWDG_S                 ((IWDG_TypeDef *) IWDG_BASE_S)
#define SPI2_S                 ((SPI_TypeDef *) SPI2_BASE_S)
#define USART2_S               ((USART_TypeDef *) USART2_BASE_S)
#define USART3_S               ((USART_TypeDef *) USART3_BASE_S)
#define UART4_S                ((USART_TypeDef *) UART4_BASE_S)
#define UART5_S                ((USART_TypeDef *) UART5_BASE_S)
#define I2C1_S                 ((I2C_TypeDef *) I2C1_BASE_S)
#define I2C2_S                 ((I2C_TypeDef *) I2C2_BASE_S)
#define CRS_S                  ((CRS_TypeDef *) CRS_BASE_S)
#define USART6_S               ((USART_TypeDef *) USART6_BASE_S)
#define I2C5_S                 ((I2C_TypeDef *) I2C5_BASE_S)
#define I2C6_S                 ((I2C_TypeDef *) I2C6_BASE_S)
#define I2C4_S                 ((I2C_TypeDef *) I2C4_BASE_S)
#define LPTIM2_S               ((LPTIM_TypeDef *) LPTIM2_BASE_S)
#define FDCAN1_S               ((FDCAN_GlobalTypeDef *) FDCAN1_BASE_S)
#define FDCAN_CONFIG_S         ((FDCAN_Config_TypeDef *) FDCAN_CONFIG_BASE_S)
#define UCPD1_S                ((UCPD_TypeDef *) UCPD1_BASE_S)

/*!< APB2 Secure peripherals */
#define TIM1_S                 ((TIM_TypeDef *) TIM1_BASE_S)
#define SPI1_S                 ((SPI_TypeDef *) SPI1_BASE_S)
#define TIM8_S                 ((TIM_TypeDef *) TIM8_BASE_S)
#define USART1_S               ((USART_TypeDef *) USART1_BASE_S)
#define TIM15_S                ((TIM_TypeDef *) TIM15_BASE_S)
#define TIM16_S                ((TIM_TypeDef *) TIM16_BASE_S)
#define TIM17_S                ((TIM_TypeDef *) TIM17_BASE_S)
#define SAI1_S                 ((SAI_TypeDef *) SAI1_BASE_S)
#define SAI1_Block_A_S         ((SAI_Block_TypeDef *)SAI1_Block_A_BASE_S)
#define SAI1_Block_B_S         ((SAI_Block_TypeDef *)SAI1_Block_B_BASE_S)
#define SAI2_S                 ((SAI_TypeDef *) SAI2_BASE_S)
#define SAI2_Block_A_S         ((SAI_Block_TypeDef *)SAI2_Block_A_BASE_S)
#define SAI2_Block_B_S         ((SAI_Block_TypeDef *)SAI2_Block_B_BASE_S)
#define LTDC_S                 ((LTDC_TypeDef *) LTDC_BASE_S)
#define LTDC_Layer1_S          ((LTDC_Layer_TypeDef *) LTDC_Layer1_BASE_S)
#define LTDC_Layer2_S          ((LTDC_Layer_TypeDef *) LTDC_Layer2_BASE_S)
#define GFXTIM_S               ((GFXTIM_TypeDef *) GFXTIM_BASE_S)

/*!< APB3 secure peripherals */
#define SYSCFG_S               ((SYSCFG_TypeDef *) SYSCFG_BASE_S)
#define SPI3_S                 ((SPI_TypeDef *) SPI3_BASE_S)
#define LPUART1_S              ((USART_TypeDef *) LPUART1_BASE_S)
#define I2C3_S                 ((I2C_TypeDef *) I2C3_BASE_S)
#define LPTIM1_S               ((LPTIM_TypeDef *) LPTIM1_BASE_S)
#define LPTIM3_S               ((LPTIM_TypeDef *) LPTIM3_BASE_S)
#define LPTIM4_S               ((LPTIM_TypeDef *) LPTIM4_BASE_S)
#define OPAMP_S                ((OPAMP_TypeDef *) OPAMP_BASE_S)
#define OPAMP1_S               ((OPAMP_TypeDef *) OPAMP1_BASE_S)
#define OPAMP2_S               ((OPAMP_TypeDef *) OPAMP2_BASE_S)
#define OPAMP12_COMMON_S       ((OPAMP_Common_TypeDef *) OPAMP1_BASE_S)
#define COMP12_S               ((COMP_TypeDef *) COMP12_BASE_S)
#define COMP1_S                ((COMP_TypeDef *) COMP1_BASE_S)
#define COMP2_S                ((COMP_TypeDef *) COMP2_BASE_S)
#define COMP12_COMMON_S        ((COMP_Common_TypeDef *) COMP1_BASE_S)
#define VREFBUF_S              ((VREFBUF_TypeDef *) VREFBUF_BASE_S)
#define RTC_S                  ((RTC_TypeDef *) RTC_BASE_S)
#define TAMP_S                 ((TAMP_TypeDef *) TAMP_BASE_S)

/*!< AHB1 Secure peripherals */
#define GPDMA1_S               ((DMA_TypeDef *) GPDMA1_BASE_S)
#define GPDMA1_Channel0_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel0_BASE_S)
#define GPDMA1_Channel1_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel1_BASE_S)
#define GPDMA1_Channel2_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel2_BASE_S)
#define GPDMA1_Channel3_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel3_BASE_S)
#define GPDMA1_Channel4_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel4_BASE_S)
#define GPDMA1_Channel5_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel5_BASE_S)
#define GPDMA1_Channel6_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel6_BASE_S)
#define GPDMA1_Channel7_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel7_BASE_S)
#define GPDMA1_Channel8_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel8_BASE_S)
#define GPDMA1_Channel9_S      ((DMA_Channel_TypeDef *) GPDMA1_Channel9_BASE_S)
#define GPDMA1_Channel10_S     ((DMA_Channel_TypeDef *) GPDMA1_Channel10_BASE_S)
#define GPDMA1_Channel11_S     ((DMA_Channel_TypeDef *) GPDMA1_Channel11_BASE_S)
#define GPDMA1_Channel12_S     ((DMA_Channel_TypeDef *) GPDMA1_Channel12_BASE_S)
#define GPDMA1_Channel13_S     ((DMA_Channel_TypeDef *) GPDMA1_Channel13_BASE_S)
#define GPDMA1_Channel14_S     ((DMA_Channel_TypeDef *) GPDMA1_Channel14_BASE_S)
#define GPDMA1_Channel15_S     ((DMA_Channel_TypeDef *) GPDMA1_Channel15_BASE_S)
#define CORDIC_S               ((CORDIC_TypeDef *) CORDIC_BASE_S)
#define FMAC_S                 ((FMAC_TypeDef *) FMAC_BASE_S)
#define FLASH_S                ((FLASH_TypeDef *) FLASH_R_BASE_S)
#define CRC_S                  ((CRC_TypeDef *) CRC_BASE_S)
#define TSC_S                  ((TSC_TypeDef *) TSC_BASE_S)
#define MDF1_S                 ((MDF_TypeDef *) MDF1_BASE_S)
#define MDF1_Filter0_S         ((MDF_Filter_TypeDef*) MDF1_Filter0_BASE_S)
#define MDF1_Filter1_S         ((MDF_Filter_TypeDef*) MDF1_Filter1_BASE_S)
#define MDF1_Filter2_S         ((MDF_Filter_TypeDef*) MDF1_Filter2_BASE_S)
#define MDF1_Filter3_S         ((MDF_Filter_TypeDef*) MDF1_Filter3_BASE_S)
#define MDF1_Filter4_S         ((MDF_Filter_TypeDef*) MDF1_Filter4_BASE_S)
#define MDF1_Filter5_S         ((MDF_Filter_TypeDef*) MDF1_Filter5_BASE_S)
#define RAMCFG_SRAM1_S         ((RAMCFG_TypeDef *) RAMCFG_SRAM1_BASE_S)
#define RAMCFG_SRAM2_S         ((RAMCFG_TypeDef *) RAMCFG_SRAM2_BASE_S)
#define RAMCFG_SRAM3_S         ((RAMCFG_TypeDef *) RAMCFG_SRAM3_BASE_S)
#define RAMCFG_SRAM4_S         ((RAMCFG_TypeDef *) RAMCFG_SRAM4_BASE_S)
#define RAMCFG_SRAM5_S         ((RAMCFG_TypeDef *) RAMCFG_SRAM5_BASE_S)
#define RAMCFG_SRAM6_S         ((RAMCFG_TypeDef *) RAMCFG_SRAM6_BASE_S)
#define JPEG_S                 ((JPEG_TypeDef *) JPEG_BASE_S)
#define RAMCFG_BKPRAM_S        ((RAMCFG_TypeDef *) RAMCFG_BKPRAM_BASE_S)
#define DMA2D_S                ((DMA2D_TypeDef *) DMA2D_BASE_S)
#define ICACHE_S               ((ICACHE_TypeDef *) ICACHE_BASE_S)
#define DCACHE1_S              ((DCACHE_TypeDef *) DCACHE1_BASE_S)
#define DCACHE2_S               ((DCACHE_TypeDef *) DCACHE2_BASE_S)
#define GTZC_TZSC1_S           ((GTZC_TZSC_TypeDef *) GTZC_TZSC1_BASE_S)
#define GTZC_TZIC1_S           ((GTZC_TZIC_TypeDef *) GTZC_TZIC1_BASE_S)
#define GTZC_MPCBB1_S          ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB1_BASE_S)
#define GTZC_MPCBB2_S          ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB2_BASE_S)
#define GTZC_MPCBB3_S          ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB3_BASE_S)
#define GTZC_MPCBB5_S          ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB5_BASE_S)
#define GTZC_MPCBB6_S          ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB6_BASE_S)
#define GFXMMU_S               ((GFXMMU_TypeDef *) GFXMMU_BASE_S)

/*!< AHB2 Secure peripherals */
#define GPIOA_S                ((GPIO_TypeDef *) GPIOA_BASE_S)
#define GPIOB_S                ((GPIO_TypeDef *) GPIOB_BASE_S)
#define GPIOC_S                ((GPIO_TypeDef *) GPIOC_BASE_S)
#define GPIOD_S                ((GPIO_TypeDef *) GPIOD_BASE_S)
#define GPIOE_S                ((GPIO_TypeDef *) GPIOE_BASE_S)
#define GPIOF_S                ((GPIO_TypeDef *) GPIOF_BASE_S)
#define GPIOG_S                ((GPIO_TypeDef *) GPIOG_BASE_S)
#define GPIOH_S                ((GPIO_TypeDef *) GPIOH_BASE_S)
#define GPIOI_S                ((GPIO_TypeDef *) GPIOI_BASE_S)
#define GPIOJ_S                ((GPIO_TypeDef *) GPIOJ_BASE_S)
#define ADC1_S                 ((ADC_TypeDef *) ADC1_BASE_S)
#define ADC2_S                 ((ADC_TypeDef *) ADC2_BASE_S)
#define ADC12_COMMON_S         ((ADC_Common_TypeDef *) ADC12_COMMON_BASE_S)
#define DCMI_S                 ((DCMI_TypeDef *) DCMI_BASE_S)
#define PSSI_S                 ((PSSI_TypeDef *) PSSI_BASE_S)
#define USB_OTG_HS_S           ((USB_OTG_GlobalTypeDef *) USB_OTG_HS_BASE_S)
#define AES_S                  ((AES_TypeDef *) AES_BASE_S)
#define HASH_S                 ((HASH_TypeDef *) HASH_BASE_S)
#define HASH_DIGEST_S          ((HASH_DIGEST_TypeDef *) HASH_DIGEST_BASE_S)
#define RNG_S                  ((RNG_TypeDef *) RNG_BASE_S)
#define SAES_S                 ((AES_TypeDef *) SAES_BASE_S)
#define PKA_S                  ((PKA_TypeDef *) PKA_BASE_S)
#define OTFDEC1_S              ((OTFDEC_TypeDef *) OTFDEC1_BASE_S)
#define OTFDEC1_REGION1_S      ((OTFDEC_Region_TypeDef *) OTFDEC1_REGION1_BASE_S)
#define OTFDEC1_REGION2_S      ((OTFDEC_Region_TypeDef *) OTFDEC1_REGION2_BASE_S)
#define OTFDEC1_REGION3_S      ((OTFDEC_Region_TypeDef *) OTFDEC1_REGION3_BASE_S)
#define OTFDEC1_REGION4_S      ((OTFDEC_Region_TypeDef *) OTFDEC1_REGION4_BASE_S)
#define OTFDEC2_S              ((OTFDEC_TypeDef *) OTFDEC2_BASE_S)
#define OTFDEC2_REGION1_S      ((OTFDEC_Region_TypeDef *) OTFDEC2_REGION1_BASE_S)
#define OTFDEC2_REGION2_S      ((OTFDEC_Region_TypeDef *) OTFDEC2_REGION2_BASE_S)
#define OTFDEC2_REGION3_S      ((OTFDEC_Region_TypeDef *) OTFDEC2_REGION3_BASE_S)
#define OTFDEC2_REGION4_S      ((OTFDEC_Region_TypeDef *) OTFDEC2_REGION4_BASE_S)
#define SDMMC1_S               ((SDMMC_TypeDef *) SDMMC1_BASE_S)
#define SDMMC2_S               ((SDMMC_TypeDef *) SDMMC2_BASE_S)
#define DLYB_SDMMC1_S          ((DLYB_TypeDef *) DLYB_SDMMC1_BASE_S)
#define DLYB_SDMMC2_S          ((DLYB_TypeDef *) DLYB_SDMMC2_BASE_S)
#define DLYB_OCTOSPI1_S        ((DLYB_TypeDef *) DLYB_OCTOSPI1_BASE_S)
#define DLYB_OCTOSPI2_S        ((DLYB_TypeDef *) DLYB_OCTOSPI2_BASE_S)
#define FMC_Bank1_R_S          ((FMC_Bank1_TypeDef *) FMC_Bank1_R_BASE_S)
#define FMC_Bank1E_R_S         ((FMC_Bank1E_TypeDef *) FMC_Bank1E_R_BASE_S)
#define FMC_Bank3_R_S          ((FMC_Bank3_TypeDef *) FMC_Bank3_R_BASE_S)
#define OCTOSPIM_S             ((OCTOSPIM_TypeDef *) OCTOSPIM_R_BASE_S)
#define OCTOSPI1_S             ((OCTOSPI_TypeDef *) OCTOSPI1_R_BASE_S)
#define OCTOSPI2_S             ((OCTOSPI_TypeDef *) OCTOSPI2_R_BASE_S)
#define HSPI1_S                ((HSPI_TypeDef *) HSPI1_R_BASE_S)

/*!< AHB3 Secure peripherals */
#define LPGPIO1_S              ((GPIO_TypeDef *) LPGPIO1_BASE_S)
#define PWR_S                  ((PWR_TypeDef *) PWR_BASE_S)
#define RCC_S                  ((RCC_TypeDef *) RCC_BASE_S)
#define ADC4_S                 ((ADC_TypeDef *) ADC4_BASE_S)
#define ADC4_COMMON_S          ((ADC_Common_TypeDef *) ADC4_COMMON_BASE_S)
#define DAC1_S                 ((DAC_TypeDef *) DAC1_BASE_S)
#define EXTI_S                 ((EXTI_TypeDef *) EXTI_BASE_S)
#define GTZC_TZSC2_S           ((GTZC_TZSC_TypeDef *) GTZC_TZSC2_BASE_S)
#define GTZC_TZIC2_S           ((GTZC_TZIC_TypeDef *) GTZC_TZIC2_BASE_S)
#define GTZC_MPCBB4_S          ((GTZC_MPCBB_TypeDef *) GTZC_MPCBB4_BASE_S)
#define ADF1_S                 ((MDF_TypeDef *) ADF1_BASE_S)
#define ADF1_Filter0_S         ((MDF_Filter_TypeDef*) ADF1_Filter0_BASE_S)
#define LPDMA1_S               ((DMA_TypeDef *) LPDMA1_BASE_S)
#define LPDMA1_Channel0_S      ((DMA_Channel_TypeDef *) LPDMA1_Channel0_BASE_S)
#define LPDMA1_Channel1_S      ((DMA_Channel_TypeDef *) LPDMA1_Channel1_BASE_S)
#define LPDMA1_Channel2_S      ((DMA_Channel_TypeDef *) LPDMA1_Channel2_BASE_S)
#define LPDMA1_Channel3_S      ((DMA_Channel_TypeDef *) LPDMA1_Channel3_BASE_S)

/*!< DBGMCU peripheral */
#define DBGMCU                 ((DBGMCU_TypeDef *) DBGMCU_BASE)

/*!< Memory & Instance aliases and base addresses for Non-Secure/Secure peripherals */

#if defined (__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE == 3U)

/*!< Memory base addresses for Secure peripherals */
#define FLASH_BASE                     FLASH_BASE_S
#define SRAM1_BASE                     SRAM1_BASE_S
#define SRAM2_BASE                     SRAM2_BASE_S
#define SRAM3_BASE                     SRAM3_BASE_S
#define SRAM4_BASE                     SRAM4_BASE_S
#define SRAM5_BASE                     SRAM5_BASE_S
#define BKPSRAM_BASE                   BKPSRAM_BASE_S
#define SRAM6_BASE                     SRAM6_BASE_S
#define PERIPH_BASE                    PERIPH_BASE_S
#define APB1PERIPH_BASE                APB1PERIPH_BASE_S
#define APB2PERIPH_BASE                APB2PERIPH_BASE_S
#define AHB1PERIPH_BASE                AHB1PERIPH_BASE_S
#define AHB2PERIPH_BASE                AHB2PERIPH_BASE_S

/*!< Instance aliases and base addresses for Secure peripherals */
#define CORDIC                         CORDIC_S
#define CORDIC_BASE                    CORDIC_BASE_S

#define RCC                            RCC_S
#define RCC_BASE                       RCC_BASE_S

#define DCMI                           DCMI_S
#define DCMI_BASE                      DCMI_BASE_S

#define PSSI                           PSSI_S
#define PSSI_BASE                      PSSI_BASE_S

#define FLASH                          FLASH_S
#define FLASH_R_BASE                   FLASH_R_BASE_S

#define FMAC                           FMAC_S
#define FMAC_BASE                      FMAC_BASE_S

#define GPDMA1                         GPDMA1_S
#define GPDMA1_BASE                    GPDMA1_BASE_S

#define GPDMA1_Channel0                GPDMA1_Channel0_S
#define GPDMA1_Channel0_BASE           GPDMA1_Channel0_BASE_S

#define GPDMA1_Channel1                GPDMA1_Channel1_S
#define GPDMA1_Channel1_BASE           GPDMA1_Channel1_BASE_S

#define GPDMA1_Channel2                GPDMA1_Channel2_S
#define GPDMA1_Channel2_BASE           GPDMA1_Channel2_BASE_S

#define GPDMA1_Channel3                GPDMA1_Channel3_S
#define GPDMA1_Channel3_BASE           GPDMA1_Channel3_BASE_S

#define GPDMA1_Channel4                GPDMA1_Channel4_S
#define GPDMA1_Channel4_BASE           GPDMA1_Channel4_BASE_S

#define GPDMA1_Channel5                GPDMA1_Channel5_S
#define GPDMA1_Channel5_BASE           GPDMA1_Channel5_BASE_S

#define GPDMA1_Channel6                GPDMA1_Channel6_S
#define GPDMA1_Channel6_BASE           GPDMA1_Channel6_BASE_S

#define GPDMA1_Channel7                GPDMA1_Channel7_S
#define GPDMA1_Channel7_BASE           GPDMA1_Channel7_BASE_S

#define GPDMA1_Channel8                GPDMA1_Channel8_S
#define GPDMA1_Channel8_BASE           GPDMA1_Channel8_BASE_S

#define GPDMA1_Channel9                GPDMA1_Channel9_S
#define GPDMA1_Channel9_BASE           GPDMA1_Channel9_BASE_S

#define GPDMA1_Channel10               GPDMA1_Channel10_S
#define GPDMA1_Channel10_BASE          GPDMA1_Channel10_BASE_S

#define GPDMA1_Channel11               GPDMA1_Channel11_S
#define GPDMA1_Channel11_BASE          GPDMA1_Channel11_BASE_S

#define GPDMA1_Channel12               GPDMA1_Channel12_S
#define GPDMA1_Channel12_BASE          GPDMA1_Channel12_BASE_S

#define GPDMA1_Channel13               GPDMA1_Channel13_S
#define GPDMA1_Channel13_BASE          GPDMA1_Channel13_BASE_S

#define GPDMA1_Channel14               GPDMA1_Channel14_S
#define GPDMA1_Channel14_BASE          GPDMA1_Channel14_BASE_S

#define GPDMA1_Channel15               GPDMA1_Channel15_S
#define GPDMA1_Channel15_BASE          GPDMA1_Channel15_BASE_S

#define LPDMA1                         LPDMA1_S
#define LPDMA1_BASE                    LPDMA1_BASE_S

#define LPDMA1_Channel0                LPDMA1_Channel0_S
#define LPDMA1_Channel0_BASE           LPDMA1_Channel0_BASE_S

#define LPDMA1_Channel1                LPDMA1_Channel1_S
#define LPDMA1_Channel1_BASE           LPDMA1_Channel1_BASE_S

#define LPDMA1_Channel2                LPDMA1_Channel2_S
#define LPDMA1_Channel2_BASE           LPDMA1_Channel2_BASE_S

#define LPDMA1_Channel3                LPDMA1_Channel3_S
#define LPDMA1_Channel3_BASE           LPDMA1_Channel3_BASE_S

#define GPIOA                          GPIOA_S
#define GPIOA_BASE                     GPIOA_BASE_S

#define GPIOB                          GPIOB_S
#define GPIOB_BASE                     GPIOB_BASE_S

#define GPIOC                          GPIOC_S
#define GPIOC_BASE                     GPIOC_BASE_S

#define GPIOD                          GPIOD_S
#define GPIOD_BASE                     GPIOD_BASE_S

#define GPIOE                          GPIOE_S
#define GPIOE_BASE                     GPIOE_BASE_S

#define GPIOF                          GPIOF_S
#define GPIOF_BASE                     GPIOF_BASE_S

#define GPIOG                          GPIOG_S
#define GPIOG_BASE                     GPIOG_BASE_S

#define GPIOH                          GPIOH_S
#define GPIOH_BASE                     GPIOH_BASE_S

#define GPIOI                          GPIOI_S
#define GPIOI_BASE                     GPIOI_BASE_S

#define GPIOJ                          GPIOJ_S
#define GPIOJ_BASE                     GPIOJ_BASE_S

#define LPGPIO1                        LPGPIO1_S
#define LPGPIO1_BASE                   LPGPIO1_BASE_S

#define PWR                            PWR_S
#define PWR_BASE                       PWR_BASE_S

#define RAMCFG_SRAM1                   RAMCFG_SRAM1_S
#define RAMCFG_SRAM1_BASE              RAMCFG_SRAM1_BASE_S

#define RAMCFG_SRAM2                   RAMCFG_SRAM2_S
#define RAMCFG_SRAM2_BASE              RAMCFG_SRAM2_BASE_S

#define RAMCFG_SRAM3                   RAMCFG_SRAM3_S
#define RAMCFG_SRAM3_BASE              RAMCFG_SRAM3_BASE_S

#define RAMCFG_SRAM4                   RAMCFG_SRAM4_S
#define RAMCFG_SRAM4_BASE              RAMCFG_SRAM4_BASE_S

#define RAMCFG_SRAM5                   RAMCFG_SRAM5_S
#define RAMCFG_SRAM5_BASE              RAMCFG_SRAM5_BASE_S

#define RAMCFG_BKPRAM                  RAMCFG_BKPRAM_S
#define RAMCFG_BKPRAM_BASE             RAMCFG_BKPRAM_BASE_S

#define RAMCFG_SRAM6                   RAMCFG_SRAM6_S
#define RAMCFG_SRAM6_BASE              RAMCFG_SRAM6_BASE_S

#define EXTI                           EXTI_S
#define EXTI_BASE                      EXTI_BASE_S

#define ICACHE                         ICACHE_S
#define ICACHE_BASE                    ICACHE_BASE_S

#define DCACHE1                        DCACHE1_S
#define DCACHE1_BASE                   DCACHE1_BASE_S

#define DCACHE2                         DCACHE2_S
#define DCACHE2_BASE                    DCACHE2_BASE_S

#define GTZC_TZSC1                     GTZC_TZSC1_S
#define GTZC_TZSC1_BASE                GTZC_TZSC1_BASE_S

#define GTZC_TZSC2                     GTZC_TZSC2_S
#define GTZC_TZSC2_BASE                GTZC_TZSC2_BASE_S

#define GTZC_TZIC1                     GTZC_TZIC1_S
#define GTZC_TZIC1_BASE                GTZC_TZIC1_BASE_S

#define GTZC_TZIC2                     GTZC_TZIC2_S
#define GTZC_TZIC2_BASE                GTZC_TZIC2_BASE_S

#define GTZC_MPCBB1                    GTZC_MPCBB1_S
#define GTZC_MPCBB1_BASE               GTZC_MPCBB1_BASE_S

#define GTZC_MPCBB2                    GTZC_MPCBB2_S
#define GTZC_MPCBB2_BASE               GTZC_MPCBB2_BASE_S

#define GTZC_MPCBB3                    GTZC_MPCBB3_S
#define GTZC_MPCBB3_BASE               GTZC_MPCBB3_BASE_S

#define GTZC_MPCBB4                    GTZC_MPCBB4_S
#define GTZC_MPCBB4_BASE               GTZC_MPCBB4_BASE_S

#define GTZC_MPCBB5                    GTZC_MPCBB5_S
#define GTZC_MPCBB5_BASE               GTZC_MPCBB5_BASE_S

#define GTZC_MPCBB6                    GTZC_MPCBB6_S
#define GTZC_MPCBB6_BASE               GTZC_MPCBB6_BASE_S

#define RTC                            RTC_S
#define RTC_BASE                       RTC_BASE_S

#define TAMP                           TAMP_S
#define TAMP_BASE                      TAMP_BASE_S

#define TIM1                           TIM1_S
#define TIM1_BASE                      TIM1_BASE_S

#define TIM2                           TIM2_S
#define TIM2_BASE                      TIM2_BASE_S

#define TIM3                           TIM3_S
#define TIM3_BASE                      TIM3_BASE_S

#define TIM4                           TIM4_S
#define TIM4_BASE                      TIM4_BASE_S

#define TIM5                           TIM5_S
#define TIM5_BASE                      TIM5_BASE_S

#define TIM6                           TIM6_S
#define TIM6_BASE                      TIM6_BASE_S

#define TIM7                           TIM7_S
#define TIM7_BASE                      TIM7_BASE_S

#define TIM8                           TIM8_S
#define TIM8_BASE                      TIM8_BASE_S

#define TIM15                          TIM15_S
#define TIM15_BASE                     TIM15_BASE_S

#define TIM16                          TIM16_S
#define TIM16_BASE                     TIM16_BASE_S

#define TIM17                          TIM17_S
#define TIM17_BASE                     TIM17_BASE_S

#define WWDG                           WWDG_S
#define WWDG_BASE                      WWDG_BASE_S

#define IWDG                           IWDG_S
#define IWDG_BASE                      IWDG_BASE_S

#define SPI1                           SPI1_S
#define SPI1_BASE                      SPI1_BASE_S

#define SPI2                           SPI2_S
#define SPI2_BASE                      SPI2_BASE_S

#define SPI3                           SPI3_S
#define SPI3_BASE                      SPI3_BASE_S

#define USART1                         USART1_S
#define USART1_BASE                    USART1_BASE_S

#define USART2                         USART2_S
#define USART2_BASE                    USART2_BASE_S

#define USART3                         USART3_S
#define USART3_BASE                    USART3_BASE_S

#define UART4                          UART4_S
#define UART4_BASE                     UART4_BASE_S

#define UART5                          UART5_S
#define UART5_BASE                     UART5_BASE_S

#define USART6                         USART6_S
#define USART6_BASE                    USART6_BASE_S

#define I2C1                           I2C1_S
#define I2C1_BASE                      I2C1_BASE_S

#define I2C2                           I2C2_S
#define I2C2_BASE                      I2C2_BASE_S

#define I2C3                           I2C3_S
#define I2C3_BASE                      I2C3_BASE_S

#define I2C4                           I2C4_S
#define I2C4_BASE                      I2C4_BASE_S

#define I2C5                           I2C5_S
#define I2C5_BASE                      I2C5_BASE_S

#define I2C6                           I2C6_S
#define I2C6_BASE                      I2C6_BASE_S

#define CRS                            CRS_S
#define CRS_BASE                       CRS_BASE_S

#define FDCAN1                         FDCAN1_S
#define FDCAN1_BASE                    FDCAN1_BASE_S

#define FDCAN_CONFIG                   FDCAN_CONFIG_S
#define FDCAN_CONFIG_BASE              FDCAN_CONFIG_BASE_S
#define SRAMCAN_BASE                   SRAMCAN_BASE_S

#define DAC                            DAC_S
#define DAC_BASE                       DAC_BASE_S

#define DAC1                           DAC1_S
#define DAC1_BASE                      DAC1_BASE_S

#define OPAMP                          OPAMP_S
#define OPAMP_BASE                     OPAMP_BASE_S

#define OPAMP1                         OPAMP1_S
#define OPAMP1_BASE                    OPAMP1_BASE_S

#define OPAMP2                         OPAMP2_S
#define OPAMP2_BASE                    OPAMP2_BASE_S

#define OPAMP12_COMMON                 OPAMP12_COMMON_S
#define OPAMP12_COMMON_BASE            OPAMP12_COMMON_BASE_S

#define LPTIM1                         LPTIM1_S
#define LPTIM1_BASE                    LPTIM1_BASE_S

#define LPTIM2                         LPTIM2_S
#define LPTIM2_BASE                    LPTIM2_BASE_S

#define LPTIM3                         LPTIM3_S
#define LPTIM3_BASE                    LPTIM3_BASE_S

#define LPTIM4                         LPTIM4_S
#define LPTIM4_BASE                    LPTIM4_BASE_S

#define LPUART1                        LPUART1_S
#define LPUART1_BASE                   LPUART1_BASE_S

#define UCPD1                          UCPD1_S
#define UCPD1_BASE                     UCPD1_BASE_S

#define SYSCFG                         SYSCFG_S
#define SYSCFG_BASE                    SYSCFG_BASE_S

#define VREFBUF                        VREFBUF_S
#define VREFBUF_BASE                   VREFBUF_BASE_S

#define COMP12                         COMP12_S
#define COMP12_BASE                    COMP12_BASE_S

#define COMP1                          COMP1_S
#define COMP1_BASE                     COMP1_BASE_S

#define COMP2                          COMP2_S
#define COMP2_BASE                     COMP2_BASE_S

#define COMP12_COMMON                  COMP12_COMMON_S
#define COMP12_COMMON_BASE             COMP1_BASE_S

#define SAI1                           SAI1_S
#define SAI1_BASE                      SAI1_BASE_S

#define SAI1_Block_A                   SAI1_Block_A_S
#define SAI1_Block_A_BASE              SAI1_Block_A_BASE_S

#define SAI1_Block_B                   SAI1_Block_B_S
#define SAI1_Block_B_BASE              SAI1_Block_B_BASE_S

#define SAI2                           SAI2_S
#define SAI2_BASE                      SAI2_BASE_S

#define SAI2_Block_A                   SAI2_Block_A_S
#define SAI2_Block_A_BASE              SAI2_Block_A_BASE_S

#define SAI2_Block_B                   SAI2_Block_B_S
#define SAI2_Block_B_BASE              SAI2_Block_B_BASE_S

#define CRC                            CRC_S
#define CRC_BASE                       CRC_BASE_S

#define TSC                            TSC_S
#define TSC_BASE                       TSC_BASE_S

#define ADC1                           ADC1_S
#define ADC1_BASE                      ADC1_BASE_S

#define ADC2                           ADC2_S
#define ADC2_BASE                      ADC2_BASE_S
#define ADC12_COMMON                   ADC12_COMMON_S
#define ADC12_COMMON_BASE              ADC12_COMMON_BASE_S


#define ADC4                           ADC4_S
#define ADC4_BASE                      ADC4_BASE_S

#define ADC4_COMMON                    ADC4_COMMON_S
#define ADC4_COMMON_BASE               ADC4_COMMON_BASE_S

#define HASH                           HASH_S
#define HASH_BASE                      HASH_BASE_S

#define HASH_DIGEST                    HASH_DIGEST_S
#define HASH_DIGEST_BASE               HASH_DIGEST_BASE_S

#define AES                            AES_S
#define AES_BASE                       AES_BASE_S

#define RNG                            RNG_S
#define RNG_BASE                       RNG_BASE_S

#define SAES                           SAES_S
#define SAES_BASE                      SAES_BASE_S

#define PKA                            PKA_S
#define PKA_BASE                       PKA_BASE_S
#define PKA_RAM_BASE                   PKA_RAM_BASE_S

#define OTFDEC1                        OTFDEC1_S
#define OTFDEC1_BASE                   OTFDEC1_BASE_S

#define OTFDEC1_REGION1                OTFDEC1_REGION1_S
#define OTFDEC1_REGION1_BASE           OTFDEC1_REGION1_BASE_S

#define OTFDEC1_REGION2                OTFDEC1_REGION2_S
#define OTFDEC1_REGION2_BASE           OTFDEC1_REGION2_BASE_S

#define OTFDEC1_REGION3                OTFDEC1_REGION3_S
#define OTFDEC1_REGION3_BASE           OTFDEC1_REGION3_BASE_S

#define OTFDEC1_REGION4                OTFDEC1_REGION4_S
#define OTFDEC1_REGION4_BASE           OTFDEC1_REGION4_BASE_S

#define OTFDEC2                        OTFDEC2_S
#define OTFDEC2_BASE                   OTFDEC2_BASE_S

#define OTFDEC2_REGION1                OTFDEC2_REGION1_S
#define OTFDEC2_REGION1_BASE           OTFDEC2_REGION1_BASE_S

#define OTFDEC2_REGION2                OTFDEC2_REGION2_S
#define OTFDEC2_REGION2_BASE           OTFDEC2_REGION2_BASE_S

#define OTFDEC2_REGION3                OTFDEC2_REGION3_S
#define OTFDEC2_REGION3_BASE           OTFDEC2_REGION3_BASE_S

#define OTFDEC2_REGION4                OTFDEC2_REGION4_S
#define OTFDEC2_REGION4_BASE           OTFDEC2_REGION4_BASE_S

#define SDMMC1                         SDMMC1_S
#define SDMMC1_BASE                    SDMMC1_BASE_S

#define SDMMC2                         SDMMC2_S
#define SDMMC2_BASE                    SDMMC2_BASE_S

#define FMC_Bank1_R                    FMC_Bank1_R_S
#define FMC_Bank1_R_BASE               FMC_Bank1_R_BASE_S

#define FMC_Bank1E_R                   FMC_Bank1E_R_S
#define FMC_Bank1E_R_BASE              FMC_Bank1E_R_BASE_S

#define FMC_Bank3_R                    FMC_Bank3_R_S
#define FMC_Bank3_R_BASE               FMC_Bank3_R_BASE_S

#define OCTOSPI1                       OCTOSPI1_S
#define OCTOSPI1_R_BASE                OCTOSPI1_R_BASE_S

#define OCTOSPI2                       OCTOSPI2_S
#define OCTOSPI2_R_BASE                OCTOSPI2_R_BASE_S

#define OCTOSPIM                       OCTOSPIM_S
#define OCTOSPIM_R_BASE                OCTOSPIM_R_BASE_S

#define DLYB_SDMMC1                    DLYB_SDMMC1_S
#define DLYB_SDMMC1_BASE               DLYB_SDMMC1_BASE_S

#define DLYB_SDMMC2                    DLYB_SDMMC2_S
#define DLYB_SDMMC2_BASE               DLYB_SDMMC2_BASE_S

#define DLYB_OCTOSPI1                  DLYB_OCTOSPI1_S
#define DLYB_OCTOSPI1_BASE             DLYB_OCTOSPI1_BASE_S

#define DLYB_OCTOSPI2                  DLYB_OCTOSPI2_S
#define DLYB_OCTOSPI2_BASE             DLYB_OCTOSPI2_BASE_S

#define HSPI1                          HSPI1_S
#define HSPI1_R_BASE                   HSPI1_R_BASE_S

#define DMA2D                          DMA2D_S
#define DMA2D_BASE                     DMA2D_BASE_S

#define USB_OTG_HS                     USB_OTG_HS_S
#define USB_OTG_HS_BASE                USB_OTG_HS_BASE_S

#define MDF1                           MDF1_S
#define MDF1_BASE                      MDF1_BASE_S

#define MDF1_Filter0                   MDF1_Filter0_S
#define MDF1_Filter0_BASE              MDF1_Filter0_BASE_S

#define MDF1_Filter1                   MDF1_Filter1_S
#define MDF1_Filter1_BASE              MDF1_Filter1_BASE_S

#define MDF1_Filter2                   MDF1_Filter2_S
#define MDF1_Filter2_BASE              MDF1_Filter2_BASE_S

#define MDF1_Filter3                   MDF1_Filter3_S
#define MDF1_Filter3_BASE              MDF1_Filter3_BASE_S

#define MDF1_Filter4                   MDF1_Filter4_S
#define MDF1_Filter4_BASE              MDF1_Filter4_BASE_S

#define MDF1_Filter5                   MDF1_Filter5_S
#define MDF1_Filter5_BASE              MDF1_Filter5_BASE_S

#define ADF1                           ADF1_S
#define ADF1_BASE                      ADF1_BASE_S

#define ADF1_Filter0                   ADF1_Filter0_S
#define ADF1_Filter0_BASE              ADF1_Filter0_BASE_S

#define GFXMMU                         GFXMMU_S
#define GFXMMU_BASE                    GFXMMU_BASE_S
/* GFXMMU virtual buffers base address */
#define GFXMMU_VIRTUAL_BUFFERS_BASE    GFXMMU_VIRTUAL_BUFFERS_BASE_S
#define GFXMMU_VIRTUAL_BUFFER0_BASE    GFXMMU_VIRTUAL_BUFFER0_BASE_S
#define GFXMMU_VIRTUAL_BUFFER1_BASE    GFXMMU_VIRTUAL_BUFFER1_BASE_S
#define GFXMMU_VIRTUAL_BUFFER2_BASE    GFXMMU_VIRTUAL_BUFFER2_BASE_S
#define GFXMMU_VIRTUAL_BUFFER3_BASE    GFXMMU_VIRTUAL_BUFFER3_BASE_S

#define GPU2D                          GPU2D_BASE_S

#define LTDC                           LTDC_S
#define LTDC_BASE                      LTDC_BASE_S

#define LTDC_Layer1_BASE               LTDC_Layer1_BASE_S
#define LTDC_Layer2_BASE               LTDC_Layer2_BASE_S


#define REFBIAS                        REFBIAS_S
#define REFBIAS_BASE                   REFBIAS_BASE_S

#define DPHY                           DPHY_S
#define DPHY_BASE                      DPHY_BASE_S

#define JPEG                           JPEG_S
#define JPEG_BASE                      JPEG_BASE_S

#define GFXTIM                         GFXTIM_S
#define GFXTIM_BASE                    GFXTIM_BASE_S
#else
/*!< Memory base addresses for Non secure peripherals */
#define FLASH_BASE                     FLASH_BASE_NS
#define SRAM1_BASE                     SRAM1_BASE_NS
#define SRAM2_BASE                     SRAM2_BASE_NS
#define SRAM3_BASE                     SRAM3_BASE_NS
#define SRAM4_BASE                     SRAM4_BASE_NS
#define SRAM5_BASE                     SRAM5_BASE_NS
#define BKPSRAM_BASE                   BKPSRAM_BASE_NS
#define SRAM6_BASE                     SRAM6_BASE_NS
#define PERIPH_BASE                    PERIPH_BASE_NS
#define APB1PERIPH_BASE                APB1PERIPH_BASE_NS
#define APB2PERIPH_BASE                APB2PERIPH_BASE_NS
#define AHB1PERIPH_BASE                AHB1PERIPH_BASE_NS
#define AHB2PERIPH_BASE                AHB2PERIPH_BASE_NS

/*!< Instance aliases and base addresses for Non secure peripherals */
#define CORDIC                         CORDIC_NS
#define CORDIC_BASE                    CORDIC_BASE_NS

#define RCC                            RCC_NS
#define RCC_BASE                       RCC_BASE_NS

#define DMA2D                          DMA2D_NS
#define DMA2D_BASE                     DMA2D_BASE_NS

#define DCMI                           DCMI_NS
#define DCMI_BASE                      DCMI_BASE_NS

#define PSSI                           PSSI_NS
#define PSSI_BASE                      PSSI_BASE_NS

#define FLASH                          FLASH_NS
#define FLASH_R_BASE                   FLASH_R_BASE_NS

#define FMAC                           FMAC_NS
#define FMAC_BASE                      FMAC_BASE_NS

#define GPDMA1                         GPDMA1_NS
#define GPDMA1_BASE                    GPDMA1_BASE_NS

#define GPDMA1_Channel0                GPDMA1_Channel0_NS
#define GPDMA1_Channel0_BASE           GPDMA1_Channel0_BASE_NS

#define GPDMA1_Channel1                GPDMA1_Channel1_NS
#define GPDMA1_Channel1_BASE           GPDMA1_Channel1_BASE_NS

#define GPDMA1_Channel2                GPDMA1_Channel2_NS
#define GPDMA1_Channel2_BASE           GPDMA1_Channel2_BASE_NS

#define GPDMA1_Channel3                GPDMA1_Channel3_NS
#define GPDMA1_Channel3_BASE           GPDMA1_Channel3_BASE_NS

#define GPDMA1_Channel4                GPDMA1_Channel4_NS
#define GPDMA1_Channel4_BASE           GPDMA1_Channel4_BASE_NS

#define GPDMA1_Channel5                GPDMA1_Channel5_NS
#define GPDMA1_Channel5_BASE           GPDMA1_Channel5_BASE_NS

#define GPDMA1_Channel6                GPDMA1_Channel6_NS
#define GPDMA1_Channel6_BASE           GPDMA1_Channel6_BASE_NS

#define GPDMA1_Channel7                GPDMA1_Channel7_NS
#define GPDMA1_Channel7_BASE           GPDMA1_Channel7_BASE_NS

#define GPDMA1_Channel8                GPDMA1_Channel8_NS
#define GPDMA1_Channel8_BASE           GPDMA1_Channel8_BASE_NS

#define GPDMA1_Channel9                GPDMA1_Channel9_NS
#define GPDMA1_Channel9_BASE           GPDMA1_Channel9_BASE_NS

#define GPDMA1_Channel10               GPDMA1_Channel10_NS
#define GPDMA1_Channel10_BASE          GPDMA1_Channel10_BASE_NS

#define GPDMA1_Channel11               GPDMA1_Channel11_NS
#define GPDMA1_Channel11_BASE          GPDMA1_Channel11_BASE_NS

#define GPDMA1_Channel12               GPDMA1_Channel12_NS
#define GPDMA1_Channel12_BASE          GPDMA1_Channel12_BASE_NS

#define GPDMA1_Channel13               GPDMA1_Channel13_NS
#define GPDMA1_Channel13_BASE          GPDMA1_Channel13_BASE_NS

#define GPDMA1_Channel14               GPDMA1_Channel14_NS
#define GPDMA1_Channel14_BASE          GPDMA1_Channel14_BASE_NS

#define GPDMA1_Channel15               GPDMA1_Channel15_NS
#define GPDMA1_Channel15_BASE          GPDMA1_Channel15_BASE_NS

#define LPDMA1                         LPDMA1_NS
#define LPDMA1_BASE                    LPDMA1_BASE_NS

#define LPDMA1_Channel0                LPDMA1_Channel0_NS
#define LPDMA1_Channel0_BASE           LPDMA1_Channel0_BASE_NS

#define LPDMA1_Channel1                LPDMA1_Channel1_NS
#define LPDMA1_Channel1_BASE           LPDMA1_Channel1_BASE_NS

#define LPDMA1_Channel2                LPDMA1_Channel2_NS
#define LPDMA1_Channel2_BASE           LPDMA1_Channel2_BASE_NS

#define LPDMA1_Channel3                LPDMA1_Channel3_NS
#define LPDMA1_Channel3_BASE           LPDMA1_Channel3_BASE_NS

#define GPIOA                          GPIOA_NS
#define GPIOA_BASE                     GPIOA_BASE_NS

#define GPIOB                          GPIOB_NS
#define GPIOB_BASE                     GPIOB_BASE_NS

#define GPIOC                          GPIOC_NS
#define GPIOC_BASE                     GPIOC_BASE_NS

#define GPIOD                          GPIOD_NS
#define GPIOD_BASE                     GPIOD_BASE_NS

#define GPIOE                          GPIOE_NS
#define GPIOE_BASE                     GPIOE_BASE_NS

#define GPIOF                          GPIOF_NS
#define GPIOF_BASE                     GPIOF_BASE_NS

#define GPIOG                          GPIOG_NS
#define GPIOG_BASE                     GPIOG_BASE_NS

#define GPIOH                          GPIOH_NS
#define GPIOH_BASE                     GPIOH_BASE_NS

#define GPIOI                          GPIOI_NS
#define GPIOI_BASE                     GPIOI_BASE_NS
#define GPIOJ                          GPIOJ_NS
#define GPIOJ_BASE                     GPIOJ_BASE_NS

#define LPGPIO1                        LPGPIO1_NS
#define LPGPIO1_BASE                   LPGPIO1_BASE_NS

#define PWR                            PWR_NS
#define PWR_BASE                       PWR_BASE_NS

#define RAMCFG_SRAM1                   RAMCFG_SRAM1_NS
#define RAMCFG_SRAM1_BASE              RAMCFG_SRAM1_BASE_NS

#define RAMCFG_SRAM2                   RAMCFG_SRAM2_NS
#define RAMCFG_SRAM2_BASE              RAMCFG_SRAM2_BASE_NS

#define RAMCFG_SRAM3                   RAMCFG_SRAM3_NS
#define RAMCFG_SRAM3_BASE              RAMCFG_SRAM3_BASE_NS

#define RAMCFG_SRAM4                   RAMCFG_SRAM4_NS
#define RAMCFG_SRAM4_BASE              RAMCFG_SRAM4_BASE_NS

#define RAMCFG_SRAM5                   RAMCFG_SRAM5_NS
#define RAMCFG_SRAM5_BASE              RAMCFG_SRAM5_BASE_NS

#define RAMCFG_BKPRAM                  RAMCFG_BKPRAM_NS
#define RAMCFG_BKPRAM_BASE             RAMCFG_BKPRAM_BASE_NS

#define RAMCFG_SRAM6                   RAMCFG_SRAM6_NS
#define RAMCFG_SRAM6_BASE              RAMCFG_SRAM6_BASE_NS

#define EXTI                           EXTI_NS
#define EXTI_BASE                      EXTI_BASE_NS

#define ICACHE                         ICACHE_NS
#define ICACHE_BASE                    ICACHE_BASE_NS

#define DCACHE1                        DCACHE1_NS
#define DCACHE1_BASE                   DCACHE1_BASE_NS

#define DCACHE2                         DCACHE2_NS
#define DCACHE2_BASE                    DCACHE2_BASE_NS

#define GTZC_TZSC1                     GTZC_TZSC1_NS
#define GTZC_TZSC1_BASE                GTZC_TZSC1_BASE_NS

#define GTZC_TZSC2                     GTZC_TZSC2_NS
#define GTZC_TZSC2_BASE                GTZC_TZSC2_BASE_NS

#define GTZC_TZIC1                     GTZC_TZIC1_NS
#define GTZC_TZIC1_BASE                GTZC_TZIC1_BASE_NS

#define GTZC_TZIC2                     GTZC_TZIC2_NS
#define GTZC_TZIC2_BASE                GTZC_TZIC2_BASE_NS

#define GTZC_MPCBB1                    GTZC_MPCBB1_NS
#define GTZC_MPCBB1_BASE               GTZC_MPCBB1_BASE_NS

#define GTZC_MPCBB2                    GTZC_MPCBB2_NS
#define GTZC_MPCBB2_BASE               GTZC_MPCBB2_BASE_NS

#define GTZC_MPCBB3                    GTZC_MPCBB3_NS
#define GTZC_MPCBB3_BASE               GTZC_MPCBB3_BASE_NS

#define GTZC_MPCBB4                    GTZC_MPCBB4_NS
#define GTZC_MPCBB4_BASE               GTZC_MPCBB4_BASE_NS

#define GTZC_MPCBB5                    GTZC_MPCBB5_NS
#define GTZC_MPCBB5_BASE               GTZC_MPCBB5_BASE_NS

#define GTZC_MPCBB6                    GTZC_MPCBB6_NS
#define GTZC_MPCBB6_BASE               GTZC_MPCBB6_BASE_NS

#define RTC                            RTC_NS
#define RTC_BASE                       RTC_BASE_NS

#define TAMP                           TAMP_NS
#define TAMP_BASE                      TAMP_BASE_NS

#define TIM1                           TIM1_NS
#define TIM1_BASE                      TIM1_BASE_NS

#define TIM2                           TIM2_NS
#define TIM2_BASE                      TIM2_BASE_NS

#define TIM3                           TIM3_NS
#define TIM3_BASE                      TIM3_BASE_NS

#define TIM4                           TIM4_NS
#define TIM4_BASE                      TIM4_BASE_NS

#define TIM5                           TIM5_NS
#define TIM5_BASE                      TIM5_BASE_NS

#define TIM6                           TIM6_NS
#define TIM6_BASE                      TIM6_BASE_NS

#define TIM7                           TIM7_NS
#define TIM7_BASE                      TIM7_BASE_NS

#define TIM8                           TIM8_NS
#define TIM8_BASE                      TIM8_BASE_NS

#define TIM15                          TIM15_NS
#define TIM15_BASE                     TIM15_BASE_NS

#define TIM16                          TIM16_NS
#define TIM16_BASE                     TIM16_BASE_NS

#define TIM17                          TIM17_NS
#define TIM17_BASE                     TIM17_BASE_NS

#define WWDG                           WWDG_NS
#define WWDG_BASE                      WWDG_BASE_NS

#define IWDG                           IWDG_NS
#define IWDG_BASE                      IWDG_BASE_NS

#define SPI1                           SPI1_NS
#define SPI1_BASE                      SPI1_BASE_NS

#define SPI2                           SPI2_NS
#define SPI2_BASE                      SPI2_BASE_NS

#define SPI3                           SPI3_NS
#define SPI3_BASE                      SPI3_BASE_NS

#define USART1                         USART1_NS
#define USART1_BASE                    USART1_BASE_NS

#define USART2                         USART2_NS
#define USART2_BASE                    USART2_BASE_NS

#define USART3                         USART3_NS
#define USART3_BASE                    USART3_BASE_NS

#define UART4                          UART4_NS
#define UART4_BASE                     UART4_BASE_NS

#define UART5                          UART5_NS
#define UART5_BASE                     UART5_BASE_NS

#define USART6                         USART6_NS
#define USART6_BASE                    USART6_BASE_NS

#define I2C1                           I2C1_NS
#define I2C1_BASE                      I2C1_BASE_NS

#define I2C2                           I2C2_NS
#define I2C2_BASE                      I2C2_BASE_NS

#define I2C3                           I2C3_NS
#define I2C3_BASE                      I2C3_BASE_NS

#define I2C4                           I2C4_NS
#define I2C4_BASE                      I2C4_BASE_NS

#define I2C5                           I2C5_NS
#define I2C5_BASE                      I2C5_BASE_NS

#define I2C6                           I2C6_NS
#define I2C6_BASE                      I2C6_BASE_NS

#define CRS                            CRS_NS
#define CRS_BASE                       CRS_BASE_NS

#define FDCAN1                         FDCAN1_NS
#define FDCAN1_BASE                    FDCAN1_BASE_NS

#define FDCAN_CONFIG                   FDCAN_CONFIG_NS
#define FDCAN_CONFIG_BASE              FDCAN_CONFIG_BASE_NS
#define SRAMCAN_BASE                   SRAMCAN_BASE_NS

#define DAC1                           DAC1_NS
#define DAC1_BASE                      DAC1_BASE_NS

#define OPAMP                          OPAMP_NS
#define OPAMP_BASE                     OPAMP_BASE_NS

#define OPAMP1                         OPAMP1_NS
#define OPAMP1_BASE                    OPAMP1_BASE_NS

#define OPAMP2                         OPAMP2_NS
#define OPAMP2_BASE                    OPAMP2_BASE_NS

#define OPAMP12_COMMON                 OPAMP12_COMMON_NS
#define OPAMP12_COMMON_BASE            OPAMP12_COMMON_BASE_NS

#define LPTIM1                         LPTIM1_NS
#define LPTIM1_BASE                    LPTIM1_BASE_NS

#define LPTIM2                         LPTIM2_NS
#define LPTIM2_BASE                    LPTIM2_BASE_NS

#define LPTIM3                         LPTIM3_NS
#define LPTIM3_BASE                    LPTIM3_BASE_NS

#define LPTIM4                         LPTIM4_NS
#define LPTIM4_BASE                    LPTIM4_BASE_NS

#define LPUART1                        LPUART1_NS
#define LPUART1_BASE                   LPUART1_BASE_NS

#define UCPD1                          UCPD1_NS
#define UCPD1_BASE                     UCPD1_BASE_NS

#define SYSCFG                         SYSCFG_NS
#define SYSCFG_BASE                    SYSCFG_BASE_NS

#define VREFBUF                        VREFBUF_NS
#define VREFBUF_BASE                   VREFBUF_BASE_NS

#define COMP12                         COMP12_NS
#define COMP12_BASE                    COMP12_BASE_NS

#define COMP1                          COMP1_NS
#define COMP1_BASE                     COMP1_BASE_NS

#define COMP2                          COMP2_NS
#define COMP2_BASE                     COMP2_BASE_NS

#define COMP12_COMMON                  COMP12_COMMON_NS
#define COMP12_COMMON_BASE             COMP1_BASE_NS

#define SAI1                           SAI1_NS
#define SAI1_BASE                      SAI1_BASE_NS

#define SAI1_Block_A                   SAI1_Block_A_NS
#define SAI1_Block_A_BASE              SAI1_Block_A_BASE_NS

#define SAI1_Block_B                   SAI1_Block_B_NS
#define SAI1_Block_B_BASE              SAI1_Block_B_BASE_NS

#define SAI2                           SAI2_NS
#define SAI2_BASE                      SAI2_BASE_NS

#define SAI2_Block_A                   SAI2_Block_A_NS
#define SAI2_Block_A_BASE              SAI2_Block_A_BASE_NS

#define SAI2_Block_B                   SAI2_Block_B_NS
#define SAI2_Block_B_BASE              SAI2_Block_B_BASE_NS

#define CRC                            CRC_NS
#define CRC_BASE                       CRC_BASE_NS

#define TSC                            TSC_NS
#define TSC_BASE                       TSC_BASE_NS

#define ADC1                           ADC1_NS
#define ADC1_BASE                      ADC1_BASE_NS

#define ADC2                           ADC2_NS
#define ADC2_BASE                      ADC2_BASE_NS

#define ADC12_COMMON                   ADC12_COMMON_NS
#define ADC12_COMMON_BASE              ADC12_COMMON_BASE_NS

#define ADC4                           ADC4_NS
#define ADC4_BASE                      ADC4_BASE_NS

#define ADC4_COMMON                    ADC4_COMMON_NS
#define ADC4_COMMON_BASE               ADC4_COMMON_BASE_NS

#define HASH                           HASH_NS
#define HASH_BASE                      HASH_BASE_NS

#define HASH_DIGEST                    HASH_DIGEST_NS
#define HASH_DIGEST_BASE               HASH_DIGEST_BASE_NS

#define AES                            AES_NS
#define AES_BASE                       AES_BASE_NS

#define RNG                            RNG_NS
#define RNG_BASE                       RNG_BASE_NS

#define SAES                            SAES_NS
#define SAES_BASE                       SAES_BASE_NS

#define PKA                            PKA_NS
#define PKA_BASE                       PKA_BASE_NS
#define PKA_RAM_BASE                   PKA_RAM_BASE_NS

#define OTFDEC1                        OTFDEC1_NS
#define OTFDEC1_BASE                   OTFDEC1_BASE_NS

#define OTFDEC1_REGION1                OTFDEC1_REGION1_NS
#define OTFDEC1_REGION1_BASE           OTFDEC1_REGION1_BASE_NS

#define OTFDEC1_REGION2                OTFDEC1_REGION2_NS
#define OTFDEC1_REGION2_BASE           OTFDEC1_REGION2_BASE_NS

#define OTFDEC1_REGION3                OTFDEC1_REGION3_NS
#define OTFDEC1_REGION3_BASE           OTFDEC1_REGION3_BASE_NS

#define OTFDEC1_REGION4                OTFDEC1_REGION4_NS
#define OTFDEC1_REGION4_BASE           OTFDEC1_REGION4_BASE_NS

#define OTFDEC2                        OTFDEC2_NS
#define OTFDEC2_BASE                   OTFDEC2_BASE_NS

#define OTFDEC2_REGION1                OTFDEC2_REGION1_NS
#define OTFDEC2_REGION1_BASE           OTFDEC2_REGION1_BASE_NS

#define OTFDEC2_REGION2                OTFDEC2_REGION2_NS
#define OTFDEC2_REGION2_BASE           OTFDEC2_REGION2_BASE_NS

#define OTFDEC2_REGION3                OTFDEC2_REGION3_NS
#define OTFDEC2_REGION3_BASE           OTFDEC2_REGION3_BASE_NS

#define OTFDEC2_REGION4                OTFDEC2_REGION4_NS
#define OTFDEC2_REGION4_BASE           OTFDEC2_REGION4_BASE_NS

#define SDMMC1                         SDMMC1_NS
#define SDMMC1_BASE                    SDMMC1_BASE_NS

#define SDMMC2                         SDMMC2_NS
#define SDMMC2_BASE                    SDMMC2_BASE_NS

#define FMC_Bank1_R                    FMC_Bank1_R_NS
#define FMC_Bank1_R_BASE               FMC_Bank1_R_BASE_NS

#define FMC_Bank1E_R                   FMC_Bank1E_R_NS
#define FMC_Bank1E_R_BASE              FMC_Bank1E_R_BASE_NS

#define FMC_Bank3_R                    FMC_Bank3_R_NS
#define FMC_Bank3_R_BASE               FMC_Bank3_R_BASE_NS

#define OCTOSPI1                       OCTOSPI1_NS
#define OCTOSPI1_R_BASE                OCTOSPI1_R_BASE_NS

#define OCTOSPI2                       OCTOSPI2_NS
#define OCTOSPI2_R_BASE                OCTOSPI2_R_BASE_NS

#define OCTOSPIM                       OCTOSPIM_NS
#define OCTOSPIM_R_BASE                OCTOSPIM_R_BASE_NS

#define DLYB_SDMMC1                    DLYB_SDMMC1_NS
#define DLYB_SDMMC1_BASE               DLYB_SDMMC1_BASE_NS

#define DLYB_SDMMC2                    DLYB_SDMMC2_NS
#define DLYB_SDMMC2_BASE               DLYB_SDMMC2_BASE_NS

#define DLYB_OCTOSPI1                  DLYB_OCTOSPI1_NS
#define DLYB_OCTOSPI1_BASE             DLYB_OCTOSPI1_BASE_NS

#define DLYB_OCTOSPI2                  DLYB_OCTOSPI2_NS
#define DLYB_OCTOSPI2_BASE             DLYB_OCTOSPI2_BASE_NS

#define HSPI1                          HSPI1_NS
#define HSPI1_R_BASE                   HSPI1_R_BASE_NS

#define USB_OTG_HS                     USB_OTG_HS_NS
#define USB_OTG_HS_BASE                USB_OTG_HS_BASE_NS

#define MDF1                           MDF1_NS
#define MDF1_BASE                      MDF1_BASE_NS

#define MDF1_Filter0                   MDF1_Filter0_NS
#define MDF1_Filter0_BASE              MDF1_Filter0_BASE_NS

#define MDF1_Filter1                   MDF1_Filter1_NS
#define MDF1_Filter1_BASE              MDF1_Filter1_BASE_NS

#define MDF1_Filter2                   MDF1_Filter2_NS
#define MDF1_Filter2_BASE              MDF1_Filter2_BASE_NS

#define MDF1_Filter3                   MDF1_Filter3_NS
#define MDF1_Filter3_BASE              MDF1_Filter3_BASE_NS

#define MDF1_Filter4                   MDF1_Filter4_NS
#define MDF1_Filter4_BASE              MDF1_Filter4_BASE_NS

#define MDF1_Filter5                   MDF1_Filter5_NS
#define MDF1_Filter5_BASE              MDF1_Filter5_BASE_NS

#define ADF1                           ADF1_NS
#define ADF1_BASE                      ADF1_BASE_NS

#define ADF1_Filter0                   ADF1_Filter0_NS
#define ADF1_Filter0_BASE              ADF1_Filter0_BASE_NS
#define GFXMMU                         GFXMMU_NS
#define GFXMMU_BASE                    GFXMMU_BASE_NS
/* GFXMMU virtual buffers base address */
#define GFXMMU_VIRTUAL_BUFFERS_BASE    GFXMMU_VIRTUAL_BUFFERS_BASE_NS
#define GFXMMU_VIRTUAL_BUFFER0_BASE    GFXMMU_VIRTUAL_BUFFER0_BASE_NS
#define GFXMMU_VIRTUAL_BUFFER1_BASE    GFXMMU_VIRTUAL_BUFFER1_BASE_NS
#define GFXMMU_VIRTUAL_BUFFER2_BASE    GFXMMU_VIRTUAL_BUFFER2_BASE_NS
#define GFXMMU_VIRTUAL_BUFFER3_BASE    GFXMMU_VIRTUAL_BUFFER3_BASE_NS

#define GPU2D                          GPU2D_BASE_NS

#define LTDC                           LTDC_NS
#define LTDC_BASE                      LTDC_BASE_NS

#define LTDC_Layer1                    LTDC_Layer1_NS
#define LTDC_Layer1_BASE               LTDC_Layer1_BASE_NS

#define LTDC_Layer2                    LTDC_Layer2_NS
#define LTDC_Layer2_BASE               LTDC_Layer2_BASE_NS


#define REFBIAS                        REFBIAS_NS
#define REFBIAS_BASE                   REFBIAS_BASE_NS

#define DPHY                           DPHY_NS
#define DPHY_BASE                      DPHY_BASE_NS

#define JPEG                           JPEG_NS
#define JPEG_BASE                      JPEG_BASE_NS

#define GFXTIM                         GFXTIM_NS
#define GFXTIM_BASE                    GFXTIM_BASE_NS
#endif

/** @addtogroup Hardware_Constant_Definition
  * @{
  */
#define LSI_STARTUP_TIME 260U /*!< LSI Maximum startup time in us */

/**
  * @}
  */

/******************************************************************************/
/*                                                                            */
/*                        Analog to Digital Converter                         */
/*                                                                            */
/******************************************************************************/
/*******************************  ADC VERSION  ********************************/
#define ADC_VER_V5_X
#define ADC_MULTIMODE_SUPPORT
/********************  Bit definition for ADC_ISR register  ********************/
#define ADC_ISR_ADRDY_Pos                 (0U)
#define ADC_ISR_ADRDY_Msk                 (0x1UL << ADC_ISR_ADRDY_Pos)          /*!< 0x00000001 */
#define ADC_ISR_ADRDY                     ADC_ISR_ADRDY_Msk                     /*!< ADC Ready (ADRDY) flag  */
#define ADC_ISR_EOSMP_Pos                 (1U)
#define ADC_ISR_EOSMP_Msk                 (0x1UL << ADC_ISR_EOSMP_Pos)          /*!< 0x00000002 */
#define ADC_ISR_EOSMP                     ADC_ISR_EOSMP_Msk                     /*!< ADC End of Sampling flag */
#define ADC_ISR_EOC_Pos                   (2U)
#define ADC_ISR_EOC_Msk                   (0x1UL << ADC_ISR_EOC_Pos)            /*!< 0x00000004 */
#define ADC_ISR_EOC                       ADC_ISR_EOC_Msk                       /*!< ADC End of Regular Conversion flag */
#define ADC_ISR_EOS_Pos                   (3U)
#define ADC_ISR_EOS_Msk                   (0x1UL << ADC_ISR_EOS_Pos)            /*!< 0x00000008 */
#define ADC_ISR_EOS                       ADC_ISR_EOS_Msk                       /*!< ADC End of Regular sequence of Conversions flag */
#define ADC_ISR_OVR_Pos                   (4U)
#define ADC_ISR_OVR_Msk                   (0x1UL << ADC_ISR_OVR_Pos)            /*!< 0x00000010 */
#define ADC_ISR_OVR                       ADC_ISR_OVR_Msk                       /*!< ADC overrun flag */
#define ADC_ISR_JEOC_Pos                  (5U)
#define ADC_ISR_JEOC_Msk                  (0x1UL << ADC_ISR_JEOC_Pos)           /*!< 0x00000020 */
#define ADC_ISR_JEOC                      ADC_ISR_JEOC_Msk                      /*!< ADC End of Injected Conversion flag */
#define ADC_ISR_JEOS_Pos                  (6U)
#define ADC_ISR_JEOS_Msk                  (0x1UL << ADC_ISR_JEOS_Pos)           /*!< 0x00000040 */
#define ADC_ISR_JEOS                      ADC_ISR_JEOS_Msk                      /*!< ADC End of Injected sequence of Conversions flag */
#define ADC_ISR_AWD1_Pos                  (7U)
#define ADC_ISR_AWD1_Msk                  (0x1UL << ADC_ISR_AWD1_Pos)           /*!< 0x00000080 */
#define ADC_ISR_AWD1                      ADC_ISR_AWD1_Msk                      /*!< ADC Analog watchdog 1 flag */
#define ADC_ISR_AWD2_Pos                  (8U)
#define ADC_ISR_AWD2_Msk                  (0x1UL << ADC_ISR_AWD2_Pos)           /*!< 0x00000100 */
#define ADC_ISR_AWD2                      ADC_ISR_AWD2_Msk                      /*!< ADC Analog watchdog 2 flag */
#define ADC_ISR_AWD3_Pos                  (9U)
#define ADC_ISR_AWD3_Msk                  (0x1UL << ADC_ISR_AWD3_Pos)           /*!< 0x00000200 */
#define ADC_ISR_AWD3                      ADC_ISR_AWD3_Msk                      /*!< ADC Analog watchdog 3 flag */
#define ADC_ISR_JQOVF_Pos                 (10U)
#define ADC_ISR_JQOVF_Msk                 (0x1UL << ADC_ISR_JQOVF_Pos)          /*!< 0x00000400 */
#define ADC_ISR_JQOVF                     ADC_ISR_JQOVF_Msk                     /*!< ADC Injected Context Queue Overflow flag */
#define ADC_ISR_EOCAL_Pos                 (11U)
#define ADC_ISR_EOCAL_Msk                 (0x1UL << ADC_ISR_EOCAL_Pos)          /*!< 0x00000800 */
#define ADC_ISR_EOCAL                     ADC_ISR_EOCAL_Msk                     /*!< ADC End of Calibration flag */
#define ADC_ISR_LDORDY_Pos                (12U)
#define ADC_ISR_LDORDY_Msk                (0x1UL << ADC_ISR_LDORDY_Pos)         /*!< 0x00001000 */
#define ADC_ISR_LDORDY                    ADC_ISR_LDORDY_Msk                    /*!< ADC  Voltage Regulator Ready flag */

/********************  Bit definition for ADC_IER register  ********************/
#define ADC_IER_ADRDYIE_Pos               (0U)
#define ADC_IER_ADRDYIE_Msk               (0x1UL << ADC_IER_ADRDYIE_Pos)        /*!< 0x00000001 */
#define ADC_IER_ADRDYIE                   ADC_IER_ADRDYIE_Msk                   /*!< ADC Ready (ADRDY) interrupt source */
#define ADC_IER_EOSMPIE_Pos               (1U)
#define ADC_IER_EOSMPIE_Msk               (0x1UL << ADC_IER_EOSMPIE_Pos)        /*!< 0x00000002 */
#define ADC_IER_EOSMPIE                   ADC_IER_EOSMPIE_Msk                   /*!< ADC End of Sampling interrupt source */
#define ADC_IER_EOCIE_Pos                 (2U)
#define ADC_IER_EOCIE_Msk                 (0x1UL << ADC_IER_EOCIE_Pos)          /*!< 0x00000004 */
#define ADC_IER_EOCIE                     ADC_IER_EOCIE_Msk                     /*!< ADC End of Regular Conversion interrupt source */
#define ADC_IER_EOSIE_Pos                 (3U)
#define ADC_IER_EOSIE_Msk                 (0x1UL << ADC_IER_EOSIE_Pos)          /*!< 0x00000008 */
#define ADC_IER_EOSIE                     ADC_IER_EOSIE_Msk                     /*!< ADC End of Regular sequence of Conversions interrupt source */
#define ADC_IER_OVRIE_Pos                 (4U)
#define ADC_IER_OVRIE_Msk                 (0x1UL << ADC_IER_OVRIE_Pos)          /*!< 0x00000010 */
#define ADC_IER_OVRIE                     ADC_IER_OVRIE_Msk                     /*!< ADC overrun interrupt source */
#define ADC_IER_JEOCIE_Pos                (5U)
#define ADC_IER_JEOCIE_Msk                (0x1UL << ADC_IER_JEOCIE_Pos)         /*!< 0x00000020 */
#define ADC_IER_JEOCIE                    ADC_IER_JEOCIE_Msk                    /*!< ADC End of Injected Conversion interrupt source */
#define ADC_IER_JEOSIE_Pos                (6U)
#define ADC_IER_JEOSIE_Msk                (0x1UL << ADC_IER_JEOSIE_Pos)         /*!< 0x00000040 */
#define ADC_IER_JEOSIE                    ADC_IER_JEOSIE_Msk                    /*!< ADC End of Injected sequence of Conversions interrupt source */
#define ADC_IER_AWD1IE_Pos                (7U)
#define ADC_IER_AWD1IE_Msk                (0x1UL << ADC_IER_AWD1IE_Pos)         /*!< 0x00000080 */
#define ADC_IER_AWD1IE                    ADC_IER_AWD1IE_Msk                    /*!< ADC Analog watchdog 1 interrupt source */
#define ADC_IER_AWD2IE_Pos                (8U)
#define ADC_IER_AWD2IE_Msk                (0x1UL << ADC_IER_AWD2IE_Pos)         /*!< 0x00000100 */
#define ADC_IER_AWD2IE                    ADC_IER_AWD2IE_Msk                    /*!< ADC Analog watchdog 2 interrupt source */
#define ADC_IER_AWD3IE_Pos                (9U)
#define ADC_IER_AWD3IE_Msk                (0x1UL << ADC_IER_AWD3IE_Pos)         /*!< 0x00000200 */
#define ADC_IER_AWD3IE                    ADC_IER_AWD3IE_Msk                    /*!< ADC Analog watchdog 3 interrupt source */
#define ADC_IER_JQOVFIE_Pos               (10U)
#define ADC_IER_JQOVFIE_Msk               (0x1UL << ADC_IER_JQOVFIE_Pos)        /*!< 0x00000400 */
#define ADC_IER_JQOVFIE                   ADC_IER_JQOVFIE_Msk                   /*!< ADC Injected Context Queue Overflow interrupt source */
#define ADC_IER_EOCALIE_Pos               (11U)
#define ADC_IER_EOCALIE_Msk               (0x1UL << ADC_IER_EOCALIE_Pos)        /*!< 0x00000800 */
#define ADC_IER_EOCALIE                   ADC_IER_EOCALIE_Msk                   /*!< ADC End of Calibration Enable */
#define ADC_IER_LDORDYIE_Pos              (12U)
#define ADC_IER_LDORDYIE_Msk              (0x1UL << ADC_IER_LDORDYIE_Pos)       /*!< 0x00001000 */
#define ADC_IER_LDORDYIE                  ADC_IER_LDORDYIE_Msk                  /*!< ADC  Voltage Regulator Ready flag */

/********************  Bit definition for ADC_CR register  ********************/
#define ADC_CR_ADEN_Pos                   (0U)
#define ADC_CR_ADEN_Msk                   (0x1UL << ADC_CR_ADEN_Pos)            /*!< 0x00000001 */
#define ADC_CR_ADEN                       ADC_CR_ADEN_Msk                       /*!< ADC Enable control */
#define ADC_CR_ADDIS_Pos                  (1U)
#define ADC_CR_ADDIS_Msk                  (0x1UL << ADC_CR_ADDIS_Pos)           /*!< 0x00000002 */
#define ADC_CR_ADDIS                      ADC_CR_ADDIS_Msk                      /*!< ADC Disable command */
#define ADC_CR_ADSTART_Pos                (2U)
#define ADC_CR_ADSTART_Msk                (0x1UL << ADC_CR_ADSTART_Pos)         /*!< 0x00000004 */
#define ADC_CR_ADSTART                    ADC_CR_ADSTART_Msk                    /*!< ADC Start of Regular conversion */
#define ADC_CR_JADSTART_Pos               (3U)
#define ADC_CR_JADSTART_Msk               (0x1UL << ADC_CR_JADSTART_Pos)        /*!< 0x00000008 */
#define ADC_CR_JADSTART                   ADC_CR_JADSTART_Msk                   /*!< ADC Start of injected conversion */
#define ADC_CR_ADSTP_Pos                  (4U)
#define ADC_CR_ADSTP_Msk                  (0x1UL << ADC_CR_ADSTP_Pos)           /*!< 0x00000010 */
#define ADC_CR_ADSTP                      ADC_CR_ADSTP_Msk                      /*!< ADC Stop of Regular conversion */
#define ADC_CR_JADSTP_Pos                 (5U)
#define ADC_CR_JADSTP_Msk                 (0x1UL << ADC_CR_JADSTP_Pos)          /*!< 0x00000020 */
#define ADC_CR_JADSTP                     ADC_CR_JADSTP_Msk                     /*!< ADC Stop of injected conversion */
#define ADC_CR_ADCALLIN_Pos               (16U)
#define ADC_CR_ADCALLIN_Msk               (0x1UL << ADC_CR_ADCALLIN_Pos)        /*!< 0x00010000 */
#define ADC_CR_ADCALLIN                   ADC_CR_ADCALLIN_Msk                   /*!< ADC Linearity calibration */

#define ADC_CR_CALINDEX_Pos               (24U)
#define ADC_CR_CALINDEX_Msk               (0xFUL << ADC_CR_CALINDEX_Pos)        /*!< 0x0F000000 */
#define ADC_CR_CALINDEX                   ADC_CR_CALINDEX_Msk                   /*!< ADC calibration factor selection */
#define ADC_CR_CALINDEX0_Pos              (24U)
#define ADC_CR_CALINDEX0_Msk              (0x1UL << ADC_CR_CALINDEX0_Pos)       /*!< 0x01000000 */
#define ADC_CR_CALINDEX0                  ADC_CR_CALINDEX0_Msk                  /*!< ADC calibration factor selection (bit 0) */
#define ADC_CR_CALINDEX1_Pos              (25U)
#define ADC_CR_CALINDEX1_Msk              (0x1UL << ADC_CR_CALINDEX1_Pos)       /*!< 0x02000000 */
#define ADC_CR_CALINDEX1                  ADC_CR_CALINDEX1_Msk                  /*!< ADC calibration factor selection (bit 1) */
#define ADC_CR_CALINDEX2_Pos              (26U)
#define ADC_CR_CALINDEX2_Msk              (0x1UL << ADC_CR_CALINDEX2_Pos)       /*!< 0x04000000 */
#define ADC_CR_CALINDEX2                  ADC_CR_CALINDEX2_Msk                  /*!< ADC calibration factor selection (bit 2) */
#define ADC_CR_CALINDEX3_Pos              (27U)
#define ADC_CR_CALINDEX3_Msk              (0x1UL << ADC_CR_CALINDEX3_Pos)       /*!< 0x08000000 */
#define ADC_CR_CALINDEX3                  ADC_CR_CALINDEX3_Msk                  /*!< ADC calibration factor selection (bit 3) */
#define ADC_CR_ADVREGEN_Pos               (28U)
#define ADC_CR_ADVREGEN_Msk               (0x1UL << ADC_CR_ADVREGEN_Pos)        /*!< 0x10000000 */
#define ADC_CR_ADVREGEN                   ADC_CR_ADVREGEN_Msk                   /*!< ADC Voltage regulator Enable */
#define ADC_CR_DEEPPWD_Pos                (29U)
#define ADC_CR_DEEPPWD_Msk                (0x1UL << ADC_CR_DEEPPWD_Pos)         /*!< 0x20000000 */
#define ADC_CR_DEEPPWD                    ADC_CR_DEEPPWD_Msk                    /*!< ADC Deep power down Enable */
#define ADC_CR_ADCAL_Pos                  (31U)
#define ADC_CR_ADCAL_Msk                  (0x1UL << ADC_CR_ADCAL_Pos)           /*!< 0x80000000 */
#define ADC_CR_ADCAL                      ADC_CR_ADCAL_Msk                      /*!< ADC Calibration */

/********************  Bit definition for ADC_CFGR register  ********************/
#define ADC_CFGR1_DMNGT_Pos                (0U)
#define ADC_CFGR1_DMNGT_Msk                (0x3UL << ADC_CFGR1_DMNGT_Pos)       /*!< 0x00000003 */
#define ADC_CFGR1_DMNGT                    ADC_CFGR1_DMNGT_Msk                  /*!< ADC Data Management configuration */
#define ADC_CFGR1_DMNGT_0                  (0x1UL << ADC_CFGR1_DMNGT_Pos)       /*!< 0x00000001 */
#define ADC_CFGR1_DMNGT_1                  (0x2UL << ADC_CFGR1_DMNGT_Pos)       /*!< 0x00000002 */

#define ADC_CFGR1_RES_Pos                  (2U)
#define ADC_CFGR1_RES_Msk                  (0x3UL << ADC_CFGR1_RES_Pos)         /*!< 0x0000000C */
#define ADC_CFGR1_RES                      ADC_CFGR1_RES_Msk                    /*!< ADC Data resolution */
#define ADC_CFGR1_RES_0                    (0x1UL << ADC_CFGR1_RES_Pos)         /*!< 0x00000004 */
#define ADC_CFGR1_RES_1                    (0x2UL << ADC_CFGR1_RES_Pos)         /*!< 0x00000008 */

#define ADC4_CFGR1_DMAEN_Pos                (0U)
#define ADC4_CFGR1_DMAEN_Msk                (0x1UL << ADC4_CFGR1_DMAEN_Pos)     /*!< 0x00000001 */
#define ADC4_CFGR1_DMAEN                    ADC4_CFGR1_DMAEN_Msk                /*!< ADC DMA transfer enable */
#define ADC4_CFGR1_DMACFG_Pos               (1U)
#define ADC4_CFGR1_DMACFG_Msk               (0x1UL << ADC4_CFGR1_DMACFG_Pos)    /*!< 0x00000002 */
#define ADC4_CFGR1_DMACFG                   ADC4_CFGR1_DMACFG_Msk               /*!< ADC DMA transfer configuration */

#define ADC4_CFGR1_SCANDIR_Pos              (4U)
#define ADC4_CFGR1_SCANDIR_Msk              (0x1UL << ADC4_CFGR1_SCANDIR_Pos)   /*!< 0x00000004 */
#define ADC4_CFGR1_SCANDIR                  ADC4_CFGR1_SCANDIR_Msk              /*!< ADC group regular sequencer scan direction */

#define ADC4_CFGR1_ALIGN_Pos                (5U)
#define ADC4_CFGR1_ALIGN_Msk                (0x1UL << ADC4_CFGR1_ALIGN_Pos)     /*!< 0x00000020 */
#define ADC4_CFGR1_ALIGN                    ADC4_CFGR1_ALIGN_Msk                /*!< ADC data alignment */

#define ADC_CFGR1_EXTSEL_Pos               (5U)
#define ADC_CFGR1_EXTSEL_Msk               (0x1FUL << ADC_CFGR1_EXTSEL_Pos)     /*!< 0x000003E0 */
#define ADC_CFGR1_EXTSEL                   ADC_CFGR1_EXTSEL_Msk                 /*!< ADC External trigger selection for regular group */
#define ADC_CFGR1_EXTSEL_0                 (0x01UL << ADC_CFGR1_EXTSEL_Pos)     /*!< 0x00000020 */
#define ADC_CFGR1_EXTSEL_1                 (0x02UL << ADC_CFGR1_EXTSEL_Pos)     /*!< 0x00000040 */
#define ADC_CFGR1_EXTSEL_2                 (0x04UL << ADC_CFGR1_EXTSEL_Pos)     /*!< 0x00000080 */
#define ADC_CFGR1_EXTSEL_3                 (0x08UL << ADC_CFGR1_EXTSEL_Pos)     /*!< 0x00000100 */
#define ADC_CFGR1_EXTSEL_4                 (0x10UL << ADC_CFGR1_EXTSEL_Pos)     /*!< 0x00000200 */

#define ADC_CFGR1_EXTEN_Pos                (10U)
#define ADC_CFGR1_EXTEN_Msk                (0x3UL << ADC_CFGR1_EXTEN_Pos)       /*!< 0x00000C00 */
#define ADC_CFGR1_EXTEN                    ADC_CFGR1_EXTEN_Msk                  /*!< ADC External trigger enable and polarity selection for regular channels */
#define ADC_CFGR1_EXTEN_0                  (0x1UL << ADC_CFGR1_EXTEN_Pos)       /*!< 0x00000400 */
#define ADC_CFGR1_EXTEN_1                  (0x2UL << ADC_CFGR1_EXTEN_Pos)       /*!< 0x00000800 */

#define ADC_CFGR1_OVRMOD_Pos               (12U)
#define ADC_CFGR1_OVRMOD_Msk               (0x1UL << ADC_CFGR1_OVRMOD_Pos)      /*!< 0x00001000 */
#define ADC_CFGR1_OVRMOD                   ADC_CFGR1_OVRMOD_Msk                 /*!< ADC overrun mode */
#define ADC_CFGR1_CONT_Pos                 (13U)
#define ADC_CFGR1_CONT_Msk                 (0x1UL << ADC_CFGR1_CONT_Pos)        /*!< 0x00002000 */
#define ADC_CFGR1_CONT                     ADC_CFGR1_CONT_Msk                   /*!< ADC Single/continuous conversion mode for regular conversion */

#define ADC_CFGR1_AUTDLY_Pos               (14U)
#define ADC_CFGR1_AUTDLY_Msk               (0x1UL << ADC_CFGR1_AUTDLY_Pos)      /*!< 0x00004000 */
#define ADC_CFGR1_AUTDLY                   ADC_CFGR1_AUTDLY_Msk                 /*!< ADC Delayed conversion mode */

#define ADC4_CFGR1_WAIT_Pos                (14U)
#define ADC4_CFGR1_WAIT_Msk                (0x1UL << ADC4_CFGR1_WAIT_Pos)       /*!< 0x00004000 */
#define ADC4_CFGR1_WAIT                    ADC4_CFGR1_WAIT_Msk                  /*!< ADC Delayed conversion mode */

#define ADC_CFGR1_DISCEN_Pos               (16U)
#define ADC_CFGR1_DISCEN_Msk               (0x1UL << ADC_CFGR1_DISCEN_Pos)      /*!< 0x00010000 */
#define ADC_CFGR1_DISCEN                   ADC_CFGR1_DISCEN_Msk                 /*!< ADC Discontinuous mode for regular channels */

#define ADC_CFGR1_DISCNUM_Pos              (17U)
#define ADC_CFGR1_DISCNUM_Msk              (0x7UL << ADC_CFGR1_DISCNUM_Pos)     /*!< 0x000E0000 */
#define ADC_CFGR1_DISCNUM                  ADC_CFGR1_DISCNUM_Msk                /*!< ADC Discontinuous mode channel count */
#define ADC_CFGR1_DISCNUM_0                (0x1UL << ADC_CFGR1_DISCNUM_Pos)     /*!< 0x00020000 */
#define ADC_CFGR1_DISCNUM_1                (0x2UL << ADC_CFGR1_DISCNUM_Pos)     /*!< 0x00040000 */
#define ADC_CFGR1_DISCNUM_2                (0x4UL << ADC_CFGR1_DISCNUM_Pos)     /*!< 0x00080000 */

#define ADC_CFGR1_JDISCEN_Pos              (20U)
#define ADC_CFGR1_JDISCEN_Msk              (0x1UL << ADC_CFGR1_JDISCEN_Pos)     /*!< 0x00100000 */
#define ADC_CFGR1_JDISCEN                  ADC_CFGR1_JDISCEN_Msk                /*!< ADC Discontinuous mode on injected channels */

#define ADC_CFGR1_AWD1SGL_Pos              (22U)
#define ADC_CFGR1_AWD1SGL_Msk              (0x1UL << ADC_CFGR1_AWD1SGL_Pos)     /*!< 0x00400000 */
#define ADC_CFGR1_AWD1SGL                  ADC_CFGR1_AWD1SGL_Msk                /*!< Enable the watchdog 1 on a single channel or on all channels */
#define ADC_CFGR1_AWD1EN_Pos               (23U)
#define ADC_CFGR1_AWD1EN_Msk               (0x1UL << ADC_CFGR1_AWD1EN_Pos)      /*!< 0x00800000 */
#define ADC_CFGR1_AWD1EN                   ADC_CFGR1_AWD1EN_Msk                 /*!< ADC Analog watchdog 1 enable on regular Channels */
#define ADC_CFGR1_JAWD1EN_Pos              (24U)
#define ADC_CFGR1_JAWD1EN_Msk              (0x1UL << ADC_CFGR1_JAWD1EN_Pos)     /*!< 0x01000000 */
#define ADC_CFGR1_JAWD1EN                  ADC_CFGR1_JAWD1EN_Msk                /*!< ADC Analog watchdog 1 enable on injected Channels */
#define ADC_CFGR1_JAUTO_Pos                (25U)
#define ADC_CFGR1_JAUTO_Msk                (0x1UL << ADC_CFGR1_JAUTO_Pos)       /*!< 0x02000000 */
#define ADC_CFGR1_JAUTO                    ADC_CFGR1_JAUTO_Msk                  /*!< ADC Automatic injected group conversion */

/* Specific ADC4 */
#define ADC4_CFGR1_EXTSEL_Pos               (6U)
#define ADC4_CFGR1_EXTSEL_Msk               (0x7UL << ADC4_CFGR1_EXTSEL_Pos)    /*!< 0x000003E0 */
#define ADC4_CFGR1_EXTSEL                   ADC4_CFGR1_EXTSEL_Msk               /*!< ADC External trigger selection for regular group */
#define ADC4_CFGR1_EXTSEL_0                 (0x01UL << ADC4_CFGR1_EXTSEL_Pos)   /*!< 0x00000020 */
#define ADC4_CFGR1_EXTSEL_1                 (0x02UL << ADC4_CFGR1_EXTSEL_Pos)   /*!< 0x00000040 */
#define ADC4_CFGR1_EXTSEL_2                 (0x04UL << ADC4_CFGR1_EXTSEL_Pos)   /*!< 0x00000080 */

#define ADC4_CFGR1_CHSELRMOD_Pos           (21U)
#define ADC4_CFGR1_CHSELRMOD_Msk           (0x1UL << ADC4_CFGR1_CHSELRMOD_Pos)  /*!< 0x00200000 */
#define ADC4_CFGR1_CHSELRMOD               ADC4_CFGR1_CHSELRMOD_Msk             /*!< ADC JSQR Queue mode */

#define ADC_CFGR1_AWD1CH_Pos               (26U)
#define ADC_CFGR1_AWD1CH_Msk               (0x1FUL << ADC_CFGR1_AWD1CH_Pos)     /*!< 0x7C000000 */
#define ADC_CFGR1_AWD1CH                   ADC_CFGR1_AWD1CH_Msk                 /*!< ADC Analog watchdog 1 Channel selection */
#define ADC_CFGR1_AWD1CH_0                 (0x01UL << ADC_CFGR1_AWD1CH_Pos)     /*!< 0x04000000 */
#define ADC_CFGR1_AWD1CH_1                 (0x02UL << ADC_CFGR1_AWD1CH_Pos)     /*!< 0x08000000 */
#define ADC_CFGR1_AWD1CH_2                 (0x04UL << ADC_CFGR1_AWD1CH_Pos)     /*!< 0x10000000 */
#define ADC_CFGR1_AWD1CH_3                 (0x08UL << ADC_CFGR1_AWD1CH_Pos)     /*!< 0x20000000 */
#define ADC_CFGR1_AWD1CH_4                 (0x10UL << ADC_CFGR1_AWD1CH_Pos)     /*!< 0x40000000 */

/********************  Bit definition for ADC_CFGR2 register  ********************/
#define ADC_CFGR2_ROVSE_Pos               (0U)
#define ADC_CFGR2_ROVSE_Msk               (0x1UL << ADC_CFGR2_ROVSE_Pos)        /*!< 0x00000001 */
#define ADC_CFGR2_ROVSE                   ADC_CFGR2_ROVSE_Msk                   /*!< ADC Regular group oversampler enable */
#define ADC_CFGR2_JOVSE_Pos               (1U)
#define ADC_CFGR2_JOVSE_Msk               (0x1UL << ADC_CFGR2_JOVSE_Pos)        /*!< 0x00000002 */
#define ADC_CFGR2_JOVSE                   ADC_CFGR2_JOVSE_Msk                   /*!< ADC Injected group oversampler enable */

#define ADC_CFGR2_OVSS_Pos                (5U)
#define ADC_CFGR2_OVSS_Msk                (0xFUL << ADC_CFGR2_OVSS_Pos)         /*!< 0x000001E0 */
#define ADC_CFGR2_OVSS                    ADC_CFGR2_OVSS_Msk                    /*!< ADC Regular Oversampling shift */
#define ADC_CFGR2_OVSS_0                  (0x1UL << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000020 */
#define ADC_CFGR2_OVSS_1                  (0x2UL << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000040 */
#define ADC_CFGR2_OVSS_2                  (0x4UL << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000080 */
#define ADC_CFGR2_OVSS_3                  (0x8UL << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000100 */

#define ADC_CFGR2_TROVS_Pos               (9U)
#define ADC_CFGR2_TROVS_Msk               (0x1UL << ADC_CFGR2_TROVS_Pos)        /*!< 0x00000200 */
#define ADC_CFGR2_TROVS                   ADC_CFGR2_TROVS_Msk                   /*!< ADC Triggered regular Oversampling */
#define ADC_CFGR2_ROVSM_Pos               (10U)
#define ADC_CFGR2_ROVSM_Msk               (0x1UL << ADC_CFGR2_ROVSM_Pos)        /*!< 0x00000400 */
#define ADC_CFGR2_ROVSM                   ADC_CFGR2_ROVSM_Msk                   /*!< ADC Regular oversampling mode */

#define ADC_CFGR2_OVSR_Pos                (16U)
#define ADC_CFGR2_OVSR_Msk                (0x3FFUL << ADC_CFGR2_OVSR_Pos)       /*!< 0x03FF0000 */
#define ADC_CFGR2_OVSR                    ADC_CFGR2_OVSR_Msk                    /*!< ADC oversampling Ratio */
#define ADC_CFGR2_OVSR_0                  (0x001UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00010000 */
#define ADC_CFGR2_OVSR_1                  (0x002UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00020000 */
#define ADC_CFGR2_OVSR_2                  (0x004UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00040000 */
#define ADC_CFGR2_OVSR_3                  (0x008UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00080000 */
#define ADC_CFGR2_OVSR_4                  (0x010UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00100000 */
#define ADC_CFGR2_OVSR_5                  (0x020UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00200000 */
#define ADC_CFGR2_OVSR_6                  (0x040UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00400000 */
#define ADC_CFGR2_OVSR_7                  (0x080UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x00800000 */
#define ADC_CFGR2_OVSR_8                  (0x100UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x01000000 */
#define ADC_CFGR2_OVSR_9                  (0x200UL << ADC_CFGR2_OVSR_Pos)       /*!< 0x02000000 */

#define ADC_CFGR2_BULB_Pos                (13U)
#define ADC_CFGR2_BULB_Msk                (0x1UL << ADC_CFGR2_BULB_Pos)         /*!< 0x00002000 */
#define ADC_CFGR2_BULB                    ADC_CFGR2_BULB_Msk                    /*!< ADC Bulb sampling mode */

#define ADC_CFGR2_SWTRIG_Pos              (14U)
#define ADC_CFGR2_SWTRIG_Msk              (0x1UL << ADC_CFGR2_SWTRIG_Pos)       /*!< 0x00004000 */
#define ADC_CFGR2_SWTRIG                  ADC_CFGR2_SWTRIG_Msk                  /*!< ADC Software trigger bit for sampling time control trigger mode */

#define ADC_CFGR2_SMPTRIG_Pos             (15U)
#define ADC_CFGR2_SMPTRIG_Msk             (0x1UL << ADC_CFGR2_SMPTRIG_Pos)      /*!< 0x00008000 */
#define ADC_CFGR2_SMPTRIG                 ADC_CFGR2_SMPTRIG_Msk                 /*!< ADC Sampling time control trigger mode */

#define ADC_CFGR2_LFTRIG_Pos              (27U)
#define ADC_CFGR2_LFTRIG_Msk              (0x1UL << ADC_CFGR2_LFTRIG_Pos)       /*!< 0x08000000 */
#define ADC_CFGR2_LFTRIG                  ADC_CFGR2_LFTRIG_Msk                  /*!< ADC low frequency trigger mode */

#define ADC_CFGR2_LSHIFT_Pos              (28U)
#define ADC_CFGR2_LSHIFT_Msk              (0xFUL << ADC_CFGR2_LSHIFT_Pos)       /*!< 0xF0000000 */
#define ADC_CFGR2_LSHIFT                  ADC_CFGR2_LSHIFT_Msk                  /*!< ADC Left shift factor */
#define ADC_CFGR2_LSHIFT_0                (0x1UL << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x10000000 */
#define ADC_CFGR2_LSHIFT_1                (0x2UL << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x20000000 */
#define ADC_CFGR2_LSHIFT_2                (0x4UL << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x40000000 */
#define ADC_CFGR2_LSHIFT_3                (0x8UL << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x80000000 */

/* Specific ADC4 */
#define ADC4_CFGR2_OVSR_Pos               (2U)
#define ADC4_CFGR2_OVSR_Msk               (0x7UL << ADC4_CFGR2_OVSR_Pos)        /*!< 0x0000001C */
#define ADC4_CFGR2_OVSR                   ADC4_CFGR2_OVSR_Msk                   /*!< ADC oversampling ratio */
#define ADC4_CFGR2_OVSR_0                 (0x1UL << ADC4_CFGR2_OVSR_Pos)        /*!< 0x00000004 */
#define ADC4_CFGR2_OVSR_1                 (0x2UL << ADC4_CFGR2_OVSR_Pos)        /*!< 0x00000008 */
#define ADC4_CFGR2_OVSR_2                 (0x4UL << ADC4_CFGR2_OVSR_Pos)        /*!< 0x00000010 */

#define ADC4_CFGR2_LFTRIG_Pos             (29U)
#define ADC4_CFGR2_LFTRIG_Msk             (0x1UL << ADC4_CFGR2_LFTRIG_Pos)      /*!< 0x20000000 */
#define ADC4_CFGR2_LFTRIG                 ADC4_CFGR2_LFTRIG_Msk                 /*!< ADC4 low frequency trigger mode */

/********************  Bit definition for ADC_SMPR1 register  ********************/
#define ADC_SMPR1_SMP0_Pos                (0U)
#define ADC_SMPR1_SMP0_Msk                (0x7UL << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000007 */
#define ADC_SMPR1_SMP0                    ADC_SMPR1_SMP0_Msk                    /*!< ADC Channel 0 Sampling time selection  */
#define ADC_SMPR1_SMP0_0                  (0x1UL << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000001 */
#define ADC_SMPR1_SMP0_1                  (0x2UL << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000002 */
#define ADC_SMPR1_SMP0_2                  (0x4UL << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000004 */

#define ADC_SMPR1_SMP1_Pos                (3U)
#define ADC_SMPR1_SMP1_Msk                (0x7UL << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000038 */
#define ADC_SMPR1_SMP1                    ADC_SMPR1_SMP1_Msk                    /*!< ADC Channel 1 Sampling time selection  */
#define ADC_SMPR1_SMP1_0                  (0x1UL << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000008 */
#define ADC_SMPR1_SMP1_1                  (0x2UL << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000010 */
#define ADC_SMPR1_SMP1_2                  (0x4UL << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000020 */

#define ADC_SMPR1_SMP2_Pos                (6U)
#define ADC_SMPR1_SMP2_Msk                (0x7UL << ADC_SMPR1_SMP2_Pos)         /*!< 0x000001C0 */
#define ADC_SMPR1_SMP2                    ADC_SMPR1_SMP2_Msk                    /*!< ADC Channel 2 Sampling time selection  */
#define ADC_SMPR1_SMP2_0                  (0x1UL << ADC_SMPR1_SMP2_Pos)         /*!< 0x00000040 */
#define ADC_SMPR1_SMP2_1                  (0x2UL << ADC_SMPR1_SMP2_Pos)         /*!< 0x00000080 */
#define ADC_SMPR1_SMP2_2                  (0x4UL << ADC_SMPR1_SMP2_Pos)         /*!< 0x00000100 */

#define ADC_SMPR1_SMP3_Pos                (9U)
#define ADC_SMPR1_SMP3_Msk                (0x7UL << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000E00 */
#define ADC_SMPR1_SMP3                    ADC_SMPR1_SMP3_Msk                    /*!< ADC Channel 3 Sampling time selection  */
#define ADC_SMPR1_SMP3_0                  (0x1UL << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000200 */
#define ADC_SMPR1_SMP3_1                  (0x2UL << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000400 */
#define ADC_SMPR1_SMP3_2                  (0x4UL << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000800 */

#define ADC_SMPR1_SMP4_Pos                (12U)
#define ADC_SMPR1_SMP4_Msk                (0x7UL << ADC_SMPR1_SMP4_Pos)         /*!< 0x00007000 */
#define ADC_SMPR1_SMP4                    ADC_SMPR1_SMP4_Msk                    /*!< ADC Channel 4 Sampling time selection  */
#define ADC_SMPR1_SMP4_0                  (0x1UL << ADC_SMPR1_SMP4_Pos)         /*!< 0x00001000 */
#define ADC_SMPR1_SMP4_1                  (0x2UL << ADC_SMPR1_SMP4_Pos)         /*!< 0x00002000 */
#define ADC_SMPR1_SMP4_2                  (0x4UL << ADC_SMPR1_SMP4_Pos)         /*!< 0x00004000 */

#define ADC_SMPR1_SMP5_Pos                (15U)
#define ADC_SMPR1_SMP5_Msk                (0x7UL << ADC_SMPR1_SMP5_Pos)         /*!< 0x00038000 */
#define ADC_SMPR1_SMP5                    ADC_SMPR1_SMP5_Msk                    /*!< ADC Channel 5 Sampling time selection  */
#define ADC_SMPR1_SMP5_0                  (0x1UL << ADC_SMPR1_SMP5_Pos)         /*!< 0x00008000 */
#define ADC_SMPR1_SMP5_1                  (0x2UL << ADC_SMPR1_SMP5_Pos)         /*!< 0x00010000 */
#define ADC_SMPR1_SMP5_2                  (0x4UL << ADC_SMPR1_SMP5_Pos)         /*!< 0x00020000 */

#define ADC_SMPR1_SMP6_Pos                (18U)
#define ADC_SMPR1_SMP6_Msk                (0x7UL << ADC_SMPR1_SMP6_Pos)         /*!< 0x001C0000 */
#define ADC_SMPR1_SMP6                    ADC_SMPR1_SMP6_Msk                    /*!< ADC Channel 6 Sampling time selection  */
#define ADC_SMPR1_SMP6_0                  (0x1UL << ADC_SMPR1_SMP6_Pos)         /*!< 0x00040000 */
#define ADC_SMPR1_SMP6_1                  (0x2UL << ADC_SMPR1_SMP6_Pos)         /*!< 0x00080000 */
#define ADC_SMPR1_SMP6_2                  (0x4UL << ADC_SMPR1_SMP6_Pos)         /*!< 0x00100000 */

#define ADC_SMPR1_SMP7_Pos                (21U)
#define ADC_SMPR1_SMP7_Msk                (0x7UL << ADC_SMPR1_SMP7_Pos)         /*!< 0x00E00000 */
#define ADC_SMPR1_SMP7                    ADC_SMPR1_SMP7_Msk                    /*!< ADC Channel 7 Sampling time selection  */
#define ADC_SMPR1_SMP7_0                  (0x1UL << ADC_SMPR1_SMP7_Pos)         /*!< 0x00200000 */
#define ADC_SMPR1_SMP7_1                  (0x2UL << ADC_SMPR1_SMP7_Pos)         /*!< 0x00400000 */
#define ADC_SMPR1_SMP7_2                  (0x4UL << ADC_SMPR1_SMP7_Pos)         /*!< 0x00800000 */

#define ADC_SMPR1_SMP8_Pos                (24U)
#define ADC_SMPR1_SMP8_Msk                (0x7UL << ADC_SMPR1_SMP8_Pos)         /*!< 0x07000000 */
#define ADC_SMPR1_SMP8                    ADC_SMPR1_SMP8_Msk                    /*!< ADC Channel 8 Sampling time selection  */
#define ADC_SMPR1_SMP8_0                  (0x1UL << ADC_SMPR1_SMP8_Pos)         /*!< 0x01000000 */
#define ADC_SMPR1_SMP8_1                  (0x2UL << ADC_SMPR1_SMP8_Pos)         /*!< 0x02000000 */
#define ADC_SMPR1_SMP8_2                  (0x4UL << ADC_SMPR1_SMP8_Pos)         /*!< 0x04000000 */

#define ADC_SMPR1_SMP9_Pos                (27U)
#define ADC_SMPR1_SMP9_Msk                (0x7UL << ADC_SMPR1_SMP9_Pos)         /*!< 0x38000000 */
#define ADC_SMPR1_SMP9                    ADC_SMPR1_SMP9_Msk                    /*!< ADC Channel 9 Sampling time selection  */
#define ADC_SMPR1_SMP9_0                  (0x1UL << ADC_SMPR1_SMP9_Pos)         /*!< 0x08000000 */
#define ADC_SMPR1_SMP9_1                  (0x2UL << ADC_SMPR1_SMP9_Pos)         /*!< 0x10000000 */
#define ADC_SMPR1_SMP9_2                  (0x4UL << ADC_SMPR1_SMP9_Pos)         /*!< 0x20000000 */

#define ADC4_SMPR_SMP1_Pos                (0U)
#define ADC4_SMPR_SMP1_Msk                (0x7UL << ADC4_SMPR_SMP1_Pos)         /*!< 0x00000007 */
#define ADC4_SMPR_SMP1                    ADC4_SMPR_SMP1_Msk                    /*!< ADC Channel 0 Sampling time selection  */
#define ADC4_SMPR_SMP1_0                  (0x1UL << ADC4_SMPR_SMP1_Pos)         /*!< 0x00000001 */
#define ADC4_SMPR_SMP1_1                  (0x2UL << ADC4_SMPR_SMP1_Pos)         /*!< 0x00000002 */
#define ADC4_SMPR_SMP1_2                  (0x4UL << ADC4_SMPR_SMP1_Pos)         /*!< 0x00000004 */

#define ADC4_SMPR_SMP2_Pos                (4U)
#define ADC4_SMPR_SMP2_Msk                (0x7UL << ADC4_SMPR_SMP2_Pos)         /*!< 0x00000070 */
#define ADC4_SMPR_SMP2                    ADC4_SMPR_SMP2_Msk                    /*!< ADC group of channels sampling time 2 */
#define ADC4_SMPR_SMP2_0                  (0x1UL << ADC4_SMPR_SMP2_Pos)         /*!< 0x00000010 */
#define ADC4_SMPR_SMP2_1                  (0x2UL << ADC4_SMPR_SMP2_Pos)         /*!< 0x00000020 */
#define ADC4_SMPR_SMP2_2                  (0x4UL << ADC4_SMPR_SMP2_Pos)         /*!< 0x00000040 */

#define ADC4_SMPR_SMPSEL_Pos              (8U)
#define ADC4_SMPR_SMPSEL_Msk              (0xFFFFFFUL << ADC4_SMPR_SMPSEL_Pos)  /*!< 0xFFFFFF00 */
#define ADC4_SMPR_SMPSEL                  ADC4_SMPR_SMPSEL_Msk                  /*!< ADC4 all channels sampling time selection */
#define ADC4_SMPR_SMPSEL0_Pos             (8U)
#define ADC4_SMPR_SMPSEL0_Msk             (0x1UL << ADC4_SMPR_SMPSEL0_Pos)      /*!< 0x00000100 */
#define ADC4_SMPR_SMPSEL0                 ADC4_SMPR_SMPSEL0_Msk                 /*!< ADC4 channel 0 sampling time selection */
#define ADC4_SMPR_SMPSEL1_Pos             (9U)
#define ADC4_SMPR_SMPSEL1_Msk             (0x1UL << ADC4_SMPR_SMPSEL1_Pos)      /*!< 0x00000200 */
#define ADC4_SMPR_SMPSEL1                 ADC4_SMPR_SMPSEL1_Msk                 /*!< ADC4 channel 1 sampling time selection */
#define ADC4_SMPR_SMPSEL2_Pos             (10U)
#define ADC4_SMPR_SMPSEL2_Msk             (0x1UL << ADC4_SMPR_SMPSEL2_Pos)      /*!< 0x00000400 */
#define ADC4_SMPR_SMPSEL2                 ADC4_SMPR_SMPSEL2_Msk                 /*!< ADC4 channel 2 sampling time selection */
#define ADC4_SMPR_SMPSEL3_Pos             (11U)
#define ADC4_SMPR_SMPSEL3_Msk             (0x1UL << ADC4_SMPR_SMPSEL3_Pos)      /*!< 0x00000800 */
#define ADC4_SMPR_SMPSEL3                 ADC4_SMPR_SMPSEL3_Msk                 /*!< ADC4 channel 3 sampling time selection */
#define ADC4_SMPR_SMPSEL4_Pos             (12U)
#define ADC4_SMPR_SMPSEL4_Msk             (0x1UL << ADC4_SMPR_SMPSEL4_Pos)      /*!< 0x00001000 */
#define ADC4_SMPR_SMPSEL4                 ADC4_SMPR_SMPSEL4_Msk                 /*!< ADC4 channel 4 sampling time selection */
#define ADC4_SMPR_SMPSEL5_Pos             (13U)
#define ADC4_SMPR_SMPSEL5_Msk             (0x1UL << ADC4_SMPR_SMPSEL5_Pos)      /*!< 0x00002000 */
#define ADC4_SMPR_SMPSEL5                 ADC4_SMPR_SMPSEL5_Msk                 /*!< ADC4 channel 5 sampling time selection */
#define ADC4_SMPR_SMPSEL6_Pos             (14U)
#define ADC4_SMPR_SMPSEL6_Msk             (0x1UL << ADC4_SMPR_SMPSEL6_Pos)      /*!< 0x00004000 */
#define ADC4_SMPR_SMPSEL6                 ADC4_SMPR_SMPSEL6_Msk                 /*!< ADC4 channel 6 sampling time selection */
#define ADC4_SMPR_SMPSEL7_Pos             (15U)
#define ADC4_SMPR_SMPSEL7_Msk             (0x1UL << ADC4_SMPR_SMPSEL7_Pos)      /*!< 0x00008000 */
#define ADC4_SMPR_SMPSEL7                 ADC4_SMPR_SMPSEL7_Msk                 /*!< ADC4 channel 7 sampling time selection */
#define ADC4_SMPR_SMPSEL8_Pos             (16U)
#define ADC4_SMPR_SMPSEL8_Msk             (0x1UL << ADC4_SMPR_SMPSEL8_Pos)      /*!< 0x00010000 */
#define ADC4_SMPR_SMPSEL8                 ADC4_SMPR_SMPSEL8_Msk                 /*!< ADC4 channel 8 sampling time selection */
#define ADC4_SMPR_SMPSEL9_Pos             (17U)
#define ADC4_SMPR_SMPSEL9_Msk             (0x1UL << ADC4_SMPR_SMPSEL9_Pos)      /*!< 0x00020000 */
#define ADC4_SMPR_SMPSEL9                 ADC4_SMPR_SMPSEL9_Msk                 /*!< ADC4 channel 9 sampling time selection */
#define ADC4_SMPR_SMPSEL10_Pos            (18U)
#define ADC4_SMPR_SMPSEL10_Msk            (0x1UL << ADC4_SMPR_SMPSEL10_Pos)     /*!< 0x00040000 */
#define ADC4_SMPR_SMPSEL10                ADC4_SMPR_SMPSEL10_Msk                /*!< ADC4 channel 10 sampling time selection */
#define ADC4_SMPR_SMPSEL11_Pos            (19U)
#define ADC4_SMPR_SMPSEL11_Msk            (0x1UL << ADC4_SMPR_SMPSEL11_Pos)     /*!< 0x00080000 */
#define ADC4_SMPR_SMPSEL11                ADC4_SMPR_SMPSEL11_Msk                /*!< ADC4 channel 11 sampling time selection */
#define ADC4_SMPR_SMPSEL12_Pos            (20U)
#define ADC4_SMPR_SMPSEL12_Msk            (0x1UL << ADC4_SMPR_SMPSEL12_Pos)     /*!< 0x00100000 */
#define ADC4_SMPR_SMPSEL12                ADC4_SMPR_SMPSEL12_Msk                /*!< ADC4 channel 12 sampling time selection */
#define ADC4_SMPR_SMPSEL13_Pos            (21U)
#define ADC4_SMPR_SMPSEL13_Msk            (0x1UL << ADC4_SMPR_SMPSEL13_Pos)     /*!< 0x00200000 */
#define ADC4_SMPR_SMPSEL13                ADC4_SMPR_SMPSEL13_Msk                /*!< ADC4 channel 13 sampling time selection */
#define ADC4_SMPR_SMPSEL14_Pos            (22U)
#define ADC4_SMPR_SMPSEL14_Msk            (0x1UL << ADC4_SMPR_SMPSEL14_Pos)     /*!< 0x00400000 */
#define ADC4_SMPR_SMPSEL14                ADC4_SMPR_SMPSEL14_Msk                /*!< ADC4 channel 14 sampling time selection */
#define ADC4_SMPR_SMPSEL15_Pos            (23U)
#define ADC4_SMPR_SMPSEL15_Msk            (0x1UL << ADC4_SMPR_SMPSEL15_Pos)     /*!< 0x00800000 */
#define ADC4_SMPR_SMPSEL15                ADC4_SMPR_SMPSEL15_Msk                /*!< ADC4 channel 15 sampling time selection */
#define ADC4_SMPR_SMPSEL16_Pos            (24U)
#define ADC4_SMPR_SMPSEL16_Msk            (0x1UL << ADC4_SMPR_SMPSEL16_Pos)     /*!< 0x01000000 */
#define ADC4_SMPR_SMPSEL16                ADC4_SMPR_SMPSEL16_Msk                /*!< ADC4 channel 16 sampling time selection */
#define ADC4_SMPR_SMPSEL17_Pos            (25U)
#define ADC4_SMPR_SMPSEL17_Msk            (0x1UL << ADC4_SMPR_SMPSEL17_Pos)     /*!< 0x02000000 */
#define ADC4_SMPR_SMPSEL17                ADC4_SMPR_SMPSEL17_Msk                /*!< ADC4 channel 17 sampling time selection */
#define ADC4_SMPR_SMPSEL18_Pos            (26U)
#define ADC4_SMPR_SMPSEL18_Msk            (0x1UL << ADC4_SMPR_SMPSEL18_Pos)     /*!< 0x04000000 */
#define ADC4_SMPR_SMPSEL18                ADC4_SMPR_SMPSEL18_Msk                /*!< ADC4 channel 18 sampling time selection */
#define ADC4_SMPR_SMPSEL19_Pos            (27U)
#define ADC4_SMPR_SMPSEL19_Msk            (0x1UL << ADC4_SMPR_SMPSEL19_Pos)     /*!< 0x08000000 */
#define ADC4_SMPR_SMPSEL19                ADC4_SMPR_SMPSEL19_Msk                /*!< ADC4 channel 19 sampling time selection */
#define ADC4_SMPR_SMPSEL20_Pos            (26U)
#define ADC4_SMPR_SMPSEL20_Msk            (0x1UL << ADC4_SMPR_SMPSEL20_Pos)     /*!< 0x10000000 */
#define ADC4_SMPR_SMPSEL20                ADC4_SMPR_SMPSEL20_Msk                /*!< ADC4 channel 20 sampling time selection */
#define ADC4_SMPR_SMPSEL21_Pos            (26U)
#define ADC4_SMPR_SMPSEL21_Msk            (0x1UL << ADC4_SMPR_SMPSEL21_Pos)     /*!< 0x20000000 */
#define ADC4_SMPR_SMPSEL21                ADC4_SMPR_SMPSEL21_Msk                /*!< ADC4 channel 20 sampling time selection */
#define ADC4_SMPR_SMPSEL22_Pos            (30U)
#define ADC4_SMPR_SMPSEL22_Msk            (0x1UL << ADC4_SMPR_SMPSEL22_Pos)     /*!< 0x40000000 */
#define ADC4_SMPR_SMPSEL22                ADC4_SMPR_SMPSEL22_Msk                /*!< ADC4 channel 21 sampling time selection */
#define ADC4_SMPR_SMPSEL23_Pos            (31U)
#define ADC4_SMPR_SMPSEL23_Msk            (0x1UL << ADC4_SMPR_SMPSEL23_Pos)     /*!< 0x80000000 */
#define ADC4_SMPR_SMPSEL23                ADC4_SMPR_SMPSEL23_Msk                /*!< ADC4 channel 23 sampling time selection */

/********************  Bit definition for ADC_SMPR2 register  ********************/
#define ADC_SMPR2_SMP10_Pos               (0U)
#define ADC_SMPR2_SMP10_Msk               (0x7UL << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000007 */
#define ADC_SMPR2_SMP10                   ADC_SMPR2_SMP10_Msk                   /*!< ADC Channel 10 Sampling time selection  */
#define ADC_SMPR2_SMP10_0                 (0x1UL << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000001 */
#define ADC_SMPR2_SMP10_1                 (0x2UL << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000002 */
#define ADC_SMPR2_SMP10_2                 (0x4UL << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000004 */

#define ADC_SMPR2_SMP11_Pos               (3U)
#define ADC_SMPR2_SMP11_Msk               (0x7UL << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000038 */
#define ADC_SMPR2_SMP11                   ADC_SMPR2_SMP11_Msk                   /*!< ADC Channel 11 Sampling time selection  */
#define ADC_SMPR2_SMP11_0                 (0x1UL << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000008 */
#define ADC_SMPR2_SMP11_1                 (0x2UL << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000010 */
#define ADC_SMPR2_SMP11_2                 (0x4UL << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000020 */

#define ADC_SMPR2_SMP12_Pos               (6U)
#define ADC_SMPR2_SMP12_Msk               (0x7UL << ADC_SMPR2_SMP12_Pos)        /*!< 0x000001C0 */
#define ADC_SMPR2_SMP12                   ADC_SMPR2_SMP12_Msk                   /*!< ADC Channel 12 Sampling time selection  */
#define ADC_SMPR2_SMP12_0                 (0x1UL << ADC_SMPR2_SMP12_Pos)        /*!< 0x00000040 */
#define ADC_SMPR2_SMP12_1                 (0x2UL << ADC_SMPR2_SMP12_Pos)        /*!< 0x00000080 */
#define ADC_SMPR2_SMP12_2                 (0x4UL << ADC_SMPR2_SMP12_Pos)        /*!< 0x00000100 */

#define ADC_SMPR2_SMP13_Pos               (9U)
#define ADC_SMPR2_SMP13_Msk               (0x7UL << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000E00 */
#define ADC_SMPR2_SMP13                   ADC_SMPR2_SMP13_Msk                   /*!< ADC Channel 13 Sampling time selection  */
#define ADC_SMPR2_SMP13_0                 (0x1UL << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000200 */
#define ADC_SMPR2_SMP13_1                 (0x2UL << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000400 */
#define ADC_SMPR2_SMP13_2                 (0x4UL << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000800 */

#define ADC_SMPR2_SMP14_Pos               (12U)
#define ADC_SMPR2_SMP14_Msk               (0x7UL << ADC_SMPR2_SMP14_Pos)        /*!< 0x00007000 */
#define ADC_SMPR2_SMP14                   ADC_SMPR2_SMP14_Msk                   /*!< ADC Channel 14 Sampling time selection  */
#define ADC_SMPR2_SMP14_0                 (0x1UL << ADC_SMPR2_SMP14_Pos)        /*!< 0x00001000 */
#define ADC_SMPR2_SMP14_1                 (0x2UL << ADC_SMPR2_SMP14_Pos)        /*!< 0x00002000 */
#define ADC_SMPR2_SMP14_2                 (0x4UL << ADC_SMPR2_SMP14_Pos)        /*!< 0x00004000 */

#define ADC_SMPR2_SMP15_Pos               (15U)
#define ADC_SMPR2_SMP15_Msk               (0x7UL << ADC_SMPR2_SMP15_Pos)        /*!< 0x00038000 */
#define ADC_SMPR2_SMP15                   ADC_SMPR2_SMP15_Msk                   /*!< ADC Channel 15 Sampling time selection  */
#define ADC_SMPR2_SMP15_0                 (0x1UL << ADC_SMPR2_SMP15_Pos)        /*!< 0x00008000 */
#define ADC_SMPR2_SMP15_1                 (0x2UL << ADC_SMPR2_SMP15_Pos)        /*!< 0x00010000 */
#define ADC_SMPR2_SMP15_2                 (0x4UL << ADC_SMPR2_SMP15_Pos)        /*!< 0x00020000 */

#define ADC_SMPR2_SMP16_Pos               (18U)
#define ADC_SMPR2_SMP16_Msk               (0x7UL << ADC_SMPR2_SMP16_Pos)        /*!< 0x001C0000 */
#define ADC_SMPR2_SMP16                   ADC_SMPR2_SMP16_Msk                   /*!< ADC Channel 16 Sampling time selection  */
#define ADC_SMPR2_SMP16_0                 (0x1UL << ADC_SMPR2_SMP16_Pos)        /*!< 0x00040000 */
#define ADC_SMPR2_SMP16_1                 (0x2UL << ADC_SMPR2_SMP16_Pos)        /*!< 0x00080000 */
#define ADC_SMPR2_SMP16_2                 (0x4UL << ADC_SMPR2_SMP16_Pos)        /*!< 0x00100000 */

#define ADC_SMPR2_SMP17_Pos               (21U)
#define ADC_SMPR2_SMP17_Msk               (0x7UL << ADC_SMPR2_SMP17_Pos)        /*!< 0x00E00000 */
#define ADC_SMPR2_SMP17                   ADC_SMPR2_SMP17_Msk                   /*!< ADC Channel 17 Sampling time selection  */
#define ADC_SMPR2_SMP17_0                 (0x1UL << ADC_SMPR2_SMP17_Pos)        /*!< 0x00200000 */
#define ADC_SMPR2_SMP17_1                 (0x2UL << ADC_SMPR2_SMP17_Pos)        /*!< 0x00400000 */
#define ADC_SMPR2_SMP17_2                 (0x4UL << ADC_SMPR2_SMP17_Pos)        /*!< 0x00800000 */

#define ADC_SMPR2_SMP18_Pos               (24U)
#define ADC_SMPR2_SMP18_Msk               (0x7UL << ADC_SMPR2_SMP18_Pos)        /*!< 0x07000000 */
#define ADC_SMPR2_SMP18                   ADC_SMPR2_SMP18_Msk                   /*!< ADC Channel 18 Sampling time selection  */
#define ADC_SMPR2_SMP18_0                 (0x1UL << ADC_SMPR2_SMP18_Pos)        /*!< 0x01000000 */
#define ADC_SMPR2_SMP18_1                 (0x2UL << ADC_SMPR2_SMP18_Pos)        /*!< 0x02000000 */
#define ADC_SMPR2_SMP18_2                 (0x4UL << ADC_SMPR2_SMP18_Pos)        /*!< 0x04000000 */

#define ADC_SMPR2_SMP19_Pos               (27U)
#define ADC_SMPR2_SMP19_Msk               (0x7UL << ADC_SMPR2_SMP19_Pos)        /*!< 0x38000000 */
#define ADC_SMPR2_SMP19                   ADC_SMPR2_SMP19_Msk                   /*!< ADC Channel 19 Sampling time selection  */
#define ADC_SMPR2_SMP19_0                 (0x1UL << ADC_SMPR2_SMP19_Pos)        /*!< 0x08000000 */
#define ADC_SMPR2_SMP19_1                 (0x2UL << ADC_SMPR2_SMP19_Pos)        /*!< 0x10000000 */
#define ADC_SMPR2_SMP19_2                 (0x4UL << ADC_SMPR2_SMP19_Pos)        /*!< 0x20000000 */

/********************  Bit definition for ADC_PCSEL register  ********************/
#define ADC_PCSEL_PCSEL_Pos               (0U)
#define ADC_PCSEL_PCSEL_Msk               (0xFFFFFUL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x000FFFFF */
#define ADC_PCSEL_PCSEL                   ADC_PCSEL_PCSEL_Msk                   /*!< ADC pre channel selection */
#define ADC_PCSEL_PCSEL_0                 (0x00001UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000001 */
#define ADC_PCSEL_PCSEL_1                 (0x00002UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000002 */
#define ADC_PCSEL_PCSEL_2                 (0x00004UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000004 */
#define ADC_PCSEL_PCSEL_3                 (0x00008UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000008 */
#define ADC_PCSEL_PCSEL_4                 (0x00010UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000010 */
#define ADC_PCSEL_PCSEL_5                 (0x00020UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000020 */
#define ADC_PCSEL_PCSEL_6                 (0x00040UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000040 */
#define ADC_PCSEL_PCSEL_7                 (0x00080UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000080 */
#define ADC_PCSEL_PCSEL_8                 (0x00100UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000100 */
#define ADC_PCSEL_PCSEL_9                 (0x00200UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000200 */
#define ADC_PCSEL_PCSEL_10                (0x00400UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000400 */
#define ADC_PCSEL_PCSEL_11                (0x00800UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000800 */
#define ADC_PCSEL_PCSEL_12                (0x01000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00001000 */
#define ADC_PCSEL_PCSEL_13                (0x02000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00002000 */
#define ADC_PCSEL_PCSEL_14                (0x04000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00004000 */
#define ADC_PCSEL_PCSEL_15                (0x08000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00008000 */
#define ADC_PCSEL_PCSEL_16                (0x10000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00010000 */
#define ADC_PCSEL_PCSEL_17                (0x20000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00020000 */
#define ADC_PCSEL_PCSEL_18                (0x40000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00040000 */
#define ADC_PCSEL_PCSEL_19                (0x80000UL << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00080000 */

/*****************  Bit definition for ADC_LTR1, 2, 3 registers *****************/
#define ADC_LTR_LT_Pos                    (0U)
#define ADC_LTR_LT_Msk                    (0x01FFFFFFUL << ADC_LTR_LT_Pos)      /*!< 0x01FFFFFF */
#define ADC_LTR_LT                        ADC_LTR_LT_Msk                        /*!< ADC Analog watchdog 1, 2 and 3 lower threshold */

/*****************  Bit definition for ADC_HTR1, 2, 3 registers  ****************/
#define ADC_HTR_HT_Pos                    (0U)
#define ADC_HTR_HT_Msk                    (0x01FFFFFFUL << ADC_HTR_HT_Pos)      /*!< 0x01FFFFFF */
#define ADC_HTR_HT                        ADC_HTR_HT_Msk                        /*!< ADC Analog watchdog 1,2 and 3 higher threshold */

#define ADC_HTR_AWDFILT_Pos               (29U)
#define ADC_HTR_AWDFILT_Msk               (0x7UL << ADC_HTR_AWDFILT_Pos)        /*!< 0xE0000000 */
#define ADC_HTR_AWDFILT                   ADC_HTR_AWDFILT_Msk                   /*!< Analog watchdog filtering parameter, HTR1 only */
#define ADC_HTR_AWDFILT_0                 (0x1UL << ADC_HTR_AWDFILT_Pos)        /*!< 0x20000000 */
#define ADC_HTR_AWDFILT_1                 (0x2UL << ADC_HTR_AWDFILT_Pos)        /*!< 0x40000000 */
#define ADC_HTR_AWDFILT_2                 (0x4UL << ADC_HTR_AWDFILT_Pos)        /*!< 0x80000000 */

/********************  Bit definition for ADC_SQR1 register  ********************/
#define ADC_SQR1_L_Pos                    (0U)
#define ADC_SQR1_L_Msk                    (0xFUL << ADC_SQR1_L_Pos)             /*!< 0x0000000F */
#define ADC_SQR1_L                        ADC_SQR1_L_Msk                        /*!< ADC regular channel sequence length */
#define ADC_SQR1_L_0                      (0x1UL << ADC_SQR1_L_Pos)             /*!< 0x00000001 */
#define ADC_SQR1_L_1                      (0x2UL << ADC_SQR1_L_Pos)             /*!< 0x00000002 */
#define ADC_SQR1_L_2                      (0x4UL << ADC_SQR1_L_Pos)             /*!< 0x00000004 */
#define ADC_SQR1_L_3                      (0x8UL << ADC_SQR1_L_Pos)             /*!< 0x00000008 */

#define ADC_SQR1_SQ1_Pos                  (6U)
#define ADC_SQR1_SQ1_Msk                  (0x1FUL << ADC_SQR1_SQ1_Pos)          /*!< 0x000007C0 */
#define ADC_SQR1_SQ1                      ADC_SQR1_SQ1_Msk                      /*!< ADC 1st conversion in regular sequence */
#define ADC_SQR1_SQ1_0                    (0x01UL << ADC_SQR1_SQ1_Pos)          /*!< 0x00000040 */
#define ADC_SQR1_SQ1_1                    (0x02UL << ADC_SQR1_SQ1_Pos)          /*!< 0x00000080 */
#define ADC_SQR1_SQ1_2                    (0x04UL << ADC_SQR1_SQ1_Pos)          /*!< 0x00000100 */
#define ADC_SQR1_SQ1_3                    (0x08UL << ADC_SQR1_SQ1_Pos)          /*!< 0x00000200 */
#define ADC_SQR1_SQ1_4                    (0x10UL << ADC_SQR1_SQ1_Pos)          /*!< 0x00000400 */

#define ADC_SQR1_SQ2_Pos                  (12U)
#define ADC_SQR1_SQ2_Msk                  (0x1FUL << ADC_SQR1_SQ2_Pos)          /*!< 0x0001F000 */
#define ADC_SQR1_SQ2                      ADC_SQR1_SQ2_Msk                      /*!< ADC 2nd conversion in regular sequence */
#define ADC_SQR1_SQ2_0                    (0x01UL << ADC_SQR1_SQ2_Pos)          /*!< 0x00001000 */
#define ADC_SQR1_SQ2_1                    (0x02UL << ADC_SQR1_SQ2_Pos)          /*!< 0x00002000 */
#define ADC_SQR1_SQ2_2                    (0x04UL << ADC_SQR1_SQ2_Pos)          /*!< 0x00004000 */
#define ADC_SQR1_SQ2_3                    (0x08UL << ADC_SQR1_SQ2_Pos)          /*!< 0x00008000 */
#define ADC_SQR1_SQ2_4                    (0x10UL << ADC_SQR1_SQ2_Pos)          /*!< 0x00010000 */

#define ADC_SQR1_SQ3_Pos                  (18U)
#define ADC_SQR1_SQ3_Msk                  (0x1FUL << ADC_SQR1_SQ3_Pos)          /*!< 0x007C0000 */
#define ADC_SQR1_SQ3                      ADC_SQR1_SQ3_Msk                      /*!< ADC 3rd conversion in regular sequence */
#define ADC_SQR1_SQ3_0                    (0x01UL << ADC_SQR1_SQ3_Pos)          /*!< 0x00040000 */
#define ADC_SQR1_SQ3_1                    (0x02UL << ADC_SQR1_SQ3_Pos)          /*!< 0x00080000 */
#define ADC_SQR1_SQ3_2                    (0x04UL << ADC_SQR1_SQ3_Pos)          /*!< 0x00100000 */
#define ADC_SQR1_SQ3_3                    (0x08UL << ADC_SQR1_SQ3_Pos)          /*!< 0x00200000 */
#define ADC_SQR1_SQ3_4                    (0x10UL << ADC_SQR1_SQ3_Pos)          /*!< 0x00400000 */

#define ADC_SQR1_SQ4_Pos                  (24U)
#define ADC_SQR1_SQ4_Msk                  (0x1FUL << ADC_SQR1_SQ4_Pos)          /*!< 0x1F000000 */
#define ADC_SQR1_SQ4                      ADC_SQR1_SQ4_Msk                      /*!< ADC 4th conversion in regular sequence */
#define ADC_SQR1_SQ4_0                    (0x01UL << ADC_SQR1_SQ4_Pos)          /*!< 0x01000000 */
#define ADC_SQR1_SQ4_1                    (0x02UL << ADC_SQR1_SQ4_Pos)          /*!< 0x02000000 */
#define ADC_SQR1_SQ4_2                    (0x04UL << ADC_SQR1_SQ4_Pos)          /*!< 0x04000000 */
#define ADC_SQR1_SQ4_3                    (0x08UL << ADC_SQR1_SQ4_Pos)          /*!< 0x08000000 */
#define ADC_SQR1_SQ4_4                    (0x10UL << ADC_SQR1_SQ4_Pos)          /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR2 register  ********************/
#define ADC_SQR2_SQ5_Pos                  (0U)
#define ADC_SQR2_SQ5_Msk                  (0x1FUL << ADC_SQR2_SQ5_Pos)          /*!< 0x0000001F */
#define ADC_SQR2_SQ5                      ADC_SQR2_SQ5_Msk                      /*!< ADC 5th conversion in regular sequence */
#define ADC_SQR2_SQ5_0                    (0x01UL << ADC_SQR2_SQ5_Pos)          /*!< 0x00000001 */
#define ADC_SQR2_SQ5_1                    (0x02UL << ADC_SQR2_SQ5_Pos)          /*!< 0x00000002 */
#define ADC_SQR2_SQ5_2                    (0x04UL << ADC_SQR2_SQ5_Pos)          /*!< 0x00000004 */
#define ADC_SQR2_SQ5_3                    (0x08UL << ADC_SQR2_SQ5_Pos)          /*!< 0x00000008 */
#define ADC_SQR2_SQ5_4                    (0x10UL << ADC_SQR2_SQ5_Pos)          /*!< 0x00000010 */

#define ADC_SQR2_SQ6_Pos                  (6U)
#define ADC_SQR2_SQ6_Msk                  (0x1FUL << ADC_SQR2_SQ6_Pos)          /*!< 0x000007C0 */
#define ADC_SQR2_SQ6                      ADC_SQR2_SQ6_Msk                      /*!< ADC 6th conversion in regular sequence */
#define ADC_SQR2_SQ6_0                    (0x01UL << ADC_SQR2_SQ6_Pos)          /*!< 0x00000040 */
#define ADC_SQR2_SQ6_1                    (0x02UL << ADC_SQR2_SQ6_Pos)          /*!< 0x00000080 */
#define ADC_SQR2_SQ6_2                    (0x04UL << ADC_SQR2_SQ6_Pos)          /*!< 0x00000100 */
#define ADC_SQR2_SQ6_3                    (0x08UL << ADC_SQR2_SQ6_Pos)          /*!< 0x00000200 */
#define ADC_SQR2_SQ6_4                    (0x10UL << ADC_SQR2_SQ6_Pos)          /*!< 0x00000400 */

#define ADC_SQR2_SQ7_Pos                  (12U)
#define ADC_SQR2_SQ7_Msk                  (0x1FUL << ADC_SQR2_SQ7_Pos)          /*!< 0x0001F000 */
#define ADC_SQR2_SQ7                      ADC_SQR2_SQ7_Msk                      /*!< ADC 7th conversion in regular sequence */
#define ADC_SQR2_SQ7_0                    (0x01UL << ADC_SQR2_SQ7_Pos)          /*!< 0x00001000 */
#define ADC_SQR2_SQ7_1                    (0x02UL << ADC_SQR2_SQ7_Pos)          /*!< 0x00002000 */
#define ADC_SQR2_SQ7_2                    (0x04UL << ADC_SQR2_SQ7_Pos)          /*!< 0x00004000 */
#define ADC_SQR2_SQ7_3                    (0x08UL << ADC_SQR2_SQ7_Pos)          /*!< 0x00008000 */
#define ADC_SQR2_SQ7_4                    (0x10UL << ADC_SQR2_SQ7_Pos)          /*!< 0x00010000 */

#define ADC_SQR2_SQ8_Pos                  (18U)
#define ADC_SQR2_SQ8_Msk                  (0x1FUL << ADC_SQR2_SQ8_Pos)          /*!< 0x007C0000 */
#define ADC_SQR2_SQ8                      ADC_SQR2_SQ8_Msk                      /*!< ADC 8th conversion in regular sequence */
#define ADC_SQR2_SQ8_0                    (0x01UL << ADC_SQR2_SQ8_Pos)          /*!< 0x00040000 */
#define ADC_SQR2_SQ8_1                    (0x02UL << ADC_SQR2_SQ8_Pos)          /*!< 0x00080000 */
#define ADC_SQR2_SQ8_2                    (0x04UL << ADC_SQR2_SQ8_Pos)          /*!< 0x00100000 */
#define ADC_SQR2_SQ8_3                    (0x08UL << ADC_SQR2_SQ8_Pos)          /*!< 0x00200000 */
#define ADC_SQR2_SQ8_4                    (0x10UL << ADC_SQR2_SQ8_Pos)          /*!< 0x00400000 */

#define ADC_SQR2_SQ9_Pos                  (24U)
#define ADC_SQR2_SQ9_Msk                  (0x1FUL << ADC_SQR2_SQ9_Pos)          /*!< 0x1F000000 */
#define ADC_SQR2_SQ9                      ADC_SQR2_SQ9_Msk                      /*!< ADC 9th conversion in regular sequence */
#define ADC_SQR2_SQ9_0                    (0x01UL << ADC_SQR2_SQ9_Pos)          /*!< 0x01000000 */
#define ADC_SQR2_SQ9_1                    (0x02UL << ADC_SQR2_SQ9_Pos)          /*!< 0x02000000 */
#define ADC_SQR2_SQ9_2                    (0x04UL << ADC_SQR2_SQ9_Pos)          /*!< 0x04000000 */
#define ADC_SQR2_SQ9_3                    (0x08UL << ADC_SQR2_SQ9_Pos)          /*!< 0x08000000 */
#define ADC_SQR2_SQ9_4                    (0x10UL << ADC_SQR2_SQ9_Pos)          /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR3 register  ********************/
#define ADC_SQR3_SQ10_Pos                 (0U)
#define ADC_SQR3_SQ10_Msk                 (0x1FUL << ADC_SQR3_SQ10_Pos)         /*!< 0x0000001F */
#define ADC_SQR3_SQ10                     ADC_SQR3_SQ10_Msk                     /*!< ADC 10th conversion in regular sequence */
#define ADC_SQR3_SQ10_0                   (0x01UL << ADC_SQR3_SQ10_Pos)         /*!< 0x00000001 */
#define ADC_SQR3_SQ10_1                   (0x02UL << ADC_SQR3_SQ10_Pos)         /*!< 0x00000002 */
#define ADC_SQR3_SQ10_2                   (0x04UL << ADC_SQR3_SQ10_Pos)         /*!< 0x00000004 */
#define ADC_SQR3_SQ10_3                   (0x08UL << ADC_SQR3_SQ10_Pos)         /*!< 0x00000008 */
#define ADC_SQR3_SQ10_4                   (0x10UL << ADC_SQR3_SQ10_Pos)         /*!< 0x00000010 */

#define ADC_SQR3_SQ11_Pos                 (6U)
#define ADC_SQR3_SQ11_Msk                 (0x1FUL << ADC_SQR3_SQ11_Pos)         /*!< 0x000007C0 */
#define ADC_SQR3_SQ11                     ADC_SQR3_SQ11_Msk                     /*!< ADC 11th conversion in regular sequence */
#define ADC_SQR3_SQ11_0                   (0x01UL << ADC_SQR3_SQ11_Pos)         /*!< 0x00000040 */
#define ADC_SQR3_SQ11_1                   (0x02UL << ADC_SQR3_SQ11_Pos)         /*!< 0x00000080 */
#define ADC_SQR3_SQ11_2                   (0x04UL << ADC_SQR3_SQ11_Pos)         /*!< 0x00000100 */
#define ADC_SQR3_SQ11_3                   (0x08UL << ADC_SQR3_SQ11_Pos)         /*!< 0x00000200 */
#define ADC_SQR3_SQ11_4                   (0x10UL << ADC_SQR3_SQ11_Pos)         /*!< 0x00000400 */

#define ADC_SQR3_SQ12_Pos                 (12U)
#define ADC_SQR3_SQ12_Msk                 (0x1FUL << ADC_SQR3_SQ12_Pos)         /*!< 0x0001F000 */
#define ADC_SQR3_SQ12                     ADC_SQR3_SQ12_Msk                     /*!< ADC 12th conversion in regular sequence */
#define ADC_SQR3_SQ12_0                   (0x01UL << ADC_SQR3_SQ12_Pos)         /*!< 0x00001000 */
#define ADC_SQR3_SQ12_1                   (0x02UL << ADC_SQR3_SQ12_Pos)         /*!< 0x00002000 */
#define ADC_SQR3_SQ12_2                   (0x04UL << ADC_SQR3_SQ12_Pos)         /*!< 0x00004000 */
#define ADC_SQR3_SQ12_3                   (0x08UL << ADC_SQR3_SQ12_Pos)         /*!< 0x00008000 */
#define ADC_SQR3_SQ12_4                   (0x10UL << ADC_SQR3_SQ12_Pos)         /*!< 0x00010000 */

#define ADC_SQR3_SQ13_Pos                 (18U)
#define ADC_SQR3_SQ13_Msk                 (0x1FUL << ADC_SQR3_SQ13_Pos)         /*!< 0x007C0000 */
#define ADC_SQR3_SQ13                     ADC_SQR3_SQ13_Msk                     /*!< ADC 13th conversion in regular sequence */
#define ADC_SQR3_SQ13_0                   (0x01UL << ADC_SQR3_SQ13_Pos)         /*!< 0x00040000 */
#define ADC_SQR3_SQ13_1                   (0x02UL << ADC_SQR3_SQ13_Pos)         /*!< 0x00080000 */
#define ADC_SQR3_SQ13_2                   (0x04UL << ADC_SQR3_SQ13_Pos)         /*!< 0x00100000 */
#define ADC_SQR3_SQ13_3                   (0x08UL << ADC_SQR3_SQ13_Pos)         /*!< 0x00200000 */
#define ADC_SQR3_SQ13_4                   (0x10UL << ADC_SQR3_SQ13_Pos)         /*!< 0x00400000 */

#define ADC_SQR3_SQ14_Pos                 (24U)
#define ADC_SQR3_SQ14_Msk                 (0x1FUL << ADC_SQR3_SQ14_Pos)         /*!< 0x1F000000 */
#define ADC_SQR3_SQ14                     ADC_SQR3_SQ14_Msk                     /*!< ADC 14th conversion in regular sequence */
#define ADC_SQR3_SQ14_0                   (0x01UL << ADC_SQR3_SQ14_Pos)         /*!< 0x01000000 */
#define ADC_SQR3_SQ14_1                   (0x02UL << ADC_SQR3_SQ14_Pos)         /*!< 0x02000000 */
#define ADC_SQR3_SQ14_2                   (0x04UL << ADC_SQR3_SQ14_Pos)         /*!< 0x04000000 */
#define ADC_SQR3_SQ14_3                   (0x08UL << ADC_SQR3_SQ14_Pos)         /*!< 0x08000000 */
#define ADC_SQR3_SQ14_4                   (0x10UL << ADC_SQR3_SQ14_Pos)         /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR4 register  ********************/
#define ADC_SQR4_SQ15_Pos                 (0U)
#define ADC_SQR4_SQ15_Msk                 (0x1FUL << ADC_SQR4_SQ15_Pos)         /*!< 0x0000001F */
#define ADC_SQR4_SQ15                     ADC_SQR4_SQ15_Msk                     /*!< ADC 15th conversion in regular sequence */
#define ADC_SQR4_SQ15_0                   (0x01UL << ADC_SQR4_SQ15_Pos)         /*!< 0x00000001 */
#define ADC_SQR4_SQ15_1                   (0x02UL << ADC_SQR4_SQ15_Pos)         /*!< 0x00000002 */
#define ADC_SQR4_SQ15_2                   (0x04UL << ADC_SQR4_SQ15_Pos)         /*!< 0x00000004 */
#define ADC_SQR4_SQ15_3                   (0x08UL << ADC_SQR4_SQ15_Pos)         /*!< 0x00000008 */
#define ADC_SQR4_SQ15_4                   (0x10UL << ADC_SQR4_SQ15_Pos)         /*!< 0x00000010 */

#define ADC_SQR4_SQ16_Pos                 (6U)
#define ADC_SQR4_SQ16_Msk                 (0x1FUL << ADC_SQR4_SQ16_Pos)         /*!< 0x000007C0 */
#define ADC_SQR4_SQ16                     ADC_SQR4_SQ16_Msk                     /*!< ADC 16th conversion in regular sequence */
#define ADC_SQR4_SQ16_0                   (0x01UL << ADC_SQR4_SQ16_Pos)         /*!< 0x00000040 */
#define ADC_SQR4_SQ16_1                   (0x02UL << ADC_SQR4_SQ16_Pos)         /*!< 0x00000080 */
#define ADC_SQR4_SQ16_2                   (0x04UL << ADC_SQR4_SQ16_Pos)         /*!< 0x00000100 */
#define ADC_SQR4_SQ16_3                   (0x08UL << ADC_SQR4_SQ16_Pos)         /*!< 0x00000200 */
#define ADC_SQR4_SQ16_4                   (0x10UL << ADC_SQR4_SQ16_Pos)         /*!< 0x00000400 */
/********************  Bit definition for ADC_DR register  ********************/
#define ADC_DR_RDATA_Pos                  (0U)
#define ADC_DR_RDATA_Msk                  (0xFFFFFFFFUL << ADC_DR_RDATA_Pos)    /*!< 0xFFFFFFFF */
#define ADC_DR_RDATA                      ADC_DR_RDATA_Msk                      /*!< ADC regular Data converted */

/********************  Bit definition for ADC_PW register  ********************/
#define ADC4_PWRR_AUTOFF_Pos              (0U)
#define ADC4_PWRR_AUTOFF_Msk              (0x1UL << ADC4_PWRR_AUTOFF_Pos)       /*!< 0x00000001 */
#define ADC4_PWRR_AUTOFF                  ADC4_PWRR_AUTOFF_Msk                  /*!< ADC Auto-Off mode */
#define ADC4_PWRR_DPD_Pos                 (1U)
#define ADC4_PWRR_DPD_Msk                 (0x1UL << ADC4_PWRR_DPD_Pos)          /*!< 0x00000002 */
#define ADC4_PWRR_DPD                     ADC4_PWRR_DPD_Msk                     /*!< ADC Deep Power mode */
#define ADC4_PWRR_VREFPROT_Pos            (2U)
#define ADC4_PWRR_VREFPROT_Msk            (0x1UL << ADC4_PWRR_VREFPROT_Pos)     /*!< 0x00000004 */
#define ADC4_PWRR_VREFPROT                ADC4_PWRR_VREFPROT_Msk                /*!< ADC Vref protection */
#define ADC4_PWRR_VREFSECSMP_Pos          (3U)
#define ADC4_PWRR_VREFSECSMP_Msk          (0x1UL << ADC4_PWRR_VREFSECSMP_Pos)   /*!< 0x00000008 */
#define ADC4_PWRR_VREFSECSMP              ADC4_PWRR_VREFSECSMP_Msk              /*!< ADC Vref Second Sample */

/* Legacy definitions */
#define ADC4_PW_AUTOFF_Pos                ADC4_PWRR_AUTOFF_Pos
#define ADC4_PW_AUTOFF_Msk                ADC4_PWRR_AUTOFF_Msk
#define ADC4_PW_AUTOFF                    ADC4_PWRR_AUTOFF
#define ADC4_PW_DPD_Pos                   ADC4_PWRR_DPD_Pos
#define ADC4_PW_DPD_Msk                   ADC4_PWRR_DPD_Msk
#define ADC4_PW_DPD                       ADC4_PWRR_DPD
#define ADC4_PW_VREFPROT_Pos              ADC4_PWRR_VREFPROT_Pos
#define ADC4_PW_VREFPROT_Msk              ADC4_PWRR_VREFPROT_Msk
#define ADC4_PW_VREFPROT                  ADC4_PWRR_VREFPROT
#define ADC4_PW_VREFSECSMP_Pos            ADC4_PWRR_VREFSECSMP_Pos
#define ADC4_PW_VREFSECSMP_Msk            ADC4_PWRR_VREFSECSMP_Msk
#define ADC4_PW_VREFSECSMP                ADC4_PWRR_VREFSECSMP

/********************  Bit definition for ADC_JSQR register  ********************/
#define ADC_JSQR_JL_Pos                   (0U)
#define ADC_JSQR_JL_Msk                   (0x3UL << ADC_JSQR_JL_Pos)            /*!< 0x00000003 */
#define ADC_JSQR_JL                       ADC_JSQR_JL_Msk                       /*!< ADC injected channel sequence length */
#define ADC_JSQR_JL_0                     (0x1UL << ADC_JSQR_JL_Pos)            /*!< 0x00000001 */
#define ADC_JSQR_JL_1                     (0x2UL << ADC_JSQR_JL_Pos)            /*!< 0x00000002 */

#define ADC_JSQR_JEXTSEL_Pos              (2U)
#define ADC_JSQR_JEXTSEL_Msk              (0x1FUL << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x0000007C */
#define ADC_JSQR_JEXTSEL                  ADC_JSQR_JEXTSEL_Msk                  /*!< ADC external trigger selection for injected group */
#define ADC_JSQR_JEXTSEL_0                (0x01UL << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000004 */
#define ADC_JSQR_JEXTSEL_1                (0x02UL << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000008 */
#define ADC_JSQR_JEXTSEL_2                (0x04UL << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000010 */
#define ADC_JSQR_JEXTSEL_3                (0x08UL << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000020 */
#define ADC_JSQR_JEXTSEL_4                (0x10UL << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000040 */

#define ADC_JSQR_JEXTEN_Pos               (7U)
#define ADC_JSQR_JEXTEN_Msk               (0x3UL << ADC_JSQR_JEXTEN_Pos)        /*!< 0x00000180 */
#define ADC_JSQR_JEXTEN                   ADC_JSQR_JEXTEN_Msk                   /*!< ADC external trigger enable and polarity selection for injected channels */
#define ADC_JSQR_JEXTEN_0                 (0x1UL << ADC_JSQR_JEXTEN_Pos)        /*!< 0x00000080 */
#define ADC_JSQR_JEXTEN_1                 (0x2UL << ADC_JSQR_JEXTEN_Pos)        /*!< 0x00000100 */

#define ADC_JSQR_JSQ1_Pos                 (9U)
#define ADC_JSQR_JSQ1_Msk                 (0x1FUL << ADC_JSQR_JSQ1_Pos)         /*!< 0x00003E00 */
#define ADC_JSQR_JSQ1                     ADC_JSQR_JSQ1_Msk                     /*!< ADC 1st conversion in injected sequence */
#define ADC_JSQR_JSQ1_0                   (0x01UL << ADC_JSQR_JSQ1_Pos)         /*!< 0x00000200 */
#define ADC_JSQR_JSQ1_1                   (0x02UL << ADC_JSQR_JSQ1_Pos)         /*!< 0x00000400 */
#define ADC_JSQR_JSQ1_2                   (0x04UL << ADC_JSQR_JSQ1_Pos)         /*!< 0x00000800 */
#define ADC_JSQR_JSQ1_3                   (0x08UL << ADC_JSQR_JSQ1_Pos)         /*!< 0x00001000 */
#define ADC_JSQR_JSQ1_4                   (0x10UL << ADC_JSQR_JSQ1_Pos)         /*!< 0x00002000 */

#define ADC_JSQR_JSQ2_Pos                 (15U)
#define ADC_JSQR_JSQ2_Msk                 (0x1FUL << ADC_JSQR_JSQ2_Pos)         /*!< 0x000F8000 */
#define ADC_JSQR_JSQ2                     ADC_JSQR_JSQ2_Msk                     /*!< ADC 2nd conversion in injected sequence */
#define ADC_JSQR_JSQ2_0                   (0x01UL << ADC_JSQR_JSQ2_Pos)         /*!< 0x00008000 */
#define ADC_JSQR_JSQ2_1                   (0x02UL << ADC_JSQR_JSQ2_Pos)         /*!< 0x00010000 */
#define ADC_JSQR_JSQ2_2                   (0x04UL << ADC_JSQR_JSQ2_Pos)         /*!< 0x00020000 */
#define ADC_JSQR_JSQ2_3                   (0x08UL << ADC_JSQR_JSQ2_Pos)         /*!< 0x00040000 */
#define ADC_JSQR_JSQ2_4                   (0x10UL << ADC_JSQR_JSQ2_Pos)         /*!< 0x00080000 */

#define ADC_JSQR_JSQ3_Pos                 (21U)
#define ADC_JSQR_JSQ3_Msk                 (0x1FUL << ADC_JSQR_JSQ3_Pos)         /*!< 0x03E00000 */
#define ADC_JSQR_JSQ3                     ADC_JSQR_JSQ3_Msk                     /*!< ADC 3rd conversion in injected sequence */
#define ADC_JSQR_JSQ3_0                   (0x01UL << ADC_JSQR_JSQ3_Pos)         /*!< 0x00200000 */
#define ADC_JSQR_JSQ3_1                   (0x02UL << ADC_JSQR_JSQ3_Pos)         /*!< 0x00400000 */
#define ADC_JSQR_JSQ3_2                   (0x04UL << ADC_JSQR_JSQ3_Pos)         /*!< 0x00800000 */
#define ADC_JSQR_JSQ3_3                   (0x08UL << ADC_JSQR_JSQ3_Pos)         /*!< 0x01000000 */
#define ADC_JSQR_JSQ3_4                   (0x10UL << ADC_JSQR_JSQ3_Pos)         /*!< 0x02000000 */

#define ADC_JSQR_JSQ4_Pos                 (27U)
#define ADC_JSQR_JSQ4_Msk                 (0x1FUL << ADC_JSQR_JSQ4_Pos)         /*!< 0xF8000000 */
#define ADC_JSQR_JSQ4                     ADC_JSQR_JSQ4_Msk                     /*!< ADC 4th conversion in injected sequence */
#define ADC_JSQR_JSQ4_0                   (0x01UL << ADC_JSQR_JSQ4_Pos)         /*!< 0x08000000 */
#define ADC_JSQR_JSQ4_1                   (0x02UL << ADC_JSQR_JSQ4_Pos)         /*!< 0x10000000 */
#define ADC_JSQR_JSQ4_2                   (0x04UL << ADC_JSQR_JSQ4_Pos)         /*!< 0x20000000 */
#define ADC_JSQR_JSQ4_3                   (0x08UL << ADC_JSQR_JSQ4_Pos)         /*!< 0x40000000 */
#define ADC_JSQR_JSQ4_4                   (0x10UL << ADC_JSQR_JSQ4_Pos)         /*!< 0x80000000 */

/********************  Bit definition for ADC_OFR1 register  ********************/
#define ADC_OFR1_OFFSET1_Pos              (0U)
#define ADC_OFR1_OFFSET1_Msk              (0x00FFFFFFUL << ADC_OFR1_OFFSET1_Pos)/*!< 0x00FFFFFF */
#define ADC_OFR1_OFFSET1                  ADC_OFR1_OFFSET1_Msk                  /*!< ADC data offset 1 for channel programmed into bits OFFSET1_CH[4:0] */
#define ADC_OFR1_OFFSET1_0                (0x0000001UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000001 */
#define ADC_OFR1_OFFSET1_1                (0x0000002UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000002 */
#define ADC_OFR1_OFFSET1_2                (0x0000004UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000004 */
#define ADC_OFR1_OFFSET1_3                (0x0000008UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000008 */
#define ADC_OFR1_OFFSET1_4                (0x0000010UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000010 */
#define ADC_OFR1_OFFSET1_5                (0x0000020UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000020 */
#define ADC_OFR1_OFFSET1_6                (0x0000040UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000040 */
#define ADC_OFR1_OFFSET1_7                (0x0000080UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000080 */
#define ADC_OFR1_OFFSET1_8                (0x0000100UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000100 */
#define ADC_OFR1_OFFSET1_9                (0x0000200UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000200 */
#define ADC_OFR1_OFFSET1_10               (0x0000400UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000400 */
#define ADC_OFR1_OFFSET1_11               (0x0000800UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000800 */
#define ADC_OFR1_OFFSET1_12               (0x0001000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00001000 */
#define ADC_OFR1_OFFSET1_13               (0x0002000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00002000 */
#define ADC_OFR1_OFFSET1_14               (0x0004000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00004000 */
#define ADC_OFR1_OFFSET1_15               (0x0008000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00008000 */
#define ADC_OFR1_OFFSET1_16               (0x0010000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00010000 */
#define ADC_OFR1_OFFSET1_17               (0x0020000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00020000 */
#define ADC_OFR1_OFFSET1_18               (0x0040000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00040000 */
#define ADC_OFR1_OFFSET1_19               (0x0080000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00080000 */
#define ADC_OFR1_OFFSET1_20               (0x0100000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00100000 */
#define ADC_OFR1_OFFSET1_21               (0x0200000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00200000 */
#define ADC_OFR1_OFFSET1_22               (0x0400000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00400000 */
#define ADC_OFR1_OFFSET1_23               (0x0800000UL << ADC_OFR1_OFFSET1_Pos) /*!< 0x00800000 */

#define ADC_OFR1_OFFSETPOS_Pos            (24U)
#define ADC_OFR1_OFFSETPOS_Msk            (0x1UL << ADC_OFR1_OFFSETPOS_Pos)     /*!< 0x01000000 */
#define ADC_OFR1_OFFSETPOS                ADC_OFR1_OFFSETPOS_Msk                /*!< ADC offset number 1 positive */
#define ADC_OFR1_USAT_Pos                 (25U)
#define ADC_OFR1_USAT_Msk                 (0x1UL << ADC_OFR1_USAT_Pos)          /*!< 0x02000000 */
#define ADC_OFR1_USAT                     ADC_OFR1_USAT_Msk                     /*!< ADC offset number 1 saturation enable */

#define ADC_OFR1_SSAT_Pos                 (26U)
#define ADC_OFR1_SSAT_Msk                 (0x1UL << ADC_OFR1_SSAT_Pos)          /*!< 0x80000000 */
#define ADC_OFR1_SSAT                     ADC_OFR1_SSAT_Msk                     /*!< ADC Signed saturation Enable */

#define ADC_OFR1_OFFSET1_CH_Pos           (27U)
#define ADC_OFR1_OFFSET1_CH_Msk           (0x1FUL << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR1_OFFSET1_CH               ADC_OFR1_OFFSET1_CH_Msk               /*!< ADC Channel selection for the data offset 1 */
#define ADC_OFR1_OFFSET1_CH_0             (0x01UL << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR1_OFFSET1_CH_1             (0x02UL << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR1_OFFSET1_CH_2             (0x04UL << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR1_OFFSET1_CH_3             (0x08UL << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR1_OFFSET1_CH_4             (0x10UL << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x40000000 */

/********************  Bit definition for ADC_OFR2 register  ********************/
#define ADC_OFR2_OFFSET2_Pos              (0U)
#define ADC_OFR2_OFFSET2_Msk              (0x00FFFFFFUL << ADC_OFR2_OFFSET2_Pos)/*!< 0x00FFFFFF */
#define ADC_OFR2_OFFSET2                  ADC_OFR2_OFFSET2_Msk                  /*!< ADC data offset 2 for channel programmed into bits OFFSET2_CH[4:0] */
#define ADC_OFR2_OFFSET2_0                (0x0000001UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000001 */
#define ADC_OFR2_OFFSET2_1                (0x0000002UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000002 */
#define ADC_OFR2_OFFSET2_2                (0x0000004UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000004 */
#define ADC_OFR2_OFFSET2_3                (0x0000008UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000008 */
#define ADC_OFR2_OFFSET2_4                (0x0000010UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000010 */
#define ADC_OFR2_OFFSET2_5                (0x0000020UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000020 */
#define ADC_OFR2_OFFSET2_6                (0x0000040UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000040 */
#define ADC_OFR2_OFFSET2_7                (0x0000080UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000080 */
#define ADC_OFR2_OFFSET2_8                (0x0000100UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000100 */
#define ADC_OFR2_OFFSET2_9                (0x0000200UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000200 */
#define ADC_OFR2_OFFSET2_10               (0x0000400UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000400 */
#define ADC_OFR2_OFFSET2_11               (0x0000800UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000800 */
#define ADC_OFR2_OFFSET2_12               (0x0001000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00001000 */
#define ADC_OFR2_OFFSET2_13               (0x0002000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00002000 */
#define ADC_OFR2_OFFSET2_14               (0x0004000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00004000 */
#define ADC_OFR2_OFFSET2_15               (0x0008000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00008000 */
#define ADC_OFR2_OFFSET2_16               (0x0010000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00010000 */
#define ADC_OFR2_OFFSET2_17               (0x0020000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00020000 */
#define ADC_OFR2_OFFSET2_18               (0x0040000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00040000 */
#define ADC_OFR2_OFFSET2_19               (0x0080000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00080000 */
#define ADC_OFR2_OFFSET2_20               (0x0100000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00100000 */
#define ADC_OFR2_OFFSET2_21               (0x0200000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00200000 */
#define ADC_OFR2_OFFSET2_22               (0x0400000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00400000 */
#define ADC_OFR2_OFFSET2_23               (0x0800000UL << ADC_OFR2_OFFSET2_Pos) /*!< 0x00800000 */

#define ADC_OFR2_OFFSETPOS_Pos            (24U)
#define ADC_OFR2_OFFSETPOS_Msk            (0x1UL << ADC_OFR2_OFFSETPOS_Pos)     /*!< 0x01000000 */
#define ADC_OFR2_OFFSETPOS                ADC_OFR2_OFFSETPOS_Msk                /*!< ADC offset number 1 positive */
#define ADC_OFR2_USAT_Pos                 (25U)
#define ADC_OFR2_USAT_Msk                 (0x1UL << ADC_OFR2_USAT_Pos)          /*!< 0x02000000 */
#define ADC_OFR2_USAT                     ADC_OFR2_USAT_Msk                     /*!< ADC offset number 1 saturation enable */

#define ADC_OFR2_SSAT_Pos                 (26U)
#define ADC_OFR2_SSAT_Msk                 (0x1UL << ADC_OFR2_SSAT_Pos)          /*!< 0x80000000 */
#define ADC_OFR2_SSAT                     ADC_OFR2_SSAT_Msk                     /*!< ADC Signed saturation Enable */

#define ADC_OFR2_OFFSET2_CH_Pos           (27U)
#define ADC_OFR2_OFFSET2_CH_Msk           (0x1FUL << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR2_OFFSET2_CH               ADC_OFR2_OFFSET2_CH_Msk               /*!< ADC Channel selection for the data offset 2 */
#define ADC_OFR2_OFFSET2_CH_0             (0x01UL << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR2_OFFSET2_CH_1             (0x02UL << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR2_OFFSET2_CH_2             (0x04UL << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR2_OFFSET2_CH_3             (0x08UL << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR2_OFFSET2_CH_4             (0x10UL << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x40000000 */

/********************  Bit definition for ADC_OFR3 register  ********************/
#define ADC_OFR3_OFFSET3_Pos              (0U)
#define ADC_OFR3_OFFSET3_Msk              (0x00FFFFFFUL << ADC_OFR3_OFFSET3_Pos)/*!< 0x00FFFFFF */
#define ADC_OFR3_OFFSET3                  ADC_OFR3_OFFSET3_Msk                  /*!< ADC data offset 3 for channel programmed into bits OFFSET3_CH[4:0] */
#define ADC_OFR3_OFFSET3_0                (0x0000001UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000001 */
#define ADC_OFR3_OFFSET3_1                (0x0000002UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000002 */
#define ADC_OFR3_OFFSET3_2                (0x0000004UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000004 */
#define ADC_OFR3_OFFSET3_3                (0x0000008UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000008 */
#define ADC_OFR3_OFFSET3_4                (0x0000010UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000010 */
#define ADC_OFR3_OFFSET3_5                (0x0000020UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000020 */
#define ADC_OFR3_OFFSET3_6                (0x0000040UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000040 */
#define ADC_OFR3_OFFSET3_7                (0x0000080UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000080 */
#define ADC_OFR3_OFFSET3_8                (0x0000100UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000100 */
#define ADC_OFR3_OFFSET3_9                (0x0000200UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000200 */
#define ADC_OFR3_OFFSET3_10               (0x0000400UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000400 */
#define ADC_OFR3_OFFSET3_11               (0x0000800UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000800 */
#define ADC_OFR3_OFFSET3_12               (0x0001000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00001000 */
#define ADC_OFR3_OFFSET3_13               (0x0002000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00002000 */
#define ADC_OFR3_OFFSET3_14               (0x0004000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00004000 */
#define ADC_OFR3_OFFSET3_15               (0x0008000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00008000 */
#define ADC_OFR3_OFFSET3_16               (0x0010000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00010000 */
#define ADC_OFR3_OFFSET3_17               (0x0020000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00020000 */
#define ADC_OFR3_OFFSET3_18               (0x0040000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00040000 */
#define ADC_OFR3_OFFSET3_19               (0x0080000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00080000 */
#define ADC_OFR3_OFFSET3_20               (0x0100000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00100000 */
#define ADC_OFR3_OFFSET3_21               (0x0200000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00200000 */
#define ADC_OFR3_OFFSET3_22               (0x0400000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00400000 */
#define ADC_OFR3_OFFSET3_23               (0x0800000UL << ADC_OFR3_OFFSET3_Pos) /*!< 0x00800000 */

#define ADC_OFR3_OFFSETPOS_Pos            (24U)
#define ADC_OFR3_OFFSETPOS_Msk            (0x1UL << ADC_OFR3_OFFSETPOS_Pos)     /*!< 0x01000000 */
#define ADC_OFR3_OFFSETPOS                ADC_OFR3_OFFSETPOS_Msk                /*!< ADC offset number 1 positive */
#define ADC_OFR3_USAT_Pos                 (25U)
#define ADC_OFR3_USAT_Msk                 (0x1UL << ADC_OFR3_USAT_Pos)          /*!< 0x02000000 */
#define ADC_OFR3_USAT                     ADC_OFR3_USAT_Msk                     /*!< ADC offset number 1 saturation enable */

#define ADC_OFR3_SSAT_Pos                 (26U)
#define ADC_OFR3_SSAT_Msk                 (0x1UL << ADC_OFR3_SSAT_Pos)          /*!< 0x80000000 */
#define ADC_OFR3_SSAT                     ADC_OFR3_SSAT_Msk                     /*!< ADC Signed saturation Enable */

#define ADC_OFR3_OFFSET3_CH_Pos           (27U)
#define ADC_OFR3_OFFSET3_CH_Msk           (0x1FUL << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR3_OFFSET3_CH               ADC_OFR3_OFFSET3_CH_Msk               /*!< ADC Channel selection for the data offset 3 */
#define ADC_OFR3_OFFSET3_CH_0             (0x01UL << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR3_OFFSET3_CH_1             (0x02UL << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR3_OFFSET3_CH_2             (0x04UL << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR3_OFFSET3_CH_3             (0x08UL << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR3_OFFSET3_CH_4             (0x10UL << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x40000000 */

/********************  Bit definition for ADC_OFR4 register  ********************/
#define ADC_OFR4_OFFSET4_Pos              (0U)
#define ADC_OFR4_OFFSET4_Msk              (0x00FFFFFFUL << ADC_OFR4_OFFSET4_Pos)/*!< 0x00FFFFFF */
#define ADC_OFR4_OFFSET4                  ADC_OFR4_OFFSET4_Msk                  /*!< ADC data offset 4 for channel programmed into bits OFFSET4_CH[4:0] */
#define ADC_OFR4_OFFSET4_0                (0x0000001UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000001 */
#define ADC_OFR4_OFFSET4_1                (0x0000002UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000002 */
#define ADC_OFR4_OFFSET4_2                (0x0000004UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000004 */
#define ADC_OFR4_OFFSET4_3                (0x0000008UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000008 */
#define ADC_OFR4_OFFSET4_4                (0x0000010UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000010 */
#define ADC_OFR4_OFFSET4_5                (0x0000020UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000020 */
#define ADC_OFR4_OFFSET4_6                (0x0000040UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000040 */
#define ADC_OFR4_OFFSET4_7                (0x0000080UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000080 */
#define ADC_OFR4_OFFSET4_8                (0x0000100UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000100 */
#define ADC_OFR4_OFFSET4_9                (0x0000200UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000200 */
#define ADC_OFR4_OFFSET4_10               (0x0000400UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000400 */
#define ADC_OFR4_OFFSET4_11               (0x0000800UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000800 */
#define ADC_OFR4_OFFSET4_12               (0x0001000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00001000 */
#define ADC_OFR4_OFFSET4_13               (0x0002000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00002000 */
#define ADC_OFR4_OFFSET4_14               (0x0004000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00004000 */
#define ADC_OFR4_OFFSET4_15               (0x0008000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00008000 */
#define ADC_OFR4_OFFSET4_16               (0x0010000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00010000 */
#define ADC_OFR4_OFFSET4_17               (0x0020000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00020000 */
#define ADC_OFR4_OFFSET4_18               (0x0040000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00040000 */
#define ADC_OFR4_OFFSET4_19               (0x0080000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00080000 */
#define ADC_OFR4_OFFSET4_20               (0x0100000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00100000 */
#define ADC_OFR4_OFFSET4_21               (0x0200000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00200000 */
#define ADC_OFR4_OFFSET4_22               (0x0400000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00400000 */
#define ADC_OFR4_OFFSET4_23               (0x0800000UL << ADC_OFR4_OFFSET4_Pos) /*!< 0x00800000 */

#define ADC_OFR4_OFFSETPOS_Pos            (24U)
#define ADC_OFR4_OFFSETPOS_Msk            (0x1UL << ADC_OFR4_OFFSETPOS_Pos)     /*!< 0x01000000 */
#define ADC_OFR4_OFFSETPOS                ADC_OFR4_OFFSETPOS_Msk                /*!< ADC offset number 1 positive */
#define ADC_OFR4_USAT_Pos                 (25U)
#define ADC_OFR4_USAT_Msk                 (0x1UL << ADC_OFR4_USAT_Pos)          /*!< 0x02000000 */
#define ADC_OFR4_USAT                     ADC_OFR4_USAT_Msk                     /*!< ADC offset number 1 saturation enable */

#define ADC_OFR4_SSAT_Pos                 (26U)
#define ADC_OFR4_SSAT_Msk                 (0x1UL << ADC_OFR4_SSAT_Pos)          /*!< 0x80000000 */
#define ADC_OFR4_SSAT                     ADC_OFR4_SSAT_Msk                     /*!< ADC Signed saturation Enable */

#define ADC_OFR4_OFFSET4_CH_Pos           (27U)
#define ADC_OFR4_OFFSET4_CH_Msk           (0x1FUL << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR4_OFFSET4_CH               ADC_OFR4_OFFSET4_CH_Msk               /*!< ADC Channel selection for the data offset 4 */
#define ADC_OFR4_OFFSET4_CH_0             (0x01UL << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR4_OFFSET4_CH_1             (0x02UL << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR4_OFFSET4_CH_2             (0x04UL << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR4_OFFSET4_CH_3             (0x08UL << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR4_OFFSET4_CH_4             (0x10UL << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x40000000 */

/********************  Bit definition for ADC_GCOMP register  ********************/
#define ADC_GCOMP_GCOMPCOEFF_Pos          (0U)
#define ADC_GCOMP_GCOMPCOEFF_Msk          (0x3FFFUL << ADC_GCOMP_GCOMPCOEFF_Pos)/*!< 0x00003FFF */
#define ADC_GCOMP_GCOMPCOEFF               ADC_GCOMP_GCOMPCOEFF_Msk             /*!< ADC Injected DATA */
#define ADC_GCOMP_GCOMP_Pos               (31U)
#define ADC_GCOMP_GCOMP_Msk               (0x1UL << ADC_GCOMP_GCOMP_Pos)        /*!< 0x00003FFF */
#define ADC_GCOMP_GCOMP                   ADC_GCOMP_GCOMP_Msk                   /*!< ADC Injected DATA */

/********************  Bit definition for ADC_JDR1 register  ********************/
#define ADC_JDR1_JDATA_Pos                (0U)
#define ADC_JDR1_JDATA_Msk                (0xFFFFFFFFUL << ADC_JDR1_JDATA_Pos)  /*!< 0xFFFFFFFF */
#define ADC_JDR1_JDATA                    ADC_JDR1_JDATA_Msk                    /*!< ADC Injected DATA */
#define ADC_JDR1_JDATA_0                  (0x00000001UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000001 */
#define ADC_JDR1_JDATA_1                  (0x00000002UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000002 */
#define ADC_JDR1_JDATA_2                  (0x00000004UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000004 */
#define ADC_JDR1_JDATA_3                  (0x00000008UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000008 */
#define ADC_JDR1_JDATA_4                  (0x00000010UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000010 */
#define ADC_JDR1_JDATA_5                  (0x00000020UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000020 */
#define ADC_JDR1_JDATA_6                  (0x00000040UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000040 */
#define ADC_JDR1_JDATA_7                  (0x00000080UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000080 */
#define ADC_JDR1_JDATA_8                  (0x00000100UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000100 */
#define ADC_JDR1_JDATA_9                  (0x00000200UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000200 */
#define ADC_JDR1_JDATA_10                 (0x00000400UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000400 */
#define ADC_JDR1_JDATA_11                 (0x00000800UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00000800 */
#define ADC_JDR1_JDATA_12                 (0x00001000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00001000 */
#define ADC_JDR1_JDATA_13                 (0x00002000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00002000 */
#define ADC_JDR1_JDATA_14                 (0x00004000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00004000 */
#define ADC_JDR1_JDATA_15                 (0x00008000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00008000 */
#define ADC_JDR1_JDATA_16                 (0x00010000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00010000 */
#define ADC_JDR1_JDATA_17                 (0x00020000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00020000 */
#define ADC_JDR1_JDATA_18                 (0x00040000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00040000 */
#define ADC_JDR1_JDATA_19                 (0x00080000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00080000 */
#define ADC_JDR1_JDATA_20                 (0x00100000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00100000 */
#define ADC_JDR1_JDATA_21                 (0x00200000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00200000 */
#define ADC_JDR1_JDATA_22                 (0x00400000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00400000 */
#define ADC_JDR1_JDATA_23                 (0x00800000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x00800000 */
#define ADC_JDR1_JDATA_24                 (0x01000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x01000000 */
#define ADC_JDR1_JDATA_25                 (0x02000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x02000000 */
#define ADC_JDR1_JDATA_26                 (0x04000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x04000000 */
#define ADC_JDR1_JDATA_27                 (0x08000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x08000000 */
#define ADC_JDR1_JDATA_28                 (0x10000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR1_JDATA_29                 (0x20000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR1_JDATA_30                 (0x40000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR1_JDATA_31                 (0x80000000UL << ADC_JDR1_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR2 register  ********************/
#define ADC_JDR2_JDATA_Pos                (0U)
#define ADC_JDR2_JDATA_Msk                (0xFFFFFFFFUL << ADC_JDR2_JDATA_Pos)  /*!< 0xFFFFFFFF */
#define ADC_JDR2_JDATA                    ADC_JDR2_JDATA_Msk                    /*!< ADC Injected DATA */
#define ADC_JDR2_JDATA_0                  (0x00000001UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000001 */
#define ADC_JDR2_JDATA_1                  (0x00000002UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000002 */
#define ADC_JDR2_JDATA_2                  (0x00000004UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000004 */
#define ADC_JDR2_JDATA_3                  (0x00000008UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000008 */
#define ADC_JDR2_JDATA_4                  (0x00000010UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000010 */
#define ADC_JDR2_JDATA_5                  (0x00000020UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000020 */
#define ADC_JDR2_JDATA_6                  (0x00000040UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000040 */
#define ADC_JDR2_JDATA_7                  (0x00000080UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000080 */
#define ADC_JDR2_JDATA_8                  (0x00000100UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000100 */
#define ADC_JDR2_JDATA_9                  (0x00000200UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000200 */
#define ADC_JDR2_JDATA_10                 (0x00000400UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000400 */
#define ADC_JDR2_JDATA_11                 (0x00000800UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00000800 */
#define ADC_JDR2_JDATA_12                 (0x00001000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00001000 */
#define ADC_JDR2_JDATA_13                 (0x00002000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00002000 */
#define ADC_JDR2_JDATA_14                 (0x00004000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00004000 */
#define ADC_JDR2_JDATA_15                 (0x00008000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00008000 */
#define ADC_JDR2_JDATA_16                 (0x00010000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00010000 */
#define ADC_JDR2_JDATA_17                 (0x00020000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00020000 */
#define ADC_JDR2_JDATA_18                 (0x00040000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00040000 */
#define ADC_JDR2_JDATA_19                 (0x00080000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00080000 */
#define ADC_JDR2_JDATA_20                 (0x00100000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00100000 */
#define ADC_JDR2_JDATA_21                 (0x00200000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00200000 */
#define ADC_JDR2_JDATA_22                 (0x00400000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00400000 */
#define ADC_JDR2_JDATA_23                 (0x00800000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x00800000 */
#define ADC_JDR2_JDATA_24                 (0x01000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x01000000 */
#define ADC_JDR2_JDATA_25                 (0x02000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x02000000 */
#define ADC_JDR2_JDATA_26                 (0x04000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x04000000 */
#define ADC_JDR2_JDATA_27                 (0x08000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x08000000 */
#define ADC_JDR2_JDATA_28                 (0x10000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR2_JDATA_29                 (0x20000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR2_JDATA_30                 (0x40000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR2_JDATA_31                 (0x80000000UL << ADC_JDR2_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR3 register  ********************/
#define ADC_JDR3_JDATA_Pos                (0U)
#define ADC_JDR3_JDATA_Msk                (0xFFFFFFFFUL << ADC_JDR3_JDATA_Pos)  /*!< 0xFFFFFFFF */
#define ADC_JDR3_JDATA                    ADC_JDR3_JDATA_Msk                    /*!< ADC Injected DATA */
#define ADC_JDR3_JDATA_0                  (0x00000001UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000001 */
#define ADC_JDR3_JDATA_1                  (0x00000002UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000002 */
#define ADC_JDR3_JDATA_2                  (0x00000004UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000004 */
#define ADC_JDR3_JDATA_3                  (0x00000008UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000008 */
#define ADC_JDR3_JDATA_4                  (0x00000010UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000010 */
#define ADC_JDR3_JDATA_5                  (0x00000020UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000020 */
#define ADC_JDR3_JDATA_6                  (0x00000040UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000040 */
#define ADC_JDR3_JDATA_7                  (0x00000080UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000080 */
#define ADC_JDR3_JDATA_8                  (0x00000100UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000100 */
#define ADC_JDR3_JDATA_9                  (0x00000200UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000200 */
#define ADC_JDR3_JDATA_10                 (0x00000400UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000400 */
#define ADC_JDR3_JDATA_11                 (0x00000800UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00000800 */
#define ADC_JDR3_JDATA_12                 (0x00001000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00001000 */
#define ADC_JDR3_JDATA_13                 (0x00002000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00002000 */
#define ADC_JDR3_JDATA_14                 (0x00004000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00004000 */
#define ADC_JDR3_JDATA_15                 (0x00008000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00008000 */
#define ADC_JDR3_JDATA_16                 (0x00010000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00010000 */
#define ADC_JDR3_JDATA_17                 (0x00020000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00020000 */
#define ADC_JDR3_JDATA_18                 (0x00040000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00040000 */
#define ADC_JDR3_JDATA_19                 (0x00080000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00080000 */
#define ADC_JDR3_JDATA_20                 (0x00100000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00100000 */
#define ADC_JDR3_JDATA_21                 (0x00200000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00200000 */
#define ADC_JDR3_JDATA_22                 (0x00400000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00400000 */
#define ADC_JDR3_JDATA_23                 (0x00800000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x00800000 */
#define ADC_JDR3_JDATA_24                 (0x01000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x01000000 */
#define ADC_JDR3_JDATA_25                 (0x02000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x02000000 */
#define ADC_JDR3_JDATA_26                 (0x04000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x04000000 */
#define ADC_JDR3_JDATA_27                 (0x08000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x08000000 */
#define ADC_JDR3_JDATA_28                 (0x10000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR3_JDATA_29                 (0x20000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR3_JDATA_30                 (0x40000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR3_JDATA_31                 (0x80000000UL << ADC_JDR3_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR4 register  ********************/
#define ADC_JDR4_JDATA_Pos                (0U)
#define ADC_JDR4_JDATA_Msk                (0xFFFFFFFFUL << ADC_JDR4_JDATA_Pos)  /*!< 0xFFFFFFFF */
#define ADC_JDR4_JDATA                    ADC_JDR4_JDATA_Msk                    /*!< ADC Injected DATA */
#define ADC_JDR4_JDATA_0                  (0x00000001UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000001 */
#define ADC_JDR4_JDATA_1                  (0x00000002UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000002 */
#define ADC_JDR4_JDATA_2                  (0x00000004UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000004 */
#define ADC_JDR4_JDATA_3                  (0x00000008UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000008 */
#define ADC_JDR4_JDATA_4                  (0x00000010UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000010 */
#define ADC_JDR4_JDATA_5                  (0x00000020UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000020 */
#define ADC_JDR4_JDATA_6                  (0x00000040UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000040 */
#define ADC_JDR4_JDATA_7                  (0x00000080UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000080 */
#define ADC_JDR4_JDATA_8                  (0x00000100UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000100 */
#define ADC_JDR4_JDATA_9                  (0x00000200UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000200 */
#define ADC_JDR4_JDATA_10                 (0x00000400UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000400 */
#define ADC_JDR4_JDATA_11                 (0x00000800UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00000800 */
#define ADC_JDR4_JDATA_12                 (0x00001000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00001000 */
#define ADC_JDR4_JDATA_13                 (0x00002000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00002000 */
#define ADC_JDR4_JDATA_14                 (0x00004000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00004000 */
#define ADC_JDR4_JDATA_15                 (0x00008000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00008000 */
#define ADC_JDR4_JDATA_16                 (0x00010000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00010000 */
#define ADC_JDR4_JDATA_17                 (0x00020000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00020000 */
#define ADC_JDR4_JDATA_18                 (0x00040000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00040000 */
#define ADC_JDR4_JDATA_19                 (0x00080000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00080000 */
#define ADC_JDR4_JDATA_20                 (0x00100000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00100000 */
#define ADC_JDR4_JDATA_21                 (0x00200000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00200000 */
#define ADC_JDR4_JDATA_22                 (0x00400000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00400000 */
#define ADC_JDR4_JDATA_23                 (0x00800000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x00800000 */
#define ADC_JDR4_JDATA_24                 (0x01000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x01000000 */
#define ADC_JDR4_JDATA_25                 (0x02000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x02000000 */
#define ADC_JDR4_JDATA_26                 (0x04000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x04000000 */
#define ADC_JDR4_JDATA_27                 (0x08000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x08000000 */
#define ADC_JDR4_JDATA_28                 (0x10000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR4_JDATA_29                 (0x20000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR4_JDATA_30                 (0x40000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR4_JDATA_31                 (0x80000000UL << ADC_JDR4_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_AWD2CR register  ********************/
#define ADC_AWD2CR_AWD2CH_Pos             (0U)
#define ADC_AWD2CR_AWD2CH_Msk             (0xFFFFFFUL << ADC_AWD2CR_AWD2CH_Pos) /*!< 0x00FFFFFF */
#define ADC_AWD2CR_AWD2CH                 ADC_AWD2CR_AWD2CH_Msk                 /*!< ADC Analog watchdog 2 channel selection */
#define ADC_AWD2CR_AWD2CH_0               (0x00001UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000001 */
#define ADC_AWD2CR_AWD2CH_1               (0x00002UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000002 */
#define ADC_AWD2CR_AWD2CH_2               (0x00004UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000004 */
#define ADC_AWD2CR_AWD2CH_3               (0x00008UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000008 */
#define ADC_AWD2CR_AWD2CH_4               (0x00010UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000010 */
#define ADC_AWD2CR_AWD2CH_5               (0x00020UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000020 */
#define ADC_AWD2CR_AWD2CH_6               (0x00040UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000040 */
#define ADC_AWD2CR_AWD2CH_7               (0x00080UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000080 */
#define ADC_AWD2CR_AWD2CH_8               (0x00100UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000100 */
#define ADC_AWD2CR_AWD2CH_9               (0x00200UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000200 */
#define ADC_AWD2CR_AWD2CH_10              (0x00400UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000400 */
#define ADC_AWD2CR_AWD2CH_11              (0x00800UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000800 */
#define ADC_AWD2CR_AWD2CH_12              (0x01000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00001000 */
#define ADC_AWD2CR_AWD2CH_13              (0x02000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00002000 */
#define ADC_AWD2CR_AWD2CH_14              (0x04000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00004000 */
#define ADC_AWD2CR_AWD2CH_15              (0x08000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00008000 */
#define ADC_AWD2CR_AWD2CH_16              (0x10000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00010000 */
#define ADC_AWD2CR_AWD2CH_17              (0x20000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00020000 */
#define ADC_AWD2CR_AWD2CH_18              (0x40000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00040000 */
#define ADC_AWD2CR_AWD2CH_19              (0x80000UL << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00080000 */
#define ADC_AWD2CR_AWD2CH_20              (0x100000UL << ADC_AWD2CR_AWD2CH_Pos) /*!< 0x00100000 */
#define ADC_AWD2CR_AWD2CH_21              (0x200000UL << ADC_AWD2CR_AWD2CH_Pos) /*!< 0x00200000 */
#define ADC_AWD2CR_AWD2CH_22              (0x400000UL << ADC_AWD2CR_AWD2CH_Pos) /*!< 0x00400000 */
#define ADC_AWD2CR_AWD2CH_23              (0x800000UL << ADC_AWD2CR_AWD2CH_Pos) /*!< 0x00800000 */

/********************  Bit definition for ADC_AWD1TR register  *******************/
#define ADC_AWD1TR_LT1_Pos                (0U)
#define ADC_AWD1TR_LT1_Msk                (0xFFFUL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000FFF */
#define ADC_AWD1TR_LT1                    ADC_AWD1TR_LT1_Msk                   /*!< ADC analog watchdog 1 threshold low */
#define ADC_AWD1TR_LT1_0                  (0x001UL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000001 */
#define ADC_AWD1TR_LT1_1                  (0x002UL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000002 */
#define ADC_AWD1TR_LT1_2                  (0x004UL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000004 */
#define ADC_AWD1TR_LT1_3                  (0x008UL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000008 */
#define ADC_AWD1TR_LT1_4                  (0x010UL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000010 */
#define ADC_AWD1TR_LT1_5                  (0x020UL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000020 */
#define ADC_AWD1TR_LT1_6                  (0x040UL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000040 */
#define ADC_AWD1TR_LT1_7                  (0x080UL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000080 */
#define ADC_AWD1TR_LT1_8                  (0x100UL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000100 */
#define ADC_AWD1TR_LT1_9                  (0x200UL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000200 */
#define ADC_AWD1TR_LT1_10                 (0x400UL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000400 */
#define ADC_AWD1TR_LT1_11                 (0x800UL << ADC_AWD1TR_LT1_Pos)      /*!< 0x00000800 */

#define ADC_AWD1TR_HT1_Pos                (16U)
#define ADC_AWD1TR_HT1_Msk                (0xFFFUL << ADC_AWD1TR_HT1_Pos)      /*!< 0x0FFF0000 */
#define ADC_AWD1TR_HT1                    ADC_AWD1TR_HT1_Msk                   /*!< ADC Analog watchdog 1 threshold high */
#define ADC_AWD1TR_HT1_0                  (0x001UL << ADC_AWD1TR_HT1_Pos)      /*!< 0x00010000 */
#define ADC_AWD1TR_HT1_1                  (0x002UL << ADC_AWD1TR_HT1_Pos)      /*!< 0x00020000 */
#define ADC_AWD1TR_HT1_2                  (0x004UL << ADC_AWD1TR_HT1_Pos)      /*!< 0x00040000 */
#define ADC_AWD1TR_HT1_3                  (0x008UL << ADC_AWD1TR_HT1_Pos)      /*!< 0x00080000 */
#define ADC_AWD1TR_HT1_4                  (0x010UL << ADC_AWD1TR_HT1_Pos)      /*!< 0x00100000 */
#define ADC_AWD1TR_HT1_5                  (0x020UL << ADC_AWD1TR_HT1_Pos)      /*!< 0x00200000 */
#define ADC_AWD1TR_HT1_6                  (0x040UL << ADC_AWD1TR_HT1_Pos)      /*!< 0x00400000 */
#define ADC_AWD1TR_HT1_7                  (0x080UL << ADC_AWD1TR_HT1_Pos)      /*!< 0x00800000 */
#define ADC_AWD1TR_HT1_8                  (0x100UL << ADC_AWD1TR_HT1_Pos)      /*!< 0x01000000 */
#define ADC_AWD1TR_HT1_9                  (0x200UL << ADC_AWD1TR_HT1_Pos)      /*!< 0x02000000 */
#define ADC_AWD1TR_HT1_10                 (0x400UL << ADC_AWD1TR_HT1_Pos)      /*!< 0x04000000 */
#define ADC_AWD1TR_HT1_11                 (0x800UL << ADC_AWD1TR_HT1_Pos)      /*!< 0x08000000 */

/********************  Bit definition for ADC_AWDTR2 register  *******************/
#define ADC_AWD2TR_LT2_Pos                (0U)
#define ADC_AWD2TR_LT2_Msk                (0xFFFUL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000FFF */
#define ADC_AWD2TR_LT2                    ADC_AWD2TR_LT2_Msk                   /*!< ADC analog watchdog 2 threshold low */
#define ADC_AWD2TR_LT2_0                  (0x001UL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000001 */
#define ADC_AWD2TR_LT2_1                  (0x002UL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000002 */
#define ADC_AWD2TR_LT2_2                  (0x004UL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000004 */
#define ADC_AWD2TR_LT2_3                  (0x008UL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000008 */
#define ADC_AWD2TR_LT2_4                  (0x010UL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000010 */
#define ADC_AWD2TR_LT2_5                  (0x020UL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000020 */
#define ADC_AWD2TR_LT2_6                  (0x040UL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000040 */
#define ADC_AWD2TR_LT2_7                  (0x080UL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000080 */
#define ADC_AWD2TR_LT2_8                  (0x100UL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000100 */
#define ADC_AWD2TR_LT2_9                  (0x200UL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000200 */
#define ADC_AWD2TR_LT2_10                 (0x400UL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000400 */
#define ADC_AWD2TR_LT2_11                 (0x800UL << ADC_AWD2TR_LT2_Pos)      /*!< 0x00000800 */

#define ADC_AWD2TR_HT2_Pos                (16U)
#define ADC_AWD2TR_HT2_Msk                (0xFFFUL << ADC_AWD2TR_HT2_Pos)      /*!< 0x0FFF0000 */
#define ADC_AWD2TR_HT2                    ADC_AWD2TR_HT2_Msk                   /*!< ADC analog watchdog 2 threshold high */
#define ADC_AWD2TR_HT2_0                  (0x001UL << ADC_AWD2TR_HT2_Pos)      /*!< 0x00010000 */
#define ADC_AWD2TR_HT2_1                  (0x002UL << ADC_AWD2TR_HT2_Pos)      /*!< 0x00020000 */
#define ADC_AWD2TR_HT2_2                  (0x004UL << ADC_AWD2TR_HT2_Pos)      /*!< 0x00040000 */
#define ADC_AWD2TR_HT2_3                  (0x008UL << ADC_AWD2TR_HT2_Pos)      /*!< 0x00080000 */
#define ADC_AWD2TR_HT2_4                  (0x010UL << ADC_AWD2TR_HT2_Pos)      /*!< 0x00100000 */
#define ADC_AWD2TR_HT2_5                  (0x020UL << ADC_AWD2TR_HT2_Pos)      /*!< 0x00200000 */
#define ADC_AWD2TR_HT2_6                  (0x040UL << ADC_AWD2TR_HT2_Pos)      /*!< 0x00400000 */
#define ADC_AWD2TR_HT2_7                  (0x080UL << ADC_AWD2TR_HT2_Pos)      /*!< 0x00800000 */
#define ADC_AWD2TR_HT2_8                  (0x100UL << ADC_AWD2TR_HT2_Pos)      /*!< 0x01000000 */
#define ADC_AWD2TR_HT2_9                  (0x200UL << ADC_AWD2TR_HT2_Pos)      /*!< 0x02000000 */
#define ADC_AWD2TR_HT2_10                 (0x400UL << ADC_AWD2TR_HT2_Pos)      /*!< 0x04000000 */
#define ADC_AWD2TR_HT2_11                 (0x800UL << ADC_AWD2TR_HT2_Pos)      /*!< 0x08000000 */

/********************  Bit definition for ADC_CHSELR register  ****************/
#define ADC_CHSELR_CHSEL_Pos           (0U)
#define ADC_CHSELR_CHSEL_Msk           (0xFFFFFFUL << ADC_CHSELR_CHSEL_Pos)    /*!< 0x0007FFFF */
#define ADC_CHSELR_CHSEL               ADC_CHSELR_CHSEL_Msk                    /*!< ADC group regular sequencer channels, available when ADC_CFGR1_CHSELRMOD is reset */

#define ADC_CHSELR_CHSEL0_Pos          (0U)
#define ADC_CHSELR_CHSEL0_Msk          (0x1UL << ADC_CHSELR_CHSEL0_Pos)        /*!< 0x00000001 */
#define ADC_CHSELR_CHSEL0              ADC_CHSELR_CHSEL0_Msk                   /*!< ADC group regular sequencer channel 0, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL1_Pos          (1U)
#define ADC_CHSELR_CHSEL1_Msk          (0x1UL << ADC_CHSELR_CHSEL1_Pos)        /*!< 0x00000002 */
#define ADC_CHSELR_CHSEL1              ADC_CHSELR_CHSEL1_Msk                   /*!< ADC group regular sequencer channel 1, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL2_Pos          (2U)
#define ADC_CHSELR_CHSEL2_Msk          (0x1UL << ADC_CHSELR_CHSEL2_Pos)        /*!< 0x00000004 */
#define ADC_CHSELR_CHSEL2              ADC_CHSELR_CHSEL2_Msk                   /*!< ADC group regular sequencer channel 2, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL3_Pos          (3U)
#define ADC_CHSELR_CHSEL3_Msk          (0x1UL << ADC_CHSELR_CHSEL3_Pos)        /*!< 0x00000008 */
#define ADC_CHSELR_CHSEL3              ADC_CHSELR_CHSEL3_Msk                   /*!< ADC group regular sequencer channel 3, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL4_Pos          (4U)
#define ADC_CHSELR_CHSEL4_Msk          (0x1UL << ADC_CHSELR_CHSEL4_Pos)        /*!< 0x00000010 */
#define ADC_CHSELR_CHSEL4              ADC_CHSELR_CHSEL4_Msk                   /*!< ADC group regular sequencer channel 4, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL5_Pos          (5U)
#define ADC_CHSELR_CHSEL5_Msk          (0x1UL << ADC_CHSELR_CHSEL5_Pos)        /*!< 0x00000020 */
#define ADC_CHSELR_CHSEL5              ADC_CHSELR_CHSEL5_Msk                   /*!< ADC group regular sequencer channel 5, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL6_Pos          (6U)
#define ADC_CHSELR_CHSEL6_Msk          (0x1UL << ADC_CHSELR_CHSEL6_Pos)        /*!< 0x00000040 */
#define ADC_CHSELR_CHSEL6              ADC_CHSELR_CHSEL6_Msk                   /*!< ADC group regular sequencer channel 6, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL7_Pos          (7U)
#define ADC_CHSELR_CHSEL7_Msk          (0x1UL << ADC_CHSELR_CHSEL7_Pos)        /*!< 0x00000080 */
#define ADC_CHSELR_CHSEL7              ADC_CHSELR_CHSEL7_Msk                   /*!< ADC group regular sequencer channel 7, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL8_Pos          (8U)
#define ADC_CHSELR_CHSEL8_Msk          (0x1UL << ADC_CHSELR_CHSEL8_Pos)        /*!< 0x00000100 */
#define ADC_CHSELR_CHSEL8              ADC_CHSELR_CHSEL8_Msk                   /*!< ADC group regular sequencer channel 8, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL9_Pos          (9U)
#define ADC_CHSELR_CHSEL9_Msk          (0x1UL << ADC_CHSELR_CHSEL9_Pos)        /*!< 0x00000200 */
#define ADC_CHSELR_CHSEL9              ADC_CHSELR_CHSEL9_Msk                   /*!< ADC group regular sequencer channel 9, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL10_Pos         (10U)
#define ADC_CHSELR_CHSEL10_Msk         (0x1UL << ADC_CHSELR_CHSEL10_Pos)       /*!< 0x00000400 */
#define ADC_CHSELR_CHSEL10             ADC_CHSELR_CHSEL10_Msk                  /*!< ADC group regular sequencer channel 10, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL11_Pos         (11U)
#define ADC_CHSELR_CHSEL11_Msk         (0x1UL << ADC_CHSELR_CHSEL11_Pos)       /*!< 0x00000800 */
#define ADC_CHSELR_CHSEL11             ADC_CHSELR_CHSEL11_Msk                  /*!< ADC group regular sequencer channel 11, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL12_Pos         (12U)
#define ADC_CHSELR_CHSEL12_Msk         (0x1UL << ADC_CHSELR_CHSEL12_Pos)       /*!< 0x00001000 */
#define ADC_CHSELR_CHSEL12             ADC_CHSELR_CHSEL12_Msk                  /*!< ADC group regular sequencer channel 12, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL13_Pos         (13U)
#define ADC_CHSELR_CHSEL13_Msk         (0x1UL << ADC_CHSELR_CHSEL13_Pos)       /*!< 0x00002000 */
#define ADC_CHSELR_CHSEL13             ADC_CHSELR_CHSEL13_Msk                  /*!< ADC group regular sequencer channel 13, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL14_Pos         (14U)
#define ADC_CHSELR_CHSEL14_Msk         (0x1UL << ADC_CHSELR_CHSEL14_Pos)       /*!< 0x00004000 */
#define ADC_CHSELR_CHSEL14             ADC_CHSELR_CHSEL14_Msk                  /*!< ADC group regular sequencer channel 14, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL15_Pos         (15U)
#define ADC_CHSELR_CHSEL15_Msk         (0x1UL << ADC_CHSELR_CHSEL15_Pos)       /*!< 0x00008000 */
#define ADC_CHSELR_CHSEL15             ADC_CHSELR_CHSEL15_Msk                  /*!< ADC group regular sequencer channel 15, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL16_Pos         (16U)
#define ADC_CHSELR_CHSEL16_Msk         (0x1UL << ADC_CHSELR_CHSEL16_Pos)       /*!< 0x00010000 */
#define ADC_CHSELR_CHSEL16             ADC_CHSELR_CHSEL16_Msk                  /*!< ADC group regular sequencer channel 16, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL17_Pos         (17U)
#define ADC_CHSELR_CHSEL17_Msk         (0x1UL << ADC_CHSELR_CHSEL17_Pos)       /*!< 0x00020000 */
#define ADC_CHSELR_CHSEL17             ADC_CHSELR_CHSEL17_Msk                  /*!< ADC group regular sequencer channel 17, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL18_Pos         (18U)
#define ADC_CHSELR_CHSEL18_Msk         (0x1UL << ADC_CHSELR_CHSEL18_Pos)       /*!< 0x00040000 */
#define ADC_CHSELR_CHSEL18             ADC_CHSELR_CHSEL18_Msk                  /*!< ADC group regular sequencer channel 18, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL19_Pos         (19U)
#define ADC_CHSELR_CHSEL19_Msk         (0x1UL << ADC_CHSELR_CHSEL19_Pos)       /*!< 0x00040000 */
#define ADC_CHSELR_CHSEL19             ADC_CHSELR_CHSEL19_Msk                  /*!< ADC group regular sequencer channel 18, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL20_Pos         (20U)
#define ADC_CHSELR_CHSEL20_Msk         (0x1UL << ADC_CHSELR_CHSEL20_Pos)       /*!< 0x00040000 */
#define ADC_CHSELR_CHSEL20             ADC_CHSELR_CHSEL20_Msk                  /*!< ADC group regular sequencer channel 18, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL21_Pos         (21U)
#define ADC_CHSELR_CHSEL21_Msk         (0x1UL << ADC_CHSELR_CHSEL21_Pos)       /*!< 0x00040000 */
#define ADC_CHSELR_CHSEL21             ADC_CHSELR_CHSEL21_Msk                  /*!< ADC group regular sequencer channel 18, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL22_Pos         (22U)
#define ADC_CHSELR_CHSEL22_Msk         (0x1UL << ADC_CHSELR_CHSEL22_Pos)       /*!< 0x00040000 */
#define ADC_CHSELR_CHSEL22             ADC_CHSELR_CHSEL22_Msk                  /*!< ADC group regular sequencer channel 18, available when ADC_CFGR1_CHSELRMOD is reset */
#define ADC_CHSELR_CHSEL23_Pos         (23U)
#define ADC_CHSELR_CHSEL23_Msk         (0x1UL << ADC_CHSELR_CHSEL23_Pos)       /*!< 0x00040000 */
#define ADC_CHSELR_CHSEL23             ADC_CHSELR_CHSEL23_Msk                  /*!< ADC group regular sequencer channel 18, available when ADC_CFGR1_CHSELRMOD is reset */

#define ADC_CHSELR_SQ_ALL_Pos          (0U)
#define ADC_CHSELR_SQ_ALL_Msk          (0xFFFFFFFFUL << ADC_CHSELR_SQ_ALL_Pos) /*!< 0xFFFFFFFF */
#define ADC_CHSELR_SQ_ALL              ADC_CHSELR_SQ_ALL_Msk                   /*!< ADC group regular sequencer all ranks, available when ADC_CFGR1_CHSELRMOD is set */

#define ADC_CHSELR_SQ1_Pos             (0U)
#define ADC_CHSELR_SQ1_Msk             (0xFUL << ADC_CHSELR_SQ1_Pos)           /*!< 0x0000000F */
#define ADC_CHSELR_SQ1                 ADC_CHSELR_SQ1_Msk                      /*!< ADC group regular sequencer rank 1, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ1_0               (0x1UL << ADC_CHSELR_SQ1_Pos)           /*!< 0x00000001 */
#define ADC_CHSELR_SQ1_1               (0x2UL << ADC_CHSELR_SQ1_Pos)           /*!< 0x00000002 */
#define ADC_CHSELR_SQ1_2               (0x4UL << ADC_CHSELR_SQ1_Pos)           /*!< 0x00000004 */
#define ADC_CHSELR_SQ1_3               (0x8UL << ADC_CHSELR_SQ1_Pos)           /*!< 0x00000008 */

#define ADC_CHSELR_SQ2_Pos             (4U)
#define ADC_CHSELR_SQ2_Msk             (0xFUL << ADC_CHSELR_SQ2_Pos)           /*!< 0x000000F0 */
#define ADC_CHSELR_SQ2                 ADC_CHSELR_SQ2_Msk                      /*!< ADC group regular sequencer rank 2, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ2_0               (0x1UL << ADC_CHSELR_SQ2_Pos)           /*!< 0x00000010 */
#define ADC_CHSELR_SQ2_1               (0x2UL << ADC_CHSELR_SQ2_Pos)           /*!< 0x00000020 */
#define ADC_CHSELR_SQ2_2               (0x4UL << ADC_CHSELR_SQ2_Pos)           /*!< 0x00000040 */
#define ADC_CHSELR_SQ2_3               (0x8UL << ADC_CHSELR_SQ2_Pos)           /*!< 0x00000080 */

#define ADC_CHSELR_SQ3_Pos             (8U)
#define ADC_CHSELR_SQ3_Msk             (0xFUL << ADC_CHSELR_SQ3_Pos)           /*!< 0x00000F00 */
#define ADC_CHSELR_SQ3                 ADC_CHSELR_SQ3_Msk                      /*!< ADC group regular sequencer rank 3, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ3_0               (0x1UL << ADC_CHSELR_SQ3_Pos)           /*!< 0x00000100 */
#define ADC_CHSELR_SQ3_1               (0x2UL << ADC_CHSELR_SQ3_Pos)           /*!< 0x00000200 */
#define ADC_CHSELR_SQ3_2               (0x4UL << ADC_CHSELR_SQ3_Pos)           /*!< 0x00000400 */
#define ADC_CHSELR_SQ3_3               (0x8UL << ADC_CHSELR_SQ3_Pos)           /*!< 0x00000800 */

#define ADC_CHSELR_SQ4_Pos             (12U)
#define ADC_CHSELR_SQ4_Msk             (0xFUL << ADC_CHSELR_SQ4_Pos)           /*!< 0x0000F000 */
#define ADC_CHSELR_SQ4                 ADC_CHSELR_SQ4_Msk                      /*!< ADC group regular sequencer rank 4, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ4_0               (0x1UL << ADC_CHSELR_SQ4_Pos)           /*!< 0x00001000 */
#define ADC_CHSELR_SQ4_1               (0x2UL << ADC_CHSELR_SQ4_Pos)           /*!< 0x00002000 */
#define ADC_CHSELR_SQ4_2               (0x4UL << ADC_CHSELR_SQ4_Pos)           /*!< 0x00004000 */
#define ADC_CHSELR_SQ4_3               (0x8UL << ADC_CHSELR_SQ4_Pos)           /*!< 0x00008000 */

#define ADC_CHSELR_SQ5_Pos             (16U)
#define ADC_CHSELR_SQ5_Msk             (0xFUL << ADC_CHSELR_SQ5_Pos)           /*!< 0x000F0000 */
#define ADC_CHSELR_SQ5                 ADC_CHSELR_SQ5_Msk                      /*!< ADC group regular sequencer rank 5, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ5_0               (0x1UL << ADC_CHSELR_SQ5_Pos)           /*!< 0x00010000 */
#define ADC_CHSELR_SQ5_1               (0x2UL << ADC_CHSELR_SQ5_Pos)           /*!< 0x00020000 */
#define ADC_CHSELR_SQ5_2               (0x4UL << ADC_CHSELR_SQ5_Pos)           /*!< 0x00040000 */
#define ADC_CHSELR_SQ5_3               (0x8UL << ADC_CHSELR_SQ5_Pos)           /*!< 0x00080000 */

#define ADC_CHSELR_SQ6_Pos             (20U)
#define ADC_CHSELR_SQ6_Msk             (0xFUL << ADC_CHSELR_SQ6_Pos)           /*!< 0x00F00000 */
#define ADC_CHSELR_SQ6                 ADC_CHSELR_SQ6_Msk                      /*!< ADC group regular sequencer rank 6, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ6_0               (0x1UL << ADC_CHSELR_SQ6_Pos)           /*!< 0x00100000 */
#define ADC_CHSELR_SQ6_1               (0x2UL << ADC_CHSELR_SQ6_Pos)           /*!< 0x00200000 */
#define ADC_CHSELR_SQ6_2               (0x4UL << ADC_CHSELR_SQ6_Pos)           /*!< 0x00400000 */
#define ADC_CHSELR_SQ6_3               (0x8UL << ADC_CHSELR_SQ6_Pos)           /*!< 0x00800000 */

#define ADC_CHSELR_SQ7_Pos             (24U)
#define ADC_CHSELR_SQ7_Msk             (0xFUL << ADC_CHSELR_SQ7_Pos)           /*!< 0x0F000000 */
#define ADC_CHSELR_SQ7                 ADC_CHSELR_SQ7_Msk                      /*!< ADC group regular sequencer rank 7, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ7_0               (0x1UL << ADC_CHSELR_SQ7_Pos)           /*!< 0x01000000 */
#define ADC_CHSELR_SQ7_1               (0x2UL << ADC_CHSELR_SQ7_Pos)           /*!< 0x02000000 */
#define ADC_CHSELR_SQ7_2               (0x4UL << ADC_CHSELR_SQ7_Pos)           /*!< 0x04000000 */
#define ADC_CHSELR_SQ7_3               (0x8UL << ADC_CHSELR_SQ7_Pos)           /*!< 0x08000000 */

#define ADC_CHSELR_SQ8_Pos             (28U)
#define ADC_CHSELR_SQ8_Msk             (0xFUL << ADC_CHSELR_SQ8_Pos)           /*!< 0xF0000000 */
#define ADC_CHSELR_SQ8                 ADC_CHSELR_SQ8_Msk                      /*!< ADC group regular sequencer rank 8, available when ADC_CFGR1_CHSELRMOD is set */
#define ADC_CHSELR_SQ8_0               (0x1UL << ADC_CHSELR_SQ8_Pos)           /*!< 0x10000000 */
#define ADC_CHSELR_SQ8_1               (0x2UL << ADC_CHSELR_SQ8_Pos)           /*!< 0x20000000 */
#define ADC_CHSELR_SQ8_2               (0x4UL << ADC_CHSELR_SQ8_Pos)           /*!< 0x40000000 */
#define ADC_CHSELR_SQ8_3               (0x8UL << ADC_CHSELR_SQ8_Pos)           /*!< 0x80000000 */

/********************  Bit definition for ADC_AWD3TR register  *******************/
#define ADC_AWD3TR_LT3_Pos                (0U)
#define ADC_AWD3TR_LT3_Msk                (0xFFFUL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000FFF */
#define ADC_AWD3TR_LT3                    ADC_AWD3TR_LT3_Msk                   /*!< ADC analog watchdog 3 threshold low */
#define ADC_AWD3TR_LT3_0                  (0x001UL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000001 */
#define ADC_AWD3TR_LT3_1                  (0x002UL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000002 */
#define ADC_AWD3TR_LT3_2                  (0x004UL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000004 */
#define ADC_AWD3TR_LT3_3                  (0x008UL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000008 */
#define ADC_AWD3TR_LT3_4                  (0x010UL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000010 */
#define ADC_AWD3TR_LT3_5                  (0x020UL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000020 */
#define ADC_AWD3TR_LT3_6                  (0x040UL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000040 */
#define ADC_AWD3TR_LT3_7                  (0x080UL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000080 */
#define ADC_AWD3TR_LT3_8                  (0x100UL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000100 */
#define ADC_AWD3TR_LT3_9                  (0x200UL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000200 */
#define ADC_AWD3TR_LT3_10                 (0x400UL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000400 */
#define ADC_AWD3TR_LT3_11                 (0x800UL << ADC_AWD3TR_LT3_Pos)      /*!< 0x00000800 */

#define ADC_AWD3TR_HT3_Pos                (16U)
#define ADC_AWD3TR_HT3_Msk                (0xFFFUL << ADC_AWD3TR_HT3_Pos)      /*!< 0x0FFF0000 */
#define ADC_AWD3TR_HT3                    ADC_AWD3TR_HT3_Msk                   /*!< ADC analog watchdog 3 threshold high */
#define ADC_AWD3TR_HT3_0                  (0x001UL << ADC_AWD3TR_HT3_Pos)      /*!< 0x00010000 */
#define ADC_AWD3TR_HT3_1                  (0x002UL << ADC_AWD3TR_HT3_Pos)      /*!< 0x00020000 */
#define ADC_AWD3TR_HT3_2                  (0x004UL << ADC_AWD3TR_HT3_Pos)      /*!< 0x00040000 */
#define ADC_AWD3TR_HT3_3                  (0x008UL << ADC_AWD3TR_HT3_Pos)      /*!< 0x00080000 */
#define ADC_AWD3TR_HT3_4                  (0x010UL << ADC_AWD3TR_HT3_Pos)      /*!< 0x00100000 */
#define ADC_AWD3TR_HT3_5                  (0x020UL << ADC_AWD3TR_HT3_Pos)      /*!< 0x00200000 */
#define ADC_AWD3TR_HT3_6                  (0x040UL << ADC_AWD3TR_HT3_Pos)      /*!< 0x00400000 */
#define ADC_AWD3TR_HT3_7                  (0x080UL << ADC_AWD3TR_HT3_Pos)      /*!< 0x00800000 */
#define ADC_AWD3TR_HT3_8                  (0x100UL << ADC_AWD3TR_HT3_Pos)      /*!< 0x01000000 */
#define ADC_AWD3TR_HT3_9                  (0x200UL << ADC_AWD3TR_HT3_Pos)      /*!< 0x02000000 */
#define ADC_AWD3TR_HT3_10                 (0x400UL << ADC_AWD3TR_HT3_Pos)      /*!< 0x04000000 */
#define ADC_AWD3TR_HT3_11                 (0x800UL << ADC_AWD3TR_HT3_Pos)      /*!< 0x08000000 */

/********************  Bit definition for ADC_AWD3CR register  ********************/
#define ADC_AWD3CR_AWD3CH_Pos             (0U)
#define ADC_AWD3CR_AWD3CH_Msk             (0xFFFFFFUL << ADC_AWD3CR_AWD3CH_Pos) /*!< 0x00FFFFFF */
#define ADC_AWD3CR_AWD3CH                 ADC_AWD3CR_AWD3CH_Msk                 /*!< ADC Analog watchdog 2 channel selection */
#define ADC_AWD3CR_AWD3CH_0               (0x00001UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000001 */
#define ADC_AWD3CR_AWD3CH_1               (0x00002UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000002 */
#define ADC_AWD3CR_AWD3CH_2               (0x00004UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000004 */
#define ADC_AWD3CR_AWD3CH_3               (0x00008UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000008 */
#define ADC_AWD3CR_AWD3CH_4               (0x00010UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000010 */
#define ADC_AWD3CR_AWD3CH_5               (0x00020UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000020 */
#define ADC_AWD3CR_AWD3CH_6               (0x00040UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000040 */
#define ADC_AWD3CR_AWD3CH_7               (0x00080UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000080 */
#define ADC_AWD3CR_AWD3CH_8               (0x00100UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000100 */
#define ADC_AWD3CR_AWD3CH_9               (0x00200UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000200 */
#define ADC_AWD3CR_AWD3CH_10              (0x00400UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000400 */
#define ADC_AWD3CR_AWD3CH_11              (0x00800UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000800 */
#define ADC_AWD3CR_AWD3CH_12              (0x01000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00001000 */
#define ADC_AWD3CR_AWD3CH_13              (0x02000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00002000 */
#define ADC_AWD3CR_AWD3CH_14              (0x04000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00004000 */
#define ADC_AWD3CR_AWD3CH_15              (0x08000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00008000 */
#define ADC_AWD3CR_AWD3CH_16              (0x10000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00010000 */
#define ADC_AWD3CR_AWD3CH_17              (0x20000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00020000 */
#define ADC_AWD3CR_AWD3CH_18              (0x40000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00040000 */
#define ADC_AWD3CR_AWD3CH_19              (0x80000UL << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00080000 */
#define ADC_AWD3CR_AWD2CH_20              (0x100000UL << ADC_AWD3CR_AWD2CH_Pos) /*!< 0x00100000 */
#define ADC_AWD3CR_AWD2CH_21              (0x200000UL << ADC_AWD3CR_AWD2CH_Pos) /*!< 0x00200000 */
#define ADC_AWD3CR_AWD2CH_22              (0x400000UL << ADC_AWD3CR_AWD2CH_Pos) /*!< 0x00400000 */
#define ADC_AWD3CR_AWD2CH_23              (0x800000UL << ADC_AWD3CR_AWD2CH_Pos) /*!< 0x00800000 */

/********************  Bit definition for ADC_DIFSEL register  ********************/
#define ADC_DIFSEL_DIFSEL_Pos             (0U)
#define ADC_DIFSEL_DIFSEL_Msk             (0xFFFFFUL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x000FFFFF */
#define ADC_DIFSEL_DIFSEL                 ADC_DIFSEL_DIFSEL_Msk                 /*!< ADC differential modes for channels 1 to 18 */
#define ADC_DIFSEL_DIFSEL_0               (0x00001UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000001 */
#define ADC_DIFSEL_DIFSEL_1               (0x00002UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000002 */
#define ADC_DIFSEL_DIFSEL_2               (0x00004UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000004 */
#define ADC_DIFSEL_DIFSEL_3               (0x00008UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000008 */
#define ADC_DIFSEL_DIFSEL_4               (0x00010UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000010 */
#define ADC_DIFSEL_DIFSEL_5               (0x00020UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000020 */
#define ADC_DIFSEL_DIFSEL_6               (0x00040UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000040 */
#define ADC_DIFSEL_DIFSEL_7               (0x00080UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000080 */
#define ADC_DIFSEL_DIFSEL_8               (0x00100UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000100 */
#define ADC_DIFSEL_DIFSEL_9               (0x00200UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000200 */
#define ADC_DIFSEL_DIFSEL_10              (0x00400UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000400 */
#define ADC_DIFSEL_DIFSEL_11              (0x00800UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000800 */
#define ADC_DIFSEL_DIFSEL_12              (0x01000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00001000 */
#define ADC_DIFSEL_DIFSEL_13              (0x02000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00002000 */
#define ADC_DIFSEL_DIFSEL_14              (0x04000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00004000 */
#define ADC_DIFSEL_DIFSEL_15              (0x08000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00008000 */
#define ADC_DIFSEL_DIFSEL_16              (0x10000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00010000 */
#define ADC_DIFSEL_DIFSEL_17              (0x20000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00020000 */
#define ADC_DIFSEL_DIFSEL_18              (0x40000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00040000 */
#define ADC_DIFSEL_DIFSEL_19              (0x80000UL << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00080000 */

/********************  Bit definition for ADC_CALFACT register  ********************/
#define ADC_CALFACT_I_APB_ADDR_Pos         (0U)
#define ADC_CALFACT_I_APB_ADDR_Msk         (0xFFUL << ADC_CALFACT_I_APB_ADDR_Pos) /*!< 0x000000FF */
#define ADC_CALFACT_I_APB_ADDR             ADC_CALFACT_I_APB_ADDR_Msk             /*!< ADC calibration factors in single-ended mode */
#define ADC_CALFACT_I_APB_ADDR_0           (0x001U << ADC_CALFACT_I_APB_ADDR_Pos) /*!< 0x00000001 */
#define ADC_CALFACT_I_APB_ADDR_1           (0x002U << ADC_CALFACT_I_APB_ADDR_Pos) /*!< 0x00000002 */
#define ADC_CALFACT_I_APB_ADDR_2           (0x004U << ADC_CALFACT_I_APB_ADDR_Pos) /*!< 0x00000004 */
#define ADC_CALFACT_I_APB_ADDR_3           (0x008U << ADC_CALFACT_I_APB_ADDR_Pos) /*!< 0x00000008 */
#define ADC_CALFACT_I_APB_ADDR_4           (0x010U << ADC_CALFACT_I_APB_ADDR_Pos) /*!< 0x00000010 */
#define ADC_CALFACT_I_APB_ADDR_5           (0x020U << ADC_CALFACT_I_APB_ADDR_Pos) /*!< 0x00000020 */
#define ADC_CALFACT_I_APB_ADDR_6           (0x040U << ADC_CALFACT_I_APB_ADDR_Pos) /*!< 0x00000040 */
#define ADC_CALFACT_I_APB_ADDR_7           (0x080U << ADC_CALFACT_I_APB_ADDR_Pos) /*!< 0x00000080 */

#define ADC_CALFACT_I_APB_DATA_Pos         (08U)
#define ADC_CALFACT_I_APB_DATA_Msk         (0xFFUL << ADC_CALFACT_I_APB_DATA_Pos) /*!< 0x0000FF00 */
#define ADC_CALFACT_I_APB_DATA             ADC_CALFACT_I_APB_DATA_Msk             /*!< ADC calibration factors in differential mode */
#define ADC_CALFACT_APB_DATA_0             (0x001U << ADC_CALFACT_APB_DATA_Pos)   /*!< 0x00000100 */
#define ADC_CALFACT_APB_DATA_1             (0x002U << ADC_CALFACT_APB_DATA_Pos)   /*!< 0x00000200 */
#define ADC_CALFACT_APB_DATA_2             (0x004U << ADC_CALFACT_APB_DATA_Pos)   /*!< 0x00000400 */
#define ADC_CALFACT_APB_DATA_3             (0x008U << ADC_CALFACT_APB_DATA_Pos)   /*!< 0x00000800 */
#define ADC_CALFACT_APB_DATA_4             (0x010U << ADC_CALFACT_APB_DATA_Pos)   /*!< 0x00001000 */
#define ADC_CALFACT_APB_DATA_5             (0x020U << ADC_CALFACT_APB_DATA_Pos)   /*!< 0x00002000 */
#define ADC_CALFACT_APB_DATA_6             (0x040U << ADC_CALFACT_APB_DATA_Pos)   /*!< 0x00004000 */
#define ADC_CALFACT_APB_DATA_7             (0x080U << ADC_CALFACT_APB_DATA_Pos)   /*!< 0x00008000 */

#define ADC_CALFACT_VALIDITY_Pos           (16U)
#define ADC_CALFACT_VALIDITY_Msk           (0x1UL << ADC_CALFACT_VALIDITY_Pos)     /*!< 0x00010000 */
#define ADC_CALFACT_VALIDITY               ADC_CALFACT_VALIDITY_Msk                /*!< ADC calibration factors in differential mode */
#define ADC_CALFACT_LATCH_COEF_Pos         (24U)
#define ADC_CALFACT_LATCH_COEF_Msk         (0x1UL << ADC_CALFACT_LATCH_COEF_Pos)   /*!< 0x01000000 */
#define ADC_CALFACT_LATCH_COEF             ADC_CALFACT_LATCH_COEF_Msk              /*!< ADC calibration factors in differential mode */
#define ADC_CALFACT_CAPTURE_COEF_Pos       (25U)
#define ADC_CALFACT_CAPTURE_COEF_Msk       (0x1UL << ADC_CALFACT_CAPTURE_COEF_Pos) /*!< 0x01000000 */
#define ADC_CALFACT_CAPTURE_COEF           ADC_CALFACT_CAPTURE_COEF_Msk            /*!< ADC calibration factors in differential mode */

#define ADC4_CALFACT_CALFACT_Pos        (0U)
#define ADC4_CALFACT_CALFACT_Msk        (0x7FUL << ADC4_CALFACT_CALFACT_Pos)     /*!< 0x0000007F */
#define ADC4_CALFACT_CALFACT            ADC4_CALFACT_CALFACT_Msk                 /*!< ADC calibration factor in single-ended mode */
#define ADC4_CALFACT_CALFACT_0          (0x01UL << ADC4_CALFACT_CALFACT_Pos)     /*!< 0x00000001 */
#define ADC4_CALFACT_CALFACT_1          (0x02UL << ADC4_CALFACT_CALFACT_Pos)     /*!< 0x00000002 */
#define ADC4_CALFACT_CALFACT_2          (0x04UL << ADC4_CALFACT_CALFACT_Pos)     /*!< 0x00000004 */
#define ADC4_CALFACT_CALFACT_3          (0x08UL << ADC4_CALFACT_CALFACT_Pos)     /*!< 0x00000008 */
#define ADC4_CALFACT_CALFACT_4          (0x10UL << ADC4_CALFACT_CALFACT_Pos)     /*!< 0x00000010 */
#define ADC4_CALFACT_CALFACT_5          (0x20UL << ADC4_CALFACT_CALFACT_Pos)     /*!< 0x00000020 */
#define ADC4_CALFACT_CALFACT_6          (0x40UL << ADC4_CALFACT_CALFACT_Pos)     /*!< 0x00000040 */

/********************  Bit definition for ADC_CALFACT2 register  ********************/
#define ADC_CALFACT2_CALFACT_Pos       (0U)
#define ADC_CALFACT2_CALFACT_Msk       (0xFFFFFFFFUL << ADC_CALFACT2_CALFACT_Pos) /*!< 0xFFFFFFFF */
#define ADC_CALFACT2_CALFACT           ADC_CALFACT2_CALFACT_Msk                   /*!< ADC Linearity calibration factors */
#define ADC_CALFACT2_CALFACT_0         (0x00000001UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00000001 */
#define ADC_CALFACT2_CALFACT_1         (0x00000002UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00000002 */
#define ADC_CALFACT2_CALFACT_2         (0x00000004UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00000004 */
#define ADC_CALFACT2_CALFACT_3         (0x00000008UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00000008 */
#define ADC_CALFACT2_CALFACT_4         (0x00000010UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00000010 */
#define ADC_CALFACT2_CALFACT_5         (0x00000020UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00000020 */
#define ADC_CALFACT2_CALFACT_6         (0x00000040UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00000040 */
#define ADC_CALFACT2_CALFACT_7         (0x00000080UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00000080 */
#define ADC_CALFACT2_CALFACT_8         (0x00000100UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00000100 */
#define ADC_CALFACT2_CALFACT_9         (0x00000200UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00000200 */
#define ADC_CALFACT2_CALFACT_10        (0x00000400UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00000400 */
#define ADC_CALFACT2_CALFACT_11        (0x00000800UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00000800 */
#define ADC_CALFACT2_CALFACT_12        (0x00001000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00001000 */
#define ADC_CALFACT2_CALFACT_13        (0x00002000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00002000 */
#define ADC_CALFACT2_CALFACT_14        (0x00004000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00004000 */
#define ADC_CALFACT2_CALFACT_15        (0x00008000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00008000 */
#define ADC_CALFACT2_CALFACT_16        (0x00010000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00010000 */
#define ADC_CALFACT2_CALFACT_17        (0x00020000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00020000 */
#define ADC_CALFACT2_CALFACT_18        (0x00040000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00040000 */
#define ADC_CALFACT2_CALFACT_19        (0x00080000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00080000 */
#define ADC_CALFACT2_CALFACT_20        (0x00100000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00100000 */
#define ADC_CALFACT2_CALFACT_21        (0x00200000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00200000 */
#define ADC_CALFACT2_CALFACT_22        (0x00400000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00400000 */
#define ADC_CALFACT2_CALFACT_23        (0x00800000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x00800000 */
#define ADC_CALFACT2_CALFACT_24        (0x01000000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x01000000 */
#define ADC_CALFACT2_CALFACT_25        (0x02000000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x02000000 */
#define ADC_CALFACT2_CALFACT_26        (0x04000000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x04000000 */
#define ADC_CALFACT2_CALFACT_27        (0x08000000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x08000000 */
#define ADC_CALFACT2_CALFACT_28        (0x10000000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x10000000 */
#define ADC_CALFACT2_CALFACT_29        (0x20000000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x20000000 */
#define ADC_CALFACT2_CALFACT_30        (0x40000000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x40000000 */
#define ADC_CALFACT2_CALFACT_31        (0x80000000UL << ADC_CALFACT2_CALFACT_Pos) /*!< 0x80000000 */

/********************  Bit definition for ADC_OR register  ********************/
#define ADC_OR_CHN0SEL_Pos             (0U)
#define ADC_OR_CHN0SEL_Msk             (0x1UL << ADC_OR_CHN0SEL_Pos)              /*!< 0x00000001 */
#define ADC_OR_CHN0SEL                 ADC_OR_CHN0SEL_Msk                         /*!< ADC Channel 0 selection */

/*************************  ADC Common registers  *****************************/
/********************  Bit definition for ADC_CSR register  ********************/
#define ADC_CSR_ADRDY_MST_Pos             (0U)
#define ADC_CSR_ADRDY_MST_Msk             (0x1UL << ADC_CSR_ADRDY_MST_Pos)     /*!< 0x00000001 */
#define ADC_CSR_ADRDY_MST                 ADC_CSR_ADRDY_MST_Msk                /*!< Master ADC ready */
#define ADC_CSR_EOSMP_MST_Pos             (1U)
#define ADC_CSR_EOSMP_MST_Msk             (0x1UL << ADC_CSR_EOSMP_MST_Pos)     /*!< 0x00000002 */
#define ADC_CSR_EOSMP_MST                 ADC_CSR_EOSMP_MST_Msk                /*!< End of sampling phase flag of the master ADC */
#define ADC_CSR_EOC_MST_Pos               (2U)
#define ADC_CSR_EOC_MST_Msk               (0x1UL << ADC_CSR_EOC_MST_Pos)       /*!< 0x00000004 */
#define ADC_CSR_EOC_MST                   ADC_CSR_EOC_MST_Msk                  /*!< End of regular conversion of the master ADC */
#define ADC_CSR_EOS_MST_Pos               (3U)
#define ADC_CSR_EOS_MST_Msk               (0x1UL << ADC_CSR_EOS_MST_Pos)       /*!< 0x00000008 */
#define ADC_CSR_EOS_MST                   ADC_CSR_EOS_MST_Msk                  /*!< End of regular sequence flag of the master ADC */
#define ADC_CSR_OVR_MST_Pos               (4U)
#define ADC_CSR_OVR_MST_Msk               (0x1UL << ADC_CSR_OVR_MST_Pos)       /*!< 0x00000010 */
#define ADC_CSR_OVR_MST                   ADC_CSR_OVR_MST_Msk                  /*!< Overrun flag of the master ADC */
#define ADC_CSR_JEOC_MST_Pos              (5U)
#define ADC_CSR_JEOC_MST_Msk              (0x1UL << ADC_CSR_JEOC_MST_Pos)      /*!< 0x00000020 */
#define ADC_CSR_JEOC_MST                  ADC_CSR_JEOC_MST_Msk                 /*!< End of injected conversion of the master ADC */
#define ADC_CSR_JEOS_MST_Pos              (6U)
#define ADC_CSR_JEOS_MST_Msk              (0x1UL << ADC_CSR_JEOS_MST_Pos)      /*!< 0x00000040 */
#define ADC_CSR_JEOS_MST                  ADC_CSR_JEOS_MST_Msk                 /*!< End of injected sequence flag of the master ADC */
#define ADC_CSR_AWD1_MST_Pos              (7U)
#define ADC_CSR_AWD1_MST_Msk              (0x1UL << ADC_CSR_AWD1_MST_Pos)      /*!< 0x00000080 */
#define ADC_CSR_AWD1_MST                  ADC_CSR_AWD1_MST_Msk                 /*!< Analog watchdog 1 flag of the master ADC */
#define ADC_CSR_AWD2_MST_Pos              (8U)
#define ADC_CSR_AWD2_MST_Msk              (0x1UL << ADC_CSR_AWD2_MST_Pos)      /*!< 0x00000100 */
#define ADC_CSR_AWD2_MST                  ADC_CSR_AWD2_MST_Msk                 /*!< Analog watchdog 2 flag of the master ADC */
#define ADC_CSR_AWD3_MST_Pos              (9U)
#define ADC_CSR_AWD3_MST_Msk              (0x1UL << ADC_CSR_AWD3_MST_Pos)      /*!< 0x00000200 */
#define ADC_CSR_AWD3_MST                  ADC_CSR_AWD3_MST_Msk                 /*!< Analog watchdog 3 flag of the master ADC */
#define ADC_CSR_JQOVF_MST_Pos             (10U)
#define ADC_CSR_JQOVF_MST_Msk             (0x1UL << ADC_CSR_JQOVF_MST_Pos)     /*!< 0x00000400 */
#define ADC_CSR_JQOVF_MST                 ADC_CSR_JQOVF_MST_Msk                /*!< Injected context queue overflow flag of the master ADC */
#define ADC_CSR_LDORDY_MST_Pos            (12U)
#define ADC_CSR_LDORDY_MST_Msk            (0x1UL << ADC_CSR_LDORDY_MST_Pos)     /*!< 0x00001000 */
#define ADC_CSR_LDORDY_MST                ADC_CSR_LDORDY_MST_Msk                /*!< Voltage regulator ready flag of the master ADC */
#define ADC_CSR_ADRDY_SLV_Pos             (16U)
#define ADC_CSR_ADRDY_SLV_Msk             (0x1UL << ADC_CSR_ADRDY_SLV_Pos)     /*!< 0x00010000 */
#define ADC_CSR_ADRDY_SLV                 ADC_CSR_ADRDY_SLV_Msk                /*!< Slave ADC ready */
#define ADC_CSR_EOSMP_SLV_Pos             (17U)
#define ADC_CSR_EOSMP_SLV_Msk             (0x1UL << ADC_CSR_EOSMP_SLV_Pos)     /*!< 0x00020000 */
#define ADC_CSR_EOSMP_SLV                 ADC_CSR_EOSMP_SLV_Msk                /*!< End of sampling phase flag of the slave ADC */
#define ADC_CSR_EOC_SLV_Pos               (18U)
#define ADC_CSR_EOC_SLV_Msk               (0x1UL << ADC_CSR_EOC_SLV_Pos)       /*!< 0x00040000 */
#define ADC_CSR_EOC_SLV                   ADC_CSR_EOC_SLV_Msk                  /*!< End of regular conversion of the slave ADC */
#define ADC_CSR_EOS_SLV_Pos               (19U)
#define ADC_CSR_EOS_SLV_Msk               (0x1UL << ADC_CSR_EOS_SLV_Pos)       /*!< 0x00080000 */
#define ADC_CSR_EOS_SLV                   ADC_CSR_EOS_SLV_Msk                  /*!< End of regular sequence flag of the slave ADC */
#define ADC_CSR_OVR_SLV_Pos               (20U)
#define ADC_CSR_OVR_SLV_Msk               (0x1UL << ADC_CSR_OVR_SLV_Pos)       /*!< 0x00100000 */
#define ADC_CSR_OVR_SLV                   ADC_CSR_OVR_SLV_Msk                  /*!< Overrun flag of the slave ADC */
#define ADC_CSR_JEOC_SLV_Pos              (21U)
#define ADC_CSR_JEOC_SLV_Msk              (0x1UL << ADC_CSR_JEOC_SLV_Pos)      /*!< 0x00200000 */
#define ADC_CSR_JEOC_SLV                  ADC_CSR_JEOC_SLV_Msk                 /*!< End of injected conversion of the slave ADC */
#define ADC_CSR_JEOS_SLV_Pos              (22U)
#define ADC_CSR_JEOS_SLV_Msk              (0x1UL << ADC_CSR_JEOS_SLV_Pos)      /*!< 0x00400000 */
#define ADC_CSR_JEOS_SLV                  ADC_CSR_JEOS_SLV_Msk                 /*!< End of injected sequence flag of the slave ADC */
#define ADC_CSR_AWD1_SLV_Pos              (23U)
#define ADC_CSR_AWD1_SLV_Msk              (0x1UL << ADC_CSR_AWD1_SLV_Pos)      /*!< 0x00800000 */
#define ADC_CSR_AWD1_SLV                  ADC_CSR_AWD1_SLV_Msk                 /*!< Analog watchdog 1 flag of the slave ADC */
#define ADC_CSR_AWD2_SLV_Pos              (24U)
#define ADC_CSR_AWD2_SLV_Msk              (0x1UL << ADC_CSR_AWD2_SLV_Pos)      /*!< 0x01000000 */
#define ADC_CSR_AWD2_SLV                  ADC_CSR_AWD2_SLV_Msk                 /*!< Analog watchdog 2 flag of the slave ADC */
#define ADC_CSR_AWD3_SLV_Pos              (25U)
#define ADC_CSR_AWD3_SLV_Msk              (0x1UL << ADC_CSR_AWD3_SLV_Pos)      /*!< 0x02000000 */
#define ADC_CSR_AWD3_SLV                  ADC_CSR_AWD3_SLV_Msk                 /*!< Analog watchdog 3 flag of the slave ADC */
#define ADC_CSR_JQOVF_SLV_Pos             (26U)
#define ADC_CSR_JQOVF_SLV_Msk             (0x1UL << ADC_CSR_JQOVF_SLV_Pos)     /*!< 0x04000000 */
#define ADC_CSR_JQOVF_SLV                 ADC_CSR_JQOVF_SLV_Msk                /*!< Injected context queue overflow flag of the slave ADC */
#define ADC_CSR_LDORDY_SLV_Pos            (28U)
#define ADC_CSR_LDORDY_SLV_Msk            (0x1UL << ADC_CSR_LDORDY_SLV_Pos)     /*!< 0x10000000 */
#define ADC_CSR_LDORDY_SLV                ADC_CSR_LDORDY_SLV_Msk                /*!< Voltage regulator ready flag of the slave ADC */

/********************  Bit definition for ADC_CCR register  ********************/
#define ADC_CCR_DUAL_Pos                  (0U)
#define ADC_CCR_DUAL_Msk                  (0x1FUL << ADC_CCR_DUAL_Pos)          /*!< 0x0000001F */
#define ADC_CCR_DUAL                      ADC_CCR_DUAL_Msk                      /*!< Dual ADC mode selection */
#define ADC_CCR_DUAL_0                    (0x01UL << ADC_CCR_DUAL_Pos)          /*!< 0x00000001 */
#define ADC_CCR_DUAL_1                    (0x02UL << ADC_CCR_DUAL_Pos)          /*!< 0x00000002 */
#define ADC_CCR_DUAL_2                    (0x04UL << ADC_CCR_DUAL_Pos)          /*!< 0x00000004 */
#define ADC_CCR_DUAL_3                    (0x08UL << ADC_CCR_DUAL_Pos)          /*!< 0x00000008 */
#define ADC_CCR_DUAL_4                    (0x10UL << ADC_CCR_DUAL_Pos)          /*!< 0x00000010 */

#define ADC_CCR_DELAY_Pos                 (8U)
#define ADC_CCR_DELAY_Msk                 (0xFUL << ADC_CCR_DELAY_Pos)          /*!< 0x00000F00 */
#define ADC_CCR_DELAY                     ADC_CCR_DELAY_Msk                     /*!< Delay between 2 sampling phases */
#define ADC_CCR_DELAY_0                   (0x1UL << ADC_CCR_DELAY_Pos)          /*!< 0x00000100 */
#define ADC_CCR_DELAY_1                   (0x2UL << ADC_CCR_DELAY_Pos)          /*!< 0x00000200 */
#define ADC_CCR_DELAY_2                   (0x4UL << ADC_CCR_DELAY_Pos)          /*!< 0x00000400 */
#define ADC_CCR_DELAY_3                   (0x8UL << ADC_CCR_DELAY_Pos)          /*!< 0x00000800 */

#define ADC_CCR_DAMDF_Pos                 (14U)
#define ADC_CCR_DAMDF_Msk                 (0x3UL << ADC_CCR_DAMDF_Pos)          /*!< 0x0000C000 */
#define ADC_CCR_DAMDF                     ADC_CCR_DAMDF_Msk                     /*!< Dual ADC mode data format */
#define ADC_CCR_DAMDF_0                   (0x1UL << ADC_CCR_DAMDF_Pos)          /*!< 0x00004000 */
#define ADC_CCR_DAMDF_1                   (0x2UL << ADC_CCR_DAMDF_Pos)          /*!< 0x00008000 */

#define ADC_CCR_PRESC_Pos                 (18U)
#define ADC_CCR_PRESC_Msk                 (0xFUL << ADC_CCR_PRESC_Pos)          /*!< 0x003C0000 */
#define ADC_CCR_PRESC                     ADC_CCR_PRESC_Msk                     /*!< ADC prescaler */
#define ADC_CCR_PRESC_0                   (0x1UL << ADC_CCR_PRESC_Pos)          /*!< 0x00040000 */
#define ADC_CCR_PRESC_1                   (0x2UL << ADC_CCR_PRESC_Pos)          /*!< 0x00080000 */
#define ADC_CCR_PRESC_2                   (0x4UL << ADC_CCR_PRESC_Pos)          /*!< 0x00100000 */
#define ADC_CCR_PRESC_3                   (0x8UL << ADC_CCR_PRESC_Pos)          /*!< 0x00200000 */

#define ADC_CCR_VREFEN_Pos                (22U)
#define ADC_CCR_VREFEN_Msk                (0x1UL << ADC_CCR_VREFEN_Pos)         /*!< 0x00400000 */
#define ADC_CCR_VREFEN                    ADC_CCR_VREFEN_Msk                    /*!< VREFINT enable */
#define ADC_CCR_VSENSEEN_Pos              (23U)
#define ADC_CCR_VSENSEEN_Msk              (0x1UL << ADC_CCR_VSENSEEN_Pos)       /*!< 0x00800000 */
#define ADC_CCR_VSENSEEN                  ADC_CCR_VSENSEEN_Msk                  /*!< Temperature sensor enable */
#define ADC_CCR_VBATEN_Pos                (24U)
#define ADC_CCR_VBATEN_Msk                (0x1UL << ADC_CCR_VBATEN_Pos)         /*!< 0x01000000 */
#define ADC_CCR_VBATEN                    ADC_CCR_VBATEN_Msk                    /*!< VBAT enable */
#define ADC_CCR_LFMEN_Pos                 (25U)
#define ADC_CCR_LFMEN_Msk                 (0x1UL << ADC_CCR_LFMEN_Pos)          /*!< 0x02000000 */
#define ADC_CCR_LFMEN                     ADC_CCR_LFMEN_Msk                     /*!< Low Frequency Mode Enable, specific ADC4*/
#define ADC_CCR_VDDCOREN_Pos              (26U)
#define ADC_CCR_VDDCOREN_Msk              (0x1UL << ADC_CCR_VDDCOREN_Pos)       /*!< 0x04000000 */
#define ADC_CCR_VDDCOREN                  ADC_CCR_VDDCOREN_Msk                  /*!< VDDCode enable */

/********************  Bit definition for ADC_CDR register  *******************/
#define ADC_CDR_RDATA_MST_Pos             (0U)
#define ADC_CDR_RDATA_MST_Msk             (0xFFFFUL << ADC_CDR_RDATA_MST_Pos)   /*!< 0x0000FFFF */
#define ADC_CDR_RDATA_MST                 ADC_CDR_RDATA_MST_Msk                 /*!< ADC multimode master group regular conversion data */

#define ADC_CDR_RDATA_SLV_Pos             (16U)
#define ADC_CDR_RDATA_SLV_Msk             (0xFFFFUL << ADC_CDR_RDATA_SLV_Pos)   /*!< 0xFFFF0000 */
#define ADC_CDR_RDATA_SLV                 ADC_CDR_RDATA_SLV_Msk                 /*!< ADC multimode slave group regular conversion data */

/********************  Bit definition for ADC_CDR2 register  ******************/
#define ADC_CDR2_RDATA_ALT_Pos            (0U)
#define ADC_CDR2_RDATA_ALT_Msk            (0xFFFFFFFFUL << ADC_CDR2_RDATA_ALT_Pos) /*!< 0xFFFFFFFF */
#define ADC_CDR2_RDATA_ALT                ADC_CDR2_RDATA_ALT_Msk                   /*!< Regular data of the master/slave alternated ADCs */

/******************************************************************************/
/*                                                                            */
/*                          CORDIC calculation unit                           */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CORDIC_CSR register  *****************/
#define CORDIC_CSR_FUNC_Pos                 (0U)
#define CORDIC_CSR_FUNC_Msk                 (0xFUL << CORDIC_CSR_FUNC_Pos)          /*!< 0x0000000F */
#define CORDIC_CSR_FUNC                     CORDIC_CSR_FUNC_Msk                     /*!< Function */
#define CORDIC_CSR_FUNC_0                   (0x1UL << CORDIC_CSR_FUNC_Pos)          /*!< 0x00000001 */
#define CORDIC_CSR_FUNC_1                   (0x2UL << CORDIC_CSR_FUNC_Pos)          /*!< 0x00000002 */
#define CORDIC_CSR_FUNC_2                   (0x4UL << CORDIC_CSR_FUNC_Pos)          /*!< 0x00000004 */
#define CORDIC_CSR_FUNC_3                   (0x8UL << CORDIC_CSR_FUNC_Pos)          /*!< 0x00000008 */
#define CORDIC_CSR_PRECISION_Pos            (4U)
#define CORDIC_CSR_PRECISION_Msk            (0xFUL << CORDIC_CSR_PRECISION_Pos)     /*!< 0x000000F0 */
#define CORDIC_CSR_PRECISION                CORDIC_CSR_PRECISION_Msk                /*!< Precision */
#define CORDIC_CSR_PRECISION_0              (0x1UL << CORDIC_CSR_PRECISION_Pos)     /*!< 0x00000010 */
#define CORDIC_CSR_PRECISION_1              (0x2UL << CORDIC_CSR_PRECISION_Pos)     /*!< 0x00000020 */
#define CORDIC_CSR_PRECISION_2              (0x4UL << CORDIC_CSR_PRECISION_Pos)     /*!< 0x00000040 */
#define CORDIC_CSR_PRECISION_3              (0x8UL << CORDIC_CSR_PRECISION_Pos)     /*!< 0x00000080 */
#define CORDIC_CSR_SCALE_Pos                (8U)
#define CORDIC_CSR_SCALE_Msk                (0x7UL << CORDIC_CSR_SCALE_Pos)         /*!< 0x00000700 */
#define CORDIC_CSR_SCALE                    CORDIC_CSR_SCALE_Msk                    /*!< Scaling factor */
#define CORDIC_CSR_SCALE_0                  (0x1UL << CORDIC_CSR_SCALE_Pos)         /*!< 0x00000100 */
#define CORDIC_CSR_SCALE_1                  (0x2UL << CORDIC_CSR_SCALE_Pos)         /*!< 0x00000200 */
#define CORDIC_CSR_SCALE_2                  (0x4UL << CORDIC_CSR_SCALE_Pos)         /*!< 0x00000400 */
#define CORDIC_CSR_IEN_Pos                  (16U)
#define CORDIC_CSR_IEN_Msk                  (0x1UL << CORDIC_CSR_IEN_Pos)           /*!< 0x00010000 */
#define CORDIC_CSR_IEN                      CORDIC_CSR_IEN_Msk                      /*!< Interrupt Enable */
#define CORDIC_CSR_DMAREN_Pos               (17U)
#define CORDIC_CSR_DMAREN_Msk               (0x1UL << CORDIC_CSR_DMAREN_Pos)        /*!< 0x00020000 */
#define CORDIC_CSR_DMAREN                   CORDIC_CSR_DMAREN_Msk                   /*!< DMA Read channel Enable */
#define CORDIC_CSR_DMAWEN_Pos               (18U)
#define CORDIC_CSR_DMAWEN_Msk               (0x1UL << CORDIC_CSR_DMAWEN_Pos)        /*!< 0x00040000 */
#define CORDIC_CSR_DMAWEN                   CORDIC_CSR_DMAWEN_Msk                   /*!< DMA Write channel Enable */
#define CORDIC_CSR_NRES_Pos                 (19U)
#define CORDIC_CSR_NRES_Msk                 (0x1UL << CORDIC_CSR_NRES_Pos)          /*!< 0x00080000 */
#define CORDIC_CSR_NRES                     CORDIC_CSR_NRES_Msk                     /*!< Number of results in WDATA register */
#define CORDIC_CSR_NARGS_Pos                (20U)
#define CORDIC_CSR_NARGS_Msk                (0x1UL << CORDIC_CSR_NARGS_Pos)         /*!< 0x00100000 */
#define CORDIC_CSR_NARGS                    CORDIC_CSR_NARGS_Msk                    /*!< Number of arguments in RDATA register */
#define CORDIC_CSR_RESSIZE_Pos              (21U)
#define CORDIC_CSR_RESSIZE_Msk              (0x1UL << CORDIC_CSR_RESSIZE_Pos)       /*!< 0x00200000 */
#define CORDIC_CSR_RESSIZE                  CORDIC_CSR_RESSIZE_Msk                  /*!< Width of output data */
#define CORDIC_CSR_ARGSIZE_Pos              (22U)
#define CORDIC_CSR_ARGSIZE_Msk              (0x1UL << CORDIC_CSR_ARGSIZE_Pos)       /*!< 0x00400000 */
#define CORDIC_CSR_ARGSIZE                  CORDIC_CSR_ARGSIZE_Msk                  /*!< Width of input data */
#define CORDIC_CSR_RRDY_Pos                 (31U)
#define CORDIC_CSR_RRDY_Msk                 (0x1UL << CORDIC_CSR_RRDY_Pos)          /*!< 0x80000000 */
#define CORDIC_CSR_RRDY                     CORDIC_CSR_RRDY_Msk                     /*!< Result Ready Flag */

/*******************  Bit definition for CORDIC_WDATA register  ***************/
#define CORDIC_WDATA_ARG_Pos                (0U)
#define CORDIC_WDATA_ARG_Msk                (0xFFFFFFFFUL << CORDIC_WDATA_ARG_Pos)  /*!< 0xFFFFFFFF */
#define CORDIC_WDATA_ARG                    CORDIC_WDATA_ARG_Msk                    /*!< Input Argument */

/*******************  Bit definition for CORDIC_RDATA register  ***************/
#define CORDIC_RDATA_RES_Pos                (0U)
#define CORDIC_RDATA_RES_Msk                (0xFFFFFFFFUL << CORDIC_RDATA_RES_Pos)  /*!< 0xFFFFFFFF */
#define CORDIC_RDATA_RES                    CORDIC_RDATA_RES_Msk                    /*!< Output Result */

/******************************************************************************/
/*                                                                            */
/*                          CRC calculation unit                              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CRC_DR register  *********************/
#define CRC_DR_DR_Pos                       (0U)
#define CRC_DR_DR_Msk                       (0xFFFFFFFFUL << CRC_DR_DR_Pos)         /*!< 0xFFFFFFFF */
#define CRC_DR_DR                           CRC_DR_DR_Msk                           /*!< Data register bits */

/*******************  Bit definition for CRC_IDR register  ********************/
#define CRC_IDR_IDR_Pos                     (0U)
#define CRC_IDR_IDR_Msk                     (0xFFFFFFFFUL << CRC_IDR_IDR_Pos)       /*!< 0xFFFFFFFF */
#define CRC_IDR_IDR                         CRC_IDR_IDR_Msk                         /*!< General-purpose 32-bits data register bits */

/********************  Bit definition for CRC_CR register  ********************/
#define CRC_CR_RESET_Pos                    (0U)
#define CRC_CR_RESET_Msk                    (0x1UL << CRC_CR_RESET_Pos)             /*!< 0x00000001 */
#define CRC_CR_RESET                        CRC_CR_RESET_Msk                        /*!< RESET the CRC computation unit bit */
#define CRC_CR_POLYSIZE_Pos                 (3U)
#define CRC_CR_POLYSIZE_Msk                 (0x3UL << CRC_CR_POLYSIZE_Pos)          /*!< 0x00000018 */
#define CRC_CR_POLYSIZE                     CRC_CR_POLYSIZE_Msk                     /*!< Polynomial size bits */
#define CRC_CR_POLYSIZE_0                   (0x1UL << CRC_CR_POLYSIZE_Pos)          /*!< 0x00000008 */
#define CRC_CR_POLYSIZE_1                   (0x2UL << CRC_CR_POLYSIZE_Pos)          /*!< 0x00000010 */
#define CRC_CR_REV_IN_Pos                   (5U)
#define CRC_CR_REV_IN_Msk                   (0x3UL << CRC_CR_REV_IN_Pos)            /*!< 0x00000060 */
#define CRC_CR_REV_IN                       CRC_CR_REV_IN_Msk                       /*!< REV_IN Reverse Input Data bits */
#define CRC_CR_REV_IN_0                     (0x1UL << CRC_CR_REV_IN_Pos)            /*!< 0x00000020 */
#define CRC_CR_REV_IN_1                     (0x2UL << CRC_CR_REV_IN_Pos)            /*!< 0x00000040 */
#define CRC_CR_REV_OUT_Pos                  (7U)
#define CRC_CR_REV_OUT_Msk                  (0x1UL << CRC_CR_REV_OUT_Pos)           /*!< 0x00000080 */
#define CRC_CR_REV_OUT                      CRC_CR_REV_OUT_Msk                      /*!< REV_OUT Reverse Output Data bits */

/*******************  Bit definition for CRC_INIT register  *******************/
#define CRC_INIT_INIT_Pos                   (0U)
#define CRC_INIT_INIT_Msk                   (0xFFFFFFFFUL << CRC_INIT_INIT_Pos)     /*!< 0xFFFFFFFF */
#define CRC_INIT_INIT                       CRC_INIT_INIT_Msk                       /*!< Initial CRC value bits */

/*******************  Bit definition for CRC_POL register  ********************/
#define CRC_POL_POL_Pos                     (0U)
#define CRC_POL_POL_Msk                     (0xFFFFFFFFUL << CRC_POL_POL_Pos)       /*!< 0xFFFFFFFF */
#define CRC_POL_POL                         CRC_POL_POL_Msk                         /*!< Coefficients of the polynomial */

/******************************************************************************/
/*                                                                            */
/*                          CRS Clock Recovery System                         */
/******************************************************************************/
/*******************  Bit definition for CRS_CR register  *********************/
#define CRS_CR_SYNCOKIE_Pos                 (0U)
#define CRS_CR_SYNCOKIE_Msk                 (0x1UL << CRS_CR_SYNCOKIE_Pos)          /*!< 0x00000001 */
#define CRS_CR_SYNCOKIE                     CRS_CR_SYNCOKIE_Msk                     /*!< SYNC event OK interrupt enable */
#define CRS_CR_SYNCWARNIE_Pos               (1U)
#define CRS_CR_SYNCWARNIE_Msk               (0x1UL << CRS_CR_SYNCWARNIE_Pos)        /*!< 0x00000002 */
#define CRS_CR_SYNCWARNIE                   CRS_CR_SYNCWARNIE_Msk                   /*!< SYNC warning interrupt enable */
#define CRS_CR_ERRIE_Pos                    (2U)
#define CRS_CR_ERRIE_Msk                    (0x1UL << CRS_CR_ERRIE_Pos)             /*!< 0x00000004 */
#define CRS_CR_ERRIE                        CRS_CR_ERRIE_Msk                        /*!< SYNC error or trimming error interrupt enable */
#define CRS_CR_ESYNCIE_Pos                  (3U)
#define CRS_CR_ESYNCIE_Msk                  (0x1UL << CRS_CR_ESYNCIE_Pos)           /*!< 0x00000008 */
#define CRS_CR_ESYNCIE                      CRS_CR_ESYNCIE_Msk                      /*!< Expected SYNC interrupt enable */
#define CRS_CR_CEN_Pos                      (5U)
#define CRS_CR_CEN_Msk                      (0x1UL << CRS_CR_CEN_Pos)               /*!< 0x00000020 */
#define CRS_CR_CEN                          CRS_CR_CEN_Msk                          /*!< Frequency error counter enable */
#define CRS_CR_AUTOTRIMEN_Pos               (6U)
#define CRS_CR_AUTOTRIMEN_Msk               (0x1UL << CRS_CR_AUTOTRIMEN_Pos)        /*!< 0x00000040 */
#define CRS_CR_AUTOTRIMEN                   CRS_CR_AUTOTRIMEN_Msk                   /*!< Automatic trimming enable */
#define CRS_CR_SWSYNC_Pos                   (7U)
#define CRS_CR_SWSYNC_Msk                   (0x1UL << CRS_CR_SWSYNC_Pos)            /*!< 0x00000080 */
#define CRS_CR_SWSYNC                       CRS_CR_SWSYNC_Msk                       /*!< Generate software SYNC event */
#define CRS_CR_TRIM_Pos                     (8U)
#define CRS_CR_TRIM_Msk                     (0x3FUL << CRS_CR_TRIM_Pos)             /*!< 0x00003F00 */
#define CRS_CR_TRIM                         CRS_CR_TRIM_Msk                         /*!< HSI48 oscillator smooth trimming */

/*******************  Bit definition for CRS_CFGR register  *********************/
#define CRS_CFGR_RELOAD_Pos                 (0U)
#define CRS_CFGR_RELOAD_Msk                 (0xFFFFUL << CRS_CFGR_RELOAD_Pos)       /*!< 0x0000FFFF */
#define CRS_CFGR_RELOAD                     CRS_CFGR_RELOAD_Msk                     /*!< Counter reload value */
#define CRS_CFGR_FELIM_Pos                  (16U)
#define CRS_CFGR_FELIM_Msk                  (0xFFUL << CRS_CFGR_FELIM_Pos)          /*!< 0x00FF0000 */
#define CRS_CFGR_FELIM                      CRS_CFGR_FELIM_Msk                      /*!< Frequency error limit */
#define CRS_CFGR_SYNCDIV_Pos                (24U)
#define CRS_CFGR_SYNCDIV_Msk                (0x7UL << CRS_CFGR_SYNCDIV_Pos)         /*!< 0x07000000 */
#define CRS_CFGR_SYNCDIV                    CRS_CFGR_SYNCDIV_Msk                    /*!< SYNC divider */
#define CRS_CFGR_SYNCDIV_0                  (0x1UL << CRS_CFGR_SYNCDIV_Pos)         /*!< 0x01000000 */
#define CRS_CFGR_SYNCDIV_1                  (0x2UL << CRS_CFGR_SYNCDIV_Pos)         /*!< 0x02000000 */
#define CRS_CFGR_SYNCDIV_2                  (0x4UL << CRS_CFGR_SYNCDIV_Pos)         /*!< 0x04000000 */
#define CRS_CFGR_SYNCSRC_Pos                (28U)
#define CRS_CFGR_SYNCSRC_Msk                (0x3UL << CRS_CFGR_SYNCSRC_Pos)         /*!< 0x30000000 */
#define CRS_CFGR_SYNCSRC                    CRS_CFGR_SYNCSRC_Msk                    /*!< SYNC signal source selection */
#define CRS_CFGR_SYNCSRC_0                  (0x1UL << CRS_CFGR_SYNCSRC_Pos)         /*!< 0x10000000 */
#define CRS_CFGR_SYNCSRC_1                  (0x2UL << CRS_CFGR_SYNCSRC_Pos)         /*!< 0x20000000 */
#define CRS_CFGR_SYNCPOL_Pos                (31U)
#define CRS_CFGR_SYNCPOL_Msk                (0x1UL << CRS_CFGR_SYNCPOL_Pos)         /*!< 0x80000000 */
#define CRS_CFGR_SYNCPOL                    CRS_CFGR_SYNCPOL_Msk                    /*!< SYNC polarity selection */

/*******************  Bit definition for CRS_ISR register  *********************/
#define CRS_ISR_SYNCOKF_Pos                 (0U)
#define CRS_ISR_SYNCOKF_Msk                 (0x1UL << CRS_ISR_SYNCOKF_Pos)          /*!< 0x00000001 */
#define CRS_ISR_SYNCOKF                     CRS_ISR_SYNCOKF_Msk                     /*!< SYNC event OK flag */
#define CRS_ISR_SYNCWARNF_Pos               (1U)
#define CRS_ISR_SYNCWARNF_Msk               (0x1UL << CRS_ISR_SYNCWARNF_Pos)        /*!< 0x00000002 */
#define CRS_ISR_SYNCWARNF                   CRS_ISR_SYNCWARNF_Msk                   /*!< SYNC warning flag */
#define CRS_ISR_ERRF_Pos                    (2U)
#define CRS_ISR_ERRF_Msk                    (0x1UL << CRS_ISR_ERRF_Pos)             /*!< 0x00000004 */
#define CRS_ISR_ERRF                        CRS_ISR_ERRF_Msk                        /*!< Error flag */
#define CRS_ISR_ESYNCF_Pos                  (3U)
#define CRS_ISR_ESYNCF_Msk                  (0x1UL << CRS_ISR_ESYNCF_Pos)           /*!< 0x00000008 */
#define CRS_ISR_ESYNCF                      CRS_ISR_ESYNCF_Msk                      /*!< Expected SYNC flag */
#define CRS_ISR_SYNCERR_Pos                 (8U)
#define CRS_ISR_SYNCERR_Msk                 (0x1UL << CRS_ISR_SYNCERR_Pos)          /*!< 0x00000100 */
#define CRS_ISR_SYNCERR                     CRS_ISR_SYNCERR_Msk                     /*!< SYNC error */
#define CRS_ISR_SYNCMISS_Pos                (9U)
#define CRS_ISR_SYNCMISS_Msk                (0x1UL << CRS_ISR_SYNCMISS_Pos)         /*!< 0x00000200 */
#define CRS_ISR_SYNCMISS                    CRS_ISR_SYNCMISS_Msk                    /*!< SYNC missed */
#define CRS_ISR_TRIMOVF_Pos                 (10U)
#define CRS_ISR_TRIMOVF_Msk                 (0x1UL << CRS_ISR_TRIMOVF_Pos)          /*!< 0x00000400 */
#define CRS_ISR_TRIMOVF                     CRS_ISR_TRIMOVF_Msk                     /*!< Trimming overflow or underflow */
#define CRS_ISR_FEDIR_Pos                   (15U)
#define CRS_ISR_FEDIR_Msk                   (0x1UL << CRS_ISR_FEDIR_Pos)            /*!< 0x00008000 */
#define CRS_ISR_FEDIR                       CRS_ISR_FEDIR_Msk                       /*!< Frequency error direction */
#define CRS_ISR_FECAP_Pos                   (16U)
#define CRS_ISR_FECAP_Msk                   (0xFFFFUL << CRS_ISR_FECAP_Pos)         /*!< 0xFFFF0000 */
#define CRS_ISR_FECAP                       CRS_ISR_FECAP_Msk                       /*!< Frequency error capture */

/*******************  Bit definition for CRS_ICR register  *********************/
#define CRS_ICR_SYNCOKC_Pos                 (0U)
#define CRS_ICR_SYNCOKC_Msk                 (0x1UL << CRS_ICR_SYNCOKC_Pos)          /*!< 0x00000001 */
#define CRS_ICR_SYNCOKC                     CRS_ICR_SYNCOKC_Msk                     /*!< SYNC event OK clear flag */
#define CRS_ICR_SYNCWARNC_Pos               (1U)
#define CRS_ICR_SYNCWARNC_Msk               (0x1UL << CRS_ICR_SYNCWARNC_Pos)        /*!< 0x00000002 */
#define CRS_ICR_SYNCWARNC                   CRS_ICR_SYNCWARNC_Msk                   /*!< SYNC warning clear flag */
#define CRS_ICR_ERRC_Pos                    (2U)
#define CRS_ICR_ERRC_Msk                    (0x1UL << CRS_ICR_ERRC_Pos)             /*!< 0x00000004 */
#define CRS_ICR_ERRC                        CRS_ICR_ERRC_Msk                        /*!< Error clear flag */
#define CRS_ICR_ESYNCC_Pos                  (3U)
#define CRS_ICR_ESYNCC_Msk                  (0x1UL << CRS_ICR_ESYNCC_Pos)           /*!< 0x00000008 */
#define CRS_ICR_ESYNCC                      CRS_ICR_ESYNCC_Msk                      /*!< Expected SYNC clear flag */

/******************************************************************************/
/*                                                                            */
/*                                    RNG                                     */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for RNG_CR register  *******************/
#define RNG_CR_RNGEN_Pos                    (2U)
#define RNG_CR_RNGEN_Msk                    (0x1UL << RNG_CR_RNGEN_Pos)             /*!< 0x00000004 */
#define RNG_CR_RNGEN                        RNG_CR_RNGEN_Msk
#define RNG_CR_IE_Pos                       (3U)
#define RNG_CR_IE_Msk                       (0x1UL << RNG_CR_IE_Pos)                /*!< 0x00000008 */
#define RNG_CR_IE                           RNG_CR_IE_Msk
#define RNG_CR_CED_Pos                      (5U)
#define RNG_CR_CED_Msk                      (0x1UL << RNG_CR_CED_Pos)               /*!< 0x00000020 */
#define RNG_CR_CED                          RNG_CR_CED_Msk
#define RNG_CR_ARDIS_Pos                    (7U)
#define RNG_CR_ARDIS_Msk                    (0x1UL << RNG_CR_ARDIS_Pos)
#define RNG_CR_ARDIS                        RNG_CR_ARDIS_Msk
#define RNG_CR_RNG_CONFIG3_Pos              (8U)
#define RNG_CR_RNG_CONFIG3_Msk              (0xFUL << RNG_CR_RNG_CONFIG3_Pos)
#define RNG_CR_RNG_CONFIG3                  RNG_CR_RNG_CONFIG3_Msk
#define RNG_CR_NISTC_Pos                    (12U)
#define RNG_CR_NISTC_Msk                    (0x1UL << RNG_CR_NISTC_Pos)
#define RNG_CR_NISTC                        RNG_CR_NISTC_Msk
#define RNG_CR_RNG_CONFIG2_Pos              (13U)
#define RNG_CR_RNG_CONFIG2_Msk              (0x7UL << RNG_CR_RNG_CONFIG2_Pos)
#define RNG_CR_RNG_CONFIG2                  RNG_CR_RNG_CONFIG2_Msk
#define RNG_CR_CLKDIV_Pos                   (16U)
#define RNG_CR_CLKDIV_Msk                   (0xFUL << RNG_CR_CLKDIV_Pos)
#define RNG_CR_CLKDIV                       RNG_CR_CLKDIV_Msk
#define RNG_CR_CLKDIV_0                     (0x1UL << RNG_CR_CLKDIV_Pos)            /*!< 0x00010000 */
#define RNG_CR_CLKDIV_1                     (0x2UL << RNG_CR_CLKDIV_Pos)            /*!< 0x00020000 */
#define RNG_CR_CLKDIV_2                     (0x4UL << RNG_CR_CLKDIV_Pos)            /*!< 0x00040000 */
#define RNG_CR_CLKDIV_3                     (0x8UL << RNG_CR_CLKDIV_Pos)            /*!< 0x00080000 */
#define RNG_CR_RNG_CONFIG1_Pos              (20U)
#define RNG_CR_RNG_CONFIG1_Msk              (0x3FUL << RNG_CR_RNG_CONFIG1_Pos)
#define RNG_CR_RNG_CONFIG1                  RNG_CR_RNG_CONFIG1_Msk
#define RNG_CR_CONDRST_Pos                  (30U)
#define RNG_CR_CONDRST_Msk                  (0x1UL << RNG_CR_CONDRST_Pos)
#define RNG_CR_CONDRST                      RNG_CR_CONDRST_Msk
#define RNG_CR_CONFIGLOCK_Pos               (31U)
#define RNG_CR_CONFIGLOCK_Msk               (0x1UL << RNG_CR_CONFIGLOCK_Pos)
#define RNG_CR_CONFIGLOCK                   RNG_CR_CONFIGLOCK_Msk

/********************  Bits definition for RNG_SR register  *******************/
#define RNG_SR_DRDY_Pos                     (0U)
#define RNG_SR_DRDY_Msk                     (0x1UL << RNG_SR_DRDY_Pos)              /*!< 0x00000001 */
#define RNG_SR_DRDY                         RNG_SR_DRDY_Msk
#define RNG_SR_CECS_Pos                     (1U)
#define RNG_SR_CECS_Msk                     (0x1UL << RNG_SR_CECS_Pos)              /*!< 0x00000002 */
#define RNG_SR_CECS                         RNG_SR_CECS_Msk
#define RNG_SR_SECS_Pos                     (2U)
#define RNG_SR_SECS_Msk                     (0x1UL << RNG_SR_SECS_Pos)              /*!< 0x00000004 */
#define RNG_SR_SECS                         RNG_SR_SECS_Msk
#define RNG_SR_CEIS_Pos                     (5U)
#define RNG_SR_CEIS_Msk                     (0x1UL << RNG_SR_CEIS_Pos)              /*!< 0x00000020 */
#define RNG_SR_CEIS                         RNG_SR_CEIS_Msk
#define RNG_SR_SEIS_Pos                     (6U)
#define RNG_SR_SEIS_Msk                     (0x1UL << RNG_SR_SEIS_Pos)              /*!< 0x00000040 */
#define RNG_SR_SEIS                         RNG_SR_SEIS_Msk

/********************  Bits definition for RNG_HTCR register  *******************/
#define RNG_HTCR_HTCFG_Pos                  (0U)
#define RNG_HTCR_HTCFG_Msk                  (0xFFFFFFFFUL << RNG_HTCR_HTCFG_Pos)    /*!< 0xFFFFFFFF */
#define RNG_HTCR_HTCFG                      RNG_HTCR_HTCFG_Msk

/******************************************************************************/
/*                                                                            */
/*                      Digital to Analog Converter                           */
/*                                                                            */
/******************************************************************************/
#define DAC_CHANNEL2_SUPPORT                                                        /*!< DAC feature available only on specific devices: DAC channel 2 available */

/********************  Bit definition for DAC_CR register  ********************/
#define DAC_CR_EN1_Pos                      (0U)
#define DAC_CR_EN1_Msk                      (0x1UL << DAC_CR_EN1_Pos)               /*!< 0x00000001 */
#define DAC_CR_EN1                          DAC_CR_EN1_Msk                          /*!<DAC channel1 enable */
#define DAC_CR_TEN1_Pos                     (1U)
#define DAC_CR_TEN1_Msk                     (0x1UL << DAC_CR_TEN1_Pos)              /*!< 0x00000002 */
#define DAC_CR_TEN1                         DAC_CR_TEN1_Msk                         /*!<DAC channel1 Trigger enable */
#define DAC_CR_TSEL1_Pos                    (2U)
#define DAC_CR_TSEL1_Msk                    (0xFUL << DAC_CR_TSEL1_Pos)             /*!< 0x0000003C */
#define DAC_CR_TSEL1                        DAC_CR_TSEL1_Msk                        /*!<TSEL1[3:0] (DAC channel1 Trigger selection) */
#define DAC_CR_TSEL1_0                      (0x1UL << DAC_CR_TSEL1_Pos)             /*!< 0x00000004 */
#define DAC_CR_TSEL1_1                      (0x2UL << DAC_CR_TSEL1_Pos)             /*!< 0x00000008 */
#define DAC_CR_TSEL1_2                      (0x4UL << DAC_CR_TSEL1_Pos)             /*!< 0x00000010 */
#define DAC_CR_TSEL1_3                      (0x8UL << DAC_CR_TSEL1_Pos)             /*!< 0x00000020 */
#define DAC_CR_WAVE1_Pos                    (6U)
#define DAC_CR_WAVE1_Msk                    (0x3UL << DAC_CR_WAVE1_Pos)             /*!< 0x000000C0 */
#define DAC_CR_WAVE1                        DAC_CR_WAVE1_Msk                        /*!<WAVE1[1:0] (DAC channel1 noise/triangle wave generation enable) */
#define DAC_CR_WAVE1_0                      (0x1UL << DAC_CR_WAVE1_Pos)             /*!< 0x00000040 */
#define DAC_CR_WAVE1_1                      (0x2UL << DAC_CR_WAVE1_Pos)             /*!< 0x00000080 */
#define DAC_CR_MAMP1_Pos                    (8U)
#define DAC_CR_MAMP1_Msk                    (0xFUL << DAC_CR_MAMP1_Pos)             /*!< 0x00000F00 */
#define DAC_CR_MAMP1                        DAC_CR_MAMP1_Msk                        /*!<MAMP1[3:0] (DAC channel1 Mask/Amplitude selector) */
#define DAC_CR_MAMP1_0                      (0x1UL << DAC_CR_MAMP1_Pos)             /*!< 0x00000100 */
#define DAC_CR_MAMP1_1                      (0x2UL << DAC_CR_MAMP1_Pos)             /*!< 0x00000200 */
#define DAC_CR_MAMP1_2                      (0x4UL << DAC_CR_MAMP1_Pos)             /*!< 0x00000400 */
#define DAC_CR_MAMP1_3                      (0x8UL << DAC_CR_MAMP1_Pos)             /*!< 0x00000800 */
#define DAC_CR_DMAEN1_Pos                   (12U)
#define DAC_CR_DMAEN1_Msk                   (0x1UL << DAC_CR_DMAEN1_Pos)            /*!< 0x00001000 */
#define DAC_CR_DMAEN1                       DAC_CR_DMAEN1_Msk                       /*!<DAC channel1 DMA enable */
#define DAC_CR_DMAUDRIE1_Pos                (13U)
#define DAC_CR_DMAUDRIE1_Msk                (0x1UL << DAC_CR_DMAUDRIE1_Pos)         /*!< 0x00002000 */
#define DAC_CR_DMAUDRIE1                    DAC_CR_DMAUDRIE1_Msk                    /*!<DAC channel 1 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN1_Pos                     (14U)
#define DAC_CR_CEN1_Msk                     (0x1UL << DAC_CR_CEN1_Pos)              /*!< 0x00004000 */
#define DAC_CR_CEN1                         DAC_CR_CEN1_Msk                         /*!<DAC channel 1 calibration enable >*/
#define DAC_CR_EN2_Pos                      (16U)
#define DAC_CR_EN2_Msk                      (0x1UL << DAC_CR_EN2_Pos)               /*!< 0x00010000 */
#define DAC_CR_EN2                          DAC_CR_EN2_Msk                          /*!<DAC channel2 enable */
#define DAC_CR_TEN2_Pos                     (17U)
#define DAC_CR_TEN2_Msk                     (0x1UL << DAC_CR_TEN2_Pos)              /*!< 0x00020000 */
#define DAC_CR_TEN2                         DAC_CR_TEN2_Msk                         /*!<DAC channel2 Trigger enable */
#define DAC_CR_TSEL2_Pos                    (18U)
#define DAC_CR_TSEL2_Msk                    (0xFUL << DAC_CR_TSEL2_Pos)             /*!< 0x003C0000 */
#define DAC_CR_TSEL2                        DAC_CR_TSEL2_Msk                        /*!<TSEL2[3:0] (DAC channel2 Trigger selection) */
#define DAC_CR_TSEL2_0                      (0x1UL << DAC_CR_TSEL2_Pos)             /*!< 0x00040000 */
#define DAC_CR_TSEL2_1                      (0x2UL << DAC_CR_TSEL2_Pos)             /*!< 0x00080000 */
#define DAC_CR_TSEL2_2                      (0x4UL << DAC_CR_TSEL2_Pos)             /*!< 0x00100000 */
#define DAC_CR_TSEL2_3                      (0x8UL << DAC_CR_TSEL2_Pos)             /*!< 0x00200000 */
#define DAC_CR_WAVE2_Pos                    (22U)
#define DAC_CR_WAVE2_Msk                    (0x3UL << DAC_CR_WAVE2_Pos)             /*!< 0x00C00000 */
#define DAC_CR_WAVE2                        DAC_CR_WAVE2_Msk                        /*!<WAVE2[1:0] (DAC channel2 noise/triangle wave generation enable) */
#define DAC_CR_WAVE2_0                      (0x1UL << DAC_CR_WAVE2_Pos)             /*!< 0x00400000 */
#define DAC_CR_WAVE2_1                      (0x2UL << DAC_CR_WAVE2_Pos)             /*!< 0x00800000 */
#define DAC_CR_MAMP2_Pos                    (24U)
#define DAC_CR_MAMP2_Msk                    (0xFUL << DAC_CR_MAMP2_Pos)             /*!< 0x0F000000 */
#define DAC_CR_MAMP2                        DAC_CR_MAMP2_Msk                        /*!<MAMP2[3:0] (DAC channel2 Mask/Amplitude selector) */
#define DAC_CR_MAMP2_0                      (0x1UL << DAC_CR_MAMP2_Pos)             /*!< 0x01000000 */
#define DAC_CR_MAMP2_1                      (0x2UL << DAC_CR_MAMP2_Pos)             /*!< 0x02000000 */
#define DAC_CR_MAMP2_2                      (0x4UL << DAC_CR_MAMP2_Pos)             /*!< 0x04000000 */
#define DAC_CR_MAMP2_3                      (0x8UL << DAC_CR_MAMP2_Pos)             /*!< 0x08000000 */
#define DAC_CR_DMAEN2_Pos                   (28U)
#define DAC_CR_DMAEN2_Msk                   (0x1UL << DAC_CR_DMAEN2_Pos)            /*!< 0x10000000 */
#define DAC_CR_DMAEN2                       DAC_CR_DMAEN2_Msk                       /*!<DAC channel2 DMA enabled */
#define DAC_CR_DMAUDRIE2_Pos                (29U)
#define DAC_CR_DMAUDRIE2_Msk                (0x1UL << DAC_CR_DMAUDRIE2_Pos)         /*!< 0x20000000 */
#define DAC_CR_DMAUDRIE2                    DAC_CR_DMAUDRIE2_Msk                    /*!<DAC channel2 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN2_Pos                     (30U)
#define DAC_CR_CEN2_Msk                     (0x1UL << DAC_CR_CEN2_Pos)              /*!< 0x40000000 */
#define DAC_CR_CEN2                         DAC_CR_CEN2_Msk                         /*!<DAC channel2 calibration enable >*/

/*****************  Bit definition for DAC_SWTRIGR register  ******************/
#define DAC_SWTRIGR_SWTRIG1_Pos             (0U)
#define DAC_SWTRIGR_SWTRIG1_Msk             (0x1UL << DAC_SWTRIGR_SWTRIG1_Pos)      /*!< 0x00000001 */
#define DAC_SWTRIGR_SWTRIG1                 DAC_SWTRIGR_SWTRIG1_Msk                 /*!<DAC channel1 software trigger */
#define DAC_SWTRIGR_SWTRIG2_Pos             (1U)
#define DAC_SWTRIGR_SWTRIG2_Msk             (0x1UL << DAC_SWTRIGR_SWTRIG2_Pos)      /*!< 0x00000002 */
#define DAC_SWTRIGR_SWTRIG2                 DAC_SWTRIGR_SWTRIG2_Msk                 /*!<DAC channel2 software trigger */
#define DAC_SWTRIGR_SWTRIGB1_Pos            (16U)
#define DAC_SWTRIGR_SWTRIGB1_Msk            (0x1UL << DAC_SWTRIGR_SWTRIGB1_Pos)     /*!< 0x00010000 */
#define DAC_SWTRIGR_SWTRIGB1                DAC_SWTRIGR_SWTRIGB1_Msk                /*!<DAC channel1 software trigger B */
#define DAC_SWTRIGR_SWTRIGB2_Pos            (17U)
#define DAC_SWTRIGR_SWTRIGB2_Msk            (0x1UL << DAC_SWTRIGR_SWTRIGB2_Pos)     /*!< 0x00020000 */
#define DAC_SWTRIGR_SWTRIGB2                DAC_SWTRIGR_SWTRIGB2_Msk                /*!<DAC channel2 software trigger B */

/*****************  Bit definition for DAC_DHR12R1 register  ******************/
#define DAC_DHR12R1_DACC1DHR_Pos            (0U)
#define DAC_DHR12R1_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12R1_DACC1DHR_Pos)   /*!< 0x00000FFF */
#define DAC_DHR12R1_DACC1DHR                DAC_DHR12R1_DACC1DHR_Msk                /*!<DAC channel1 12-bit Right aligned data */
#define DAC_DHR12R1_DACC1DHRB_Pos           (16U)
#define DAC_DHR12R1_DACC1DHRB_Msk           (0xFFFUL << DAC_DHR12R1_DACC1DHRB_Pos)  /*!< 0x0FFF0000 */
#define DAC_DHR12R1_DACC1DHRB               DAC_DHR12R1_DACC1DHRB_Msk               /*!<DAC channel1 12-bit Right-aligned data B */

/*****************  Bit definition for DAC_DHR12L1 register  ******************/
#define DAC_DHR12L1_DACC1DHR_Pos            (4U)
#define DAC_DHR12L1_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12L1_DACC1DHR_Pos)   /*!< 0x0000FFF0 */
#define DAC_DHR12L1_DACC1DHR                DAC_DHR12L1_DACC1DHR_Msk                /*!<DAC channel1 12-bit Left aligned data */
#define DAC_DHR12L1_DACC1DHRB_Pos           (20U)
#define DAC_DHR12L1_DACC1DHRB_Msk           (0xFFFUL << DAC_DHR12L1_DACC1DHRB_Pos)  /*!< 0xFFF00000 */
#define DAC_DHR12L1_DACC1DHRB               DAC_DHR12L1_DACC1DHRB_Msk               /*!<DAC channel1 12-bit Left aligned data B */

/******************  Bit definition for DAC_DHR8R1 register  ******************/
#define DAC_DHR8R1_DACC1DHR_Pos             (0U)
#define DAC_DHR8R1_DACC1DHR_Msk             (0xFFUL << DAC_DHR8R1_DACC1DHR_Pos)     /*!< 0x000000FF */
#define DAC_DHR8R1_DACC1DHR                 DAC_DHR8R1_DACC1DHR_Msk                 /*!<DAC channel1 8-bit Right aligned data */
#define DAC_DHR8R1_DACC1DHRB_Pos            (8U)
#define DAC_DHR8R1_DACC1DHRB_Msk            (0xFFUL << DAC_DHR8R1_DACC1DHRB_Pos)    /*!< 0x0000FF00 */
#define DAC_DHR8R1_DACC1DHRB                DAC_DHR8R1_DACC1DHRB_Msk                /*!<DAC channel1 8-bit Right aligned data B */

/*****************  Bit definition for DAC_DHR12R2 register  ******************/
#define DAC_DHR12R2_DACC2DHR_Pos            (0U)
#define DAC_DHR12R2_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12R2_DACC2DHR_Pos)   /*!< 0x00000FFF */
#define DAC_DHR12R2_DACC2DHR                DAC_DHR12R2_DACC2DHR_Msk                /*!<DAC channel2 12-bit Right aligned data */
#define DAC_DHR12R2_DACC2DHRB_Pos           (16U)
#define DAC_DHR12R2_DACC2DHRB_Msk           (0xFFFUL << DAC_DHR12R2_DACC2DHRB_Pos)  /*!< 0x0FFF0000 */
#define DAC_DHR12R2_DACC2DHRB               DAC_DHR12R2_DACC2DHRB_Msk               /*!<DAC channel2 12-bit Right-aligned data B */

/*****************  Bit definition for DAC_DHR12L2 register  ******************/
#define DAC_DHR12L2_DACC2DHR_Pos            (4U)
#define DAC_DHR12L2_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12L2_DACC2DHR_Pos)   /*!< 0x0000FFF0 */
#define DAC_DHR12L2_DACC2DHR                DAC_DHR12L2_DACC2DHR_Msk                /*!<DAC channel2 12-bit Left aligned data */
#define DAC_DHR12L2_DACC2DHRB_Pos           (20U)
#define DAC_DHR12L2_DACC2DHRB_Msk           (0xFFFUL << DAC_DHR12L2_DACC2DHRB_Pos)  /*!< 0xFFF00000 */
#define DAC_DHR12L2_DACC2DHRB               DAC_DHR12L2_DACC2DHRB_Msk               /*!<DAC channel2 12-bit Left aligned data B */

/******************  Bit definition for DAC_DHR8R2 register  ******************/
#define DAC_DHR8R2_DACC2DHR_Pos             (0U)
#define DAC_DHR8R2_DACC2DHR_Msk             (0xFFUL << DAC_DHR8R2_DACC2DHR_Pos)     /*!< 0x000000FF */
#define DAC_DHR8R2_DACC2DHR                 DAC_DHR8R2_DACC2DHR_Msk                 /*!<DAC channel2 8-bit Right aligned data */
#define DAC_DHR8R2_DACC2DHRB_Pos            (8U)
#define DAC_DHR8R2_DACC2DHRB_Msk            (0xFFUL << DAC_DHR8R2_DACC2DHRB_Pos)    /*!< 0x0000FF00 */
#define DAC_DHR8R2_DACC2DHRB                DAC_DHR8R2_DACC2DHRB_Msk                /*!<DAC channel2 8-bit Right aligned data B */

/*****************  Bit definition for DAC_DHR12RD register  ******************/
#define DAC_DHR12RD_DACC1DHR_Pos            (0U)
#define DAC_DHR12RD_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12RD_DACC1DHR_Pos)   /*!< 0x00000FFF */
#define DAC_DHR12RD_DACC1DHR                DAC_DHR12RD_DACC1DHR_Msk                /*!<DAC channel1 12-bit Right aligned data */
#define DAC_DHR12RD_DACC2DHR_Pos            (16U)
#define DAC_DHR12RD_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12RD_DACC2DHR_Pos)   /*!< 0x0FFF0000 */
#define DAC_DHR12RD_DACC2DHR                DAC_DHR12RD_DACC2DHR_Msk                /*!<DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12LD register  ******************/
#define DAC_DHR12LD_DACC1DHR_Pos            (4U)
#define DAC_DHR12LD_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12LD_DACC1DHR_Pos)   /*!< 0x0000FFF0 */
#define DAC_DHR12LD_DACC1DHR                DAC_DHR12LD_DACC1DHR_Msk                /*!<DAC channel1 12-bit Left aligned data */
#define DAC_DHR12LD_DACC2DHR_Pos            (20U)
#define DAC_DHR12LD_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12LD_DACC2DHR_Pos)   /*!< 0xFFF00000 */
#define DAC_DHR12LD_DACC2DHR                DAC_DHR12LD_DACC2DHR_Msk                /*!<DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8RD register  ******************/
#define DAC_DHR8RD_DACC1DHR_Pos             (0U)
#define DAC_DHR8RD_DACC1DHR_Msk             (0xFFUL << DAC_DHR8RD_DACC1DHR_Pos)     /*!< 0x000000FF */
#define DAC_DHR8RD_DACC1DHR                 DAC_DHR8RD_DACC1DHR_Msk                 /*!<DAC channel1 8-bit Right aligned data */
#define DAC_DHR8RD_DACC2DHR_Pos             (8U)
#define DAC_DHR8RD_DACC2DHR_Msk             (0xFFUL << DAC_DHR8RD_DACC2DHR_Pos)     /*!< 0x0000FF00 */
#define DAC_DHR8RD_DACC2DHR                 DAC_DHR8RD_DACC2DHR_Msk                 /*!<DAC channel2 8-bit Right aligned data */

/*******************  Bit definition for DAC_DOR1 register  *******************/
#define DAC_DOR1_DACC1DOR_Pos               (0U)
#define DAC_DOR1_DACC1DOR_Msk               (0xFFFUL << DAC_DOR1_DACC1DOR_Pos)      /*!< 0x00000FFF */
#define DAC_DOR1_DACC1DOR                   DAC_DOR1_DACC1DOR_Msk                   /*!<DAC channel1 data output */
#define DAC_DOR1_DACC1DORB_Pos              (16U)
#define DAC_DOR1_DACC1DORB_Msk              (0xFFFUL << DAC_DOR1_DACC1DORB_Pos)     /*!< 0x0FFF0000 */
#define DAC_DOR1_DACC1DORB                  DAC_DOR1_DACC1DORB_Msk                  /*!<DAC channel1 data output B */

/*******************  Bit definition for DAC_DOR2 register  *******************/
#define DAC_DOR2_DACC2DOR_Pos               (0U)
#define DAC_DOR2_DACC2DOR_Msk               (0xFFFUL << DAC_DOR2_DACC2DOR_Pos)      /*!< 0x00000FFF */
#define DAC_DOR2_DACC2DOR                   DAC_DOR2_DACC2DOR_Msk                   /*!<DAC channel2 data output */
#define DAC_DOR2_DACC2DORB_Pos              (16U)
#define DAC_DOR2_DACC2DORB_Msk              (0xFFFUL << DAC_DOR2_DACC2DORB_Pos)     /*!< 0x0FFF0000 */
#define DAC_DOR2_DACC2DORB                  DAC_DOR2_DACC2DORB_Msk                  /*!<DAC channel2 data output B */

/********************  Bit definition for DAC_SR register  ********************/
#define DAC_SR_DAC1RDY_Pos                  (11U)
#define DAC_SR_DAC1RDY_Msk                  (0x1UL << DAC_SR_DAC1RDY_Pos)           /*!< 0x00000800 */
#define DAC_SR_DAC1RDY                      DAC_SR_DAC1RDY_Msk                      /*!<DAC channel 1 ready status bit */
#define DAC_SR_DORSTAT1_Pos                 (12U)
#define DAC_SR_DORSTAT1_Msk                 (0x1UL << DAC_SR_DORSTAT1_Pos)          /*!< 0x00001000 */
#define DAC_SR_DORSTAT1                     DAC_SR_DORSTAT1_Msk                     /*!<DAC channel 1 output register status bit */
#define DAC_SR_DMAUDR1_Pos                  (13U)
#define DAC_SR_DMAUDR1_Msk                  (0x1UL << DAC_SR_DMAUDR1_Pos)           /*!< 0x00002000 */
#define DAC_SR_DMAUDR1                      DAC_SR_DMAUDR1_Msk                      /*!<DAC channel1 DMA underrun flag */
#define DAC_SR_CAL_FLAG1_Pos                (14U)
#define DAC_SR_CAL_FLAG1_Msk                (0x1UL << DAC_SR_CAL_FLAG1_Pos)         /*!< 0x00004000 */
#define DAC_SR_CAL_FLAG1                    DAC_SR_CAL_FLAG1_Msk                    /*!<DAC channel1 calibration offset status */
#define DAC_SR_BWST1_Pos                    (15U)
#define DAC_SR_BWST1_Msk                    (0x1UL << DAC_SR_BWST1_Pos)             /*!< 0x00008000 */
#define DAC_SR_BWST1                        DAC_SR_BWST1_Msk                        /*!<DAC channel1 busy writing sample time flag */

#define DAC_SR_DAC2RDY_Pos                  (27U)
#define DAC_SR_DAC2RDY_Msk                  (0x1UL << DAC_SR_DAC2RDY_Pos)           /*!< 0x08000000 */
#define DAC_SR_DAC2RDY                      DAC_SR_DAC2RDY_Msk                      /*!<DAC channel 2 ready status bit */
#define DAC_SR_DORSTAT2_Pos                 (28U)
#define DAC_SR_DORSTAT2_Msk                 (0x1UL << DAC_SR_DORSTAT2_Pos)          /*!< 0x10000000 */
#define DAC_SR_DORSTAT2                     DAC_SR_DORSTAT2_Msk                     /*!<DAC channel 2 output register status bit */
#define DAC_SR_DMAUDR2_Pos                  (29U)
#define DAC_SR_DMAUDR2_Msk                  (0x1UL << DAC_SR_DMAUDR2_Pos)           /*!< 0x20000000 */
#define DAC_SR_DMAUDR2                      DAC_SR_DMAUDR2_Msk                      /*!<DAC channel2 DMA underrun flag */
#define DAC_SR_CAL_FLAG2_Pos                (30U)
#define DAC_SR_CAL_FLAG2_Msk                (0x1UL << DAC_SR_CAL_FLAG2_Pos)         /*!< 0x40000000 */
#define DAC_SR_CAL_FLAG2                    DAC_SR_CAL_FLAG2_Msk                    /*!<DAC channel2 calibration offset status */
#define DAC_SR_BWST2_Pos                    (31U)
#define DAC_SR_BWST2_Msk                    (0x1UL << DAC_SR_BWST2_Pos)             /*!< 0x80000000 */
#define DAC_SR_BWST2                        DAC_SR_BWST2_Msk                        /*!<DAC channel2 busy writing sample time flag */

/*******************  Bit definition for DAC_CCR register  ********************/
#define DAC_CCR_OTRIM1_Pos                  (0U)
#define DAC_CCR_OTRIM1_Msk                  (0x1FUL << DAC_CCR_OTRIM1_Pos)          /*!< 0x0000001F */
#define DAC_CCR_OTRIM1                      DAC_CCR_OTRIM1_Msk                      /*!<DAC channel1 offset trimming value */
#define DAC_CCR_OTRIM2_Pos                  (16U)
#define DAC_CCR_OTRIM2_Msk                  (0x1FUL << DAC_CCR_OTRIM2_Pos)          /*!< 0x001F0000 */
#define DAC_CCR_OTRIM2                      DAC_CCR_OTRIM2_Msk                      /*!<DAC channel2 offset trimming value */

/*******************  Bit definition for DAC_MCR register  *******************/
#define DAC_MCR_MODE1_Pos                   (0U)
#define DAC_MCR_MODE1_Msk                   (0x7UL << DAC_MCR_MODE1_Pos)            /*!< 0x00000007 */
#define DAC_MCR_MODE1                       DAC_MCR_MODE1_Msk                       /*!<MODE1[2:0] (DAC channel1 mode) */
#define DAC_MCR_MODE1_0                     (0x1UL << DAC_MCR_MODE1_Pos)            /*!< 0x00000001 */
#define DAC_MCR_MODE1_1                     (0x2UL << DAC_MCR_MODE1_Pos)            /*!< 0x00000002 */
#define DAC_MCR_MODE1_2                     (0x4UL << DAC_MCR_MODE1_Pos)            /*!< 0x00000004 */
#define DAC_MCR_DMADOUBLE1_Pos              (8U)
#define DAC_MCR_DMADOUBLE1_Msk              (0x1UL << DAC_MCR_DMADOUBLE1_Pos)       /*!< 0x00000100 */
#define DAC_MCR_DMADOUBLE1                  DAC_MCR_DMADOUBLE1_Msk                  /*!<DAC Channel 1 DMA double data mode */
#define DAC_MCR_SINFORMAT1_Pos              (9U)
#define DAC_MCR_SINFORMAT1_Msk              (0x1UL << DAC_MCR_SINFORMAT1_Pos)       /*!< 0x00000200 */
#define DAC_MCR_SINFORMAT1                  DAC_MCR_SINFORMAT1_Msk                  /*!<DAC Channel 1 enable signed format */
#define DAC_MCR_HFSEL_Pos                   (14U)
#define DAC_MCR_HFSEL_Msk                   (0x3UL << DAC_MCR_HFSEL_Pos)            /*!< 0x0000C000 */
#define DAC_MCR_HFSEL                       DAC_MCR_HFSEL_Msk                       /*!<HFSEL[1:0] (High Frequency interface mode selection) */
#define DAC_MCR_HFSEL_0                     (0x1UL << DAC_MCR_HFSEL_Pos)            /*!< 0x00004000 */
#define DAC_MCR_HFSEL_1                     (0x2UL << DAC_MCR_HFSEL_Pos)            /*!< 0x00008000 */
#define DAC_MCR_MODE2_Pos                   (16U)
#define DAC_MCR_MODE2_Msk                   (0x7UL << DAC_MCR_MODE2_Pos)            /*!< 0x00070000 */
#define DAC_MCR_MODE2                       DAC_MCR_MODE2_Msk                       /*!<MODE2[2:0] (DAC channel2 mode) */
#define DAC_MCR_MODE2_0                     (0x1UL << DAC_MCR_MODE2_Pos)            /*!< 0x00010000 */
#define DAC_MCR_MODE2_1                     (0x2UL << DAC_MCR_MODE2_Pos)            /*!< 0x00020000 */
#define DAC_MCR_MODE2_2                     (0x4UL << DAC_MCR_MODE2_Pos)            /*!< 0x00040000 */
#define DAC_MCR_DMADOUBLE2_Pos              (24U)
#define DAC_MCR_DMADOUBLE2_Msk              (0x1UL << DAC_MCR_DMADOUBLE2_Pos)       /*!< 0x01000000 */
#define DAC_MCR_DMADOUBLE2                  DAC_MCR_DMADOUBLE2_Msk                  /*!<DAC Channel 2 DMA double data mode */
#define DAC_MCR_SINFORMAT2_Pos              (25U)
#define DAC_MCR_SINFORMAT2_Msk              (0x1UL << DAC_MCR_SINFORMAT2_Pos)       /*!< 0x02000000 */
#define DAC_MCR_SINFORMAT2                  DAC_MCR_SINFORMAT2_Msk                  /*!<DAC Channel 2 enable signed format */

/******************  Bit definition for DAC_SHSR1 register  ******************/
#define DAC_SHSR1_TSAMPLE1_Pos              (0U)
#define DAC_SHSR1_TSAMPLE1_Msk              (0x3FFUL << DAC_SHSR1_TSAMPLE1_Pos)     /*!< 0x000003FF */
#define DAC_SHSR1_TSAMPLE1                  DAC_SHSR1_TSAMPLE1_Msk                  /*!<DAC channel1 sample time */

/******************  Bit definition for DAC_SHSR2 register  ******************/
#define DAC_SHSR2_TSAMPLE2_Pos              (0U)
#define DAC_SHSR2_TSAMPLE2_Msk              (0x3FFUL << DAC_SHSR2_TSAMPLE2_Pos)     /*!< 0x000003FF */
#define DAC_SHSR2_TSAMPLE2                  DAC_SHSR2_TSAMPLE2_Msk                  /*!<DAC channel2 sample time */

/******************  Bit definition for DAC_SHHR register  ******************/
#define DAC_SHHR_THOLD1_Pos                 (0U)
#define DAC_SHHR_THOLD1_Msk                 (0x3FFUL << DAC_SHHR_THOLD1_Pos)        /*!< 0x000003FF */
#define DAC_SHHR_THOLD1                     DAC_SHHR_THOLD1_Msk                     /*!<DAC channel1 hold time */
#define DAC_SHHR_THOLD2_Pos                 (16U)
#define DAC_SHHR_THOLD2_Msk                 (0x3FFUL << DAC_SHHR_THOLD2_Pos)        /*!< 0x03FF0000 */
#define DAC_SHHR_THOLD2                     DAC_SHHR_THOLD2_Msk                     /*!<DAC channel2 hold time */

/******************  Bit definition for DAC_SHRR register  ******************/
#define DAC_SHRR_TREFRESH1_Pos              (0U)
#define DAC_SHRR_TREFRESH1_Msk              (0xFFUL << DAC_SHRR_TREFRESH1_Pos)      /*!< 0x000000FF */
#define DAC_SHRR_TREFRESH1                  DAC_SHRR_TREFRESH1_Msk                  /*!<DAC channel1 refresh time */
#define DAC_SHRR_TREFRESH2_Pos              (16U)
#define DAC_SHRR_TREFRESH2_Msk              (0xFFUL << DAC_SHRR_TREFRESH2_Pos)      /*!< 0x00FF0000 */
#define DAC_SHRR_TREFRESH2                  DAC_SHRR_TREFRESH2_Msk                  /*!<DAC channel2 refresh time */

/******************  Bit definition for DAC_AUTOCR register  ******************/
#define DAC_AUTOCR_AUTOMODE_Pos             (22U)
#define DAC_AUTOCR_AUTOMODE_Msk             (0x1UL << DAC_AUTOCR_AUTOMODE_Pos)      /*!< 0x00400000 */
#define DAC_AUTOCR_AUTOMODE                 DAC_AUTOCR_AUTOMODE_Msk                 /*!< AUTOCR Enable */

/******************************************************************************/
/*                                                                            */
/*                       Advanced Encryption Standard (AES)                   */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for AES_CR register  *********************/
#define AES_CR_EN_Pos                       (0U)
#define AES_CR_EN_Msk                       (0x1UL << AES_CR_EN_Pos)                /*!< 0x00000001 */
#define AES_CR_EN                           AES_CR_EN_Msk                           /*!< AES Enable */
#define AES_CR_DATATYPE_Pos                 (1U)
#define AES_CR_DATATYPE_Msk                 (0x3UL << AES_CR_DATATYPE_Pos)          /*!< 0x00000006 */
#define AES_CR_DATATYPE                     AES_CR_DATATYPE_Msk                     /*!< Data type selection */
#define AES_CR_DATATYPE_0                   (0x1UL << AES_CR_DATATYPE_Pos)          /*!< 0x00000002 */
#define AES_CR_DATATYPE_1                   (0x2UL << AES_CR_DATATYPE_Pos)          /*!< 0x00000004 */
#define AES_CR_MODE_Pos                     (3U)
#define AES_CR_MODE_Msk                     (0x3UL << AES_CR_MODE_Pos)              /*!< 0x00000018 */
#define AES_CR_MODE                         AES_CR_MODE_Msk                         /*!< AES Mode Of Operation */
#define AES_CR_MODE_0                       (0x1UL << AES_CR_MODE_Pos)              /*!< 0x00000008 */
#define AES_CR_MODE_1                       (0x2UL << AES_CR_MODE_Pos)              /*!< 0x00000010 */
#define AES_CR_CHMOD_Pos                    (5U)
#define AES_CR_CHMOD_Msk                    (0x803UL << AES_CR_CHMOD_Pos)           /*!< 0x00010060 */
#define AES_CR_CHMOD                        AES_CR_CHMOD_Msk                        /*!< AES Chaining Mode */
#define AES_CR_CHMOD_0                      (0x001UL << AES_CR_CHMOD_Pos)           /*!< 0x00000020 */
#define AES_CR_CHMOD_1                      (0x002UL << AES_CR_CHMOD_Pos)           /*!< 0x00000040 */
#define AES_CR_CHMOD_2                      (0x800UL << AES_CR_CHMOD_Pos)           /*!< 0x00010000 */
#define AES_CR_DMAINEN_Pos                  (11U)
#define AES_CR_DMAINEN_Msk                  (0x1UL << AES_CR_DMAINEN_Pos)           /*!< 0x00000800 */
#define AES_CR_DMAINEN                      AES_CR_DMAINEN_Msk                      /*!< Enable data input phase DMA management  */
#define AES_CR_DMAOUTEN_Pos                 (12U)
#define AES_CR_DMAOUTEN_Msk                 (0x1UL << AES_CR_DMAOUTEN_Pos)          /*!< 0x00001000 */
#define AES_CR_DMAOUTEN                     AES_CR_DMAOUTEN_Msk                     /*!< Enable data output phase DMA management */
#define AES_CR_GCMPH_Pos                    (13U)
#define AES_CR_GCMPH_Msk                    (0x3UL << AES_CR_GCMPH_Pos)             /*!< 0x00006000 */
#define AES_CR_GCMPH                        AES_CR_GCMPH_Msk                        /*!< GCM Phase */
#define AES_CR_GCMPH_0                      (0x1UL << AES_CR_GCMPH_Pos)             /*!< 0x00002000 */
#define AES_CR_GCMPH_1                      (0x2UL << AES_CR_GCMPH_Pos)             /*!< 0x00004000 */
#define AES_CR_KEYSIZE_Pos                  (18U)
#define AES_CR_KEYSIZE_Msk                  (0x1UL << AES_CR_KEYSIZE_Pos)           /*!< 0x00040000 */
#define AES_CR_KEYSIZE                      AES_CR_KEYSIZE_Msk                      /*!< Key size selection */
#define AES_CR_KEYPROT_Pos                 (19U)
#define AES_CR_KEYPROT_Msk                 (0x1UL << AES_CR_KEYPROT_Pos)          /*!< 0x00040000 */
#define AES_CR_KEYPROT                     AES_CR_KEYPROT_Msk                     /*!<  Key protection */
#define AES_CR_NPBLB_Pos                    (20U)
#define AES_CR_NPBLB_Msk                    (0xFUL << AES_CR_NPBLB_Pos)             /*!< 0x00F00000 */
#define AES_CR_NPBLB                        AES_CR_NPBLB_Msk                        /*!< Number of padding bytes in payload last block */
#define AES_CR_NPBLB_0                      (0x1UL << AES_CR_NPBLB_Pos)             /*!< 0x00100000 */
#define AES_CR_NPBLB_1                      (0x2UL << AES_CR_NPBLB_Pos)             /*!< 0x00200000 */
#define AES_CR_NPBLB_2                      (0x4UL << AES_CR_NPBLB_Pos)             /*!< 0x00400000 */
#define AES_CR_NPBLB_3                      (0x8UL << AES_CR_NPBLB_Pos)             /*!< 0x00800000 */
#define AES_CR_KMOD_Pos                     (24U)
#define AES_CR_KMOD_Msk                     (0x3UL << AES_CR_KMOD_Pos)              /*!< 0x00000006 */
#define AES_CR_KMOD                         AES_CR_KMOD_Msk                         /*!< Key mode selection */
#define AES_CR_KMOD_0                       (0x1UL << AES_CR_KMOD_Pos)             /*!< 0x01000000 */
#define AES_CR_KMOD_1                       (0x2UL << AES_CR_KMOD_Pos)              /*!< 0x02000000 */
#define AES_CR_KSHAREID_Pos                (26U)
#define AES_CR_KSHAREID_Msk                (0x3UL << AES_CR_KSHAREID_Pos)         /*!< 0x00000006 */
#define AES_CR_KSHAREID                    AES_CR_KSHAREID_Msk                    /*!< Key Shared ID */
#define AES_CR_KEYSEL_Pos                  (28U)
#define AES_CR_KEYSEL_Msk                  (0x7UL << AES_CR_KEYSEL_Pos)           /*!< 0x00000006 */
#define AES_CR_KEYSEL                      AES_CR_KEYSEL_Msk                      /*!< Key Selection */
#define AES_CR_KEYSEL_0                    (0x1UL << AES_CR_KEYSEL_Pos)           /*!< 0x02000000 */
#define AES_CR_KEYSEL_1                    (0x2UL << AES_CR_KEYSEL_Pos)           /*!< 0x02000000 */
#define AES_CR_KEYSEL_2                    (0x4UL << AES_CR_KEYSEL_Pos)           /*!< 0x02000000 */
#define AES_CR_IPRST_Pos                    (31U)
#define AES_CR_IPRST_Msk                    (0x1UL << AES_CR_IPRST_Pos)             /*!< 0x80000001 */
#define AES_CR_IPRST                        AES_CR_IPRST_Msk                        /*!< AES IP software reset */

/*******************  Bit definition for AES_SR register  *********************/
#define AES_SR_CCF_Pos                      (0U)
#define AES_SR_CCF_Msk                      (0x1UL << AES_SR_CCF_Pos)               /*!< 0x00000001 */
#define AES_SR_CCF                          AES_SR_CCF_Msk                          /*!< Computation Complete Flag */
#define AES_SR_RDERR_Pos                    (1U)
#define AES_SR_RDERR_Msk                    (0x1UL << AES_SR_RDERR_Pos)             /*!< 0x00000002 */
#define AES_SR_RDERR                        AES_SR_RDERR_Msk                        /*!< Read Error Flag */
#define AES_SR_WRERR_Pos                    (2U)
#define AES_SR_WRERR_Msk                    (0x1UL << AES_SR_WRERR_Pos)             /*!< 0x00000004 */
#define AES_SR_WRERR                        AES_SR_WRERR_Msk                        /*!< Write Error Flag */
#define AES_SR_BUSY_Pos                     (3U)
#define AES_SR_BUSY_Msk                     (0x1UL << AES_SR_BUSY_Pos)              /*!< 0x00000008 */
#define AES_SR_BUSY                         AES_SR_BUSY_Msk                         /*!< Busy Flag */
#define AES_SR_KEYVALID_Pos                 (7U)
#define AES_SR_KEYVALID_Msk                 (0x1UL << AES_SR_KEYVALID_Pos)          /*!< 0x00000008 */
#define AES_SR_KEYVALID                     AES_SR_KEYVALID_Msk                     /*!< KEYVALID Flag */

/*******************  Bit definition for AES_DINR register  *******************/
#define AES_DINR_Pos                        (0U)
#define AES_DINR_Msk                        (0xFFFFFFFFUL << AES_DINR_Pos)          /*!< 0xFFFFFFFF */
#define AES_DINR                            AES_DINR_Msk                            /*!< AES Data Input Register */

/*******************  Bit definition for AES_DOUTR register  ******************/
#define AES_DOUTR_Pos                       (0U)
#define AES_DOUTR_Msk                       (0xFFFFFFFFUL << AES_DOUTR_Pos)         /*!< 0xFFFFFFFF */
#define AES_DOUTR                           AES_DOUTR_Msk                           /*!< AES Data Output Register */

/*******************  Bit definition for AES_KEYR0 register  ******************/
#define AES_KEYR0_Pos                       (0U)
#define AES_KEYR0_Msk                       (0xFFFFFFFFUL << AES_KEYR0_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR0                           AES_KEYR0_Msk                           /*!< AES Key Register 0 */

/*******************  Bit definition for AES_KEYR1 register  ******************/
#define AES_KEYR1_Pos                       (0U)
#define AES_KEYR1_Msk                       (0xFFFFFFFFUL << AES_KEYR1_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR1                           AES_KEYR1_Msk                           /*!< AES Key Register 1 */

/*******************  Bit definition for AES_KEYR2 register  ******************/
#define AES_KEYR2_Pos                       (0U)
#define AES_KEYR2_Msk                       (0xFFFFFFFFUL << AES_KEYR2_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR2                           AES_KEYR2_Msk                           /*!< AES Key Register 2 */

/*******************  Bit definition for AES_KEYR3 register  ******************/
#define AES_KEYR3_Pos                       (0U)
#define AES_KEYR3_Msk                       (0xFFFFFFFFUL << AES_KEYR3_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR3                           AES_KEYR3_Msk                           /*!< AES Key Register 3 */

/*******************  Bit definition for AES_KEYR4 register  ******************/
#define AES_KEYR4_Pos                       (0U)
#define AES_KEYR4_Msk                       (0xFFFFFFFFUL << AES_KEYR4_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR4                           AES_KEYR4_Msk                           /*!< AES Key Register 4 */

/*******************  Bit definition for AES_KEYR5 register  ******************/
#define AES_KEYR5_Pos                       (0U)
#define AES_KEYR5_Msk                       (0xFFFFFFFFUL << AES_KEYR5_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR5                           AES_KEYR5_Msk                           /*!< AES Key Register 5 */

/*******************  Bit definition for AES_KEYR6 register  ******************/
#define AES_KEYR6_Pos                       (0U)
#define AES_KEYR6_Msk                       (0xFFFFFFFFUL << AES_KEYR6_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR6                           AES_KEYR6_Msk                           /*!< AES Key Register 6 */

/*******************  Bit definition for AES_KEYR7 register  ******************/
#define AES_KEYR7_Pos                       (0U)
#define AES_KEYR7_Msk                       (0xFFFFFFFFUL << AES_KEYR7_Pos)         /*!< 0xFFFFFFFF */
#define AES_KEYR7                           AES_KEYR7_Msk                           /*!< AES Key Register 7 */

/*******************  Bit definition for AES_IVR0 register   ******************/
#define AES_IVR0_Pos                        (0U)
#define AES_IVR0_Msk                        (0xFFFFFFFFUL << AES_IVR0_Pos)          /*!< 0xFFFFFFFF */
#define AES_IVR0                            AES_IVR0_Msk                            /*!< AES Initialization Vector Register 0 */

/*******************  Bit definition for AES_IVR1 register   ******************/
#define AES_IVR1_Pos                        (0U)
#define AES_IVR1_Msk                        (0xFFFFFFFFUL << AES_IVR1_Pos)          /*!< 0xFFFFFFFF */
#define AES_IVR1                            AES_IVR1_Msk                            /*!< AES Initialization Vector Register 1 */

/*******************  Bit definition for AES_IVR2 register   ******************/
#define AES_IVR2_Pos                        (0U)
#define AES_IVR2_Msk                        (0xFFFFFFFFUL << AES_IVR2_Pos)          /*!< 0xFFFFFFFF */
#define AES_IVR2                            AES_IVR2_Msk                            /*!< AES Initialization Vector Register 2 */

/*******************  Bit definition for AES_IVR3 register   ******************/
#define AES_IVR3_Pos                        (0U)
#define AES_IVR3_Msk                        (0xFFFFFFFFUL << AES_IVR3_Pos)          /*!< 0xFFFFFFFF */
#define AES_IVR3                            AES_IVR3_Msk                            /*!< AES Initialization Vector Register 3 */

/*******************  Bit definition for AES_SUSP0R register  ******************/
#define AES_SUSP0R_Pos                      (0U)
#define AES_SUSP0R_Msk                      (0xFFFFFFFFUL << AES_SUSP0R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP0R                          AES_SUSP0R_Msk                          /*!< AES Suspend registers 0 */

/*******************  Bit definition for AES_SUSP1R register  ******************/
#define AES_SUSP1R_Pos                      (0U)
#define AES_SUSP1R_Msk                      (0xFFFFFFFFUL << AES_SUSP1R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP1R                          AES_SUSP1R_Msk                          /*!< AES Suspend registers 1 */

/*******************  Bit definition for AES_SUSP2R register  ******************/
#define AES_SUSP2R_Pos                      (0U)
#define AES_SUSP2R_Msk                      (0xFFFFFFFFUL << AES_SUSP2R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP2R                          AES_SUSP2R_Msk                          /*!< AES Suspend registers 2 */

/*******************  Bit definition for AES_SUSP3R register  ******************/
#define AES_SUSP3R_Pos                      (0U)
#define AES_SUSP3R_Msk                      (0xFFFFFFFFUL << AES_SUSP3R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP3R                          AES_SUSP3R_Msk                          /*!< AES Suspend registers 3 */

/*******************  Bit definition for AES_SUSP4R register  ******************/
#define AES_SUSP4R_Pos                      (0U)
#define AES_SUSP4R_Msk                      (0xFFFFFFFFUL << AES_SUSP4R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP4R                          AES_SUSP4R_Msk                          /*!< AES Suspend registers 4 */

/*******************  Bit definition for AES_SUSP5R register  ******************/
#define AES_SUSP5R_Pos                      (0U)
#define AES_SUSP5R_Msk                      (0xFFFFFFFFUL << AES_SUSP5R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP5R                          AES_SUSP5R_Msk                          /*!< AES Suspend registers 5 */

/*******************  Bit definition for AES_SUSP6R register  ******************/
#define AES_SUSP6R_Pos                      (0U)
#define AES_SUSP6R_Msk                      (0xFFFFFFFFUL << AES_SUSP6R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP6R                          AES_SUSP6R_Msk                          /*!< AES Suspend registers 6 */

/*******************  Bit definition for AES_SUSP7R register  ******************/
#define AES_SUSP7R_Pos                      (0U)
#define AES_SUSP7R_Msk                      (0xFFFFFFFFUL << AES_SUSP7R_Pos)        /*!< 0xFFFFFFFF */
#define AES_SUSP7R                          AES_SUSP7R_Msk                          /*!< AES Suspend registers 7 */

/*******************  Bit definition for AES_IER register     ******************/
#define AES_IER_CCFIE_Pos                   (0U)
#define AES_IER_CCFIE_Msk                   (0x1UL << AES_IER_CCFIE_Pos)            /*!< 0x00000001 */
#define AES_IER_CCFIE                       AES_IER_CCFIE_Msk                       /*!< Computation complete flag interrupt enable */
#define AES_IER_RWEIE_Pos                   (1U)
#define AES_IER_RWEIE_Msk                   (0x1UL << AES_IER_RWEIE_Pos)            /*!< 0x00000002 */
#define AES_IER_RWEIE                       AES_IER_RWEIE_Msk                       /*!< Read or write error Interrupt Enable */
#define AES_IER_KEIE_Pos                    (2U)
#define AES_IER_KEIE_Msk                    (0x1UL << AES_IER_KEIE_Pos)             /*!< 0x00000004 */
#define AES_IER_KEIE                        AES_IER_KEIE_Msk                        /*!< Key error interrupt enable */
#define AES_IER_RNGEIE_Pos                  (3U)
#define AES_IER_RNGEIE_Msk                  (0x1UL << AES_IER_RNGEIE_Pos)           /*!< 0x00000008 */
#define AES_IER_RNGEIE                      AES_IER_RNGEIE_Msk                      /*!< Rng error interrupt enable */

/*******************  Bit definition for AES_ISR register     ******************/
#define AES_ISR_CCF_Pos                     (0U)
#define AES_ISR_CCF_Msk                     (0x1UL << AES_ISR_CCF_Pos)              /*!< 0x00000001 */
#define AES_ISR_CCF                         AES_ISR_CCF_Msk                         /*!< Computation complete flag */
#define AES_ISR_RWEIF_Pos                   (1U)
#define AES_ISR_RWEIF_Msk                   (0x1UL << AES_ISR_RWEIF_Pos)            /*!< 0x00000002 */
#define AES_ISR_RWEIF                       AES_ISR_RWEIF_Msk                       /*!< Read or write error Interrupt flag */
#define AES_ISR_KEIF_Pos                    (2U)
#define AES_ISR_KEIF_Msk                    (0x1UL << AES_ISR_KEIF_Pos)             /*!< 0x00000004 */
#define AES_ISR_KEIF                        AES_ISR_KEIF_Msk                        /*!< Key error interrupt flag */
#define AES_ISR_RNGEIF_Pos                  (3U)
#define AES_ISR_RNGEIF_Msk                  (0x1UL << AES_ISR_RNGEIF_Pos)           /*!< 0x00000008 */
#define AES_ISR_RNGEIF                      AES_ISR_RNGEIF_Msk                      /*!< Rng error interrupt flag */

/*******************  Bit definition for AES_ICR register     ******************/
#define AES_ICR_CCF_Pos                     (0U)
#define AES_ICR_CCF_Msk                     (0x1UL << AES_ICR_CCF_Pos)              /*!< 0x00000001 */
#define AES_ICR_CCF                         AES_ICR_CCF_Msk                         /*!< Computation complete flag clear */
#define AES_ICR_RWEIF_Pos                   (1U)
#define AES_ICR_RWEIF_Msk                   (0x1UL << AES_ICR_RWEIF_Pos)            /*!< 0x00000002 */
#define AES_ICR_RWEIF                       AES_ICR_RWEIF_Msk                       /*!< Read or write error Interrupt flag clear */
#define AES_ICR_KEIF_Pos                    (2U)
#define AES_ICR_KEIF_Msk                    (0x1UL << AES_ICR_KEIF_Pos)             /*!< 0x00000004 */
#define AES_ICR_KEIF                        AES_ICR_KEIF_Msk                        /*!< Key error interrupt flag clear */
#define AES_ICR_RNGEIF_Pos                  (3U)
#define AES_ICR_RNGEIF_Msk                  (0x1UL << AES_ICR_RNGEIF_Pos)           /*!< 0x00000008 */
#define AES_ICR_RNGEIF                       AES_ICR_RNGEIF_Msk                     /*!< Rng error interrupt flag clear */

/******************************************************************************/
/*                                                                            */
/*                                    HASH                                    */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for HASH_CR register  ********************/
#define HASH_CR_INIT_Pos                    (2U)
#define HASH_CR_INIT_Msk                    (0x1UL << HASH_CR_INIT_Pos)             /*!< 0x00000004 */
#define HASH_CR_INIT                        HASH_CR_INIT_Msk
#define HASH_CR_DMAE_Pos                    (3U)
#define HASH_CR_DMAE_Msk                    (0x1UL << HASH_CR_DMAE_Pos)             /*!< 0x00000008 */
#define HASH_CR_DMAE                        HASH_CR_DMAE_Msk
#define HASH_CR_DATATYPE_Pos                (4U)
#define HASH_CR_DATATYPE_Msk                (0x3UL << HASH_CR_DATATYPE_Pos)         /*!< 0x00000030 */
#define HASH_CR_DATATYPE                    HASH_CR_DATATYPE_Msk
#define HASH_CR_DATATYPE_0                  (0x1UL << HASH_CR_DATATYPE_Pos)         /*!< 0x00000010 */
#define HASH_CR_DATATYPE_1                  (0x2UL << HASH_CR_DATATYPE_Pos)         /*!< 0x00000020 */
#define HASH_CR_MODE_Pos                    (6U)
#define HASH_CR_MODE_Msk                    (0x1UL << HASH_CR_MODE_Pos)             /*!< 0x00000040 */
#define HASH_CR_MODE                        HASH_CR_MODE_Msk
#define HASH_CR_NBW_Pos                     (8U)
#define HASH_CR_NBW_Msk                     (0xFUL << HASH_CR_NBW_Pos)              /*!< 0x00000F00 */
#define HASH_CR_NBW                         HASH_CR_NBW_Msk
#define HASH_CR_NBW_0                       (0x1UL << HASH_CR_NBW_Pos)              /*!< 0x00000100 */
#define HASH_CR_NBW_1                       (0x2UL << HASH_CR_NBW_Pos)              /*!< 0x00000200 */
#define HASH_CR_NBW_2                       (0x4UL << HASH_CR_NBW_Pos)              /*!< 0x00000400 */
#define HASH_CR_NBW_3                       (0x8UL << HASH_CR_NBW_Pos)              /*!< 0x00000800 */
#define HASH_CR_DINNE_Pos                   (12U)
#define HASH_CR_DINNE_Msk                   (0x1UL << HASH_CR_DINNE_Pos)            /*!< 0x00001000 */
#define HASH_CR_DINNE                       HASH_CR_DINNE_Msk
#define HASH_CR_MDMAT_Pos                   (13U)
#define HASH_CR_MDMAT_Msk                   (0x1UL << HASH_CR_MDMAT_Pos)            /*!< 0x00002000 */
#define HASH_CR_MDMAT                       HASH_CR_MDMAT_Msk
#define HASH_CR_LKEY_Pos                    (16U)
#define HASH_CR_LKEY_Msk                    (0x1UL << HASH_CR_LKEY_Pos)             /*!< 0x00010000 */
#define HASH_CR_LKEY                        HASH_CR_LKEY_Msk
#define HASH_CR_ALGO_Pos                    (17U)
#define HASH_CR_ALGO_Msk                    (0x3UL << HASH_CR_ALGO_Pos)             /*!< 0x00040080 */
#define HASH_CR_ALGO                        HASH_CR_ALGO_Msk
#define HASH_CR_ALGO_0                      (0x1UL << HASH_CR_ALGO_Pos)             /*!< 0x00000080 */
#define HASH_CR_ALGO_1                      (0x2UL << HASH_CR_ALGO_Pos)             /*!< 0x00040000 */

/******************  Bits definition for HASH_STR register  *******************/
#define HASH_STR_NBLW_Pos                   (0U)
#define HASH_STR_NBLW_Msk                   (0x1FUL << HASH_STR_NBLW_Pos)           /*!< 0x0000001F */
#define HASH_STR_NBLW                       HASH_STR_NBLW_Msk
#define HASH_STR_NBLW_0                     (0x01UL << HASH_STR_NBLW_Pos)           /*!< 0x00000001 */
#define HASH_STR_NBLW_1                     (0x02UL << HASH_STR_NBLW_Pos)           /*!< 0x00000002 */
#define HASH_STR_NBLW_2                     (0x04UL << HASH_STR_NBLW_Pos)           /*!< 0x00000004 */
#define HASH_STR_NBLW_3                     (0x08UL << HASH_STR_NBLW_Pos)           /*!< 0x00000008 */
#define HASH_STR_NBLW_4                     (0x10UL << HASH_STR_NBLW_Pos)           /*!< 0x00000010 */
#define HASH_STR_DCAL_Pos                   (8U)
#define HASH_STR_DCAL_Msk                   (0x1UL << HASH_STR_DCAL_Pos)            /*!< 0x00000100 */
#define HASH_STR_DCAL                       HASH_STR_DCAL_Msk

/******************  Bits definition for HASH_IMR register  *******************/
#define HASH_IMR_DINIE_Pos                  (0U)
#define HASH_IMR_DINIE_Msk                  (0x1UL << HASH_IMR_DINIE_Pos)           /*!< 0x00000001 */
#define HASH_IMR_DINIE                      HASH_IMR_DINIE_Msk
#define HASH_IMR_DCIE_Pos                   (1U)
#define HASH_IMR_DCIE_Msk                   (0x1UL << HASH_IMR_DCIE_Pos)            /*!< 0x00000002 */
#define HASH_IMR_DCIE                       HASH_IMR_DCIE_Msk

/******************  Bits definition for HASH_SR register  ********************/
#define HASH_SR_DINIS_Pos                   (0U)
#define HASH_SR_DINIS_Msk                   (0x1UL << HASH_SR_DINIS_Pos)            /*!< 0x00000001 */
#define HASH_SR_DINIS                       HASH_SR_DINIS_Msk
#define HASH_SR_DCIS_Pos                    (1U)
#define HASH_SR_DCIS_Msk                    (0x1UL << HASH_SR_DCIS_Pos)             /*!< 0x00000002 */
#define HASH_SR_DCIS                        HASH_SR_DCIS_Msk
#define HASH_SR_DMAS_Pos                    (2U)
#define HASH_SR_DMAS_Msk                    (0x1UL << HASH_SR_DMAS_Pos)             /*!< 0x00000004 */
#define HASH_SR_DMAS                        HASH_SR_DMAS_Msk
#define HASH_SR_BUSY_Pos                    (3U)
#define HASH_SR_BUSY_Msk                    (0x1UL << HASH_SR_BUSY_Pos)             /*!< 0x00000008 */
#define HASH_SR_BUSY                        HASH_SR_BUSY_Msk
#define HASH_SR_NBWE_Pos                    (16U)
#define HASH_SR_NBWE_Msk                    (0xFUL << HASH_SR_NBWE_Pos)             /*!< 0x000F0000 */
#define HASH_SR_NBWE                        HASH_SR_NBWE_Msk
#define HASH_SR_NBWE_0                      (0x01UL << HASH_SR_NBWE_Pos)            /*!< 0x00010000 */
#define HASH_SR_NBWE_1                      (0x02UL << HASH_SR_NBWE_Pos)            /*!< 0x00020000 */
#define HASH_SR_NBWE_2                      (0x04UL << HASH_SR_NBWE_Pos)            /*!< 0x00040000 */
#define HASH_SR_NBWE_3                      (0x08UL << HASH_SR_NBWE_Pos)            /*!< 0x00080000 */
#define HASH_SR_DINNE_Pos                   (15U)
#define HASH_SR_DINNE_Msk                   (0x1UL << HASH_SR_DINNE_Pos)            /*!< 0x00008000 */
#define HASH_SR_DINNE                       HASH_SR_DINNE_Msk
#define HASH_SR_NBWP_Pos                    (9U)
#define HASH_SR_NBWP_Msk                    (0xFUL << HASH_SR_NBWP_Pos)             /*!< 0x000F0000 */
#define HASH_SR_NBWP                        HASH_SR_NBWP_Msk
#define HASH_SR_NBWP_0                      (0x01UL << HASH_SR_NBWP_Pos)            /*!< 0x000O0200 */
#define HASH_SR_NBWP_1                      (0x02UL << HASH_SR_NBWP_Pos)            /*!< 0x00000400 */
#define HASH_SR_NBWP_2                      (0x04UL << HASH_SR_NBWP_Pos)            /*!< 0x00000800 */
#define HASH_SR_NBWP_3                      (0x08UL << HASH_SR_NBWP_Pos)            /*!< 0x00001000 */

/******************************************************************************/
/*                                                                            */
/*                                 Debug MCU                                  */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for DBGMCU_IDCODE register  *************/
#define DBGMCU_IDCODE_DEV_ID_Pos            (0U)
#define DBGMCU_IDCODE_DEV_ID_Msk            (0xFFFUL << DBGMCU_IDCODE_DEV_ID_Pos)   /*!< 0x00000FFF */
#define DBGMCU_IDCODE_DEV_ID                DBGMCU_IDCODE_DEV_ID_Msk
#define DBGMCU_IDCODE_REV_ID_Pos            (16U)
#define DBGMCU_IDCODE_REV_ID_Msk            (0xFFFFUL << DBGMCU_IDCODE_REV_ID_Pos)  /*!< 0xFFFF0000 */
#define DBGMCU_IDCODE_REV_ID                DBGMCU_IDCODE_REV_ID_Msk

/********************  Bit definition for DBGMCU_CR register  *****************/
#define DBGMCU_CR_DBG_STOP_Pos              (1U)
#define DBGMCU_CR_DBG_STOP_Msk              (0x1UL << DBGMCU_CR_DBG_STOP_Pos)       /*!< 0x00000002 */
#define DBGMCU_CR_DBG_STOP                  DBGMCU_CR_DBG_STOP_Msk
#define DBGMCU_CR_DBG_STANDBY_Pos           (2U)
#define DBGMCU_CR_DBG_STANDBY_Msk           (0x1UL << DBGMCU_CR_DBG_STANDBY_Pos)    /*!< 0x00000004 */
#define DBGMCU_CR_DBG_STANDBY               DBGMCU_CR_DBG_STANDBY_Msk
#define DBGMCU_CR_TRACE_IOEN_Pos            (4U)
#define DBGMCU_CR_TRACE_IOEN_Msk            (0x1UL << DBGMCU_CR_TRACE_IOEN_Pos)     /*!< 0x00000010 */
#define DBGMCU_CR_TRACE_IOEN                DBGMCU_CR_TRACE_IOEN_Msk
#define DBGMCU_CR_TRACE_CLKEN_Pos           (5U)
#define DBGMCU_CR_TRACE_CLKEN_Msk           (0x1UL << DBGMCU_CR_TRACE_CLKEN_Pos)    /*!< 0x00000020 */
#define DBGMCU_CR_TRACE_CLKEN               DBGMCU_CR_TRACE_CLKEN_Msk
#define DBGMCU_CR_TRACE_MODE_Pos            (6U)
#define DBGMCU_CR_TRACE_MODE_Msk            (0x3UL << DBGMCU_CR_TRACE_MODE_Pos)     /*!< 0x000000C0 */
#define DBGMCU_CR_TRACE_MODE                DBGMCU_CR_TRACE_MODE_Msk
#define DBGMCU_CR_TRACE_MODE_0              (0x1UL << DBGMCU_CR_TRACE_MODE_Pos)     /*!< 0x00000040 */
#define DBGMCU_CR_TRACE_MODE_1              (0x2UL << DBGMCU_CR_TRACE_MODE_Pos)     /*!< 0x00000080 */

/********************  Bit definition for DBGMCU_APB1FZR1 register  ***********/
#define DBGMCU_APB1FZR1_DBG_TIM2_STOP_Pos   (0U)
#define DBGMCU_APB1FZR1_DBG_TIM2_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM2_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM2_STOP       DBGMCU_APB1FZR1_DBG_TIM2_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM3_STOP_Pos   (1U)
#define DBGMCU_APB1FZR1_DBG_TIM3_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM3_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM3_STOP       DBGMCU_APB1FZR1_DBG_TIM3_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM4_STOP_Pos   (2U)
#define DBGMCU_APB1FZR1_DBG_TIM4_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM4_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM4_STOP       DBGMCU_APB1FZR1_DBG_TIM4_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM5_STOP_Pos   (3U)
#define DBGMCU_APB1FZR1_DBG_TIM5_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM5_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM5_STOP       DBGMCU_APB1FZR1_DBG_TIM5_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM6_STOP_Pos   (4U)
#define DBGMCU_APB1FZR1_DBG_TIM6_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM6_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM6_STOP       DBGMCU_APB1FZR1_DBG_TIM6_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_TIM7_STOP_Pos   (5U)
#define DBGMCU_APB1FZR1_DBG_TIM7_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_TIM7_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_TIM7_STOP       DBGMCU_APB1FZR1_DBG_TIM7_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_WWDG_STOP_Pos   (11U)
#define DBGMCU_APB1FZR1_DBG_WWDG_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_WWDG_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_WWDG_STOP       DBGMCU_APB1FZR1_DBG_WWDG_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_IWDG_STOP_Pos   (12U)
#define DBGMCU_APB1FZR1_DBG_IWDG_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_IWDG_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_IWDG_STOP       DBGMCU_APB1FZR1_DBG_IWDG_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_I2C1_STOP_Pos   (21U)
#define DBGMCU_APB1FZR1_DBG_I2C1_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_I2C1_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_I2C1_STOP       DBGMCU_APB1FZR1_DBG_I2C1_STOP_Msk
#define DBGMCU_APB1FZR1_DBG_I2C2_STOP_Pos   (22U)
#define DBGMCU_APB1FZR1_DBG_I2C2_STOP_Msk   (0x1UL << DBGMCU_APB1FZR1_DBG_I2C2_STOP_Pos)
#define DBGMCU_APB1FZR1_DBG_I2C2_STOP       DBGMCU_APB1FZR1_DBG_I2C2_STOP_Msk

/********************  Bit definition for DBGMCU_APB1FZR2 register  ***********/
#define DBGMCU_APB1FZR2_DBG_I2C4_STOP_Pos   (1U)
#define DBGMCU_APB1FZR2_DBG_I2C4_STOP_Msk   (0x1UL << DBGMCU_APB1FZR2_DBG_I2C4_STOP_Pos)
#define DBGMCU_APB1FZR2_DBG_I2C4_STOP       DBGMCU_APB1FZR2_DBG_I2C4_STOP_Msk
#define DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Pos (5U)
#define DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Msk (0x1UL << DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Pos)
#define DBGMCU_APB1FZR2_DBG_LPTIM2_STOP     DBGMCU_APB1FZR2_DBG_LPTIM2_STOP_Msk
#define DBGMCU_APB1FZR2_DBG_I2C5_STOP_Pos   (6U)
#define DBGMCU_APB1FZR2_DBG_I2C5_STOP_Msk   (0x1UL << DBGMCU_APB1FZR2_DBG_I2C5_STOP_Pos)
#define DBGMCU_APB1FZR2_DBG_I2C5_STOP       DBGMCU_APB1FZR2_DBG_I2C5_STOP_Msk
#define DBGMCU_APB1FZR2_DBG_I2C6_STOP_Pos   (7U)
#define DBGMCU_APB1FZR2_DBG_I2C6_STOP_Msk   (0x1UL << DBGMCU_APB1FZR2_DBG_I2C6_STOP_Pos)
#define DBGMCU_APB1FZR2_DBG_I2C6_STOP       DBGMCU_APB1FZR2_DBG_I2C6_STOP_Msk

/********************  Bit definition for DBGMCU_APB2FZR register  ***********/
#define DBGMCU_APB2FZR_DBG_TIM1_STOP_Pos    (11U)
#define DBGMCU_APB2FZR_DBG_TIM1_STOP_Msk    (0x1UL << DBGMCU_APB2FZR_DBG_TIM1_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM1_STOP        DBGMCU_APB2FZR_DBG_TIM1_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM8_STOP_Pos    (13U)
#define DBGMCU_APB2FZR_DBG_TIM8_STOP_Msk    (0x1UL << DBGMCU_APB2FZR_DBG_TIM8_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM8_STOP        DBGMCU_APB2FZR_DBG_TIM8_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM15_STOP_Pos   (16U)
#define DBGMCU_APB2FZR_DBG_TIM15_STOP_Msk   (0x1UL << DBGMCU_APB2FZR_DBG_TIM15_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM15_STOP       DBGMCU_APB2FZR_DBG_TIM15_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM16_STOP_Pos   (17U)
#define DBGMCU_APB2FZR_DBG_TIM16_STOP_Msk   (0x1UL << DBGMCU_APB2FZR_DBG_TIM16_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM16_STOP       DBGMCU_APB2FZR_DBG_TIM16_STOP_Msk
#define DBGMCU_APB2FZR_DBG_TIM17_STOP_Pos   (18U)
#define DBGMCU_APB2FZR_DBG_TIM17_STOP_Msk   (0x1UL << DBGMCU_APB2FZR_DBG_TIM17_STOP_Pos)
#define DBGMCU_APB2FZR_DBG_TIM17_STOP       DBGMCU_APB2FZR_DBG_TIM17_STOP_Msk

/********************  Bit definition for DBGMCU_APB3FZR register  ***********/
#define DBGMCU_APB3FZR_DBG_I2C3_STOP_Pos    (10U)
#define DBGMCU_APB3FZR_DBG_I2C3_STOP_Msk    (0x1UL << DBGMCU_APB3FZR_DBG_I2C3_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_I2C3_STOP        DBGMCU_APB3FZR_DBG_I2C3_STOP_Msk
#define DBGMCU_APB3FZR_DBG_LPTIM1_STOP_Pos  (17U)
#define DBGMCU_APB3FZR_DBG_LPTIM1_STOP_Msk  (0x1UL << DBGMCU_APB3FZR_DBG_LPTIM1_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_LPTIM1_STOP      DBGMCU_APB3FZR_DBG_LPTIM1_STOP_Msk
#define DBGMCU_APB3FZR_DBG_LPTIM3_STOP_Pos  (18U)
#define DBGMCU_APB3FZR_DBG_LPTIM3_STOP_Msk  (0x1UL << DBGMCU_APB3FZR_DBG_LPTIM3_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_LPTIM3_STOP      DBGMCU_APB3FZR_DBG_LPTIM3_STOP_Msk
#define DBGMCU_APB3FZR_DBG_LPTIM4_STOP_Pos  (19U)
#define DBGMCU_APB3FZR_DBG_LPTIM4_STOP_Msk  (0x1UL << DBGMCU_APB3FZR_DBG_LPTIM4_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_LPTIM4_STOP      DBGMCU_APB3FZR_DBG_LPTIM4_STOP_Msk
#define DBGMCU_APB3FZR_DBG_RTC_STOP_Pos     (30U)
#define DBGMCU_APB3FZR_DBG_RTC_STOP_Msk     (0x1UL << DBGMCU_APB3FZR_DBG_RTC_STOP_Pos)
#define DBGMCU_APB3FZR_DBG_RTC_STOP         DBGMCU_APB3FZR_DBG_RTC_STOP_Msk

/********************  Bit definition for DBGMCU_AHB1FZR register  ***********/
#define DBGMCU_AHB1FZR_DBG_GPDMA0_STOP_Pos  (0U)
#define DBGMCU_AHB1FZR_DBG_GPDMA0_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA0_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA0_STOP      DBGMCU_AHB1FZR_DBG_GPDMA0_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA1_STOP_Pos  (1U)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA1_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA1_STOP      DBGMCU_AHB1FZR_DBG_GPDMA1_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA2_STOP_Pos  (2U)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA2_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA2_STOP      DBGMCU_AHB1FZR_DBG_GPDMA2_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA3_STOP_Pos  (3U)
#define DBGMCU_AHB1FZR_DBG_GPDMA3_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA3_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA3_STOP      DBGMCU_AHB1FZR_DBG_GPDMA3_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA4_STOP_Pos  (4U)
#define DBGMCU_AHB1FZR_DBG_GPDMA4_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA4_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA4_STOP      DBGMCU_AHB1FZR_DBG_GPDMA4_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA5_STOP_Pos  (5U)
#define DBGMCU_AHB1FZR_DBG_GPDMA5_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA5_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA5_STOP      DBGMCU_AHB1FZR_DBG_GPDMA5_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA6_STOP_Pos  (6U)
#define DBGMCU_AHB1FZR_DBG_GPDMA6_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA6_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA6_STOP      DBGMCU_AHB1FZR_DBG_GPDMA6_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA7_STOP_Pos  (7U)
#define DBGMCU_AHB1FZR_DBG_GPDMA7_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA7_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA7_STOP      DBGMCU_AHB1FZR_DBG_GPDMA7_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA8_STOP_Pos  (8U)
#define DBGMCU_AHB1FZR_DBG_GPDMA8_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA8_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA8_STOP      DBGMCU_AHB1FZR_DBG_GPDMA8_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA9_STOP_Pos  (9U)
#define DBGMCU_AHB1FZR_DBG_GPDMA9_STOP_Msk  (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA9_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA9_STOP      DBGMCU_AHB1FZR_DBG_GPDMA9_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA10_STOP_Pos (10U)
#define DBGMCU_AHB1FZR_DBG_GPDMA10_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA10_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA10_STOP     DBGMCU_AHB1FZR_DBG_GPDMA10_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA11_STOP_Pos (11U)
#define DBGMCU_AHB1FZR_DBG_GPDMA11_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA11_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA11_STOP     DBGMCU_AHB1FZR_DBG_GPDMA11_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA12_STOP_Pos (12U)
#define DBGMCU_AHB1FZR_DBG_GPDMA12_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA12_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA12_STOP     DBGMCU_AHB1FZR_DBG_GPDMA12_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA13_STOP_Pos (13U)
#define DBGMCU_AHB1FZR_DBG_GPDMA13_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA13_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA13_STOP     DBGMCU_AHB1FZR_DBG_GPDMA13_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA14_STOP_Pos (14U)
#define DBGMCU_AHB1FZR_DBG_GPDMA14_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA14_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA14_STOP     DBGMCU_AHB1FZR_DBG_GPDMA14_STOP_Msk
#define DBGMCU_AHB1FZR_DBG_GPDMA15_STOP_Pos (15U)
#define DBGMCU_AHB1FZR_DBG_GPDMA15_STOP_Msk (0x1UL << DBGMCU_AHB1FZR_DBG_GPDMA15_STOP_Pos)
#define DBGMCU_AHB1FZR_DBG_GPDMA15_STOP     DBGMCU_AHB1FZR_DBG_GPDMA15_STOP_Msk

/********************  Bit definition for DBGMCU_AHB3FZR register  ***********/
#define DBGMCU_AHB3FZR_DBG_LPDMA0_STOP_Pos  (0U)
#define DBGMCU_AHB3FZR_DBG_LPDMA0_STOP_Msk  (0x1UL << DBGMCU_AHB3FZR_DBG_LPDMA0_STOP_Pos)
#define DBGMCU_AHB3FZR_DBG_LPDMA0_STOP      DBGMCU_AHB3FZR_DBG_LPDMA0_STOP_Msk
#define DBGMCU_AHB3FZR_DBG_LPDMA1_STOP_Pos  (1U)
#define DBGMCU_AHB3FZR_DBG_LPDMA1_STOP_Msk  (0x1UL << DBGMCU_AHB3FZR_DBG_LPDMA1_STOP_Pos)
#define DBGMCU_AHB3FZR_DBG_LPDMA1_STOP      DBGMCU_AHB3FZR_DBG_LPDMA1_STOP_Msk
#define DBGMCU_AHB3FZR_DBG_LPDMA2_STOP_Pos  (2U)
#define DBGMCU_AHB3FZR_DBG_LPDMA2_STOP_Msk  (0x1UL << DBGMCU_AHB3FZR_DBG_LPDMA2_STOP_Pos)
#define DBGMCU_AHB3FZR_DBG_LPDMA2_STOP      DBGMCU_AHB3FZR_DBG_LPDMA2_STOP_Msk
#define DBGMCU_AHB3FZR_DBG_LPDMA3_STOP_Pos  (3U)
#define DBGMCU_AHB3FZR_DBG_LPDMA3_STOP_Msk  (0x1UL << DBGMCU_AHB3FZR_DBG_LPDMA3_STOP_Pos)
#define DBGMCU_AHB3FZR_DBG_LPDMA3_STOP      DBGMCU_AHB3FZR_DBG_LPDMA3_STOP_Msk

/******************************************************************************/
/*                                                                            */
/*                                    DCMI                                    */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for DCMI_CR register  ******************/
#define DCMI_CR_CAPTURE_Pos                 (0U)
#define DCMI_CR_CAPTURE_Msk                 (0x1UL << DCMI_CR_CAPTURE_Pos)          /*!< 0x00000001 */
#define DCMI_CR_CAPTURE                     DCMI_CR_CAPTURE_Msk
#define DCMI_CR_CM_Pos                      (1U)
#define DCMI_CR_CM_Msk                      (0x1UL << DCMI_CR_CM_Pos)               /*!< 0x00000002 */
#define DCMI_CR_CM                          DCMI_CR_CM_Msk
#define DCMI_CR_CROP_Pos                    (2U)
#define DCMI_CR_CROP_Msk                    (0x1UL << DCMI_CR_CROP_Pos)             /*!< 0x00000004 */
#define DCMI_CR_CROP                        DCMI_CR_CROP_Msk
#define DCMI_CR_JPEG_Pos                    (3U)
#define DCMI_CR_JPEG_Msk                    (0x1UL << DCMI_CR_JPEG_Pos)             /*!< 0x00000008 */
#define DCMI_CR_JPEG                        DCMI_CR_JPEG_Msk
#define DCMI_CR_ESS_Pos                     (4U)
#define DCMI_CR_ESS_Msk                     (0x1UL << DCMI_CR_ESS_Pos)              /*!< 0x00000010 */
#define DCMI_CR_ESS                         DCMI_CR_ESS_Msk
#define DCMI_CR_PCKPOL_Pos                  (5U)
#define DCMI_CR_PCKPOL_Msk                  (0x1UL << DCMI_CR_PCKPOL_Pos)           /*!< 0x00000020 */
#define DCMI_CR_PCKPOL                      DCMI_CR_PCKPOL_Msk
#define DCMI_CR_HSPOL_Pos                   (6U)
#define DCMI_CR_HSPOL_Msk                   (0x1UL << DCMI_CR_HSPOL_Pos)            /*!< 0x00000040 */
#define DCMI_CR_HSPOL                       DCMI_CR_HSPOL_Msk
#define DCMI_CR_VSPOL_Pos                   (7U)
#define DCMI_CR_VSPOL_Msk                   (0x1UL << DCMI_CR_VSPOL_Pos)            /*!< 0x00000080 */
#define DCMI_CR_VSPOL                       DCMI_CR_VSPOL_Msk
#define DCMI_CR_FCRC_Pos                    (8U)
#define DCMI_CR_FCRC_Msk                    (0x3UL << DCMI_CR_FCRC_Pos)             /*!< 0x00000300 */
#define DCMI_CR_FCRC                        DCMI_CR_FCRC_Msk                        /*!< DCMI Frame capture rate control FCRC[1:0] */
#define DCMI_CR_FCRC_0                      (0x1UL << DCMI_CR_FCRC_Pos)             /*!< 0x00000100 */
#define DCMI_CR_FCRC_1                      (0x2UL << DCMI_CR_FCRC_Pos)             /*!< 0x00000200 */
#define DCMI_CR_EDM_Pos                     (10U)
#define DCMI_CR_EDM_Msk                     (0x3UL << DCMI_CR_EDM_Pos)              /*!< 0x00000C00 */
#define DCMI_CR_EDM                         DCMI_CR_EDM_Msk                         /*!< DCMI Extended data mode EDM[1:0] */
#define DCMI_CR_EDM_0                       (0x1UL << DCMI_CR_EDM_Pos)              /*!< 0x00000400 */
#define DCMI_CR_EDM_1                       (0x2UL << DCMI_CR_EDM_Pos)              /*!< 0x00000800 */
#define DCMI_CR_ENABLE_Pos                  (14U)
#define DCMI_CR_ENABLE_Msk                  (0x1UL << DCMI_CR_ENABLE_Pos)           /*!< 0x00004000 */
#define DCMI_CR_ENABLE                      DCMI_CR_ENABLE_Msk
#define DCMI_CR_BSM_Pos                     (16U)
#define DCMI_CR_BSM_Msk                     (0x3UL << DCMI_CR_BSM_Pos)              /*!< 0x00030000 */
#define DCMI_CR_BSM                         DCMI_CR_BSM_Msk
#define DCMI_CR_BSM_0                       (0x1UL << DCMI_CR_BSM_Pos)              /*!< 0x00010000 */
#define DCMI_CR_BSM_1                       (0x2UL << DCMI_CR_BSM_Pos)              /*!< 0x00020000 */
#define DCMI_CR_OEBS_Pos                    (18U)
#define DCMI_CR_OEBS_Msk                    (0x1UL << DCMI_CR_OEBS_Pos)             /*!< 0x00040000 */
#define DCMI_CR_OEBS                        DCMI_CR_OEBS_Msk
#define DCMI_CR_LSM_Pos                     (19U)
#define DCMI_CR_LSM_Msk                     (0x1UL << DCMI_CR_LSM_Pos)              /*!< 0x00080000 */
#define DCMI_CR_LSM                         DCMI_CR_LSM_Msk
#define DCMI_CR_OELS_Pos                    (20U)
#define DCMI_CR_OELS_Msk                    (0x1UL << DCMI_CR_OELS_Pos)             /*!< 0x00100000 */
#define DCMI_CR_OELS                        DCMI_CR_OELS_Msk
#define DCMI_CR_PSDM_Pos                    (31U)
#define DCMI_CR_PSDM_Msk                    (0x0UL << DCMI_CR_PSDM_Pos)             /*!< 0x00000000 */
#define DCMI_CR_PSDM                        DCMI_CR_PSDM_Msk                        /*PSDM: Parallel Synchronous raw Data Mode (PSDM = 0)*/

/********************  Bits definition for DCMI_SR register  ******************/
#define DCMI_SR_HSYNC_Pos                   (0U)
#define DCMI_SR_HSYNC_Msk                   (0x1UL << DCMI_SR_HSYNC_Pos)            /*!< 0x00000001 */
#define DCMI_SR_HSYNC                       DCMI_SR_HSYNC_Msk
#define DCMI_SR_VSYNC_Pos                   (1U)
#define DCMI_SR_VSYNC_Msk                   (0x1UL << DCMI_SR_VSYNC_Pos)            /*!< 0x00000002 */
#define DCMI_SR_VSYNC                       DCMI_SR_VSYNC_Msk
#define DCMI_SR_FNE_Pos                     (2U)
#define DCMI_SR_FNE_Msk                     (0x1UL << DCMI_SR_FNE_Pos)              /*!< 0x00000004 */
#define DCMI_SR_FNE                         DCMI_SR_FNE_Msk

/********************  Bits definition for DCMI_RIS register   ****************/
#define DCMI_RIS_FRAME_RIS_Pos              (0U)
#define DCMI_RIS_FRAME_RIS_Msk              (0x1UL << DCMI_RIS_FRAME_RIS_Pos)       /*!< 0x00000001 */
#define DCMI_RIS_FRAME_RIS                  DCMI_RIS_FRAME_RIS_Msk
#define DCMI_RIS_OVR_RIS_Pos                (1U)
#define DCMI_RIS_OVR_RIS_Msk                (0x1UL << DCMI_RIS_OVR_RIS_Pos)         /*!< 0x00000002 */
#define DCMI_RIS_OVR_RIS                    DCMI_RIS_OVR_RIS_Msk
#define DCMI_RIS_ERR_RIS_Pos                (2U)
#define DCMI_RIS_ERR_RIS_Msk                (0x1UL << DCMI_RIS_ERR_RIS_Pos)         /*!< 0x00000004 */
#define DCMI_RIS_ERR_RIS                    DCMI_RIS_ERR_RIS_Msk
#define DCMI_RIS_VSYNC_RIS_Pos              (3U)
#define DCMI_RIS_VSYNC_RIS_Msk              (0x1UL << DCMI_RIS_VSYNC_RIS_Pos)       /*!< 0x00000008 */
#define DCMI_RIS_VSYNC_RIS                  DCMI_RIS_VSYNC_RIS_Msk
#define DCMI_RIS_LINE_RIS_Pos               (4U)
#define DCMI_RIS_LINE_RIS_Msk               (0x1UL << DCMI_RIS_LINE_RIS_Pos)        /*!< 0x00000010 */
#define DCMI_RIS_LINE_RIS                   DCMI_RIS_LINE_RIS_Msk

/********************  Bits definition for DCMI_IER register  *****************/
#define DCMI_IER_FRAME_IE_Pos               (0U)
#define DCMI_IER_FRAME_IE_Msk               (0x1UL << DCMI_IER_FRAME_IE_Pos)        /*!< 0x00000001 */
#define DCMI_IER_FRAME_IE                   DCMI_IER_FRAME_IE_Msk
#define DCMI_IER_OVR_IE_Pos                 (1U)
#define DCMI_IER_OVR_IE_Msk                 (0x1UL << DCMI_IER_OVR_IE_Pos)          /*!< 0x00000002 */
#define DCMI_IER_OVR_IE                     DCMI_IER_OVR_IE_Msk
#define DCMI_IER_ERR_IE_Pos                 (2U)
#define DCMI_IER_ERR_IE_Msk                 (0x1UL << DCMI_IER_ERR_IE_Pos)          /*!< 0x00000004 */
#define DCMI_IER_ERR_IE                     DCMI_IER_ERR_IE_Msk
#define DCMI_IER_VSYNC_IE_Pos               (3U)
#define DCMI_IER_VSYNC_IE_Msk               (0x1UL << DCMI_IER_VSYNC_IE_Pos)        /*!< 0x00000008 */
#define DCMI_IER_VSYNC_IE                   DCMI_IER_VSYNC_IE_Msk
#define DCMI_IER_LINE_IE_Pos                (4U)
#define DCMI_IER_LINE_IE_Msk                (0x1UL << DCMI_IER_LINE_IE_Pos)         /*!< 0x00000010 */
#define DCMI_IER_LINE_IE                    DCMI_IER_LINE_IE_Msk

/********************  Bits definition for DCMI_MIS register  *****************/
#define DCMI_MIS_FRAME_MIS_Pos              (0U)
#define DCMI_MIS_FRAME_MIS_Msk              (0x1UL << DCMI_MIS_FRAME_MIS_Pos)       /*!< 0x00000001 */
#define DCMI_MIS_FRAME_MIS                  DCMI_MIS_FRAME_MIS_Msk
#define DCMI_MIS_OVR_MIS_Pos                (1U)
#define DCMI_MIS_OVR_MIS_Msk                (0x1UL << DCMI_MIS_OVR_MIS_Pos)         /*!< 0x00000002 */
#define DCMI_MIS_OVR_MIS                    DCMI_MIS_OVR_MIS_Msk
#define DCMI_MIS_ERR_MIS_Pos                (2U)
#define DCMI_MIS_ERR_MIS_Msk                (0x1UL << DCMI_MIS_ERR_MIS_Pos)         /*!< 0x00000004 */
#define DCMI_MIS_ERR_MIS                    DCMI_MIS_ERR_MIS_Msk
#define DCMI_MIS_VSYNC_MIS_Pos              (3U)
#define DCMI_MIS_VSYNC_MIS_Msk              (0x1UL << DCMI_MIS_VSYNC_MIS_Pos)       /*!< 0x00000008 */
#define DCMI_MIS_VSYNC_MIS                  DCMI_MIS_VSYNC_MIS_Msk
#define DCMI_MIS_LINE_MIS_Pos               (4U)
#define DCMI_MIS_LINE_MIS_Msk               (0x1UL << DCMI_MIS_LINE_MIS_Pos)        /*!< 0x00000010 */
#define DCMI_MIS_LINE_MIS                   DCMI_MIS_LINE_MIS_Msk

/********************  Bits definition for DCMI_ICR register  *****************/
#define DCMI_ICR_FRAME_ISC_Pos              (0U)
#define DCMI_ICR_FRAME_ISC_Msk              (0x1UL << DCMI_ICR_FRAME_ISC_Pos)       /*!< 0x00000001 */
#define DCMI_ICR_FRAME_ISC                  DCMI_ICR_FRAME_ISC_Msk
#define DCMI_ICR_OVR_ISC_Pos                (1U)
#define DCMI_ICR_OVR_ISC_Msk                (0x1UL << DCMI_ICR_OVR_ISC_Pos)         /*!< 0x00000002 */
#define DCMI_ICR_OVR_ISC                    DCMI_ICR_OVR_ISC_Msk
#define DCMI_ICR_ERR_ISC_Pos                (2U)
#define DCMI_ICR_ERR_ISC_Msk                (0x1UL << DCMI_ICR_ERR_ISC_Pos)         /*!< 0x00000004 */
#define DCMI_ICR_ERR_ISC                    DCMI_ICR_ERR_ISC_Msk
#define DCMI_ICR_VSYNC_ISC_Pos              (3U)
#define DCMI_ICR_VSYNC_ISC_Msk              (0x1UL << DCMI_ICR_VSYNC_ISC_Pos)       /*!< 0x00000008 */
#define DCMI_ICR_VSYNC_ISC                  DCMI_ICR_VSYNC_ISC_Msk
#define DCMI_ICR_LINE_ISC_Pos               (4U)
#define DCMI_ICR_LINE_ISC_Msk               (0x1UL << DCMI_ICR_LINE_ISC_Pos)        /*!< 0x00000010 */
#define DCMI_ICR_LINE_ISC                   DCMI_ICR_LINE_ISC_Msk

/********************  Bits definition for DCMI_ESCR register  ******************/
#define DCMI_ESCR_FSC_Pos                   (0U)
#define DCMI_ESCR_FSC_Msk                   (0xFFUL << DCMI_ESCR_FSC_Pos)           /*!< 0x000000FF */
#define DCMI_ESCR_FSC                       DCMI_ESCR_FSC_Msk
#define DCMI_ESCR_LSC_Pos                   (8U)
#define DCMI_ESCR_LSC_Msk                   (0xFFUL << DCMI_ESCR_LSC_Pos)           /*!< 0x0000FF00 */
#define DCMI_ESCR_LSC                       DCMI_ESCR_LSC_Msk
#define DCMI_ESCR_LEC_Pos                   (16U)
#define DCMI_ESCR_LEC_Msk                   (0xFFUL << DCMI_ESCR_LEC_Pos)           /*!< 0x00FF0000 */
#define DCMI_ESCR_LEC                       DCMI_ESCR_LEC_Msk
#define DCMI_ESCR_FEC_Pos                   (24U)
#define DCMI_ESCR_FEC_Msk                   (0xFFUL << DCMI_ESCR_FEC_Pos)           /*!< 0xFF000000 */
#define DCMI_ESCR_FEC                       DCMI_ESCR_FEC_Msk

/********************  Bits definition for DCMI_ESUR register  ******************/
#define DCMI_ESUR_FSU_Pos                   (0U)
#define DCMI_ESUR_FSU_Msk                   (0xFFUL << DCMI_ESUR_FSU_Pos)           /*!< 0x000000FF */
#define DCMI_ESUR_FSU                       DCMI_ESUR_FSU_Msk
#define DCMI_ESUR_LSU_Pos                   (8U)
#define DCMI_ESUR_LSU_Msk                   (0xFFUL << DCMI_ESUR_LSU_Pos)           /*!< 0x0000FF00 */
#define DCMI_ESUR_LSU                       DCMI_ESUR_LSU_Msk
#define DCMI_ESUR_LEU_Pos                   (16U)
#define DCMI_ESUR_LEU_Msk                   (0xFFUL << DCMI_ESUR_LEU_Pos)           /*!< 0x00FF0000 */
#define DCMI_ESUR_LEU                       DCMI_ESUR_LEU_Msk
#define DCMI_ESUR_FEU_Pos                   (24U)
#define DCMI_ESUR_FEU_Msk                   (0xFFUL << DCMI_ESUR_FEU_Pos)           /*!< 0xFF000000 */
#define DCMI_ESUR_FEU                       DCMI_ESUR_FEU_Msk

/********************  Bits definition for DCMI_CWSTRT register  ******************/
#define DCMI_CWSTRT_HOFFCNT_Pos             (0U)
#define DCMI_CWSTRT_HOFFCNT_Msk             (0x3FFFUL << DCMI_CWSTRT_HOFFCNT_Pos)   /*!< 0x00003FFF */
#define DCMI_CWSTRT_HOFFCNT                 DCMI_CWSTRT_HOFFCNT_Msk
#define DCMI_CWSTRT_VST_Pos                 (16U)
#define DCMI_CWSTRT_VST_Msk                 (0x1FFFUL << DCMI_CWSTRT_VST_Pos)       /*!< 0x1FFF0000 */
#define DCMI_CWSTRT_VST                     DCMI_CWSTRT_VST_Msk

/********************  Bits definition for DCMI_CWSIZE register  ******************/
#define DCMI_CWSIZE_CAPCNT_Pos              (0U)
#define DCMI_CWSIZE_CAPCNT_Msk              (0x3FFFUL << DCMI_CWSIZE_CAPCNT_Pos)    /*!< 0x00003FFF */
#define DCMI_CWSIZE_CAPCNT                  DCMI_CWSIZE_CAPCNT_Msk
#define DCMI_CWSIZE_VLINE_Pos               (16U)
#define DCMI_CWSIZE_VLINE_Msk               (0x3FFFUL << DCMI_CWSIZE_VLINE_Pos)     /*!< 0x3FFF0000 */
#define DCMI_CWSIZE_VLINE                   DCMI_CWSIZE_VLINE_Msk

/********************  Bits definition for DCMI_DR register  ******************/
#define DCMI_DR_BYTE0_Pos                   (0U)
#define DCMI_DR_BYTE0_Msk                   (0xFFUL << DCMI_DR_BYTE0_Pos)           /*!< 0x000000FF */
#define DCMI_DR_BYTE0                       DCMI_DR_BYTE0_Msk
#define DCMI_DR_BYTE1_Pos                   (8U)
#define DCMI_DR_BYTE1_Msk                   (0xFFUL << DCMI_DR_BYTE1_Pos)           /*!< 0x0000FF00 */
#define DCMI_DR_BYTE1                       DCMI_DR_BYTE1_Msk
#define DCMI_DR_BYTE2_Pos                   (16U)
#define DCMI_DR_BYTE2_Msk                   (0xFFUL << DCMI_DR_BYTE2_Pos)           /*!< 0x00FF0000 */
#define DCMI_DR_BYTE2                       DCMI_DR_BYTE2_Msk
#define DCMI_DR_BYTE3_Pos                   (24U)
#define DCMI_DR_BYTE3_Msk                   (0xFFUL << DCMI_DR_BYTE3_Pos)           /*!< 0xFF000000 */
#define DCMI_DR_BYTE3                       DCMI_DR_BYTE3_Msk

/******************************************************************************/
/*                                                                            */
/*                           DMA Controller (DMA)                             */
/*                                                                            */
/******************************************************************************/
/************************  DMA Trigger Signals Support  ***********************/
#define TIM3_TRGO_TRIGGER_SUPPORT /* TIM3 TRGO HW signal support  */
#define TIM4_TRGO_TRIGGER_SUPPORT /* TIM4 TRGO HW signal support  */
#define TIM5_TRGO_TRIGGER_SUPPORT /* TIM5 TRGO HW signal support  */
#define DMA2D_TRIGGER_SUPPORT     /* DMA2D TRGO HW signal support */
/*******************  Bit definition for DMA_SECCFGR register  ****************/
#define DMA_SECCFGR_SEC0_Pos                (0U)
#define DMA_SECCFGR_SEC0_Msk                (0x1UL << DMA_SECCFGR_SEC0_Pos)         /*!< 0x00000001 */
#define DMA_SECCFGR_SEC0                    DMA_SECCFGR_SEC0_Msk                    /*!< Secure State of Channel 0  */
#define DMA_SECCFGR_SEC1_Pos                (1U)
#define DMA_SECCFGR_SEC1_Msk                (0x1UL << DMA_SECCFGR_SEC1_Pos)         /*!< 0x00000002 */
#define DMA_SECCFGR_SEC1                    DMA_SECCFGR_SEC1_Msk                    /*!< Secure State of Channel 1  */
#define DMA_SECCFGR_SEC2_Pos                (2U)
#define DMA_SECCFGR_SEC2_Msk                (0x1UL << DMA_SECCFGR_SEC2_Pos)         /*!< 0x00000004 */
#define DMA_SECCFGR_SEC2                    DMA_SECCFGR_SEC2_Msk                    /*!< Secure State of Channel 2  */
#define DMA_SECCFGR_SEC3_Pos                (3U)
#define DMA_SECCFGR_SEC3_Msk                (0x1UL << DMA_SECCFGR_SEC3_Pos)         /*!< 0x00000008 */
#define DMA_SECCFGR_SEC3                    DMA_SECCFGR_SEC3_Msk                    /*!< Secure State of Channel 3  */
#define DMA_SECCFGR_SEC4_Pos                (4U)
#define DMA_SECCFGR_SEC4_Msk                (0x1UL << DMA_SECCFGR_SEC4_Pos)         /*!< 0x00000010 */
#define DMA_SECCFGR_SEC4                    DMA_SECCFGR_SEC4_Msk                    /*!< Secure State of Channel 4  */
#define DMA_SECCFGR_SEC5_Pos                (5U)
#define DMA_SECCFGR_SEC5_Msk                (0x1UL << DMA_SECCFGR_SEC5_Pos)         /*!< 0x00000020 */
#define DMA_SECCFGR_SEC5                    DMA_SECCFGR_SEC5_Msk                    /*!< Secure State of Channel 5  */
#define DMA_SECCFGR_SEC6_Pos                (6U)
#define DMA_SECCFGR_SEC6_Msk                (0x1UL << DMA_SECCFGR_SEC6_Pos)         /*!< 0x00000040 */
#define DMA_SECCFGR_SEC6                    DMA_SECCFGR_SEC6_Msk                    /*!< Secure State of Channel 6  */
#define DMA_SECCFGR_SEC7_Pos                (7U)
#define DMA_SECCFGR_SEC7_Msk                (0x1UL << DMA_SECCFGR_SEC7_Pos)         /*!< 0x00000080 */
#define DMA_SECCFGR_SEC7                    DMA_SECCFGR_SEC7_Msk                    /*!< Secure State of Channel 7  */
#define DMA_SECCFGR_SEC8_Pos                (8U)
#define DMA_SECCFGR_SEC8_Msk                (0x1UL << DMA_SECCFGR_SEC8_Pos)         /*!< 0x00000100 */
#define DMA_SECCFGR_SEC8                    DMA_SECCFGR_SEC8_Msk                    /*!< Secure State of Channel 8  */
#define DMA_SECCFGR_SEC9_Pos                (9U)
#define DMA_SECCFGR_SEC9_Msk                (0x1UL << DMA_SECCFGR_SEC9_Pos)         /*!< 0x00000200 */
#define DMA_SECCFGR_SEC9                    DMA_SECCFGR_SEC9_Msk                    /*!< Secure State of Channel 9  */
#define DMA_SECCFGR_SEC10_Pos               (10U)
#define DMA_SECCFGR_SEC10_Msk               (0x1UL << DMA_SECCFGR_SEC10_Pos)        /*!< 0x00000400 */
#define DMA_SECCFGR_SEC10                   DMA_SECCFGR_SEC10_Msk                   /*!< Secure State of Channel 10 */
#define DMA_SECCFGR_SEC11_Pos               (11U)
#define DMA_SECCFGR_SEC11_Msk               (0x1UL << DMA_SECCFGR_SEC11_Pos)        /*!< 0x00000800 */
#define DMA_SECCFGR_SEC11                   DMA_SECCFGR_SEC11_Msk                   /*!< Secure State of Channel 11 */
#define DMA_SECCFGR_SEC12_Pos               (12U)
#define DMA_SECCFGR_SEC12_Msk               (0x1UL << DMA_SECCFGR_SEC12_Pos)        /*!< 0x00001000 */
#define DMA_SECCFGR_SEC12                   DMA_SECCFGR_SEC12_Msk                   /*!< Secure State of Channel 12 */
#define DMA_SECCFGR_SEC13_Pos               (13U)
#define DMA_SECCFGR_SEC13_Msk               (0x1UL << DMA_SECCFGR_SEC13_Pos)        /*!< 0x00002000 */
#define DMA_SECCFGR_SEC13                   DMA_SECCFGR_SEC13_Msk                   /*!< Secure State of Channel 13 */
#define DMA_SECCFGR_SEC14_Pos               (14U)
#define DMA_SECCFGR_SEC14_Msk               (0x1UL << DMA_SECCFGR_SEC14_Pos)        /*!< 0x00004000 */
#define DMA_SECCFGR_SEC14                   DMA_SECCFGR_SEC14_Msk                   /*!< Secure State of Channel 14 */
#define DMA_SECCFGR_SEC15_Pos               (15U)
#define DMA_SECCFGR_SEC15_Msk               (0x1UL << DMA_SECCFGR_SEC15_Pos)        /*!< 0x00008000 */
#define DMA_SECCFGR_SEC15                   DMA_SECCFGR_SEC15_Msk                   /*!< Secure State of Channel 15 */

/*******************  Bit definition for DMA_PRIVCFGR register  ****************/
#define DMA_PRIVCFGR_PRIV0_Pos              (0U)
#define DMA_PRIVCFGR_PRIV0_Msk              (0x1UL << DMA_PRIVCFGR_PRIV0_Pos)       /*!< 0x00000001 */
#define DMA_PRIVCFGR_PRIV0                  DMA_PRIVCFGR_PRIV0_Msk                  /*!< Privileged State of Channel 0  */
#define DMA_PRIVCFGR_PRIV1_Pos              (1U)
#define DMA_PRIVCFGR_PRIV1_Msk              (0x1UL << DMA_PRIVCFGR_PRIV1_Pos)       /*!< 0x00000002 */
#define DMA_PRIVCFGR_PRIV1                  DMA_PRIVCFGR_PRIV1_Msk                  /*!< Privileged State of Channel 1  */
#define DMA_PRIVCFGR_PRIV2_Pos              (2U)
#define DMA_PRIVCFGR_PRIV2_Msk              (0x1UL << DMA_PRIVCFGR_PRIV2_Pos)       /*!< 0x00000004 */
#define DMA_PRIVCFGR_PRIV2                  DMA_PRIVCFGR_PRIV2_Msk                  /*!< Privileged State of Channel 2  */
#define DMA_PRIVCFGR_PRIV3_Pos              (3U)
#define DMA_PRIVCFGR_PRIV3_Msk              (0x1UL << DMA_PRIVCFGR_PRIV3_Pos)       /*!< 0x00000008 */
#define DMA_PRIVCFGR_PRIV3                  DMA_PRIVCFGR_PRIV3_Msk                  /*!< Privileged State of Channel 3  */
#define DMA_PRIVCFGR_PRIV4_Pos              (4U)
#define DMA_PRIVCFGR_PRIV4_Msk              (0x1UL << DMA_PRIVCFGR_PRIV4_Pos)       /*!< 0x00000010 */
#define DMA_PRIVCFGR_PRIV4                  DMA_PRIVCFGR_PRIV4_Msk                  /*!< Privileged State of Channel 4  */
#define DMA_PRIVCFGR_PRIV5_Pos              (5U)
#define DMA_PRIVCFGR_PRIV5_Msk              (0x1UL << DMA_PRIVCFGR_PRIV5_Pos)       /*!< 0x00000020 */
#define DMA_PRIVCFGR_PRIV5                  DMA_PRIVCFGR_PRIV5_Msk                  /*!< Privileged State of Channel 5  */
#define DMA_PRIVCFGR_PRIV6_Pos              (6U)
#define DMA_PRIVCFGR_PRIV6_Msk              (0x1UL << DMA_PRIVCFGR_PRIV6_Pos)       /*!< 0x00000040 */
#define DMA_PRIVCFGR_PRIV6                  DMA_PRIVCFGR_PRIV6_Msk                  /*!< Privileged State of Channel 6  */
#define DMA_PRIVCFGR_PRIV7_Pos              (7U)
#define DMA_PRIVCFGR_PRIV7_Msk              (0x1UL << DMA_PRIVCFGR_PRIV7_Pos)       /*!< 0x00000080 */
#define DMA_PRIVCFGR_PRIV7                  DMA_PRIVCFGR_PRIV7_Msk                  /*!< Privileged State of Channel 7  */
#define DMA_PRIVCFGR_PRIV8_Pos              (8U)
#define DMA_PRIVCFGR_PRIV8_Msk              (0x1UL << DMA_PRIVCFGR_PRIV8_Pos)       /*!< 0x00000100 */
#define DMA_PRIVCFGR_PRIV8                  DMA_PRIVCFGR_PRIV8_Msk                  /*!< Privileged State of Channel 8  */
#define DMA_PRIVCFGR_PRIV9_Pos              (9U)
#define DMA_PRIVCFGR_PRIV9_Msk              (0x1UL << DMA_PRIVCFGR_PRIV9_Pos)       /*!< 0x00000200 */
#define DMA_PRIVCFGR_PRIV9                  DMA_PRIVCFGR_PRIV9_Msk                  /*!< Privileged State of Channel 9  */
#define DMA_PRIVCFGR_PRIV10_Pos             (10U)
#define DMA_PRIVCFGR_PRIV10_Msk             (0x1UL << DMA_PRIVCFGR_PRIV10_Pos)      /*!< 0x00000400 */
#define DMA_PRIVCFGR_PRIV10                 DMA_PRIVCFGR_PRIV10_Msk                 /*!< Privileged State of Channel 10 */
#define DMA_PRIVCFGR_PRIV11_Pos             (11U)
#define DMA_PRIVCFGR_PRIV11_Msk             (0x1UL << DMA_PRIVCFGR_PRIV11_Pos)      /*!< 0x00000800 */
#define DMA_PRIVCFGR_PRIV11                 DMA_PRIVCFGR_PRIV11_Msk                 /*!< Privileged State of Channel 11 */
#define DMA_PRIVCFGR_PRIV12_Pos             (12U)
#define DMA_PRIVCFGR_PRIV12_Msk             (0x1UL << DMA_PRIVCFGR_PRIV12_Pos)      /*!< 0x00001000 */
#define DMA_PRIVCFGR_PRIV12                 DMA_PRIVCFGR_PRIV12_Msk                 /*!< Privileged State of Channel 12 */
#define DMA_PRIVCFGR_PRIV13_Pos             (13U)
#define DMA_PRIVCFGR_PRIV13_Msk             (0x1UL << DMA_PRIVCFGR_PRIV13_Pos)      /*!< 0x00002000 */
#define DMA_PRIVCFGR_PRIV13                 DMA_PRIVCFGR_PRIV13_Msk                 /*!< Privileged State of Channel 13 */
#define DMA_PRIVCFGR_PRIV14_Pos             (14U)
#define DMA_PRIVCFGR_PRIV14_Msk             (0x1UL << DMA_PRIVCFGR_PRIV14_Pos)      /*!< 0x00004000 */
#define DMA_PRIVCFGR_PRIV14                 DMA_PRIVCFGR_PRIV14_Msk                 /*!< Privileged State of Channel 14 */
#define DMA_PRIVCFGR_PRIV15_Pos             (15U)
#define DMA_PRIVCFGR_PRIV15_Msk             (0x1UL << DMA_PRIVCFGR_PRIV15_Pos)      /*!< 0x00008000 */
#define DMA_PRIVCFGR_PRIV15                 DMA_PRIVCFGR_PRIV15_Msk                 /*!< Privileged State of Channel 15 */

/*******************  Bit definition for DMA_RCFGLOCKR register  ****************/
#define DMA_RCFGLOCKR_LOCK0_Pos              (0U)
#define DMA_RCFGLOCKR_LOCK0_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK0_Pos)       /*!< 0x00000001 */
#define DMA_RCFGLOCKR_LOCK0                  DMA_RCFGLOCKR_LOCK0_Msk                  /*!< Lock the configuration of Channel 0  */
#define DMA_RCFGLOCKR_LOCK1_Pos              (1U)
#define DMA_RCFGLOCKR_LOCK1_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK1_Pos)       /*!< 0x00000002 */
#define DMA_RCFGLOCKR_LOCK1                  DMA_RCFGLOCKR_LOCK1_Msk                  /*!< Lock the configuration of Channel 1  */
#define DMA_RCFGLOCKR_LOCK2_Pos              (2U)
#define DMA_RCFGLOCKR_LOCK2_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK2_Pos)       /*!< 0x00000004 */
#define DMA_RCFGLOCKR_LOCK2                  DMA_RCFGLOCKR_LOCK2_Msk                  /*!< Lock the configuration of Channel 2  */
#define DMA_RCFGLOCKR_LOCK3_Pos              (3U)
#define DMA_RCFGLOCKR_LOCK3_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK3_Pos)       /*!< 0x00000008 */
#define DMA_RCFGLOCKR_LOCK3                  DMA_RCFGLOCKR_LOCK3_Msk                  /*!< Lock the configuration of Channel 3  */
#define DMA_RCFGLOCKR_LOCK4_Pos              (4U)
#define DMA_RCFGLOCKR_LOCK4_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK4_Pos)       /*!< 0x00000010 */
#define DMA_RCFGLOCKR_LOCK4                  DMA_RCFGLOCKR_LOCK4_Msk                  /*!< Lock the configuration of Channel 4  */
#define DMA_RCFGLOCKR_LOCK5_Pos              (5U)
#define DMA_RCFGLOCKR_LOCK5_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK5_Pos)       /*!< 0x00000020 */
#define DMA_RCFGLOCKR_LOCK5                  DMA_RCFGLOCKR_LOCK5_Msk                  /*!< Lock the configuration of Channel 5  */
#define DMA_RCFGLOCKR_LOCK6_Pos              (6U)
#define DMA_RCFGLOCKR_LOCK6_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK6_Pos)       /*!< 0x00000040 */
#define DMA_RCFGLOCKR_LOCK6                  DMA_RCFGLOCKR_LOCK6_Msk                  /*!< Lock the configuration of Channel 6  */
#define DMA_RCFGLOCKR_LOCK7_Pos              (7U)
#define DMA_RCFGLOCKR_LOCK7_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK7_Pos)       /*!< 0x00000080 */
#define DMA_RCFGLOCKR_LOCK7                  DMA_RCFGLOCKR_LOCK7_Msk                  /*!< Lock the configuration of Channel 7  */
#define DMA_RCFGLOCKR_LOCK8_Pos              (8U)
#define DMA_RCFGLOCKR_LOCK8_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK8_Pos)       /*!< 0x00000100 */
#define DMA_RCFGLOCKR_LOCK8                  DMA_RCFGLOCKR_LOCK8_Msk                  /*!< Lock the configuration of Channel 8  */
#define DMA_RCFGLOCKR_LOCK9_Pos              (9U)
#define DMA_RCFGLOCKR_LOCK9_Msk              (0x1UL << DMA_RCFGLOCKR_LOCK9_Pos)       /*!< 0x00000200 */
#define DMA_RCFGLOCKR_LOCK9                  DMA_RCFGLOCKR_LOCK9_Msk                  /*!< Lock the configuration of Channel 9  */
#define DMA_RCFGLOCKR_LOCK10_Pos             (10U)
#define DMA_RCFGLOCKR_LOCK10_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK10_Pos)      /*!< 0x00000400 */
#define DMA_RCFGLOCKR_LOCK10                 DMA_RCFGLOCKR_LOCK10_Msk                 /*!< Lock the configuration of Channel 10 */
#define DMA_RCFGLOCKR_LOCK11_Pos             (11U)
#define DMA_RCFGLOCKR_LOCK11_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK11_Pos)      /*!< 0x00000800 */
#define DMA_RCFGLOCKR_LOCK11                 DMA_RCFGLOCKR_LOCK11_Msk                 /*!< Lock the configuration of Channel 11 */
#define DMA_RCFGLOCKR_LOCK12_Pos             (12U)
#define DMA_RCFGLOCKR_LOCK12_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK12_Pos)      /*!< 0x00001000 */
#define DMA_RCFGLOCKR_LOCK12                 DMA_RCFGLOCKR_LOCK12_Msk                 /*!< Lock the configuration of Channel 12 */
#define DMA_RCFGLOCKR_LOCK13_Pos             (13U)
#define DMA_RCFGLOCKR_LOCK13_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK13_Pos)      /*!< 0x00002000 */
#define DMA_RCFGLOCKR_LOCK13                 DMA_RCFGLOCKR_LOCK13_Msk                 /*!< Lock the configuration of Channel 13 */
#define DMA_RCFGLOCKR_LOCK14_Pos             (14U)
#define DMA_RCFGLOCKR_LOCK14_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK14_Pos)      /*!< 0x00004000 */
#define DMA_RCFGLOCKR_LOCK14                 DMA_RCFGLOCKR_LOCK14_Msk                 /*!< Lock the configuration of Channel 14 */
#define DMA_RCFGLOCKR_LOCK15_Pos             (15U)
#define DMA_RCFGLOCKR_LOCK15_Msk             (0x1UL << DMA_RCFGLOCKR_LOCK15_Pos)      /*!< 0x00008000 */
#define DMA_RCFGLOCKR_LOCK15                 DMA_RCFGLOCKR_LOCK15_Msk                 /*!< Lock the configuration of Channel 15 */

/*******************  Bit definition for DMA_MISR register  ****************/
#define DMA_MISR_MIS0_Pos                   (0U)
#define DMA_MISR_MIS0_Msk                   (0x1UL << DMA_MISR_MIS0_Pos)            /*!< 0x00000001 */
#define DMA_MISR_MIS0                       DMA_MISR_MIS0_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 0  */
#define DMA_MISR_MIS1_Pos                   (1U)
#define DMA_MISR_MIS1_Msk                   (0x1UL << DMA_MISR_MIS1_Pos)            /*!< 0x00000002 */
#define DMA_MISR_MIS1                       DMA_MISR_MIS1_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 1  */
#define DMA_MISR_MIS2_Pos                   (2U)
#define DMA_MISR_MIS2_Msk                   (0x1UL << DMA_MISR_MIS2_Pos)            /*!< 0x00000004 */
#define DMA_MISR_MIS2                       DMA_MISR_MIS2_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 2  */
#define DMA_MISR_MIS3_Pos                   (3U)
#define DMA_MISR_MIS3_Msk                   (0x1UL << DMA_MISR_MIS3_Pos)            /*!< 0x00000008 */
#define DMA_MISR_MIS3                       DMA_MISR_MIS3_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 3  */
#define DMA_MISR_MIS4_Pos                   (4U)
#define DMA_MISR_MIS4_Msk                   (0x1UL << DMA_MISR_MIS4_Pos)            /*!< 0x00000010 */
#define DMA_MISR_MIS4                       DMA_MISR_MIS4_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 4  */
#define DMA_MISR_MIS5_Pos                   (5U)
#define DMA_MISR_MIS5_Msk                   (0x1UL << DMA_MISR_MIS5_Pos)            /*!< 0x00000020 */
#define DMA_MISR_MIS5                       DMA_MISR_MIS5_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 5  */
#define DMA_MISR_MIS6_Pos                   (6U)
#define DMA_MISR_MIS6_Msk                   (0x1UL << DMA_MISR_MIS6_Pos)            /*!< 0x00000040 */
#define DMA_MISR_MIS6                       DMA_MISR_MIS6_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 6  */
#define DMA_MISR_MIS7_Pos                   (7U)
#define DMA_MISR_MIS7_Msk                   (0x1UL << DMA_MISR_MIS7_Pos)            /*!< 0x00000080 */
#define DMA_MISR_MIS7                       DMA_MISR_MIS7_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 7  */
#define DMA_MISR_MIS8_Pos                   (8U)
#define DMA_MISR_MIS8_Msk                   (0x1UL << DMA_MISR_MIS8_Pos)            /*!< 0x00000100 */
#define DMA_MISR_MIS8                       DMA_MISR_MIS8_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 8  */
#define DMA_MISR_MIS9_Pos                   (9U)
#define DMA_MISR_MIS9_Msk                   (0x1UL << DMA_MISR_MIS9_Pos)            /*!< 0x00000200 */
#define DMA_MISR_MIS9                       DMA_MISR_MIS9_Msk                       /*!< Masked Interrupt State of Non-Secure Channel 9  */
#define DMA_MISR_MIS10_Pos                  (10U)
#define DMA_MISR_MIS10_Msk                  (0x1UL << DMA_MISR_MIS10_Pos)           /*!< 0x00000400 */
#define DMA_MISR_MIS10                      DMA_MISR_MIS10_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 10 */
#define DMA_MISR_MIS11_Pos                  (11U)
#define DMA_MISR_MIS11_Msk                  (0x1UL << DMA_MISR_MIS11_Pos)           /*!< 0x00000800 */
#define DMA_MISR_MIS11                      DMA_MISR_MIS11_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 11 */
#define DMA_MISR_MIS12_Pos                  (12U)
#define DMA_MISR_MIS12_Msk                  (0x1UL << DMA_MISR_MIS12_Pos)           /*!< 0x00001000 */
#define DMA_MISR_MIS12                      DMA_MISR_MIS12_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 12 */
#define DMA_MISR_MIS13_Pos                  (13U)
#define DMA_MISR_MIS13_Msk                  (0x1UL << DMA_MISR_MIS13_Pos)           /*!< 0x00002000 */
#define DMA_MISR_MIS13                      DMA_MISR_MIS13_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 13 */
#define DMA_MISR_MIS14_Pos                  (14U)
#define DMA_MISR_MIS14_Msk                  (0x1UL << DMA_MISR_MIS14_Pos)           /*!< 0x00004000 */
#define DMA_MISR_MIS14                      DMA_MISR_MIS14_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 14 */
#define DMA_MISR_MIS15_Pos                  (15U)
#define DMA_MISR_MIS15_Msk                  (0x1UL << DMA_MISR_MIS15_Pos)           /*!< 0x00008000 */
#define DMA_MISR_MIS15                      DMA_MISR_MIS14_Msk                      /*!< Masked Interrupt State of Non-Secure Channel 15 */

/*******************  Bit definition for DMA_SMISR register  ****************/
#define DMA_SMISR_MIS0_Pos                  (0U)
#define DMA_SMISR_MIS0_Msk                  (0x1UL << DMA_SMISR_MIS0_Pos)           /*!< 0x00000001 */
#define DMA_SMISR_MIS0                      DMA_SMISR_MIS0_Msk                      /*!< Masked Interrupt State of Secure Channel 0  */
#define DMA_SMISR_MIS1_Pos                  (1U)
#define DMA_SMISR_MIS1_Msk                  (0x1UL << DMA_SMISR_MIS1_Pos)           /*!< 0x00000002 */
#define DMA_SMISR_MIS1                      DMA_SMISR_MIS1_Msk                      /*!< Masked Interrupt State of Secure Channel 1  */
#define DMA_SMISR_MIS2_Pos                  (2U)
#define DMA_SMISR_MIS2_Msk                  (0x1UL << DMA_SMISR_MIS2_Pos)           /*!< 0x00000004 */
#define DMA_SMISR_MIS2                      DMA_SMISR_MIS2_Msk                      /*!< Masked Interrupt State of Secure Channel 2  */
#define DMA_SMISR_MIS3_Pos                  (3U)
#define DMA_SMISR_MIS3_Msk                  (0x1UL << DMA_SMISR_MIS3_Pos)           /*!< 0x00000008 */
#define DMA_SMISR_MIS3                      DMA_SMISR_MIS3_Msk                      /*!< Masked Interrupt State of Secure Channel 3  */
#define DMA_SMISR_MIS4_Pos                  (4U)
#define DMA_SMISR_MIS4_Msk                  (0x1UL << DMA_SMISR_MIS4_Pos)           /*!< 0x00000010 */
#define DMA_SMISR_MIS4                      DMA_SMISR_MIS4_Msk                      /*!< Masked Interrupt State of Secure Channel 4  */
#define DMA_SMISR_MIS5_Pos                  (5U)
#define DMA_SMISR_MIS5_Msk                  (0x1UL << DMA_SMISR_MIS5_Pos)           /*!< 0x00000020 */
#define DMA_SMISR_MIS5                      DMA_SMISR_MIS5_Msk                      /*!< Masked Interrupt State of Secure Channel 5  */
#define DMA_SMISR_MIS6_Pos                  (6U)
#define DMA_SMISR_MIS6_Msk                  (0x1UL << DMA_SMISR_MIS6_Pos)           /*!< 0x00000040 */
#define DMA_SMISR_MIS6                      DMA_SMISR_MIS6_Msk                      /*!< Masked Interrupt State of Secure Channel 6  */
#define DMA_SMISR_MIS7_Pos                  (7U)
#define DMA_SMISR_MIS7_Msk                  (0x1UL << DMA_SMISR_MIS7_Pos)           /*!< 0x00000080 */
#define DMA_SMISR_MIS7                      DMA_SMISR_MIS7_Msk                      /*!< Masked Interrupt State of Secure Channel 7  */
#define DMA_SMISR_MIS8_Pos                  (8U)
#define DMA_SMISR_MIS8_Msk                  (0x1UL << DMA_SMISR_MIS8_Pos)           /*!< 0x00000100 */
#define DMA_SMISR_MIS8                      DMA_SMISR_MIS8_Msk                      /*!< Masked Interrupt State of Secure Channel 8  */
#define DMA_SMISR_MIS9_Pos                  (9U)
#define DMA_SMISR_MIS9_Msk                  (0x1UL << DMA_SMISR_MIS9_Pos)           /*!< 0x00000200 */
#define DMA_SMISR_MIS9                      DMA_SMISR_MIS9_Msk                      /*!< Masked Interrupt State of Secure Channel 9  */
#define DMA_SMISR_MIS10_Pos                 (10U)
#define DMA_SMISR_MIS10_Msk                 (0x1UL << DMA_SMISR_MIS10_Pos)          /*!< 0x00000400 */
#define DMA_SMISR_MIS10                     DMA_SMISR_MIS10_Msk                     /*!< Masked Interrupt State of Secure Channel 10 */
#define DMA_SMISR_MIS11_Pos                 (11U)
#define DMA_SMISR_MIS11_Msk                 (0x1UL << DMA_SMISR_MIS11_Pos)          /*!< 0x00000800 */
#define DMA_SMISR_MIS11                     DMA_SMISR_MIS11_Msk                     /*!< Masked Interrupt State of Secure Channel 11 */
#define DMA_SMISR_MIS12_Pos                 (12U)
#define DMA_SMISR_MIS12_Msk                 (0x1UL << DMA_SMISR_MIS12_Pos)          /*!< 0x00001000 */
#define DMA_SMISR_MIS12                     DMA_SMISR_MIS12_Msk                     /*!< Masked Interrupt State of Secure Channel 12 */
#define DMA_SMISR_MIS13_Pos                 (13U)
#define DMA_SMISR_MIS13_Msk                 (0x1UL << DMA_SMISR_MIS13_Pos)          /*!< 0x00002000 */
#define DMA_SMISR_MIS13                     DMA_SMISR_MIS13_Msk                     /*!< Masked Interrupt State of Secure Channel 13 */
#define DMA_SMISR_MIS14_Pos                 (14U)
#define DMA_SMISR_MIS14_Msk                 (0x1UL << DMA_SMISR_MIS14_Pos)          /*!< 0x00004000 */
#define DMA_SMISR_MIS14                     DMA_SMISR_MIS14_Msk                     /*!< Masked Interrupt State of Secure Channel 14 */
#define DMA_SMISR_MIS15_Pos                 (15U)
#define DMA_SMISR_MIS15_Msk                 (0x1UL << DMA_SMISR_MIS15_Pos)          /*!< 0x00008000 */
#define DMA_SMISR_MIS15                     DMA_SMISR_MIS14_Msk                     /*!< Masked Interrupt State of Secure Channel 15 */

/*******************  Bit definition for DMA_CLBAR register  ****************/
#define DMA_CLBAR_LBA_Pos                   (16U)
#define DMA_CLBAR_LBA_Msk                   (0xFFFFUL << DMA_CLBAR_LBA_Pos)         /*!< 0xFFFF0000 */
#define DMA_CLBAR_LBA                       DMA_CLBAR_LBA_Msk                       /*!< Linked-list Base Address of DMA channel x */

/*******************  Bit definition for DMA_CFCR register  *******************/
#define DMA_CFCR_TCF_Pos                    (8U)
#define DMA_CFCR_TCF_Msk                    (0x1UL << DMA_CFCR_TCF_Pos)             /*!< 0x00000100 */
#define DMA_CFCR_TCF                        DMA_CFCR_TCF_Msk                        /*!< Transfer complete flag clear             */
#define DMA_CFCR_HTF_Pos                    (9U)
#define DMA_CFCR_HTF_Msk                    (0x1UL << DMA_CFCR_HTF_Pos)             /*!< 0x00000200 */
#define DMA_CFCR_HTF                        DMA_CFCR_HTF_Msk                        /*!< Half transfer complete flag clear        */
#define DMA_CFCR_DTEF_Pos                   (10U)
#define DMA_CFCR_DTEF_Msk                   (0x1UL << DMA_CFCR_DTEF_Pos)            /*!< 0x00000400 */
#define DMA_CFCR_DTEF                       DMA_CFCR_DTEF_Msk                       /*!< Data transfer error flag clear           */
#define DMA_CFCR_ULEF_Pos                   (11U)
#define DMA_CFCR_ULEF_Msk                   (0x1UL << DMA_CFCR_ULEF_Pos)            /*!< 0x00000800 */
#define DMA_CFCR_ULEF                       DMA_CFCR_ULEF_Msk                       /*!< Update linked-list item error flag clear */
#define DMA_CFCR_USEF_Pos                   (12U)
#define DMA_CFCR_USEF_Msk                   (0x1UL << DMA_CFCR_USEF_Pos)            /*!< 0x00001000 */
#define DMA_CFCR_USEF                       DMA_CFCR_USEF_Msk                       /*!< User setting error flag clear            */
#define DMA_CFCR_SUSPF_Pos                  (13U)
#define DMA_CFCR_SUSPF_Msk                  (0x1UL << DMA_CFCR_SUSPF_Pos)           /*!< 0x00002000 */
#define DMA_CFCR_SUSPF                      DMA_CFCR_SUSPF_Msk                      /*!< Completed suspension flag clear          */
#define DMA_CFCR_TOF_Pos                    (14U)
#define DMA_CFCR_TOF_Msk                    (0x1UL << DMA_CFCR_TOF_Pos)             /*!< 0x00004000 */
#define DMA_CFCR_TOF                        DMA_CFCR_TOF_Msk                        /*!< Trigger overrun flag clear               */

/*******************  Bit definition for DMA_CSR register  *******************/
#define DMA_CSR_IDLEF_Pos                   (0U)
#define DMA_CSR_IDLEF_Msk                   (0x1UL << DMA_CSR_IDLEF_Pos)            /*!< 0x00000001 */
#define DMA_CSR_IDLEF                       DMA_CSR_IDLEF_Msk                       /*!< Idle flag                          */
#define DMA_CSR_TCF_Pos                     (8U)
#define DMA_CSR_TCF_Msk                     (0x1UL << DMA_CSR_TCF_Pos)              /*!< 0x00000100 */
#define DMA_CSR_TCF                         DMA_CSR_TCF_Msk                         /*!< Transfer complete flag             */
#define DMA_CSR_HTF_Pos                     (9U)
#define DMA_CSR_HTF_Msk                     (0x1UL << DMA_CSR_HTF_Pos)              /*!< 0x00000200 */
#define DMA_CSR_HTF                         DMA_CSR_HTF_Msk                         /*!< Half transfer complete flag        */
#define DMA_CSR_DTEF_Pos                    (10U)
#define DMA_CSR_DTEF_Msk                    (0x1UL << DMA_CSR_DTEF_Pos)             /*!< 0x00000400 */
#define DMA_CSR_DTEF                        DMA_CSR_DTEF_Msk                        /*!< Data transfer error flag           */
#define DMA_CSR_ULEF_Pos                    (11U)
#define DMA_CSR_ULEF_Msk                    (0x1UL << DMA_CSR_ULEF_Pos)             /*!< 0x00000800 */
#define DMA_CSR_ULEF                        DMA_CSR_ULEF_Msk                        /*!< Update linked-list item error flag */
#define DMA_CSR_USEF_Pos                    (12U)
#define DMA_CSR_USEF_Msk                    (0x1UL << DMA_CSR_USEF_Pos)             /*!< 0x00001000 */
#define DMA_CSR_USEF                        DMA_CSR_USEF_Msk                        /*!< User setting error flag            */
#define DMA_CSR_SUSPF_Pos                   (13U)
#define DMA_CSR_SUSPF_Msk                   (0x1UL << DMA_CSR_SUSPF_Pos)            /*!< 0x00002000 */
#define DMA_CSR_SUSPF                       DMA_CSR_SUSPF_Msk                       /*!< Completed suspension flag          */
#define DMA_CSR_TOF_Pos                     (14U)
#define DMA_CSR_TOF_Msk                     (0x1UL << DMA_CSR_TOF_Pos)              /*!< 0x00004000 */
#define DMA_CSR_TOF                         DMA_CSR_TOF_Msk                         /*!< Trigger overrun flag               */
#define DMA_CSR_FIFOL_Pos                   (16U)
#define DMA_CSR_FIFOL_Msk                   (0xFFUL << DMA_CSR_FIFOL_Pos)           /*!< 0x00FF0000 */
#define DMA_CSR_FIFOL                       DMA_CSR_FIFOL_Msk                       /*!< Monitored FIFO level in bytes      */

/*******************  Bit definition for DMA_CCR register  ********************/
#define DMA_CCR_EN_Pos                      (0U)
#define DMA_CCR_EN_Msk                      (0x1UL << DMA_CCR_EN_Pos)               /*!< 0x00000001 */
#define DMA_CCR_EN                          DMA_CCR_EN_Msk                          /*!< Channel enable                                 */
#define DMA_CCR_RESET_Pos                   (1U)
#define DMA_CCR_RESET_Msk                   (0x1UL << DMA_CCR_RESET_Pos)            /*!< 0x00000002 */
#define DMA_CCR_RESET                       DMA_CCR_RESET_Msk                       /*!< Channel reset                                  */
#define DMA_CCR_SUSP_Pos                    (2U)
#define DMA_CCR_SUSP_Msk                    (0x1UL << DMA_CCR_SUSP_Pos)             /*!< 0x00000004 */
#define DMA_CCR_SUSP                        DMA_CCR_SUSP_Msk                        /*!< Channel suspend                                */
#define DMA_CCR_TCIE_Pos                    (8U)
#define DMA_CCR_TCIE_Msk                    (0x1UL << DMA_CCR_TCIE_Pos)             /*!< 0x00000100 */
#define DMA_CCR_TCIE                        DMA_CCR_TCIE_Msk                        /*!< Transfer complete interrupt enable             */
#define DMA_CCR_HTIE_Pos                    (9U)
#define DMA_CCR_HTIE_Msk                    (0x1UL << DMA_CCR_HTIE_Pos)             /*!< 0x00000200 */
#define DMA_CCR_HTIE                        DMA_CCR_HTIE_Msk                        /*!< Half transfer complete interrupt enable        */
#define DMA_CCR_DTEIE_Pos                   (10U)
#define DMA_CCR_DTEIE_Msk                   (0x1UL << DMA_CCR_DTEIE_Pos)            /*!< 0x00000400 */
#define DMA_CCR_DTEIE                       DMA_CCR_DTEIE_Msk                       /*!< Data transfer error interrupt enable           */
#define DMA_CCR_ULEIE_Pos                   (11U)
#define DMA_CCR_ULEIE_Msk                   (0x1UL << DMA_CCR_ULEIE_Pos)            /*!< 0x00000800 */
#define DMA_CCR_ULEIE                       DMA_CCR_ULEIE_Msk                       /*!< Update linked-list item error interrupt enable */
#define DMA_CCR_USEIE_Pos                   (12U)
#define DMA_CCR_USEIE_Msk                   (0x1UL << DMA_CCR_USEIE_Pos)            /*!< 0x00001000 */
#define DMA_CCR_USEIE                       DMA_CCR_USEIE_Msk                       /*!< User setting error interrupt enable            */
#define DMA_CCR_SUSPIE_Pos                  (13U)
#define DMA_CCR_SUSPIE_Msk                  (0x1UL << DMA_CCR_SUSPIE_Pos)           /*!< 0x00002000 */
#define DMA_CCR_SUSPIE                      DMA_CCR_SUSPIE_Msk                      /*!< Completed suspension interrupt enable          */
#define DMA_CCR_TOIE_Pos                    (14U)
#define DMA_CCR_TOIE_Msk                    (0x1UL << DMA_CCR_TOIE_Pos)             /*!< 0x00004000 */
#define DMA_CCR_TOIE                        DMA_CCR_TOIE_Msk                        /*!< Trigger overrun interrupt enable               */
#define DMA_CCR_LSM_Pos                     (16U)
#define DMA_CCR_LSM_Msk                     (0x1UL << DMA_CCR_LSM_Pos)              /*!< 0x00010000 */
#define DMA_CCR_LSM                         DMA_CCR_LSM_Msk                         /*!< Link step mode                                 */
#define DMA_CCR_LAP_Pos                     (17U)
#define DMA_CCR_LAP_Msk                     (0x1UL << DMA_CCR_LAP_Pos)              /*!< 0x00020000 */
#define DMA_CCR_LAP                         DMA_CCR_LAP_Msk                         /*!< Linked-list allocated port                     */
#define DMA_CCR_PRIO_Pos                    (22U)
#define DMA_CCR_PRIO_Msk                    (0x3UL << DMA_CCR_PRIO_Pos)             /*!< 0x00C00000 */
#define DMA_CCR_PRIO                        DMA_CCR_PRIO_Msk                        /*!< Priority level                                 */
#define DMA_CCR_PRIO_0                      (0x1UL << DMA_CCR_PRIO_Pos)             /*!< 0x00400000 */
#define DMA_CCR_PRIO_1                      (0x2UL << DMA_CCR_PRIO_Pos)             /*!< 0x00800000 */

/*******************  Bit definition for DMA_CTR1 register  *******************/
#define DMA_CTR1_SDW_LOG2_Pos               (0U)
#define DMA_CTR1_SDW_LOG2_Msk               (0x3UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< 0x00000003 */
#define DMA_CTR1_SDW_LOG2                   DMA_CTR1_SDW_LOG2_Msk                   /*!< Binary logarithm of the source data width of a burst                    */
#define DMA_CTR1_SDW_LOG2_0                 (0x1UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< Bit 0 */
#define DMA_CTR1_SDW_LOG2_1                 (0x2UL << DMA_CTR1_SDW_LOG2_Pos)        /*!< Bit 1 */
#define DMA_CTR1_SINC_Pos                   (3U)
#define DMA_CTR1_SINC_Msk                   (0x1UL << DMA_CTR1_SINC_Pos)            /*!< 0x00000008 */
#define DMA_CTR1_SINC                       DMA_CTR1_SINC_Msk                       /*!< Source incrementing burst                                               */
#define DMA_CTR1_SBL_1_Pos                  (4U)
#define DMA_CTR1_SBL_1_Msk                  (0x3FUL << DMA_CTR1_SBL_1_Pos)          /*!< 0x000003F0 */
#define DMA_CTR1_SBL_1                      DMA_CTR1_SBL_1_Msk                      /*!< Source burst length minus 1                                             */
#define DMA_CTR1_PAM_Pos                    (11U)
#define DMA_CTR1_PAM_Msk                    (0x3UL << DMA_CTR1_PAM_Pos)             /*!< 0x0001800 */
#define DMA_CTR1_PAM                        DMA_CTR1_PAM_Msk                        /*!< Padding / alignment mode                                                */
#define DMA_CTR1_PAM_0                      (0x1UL << DMA_CTR1_PAM_Pos)             /*!< Bit 0 */
#define DMA_CTR1_PAM_1                      (0x2UL << DMA_CTR1_PAM_Pos)             /*!< Bit 1 */
#define DMA_CTR1_SBX_Pos                    (13U)
#define DMA_CTR1_SBX_Msk                    (0x1UL << DMA_CTR1_SBX_Pos)             /*!< 0x00002000 */
#define DMA_CTR1_SBX                        DMA_CTR1_SBX_Msk                        /*!< Source byte exchange within the unaligned half-word of each source word */
#define DMA_CTR1_SAP_Pos                    (14U)
#define DMA_CTR1_SAP_Msk                    (0x1UL << DMA_CTR1_SAP_Pos)             /*!< 0x00004000 */
#define DMA_CTR1_SAP                        DMA_CTR1_SAP_Msk                        /*!< Source allocated port                                                   */
#define DMA_CTR1_SSEC_Pos                   (15U)
#define DMA_CTR1_SSEC_Msk                   (0x1UL << DMA_CTR1_SSEC_Pos)            /*!< 0x00008000 */
#define DMA_CTR1_SSEC                       DMA_CTR1_SSEC_Msk                       /*!< Security attribute of the DMA transfer from the source                  */
#define DMA_CTR1_DDW_LOG2_Pos               (16U)
#define DMA_CTR1_DDW_LOG2_Msk               (0x3UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< 0x00030000 */
#define DMA_CTR1_DDW_LOG2                   DMA_CTR1_DDW_LOG2_Msk                   /*!< Binary logarithm of the destination data width of a burst               */
#define DMA_CTR1_DDW_LOG2_0                 (0x1UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< Bit 0 */
#define DMA_CTR1_DDW_LOG2_1                 (0x2UL << DMA_CTR1_DDW_LOG2_Pos)        /*!< Bit 1 */
#define DMA_CTR1_DINC_Pos                   (19U)
#define DMA_CTR1_DINC_Msk                   (0x1UL << DMA_CTR1_DINC_Pos)            /*!< 0x00080000 */
#define DMA_CTR1_DINC                       DMA_CTR1_DINC_Msk                       /*!< Destination incrementing burst                                          */
#define DMA_CTR1_DBL_1_Pos                  (20U)
#define DMA_CTR1_DBL_1_Msk                  (0x3FUL << DMA_CTR1_DBL_1_Pos)          /*!< 0x03F00000 */
#define DMA_CTR1_DBL_1                      DMA_CTR1_DBL_1_Msk                      /*!< Destination burst length minus 1                                        */
#define DMA_CTR1_DBX_Pos                    (26U)
#define DMA_CTR1_DBX_Msk                    (0x1UL << DMA_CTR1_DBX_Pos)             /*!< 0x04000000 */
#define DMA_CTR1_DBX                        DMA_CTR1_DBX_Msk                        /*!< Destination byte exchange                                               */
#define DMA_CTR1_DHX_Pos                    (27U)
#define DMA_CTR1_DHX_Msk                    (0x1UL << DMA_CTR1_DHX_Pos)             /*!< 0x08000000 */
#define DMA_CTR1_DHX                        DMA_CTR1_DHX_Msk                        /*!< Destination half-word exchange                                          */
#define DMA_CTR1_DAP_Pos                    (30U)
#define DMA_CTR1_DAP_Msk                    (0x1UL << DMA_CTR1_DAP_Pos)             /*!< 0x40000000 */
#define DMA_CTR1_DAP                        DMA_CTR1_DAP_Msk                        /*!< Destination allocated port                                              */
#define DMA_CTR1_DSEC_Pos                   (31U)
#define DMA_CTR1_DSEC_Msk                   (0x1UL << DMA_CTR1_DSEC_Pos)            /*!< 0x80000000 */
#define DMA_CTR1_DSEC                       DMA_CTR1_DSEC_Msk                       /*!< Security attribute of the DMA transfer from the destination             */

/******************  Bit definition for DMA_CTR2 register  *******************/
#define DMA_CTR2_REQSEL_Pos                 (0U)
#define DMA_CTR2_REQSEL_Msk                 (0x7FUL << DMA_CTR2_REQSEL_Pos)         /*!< 0x0000007F */
#define DMA_CTR2_REQSEL                     DMA_CTR2_REQSEL_Msk                     /*!< DMA hardware request selection */
#define DMA_CTR2_SWREQ_Pos                  (9U)
#define DMA_CTR2_SWREQ_Msk                  (0x1UL << DMA_CTR2_SWREQ_Pos)           /*!< 0x00000200 */
#define DMA_CTR2_SWREQ                      DMA_CTR2_SWREQ_Msk                      /*!< Software request               */
#define DMA_CTR2_DREQ_Pos                   (10U)
#define DMA_CTR2_DREQ_Msk                   (0x1UL << DMA_CTR2_DREQ_Pos)            /*!< 0x00000400 */
#define DMA_CTR2_DREQ                       DMA_CTR2_DREQ_Msk                       /*!< Destination hardware request   */
#define DMA_CTR2_BREQ_Pos                   (11U)
#define DMA_CTR2_BREQ_Msk                   (0x1UL << DMA_CTR2_BREQ_Pos)            /*!< 0x00000800 */
#define DMA_CTR2_BREQ                       DMA_CTR2_BREQ_Msk                       /*!< Block hardware request         */
#define DMA_CTR2_TRIGM_Pos                  (14U)
#define DMA_CTR2_TRIGM_Msk                  (0x3UL << DMA_CTR2_TRIGM_Pos)           /*!< 0x0000C000 */
#define DMA_CTR2_TRIGM                      DMA_CTR2_TRIGM_Msk                      /*!< Trigger mode                   */
#define DMA_CTR2_TRIGM_0                    (0x1UL << DMA_CTR2_TRIGM_Pos)           /*!< Bit 0 */
#define DMA_CTR2_TRIGM_1                    (0x2UL << DMA_CTR2_TRIGM_Pos)           /*!< Bit 1 */
#define DMA_CTR2_TRIGSEL_Pos                (16U)
#define DMA_CTR2_TRIGSEL_Msk                (0x7FUL << DMA_CTR2_TRIGSEL_Pos)        /*!< 0x007F0000 */
#define DMA_CTR2_TRIGSEL                    DMA_CTR2_TRIGSEL_Msk                    /*!< Trigger event input selection  */
#define DMA_CTR2_TRIGPOL_Pos                (24U)
#define DMA_CTR2_TRIGPOL_Msk                (0x3UL << DMA_CTR2_TRIGPOL_Pos)         /*!< 0x03000000 */
#define DMA_CTR2_TRIGPOL                    DMA_CTR2_TRIGPOL_Msk                    /*!< Trigger event polarity         */
#define DMA_CTR2_TRIGPOL_0                  (0x1UL << DMA_CTR2_TRIGPOL_Pos)         /*!< Bit 0 */
#define DMA_CTR2_TRIGPOL_1                  (0x2UL << DMA_CTR2_TRIGPOL_Pos)         /*!< Bit 1 */
#define DMA_CTR2_TCEM_Pos                   (30U)
#define DMA_CTR2_TCEM_Msk                   (0x3UL << DMA_CTR2_TCEM_Pos)            /*!< 0xC0000000 */
#define DMA_CTR2_TCEM                       DMA_CTR2_TCEM_Msk                       /*!< Transfer complete event mode   */
#define DMA_CTR2_TCEM_0                     (0x1UL << DMA_CTR2_TCEM_Pos)            /*!< Bit 0 */
#define DMA_CTR2_TCEM_1                     (0x2UL << DMA_CTR2_TCEM_Pos)            /*!< Bit 1 */

/******************  Bit definition for DMA_CBR1 register  *******************/
#define DMA_CBR1_BNDT_Pos                   (0U)
#define DMA_CBR1_BNDT_Msk                   (0xFFFFUL << DMA_CBR1_BNDT_Pos)         /*!< 0x0000FFFF */
#define DMA_CBR1_BNDT                       DMA_CBR1_BNDT_Msk                       /*!< Block number of data bytes to transfer from the source */
#define DMA_CBR1_BRC_Pos                    (16U)
#define DMA_CBR1_BRC_Msk                    (0x7FFUL << DMA_CBR1_BRC_Pos)           /*!< 0x07FF0000 */
#define DMA_CBR1_BRC                        DMA_CBR1_BRC_Msk                        /*!< Block repeat counter                                   */
#define DMA_CBR1_SDEC_Pos                   (28U)
#define DMA_CBR1_SDEC_Msk                   (0x1UL << DMA_CBR1_SDEC_Pos)            /*!< 0x10000000 */
#define DMA_CBR1_SDEC                       DMA_CBR1_SDEC_Msk                       /*!< Source address decrement                               */
#define DMA_CBR1_DDEC_Pos                   (29U)
#define DMA_CBR1_DDEC_Msk                   (0x1UL << DMA_CBR1_DDEC_Pos)            /*!< 0x20000000 */
#define DMA_CBR1_DDEC                       DMA_CBR1_DDEC_Msk                       /*!< Destination address decrement                          */
#define DMA_CBR1_BRSDEC_Pos                 (30U)
#define DMA_CBR1_BRSDEC_Msk                 (0x1UL << DMA_CBR1_BRSDEC_Pos)          /*!< 0x40000000 */
#define DMA_CBR1_BRSDEC                     DMA_CBR1_BRSDEC_Msk                     /*!< Block repeat source address decrement                  */
#define DMA_CBR1_BRDDEC_Pos                 (31U)
#define DMA_CBR1_BRDDEC_Msk                 (0x1UL << DMA_CBR1_BRDDEC_Pos)          /*!< 0x80000000 */
#define DMA_CBR1_BRDDEC                     DMA_CBR1_BRDDEC_Msk                     /*!< Block repeat destination address decrement             */

/******************  Bit definition for DMA_CSAR register  ********************/
#define DMA_CSAR_SA_Pos                     (0U)
#define DMA_CSAR_SA_Msk                     (0xFFFFFFFFUL << DMA_CSAR_SA_Pos)       /*!< 0xFFFFFFFF */
#define DMA_CSAR_SA                         DMA_CSAR_SA_Msk                         /*!< Source Address */

/******************  Bit definition for DMA_CDAR register  *******************/
#define DMA_CDAR_DA_Pos                     (0U)
#define DMA_CDAR_DA_Msk                     (0xFFFFFFFFUL << DMA_CDAR_DA_Pos)       /*!< 0xFFFFFFFF */
#define DMA_CDAR_DA                         DMA_CDAR_DA_Msk                         /*!< Destination address */

/******************  Bit definition for DMA_CTR3 register  *******************/
#define DMA_CTR3_SAO_Pos                    (0U)
#define DMA_CTR3_SAO_Msk                    (0x1FFFUL << DMA_CTR3_SAO_Pos)          /*!< 0x00001FFF */
#define DMA_CTR3_SAO                        DMA_CTR3_SAO_Msk                        /*!< Source address offset increment      */
#define DMA_CTR3_DAO_Pos                    (16U)
#define DMA_CTR3_DAO_Msk                    (0x1FFFUL << DMA_CTR3_DAO_Pos)          /*!< 0x1FFF0000 */
#define DMA_CTR3_DAO                        DMA_CTR3_DAO_Msk                        /*!< Destination address offset increment */

/******************  Bit definition for DMA_CBR2 register  *******************/
#define DMA_CBR2_BRSAO_Pos                  (0U)
#define DMA_CBR2_BRSAO_Msk                  (0xFFFFUL << DMA_CBR2_BRSAO_Pos)        /*!< 0x0000FFFF */
#define DMA_CBR2_BRSAO                      DMA_CBR2_BRSAO_Msk                      /*!< Block repeated source address offset      */
#define DMA_CBR2_BRDAO_Pos                  (16U)
#define DMA_CBR2_BRDAO_Msk                  (0xFFFFUL << DMA_CBR2_BRDAO_Pos)        /*!< 0xFFFF0000 */
#define DMA_CBR2_BRDAO                      DMA_CBR2_BRDAO_Msk                      /*!< Block repeated destination address offset */

/******************  Bit definition for DMA_CLLR register  *******************/
#define DMA_CLLR_LA_Pos                     (2U)
#define DMA_CLLR_LA_Msk                     (0x3FFFUL << DMA_CLLR_LA_Pos)           /*!< 0x0000FFFC */
#define DMA_CLLR_LA                         DMA_CLLR_LA_Msk                         /*!< Pointer to the next linked-list data structure */
#define DMA_CLLR_ULL_Pos                    (16U)
#define DMA_CLLR_ULL_Msk                    (0x1UL << DMA_CLLR_ULL_Pos)             /*!< 0x00010000 */
#define DMA_CLLR_ULL                        DMA_CLLR_ULL_Msk                        /*!< Update link address register from memory       */
#define DMA_CLLR_UB2_Pos                    (25U)
#define DMA_CLLR_UB2_Msk                    (0x1UL << DMA_CLLR_UB2_Pos)             /*!< 0x02000000 */
#define DMA_CLLR_UB2                        DMA_CLLR_UB2_Msk                        /*!< Update block register 2 from memory            */
#define DMA_CLLR_UT3_Pos                    (26U)
#define DMA_CLLR_UT3_Msk                    (0x1UL << DMA_CLLR_UT3_Pos)             /*!< 0x04000000 */
#define DMA_CLLR_UT3                        DMA_CLLR_UT3_Msk                        /*!< Update transfer register 3 from SRAM           */
#define DMA_CLLR_UDA_Pos                    (27U)
#define DMA_CLLR_UDA_Msk                    (0x1UL << DMA_CLLR_UDA_Pos)             /*!< 0x08000000 */
#define DMA_CLLR_UDA                        DMA_CLLR_UDA_Msk                        /*!< Update destination address register from SRAM  */
#define DMA_CLLR_USA_Pos                    (28U)
#define DMA_CLLR_USA_Msk                    (0x1UL << DMA_CLLR_USA_Pos)             /*!< 0x10000000 */
#define DMA_CLLR_USA                        DMA_CLLR_USA_Msk                        /*!< Update source address register from SRAM       */
#define DMA_CLLR_UB1_Pos                    (29U)
#define DMA_CLLR_UB1_Msk                    (0x1UL << DMA_CLLR_UB1_Pos)             /*!< 0x20000000 */
#define DMA_CLLR_UB1                        DMA_CLLR_UB1_Msk                        /*!< Update block register 1 from SRAM              */
#define DMA_CLLR_UT2_Pos                    (30U)
#define DMA_CLLR_UT2_Msk                    (0x1UL << DMA_CLLR_UT2_Pos)             /*!< 0x40000000 */
#define DMA_CLLR_UT2                        DMA_CLLR_UT2_Msk                        /*!< Update transfer register 2 from SRAM           */
#define DMA_CLLR_UT1_Pos                    (31U)
#define DMA_CLLR_UT1_Msk                    (0x1UL << DMA_CLLR_UT1_Pos)             /*!< 0x80000000 */
#define DMA_CLLR_UT1                        DMA_CLLR_UT1_Msk                        /*!< Update transfer register 1 from SRAM           */

/******************************************************************************/
/*                                                                            */
/*                         AHB Master DMA2D Controller (DMA2D)                */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for DMA2D_CR register  ******************/
#define DMA2D_CR_START_Pos                  (0U)
#define DMA2D_CR_START_Msk                  (0x1UL << DMA2D_CR_START_Pos)           /*!< 0x00000001 */
#define DMA2D_CR_START                      DMA2D_CR_START_Msk                      /*!< Start transfer                          */
#define DMA2D_CR_SUSP_Pos                   (1U)
#define DMA2D_CR_SUSP_Msk                   (0x1UL << DMA2D_CR_SUSP_Pos)            /*!< 0x00000002 */
#define DMA2D_CR_SUSP                       DMA2D_CR_SUSP_Msk                       /*!< Suspend transfer                        */
#define DMA2D_CR_ABORT_Pos                  (2U)
#define DMA2D_CR_ABORT_Msk                  (0x1UL << DMA2D_CR_ABORT_Pos)           /*!< 0x00000004 */
#define DMA2D_CR_ABORT                      DMA2D_CR_ABORT_Msk                      /*!< Abort transfer                          */
#define DMA2D_CR_LOM_Pos                    (6U)
#define DMA2D_CR_LOM_Msk                    (0x1UL << DMA2D_CR_LOM_Pos)             /*!< 0x00000040 */
#define DMA2D_CR_LOM                        DMA2D_CR_LOM_Msk
#define DMA2D_CR_TEIE_Pos                   (8U)
#define DMA2D_CR_TEIE_Msk                   (0x1UL << DMA2D_CR_TEIE_Pos)            /*!< 0x00000100 */
#define DMA2D_CR_TEIE                       DMA2D_CR_TEIE_Msk                       /*!< Transfer Error Interrupt Enable         */
#define DMA2D_CR_TCIE_Pos                   (9U)
#define DMA2D_CR_TCIE_Msk                   (0x1UL << DMA2D_CR_TCIE_Pos)            /*!< 0x00000200 */
#define DMA2D_CR_TCIE                       DMA2D_CR_TCIE_Msk                       /*!< Transfer Complete Interrupt Enable      */
#define DMA2D_CR_TWIE_Pos                   (10U)
#define DMA2D_CR_TWIE_Msk                   (0x1UL << DMA2D_CR_TWIE_Pos)            /*!< 0x00000400 */
#define DMA2D_CR_TWIE                       DMA2D_CR_TWIE_Msk                       /*!< Transfer Watermark Interrupt Enable     */
#define DMA2D_CR_CAEIE_Pos                  (11U)
#define DMA2D_CR_CAEIE_Msk                  (0x1UL << DMA2D_CR_CAEIE_Pos)           /*!< 0x00000800 */
#define DMA2D_CR_CAEIE                      DMA2D_CR_CAEIE_Msk                      /*!< CLUT Access Error Interrupt Enable      */
#define DMA2D_CR_CTCIE_Pos                  (12U)
#define DMA2D_CR_CTCIE_Msk                  (0x1UL << DMA2D_CR_CTCIE_Pos)           /*!< 0x00001000 */
#define DMA2D_CR_CTCIE                      DMA2D_CR_CTCIE_Msk                      /*!< CLUT Transfer Complete Interrupt Enable */
#define DMA2D_CR_CEIE_Pos                   (13U)
#define DMA2D_CR_CEIE_Msk                   (0x1UL << DMA2D_CR_CEIE_Pos)            /*!< 0x00002000 */
#define DMA2D_CR_CEIE                       DMA2D_CR_CEIE_Msk                       /*!< Configuration Error Interrupt Enable    */
#define DMA2D_CR_MODE_Pos                   (16U)
#define DMA2D_CR_MODE_Msk                   (0x7UL << DMA2D_CR_MODE_Pos)            /*!< 0x00070000 */
#define DMA2D_CR_MODE                       DMA2D_CR_MODE_Msk                       /*!< DMA2D Mode[2:0]                         */
#define DMA2D_CR_MODE_0                     (0x1UL << DMA2D_CR_MODE_Pos)            /*!< 0x00010000 */
#define DMA2D_CR_MODE_1                     (0x2UL << DMA2D_CR_MODE_Pos)            /*!< 0x00020000 */
#define DMA2D_CR_MODE_2                     (0x4UL << DMA2D_CR_MODE_Pos)            /*!< 0x00040000 */

/********************  Bit definition for DMA2D_ISR register  *****************/
#define DMA2D_ISR_TEIF_Pos                  (0U)
#define DMA2D_ISR_TEIF_Msk                  (0x1UL << DMA2D_ISR_TEIF_Pos)           /*!< 0x00000001 */
#define DMA2D_ISR_TEIF                      DMA2D_ISR_TEIF_Msk                      /*!< Transfer Error Interrupt Flag         */
#define DMA2D_ISR_TCIF_Pos                  (1U)
#define DMA2D_ISR_TCIF_Msk                  (0x1UL << DMA2D_ISR_TCIF_Pos)           /*!< 0x00000002 */
#define DMA2D_ISR_TCIF                      DMA2D_ISR_TCIF_Msk                      /*!< Transfer Complete Interrupt Flag      */
#define DMA2D_ISR_TWIF_Pos                  (2U)
#define DMA2D_ISR_TWIF_Msk                  (0x1UL << DMA2D_ISR_TWIF_Pos)           /*!< 0x00000004 */
#define DMA2D_ISR_TWIF                      DMA2D_ISR_TWIF_Msk                      /*!< Transfer Watermark Interrupt Flag     */
#define DMA2D_ISR_CAEIF_Pos                 (3U)
#define DMA2D_ISR_CAEIF_Msk                 (0x1UL << DMA2D_ISR_CAEIF_Pos)          /*!< 0x00000008 */
#define DMA2D_ISR_CAEIF                     DMA2D_ISR_CAEIF_Msk                     /*!< CLUT Access Error Interrupt Flag      */
#define DMA2D_ISR_CTCIF_Pos                 (4U)
#define DMA2D_ISR_CTCIF_Msk                 (0x1UL << DMA2D_ISR_CTCIF_Pos)          /*!< 0x00000010 */
#define DMA2D_ISR_CTCIF                     DMA2D_ISR_CTCIF_Msk                     /*!< CLUT Transfer Complete Interrupt Flag */
#define DMA2D_ISR_CEIF_Pos                  (5U)
#define DMA2D_ISR_CEIF_Msk                  (0x1UL << DMA2D_ISR_CEIF_Pos)           /*!< 0x00000020 */
#define DMA2D_ISR_CEIF                      DMA2D_ISR_CEIF_Msk                      /*!< Configuration Error Interrupt Flag    */

/********************  Bit definition for DMA2D_IFCR register  ****************/
#define DMA2D_IFCR_CTEIF_Pos                (0U)
#define DMA2D_IFCR_CTEIF_Msk                (0x1UL << DMA2D_IFCR_CTEIF_Pos)         /*!< 0x00000001 */
#define DMA2D_IFCR_CTEIF                    DMA2D_IFCR_CTEIF_Msk                    /*!< Clears Transfer Error Interrupt Flag         */
#define DMA2D_IFCR_CTCIF_Pos                (1U)
#define DMA2D_IFCR_CTCIF_Msk                (0x1UL << DMA2D_IFCR_CTCIF_Pos)         /*!< 0x00000002 */
#define DMA2D_IFCR_CTCIF                    DMA2D_IFCR_CTCIF_Msk                    /*!< Clears Transfer Complete Interrupt Flag      */
#define DMA2D_IFCR_CTWIF_Pos                (2U)
#define DMA2D_IFCR_CTWIF_Msk                (0x1UL << DMA2D_IFCR_CTWIF_Pos)         /*!< 0x00000004 */
#define DMA2D_IFCR_CTWIF                    DMA2D_IFCR_CTWIF_Msk                    /*!< Clears Transfer Watermark Interrupt Flag     */
#define DMA2D_IFCR_CAECIF_Pos               (3U)
#define DMA2D_IFCR_CAECIF_Msk               (0x1UL << DMA2D_IFCR_CAECIF_Pos)        /*!< 0x00000008 */
#define DMA2D_IFCR_CAECIF                   DMA2D_IFCR_CAECIF_Msk                   /*!< Clears CLUT Access Error Interrupt Flag      */
#define DMA2D_IFCR_CCTCIF_Pos               (4U)
#define DMA2D_IFCR_CCTCIF_Msk               (0x1UL << DMA2D_IFCR_CCTCIF_Pos)        /*!< 0x00000010 */
#define DMA2D_IFCR_CCTCIF                   DMA2D_IFCR_CCTCIF_Msk                   /*!< Clears CLUT Transfer Complete Interrupt Flag */
#define DMA2D_IFCR_CCEIF_Pos                (5U)
#define DMA2D_IFCR_CCEIF_Msk                (0x1UL << DMA2D_IFCR_CCEIF_Pos)         /*!< 0x00000020 */
#define DMA2D_IFCR_CCEIF                    DMA2D_IFCR_CCEIF_Msk                    /*!< Clears Configuration Error Interrupt Flag    */

/********************  Bit definition for DMA2D_FGMAR register  ***************/
#define DMA2D_FGMAR_MA_Pos                  (0U)
#define DMA2D_FGMAR_MA_Msk                  (0xFFFFFFFFUL << DMA2D_FGMAR_MA_Pos)    /*!< 0xFFFFFFFF */
#define DMA2D_FGMAR_MA                      DMA2D_FGMAR_MA_Msk                      /*!< Foreground Memory Address */

/********************  Bit definition for DMA2D_FGOR register  ****************/
#define DMA2D_FGOR_LO_Pos                   (0U)
#define DMA2D_FGOR_LO_Msk                   (0xFFFFUL << DMA2D_FGOR_LO_Pos)         /*!< 0x0000FFFF */
#define DMA2D_FGOR_LO                       DMA2D_FGOR_LO_Msk                       /*!< Line Offset */

/********************  Bit definition for DMA2D_BGMAR register  ***************/
#define DMA2D_BGMAR_MA_Pos                  (0U)
#define DMA2D_BGMAR_MA_Msk                  (0xFFFFFFFFUL << DMA2D_BGMAR_MA_Pos)    /*!< 0xFFFFFFFF */
#define DMA2D_BGMAR_MA                      DMA2D_BGMAR_MA_Msk                      /*!< Background Memory Address */

/********************  Bit definition for DMA2D_BGOR register  ****************/
#define DMA2D_BGOR_LO_Pos                   (0U)
#define DMA2D_BGOR_LO_Msk                   (0xFFFFUL << DMA2D_BGOR_LO_Pos)         /*!< 0x0000FFFF */
#define DMA2D_BGOR_LO                       DMA2D_BGOR_LO_Msk                       /*!< Line Offset */

/********************  Bit definition for DMA2D_FGPFCCR register  *************/
#define DMA2D_FGPFCCR_CM_Pos                (0U)
#define DMA2D_FGPFCCR_CM_Msk                (0xFUL << DMA2D_FGPFCCR_CM_Pos)         /*!< 0x0000000F */
#define DMA2D_FGPFCCR_CM                    DMA2D_FGPFCCR_CM_Msk                    /*!< Input color mode CM[3:0] */
#define DMA2D_FGPFCCR_CM_0                  (0x1UL << DMA2D_FGPFCCR_CM_Pos)         /*!< 0x00000001 */
#define DMA2D_FGPFCCR_CM_1                  (0x2UL << DMA2D_FGPFCCR_CM_Pos)         /*!< 0x00000002 */
#define DMA2D_FGPFCCR_CM_2                  (0x4UL << DMA2D_FGPFCCR_CM_Pos)         /*!< 0x00000004 */
#define DMA2D_FGPFCCR_CM_3                  (0x8UL << DMA2D_FGPFCCR_CM_Pos)         /*!< 0x00000008 */
#define DMA2D_FGPFCCR_CCM_Pos               (4U)
#define DMA2D_FGPFCCR_CCM_Msk               (0x1UL << DMA2D_FGPFCCR_CCM_Pos)        /*!< 0x00000010 */
#define DMA2D_FGPFCCR_CCM                   DMA2D_FGPFCCR_CCM_Msk                   /*!< CLUT Color mode */
#define DMA2D_FGPFCCR_START_Pos             (5U)
#define DMA2D_FGPFCCR_START_Msk             (0x1UL << DMA2D_FGPFCCR_START_Pos)      /*!< 0x00000020 */
#define DMA2D_FGPFCCR_START                 DMA2D_FGPFCCR_START_Msk                 /*!< Start */
#define DMA2D_FGPFCCR_CS_Pos                (8U)
#define DMA2D_FGPFCCR_CS_Msk                (0xFFUL << DMA2D_FGPFCCR_CS_Pos)        /*!< 0x0000FF00 */
#define DMA2D_FGPFCCR_CS                    DMA2D_FGPFCCR_CS_Msk                    /*!< CLUT size */
#define DMA2D_FGPFCCR_AM_Pos                (16U)
#define DMA2D_FGPFCCR_AM_Msk                (0x3UL << DMA2D_FGPFCCR_AM_Pos)         /*!< 0x00030000 */
#define DMA2D_FGPFCCR_AM                    DMA2D_FGPFCCR_AM_Msk                    /*!< Alpha mode AM[1:0] */
#define DMA2D_FGPFCCR_AM_0                  (0x1UL << DMA2D_FGPFCCR_AM_Pos)         /*!< 0x00010000 */
#define DMA2D_FGPFCCR_AM_1                  (0x2UL << DMA2D_FGPFCCR_AM_Pos)         /*!< 0x00020000 */
#define DMA2D_FGPFCCR_CSS_Pos               (18U)
#define DMA2D_FGPFCCR_CSS_Msk               (0x3UL << DMA2D_FGPFCCR_CSS_Pos)        /*!< 0x000C0000 */
#define DMA2D_FGPFCCR_CSS                   DMA2D_FGPFCCR_CSS_Msk                   /* !< Chroma Sub-Sampling */
#define DMA2D_FGPFCCR_CSS_0                 (0x1UL << DMA2D_FGPFCCR_CSS_Pos)        /*!< 0x00040000 */
#define DMA2D_FGPFCCR_CSS_1                 (0x2UL << DMA2D_FGPFCCR_CSS_Pos)        /*!< 0x00080000 */
#define DMA2D_FGPFCCR_AI_Pos                (20U)
#define DMA2D_FGPFCCR_AI_Msk                (0x1UL << DMA2D_FGPFCCR_AI_Pos)         /*!< 0x00100000 */
#define DMA2D_FGPFCCR_AI                    DMA2D_FGPFCCR_AI_Msk                    /*!< Foreground Input Alpha Inverted */
#define DMA2D_FGPFCCR_RBS_Pos               (21U)
#define DMA2D_FGPFCCR_RBS_Msk               (0x1UL << DMA2D_FGPFCCR_RBS_Pos)        /*!< 0x00200000 */
#define DMA2D_FGPFCCR_RBS                   DMA2D_FGPFCCR_RBS_Msk                   /*!< Foreground Input Red Blue Swap */
#define DMA2D_FGPFCCR_ALPHA_Pos             (24U)
#define DMA2D_FGPFCCR_ALPHA_Msk             (0xFFUL << DMA2D_FGPFCCR_ALPHA_Pos)     /*!< 0xFF000000 */
#define DMA2D_FGPFCCR_ALPHA                 DMA2D_FGPFCCR_ALPHA_Msk                 /*!< Alpha value */

/********************  Bit definition for DMA2D_FGCOLR register  **************/
#define DMA2D_FGCOLR_BLUE_Pos               (0U)
#define DMA2D_FGCOLR_BLUE_Msk               (0xFFUL << DMA2D_FGCOLR_BLUE_Pos)       /*!< 0x000000FF */
#define DMA2D_FGCOLR_BLUE                   DMA2D_FGCOLR_BLUE_Msk                   /*!< Foreground Blue Value */
#define DMA2D_FGCOLR_GREEN_Pos              (8U)
#define DMA2D_FGCOLR_GREEN_Msk              (0xFFUL << DMA2D_FGCOLR_GREEN_Pos)      /*!< 0x0000FF00 */
#define DMA2D_FGCOLR_GREEN                  DMA2D_FGCOLR_GREEN_Msk                  /*!< Foreground Green Value */
#define DMA2D_FGCOLR_RED_Pos                (16U)
#define DMA2D_FGCOLR_RED_Msk                (0xFFUL << DMA2D_FGCOLR_RED_Pos)        /*!< 0x00FF0000 */
#define DMA2D_FGCOLR_RED                    DMA2D_FGCOLR_RED_Msk                    /*!< Foreground Red Value */

/********************  Bit definition for DMA2D_BGPFCCR register  *************/
#define DMA2D_BGPFCCR_CM_Pos                (0U)
#define DMA2D_BGPFCCR_CM_Msk                (0xFUL << DMA2D_BGPFCCR_CM_Pos)         /*!< 0x0000000F */
#define DMA2D_BGPFCCR_CM                    DMA2D_BGPFCCR_CM_Msk                    /*!< Input color mode CM[3:0] */
#define DMA2D_BGPFCCR_CM_0                  (0x1UL << DMA2D_BGPFCCR_CM_Pos)         /*!< 0x00000001 */
#define DMA2D_BGPFCCR_CM_1                  (0x2UL << DMA2D_BGPFCCR_CM_Pos)         /*!< 0x00000002 */
#define DMA2D_BGPFCCR_CM_2                  (0x4UL << DMA2D_BGPFCCR_CM_Pos)         /*!< 0x00000004 */
#define DMA2D_BGPFCCR_CM_3                  (0x8UL << DMA2D_BGPFCCR_CM_Pos)         /*!< 0x00000008 */
#define DMA2D_BGPFCCR_CCM_Pos               (4U)
#define DMA2D_BGPFCCR_CCM_Msk               (0x1UL << DMA2D_BGPFCCR_CCM_Pos)        /*!< 0x00000010 */
#define DMA2D_BGPFCCR_CCM                   DMA2D_BGPFCCR_CCM_Msk                   /*!< CLUT Color mode */
#define DMA2D_BGPFCCR_START_Pos             (5U)
#define DMA2D_BGPFCCR_START_Msk             (0x1UL << DMA2D_BGPFCCR_START_Pos)      /*!< 0x00000020 */
#define DMA2D_BGPFCCR_START                 DMA2D_BGPFCCR_START_Msk                 /*!< Start */
#define DMA2D_BGPFCCR_CS_Pos                (8U)
#define DMA2D_BGPFCCR_CS_Msk                (0xFFUL << DMA2D_BGPFCCR_CS_Pos)        /*!< 0x0000FF00 */
#define DMA2D_BGPFCCR_CS                    DMA2D_BGPFCCR_CS_Msk                    /*!< CLUT size */
#define DMA2D_BGPFCCR_AM_Pos                (16U)
#define DMA2D_BGPFCCR_AM_Msk                (0x3UL << DMA2D_BGPFCCR_AM_Pos)         /*!< 0x00030000 */
#define DMA2D_BGPFCCR_AM                    DMA2D_BGPFCCR_AM_Msk                    /*!< Alpha mode AM[1:0] */
#define DMA2D_BGPFCCR_AM_0                  (0x1UL << DMA2D_BGPFCCR_AM_Pos)         /*!< 0x00010000 */
#define DMA2D_BGPFCCR_AM_1                  (0x2UL << DMA2D_BGPFCCR_AM_Pos)         /*!< 0x00020000 */
#define DMA2D_BGPFCCR_AI_Pos                (20U)
#define DMA2D_BGPFCCR_AI_Msk                (0x1UL << DMA2D_BGPFCCR_AI_Pos)         /*!< 0x00100000 */
#define DMA2D_BGPFCCR_AI                    DMA2D_BGPFCCR_AI_Msk                    /*!< background Input Alpha Inverted */
#define DMA2D_BGPFCCR_RBS_Pos               (21U)
#define DMA2D_BGPFCCR_RBS_Msk               (0x1UL << DMA2D_BGPFCCR_RBS_Pos)        /*!< 0x00200000 */
#define DMA2D_BGPFCCR_RBS                   DMA2D_BGPFCCR_RBS_Msk                   /*!< Background Input Red Blue Swap */
#define DMA2D_BGPFCCR_ALPHA_Pos             (24U)
#define DMA2D_BGPFCCR_ALPHA_Msk             (0xFFUL << DMA2D_BGPFCCR_ALPHA_Pos)     /*!< 0xFF000000 */
#define DMA2D_BGPFCCR_ALPHA                 DMA2D_BGPFCCR_ALPHA_Msk                 /*!< background Input Alpha value */

/********************  Bit definition for DMA2D_BGCOLR register  **************/
#define DMA2D_BGCOLR_BLUE_Pos               (0U)
#define DMA2D_BGCOLR_BLUE_Msk               (0xFFUL << DMA2D_BGCOLR_BLUE_Pos)       /*!< 0x000000FF */
#define DMA2D_BGCOLR_BLUE                   DMA2D_BGCOLR_BLUE_Msk                   /*!< Background Blue Value */
#define DMA2D_BGCOLR_GREEN_Pos              (8U)
#define DMA2D_BGCOLR_GREEN_Msk              (0xFFUL << DMA2D_BGCOLR_GREEN_Pos)      /*!< 0x0000FF00 */
#define DMA2D_BGCOLR_GREEN                  DMA2D_BGCOLR_GREEN_Msk                  /*!< Background Green Value */
#define DMA2D_BGCOLR_RED_Pos                (16U)
#define DMA2D_BGCOLR_RED_Msk                (0xFFUL << DMA2D_BGCOLR_RED_Pos)        /*!< 0x00FF0000 */
#define DMA2D_BGCOLR_RED                    DMA2D_BGCOLR_RED_Msk                    /*!< Background Red Value */

/********************  Bit definition for DMA2D_FGCMAR register  **************/
#define DMA2D_FGCMAR_MA_Pos                 (0U)
#define DMA2D_FGCMAR_MA_Msk                 (0xFFFFFFFFUL << DMA2D_FGCMAR_MA_Pos)   /*!< 0xFFFFFFFF */
#define DMA2D_FGCMAR_MA                     DMA2D_FGCMAR_MA_Msk                     /*!< Foreground CLUT Memory Address */

/********************  Bit definition for DMA2D_BGCMAR register  **************/
#define DMA2D_BGCMAR_MA_Pos                 (0U)
#define DMA2D_BGCMAR_MA_Msk                 (0xFFFFFFFFUL << DMA2D_BGCMAR_MA_Pos)   /*!< 0xFFFFFFFF */
#define DMA2D_BGCMAR_MA                     DMA2D_BGCMAR_MA_Msk                     /*!< Background CLUT Memory Address */

/********************  Bit definition for DMA2D_OPFCCR register  **************/
#define DMA2D_OPFCCR_CM_Pos                 (0U)
#define DMA2D_OPFCCR_CM_Msk                 (0x7UL << DMA2D_OPFCCR_CM_Pos)          /*!< 0x00000007 */
#define DMA2D_OPFCCR_CM                     DMA2D_OPFCCR_CM_Msk                     /*!< Output Color mode CM[2:0] */
#define DMA2D_OPFCCR_CM_0                   (0x1UL << DMA2D_OPFCCR_CM_Pos)          /*!< 0x00000001 */
#define DMA2D_OPFCCR_CM_1                   (0x2UL << DMA2D_OPFCCR_CM_Pos)          /*!< 0x00000002 */
#define DMA2D_OPFCCR_CM_2                   (0x4UL << DMA2D_OPFCCR_CM_Pos)          /*!< 0x00000004 */
#define DMA2D_OPFCCR_SB_Pos                 (8U)
#define DMA2D_OPFCCR_SB_Msk                 (0x1UL << DMA2D_OPFCCR_SB_Pos)          /*!< 0x00000100 */
#define DMA2D_OPFCCR_SB                     DMA2D_OPFCCR_SB_Msk                     /*!< Swap Bytes */
#define DMA2D_OPFCCR_AI_Pos                 (20U)
#define DMA2D_OPFCCR_AI_Msk                 (0x1UL << DMA2D_OPFCCR_AI_Pos)          /*!< 0x00100000 */
#define DMA2D_OPFCCR_AI                     DMA2D_OPFCCR_AI_Msk                     /*!< Output Alpha Inverted */
#define DMA2D_OPFCCR_RBS_Pos                (21U)
#define DMA2D_OPFCCR_RBS_Msk                (0x1UL << DMA2D_OPFCCR_RBS_Pos)         /*!< 0x00200000 */
#define DMA2D_OPFCCR_RBS                    DMA2D_OPFCCR_RBS_Msk                    /*!< Output Red Blue Swap */

/********************  Bit definition for DMA2D_OCOLR register  ***************/
/*!<Mode_ARGB8888/RGB888 */
#define DMA2D_OCOLR_BLUE_1_Pos              (0U)
#define DMA2D_OCOLR_BLUE_1_Msk              (0xFFUL << DMA2D_OCOLR_BLUE_1_Pos)      /*0x000000FFU*/
#define DMA2D_OCOLR_BLUE_1                  DMA2D_OCOLR_BLUE_1_Msk                  /*!< Output BLUE Value */
#define DMA2D_OCOLR_GREEN_1_Pos             (8U)
#define DMA2D_OCOLR_GREEN_1_Msk             (0xFFUL << DMA2D_OCOLR_GREEN_1_Pos)     /*0x0000FF00U)*/
#define DMA2D_OCOLR_GREEN_1                 DMA2D_OCOLR_GREEN_1_Msk                 /*!< Output GREEN Value  */
#define DMA2D_OCOLR_RED_1_Pos               (16U)
#define DMA2D_OCOLR_RED_1_Msk               (0xFFUL << DMA2D_OCOLR_RED_1_Pos)       /*0x00FF0000U */
#define DMA2D_OCOLR_RED_1                   DMA2D_OCOLR_RED_1_Msk                   /*!< Output Red Value */
#define DMA2D_OCOLR_ALPHA_1_Pos             (24U)
#define DMA2D_OCOLR_ALPHA_1_Msk             (0xFFUL << DMA2D_OCOLR_ALPHA_1_Pos)     /*0xFF000000U*/
#define DMA2D_OCOLR_ALPHA_1                 DMA2D_OCOLR_ALPHA_1_Msk                 /*!< Output Alpha Channel Value */
/*!<Mode_RGB565 */
#define DMA2D_OCOLR_BLUE_2_Pos              (0U)
#define DMA2D_OCOLR_BLUE_2_Msk              (0x1FUL << DMA2D_OCOLR_BLUE_2_Pos)      /*0x0000001FU*/
#define DMA2D_OCOLR_BLUE_2                  DMA2D_OCOLR_BLUE_2_Msk                  /*!< Output BLUE Value */
#define DMA2D_OCOLR_GREEN_2_Pos             (5U)
#define DMA2D_OCOLR_GREEN_2_Msk             (0x7EUL << DMA2D_OCOLR_GREEN_2_Pos)     /* 0x000007E0U */
#define DMA2D_OCOLR_GREEN_2                 DMA2D_OCOLR_GREEN_2_Msk                 /*!< Output GREEN Value  */
#define DMA2D_OCOLR_RED_2_Pos               (11U)
#define DMA2D_OCOLR_RED_2_Msk               (0xF8UL << DMA2D_OCOLR_RED_2_Pos)       /*0x0000F800U*/
#define DMA2D_OCOLR_RED_2                   DMA2D_OCOLR_RED_2_Msk                   /*!< Output Red Value */
/*!<Mode_ARGB1555 */
#define DMA2D_OCOLR_BLUE_3_Pos              (0U)
#define DMA2D_OCOLR_BLUE_3_Msk              (0x1FUL << DMA2D_OCOLR_BLUE_3_Pos)      /*0x0000001FU*/
#define DMA2D_OCOLR_BLUE_3                  DMA2D_OCOLR_BLUE_3_Msk                  /*!< Output BLUE Value */
#define DMA2D_OCOLR_GREEN_3_Pos             (5U)
#define DMA2D_OCOLR_GREEN_3_Msk             (0x3EUL << DMA2D_OCOLR_GREEN_3_Pos)     /*0x000003E0U*/
#define DMA2D_OCOLR_GREEN_3                 DMA2D_OCOLR_GREEN_3_Msk                 /*!< Output GREEN Value  */
#define DMA2D_OCOLR_RED_3_Pos               (10U)
#define DMA2D_OCOLR_RED_3_Msk               (0x7CUL << DMA2D_OCOLR_RED_3_Pos)       /* 0x00007C00U*/
#define DMA2D_OCOLR_RED_3                   DMA2D_OCOLR_RED_3_Msk                   /*!< Output Red Value */
#define DMA2D_OCOLR_ALPHA_3_Pos             (15U)
#define DMA2D_OCOLR_ALPHA_3_Msk             (0x1UL << DMA2D_OCOLR_ALPHA_3_Pos)      /*0x00008000U*/
#define DMA2D_OCOLR_ALPHA_3                 DMA2D_OCOLR_ALPHA_3_Msk                 /*!< Output Alpha Channel Value */
/*!<Mode_ARGB4444 */
#define DMA2D_OCOLR_BLUE_4_Pos              (0U)
#define DMA2D_OCOLR_BLUE_4_Msk              (0xFUL << DMA2D_OCOLR_BLUE_4_Pos)       /*0x0000000FU*/
#define DMA2D_OCOLR_BLUE_4                  DMA2D_OCOLR_BLUE_4_Msk                  /*!< Output BLUE Value */
#define DMA2D_OCOLR_GREEN_4_Pos             (4U)
#define DMA2D_OCOLR_GREEN_4_Msk             (0xFUL << DMA2D_OCOLR_GREEN_4_Pos)      /*0x000000F0U*/
#define DMA2D_OCOLR_GREEN_4                 DMA2D_OCOLR_GREEN_4_Msk                 /*!< Output GREEN Value  */
#define DMA2D_OCOLR_RED_4_Pos               (8U)
#define DMA2D_OCOLR_RED_4_Msk               (0xFUL << DMA2D_OCOLR_RED_4_Pos)        /*0x00000F00U*/
#define DMA2D_OCOLR_RED_4                   DMA2D_OCOLR_RED_4_Msk                   /*!< Output Red Value */
#define DMA2D_OCOLR_ALPHA_4_Pos             (12U)
#define DMA2D_OCOLR_ALPHA_4_Msk             (0xF << DMA2D_OCOLR_ALPHA_4_Pos)        /*0x0000F000U*/
#define DMA2D_OCOLR_ALPHA_4                 DMA2D_OCOLR_ALPHA_4_Msk                 /*!< Output Alpha Channel Value */

/********************  Bit definition for DMA2D_OMAR register  ****************/
#define DMA2D_OMAR_MA_Pos                   (0U)
#define DMA2D_OMAR_MA_Msk                   (0xFFFFFFFFUL << DMA2D_OMAR_MA_Pos)     /*!< 0xFFFFFFFF */
#define DMA2D_OMAR_MA                       DMA2D_OMAR_MA_Msk                       /*!< Output Memory Address */

/********************  Bit definition for DMA2D_OOR register  *****************/
#define DMA2D_OOR_LO_Pos                    (0U)
#define DMA2D_OOR_LO_Msk                    (0xFFFFUL << DMA2D_OOR_LO_Pos)          /*!< 0x0000FFFF */
#define DMA2D_OOR_LO                        DMA2D_OOR_LO_Msk                        /*!< Output Line Offset */

/********************  Bit definition for DMA2D_NLR register  *****************/
#define DMA2D_NLR_NL_Pos                    (0U)
#define DMA2D_NLR_NL_Msk                    (0xFFFFUL << DMA2D_NLR_NL_Pos)          /*!< 0x0000FFFF */
#define DMA2D_NLR_NL                        DMA2D_NLR_NL_Msk                        /*!< Number of Lines */
#define DMA2D_NLR_PL_Pos                    (16U)
#define DMA2D_NLR_PL_Msk                    (0x3FFFUL << DMA2D_NLR_PL_Pos)          /*!< 0x3FFF0000 */
#define DMA2D_NLR_PL                        DMA2D_NLR_PL_Msk                        /*!< Pixel per Lines */

/********************  Bit definition for DMA2D_LWR register  *****************/
#define DMA2D_LWR_LW_Pos                    (0U)
#define DMA2D_LWR_LW_Msk                    (0xFFFFUL << DMA2D_LWR_LW_Pos)          /*!< 0x0000FFFF */
#define DMA2D_LWR_LW                        DMA2D_LWR_LW_Msk                        /*!< Line Watermark */

/********************  Bit definition for DMA2D_AMTCR register  ***************/
#define DMA2D_AMTCR_EN_Pos                  (0U)
#define DMA2D_AMTCR_EN_Msk                  (0x1UL << DMA2D_AMTCR_EN_Pos)           /*!< 0x00000001 */
#define DMA2D_AMTCR_EN                      DMA2D_AMTCR_EN_Msk                      /*!< Enable */
#define DMA2D_AMTCR_DT_Pos                  (8U)
#define DMA2D_AMTCR_DT_Msk                  (0xFFUL << DMA2D_AMTCR_DT_Pos)          /*!< 0x0000FF00 */
#define DMA2D_AMTCR_DT                      DMA2D_AMTCR_DT_Msk                      /*!< Dead Time */

/******************************************************************************/
/*                                                                            */
/*                    External Interrupt/Event Controller                     */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for EXTI_RTSR1 register  ******************/
#define EXTI_RTSR1_RT0_Pos                  (0U)
#define EXTI_RTSR1_RT0_Msk                  (0x1UL << EXTI_RTSR1_RT0_Pos)           /*!< 0x00000001 */
#define EXTI_RTSR1_RT0                      EXTI_RTSR1_RT0_Msk                      /*!< Rising trigger configuration for input line 0 */
#define EXTI_RTSR1_RT1_Pos                  (1U)
#define EXTI_RTSR1_RT1_Msk                  (0x1UL << EXTI_RTSR1_RT1_Pos)           /*!< 0x00000002 */
#define EXTI_RTSR1_RT1                      EXTI_RTSR1_RT1_Msk                      /*!< Rising trigger configuration for input line 1 */
#define EXTI_RTSR1_RT2_Pos                  (2U)
#define EXTI_RTSR1_RT2_Msk                  (0x1UL << EXTI_RTSR1_RT2_Pos)           /*!< 0x00000004 */
#define EXTI_RTSR1_RT2                      EXTI_RTSR1_RT2_Msk                      /*!< Rising trigger configuration for input line 2 */
#define EXTI_RTSR1_RT3_Pos                  (3U)
#define EXTI_RTSR1_RT3_Msk                  (0x1UL << EXTI_RTSR1_RT3_Pos)           /*!< 0x00000008 */
#define EXTI_RTSR1_RT3                      EXTI_RTSR1_RT3_Msk                      /*!< Rising trigger configuration for input line 3 */
#define EXTI_RTSR1_RT4_Pos                  (4U)
#define EXTI_RTSR1_RT4_Msk                  (0x1UL << EXTI_RTSR1_RT4_Pos)           /*!< 0x00000010 */
#define EXTI_RTSR1_RT4                      EXTI_RTSR1_RT4_Msk                      /*!< Rising trigger configuration for input line 4 */
#define EXTI_RTSR1_RT5_Pos                  (5U)
#define EXTI_RTSR1_RT5_Msk                  (0x1UL << EXTI_RTSR1_RT5_Pos)           /*!< 0x00000020 */
#define EXTI_RTSR1_RT5                      EXTI_RTSR1_RT5_Msk                      /*!< Rising trigger configuration for input line 5 */
#define EXTI_RTSR1_RT6_Pos                  (6U)
#define EXTI_RTSR1_RT6_Msk                  (0x1UL << EXTI_RTSR1_RT6_Pos)           /*!< 0x00000040 */
#define EXTI_RTSR1_RT6                      EXTI_RTSR1_RT6_Msk                      /*!< Rising trigger configuration for input line 6 */
#define EXTI_RTSR1_RT7_Pos                  (7U)
#define EXTI_RTSR1_RT7_Msk                  (0x1UL << EXTI_RTSR1_RT7_Pos)           /*!< 0x00000080 */
#define EXTI_RTSR1_RT7                      EXTI_RTSR1_RT7_Msk                      /*!< Rising trigger configuration for input line 7 */
#define EXTI_RTSR1_RT8_Pos                  (8U)
#define EXTI_RTSR1_RT8_Msk                  (0x1UL << EXTI_RTSR1_RT8_Pos)           /*!< 0x00000100 */
#define EXTI_RTSR1_RT8                      EXTI_RTSR1_RT8_Msk                      /*!< Rising trigger configuration for input line 8 */
#define EXTI_RTSR1_RT9_Pos                  (9U)
#define EXTI_RTSR1_RT9_Msk                  (0x1UL << EXTI_RTSR1_RT9_Pos)           /*!< 0x00000200 */
#define EXTI_RTSR1_RT9                      EXTI_RTSR1_RT9_Msk                      /*!< Rising trigger configuration for input line 9 */
#define EXTI_RTSR1_RT10_Pos                 (10U)
#define EXTI_RTSR1_RT10_Msk                 (0x1UL << EXTI_RTSR1_RT10_Pos)          /*!< 0x00000400 */
#define EXTI_RTSR1_RT10                     EXTI_RTSR1_RT10_Msk                     /*!< Rising trigger configuration for input line 10 */
#define EXTI_RTSR1_RT11_Pos                 (11U)
#define EXTI_RTSR1_RT11_Msk                 (0x1UL << EXTI_RTSR1_RT11_Pos)          /*!< 0x00000800 */
#define EXTI_RTSR1_RT11                     EXTI_RTSR1_RT11_Msk                     /*!< Rising trigger configuration for input line 11 */
#define EXTI_RTSR1_RT12_Pos                 (12U)
#define EXTI_RTSR1_RT12_Msk                 (0x1UL << EXTI_RTSR1_RT12_Pos)          /*!< 0x00001000 */
#define EXTI_RTSR1_RT12                     EXTI_RTSR1_RT12_Msk                     /*!< Rising trigger configuration for input line 12 */
#define EXTI_RTSR1_RT13_Pos                 (13U)
#define EXTI_RTSR1_RT13_Msk                 (0x1UL << EXTI_RTSR1_RT13_Pos)          /*!< 0x00002000 */
#define EXTI_RTSR1_RT13                     EXTI_RTSR1_RT13_Msk                     /*!< Rising trigger configuration for input line 13 */
#define EXTI_RTSR1_RT14_Pos                 (14U)
#define EXTI_RTSR1_RT14_Msk                 (0x1UL << EXTI_RTSR1_RT14_Pos)          /*!< 0x00004000 */
#define EXTI_RTSR1_RT14                     EXTI_RTSR1_RT14_Msk                     /*!< Rising trigger configuration for input line 14 */
#define EXTI_RTSR1_RT15_Pos                 (15U)
#define EXTI_RTSR1_RT15_Msk                 (0x1UL << EXTI_RTSR1_RT15_Pos)          /*!< 0x00008000 */
#define EXTI_RTSR1_RT15                     EXTI_RTSR1_RT15_Msk                     /*!< Rising trigger configuration for input line 15 */
#define EXTI_RTSR1_RT16_Pos                 (16U)
#define EXTI_RTSR1_RT16_Msk                 (0x1UL << EXTI_RTSR1_RT16_Pos)          /*!< 0x00010000 */
#define EXTI_RTSR1_RT16                     EXTI_RTSR1_RT16_Msk                     /*!< Rising trigger configuration for input line 16 */
#define EXTI_RTSR1_RT17_Pos                 (17U)
#define EXTI_RTSR1_RT17_Msk                 (0x1UL << EXTI_RTSR1_RT17_Pos)          /*!< 0x00020000 */
#define EXTI_RTSR1_RT17                     EXTI_RTSR1_RT17_Msk                     /*!< Rising trigger configuration for input line 17 */
#define EXTI_RTSR1_RT18_Pos                 (18U)
#define EXTI_RTSR1_RT18_Msk                 (0x1UL << EXTI_RTSR1_RT18_Pos)          /*!< 0x00040000 */
#define EXTI_RTSR1_RT18                     EXTI_RTSR1_RT18_Msk                     /*!< Rising trigger configuration for input line 18 */
#define EXTI_RTSR1_RT19_Pos                 (19U)
#define EXTI_RTSR1_RT19_Msk                 (0x1UL << EXTI_RTSR1_RT19_Pos)          /*!< 0x00080000 */
#define EXTI_RTSR1_RT19                     EXTI_RTSR1_RT19_Msk                     /*!< Rising trigger configuration for input line 19 */
#define EXTI_RTSR1_RT20_Pos                 (20U)
#define EXTI_RTSR1_RT20_Msk                 (0x1UL << EXTI_RTSR1_RT20_Pos)          /*!< 0x00100000 */
#define EXTI_RTSR1_RT20                     EXTI_RTSR1_RT20_Msk                     /*!< Rising trigger configuration for input line 20 */
#define EXTI_RTSR1_RT21_Pos                 (21U)
#define EXTI_RTSR1_RT21_Msk                 (0x1UL << EXTI_RTSR1_RT21_Pos)          /*!< 0x00200000 */
#define EXTI_RTSR1_RT21                     EXTI_RTSR1_RT21_Msk                     /*!< Rising trigger configuration for input line 21 */
#define EXTI_RTSR1_RT22_Pos                 (22U)
#define EXTI_RTSR1_RT22_Msk                 (0x1UL << EXTI_RTSR1_RT22_Pos)          /*!< 0x00400000 */
#define EXTI_RTSR1_RT22                     EXTI_RTSR1_RT22_Msk                     /*!< Rising trigger configuration for input line 22 */
#define EXTI_RTSR1_RT23_Pos                 (23U)
#define EXTI_RTSR1_RT23_Msk                 (0x1UL << EXTI_RTSR1_RT23_Pos)          /*!< 0x00800000 */
#define EXTI_RTSR1_RT23                     EXTI_RTSR1_RT23_Msk                     /*!< Rising trigger configuration for input line 23 */
#define EXTI_RTSR1_RT24_Pos                 (24U)
#define EXTI_RTSR1_RT24_Msk                 (0x1UL << EXTI_RTSR1_RT24_Pos)          /*!< 0x01000000 */
#define EXTI_RTSR1_RT24                     EXTI_RTSR1_RT24_Msk                     /*!< Rising trigger configuration for input line 24 */
#define EXTI_RTSR1_RT25_Pos                  (25U)
#define EXTI_RTSR1_RT25_Msk                 (0x1UL << EXTI_RTSR1_RT25_Pos)          /*!< 0x02000000 */
#define EXTI_RTSR1_RT25                     EXTI_RTSR1_RT25_Msk                     /*!< Rising trigger configuration for input line 24 */

/******************  Bit definition for EXTI_FTSR1 register  ******************/
#define EXTI_FTSR1_FT0_Pos                  (0U)
#define EXTI_FTSR1_FT0_Msk                  (0x1UL << EXTI_FTSR1_FT0_Pos)           /*!< 0x00000001 */
#define EXTI_FTSR1_FT0                      EXTI_FTSR1_FT0_Msk                      /*!< Falling trigger configuration for input line 0 */
#define EXTI_FTSR1_FT1_Pos                  (1U)
#define EXTI_FTSR1_FT1_Msk                  (0x1UL << EXTI_FTSR1_FT1_Pos)           /*!< 0x00000002 */
#define EXTI_FTSR1_FT1                      EXTI_FTSR1_FT1_Msk                      /*!< Falling trigger configuration for input line 1 */
#define EXTI_FTSR1_FT2_Pos                  (2U)
#define EXTI_FTSR1_FT2_Msk                  (0x1UL << EXTI_FTSR1_FT2_Pos)           /*!< 0x00000004 */
#define EXTI_FTSR1_FT2                      EXTI_FTSR1_FT2_Msk                      /*!< Falling trigger configuration for input line 2 */
#define EXTI_FTSR1_FT3_Pos                  (3U)
#define EXTI_FTSR1_FT3_Msk                  (0x1UL << EXTI_FTSR1_FT3_Pos)           /*!< 0x00000008 */
#define EXTI_FTSR1_FT3                      EXTI_FTSR1_FT3_Msk                      /*!< Falling trigger configuration for input line 3 */
#define EXTI_FTSR1_FT4_Pos                  (4U)
#define EXTI_FTSR1_FT4_Msk                  (0x1UL << EXTI_FTSR1_FT4_Pos)           /*!< 0x00000010 */
#define EXTI_FTSR1_FT4                      EXTI_FTSR1_FT4_Msk                      /*!< Falling trigger configuration for input line 4 */
#define EXTI_FTSR1_FT5_Pos                  (5U)
#define EXTI_FTSR1_FT5_Msk                  (0x1UL << EXTI_FTSR1_FT5_Pos)           /*!< 0x00000020 */
#define EXTI_FTSR1_FT5                      EXTI_FTSR1_FT5_Msk                      /*!< Falling trigger configuration for input line 5 */
#define EXTI_FTSR1_FT6_Pos                  (6U)
#define EXTI_FTSR1_FT6_Msk                  (0x1UL << EXTI_FTSR1_FT6_Pos)           /*!< 0x00000040 */
#define EXTI_FTSR1_FT6                      EXTI_FTSR1_FT6_Msk                      /*!< Falling trigger configuration for input line 6 */
#define EXTI_FTSR1_FT7_Pos                  (7U)
#define EXTI_FTSR1_FT7_Msk                  (0x1UL << EXTI_FTSR1_FT7_Pos)           /*!< 0x00000080 */
#define EXTI_FTSR1_FT7                      EXTI_FTSR1_FT7_Msk                      /*!< Falling trigger configuration for input line 7 */
#define EXTI_FTSR1_FT8_Pos                  (8U)
#define EXTI_FTSR1_FT8_Msk                  (0x1UL << EXTI_FTSR1_FT8_Pos)           /*!< 0x00000100 */
#define EXTI_FTSR1_FT8                      EXTI_FTSR1_FT8_Msk                      /*!< Falling trigger configuration for input line 8 */
#define EXTI_FTSR1_FT9_Pos                  (9U)
#define EXTI_FTSR1_FT9_Msk                  (0x1UL << EXTI_FTSR1_FT9_Pos)           /*!< 0x00000200 */
#define EXTI_FTSR1_FT9                      EXTI_FTSR1_FT9_Msk                      /*!< Falling trigger configuration for input line 9 */
#define EXTI_FTSR1_FT10_Pos                 (10U)
#define EXTI_FTSR1_FT10_Msk                 (0x1UL << EXTI_FTSR1_FT10_Pos)          /*!< 0x00000400 */
#define EXTI_FTSR1_FT10                     EXTI_FTSR1_FT10_Msk                     /*!< Falling trigger configuration for input line 10 */
#define EXTI_FTSR1_FT11_Pos                 (11U)
#define EXTI_FTSR1_FT11_Msk                 (0x1UL << EXTI_FTSR1_FT11_Pos)          /*!< 0x00000800 */
#define EXTI_FTSR1_FT11                     EXTI_FTSR1_FT11_Msk                     /*!< Falling trigger configuration for input line 11 */
#define EXTI_FTSR1_FT12_Pos                 (12U)
#define EXTI_FTSR1_FT12_Msk                 (0x1UL << EXTI_FTSR1_FT12_Pos)          /*!< 0x00001000 */
#define EXTI_FTSR1_FT12                     EXTI_FTSR1_FT12_Msk                     /*!< Falling trigger configuration for input line 12 */
#define EXTI_FTSR1_FT13_Pos                 (13U)
#define EXTI_FTSR1_FT13_Msk                 (0x1UL << EXTI_FTSR1_FT13_Pos)          /*!< 0x00002000 */
#define EXTI_FTSR1_FT13                     EXTI_FTSR1_FT13_Msk                     /*!< Falling trigger configuration for input line 13 */
#define EXTI_FTSR1_FT14_Pos                 (14U)
#define EXTI_FTSR1_FT14_Msk                 (0x1UL << EXTI_FTSR1_FT14_Pos)          /*!< 0x00004000 */
#define EXTI_FTSR1_FT14                     EXTI_FTSR1_FT14_Msk                     /*!< Falling trigger configuration for input line 14 */
#define EXTI_FTSR1_FT15_Pos                 (15U)
#define EXTI_FTSR1_FT15_Msk                 (0x1UL << EXTI_FTSR1_FT15_Pos)          /*!< 0x00008000 */
#define EXTI_FTSR1_FT15                     EXTI_FTSR1_FT15_Msk                     /*!< Falling trigger configuration for input line 15 */
#define EXTI_FTSR1_FT16_Pos                 (16U)
#define EXTI_FTSR1_FT16_Msk                 (0x1UL << EXTI_FTSR1_FT16_Pos)          /*!< 0x00010000 */
#define EXTI_FTSR1_FT16                     EXTI_FTSR1_FT16_Msk                     /*!< Falling trigger configuration for input line 16 */
#define EXTI_FTSR1_FT17_Pos                 (17U)
#define EXTI_FTSR1_FT17_Msk                 (0x1UL << EXTI_FTSR1_FT17_Pos)          /*!< 0x00020000 */
#define EXTI_FTSR1_FT17                     EXTI_FTSR1_FT17_Msk                     /*!< Falling trigger configuration for input line 17 */
#define EXTI_FTSR1_FT18_Pos                 (18U)
#define EXTI_FTSR1_FT18_Msk                 (0x1UL << EXTI_FTSR1_FT18_Pos)          /*!< 0x00040000 */
#define EXTI_FTSR1_FT18                     EXTI_FTSR1_FT18_Msk                     /*!< Falling trigger configuration for input line 18 */
#define EXTI_FTSR1_FT19_Pos                 (19U)
#define EXTI_FTSR1_FT19_Msk                 (0x1UL << EXTI_FTSR1_FT19_Pos)          /*!< 0x00080000 */
#define EXTI_FTSR1_FT19                     EXTI_FTSR1_FT19_Msk                     /*!< Falling trigger configuration for input line 19 */
#define EXTI_FTSR1_FT20_Pos                 (20U)
#define EXTI_FTSR1_FT20_Msk                 (0x1UL << EXTI_FTSR1_FT20_Pos)          /*!< 0x00100000 */
#define EXTI_FTSR1_FT20                     EXTI_FTSR1_FT20_Msk                     /*!< Falling trigger configuration for input line 20 */
#define EXTI_FTSR1_FT21_Pos                 (21U)
#define EXTI_FTSR1_FT21_Msk                 (0x1UL << EXTI_FTSR1_FT21_Pos)          /*!< 0x00200000 */
#define EXTI_FTSR1_FT21                     EXTI_FTSR1_FT21_Msk                     /*!< Falling trigger configuration for input line 21 */
#define EXTI_FTSR1_FT22_Pos                 (22U)
#define EXTI_FTSR1_FT22_Msk                 (0x1UL << EXTI_FTSR1_FT22_Pos)          /*!< 0x00400000 */
#define EXTI_FTSR1_FT22                     EXTI_FTSR1_FT22_Msk                     /*!< Falling trigger configuration for input line 22 */
#define EXTI_FTSR1_FT23_Pos                 (23U)
#define EXTI_FTSR1_FT23_Msk                 (0x1UL << EXTI_FTSR1_FT23_Pos)          /*!< 0x00800000 */
#define EXTI_FTSR1_FT23                     EXTI_FTSR1_FT23_Msk                     /*!< Falling trigger configuration for input line 23 */
#define EXTI_FTSR1_FT24_Pos                 (24U)
#define EXTI_FTSR1_FT24_Msk                 (0x1UL << EXTI_FTSR1_FT24_Pos)          /*!< 0x01000000 */
#define EXTI_FTSR1_FT24                     EXTI_FTSR1_FT24_Msk                     /*!< Falling trigger configuration for input line 24 */
#define EXTI_FTSR1_FT25_Pos                 (25U)
#define EXTI_FTSR1_FT25_Msk                 (0x1UL << EXTI_FTSR1_FT25_Pos)          /*!< 0x02000000 */
#define EXTI_FTSR1_FT25                     EXTI_FTSR1_FT25_Msk                     /*!< Falling trigger configuration for input line 25 */

/******************  Bit definition for EXTI_SWIER1 register  *****************/
#define EXTI_SWIER1_SWI0_Pos                (0U)
#define EXTI_SWIER1_SWI0_Msk                (0x1UL << EXTI_SWIER1_SWI0_Pos)         /*!< 0x00000001 */
#define EXTI_SWIER1_SWI0                    EXTI_SWIER1_SWI0_Msk                    /*!< Software Interrupt on line 0 */
#define EXTI_SWIER1_SWI1_Pos                (1U)
#define EXTI_SWIER1_SWI1_Msk                (0x1UL << EXTI_SWIER1_SWI1_Pos)         /*!< 0x00000002 */
#define EXTI_SWIER1_SWI1                    EXTI_SWIER1_SWI1_Msk                    /*!< Software Interrupt on line 1 */
#define EXTI_SWIER1_SWI2_Pos                (2U)
#define EXTI_SWIER1_SWI2_Msk                (0x1UL << EXTI_SWIER1_SWI2_Pos)         /*!< 0x00000004 */
#define EXTI_SWIER1_SWI2                    EXTI_SWIER1_SWI2_Msk                    /*!< Software Interrupt on line 2 */
#define EXTI_SWIER1_SWI3_Pos                (3U)
#define EXTI_SWIER1_SWI3_Msk                (0x1UL << EXTI_SWIER1_SWI3_Pos)         /*!< 0x00000008 */
#define EXTI_SWIER1_SWI3                    EXTI_SWIER1_SWI3_Msk                    /*!< Software Interrupt on line 3 */
#define EXTI_SWIER1_SWI4_Pos                (4U)
#define EXTI_SWIER1_SWI4_Msk                (0x1UL << EXTI_SWIER1_SWI4_Pos)         /*!< 0x00000010 */
#define EXTI_SWIER1_SWI4                    EXTI_SWIER1_SWI4_Msk                    /*!< Software Interrupt on line 4 */
#define EXTI_SWIER1_SWI5_Pos                (5U)
#define EXTI_SWIER1_SWI5_Msk                (0x1UL << EXTI_SWIER1_SWI5_Pos)         /*!< 0x00000020 */
#define EXTI_SWIER1_SWI5                    EXTI_SWIER1_SWI5_Msk                    /*!< Software Interrupt on line 5 */
#define EXTI_SWIER1_SWI6_Pos                (6U)
#define EXTI_SWIER1_SWI6_Msk                (0x1UL << EXTI_SWIER1_SWI6_Pos)         /*!< 0x00000040 */
#define EXTI_SWIER1_SWI6                    EXTI_SWIER1_SWI6_Msk                    /*!< Software Interrupt on line 6 */
#define EXTI_SWIER1_SWI7_Pos                (7U)
#define EXTI_SWIER1_SWI7_Msk                (0x1UL << EXTI_SWIER1_SWI7_Pos)         /*!< 0x00000080 */
#define EXTI_SWIER1_SWI7                    EXTI_SWIER1_SWI7_Msk                    /*!< Software Interrupt on line 7 */
#define EXTI_SWIER1_SWI8_Pos                (8U)
#define EXTI_SWIER1_SWI8_Msk                (0x1UL << EXTI_SWIER1_SWI8_Pos)         /*!< 0x00000100 */
#define EXTI_SWIER1_SWI8                    EXTI_SWIER1_SWI8_Msk                    /*!< Software Interrupt on line 8 */
#define EXTI_SWIER1_SWI9_Pos                (9U)
#define EXTI_SWIER1_SWI9_Msk                (0x1UL << EXTI_SWIER1_SWI9_Pos)         /*!< 0x00000200 */
#define EXTI_SWIER1_SWI9                    EXTI_SWIER1_SWI9_Msk                    /*!< Software Interrupt on line 9 */
#define EXTI_SWIER1_SWI10_Pos               (10U)
#define EXTI_SWIER1_SWI10_Msk               (0x1UL << EXTI_SWIER1_SWI10_Pos)        /*!< 0x00000400 */
#define EXTI_SWIER1_SWI10                   EXTI_SWIER1_SWI10_Msk                   /*!< Software Interrupt on line 10 */
#define EXTI_SWIER1_SWI11_Pos               (11U)
#define EXTI_SWIER1_SWI11_Msk               (0x1UL << EXTI_SWIER1_SWI11_Pos)        /*!< 0x00000800 */
#define EXTI_SWIER1_SWI11                   EXTI_SWIER1_SWI11_Msk                   /*!< Software Interrupt on line 11 */
#define EXTI_SWIER1_SWI12_Pos               (12U)
#define EXTI_SWIER1_SWI12_Msk               (0x1UL << EXTI_SWIER1_SWI12_Pos)        /*!< 0x00001000 */
#define EXTI_SWIER1_SWI12                   EXTI_SWIER1_SWI12_Msk                   /*!< Software Interrupt on line 12 */
#define EXTI_SWIER1_SWI13_Pos               (13U)
#define EXTI_SWIER1_SWI13_Msk               (0x1UL << EXTI_SWIER1_SWI13_Pos)        /*!< 0x00002000 */
#define EXTI_SWIER1_SWI13                   EXTI_SWIER1_SWI13_Msk                   /*!< Software Interrupt on line 13 */
#define EXTI_SWIER1_SWI14_Pos               (14U)
#define EXTI_SWIER1_SWI14_Msk               (0x1UL << EXTI_SWIER1_SWI14_Pos)        /*!< 0x00004000 */
#define EXTI_SWIER1_SWI14                   EXTI_SWIER1_SWI14_Msk                   /*!< Software Interrupt on line 14 */
#define EXTI_SWIER1_SWI15_Pos               (15U)
#define EXTI_SWIER1_SWI15_Msk               (0x1UL << EXTI_SWIER1_SWI15_Pos)        /*!< 0x00008000 */
#define EXTI_SWIER1_SWI15                   EXTI_SWIER1_SWI15_Msk                   /*!< Software Interrupt on line 15 */
#define EXTI_SWIER1_SWI16_Pos               (16U)
#define EXTI_SWIER1_SWI16_Msk               (0x1UL << EXTI_SWIER1_SWI16_Pos)        /*!< 0x00010000 */
#define EXTI_SWIER1_SWI16                   EXTI_SWIER1_SWI16_Msk                   /*!< Software Interrupt on line 16 */
#define EXTI_SWIER1_SWI17_Pos               (17U)
#define EXTI_SWIER1_SWI17_Msk               (0x1UL << EXTI_SWIER1_SWI17_Pos)        /*!< 0x00020000 */
#define EXTI_SWIER1_SWI17                   EXTI_SWIER1_SWI17_Msk                   /*!< Software Interrupt on line 17 */
#define EXTI_SWIER1_SWI18_Pos               (18U)
#define EXTI_SWIER1_SWI18_Msk               (0x1UL << EXTI_SWIER1_SWI18_Pos)        /*!< 0x00040000 */
#define EXTI_SWIER1_SWI18                   EXTI_SWIER1_SWI18_Msk                   /*!< Software Interrupt on line 18 */
#define EXTI_SWIER1_SWI19_Pos               (19U)
#define EXTI_SWIER1_SWI19_Msk               (0x1UL << EXTI_SWIER1_SWI19_Pos)        /*!< 0x00080000 */
#define EXTI_SWIER1_SWI19                   EXTI_SWIER1_SWI19_Msk                   /*!< Software Interrupt on line 19 */
#define EXTI_SWIER1_SWI20_Pos               (20U)
#define EXTI_SWIER1_SWI20_Msk               (0x1UL << EXTI_SWIER1_SWI20_Pos)        /*!< 0x00100000 */
#define EXTI_SWIER1_SWI20                   EXTI_SWIER1_SWI20_Msk                   /*!< Software Interrupt on line 20 */
#define EXTI_SWIER1_SWI21_Pos               (21U)
#define EXTI_SWIER1_SWI21_Msk               (0x1UL << EXTI_SWIER1_SWI21_Pos)        /*!< 0x00200000 */
#define EXTI_SWIER1_SWI21                   EXTI_SWIER1_SWI21_Msk                   /*!< Software Interrupt on line 21 */
#define EXTI_SWIER1_SWI22_Pos               (22U)
#define EXTI_SWIER1_SWI22_Msk               (0x1UL << EXTI_SWIER1_SWI22_Pos)        /*!< 0x00400000 */
#define EXTI_SWIER1_SWI22                   EXTI_SWIER1_SWI22_Msk                   /*!< Software Interrupt on line 22 */
#define EXTI_SWIER1_SWI23_Pos               (23U)
#define EXTI_SWIER1_SWI23_Msk               (0x1UL << EXTI_SWIER1_SWI23_Pos)        /*!< 0x00800000 */
#define EXTI_SWIER1_SWI23                   EXTI_SWIER1_SWI23_Msk                   /*!< Software Interrupt on line 23 */
#define EXTI_SWIER1_SWI24_Pos               (24U)
#define EXTI_SWIER1_SWI24_Msk               (0x1UL << EXTI_SWIER1_SWI24_Pos)        /*!< 0x01000000 */
#define EXTI_SWIER1_SWI24                   EXTI_SWIER1_SWI24_Msk                   /*!< Software Interrupt on line 24 */
#define EXTI_SWIER1_SWI25_Pos               (25U)
#define EXTI_SWIER1_SWI25_Msk               (0x1UL << EXTI_SWIER1_SWI25_Pos)        /*!< 0x02000000 */
#define EXTI_SWIER1_SWI25                   EXTI_SWIER1_SWI25_Msk                   /*!< Software Interrupt on line 25 */

/*******************  Bit definition for EXTI_RPR1 register  ******************/
#define EXTI_RPR1_RPIF0_Pos                 (0U)
#define EXTI_RPR1_RPIF0_Msk                 (0x1UL << EXTI_RPR1_RPIF0_Pos)          /*!< 0x00000001 */
#define EXTI_RPR1_RPIF0                     EXTI_RPR1_RPIF0_Msk                     /*!< Rising Pending Interrupt Flag on line 0 */
#define EXTI_RPR1_RPIF1_Pos                 (1U)
#define EXTI_RPR1_RPIF1_Msk                 (0x1UL << EXTI_RPR1_RPIF1_Pos)          /*!< 0x00000002 */
#define EXTI_RPR1_RPIF1                     EXTI_RPR1_RPIF1_Msk                     /*!< Rising Pending Interrupt Flag on line 1 */
#define EXTI_RPR1_RPIF2_Pos                 (2U)
#define EXTI_RPR1_RPIF2_Msk                 (0x1UL << EXTI_RPR1_RPIF2_Pos)          /*!< 0x00000004 */
#define EXTI_RPR1_RPIF2                     EXTI_RPR1_RPIF2_Msk                     /*!< Rising Pending Interrupt Flag on line 2 */
#define EXTI_RPR1_RPIF3_Pos                 (3U)
#define EXTI_RPR1_RPIF3_Msk                 (0x1UL << EXTI_RPR1_RPIF3_Pos)          /*!< 0x00000008 */
#define EXTI_RPR1_RPIF3                     EXTI_RPR1_RPIF3_Msk                     /*!< Rising Pending Interrupt Flag on line 3 */
#define EXTI_RPR1_RPIF4_Pos                 (4U)
#define EXTI_RPR1_RPIF4_Msk                 (0x1UL << EXTI_RPR1_RPIF4_Pos)          /*!< 0x00000010 */
#define EXTI_RPR1_RPIF4                     EXTI_RPR1_RPIF4_Msk                     /*!< Rising Pending Interrupt Flag on line 4 */
#define EXTI_RPR1_RPIF5_Pos                 (5U)
#define EXTI_RPR1_RPIF5_Msk                 (0x1UL << EXTI_RPR1_RPIF5_Pos)          /*!< 0x00000020 */
#define EXTI_RPR1_RPIF5                     EXTI_RPR1_RPIF5_Msk                     /*!< Rising Pending Interrupt Flag on line 5 */
#define EXTI_RPR1_RPIF6_Pos                 (6U)
#define EXTI_RPR1_RPIF6_Msk                 (0x1UL << EXTI_RPR1_RPIF6_Pos)          /*!< 0x00000040 */
#define EXTI_RPR1_RPIF6                     EXTI_RPR1_RPIF6_Msk                     /*!< Rising Pending Interrupt Flag on line 6 */
#define EXTI_RPR1_RPIF7_Pos                 (7U)
#define EXTI_RPR1_RPIF7_Msk                 (0x1UL << EXTI_RPR1_RPIF7_Pos)          /*!< 0x00000080 */
#define EXTI_RPR1_RPIF7                     EXTI_RPR1_RPIF7_Msk                     /*!< Rising Pending Interrupt Flag on line 7 */
#define EXTI_RPR1_RPIF8_Pos                 (8U)
#define EXTI_RPR1_RPIF8_Msk                 (0x1UL << EXTI_RPR1_RPIF8_Pos)          /*!< 0x00000100 */
#define EXTI_RPR1_RPIF8                     EXTI_RPR1_RPIF8_Msk                     /*!< Rising Pending Interrupt Flag on line 8 */
#define EXTI_RPR1_RPIF9_Pos                 (9U)
#define EXTI_RPR1_RPIF9_Msk                 (0x1UL << EXTI_RPR1_RPIF9_Pos)          /*!< 0x00000200 */
#define EXTI_RPR1_RPIF9                     EXTI_RPR1_RPIF9_Msk                     /*!< Rising Pending Interrupt Flag on line 9 */
#define EXTI_RPR1_RPIF10_Pos                (10U)
#define EXTI_RPR1_RPIF10_Msk                (0x1UL << EXTI_RPR1_RPIF10_Pos)         /*!< 0x00000400 */
#define EXTI_RPR1_RPIF10                    EXTI_RPR1_RPIF10_Msk                    /*!< Rising Pending Interrupt Flag on line 10 */
#define EXTI_RPR1_RPIF11_Pos                (11U)
#define EXTI_RPR1_RPIF11_Msk                (0x1UL << EXTI_RPR1_RPIF11_Pos)         /*!< 0x00000800 */
#define EXTI_RPR1_RPIF11                    EXTI_RPR1_RPIF11_Msk                    /*!< Rising Pending Interrupt Flag on line 11 */
#define EXTI_RPR1_RPIF12_Pos                (12U)
#define EXTI_RPR1_RPIF12_Msk                (0x1UL << EXTI_RPR1_RPIF12_Pos)         /*!< 0x00001000 */
#define EXTI_RPR1_RPIF12                    EXTI_RPR1_RPIF12_Msk                    /*!< Rising Pending Interrupt Flag on line 12 */
#define EXTI_RPR1_RPIF13_Pos                (13U)
#define EXTI_RPR1_RPIF13_Msk                (0x1UL << EXTI_RPR1_RPIF13_Pos)         /*!< 0x00002000 */
#define EXTI_RPR1_RPIF13                    EXTI_RPR1_RPIF13_Msk                    /*!< Rising Pending Interrupt Flag on line 13 */
#define EXTI_RPR1_RPIF14_Pos                (14U)
#define EXTI_RPR1_RPIF14_Msk                (0x1UL << EXTI_RPR1_RPIF14_Pos)         /*!< 0x00004000 */
#define EXTI_RPR1_RPIF14                    EXTI_RPR1_RPIF14_Msk                    /*!< Rising Pending Interrupt Flag on line 14 */
#define EXTI_RPR1_RPIF15_Pos                (15U)
#define EXTI_RPR1_RPIF15_Msk                (0x1UL << EXTI_RPR1_RPIF15_Pos)         /*!< 0x00008000 */
#define EXTI_RPR1_RPIF15                    EXTI_RPR1_RPIF15_Msk                    /*!< Rising Pending Interrupt Flag on line 15 */
#define EXTI_RPR1_RPIF16_Pos                (16U)
#define EXTI_RPR1_RPIF16_Msk                (0x1UL << EXTI_RPR1_RPIF16_Pos)         /*!< 0x00010000 */
#define EXTI_RPR1_RPIF16                    EXTI_RPR1_RPIF16_Msk                    /*!< Rising Pending Interrupt Flag on line 16 */
#define EXTI_RPR1_RPIF17_Pos                (17U)
#define EXTI_RPR1_RPIF17_Msk                (0x1UL << EXTI_RPR1_RPIF17_Pos)         /*!< 0x00020000 */
#define EXTI_RPR1_RPIF17                    EXTI_RPR1_RPIF17_Msk                    /*!< Rising Pending Interrupt Flag on line 17 */
#define EXTI_RPR1_RPIF18_Pos                (18U)
#define EXTI_RPR1_RPIF18_Msk                (0x1UL << EXTI_RPR1_RPIF18_Pos)         /*!< 0x00040000 */
#define EXTI_RPR1_RPIF18                    EXTI_RPR1_RPIF18_Msk                    /*!< Rising Pending Interrupt Flag on line 18 */
#define EXTI_RPR1_RPIF19_Pos                (19U)
#define EXTI_RPR1_RPIF19_Msk                (0x1UL << EXTI_RPR1_RPIF19_Pos)         /*!< 0x00080000 */
#define EXTI_RPR1_RPIF19                    EXTI_RPR1_RPIF19_Msk                    /*!< Rising Pending Interrupt Flag on line 19 */
#define EXTI_RPR1_RPIF20_Pos                (20U)
#define EXTI_RPR1_RPIF20_Msk                (0x1UL << EXTI_RPR1_RPIF20_Pos)         /*!< 0x00100000 */
#define EXTI_RPR1_RPIF20                    EXTI_RPR1_RPIF20_Msk                    /*!< Rising Pending Interrupt Flag on line 20 */
#define EXTI_RPR1_RPIF21_Pos                (21U)
#define EXTI_RPR1_RPIF21_Msk                (0x1UL << EXTI_RPR1_RPIF21_Pos)         /*!< 0x00200000 */
#define EXTI_RPR1_RPIF21                    EXTI_RPR1_RPIF21_Msk                    /*!< Rising Pending Interrupt Flag on line 21 */
#define EXTI_RPR1_RPIF22_Pos                (22U)
#define EXTI_RPR1_RPIF22_Msk                (0x1UL << EXTI_RPR1_RPIF22_Pos)         /*!< 0x00400000 */
#define EXTI_RPR1_RPIF22                    EXTI_RPR1_RPIF22_Msk                    /*!< Rising Pending Interrupt Flag on line 22 */
#define EXTI_RPR1_RPIF23_Pos                (23U)
#define EXTI_RPR1_RPIF23_Msk                (0x1UL << EXTI_RPR1_RPIF23_Pos)         /*!< 0x00800000 */
#define EXTI_RPR1_RPIF23                    EXTI_RPR1_RPIF23_Msk                    /*!< Rising Pending Interrupt Flag on line 23 */
#define EXTI_RPR1_RPIF24_Pos                (24U)
#define EXTI_RPR1_RPIF24_Msk                (0x1UL << EXTI_RPR1_RPIF24_Pos)         /*!< 0x01000000 */
#define EXTI_RPR1_RPIF24                    EXTI_RPR1_RPIF24_Msk                    /*!< Rising Pending Interrupt Flag on line 24 */
#define EXTI_RPR1_RPIF25_Pos                (25U)
#define EXTI_RPR1_RPIF25_Msk                (0x1UL << EXTI_RPR1_RPIF25_Pos)         /*!< 0x02000000 */
#define EXTI_RPR1_RPIF25                    EXTI_RPR1_RPIF25_Msk                    /*!< Rising Pending Interrupt Flag on line 25 */

/*******************  Bit definition for EXTI_FPR1 register  ******************/
#define EXTI_FPR1_FPIF0_Pos                 (0U)
#define EXTI_FPR1_FPIF0_Msk                 (0x1UL << EXTI_FPR1_FPIF0_Pos)          /*!< 0x00000001 */
#define EXTI_FPR1_FPIF0                     EXTI_FPR1_FPIF0_Msk                     /*!< Falling Pending Interrupt Flag on line 0 */
#define EXTI_FPR1_FPIF1_Pos                 (1U)
#define EXTI_FPR1_FPIF1_Msk                 (0x1UL << EXTI_FPR1_FPIF1_Pos)          /*!< 0x00000002 */
#define EXTI_FPR1_FPIF1                     EXTI_FPR1_FPIF1_Msk                     /*!< Falling Pending Interrupt Flag on line 1 */
#define EXTI_FPR1_FPIF2_Pos                 (2U)
#define EXTI_FPR1_FPIF2_Msk                 (0x1UL << EXTI_FPR1_FPIF2_Pos)          /*!< 0x00000004 */
#define EXTI_FPR1_FPIF2                     EXTI_FPR1_FPIF2_Msk                     /*!< Falling Pending Interrupt Flag on line 2 */
#define EXTI_FPR1_FPIF3_Pos                 (3U)
#define EXTI_FPR1_FPIF3_Msk                 (0x1UL << EXTI_FPR1_FPIF3_Pos)          /*!< 0x00000008 */
#define EXTI_FPR1_FPIF3                     EXTI_FPR1_FPIF3_Msk                     /*!< Falling Pending Interrupt Flag on line 3 */
#define EXTI_FPR1_FPIF4_Pos                 (4U)
#define EXTI_FPR1_FPIF4_Msk                 (0x1UL << EXTI_FPR1_FPIF4_Pos)          /*!< 0x00000010 */
#define EXTI_FPR1_FPIF4                     EXTI_FPR1_FPIF4_Msk                     /*!< Falling Pending Interrupt Flag on line 4 */
#define EXTI_FPR1_FPIF5_Pos                 (5U)
#define EXTI_FPR1_FPIF5_Msk                 (0x1UL << EXTI_FPR1_FPIF5_Pos)          /*!< 0x00000020 */
#define EXTI_FPR1_FPIF5                     EXTI_FPR1_FPIF5_Msk                     /*!< Falling Pending Interrupt Flag on line 5 */
#define EXTI_FPR1_FPIF6_Pos                 (6U)
#define EXTI_FPR1_FPIF6_Msk                 (0x1UL << EXTI_FPR1_FPIF6_Pos)          /*!< 0x00000040 */
#define EXTI_FPR1_FPIF6                     EXTI_FPR1_FPIF6_Msk                     /*!< Falling Pending Interrupt Flag on line 6 */
#define EXTI_FPR1_FPIF7_Pos                 (7U)
#define EXTI_FPR1_FPIF7_Msk                 (0x1UL << EXTI_FPR1_FPIF7_Pos)          /*!< 0x00000080 */
#define EXTI_FPR1_FPIF7                     EXTI_FPR1_FPIF7_Msk                     /*!< Falling Pending Interrupt Flag on line 7 */
#define EXTI_FPR1_FPIF8_Pos                 (8U)
#define EXTI_FPR1_FPIF8_Msk                 (0x1UL << EXTI_FPR1_FPIF8_Pos)          /*!< 0x00000100 */
#define EXTI_FPR1_FPIF8                     EXTI_FPR1_FPIF8_Msk                     /*!< Falling Pending Interrupt Flag on line 8 */
#define EXTI_FPR1_FPIF9_Pos                 (9U)
#define EXTI_FPR1_FPIF9_Msk                 (0x1UL << EXTI_FPR1_FPIF9_Pos)          /*!< 0x00000200 */
#define EXTI_FPR1_FPIF9                     EXTI_FPR1_FPIF9_Msk                     /*!< Falling Pending Interrupt Flag on line 9 */
#define EXTI_FPR1_FPIF10_Pos                (10U)
#define EXTI_FPR1_FPIF10_Msk                (0x1UL << EXTI_FPR1_FPIF10_Pos)         /*!< 0x00000400 */
#define EXTI_FPR1_FPIF10                    EXTI_FPR1_FPIF10_Msk                    /*!< Falling Pending Interrupt Flag on line 10 */
#define EXTI_FPR1_FPIF11_Pos                (11U)
#define EXTI_FPR1_FPIF11_Msk                (0x1UL << EXTI_FPR1_FPIF11_Pos)         /*!< 0x00000800 */
#define EXTI_FPR1_FPIF11                    EXTI_FPR1_FPIF11_Msk                    /*!< Falling Pending Interrupt Flag on line 11 */
#define EXTI_FPR1_FPIF12_Pos                (12U)
#define EXTI_FPR1_FPIF12_Msk                (0x1UL << EXTI_FPR1_FPIF12_Pos)         /*!< 0x00001000 */
#define EXTI_FPR1_FPIF12                    EXTI_FPR1_FPIF12_Msk                    /*!< Falling Pending Interrupt Flag on line 12 */
#define EXTI_FPR1_FPIF13_Pos                (13U)
#define EXTI_FPR1_FPIF13_Msk                (0x1UL << EXTI_FPR1_FPIF13_Pos)         /*!< 0x00002000 */
#define EXTI_FPR1_FPIF13                    EXTI_FPR1_FPIF13_Msk                    /*!< Falling Pending Interrupt Flag on line 13 */
#define EXTI_FPR1_FPIF14_Pos                (14U)
#define EXTI_FPR1_FPIF14_Msk                (0x1UL << EXTI_FPR1_FPIF14_Pos)         /*!< 0x00004000 */
#define EXTI_FPR1_FPIF14                    EXTI_FPR1_FPIF14_Msk                    /*!< Falling Pending Interrupt Flag on line 14 */
#define EXTI_FPR1_FPIF15_Pos                (15U)
#define EXTI_FPR1_FPIF15_Msk                (0x1UL << EXTI_FPR1_FPIF15_Pos)         /*!< 0x00008000 */
#define EXTI_FPR1_FPIF15                    EXTI_FPR1_FPIF15_Msk                    /*!< Falling Pending Interrupt Flag on line 15 */
#define EXTI_FPR1_FPIF16_Pos                (16U)
#define EXTI_FPR1_FPIF16_Msk                (0x1UL << EXTI_FPR1_FPIF16_Pos)         /*!< 0x00010000 */
#define EXTI_FPR1_FPIF16                    EXTI_FPR1_FPIF16_Msk                    /*!< Falling Pending Interrupt Flag on line 16 */
#define EXTI_FPR1_FPIF17_Pos                (17U)
#define EXTI_FPR1_FPIF17_Msk                (0x1UL << EXTI_FPR1_FPIF17_Pos)         /*!< 0x00020000 */
#define EXTI_FPR1_FPIF17                    EXTI_FPR1_FPIF17_Msk                    /*!< Falling Pending Interrupt Flag on line 17 */
#define EXTI_FPR1_FPIF18_Pos                (18U)
#define EXTI_FPR1_FPIF18_Msk                (0x1UL << EXTI_FPR1_FPIF18_Pos)         /*!< 0x00040000 */
#define EXTI_FPR1_FPIF18                    EXTI_FPR1_FPIF18_Msk                    /*!< Falling Pending Interrupt Flag on line 18 */
#define EXTI_FPR1_FPIF19_Pos                (19U)
#define EXTI_FPR1_FPIF19_Msk                (0x1UL << EXTI_FPR1_FPIF19_Pos)         /*!< 0x00080000 */
#define EXTI_FPR1_FPIF19                    EXTI_FPR1_FPIF19_Msk                    /*!< Falling Pending Interrupt Flag on line 19 */
#define EXTI_FPR1_FPIF20_Pos                (20U)
#define EXTI_FPR1_FPIF20_Msk                (0x1UL << EXTI_FPR1_FPIF20_Pos)         /*!< 0x00100000 */
#define EXTI_FPR1_FPIF20                    EXTI_FPR1_FPIF20_Msk                    /*!< Falling Pending Interrupt Flag on line 20 */
#define EXTI_FPR1_FPIF21_Pos                (21U)
#define EXTI_FPR1_FPIF21_Msk                (0x1UL << EXTI_FPR1_FPIF21_Pos)         /*!< 0x00200000 */
#define EXTI_FPR1_FPIF21                    EXTI_FPR1_FPIF21_Msk                    /*!< Falling Pending Interrupt Flag on line 21 */
#define EXTI_FPR1_FPIF22_Pos                (22U)
#define EXTI_FPR1_FPIF22_Msk                (0x1UL << EXTI_FPR1_FPIF22_Pos)         /*!< 0x00400000 */
#define EXTI_FPR1_FPIF22                    EXTI_FPR1_FPIF22_Msk                    /*!< Falling Pending Interrupt Flag on line 22 */
#define EXTI_FPR1_FPIF23_Pos                (23U)
#define EXTI_FPR1_FPIF23_Msk                (0x1UL << EXTI_FPR1_FPIF23_Pos)         /*!< 0x00800000 */
#define EXTI_FPR1_FPIF23                    EXTI_FPR1_FPIF23_Msk                    /*!< Falling Pending Interrupt Flag on line 23 */
#define EXTI_FPR1_FPIF24_Pos                (24U)
#define EXTI_FPR1_FPIF24_Msk                (0x1UL << EXTI_FPR1_FPIF24_Pos)         /*!< 0x01000000 */
#define EXTI_FPR1_FPIF24                    EXTI_FPR1_FPIF24_Msk                    /*!< Falling Pending Interrupt Flag on line 24 */
#define EXTI_FPR1_FPIF25_Pos                (25U)
#define EXTI_FPR1_FPIF25_Msk                (0x1UL << EXTI_FPR1_FPIF25_Pos)         /*!< 0x02000000 */
#define EXTI_FPR1_FPIF25                    EXTI_FPR1_FPIF25_Msk                    /*!< Falling Pending Interrupt Flag on line 25 */

/*******************  Bit definition for EXTI_SECCFGR1 register  ******************/
#define EXTI_SECCFGR1_SEC0_Pos              (0U)
#define EXTI_SECCFGR1_SEC0_Msk              (0x1UL << EXTI_SECCFGR1_SEC0_Pos)       /*!< 0x00000001 */
#define EXTI_SECCFGR1_SEC0                  EXTI_SECCFGR1_SEC0_Msk                  /*!< Security enable on line 0 */
#define EXTI_SECCFGR1_SEC1_Pos              (1U)
#define EXTI_SECCFGR1_SEC1_Msk              (0x1UL << EXTI_SECCFGR1_SEC1_Pos)       /*!< 0x00000002 */
#define EXTI_SECCFGR1_SEC1                  EXTI_SECCFGR1_SEC1_Msk                  /*!< Security enable on line 1 */
#define EXTI_SECCFGR1_SEC2_Pos              (2U)
#define EXTI_SECCFGR1_SEC2_Msk              (0x1UL << EXTI_SECCFGR1_SEC2_Pos)       /*!< 0x00000004 */
#define EXTI_SECCFGR1_SEC2                  EXTI_SECCFGR1_SEC2_Msk                  /*!< Security enable on line 2 */
#define EXTI_SECCFGR1_SEC3_Pos              (3U)
#define EXTI_SECCFGR1_SEC3_Msk              (0x1UL << EXTI_SECCFGR1_SEC3_Pos)       /*!< 0x00000008 */
#define EXTI_SECCFGR1_SEC3                  EXTI_SECCFGR1_SEC3_Msk                  /*!< Security enable on line 3 */
#define EXTI_SECCFGR1_SEC4_Pos              (4U)
#define EXTI_SECCFGR1_SEC4_Msk              (0x1UL << EXTI_SECCFGR1_SEC4_Pos)       /*!< 0x00000010 */
#define EXTI_SECCFGR1_SEC4                  EXTI_SECCFGR1_SEC4_Msk                  /*!< Security enable on line 4 */
#define EXTI_SECCFGR1_SEC5_Pos              (5U)
#define EXTI_SECCFGR1_SEC5_Msk              (0x1UL << EXTI_SECCFGR1_SEC5_Pos)       /*!< 0x00000020 */
#define EXTI_SECCFGR1_SEC5                  EXTI_SECCFGR1_SEC5_Msk                  /*!< Security enable on line 5 */
#define EXTI_SECCFGR1_SEC6_Pos              (6U)
#define EXTI_SECCFGR1_SEC6_Msk              (0x1UL << EXTI_SECCFGR1_SEC6_Pos)       /*!< 0x00000040 */
#define EXTI_SECCFGR1_SEC6                  EXTI_SECCFGR1_SEC6_Msk                  /*!< Security enable on line 6 */
#define EXTI_SECCFGR1_SEC7_Pos              (7U)
#define EXTI_SECCFGR1_SEC7_Msk              (0x1UL << EXTI_SECCFGR1_SEC7_Pos)       /*!< 0x00000080 */
#define EXTI_SECCFGR1_SEC7                  EXTI_SECCFGR1_SEC7_Msk                  /*!< Security enable on line 7 */
#define EXTI_SECCFGR1_SEC8_Pos              (8U)
#define EXTI_SECCFGR1_SEC8_Msk              (0x1UL << EXTI_SECCFGR1_SEC8_Pos)       /*!< 0x00000100 */
#define EXTI_SECCFGR1_SEC8                  EXTI_SECCFGR1_SEC8_Msk                  /*!< Security enable on line 8 */
#define EXTI_SECCFGR1_SEC9_Pos              (9U)
#define EXTI_SECCFGR1_SEC9_Msk              (0x1UL << EXTI_SECCFGR1_SEC9_Pos)       /*!< 0x00000200 */
#define EXTI_SECCFGR1_SEC9                  EXTI_SECCFGR1_SEC9_Msk                  /*!< Security enable on line 9 */
#define EXTI_SECCFGR1_SEC10_Pos             (10U)
#define EXTI_SECCFGR1_SEC10_Msk             (0x1UL << EXTI_SECCFGR1_SEC10_Pos)      /*!< 0x00000400 */
#define EXTI_SECCFGR1_SEC10                 EXTI_SECCFGR1_SEC10_Msk                 /*!< Security enable on line 10 */
#define EXTI_SECCFGR1_SEC11_Pos             (11U)
#define EXTI_SECCFGR1_SEC11_Msk             (0x1UL << EXTI_SECCFGR1_SEC11_Pos)      /*!< 0x00000800 */
#define EXTI_SECCFGR1_SEC11                 EXTI_SECCFGR1_SEC11_Msk                 /*!< Security enable on line 11 */
#define EXTI_SECCFGR1_SEC12_Pos             (12U)
#define EXTI_SECCFGR1_SEC12_Msk             (0x1UL << EXTI_SECCFGR1_SEC12_Pos)      /*!< 0x00001000 */
#define EXTI_SECCFGR1_SEC12                 EXTI_SECCFGR1_SEC12_Msk                 /*!< Security enable on line 12 */
#define EXTI_SECCFGR1_SEC13_Pos             (13U)
#define EXTI_SECCFGR1_SEC13_Msk             (0x1UL << EXTI_SECCFGR1_SEC13_Pos)      /*!< 0x00002000 */
#define EXTI_SECCFGR1_SEC13                 EXTI_SECCFGR1_SEC13_Msk                 /*!< Security enable on line 13 */
#define EXTI_SECCFGR1_SEC14_Pos             (14U)
#define EXTI_SECCFGR1_SEC14_Msk             (0x1UL << EXTI_SECCFGR1_SEC14_Pos)      /*!< 0x00004000 */
#define EXTI_SECCFGR1_SEC14                 EXTI_SECCFGR1_SEC14_Msk                 /*!< Security enable on line 14 */
#define EXTI_SECCFGR1_SEC15_Pos             (15U)
#define EXTI_SECCFGR1_SEC15_Msk             (0x1UL << EXTI_SECCFGR1_SEC15_Pos)      /*!< 0x00008000 */
#define EXTI_SECCFGR1_SEC15                 EXTI_SECCFGR1_SEC15_Msk                 /*!< Security enable on line 15 */
#define EXTI_SECCFGR1_SEC16_Pos             (16U)
#define EXTI_SECCFGR1_SEC16_Msk             (0x1UL << EXTI_SECCFGR1_SEC16_Pos)      /*!< 0x00010000 */
#define EXTI_SECCFGR1_SEC16                 EXTI_SECCFGR1_SEC16_Msk                 /*!< Security enable on line 16 */
#define EXTI_SECCFGR1_SEC17_Pos             (17U)
#define EXTI_SECCFGR1_SEC17_Msk             (0x1UL << EXTI_SECCFGR1_SEC17_Pos)      /*!< 0x00020000 */
#define EXTI_SECCFGR1_SEC17                 EXTI_SECCFGR1_SEC17_Msk                 /*!< Security enable on line 17 */
#define EXTI_SECCFGR1_SEC18_Pos             (18U)
#define EXTI_SECCFGR1_SEC18_Msk             (0x1UL << EXTI_SECCFGR1_SEC18_Pos)      /*!< 0x00040000 */
#define EXTI_SECCFGR1_SEC18                 EXTI_SECCFGR1_SEC18_Msk                 /*!< Security enable on line 18 */
#define EXTI_SECCFGR1_SEC19_Pos             (19U)
#define EXTI_SECCFGR1_SEC19_Msk             (0x1UL << EXTI_SECCFGR1_SEC19_Pos)      /*!< 0x00080000 */
#define EXTI_SECCFGR1_SEC19                 EXTI_SECCFGR1_SEC19_Msk                 /*!< Security enable on line 19 */
#define EXTI_SECCFGR1_SEC20_Pos             (20U)
#define EXTI_SECCFGR1_SEC20_Msk             (0x1UL << EXTI_SECCFGR1_SEC20_Pos)      /*!< 0x00100000 */
#define EXTI_SECCFGR1_SEC20                 EXTI_SECCFGR1_SEC20_Msk                 /*!< Security enable on line 20 */
#define EXTI_SECCFGR1_SEC21_Pos             (21U)
#define EXTI_SECCFGR1_SEC21_Msk             (0x1UL << EXTI_SECCFGR1_SEC21_Pos)      /*!< 0x00200000 */
#define EXTI_SECCFGR1_SEC21                 EXTI_SECCFGR1_SEC21_Msk                 /*!< Security enable on line 21 */
#define EXTI_SECCFGR1_SEC22_Pos             (22U)
#define EXTI_SECCFGR1_SEC22_Msk             (0x1UL << EXTI_SECCFGR1_SEC22_Pos)      /*!< 0x00400000 */
#define EXTI_SECCFGR1_SEC22                 EXTI_SECCFGR1_SEC22_Msk                 /*!< Security enable on line 22 */
#define EXTI_SECCFGR1_SEC23_Pos             (23U)
#define EXTI_SECCFGR1_SEC23_Msk             (0x1UL << EXTI_SECCFGR1_SEC23_Pos)      /*!< 0x00800000 */
#define EXTI_SECCFGR1_SEC23                 EXTI_SECCFGR1_SEC23_Msk                 /*!< Security enable on line 23 */
#define EXTI_SECCFGR1_SEC24_Pos             (24U)
#define EXTI_SECCFGR1_SEC24_Msk             (0x1UL << EXTI_SECCFGR1_SEC24_Pos)      /*!< 0x01000000 */
#define EXTI_SECCFGR1_SEC24                 EXTI_SECCFGR1_SEC24_Msk                 /*!< Security enable on line 24 */
#define EXTI_SECCFGR1_SEC25_Pos             (25U)
#define EXTI_SECCFGR1_SEC25_Msk             (0x1UL << EXTI_SECCFGR1_SEC25_Pos)      /*!< 0x02000000 */
#define EXTI_SECCFGR1_SEC25                 EXTI_SECCFGR1_SEC25_Msk                 /*!< Security enable on line 25 */

/*******************  Bit definition for EXTI_PRIVCFGR1 register  ******************/
#define EXTI_PRIVCFGR1_PRIV0_Pos             (0U)
#define EXTI_PRIVCFGR1_PRIV0_Msk             (0x1UL << EXTI_PRIVCFGR1_PRIV0_Pos)      /*!< 0x00000001 */
#define EXTI_PRIVCFGR1_PRIV0                 EXTI_PRIVCFGR1_PRIV0_Msk                 /*!< Privilege enable on line 0 */
#define EXTI_PRIVCFGR1_PRIV1_Pos             (1U)
#define EXTI_PRIVCFGR1_PRIV1_Msk             (0x1UL << EXTI_PRIVCFGR1_PRIV1_Pos)      /*!< 0x00000002 */
#define EXTI_PRIVCFGR1_PRIV1                 EXTI_PRIVCFGR1_PRIV1_Msk                 /*!< Privilege enable on line 1 */
#define EXTI_PRIVCFGR1_PRIV2_Pos             (2U)
#define EXTI_PRIVCFGR1_PRIV2_Msk             (0x1UL << EXTI_PRIVCFGR1_PRIV2_Pos)      /*!< 0x00000004 */
#define EXTI_PRIVCFGR1_PRIV2                 EXTI_PRIVCFGR1_PRIV2_Msk                 /*!< Privilege enable on line 2 */
#define EXTI_PRIVCFGR1_PRIV3_Pos             (3U)
#define EXTI_PRIVCFGR1_PRIV3_Msk             (0x1UL << EXTI_PRIVCFGR1_PRIV3_Pos)      /*!< 0x00000008 */
#define EXTI_PRIVCFGR1_PRIV3                 EXTI_PRIVCFGR1_PRIV3_Msk                 /*!< Privilege enable on line 3 */
#define EXTI_PRIVCFGR1_PRIV4_Pos             (4U)
#define EXTI_PRIVCFGR1_PRIV4_Msk             (0x1UL << EXTI_PRIVCFGR1_PRIV4_Pos)      /*!< 0x00000010 */
#define EXTI_PRIVCFGR1_PRIV4                 EXTI_PRIVCFGR1_PRIV4_Msk                 /*!< Privilege enable on line 4 */
#define EXTI_PRIVCFGR1_PRIV5_Pos             (5U)
#define EXTI_PRIVCFGR1_PRIV5_Msk             (0x1UL << EXTI_PRIVCFGR1_PRIV5_Pos)      /*!< 0x00000020 */
#define EXTI_PRIVCFGR1_PRIV5                 EXTI_PRIVCFGR1_PRIV5_Msk                 /*!< Privilege enable on line 5 */
#define EXTI_PRIVCFGR1_PRIV6_Pos             (6U)
#define EXTI_PRIVCFGR1_PRIV6_Msk             (0x1UL << EXTI_PRIVCFGR1_PRIV6_Pos)      /*!< 0x00000040 */
#define EXTI_PRIVCFGR1_PRIV6                 EXTI_PRIVCFGR1_PRIV6_Msk                 /*!< Privilege enable on line 6 */
#define EXTI_PRIVCFGR1_PRIV7_Pos             (7U)
#define EXTI_PRIVCFGR1_PRIV7_Msk             (0x1UL << EXTI_PRIVCFGR1_PRIV7_Pos)      /*!< 0x00000080 */
#define EXTI_PRIVCFGR1_PRIV7                 EXTI_PRIVCFGR1_PRIV7_Msk                 /*!< Privilege enable on line 7 */
#define EXTI_PRIVCFGR1_PRIV8_Pos             (8U)
#define EXTI_PRIVCFGR1_PRIV8_Msk             (0x1UL << EXTI_PRIVCFGR1_PRIV8_Pos)      /*!< 0x00000100 */
#define EXTI_PRIVCFGR1_PRIV8                 EXTI_PRIVCFGR1_PRIV8_Msk                 /*!< Privilege enable on line 8 */
#define EXTI_PRIVCFGR1_PRIV9_Pos             (9U)
#define EXTI_PRIVCFGR1_PRIV9_Msk             (0x1UL << EXTI_PRIVCFGR1_PRIV9_Pos)      /*!< 0x00000200 */
#define EXTI_PRIVCFGR1_PRIV9                 EXTI_PRIVCFGR1_PRIV9_Msk                 /*!< Privilege enable on line 9 */
#define EXTI_PRIVCFGR1_PRIV10_Pos            (10U)
#define EXTI_PRIVCFGR1_PRIV10_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV10_Pos)     /*!< 0x00000400 */
#define EXTI_PRIVCFGR1_PRIV10                EXTI_PRIVCFGR1_PRIV10_Msk                /*!< Privilege enable on line 10 */
#define EXTI_PRIVCFGR1_PRIV11_Pos            (11U)
#define EXTI_PRIVCFGR1_PRIV11_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV11_Pos)     /*!< 0x00000800 */
#define EXTI_PRIVCFGR1_PRIV11                EXTI_PRIVCFGR1_PRIV11_Msk                /*!< Privilege enable on line 11 */
#define EXTI_PRIVCFGR1_PRIV12_Pos            (12U)
#define EXTI_PRIVCFGR1_PRIV12_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV12_Pos)     /*!< 0x00001000 */
#define EXTI_PRIVCFGR1_PRIV12                EXTI_PRIVCFGR1_PRIV12_Msk                /*!< Privilege enable on line 12 */
#define EXTI_PRIVCFGR1_PRIV13_Pos            (13U)
#define EXTI_PRIVCFGR1_PRIV13_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV13_Pos)     /*!< 0x00002000 */
#define EXTI_PRIVCFGR1_PRIV13                EXTI_PRIVCFGR1_PRIV13_Msk                /*!< Privilege enable on line 13 */
#define EXTI_PRIVCFGR1_PRIV14_Pos            (14U)
#define EXTI_PRIVCFGR1_PRIV14_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV14_Pos)     /*!< 0x00004000 */
#define EXTI_PRIVCFGR1_PRIV14                EXTI_PRIVCFGR1_PRIV14_Msk                /*!< Privilege enable on line 14 */
#define EXTI_PRIVCFGR1_PRIV15_Pos            (15U)
#define EXTI_PRIVCFGR1_PRIV15_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV15_Pos)     /*!< 0x00008000 */
#define EXTI_PRIVCFGR1_PRIV15                EXTI_PRIVCFGR1_PRIV15_Msk                /*!< Privilege enable on line 15 */
#define EXTI_PRIVCFGR1_PRIV16_Pos            (16U)
#define EXTI_PRIVCFGR1_PRIV16_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV16_Pos)     /*!< 0x00010000 */
#define EXTI_PRIVCFGR1_PRIV16                EXTI_PRIVCFGR1_PRIV16_Msk                /*!< Privilege enable on line 16 */
#define EXTI_PRIVCFGR1_PRIV17_Pos            (17U)
#define EXTI_PRIVCFGR1_PRIV17_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV17_Pos)     /*!< 0x00020000 */
#define EXTI_PRIVCFGR1_PRIV17                EXTI_PRIVCFGR1_PRIV17_Msk                /*!< Privilege enable on line 17 */
#define EXTI_PRIVCFGR1_PRIV18_Pos            (18U)
#define EXTI_PRIVCFGR1_PRIV18_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV18_Pos)     /*!< 0x00040000 */
#define EXTI_PRIVCFGR1_PRIV18                EXTI_PRIVCFGR1_PRIV18_Msk                /*!< Privilege enable on line 18 */
#define EXTI_PRIVCFGR1_PRIV19_Pos            (19U)
#define EXTI_PRIVCFGR1_PRIV19_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV19_Pos)     /*!< 0x00080000 */
#define EXTI_PRIVCFGR1_PRIV19                EXTI_PRIVCFGR1_PRIV19_Msk                /*!< Privilege enable on line 19 */
#define EXTI_PRIVCFGR1_PRIV20_Pos            (20U)
#define EXTI_PRIVCFGR1_PRIV20_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV20_Pos)     /*!< 0x00100000 */
#define EXTI_PRIVCFGR1_PRIV20                EXTI_PRIVCFGR1_PRIV20_Msk                /*!< Privilege enable on line 20 */
#define EXTI_PRIVCFGR1_PRIV21_Pos            (21U)
#define EXTI_PRIVCFGR1_PRIV21_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV21_Pos)     /*!< 0x00200000 */
#define EXTI_PRIVCFGR1_PRIV21                EXTI_PRIVCFGR1_PRIV21_Msk                /*!< Privilege enable on line 21 */
#define EXTI_PRIVCFGR1_PRIV22_Pos            (22U)
#define EXTI_PRIVCFGR1_PRIV22_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV22_Pos)     /*!< 0x00400000 */
#define EXTI_PRIVCFGR1_PRIV22                EXTI_PRIVCFGR1_PRIV22_Msk                /*!< Privilege enable on line 22 */
#define EXTI_PRIVCFGR1_PRIV23_Pos            (23U)
#define EXTI_PRIVCFGR1_PRIV23_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV23_Pos)     /*!< 0x00800000 */
#define EXTI_PRIVCFGR1_PRIV23                EXTI_PRIVCFGR1_PRIV23_Msk                /*!< Privilege enable on line 23 */
#define EXTI_PRIVCFGR1_PRIV24_Pos            (24U)
#define EXTI_PRIVCFGR1_PRIV24_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV24_Pos)     /*!< 0x01000000 */
#define EXTI_PRIVCFGR1_PRIV24                EXTI_PRIVCFGR1_PRIV24_Msk                /*!< Privilege enable on line 24 */
#define EXTI_PRIVCFGR1_PRIV25_Pos            (25U)
#define EXTI_PRIVCFGR1_PRIV25_Msk            (0x1UL << EXTI_PRIVCFGR1_PRIV25_Pos)     /*!< 0x02000000 */
#define EXTI_PRIVCFGR1_PRIV25                EXTI_PRIVCFGR1_PRIV25_Msk                /*!< Privilege enable on line 25 */

/*****************  Bit definition for EXTI_EXTICR1 register  **************/
#define EXTI_EXTICR1_EXTI0_Pos              (0U)
#define EXTI_EXTICR1_EXTI0_Msk              (0xFUL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000007 */
#define EXTI_EXTICR1_EXTI0                  EXTI_EXTICR1_EXTI0_Msk                  /*!< EXTI 0 configuration */
#define EXTI_EXTICR1_EXTI0_0                (0x1UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR1_EXTI0_1                (0x2UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR1_EXTI0_2                (0x4UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR1_EXTI0_3                (0x8UL << EXTI_EXTICR1_EXTI0_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR1_EXTI1_Pos              (8U)
#define EXTI_EXTICR1_EXTI1_Msk              (0xFUL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000700 */
#define EXTI_EXTICR1_EXTI1                  EXTI_EXTICR1_EXTI1_Msk                  /*!< EXTI 1 configuration */
#define EXTI_EXTICR1_EXTI1_0                (0x1UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR1_EXTI1_1                (0x2UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR1_EXTI1_2                (0x4UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR1_EXTI1_3                (0x8UL << EXTI_EXTICR1_EXTI1_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR1_EXTI2_Pos              (16U)
#define EXTI_EXTICR1_EXTI2_Msk              (0xFUL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00070000 */
#define EXTI_EXTICR1_EXTI2                  EXTI_EXTICR1_EXTI2_Msk                  /*!< EXTI 2 configuration */
#define EXTI_EXTICR1_EXTI2_0                (0x1UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00010000 */
#define EXTI_EXTICR1_EXTI2_1                (0x2UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00020000 */
#define EXTI_EXTICR1_EXTI2_2                (0x4UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00040000 */
#define EXTI_EXTICR1_EXTI2_3                (0x8UL << EXTI_EXTICR1_EXTI2_Pos)       /*!< 0x00080000 */
#define EXTI_EXTICR1_EXTI3_Pos              (24U)
#define EXTI_EXTICR1_EXTI3_Msk              (0xFUL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x07000000 */
#define EXTI_EXTICR1_EXTI3                  EXTI_EXTICR1_EXTI3_Msk                  /*!< EXTI 3 configuration */
#define EXTI_EXTICR1_EXTI3_0                (0x1UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x01000000 */
#define EXTI_EXTICR1_EXTI3_1                (0x2UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x02000000 */
#define EXTI_EXTICR1_EXTI3_2                (0x4UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x04000000 */
#define EXTI_EXTICR1_EXTI3_3                (0x8UL << EXTI_EXTICR1_EXTI3_Pos)       /*!< 0x08000000 */

/*****************  Bit definition for EXTI_EXTICR2 register  **************/
#define EXTI_EXTICR2_EXTI4_Pos              (0U)
#define EXTI_EXTICR2_EXTI4_Msk              (0xFUL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000007 */
#define EXTI_EXTICR2_EXTI4                  EXTI_EXTICR2_EXTI4_Msk                  /*!< EXTI 4 configuration */
#define EXTI_EXTICR2_EXTI4_0                (0x1UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR2_EXTI4_1                (0x2UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR2_EXTI4_2                (0x4UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR2_EXTI4_3                (0x8UL << EXTI_EXTICR2_EXTI4_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR2_EXTI5_Pos              (8U)
#define EXTI_EXTICR2_EXTI5_Msk              (0xFUL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000700 */
#define EXTI_EXTICR2_EXTI5                  EXTI_EXTICR2_EXTI5_Msk                  /*!< EXTI 5 configuration */
#define EXTI_EXTICR2_EXTI5_0                (0x1UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR2_EXTI5_1                (0x2UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR2_EXTI5_2                (0x4UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR2_EXTI5_3                (0x8UL << EXTI_EXTICR2_EXTI5_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR2_EXTI6_Pos              (16U)
#define EXTI_EXTICR2_EXTI6_Msk              (0xFUL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00070000 */
#define EXTI_EXTICR2_EXTI6                  EXTI_EXTICR2_EXTI6_Msk                  /*!< EXTI 6 configuration */
#define EXTI_EXTICR2_EXTI6_0                (0x1UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00010000 */
#define EXTI_EXTICR2_EXTI6_1                (0x2UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00020000 */
#define EXTI_EXTICR2_EXTI6_2                (0x4UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00040000 */
#define EXTI_EXTICR2_EXTI6_3                (0x8UL << EXTI_EXTICR2_EXTI6_Pos)       /*!< 0x00080000 */
#define EXTI_EXTICR2_EXTI7_Pos              (24U)
#define EXTI_EXTICR2_EXTI7_Msk              (0xFUL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x07000000 */
#define EXTI_EXTICR2_EXTI7                  EXTI_EXTICR2_EXTI7_Msk                  /*!< EXTI 7 configuration */
#define EXTI_EXTICR2_EXTI7_0                (0x1UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x01000000 */
#define EXTI_EXTICR2_EXTI7_1                (0x2UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x02000000 */
#define EXTI_EXTICR2_EXTI7_2                (0x4UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x04000000 */
#define EXTI_EXTICR2_EXTI7_3                (0x8UL << EXTI_EXTICR2_EXTI7_Pos)       /*!< 0x08000000 */

/*****************  Bit definition for EXTI_EXTICR3 register  **************/
#define EXTI_EXTICR3_EXTI8_Pos              (0U)
#define EXTI_EXTICR3_EXTI8_Msk              (0xFUL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000007 */
#define EXTI_EXTICR3_EXTI8                  EXTI_EXTICR3_EXTI8_Msk                  /*!< EXTI 8 configuration */
#define EXTI_EXTICR3_EXTI8_0                (0x1UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000001 */
#define EXTI_EXTICR3_EXTI8_1                (0x2UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000002 */
#define EXTI_EXTICR3_EXTI8_2                (0x4UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000004 */
#define EXTI_EXTICR3_EXTI8_3                (0x8UL << EXTI_EXTICR3_EXTI8_Pos)       /*!< 0x00000008 */
#define EXTI_EXTICR3_EXTI9_Pos              (8U)
#define EXTI_EXTICR3_EXTI9_Msk              (0xFUL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000700 */
#define EXTI_EXTICR3_EXTI9                  EXTI_EXTICR3_EXTI9_Msk                  /*!< EXTI 9 configuration */
#define EXTI_EXTICR3_EXTI9_0                (0x1UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000100 */
#define EXTI_EXTICR3_EXTI9_1                (0x2UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000200 */
#define EXTI_EXTICR3_EXTI9_2                (0x4UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000400 */
#define EXTI_EXTICR3_EXTI9_3                (0x8UL << EXTI_EXTICR3_EXTI9_Pos)       /*!< 0x00000800 */
#define EXTI_EXTICR3_EXTI10_Pos             (16U)
#define EXTI_EXTICR3_EXTI10_Msk             (0xFUL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00070000 */
#define EXTI_EXTICR3_EXTI10                 EXTI_EXTICR3_EXTI10_Msk                 /*!< EXTI 10 configuration */
#define EXTI_EXTICR3_EXTI10_0               (0x1UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00010000 */
#define EXTI_EXTICR3_EXTI10_1               (0x2UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00020000 */
#define EXTI_EXTICR3_EXTI10_2               (0x4UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00040000 */
#define EXTI_EXTICR3_EXTI10_3               (0x8UL << EXTI_EXTICR3_EXTI10_Pos)      /*!< 0x00080000 */
#define EXTI_EXTICR3_EXTI11_Pos             (24U)
#define EXTI_EXTICR3_EXTI11_Msk             (0xFUL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x07000000 */
#define EXTI_EXTICR3_EXTI11                 EXTI_EXTICR3_EXTI11_Msk                 /*!< EXTI 11 configuration */
#define EXTI_EXTICR3_EXTI11_0               (0x1UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x01000000 */
#define EXTI_EXTICR3_EXTI11_1               (0x2UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x02000000 */
#define EXTI_EXTICR3_EXTI11_2               (0x4UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x04000000 */
#define EXTI_EXTICR3_EXTI11_3               (0x8UL << EXTI_EXTICR3_EXTI11_Pos)      /*!< 0x08000000 */

/*****************  Bit definition for EXTI_EXTICR4 register  **************/
#define EXTI_EXTICR4_EXTI12_Pos             (0U)
#define EXTI_EXTICR4_EXTI12_Msk             (0xFUL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000007 */
#define EXTI_EXTICR4_EXTI12                 EXTI_EXTICR4_EXTI12_Msk                 /*!< EXTI 12 configuration */
#define EXTI_EXTICR4_EXTI12_0               (0x1UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000001 */
#define EXTI_EXTICR4_EXTI12_1               (0x2UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000002 */
#define EXTI_EXTICR4_EXTI12_2               (0x4UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000004 */
#define EXTI_EXTICR4_EXTI12_3               (0x8UL << EXTI_EXTICR4_EXTI12_Pos)      /*!< 0x00000008 */
#define EXTI_EXTICR4_EXTI13_Pos             (8U)
#define EXTI_EXTICR4_EXTI13_Msk             (0xFUL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000700 */
#define EXTI_EXTICR4_EXTI13                 EXTI_EXTICR4_EXTI13_Msk                 /*!< EXTI 13 configuration */
#define EXTI_EXTICR4_EXTI13_0               (0x1UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000100 */
#define EXTI_EXTICR4_EXTI13_1               (0x2UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000200 */
#define EXTI_EXTICR4_EXTI13_2               (0x4UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000400 */
#define EXTI_EXTICR4_EXTI13_3               (0x8UL << EXTI_EXTICR4_EXTI13_Pos)      /*!< 0x00000800 */
#define EXTI_EXTICR4_EXTI14_Pos             (16U)
#define EXTI_EXTICR4_EXTI14_Msk             (0xFUL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00070000 */
#define EXTI_EXTICR4_EXTI14                 EXTI_EXTICR4_EXTI14_Msk                 /*!< EXTI 14 configuration */
#define EXTI_EXTICR4_EXTI14_0               (0x1UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00010000 */
#define EXTI_EXTICR4_EXTI14_1               (0x2UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00020000 */
#define EXTI_EXTICR4_EXTI14_2               (0x4UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00040000 */
#define EXTI_EXTICR4_EXTI14_3               (0x8UL << EXTI_EXTICR4_EXTI14_Pos)      /*!< 0x00080000 */
#define EXTI_EXTICR4_EXTI15_Pos             (24U)
#define EXTI_EXTICR4_EXTI15_Msk             (0xFUL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x07000000 */
#define EXTI_EXTICR4_EXTI15                 EXTI_EXTICR4_EXTI15_Msk                 /*!< EXTI 15 configuration */
#define EXTI_EXTICR4_EXTI15_0               (0x1UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x01000000 */
#define EXTI_EXTICR4_EXTI15_1               (0x2UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x02000000 */
#define EXTI_EXTICR4_EXTI15_2               (0x4UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x04000000 */
#define EXTI_EXTICR4_EXTI15_3               (0x8UL << EXTI_EXTICR4_EXTI15_Pos)      /*!< 0x08000000 */

/*****************  Bit definition for EXTI_LOCKR register  **************/
#define EXTI_LOCKR_LOCK_Pos                 (0U)
#define EXTI_LOCKR_LOCK_Msk                 (0x1UL << EXTI_LOCKR_LOCK_Pos)          /*!< 0x00000001 */
#define EXTI_LOCKR_LOCK                     EXTI_LOCKR_LOCK_Msk                     /*!< Global security and privilege configuration registers lock */

/*******************  Bit definition for EXTI_IMR1 register  ******************/
#define EXTI_IMR1_IM0_Pos                   (0U)
#define EXTI_IMR1_IM0_Msk                   (0x1UL << EXTI_IMR1_IM0_Pos)            /*!< 0x00000001 */
#define EXTI_IMR1_IM0                       EXTI_IMR1_IM0_Msk                       /*!< Interrupt Mask on line 0 */
#define EXTI_IMR1_IM1_Pos                   (1U)
#define EXTI_IMR1_IM1_Msk                   (0x1UL << EXTI_IMR1_IM1_Pos)            /*!< 0x00000002 */
#define EXTI_IMR1_IM1                       EXTI_IMR1_IM1_Msk                       /*!< Interrupt Mask on line 1 */
#define EXTI_IMR1_IM2_Pos                   (2U)
#define EXTI_IMR1_IM2_Msk                   (0x1UL << EXTI_IMR1_IM2_Pos)            /*!< 0x00000004 */
#define EXTI_IMR1_IM2                       EXTI_IMR1_IM2_Msk                       /*!< Interrupt Mask on line 2 */
#define EXTI_IMR1_IM3_Pos                   (3U)
#define EXTI_IMR1_IM3_Msk                   (0x1UL << EXTI_IMR1_IM3_Pos)            /*!< 0x00000008 */
#define EXTI_IMR1_IM3                       EXTI_IMR1_IM3_Msk                       /*!< Interrupt Mask on line 3 */
#define EXTI_IMR1_IM4_Pos                   (4U)
#define EXTI_IMR1_IM4_Msk                   (0x1UL << EXTI_IMR1_IM4_Pos)            /*!< 0x00000010 */
#define EXTI_IMR1_IM4                       EXTI_IMR1_IM4_Msk                       /*!< Interrupt Mask on line 4 */
#define EXTI_IMR1_IM5_Pos                   (5U)
#define EXTI_IMR1_IM5_Msk                   (0x1UL << EXTI_IMR1_IM5_Pos)            /*!< 0x00000020 */
#define EXTI_IMR1_IM5                       EXTI_IMR1_IM5_Msk                       /*!< Interrupt Mask on line 5 */
#define EXTI_IMR1_IM6_Pos                   (6U)
#define EXTI_IMR1_IM6_Msk                   (0x1UL << EXTI_IMR1_IM6_Pos)            /*!< 0x00000040 */
#define EXTI_IMR1_IM6                       EXTI_IMR1_IM6_Msk                       /*!< Interrupt Mask on line 6 */
#define EXTI_IMR1_IM7_Pos                   (7U)
#define EXTI_IMR1_IM7_Msk                   (0x1UL << EXTI_IMR1_IM7_Pos)            /*!< 0x00000080 */
#define EXTI_IMR1_IM7                       EXTI_IMR1_IM7_Msk                       /*!< Interrupt Mask on line 7 */
#define EXTI_IMR1_IM8_Pos                   (8U)
#define EXTI_IMR1_IM8_Msk                   (0x1UL << EXTI_IMR1_IM8_Pos)            /*!< 0x00000100 */
#define EXTI_IMR1_IM8                       EXTI_IMR1_IM8_Msk                       /*!< Interrupt Mask on line 8 */
#define EXTI_IMR1_IM9_Pos                   (9U)
#define EXTI_IMR1_IM9_Msk                   (0x1UL << EXTI_IMR1_IM9_Pos)            /*!< 0x00000200 */
#define EXTI_IMR1_IM9                       EXTI_IMR1_IM9_Msk                       /*!< Interrupt Mask on line 9 */
#define EXTI_IMR1_IM10_Pos                  (10U)
#define EXTI_IMR1_IM10_Msk                  (0x1UL << EXTI_IMR1_IM10_Pos)           /*!< 0x00000400 */
#define EXTI_IMR1_IM10                      EXTI_IMR1_IM10_Msk                      /*!< Interrupt Mask on line 10 */
#define EXTI_IMR1_IM11_Pos                  (11U)
#define EXTI_IMR1_IM11_Msk                  (0x1UL << EXTI_IMR1_IM11_Pos)           /*!< 0x00000800 */
#define EXTI_IMR1_IM11                      EXTI_IMR1_IM11_Msk                      /*!< Interrupt Mask on line 11 */
#define EXTI_IMR1_IM12_Pos                  (12U)
#define EXTI_IMR1_IM12_Msk                  (0x1UL << EXTI_IMR1_IM12_Pos)           /*!< 0x00001000 */
#define EXTI_IMR1_IM12                      EXTI_IMR1_IM12_Msk                      /*!< Interrupt Mask on line 12 */
#define EXTI_IMR1_IM13_Pos                  (13U)
#define EXTI_IMR1_IM13_Msk                  (0x1UL << EXTI_IMR1_IM13_Pos)           /*!< 0x00002000 */
#define EXTI_IMR1_IM13                      EXTI_IMR1_IM13_Msk                      /*!< Interrupt Mask on line 13 */
#define EXTI_IMR1_IM14_Pos                  (14U)
#define EXTI_IMR1_IM14_Msk                  (0x1UL << EXTI_IMR1_IM14_Pos)           /*!< 0x00004000 */
#define EXTI_IMR1_IM14                      EXTI_IMR1_IM14_Msk                      /*!< Interrupt Mask on line 14 */
#define EXTI_IMR1_IM15_Pos                  (15U)
#define EXTI_IMR1_IM15_Msk                  (0x1UL << EXTI_IMR1_IM15_Pos)           /*!< 0x00008000 */
#define EXTI_IMR1_IM15                      EXTI_IMR1_IM15_Msk                      /*!< Interrupt Mask on line 15 */
#define EXTI_IMR1_IM16_Pos                  (16U)
#define EXTI_IMR1_IM16_Msk                  (0x1UL << EXTI_IMR1_IM16_Pos)           /*!< 0x00010000 */
#define EXTI_IMR1_IM16                      EXTI_IMR1_IM16_Msk                      /*!< Interrupt Mask on line 16 */
#define EXTI_IMR1_IM17_Pos                  (17U)
#define EXTI_IMR1_IM17_Msk                  (0x1UL << EXTI_IMR1_IM17_Pos)           /*!< 0x00020000 */
#define EXTI_IMR1_IM17                      EXTI_IMR1_IM17_Msk                      /*!< Interrupt Mask on line 17 */
#define EXTI_IMR1_IM18_Pos                  (18U)
#define EXTI_IMR1_IM18_Msk                  (0x1UL << EXTI_IMR1_IM18_Pos)           /*!< 0x00040000 */
#define EXTI_IMR1_IM18                      EXTI_IMR1_IM18_Msk                      /*!< Interrupt Mask on line 18 */
#define EXTI_IMR1_IM19_Pos                  (19U)
#define EXTI_IMR1_IM19_Msk                  (0x1UL << EXTI_IMR1_IM19_Pos)           /*!< 0x00080000 */
#define EXTI_IMR1_IM19                      EXTI_IMR1_IM19_Msk                      /*!< Interrupt Mask on line 19 */
#define EXTI_IMR1_IM20_Pos                  (20U)
#define EXTI_IMR1_IM20_Msk                  (0x1UL << EXTI_IMR1_IM20_Pos)           /*!< 0x00100000 */
#define EXTI_IMR1_IM20                      EXTI_IMR1_IM20_Msk                      /*!< Interrupt Mask on line 20 */
#define EXTI_IMR1_IM21_Pos                  (21U)
#define EXTI_IMR1_IM21_Msk                  (0x1UL << EXTI_IMR1_IM21_Pos)           /*!< 0x00200000 */
#define EXTI_IMR1_IM21                      EXTI_IMR1_IM21_Msk                      /*!< Interrupt Mask on line 21 */
#define EXTI_IMR1_IM22_Pos                  (22U)
#define EXTI_IMR1_IM22_Msk                  (0x1UL << EXTI_IMR1_IM22_Pos)           /*!< 0x00400000 */
#define EXTI_IMR1_IM22                      EXTI_IMR1_IM22_Msk                      /*!< Interrupt Mask on line 22 */
#define EXTI_IMR1_IM23_Pos                  (23U)
#define EXTI_IMR1_IM23_Msk                  (0x1UL << EXTI_IMR1_IM23_Pos)           /*!< 0x00800000 */
#define EXTI_IMR1_IM23                      EXTI_IMR1_IM23_Msk                      /*!< Interrupt Mask on line 23 */
#define EXTI_IMR1_IM24_Pos                  (24U)
#define EXTI_IMR1_IM24_Msk                  (0x1UL << EXTI_IMR1_IM24_Pos)           /*!< 0x01000000 */
#define EXTI_IMR1_IM24                      EXTI_IMR1_IM24_Msk                      /*!< Interrupt Mask on line 24 */
#define EXTI_IMR1_IM25_Pos                  (25U)
#define EXTI_IMR1_IM25_Msk                  (0x1UL << EXTI_IMR1_IM25_Pos)           /*!< 0x02000000 */
#define EXTI_IMR1_IM25                      EXTI_IMR1_IM25_Msk                      /*!< Interrupt Mask on line 25 */

/*******************  Bit definition for EXTI_EMR1 register  ******************/
#define EXTI_EMR1_EM0_Pos                   (0U)
#define EXTI_EMR1_EM0_Msk                   (0x1UL << EXTI_EMR1_EM0_Pos)            /*!< 0x00000001 */
#define EXTI_EMR1_EM0                       EXTI_EMR1_EM0_Msk                       /*!< Event Mask on line 0 */
#define EXTI_EMR1_EM1_Pos                   (1U)
#define EXTI_EMR1_EM1_Msk                   (0x1UL << EXTI_EMR1_EM1_Pos)            /*!< 0x00000002 */
#define EXTI_EMR1_EM1                       EXTI_EMR1_EM1_Msk                       /*!< Event Mask on line 1 */
#define EXTI_EMR1_EM2_Pos                   (2U)
#define EXTI_EMR1_EM2_Msk                   (0x1UL << EXTI_EMR1_EM2_Pos)            /*!< 0x00000004 */
#define EXTI_EMR1_EM2                       EXTI_EMR1_EM2_Msk                       /*!< Event Mask on line 2 */
#define EXTI_EMR1_EM3_Pos                   (3U)
#define EXTI_EMR1_EM3_Msk                   (0x1UL << EXTI_EMR1_EM3_Pos)            /*!< 0x00000008 */
#define EXTI_EMR1_EM3                       EXTI_EMR1_EM3_Msk                       /*!< Event Mask on line 3 */
#define EXTI_EMR1_EM4_Pos                   (4U)
#define EXTI_EMR1_EM4_Msk                   (0x1UL << EXTI_EMR1_EM4_Pos)            /*!< 0x00000010 */
#define EXTI_EMR1_EM4                       EXTI_EMR1_EM4_Msk                       /*!< Event Mask on line 4 */
#define EXTI_EMR1_EM5_Pos                   (5U)
#define EXTI_EMR1_EM5_Msk                   (0x1UL << EXTI_EMR1_EM5_Pos)            /*!< 0x00000020 */
#define EXTI_EMR1_EM5                       EXTI_EMR1_EM5_Msk                       /*!< Event Mask on line 5 */
#define EXTI_EMR1_EM6_Pos                   (6U)
#define EXTI_EMR1_EM6_Msk                   (0x1UL << EXTI_EMR1_EM6_Pos)            /*!< 0x00000040 */
#define EXTI_EMR1_EM6                       EXTI_EMR1_EM6_Msk                       /*!< Event Mask on line 6 */
#define EXTI_EMR1_EM7_Pos                   (7U)
#define EXTI_EMR1_EM7_Msk                   (0x1UL << EXTI_EMR1_EM7_Pos)            /*!< 0x00000080 */
#define EXTI_EMR1_EM7                       EXTI_EMR1_EM7_Msk                       /*!< Event Mask on line 7 */
#define EXTI_EMR1_EM8_Pos                   (8U)
#define EXTI_EMR1_EM8_Msk                   (0x1UL << EXTI_EMR1_EM8_Pos)            /*!< 0x00000100 */
#define EXTI_EMR1_EM8                       EXTI_EMR1_EM8_Msk                       /*!< Event Mask on line 8 */
#define EXTI_EMR1_EM9_Pos                   (9U)
#define EXTI_EMR1_EM9_Msk                   (0x1UL << EXTI_EMR1_EM9_Pos)            /*!< 0x00000200 */
#define EXTI_EMR1_EM9                       EXTI_EMR1_EM9_Msk                       /*!< Event Mask on line 9 */
#define EXTI_EMR1_EM10_Pos                  (10U)
#define EXTI_EMR1_EM10_Msk                  (0x1UL << EXTI_EMR1_EM10_Pos)           /*!< 0x00000400 */
#define EXTI_EMR1_EM10                      EXTI_EMR1_EM10_Msk                      /*!< Event Mask on line 10 */
#define EXTI_EMR1_EM11_Pos                  (11U)
#define EXTI_EMR1_EM11_Msk                  (0x1UL << EXTI_EMR1_EM11_Pos)           /*!< 0x00000800 */
#define EXTI_EMR1_EM11                      EXTI_EMR1_EM11_Msk                      /*!< Event Mask on line 11 */
#define EXTI_EMR1_EM12_Pos                  (12U)
#define EXTI_EMR1_EM12_Msk                  (0x1UL << EXTI_EMR1_EM12_Pos)           /*!< 0x00001000 */
#define EXTI_EMR1_EM12                      EXTI_EMR1_EM12_Msk                      /*!< Event Mask on line 12 */
#define EXTI_EMR1_EM13_Pos                  (13U)
#define EXTI_EMR1_EM13_Msk                  (0x1UL << EXTI_EMR1_EM13_Pos)           /*!< 0x00002000 */
#define EXTI_EMR1_EM13                      EXTI_EMR1_EM13_Msk                      /*!< Event Mask on line 13 */
#define EXTI_EMR1_EM14_Pos                  (14U)
#define EXTI_EMR1_EM14_Msk                  (0x1UL << EXTI_EMR1_EM14_Pos)           /*!< 0x00004000 */
#define EXTI_EMR1_EM14                      EXTI_EMR1_EM14_Msk                      /*!< Event Mask on line 14 */
#define EXTI_EMR1_EM15_Pos                  (15U)
#define EXTI_EMR1_EM15_Msk                  (0x1UL << EXTI_EMR1_EM15_Pos)           /*!< 0x00008000 */
#define EXTI_EMR1_EM15                      EXTI_EMR1_EM15_Msk                      /*!< Event Mask on line 15 */
#define EXTI_EMR1_EM16_Pos                  (16U)
#define EXTI_EMR1_EM16_Msk                  (0x1UL << EXTI_EMR1_EM16_Pos)           /*!< 0x00010000 */
#define EXTI_EMR1_EM16                      EXTI_EMR1_EM16_Msk                      /*!< Event Mask on line 16 */
#define EXTI_EMR1_EM17_Pos                  (17U)
#define EXTI_EMR1_EM17_Msk                  (0x1UL << EXTI_EMR1_EM17_Pos)           /*!< 0x00020000 */
#define EXTI_EMR1_EM17                      EXTI_EMR1_EM17_Msk                      /*!< Event Mask on line 17 */
#define EXTI_EMR1_EM18_Pos                  (18U)
#define EXTI_EMR1_EM18_Msk                  (0x1UL << EXTI_EMR1_EM18_Pos)           /*!< 0x00040000 */
#define EXTI_EMR1_EM18                      EXTI_EMR1_EM18_Msk                      /*!< Event Mask on line 18 */
#define EXTI_EMR1_EM19_Pos                  (19U)
#define EXTI_EMR1_EM19_Msk                  (0x1UL << EXTI_EMR1_EM19_Pos)           /*!< 0x00080000 */
#define EXTI_EMR1_EM19                      EXTI_EMR1_EM19_Msk                      /*!< Event Mask on line 19 */
#define EXTI_EMR1_EM20_Pos                  (20U)
#define EXTI_EMR1_EM20_Msk                  (0x1UL << EXTI_EMR1_EM20_Pos)           /*!< 0x00100000 */
#define EXTI_EMR1_EM20                      EXTI_EMR1_EM20_Msk                      /*!< Event Mask on line 20 */
#define EXTI_EMR1_EM21_Pos                  (21U)
#define EXTI_EMR1_EM21_Msk                  (0x1UL << EXTI_EMR1_EM21_Pos)           /*!< 0x00200000 */
#define EXTI_EMR1_EM21                      EXTI_EMR1_EM21_Msk                      /*!< Event Mask on line 21 */
#define EXTI_EMR1_EM22_Pos                  (22U)
#define EXTI_EMR1_EM22_Msk                  (0x1UL << EXTI_EMR1_EM22_Pos)           /*!< 0x00400000 */
#define EXTI_EMR1_EM22                      EXTI_EMR1_EM22_Msk                      /*!< Event Mask on line 22 */
#define EXTI_EMR1_EM23_Pos                  (23U)
#define EXTI_EMR1_EM23_Msk                  (0x1UL << EXTI_EMR1_EM23_Pos)           /*!< 0x00800000 */
#define EXTI_EMR1_EM23                      EXTI_EMR1_EM23_Msk                      /*!< Event Mask on line 23 */
#define EXTI_EMR1_EM24_Pos                  (24U)
#define EXTI_EMR1_EM24_Msk                  (0x1UL << EXTI_EMR1_EM24_Pos)           /*!< 0x01000000 */
#define EXTI_EMR1_EM24                      EXTI_EMR1_EM24_Msk                      /*!< Event Mask on line 24 */
#define EXTI_EMR1_EM25_Pos                  (25U)
#define EXTI_EMR1_EM25_Msk                  (0x1UL << EXTI_EMR1_EM25_Pos)           /*!< 0x02000000 */
#define EXTI_EMR1_EM25                      EXTI_EMR1_EM25_Msk                      /*!< Event Mask on line 25 */

/******************************************************************************/
/*                                                                            */
/*                 Flexible Datarate Controller Area Network                  */
/*                                                                            */
/******************************************************************************/
/*!<FDCAN control and status registers */
/*****************  Bit definition for FDCAN_CREL register  *******************/
#define FDCAN_CREL_DAY_Pos                  (0U)
#define FDCAN_CREL_DAY_Msk                  (0xFFUL << FDCAN_CREL_DAY_Pos)          /*!< 0x000000FF */
#define FDCAN_CREL_DAY                      FDCAN_CREL_DAY_Msk                      /*!<Timestamp Day                           */
#define FDCAN_CREL_MON_Pos                  (8U)
#define FDCAN_CREL_MON_Msk                  (0xFFUL << FDCAN_CREL_MON_Pos)          /*!< 0x0000FF00 */
#define FDCAN_CREL_MON                      FDCAN_CREL_MON_Msk                      /*!<Timestamp Month                         */
#define FDCAN_CREL_YEAR_Pos                 (16U)
#define FDCAN_CREL_YEAR_Msk                 (0xFUL << FDCAN_CREL_YEAR_Pos)          /*!< 0x000F0000 */
#define FDCAN_CREL_YEAR                     FDCAN_CREL_YEAR_Msk                     /*!<Timestamp Year                          */
#define FDCAN_CREL_SUBSTEP_Pos              (20U)
#define FDCAN_CREL_SUBSTEP_Msk              (0xFUL << FDCAN_CREL_SUBSTEP_Pos)       /*!< 0x00F00000 */
#define FDCAN_CREL_SUBSTEP                  FDCAN_CREL_SUBSTEP_Msk                  /*!<Sub-step of Core release                */
#define FDCAN_CREL_STEP_Pos                 (24U)
#define FDCAN_CREL_STEP_Msk                 (0xFUL << FDCAN_CREL_STEP_Pos)          /*!< 0x0F000000 */
#define FDCAN_CREL_STEP                     FDCAN_CREL_STEP_Msk                     /*!<Step of Core release                    */
#define FDCAN_CREL_REL_Pos                  (28U)
#define FDCAN_CREL_REL_Msk                  (0xFUL << FDCAN_CREL_REL_Pos)           /*!< 0xF0000000 */
#define FDCAN_CREL_REL                      FDCAN_CREL_REL_Msk                      /*!<Core release                            */

/*****************  Bit definition for FDCAN_ENDN register  *******************/
#define FDCAN_ENDN_ETV_Pos                  (0U)
#define FDCAN_ENDN_ETV_Msk                  (0xFFFFFFFFUL << FDCAN_ENDN_ETV_Pos)    /*!< 0xFFFFFFFF */
#define FDCAN_ENDN_ETV                      FDCAN_ENDN_ETV_Msk                      /*!<Endianness Test Value                    */

/*****************  Bit definition for FDCAN_DBTP register  *******************/
#define FDCAN_DBTP_DSJW_Pos                 (0U)
#define FDCAN_DBTP_DSJW_Msk                 (0xFUL << FDCAN_DBTP_DSJW_Pos)          /*!< 0x0000000F */
#define FDCAN_DBTP_DSJW                     FDCAN_DBTP_DSJW_Msk                     /*!<Synchronization Jump Width              */
#define FDCAN_DBTP_DTSEG2_Pos               (4U)
#define FDCAN_DBTP_DTSEG2_Msk               (0xFUL << FDCAN_DBTP_DTSEG2_Pos)        /*!< 0x000000F0 */
#define FDCAN_DBTP_DTSEG2                   FDCAN_DBTP_DTSEG2_Msk                   /*!<Data time segment after sample point    */
#define FDCAN_DBTP_DTSEG1_Pos               (8U)
#define FDCAN_DBTP_DTSEG1_Msk               (0x1FUL << FDCAN_DBTP_DTSEG1_Pos)       /*!< 0x00001F00 */
#define FDCAN_DBTP_DTSEG1                   FDCAN_DBTP_DTSEG1_Msk                   /*!<Data time segment before sample point   */
#define FDCAN_DBTP_DBRP_Pos                 (16U)
#define FDCAN_DBTP_DBRP_Msk                 (0x1FUL << FDCAN_DBTP_DBRP_Pos)         /*!< 0x001F0000 */
#define FDCAN_DBTP_DBRP                     FDCAN_DBTP_DBRP_Msk                     /*!<Data BIt Rate Prescaler                 */
#define FDCAN_DBTP_TDC_Pos                  (23U)
#define FDCAN_DBTP_TDC_Msk                  (0x1UL << FDCAN_DBTP_TDC_Pos)           /*!< 0x00800000 */
#define FDCAN_DBTP_TDC                      FDCAN_DBTP_TDC_Msk                      /*!<Transceiver Delay Compensation          */

/*****************  Bit definition for FDCAN_TEST register  *******************/
#define FDCAN_TEST_LBCK_Pos                 (4U)
#define FDCAN_TEST_LBCK_Msk                 (0x1UL << FDCAN_TEST_LBCK_Pos)          /*!< 0x00000010 */
#define FDCAN_TEST_LBCK                     FDCAN_TEST_LBCK_Msk                     /*!<Loop Back mode                           */
#define FDCAN_TEST_TX_Pos                   (5U)
#define FDCAN_TEST_TX_Msk                   (0x3UL << FDCAN_TEST_TX_Pos)            /*!< 0x00000060 */
#define FDCAN_TEST_TX                       FDCAN_TEST_TX_Msk                       /*!<Control of Transmit Pin                  */
#define FDCAN_TEST_RX_Pos                   (7U)
#define FDCAN_TEST_RX_Msk                   (0x1UL << FDCAN_TEST_RX_Pos)            /*!< 0x00000080 */
#define FDCAN_TEST_RX                       FDCAN_TEST_RX_Msk                       /*!<Receive Pin                              */

/*****************  Bit definition for FDCAN_RWD register  ********************/
#define FDCAN_RWD_WDC_Pos                   (0U)
#define FDCAN_RWD_WDC_Msk                   (0xFFUL << FDCAN_RWD_WDC_Pos)           /*!< 0x000000FF */
#define FDCAN_RWD_WDC                       FDCAN_RWD_WDC_Msk                       /*!<Watchdog configuration                   */
#define FDCAN_RWD_WDV_Pos                   (8U)
#define FDCAN_RWD_WDV_Msk                   (0xFFUL << FDCAN_RWD_WDV_Pos)           /*!< 0x0000FF00 */
#define FDCAN_RWD_WDV                       FDCAN_RWD_WDV_Msk                       /*!<Watchdog value                           */

/*****************  Bit definition for FDCAN_CCCR register  ********************/
#define FDCAN_CCCR_INIT_Pos                 (0U)
#define FDCAN_CCCR_INIT_Msk                 (0x1UL << FDCAN_CCCR_INIT_Pos)          /*!< 0x00000001 */
#define FDCAN_CCCR_INIT                     FDCAN_CCCR_INIT_Msk                     /*!<Initialization                           */
#define FDCAN_CCCR_CCE_Pos                  (1U)
#define FDCAN_CCCR_CCE_Msk                  (0x1UL << FDCAN_CCCR_CCE_Pos)           /*!< 0x00000002 */
#define FDCAN_CCCR_CCE                      FDCAN_CCCR_CCE_Msk                      /*!<Configuration Change Enable              */
#define FDCAN_CCCR_ASM_Pos                  (2U)
#define FDCAN_CCCR_ASM_Msk                  (0x1UL << FDCAN_CCCR_ASM_Pos)           /*!< 0x00000004 */
#define FDCAN_CCCR_ASM                      FDCAN_CCCR_ASM_Msk                      /*!<ASM Restricted Operation Mode            */
#define FDCAN_CCCR_CSA_Pos                  (3U)
#define FDCAN_CCCR_CSA_Msk                  (0x1UL << FDCAN_CCCR_CSA_Pos)           /*!< 0x00000008 */
#define FDCAN_CCCR_CSA                      FDCAN_CCCR_CSA_Msk                      /*!<Clock Stop Acknowledge                   */
#define FDCAN_CCCR_CSR_Pos                  (4U)
#define FDCAN_CCCR_CSR_Msk                  (0x1UL << FDCAN_CCCR_CSR_Pos)           /*!< 0x00000010 */
#define FDCAN_CCCR_CSR                      FDCAN_CCCR_CSR_Msk                      /*!<Clock Stop Request                       */
#define FDCAN_CCCR_MON_Pos                  (5U)
#define FDCAN_CCCR_MON_Msk                  (0x1UL << FDCAN_CCCR_MON_Pos)           /*!< 0x00000020 */
#define FDCAN_CCCR_MON                      FDCAN_CCCR_MON_Msk                      /*!<Bus Monitoring Mode                      */
#define FDCAN_CCCR_DAR_Pos                  (6U)
#define FDCAN_CCCR_DAR_Msk                  (0x1UL << FDCAN_CCCR_DAR_Pos)           /*!< 0x00000040 */
#define FDCAN_CCCR_DAR                      FDCAN_CCCR_DAR_Msk                      /*!<Disable Automatic Retransmission         */
#define FDCAN_CCCR_TEST_Pos                 (7U)
#define FDCAN_CCCR_TEST_Msk                 (0x1UL << FDCAN_CCCR_TEST_Pos)          /*!< 0x00000080 */
#define FDCAN_CCCR_TEST                     FDCAN_CCCR_TEST_Msk                     /*!<Test Mode Enable                         */
#define FDCAN_CCCR_FDOE_Pos                 (8U)
#define FDCAN_CCCR_FDOE_Msk                 (0x1UL << FDCAN_CCCR_FDOE_Pos)          /*!< 0x00000100 */
#define FDCAN_CCCR_FDOE                     FDCAN_CCCR_FDOE_Msk                     /*!<FD Operation Enable                      */
#define FDCAN_CCCR_BRSE_Pos                 (9U)
#define FDCAN_CCCR_BRSE_Msk                 (0x1UL << FDCAN_CCCR_BRSE_Pos)          /*!< 0x00000200 */
#define FDCAN_CCCR_BRSE                     FDCAN_CCCR_BRSE_Msk                     /*!<FDCAN Bit Rate Switching                 */
#define FDCAN_CCCR_PXHD_Pos                 (12U)
#define FDCAN_CCCR_PXHD_Msk                 (0x1UL << FDCAN_CCCR_PXHD_Pos)          /*!< 0x00001000 */
#define FDCAN_CCCR_PXHD                     FDCAN_CCCR_PXHD_Msk                     /*!<Protocol Exception Handling Disable      */
#define FDCAN_CCCR_EFBI_Pos                 (13U)
#define FDCAN_CCCR_EFBI_Msk                 (0x1UL << FDCAN_CCCR_EFBI_Pos)          /*!< 0x00002000 */
#define FDCAN_CCCR_EFBI                     FDCAN_CCCR_EFBI_Msk                     /*!<Edge Filtering during Bus Integration    */
#define FDCAN_CCCR_TXP_Pos                  (14U)
#define FDCAN_CCCR_TXP_Msk                  (0x1UL << FDCAN_CCCR_TXP_Pos)           /*!< 0x00004000 */
#define FDCAN_CCCR_TXP                      FDCAN_CCCR_TXP_Msk                      /*!<Two CAN bit times Pause                  */
#define FDCAN_CCCR_NISO_Pos                 (15U)
#define FDCAN_CCCR_NISO_Msk                 (0x1UL << FDCAN_CCCR_NISO_Pos)          /*!< 0x00008000 */
#define FDCAN_CCCR_NISO                     FDCAN_CCCR_NISO_Msk                     /*!<Non ISO Operation                        */

/*****************  Bit definition for FDCAN_NBTP register  ******************* */
#define FDCAN_NBTP_NTSEG2_Pos               (0U)
#define FDCAN_NBTP_NTSEG2_Msk               (0x7FUL << FDCAN_NBTP_NTSEG2_Pos)       /*!< 0x0000007F */
#define FDCAN_NBTP_NTSEG2                   FDCAN_NBTP_NTSEG2_Msk                   /*!<Nominal Time segment after sample point  */
#define FDCAN_NBTP_NTSEG1_Pos               (8U)
#define FDCAN_NBTP_NTSEG1_Msk               (0xFFUL << FDCAN_NBTP_NTSEG1_Pos)       /*!< 0x0000FF00 */
#define FDCAN_NBTP_NTSEG1                   FDCAN_NBTP_NTSEG1_Msk                   /*!<Nominal Time segment before sample point */
#define FDCAN_NBTP_NBRP_Pos                 (16U)
#define FDCAN_NBTP_NBRP_Msk                 (0x1FFUL << FDCAN_NBTP_NBRP_Pos)        /*!< 0x01FF0000 */
#define FDCAN_NBTP_NBRP                     FDCAN_NBTP_NBRP_Msk                     /*!<Bit Rate Prescaler                       */
#define FDCAN_NBTP_NSJW_Pos                 (25U)
#define FDCAN_NBTP_NSJW_Msk                 (0x7FUL << FDCAN_NBTP_NSJW_Pos)         /*!< 0xFE000000 */
#define FDCAN_NBTP_NSJW                     FDCAN_NBTP_NSJW_Msk                     /*!<Nominal (Re)Synchronization Jump Width   */

/*****************  Bit definition for FDCAN_TSCC register  ********************/
#define FDCAN_TSCC_TSS_Pos                  (0U)
#define FDCAN_TSCC_TSS_Msk                  (0x3UL << FDCAN_TSCC_TSS_Pos)           /*!< 0x00000003 */
#define FDCAN_TSCC_TSS                      FDCAN_TSCC_TSS_Msk                      /*!<Timestamp Select                         */
#define FDCAN_TSCC_TCP_Pos                  (16U)
#define FDCAN_TSCC_TCP_Msk                  (0xFUL << FDCAN_TSCC_TCP_Pos)           /*!< 0x000F0000 */
#define FDCAN_TSCC_TCP                      FDCAN_TSCC_TCP_Msk                      /*!<Timestamp Counter Prescaler              */

/*****************  Bit definition for FDCAN_TSCV register  ********************/
#define FDCAN_TSCV_TSC_Pos                  (0U)
#define FDCAN_TSCV_TSC_Msk                  (0xFFFFUL << FDCAN_TSCV_TSC_Pos)        /*!< 0x0000FFFF */
#define FDCAN_TSCV_TSC                      FDCAN_TSCV_TSC_Msk                      /*!<Timestamp Counter                        */

/*****************  Bit definition for FDCAN_TOCC register  ********************/
#define FDCAN_TOCC_ETOC_Pos                 (0U)
#define FDCAN_TOCC_ETOC_Msk                 (0x1UL << FDCAN_TOCC_ETOC_Pos)          /*!< 0x00000001 */
#define FDCAN_TOCC_ETOC                     FDCAN_TOCC_ETOC_Msk                     /*!<Enable Timeout Counter                   */
#define FDCAN_TOCC_TOS_Pos                  (1U)
#define FDCAN_TOCC_TOS_Msk                  (0x3UL << FDCAN_TOCC_TOS_Pos)           /*!< 0x00000006 */
#define FDCAN_TOCC_TOS                      FDCAN_TOCC_TOS_Msk                      /*!<Timeout Select                           */
#define FDCAN_TOCC_TOP_Pos                  (16U)
#define FDCAN_TOCC_TOP_Msk                  (0xFFFFUL << FDCAN_TOCC_TOP_Pos)        /*!< 0xFFFF0000 */
#define FDCAN_TOCC_TOP                      FDCAN_TOCC_TOP_Msk                      /*!<Timeout Period                           */

/*****************  Bit definition for FDCAN_TOCV register  ******************* */
#define FDCAN_TOCV_TOC_Pos                  (0U)
#define FDCAN_TOCV_TOC_Msk                  (0xFFFFUL << FDCAN_TOCV_TOC_Pos)        /*!< 0x0000FFFF */
#define FDCAN_TOCV_TOC                      FDCAN_TOCV_TOC_Msk                      /*!<Timeout Counter                          */

/*****************  Bit definition for FDCAN_ECR register  ******************** */
#define FDCAN_ECR_TEC_Pos                   (0U)
#define FDCAN_ECR_TEC_Msk                   (0xFFUL << FDCAN_ECR_TEC_Pos)           /*!< 0x000000FF */
#define FDCAN_ECR_TEC                       FDCAN_ECR_TEC_Msk                       /*!<Transmit Error Counter                   */
#define FDCAN_ECR_REC_Pos                   (8U)
#define FDCAN_ECR_REC_Msk                   (0x7FUL << FDCAN_ECR_REC_Pos)           /*!< 0x00007F00 */
#define FDCAN_ECR_REC                       FDCAN_ECR_REC_Msk                       /*!<Receive Error Counter                    */
#define FDCAN_ECR_RP_Pos                    (15U)
#define FDCAN_ECR_RP_Msk                    (0x1UL << FDCAN_ECR_RP_Pos)             /*!< 0x00008000 */
#define FDCAN_ECR_RP                        FDCAN_ECR_RP_Msk                        /*!<Receive Error Passive                    */
#define FDCAN_ECR_CEL_Pos                   (16U)
#define FDCAN_ECR_CEL_Msk                   (0xFFUL << FDCAN_ECR_CEL_Pos)           /*!< 0x00FF0000 */
#define FDCAN_ECR_CEL                       FDCAN_ECR_CEL_Msk                       /*!<CAN Error Logging                        */

/*****************  Bit definition for FDCAN_PSR register  ******************** */
#define FDCAN_PSR_LEC_Pos                   (0U)
#define FDCAN_PSR_LEC_Msk                   (0x7UL << FDCAN_PSR_LEC_Pos)            /*!< 0x00000007 */
#define FDCAN_PSR_LEC                       FDCAN_PSR_LEC_Msk                       /*!<Last Error Code                          */
#define FDCAN_PSR_ACT_Pos                   (3U)
#define FDCAN_PSR_ACT_Msk                   (0x3UL << FDCAN_PSR_ACT_Pos)            /*!< 0x00000018 */
#define FDCAN_PSR_ACT                       FDCAN_PSR_ACT_Msk                       /*!<Activity                                 */
#define FDCAN_PSR_EP_Pos                    (5U)
#define FDCAN_PSR_EP_Msk                    (0x1UL << FDCAN_PSR_EP_Pos)             /*!< 0x00000020 */
#define FDCAN_PSR_EP                        FDCAN_PSR_EP_Msk                        /*!<Error Passive                            */
#define FDCAN_PSR_EW_Pos                    (6U)
#define FDCAN_PSR_EW_Msk                    (0x1UL << FDCAN_PSR_EW_Pos)             /*!< 0x00000040 */
#define FDCAN_PSR_EW                        FDCAN_PSR_EW_Msk                        /*!<Warning Status                           */
#define FDCAN_PSR_BO_Pos                    (7U)
#define FDCAN_PSR_BO_Msk                    (0x1UL << FDCAN_PSR_BO_Pos)             /*!< 0x00000080 */
#define FDCAN_PSR_BO                        FDCAN_PSR_BO_Msk                        /*!<Bus_Off Status                           */
#define FDCAN_PSR_DLEC_Pos                  (8U)
#define FDCAN_PSR_DLEC_Msk                  (0x7UL << FDCAN_PSR_DLEC_Pos)           /*!< 0x00000700 */
#define FDCAN_PSR_DLEC                      FDCAN_PSR_DLEC_Msk                      /*!<Data Last Error Code                     */
#define FDCAN_PSR_RESI_Pos                  (11U)
#define FDCAN_PSR_RESI_Msk                  (0x1UL << FDCAN_PSR_RESI_Pos)           /*!< 0x00000800 */
#define FDCAN_PSR_RESI                      FDCAN_PSR_RESI_Msk                      /*!<ESI flag of last received FDCAN Message  */
#define FDCAN_PSR_RBRS_Pos                  (12U)
#define FDCAN_PSR_RBRS_Msk                  (0x1UL << FDCAN_PSR_RBRS_Pos)           /*!< 0x00001000 */
#define FDCAN_PSR_RBRS                      FDCAN_PSR_RBRS_Msk                      /*!<BRS flag of last received FDCAN Message  */
#define FDCAN_PSR_REDL_Pos                  (13U)
#define FDCAN_PSR_REDL_Msk                  (0x1UL << FDCAN_PSR_REDL_Pos)           /*!< 0x00002000 */
#define FDCAN_PSR_REDL                      FDCAN_PSR_REDL_Msk                      /*!<Received FDCAN Message                   */
#define FDCAN_PSR_PXE_Pos                   (14U)
#define FDCAN_PSR_PXE_Msk                   (0x1UL << FDCAN_PSR_PXE_Pos)            /*!< 0x00004000 */
#define FDCAN_PSR_PXE                       FDCAN_PSR_PXE_Msk                       /*!<Protocol Exception Event                 */
#define FDCAN_PSR_TDCV_Pos                  (16U)
#define FDCAN_PSR_TDCV_Msk                  (0x7FUL << FDCAN_PSR_TDCV_Pos)          /*!< 0x007F0000 */
#define FDCAN_PSR_TDCV                      FDCAN_PSR_TDCV_Msk                      /*!<Transmitter Delay Compensation Value     */

/*****************  Bit definition for FDCAN_TDCR register  ******************* */
#define FDCAN_TDCR_TDCF_Pos                 (0U)
#define FDCAN_TDCR_TDCF_Msk                 (0x7FUL << FDCAN_TDCR_TDCF_Pos)         /*!< 0x0000007F */
#define FDCAN_TDCR_TDCF                     FDCAN_TDCR_TDCF_Msk                     /*!<Transmitter Delay Compensation Filter    */
#define FDCAN_TDCR_TDCO_Pos                 (8U)
#define FDCAN_TDCR_TDCO_Msk                 (0x7FUL << FDCAN_TDCR_TDCO_Pos)         /*!< 0x00007F00 */
#define FDCAN_TDCR_TDCO                     FDCAN_TDCR_TDCO_Msk                     /*!<Transmitter Delay Compensation Offset    */

/*****************  Bit definition for FDCAN_IR register  ********************* */
#define FDCAN_IR_RF0N_Pos                   (0U)
#define FDCAN_IR_RF0N_Msk                   (0x1UL << FDCAN_IR_RF0N_Pos)            /*!< 0x00000001 */
#define FDCAN_IR_RF0N                       FDCAN_IR_RF0N_Msk                       /*!<Rx FIFO 0 New Message                    */
#define FDCAN_IR_RF0F_Pos                   (1U)
#define FDCAN_IR_RF0F_Msk                   (0x1UL << FDCAN_IR_RF0F_Pos)            /*!< 0x00000002 */
#define FDCAN_IR_RF0F                       FDCAN_IR_RF0F_Msk                       /*!<Rx FIFO 0 Full                           */
#define FDCAN_IR_RF0L_Pos                   (2U)
#define FDCAN_IR_RF0L_Msk                   (0x1UL << FDCAN_IR_RF0L_Pos)            /*!< 0x00000004 */
#define FDCAN_IR_RF0L                       FDCAN_IR_RF0L_Msk                       /*!<Rx FIFO 0 Message Lost                   */
#define FDCAN_IR_RF1N_Pos                   (3U)
#define FDCAN_IR_RF1N_Msk                   (0x1UL << FDCAN_IR_RF1N_Pos)            /*!< 0x00000008 */
#define FDCAN_IR_RF1N                       FDCAN_IR_RF1N_Msk                       /*!<Rx FIFO 1 New Message                    */
#define FDCAN_IR_RF1F_Pos                   (4U)
#define FDCAN_IR_RF1F_Msk                   (0x1UL << FDCAN_IR_RF1F_Pos)            /*!< 0x00000010 */
#define FDCAN_IR_RF1F                       FDCAN_IR_RF1F_Msk                       /*!<Rx FIFO 1 Full                           */
#define FDCAN_IR_RF1L_Pos                   (5U)
#define FDCAN_IR_RF1L_Msk                   (0x1UL << FDCAN_IR_RF1L_Pos)            /*!< 0x00000020 */
#define FDCAN_IR_RF1L                       FDCAN_IR_RF1L_Msk                       /*!<Rx FIFO 1 Message Lost                   */
#define FDCAN_IR_HPM_Pos                    (6U)
#define FDCAN_IR_HPM_Msk                    (0x1UL << FDCAN_IR_HPM_Pos)             /*!< 0x00000040 */
#define FDCAN_IR_HPM                        FDCAN_IR_HPM_Msk                        /*!<High Priority Message                    */
#define FDCAN_IR_TC_Pos                     (7U)
#define FDCAN_IR_TC_Msk                     (0x1UL << FDCAN_IR_TC_Pos)              /*!< 0x00000080 */
#define FDCAN_IR_TC                         FDCAN_IR_TC_Msk                         /*!<Transmission Completed                   */
#define FDCAN_IR_TCF_Pos                    (8U)
#define FDCAN_IR_TCF_Msk                    (0x1UL << FDCAN_IR_TCF_Pos)             /*!< 0x00000100 */
#define FDCAN_IR_TCF                        FDCAN_IR_TCF_Msk                        /*!<Transmission Cancellation Finished       */
#define FDCAN_IR_TFE_Pos                    (9U)
#define FDCAN_IR_TFE_Msk                    (0x1UL << FDCAN_IR_TFE_Pos)             /*!< 0x00000200 */
#define FDCAN_IR_TFE                        FDCAN_IR_TFE_Msk                        /*!<Tx FIFO Empty                            */
#define FDCAN_IR_TEFN_Pos                   (10U)
#define FDCAN_IR_TEFN_Msk                   (0x1UL << FDCAN_IR_TEFN_Pos)            /*!< 0x00000400 */
#define FDCAN_IR_TEFN                       FDCAN_IR_TEFN_Msk                       /*!<Tx Event FIFO New Entry                  */
#define FDCAN_IR_TEFF_Pos                   (11U)
#define FDCAN_IR_TEFF_Msk                   (0x1UL << FDCAN_IR_TEFF_Pos)            /*!< 0x00000800 */
#define FDCAN_IR_TEFF                       FDCAN_IR_TEFF_Msk                       /*!<Tx Event FIFO Full                       */
#define FDCAN_IR_TEFL_Pos                   (12U)
#define FDCAN_IR_TEFL_Msk                   (0x1UL << FDCAN_IR_TEFL_Pos)            /*!< 0x00001000 */
#define FDCAN_IR_TEFL                       FDCAN_IR_TEFL_Msk                       /*!<Tx Event FIFO Element Lost               */
#define FDCAN_IR_TSW_Pos                    (13U)
#define FDCAN_IR_TSW_Msk                    (0x1UL << FDCAN_IR_TSW_Pos)             /*!< 0x00002000 */
#define FDCAN_IR_TSW                        FDCAN_IR_TSW_Msk                        /*!<Timestamp Wraparound                     */
#define FDCAN_IR_MRAF_Pos                   (14U)
#define FDCAN_IR_MRAF_Msk                   (0x1UL << FDCAN_IR_MRAF_Pos)            /*!< 0x00004000 */
#define FDCAN_IR_MRAF                       FDCAN_IR_MRAF_Msk                       /*!<Message RAM Access Failure               */
#define FDCAN_IR_TOO_Pos                    (15U)
#define FDCAN_IR_TOO_Msk                    (0x1UL << FDCAN_IR_TOO_Pos)             /*!< 0x00008000 */
#define FDCAN_IR_TOO                        FDCAN_IR_TOO_Msk                        /*!<Timeout Occurred                         */
#define FDCAN_IR_ELO_Pos                    (16U)
#define FDCAN_IR_ELO_Msk                    (0x1UL << FDCAN_IR_ELO_Pos)             /*!< 0x00010000 */
#define FDCAN_IR_ELO                        FDCAN_IR_ELO_Msk                        /*!<Error Logging Overflow                   */
#define FDCAN_IR_EP_Pos                     (17U)
#define FDCAN_IR_EP_Msk                     (0x1UL << FDCAN_IR_EP_Pos)              /*!< 0x00020000 */
#define FDCAN_IR_EP                         FDCAN_IR_EP_Msk                         /*!<Error Passive                            */
#define FDCAN_IR_EW_Pos                     (18U)
#define FDCAN_IR_EW_Msk                     (0x1UL << FDCAN_IR_EW_Pos)              /*!< 0x00040000 */
#define FDCAN_IR_EW                         FDCAN_IR_EW_Msk                         /*!<Warning Status                           */
#define FDCAN_IR_BO_Pos                     (19U)
#define FDCAN_IR_BO_Msk                     (0x1UL << FDCAN_IR_BO_Pos)              /*!< 0x00080000 */
#define FDCAN_IR_BO                         FDCAN_IR_BO_Msk                         /*!<Bus_Off Status                           */
#define FDCAN_IR_WDI_Pos                    (20U)
#define FDCAN_IR_WDI_Msk                    (0x1UL << FDCAN_IR_WDI_Pos)             /*!< 0x00100000 */
#define FDCAN_IR_WDI                        FDCAN_IR_WDI_Msk                        /*!<Watchdog Interrupt                       */
#define FDCAN_IR_PEA_Pos                    (21U)
#define FDCAN_IR_PEA_Msk                    (0x1UL << FDCAN_IR_PEA_Pos)             /*!< 0x00200000 */
#define FDCAN_IR_PEA                        FDCAN_IR_PEA_Msk                        /*!<Protocol Error in Arbitration Phase      */
#define FDCAN_IR_PED_Pos                    (22U)
#define FDCAN_IR_PED_Msk                    (0x1UL << FDCAN_IR_PED_Pos)             /*!< 0x00400000 */
#define FDCAN_IR_PED                        FDCAN_IR_PED_Msk                        /*!<Protocol Error in Data Phase             */
#define FDCAN_IR_ARA_Pos                    (23U)
#define FDCAN_IR_ARA_Msk                    (0x1UL << FDCAN_IR_ARA_Pos)             /*!< 0x00800000 */
#define FDCAN_IR_ARA                        FDCAN_IR_ARA_Msk                        /*!<Access to Reserved Address               */

/*****************  Bit definition for FDCAN_IE register  ********************* */
#define FDCAN_IE_RF0NE_Pos                  (0U)
#define FDCAN_IE_RF0NE_Msk                  (0x1UL << FDCAN_IE_RF0NE_Pos)           /*!< 0x00000001 */
#define FDCAN_IE_RF0NE                      FDCAN_IE_RF0NE_Msk                      /*!<Rx FIFO 0 New Message Enable             */
#define FDCAN_IE_RF0FE_Pos                  (1U)
#define FDCAN_IE_RF0FE_Msk                  (0x1UL << FDCAN_IE_RF0FE_Pos)           /*!< 0x00000002 */
#define FDCAN_IE_RF0FE                      FDCAN_IE_RF0FE_Msk                      /*!<Rx FIFO 0 Full Enable                    */
#define FDCAN_IE_RF0LE_Pos                  (2U)
#define FDCAN_IE_RF0LE_Msk                  (0x1UL << FDCAN_IE_RF0LE_Pos)           /*!< 0x00000004 */
#define FDCAN_IE_RF0LE                      FDCAN_IE_RF0LE_Msk                      /*!<Rx FIFO 0 Message Lost Enable            */
#define FDCAN_IE_RF1NE_Pos                  (3U)
#define FDCAN_IE_RF1NE_Msk                  (0x1UL << FDCAN_IE_RF1NE_Pos)           /*!< 0x00000008 */
#define FDCAN_IE_RF1NE                      FDCAN_IE_RF1NE_Msk                      /*!<Rx FIFO 1 New Message Enable             */
#define FDCAN_IE_RF1FE_Pos                  (4U)
#define FDCAN_IE_RF1FE_Msk                  (0x1UL << FDCAN_IE_RF1FE_Pos)           /*!< 0x00000010 */
#define FDCAN_IE_RF1FE                      FDCAN_IE_RF1FE_Msk                      /*!<Rx FIFO 1 Full Enable                    */
#define FDCAN_IE_RF1LE_Pos                  (5U)
#define FDCAN_IE_RF1LE_Msk                  (0x1UL << FDCAN_IE_RF1LE_Pos)           /*!< 0x00000020 */
#define FDCAN_IE_RF1LE                      FDCAN_IE_RF1LE_Msk                      /*!<Rx FIFO 1 Message Lost Enable            */
#define FDCAN_IE_HPME_Pos                   (6U)
#define FDCAN_IE_HPME_Msk                   (0x1UL << FDCAN_IE_HPME_Pos)            /*!< 0x00000040 */
#define FDCAN_IE_HPME                       FDCAN_IE_HPME_Msk                       /*!<High Priority Message Enable             */
#define FDCAN_IE_TCE_Pos                    (7U)
#define FDCAN_IE_TCE_Msk                    (0x1UL << FDCAN_IE_TCE_Pos)             /*!< 0x00000080 */
#define FDCAN_IE_TCE                        FDCAN_IE_TCE_Msk                        /*!<Transmission Completed Enable            */
#define FDCAN_IE_TCFE_Pos                   (8U)
#define FDCAN_IE_TCFE_Msk                   (0x1UL << FDCAN_IE_TCFE_Pos)            /*!< 0x00000100 */
#define FDCAN_IE_TCFE                       FDCAN_IE_TCFE_Msk                       /*!<Transmission Cancellation Finished Enable*/
#define FDCAN_IE_TFEE_Pos                   (9U)
#define FDCAN_IE_TFEE_Msk                   (0x1UL << FDCAN_IE_TFEE_Pos)            /*!< 0x00000200 */
#define FDCAN_IE_TFEE                       FDCAN_IE_TFEE_Msk                       /*!<Tx FIFO Empty Enable                     */
#define FDCAN_IE_TEFNE_Pos                  (10U)
#define FDCAN_IE_TEFNE_Msk                  (0x1UL << FDCAN_IE_TEFNE_Pos)           /*!< 0x00000400 */
#define FDCAN_IE_TEFNE                      FDCAN_IE_TEFNE_Msk                      /*!<Tx Event FIFO New Entry Enable           */
#define FDCAN_IE_TEFFE_Pos                  (11U)
#define FDCAN_IE_TEFFE_Msk                  (0x1UL << FDCAN_IE_TEFFE_Pos)           /*!< 0x00000800 */
#define FDCAN_IE_TEFFE                      FDCAN_IE_TEFFE_Msk                      /*!<Tx Event FIFO Full Enable                */
#define FDCAN_IE_TEFLE_Pos                  (12U)
#define FDCAN_IE_TEFLE_Msk                  (0x1UL << FDCAN_IE_TEFLE_Pos)           /*!< 0x00001000 */
#define FDCAN_IE_TEFLE                      FDCAN_IE_TEFLE_Msk                      /*!<Tx Event FIFO Element Lost Enable        */
#define FDCAN_IE_TSWE_Pos                   (13U)
#define FDCAN_IE_TSWE_Msk                   (0x1UL << FDCAN_IE_TSWE_Pos)            /*!< 0x00002000 */
#define FDCAN_IE_TSWE                       FDCAN_IE_TSWE_Msk                       /*!<Timestamp Wraparound Enable              */
#define FDCAN_IE_MRAFE_Pos                  (14U)
#define FDCAN_IE_MRAFE_Msk                  (0x1UL << FDCAN_IE_MRAFE_Pos)           /*!< 0x00004000 */
#define FDCAN_IE_MRAFE                      FDCAN_IE_MRAFE_Msk                      /*!<Message RAM Access Failure Enable        */
#define FDCAN_IE_TOOE_Pos                   (15U)
#define FDCAN_IE_TOOE_Msk                   (0x1UL << FDCAN_IE_TOOE_Pos)            /*!< 0x00008000 */
#define FDCAN_IE_TOOE                       FDCAN_IE_TOOE_Msk                       /*!<Timeout Occurred Enable                  */
#define FDCAN_IE_ELOE_Pos                   (16U)
#define FDCAN_IE_ELOE_Msk                   (0x1UL << FDCAN_IE_ELOE_Pos)            /*!< 0x00010000 */
#define FDCAN_IE_ELOE                       FDCAN_IE_ELOE_Msk                       /*!<Error Logging Overflow Enable            */
#define FDCAN_IE_EPE_Pos                    (17U)
#define FDCAN_IE_EPE_Msk                    (0x1UL << FDCAN_IE_EPE_Pos)             /*!< 0x00020000 */
#define FDCAN_IE_EPE                        FDCAN_IE_EPE_Msk                        /*!<Error Passive Enable                     */
#define FDCAN_IE_EWE_Pos                    (18U)
#define FDCAN_IE_EWE_Msk                    (0x1UL << FDCAN_IE_EWE_Pos)             /*!< 0x00040000 */
#define FDCAN_IE_EWE                        FDCAN_IE_EWE_Msk                        /*!<Warning Status Enable                    */
#define FDCAN_IE_BOE_Pos                    (19U)
#define FDCAN_IE_BOE_Msk                    (0x1UL << FDCAN_IE_BOE_Pos)             /*!< 0x00080000 */
#define FDCAN_IE_BOE                        FDCAN_IE_BOE_Msk                        /*!<Bus_Off Status Enable                    */
#define FDCAN_IE_WDIE_Pos                   (20U)
#define FDCAN_IE_WDIE_Msk                   (0x1UL << FDCAN_IE_WDIE_Pos)            /*!< 0x00100000 */
#define FDCAN_IE_WDIE                       FDCAN_IE_WDIE_Msk                       /*!<Watchdog Interrupt Enable                */
#define FDCAN_IE_PEAE_Pos                   (21U)
#define FDCAN_IE_PEAE_Msk                   (0x1UL << FDCAN_IE_PEAE_Pos)            /*!< 0x00200000 */
#define FDCAN_IE_PEAE                       FDCAN_IE_PEAE_Msk                       /*!<Protocol Error in Arbitration Phase Enable*/
#define FDCAN_IE_PEDE_Pos                   (22U)
#define FDCAN_IE_PEDE_Msk                   (0x1UL << FDCAN_IE_PEDE_Pos)            /*!< 0x00400000 */
#define FDCAN_IE_PEDE                       FDCAN_IE_PEDE_Msk                       /*!<Protocol Error in Data Phase Enable      */
#define FDCAN_IE_ARAE_Pos                   (23U)
#define FDCAN_IE_ARAE_Msk                   (0x1UL << FDCAN_IE_ARAE_Pos)            /*!< 0x00800000 */
#define FDCAN_IE_ARAE                       FDCAN_IE_ARAE_Msk                       /*!<Access to Reserved Address Enable        */

/*****************  Bit definition for FDCAN_ILS register  ******************** **/
#define FDCAN_ILS_RXFIFO0_Pos               (0U)
#define FDCAN_ILS_RXFIFO0_Msk               (0x1UL << FDCAN_ILS_RXFIFO0_Pos)        /*!< 0x00000001 */
#define FDCAN_ILS_RXFIFO0                   FDCAN_ILS_RXFIFO0_Msk                   /*!<Rx FIFO 0 Message Lost
                                                                                        Rx FIFO 0 is Full
                                                                                        Rx FIFO 0 Has New Message                */
#define FDCAN_ILS_RXFIFO1_Pos               (1U)
#define FDCAN_ILS_RXFIFO1_Msk               (0x1UL << FDCAN_ILS_RXFIFO1_Pos)        /*!< 0x00000002 */
#define FDCAN_ILS_RXFIFO1                   FDCAN_ILS_RXFIFO1_Msk                   /*!<Rx FIFO 1 Message Lost
                                                                                        Rx FIFO 1 is Full
                                                                                        Rx FIFO 1 Has New Message                */
#define FDCAN_ILS_SMSG_Pos                  (2U)
#define FDCAN_ILS_SMSG_Msk                  (0x1UL << FDCAN_ILS_SMSG_Pos)           /*!< 0x00000004 */
#define FDCAN_ILS_SMSG                      FDCAN_ILS_SMSG_Msk                      /*!<Transmission Cancellation Finished
                                                                                        Transmission Completed
                                                                                        High Priority Message                    */
#define FDCAN_ILS_TFERR_Pos                 (3U)
#define FDCAN_ILS_TFERR_Msk                 (0x1UL << FDCAN_ILS_TFERR_Pos)          /*!< 0x00000008 */
#define FDCAN_ILS_TFERR                     FDCAN_ILS_TFERR_Msk                     /*!<Tx Event FIFO Element Lost
                                                                                        Tx Event FIFO Full
                                                                                        Tx Event FIFO New Entry
                                                                                        Tx FIFO Empty Interrupt Line             */
#define FDCAN_ILS_MISC_Pos                  (4U)
#define FDCAN_ILS_MISC_Msk                  (0x1UL << FDCAN_ILS_MISC_Pos)           /*!< 0x00000010 */
#define FDCAN_ILS_MISC                      FDCAN_ILS_MISC_Msk                      /*!<Timeout Occurred
                                                                                        Message RAM Access Failure
                                                                                        Timestamp Wraparound                    */
#define FDCAN_ILS_BERR_Pos                  (5U)
#define FDCAN_ILS_BERR_Msk                  (0x1UL << FDCAN_ILS_BERR_Pos)           /*!< 0x00000020 */
#define FDCAN_ILS_BERR                      FDCAN_ILS_BERR_Msk                      /*!<Error Passive
                                                                                        Error Logging Overflow                   */
#define FDCAN_ILS_PERR_Pos                  (6U)
#define FDCAN_ILS_PERR_Msk                  (0x1UL << FDCAN_ILS_PERR_Pos)           /*!< 0x00000040 */
#define FDCAN_ILS_PERR                      FDCAN_ILS_PERR_Msk                      /*!<Access to Reserved Address Line
                                                                                        Protocol Error in Data Phase Line
                                                                                        Protocol Error in Arbitration Phase Line
                                                                                        Watchdog Interrupt Line
                                                                                        Bus_Off Status
                                                                                        Warning Status                           */

/*****************  Bit definition for FDCAN_ILE register  ******************** **/
#define FDCAN_ILE_EINT0_Pos                 (0U)
#define FDCAN_ILE_EINT0_Msk                 (0x1UL << FDCAN_ILE_EINT0_Pos)          /*!< 0x00000001 */
#define FDCAN_ILE_EINT0                     FDCAN_ILE_EINT0_Msk                     /*!<Enable Interrupt Line 0                  */
#define FDCAN_ILE_EINT1_Pos                 (1U)
#define FDCAN_ILE_EINT1_Msk                 (0x1UL << FDCAN_ILE_EINT1_Pos)          /*!< 0x00000002 */
#define FDCAN_ILE_EINT1                     FDCAN_ILE_EINT1_Msk                     /*!<Enable Interrupt Line 1                  */

/*****************  Bit definition for FDCAN_RXGFC register  ****************** **/
#define FDCAN_RXGFC_RRFE_Pos                (0U)
#define FDCAN_RXGFC_RRFE_Msk                (0x1UL << FDCAN_RXGFC_RRFE_Pos)         /*!< 0x00000001 */
#define FDCAN_RXGFC_RRFE                    FDCAN_RXGFC_RRFE_Msk                    /*!<Reject Remote Frames Extended            */
#define FDCAN_RXGFC_RRFS_Pos                (1U)
#define FDCAN_RXGFC_RRFS_Msk                (0x1UL << FDCAN_RXGFC_RRFS_Pos)         /*!< 0x00000002 */
#define FDCAN_RXGFC_RRFS                    FDCAN_RXGFC_RRFS_Msk                    /*!<Reject Remote Frames Standard            */
#define FDCAN_RXGFC_ANFE_Pos                (2U)
#define FDCAN_RXGFC_ANFE_Msk                (0x3UL << FDCAN_RXGFC_ANFE_Pos)         /*!< 0x0000000C */
#define FDCAN_RXGFC_ANFE                    FDCAN_RXGFC_ANFE_Msk                    /*!<Accept Non-matching Frames Extended      */
#define FDCAN_RXGFC_ANFS_Pos                (4U)
#define FDCAN_RXGFC_ANFS_Msk                (0x3UL << FDCAN_RXGFC_ANFS_Pos)         /*!< 0x00000030 */
#define FDCAN_RXGFC_ANFS                    FDCAN_RXGFC_ANFS_Msk                    /*!<Accept Non-matching Frames Standard      */
#define FDCAN_RXGFC_F1OM_Pos                (8U)
#define FDCAN_RXGFC_F1OM_Msk                (0x1UL << FDCAN_RXGFC_F1OM_Pos)         /*!< 0x00000100 */
#define FDCAN_RXGFC_F1OM                    FDCAN_RXGFC_F1OM_Msk                    /*!<FIFO 1 operation mode                    */
#define FDCAN_RXGFC_F0OM_Pos                (9U)
#define FDCAN_RXGFC_F0OM_Msk                (0x1UL << FDCAN_RXGFC_F0OM_Pos)         /*!< 0x00000200 */
#define FDCAN_RXGFC_F0OM                    FDCAN_RXGFC_F0OM_Msk                    /*!<FIFO 0 operation mode                    */
#define FDCAN_RXGFC_LSS_Pos                 (16U)
#define FDCAN_RXGFC_LSS_Msk                 (0x1FUL << FDCAN_RXGFC_LSS_Pos)         /*!< 0x001F0000 */
#define FDCAN_RXGFC_LSS                     FDCAN_RXGFC_LSS_Msk                     /*!<List Size Standard                       */
#define FDCAN_RXGFC_LSE_Pos                 (24U)
#define FDCAN_RXGFC_LSE_Msk                 (0xFUL << FDCAN_RXGFC_LSE_Pos)          /*!< 0x0F000000 */
#define FDCAN_RXGFC_LSE                     FDCAN_RXGFC_LSE_Msk                     /*!<List Size Extended                       */

/*****************  Bit definition for FDCAN_XIDAM register  ****************** **/
#define FDCAN_XIDAM_EIDM_Pos                (0U)
#define FDCAN_XIDAM_EIDM_Msk                (0x1FFFFFFFUL << FDCAN_XIDAM_EIDM_Pos)  /*!< 0x1FFFFFFF */
#define FDCAN_XIDAM_EIDM                    FDCAN_XIDAM_EIDM_Msk                    /*!<Extended ID Mask                         */

/*****************  Bit definition for FDCAN_HPMS register  ******************* **/
#define FDCAN_HPMS_BIDX_Pos                 (0U)
#define FDCAN_HPMS_BIDX_Msk                 (0x7UL << FDCAN_HPMS_BIDX_Pos)          /*!< 0x00000007 */
#define FDCAN_HPMS_BIDX                     FDCAN_HPMS_BIDX_Msk                     /*!<Buffer Index                             */
#define FDCAN_HPMS_MSI_Pos                  (6U)
#define FDCAN_HPMS_MSI_Msk                  (0x3UL << FDCAN_HPMS_MSI_Pos)           /*!< 0x000000C0 */
#define FDCAN_HPMS_MSI                      FDCAN_HPMS_MSI_Msk                      /*!<Message Storage Indicator                */
#define FDCAN_HPMS_FIDX_Pos                 (8U)
#define FDCAN_HPMS_FIDX_Msk                 (0x1FUL << FDCAN_HPMS_FIDX_Pos)         /*!< 0x00001F00 */
#define FDCAN_HPMS_FIDX                     FDCAN_HPMS_FIDX_Msk                     /*!<Filter Index                             */
#define FDCAN_HPMS_FLST_Pos                 (15U)
#define FDCAN_HPMS_FLST_Msk                 (0x1UL << FDCAN_HPMS_FLST_Pos)          /*!< 0x00008000 */
#define FDCAN_HPMS_FLST                     FDCAN_HPMS_FLST_Msk                     /*!<Filter List                              */

/*****************  Bit definition for FDCAN_RXF0S register  ****************** **/
#define FDCAN_RXF0S_F0FL_Pos                (0U)
#define FDCAN_RXF0S_F0FL_Msk                (0xFUL << FDCAN_RXF0S_F0FL_Pos)         /*!< 0x0000000F */
#define FDCAN_RXF0S_F0FL                    FDCAN_RXF0S_F0FL_Msk                    /*!<Rx FIFO 0 Fill Level                     */
#define FDCAN_RXF0S_F0GI_Pos                (8U)
#define FDCAN_RXF0S_F0GI_Msk                (0x3UL << FDCAN_RXF0S_F0GI_Pos)         /*!< 0x00000300 */
#define FDCAN_RXF0S_F0GI                    FDCAN_RXF0S_F0GI_Msk                    /*!<Rx FIFO 0 Get Index                      */
#define FDCAN_RXF0S_F0PI_Pos                (16U)
#define FDCAN_RXF0S_F0PI_Msk                (0x3UL << FDCAN_RXF0S_F0PI_Pos)         /*!< 0x00030000 */
#define FDCAN_RXF0S_F0PI                    FDCAN_RXF0S_F0PI_Msk                    /*!<Rx FIFO 0 Put Index                      */
#define FDCAN_RXF0S_F0F_Pos                 (24U)
#define FDCAN_RXF0S_F0F_Msk                 (0x1UL << FDCAN_RXF0S_F0F_Pos)          /*!< 0x01000000 */
#define FDCAN_RXF0S_F0F                     FDCAN_RXF0S_F0F_Msk                     /*!<Rx FIFO 0 Full                           */
#define FDCAN_RXF0S_RF0L_Pos                (25U)
#define FDCAN_RXF0S_RF0L_Msk                (0x1UL << FDCAN_RXF0S_RF0L_Pos)         /*!< 0x02000000 */
#define FDCAN_RXF0S_RF0L                    FDCAN_RXF0S_RF0L_Msk                    /*!<Rx FIFO 0 Message Lost                   */

/*****************  Bit definition for FDCAN_RXF0A register  ****************** **/
#define FDCAN_RXF0A_F0AI_Pos                (0U)
#define FDCAN_RXF0A_F0AI_Msk                (0x7UL << FDCAN_RXF0A_F0AI_Pos)         /*!< 0x00000007 */
#define FDCAN_RXF0A_F0AI                    FDCAN_RXF0A_F0AI_Msk                    /*!<Rx FIFO 0 Acknowledge Index              */

/*****************  Bit definition for FDCAN_RXF1S register  ****************** **/
#define FDCAN_RXF1S_F1FL_Pos                (0U)
#define FDCAN_RXF1S_F1FL_Msk                (0xFUL << FDCAN_RXF1S_F1FL_Pos)         /*!< 0x0000000F */
#define FDCAN_RXF1S_F1FL                    FDCAN_RXF1S_F1FL_Msk                    /*!<Rx FIFO 1 Fill Level                     */
#define FDCAN_RXF1S_F1GI_Pos                (8U)
#define FDCAN_RXF1S_F1GI_Msk                (0x3UL << FDCAN_RXF1S_F1GI_Pos)         /*!< 0x00000300 */
#define FDCAN_RXF1S_F1GI                    FDCAN_RXF1S_F1GI_Msk                    /*!<Rx FIFO 1 Get Index                      */
#define FDCAN_RXF1S_F1PI_Pos                (16U)
#define FDCAN_RXF1S_F1PI_Msk                (0x3UL << FDCAN_RXF1S_F1PI_Pos)         /*!< 0x00030000 */
#define FDCAN_RXF1S_F1PI                    FDCAN_RXF1S_F1PI_Msk                    /*!<Rx FIFO 1 Put Index                      */
#define FDCAN_RXF1S_F1F_Pos                 (24U)
#define FDCAN_RXF1S_F1F_Msk                 (0x1UL << FDCAN_RXF1S_F1F_Pos)          /*!< 0x01000000 */
#define FDCAN_RXF1S_F1F                     FDCAN_RXF1S_F1F_Msk                     /*!<Rx FIFO 1 Full                           */
#define FDCAN_RXF1S_RF1L_Pos                (25U)
#define FDCAN_RXF1S_RF1L_Msk                (0x1UL << FDCAN_RXF1S_RF1L_Pos)         /*!< 0x02000000 */
#define FDCAN_RXF1S_RF1L                    FDCAN_RXF1S_RF1L_Msk                    /*!<Rx FIFO 1 Message Lost                   */

/*****************  Bit definition for FDCAN_RXF1A register  ****************** **/
#define FDCAN_RXF1A_F1AI_Pos                (0U)
#define FDCAN_RXF1A_F1AI_Msk                (0x7UL << FDCAN_RXF1A_F1AI_Pos)         /*!< 0x00000007 */
#define FDCAN_RXF1A_F1AI                    FDCAN_RXF1A_F1AI_Msk                    /*!<Rx FIFO 1 Acknowledge Index              */

/*****************  Bit definition for FDCAN_TXBC register  ******************* **/
#define FDCAN_TXBC_TFQM_Pos                 (24U)
#define FDCAN_TXBC_TFQM_Msk                 (0x1UL << FDCAN_TXBC_TFQM_Pos)          /*!< 0x01000000 */
#define FDCAN_TXBC_TFQM                     FDCAN_TXBC_TFQM_Msk                     /*!<Tx FIFO/Queue Mode                       */

/*****************  Bit definition for FDCAN_TXFQS register  ****************** ***/
#define FDCAN_TXFQS_TFFL_Pos                (0U)
#define FDCAN_TXFQS_TFFL_Msk                (0x7UL << FDCAN_TXFQS_TFFL_Pos)         /*!< 0x00000007 */
#define FDCAN_TXFQS_TFFL                    FDCAN_TXFQS_TFFL_Msk                    /*!<Tx FIFO Free Level                       */
#define FDCAN_TXFQS_TFGI_Pos                (8U)
#define FDCAN_TXFQS_TFGI_Msk                (0x3UL << FDCAN_TXFQS_TFGI_Pos)         /*!< 0x00000300 */
#define FDCAN_TXFQS_TFGI                    FDCAN_TXFQS_TFGI_Msk                    /*!<Tx FIFO Get Index                        */
#define FDCAN_TXFQS_TFQPI_Pos               (16U)
#define FDCAN_TXFQS_TFQPI_Msk               (0x3UL << FDCAN_TXFQS_TFQPI_Pos)        /*!< 0x00030000 */
#define FDCAN_TXFQS_TFQPI                   FDCAN_TXFQS_TFQPI_Msk                   /*!<Tx FIFO/Queue Put Index                  */
#define FDCAN_TXFQS_TFQF_Pos                (21U)
#define FDCAN_TXFQS_TFQF_Msk                (0x1UL << FDCAN_TXFQS_TFQF_Pos)         /*!< 0x00200000 */
#define FDCAN_TXFQS_TFQF                    FDCAN_TXFQS_TFQF_Msk                    /*!<Tx FIFO/Queue Full                       */

/*****************  Bit definition for FDCAN_TXBRP register  ****************** ***/
#define FDCAN_TXBRP_TRP_Pos                 (0U)
#define FDCAN_TXBRP_TRP_Msk                 (0x7UL << FDCAN_TXBRP_TRP_Pos)          /*!< 0x00000007 */
#define FDCAN_TXBRP_TRP                     FDCAN_TXBRP_TRP_Msk                     /*!<Transmission Request Pending             */

/*****************  Bit definition for FDCAN_TXBAR register  ****************** ***/
#define FDCAN_TXBAR_AR_Pos                  (0U)
#define FDCAN_TXBAR_AR_Msk                  (0x7UL << FDCAN_TXBAR_AR_Pos)           /*!< 0x00000007 */
#define FDCAN_TXBAR_AR                      FDCAN_TXBAR_AR_Msk                      /*!<Add Request                              */

/*****************  Bit definition for FDCAN_TXBCR register  ****************** ***/
#define FDCAN_TXBCR_CR_Pos                  (0U)
#define FDCAN_TXBCR_CR_Msk                  (0x7UL << FDCAN_TXBCR_CR_Pos)           /*!< 0x00000007 */
#define FDCAN_TXBCR_CR                      FDCAN_TXBCR_CR_Msk                      /*!<Cancellation Request                     */

/*****************  Bit definition for FDCAN_TXBTO register  ****************** ***/
#define FDCAN_TXBTO_TO_Pos                  (0U)
#define FDCAN_TXBTO_TO_Msk                  (0x7UL << FDCAN_TXBTO_TO_Pos)           /*!< 0x00000007 */
#define FDCAN_TXBTO_TO                      FDCAN_TXBTO_TO_Msk                      /*!<Transmission Occurred                    */

/*****************  Bit definition for FDCAN_TXBCF register  ****************** ***/
#define FDCAN_TXBCF_CF_Pos                  (0U)
#define FDCAN_TXBCF_CF_Msk                  (0x7UL << FDCAN_TXBCF_CF_Pos)           /*!< 0x00000007 */
#define FDCAN_TXBCF_CF                      FDCAN_TXBCF_CF_Msk                      /*!<Cancellation Finished                    */

/*****************  Bit definition for FDCAN_TXBTIE register  ***************** ***/
#define FDCAN_TXBTIE_TIE_Pos                (0U)
#define FDCAN_TXBTIE_TIE_Msk                (0x7UL << FDCAN_TXBTIE_TIE_Pos)         /*!< 0x00000007 */
#define FDCAN_TXBTIE_TIE                    FDCAN_TXBTIE_TIE_Msk                    /*!<Transmission Interrupt Enable            */

/*****************  Bit definition for FDCAN_ TXBCIE register  **************** ***/
#define FDCAN_TXBCIE_CFIE_Pos               (0U)
#define FDCAN_TXBCIE_CFIE_Msk               (0x7UL << FDCAN_TXBCIE_CFIE_Pos)        /*!< 0x00000007 */
#define FDCAN_TXBCIE_CFIE                   FDCAN_TXBCIE_CFIE_Msk                   /*!<Cancellation Finished Interrupt Enable   */

/*****************  Bit definition for FDCAN_TXEFS register  ****************** ***/
#define FDCAN_TXEFS_EFFL_Pos                (0U)
#define FDCAN_TXEFS_EFFL_Msk                (0x7UL << FDCAN_TXEFS_EFFL_Pos)         /*!< 0x00000007 */
#define FDCAN_TXEFS_EFFL                    FDCAN_TXEFS_EFFL_Msk                    /*!<Event FIFO Fill Level                    */
#define FDCAN_TXEFS_EFGI_Pos                (8U)
#define FDCAN_TXEFS_EFGI_Msk                (0x3UL << FDCAN_TXEFS_EFGI_Pos)         /*!< 0x00000300 */
#define FDCAN_TXEFS_EFGI                    FDCAN_TXEFS_EFGI_Msk                    /*!<Event FIFO Get Index                     */
#define FDCAN_TXEFS_EFPI_Pos                (16U)
#define FDCAN_TXEFS_EFPI_Msk                (0x3UL << FDCAN_TXEFS_EFPI_Pos)         /*!< 0x00030000 */
#define FDCAN_TXEFS_EFPI                    FDCAN_TXEFS_EFPI_Msk                    /*!<Event FIFO Put Index                     */
#define FDCAN_TXEFS_EFF_Pos                 (24U)
#define FDCAN_TXEFS_EFF_Msk                 (0x1UL << FDCAN_TXEFS_EFF_Pos)          /*!< 0x01000000 */
#define FDCAN_TXEFS_EFF                     FDCAN_TXEFS_EFF_Msk                     /*!<Event FIFO Full                          */
#define FDCAN_TXEFS_TEFL_Pos                (25U)
#define FDCAN_TXEFS_TEFL_Msk                (0x1UL << FDCAN_TXEFS_TEFL_Pos)         /*!< 0x02000000 */
#define FDCAN_TXEFS_TEFL                    FDCAN_TXEFS_TEFL_Msk                    /*!<Tx Event FIFO Element Lost               */

/*****************  Bit definition for FDCAN_TXEFA register  ****************** ***/
#define FDCAN_TXEFA_EFAI_Pos                (0U)
#define FDCAN_TXEFA_EFAI_Msk                (0x3UL << FDCAN_TXEFA_EFAI_Pos)         /*!< 0x00000003 */
#define FDCAN_TXEFA_EFAI                    FDCAN_TXEFA_EFAI_Msk                    /*!<Event FIFO Acknowledge Index             */

/*!<FDCAN config registers */
/*****************  Bit definition for FDCAN_CKDIV register  ****************** ***/
#define FDCAN_CKDIV_PDIV_Pos                (0U)
#define FDCAN_CKDIV_PDIV_Msk                (0xFUL << FDCAN_CKDIV_PDIV_Pos)         /*!< 0x0000000F */
#define FDCAN_CKDIV_PDIV                    FDCAN_CKDIV_PDIV_Msk                    /*!<Input Clock Divider                      */

/******************************************************************************/
/*                                                                            */
/*                                    FLASH                                   */
/*                                                                            */
/******************************************************************************/
#define FLASH_LATENCY_DEFAULT               FLASH_ACR_LATENCY_3WS   /*!< FLASH Three Latency cycles   */

#define FLASH_SIZE_DEFAULT                  0x400000U               /*!< Flash memory default size */
#define FLASH_BLOCKBASED_NB_REG             (8U)                    /*!< 8 Block-based registers for each Flash bank */

#define FLASH_SIZE                          ((((*((uint16_t *)FLASHSIZE_BASE)) == 0xFFFFU)) ? FLASH_SIZE_DEFAULT : \
                                             ((((*((uint16_t *)FLASHSIZE_BASE)) == 0x0000U)) ? FLASH_SIZE_DEFAULT : \
                                              (((uint32_t)(*((uint16_t *)FLASHSIZE_BASE)) & (0xFFFFU)) << 10U)))

#define FLASH_BANK_SIZE                     (FLASH_SIZE >> 1U)

#define FLASH_PAGE_SIZE                     0x2000U  /* 8 KB */

#define FLASH_PAGE_NB                       (FLASH_BANK_SIZE / FLASH_PAGE_SIZE)

/*******************  Bits definition for FLASH_ACR register  *****************/
#define FLASH_ACR_LATENCY_Pos               (0U)
#define FLASH_ACR_LATENCY_Msk               (0xFUL << FLASH_ACR_LATENCY_Pos)        /*!< 0x0000000F */
#define FLASH_ACR_LATENCY                   FLASH_ACR_LATENCY_Msk                   /*!< Latency    */
#define FLASH_ACR_LATENCY_0WS               (0x00000000U)
#define FLASH_ACR_LATENCY_1WS               (0x00000001U)
#define FLASH_ACR_LATENCY_2WS               (0x00000002U)
#define FLASH_ACR_LATENCY_3WS               (0x00000003U)
#define FLASH_ACR_LATENCY_4WS               (0x00000004U)
#define FLASH_ACR_LATENCY_5WS               (0x00000005U)
#define FLASH_ACR_LATENCY_6WS               (0x00000006U)
#define FLASH_ACR_LATENCY_7WS               (0x00000007U)
#define FLASH_ACR_LATENCY_8WS               (0x00000008U)
#define FLASH_ACR_LATENCY_9WS               (0x00000009U)
#define FLASH_ACR_LATENCY_10WS              (0x0000000AU)
#define FLASH_ACR_LATENCY_11WS              (0x0000000BU)
#define FLASH_ACR_LATENCY_12WS              (0x0000000CU)
#define FLASH_ACR_LATENCY_13WS              (0x0000000DU)
#define FLASH_ACR_LATENCY_14WS              (0x0000000EU)
#define FLASH_ACR_LATENCY_15WS              (0x0000000FU)
#define FLASH_ACR_PRFTEN_Pos                (8U)
#define FLASH_ACR_PRFTEN_Msk                (0x1UL << FLASH_ACR_PRFTEN_Pos)         /*!< 0x00000100 */
#define FLASH_ACR_PRFTEN                    FLASH_ACR_PRFTEN_Msk                    /*!< Prefetch enable */
#define FLASH_ACR_LPM_Pos                   (11U)
#define FLASH_ACR_LPM_Msk                   (0x1UL << FLASH_ACR_LPM_Pos)            /*!< 0x00000800 */
#define FLASH_ACR_LPM                       FLASH_ACR_LPM_Msk                       /*!< Low-Power read mode */
#define FLASH_ACR_PDREQ1_Pos                (12U)
#define FLASH_ACR_PDREQ1_Msk                (0x1UL << FLASH_ACR_PDREQ1_Pos)         /*!< 0x00001000 */
#define FLASH_ACR_PDREQ1                    FLASH_ACR_PDREQ1_Msk                    /*!< Bank 1 power-down mode request */
#define FLASH_ACR_PDREQ2_Pos                (13U)
#define FLASH_ACR_PDREQ2_Msk                (0x1UL << FLASH_ACR_PDREQ2_Pos)         /*!< 0x00002000 */
#define FLASH_ACR_PDREQ2                    FLASH_ACR_PDREQ2_Msk                    /*!< Bank 2 power-down mode request */
#define FLASH_ACR_SLEEP_PD_Pos              (14U)
#define FLASH_ACR_SLEEP_PD_Msk              (0x1UL << FLASH_ACR_SLEEP_PD_Pos)       /*!< 0x00004000 */
#define FLASH_ACR_SLEEP_PD                  FLASH_ACR_SLEEP_PD_Msk                  /*!< Flash power-down mode during sleep */

/******************  Bits definition for FLASH_NSSR register  *****************/
#define FLASH_NSSR_EOP_Pos                  (0U)
#define FLASH_NSSR_EOP_Msk                  (0x1UL << FLASH_NSSR_EOP_Pos)           /*!< 0x00000001 */
#define FLASH_NSSR_EOP                      FLASH_NSSR_EOP_Msk                      /*!< Non-secure end of operation */
#define FLASH_NSSR_OPERR_Pos                (1U)
#define FLASH_NSSR_OPERR_Msk                (0x1UL << FLASH_NSSR_OPERR_Pos)         /*!< 0x00000002 */
#define FLASH_NSSR_OPERR                    FLASH_NSSR_OPERR_Msk                    /*!< Non-secure operation error */
#define FLASH_NSSR_PROGERR_Pos              (3U)
#define FLASH_NSSR_PROGERR_Msk              (0x1UL << FLASH_NSSR_PROGERR_Pos)       /*!< 0x00000008 */
#define FLASH_NSSR_PROGERR                  FLASH_NSSR_PROGERR_Msk                  /*!< Non-secure programming error */
#define FLASH_NSSR_WRPERR_Pos               (4U)
#define FLASH_NSSR_WRPERR_Msk               (0x1UL << FLASH_NSSR_WRPERR_Pos)        /*!< 0x00000010 */
#define FLASH_NSSR_WRPERR                   FLASH_NSSR_WRPERR_Msk                   /*!< Non-secure write protection error */
#define FLASH_NSSR_PGAERR_Pos               (5U)
#define FLASH_NSSR_PGAERR_Msk               (0x1UL << FLASH_NSSR_PGAERR_Pos)        /*!< 0x00000020 */
#define FLASH_NSSR_PGAERR                   FLASH_NSSR_PGAERR_Msk                   /*!< Non-secure programming alignment error */
#define FLASH_NSSR_SIZERR_Pos               (6U)
#define FLASH_NSSR_SIZERR_Msk               (0x1UL << FLASH_NSSR_SIZERR_Pos)        /*!< 0x00000040 */
#define FLASH_NSSR_SIZERR                   FLASH_NSSR_SIZERR_Msk                   /*!< Non-secure size error */
#define FLASH_NSSR_PGSERR_Pos               (7U)
#define FLASH_NSSR_PGSERR_Msk               (0x1UL << FLASH_NSSR_PGSERR_Pos)        /*!< 0x00000080 */
#define FLASH_NSSR_PGSERR                   FLASH_NSSR_PGSERR_Msk                   /*!< Non-secure programming sequence error */
#define FLASH_NSSR_OPTWERR_Pos              (13U)
#define FLASH_NSSR_OPTWERR_Msk              (0x1UL << FLASH_NSSR_OPTWERR_Pos)       /*!< 0x00002000 */
#define FLASH_NSSR_OPTWERR                  FLASH_NSSR_OPTWERR_Msk                  /*!< Option write error */
#define FLASH_NSSR_BSY_Pos                  (16U)
#define FLASH_NSSR_BSY_Msk                  (0x1UL << FLASH_NSSR_BSY_Pos)           /*!< 0x00010000 */
#define FLASH_NSSR_BSY                      FLASH_NSSR_BSY_Msk                      /*!< Non-secure busy */
#define FLASH_NSSR_WDW_Pos                  (17U)
#define FLASH_NSSR_WDW_Msk                  (0x1UL << FLASH_NSSR_WDW_Pos)           /*!< 0x00020000 */
#define FLASH_NSSR_WDW                      FLASH_NSSR_WDW_Msk                      /*!< Non-secure wait data to write */
#define FLASH_NSSR_OEM1LOCK_Pos             (18U)
#define FLASH_NSSR_OEM1LOCK_Msk             (0x1UL << FLASH_NSSR_OEM1LOCK_Pos)      /*!< 0x00040000 */
#define FLASH_NSSR_OEM1LOCK                 FLASH_NSSR_OEM1LOCK_Msk                 /*!< OEM1 lock */
#define FLASH_NSSR_OEM2LOCK_Pos             (19U)
#define FLASH_NSSR_OEM2LOCK_Msk             (0x1UL << FLASH_NSSR_OEM2LOCK_Pos)      /*!< 0x00080000 */
#define FLASH_NSSR_OEM2LOCK                 FLASH_NSSR_OEM2LOCK_Msk                 /*!< OEM2 lock */
#define FLASH_NSSR_PD1_Pos                  (20U)
#define FLASH_NSSR_PD1_Msk                  (0x1UL << FLASH_NSSR_PD1_Pos)           /*!< 0x00100000 */
#define FLASH_NSSR_PD1                      FLASH_NSSR_PD1_Msk                      /*!< Bank 1 in power-down mode */
#define FLASH_NSSR_PD2_Pos                  (21U)
#define FLASH_NSSR_PD2_Msk                  (0x1UL << FLASH_NSSR_PD2_Pos)           /*!< 0x00200000 */
#define FLASH_NSSR_PD2                      FLASH_NSSR_PD2_Msk                      /*!< Bank 2 in power-down mode */

/******************  Bits definition for FLASH_SECSR register  ****************/
#define FLASH_SECSR_EOP_Pos                 (0U)
#define FLASH_SECSR_EOP_Msk                 (0x1UL << FLASH_SECSR_EOP_Pos)          /*!< 0x00000001 */
#define FLASH_SECSR_EOP                     FLASH_SECSR_EOP_Msk                     /*!< Secure end of operation */
#define FLASH_SECSR_OPERR_Pos               (1U)
#define FLASH_SECSR_OPERR_Msk               (0x1UL << FLASH_SECSR_OPERR_Pos)        /*!< 0x00000002 */
#define FLASH_SECSR_OPERR                   FLASH_SECSR_OPERR_Msk                   /*!< Secure operation error */
#define FLASH_SECSR_PROGERR_Pos             (3U)
#define FLASH_SECSR_PROGERR_Msk             (0x1UL << FLASH_SECSR_PROGERR_Pos)      /*!< 0x00000008 */
#define FLASH_SECSR_PROGERR                 FLASH_SECSR_PROGERR_Msk                 /*!< Secure programming error */
#define FLASH_SECSR_WRPERR_Pos              (4U)
#define FLASH_SECSR_WRPERR_Msk              (0x1UL << FLASH_SECSR_WRPERR_Pos)       /*!< 0x00000010 */
#define FLASH_SECSR_WRPERR                  FLASH_SECSR_WRPERR_Msk                  /*!< Secure write protection error */
#define FLASH_SECSR_PGAERR_Pos              (5U)
#define FLASH_SECSR_PGAERR_Msk              (0x1UL << FLASH_SECSR_PGAERR_Pos)       /*!< 0x00000020 */
#define FLASH_SECSR_PGAERR                  FLASH_SECSR_PGAERR_Msk                  /*!< Secure programming alignment error */
#define FLASH_SECSR_SIZERR_Pos              (6U)
#define FLASH_SECSR_SIZERR_Msk              (0x1UL << FLASH_SECSR_SIZERR_Pos)       /*!< 0x00000040 */
#define FLASH_SECSR_SIZERR                  FLASH_SECSR_SIZERR_Msk                  /*!< Secure size error */
#define FLASH_SECSR_PGSERR_Pos              (7U)
#define FLASH_SECSR_PGSERR_Msk              (0x1UL << FLASH_SECSR_PGSERR_Pos)       /*!< 0x00000080 */
#define FLASH_SECSR_PGSERR                  FLASH_SECSR_PGSERR_Msk                  /*!< Secure programming sequence error */
#define FLASH_SECSR_BSY_Pos                 (16U)
#define FLASH_SECSR_BSY_Msk                 (0x1UL << FLASH_SECSR_BSY_Pos)          /*!< 0x00010000 */
#define FLASH_SECSR_BSY                     FLASH_SECSR_BSY_Msk                     /*!< Secure busy */
#define FLASH_SECSR_WDW_Pos                 (17U)
#define FLASH_SECSR_WDW_Msk                 (0x1UL << FLASH_SECSR_WDW_Pos)          /*!< 0x00020000 */
#define FLASH_SECSR_WDW                     FLASH_SECSR_WDW_Msk                     /*!< Secure wait data to write */

/******************  Bits definition for FLASH_NSCR register  *****************/
#define FLASH_NSCR_PG_Pos                   (0U)
#define FLASH_NSCR_PG_Msk                   (0x1UL << FLASH_NSCR_PG_Pos)            /*!< 0x00000001 */
#define FLASH_NSCR_PG                       FLASH_NSCR_PG_Msk                       /*!< Non-secure Programming */
#define FLASH_NSCR_PER_Pos                  (1U)
#define FLASH_NSCR_PER_Msk                  (0x1UL << FLASH_NSCR_PER_Pos)           /*!< 0x00000002 */
#define FLASH_NSCR_PER                      FLASH_NSCR_PER_Msk                      /*!< Non-secure Page Erase */
#define FLASH_NSCR_MER1_Pos                 (2U)
#define FLASH_NSCR_MER1_Msk                 (0x1UL << FLASH_NSCR_MER1_Pos)          /*!< 0x00000004 */
#define FLASH_NSCR_MER1                     FLASH_NSCR_MER1_Msk                     /*!< Non-secure Bank 1 Mass Erase */
#define FLASH_NSCR_PNB_Pos                  (3U)
#define FLASH_NSCR_PNB_Msk                  (0xFFUL << FLASH_NSCR_PNB_Pos)          /*!< 0x000007F8 */
#define FLASH_NSCR_PNB                      FLASH_NSCR_PNB_Msk                      /*!< Non-secure Page Number selection */
#define FLASH_NSCR_BKER_Pos                 (11U)
#define FLASH_NSCR_BKER_Msk                 (0x1UL << FLASH_NSCR_BKER_Pos)          /*!< 0x00000800 */
#define FLASH_NSCR_BKER                     FLASH_NSCR_BKER_Msk                     /*!< Non-secure Bank Selection for Page Erase */
#define FLASH_NSCR_BWR_Pos                  (14U)
#define FLASH_NSCR_BWR_Msk                  (0x1UL << FLASH_NSCR_BWR_Pos)           /*!< 0x00004000 */
#define FLASH_NSCR_BWR                      FLASH_NSCR_BWR_Msk                      /*!< Non-secure Burst Write Programming mode */
#define FLASH_NSCR_MER2_Pos                 (15U)
#define FLASH_NSCR_MER2_Msk                 (0x1UL << FLASH_NSCR_MER2_Pos)          /*!< 0x00008000 */
#define FLASH_NSCR_MER2                     FLASH_NSCR_MER2_Msk                     /*!< Non-secure Bank 2 Mass Erase */
#define FLASH_NSCR_STRT_Pos                 (16U)
#define FLASH_NSCR_STRT_Msk                 (0x1UL << FLASH_NSCR_STRT_Pos)          /*!< 0x00010000 */
#define FLASH_NSCR_STRT                     FLASH_NSCR_STRT_Msk                     /*!< Non-secure Start */
#define FLASH_NSCR_OPTSTRT_Pos              (17U)
#define FLASH_NSCR_OPTSTRT_Msk              (0x1UL << FLASH_NSCR_OPTSTRT_Pos)       /*!< 0x00020000 */
#define FLASH_NSCR_OPTSTRT                  FLASH_NSCR_OPTSTRT_Msk                  /*!< Option Modification Start */
#define FLASH_NSCR_EOPIE_Pos                (24U)
#define FLASH_NSCR_EOPIE_Msk                (0x1UL << FLASH_NSCR_EOPIE_Pos)         /*!< 0x01000000 */
#define FLASH_NSCR_EOPIE                    FLASH_NSCR_EOPIE_Msk                    /*!< Non-secure End of operation interrupt enable */
#define FLASH_NSCR_ERRIE_Pos                (25U)
#define FLASH_NSCR_ERRIE_Msk                (0x1UL << FLASH_NSCR_ERRIE_Pos)         /*!< 0x02000000 */
#define FLASH_NSCR_ERRIE                    FLASH_NSCR_ERRIE_Msk                    /*!< Non-secure error interrupt enable */
#define FLASH_NSCR_OBL_LAUNCH_Pos           (27U)
#define FLASH_NSCR_OBL_LAUNCH_Msk           (0x1UL << FLASH_NSCR_OBL_LAUNCH_Pos)    /*!< 0x08000000 */
#define FLASH_NSCR_OBL_LAUNCH               FLASH_NSCR_OBL_LAUNCH_Msk               /*!< Force the option byte loading */
#define FLASH_NSCR_OPTLOCK_Pos              (30U)
#define FLASH_NSCR_OPTLOCK_Msk              (0x1UL << FLASH_NSCR_OPTLOCK_Pos)       /*!< 0x40000000 */
#define FLASH_NSCR_OPTLOCK                  FLASH_NSCR_OPTLOCK_Msk                  /*!< Option Lock */
#define FLASH_NSCR_LOCK_Pos                 (31U)
#define FLASH_NSCR_LOCK_Msk                 (0x1UL << FLASH_NSCR_LOCK_Pos)          /*!< 0x80000000 */
#define FLASH_NSCR_LOCK                     FLASH_NSCR_LOCK_Msk                     /*!< Non-secure Lock */

/******************  Bits definition for FLASH_SECCR register  ****************/
#define FLASH_SECCR_PG_Pos                  (0U)
#define FLASH_SECCR_PG_Msk                  (0x1UL << FLASH_SECCR_PG_Pos)           /*!< 0x00000001 */
#define FLASH_SECCR_PG                      FLASH_SECCR_PG_Msk                      /*!< Secure Programming */
#define FLASH_SECCR_PER_Pos                 (1U)
#define FLASH_SECCR_PER_Msk                 (0x1UL << FLASH_SECCR_PER_Pos)          /*!< 0x00000002 */
#define FLASH_SECCR_PER                     FLASH_SECCR_PER_Msk                     /*!< Secure Page Erase */
#define FLASH_SECCR_MER1_Pos                (2U)
#define FLASH_SECCR_MER1_Msk                (0x1UL << FLASH_SECCR_MER1_Pos)         /*!< 0x00000004 */
#define FLASH_SECCR_MER1                    FLASH_SECCR_MER1_Msk                    /*!< Secure Bank 1 Mass Erase */
#define FLASH_SECCR_PNB_Pos                 (3U)
#define FLASH_SECCR_PNB_Msk                 (0xFFUL << FLASH_SECCR_PNB_Pos)         /*!< 0x000007F8 */
#define FLASH_SECCR_PNB                     FLASH_SECCR_PNB_Msk                     /*!< Secure Page Number selection */
#define FLASH_SECCR_BKER_Pos                (11U)
#define FLASH_SECCR_BKER_Msk                (0x1UL << FLASH_SECCR_BKER_Pos)         /*!< 0x00000800 */
#define FLASH_SECCR_BKER                    FLASH_SECCR_BKER_Msk                    /*!< Secure Bank Selection for Page Erase */
#define FLASH_SECCR_BWR_Pos                 (14U)
#define FLASH_SECCR_BWR_Msk                 (0x1UL << FLASH_SECCR_BWR_Pos)          /*!< 0x00004000 */
#define FLASH_SECCR_BWR                     FLASH_SECCR_BWR_Msk                     /*!< Secure Burst Write programming mode */
#define FLASH_SECCR_MER2_Pos                (15U)
#define FLASH_SECCR_MER2_Msk                (0x1UL << FLASH_SECCR_MER2_Pos)         /*!< 0x00008000 */
#define FLASH_SECCR_MER2                    FLASH_SECCR_MER2_Msk                    /*!< Secure Bank 2 Mass Erase */
#define FLASH_SECCR_STRT_Pos                (16U)
#define FLASH_SECCR_STRT_Msk                (0x1UL << FLASH_SECCR_STRT_Pos)         /*!< 0x00010000 */
#define FLASH_SECCR_STRT                    FLASH_SECCR_STRT_Msk                    /*!< Secure Start */
#define FLASH_SECCR_EOPIE_Pos               (24U)
#define FLASH_SECCR_EOPIE_Msk               (0x1UL << FLASH_SECCR_EOPIE_Pos)        /*!< 0x01000000 */
#define FLASH_SECCR_EOPIE                   FLASH_SECCR_EOPIE_Msk                   /*!< Secure end of operation interrupt enable */
#define FLASH_SECCR_ERRIE_Pos               (25U)
#define FLASH_SECCR_ERRIE_Msk               (0x1UL << FLASH_SECCR_ERRIE_Pos)        /*!< 0x02000000 */
#define FLASH_SECCR_ERRIE                   FLASH_SECCR_ERRIE_Msk                   /*!< Secure error interrupt enable */
#define FLASH_SECCR_INV_Pos                 (29U)
#define FLASH_SECCR_INV_Msk                 (0x1UL << FLASH_SECCR_INV_Pos)          /*!< 0x20000000 */
#define FLASH_SECCR_INV                     FLASH_SECCR_INV_Msk                     /*!< Flash Security State Invert */
#define FLASH_SECCR_LOCK_Pos                (31U)
#define FLASH_SECCR_LOCK_Msk                (0x1UL << FLASH_SECCR_LOCK_Pos)         /*!< 0x80000000 */
#define FLASH_SECCR_LOCK                    FLASH_SECCR_LOCK_Msk                    /*!< Secure Lock */

/*******************  Bits definition for FLASH_ECCR register  ***************/
#define FLASH_ECCR_ADDR_ECC_Pos             (0U)
#define FLASH_ECCR_ADDR_ECC_Msk             (0x1FFFFFUL << FLASH_ECCR_ADDR_ECC_Pos) /*!< 0x001FFFFF */
#define FLASH_ECCR_ADDR_ECC                 FLASH_ECCR_ADDR_ECC_Msk                 /*!< ECC fail address */
#define FLASH_ECCR_BK_ECC_Pos               (21U)
#define FLASH_ECCR_BK_ECC_Msk               (0x1UL << FLASH_ECCR_BK_ECC_Pos)        /*!< 0x00200000 */
#define FLASH_ECCR_BK_ECC                   FLASH_ECCR_BK_ECC_Msk                   /*!< ECC fail bank */
#define FLASH_ECCR_SYSF_ECC_Pos             (22U)
#define FLASH_ECCR_SYSF_ECC_Msk             (0x1UL << FLASH_ECCR_SYSF_ECC_Pos)      /*!< 0x00400000 */
#define FLASH_ECCR_SYSF_ECC                 FLASH_ECCR_SYSF_ECC_Msk                 /*!< System Flash ECC fail */
#define FLASH_ECCR_ECCIE_Pos                (24U)
#define FLASH_ECCR_ECCIE_Msk                (0x1UL << FLASH_ECCR_ECCIE_Pos)         /*!< 0x01000000 */
#define FLASH_ECCR_ECCIE                    FLASH_ECCR_ECCIE_Msk                    /*!< ECC correction interrupt enable */
#define FLASH_ECCR_ECCC_Pos                 (30U)
#define FLASH_ECCR_ECCC_Msk                 (0x1UL << FLASH_ECCR_ECCC_Pos)          /*!< 0x40000000 */
#define FLASH_ECCR_ECCC                     FLASH_ECCR_ECCC_Msk                     /*!< ECC correction */
#define FLASH_ECCR_ECCD_Pos                 (31U)
#define FLASH_ECCR_ECCD_Msk                 (0x1UL << FLASH_ECCR_ECCD_Pos)          /*!< 0x80000000 */
#define FLASH_ECCR_ECCD                     FLASH_ECCR_ECCD_Msk                     /*!< ECC detection */

/*******************  Bits definition for FLASH_OPSR register  ***************/
#define FLASH_OPSR_ADDR_OP_Pos              (0U)
#define FLASH_OPSR_ADDR_OP_Msk              (0x1FFFFFUL << FLASH_OPSR_ADDR_OP_Pos)  /*!< 0x001FFFFF */
#define FLASH_OPSR_ADDR_OP                  FLASH_OPSR_ADDR_OP_Msk                  /*!< Flash operation address */
#define FLASH_OPSR_BK_OP_Pos                (21U)
#define FLASH_OPSR_BK_OP_Msk                (0x1UL << FLASH_OPSR_BK_OP_Pos)         /*!< 0x00200000 */
#define FLASH_OPSR_BK_OP                    FLASH_OPSR_BK_OP_Msk                    /*!< Interrupted operation bank */
#define FLASH_OPSR_SYSF_OP_Pos              (22U)
#define FLASH_OPSR_SYSF_OP_Msk              (0x1UL << FLASH_OPSR_SYSF_OP_Pos)       /*!< 0x00400000 */
#define FLASH_OPSR_SYSF_OP                  FLASH_OPSR_SYSF_OP_Msk                  /*!< Operation in System Flash interrupted */
#define FLASH_OPSR_CODE_OP_Pos              (29U)
#define FLASH_OPSR_CODE_OP_Msk              (0x7UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0xE0000000 */
#define FLASH_OPSR_CODE_OP                  FLASH_OPSR_CODE_OP_Msk                  /*!< Flash operation code */
#define FLASH_OPSR_CODE_OP_0                (0x1UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x20000000 */
#define FLASH_OPSR_CODE_OP_1                (0x2UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x40000000 */
#define FLASH_OPSR_CODE_OP_2                (0x4UL << FLASH_OPSR_CODE_OP_Pos)       /*!< 0x80000000 */

/*******************  Bits definition for FLASH_OPTR register  ***************/
#define FLASH_OPTR_RDP_Pos                  (0U)
#define FLASH_OPTR_RDP_Msk                  (0xFFUL << FLASH_OPTR_RDP_Pos)          /*!< 0x000000FF */
#define FLASH_OPTR_RDP                      FLASH_OPTR_RDP_Msk                      /*!< Readout protection level */
#define FLASH_OPTR_BOR_LEV_Pos              (8U)
#define FLASH_OPTR_BOR_LEV_Msk              (0x7UL << FLASH_OPTR_BOR_LEV_Pos)       /*!< 0x00000700 */
#define FLASH_OPTR_BOR_LEV                  FLASH_OPTR_BOR_LEV_Msk                  /*!< BOR reset Level */
#define FLASH_OPTR_BOR_LEV_0                (0x1UL << FLASH_OPTR_BOR_LEV_Pos)       /*!< 0x00000100 */
#define FLASH_OPTR_BOR_LEV_1                (0x2UL << FLASH_OPTR_BOR_LEV_Pos)       /*!< 0x00000200 */
#define FLASH_OPTR_BOR_LEV_2                (0x4UL << FLASH_OPTR_BOR_LEV_Pos)       /*!< 0x00000400 */
#define FLASH_OPTR_nRST_STOP_Pos            (12U)
#define FLASH_OPTR_nRST_STOP_Msk            (0x1UL << FLASH_OPTR_nRST_STOP_Pos)     /*!< 0x00001000 */
#define FLASH_OPTR_nRST_STOP                FLASH_OPTR_nRST_STOP_Msk                /*!< nRST_STOP */
#define FLASH_OPTR_nRST_STDBY_Pos           (13U)
#define FLASH_OPTR_nRST_STDBY_Msk           (0x1UL << FLASH_OPTR_nRST_STDBY_Pos)    /*!< 0x00002000 */
#define FLASH_OPTR_nRST_STDBY               FLASH_OPTR_nRST_STDBY_Msk               /*!< nRST_STDBY */
#define FLASH_OPTR_nRST_SHDW_Pos            (14U)
#define FLASH_OPTR_nRST_SHDW_Msk            (0x1UL << FLASH_OPTR_nRST_SHDW_Pos)     /*!< 0x00004000 */
#define FLASH_OPTR_nRST_SHDW                FLASH_OPTR_nRST_SHDW_Msk                /*!< nRST_SHDW */
#define FLASH_OPTR_SRAM_RST_Pos             (15U)
#define FLASH_OPTR_SRAM_RST_Msk             (0x1UL << FLASH_OPTR_SRAM_RST_Pos)      /*!< 0x00008000 */
#define FLASH_OPTR_SRAM_RST                 FLASH_OPTR_SRAM_RST_Msk                 /*!< All SRAMs (except SRAM2 and BKPSRAM) erase upon system reset */
#define FLASH_OPTR_IWDG_SW_Pos              (16U)
#define FLASH_OPTR_IWDG_SW_Msk              (0x1UL << FLASH_OPTR_IWDG_SW_Pos)       /*!< 0x00010000 */
#define FLASH_OPTR_IWDG_SW                  FLASH_OPTR_IWDG_SW_Msk                  /*!< Independent watchdog selection */
#define FLASH_OPTR_IWDG_STOP_Pos            (17U)
#define FLASH_OPTR_IWDG_STOP_Msk            (0x1UL << FLASH_OPTR_IWDG_STOP_Pos)     /*!< 0x00020000 */
#define FLASH_OPTR_IWDG_STOP                FLASH_OPTR_IWDG_STOP_Msk                /*!< Independent watchdog counter freeze in Stop mode */
#define FLASH_OPTR_IWDG_STDBY_Pos           (18U)
#define FLASH_OPTR_IWDG_STDBY_Msk           (0x1UL << FLASH_OPTR_IWDG_STDBY_Pos)    /*!< 0x00040000 */
#define FLASH_OPTR_IWDG_STDBY               FLASH_OPTR_IWDG_STDBY_Msk               /*!< Independent watchdog counter freeze in Standby mode */
#define FLASH_OPTR_WWDG_SW_Pos              (19U)
#define FLASH_OPTR_WWDG_SW_Msk              (0x1UL << FLASH_OPTR_WWDG_SW_Pos)       /*!< 0x00080000 */
#define FLASH_OPTR_WWDG_SW                  FLASH_OPTR_WWDG_SW_Msk                  /*!< Window watchdog selection */
#define FLASH_OPTR_SWAP_BANK_Pos            (20U)
#define FLASH_OPTR_SWAP_BANK_Msk            (0x1UL << FLASH_OPTR_SWAP_BANK_Pos)     /*!< 0x00100000 */
#define FLASH_OPTR_SWAP_BANK                FLASH_OPTR_SWAP_BANK_Msk                /*!< Swap banks */
#define FLASH_OPTR_DUALBANK_Pos             (21U)
#define FLASH_OPTR_DUALBANK_Msk             (0x1UL << FLASH_OPTR_DUALBANK_Pos)      /*!< 0x00200000 */
#define FLASH_OPTR_DUALBANK                 FLASH_OPTR_DUALBANK_Msk                 /*!< Dual-bank on 1M and 512 Kbytes Flash memory devices */
#define FLASH_OPTR_BKPRAM_ECC_Pos           (22U)
#define FLASH_OPTR_BKPRAM_ECC_Msk           (0x1UL << FLASH_OPTR_BKPRAM_ECC_Pos)    /*!< 0x00400000 */
#define FLASH_OPTR_BKPRAM_ECC               FLASH_OPTR_BKPRAM_ECC_Msk               /*!< Backup RAM ECC detection and correction enable */
#define FLASH_OPTR_SRAM3_ECC_Pos            (23U)
#define FLASH_OPTR_SRAM3_ECC_Msk            (0x1UL << FLASH_OPTR_SRAM3_ECC_Pos)     /*!< 0x00800000 */
#define FLASH_OPTR_SRAM3_ECC                FLASH_OPTR_SRAM3_ECC_Msk                /*!< SRAM3 ECC detection and correction enable */
#define FLASH_OPTR_SRAM2_ECC_Pos            (24U)
#define FLASH_OPTR_SRAM2_ECC_Msk            (0x1UL << FLASH_OPTR_SRAM2_ECC_Pos)     /*!< 0x01000000 */
#define FLASH_OPTR_SRAM2_ECC                FLASH_OPTR_SRAM2_ECC_Msk                /*!< SRAM2 ECC detection and correction enable*/
#define FLASH_OPTR_SRAM2_RST_Pos            (25U)
#define FLASH_OPTR_SRAM2_RST_Msk            (0x1UL << FLASH_OPTR_SRAM2_RST_Pos)     /*!< 0x02000000 */
#define FLASH_OPTR_SRAM2_RST                FLASH_OPTR_SRAM2_RST_Msk                /*!< SRAM2 erase when system reset */
#define FLASH_OPTR_nSWBOOT0_Pos             (26U)
#define FLASH_OPTR_nSWBOOT0_Msk             (0x1UL << FLASH_OPTR_nSWBOOT0_Pos)      /*!< 0x04000000 */
#define FLASH_OPTR_nSWBOOT0                 FLASH_OPTR_nSWBOOT0_Msk                 /*!< Software BOOT0 */
#define FLASH_OPTR_nBOOT0_Pos               (27U)
#define FLASH_OPTR_nBOOT0_Msk               (0x1UL << FLASH_OPTR_nBOOT0_Pos)        /*!< 0x08000000 */
#define FLASH_OPTR_nBOOT0                   FLASH_OPTR_nBOOT0_Msk                   /*!< nBOOT0 option bit */
#define FLASH_OPTR_PA15_PUPEN_Pos           (28U)
#define FLASH_OPTR_PA15_PUPEN_Msk           (0x1UL << FLASH_OPTR_PA15_PUPEN_Pos)    /*!< 0x10000000 */
#define FLASH_OPTR_PA15_PUPEN               FLASH_OPTR_PA15_PUPEN_Msk               /*!< PA15 pull-up enable */
#define FLASH_OPTR_IO_VDD_HSLV_Pos          (29U)
#define FLASH_OPTR_IO_VDD_HSLV_Msk          (0x1UL << FLASH_OPTR_IO_VDD_HSLV_Pos)   /*!< 0x20000000 */
#define FLASH_OPTR_IO_VDD_HSLV              FLASH_OPTR_IO_VDD_HSLV_Msk              /*!< High speed IO at low voltage configuration bit */
#define FLASH_OPTR_IO_VDDIO2_HSLV_Pos       (30U)
#define FLASH_OPTR_IO_VDDIO2_HSLV_Msk       (0x1UL << FLASH_OPTR_IO_VDDIO2_HSLV_Pos) /*!< 0x40000000 */
#define FLASH_OPTR_IO_VDDIO2_HSLV           FLASH_OPTR_IO_VDDIO2_HSLV_Msk           /*!< High speed IO at low VDDIO2 voltage configuration bit */
#define FLASH_OPTR_TZEN_Pos                 (31U)
#define FLASH_OPTR_TZEN_Msk                 (0x1UL << FLASH_OPTR_TZEN_Pos)          /*!< 0x80000000 */
#define FLASH_OPTR_TZEN                     FLASH_OPTR_TZEN_Msk                     /*!< Global TrustZone security enable */

/****************  Bits definition for FLASH_NSBOOTADD0R register  ************/
#define FLASH_NSBOOTADD0R_NSBOOTADD0_Pos    (7U)
#define FLASH_NSBOOTADD0R_NSBOOTADD0_Msk    (0x1FFFFFFUL << FLASH_NSBOOTADD0R_NSBOOTADD0_Pos) /*!< 0xFFFFFF80 */
#define FLASH_NSBOOTADD0R_NSBOOTADD0        FLASH_NSBOOTADD0R_NSBOOTADD0_Msk        /*!< Non-secure boot address 0 */

/****************  Bits definition for FLASH_NSBOOTADD1R register  ************/
#define FLASH_NSBOOTADD1R_NSBOOTADD1_Pos    (7U)
#define FLASH_NSBOOTADD1R_NSBOOTADD1_Msk    (0x1FFFFFFUL << FLASH_NSBOOTADD1R_NSBOOTADD1_Pos) /*!< 0xFFFFFF80 */
#define FLASH_NSBOOTADD1R_NSBOOTADD1        FLASH_NSBOOTADD1R_NSBOOTADD1_Msk        /*!< Non-secure boot address 1 */

/****************  Bits definition for FLASH_SECBOOTADD0R register  ***********/
#define FLASH_SECBOOTADD0R_BOOT_LOCK_Pos    (0U)
#define FLASH_SECBOOTADD0R_BOOT_LOCK_Msk    (0x1UL << FLASH_SECBOOTADD0R_BOOT_LOCK_Pos) /*!< 0x00000001 */
#define FLASH_SECBOOTADD0R_BOOT_LOCK        FLASH_SECBOOTADD0R_BOOT_LOCK_Msk        /*!< Boot Lock */
#define FLASH_SECBOOTADD0R_SECBOOTADD0_Pos  (7U)
#define FLASH_SECBOOTADD0R_SECBOOTADD0_Msk  (0x1FFFFFFUL << FLASH_SECBOOTADD0R_SECBOOTADD0_Pos) /*!< 0xFFFFFF80 */
#define FLASH_SECBOOTADD0R_SECBOOTADD0      FLASH_SECBOOTADD0R_SECBOOTADD0_Msk      /*!< Secure boot address 0 */

/*****************  Bits definition for FLASH_SECWM1R1 register  **************/
#define FLASH_SECWM1R1_SECWM1_PSTRT_Pos     (0U)
#define FLASH_SECWM1R1_SECWM1_PSTRT_Msk     (0xFFUL << FLASH_SECWM1R1_SECWM1_PSTRT_Pos) /*!< 0x000000FF */
#define FLASH_SECWM1R1_SECWM1_PSTRT         FLASH_SECWM1R1_SECWM1_PSTRT_Msk         /*!< Start page of first secure area */
#define FLASH_SECWM1R1_SECWM1_PEND_Pos      (16U)
#define FLASH_SECWM1R1_SECWM1_PEND_Msk      (0xFFUL << FLASH_SECWM1R1_SECWM1_PEND_Pos) /*!< 0x00FF0000 */
#define FLASH_SECWM1R1_SECWM1_PEND          FLASH_SECWM1R1_SECWM1_PEND_Msk          /*!< End page of first secure area */

/*****************  Bits definition for FLASH_SECWM1R2 register  **************/
#define FLASH_SECWM1R2_HDP1_PEND_Pos        (16U)
#define FLASH_SECWM1R2_HDP1_PEND_Msk        (0xFFUL << FLASH_SECWM1R2_HDP1_PEND_Pos) /*!< 0x00FF0000 */
#define FLASH_SECWM1R2_HDP1_PEND            FLASH_SECWM1R2_HDP1_PEND_Msk            /*!< End page of first hide protection area */
#define FLASH_SECWM1R2_HDP1EN_Pos           (31U)
#define FLASH_SECWM1R2_HDP1EN_Msk           (0x1UL << FLASH_SECWM1R2_HDP1EN_Pos)    /*!< 0x80000000 */
#define FLASH_SECWM1R2_HDP1EN               FLASH_SECWM1R2_HDP1EN_Msk               /*!< Hide protection first area enable */

/******************  Bits definition for FLASH_WRP1AR register  ***************/
#define FLASH_WRP1AR_WRP1A_PSTRT_Pos        (0U)
#define FLASH_WRP1AR_WRP1A_PSTRT_Msk        (0xFFUL << FLASH_WRP1AR_WRP1A_PSTRT_Pos) /*!< 0x000000FF */
#define FLASH_WRP1AR_WRP1A_PSTRT            FLASH_WRP1AR_WRP1A_PSTRT_Msk            /*!< Bank 1 WPR first area A start page */
#define FLASH_WRP1AR_WRP1A_PEND_Pos         (16U)
#define FLASH_WRP1AR_WRP1A_PEND_Msk         (0xFFUL << FLASH_WRP1AR_WRP1A_PEND_Pos) /*!< 0x00FF0000 */
#define FLASH_WRP1AR_WRP1A_PEND             FLASH_WRP1AR_WRP1A_PEND_Msk             /*!< Bank 1 WPR first area A end page */
#define FLASH_WRP1AR_UNLOCK_Pos             (31U)
#define FLASH_WRP1AR_UNLOCK_Msk             (0x1UL << FLASH_WRP1AR_UNLOCK_Pos)      /*!< 0x80000000 */
#define FLASH_WRP1AR_UNLOCK                 FLASH_WRP1AR_UNLOCK_Msk                 /*!< Bank 1 WPR first area A unlock */

/******************  Bits definition for FLASH_WRP1BR register  ***************/
#define FLASH_WRP1BR_WRP1B_PSTRT_Pos        (0U)
#define FLASH_WRP1BR_WRP1B_PSTRT_Msk        (0xFFUL << FLASH_WRP1BR_WRP1B_PSTRT_Pos) /*!< 0x000000FF */
#define FLASH_WRP1BR_WRP1B_PSTRT            FLASH_WRP1BR_WRP1B_PSTRT_Msk            /*!< Bank 1 WPR second area B start page */
#define FLASH_WRP1BR_WRP1B_PEND_Pos         (16U)
#define FLASH_WRP1BR_WRP1B_PEND_Msk         (0xFFUL << FLASH_WRP1BR_WRP1B_PEND_Pos) /*!< 0x00FF0000 */
#define FLASH_WRP1BR_WRP1B_PEND             FLASH_WRP1BR_WRP1B_PEND_Msk             /*!< Bank 1 WPR second area B end page */
#define FLASH_WRP1BR_UNLOCK_Pos             (31U)
#define FLASH_WRP1BR_UNLOCK_Msk             (0x1UL << FLASH_WRP1BR_UNLOCK_Pos)      /*!< 0x80000000 */
#define FLASH_WRP1BR_UNLOCK                 FLASH_WRP1BR_UNLOCK_Msk                 /*!< Bank 1 WPR first area B unlock */

/*****************  Bits definition for FLASH_SECWM2R1 register  **************/
#define FLASH_SECWM2R1_SECWM2_PSTRT_Pos     (0U)
#define FLASH_SECWM2R1_SECWM2_PSTRT_Msk     (0xFFUL << FLASH_SECWM2R1_SECWM2_PSTRT_Pos) /*!< 0x000000FF */
#define FLASH_SECWM2R1_SECWM2_PSTRT         FLASH_SECWM2R1_SECWM2_PSTRT_Msk         /*!< Start page of second secure area */
#define FLASH_SECWM2R1_SECWM2_PEND_Pos      (16U)
#define FLASH_SECWM2R1_SECWM2_PEND_Msk      (0xFFUL << FLASH_SECWM2R1_SECWM2_PEND_Pos) /*!< 0x00FF0000 */
#define FLASH_SECWM2R1_SECWM2_PEND          FLASH_SECWM2R1_SECWM2_PEND_Msk          /*!< End page of second secure area */

/*****************  Bits definition for FLASH_SECWM2R2 register  **************/
#define FLASH_SECWM2R2_HDP2_PEND_Pos        (16U)
#define FLASH_SECWM2R2_HDP2_PEND_Msk        (0xFFUL << FLASH_SECWM2R2_HDP2_PEND_Pos) /*!< 0x00FF0000 */
#define FLASH_SECWM2R2_HDP2_PEND            FLASH_SECWM2R2_HDP2_PEND_Msk            /*!< End page of hide protection second area */
#define FLASH_SECWM2R2_HDP2EN_Pos           (31U)
#define FLASH_SECWM2R2_HDP2EN_Msk           (0x1UL << FLASH_SECWM2R2_HDP2EN_Pos)    /*!< 0x80000000 */
#define FLASH_SECWM2R2_HDP2EN               FLASH_SECWM2R2_HDP2EN_Msk               /*!< Hide protection second area enable */

/******************  Bits definition for FLASH_WRP2AR register  ***************/
#define FLASH_WRP2AR_WRP2A_PSTRT_Pos        (0U)
#define FLASH_WRP2AR_WRP2A_PSTRT_Msk        (0xFFUL << FLASH_WRP2AR_WRP2A_PSTRT_Pos) /*!< 0x000000FF */
#define FLASH_WRP2AR_WRP2A_PSTRT            FLASH_WRP2AR_WRP2A_PSTRT_Msk            /*!< Bank 2 WPR first area A start page */
#define FLASH_WRP2AR_WRP2A_PEND_Pos         (16U)
#define FLASH_WRP2AR_WRP2A_PEND_Msk         (0xFFUL << FLASH_WRP2AR_WRP2A_PEND_Pos) /*!< 0x00FF0000 */
#define FLASH_WRP2AR_WRP2A_PEND             FLASH_WRP2AR_WRP2A_PEND_Msk             /*!< Bank 2 WPR first area A end page */
#define FLASH_WRP2AR_UNLOCK_Pos             (31U)
#define FLASH_WRP2AR_UNLOCK_Msk             (0x1UL << FLASH_WRP2AR_UNLOCK_Pos)      /*!< 0x80000000 */
#define FLASH_WRP2AR_UNLOCK                 FLASH_WRP2AR_UNLOCK_Msk                 /*!< Bank 2 WPR first area A unlock */

/******************  Bits definition for FLASH_WRP2BR register  ***************/
#define FLASH_WRP2BR_WRP2B_PSTRT_Pos        (0U)
#define FLASH_WRP2BR_WRP2B_PSTRT_Msk        (0xFFUL << FLASH_WRP2BR_WRP2B_PSTRT_Pos) /*!< 0x000000FF */
#define FLASH_WRP2BR_WRP2B_PSTRT            FLASH_WRP2BR_WRP2B_PSTRT_Msk            /*!< Bank 2 WPR first area B start page */
#define FLASH_WRP2BR_WRP2B_PEND_Pos         (16U)
#define FLASH_WRP2BR_WRP2B_PEND_Msk         (0xFFUL << FLASH_WRP2BR_WRP2B_PEND_Pos) /*!< 0x00FF0000 */
#define FLASH_WRP2BR_WRP2B_PEND             FLASH_WRP2BR_WRP2B_PEND_Msk             /*!< Bank 2 WPR first area B end page */
#define FLASH_WRP2BR_UNLOCK_Pos             (31U)
#define FLASH_WRP2BR_UNLOCK_Msk             (0x1UL << FLASH_WRP2BR_UNLOCK_Pos)      /*!< 0x80000000 */
#define FLASH_WRP2BR_UNLOCK                 FLASH_WRP2BR_UNLOCK_Msk                 /*!< Bank 2 WPR first area B unlock */

/******************  Bits definition for FLASH_SECHDPCR register  ***********/
#define FLASH_SECHDPCR_HDP1_ACCDIS_Pos      (0U)
#define FLASH_SECHDPCR_HDP1_ACCDIS_Msk      (0x1UL << FLASH_SECHDPCR_HDP1_ACCDIS_Pos) /*!< 0x00000001 */
#define FLASH_SECHDPCR_HDP1_ACCDIS          FLASH_SECHDPCR_HDP1_ACCDIS_Msk          /*!< HDP1 area access disable */
#define FLASH_SECHDPCR_HDP2_ACCDIS_Pos      (1U)
#define FLASH_SECHDPCR_HDP2_ACCDIS_Msk      (0x1UL << FLASH_SECHDPCR_HDP2_ACCDIS_Pos) /*!< 0x00000002 */
#define FLASH_SECHDPCR_HDP2_ACCDIS          FLASH_SECHDPCR_HDP2_ACCDIS_Msk          /*!< HDP2 area access disable */

/******************  Bits definition for FLASH_PRIVCFGR register  ***********/
#define FLASH_PRIVCFGR_SPRIV_Pos            (0U)
#define FLASH_PRIVCFGR_SPRIV_Msk            (0x1UL << FLASH_PRIVCFGR_SPRIV_Pos)     /*!< 0x00000001 */
#define FLASH_PRIVCFGR_SPRIV                FLASH_PRIVCFGR_SPRIV_Msk                /*!< Privilege protection for secure registers */
#define FLASH_PRIVCFGR_NSPRIV_Pos           (1U)
#define FLASH_PRIVCFGR_NSPRIV_Msk           (0x1UL << FLASH_PRIVCFGR_NSPRIV_Pos)    /*!< 0x00000002 */
#define FLASH_PRIVCFGR_NSPRIV               FLASH_PRIVCFGR_NSPRIV_Msk               /*!< Privilege protection for non-secure registers */

/******************************************************************************/
/*                                                                            */
/*                Filter Mathematical ACcelerator unit (FMAC)                 */
/*                                                                            */
/******************************************************************************/
/*****************  Bit definition for FMAC_X1BUFCFG register  ****************/
#define FMAC_X1BUFCFG_X1_BASE_Pos           (0U)
#define FMAC_X1BUFCFG_X1_BASE_Msk           (0xFFUL << FMAC_X1BUFCFG_X1_BASE_Pos)   /*!< 0x000000FF */
#define FMAC_X1BUFCFG_X1_BASE               FMAC_X1BUFCFG_X1_BASE_Msk               /*!< Base address of X1 buffer */
#define FMAC_X1BUFCFG_X1_BUF_SIZE_Pos       (8U)
#define FMAC_X1BUFCFG_X1_BUF_SIZE_Msk       (0xFFUL << FMAC_X1BUFCFG_X1_BUF_SIZE_Pos) /*!< 0x0000FF00 */
#define FMAC_X1BUFCFG_X1_BUF_SIZE           FMAC_X1BUFCFG_X1_BUF_SIZE_Msk           /*!< Allocated size of X1 buffer in 16-bit words */
#define FMAC_X1BUFCFG_FULL_WM_Pos           (24U)
#define FMAC_X1BUFCFG_FULL_WM_Msk           (0x3UL << FMAC_X1BUFCFG_FULL_WM_Pos)    /*!< 0x03000000 */
#define FMAC_X1BUFCFG_FULL_WM               FMAC_X1BUFCFG_FULL_WM_Msk               /*!< Watermark for buffer full flag */

/*****************  Bit definition for FMAC_X2BUFCFG register  ****************/
#define FMAC_X2BUFCFG_X2_BASE_Pos           (0U)
#define FMAC_X2BUFCFG_X2_BASE_Msk           (0xFFUL << FMAC_X2BUFCFG_X2_BASE_Pos)   /*!< 0x000000FF */
#define FMAC_X2BUFCFG_X2_BASE               FMAC_X2BUFCFG_X2_BASE_Msk               /*!< Base address of X2 buffer */
#define FMAC_X2BUFCFG_X2_BUF_SIZE_Pos       (8U)
#define FMAC_X2BUFCFG_X2_BUF_SIZE_Msk       (0xFFUL << FMAC_X2BUFCFG_X2_BUF_SIZE_Pos) /*!< 0x0000FF00 */
#define FMAC_X2BUFCFG_X2_BUF_SIZE           FMAC_X2BUFCFG_X2_BUF_SIZE_Msk           /*!< Size of X2 buffer in 16-bit words */

/*****************  Bit definition for FMAC_YBUFCFG register  *****************/
#define FMAC_YBUFCFG_Y_BASE_Pos             (0U)
#define FMAC_YBUFCFG_Y_BASE_Msk             (0xFFUL << FMAC_YBUFCFG_Y_BASE_Pos)     /*!< 0x000000FF */
#define FMAC_YBUFCFG_Y_BASE                 FMAC_YBUFCFG_Y_BASE_Msk                 /*!< Base address of Y buffer */
#define FMAC_YBUFCFG_Y_BUF_SIZE_Pos         (8U)
#define FMAC_YBUFCFG_Y_BUF_SIZE_Msk         (0xFFUL << FMAC_YBUFCFG_Y_BUF_SIZE_Pos) /*!< 0x0000FF00 */
#define FMAC_YBUFCFG_Y_BUF_SIZE             FMAC_YBUFCFG_Y_BUF_SIZE_Msk             /*!< Size of Y buffer in 16-bit words */
#define FMAC_YBUFCFG_EMPTY_WM_Pos           (24U)
#define FMAC_YBUFCFG_EMPTY_WM_Msk           (0x3UL << FMAC_YBUFCFG_EMPTY_WM_Pos)    /*!< 0x03000000 */
#define FMAC_YBUFCFG_EMPTY_WM               FMAC_YBUFCFG_EMPTY_WM_Msk               /*!< Watermark for buffer empty flag */

/******************  Bit definition for FMAC_PARAM register  ******************/
#define FMAC_PARAM_P_Pos                    (0U)
#define FMAC_PARAM_P_Msk                    (0xFFUL << FMAC_PARAM_P_Pos)            /*!< 0x000000FF */
#define FMAC_PARAM_P                        FMAC_PARAM_P_Msk                        /*!< Input parameter P */
#define FMAC_PARAM_Q_Pos                    (8U)
#define FMAC_PARAM_Q_Msk                    (0xFFUL << FMAC_PARAM_Q_Pos)            /*!< 0x0000FF00 */
#define FMAC_PARAM_Q                        FMAC_PARAM_Q_Msk                        /*!< Input parameter Q */
#define FMAC_PARAM_R_Pos                    (16U)
#define FMAC_PARAM_R_Msk                    (0xFFUL << FMAC_PARAM_R_Pos)            /*!< 0x00FF0000 */
#define FMAC_PARAM_R                        FMAC_PARAM_R_Msk                        /*!< Input parameter R */
#define FMAC_PARAM_FUNC_Pos                 (24U)
#define FMAC_PARAM_FUNC_Msk                 (0x7FUL << FMAC_PARAM_FUNC_Pos)         /*!< 0x7F000000 */
#define FMAC_PARAM_FUNC                     FMAC_PARAM_FUNC_Msk                     /*!< Function */
#define FMAC_PARAM_FUNC_0                   (0x1UL << FMAC_PARAM_FUNC_Pos)          /*!< 0x01000000 */
#define FMAC_PARAM_FUNC_1                   (0x2UL << FMAC_PARAM_FUNC_Pos)          /*!< 0x02000000 */
#define FMAC_PARAM_FUNC_2                   (0x4UL << FMAC_PARAM_FUNC_Pos)          /*!< 0x04000000 */
#define FMAC_PARAM_FUNC_3                   (0x8UL << FMAC_PARAM_FUNC_Pos)          /*!< 0x08000000 */
#define FMAC_PARAM_FUNC_4                   (0x10UL << FMAC_PARAM_FUNC_Pos)         /*!< 0x10000000 */
#define FMAC_PARAM_FUNC_5                   (0x20UL << FMAC_PARAM_FUNC_Pos)         /*!< 0x20000000 */
#define FMAC_PARAM_FUNC_6                   (0x40UL << FMAC_PARAM_FUNC_Pos)         /*!< 0x40000000 */
#define FMAC_PARAM_START_Pos                (31U)
#define FMAC_PARAM_START_Msk                (0x1UL << FMAC_PARAM_START_Pos)         /*!< 0x80000000 */
#define FMAC_PARAM_START                    FMAC_PARAM_START_Msk                    /*!< Enable execution */

/********************  Bit definition for FMAC_CR register  *******************/
#define FMAC_CR_RIEN_Pos                    (0U)
#define FMAC_CR_RIEN_Msk                    (0x1UL << FMAC_CR_RIEN_Pos)             /*!< 0x00000001 */
#define FMAC_CR_RIEN                        FMAC_CR_RIEN_Msk                        /*!< Enable read interrupt */
#define FMAC_CR_WIEN_Pos                    (1U)
#define FMAC_CR_WIEN_Msk                    (0x1UL << FMAC_CR_WIEN_Pos)             /*!< 0x00000002 */
#define FMAC_CR_WIEN                        FMAC_CR_WIEN_Msk                        /*!< Enable write interrupt */
#define FMAC_CR_OVFLIEN_Pos                 (2U)
#define FMAC_CR_OVFLIEN_Msk                 (0x1UL << FMAC_CR_OVFLIEN_Pos)          /*!< 0x00000004 */
#define FMAC_CR_OVFLIEN                     FMAC_CR_OVFLIEN_Msk                     /*!< Enable overflow error interrupts */
#define FMAC_CR_UNFLIEN_Pos                 (3U)
#define FMAC_CR_UNFLIEN_Msk                 (0x1UL << FMAC_CR_UNFLIEN_Pos)          /*!< 0x00000008 */
#define FMAC_CR_UNFLIEN                     FMAC_CR_UNFLIEN_Msk                     /*!< Enable underflow error interrupts */
#define FMAC_CR_SATIEN_Pos                  (4U)
#define FMAC_CR_SATIEN_Msk                  (0x1UL << FMAC_CR_SATIEN_Pos)           /*!< 0x00000010 */
#define FMAC_CR_SATIEN                      FMAC_CR_SATIEN_Msk                      /*!< Enable saturation error interrupts */
#define FMAC_CR_DMAREN_Pos                  (8U)
#define FMAC_CR_DMAREN_Msk                  (0x1UL << FMAC_CR_DMAREN_Pos)           /*!< 0x00000100 */
#define FMAC_CR_DMAREN                      FMAC_CR_DMAREN_Msk                      /*!< Enable DMA read channel requests */
#define FMAC_CR_DMAWEN_Pos                  (9U)
#define FMAC_CR_DMAWEN_Msk                  (0x1UL << FMAC_CR_DMAWEN_Pos)           /*!< 0x00000200 */
#define FMAC_CR_DMAWEN                      FMAC_CR_DMAWEN_Msk                      /*!< Enable DMA write channel requests */
#define FMAC_CR_CLIPEN_Pos                  (15U)
#define FMAC_CR_CLIPEN_Msk                  (0x1UL << FMAC_CR_CLIPEN_Pos)           /*!< 0x00008000 */
#define FMAC_CR_CLIPEN                      FMAC_CR_CLIPEN_Msk                      /*!< Enable clipping */
#define FMAC_CR_RESET_Pos                   (16U)
#define FMAC_CR_RESET_Msk                   (0x1UL << FMAC_CR_RESET_Pos)            /*!< 0x00010000 */
#define FMAC_CR_RESET                       FMAC_CR_RESET_Msk                       /*!< Reset filter mathematical accelerator unit */

/*******************  Bit definition for FMAC_SR register  ********************/
#define FMAC_SR_YEMPTY_Pos                  (0U)
#define FMAC_SR_YEMPTY_Msk                  (0x1UL << FMAC_SR_YEMPTY_Pos)           /*!< 0x00000001 */
#define FMAC_SR_YEMPTY                      FMAC_SR_YEMPTY_Msk                      /*!< Y buffer empty flag */
#define FMAC_SR_X1FULL_Pos                  (1U)
#define FMAC_SR_X1FULL_Msk                  (0x1UL << FMAC_SR_X1FULL_Pos)           /*!< 0x00000002 */
#define FMAC_SR_X1FULL                      FMAC_SR_X1FULL_Msk                      /*!< X1 buffer full flag */
#define FMAC_SR_OVFL_Pos                    (8U)
#define FMAC_SR_OVFL_Msk                    (0x1UL << FMAC_SR_OVFL_Pos)             /*!< 0x00000100 */
#define FMAC_SR_OVFL                        FMAC_SR_OVFL_Msk                        /*!< Overflow error flag */
#define FMAC_SR_UNFL_Pos                    (9U)
#define FMAC_SR_UNFL_Msk                    (0x1UL << FMAC_SR_UNFL_Pos)             /*!< 0x00000200 */
#define FMAC_SR_UNFL                        FMAC_SR_UNFL_Msk                        /*!< Underflow error flag */
#define FMAC_SR_SAT_Pos                     (10U)
#define FMAC_SR_SAT_Msk                     (0x1UL << FMAC_SR_SAT_Pos)              /*!< 0x00000400 */
#define FMAC_SR_SAT                         FMAC_SR_SAT_Msk                         /*!< Saturation error flag */

/******************  Bit definition for FMAC_WDATA register  ******************/
#define FMAC_WDATA_WDATA_Pos                (0U)
#define FMAC_WDATA_WDATA_Msk                (0xFFFFUL << FMAC_WDATA_WDATA_Pos)      /*!< 0x0000FFFF */
#define FMAC_WDATA_WDATA                    FMAC_WDATA_WDATA_Msk                    /*!< Write data */

/******************  Bit definition for FMACX_RDATA register  *****************/
#define FMAC_RDATA_RDATA_Pos                (0U)
#define FMAC_RDATA_RDATA_Msk                (0xFFFFUL << FMAC_RDATA_RDATA_Pos)      /*!< 0x0000FFFF */
#define FMAC_RDATA_RDATA                    FMAC_RDATA_RDATA_Msk                    /*!< Read data */

/******************************************************************************/
/*                                                                            */
/*                          Flexible Memory Controller                        */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for FMC_BCR1 register  *******************/
#define FMC_BCR1_CCLKEN_Pos                 (20U)
#define FMC_BCR1_CCLKEN_Msk                 (0x1UL << FMC_BCR1_CCLKEN_Pos)          /*!< 0x00100000 */
#define FMC_BCR1_CCLKEN                     FMC_BCR1_CCLKEN_Msk                     /*!<Continuous clock enable     */
#define FMC_BCR1_WFDIS_Pos                  (21U)
#define FMC_BCR1_WFDIS_Msk                  (0x1UL << FMC_BCR1_WFDIS_Pos)           /*!< 0x00200000 */
#define FMC_BCR1_WFDIS                      FMC_BCR1_WFDIS_Msk                      /*!<Write FIFO Disable         */
#define FMC_BCR1_FMCEN_Pos                  (31U)
#define FMC_BCR1_FMCEN_Msk                  (0x1UL << FMC_BCR1_FMCEN_Pos)           /*!< 0x80000000 */
#define FMC_BCR1_FMCEN                      FMC_BCR1_FMCEN_Msk                      /*!<FMC controller Enable */

/******************  Bit definition for FMC_BCRx registers (x=1..4)  *********/
#define FMC_BCRx_MBKEN_Pos                  (0U)
#define FMC_BCRx_MBKEN_Msk                  (0x1UL << FMC_BCRx_MBKEN_Pos)           /*!< 0x00000001 */
#define FMC_BCRx_MBKEN                      FMC_BCRx_MBKEN_Msk                      /*!<Memory bank enable bit                 */
#define FMC_BCRx_MUXEN_Pos                  (1U)
#define FMC_BCRx_MUXEN_Msk                  (0x1UL << FMC_BCRx_MUXEN_Pos)           /*!< 0x00000002 */
#define FMC_BCRx_MUXEN                      FMC_BCRx_MUXEN_Msk                      /*!<Address/data multiplexing enable bit   */
#define FMC_BCRx_MTYP_Pos                   (2U)
#define FMC_BCRx_MTYP_Msk                   (0x3UL << FMC_BCRx_MTYP_Pos)            /*!< 0x0000000C */
#define FMC_BCRx_MTYP                       FMC_BCRx_MTYP_Msk                       /*!<MTYP[1:0] bits (Memory type)           */
#define FMC_BCRx_MTYP_0                     (0x1UL << FMC_BCRx_MTYP_Pos)            /*!< 0x00000004 */
#define FMC_BCRx_MTYP_1                     (0x2UL << FMC_BCRx_MTYP_Pos)            /*!< 0x00000008 */
#define FMC_BCRx_MWID_Pos                   (4U)
#define FMC_BCRx_MWID_Msk                   (0x3UL << FMC_BCRx_MWID_Pos)            /*!< 0x00000030 */
#define FMC_BCRx_MWID                       FMC_BCRx_MWID_Msk                       /*!<MWID[1:0] bits (Memory data bus width) */
#define FMC_BCRx_MWID_0                     (0x1UL << FMC_BCRx_MWID_Pos)            /*!< 0x00000010 */
#define FMC_BCRx_MWID_1                     (0x2UL << FMC_BCRx_MWID_Pos)            /*!< 0x00000020 */
#define FMC_BCRx_FACCEN_Pos                 (6U)
#define FMC_BCRx_FACCEN_Msk                 (0x1UL << FMC_BCRx_FACCEN_Pos)          /*!< 0x00000040 */
#define FMC_BCRx_FACCEN                     FMC_BCRx_FACCEN_Msk                     /*!<Flash access enable        */
#define FMC_BCRx_BURSTEN_Pos                (8U)
#define FMC_BCRx_BURSTEN_Msk                (0x1UL << FMC_BCRx_BURSTEN_Pos)         /*!< 0x00000100 */
#define FMC_BCRx_BURSTEN                    FMC_BCRx_BURSTEN_Msk                    /*!<Burst enable bit           */
#define FMC_BCRx_WAITPOL_Pos                (9U)
#define FMC_BCRx_WAITPOL_Msk                (0x1UL << FMC_BCRx_WAITPOL_Pos)         /*!< 0x00000200 */
#define FMC_BCRx_WAITPOL                    FMC_BCRx_WAITPOL_Msk                    /*!<Wait signal polarity bit   */
#define FMC_BCRx_WAITCFG_Pos                (11U)
#define FMC_BCRx_WAITCFG_Msk                (0x1UL << FMC_BCRx_WAITCFG_Pos)         /*!< 0x00000800 */
#define FMC_BCRx_WAITCFG                    FMC_BCRx_WAITCFG_Msk                    /*!<Wait timing configuration  */
#define FMC_BCRx_WREN_Pos                   (12U)
#define FMC_BCRx_WREN_Msk                   (0x1UL << FMC_BCRx_WREN_Pos)            /*!< 0x00001000 */
#define FMC_BCRx_WREN                       FMC_BCRx_WREN_Msk                       /*!<Write enable bit           */
#define FMC_BCRx_WAITEN_Pos                 (13U)
#define FMC_BCRx_WAITEN_Msk                 (0x1UL << FMC_BCRx_WAITEN_Pos)          /*!< 0x00002000 */
#define FMC_BCRx_WAITEN                     FMC_BCRx_WAITEN_Msk                     /*!<Wait enable bit            */
#define FMC_BCRx_EXTMOD_Pos                 (14U)
#define FMC_BCRx_EXTMOD_Msk                 (0x1UL << FMC_BCRx_EXTMOD_Pos)          /*!< 0x00004000 */
#define FMC_BCRx_EXTMOD                     FMC_BCRx_EXTMOD_Msk                     /*!<Extended mode enable       */
#define FMC_BCRx_ASYNCWAIT_Pos              (15U)
#define FMC_BCRx_ASYNCWAIT_Msk              (0x1UL << FMC_BCRx_ASYNCWAIT_Pos)       /*!< 0x00008000 */
#define FMC_BCRx_ASYNCWAIT                  FMC_BCRx_ASYNCWAIT_Msk                  /*!<Asynchronous wait          */
#define FMC_BCRx_CPSIZE_Pos                 (16U)
#define FMC_BCRx_CPSIZE_Msk                 (0x7UL << FMC_BCRx_CPSIZE_Pos)          /*!< 0x00070000 */
#define FMC_BCRx_CPSIZE                     FMC_BCRx_CPSIZE_Msk                     /*!<PSIZE[2:0] bits CRAM Page Size */
#define FMC_BCRx_CPSIZE_0                   (0x1UL << FMC_BCRx_CPSIZE_Pos)          /*!< 0x00010000 */
#define FMC_BCRx_CPSIZE_1                   (0x2UL << FMC_BCRx_CPSIZE_Pos)          /*!< 0x00020000 */
#define FMC_BCRx_CPSIZE_2                   (0x4UL << FMC_BCRx_CPSIZE_Pos)          /*!< 0x00040000 */
#define FMC_BCRx_CBURSTRW_Pos               (19U)
#define FMC_BCRx_CBURSTRW_Msk               (0x1UL << FMC_BCRx_CBURSTRW_Pos)        /*!< 0x00080000 */
#define FMC_BCRx_CBURSTRW                   FMC_BCRx_CBURSTRW_Msk                   /*!<Write burst enable         */
#define FMC_BCRx_NBLSET_Pos                 (22U)
#define FMC_BCRx_NBLSET_Msk                 (0x3UL << FMC_BCRx_NBLSET_Pos)          /*!< 0x00C00000 */
#define FMC_BCRx_NBLSET                     FMC_BCRx_NBLSET_Msk                     /*!<Byte lane (NBL) setup      */
#define FMC_BCRx_NBLSET_0                   (0x1UL << FMC_BCRx_NBLSET_Pos)          /*!< 0x00400000 */
#define FMC_BCRx_NBLSET_1                   (0x2UL << FMC_BCRx_NBLSET_Pos)          /*!< 0x00800000 */

/******************  Bit definition for FMC_BTRx registers (x=1..4)  *********/
#define FMC_BTRx_ADDSET_Pos                 (0U)
#define FMC_BTRx_ADDSET_Msk                 (0xFUL << FMC_BTRx_ADDSET_Pos)          /*!< 0x0000000F */
#define FMC_BTRx_ADDSET                     FMC_BTRx_ADDSET_Msk                     /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BTRx_ADDSET_0                   (0x1UL << FMC_BTRx_ADDSET_Pos)          /*!< 0x00000001 */
#define FMC_BTRx_ADDSET_1                   (0x2UL << FMC_BTRx_ADDSET_Pos)          /*!< 0x00000002 */
#define FMC_BTRx_ADDSET_2                   (0x4UL << FMC_BTRx_ADDSET_Pos)          /*!< 0x00000004 */
#define FMC_BTRx_ADDSET_3                   (0x8UL << FMC_BTRx_ADDSET_Pos)          /*!< 0x00000008 */
#define FMC_BTRx_ADDHLD_Pos                 (4U)
#define FMC_BTRx_ADDHLD_Msk                 (0xFUL << FMC_BTRx_ADDHLD_Pos)          /*!< 0x000000F0 */
#define FMC_BTRx_ADDHLD                     FMC_BTRx_ADDHLD_Msk                     /*!<ADDHLD[3:0] bits (Address-hold phase duration)  */
#define FMC_BTRx_ADDHLD_0                   (0x1UL << FMC_BTRx_ADDHLD_Pos)          /*!< 0x00000010 */
#define FMC_BTRx_ADDHLD_1                   (0x2UL << FMC_BTRx_ADDHLD_Pos)          /*!< 0x00000020 */
#define FMC_BTRx_ADDHLD_2                   (0x4UL << FMC_BTRx_ADDHLD_Pos)          /*!< 0x00000040 */
#define FMC_BTRx_ADDHLD_3                   (0x8UL << FMC_BTRx_ADDHLD_Pos)          /*!< 0x00000080 */
#define FMC_BTRx_DATAST_Pos                 (8U)
#define FMC_BTRx_DATAST_Msk                 (0xFFUL << FMC_BTRx_DATAST_Pos)         /*!< 0x0000FF00 */
#define FMC_BTRx_DATAST                     FMC_BTRx_DATAST_Msk                     /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BTRx_DATAST_0                   (0x01UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00000100 */
#define FMC_BTRx_DATAST_1                   (0x02UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00000200 */
#define FMC_BTRx_DATAST_2                   (0x04UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00000400 */
#define FMC_BTRx_DATAST_3                   (0x08UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00000800 */
#define FMC_BTRx_DATAST_4                   (0x10UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00001000 */
#define FMC_BTRx_DATAST_5                   (0x20UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00002000 */
#define FMC_BTRx_DATAST_6                   (0x40UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00004000 */
#define FMC_BTRx_DATAST_7                   (0x80UL << FMC_BTRx_DATAST_Pos)         /*!< 0x00008000 */
#define FMC_BTRx_BUSTURN_Pos                (16U)
#define FMC_BTRx_BUSTURN_Msk                (0xFUL << FMC_BTRx_BUSTURN_Pos)         /*!< 0x000F0000 */
#define FMC_BTRx_BUSTURN                    FMC_BTRx_BUSTURN_Msk                    /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BTRx_BUSTURN_0                  (0x1UL << FMC_BTRx_BUSTURN_Pos)         /*!< 0x00010000 */
#define FMC_BTRx_BUSTURN_1                  (0x2UL << FMC_BTRx_BUSTURN_Pos)         /*!< 0x00020000 */
#define FMC_BTRx_BUSTURN_2                  (0x4UL << FMC_BTRx_BUSTURN_Pos)         /*!< 0x00040000 */
#define FMC_BTRx_BUSTURN_3                  (0x8UL << FMC_BTRx_BUSTURN_Pos)         /*!< 0x00080000 */
#define FMC_BTRx_CLKDIV_Pos                 (20U)
#define FMC_BTRx_CLKDIV_Msk                 (0xFUL << FMC_BTRx_CLKDIV_Pos)          /*!< 0x00F00000 */
#define FMC_BTRx_CLKDIV                     FMC_BTRx_CLKDIV_Msk                     /*!<CLKDIV[3:0] bits (Clock divide ratio) */
#define FMC_BTRx_CLKDIV_0                   (0x1UL << FMC_BTRx_CLKDIV_Pos)          /*!< 0x00100000 */
#define FMC_BTRx_CLKDIV_1                   (0x2UL << FMC_BTRx_CLKDIV_Pos)          /*!< 0x00200000 */
#define FMC_BTRx_CLKDIV_2                   (0x4UL << FMC_BTRx_CLKDIV_Pos)          /*!< 0x00400000 */
#define FMC_BTRx_CLKDIV_3                   (0x8UL << FMC_BTRx_CLKDIV_Pos)          /*!< 0x00800000 */
#define FMC_BTRx_DATLAT_Pos                 (24U)
#define FMC_BTRx_DATLAT_Msk                 (0xFUL << FMC_BTRx_DATLAT_Pos)          /*!< 0x0F000000 */
#define FMC_BTRx_DATLAT                     FMC_BTRx_DATLAT_Msk                     /*!<DATLA[3:0] bits (Data latency) */
#define FMC_BTRx_DATLAT_0                   (0x1UL << FMC_BTRx_DATLAT_Pos)          /*!< 0x01000000 */
#define FMC_BTRx_DATLAT_1                   (0x2UL << FMC_BTRx_DATLAT_Pos)          /*!< 0x02000000 */
#define FMC_BTRx_DATLAT_2                   (0x4UL << FMC_BTRx_DATLAT_Pos)          /*!< 0x04000000 */
#define FMC_BTRx_DATLAT_3                   (0x8UL << FMC_BTRx_DATLAT_Pos)          /*!< 0x08000000 */
#define FMC_BTRx_ACCMOD_Pos                 (28U)
#define FMC_BTRx_ACCMOD_Msk                 (0x3UL << FMC_BTRx_ACCMOD_Pos)          /*!< 0x30000000 */
#define FMC_BTRx_ACCMOD                     FMC_BTRx_ACCMOD_Msk                     /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BTRx_ACCMOD_0                   (0x1UL << FMC_BTRx_ACCMOD_Pos)          /*!< 0x10000000 */
#define FMC_BTRx_ACCMOD_1                   (0x2UL << FMC_BTRx_ACCMOD_Pos)          /*!< 0x20000000 */
#define FMC_BTRx_DATAHLD_Pos                (30U)
#define FMC_BTRx_DATAHLD_Msk                (0x3UL << FMC_BTRx_DATAHLD_Pos)         /*!< 0xC0000000 */
#define FMC_BTRx_DATAHLD                    FMC_BTRx_DATAHLD_Msk                    /*!<DATAHLD[1:0] bits (Data hold phase duration) */
#define FMC_BTRx_DATAHLD_0                  (0x1UL << FMC_BTRx_DATAHLD_Pos)         /*!< 0x40000000 */
#define FMC_BTRx_DATAHLD_1                  (0x2UL << FMC_BTRx_DATAHLD_Pos)         /*!< 0x80000000 */

/******************  Bit definition for FMC_BWTRx registers (x=1..4)  *********/
#define FMC_BWTRx_ADDSET_Pos                (0U)
#define FMC_BWTRx_ADDSET_Msk                (0xFUL << FMC_BWTRx_ADDSET_Pos)         /*!< 0x0000000F */
#define FMC_BWTRx_ADDSET                    FMC_BWTRx_ADDSET_Msk                    /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BWTRx_ADDSET_0                  (0x1UL << FMC_BWTRx_ADDSET_Pos)         /*!< 0x00000001 */
#define FMC_BWTRx_ADDSET_1                  (0x2UL << FMC_BWTRx_ADDSET_Pos)         /*!< 0x00000002 */
#define FMC_BWTRx_ADDSET_2                  (0x4UL << FMC_BWTRx_ADDSET_Pos)         /*!< 0x00000004 */
#define FMC_BWTRx_ADDSET_3                  (0x8UL << FMC_BWTRx_ADDSET_Pos)         /*!< 0x00000008 */
#define FMC_BWTRx_ADDHLD_Pos                (4U)
#define FMC_BWTRx_ADDHLD_Msk                (0xFUL << FMC_BWTRx_ADDHLD_Pos)         /*!< 0x000000F0 */
#define FMC_BWTRx_ADDHLD                    FMC_BWTRx_ADDHLD_Msk                    /*!<ADDHLD[3:0] bits (Address-hold phase duration) */
#define FMC_BWTRx_ADDHLD_0                  (0x1UL << FMC_BWTRx_ADDHLD_Pos)         /*!< 0x00000010 */
#define FMC_BWTRx_ADDHLD_1                  (0x2UL << FMC_BWTRx_ADDHLD_Pos)         /*!< 0x00000020 */
#define FMC_BWTRx_ADDHLD_2                  (0x4UL << FMC_BWTRx_ADDHLD_Pos)         /*!< 0x00000040 */
#define FMC_BWTRx_ADDHLD_3                  (0x8UL << FMC_BWTRx_ADDHLD_Pos)         /*!< 0x00000080 */
#define FMC_BWTRx_DATAST_Pos                (8U)
#define FMC_BWTRx_DATAST_Msk                (0xFFUL << FMC_BWTRx_DATAST_Pos)        /*!< 0x0000FF00 */
#define FMC_BWTRx_DATAST                    FMC_BWTRx_DATAST_Msk                    /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BWTRx_DATAST_0                  (0x01UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00000100 */
#define FMC_BWTRx_DATAST_1                  (0x02UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00000200 */
#define FMC_BWTRx_DATAST_2                  (0x04UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00000400 */
#define FMC_BWTRx_DATAST_3                  (0x08UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00000800 */
#define FMC_BWTRx_DATAST_4                  (0x10UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00001000 */
#define FMC_BWTRx_DATAST_5                  (0x20UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00002000 */
#define FMC_BWTRx_DATAST_6                  (0x40UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00004000 */
#define FMC_BWTRx_DATAST_7                  (0x80UL << FMC_BWTRx_DATAST_Pos)        /*!< 0x00008000 */
#define FMC_BWTRx_BUSTURN_Pos               (16U)
#define FMC_BWTRx_BUSTURN_Msk               (0xFUL << FMC_BWTRx_BUSTURN_Pos)        /*!< 0x000F0000 */
#define FMC_BWTRx_BUSTURN                   FMC_BWTRx_BUSTURN_Msk                   /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BWTRx_BUSTURN_0                 (0x1UL << FMC_BWTRx_BUSTURN_Pos)        /*!< 0x00010000 */
#define FMC_BWTRx_BUSTURN_1                 (0x2UL << FMC_BWTRx_BUSTURN_Pos)        /*!< 0x00020000 */
#define FMC_BWTRx_BUSTURN_2                 (0x4UL << FMC_BWTRx_BUSTURN_Pos)        /*!< 0x00040000 */
#define FMC_BWTRx_BUSTURN_3                 (0x8UL << FMC_BWTRx_BUSTURN_Pos)        /*!< 0x00080000 */
#define FMC_BWTRx_ACCMOD_Pos                (28U)
#define FMC_BWTRx_ACCMOD_Msk                (0x3UL << FMC_BWTRx_ACCMOD_Pos)         /*!< 0x30000000 */
#define FMC_BWTRx_ACCMOD                    FMC_BWTRx_ACCMOD_Msk                    /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BWTRx_ACCMOD_0                  (0x1UL << FMC_BWTRx_ACCMOD_Pos)         /*!< 0x10000000 */
#define FMC_BWTRx_ACCMOD_1                  (0x2UL << FMC_BWTRx_ACCMOD_Pos)         /*!< 0x20000000 */
#define FMC_BWTRx_DATAHLD_Pos               (30U)
#define FMC_BWTRx_DATAHLD_Msk               (0x3UL << FMC_BWTRx_DATAHLD_Pos)        /*!< 0xC0000000 */
#define FMC_BWTRx_DATAHLD                   FMC_BWTRx_DATAHLD_Msk                   /*!<DATAHLD[1:0] bits (Data hold phase duration) */
#define FMC_BWTRx_DATAHLD_0                 (0x1UL << FMC_BWTRx_DATAHLD_Pos)        /*!< 0x40000000 */
#define FMC_BWTRx_DATAHLD_1                 (0x2UL << FMC_BWTRx_DATAHLD_Pos)        /*!< 0x80000000 */

/******************  Bit definition for FMC_PCSCNTR register ******************/
#define FMC_PCSCNTR_CSCOUNT_Pos             (0U)
#define FMC_PCSCNTR_CSCOUNT_Msk             (0xFFFFUL << FMC_PCSCNTR_CSCOUNT_Pos)   /*!< 0x0000FFFF */
#define FMC_PCSCNTR_CSCOUNT                 FMC_PCSCNTR_CSCOUNT_Msk                 /*!<CSCOUNT[15:0] bits (Chip select counter) */
#define FMC_PCSCNTR_CNTB1EN_Pos             (16U)
#define FMC_PCSCNTR_CNTB1EN_Msk             (0x1UL << FMC_PCSCNTR_CNTB1EN_Pos)      /*!< 0x00010000 */
#define FMC_PCSCNTR_CNTB1EN                 FMC_PCSCNTR_CNTB1EN_Msk                 /*!<Counter PSRAM/NOR Bank1_1 enable */
#define FMC_PCSCNTR_CNTB2EN_Pos             (17U)
#define FMC_PCSCNTR_CNTB2EN_Msk             (0x1UL << FMC_PCSCNTR_CNTB2EN_Pos)      /*!< 0x00020000 */
#define FMC_PCSCNTR_CNTB2EN                 FMC_PCSCNTR_CNTB2EN_Msk                 /*!<Counter PSRAM/NOR Bank1_2 enable */
#define FMC_PCSCNTR_CNTB3EN_Pos             (18U)
#define FMC_PCSCNTR_CNTB3EN_Msk             (0x1UL << FMC_PCSCNTR_CNTB3EN_Pos)      /*!< 0x00040000 */
#define FMC_PCSCNTR_CNTB3EN                 FMC_PCSCNTR_CNTB3EN_Msk                 /*!<Counter PSRAM/NOR Bank1_3 enable */
#define FMC_PCSCNTR_CNTB4EN_Pos             (19U)
#define FMC_PCSCNTR_CNTB4EN_Msk             (0x1UL << FMC_PCSCNTR_CNTB4EN_Pos)      /*!< 0x00080000 */
#define FMC_PCSCNTR_CNTB4EN                 FMC_PCSCNTR_CNTB4EN_Msk                 /*!<Counter PSRAM/NOR Bank1_4 enable */

/******************  Bit definition for FMC_PCR register  *******************/
#define FMC_PCR_PWAITEN_Pos                 (1U)
#define FMC_PCR_PWAITEN_Msk                 (0x1UL << FMC_PCR_PWAITEN_Pos)          /*!< 0x00000002 */
#define FMC_PCR_PWAITEN                     FMC_PCR_PWAITEN_Msk                     /*!<Wait feature enable bit                   */
#define FMC_PCR_PBKEN_Pos                   (2U)
#define FMC_PCR_PBKEN_Msk                   (0x1UL << FMC_PCR_PBKEN_Pos)            /*!< 0x00000004 */
#define FMC_PCR_PBKEN                       FMC_PCR_PBKEN_Msk                       /*!<NAND Flash memory bank enable bit */
#define FMC_PCR_PTYP_Pos                    (3U)
#define FMC_PCR_PTYP_Msk                    (0x1UL << FMC_PCR_PTYP_Pos)             /*!< 0x00000008 */
#define FMC_PCR_PTYP                        FMC_PCR_PTYP_Msk                        /*!<Memory type                               */
#define FMC_PCR_PWID_Pos                    (4U)
#define FMC_PCR_PWID_Msk                    (0x3UL << FMC_PCR_PWID_Pos)             /*!< 0x00000030 */
#define FMC_PCR_PWID                        FMC_PCR_PWID_Msk                        /*!<PWID[1:0] bits (NAND Flash databus width) */
#define FMC_PCR_PWID_0                      (0x1UL << FMC_PCR_PWID_Pos)             /*!< 0x00000010 */
#define FMC_PCR_PWID_1                      (0x2UL << FMC_PCR_PWID_Pos)             /*!< 0x00000020 */
#define FMC_PCR_ECCEN_Pos                   (6U)
#define FMC_PCR_ECCEN_Msk                   (0x1UL << FMC_PCR_ECCEN_Pos)            /*!< 0x00000040 */
#define FMC_PCR_ECCEN                       FMC_PCR_ECCEN_Msk                       /*!<ECC computation logic enable bit          */
#define FMC_PCR_TCLR_Pos                    (9U)
#define FMC_PCR_TCLR_Msk                    (0xFUL << FMC_PCR_TCLR_Pos)             /*!< 0x00001E00 */
#define FMC_PCR_TCLR                        FMC_PCR_TCLR_Msk                        /*!<TCLR[3:0] bits (CLE to RE delay)          */
#define FMC_PCR_TCLR_0                      (0x1UL << FMC_PCR_TCLR_Pos)             /*!< 0x00000200 */
#define FMC_PCR_TCLR_1                      (0x2UL << FMC_PCR_TCLR_Pos)             /*!< 0x00000400 */
#define FMC_PCR_TCLR_2                      (0x4UL << FMC_PCR_TCLR_Pos)             /*!< 0x00000800 */
#define FMC_PCR_TCLR_3                      (0x8UL << FMC_PCR_TCLR_Pos)             /*!< 0x00001000 */
#define FMC_PCR_TAR_Pos                     (13U)
#define FMC_PCR_TAR_Msk                     (0xFUL << FMC_PCR_TAR_Pos)              /*!< 0x0001E000 */
#define FMC_PCR_TAR                         FMC_PCR_TAR_Msk                         /*!<TAR[3:0] bits (ALE to RE delay)           */
#define FMC_PCR_TAR_0                       (0x1UL << FMC_PCR_TAR_Pos)              /*!< 0x00002000 */
#define FMC_PCR_TAR_1                       (0x2UL << FMC_PCR_TAR_Pos)              /*!< 0x00004000 */
#define FMC_PCR_TAR_2                       (0x4UL << FMC_PCR_TAR_Pos)              /*!< 0x00008000 */
#define FMC_PCR_TAR_3                       (0x8UL << FMC_PCR_TAR_Pos)              /*!< 0x00010000 */
#define FMC_PCR_ECCPS_Pos                   (17U)
#define FMC_PCR_ECCPS_Msk                   (0x7UL << FMC_PCR_ECCPS_Pos)            /*!< 0x000E0000 */
#define FMC_PCR_ECCPS                       FMC_PCR_ECCPS_Msk                       /*!<ECCPS[1:0] bits (ECC page size)           */
#define FMC_PCR_ECCPS_0                     (0x1UL << FMC_PCR_ECCPS_Pos)            /*!< 0x00020000 */
#define FMC_PCR_ECCPS_1                     (0x2UL << FMC_PCR_ECCPS_Pos)            /*!< 0x00040000 */
#define FMC_PCR_ECCPS_2                     (0x4UL << FMC_PCR_ECCPS_Pos)            /*!< 0x00080000 */

/*******************  Bit definition for FMC_SR register  *******************/
#define FMC_SR_IRS_Pos                      (0U)
#define FMC_SR_IRS_Msk                      (0x1UL << FMC_SR_IRS_Pos)               /*!< 0x00000001 */
#define FMC_SR_IRS                          FMC_SR_IRS_Msk                          /*!<Interrupt Rising Edge status                */
#define FMC_SR_ILS_Pos                      (1U)
#define FMC_SR_ILS_Msk                      (0x1UL << FMC_SR_ILS_Pos)               /*!< 0x00000002 */
#define FMC_SR_ILS                          FMC_SR_ILS_Msk                          /*!<Interrupt Level status                      */
#define FMC_SR_IFS_Pos                      (2U)
#define FMC_SR_IFS_Msk                      (0x1UL << FMC_SR_IFS_Pos)               /*!< 0x00000004 */
#define FMC_SR_IFS                          FMC_SR_IFS_Msk                          /*!<Interrupt Falling Edge status               */
#define FMC_SR_IREN_Pos                     (3U)
#define FMC_SR_IREN_Msk                     (0x1UL << FMC_SR_IREN_Pos)              /*!< 0x00000008 */
#define FMC_SR_IREN                         FMC_SR_IREN_Msk                         /*!<Interrupt Rising Edge detection Enable bit  */
#define FMC_SR_ILEN_Pos                     (4U)
#define FMC_SR_ILEN_Msk                     (0x1UL << FMC_SR_ILEN_Pos)              /*!< 0x00000010 */
#define FMC_SR_ILEN                         FMC_SR_ILEN_Msk                         /*!<Interrupt Level detection Enable bit        */
#define FMC_SR_IFEN_Pos                     (5U)
#define FMC_SR_IFEN_Msk                     (0x1UL << FMC_SR_IFEN_Pos)              /*!< 0x00000020 */
#define FMC_SR_IFEN                         FMC_SR_IFEN_Msk                         /*!<Interrupt Falling Edge detection Enable bit */
#define FMC_SR_FEMPT_Pos                    (6U)
#define FMC_SR_FEMPT_Msk                    (0x1UL << FMC_SR_FEMPT_Pos)             /*!< 0x00000040 */
#define FMC_SR_FEMPT                        FMC_SR_FEMPT_Msk                        /*!<FIFO empty                                  */

/******************  Bit definition for FMC_PMEM register  ******************/
#define FMC_PMEM_MEMSET_Pos                 (0U)
#define FMC_PMEM_MEMSET_Msk                 (0xFFUL << FMC_PMEM_MEMSET_Pos)         /*!< 0x000000FF */
#define FMC_PMEM_MEMSET                     FMC_PMEM_MEMSET_Msk                     /*!<MEMSET[7:0] bits (Common memory setup time) */
#define FMC_PMEM_MEMSET_0                   (0x01UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000001 */
#define FMC_PMEM_MEMSET_1                   (0x02UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000002 */
#define FMC_PMEM_MEMSET_2                   (0x04UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000004 */
#define FMC_PMEM_MEMSET_3                   (0x08UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000008 */
#define FMC_PMEM_MEMSET_4                   (0x10UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000010 */
#define FMC_PMEM_MEMSET_5                   (0x20UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000020 */
#define FMC_PMEM_MEMSET_6                   (0x40UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000040 */
#define FMC_PMEM_MEMSET_7                   (0x80UL << FMC_PMEM_MEMSET_Pos)         /*!< 0x00000080 */
#define FMC_PMEM_MEMWAIT_Pos                (8U)
#define FMC_PMEM_MEMWAIT_Msk                (0xFFUL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x0000FF00 */
#define FMC_PMEM_MEMWAIT                    FMC_PMEM_MEMWAIT_Msk                    /*!<MEMWAIT[7:0] bits (Common memory wait time) */
#define FMC_PMEM_MEMWAIT_0                  (0x01UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00000100 */
#define FMC_PMEM_MEMWAIT_1                  (0x02UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00000200 */
#define FMC_PMEM_MEMWAIT_2                  (0x04UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00000400 */
#define FMC_PMEM_MEMWAIT_3                  (0x08UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00000800 */
#define FMC_PMEM_MEMWAIT_4                  (0x10UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00001000 */
#define FMC_PMEM_MEMWAIT_5                  (0x20UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00002000 */
#define FMC_PMEM_MEMWAIT_6                  (0x40UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00004000 */
#define FMC_PMEM_MEMWAIT_7                  (0x80UL << FMC_PMEM_MEMWAIT_Pos)        /*!< 0x00008000 */
#define FMC_PMEM_MEMHOLD_Pos                (16U)
#define FMC_PMEM_MEMHOLD_Msk                (0xFFUL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00FF0000 */
#define FMC_PMEM_MEMHOLD                    FMC_PMEM_MEMHOLD_Msk                    /*!<MEMHOLD[7:0] bits (Common memory hold time) */
#define FMC_PMEM_MEMHOLD_0                  (0x01UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00010000 */
#define FMC_PMEM_MEMHOLD_1                  (0x02UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00020000 */
#define FMC_PMEM_MEMHOLD_2                  (0x04UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00040000 */
#define FMC_PMEM_MEMHOLD_3                  (0x08UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00080000 */
#define FMC_PMEM_MEMHOLD_4                  (0x10UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00100000 */
#define FMC_PMEM_MEMHOLD_5                  (0x20UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00200000 */
#define FMC_PMEM_MEMHOLD_6                  (0x40UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00400000 */
#define FMC_PMEM_MEMHOLD_7                  (0x80UL << FMC_PMEM_MEMHOLD_Pos)        /*!< 0x00800000 */
#define FMC_PMEM_MEMHIZ_Pos                 (24U)
#define FMC_PMEM_MEMHIZ_Msk                 (0xFFUL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0xFF000000 */
#define FMC_PMEM_MEMHIZ                     FMC_PMEM_MEMHIZ_Msk                     /*!<MEMHIZ[7:0] bits (Common memory databus HiZ time) */
#define FMC_PMEM_MEMHIZ_0                   (0x01UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x01000000 */
#define FMC_PMEM_MEMHIZ_1                   (0x02UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x02000000 */
#define FMC_PMEM_MEMHIZ_2                   (0x04UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x04000000 */
#define FMC_PMEM_MEMHIZ_3                   (0x08UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x08000000 */
#define FMC_PMEM_MEMHIZ_4                   (0x10UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x10000000 */
#define FMC_PMEM_MEMHIZ_5                   (0x20UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x20000000 */
#define FMC_PMEM_MEMHIZ_6                   (0x40UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x40000000 */
#define FMC_PMEM_MEMHIZ_7                   (0x80UL << FMC_PMEM_MEMHIZ_Pos)         /*!< 0x80000000 */

/******************  Bit definition for FMC_PATT register  ******************/
#define FMC_PATT_ATTSET_Pos                 (0U)
#define FMC_PATT_ATTSET_Msk                 (0xFFUL << FMC_PATT_ATTSET_Pos)         /*!< 0x000000FF */
#define FMC_PATT_ATTSET                     FMC_PATT_ATTSET_Msk                     /*!<ATTSET[7:0] bits (Attribute memory setup time) */
#define FMC_PATT_ATTSET_0                   (0x01UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000001 */
#define FMC_PATT_ATTSET_1                   (0x02UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000002 */
#define FMC_PATT_ATTSET_2                   (0x04UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000004 */
#define FMC_PATT_ATTSET_3                   (0x08UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000008 */
#define FMC_PATT_ATTSET_4                   (0x10UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000010 */
#define FMC_PATT_ATTSET_5                   (0x20UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000020 */
#define FMC_PATT_ATTSET_6                   (0x40UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000040 */
#define FMC_PATT_ATTSET_7                   (0x80UL << FMC_PATT_ATTSET_Pos)         /*!< 0x00000080 */
#define FMC_PATT_ATTWAIT_Pos                (8U)
#define FMC_PATT_ATTWAIT_Msk                (0xFFUL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x0000FF00 */
#define FMC_PATT_ATTWAIT                    FMC_PATT_ATTWAIT_Msk                    /*!<ATTWAIT[7:0] bits (Attribute memory wait time) */
#define FMC_PATT_ATTWAIT_0                  (0x01UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00000100 */
#define FMC_PATT_ATTWAIT_1                  (0x02UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00000200 */
#define FMC_PATT_ATTWAIT_2                  (0x04UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00000400 */
#define FMC_PATT_ATTWAIT_3                  (0x08UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00000800 */
#define FMC_PATT_ATTWAIT_4                  (0x10UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00001000 */
#define FMC_PATT_ATTWAIT_5                  (0x20UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00002000 */
#define FMC_PATT_ATTWAIT_6                  (0x40UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00004000 */
#define FMC_PATT_ATTWAIT_7                  (0x80UL << FMC_PATT_ATTWAIT_Pos)        /*!< 0x00008000 */
#define FMC_PATT_ATTHOLD_Pos                (16U)
#define FMC_PATT_ATTHOLD_Msk                (0xFFUL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00FF0000 */
#define FMC_PATT_ATTHOLD                    FMC_PATT_ATTHOLD_Msk                    /*!<ATTHOLD[7:0] bits (Attribute memory hold time) */
#define FMC_PATT_ATTHOLD_0                  (0x01UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00010000 */
#define FMC_PATT_ATTHOLD_1                  (0x02UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00020000 */
#define FMC_PATT_ATTHOLD_2                  (0x04UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00040000 */
#define FMC_PATT_ATTHOLD_3                  (0x08UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00080000 */
#define FMC_PATT_ATTHOLD_4                  (0x10UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00100000 */
#define FMC_PATT_ATTHOLD_5                  (0x20UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00200000 */
#define FMC_PATT_ATTHOLD_6                  (0x40UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00400000 */
#define FMC_PATT_ATTHOLD_7                  (0x80UL << FMC_PATT_ATTHOLD_Pos)        /*!< 0x00800000 */
#define FMC_PATT_ATTHIZ_Pos                 (24U)
#define FMC_PATT_ATTHIZ_Msk                 (0xFFUL << FMC_PATT_ATTHIZ_Pos)         /*!< 0xFF000000 */
#define FMC_PATT_ATTHIZ                     FMC_PATT_ATTHIZ_Msk                     /*!<ATTHIZ[7:0] bits (Attribute memory databus HiZ time) */
#define FMC_PATT_ATTHIZ_0                   (0x01UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x01000000 */
#define FMC_PATT_ATTHIZ_1                   (0x02UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x02000000 */
#define FMC_PATT_ATTHIZ_2                   (0x04UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x04000000 */
#define FMC_PATT_ATTHIZ_3                   (0x08UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x08000000 */
#define FMC_PATT_ATTHIZ_4                   (0x10UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x10000000 */
#define FMC_PATT_ATTHIZ_5                   (0x20UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x20000000 */
#define FMC_PATT_ATTHIZ_6                   (0x40UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x40000000 */
#define FMC_PATT_ATTHIZ_7                   (0x80UL << FMC_PATT_ATTHIZ_Pos)         /*!< 0x80000000 */

/******************  Bit definition for FMC_ECCR3 register  ******************/
#define FMC_ECCR3_ECC3_Pos                  (0U)
#define FMC_ECCR3_ECC3_Msk                  (0xFFFFFFFFUL << FMC_ECCR3_ECC3_Pos)    /*!< 0xFFFFFFFF */
#define FMC_ECCR3_ECC3                      FMC_ECCR3_ECC3_Msk                      /*!<ECC result */

/******************************************************************************/
/*                                                                            */
/*                       Graphic MMU (GFXMMU)                                 */
/*                                                                            */
/******************************************************************************/
/****************** Bits definition for GFXMMU_CR register ********************/
#define GFXMMU_CR_B0OIE_Pos                (0U)
#define GFXMMU_CR_B0OIE_Msk                (0x1UL << GFXMMU_CR_B0OIE_Pos)       /*!< 0x00000001 */
#define GFXMMU_CR_B0OIE                    GFXMMU_CR_B0OIE_Msk                  /*!< Buffer 0 overflow interrupt enable */
#define GFXMMU_CR_B1OIE_Pos                (1U)
#define GFXMMU_CR_B1OIE_Msk                (0x1UL << GFXMMU_CR_B1OIE_Pos)       /*!< 0x00000002 */
#define GFXMMU_CR_B1OIE                    GFXMMU_CR_B1OIE_Msk                  /*!< Buffer 1 overflow interrupt enable */
#define GFXMMU_CR_B2OIE_Pos                (2U)
#define GFXMMU_CR_B2OIE_Msk                (0x1UL << GFXMMU_CR_B2OIE_Pos)       /*!< 0x00000004 */
#define GFXMMU_CR_B2OIE                    GFXMMU_CR_B2OIE_Msk                  /*!< Buffer 2 overflow interrupt enable */
#define GFXMMU_CR_B3OIE_Pos                (3U)
#define GFXMMU_CR_B3OIE_Msk                (0x1UL << GFXMMU_CR_B3OIE_Pos)       /*!< 0x00000008 */
#define GFXMMU_CR_B3OIE                    GFXMMU_CR_B3OIE_Msk                  /*!< Buffer 3 overflow interrupt enable */
#define GFXMMU_CR_AMEIE_Pos                (4U)
#define GFXMMU_CR_AMEIE_Msk                (0x1UL << GFXMMU_CR_AMEIE_Pos)       /*!< 0x00000010 */
#define GFXMMU_CR_AMEIE                    GFXMMU_CR_AMEIE_Msk                  /*!< AHB master error interrupt enable */
#define GFXMMU_CR_192BM_Pos                (6U)
#define GFXMMU_CR_192BM_Msk                (0x1UL << GFXMMU_CR_192BM_Pos)       /*!< 0x00000040 */
#define GFXMMU_CR_192BM                    GFXMMU_CR_192BM_Msk                  /*!< 192 block mode */
#define GFXMMU_CR_ACE_Pos                  (20U)
#define GFXMMU_CR_ACE_Msk                  (0x1UL << GFXMMU_CR_ACE_Pos)         /*!< 0x00100000 */
#define GFXMMU_CR_ACE                      GFXMMU_CR_ACE_Msk                    /*!< Address cache enable */
#define GFXMMU_CR_ACLB_Pos                 (21U)
#define GFXMMU_CR_ACLB_Msk                 (0x3UL << GFXMMU_CR_ACLB_Pos)        /*!< 0x00600000 */
#define GFXMMU_CR_ACLB                     GFXMMU_CR_ACLB_Msk                   /*!< ACLB[1:0]: Address cache lock buffer */
#define GFXMMU_CR_ACLB_0                   (0x1UL << GFXMMU_CR_ACLB_Pos)        /*!< Address cache locked bit 0 */
#define GFXMMU_CR_ACLB_1                   (0x2UL << GFXMMU_CR_ACLB_Pos)        /*!< Address cache locked bit 1 */

/****************** Bits definition for GFXMMU_SR register ********************/
#define GFXMMU_SR_B0OF_Pos                 (0U)
#define GFXMMU_SR_B0OF_Msk                 (0x1UL << GFXMMU_SR_B0OF_Pos)        /*!< 0x00000001 */
#define GFXMMU_SR_B0OF                     GFXMMU_SR_B0OF_Msk                   /*!< Buffer 0 overflow flag */
#define GFXMMU_SR_B1OF_Pos                 (1U)
#define GFXMMU_SR_B1OF_Msk                 (0x1UL << GFXMMU_SR_B1OF_Pos)        /*!< 0x00000002 */
#define GFXMMU_SR_B1OF                     GFXMMU_SR_B1OF_Msk                   /*!< Buffer 1 overflow flag */
#define GFXMMU_SR_B2OF_Pos                 (2U)
#define GFXMMU_SR_B2OF_Msk                 (0x1UL << GFXMMU_SR_B2OF_Pos)        /*!< 0x00000004 */
#define GFXMMU_SR_B2OF                     GFXMMU_SR_B2OF_Msk                   /*!< Buffer 2 overflow flag */
#define GFXMMU_SR_B3OF_Pos                 (3U)
#define GFXMMU_SR_B3OF_Msk                 (0x1UL << GFXMMU_SR_B3OF_Pos)        /*!< 0x00000008 */
#define GFXMMU_SR_B3OF                     GFXMMU_SR_B3OF_Msk                   /*!< Buffer 3 overflow flag */
#define GFXMMU_SR_AMEF_Pos                 (4U)
#define GFXMMU_SR_AMEF_Msk                 (0x1UL << GFXMMU_SR_AMEF_Pos)        /*!< 0x00000010 */
#define GFXMMU_SR_AMEF                     GFXMMU_SR_AMEF_Msk                   /*!< AHB master error flag */

/****************** Bits definition for GFXMMU_FCR register *******************/
#define GFXMMU_FCR_CB0OF_Pos               (0U)
#define GFXMMU_FCR_CB0OF_Msk               (0x1UL << GFXMMU_FCR_CB0OF_Pos)      /*!< 0x00000001 */
#define GFXMMU_FCR_CB0OF                   GFXMMU_FCR_CB0OF_Msk                 /*!< Clear buffer 0 overflow flag */
#define GFXMMU_FCR_CB1OF_Pos               (1U)
#define GFXMMU_FCR_CB1OF_Msk               (0x1UL << GFXMMU_FCR_CB1OF_Pos)      /*!< 0x00000002 */
#define GFXMMU_FCR_CB1OF                   GFXMMU_FCR_CB1OF_Msk                 /*!< Clear buffer 1 overflow flag */
#define GFXMMU_FCR_CB2OF_Pos               (2U)
#define GFXMMU_FCR_CB2OF_Msk               (0x1UL << GFXMMU_FCR_CB2OF_Pos)      /*!< 0x00000004 */
#define GFXMMU_FCR_CB2OF                   GFXMMU_FCR_CB2OF_Msk                 /*!< Clear buffer 2 overflow flag */
#define GFXMMU_FCR_CB3OF_Pos               (3U)
#define GFXMMU_FCR_CB3OF_Msk               (0x1UL << GFXMMU_FCR_CB3OF_Pos)      /*!< 0x00000008 */
#define GFXMMU_FCR_CB3OF                   GFXMMU_FCR_CB3OF_Msk                 /*!< Clear buffer 3 overflow flag */
#define GFXMMU_FCR_CAMEF_Pos               (4U)
#define GFXMMU_FCR_CAMEF_Msk               (0x1UL << GFXMMU_FCR_CAMEF_Pos)      /*!< 0x00000010 */
#define GFXMMU_FCR_CAMEF                   GFXMMU_FCR_CAMEF_Msk                 /*!< Clear AHB master error flag */

/****************** Bits definition for GFXMMU_CCR register *******************/
#define GFXMMU_CCR_FF_Pos                  (0U)
#define GFXMMU_CCR_FF_Msk                  (0x1UL << GFXMMU_CCR_FF_Pos)         /*!< 0x00000001 */
#define GFXMMU_CCR_FF                      GFXMMU_CCR_FF_Msk                    /*!< Clear buffer 0 overflow flag */
#define GFXMMU_CCR_FI_Pos                  (1U)
#define GFXMMU_CCR_FI_Msk                  (0x1UL << GFXMMU_CCR_FI_Pos)         /*!< 0x00000002 */
#define GFXMMU_CCR_FI                      GFXMMU_CCR_FI_Msk                    /*!< Clear buffer 1 overflow flag */

/****************** Bits definition for GFXMMU_DVR register *******************/
#define GFXMMU_DVR_DV_Pos                  (0U)
#define GFXMMU_DVR_DV_Msk                  (0xFFFFFFFFUL << GFXMMU_DVR_DV_Pos)  /*!< 0xFFFFFFFF */
#define GFXMMU_DVR_DV                      GFXMMU_DVR_DV_Msk                    /*!< DV[31:0] bits (Default value) */

/****************** Bits definition for GFXMMU_B0CR register ******************/
#define GFXMMU_B0CR_PBO_Pos                (4U)
#define GFXMMU_B0CR_PBO_Msk                (0x7FFFFUL << GFXMMU_B0CR_PBO_Pos)   /*!< 0x007FFFF0 */
#define GFXMMU_B0CR_PBO                    GFXMMU_B0CR_PBO_Msk                  /*!< PB0[22:4] bits (Physical buffer offset) */
#define GFXMMU_B0CR_PBBA_Pos               (23U)
#define GFXMMU_B0CR_PBBA_Msk               (0x1FFUL << GFXMMU_B0CR_PBBA_Pos)    /*!< 0xFF800000 */
#define GFXMMU_B0CR_PBBA                   GFXMMU_B0CR_PBBA_Msk                 /*!< PBBA[31:23] bits (Physical buffer base address) */

/****************** Bits definition for GFXMMU_B1CR register ******************/
#define GFXMMU_B1CR_PBO_Pos                (4U)
#define GFXMMU_B1CR_PBO_Msk                (0x7FFFFUL << GFXMMU_B1CR_PBO_Pos)   /*!< 0x007FFFF0 */
#define GFXMMU_B1CR_PBO                    GFXMMU_B1CR_PBO_Msk                  /*!< PB0[22:4] bits (Physical buffer offset) */
#define GFXMMU_B1CR_PBBA_Pos               (23U)
#define GFXMMU_B1CR_PBBA_Msk               (0x1FFUL << GFXMMU_B1CR_PBBA_Pos)    /*!< 0xFF800000 */
#define GFXMMU_B1CR_PBBA                   GFXMMU_B1CR_PBBA_Msk                 /*!< PBBA[31:23] bits (Physical buffer base address) */

/****************** Bits definition for GFXMMU_B2CR register ******************/
#define GFXMMU_B2CR_PBO_Pos                (4U)
#define GFXMMU_B2CR_PBO_Msk                (0x7FFFFUL << GFXMMU_B2CR_PBO_Pos)   /*!< 0x007FFFF0 */
#define GFXMMU_B2CR_PBO                    GFXMMU_B2CR_PBO_Msk                  /*!< PB0[22:4] bits (Physical buffer offset) */
#define GFXMMU_B2CR_PBBA_Pos               (23U)
#define GFXMMU_B2CR_PBBA_Msk               (0x1FFUL << GFXMMU_B2CR_PBBA_Pos)    /*!< 0xFF800000 */
#define GFXMMU_B2CR_PBBA                   GFXMMU_B2CR_PBBA_Msk                 /*!< PBBA[31:23] bits (Physical buffer base address) */

/****************** Bits definition for GFXMMU_B3CR register ******************/
#define GFXMMU_B3CR_PBO_Pos                (4U)
#define GFXMMU_B3CR_PBO_Msk                (0x7FFFFUL << GFXMMU_B3CR_PBO_Pos)   /*!< 0x007FFFF0 */
#define GFXMMU_B3CR_PBO                    GFXMMU_B3CR_PBO_Msk                  /*!< PB0[22:4] bits (Physical buffer offset) */
#define GFXMMU_B3CR_PBBA_Pos               (23U)
#define GFXMMU_B3CR_PBBA_Msk               (0x1FFUL << GFXMMU_B3CR_PBBA_Pos)    /*!< 0xFF800000 */
#define GFXMMU_B3CR_PBBA                   GFXMMU_B3CR_PBBA_Msk                 /*!< PBBA[31:23] bits (Physical buffer base address) */

/****************** Bits definition for GFXMMU_LUTxL register *****************/
#define GFXMMU_LUTxL_EN_Pos                (0U)
#define GFXMMU_LUTxL_EN_Msk                (0x1UL << GFXMMU_LUTxL_EN_Pos)       /*!< 0x00000001 */
#define GFXMMU_LUTxL_EN                    GFXMMU_LUTxL_EN_Msk                  /*!< Enable */
#define GFXMMU_LUTxL_FVB_Pos               (8U)
#define GFXMMU_LUTxL_FVB_Msk               (0xFFUL << GFXMMU_LUTxL_FVB_Pos)     /*!< 0x0000FF00 */
#define GFXMMU_LUTxL_FVB                   GFXMMU_LUTxL_FVB_Msk                 /*!< FVB[7:0] bits (First visible block) */
#define GFXMMU_LUTxL_LVB_Pos               (16U)
#define GFXMMU_LUTxL_LVB_Msk               (0xFFUL << GFXMMU_LUTxL_LVB_Pos)     /*!< 0x00FF0000 */
#define GFXMMU_LUTxL_LVB                   GFXMMU_LUTxL_LVB_Msk                 /*!< LVB[7:0] bits (Last visible block) */

/****************** Bits definition for GFXMMU_LUTxH register *****************/
#define GFXMMU_LUTxH_LO_Pos                (4U)
#define GFXMMU_LUTxH_LO_Msk                (0x3FFFFUL << GFXMMU_LUTxH_LO_Pos)   /*!< 0x003FFFF0 */
#define GFXMMU_LUTxH_LO                    GFXMMU_LUTxH_LO_Msk                  /*!< LO[21:4] bits (Line offset) */

/******************************************************************************/
/*                                                                            */
/*                       Graphic Timer (GFXTIM)                               */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for GFXTIM_CR register  ******************/
#define GFXTIM_CR_TES_Pos              (0U)
#define GFXTIM_CR_TES_Msk              (0x3UL << GFXTIM_CR_TES_Pos)            /*!< 0x00000003 */
#define GFXTIM_CR_TES                  GFXTIM_CR_TES_Msk
#define GFXTIM_CR_TES_0                (0x1UL << GFXTIM_CR_TES_Pos)            /*!< 0x00000001 */
#define GFXTIM_CR_TES_1                (0x2UL << GFXTIM_CR_TES_Pos)            /*!< 0x00000002 */

#define GFXTIM_CR_TEPOL_Pos            (4U)
#define GFXTIM_CR_TEPOL_Msk            (0x1UL << GFXTIM_CR_TEPOL_Pos)          /*!< 0x00000010 */
#define GFXTIM_CR_TEPOL                GFXTIM_CR_TEPOL_Msk

#define GFXTIM_CR_SYNCS_Pos            (8U)
#define GFXTIM_CR_SYNCS_Msk            (0x3UL << GFXTIM_CR_SYNCS_Pos)          /*!< 0x00000300 */
#define GFXTIM_CR_SYNCS                GFXTIM_CR_SYNCS_Msk
#define GFXTIM_CR_SYNCS_0              (0x1UL << GFXTIM_CR_SYNCS_Pos)          /*!< 0x00000100 */
#define GFXTIM_CR_SYNCS_1              (0x2UL << GFXTIM_CR_SYNCS_Pos)          /*!< 0x00000200 */

#define GFXTIM_CR_FCCOE_Pos            (16U)
#define GFXTIM_CR_FCCOE_Msk            (0x1UL << GFXTIM_CR_FCCOE_Pos)          /*!< 0x00010000 */
#define GFXTIM_CR_FCCOE                GFXTIM_CR_FCCOE_Msk

#define GFXTIM_CR_LCCOE_Pos            (17U)
#define GFXTIM_CR_LCCOE_Msk            (0x1UL << GFXTIM_CR_LCCOE_Pos)          /*!< 0x00020000 */
#define GFXTIM_CR_LCCOE                GFXTIM_CR_LCCOE_Msk

/******************  Bits definition for GFXTIM_CR register  ******************/
#define GFXTIM_CGCR_LCS_Pos           (0U)
#define GFXTIM_CGCR_LCS_Msk           (0x7UL << GFXTIM_CGCR_LCS_Pos)           /*!< 0x00000007 */
#define GFXTIM_CGCR_LCS               GFXTIM_CGCR_LCS_Msk
#define GFXTIM_CGCR_LCS_0             (0x1UL << GFXTIM_CGCR_LCS_Pos)           /*!< 0x00000001 */
#define GFXTIM_CGCR_LCS_1             (0x2UL << GFXTIM_CGCR_LCS_Pos)           /*!< 0x00000002 */
#define GFXTIM_CGCR_LCS_2             (0x4UL << GFXTIM_CGCR_LCS_Pos)           /*!< 0x00000004 */

#define GFXTIM_CGCR_LCCCS_Pos         (4U)
#define GFXTIM_CGCR_LCCCS_Msk         (0x1UL << GFXTIM_CGCR_LCCCS_Pos)         /*!< 0x00000010 */
#define GFXTIM_CGCR_LCCCS             GFXTIM_CGCR_LCCCS_Msk

#define GFXTIM_CGCR_LCCFR_Pos         (8U)
#define GFXTIM_CGCR_LCCFR_Msk         (0x1UL << GFXTIM_CGCR_LCCFR_Pos)         /*!< 0x00000100 */
#define GFXTIM_CGCR_LCCFR             GFXTIM_CGCR_LCCFR_Msk

#define GFXTIM_CGCR_LCCHRS_Pos        (12U)
#define GFXTIM_CGCR_LCCHRS_Msk        (0x7UL << GFXTIM_CGCR_LCCHRS_Pos)        /*!< 0x00007000 */
#define GFXTIM_CGCR_LCCHRS            GFXTIM_CGCR_LCCHRS_Msk
#define GFXTIM_CGCR_LCCHRS_0          (0x1UL << GFXTIM_CGCR_LCCHRS_Pos)        /*!< 0x00001000 */
#define GFXTIM_CGCR_LCCHRS_1          (0x2UL << GFXTIM_CGCR_LCCHRS_Pos)        /*!< 0x00002000 */
#define GFXTIM_CGCR_LCCHRS_2          (0x4UL << GFXTIM_CGCR_LCCHRS_Pos)        /*!< 0x00004000 */

#define GFXTIM_CGCR_FCS_Pos           (16U)
#define GFXTIM_CGCR_FCS_Msk           (0x7UL << GFXTIM_CGCR_FCS_Pos)           /*!< 0x00000007 */
#define GFXTIM_CGCR_FCS               GFXTIM_CGCR_FCS_Msk
#define GFXTIM_CGCR_FCS_0             (0x1UL << GFXTIM_CGCR_FCS_Pos)           /*!< 0x00001000 */
#define GFXTIM_CGCR_FCS_1             (0x2UL << GFXTIM_CGCR_FCS_Pos)           /*!< 0x00002000 */
#define GFXTIM_CGCR_FCS_2             (0x4UL << GFXTIM_CGCR_FCS_Pos)           /*!< 0x00004000 */

#define GFXTIM_CGCR_FCCCS_Pos         (20U)
#define GFXTIM_CGCR_FCCCS_Msk         (0x7UL << GFXTIM_CGCR_FCCCS_Pos)         /*!< 0x00070000 */
#define GFXTIM_CGCR_FCCCS             GFXTIM_CGCR_FCCCS_Msk
#define GFXTIM_CGCR_FCCCS_0           (0x1UL << GFXTIM_CGCR_FCCCS_Pos)         /*!< 0x00010000 */
#define GFXTIM_CGCR_FCCCS_1           (0x2UL << GFXTIM_CGCR_FCCCS_Pos)         /*!< 0x00020000 */
#define GFXTIM_CGCR_FCCCS_2           (0x4UL << GFXTIM_CGCR_FCCCS_Pos)         /*!< 0x00040000 */

#define GFXTIM_CGCR_FCCFR_Pos         (24U)
#define GFXTIM_CGCR_FCCFR_Msk         (0x1UL << GFXTIM_CGCR_FCCFR_Pos)         /*!< 0x00100000 */
#define GFXTIM_CGCR_FCCFR             GFXTIM_CGCR_FCCFR_Msk

#define GFXTIM_CGCR_FCCHRS_Pos        (28U)
#define GFXTIM_CGCR_FCCHRS_Msk        (0x7UL << GFXTIM_CGCR_FCCHRS_Pos)        /*!< 0x70000000 */
#define GFXTIM_CGCR_FCCHRS            GFXTIM_CGCR_FCCHRS_Msk
#define GFXTIM_CGCR_FCCHRS_0          (0x1UL << GFXTIM_CGCR_FCCHRS_Pos)        /*!< 0x10000000 */
#define GFXTIM_CGCR_FCCHRS_1          (0x2UL << GFXTIM_CGCR_FCCHRS_Pos)        /*!< 0x20000000 */
#define GFXTIM_CGCR_FCCHRS_2          (0x4UL << GFXTIM_CGCR_FCCHRS_Pos)        /*!< 0x40000000 */

/******************  Bits definition for GFXTIM_TCR register  *****************/
#define GFXTIM_TCR_AFCEN_Pos           (0U)
#define GFXTIM_TCR_AFCEN_Msk           (0x1UL << GFXTIM_TCR_AFCEN_Pos)         /*!< 0x00000001 */
#define GFXTIM_TCR_AFCEN               GFXTIM_TCR_AFCEN_Msk

#define GFXTIM_TCR_FAFCR_Pos           (1U)
#define GFXTIM_TCR_FAFCR_Msk           (0x1UL << GFXTIM_TCR_FAFCR_Pos)         /*!< 0x00000002 */
#define GFXTIM_TCR_FAFCR               GFXTIM_TCR_FAFCR_Msk

#define GFXTIM_TCR_ALCEN_Pos           (4U)
#define GFXTIM_TCR_ALCEN_Msk           (0x1UL << GFXTIM_TCR_ALCEN_Pos)         /*!< 0x00000010 */
#define GFXTIM_TCR_ALCEN               GFXTIM_TCR_ALCEN_Msk

#define GFXTIM_TCR_FALCR_Pos           (5U)
#define GFXTIM_TCR_FALCR_Msk           (0x1UL << GFXTIM_TCR_FALCR_Pos)         /*!< 0x00000020 */
#define GFXTIM_TCR_FALCR               GFXTIM_TCR_FALCR_Msk

#define GFXTIM_TCR_RFC1EN_Pos          (16U)
#define GFXTIM_TCR_RFC1EN_Msk          (0x1UL << GFXTIM_TCR_RFC1EN_Pos)        /*!< 0x00010000 */
#define GFXTIM_TCR_RFC1EN              GFXTIM_TCR_RFC1EN_Msk

#define GFXTIM_TCR_RFC1CM_Pos          (17U)
#define GFXTIM_TCR_RFC1CM_Msk          (0x1UL << GFXTIM_TCR_RFC1CM_Pos)        /*!< 0x00020000 */
#define GFXTIM_TCR_RFC1CM              GFXTIM_TCR_RFC1CM_Msk

#define GFXTIM_TCR_FRFC1R_Pos          (18U)
#define GFXTIM_TCR_FRFC1R_Msk          (0x1UL << GFXTIM_TCR_FRFC1R_Pos)        /*!< 0x00040000 */
#define GFXTIM_TCR_FRFC1R              GFXTIM_TCR_FRFC1R_Msk

#define GFXTIM_TCR_RFC2EN_Pos          (20U)
#define GFXTIM_TCR_RFC2EN_Msk          (0x1UL << GFXTIM_TCR_RFC2EN_Pos)        /*!< 0x00100000 */
#define GFXTIM_TCR_RFC2EN              GFXTIM_TCR_RFC2EN_Msk

#define GFXTIM_TCR_RFC2CM_Pos          (21U)
#define GFXTIM_TCR_RFC2CM_Msk          (0x1UL << GFXTIM_TCR_RFC2CM_Pos)        /*!< 0x00200000 */
#define GFXTIM_TCR_RFC2CM              GFXTIM_TCR_RFC2CM_Msk

#define GFXTIM_TCR_FRFC2R_Pos          (22U)
#define GFXTIM_TCR_FRFC2R_Msk          (0x1UL << GFXTIM_TCR_FRFC2R_Pos)        /*!< 0x00400000 */
#define GFXTIM_TCR_FRFC2R              GFXTIM_TCR_FRFC2R_Msk

/******************  Bits definition for GFXTIM_TDR register  *****************/
#define GFXTIM_TDR_AFCDIS_Pos          (0U)
#define GFXTIM_TDR_AFCDIS_Msk          (0x1UL << GFXTIM_TDR_AFCDIS_Pos)        /*!< 0x00000001 */
#define GFXTIM_TDR_AFCDIS              GFXTIM_TDR_AFCDIS_Msk

#define GFXTIM_TDR_ALCDIS_Pos          (4U)
#define GFXTIM_TDR_ALCDIS_Msk          (0x1UL << GFXTIM_TDR_ALCDIS_Pos)        /*!< 0x00000010 */
#define GFXTIM_TDR_ALCDIS              GFXTIM_TDR_ALCDIS_Msk

#define GFXTIM_TDR_RFC1DIS_Pos         (16U)
#define GFXTIM_TDR_RFC1DIS_Msk         (0x1UL << GFXTIM_TDR_RFC1DIS_Pos)       /*!< 0x00010000 */
#define GFXTIM_TDR_RFC1DIS             GFXTIM_TDR_RFC1DIS_Msk

#define GFXTIM_TDR_RFC2DIS_Pos         (20U)
#define GFXTIM_TDR_RFC2DIS_Msk         (0x1UL << GFXTIM_TDR_RFC2DIS_Pos)       /*!< 0x00100000 */
#define GFXTIM_TDR_RFC2DIS             GFXTIM_TDR_RFC2DIS_Msk

/******************  Bits definition for GFXTIM_EVCR register  ****************/
#define GFXTIM_EVCR_EV1EN_Pos          (0U)
#define GFXTIM_EVCR_EV1EN_Msk          (0x1UL << GFXTIM_EVCR_EV1EN_Pos)        /*!< 0x00000001 */
#define GFXTIM_EVCR_EV1EN              GFXTIM_EVCR_EV1EN_Msk

#define GFXTIM_EVCR_EV2EN_Pos          (1U)
#define GFXTIM_EVCR_EV2EN_Msk          (0x1UL << GFXTIM_EVCR_EV2EN_Pos)        /*!< 0x00000002 */
#define GFXTIM_EVCR_EV2EN              GFXTIM_EVCR_EV2EN_Msk

#define GFXTIM_EVCR_EV3EN_Pos          (2U)
#define GFXTIM_EVCR_EV3EN_Msk          (0x1UL << GFXTIM_EVCR_EV3EN_Pos)        /*!< 0x00000004 */
#define GFXTIM_EVCR_EV3EN              GFXTIM_EVCR_EV3EN_Msk

#define GFXTIM_EVCR_EV4EN_Pos          (3U)
#define GFXTIM_EVCR_EV4EN_Msk          (0x1UL << GFXTIM_EVCR_EV4EN_Pos)        /*!< 0x00000008 */
#define GFXTIM_EVCR_EV4EN              GFXTIM_EVCR_EV4EN_Msk

/******************  Bits definition for GFXTIM_EVSR register  ****************/
#define GFXTIM_EVSR_LES1_Pos           (0U)
#define GFXTIM_EVSR_LES1_Msk           (0x7UL << GFXTIM_EVSR_LES1_Pos)         /*!< 0x00000007 */
#define GFXTIM_EVSR_LES1               GFXTIM_EVSR_LES1_Msk
#define GFXTIM_EVSR_LES1_0             (0x1UL << GFXTIM_EVSR_LES1_Pos)         /*!< 0x00000001 */
#define GFXTIM_EVSR_LES1_1             (0x2UL << GFXTIM_EVSR_LES1_Pos)         /*!< 0x00000002 */
#define GFXTIM_EVSR_LES1_2             (0x4UL << GFXTIM_EVSR_LES1_Pos)         /*!< 0x00000004 */

#define GFXTIM_EVSR_FES1_Pos           (4U)
#define GFXTIM_EVSR_FES1_Msk           (0x7UL << GFXTIM_EVSR_FES1_Pos)         /*!< 0x00000070 */
#define GFXTIM_EVSR_FES1               GFXTIM_EVSR_FES1_Msk
#define GFXTIM_EVSR_FES1_0             (0x1UL << GFXTIM_EVSR_FES1_Pos)         /*!< 0x00000010 */
#define GFXTIM_EVSR_FES1_1             (0x2UL << GFXTIM_EVSR_FES1_Pos)         /*!< 0x00000020 */
#define GFXTIM_EVSR_FES1_2             (0x4UL << GFXTIM_EVSR_FES1_Pos)         /*!< 0x00000040 */

#define GFXTIM_EVSR_LES2_Pos           (8U)
#define GFXTIM_EVSR_LES2_Msk           (0x7UL << GFXTIM_EVSR_LES2_Pos)         /*!< 0x00000700 */
#define GFXTIM_EVSR_LES2               GFXTIM_EVSR_LES2_Msk
#define GFXTIM_EVSR_LES2_0             (0x1UL << GFXTIM_EVSR_LES2_Pos)         /*!< 0x00000100 */
#define GFXTIM_EVSR_LES2_1             (0x2UL << GFXTIM_EVSR_LES2_Pos)         /*!< 0x00000200 */
#define GFXTIM_EVSR_LES2_2             (0x4UL << GFXTIM_EVSR_LES2_Pos)         /*!< 0x00000400 */

#define GFXTIM_EVSR_FES2_Pos           (12U)
#define GFXTIM_EVSR_FES2_Msk           (0x7UL << GFXTIM_EVSR_FES2_Pos)         /*!< 0x00007000 */
#define GFXTIM_EVSR_FES2               GFXTIM_EVSR_FES2_Msk
#define GFXTIM_EVSR_FES2_0             (0x1UL << GFXTIM_EVSR_FES2_Pos)         /*!< 0x00001000 */
#define GFXTIM_EVSR_FES2_1             (0x2UL << GFXTIM_EVSR_FES2_Pos)         /*!< 0x00002000 */
#define GFXTIM_EVSR_FES2_2             (0x4UL << GFXTIM_EVSR_FES2_Pos)         /*!< 0x00004000 */

#define GFXTIM_EVSR_LES3_Pos           (16U)
#define GFXTIM_EVSR_LES3_Msk           (0x7UL << GFXTIM_EVSR_LES3_Pos)         /*!< 0x00070000 */
#define GFXTIM_EVSR_LES3               GFXTIM_EVSR_LES3_Msk
#define GFXTIM_EVSR_LES3_0             (0x1UL << GFXTIM_EVSR_LES3_Pos)         /*!< 0x00010000 */
#define GFXTIM_EVSR_LES3_1             (0x2UL << GFXTIM_EVSR_LES3_Pos)         /*!< 0x00020000 */
#define GFXTIM_EVSR_LES3_2             (0x4UL << GFXTIM_EVSR_LES3_Pos)         /*!< 0x00040000 */

#define GFXTIM_EVSR_FES3_Pos           (20U)
#define GFXTIM_EVSR_FES3_Msk           (0x7UL << GFXTIM_EVSR_FES3_Pos)         /*!< 0x00700000 */
#define GFXTIM_EVSR_FES3               GFXTIM_EVSR_FES3_Msk
#define GFXTIM_EVSR_FES3_0             (0x1UL << GFXTIM_EVSR_FES3_Pos)         /*!< 0x00100000 */
#define GFXTIM_EVSR_FES3_1             (0x2UL << GFXTIM_EVSR_FES3_Pos)         /*!< 0x00200000 */
#define GFXTIM_EVSR_FES3_2             (0x4UL << GFXTIM_EVSR_FES3_Pos)         /*!< 0x00400000 */

#define GFXTIM_EVSR_LES4_Pos           (24U)
#define GFXTIM_EVSR_LES4_Msk           (0x7UL << GFXTIM_EVSR_LES4_Pos)         /*!< 0x07000000 */
#define GFXTIM_EVSR_LES4               GFXTIM_EVSR_LES4_Msk
#define GFXTIM_EVSR_LES4_0             (0x1UL << GFXTIM_EVSR_LES4_Pos)         /*!< 0x01000000 */
#define GFXTIM_EVSR_LES4_1             (0x2UL << GFXTIM_EVSR_LES4_Pos)         /*!< 0x02000000 */
#define GFXTIM_EVSR_LES4_2             (0x4UL << GFXTIM_EVSR_LES4_Pos)         /*!< 0x04000000 */

#define GFXTIM_EVSR_FES4_Pos           (28U)
#define GFXTIM_EVSR_FES4_Msk           (0x7UL << GFXTIM_EVSR_FES4_Pos)         /*!< 0x70000000 */
#define GFXTIM_EVSR_FES4               GFXTIM_EVSR_FES4_Msk
#define GFXTIM_EVSR_FES4_0             (0x1UL << GFXTIM_EVSR_FES4_Pos)         /*!< 0x10000000 */
#define GFXTIM_EVSR_FES4_1             (0x2UL << GFXTIM_EVSR_FES4_Pos)         /*!< 0x20000000 */
#define GFXTIM_EVSR_FES4_2             (0x4UL << GFXTIM_EVSR_FES4_Pos)         /*!< 0x40000000 */

/******************  Bits definition for GFXTIM_WDGTCR register  **************/
#define GFXTIM_WDGTCR_WDGEN_Pos        (0U)
#define GFXTIM_WDGTCR_WDGEN_Msk        (0x1UL << GFXTIM_WDGTCR_WDGEN_Pos)      /*!< 0x00000001 */
#define GFXTIM_WDGTCR_WDGEN            GFXTIM_WDGTCR_WDGEN_Msk

#define GFXTIM_WDGTCR_WDGDIS_Pos       (1U)
#define GFXTIM_WDGTCR_WDGDIS_Msk       (0x1UL << GFXTIM_WDGTCR_WDGDIS_Pos)     /*!< 0x00000002 */
#define GFXTIM_WDGTCR_WDGDIS           GFXTIM_WDGTCR_WDGDIS_Msk

#define GFXTIM_WDGTCR_WDGS_Pos         (2U)
#define GFXTIM_WDGTCR_WDGS_Msk         (0x1UL << GFXTIM_WDGTCR_WDGS_Pos)       /*!< 0x00000004 */
#define GFXTIM_WDGTCR_WDGS             GFXTIM_WDGTCR_WDGS_Msk

#define GFXTIM_WDGTCR_WDGHRC_Pos       (4U)
#define GFXTIM_WDGTCR_WDGHRC_Msk       (0x3UL << GFXTIM_WDGTCR_WDGHRC_Pos)     /*!< 0x00000030 */
#define GFXTIM_WDGTCR_WDGHRC           GFXTIM_WDGTCR_WDGHRC_Msk
#define GFXTIM_WDGTCR_WDGHRC_0         (0x1UL << GFXTIM_WDGTCR_WDGHRC_Pos)     /*!< 0x00000010 */
#define GFXTIM_WDGTCR_WDGHRC_1         (0x2UL << GFXTIM_WDGTCR_WDGHRC_Pos)     /*!< 0x00000020 */

#define GFXTIM_WDGTCR_WDGCS_Pos        (8U)
#define GFXTIM_WDGTCR_WDGCS_Msk        (0xFUL << GFXTIM_WDGTCR_WDGCS_Pos)      /*!< 0x00000700 */
#define GFXTIM_WDGTCR_WDGCS            GFXTIM_WDGTCR_WDGCS_Msk
#define GFXTIM_WDGTCR_WDGCS_0          (0x1UL << GFXTIM_WDGTCR_WDGCS_Pos)      /*!< 0x00000100 */
#define GFXTIM_WDGTCR_WDGCS_1          (0x2UL << GFXTIM_WDGTCR_WDGCS_Pos)      /*!< 0x00000200 */
#define GFXTIM_WDGTCR_WDGCS_2          (0x4UL << GFXTIM_WDGTCR_WDGCS_Pos)      /*!< 0x00000400 */
#define GFXTIM_WDGTCR_WDGCS_3          (0x8UL << GFXTIM_WDGTCR_WDGCS_Pos)      /*!< 0x00000800 */

#define GFXTIM_WDGTCR_FWDGR_Pos        (16U)
#define GFXTIM_WDGTCR_FWDGR_Msk        (0x1UL << GFXTIM_WDGTCR_FWDGR_Pos)      /*!< 0x00010000 */
#define GFXTIM_WDGTCR_FWDGR            GFXTIM_WDGTCR_FWDGR_Msk

/******************  Bits definition for GFXTIM_ISR register  *****************/
#define GFXTIM_ISR_AFCOF_Pos           (0U)
#define GFXTIM_ISR_AFCOF_Msk           (0x1UL << GFXTIM_ISR_AFCOF_Pos)         /*!< 0x00000001 */
#define GFXTIM_ISR_AFCOF               GFXTIM_ISR_AFCOF_Msk

#define GFXTIM_ISR_ALCOF_Pos           (1U)
#define GFXTIM_ISR_ALCOF_Msk           (0x1UL << GFXTIM_ISR_ALCOF_Pos)         /*!< 0x00000002 */
#define GFXTIM_ISR_ALCOF               GFXTIM_ISR_ALCOF_Msk

#define GFXTIM_ISR_TEF_Pos             (2U)
#define GFXTIM_ISR_TEF_Msk             (0x1UL << GFXTIM_ISR_TEF_Pos)           /*!< 0x00000004 */
#define GFXTIM_ISR_TEF                 GFXTIM_ISR_TEF_Msk

#define GFXTIM_ISR_AFCC1F_Pos          (4U)
#define GFXTIM_ISR_AFCC1F_Msk          (0x1UL << GFXTIM_ISR_AFCC1F_Pos)        /*!< 0x00000010 */
#define GFXTIM_ISR_AFCC1F              GFXTIM_ISR_AFCC1F_Msk

#define GFXTIM_ISR_ALCC1F_Pos          (8U)
#define GFXTIM_ISR_ALCC1F_Msk          (0x1UL << GFXTIM_ISR_ALCC1F_Pos)        /*!< 0x00000100 */
#define GFXTIM_ISR_ALCC1F              GFXTIM_ISR_ALCC1F_Msk

#define GFXTIM_ISR_ALCC2F_Pos          (9U)
#define GFXTIM_ISR_ALCC2F_Msk          (0x1UL << GFXTIM_ISR_ALCC2F_Pos)        /*!< 0x00000200 */
#define GFXTIM_ISR_ALCC2F              GFXTIM_ISR_ALCC2F_Msk

#define GFXTIM_ISR_RFC1RF_Pos          (12U)
#define GFXTIM_ISR_RFC1RF_Msk          (0x1UL << GFXTIM_ISR_RFC1RF_Pos)        /*!< 0x00001000 */
#define GFXTIM_ISR_RFC1RF              GFXTIM_ISR_RFC1RF_Msk

#define GFXTIM_ISR_RFC2RF_Pos          (13U)
#define GFXTIM_ISR_RFC2RF_Msk          (0x1UL << GFXTIM_ISR_RFC2RF_Pos)        /*!< 0x00002000 */
#define GFXTIM_ISR_RFC2RF              GFXTIM_ISR_RFC2RF_Msk

#define GFXTIM_ISR_EV1F_Pos            (16U)
#define GFXTIM_ISR_EV1F_Msk            (0x1UL << GFXTIM_ISR_EV1F_Pos)          /*!< 0x00010000 */
#define GFXTIM_ISR_EV1F                GFXTIM_ISR_EV1F_Msk

#define GFXTIM_ISR_EV2F_Pos            (17U)
#define GFXTIM_ISR_EV2F_Msk            (0x1UL << GFXTIM_ISR_EV2F_Pos)          /*!< 0x00020000 */
#define GFXTIM_ISR_EV2F                GFXTIM_ISR_EV2F_Msk

#define GFXTIM_ISR_EV3F_Pos            (18U)
#define GFXTIM_ISR_EV3F_Msk            (0x1UL << GFXTIM_ISR_EV3F_Pos)          /*!< 0x00040000 */
#define GFXTIM_ISR_EV3F                GFXTIM_ISR_EV3F_Msk

#define GFXTIM_ISR_EV4F_Pos            (19U)
#define GFXTIM_ISR_EV4F_Msk            (0x1UL << GFXTIM_ISR_EV4F_Pos)          /*!< 0x00080000 */
#define GFXTIM_ISR_EV4F                GFXTIM_ISR_EV4F_Msk

#define GFXTIM_ISR_WDGAF_Pos           (24U)
#define GFXTIM_ISR_WDGAF_Msk           (0x1UL << GFXTIM_ISR_WDGAF_Pos)         /*!< 0x01000000 */
#define GFXTIM_ISR_WDGAF               GFXTIM_ISR_WDGAF_Msk

#define GFXTIM_ISR_WDGPF_Pos           (25U)
#define GFXTIM_ISR_WDGPF_Msk           (0x1UL << GFXTIM_ISR_WDGPF_Pos)         /*!< 0x02000000 */
#define GFXTIM_ISR_WDGPF               GFXTIM_ISR_WDGPF_Msk

/******************  Bits definition for GFXTIM_ICR register  *****************/
#define GFXTIM_ICR_CAFCOF_Pos          (0U)
#define GFXTIM_ICR_CAFCOF_Msk          (0x1UL << GFXTIM_ICR_CAFCOF_Pos)        /*!< 0x00000001 */
#define GFXTIM_ICR_CAFCOF              GFXTIM_ICR_CAFCOF_Msk

#define GFXTIM_ICR_CALCOF_Pos          (1U)
#define GFXTIM_ICR_CALCOF_Msk          (0x1UL << GFXTIM_ICR_CALCOF_Pos)        /*!< 0x00000002 */
#define GFXTIM_ICR_CALCOF              GFXTIM_ICR_CALCOF_Msk

#define GFXTIM_ICR_CTEF_Pos            (2U)
#define GFXTIM_ICR_CTEF_Msk            (0x1UL << GFXTIM_ICR_CTEF_Pos)          /*!< 0x00000004 */
#define GFXTIM_ICR_CTEF                GFXTIM_ICR_CTEF_Msk

#define GFXTIM_ICR_CAFCC1F_Pos         (4U)
#define GFXTIM_ICR_CAFCC1F_Msk         (0x1UL << GFXTIM_ICR_CAFCC1F_Pos)       /*!< 0x00000010 */
#define GFXTIM_ICR_CAFCC1F             GFXTIM_ICR_CAFCC1F_Msk

#define GFXTIM_ICR_CALCC1F_Pos         (8U)
#define GFXTIM_ICR_CALCC1F_Msk         (0x1UL << GFXTIM_ICR_CALCC1F_Pos)       /*!< 0x00000100 */
#define GFXTIM_ICR_CALCC1F             GFXTIM_ICR_CALCC1F_Msk

#define GFXTIM_ICR_CALCC2F_Pos         (9U)
#define GFXTIM_ICR_CALCC2F_Msk         (0x1UL << GFXTIM_ICR_CALCC2F_Pos)       /*!< 0x00000200 */
#define GFXTIM_ICR_CALCC2F             GFXTIM_ICR_CALCC2F_Msk

#define GFXTIM_ICR_CRFC1RF_Pos         (12U)
#define GFXTIM_ICR_CRFC1RF_Msk         (0x1UL << GFXTIM_ICR_CRFC1RF_Pos)       /*!< 0x00001000 */
#define GFXTIM_ICR_CRFC1RF             GFXTIM_ICR_CRFC1RF_Msk

#define GFXTIM_ICR_CRFC2RF_Pos         (13U)
#define GFXTIM_ICR_CRFC2RF_Msk         (0x1UL << GFXTIM_ICR_CRFC2RF_Pos)       /*!< 0x00002000 */
#define GFXTIM_ICR_CRFC2RF             GFXTIM_ICR_CRFC2RF_Msk

#define GFXTIM_ICR_CEV1F_Pos           (16U)
#define GFXTIM_ICR_CEV1F_Msk           (0x1UL << GFXTIM_ICR_CEV1F_Pos)         /*!< 0x00010000 */
#define GFXTIM_ICR_CEV1F               GFXTIM_ICR_CEV1F_Msk

#define GFXTIM_ICR_CEV2F_Pos           (17U)
#define GFXTIM_ICR_CEV2F_Msk           (0x1UL << GFXTIM_ICR_CEV2F_Pos)         /*!< 0x00020000 */
#define GFXTIM_ICR_CEV2F               GFXTIM_ICR_CEV2F_Msk

#define GFXTIM_ICR_CEV3F_Pos           (18U)
#define GFXTIM_ICR_CEV3F_Msk           (0x1UL << GFXTIM_ICR_CEV3F_Pos)         /*!< 0x00040000 */
#define GFXTIM_ICR_CEV3F               GFXTIM_ICR_CEV3F_Msk

#define GFXTIM_ICR_CEV4F_Pos           (19U)
#define GFXTIM_ICR_CEV4F_Msk           (0x1UL << GFXTIM_ICR_CEV4F_Pos)         /*!< 0x00080000 */
#define GFXTIM_ICR_CEV4F               GFXTIM_ICR_CEV4F_Msk

#define GFXTIM_ICR_CWDGAF_Pos          (24U)
#define GFXTIM_ICR_CWDGAF_Msk          (0x1UL << GFXTIM_ICR_CWDGAF_Pos)        /*!< 0x01000000 */
#define GFXTIM_ICR_CWDGAF              GFXTIM_ICR_CWDGAF_Msk

#define GFXTIM_ICR_CWDGPF_Pos          (25U)
#define GFXTIM_ICR_CWDGPF_Msk          (0x1UL << GFXTIM_ICR_CWDGPF_Pos)        /*!< 0x02000000 */
#define GFXTIM_ICR_CWDGPF              GFXTIM_ICR_CWDGPF_Msk

/******************  Bits definition for GFXTIM_IER register  *****************/
#define GFXTIM_IER_AFCOIE_Pos          (0U)
#define GFXTIM_IER_AFCOIE_Msk          (0x1UL << GFXTIM_IER_AFCOIE_Pos)        /*!< 0x00000001 */
#define GFXTIM_IER_AFCOIE              GFXTIM_IER_AFCOIE_Msk

#define GFXTIM_IER_ALCOIE_Pos          (1U)
#define GFXTIM_IER_ALCOIE_Msk          (0x1UL << GFXTIM_IER_ALCOIE_Pos)        /*!< 0x00000002 */
#define GFXTIM_IER_ALCOIE              GFXTIM_IER_ALCOIE_Msk

#define GFXTIM_IER_TEIE_Pos            (2U)
#define GFXTIM_IER_TEIE_Msk            (0x1UL << GFXTIM_IER_TEIE_Pos)          /*!< 0x00000004 */
#define GFXTIM_IER_TEIE                GFXTIM_IER_TEIE_Msk

#define GFXTIM_IER_AFCC1IE_Pos         (4U)
#define GFXTIM_IER_AFCC1IE_Msk         (0x1UL << GFXTIM_IER_AFCC1IE_Pos)       /*!< 0x00000010 */
#define GFXTIM_IER_AFCC1IE             GFXTIM_IER_AFCC1IE_Msk

#define GFXTIM_IER_ALCC1IE_Pos         (8U)
#define GFXTIM_IER_ALCC1IE_Msk         (0x1UL << GFXTIM_IER_ALCC1IE_Pos)       /*!< 0x00000100 */
#define GFXTIM_IER_ALCC1IE             GFXTIM_IER_ALCC1IE_Msk

#define GFXTIM_IER_ALCC2IE_Pos         (9U)
#define GFXTIM_IER_ALCC2IE_Msk         (0x1UL << GFXTIM_IER_ALCC2IE_Pos)       /*!< 0x00000200 */
#define GFXTIM_IER_ALCC2IE             GFXTIM_IER_ALCC2IE_Msk

#define GFXTIM_IER_RFC1RIE_Pos         (12U)
#define GFXTIM_IER_RFC1RIE_Msk         (0x1UL << GFXTIM_IER_RFC1RIE_Pos)       /*!< 0x00001000 */
#define GFXTIM_IER_RFC1RIE             GFXTIM_IER_RFC1RIE_Msk

#define GFXTIM_IER_RFC2RIE_Pos         (13U)
#define GFXTIM_IER_RFC2RIE_Msk         (0x1UL << GFXTIM_IER_RFC2RIE_Pos)       /*!< 0x00002000 */
#define GFXTIM_IER_RFC2RIE             GFXTIM_IER_RFC2RIE_Msk

#define GFXTIM_IER_EV1IE_Pos           (16U)
#define GFXTIM_IER_EV1IE_Msk           (0x1UL << GFXTIM_IER_EV1IE_Pos)         /*!< 0x00010000 */
#define GFXTIM_IER_EV1IE               GFXTIM_IER_EV1IE_Msk

#define GFXTIM_IER_EV2IE_Pos           (17U)
#define GFXTIM_IER_EV2IE_Msk           (0x1UL << GFXTIM_IER_EV2IE_Pos)         /*!< 0x00020000 */
#define GFXTIM_IER_EV2IE               GFXTIM_IER_EV2IE_Msk

#define GFXTIM_IER_EV3IE_Pos           (18U)
#define GFXTIM_IER_EV3IE_Msk           (0x1UL << GFXTIM_IER_EV3IE_Pos)         /*!< 0x00040000 */
#define GFXTIM_IER_EV3IE               GFXTIM_IER_EV3IE_Msk

#define GFXTIM_IER_EV4IE_Pos           (19U)
#define GFXTIM_IER_EV4IE_Msk           (0x1UL << GFXTIM_IER_EV4IE_Pos)         /*!< 0x00080000 */
#define GFXTIM_IER_EV4IE               GFXTIM_IER_EV4IE_Msk

#define GFXTIM_IER_WDGAIE_Pos          (24U)
#define GFXTIM_IER_WDGAIE_Msk          (0x1UL << GFXTIM_IER_WDGAIE_Pos)        /*!< 0x01000000 */
#define GFXTIM_IER_WDGAIE              GFXTIM_IER_WDGAIE_Msk

#define GFXTIM_IER_WDGPIE_Pos          (25U)
#define GFXTIM_IER_WDGPIE_Msk          (0x1UL << GFXTIM_IER_WDGPIE_Pos)        /*!< 0x02000000 */
#define GFXTIM_IER_WDGPIE              GFXTIM_IER_WDGPIE_Msk

/******************  Bits definition for GFXTIM_TSR register  *****************/
#define GFXTIM_TSR_AFCS_Pos            (0U)
#define GFXTIM_TSR_AFCS_Msk            (0x1UL << GFXTIM_TSR_AFCS_Pos)          /*!< 0x00000001 */
#define GFXTIM_TSR_AFCS                GFXTIM_TSR_AFCS_Msk

#define GFXTIM_TSR_ALCS_Pos            (4U)
#define GFXTIM_TSR_ALCS_Msk            (0x1UL << GFXTIM_TSR_ALCS_Pos)          /*!< 0x00000010 */
#define GFXTIM_TSR_ALCS                GFXTIM_TSR_ALCS_Msk

#define GFXTIM_TSR_RFC1S_Pos           (16U)
#define GFXTIM_TSR_RFC1S_Msk           (0x1UL << GFXTIM_TSR_RFC1S_Pos)         /*!< 0x00010000 */
#define GFXTIM_TSR_RFC1S               GFXTIM_TSR_RFC1S_Msk

#define GFXTIM_TSR_RFC2S_Pos           (20U)
#define GFXTIM_TSR_RFC2S_Msk           (0x1UL << GFXTIM_TSR_RFC2S_Pos)         /*!< 0x00100000 */
#define GFXTIM_TSR_RFC2S               GFXTIM_TSR_RFC2S_Msk

/******************  Bits definition for GFXTIM_LCCRR register  ***************/
#define GFXTIM_LCCRR_RELOAD_Pos        (0U)
#define GFXTIM_LCCRR_RELOAD_Msk        (0x3FFFFFUL << GFXTIM_LCCRR_RELOAD_Pos) /*!< 0x003FFFFF */
#define GFXTIM_LCCRR_RELOAD            GFXTIM_LCCRR_RELOAD_Msk

/******************  Bits definition for GFXTIM_FCCRR register  ***************/
#define GFXTIM_FCCRR_RELOAD_Pos        (0U)
#define GFXTIM_FCCRR_RELOAD_Msk        (0xFFFUL << GFXTIM_FCCRR_RELOAD_Pos)    /*!< 0x00000FFF */
#define GFXTIM_FCCRR_RELOAD            GFXTIM_FCCRR_RELOAD_Msk

/******************  Bits definition for GFXTIM_ATR register  *****************/
#define GFXTIM_ATR_LINE_Pos            (0U)
#define GFXTIM_ATR_LINE_Msk            (0xFFFUL << GFXTIM_ATR_LINE_Pos)        /*!< 0x00000FFF */
#define GFXTIM_ATR_LINE                GFXTIM_ATR_LINE_Msk

#define GFXTIM_ATR_FRAME_Pos           (12U)
#define GFXTIM_ATR_FRAME_Msk           (0xFFFFFUL << GFXTIM_ATR_FRAME_Pos)     /*!< 0xFFFFF000 */
#define GFXTIM_ATR_FRAME               GFXTIM_ATR_FRAME_Msk

/******************  Bits definition for GFXTIM_AFCR register  ****************/
#define GFXTIM_AFCR_FRAME_Pos          (0U)
#define GFXTIM_AFCR_FRAME_Msk          (0xFFFFFUL << GFXTIM_AFCR_FRAME_Pos)    /*!< 0x000FFFFF */
#define GFXTIM_AFCR_FRAME              GFXTIM_AFCR_FRAME_Msk

/******************  Bits definition for GFXTIM_ALCR register  ****************/
#define GFXTIM_ALCR_LINE_Pos           (0U)
#define GFXTIM_ALCR_LINE_Msk           (0xFFFUL << GFXTIM_ALCR_LINE_Pos)       /*!< 0x00000FFF */
#define GFXTIM_ALCR_LINE               GFXTIM_ALCR_LINE_Msk

/******************  Bits definition for GFXTIM_AFCC1R register  **************/
#define GFXTIM_AFCC1R_FRAME_Pos        (0U)
#define GFXTIM_AFCC1R_FRAME_Msk        (0xFFFFFUL << GFXTIM_AFCC1R_FRAME_Pos)  /*!< 0x000FFFFF */
#define GFXTIM_AFCC1R_FRAME            GFXTIM_AFCC1R_FRAME_Msk

/******************  Bits definition for GFXTIM_ALCC1R register  **************/
#define GFXTIM_ALCC1R_LINE_Pos         (0U)
#define GFXTIM_ALCC1R_LINE_Msk         (0xFFFUL << GFXTIM_ALCC1R_LINE_Pos)     /*!< 0x00000FFF */
#define GFXTIM_ALCC1R_LINE             GFXTIM_ALCC1R_LINE_Msk

/******************  Bits definition for GFXTIM_ALCC2R register  **************/
#define GFXTIM_ALCC2R_LINE_Pos         (0U)
#define GFXTIM_ALCC2R_LINE_Msk         (0xFFFUL << GFXTIM_ALCC2R_LINE_Pos)     /*!< 0x00000FFF */
#define GFXTIM_ALCC2R_LINE             GFXTIM_ALCC2R_LINE_Msk

/******************  Bits definition for GFXTIM_RFC1R register  ***************/
#define GFXTIM_RFC1R_FRAME_Pos         (0U)
#define GFXTIM_RFC1R_FRAME_Msk         (0xFFFUL << GFXTIM_RFC1R_FRAME_Pos)     /*!< 0x00000FFF */
#define GFXTIM_RFC1R_FRAME             GFXTIM_RFC1R_FRAME_Msk

/******************  Bits definition for GFXTIM_RFC1RR register  **************/
#define GFXTIM_RFC1RR_FRAME_Pos        (0U)
#define GFXTIM_RFC1RR_FRAME_Msk        (0xFFFUL << GFXTIM_RFC1RR_FRAME_Pos)    /*!< 0x00000FFF */
#define GFXTIM_RFC1RR_FRAME            GFXTIM_RFC1RR_FRAME_Msk

/******************  Bits definition for GFXTIM_RFC2R register  ***************/
#define GFXTIM_RFC2R_FRAME_Pos         (0U)
#define GFXTIM_RFC2R_FRAME_Msk         (0xFFFUL << GFXTIM_RFC2R_FRAME_Pos)     /*!< 0x00000FFF */
#define GFXTIM_RFC2R_FRAME             GFXTIM_RFC2R_FRAME_Msk

/******************  Bits definition for GFXTIM_RFC2RR register  **************/
#define GFXTIM_RFC2RR_FRAME_Pos        (0U)
#define GFXTIM_RFC2RR_FRAME_Msk        (0xFFFUL << GFXTIM_RFC2RR_FRAME_Pos)    /*!< 0x00000FFF */
#define GFXTIM_RFC2RR_FRAME            GFXTIM_RFC2RR_FRAME_Msk

/******************  Bits definition for GFXTIM_WDGCR register  ***************/
#define GFXTIM_WDGCR_VALUE_Pos         (0U)
#define GFXTIM_WDGCR_VALUE_Msk         (0xFFFFUL << GFXTIM_WDGCR_VALUE_Pos)    /*!< 0x0000FFFF */
#define GFXTIM_WDGCR_VALUE             GFXTIM_WDGCR_VALUE_Msk

/******************  Bits definition for GFXTIM_WDGRR register  ***************/
#define GFXTIM_WDGRR_RELOAD_Pos        (0U)
#define GFXTIM_WDGRR_RELOAD_Msk        (0xFFFFUL << GFXTIM_WDGRR_RELOAD_Pos)   /*!< 0x0000FFFF */
#define GFXTIM_WDGRR_RELOAD            GFXTIM_WDGRR_RELOAD_Msk

/******************  Bits definition for GFXTIM_WDGPAR register  **************/
#define GFXTIM_WDGPAR_PREALARM_Pos      (0U)
#define GFXTIM_WDGPAR_PREALARM_Msk     (0xFFFFUL << GFXTIM_WDGPAR_PREALARM_Pos)/*!< 0x0000FFFF */
#define GFXTIM_WDGPAR_PREALARM          GFXTIM_WDGPAR_PREALARM_Msk

/******************  Bits definition for GFXTIM_HWCFGR register  **************/

/******************  Bits definition for GFXTIM_VERR register  ****************/
#define GFXTIM_VERR_MINREV_Pos         (0U)
#define GFXTIM_VERR_MINREV_Msk         (0xFUL << GFXTIM_VERR_MINREV_Pos)       /*!< 0x0000000F */
#define GFXTIM_VERR_MINREV             GFXTIM_VERR_MINREV_Msk

#define GFXTIM_VERR_MAJREV_Pos         (4U)
#define GFXTIM_VERR_MAJREV_Msk         (0xFUL << GFXTIM_VERR_MAJREV_Pos)       /*!< 0x000000F0 */
#define GFXTIM_VERR_MAJREV             GFXTIM_VERR_MAJREV_Msk

/******************  Bits definition for GFXTIM_IPIDR register  ***************/
#define GFXTIM_IPIDR_ID_Pos            (0U)
#define GFXTIM_IPIDR_ID_Msk            (0xFFFFFFFFUL << GFXTIM_IPIDR_ID_Pos)   /*!< 0xFFFFFFFF */
#define GFXTIM_IPIDR_ID                GFXTIM_IPIDR_ID_Msk

/******************  Bits definition for GFXTIM_SIDR register  ****************/
#define GFXTIM_SIDR_SID_Pos            (0U)
#define GFXTIM_SIDR_SID_Msk            (0xFFFFFFFFUL << GFXTIM_SIDR_SID_Pos)   /*!< 0xFFFFFFFF */
#define GFXTIM_SIDR_SID                GFXTIM_SIDR_SID_Msk

/******************************************************************************/
/*                                                                            */
/*                       General Purpose IOs (GPIO)                           */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for GPIO_MODER register  *****************/
#define GPIO_MODER_MODE0_Pos                (0U)
#define GPIO_MODER_MODE0_Msk                (0x3UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000003 */
#define GPIO_MODER_MODE0                    GPIO_MODER_MODE0_Msk
#define GPIO_MODER_MODE0_0                  (0x1UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000001 */
#define GPIO_MODER_MODE0_1                  (0x2UL << GPIO_MODER_MODE0_Pos)         /*!< 0x00000002 */
#define GPIO_MODER_MODE1_Pos                (2U)
#define GPIO_MODER_MODE1_Msk                (0x3UL << GPIO_MODER_MODE1_Pos)         /*!< 0x0000000C */
#define GPIO_MODER_MODE1                    GPIO_MODER_MODE1_Msk
#define GPIO_MODER_MODE1_0                  (0x1UL << GPIO_MODER_MODE1_Pos)         /*!< 0x00000004 */
#define GPIO_MODER_MODE1_1                  (0x2UL << GPIO_MODER_MODE1_Pos)         /*!< 0x00000008 */
#define GPIO_MODER_MODE2_Pos                (4U)
#define GPIO_MODER_MODE2_Msk                (0x3UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000030 */
#define GPIO_MODER_MODE2                    GPIO_MODER_MODE2_Msk
#define GPIO_MODER_MODE2_0                  (0x1UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000010 */
#define GPIO_MODER_MODE2_1                  (0x2UL << GPIO_MODER_MODE2_Pos)         /*!< 0x00000020 */
#define GPIO_MODER_MODE3_Pos                (6U)
#define GPIO_MODER_MODE3_Msk                (0x3UL << GPIO_MODER_MODE3_Pos)         /*!< 0x000000C0 */
#define GPIO_MODER_MODE3                    GPIO_MODER_MODE3_Msk
#define GPIO_MODER_MODE3_0                  (0x1UL << GPIO_MODER_MODE3_Pos)         /*!< 0x00000040 */
#define GPIO_MODER_MODE3_1                  (0x2UL << GPIO_MODER_MODE3_Pos)         /*!< 0x00000080 */
#define GPIO_MODER_MODE4_Pos                (8U)
#define GPIO_MODER_MODE4_Msk                (0x3UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000300 */
#define GPIO_MODER_MODE4                    GPIO_MODER_MODE4_Msk
#define GPIO_MODER_MODE4_0                  (0x1UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000100 */
#define GPIO_MODER_MODE4_1                  (0x2UL << GPIO_MODER_MODE4_Pos)         /*!< 0x00000200 */
#define GPIO_MODER_MODE5_Pos                (10U)
#define GPIO_MODER_MODE5_Msk                (0x3UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000C00 */
#define GPIO_MODER_MODE5                    GPIO_MODER_MODE5_Msk
#define GPIO_MODER_MODE5_0                  (0x1UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000400 */
#define GPIO_MODER_MODE5_1                  (0x2UL << GPIO_MODER_MODE5_Pos)         /*!< 0x00000800 */
#define GPIO_MODER_MODE6_Pos                (12U)
#define GPIO_MODER_MODE6_Msk                (0x3UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00003000 */
#define GPIO_MODER_MODE6                    GPIO_MODER_MODE6_Msk
#define GPIO_MODER_MODE6_0                  (0x1UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00001000 */
#define GPIO_MODER_MODE6_1                  (0x2UL << GPIO_MODER_MODE6_Pos)         /*!< 0x00002000 */
#define GPIO_MODER_MODE7_Pos                (14U)
#define GPIO_MODER_MODE7_Msk                (0x3UL << GPIO_MODER_MODE7_Pos)         /*!< 0x0000C000 */
#define GPIO_MODER_MODE7                    GPIO_MODER_MODE7_Msk
#define GPIO_MODER_MODE7_0                  (0x1UL << GPIO_MODER_MODE7_Pos)         /*!< 0x00004000 */
#define GPIO_MODER_MODE7_1                  (0x2UL << GPIO_MODER_MODE7_Pos)         /*!< 0x00008000 */
#define GPIO_MODER_MODE8_Pos                (16U)
#define GPIO_MODER_MODE8_Msk                (0x3UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00030000 */
#define GPIO_MODER_MODE8                    GPIO_MODER_MODE8_Msk
#define GPIO_MODER_MODE8_0                  (0x1UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00010000 */
#define GPIO_MODER_MODE8_1                  (0x2UL << GPIO_MODER_MODE8_Pos)         /*!< 0x00020000 */
#define GPIO_MODER_MODE9_Pos                (18U)
#define GPIO_MODER_MODE9_Msk                (0x3UL << GPIO_MODER_MODE9_Pos)         /*!< 0x000C0000 */
#define GPIO_MODER_MODE9                    GPIO_MODER_MODE9_Msk
#define GPIO_MODER_MODE9_0                  (0x1UL << GPIO_MODER_MODE9_Pos)         /*!< 0x00040000 */
#define GPIO_MODER_MODE9_1                  (0x2UL << GPIO_MODER_MODE9_Pos)         /*!< 0x00080000 */
#define GPIO_MODER_MODE10_Pos               (20U)
#define GPIO_MODER_MODE10_Msk               (0x3UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00300000 */
#define GPIO_MODER_MODE10                   GPIO_MODER_MODE10_Msk
#define GPIO_MODER_MODE10_0                 (0x1UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00100000 */
#define GPIO_MODER_MODE10_1                 (0x2UL << GPIO_MODER_MODE10_Pos)        /*!< 0x00200000 */
#define GPIO_MODER_MODE11_Pos               (22U)
#define GPIO_MODER_MODE11_Msk               (0x3UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00C00000 */
#define GPIO_MODER_MODE11                   GPIO_MODER_MODE11_Msk
#define GPIO_MODER_MODE11_0                 (0x1UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00400000 */
#define GPIO_MODER_MODE11_1                 (0x2UL << GPIO_MODER_MODE11_Pos)        /*!< 0x00800000 */
#define GPIO_MODER_MODE12_Pos               (24U)
#define GPIO_MODER_MODE12_Msk               (0x3UL << GPIO_MODER_MODE12_Pos)        /*!< 0x03000000 */
#define GPIO_MODER_MODE12                   GPIO_MODER_MODE12_Msk
#define GPIO_MODER_MODE12_0                 (0x1UL << GPIO_MODER_MODE12_Pos)        /*!< 0x01000000 */
#define GPIO_MODER_MODE12_1                 (0x2UL << GPIO_MODER_MODE12_Pos)        /*!< 0x02000000 */
#define GPIO_MODER_MODE13_Pos               (26U)
#define GPIO_MODER_MODE13_Msk               (0x3UL << GPIO_MODER_MODE13_Pos)        /*!< 0x0C000000 */
#define GPIO_MODER_MODE13                   GPIO_MODER_MODE13_Msk
#define GPIO_MODER_MODE13_0                 (0x1UL << GPIO_MODER_MODE13_Pos)        /*!< 0x04000000 */
#define GPIO_MODER_MODE13_1                 (0x2UL << GPIO_MODER_MODE13_Pos)        /*!< 0x08000000 */
#define GPIO_MODER_MODE14_Pos               (28U)
#define GPIO_MODER_MODE14_Msk               (0x3UL << GPIO_MODER_MODE14_Pos)        /*!< 0x30000000 */
#define GPIO_MODER_MODE14                   GPIO_MODER_MODE14_Msk
#define GPIO_MODER_MODE14_0                 (0x1UL << GPIO_MODER_MODE14_Pos)        /*!< 0x10000000 */
#define GPIO_MODER_MODE14_1                 (0x2UL << GPIO_MODER_MODE14_Pos)        /*!< 0x20000000 */
#define GPIO_MODER_MODE15_Pos               (30U)
#define GPIO_MODER_MODE15_Msk               (0x3UL << GPIO_MODER_MODE15_Pos)        /*!< 0xC0000000 */
#define GPIO_MODER_MODE15                   GPIO_MODER_MODE15_Msk
#define GPIO_MODER_MODE15_0                 (0x1UL << GPIO_MODER_MODE15_Pos)        /*!< 0x40000000 */
#define GPIO_MODER_MODE15_1                 (0x2UL << GPIO_MODER_MODE15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_OTYPER register  ****************/
#define GPIO_OTYPER_OT0_Pos                 (0U)
#define GPIO_OTYPER_OT0_Msk                 (0x1UL << GPIO_OTYPER_OT0_Pos)          /*!< 0x00000001 */
#define GPIO_OTYPER_OT0                     GPIO_OTYPER_OT0_Msk
#define GPIO_OTYPER_OT1_Pos                 (1U)
#define GPIO_OTYPER_OT1_Msk                 (0x1UL << GPIO_OTYPER_OT1_Pos)          /*!< 0x00000002 */
#define GPIO_OTYPER_OT1                     GPIO_OTYPER_OT1_Msk
#define GPIO_OTYPER_OT2_Pos                 (2U)
#define GPIO_OTYPER_OT2_Msk                 (0x1UL << GPIO_OTYPER_OT2_Pos)          /*!< 0x00000004 */
#define GPIO_OTYPER_OT2                     GPIO_OTYPER_OT2_Msk
#define GPIO_OTYPER_OT3_Pos                 (3U)
#define GPIO_OTYPER_OT3_Msk                 (0x1UL << GPIO_OTYPER_OT3_Pos)          /*!< 0x00000008 */
#define GPIO_OTYPER_OT3                     GPIO_OTYPER_OT3_Msk
#define GPIO_OTYPER_OT4_Pos                 (4U)
#define GPIO_OTYPER_OT4_Msk                 (0x1UL << GPIO_OTYPER_OT4_Pos)          /*!< 0x00000010 */
#define GPIO_OTYPER_OT4                     GPIO_OTYPER_OT4_Msk
#define GPIO_OTYPER_OT5_Pos                 (5U)
#define GPIO_OTYPER_OT5_Msk                 (0x1UL << GPIO_OTYPER_OT5_Pos)          /*!< 0x00000020 */
#define GPIO_OTYPER_OT5                     GPIO_OTYPER_OT5_Msk
#define GPIO_OTYPER_OT6_Pos                 (6U)
#define GPIO_OTYPER_OT6_Msk                 (0x1UL << GPIO_OTYPER_OT6_Pos)          /*!< 0x00000040 */
#define GPIO_OTYPER_OT6                     GPIO_OTYPER_OT6_Msk
#define GPIO_OTYPER_OT7_Pos                 (7U)
#define GPIO_OTYPER_OT7_Msk                 (0x1UL << GPIO_OTYPER_OT7_Pos)          /*!< 0x00000080 */
#define GPIO_OTYPER_OT7                     GPIO_OTYPER_OT7_Msk
#define GPIO_OTYPER_OT8_Pos                 (8U)
#define GPIO_OTYPER_OT8_Msk                 (0x1UL << GPIO_OTYPER_OT8_Pos)          /*!< 0x00000100 */
#define GPIO_OTYPER_OT8                     GPIO_OTYPER_OT8_Msk
#define GPIO_OTYPER_OT9_Pos                 (9U)
#define GPIO_OTYPER_OT9_Msk                 (0x1UL << GPIO_OTYPER_OT9_Pos)          /*!< 0x00000200 */
#define GPIO_OTYPER_OT9                     GPIO_OTYPER_OT9_Msk
#define GPIO_OTYPER_OT10_Pos                (10U)
#define GPIO_OTYPER_OT10_Msk                (0x1UL << GPIO_OTYPER_OT10_Pos)         /*!< 0x00000400 */
#define GPIO_OTYPER_OT10                    GPIO_OTYPER_OT10_Msk
#define GPIO_OTYPER_OT11_Pos                (11U)
#define GPIO_OTYPER_OT11_Msk                (0x1UL << GPIO_OTYPER_OT11_Pos)         /*!< 0x00000800 */
#define GPIO_OTYPER_OT11                    GPIO_OTYPER_OT11_Msk
#define GPIO_OTYPER_OT12_Pos                (12U)
#define GPIO_OTYPER_OT12_Msk                (0x1UL << GPIO_OTYPER_OT12_Pos)         /*!< 0x00001000 */
#define GPIO_OTYPER_OT12                    GPIO_OTYPER_OT12_Msk
#define GPIO_OTYPER_OT13_Pos                (13U)
#define GPIO_OTYPER_OT13_Msk                (0x1UL << GPIO_OTYPER_OT13_Pos)         /*!< 0x00002000 */
#define GPIO_OTYPER_OT13                    GPIO_OTYPER_OT13_Msk
#define GPIO_OTYPER_OT14_Pos                (14U)
#define GPIO_OTYPER_OT14_Msk                (0x1UL << GPIO_OTYPER_OT14_Pos)         /*!< 0x00004000 */
#define GPIO_OTYPER_OT14                    GPIO_OTYPER_OT14_Msk
#define GPIO_OTYPER_OT15_Pos                (15U)
#define GPIO_OTYPER_OT15_Msk                (0x1UL << GPIO_OTYPER_OT15_Pos)         /*!< 0x00008000 */
#define GPIO_OTYPER_OT15                    GPIO_OTYPER_OT15_Msk

/******************  Bits definition for GPIO_OSPEEDR register  ***************/
#define GPIO_OSPEEDR_OSPEED0_Pos            (0U)
#define GPIO_OSPEEDR_OSPEED0_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000003 */
#define GPIO_OSPEEDR_OSPEED0                GPIO_OSPEEDR_OSPEED0_Msk
#define GPIO_OSPEEDR_OSPEED0_0              (0x1UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000001 */
#define GPIO_OSPEEDR_OSPEED0_1              (0x2UL << GPIO_OSPEEDR_OSPEED0_Pos)     /*!< 0x00000002 */
#define GPIO_OSPEEDR_OSPEED1_Pos            (2U)
#define GPIO_OSPEEDR_OSPEED1_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x0000000C */
#define GPIO_OSPEEDR_OSPEED1                GPIO_OSPEEDR_OSPEED1_Msk
#define GPIO_OSPEEDR_OSPEED1_0              (0x1UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x00000004 */
#define GPIO_OSPEEDR_OSPEED1_1              (0x2UL << GPIO_OSPEEDR_OSPEED1_Pos)     /*!< 0x00000008 */
#define GPIO_OSPEEDR_OSPEED2_Pos            (4U)
#define GPIO_OSPEEDR_OSPEED2_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000030 */
#define GPIO_OSPEEDR_OSPEED2                GPIO_OSPEEDR_OSPEED2_Msk
#define GPIO_OSPEEDR_OSPEED2_0              (0x1UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000010 */
#define GPIO_OSPEEDR_OSPEED2_1              (0x2UL << GPIO_OSPEEDR_OSPEED2_Pos)     /*!< 0x00000020 */
#define GPIO_OSPEEDR_OSPEED3_Pos            (6U)
#define GPIO_OSPEEDR_OSPEED3_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x000000C0 */
#define GPIO_OSPEEDR_OSPEED3                GPIO_OSPEEDR_OSPEED3_Msk
#define GPIO_OSPEEDR_OSPEED3_0              (0x1UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x00000040 */
#define GPIO_OSPEEDR_OSPEED3_1              (0x2UL << GPIO_OSPEEDR_OSPEED3_Pos)     /*!< 0x00000080 */
#define GPIO_OSPEEDR_OSPEED4_Pos            (8U)
#define GPIO_OSPEEDR_OSPEED4_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000300 */
#define GPIO_OSPEEDR_OSPEED4                GPIO_OSPEEDR_OSPEED4_Msk
#define GPIO_OSPEEDR_OSPEED4_0              (0x1UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000100 */
#define GPIO_OSPEEDR_OSPEED4_1              (0x2UL << GPIO_OSPEEDR_OSPEED4_Pos)     /*!< 0x00000200 */
#define GPIO_OSPEEDR_OSPEED5_Pos            (10U)
#define GPIO_OSPEEDR_OSPEED5_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000C00 */
#define GPIO_OSPEEDR_OSPEED5                GPIO_OSPEEDR_OSPEED5_Msk
#define GPIO_OSPEEDR_OSPEED5_0              (0x1UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000400 */
#define GPIO_OSPEEDR_OSPEED5_1              (0x2UL << GPIO_OSPEEDR_OSPEED5_Pos)     /*!< 0x00000800 */
#define GPIO_OSPEEDR_OSPEED6_Pos            (12U)
#define GPIO_OSPEEDR_OSPEED6_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00003000 */
#define GPIO_OSPEEDR_OSPEED6                GPIO_OSPEEDR_OSPEED6_Msk
#define GPIO_OSPEEDR_OSPEED6_0              (0x1UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00001000 */
#define GPIO_OSPEEDR_OSPEED6_1              (0x2UL << GPIO_OSPEEDR_OSPEED6_Pos)     /*!< 0x00002000 */
#define GPIO_OSPEEDR_OSPEED7_Pos            (14U)
#define GPIO_OSPEEDR_OSPEED7_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x0000C000 */
#define GPIO_OSPEEDR_OSPEED7                GPIO_OSPEEDR_OSPEED7_Msk
#define GPIO_OSPEEDR_OSPEED7_0              (0x1UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x00004000 */
#define GPIO_OSPEEDR_OSPEED7_1              (0x2UL << GPIO_OSPEEDR_OSPEED7_Pos)     /*!< 0x00008000 */
#define GPIO_OSPEEDR_OSPEED8_Pos            (16U)
#define GPIO_OSPEEDR_OSPEED8_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00030000 */
#define GPIO_OSPEEDR_OSPEED8                GPIO_OSPEEDR_OSPEED8_Msk
#define GPIO_OSPEEDR_OSPEED8_0              (0x1UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00010000 */
#define GPIO_OSPEEDR_OSPEED8_1              (0x2UL << GPIO_OSPEEDR_OSPEED8_Pos)     /*!< 0x00020000 */
#define GPIO_OSPEEDR_OSPEED9_Pos            (18U)
#define GPIO_OSPEEDR_OSPEED9_Msk            (0x3UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x000C0000 */
#define GPIO_OSPEEDR_OSPEED9                GPIO_OSPEEDR_OSPEED9_Msk
#define GPIO_OSPEEDR_OSPEED9_0              (0x1UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x00040000 */
#define GPIO_OSPEEDR_OSPEED9_1              (0x2UL << GPIO_OSPEEDR_OSPEED9_Pos)     /*!< 0x00080000 */
#define GPIO_OSPEEDR_OSPEED10_Pos           (20U)
#define GPIO_OSPEEDR_OSPEED10_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00300000 */
#define GPIO_OSPEEDR_OSPEED10               GPIO_OSPEEDR_OSPEED10_Msk
#define GPIO_OSPEEDR_OSPEED10_0             (0x1UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00100000 */
#define GPIO_OSPEEDR_OSPEED10_1             (0x2UL << GPIO_OSPEEDR_OSPEED10_Pos)    /*!< 0x00200000 */
#define GPIO_OSPEEDR_OSPEED11_Pos           (22U)
#define GPIO_OSPEEDR_OSPEED11_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00C00000 */
#define GPIO_OSPEEDR_OSPEED11               GPIO_OSPEEDR_OSPEED11_Msk
#define GPIO_OSPEEDR_OSPEED11_0             (0x1UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00400000 */
#define GPIO_OSPEEDR_OSPEED11_1             (0x2UL << GPIO_OSPEEDR_OSPEED11_Pos)    /*!< 0x00800000 */
#define GPIO_OSPEEDR_OSPEED12_Pos           (24U)
#define GPIO_OSPEEDR_OSPEED12_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x03000000 */
#define GPIO_OSPEEDR_OSPEED12               GPIO_OSPEEDR_OSPEED12_Msk
#define GPIO_OSPEEDR_OSPEED12_0             (0x1UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x01000000 */
#define GPIO_OSPEEDR_OSPEED12_1             (0x2UL << GPIO_OSPEEDR_OSPEED12_Pos)    /*!< 0x02000000 */
#define GPIO_OSPEEDR_OSPEED13_Pos           (26U)
#define GPIO_OSPEEDR_OSPEED13_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x0C000000 */
#define GPIO_OSPEEDR_OSPEED13               GPIO_OSPEEDR_OSPEED13_Msk
#define GPIO_OSPEEDR_OSPEED13_0             (0x1UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x04000000 */
#define GPIO_OSPEEDR_OSPEED13_1             (0x2UL << GPIO_OSPEEDR_OSPEED13_Pos)    /*!< 0x08000000 */
#define GPIO_OSPEEDR_OSPEED14_Pos           (28U)
#define GPIO_OSPEEDR_OSPEED14_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x30000000 */
#define GPIO_OSPEEDR_OSPEED14               GPIO_OSPEEDR_OSPEED14_Msk
#define GPIO_OSPEEDR_OSPEED14_0             (0x1UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x10000000 */
#define GPIO_OSPEEDR_OSPEED14_1             (0x2UL << GPIO_OSPEEDR_OSPEED14_Pos)    /*!< 0x20000000 */
#define GPIO_OSPEEDR_OSPEED15_Pos           (30U)
#define GPIO_OSPEEDR_OSPEED15_Msk           (0x3UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0xC0000000 */
#define GPIO_OSPEEDR_OSPEED15               GPIO_OSPEEDR_OSPEED15_Msk
#define GPIO_OSPEEDR_OSPEED15_0             (0x1UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0x40000000 */
#define GPIO_OSPEEDR_OSPEED15_1             (0x2UL << GPIO_OSPEEDR_OSPEED15_Pos)    /*!< 0x80000000 */

/******************  Bits definition for GPIO_PUPDR register  *****************/
#define GPIO_PUPDR_PUPD0_Pos                (0U)
#define GPIO_PUPDR_PUPD0_Msk                (0x3UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000003 */
#define GPIO_PUPDR_PUPD0                    GPIO_PUPDR_PUPD0_Msk
#define GPIO_PUPDR_PUPD0_0                  (0x1UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000001 */
#define GPIO_PUPDR_PUPD0_1                  (0x2UL << GPIO_PUPDR_PUPD0_Pos)         /*!< 0x00000002 */
#define GPIO_PUPDR_PUPD1_Pos                (2U)
#define GPIO_PUPDR_PUPD1_Msk                (0x3UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x0000000C */
#define GPIO_PUPDR_PUPD1                    GPIO_PUPDR_PUPD1_Msk
#define GPIO_PUPDR_PUPD1_0                  (0x1UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x00000004 */
#define GPIO_PUPDR_PUPD1_1                  (0x2UL << GPIO_PUPDR_PUPD1_Pos)         /*!< 0x00000008 */
#define GPIO_PUPDR_PUPD2_Pos                (4U)
#define GPIO_PUPDR_PUPD2_Msk                (0x3UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000030 */
#define GPIO_PUPDR_PUPD2                    GPIO_PUPDR_PUPD2_Msk
#define GPIO_PUPDR_PUPD2_0                  (0x1UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000010 */
#define GPIO_PUPDR_PUPD2_1                  (0x2UL << GPIO_PUPDR_PUPD2_Pos)         /*!< 0x00000020 */
#define GPIO_PUPDR_PUPD3_Pos                (6U)
#define GPIO_PUPDR_PUPD3_Msk                (0x3UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x000000C0 */
#define GPIO_PUPDR_PUPD3                    GPIO_PUPDR_PUPD3_Msk
#define GPIO_PUPDR_PUPD3_0                  (0x1UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x00000040 */
#define GPIO_PUPDR_PUPD3_1                  (0x2UL << GPIO_PUPDR_PUPD3_Pos)         /*!< 0x00000080 */
#define GPIO_PUPDR_PUPD4_Pos                (8U)
#define GPIO_PUPDR_PUPD4_Msk                (0x3UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000300 */
#define GPIO_PUPDR_PUPD4                    GPIO_PUPDR_PUPD4_Msk
#define GPIO_PUPDR_PUPD4_0                  (0x1UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000100 */
#define GPIO_PUPDR_PUPD4_1                  (0x2UL << GPIO_PUPDR_PUPD4_Pos)         /*!< 0x00000200 */
#define GPIO_PUPDR_PUPD5_Pos                (10U)
#define GPIO_PUPDR_PUPD5_Msk                (0x3UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000C00 */
#define GPIO_PUPDR_PUPD5                    GPIO_PUPDR_PUPD5_Msk
#define GPIO_PUPDR_PUPD5_0                  (0x1UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000400 */
#define GPIO_PUPDR_PUPD5_1                  (0x2UL << GPIO_PUPDR_PUPD5_Pos)         /*!< 0x00000800 */
#define GPIO_PUPDR_PUPD6_Pos                (12U)
#define GPIO_PUPDR_PUPD6_Msk                (0x3UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00003000 */
#define GPIO_PUPDR_PUPD6                    GPIO_PUPDR_PUPD6_Msk
#define GPIO_PUPDR_PUPD6_0                  (0x1UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00001000 */
#define GPIO_PUPDR_PUPD6_1                  (0x2UL << GPIO_PUPDR_PUPD6_Pos)         /*!< 0x00002000 */
#define GPIO_PUPDR_PUPD7_Pos                (14U)
#define GPIO_PUPDR_PUPD7_Msk                (0x3UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x0000C000 */
#define GPIO_PUPDR_PUPD7                    GPIO_PUPDR_PUPD7_Msk
#define GPIO_PUPDR_PUPD7_0                  (0x1UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x00004000 */
#define GPIO_PUPDR_PUPD7_1                  (0x2UL << GPIO_PUPDR_PUPD7_Pos)         /*!< 0x00008000 */
#define GPIO_PUPDR_PUPD8_Pos                (16U)
#define GPIO_PUPDR_PUPD8_Msk                (0x3UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00030000 */
#define GPIO_PUPDR_PUPD8                    GPIO_PUPDR_PUPD8_Msk
#define GPIO_PUPDR_PUPD8_0                  (0x1UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00010000 */
#define GPIO_PUPDR_PUPD8_1                  (0x2UL << GPIO_PUPDR_PUPD8_Pos)         /*!< 0x00020000 */
#define GPIO_PUPDR_PUPD9_Pos                (18U)
#define GPIO_PUPDR_PUPD9_Msk                (0x3UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x000C0000 */
#define GPIO_PUPDR_PUPD9                    GPIO_PUPDR_PUPD9_Msk
#define GPIO_PUPDR_PUPD9_0                  (0x1UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x00040000 */
#define GPIO_PUPDR_PUPD9_1                  (0x2UL << GPIO_PUPDR_PUPD9_Pos)         /*!< 0x00080000 */
#define GPIO_PUPDR_PUPD10_Pos               (20U)
#define GPIO_PUPDR_PUPD10_Msk               (0x3UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00300000 */
#define GPIO_PUPDR_PUPD10                   GPIO_PUPDR_PUPD10_Msk
#define GPIO_PUPDR_PUPD10_0                 (0x1UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00100000 */
#define GPIO_PUPDR_PUPD10_1                 (0x2UL << GPIO_PUPDR_PUPD10_Pos)        /*!< 0x00200000 */
#define GPIO_PUPDR_PUPD11_Pos               (22U)
#define GPIO_PUPDR_PUPD11_Msk               (0x3UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00C00000 */
#define GPIO_PUPDR_PUPD11                   GPIO_PUPDR_PUPD11_Msk
#define GPIO_PUPDR_PUPD11_0                 (0x1UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00400000 */
#define GPIO_PUPDR_PUPD11_1                 (0x2UL << GPIO_PUPDR_PUPD11_Pos)        /*!< 0x00800000 */
#define GPIO_PUPDR_PUPD12_Pos               (24U)
#define GPIO_PUPDR_PUPD12_Msk               (0x3UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x03000000 */
#define GPIO_PUPDR_PUPD12                   GPIO_PUPDR_PUPD12_Msk
#define GPIO_PUPDR_PUPD12_0                 (0x1UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x01000000 */
#define GPIO_PUPDR_PUPD12_1                 (0x2UL << GPIO_PUPDR_PUPD12_Pos)        /*!< 0x02000000 */
#define GPIO_PUPDR_PUPD13_Pos               (26U)
#define GPIO_PUPDR_PUPD13_Msk               (0x3UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x0C000000 */
#define GPIO_PUPDR_PUPD13                   GPIO_PUPDR_PUPD13_Msk
#define GPIO_PUPDR_PUPD13_0                 (0x1UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x04000000 */
#define GPIO_PUPDR_PUPD13_1                 (0x2UL << GPIO_PUPDR_PUPD13_Pos)        /*!< 0x08000000 */
#define GPIO_PUPDR_PUPD14_Pos               (28U)
#define GPIO_PUPDR_PUPD14_Msk               (0x3UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x30000000 */
#define GPIO_PUPDR_PUPD14                   GPIO_PUPDR_PUPD14_Msk
#define GPIO_PUPDR_PUPD14_0                 (0x1UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x10000000 */
#define GPIO_PUPDR_PUPD14_1                 (0x2UL << GPIO_PUPDR_PUPD14_Pos)        /*!< 0x20000000 */
#define GPIO_PUPDR_PUPD15_Pos               (30U)
#define GPIO_PUPDR_PUPD15_Msk               (0x3UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0xC0000000 */
#define GPIO_PUPDR_PUPD15                   GPIO_PUPDR_PUPD15_Msk
#define GPIO_PUPDR_PUPD15_0                 (0x1UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0x40000000 */
#define GPIO_PUPDR_PUPD15_1                 (0x2UL << GPIO_PUPDR_PUPD15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_IDR register  *******************/
#define GPIO_IDR_ID0_Pos                    (0U)
#define GPIO_IDR_ID0_Msk                    (0x1UL << GPIO_IDR_ID0_Pos)             /*!< 0x00000001 */
#define GPIO_IDR_ID0                        GPIO_IDR_ID0_Msk
#define GPIO_IDR_ID1_Pos                    (1U)
#define GPIO_IDR_ID1_Msk                    (0x1UL << GPIO_IDR_ID1_Pos)             /*!< 0x00000002 */
#define GPIO_IDR_ID1                        GPIO_IDR_ID1_Msk
#define GPIO_IDR_ID2_Pos                    (2U)
#define GPIO_IDR_ID2_Msk                    (0x1UL << GPIO_IDR_ID2_Pos)             /*!< 0x00000004 */
#define GPIO_IDR_ID2                        GPIO_IDR_ID2_Msk
#define GPIO_IDR_ID3_Pos                    (3U)
#define GPIO_IDR_ID3_Msk                    (0x1UL << GPIO_IDR_ID3_Pos)             /*!< 0x00000008 */
#define GPIO_IDR_ID3                        GPIO_IDR_ID3_Msk
#define GPIO_IDR_ID4_Pos                    (4U)
#define GPIO_IDR_ID4_Msk                    (0x1UL << GPIO_IDR_ID4_Pos)             /*!< 0x00000010 */
#define GPIO_IDR_ID4                        GPIO_IDR_ID4_Msk
#define GPIO_IDR_ID5_Pos                    (5U)
#define GPIO_IDR_ID5_Msk                    (0x1UL << GPIO_IDR_ID5_Pos)             /*!< 0x00000020 */
#define GPIO_IDR_ID5                        GPIO_IDR_ID5_Msk
#define GPIO_IDR_ID6_Pos                    (6U)
#define GPIO_IDR_ID6_Msk                    (0x1UL << GPIO_IDR_ID6_Pos)             /*!< 0x00000040 */
#define GPIO_IDR_ID6                        GPIO_IDR_ID6_Msk
#define GPIO_IDR_ID7_Pos                    (7U)
#define GPIO_IDR_ID7_Msk                    (0x1UL << GPIO_IDR_ID7_Pos)             /*!< 0x00000080 */
#define GPIO_IDR_ID7                        GPIO_IDR_ID7_Msk
#define GPIO_IDR_ID8_Pos                    (8U)
#define GPIO_IDR_ID8_Msk                    (0x1UL << GPIO_IDR_ID8_Pos)             /*!< 0x00000100 */
#define GPIO_IDR_ID8                        GPIO_IDR_ID8_Msk
#define GPIO_IDR_ID9_Pos                    (9U)
#define GPIO_IDR_ID9_Msk                    (0x1UL << GPIO_IDR_ID9_Pos)             /*!< 0x00000200 */
#define GPIO_IDR_ID9                        GPIO_IDR_ID9_Msk
#define GPIO_IDR_ID10_Pos                   (10U)
#define GPIO_IDR_ID10_Msk                   (0x1UL << GPIO_IDR_ID10_Pos)            /*!< 0x00000400 */
#define GPIO_IDR_ID10                       GPIO_IDR_ID10_Msk
#define GPIO_IDR_ID11_Pos                   (11U)
#define GPIO_IDR_ID11_Msk                   (0x1UL << GPIO_IDR_ID11_Pos)            /*!< 0x00000800 */
#define GPIO_IDR_ID11                       GPIO_IDR_ID11_Msk
#define GPIO_IDR_ID12_Pos                   (12U)
#define GPIO_IDR_ID12_Msk                   (0x1UL << GPIO_IDR_ID12_Pos)            /*!< 0x00001000 */
#define GPIO_IDR_ID12                       GPIO_IDR_ID12_Msk
#define GPIO_IDR_ID13_Pos                   (13U)
#define GPIO_IDR_ID13_Msk                   (0x1UL << GPIO_IDR_ID13_Pos)            /*!< 0x00002000 */
#define GPIO_IDR_ID13                       GPIO_IDR_ID13_Msk
#define GPIO_IDR_ID14_Pos                   (14U)
#define GPIO_IDR_ID14_Msk                   (0x1UL << GPIO_IDR_ID14_Pos)            /*!< 0x00004000 */
#define GPIO_IDR_ID14                       GPIO_IDR_ID14_Msk
#define GPIO_IDR_ID15_Pos                   (15U)
#define GPIO_IDR_ID15_Msk                   (0x1UL << GPIO_IDR_ID15_Pos)            /*!< 0x00008000 */
#define GPIO_IDR_ID15                       GPIO_IDR_ID15_Msk

/******************  Bits definition for GPIO_ODR register  *******************/
#define GPIO_ODR_OD0_Pos                    (0U)
#define GPIO_ODR_OD0_Msk                    (0x1UL << GPIO_ODR_OD0_Pos)             /*!< 0x00000001 */
#define GPIO_ODR_OD0                        GPIO_ODR_OD0_Msk
#define GPIO_ODR_OD1_Pos                    (1U)
#define GPIO_ODR_OD1_Msk                    (0x1UL << GPIO_ODR_OD1_Pos)             /*!< 0x00000002 */
#define GPIO_ODR_OD1                        GPIO_ODR_OD1_Msk
#define GPIO_ODR_OD2_Pos                    (2U)
#define GPIO_ODR_OD2_Msk                    (0x1UL << GPIO_ODR_OD2_Pos)             /*!< 0x00000004 */
#define GPIO_ODR_OD2                        GPIO_ODR_OD2_Msk
#define GPIO_ODR_OD3_Pos                    (3U)
#define GPIO_ODR_OD3_Msk                    (0x1UL << GPIO_ODR_OD3_Pos)             /*!< 0x00000008 */
#define GPIO_ODR_OD3                        GPIO_ODR_OD3_Msk
#define GPIO_ODR_OD4_Pos                    (4U)
#define GPIO_ODR_OD4_Msk                    (0x1UL << GPIO_ODR_OD4_Pos)             /*!< 0x00000010 */
#define GPIO_ODR_OD4                        GPIO_ODR_OD4_Msk
#define GPIO_ODR_OD5_Pos                    (5U)
#define GPIO_ODR_OD5_Msk                    (0x1UL << GPIO_ODR_OD5_Pos)             /*!< 0x00000020 */
#define GPIO_ODR_OD5                        GPIO_ODR_OD5_Msk
#define GPIO_ODR_OD6_Pos                    (6U)
#define GPIO_ODR_OD6_Msk                    (0x1UL << GPIO_ODR_OD6_Pos)             /*!< 0x00000040 */
#define GPIO_ODR_OD6                        GPIO_ODR_OD6_Msk
#define GPIO_ODR_OD7_Pos                    (7U)
#define GPIO_ODR_OD7_Msk                    (0x1UL << GPIO_ODR_OD7_Pos)             /*!< 0x00000080 */
#define GPIO_ODR_OD7                        GPIO_ODR_OD7_Msk
#define GPIO_ODR_OD8_Pos                    (8U)
#define GPIO_ODR_OD8_Msk                    (0x1UL << GPIO_ODR_OD8_Pos)             /*!< 0x00000100 */
#define GPIO_ODR_OD8                        GPIO_ODR_OD8_Msk
#define GPIO_ODR_OD9_Pos                    (9U)
#define GPIO_ODR_OD9_Msk                    (0x1UL << GPIO_ODR_OD9_Pos)             /*!< 0x00000200 */
#define GPIO_ODR_OD9                        GPIO_ODR_OD9_Msk
#define GPIO_ODR_OD10_Pos                   (10U)
#define GPIO_ODR_OD10_Msk                   (0x1UL << GPIO_ODR_OD10_Pos)            /*!< 0x00000400 */
#define GPIO_ODR_OD10                       GPIO_ODR_OD10_Msk
#define GPIO_ODR_OD11_Pos                   (11U)
#define GPIO_ODR_OD11_Msk                   (0x1UL << GPIO_ODR_OD11_Pos)            /*!< 0x00000800 */
#define GPIO_ODR_OD11                       GPIO_ODR_OD11_Msk
#define GPIO_ODR_OD12_Pos                   (12U)
#define GPIO_ODR_OD12_Msk                   (0x1UL << GPIO_ODR_OD12_Pos)            /*!< 0x00001000 */
#define GPIO_ODR_OD12                       GPIO_ODR_OD12_Msk
#define GPIO_ODR_OD13_Pos                   (13U)
#define GPIO_ODR_OD13_Msk                   (0x1UL << GPIO_ODR_OD13_Pos)            /*!< 0x00002000 */
#define GPIO_ODR_OD13                       GPIO_ODR_OD13_Msk
#define GPIO_ODR_OD14_Pos                   (14U)
#define GPIO_ODR_OD14_Msk                   (0x1UL << GPIO_ODR_OD14_Pos)            /*!< 0x00004000 */
#define GPIO_ODR_OD14                       GPIO_ODR_OD14_Msk
#define GPIO_ODR_OD15_Pos                   (15U)
#define GPIO_ODR_OD15_Msk                   (0x1UL << GPIO_ODR_OD15_Pos)            /*!< 0x00008000 */
#define GPIO_ODR_OD15                       GPIO_ODR_OD15_Msk

/******************  Bits definition for GPIO_BSRR register  ******************/
#define GPIO_BSRR_BS0_Pos                   (0U)
#define GPIO_BSRR_BS0_Msk                   (0x1UL << GPIO_BSRR_BS0_Pos)            /*!< 0x00000001 */
#define GPIO_BSRR_BS0                       GPIO_BSRR_BS0_Msk
#define GPIO_BSRR_BS1_Pos                   (1U)
#define GPIO_BSRR_BS1_Msk                   (0x1UL << GPIO_BSRR_BS1_Pos)            /*!< 0x00000002 */
#define GPIO_BSRR_BS1                       GPIO_BSRR_BS1_Msk
#define GPIO_BSRR_BS2_Pos                   (2U)
#define GPIO_BSRR_BS2_Msk                   (0x1UL << GPIO_BSRR_BS2_Pos)            /*!< 0x00000004 */
#define GPIO_BSRR_BS2                       GPIO_BSRR_BS2_Msk
#define GPIO_BSRR_BS3_Pos                   (3U)
#define GPIO_BSRR_BS3_Msk                   (0x1UL << GPIO_BSRR_BS3_Pos)            /*!< 0x00000008 */
#define GPIO_BSRR_BS3                       GPIO_BSRR_BS3_Msk
#define GPIO_BSRR_BS4_Pos                   (4U)
#define GPIO_BSRR_BS4_Msk                   (0x1UL << GPIO_BSRR_BS4_Pos)            /*!< 0x00000010 */
#define GPIO_BSRR_BS4                       GPIO_BSRR_BS4_Msk
#define GPIO_BSRR_BS5_Pos                   (5U)
#define GPIO_BSRR_BS5_Msk                   (0x1UL << GPIO_BSRR_BS5_Pos)            /*!< 0x00000020 */
#define GPIO_BSRR_BS5                       GPIO_BSRR_BS5_Msk
#define GPIO_BSRR_BS6_Pos                   (6U)
#define GPIO_BSRR_BS6_Msk                   (0x1UL << GPIO_BSRR_BS6_Pos)            /*!< 0x00000040 */
#define GPIO_BSRR_BS6                       GPIO_BSRR_BS6_Msk
#define GPIO_BSRR_BS7_Pos                   (7U)
#define GPIO_BSRR_BS7_Msk                   (0x1UL << GPIO_BSRR_BS7_Pos)            /*!< 0x00000080 */
#define GPIO_BSRR_BS7                       GPIO_BSRR_BS7_Msk
#define GPIO_BSRR_BS8_Pos                   (8U)
#define GPIO_BSRR_BS8_Msk                   (0x1UL << GPIO_BSRR_BS8_Pos)            /*!< 0x00000100 */
#define GPIO_BSRR_BS8                       GPIO_BSRR_BS8_Msk
#define GPIO_BSRR_BS9_Pos                   (9U)
#define GPIO_BSRR_BS9_Msk                   (0x1UL << GPIO_BSRR_BS9_Pos)            /*!< 0x00000200 */
#define GPIO_BSRR_BS9                       GPIO_BSRR_BS9_Msk
#define GPIO_BSRR_BS10_Pos                  (10U)
#define GPIO_BSRR_BS10_Msk                  (0x1UL << GPIO_BSRR_BS10_Pos)           /*!< 0x00000400 */
#define GPIO_BSRR_BS10                      GPIO_BSRR_BS10_Msk
#define GPIO_BSRR_BS11_Pos                  (11U)
#define GPIO_BSRR_BS11_Msk                  (0x1UL << GPIO_BSRR_BS11_Pos)           /*!< 0x00000800 */
#define GPIO_BSRR_BS11                      GPIO_BSRR_BS11_Msk
#define GPIO_BSRR_BS12_Pos                  (12U)
#define GPIO_BSRR_BS12_Msk                  (0x1UL << GPIO_BSRR_BS12_Pos)           /*!< 0x00001000 */
#define GPIO_BSRR_BS12                      GPIO_BSRR_BS12_Msk
#define GPIO_BSRR_BS13_Pos                  (13U)
#define GPIO_BSRR_BS13_Msk                  (0x1UL << GPIO_BSRR_BS13_Pos)           /*!< 0x00002000 */
#define GPIO_BSRR_BS13                      GPIO_BSRR_BS13_Msk
#define GPIO_BSRR_BS14_Pos                  (14U)
#define GPIO_BSRR_BS14_Msk                  (0x1UL << GPIO_BSRR_BS14_Pos)           /*!< 0x00004000 */
#define GPIO_BSRR_BS14                      GPIO_BSRR_BS14_Msk
#define GPIO_BSRR_BS15_Pos                  (15U)
#define GPIO_BSRR_BS15_Msk                  (0x1UL << GPIO_BSRR_BS15_Pos)           /*!< 0x00008000 */
#define GPIO_BSRR_BS15                      GPIO_BSRR_BS15_Msk
#define GPIO_BSRR_BR0_Pos                   (16U)
#define GPIO_BSRR_BR0_Msk                   (0x1UL << GPIO_BSRR_BR0_Pos)            /*!< 0x00010000 */
#define GPIO_BSRR_BR0                       GPIO_BSRR_BR0_Msk
#define GPIO_BSRR_BR1_Pos                   (17U)
#define GPIO_BSRR_BR1_Msk                   (0x1UL << GPIO_BSRR_BR1_Pos)            /*!< 0x00020000 */
#define GPIO_BSRR_BR1                       GPIO_BSRR_BR1_Msk
#define GPIO_BSRR_BR2_Pos                   (18U)
#define GPIO_BSRR_BR2_Msk                   (0x1UL << GPIO_BSRR_BR2_Pos)            /*!< 0x00040000 */
#define GPIO_BSRR_BR2                       GPIO_BSRR_BR2_Msk
#define GPIO_BSRR_BR3_Pos                   (19U)
#define GPIO_BSRR_BR3_Msk                   (0x1UL << GPIO_BSRR_BR3_Pos)            /*!< 0x00080000 */
#define GPIO_BSRR_BR3                       GPIO_BSRR_BR3_Msk
#define GPIO_BSRR_BR4_Pos                   (20U)
#define GPIO_BSRR_BR4_Msk                   (0x1UL << GPIO_BSRR_BR4_Pos)            /*!< 0x00100000 */
#define GPIO_BSRR_BR4                       GPIO_BSRR_BR4_Msk
#define GPIO_BSRR_BR5_Pos                   (21U)
#define GPIO_BSRR_BR5_Msk                   (0x1UL << GPIO_BSRR_BR5_Pos)            /*!< 0x00200000 */
#define GPIO_BSRR_BR5                       GPIO_BSRR_BR5_Msk
#define GPIO_BSRR_BR6_Pos                   (22U)
#define GPIO_BSRR_BR6_Msk                   (0x1UL << GPIO_BSRR_BR6_Pos)            /*!< 0x00400000 */
#define GPIO_BSRR_BR6                       GPIO_BSRR_BR6_Msk
#define GPIO_BSRR_BR7_Pos                   (23U)
#define GPIO_BSRR_BR7_Msk                   (0x1UL << GPIO_BSRR_BR7_Pos)            /*!< 0x00800000 */
#define GPIO_BSRR_BR7                       GPIO_BSRR_BR7_Msk
#define GPIO_BSRR_BR8_Pos                   (24U)
#define GPIO_BSRR_BR8_Msk                   (0x1UL << GPIO_BSRR_BR8_Pos)            /*!< 0x01000000 */
#define GPIO_BSRR_BR8                       GPIO_BSRR_BR8_Msk
#define GPIO_BSRR_BR9_Pos                   (25U)
#define GPIO_BSRR_BR9_Msk                   (0x1UL << GPIO_BSRR_BR9_Pos)            /*!< 0x02000000 */
#define GPIO_BSRR_BR9                       GPIO_BSRR_BR9_Msk
#define GPIO_BSRR_BR10_Pos                  (26U)
#define GPIO_BSRR_BR10_Msk                  (0x1UL << GPIO_BSRR_BR10_Pos)           /*!< 0x04000000 */
#define GPIO_BSRR_BR10                      GPIO_BSRR_BR10_Msk
#define GPIO_BSRR_BR11_Pos                  (27U)
#define GPIO_BSRR_BR11_Msk                  (0x1UL << GPIO_BSRR_BR11_Pos)           /*!< 0x08000000 */
#define GPIO_BSRR_BR11                      GPIO_BSRR_BR11_Msk
#define GPIO_BSRR_BR12_Pos                  (28U)
#define GPIO_BSRR_BR12_Msk                  (0x1UL << GPIO_BSRR_BR12_Pos)           /*!< 0x10000000 */
#define GPIO_BSRR_BR12                      GPIO_BSRR_BR12_Msk
#define GPIO_BSRR_BR13_Pos                  (29U)
#define GPIO_BSRR_BR13_Msk                  (0x1UL << GPIO_BSRR_BR13_Pos)           /*!< 0x20000000 */
#define GPIO_BSRR_BR13                      GPIO_BSRR_BR13_Msk
#define GPIO_BSRR_BR14_Pos                  (30U)
#define GPIO_BSRR_BR14_Msk                  (0x1UL << GPIO_BSRR_BR14_Pos)           /*!< 0x40000000 */
#define GPIO_BSRR_BR14                      GPIO_BSRR_BR14_Msk
#define GPIO_BSRR_BR15_Pos                  (31U)
#define GPIO_BSRR_BR15_Msk                  (0x1UL << GPIO_BSRR_BR15_Pos)           /*!< 0x80000000 */
#define GPIO_BSRR_BR15                      GPIO_BSRR_BR15_Msk

/****************** Bit definition for GPIO_LCKR register *********************/
#define GPIO_LCKR_LCK0_Pos                  (0U)
#define GPIO_LCKR_LCK0_Msk                  (0x1UL << GPIO_LCKR_LCK0_Pos)           /*!< 0x00000001 */
#define GPIO_LCKR_LCK0                      GPIO_LCKR_LCK0_Msk
#define GPIO_LCKR_LCK1_Pos                  (1U)
#define GPIO_LCKR_LCK1_Msk                  (0x1UL << GPIO_LCKR_LCK1_Pos)           /*!< 0x00000002 */
#define GPIO_LCKR_LCK1                      GPIO_LCKR_LCK1_Msk
#define GPIO_LCKR_LCK2_Pos                  (2U)
#define GPIO_LCKR_LCK2_Msk                  (0x1UL << GPIO_LCKR_LCK2_Pos)           /*!< 0x00000004 */
#define GPIO_LCKR_LCK2                      GPIO_LCKR_LCK2_Msk
#define GPIO_LCKR_LCK3_Pos                  (3U)
#define GPIO_LCKR_LCK3_Msk                  (0x1UL << GPIO_LCKR_LCK3_Pos)           /*!< 0x00000008 */
#define GPIO_LCKR_LCK3                      GPIO_LCKR_LCK3_Msk
#define GPIO_LCKR_LCK4_Pos                  (4U)
#define GPIO_LCKR_LCK4_Msk                  (0x1UL << GPIO_LCKR_LCK4_Pos)           /*!< 0x00000010 */
#define GPIO_LCKR_LCK4                      GPIO_LCKR_LCK4_Msk
#define GPIO_LCKR_LCK5_Pos                  (5U)
#define GPIO_LCKR_LCK5_Msk                  (0x1UL << GPIO_LCKR_LCK5_Pos)           /*!< 0x00000020 */
#define GPIO_LCKR_LCK5                      GPIO_LCKR_LCK5_Msk
#define GPIO_LCKR_LCK6_Pos                  (6U)
#define GPIO_LCKR_LCK6_Msk                  (0x1UL << GPIO_LCKR_LCK6_Pos)           /*!< 0x00000040 */
#define GPIO_LCKR_LCK6                      GPIO_LCKR_LCK6_Msk
#define GPIO_LCKR_LCK7_Pos                  (7U)
#define GPIO_LCKR_LCK7_Msk                  (0x1UL << GPIO_LCKR_LCK7_Pos)           /*!< 0x00000080 */
#define GPIO_LCKR_LCK7                      GPIO_LCKR_LCK7_Msk
#define GPIO_LCKR_LCK8_Pos                  (8U)
#define GPIO_LCKR_LCK8_Msk                  (0x1UL << GPIO_LCKR_LCK8_Pos)           /*!< 0x00000100 */
#define GPIO_LCKR_LCK8                      GPIO_LCKR_LCK8_Msk
#define GPIO_LCKR_LCK9_Pos                  (9U)
#define GPIO_LCKR_LCK9_Msk                  (0x1UL << GPIO_LCKR_LCK9_Pos)           /*!< 0x00000200 */
#define GPIO_LCKR_LCK9                      GPIO_LCKR_LCK9_Msk
#define GPIO_LCKR_LCK10_Pos                 (10U)
#define GPIO_LCKR_LCK10_Msk                 (0x1UL << GPIO_LCKR_LCK10_Pos)          /*!< 0x00000400 */
#define GPIO_LCKR_LCK10                     GPIO_LCKR_LCK10_Msk
#define GPIO_LCKR_LCK11_Pos                 (11U)
#define GPIO_LCKR_LCK11_Msk                 (0x1UL << GPIO_LCKR_LCK11_Pos)          /*!< 0x00000800 */
#define GPIO_LCKR_LCK11                     GPIO_LCKR_LCK11_Msk
#define GPIO_LCKR_LCK12_Pos                 (12U)
#define GPIO_LCKR_LCK12_Msk                 (0x1UL << GPIO_LCKR_LCK12_Pos)          /*!< 0x00001000 */
#define GPIO_LCKR_LCK12                     GPIO_LCKR_LCK12_Msk
#define GPIO_LCKR_LCK13_Pos                 (13U)
#define GPIO_LCKR_LCK13_Msk                 (0x1UL << GPIO_LCKR_LCK13_Pos)          /*!< 0x00002000 */
#define GPIO_LCKR_LCK13                     GPIO_LCKR_LCK13_Msk
#define GPIO_LCKR_LCK14_Pos                 (14U)
#define GPIO_LCKR_LCK14_Msk                 (0x1UL << GPIO_LCKR_LCK14_Pos)          /*!< 0x00004000 */
#define GPIO_LCKR_LCK14                     GPIO_LCKR_LCK14_Msk
#define GPIO_LCKR_LCK15_Pos                 (15U)
#define GPIO_LCKR_LCK15_Msk                 (0x1UL << GPIO_LCKR_LCK15_Pos)          /*!< 0x00008000 */
#define GPIO_LCKR_LCK15                     GPIO_LCKR_LCK15_Msk
#define GPIO_LCKR_LCKK_Pos                  (16U)
#define GPIO_LCKR_LCKK_Msk                  (0x1UL << GPIO_LCKR_LCKK_Pos)           /*!< 0x00010000 */
#define GPIO_LCKR_LCKK                      GPIO_LCKR_LCKK_Msk

/****************** Bit definition for GPIO_AFRL register *********************/
#define GPIO_AFRL_AFSEL0_Pos                (0U)
#define GPIO_AFRL_AFSEL0_Msk                (0xFUL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x0000000F */
#define GPIO_AFRL_AFSEL0                    GPIO_AFRL_AFSEL0_Msk
#define GPIO_AFRL_AFSEL0_0                  (0x1UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000001 */
#define GPIO_AFRL_AFSEL0_1                  (0x2UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000002 */
#define GPIO_AFRL_AFSEL0_2                  (0x4UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000004 */
#define GPIO_AFRL_AFSEL0_3                  (0x8UL << GPIO_AFRL_AFSEL0_Pos)         /*!< 0x00000008 */
#define GPIO_AFRL_AFSEL1_Pos                (4U)
#define GPIO_AFRL_AFSEL1_Msk                (0xFUL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRL_AFSEL1                    GPIO_AFRL_AFSEL1_Msk
#define GPIO_AFRL_AFSEL1_0                  (0x1UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000010 */
#define GPIO_AFRL_AFSEL1_1                  (0x2UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000020 */
#define GPIO_AFRL_AFSEL1_2                  (0x4UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000040 */
#define GPIO_AFRL_AFSEL1_3                  (0x8UL << GPIO_AFRL_AFSEL1_Pos)         /*!< 0x00000080 */
#define GPIO_AFRL_AFSEL2_Pos                (8U)
#define GPIO_AFRL_AFSEL2_Msk                (0xFUL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000F00 */
#define GPIO_AFRL_AFSEL2                    GPIO_AFRL_AFSEL2_Msk
#define GPIO_AFRL_AFSEL2_0                  (0x1UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000100 */
#define GPIO_AFRL_AFSEL2_1                  (0x2UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000200 */
#define GPIO_AFRL_AFSEL2_2                  (0x4UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000400 */
#define GPIO_AFRL_AFSEL2_3                  (0x8UL << GPIO_AFRL_AFSEL2_Pos)         /*!< 0x00000800 */
#define GPIO_AFRL_AFSEL3_Pos                (12U)
#define GPIO_AFRL_AFSEL3_Msk                (0xFUL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x0000F000 */
#define GPIO_AFRL_AFSEL3                    GPIO_AFRL_AFSEL3_Msk
#define GPIO_AFRL_AFSEL3_0                  (0x1UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00001000 */
#define GPIO_AFRL_AFSEL3_1                  (0x2UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00002000 */
#define GPIO_AFRL_AFSEL3_2                  (0x4UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00004000 */
#define GPIO_AFRL_AFSEL3_3                  (0x8UL << GPIO_AFRL_AFSEL3_Pos)         /*!< 0x00008000 */
#define GPIO_AFRL_AFSEL4_Pos                (16U)
#define GPIO_AFRL_AFSEL4_Msk                (0xFUL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x000F0000 */
#define GPIO_AFRL_AFSEL4                    GPIO_AFRL_AFSEL4_Msk
#define GPIO_AFRL_AFSEL4_0                  (0x1UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00010000 */
#define GPIO_AFRL_AFSEL4_1                  (0x2UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00020000 */
#define GPIO_AFRL_AFSEL4_2                  (0x4UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00040000 */
#define GPIO_AFRL_AFSEL4_3                  (0x8UL << GPIO_AFRL_AFSEL4_Pos)         /*!< 0x00080000 */
#define GPIO_AFRL_AFSEL5_Pos                (20U)
#define GPIO_AFRL_AFSEL5_Msk                (0xFUL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00F00000 */
#define GPIO_AFRL_AFSEL5                    GPIO_AFRL_AFSEL5_Msk
#define GPIO_AFRL_AFSEL5_0                  (0x1UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00100000 */
#define GPIO_AFRL_AFSEL5_1                  (0x2UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00200000 */
#define GPIO_AFRL_AFSEL5_2                  (0x4UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00400000 */
#define GPIO_AFRL_AFSEL5_3                  (0x8UL << GPIO_AFRL_AFSEL5_Pos)         /*!< 0x00800000 */
#define GPIO_AFRL_AFSEL6_Pos                (24U)
#define GPIO_AFRL_AFSEL6_Msk                (0xFUL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x0F000000 */
#define GPIO_AFRL_AFSEL6                    GPIO_AFRL_AFSEL6_Msk
#define GPIO_AFRL_AFSEL6_0                  (0x1UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x01000000 */
#define GPIO_AFRL_AFSEL6_1                  (0x2UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x02000000 */
#define GPIO_AFRL_AFSEL6_2                  (0x4UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x04000000 */
#define GPIO_AFRL_AFSEL6_3                  (0x8UL << GPIO_AFRL_AFSEL6_Pos)         /*!< 0x08000000 */
#define GPIO_AFRL_AFSEL7_Pos                (28U)
#define GPIO_AFRL_AFSEL7_Msk                (0xFUL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0xF0000000 */
#define GPIO_AFRL_AFSEL7                    GPIO_AFRL_AFSEL7_Msk
#define GPIO_AFRL_AFSEL7_0                  (0x1UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x10000000 */
#define GPIO_AFRL_AFSEL7_1                  (0x2UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x20000000 */
#define GPIO_AFRL_AFSEL7_2                  (0x4UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x40000000 */
#define GPIO_AFRL_AFSEL7_3                  (0x8UL << GPIO_AFRL_AFSEL7_Pos)         /*!< 0x80000000 */

/****************** Bit definition for GPIO_AFRH register *********************/
#define GPIO_AFRH_AFSEL8_Pos                (0U)
#define GPIO_AFRH_AFSEL8_Msk                (0xFUL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x0000000F */
#define GPIO_AFRH_AFSEL8                    GPIO_AFRH_AFSEL8_Msk
#define GPIO_AFRH_AFSEL8_0                  (0x1UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000001 */
#define GPIO_AFRH_AFSEL8_1                  (0x2UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000002 */
#define GPIO_AFRH_AFSEL8_2                  (0x4UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000004 */
#define GPIO_AFRH_AFSEL8_3                  (0x8UL << GPIO_AFRH_AFSEL8_Pos)         /*!< 0x00000008 */
#define GPIO_AFRH_AFSEL9_Pos                (4U)
#define GPIO_AFRH_AFSEL9_Msk                (0xFUL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x000000F0 */
#define GPIO_AFRH_AFSEL9                    GPIO_AFRH_AFSEL9_Msk
#define GPIO_AFRH_AFSEL9_0                  (0x1UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000010 */
#define GPIO_AFRH_AFSEL9_1                  (0x2UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000020 */
#define GPIO_AFRH_AFSEL9_2                  (0x4UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000040 */
#define GPIO_AFRH_AFSEL9_3                  (0x8UL << GPIO_AFRH_AFSEL9_Pos)         /*!< 0x00000080 */
#define GPIO_AFRH_AFSEL10_Pos               (8U)
#define GPIO_AFRH_AFSEL10_Msk               (0xFUL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000F00 */
#define GPIO_AFRH_AFSEL10                   GPIO_AFRH_AFSEL10_Msk
#define GPIO_AFRH_AFSEL10_0                 (0x1UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000100 */
#define GPIO_AFRH_AFSEL10_1                 (0x2UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000200 */
#define GPIO_AFRH_AFSEL10_2                 (0x4UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000400 */
#define GPIO_AFRH_AFSEL10_3                 (0x8UL << GPIO_AFRH_AFSEL10_Pos)        /*!< 0x00000800 */
#define GPIO_AFRH_AFSEL11_Pos               (12U)
#define GPIO_AFRH_AFSEL11_Msk               (0xFUL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x0000F000 */
#define GPIO_AFRH_AFSEL11                   GPIO_AFRH_AFSEL11_Msk
#define GPIO_AFRH_AFSEL11_0                 (0x1UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00001000 */
#define GPIO_AFRH_AFSEL11_1                 (0x2UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00002000 */
#define GPIO_AFRH_AFSEL11_2                 (0x4UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00004000 */
#define GPIO_AFRH_AFSEL11_3                 (0x8UL << GPIO_AFRH_AFSEL11_Pos)        /*!< 0x00008000 */
#define GPIO_AFRH_AFSEL12_Pos               (16U)
#define GPIO_AFRH_AFSEL12_Msk               (0xFUL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x000F0000 */
#define GPIO_AFRH_AFSEL12                   GPIO_AFRH_AFSEL12_Msk
#define GPIO_AFRH_AFSEL12_0                 (0x1UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00010000 */
#define GPIO_AFRH_AFSEL12_1                 (0x2UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00020000 */
#define GPIO_AFRH_AFSEL12_2                 (0x4UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00040000 */
#define GPIO_AFRH_AFSEL12_3                 (0x8UL << GPIO_AFRH_AFSEL12_Pos)        /*!< 0x00080000 */
#define GPIO_AFRH_AFSEL13_Pos               (20U)
#define GPIO_AFRH_AFSEL13_Msk               (0xFUL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00F00000 */
#define GPIO_AFRH_AFSEL13                   GPIO_AFRH_AFSEL13_Msk
#define GPIO_AFRH_AFSEL13_0                 (0x1UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00100000 */
#define GPIO_AFRH_AFSEL13_1                 (0x2UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00200000 */
#define GPIO_AFRH_AFSEL13_2                 (0x4UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00400000 */
#define GPIO_AFRH_AFSEL13_3                 (0x8UL << GPIO_AFRH_AFSEL13_Pos)        /*!< 0x00800000 */
#define GPIO_AFRH_AFSEL14_Pos               (24U)
#define GPIO_AFRH_AFSEL14_Msk               (0xFUL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x0F000000 */
#define GPIO_AFRH_AFSEL14                   GPIO_AFRH_AFSEL14_Msk
#define GPIO_AFRH_AFSEL14_0                 (0x1UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x01000000 */
#define GPIO_AFRH_AFSEL14_1                 (0x2UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x02000000 */
#define GPIO_AFRH_AFSEL14_2                 (0x4UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x04000000 */
#define GPIO_AFRH_AFSEL14_3                 (0x8UL << GPIO_AFRH_AFSEL14_Pos)        /*!< 0x08000000 */
#define GPIO_AFRH_AFSEL15_Pos               (28U)
#define GPIO_AFRH_AFSEL15_Msk               (0xFUL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0xF0000000 */
#define GPIO_AFRH_AFSEL15                   GPIO_AFRH_AFSEL15_Msk
#define GPIO_AFRH_AFSEL15_0                 (0x1UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x10000000 */
#define GPIO_AFRH_AFSEL15_1                 (0x2UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x20000000 */
#define GPIO_AFRH_AFSEL15_2                 (0x4UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x40000000 */
#define GPIO_AFRH_AFSEL15_3                 (0x8UL << GPIO_AFRH_AFSEL15_Pos)        /*!< 0x80000000 */

/******************  Bits definition for GPIO_BRR register  ******************/
#define GPIO_BRR_BR0_Pos                    (0U)
#define GPIO_BRR_BR0_Msk                    (0x1UL << GPIO_BRR_BR0_Pos)             /*!< 0x00000001 */
#define GPIO_BRR_BR0                        GPIO_BRR_BR0_Msk
#define GPIO_BRR_BR1_Pos                    (1U)
#define GPIO_BRR_BR1_Msk                    (0x1UL << GPIO_BRR_BR1_Pos)             /*!< 0x00000002 */
#define GPIO_BRR_BR1                        GPIO_BRR_BR1_Msk
#define GPIO_BRR_BR2_Pos                    (2U)
#define GPIO_BRR_BR2_Msk                    (0x1UL << GPIO_BRR_BR2_Pos)             /*!< 0x00000004 */
#define GPIO_BRR_BR2                        GPIO_BRR_BR2_Msk
#define GPIO_BRR_BR3_Pos                    (3U)
#define GPIO_BRR_BR3_Msk                    (0x1UL << GPIO_BRR_BR3_Pos)             /*!< 0x00000008 */
#define GPIO_BRR_BR3                        GPIO_BRR_BR3_Msk
#define GPIO_BRR_BR4_Pos                    (4U)
#define GPIO_BRR_BR4_Msk                    (0x1UL << GPIO_BRR_BR4_Pos)             /*!< 0x00000010 */
#define GPIO_BRR_BR4                        GPIO_BRR_BR4_Msk
#define GPIO_BRR_BR5_Pos                    (5U)
#define GPIO_BRR_BR5_Msk                    (0x1UL << GPIO_BRR_BR5_Pos)             /*!< 0x00000020 */
#define GPIO_BRR_BR5                        GPIO_BRR_BR5_Msk
#define GPIO_BRR_BR6_Pos                    (6U)
#define GPIO_BRR_BR6_Msk                    (0x1UL << GPIO_BRR_BR6_Pos)             /*!< 0x00000040 */
#define GPIO_BRR_BR6                        GPIO_BRR_BR6_Msk
#define GPIO_BRR_BR7_Pos                    (7U)
#define GPIO_BRR_BR7_Msk                    (0x1UL << GPIO_BRR_BR7_Pos)             /*!< 0x00000080 */
#define GPIO_BRR_BR7                        GPIO_BRR_BR7_Msk
#define GPIO_BRR_BR8_Pos                    (8U)
#define GPIO_BRR_BR8_Msk                    (0x1UL << GPIO_BRR_BR8_Pos)             /*!< 0x00000100 */
#define GPIO_BRR_BR8                        GPIO_BRR_BR8_Msk
#define GPIO_BRR_BR9_Pos                    (9U)
#define GPIO_BRR_BR9_Msk                    (0x1UL << GPIO_BRR_BR9_Pos)             /*!< 0x00000200 */
#define GPIO_BRR_BR9                        GPIO_BRR_BR9_Msk
#define GPIO_BRR_BR10_Pos                   (10U)
#define GPIO_BRR_BR10_Msk                   (0x1UL << GPIO_BRR_BR10_Pos)            /*!< 0x00000400 */
#define GPIO_BRR_BR10                       GPIO_BRR_BR10_Msk
#define GPIO_BRR_BR11_Pos                   (11U)
#define GPIO_BRR_BR11_Msk                   (0x1UL << GPIO_BRR_BR11_Pos)            /*!< 0x00000800 */
#define GPIO_BRR_BR11                       GPIO_BRR_BR11_Msk
#define GPIO_BRR_BR12_Pos                   (12U)
#define GPIO_BRR_BR12_Msk                   (0x1UL << GPIO_BRR_BR12_Pos)            /*!< 0x00001000 */
#define GPIO_BRR_BR12                       GPIO_BRR_BR12_Msk
#define GPIO_BRR_BR13_Pos                   (13U)
#define GPIO_BRR_BR13_Msk                   (0x1UL << GPIO_BRR_BR13_Pos)            /*!< 0x00002000 */
#define GPIO_BRR_BR13                       GPIO_BRR_BR13_Msk
#define GPIO_BRR_BR14_Pos                   (14U)
#define GPIO_BRR_BR14_Msk                   (0x1UL << GPIO_BRR_BR14_Pos)            /*!< 0x00004000 */
#define GPIO_BRR_BR14                       GPIO_BRR_BR14_Msk
#define GPIO_BRR_BR15_Pos                   (15U)
#define GPIO_BRR_BR15_Msk                   (0x1UL << GPIO_BRR_BR15_Pos)            /*!< 0x00008000 */
#define GPIO_BRR_BR15                       GPIO_BRR_BR15_Msk

/******************  Bits definition for GPIO_HSLVR register  ******************/
#define GPIO_HSLVR_HSLV0_Pos                (0U)
#define GPIO_HSLVR_HSLV0_Msk                (0x1UL << GPIO_HSLVR_HSLV0_Pos)         /*!< 0x00000001 */
#define GPIO_HSLVR_HSLV0                    GPIO_HSLVR_HSLV0_Msk
#define GPIO_HSLVR_HSLV1_Pos                (1U)
#define GPIO_HSLVR_HSLV1_Msk                (0x1UL << GPIO_HSLVR_HSLV1_Pos)         /*!< 0x00000002 */
#define GPIO_HSLVR_HSLV1                    GPIO_HSLVR_HSLV1_Msk
#define GPIO_HSLVR_HSLV2_Pos                (2U)
#define GPIO_HSLVR_HSLV2_Msk                (0x1UL << GPIO_HSLVR_HSLV2_Pos)         /*!< 0x00000004 */
#define GPIO_HSLVR_HSLV2                    GPIO_HSLVR_HSLV2_Msk
#define GPIO_HSLVR_HSLV3_Pos                (3U)
#define GPIO_HSLVR_HSLV3_Msk                (0x1UL << GPIO_HSLVR_HSLV3_Pos)         /*!< 0x00000008 */
#define GPIO_HSLVR_HSLV3                    GPIO_HSLVR_HSLV3_Msk
#define GPIO_HSLVR_HSLV4_Pos                (4U)
#define GPIO_HSLVR_HSLV4_Msk                (0x1UL << GPIO_HSLVR_HSLV4_Pos)         /*!< 0x00000010 */
#define GPIO_HSLVR_HSLV4                    GPIO_HSLVR_HSLV4_Msk
#define GPIO_HSLVR_HSLV5_Pos                (5U)
#define GPIO_HSLVR_HSLV5_Msk                (0x1UL << GPIO_HSLVR_HSLV5_Pos)         /*!< 0x00000020 */
#define GPIO_HSLVR_HSLV5                    GPIO_HSLVR_HSLV5_Msk
#define GPIO_HSLVR_HSLV6_Pos                (6U)
#define GPIO_HSLVR_HSLV6_Msk                (0x1UL << GPIO_HSLVR_HSLV6_Pos)         /*!< 0x00000040 */
#define GPIO_HSLVR_HSLV6                    GPIO_HSLVR_HSLV6_Msk
#define GPIO_HSLVR_HSLV7_Pos                (7U)
#define GPIO_HSLVR_HSLV7_Msk                (0x1UL << GPIO_HSLVR_HSLV7_Pos)         /*!< 0x00000080 */
#define GPIO_HSLVR_HSLV7                    GPIO_HSLVR_HSLV7_Msk
#define GPIO_HSLVR_HSLV8_Pos                (8U)
#define GPIO_HSLVR_HSLV8_Msk                (0x1UL << GPIO_HSLVR_HSLV8_Pos)         /*!< 0x00000100 */
#define GPIO_HSLVR_HSLV8                    GPIO_HSLVR_HSLV8_Msk
#define GPIO_HSLVR_HSLV9_Pos                (9U)
#define GPIO_HSLVR_HSLV9_Msk                (0x1UL << GPIO_HSLVR_HSLV9_Pos)         /*!< 0x00000200 */
#define GPIO_HSLVR_HSLV9                    GPIO_HSLVR_HSLV9_Msk
#define GPIO_HSLVR_HSLV10_Pos               (10U)
#define GPIO_HSLVR_HSLV10_Msk               (0x1UL << GPIO_HSLVR_HSLV10_Pos)        /*!< 0x00000400 */
#define GPIO_HSLVR_HSLV10                   GPIO_HSLVR_HSLV10_Msk
#define GPIO_HSLVR_HSLV11_Pos               (11U)
#define GPIO_HSLVR_HSLV11_Msk               (x1UL << GPIO_HSLVR_HSLV11_Pos)         /*!< 0x00000800 */
#define GPIO_HSLVR_HSLV11                   GPIO_HSLVR_HSLV11_Msk
#define GPIO_HSLVR_HSLV12_Pos               (12U)
#define GPIO_HSLVR_HSLV12_Msk               (0x1UL << GPIO_HSLVR_HSLV12_Pos)        /*!< 0x00001000 */
#define GPIO_HSLVR_HSLV12                   GPIO_HSLVR_HSLV12_Msk
#define GPIO_HSLVR_HSLV13_Pos               (13U)
#define GPIO_HSLVR_HSLV13_Msk               (0x1UL << GPIO_HSLVR_HSLV13_Pos)        /*!< 0x00002000 */
#define GPIO_HSLVR_HSLV13                   GPIO_HSLVR_HSLV13_Msk
#define GPIO_HSLVR_HSLV14_Pos               (14U)
#define GPIO_HSLVR_HSLV14_Msk               (0x1UL << GPIO_HSLVR_HSLV14_Pos)        /*!< 0x00004000 */
#define GPIO_HSLVR_HSLV14                   GPIO_HSLVR_HSLV14_Msk
#define GPIO_HSLVR_HSLV15_Pos               (15U)
#define GPIO_HSLVR_HSLV15_Msk               (0x1UL << GPIO_HSLVR_HSLV15_Pos)        /*!< 0x00008000 */
#define GPIO_HSLVR_HSLV15                   GPIO_HSLVR_HSLV15_Msk

/******************  Bits definition for GPIO_SECCFGR register  ******************/
#define GPIO_SECCFGR_SEC0_Pos               (0U)
#define GPIO_SECCFGR_SEC0_Msk               (0x1UL << GPIO_SECCFGR_SEC0_Pos)        /*!< 0x00000001 */
#define GPIO_SECCFGR_SEC0                   GPIO_SECCFGR_SEC0_Msk
#define GPIO_SECCFGR_SEC1_Pos               (1U)
#define GPIO_SECCFGR_SEC1_Msk               (0x1UL << GPIO_SECCFGR_SEC1_Pos)        /*!< 0x00000002 */
#define GPIO_SECCFGR_SEC1                   GPIO_SECCFGR_SEC1_Msk
#define GPIO_SECCFGR_SEC2_Pos               (2U)
#define GPIO_SECCFGR_SEC2_Msk               (0x1UL << GPIO_SECCFGR_SEC2_Pos)        /*!< 0x00000004 */
#define GPIO_SECCFGR_SEC2                   GPIO_SECCFGR_SEC2_Msk
#define GPIO_SECCFGR_SEC3_Pos               (3U)
#define GPIO_SECCFGR_SEC3_Msk               (0x1UL << GPIO_SECCFGR_SEC3_Pos)        /*!< 0x00000008 */
#define GPIO_SECCFGR_SEC3                   GPIO_SECCFGR_SEC3_Msk
#define GPIO_SECCFGR_SEC4_Pos               (4U)
#define GPIO_SECCFGR_SEC4_Msk               (0x1UL << GPIO_SECCFGR_SEC4_Pos)        /*!< 0x00000010 */
#define GPIO_SECCFGR_SEC4                   GPIO_SECCFGR_SEC4_Msk
#define GPIO_SECCFGR_SEC5_Pos               (5U)
#define GPIO_SECCFGR_SEC5_Msk               (0x1UL << GPIO_SECCFGR_SEC5_Pos)        /*!< 0x00000020 */
#define GPIO_SECCFGR_SEC5                   GPIO_SECCFGR_SEC5_Msk
#define GPIO_SECCFGR_SEC6_Pos               (6U)
#define GPIO_SECCFGR_SEC6_Msk               (0x1UL << GPIO_SECCFGR_SEC6_Pos)        /*!< 0x00000040 */
#define GPIO_SECCFGR_SEC6                   GPIO_SECCFGR_SEC6_Msk
#define GPIO_SECCFGR_SEC7_Pos               (7U)
#define GPIO_SECCFGR_SEC7_Msk               (0x1UL << GPIO_SECCFGR_SEC7_Pos)        /*!< 0x00000080 */
#define GPIO_SECCFGR_SEC7                   GPIO_SECCFGR_SEC7_Msk
#define GPIO_SECCFGR_SEC8_Pos               (8U)
#define GPIO_SECCFGR_SEC8_Msk               (0x1UL << GPIO_SECCFGR_SEC8_Pos)        /*!< 0x00000100 */
#define GPIO_SECCFGR_SEC8                   GPIO_SECCFGR_SEC8_Msk
#define GPIO_SECCFGR_SEC9_Pos               (9U)
#define GPIO_SECCFGR_SEC9_Msk               (0x1UL << GPIO_SECCFGR_SEC9_Pos)        /*!< 0x00000200 */
#define GPIO_SECCFGR_SEC9                   GPIO_SECCFGR_SEC9_Msk
#define GPIO_SECCFGR_SEC10_Pos              (10U)
#define GPIO_SECCFGR_SEC10_Msk              (0x1UL << GPIO_SECCFGR_SEC10_Pos)       /*!< 0x00000400 */
#define GPIO_SECCFGR_SEC10                  GPIO_SECCFGR_SEC10_Msk
#define GPIO_SECCFGR_SEC11_Pos              (11U)
#define GPIO_SECCFGR_SEC11_Msk              (x1UL << GPIO_SECCFGR_SEC11_Pos)        /*!< 0x00000800 */
#define GPIO_SECCFGR_SEC11                  GPIO_SECCFGR_SEC11_Msk
#define GPIO_SECCFGR_SEC12_Pos              (12U)
#define GPIO_SECCFGR_SEC12_Msk              (0x1UL << GPIO_SECCFGR_SEC12_Pos)       /*!< 0x00001000 */
#define GPIO_SECCFGR_SEC12                  GPIO_SECCFGR_SEC12_Msk
#define GPIO_SECCFGR_SEC13_Pos              (13U)
#define GPIO_SECCFGR_SEC13_Msk              (0x1UL << GPIO_SECCFGR_SEC13_Pos)       /*!< 0x00002000 */
#define GPIO_SECCFGR_SEC13                  GPIO_SECCFGR_SEC13_Msk
#define GPIO_SECCFGR_SEC14_Pos              (14U)
#define GPIO_SECCFGR_SEC14_Msk              (0x1UL << GPIO_SECCFGR_SEC14_Pos)       /*!< 0x00004000 */
#define GPIO_SECCFGR_SEC14                  GPIO_SECCFGR_SEC14_Msk
#define GPIO_SECCFGR_SEC15_Pos              (15U)
#define GPIO_SECCFGR_SEC15_Msk              (0x1UL << GPIO_SECCFGR_SEC15_Pos)       /*!< 0x00008000 */
#define GPIO_SECCFGR_SEC15                  GPIO_SECCFGR_SEC15_Msk

/******************************************************************************/
/*                                                                            */
/*                        JPEG Encoder/Decoder                                */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for CONFR0 register  ********************/
#define JPEG_CONFR0_START_Pos           (0U)
#define JPEG_CONFR0_START_Msk           (0x1UL << JPEG_CONFR0_START_Pos)       /*!< 0x00000001 */
#define JPEG_CONFR0_START               JPEG_CONFR0_START_Msk                  /*!<Start/Stop bit */

/********************  Bit definition for CONFR1 register  ********************/
#define JPEG_CONFR1_NF_Pos              (0U)
#define JPEG_CONFR1_NF_Msk              (0x3UL << JPEG_CONFR1_NF_Pos)          /*!< 0x00000003 */
#define JPEG_CONFR1_NF                  JPEG_CONFR1_NF_Msk                     /*!<Number of color components */
#define JPEG_CONFR1_NF_0                (0x1UL << JPEG_CONFR1_NF_Pos)           /*!< 0x00000001 */
#define JPEG_CONFR1_NF_1                (0x2UL << JPEG_CONFR1_NF_Pos)           /*!< 0x00000002 */
#define JPEG_CONFR1_DE_Pos              (3U)
#define JPEG_CONFR1_DE_Msk              (0x1UL << JPEG_CONFR1_DE_Pos)          /*!< 0x00000008 */
#define JPEG_CONFR1_DE                  JPEG_CONFR1_DE_Msk                     /*!<Decoding Enable */
#define JPEG_CONFR1_COLORSPACE_Pos      (4U)
#define JPEG_CONFR1_COLORSPACE_Msk      (0x3UL << JPEG_CONFR1_COLORSPACE_Pos)  /*!< 0x00000030 */
#define JPEG_CONFR1_COLORSPACE          JPEG_CONFR1_COLORSPACE_Msk             /*!<Color Space */
#define JPEG_CONFR1_COLORSPACE_0        (0x1UL << JPEG_CONFR1_COLORSPACE_Pos)   /*!< 0x00000010 */
#define JPEG_CONFR1_COLORSPACE_1        (0x2UL << JPEG_CONFR1_COLORSPACE_Pos)   /*!< 0x00000020 */
#define JPEG_CONFR1_NS_Pos              (6U)
#define JPEG_CONFR1_NS_Msk              (0x3UL << JPEG_CONFR1_NS_Pos)          /*!< 0x000000C0 */
#define JPEG_CONFR1_NS                  JPEG_CONFR1_NS_Msk                     /*!<Number of components for Scan */
#define JPEG_CONFR1_NS_0                (0x1UL << JPEG_CONFR1_NS_Pos)           /*!< 0x00000040 */
#define JPEG_CONFR1_NS_1                (0x2UL << JPEG_CONFR1_NS_Pos)           /*!< 0x00000080 */
#define JPEG_CONFR1_HDR_Pos             (8U)
#define JPEG_CONFR1_HDR_Msk             (0x1UL << JPEG_CONFR1_HDR_Pos)         /*!< 0x00000100 */
#define JPEG_CONFR1_HDR                 JPEG_CONFR1_HDR_Msk                    /*!<Header Processing On/Off */
#define JPEG_CONFR1_YSIZE_Pos           (16U)
#define JPEG_CONFR1_YSIZE_Msk           (0xFFFFUL << JPEG_CONFR1_YSIZE_Pos)    /*!< 0xFFFF0000 */
#define JPEG_CONFR1_YSIZE               JPEG_CONFR1_YSIZE_Msk                  /*!<Number of lines in source image */

/********************  Bit definition for CONFR2 register  ********************/
#define JPEG_CONFR2_NMCU_Pos            (0U)
#define JPEG_CONFR2_NMCU_Msk            (0x3FFFFFFUL << JPEG_CONFR2_NMCU_Pos)  /*!< 0x03FFFFFF */
#define JPEG_CONFR2_NMCU                JPEG_CONFR2_NMCU_Msk                   /*!<Number of MCU units minus 1 to encode */

/********************  Bit definition for CONFR3 register  ********************/
#define JPEG_CONFR3_XSIZE_Pos           (16U)
#define JPEG_CONFR3_XSIZE_Msk           (0xFFFFUL << JPEG_CONFR3_XSIZE_Pos)    /*!< 0xFFFF0000 */
#define JPEG_CONFR3_XSIZE               JPEG_CONFR3_XSIZE_Msk                  /*!<Number of pixels per line */

/********************  Bit definition for CONFR4 register  ********************/
#define JPEG_CONFR4_HD_Pos              (0U)
#define JPEG_CONFR4_HD_Msk              (0x1UL << JPEG_CONFR4_HD_Pos)          /*!< 0x00000001 */
#define JPEG_CONFR4_HD                  JPEG_CONFR4_HD_Msk                     /*!<Selects the Huffman table for encoding the DC coefficients */
#define JPEG_CONFR4_HA_Pos              (1U)
#define JPEG_CONFR4_HA_Msk              (0x1UL << JPEG_CONFR4_HA_Pos)          /*!< 0x00000002 */
#define JPEG_CONFR4_HA                  JPEG_CONFR4_HA_Msk                     /*!<Selects the Huffman table for encoding the AC coefficients */
#define JPEG_CONFR4_QT_Pos              (2U)
#define JPEG_CONFR4_QT_Msk              (0x3UL << JPEG_CONFR4_QT_Pos)          /*!< 0x0000000C */
#define JPEG_CONFR4_QT                  JPEG_CONFR4_QT_Msk                     /*!<Selects quantization table associated with a color component */
#define JPEG_CONFR4_QT_0                (0x1UL << JPEG_CONFR4_QT_Pos)           /*!< 0x00000004 */
#define JPEG_CONFR4_QT_1                (0x2UL << JPEG_CONFR4_QT_Pos)           /*!< 0x00000008 */
#define JPEG_CONFR4_NB_Pos              (4U)
#define JPEG_CONFR4_NB_Msk              (0xFUL << JPEG_CONFR4_NB_Pos)          /*!< 0x000000F0 */
#define JPEG_CONFR4_NB                  JPEG_CONFR4_NB_Msk                     /*!<Number of data units minus 1 that belong to a particular color in the MCU */
#define JPEG_CONFR4_NB_0                (0x1UL << JPEG_CONFR4_NB_Pos)           /*!< 0x00000010 */
#define JPEG_CONFR4_NB_1                (0x2UL << JPEG_CONFR4_NB_Pos)           /*!< 0x00000020 */
#define JPEG_CONFR4_NB_2                (0x4UL << JPEG_CONFR4_NB_Pos)           /*!< 0x00000040 */
#define JPEG_CONFR4_NB_3                (0x8UL << JPEG_CONFR4_NB_Pos)           /*!< 0x00000080 */
#define JPEG_CONFR4_VSF_Pos             (8U)
#define JPEG_CONFR4_VSF_Msk             (0xFUL << JPEG_CONFR4_VSF_Pos)         /*!< 0x00000F00 */
#define JPEG_CONFR4_VSF                 JPEG_CONFR4_VSF_Msk                    /*!<Vertical sampling factor for component 1 */
#define JPEG_CONFR4_VSF_0               (0x1UL << JPEG_CONFR4_VSF_Pos)          /*!< 0x00000100 */
#define JPEG_CONFR4_VSF_1               (0x2UL << JPEG_CONFR4_VSF_Pos)          /*!< 0x00000200 */
#define JPEG_CONFR4_VSF_2               (0x4UL << JPEG_CONFR4_VSF_Pos)          /*!< 0x00000400 */
#define JPEG_CONFR4_VSF_3               (0x8UL << JPEG_CONFR4_VSF_Pos)          /*!< 0x00000800 */
#define JPEG_CONFR4_HSF_Pos             (12U)
#define JPEG_CONFR4_HSF_Msk             (0xFUL << JPEG_CONFR4_HSF_Pos)         /*!< 0x0000F000 */
#define JPEG_CONFR4_HSF                 JPEG_CONFR4_HSF_Msk                    /*!<Horizontal sampling factor for component 1 */
#define JPEG_CONFR4_HSF_0               (0x1UL << JPEG_CONFR4_HSF_Pos)          /*!< 0x00001000 */
#define JPEG_CONFR4_HSF_1               (0x2UL << JPEG_CONFR4_HSF_Pos)          /*!< 0x00002000 */
#define JPEG_CONFR4_HSF_2               (0x4UL << JPEG_CONFR4_HSF_Pos)          /*!< 0x00004000 */
#define JPEG_CONFR4_HSF_3               (0x8UL << JPEG_CONFR4_HSF_Pos)          /*!< 0x00008000 */

/********************  Bit definition for CONFR5 register  ********************/
#define JPEG_CONFR5_HD_Pos              (0U)
#define JPEG_CONFR5_HD_Msk              (0x1UL << JPEG_CONFR5_HD_Pos)          /*!< 0x00000001 */
#define JPEG_CONFR5_HD                  JPEG_CONFR5_HD_Msk                     /*!<Selects the Huffman table for encoding the DC coefficients */
#define JPEG_CONFR5_HA_Pos              (1U)
#define JPEG_CONFR5_HA_Msk              (0x1UL << JPEG_CONFR5_HA_Pos)          /*!< 0x00000002 */
#define JPEG_CONFR5_HA                  JPEG_CONFR5_HA_Msk                     /*!<Selects the Huffman table for encoding the AC coefficients */
#define JPEG_CONFR5_QT_Pos              (2U)
#define JPEG_CONFR5_QT_Msk              (0x3UL << JPEG_CONFR5_QT_Pos)          /*!< 0x0000000C */
#define JPEG_CONFR5_QT                  JPEG_CONFR5_QT_Msk                     /*!<Selects quantization table associated with a color component */
#define JPEG_CONFR5_QT_0                (0x1UL << JPEG_CONFR5_QT_Pos)           /*!< 0x00000004 */
#define JPEG_CONFR5_QT_1                (0x2UL << JPEG_CONFR5_QT_Pos)           /*!< 0x00000008 */
#define JPEG_CONFR5_NB_Pos              (4U)
#define JPEG_CONFR5_NB_Msk              (0xFUL << JPEG_CONFR5_NB_Pos)          /*!< 0x000000F0 */
#define JPEG_CONFR5_NB                  JPEG_CONFR5_NB_Msk                     /*!<Number of data units minus 1 that belong to a particular color in the MCU */
#define JPEG_CONFR5_NB_0                (0x1UL << JPEG_CONFR5_NB_Pos)           /*!< 0x00000010 */
#define JPEG_CONFR5_NB_1                (0x2UL << JPEG_CONFR5_NB_Pos)           /*!< 0x00000020 */
#define JPEG_CONFR5_NB_2                (0x4UL << JPEG_CONFR5_NB_Pos)           /*!< 0x00000040 */
#define JPEG_CONFR5_NB_3                (0x8UL << JPEG_CONFR5_NB_Pos)           /*!< 0x00000080 */
#define JPEG_CONFR5_VSF_Pos             (8U)
#define JPEG_CONFR5_VSF_Msk             (0xFUL << JPEG_CONFR5_VSF_Pos)         /*!< 0x00000F00 */
#define JPEG_CONFR5_VSF                 JPEG_CONFR5_VSF_Msk                    /*!<Vertical sampling factor for component 2 */
#define JPEG_CONFR5_VSF_0               (0x1UL << JPEG_CONFR5_VSF_Pos)          /*!< 0x00000100 */
#define JPEG_CONFR5_VSF_1               (0x2UL << JPEG_CONFR5_VSF_Pos)          /*!< 0x00000200 */
#define JPEG_CONFR5_VSF_2               (0x4UL << JPEG_CONFR5_VSF_Pos)          /*!< 0x00000400 */
#define JPEG_CONFR5_VSF_3               (0x8UL << JPEG_CONFR5_VSF_Pos)          /*!< 0x00000800 */
#define JPEG_CONFR5_HSF_Pos             (12U)
#define JPEG_CONFR5_HSF_Msk             (0xFUL << JPEG_CONFR5_HSF_Pos)         /*!< 0x0000F000 */
#define JPEG_CONFR5_HSF                 JPEG_CONFR5_HSF_Msk                    /*!<Horizontal sampling factor for component 2 */
#define JPEG_CONFR5_HSF_0               (0x1UL << JPEG_CONFR5_HSF_Pos)          /*!< 0x00001000 */
#define JPEG_CONFR5_HSF_1               (0x2UL << JPEG_CONFR5_HSF_Pos)          /*!< 0x00002000 */
#define JPEG_CONFR5_HSF_2               (0x4UL << JPEG_CONFR5_HSF_Pos)          /*!< 0x00004000 */
#define JPEG_CONFR5_HSF_3               (0x8UL << JPEG_CONFR5_HSF_Pos)          /*!< 0x00008000 */

/********************  Bit definition for CONFR6 register  ********************/
#define JPEG_CONFR6_HD_Pos              (0U)
#define JPEG_CONFR6_HD_Msk              (0x1UL << JPEG_CONFR6_HD_Pos)          /*!< 0x00000001 */
#define JPEG_CONFR6_HD                  JPEG_CONFR6_HD_Msk                     /*!<Selects the Huffman table for encoding the DC coefficients */
#define JPEG_CONFR6_HA_Pos              (1U)
#define JPEG_CONFR6_HA_Msk              (0x1UL << JPEG_CONFR6_HA_Pos)          /*!< 0x00000002 */
#define JPEG_CONFR6_HA                  JPEG_CONFR6_HA_Msk                     /*!<Selects the Huffman table for encoding the AC coefficients */
#define JPEG_CONFR6_QT_Pos              (2U)
#define JPEG_CONFR6_QT_Msk              (0x3UL << JPEG_CONFR6_QT_Pos)          /*!< 0x0000000C */
#define JPEG_CONFR6_QT                  JPEG_CONFR6_QT_Msk                     /*!<Selects quantization table associated with a color component */
#define JPEG_CONFR6_QT_0                (0x1UL << JPEG_CONFR6_QT_Pos)           /*!< 0x00000004 */
#define JPEG_CONFR6_QT_1                (0x2UL << JPEG_CONFR6_QT_Pos)           /*!< 0x00000008 */
#define JPEG_CONFR6_NB_Pos              (4U)
#define JPEG_CONFR6_NB_Msk              (0xFUL << JPEG_CONFR6_NB_Pos)          /*!< 0x000000F0 */
#define JPEG_CONFR6_NB                  JPEG_CONFR6_NB_Msk                     /*!<Number of data units minus 1 that belong to a particular color in the MCU */
#define JPEG_CONFR6_NB_0                (0x1UL << JPEG_CONFR6_NB_Pos)           /*!< 0x00000010 */
#define JPEG_CONFR6_NB_1                (0x2UL << JPEG_CONFR6_NB_Pos)           /*!< 0x00000020 */
#define JPEG_CONFR6_NB_2                (0x4UL << JPEG_CONFR6_NB_Pos)           /*!< 0x00000040 */
#define JPEG_CONFR6_NB_3                (0x8UL << JPEG_CONFR6_NB_Pos)           /*!< 0x00000080 */
#define JPEG_CONFR6_VSF_Pos             (8U)
#define JPEG_CONFR6_VSF_Msk             (0xFUL << JPEG_CONFR6_VSF_Pos)         /*!< 0x00000F00 */
#define JPEG_CONFR6_VSF                 JPEG_CONFR6_VSF_Msk                    /*!<Vertical sampling factor for component 2 */
#define JPEG_CONFR6_VSF_0               (0x1UL << JPEG_CONFR6_VSF_Pos)          /*!< 0x00000100 */
#define JPEG_CONFR6_VSF_1               (0x2UL << JPEG_CONFR6_VSF_Pos)          /*!< 0x00000200 */
#define JPEG_CONFR6_VSF_2               (0x4UL << JPEG_CONFR6_VSF_Pos)          /*!< 0x00000400 */
#define JPEG_CONFR6_VSF_3               (0x8UL << JPEG_CONFR6_VSF_Pos)          /*!< 0x00000800 */
#define JPEG_CONFR6_HSF_Pos             (12U)
#define JPEG_CONFR6_HSF_Msk             (0xFUL << JPEG_CONFR6_HSF_Pos)         /*!< 0x0000F000 */
#define JPEG_CONFR6_HSF                 JPEG_CONFR6_HSF_Msk                    /*!<Horizontal sampling factor for component 2 */
#define JPEG_CONFR6_HSF_0               (0x1UL << JPEG_CONFR6_HSF_Pos)          /*!< 0x00001000 */
#define JPEG_CONFR6_HSF_1               (0x2UL << JPEG_CONFR6_HSF_Pos)          /*!< 0x00002000 */
#define JPEG_CONFR6_HSF_2               (0x4UL << JPEG_CONFR6_HSF_Pos)          /*!< 0x00004000 */
#define JPEG_CONFR6_HSF_3               (0x8UL << JPEG_CONFR6_HSF_Pos)          /*!< 0x00008000 */

/********************  Bit definition for CONFR7 register  ********************/
#define JPEG_CONFR7_HD_Pos              (0U)
#define JPEG_CONFR7_HD_Msk              (0x1UL << JPEG_CONFR7_HD_Pos)          /*!< 0x00000001 */
#define JPEG_CONFR7_HD                  JPEG_CONFR7_HD_Msk                     /*!<Selects the Huffman table for encoding the DC coefficients */
#define JPEG_CONFR7_HA_Pos              (1U)
#define JPEG_CONFR7_HA_Msk              (0x1UL << JPEG_CONFR7_HA_Pos)          /*!< 0x00000002 */
#define JPEG_CONFR7_HA                  JPEG_CONFR7_HA_Msk                     /*!<Selects the Huffman table for encoding the AC coefficients */
#define JPEG_CONFR7_QT_Pos              (2U)
#define JPEG_CONFR7_QT_Msk              (0x3UL << JPEG_CONFR7_QT_Pos)          /*!< 0x0000000C */
#define JPEG_CONFR7_QT                  JPEG_CONFR7_QT_Msk                     /*!<Selects quantization table associated with a color component */
#define JPEG_CONFR7_QT_0                (0x1UL << JPEG_CONFR7_QT_Pos)           /*!< 0x00000004 */
#define JPEG_CONFR7_QT_1                (0x2UL << JPEG_CONFR7_QT_Pos)           /*!< 0x00000008 */
#define JPEG_CONFR7_NB_Pos              (4U)
#define JPEG_CONFR7_NB_Msk              (0xFUL << JPEG_CONFR7_NB_Pos)          /*!< 0x000000F0 */
#define JPEG_CONFR7_NB                  JPEG_CONFR7_NB_Msk                     /*!<Number of data units minus 1 that belong to a particular color in the MCU */
#define JPEG_CONFR7_NB_0                (0x1UL << JPEG_CONFR7_NB_Pos)           /*!< 0x00000010 */
#define JPEG_CONFR7_NB_1                (0x2UL << JPEG_CONFR7_NB_Pos)           /*!< 0x00000020 */
#define JPEG_CONFR7_NB_2                (0x4UL << JPEG_CONFR7_NB_Pos)           /*!< 0x00000040 */
#define JPEG_CONFR7_NB_3                (0x8UL << JPEG_CONFR7_NB_Pos)           /*!< 0x00000080 */
#define JPEG_CONFR7_VSF_Pos             (8U)
#define JPEG_CONFR7_VSF_Msk             (0xFUL << JPEG_CONFR7_VSF_Pos)         /*!< 0x00000F00 */
#define JPEG_CONFR7_VSF                 JPEG_CONFR7_VSF_Msk                    /*!<Vertical sampling factor for component 2 */
#define JPEG_CONFR7_VSF_0               (0x1UL << JPEG_CONFR7_VSF_Pos)          /*!< 0x00000100 */
#define JPEG_CONFR7_VSF_1               (0x2UL << JPEG_CONFR7_VSF_Pos)          /*!< 0x00000200 */
#define JPEG_CONFR7_VSF_2               (0x4UL << JPEG_CONFR7_VSF_Pos)          /*!< 0x00000400 */
#define JPEG_CONFR7_VSF_3               (0x8UL << JPEG_CONFR7_VSF_Pos)          /*!< 0x00000800 */
#define JPEG_CONFR7_HSF_Pos             (12U)
#define JPEG_CONFR7_HSF_Msk             (0xFUL << JPEG_CONFR7_HSF_Pos)         /*!< 0x0000F000 */
#define JPEG_CONFR7_HSF                 JPEG_CONFR7_HSF_Msk                    /*!<Horizontal sampling factor for component 2 */
#define JPEG_CONFR7_HSF_0               (0x1UL << JPEG_CONFR7_HSF_Pos)          /*!< 0x00001000 */
#define JPEG_CONFR7_HSF_1               (0x2UL << JPEG_CONFR7_HSF_Pos)          /*!< 0x00002000 */
#define JPEG_CONFR7_HSF_2               (0x4UL << JPEG_CONFR7_HSF_Pos)          /*!< 0x00004000 */
#define JPEG_CONFR7_HSF_3               (0x8UL << JPEG_CONFR7_HSF_Pos)          /*!< 0x00008000 */

/********************  Bit definition for CR register  ********************/
#define JPEG_CR_JCEN_Pos                (0U)
#define JPEG_CR_JCEN_Msk                (0x1UL << JPEG_CR_JCEN_Pos)            /*!< 0x00000001 */
#define JPEG_CR_JCEN                    JPEG_CR_JCEN_Msk                       /*!<Enable the JPEG Codec Core */
#define JPEG_CR_IFTIE_Pos               (1U)
#define JPEG_CR_IFTIE_Msk               (0x1UL << JPEG_CR_IFTIE_Pos)           /*!< 0x00000002 */
#define JPEG_CR_IFTIE                   JPEG_CR_IFTIE_Msk                      /*!<Input FIFO Threshold Interrupt Enable */
#define JPEG_CR_IFNFIE_Pos              (2U)
#define JPEG_CR_IFNFIE_Msk              (0x1UL << JPEG_CR_IFNFIE_Pos)          /*!< 0x00000004 */
#define JPEG_CR_IFNFIE                  JPEG_CR_IFNFIE_Msk                     /*!<Input FIFO Not Full Interrupt Enable */
#define JPEG_CR_OFTIE_Pos               (3U)
#define JPEG_CR_OFTIE_Msk               (0x1UL << JPEG_CR_OFTIE_Pos)           /*!< 0x00000008 */
#define JPEG_CR_OFTIE                   JPEG_CR_OFTIE_Msk                      /*!<Output FIFO Threshold Interrupt Enable */
#define JPEG_CR_OFNEIE_Pos              (4U)
#define JPEG_CR_OFNEIE_Msk              (0x1UL << JPEG_CR_OFNEIE_Pos)          /*!< 0x00000010 */
#define JPEG_CR_OFNEIE                  JPEG_CR_OFNEIE_Msk                     /*!<Output FIFO Not Empty Interrupt Enable */
#define JPEG_CR_EOCIE_Pos               (5U)
#define JPEG_CR_EOCIE_Msk               (0x1UL << JPEG_CR_EOCIE_Pos)           /*!< 0x00000020 */
#define JPEG_CR_EOCIE                   JPEG_CR_EOCIE_Msk                      /*!<End of Conversion Interrupt Enable */
#define JPEG_CR_HPDIE_Pos               (6U)
#define JPEG_CR_HPDIE_Msk               (0x1UL << JPEG_CR_HPDIE_Pos)           /*!< 0x00000040 */
#define JPEG_CR_HPDIE                   JPEG_CR_HPDIE_Msk                      /*!<Header Parsing Done Interrupt Enable */
#define JPEG_CR_IDMAEN_Pos              (11U)
#define JPEG_CR_IDMAEN_Msk              (0x1UL << JPEG_CR_IDMAEN_Pos)           /*!< 0x00000800 */
#define JPEG_CR_IDMAEN                  JPEG_CR_IDMAEN_Msk                     /*!<Enable the DMA request generation for the input FIFO */
#define JPEG_CR_ODMAEN_Pos              (12U)
#define JPEG_CR_ODMAEN_Msk              (0x1UL << JPEG_CR_ODMAEN_Pos)           /*!< 0x00001000 */
#define JPEG_CR_ODMAEN                  JPEG_CR_ODMAEN_Msk                     /*!<Enable the DMA request generation for the output FIFO */
#define JPEG_CR_IFF_Pos                 (13U)
#define JPEG_CR_IFF_Msk                 (0x1UL << JPEG_CR_IFF_Pos)             /*!< 0x00002000 */
#define JPEG_CR_IFF                     JPEG_CR_IFF_Msk                        /*!<Flush the input FIFO */
#define JPEG_CR_OFF_Pos                 (14U)
#define JPEG_CR_OFF_Msk                 (0x1UL << JPEG_CR_OFF_Pos)             /*!< 0x00004000 */
#define JPEG_CR_OFF                     JPEG_CR_OFF_Msk                        /*!<Flush the output FIFO */

/********************  Bit definition for SR register  ********************/
#define JPEG_SR_IFTF_Pos                (1U)
#define JPEG_SR_IFTF_Msk                (0x1UL << JPEG_SR_IFTF_Pos)            /*!< 0x00000002 */
#define JPEG_SR_IFTF                    JPEG_SR_IFTF_Msk                       /*!<Input FIFO is not full and is below its threshold flag */
#define JPEG_SR_IFNFF_Pos               (2U)
#define JPEG_SR_IFNFF_Msk               (0x1UL << JPEG_SR_IFNFF_Pos)           /*!< 0x00000004 */
#define JPEG_SR_IFNFF                   JPEG_SR_IFNFF_Msk                      /*!<Input FIFO Not Full Flag, a data can be written */
#define JPEG_SR_OFTF_Pos                (3U)
#define JPEG_SR_OFTF_Msk                (0x1UL << JPEG_SR_OFTF_Pos)            /*!< 0x00000008 */
#define JPEG_SR_OFTF                    JPEG_SR_OFTF_Msk                       /*!<Output FIFO is not empty and has reach its threshold */
#define JPEG_SR_OFNEF_Pos               (4U)
#define JPEG_SR_OFNEF_Msk               (0x1UL << JPEG_SR_OFNEF_Pos)           /*!< 0x00000010 */
#define JPEG_SR_OFNEF                   JPEG_SR_OFNEF_Msk                      /*!<Output FIFO is not empty, a data is available */
#define JPEG_SR_EOCF_Pos                (5U)
#define JPEG_SR_EOCF_Msk                (0x1UL << JPEG_SR_EOCF_Pos)            /*!< 0x00000020 */
#define JPEG_SR_EOCF                    JPEG_SR_EOCF_Msk                       /*!<JPEG Codec core has finished the encoding or the decoding process and than last data has been sent to the output FIFO */
#define JPEG_SR_HPDF_Pos                (6U)
#define JPEG_SR_HPDF_Msk                (0x1UL << JPEG_SR_HPDF_Pos)            /*!< 0x00000040 */
#define JPEG_SR_HPDF                    JPEG_SR_HPDF_Msk                       /*!<JPEG Codec has finished the parsing of the headers and the internal registers have been updated */
#define JPEG_SR_COF_Pos                 (7U)
#define JPEG_SR_COF_Msk                 (0x1UL << JPEG_SR_COF_Pos)             /*!< 0x00000080 */
#define JPEG_SR_COF                     JPEG_SR_COF_Msk                        /*!<JPEG Codec operation on going flag */

/********************  Bit definition for CFR register  ********************/
#define JPEG_CFR_CEOCF_Pos              (4U)
#define JPEG_CFR_CEOCF_Msk              (0x1UL << JPEG_CFR_CEOCF_Pos)          /*!< 0x00000010 */
#define JPEG_CFR_CEOCF                  JPEG_CFR_CEOCF_Msk                     /*!<Clear End of Conversion Flag */
#define JPEG_CFR_CHPDF_Pos              (5U)
#define JPEG_CFR_CHPDF_Msk              (0x1UL << JPEG_CFR_CHPDF_Pos)          /*!< 0x00000020 */
#define JPEG_CFR_CHPDF                  JPEG_CFR_CHPDF_Msk                     /*!<Clear Header Parsing Done Flag */

/********************  Bit definition for DIR register  ********************/
#define JPEG_DIR_DATAIN_Pos             (0U)
#define JPEG_DIR_DATAIN_Msk             (0xFFFFFFFFUL << JPEG_DIR_DATAIN_Pos)  /*!< 0xFFFFFFFF */
#define JPEG_DIR_DATAIN                 JPEG_DIR_DATAIN_Msk                    /*!<Data Input FIFO */

/********************  Bit definition for DOR register  ********************/
#define JPEG_DOR_DATAOUT_Pos            (0U)
#define JPEG_DOR_DATAOUT_Msk            (0xFFFFFFFFUL << JPEG_DOR_DATAOUT_Pos) /*!< 0xFFFFFFFF */
#define JPEG_DOR_DATAOUT                JPEG_DOR_DATAOUT_Msk                   /*!<Data Output FIFO */

/******************************************************************************/
/*                                                                            */
/*                       Low Power General Purpose IOs (LPGPIO)               */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for LPGPIO_MODER register  *****************/
#define LPGPIO_MODER_MOD0_Pos               (0U)
#define LPGPIO_MODER_MOD0_Msk               (0x1UL << LPGPIO_MODER_MOD0_Pos)        /*!< 0x00000001 */
#define LPGPIO_MODER_MOD0                   LPGPIO_MODER_MOD0_Msk
#define LPGPIO_MODER_MOD1_Pos               (1U)
#define LPGPIO_MODER_MOD1_Msk               (0x1UL << LPGPIO_MODER_MOD1_Pos)        /*!< 0x00000002 */
#define LPGPIO_MODER_MOD1                   LPGPIO_MODER_MOD1_Msk
#define LPGPIO_MODER_MOD2_Pos               (2U)
#define LPGPIO_MODER_MOD2_Msk               (0x1UL << LPGPIO_MODER_MOD2_Pos)        /*!< 0x00000004 */
#define LPGPIO_MODER_MOD2                   LPGPIO_MODER_MOD2_Msk
#define LPGPIO_MODER_MOD3_Pos               (3U)
#define LPGPIO_MODER_MOD3_Msk               (0x1UL << LPGPIO_MODER_MOD3_Pos)        /*!< 0x00000008 */
#define LPGPIO_MODER_MOD3                   LPGPIO_MODER_MOD3_Msk
#define LPGPIO_MODER_MOD4_Pos               (4U)
#define LPGPIO_MODER_MOD4_Msk               (0x1UL << LPGPIO_MODER_MOD4_Pos)        /*!< 0x00000010 */
#define LPGPIO_MODER_MOD4                   LPGPIO_MODER_MOD4_Msk
#define LPGPIO_MODER_MOD5_Pos               (5U)
#define LPGPIO_MODER_MOD5_Msk               (0x1UL << LPGPIO_MODER_MOD5_Pos)        /*!< 0x00000020 */
#define LPGPIO_MODER_MOD5                   LPGPIO_MODER_MOD5_Msk
#define LPGPIO_MODER_MOD6_Pos               (6U)
#define LPGPIO_MODER_MOD6_Msk               (0x1UL << LPGPIO_MODER_MOD6_Pos)        /*!< 0x00000040 */
#define LPGPIO_MODER_MOD6                   LPGPIO_MODER_MOD6_Msk
#define LPGPIO_MODER_MOD7_Pos               (7U)
#define LPGPIO_MODER_MOD7_Msk               (0x1UL << LPGPIO_MODER_MOD7_Pos)        /*!< 0x00000080 */
#define LPGPIO_MODER_MOD7                   LPGPIO_MODER_MOD7_Msk
#define LPGPIO_MODER_MOD8_Pos               (8U)
#define LPGPIO_MODER_MOD8_Msk               (0x1UL << LPGPIO_MODER_MOD8_Pos)        /*!< 0x00000100 */
#define LPGPIO_MODER_MOD8                   LPGPIO_MODER_MOD8_Msk
#define LPGPIO_MODER_MOD9_Pos               (9U)
#define LPGPIO_MODER_MOD9_Msk               (0x1UL << LPGPIO_MODER_MOD9_Pos)        /*!< 0x00000200 */
#define LPGPIO_MODER_MOD9                   LPGPIO_MODER_MOD9_Msk
#define LPGPIO_MODER_MOD10_Pos              (10U)
#define LPGPIO_MODER_MOD10_Msk              (0x1UL << LPGPIO_MODER_MOD10_Pos)       /*!< 0x00000400 */
#define LPGPIO_MODER_MOD10                  LPGPIO_MODER_MOD10_Msk
#define LPGPIO_MODER_MOD11_Pos              (11U)
#define LPGPIO_MODER_MOD11_Msk              (0x1UL << LPGPIO_MODER_MOD11_Pos)       /*!< 0x00000800 */
#define LPGPIO_MODER_MOD11                  LPGPIO_MODER_MOD11_Msk
#define LPGPIO_MODER_MOD12_Pos              (12U)
#define LPGPIO_MODER_MOD12_Msk              (0x1UL << LPGPIO_MODER_MOD12_Pos)       /*!< 0x00001000 */
#define LPGPIO_MODER_MOD12                  LPGPIO_MODER_MOD12_Msk
#define LPGPIO_MODER_MOD13_Pos              (13U)
#define LPGPIO_MODER_MOD13_Msk              (0x1UL << LPGPIO_MODER_MOD13_Pos)       /*!< 0x00002000 */
#define LPGPIO_MODER_MOD13                  LPGPIO_MODER_MOD13_Msk
#define LPGPIO_MODER_MOD14_Pos              (14U)
#define LPGPIO_MODER_MOD14_Msk              (0x1UL << LPGPIO_MODER_MOD14_Pos)       /*!< 0x00004000 */
#define LPGPIO_MODER_MOD14                  LPGPIO_MODER_MOD14_Msk
#define LPGPIO_MODER_MOD15_Pos              (15U)
#define LPGPIO_MODER_MOD15_Msk              (0x1UL << LPGPIO_MODER_MOD15_Pos)       /*!< 0x00008000 */
#define LPGPIO_MODER_MOD15                  LPGPIO_MODER_MOD15_Msk

/******************  Bits definition for LPGPIO_IDR register  *******************/
#define LPGPIO_IDR_ID0_Pos                  (0U)
#define LPGPIO_IDR_ID0_Msk                  (0x1UL << LPGPIO_IDR_ID0_Pos)           /*!< 0x00000001 */
#define LPGPIO_IDR_ID0                      LPGPIO_IDR_ID0_Msk
#define LPGPIO_IDR_ID1_Pos                  (1U)
#define LPGPIO_IDR_ID1_Msk                  (0x1UL << GPIO_IDR_ID1_Pos)             /*!< 0x00000002 */
#define LPGPIO_IDR_ID1                      LPGPIO_IDR_ID1_Msk
#define LPGPIO_IDR_ID2_Pos                  (2U)
#define LPGPIO_IDR_ID2_Msk                  (0x1UL << LPGPIO_IDR_ID2_Pos)           /*!< 0x00000004 */
#define LPGPIO_IDR_ID2                      LPGPIO_IDR_ID2_Msk
#define LPGPIO_IDR_ID3_Pos                  (3U)
#define LPGPIO_IDR_ID3_Msk                  (0x1UL << LPGPIO_IDR_ID3_Pos)           /*!< 0x00000008 */
#define LPGPIO_IDR_ID3                      LPGPIO_IDR_ID3_Msk
#define LPGPIO_IDR_ID4_Pos                  (4U)
#define LPGPIO_IDR_ID4_Msk                  (0x1UL << LPGPIO_IDR_ID4_Pos)           /*!< 0x00000010 */
#define LPGPIO_IDR_ID4                      LPGPIO_IDR_ID4_Msk
#define LPGPIO_IDR_ID5_Pos                  (5U)
#define LPGPIO_IDR_ID5_Msk                  (0x1UL << LPGPIO_IDR_ID5_Pos)           /*!< 0x00000020 */
#define LPGPIO_IDR_ID5                      LPGPIO_IDR_ID5_Msk
#define LPGPIO_IDR_ID6_Pos                  (6U)
#define LPGPIO_IDR_ID6_Msk                  (0x1UL << LPGPIO_IDR_ID6_Pos)           /*!< 0x00000040 */
#define LPGPIO_IDR_ID6                      LPGPIO_IDR_ID6_Msk
#define LPGPIO_IDR_ID7_Pos                  (7U)
#define LPGPIO_IDR_ID7_Msk                  (0x1UL << LPGPIO_IDR_ID7_Pos)           /*!< 0x00000080 */
#define LPGPIO_IDR_ID7                      LPGPIO_IDR_ID7_Msk
#define LPGPIO_IDR_ID8_Pos                  (8U)
#define LPGPIO_IDR_ID8_Msk                  (0x1UL << LPGPIO_IDR_ID8_Pos)           /*!< 0x00000100 */
#define LPGPIO_IDR_ID8                      LPGPIO_IDR_ID8_Msk
#define LPGPIO_IDR_ID9_Pos                  (9U)
#define LPGPIO_IDR_ID9_Msk                  (0x1UL << LPGPIO_IDR_ID9_Pos)           /*!< 0x00000200 */
#define LPGPIO_IDR_ID9                      LPGPIO_IDR_ID9_Msk
#define LPGPIO_IDR_ID10_Pos                 (10U)
#define LPGPIO_IDR_ID10_Msk                 (0x1UL << LPGPIO_IDR_ID10_Pos)          /*!< 0x00000400 */
#define LPGPIO_IDR_ID10                     LPGPIO_IDR_ID10_Msk
#define LPGPIO_IDR_ID11_Pos                 (11U)
#define LPGPIO_IDR_ID11_Msk                 (0x1UL << LPGPIO_IDR_ID11_Pos)          /*!< 0x00000800 */
#define LPGPIO_IDR_ID11                     LPGPIO_IDR_ID11_Msk
#define LPGPIO_IDR_ID12_Pos                 (12U)
#define LPGPIO_IDR_ID12_Msk                 (0x1UL << LPGPIO_IDR_ID12_Pos)          /*!< 0x00001000 */
#define LPGPIO_IDR_ID12                     LPGPIO_IDR_ID12_Msk
#define LPGPIO_IDR_ID13_Pos                 (13U)
#define LPGPIO_IDR_ID13_Msk                 (0x1UL << LPGPIO_IDR_ID13_Pos)          /*!< 0x00002000 */
#define LPGPIO_IDR_ID13                     LPGPIO_IDR_ID13_Msk
#define LPGPIO_IDR_ID14_Pos                 (14U)
#define LPGPIO_IDR_ID14_Msk                 (0x1UL << LPGPIO_IDR_ID14_Pos)          /*!< 0x00004000 */
#define LPGPIO_IDR_ID14                     LPGPIO_IDR_ID14_Msk
#define LPGPIO_IDR_ID15_Pos                 (15U)
#define LPGPIO_IDR_ID15_Msk                 (0x1UL << LPGPIO_IDR_ID15_Pos)          /*!< 0x00008000 */
#define LPGPIO_IDR_ID15                     LPGPIO_IDR_ID15_Msk

/******************  Bits definition for LPGPIO_ODR register  *******************/
#define LPGPIO_ODR_OD0_Pos                  (0U)
#define LPGPIO_ODR_OD0_Msk                  (0x1UL << LPGPIO_ODR_OD0_Pos)           /*!< 0x00000001 */
#define LPGPIO_ODR_OD0                      LPGPIO_ODR_OD0_Msk
#define LPGPIO_ODR_OD1_Pos                  (1U)
#define LPGPIO_ODR_OD1_Msk                  (0x1UL << LPGPIO_ODR_OD1_Pos)           /*!< 0x00000002 */
#define LPGPIO_ODR_OD1                      LPGPIO_ODR_OD1_Msk
#define LPGPIO_ODR_OD2_Pos                  (2U)
#define LPGPIO_ODR_OD2_Msk                  (0x1UL << LPGPIO_ODR_OD2_Pos)           /*!< 0x00000004 */
#define LPGPIO_ODR_OD2                      LPGPIO_ODR_OD2_Msk
#define LPGPIO_ODR_OD3_Pos                  (3U)
#define LPGPIO_ODR_OD3_Msk                  (0x1UL << LPGPIO_ODR_OD3_Pos)           /*!< 0x00000008 */
#define LPGPIO_ODR_OD3                      LPGPIO_ODR_OD3_Msk
#define LPGPIO_ODR_OD4_Pos                  (4U)
#define LPGPIO_ODR_OD4_Msk                  (0x1UL << LPGPIO_ODR_OD4_Pos)           /*!< 0x00000010 */
#define LPGPIO_ODR_OD4                      LPGPIO_ODR_OD4_Msk
#define LPGPIO_ODR_OD5_Pos                  (5U)
#define LPGPIO_ODR_OD5_Msk                  (0x1UL << LPGPIO_ODR_OD5_Pos)           /*!< 0x00000020 */
#define LPGPIO_ODR_OD5                      LPGPIO_ODR_OD5_Msk
#define LPGPIO_ODR_OD6_Pos                  (6U)
#define LPGPIO_ODR_OD6_Msk                  (0x1UL << LPGPIO_ODR_OD6_Pos)           /*!< 0x00000040 */
#define LPGPIO_ODR_OD6                      LPGPIO_ODR_OD6_Msk
#define LPGPIO_ODR_OD7_Pos                  (7U)
#define LPGPIO_ODR_OD7_Msk                  (0x1UL << LPGPIO_ODR_OD7_Pos)           /*!< 0x00000080 */
#define LPGPIO_ODR_OD7                      LPGPIO_ODR_OD7_Msk
#define LPGPIO_ODR_OD8_Pos                  (8U)
#define LPGPIO_ODR_OD8_Msk                  (0x1UL << LPGPIO_ODR_OD8_Pos)           /*!< 0x00000100 */
#define LPGPIO_ODR_OD8                      LPGPIO_ODR_OD8_Msk
#define LPGPIO_ODR_OD9_Pos                  (9U)
#define LPGPIO_ODR_OD9_Msk                  (0x1UL << LPGPIO_ODR_OD9_Pos)           /*!< 0x00000200 */
#define LPGPIO_ODR_OD9                      LPGPIO_ODR_OD9_Msk
#define LPGPIO_ODR_OD10_Pos                 (10U)
#define LPGPIO_ODR_OD10_Msk                 (0x1UL << LPGPIO_ODR_OD10_Pos)          /*!< 0x00000400 */
#define LPGPIO_ODR_OD10                     LPGPIO_ODR_OD10_Msk
#define LPGPIO_ODR_OD11_Pos                 (11U)
#define LPGPIO_ODR_OD11_Msk                 (0x1UL << LPGPIO_ODR_OD11_Pos)          /*!< 0x00000800 */
#define LPGPIO_ODR_OD11                     LPGPIO_ODR_OD11_Msk
#define LPGPIO_ODR_OD12_Pos                 (12U)
#define LPGPIO_ODR_OD12_Msk                 (0x1UL << LPGPIO_ODR_OD12_Pos)          /*!< 0x00001000 */
#define LPGPIO_ODR_OD12                     LPGPIO_ODR_OD12_Msk
#define LPGPIO_ODR_OD13_Pos                 (13U)
#define LPGPIO_ODR_OD13_Msk                 (0x1UL << LPGPIO_ODR_OD13_Pos)          /*!< 0x00002000 */
#define LPGPIO_ODR_OD13                     LPGPIO_ODR_OD13_Msk
#define LPGPIO_ODR_OD14_Pos                 (14U)
#define LPGPIO_ODR_OD14_Msk                 (0x1UL << LPGPIO_ODR_OD14_Pos)          /*!< 0x00004000 */
#define LPGPIO_ODR_OD14                     LPGPIO_ODR_OD14_Msk
#define LPGPIO_ODR_OD15_Pos                 (15U)
#define LPGPIO_ODR_OD15_Msk                 (0x1UL << LPGPIO_ODR_OD15_Pos)          /*!< 0x00008000 */
#define LPGPIO_ODR_OD15                     LPGPIO_ODR_OD15_Msk

/******************  Bits definition for LPGPIO_BSRR register  ******************/
#define LPGPIO_BSRR_BS0_Pos                 (0U)
#define LPGPIO_BSRR_BS0_Msk                 (0x1UL << LPGPIO_BSRR_BS0_Pos)          /*!< 0x00000001 */
#define LPGPIO_BSRR_BS0                     LPGPIO_BSRR_BS0_Msk
#define LPGPIO_BSRR_BS1_Pos                 (1U)
#define LPGPIO_BSRR_BS1_Msk                 (0x1UL << LPGPIO_BSRR_BS1_Pos)          /*!< 0x00000002 */
#define LPGPIO_BSRR_BS1                     LPGPIO_BSRR_BS1_Msk
#define LPGPIO_BSRR_BS2_Pos                 (2U)
#define LPGPIO_BSRR_BS2_Msk                 (0x1UL << LPGPIO_BSRR_BS2_Pos)          /*!< 0x00000004 */
#define LPGPIO_BSRR_BS2                     LPGPIO_BSRR_BS2_Msk
#define LPGPIO_BSRR_BS3_Pos                 (3U)
#define LPGPIO_BSRR_BS3_Msk                 (0x1UL << LPGPIO_BSRR_BS3_Pos)          /*!< 0x00000008 */
#define LPGPIO_BSRR_BS3                     LPGPIO_BSRR_BS3_Msk
#define LPGPIO_BSRR_BS4_Pos                 (4U)
#define LPGPIO_BSRR_BS4_Msk                 (0x1UL << LPGPIO_BSRR_BS4_Pos)          /*!< 0x00000010 */
#define LPGPIO_BSRR_BS4                     LPGPIO_BSRR_BS4_Msk
#define LPGPIO_BSRR_BS5_Pos                 (5U)
#define LPGPIO_BSRR_BS5_Msk                 (0x1UL << LPGPIO_BSRR_BS5_Pos)          /*!< 0x00000020 */
#define LPGPIO_BSRR_BS5                     LPGPIO_BSRR_BS5_Msk
#define LPGPIO_BSRR_BS6_Pos                 (6U)
#define LPGPIO_BSRR_BS6_Msk                 (0x1UL << LPGPIO_BSRR_BS6_Pos)          /*!< 0x00000040 */
#define LPGPIO_BSRR_BS6                     LPGPIO_BSRR_BS6_Msk
#define LPGPIO_BSRR_BS7_Pos                 (7U)
#define LPGPIO_BSRR_BS7_Msk                 (0x1UL << LPGPIO_BSRR_BS7_Pos)          /*!< 0x00000080 */
#define LPGPIO_BSRR_BS7                     LPGPIO_BSRR_BS7_Msk
#define LPGPIO_BSRR_BS8_Pos                 (8U)
#define LPGPIO_BSRR_BS8_Msk                 (0x1UL << LPGPIO_BSRR_BS8_Pos)          /*!< 0x00000100 */
#define LPGPIO_BSRR_BS8                     LPGPIO_BSRR_BS8_Msk
#define LPGPIO_BSRR_BS9_Pos                 (9U)
#define LPGPIO_BSRR_BS9_Msk                 (0x1UL << LPGPIO_BSRR_BS9_Pos)          /*!< 0x00000200 */
#define LPGPIO_BSRR_BS9                     LPGPIO_BSRR_BS9_Msk
#define LPGPIO_BSRR_BS10_Pos                (10U)
#define LPGPIO_BSRR_BS10_Msk                (0x1UL << LPGPIO_BSRR_BS10_Pos)         /*!< 0x00000400 */
#define LPGPIO_BSRR_BS10                    LPGPIO_BSRR_BS10_Msk
#define LPGPIO_BSRR_BS11_Pos                (11U)
#define LPGPIO_BSRR_BS11_Msk                (0x1UL << LPGPIO_BSRR_BS11_Pos)         /*!< 0x00000800 */
#define LPGPIO_BSRR_BS11                    LPGPIO_BSRR_BS11_Msk
#define LPGPIO_BSRR_BS12_Pos                (12U)
#define LPGPIO_BSRR_BS12_Msk                (0x1UL << LPGPIO_BSRR_BS12_Pos)         /*!< 0x00001000 */
#define LPGPIO_BSRR_BS12                    LPGPIO_BSRR_BS12_Msk
#define LPGPIO_BSRR_BS13_Pos                (13U)
#define LPGPIO_BSRR_BS13_Msk                (0x1UL << LPGPIO_BSRR_BS13_Pos)         /*!< 0x00002000 */
#define LPGPIO_BSRR_BS13                    LPGPIO_BSRR_BS13_Msk
#define LPGPIO_BSRR_BS14_Pos                (14U)
#define LPGPIO_BSRR_BS14_Msk                (0x1UL << LPGPIO_BSRR_BS14_Pos)         /*!< 0x00004000 */
#define LPGPIO_BSRR_BS14                    LPGPIO_BSRR_BS14_Msk
#define LPGPIO_BSRR_BS15_Pos                (15U)
#define LPGPIO_BSRR_BS15_Msk                (0x1UL << LPGPIO_BSRR_BS15_Pos)         /*!< 0x00008000 */
#define LPGPIO_BSRR_BS15                    LPGPIO_BSRR_BS15_Msk
#define LPGPIO_BSRR_BR0_Pos                 (16U)
#define LPGPIO_BSRR_BR0_Msk                 (0x1UL << LPGPIO_BSRR_BR0_Pos)          /*!< 0x00010000 */
#define LPGPIO_BSRR_BR0                     LPGPIO_BSRR_BR0_Msk
#define LPGPIO_BSRR_BR1_Pos                 (17U)
#define LPGPIO_BSRR_BR1_Msk                 (0x1UL << LPGPIO_BSRR_BR1_Pos)          /*!< 0x00020000 */
#define LPGPIO_BSRR_BR1                     LPGPIO_BSRR_BR1_Msk
#define LPGPIO_BSRR_BR2_Pos                 (18U)
#define LPGPIO_BSRR_BR2_Msk                 (0x1UL << LPGPIO_BSRR_BR2_Pos)          /*!< 0x00040000 */
#define LPGPIO_BSRR_BR2                     LPGPIO_BSRR_BR2_Msk
#define LPGPIO_BSRR_BR3_Pos                 (19U)
#define LPGPIO_BSRR_BR3_Msk                 (0x1UL << LPGPIO_BSRR_BR3_Pos)          /*!< 0x00080000 */
#define LPGPIO_BSRR_BR3                     LPGPIO_BSRR_BR3_Msk
#define LPGPIO_BSRR_BR4_Pos                 (20U)
#define LPGPIO_BSRR_BR4_Msk                 (0x1UL << LPGPIO_BSRR_BR4_Pos)          /*!< 0x00100000 */
#define LPGPIO_BSRR_BR4                     LPGPIO_BSRR_BR4_Msk
#define LPGPIO_BSRR_BR5_Pos                 (21U)
#define LPGPIO_BSRR_BR5_Msk                 (0x1UL << LPGPIO_BSRR_BR5_Pos)          /*!< 0x00200000 */
#define LPGPIO_BSRR_BR5                     LPGPIO_BSRR_BR5_Msk
#define LPGPIO_BSRR_BR6_Pos                 (22U)
#define LPGPIO_BSRR_BR6_Msk                 (0x1UL << LPGPIO_BSRR_BR6_Pos)          /*!< 0x00400000 */
#define LPGPIO_BSRR_BR6                     LPGPIO_BSRR_BR6_Msk
#define LPGPIO_BSRR_BR7_Pos                 (23U)
#define LPGPIO_BSRR_BR7_Msk                 (0x1UL << LPGPIO_BSRR_BR7_Pos)          /*!< 0x00800000 */
#define LPGPIO_BSRR_BR7                     LPGPIO_BSRR_BR7_Msk
#define LPGPIO_BSRR_BR8_Pos                 (24U)
#define LPGPIO_BSRR_BR8_Msk                 (0x1UL << LPGPIO_BSRR_BR8_Pos)          /*!< 0x01000000 */
#define LPGPIO_BSRR_BR8                     LPGPIO_BSRR_BR8_Msk
#define LPGPIO_BSRR_BR9_Pos                 (25U)
#define LPGPIO_BSRR_BR9_Msk                 (0x1UL << LPGPIO_BSRR_BR9_Pos)          /*!< 0x02000000 */
#define LPGPIO_BSRR_BR9                     LPGPIO_BSRR_BR9_Msk
#define LPGPIO_BSRR_BR10_Pos                (26U)
#define LPGPIO_BSRR_BR10_Msk                (0x1UL << LPGPIO_BSRR_BR10_Pos)         /*!< 0x04000000 */
#define LPGPIO_BSRR_BR10                    LPGPIO_BSRR_BR10_Msk
#define LPGPIO_BSRR_BR11_Pos                (27U)
#define LPGPIO_BSRR_BR11_Msk                (0x1UL << LPGPIO_BSRR_BR11_Pos)         /*!< 0x08000000 */
#define LPGPIO_BSRR_BR11                    LPGPIO_BSRR_BR11_Msk
#define LPGPIO_BSRR_BR12_Pos                (28U)
#define LPGPIO_BSRR_BR12_Msk                (0x1UL << LPGPIO_BSRR_BR12_Pos)         /*!< 0x10000000 */
#define LPGPIO_BSRR_BR12                    LPGPIO_BSRR_BR12_Msk
#define LPGPIO_BSRR_BR13_Pos                (29U)
#define LPGPIO_BSRR_BR13_Msk                (0x1UL << LPGPIO_BSRR_BR13_Pos)         /*!< 0x20000000 */
#define LPGPIO_BSRR_BR13                    LPGPIO_BSRR_BR13_Msk
#define LPGPIO_BSRR_BR14_Pos                (30U)
#define LPGPIO_BSRR_BR14_Msk                (0x1UL << LPGPIO_BSRR_BR14_Pos)         /*!< 0x40000000 */
#define LPGPIO_BSRR_BR14                    LPGPIO_BSRR_BR14_Msk
#define LPGPIO_BSRR_BR15_Pos                (31U)
#define LPGPIO_BSRR_BR15_Msk                (0x1UL << LPGPIO_BSRR_BR15_Pos)         /*!< 0x80000000 */
#define LPGPIO_BSRR_BR15                    LPGPIO_BSRR_BR15_Msk

/******************  Bits definition for LPGPIO_BRR register  ******************/
#define LPGPIO_BRR_BR0_Pos                  (0U)
#define LPGPIO_BRR_BR0_Msk                  (0x1UL << LPGPIO_BRR_BR0_Pos)           /*!< 0x00000001 */
#define LPGPIO_BRR_BR0                      LPGPIO_BRR_BR0_Msk
#define LPGPIO_BRR_BR1_Pos                  (1U)
#define LPGPIO_BRR_BR1_Msk                  (0x1UL << LPGPIO_BRR_BR1_Pos)           /*!< 0x00000002 */
#define LPGPIO_BRR_BR1                      LPGPIO_BRR_BR1_Msk
#define LPGPIO_BRR_BR2_Pos                  (2U)
#define LPGPIO_BRR_BR2_Msk                  (0x1UL << LPGPIO_BRR_BR2_Pos)           /*!< 0x00000004 */
#define LPGPIO_BRR_BR2                      LPGPIO_BRR_BR2_Msk
#define LPGPIO_BRR_BR3_Pos                  (3U)
#define LPGPIO_BRR_BR3_Msk                  (0x1UL << LPGPIO_BRR_BR3_Pos)           /*!< 0x00000008 */
#define LPGPIO_BRR_BR3                      LPGPIO_BRR_BR3_Msk
#define LPGPIO_BRR_BR4_Pos                  (4U)
#define LPGPIO_BRR_BR4_Msk                  (0x1UL << LPGPIO_BRR_BR4_Pos)           /*!< 0x00000010 */
#define LPGPIO_BRR_BR4                      LPGPIO_BRR_BR4_Msk
#define LPGPIO_BRR_BR5_Pos                  (5U)
#define LPGPIO_BRR_BR5_Msk                  (0x1UL << LPGPIO_BRR_BR5_Pos)           /*!< 0x00000020 */
#define LPGPIO_BRR_BR5                      LPGPIO_BRR_BR5_Msk
#define LPGPIO_BRR_BR6_Pos                  (6U)
#define LPGPIO_BRR_BR6_Msk                  (0x1UL << LPGPIO_BRR_BR6_Pos)           /*!< 0x00000040 */
#define LPGPIO_BRR_BR6                      LPGPIO_BRR_BR6_Msk
#define LPGPIO_BRR_BR7_Pos                  (7U)
#define LPGPIO_BRR_BR7_Msk                  (0x1UL << LPGPIO_BRR_BR7_Pos)           /*!< 0x00000080 */
#define LPGPIO_BRR_BR7                      LPGPIO_BRR_BR7_Msk
#define LPGPIO_BRR_BR8_Pos                  (8U)
#define LPGPIO_BRR_BR8_Msk                  (0x1UL << LPGPIO_BRR_BR8_Pos)           /*!< 0x00000100 */
#define LPGPIO_BRR_BR8                      LPGPIO_BRR_BR8_Msk
#define LPGPIO_BRR_BR9_Pos                  (9U)
#define LPGPIO_BRR_BR9_Msk                  (0x1UL << LPGPIO_BRR_BR9_Pos)           /*!< 0x00000200 */
#define LPGPIO_BRR_BR9                      LPGPIO_BRR_BR9_Msk
#define LPGPIO_BRR_BR10_Pos                 (10U)
#define LPGPIO_BRR_BR10_Msk                 (0x1UL << LPGPIO_BRR_BR10_Pos)          /*!< 0x00000400 */
#define LPGPIO_BRR_BR10                     LPGPIO_BRR_BR10_Msk
#define LPGPIO_BRR_BR11_Pos                 (11U)
#define LPGPIO_BRR_BR11_Msk                 (0x1UL << LPGPIO_BRR_BR11_Pos)          /*!< 0x00000800 */
#define LPGPIO_BRR_BR11                     LPGPIO_BRR_BR11_Msk
#define LPGPIO_BRR_BR12_Pos                 (12U)
#define LPGPIO_BRR_BR12_Msk                 (0x1UL << LPGPIO_BRR_BR12_Pos)          /*!< 0x00001000 */
#define LPGPIO_BRR_BR12                     LPGPIO_BRR_BR12_Msk
#define LPGPIO_BRR_BR13_Pos                 (13U)
#define LPGPIO_BRR_BR13_Msk                 (0x1UL << LPGPIO_BRR_BR13_Pos)          /*!< 0x00002000 */
#define LPGPIO_BRR_BR13                     LPGPIO_BRR_BR13_Msk
#define LPGPIO_BRR_BR14_Pos                 (14U)
#define LPGPIO_BRR_BR14_Msk                 (0x1UL << LPGPIO_BRR_BR14_Pos)          /*!< 0x00004000 */
#define LPGPIO_BRR_BR14                     LPGPIO_BRR_BR14_Msk
#define LPGPIO_BRR_BR15_Pos                 (15U)
#define LPGPIO_BRR_BR15_Msk                 (0x1UL << LPGPIO_BRR_BR15_Pos)          /*!< 0x00008000 */
#define LPGPIO_BRR_BR15                     LPGPIO_BRR_BR15_Msk

/******************************************************************************/
/*                                                                            */
/*                      LCD-TFT Display Controller (LTDC)                     */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for LTDC_SSCR register  *****************/

#define LTDC_SSCR_VSH_Pos            (0U)
#define LTDC_SSCR_VSH_Msk            (0x7FFUL << LTDC_SSCR_VSH_Pos)            /*!< 0x000007FF */
#define LTDC_SSCR_VSH                LTDC_SSCR_VSH_Msk                         /*!< Vertical Synchronization Height  */
#define LTDC_SSCR_HSW_Pos            (16U)
#define LTDC_SSCR_HSW_Msk            (0xFFFUL << LTDC_SSCR_HSW_Pos)            /*!< 0x0FFF0000 */
#define LTDC_SSCR_HSW                LTDC_SSCR_HSW_Msk                         /*!< Horizontal Synchronization Width */

/********************  Bit definition for LTDC_BPCR register  *****************/

#define LTDC_BPCR_AVBP_Pos           (0U)
#define LTDC_BPCR_AVBP_Msk           (0x7FFUL << LTDC_BPCR_AVBP_Pos)           /*!< 0x000007FF */
#define LTDC_BPCR_AVBP               LTDC_BPCR_AVBP_Msk                        /*!< Accumulated Vertical Back Porch   */
#define LTDC_BPCR_AHBP_Pos           (16U)
#define LTDC_BPCR_AHBP_Msk           (0xFFFUL << LTDC_BPCR_AHBP_Pos)           /*!< 0x0FFF0000 */
#define LTDC_BPCR_AHBP               LTDC_BPCR_AHBP_Msk                        /*!< Accumulated Horizontal Back Porch */

/********************  Bit definition for LTDC_AWCR register  *****************/

#define LTDC_AWCR_AAH_Pos            (0U)
#define LTDC_AWCR_AAH_Msk            (0x7FFUL << LTDC_AWCR_AAH_Pos)            /*!< 0x000007FF */
#define LTDC_AWCR_AAH                LTDC_AWCR_AAH_Msk                         /*!< Accumulated Active height */
#define LTDC_AWCR_AAW_Pos            (16U)
#define LTDC_AWCR_AAW_Msk            (0xFFFUL << LTDC_AWCR_AAW_Pos)            /*!< 0x0FFF0000 */
#define LTDC_AWCR_AAW                LTDC_AWCR_AAW_Msk                         /*!< Accumulated Active Width */

/********************  Bit definition for LTDC_TWCR register  *****************/

#define LTDC_TWCR_TOTALH_Pos         (0U)
#define LTDC_TWCR_TOTALH_Msk         (0x7FFUL << LTDC_TWCR_TOTALH_Pos)         /*!< 0x000007FF */
#define LTDC_TWCR_TOTALH             LTDC_TWCR_TOTALH_Msk                      /*!< Total Height */
#define LTDC_TWCR_TOTALW_Pos         (16U)
#define LTDC_TWCR_TOTALW_Msk         (0xFFFUL << LTDC_TWCR_TOTALW_Pos)         /*!< 0x0FFF0000 */
#define LTDC_TWCR_TOTALW             LTDC_TWCR_TOTALW_Msk                      /*!< Total Width */

/********************  Bit definition for LTDC_GCR register  ******************/

#define LTDC_GCR_LTDCEN_Pos          (0U)
#define LTDC_GCR_LTDCEN_Msk          (0x1UL << LTDC_GCR_LTDCEN_Pos)            /*!< 0x00000001 */
#define LTDC_GCR_LTDCEN              LTDC_GCR_LTDCEN_Msk                       /*!< LCD-TFT controller enable bit       */
#define LTDC_GCR_DBW_Pos             (4U)
#define LTDC_GCR_DBW_Msk             (0x7UL << LTDC_GCR_DBW_Pos)               /*!< 0x00000070 */
#define LTDC_GCR_DBW                 LTDC_GCR_DBW_Msk                          /*!< Dither Blue Width                   */
#define LTDC_GCR_DGW_Pos             (8U)
#define LTDC_GCR_DGW_Msk             (0x7UL << LTDC_GCR_DGW_Pos)               /*!< 0x00000700 */
#define LTDC_GCR_DGW                 LTDC_GCR_DGW_Msk                          /*!< Dither Green Width                  */
#define LTDC_GCR_DRW_Pos             (12U)
#define LTDC_GCR_DRW_Msk             (0x7UL << LTDC_GCR_DRW_Pos)               /*!< 0x00007000 */
#define LTDC_GCR_DRW                 LTDC_GCR_DRW_Msk                          /*!< Dither Red Width                    */
#define LTDC_GCR_DEN_Pos             (16U)
#define LTDC_GCR_DEN_Msk             (0x1UL << LTDC_GCR_DEN_Pos)               /*!< 0x00010000 */
#define LTDC_GCR_DEN                 LTDC_GCR_DEN_Msk                          /*!< Dither Enable                       */
#define LTDC_GCR_PCPOL_Pos           (28U)
#define LTDC_GCR_PCPOL_Msk           (0x1UL << LTDC_GCR_PCPOL_Pos)             /*!< 0x10000000 */
#define LTDC_GCR_PCPOL               LTDC_GCR_PCPOL_Msk                        /*!< Pixel Clock Polarity                */
#define LTDC_GCR_DEPOL_Pos           (29U)
#define LTDC_GCR_DEPOL_Msk           (0x1UL << LTDC_GCR_DEPOL_Pos)             /*!< 0x20000000 */
#define LTDC_GCR_DEPOL               LTDC_GCR_DEPOL_Msk                        /*!< Data Enable Polarity                */
#define LTDC_GCR_VSPOL_Pos           (30U)
#define LTDC_GCR_VSPOL_Msk           (0x1UL << LTDC_GCR_VSPOL_Pos)             /*!< 0x40000000 */
#define LTDC_GCR_VSPOL               LTDC_GCR_VSPOL_Msk                        /*!< Vertical Synchronization Polarity   */
#define LTDC_GCR_HSPOL_Pos           (31U)
#define LTDC_GCR_HSPOL_Msk           (0x1UL << LTDC_GCR_HSPOL_Pos)             /*!< 0x80000000 */
#define LTDC_GCR_HSPOL               LTDC_GCR_HSPOL_Msk                        /*!< Horizontal Synchronization Polarity */

/********************  Bit definition for LTDC_SRCR register  *****************/

#define LTDC_SRCR_IMR_Pos            (0U)
#define LTDC_SRCR_IMR_Msk            (0x1UL << LTDC_SRCR_IMR_Pos)              /*!< 0x00000001 */
#define LTDC_SRCR_IMR                LTDC_SRCR_IMR_Msk                         /*!< Immediate Reload         */
#define LTDC_SRCR_VBR_Pos            (1U)
#define LTDC_SRCR_VBR_Msk            (0x1UL << LTDC_SRCR_VBR_Pos)              /*!< 0x00000002 */
#define LTDC_SRCR_VBR                LTDC_SRCR_VBR_Msk                         /*!< Vertical Blanking Reload */

/********************  Bit definition for LTDC_BCCR register  *****************/

#define LTDC_BCCR_BCBLUE_Pos         (0U)
#define LTDC_BCCR_BCBLUE_Msk         (0xFFUL << LTDC_BCCR_BCBLUE_Pos)          /*!< 0x000000FF */
#define LTDC_BCCR_BCBLUE             LTDC_BCCR_BCBLUE_Msk                      /*!< Background Blue value  */
#define LTDC_BCCR_BCGREEN_Pos        (8U)
#define LTDC_BCCR_BCGREEN_Msk        (0xFFUL << LTDC_BCCR_BCGREEN_Pos)         /*!< 0x0000FF00 */
#define LTDC_BCCR_BCGREEN            LTDC_BCCR_BCGREEN_Msk                     /*!< Background Green value */
#define LTDC_BCCR_BCRED_Pos          (16U)
#define LTDC_BCCR_BCRED_Msk          (0xFFUL << LTDC_BCCR_BCRED_Pos)           /*!< 0x00FF0000 */
#define LTDC_BCCR_BCRED              LTDC_BCCR_BCRED_Msk                       /*!< Background Red value   */

/********************  Bit definition for LTDC_IER register  ******************/

#define LTDC_IER_LIE_Pos             (0U)
#define LTDC_IER_LIE_Msk             (0x1UL << LTDC_IER_LIE_Pos)               /*!< 0x00000001 */
#define LTDC_IER_LIE                 LTDC_IER_LIE_Msk                          /*!< Line Interrupt Enable            */
#define LTDC_IER_FUIE_Pos            (1U)
#define LTDC_IER_FUIE_Msk            (0x1UL << LTDC_IER_FUIE_Pos)              /*!< 0x00000002 */
#define LTDC_IER_FUIE                LTDC_IER_FUIE_Msk                         /*!< FIFO Underrun Interrupt Enable   */
#define LTDC_IER_TERRIE_Pos          (2U)
#define LTDC_IER_TERRIE_Msk          (0x1UL << LTDC_IER_TERRIE_Pos)            /*!< 0x00000004 */
#define LTDC_IER_TERRIE              LTDC_IER_TERRIE_Msk                       /*!< Transfer Error Interrupt Enable  */
#define LTDC_IER_RRIE_Pos            (3U)
#define LTDC_IER_RRIE_Msk            (0x1UL << LTDC_IER_RRIE_Pos)              /*!< 0x00000008 */
#define LTDC_IER_RRIE                LTDC_IER_RRIE_Msk                         /*!< Register Reload interrupt enable */

/********************  Bit definition for LTDC_ISR register  ******************/

#define LTDC_ISR_LIF_Pos             (0U)
#define LTDC_ISR_LIF_Msk             (0x1UL << LTDC_ISR_LIF_Pos)               /*!< 0x00000001 */
#define LTDC_ISR_LIF                 LTDC_ISR_LIF_Msk                          /*!< Line Interrupt Flag */
#define LTDC_ISR_FUIF_Pos            (1U)
#define LTDC_ISR_FUIF_Msk            (0x1UL << LTDC_ISR_FUIF_Pos)              /*!< 0x00000002 */
#define LTDC_ISR_FUIF                LTDC_ISR_FUIF_Msk                         /*!< FIFO Underrun Interrupt Flag */
#define LTDC_ISR_TERRIF_Pos          (2U)
#define LTDC_ISR_TERRIF_Msk          (0x1UL << LTDC_ISR_TERRIF_Pos)            /*!< 0x00000004 */
#define LTDC_ISR_TERRIF              LTDC_ISR_TERRIF_Msk                       /*!< Transfer Error Interrupt Flag */
#define LTDC_ISR_RRIF_Pos            (3U)
#define LTDC_ISR_RRIF_Msk            (0x1UL << LTDC_ISR_RRIF_Pos)              /*!< 0x00000008 */
#define LTDC_ISR_RRIF                LTDC_ISR_RRIF_Msk                         /*!< Register Reload interrupt Flag */

/********************  Bit definition for LTDC_ICR register  ******************/

#define LTDC_ICR_CLIF_Pos            (0U)
#define LTDC_ICR_CLIF_Msk            (0x1UL << LTDC_ICR_CLIF_Pos)              /*!< 0x00000001 */
#define LTDC_ICR_CLIF                LTDC_ICR_CLIF_Msk                         /*!< Clears the Line Interrupt Flag */
#define LTDC_ICR_CFUIF_Pos           (1U)
#define LTDC_ICR_CFUIF_Msk           (0x1UL << LTDC_ICR_CFUIF_Pos)             /*!< 0x00000002 */
#define LTDC_ICR_CFUIF               LTDC_ICR_CFUIF_Msk                        /*!< Clears the FIFO Underrun Interrupt Flag */
#define LTDC_ICR_CTERRIF_Pos         (2U)
#define LTDC_ICR_CTERRIF_Msk         (0x1UL << LTDC_ICR_CTERRIF_Pos)           /*!< 0x00000004 */
#define LTDC_ICR_CTERRIF             LTDC_ICR_CTERRIF_Msk                      /*!< Clears the Transfer Error Interrupt Flag */
#define LTDC_ICR_CRRIF_Pos           (3U)
#define LTDC_ICR_CRRIF_Msk           (0x1UL << LTDC_ICR_CRRIF_Pos)             /*!< 0x00000008 */
#define LTDC_ICR_CRRIF               LTDC_ICR_CRRIF_Msk                        /*!< Clears Register Reload interrupt Flag */

/********************  Bit definition for LTDC_LIPCR register  ****************/

#define LTDC_LIPCR_LIPOS_Pos         (0U)
#define LTDC_LIPCR_LIPOS_Msk         (0x7FFUL << LTDC_LIPCR_LIPOS_Pos)         /*!< 0x000007FF */
#define LTDC_LIPCR_LIPOS             LTDC_LIPCR_LIPOS_Msk                      /*!< Line Interrupt Position */

/********************  Bit definition for LTDC_CPSR register  *****************/

#define LTDC_CPSR_CYPOS_Pos          (0U)
#define LTDC_CPSR_CYPOS_Msk          (0xFFFFUL << LTDC_CPSR_CYPOS_Pos)         /*!< 0x0000FFFF */
#define LTDC_CPSR_CYPOS              LTDC_CPSR_CYPOS_Msk                       /*!< Current Y Position */
#define LTDC_CPSR_CXPOS_Pos          (16U)
#define LTDC_CPSR_CXPOS_Msk          (0xFFFFUL << LTDC_CPSR_CXPOS_Pos)         /*!< 0xFFFF0000 */
#define LTDC_CPSR_CXPOS              LTDC_CPSR_CXPOS_Msk                       /*!< Current X Position */

/********************  Bit definition for LTDC_CDSR register  *****************/

#define LTDC_CDSR_VDES_Pos           (0U)
#define LTDC_CDSR_VDES_Msk           (0x1UL << LTDC_CDSR_VDES_Pos)             /*!< 0x00000001 */
#define LTDC_CDSR_VDES               LTDC_CDSR_VDES_Msk                        /*!< Vertical Data Enable Status       */
#define LTDC_CDSR_HDES_Pos           (1U)
#define LTDC_CDSR_HDES_Msk           (0x1UL << LTDC_CDSR_HDES_Pos)             /*!< 0x00000002 */
#define LTDC_CDSR_HDES               LTDC_CDSR_HDES_Msk                        /*!< Horizontal Data Enable Status     */
#define LTDC_CDSR_VSYNCS_Pos         (2U)
#define LTDC_CDSR_VSYNCS_Msk         (0x1UL << LTDC_CDSR_VSYNCS_Pos)           /*!< 0x00000004 */
#define LTDC_CDSR_VSYNCS             LTDC_CDSR_VSYNCS_Msk                      /*!< Vertical Synchronization Status   */
#define LTDC_CDSR_HSYNCS_Pos         (3U)
#define LTDC_CDSR_HSYNCS_Msk         (0x1UL << LTDC_CDSR_HSYNCS_Pos)           /*!< 0x00000008 */
#define LTDC_CDSR_HSYNCS             LTDC_CDSR_HSYNCS_Msk                      /*!< Horizontal Synchronization Status */

/********************  Bit definition for LTDC_LxCR register  *****************/

#define LTDC_LxCR_LEN_Pos            (0U)
#define LTDC_LxCR_LEN_Msk            (0x1UL << LTDC_LxCR_LEN_Pos)              /*!< 0x00000001 */
#define LTDC_LxCR_LEN                LTDC_LxCR_LEN_Msk                         /*!< Layer Enable              */
#define LTDC_LxCR_COLKEN_Pos         (1U)
#define LTDC_LxCR_COLKEN_Msk         (0x1UL << LTDC_LxCR_COLKEN_Pos)           /*!< 0x00000002 */
#define LTDC_LxCR_COLKEN             LTDC_LxCR_COLKEN_Msk                      /*!< Color Keying Enable       */
#define LTDC_LxCR_CLUTEN_Pos         (4U)
#define LTDC_LxCR_CLUTEN_Msk         (0x1UL << LTDC_LxCR_CLUTEN_Pos)           /*!< 0x00000010 */
#define LTDC_LxCR_CLUTEN             LTDC_LxCR_CLUTEN_Msk                      /*!< Color Lockup Table Enable */

/********************  Bit definition for LTDC_LxWHPCR register  **************/

#define LTDC_LxWHPCR_WHSTPOS_Pos     (0U)
#define LTDC_LxWHPCR_WHSTPOS_Msk     (0xFFFUL << LTDC_LxWHPCR_WHSTPOS_Pos)     /*!< 0x00000FFF */
#define LTDC_LxWHPCR_WHSTPOS         LTDC_LxWHPCR_WHSTPOS_Msk                  /*!< Window Horizontal Start Position */
#define LTDC_LxWHPCR_WHSPPOS_Pos     (16U)
#define LTDC_LxWHPCR_WHSPPOS_Msk     (0xFFFUL << LTDC_LxWHPCR_WHSPPOS_Pos)     /*!< 0x0FFF0000 */
#define LTDC_LxWHPCR_WHSPPOS         LTDC_LxWHPCR_WHSPPOS_Msk                  /*!< Window Horizontal Stop Position  */

/********************  Bit definition for LTDC_LxWVPCR register  **************/

#define LTDC_LxWVPCR_WVSTPOS_Pos     (0U)
#define LTDC_LxWVPCR_WVSTPOS_Msk     (0xFFFUL << LTDC_LxWVPCR_WVSTPOS_Pos)     /*!< 0x00000FFF */
#define LTDC_LxWVPCR_WVSTPOS         LTDC_LxWVPCR_WVSTPOS_Msk                  /*!< Window Vertical Start Position */
#define LTDC_LxWVPCR_WVSPPOS_Pos     (16U)
#define LTDC_LxWVPCR_WVSPPOS_Msk     (0xFFFUL << LTDC_LxWVPCR_WVSPPOS_Pos)     /*!< 0x0FFF0000 */
#define LTDC_LxWVPCR_WVSPPOS         LTDC_LxWVPCR_WVSPPOS_Msk                  /*!< Window Vertical Stop Position  */

/********************  Bit definition for LTDC_LxCKCR register  ***************/

#define LTDC_LxCKCR_CKBLUE_Pos       (0U)
#define LTDC_LxCKCR_CKBLUE_Msk       (0xFFUL << LTDC_LxCKCR_CKBLUE_Pos)        /*!< 0x000000FF */
#define LTDC_LxCKCR_CKBLUE           LTDC_LxCKCR_CKBLUE_Msk                    /*!< Color Key Blue value  */
#define LTDC_LxCKCR_CKGREEN_Pos      (8U)
#define LTDC_LxCKCR_CKGREEN_Msk      (0xFFUL << LTDC_LxCKCR_CKGREEN_Pos)       /*!< 0x0000FF00 */
#define LTDC_LxCKCR_CKGREEN          LTDC_LxCKCR_CKGREEN_Msk                   /*!< Color Key Green value */
#define LTDC_LxCKCR_CKRED_Pos        (16U)
#define LTDC_LxCKCR_CKRED_Msk        (0xFFUL << LTDC_LxCKCR_CKRED_Pos)         /*!< 0x00FF0000 */
#define LTDC_LxCKCR_CKRED            LTDC_LxCKCR_CKRED_Msk                     /*!< Color Key Red value   */

/********************  Bit definition for LTDC_LxPFCR register  ***************/

#define LTDC_LxPFCR_PF_Pos           (0U)
#define LTDC_LxPFCR_PF_Msk           (0x7UL << LTDC_LxPFCR_PF_Pos)             /*!< 0x00000007 */
#define LTDC_LxPFCR_PF               LTDC_LxPFCR_PF_Msk                        /*!< Pixel Format */

/********************  Bit definition for LTDC_LxCACR register  ***************/

#define LTDC_LxCACR_CONSTA_Pos       (0U)
#define LTDC_LxCACR_CONSTA_Msk       (0xFFUL << LTDC_LxCACR_CONSTA_Pos)        /*!< 0x000000FF */
#define LTDC_LxCACR_CONSTA           LTDC_LxCACR_CONSTA_Msk                    /*!< Constant Alpha */

/********************  Bit definition for LTDC_LxDCCR register  ***************/

#define LTDC_LxDCCR_DCBLUE_Pos       (0U)
#define LTDC_LxDCCR_DCBLUE_Msk       (0xFFUL << LTDC_LxDCCR_DCBLUE_Pos)        /*!< 0x000000FF */
#define LTDC_LxDCCR_DCBLUE           LTDC_LxDCCR_DCBLUE_Msk                    /*!< Default Color Blue  */
#define LTDC_LxDCCR_DCGREEN_Pos      (8U)
#define LTDC_LxDCCR_DCGREEN_Msk      (0xFFUL << LTDC_LxDCCR_DCGREEN_Pos)       /*!< 0x0000FF00 */
#define LTDC_LxDCCR_DCGREEN          LTDC_LxDCCR_DCGREEN_Msk                   /*!< Default Color Green */
#define LTDC_LxDCCR_DCRED_Pos        (16U)
#define LTDC_LxDCCR_DCRED_Msk        (0xFFUL << LTDC_LxDCCR_DCRED_Pos)         /*!< 0x00FF0000 */
#define LTDC_LxDCCR_DCRED            LTDC_LxDCCR_DCRED_Msk                     /*!< Default Color Red   */
#define LTDC_LxDCCR_DCALPHA_Pos      (24U)
#define LTDC_LxDCCR_DCALPHA_Msk      (0xFFUL << LTDC_LxDCCR_DCALPHA_Pos)       /*!< 0xFF000000 */
#define LTDC_LxDCCR_DCALPHA          LTDC_LxDCCR_DCALPHA_Msk                   /*!< Default Color Alpha */

/********************  Bit definition for LTDC_LxBFCR register  ***************/

#define LTDC_LxBFCR_BF2_Pos          (0U)
#define LTDC_LxBFCR_BF2_Msk          (0x7UL << LTDC_LxBFCR_BF2_Pos)            /*!< 0x00000007 */
#define LTDC_LxBFCR_BF2              LTDC_LxBFCR_BF2_Msk                       /*!< Blending Factor 2 */
#define LTDC_LxBFCR_BF1_Pos          (8U)
#define LTDC_LxBFCR_BF1_Msk          (0x7UL << LTDC_LxBFCR_BF1_Pos)            /*!< 0x00000700 */
#define LTDC_LxBFCR_BF1              LTDC_LxBFCR_BF1_Msk                       /*!< Blending Factor 1 */

/********************  Bit definition for LTDC_LxCFBAR register  **************/

#define LTDC_LxCFBAR_CFBADD_Pos      (0U)
#define LTDC_LxCFBAR_CFBADD_Msk      (0xFFFFFFFFUL << LTDC_LxCFBAR_CFBADD_Pos) /*!< 0xFFFFFFFF */
#define LTDC_LxCFBAR_CFBADD          LTDC_LxCFBAR_CFBADD_Msk                   /*!< Color Frame Buffer Start Address */

/********************  Bit definition for LTDC_LxCFBLR register  **************/

#define LTDC_LxCFBLR_CFBLL_Pos       (0U)
#define LTDC_LxCFBLR_CFBLL_Msk       (0x1FFFUL << LTDC_LxCFBLR_CFBLL_Pos)      /*!< 0x00001FFF */
#define LTDC_LxCFBLR_CFBLL           LTDC_LxCFBLR_CFBLL_Msk                    /*!< Color Frame Buffer Line Length    */
#define LTDC_LxCFBLR_CFBP_Pos        (16U)
#define LTDC_LxCFBLR_CFBP_Msk        (0x1FFFUL << LTDC_LxCFBLR_CFBP_Pos)       /*!< 0x1FFF0000 */
#define LTDC_LxCFBLR_CFBP            LTDC_LxCFBLR_CFBP_Msk                     /*!< Color Frame Buffer Pitch in bytes */

/********************  Bit definition for LTDC_LxCFBLNR register  *************/

#define LTDC_LxCFBLNR_CFBLNBR_Pos    (0U)
#define LTDC_LxCFBLNR_CFBLNBR_Msk    (0x7FFUL << LTDC_LxCFBLNR_CFBLNBR_Pos)    /*!< 0x000007FF */
#define LTDC_LxCFBLNR_CFBLNBR        LTDC_LxCFBLNR_CFBLNBR_Msk                 /*!< Frame Buffer Line Number */

/********************  Bit definition for LTDC_LxCLUTWR register  *************/

#define LTDC_LxCLUTWR_BLUE_Pos       (0U)
#define LTDC_LxCLUTWR_BLUE_Msk       (0xFFUL << LTDC_LxCLUTWR_BLUE_Pos)        /*!< 0x000000FF */
#define LTDC_LxCLUTWR_BLUE           LTDC_LxCLUTWR_BLUE_Msk                    /*!< Blue value   */
#define LTDC_LxCLUTWR_GREEN_Pos      (8U)
#define LTDC_LxCLUTWR_GREEN_Msk      (0xFFUL << LTDC_LxCLUTWR_GREEN_Pos)       /*!< 0x0000FF00 */
#define LTDC_LxCLUTWR_GREEN          LTDC_LxCLUTWR_GREEN_Msk                   /*!< Green value  */
#define LTDC_LxCLUTWR_RED_Pos        (16U)
#define LTDC_LxCLUTWR_RED_Msk        (0xFFUL << LTDC_LxCLUTWR_RED_Pos)         /*!< 0x00FF0000 */
#define LTDC_LxCLUTWR_RED            LTDC_LxCLUTWR_RED_Msk                     /*!< Red value    */
#define LTDC_LxCLUTWR_CLUTADD_Pos    (24U)
#define LTDC_LxCLUTWR_CLUTADD_Msk    (0xFFUL << LTDC_LxCLUTWR_CLUTADD_Pos)     /*!< 0xFF000000 */
#define LTDC_LxCLUTWR_CLUTADD        LTDC_LxCLUTWR_CLUTADD_Msk                 /*!< CLUT address */

/******************************************************************************/
/*                                                                            */
/*                                 ICACHE                                     */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for ICACHE_CR register  *******************/
#define ICACHE_CR_EN_Pos                    (0U)
#define ICACHE_CR_EN_Msk                    (0x1UL << ICACHE_CR_EN_Pos)             /*!< 0x00000001 */
#define ICACHE_CR_EN                        ICACHE_CR_EN_Msk                        /*!< Enable */
#define ICACHE_CR_CACHEINV_Pos              (1U)
#define ICACHE_CR_CACHEINV_Msk              (0x1UL << ICACHE_CR_CACHEINV_Pos)       /*!< 0x00000002 */
#define ICACHE_CR_CACHEINV                  ICACHE_CR_CACHEINV_Msk                  /*!< Cache invalidation */
#define ICACHE_CR_WAYSEL_Pos                (2U)
#define ICACHE_CR_WAYSEL_Msk                (0x1UL << ICACHE_CR_WAYSEL_Pos)         /*!< 0x00000004 */
#define ICACHE_CR_WAYSEL                    ICACHE_CR_WAYSEL_Msk                    /*!< Ways selection */
#define ICACHE_CR_HITMEN_Pos                (16U)
#define ICACHE_CR_HITMEN_Msk                (0x1UL << ICACHE_CR_HITMEN_Pos)         /*!< 0x00010000 */
#define ICACHE_CR_HITMEN                    ICACHE_CR_HITMEN_Msk                    /*!< Hit monitor enable */
#define ICACHE_CR_MISSMEN_Pos               (17U)
#define ICACHE_CR_MISSMEN_Msk               (0x1UL << ICACHE_CR_MISSMEN_Pos)        /*!< 0x00020000 */
#define ICACHE_CR_MISSMEN                   ICACHE_CR_MISSMEN_Msk                   /*!< Miss monitor enable */
#define ICACHE_CR_HITMRST_Pos               (18U)
#define ICACHE_CR_HITMRST_Msk               (0x1UL << ICACHE_CR_HITMRST_Pos)        /*!< 0x00040000 */
#define ICACHE_CR_HITMRST                   ICACHE_CR_HITMRST_Msk                   /*!< Hit monitor reset */
#define ICACHE_CR_MISSMRST_Pos              (19U)
#define ICACHE_CR_MISSMRST_Msk              (0x1UL << ICACHE_CR_MISSMRST_Pos)       /*!< 0x00080000 */
#define ICACHE_CR_MISSMRST                  ICACHE_CR_MISSMRST_Msk                  /*!< Miss monitor reset */

/******************  Bit definition for ICACHE_SR register  *******************/
#define ICACHE_SR_BUSYF_Pos                 (0U)
#define ICACHE_SR_BUSYF_Msk                 (0x1UL << ICACHE_SR_BUSYF_Pos)          /*!< 0x00000001 */
#define ICACHE_SR_BUSYF                     ICACHE_SR_BUSYF_Msk                     /*!< Busy flag */
#define ICACHE_SR_BSYENDF_Pos               (1U)
#define ICACHE_SR_BSYENDF_Msk               (0x1UL << ICACHE_SR_BSYENDF_Pos)        /*!< 0x00000002 */
#define ICACHE_SR_BSYENDF                   ICACHE_SR_BSYENDF_Msk                   /*!< Busy end flag */
#define ICACHE_SR_ERRF_Pos                  (2U)
#define ICACHE_SR_ERRF_Msk                  (0x1UL << ICACHE_SR_ERRF_Pos)           /*!< 0x00000004 */
#define ICACHE_SR_ERRF                      ICACHE_SR_ERRF_Msk                      /*!< Cache error flag */

/******************  Bit definition for ICACHE_IER register  ******************/
#define ICACHE_IER_BSYENDIE_Pos             (1U)
#define ICACHE_IER_BSYENDIE_Msk             (0x1UL << ICACHE_IER_BSYENDIE_Pos)      /*!< 0x00000002 */
#define ICACHE_IER_BSYENDIE                 ICACHE_IER_BSYENDIE_Msk                 /*!< Busy end interrupt enable */
#define ICACHE_IER_ERRIE_Pos                (2U)
#define ICACHE_IER_ERRIE_Msk                (0x1UL << ICACHE_IER_ERRIE_Pos)         /*!< 0x00000004 */
#define ICACHE_IER_ERRIE                    ICACHE_IER_ERRIE_Msk                    /*!< Cache error interrupt enable */

/******************  Bit definition for ICACHE_FCR register  ******************/
#define ICACHE_FCR_CBSYENDF_Pos             (1U)
#define ICACHE_FCR_CBSYENDF_Msk             (0x1UL << ICACHE_FCR_CBSYENDF_Pos)      /*!< 0x00000002 */
#define ICACHE_FCR_CBSYENDF                 ICACHE_FCR_CBSYENDF_Msk                 /*!< Busy end flag clear */
#define ICACHE_FCR_CERRF_Pos                (2U)
#define ICACHE_FCR_CERRF_Msk                (0x1UL << ICACHE_FCR_CERRF_Pos)         /*!< 0x00000004 */
#define ICACHE_FCR_CERRF                    ICACHE_FCR_CERRF_Msk                    /*!< Cache error flag clear */

/******************  Bit definition for ICACHE_HMONR register  ****************/
#define ICACHE_HMONR_HITMON_Pos             (0U)
#define ICACHE_HMONR_HITMON_Msk             (0xFFFFFFFFUL << ICACHE_HMONR_HITMON_Pos) /*!< 0xFFFFFFFF */
#define ICACHE_HMONR_HITMON                 ICACHE_HMONR_HITMON_Msk                 /*!< Cache hit monitor register */

/******************  Bit definition for ICACHE_MMONR register  ****************/
#define ICACHE_MMONR_MISSMON_Pos            (0U)
#define ICACHE_MMONR_MISSMON_Msk            (0xFFFFUL << ICACHE_MMONR_MISSMON_Pos)  /*!< 0x0000FFFF */
#define ICACHE_MMONR_MISSMON                ICACHE_MMONR_MISSMON_Msk                /*!< Cache miss monitor register */

/******************  Bit definition for ICACHE_CRRx register  *****************/
#define ICACHE_CRRx_BASEADDR_Pos            (0U)
#define ICACHE_CRRx_BASEADDR_Msk            (0xFFUL << ICACHE_CRRx_BASEADDR_Pos)    /*!< 0x000000FF */
#define ICACHE_CRRx_BASEADDR                ICACHE_CRRx_BASEADDR_Msk                /*!< Base address of region X to remap */
#define ICACHE_CRRx_RSIZE_Pos               (9U)
#define ICACHE_CRRx_RSIZE_Msk               (0x7UL << ICACHE_CRRx_RSIZE_Pos)        /*!< 0x00000E00 */
#define ICACHE_CRRx_RSIZE                   ICACHE_CRRx_RSIZE_Msk                   /*!< Region X size */
#define ICACHE_CRRx_RSIZE_0                 (0x1UL << ICACHE_CRRx_RSIZE_Pos)        /*!< 0x00000200 */
#define ICACHE_CRRx_RSIZE_1                 (0x2UL << ICACHE_CRRx_RSIZE_Pos)        /*!< 0x00000400 */
#define ICACHE_CRRx_RSIZE_2                 (0x4UL << ICACHE_CRRx_RSIZE_Pos)        /*!< 0x00000800 */
#define ICACHE_CRRx_REN_Pos                 (15U)
#define ICACHE_CRRx_REN_Msk                 (0x1UL << ICACHE_CRRx_REN_Pos)          /*!< 0x00008000 */
#define ICACHE_CRRx_REN                     ICACHE_CRRx_REN_Msk                     /*!< Region X enable */
#define ICACHE_CRRx_REMAPADDR_Pos           (16U)
#define ICACHE_CRRx_REMAPADDR_Msk           (0x7FFUL << ICACHE_CRRx_REMAPADDR_Pos)  /*!< 0x07FF0000 */
#define ICACHE_CRRx_REMAPADDR               ICACHE_CRRx_REMAPADDR_Msk               /*!< Remap address of Region X to be remapped */
#define ICACHE_CRRx_MSTSEL_Pos              (28U)
#define ICACHE_CRRx_MSTSEL_Msk              (0x1UL << ICACHE_CRRx_MSTSEL_Pos)       /*!< 0x10000000 */
#define ICACHE_CRRx_MSTSEL                  ICACHE_CRRx_MSTSEL_Msk                  /*!< Region X AHB cache master selection */
#define ICACHE_CRRx_HBURST_Pos              (31U)
#define ICACHE_CRRx_HBURST_Msk              (0x1UL << ICACHE_CRRx_HBURST_Pos)       /*!< 0x80000000 */
#define ICACHE_CRRx_HBURST                  ICACHE_CRRx_HBURST_Msk                  /*!< Region X output burst type */

/******************************************************************************/
/*                                                                            */
/*                                 DCACHE                                     */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for DCACHE_CR register  *******************/
#define DCACHE_CR_EN_Pos                    (0U)
#define DCACHE_CR_EN_Msk                    (0x1UL << DCACHE_CR_EN_Pos)             /*!< 0x00000001 */
#define DCACHE_CR_EN                        DCACHE_CR_EN_Msk                        /*!< Enable */
#define DCACHE_CR_CACHEINV_Pos              (1U)
#define DCACHE_CR_CACHEINV_Msk              (0x1UL << DCACHE_CR_CACHEINV_Pos)       /*!< 0x00000002 */
#define DCACHE_CR_CACHEINV                  DCACHE_CR_CACHEINV_Msk                  /*!< Cache invalidation */
#define DCACHE_CR_CACHECMD_Pos              (8U)
#define DCACHE_CR_CACHECMD_Msk              (0x7UL << DCACHE_CR_CACHECMD_Pos)       /*!< 0x00000700 */
#define DCACHE_CR_CACHECMD                  DCACHE_CR_CACHECMD_Msk                  /*!< Cache command */
#define DCACHE_CR_CACHECMD_0                (0x1UL << DCACHE_CR_CACHECMD_Pos)       /*!< 0x00000100 */
#define DCACHE_CR_CACHECMD_1                (0x2UL << DCACHE_CR_CACHECMD_Pos)       /*!< 0x00000200 */
#define DCACHE_CR_CACHECMD_2                (0x4UL << DCACHE_CR_CACHECMD_Pos)       /*!< 0x00000400 */
#define DCACHE_CR_STARTCMD_Pos              (11U)
#define DCACHE_CR_STARTCMD_Msk              (0x1UL << DCACHE_CR_STARTCMD_Pos)       /*!< 0x00000800 */
#define DCACHE_CR_STARTCMD                  DCACHE_CR_STARTCMD_Msk                  /*!< Start command */
#define DCACHE_CR_RHITMEN_Pos               (16U)
#define DCACHE_CR_RHITMEN_Msk               (0x1UL << DCACHE_CR_RHITMEN_Pos)        /*!< 0x00010000 */
#define DCACHE_CR_RHITMEN                   DCACHE_CR_RHITMEN_Msk                   /*!< Read Hit monitor enable */
#define DCACHE_CR_RMISSMEN_Pos              (17U)
#define DCACHE_CR_RMISSMEN_Msk              (0x1UL << DCACHE_CR_RMISSMEN_Pos)       /*!< 0x00020000 */
#define DCACHE_CR_RMISSMEN                  DCACHE_CR_RMISSMEN_Msk                  /*!< Read Miss monitor enable */
#define DCACHE_CR_RHITMRST_Pos              (18U)
#define DCACHE_CR_RHITMRST_Msk              (0x1UL << DCACHE_CR_RHITMRST_Pos)       /*!< 0x00040000 */
#define DCACHE_CR_RHITMRST                  DCACHE_CR_RHITMRST_Msk                  /*!< Read Hit monitor reset */
#define DCACHE_CR_RMISSMRST_Pos             (19U)
#define DCACHE_CR_RMISSMRST_Msk             (0x1UL << DCACHE_CR_RMISSMRST_Pos)      /*!< 0x00080000 */
#define DCACHE_CR_RMISSMRST                 DCACHE_CR_RMISSMRST_Msk                 /*!< Read Miss monitor reset */
#define DCACHE_CR_WHITMEN_Pos               (20U)
#define DCACHE_CR_WHITMEN_Msk               (0x1UL << DCACHE_CR_WHITMEN_Pos)        /*!< 0x00100000 */
#define DCACHE_CR_WHITMEN                   DCACHE_CR_WHITMEN_Msk                   /*!< Write Hit monitor enable */
#define DCACHE_CR_WMISSMEN_Pos              (21U)
#define DCACHE_CR_WMISSMEN_Msk              (0x1UL << DCACHE_CR_WMISSMEN_Pos)       /*!< 0x00200000 */
#define DCACHE_CR_WMISSMEN                  DCACHE_CR_WMISSMEN_Msk                  /*!< Write Miss monitor enable */
#define DCACHE_CR_WHITMRST_Pos              (22U)
#define DCACHE_CR_WHITMRST_Msk              (0x1UL << DCACHE_CR_WHITMRST_Pos)       /*!< 0x00400000 */
#define DCACHE_CR_WHITMRST                  DCACHE_CR_WHITMRST_Msk                  /*!< Write Hit monitor reset */
#define DCACHE_CR_WMISSMRST_Pos             (23U)
#define DCACHE_CR_WMISSMRST_Msk             (0x1UL << DCACHE_CR_WMISSMRST_Pos)      /*!< 0x00800000 */
#define DCACHE_CR_WMISSMRST                 DCACHE_CR_WMISSMRST_Msk                 /*!< Write Miss monitor reset */
#define DCACHE_CR_HBURST_Pos                (31U)
#define DCACHE_CR_HBURST_Msk                (0x1UL << DCACHE_CR_HBURST_Pos)         /*!< 0x80000000 */
#define DCACHE_CR_HBURST                    DCACHE_CR_HBURST_Msk                    /*!< Read burst type */

/******************  Bit definition for DCACHE_SR register  *******************/
#define DCACHE_SR_BUSYF_Pos                 (0U)
#define DCACHE_SR_BUSYF_Msk                 (0x1UL << DCACHE_SR_BUSYF_Pos)          /*!< 0x00000001 */
#define DCACHE_SR_BUSYF                     DCACHE_SR_BUSYF_Msk                     /*!< Busy flag */
#define DCACHE_SR_BSYENDF_Pos               (1U)
#define DCACHE_SR_BSYENDF_Msk               (0x1UL << DCACHE_SR_BSYENDF_Pos)        /*!< 0x00000002 */
#define DCACHE_SR_BSYENDF                   DCACHE_SR_BSYENDF_Msk                   /*!< Busy end flag */
#define DCACHE_SR_ERRF_Pos                  (2U)
#define DCACHE_SR_ERRF_Msk                  (0x1UL << DCACHE_SR_ERRF_Pos)           /*!< 0x00000004 */
#define DCACHE_SR_ERRF                      DCACHE_SR_ERRF_Msk                      /*!< Cache error flag */
#define DCACHE_SR_BUSYCMDF_Pos              (3U)
#define DCACHE_SR_BUSYCMDF_Msk              (0x1UL << DCACHE_SR_BUSYCMDF_Pos)       /*!< 0x00000008 */
#define DCACHE_SR_BUSYCMDF                  DCACHE_SR_BUSYCMDF_Msk                  /*!< Busy command flag */
#define DCACHE_SR_CMDENDF_Pos               (4U)
#define DCACHE_SR_CMDENDF_Msk               (0x1UL << DCACHE_SR_CMDENDF_Pos)        /*!< 0x00000010 */
#define DCACHE_SR_CMDENDF                   DCACHE_SR_CMDENDF_Msk                   /*!< Command end flag */

/******************  Bit definition for DCACHE_IER register  ******************/
#define DCACHE_IER_BSYENDIE_Pos             (1U)
#define DCACHE_IER_BSYENDIE_Msk             (0x1UL << DCACHE_IER_BSYENDIE_Pos)      /*!< 0x00000002 */
#define DCACHE_IER_BSYENDIE                 DCACHE_IER_BSYENDIE_Msk                 /*!< Busy end interrupt enable */
#define DCACHE_IER_ERRIE_Pos                (2U)
#define DCACHE_IER_ERRIE_Msk                (0x1UL << DCACHE_IER_ERRIE_Pos)         /*!< 0x00000004 */
#define DCACHE_IER_ERRIE                    DCACHE_IER_ERRIE_Msk                    /*!< Cache error interrupt enable */
#define DCACHE_IER_CMDENDIE_Pos             (4U)
#define DCACHE_IER_CMDENDIE_Msk             (0x1UL << DCACHE_IER_CMDENDIE_Pos)      /*!< 0x00000010 */
#define DCACHE_IER_CMDENDIE                 DCACHE_IER_CMDENDIE_Msk                 /*!< Command end interrupt enable */

/******************  Bit definition for DCACHE_FCR register  ******************/
#define DCACHE_FCR_CBSYENDF_Pos             (1U)
#define DCACHE_FCR_CBSYENDF_Msk             (0x1UL << DCACHE_FCR_CBSYENDF_Pos)       /*!< 0x00000002 */
#define DCACHE_FCR_CBSYENDF                 DCACHE_FCR_CBSYENDF_Msk                  /*!< Busy end flag clear */
#define DCACHE_FCR_CERRF_Pos                (2U)
#define DCACHE_FCR_CERRF_Msk                (0x1UL << DCACHE_FCR_CERRF_Pos)          /*!< 0x00000004 */
#define DCACHE_FCR_CERRF                    DCACHE_FCR_CERRF_Msk                     /*!< Cache error flag clear */
#define DCACHE_FCR_CCMDENDF_Pos             (4U)
#define DCACHE_FCR_CCMDENDF_Msk             (0x1UL << DCACHE_FCR_CCMDENDF_Pos)       /*!< 0x00000010 */
#define DCACHE_FCR_CCMDENDF                 DCACHE_FCR_CCMDENDF_Msk                  /*!< Command end flag clear */

/******************  Bit definition for DCACHE_RHMONR register  ****************/
#define DCACHE_RHMONR_RHITMON_Pos           (0U)
#define DCACHE_RHMONR_RHITMON_Msk           (0xFFFFFFFFUL << DCACHE_RHMONR_RHITMON_Pos) /*!< 0xFFFFFFFF */
#define DCACHE_RHMONR_RHITMON               DCACHE_RHMONR_RHITMON_Msk               /*!< Cache Read hit monitor register */

/******************  Bit definition for DCACHE_RMMONR register  ****************/
#define DCACHE_RMMONR_RMISSMON_Pos          (0U)
#define DCACHE_RMMONR_RMISSMON_Msk          (0xFFFFUL << DCACHE_RMMONR_RMISSMON_Pos) /*!< 0x0000FFFF */
#define DCACHE_RMMONR_RMISSMON              DCACHE_RMMONR_RMISSMON_Msk              /*!< Cache Read miss monitor register */

/******************  Bit definition for DCACHE_WHMONR register  ****************/
#define DCACHE_WHMONR_WHITMON_Pos           (0U)
#define DCACHE_WHMONR_WHITMON_Msk           (0xFFFFFFFFUL << DCACHE_WHMONR_WHITMON_Pos) /*!< 0xFFFFFFFF */
#define DCACHE_WHMONR_WHITMON               DCACHE_WHMONR_WHITMON_Msk               /*!< Cache Read hit monitor register */

/******************  Bit definition for DCACHE_WMMONR register  ****************/
#define DCACHE_WMMONR_WMISSMON_Pos          (0U)
#define DCACHE_WMMONR_WMISSMON_Msk          (0xFFFFUL << DCACHE_WMMONR_WMISSMON_Pos) /*!< 0x0000FFFF */
#define DCACHE_WMMONR_WMISSMON              DCACHE_WMMONR_WMISSMON_Msk              /*!< Cache Read miss monitor register */

/******************  Bit definition for DCACHE_CMDRSADDRR register  ****************/
#define DCACHE_CMDRSADDRR_CMDSTARTADDR_Pos  (0U)
#define DCACHE_CMDRSADDRR_CMDSTARTADDR_Msk  (0xFFFFFFE0UL << DCACHE_CMDRSADDRR_CMDSTARTADDR_Pos) /*!< 0xFFFFFFE0 */
#define DCACHE_CMDRSADDRR_CMDSTARTADDR      DCACHE_CMDRSADDRR_CMDSTARTADDR_Msk      /*!< Command start address */

/******************  Bit definition for DCACHE_CMDREADDRR register  ****************/
#define DCACHE_CMDREADDRR_CMDENDADDR_Pos    (0U)
#define DCACHE_CMDREADDRR_CMDENDADDR_Msk    (0xFFFFFFE0UL << DCACHE_CMDREADDRR_CMDENDADDR_Pos) /*!< 0xFFFFFFE0 */
#define DCACHE_CMDREADDRR_CMDENDADDR        DCACHE_CMDREADDRR_CMDENDADDR_Msk        /*!< Command end address */

/******************************************************************************/
/*                                                                            */
/*                      Analog Comparators (COMP)                             */
/*                                                                            */
/******************************************************************************/

#define COMP_WINDOW_MODE_SUPPORT  /*!< COMP feature available only on specific devices */

/**********************  Bit definition for COMP_CSR register  ****************/
#define COMP_CSR_EN_Pos                     (0U)
#define COMP_CSR_EN_Msk                     (0x1UL << COMP_CSR_EN_Pos)              /*!< 0x00000001 */
#define COMP_CSR_EN                         COMP_CSR_EN_Msk                         /*!< Comparator enable */
#define COMP_CSR_INMSEL_Pos                 (4U)
#define COMP_CSR_INMSEL_Msk                 (0xFUL << COMP_CSR_INMSEL_Pos)          /*!< 0x000000F0 */
#define COMP_CSR_INMSEL                     COMP_CSR_INMSEL_Msk                     /*!< Comparator input minus selection */
#define COMP_CSR_INMSEL_0                   (0x1UL << COMP_CSR_INMSEL_Pos)          /*!< 0x00000010 */
#define COMP_CSR_INMSEL_1                   (0x2UL << COMP_CSR_INMSEL_Pos)          /*!< 0x00000020 */
#define COMP_CSR_INMSEL_2                   (0x4UL << COMP_CSR_INMSEL_Pos)          /*!< 0x00000040 */
#define COMP_CSR_INMSEL_3                   (0x8UL << COMP_CSR_INMSEL_Pos)          /*!< 0x00000080 */
#define COMP_CSR_INPSEL_Pos                 (8U)
#define COMP_CSR_INPSEL_Msk                 (0x3UL << COMP_CSR_INPSEL_Pos)          /*!< 0x00000300 */
#define COMP_CSR_INPSEL                     COMP_CSR_INPSEL_Msk                     /*!< Comparator input plus selection */
#define COMP_CSR_INPSEL_0                   (0x1UL << COMP_CSR_INPSEL_Pos)          /*!< 0x00000100 */
#define COMP_CSR_INPSEL_1                   (0x2UL << COMP_CSR_INPSEL_Pos)          /*!< 0x00000200 */
#define COMP_CSR_WINMODE_Pos                (11U)
#define COMP_CSR_WINMODE_Msk                (0x1UL << COMP_CSR_WINMODE_Pos)         /*!< 0x00000800 */
#define COMP_CSR_WINMODE                    COMP_CSR_WINMODE_Msk                    /*!< Pair of comparators window mode. Bit intended to be used with COMP common instance (COMP_Common_TypeDef) */
#define COMP_CSR_WINOUT_Pos                 (14U)
#define COMP_CSR_WINOUT_Msk                 (0x1UL << COMP_CSR_WINOUT_Pos)          /*!< 0x00004000 */
#define COMP_CSR_WINOUT                     COMP_CSR_WINOUT_Msk                     /*!< Pair of comparators window output level. Bit intended to be used with COMP common instance (COMP_Common_TypeDef) */
#define COMP_CSR_POLARITY_Pos               (15U)
#define COMP_CSR_POLARITY_Msk               (0x1UL << COMP_CSR_POLARITY_Pos)        /*!< 0x00008000 */
#define COMP_CSR_POLARITY                   COMP_CSR_POLARITY_Msk                   /*!< Comparator output polarity */
#define COMP_CSR_HYST_Pos                   (16U)
#define COMP_CSR_HYST_Msk                   (0x3UL << COMP_CSR_HYST_Pos)            /*!< 0x00030000 */
#define COMP_CSR_HYST                       COMP_CSR_HYST_Msk                       /*!< Comparator input hysteresis */
#define COMP_CSR_HYST_0                     (0x1UL << COMP_CSR_HYST_Pos)            /*!< 0x00010000 */
#define COMP_CSR_HYST_1                     (0x2UL << COMP_CSR_HYST_Pos)            /*!< 0x00020000 */
#define COMP_CSR_PWRMODE_Pos                (18U)
#define COMP_CSR_PWRMODE_Msk                (0x3UL << COMP_CSR_PWRMODE_Pos)         /*!< 0x000C0000 */
#define COMP_CSR_PWRMODE                    COMP_CSR_PWRMODE_Msk                    /*!< Comparator power mode */
#define COMP_CSR_PWRMODE_0                  (0x1UL << COMP_CSR_PWRMODE_Pos)         /*!< 0x00040000 */
#define COMP_CSR_PWRMODE_1                  (0x2UL << COMP_CSR_PWRMODE_Pos)         /*!< 0x00080000 */
#define COMP_CSR_BLANKSEL_Pos               (20U)
#define COMP_CSR_BLANKSEL_Msk               (0x1FUL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x01F00000 */
#define COMP_CSR_BLANKSEL                   COMP_CSR_BLANKSEL_Msk                   /*!< Comparator blanking source */
#define COMP_CSR_BLANKSEL_0                 (0x01UL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x00100000 */
#define COMP_CSR_BLANKSEL_1                 (0x02UL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x00200000 */
#define COMP_CSR_BLANKSEL_2                 (0x04UL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x00400000 */
#define COMP_CSR_BLANKSEL_3                 (0x08UL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x00800000 */
#define COMP_CSR_BLANKSEL_4                 (0x10UL << COMP_CSR_BLANKSEL_Pos)       /*!< 0x01000000 */
#define COMP_CSR_VALUE_Pos                  (30U)
#define COMP_CSR_VALUE_Msk                  (0x1UL << COMP_CSR_VALUE_Pos)           /*!< 0x40000000 */
#define COMP_CSR_VALUE                      COMP_CSR_VALUE_Msk                      /*!< Comparator output level */
#define COMP_CSR_LOCK_Pos                   (31U)
#define COMP_CSR_LOCK_Msk                   (0x1UL << COMP_CSR_LOCK_Pos)            /*!< 0x80000000 */
#define COMP_CSR_LOCK                       COMP_CSR_LOCK_Msk                       /*!< Comparator lock */

/******************************************************************************/
/*                                                                            */
/*                         Operational Amplifier (OPAMP)                      */
/*                                                                            */
/******************************************************************************/
/*********************  Bit definition for OPAMPx_CSR register  ***************/
#define OPAMP_CSR_OPAEN_Pos                 (0U)
#define OPAMP_CSR_OPAEN_Msk                 (0x1UL << OPAMP_CSR_OPAEN_Pos)            /*!< 0x00000001 */
#define OPAMP_CSR_OPAEN                     OPAMP_CSR_OPAEN_Msk                       /*!< OPAMP enable */
#define OPAMP_CSR_OPALPM_Pos                (1U)
#define OPAMP_CSR_OPALPM_Msk                (0x1UL << OPAMP_CSR_OPALPM_Pos)           /*!< 0x00000002 */
#define OPAMP_CSR_OPALPM                    OPAMP_CSR_OPALPM_Msk                      /*!< Operational amplifier Low Power Mode */
#define OPAMP_CSR_OPAMODE_Pos               (2U)
#define OPAMP_CSR_OPAMODE_Msk               (0x3UL << OPAMP_CSR_OPAMODE_Pos)          /*!< 0x0000000C */
#define OPAMP_CSR_OPAMODE                   OPAMP_CSR_OPAMODE_Msk                     /*!< Operational amplifier PGA mode */
#define OPAMP_CSR_OPAMODE_0                 (0x1UL << OPAMP_CSR_OPAMODE_Pos)          /*!< 0x00000004 */
#define OPAMP_CSR_OPAMODE_1                 (0x2UL << OPAMP_CSR_OPAMODE_Pos)          /*!< 0x00000008 */
#define OPAMP_CSR_PGA_GAIN_Pos              (4U)
#define OPAMP_CSR_PGA_GAIN_Msk              (0x3UL << OPAMP_CSR_PGA_GAIN_Pos)         /*!< 0x00000030 */
#define OPAMP_CSR_PGA_GAIN                  OPAMP_CSR_PGA_GAIN_Msk                    /*!< Operational amplifier Programmable amplifier gain value */
#define OPAMP_CSR_PGA_GAIN_0                (0x1UL << OPAMP_CSR_PGA_GAIN_Pos)         /*!< 0x00000010 */
#define OPAMP_CSR_PGA_GAIN_1                (0x2UL << OPAMP_CSR_PGA_GAIN_Pos)         /*!< 0x00000020 */
#define OPAMP_CSR_VM_SEL_Pos                (8U)
#define OPAMP_CSR_VM_SEL_Msk                (0x3UL << OPAMP_CSR_VM_SEL_Pos)           /*!< 0x00000300 */
#define OPAMP_CSR_VM_SEL                    OPAMP_CSR_VM_SEL_Msk                      /*!< Inverting input selection */
#define OPAMP_CSR_VM_SEL_0                  (0x1UL << OPAMP_CSR_VM_SEL_Pos)           /*!< 0x00000100 */
#define OPAMP_CSR_VM_SEL_1                  (0x2UL << OPAMP_CSR_VM_SEL_Pos)           /*!< 0x00000200 */
#define OPAMP_CSR_VP_SEL_Pos                (10U)
#define OPAMP_CSR_VP_SEL_Msk                (0x1UL << OPAMP_CSR_VP_SEL_Pos)           /*!< 0x00000400 */
#define OPAMP_CSR_VP_SEL                    OPAMP_CSR_VP_SEL_Msk                      /*!< Non inverted input selection */
#define OPAMP_CSR_CALON_Pos                 (12U)
#define OPAMP_CSR_CALON_Msk                 (0x1UL << OPAMP_CSR_CALON_Pos)            /*!< 0x00001000 */
#define OPAMP_CSR_CALON                     OPAMP_CSR_CALON_Msk                       /*!< Calibration mode enable */
#define OPAMP_CSR_CALSEL_Pos                (13U)
#define OPAMP_CSR_CALSEL_Msk                (0x1UL << OPAMP_CSR_CALSEL_Pos)           /*!< 0x00002000 */
#define OPAMP_CSR_CALSEL                    OPAMP_CSR_CALSEL_Msk                      /*!< Calibration selection */
#define OPAMP_CSR_USERTRIM_Pos              (14U)
#define OPAMP_CSR_USERTRIM_Msk              (0x1UL << OPAMP_CSR_USERTRIM_Pos)         /*!< 0x00004000 */
#define OPAMP_CSR_USERTRIM                  OPAMP_CSR_USERTRIM_Msk                    /*!< User trimming enable */
#define OPAMP_CSR_CALOUT_Pos                (15U)
#define OPAMP_CSR_CALOUT_Msk                (0x1UL << OPAMP_CSR_CALOUT_Pos)           /*!< 0x00008000 */
#define OPAMP_CSR_CALOUT                    OPAMP_CSR_CALOUT_Msk                      /*!< Operational amplifier calibration output */
#define OPAMP_CSR_HSM_Pos                   (30U)
#define OPAMP_CSR_HSM_Msk                   (0x1UL << OPAMP_CSR_HSM_Pos)              /*!< 0x40000000 */
#define OPAMP_CSR_HSM                       OPAMP_CSR_HSM_Msk                         /*!< Operational amplifier high speed mode */
#define OPAMP_CSR_OPARANGE_Pos              (31U)
#define OPAMP_CSR_OPARANGE_Msk              (0x1UL << OPAMP_CSR_OPARANGE_Pos)         /*!< 0x80000000 */
#define OPAMP_CSR_OPARANGE                  OPAMP_CSR_OPARANGE_Msk                    /*!< Operational amplifier range setting */

/*******************  Bit definition for OPAMPx_OTR register  ******************/
#define OPAMP_OTR_TRIMOFFSETN_Pos           (0U)
#define OPAMP_OTR_TRIMOFFSETN_Msk           (0x1FUL << OPAMP_OTR_TRIMOFFSETN_Pos)     /*!< 0x0000001F */
#define OPAMP_OTR_TRIMOFFSETN               OPAMP_OTR_TRIMOFFSETN_Msk                 /*!< Trim for NMOS differential pairs */
#define OPAMP_OTR_TRIMOFFSETP_Pos           (8U)
#define OPAMP_OTR_TRIMOFFSETP_Msk           (0x1FUL << OPAMP_OTR_TRIMOFFSETP_Pos)     /*!< 0x00001F00 */
#define OPAMP_OTR_TRIMOFFSETP               OPAMP_OTR_TRIMOFFSETP_Msk                 /*!< Trim for PMOS differential pairs */

/*******************  Bit definition for OPAMPx_LPOTR register  ****************/
#define OPAMP_LPOTR_TRIMLPOFFSETN_Pos       (0U)
#define OPAMP_LPOTR_TRIMLPOFFSETN_Msk       (0x1FUL << OPAMP_LPOTR_TRIMLPOFFSETN_Pos) /*!< 0x0000001F */
#define OPAMP_LPOTR_TRIMLPOFFSETN           OPAMP_LPOTR_TRIMLPOFFSETN_Msk             /*!< Trim for NMOS differential pairs */
#define OPAMP_LPOTR_TRIMLPOFFSETP_Pos       (8U)
#define OPAMP_LPOTR_TRIMLPOFFSETP_Msk       (0x1FUL << OPAMP_LPOTR_TRIMLPOFFSETP_Pos) /*!< 0x00001F00 */
#define OPAMP_LPOTR_TRIMLPOFFSETP           OPAMP_LPOTR_TRIMLPOFFSETP_Msk             /*!< Trim for PMOS differential pairs */

/******************************************************************************/
/*                                                                            */
/*                                 MDF/ADF                                    */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for MDF/ADF_GCR register  ********************/
#define MDF_GCR_TRGO_Pos                    (0U)
#define MDF_GCR_TRGO_Msk                    (0x1UL << MDF_GCR_TRGO_Pos)             /*!< 0x00000001 */
#define MDF_GCR_TRGO                        MDF_GCR_TRGO_Msk                        /*!<Trigger output control */
#define MDF_GCR_ILVNB_Pos                   (4U)
#define MDF_GCR_ILVNB_Msk                   (0xFUL << MDF_GCR_ILVNB_Pos)            /*!< 0x000000F0 */
#define MDF_GCR_ILVNB                       MDF_GCR_ILVNB_Msk                       /*!< Interleaved Number */

/*******************  Bit definition for MDF/ADF_CKGCR register  ********************/
#define MDF_CKGCR_CKDEN_Pos                 (0U)
#define MDF_CKGCR_CKDEN_Msk                 (0x1UL << MDF_CKGCR_CKDEN_Pos)          /*!< 0x00000001 */
#define MDF_CKGCR_CKDEN                     MDF_CKGCR_CKDEN_Msk                     /*!<CKGEN diveders enable */
#define MDF_CKGCR_CCK0EN_Pos                (1U)
#define MDF_CKGCR_CCK0EN_Msk                (0x1UL << MDF_CKGCR_CCK0EN_Pos)         /*!< 0x00000002 */
#define MDF_CKGCR_CCK0EN                    MDF_CKGCR_CCK0EN_Msk                    /*!<CCK0 clock enable */
#define MDF_CKGCR_CCK1EN_Pos                (2U)
#define MDF_CKGCR_CCK1EN_Msk                (0x1UL << MDF_CKGCR_CCK1EN_Pos)         /*!< 0x00000004 */
#define MDF_CKGCR_CCK1EN                    MDF_CKGCR_CCK1EN_Msk                    /*!<CCK1 clock enable */
#define MDF_CKGCR_CKGMOD_Pos                (4U)
#define MDF_CKGCR_CKGMOD_Msk                (0x1UL << MDF_CKGCR_CKGMOD_Pos)         /*!< 0x00000010 */
#define MDF_CKGCR_CKGMOD                    MDF_CKGCR_CKGMOD_Msk                    /*!<Clock genartor mode */
#define MDF_CKGCR_CCK0DIR_Pos               (5U)
#define MDF_CKGCR_CCK0DIR_Msk               (0x1UL << MDF_CKGCR_CCK0DIR_Pos)        /*!< 0x00000020 */
#define MDF_CKGCR_CCK0DIR                   MDF_CKGCR_CCK0DIR_Msk                   /*!<CCK0 clock direction */
#define MDF_CKGCR_CCK1DIR_Pos               (6U)
#define MDF_CKGCR_CCK1DIR_Msk               (0x1UL << MDF_CKGCR_CCK1DIR_Pos)        /*!< 0x00000040 */
#define MDF_CKGCR_CCK1DIR                   MDF_CKGCR_CCK1DIR_Msk                   /*!<CCK1 clock direction */
#define MDF_CKGCR_TRGSENS_Pos               (8U)
#define MDF_CKGCR_TRGSENS_Msk               (0x1UL << MDF_CKGCR_TRGSENS_Pos)        /*!< 0x00000100 */
#define MDF_CKGCR_TRGSENS                   MDF_CKGCR_TRGSENS_Msk                   /*!<CKGEN trigger sensitivity selection */
#define MDF_CKGCR_TRGSRC_Pos                (12U)
#define MDF_CKGCR_TRGSRC_Msk                (0xFUL << MDF_CKGCR_TRGSRC_Pos)         /*!< 0x0000F000 */
#define MDF_CKGCR_TRGSRC                    MDF_CKGCR_TRGSRC_Msk                    /*!<Digital Filter trigger signal selection */
#define MDF_CKGCR_TRGSRC_0                  (0x1UL << MDF_CKGCR_TRGSRC_Pos)         /*!< 0x00001000 */
#define MDF_CKGCR_TRGSRC_1                  (0x2UL << MDF_CKGCR_TRGSRC_Pos)         /*!< 0x00002000 */
#define MDF_CKGCR_TRGSRC_2                  (0x4UL << MDF_CKGCR_TRGSRC_Pos)         /*!< 0x00004000 */
#define MDF_CKGCR_TRGSRC_3                  (0x8UL << MDF_CKGCR_TRGSRC_Pos)         /*!< 0x00008000 */
#define MDF_CKGCR_CCKDIV_Pos                (16U)
#define MDF_CKGCR_CCKDIV_Msk                (0xFUL << MDF_CKGCR_CCKDIV_Pos)         /*!< 0x000F0000 */
#define MDF_CKGCR_CCKDIV                    MDF_CKGCR_CCKDIV_Msk                    /*!<Divider to control the MDF_CCK clock */
#define MDF_CKGCR_PROCDIV_Pos               (24U)
#define MDF_CKGCR_PROCDIV_Msk               (0x7FUL << MDF_CKGCR_PROCDIV_Pos)       /*!< 0x7F000000 */
#define MDF_CKGCR_PROCDIV                   MDF_CKGCR_PROCDIV_Msk                   /*!<Divider to control the serial interface clock */
#define MDF_CKGCR_CCKACTIVE_Pos             (31U)
#define MDF_CKGCR_CCKACTIVE_Msk             (0x1UL << MDF_CKGCR_CCKACTIVE_Pos)      /*!< 0x80000000 */
#define MDF_CKGCR_CCKACTIVE                 MDF_CKGCR_CCKACTIVE_Msk                 /*!<Clock generator active flag */

/*******************  Bit definition for MDF/ADF_OR register  ********************/
#define MDF_OR_OPTION_Pos                   (0U)
#define MDF_OR_OPTION_Msk                   (0xFFFFFFFFUL << MDF_OR_OPTION_Pos)     /*!< 0xFFFFFFFF */
#define MDF_OR_OPTION                       MDF_OR_OPTION_Msk                       /*!<Option Control Bits */

/*******************  Bit definition for MDF/ADF_SITFxCR register  ********************/
#define MDF_SITFCR_SITFEN_Pos               (0U)
#define MDF_SITFCR_SITFEN_Msk               (0x1UL << MDF_SITFCR_SITFEN_Pos)        /*!< 0x00000001 */
#define MDF_SITFCR_SITFEN                   MDF_SITFCR_SITFEN_Msk                   /*!<Serial interface enable */
#define MDF_SITFCR_SCKSRC_Pos               (1U)
#define MDF_SITFCR_SCKSRC_Msk               (0x3UL << MDF_SITFCR_SCKSRC_Pos)        /*!< 0x00000006 */
#define MDF_SITFCR_SCKSRC                   MDF_SITFCR_SCKSRC_Msk                   /*!<Serial clock source */
#define MDF_SITFCR_SCKSRC_0                 (0x1UL << MDF_SITFCR_SCKSRC_Pos)
#define MDF_SITFCR_SCKSRC_1                 (0x2UL << MDF_SITFCR_SCKSRC_Pos)
#define MDF_SITFCR_SITFMOD_Pos              (4U)
#define MDF_SITFCR_SITFMOD_Msk              (0x3UL << MDF_SITFCR_SITFMOD_Pos)       /*!< 0x00000030 */
#define MDF_SITFCR_SITFMOD                  MDF_SITFCR_SITFMOD_Msk                  /*!<Serial interface type */
#define MDF_SITFCR_SITFMOD_0                (0x1UL << MDF_SITFCR_SITFMOD_Pos)       /*!< 0x00000010 */
#define MDF_SITFCR_SITFMOD_1                (0x2UL << MDF_SITFCR_SITFMOD_Pos)       /*!< 0x00000020 */
#define MDF_SITFCR_STH_Pos                  (8U)
#define MDF_SITFCR_STH_Msk                  (0x1FUL << MDF_SITFCR_STH_Pos)          /*!< 0x00001F00 */
#define MDF_SITFCR_STH                      MDF_SITFCR_STH_Msk                      /*!<Manchester Symbol threshold / SPI threshold */
#define MDF_SITFCR_SITFACTIVE_Pos           (31U)
#define MDF_SITFCR_SITFACTIVE_Msk           (0x1UL << MDF_SITFCR_SITFACTIVE_Pos)    /*!< 0x80000000 */
#define MDF_SITFCR_SITFACTIVE               MDF_SITFCR_SITFACTIVE_Msk               /*!<Serial interface active flag */

/*******************  Bit definition for MDF/ADF_BSMXxCR register  ********************/
#define MDF_BSMXCR_BSSEL_Pos                (0U)
#define MDF_BSMXCR_BSSEL_Msk                (0x1FUL << MDF_BSMXCR_BSSEL_Pos)        /*!< 0x0000001F */
#define MDF_BSMXCR_BSSEL                    MDF_BSMXCR_BSSEL_Msk                    /*!<Bit Streal selection */
#define MDF_BSMXCR_BSSEL_0                  (0x1UL  << MDF_BSMXCR_BSSEL_Pos)        /*!< 0x00000001 */
#define MDF_BSMXCR_BSSEL_1                  (0x2UL  << MDF_BSMXCR_BSSEL_Pos)        /*!< 0x00000002 */
#define MDF_BSMXCR_BSSEL_2                  (0x4UL  << MDF_BSMXCR_BSSEL_Pos)        /*!< 0x00000004 */
#define MDF_BSMXCR_BSSEL_3                  (0x8UL  << MDF_BSMXCR_BSSEL_Pos)        /*!< 0x00000008 */
#define MDF_BSMXCR_BSSEL_4                  (0x10UL  << MDF_BSMXCR_BSSEL_Pos)       /*!< 0x00000010 */
#define MDF_BSMXCR_BSMXACTIVATE_Pos         (31U)
#define MDF_BSMXCR_BSMXACTIVATE_Msk         (0x1UL << MDF_BSMXCR_BSMXACTIVATE_Pos)  /*!< 0x80000000 */
#define MDF_BSMXCR_BSMXACTIVATE             MDF_BSMXCR_BSMXACTIVATE_Msk             /*!<Bit Streal activation flag */

/*******************  Bit definition for MDF/ADF_DFLTxCR register  ********************/
#define MDF_DFLTCR_DFLTEN_Pos               (0U)
#define MDF_DFLTCR_DFLTEN_Msk               (0x1UL << MDF_DFLTCR_DFLTEN_Pos)        /*!< 0x00000001 */
#define MDF_DFLTCR_DFLTEN                   MDF_DFLTCR_DFLTEN_Msk                   /*!<Digital filter enable */
#define MDF_DFLTCR_DMAEN_Pos                (1U)
#define MDF_DFLTCR_DMAEN_Msk                (0x1UL << MDF_DFLTCR_DMAEN_Pos)         /*!< 0x00000002 */
#define MDF_DFLTCR_DMAEN                    MDF_DFLTCR_DMAEN_Msk                    /*!<DMA request enable */
#define MDF_DFLTCR_FTH_Pos                  (2U)
#define MDF_DFLTCR_FTH_Msk                  (0x1UL << MDF_DFLTCR_FTH_Pos)           /*!< 0x00000004 */
#define MDF_DFLTCR_FTH                      MDF_DFLTCR_FTH_Msk                      /*!<RXFIFO Threshold selection */
#define MDF_DFLTCR_ACQMOD_Pos               (4U)
#define MDF_DFLTCR_ACQMOD_Msk               (0x7UL << MDF_DFLTCR_ACQMOD_Pos)        /*!< 0x00000004 */
#define MDF_DFLTCR_ACQMOD                   MDF_DFLTCR_ACQMOD_Msk                   /*!<Digital filter trigger mode */
#define MDF_DFLTCR_ACQMOD_0                 (0x1UL << MDF_DFLTCR_ACQMOD_Pos)        /*!< 0x00000010 */
#define MDF_DFLTCR_ACQMOD_1                 (0x2UL << MDF_DFLTCR_ACQMOD_Pos)        /*!< 0x00000020 */
#define MDF_DFLTCR_ACQMOD_2                 (0x4UL << MDF_DFLTCR_ACQMOD_Pos)        /*!< 0x00000040 */
#define MDF_DFLTCR_TRGSENS_Pos              (8U)
#define MDF_DFLTCR_TRGSENS_Msk              (0x1UL << MDF_DFLTCR_TRGSENS_Pos)       /*!< 0x00000004 */
#define MDF_DFLTCR_TRGSENS                  MDF_DFLTCR_TRGSENS_Msk                  /*!<Digital filter trigger sensitivity selection */
#define MDF_DFLTCR_TRGSRC_Pos               (12U)
#define MDF_DFLTCR_TRGSRC_Msk               (0xFUL << MDF_DFLTCR_TRGSRC_Pos)        /*!< 0x00000004 */
#define MDF_DFLTCR_TRGSRC                   MDF_DFLTCR_TRGSRC_Msk                   /*!<Digital filter trigger signal selection */
#define MDF_DFLTCR_TRGSRC_0                 (0x1UL << MDF_DFLTCR_TRGSRC_Pos)        /*!< 0x00001000 */
#define MDF_DFLTCR_TRGSRC_1                 (0x2UL << MDF_DFLTCR_TRGSRC_Pos)        /*!< 0x00002000 */
#define MDF_DFLTCR_TRGSRC_2                 (0x4UL << MDF_DFLTCR_TRGSRC_Pos)        /*!< 0x00004000 */
#define MDF_DFLTCR_TRGSRC_3                 (0x8UL << MDF_DFLTCR_TRGSRC_Pos)        /*!< 0x00008000 */
#define MDF_DFLTCR_SNPSFMT_Pos              (16U)
#define MDF_DFLTCR_SNPSFMT_Msk              (0x1UL << MDF_DFLTCR_SNPSFMT_Pos)       /*!< 0x00000004 */
#define MDF_DFLTCR_SNPSFMT                  MDF_DFLTCR_SNPSFMT_Msk                  /*!<SnapShot Data format */
#define MDF_DFLTCR_NBDIS_Pos                (20U)
#define MDF_DFLTCR_NBDIS_Msk                (0xFFUL << MDF_DFLTCR_NBDIS_Pos)        /*!< 0x00000004 */
#define MDF_DFLTCR_NBDIS                    MDF_DFLTCR_NBDIS_Msk                    /*!<Number of samples to be discard */
#define MDF_DFLTCR_DFLTRUN_Pos              (30U)
#define MDF_DFLTCR_DFLTRUN_Msk              (0x1UL << MDF_DFLTCR_DFLTRUN_Pos)       /*!< 0x00000004 */
#define MDF_DFLTCR_DFLTRUN                  MDF_DFLTCR_DFLTRUN_Msk                  /*!<Digital filter run status flag */
#define MDF_DFLTCR_DFLTACTIVE_Pos           (31U)
#define MDF_DFLTCR_DFLTACTIVE_Msk           (0x1UL << MDF_DFLTCR_DFLTACTIVE_Pos)    /*!< 0x00000004 */
#define MDF_DFLTCR_DFLTACTIVE               MDF_DFLTCR_DFLTACTIVE_Msk               /*!<Digital filter active flag */

/*******************  Bit definition for MDF/ADF_DFLTxCICR register  ********************/
#define MDF_DFLTCICR_DATSRC_Pos             (0U)
#define MDF_DFLTCICR_DATSRC_Msk             (0x3UL << MDF_DFLTCICR_DATSRC_Pos)      /*!< 0x00000003 */
#define MDF_DFLTCICR_DATSRC                 MDF_DFLTCICR_DATSRC_Msk                 /*!<Source Data for the digital filter */
#define MDF_DFLTCICR_DATSRC_0               (0x1UL << MDF_DFLTCICR_DATSRC_Pos)      /*!< 0x00000001 */
#define MDF_DFLTCICR_DATSRC_1               (0x2UL << MDF_DFLTCICR_DATSRC_Pos)      /*!< 0x00000002 */
#define MDF_DFLTCICR_CICMOD_Pos             (4U)
#define MDF_DFLTCICR_CICMOD_Msk             (0x7UL << MDF_DFLTCICR_CICMOD_Pos)      /*!< 0x00000070 */
#define MDF_DFLTCICR_CICMOD                 MDF_DFLTCICR_CICMOD_Msk                 /*!<Select the CIC Mode*/
#define MDF_DFLTCICR_CICMOD_0               (0x1UL << MDF_DFLTCICR_CICMOD_Pos)      /*!< 0x00000010 */
#define MDF_DFLTCICR_CICMOD_1               (0x2UL << MDF_DFLTCICR_CICMOD_Pos)      /*!< 0x00000020 */
#define MDF_DFLTCICR_CICMOD_2               (0x4UL << MDF_DFLTCICR_CICMOD_Pos)      /*!< 0x00000030 */
#define MDF_DFLTCICR_MCICD_Pos              (8U)
#define MDF_DFLTCICR_MCICD_Msk              (0x1FFUL << MDF_DFLTCICR_MCICD_Pos)     /*!< 0x0001FF00 */
#define MDF_DFLTCICR_MCICD                  MDF_DFLTCICR_MCICD_Msk                  /*!<CIC decimation ratio selection*/
#define MDF_DFLTCICR_SCALE_Pos              (20U)
#define MDF_DFLTCICR_SCALE_Msk              (0x3FUL << MDF_DFLTCICR_SCALE_Pos)      /*!< 0x03F00000 */
#define MDF_DFLTCICR_SCALE                  MDF_DFLTCICR_SCALE_Msk                  /*!<Scaling factor selection*/

/*******************  Bit definition for MDF/ADF_DFLTxRSFR register  ********************/
#define MDF_DFLTRSFR_RSFLTBYP_Pos           (0U)
#define MDF_DFLTRSFR_RSFLTBYP_Msk           (0x1UL << MDF_DFLTRSFR_RSFLTBYP_Pos)    /*!< 0x00000001 */
#define MDF_DFLTRSFR_RSFLTBYP               MDF_DFLTRSFR_RSFLTBYP_Msk               /*!<Reshape filter bypass*/
#define MDF_DFLTRSFR_RSFLTD_Pos             (4U)
#define MDF_DFLTRSFR_RSFLTD_Msk             (0x1UL << MDF_DFLTRSFR_RSFLTD_Pos)      /*!< 0x00000010 */
#define MDF_DFLTRSFR_RSFLTD                 MDF_DFLTRSFR_RSFLTD_Msk                 /*!<Reshape filter decimation ratio*/
#define MDF_DFLTRSFR_HPFBYP_Pos             (7U)
#define MDF_DFLTRSFR_HPFBYP_Msk             (0x1UL << MDF_DFLTRSFR_HPFBYP_Pos)      /*!< 0x00000080 */
#define MDF_DFLTRSFR_HPFBYP                 MDF_DFLTRSFR_HPFBYP_Msk                 /*!<High-pass filter bypass*/
#define MDF_DFLTRSFR_HPFC_Pos               (8U)
#define MDF_DFLTRSFR_HPFC_Msk               (0x3UL << MDF_DFLTRSFR_HPFC_Pos)        /*!< 0x00000080 */
#define MDF_DFLTRSFR_HPFC                   MDF_DFLTRSFR_HPFC_Msk                   /*!<High-pass filter cut-off frequency*/
#define MDF_DFLTRSFR_HPFC_0                 (0x1UL << MDF_DFLTRSFR_HPFC_Pos)
#define MDF_DFLTRSFR_HPFC_1                 (0x2UL << MDF_DFLTRSFR_HPFC_Pos)

/*******************  Bit definition for MDF/ADF_DFLTxINTR register  ********************/
#define MDF_DFLTINTR_INTDIV_Pos             (0U)
#define MDF_DFLTINTR_INTDIV_Msk             (0x3UL << MDF_DFLTINTR_INTDIV_Pos)      /*!< 0x00000003 */
#define MDF_DFLTINTR_INTDIV                 MDF_DFLTINTR_INTDIV_Msk                 /*!<Integrator output dividion*/
#define MDF_DFLTINTR_INTDIV_0               (0x1UL << MDF_DFLTINTR_INTDIV_Pos)      /*!< 0x00000001 */
#define MDF_DFLTINTR_INTDIV_1               (0x2UL << MDF_DFLTINTR_INTDIV_Pos)      /*!< 0x00000002 */
#define MDF_DFLTINTR_INTVAL_Pos             (4U)
#define MDF_DFLTINTR_INTVAL_Msk             (0x7FUL << MDF_DFLTINTR_INTVAL_Pos)     /*!< 0x000007F0 */
#define MDF_DFLTINTR_INTVAL                 MDF_DFLTINTR_INTVAL_Msk                 /*!<Integrator value selection*/

/*******************  Bit definition for MDF/ADF_OLDxCR register  ********************/
#define MDF_OLDCR_OLDEN_Pos                 (0U)
#define MDF_OLDCR_OLDEN_Msk                 (0x1UL << MDF_OLDCR_OLDEN_Pos)          /*!< 0x00000001 */
#define MDF_OLDCR_OLDEN                     MDF_OLDCR_OLDEN_Msk                     /*!<OLD enable*/
#define MDF_OLDCR_THINB_Pos                 (1U)
#define MDF_OLDCR_THINB_Msk                 (0x1UL << MDF_OLDCR_THINB_Pos)          /*!< 0x00000002 */
#define MDF_OLDCR_THINB                     MDF_OLDCR_THINB_Msk                     /*!<OLD threshold in band*/
#define MDF_OLDCR_BKOLD_Pos                 (4U)
#define MDF_OLDCR_BKOLD_Msk                 (0xFUL << MDF_OLDCR_BKOLD_Pos)          /*!< 0x000000F0 */
#define MDF_OLDCR_BKOLD                     MDF_OLDCR_BKOLD_Msk                     /*!<Bteak signal assignment for OLD*/
#define MDF_OLDCR_BKOLD_0                   (0x1UL << MDF_OLDCR_BKOLD_Pos)          /*!< 0x00000010 */
#define MDF_OLDCR_BKOLD_1                   (0x2UL << MDF_OLDCR_BKOLD_Pos)          /*!< 0x00000020 */
#define MDF_OLDCR_BKOLD_2                   (0x4UL << MDF_OLDCR_BKOLD_Pos)          /*!< 0x00000040 */
#define MDF_OLDCR_BKOLD_3                   (0x8UL << MDF_OLDCR_BKOLD_Pos)          /*!< 0x00000080 */
#define MDF_OLDCR_ACICN_Pos                 (12U)
#define MDF_OLDCR_ACICN_Msk                 (0x3UL << MDF_OLDCR_ACICN_Pos)          /*!< 0x00003000 */
#define MDF_OLDCR_ACICN                     MDF_OLDCR_ACICN_Msk                     /*!<OLD CIC order selection*/
#define MDF_OLDCR_ACICN_0                   (0x1UL << MDF_OLDCR_ACICN_Pos)          /*!< 0x00001000 */
#define MDF_OLDCR_ACICN_1                   (0x2UL << MDF_OLDCR_ACICN_Pos)          /*!< 0x00002000 */
#define MDF_OLDCR_ACICD_Pos                 (17U)
#define MDF_OLDCR_ACICD_Msk                 (0x1FUL << MDF_OLDCR_ACICD_Pos)         /*!< 0x003E0000 */
#define MDF_OLDCR_ACICD                     MDF_OLDCR_ACICD_Msk                     /*!<OLD CIC decimation ratio selection*/
#define MDF_OLDCR_OLDACTIVE_Pos             (31U)
#define MDF_OLDCR_OLDACTIVE_Msk             (0x1UL << MDF_OLDCR_OLDACTIVE_Pos)      /*!< 0x80000000 */
#define MDF_OLDCR_OLDACTIVE                 MDF_OLDCR_OLDACTIVE_Msk                 /*!<OLD active flag*/

/*******************  Bit definition for MDF/ADF_OLDxTHLR register  ********************/
#define MDF_OLDTHLR_OLDTHL_Pos              (0U)
#define MDF_OLDTHLR_OLDTHL_Msk              (0x3FFFFFFUL << MDF_OLDTHLR_OLDTHL_Pos) /*!< 0x03FFFFFF */
#define MDF_OLDTHLR_OLDTHL                  MDF_OLDTHLR_OLDTHL_Msk                  /*!<OLD Low threshold value*/

/*******************  Bit definition for MDF/ADF_OLDxTHHR register  ********************/
#define MDF_OLDTHHR_OLDTHH_Pos              (0U)
#define MDF_OLDTHHR_OLDTHH_Msk              (0x3FFFFFFUL << MDF_OLDTHHR_OLDTHH_Pos) /*!< 0x03FFFFFF */
#define MDF_OLDTHHR_OLDTHH                  MDF_OLDTHHR_OLDTHH_Msk                  /*!<OLD High threshold value*/

/*******************  Bit definition for MDF/ADF_DLYxCR register  ********************/
#define MDF_DLYCR_SKPDLY_Pos                (0U)
#define MDF_DLYCR_SKPDLY_Msk                (0x7FUL << MDF_DLYCR_SKPDLY_Pos)        /*!< 0x0000007F */
#define MDF_DLYCR_SKPDLY                    MDF_DLYCR_SKPDLY_Msk                    /*!<Delay to apply to a bitstream*/
#define MDF_DLYCR_SKPBF_Pos                 (31U)
#define MDF_DLYCR_SKPBF_Msk                 (0x1UL << MDF_DLYCR_SKPBF_Pos)          /*!< 0x80000000 */
#define MDF_DLYCR_SKPBF                     MDF_DLYCR_SKPBF_Msk                     /*!<DSkip Busy Flag*/

/*******************  Bit definition for MDF/ADF_SCDxCR register  ********************/
#define MDF_SCDCR_SCDEN_Pos                 (0U)
#define MDF_SCDCR_SCDEN_Msk                 (0x1UL << MDF_SCDCR_SCDEN_Pos)          /*!< 0x00000001 */
#define MDF_SCDCR_SCDEN                     MDF_SCDCR_SCDEN_Msk                     /*!<Short circuit detector enable*/
#define MDF_SCDCR_BKSCD_Pos                 (4U)
#define MDF_SCDCR_BKSCD_Msk                 (0xFUL << MDF_SCDCR_BKSCD_Pos)          /*!< 0x000000F0 */
#define MDF_SCDCR_BKSCD                     MDF_SCDCR_BKSCD_Msk                     /*!<Break signal assignment to short circuit detector */
#define MDF_SCDCR_BKSCD_0                   (0x1UL << MDF_SCDCR_BKSCD_Pos)          /*!< 0x00000010 */
#define MDF_SCDCR_BKSCD_1                   (0x2UL << MDF_SCDCR_BKSCD_Pos)          /*!< 0x00000020 */
#define MDF_SCDCR_BKSCD_2                   (0x4UL << MDF_SCDCR_BKSCD_Pos)          /*!< 0x00000040 */
#define MDF_SCDCR_BKSCD_3                   (0x8UL << MDF_SCDCR_BKSCD_Pos)          /*!< 0x00000080 */
#define MDF_SCDCR_SCDT_Pos                  (12U)
#define MDF_SCDCR_SCDT_Msk                  (0xFFUL << MDF_SCDCR_SCDT_Pos)          /*!< 0x00000FF00 */
#define MDF_SCDCR_SCDT                      MDF_SCDCR_SCDT_Msk                      /*!<Short circuit detector threshold*/
#define MDF_SCDCR_SCDACTIVE_Pos             (31U)
#define MDF_SCDCR_SCDACTIVE_Msk             (0x1UL << MDF_SCDCR_SCDACTIVE_Pos)      /*!< 0x80000000 */
#define MDF_SCDCR_SCDACTIVE                 MDF_SCDCR_SCDACTIVE_Msk                 /*!<Short circuit detector active flag*/

/*******************  Bit definition for MDF/ADF_DFLTIER register  ********************/
#define MDF_DFLTIER_FTHIE_Pos               (0U)
#define MDF_DFLTIER_FTHIE_Msk               (0x1UL << MDF_DFLTIER_FTHIE_Pos)        /*!< 0x00000001 */
#define MDF_DFLTIER_FTHIE                   MDF_DFLTIER_FTHIE_Msk                   /*!<RXFIFO threshold interrupt enable*/
#define MDF_DFLTIER_DOVRIE_Pos              (1U)
#define MDF_DFLTIER_DOVRIE_Msk              (0x1UL << MDF_DFLTIER_DOVRIE_Pos)       /*!< 0x00000002 */
#define MDF_DFLTIER_DOVRIE                  MDF_DFLTIER_DOVRIE_Msk                  /*!<Data overflow interrupt enable*/
#define MDF_DFLTIER_SSDRIE_Pos              (2U)
#define MDF_DFLTIER_SSDRIE_Msk              (0x1UL << MDF_DFLTIER_SSDRIE_Pos)       /*!< 0x00000004 */
#define MDF_DFLTIER_SSDRIE                  MDF_DFLTIER_SSDRIE_Msk                  /*!<Snapshot data ready interrupt enable*/
#define MDF_DFLTIER_OLDIE_Pos               (4U)
#define MDF_DFLTIER_OLDIE_Msk               (0x1UL << MDF_DFLTIER_OLDIE_Pos)        /*!< 0x00000010 */
#define MDF_DFLTIER_OLDIE                   MDF_DFLTIER_OLDIE_Msk                   /*!<OLD interrupt enable*/
#define MDF_DFLTIER_SSOVRIE_Pos             (7U)
#define MDF_DFLTIER_SSOVRIE_Msk             (0x1UL << MDF_DFLTIER_SSOVRIE_Pos)      /*!< 0x00000080 */
#define MDF_DFLTIER_SSOVRIE                 MDF_DFLTIER_SSOVRIE_Msk                 /*!<Snapshot overrun interrupt enable*/
#define MDF_DFLTIER_SCDIE_Pos               (8U)
#define MDF_DFLTIER_SCDIE_Msk               (0x1UL << MDF_DFLTIER_SCDIE_Pos)        /*!< 0x00000100 */
#define MDF_DFLTIER_SCDIE                   MDF_DFLTIER_SCDIE_Msk                   /*!<Short circuit dtector interrupt enable*/
#define MDF_DFLTIER_SATIE_Pos               (9U)
#define MDF_DFLTIER_SATIE_Msk               (0x1UL << MDF_DFLTIER_SATIE_Pos)        /*!< 0x00000200 */
#define MDF_DFLTIER_SATIE                   MDF_DFLTIER_SATIE_Msk                   /*!<Saturation detection interrupt enable*/
#define MDF_DFLTIER_CKABIE_Pos              (10U)
#define MDF_DFLTIER_CKABIE_Msk              (0x1UL << MDF_DFLTIER_CKABIE_Pos)       /*!< 0x00000400 */
#define MDF_DFLTIER_CKABIE                  MDF_DFLTIER_CKABIE_Msk                  /*!<Clock absence detection interrupt enable*/
#define MDF_DFLTIER_RFOVRIE_Pos             (11U)
#define MDF_DFLTIER_RFOVRIE_Msk             (0x1UL << MDF_DFLTIER_RFOVRIE_Pos)      /*!< 0x00000800 */
#define MDF_DFLTIER_RFOVRIE                 MDF_DFLTIER_RFOVRIE_Msk                 /*!<reshape filter overrun interrupt enable*/
#define MDF_DFLTIER_SDDETIE_Pos             (12U)
#define MDF_DFLTIER_SDDETIE_Msk             (0x1UL << MDF_DFLTIER_SDDETIE_Pos)      /*!< 0x00001000 */
#define MDF_DFLTIER_SDDETIE                 MDF_DFLTIER_SDDETIE_Msk                 /*!<SAD interrupt enable*/
#define MDF_DFLTIER_SDLVLIE_Pos             (13U)
#define MDF_DFLTIER_SDLVLIE_Msk             (0x1UL << MDF_DFLTIER_SDLVLIE_Pos)      /*!< 0x00002000 */
#define MDF_DFLTIER_SDLVLIE                 MDF_DFLTIER_SDLVLIE_Msk                 /*!<Sound level value ready interrupt enable*/

/*******************  Bit definition for MDF/ADF_DFLTISR register  ********************/
#define MDF_DFLTISR_FTHF_Pos                (0U)
#define MDF_DFLTISR_FTHF_Msk                (0x1UL << MDF_DFLTISR_FTHF_Pos)         /*!< 0x00000001 */
#define MDF_DFLTISR_FTHF                    MDF_DFLTISR_FTHF_Msk                    /*!<RXFIFO threshold interrupt flag*/
#define MDF_DFLTISR_DOVRF_Pos               (1U)
#define MDF_DFLTISR_DOVRF_Msk               (0x1UL << MDF_DFLTISR_DOVRF_Pos)        /*!< 0x00000002 */
#define MDF_DFLTISR_DOVRF                   MDF_DFLTISR_DOVRF_Msk                   /*!<Data overflow interrupt flag*/
#define MDF_DFLTISR_SSDRF_Pos               (2U)
#define MDF_DFLTISR_SSDRF_Msk               (0x1UL << MDF_DFLTISR_SSDRF_Pos)        /*!< 0x00000004 */
#define MDF_DFLTISR_SSDRF                   MDF_DFLTISR_SSDRF_Msk                   /*!<Snapshot data ready interrupt flag*/
#define MDF_DFLTISR_RXNEF_Pos               (3U)
#define MDF_DFLTISR_RXNEF_Msk               (0x1UL << MDF_DFLTISR_RXNEF_Pos)        /*!< 0x00000008 */
#define MDF_DFLTISR_RXNEF                   MDF_DFLTISR_RXNEF_Msk                   /*!<Snapshot data ready interrupt flag*/
#define MDF_DFLTISR_OLDF_Pos                (4U)
#define MDF_DFLTISR_OLDF_Msk                (0x1UL << MDF_DFLTISR_OLDF_Pos)         /*!< 0x00000010 */
#define MDF_DFLTISR_OLDF                    MDF_DFLTISR_OLDF_Msk                    /*!<OLD interrupt flag*/
#define MDF_DFLTISR_THLF_Pos                (5U)
#define MDF_DFLTISR_THLF_Msk                (0x1UL << MDF_DFLTISR_THLF_Pos)         /*!< 0x00000010 */
#define MDF_DFLTISR_THLF                    MDF_DFLTISR_THLF_Msk                    /*!<OLD interrupt flag*/
#define MDF_DFLTISR_THHF_Pos                (6U)
#define MDF_DFLTISR_THHF_Msk                (0x1UL << MDF_DFLTISR_THHF_Pos)         /*!< 0x00000010 */
#define MDF_DFLTISR_THHF                    MDF_DFLTISR_THHF_Msk                    /*!<OLD interrupt flag*/
#define MDF_DFLTISR_SSOVRF_Pos              (7U)
#define MDF_DFLTISR_SSOVRF_Msk              (0x1UL << MDF_DFLTISR_SSOVRF_Pos)      /*!< 0x00000080 */
#define MDF_DFLTISR_SSOVRF                  MDF_DFLTISR_SSOVRF_Msk                  /*!<Snapshot overrun interrupt flag*/
#define MDF_DFLTISR_SCDF_Pos                (8U)
#define MDF_DFLTISR_SCDF_Msk                (0x1UL << MDF_DFLTISR