# ACSIP_S76S
# -----------------------------------------------------------------------------

set(ACSIP_S76S_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32L0xx/L072R(B-Z)T_L073R(B-Z)T_L083R(B-Z)T")
set(ACSIP_S76S_MAXSIZE 196608)
set(ACSIP_S76S_MAXDATASIZE 20480)
set(ACSIP_S76S_MCU cortex-m0plus)
set(ACSIP_S76S_FPCONF "-")
add_library(ACSIP_S76S INTERFACE)
target_compile_options(ACSIP_S76S INTERFACE
  "SHELL:-DSTM32L073xx   -D__CORTEX_SC=0"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL: "
  -mcpu=${ACSIP_S76S_MCU}
)
target_compile_definitions(ACSIP_S76S INTERFACE
  "STM32L0xx"
	"ARDUINO_ACSIP_S76S"
	"BOARD_NAME=\"ACSIP_S76S\""
	"BOARD_ID=ACSIP_S76S"
	"VARIANT_H=\"variant_ACSIP_S76S.h\""
)
target_include_directories(ACSIP_S76S INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32L0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32L0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32L0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32L0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32L0xx/Source/Templates/gcc/
  ${ACSIP_S76S_VARIANT_PATH}
)

target_link_options(ACSIP_S76S INTERFACE
  "LINKER:--default-script=${ACSIP_S76S_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=196608"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${ACSIP_S76S_MCU}
)

add_library(ACSIP_S76S_serial_disabled INTERFACE)
target_compile_options(ACSIP_S76S_serial_disabled INTERFACE
  "SHELL:"
)
add_library(ACSIP_S76S_serial_generic INTERFACE)
target_compile_options(ACSIP_S76S_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(ACSIP_S76S_serial_none INTERFACE)
target_compile_options(ACSIP_S76S_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# AFROFLIGHT_F103CB
# -----------------------------------------------------------------------------

set(AFROFLIGHT_F103CB_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(AFROFLIGHT_F103CB_MAXSIZE 131072)
set(AFROFLIGHT_F103CB_MAXDATASIZE 20480)
set(AFROFLIGHT_F103CB_MCU cortex-m3)
set(AFROFLIGHT_F103CB_FPCONF "-")
add_library(AFROFLIGHT_F103CB INTERFACE)
target_compile_options(AFROFLIGHT_F103CB INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_MCU}
)
target_compile_definitions(AFROFLIGHT_F103CB INTERFACE
  "STM32F1xx"
	"ARDUINO_AFROFLIGHT_F103CB"
	"BOARD_NAME=\"AFROFLIGHT_F103CB\""
	"BOARD_ID=AFROFLIGHT_F103CB"
	"VARIANT_H=\"variant_AFROFLIGHT_F103CB_XX.h\""
)
target_include_directories(AFROFLIGHT_F103CB INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${AFROFLIGHT_F103CB_VARIANT_PATH}
)

target_link_options(AFROFLIGHT_F103CB INTERFACE
  "LINKER:--default-script=${AFROFLIGHT_F103CB_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_MCU}
)

add_library(AFROFLIGHT_F103CB_serial_disabled INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_serial_disabled INTERFACE
  "SHELL:"
)
add_library(AFROFLIGHT_F103CB_serial_generic INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(AFROFLIGHT_F103CB_serial_none INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(AFROFLIGHT_F103CB_usb_CDC INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(AFROFLIGHT_F103CB_usb_CDCgen INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(AFROFLIGHT_F103CB_usb_HID INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(AFROFLIGHT_F103CB_usb_none INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_usb_none INTERFACE
  "SHELL:"
)
add_library(AFROFLIGHT_F103CB_xusb_FS INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_xusb_FS INTERFACE
  "SHELL:"
)
add_library(AFROFLIGHT_F103CB_xusb_HS INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(AFROFLIGHT_F103CB_xusb_HSFS INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# AFROFLIGHT_F103CB_12M
# -----------------------------------------------------------------------------

set(AFROFLIGHT_F103CB_12M_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(AFROFLIGHT_F103CB_12M_MAXSIZE 131072)
set(AFROFLIGHT_F103CB_12M_MAXDATASIZE 20480)
set(AFROFLIGHT_F103CB_12M_MCU cortex-m3)
set(AFROFLIGHT_F103CB_12M_FPCONF "-")
add_library(AFROFLIGHT_F103CB_12M INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_12M_MCU}
)
target_compile_definitions(AFROFLIGHT_F103CB_12M INTERFACE
  "STM32F1xx"
	"ARDUINO_AFROFLIGHT_F103CB_12M"
	"BOARD_NAME=\"AFROFLIGHT_F103CB_12M\""
	"BOARD_ID=AFROFLIGHT_F103CB_12M"
	"VARIANT_H=\"variant_AFROFLIGHT_F103CB_XX.h\""
)
target_include_directories(AFROFLIGHT_F103CB_12M INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${AFROFLIGHT_F103CB_12M_VARIANT_PATH}
)

target_link_options(AFROFLIGHT_F103CB_12M INTERFACE
  "LINKER:--default-script=${AFROFLIGHT_F103CB_12M_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_12M_MCU}
)

add_library(AFROFLIGHT_F103CB_12M_serial_disabled INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_serial_disabled INTERFACE
  "SHELL:"
)
add_library(AFROFLIGHT_F103CB_12M_serial_generic INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(AFROFLIGHT_F103CB_12M_serial_none INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(AFROFLIGHT_F103CB_12M_usb_CDC INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(AFROFLIGHT_F103CB_12M_usb_CDCgen INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(AFROFLIGHT_F103CB_12M_usb_HID INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(AFROFLIGHT_F103CB_12M_usb_none INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_usb_none INTERFACE
  "SHELL:"
)
add_library(AFROFLIGHT_F103CB_12M_xusb_FS INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_xusb_FS INTERFACE
  "SHELL:"
)
add_library(AFROFLIGHT_F103CB_12M_xusb_HS INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(AFROFLIGHT_F103CB_12M_xusb_HSFS INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# AFROFLIGHT_F103CB_12M_dfu2
# -----------------------------------------------------------------------------

set(AFROFLIGHT_F103CB_12M_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(AFROFLIGHT_F103CB_12M_dfu2_MAXSIZE 131072)
set(AFROFLIGHT_F103CB_12M_dfu2_MAXDATASIZE 20480)
set(AFROFLIGHT_F103CB_12M_dfu2_MCU cortex-m3)
set(AFROFLIGHT_F103CB_12M_dfu2_FPCONF "-")
add_library(AFROFLIGHT_F103CB_12M_dfu2 INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_12M_dfu2_MCU}
)
target_compile_definitions(AFROFLIGHT_F103CB_12M_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_AFROFLIGHT_F103CB_12M"
	"BOARD_NAME=\"AFROFLIGHT_F103CB_12M\""
	"BOARD_ID=AFROFLIGHT_F103CB_12M"
	"VARIANT_H=\"variant_AFROFLIGHT_F103CB_XX.h\""
)
target_include_directories(AFROFLIGHT_F103CB_12M_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${AFROFLIGHT_F103CB_12M_dfu2_VARIANT_PATH}
)

target_link_options(AFROFLIGHT_F103CB_12M_dfu2 INTERFACE
  "LINKER:--default-script=${AFROFLIGHT_F103CB_12M_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_12M_dfu2_MCU}
)


# AFROFLIGHT_F103CB_12M_dfuo
# -----------------------------------------------------------------------------

set(AFROFLIGHT_F103CB_12M_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(AFROFLIGHT_F103CB_12M_dfuo_MAXSIZE 131072)
set(AFROFLIGHT_F103CB_12M_dfuo_MAXDATASIZE 20480)
set(AFROFLIGHT_F103CB_12M_dfuo_MCU cortex-m3)
set(AFROFLIGHT_F103CB_12M_dfuo_FPCONF "-")
add_library(AFROFLIGHT_F103CB_12M_dfuo INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_12M_dfuo_MCU}
)
target_compile_definitions(AFROFLIGHT_F103CB_12M_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_AFROFLIGHT_F103CB_12M"
	"BOARD_NAME=\"AFROFLIGHT_F103CB_12M\""
	"BOARD_ID=AFROFLIGHT_F103CB_12M"
	"VARIANT_H=\"variant_AFROFLIGHT_F103CB_XX.h\""
)
target_include_directories(AFROFLIGHT_F103CB_12M_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${AFROFLIGHT_F103CB_12M_dfuo_VARIANT_PATH}
)

target_link_options(AFROFLIGHT_F103CB_12M_dfuo INTERFACE
  "LINKER:--default-script=${AFROFLIGHT_F103CB_12M_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_12M_dfuo_MCU}
)


# AFROFLIGHT_F103CB_12M_hid
# -----------------------------------------------------------------------------

set(AFROFLIGHT_F103CB_12M_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(AFROFLIGHT_F103CB_12M_hid_MAXSIZE 131072)
set(AFROFLIGHT_F103CB_12M_hid_MAXDATASIZE 20480)
set(AFROFLIGHT_F103CB_12M_hid_MCU cortex-m3)
set(AFROFLIGHT_F103CB_12M_hid_FPCONF "-")
add_library(AFROFLIGHT_F103CB_12M_hid INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_12M_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_12M_hid_MCU}
)
target_compile_definitions(AFROFLIGHT_F103CB_12M_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_AFROFLIGHT_F103CB_12M"
	"BOARD_NAME=\"AFROFLIGHT_F103CB_12M\""
	"BOARD_ID=AFROFLIGHT_F103CB_12M"
	"VARIANT_H=\"variant_AFROFLIGHT_F103CB_XX.h\""
)
target_include_directories(AFROFLIGHT_F103CB_12M_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${AFROFLIGHT_F103CB_12M_hid_VARIANT_PATH}
)

target_link_options(AFROFLIGHT_F103CB_12M_hid INTERFACE
  "LINKER:--default-script=${AFROFLIGHT_F103CB_12M_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_12M_hid_MCU}
)


# AFROFLIGHT_F103CB_dfu2
# -----------------------------------------------------------------------------

set(AFROFLIGHT_F103CB_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(AFROFLIGHT_F103CB_dfu2_MAXSIZE 131072)
set(AFROFLIGHT_F103CB_dfu2_MAXDATASIZE 20480)
set(AFROFLIGHT_F103CB_dfu2_MCU cortex-m3)
set(AFROFLIGHT_F103CB_dfu2_FPCONF "-")
add_library(AFROFLIGHT_F103CB_dfu2 INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_dfu2_MCU}
)
target_compile_definitions(AFROFLIGHT_F103CB_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_AFROFLIGHT_F103CB"
	"BOARD_NAME=\"AFROFLIGHT_F103CB\""
	"BOARD_ID=AFROFLIGHT_F103CB"
	"VARIANT_H=\"variant_AFROFLIGHT_F103CB_XX.h\""
)
target_include_directories(AFROFLIGHT_F103CB_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${AFROFLIGHT_F103CB_dfu2_VARIANT_PATH}
)

target_link_options(AFROFLIGHT_F103CB_dfu2 INTERFACE
  "LINKER:--default-script=${AFROFLIGHT_F103CB_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_dfu2_MCU}
)


# AFROFLIGHT_F103CB_dfuo
# -----------------------------------------------------------------------------

set(AFROFLIGHT_F103CB_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(AFROFLIGHT_F103CB_dfuo_MAXSIZE 131072)
set(AFROFLIGHT_F103CB_dfuo_MAXDATASIZE 20480)
set(AFROFLIGHT_F103CB_dfuo_MCU cortex-m3)
set(AFROFLIGHT_F103CB_dfuo_FPCONF "-")
add_library(AFROFLIGHT_F103CB_dfuo INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_dfuo_MCU}
)
target_compile_definitions(AFROFLIGHT_F103CB_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_AFROFLIGHT_F103CB"
	"BOARD_NAME=\"AFROFLIGHT_F103CB\""
	"BOARD_ID=AFROFLIGHT_F103CB"
	"VARIANT_H=\"variant_AFROFLIGHT_F103CB_XX.h\""
)
target_include_directories(AFROFLIGHT_F103CB_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${AFROFLIGHT_F103CB_dfuo_VARIANT_PATH}
)

target_link_options(AFROFLIGHT_F103CB_dfuo INTERFACE
  "LINKER:--default-script=${AFROFLIGHT_F103CB_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_dfuo_MCU}
)


# AFROFLIGHT_F103CB_hid
# -----------------------------------------------------------------------------

set(AFROFLIGHT_F103CB_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(AFROFLIGHT_F103CB_hid_MAXSIZE 131072)
set(AFROFLIGHT_F103CB_hid_MAXDATASIZE 20480)
set(AFROFLIGHT_F103CB_hid_MCU cortex-m3)
set(AFROFLIGHT_F103CB_hid_FPCONF "-")
add_library(AFROFLIGHT_F103CB_hid INTERFACE)
target_compile_options(AFROFLIGHT_F103CB_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_hid_MCU}
)
target_compile_definitions(AFROFLIGHT_F103CB_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_AFROFLIGHT_F103CB"
	"BOARD_NAME=\"AFROFLIGHT_F103CB\""
	"BOARD_ID=AFROFLIGHT_F103CB"
	"VARIANT_H=\"variant_AFROFLIGHT_F103CB_XX.h\""
)
target_include_directories(AFROFLIGHT_F103CB_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${AFROFLIGHT_F103CB_hid_VARIANT_PATH}
)

target_link_options(AFROFLIGHT_F103CB_hid INTERFACE
  "LINKER:--default-script=${AFROFLIGHT_F103CB_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${AFROFLIGHT_F103CB_hid_MCU}
)


# AGAFIA_SG0
# -----------------------------------------------------------------------------

set(AGAFIA_SG0_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32G0xx/G071C(6-8-B)(T-U)_G081CB(T-U)")
set(AGAFIA_SG0_MAXSIZE 131072)
set(AGAFIA_SG0_MAXDATASIZE 36864)
set(AGAFIA_SG0_MCU cortex-m0plus)
set(AGAFIA_SG0_FPCONF "-")
add_library(AGAFIA_SG0 INTERFACE)
target_compile_options(AGAFIA_SG0 INTERFACE
  "SHELL:-DSTM32G071xx   -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${AGAFIA_SG0_MCU}
)
target_compile_definitions(AGAFIA_SG0 INTERFACE
  "STM32G0xx"
	"ARDUINO_AGAFIA_SG0"
	"BOARD_NAME=\"AGAFIA_SG0\""
	"BOARD_ID=AGAFIA_SG0"
	"VARIANT_H=\"variant_AGAFIA_SG0.h\""
)
target_include_directories(AGAFIA_SG0 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32G0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32G0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32G0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32G0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32G0xx/Source/Templates/gcc/
  ${AGAFIA_SG0_VARIANT_PATH}
)

target_link_options(AGAFIA_SG0 INTERFACE
  "LINKER:--default-script=${AGAFIA_SG0_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=36864"
  "SHELL: "
  -mcpu=${AGAFIA_SG0_MCU}
)

add_library(AGAFIA_SG0_serial_disabled INTERFACE)
target_compile_options(AGAFIA_SG0_serial_disabled INTERFACE
  "SHELL:"
)
add_library(AGAFIA_SG0_serial_generic INTERFACE)
target_compile_options(AGAFIA_SG0_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(AGAFIA_SG0_serial_none INTERFACE)
target_compile_options(AGAFIA_SG0_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(AGAFIA_SG0_usb_CDC INTERFACE)
target_compile_options(AGAFIA_SG0_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(AGAFIA_SG0_usb_CDCgen INTERFACE)
target_compile_options(AGAFIA_SG0_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(AGAFIA_SG0_usb_HID INTERFACE)
target_compile_options(AGAFIA_SG0_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(AGAFIA_SG0_usb_none INTERFACE)
target_compile_options(AGAFIA_SG0_usb_none INTERFACE
  "SHELL:"
)

# ARMED_V1
# -----------------------------------------------------------------------------

set(ARMED_V1_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407V(E-G)T_F417V(E-G)T")
set(ARMED_V1_MAXSIZE 524288)
set(ARMED_V1_MAXDATASIZE 131072)
set(ARMED_V1_MCU cortex-m4)
set(ARMED_V1_FPCONF "fpv4-sp-d16-hard")
add_library(ARMED_V1 INTERFACE)
target_compile_options(ARMED_V1 INTERFACE
  "SHELL:-DSTM32F407xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${ARMED_V1_MCU}
)
target_compile_definitions(ARMED_V1 INTERFACE
  "STM32F4xx"
	"ARDUINO_ARMED_V1"
	"BOARD_NAME=\"ARMED_V1\""
	"BOARD_ID=ARMED_V1"
	"VARIANT_H=\"variant_ARMED_V1.h\""
)
target_include_directories(ARMED_V1 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${ARMED_V1_VARIANT_PATH}
)

target_link_options(ARMED_V1 INTERFACE
  "LINKER:--default-script=${ARMED_V1_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${ARMED_V1_MCU}
)

add_library(ARMED_V1_serial_disabled INTERFACE)
target_compile_options(ARMED_V1_serial_disabled INTERFACE
  "SHELL:"
)
add_library(ARMED_V1_serial_generic INTERFACE)
target_compile_options(ARMED_V1_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(ARMED_V1_serial_none INTERFACE)
target_compile_options(ARMED_V1_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(ARMED_V1_usb_CDC INTERFACE)
target_compile_options(ARMED_V1_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(ARMED_V1_usb_CDCgen INTERFACE)
target_compile_options(ARMED_V1_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(ARMED_V1_usb_none INTERFACE)
target_compile_options(ARMED_V1_usb_none INTERFACE
  "SHELL:"
)
add_library(ARMED_V1_xusb_FS INTERFACE)
target_compile_options(ARMED_V1_xusb_FS INTERFACE
  "SHELL:"
)
add_library(ARMED_V1_xusb_HS INTERFACE)
target_compile_options(ARMED_V1_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(ARMED_V1_xusb_HSFS INTERFACE)
target_compile_options(ARMED_V1_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# AURORA_ONE
# -----------------------------------------------------------------------------

set(AURORA_ONE_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32G0xx/G030K(6-8)T")
set(AURORA_ONE_MAXSIZE 65536)
set(AURORA_ONE_MAXDATASIZE 8192)
set(AURORA_ONE_MCU cortex-m0plus)
set(AURORA_ONE_FPCONF "-")
add_library(AURORA_ONE INTERFACE)
target_compile_options(AURORA_ONE INTERFACE
  "SHELL:-DSTM32G030xx   -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${AURORA_ONE_MCU}
)
target_compile_definitions(AURORA_ONE INTERFACE
  "STM32G0xx"
	"ARDUINO_AURORA_ONE"
	"BOARD_NAME=\"AURORA_ONE\""
	"BOARD_ID=AURORA_ONE"
	"VARIANT_H=\"variant_AURORA_ONE.h\""
)
target_include_directories(AURORA_ONE INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32G0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32G0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32G0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32G0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32G0xx/Source/Templates/gcc/
  ${AURORA_ONE_VARIANT_PATH}
)

target_link_options(AURORA_ONE INTERFACE
  "LINKER:--default-script=${AURORA_ONE_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${AURORA_ONE_MCU}
)

add_library(AURORA_ONE_serial_disabled INTERFACE)
target_compile_options(AURORA_ONE_serial_disabled INTERFACE
  "SHELL:"
)
add_library(AURORA_ONE_serial_generic INTERFACE)
target_compile_options(AURORA_ONE_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(AURORA_ONE_serial_none INTERFACE)
target_compile_options(AURORA_ONE_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(AURORA_ONE_usb_CDC INTERFACE)
target_compile_options(AURORA_ONE_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(AURORA_ONE_usb_CDCgen INTERFACE)
target_compile_options(AURORA_ONE_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(AURORA_ONE_usb_HID INTERFACE)
target_compile_options(AURORA_ONE_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(AURORA_ONE_usb_none INTERFACE)
target_compile_options(AURORA_ONE_usb_none INTERFACE
  "SHELL:"
)

# B_G431B_ESC1
# -----------------------------------------------------------------------------

set(B_G431B_ESC1_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32G4xx/G431C(6-8-B)U_G441CBU")
set(B_G431B_ESC1_MAXSIZE 131072)
set(B_G431B_ESC1_MAXDATASIZE 32768)
set(B_G431B_ESC1_MCU cortex-m4)
set(B_G431B_ESC1_FPCONF "fpv4-sp-d16-hard")
add_library(B_G431B_ESC1 INTERFACE)
target_compile_options(B_G431B_ESC1 INTERFACE
  "SHELL:-DSTM32G431xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${B_G431B_ESC1_MCU}
)
target_compile_definitions(B_G431B_ESC1 INTERFACE
  "STM32G4xx"
	"ARDUINO_B_G431B_ESC1"
	"BOARD_NAME=\"B_G431B_ESC1\""
	"BOARD_ID=B_G431B_ESC1"
	"VARIANT_H=\"variant_B_G431B_ESC1.h\""
)
target_include_directories(B_G431B_ESC1 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32G4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32G4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32G4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32G4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32G4xx/Source/Templates/gcc/
  ${B_G431B_ESC1_VARIANT_PATH}
)

target_link_options(B_G431B_ESC1 INTERFACE
  "LINKER:--default-script=${B_G431B_ESC1_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${B_G431B_ESC1_MCU}
)

add_library(B_G431B_ESC1_serial_disabled INTERFACE)
target_compile_options(B_G431B_ESC1_serial_disabled INTERFACE
  "SHELL:"
)
add_library(B_G431B_ESC1_serial_generic INTERFACE)
target_compile_options(B_G431B_ESC1_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(B_G431B_ESC1_serial_none INTERFACE)
target_compile_options(B_G431B_ESC1_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(B_G431B_ESC1_usb_CDC INTERFACE)
target_compile_options(B_G431B_ESC1_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(B_G431B_ESC1_usb_CDCgen INTERFACE)
target_compile_options(B_G431B_ESC1_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(B_G431B_ESC1_usb_HID INTERFACE)
target_compile_options(B_G431B_ESC1_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(B_G431B_ESC1_usb_none INTERFACE)
target_compile_options(B_G431B_ESC1_usb_none INTERFACE
  "SHELL:"
)
add_library(B_G431B_ESC1_xusb_FS INTERFACE)
target_compile_options(B_G431B_ESC1_xusb_FS INTERFACE
  "SHELL:"
)
add_library(B_G431B_ESC1_xusb_HS INTERFACE)
target_compile_options(B_G431B_ESC1_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(B_G431B_ESC1_xusb_HSFS INTERFACE)
target_compile_options(B_G431B_ESC1_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# B_L072Z_LRWAN1
# -----------------------------------------------------------------------------

set(B_L072Z_LRWAN1_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32L0xx/L072CBY_L072CZ(E-Y)_L073CZY_L082CZY")
set(B_L072Z_LRWAN1_MAXSIZE 196608)
set(B_L072Z_LRWAN1_MAXDATASIZE 20480)
set(B_L072Z_LRWAN1_MCU cortex-m0plus)
set(B_L072Z_LRWAN1_FPCONF "-")
add_library(B_L072Z_LRWAN1 INTERFACE)
target_compile_options(B_L072Z_LRWAN1 INTERFACE
  "SHELL:-DSTM32L072xx   -D__CORTEX_SC=0"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL: "
  -mcpu=${B_L072Z_LRWAN1_MCU}
)
target_compile_definitions(B_L072Z_LRWAN1 INTERFACE
  "STM32L0xx"
	"ARDUINO_B_L072Z_LRWAN1"
	"BOARD_NAME=\"B_L072Z_LRWAN1\""
	"BOARD_ID=B_L072Z_LRWAN1"
	"VARIANT_H=\"variant_B_L072Z_LRWAN1.h\""
)
target_include_directories(B_L072Z_LRWAN1 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32L0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32L0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32L0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32L0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32L0xx/Source/Templates/gcc/
  ${B_L072Z_LRWAN1_VARIANT_PATH}
)

target_link_options(B_L072Z_LRWAN1 INTERFACE
  "LINKER:--default-script=${B_L072Z_LRWAN1_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=196608"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${B_L072Z_LRWAN1_MCU}
)

add_library(B_L072Z_LRWAN1_serial_disabled INTERFACE)
target_compile_options(B_L072Z_LRWAN1_serial_disabled INTERFACE
  "SHELL:"
)
add_library(B_L072Z_LRWAN1_serial_generic INTERFACE)
target_compile_options(B_L072Z_LRWAN1_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(B_L072Z_LRWAN1_serial_none INTERFACE)
target_compile_options(B_L072Z_LRWAN1_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(B_L072Z_LRWAN1_usb_CDC INTERFACE)
target_compile_options(B_L072Z_LRWAN1_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(B_L072Z_LRWAN1_usb_CDCgen INTERFACE)
target_compile_options(B_L072Z_LRWAN1_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(B_L072Z_LRWAN1_usb_HID INTERFACE)
target_compile_options(B_L072Z_LRWAN1_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(B_L072Z_LRWAN1_usb_none INTERFACE)
target_compile_options(B_L072Z_LRWAN1_usb_none INTERFACE
  "SHELL:"
)
add_library(B_L072Z_LRWAN1_xusb_FS INTERFACE)
target_compile_options(B_L072Z_LRWAN1_xusb_FS INTERFACE
  "SHELL:"
)
add_library(B_L072Z_LRWAN1_xusb_HS INTERFACE)
target_compile_options(B_L072Z_LRWAN1_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(B_L072Z_LRWAN1_xusb_HSFS INTERFACE)
target_compile_options(B_L072Z_LRWAN1_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# B_L475E_IOT01A
# -----------------------------------------------------------------------------

set(B_L475E_IOT01A_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32L4xx/L475V(C-E-G)T_L476V(C-E-G)T_L486VGT")
set(B_L475E_IOT01A_MAXSIZE 1048576)
set(B_L475E_IOT01A_MAXDATASIZE 98304)
set(B_L475E_IOT01A_MCU cortex-m4)
set(B_L475E_IOT01A_FPCONF "fpv4-sp-d16-hard")
add_library(B_L475E_IOT01A INTERFACE)
target_compile_options(B_L475E_IOT01A INTERFACE
  "SHELL:-DSTM32L475xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${B_L475E_IOT01A_MCU}
)
target_compile_definitions(B_L475E_IOT01A INTERFACE
  "STM32L4xx"
	"ARDUINO_B_L475E_IOT01A"
	"BOARD_NAME=\"B_L475E_IOT01A\""
	"BOARD_ID=B_L475E_IOT01A"
	"VARIANT_H=\"variant_B_L475E_IOT01A.h\""
)
target_include_directories(B_L475E_IOT01A INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32L4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32L4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32L4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32L4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32L4xx/Source/Templates/gcc/
  ${B_L475E_IOT01A_VARIANT_PATH}
)

target_link_options(B_L475E_IOT01A INTERFACE
  "LINKER:--default-script=${B_L475E_IOT01A_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${B_L475E_IOT01A_MCU}
)

add_library(B_L475E_IOT01A_serial_disabled INTERFACE)
target_compile_options(B_L475E_IOT01A_serial_disabled INTERFACE
  "SHELL:"
)
add_library(B_L475E_IOT01A_serial_generic INTERFACE)
target_compile_options(B_L475E_IOT01A_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(B_L475E_IOT01A_serial_none INTERFACE)
target_compile_options(B_L475E_IOT01A_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(B_L475E_IOT01A_usb_CDC INTERFACE)
target_compile_options(B_L475E_IOT01A_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(B_L475E_IOT01A_usb_CDCgen INTERFACE)
target_compile_options(B_L475E_IOT01A_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(B_L475E_IOT01A_usb_HID INTERFACE)
target_compile_options(B_L475E_IOT01A_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(B_L475E_IOT01A_usb_none INTERFACE)
target_compile_options(B_L475E_IOT01A_usb_none INTERFACE
  "SHELL:"
)
add_library(B_L475E_IOT01A_xusb_FS INTERFACE)
target_compile_options(B_L475E_IOT01A_xusb_FS INTERFACE
  "SHELL:"
)
add_library(B_L475E_IOT01A_xusb_HS INTERFACE)
target_compile_options(B_L475E_IOT01A_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(B_L475E_IOT01A_xusb_HSFS INTERFACE)
target_compile_options(B_L475E_IOT01A_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# B_L4S5I_IOT01A
# -----------------------------------------------------------------------------

set(B_L4S5I_IOT01A_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32L4xx/L4R5V(G-I)T_L4R7VIT_L4S5VIT_L4S7VIT")
set(B_L4S5I_IOT01A_MAXSIZE 2097152)
set(B_L4S5I_IOT01A_MAXDATASIZE 655360)
set(B_L4S5I_IOT01A_MCU cortex-m4)
set(B_L4S5I_IOT01A_FPCONF "fpv4-sp-d16-hard")
add_library(B_L4S5I_IOT01A INTERFACE)
target_compile_options(B_L4S5I_IOT01A INTERFACE
  "SHELL:-DSTM32L4S5xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${B_L4S5I_IOT01A_MCU}
)
target_compile_definitions(B_L4S5I_IOT01A INTERFACE
  "STM32L4xx"
	"ARDUINO_B_L4S5I_IOT01A"
	"BOARD_NAME=\"B_L4S5I_IOT01A\""
	"BOARD_ID=B_L4S5I_IOT01A"
	"VARIANT_H=\"variant_B_L4S5I_IOT01A.h\""
)
target_include_directories(B_L4S5I_IOT01A INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32L4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32L4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32L4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32L4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32L4xx/Source/Templates/gcc/
  ${B_L4S5I_IOT01A_VARIANT_PATH}
)

target_link_options(B_L4S5I_IOT01A INTERFACE
  "LINKER:--default-script=${B_L4S5I_IOT01A_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=2097152"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=655360"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${B_L4S5I_IOT01A_MCU}
)

add_library(B_L4S5I_IOT01A_serial_disabled INTERFACE)
target_compile_options(B_L4S5I_IOT01A_serial_disabled INTERFACE
  "SHELL:"
)
add_library(B_L4S5I_IOT01A_serial_generic INTERFACE)
target_compile_options(B_L4S5I_IOT01A_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(B_L4S5I_IOT01A_serial_none INTERFACE)
target_compile_options(B_L4S5I_IOT01A_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(B_L4S5I_IOT01A_usb_CDC INTERFACE)
target_compile_options(B_L4S5I_IOT01A_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(B_L4S5I_IOT01A_usb_CDCgen INTERFACE)
target_compile_options(B_L4S5I_IOT01A_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(B_L4S5I_IOT01A_usb_HID INTERFACE)
target_compile_options(B_L4S5I_IOT01A_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(B_L4S5I_IOT01A_usb_none INTERFACE)
target_compile_options(B_L4S5I_IOT01A_usb_none INTERFACE
  "SHELL:"
)
add_library(B_L4S5I_IOT01A_xusb_FS INTERFACE)
target_compile_options(B_L4S5I_IOT01A_xusb_FS INTERFACE
  "SHELL:"
)
add_library(B_L4S5I_IOT01A_xusb_HS INTERFACE)
target_compile_options(B_L4S5I_IOT01A_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(B_L4S5I_IOT01A_xusb_HSFS INTERFACE)
target_compile_options(B_L4S5I_IOT01A_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# B_U585I_IOT02A
# -----------------------------------------------------------------------------

set(B_U585I_IOT02A_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32U5xx/U575A(G-I)IxQ_U585AIIxQ")
set(B_U585I_IOT02A_MAXSIZE 2097152)
set(B_U585I_IOT02A_MAXDATASIZE 262144)
set(B_U585I_IOT02A_MCU cortex-m33)
set(B_U585I_IOT02A_FPCONF "fpv4-sp-d16-hard")
add_library(B_U585I_IOT02A INTERFACE)
target_compile_options(B_U585I_IOT02A INTERFACE
  "SHELL:-DSTM32U585xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${B_U585I_IOT02A_MCU}
)
target_compile_definitions(B_U585I_IOT02A INTERFACE
  "STM32U5xx"
	"ARDUINO_B_U585I_IOT02A"
	"BOARD_NAME=\"B_U585I_IOT02A\""
	"BOARD_ID=B_U585I_IOT02A"
	"VARIANT_H=\"variant_B_U585I_IOT02A.h\""
)
target_include_directories(B_U585I_IOT02A INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32U5xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32U5xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32U5xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32U5xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32U5xx/Source/Templates/gcc/
  ${B_U585I_IOT02A_VARIANT_PATH}
)

target_link_options(B_U585I_IOT02A INTERFACE
  "LINKER:--default-script=${B_U585I_IOT02A_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=2097152"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=262144"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${B_U585I_IOT02A_MCU}
)

add_library(B_U585I_IOT02A_serial_disabled INTERFACE)
target_compile_options(B_U585I_IOT02A_serial_disabled INTERFACE
  "SHELL:"
)
add_library(B_U585I_IOT02A_serial_generic INTERFACE)
target_compile_options(B_U585I_IOT02A_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(B_U585I_IOT02A_serial_none INTERFACE)
target_compile_options(B_U585I_IOT02A_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(B_U585I_IOT02A_usb_CDC INTERFACE)
target_compile_options(B_U585I_IOT02A_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(B_U585I_IOT02A_usb_CDCgen INTERFACE)
target_compile_options(B_U585I_IOT02A_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(B_U585I_IOT02A_usb_HID INTERFACE)
target_compile_options(B_U585I_IOT02A_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(B_U585I_IOT02A_usb_none INTERFACE)
target_compile_options(B_U585I_IOT02A_usb_none INTERFACE
  "SHELL:"
)
add_library(B_U585I_IOT02A_xusb_FS INTERFACE)
target_compile_options(B_U585I_IOT02A_xusb_FS INTERFACE
  "SHELL:"
)
add_library(B_U585I_IOT02A_xusb_HS INTERFACE)
target_compile_options(B_U585I_IOT02A_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(B_U585I_IOT02A_xusb_HSFS INTERFACE)
target_compile_options(B_U585I_IOT02A_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLACK_F407VE
# -----------------------------------------------------------------------------

set(BLACK_F407VE_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407V(E-G)T_F417V(E-G)T")
set(BLACK_F407VE_MAXSIZE 524288)
set(BLACK_F407VE_MAXDATASIZE 131072)
set(BLACK_F407VE_MCU cortex-m4)
set(BLACK_F407VE_FPCONF "-")
add_library(BLACK_F407VE INTERFACE)
target_compile_options(BLACK_F407VE INTERFACE
  "SHELL:-DSTM32F407xx   "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407VE_MCU}
)
target_compile_definitions(BLACK_F407VE INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACK_F407VE"
	"BOARD_NAME=\"BLACK_F407VE\""
	"BOARD_ID=BLACK_F407VE"
	"VARIANT_H=\"variant_BLACK_F407VX.h\""
)
target_include_directories(BLACK_F407VE INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACK_F407VE_VARIANT_PATH}
)

target_link_options(BLACK_F407VE INTERFACE
  "LINKER:--default-script=${BLACK_F407VE_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407VE_MCU}
)

add_library(BLACK_F407VE_serial_disabled INTERFACE)
target_compile_options(BLACK_F407VE_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLACK_F407VE_serial_generic INTERFACE)
target_compile_options(BLACK_F407VE_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLACK_F407VE_serial_none INTERFACE)
target_compile_options(BLACK_F407VE_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLACK_F407VE_usb_CDC INTERFACE)
target_compile_options(BLACK_F407VE_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLACK_F407VE_usb_CDCgen INTERFACE)
target_compile_options(BLACK_F407VE_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLACK_F407VE_usb_HID INTERFACE)
target_compile_options(BLACK_F407VE_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLACK_F407VE_usb_none INTERFACE)
target_compile_options(BLACK_F407VE_usb_none INTERFACE
  "SHELL:"
)
add_library(BLACK_F407VE_xusb_FS INTERFACE)
target_compile_options(BLACK_F407VE_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLACK_F407VE_xusb_HS INTERFACE)
target_compile_options(BLACK_F407VE_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLACK_F407VE_xusb_HSFS INTERFACE)
target_compile_options(BLACK_F407VE_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLACK_F407VE_hid
# -----------------------------------------------------------------------------

set(BLACK_F407VE_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407V(E-G)T_F417V(E-G)T")
set(BLACK_F407VE_hid_MAXSIZE 524288)
set(BLACK_F407VE_hid_MAXDATASIZE 131072)
set(BLACK_F407VE_hid_MCU cortex-m4)
set(BLACK_F407VE_hid_FPCONF "-")
add_library(BLACK_F407VE_hid INTERFACE)
target_compile_options(BLACK_F407VE_hid INTERFACE
  "SHELL:-DSTM32F407xx  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407VE_hid_MCU}
)
target_compile_definitions(BLACK_F407VE_hid INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACK_F407VE"
	"BOARD_NAME=\"BLACK_F407VE\""
	"BOARD_ID=BLACK_F407VE"
	"VARIANT_H=\"variant_BLACK_F407VX.h\""
)
target_include_directories(BLACK_F407VE_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACK_F407VE_hid_VARIANT_PATH}
)

target_link_options(BLACK_F407VE_hid INTERFACE
  "LINKER:--default-script=${BLACK_F407VE_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x4000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407VE_hid_MCU}
)


# BLACK_F407VG
# -----------------------------------------------------------------------------

set(BLACK_F407VG_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407V(E-G)T_F417V(E-G)T")
set(BLACK_F407VG_MAXSIZE 1048576)
set(BLACK_F407VG_MAXDATASIZE 131072)
set(BLACK_F407VG_MCU cortex-m4)
set(BLACK_F407VG_FPCONF "-")
add_library(BLACK_F407VG INTERFACE)
target_compile_options(BLACK_F407VG INTERFACE
  "SHELL:-DSTM32F407xx   "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407VG_MCU}
)
target_compile_definitions(BLACK_F407VG INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACK_F407VG"
	"BOARD_NAME=\"BLACK_F407VG\""
	"BOARD_ID=BLACK_F407VG"
	"VARIANT_H=\"variant_BLACK_F407VX.h\""
)
target_include_directories(BLACK_F407VG INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACK_F407VG_VARIANT_PATH}
)

target_link_options(BLACK_F407VG INTERFACE
  "LINKER:--default-script=${BLACK_F407VG_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407VG_MCU}
)

add_library(BLACK_F407VG_serial_disabled INTERFACE)
target_compile_options(BLACK_F407VG_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLACK_F407VG_serial_generic INTERFACE)
target_compile_options(BLACK_F407VG_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLACK_F407VG_serial_none INTERFACE)
target_compile_options(BLACK_F407VG_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLACK_F407VG_usb_CDC INTERFACE)
target_compile_options(BLACK_F407VG_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLACK_F407VG_usb_CDCgen INTERFACE)
target_compile_options(BLACK_F407VG_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLACK_F407VG_usb_HID INTERFACE)
target_compile_options(BLACK_F407VG_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLACK_F407VG_usb_none INTERFACE)
target_compile_options(BLACK_F407VG_usb_none INTERFACE
  "SHELL:"
)
add_library(BLACK_F407VG_xusb_FS INTERFACE)
target_compile_options(BLACK_F407VG_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLACK_F407VG_xusb_HS INTERFACE)
target_compile_options(BLACK_F407VG_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLACK_F407VG_xusb_HSFS INTERFACE)
target_compile_options(BLACK_F407VG_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLACK_F407VG_hid
# -----------------------------------------------------------------------------

set(BLACK_F407VG_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407V(E-G)T_F417V(E-G)T")
set(BLACK_F407VG_hid_MAXSIZE 1048576)
set(BLACK_F407VG_hid_MAXDATASIZE 131072)
set(BLACK_F407VG_hid_MCU cortex-m4)
set(BLACK_F407VG_hid_FPCONF "-")
add_library(BLACK_F407VG_hid INTERFACE)
target_compile_options(BLACK_F407VG_hid INTERFACE
  "SHELL:-DSTM32F407xx  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407VG_hid_MCU}
)
target_compile_definitions(BLACK_F407VG_hid INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACK_F407VG"
	"BOARD_NAME=\"BLACK_F407VG\""
	"BOARD_ID=BLACK_F407VG"
	"VARIANT_H=\"variant_BLACK_F407VX.h\""
)
target_include_directories(BLACK_F407VG_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACK_F407VG_hid_VARIANT_PATH}
)

target_link_options(BLACK_F407VG_hid INTERFACE
  "LINKER:--default-script=${BLACK_F407VG_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x4000"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407VG_hid_MCU}
)


# BLACK_F407ZE
# -----------------------------------------------------------------------------

set(BLACK_F407ZE_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407Z(E-G)T_F417Z(E-G)T")
set(BLACK_F407ZE_MAXSIZE 524288)
set(BLACK_F407ZE_MAXDATASIZE 131072)
set(BLACK_F407ZE_MCU cortex-m4)
set(BLACK_F407ZE_FPCONF "-")
add_library(BLACK_F407ZE INTERFACE)
target_compile_options(BLACK_F407ZE INTERFACE
  "SHELL:-DSTM32F407xx   "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407ZE_MCU}
)
target_compile_definitions(BLACK_F407ZE INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACK_F407ZE"
	"BOARD_NAME=\"BLACK_F407ZE\""
	"BOARD_ID=BLACK_F407ZE"
	"VARIANT_H=\"variant_BLACK_F407ZX.h\""
)
target_include_directories(BLACK_F407ZE INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACK_F407ZE_VARIANT_PATH}
)

target_link_options(BLACK_F407ZE INTERFACE
  "LINKER:--default-script=${BLACK_F407ZE_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407ZE_MCU}
)

add_library(BLACK_F407ZE_serial_disabled INTERFACE)
target_compile_options(BLACK_F407ZE_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLACK_F407ZE_serial_generic INTERFACE)
target_compile_options(BLACK_F407ZE_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLACK_F407ZE_serial_none INTERFACE)
target_compile_options(BLACK_F407ZE_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLACK_F407ZE_usb_CDC INTERFACE)
target_compile_options(BLACK_F407ZE_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLACK_F407ZE_usb_CDCgen INTERFACE)
target_compile_options(BLACK_F407ZE_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLACK_F407ZE_usb_HID INTERFACE)
target_compile_options(BLACK_F407ZE_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLACK_F407ZE_usb_none INTERFACE)
target_compile_options(BLACK_F407ZE_usb_none INTERFACE
  "SHELL:"
)
add_library(BLACK_F407ZE_xusb_FS INTERFACE)
target_compile_options(BLACK_F407ZE_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLACK_F407ZE_xusb_HS INTERFACE)
target_compile_options(BLACK_F407ZE_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLACK_F407ZE_xusb_HSFS INTERFACE)
target_compile_options(BLACK_F407ZE_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLACK_F407ZE_hid
# -----------------------------------------------------------------------------

set(BLACK_F407ZE_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407Z(E-G)T_F417Z(E-G)T")
set(BLACK_F407ZE_hid_MAXSIZE 524288)
set(BLACK_F407ZE_hid_MAXDATASIZE 131072)
set(BLACK_F407ZE_hid_MCU cortex-m4)
set(BLACK_F407ZE_hid_FPCONF "-")
add_library(BLACK_F407ZE_hid INTERFACE)
target_compile_options(BLACK_F407ZE_hid INTERFACE
  "SHELL:-DSTM32F407xx  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407ZE_hid_MCU}
)
target_compile_definitions(BLACK_F407ZE_hid INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACK_F407ZE"
	"BOARD_NAME=\"BLACK_F407ZE\""
	"BOARD_ID=BLACK_F407ZE"
	"VARIANT_H=\"variant_BLACK_F407ZX.h\""
)
target_include_directories(BLACK_F407ZE_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACK_F407ZE_hid_VARIANT_PATH}
)

target_link_options(BLACK_F407ZE_hid INTERFACE
  "LINKER:--default-script=${BLACK_F407ZE_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x4000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407ZE_hid_MCU}
)


# BLACK_F407ZG
# -----------------------------------------------------------------------------

set(BLACK_F407ZG_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407Z(E-G)T_F417Z(E-G)T")
set(BLACK_F407ZG_MAXSIZE 1048576)
set(BLACK_F407ZG_MAXDATASIZE 131072)
set(BLACK_F407ZG_MCU cortex-m4)
set(BLACK_F407ZG_FPCONF "-")
add_library(BLACK_F407ZG INTERFACE)
target_compile_options(BLACK_F407ZG INTERFACE
  "SHELL:-DSTM32F407xx   "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407ZG_MCU}
)
target_compile_definitions(BLACK_F407ZG INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACK_F407ZG"
	"BOARD_NAME=\"BLACK_F407ZG\""
	"BOARD_ID=BLACK_F407ZG"
	"VARIANT_H=\"variant_BLACK_F407ZX.h\""
)
target_include_directories(BLACK_F407ZG INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACK_F407ZG_VARIANT_PATH}
)

target_link_options(BLACK_F407ZG INTERFACE
  "LINKER:--default-script=${BLACK_F407ZG_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407ZG_MCU}
)

add_library(BLACK_F407ZG_serial_disabled INTERFACE)
target_compile_options(BLACK_F407ZG_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLACK_F407ZG_serial_generic INTERFACE)
target_compile_options(BLACK_F407ZG_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLACK_F407ZG_serial_none INTERFACE)
target_compile_options(BLACK_F407ZG_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLACK_F407ZG_usb_CDC INTERFACE)
target_compile_options(BLACK_F407ZG_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLACK_F407ZG_usb_CDCgen INTERFACE)
target_compile_options(BLACK_F407ZG_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLACK_F407ZG_usb_HID INTERFACE)
target_compile_options(BLACK_F407ZG_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLACK_F407ZG_usb_none INTERFACE)
target_compile_options(BLACK_F407ZG_usb_none INTERFACE
  "SHELL:"
)
add_library(BLACK_F407ZG_xusb_FS INTERFACE)
target_compile_options(BLACK_F407ZG_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLACK_F407ZG_xusb_HS INTERFACE)
target_compile_options(BLACK_F407ZG_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLACK_F407ZG_xusb_HSFS INTERFACE)
target_compile_options(BLACK_F407ZG_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLACK_F407ZG_hid
# -----------------------------------------------------------------------------

set(BLACK_F407ZG_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407Z(E-G)T_F417Z(E-G)T")
set(BLACK_F407ZG_hid_MAXSIZE 1048576)
set(BLACK_F407ZG_hid_MAXDATASIZE 131072)
set(BLACK_F407ZG_hid_MCU cortex-m4)
set(BLACK_F407ZG_hid_FPCONF "-")
add_library(BLACK_F407ZG_hid INTERFACE)
target_compile_options(BLACK_F407ZG_hid INTERFACE
  "SHELL:-DSTM32F407xx  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407ZG_hid_MCU}
)
target_compile_definitions(BLACK_F407ZG_hid INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACK_F407ZG"
	"BOARD_NAME=\"BLACK_F407ZG\""
	"BOARD_ID=BLACK_F407ZG"
	"VARIANT_H=\"variant_BLACK_F407ZX.h\""
)
target_include_directories(BLACK_F407ZG_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACK_F407ZG_hid_VARIANT_PATH}
)

target_link_options(BLACK_F407ZG_hid INTERFACE
  "LINKER:--default-script=${BLACK_F407ZG_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x4000"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACK_F407ZG_hid_MCU}
)


# BLACKPILL_F103C8
# -----------------------------------------------------------------------------

set(BLACKPILL_F103C8_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLACKPILL_F103C8_MAXSIZE 65536)
set(BLACKPILL_F103C8_MAXDATASIZE 20480)
set(BLACKPILL_F103C8_MCU cortex-m3)
set(BLACKPILL_F103C8_FPCONF "-")
add_library(BLACKPILL_F103C8 INTERFACE)
target_compile_options(BLACKPILL_F103C8 INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLACKPILL_F103C8_MCU}
)
target_compile_definitions(BLACKPILL_F103C8 INTERFACE
  "STM32F1xx"
	"ARDUINO_BLACKPILL_F103C8"
	"BOARD_NAME=\"BLACKPILL_F103C8\""
	"BOARD_ID=BLACKPILL_F103C8"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLACKPILL_F103C8 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLACKPILL_F103C8_VARIANT_PATH}
)

target_link_options(BLACKPILL_F103C8 INTERFACE
  "LINKER:--default-script=${BLACKPILL_F103C8_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLACKPILL_F103C8_MCU}
)

add_library(BLACKPILL_F103C8_serial_disabled INTERFACE)
target_compile_options(BLACKPILL_F103C8_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F103C8_serial_generic INTERFACE)
target_compile_options(BLACKPILL_F103C8_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLACKPILL_F103C8_serial_none INTERFACE)
target_compile_options(BLACKPILL_F103C8_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLACKPILL_F103C8_usb_CDC INTERFACE)
target_compile_options(BLACKPILL_F103C8_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLACKPILL_F103C8_usb_CDCgen INTERFACE)
target_compile_options(BLACKPILL_F103C8_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLACKPILL_F103C8_usb_HID INTERFACE)
target_compile_options(BLACKPILL_F103C8_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLACKPILL_F103C8_usb_none INTERFACE)
target_compile_options(BLACKPILL_F103C8_usb_none INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F103C8_xusb_FS INTERFACE)
target_compile_options(BLACKPILL_F103C8_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F103C8_xusb_HS INTERFACE)
target_compile_options(BLACKPILL_F103C8_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLACKPILL_F103C8_xusb_HSFS INTERFACE)
target_compile_options(BLACKPILL_F103C8_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLACKPILL_F103C8_dfu2
# -----------------------------------------------------------------------------

set(BLACKPILL_F103C8_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLACKPILL_F103C8_dfu2_MAXSIZE 65536)
set(BLACKPILL_F103C8_dfu2_MAXDATASIZE 20480)
set(BLACKPILL_F103C8_dfu2_MCU cortex-m3)
set(BLACKPILL_F103C8_dfu2_FPCONF "-")
add_library(BLACKPILL_F103C8_dfu2 INTERFACE)
target_compile_options(BLACKPILL_F103C8_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLACKPILL_F103C8_dfu2_MCU}
)
target_compile_definitions(BLACKPILL_F103C8_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_BLACKPILL_F103C8"
	"BOARD_NAME=\"BLACKPILL_F103C8\""
	"BOARD_ID=BLACKPILL_F103C8"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLACKPILL_F103C8_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLACKPILL_F103C8_dfu2_VARIANT_PATH}
)

target_link_options(BLACKPILL_F103C8_dfu2 INTERFACE
  "LINKER:--default-script=${BLACKPILL_F103C8_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLACKPILL_F103C8_dfu2_MCU}
)


# BLACKPILL_F103C8_dfuo
# -----------------------------------------------------------------------------

set(BLACKPILL_F103C8_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLACKPILL_F103C8_dfuo_MAXSIZE 65536)
set(BLACKPILL_F103C8_dfuo_MAXDATASIZE 20480)
set(BLACKPILL_F103C8_dfuo_MCU cortex-m3)
set(BLACKPILL_F103C8_dfuo_FPCONF "-")
add_library(BLACKPILL_F103C8_dfuo INTERFACE)
target_compile_options(BLACKPILL_F103C8_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLACKPILL_F103C8_dfuo_MCU}
)
target_compile_definitions(BLACKPILL_F103C8_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_BLACKPILL_F103C8"
	"BOARD_NAME=\"BLACKPILL_F103C8\""
	"BOARD_ID=BLACKPILL_F103C8"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLACKPILL_F103C8_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLACKPILL_F103C8_dfuo_VARIANT_PATH}
)

target_link_options(BLACKPILL_F103C8_dfuo INTERFACE
  "LINKER:--default-script=${BLACKPILL_F103C8_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLACKPILL_F103C8_dfuo_MCU}
)


# BLACKPILL_F103C8_hid
# -----------------------------------------------------------------------------

set(BLACKPILL_F103C8_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLACKPILL_F103C8_hid_MAXSIZE 65536)
set(BLACKPILL_F103C8_hid_MAXDATASIZE 20480)
set(BLACKPILL_F103C8_hid_MCU cortex-m3)
set(BLACKPILL_F103C8_hid_FPCONF "-")
add_library(BLACKPILL_F103C8_hid INTERFACE)
target_compile_options(BLACKPILL_F103C8_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLACKPILL_F103C8_hid_MCU}
)
target_compile_definitions(BLACKPILL_F103C8_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_BLACKPILL_F103C8"
	"BOARD_NAME=\"BLACKPILL_F103C8\""
	"BOARD_ID=BLACKPILL_F103C8"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLACKPILL_F103C8_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLACKPILL_F103C8_hid_VARIANT_PATH}
)

target_link_options(BLACKPILL_F103C8_hid INTERFACE
  "LINKER:--default-script=${BLACKPILL_F103C8_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLACKPILL_F103C8_hid_MCU}
)


# BLACKPILL_F103CB
# -----------------------------------------------------------------------------

set(BLACKPILL_F103CB_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLACKPILL_F103CB_MAXSIZE 131072)
set(BLACKPILL_F103CB_MAXDATASIZE 20480)
set(BLACKPILL_F103CB_MCU cortex-m3)
set(BLACKPILL_F103CB_FPCONF "-")
add_library(BLACKPILL_F103CB INTERFACE)
target_compile_options(BLACKPILL_F103CB INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLACKPILL_F103CB_MCU}
)
target_compile_definitions(BLACKPILL_F103CB INTERFACE
  "STM32F1xx"
	"ARDUINO_BLACKPILL_F103CB"
	"BOARD_NAME=\"BLACKPILL_F103CB\""
	"BOARD_ID=BLACKPILL_F103CB"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLACKPILL_F103CB INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLACKPILL_F103CB_VARIANT_PATH}
)

target_link_options(BLACKPILL_F103CB INTERFACE
  "LINKER:--default-script=${BLACKPILL_F103CB_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLACKPILL_F103CB_MCU}
)

add_library(BLACKPILL_F103CB_serial_disabled INTERFACE)
target_compile_options(BLACKPILL_F103CB_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F103CB_serial_generic INTERFACE)
target_compile_options(BLACKPILL_F103CB_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLACKPILL_F103CB_serial_none INTERFACE)
target_compile_options(BLACKPILL_F103CB_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLACKPILL_F103CB_usb_CDC INTERFACE)
target_compile_options(BLACKPILL_F103CB_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLACKPILL_F103CB_usb_CDCgen INTERFACE)
target_compile_options(BLACKPILL_F103CB_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLACKPILL_F103CB_usb_HID INTERFACE)
target_compile_options(BLACKPILL_F103CB_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLACKPILL_F103CB_usb_none INTERFACE)
target_compile_options(BLACKPILL_F103CB_usb_none INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F103CB_xusb_FS INTERFACE)
target_compile_options(BLACKPILL_F103CB_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F103CB_xusb_HS INTERFACE)
target_compile_options(BLACKPILL_F103CB_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLACKPILL_F103CB_xusb_HSFS INTERFACE)
target_compile_options(BLACKPILL_F103CB_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLACKPILL_F103CB_dfu2
# -----------------------------------------------------------------------------

set(BLACKPILL_F103CB_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLACKPILL_F103CB_dfu2_MAXSIZE 131072)
set(BLACKPILL_F103CB_dfu2_MAXDATASIZE 20480)
set(BLACKPILL_F103CB_dfu2_MCU cortex-m3)
set(BLACKPILL_F103CB_dfu2_FPCONF "-")
add_library(BLACKPILL_F103CB_dfu2 INTERFACE)
target_compile_options(BLACKPILL_F103CB_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLACKPILL_F103CB_dfu2_MCU}
)
target_compile_definitions(BLACKPILL_F103CB_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_BLACKPILL_F103CB"
	"BOARD_NAME=\"BLACKPILL_F103CB\""
	"BOARD_ID=BLACKPILL_F103CB"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLACKPILL_F103CB_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLACKPILL_F103CB_dfu2_VARIANT_PATH}
)

target_link_options(BLACKPILL_F103CB_dfu2 INTERFACE
  "LINKER:--default-script=${BLACKPILL_F103CB_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLACKPILL_F103CB_dfu2_MCU}
)


# BLACKPILL_F103CB_dfuo
# -----------------------------------------------------------------------------

set(BLACKPILL_F103CB_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLACKPILL_F103CB_dfuo_MAXSIZE 131072)
set(BLACKPILL_F103CB_dfuo_MAXDATASIZE 20480)
set(BLACKPILL_F103CB_dfuo_MCU cortex-m3)
set(BLACKPILL_F103CB_dfuo_FPCONF "-")
add_library(BLACKPILL_F103CB_dfuo INTERFACE)
target_compile_options(BLACKPILL_F103CB_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLACKPILL_F103CB_dfuo_MCU}
)
target_compile_definitions(BLACKPILL_F103CB_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_BLACKPILL_F103CB"
	"BOARD_NAME=\"BLACKPILL_F103CB\""
	"BOARD_ID=BLACKPILL_F103CB"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLACKPILL_F103CB_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLACKPILL_F103CB_dfuo_VARIANT_PATH}
)

target_link_options(BLACKPILL_F103CB_dfuo INTERFACE
  "LINKER:--default-script=${BLACKPILL_F103CB_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLACKPILL_F103CB_dfuo_MCU}
)


# BLACKPILL_F103CB_hid
# -----------------------------------------------------------------------------

set(BLACKPILL_F103CB_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLACKPILL_F103CB_hid_MAXSIZE 131072)
set(BLACKPILL_F103CB_hid_MAXDATASIZE 20480)
set(BLACKPILL_F103CB_hid_MCU cortex-m3)
set(BLACKPILL_F103CB_hid_FPCONF "-")
add_library(BLACKPILL_F103CB_hid INTERFACE)
target_compile_options(BLACKPILL_F103CB_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLACKPILL_F103CB_hid_MCU}
)
target_compile_definitions(BLACKPILL_F103CB_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_BLACKPILL_F103CB"
	"BOARD_NAME=\"BLACKPILL_F103CB\""
	"BOARD_ID=BLACKPILL_F103CB"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLACKPILL_F103CB_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLACKPILL_F103CB_hid_VARIANT_PATH}
)

target_link_options(BLACKPILL_F103CB_hid INTERFACE
  "LINKER:--default-script=${BLACKPILL_F103CB_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLACKPILL_F103CB_hid_MCU}
)


# BLACKPILL_F303CC
# -----------------------------------------------------------------------------

set(BLACKPILL_F303CC_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F3xx/F303C(B-C)T")
set(BLACKPILL_F303CC_MAXSIZE 262144)
set(BLACKPILL_F303CC_MAXDATASIZE 40960)
set(BLACKPILL_F303CC_MCU cortex-m4)
set(BLACKPILL_F303CC_FPCONF "-")
add_library(BLACKPILL_F303CC INTERFACE)
target_compile_options(BLACKPILL_F303CC INTERFACE
  "SHELL:-DSTM32F303xC   "
  "SHELL:"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F303CC_MCU}
)
target_compile_definitions(BLACKPILL_F303CC INTERFACE
  "STM32F3xx"
	"ARDUINO_BLACKPILL_F303CC"
	"BOARD_NAME=\"BLACKPILL_F303CC\""
	"BOARD_ID=BLACKPILL_F303CC"
	"VARIANT_H=\"variant_BLACKPILL_F303CC.h\""
)
target_include_directories(BLACKPILL_F303CC INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F3xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F3xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F3xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F3xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F3xx/Source/Templates/gcc/
  ${BLACKPILL_F303CC_VARIANT_PATH}
)

target_link_options(BLACKPILL_F303CC INTERFACE
  "LINKER:--default-script=${BLACKPILL_F303CC_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=40960"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F303CC_MCU}
)

add_library(BLACKPILL_F303CC_serial_disabled INTERFACE)
target_compile_options(BLACKPILL_F303CC_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F303CC_serial_generic INTERFACE)
target_compile_options(BLACKPILL_F303CC_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLACKPILL_F303CC_serial_none INTERFACE)
target_compile_options(BLACKPILL_F303CC_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLACKPILL_F303CC_usb_CDC INTERFACE)
target_compile_options(BLACKPILL_F303CC_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLACKPILL_F303CC_usb_CDCgen INTERFACE)
target_compile_options(BLACKPILL_F303CC_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLACKPILL_F303CC_usb_HID INTERFACE)
target_compile_options(BLACKPILL_F303CC_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLACKPILL_F303CC_usb_none INTERFACE)
target_compile_options(BLACKPILL_F303CC_usb_none INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F303CC_xusb_FS INTERFACE)
target_compile_options(BLACKPILL_F303CC_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F303CC_xusb_HS INTERFACE)
target_compile_options(BLACKPILL_F303CC_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLACKPILL_F303CC_xusb_HSFS INTERFACE)
target_compile_options(BLACKPILL_F303CC_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLACKPILL_F401CC
# -----------------------------------------------------------------------------

set(BLACKPILL_F401CC_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F401CC(F-U-Y)_F401C(B-D-E)(U-Y)")
set(BLACKPILL_F401CC_MAXSIZE 262144)
set(BLACKPILL_F401CC_MAXDATASIZE 65536)
set(BLACKPILL_F401CC_MCU cortex-m4)
set(BLACKPILL_F401CC_FPCONF "-")
add_library(BLACKPILL_F401CC INTERFACE)
target_compile_options(BLACKPILL_F401CC INTERFACE
  "SHELL:-DSTM32F401xC   "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F401CC_MCU}
)
target_compile_definitions(BLACKPILL_F401CC INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACKPILL_F401CC"
	"BOARD_NAME=\"BLACKPILL_F401CC\""
	"BOARD_ID=BLACKPILL_F401CC"
	"VARIANT_H=\"variant_BLACKPILL_F401Cx.h\""
)
target_include_directories(BLACKPILL_F401CC INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACKPILL_F401CC_VARIANT_PATH}
)

target_link_options(BLACKPILL_F401CC INTERFACE
  "LINKER:--default-script=${BLACKPILL_F401CC_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F401CC_MCU}
)

add_library(BLACKPILL_F401CC_serial_disabled INTERFACE)
target_compile_options(BLACKPILL_F401CC_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F401CC_serial_generic INTERFACE)
target_compile_options(BLACKPILL_F401CC_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLACKPILL_F401CC_serial_none INTERFACE)
target_compile_options(BLACKPILL_F401CC_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLACKPILL_F401CC_usb_CDC INTERFACE)
target_compile_options(BLACKPILL_F401CC_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLACKPILL_F401CC_usb_CDCgen INTERFACE)
target_compile_options(BLACKPILL_F401CC_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLACKPILL_F401CC_usb_HID INTERFACE)
target_compile_options(BLACKPILL_F401CC_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLACKPILL_F401CC_usb_none INTERFACE)
target_compile_options(BLACKPILL_F401CC_usb_none INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F401CC_xusb_FS INTERFACE)
target_compile_options(BLACKPILL_F401CC_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F401CC_xusb_HS INTERFACE)
target_compile_options(BLACKPILL_F401CC_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLACKPILL_F401CC_xusb_HSFS INTERFACE)
target_compile_options(BLACKPILL_F401CC_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLACKPILL_F401CC_hid
# -----------------------------------------------------------------------------

set(BLACKPILL_F401CC_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F401CC(F-U-Y)_F401C(B-D-E)(U-Y)")
set(BLACKPILL_F401CC_hid_MAXSIZE 262144)
set(BLACKPILL_F401CC_hid_MAXDATASIZE 65536)
set(BLACKPILL_F401CC_hid_MCU cortex-m4)
set(BLACKPILL_F401CC_hid_FPCONF "-")
add_library(BLACKPILL_F401CC_hid INTERFACE)
target_compile_options(BLACKPILL_F401CC_hid INTERFACE
  "SHELL:-DSTM32F401xC  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F401CC_hid_MCU}
)
target_compile_definitions(BLACKPILL_F401CC_hid INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACKPILL_F401CC"
	"BOARD_NAME=\"BLACKPILL_F401CC\""
	"BOARD_ID=BLACKPILL_F401CC"
	"VARIANT_H=\"variant_BLACKPILL_F401Cx.h\""
)
target_include_directories(BLACKPILL_F401CC_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACKPILL_F401CC_hid_VARIANT_PATH}
)

target_link_options(BLACKPILL_F401CC_hid INTERFACE
  "LINKER:--default-script=${BLACKPILL_F401CC_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x4000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F401CC_hid_MCU}
)


# BLACKPILL_F401CE
# -----------------------------------------------------------------------------

set(BLACKPILL_F401CE_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F401CC(F-U-Y)_F401C(B-D-E)(U-Y)")
set(BLACKPILL_F401CE_MAXSIZE 524288)
set(BLACKPILL_F401CE_MAXDATASIZE 98304)
set(BLACKPILL_F401CE_MCU cortex-m4)
set(BLACKPILL_F401CE_FPCONF "-")
add_library(BLACKPILL_F401CE INTERFACE)
target_compile_options(BLACKPILL_F401CE INTERFACE
  "SHELL:-DSTM32F401xE   "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F401CE_MCU}
)
target_compile_definitions(BLACKPILL_F401CE INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACKPILL_F401CE"
	"BOARD_NAME=\"BLACKPILL_F401CE\""
	"BOARD_ID=BLACKPILL_F401CE"
	"VARIANT_H=\"variant_BLACKPILL_F401Cx.h\""
)
target_include_directories(BLACKPILL_F401CE INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACKPILL_F401CE_VARIANT_PATH}
)

target_link_options(BLACKPILL_F401CE INTERFACE
  "LINKER:--default-script=${BLACKPILL_F401CE_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F401CE_MCU}
)

add_library(BLACKPILL_F401CE_serial_disabled INTERFACE)
target_compile_options(BLACKPILL_F401CE_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F401CE_serial_generic INTERFACE)
target_compile_options(BLACKPILL_F401CE_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLACKPILL_F401CE_serial_none INTERFACE)
target_compile_options(BLACKPILL_F401CE_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLACKPILL_F401CE_usb_CDC INTERFACE)
target_compile_options(BLACKPILL_F401CE_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLACKPILL_F401CE_usb_CDCgen INTERFACE)
target_compile_options(BLACKPILL_F401CE_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLACKPILL_F401CE_usb_HID INTERFACE)
target_compile_options(BLACKPILL_F401CE_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLACKPILL_F401CE_usb_none INTERFACE)
target_compile_options(BLACKPILL_F401CE_usb_none INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F401CE_xusb_FS INTERFACE)
target_compile_options(BLACKPILL_F401CE_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F401CE_xusb_HS INTERFACE)
target_compile_options(BLACKPILL_F401CE_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLACKPILL_F401CE_xusb_HSFS INTERFACE)
target_compile_options(BLACKPILL_F401CE_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLACKPILL_F401CE_hid
# -----------------------------------------------------------------------------

set(BLACKPILL_F401CE_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F401CC(F-U-Y)_F401C(B-D-E)(U-Y)")
set(BLACKPILL_F401CE_hid_MAXSIZE 524288)
set(BLACKPILL_F401CE_hid_MAXDATASIZE 98304)
set(BLACKPILL_F401CE_hid_MCU cortex-m4)
set(BLACKPILL_F401CE_hid_FPCONF "-")
add_library(BLACKPILL_F401CE_hid INTERFACE)
target_compile_options(BLACKPILL_F401CE_hid INTERFACE
  "SHELL:-DSTM32F401xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F401CE_hid_MCU}
)
target_compile_definitions(BLACKPILL_F401CE_hid INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACKPILL_F401CE"
	"BOARD_NAME=\"BLACKPILL_F401CE\""
	"BOARD_ID=BLACKPILL_F401CE"
	"VARIANT_H=\"variant_BLACKPILL_F401Cx.h\""
)
target_include_directories(BLACKPILL_F401CE_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACKPILL_F401CE_hid_VARIANT_PATH}
)

target_link_options(BLACKPILL_F401CE_hid INTERFACE
  "LINKER:--default-script=${BLACKPILL_F401CE_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x4000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F401CE_hid_MCU}
)


# BLACKPILL_F411CE
# -----------------------------------------------------------------------------

set(BLACKPILL_F411CE_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F411C(C-E)(U-Y)")
set(BLACKPILL_F411CE_MAXSIZE 524288)
set(BLACKPILL_F411CE_MAXDATASIZE 131072)
set(BLACKPILL_F411CE_MCU cortex-m4)
set(BLACKPILL_F411CE_FPCONF "-")
add_library(BLACKPILL_F411CE INTERFACE)
target_compile_options(BLACKPILL_F411CE INTERFACE
  "SHELL:-DSTM32F411xE   "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F411CE_MCU}
)
target_compile_definitions(BLACKPILL_F411CE INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACKPILL_F411CE"
	"BOARD_NAME=\"BLACKPILL_F411CE\""
	"BOARD_ID=BLACKPILL_F411CE"
	"VARIANT_H=\"variant_BLACKPILL_F411CE.h\""
)
target_include_directories(BLACKPILL_F411CE INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACKPILL_F411CE_VARIANT_PATH}
)

target_link_options(BLACKPILL_F411CE INTERFACE
  "LINKER:--default-script=${BLACKPILL_F411CE_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F411CE_MCU}
)

add_library(BLACKPILL_F411CE_serial_disabled INTERFACE)
target_compile_options(BLACKPILL_F411CE_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F411CE_serial_generic INTERFACE)
target_compile_options(BLACKPILL_F411CE_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLACKPILL_F411CE_serial_none INTERFACE)
target_compile_options(BLACKPILL_F411CE_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLACKPILL_F411CE_usb_CDC INTERFACE)
target_compile_options(BLACKPILL_F411CE_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLACKPILL_F411CE_usb_CDCgen INTERFACE)
target_compile_options(BLACKPILL_F411CE_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLACKPILL_F411CE_usb_HID INTERFACE)
target_compile_options(BLACKPILL_F411CE_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLACKPILL_F411CE_usb_none INTERFACE)
target_compile_options(BLACKPILL_F411CE_usb_none INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F411CE_xusb_FS INTERFACE)
target_compile_options(BLACKPILL_F411CE_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLACKPILL_F411CE_xusb_HS INTERFACE)
target_compile_options(BLACKPILL_F411CE_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLACKPILL_F411CE_xusb_HSFS INTERFACE)
target_compile_options(BLACKPILL_F411CE_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLACKPILL_F411CE_hid
# -----------------------------------------------------------------------------

set(BLACKPILL_F411CE_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F411C(C-E)(U-Y)")
set(BLACKPILL_F411CE_hid_MAXSIZE 524288)
set(BLACKPILL_F411CE_hid_MAXDATASIZE 131072)
set(BLACKPILL_F411CE_hid_MCU cortex-m4)
set(BLACKPILL_F411CE_hid_FPCONF "-")
add_library(BLACKPILL_F411CE_hid INTERFACE)
target_compile_options(BLACKPILL_F411CE_hid INTERFACE
  "SHELL:-DSTM32F411xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F411CE_hid_MCU}
)
target_compile_definitions(BLACKPILL_F411CE_hid INTERFACE
  "STM32F4xx"
	"ARDUINO_BLACKPILL_F411CE"
	"BOARD_NAME=\"BLACKPILL_F411CE\""
	"BOARD_ID=BLACKPILL_F411CE"
	"VARIANT_H=\"variant_BLACKPILL_F411CE.h\""
)
target_include_directories(BLACKPILL_F411CE_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLACKPILL_F411CE_hid_VARIANT_PATH}
)

target_link_options(BLACKPILL_F411CE_hid INTERFACE
  "LINKER:--default-script=${BLACKPILL_F411CE_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x4000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLACKPILL_F411CE_hid_MCU}
)


# BLUE_F407VE_MINI
# -----------------------------------------------------------------------------

set(BLUE_F407VE_MINI_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407V(E-G)T_F417V(E-G)T")
set(BLUE_F407VE_MINI_MAXSIZE 524288)
set(BLUE_F407VE_MINI_MAXDATASIZE 131072)
set(BLUE_F407VE_MINI_MCU cortex-m4)
set(BLUE_F407VE_MINI_FPCONF "-")
add_library(BLUE_F407VE_MINI INTERFACE)
target_compile_options(BLUE_F407VE_MINI INTERFACE
  "SHELL:-DSTM32F407xx   "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLUE_F407VE_MINI_MCU}
)
target_compile_definitions(BLUE_F407VE_MINI INTERFACE
  "STM32F4xx"
	"ARDUINO_BLUE_F407VE_MINI"
	"BOARD_NAME=\"BLUE_F407VE_MINI\""
	"BOARD_ID=BLUE_F407VE_MINI"
	"VARIANT_H=\"variant_BLUE_F407VE_MINI.h\""
)
target_include_directories(BLUE_F407VE_MINI INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLUE_F407VE_MINI_VARIANT_PATH}
)

target_link_options(BLUE_F407VE_MINI INTERFACE
  "LINKER:--default-script=${BLUE_F407VE_MINI_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLUE_F407VE_MINI_MCU}
)

add_library(BLUE_F407VE_MINI_serial_disabled INTERFACE)
target_compile_options(BLUE_F407VE_MINI_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLUE_F407VE_MINI_serial_generic INTERFACE)
target_compile_options(BLUE_F407VE_MINI_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLUE_F407VE_MINI_serial_none INTERFACE)
target_compile_options(BLUE_F407VE_MINI_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLUE_F407VE_MINI_usb_CDC INTERFACE)
target_compile_options(BLUE_F407VE_MINI_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLUE_F407VE_MINI_usb_CDCgen INTERFACE)
target_compile_options(BLUE_F407VE_MINI_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLUE_F407VE_MINI_usb_HID INTERFACE)
target_compile_options(BLUE_F407VE_MINI_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLUE_F407VE_MINI_usb_none INTERFACE)
target_compile_options(BLUE_F407VE_MINI_usb_none INTERFACE
  "SHELL:"
)
add_library(BLUE_F407VE_MINI_xusb_FS INTERFACE)
target_compile_options(BLUE_F407VE_MINI_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLUE_F407VE_MINI_xusb_HS INTERFACE)
target_compile_options(BLUE_F407VE_MINI_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLUE_F407VE_MINI_xusb_HSFS INTERFACE)
target_compile_options(BLUE_F407VE_MINI_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLUE_F407VE_MINI_hid
# -----------------------------------------------------------------------------

set(BLUE_F407VE_MINI_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407V(E-G)T_F417V(E-G)T")
set(BLUE_F407VE_MINI_hid_MAXSIZE 524288)
set(BLUE_F407VE_MINI_hid_MAXDATASIZE 131072)
set(BLUE_F407VE_MINI_hid_MCU cortex-m4)
set(BLUE_F407VE_MINI_hid_FPCONF "-")
add_library(BLUE_F407VE_MINI_hid INTERFACE)
target_compile_options(BLUE_F407VE_MINI_hid INTERFACE
  "SHELL:-DSTM32F407xx  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLUE_F407VE_MINI_hid_MCU}
)
target_compile_definitions(BLUE_F407VE_MINI_hid INTERFACE
  "STM32F4xx"
	"ARDUINO_BLUE_F407VE_MINI"
	"BOARD_NAME=\"BLUE_F407VE_MINI\""
	"BOARD_ID=BLUE_F407VE_MINI"
	"VARIANT_H=\"variant_BLUE_F407VE_MINI.h\""
)
target_include_directories(BLUE_F407VE_MINI_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${BLUE_F407VE_MINI_hid_VARIANT_PATH}
)

target_link_options(BLUE_F407VE_MINI_hid INTERFACE
  "LINKER:--default-script=${BLUE_F407VE_MINI_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x4000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${BLUE_F407VE_MINI_hid_MCU}
)


# BLUEBUTTON_F103R8T
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103R8T_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(BLUEBUTTON_F103R8T_MAXSIZE 65536)
set(BLUEBUTTON_F103R8T_MAXDATASIZE 20480)
set(BLUEBUTTON_F103R8T_MCU cortex-m3)
set(BLUEBUTTON_F103R8T_FPCONF "-")
add_library(BLUEBUTTON_F103R8T INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103R8T_MCU}
)
target_compile_definitions(BLUEBUTTON_F103R8T INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103R8T"
	"BOARD_NAME=\"BLUEBUTTON_F103R8T\""
	"BOARD_ID=BLUEBUTTON_F103R8T"
	"VARIANT_H=\"variant_BLUEBUTTON_F103R8T.h\""
)
target_include_directories(BLUEBUTTON_F103R8T INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103R8T_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103R8T INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103R8T_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103R8T_MCU}
)

add_library(BLUEBUTTON_F103R8T_serial_disabled INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLUEBUTTON_F103R8T_serial_generic INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLUEBUTTON_F103R8T_serial_none INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLUEBUTTON_F103R8T_usb_CDC INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLUEBUTTON_F103R8T_usb_CDCgen INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLUEBUTTON_F103R8T_usb_HID INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLUEBUTTON_F103R8T_usb_none INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_usb_none INTERFACE
  "SHELL:"
)
add_library(BLUEBUTTON_F103R8T_xusb_FS INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLUEBUTTON_F103R8T_xusb_HS INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLUEBUTTON_F103R8T_xusb_HSFS INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLUEBUTTON_F103R8T_dfu2
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103R8T_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(BLUEBUTTON_F103R8T_dfu2_MAXSIZE 65536)
set(BLUEBUTTON_F103R8T_dfu2_MAXDATASIZE 20480)
set(BLUEBUTTON_F103R8T_dfu2_MCU cortex-m3)
set(BLUEBUTTON_F103R8T_dfu2_FPCONF "-")
add_library(BLUEBUTTON_F103R8T_dfu2 INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103R8T_dfu2_MCU}
)
target_compile_definitions(BLUEBUTTON_F103R8T_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103R8T"
	"BOARD_NAME=\"BLUEBUTTON_F103R8T\""
	"BOARD_ID=BLUEBUTTON_F103R8T"
	"VARIANT_H=\"variant_BLUEBUTTON_F103R8T.h\""
)
target_include_directories(BLUEBUTTON_F103R8T_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103R8T_dfu2_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103R8T_dfu2 INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103R8T_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103R8T_dfu2_MCU}
)


# BLUEBUTTON_F103R8T_dfuo
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103R8T_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(BLUEBUTTON_F103R8T_dfuo_MAXSIZE 65536)
set(BLUEBUTTON_F103R8T_dfuo_MAXDATASIZE 20480)
set(BLUEBUTTON_F103R8T_dfuo_MCU cortex-m3)
set(BLUEBUTTON_F103R8T_dfuo_FPCONF "-")
add_library(BLUEBUTTON_F103R8T_dfuo INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103R8T_dfuo_MCU}
)
target_compile_definitions(BLUEBUTTON_F103R8T_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103R8T"
	"BOARD_NAME=\"BLUEBUTTON_F103R8T\""
	"BOARD_ID=BLUEBUTTON_F103R8T"
	"VARIANT_H=\"variant_BLUEBUTTON_F103R8T.h\""
)
target_include_directories(BLUEBUTTON_F103R8T_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103R8T_dfuo_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103R8T_dfuo INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103R8T_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103R8T_dfuo_MCU}
)


# BLUEBUTTON_F103R8T_hid
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103R8T_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(BLUEBUTTON_F103R8T_hid_MAXSIZE 65536)
set(BLUEBUTTON_F103R8T_hid_MAXDATASIZE 20480)
set(BLUEBUTTON_F103R8T_hid_MCU cortex-m3)
set(BLUEBUTTON_F103R8T_hid_FPCONF "-")
add_library(BLUEBUTTON_F103R8T_hid INTERFACE)
target_compile_options(BLUEBUTTON_F103R8T_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103R8T_hid_MCU}
)
target_compile_definitions(BLUEBUTTON_F103R8T_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103R8T"
	"BOARD_NAME=\"BLUEBUTTON_F103R8T\""
	"BOARD_ID=BLUEBUTTON_F103R8T"
	"VARIANT_H=\"variant_BLUEBUTTON_F103R8T.h\""
)
target_include_directories(BLUEBUTTON_F103R8T_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103R8T_hid_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103R8T_hid INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103R8T_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103R8T_hid_MCU}
)


# BLUEBUTTON_F103RBT
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103RBT_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(BLUEBUTTON_F103RBT_MAXSIZE 131072)
set(BLUEBUTTON_F103RBT_MAXDATASIZE 20480)
set(BLUEBUTTON_F103RBT_MCU cortex-m3)
set(BLUEBUTTON_F103RBT_FPCONF "-")
add_library(BLUEBUTTON_F103RBT INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RBT_MCU}
)
target_compile_definitions(BLUEBUTTON_F103RBT INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103RBT"
	"BOARD_NAME=\"BLUEBUTTON_F103RBT\""
	"BOARD_ID=BLUEBUTTON_F103RBT"
	"VARIANT_H=\"variant_BLUEBUTTON_F103RBT.h\""
)
target_include_directories(BLUEBUTTON_F103RBT INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103RBT_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103RBT INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103RBT_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RBT_MCU}
)

add_library(BLUEBUTTON_F103RBT_serial_disabled INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLUEBUTTON_F103RBT_serial_generic INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLUEBUTTON_F103RBT_serial_none INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLUEBUTTON_F103RBT_usb_CDC INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLUEBUTTON_F103RBT_usb_CDCgen INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLUEBUTTON_F103RBT_usb_HID INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLUEBUTTON_F103RBT_usb_none INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_usb_none INTERFACE
  "SHELL:"
)
add_library(BLUEBUTTON_F103RBT_xusb_FS INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLUEBUTTON_F103RBT_xusb_HS INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLUEBUTTON_F103RBT_xusb_HSFS INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLUEBUTTON_F103RBT_dfu2
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103RBT_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(BLUEBUTTON_F103RBT_dfu2_MAXSIZE 131072)
set(BLUEBUTTON_F103RBT_dfu2_MAXDATASIZE 20480)
set(BLUEBUTTON_F103RBT_dfu2_MCU cortex-m3)
set(BLUEBUTTON_F103RBT_dfu2_FPCONF "-")
add_library(BLUEBUTTON_F103RBT_dfu2 INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RBT_dfu2_MCU}
)
target_compile_definitions(BLUEBUTTON_F103RBT_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103RBT"
	"BOARD_NAME=\"BLUEBUTTON_F103RBT\""
	"BOARD_ID=BLUEBUTTON_F103RBT"
	"VARIANT_H=\"variant_BLUEBUTTON_F103RBT.h\""
)
target_include_directories(BLUEBUTTON_F103RBT_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103RBT_dfu2_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103RBT_dfu2 INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103RBT_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RBT_dfu2_MCU}
)


# BLUEBUTTON_F103RBT_dfuo
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103RBT_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(BLUEBUTTON_F103RBT_dfuo_MAXSIZE 131072)
set(BLUEBUTTON_F103RBT_dfuo_MAXDATASIZE 20480)
set(BLUEBUTTON_F103RBT_dfuo_MCU cortex-m3)
set(BLUEBUTTON_F103RBT_dfuo_FPCONF "-")
add_library(BLUEBUTTON_F103RBT_dfuo INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RBT_dfuo_MCU}
)
target_compile_definitions(BLUEBUTTON_F103RBT_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103RBT"
	"BOARD_NAME=\"BLUEBUTTON_F103RBT\""
	"BOARD_ID=BLUEBUTTON_F103RBT"
	"VARIANT_H=\"variant_BLUEBUTTON_F103RBT.h\""
)
target_include_directories(BLUEBUTTON_F103RBT_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103RBT_dfuo_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103RBT_dfuo INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103RBT_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RBT_dfuo_MCU}
)


# BLUEBUTTON_F103RBT_hid
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103RBT_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(BLUEBUTTON_F103RBT_hid_MAXSIZE 131072)
set(BLUEBUTTON_F103RBT_hid_MAXDATASIZE 20480)
set(BLUEBUTTON_F103RBT_hid_MCU cortex-m3)
set(BLUEBUTTON_F103RBT_hid_FPCONF "-")
add_library(BLUEBUTTON_F103RBT_hid INTERFACE)
target_compile_options(BLUEBUTTON_F103RBT_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RBT_hid_MCU}
)
target_compile_definitions(BLUEBUTTON_F103RBT_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103RBT"
	"BOARD_NAME=\"BLUEBUTTON_F103RBT\""
	"BOARD_ID=BLUEBUTTON_F103RBT"
	"VARIANT_H=\"variant_BLUEBUTTON_F103RBT.h\""
)
target_include_directories(BLUEBUTTON_F103RBT_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103RBT_hid_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103RBT_hid INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103RBT_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RBT_hid_MCU}
)


# BLUEBUTTON_F103RCT
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103RCT_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(BLUEBUTTON_F103RCT_MAXSIZE 262144)
set(BLUEBUTTON_F103RCT_MAXDATASIZE 49152)
set(BLUEBUTTON_F103RCT_MCU cortex-m3)
set(BLUEBUTTON_F103RCT_FPCONF "-")
add_library(BLUEBUTTON_F103RCT INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RCT_MCU}
)
target_compile_definitions(BLUEBUTTON_F103RCT INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103RCT"
	"BOARD_NAME=\"BLUEBUTTON_F103RCT\""
	"BOARD_ID=BLUEBUTTON_F103RCT"
	"VARIANT_H=\"variant_BLUEBUTTON_F103RCT.h\""
)
target_include_directories(BLUEBUTTON_F103RCT INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103RCT_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103RCT INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103RCT_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RCT_MCU}
)

add_library(BLUEBUTTON_F103RCT_serial_disabled INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLUEBUTTON_F103RCT_serial_generic INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLUEBUTTON_F103RCT_serial_none INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLUEBUTTON_F103RCT_usb_CDC INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLUEBUTTON_F103RCT_usb_CDCgen INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLUEBUTTON_F103RCT_usb_HID INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLUEBUTTON_F103RCT_usb_none INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_usb_none INTERFACE
  "SHELL:"
)
add_library(BLUEBUTTON_F103RCT_xusb_FS INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLUEBUTTON_F103RCT_xusb_HS INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLUEBUTTON_F103RCT_xusb_HSFS INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLUEBUTTON_F103RCT_dfu2
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103RCT_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(BLUEBUTTON_F103RCT_dfu2_MAXSIZE 262144)
set(BLUEBUTTON_F103RCT_dfu2_MAXDATASIZE 49152)
set(BLUEBUTTON_F103RCT_dfu2_MCU cortex-m3)
set(BLUEBUTTON_F103RCT_dfu2_FPCONF "-")
add_library(BLUEBUTTON_F103RCT_dfu2 INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RCT_dfu2_MCU}
)
target_compile_definitions(BLUEBUTTON_F103RCT_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103RCT"
	"BOARD_NAME=\"BLUEBUTTON_F103RCT\""
	"BOARD_ID=BLUEBUTTON_F103RCT"
	"VARIANT_H=\"variant_BLUEBUTTON_F103RCT.h\""
)
target_include_directories(BLUEBUTTON_F103RCT_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103RCT_dfu2_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103RCT_dfu2 INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103RCT_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RCT_dfu2_MCU}
)


# BLUEBUTTON_F103RCT_dfuo
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103RCT_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(BLUEBUTTON_F103RCT_dfuo_MAXSIZE 262144)
set(BLUEBUTTON_F103RCT_dfuo_MAXDATASIZE 49152)
set(BLUEBUTTON_F103RCT_dfuo_MCU cortex-m3)
set(BLUEBUTTON_F103RCT_dfuo_FPCONF "-")
add_library(BLUEBUTTON_F103RCT_dfuo INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RCT_dfuo_MCU}
)
target_compile_definitions(BLUEBUTTON_F103RCT_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103RCT"
	"BOARD_NAME=\"BLUEBUTTON_F103RCT\""
	"BOARD_ID=BLUEBUTTON_F103RCT"
	"VARIANT_H=\"variant_BLUEBUTTON_F103RCT.h\""
)
target_include_directories(BLUEBUTTON_F103RCT_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103RCT_dfuo_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103RCT_dfuo INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103RCT_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RCT_dfuo_MCU}
)


# BLUEBUTTON_F103RCT_hid
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103RCT_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(BLUEBUTTON_F103RCT_hid_MAXSIZE 262144)
set(BLUEBUTTON_F103RCT_hid_MAXDATASIZE 49152)
set(BLUEBUTTON_F103RCT_hid_MCU cortex-m3)
set(BLUEBUTTON_F103RCT_hid_FPCONF "-")
add_library(BLUEBUTTON_F103RCT_hid INTERFACE)
target_compile_options(BLUEBUTTON_F103RCT_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RCT_hid_MCU}
)
target_compile_definitions(BLUEBUTTON_F103RCT_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103RCT"
	"BOARD_NAME=\"BLUEBUTTON_F103RCT\""
	"BOARD_ID=BLUEBUTTON_F103RCT"
	"VARIANT_H=\"variant_BLUEBUTTON_F103RCT.h\""
)
target_include_directories(BLUEBUTTON_F103RCT_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103RCT_hid_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103RCT_hid INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103RCT_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RCT_hid_MCU}
)


# BLUEBUTTON_F103RET
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103RET_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(BLUEBUTTON_F103RET_MAXSIZE 524288)
set(BLUEBUTTON_F103RET_MAXDATASIZE 65536)
set(BLUEBUTTON_F103RET_MCU cortex-m3)
set(BLUEBUTTON_F103RET_FPCONF "-")
add_library(BLUEBUTTON_F103RET INTERFACE)
target_compile_options(BLUEBUTTON_F103RET INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RET_MCU}
)
target_compile_definitions(BLUEBUTTON_F103RET INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103RET"
	"BOARD_NAME=\"BLUEBUTTON_F103RET\""
	"BOARD_ID=BLUEBUTTON_F103RET"
	"VARIANT_H=\"variant_BLUEBUTTON_F103RET.h\""
)
target_include_directories(BLUEBUTTON_F103RET INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103RET_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103RET INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103RET_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RET_MCU}
)

add_library(BLUEBUTTON_F103RET_serial_disabled INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLUEBUTTON_F103RET_serial_generic INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLUEBUTTON_F103RET_serial_none INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLUEBUTTON_F103RET_usb_CDC INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLUEBUTTON_F103RET_usb_CDCgen INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLUEBUTTON_F103RET_usb_HID INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLUEBUTTON_F103RET_usb_none INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_usb_none INTERFACE
  "SHELL:"
)
add_library(BLUEBUTTON_F103RET_xusb_FS INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLUEBUTTON_F103RET_xusb_HS INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLUEBUTTON_F103RET_xusb_HSFS INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLUEBUTTON_F103RET_dfu2
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103RET_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(BLUEBUTTON_F103RET_dfu2_MAXSIZE 524288)
set(BLUEBUTTON_F103RET_dfu2_MAXDATASIZE 65536)
set(BLUEBUTTON_F103RET_dfu2_MCU cortex-m3)
set(BLUEBUTTON_F103RET_dfu2_FPCONF "-")
add_library(BLUEBUTTON_F103RET_dfu2 INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RET_dfu2_MCU}
)
target_compile_definitions(BLUEBUTTON_F103RET_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103RET"
	"BOARD_NAME=\"BLUEBUTTON_F103RET\""
	"BOARD_ID=BLUEBUTTON_F103RET"
	"VARIANT_H=\"variant_BLUEBUTTON_F103RET.h\""
)
target_include_directories(BLUEBUTTON_F103RET_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103RET_dfu2_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103RET_dfu2 INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103RET_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RET_dfu2_MCU}
)


# BLUEBUTTON_F103RET_dfuo
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103RET_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(BLUEBUTTON_F103RET_dfuo_MAXSIZE 524288)
set(BLUEBUTTON_F103RET_dfuo_MAXDATASIZE 65536)
set(BLUEBUTTON_F103RET_dfuo_MCU cortex-m3)
set(BLUEBUTTON_F103RET_dfuo_FPCONF "-")
add_library(BLUEBUTTON_F103RET_dfuo INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RET_dfuo_MCU}
)
target_compile_definitions(BLUEBUTTON_F103RET_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103RET"
	"BOARD_NAME=\"BLUEBUTTON_F103RET\""
	"BOARD_ID=BLUEBUTTON_F103RET"
	"VARIANT_H=\"variant_BLUEBUTTON_F103RET.h\""
)
target_include_directories(BLUEBUTTON_F103RET_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103RET_dfuo_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103RET_dfuo INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103RET_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RET_dfuo_MCU}
)


# BLUEBUTTON_F103RET_hid
# -----------------------------------------------------------------------------

set(BLUEBUTTON_F103RET_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(BLUEBUTTON_F103RET_hid_MAXSIZE 524288)
set(BLUEBUTTON_F103RET_hid_MAXDATASIZE 65536)
set(BLUEBUTTON_F103RET_hid_MCU cortex-m3)
set(BLUEBUTTON_F103RET_hid_FPCONF "-")
add_library(BLUEBUTTON_F103RET_hid INTERFACE)
target_compile_options(BLUEBUTTON_F103RET_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RET_hid_MCU}
)
target_compile_definitions(BLUEBUTTON_F103RET_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEBUTTON_F103RET"
	"BOARD_NAME=\"BLUEBUTTON_F103RET\""
	"BOARD_ID=BLUEBUTTON_F103RET"
	"VARIANT_H=\"variant_BLUEBUTTON_F103RET.h\""
)
target_include_directories(BLUEBUTTON_F103RET_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEBUTTON_F103RET_hid_VARIANT_PATH}
)

target_link_options(BLUEBUTTON_F103RET_hid INTERFACE
  "LINKER:--default-script=${BLUEBUTTON_F103RET_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${BLUEBUTTON_F103RET_hid_MCU}
)


# BLUEPILL_F103C6
# -----------------------------------------------------------------------------

set(BLUEPILL_F103C6_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(BLUEPILL_F103C6_MAXSIZE 32768)
set(BLUEPILL_F103C6_MAXDATASIZE 10240)
set(BLUEPILL_F103C6_MCU cortex-m3)
set(BLUEPILL_F103C6_FPCONF "-")
add_library(BLUEPILL_F103C6 INTERFACE)
target_compile_options(BLUEPILL_F103C6 INTERFACE
  "SHELL:-DSTM32F103x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C6_MCU}
)
target_compile_definitions(BLUEPILL_F103C6 INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEPILL_F103C6"
	"BOARD_NAME=\"BLUEPILL_F103C6\""
	"BOARD_ID=BLUEPILL_F103C6"
	"VARIANT_H=\"variant_BLUEPILL_F103C6.h\""
)
target_include_directories(BLUEPILL_F103C6 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEPILL_F103C6_VARIANT_PATH}
)

target_link_options(BLUEPILL_F103C6 INTERFACE
  "LINKER:--default-script=${BLUEPILL_F103C6_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C6_MCU}
)

add_library(BLUEPILL_F103C6_serial_disabled INTERFACE)
target_compile_options(BLUEPILL_F103C6_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLUEPILL_F103C6_serial_generic INTERFACE)
target_compile_options(BLUEPILL_F103C6_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLUEPILL_F103C6_serial_none INTERFACE)
target_compile_options(BLUEPILL_F103C6_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLUEPILL_F103C6_usb_CDC INTERFACE)
target_compile_options(BLUEPILL_F103C6_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLUEPILL_F103C6_usb_CDCgen INTERFACE)
target_compile_options(BLUEPILL_F103C6_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLUEPILL_F103C6_usb_HID INTERFACE)
target_compile_options(BLUEPILL_F103C6_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLUEPILL_F103C6_usb_none INTERFACE)
target_compile_options(BLUEPILL_F103C6_usb_none INTERFACE
  "SHELL:"
)
add_library(BLUEPILL_F103C6_xusb_FS INTERFACE)
target_compile_options(BLUEPILL_F103C6_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLUEPILL_F103C6_xusb_HS INTERFACE)
target_compile_options(BLUEPILL_F103C6_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLUEPILL_F103C6_xusb_HSFS INTERFACE)
target_compile_options(BLUEPILL_F103C6_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLUEPILL_F103C6_dfu2
# -----------------------------------------------------------------------------

set(BLUEPILL_F103C6_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(BLUEPILL_F103C6_dfu2_MAXSIZE 32768)
set(BLUEPILL_F103C6_dfu2_MAXDATASIZE 10240)
set(BLUEPILL_F103C6_dfu2_MCU cortex-m3)
set(BLUEPILL_F103C6_dfu2_FPCONF "-")
add_library(BLUEPILL_F103C6_dfu2 INTERFACE)
target_compile_options(BLUEPILL_F103C6_dfu2 INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C6_dfu2_MCU}
)
target_compile_definitions(BLUEPILL_F103C6_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEPILL_F103C6"
	"BOARD_NAME=\"BLUEPILL_F103C6\""
	"BOARD_ID=BLUEPILL_F103C6"
	"VARIANT_H=\"variant_BLUEPILL_F103C6.h\""
)
target_include_directories(BLUEPILL_F103C6_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEPILL_F103C6_dfu2_VARIANT_PATH}
)

target_link_options(BLUEPILL_F103C6_dfu2 INTERFACE
  "LINKER:--default-script=${BLUEPILL_F103C6_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C6_dfu2_MCU}
)


# BLUEPILL_F103C6_dfuo
# -----------------------------------------------------------------------------

set(BLUEPILL_F103C6_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(BLUEPILL_F103C6_dfuo_MAXSIZE 32768)
set(BLUEPILL_F103C6_dfuo_MAXDATASIZE 10240)
set(BLUEPILL_F103C6_dfuo_MCU cortex-m3)
set(BLUEPILL_F103C6_dfuo_FPCONF "-")
add_library(BLUEPILL_F103C6_dfuo INTERFACE)
target_compile_options(BLUEPILL_F103C6_dfuo INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C6_dfuo_MCU}
)
target_compile_definitions(BLUEPILL_F103C6_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEPILL_F103C6"
	"BOARD_NAME=\"BLUEPILL_F103C6\""
	"BOARD_ID=BLUEPILL_F103C6"
	"VARIANT_H=\"variant_BLUEPILL_F103C6.h\""
)
target_include_directories(BLUEPILL_F103C6_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEPILL_F103C6_dfuo_VARIANT_PATH}
)

target_link_options(BLUEPILL_F103C6_dfuo INTERFACE
  "LINKER:--default-script=${BLUEPILL_F103C6_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C6_dfuo_MCU}
)


# BLUEPILL_F103C6_hid
# -----------------------------------------------------------------------------

set(BLUEPILL_F103C6_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(BLUEPILL_F103C6_hid_MAXSIZE 32768)
set(BLUEPILL_F103C6_hid_MAXDATASIZE 10240)
set(BLUEPILL_F103C6_hid_MCU cortex-m3)
set(BLUEPILL_F103C6_hid_FPCONF "-")
add_library(BLUEPILL_F103C6_hid INTERFACE)
target_compile_options(BLUEPILL_F103C6_hid INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C6_hid_MCU}
)
target_compile_definitions(BLUEPILL_F103C6_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEPILL_F103C6"
	"BOARD_NAME=\"BLUEPILL_F103C6\""
	"BOARD_ID=BLUEPILL_F103C6"
	"VARIANT_H=\"variant_BLUEPILL_F103C6.h\""
)
target_include_directories(BLUEPILL_F103C6_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEPILL_F103C6_hid_VARIANT_PATH}
)

target_link_options(BLUEPILL_F103C6_hid INTERFACE
  "LINKER:--default-script=${BLUEPILL_F103C6_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C6_hid_MCU}
)


# BLUEPILL_F103C8
# -----------------------------------------------------------------------------

set(BLUEPILL_F103C8_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLUEPILL_F103C8_MAXSIZE 65536)
set(BLUEPILL_F103C8_MAXDATASIZE 20480)
set(BLUEPILL_F103C8_MCU cortex-m3)
set(BLUEPILL_F103C8_FPCONF "-")
add_library(BLUEPILL_F103C8 INTERFACE)
target_compile_options(BLUEPILL_F103C8 INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C8_MCU}
)
target_compile_definitions(BLUEPILL_F103C8 INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEPILL_F103C8"
	"BOARD_NAME=\"BLUEPILL_F103C8\""
	"BOARD_ID=BLUEPILL_F103C8"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLUEPILL_F103C8 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEPILL_F103C8_VARIANT_PATH}
)

target_link_options(BLUEPILL_F103C8 INTERFACE
  "LINKER:--default-script=${BLUEPILL_F103C8_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C8_MCU}
)

add_library(BLUEPILL_F103C8_serial_disabled INTERFACE)
target_compile_options(BLUEPILL_F103C8_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLUEPILL_F103C8_serial_generic INTERFACE)
target_compile_options(BLUEPILL_F103C8_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLUEPILL_F103C8_serial_none INTERFACE)
target_compile_options(BLUEPILL_F103C8_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLUEPILL_F103C8_usb_CDC INTERFACE)
target_compile_options(BLUEPILL_F103C8_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLUEPILL_F103C8_usb_CDCgen INTERFACE)
target_compile_options(BLUEPILL_F103C8_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLUEPILL_F103C8_usb_HID INTERFACE)
target_compile_options(BLUEPILL_F103C8_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLUEPILL_F103C8_usb_none INTERFACE)
target_compile_options(BLUEPILL_F103C8_usb_none INTERFACE
  "SHELL:"
)
add_library(BLUEPILL_F103C8_xusb_FS INTERFACE)
target_compile_options(BLUEPILL_F103C8_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLUEPILL_F103C8_xusb_HS INTERFACE)
target_compile_options(BLUEPILL_F103C8_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLUEPILL_F103C8_xusb_HSFS INTERFACE)
target_compile_options(BLUEPILL_F103C8_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLUEPILL_F103C8_dfu2
# -----------------------------------------------------------------------------

set(BLUEPILL_F103C8_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLUEPILL_F103C8_dfu2_MAXSIZE 65536)
set(BLUEPILL_F103C8_dfu2_MAXDATASIZE 20480)
set(BLUEPILL_F103C8_dfu2_MCU cortex-m3)
set(BLUEPILL_F103C8_dfu2_FPCONF "-")
add_library(BLUEPILL_F103C8_dfu2 INTERFACE)
target_compile_options(BLUEPILL_F103C8_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C8_dfu2_MCU}
)
target_compile_definitions(BLUEPILL_F103C8_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEPILL_F103C8"
	"BOARD_NAME=\"BLUEPILL_F103C8\""
	"BOARD_ID=BLUEPILL_F103C8"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLUEPILL_F103C8_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEPILL_F103C8_dfu2_VARIANT_PATH}
)

target_link_options(BLUEPILL_F103C8_dfu2 INTERFACE
  "LINKER:--default-script=${BLUEPILL_F103C8_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C8_dfu2_MCU}
)


# BLUEPILL_F103C8_dfuo
# -----------------------------------------------------------------------------

set(BLUEPILL_F103C8_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLUEPILL_F103C8_dfuo_MAXSIZE 65536)
set(BLUEPILL_F103C8_dfuo_MAXDATASIZE 20480)
set(BLUEPILL_F103C8_dfuo_MCU cortex-m3)
set(BLUEPILL_F103C8_dfuo_FPCONF "-")
add_library(BLUEPILL_F103C8_dfuo INTERFACE)
target_compile_options(BLUEPILL_F103C8_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C8_dfuo_MCU}
)
target_compile_definitions(BLUEPILL_F103C8_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEPILL_F103C8"
	"BOARD_NAME=\"BLUEPILL_F103C8\""
	"BOARD_ID=BLUEPILL_F103C8"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLUEPILL_F103C8_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEPILL_F103C8_dfuo_VARIANT_PATH}
)

target_link_options(BLUEPILL_F103C8_dfuo INTERFACE
  "LINKER:--default-script=${BLUEPILL_F103C8_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C8_dfuo_MCU}
)


# BLUEPILL_F103C8_hid
# -----------------------------------------------------------------------------

set(BLUEPILL_F103C8_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLUEPILL_F103C8_hid_MAXSIZE 65536)
set(BLUEPILL_F103C8_hid_MAXDATASIZE 20480)
set(BLUEPILL_F103C8_hid_MCU cortex-m3)
set(BLUEPILL_F103C8_hid_FPCONF "-")
add_library(BLUEPILL_F103C8_hid INTERFACE)
target_compile_options(BLUEPILL_F103C8_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C8_hid_MCU}
)
target_compile_definitions(BLUEPILL_F103C8_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEPILL_F103C8"
	"BOARD_NAME=\"BLUEPILL_F103C8\""
	"BOARD_ID=BLUEPILL_F103C8"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLUEPILL_F103C8_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEPILL_F103C8_hid_VARIANT_PATH}
)

target_link_options(BLUEPILL_F103C8_hid INTERFACE
  "LINKER:--default-script=${BLUEPILL_F103C8_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEPILL_F103C8_hid_MCU}
)


# BLUEPILL_F103CB
# -----------------------------------------------------------------------------

set(BLUEPILL_F103CB_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLUEPILL_F103CB_MAXSIZE 131072)
set(BLUEPILL_F103CB_MAXDATASIZE 20480)
set(BLUEPILL_F103CB_MCU cortex-m3)
set(BLUEPILL_F103CB_FPCONF "-")
add_library(BLUEPILL_F103CB INTERFACE)
target_compile_options(BLUEPILL_F103CB INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEPILL_F103CB_MCU}
)
target_compile_definitions(BLUEPILL_F103CB INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEPILL_F103CB"
	"BOARD_NAME=\"BLUEPILL_F103CB\""
	"BOARD_ID=BLUEPILL_F103CB"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLUEPILL_F103CB INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEPILL_F103CB_VARIANT_PATH}
)

target_link_options(BLUEPILL_F103CB INTERFACE
  "LINKER:--default-script=${BLUEPILL_F103CB_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEPILL_F103CB_MCU}
)

add_library(BLUEPILL_F103CB_serial_disabled INTERFACE)
target_compile_options(BLUEPILL_F103CB_serial_disabled INTERFACE
  "SHELL:"
)
add_library(BLUEPILL_F103CB_serial_generic INTERFACE)
target_compile_options(BLUEPILL_F103CB_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(BLUEPILL_F103CB_serial_none INTERFACE)
target_compile_options(BLUEPILL_F103CB_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(BLUEPILL_F103CB_usb_CDC INTERFACE)
target_compile_options(BLUEPILL_F103CB_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(BLUEPILL_F103CB_usb_CDCgen INTERFACE)
target_compile_options(BLUEPILL_F103CB_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(BLUEPILL_F103CB_usb_HID INTERFACE)
target_compile_options(BLUEPILL_F103CB_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(BLUEPILL_F103CB_usb_none INTERFACE)
target_compile_options(BLUEPILL_F103CB_usb_none INTERFACE
  "SHELL:"
)
add_library(BLUEPILL_F103CB_xusb_FS INTERFACE)
target_compile_options(BLUEPILL_F103CB_xusb_FS INTERFACE
  "SHELL:"
)
add_library(BLUEPILL_F103CB_xusb_HS INTERFACE)
target_compile_options(BLUEPILL_F103CB_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(BLUEPILL_F103CB_xusb_HSFS INTERFACE)
target_compile_options(BLUEPILL_F103CB_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# BLUEPILL_F103CB_dfu2
# -----------------------------------------------------------------------------

set(BLUEPILL_F103CB_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLUEPILL_F103CB_dfu2_MAXSIZE 131072)
set(BLUEPILL_F103CB_dfu2_MAXDATASIZE 20480)
set(BLUEPILL_F103CB_dfu2_MCU cortex-m3)
set(BLUEPILL_F103CB_dfu2_FPCONF "-")
add_library(BLUEPILL_F103CB_dfu2 INTERFACE)
target_compile_options(BLUEPILL_F103CB_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEPILL_F103CB_dfu2_MCU}
)
target_compile_definitions(BLUEPILL_F103CB_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEPILL_F103CB"
	"BOARD_NAME=\"BLUEPILL_F103CB\""
	"BOARD_ID=BLUEPILL_F103CB"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLUEPILL_F103CB_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEPILL_F103CB_dfu2_VARIANT_PATH}
)

target_link_options(BLUEPILL_F103CB_dfu2 INTERFACE
  "LINKER:--default-script=${BLUEPILL_F103CB_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEPILL_F103CB_dfu2_MCU}
)


# BLUEPILL_F103CB_dfuo
# -----------------------------------------------------------------------------

set(BLUEPILL_F103CB_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLUEPILL_F103CB_dfuo_MAXSIZE 131072)
set(BLUEPILL_F103CB_dfuo_MAXDATASIZE 20480)
set(BLUEPILL_F103CB_dfuo_MCU cortex-m3)
set(BLUEPILL_F103CB_dfuo_FPCONF "-")
add_library(BLUEPILL_F103CB_dfuo INTERFACE)
target_compile_options(BLUEPILL_F103CB_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEPILL_F103CB_dfuo_MCU}
)
target_compile_definitions(BLUEPILL_F103CB_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEPILL_F103CB"
	"BOARD_NAME=\"BLUEPILL_F103CB\""
	"BOARD_ID=BLUEPILL_F103CB"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLUEPILL_F103CB_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEPILL_F103CB_dfuo_VARIANT_PATH}
)

target_link_options(BLUEPILL_F103CB_dfuo INTERFACE
  "LINKER:--default-script=${BLUEPILL_F103CB_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEPILL_F103CB_dfuo_MCU}
)


# BLUEPILL_F103CB_hid
# -----------------------------------------------------------------------------

set(BLUEPILL_F103CB_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(BLUEPILL_F103CB_hid_MAXSIZE 131072)
set(BLUEPILL_F103CB_hid_MAXDATASIZE 20480)
set(BLUEPILL_F103CB_hid_MCU cortex-m3)
set(BLUEPILL_F103CB_hid_FPCONF "-")
add_library(BLUEPILL_F103CB_hid INTERFACE)
target_compile_options(BLUEPILL_F103CB_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${BLUEPILL_F103CB_hid_MCU}
)
target_compile_definitions(BLUEPILL_F103CB_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_BLUEPILL_F103CB"
	"BOARD_NAME=\"BLUEPILL_F103CB\""
	"BOARD_ID=BLUEPILL_F103CB"
	"VARIANT_H=\"variant_PILL_F103Cx.h\""
)
target_include_directories(BLUEPILL_F103CB_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${BLUEPILL_F103CB_hid_VARIANT_PATH}
)

target_link_options(BLUEPILL_F103CB_hid INTERFACE
  "LINKER:--default-script=${BLUEPILL_F103CB_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${BLUEPILL_F103CB_hid_MCU}
)


# CoreBoard_F401RC
# -----------------------------------------------------------------------------

set(CoreBoard_F401RC_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F401R(B-C-D-E)T")
set(CoreBoard_F401RC_MAXSIZE 262144)
set(CoreBoard_F401RC_MAXDATASIZE 65536)
set(CoreBoard_F401RC_MCU cortex-m4)
set(CoreBoard_F401RC_FPCONF "-")
add_library(CoreBoard_F401RC INTERFACE)
target_compile_options(CoreBoard_F401RC INTERFACE
  "SHELL:-DSTM32F401xC   "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${CoreBoard_F401RC_MCU}
)
target_compile_definitions(CoreBoard_F401RC INTERFACE
  "STM32F4xx"
	"ARDUINO_CoreBoard_F401RC"
	"BOARD_NAME=\"CoreBoard_F401RC\""
	"BOARD_ID=CoreBoard_F401RC"
	"VARIANT_H=\"variant_CoreBoard_F401RC.h\""
)
target_include_directories(CoreBoard_F401RC INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${CoreBoard_F401RC_VARIANT_PATH}
)

target_link_options(CoreBoard_F401RC INTERFACE
  "LINKER:--default-script=${CoreBoard_F401RC_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${CoreBoard_F401RC_MCU}
)

add_library(CoreBoard_F401RC_serial_disabled INTERFACE)
target_compile_options(CoreBoard_F401RC_serial_disabled INTERFACE
  "SHELL:"
)
add_library(CoreBoard_F401RC_serial_generic INTERFACE)
target_compile_options(CoreBoard_F401RC_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(CoreBoard_F401RC_serial_none INTERFACE)
target_compile_options(CoreBoard_F401RC_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(CoreBoard_F401RC_usb_CDC INTERFACE)
target_compile_options(CoreBoard_F401RC_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(CoreBoard_F401RC_usb_CDCgen INTERFACE)
target_compile_options(CoreBoard_F401RC_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(CoreBoard_F401RC_usb_HID INTERFACE)
target_compile_options(CoreBoard_F401RC_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(CoreBoard_F401RC_usb_none INTERFACE)
target_compile_options(CoreBoard_F401RC_usb_none INTERFACE
  "SHELL:"
)
add_library(CoreBoard_F401RC_xusb_FS INTERFACE)
target_compile_options(CoreBoard_F401RC_xusb_FS INTERFACE
  "SHELL:"
)
add_library(CoreBoard_F401RC_xusb_HS INTERFACE)
target_compile_options(CoreBoard_F401RC_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(CoreBoard_F401RC_xusb_HSFS INTERFACE)
target_compile_options(CoreBoard_F401RC_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# CoreBoard_F401RC_hid
# -----------------------------------------------------------------------------

set(CoreBoard_F401RC_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F401R(B-C-D-E)T")
set(CoreBoard_F401RC_hid_MAXSIZE 262144)
set(CoreBoard_F401RC_hid_MAXDATASIZE 65536)
set(CoreBoard_F401RC_hid_MCU cortex-m4)
set(CoreBoard_F401RC_hid_FPCONF "-")
add_library(CoreBoard_F401RC_hid INTERFACE)
target_compile_options(CoreBoard_F401RC_hid INTERFACE
  "SHELL:-DSTM32F401xC  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${CoreBoard_F401RC_hid_MCU}
)
target_compile_definitions(CoreBoard_F401RC_hid INTERFACE
  "STM32F4xx"
	"ARDUINO_CoreBoard_F401RC"
	"BOARD_NAME=\"CoreBoard_F401RC\""
	"BOARD_ID=CoreBoard_F401RC"
	"VARIANT_H=\"variant_CoreBoard_F401RC.h\""
)
target_include_directories(CoreBoard_F401RC_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${CoreBoard_F401RC_hid_VARIANT_PATH}
)

target_link_options(CoreBoard_F401RC_hid INTERFACE
  "LINKER:--default-script=${CoreBoard_F401RC_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x4000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${CoreBoard_F401RC_hid_MCU}
)


# DAISY_PATCH_SM
# -----------------------------------------------------------------------------

set(DAISY_PATCH_SM_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32H7xx/H742I(G-I)(K-T)_H743I(G-I)(K-T)_H750IB(K-T)_H753II(K-T)")
set(DAISY_PATCH_SM_MAXSIZE 131072)
set(DAISY_PATCH_SM_MAXDATASIZE 524288)
set(DAISY_PATCH_SM_MCU cortex-m7)
set(DAISY_PATCH_SM_FPCONF "-")
add_library(DAISY_PATCH_SM INTERFACE)
target_compile_options(DAISY_PATCH_SM INTERFACE
  "SHELL:-DCORE_CM7 -DSTM32H750xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DAISY_PATCH_SM_MCU}
)
target_compile_definitions(DAISY_PATCH_SM INTERFACE
  "STM32H7xx"
	"ARDUINO_DAISY_PATCH_SM"
	"BOARD_NAME=\"DAISY_PATCH_SM\""
	"BOARD_ID=DAISY_PATCH_SM"
	"VARIANT_H=\"variant_DAISY_PATCH_SM.h\""
)
target_include_directories(DAISY_PATCH_SM INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32H7xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32H7xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32H7xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32H7xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32H7xx/Source/Templates/gcc/
  ${DAISY_PATCH_SM_VARIANT_PATH}
)

target_link_options(DAISY_PATCH_SM INTERFACE
  "LINKER:--default-script=${DAISY_PATCH_SM_VARIANT_PATH}/DAISY_SEED.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=524288"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DAISY_PATCH_SM_MCU}
)

add_library(DAISY_PATCH_SM_serial_disabled INTERFACE)
target_compile_options(DAISY_PATCH_SM_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DAISY_PATCH_SM_serial_generic INTERFACE)
target_compile_options(DAISY_PATCH_SM_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DAISY_PATCH_SM_serial_none INTERFACE)
target_compile_options(DAISY_PATCH_SM_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DAISY_PATCH_SM_usb_CDC INTERFACE)
target_compile_options(DAISY_PATCH_SM_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DAISY_PATCH_SM_usb_CDCgen INTERFACE)
target_compile_options(DAISY_PATCH_SM_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DAISY_PATCH_SM_usb_HID INTERFACE)
target_compile_options(DAISY_PATCH_SM_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DAISY_PATCH_SM_usb_none INTERFACE)
target_compile_options(DAISY_PATCH_SM_usb_none INTERFACE
  "SHELL:"
)
add_library(DAISY_PATCH_SM_xusb_FS INTERFACE)
target_compile_options(DAISY_PATCH_SM_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DAISY_PATCH_SM_xusb_HS INTERFACE)
target_compile_options(DAISY_PATCH_SM_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DAISY_PATCH_SM_xusb_HSFS INTERFACE)
target_compile_options(DAISY_PATCH_SM_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DAISY_PETAL_SM
# -----------------------------------------------------------------------------

set(DAISY_PETAL_SM_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32H7xx/H742I(G-I)(K-T)_H743I(G-I)(K-T)_H750IB(K-T)_H753II(K-T)")
set(DAISY_PETAL_SM_MAXSIZE 131072)
set(DAISY_PETAL_SM_MAXDATASIZE 524288)
set(DAISY_PETAL_SM_MCU cortex-m7)
set(DAISY_PETAL_SM_FPCONF "-")
add_library(DAISY_PETAL_SM INTERFACE)
target_compile_options(DAISY_PETAL_SM INTERFACE
  "SHELL:-DCORE_CM7 -DSTM32H750xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DAISY_PETAL_SM_MCU}
)
target_compile_definitions(DAISY_PETAL_SM INTERFACE
  "STM32H7xx"
	"ARDUINO_DAISY_PETAL_SM"
	"BOARD_NAME=\"DAISY_PETAL_SM\""
	"BOARD_ID=DAISY_PETAL_SM"
	"VARIANT_H=\"variant_DAISY_PETAL_SM.h\""
)
target_include_directories(DAISY_PETAL_SM INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32H7xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32H7xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32H7xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32H7xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32H7xx/Source/Templates/gcc/
  ${DAISY_PETAL_SM_VARIANT_PATH}
)

target_link_options(DAISY_PETAL_SM INTERFACE
  "LINKER:--default-script=${DAISY_PETAL_SM_VARIANT_PATH}/DAISY_SEED.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=524288"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DAISY_PETAL_SM_MCU}
)

add_library(DAISY_PETAL_SM_serial_disabled INTERFACE)
target_compile_options(DAISY_PETAL_SM_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DAISY_PETAL_SM_serial_generic INTERFACE)
target_compile_options(DAISY_PETAL_SM_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DAISY_PETAL_SM_serial_none INTERFACE)
target_compile_options(DAISY_PETAL_SM_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DAISY_PETAL_SM_usb_CDC INTERFACE)
target_compile_options(DAISY_PETAL_SM_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DAISY_PETAL_SM_usb_CDCgen INTERFACE)
target_compile_options(DAISY_PETAL_SM_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DAISY_PETAL_SM_usb_HID INTERFACE)
target_compile_options(DAISY_PETAL_SM_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DAISY_PETAL_SM_usb_none INTERFACE)
target_compile_options(DAISY_PETAL_SM_usb_none INTERFACE
  "SHELL:"
)
add_library(DAISY_PETAL_SM_xusb_FS INTERFACE)
target_compile_options(DAISY_PETAL_SM_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DAISY_PETAL_SM_xusb_HS INTERFACE)
target_compile_options(DAISY_PETAL_SM_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DAISY_PETAL_SM_xusb_HSFS INTERFACE)
target_compile_options(DAISY_PETAL_SM_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DAISY_SEED
# -----------------------------------------------------------------------------

set(DAISY_SEED_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32H7xx/H742I(G-I)(K-T)_H743I(G-I)(K-T)_H750IB(K-T)_H753II(K-T)")
set(DAISY_SEED_MAXSIZE 131072)
set(DAISY_SEED_MAXDATASIZE 524288)
set(DAISY_SEED_MCU cortex-m7)
set(DAISY_SEED_FPCONF "-")
add_library(DAISY_SEED INTERFACE)
target_compile_options(DAISY_SEED INTERFACE
  "SHELL:-DCORE_CM7 -DSTM32H750xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DAISY_SEED_MCU}
)
target_compile_definitions(DAISY_SEED INTERFACE
  "STM32H7xx"
	"ARDUINO_DAISY_SEED"
	"BOARD_NAME=\"DAISY_SEED\""
	"BOARD_ID=DAISY_SEED"
	"VARIANT_H=\"variant_DAISY_SEED.h\""
)
target_include_directories(DAISY_SEED INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32H7xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32H7xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32H7xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32H7xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32H7xx/Source/Templates/gcc/
  ${DAISY_SEED_VARIANT_PATH}
)

target_link_options(DAISY_SEED INTERFACE
  "LINKER:--default-script=${DAISY_SEED_VARIANT_PATH}/DAISY_SEED.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=524288"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DAISY_SEED_MCU}
)

add_library(DAISY_SEED_serial_disabled INTERFACE)
target_compile_options(DAISY_SEED_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DAISY_SEED_serial_generic INTERFACE)
target_compile_options(DAISY_SEED_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DAISY_SEED_serial_none INTERFACE)
target_compile_options(DAISY_SEED_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DAISY_SEED_usb_CDC INTERFACE)
target_compile_options(DAISY_SEED_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DAISY_SEED_usb_CDCgen INTERFACE)
target_compile_options(DAISY_SEED_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DAISY_SEED_usb_HID INTERFACE)
target_compile_options(DAISY_SEED_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DAISY_SEED_usb_none INTERFACE)
target_compile_options(DAISY_SEED_usb_none INTERFACE
  "SHELL:"
)
add_library(DAISY_SEED_xusb_FS INTERFACE)
target_compile_options(DAISY_SEED_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DAISY_SEED_xusb_HS INTERFACE)
target_compile_options(DAISY_SEED_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DAISY_SEED_xusb_HSFS INTERFACE)
target_compile_options(DAISY_SEED_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DEMO_F030F4
# -----------------------------------------------------------------------------

set(DEMO_F030F4_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F030F4P")
set(DEMO_F030F4_MAXSIZE 16384)
set(DEMO_F030F4_MAXDATASIZE 4096)
set(DEMO_F030F4_MCU cortex-m0)
set(DEMO_F030F4_FPCONF "-")
add_library(DEMO_F030F4 INTERFACE)
target_compile_options(DEMO_F030F4 INTERFACE
  "SHELL:-DSTM32F030x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${DEMO_F030F4_MCU}
)
target_compile_definitions(DEMO_F030F4 INTERFACE
  "STM32F0xx"
	"ARDUINO_DEMO_F030F4"
	"BOARD_NAME=\"DEMO_F030F4\""
	"BOARD_ID=DEMO_F030F4"
	"VARIANT_H=\"variant_DEMO_F030F4.h\""
)
target_include_directories(DEMO_F030F4 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${DEMO_F030F4_VARIANT_PATH}
)

target_link_options(DEMO_F030F4 INTERFACE
  "LINKER:--default-script=${DEMO_F030F4_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${DEMO_F030F4_MCU}
)

add_library(DEMO_F030F4_serial_disabled INTERFACE)
target_compile_options(DEMO_F030F4_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DEMO_F030F4_serial_generic INTERFACE)
target_compile_options(DEMO_F030F4_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DEMO_F030F4_serial_none INTERFACE)
target_compile_options(DEMO_F030F4_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DEMO_F030F4_usb_CDC INTERFACE)
target_compile_options(DEMO_F030F4_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DEMO_F030F4_usb_CDCgen INTERFACE)
target_compile_options(DEMO_F030F4_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DEMO_F030F4_usb_HID INTERFACE)
target_compile_options(DEMO_F030F4_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DEMO_F030F4_usb_none INTERFACE)
target_compile_options(DEMO_F030F4_usb_none INTERFACE
  "SHELL:"
)

# DEMO_F030F4_16M
# -----------------------------------------------------------------------------

set(DEMO_F030F4_16M_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F030F4P")
set(DEMO_F030F4_16M_MAXSIZE 16384)
set(DEMO_F030F4_16M_MAXDATASIZE 4096)
set(DEMO_F030F4_16M_MCU cortex-m0)
set(DEMO_F030F4_16M_FPCONF "-")
add_library(DEMO_F030F4_16M INTERFACE)
target_compile_options(DEMO_F030F4_16M INTERFACE
  "SHELL:-DSTM32F030x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${DEMO_F030F4_16M_MCU}
)
target_compile_definitions(DEMO_F030F4_16M INTERFACE
  "STM32F0xx"
	"ARDUINO_DEMO_F030F4_16M"
	"BOARD_NAME=\"DEMO_F030F4_16M\""
	"BOARD_ID=DEMO_F030F4_16M"
	"VARIANT_H=\"variant_DEMO_F030F4.h\""
)
target_include_directories(DEMO_F030F4_16M INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${DEMO_F030F4_16M_VARIANT_PATH}
)

target_link_options(DEMO_F030F4_16M INTERFACE
  "LINKER:--default-script=${DEMO_F030F4_16M_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${DEMO_F030F4_16M_MCU}
)

add_library(DEMO_F030F4_16M_serial_disabled INTERFACE)
target_compile_options(DEMO_F030F4_16M_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DEMO_F030F4_16M_serial_generic INTERFACE)
target_compile_options(DEMO_F030F4_16M_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DEMO_F030F4_16M_serial_none INTERFACE)
target_compile_options(DEMO_F030F4_16M_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DEMO_F030F4_16M_usb_CDC INTERFACE)
target_compile_options(DEMO_F030F4_16M_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DEMO_F030F4_16M_usb_CDCgen INTERFACE)
target_compile_options(DEMO_F030F4_16M_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DEMO_F030F4_16M_usb_HID INTERFACE)
target_compile_options(DEMO_F030F4_16M_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DEMO_F030F4_16M_usb_none INTERFACE)
target_compile_options(DEMO_F030F4_16M_usb_none INTERFACE
  "SHELL:"
)

# DEMO_F030F4_HSI
# -----------------------------------------------------------------------------

set(DEMO_F030F4_HSI_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F030F4P")
set(DEMO_F030F4_HSI_MAXSIZE 16384)
set(DEMO_F030F4_HSI_MAXDATASIZE 4096)
set(DEMO_F030F4_HSI_MCU cortex-m0)
set(DEMO_F030F4_HSI_FPCONF "-")
add_library(DEMO_F030F4_HSI INTERFACE)
target_compile_options(DEMO_F030F4_HSI INTERFACE
  "SHELL:-DSTM32F030x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${DEMO_F030F4_HSI_MCU}
)
target_compile_definitions(DEMO_F030F4_HSI INTERFACE
  "STM32F0xx"
	"ARDUINO_DEMO_F030F4_HSI"
	"BOARD_NAME=\"DEMO_F030F4_HSI\""
	"BOARD_ID=DEMO_F030F4_HSI"
	"VARIANT_H=\"variant_DEMO_F030F4.h\""
)
target_include_directories(DEMO_F030F4_HSI INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${DEMO_F030F4_HSI_VARIANT_PATH}
)

target_link_options(DEMO_F030F4_HSI INTERFACE
  "LINKER:--default-script=${DEMO_F030F4_HSI_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${DEMO_F030F4_HSI_MCU}
)

add_library(DEMO_F030F4_HSI_serial_disabled INTERFACE)
target_compile_options(DEMO_F030F4_HSI_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DEMO_F030F4_HSI_serial_generic INTERFACE)
target_compile_options(DEMO_F030F4_HSI_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DEMO_F030F4_HSI_serial_none INTERFACE)
target_compile_options(DEMO_F030F4_HSI_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DEMO_F030F4_HSI_usb_CDC INTERFACE)
target_compile_options(DEMO_F030F4_HSI_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DEMO_F030F4_HSI_usb_CDCgen INTERFACE)
target_compile_options(DEMO_F030F4_HSI_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DEMO_F030F4_HSI_usb_HID INTERFACE)
target_compile_options(DEMO_F030F4_HSI_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DEMO_F030F4_HSI_usb_none INTERFACE)
target_compile_options(DEMO_F030F4_HSI_usb_none INTERFACE
  "SHELL:"
)

# DevEBoxH743VITX
# -----------------------------------------------------------------------------

set(DevEBoxH743VITX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32H7xx/H742V(G-I)(H-T)_H743V(G-I)(H-T)_H750VBT_H753VI(H-T)")
set(DevEBoxH743VITX_MAXSIZE 2097152)
set(DevEBoxH743VITX_MAXDATASIZE 524288)
set(DevEBoxH743VITX_MCU cortex-m7)
set(DevEBoxH743VITX_FPCONF "-")
add_library(DevEBoxH743VITX INTERFACE)
target_compile_options(DevEBoxH743VITX INTERFACE
  "SHELL:-DCORE_CM7 -DSTM32H743xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DevEBoxH743VITX_MCU}
)
target_compile_definitions(DevEBoxH743VITX INTERFACE
  "STM32H7xx"
	"ARDUINO_DevEBoxH743VITX"
	"BOARD_NAME=\"DevEBoxH743VITX\""
	"BOARD_ID=DevEBoxH743VITX"
	"VARIANT_H=\"variant_DevEBoxH7xx.h\""
)
target_include_directories(DevEBoxH743VITX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32H7xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32H7xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32H7xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32H7xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32H7xx/Source/Templates/gcc/
  ${DevEBoxH743VITX_VARIANT_PATH}
)

target_link_options(DevEBoxH743VITX INTERFACE
  "LINKER:--default-script=${DevEBoxH743VITX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=2097152"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=524288"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DevEBoxH743VITX_MCU}
)

add_library(DevEBoxH743VITX_serial_disabled INTERFACE)
target_compile_options(DevEBoxH743VITX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DevEBoxH743VITX_serial_generic INTERFACE)
target_compile_options(DevEBoxH743VITX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DevEBoxH743VITX_serial_none INTERFACE)
target_compile_options(DevEBoxH743VITX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DevEBoxH743VITX_usb_CDC INTERFACE)
target_compile_options(DevEBoxH743VITX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DevEBoxH743VITX_usb_CDCgen INTERFACE)
target_compile_options(DevEBoxH743VITX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DevEBoxH743VITX_usb_HID INTERFACE)
target_compile_options(DevEBoxH743VITX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DevEBoxH743VITX_usb_none INTERFACE)
target_compile_options(DevEBoxH743VITX_usb_none INTERFACE
  "SHELL:"
)
add_library(DevEBoxH743VITX_xusb_FS INTERFACE)
target_compile_options(DevEBoxH743VITX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DevEBoxH743VITX_xusb_HS INTERFACE)
target_compile_options(DevEBoxH743VITX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DevEBoxH743VITX_xusb_HSFS INTERFACE)
target_compile_options(DevEBoxH743VITX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DevEBoxH750VBTX
# -----------------------------------------------------------------------------

set(DevEBoxH750VBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32H7xx/H742V(G-I)(H-T)_H743V(G-I)(H-T)_H750VBT_H753VI(H-T)")
set(DevEBoxH750VBTX_MAXSIZE 131072)
set(DevEBoxH750VBTX_MAXDATASIZE 524288)
set(DevEBoxH750VBTX_MCU cortex-m7)
set(DevEBoxH750VBTX_FPCONF "-")
add_library(DevEBoxH750VBTX INTERFACE)
target_compile_options(DevEBoxH750VBTX INTERFACE
  "SHELL:-DCORE_CM7 -DSTM32H750xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DevEBoxH750VBTX_MCU}
)
target_compile_definitions(DevEBoxH750VBTX INTERFACE
  "STM32H7xx"
	"ARDUINO_DevEBoxH750VBTX"
	"BOARD_NAME=\"DevEBoxH750VBTX\""
	"BOARD_ID=DevEBoxH750VBTX"
	"VARIANT_H=\"variant_DevEBoxH7xx.h\""
)
target_include_directories(DevEBoxH750VBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32H7xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32H7xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32H7xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32H7xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32H7xx/Source/Templates/gcc/
  ${DevEBoxH750VBTX_VARIANT_PATH}
)

target_link_options(DevEBoxH750VBTX INTERFACE
  "LINKER:--default-script=${DevEBoxH750VBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=524288"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DevEBoxH750VBTX_MCU}
)

add_library(DevEBoxH750VBTX_serial_disabled INTERFACE)
target_compile_options(DevEBoxH750VBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DevEBoxH750VBTX_serial_generic INTERFACE)
target_compile_options(DevEBoxH750VBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DevEBoxH750VBTX_serial_none INTERFACE)
target_compile_options(DevEBoxH750VBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DevEBoxH750VBTX_usb_CDC INTERFACE)
target_compile_options(DevEBoxH750VBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DevEBoxH750VBTX_usb_CDCgen INTERFACE)
target_compile_options(DevEBoxH750VBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DevEBoxH750VBTX_usb_HID INTERFACE)
target_compile_options(DevEBoxH750VBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DevEBoxH750VBTX_usb_none INTERFACE)
target_compile_options(DevEBoxH750VBTX_usb_none INTERFACE
  "SHELL:"
)
add_library(DevEBoxH750VBTX_xusb_FS INTERFACE)
target_compile_options(DevEBoxH750VBTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DevEBoxH750VBTX_xusb_HS INTERFACE)
target_compile_options(DevEBoxH750VBTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DevEBoxH750VBTX_xusb_HSFS INTERFACE)
target_compile_options(DevEBoxH750VBTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DEVKIT_IOT_CONTINUUM
# -----------------------------------------------------------------------------

set(DEVKIT_IOT_CONTINUUM_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32U5xx/U575C(G-I)(T-U)_U585CI(T-U)")
set(DEVKIT_IOT_CONTINUUM_MAXSIZE 2097152)
set(DEVKIT_IOT_CONTINUUM_MAXDATASIZE 786432)
set(DEVKIT_IOT_CONTINUUM_MCU cortex-m33)
set(DEVKIT_IOT_CONTINUUM_FPCONF "fpv4-sp-d16-hard")
add_library(DEVKIT_IOT_CONTINUUM INTERFACE)
target_compile_options(DEVKIT_IOT_CONTINUUM INTERFACE
  "SHELL:-DSTM32U585xx "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DEVKIT_IOT_CONTINUUM_MCU}
)
target_compile_definitions(DEVKIT_IOT_CONTINUUM INTERFACE
  "STM32U5xx"
	"ARDUINO_DEVKIT_IOT_CONTINUUM"
	"BOARD_NAME=\"DEVKIT_IOT_CONTINUUM\""
	"BOARD_ID=DEVKIT_IOT_CONTINUUM"
	"VARIANT_H=\"variant_DEVKIT_IOT_CONTINUUM.h\""
)
target_include_directories(DEVKIT_IOT_CONTINUUM INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32U5xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32U5xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32U5xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32U5xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32U5xx/Source/Templates/gcc/
  ${DEVKIT_IOT_CONTINUUM_VARIANT_PATH}
)

target_link_options(DEVKIT_IOT_CONTINUUM INTERFACE
  "LINKER:--default-script=${DEVKIT_IOT_CONTINUUM_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=2097152"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=786432"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DEVKIT_IOT_CONTINUUM_MCU}
)

add_library(DEVKIT_IOT_CONTINUUM_serial_disabled INTERFACE)
target_compile_options(DEVKIT_IOT_CONTINUUM_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DEVKIT_IOT_CONTINUUM_serial_generic INTERFACE)
target_compile_options(DEVKIT_IOT_CONTINUUM_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DEVKIT_IOT_CONTINUUM_serial_none INTERFACE)
target_compile_options(DEVKIT_IOT_CONTINUUM_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# DISCO_F030R8
# -----------------------------------------------------------------------------

set(DISCO_F030R8_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F030R8T")
set(DISCO_F030R8_MAXSIZE 65536)
set(DISCO_F030R8_MAXDATASIZE 8192)
set(DISCO_F030R8_MCU cortex-m0)
set(DISCO_F030R8_FPCONF "-")
add_library(DISCO_F030R8 INTERFACE)
target_compile_options(DISCO_F030R8 INTERFACE
  "SHELL:-DSTM32F030x8  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${DISCO_F030R8_MCU}
)
target_compile_definitions(DISCO_F030R8 INTERFACE
  "STM32F0xx"
	"ARDUINO_DISCO_F030R8"
	"BOARD_NAME=\"DISCO_F030R8\""
	"BOARD_ID=DISCO_F030R8"
	"VARIANT_H=\"variant_DISCO_F030R8.h\""
)
target_include_directories(DISCO_F030R8 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${DISCO_F030R8_VARIANT_PATH}
)

target_link_options(DISCO_F030R8 INTERFACE
  "LINKER:--default-script=${DISCO_F030R8_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${DISCO_F030R8_MCU}
)

add_library(DISCO_F030R8_serial_disabled INTERFACE)
target_compile_options(DISCO_F030R8_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DISCO_F030R8_serial_generic INTERFACE)
target_compile_options(DISCO_F030R8_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DISCO_F030R8_serial_none INTERFACE)
target_compile_options(DISCO_F030R8_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DISCO_F030R8_usb_CDC INTERFACE)
target_compile_options(DISCO_F030R8_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DISCO_F030R8_usb_CDCgen INTERFACE)
target_compile_options(DISCO_F030R8_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DISCO_F030R8_usb_HID INTERFACE)
target_compile_options(DISCO_F030R8_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DISCO_F030R8_usb_none INTERFACE)
target_compile_options(DISCO_F030R8_usb_none INTERFACE
  "SHELL:"
)
add_library(DISCO_F030R8_xusb_FS INTERFACE)
target_compile_options(DISCO_F030R8_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DISCO_F030R8_xusb_HS INTERFACE)
target_compile_options(DISCO_F030R8_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DISCO_F030R8_xusb_HSFS INTERFACE)
target_compile_options(DISCO_F030R8_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DISCO_F072RB
# -----------------------------------------------------------------------------

set(DISCO_F072RB_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072R8T_F072RB(H-I-T)")
set(DISCO_F072RB_MAXSIZE 131072)
set(DISCO_F072RB_MAXDATASIZE 16384)
set(DISCO_F072RB_MCU cortex-m0)
set(DISCO_F072RB_FPCONF "-")
add_library(DISCO_F072RB INTERFACE)
target_compile_options(DISCO_F072RB INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${DISCO_F072RB_MCU}
)
target_compile_definitions(DISCO_F072RB INTERFACE
  "STM32F0xx"
	"ARDUINO_DISCO_F072RB"
	"BOARD_NAME=\"DISCO_F072RB\""
	"BOARD_ID=DISCO_F072RB"
	"VARIANT_H=\"variant_DISCO_F072RB.h\""
)
target_include_directories(DISCO_F072RB INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${DISCO_F072RB_VARIANT_PATH}
)

target_link_options(DISCO_F072RB INTERFACE
  "LINKER:--default-script=${DISCO_F072RB_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${DISCO_F072RB_MCU}
)

add_library(DISCO_F072RB_serial_disabled INTERFACE)
target_compile_options(DISCO_F072RB_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DISCO_F072RB_serial_generic INTERFACE)
target_compile_options(DISCO_F072RB_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DISCO_F072RB_serial_none INTERFACE)
target_compile_options(DISCO_F072RB_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DISCO_F072RB_usb_CDC INTERFACE)
target_compile_options(DISCO_F072RB_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DISCO_F072RB_usb_CDCgen INTERFACE)
target_compile_options(DISCO_F072RB_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DISCO_F072RB_usb_HID INTERFACE)
target_compile_options(DISCO_F072RB_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DISCO_F072RB_usb_none INTERFACE)
target_compile_options(DISCO_F072RB_usb_none INTERFACE
  "SHELL:"
)
add_library(DISCO_F072RB_xusb_FS INTERFACE)
target_compile_options(DISCO_F072RB_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DISCO_F072RB_xusb_HS INTERFACE)
target_compile_options(DISCO_F072RB_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DISCO_F072RB_xusb_HSFS INTERFACE)
target_compile_options(DISCO_F072RB_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DISCO_F100RB
# -----------------------------------------------------------------------------

set(DISCO_F100RB_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(8-B)T")
set(DISCO_F100RB_MAXSIZE 131071)
set(DISCO_F100RB_MAXDATASIZE 8192)
set(DISCO_F100RB_MCU cortex-m3)
set(DISCO_F100RB_FPCONF "-")
add_library(DISCO_F100RB INTERFACE)
target_compile_options(DISCO_F100RB INTERFACE
  "SHELL:-DSTM32F100xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${DISCO_F100RB_MCU}
)
target_compile_definitions(DISCO_F100RB INTERFACE
  "STM32F1xx"
	"ARDUINO_DISCO_F100RB"
	"BOARD_NAME=\"DISCO_F100RB\""
	"BOARD_ID=DISCO_F100RB"
	"VARIANT_H=\"variant_DISCO_F100RB.h\""
)
target_include_directories(DISCO_F100RB INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${DISCO_F100RB_VARIANT_PATH}
)

target_link_options(DISCO_F100RB INTERFACE
  "LINKER:--default-script=${DISCO_F100RB_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131071"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${DISCO_F100RB_MCU}
)

add_library(DISCO_F100RB_serial_disabled INTERFACE)
target_compile_options(DISCO_F100RB_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DISCO_F100RB_serial_generic INTERFACE)
target_compile_options(DISCO_F100RB_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DISCO_F100RB_serial_none INTERFACE)
target_compile_options(DISCO_F100RB_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DISCO_F100RB_usb_CDC INTERFACE)
target_compile_options(DISCO_F100RB_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DISCO_F100RB_usb_CDCgen INTERFACE)
target_compile_options(DISCO_F100RB_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DISCO_F100RB_usb_HID INTERFACE)
target_compile_options(DISCO_F100RB_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DISCO_F100RB_usb_none INTERFACE)
target_compile_options(DISCO_F100RB_usb_none INTERFACE
  "SHELL:"
)
add_library(DISCO_F100RB_xusb_FS INTERFACE)
target_compile_options(DISCO_F100RB_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DISCO_F100RB_xusb_HS INTERFACE)
target_compile_options(DISCO_F100RB_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DISCO_F100RB_xusb_HSFS INTERFACE)
target_compile_options(DISCO_F100RB_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DISCO_F303VC
# -----------------------------------------------------------------------------

set(DISCO_F303VC_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F3xx/F303V(B-C)T")
set(DISCO_F303VC_MAXSIZE 262144)
set(DISCO_F303VC_MAXDATASIZE 40960)
set(DISCO_F303VC_MCU cortex-m4)
set(DISCO_F303VC_FPCONF "fpv4-sp-d16-hard")
add_library(DISCO_F303VC INTERFACE)
target_compile_options(DISCO_F303VC INTERFACE
  "SHELL:-DSTM32F303xC  "
  "SHELL:"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DISCO_F303VC_MCU}
)
target_compile_definitions(DISCO_F303VC INTERFACE
  "STM32F3xx"
	"ARDUINO_DISCO_F303VC"
	"BOARD_NAME=\"DISCO_F303VC\""
	"BOARD_ID=DISCO_F303VC"
	"VARIANT_H=\"variant_DISCO_F303VC.h\""
)
target_include_directories(DISCO_F303VC INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F3xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F3xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F3xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F3xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F3xx/Source/Templates/gcc/
  ${DISCO_F303VC_VARIANT_PATH}
)

target_link_options(DISCO_F303VC INTERFACE
  "LINKER:--default-script=${DISCO_F303VC_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=40960"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DISCO_F303VC_MCU}
)

add_library(DISCO_F303VC_serial_disabled INTERFACE)
target_compile_options(DISCO_F303VC_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DISCO_F303VC_serial_generic INTERFACE)
target_compile_options(DISCO_F303VC_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DISCO_F303VC_serial_none INTERFACE)
target_compile_options(DISCO_F303VC_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DISCO_F303VC_usb_CDC INTERFACE)
target_compile_options(DISCO_F303VC_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DISCO_F303VC_usb_CDCgen INTERFACE)
target_compile_options(DISCO_F303VC_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DISCO_F303VC_usb_HID INTERFACE)
target_compile_options(DISCO_F303VC_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DISCO_F303VC_usb_none INTERFACE)
target_compile_options(DISCO_F303VC_usb_none INTERFACE
  "SHELL:"
)
add_library(DISCO_F303VC_xusb_FS INTERFACE)
target_compile_options(DISCO_F303VC_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DISCO_F303VC_xusb_HS INTERFACE)
target_compile_options(DISCO_F303VC_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DISCO_F303VC_xusb_HSFS INTERFACE)
target_compile_options(DISCO_F303VC_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DISCO_F407VG
# -----------------------------------------------------------------------------

set(DISCO_F407VG_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407V(E-G)T_F417V(E-G)T")
set(DISCO_F407VG_MAXSIZE 1048576)
set(DISCO_F407VG_MAXDATASIZE 131072)
set(DISCO_F407VG_MCU cortex-m4)
set(DISCO_F407VG_FPCONF "fpv4-sp-d16-hard")
add_library(DISCO_F407VG INTERFACE)
target_compile_options(DISCO_F407VG INTERFACE
  "SHELL:-DSTM32F407xx  "
  "SHELL:"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DISCO_F407VG_MCU}
)
target_compile_definitions(DISCO_F407VG INTERFACE
  "STM32F4xx"
	"ARDUINO_DISCO_F407VG"
	"BOARD_NAME=\"DISCO_F407VG\""
	"BOARD_ID=DISCO_F407VG"
	"VARIANT_H=\"variant_DISCO_F407VG.h\""
)
target_include_directories(DISCO_F407VG INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${DISCO_F407VG_VARIANT_PATH}
)

target_link_options(DISCO_F407VG INTERFACE
  "LINKER:--default-script=${DISCO_F407VG_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DISCO_F407VG_MCU}
)

add_library(DISCO_F407VG_serial_disabled INTERFACE)
target_compile_options(DISCO_F407VG_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DISCO_F407VG_serial_generic INTERFACE)
target_compile_options(DISCO_F407VG_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DISCO_F407VG_serial_none INTERFACE)
target_compile_options(DISCO_F407VG_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DISCO_F407VG_usb_CDC INTERFACE)
target_compile_options(DISCO_F407VG_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DISCO_F407VG_usb_CDCgen INTERFACE)
target_compile_options(DISCO_F407VG_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DISCO_F407VG_usb_HID INTERFACE)
target_compile_options(DISCO_F407VG_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DISCO_F407VG_usb_none INTERFACE)
target_compile_options(DISCO_F407VG_usb_none INTERFACE
  "SHELL:"
)
add_library(DISCO_F407VG_xusb_FS INTERFACE)
target_compile_options(DISCO_F407VG_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DISCO_F407VG_xusb_HS INTERFACE)
target_compile_options(DISCO_F407VG_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DISCO_F407VG_xusb_HSFS INTERFACE)
target_compile_options(DISCO_F407VG_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DISCO_F413ZH
# -----------------------------------------------------------------------------

set(DISCO_F413ZH_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F413Z(G-H)(J-T)_F423ZH(J-T)")
set(DISCO_F413ZH_MAXSIZE 1572864)
set(DISCO_F413ZH_MAXDATASIZE 327680)
set(DISCO_F413ZH_MCU cortex-m4)
set(DISCO_F413ZH_FPCONF "fpv4-sp-d16-hard")
add_library(DISCO_F413ZH INTERFACE)
target_compile_options(DISCO_F413ZH INTERFACE
  "SHELL:-DSTM32F413xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DISCO_F413ZH_MCU}
)
target_compile_definitions(DISCO_F413ZH INTERFACE
  "STM32F4xx"
	"ARDUINO_DISCO_F413ZH"
	"BOARD_NAME=\"DISCO_F413ZH\""
	"BOARD_ID=DISCO_F413ZH"
	"VARIANT_H=\"variant_DISCO_F413ZH.h\""
)
target_include_directories(DISCO_F413ZH INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${DISCO_F413ZH_VARIANT_PATH}
)

target_link_options(DISCO_F413ZH INTERFACE
  "LINKER:--default-script=${DISCO_F413ZH_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=1572864"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=327680"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DISCO_F413ZH_MCU}
)

add_library(DISCO_F413ZH_serial_disabled INTERFACE)
target_compile_options(DISCO_F413ZH_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DISCO_F413ZH_serial_generic INTERFACE)
target_compile_options(DISCO_F413ZH_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DISCO_F413ZH_serial_none INTERFACE)
target_compile_options(DISCO_F413ZH_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DISCO_F413ZH_usb_CDC INTERFACE)
target_compile_options(DISCO_F413ZH_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DISCO_F413ZH_usb_CDCgen INTERFACE)
target_compile_options(DISCO_F413ZH_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DISCO_F413ZH_usb_HID INTERFACE)
target_compile_options(DISCO_F413ZH_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DISCO_F413ZH_usb_none INTERFACE)
target_compile_options(DISCO_F413ZH_usb_none INTERFACE
  "SHELL:"
)
add_library(DISCO_F413ZH_xusb_FS INTERFACE)
target_compile_options(DISCO_F413ZH_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DISCO_F413ZH_xusb_HS INTERFACE)
target_compile_options(DISCO_F413ZH_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DISCO_F413ZH_xusb_HSFS INTERFACE)
target_compile_options(DISCO_F413ZH_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DISCO_F746NG
# -----------------------------------------------------------------------------

set(DISCO_F746NG_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F7xx/F746B(E-G)T_F746N(E-G)H_F750N8H_F756BGT_F756NGH")
set(DISCO_F746NG_MAXSIZE 1048576)
set(DISCO_F746NG_MAXDATASIZE 327680)
set(DISCO_F746NG_MCU cortex-m7)
set(DISCO_F746NG_FPCONF "fpv4-sp-d16-hard")
add_library(DISCO_F746NG INTERFACE)
target_compile_options(DISCO_F746NG INTERFACE
  "SHELL:-DSTM32F746xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DISCO_F746NG_MCU}
)
target_compile_definitions(DISCO_F746NG INTERFACE
  "STM32F7xx"
	"ARDUINO_DISCO_F746NG"
	"BOARD_NAME=\"DISCO_F746NG\""
	"BOARD_ID=DISCO_F746NG"
	"VARIANT_H=\"variant_DISCO_F746NG.h\""
)
target_include_directories(DISCO_F746NG INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F7xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F7xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F7xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F7xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F7xx/Source/Templates/gcc/
  ${DISCO_F746NG_VARIANT_PATH}
)

target_link_options(DISCO_F746NG INTERFACE
  "LINKER:--default-script=${DISCO_F746NG_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=327680"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DISCO_F746NG_MCU}
)

add_library(DISCO_F746NG_serial_disabled INTERFACE)
target_compile_options(DISCO_F746NG_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DISCO_F746NG_serial_generic INTERFACE)
target_compile_options(DISCO_F746NG_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DISCO_F746NG_serial_none INTERFACE)
target_compile_options(DISCO_F746NG_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DISCO_F746NG_usb_CDC INTERFACE)
target_compile_options(DISCO_F746NG_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DISCO_F746NG_usb_CDCgen INTERFACE)
target_compile_options(DISCO_F746NG_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DISCO_F746NG_usb_HID INTERFACE)
target_compile_options(DISCO_F746NG_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DISCO_F746NG_usb_none INTERFACE)
target_compile_options(DISCO_F746NG_usb_none INTERFACE
  "SHELL:"
)
add_library(DISCO_F746NG_xusb_FS INTERFACE)
target_compile_options(DISCO_F746NG_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DISCO_F746NG_xusb_HS INTERFACE)
target_compile_options(DISCO_F746NG_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DISCO_F746NG_xusb_HSFS INTERFACE)
target_compile_options(DISCO_F746NG_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DISCO_G0316
# -----------------------------------------------------------------------------

set(DISCO_G0316_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32G0xx/G031J(4-6)M_G041J6M")
set(DISCO_G0316_MAXSIZE 32768)
set(DISCO_G0316_MAXDATASIZE 8192)
set(DISCO_G0316_MCU cortex-m0plus)
set(DISCO_G0316_FPCONF "-")
add_library(DISCO_G0316 INTERFACE)
target_compile_options(DISCO_G0316 INTERFACE
  "SHELL:-DSTM32G031xx  -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${DISCO_G0316_MCU}
)
target_compile_definitions(DISCO_G0316 INTERFACE
  "STM32G0xx"
	"ARDUINO_DISCO_G0316"
	"BOARD_NAME=\"DISCO_G0316\""
	"BOARD_ID=DISCO_G0316"
	"VARIANT_H=\"variant_DISCO_G0316.h\""
)
target_include_directories(DISCO_G0316 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32G0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32G0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32G0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32G0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32G0xx/Source/Templates/gcc/
  ${DISCO_G0316_VARIANT_PATH}
)

target_link_options(DISCO_G0316 INTERFACE
  "LINKER:--default-script=${DISCO_G0316_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${DISCO_G0316_MCU}
)

add_library(DISCO_G0316_serial_disabled INTERFACE)
target_compile_options(DISCO_G0316_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DISCO_G0316_serial_generic INTERFACE)
target_compile_options(DISCO_G0316_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DISCO_G0316_serial_none INTERFACE)
target_compile_options(DISCO_G0316_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DISCO_G0316_usb_CDC INTERFACE)
target_compile_options(DISCO_G0316_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DISCO_G0316_usb_CDCgen INTERFACE)
target_compile_options(DISCO_G0316_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DISCO_G0316_usb_HID INTERFACE)
target_compile_options(DISCO_G0316_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DISCO_G0316_usb_none INTERFACE)
target_compile_options(DISCO_G0316_usb_none INTERFACE
  "SHELL:"
)
add_library(DISCO_G0316_xusb_FS INTERFACE)
target_compile_options(DISCO_G0316_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DISCO_G0316_xusb_HS INTERFACE)
target_compile_options(DISCO_G0316_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DISCO_G0316_xusb_HSFS INTERFACE)
target_compile_options(DISCO_G0316_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DIYMORE_F407VGT
# -----------------------------------------------------------------------------

set(DIYMORE_F407VGT_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407V(E-G)T_F417V(E-G)T")
set(DIYMORE_F407VGT_MAXSIZE 1048576)
set(DIYMORE_F407VGT_MAXDATASIZE 131072)
set(DIYMORE_F407VGT_MCU cortex-m4)
set(DIYMORE_F407VGT_FPCONF "-")
add_library(DIYMORE_F407VGT INTERFACE)
target_compile_options(DIYMORE_F407VGT INTERFACE
  "SHELL:-DSTM32F407xx   "
  "SHELL:"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DIYMORE_F407VGT_MCU}
)
target_compile_definitions(DIYMORE_F407VGT INTERFACE
  "STM32F4xx"
	"ARDUINO_DIYMORE_F407VGT"
	"BOARD_NAME=\"DIYMORE_F407VGT\""
	"BOARD_ID=DIYMORE_F407VGT"
	"VARIANT_H=\"variant_DIYMORE_F407VGT.h\""
)
target_include_directories(DIYMORE_F407VGT INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${DIYMORE_F407VGT_VARIANT_PATH}
)

target_link_options(DIYMORE_F407VGT INTERFACE
  "LINKER:--default-script=${DIYMORE_F407VGT_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DIYMORE_F407VGT_MCU}
)

add_library(DIYMORE_F407VGT_serial_disabled INTERFACE)
target_compile_options(DIYMORE_F407VGT_serial_disabled INTERFACE
  "SHELL:"
)
add_library(DIYMORE_F407VGT_serial_generic INTERFACE)
target_compile_options(DIYMORE_F407VGT_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(DIYMORE_F407VGT_serial_none INTERFACE)
target_compile_options(DIYMORE_F407VGT_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(DIYMORE_F407VGT_usb_CDC INTERFACE)
target_compile_options(DIYMORE_F407VGT_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(DIYMORE_F407VGT_usb_CDCgen INTERFACE)
target_compile_options(DIYMORE_F407VGT_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(DIYMORE_F407VGT_usb_HID INTERFACE)
target_compile_options(DIYMORE_F407VGT_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(DIYMORE_F407VGT_usb_none INTERFACE)
target_compile_options(DIYMORE_F407VGT_usb_none INTERFACE
  "SHELL:"
)
add_library(DIYMORE_F407VGT_xusb_FS INTERFACE)
target_compile_options(DIYMORE_F407VGT_xusb_FS INTERFACE
  "SHELL:"
)
add_library(DIYMORE_F407VGT_xusb_HS INTERFACE)
target_compile_options(DIYMORE_F407VGT_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(DIYMORE_F407VGT_xusb_HSFS INTERFACE)
target_compile_options(DIYMORE_F407VGT_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# DIYMORE_F407VGT_hid
# -----------------------------------------------------------------------------

set(DIYMORE_F407VGT_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407V(E-G)T_F417V(E-G)T")
set(DIYMORE_F407VGT_hid_MAXSIZE 1048576)
set(DIYMORE_F407VGT_hid_MAXDATASIZE 131072)
set(DIYMORE_F407VGT_hid_MCU cortex-m4)
set(DIYMORE_F407VGT_hid_FPCONF "-")
add_library(DIYMORE_F407VGT_hid INTERFACE)
target_compile_options(DIYMORE_F407VGT_hid INTERFACE
  "SHELL:-DSTM32F407xx  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DIYMORE_F407VGT_hid_MCU}
)
target_compile_definitions(DIYMORE_F407VGT_hid INTERFACE
  "STM32F4xx"
	"ARDUINO_DIYMORE_F407VGT"
	"BOARD_NAME=\"DIYMORE_F407VGT\""
	"BOARD_ID=DIYMORE_F407VGT"
	"VARIANT_H=\"variant_DIYMORE_F407VGT.h\""
)
target_include_directories(DIYMORE_F407VGT_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${DIYMORE_F407VGT_hid_VARIANT_PATH}
)

target_link_options(DIYMORE_F407VGT_hid INTERFACE
  "LINKER:--default-script=${DIYMORE_F407VGT_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x4000"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${DIYMORE_F407VGT_hid_MCU}
)


# EBB42_V1_1
# -----------------------------------------------------------------------------

set(EBB42_V1_1_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32G0xx/G0B1C(B-C-E)(T-U)_G0C1C(C-E)(T-U)")
set(EBB42_V1_1_MAXSIZE 131072)
set(EBB42_V1_1_MAXDATASIZE 147456)
set(EBB42_V1_1_MCU cortex-m0plus)
set(EBB42_V1_1_FPCONF "-")
add_library(EBB42_V1_1 INTERFACE)
target_compile_options(EBB42_V1_1 INTERFACE
  "SHELL:-DSTM32G0B1xx   -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${EBB42_V1_1_MCU}
)
target_compile_definitions(EBB42_V1_1 INTERFACE
  "STM32G0xx"
	"ARDUINO_EBB42_V1_1"
	"BOARD_NAME=\"EBB42_V1_1\""
	"BOARD_ID=EBB42_V1_1"
	"VARIANT_H=\"variant_EBB42_V1_1.h\""
)
target_include_directories(EBB42_V1_1 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32G0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32G0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32G0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32G0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32G0xx/Source/Templates/gcc/
  ${EBB42_V1_1_VARIANT_PATH}
)

target_link_options(EBB42_V1_1 INTERFACE
  "LINKER:--default-script=${EBB42_V1_1_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=147456"
  "SHELL: "
  -mcpu=${EBB42_V1_1_MCU}
)

add_library(EBB42_V1_1_serial_disabled INTERFACE)
target_compile_options(EBB42_V1_1_serial_disabled INTERFACE
  "SHELL:"
)
add_library(EBB42_V1_1_serial_generic INTERFACE)
target_compile_options(EBB42_V1_1_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(EBB42_V1_1_serial_none INTERFACE)
target_compile_options(EBB42_V1_1_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(EBB42_V1_1_usb_CDC INTERFACE)
target_compile_options(EBB42_V1_1_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(EBB42_V1_1_usb_CDCgen INTERFACE)
target_compile_options(EBB42_V1_1_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(EBB42_V1_1_usb_none INTERFACE)
target_compile_options(EBB42_V1_1_usb_none INTERFACE
  "SHELL:"
)
add_library(EBB42_V1_1_xusb_FS INTERFACE)
target_compile_options(EBB42_V1_1_xusb_FS INTERFACE
  "SHELL:"
)
add_library(EBB42_V1_1_xusb_HS INTERFACE)
target_compile_options(EBB42_V1_1_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(EBB42_V1_1_xusb_HSFS INTERFACE)
target_compile_options(EBB42_V1_1_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# EEXTR_F030_V1
# -----------------------------------------------------------------------------

set(EEXTR_F030_V1_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F030C8T")
set(EEXTR_F030_V1_MAXSIZE 65536)
set(EEXTR_F030_V1_MAXDATASIZE 8192)
set(EEXTR_F030_V1_MCU cortex-m0)
set(EEXTR_F030_V1_FPCONF "-")
add_library(EEXTR_F030_V1 INTERFACE)
target_compile_options(EEXTR_F030_V1 INTERFACE
  "SHELL:-DSTM32F030x8  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL: "
  -mcpu=${EEXTR_F030_V1_MCU}
)
target_compile_definitions(EEXTR_F030_V1 INTERFACE
  "STM32F0xx"
	"ARDUINO_EEXTR_F030_V1"
	"BOARD_NAME=\"EEXTR_F030_V1\""
	"BOARD_ID=EEXTR_F030_V1"
	"VARIANT_H=\"variant_EEXTR_F030_V1.h\""
)
target_include_directories(EEXTR_F030_V1 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${EEXTR_F030_V1_VARIANT_PATH}
)

target_link_options(EEXTR_F030_V1 INTERFACE
  "LINKER:--default-script=${EEXTR_F030_V1_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${EEXTR_F030_V1_MCU}
)

add_library(EEXTR_F030_V1_serial_disabled INTERFACE)
target_compile_options(EEXTR_F030_V1_serial_disabled INTERFACE
  "SHELL:"
)
add_library(EEXTR_F030_V1_serial_generic INTERFACE)
target_compile_options(EEXTR_F030_V1_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(EEXTR_F030_V1_serial_none INTERFACE)
target_compile_options(EEXTR_F030_V1_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(EEXTR_F030_V1_usb_CDC INTERFACE)
target_compile_options(EEXTR_F030_V1_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(EEXTR_F030_V1_usb_CDCgen INTERFACE)
target_compile_options(EEXTR_F030_V1_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(EEXTR_F030_V1_usb_none INTERFACE)
target_compile_options(EEXTR_F030_V1_usb_none INTERFACE
  "SHELL:"
)
add_library(EEXTR_F030_V1_xusb_FS INTERFACE)
target_compile_options(EEXTR_F030_V1_xusb_FS INTERFACE
  "SHELL:"
)
add_library(EEXTR_F030_V1_xusb_HS INTERFACE)
target_compile_options(EEXTR_F030_V1_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(EEXTR_F030_V1_xusb_HSFS INTERFACE)
target_compile_options(EEXTR_F030_V1_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# ELEKTOR_F072C8
# -----------------------------------------------------------------------------

set(ELEKTOR_F072C8_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072C8(T-U)_F072CB(T-U-Y)")
set(ELEKTOR_F072C8_MAXSIZE 65536)
set(ELEKTOR_F072C8_MAXDATASIZE 16384)
set(ELEKTOR_F072C8_MCU cortex-m0)
set(ELEKTOR_F072C8_FPCONF "-")
add_library(ELEKTOR_F072C8 INTERFACE)
target_compile_options(ELEKTOR_F072C8 INTERFACE
  "SHELL:-DSTM32F072xB "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL: "
  -mcpu=${ELEKTOR_F072C8_MCU}
)
target_compile_definitions(ELEKTOR_F072C8 INTERFACE
  "STM32F0xx"
	"ARDUINO_ELEKTOR_F072C8"
	"BOARD_NAME=\"ELEKTOR_F072C8\""
	"BOARD_ID=ELEKTOR_F072C8"
	"VARIANT_H=\"variant_ELEKTOR_F072Cx.h\""
)
target_include_directories(ELEKTOR_F072C8 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${ELEKTOR_F072C8_VARIANT_PATH}
)

target_link_options(ELEKTOR_F072C8 INTERFACE
  "LINKER:--default-script=${ELEKTOR_F072C8_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${ELEKTOR_F072C8_MCU}
)

add_library(ELEKTOR_F072C8_serial_disabled INTERFACE)
target_compile_options(ELEKTOR_F072C8_serial_disabled INTERFACE
  "SHELL:"
)
add_library(ELEKTOR_F072C8_serial_generic INTERFACE)
target_compile_options(ELEKTOR_F072C8_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(ELEKTOR_F072C8_serial_none INTERFACE)
target_compile_options(ELEKTOR_F072C8_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# ELEKTOR_F072CB
# -----------------------------------------------------------------------------

set(ELEKTOR_F072CB_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072C8(T-U)_F072CB(T-U-Y)")
set(ELEKTOR_F072CB_MAXSIZE 131072)
set(ELEKTOR_F072CB_MAXDATASIZE 16384)
set(ELEKTOR_F072CB_MCU cortex-m0)
set(ELEKTOR_F072CB_FPCONF "-")
add_library(ELEKTOR_F072CB INTERFACE)
target_compile_options(ELEKTOR_F072CB INTERFACE
  "SHELL:-DSTM32F072xB "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL: "
  -mcpu=${ELEKTOR_F072CB_MCU}
)
target_compile_definitions(ELEKTOR_F072CB INTERFACE
  "STM32F0xx"
	"ARDUINO_ELEKTOR_F072CB"
	"BOARD_NAME=\"ELEKTOR_F072CB\""
	"BOARD_ID=ELEKTOR_F072CB"
	"VARIANT_H=\"variant_ELEKTOR_F072Cx.h\""
)
target_include_directories(ELEKTOR_F072CB INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${ELEKTOR_F072CB_VARIANT_PATH}
)

target_link_options(ELEKTOR_F072CB INTERFACE
  "LINKER:--default-script=${ELEKTOR_F072CB_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${ELEKTOR_F072CB_MCU}
)

add_library(ELEKTOR_F072CB_serial_disabled INTERFACE)
target_compile_options(ELEKTOR_F072CB_serial_disabled INTERFACE
  "SHELL:"
)
add_library(ELEKTOR_F072CB_serial_generic INTERFACE)
target_compile_options(ELEKTOR_F072CB_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(ELEKTOR_F072CB_serial_none INTERFACE)
target_compile_options(ELEKTOR_F072CB_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# ETHERCAT_DUINO
# -----------------------------------------------------------------------------

set(ETHERCAT_DUINO_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F7xx/F745Z(E-G)T_F746Z(E-G)(T-Y)_F750Z8T_F756ZG(T-Y)")
set(ETHERCAT_DUINO_MAXSIZE 524288)
set(ETHERCAT_DUINO_MAXDATASIZE 327680)
set(ETHERCAT_DUINO_MCU cortex-m7)
set(ETHERCAT_DUINO_FPCONF "fpv4-sp-d16-hard")
add_library(ETHERCAT_DUINO INTERFACE)
target_compile_options(ETHERCAT_DUINO INTERFACE
  "SHELL:-DSTM32F746xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${ETHERCAT_DUINO_MCU}
)
target_compile_definitions(ETHERCAT_DUINO INTERFACE
  "STM32F7xx"
	"ARDUINO_ETHERCAT_DUINO"
	"BOARD_NAME=\"ETHERCAT_DUINO\""
	"BOARD_ID=ETHERCAT_DUINO"
	"VARIANT_H=\"variant_ETHERCAT_DUINO.h\""
)
target_include_directories(ETHERCAT_DUINO INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F7xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F7xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F7xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F7xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F7xx/Source/Templates/gcc/
  ${ETHERCAT_DUINO_VARIANT_PATH}
)

target_link_options(ETHERCAT_DUINO INTERFACE
  "LINKER:--default-script=${ETHERCAT_DUINO_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=327680"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${ETHERCAT_DUINO_MCU}
)

add_library(ETHERCAT_DUINO_serial_disabled INTERFACE)
target_compile_options(ETHERCAT_DUINO_serial_disabled INTERFACE
  "SHELL:"
)
add_library(ETHERCAT_DUINO_serial_generic INTERFACE)
target_compile_options(ETHERCAT_DUINO_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(ETHERCAT_DUINO_serial_none INTERFACE)
target_compile_options(ETHERCAT_DUINO_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(ETHERCAT_DUINO_usb_CDC INTERFACE)
target_compile_options(ETHERCAT_DUINO_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(ETHERCAT_DUINO_usb_CDCgen INTERFACE)
target_compile_options(ETHERCAT_DUINO_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(ETHERCAT_DUINO_usb_HID INTERFACE)
target_compile_options(ETHERCAT_DUINO_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(ETHERCAT_DUINO_usb_none INTERFACE)
target_compile_options(ETHERCAT_DUINO_usb_none INTERFACE
  "SHELL:"
)
add_library(ETHERCAT_DUINO_xusb_FS INTERFACE)
target_compile_options(ETHERCAT_DUINO_xusb_FS INTERFACE
  "SHELL:"
)
add_library(ETHERCAT_DUINO_xusb_HS INTERFACE)
target_compile_options(ETHERCAT_DUINO_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(ETHERCAT_DUINO_xusb_HSFS INTERFACE)
target_compile_options(ETHERCAT_DUINO_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# FEATHER_F405
# -----------------------------------------------------------------------------

set(FEATHER_F405_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F405RGT_F415RGT")
set(FEATHER_F405_MAXSIZE 1048576)
set(FEATHER_F405_MAXDATASIZE 131072)
set(FEATHER_F405_MCU cortex-m4)
set(FEATHER_F405_FPCONF "-")
add_library(FEATHER_F405 INTERFACE)
target_compile_options(FEATHER_F405 INTERFACE
  "SHELL:-DSTM32F405xx   "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${FEATHER_F405_MCU}
)
target_compile_definitions(FEATHER_F405 INTERFACE
  "STM32F4xx"
	"ARDUINO_FEATHER_F405"
	"BOARD_NAME=\"FEATHER_F405\""
	"BOARD_ID=FEATHER_F405"
	"VARIANT_H=\"variant_FEATHER_F405.h\""
)
target_include_directories(FEATHER_F405 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${FEATHER_F405_VARIANT_PATH}
)

target_link_options(FEATHER_F405 INTERFACE
  "LINKER:--default-script=${FEATHER_F405_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${FEATHER_F405_MCU}
)

add_library(FEATHER_F405_serial_disabled INTERFACE)
target_compile_options(FEATHER_F405_serial_disabled INTERFACE
  "SHELL:"
)
add_library(FEATHER_F405_serial_generic INTERFACE)
target_compile_options(FEATHER_F405_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(FEATHER_F405_serial_none INTERFACE)
target_compile_options(FEATHER_F405_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(FEATHER_F405_usb_CDC INTERFACE)
target_compile_options(FEATHER_F405_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(FEATHER_F405_usb_CDCgen INTERFACE)
target_compile_options(FEATHER_F405_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(FEATHER_F405_usb_HID INTERFACE)
target_compile_options(FEATHER_F405_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(FEATHER_F405_usb_none INTERFACE)
target_compile_options(FEATHER_F405_usb_none INTERFACE
  "SHELL:"
)
add_library(FEATHER_F405_xusb_FS INTERFACE)
target_compile_options(FEATHER_F405_xusb_FS INTERFACE
  "SHELL:"
)
add_library(FEATHER_F405_xusb_HS INTERFACE)
target_compile_options(FEATHER_F405_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(FEATHER_F405_xusb_HSFS INTERFACE)
target_compile_options(FEATHER_F405_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# FEATHER_F405_hid
# -----------------------------------------------------------------------------

set(FEATHER_F405_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F405RGT_F415RGT")
set(FEATHER_F405_hid_MAXSIZE 1048576)
set(FEATHER_F405_hid_MAXDATASIZE 131072)
set(FEATHER_F405_hid_MCU cortex-m4)
set(FEATHER_F405_hid_FPCONF "-")
add_library(FEATHER_F405_hid INTERFACE)
target_compile_options(FEATHER_F405_hid INTERFACE
  "SHELL:-DSTM32F405xx  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${FEATHER_F405_hid_MCU}
)
target_compile_definitions(FEATHER_F405_hid INTERFACE
  "STM32F4xx"
	"ARDUINO_FEATHER_F405"
	"BOARD_NAME=\"FEATHER_F405\""
	"BOARD_ID=FEATHER_F405"
	"VARIANT_H=\"variant_FEATHER_F405.h\""
)
target_include_directories(FEATHER_F405_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${FEATHER_F405_hid_VARIANT_PATH}
)

target_link_options(FEATHER_F405_hid INTERFACE
  "LINKER:--default-script=${FEATHER_F405_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x4000"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${FEATHER_F405_hid_MCU}
)


# FK407M1
# -----------------------------------------------------------------------------

set(FK407M1_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407V(E-G)T_F417V(E-G)T")
set(FK407M1_MAXSIZE 524288)
set(FK407M1_MAXDATASIZE 131072)
set(FK407M1_MCU cortex-m4)
set(FK407M1_FPCONF "-")
add_library(FK407M1 INTERFACE)
target_compile_options(FK407M1 INTERFACE
  "SHELL:-DSTM32F407xx   "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${FK407M1_MCU}
)
target_compile_definitions(FK407M1 INTERFACE
  "STM32F4xx"
	"ARDUINO_FK407M1"
	"BOARD_NAME=\"FK407M1\""
	"BOARD_ID=FK407M1"
	"VARIANT_H=\"variant_FK407M1.h\""
)
target_include_directories(FK407M1 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${FK407M1_VARIANT_PATH}
)

target_link_options(FK407M1 INTERFACE
  "LINKER:--default-script=${FK407M1_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${FK407M1_MCU}
)

add_library(FK407M1_serial_disabled INTERFACE)
target_compile_options(FK407M1_serial_disabled INTERFACE
  "SHELL:"
)
add_library(FK407M1_serial_generic INTERFACE)
target_compile_options(FK407M1_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(FK407M1_serial_none INTERFACE)
target_compile_options(FK407M1_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(FK407M1_usb_CDC INTERFACE)
target_compile_options(FK407M1_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(FK407M1_usb_CDCgen INTERFACE)
target_compile_options(FK407M1_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(FK407M1_usb_HID INTERFACE)
target_compile_options(FK407M1_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(FK407M1_usb_none INTERFACE)
target_compile_options(FK407M1_usb_none INTERFACE
  "SHELL:"
)
add_library(FK407M1_xusb_FS INTERFACE)
target_compile_options(FK407M1_xusb_FS INTERFACE
  "SHELL:"
)
add_library(FK407M1_xusb_HS INTERFACE)
target_compile_options(FK407M1_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(FK407M1_xusb_HSFS INTERFACE)
target_compile_options(FK407M1_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# FK407M1_hid
# -----------------------------------------------------------------------------

set(FK407M1_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F407V(E-G)T_F417V(E-G)T")
set(FK407M1_hid_MAXSIZE 524288)
set(FK407M1_hid_MAXDATASIZE 131072)
set(FK407M1_hid_MCU cortex-m4)
set(FK407M1_hid_FPCONF "-")
add_library(FK407M1_hid INTERFACE)
target_compile_options(FK407M1_hid INTERFACE
  "SHELL:-DSTM32F407xx  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${FK407M1_hid_MCU}
)
target_compile_definitions(FK407M1_hid INTERFACE
  "STM32F4xx"
	"ARDUINO_FK407M1"
	"BOARD_NAME=\"FK407M1\""
	"BOARD_ID=FK407M1"
	"VARIANT_H=\"variant_FK407M1.h\""
)
target_include_directories(FK407M1_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${FK407M1_hid_VARIANT_PATH}
)

target_link_options(FK407M1_hid INTERFACE
  "LINKER:--default-script=${FK407M1_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x4000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${FK407M1_hid_MCU}
)


# FYSETC_S6
# -----------------------------------------------------------------------------

set(FYSETC_S6_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F4xx/F446V(C-E)T")
set(FYSETC_S6_MAXSIZE 458752)
set(FYSETC_S6_MAXDATASIZE 131072)
set(FYSETC_S6_MCU cortex-m4)
set(FYSETC_S6_FPCONF "fpv4-sp-d16-hard")
add_library(FYSETC_S6 INTERFACE)
target_compile_options(FYSETC_S6 INTERFACE
  "SHELL:-DSTM32F446xx  "
  "SHELL:-DCUSTOM_PERIPHERAL_PINS"
  "SHELL:"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${FYSETC_S6_MCU}
)
target_compile_definitions(FYSETC_S6 INTERFACE
  "STM32F4xx"
	"ARDUINO_FYSETC_S6"
	"BOARD_NAME=\"FYSETC_S6\""
	"BOARD_ID=FYSETC_S6"
	"VARIANT_H=\"variant_FYSETC_S6.h\""
)
target_include_directories(FYSETC_S6 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F4xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F4xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F4xx/Source/Templates/gcc/
  ${FYSETC_S6_VARIANT_PATH}
)

target_link_options(FYSETC_S6 INTERFACE
  "LINKER:--default-script=${FYSETC_S6_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x10000"
	"LINKER:--defsym=LD_MAX_SIZE=458752"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=131072"
  "SHELL:-mfpu=fpv4-sp-d16 -mfloat-abi=hard"
  -mcpu=${FYSETC_S6_MCU}
)

add_library(FYSETC_S6_serial_disabled INTERFACE)
target_compile_options(FYSETC_S6_serial_disabled INTERFACE
  "SHELL:"
)
add_library(FYSETC_S6_serial_generic INTERFACE)
target_compile_options(FYSETC_S6_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(FYSETC_S6_serial_none INTERFACE)
target_compile_options(FYSETC_S6_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(FYSETC_S6_usb_CDC INTERFACE)
target_compile_options(FYSETC_S6_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(FYSETC_S6_usb_CDCgen INTERFACE)
target_compile_options(FYSETC_S6_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(FYSETC_S6_usb_none INTERFACE)
target_compile_options(FYSETC_S6_usb_none INTERFACE
  "SHELL:"
)
add_library(FYSETC_S6_xusb_FS INTERFACE)
target_compile_options(FYSETC_S6_xusb_FS INTERFACE
  "SHELL:"
)
add_library(FYSETC_S6_xusb_HS INTERFACE)
target_compile_options(FYSETC_S6_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(FYSETC_S6_xusb_HSFS INTERFACE)
target_compile_options(FYSETC_S6_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_C011D6YX
# -----------------------------------------------------------------------------

set(GENERIC_C011D6YX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32C0xx/C011D6Y_C011F(4-6)(P-U)_C031F(4-6)P")
set(GENERIC_C011D6YX_MAXSIZE 32768)
set(GENERIC_C011D6YX_MAXDATASIZE 6144)
set(GENERIC_C011D6YX_MCU cortex-m0plus)
set(GENERIC_C011D6YX_FPCONF "-")
add_library(GENERIC_C011D6YX INTERFACE)
target_compile_options(GENERIC_C011D6YX INTERFACE
  "SHELL:-DSTM32C011xx  -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_C011D6YX_MCU}
)
target_compile_definitions(GENERIC_C011D6YX INTERFACE
  "STM32C0xx"
	"ARDUINO_GENERIC_C011D6YX"
	"BOARD_NAME=\"GENERIC_C011D6YX\""
	"BOARD_ID=GENERIC_C011D6YX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_C011D6YX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32C0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Source/Templates/gcc/
  ${GENERIC_C011D6YX_VARIANT_PATH}
)

target_link_options(GENERIC_C011D6YX INTERFACE
  "LINKER:--default-script=${GENERIC_C011D6YX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_C011D6YX_MCU}
)

add_library(GENERIC_C011D6YX_serial_disabled INTERFACE)
target_compile_options(GENERIC_C011D6YX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_C011D6YX_serial_generic INTERFACE)
target_compile_options(GENERIC_C011D6YX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_C011D6YX_serial_none INTERFACE)
target_compile_options(GENERIC_C011D6YX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# GENERIC_C011F4PX
# -----------------------------------------------------------------------------

set(GENERIC_C011F4PX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32C0xx/C011D6Y_C011F(4-6)(P-U)_C031F(4-6)P")
set(GENERIC_C011F4PX_MAXSIZE 16384)
set(GENERIC_C011F4PX_MAXDATASIZE 6144)
set(GENERIC_C011F4PX_MCU cortex-m0plus)
set(GENERIC_C011F4PX_FPCONF "-")
add_library(GENERIC_C011F4PX INTERFACE)
target_compile_options(GENERIC_C011F4PX INTERFACE
  "SHELL:-DSTM32C011xx  -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_C011F4PX_MCU}
)
target_compile_definitions(GENERIC_C011F4PX INTERFACE
  "STM32C0xx"
	"ARDUINO_GENERIC_C011F4PX"
	"BOARD_NAME=\"GENERIC_C011F4PX\""
	"BOARD_ID=GENERIC_C011F4PX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_C011F4PX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32C0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Source/Templates/gcc/
  ${GENERIC_C011F4PX_VARIANT_PATH}
)

target_link_options(GENERIC_C011F4PX INTERFACE
  "LINKER:--default-script=${GENERIC_C011F4PX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_C011F4PX_MCU}
)

add_library(GENERIC_C011F4PX_serial_disabled INTERFACE)
target_compile_options(GENERIC_C011F4PX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_C011F4PX_serial_generic INTERFACE)
target_compile_options(GENERIC_C011F4PX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_C011F4PX_serial_none INTERFACE)
target_compile_options(GENERIC_C011F4PX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# GENERIC_C011F4UX
# -----------------------------------------------------------------------------

set(GENERIC_C011F4UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32C0xx/C011D6Y_C011F(4-6)(P-U)_C031F(4-6)P")
set(GENERIC_C011F4UX_MAXSIZE 16384)
set(GENERIC_C011F4UX_MAXDATASIZE 6144)
set(GENERIC_C011F4UX_MCU cortex-m0plus)
set(GENERIC_C011F4UX_FPCONF "-")
add_library(GENERIC_C011F4UX INTERFACE)
target_compile_options(GENERIC_C011F4UX INTERFACE
  "SHELL:-DSTM32C011xx  -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_C011F4UX_MCU}
)
target_compile_definitions(GENERIC_C011F4UX INTERFACE
  "STM32C0xx"
	"ARDUINO_GENERIC_C011F4UX"
	"BOARD_NAME=\"GENERIC_C011F4UX\""
	"BOARD_ID=GENERIC_C011F4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_C011F4UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32C0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Source/Templates/gcc/
  ${GENERIC_C011F4UX_VARIANT_PATH}
)

target_link_options(GENERIC_C011F4UX INTERFACE
  "LINKER:--default-script=${GENERIC_C011F4UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_C011F4UX_MCU}
)

add_library(GENERIC_C011F4UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_C011F4UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_C011F4UX_serial_generic INTERFACE)
target_compile_options(GENERIC_C011F4UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_C011F4UX_serial_none INTERFACE)
target_compile_options(GENERIC_C011F4UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# GENERIC_C011F6PX
# -----------------------------------------------------------------------------

set(GENERIC_C011F6PX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32C0xx/C011D6Y_C011F(4-6)(P-U)_C031F(4-6)P")
set(GENERIC_C011F6PX_MAXSIZE 32768)
set(GENERIC_C011F6PX_MAXDATASIZE 6144)
set(GENERIC_C011F6PX_MCU cortex-m0plus)
set(GENERIC_C011F6PX_FPCONF "-")
add_library(GENERIC_C011F6PX INTERFACE)
target_compile_options(GENERIC_C011F6PX INTERFACE
  "SHELL:-DSTM32C011xx  -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_C011F6PX_MCU}
)
target_compile_definitions(GENERIC_C011F6PX INTERFACE
  "STM32C0xx"
	"ARDUINO_GENERIC_C011F6PX"
	"BOARD_NAME=\"GENERIC_C011F6PX\""
	"BOARD_ID=GENERIC_C011F6PX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_C011F6PX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32C0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Source/Templates/gcc/
  ${GENERIC_C011F6PX_VARIANT_PATH}
)

target_link_options(GENERIC_C011F6PX INTERFACE
  "LINKER:--default-script=${GENERIC_C011F6PX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_C011F6PX_MCU}
)

add_library(GENERIC_C011F6PX_serial_disabled INTERFACE)
target_compile_options(GENERIC_C011F6PX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_C011F6PX_serial_generic INTERFACE)
target_compile_options(GENERIC_C011F6PX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_C011F6PX_serial_none INTERFACE)
target_compile_options(GENERIC_C011F6PX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# GENERIC_C011F6UX
# -----------------------------------------------------------------------------

set(GENERIC_C011F6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32C0xx/C011D6Y_C011F(4-6)(P-U)_C031F(4-6)P")
set(GENERIC_C011F6UX_MAXSIZE 32768)
set(GENERIC_C011F6UX_MAXDATASIZE 6144)
set(GENERIC_C011F6UX_MCU cortex-m0plus)
set(GENERIC_C011F6UX_FPCONF "-")
add_library(GENERIC_C011F6UX INTERFACE)
target_compile_options(GENERIC_C011F6UX INTERFACE
  "SHELL:-DSTM32C011xx  -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_C011F6UX_MCU}
)
target_compile_definitions(GENERIC_C011F6UX INTERFACE
  "STM32C0xx"
	"ARDUINO_GENERIC_C011F6UX"
	"BOARD_NAME=\"GENERIC_C011F6UX\""
	"BOARD_ID=GENERIC_C011F6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_C011F6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32C0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Source/Templates/gcc/
  ${GENERIC_C011F6UX_VARIANT_PATH}
)

target_link_options(GENERIC_C011F6UX INTERFACE
  "LINKER:--default-script=${GENERIC_C011F6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_C011F6UX_MCU}
)

add_library(GENERIC_C011F6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_C011F6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_C011F6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_C011F6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_C011F6UX_serial_none INTERFACE)
target_compile_options(GENERIC_C011F6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# GENERIC_C031C4TX
# -----------------------------------------------------------------------------

set(GENERIC_C031C4TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32C0xx/C031C(4-6)(T-U)")
set(GENERIC_C031C4TX_MAXSIZE 16384)
set(GENERIC_C031C4TX_MAXDATASIZE 12288)
set(GENERIC_C031C4TX_MCU cortex-m0plus)
set(GENERIC_C031C4TX_FPCONF "-")
add_library(GENERIC_C031C4TX INTERFACE)
target_compile_options(GENERIC_C031C4TX INTERFACE
  "SHELL:-DSTM32C031xx  -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_C031C4TX_MCU}
)
target_compile_definitions(GENERIC_C031C4TX INTERFACE
  "STM32C0xx"
	"ARDUINO_GENERIC_C031C4TX"
	"BOARD_NAME=\"GENERIC_C031C4TX\""
	"BOARD_ID=GENERIC_C031C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_C031C4TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32C0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Source/Templates/gcc/
  ${GENERIC_C031C4TX_VARIANT_PATH}
)

target_link_options(GENERIC_C031C4TX INTERFACE
  "LINKER:--default-script=${GENERIC_C031C4TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=12288"
  "SHELL: "
  -mcpu=${GENERIC_C031C4TX_MCU}
)

add_library(GENERIC_C031C4TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_C031C4TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_C031C4TX_serial_generic INTERFACE)
target_compile_options(GENERIC_C031C4TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_C031C4TX_serial_none INTERFACE)
target_compile_options(GENERIC_C031C4TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# GENERIC_C031C4UX
# -----------------------------------------------------------------------------

set(GENERIC_C031C4UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32C0xx/C031C(4-6)(T-U)")
set(GENERIC_C031C4UX_MAXSIZE 16384)
set(GENERIC_C031C4UX_MAXDATASIZE 12288)
set(GENERIC_C031C4UX_MCU cortex-m0plus)
set(GENERIC_C031C4UX_FPCONF "-")
add_library(GENERIC_C031C4UX INTERFACE)
target_compile_options(GENERIC_C031C4UX INTERFACE
  "SHELL:-DSTM32C031xx  -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_C031C4UX_MCU}
)
target_compile_definitions(GENERIC_C031C4UX INTERFACE
  "STM32C0xx"
	"ARDUINO_GENERIC_C031C4UX"
	"BOARD_NAME=\"GENERIC_C031C4UX\""
	"BOARD_ID=GENERIC_C031C4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_C031C4UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32C0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Source/Templates/gcc/
  ${GENERIC_C031C4UX_VARIANT_PATH}
)

target_link_options(GENERIC_C031C4UX INTERFACE
  "LINKER:--default-script=${GENERIC_C031C4UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=12288"
  "SHELL: "
  -mcpu=${GENERIC_C031C4UX_MCU}
)

add_library(GENERIC_C031C4UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_C031C4UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_C031C4UX_serial_generic INTERFACE)
target_compile_options(GENERIC_C031C4UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_C031C4UX_serial_none INTERFACE)
target_compile_options(GENERIC_C031C4UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# GENERIC_C031C6TX
# -----------------------------------------------------------------------------

set(GENERIC_C031C6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32C0xx/C031C(4-6)(T-U)")
set(GENERIC_C031C6TX_MAXSIZE 32768)
set(GENERIC_C031C6TX_MAXDATASIZE 12288)
set(GENERIC_C031C6TX_MCU cortex-m0plus)
set(GENERIC_C031C6TX_FPCONF "-")
add_library(GENERIC_C031C6TX INTERFACE)
target_compile_options(GENERIC_C031C6TX INTERFACE
  "SHELL:-DSTM32C031xx  -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_C031C6TX_MCU}
)
target_compile_definitions(GENERIC_C031C6TX INTERFACE
  "STM32C0xx"
	"ARDUINO_GENERIC_C031C6TX"
	"BOARD_NAME=\"GENERIC_C031C6TX\""
	"BOARD_ID=GENERIC_C031C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_C031C6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32C0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Source/Templates/gcc/
  ${GENERIC_C031C6TX_VARIANT_PATH}
)

target_link_options(GENERIC_C031C6TX INTERFACE
  "LINKER:--default-script=${GENERIC_C031C6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=12288"
  "SHELL: "
  -mcpu=${GENERIC_C031C6TX_MCU}
)

add_library(GENERIC_C031C6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_C031C6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_C031C6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_C031C6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_C031C6TX_serial_none INTERFACE)
target_compile_options(GENERIC_C031C6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# GENERIC_C031C6UX
# -----------------------------------------------------------------------------

set(GENERIC_C031C6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32C0xx/C031C(4-6)(T-U)")
set(GENERIC_C031C6UX_MAXSIZE 32768)
set(GENERIC_C031C6UX_MAXDATASIZE 12288)
set(GENERIC_C031C6UX_MCU cortex-m0plus)
set(GENERIC_C031C6UX_FPCONF "-")
add_library(GENERIC_C031C6UX INTERFACE)
target_compile_options(GENERIC_C031C6UX INTERFACE
  "SHELL:-DSTM32C031xx  -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_C031C6UX_MCU}
)
target_compile_definitions(GENERIC_C031C6UX INTERFACE
  "STM32C0xx"
	"ARDUINO_GENERIC_C031C6UX"
	"BOARD_NAME=\"GENERIC_C031C6UX\""
	"BOARD_ID=GENERIC_C031C6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_C031C6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32C0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Source/Templates/gcc/
  ${GENERIC_C031C6UX_VARIANT_PATH}
)

target_link_options(GENERIC_C031C6UX INTERFACE
  "LINKER:--default-script=${GENERIC_C031C6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=12288"
  "SHELL: "
  -mcpu=${GENERIC_C031C6UX_MCU}
)

add_library(GENERIC_C031C6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_C031C6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_C031C6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_C031C6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_C031C6UX_serial_none INTERFACE)
target_compile_options(GENERIC_C031C6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# GENERIC_C031F4PX
# -----------------------------------------------------------------------------

set(GENERIC_C031F4PX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32C0xx/C011D6Y_C011F(4-6)(P-U)_C031F(4-6)P")
set(GENERIC_C031F4PX_MAXSIZE 16384)
set(GENERIC_C031F4PX_MAXDATASIZE 12288)
set(GENERIC_C031F4PX_MCU cortex-m0plus)
set(GENERIC_C031F4PX_FPCONF "-")
add_library(GENERIC_C031F4PX INTERFACE)
target_compile_options(GENERIC_C031F4PX INTERFACE
  "SHELL:-DSTM32C031xx  -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_C031F4PX_MCU}
)
target_compile_definitions(GENERIC_C031F4PX INTERFACE
  "STM32C0xx"
	"ARDUINO_GENERIC_C031F4PX"
	"BOARD_NAME=\"GENERIC_C031F4PX\""
	"BOARD_ID=GENERIC_C031F4PX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_C031F4PX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32C0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Source/Templates/gcc/
  ${GENERIC_C031F4PX_VARIANT_PATH}
)

target_link_options(GENERIC_C031F4PX INTERFACE
  "LINKER:--default-script=${GENERIC_C031F4PX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=12288"
  "SHELL: "
  -mcpu=${GENERIC_C031F4PX_MCU}
)

add_library(GENERIC_C031F4PX_serial_disabled INTERFACE)
target_compile_options(GENERIC_C031F4PX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_C031F4PX_serial_generic INTERFACE)
target_compile_options(GENERIC_C031F4PX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_C031F4PX_serial_none INTERFACE)
target_compile_options(GENERIC_C031F4PX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# GENERIC_C031F6PX
# -----------------------------------------------------------------------------

set(GENERIC_C031F6PX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32C0xx/C011D6Y_C011F(4-6)(P-U)_C031F(4-6)P")
set(GENERIC_C031F6PX_MAXSIZE 32768)
set(GENERIC_C031F6PX_MAXDATASIZE 12288)
set(GENERIC_C031F6PX_MCU cortex-m0plus)
set(GENERIC_C031F6PX_FPCONF "-")
add_library(GENERIC_C031F6PX INTERFACE)
target_compile_options(GENERIC_C031F6PX INTERFACE
  "SHELL:-DSTM32C031xx  -D__CORTEX_SC=0"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_C031F6PX_MCU}
)
target_compile_definitions(GENERIC_C031F6PX INTERFACE
  "STM32C0xx"
	"ARDUINO_GENERIC_C031F6PX"
	"BOARD_NAME=\"GENERIC_C031F6PX\""
	"BOARD_ID=GENERIC_C031F6PX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_C031F6PX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32C0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32C0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32C0xx/Source/Templates/gcc/
  ${GENERIC_C031F6PX_VARIANT_PATH}
)

target_link_options(GENERIC_C031F6PX INTERFACE
  "LINKER:--default-script=${GENERIC_C031F6PX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=12288"
  "SHELL: "
  -mcpu=${GENERIC_C031F6PX_MCU}
)

add_library(GENERIC_C031F6PX_serial_disabled INTERFACE)
target_compile_options(GENERIC_C031F6PX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_C031F6PX_serial_generic INTERFACE)
target_compile_options(GENERIC_C031F6PX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_C031F6PX_serial_none INTERFACE)
target_compile_options(GENERIC_C031F6PX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)

# GENERIC_F030C6TX
# -----------------------------------------------------------------------------

set(GENERIC_F030C6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F030C6T")
set(GENERIC_F030C6TX_MAXSIZE 32768)
set(GENERIC_F030C6TX_MAXDATASIZE 4096)
set(GENERIC_F030C6TX_MCU cortex-m0)
set(GENERIC_F030C6TX_FPCONF "-")
add_library(GENERIC_F030C6TX INTERFACE)
target_compile_options(GENERIC_F030C6TX INTERFACE
  "SHELL:-DSTM32F030x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F030C6TX_MCU}
)
target_compile_definitions(GENERIC_F030C6TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F030C6TX"
	"BOARD_NAME=\"GENERIC_F030C6TX\""
	"BOARD_ID=GENERIC_F030C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F030C6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F030C6TX_VARIANT_PATH}
)

target_link_options(GENERIC_F030C6TX INTERFACE
  "LINKER:--default-script=${GENERIC_F030C6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F030C6TX_MCU}
)

add_library(GENERIC_F030C6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F030C6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F030C6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F030C6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F030C6TX_serial_none INTERFACE)
target_compile_options(GENERIC_F030C6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F030C6TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F030C6TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F030C6TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F030C6TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F030C6TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F030C6TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F030C6TX_usb_none INTERFACE)
target_compile_options(GENERIC_F030C6TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F030C8TX
# -----------------------------------------------------------------------------

set(GENERIC_F030C8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F030C8T")
set(GENERIC_F030C8TX_MAXSIZE 65536)
set(GENERIC_F030C8TX_MAXDATASIZE 8192)
set(GENERIC_F030C8TX_MCU cortex-m0)
set(GENERIC_F030C8TX_FPCONF "-")
add_library(GENERIC_F030C8TX INTERFACE)
target_compile_options(GENERIC_F030C8TX INTERFACE
  "SHELL:-DSTM32F030x8  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F030C8TX_MCU}
)
target_compile_definitions(GENERIC_F030C8TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F030C8TX"
	"BOARD_NAME=\"GENERIC_F030C8TX\""
	"BOARD_ID=GENERIC_F030C8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F030C8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F030C8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F030C8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F030C8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F030C8TX_MCU}
)

add_library(GENERIC_F030C8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F030C8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F030C8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F030C8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F030C8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F030C8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F030C8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F030C8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F030C8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F030C8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F030C8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F030C8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F030C8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F030C8TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F030F4PX
# -----------------------------------------------------------------------------

set(GENERIC_F030F4PX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F030F4P")
set(GENERIC_F030F4PX_MAXSIZE 16384)
set(GENERIC_F030F4PX_MAXDATASIZE 4096)
set(GENERIC_F030F4PX_MCU cortex-m0)
set(GENERIC_F030F4PX_FPCONF "-")
add_library(GENERIC_F030F4PX INTERFACE)
target_compile_options(GENERIC_F030F4PX INTERFACE
  "SHELL:-DSTM32F030x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F030F4PX_MCU}
)
target_compile_definitions(GENERIC_F030F4PX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F030F4PX"
	"BOARD_NAME=\"GENERIC_F030F4PX\""
	"BOARD_ID=GENERIC_F030F4PX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F030F4PX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F030F4PX_VARIANT_PATH}
)

target_link_options(GENERIC_F030F4PX INTERFACE
  "LINKER:--default-script=${GENERIC_F030F4PX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F030F4PX_MCU}
)

add_library(GENERIC_F030F4PX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F030F4PX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F030F4PX_serial_generic INTERFACE)
target_compile_options(GENERIC_F030F4PX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F030F4PX_serial_none INTERFACE)
target_compile_options(GENERIC_F030F4PX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F030F4PX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F030F4PX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F030F4PX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F030F4PX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F030F4PX_usb_HID INTERFACE)
target_compile_options(GENERIC_F030F4PX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F030F4PX_usb_none INTERFACE)
target_compile_options(GENERIC_F030F4PX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F030K6TX
# -----------------------------------------------------------------------------

set(GENERIC_F030K6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F030K6T")
set(GENERIC_F030K6TX_MAXSIZE 32768)
set(GENERIC_F030K6TX_MAXDATASIZE 4096)
set(GENERIC_F030K6TX_MCU cortex-m0)
set(GENERIC_F030K6TX_FPCONF "-")
add_library(GENERIC_F030K6TX INTERFACE)
target_compile_options(GENERIC_F030K6TX INTERFACE
  "SHELL:-DSTM32F030x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F030K6TX_MCU}
)
target_compile_definitions(GENERIC_F030K6TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F030K6TX"
	"BOARD_NAME=\"GENERIC_F030K6TX\""
	"BOARD_ID=GENERIC_F030K6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F030K6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F030K6TX_VARIANT_PATH}
)

target_link_options(GENERIC_F030K6TX INTERFACE
  "LINKER:--default-script=${GENERIC_F030K6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F030K6TX_MCU}
)

add_library(GENERIC_F030K6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F030K6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F030K6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F030K6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F030K6TX_serial_none INTERFACE)
target_compile_options(GENERIC_F030K6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F030K6TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F030K6TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F030K6TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F030K6TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F030K6TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F030K6TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F030K6TX_usb_none INTERFACE)
target_compile_options(GENERIC_F030K6TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F030R8TX
# -----------------------------------------------------------------------------

set(GENERIC_F030R8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F030R8T")
set(GENERIC_F030R8TX_MAXSIZE 65536)
set(GENERIC_F030R8TX_MAXDATASIZE 8192)
set(GENERIC_F030R8TX_MCU cortex-m0)
set(GENERIC_F030R8TX_FPCONF "-")
add_library(GENERIC_F030R8TX INTERFACE)
target_compile_options(GENERIC_F030R8TX INTERFACE
  "SHELL:-DSTM32F030x8  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F030R8TX_MCU}
)
target_compile_definitions(GENERIC_F030R8TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F030R8TX"
	"BOARD_NAME=\"GENERIC_F030R8TX\""
	"BOARD_ID=GENERIC_F030R8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F030R8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F030R8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F030R8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F030R8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F030R8TX_MCU}
)

add_library(GENERIC_F030R8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F030R8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F030R8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F030R8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F030R8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F030R8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F030R8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F030R8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F030R8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F030R8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F030R8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F030R8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F030R8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F030R8TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F031C4TX
# -----------------------------------------------------------------------------

set(GENERIC_F031C4TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F031C(4-6)T")
set(GENERIC_F031C4TX_MAXSIZE 16384)
set(GENERIC_F031C4TX_MAXDATASIZE 4096)
set(GENERIC_F031C4TX_MCU cortex-m0)
set(GENERIC_F031C4TX_FPCONF "-")
add_library(GENERIC_F031C4TX INTERFACE)
target_compile_options(GENERIC_F031C4TX INTERFACE
  "SHELL:-DSTM32F031x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F031C4TX_MCU}
)
target_compile_definitions(GENERIC_F031C4TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F031C4TX"
	"BOARD_NAME=\"GENERIC_F031C4TX\""
	"BOARD_ID=GENERIC_F031C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F031C4TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F031C4TX_VARIANT_PATH}
)

target_link_options(GENERIC_F031C4TX INTERFACE
  "LINKER:--default-script=${GENERIC_F031C4TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F031C4TX_MCU}
)

add_library(GENERIC_F031C4TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F031C4TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F031C4TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F031C4TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F031C4TX_serial_none INTERFACE)
target_compile_options(GENERIC_F031C4TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F031C4TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F031C4TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F031C4TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F031C4TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F031C4TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F031C4TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F031C4TX_usb_none INTERFACE)
target_compile_options(GENERIC_F031C4TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F031C6TX
# -----------------------------------------------------------------------------

set(GENERIC_F031C6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F031C(4-6)T")
set(GENERIC_F031C6TX_MAXSIZE 32768)
set(GENERIC_F031C6TX_MAXDATASIZE 4096)
set(GENERIC_F031C6TX_MCU cortex-m0)
set(GENERIC_F031C6TX_FPCONF "-")
add_library(GENERIC_F031C6TX INTERFACE)
target_compile_options(GENERIC_F031C6TX INTERFACE
  "SHELL:-DSTM32F031x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F031C6TX_MCU}
)
target_compile_definitions(GENERIC_F031C6TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F031C6TX"
	"BOARD_NAME=\"GENERIC_F031C6TX\""
	"BOARD_ID=GENERIC_F031C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F031C6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F031C6TX_VARIANT_PATH}
)

target_link_options(GENERIC_F031C6TX INTERFACE
  "LINKER:--default-script=${GENERIC_F031C6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F031C6TX_MCU}
)

add_library(GENERIC_F031C6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F031C6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F031C6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F031C6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F031C6TX_serial_none INTERFACE)
target_compile_options(GENERIC_F031C6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F031C6TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F031C6TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F031C6TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F031C6TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F031C6TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F031C6TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F031C6TX_usb_none INTERFACE)
target_compile_options(GENERIC_F031C6TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F031E6YX
# -----------------------------------------------------------------------------

set(GENERIC_F031E6YX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F031E6Y_F038E6Y")
set(GENERIC_F031E6YX_MAXSIZE 32768)
set(GENERIC_F031E6YX_MAXDATASIZE 4096)
set(GENERIC_F031E6YX_MCU cortex-m0)
set(GENERIC_F031E6YX_FPCONF "-")
add_library(GENERIC_F031E6YX INTERFACE)
target_compile_options(GENERIC_F031E6YX INTERFACE
  "SHELL:-DSTM32F031x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F031E6YX_MCU}
)
target_compile_definitions(GENERIC_F031E6YX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F031E6YX"
	"BOARD_NAME=\"GENERIC_F031E6YX\""
	"BOARD_ID=GENERIC_F031E6YX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F031E6YX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F031E6YX_VARIANT_PATH}
)

target_link_options(GENERIC_F031E6YX INTERFACE
  "LINKER:--default-script=${GENERIC_F031E6YX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F031E6YX_MCU}
)

add_library(GENERIC_F031E6YX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F031E6YX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F031E6YX_serial_generic INTERFACE)
target_compile_options(GENERIC_F031E6YX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F031E6YX_serial_none INTERFACE)
target_compile_options(GENERIC_F031E6YX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F031E6YX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F031E6YX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F031E6YX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F031E6YX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F031E6YX_usb_HID INTERFACE)
target_compile_options(GENERIC_F031E6YX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F031E6YX_usb_none INTERFACE)
target_compile_options(GENERIC_F031E6YX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F031F4PX
# -----------------------------------------------------------------------------

set(GENERIC_F031F4PX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F031F(4-6)P")
set(GENERIC_F031F4PX_MAXSIZE 16384)
set(GENERIC_F031F4PX_MAXDATASIZE 4096)
set(GENERIC_F031F4PX_MCU cortex-m0)
set(GENERIC_F031F4PX_FPCONF "-")
add_library(GENERIC_F031F4PX INTERFACE)
target_compile_options(GENERIC_F031F4PX INTERFACE
  "SHELL:-DSTM32F031x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F031F4PX_MCU}
)
target_compile_definitions(GENERIC_F031F4PX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F031F4PX"
	"BOARD_NAME=\"GENERIC_F031F4PX\""
	"BOARD_ID=GENERIC_F031F4PX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F031F4PX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F031F4PX_VARIANT_PATH}
)

target_link_options(GENERIC_F031F4PX INTERFACE
  "LINKER:--default-script=${GENERIC_F031F4PX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F031F4PX_MCU}
)

add_library(GENERIC_F031F4PX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F031F4PX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F031F4PX_serial_generic INTERFACE)
target_compile_options(GENERIC_F031F4PX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F031F4PX_serial_none INTERFACE)
target_compile_options(GENERIC_F031F4PX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F031F4PX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F031F4PX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F031F4PX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F031F4PX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F031F4PX_usb_HID INTERFACE)
target_compile_options(GENERIC_F031F4PX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F031F4PX_usb_none INTERFACE)
target_compile_options(GENERIC_F031F4PX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F031F6PX
# -----------------------------------------------------------------------------

set(GENERIC_F031F6PX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F031F(4-6)P")
set(GENERIC_F031F6PX_MAXSIZE 32768)
set(GENERIC_F031F6PX_MAXDATASIZE 4096)
set(GENERIC_F031F6PX_MCU cortex-m0)
set(GENERIC_F031F6PX_FPCONF "-")
add_library(GENERIC_F031F6PX INTERFACE)
target_compile_options(GENERIC_F031F6PX INTERFACE
  "SHELL:-DSTM32F031x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F031F6PX_MCU}
)
target_compile_definitions(GENERIC_F031F6PX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F031F6PX"
	"BOARD_NAME=\"GENERIC_F031F6PX\""
	"BOARD_ID=GENERIC_F031F6PX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F031F6PX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F031F6PX_VARIANT_PATH}
)

target_link_options(GENERIC_F031F6PX INTERFACE
  "LINKER:--default-script=${GENERIC_F031F6PX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F031F6PX_MCU}
)

add_library(GENERIC_F031F6PX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F031F6PX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F031F6PX_serial_generic INTERFACE)
target_compile_options(GENERIC_F031F6PX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F031F6PX_serial_none INTERFACE)
target_compile_options(GENERIC_F031F6PX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F031F6PX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F031F6PX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F031F6PX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F031F6PX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F031F6PX_usb_HID INTERFACE)
target_compile_options(GENERIC_F031F6PX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F031F6PX_usb_none INTERFACE)
target_compile_options(GENERIC_F031F6PX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F031G4UX
# -----------------------------------------------------------------------------

set(GENERIC_F031G4UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F031G(4-6)U")
set(GENERIC_F031G4UX_MAXSIZE 16384)
set(GENERIC_F031G4UX_MAXDATASIZE 4096)
set(GENERIC_F031G4UX_MCU cortex-m0)
set(GENERIC_F031G4UX_FPCONF "-")
add_library(GENERIC_F031G4UX INTERFACE)
target_compile_options(GENERIC_F031G4UX INTERFACE
  "SHELL:-DSTM32F031x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F031G4UX_MCU}
)
target_compile_definitions(GENERIC_F031G4UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F031G4UX"
	"BOARD_NAME=\"GENERIC_F031G4UX\""
	"BOARD_ID=GENERIC_F031G4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F031G4UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F031G4UX_VARIANT_PATH}
)

target_link_options(GENERIC_F031G4UX INTERFACE
  "LINKER:--default-script=${GENERIC_F031G4UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F031G4UX_MCU}
)

add_library(GENERIC_F031G4UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F031G4UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F031G4UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F031G4UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F031G4UX_serial_none INTERFACE)
target_compile_options(GENERIC_F031G4UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F031G4UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F031G4UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F031G4UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F031G4UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F031G4UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F031G4UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F031G4UX_usb_none INTERFACE)
target_compile_options(GENERIC_F031G4UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F031G6UX
# -----------------------------------------------------------------------------

set(GENERIC_F031G6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F031G(4-6)U")
set(GENERIC_F031G6UX_MAXSIZE 32768)
set(GENERIC_F031G6UX_MAXDATASIZE 4096)
set(GENERIC_F031G6UX_MCU cortex-m0)
set(GENERIC_F031G6UX_FPCONF "-")
add_library(GENERIC_F031G6UX INTERFACE)
target_compile_options(GENERIC_F031G6UX INTERFACE
  "SHELL:-DSTM32F031x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F031G6UX_MCU}
)
target_compile_definitions(GENERIC_F031G6UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F031G6UX"
	"BOARD_NAME=\"GENERIC_F031G6UX\""
	"BOARD_ID=GENERIC_F031G6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F031G6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F031G6UX_VARIANT_PATH}
)

target_link_options(GENERIC_F031G6UX INTERFACE
  "LINKER:--default-script=${GENERIC_F031G6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F031G6UX_MCU}
)

add_library(GENERIC_F031G6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F031G6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F031G6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F031G6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F031G6UX_serial_none INTERFACE)
target_compile_options(GENERIC_F031G6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F031G6UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F031G6UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F031G6UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F031G6UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F031G6UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F031G6UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F031G6UX_usb_none INTERFACE)
target_compile_options(GENERIC_F031G6UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F031K4UX
# -----------------------------------------------------------------------------

set(GENERIC_F031K4UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F031K(4-6)U")
set(GENERIC_F031K4UX_MAXSIZE 16384)
set(GENERIC_F031K4UX_MAXDATASIZE 4096)
set(GENERIC_F031K4UX_MCU cortex-m0)
set(GENERIC_F031K4UX_FPCONF "-")
add_library(GENERIC_F031K4UX INTERFACE)
target_compile_options(GENERIC_F031K4UX INTERFACE
  "SHELL:-DSTM32F031x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F031K4UX_MCU}
)
target_compile_definitions(GENERIC_F031K4UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F031K4UX"
	"BOARD_NAME=\"GENERIC_F031K4UX\""
	"BOARD_ID=GENERIC_F031K4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F031K4UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F031K4UX_VARIANT_PATH}
)

target_link_options(GENERIC_F031K4UX INTERFACE
  "LINKER:--default-script=${GENERIC_F031K4UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F031K4UX_MCU}
)

add_library(GENERIC_F031K4UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F031K4UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F031K4UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F031K4UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F031K4UX_serial_none INTERFACE)
target_compile_options(GENERIC_F031K4UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F031K4UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F031K4UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F031K4UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F031K4UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F031K4UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F031K4UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F031K4UX_usb_none INTERFACE)
target_compile_options(GENERIC_F031K4UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F031K6TX
# -----------------------------------------------------------------------------

set(GENERIC_F031K6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F031K6T")
set(GENERIC_F031K6TX_MAXSIZE 32768)
set(GENERIC_F031K6TX_MAXDATASIZE 4096)
set(GENERIC_F031K6TX_MCU cortex-m0)
set(GENERIC_F031K6TX_FPCONF "-")
add_library(GENERIC_F031K6TX INTERFACE)
target_compile_options(GENERIC_F031K6TX INTERFACE
  "SHELL:-DSTM32F031x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F031K6TX_MCU}
)
target_compile_definitions(GENERIC_F031K6TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F031K6TX"
	"BOARD_NAME=\"GENERIC_F031K6TX\""
	"BOARD_ID=GENERIC_F031K6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F031K6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F031K6TX_VARIANT_PATH}
)

target_link_options(GENERIC_F031K6TX INTERFACE
  "LINKER:--default-script=${GENERIC_F031K6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F031K6TX_MCU}
)

add_library(GENERIC_F031K6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F031K6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F031K6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F031K6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F031K6TX_serial_none INTERFACE)
target_compile_options(GENERIC_F031K6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F031K6TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F031K6TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F031K6TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F031K6TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F031K6TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F031K6TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F031K6TX_usb_none INTERFACE)
target_compile_options(GENERIC_F031K6TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F031K6UX
# -----------------------------------------------------------------------------

set(GENERIC_F031K6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F031K(4-6)U")
set(GENERIC_F031K6UX_MAXSIZE 32768)
set(GENERIC_F031K6UX_MAXDATASIZE 4096)
set(GENERIC_F031K6UX_MCU cortex-m0)
set(GENERIC_F031K6UX_FPCONF "-")
add_library(GENERIC_F031K6UX INTERFACE)
target_compile_options(GENERIC_F031K6UX INTERFACE
  "SHELL:-DSTM32F031x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F031K6UX_MCU}
)
target_compile_definitions(GENERIC_F031K6UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F031K6UX"
	"BOARD_NAME=\"GENERIC_F031K6UX\""
	"BOARD_ID=GENERIC_F031K6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F031K6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F031K6UX_VARIANT_PATH}
)

target_link_options(GENERIC_F031K6UX INTERFACE
  "LINKER:--default-script=${GENERIC_F031K6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F031K6UX_MCU}
)

add_library(GENERIC_F031K6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F031K6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F031K6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F031K6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F031K6UX_serial_none INTERFACE)
target_compile_options(GENERIC_F031K6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F031K6UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F031K6UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F031K6UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F031K6UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F031K6UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F031K6UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F031K6UX_usb_none INTERFACE)
target_compile_options(GENERIC_F031K6UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F038C6TX
# -----------------------------------------------------------------------------

set(GENERIC_F038C6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F038C6T")
set(GENERIC_F038C6TX_MAXSIZE 32768)
set(GENERIC_F038C6TX_MAXDATASIZE 4096)
set(GENERIC_F038C6TX_MCU cortex-m0)
set(GENERIC_F038C6TX_FPCONF "-")
add_library(GENERIC_F038C6TX INTERFACE)
target_compile_options(GENERIC_F038C6TX INTERFACE
  "SHELL:-DSTM32F038xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F038C6TX_MCU}
)
target_compile_definitions(GENERIC_F038C6TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F038C6TX"
	"BOARD_NAME=\"GENERIC_F038C6TX\""
	"BOARD_ID=GENERIC_F038C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F038C6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F038C6TX_VARIANT_PATH}
)

target_link_options(GENERIC_F038C6TX INTERFACE
  "LINKER:--default-script=${GENERIC_F038C6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F038C6TX_MCU}
)

add_library(GENERIC_F038C6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F038C6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F038C6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F038C6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F038C6TX_serial_none INTERFACE)
target_compile_options(GENERIC_F038C6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F038C6TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F038C6TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F038C6TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F038C6TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F038C6TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F038C6TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F038C6TX_usb_none INTERFACE)
target_compile_options(GENERIC_F038C6TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F038E6YX
# -----------------------------------------------------------------------------

set(GENERIC_F038E6YX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F031E6Y_F038E6Y")
set(GENERIC_F038E6YX_MAXSIZE 32768)
set(GENERIC_F038E6YX_MAXDATASIZE 4096)
set(GENERIC_F038E6YX_MCU cortex-m0)
set(GENERIC_F038E6YX_FPCONF "-")
add_library(GENERIC_F038E6YX INTERFACE)
target_compile_options(GENERIC_F038E6YX INTERFACE
  "SHELL:-DSTM32F038xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F038E6YX_MCU}
)
target_compile_definitions(GENERIC_F038E6YX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F038E6YX"
	"BOARD_NAME=\"GENERIC_F038E6YX\""
	"BOARD_ID=GENERIC_F038E6YX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F038E6YX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F038E6YX_VARIANT_PATH}
)

target_link_options(GENERIC_F038E6YX INTERFACE
  "LINKER:--default-script=${GENERIC_F038E6YX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F038E6YX_MCU}
)

add_library(GENERIC_F038E6YX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F038E6YX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F038E6YX_serial_generic INTERFACE)
target_compile_options(GENERIC_F038E6YX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F038E6YX_serial_none INTERFACE)
target_compile_options(GENERIC_F038E6YX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F038E6YX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F038E6YX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F038E6YX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F038E6YX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F038E6YX_usb_HID INTERFACE)
target_compile_options(GENERIC_F038E6YX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F038E6YX_usb_none INTERFACE)
target_compile_options(GENERIC_F038E6YX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F038F6PX
# -----------------------------------------------------------------------------

set(GENERIC_F038F6PX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F038F6P")
set(GENERIC_F038F6PX_MAXSIZE 32768)
set(GENERIC_F038F6PX_MAXDATASIZE 4096)
set(GENERIC_F038F6PX_MCU cortex-m0)
set(GENERIC_F038F6PX_FPCONF "-")
add_library(GENERIC_F038F6PX INTERFACE)
target_compile_options(GENERIC_F038F6PX INTERFACE
  "SHELL:-DSTM32F038xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F038F6PX_MCU}
)
target_compile_definitions(GENERIC_F038F6PX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F038F6PX"
	"BOARD_NAME=\"GENERIC_F038F6PX\""
	"BOARD_ID=GENERIC_F038F6PX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F038F6PX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F038F6PX_VARIANT_PATH}
)

target_link_options(GENERIC_F038F6PX INTERFACE
  "LINKER:--default-script=${GENERIC_F038F6PX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F038F6PX_MCU}
)

add_library(GENERIC_F038F6PX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F038F6PX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F038F6PX_serial_generic INTERFACE)
target_compile_options(GENERIC_F038F6PX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F038F6PX_serial_none INTERFACE)
target_compile_options(GENERIC_F038F6PX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F038F6PX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F038F6PX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F038F6PX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F038F6PX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F038F6PX_usb_HID INTERFACE)
target_compile_options(GENERIC_F038F6PX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F038F6PX_usb_none INTERFACE)
target_compile_options(GENERIC_F038F6PX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F038G6UX
# -----------------------------------------------------------------------------

set(GENERIC_F038G6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F038G6U")
set(GENERIC_F038G6UX_MAXSIZE 32768)
set(GENERIC_F038G6UX_MAXDATASIZE 4096)
set(GENERIC_F038G6UX_MCU cortex-m0)
set(GENERIC_F038G6UX_FPCONF "-")
add_library(GENERIC_F038G6UX INTERFACE)
target_compile_options(GENERIC_F038G6UX INTERFACE
  "SHELL:-DSTM32F038xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F038G6UX_MCU}
)
target_compile_definitions(GENERIC_F038G6UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F038G6UX"
	"BOARD_NAME=\"GENERIC_F038G6UX\""
	"BOARD_ID=GENERIC_F038G6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F038G6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F038G6UX_VARIANT_PATH}
)

target_link_options(GENERIC_F038G6UX INTERFACE
  "LINKER:--default-script=${GENERIC_F038G6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F038G6UX_MCU}
)

add_library(GENERIC_F038G6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F038G6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F038G6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F038G6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F038G6UX_serial_none INTERFACE)
target_compile_options(GENERIC_F038G6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F038G6UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F038G6UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F038G6UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F038G6UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F038G6UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F038G6UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F038G6UX_usb_none INTERFACE)
target_compile_options(GENERIC_F038G6UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F038K6UX
# -----------------------------------------------------------------------------

set(GENERIC_F038K6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F038K6U")
set(GENERIC_F038K6UX_MAXSIZE 32768)
set(GENERIC_F038K6UX_MAXDATASIZE 4096)
set(GENERIC_F038K6UX_MCU cortex-m0)
set(GENERIC_F038K6UX_FPCONF "-")
add_library(GENERIC_F038K6UX INTERFACE)
target_compile_options(GENERIC_F038K6UX INTERFACE
  "SHELL:-DSTM32F038xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F038K6UX_MCU}
)
target_compile_definitions(GENERIC_F038K6UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F038K6UX"
	"BOARD_NAME=\"GENERIC_F038K6UX\""
	"BOARD_ID=GENERIC_F038K6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F038K6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F038K6UX_VARIANT_PATH}
)

target_link_options(GENERIC_F038K6UX INTERFACE
  "LINKER:--default-script=${GENERIC_F038K6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F038K6UX_MCU}
)

add_library(GENERIC_F038K6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F038K6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F038K6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F038K6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F038K6UX_serial_none INTERFACE)
target_compile_options(GENERIC_F038K6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F038K6UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F038K6UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F038K6UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F038K6UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F038K6UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F038K6UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F038K6UX_usb_none INTERFACE)
target_compile_options(GENERIC_F038K6UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F042C4TX
# -----------------------------------------------------------------------------

set(GENERIC_F042C4TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F042C(4-6)(T-U)")
set(GENERIC_F042C4TX_MAXSIZE 16384)
set(GENERIC_F042C4TX_MAXDATASIZE 6144)
set(GENERIC_F042C4TX_MCU cortex-m0)
set(GENERIC_F042C4TX_FPCONF "-")
add_library(GENERIC_F042C4TX INTERFACE)
target_compile_options(GENERIC_F042C4TX INTERFACE
  "SHELL:-DSTM32F042x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F042C4TX_MCU}
)
target_compile_definitions(GENERIC_F042C4TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F042C4TX"
	"BOARD_NAME=\"GENERIC_F042C4TX\""
	"BOARD_ID=GENERIC_F042C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F042C4TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F042C4TX_VARIANT_PATH}
)

target_link_options(GENERIC_F042C4TX INTERFACE
  "LINKER:--default-script=${GENERIC_F042C4TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F042C4TX_MCU}
)

add_library(GENERIC_F042C4TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F042C4TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F042C4TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F042C4TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F042C4TX_serial_none INTERFACE)
target_compile_options(GENERIC_F042C4TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F042C4TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F042C4TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F042C4TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F042C4TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F042C4TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F042C4TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F042C4TX_usb_none INTERFACE)
target_compile_options(GENERIC_F042C4TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F042C4UX
# -----------------------------------------------------------------------------

set(GENERIC_F042C4UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F042C(4-6)(T-U)")
set(GENERIC_F042C4UX_MAXSIZE 16384)
set(GENERIC_F042C4UX_MAXDATASIZE 6144)
set(GENERIC_F042C4UX_MCU cortex-m0)
set(GENERIC_F042C4UX_FPCONF "-")
add_library(GENERIC_F042C4UX INTERFACE)
target_compile_options(GENERIC_F042C4UX INTERFACE
  "SHELL:-DSTM32F042x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F042C4UX_MCU}
)
target_compile_definitions(GENERIC_F042C4UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F042C4UX"
	"BOARD_NAME=\"GENERIC_F042C4UX\""
	"BOARD_ID=GENERIC_F042C4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F042C4UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F042C4UX_VARIANT_PATH}
)

target_link_options(GENERIC_F042C4UX INTERFACE
  "LINKER:--default-script=${GENERIC_F042C4UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F042C4UX_MCU}
)

add_library(GENERIC_F042C4UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F042C4UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F042C4UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F042C4UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F042C4UX_serial_none INTERFACE)
target_compile_options(GENERIC_F042C4UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F042C4UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F042C4UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F042C4UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F042C4UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F042C4UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F042C4UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F042C4UX_usb_none INTERFACE)
target_compile_options(GENERIC_F042C4UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F042C6TX
# -----------------------------------------------------------------------------

set(GENERIC_F042C6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F042C(4-6)(T-U)")
set(GENERIC_F042C6TX_MAXSIZE 32768)
set(GENERIC_F042C6TX_MAXDATASIZE 6144)
set(GENERIC_F042C6TX_MCU cortex-m0)
set(GENERIC_F042C6TX_FPCONF "-")
add_library(GENERIC_F042C6TX INTERFACE)
target_compile_options(GENERIC_F042C6TX INTERFACE
  "SHELL:-DSTM32F042x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F042C6TX_MCU}
)
target_compile_definitions(GENERIC_F042C6TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F042C6TX"
	"BOARD_NAME=\"GENERIC_F042C6TX\""
	"BOARD_ID=GENERIC_F042C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F042C6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F042C6TX_VARIANT_PATH}
)

target_link_options(GENERIC_F042C6TX INTERFACE
  "LINKER:--default-script=${GENERIC_F042C6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F042C6TX_MCU}
)

add_library(GENERIC_F042C6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F042C6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F042C6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F042C6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F042C6TX_serial_none INTERFACE)
target_compile_options(GENERIC_F042C6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F042C6TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F042C6TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F042C6TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F042C6TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F042C6TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F042C6TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F042C6TX_usb_none INTERFACE)
target_compile_options(GENERIC_F042C6TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F042C6UX
# -----------------------------------------------------------------------------

set(GENERIC_F042C6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F042C(4-6)(T-U)")
set(GENERIC_F042C6UX_MAXSIZE 32768)
set(GENERIC_F042C6UX_MAXDATASIZE 6144)
set(GENERIC_F042C6UX_MCU cortex-m0)
set(GENERIC_F042C6UX_FPCONF "-")
add_library(GENERIC_F042C6UX INTERFACE)
target_compile_options(GENERIC_F042C6UX INTERFACE
  "SHELL:-DSTM32F042x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F042C6UX_MCU}
)
target_compile_definitions(GENERIC_F042C6UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F042C6UX"
	"BOARD_NAME=\"GENERIC_F042C6UX\""
	"BOARD_ID=GENERIC_F042C6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F042C6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F042C6UX_VARIANT_PATH}
)

target_link_options(GENERIC_F042C6UX INTERFACE
  "LINKER:--default-script=${GENERIC_F042C6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F042C6UX_MCU}
)

add_library(GENERIC_F042C6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F042C6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F042C6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F042C6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F042C6UX_serial_none INTERFACE)
target_compile_options(GENERIC_F042C6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F042C6UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F042C6UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F042C6UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F042C6UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F042C6UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F042C6UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F042C6UX_usb_none INTERFACE)
target_compile_options(GENERIC_F042C6UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F042F4PX
# -----------------------------------------------------------------------------

set(GENERIC_F042F4PX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F042F(4-6)P")
set(GENERIC_F042F4PX_MAXSIZE 16384)
set(GENERIC_F042F4PX_MAXDATASIZE 6144)
set(GENERIC_F042F4PX_MCU cortex-m0)
set(GENERIC_F042F4PX_FPCONF "-")
add_library(GENERIC_F042F4PX INTERFACE)
target_compile_options(GENERIC_F042F4PX INTERFACE
  "SHELL:-DSTM32F042x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F042F4PX_MCU}
)
target_compile_definitions(GENERIC_F042F4PX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F042F4PX"
	"BOARD_NAME=\"GENERIC_F042F4PX\""
	"BOARD_ID=GENERIC_F042F4PX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F042F4PX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F042F4PX_VARIANT_PATH}
)

target_link_options(GENERIC_F042F4PX INTERFACE
  "LINKER:--default-script=${GENERIC_F042F4PX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F042F4PX_MCU}
)

add_library(GENERIC_F042F4PX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F042F4PX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F042F4PX_serial_generic INTERFACE)
target_compile_options(GENERIC_F042F4PX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F042F4PX_serial_none INTERFACE)
target_compile_options(GENERIC_F042F4PX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F042F4PX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F042F4PX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F042F4PX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F042F4PX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F042F4PX_usb_HID INTERFACE)
target_compile_options(GENERIC_F042F4PX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F042F4PX_usb_none INTERFACE)
target_compile_options(GENERIC_F042F4PX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F042F6PX
# -----------------------------------------------------------------------------

set(GENERIC_F042F6PX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F042F(4-6)P")
set(GENERIC_F042F6PX_MAXSIZE 32768)
set(GENERIC_F042F6PX_MAXDATASIZE 6144)
set(GENERIC_F042F6PX_MCU cortex-m0)
set(GENERIC_F042F6PX_FPCONF "-")
add_library(GENERIC_F042F6PX INTERFACE)
target_compile_options(GENERIC_F042F6PX INTERFACE
  "SHELL:-DSTM32F042x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F042F6PX_MCU}
)
target_compile_definitions(GENERIC_F042F6PX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F042F6PX"
	"BOARD_NAME=\"GENERIC_F042F6PX\""
	"BOARD_ID=GENERIC_F042F6PX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F042F6PX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F042F6PX_VARIANT_PATH}
)

target_link_options(GENERIC_F042F6PX INTERFACE
  "LINKER:--default-script=${GENERIC_F042F6PX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F042F6PX_MCU}
)

add_library(GENERIC_F042F6PX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F042F6PX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F042F6PX_serial_generic INTERFACE)
target_compile_options(GENERIC_F042F6PX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F042F6PX_serial_none INTERFACE)
target_compile_options(GENERIC_F042F6PX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F042F6PX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F042F6PX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F042F6PX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F042F6PX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F042F6PX_usb_HID INTERFACE)
target_compile_options(GENERIC_F042F6PX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F042F6PX_usb_none INTERFACE)
target_compile_options(GENERIC_F042F6PX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F042G4UX
# -----------------------------------------------------------------------------

set(GENERIC_F042G4UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F042G(4-6)U")
set(GENERIC_F042G4UX_MAXSIZE 16384)
set(GENERIC_F042G4UX_MAXDATASIZE 6144)
set(GENERIC_F042G4UX_MCU cortex-m0)
set(GENERIC_F042G4UX_FPCONF "-")
add_library(GENERIC_F042G4UX INTERFACE)
target_compile_options(GENERIC_F042G4UX INTERFACE
  "SHELL:-DSTM32F042x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F042G4UX_MCU}
)
target_compile_definitions(GENERIC_F042G4UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F042G4UX"
	"BOARD_NAME=\"GENERIC_F042G4UX\""
	"BOARD_ID=GENERIC_F042G4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F042G4UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F042G4UX_VARIANT_PATH}
)

target_link_options(GENERIC_F042G4UX INTERFACE
  "LINKER:--default-script=${GENERIC_F042G4UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F042G4UX_MCU}
)

add_library(GENERIC_F042G4UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F042G4UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F042G4UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F042G4UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F042G4UX_serial_none INTERFACE)
target_compile_options(GENERIC_F042G4UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F042G4UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F042G4UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F042G4UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F042G4UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F042G4UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F042G4UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F042G4UX_usb_none INTERFACE)
target_compile_options(GENERIC_F042G4UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F042G6UX
# -----------------------------------------------------------------------------

set(GENERIC_F042G6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F042G(4-6)U")
set(GENERIC_F042G6UX_MAXSIZE 32768)
set(GENERIC_F042G6UX_MAXDATASIZE 6144)
set(GENERIC_F042G6UX_MCU cortex-m0)
set(GENERIC_F042G6UX_FPCONF "-")
add_library(GENERIC_F042G6UX INTERFACE)
target_compile_options(GENERIC_F042G6UX INTERFACE
  "SHELL:-DSTM32F042x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F042G6UX_MCU}
)
target_compile_definitions(GENERIC_F042G6UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F042G6UX"
	"BOARD_NAME=\"GENERIC_F042G6UX\""
	"BOARD_ID=GENERIC_F042G6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F042G6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F042G6UX_VARIANT_PATH}
)

target_link_options(GENERIC_F042G6UX INTERFACE
  "LINKER:--default-script=${GENERIC_F042G6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F042G6UX_MCU}
)

add_library(GENERIC_F042G6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F042G6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F042G6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F042G6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F042G6UX_serial_none INTERFACE)
target_compile_options(GENERIC_F042G6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F042G6UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F042G6UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F042G6UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F042G6UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F042G6UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F042G6UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F042G6UX_usb_none INTERFACE)
target_compile_options(GENERIC_F042G6UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F042K4TX
# -----------------------------------------------------------------------------

set(GENERIC_F042K4TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F042K(4-6)T")
set(GENERIC_F042K4TX_MAXSIZE 16384)
set(GENERIC_F042K4TX_MAXDATASIZE 6144)
set(GENERIC_F042K4TX_MCU cortex-m0)
set(GENERIC_F042K4TX_FPCONF "-")
add_library(GENERIC_F042K4TX INTERFACE)
target_compile_options(GENERIC_F042K4TX INTERFACE
  "SHELL:-DSTM32F042x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F042K4TX_MCU}
)
target_compile_definitions(GENERIC_F042K4TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F042K4TX"
	"BOARD_NAME=\"GENERIC_F042K4TX\""
	"BOARD_ID=GENERIC_F042K4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F042K4TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F042K4TX_VARIANT_PATH}
)

target_link_options(GENERIC_F042K4TX INTERFACE
  "LINKER:--default-script=${GENERIC_F042K4TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F042K4TX_MCU}
)

add_library(GENERIC_F042K4TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F042K4TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F042K4TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F042K4TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F042K4TX_serial_none INTERFACE)
target_compile_options(GENERIC_F042K4TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F042K4TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F042K4TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F042K4TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F042K4TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F042K4TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F042K4TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F042K4TX_usb_none INTERFACE)
target_compile_options(GENERIC_F042K4TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F042K6TX
# -----------------------------------------------------------------------------

set(GENERIC_F042K6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F042K(4-6)T")
set(GENERIC_F042K6TX_MAXSIZE 32768)
set(GENERIC_F042K6TX_MAXDATASIZE 6144)
set(GENERIC_F042K6TX_MCU cortex-m0)
set(GENERIC_F042K6TX_FPCONF "-")
add_library(GENERIC_F042K6TX INTERFACE)
target_compile_options(GENERIC_F042K6TX INTERFACE
  "SHELL:-DSTM32F042x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F042K6TX_MCU}
)
target_compile_definitions(GENERIC_F042K6TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F042K6TX"
	"BOARD_NAME=\"GENERIC_F042K6TX\""
	"BOARD_ID=GENERIC_F042K6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F042K6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F042K6TX_VARIANT_PATH}
)

target_link_options(GENERIC_F042K6TX INTERFACE
  "LINKER:--default-script=${GENERIC_F042K6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F042K6TX_MCU}
)

add_library(GENERIC_F042K6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F042K6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F042K6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F042K6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F042K6TX_serial_none INTERFACE)
target_compile_options(GENERIC_F042K6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F042K6TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F042K6TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F042K6TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F042K6TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F042K6TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F042K6TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F042K6TX_usb_none INTERFACE)
target_compile_options(GENERIC_F042K6TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F042T6YX
# -----------------------------------------------------------------------------

set(GENERIC_F042T6YX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F042T6Y")
set(GENERIC_F042T6YX_MAXSIZE 32768)
set(GENERIC_F042T6YX_MAXDATASIZE 6144)
set(GENERIC_F042T6YX_MCU cortex-m0)
set(GENERIC_F042T6YX_FPCONF "-")
add_library(GENERIC_F042T6YX INTERFACE)
target_compile_options(GENERIC_F042T6YX INTERFACE
  "SHELL:-DSTM32F042x6  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F042T6YX_MCU}
)
target_compile_definitions(GENERIC_F042T6YX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F042T6YX"
	"BOARD_NAME=\"GENERIC_F042T6YX\""
	"BOARD_ID=GENERIC_F042T6YX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F042T6YX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F042T6YX_VARIANT_PATH}
)

target_link_options(GENERIC_F042T6YX INTERFACE
  "LINKER:--default-script=${GENERIC_F042T6YX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F042T6YX_MCU}
)

add_library(GENERIC_F042T6YX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F042T6YX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F042T6YX_serial_generic INTERFACE)
target_compile_options(GENERIC_F042T6YX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F042T6YX_serial_none INTERFACE)
target_compile_options(GENERIC_F042T6YX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F042T6YX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F042T6YX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F042T6YX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F042T6YX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F042T6YX_usb_HID INTERFACE)
target_compile_options(GENERIC_F042T6YX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F042T6YX_usb_none INTERFACE)
target_compile_options(GENERIC_F042T6YX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F048G6UX
# -----------------------------------------------------------------------------

set(GENERIC_F048G6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F048G6U")
set(GENERIC_F048G6UX_MAXSIZE 32768)
set(GENERIC_F048G6UX_MAXDATASIZE 6144)
set(GENERIC_F048G6UX_MCU cortex-m0)
set(GENERIC_F048G6UX_FPCONF "-")
add_library(GENERIC_F048G6UX INTERFACE)
target_compile_options(GENERIC_F048G6UX INTERFACE
  "SHELL:-DSTM32F048xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F048G6UX_MCU}
)
target_compile_definitions(GENERIC_F048G6UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F048G6UX"
	"BOARD_NAME=\"GENERIC_F048G6UX\""
	"BOARD_ID=GENERIC_F048G6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F048G6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F048G6UX_VARIANT_PATH}
)

target_link_options(GENERIC_F048G6UX INTERFACE
  "LINKER:--default-script=${GENERIC_F048G6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F048G6UX_MCU}
)

add_library(GENERIC_F048G6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F048G6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F048G6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F048G6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F048G6UX_serial_none INTERFACE)
target_compile_options(GENERIC_F048G6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F048G6UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F048G6UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F048G6UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F048G6UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F048G6UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F048G6UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F048G6UX_usb_none INTERFACE)
target_compile_options(GENERIC_F048G6UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F048T6YX
# -----------------------------------------------------------------------------

set(GENERIC_F048T6YX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F048T6Y")
set(GENERIC_F048T6YX_MAXSIZE 32768)
set(GENERIC_F048T6YX_MAXDATASIZE 6144)
set(GENERIC_F048T6YX_MCU cortex-m0)
set(GENERIC_F048T6YX_FPCONF "-")
add_library(GENERIC_F048T6YX INTERFACE)
target_compile_options(GENERIC_F048T6YX INTERFACE
  "SHELL:-DSTM32F048xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F048T6YX_MCU}
)
target_compile_definitions(GENERIC_F048T6YX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F048T6YX"
	"BOARD_NAME=\"GENERIC_F048T6YX\""
	"BOARD_ID=GENERIC_F048T6YX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F048T6YX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F048T6YX_VARIANT_PATH}
)

target_link_options(GENERIC_F048T6YX INTERFACE
  "LINKER:--default-script=${GENERIC_F048T6YX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F048T6YX_MCU}
)

add_library(GENERIC_F048T6YX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F048T6YX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F048T6YX_serial_generic INTERFACE)
target_compile_options(GENERIC_F048T6YX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F048T6YX_serial_none INTERFACE)
target_compile_options(GENERIC_F048T6YX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F048T6YX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F048T6YX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F048T6YX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F048T6YX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F048T6YX_usb_HID INTERFACE)
target_compile_options(GENERIC_F048T6YX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F048T6YX_usb_none INTERFACE)
target_compile_options(GENERIC_F048T6YX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F051C4TX
# -----------------------------------------------------------------------------

set(GENERIC_F051C4TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F051C4(T-U)")
set(GENERIC_F051C4TX_MAXSIZE 16384)
set(GENERIC_F051C4TX_MAXDATASIZE 8192)
set(GENERIC_F051C4TX_MCU cortex-m0)
set(GENERIC_F051C4TX_FPCONF "-")
add_library(GENERIC_F051C4TX INTERFACE)
target_compile_options(GENERIC_F051C4TX INTERFACE
  "SHELL:-DSTM32F051x8  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F051C4TX_MCU}
)
target_compile_definitions(GENERIC_F051C4TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F051C4TX"
	"BOARD_NAME=\"GENERIC_F051C4TX\""
	"BOARD_ID=GENERIC_F051C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F051C4TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F051C4TX_VARIANT_PATH}
)

target_link_options(GENERIC_F051C4TX INTERFACE
  "LINKER:--default-script=${GENERIC_F051C4TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F051C4TX_MCU}
)

add_library(GENERIC_F051C4TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F051C4TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F051C4TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F051C4TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F051C4TX_serial_none INTERFACE)
target_compile_options(GENERIC_F051C4TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F051C4TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F051C4TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F051C4TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F051C4TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F051C4TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F051C4TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F051C4TX_usb_none INTERFACE)
target_compile_options(GENERIC_F051C4TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F051C4UX
# -----------------------------------------------------------------------------

set(GENERIC_F051C4UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F051C4(T-U)")
set(GENERIC_F051C4UX_MAXSIZE 16384)
set(GENERIC_F051C4UX_MAXDATASIZE 8192)
set(GENERIC_F051C4UX_MCU cortex-m0)
set(GENERIC_F051C4UX_FPCONF "-")
add_library(GENERIC_F051C4UX INTERFACE)
target_compile_options(GENERIC_F051C4UX INTERFACE
  "SHELL:-DSTM32F051x8  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F051C4UX_MCU}
)
target_compile_definitions(GENERIC_F051C4UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F051C4UX"
	"BOARD_NAME=\"GENERIC_F051C4UX\""
	"BOARD_ID=GENERIC_F051C4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F051C4UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F051C4UX_VARIANT_PATH}
)

target_link_options(GENERIC_F051C4UX INTERFACE
  "LINKER:--default-script=${GENERIC_F051C4UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F051C4UX_MCU}
)

add_library(GENERIC_F051C4UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F051C4UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F051C4UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F051C4UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F051C4UX_serial_none INTERFACE)
target_compile_options(GENERIC_F051C4UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F051C4UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F051C4UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F051C4UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F051C4UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F051C4UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F051C4UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F051C4UX_usb_none INTERFACE)
target_compile_options(GENERIC_F051C4UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F051K4TX
# -----------------------------------------------------------------------------

set(GENERIC_F051K4TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F051K4T")
set(GENERIC_F051K4TX_MAXSIZE 16384)
set(GENERIC_F051K4TX_MAXDATASIZE 8192)
set(GENERIC_F051K4TX_MCU cortex-m0)
set(GENERIC_F051K4TX_FPCONF "-")
add_library(GENERIC_F051K4TX INTERFACE)
target_compile_options(GENERIC_F051K4TX INTERFACE
  "SHELL:-DSTM32F051x8  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F051K4TX_MCU}
)
target_compile_definitions(GENERIC_F051K4TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F051K4TX"
	"BOARD_NAME=\"GENERIC_F051K4TX\""
	"BOARD_ID=GENERIC_F051K4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F051K4TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F051K4TX_VARIANT_PATH}
)

target_link_options(GENERIC_F051K4TX INTERFACE
  "LINKER:--default-script=${GENERIC_F051K4TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F051K4TX_MCU}
)

add_library(GENERIC_F051K4TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F051K4TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F051K4TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F051K4TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F051K4TX_serial_none INTERFACE)
target_compile_options(GENERIC_F051K4TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F051K4TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F051K4TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F051K4TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F051K4TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F051K4TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F051K4TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F051K4TX_usb_none INTERFACE)
target_compile_options(GENERIC_F051K4TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F051K6UX
# -----------------------------------------------------------------------------

set(GENERIC_F051K6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F051K(6-8)U")
set(GENERIC_F051K6UX_MAXSIZE 32768)
set(GENERIC_F051K6UX_MAXDATASIZE 8192)
set(GENERIC_F051K6UX_MCU cortex-m0)
set(GENERIC_F051K6UX_FPCONF "-")
add_library(GENERIC_F051K6UX INTERFACE)
target_compile_options(GENERIC_F051K6UX INTERFACE
  "SHELL:-DSTM32F051x8  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F051K6UX_MCU}
)
target_compile_definitions(GENERIC_F051K6UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F051K6UX"
	"BOARD_NAME=\"GENERIC_F051K6UX\""
	"BOARD_ID=GENERIC_F051K6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F051K6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F051K6UX_VARIANT_PATH}
)

target_link_options(GENERIC_F051K6UX INTERFACE
  "LINKER:--default-script=${GENERIC_F051K6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F051K6UX_MCU}
)

add_library(GENERIC_F051K6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F051K6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F051K6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F051K6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F051K6UX_serial_none INTERFACE)
target_compile_options(GENERIC_F051K6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F051K6UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F051K6UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F051K6UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F051K6UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F051K6UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F051K6UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F051K6UX_usb_none INTERFACE)
target_compile_options(GENERIC_F051K6UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F051K8UX
# -----------------------------------------------------------------------------

set(GENERIC_F051K8UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F051K(6-8)U")
set(GENERIC_F051K8UX_MAXSIZE 65536)
set(GENERIC_F051K8UX_MAXDATASIZE 8192)
set(GENERIC_F051K8UX_MCU cortex-m0)
set(GENERIC_F051K8UX_FPCONF "-")
add_library(GENERIC_F051K8UX INTERFACE)
target_compile_options(GENERIC_F051K8UX INTERFACE
  "SHELL:-DSTM32F051x8  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F051K8UX_MCU}
)
target_compile_definitions(GENERIC_F051K8UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F051K8UX"
	"BOARD_NAME=\"GENERIC_F051K8UX\""
	"BOARD_ID=GENERIC_F051K8UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F051K8UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F051K8UX_VARIANT_PATH}
)

target_link_options(GENERIC_F051K8UX INTERFACE
  "LINKER:--default-script=${GENERIC_F051K8UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F051K8UX_MCU}
)

add_library(GENERIC_F051K8UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F051K8UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F051K8UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F051K8UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F051K8UX_serial_none INTERFACE)
target_compile_options(GENERIC_F051K8UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F051K8UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F051K8UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F051K8UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F051K8UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F051K8UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F051K8UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F051K8UX_usb_none INTERFACE)
target_compile_options(GENERIC_F051K8UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F051R4TX
# -----------------------------------------------------------------------------

set(GENERIC_F051R4TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F051R4T")
set(GENERIC_F051R4TX_MAXSIZE 16384)
set(GENERIC_F051R4TX_MAXDATASIZE 8192)
set(GENERIC_F051R4TX_MCU cortex-m0)
set(GENERIC_F051R4TX_FPCONF "-")
add_library(GENERIC_F051R4TX INTERFACE)
target_compile_options(GENERIC_F051R4TX INTERFACE
  "SHELL:-DSTM32F051x8  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F051R4TX_MCU}
)
target_compile_definitions(GENERIC_F051R4TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F051R4TX"
	"BOARD_NAME=\"GENERIC_F051R4TX\""
	"BOARD_ID=GENERIC_F051R4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F051R4TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F051R4TX_VARIANT_PATH}
)

target_link_options(GENERIC_F051R4TX INTERFACE
  "LINKER:--default-script=${GENERIC_F051R4TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F051R4TX_MCU}
)

add_library(GENERIC_F051R4TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F051R4TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F051R4TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F051R4TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F051R4TX_serial_none INTERFACE)
target_compile_options(GENERIC_F051R4TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F051R4TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F051R4TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F051R4TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F051R4TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F051R4TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F051R4TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F051R4TX_usb_none INTERFACE)
target_compile_options(GENERIC_F051R4TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F051T8YX
# -----------------------------------------------------------------------------

set(GENERIC_F051T8YX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F051T8Y")
set(GENERIC_F051T8YX_MAXSIZE 65536)
set(GENERIC_F051T8YX_MAXDATASIZE 8192)
set(GENERIC_F051T8YX_MCU cortex-m0)
set(GENERIC_F051T8YX_FPCONF "-")
add_library(GENERIC_F051T8YX INTERFACE)
target_compile_options(GENERIC_F051T8YX INTERFACE
  "SHELL:-DSTM32F051x8  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F051T8YX_MCU}
)
target_compile_definitions(GENERIC_F051T8YX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F051T8YX"
	"BOARD_NAME=\"GENERIC_F051T8YX\""
	"BOARD_ID=GENERIC_F051T8YX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F051T8YX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F051T8YX_VARIANT_PATH}
)

target_link_options(GENERIC_F051T8YX INTERFACE
  "LINKER:--default-script=${GENERIC_F051T8YX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F051T8YX_MCU}
)

add_library(GENERIC_F051T8YX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F051T8YX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F051T8YX_serial_generic INTERFACE)
target_compile_options(GENERIC_F051T8YX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F051T8YX_serial_none INTERFACE)
target_compile_options(GENERIC_F051T8YX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F051T8YX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F051T8YX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F051T8YX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F051T8YX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F051T8YX_usb_HID INTERFACE)
target_compile_options(GENERIC_F051T8YX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F051T8YX_usb_none INTERFACE)
target_compile_options(GENERIC_F051T8YX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F058C8UX
# -----------------------------------------------------------------------------

set(GENERIC_F058C8UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F058C8U")
set(GENERIC_F058C8UX_MAXSIZE 65536)
set(GENERIC_F058C8UX_MAXDATASIZE 8192)
set(GENERIC_F058C8UX_MCU cortex-m0)
set(GENERIC_F058C8UX_FPCONF "-")
add_library(GENERIC_F058C8UX INTERFACE)
target_compile_options(GENERIC_F058C8UX INTERFACE
  "SHELL:-DSTM32F058xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F058C8UX_MCU}
)
target_compile_definitions(GENERIC_F058C8UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F058C8UX"
	"BOARD_NAME=\"GENERIC_F058C8UX\""
	"BOARD_ID=GENERIC_F058C8UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F058C8UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F058C8UX_VARIANT_PATH}
)

target_link_options(GENERIC_F058C8UX INTERFACE
  "LINKER:--default-script=${GENERIC_F058C8UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F058C8UX_MCU}
)

add_library(GENERIC_F058C8UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F058C8UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F058C8UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F058C8UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F058C8UX_serial_none INTERFACE)
target_compile_options(GENERIC_F058C8UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F058C8UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F058C8UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F058C8UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F058C8UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F058C8UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F058C8UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F058C8UX_usb_none INTERFACE)
target_compile_options(GENERIC_F058C8UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F058R8HX
# -----------------------------------------------------------------------------

set(GENERIC_F058R8HX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F058R8(H-T)")
set(GENERIC_F058R8HX_MAXSIZE 65536)
set(GENERIC_F058R8HX_MAXDATASIZE 8192)
set(GENERIC_F058R8HX_MCU cortex-m0)
set(GENERIC_F058R8HX_FPCONF "-")
add_library(GENERIC_F058R8HX INTERFACE)
target_compile_options(GENERIC_F058R8HX INTERFACE
  "SHELL:-DSTM32F058xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F058R8HX_MCU}
)
target_compile_definitions(GENERIC_F058R8HX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F058R8HX"
	"BOARD_NAME=\"GENERIC_F058R8HX\""
	"BOARD_ID=GENERIC_F058R8HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F058R8HX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F058R8HX_VARIANT_PATH}
)

target_link_options(GENERIC_F058R8HX INTERFACE
  "LINKER:--default-script=${GENERIC_F058R8HX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F058R8HX_MCU}
)

add_library(GENERIC_F058R8HX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F058R8HX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F058R8HX_serial_generic INTERFACE)
target_compile_options(GENERIC_F058R8HX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F058R8HX_serial_none INTERFACE)
target_compile_options(GENERIC_F058R8HX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F058R8HX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F058R8HX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F058R8HX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F058R8HX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F058R8HX_usb_HID INTERFACE)
target_compile_options(GENERIC_F058R8HX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F058R8HX_usb_none INTERFACE)
target_compile_options(GENERIC_F058R8HX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F058R8TX
# -----------------------------------------------------------------------------

set(GENERIC_F058R8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F058R8(H-T)")
set(GENERIC_F058R8TX_MAXSIZE 65536)
set(GENERIC_F058R8TX_MAXDATASIZE 8192)
set(GENERIC_F058R8TX_MCU cortex-m0)
set(GENERIC_F058R8TX_FPCONF "-")
add_library(GENERIC_F058R8TX INTERFACE)
target_compile_options(GENERIC_F058R8TX INTERFACE
  "SHELL:-DSTM32F058xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F058R8TX_MCU}
)
target_compile_definitions(GENERIC_F058R8TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F058R8TX"
	"BOARD_NAME=\"GENERIC_F058R8TX\""
	"BOARD_ID=GENERIC_F058R8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F058R8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F058R8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F058R8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F058R8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F058R8TX_MCU}
)

add_library(GENERIC_F058R8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F058R8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F058R8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F058R8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F058R8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F058R8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F058R8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F058R8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F058R8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F058R8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F058R8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F058R8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F058R8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F058R8TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F058T8YX
# -----------------------------------------------------------------------------

set(GENERIC_F058T8YX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F058T8Y")
set(GENERIC_F058T8YX_MAXSIZE 65536)
set(GENERIC_F058T8YX_MAXDATASIZE 8192)
set(GENERIC_F058T8YX_MCU cortex-m0)
set(GENERIC_F058T8YX_FPCONF "-")
add_library(GENERIC_F058T8YX INTERFACE)
target_compile_options(GENERIC_F058T8YX INTERFACE
  "SHELL:-DSTM32F058xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F058T8YX_MCU}
)
target_compile_definitions(GENERIC_F058T8YX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F058T8YX"
	"BOARD_NAME=\"GENERIC_F058T8YX\""
	"BOARD_ID=GENERIC_F058T8YX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F058T8YX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F058T8YX_VARIANT_PATH}
)

target_link_options(GENERIC_F058T8YX INTERFACE
  "LINKER:--default-script=${GENERIC_F058T8YX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F058T8YX_MCU}
)

add_library(GENERIC_F058T8YX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F058T8YX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F058T8YX_serial_generic INTERFACE)
target_compile_options(GENERIC_F058T8YX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F058T8YX_serial_none INTERFACE)
target_compile_options(GENERIC_F058T8YX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F058T8YX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F058T8YX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F058T8YX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F058T8YX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F058T8YX_usb_HID INTERFACE)
target_compile_options(GENERIC_F058T8YX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F058T8YX_usb_none INTERFACE)
target_compile_options(GENERIC_F058T8YX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F070CBTX
# -----------------------------------------------------------------------------

set(GENERIC_F070CBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F070CBT")
set(GENERIC_F070CBTX_MAXSIZE 131072)
set(GENERIC_F070CBTX_MAXDATASIZE 16384)
set(GENERIC_F070CBTX_MCU cortex-m0)
set(GENERIC_F070CBTX_FPCONF "-")
add_library(GENERIC_F070CBTX INTERFACE)
target_compile_options(GENERIC_F070CBTX INTERFACE
  "SHELL:-DSTM32F070xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F070CBTX_MCU}
)
target_compile_definitions(GENERIC_F070CBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F070CBTX"
	"BOARD_NAME=\"GENERIC_F070CBTX\""
	"BOARD_ID=GENERIC_F070CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F070CBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F070CBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F070CBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F070CBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F070CBTX_MCU}
)

add_library(GENERIC_F070CBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F070CBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F070CBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F070CBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F070CBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F070CBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F070CBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F070CBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F070CBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F070CBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F070CBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F070CBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F070CBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F070CBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F070RBTX
# -----------------------------------------------------------------------------

set(GENERIC_F070RBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F070RBT")
set(GENERIC_F070RBTX_MAXSIZE 131072)
set(GENERIC_F070RBTX_MAXDATASIZE 16384)
set(GENERIC_F070RBTX_MCU cortex-m0)
set(GENERIC_F070RBTX_FPCONF "-")
add_library(GENERIC_F070RBTX INTERFACE)
target_compile_options(GENERIC_F070RBTX INTERFACE
  "SHELL:-DSTM32F070xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F070RBTX_MCU}
)
target_compile_definitions(GENERIC_F070RBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F070RBTX"
	"BOARD_NAME=\"GENERIC_F070RBTX\""
	"BOARD_ID=GENERIC_F070RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F070RBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F070RBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F070RBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F070RBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F070RBTX_MCU}
)

add_library(GENERIC_F070RBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F070RBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F070RBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F070RBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F070RBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F070RBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F070RBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F070RBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F070RBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F070RBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F070RBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F070RBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F070RBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F070RBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F071C8TX
# -----------------------------------------------------------------------------

set(GENERIC_F071C8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F071C8(T-U)_F071CB(T-U-Y)")
set(GENERIC_F071C8TX_MAXSIZE 65536)
set(GENERIC_F071C8TX_MAXDATASIZE 16384)
set(GENERIC_F071C8TX_MCU cortex-m0)
set(GENERIC_F071C8TX_FPCONF "-")
add_library(GENERIC_F071C8TX INTERFACE)
target_compile_options(GENERIC_F071C8TX INTERFACE
  "SHELL:-DSTM32F071xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F071C8TX_MCU}
)
target_compile_definitions(GENERIC_F071C8TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F071C8TX"
	"BOARD_NAME=\"GENERIC_F071C8TX\""
	"BOARD_ID=GENERIC_F071C8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F071C8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F071C8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F071C8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F071C8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F071C8TX_MCU}
)

add_library(GENERIC_F071C8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F071C8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F071C8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F071C8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F071C8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F071C8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F071C8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F071C8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F071C8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F071C8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F071C8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F071C8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F071C8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F071C8TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F071C8UX
# -----------------------------------------------------------------------------

set(GENERIC_F071C8UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F071C8(T-U)_F071CB(T-U-Y)")
set(GENERIC_F071C8UX_MAXSIZE 65536)
set(GENERIC_F071C8UX_MAXDATASIZE 16384)
set(GENERIC_F071C8UX_MCU cortex-m0)
set(GENERIC_F071C8UX_FPCONF "-")
add_library(GENERIC_F071C8UX INTERFACE)
target_compile_options(GENERIC_F071C8UX INTERFACE
  "SHELL:-DSTM32F071xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F071C8UX_MCU}
)
target_compile_definitions(GENERIC_F071C8UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F071C8UX"
	"BOARD_NAME=\"GENERIC_F071C8UX\""
	"BOARD_ID=GENERIC_F071C8UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F071C8UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F071C8UX_VARIANT_PATH}
)

target_link_options(GENERIC_F071C8UX INTERFACE
  "LINKER:--default-script=${GENERIC_F071C8UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F071C8UX_MCU}
)

add_library(GENERIC_F071C8UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F071C8UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F071C8UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F071C8UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F071C8UX_serial_none INTERFACE)
target_compile_options(GENERIC_F071C8UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F071C8UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F071C8UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F071C8UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F071C8UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F071C8UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F071C8UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F071C8UX_usb_none INTERFACE)
target_compile_options(GENERIC_F071C8UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F071CBTX
# -----------------------------------------------------------------------------

set(GENERIC_F071CBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F071C8(T-U)_F071CB(T-U-Y)")
set(GENERIC_F071CBTX_MAXSIZE 131072)
set(GENERIC_F071CBTX_MAXDATASIZE 16384)
set(GENERIC_F071CBTX_MCU cortex-m0)
set(GENERIC_F071CBTX_FPCONF "-")
add_library(GENERIC_F071CBTX INTERFACE)
target_compile_options(GENERIC_F071CBTX INTERFACE
  "SHELL:-DSTM32F071xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F071CBTX_MCU}
)
target_compile_definitions(GENERIC_F071CBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F071CBTX"
	"BOARD_NAME=\"GENERIC_F071CBTX\""
	"BOARD_ID=GENERIC_F071CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F071CBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F071CBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F071CBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F071CBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F071CBTX_MCU}
)

add_library(GENERIC_F071CBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F071CBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F071CBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F071CBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F071CBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F071CBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F071CBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F071CBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F071CBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F071CBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F071CBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F071CBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F071CBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F071CBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F071CBUX
# -----------------------------------------------------------------------------

set(GENERIC_F071CBUX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F071C8(T-U)_F071CB(T-U-Y)")
set(GENERIC_F071CBUX_MAXSIZE 131072)
set(GENERIC_F071CBUX_MAXDATASIZE 16384)
set(GENERIC_F071CBUX_MCU cortex-m0)
set(GENERIC_F071CBUX_FPCONF "-")
add_library(GENERIC_F071CBUX INTERFACE)
target_compile_options(GENERIC_F071CBUX INTERFACE
  "SHELL:-DSTM32F071xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F071CBUX_MCU}
)
target_compile_definitions(GENERIC_F071CBUX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F071CBUX"
	"BOARD_NAME=\"GENERIC_F071CBUX\""
	"BOARD_ID=GENERIC_F071CBUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F071CBUX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F071CBUX_VARIANT_PATH}
)

target_link_options(GENERIC_F071CBUX INTERFACE
  "LINKER:--default-script=${GENERIC_F071CBUX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F071CBUX_MCU}
)

add_library(GENERIC_F071CBUX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F071CBUX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F071CBUX_serial_generic INTERFACE)
target_compile_options(GENERIC_F071CBUX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F071CBUX_serial_none INTERFACE)
target_compile_options(GENERIC_F071CBUX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F071CBUX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F071CBUX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F071CBUX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F071CBUX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F071CBUX_usb_HID INTERFACE)
target_compile_options(GENERIC_F071CBUX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F071CBUX_usb_none INTERFACE)
target_compile_options(GENERIC_F071CBUX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F071CBYX
# -----------------------------------------------------------------------------

set(GENERIC_F071CBYX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F071C8(T-U)_F071CB(T-U-Y)")
set(GENERIC_F071CBYX_MAXSIZE 131072)
set(GENERIC_F071CBYX_MAXDATASIZE 16384)
set(GENERIC_F071CBYX_MCU cortex-m0)
set(GENERIC_F071CBYX_FPCONF "-")
add_library(GENERIC_F071CBYX INTERFACE)
target_compile_options(GENERIC_F071CBYX INTERFACE
  "SHELL:-DSTM32F071xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F071CBYX_MCU}
)
target_compile_definitions(GENERIC_F071CBYX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F071CBYX"
	"BOARD_NAME=\"GENERIC_F071CBYX\""
	"BOARD_ID=GENERIC_F071CBYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F071CBYX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F071CBYX_VARIANT_PATH}
)

target_link_options(GENERIC_F071CBYX INTERFACE
  "LINKER:--default-script=${GENERIC_F071CBYX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F071CBYX_MCU}
)

add_library(GENERIC_F071CBYX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F071CBYX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F071CBYX_serial_generic INTERFACE)
target_compile_options(GENERIC_F071CBYX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F071CBYX_serial_none INTERFACE)
target_compile_options(GENERIC_F071CBYX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F071CBYX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F071CBYX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F071CBYX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F071CBYX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F071CBYX_usb_HID INTERFACE)
target_compile_options(GENERIC_F071CBYX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F071CBYX_usb_none INTERFACE)
target_compile_options(GENERIC_F071CBYX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F071RBTX
# -----------------------------------------------------------------------------

set(GENERIC_F071RBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F071RBT")
set(GENERIC_F071RBTX_MAXSIZE 131072)
set(GENERIC_F071RBTX_MAXDATASIZE 16384)
set(GENERIC_F071RBTX_MCU cortex-m0)
set(GENERIC_F071RBTX_FPCONF "-")
add_library(GENERIC_F071RBTX INTERFACE)
target_compile_options(GENERIC_F071RBTX INTERFACE
  "SHELL:-DSTM32F071xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F071RBTX_MCU}
)
target_compile_definitions(GENERIC_F071RBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F071RBTX"
	"BOARD_NAME=\"GENERIC_F071RBTX\""
	"BOARD_ID=GENERIC_F071RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F071RBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F071RBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F071RBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F071RBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F071RBTX_MCU}
)

add_library(GENERIC_F071RBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F071RBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F071RBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F071RBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F071RBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F071RBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F071RBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F071RBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F071RBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F071RBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F071RBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F071RBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F071RBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F071RBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F071V8HX
# -----------------------------------------------------------------------------

set(GENERIC_F071V8HX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F071V(8-B)(H-T)")
set(GENERIC_F071V8HX_MAXSIZE 65536)
set(GENERIC_F071V8HX_MAXDATASIZE 16384)
set(GENERIC_F071V8HX_MCU cortex-m0)
set(GENERIC_F071V8HX_FPCONF "-")
add_library(GENERIC_F071V8HX INTERFACE)
target_compile_options(GENERIC_F071V8HX INTERFACE
  "SHELL:-DSTM32F071xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F071V8HX_MCU}
)
target_compile_definitions(GENERIC_F071V8HX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F071V8HX"
	"BOARD_NAME=\"GENERIC_F071V8HX\""
	"BOARD_ID=GENERIC_F071V8HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F071V8HX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F071V8HX_VARIANT_PATH}
)

target_link_options(GENERIC_F071V8HX INTERFACE
  "LINKER:--default-script=${GENERIC_F071V8HX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F071V8HX_MCU}
)

add_library(GENERIC_F071V8HX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F071V8HX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F071V8HX_serial_generic INTERFACE)
target_compile_options(GENERIC_F071V8HX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F071V8HX_serial_none INTERFACE)
target_compile_options(GENERIC_F071V8HX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F071V8HX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F071V8HX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F071V8HX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F071V8HX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F071V8HX_usb_HID INTERFACE)
target_compile_options(GENERIC_F071V8HX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F071V8HX_usb_none INTERFACE)
target_compile_options(GENERIC_F071V8HX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F071V8TX
# -----------------------------------------------------------------------------

set(GENERIC_F071V8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F071V(8-B)(H-T)")
set(GENERIC_F071V8TX_MAXSIZE 65536)
set(GENERIC_F071V8TX_MAXDATASIZE 16384)
set(GENERIC_F071V8TX_MCU cortex-m0)
set(GENERIC_F071V8TX_FPCONF "-")
add_library(GENERIC_F071V8TX INTERFACE)
target_compile_options(GENERIC_F071V8TX INTERFACE
  "SHELL:-DSTM32F071xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F071V8TX_MCU}
)
target_compile_definitions(GENERIC_F071V8TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F071V8TX"
	"BOARD_NAME=\"GENERIC_F071V8TX\""
	"BOARD_ID=GENERIC_F071V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F071V8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F071V8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F071V8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F071V8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F071V8TX_MCU}
)

add_library(GENERIC_F071V8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F071V8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F071V8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F071V8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F071V8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F071V8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F071V8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F071V8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F071V8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F071V8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F071V8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F071V8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F071V8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F071V8TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F071VBHX
# -----------------------------------------------------------------------------

set(GENERIC_F071VBHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F071V(8-B)(H-T)")
set(GENERIC_F071VBHX_MAXSIZE 131072)
set(GENERIC_F071VBHX_MAXDATASIZE 16384)
set(GENERIC_F071VBHX_MCU cortex-m0)
set(GENERIC_F071VBHX_FPCONF "-")
add_library(GENERIC_F071VBHX INTERFACE)
target_compile_options(GENERIC_F071VBHX INTERFACE
  "SHELL:-DSTM32F071xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F071VBHX_MCU}
)
target_compile_definitions(GENERIC_F071VBHX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F071VBHX"
	"BOARD_NAME=\"GENERIC_F071VBHX\""
	"BOARD_ID=GENERIC_F071VBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F071VBHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F071VBHX_VARIANT_PATH}
)

target_link_options(GENERIC_F071VBHX INTERFACE
  "LINKER:--default-script=${GENERIC_F071VBHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F071VBHX_MCU}
)

add_library(GENERIC_F071VBHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F071VBHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F071VBHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F071VBHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F071VBHX_serial_none INTERFACE)
target_compile_options(GENERIC_F071VBHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F071VBHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F071VBHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F071VBHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F071VBHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F071VBHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F071VBHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F071VBHX_usb_none INTERFACE)
target_compile_options(GENERIC_F071VBHX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F071VBTX
# -----------------------------------------------------------------------------

set(GENERIC_F071VBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F071V(8-B)(H-T)")
set(GENERIC_F071VBTX_MAXSIZE 131072)
set(GENERIC_F071VBTX_MAXDATASIZE 16384)
set(GENERIC_F071VBTX_MCU cortex-m0)
set(GENERIC_F071VBTX_FPCONF "-")
add_library(GENERIC_F071VBTX INTERFACE)
target_compile_options(GENERIC_F071VBTX INTERFACE
  "SHELL:-DSTM32F071xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F071VBTX_MCU}
)
target_compile_definitions(GENERIC_F071VBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F071VBTX"
	"BOARD_NAME=\"GENERIC_F071VBTX\""
	"BOARD_ID=GENERIC_F071VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F071VBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F071VBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F071VBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F071VBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F071VBTX_MCU}
)

add_library(GENERIC_F071VBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F071VBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F071VBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F071VBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F071VBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F071VBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F071VBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F071VBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F071VBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F071VBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F071VBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F071VBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F071VBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F071VBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072C8TX
# -----------------------------------------------------------------------------

set(GENERIC_F072C8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072C8(T-U)_F072CB(T-U-Y)")
set(GENERIC_F072C8TX_MAXSIZE 65536)
set(GENERIC_F072C8TX_MAXDATASIZE 16384)
set(GENERIC_F072C8TX_MCU cortex-m0)
set(GENERIC_F072C8TX_FPCONF "-")
add_library(GENERIC_F072C8TX INTERFACE)
target_compile_options(GENERIC_F072C8TX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072C8TX_MCU}
)
target_compile_definitions(GENERIC_F072C8TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072C8TX"
	"BOARD_NAME=\"GENERIC_F072C8TX\""
	"BOARD_ID=GENERIC_F072C8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072C8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072C8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F072C8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F072C8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072C8TX_MCU}
)

add_library(GENERIC_F072C8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072C8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072C8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072C8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072C8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F072C8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072C8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072C8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072C8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072C8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072C8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072C8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072C8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F072C8TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072C8UX
# -----------------------------------------------------------------------------

set(GENERIC_F072C8UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072C8(T-U)_F072CB(T-U-Y)")
set(GENERIC_F072C8UX_MAXSIZE 65536)
set(GENERIC_F072C8UX_MAXDATASIZE 16384)
set(GENERIC_F072C8UX_MCU cortex-m0)
set(GENERIC_F072C8UX_FPCONF "-")
add_library(GENERIC_F072C8UX INTERFACE)
target_compile_options(GENERIC_F072C8UX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072C8UX_MCU}
)
target_compile_definitions(GENERIC_F072C8UX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072C8UX"
	"BOARD_NAME=\"GENERIC_F072C8UX\""
	"BOARD_ID=GENERIC_F072C8UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072C8UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072C8UX_VARIANT_PATH}
)

target_link_options(GENERIC_F072C8UX INTERFACE
  "LINKER:--default-script=${GENERIC_F072C8UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072C8UX_MCU}
)

add_library(GENERIC_F072C8UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072C8UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072C8UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072C8UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072C8UX_serial_none INTERFACE)
target_compile_options(GENERIC_F072C8UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072C8UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072C8UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072C8UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072C8UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072C8UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072C8UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072C8UX_usb_none INTERFACE)
target_compile_options(GENERIC_F072C8UX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072CBTX
# -----------------------------------------------------------------------------

set(GENERIC_F072CBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072C8(T-U)_F072CB(T-U-Y)")
set(GENERIC_F072CBTX_MAXSIZE 131072)
set(GENERIC_F072CBTX_MAXDATASIZE 16384)
set(GENERIC_F072CBTX_MCU cortex-m0)
set(GENERIC_F072CBTX_FPCONF "-")
add_library(GENERIC_F072CBTX INTERFACE)
target_compile_options(GENERIC_F072CBTX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072CBTX_MCU}
)
target_compile_definitions(GENERIC_F072CBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072CBTX"
	"BOARD_NAME=\"GENERIC_F072CBTX\""
	"BOARD_ID=GENERIC_F072CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072CBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072CBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F072CBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F072CBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072CBTX_MCU}
)

add_library(GENERIC_F072CBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072CBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072CBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072CBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072CBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F072CBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072CBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072CBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072CBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072CBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072CBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072CBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072CBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F072CBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072CBUX
# -----------------------------------------------------------------------------

set(GENERIC_F072CBUX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072C8(T-U)_F072CB(T-U-Y)")
set(GENERIC_F072CBUX_MAXSIZE 131072)
set(GENERIC_F072CBUX_MAXDATASIZE 16384)
set(GENERIC_F072CBUX_MCU cortex-m0)
set(GENERIC_F072CBUX_FPCONF "-")
add_library(GENERIC_F072CBUX INTERFACE)
target_compile_options(GENERIC_F072CBUX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072CBUX_MCU}
)
target_compile_definitions(GENERIC_F072CBUX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072CBUX"
	"BOARD_NAME=\"GENERIC_F072CBUX\""
	"BOARD_ID=GENERIC_F072CBUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072CBUX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072CBUX_VARIANT_PATH}
)

target_link_options(GENERIC_F072CBUX INTERFACE
  "LINKER:--default-script=${GENERIC_F072CBUX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072CBUX_MCU}
)

add_library(GENERIC_F072CBUX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072CBUX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072CBUX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072CBUX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072CBUX_serial_none INTERFACE)
target_compile_options(GENERIC_F072CBUX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072CBUX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072CBUX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072CBUX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072CBUX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072CBUX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072CBUX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072CBUX_usb_none INTERFACE)
target_compile_options(GENERIC_F072CBUX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072CBYX
# -----------------------------------------------------------------------------

set(GENERIC_F072CBYX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072C8(T-U)_F072CB(T-U-Y)")
set(GENERIC_F072CBYX_MAXSIZE 131072)
set(GENERIC_F072CBYX_MAXDATASIZE 16384)
set(GENERIC_F072CBYX_MCU cortex-m0)
set(GENERIC_F072CBYX_FPCONF "-")
add_library(GENERIC_F072CBYX INTERFACE)
target_compile_options(GENERIC_F072CBYX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072CBYX_MCU}
)
target_compile_definitions(GENERIC_F072CBYX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072CBYX"
	"BOARD_NAME=\"GENERIC_F072CBYX\""
	"BOARD_ID=GENERIC_F072CBYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072CBYX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072CBYX_VARIANT_PATH}
)

target_link_options(GENERIC_F072CBYX INTERFACE
  "LINKER:--default-script=${GENERIC_F072CBYX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072CBYX_MCU}
)

add_library(GENERIC_F072CBYX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072CBYX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072CBYX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072CBYX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072CBYX_serial_none INTERFACE)
target_compile_options(GENERIC_F072CBYX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072CBYX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072CBYX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072CBYX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072CBYX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072CBYX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072CBYX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072CBYX_usb_none INTERFACE)
target_compile_options(GENERIC_F072CBYX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072R8TX
# -----------------------------------------------------------------------------

set(GENERIC_F072R8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072R8T_F072RB(H-I-T)")
set(GENERIC_F072R8TX_MAXSIZE 65536)
set(GENERIC_F072R8TX_MAXDATASIZE 16384)
set(GENERIC_F072R8TX_MCU cortex-m0)
set(GENERIC_F072R8TX_FPCONF "-")
add_library(GENERIC_F072R8TX INTERFACE)
target_compile_options(GENERIC_F072R8TX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072R8TX_MCU}
)
target_compile_definitions(GENERIC_F072R8TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072R8TX"
	"BOARD_NAME=\"GENERIC_F072R8TX\""
	"BOARD_ID=GENERIC_F072R8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072R8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072R8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F072R8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F072R8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072R8TX_MCU}
)

add_library(GENERIC_F072R8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072R8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072R8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072R8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072R8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F072R8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072R8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072R8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072R8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072R8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072R8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072R8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072R8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F072R8TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072RBHX
# -----------------------------------------------------------------------------

set(GENERIC_F072RBHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072R8T_F072RB(H-I-T)")
set(GENERIC_F072RBHX_MAXSIZE 131072)
set(GENERIC_F072RBHX_MAXDATASIZE 16384)
set(GENERIC_F072RBHX_MCU cortex-m0)
set(GENERIC_F072RBHX_FPCONF "-")
add_library(GENERIC_F072RBHX INTERFACE)
target_compile_options(GENERIC_F072RBHX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072RBHX_MCU}
)
target_compile_definitions(GENERIC_F072RBHX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072RBHX"
	"BOARD_NAME=\"GENERIC_F072RBHX\""
	"BOARD_ID=GENERIC_F072RBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072RBHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072RBHX_VARIANT_PATH}
)

target_link_options(GENERIC_F072RBHX INTERFACE
  "LINKER:--default-script=${GENERIC_F072RBHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072RBHX_MCU}
)

add_library(GENERIC_F072RBHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072RBHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072RBHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072RBHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072RBHX_serial_none INTERFACE)
target_compile_options(GENERIC_F072RBHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072RBHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072RBHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072RBHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072RBHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072RBHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072RBHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072RBHX_usb_none INTERFACE)
target_compile_options(GENERIC_F072RBHX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072RBIX
# -----------------------------------------------------------------------------

set(GENERIC_F072RBIX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072R8T_F072RB(H-I-T)")
set(GENERIC_F072RBIX_MAXSIZE 131072)
set(GENERIC_F072RBIX_MAXDATASIZE 16384)
set(GENERIC_F072RBIX_MCU cortex-m0)
set(GENERIC_F072RBIX_FPCONF "-")
add_library(GENERIC_F072RBIX INTERFACE)
target_compile_options(GENERIC_F072RBIX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072RBIX_MCU}
)
target_compile_definitions(GENERIC_F072RBIX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072RBIX"
	"BOARD_NAME=\"GENERIC_F072RBIX\""
	"BOARD_ID=GENERIC_F072RBIX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072RBIX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072RBIX_VARIANT_PATH}
)

target_link_options(GENERIC_F072RBIX INTERFACE
  "LINKER:--default-script=${GENERIC_F072RBIX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072RBIX_MCU}
)

add_library(GENERIC_F072RBIX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072RBIX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072RBIX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072RBIX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072RBIX_serial_none INTERFACE)
target_compile_options(GENERIC_F072RBIX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072RBIX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072RBIX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072RBIX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072RBIX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072RBIX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072RBIX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072RBIX_usb_none INTERFACE)
target_compile_options(GENERIC_F072RBIX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072RBTX
# -----------------------------------------------------------------------------

set(GENERIC_F072RBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072R8T_F072RB(H-I-T)")
set(GENERIC_F072RBTX_MAXSIZE 131072)
set(GENERIC_F072RBTX_MAXDATASIZE 16384)
set(GENERIC_F072RBTX_MCU cortex-m0)
set(GENERIC_F072RBTX_FPCONF "-")
add_library(GENERIC_F072RBTX INTERFACE)
target_compile_options(GENERIC_F072RBTX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072RBTX_MCU}
)
target_compile_definitions(GENERIC_F072RBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072RBTX"
	"BOARD_NAME=\"GENERIC_F072RBTX\""
	"BOARD_ID=GENERIC_F072RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072RBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072RBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F072RBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F072RBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072RBTX_MCU}
)

add_library(GENERIC_F072RBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072RBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072RBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072RBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072RBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F072RBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072RBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072RBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072RBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072RBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072RBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072RBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072RBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F072RBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072V8HX
# -----------------------------------------------------------------------------

set(GENERIC_F072V8HX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072V(8-B)(H-T)")
set(GENERIC_F072V8HX_MAXSIZE 65536)
set(GENERIC_F072V8HX_MAXDATASIZE 16384)
set(GENERIC_F072V8HX_MCU cortex-m0)
set(GENERIC_F072V8HX_FPCONF "-")
add_library(GENERIC_F072V8HX INTERFACE)
target_compile_options(GENERIC_F072V8HX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072V8HX_MCU}
)
target_compile_definitions(GENERIC_F072V8HX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072V8HX"
	"BOARD_NAME=\"GENERIC_F072V8HX\""
	"BOARD_ID=GENERIC_F072V8HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072V8HX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072V8HX_VARIANT_PATH}
)

target_link_options(GENERIC_F072V8HX INTERFACE
  "LINKER:--default-script=${GENERIC_F072V8HX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072V8HX_MCU}
)

add_library(GENERIC_F072V8HX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072V8HX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072V8HX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072V8HX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072V8HX_serial_none INTERFACE)
target_compile_options(GENERIC_F072V8HX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072V8HX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072V8HX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072V8HX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072V8HX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072V8HX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072V8HX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072V8HX_usb_none INTERFACE)
target_compile_options(GENERIC_F072V8HX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072V8TX
# -----------------------------------------------------------------------------

set(GENERIC_F072V8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072V(8-B)(H-T)")
set(GENERIC_F072V8TX_MAXSIZE 65536)
set(GENERIC_F072V8TX_MAXDATASIZE 16384)
set(GENERIC_F072V8TX_MCU cortex-m0)
set(GENERIC_F072V8TX_FPCONF "-")
add_library(GENERIC_F072V8TX INTERFACE)
target_compile_options(GENERIC_F072V8TX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072V8TX_MCU}
)
target_compile_definitions(GENERIC_F072V8TX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072V8TX"
	"BOARD_NAME=\"GENERIC_F072V8TX\""
	"BOARD_ID=GENERIC_F072V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072V8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072V8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F072V8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F072V8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072V8TX_MCU}
)

add_library(GENERIC_F072V8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072V8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072V8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072V8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072V8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F072V8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072V8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072V8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072V8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072V8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072V8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072V8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072V8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F072V8TX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072VBHX
# -----------------------------------------------------------------------------

set(GENERIC_F072VBHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072V(8-B)(H-T)")
set(GENERIC_F072VBHX_MAXSIZE 131072)
set(GENERIC_F072VBHX_MAXDATASIZE 16384)
set(GENERIC_F072VBHX_MCU cortex-m0)
set(GENERIC_F072VBHX_FPCONF "-")
add_library(GENERIC_F072VBHX INTERFACE)
target_compile_options(GENERIC_F072VBHX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072VBHX_MCU}
)
target_compile_definitions(GENERIC_F072VBHX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072VBHX"
	"BOARD_NAME=\"GENERIC_F072VBHX\""
	"BOARD_ID=GENERIC_F072VBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072VBHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072VBHX_VARIANT_PATH}
)

target_link_options(GENERIC_F072VBHX INTERFACE
  "LINKER:--default-script=${GENERIC_F072VBHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072VBHX_MCU}
)

add_library(GENERIC_F072VBHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072VBHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072VBHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072VBHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072VBHX_serial_none INTERFACE)
target_compile_options(GENERIC_F072VBHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072VBHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072VBHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072VBHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072VBHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072VBHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072VBHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072VBHX_usb_none INTERFACE)
target_compile_options(GENERIC_F072VBHX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F072VBTX
# -----------------------------------------------------------------------------

set(GENERIC_F072VBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F072V(8-B)(H-T)")
set(GENERIC_F072VBTX_MAXSIZE 131072)
set(GENERIC_F072VBTX_MAXDATASIZE 16384)
set(GENERIC_F072VBTX_MCU cortex-m0)
set(GENERIC_F072VBTX_FPCONF "-")
add_library(GENERIC_F072VBTX INTERFACE)
target_compile_options(GENERIC_F072VBTX INTERFACE
  "SHELL:-DSTM32F072xB  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F072VBTX_MCU}
)
target_compile_definitions(GENERIC_F072VBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F072VBTX"
	"BOARD_NAME=\"GENERIC_F072VBTX\""
	"BOARD_ID=GENERIC_F072VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F072VBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F072VBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F072VBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F072VBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F072VBTX_MCU}
)

add_library(GENERIC_F072VBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F072VBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F072VBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F072VBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F072VBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F072VBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F072VBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F072VBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F072VBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F072VBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F072VBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F072VBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F072VBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F072VBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F078CBTX
# -----------------------------------------------------------------------------

set(GENERIC_F078CBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F078CB(T-U-Y)")
set(GENERIC_F078CBTX_MAXSIZE 131072)
set(GENERIC_F078CBTX_MAXDATASIZE 16384)
set(GENERIC_F078CBTX_MCU cortex-m0)
set(GENERIC_F078CBTX_FPCONF "-")
add_library(GENERIC_F078CBTX INTERFACE)
target_compile_options(GENERIC_F078CBTX INTERFACE
  "SHELL:-DSTM32F078xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F078CBTX_MCU}
)
target_compile_definitions(GENERIC_F078CBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F078CBTX"
	"BOARD_NAME=\"GENERIC_F078CBTX\""
	"BOARD_ID=GENERIC_F078CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F078CBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F078CBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F078CBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F078CBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F078CBTX_MCU}
)

add_library(GENERIC_F078CBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F078CBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F078CBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F078CBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F078CBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F078CBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F078CBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F078CBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F078CBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F078CBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F078CBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F078CBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F078CBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F078CBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F078CBUX
# -----------------------------------------------------------------------------

set(GENERIC_F078CBUX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F078CB(T-U-Y)")
set(GENERIC_F078CBUX_MAXSIZE 131072)
set(GENERIC_F078CBUX_MAXDATASIZE 16384)
set(GENERIC_F078CBUX_MCU cortex-m0)
set(GENERIC_F078CBUX_FPCONF "-")
add_library(GENERIC_F078CBUX INTERFACE)
target_compile_options(GENERIC_F078CBUX INTERFACE
  "SHELL:-DSTM32F078xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F078CBUX_MCU}
)
target_compile_definitions(GENERIC_F078CBUX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F078CBUX"
	"BOARD_NAME=\"GENERIC_F078CBUX\""
	"BOARD_ID=GENERIC_F078CBUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F078CBUX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F078CBUX_VARIANT_PATH}
)

target_link_options(GENERIC_F078CBUX INTERFACE
  "LINKER:--default-script=${GENERIC_F078CBUX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F078CBUX_MCU}
)

add_library(GENERIC_F078CBUX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F078CBUX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F078CBUX_serial_generic INTERFACE)
target_compile_options(GENERIC_F078CBUX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F078CBUX_serial_none INTERFACE)
target_compile_options(GENERIC_F078CBUX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F078CBUX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F078CBUX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F078CBUX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F078CBUX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F078CBUX_usb_HID INTERFACE)
target_compile_options(GENERIC_F078CBUX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F078CBUX_usb_none INTERFACE)
target_compile_options(GENERIC_F078CBUX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F078CBYX
# -----------------------------------------------------------------------------

set(GENERIC_F078CBYX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F078CB(T-U-Y)")
set(GENERIC_F078CBYX_MAXSIZE 131072)
set(GENERIC_F078CBYX_MAXDATASIZE 16384)
set(GENERIC_F078CBYX_MCU cortex-m0)
set(GENERIC_F078CBYX_FPCONF "-")
add_library(GENERIC_F078CBYX INTERFACE)
target_compile_options(GENERIC_F078CBYX INTERFACE
  "SHELL:-DSTM32F078xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F078CBYX_MCU}
)
target_compile_definitions(GENERIC_F078CBYX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F078CBYX"
	"BOARD_NAME=\"GENERIC_F078CBYX\""
	"BOARD_ID=GENERIC_F078CBYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F078CBYX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F078CBYX_VARIANT_PATH}
)

target_link_options(GENERIC_F078CBYX INTERFACE
  "LINKER:--default-script=${GENERIC_F078CBYX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F078CBYX_MCU}
)

add_library(GENERIC_F078CBYX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F078CBYX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F078CBYX_serial_generic INTERFACE)
target_compile_options(GENERIC_F078CBYX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F078CBYX_serial_none INTERFACE)
target_compile_options(GENERIC_F078CBYX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F078CBYX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F078CBYX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F078CBYX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F078CBYX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F078CBYX_usb_HID INTERFACE)
target_compile_options(GENERIC_F078CBYX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F078CBYX_usb_none INTERFACE)
target_compile_options(GENERIC_F078CBYX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F078RBHX
# -----------------------------------------------------------------------------

set(GENERIC_F078RBHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F078RB(H-T)")
set(GENERIC_F078RBHX_MAXSIZE 131072)
set(GENERIC_F078RBHX_MAXDATASIZE 16384)
set(GENERIC_F078RBHX_MCU cortex-m0)
set(GENERIC_F078RBHX_FPCONF "-")
add_library(GENERIC_F078RBHX INTERFACE)
target_compile_options(GENERIC_F078RBHX INTERFACE
  "SHELL:-DSTM32F078xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F078RBHX_MCU}
)
target_compile_definitions(GENERIC_F078RBHX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F078RBHX"
	"BOARD_NAME=\"GENERIC_F078RBHX\""
	"BOARD_ID=GENERIC_F078RBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F078RBHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F078RBHX_VARIANT_PATH}
)

target_link_options(GENERIC_F078RBHX INTERFACE
  "LINKER:--default-script=${GENERIC_F078RBHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F078RBHX_MCU}
)

add_library(GENERIC_F078RBHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F078RBHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F078RBHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F078RBHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F078RBHX_serial_none INTERFACE)
target_compile_options(GENERIC_F078RBHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F078RBHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F078RBHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F078RBHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F078RBHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F078RBHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F078RBHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F078RBHX_usb_none INTERFACE)
target_compile_options(GENERIC_F078RBHX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F078RBTX
# -----------------------------------------------------------------------------

set(GENERIC_F078RBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F078RB(H-T)")
set(GENERIC_F078RBTX_MAXSIZE 131072)
set(GENERIC_F078RBTX_MAXDATASIZE 16384)
set(GENERIC_F078RBTX_MCU cortex-m0)
set(GENERIC_F078RBTX_FPCONF "-")
add_library(GENERIC_F078RBTX INTERFACE)
target_compile_options(GENERIC_F078RBTX INTERFACE
  "SHELL:-DSTM32F078xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F078RBTX_MCU}
)
target_compile_definitions(GENERIC_F078RBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F078RBTX"
	"BOARD_NAME=\"GENERIC_F078RBTX\""
	"BOARD_ID=GENERIC_F078RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F078RBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F078RBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F078RBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F078RBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F078RBTX_MCU}
)

add_library(GENERIC_F078RBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F078RBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F078RBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F078RBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F078RBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F078RBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F078RBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F078RBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F078RBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F078RBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F078RBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F078RBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F078RBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F078RBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F078VBHX
# -----------------------------------------------------------------------------

set(GENERIC_F078VBHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F078VB(H-T)")
set(GENERIC_F078VBHX_MAXSIZE 131072)
set(GENERIC_F078VBHX_MAXDATASIZE 16384)
set(GENERIC_F078VBHX_MCU cortex-m0)
set(GENERIC_F078VBHX_FPCONF "-")
add_library(GENERIC_F078VBHX INTERFACE)
target_compile_options(GENERIC_F078VBHX INTERFACE
  "SHELL:-DSTM32F078xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F078VBHX_MCU}
)
target_compile_definitions(GENERIC_F078VBHX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F078VBHX"
	"BOARD_NAME=\"GENERIC_F078VBHX\""
	"BOARD_ID=GENERIC_F078VBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F078VBHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F078VBHX_VARIANT_PATH}
)

target_link_options(GENERIC_F078VBHX INTERFACE
  "LINKER:--default-script=${GENERIC_F078VBHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F078VBHX_MCU}
)

add_library(GENERIC_F078VBHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F078VBHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F078VBHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F078VBHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F078VBHX_serial_none INTERFACE)
target_compile_options(GENERIC_F078VBHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F078VBHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F078VBHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F078VBHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F078VBHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F078VBHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F078VBHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F078VBHX_usb_none INTERFACE)
target_compile_options(GENERIC_F078VBHX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F078VBTX
# -----------------------------------------------------------------------------

set(GENERIC_F078VBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F078VB(H-T)")
set(GENERIC_F078VBTX_MAXSIZE 131072)
set(GENERIC_F078VBTX_MAXDATASIZE 16384)
set(GENERIC_F078VBTX_MCU cortex-m0)
set(GENERIC_F078VBTX_FPCONF "-")
add_library(GENERIC_F078VBTX INTERFACE)
target_compile_options(GENERIC_F078VBTX INTERFACE
  "SHELL:-DSTM32F078xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F078VBTX_MCU}
)
target_compile_definitions(GENERIC_F078VBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F078VBTX"
	"BOARD_NAME=\"GENERIC_F078VBTX\""
	"BOARD_ID=GENERIC_F078VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F078VBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F078VBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F078VBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F078VBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F078VBTX_MCU}
)

add_library(GENERIC_F078VBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F078VBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F078VBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F078VBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F078VBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F078VBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F078VBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F078VBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F078VBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F078VBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F078VBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F078VBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F078VBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F078VBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F091CBTX
# -----------------------------------------------------------------------------

set(GENERIC_F091CBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F091C(B-C)(T-U)")
set(GENERIC_F091CBTX_MAXSIZE 131072)
set(GENERIC_F091CBTX_MAXDATASIZE 32768)
set(GENERIC_F091CBTX_MCU cortex-m0)
set(GENERIC_F091CBTX_FPCONF "-")
add_library(GENERIC_F091CBTX INTERFACE)
target_compile_options(GENERIC_F091CBTX INTERFACE
  "SHELL:-DSTM32F091xC  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F091CBTX_MCU}
)
target_compile_definitions(GENERIC_F091CBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F091CBTX"
	"BOARD_NAME=\"GENERIC_F091CBTX\""
	"BOARD_ID=GENERIC_F091CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F091CBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F091CBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F091CBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F091CBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F091CBTX_MCU}
)

add_library(GENERIC_F091CBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F091CBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F091CBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F091CBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F091CBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F091CBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F091CBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F091CBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F091CBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F091CBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F091CBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F091CBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F091CBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F091CBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F091CBUX
# -----------------------------------------------------------------------------

set(GENERIC_F091CBUX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F091C(B-C)(T-U)")
set(GENERIC_F091CBUX_MAXSIZE 131072)
set(GENERIC_F091CBUX_MAXDATASIZE 32768)
set(GENERIC_F091CBUX_MCU cortex-m0)
set(GENERIC_F091CBUX_FPCONF "-")
add_library(GENERIC_F091CBUX INTERFACE)
target_compile_options(GENERIC_F091CBUX INTERFACE
  "SHELL:-DSTM32F091xC  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F091CBUX_MCU}
)
target_compile_definitions(GENERIC_F091CBUX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F091CBUX"
	"BOARD_NAME=\"GENERIC_F091CBUX\""
	"BOARD_ID=GENERIC_F091CBUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F091CBUX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F091CBUX_VARIANT_PATH}
)

target_link_options(GENERIC_F091CBUX INTERFACE
  "LINKER:--default-script=${GENERIC_F091CBUX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F091CBUX_MCU}
)

add_library(GENERIC_F091CBUX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F091CBUX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F091CBUX_serial_generic INTERFACE)
target_compile_options(GENERIC_F091CBUX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F091CBUX_serial_none INTERFACE)
target_compile_options(GENERIC_F091CBUX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F091CBUX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F091CBUX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F091CBUX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F091CBUX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F091CBUX_usb_HID INTERFACE)
target_compile_options(GENERIC_F091CBUX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F091CBUX_usb_none INTERFACE)
target_compile_options(GENERIC_F091CBUX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F091CCTX
# -----------------------------------------------------------------------------

set(GENERIC_F091CCTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F091C(B-C)(T-U)")
set(GENERIC_F091CCTX_MAXSIZE 262144)
set(GENERIC_F091CCTX_MAXDATASIZE 32768)
set(GENERIC_F091CCTX_MCU cortex-m0)
set(GENERIC_F091CCTX_FPCONF "-")
add_library(GENERIC_F091CCTX INTERFACE)
target_compile_options(GENERIC_F091CCTX INTERFACE
  "SHELL:-DSTM32F091xC  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F091CCTX_MCU}
)
target_compile_definitions(GENERIC_F091CCTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F091CCTX"
	"BOARD_NAME=\"GENERIC_F091CCTX\""
	"BOARD_ID=GENERIC_F091CCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F091CCTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F091CCTX_VARIANT_PATH}
)

target_link_options(GENERIC_F091CCTX INTERFACE
  "LINKER:--default-script=${GENERIC_F091CCTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F091CCTX_MCU}
)

add_library(GENERIC_F091CCTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F091CCTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F091CCTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F091CCTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F091CCTX_serial_none INTERFACE)
target_compile_options(GENERIC_F091CCTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F091CCTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F091CCTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F091CCTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F091CCTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F091CCTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F091CCTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F091CCTX_usb_none INTERFACE)
target_compile_options(GENERIC_F091CCTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F091CCUX
# -----------------------------------------------------------------------------

set(GENERIC_F091CCUX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F091C(B-C)(T-U)")
set(GENERIC_F091CCUX_MAXSIZE 262144)
set(GENERIC_F091CCUX_MAXDATASIZE 32768)
set(GENERIC_F091CCUX_MCU cortex-m0)
set(GENERIC_F091CCUX_FPCONF "-")
add_library(GENERIC_F091CCUX INTERFACE)
target_compile_options(GENERIC_F091CCUX INTERFACE
  "SHELL:-DSTM32F091xC  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F091CCUX_MCU}
)
target_compile_definitions(GENERIC_F091CCUX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F091CCUX"
	"BOARD_NAME=\"GENERIC_F091CCUX\""
	"BOARD_ID=GENERIC_F091CCUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F091CCUX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F091CCUX_VARIANT_PATH}
)

target_link_options(GENERIC_F091CCUX INTERFACE
  "LINKER:--default-script=${GENERIC_F091CCUX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F091CCUX_MCU}
)

add_library(GENERIC_F091CCUX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F091CCUX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F091CCUX_serial_generic INTERFACE)
target_compile_options(GENERIC_F091CCUX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F091CCUX_serial_none INTERFACE)
target_compile_options(GENERIC_F091CCUX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F091CCUX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F091CCUX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F091CCUX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F091CCUX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F091CCUX_usb_HID INTERFACE)
target_compile_options(GENERIC_F091CCUX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F091CCUX_usb_none INTERFACE)
target_compile_options(GENERIC_F091CCUX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F091RBTX
# -----------------------------------------------------------------------------

set(GENERIC_F091RBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F091RBT_F091RC(H-T-Y)")
set(GENERIC_F091RBTX_MAXSIZE 131072)
set(GENERIC_F091RBTX_MAXDATASIZE 32768)
set(GENERIC_F091RBTX_MCU cortex-m0)
set(GENERIC_F091RBTX_FPCONF "-")
add_library(GENERIC_F091RBTX INTERFACE)
target_compile_options(GENERIC_F091RBTX INTERFACE
  "SHELL:-DSTM32F091xC  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F091RBTX_MCU}
)
target_compile_definitions(GENERIC_F091RBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F091RBTX"
	"BOARD_NAME=\"GENERIC_F091RBTX\""
	"BOARD_ID=GENERIC_F091RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F091RBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F091RBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F091RBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F091RBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F091RBTX_MCU}
)

add_library(GENERIC_F091RBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F091RBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F091RBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F091RBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F091RBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F091RBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F091RBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F091RBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F091RBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F091RBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F091RBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F091RBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F091RBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F091RBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F091RCHX
# -----------------------------------------------------------------------------

set(GENERIC_F091RCHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F091RBT_F091RC(H-T-Y)")
set(GENERIC_F091RCHX_MAXSIZE 262144)
set(GENERIC_F091RCHX_MAXDATASIZE 32768)
set(GENERIC_F091RCHX_MCU cortex-m0)
set(GENERIC_F091RCHX_FPCONF "-")
add_library(GENERIC_F091RCHX INTERFACE)
target_compile_options(GENERIC_F091RCHX INTERFACE
  "SHELL:-DSTM32F091xC  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F091RCHX_MCU}
)
target_compile_definitions(GENERIC_F091RCHX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F091RCHX"
	"BOARD_NAME=\"GENERIC_F091RCHX\""
	"BOARD_ID=GENERIC_F091RCHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F091RCHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F091RCHX_VARIANT_PATH}
)

target_link_options(GENERIC_F091RCHX INTERFACE
  "LINKER:--default-script=${GENERIC_F091RCHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F091RCHX_MCU}
)

add_library(GENERIC_F091RCHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F091RCHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F091RCHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F091RCHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F091RCHX_serial_none INTERFACE)
target_compile_options(GENERIC_F091RCHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F091RCHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F091RCHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F091RCHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F091RCHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F091RCHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F091RCHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F091RCHX_usb_none INTERFACE)
target_compile_options(GENERIC_F091RCHX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F091RCTX
# -----------------------------------------------------------------------------

set(GENERIC_F091RCTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F091RBT_F091RC(H-T-Y)")
set(GENERIC_F091RCTX_MAXSIZE 262144)
set(GENERIC_F091RCTX_MAXDATASIZE 32768)
set(GENERIC_F091RCTX_MCU cortex-m0)
set(GENERIC_F091RCTX_FPCONF "-")
add_library(GENERIC_F091RCTX INTERFACE)
target_compile_options(GENERIC_F091RCTX INTERFACE
  "SHELL:-DSTM32F091xC  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F091RCTX_MCU}
)
target_compile_definitions(GENERIC_F091RCTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F091RCTX"
	"BOARD_NAME=\"GENERIC_F091RCTX\""
	"BOARD_ID=GENERIC_F091RCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F091RCTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F091RCTX_VARIANT_PATH}
)

target_link_options(GENERIC_F091RCTX INTERFACE
  "LINKER:--default-script=${GENERIC_F091RCTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F091RCTX_MCU}
)

add_library(GENERIC_F091RCTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F091RCTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F091RCTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F091RCTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F091RCTX_serial_none INTERFACE)
target_compile_options(GENERIC_F091RCTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F091RCTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F091RCTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F091RCTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F091RCTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F091RCTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F091RCTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F091RCTX_usb_none INTERFACE)
target_compile_options(GENERIC_F091RCTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F091RCYX
# -----------------------------------------------------------------------------

set(GENERIC_F091RCYX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F091RBT_F091RC(H-T-Y)")
set(GENERIC_F091RCYX_MAXSIZE 262144)
set(GENERIC_F091RCYX_MAXDATASIZE 32768)
set(GENERIC_F091RCYX_MCU cortex-m0)
set(GENERIC_F091RCYX_FPCONF "-")
add_library(GENERIC_F091RCYX INTERFACE)
target_compile_options(GENERIC_F091RCYX INTERFACE
  "SHELL:-DSTM32F091xC  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F091RCYX_MCU}
)
target_compile_definitions(GENERIC_F091RCYX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F091RCYX"
	"BOARD_NAME=\"GENERIC_F091RCYX\""
	"BOARD_ID=GENERIC_F091RCYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F091RCYX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F091RCYX_VARIANT_PATH}
)

target_link_options(GENERIC_F091RCYX INTERFACE
  "LINKER:--default-script=${GENERIC_F091RCYX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F091RCYX_MCU}
)

add_library(GENERIC_F091RCYX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F091RCYX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F091RCYX_serial_generic INTERFACE)
target_compile_options(GENERIC_F091RCYX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F091RCYX_serial_none INTERFACE)
target_compile_options(GENERIC_F091RCYX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F091RCYX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F091RCYX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F091RCYX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F091RCYX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F091RCYX_usb_HID INTERFACE)
target_compile_options(GENERIC_F091RCYX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F091RCYX_usb_none INTERFACE)
target_compile_options(GENERIC_F091RCYX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F091VBTX
# -----------------------------------------------------------------------------

set(GENERIC_F091VBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F091VBT_F091VC(H-T)")
set(GENERIC_F091VBTX_MAXSIZE 131072)
set(GENERIC_F091VBTX_MAXDATASIZE 32768)
set(GENERIC_F091VBTX_MCU cortex-m0)
set(GENERIC_F091VBTX_FPCONF "-")
add_library(GENERIC_F091VBTX INTERFACE)
target_compile_options(GENERIC_F091VBTX INTERFACE
  "SHELL:-DSTM32F091xC  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F091VBTX_MCU}
)
target_compile_definitions(GENERIC_F091VBTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F091VBTX"
	"BOARD_NAME=\"GENERIC_F091VBTX\""
	"BOARD_ID=GENERIC_F091VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F091VBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F091VBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F091VBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F091VBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F091VBTX_MCU}
)

add_library(GENERIC_F091VBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F091VBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F091VBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F091VBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F091VBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F091VBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F091VBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F091VBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F091VBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F091VBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F091VBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F091VBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F091VBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F091VBTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F091VCHX
# -----------------------------------------------------------------------------

set(GENERIC_F091VCHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F091VBT_F091VC(H-T)")
set(GENERIC_F091VCHX_MAXSIZE 262144)
set(GENERIC_F091VCHX_MAXDATASIZE 32768)
set(GENERIC_F091VCHX_MCU cortex-m0)
set(GENERIC_F091VCHX_FPCONF "-")
add_library(GENERIC_F091VCHX INTERFACE)
target_compile_options(GENERIC_F091VCHX INTERFACE
  "SHELL:-DSTM32F091xC  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F091VCHX_MCU}
)
target_compile_definitions(GENERIC_F091VCHX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F091VCHX"
	"BOARD_NAME=\"GENERIC_F091VCHX\""
	"BOARD_ID=GENERIC_F091VCHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F091VCHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F091VCHX_VARIANT_PATH}
)

target_link_options(GENERIC_F091VCHX INTERFACE
  "LINKER:--default-script=${GENERIC_F091VCHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F091VCHX_MCU}
)

add_library(GENERIC_F091VCHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F091VCHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F091VCHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F091VCHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F091VCHX_serial_none INTERFACE)
target_compile_options(GENERIC_F091VCHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F091VCHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F091VCHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F091VCHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F091VCHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F091VCHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F091VCHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F091VCHX_usb_none INTERFACE)
target_compile_options(GENERIC_F091VCHX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F091VCTX
# -----------------------------------------------------------------------------

set(GENERIC_F091VCTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F091VBT_F091VC(H-T)")
set(GENERIC_F091VCTX_MAXSIZE 262144)
set(GENERIC_F091VCTX_MAXDATASIZE 32768)
set(GENERIC_F091VCTX_MCU cortex-m0)
set(GENERIC_F091VCTX_FPCONF "-")
add_library(GENERIC_F091VCTX INTERFACE)
target_compile_options(GENERIC_F091VCTX INTERFACE
  "SHELL:-DSTM32F091xC  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F091VCTX_MCU}
)
target_compile_definitions(GENERIC_F091VCTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F091VCTX"
	"BOARD_NAME=\"GENERIC_F091VCTX\""
	"BOARD_ID=GENERIC_F091VCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F091VCTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F091VCTX_VARIANT_PATH}
)

target_link_options(GENERIC_F091VCTX INTERFACE
  "LINKER:--default-script=${GENERIC_F091VCTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F091VCTX_MCU}
)

add_library(GENERIC_F091VCTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F091VCTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F091VCTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F091VCTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F091VCTX_serial_none INTERFACE)
target_compile_options(GENERIC_F091VCTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F091VCTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F091VCTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F091VCTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F091VCTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F091VCTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F091VCTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F091VCTX_usb_none INTERFACE)
target_compile_options(GENERIC_F091VCTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F098CCTX
# -----------------------------------------------------------------------------

set(GENERIC_F098CCTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F098CC(T-U)")
set(GENERIC_F098CCTX_MAXSIZE 262144)
set(GENERIC_F098CCTX_MAXDATASIZE 32768)
set(GENERIC_F098CCTX_MCU cortex-m0)
set(GENERIC_F098CCTX_FPCONF "-")
add_library(GENERIC_F098CCTX INTERFACE)
target_compile_options(GENERIC_F098CCTX INTERFACE
  "SHELL:-DSTM32F098xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F098CCTX_MCU}
)
target_compile_definitions(GENERIC_F098CCTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F098CCTX"
	"BOARD_NAME=\"GENERIC_F098CCTX\""
	"BOARD_ID=GENERIC_F098CCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F098CCTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F098CCTX_VARIANT_PATH}
)

target_link_options(GENERIC_F098CCTX INTERFACE
  "LINKER:--default-script=${GENERIC_F098CCTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F098CCTX_MCU}
)

add_library(GENERIC_F098CCTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F098CCTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F098CCTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F098CCTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F098CCTX_serial_none INTERFACE)
target_compile_options(GENERIC_F098CCTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F098CCTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F098CCTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F098CCTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F098CCTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F098CCTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F098CCTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F098CCTX_usb_none INTERFACE)
target_compile_options(GENERIC_F098CCTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F098CCUX
# -----------------------------------------------------------------------------

set(GENERIC_F098CCUX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F098CC(T-U)")
set(GENERIC_F098CCUX_MAXSIZE 262144)
set(GENERIC_F098CCUX_MAXDATASIZE 32768)
set(GENERIC_F098CCUX_MCU cortex-m0)
set(GENERIC_F098CCUX_FPCONF "-")
add_library(GENERIC_F098CCUX INTERFACE)
target_compile_options(GENERIC_F098CCUX INTERFACE
  "SHELL:-DSTM32F098xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F098CCUX_MCU}
)
target_compile_definitions(GENERIC_F098CCUX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F098CCUX"
	"BOARD_NAME=\"GENERIC_F098CCUX\""
	"BOARD_ID=GENERIC_F098CCUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F098CCUX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F098CCUX_VARIANT_PATH}
)

target_link_options(GENERIC_F098CCUX INTERFACE
  "LINKER:--default-script=${GENERIC_F098CCUX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F098CCUX_MCU}
)

add_library(GENERIC_F098CCUX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F098CCUX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F098CCUX_serial_generic INTERFACE)
target_compile_options(GENERIC_F098CCUX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F098CCUX_serial_none INTERFACE)
target_compile_options(GENERIC_F098CCUX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F098CCUX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F098CCUX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F098CCUX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F098CCUX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F098CCUX_usb_HID INTERFACE)
target_compile_options(GENERIC_F098CCUX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F098CCUX_usb_none INTERFACE)
target_compile_options(GENERIC_F098CCUX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F098RCHX
# -----------------------------------------------------------------------------

set(GENERIC_F098RCHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F098RC(H-T-Y)")
set(GENERIC_F098RCHX_MAXSIZE 262144)
set(GENERIC_F098RCHX_MAXDATASIZE 32768)
set(GENERIC_F098RCHX_MCU cortex-m0)
set(GENERIC_F098RCHX_FPCONF "-")
add_library(GENERIC_F098RCHX INTERFACE)
target_compile_options(GENERIC_F098RCHX INTERFACE
  "SHELL:-DSTM32F098xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F098RCHX_MCU}
)
target_compile_definitions(GENERIC_F098RCHX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F098RCHX"
	"BOARD_NAME=\"GENERIC_F098RCHX\""
	"BOARD_ID=GENERIC_F098RCHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F098RCHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F098RCHX_VARIANT_PATH}
)

target_link_options(GENERIC_F098RCHX INTERFACE
  "LINKER:--default-script=${GENERIC_F098RCHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F098RCHX_MCU}
)

add_library(GENERIC_F098RCHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F098RCHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F098RCHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F098RCHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F098RCHX_serial_none INTERFACE)
target_compile_options(GENERIC_F098RCHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F098RCHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F098RCHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F098RCHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F098RCHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F098RCHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F098RCHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F098RCHX_usb_none INTERFACE)
target_compile_options(GENERIC_F098RCHX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F098RCTX
# -----------------------------------------------------------------------------

set(GENERIC_F098RCTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F098RC(H-T-Y)")
set(GENERIC_F098RCTX_MAXSIZE 262144)
set(GENERIC_F098RCTX_MAXDATASIZE 32768)
set(GENERIC_F098RCTX_MCU cortex-m0)
set(GENERIC_F098RCTX_FPCONF "-")
add_library(GENERIC_F098RCTX INTERFACE)
target_compile_options(GENERIC_F098RCTX INTERFACE
  "SHELL:-DSTM32F098xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F098RCTX_MCU}
)
target_compile_definitions(GENERIC_F098RCTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F098RCTX"
	"BOARD_NAME=\"GENERIC_F098RCTX\""
	"BOARD_ID=GENERIC_F098RCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F098RCTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F098RCTX_VARIANT_PATH}
)

target_link_options(GENERIC_F098RCTX INTERFACE
  "LINKER:--default-script=${GENERIC_F098RCTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F098RCTX_MCU}
)

add_library(GENERIC_F098RCTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F098RCTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F098RCTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F098RCTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F098RCTX_serial_none INTERFACE)
target_compile_options(GENERIC_F098RCTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F098RCTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F098RCTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F098RCTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F098RCTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F098RCTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F098RCTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F098RCTX_usb_none INTERFACE)
target_compile_options(GENERIC_F098RCTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F098RCYX
# -----------------------------------------------------------------------------

set(GENERIC_F098RCYX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F098RC(H-T-Y)")
set(GENERIC_F098RCYX_MAXSIZE 262144)
set(GENERIC_F098RCYX_MAXDATASIZE 32768)
set(GENERIC_F098RCYX_MCU cortex-m0)
set(GENERIC_F098RCYX_FPCONF "-")
add_library(GENERIC_F098RCYX INTERFACE)
target_compile_options(GENERIC_F098RCYX INTERFACE
  "SHELL:-DSTM32F098xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F098RCYX_MCU}
)
target_compile_definitions(GENERIC_F098RCYX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F098RCYX"
	"BOARD_NAME=\"GENERIC_F098RCYX\""
	"BOARD_ID=GENERIC_F098RCYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F098RCYX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F098RCYX_VARIANT_PATH}
)

target_link_options(GENERIC_F098RCYX INTERFACE
  "LINKER:--default-script=${GENERIC_F098RCYX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F098RCYX_MCU}
)

add_library(GENERIC_F098RCYX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F098RCYX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F098RCYX_serial_generic INTERFACE)
target_compile_options(GENERIC_F098RCYX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F098RCYX_serial_none INTERFACE)
target_compile_options(GENERIC_F098RCYX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F098RCYX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F098RCYX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F098RCYX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F098RCYX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F098RCYX_usb_HID INTERFACE)
target_compile_options(GENERIC_F098RCYX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F098RCYX_usb_none INTERFACE)
target_compile_options(GENERIC_F098RCYX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F098VCHX
# -----------------------------------------------------------------------------

set(GENERIC_F098VCHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F098VC(H-T)")
set(GENERIC_F098VCHX_MAXSIZE 262144)
set(GENERIC_F098VCHX_MAXDATASIZE 32768)
set(GENERIC_F098VCHX_MCU cortex-m0)
set(GENERIC_F098VCHX_FPCONF "-")
add_library(GENERIC_F098VCHX INTERFACE)
target_compile_options(GENERIC_F098VCHX INTERFACE
  "SHELL:-DSTM32F098xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F098VCHX_MCU}
)
target_compile_definitions(GENERIC_F098VCHX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F098VCHX"
	"BOARD_NAME=\"GENERIC_F098VCHX\""
	"BOARD_ID=GENERIC_F098VCHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F098VCHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F098VCHX_VARIANT_PATH}
)

target_link_options(GENERIC_F098VCHX INTERFACE
  "LINKER:--default-script=${GENERIC_F098VCHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F098VCHX_MCU}
)

add_library(GENERIC_F098VCHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F098VCHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F098VCHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F098VCHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F098VCHX_serial_none INTERFACE)
target_compile_options(GENERIC_F098VCHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F098VCHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F098VCHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F098VCHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F098VCHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F098VCHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F098VCHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F098VCHX_usb_none INTERFACE)
target_compile_options(GENERIC_F098VCHX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F098VCTX
# -----------------------------------------------------------------------------

set(GENERIC_F098VCTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F0xx/F098VC(H-T)")
set(GENERIC_F098VCTX_MAXSIZE 262144)
set(GENERIC_F098VCTX_MAXDATASIZE 32768)
set(GENERIC_F098VCTX_MCU cortex-m0)
set(GENERIC_F098VCTX_FPCONF "-")
add_library(GENERIC_F098VCTX INTERFACE)
target_compile_options(GENERIC_F098VCTX INTERFACE
  "SHELL:-DSTM32F098xx  "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F098VCTX_MCU}
)
target_compile_definitions(GENERIC_F098VCTX INTERFACE
  "STM32F0xx"
	"ARDUINO_GENERIC_F098VCTX"
	"BOARD_NAME=\"GENERIC_F098VCTX\""
	"BOARD_ID=GENERIC_F098VCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F098VCTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F0xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F0xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F0xx/Source/Templates/gcc/
  ${GENERIC_F098VCTX_VARIANT_PATH}
)

target_link_options(GENERIC_F098VCTX INTERFACE
  "LINKER:--default-script=${GENERIC_F098VCTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F098VCTX_MCU}
)

add_library(GENERIC_F098VCTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F098VCTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F098VCTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F098VCTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F098VCTX_serial_none INTERFACE)
target_compile_options(GENERIC_F098VCTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F098VCTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F098VCTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F098VCTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F098VCTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F098VCTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F098VCTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F098VCTX_usb_none INTERFACE)
target_compile_options(GENERIC_F098VCTX_usb_none INTERFACE
  "SHELL:"
)

# GENERIC_F100C4TX
# -----------------------------------------------------------------------------

set(GENERIC_F100C4TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(4-6)T")
set(GENERIC_F100C4TX_MAXSIZE 16384)
set(GENERIC_F100C4TX_MAXDATASIZE 4096)
set(GENERIC_F100C4TX_MCU cortex-m3)
set(GENERIC_F100C4TX_FPCONF "-")
add_library(GENERIC_F100C4TX INTERFACE)
target_compile_options(GENERIC_F100C4TX INTERFACE
  "SHELL:-DSTM32F100xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100C4TX_MCU}
)
target_compile_definitions(GENERIC_F100C4TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100C4TX"
	"BOARD_NAME=\"GENERIC_F100C4TX\""
	"BOARD_ID=GENERIC_F100C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100C4TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100C4TX_VARIANT_PATH}
)

target_link_options(GENERIC_F100C4TX INTERFACE
  "LINKER:--default-script=${GENERIC_F100C4TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100C4TX_MCU}
)

add_library(GENERIC_F100C4TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100C4TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100C4TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100C4TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100C4TX_serial_none INTERFACE)
target_compile_options(GENERIC_F100C4TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100C4TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100C4TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100C4TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100C4TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100C4TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100C4TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100C4TX_usb_none INTERFACE)
target_compile_options(GENERIC_F100C4TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100C4TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100C4TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100C4TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100C4TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100C4TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100C4TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100C4TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100C4TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(4-6)T")
set(GENERIC_F100C4TX_dfu2_MAXSIZE 16384)
set(GENERIC_F100C4TX_dfu2_MAXDATASIZE 4096)
set(GENERIC_F100C4TX_dfu2_MCU cortex-m3)
set(GENERIC_F100C4TX_dfu2_FPCONF "-")
add_library(GENERIC_F100C4TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100C4TX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100C4TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100C4TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100C4TX"
	"BOARD_NAME=\"GENERIC_F100C4TX\""
	"BOARD_ID=GENERIC_F100C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100C4TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100C4TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100C4TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100C4TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100C4TX_dfu2_MCU}
)


# GENERIC_F100C4TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100C4TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(4-6)T")
set(GENERIC_F100C4TX_dfuo_MAXSIZE 16384)
set(GENERIC_F100C4TX_dfuo_MAXDATASIZE 4096)
set(GENERIC_F100C4TX_dfuo_MCU cortex-m3)
set(GENERIC_F100C4TX_dfuo_FPCONF "-")
add_library(GENERIC_F100C4TX_dfuo INTERFACE)
target_compile_options(GENERIC_F100C4TX_dfuo INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100C4TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100C4TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100C4TX"
	"BOARD_NAME=\"GENERIC_F100C4TX\""
	"BOARD_ID=GENERIC_F100C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100C4TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100C4TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100C4TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100C4TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100C4TX_dfuo_MCU}
)


# GENERIC_F100C4TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100C4TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(4-6)T")
set(GENERIC_F100C4TX_hid_MAXSIZE 16384)
set(GENERIC_F100C4TX_hid_MAXDATASIZE 4096)
set(GENERIC_F100C4TX_hid_MCU cortex-m3)
set(GENERIC_F100C4TX_hid_FPCONF "-")
add_library(GENERIC_F100C4TX_hid INTERFACE)
target_compile_options(GENERIC_F100C4TX_hid INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100C4TX_hid_MCU}
)
target_compile_definitions(GENERIC_F100C4TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100C4TX"
	"BOARD_NAME=\"GENERIC_F100C4TX\""
	"BOARD_ID=GENERIC_F100C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100C4TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100C4TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100C4TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100C4TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100C4TX_hid_MCU}
)


# GENERIC_F100C6TX
# -----------------------------------------------------------------------------

set(GENERIC_F100C6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(4-6)T")
set(GENERIC_F100C6TX_MAXSIZE 32768)
set(GENERIC_F100C6TX_MAXDATASIZE 4096)
set(GENERIC_F100C6TX_MCU cortex-m3)
set(GENERIC_F100C6TX_FPCONF "-")
add_library(GENERIC_F100C6TX INTERFACE)
target_compile_options(GENERIC_F100C6TX INTERFACE
  "SHELL:-DSTM32F100xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100C6TX_MCU}
)
target_compile_definitions(GENERIC_F100C6TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100C6TX"
	"BOARD_NAME=\"GENERIC_F100C6TX\""
	"BOARD_ID=GENERIC_F100C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100C6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100C6TX_VARIANT_PATH}
)

target_link_options(GENERIC_F100C6TX INTERFACE
  "LINKER:--default-script=${GENERIC_F100C6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100C6TX_MCU}
)

add_library(GENERIC_F100C6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100C6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100C6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100C6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100C6TX_serial_none INTERFACE)
target_compile_options(GENERIC_F100C6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100C6TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100C6TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100C6TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100C6TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100C6TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100C6TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100C6TX_usb_none INTERFACE)
target_compile_options(GENERIC_F100C6TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100C6TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100C6TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100C6TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100C6TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100C6TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100C6TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100C6TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100C6TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(4-6)T")
set(GENERIC_F100C6TX_dfu2_MAXSIZE 32768)
set(GENERIC_F100C6TX_dfu2_MAXDATASIZE 4096)
set(GENERIC_F100C6TX_dfu2_MCU cortex-m3)
set(GENERIC_F100C6TX_dfu2_FPCONF "-")
add_library(GENERIC_F100C6TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100C6TX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100C6TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100C6TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100C6TX"
	"BOARD_NAME=\"GENERIC_F100C6TX\""
	"BOARD_ID=GENERIC_F100C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100C6TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100C6TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100C6TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100C6TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100C6TX_dfu2_MCU}
)


# GENERIC_F100C6TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100C6TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(4-6)T")
set(GENERIC_F100C6TX_dfuo_MAXSIZE 32768)
set(GENERIC_F100C6TX_dfuo_MAXDATASIZE 4096)
set(GENERIC_F100C6TX_dfuo_MCU cortex-m3)
set(GENERIC_F100C6TX_dfuo_FPCONF "-")
add_library(GENERIC_F100C6TX_dfuo INTERFACE)
target_compile_options(GENERIC_F100C6TX_dfuo INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100C6TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100C6TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100C6TX"
	"BOARD_NAME=\"GENERIC_F100C6TX\""
	"BOARD_ID=GENERIC_F100C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100C6TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100C6TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100C6TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100C6TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100C6TX_dfuo_MCU}
)


# GENERIC_F100C6TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100C6TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(4-6)T")
set(GENERIC_F100C6TX_hid_MAXSIZE 32768)
set(GENERIC_F100C6TX_hid_MAXDATASIZE 4096)
set(GENERIC_F100C6TX_hid_MCU cortex-m3)
set(GENERIC_F100C6TX_hid_FPCONF "-")
add_library(GENERIC_F100C6TX_hid INTERFACE)
target_compile_options(GENERIC_F100C6TX_hid INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100C6TX_hid_MCU}
)
target_compile_definitions(GENERIC_F100C6TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100C6TX"
	"BOARD_NAME=\"GENERIC_F100C6TX\""
	"BOARD_ID=GENERIC_F100C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100C6TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100C6TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100C6TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100C6TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100C6TX_hid_MCU}
)


# GENERIC_F100C8TX
# -----------------------------------------------------------------------------

set(GENERIC_F100C8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(8-B)T")
set(GENERIC_F100C8TX_MAXSIZE 65536)
set(GENERIC_F100C8TX_MAXDATASIZE 8192)
set(GENERIC_F100C8TX_MCU cortex-m3)
set(GENERIC_F100C8TX_FPCONF "-")
add_library(GENERIC_F100C8TX INTERFACE)
target_compile_options(GENERIC_F100C8TX INTERFACE
  "SHELL:-DSTM32F100xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100C8TX_MCU}
)
target_compile_definitions(GENERIC_F100C8TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100C8TX"
	"BOARD_NAME=\"GENERIC_F100C8TX\""
	"BOARD_ID=GENERIC_F100C8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100C8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100C8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F100C8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F100C8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100C8TX_MCU}
)

add_library(GENERIC_F100C8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100C8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100C8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100C8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100C8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F100C8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100C8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100C8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100C8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100C8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100C8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100C8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100C8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F100C8TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100C8TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100C8TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100C8TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100C8TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100C8TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100C8TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100C8TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100C8TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(8-B)T")
set(GENERIC_F100C8TX_dfu2_MAXSIZE 65536)
set(GENERIC_F100C8TX_dfu2_MAXDATASIZE 8192)
set(GENERIC_F100C8TX_dfu2_MCU cortex-m3)
set(GENERIC_F100C8TX_dfu2_FPCONF "-")
add_library(GENERIC_F100C8TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100C8TX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100C8TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100C8TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100C8TX"
	"BOARD_NAME=\"GENERIC_F100C8TX\""
	"BOARD_ID=GENERIC_F100C8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100C8TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100C8TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100C8TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100C8TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100C8TX_dfu2_MCU}
)


# GENERIC_F100C8TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100C8TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(8-B)T")
set(GENERIC_F100C8TX_dfuo_MAXSIZE 65536)
set(GENERIC_F100C8TX_dfuo_MAXDATASIZE 8192)
set(GENERIC_F100C8TX_dfuo_MCU cortex-m3)
set(GENERIC_F100C8TX_dfuo_FPCONF "-")
add_library(GENERIC_F100C8TX_dfuo INTERFACE)
target_compile_options(GENERIC_F100C8TX_dfuo INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100C8TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100C8TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100C8TX"
	"BOARD_NAME=\"GENERIC_F100C8TX\""
	"BOARD_ID=GENERIC_F100C8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100C8TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100C8TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100C8TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100C8TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100C8TX_dfuo_MCU}
)


# GENERIC_F100C8TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100C8TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(8-B)T")
set(GENERIC_F100C8TX_hid_MAXSIZE 65536)
set(GENERIC_F100C8TX_hid_MAXDATASIZE 8192)
set(GENERIC_F100C8TX_hid_MCU cortex-m3)
set(GENERIC_F100C8TX_hid_FPCONF "-")
add_library(GENERIC_F100C8TX_hid INTERFACE)
target_compile_options(GENERIC_F100C8TX_hid INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100C8TX_hid_MCU}
)
target_compile_definitions(GENERIC_F100C8TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100C8TX"
	"BOARD_NAME=\"GENERIC_F100C8TX\""
	"BOARD_ID=GENERIC_F100C8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100C8TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100C8TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100C8TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100C8TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100C8TX_hid_MCU}
)


# GENERIC_F100CBTX
# -----------------------------------------------------------------------------

set(GENERIC_F100CBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(8-B)T")
set(GENERIC_F100CBTX_MAXSIZE 131072)
set(GENERIC_F100CBTX_MAXDATASIZE 8192)
set(GENERIC_F100CBTX_MCU cortex-m3)
set(GENERIC_F100CBTX_FPCONF "-")
add_library(GENERIC_F100CBTX INTERFACE)
target_compile_options(GENERIC_F100CBTX INTERFACE
  "SHELL:-DSTM32F100xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100CBTX_MCU}
)
target_compile_definitions(GENERIC_F100CBTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100CBTX"
	"BOARD_NAME=\"GENERIC_F100CBTX\""
	"BOARD_ID=GENERIC_F100CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100CBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100CBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F100CBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F100CBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100CBTX_MCU}
)

add_library(GENERIC_F100CBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100CBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100CBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100CBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100CBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F100CBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100CBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100CBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100CBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100CBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100CBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100CBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100CBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F100CBTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100CBTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100CBTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100CBTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100CBTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100CBTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100CBTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100CBTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100CBTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(8-B)T")
set(GENERIC_F100CBTX_dfu2_MAXSIZE 131072)
set(GENERIC_F100CBTX_dfu2_MAXDATASIZE 8192)
set(GENERIC_F100CBTX_dfu2_MCU cortex-m3)
set(GENERIC_F100CBTX_dfu2_FPCONF "-")
add_library(GENERIC_F100CBTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100CBTX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100CBTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100CBTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100CBTX"
	"BOARD_NAME=\"GENERIC_F100CBTX\""
	"BOARD_ID=GENERIC_F100CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100CBTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100CBTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100CBTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100CBTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100CBTX_dfu2_MCU}
)


# GENERIC_F100CBTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100CBTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(8-B)T")
set(GENERIC_F100CBTX_dfuo_MAXSIZE 131072)
set(GENERIC_F100CBTX_dfuo_MAXDATASIZE 8192)
set(GENERIC_F100CBTX_dfuo_MCU cortex-m3)
set(GENERIC_F100CBTX_dfuo_FPCONF "-")
add_library(GENERIC_F100CBTX_dfuo INTERFACE)
target_compile_options(GENERIC_F100CBTX_dfuo INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100CBTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100CBTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100CBTX"
	"BOARD_NAME=\"GENERIC_F100CBTX\""
	"BOARD_ID=GENERIC_F100CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100CBTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100CBTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100CBTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100CBTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100CBTX_dfuo_MCU}
)


# GENERIC_F100CBTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100CBTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100C(8-B)T")
set(GENERIC_F100CBTX_hid_MAXSIZE 131072)
set(GENERIC_F100CBTX_hid_MAXDATASIZE 8192)
set(GENERIC_F100CBTX_hid_MCU cortex-m3)
set(GENERIC_F100CBTX_hid_FPCONF "-")
add_library(GENERIC_F100CBTX_hid INTERFACE)
target_compile_options(GENERIC_F100CBTX_hid INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100CBTX_hid_MCU}
)
target_compile_definitions(GENERIC_F100CBTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100CBTX"
	"BOARD_NAME=\"GENERIC_F100CBTX\""
	"BOARD_ID=GENERIC_F100CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100CBTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100CBTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100CBTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100CBTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100CBTX_hid_MCU}
)


# GENERIC_F100R4HX
# -----------------------------------------------------------------------------

set(GENERIC_F100R4HX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(4-6)H")
set(GENERIC_F100R4HX_MAXSIZE 16384)
set(GENERIC_F100R4HX_MAXDATASIZE 4096)
set(GENERIC_F100R4HX_MCU cortex-m3)
set(GENERIC_F100R4HX_FPCONF "-")
add_library(GENERIC_F100R4HX INTERFACE)
target_compile_options(GENERIC_F100R4HX INTERFACE
  "SHELL:-DSTM32F100xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100R4HX_MCU}
)
target_compile_definitions(GENERIC_F100R4HX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100R4HX"
	"BOARD_NAME=\"GENERIC_F100R4HX\""
	"BOARD_ID=GENERIC_F100R4HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100R4HX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100R4HX_VARIANT_PATH}
)

target_link_options(GENERIC_F100R4HX INTERFACE
  "LINKER:--default-script=${GENERIC_F100R4HX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100R4HX_MCU}
)

add_library(GENERIC_F100R4HX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100R4HX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100R4HX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100R4HX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100R4HX_serial_none INTERFACE)
target_compile_options(GENERIC_F100R4HX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100R4HX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100R4HX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100R4HX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100R4HX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100R4HX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100R4HX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100R4HX_usb_none INTERFACE)
target_compile_options(GENERIC_F100R4HX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100R4HX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100R4HX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100R4HX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100R4HX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100R4HX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100R4HX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100R4HX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100R4HX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(4-6)H")
set(GENERIC_F100R4HX_dfu2_MAXSIZE 16384)
set(GENERIC_F100R4HX_dfu2_MAXDATASIZE 4096)
set(GENERIC_F100R4HX_dfu2_MCU cortex-m3)
set(GENERIC_F100R4HX_dfu2_FPCONF "-")
add_library(GENERIC_F100R4HX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100R4HX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100R4HX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100R4HX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100R4HX"
	"BOARD_NAME=\"GENERIC_F100R4HX\""
	"BOARD_ID=GENERIC_F100R4HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100R4HX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100R4HX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100R4HX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100R4HX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100R4HX_dfu2_MCU}
)


# GENERIC_F100R4HX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100R4HX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(4-6)H")
set(GENERIC_F100R4HX_dfuo_MAXSIZE 16384)
set(GENERIC_F100R4HX_dfuo_MAXDATASIZE 4096)
set(GENERIC_F100R4HX_dfuo_MCU cortex-m3)
set(GENERIC_F100R4HX_dfuo_FPCONF "-")
add_library(GENERIC_F100R4HX_dfuo INTERFACE)
target_compile_options(GENERIC_F100R4HX_dfuo INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100R4HX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100R4HX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100R4HX"
	"BOARD_NAME=\"GENERIC_F100R4HX\""
	"BOARD_ID=GENERIC_F100R4HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100R4HX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100R4HX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100R4HX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100R4HX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100R4HX_dfuo_MCU}
)


# GENERIC_F100R4HX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100R4HX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(4-6)H")
set(GENERIC_F100R4HX_hid_MAXSIZE 16384)
set(GENERIC_F100R4HX_hid_MAXDATASIZE 4096)
set(GENERIC_F100R4HX_hid_MCU cortex-m3)
set(GENERIC_F100R4HX_hid_FPCONF "-")
add_library(GENERIC_F100R4HX_hid INTERFACE)
target_compile_options(GENERIC_F100R4HX_hid INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100R4HX_hid_MCU}
)
target_compile_definitions(GENERIC_F100R4HX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100R4HX"
	"BOARD_NAME=\"GENERIC_F100R4HX\""
	"BOARD_ID=GENERIC_F100R4HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100R4HX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100R4HX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100R4HX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100R4HX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100R4HX_hid_MCU}
)


# GENERIC_F100R6HX
# -----------------------------------------------------------------------------

set(GENERIC_F100R6HX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(4-6)H")
set(GENERIC_F100R6HX_MAXSIZE 32768)
set(GENERIC_F100R6HX_MAXDATASIZE 4096)
set(GENERIC_F100R6HX_MCU cortex-m3)
set(GENERIC_F100R6HX_FPCONF "-")
add_library(GENERIC_F100R6HX INTERFACE)
target_compile_options(GENERIC_F100R6HX INTERFACE
  "SHELL:-DSTM32F100xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100R6HX_MCU}
)
target_compile_definitions(GENERIC_F100R6HX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100R6HX"
	"BOARD_NAME=\"GENERIC_F100R6HX\""
	"BOARD_ID=GENERIC_F100R6HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100R6HX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100R6HX_VARIANT_PATH}
)

target_link_options(GENERIC_F100R6HX INTERFACE
  "LINKER:--default-script=${GENERIC_F100R6HX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100R6HX_MCU}
)

add_library(GENERIC_F100R6HX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100R6HX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100R6HX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100R6HX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100R6HX_serial_none INTERFACE)
target_compile_options(GENERIC_F100R6HX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100R6HX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100R6HX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100R6HX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100R6HX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100R6HX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100R6HX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100R6HX_usb_none INTERFACE)
target_compile_options(GENERIC_F100R6HX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100R6HX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100R6HX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100R6HX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100R6HX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100R6HX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100R6HX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100R6HX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100R6HX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(4-6)H")
set(GENERIC_F100R6HX_dfu2_MAXSIZE 32768)
set(GENERIC_F100R6HX_dfu2_MAXDATASIZE 4096)
set(GENERIC_F100R6HX_dfu2_MCU cortex-m3)
set(GENERIC_F100R6HX_dfu2_FPCONF "-")
add_library(GENERIC_F100R6HX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100R6HX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100R6HX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100R6HX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100R6HX"
	"BOARD_NAME=\"GENERIC_F100R6HX\""
	"BOARD_ID=GENERIC_F100R6HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100R6HX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100R6HX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100R6HX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100R6HX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100R6HX_dfu2_MCU}
)


# GENERIC_F100R6HX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100R6HX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(4-6)H")
set(GENERIC_F100R6HX_dfuo_MAXSIZE 32768)
set(GENERIC_F100R6HX_dfuo_MAXDATASIZE 4096)
set(GENERIC_F100R6HX_dfuo_MCU cortex-m3)
set(GENERIC_F100R6HX_dfuo_FPCONF "-")
add_library(GENERIC_F100R6HX_dfuo INTERFACE)
target_compile_options(GENERIC_F100R6HX_dfuo INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100R6HX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100R6HX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100R6HX"
	"BOARD_NAME=\"GENERIC_F100R6HX\""
	"BOARD_ID=GENERIC_F100R6HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100R6HX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100R6HX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100R6HX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100R6HX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100R6HX_dfuo_MCU}
)


# GENERIC_F100R6HX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100R6HX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(4-6)H")
set(GENERIC_F100R6HX_hid_MAXSIZE 32768)
set(GENERIC_F100R6HX_hid_MAXDATASIZE 4096)
set(GENERIC_F100R6HX_hid_MCU cortex-m3)
set(GENERIC_F100R6HX_hid_FPCONF "-")
add_library(GENERIC_F100R6HX_hid INTERFACE)
target_compile_options(GENERIC_F100R6HX_hid INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100R6HX_hid_MCU}
)
target_compile_definitions(GENERIC_F100R6HX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100R6HX"
	"BOARD_NAME=\"GENERIC_F100R6HX\""
	"BOARD_ID=GENERIC_F100R6HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100R6HX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100R6HX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100R6HX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100R6HX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F100R6HX_hid_MCU}
)


# GENERIC_F100R8TX
# -----------------------------------------------------------------------------

set(GENERIC_F100R8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(8-B)T")
set(GENERIC_F100R8TX_MAXSIZE 65536)
set(GENERIC_F100R8TX_MAXDATASIZE 8192)
set(GENERIC_F100R8TX_MCU cortex-m3)
set(GENERIC_F100R8TX_FPCONF "-")
add_library(GENERIC_F100R8TX INTERFACE)
target_compile_options(GENERIC_F100R8TX INTERFACE
  "SHELL:-DSTM32F100xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100R8TX_MCU}
)
target_compile_definitions(GENERIC_F100R8TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100R8TX"
	"BOARD_NAME=\"GENERIC_F100R8TX\""
	"BOARD_ID=GENERIC_F100R8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100R8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100R8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F100R8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F100R8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100R8TX_MCU}
)

add_library(GENERIC_F100R8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100R8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100R8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100R8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100R8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F100R8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100R8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100R8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100R8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100R8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100R8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100R8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100R8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F100R8TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100R8TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100R8TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100R8TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100R8TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100R8TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100R8TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100R8TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100R8TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(8-B)T")
set(GENERIC_F100R8TX_dfu2_MAXSIZE 65536)
set(GENERIC_F100R8TX_dfu2_MAXDATASIZE 8192)
set(GENERIC_F100R8TX_dfu2_MCU cortex-m3)
set(GENERIC_F100R8TX_dfu2_FPCONF "-")
add_library(GENERIC_F100R8TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100R8TX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100R8TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100R8TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100R8TX"
	"BOARD_NAME=\"GENERIC_F100R8TX\""
	"BOARD_ID=GENERIC_F100R8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100R8TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100R8TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100R8TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100R8TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100R8TX_dfu2_MCU}
)


# GENERIC_F100R8TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100R8TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(8-B)T")
set(GENERIC_F100R8TX_dfuo_MAXSIZE 65536)
set(GENERIC_F100R8TX_dfuo_MAXDATASIZE 8192)
set(GENERIC_F100R8TX_dfuo_MCU cortex-m3)
set(GENERIC_F100R8TX_dfuo_FPCONF "-")
add_library(GENERIC_F100R8TX_dfuo INTERFACE)
target_compile_options(GENERIC_F100R8TX_dfuo INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100R8TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100R8TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100R8TX"
	"BOARD_NAME=\"GENERIC_F100R8TX\""
	"BOARD_ID=GENERIC_F100R8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100R8TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100R8TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100R8TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100R8TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100R8TX_dfuo_MCU}
)


# GENERIC_F100R8TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100R8TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(8-B)T")
set(GENERIC_F100R8TX_hid_MAXSIZE 65536)
set(GENERIC_F100R8TX_hid_MAXDATASIZE 8192)
set(GENERIC_F100R8TX_hid_MCU cortex-m3)
set(GENERIC_F100R8TX_hid_FPCONF "-")
add_library(GENERIC_F100R8TX_hid INTERFACE)
target_compile_options(GENERIC_F100R8TX_hid INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100R8TX_hid_MCU}
)
target_compile_definitions(GENERIC_F100R8TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100R8TX"
	"BOARD_NAME=\"GENERIC_F100R8TX\""
	"BOARD_ID=GENERIC_F100R8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100R8TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100R8TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100R8TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100R8TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100R8TX_hid_MCU}
)


# GENERIC_F100RBTX
# -----------------------------------------------------------------------------

set(GENERIC_F100RBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(8-B)T")
set(GENERIC_F100RBTX_MAXSIZE 131072)
set(GENERIC_F100RBTX_MAXDATASIZE 8192)
set(GENERIC_F100RBTX_MCU cortex-m3)
set(GENERIC_F100RBTX_FPCONF "-")
add_library(GENERIC_F100RBTX INTERFACE)
target_compile_options(GENERIC_F100RBTX INTERFACE
  "SHELL:-DSTM32F100xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100RBTX_MCU}
)
target_compile_definitions(GENERIC_F100RBTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100RBTX"
	"BOARD_NAME=\"GENERIC_F100RBTX\""
	"BOARD_ID=GENERIC_F100RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100RBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100RBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F100RBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F100RBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100RBTX_MCU}
)

add_library(GENERIC_F100RBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100RBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100RBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100RBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100RBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F100RBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100RBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100RBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100RBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100RBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100RBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100RBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100RBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F100RBTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100RBTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100RBTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100RBTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100RBTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100RBTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100RBTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100RBTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100RBTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(8-B)T")
set(GENERIC_F100RBTX_dfu2_MAXSIZE 131072)
set(GENERIC_F100RBTX_dfu2_MAXDATASIZE 8192)
set(GENERIC_F100RBTX_dfu2_MCU cortex-m3)
set(GENERIC_F100RBTX_dfu2_FPCONF "-")
add_library(GENERIC_F100RBTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100RBTX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100RBTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100RBTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100RBTX"
	"BOARD_NAME=\"GENERIC_F100RBTX\""
	"BOARD_ID=GENERIC_F100RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100RBTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100RBTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100RBTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100RBTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100RBTX_dfu2_MCU}
)


# GENERIC_F100RBTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100RBTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(8-B)T")
set(GENERIC_F100RBTX_dfuo_MAXSIZE 131072)
set(GENERIC_F100RBTX_dfuo_MAXDATASIZE 8192)
set(GENERIC_F100RBTX_dfuo_MCU cortex-m3)
set(GENERIC_F100RBTX_dfuo_FPCONF "-")
add_library(GENERIC_F100RBTX_dfuo INTERFACE)
target_compile_options(GENERIC_F100RBTX_dfuo INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100RBTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100RBTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100RBTX"
	"BOARD_NAME=\"GENERIC_F100RBTX\""
	"BOARD_ID=GENERIC_F100RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100RBTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100RBTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100RBTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100RBTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100RBTX_dfuo_MCU}
)


# GENERIC_F100RBTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100RBTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100R(8-B)T")
set(GENERIC_F100RBTX_hid_MAXSIZE 131072)
set(GENERIC_F100RBTX_hid_MAXDATASIZE 8192)
set(GENERIC_F100RBTX_hid_MCU cortex-m3)
set(GENERIC_F100RBTX_hid_FPCONF "-")
add_library(GENERIC_F100RBTX_hid INTERFACE)
target_compile_options(GENERIC_F100RBTX_hid INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100RBTX_hid_MCU}
)
target_compile_definitions(GENERIC_F100RBTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100RBTX"
	"BOARD_NAME=\"GENERIC_F100RBTX\""
	"BOARD_ID=GENERIC_F100RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100RBTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100RBTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100RBTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100RBTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100RBTX_hid_MCU}
)


# GENERIC_F100V8TX
# -----------------------------------------------------------------------------

set(GENERIC_F100V8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100V(8-B)T")
set(GENERIC_F100V8TX_MAXSIZE 65536)
set(GENERIC_F100V8TX_MAXDATASIZE 8192)
set(GENERIC_F100V8TX_MCU cortex-m3)
set(GENERIC_F100V8TX_FPCONF "-")
add_library(GENERIC_F100V8TX INTERFACE)
target_compile_options(GENERIC_F100V8TX INTERFACE
  "SHELL:-DSTM32F100xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100V8TX_MCU}
)
target_compile_definitions(GENERIC_F100V8TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100V8TX"
	"BOARD_NAME=\"GENERIC_F100V8TX\""
	"BOARD_ID=GENERIC_F100V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100V8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100V8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F100V8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F100V8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100V8TX_MCU}
)

add_library(GENERIC_F100V8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100V8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100V8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100V8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100V8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F100V8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100V8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100V8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100V8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100V8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100V8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100V8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100V8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F100V8TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100V8TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100V8TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100V8TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100V8TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100V8TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100V8TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100V8TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100V8TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100V(8-B)T")
set(GENERIC_F100V8TX_dfu2_MAXSIZE 65536)
set(GENERIC_F100V8TX_dfu2_MAXDATASIZE 8192)
set(GENERIC_F100V8TX_dfu2_MCU cortex-m3)
set(GENERIC_F100V8TX_dfu2_FPCONF "-")
add_library(GENERIC_F100V8TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100V8TX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100V8TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100V8TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100V8TX"
	"BOARD_NAME=\"GENERIC_F100V8TX\""
	"BOARD_ID=GENERIC_F100V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100V8TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100V8TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100V8TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100V8TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100V8TX_dfu2_MCU}
)


# GENERIC_F100V8TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100V8TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100V(8-B)T")
set(GENERIC_F100V8TX_dfuo_MAXSIZE 65536)
set(GENERIC_F100V8TX_dfuo_MAXDATASIZE 8192)
set(GENERIC_F100V8TX_dfuo_MCU cortex-m3)
set(GENERIC_F100V8TX_dfuo_FPCONF "-")
add_library(GENERIC_F100V8TX_dfuo INTERFACE)
target_compile_options(GENERIC_F100V8TX_dfuo INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100V8TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100V8TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100V8TX"
	"BOARD_NAME=\"GENERIC_F100V8TX\""
	"BOARD_ID=GENERIC_F100V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100V8TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100V8TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100V8TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100V8TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100V8TX_dfuo_MCU}
)


# GENERIC_F100V8TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100V8TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100V(8-B)T")
set(GENERIC_F100V8TX_hid_MAXSIZE 65536)
set(GENERIC_F100V8TX_hid_MAXDATASIZE 8192)
set(GENERIC_F100V8TX_hid_MCU cortex-m3)
set(GENERIC_F100V8TX_hid_FPCONF "-")
add_library(GENERIC_F100V8TX_hid INTERFACE)
target_compile_options(GENERIC_F100V8TX_hid INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100V8TX_hid_MCU}
)
target_compile_definitions(GENERIC_F100V8TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100V8TX"
	"BOARD_NAME=\"GENERIC_F100V8TX\""
	"BOARD_ID=GENERIC_F100V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100V8TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100V8TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100V8TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100V8TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100V8TX_hid_MCU}
)


# GENERIC_F100VBTX
# -----------------------------------------------------------------------------

set(GENERIC_F100VBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100V(8-B)T")
set(GENERIC_F100VBTX_MAXSIZE 131072)
set(GENERIC_F100VBTX_MAXDATASIZE 8192)
set(GENERIC_F100VBTX_MCU cortex-m3)
set(GENERIC_F100VBTX_FPCONF "-")
add_library(GENERIC_F100VBTX INTERFACE)
target_compile_options(GENERIC_F100VBTX INTERFACE
  "SHELL:-DSTM32F100xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100VBTX_MCU}
)
target_compile_definitions(GENERIC_F100VBTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100VBTX"
	"BOARD_NAME=\"GENERIC_F100VBTX\""
	"BOARD_ID=GENERIC_F100VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100VBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100VBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F100VBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F100VBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100VBTX_MCU}
)

add_library(GENERIC_F100VBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100VBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100VBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100VBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100VBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F100VBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100VBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100VBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100VBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100VBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100VBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100VBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100VBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F100VBTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100VBTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100VBTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100VBTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100VBTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100VBTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100VBTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100VBTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100VBTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100V(8-B)T")
set(GENERIC_F100VBTX_dfu2_MAXSIZE 131072)
set(GENERIC_F100VBTX_dfu2_MAXDATASIZE 8192)
set(GENERIC_F100VBTX_dfu2_MCU cortex-m3)
set(GENERIC_F100VBTX_dfu2_FPCONF "-")
add_library(GENERIC_F100VBTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100VBTX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100VBTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100VBTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100VBTX"
	"BOARD_NAME=\"GENERIC_F100VBTX\""
	"BOARD_ID=GENERIC_F100VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100VBTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100VBTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100VBTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100VBTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100VBTX_dfu2_MCU}
)


# GENERIC_F100VBTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100VBTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100V(8-B)T")
set(GENERIC_F100VBTX_dfuo_MAXSIZE 131072)
set(GENERIC_F100VBTX_dfuo_MAXDATASIZE 8192)
set(GENERIC_F100VBTX_dfuo_MCU cortex-m3)
set(GENERIC_F100VBTX_dfuo_FPCONF "-")
add_library(GENERIC_F100VBTX_dfuo INTERFACE)
target_compile_options(GENERIC_F100VBTX_dfuo INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100VBTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100VBTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100VBTX"
	"BOARD_NAME=\"GENERIC_F100VBTX\""
	"BOARD_ID=GENERIC_F100VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100VBTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100VBTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100VBTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100VBTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100VBTX_dfuo_MCU}
)


# GENERIC_F100VBTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100VBTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100V(8-B)T")
set(GENERIC_F100VBTX_hid_MAXSIZE 131072)
set(GENERIC_F100VBTX_hid_MAXDATASIZE 8192)
set(GENERIC_F100VBTX_hid_MCU cortex-m3)
set(GENERIC_F100VBTX_hid_FPCONF "-")
add_library(GENERIC_F100VBTX_hid INTERFACE)
target_compile_options(GENERIC_F100VBTX_hid INTERFACE
  "SHELL:-DSTM32F100xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100VBTX_hid_MCU}
)
target_compile_definitions(GENERIC_F100VBTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100VBTX"
	"BOARD_NAME=\"GENERIC_F100VBTX\""
	"BOARD_ID=GENERIC_F100VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100VBTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100VBTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100VBTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100VBTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=8192"
  "SHELL: "
  -mcpu=${GENERIC_F100VBTX_hid_MCU}
)


# GENERIC_F100ZCTX
# -----------------------------------------------------------------------------

set(GENERIC_F100ZCTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100Z(C-D-E)T")
set(GENERIC_F100ZCTX_MAXSIZE 262144)
set(GENERIC_F100ZCTX_MAXDATASIZE 24576)
set(GENERIC_F100ZCTX_MCU cortex-m3)
set(GENERIC_F100ZCTX_FPCONF "-")
add_library(GENERIC_F100ZCTX INTERFACE)
target_compile_options(GENERIC_F100ZCTX INTERFACE
  "SHELL:-DSTM32F100xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100ZCTX_MCU}
)
target_compile_definitions(GENERIC_F100ZCTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100ZCTX"
	"BOARD_NAME=\"GENERIC_F100ZCTX\""
	"BOARD_ID=GENERIC_F100ZCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100ZCTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100ZCTX_VARIANT_PATH}
)

target_link_options(GENERIC_F100ZCTX INTERFACE
  "LINKER:--default-script=${GENERIC_F100ZCTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=24576"
  "SHELL: "
  -mcpu=${GENERIC_F100ZCTX_MCU}
)

add_library(GENERIC_F100ZCTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100ZCTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100ZCTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100ZCTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100ZCTX_serial_none INTERFACE)
target_compile_options(GENERIC_F100ZCTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100ZCTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100ZCTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100ZCTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100ZCTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100ZCTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100ZCTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100ZCTX_usb_none INTERFACE)
target_compile_options(GENERIC_F100ZCTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100ZCTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100ZCTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100ZCTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100ZCTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100ZCTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100ZCTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100ZCTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100ZCTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100Z(C-D-E)T")
set(GENERIC_F100ZCTX_dfu2_MAXSIZE 262144)
set(GENERIC_F100ZCTX_dfu2_MAXDATASIZE 24576)
set(GENERIC_F100ZCTX_dfu2_MCU cortex-m3)
set(GENERIC_F100ZCTX_dfu2_FPCONF "-")
add_library(GENERIC_F100ZCTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100ZCTX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100ZCTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100ZCTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100ZCTX"
	"BOARD_NAME=\"GENERIC_F100ZCTX\""
	"BOARD_ID=GENERIC_F100ZCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100ZCTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100ZCTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100ZCTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100ZCTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=24576"
  "SHELL: "
  -mcpu=${GENERIC_F100ZCTX_dfu2_MCU}
)


# GENERIC_F100ZCTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100ZCTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100Z(C-D-E)T")
set(GENERIC_F100ZCTX_dfuo_MAXSIZE 262144)
set(GENERIC_F100ZCTX_dfuo_MAXDATASIZE 24576)
set(GENERIC_F100ZCTX_dfuo_MCU cortex-m3)
set(GENERIC_F100ZCTX_dfuo_FPCONF "-")
add_library(GENERIC_F100ZCTX_dfuo INTERFACE)
target_compile_options(GENERIC_F100ZCTX_dfuo INTERFACE
  "SHELL:-DSTM32F100xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100ZCTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100ZCTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100ZCTX"
	"BOARD_NAME=\"GENERIC_F100ZCTX\""
	"BOARD_ID=GENERIC_F100ZCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100ZCTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100ZCTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100ZCTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100ZCTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=24576"
  "SHELL: "
  -mcpu=${GENERIC_F100ZCTX_dfuo_MCU}
)


# GENERIC_F100ZCTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100ZCTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100Z(C-D-E)T")
set(GENERIC_F100ZCTX_hid_MAXSIZE 262144)
set(GENERIC_F100ZCTX_hid_MAXDATASIZE 24576)
set(GENERIC_F100ZCTX_hid_MCU cortex-m3)
set(GENERIC_F100ZCTX_hid_FPCONF "-")
add_library(GENERIC_F100ZCTX_hid INTERFACE)
target_compile_options(GENERIC_F100ZCTX_hid INTERFACE
  "SHELL:-DSTM32F100xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100ZCTX_hid_MCU}
)
target_compile_definitions(GENERIC_F100ZCTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100ZCTX"
	"BOARD_NAME=\"GENERIC_F100ZCTX\""
	"BOARD_ID=GENERIC_F100ZCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100ZCTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100ZCTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100ZCTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100ZCTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=24576"
  "SHELL: "
  -mcpu=${GENERIC_F100ZCTX_hid_MCU}
)


# GENERIC_F100ZDTX
# -----------------------------------------------------------------------------

set(GENERIC_F100ZDTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100Z(C-D-E)T")
set(GENERIC_F100ZDTX_MAXSIZE 393216)
set(GENERIC_F100ZDTX_MAXDATASIZE 32768)
set(GENERIC_F100ZDTX_MCU cortex-m3)
set(GENERIC_F100ZDTX_FPCONF "-")
add_library(GENERIC_F100ZDTX INTERFACE)
target_compile_options(GENERIC_F100ZDTX INTERFACE
  "SHELL:-DSTM32F100xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100ZDTX_MCU}
)
target_compile_definitions(GENERIC_F100ZDTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100ZDTX"
	"BOARD_NAME=\"GENERIC_F100ZDTX\""
	"BOARD_ID=GENERIC_F100ZDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100ZDTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100ZDTX_VARIANT_PATH}
)

target_link_options(GENERIC_F100ZDTX INTERFACE
  "LINKER:--default-script=${GENERIC_F100ZDTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F100ZDTX_MCU}
)

add_library(GENERIC_F100ZDTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100ZDTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100ZDTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100ZDTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100ZDTX_serial_none INTERFACE)
target_compile_options(GENERIC_F100ZDTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100ZDTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100ZDTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100ZDTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100ZDTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100ZDTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100ZDTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100ZDTX_usb_none INTERFACE)
target_compile_options(GENERIC_F100ZDTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100ZDTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100ZDTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100ZDTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100ZDTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100ZDTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100ZDTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100ZDTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100ZDTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100Z(C-D-E)T")
set(GENERIC_F100ZDTX_dfu2_MAXSIZE 393216)
set(GENERIC_F100ZDTX_dfu2_MAXDATASIZE 32768)
set(GENERIC_F100ZDTX_dfu2_MCU cortex-m3)
set(GENERIC_F100ZDTX_dfu2_FPCONF "-")
add_library(GENERIC_F100ZDTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100ZDTX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100ZDTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100ZDTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100ZDTX"
	"BOARD_NAME=\"GENERIC_F100ZDTX\""
	"BOARD_ID=GENERIC_F100ZDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100ZDTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100ZDTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100ZDTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100ZDTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F100ZDTX_dfu2_MCU}
)


# GENERIC_F100ZDTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100ZDTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100Z(C-D-E)T")
set(GENERIC_F100ZDTX_dfuo_MAXSIZE 393216)
set(GENERIC_F100ZDTX_dfuo_MAXDATASIZE 32768)
set(GENERIC_F100ZDTX_dfuo_MCU cortex-m3)
set(GENERIC_F100ZDTX_dfuo_FPCONF "-")
add_library(GENERIC_F100ZDTX_dfuo INTERFACE)
target_compile_options(GENERIC_F100ZDTX_dfuo INTERFACE
  "SHELL:-DSTM32F100xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100ZDTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100ZDTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100ZDTX"
	"BOARD_NAME=\"GENERIC_F100ZDTX\""
	"BOARD_ID=GENERIC_F100ZDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100ZDTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100ZDTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100ZDTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100ZDTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F100ZDTX_dfuo_MCU}
)


# GENERIC_F100ZDTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100ZDTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100Z(C-D-E)T")
set(GENERIC_F100ZDTX_hid_MAXSIZE 393216)
set(GENERIC_F100ZDTX_hid_MAXDATASIZE 32768)
set(GENERIC_F100ZDTX_hid_MCU cortex-m3)
set(GENERIC_F100ZDTX_hid_FPCONF "-")
add_library(GENERIC_F100ZDTX_hid INTERFACE)
target_compile_options(GENERIC_F100ZDTX_hid INTERFACE
  "SHELL:-DSTM32F100xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100ZDTX_hid_MCU}
)
target_compile_definitions(GENERIC_F100ZDTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100ZDTX"
	"BOARD_NAME=\"GENERIC_F100ZDTX\""
	"BOARD_ID=GENERIC_F100ZDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100ZDTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100ZDTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100ZDTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100ZDTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F100ZDTX_hid_MCU}
)


# GENERIC_F100ZETX
# -----------------------------------------------------------------------------

set(GENERIC_F100ZETX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100Z(C-D-E)T")
set(GENERIC_F100ZETX_MAXSIZE 524288)
set(GENERIC_F100ZETX_MAXDATASIZE 32768)
set(GENERIC_F100ZETX_MCU cortex-m3)
set(GENERIC_F100ZETX_FPCONF "-")
add_library(GENERIC_F100ZETX INTERFACE)
target_compile_options(GENERIC_F100ZETX INTERFACE
  "SHELL:-DSTM32F100xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100ZETX_MCU}
)
target_compile_definitions(GENERIC_F100ZETX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100ZETX"
	"BOARD_NAME=\"GENERIC_F100ZETX\""
	"BOARD_ID=GENERIC_F100ZETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100ZETX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100ZETX_VARIANT_PATH}
)

target_link_options(GENERIC_F100ZETX INTERFACE
  "LINKER:--default-script=${GENERIC_F100ZETX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F100ZETX_MCU}
)

add_library(GENERIC_F100ZETX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F100ZETX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100ZETX_serial_generic INTERFACE)
target_compile_options(GENERIC_F100ZETX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F100ZETX_serial_none INTERFACE)
target_compile_options(GENERIC_F100ZETX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F100ZETX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F100ZETX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F100ZETX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F100ZETX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F100ZETX_usb_HID INTERFACE)
target_compile_options(GENERIC_F100ZETX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F100ZETX_usb_none INTERFACE)
target_compile_options(GENERIC_F100ZETX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100ZETX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F100ZETX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F100ZETX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F100ZETX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F100ZETX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F100ZETX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F100ZETX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F100ZETX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100Z(C-D-E)T")
set(GENERIC_F100ZETX_dfu2_MAXSIZE 524288)
set(GENERIC_F100ZETX_dfu2_MAXDATASIZE 32768)
set(GENERIC_F100ZETX_dfu2_MCU cortex-m3)
set(GENERIC_F100ZETX_dfu2_FPCONF "-")
add_library(GENERIC_F100ZETX_dfu2 INTERFACE)
target_compile_options(GENERIC_F100ZETX_dfu2 INTERFACE
  "SHELL:-DSTM32F100xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100ZETX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F100ZETX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100ZETX"
	"BOARD_NAME=\"GENERIC_F100ZETX\""
	"BOARD_ID=GENERIC_F100ZETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100ZETX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100ZETX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F100ZETX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F100ZETX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F100ZETX_dfu2_MCU}
)


# GENERIC_F100ZETX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F100ZETX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100Z(C-D-E)T")
set(GENERIC_F100ZETX_dfuo_MAXSIZE 524288)
set(GENERIC_F100ZETX_dfuo_MAXDATASIZE 32768)
set(GENERIC_F100ZETX_dfuo_MCU cortex-m3)
set(GENERIC_F100ZETX_dfuo_FPCONF "-")
add_library(GENERIC_F100ZETX_dfuo INTERFACE)
target_compile_options(GENERIC_F100ZETX_dfuo INTERFACE
  "SHELL:-DSTM32F100xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100ZETX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F100ZETX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100ZETX"
	"BOARD_NAME=\"GENERIC_F100ZETX\""
	"BOARD_ID=GENERIC_F100ZETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100ZETX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100ZETX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F100ZETX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F100ZETX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F100ZETX_dfuo_MCU}
)


# GENERIC_F100ZETX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F100ZETX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F100Z(C-D-E)T")
set(GENERIC_F100ZETX_hid_MAXSIZE 524288)
set(GENERIC_F100ZETX_hid_MAXDATASIZE 32768)
set(GENERIC_F100ZETX_hid_MCU cortex-m3)
set(GENERIC_F100ZETX_hid_FPCONF "-")
add_library(GENERIC_F100ZETX_hid INTERFACE)
target_compile_options(GENERIC_F100ZETX_hid INTERFACE
  "SHELL:-DSTM32F100xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F100ZETX_hid_MCU}
)
target_compile_definitions(GENERIC_F100ZETX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F100ZETX"
	"BOARD_NAME=\"GENERIC_F100ZETX\""
	"BOARD_ID=GENERIC_F100ZETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F100ZETX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F100ZETX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F100ZETX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F100ZETX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F100ZETX_hid_MCU}
)


# GENERIC_F101C4TX
# -----------------------------------------------------------------------------

set(GENERIC_F101C4TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101C(4-6)T")
set(GENERIC_F101C4TX_MAXSIZE 16384)
set(GENERIC_F101C4TX_MAXDATASIZE 4096)
set(GENERIC_F101C4TX_MCU cortex-m3)
set(GENERIC_F101C4TX_FPCONF "-")
add_library(GENERIC_F101C4TX INTERFACE)
target_compile_options(GENERIC_F101C4TX INTERFACE
  "SHELL:-DSTM32F101x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101C4TX_MCU}
)
target_compile_definitions(GENERIC_F101C4TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101C4TX"
	"BOARD_NAME=\"GENERIC_F101C4TX\""
	"BOARD_ID=GENERIC_F101C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101C4TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101C4TX_VARIANT_PATH}
)

target_link_options(GENERIC_F101C4TX INTERFACE
  "LINKER:--default-script=${GENERIC_F101C4TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F101C4TX_MCU}
)

add_library(GENERIC_F101C4TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F101C4TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101C4TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F101C4TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F101C4TX_serial_none INTERFACE)
target_compile_options(GENERIC_F101C4TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F101C4TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F101C4TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F101C4TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F101C4TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F101C4TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F101C4TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F101C4TX_usb_none INTERFACE)
target_compile_options(GENERIC_F101C4TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101C4TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F101C4TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101C4TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F101C4TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F101C4TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F101C4TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F101C4TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F101C4TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101C(4-6)T")
set(GENERIC_F101C4TX_dfu2_MAXSIZE 16384)
set(GENERIC_F101C4TX_dfu2_MAXDATASIZE 4096)
set(GENERIC_F101C4TX_dfu2_MCU cortex-m3)
set(GENERIC_F101C4TX_dfu2_FPCONF "-")
add_library(GENERIC_F101C4TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F101C4TX_dfu2 INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101C4TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F101C4TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101C4TX"
	"BOARD_NAME=\"GENERIC_F101C4TX\""
	"BOARD_ID=GENERIC_F101C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101C4TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101C4TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F101C4TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F101C4TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F101C4TX_dfu2_MCU}
)


# GENERIC_F101C4TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F101C4TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101C(4-6)T")
set(GENERIC_F101C4TX_dfuo_MAXSIZE 16384)
set(GENERIC_F101C4TX_dfuo_MAXDATASIZE 4096)
set(GENERIC_F101C4TX_dfuo_MCU cortex-m3)
set(GENERIC_F101C4TX_dfuo_FPCONF "-")
add_library(GENERIC_F101C4TX_dfuo INTERFACE)
target_compile_options(GENERIC_F101C4TX_dfuo INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101C4TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F101C4TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101C4TX"
	"BOARD_NAME=\"GENERIC_F101C4TX\""
	"BOARD_ID=GENERIC_F101C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101C4TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101C4TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F101C4TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F101C4TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F101C4TX_dfuo_MCU}
)


# GENERIC_F101C4TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F101C4TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101C(4-6)T")
set(GENERIC_F101C4TX_hid_MAXSIZE 16384)
set(GENERIC_F101C4TX_hid_MAXDATASIZE 4096)
set(GENERIC_F101C4TX_hid_MCU cortex-m3)
set(GENERIC_F101C4TX_hid_FPCONF "-")
add_library(GENERIC_F101C4TX_hid INTERFACE)
target_compile_options(GENERIC_F101C4TX_hid INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101C4TX_hid_MCU}
)
target_compile_definitions(GENERIC_F101C4TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101C4TX"
	"BOARD_NAME=\"GENERIC_F101C4TX\""
	"BOARD_ID=GENERIC_F101C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101C4TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101C4TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F101C4TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F101C4TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F101C4TX_hid_MCU}
)


# GENERIC_F101C6TX
# -----------------------------------------------------------------------------

set(GENERIC_F101C6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101C(4-6)T")
set(GENERIC_F101C6TX_MAXSIZE 32768)
set(GENERIC_F101C6TX_MAXDATASIZE 6144)
set(GENERIC_F101C6TX_MCU cortex-m3)
set(GENERIC_F101C6TX_FPCONF "-")
add_library(GENERIC_F101C6TX INTERFACE)
target_compile_options(GENERIC_F101C6TX INTERFACE
  "SHELL:-DSTM32F101x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101C6TX_MCU}
)
target_compile_definitions(GENERIC_F101C6TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101C6TX"
	"BOARD_NAME=\"GENERIC_F101C6TX\""
	"BOARD_ID=GENERIC_F101C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101C6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101C6TX_VARIANT_PATH}
)

target_link_options(GENERIC_F101C6TX INTERFACE
  "LINKER:--default-script=${GENERIC_F101C6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F101C6TX_MCU}
)

add_library(GENERIC_F101C6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F101C6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101C6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F101C6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F101C6TX_serial_none INTERFACE)
target_compile_options(GENERIC_F101C6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F101C6TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F101C6TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F101C6TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F101C6TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F101C6TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F101C6TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F101C6TX_usb_none INTERFACE)
target_compile_options(GENERIC_F101C6TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101C6TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F101C6TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101C6TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F101C6TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F101C6TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F101C6TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F101C6TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F101C6TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101C(4-6)T")
set(GENERIC_F101C6TX_dfu2_MAXSIZE 32768)
set(GENERIC_F101C6TX_dfu2_MAXDATASIZE 6144)
set(GENERIC_F101C6TX_dfu2_MCU cortex-m3)
set(GENERIC_F101C6TX_dfu2_FPCONF "-")
add_library(GENERIC_F101C6TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F101C6TX_dfu2 INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101C6TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F101C6TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101C6TX"
	"BOARD_NAME=\"GENERIC_F101C6TX\""
	"BOARD_ID=GENERIC_F101C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101C6TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101C6TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F101C6TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F101C6TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F101C6TX_dfu2_MCU}
)


# GENERIC_F101C6TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F101C6TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101C(4-6)T")
set(GENERIC_F101C6TX_dfuo_MAXSIZE 32768)
set(GENERIC_F101C6TX_dfuo_MAXDATASIZE 6144)
set(GENERIC_F101C6TX_dfuo_MCU cortex-m3)
set(GENERIC_F101C6TX_dfuo_FPCONF "-")
add_library(GENERIC_F101C6TX_dfuo INTERFACE)
target_compile_options(GENERIC_F101C6TX_dfuo INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101C6TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F101C6TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101C6TX"
	"BOARD_NAME=\"GENERIC_F101C6TX\""
	"BOARD_ID=GENERIC_F101C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101C6TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101C6TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F101C6TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F101C6TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F101C6TX_dfuo_MCU}
)


# GENERIC_F101C6TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F101C6TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101C(4-6)T")
set(GENERIC_F101C6TX_hid_MAXSIZE 32768)
set(GENERIC_F101C6TX_hid_MAXDATASIZE 6144)
set(GENERIC_F101C6TX_hid_MCU cortex-m3)
set(GENERIC_F101C6TX_hid_FPCONF "-")
add_library(GENERIC_F101C6TX_hid INTERFACE)
target_compile_options(GENERIC_F101C6TX_hid INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101C6TX_hid_MCU}
)
target_compile_definitions(GENERIC_F101C6TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101C6TX"
	"BOARD_NAME=\"GENERIC_F101C6TX\""
	"BOARD_ID=GENERIC_F101C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101C6TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101C6TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F101C6TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F101C6TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F101C6TX_hid_MCU}
)


# GENERIC_F101R4TX
# -----------------------------------------------------------------------------

set(GENERIC_F101R4TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101R(4-6)T")
set(GENERIC_F101R4TX_MAXSIZE 16384)
set(GENERIC_F101R4TX_MAXDATASIZE 4096)
set(GENERIC_F101R4TX_MCU cortex-m3)
set(GENERIC_F101R4TX_FPCONF "-")
add_library(GENERIC_F101R4TX INTERFACE)
target_compile_options(GENERIC_F101R4TX INTERFACE
  "SHELL:-DSTM32F101x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101R4TX_MCU}
)
target_compile_definitions(GENERIC_F101R4TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101R4TX"
	"BOARD_NAME=\"GENERIC_F101R4TX\""
	"BOARD_ID=GENERIC_F101R4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101R4TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101R4TX_VARIANT_PATH}
)

target_link_options(GENERIC_F101R4TX INTERFACE
  "LINKER:--default-script=${GENERIC_F101R4TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F101R4TX_MCU}
)

add_library(GENERIC_F101R4TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F101R4TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101R4TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F101R4TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F101R4TX_serial_none INTERFACE)
target_compile_options(GENERIC_F101R4TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F101R4TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F101R4TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F101R4TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F101R4TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F101R4TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F101R4TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F101R4TX_usb_none INTERFACE)
target_compile_options(GENERIC_F101R4TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101R4TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F101R4TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101R4TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F101R4TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F101R4TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F101R4TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F101R4TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F101R4TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101R(4-6)T")
set(GENERIC_F101R4TX_dfu2_MAXSIZE 16384)
set(GENERIC_F101R4TX_dfu2_MAXDATASIZE 4096)
set(GENERIC_F101R4TX_dfu2_MCU cortex-m3)
set(GENERIC_F101R4TX_dfu2_FPCONF "-")
add_library(GENERIC_F101R4TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F101R4TX_dfu2 INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101R4TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F101R4TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101R4TX"
	"BOARD_NAME=\"GENERIC_F101R4TX\""
	"BOARD_ID=GENERIC_F101R4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101R4TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101R4TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F101R4TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F101R4TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F101R4TX_dfu2_MCU}
)


# GENERIC_F101R4TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F101R4TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101R(4-6)T")
set(GENERIC_F101R4TX_dfuo_MAXSIZE 16384)
set(GENERIC_F101R4TX_dfuo_MAXDATASIZE 4096)
set(GENERIC_F101R4TX_dfuo_MCU cortex-m3)
set(GENERIC_F101R4TX_dfuo_FPCONF "-")
add_library(GENERIC_F101R4TX_dfuo INTERFACE)
target_compile_options(GENERIC_F101R4TX_dfuo INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101R4TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F101R4TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101R4TX"
	"BOARD_NAME=\"GENERIC_F101R4TX\""
	"BOARD_ID=GENERIC_F101R4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101R4TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101R4TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F101R4TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F101R4TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F101R4TX_dfuo_MCU}
)


# GENERIC_F101R4TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F101R4TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101R(4-6)T")
set(GENERIC_F101R4TX_hid_MAXSIZE 16384)
set(GENERIC_F101R4TX_hid_MAXDATASIZE 4096)
set(GENERIC_F101R4TX_hid_MCU cortex-m3)
set(GENERIC_F101R4TX_hid_FPCONF "-")
add_library(GENERIC_F101R4TX_hid INTERFACE)
target_compile_options(GENERIC_F101R4TX_hid INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101R4TX_hid_MCU}
)
target_compile_definitions(GENERIC_F101R4TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101R4TX"
	"BOARD_NAME=\"GENERIC_F101R4TX\""
	"BOARD_ID=GENERIC_F101R4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101R4TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101R4TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F101R4TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F101R4TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F101R4TX_hid_MCU}
)


# GENERIC_F101R6TX
# -----------------------------------------------------------------------------

set(GENERIC_F101R6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101R(4-6)T")
set(GENERIC_F101R6TX_MAXSIZE 32768)
set(GENERIC_F101R6TX_MAXDATASIZE 6144)
set(GENERIC_F101R6TX_MCU cortex-m3)
set(GENERIC_F101R6TX_FPCONF "-")
add_library(GENERIC_F101R6TX INTERFACE)
target_compile_options(GENERIC_F101R6TX INTERFACE
  "SHELL:-DSTM32F101x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101R6TX_MCU}
)
target_compile_definitions(GENERIC_F101R6TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101R6TX"
	"BOARD_NAME=\"GENERIC_F101R6TX\""
	"BOARD_ID=GENERIC_F101R6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101R6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101R6TX_VARIANT_PATH}
)

target_link_options(GENERIC_F101R6TX INTERFACE
  "LINKER:--default-script=${GENERIC_F101R6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F101R6TX_MCU}
)

add_library(GENERIC_F101R6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F101R6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101R6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F101R6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F101R6TX_serial_none INTERFACE)
target_compile_options(GENERIC_F101R6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F101R6TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F101R6TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F101R6TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F101R6TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F101R6TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F101R6TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F101R6TX_usb_none INTERFACE)
target_compile_options(GENERIC_F101R6TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101R6TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F101R6TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101R6TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F101R6TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F101R6TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F101R6TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F101R6TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F101R6TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101R(4-6)T")
set(GENERIC_F101R6TX_dfu2_MAXSIZE 32768)
set(GENERIC_F101R6TX_dfu2_MAXDATASIZE 6144)
set(GENERIC_F101R6TX_dfu2_MCU cortex-m3)
set(GENERIC_F101R6TX_dfu2_FPCONF "-")
add_library(GENERIC_F101R6TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F101R6TX_dfu2 INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101R6TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F101R6TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101R6TX"
	"BOARD_NAME=\"GENERIC_F101R6TX\""
	"BOARD_ID=GENERIC_F101R6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101R6TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101R6TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F101R6TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F101R6TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F101R6TX_dfu2_MCU}
)


# GENERIC_F101R6TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F101R6TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101R(4-6)T")
set(GENERIC_F101R6TX_dfuo_MAXSIZE 32768)
set(GENERIC_F101R6TX_dfuo_MAXDATASIZE 6144)
set(GENERIC_F101R6TX_dfuo_MCU cortex-m3)
set(GENERIC_F101R6TX_dfuo_FPCONF "-")
add_library(GENERIC_F101R6TX_dfuo INTERFACE)
target_compile_options(GENERIC_F101R6TX_dfuo INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101R6TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F101R6TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101R6TX"
	"BOARD_NAME=\"GENERIC_F101R6TX\""
	"BOARD_ID=GENERIC_F101R6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101R6TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101R6TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F101R6TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F101R6TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F101R6TX_dfuo_MCU}
)


# GENERIC_F101R6TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F101R6TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101R(4-6)T")
set(GENERIC_F101R6TX_hid_MAXSIZE 32768)
set(GENERIC_F101R6TX_hid_MAXDATASIZE 6144)
set(GENERIC_F101R6TX_hid_MCU cortex-m3)
set(GENERIC_F101R6TX_hid_FPCONF "-")
add_library(GENERIC_F101R6TX_hid INTERFACE)
target_compile_options(GENERIC_F101R6TX_hid INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101R6TX_hid_MCU}
)
target_compile_definitions(GENERIC_F101R6TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101R6TX"
	"BOARD_NAME=\"GENERIC_F101R6TX\""
	"BOARD_ID=GENERIC_F101R6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101R6TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101R6TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F101R6TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F101R6TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F101R6TX_hid_MCU}
)


# GENERIC_F101T4UX
# -----------------------------------------------------------------------------

set(GENERIC_F101T4UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101T(4-6)U")
set(GENERIC_F101T4UX_MAXSIZE 16384)
set(GENERIC_F101T4UX_MAXDATASIZE 4096)
set(GENERIC_F101T4UX_MCU cortex-m3)
set(GENERIC_F101T4UX_FPCONF "-")
add_library(GENERIC_F101T4UX INTERFACE)
target_compile_options(GENERIC_F101T4UX INTERFACE
  "SHELL:-DSTM32F101x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101T4UX_MCU}
)
target_compile_definitions(GENERIC_F101T4UX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101T4UX"
	"BOARD_NAME=\"GENERIC_F101T4UX\""
	"BOARD_ID=GENERIC_F101T4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101T4UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101T4UX_VARIANT_PATH}
)

target_link_options(GENERIC_F101T4UX INTERFACE
  "LINKER:--default-script=${GENERIC_F101T4UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F101T4UX_MCU}
)

add_library(GENERIC_F101T4UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F101T4UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101T4UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F101T4UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F101T4UX_serial_none INTERFACE)
target_compile_options(GENERIC_F101T4UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F101T4UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F101T4UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F101T4UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F101T4UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F101T4UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F101T4UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F101T4UX_usb_none INTERFACE)
target_compile_options(GENERIC_F101T4UX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101T4UX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F101T4UX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101T4UX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F101T4UX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F101T4UX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F101T4UX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F101T4UX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F101T4UX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101T(4-6)U")
set(GENERIC_F101T4UX_dfu2_MAXSIZE 16384)
set(GENERIC_F101T4UX_dfu2_MAXDATASIZE 4096)
set(GENERIC_F101T4UX_dfu2_MCU cortex-m3)
set(GENERIC_F101T4UX_dfu2_FPCONF "-")
add_library(GENERIC_F101T4UX_dfu2 INTERFACE)
target_compile_options(GENERIC_F101T4UX_dfu2 INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101T4UX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F101T4UX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101T4UX"
	"BOARD_NAME=\"GENERIC_F101T4UX\""
	"BOARD_ID=GENERIC_F101T4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101T4UX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101T4UX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F101T4UX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F101T4UX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F101T4UX_dfu2_MCU}
)


# GENERIC_F101T4UX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F101T4UX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101T(4-6)U")
set(GENERIC_F101T4UX_dfuo_MAXSIZE 16384)
set(GENERIC_F101T4UX_dfuo_MAXDATASIZE 4096)
set(GENERIC_F101T4UX_dfuo_MCU cortex-m3)
set(GENERIC_F101T4UX_dfuo_FPCONF "-")
add_library(GENERIC_F101T4UX_dfuo INTERFACE)
target_compile_options(GENERIC_F101T4UX_dfuo INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101T4UX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F101T4UX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101T4UX"
	"BOARD_NAME=\"GENERIC_F101T4UX\""
	"BOARD_ID=GENERIC_F101T4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101T4UX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101T4UX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F101T4UX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F101T4UX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F101T4UX_dfuo_MCU}
)


# GENERIC_F101T4UX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F101T4UX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101T(4-6)U")
set(GENERIC_F101T4UX_hid_MAXSIZE 16384)
set(GENERIC_F101T4UX_hid_MAXDATASIZE 4096)
set(GENERIC_F101T4UX_hid_MCU cortex-m3)
set(GENERIC_F101T4UX_hid_FPCONF "-")
add_library(GENERIC_F101T4UX_hid INTERFACE)
target_compile_options(GENERIC_F101T4UX_hid INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101T4UX_hid_MCU}
)
target_compile_definitions(GENERIC_F101T4UX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101T4UX"
	"BOARD_NAME=\"GENERIC_F101T4UX\""
	"BOARD_ID=GENERIC_F101T4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101T4UX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101T4UX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F101T4UX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F101T4UX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=4096"
  "SHELL: "
  -mcpu=${GENERIC_F101T4UX_hid_MCU}
)


# GENERIC_F101T6UX
# -----------------------------------------------------------------------------

set(GENERIC_F101T6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101T(4-6)U")
set(GENERIC_F101T6UX_MAXSIZE 32768)
set(GENERIC_F101T6UX_MAXDATASIZE 6144)
set(GENERIC_F101T6UX_MCU cortex-m3)
set(GENERIC_F101T6UX_FPCONF "-")
add_library(GENERIC_F101T6UX INTERFACE)
target_compile_options(GENERIC_F101T6UX INTERFACE
  "SHELL:-DSTM32F101x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101T6UX_MCU}
)
target_compile_definitions(GENERIC_F101T6UX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101T6UX"
	"BOARD_NAME=\"GENERIC_F101T6UX\""
	"BOARD_ID=GENERIC_F101T6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101T6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101T6UX_VARIANT_PATH}
)

target_link_options(GENERIC_F101T6UX INTERFACE
  "LINKER:--default-script=${GENERIC_F101T6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F101T6UX_MCU}
)

add_library(GENERIC_F101T6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F101T6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101T6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F101T6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F101T6UX_serial_none INTERFACE)
target_compile_options(GENERIC_F101T6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F101T6UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F101T6UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F101T6UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F101T6UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F101T6UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F101T6UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F101T6UX_usb_none INTERFACE)
target_compile_options(GENERIC_F101T6UX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101T6UX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F101T6UX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101T6UX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F101T6UX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F101T6UX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F101T6UX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F101T6UX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F101T6UX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101T(4-6)U")
set(GENERIC_F101T6UX_dfu2_MAXSIZE 32768)
set(GENERIC_F101T6UX_dfu2_MAXDATASIZE 6144)
set(GENERIC_F101T6UX_dfu2_MCU cortex-m3)
set(GENERIC_F101T6UX_dfu2_FPCONF "-")
add_library(GENERIC_F101T6UX_dfu2 INTERFACE)
target_compile_options(GENERIC_F101T6UX_dfu2 INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101T6UX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F101T6UX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101T6UX"
	"BOARD_NAME=\"GENERIC_F101T6UX\""
	"BOARD_ID=GENERIC_F101T6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101T6UX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101T6UX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F101T6UX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F101T6UX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F101T6UX_dfu2_MCU}
)


# GENERIC_F101T6UX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F101T6UX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101T(4-6)U")
set(GENERIC_F101T6UX_dfuo_MAXSIZE 32768)
set(GENERIC_F101T6UX_dfuo_MAXDATASIZE 6144)
set(GENERIC_F101T6UX_dfuo_MCU cortex-m3)
set(GENERIC_F101T6UX_dfuo_FPCONF "-")
add_library(GENERIC_F101T6UX_dfuo INTERFACE)
target_compile_options(GENERIC_F101T6UX_dfuo INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101T6UX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F101T6UX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101T6UX"
	"BOARD_NAME=\"GENERIC_F101T6UX\""
	"BOARD_ID=GENERIC_F101T6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101T6UX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101T6UX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F101T6UX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F101T6UX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F101T6UX_dfuo_MCU}
)


# GENERIC_F101T6UX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F101T6UX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101T(4-6)U")
set(GENERIC_F101T6UX_hid_MAXSIZE 32768)
set(GENERIC_F101T6UX_hid_MAXDATASIZE 6144)
set(GENERIC_F101T6UX_hid_MCU cortex-m3)
set(GENERIC_F101T6UX_hid_FPCONF "-")
add_library(GENERIC_F101T6UX_hid INTERFACE)
target_compile_options(GENERIC_F101T6UX_hid INTERFACE
  "SHELL:-DSTM32F101x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101T6UX_hid_MCU}
)
target_compile_definitions(GENERIC_F101T6UX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101T6UX"
	"BOARD_NAME=\"GENERIC_F101T6UX\""
	"BOARD_ID=GENERIC_F101T6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101T6UX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101T6UX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F101T6UX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F101T6UX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F101T6UX_hid_MCU}
)


# GENERIC_F101V8TX
# -----------------------------------------------------------------------------

set(GENERIC_F101V8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101V(8-B)T")
set(GENERIC_F101V8TX_MAXSIZE 65536)
set(GENERIC_F101V8TX_MAXDATASIZE 10240)
set(GENERIC_F101V8TX_MCU cortex-m3)
set(GENERIC_F101V8TX_FPCONF "-")
add_library(GENERIC_F101V8TX INTERFACE)
target_compile_options(GENERIC_F101V8TX INTERFACE
  "SHELL:-DSTM32F101xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101V8TX_MCU}
)
target_compile_definitions(GENERIC_F101V8TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101V8TX"
	"BOARD_NAME=\"GENERIC_F101V8TX\""
	"BOARD_ID=GENERIC_F101V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101V8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101V8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F101V8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F101V8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F101V8TX_MCU}
)

add_library(GENERIC_F101V8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F101V8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101V8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F101V8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F101V8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F101V8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F101V8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F101V8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F101V8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F101V8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F101V8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F101V8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F101V8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F101V8TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101V8TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F101V8TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101V8TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F101V8TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F101V8TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F101V8TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F101V8TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F101V8TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101V(8-B)T")
set(GENERIC_F101V8TX_dfu2_MAXSIZE 65536)
set(GENERIC_F101V8TX_dfu2_MAXDATASIZE 10240)
set(GENERIC_F101V8TX_dfu2_MCU cortex-m3)
set(GENERIC_F101V8TX_dfu2_FPCONF "-")
add_library(GENERIC_F101V8TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F101V8TX_dfu2 INTERFACE
  "SHELL:-DSTM32F101xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101V8TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F101V8TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101V8TX"
	"BOARD_NAME=\"GENERIC_F101V8TX\""
	"BOARD_ID=GENERIC_F101V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101V8TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101V8TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F101V8TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F101V8TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F101V8TX_dfu2_MCU}
)


# GENERIC_F101V8TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F101V8TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101V(8-B)T")
set(GENERIC_F101V8TX_dfuo_MAXSIZE 65536)
set(GENERIC_F101V8TX_dfuo_MAXDATASIZE 10240)
set(GENERIC_F101V8TX_dfuo_MCU cortex-m3)
set(GENERIC_F101V8TX_dfuo_FPCONF "-")
add_library(GENERIC_F101V8TX_dfuo INTERFACE)
target_compile_options(GENERIC_F101V8TX_dfuo INTERFACE
  "SHELL:-DSTM32F101xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101V8TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F101V8TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101V8TX"
	"BOARD_NAME=\"GENERIC_F101V8TX\""
	"BOARD_ID=GENERIC_F101V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101V8TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101V8TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F101V8TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F101V8TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F101V8TX_dfuo_MCU}
)


# GENERIC_F101V8TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F101V8TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101V(8-B)T")
set(GENERIC_F101V8TX_hid_MAXSIZE 65536)
set(GENERIC_F101V8TX_hid_MAXDATASIZE 10240)
set(GENERIC_F101V8TX_hid_MCU cortex-m3)
set(GENERIC_F101V8TX_hid_FPCONF "-")
add_library(GENERIC_F101V8TX_hid INTERFACE)
target_compile_options(GENERIC_F101V8TX_hid INTERFACE
  "SHELL:-DSTM32F101xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101V8TX_hid_MCU}
)
target_compile_definitions(GENERIC_F101V8TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101V8TX"
	"BOARD_NAME=\"GENERIC_F101V8TX\""
	"BOARD_ID=GENERIC_F101V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101V8TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101V8TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F101V8TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F101V8TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F101V8TX_hid_MCU}
)


# GENERIC_F101VBTX
# -----------------------------------------------------------------------------

set(GENERIC_F101VBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101V(8-B)T")
set(GENERIC_F101VBTX_MAXSIZE 131072)
set(GENERIC_F101VBTX_MAXDATASIZE 16384)
set(GENERIC_F101VBTX_MCU cortex-m3)
set(GENERIC_F101VBTX_FPCONF "-")
add_library(GENERIC_F101VBTX INTERFACE)
target_compile_options(GENERIC_F101VBTX INTERFACE
  "SHELL:-DSTM32F101xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101VBTX_MCU}
)
target_compile_definitions(GENERIC_F101VBTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101VBTX"
	"BOARD_NAME=\"GENERIC_F101VBTX\""
	"BOARD_ID=GENERIC_F101VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101VBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101VBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F101VBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F101VBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F101VBTX_MCU}
)

add_library(GENERIC_F101VBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F101VBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101VBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F101VBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F101VBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F101VBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F101VBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F101VBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F101VBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F101VBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F101VBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F101VBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F101VBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F101VBTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101VBTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F101VBTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101VBTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F101VBTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F101VBTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F101VBTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F101VBTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F101VBTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101V(8-B)T")
set(GENERIC_F101VBTX_dfu2_MAXSIZE 131072)
set(GENERIC_F101VBTX_dfu2_MAXDATASIZE 16384)
set(GENERIC_F101VBTX_dfu2_MCU cortex-m3)
set(GENERIC_F101VBTX_dfu2_FPCONF "-")
add_library(GENERIC_F101VBTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F101VBTX_dfu2 INTERFACE
  "SHELL:-DSTM32F101xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101VBTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F101VBTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101VBTX"
	"BOARD_NAME=\"GENERIC_F101VBTX\""
	"BOARD_ID=GENERIC_F101VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101VBTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101VBTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F101VBTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F101VBTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F101VBTX_dfu2_MCU}
)


# GENERIC_F101VBTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F101VBTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101V(8-B)T")
set(GENERIC_F101VBTX_dfuo_MAXSIZE 131072)
set(GENERIC_F101VBTX_dfuo_MAXDATASIZE 16384)
set(GENERIC_F101VBTX_dfuo_MCU cortex-m3)
set(GENERIC_F101VBTX_dfuo_FPCONF "-")
add_library(GENERIC_F101VBTX_dfuo INTERFACE)
target_compile_options(GENERIC_F101VBTX_dfuo INTERFACE
  "SHELL:-DSTM32F101xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101VBTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F101VBTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101VBTX"
	"BOARD_NAME=\"GENERIC_F101VBTX\""
	"BOARD_ID=GENERIC_F101VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101VBTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101VBTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F101VBTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F101VBTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F101VBTX_dfuo_MCU}
)


# GENERIC_F101VBTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F101VBTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101V(8-B)T")
set(GENERIC_F101VBTX_hid_MAXSIZE 131072)
set(GENERIC_F101VBTX_hid_MAXDATASIZE 16384)
set(GENERIC_F101VBTX_hid_MCU cortex-m3)
set(GENERIC_F101VBTX_hid_FPCONF "-")
add_library(GENERIC_F101VBTX_hid INTERFACE)
target_compile_options(GENERIC_F101VBTX_hid INTERFACE
  "SHELL:-DSTM32F101xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101VBTX_hid_MCU}
)
target_compile_definitions(GENERIC_F101VBTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101VBTX"
	"BOARD_NAME=\"GENERIC_F101VBTX\""
	"BOARD_ID=GENERIC_F101VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101VBTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101VBTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F101VBTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F101VBTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=16384"
  "SHELL: "
  -mcpu=${GENERIC_F101VBTX_hid_MCU}
)


# GENERIC_F101ZCTX
# -----------------------------------------------------------------------------

set(GENERIC_F101ZCTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101Z(C-D-E)T")
set(GENERIC_F101ZCTX_MAXSIZE 262144)
set(GENERIC_F101ZCTX_MAXDATASIZE 32768)
set(GENERIC_F101ZCTX_MCU cortex-m3)
set(GENERIC_F101ZCTX_FPCONF "-")
add_library(GENERIC_F101ZCTX INTERFACE)
target_compile_options(GENERIC_F101ZCTX INTERFACE
  "SHELL:-DSTM32F101xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101ZCTX_MCU}
)
target_compile_definitions(GENERIC_F101ZCTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101ZCTX"
	"BOARD_NAME=\"GENERIC_F101ZCTX\""
	"BOARD_ID=GENERIC_F101ZCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101ZCTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101ZCTX_VARIANT_PATH}
)

target_link_options(GENERIC_F101ZCTX INTERFACE
  "LINKER:--default-script=${GENERIC_F101ZCTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F101ZCTX_MCU}
)

add_library(GENERIC_F101ZCTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F101ZCTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101ZCTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F101ZCTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F101ZCTX_serial_none INTERFACE)
target_compile_options(GENERIC_F101ZCTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F101ZCTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F101ZCTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F101ZCTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F101ZCTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F101ZCTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F101ZCTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F101ZCTX_usb_none INTERFACE)
target_compile_options(GENERIC_F101ZCTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101ZCTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F101ZCTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101ZCTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F101ZCTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F101ZCTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F101ZCTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F101ZCTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F101ZCTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101Z(C-D-E)T")
set(GENERIC_F101ZCTX_dfu2_MAXSIZE 262144)
set(GENERIC_F101ZCTX_dfu2_MAXDATASIZE 32768)
set(GENERIC_F101ZCTX_dfu2_MCU cortex-m3)
set(GENERIC_F101ZCTX_dfu2_FPCONF "-")
add_library(GENERIC_F101ZCTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F101ZCTX_dfu2 INTERFACE
  "SHELL:-DSTM32F101xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101ZCTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F101ZCTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101ZCTX"
	"BOARD_NAME=\"GENERIC_F101ZCTX\""
	"BOARD_ID=GENERIC_F101ZCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101ZCTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101ZCTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F101ZCTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F101ZCTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F101ZCTX_dfu2_MCU}
)


# GENERIC_F101ZCTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F101ZCTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101Z(C-D-E)T")
set(GENERIC_F101ZCTX_dfuo_MAXSIZE 262144)
set(GENERIC_F101ZCTX_dfuo_MAXDATASIZE 32768)
set(GENERIC_F101ZCTX_dfuo_MCU cortex-m3)
set(GENERIC_F101ZCTX_dfuo_FPCONF "-")
add_library(GENERIC_F101ZCTX_dfuo INTERFACE)
target_compile_options(GENERIC_F101ZCTX_dfuo INTERFACE
  "SHELL:-DSTM32F101xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101ZCTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F101ZCTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101ZCTX"
	"BOARD_NAME=\"GENERIC_F101ZCTX\""
	"BOARD_ID=GENERIC_F101ZCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101ZCTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101ZCTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F101ZCTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F101ZCTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F101ZCTX_dfuo_MCU}
)


# GENERIC_F101ZCTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F101ZCTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101Z(C-D-E)T")
set(GENERIC_F101ZCTX_hid_MAXSIZE 262144)
set(GENERIC_F101ZCTX_hid_MAXDATASIZE 32768)
set(GENERIC_F101ZCTX_hid_MCU cortex-m3)
set(GENERIC_F101ZCTX_hid_FPCONF "-")
add_library(GENERIC_F101ZCTX_hid INTERFACE)
target_compile_options(GENERIC_F101ZCTX_hid INTERFACE
  "SHELL:-DSTM32F101xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101ZCTX_hid_MCU}
)
target_compile_definitions(GENERIC_F101ZCTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101ZCTX"
	"BOARD_NAME=\"GENERIC_F101ZCTX\""
	"BOARD_ID=GENERIC_F101ZCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101ZCTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101ZCTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F101ZCTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F101ZCTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=32768"
  "SHELL: "
  -mcpu=${GENERIC_F101ZCTX_hid_MCU}
)


# GENERIC_F101ZDTX
# -----------------------------------------------------------------------------

set(GENERIC_F101ZDTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101Z(C-D-E)T")
set(GENERIC_F101ZDTX_MAXSIZE 393216)
set(GENERIC_F101ZDTX_MAXDATASIZE 49152)
set(GENERIC_F101ZDTX_MCU cortex-m3)
set(GENERIC_F101ZDTX_FPCONF "-")
add_library(GENERIC_F101ZDTX INTERFACE)
target_compile_options(GENERIC_F101ZDTX INTERFACE
  "SHELL:-DSTM32F101xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101ZDTX_MCU}
)
target_compile_definitions(GENERIC_F101ZDTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101ZDTX"
	"BOARD_NAME=\"GENERIC_F101ZDTX\""
	"BOARD_ID=GENERIC_F101ZDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101ZDTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101ZDTX_VARIANT_PATH}
)

target_link_options(GENERIC_F101ZDTX INTERFACE
  "LINKER:--default-script=${GENERIC_F101ZDTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F101ZDTX_MCU}
)

add_library(GENERIC_F101ZDTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F101ZDTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101ZDTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F101ZDTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F101ZDTX_serial_none INTERFACE)
target_compile_options(GENERIC_F101ZDTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F101ZDTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F101ZDTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F101ZDTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F101ZDTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F101ZDTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F101ZDTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F101ZDTX_usb_none INTERFACE)
target_compile_options(GENERIC_F101ZDTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101ZDTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F101ZDTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101ZDTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F101ZDTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F101ZDTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F101ZDTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F101ZDTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F101ZDTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101Z(C-D-E)T")
set(GENERIC_F101ZDTX_dfu2_MAXSIZE 393216)
set(GENERIC_F101ZDTX_dfu2_MAXDATASIZE 49152)
set(GENERIC_F101ZDTX_dfu2_MCU cortex-m3)
set(GENERIC_F101ZDTX_dfu2_FPCONF "-")
add_library(GENERIC_F101ZDTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F101ZDTX_dfu2 INTERFACE
  "SHELL:-DSTM32F101xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101ZDTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F101ZDTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101ZDTX"
	"BOARD_NAME=\"GENERIC_F101ZDTX\""
	"BOARD_ID=GENERIC_F101ZDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101ZDTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101ZDTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F101ZDTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F101ZDTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F101ZDTX_dfu2_MCU}
)


# GENERIC_F101ZDTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F101ZDTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101Z(C-D-E)T")
set(GENERIC_F101ZDTX_dfuo_MAXSIZE 393216)
set(GENERIC_F101ZDTX_dfuo_MAXDATASIZE 49152)
set(GENERIC_F101ZDTX_dfuo_MCU cortex-m3)
set(GENERIC_F101ZDTX_dfuo_FPCONF "-")
add_library(GENERIC_F101ZDTX_dfuo INTERFACE)
target_compile_options(GENERIC_F101ZDTX_dfuo INTERFACE
  "SHELL:-DSTM32F101xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101ZDTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F101ZDTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101ZDTX"
	"BOARD_NAME=\"GENERIC_F101ZDTX\""
	"BOARD_ID=GENERIC_F101ZDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101ZDTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101ZDTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F101ZDTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F101ZDTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F101ZDTX_dfuo_MCU}
)


# GENERIC_F101ZDTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F101ZDTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101Z(C-D-E)T")
set(GENERIC_F101ZDTX_hid_MAXSIZE 393216)
set(GENERIC_F101ZDTX_hid_MAXDATASIZE 49152)
set(GENERIC_F101ZDTX_hid_MCU cortex-m3)
set(GENERIC_F101ZDTX_hid_FPCONF "-")
add_library(GENERIC_F101ZDTX_hid INTERFACE)
target_compile_options(GENERIC_F101ZDTX_hid INTERFACE
  "SHELL:-DSTM32F101xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101ZDTX_hid_MCU}
)
target_compile_definitions(GENERIC_F101ZDTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101ZDTX"
	"BOARD_NAME=\"GENERIC_F101ZDTX\""
	"BOARD_ID=GENERIC_F101ZDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101ZDTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101ZDTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F101ZDTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F101ZDTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F101ZDTX_hid_MCU}
)


# GENERIC_F101ZETX
# -----------------------------------------------------------------------------

set(GENERIC_F101ZETX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101Z(C-D-E)T")
set(GENERIC_F101ZETX_MAXSIZE 524288)
set(GENERIC_F101ZETX_MAXDATASIZE 49152)
set(GENERIC_F101ZETX_MCU cortex-m3)
set(GENERIC_F101ZETX_FPCONF "-")
add_library(GENERIC_F101ZETX INTERFACE)
target_compile_options(GENERIC_F101ZETX INTERFACE
  "SHELL:-DSTM32F101xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101ZETX_MCU}
)
target_compile_definitions(GENERIC_F101ZETX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101ZETX"
	"BOARD_NAME=\"GENERIC_F101ZETX\""
	"BOARD_ID=GENERIC_F101ZETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101ZETX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101ZETX_VARIANT_PATH}
)

target_link_options(GENERIC_F101ZETX INTERFACE
  "LINKER:--default-script=${GENERIC_F101ZETX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F101ZETX_MCU}
)

add_library(GENERIC_F101ZETX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F101ZETX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101ZETX_serial_generic INTERFACE)
target_compile_options(GENERIC_F101ZETX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F101ZETX_serial_none INTERFACE)
target_compile_options(GENERIC_F101ZETX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F101ZETX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F101ZETX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F101ZETX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F101ZETX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F101ZETX_usb_HID INTERFACE)
target_compile_options(GENERIC_F101ZETX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F101ZETX_usb_none INTERFACE)
target_compile_options(GENERIC_F101ZETX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101ZETX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F101ZETX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F101ZETX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F101ZETX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F101ZETX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F101ZETX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F101ZETX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F101ZETX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101Z(C-D-E)T")
set(GENERIC_F101ZETX_dfu2_MAXSIZE 524288)
set(GENERIC_F101ZETX_dfu2_MAXDATASIZE 49152)
set(GENERIC_F101ZETX_dfu2_MCU cortex-m3)
set(GENERIC_F101ZETX_dfu2_FPCONF "-")
add_library(GENERIC_F101ZETX_dfu2 INTERFACE)
target_compile_options(GENERIC_F101ZETX_dfu2 INTERFACE
  "SHELL:-DSTM32F101xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101ZETX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F101ZETX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101ZETX"
	"BOARD_NAME=\"GENERIC_F101ZETX\""
	"BOARD_ID=GENERIC_F101ZETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101ZETX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101ZETX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F101ZETX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F101ZETX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F101ZETX_dfu2_MCU}
)


# GENERIC_F101ZETX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F101ZETX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101Z(C-D-E)T")
set(GENERIC_F101ZETX_dfuo_MAXSIZE 524288)
set(GENERIC_F101ZETX_dfuo_MAXDATASIZE 49152)
set(GENERIC_F101ZETX_dfuo_MCU cortex-m3)
set(GENERIC_F101ZETX_dfuo_FPCONF "-")
add_library(GENERIC_F101ZETX_dfuo INTERFACE)
target_compile_options(GENERIC_F101ZETX_dfuo INTERFACE
  "SHELL:-DSTM32F101xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101ZETX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F101ZETX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101ZETX"
	"BOARD_NAME=\"GENERIC_F101ZETX\""
	"BOARD_ID=GENERIC_F101ZETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101ZETX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101ZETX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F101ZETX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F101ZETX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F101ZETX_dfuo_MCU}
)


# GENERIC_F101ZETX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F101ZETX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F101Z(C-D-E)T")
set(GENERIC_F101ZETX_hid_MAXSIZE 524288)
set(GENERIC_F101ZETX_hid_MAXDATASIZE 49152)
set(GENERIC_F101ZETX_hid_MCU cortex-m3)
set(GENERIC_F101ZETX_hid_FPCONF "-")
add_library(GENERIC_F101ZETX_hid INTERFACE)
target_compile_options(GENERIC_F101ZETX_hid INTERFACE
  "SHELL:-DSTM32F101xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F101ZETX_hid_MCU}
)
target_compile_definitions(GENERIC_F101ZETX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F101ZETX"
	"BOARD_NAME=\"GENERIC_F101ZETX\""
	"BOARD_ID=GENERIC_F101ZETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F101ZETX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F101ZETX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F101ZETX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F101ZETX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F101ZETX_hid_MCU}
)


# GENERIC_F103C4TX
# -----------------------------------------------------------------------------

set(GENERIC_F103C4TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(GENERIC_F103C4TX_MAXSIZE 16384)
set(GENERIC_F103C4TX_MAXDATASIZE 6144)
set(GENERIC_F103C4TX_MCU cortex-m3)
set(GENERIC_F103C4TX_FPCONF "-")
add_library(GENERIC_F103C4TX INTERFACE)
target_compile_options(GENERIC_F103C4TX INTERFACE
  "SHELL:-DSTM32F103x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C4TX_MCU}
)
target_compile_definitions(GENERIC_F103C4TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C4TX"
	"BOARD_NAME=\"GENERIC_F103C4TX\""
	"BOARD_ID=GENERIC_F103C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C4TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C4TX_VARIANT_PATH}
)

target_link_options(GENERIC_F103C4TX INTERFACE
  "LINKER:--default-script=${GENERIC_F103C4TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103C4TX_MCU}
)

add_library(GENERIC_F103C4TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103C4TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103C4TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103C4TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103C4TX_serial_none INTERFACE)
target_compile_options(GENERIC_F103C4TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103C4TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103C4TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103C4TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103C4TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103C4TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103C4TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103C4TX_usb_none INTERFACE)
target_compile_options(GENERIC_F103C4TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103C4TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103C4TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103C4TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103C4TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103C4TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103C4TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103C4TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103C4TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(GENERIC_F103C4TX_dfu2_MAXSIZE 16384)
set(GENERIC_F103C4TX_dfu2_MAXDATASIZE 6144)
set(GENERIC_F103C4TX_dfu2_MCU cortex-m3)
set(GENERIC_F103C4TX_dfu2_FPCONF "-")
add_library(GENERIC_F103C4TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103C4TX_dfu2 INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C4TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103C4TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C4TX"
	"BOARD_NAME=\"GENERIC_F103C4TX\""
	"BOARD_ID=GENERIC_F103C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C4TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C4TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103C4TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103C4TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103C4TX_dfu2_MCU}
)


# GENERIC_F103C4TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103C4TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(GENERIC_F103C4TX_dfuo_MAXSIZE 16384)
set(GENERIC_F103C4TX_dfuo_MAXDATASIZE 6144)
set(GENERIC_F103C4TX_dfuo_MCU cortex-m3)
set(GENERIC_F103C4TX_dfuo_FPCONF "-")
add_library(GENERIC_F103C4TX_dfuo INTERFACE)
target_compile_options(GENERIC_F103C4TX_dfuo INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C4TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103C4TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C4TX"
	"BOARD_NAME=\"GENERIC_F103C4TX\""
	"BOARD_ID=GENERIC_F103C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C4TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C4TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103C4TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103C4TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103C4TX_dfuo_MCU}
)


# GENERIC_F103C4TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103C4TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(GENERIC_F103C4TX_hid_MAXSIZE 16384)
set(GENERIC_F103C4TX_hid_MAXDATASIZE 6144)
set(GENERIC_F103C4TX_hid_MCU cortex-m3)
set(GENERIC_F103C4TX_hid_FPCONF "-")
add_library(GENERIC_F103C4TX_hid INTERFACE)
target_compile_options(GENERIC_F103C4TX_hid INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C4TX_hid_MCU}
)
target_compile_definitions(GENERIC_F103C4TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C4TX"
	"BOARD_NAME=\"GENERIC_F103C4TX\""
	"BOARD_ID=GENERIC_F103C4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C4TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C4TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103C4TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103C4TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103C4TX_hid_MCU}
)


# GENERIC_F103C6TX
# -----------------------------------------------------------------------------

set(GENERIC_F103C6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(GENERIC_F103C6TX_MAXSIZE 32768)
set(GENERIC_F103C6TX_MAXDATASIZE 10240)
set(GENERIC_F103C6TX_MCU cortex-m3)
set(GENERIC_F103C6TX_FPCONF "-")
add_library(GENERIC_F103C6TX INTERFACE)
target_compile_options(GENERIC_F103C6TX INTERFACE
  "SHELL:-DSTM32F103x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C6TX_MCU}
)
target_compile_definitions(GENERIC_F103C6TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C6TX"
	"BOARD_NAME=\"GENERIC_F103C6TX\""
	"BOARD_ID=GENERIC_F103C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C6TX_VARIANT_PATH}
)

target_link_options(GENERIC_F103C6TX INTERFACE
  "LINKER:--default-script=${GENERIC_F103C6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103C6TX_MCU}
)

add_library(GENERIC_F103C6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103C6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103C6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103C6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103C6TX_serial_none INTERFACE)
target_compile_options(GENERIC_F103C6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103C6TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103C6TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103C6TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103C6TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103C6TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103C6TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103C6TX_usb_none INTERFACE)
target_compile_options(GENERIC_F103C6TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103C6TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103C6TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103C6TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103C6TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103C6TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103C6TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103C6TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103C6TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(GENERIC_F103C6TX_dfu2_MAXSIZE 32768)
set(GENERIC_F103C6TX_dfu2_MAXDATASIZE 10240)
set(GENERIC_F103C6TX_dfu2_MCU cortex-m3)
set(GENERIC_F103C6TX_dfu2_FPCONF "-")
add_library(GENERIC_F103C6TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103C6TX_dfu2 INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C6TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103C6TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C6TX"
	"BOARD_NAME=\"GENERIC_F103C6TX\""
	"BOARD_ID=GENERIC_F103C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C6TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C6TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103C6TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103C6TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103C6TX_dfu2_MCU}
)


# GENERIC_F103C6TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103C6TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(GENERIC_F103C6TX_dfuo_MAXSIZE 32768)
set(GENERIC_F103C6TX_dfuo_MAXDATASIZE 10240)
set(GENERIC_F103C6TX_dfuo_MCU cortex-m3)
set(GENERIC_F103C6TX_dfuo_FPCONF "-")
add_library(GENERIC_F103C6TX_dfuo INTERFACE)
target_compile_options(GENERIC_F103C6TX_dfuo INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C6TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103C6TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C6TX"
	"BOARD_NAME=\"GENERIC_F103C6TX\""
	"BOARD_ID=GENERIC_F103C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C6TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C6TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103C6TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103C6TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103C6TX_dfuo_MCU}
)


# GENERIC_F103C6TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103C6TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(GENERIC_F103C6TX_hid_MAXSIZE 32768)
set(GENERIC_F103C6TX_hid_MAXDATASIZE 10240)
set(GENERIC_F103C6TX_hid_MCU cortex-m3)
set(GENERIC_F103C6TX_hid_FPCONF "-")
add_library(GENERIC_F103C6TX_hid INTERFACE)
target_compile_options(GENERIC_F103C6TX_hid INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C6TX_hid_MCU}
)
target_compile_definitions(GENERIC_F103C6TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C6TX"
	"BOARD_NAME=\"GENERIC_F103C6TX\""
	"BOARD_ID=GENERIC_F103C6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C6TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C6TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103C6TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103C6TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103C6TX_hid_MCU}
)


# GENERIC_F103C6UX
# -----------------------------------------------------------------------------

set(GENERIC_F103C6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(GENERIC_F103C6UX_MAXSIZE 32768)
set(GENERIC_F103C6UX_MAXDATASIZE 10240)
set(GENERIC_F103C6UX_MCU cortex-m3)
set(GENERIC_F103C6UX_FPCONF "-")
add_library(GENERIC_F103C6UX INTERFACE)
target_compile_options(GENERIC_F103C6UX INTERFACE
  "SHELL:-DSTM32F103x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C6UX_MCU}
)
target_compile_definitions(GENERIC_F103C6UX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C6UX"
	"BOARD_NAME=\"GENERIC_F103C6UX\""
	"BOARD_ID=GENERIC_F103C6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C6UX_VARIANT_PATH}
)

target_link_options(GENERIC_F103C6UX INTERFACE
  "LINKER:--default-script=${GENERIC_F103C6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103C6UX_MCU}
)

add_library(GENERIC_F103C6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103C6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103C6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103C6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103C6UX_serial_none INTERFACE)
target_compile_options(GENERIC_F103C6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103C6UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103C6UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103C6UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103C6UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103C6UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103C6UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103C6UX_usb_none INTERFACE)
target_compile_options(GENERIC_F103C6UX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103C6UX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103C6UX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103C6UX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103C6UX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103C6UX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103C6UX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103C6UX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103C6UX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(GENERIC_F103C6UX_dfu2_MAXSIZE 32768)
set(GENERIC_F103C6UX_dfu2_MAXDATASIZE 10240)
set(GENERIC_F103C6UX_dfu2_MCU cortex-m3)
set(GENERIC_F103C6UX_dfu2_FPCONF "-")
add_library(GENERIC_F103C6UX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103C6UX_dfu2 INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C6UX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103C6UX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C6UX"
	"BOARD_NAME=\"GENERIC_F103C6UX\""
	"BOARD_ID=GENERIC_F103C6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C6UX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C6UX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103C6UX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103C6UX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103C6UX_dfu2_MCU}
)


# GENERIC_F103C6UX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103C6UX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(GENERIC_F103C6UX_dfuo_MAXSIZE 32768)
set(GENERIC_F103C6UX_dfuo_MAXDATASIZE 10240)
set(GENERIC_F103C6UX_dfuo_MCU cortex-m3)
set(GENERIC_F103C6UX_dfuo_FPCONF "-")
add_library(GENERIC_F103C6UX_dfuo INTERFACE)
target_compile_options(GENERIC_F103C6UX_dfuo INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C6UX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103C6UX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C6UX"
	"BOARD_NAME=\"GENERIC_F103C6UX\""
	"BOARD_ID=GENERIC_F103C6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C6UX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C6UX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103C6UX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103C6UX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103C6UX_dfuo_MCU}
)


# GENERIC_F103C6UX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103C6UX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C4T_F103C6(T-U)")
set(GENERIC_F103C6UX_hid_MAXSIZE 32768)
set(GENERIC_F103C6UX_hid_MAXDATASIZE 10240)
set(GENERIC_F103C6UX_hid_MCU cortex-m3)
set(GENERIC_F103C6UX_hid_FPCONF "-")
add_library(GENERIC_F103C6UX_hid INTERFACE)
target_compile_options(GENERIC_F103C6UX_hid INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C6UX_hid_MCU}
)
target_compile_definitions(GENERIC_F103C6UX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C6UX"
	"BOARD_NAME=\"GENERIC_F103C6UX\""
	"BOARD_ID=GENERIC_F103C6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C6UX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C6UX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103C6UX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103C6UX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103C6UX_hid_MCU}
)


# GENERIC_F103C8TX
# -----------------------------------------------------------------------------

set(GENERIC_F103C8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(GENERIC_F103C8TX_MAXSIZE 65536)
set(GENERIC_F103C8TX_MAXDATASIZE 20480)
set(GENERIC_F103C8TX_MCU cortex-m3)
set(GENERIC_F103C8TX_FPCONF "-")
add_library(GENERIC_F103C8TX INTERFACE)
target_compile_options(GENERIC_F103C8TX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C8TX_MCU}
)
target_compile_definitions(GENERIC_F103C8TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C8TX"
	"BOARD_NAME=\"GENERIC_F103C8TX\""
	"BOARD_ID=GENERIC_F103C8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F103C8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F103C8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103C8TX_MCU}
)

add_library(GENERIC_F103C8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103C8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103C8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103C8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103C8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F103C8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103C8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103C8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103C8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103C8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103C8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103C8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103C8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F103C8TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103C8TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103C8TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103C8TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103C8TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103C8TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103C8TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103C8TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103C8TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(GENERIC_F103C8TX_dfu2_MAXSIZE 65536)
set(GENERIC_F103C8TX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103C8TX_dfu2_MCU cortex-m3)
set(GENERIC_F103C8TX_dfu2_FPCONF "-")
add_library(GENERIC_F103C8TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103C8TX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C8TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103C8TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C8TX"
	"BOARD_NAME=\"GENERIC_F103C8TX\""
	"BOARD_ID=GENERIC_F103C8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C8TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C8TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103C8TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103C8TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103C8TX_dfu2_MCU}
)


# GENERIC_F103C8TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103C8TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(GENERIC_F103C8TX_dfuo_MAXSIZE 65536)
set(GENERIC_F103C8TX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103C8TX_dfuo_MCU cortex-m3)
set(GENERIC_F103C8TX_dfuo_FPCONF "-")
add_library(GENERIC_F103C8TX_dfuo INTERFACE)
target_compile_options(GENERIC_F103C8TX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C8TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103C8TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C8TX"
	"BOARD_NAME=\"GENERIC_F103C8TX\""
	"BOARD_ID=GENERIC_F103C8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C8TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C8TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103C8TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103C8TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103C8TX_dfuo_MCU}
)


# GENERIC_F103C8TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103C8TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(GENERIC_F103C8TX_hid_MAXSIZE 65536)
set(GENERIC_F103C8TX_hid_MAXDATASIZE 20480)
set(GENERIC_F103C8TX_hid_MCU cortex-m3)
set(GENERIC_F103C8TX_hid_FPCONF "-")
add_library(GENERIC_F103C8TX_hid INTERFACE)
target_compile_options(GENERIC_F103C8TX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103C8TX_hid_MCU}
)
target_compile_definitions(GENERIC_F103C8TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103C8TX"
	"BOARD_NAME=\"GENERIC_F103C8TX\""
	"BOARD_ID=GENERIC_F103C8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103C8TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103C8TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103C8TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103C8TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103C8TX_hid_MCU}
)


# GENERIC_F103CBTX
# -----------------------------------------------------------------------------

set(GENERIC_F103CBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(GENERIC_F103CBTX_MAXSIZE 131072)
set(GENERIC_F103CBTX_MAXDATASIZE 20480)
set(GENERIC_F103CBTX_MCU cortex-m3)
set(GENERIC_F103CBTX_FPCONF "-")
add_library(GENERIC_F103CBTX INTERFACE)
target_compile_options(GENERIC_F103CBTX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103CBTX_MCU}
)
target_compile_definitions(GENERIC_F103CBTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103CBTX"
	"BOARD_NAME=\"GENERIC_F103CBTX\""
	"BOARD_ID=GENERIC_F103CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103CBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103CBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F103CBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F103CBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103CBTX_MCU}
)

add_library(GENERIC_F103CBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103CBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103CBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103CBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103CBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F103CBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103CBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103CBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103CBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103CBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103CBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103CBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103CBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F103CBTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103CBTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103CBTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103CBTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103CBTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103CBTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103CBTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103CBTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103CBTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(GENERIC_F103CBTX_dfu2_MAXSIZE 131072)
set(GENERIC_F103CBTX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103CBTX_dfu2_MCU cortex-m3)
set(GENERIC_F103CBTX_dfu2_FPCONF "-")
add_library(GENERIC_F103CBTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103CBTX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103CBTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103CBTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103CBTX"
	"BOARD_NAME=\"GENERIC_F103CBTX\""
	"BOARD_ID=GENERIC_F103CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103CBTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103CBTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103CBTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103CBTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103CBTX_dfu2_MCU}
)


# GENERIC_F103CBTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103CBTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(GENERIC_F103CBTX_dfuo_MAXSIZE 131072)
set(GENERIC_F103CBTX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103CBTX_dfuo_MCU cortex-m3)
set(GENERIC_F103CBTX_dfuo_FPCONF "-")
add_library(GENERIC_F103CBTX_dfuo INTERFACE)
target_compile_options(GENERIC_F103CBTX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103CBTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103CBTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103CBTX"
	"BOARD_NAME=\"GENERIC_F103CBTX\""
	"BOARD_ID=GENERIC_F103CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103CBTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103CBTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103CBTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103CBTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103CBTX_dfuo_MCU}
)


# GENERIC_F103CBTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103CBTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(GENERIC_F103CBTX_hid_MAXSIZE 131072)
set(GENERIC_F103CBTX_hid_MAXDATASIZE 20480)
set(GENERIC_F103CBTX_hid_MCU cortex-m3)
set(GENERIC_F103CBTX_hid_FPCONF "-")
add_library(GENERIC_F103CBTX_hid INTERFACE)
target_compile_options(GENERIC_F103CBTX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103CBTX_hid_MCU}
)
target_compile_definitions(GENERIC_F103CBTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103CBTX"
	"BOARD_NAME=\"GENERIC_F103CBTX\""
	"BOARD_ID=GENERIC_F103CBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103CBTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103CBTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103CBTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103CBTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103CBTX_hid_MCU}
)


# GENERIC_F103CBUX
# -----------------------------------------------------------------------------

set(GENERIC_F103CBUX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(GENERIC_F103CBUX_MAXSIZE 131072)
set(GENERIC_F103CBUX_MAXDATASIZE 20480)
set(GENERIC_F103CBUX_MCU cortex-m3)
set(GENERIC_F103CBUX_FPCONF "-")
add_library(GENERIC_F103CBUX INTERFACE)
target_compile_options(GENERIC_F103CBUX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103CBUX_MCU}
)
target_compile_definitions(GENERIC_F103CBUX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103CBUX"
	"BOARD_NAME=\"GENERIC_F103CBUX\""
	"BOARD_ID=GENERIC_F103CBUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103CBUX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103CBUX_VARIANT_PATH}
)

target_link_options(GENERIC_F103CBUX INTERFACE
  "LINKER:--default-script=${GENERIC_F103CBUX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103CBUX_MCU}
)

add_library(GENERIC_F103CBUX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103CBUX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103CBUX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103CBUX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103CBUX_serial_none INTERFACE)
target_compile_options(GENERIC_F103CBUX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103CBUX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103CBUX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103CBUX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103CBUX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103CBUX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103CBUX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103CBUX_usb_none INTERFACE)
target_compile_options(GENERIC_F103CBUX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103CBUX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103CBUX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103CBUX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103CBUX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103CBUX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103CBUX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103CBUX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103CBUX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(GENERIC_F103CBUX_dfu2_MAXSIZE 131072)
set(GENERIC_F103CBUX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103CBUX_dfu2_MCU cortex-m3)
set(GENERIC_F103CBUX_dfu2_FPCONF "-")
add_library(GENERIC_F103CBUX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103CBUX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103CBUX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103CBUX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103CBUX"
	"BOARD_NAME=\"GENERIC_F103CBUX\""
	"BOARD_ID=GENERIC_F103CBUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103CBUX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103CBUX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103CBUX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103CBUX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103CBUX_dfu2_MCU}
)


# GENERIC_F103CBUX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103CBUX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(GENERIC_F103CBUX_dfuo_MAXSIZE 131072)
set(GENERIC_F103CBUX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103CBUX_dfuo_MCU cortex-m3)
set(GENERIC_F103CBUX_dfuo_FPCONF "-")
add_library(GENERIC_F103CBUX_dfuo INTERFACE)
target_compile_options(GENERIC_F103CBUX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103CBUX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103CBUX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103CBUX"
	"BOARD_NAME=\"GENERIC_F103CBUX\""
	"BOARD_ID=GENERIC_F103CBUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103CBUX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103CBUX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103CBUX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103CBUX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103CBUX_dfuo_MCU}
)


# GENERIC_F103CBUX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103CBUX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103C8T_F103CB(T-U)")
set(GENERIC_F103CBUX_hid_MAXSIZE 131072)
set(GENERIC_F103CBUX_hid_MAXDATASIZE 20480)
set(GENERIC_F103CBUX_hid_MCU cortex-m3)
set(GENERIC_F103CBUX_hid_FPCONF "-")
add_library(GENERIC_F103CBUX_hid INTERFACE)
target_compile_options(GENERIC_F103CBUX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103CBUX_hid_MCU}
)
target_compile_definitions(GENERIC_F103CBUX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103CBUX"
	"BOARD_NAME=\"GENERIC_F103CBUX\""
	"BOARD_ID=GENERIC_F103CBUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103CBUX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103CBUX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103CBUX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103CBUX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103CBUX_hid_MCU}
)


# GENERIC_F103R4HX
# -----------------------------------------------------------------------------

set(GENERIC_F103R4HX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)H")
set(GENERIC_F103R4HX_MAXSIZE 16384)
set(GENERIC_F103R4HX_MAXDATASIZE 6144)
set(GENERIC_F103R4HX_MCU cortex-m3)
set(GENERIC_F103R4HX_FPCONF "-")
add_library(GENERIC_F103R4HX INTERFACE)
target_compile_options(GENERIC_F103R4HX INTERFACE
  "SHELL:-DSTM32F103x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R4HX_MCU}
)
target_compile_definitions(GENERIC_F103R4HX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R4HX"
	"BOARD_NAME=\"GENERIC_F103R4HX\""
	"BOARD_ID=GENERIC_F103R4HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R4HX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R4HX_VARIANT_PATH}
)

target_link_options(GENERIC_F103R4HX INTERFACE
  "LINKER:--default-script=${GENERIC_F103R4HX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103R4HX_MCU}
)

add_library(GENERIC_F103R4HX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103R4HX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R4HX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103R4HX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103R4HX_serial_none INTERFACE)
target_compile_options(GENERIC_F103R4HX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103R4HX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103R4HX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103R4HX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103R4HX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103R4HX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103R4HX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103R4HX_usb_none INTERFACE)
target_compile_options(GENERIC_F103R4HX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R4HX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103R4HX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R4HX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103R4HX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103R4HX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103R4HX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103R4HX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103R4HX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)H")
set(GENERIC_F103R4HX_dfu2_MAXSIZE 16384)
set(GENERIC_F103R4HX_dfu2_MAXDATASIZE 6144)
set(GENERIC_F103R4HX_dfu2_MCU cortex-m3)
set(GENERIC_F103R4HX_dfu2_FPCONF "-")
add_library(GENERIC_F103R4HX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103R4HX_dfu2 INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R4HX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103R4HX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R4HX"
	"BOARD_NAME=\"GENERIC_F103R4HX\""
	"BOARD_ID=GENERIC_F103R4HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R4HX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R4HX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103R4HX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103R4HX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103R4HX_dfu2_MCU}
)


# GENERIC_F103R4HX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103R4HX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)H")
set(GENERIC_F103R4HX_dfuo_MAXSIZE 16384)
set(GENERIC_F103R4HX_dfuo_MAXDATASIZE 6144)
set(GENERIC_F103R4HX_dfuo_MCU cortex-m3)
set(GENERIC_F103R4HX_dfuo_FPCONF "-")
add_library(GENERIC_F103R4HX_dfuo INTERFACE)
target_compile_options(GENERIC_F103R4HX_dfuo INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R4HX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103R4HX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R4HX"
	"BOARD_NAME=\"GENERIC_F103R4HX\""
	"BOARD_ID=GENERIC_F103R4HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R4HX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R4HX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103R4HX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103R4HX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103R4HX_dfuo_MCU}
)


# GENERIC_F103R4HX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103R4HX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)H")
set(GENERIC_F103R4HX_hid_MAXSIZE 16384)
set(GENERIC_F103R4HX_hid_MAXDATASIZE 6144)
set(GENERIC_F103R4HX_hid_MCU cortex-m3)
set(GENERIC_F103R4HX_hid_FPCONF "-")
add_library(GENERIC_F103R4HX_hid INTERFACE)
target_compile_options(GENERIC_F103R4HX_hid INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R4HX_hid_MCU}
)
target_compile_definitions(GENERIC_F103R4HX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R4HX"
	"BOARD_NAME=\"GENERIC_F103R4HX\""
	"BOARD_ID=GENERIC_F103R4HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R4HX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R4HX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103R4HX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103R4HX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103R4HX_hid_MCU}
)


# GENERIC_F103R4TX
# -----------------------------------------------------------------------------

set(GENERIC_F103R4TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)T")
set(GENERIC_F103R4TX_MAXSIZE 16384)
set(GENERIC_F103R4TX_MAXDATASIZE 6144)
set(GENERIC_F103R4TX_MCU cortex-m3)
set(GENERIC_F103R4TX_FPCONF "-")
add_library(GENERIC_F103R4TX INTERFACE)
target_compile_options(GENERIC_F103R4TX INTERFACE
  "SHELL:-DSTM32F103x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R4TX_MCU}
)
target_compile_definitions(GENERIC_F103R4TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R4TX"
	"BOARD_NAME=\"GENERIC_F103R4TX\""
	"BOARD_ID=GENERIC_F103R4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R4TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R4TX_VARIANT_PATH}
)

target_link_options(GENERIC_F103R4TX INTERFACE
  "LINKER:--default-script=${GENERIC_F103R4TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103R4TX_MCU}
)

add_library(GENERIC_F103R4TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103R4TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R4TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103R4TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103R4TX_serial_none INTERFACE)
target_compile_options(GENERIC_F103R4TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103R4TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103R4TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103R4TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103R4TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103R4TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103R4TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103R4TX_usb_none INTERFACE)
target_compile_options(GENERIC_F103R4TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R4TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103R4TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R4TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103R4TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103R4TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103R4TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103R4TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103R4TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)T")
set(GENERIC_F103R4TX_dfu2_MAXSIZE 16384)
set(GENERIC_F103R4TX_dfu2_MAXDATASIZE 6144)
set(GENERIC_F103R4TX_dfu2_MCU cortex-m3)
set(GENERIC_F103R4TX_dfu2_FPCONF "-")
add_library(GENERIC_F103R4TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103R4TX_dfu2 INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R4TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103R4TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R4TX"
	"BOARD_NAME=\"GENERIC_F103R4TX\""
	"BOARD_ID=GENERIC_F103R4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R4TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R4TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103R4TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103R4TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103R4TX_dfu2_MCU}
)


# GENERIC_F103R4TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103R4TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)T")
set(GENERIC_F103R4TX_dfuo_MAXSIZE 16384)
set(GENERIC_F103R4TX_dfuo_MAXDATASIZE 6144)
set(GENERIC_F103R4TX_dfuo_MCU cortex-m3)
set(GENERIC_F103R4TX_dfuo_FPCONF "-")
add_library(GENERIC_F103R4TX_dfuo INTERFACE)
target_compile_options(GENERIC_F103R4TX_dfuo INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R4TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103R4TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R4TX"
	"BOARD_NAME=\"GENERIC_F103R4TX\""
	"BOARD_ID=GENERIC_F103R4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R4TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R4TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103R4TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103R4TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103R4TX_dfuo_MCU}
)


# GENERIC_F103R4TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103R4TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)T")
set(GENERIC_F103R4TX_hid_MAXSIZE 16384)
set(GENERIC_F103R4TX_hid_MAXDATASIZE 6144)
set(GENERIC_F103R4TX_hid_MCU cortex-m3)
set(GENERIC_F103R4TX_hid_FPCONF "-")
add_library(GENERIC_F103R4TX_hid INTERFACE)
target_compile_options(GENERIC_F103R4TX_hid INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R4TX_hid_MCU}
)
target_compile_definitions(GENERIC_F103R4TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R4TX"
	"BOARD_NAME=\"GENERIC_F103R4TX\""
	"BOARD_ID=GENERIC_F103R4TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R4TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R4TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103R4TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103R4TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103R4TX_hid_MCU}
)


# GENERIC_F103R6HX
# -----------------------------------------------------------------------------

set(GENERIC_F103R6HX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)H")
set(GENERIC_F103R6HX_MAXSIZE 32768)
set(GENERIC_F103R6HX_MAXDATASIZE 10240)
set(GENERIC_F103R6HX_MCU cortex-m3)
set(GENERIC_F103R6HX_FPCONF "-")
add_library(GENERIC_F103R6HX INTERFACE)
target_compile_options(GENERIC_F103R6HX INTERFACE
  "SHELL:-DSTM32F103x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R6HX_MCU}
)
target_compile_definitions(GENERIC_F103R6HX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R6HX"
	"BOARD_NAME=\"GENERIC_F103R6HX\""
	"BOARD_ID=GENERIC_F103R6HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R6HX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R6HX_VARIANT_PATH}
)

target_link_options(GENERIC_F103R6HX INTERFACE
  "LINKER:--default-script=${GENERIC_F103R6HX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103R6HX_MCU}
)

add_library(GENERIC_F103R6HX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103R6HX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R6HX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103R6HX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103R6HX_serial_none INTERFACE)
target_compile_options(GENERIC_F103R6HX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103R6HX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103R6HX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103R6HX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103R6HX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103R6HX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103R6HX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103R6HX_usb_none INTERFACE)
target_compile_options(GENERIC_F103R6HX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R6HX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103R6HX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R6HX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103R6HX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103R6HX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103R6HX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103R6HX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103R6HX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)H")
set(GENERIC_F103R6HX_dfu2_MAXSIZE 32768)
set(GENERIC_F103R6HX_dfu2_MAXDATASIZE 10240)
set(GENERIC_F103R6HX_dfu2_MCU cortex-m3)
set(GENERIC_F103R6HX_dfu2_FPCONF "-")
add_library(GENERIC_F103R6HX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103R6HX_dfu2 INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R6HX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103R6HX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R6HX"
	"BOARD_NAME=\"GENERIC_F103R6HX\""
	"BOARD_ID=GENERIC_F103R6HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R6HX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R6HX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103R6HX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103R6HX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103R6HX_dfu2_MCU}
)


# GENERIC_F103R6HX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103R6HX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)H")
set(GENERIC_F103R6HX_dfuo_MAXSIZE 32768)
set(GENERIC_F103R6HX_dfuo_MAXDATASIZE 10240)
set(GENERIC_F103R6HX_dfuo_MCU cortex-m3)
set(GENERIC_F103R6HX_dfuo_FPCONF "-")
add_library(GENERIC_F103R6HX_dfuo INTERFACE)
target_compile_options(GENERIC_F103R6HX_dfuo INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R6HX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103R6HX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R6HX"
	"BOARD_NAME=\"GENERIC_F103R6HX\""
	"BOARD_ID=GENERIC_F103R6HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R6HX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R6HX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103R6HX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103R6HX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103R6HX_dfuo_MCU}
)


# GENERIC_F103R6HX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103R6HX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)H")
set(GENERIC_F103R6HX_hid_MAXSIZE 32768)
set(GENERIC_F103R6HX_hid_MAXDATASIZE 10240)
set(GENERIC_F103R6HX_hid_MCU cortex-m3)
set(GENERIC_F103R6HX_hid_FPCONF "-")
add_library(GENERIC_F103R6HX_hid INTERFACE)
target_compile_options(GENERIC_F103R6HX_hid INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R6HX_hid_MCU}
)
target_compile_definitions(GENERIC_F103R6HX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R6HX"
	"BOARD_NAME=\"GENERIC_F103R6HX\""
	"BOARD_ID=GENERIC_F103R6HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R6HX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R6HX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103R6HX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103R6HX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103R6HX_hid_MCU}
)


# GENERIC_F103R6TX
# -----------------------------------------------------------------------------

set(GENERIC_F103R6TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)T")
set(GENERIC_F103R6TX_MAXSIZE 32768)
set(GENERIC_F103R6TX_MAXDATASIZE 10240)
set(GENERIC_F103R6TX_MCU cortex-m3)
set(GENERIC_F103R6TX_FPCONF "-")
add_library(GENERIC_F103R6TX INTERFACE)
target_compile_options(GENERIC_F103R6TX INTERFACE
  "SHELL:-DSTM32F103x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R6TX_MCU}
)
target_compile_definitions(GENERIC_F103R6TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R6TX"
	"BOARD_NAME=\"GENERIC_F103R6TX\""
	"BOARD_ID=GENERIC_F103R6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R6TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R6TX_VARIANT_PATH}
)

target_link_options(GENERIC_F103R6TX INTERFACE
  "LINKER:--default-script=${GENERIC_F103R6TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103R6TX_MCU}
)

add_library(GENERIC_F103R6TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103R6TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R6TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103R6TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103R6TX_serial_none INTERFACE)
target_compile_options(GENERIC_F103R6TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103R6TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103R6TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103R6TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103R6TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103R6TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103R6TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103R6TX_usb_none INTERFACE)
target_compile_options(GENERIC_F103R6TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R6TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103R6TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R6TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103R6TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103R6TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103R6TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103R6TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103R6TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)T")
set(GENERIC_F103R6TX_dfu2_MAXSIZE 32768)
set(GENERIC_F103R6TX_dfu2_MAXDATASIZE 10240)
set(GENERIC_F103R6TX_dfu2_MCU cortex-m3)
set(GENERIC_F103R6TX_dfu2_FPCONF "-")
add_library(GENERIC_F103R6TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103R6TX_dfu2 INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R6TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103R6TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R6TX"
	"BOARD_NAME=\"GENERIC_F103R6TX\""
	"BOARD_ID=GENERIC_F103R6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R6TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R6TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103R6TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103R6TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103R6TX_dfu2_MCU}
)


# GENERIC_F103R6TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103R6TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)T")
set(GENERIC_F103R6TX_dfuo_MAXSIZE 32768)
set(GENERIC_F103R6TX_dfuo_MAXDATASIZE 10240)
set(GENERIC_F103R6TX_dfuo_MCU cortex-m3)
set(GENERIC_F103R6TX_dfuo_FPCONF "-")
add_library(GENERIC_F103R6TX_dfuo INTERFACE)
target_compile_options(GENERIC_F103R6TX_dfuo INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R6TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103R6TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R6TX"
	"BOARD_NAME=\"GENERIC_F103R6TX\""
	"BOARD_ID=GENERIC_F103R6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R6TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R6TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103R6TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103R6TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103R6TX_dfuo_MCU}
)


# GENERIC_F103R6TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103R6TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(4-6)T")
set(GENERIC_F103R6TX_hid_MAXSIZE 32768)
set(GENERIC_F103R6TX_hid_MAXDATASIZE 10240)
set(GENERIC_F103R6TX_hid_MCU cortex-m3)
set(GENERIC_F103R6TX_hid_FPCONF "-")
add_library(GENERIC_F103R6TX_hid INTERFACE)
target_compile_options(GENERIC_F103R6TX_hid INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R6TX_hid_MCU}
)
target_compile_definitions(GENERIC_F103R6TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R6TX"
	"BOARD_NAME=\"GENERIC_F103R6TX\""
	"BOARD_ID=GENERIC_F103R6TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R6TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R6TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103R6TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103R6TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103R6TX_hid_MCU}
)


# GENERIC_F103R8HX
# -----------------------------------------------------------------------------

set(GENERIC_F103R8HX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)H")
set(GENERIC_F103R8HX_MAXSIZE 65536)
set(GENERIC_F103R8HX_MAXDATASIZE 20480)
set(GENERIC_F103R8HX_MCU cortex-m3)
set(GENERIC_F103R8HX_FPCONF "-")
add_library(GENERIC_F103R8HX INTERFACE)
target_compile_options(GENERIC_F103R8HX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R8HX_MCU}
)
target_compile_definitions(GENERIC_F103R8HX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R8HX"
	"BOARD_NAME=\"GENERIC_F103R8HX\""
	"BOARD_ID=GENERIC_F103R8HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R8HX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R8HX_VARIANT_PATH}
)

target_link_options(GENERIC_F103R8HX INTERFACE
  "LINKER:--default-script=${GENERIC_F103R8HX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103R8HX_MCU}
)

add_library(GENERIC_F103R8HX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103R8HX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R8HX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103R8HX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103R8HX_serial_none INTERFACE)
target_compile_options(GENERIC_F103R8HX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103R8HX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103R8HX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103R8HX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103R8HX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103R8HX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103R8HX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103R8HX_usb_none INTERFACE)
target_compile_options(GENERIC_F103R8HX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R8HX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103R8HX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R8HX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103R8HX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103R8HX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103R8HX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103R8HX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103R8HX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)H")
set(GENERIC_F103R8HX_dfu2_MAXSIZE 65536)
set(GENERIC_F103R8HX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103R8HX_dfu2_MCU cortex-m3)
set(GENERIC_F103R8HX_dfu2_FPCONF "-")
add_library(GENERIC_F103R8HX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103R8HX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R8HX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103R8HX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R8HX"
	"BOARD_NAME=\"GENERIC_F103R8HX\""
	"BOARD_ID=GENERIC_F103R8HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R8HX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R8HX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103R8HX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103R8HX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103R8HX_dfu2_MCU}
)


# GENERIC_F103R8HX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103R8HX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)H")
set(GENERIC_F103R8HX_dfuo_MAXSIZE 65536)
set(GENERIC_F103R8HX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103R8HX_dfuo_MCU cortex-m3)
set(GENERIC_F103R8HX_dfuo_FPCONF "-")
add_library(GENERIC_F103R8HX_dfuo INTERFACE)
target_compile_options(GENERIC_F103R8HX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R8HX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103R8HX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R8HX"
	"BOARD_NAME=\"GENERIC_F103R8HX\""
	"BOARD_ID=GENERIC_F103R8HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R8HX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R8HX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103R8HX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103R8HX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103R8HX_dfuo_MCU}
)


# GENERIC_F103R8HX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103R8HX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)H")
set(GENERIC_F103R8HX_hid_MAXSIZE 65536)
set(GENERIC_F103R8HX_hid_MAXDATASIZE 20480)
set(GENERIC_F103R8HX_hid_MCU cortex-m3)
set(GENERIC_F103R8HX_hid_FPCONF "-")
add_library(GENERIC_F103R8HX_hid INTERFACE)
target_compile_options(GENERIC_F103R8HX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R8HX_hid_MCU}
)
target_compile_definitions(GENERIC_F103R8HX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R8HX"
	"BOARD_NAME=\"GENERIC_F103R8HX\""
	"BOARD_ID=GENERIC_F103R8HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R8HX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R8HX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103R8HX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103R8HX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103R8HX_hid_MCU}
)


# GENERIC_F103R8TX
# -----------------------------------------------------------------------------

set(GENERIC_F103R8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(GENERIC_F103R8TX_MAXSIZE 65536)
set(GENERIC_F103R8TX_MAXDATASIZE 20480)
set(GENERIC_F103R8TX_MCU cortex-m3)
set(GENERIC_F103R8TX_FPCONF "-")
add_library(GENERIC_F103R8TX INTERFACE)
target_compile_options(GENERIC_F103R8TX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R8TX_MCU}
)
target_compile_definitions(GENERIC_F103R8TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R8TX"
	"BOARD_NAME=\"GENERIC_F103R8TX\""
	"BOARD_ID=GENERIC_F103R8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F103R8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F103R8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103R8TX_MCU}
)

add_library(GENERIC_F103R8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103R8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103R8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103R8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F103R8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103R8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103R8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103R8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103R8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103R8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103R8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103R8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F103R8TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R8TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103R8TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103R8TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103R8TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103R8TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103R8TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103R8TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103R8TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(GENERIC_F103R8TX_dfu2_MAXSIZE 65536)
set(GENERIC_F103R8TX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103R8TX_dfu2_MCU cortex-m3)
set(GENERIC_F103R8TX_dfu2_FPCONF "-")
add_library(GENERIC_F103R8TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103R8TX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R8TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103R8TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R8TX"
	"BOARD_NAME=\"GENERIC_F103R8TX\""
	"BOARD_ID=GENERIC_F103R8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R8TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R8TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103R8TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103R8TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103R8TX_dfu2_MCU}
)


# GENERIC_F103R8TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103R8TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(GENERIC_F103R8TX_dfuo_MAXSIZE 65536)
set(GENERIC_F103R8TX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103R8TX_dfuo_MCU cortex-m3)
set(GENERIC_F103R8TX_dfuo_FPCONF "-")
add_library(GENERIC_F103R8TX_dfuo INTERFACE)
target_compile_options(GENERIC_F103R8TX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R8TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103R8TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R8TX"
	"BOARD_NAME=\"GENERIC_F103R8TX\""
	"BOARD_ID=GENERIC_F103R8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R8TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R8TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103R8TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103R8TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103R8TX_dfuo_MCU}
)


# GENERIC_F103R8TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103R8TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(GENERIC_F103R8TX_hid_MAXSIZE 65536)
set(GENERIC_F103R8TX_hid_MAXDATASIZE 20480)
set(GENERIC_F103R8TX_hid_MCU cortex-m3)
set(GENERIC_F103R8TX_hid_FPCONF "-")
add_library(GENERIC_F103R8TX_hid INTERFACE)
target_compile_options(GENERIC_F103R8TX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103R8TX_hid_MCU}
)
target_compile_definitions(GENERIC_F103R8TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103R8TX"
	"BOARD_NAME=\"GENERIC_F103R8TX\""
	"BOARD_ID=GENERIC_F103R8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103R8TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103R8TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103R8TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103R8TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103R8TX_hid_MCU}
)


# GENERIC_F103RBHX
# -----------------------------------------------------------------------------

set(GENERIC_F103RBHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)H")
set(GENERIC_F103RBHX_MAXSIZE 131072)
set(GENERIC_F103RBHX_MAXDATASIZE 20480)
set(GENERIC_F103RBHX_MCU cortex-m3)
set(GENERIC_F103RBHX_FPCONF "-")
add_library(GENERIC_F103RBHX INTERFACE)
target_compile_options(GENERIC_F103RBHX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RBHX_MCU}
)
target_compile_definitions(GENERIC_F103RBHX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RBHX"
	"BOARD_NAME=\"GENERIC_F103RBHX\""
	"BOARD_ID=GENERIC_F103RBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RBHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RBHX_VARIANT_PATH}
)

target_link_options(GENERIC_F103RBHX INTERFACE
  "LINKER:--default-script=${GENERIC_F103RBHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103RBHX_MCU}
)

add_library(GENERIC_F103RBHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103RBHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RBHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103RBHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103RBHX_serial_none INTERFACE)
target_compile_options(GENERIC_F103RBHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103RBHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103RBHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103RBHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103RBHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103RBHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103RBHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103RBHX_usb_none INTERFACE)
target_compile_options(GENERIC_F103RBHX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RBHX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103RBHX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RBHX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103RBHX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103RBHX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103RBHX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103RBHX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103RBHX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)H")
set(GENERIC_F103RBHX_dfu2_MAXSIZE 131072)
set(GENERIC_F103RBHX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103RBHX_dfu2_MCU cortex-m3)
set(GENERIC_F103RBHX_dfu2_FPCONF "-")
add_library(GENERIC_F103RBHX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103RBHX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RBHX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103RBHX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RBHX"
	"BOARD_NAME=\"GENERIC_F103RBHX\""
	"BOARD_ID=GENERIC_F103RBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RBHX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RBHX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103RBHX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103RBHX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103RBHX_dfu2_MCU}
)


# GENERIC_F103RBHX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103RBHX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)H")
set(GENERIC_F103RBHX_dfuo_MAXSIZE 131072)
set(GENERIC_F103RBHX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103RBHX_dfuo_MCU cortex-m3)
set(GENERIC_F103RBHX_dfuo_FPCONF "-")
add_library(GENERIC_F103RBHX_dfuo INTERFACE)
target_compile_options(GENERIC_F103RBHX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RBHX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103RBHX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RBHX"
	"BOARD_NAME=\"GENERIC_F103RBHX\""
	"BOARD_ID=GENERIC_F103RBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RBHX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RBHX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103RBHX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103RBHX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103RBHX_dfuo_MCU}
)


# GENERIC_F103RBHX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103RBHX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)H")
set(GENERIC_F103RBHX_hid_MAXSIZE 131072)
set(GENERIC_F103RBHX_hid_MAXDATASIZE 20480)
set(GENERIC_F103RBHX_hid_MCU cortex-m3)
set(GENERIC_F103RBHX_hid_FPCONF "-")
add_library(GENERIC_F103RBHX_hid INTERFACE)
target_compile_options(GENERIC_F103RBHX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RBHX_hid_MCU}
)
target_compile_definitions(GENERIC_F103RBHX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RBHX"
	"BOARD_NAME=\"GENERIC_F103RBHX\""
	"BOARD_ID=GENERIC_F103RBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RBHX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RBHX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103RBHX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103RBHX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103RBHX_hid_MCU}
)


# GENERIC_F103RBTX
# -----------------------------------------------------------------------------

set(GENERIC_F103RBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(GENERIC_F103RBTX_MAXSIZE 131072)
set(GENERIC_F103RBTX_MAXDATASIZE 20480)
set(GENERIC_F103RBTX_MCU cortex-m3)
set(GENERIC_F103RBTX_FPCONF "-")
add_library(GENERIC_F103RBTX INTERFACE)
target_compile_options(GENERIC_F103RBTX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RBTX_MCU}
)
target_compile_definitions(GENERIC_F103RBTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RBTX"
	"BOARD_NAME=\"GENERIC_F103RBTX\""
	"BOARD_ID=GENERIC_F103RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F103RBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F103RBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103RBTX_MCU}
)

add_library(GENERIC_F103RBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103RBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103RBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103RBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F103RBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103RBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103RBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103RBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103RBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103RBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103RBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103RBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F103RBTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RBTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103RBTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RBTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103RBTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103RBTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103RBTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103RBTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103RBTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(GENERIC_F103RBTX_dfu2_MAXSIZE 131072)
set(GENERIC_F103RBTX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103RBTX_dfu2_MCU cortex-m3)
set(GENERIC_F103RBTX_dfu2_FPCONF "-")
add_library(GENERIC_F103RBTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103RBTX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RBTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103RBTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RBTX"
	"BOARD_NAME=\"GENERIC_F103RBTX\""
	"BOARD_ID=GENERIC_F103RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RBTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RBTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103RBTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103RBTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103RBTX_dfu2_MCU}
)


# GENERIC_F103RBTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103RBTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(GENERIC_F103RBTX_dfuo_MAXSIZE 131072)
set(GENERIC_F103RBTX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103RBTX_dfuo_MCU cortex-m3)
set(GENERIC_F103RBTX_dfuo_FPCONF "-")
add_library(GENERIC_F103RBTX_dfuo INTERFACE)
target_compile_options(GENERIC_F103RBTX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RBTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103RBTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RBTX"
	"BOARD_NAME=\"GENERIC_F103RBTX\""
	"BOARD_ID=GENERIC_F103RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RBTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RBTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103RBTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103RBTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103RBTX_dfuo_MCU}
)


# GENERIC_F103RBTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103RBTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(8-B)T")
set(GENERIC_F103RBTX_hid_MAXSIZE 131072)
set(GENERIC_F103RBTX_hid_MAXDATASIZE 20480)
set(GENERIC_F103RBTX_hid_MCU cortex-m3)
set(GENERIC_F103RBTX_hid_FPCONF "-")
add_library(GENERIC_F103RBTX_hid INTERFACE)
target_compile_options(GENERIC_F103RBTX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RBTX_hid_MCU}
)
target_compile_definitions(GENERIC_F103RBTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RBTX"
	"BOARD_NAME=\"GENERIC_F103RBTX\""
	"BOARD_ID=GENERIC_F103RBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RBTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RBTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103RBTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103RBTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103RBTX_hid_MCU}
)


# GENERIC_F103RCTX
# -----------------------------------------------------------------------------

set(GENERIC_F103RCTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(GENERIC_F103RCTX_MAXSIZE 262144)
set(GENERIC_F103RCTX_MAXDATASIZE 49152)
set(GENERIC_F103RCTX_MCU cortex-m3)
set(GENERIC_F103RCTX_FPCONF "-")
add_library(GENERIC_F103RCTX INTERFACE)
target_compile_options(GENERIC_F103RCTX INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RCTX_MCU}
)
target_compile_definitions(GENERIC_F103RCTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RCTX"
	"BOARD_NAME=\"GENERIC_F103RCTX\""
	"BOARD_ID=GENERIC_F103RCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RCTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RCTX_VARIANT_PATH}
)

target_link_options(GENERIC_F103RCTX INTERFACE
  "LINKER:--default-script=${GENERIC_F103RCTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103RCTX_MCU}
)

add_library(GENERIC_F103RCTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103RCTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RCTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103RCTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103RCTX_serial_none INTERFACE)
target_compile_options(GENERIC_F103RCTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103RCTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103RCTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103RCTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103RCTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103RCTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103RCTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103RCTX_usb_none INTERFACE)
target_compile_options(GENERIC_F103RCTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RCTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103RCTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RCTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103RCTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103RCTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103RCTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103RCTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103RCTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(GENERIC_F103RCTX_dfu2_MAXSIZE 262144)
set(GENERIC_F103RCTX_dfu2_MAXDATASIZE 49152)
set(GENERIC_F103RCTX_dfu2_MCU cortex-m3)
set(GENERIC_F103RCTX_dfu2_FPCONF "-")
add_library(GENERIC_F103RCTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103RCTX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RCTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103RCTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RCTX"
	"BOARD_NAME=\"GENERIC_F103RCTX\""
	"BOARD_ID=GENERIC_F103RCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RCTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RCTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103RCTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103RCTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103RCTX_dfu2_MCU}
)


# GENERIC_F103RCTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103RCTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(GENERIC_F103RCTX_dfuo_MAXSIZE 262144)
set(GENERIC_F103RCTX_dfuo_MAXDATASIZE 49152)
set(GENERIC_F103RCTX_dfuo_MCU cortex-m3)
set(GENERIC_F103RCTX_dfuo_FPCONF "-")
add_library(GENERIC_F103RCTX_dfuo INTERFACE)
target_compile_options(GENERIC_F103RCTX_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RCTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103RCTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RCTX"
	"BOARD_NAME=\"GENERIC_F103RCTX\""
	"BOARD_ID=GENERIC_F103RCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RCTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RCTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103RCTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103RCTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103RCTX_dfuo_MCU}
)


# GENERIC_F103RCTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103RCTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(GENERIC_F103RCTX_hid_MAXSIZE 262144)
set(GENERIC_F103RCTX_hid_MAXDATASIZE 49152)
set(GENERIC_F103RCTX_hid_MCU cortex-m3)
set(GENERIC_F103RCTX_hid_FPCONF "-")
add_library(GENERIC_F103RCTX_hid INTERFACE)
target_compile_options(GENERIC_F103RCTX_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RCTX_hid_MCU}
)
target_compile_definitions(GENERIC_F103RCTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RCTX"
	"BOARD_NAME=\"GENERIC_F103RCTX\""
	"BOARD_ID=GENERIC_F103RCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RCTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RCTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103RCTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103RCTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103RCTX_hid_MCU}
)


# GENERIC_F103RCYX
# -----------------------------------------------------------------------------

set(GENERIC_F103RCYX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)Y")
set(GENERIC_F103RCYX_MAXSIZE 262144)
set(GENERIC_F103RCYX_MAXDATASIZE 49152)
set(GENERIC_F103RCYX_MCU cortex-m3)
set(GENERIC_F103RCYX_FPCONF "-")
add_library(GENERIC_F103RCYX INTERFACE)
target_compile_options(GENERIC_F103RCYX INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RCYX_MCU}
)
target_compile_definitions(GENERIC_F103RCYX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RCYX"
	"BOARD_NAME=\"GENERIC_F103RCYX\""
	"BOARD_ID=GENERIC_F103RCYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RCYX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RCYX_VARIANT_PATH}
)

target_link_options(GENERIC_F103RCYX INTERFACE
  "LINKER:--default-script=${GENERIC_F103RCYX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103RCYX_MCU}
)

add_library(GENERIC_F103RCYX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103RCYX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RCYX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103RCYX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103RCYX_serial_none INTERFACE)
target_compile_options(GENERIC_F103RCYX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103RCYX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103RCYX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103RCYX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103RCYX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103RCYX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103RCYX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103RCYX_usb_none INTERFACE)
target_compile_options(GENERIC_F103RCYX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RCYX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103RCYX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RCYX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103RCYX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103RCYX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103RCYX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103RCYX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103RCYX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)Y")
set(GENERIC_F103RCYX_dfu2_MAXSIZE 262144)
set(GENERIC_F103RCYX_dfu2_MAXDATASIZE 49152)
set(GENERIC_F103RCYX_dfu2_MCU cortex-m3)
set(GENERIC_F103RCYX_dfu2_FPCONF "-")
add_library(GENERIC_F103RCYX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103RCYX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RCYX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103RCYX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RCYX"
	"BOARD_NAME=\"GENERIC_F103RCYX\""
	"BOARD_ID=GENERIC_F103RCYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RCYX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RCYX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103RCYX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103RCYX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103RCYX_dfu2_MCU}
)


# GENERIC_F103RCYX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103RCYX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)Y")
set(GENERIC_F103RCYX_dfuo_MAXSIZE 262144)
set(GENERIC_F103RCYX_dfuo_MAXDATASIZE 49152)
set(GENERIC_F103RCYX_dfuo_MCU cortex-m3)
set(GENERIC_F103RCYX_dfuo_FPCONF "-")
add_library(GENERIC_F103RCYX_dfuo INTERFACE)
target_compile_options(GENERIC_F103RCYX_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RCYX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103RCYX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RCYX"
	"BOARD_NAME=\"GENERIC_F103RCYX\""
	"BOARD_ID=GENERIC_F103RCYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RCYX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RCYX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103RCYX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103RCYX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103RCYX_dfuo_MCU}
)


# GENERIC_F103RCYX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103RCYX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)Y")
set(GENERIC_F103RCYX_hid_MAXSIZE 262144)
set(GENERIC_F103RCYX_hid_MAXDATASIZE 49152)
set(GENERIC_F103RCYX_hid_MCU cortex-m3)
set(GENERIC_F103RCYX_hid_FPCONF "-")
add_library(GENERIC_F103RCYX_hid INTERFACE)
target_compile_options(GENERIC_F103RCYX_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RCYX_hid_MCU}
)
target_compile_definitions(GENERIC_F103RCYX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RCYX"
	"BOARD_NAME=\"GENERIC_F103RCYX\""
	"BOARD_ID=GENERIC_F103RCYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RCYX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RCYX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103RCYX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103RCYX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103RCYX_hid_MCU}
)


# GENERIC_F103RDTX
# -----------------------------------------------------------------------------

set(GENERIC_F103RDTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(GENERIC_F103RDTX_MAXSIZE 393216)
set(GENERIC_F103RDTX_MAXDATASIZE 65536)
set(GENERIC_F103RDTX_MCU cortex-m3)
set(GENERIC_F103RDTX_FPCONF "-")
add_library(GENERIC_F103RDTX INTERFACE)
target_compile_options(GENERIC_F103RDTX INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RDTX_MCU}
)
target_compile_definitions(GENERIC_F103RDTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RDTX"
	"BOARD_NAME=\"GENERIC_F103RDTX\""
	"BOARD_ID=GENERIC_F103RDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RDTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RDTX_VARIANT_PATH}
)

target_link_options(GENERIC_F103RDTX INTERFACE
  "LINKER:--default-script=${GENERIC_F103RDTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103RDTX_MCU}
)

add_library(GENERIC_F103RDTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103RDTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RDTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103RDTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103RDTX_serial_none INTERFACE)
target_compile_options(GENERIC_F103RDTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103RDTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103RDTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103RDTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103RDTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103RDTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103RDTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103RDTX_usb_none INTERFACE)
target_compile_options(GENERIC_F103RDTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RDTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103RDTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RDTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103RDTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103RDTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103RDTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103RDTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103RDTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(GENERIC_F103RDTX_dfu2_MAXSIZE 393216)
set(GENERIC_F103RDTX_dfu2_MAXDATASIZE 65536)
set(GENERIC_F103RDTX_dfu2_MCU cortex-m3)
set(GENERIC_F103RDTX_dfu2_FPCONF "-")
add_library(GENERIC_F103RDTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103RDTX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RDTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103RDTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RDTX"
	"BOARD_NAME=\"GENERIC_F103RDTX\""
	"BOARD_ID=GENERIC_F103RDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RDTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RDTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103RDTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103RDTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103RDTX_dfu2_MCU}
)


# GENERIC_F103RDTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103RDTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(GENERIC_F103RDTX_dfuo_MAXSIZE 393216)
set(GENERIC_F103RDTX_dfuo_MAXDATASIZE 65536)
set(GENERIC_F103RDTX_dfuo_MCU cortex-m3)
set(GENERIC_F103RDTX_dfuo_FPCONF "-")
add_library(GENERIC_F103RDTX_dfuo INTERFACE)
target_compile_options(GENERIC_F103RDTX_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RDTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103RDTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RDTX"
	"BOARD_NAME=\"GENERIC_F103RDTX\""
	"BOARD_ID=GENERIC_F103RDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RDTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RDTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103RDTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103RDTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103RDTX_dfuo_MCU}
)


# GENERIC_F103RDTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103RDTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(GENERIC_F103RDTX_hid_MAXSIZE 393216)
set(GENERIC_F103RDTX_hid_MAXDATASIZE 65536)
set(GENERIC_F103RDTX_hid_MCU cortex-m3)
set(GENERIC_F103RDTX_hid_FPCONF "-")
add_library(GENERIC_F103RDTX_hid INTERFACE)
target_compile_options(GENERIC_F103RDTX_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RDTX_hid_MCU}
)
target_compile_definitions(GENERIC_F103RDTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RDTX"
	"BOARD_NAME=\"GENERIC_F103RDTX\""
	"BOARD_ID=GENERIC_F103RDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RDTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RDTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103RDTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103RDTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103RDTX_hid_MCU}
)


# GENERIC_F103RDYX
# -----------------------------------------------------------------------------

set(GENERIC_F103RDYX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)Y")
set(GENERIC_F103RDYX_MAXSIZE 393216)
set(GENERIC_F103RDYX_MAXDATASIZE 65536)
set(GENERIC_F103RDYX_MCU cortex-m3)
set(GENERIC_F103RDYX_FPCONF "-")
add_library(GENERIC_F103RDYX INTERFACE)
target_compile_options(GENERIC_F103RDYX INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RDYX_MCU}
)
target_compile_definitions(GENERIC_F103RDYX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RDYX"
	"BOARD_NAME=\"GENERIC_F103RDYX\""
	"BOARD_ID=GENERIC_F103RDYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RDYX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RDYX_VARIANT_PATH}
)

target_link_options(GENERIC_F103RDYX INTERFACE
  "LINKER:--default-script=${GENERIC_F103RDYX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103RDYX_MCU}
)

add_library(GENERIC_F103RDYX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103RDYX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RDYX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103RDYX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103RDYX_serial_none INTERFACE)
target_compile_options(GENERIC_F103RDYX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103RDYX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103RDYX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103RDYX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103RDYX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103RDYX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103RDYX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103RDYX_usb_none INTERFACE)
target_compile_options(GENERIC_F103RDYX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RDYX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103RDYX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RDYX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103RDYX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103RDYX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103RDYX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103RDYX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103RDYX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)Y")
set(GENERIC_F103RDYX_dfu2_MAXSIZE 393216)
set(GENERIC_F103RDYX_dfu2_MAXDATASIZE 65536)
set(GENERIC_F103RDYX_dfu2_MCU cortex-m3)
set(GENERIC_F103RDYX_dfu2_FPCONF "-")
add_library(GENERIC_F103RDYX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103RDYX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RDYX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103RDYX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RDYX"
	"BOARD_NAME=\"GENERIC_F103RDYX\""
	"BOARD_ID=GENERIC_F103RDYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RDYX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RDYX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103RDYX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103RDYX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103RDYX_dfu2_MCU}
)


# GENERIC_F103RDYX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103RDYX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)Y")
set(GENERIC_F103RDYX_dfuo_MAXSIZE 393216)
set(GENERIC_F103RDYX_dfuo_MAXDATASIZE 65536)
set(GENERIC_F103RDYX_dfuo_MCU cortex-m3)
set(GENERIC_F103RDYX_dfuo_FPCONF "-")
add_library(GENERIC_F103RDYX_dfuo INTERFACE)
target_compile_options(GENERIC_F103RDYX_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RDYX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103RDYX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RDYX"
	"BOARD_NAME=\"GENERIC_F103RDYX\""
	"BOARD_ID=GENERIC_F103RDYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RDYX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RDYX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103RDYX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103RDYX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103RDYX_dfuo_MCU}
)


# GENERIC_F103RDYX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103RDYX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)Y")
set(GENERIC_F103RDYX_hid_MAXSIZE 393216)
set(GENERIC_F103RDYX_hid_MAXDATASIZE 65536)
set(GENERIC_F103RDYX_hid_MCU cortex-m3)
set(GENERIC_F103RDYX_hid_FPCONF "-")
add_library(GENERIC_F103RDYX_hid INTERFACE)
target_compile_options(GENERIC_F103RDYX_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RDYX_hid_MCU}
)
target_compile_definitions(GENERIC_F103RDYX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RDYX"
	"BOARD_NAME=\"GENERIC_F103RDYX\""
	"BOARD_ID=GENERIC_F103RDYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RDYX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RDYX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103RDYX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103RDYX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103RDYX_hid_MCU}
)


# GENERIC_F103RETX
# -----------------------------------------------------------------------------

set(GENERIC_F103RETX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(GENERIC_F103RETX_MAXSIZE 524288)
set(GENERIC_F103RETX_MAXDATASIZE 65536)
set(GENERIC_F103RETX_MCU cortex-m3)
set(GENERIC_F103RETX_FPCONF "-")
add_library(GENERIC_F103RETX INTERFACE)
target_compile_options(GENERIC_F103RETX INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RETX_MCU}
)
target_compile_definitions(GENERIC_F103RETX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RETX"
	"BOARD_NAME=\"GENERIC_F103RETX\""
	"BOARD_ID=GENERIC_F103RETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RETX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RETX_VARIANT_PATH}
)

target_link_options(GENERIC_F103RETX INTERFACE
  "LINKER:--default-script=${GENERIC_F103RETX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103RETX_MCU}
)

add_library(GENERIC_F103RETX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103RETX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RETX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103RETX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103RETX_serial_none INTERFACE)
target_compile_options(GENERIC_F103RETX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103RETX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103RETX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103RETX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103RETX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103RETX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103RETX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103RETX_usb_none INTERFACE)
target_compile_options(GENERIC_F103RETX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RETX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103RETX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RETX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103RETX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103RETX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103RETX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103RETX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103RETX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(GENERIC_F103RETX_dfu2_MAXSIZE 524288)
set(GENERIC_F103RETX_dfu2_MAXDATASIZE 65536)
set(GENERIC_F103RETX_dfu2_MCU cortex-m3)
set(GENERIC_F103RETX_dfu2_FPCONF "-")
add_library(GENERIC_F103RETX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103RETX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RETX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103RETX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RETX"
	"BOARD_NAME=\"GENERIC_F103RETX\""
	"BOARD_ID=GENERIC_F103RETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RETX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RETX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103RETX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103RETX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103RETX_dfu2_MCU}
)


# GENERIC_F103RETX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103RETX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(GENERIC_F103RETX_dfuo_MAXSIZE 524288)
set(GENERIC_F103RETX_dfuo_MAXDATASIZE 65536)
set(GENERIC_F103RETX_dfuo_MCU cortex-m3)
set(GENERIC_F103RETX_dfuo_FPCONF "-")
add_library(GENERIC_F103RETX_dfuo INTERFACE)
target_compile_options(GENERIC_F103RETX_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RETX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103RETX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RETX"
	"BOARD_NAME=\"GENERIC_F103RETX\""
	"BOARD_ID=GENERIC_F103RETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RETX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RETX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103RETX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103RETX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103RETX_dfuo_MCU}
)


# GENERIC_F103RETX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103RETX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)T")
set(GENERIC_F103RETX_hid_MAXSIZE 524288)
set(GENERIC_F103RETX_hid_MAXDATASIZE 65536)
set(GENERIC_F103RETX_hid_MCU cortex-m3)
set(GENERIC_F103RETX_hid_FPCONF "-")
add_library(GENERIC_F103RETX_hid INTERFACE)
target_compile_options(GENERIC_F103RETX_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RETX_hid_MCU}
)
target_compile_definitions(GENERIC_F103RETX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RETX"
	"BOARD_NAME=\"GENERIC_F103RETX\""
	"BOARD_ID=GENERIC_F103RETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RETX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RETX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103RETX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103RETX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103RETX_hid_MCU}
)


# GENERIC_F103REYX
# -----------------------------------------------------------------------------

set(GENERIC_F103REYX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)Y")
set(GENERIC_F103REYX_MAXSIZE 524288)
set(GENERIC_F103REYX_MAXDATASIZE 65536)
set(GENERIC_F103REYX_MCU cortex-m3)
set(GENERIC_F103REYX_FPCONF "-")
add_library(GENERIC_F103REYX INTERFACE)
target_compile_options(GENERIC_F103REYX INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103REYX_MCU}
)
target_compile_definitions(GENERIC_F103REYX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103REYX"
	"BOARD_NAME=\"GENERIC_F103REYX\""
	"BOARD_ID=GENERIC_F103REYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103REYX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103REYX_VARIANT_PATH}
)

target_link_options(GENERIC_F103REYX INTERFACE
  "LINKER:--default-script=${GENERIC_F103REYX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103REYX_MCU}
)

add_library(GENERIC_F103REYX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103REYX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103REYX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103REYX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103REYX_serial_none INTERFACE)
target_compile_options(GENERIC_F103REYX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103REYX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103REYX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103REYX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103REYX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103REYX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103REYX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103REYX_usb_none INTERFACE)
target_compile_options(GENERIC_F103REYX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103REYX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103REYX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103REYX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103REYX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103REYX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103REYX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103REYX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103REYX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)Y")
set(GENERIC_F103REYX_dfu2_MAXSIZE 524288)
set(GENERIC_F103REYX_dfu2_MAXDATASIZE 65536)
set(GENERIC_F103REYX_dfu2_MCU cortex-m3)
set(GENERIC_F103REYX_dfu2_FPCONF "-")
add_library(GENERIC_F103REYX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103REYX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103REYX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103REYX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103REYX"
	"BOARD_NAME=\"GENERIC_F103REYX\""
	"BOARD_ID=GENERIC_F103REYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103REYX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103REYX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103REYX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103REYX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103REYX_dfu2_MCU}
)


# GENERIC_F103REYX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103REYX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)Y")
set(GENERIC_F103REYX_dfuo_MAXSIZE 524288)
set(GENERIC_F103REYX_dfuo_MAXDATASIZE 65536)
set(GENERIC_F103REYX_dfuo_MCU cortex-m3)
set(GENERIC_F103REYX_dfuo_FPCONF "-")
add_library(GENERIC_F103REYX_dfuo INTERFACE)
target_compile_options(GENERIC_F103REYX_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103REYX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103REYX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103REYX"
	"BOARD_NAME=\"GENERIC_F103REYX\""
	"BOARD_ID=GENERIC_F103REYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103REYX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103REYX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103REYX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103REYX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103REYX_dfuo_MCU}
)


# GENERIC_F103REYX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103REYX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(C-D-E)Y")
set(GENERIC_F103REYX_hid_MAXSIZE 524288)
set(GENERIC_F103REYX_hid_MAXDATASIZE 65536)
set(GENERIC_F103REYX_hid_MCU cortex-m3)
set(GENERIC_F103REYX_hid_FPCONF "-")
add_library(GENERIC_F103REYX_hid INTERFACE)
target_compile_options(GENERIC_F103REYX_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103REYX_hid_MCU}
)
target_compile_definitions(GENERIC_F103REYX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103REYX"
	"BOARD_NAME=\"GENERIC_F103REYX\""
	"BOARD_ID=GENERIC_F103REYX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103REYX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103REYX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103REYX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103REYX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103REYX_hid_MCU}
)


# GENERIC_F103RFTX
# -----------------------------------------------------------------------------

set(GENERIC_F103RFTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(F-G)T")
set(GENERIC_F103RFTX_MAXSIZE 786432)
set(GENERIC_F103RFTX_MAXDATASIZE 98304)
set(GENERIC_F103RFTX_MCU cortex-m3)
set(GENERIC_F103RFTX_FPCONF "-")
add_library(GENERIC_F103RFTX INTERFACE)
target_compile_options(GENERIC_F103RFTX INTERFACE
  "SHELL:-DSTM32F103xG   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RFTX_MCU}
)
target_compile_definitions(GENERIC_F103RFTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RFTX"
	"BOARD_NAME=\"GENERIC_F103RFTX\""
	"BOARD_ID=GENERIC_F103RFTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RFTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RFTX_VARIANT_PATH}
)

target_link_options(GENERIC_F103RFTX INTERFACE
  "LINKER:--default-script=${GENERIC_F103RFTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=786432"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103RFTX_MCU}
)

add_library(GENERIC_F103RFTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103RFTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RFTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103RFTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103RFTX_serial_none INTERFACE)
target_compile_options(GENERIC_F103RFTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103RFTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103RFTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103RFTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103RFTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103RFTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103RFTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103RFTX_usb_none INTERFACE)
target_compile_options(GENERIC_F103RFTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RFTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103RFTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RFTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103RFTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103RFTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103RFTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103RFTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103RFTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(F-G)T")
set(GENERIC_F103RFTX_dfu2_MAXSIZE 786432)
set(GENERIC_F103RFTX_dfu2_MAXDATASIZE 98304)
set(GENERIC_F103RFTX_dfu2_MCU cortex-m3)
set(GENERIC_F103RFTX_dfu2_FPCONF "-")
add_library(GENERIC_F103RFTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103RFTX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xG  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RFTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103RFTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RFTX"
	"BOARD_NAME=\"GENERIC_F103RFTX\""
	"BOARD_ID=GENERIC_F103RFTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RFTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RFTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103RFTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103RFTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=786432"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103RFTX_dfu2_MCU}
)


# GENERIC_F103RFTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103RFTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(F-G)T")
set(GENERIC_F103RFTX_dfuo_MAXSIZE 786432)
set(GENERIC_F103RFTX_dfuo_MAXDATASIZE 98304)
set(GENERIC_F103RFTX_dfuo_MCU cortex-m3)
set(GENERIC_F103RFTX_dfuo_FPCONF "-")
add_library(GENERIC_F103RFTX_dfuo INTERFACE)
target_compile_options(GENERIC_F103RFTX_dfuo INTERFACE
  "SHELL:-DSTM32F103xG  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RFTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103RFTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RFTX"
	"BOARD_NAME=\"GENERIC_F103RFTX\""
	"BOARD_ID=GENERIC_F103RFTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RFTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RFTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103RFTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103RFTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=786432"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103RFTX_dfuo_MCU}
)


# GENERIC_F103RFTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103RFTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(F-G)T")
set(GENERIC_F103RFTX_hid_MAXSIZE 786432)
set(GENERIC_F103RFTX_hid_MAXDATASIZE 98304)
set(GENERIC_F103RFTX_hid_MCU cortex-m3)
set(GENERIC_F103RFTX_hid_FPCONF "-")
add_library(GENERIC_F103RFTX_hid INTERFACE)
target_compile_options(GENERIC_F103RFTX_hid INTERFACE
  "SHELL:-DSTM32F103xG  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RFTX_hid_MCU}
)
target_compile_definitions(GENERIC_F103RFTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RFTX"
	"BOARD_NAME=\"GENERIC_F103RFTX\""
	"BOARD_ID=GENERIC_F103RFTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RFTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RFTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103RFTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103RFTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=786432"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103RFTX_hid_MCU}
)


# GENERIC_F103RGTX
# -----------------------------------------------------------------------------

set(GENERIC_F103RGTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(F-G)T")
set(GENERIC_F103RGTX_MAXSIZE 1048576)
set(GENERIC_F103RGTX_MAXDATASIZE 98304)
set(GENERIC_F103RGTX_MCU cortex-m3)
set(GENERIC_F103RGTX_FPCONF "-")
add_library(GENERIC_F103RGTX INTERFACE)
target_compile_options(GENERIC_F103RGTX INTERFACE
  "SHELL:-DSTM32F103xG   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RGTX_MCU}
)
target_compile_definitions(GENERIC_F103RGTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RGTX"
	"BOARD_NAME=\"GENERIC_F103RGTX\""
	"BOARD_ID=GENERIC_F103RGTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RGTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RGTX_VARIANT_PATH}
)

target_link_options(GENERIC_F103RGTX INTERFACE
  "LINKER:--default-script=${GENERIC_F103RGTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103RGTX_MCU}
)

add_library(GENERIC_F103RGTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103RGTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RGTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103RGTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103RGTX_serial_none INTERFACE)
target_compile_options(GENERIC_F103RGTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103RGTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103RGTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103RGTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103RGTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103RGTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103RGTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103RGTX_usb_none INTERFACE)
target_compile_options(GENERIC_F103RGTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RGTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103RGTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103RGTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103RGTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103RGTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103RGTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103RGTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103RGTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(F-G)T")
set(GENERIC_F103RGTX_dfu2_MAXSIZE 1048576)
set(GENERIC_F103RGTX_dfu2_MAXDATASIZE 98304)
set(GENERIC_F103RGTX_dfu2_MCU cortex-m3)
set(GENERIC_F103RGTX_dfu2_FPCONF "-")
add_library(GENERIC_F103RGTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103RGTX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xG  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RGTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103RGTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RGTX"
	"BOARD_NAME=\"GENERIC_F103RGTX\""
	"BOARD_ID=GENERIC_F103RGTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RGTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RGTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103RGTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103RGTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103RGTX_dfu2_MCU}
)


# GENERIC_F103RGTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103RGTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(F-G)T")
set(GENERIC_F103RGTX_dfuo_MAXSIZE 1048576)
set(GENERIC_F103RGTX_dfuo_MAXDATASIZE 98304)
set(GENERIC_F103RGTX_dfuo_MCU cortex-m3)
set(GENERIC_F103RGTX_dfuo_FPCONF "-")
add_library(GENERIC_F103RGTX_dfuo INTERFACE)
target_compile_options(GENERIC_F103RGTX_dfuo INTERFACE
  "SHELL:-DSTM32F103xG  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RGTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103RGTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RGTX"
	"BOARD_NAME=\"GENERIC_F103RGTX\""
	"BOARD_ID=GENERIC_F103RGTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RGTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RGTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103RGTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103RGTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103RGTX_dfuo_MCU}
)


# GENERIC_F103RGTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103RGTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103R(F-G)T")
set(GENERIC_F103RGTX_hid_MAXSIZE 1048576)
set(GENERIC_F103RGTX_hid_MAXDATASIZE 98304)
set(GENERIC_F103RGTX_hid_MCU cortex-m3)
set(GENERIC_F103RGTX_hid_FPCONF "-")
add_library(GENERIC_F103RGTX_hid INTERFACE)
target_compile_options(GENERIC_F103RGTX_hid INTERFACE
  "SHELL:-DSTM32F103xG  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103RGTX_hid_MCU}
)
target_compile_definitions(GENERIC_F103RGTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103RGTX"
	"BOARD_NAME=\"GENERIC_F103RGTX\""
	"BOARD_ID=GENERIC_F103RGTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103RGTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103RGTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103RGTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103RGTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103RGTX_hid_MCU}
)


# GENERIC_F103T4UX
# -----------------------------------------------------------------------------

set(GENERIC_F103T4UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(4-6)U")
set(GENERIC_F103T4UX_MAXSIZE 16384)
set(GENERIC_F103T4UX_MAXDATASIZE 6144)
set(GENERIC_F103T4UX_MCU cortex-m3)
set(GENERIC_F103T4UX_FPCONF "-")
add_library(GENERIC_F103T4UX INTERFACE)
target_compile_options(GENERIC_F103T4UX INTERFACE
  "SHELL:-DSTM32F103x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103T4UX_MCU}
)
target_compile_definitions(GENERIC_F103T4UX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103T4UX"
	"BOARD_NAME=\"GENERIC_F103T4UX\""
	"BOARD_ID=GENERIC_F103T4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103T4UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103T4UX_VARIANT_PATH}
)

target_link_options(GENERIC_F103T4UX INTERFACE
  "LINKER:--default-script=${GENERIC_F103T4UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103T4UX_MCU}
)

add_library(GENERIC_F103T4UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103T4UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103T4UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103T4UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103T4UX_serial_none INTERFACE)
target_compile_options(GENERIC_F103T4UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103T4UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103T4UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103T4UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103T4UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103T4UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103T4UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103T4UX_usb_none INTERFACE)
target_compile_options(GENERIC_F103T4UX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103T4UX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103T4UX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103T4UX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103T4UX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103T4UX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103T4UX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103T4UX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103T4UX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(4-6)U")
set(GENERIC_F103T4UX_dfu2_MAXSIZE 16384)
set(GENERIC_F103T4UX_dfu2_MAXDATASIZE 6144)
set(GENERIC_F103T4UX_dfu2_MCU cortex-m3)
set(GENERIC_F103T4UX_dfu2_FPCONF "-")
add_library(GENERIC_F103T4UX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103T4UX_dfu2 INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103T4UX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103T4UX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103T4UX"
	"BOARD_NAME=\"GENERIC_F103T4UX\""
	"BOARD_ID=GENERIC_F103T4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103T4UX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103T4UX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103T4UX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103T4UX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103T4UX_dfu2_MCU}
)


# GENERIC_F103T4UX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103T4UX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(4-6)U")
set(GENERIC_F103T4UX_dfuo_MAXSIZE 16384)
set(GENERIC_F103T4UX_dfuo_MAXDATASIZE 6144)
set(GENERIC_F103T4UX_dfuo_MCU cortex-m3)
set(GENERIC_F103T4UX_dfuo_FPCONF "-")
add_library(GENERIC_F103T4UX_dfuo INTERFACE)
target_compile_options(GENERIC_F103T4UX_dfuo INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103T4UX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103T4UX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103T4UX"
	"BOARD_NAME=\"GENERIC_F103T4UX\""
	"BOARD_ID=GENERIC_F103T4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103T4UX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103T4UX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103T4UX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103T4UX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103T4UX_dfuo_MCU}
)


# GENERIC_F103T4UX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103T4UX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(4-6)U")
set(GENERIC_F103T4UX_hid_MAXSIZE 16384)
set(GENERIC_F103T4UX_hid_MAXDATASIZE 6144)
set(GENERIC_F103T4UX_hid_MCU cortex-m3)
set(GENERIC_F103T4UX_hid_FPCONF "-")
add_library(GENERIC_F103T4UX_hid INTERFACE)
target_compile_options(GENERIC_F103T4UX_hid INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103T4UX_hid_MCU}
)
target_compile_definitions(GENERIC_F103T4UX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103T4UX"
	"BOARD_NAME=\"GENERIC_F103T4UX\""
	"BOARD_ID=GENERIC_F103T4UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103T4UX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103T4UX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103T4UX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103T4UX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=16384"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=6144"
  "SHELL: "
  -mcpu=${GENERIC_F103T4UX_hid_MCU}
)


# GENERIC_F103T6UX
# -----------------------------------------------------------------------------

set(GENERIC_F103T6UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(4-6)U")
set(GENERIC_F103T6UX_MAXSIZE 32768)
set(GENERIC_F103T6UX_MAXDATASIZE 10240)
set(GENERIC_F103T6UX_MCU cortex-m3)
set(GENERIC_F103T6UX_FPCONF "-")
add_library(GENERIC_F103T6UX INTERFACE)
target_compile_options(GENERIC_F103T6UX INTERFACE
  "SHELL:-DSTM32F103x6   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103T6UX_MCU}
)
target_compile_definitions(GENERIC_F103T6UX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103T6UX"
	"BOARD_NAME=\"GENERIC_F103T6UX\""
	"BOARD_ID=GENERIC_F103T6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103T6UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103T6UX_VARIANT_PATH}
)

target_link_options(GENERIC_F103T6UX INTERFACE
  "LINKER:--default-script=${GENERIC_F103T6UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103T6UX_MCU}
)

add_library(GENERIC_F103T6UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103T6UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103T6UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103T6UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103T6UX_serial_none INTERFACE)
target_compile_options(GENERIC_F103T6UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103T6UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103T6UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103T6UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103T6UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103T6UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103T6UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103T6UX_usb_none INTERFACE)
target_compile_options(GENERIC_F103T6UX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103T6UX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103T6UX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103T6UX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103T6UX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103T6UX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103T6UX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103T6UX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103T6UX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(4-6)U")
set(GENERIC_F103T6UX_dfu2_MAXSIZE 32768)
set(GENERIC_F103T6UX_dfu2_MAXDATASIZE 10240)
set(GENERIC_F103T6UX_dfu2_MCU cortex-m3)
set(GENERIC_F103T6UX_dfu2_FPCONF "-")
add_library(GENERIC_F103T6UX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103T6UX_dfu2 INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103T6UX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103T6UX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103T6UX"
	"BOARD_NAME=\"GENERIC_F103T6UX\""
	"BOARD_ID=GENERIC_F103T6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103T6UX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103T6UX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103T6UX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103T6UX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103T6UX_dfu2_MCU}
)


# GENERIC_F103T6UX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103T6UX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(4-6)U")
set(GENERIC_F103T6UX_dfuo_MAXSIZE 32768)
set(GENERIC_F103T6UX_dfuo_MAXDATASIZE 10240)
set(GENERIC_F103T6UX_dfuo_MCU cortex-m3)
set(GENERIC_F103T6UX_dfuo_FPCONF "-")
add_library(GENERIC_F103T6UX_dfuo INTERFACE)
target_compile_options(GENERIC_F103T6UX_dfuo INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103T6UX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103T6UX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103T6UX"
	"BOARD_NAME=\"GENERIC_F103T6UX\""
	"BOARD_ID=GENERIC_F103T6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103T6UX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103T6UX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103T6UX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103T6UX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103T6UX_dfuo_MCU}
)


# GENERIC_F103T6UX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103T6UX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(4-6)U")
set(GENERIC_F103T6UX_hid_MAXSIZE 32768)
set(GENERIC_F103T6UX_hid_MAXDATASIZE 10240)
set(GENERIC_F103T6UX_hid_MCU cortex-m3)
set(GENERIC_F103T6UX_hid_FPCONF "-")
add_library(GENERIC_F103T6UX_hid INTERFACE)
target_compile_options(GENERIC_F103T6UX_hid INTERFACE
  "SHELL:-DSTM32F103x6  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103T6UX_hid_MCU}
)
target_compile_definitions(GENERIC_F103T6UX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103T6UX"
	"BOARD_NAME=\"GENERIC_F103T6UX\""
	"BOARD_ID=GENERIC_F103T6UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103T6UX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103T6UX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103T6UX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103T6UX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=32768"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=10240"
  "SHELL: "
  -mcpu=${GENERIC_F103T6UX_hid_MCU}
)


# GENERIC_F103T8UX
# -----------------------------------------------------------------------------

set(GENERIC_F103T8UX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(8-B)U")
set(GENERIC_F103T8UX_MAXSIZE 65536)
set(GENERIC_F103T8UX_MAXDATASIZE 20480)
set(GENERIC_F103T8UX_MCU cortex-m3)
set(GENERIC_F103T8UX_FPCONF "-")
add_library(GENERIC_F103T8UX INTERFACE)
target_compile_options(GENERIC_F103T8UX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103T8UX_MCU}
)
target_compile_definitions(GENERIC_F103T8UX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103T8UX"
	"BOARD_NAME=\"GENERIC_F103T8UX\""
	"BOARD_ID=GENERIC_F103T8UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103T8UX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103T8UX_VARIANT_PATH}
)

target_link_options(GENERIC_F103T8UX INTERFACE
  "LINKER:--default-script=${GENERIC_F103T8UX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103T8UX_MCU}
)

add_library(GENERIC_F103T8UX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103T8UX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103T8UX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103T8UX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103T8UX_serial_none INTERFACE)
target_compile_options(GENERIC_F103T8UX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103T8UX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103T8UX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103T8UX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103T8UX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103T8UX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103T8UX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103T8UX_usb_none INTERFACE)
target_compile_options(GENERIC_F103T8UX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103T8UX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103T8UX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103T8UX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103T8UX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103T8UX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103T8UX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103T8UX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103T8UX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(8-B)U")
set(GENERIC_F103T8UX_dfu2_MAXSIZE 65536)
set(GENERIC_F103T8UX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103T8UX_dfu2_MCU cortex-m3)
set(GENERIC_F103T8UX_dfu2_FPCONF "-")
add_library(GENERIC_F103T8UX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103T8UX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103T8UX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103T8UX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103T8UX"
	"BOARD_NAME=\"GENERIC_F103T8UX\""
	"BOARD_ID=GENERIC_F103T8UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103T8UX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103T8UX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103T8UX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103T8UX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103T8UX_dfu2_MCU}
)


# GENERIC_F103T8UX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103T8UX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(8-B)U")
set(GENERIC_F103T8UX_dfuo_MAXSIZE 65536)
set(GENERIC_F103T8UX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103T8UX_dfuo_MCU cortex-m3)
set(GENERIC_F103T8UX_dfuo_FPCONF "-")
add_library(GENERIC_F103T8UX_dfuo INTERFACE)
target_compile_options(GENERIC_F103T8UX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103T8UX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103T8UX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103T8UX"
	"BOARD_NAME=\"GENERIC_F103T8UX\""
	"BOARD_ID=GENERIC_F103T8UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103T8UX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103T8UX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103T8UX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103T8UX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103T8UX_dfuo_MCU}
)


# GENERIC_F103T8UX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103T8UX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(8-B)U")
set(GENERIC_F103T8UX_hid_MAXSIZE 65536)
set(GENERIC_F103T8UX_hid_MAXDATASIZE 20480)
set(GENERIC_F103T8UX_hid_MCU cortex-m3)
set(GENERIC_F103T8UX_hid_FPCONF "-")
add_library(GENERIC_F103T8UX_hid INTERFACE)
target_compile_options(GENERIC_F103T8UX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103T8UX_hid_MCU}
)
target_compile_definitions(GENERIC_F103T8UX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103T8UX"
	"BOARD_NAME=\"GENERIC_F103T8UX\""
	"BOARD_ID=GENERIC_F103T8UX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103T8UX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103T8UX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103T8UX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103T8UX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103T8UX_hid_MCU}
)


# GENERIC_F103TBUX
# -----------------------------------------------------------------------------

set(GENERIC_F103TBUX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(8-B)U")
set(GENERIC_F103TBUX_MAXSIZE 131072)
set(GENERIC_F103TBUX_MAXDATASIZE 20480)
set(GENERIC_F103TBUX_MCU cortex-m3)
set(GENERIC_F103TBUX_FPCONF "-")
add_library(GENERIC_F103TBUX INTERFACE)
target_compile_options(GENERIC_F103TBUX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103TBUX_MCU}
)
target_compile_definitions(GENERIC_F103TBUX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103TBUX"
	"BOARD_NAME=\"GENERIC_F103TBUX\""
	"BOARD_ID=GENERIC_F103TBUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103TBUX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103TBUX_VARIANT_PATH}
)

target_link_options(GENERIC_F103TBUX INTERFACE
  "LINKER:--default-script=${GENERIC_F103TBUX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103TBUX_MCU}
)

add_library(GENERIC_F103TBUX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103TBUX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103TBUX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103TBUX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103TBUX_serial_none INTERFACE)
target_compile_options(GENERIC_F103TBUX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103TBUX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103TBUX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103TBUX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103TBUX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103TBUX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103TBUX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103TBUX_usb_none INTERFACE)
target_compile_options(GENERIC_F103TBUX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103TBUX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103TBUX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103TBUX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103TBUX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103TBUX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103TBUX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103TBUX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103TBUX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(8-B)U")
set(GENERIC_F103TBUX_dfu2_MAXSIZE 131072)
set(GENERIC_F103TBUX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103TBUX_dfu2_MCU cortex-m3)
set(GENERIC_F103TBUX_dfu2_FPCONF "-")
add_library(GENERIC_F103TBUX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103TBUX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103TBUX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103TBUX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103TBUX"
	"BOARD_NAME=\"GENERIC_F103TBUX\""
	"BOARD_ID=GENERIC_F103TBUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103TBUX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103TBUX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103TBUX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103TBUX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103TBUX_dfu2_MCU}
)


# GENERIC_F103TBUX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103TBUX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(8-B)U")
set(GENERIC_F103TBUX_dfuo_MAXSIZE 131072)
set(GENERIC_F103TBUX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103TBUX_dfuo_MCU cortex-m3)
set(GENERIC_F103TBUX_dfuo_FPCONF "-")
add_library(GENERIC_F103TBUX_dfuo INTERFACE)
target_compile_options(GENERIC_F103TBUX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103TBUX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103TBUX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103TBUX"
	"BOARD_NAME=\"GENERIC_F103TBUX\""
	"BOARD_ID=GENERIC_F103TBUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103TBUX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103TBUX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103TBUX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103TBUX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103TBUX_dfuo_MCU}
)


# GENERIC_F103TBUX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103TBUX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103T(8-B)U")
set(GENERIC_F103TBUX_hid_MAXSIZE 131072)
set(GENERIC_F103TBUX_hid_MAXDATASIZE 20480)
set(GENERIC_F103TBUX_hid_MCU cortex-m3)
set(GENERIC_F103TBUX_hid_FPCONF "-")
add_library(GENERIC_F103TBUX_hid INTERFACE)
target_compile_options(GENERIC_F103TBUX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103TBUX_hid_MCU}
)
target_compile_definitions(GENERIC_F103TBUX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103TBUX"
	"BOARD_NAME=\"GENERIC_F103TBUX\""
	"BOARD_ID=GENERIC_F103TBUX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103TBUX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103TBUX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103TBUX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103TBUX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103TBUX_hid_MCU}
)


# GENERIC_F103V8HX
# -----------------------------------------------------------------------------

set(GENERIC_F103V8HX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103V8HX_MAXSIZE 65536)
set(GENERIC_F103V8HX_MAXDATASIZE 20480)
set(GENERIC_F103V8HX_MCU cortex-m3)
set(GENERIC_F103V8HX_FPCONF "-")
add_library(GENERIC_F103V8HX INTERFACE)
target_compile_options(GENERIC_F103V8HX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103V8HX_MCU}
)
target_compile_definitions(GENERIC_F103V8HX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103V8HX"
	"BOARD_NAME=\"GENERIC_F103V8HX\""
	"BOARD_ID=GENERIC_F103V8HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103V8HX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103V8HX_VARIANT_PATH}
)

target_link_options(GENERIC_F103V8HX INTERFACE
  "LINKER:--default-script=${GENERIC_F103V8HX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103V8HX_MCU}
)

add_library(GENERIC_F103V8HX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103V8HX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103V8HX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103V8HX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103V8HX_serial_none INTERFACE)
target_compile_options(GENERIC_F103V8HX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103V8HX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103V8HX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103V8HX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103V8HX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103V8HX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103V8HX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103V8HX_usb_none INTERFACE)
target_compile_options(GENERIC_F103V8HX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103V8HX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103V8HX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103V8HX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103V8HX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103V8HX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103V8HX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103V8HX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103V8HX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103V8HX_dfu2_MAXSIZE 65536)
set(GENERIC_F103V8HX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103V8HX_dfu2_MCU cortex-m3)
set(GENERIC_F103V8HX_dfu2_FPCONF "-")
add_library(GENERIC_F103V8HX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103V8HX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103V8HX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103V8HX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103V8HX"
	"BOARD_NAME=\"GENERIC_F103V8HX\""
	"BOARD_ID=GENERIC_F103V8HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103V8HX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103V8HX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103V8HX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103V8HX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103V8HX_dfu2_MCU}
)


# GENERIC_F103V8HX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103V8HX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103V8HX_dfuo_MAXSIZE 65536)
set(GENERIC_F103V8HX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103V8HX_dfuo_MCU cortex-m3)
set(GENERIC_F103V8HX_dfuo_FPCONF "-")
add_library(GENERIC_F103V8HX_dfuo INTERFACE)
target_compile_options(GENERIC_F103V8HX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103V8HX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103V8HX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103V8HX"
	"BOARD_NAME=\"GENERIC_F103V8HX\""
	"BOARD_ID=GENERIC_F103V8HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103V8HX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103V8HX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103V8HX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103V8HX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103V8HX_dfuo_MCU}
)


# GENERIC_F103V8HX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103V8HX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103V8HX_hid_MAXSIZE 65536)
set(GENERIC_F103V8HX_hid_MAXDATASIZE 20480)
set(GENERIC_F103V8HX_hid_MCU cortex-m3)
set(GENERIC_F103V8HX_hid_FPCONF "-")
add_library(GENERIC_F103V8HX_hid INTERFACE)
target_compile_options(GENERIC_F103V8HX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103V8HX_hid_MCU}
)
target_compile_definitions(GENERIC_F103V8HX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103V8HX"
	"BOARD_NAME=\"GENERIC_F103V8HX\""
	"BOARD_ID=GENERIC_F103V8HX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103V8HX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103V8HX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103V8HX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103V8HX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103V8HX_hid_MCU}
)


# GENERIC_F103V8TX
# -----------------------------------------------------------------------------

set(GENERIC_F103V8TX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103V8TX_MAXSIZE 65536)
set(GENERIC_F103V8TX_MAXDATASIZE 20480)
set(GENERIC_F103V8TX_MCU cortex-m3)
set(GENERIC_F103V8TX_FPCONF "-")
add_library(GENERIC_F103V8TX INTERFACE)
target_compile_options(GENERIC_F103V8TX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103V8TX_MCU}
)
target_compile_definitions(GENERIC_F103V8TX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103V8TX"
	"BOARD_NAME=\"GENERIC_F103V8TX\""
	"BOARD_ID=GENERIC_F103V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103V8TX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103V8TX_VARIANT_PATH}
)

target_link_options(GENERIC_F103V8TX INTERFACE
  "LINKER:--default-script=${GENERIC_F103V8TX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103V8TX_MCU}
)

add_library(GENERIC_F103V8TX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103V8TX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103V8TX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103V8TX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103V8TX_serial_none INTERFACE)
target_compile_options(GENERIC_F103V8TX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103V8TX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103V8TX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103V8TX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103V8TX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103V8TX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103V8TX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103V8TX_usb_none INTERFACE)
target_compile_options(GENERIC_F103V8TX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103V8TX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103V8TX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103V8TX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103V8TX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103V8TX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103V8TX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103V8TX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103V8TX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103V8TX_dfu2_MAXSIZE 65536)
set(GENERIC_F103V8TX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103V8TX_dfu2_MCU cortex-m3)
set(GENERIC_F103V8TX_dfu2_FPCONF "-")
add_library(GENERIC_F103V8TX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103V8TX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103V8TX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103V8TX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103V8TX"
	"BOARD_NAME=\"GENERIC_F103V8TX\""
	"BOARD_ID=GENERIC_F103V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103V8TX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103V8TX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103V8TX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103V8TX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103V8TX_dfu2_MCU}
)


# GENERIC_F103V8TX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103V8TX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103V8TX_dfuo_MAXSIZE 65536)
set(GENERIC_F103V8TX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103V8TX_dfuo_MCU cortex-m3)
set(GENERIC_F103V8TX_dfuo_FPCONF "-")
add_library(GENERIC_F103V8TX_dfuo INTERFACE)
target_compile_options(GENERIC_F103V8TX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103V8TX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103V8TX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103V8TX"
	"BOARD_NAME=\"GENERIC_F103V8TX\""
	"BOARD_ID=GENERIC_F103V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103V8TX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103V8TX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103V8TX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103V8TX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103V8TX_dfuo_MCU}
)


# GENERIC_F103V8TX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103V8TX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103V8TX_hid_MAXSIZE 65536)
set(GENERIC_F103V8TX_hid_MAXDATASIZE 20480)
set(GENERIC_F103V8TX_hid_MCU cortex-m3)
set(GENERIC_F103V8TX_hid_FPCONF "-")
add_library(GENERIC_F103V8TX_hid INTERFACE)
target_compile_options(GENERIC_F103V8TX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103V8TX_hid_MCU}
)
target_compile_definitions(GENERIC_F103V8TX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103V8TX"
	"BOARD_NAME=\"GENERIC_F103V8TX\""
	"BOARD_ID=GENERIC_F103V8TX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103V8TX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103V8TX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103V8TX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103V8TX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=65536"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103V8TX_hid_MCU}
)


# GENERIC_F103VBHX
# -----------------------------------------------------------------------------

set(GENERIC_F103VBHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103VBHX_MAXSIZE 131072)
set(GENERIC_F103VBHX_MAXDATASIZE 20480)
set(GENERIC_F103VBHX_MCU cortex-m3)
set(GENERIC_F103VBHX_FPCONF "-")
add_library(GENERIC_F103VBHX INTERFACE)
target_compile_options(GENERIC_F103VBHX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VBHX_MCU}
)
target_compile_definitions(GENERIC_F103VBHX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VBHX"
	"BOARD_NAME=\"GENERIC_F103VBHX\""
	"BOARD_ID=GENERIC_F103VBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VBHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VBHX_VARIANT_PATH}
)

target_link_options(GENERIC_F103VBHX INTERFACE
  "LINKER:--default-script=${GENERIC_F103VBHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103VBHX_MCU}
)

add_library(GENERIC_F103VBHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103VBHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VBHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103VBHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103VBHX_serial_none INTERFACE)
target_compile_options(GENERIC_F103VBHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103VBHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103VBHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103VBHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103VBHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103VBHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103VBHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103VBHX_usb_none INTERFACE)
target_compile_options(GENERIC_F103VBHX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VBHX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103VBHX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VBHX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103VBHX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103VBHX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103VBHX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103VBHX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103VBHX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103VBHX_dfu2_MAXSIZE 131072)
set(GENERIC_F103VBHX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103VBHX_dfu2_MCU cortex-m3)
set(GENERIC_F103VBHX_dfu2_FPCONF "-")
add_library(GENERIC_F103VBHX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103VBHX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VBHX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103VBHX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VBHX"
	"BOARD_NAME=\"GENERIC_F103VBHX\""
	"BOARD_ID=GENERIC_F103VBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VBHX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VBHX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103VBHX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103VBHX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103VBHX_dfu2_MCU}
)


# GENERIC_F103VBHX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103VBHX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103VBHX_dfuo_MAXSIZE 131072)
set(GENERIC_F103VBHX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103VBHX_dfuo_MCU cortex-m3)
set(GENERIC_F103VBHX_dfuo_FPCONF "-")
add_library(GENERIC_F103VBHX_dfuo INTERFACE)
target_compile_options(GENERIC_F103VBHX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VBHX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103VBHX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VBHX"
	"BOARD_NAME=\"GENERIC_F103VBHX\""
	"BOARD_ID=GENERIC_F103VBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VBHX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VBHX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103VBHX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103VBHX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103VBHX_dfuo_MCU}
)


# GENERIC_F103VBHX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103VBHX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103VBHX_hid_MAXSIZE 131072)
set(GENERIC_F103VBHX_hid_MAXDATASIZE 20480)
set(GENERIC_F103VBHX_hid_MCU cortex-m3)
set(GENERIC_F103VBHX_hid_FPCONF "-")
add_library(GENERIC_F103VBHX_hid INTERFACE)
target_compile_options(GENERIC_F103VBHX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VBHX_hid_MCU}
)
target_compile_definitions(GENERIC_F103VBHX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VBHX"
	"BOARD_NAME=\"GENERIC_F103VBHX\""
	"BOARD_ID=GENERIC_F103VBHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VBHX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VBHX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103VBHX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103VBHX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103VBHX_hid_MCU}
)


# GENERIC_F103VBIX
# -----------------------------------------------------------------------------

set(GENERIC_F103VBIX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103VBIX_MAXSIZE 131072)
set(GENERIC_F103VBIX_MAXDATASIZE 20480)
set(GENERIC_F103VBIX_MCU cortex-m3)
set(GENERIC_F103VBIX_FPCONF "-")
add_library(GENERIC_F103VBIX INTERFACE)
target_compile_options(GENERIC_F103VBIX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VBIX_MCU}
)
target_compile_definitions(GENERIC_F103VBIX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VBIX"
	"BOARD_NAME=\"GENERIC_F103VBIX\""
	"BOARD_ID=GENERIC_F103VBIX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VBIX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VBIX_VARIANT_PATH}
)

target_link_options(GENERIC_F103VBIX INTERFACE
  "LINKER:--default-script=${GENERIC_F103VBIX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103VBIX_MCU}
)

add_library(GENERIC_F103VBIX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103VBIX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VBIX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103VBIX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103VBIX_serial_none INTERFACE)
target_compile_options(GENERIC_F103VBIX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103VBIX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103VBIX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103VBIX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103VBIX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103VBIX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103VBIX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103VBIX_usb_none INTERFACE)
target_compile_options(GENERIC_F103VBIX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VBIX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103VBIX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VBIX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103VBIX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103VBIX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103VBIX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103VBIX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103VBIX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103VBIX_dfu2_MAXSIZE 131072)
set(GENERIC_F103VBIX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103VBIX_dfu2_MCU cortex-m3)
set(GENERIC_F103VBIX_dfu2_FPCONF "-")
add_library(GENERIC_F103VBIX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103VBIX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VBIX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103VBIX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VBIX"
	"BOARD_NAME=\"GENERIC_F103VBIX\""
	"BOARD_ID=GENERIC_F103VBIX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VBIX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VBIX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103VBIX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103VBIX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103VBIX_dfu2_MCU}
)


# GENERIC_F103VBIX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103VBIX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103VBIX_dfuo_MAXSIZE 131072)
set(GENERIC_F103VBIX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103VBIX_dfuo_MCU cortex-m3)
set(GENERIC_F103VBIX_dfuo_FPCONF "-")
add_library(GENERIC_F103VBIX_dfuo INTERFACE)
target_compile_options(GENERIC_F103VBIX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VBIX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103VBIX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VBIX"
	"BOARD_NAME=\"GENERIC_F103VBIX\""
	"BOARD_ID=GENERIC_F103VBIX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VBIX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VBIX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103VBIX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103VBIX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103VBIX_dfuo_MCU}
)


# GENERIC_F103VBIX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103VBIX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103VBIX_hid_MAXSIZE 131072)
set(GENERIC_F103VBIX_hid_MAXDATASIZE 20480)
set(GENERIC_F103VBIX_hid_MCU cortex-m3)
set(GENERIC_F103VBIX_hid_FPCONF "-")
add_library(GENERIC_F103VBIX_hid INTERFACE)
target_compile_options(GENERIC_F103VBIX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VBIX_hid_MCU}
)
target_compile_definitions(GENERIC_F103VBIX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VBIX"
	"BOARD_NAME=\"GENERIC_F103VBIX\""
	"BOARD_ID=GENERIC_F103VBIX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VBIX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VBIX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103VBIX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103VBIX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103VBIX_hid_MCU}
)


# GENERIC_F103VBTX
# -----------------------------------------------------------------------------

set(GENERIC_F103VBTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103VBTX_MAXSIZE 131072)
set(GENERIC_F103VBTX_MAXDATASIZE 20480)
set(GENERIC_F103VBTX_MCU cortex-m3)
set(GENERIC_F103VBTX_FPCONF "-")
add_library(GENERIC_F103VBTX INTERFACE)
target_compile_options(GENERIC_F103VBTX INTERFACE
  "SHELL:-DSTM32F103xB   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VBTX_MCU}
)
target_compile_definitions(GENERIC_F103VBTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VBTX"
	"BOARD_NAME=\"GENERIC_F103VBTX\""
	"BOARD_ID=GENERIC_F103VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VBTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VBTX_VARIANT_PATH}
)

target_link_options(GENERIC_F103VBTX INTERFACE
  "LINKER:--default-script=${GENERIC_F103VBTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103VBTX_MCU}
)

add_library(GENERIC_F103VBTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103VBTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VBTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103VBTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103VBTX_serial_none INTERFACE)
target_compile_options(GENERIC_F103VBTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103VBTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103VBTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103VBTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103VBTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103VBTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103VBTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103VBTX_usb_none INTERFACE)
target_compile_options(GENERIC_F103VBTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VBTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103VBTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VBTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103VBTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103VBTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103VBTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103VBTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103VBTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103VBTX_dfu2_MAXSIZE 131072)
set(GENERIC_F103VBTX_dfu2_MAXDATASIZE 20480)
set(GENERIC_F103VBTX_dfu2_MCU cortex-m3)
set(GENERIC_F103VBTX_dfu2_FPCONF "-")
add_library(GENERIC_F103VBTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103VBTX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VBTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103VBTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VBTX"
	"BOARD_NAME=\"GENERIC_F103VBTX\""
	"BOARD_ID=GENERIC_F103VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VBTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VBTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103VBTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103VBTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103VBTX_dfu2_MCU}
)


# GENERIC_F103VBTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103VBTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103VBTX_dfuo_MAXSIZE 131072)
set(GENERIC_F103VBTX_dfuo_MAXDATASIZE 20480)
set(GENERIC_F103VBTX_dfuo_MCU cortex-m3)
set(GENERIC_F103VBTX_dfuo_FPCONF "-")
add_library(GENERIC_F103VBTX_dfuo INTERFACE)
target_compile_options(GENERIC_F103VBTX_dfuo INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VBTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103VBTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VBTX"
	"BOARD_NAME=\"GENERIC_F103VBTX\""
	"BOARD_ID=GENERIC_F103VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VBTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VBTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103VBTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103VBTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103VBTX_dfuo_MCU}
)


# GENERIC_F103VBTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103VBTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V8(H-T)_F103VB(H-I-T)")
set(GENERIC_F103VBTX_hid_MAXSIZE 131072)
set(GENERIC_F103VBTX_hid_MAXDATASIZE 20480)
set(GENERIC_F103VBTX_hid_MCU cortex-m3)
set(GENERIC_F103VBTX_hid_FPCONF "-")
add_library(GENERIC_F103VBTX_hid INTERFACE)
target_compile_options(GENERIC_F103VBTX_hid INTERFACE
  "SHELL:-DSTM32F103xB  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VBTX_hid_MCU}
)
target_compile_definitions(GENERIC_F103VBTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VBTX"
	"BOARD_NAME=\"GENERIC_F103VBTX\""
	"BOARD_ID=GENERIC_F103VBTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VBTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VBTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103VBTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103VBTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=131072"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=20480"
  "SHELL: "
  -mcpu=${GENERIC_F103VBTX_hid_MCU}
)


# GENERIC_F103VCHX
# -----------------------------------------------------------------------------

set(GENERIC_F103VCHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VCHX_MAXSIZE 262144)
set(GENERIC_F103VCHX_MAXDATASIZE 49152)
set(GENERIC_F103VCHX_MCU cortex-m3)
set(GENERIC_F103VCHX_FPCONF "-")
add_library(GENERIC_F103VCHX INTERFACE)
target_compile_options(GENERIC_F103VCHX INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VCHX_MCU}
)
target_compile_definitions(GENERIC_F103VCHX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VCHX"
	"BOARD_NAME=\"GENERIC_F103VCHX\""
	"BOARD_ID=GENERIC_F103VCHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VCHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VCHX_VARIANT_PATH}
)

target_link_options(GENERIC_F103VCHX INTERFACE
  "LINKER:--default-script=${GENERIC_F103VCHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103VCHX_MCU}
)

add_library(GENERIC_F103VCHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103VCHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VCHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103VCHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103VCHX_serial_none INTERFACE)
target_compile_options(GENERIC_F103VCHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103VCHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103VCHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103VCHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103VCHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103VCHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103VCHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103VCHX_usb_none INTERFACE)
target_compile_options(GENERIC_F103VCHX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VCHX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103VCHX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VCHX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103VCHX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103VCHX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103VCHX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103VCHX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103VCHX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VCHX_dfu2_MAXSIZE 262144)
set(GENERIC_F103VCHX_dfu2_MAXDATASIZE 49152)
set(GENERIC_F103VCHX_dfu2_MCU cortex-m3)
set(GENERIC_F103VCHX_dfu2_FPCONF "-")
add_library(GENERIC_F103VCHX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103VCHX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VCHX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103VCHX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VCHX"
	"BOARD_NAME=\"GENERIC_F103VCHX\""
	"BOARD_ID=GENERIC_F103VCHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VCHX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VCHX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103VCHX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103VCHX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103VCHX_dfu2_MCU}
)


# GENERIC_F103VCHX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103VCHX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VCHX_dfuo_MAXSIZE 262144)
set(GENERIC_F103VCHX_dfuo_MAXDATASIZE 49152)
set(GENERIC_F103VCHX_dfuo_MCU cortex-m3)
set(GENERIC_F103VCHX_dfuo_FPCONF "-")
add_library(GENERIC_F103VCHX_dfuo INTERFACE)
target_compile_options(GENERIC_F103VCHX_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VCHX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103VCHX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VCHX"
	"BOARD_NAME=\"GENERIC_F103VCHX\""
	"BOARD_ID=GENERIC_F103VCHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VCHX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VCHX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103VCHX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103VCHX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103VCHX_dfuo_MCU}
)


# GENERIC_F103VCHX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103VCHX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VCHX_hid_MAXSIZE 262144)
set(GENERIC_F103VCHX_hid_MAXDATASIZE 49152)
set(GENERIC_F103VCHX_hid_MCU cortex-m3)
set(GENERIC_F103VCHX_hid_FPCONF "-")
add_library(GENERIC_F103VCHX_hid INTERFACE)
target_compile_options(GENERIC_F103VCHX_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VCHX_hid_MCU}
)
target_compile_definitions(GENERIC_F103VCHX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VCHX"
	"BOARD_NAME=\"GENERIC_F103VCHX\""
	"BOARD_ID=GENERIC_F103VCHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VCHX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VCHX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103VCHX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103VCHX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103VCHX_hid_MCU}
)


# GENERIC_F103VCTX
# -----------------------------------------------------------------------------

set(GENERIC_F103VCTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VCTX_MAXSIZE 262144)
set(GENERIC_F103VCTX_MAXDATASIZE 49152)
set(GENERIC_F103VCTX_MCU cortex-m3)
set(GENERIC_F103VCTX_FPCONF "-")
add_library(GENERIC_F103VCTX INTERFACE)
target_compile_options(GENERIC_F103VCTX INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VCTX_MCU}
)
target_compile_definitions(GENERIC_F103VCTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VCTX"
	"BOARD_NAME=\"GENERIC_F103VCTX\""
	"BOARD_ID=GENERIC_F103VCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VCTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VCTX_VARIANT_PATH}
)

target_link_options(GENERIC_F103VCTX INTERFACE
  "LINKER:--default-script=${GENERIC_F103VCTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103VCTX_MCU}
)

add_library(GENERIC_F103VCTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103VCTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VCTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103VCTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103VCTX_serial_none INTERFACE)
target_compile_options(GENERIC_F103VCTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103VCTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103VCTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103VCTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103VCTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103VCTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103VCTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103VCTX_usb_none INTERFACE)
target_compile_options(GENERIC_F103VCTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VCTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103VCTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VCTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103VCTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103VCTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103VCTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103VCTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103VCTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VCTX_dfu2_MAXSIZE 262144)
set(GENERIC_F103VCTX_dfu2_MAXDATASIZE 49152)
set(GENERIC_F103VCTX_dfu2_MCU cortex-m3)
set(GENERIC_F103VCTX_dfu2_FPCONF "-")
add_library(GENERIC_F103VCTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103VCTX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VCTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103VCTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VCTX"
	"BOARD_NAME=\"GENERIC_F103VCTX\""
	"BOARD_ID=GENERIC_F103VCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VCTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VCTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103VCTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103VCTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103VCTX_dfu2_MCU}
)


# GENERIC_F103VCTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103VCTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VCTX_dfuo_MAXSIZE 262144)
set(GENERIC_F103VCTX_dfuo_MAXDATASIZE 49152)
set(GENERIC_F103VCTX_dfuo_MCU cortex-m3)
set(GENERIC_F103VCTX_dfuo_FPCONF "-")
add_library(GENERIC_F103VCTX_dfuo INTERFACE)
target_compile_options(GENERIC_F103VCTX_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VCTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103VCTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VCTX"
	"BOARD_NAME=\"GENERIC_F103VCTX\""
	"BOARD_ID=GENERIC_F103VCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VCTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VCTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103VCTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103VCTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103VCTX_dfuo_MCU}
)


# GENERIC_F103VCTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103VCTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VCTX_hid_MAXSIZE 262144)
set(GENERIC_F103VCTX_hid_MAXDATASIZE 49152)
set(GENERIC_F103VCTX_hid_MCU cortex-m3)
set(GENERIC_F103VCTX_hid_FPCONF "-")
add_library(GENERIC_F103VCTX_hid INTERFACE)
target_compile_options(GENERIC_F103VCTX_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VCTX_hid_MCU}
)
target_compile_definitions(GENERIC_F103VCTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VCTX"
	"BOARD_NAME=\"GENERIC_F103VCTX\""
	"BOARD_ID=GENERIC_F103VCTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VCTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VCTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103VCTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103VCTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=262144"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=49152"
  "SHELL: "
  -mcpu=${GENERIC_F103VCTX_hid_MCU}
)


# GENERIC_F103VDHX
# -----------------------------------------------------------------------------

set(GENERIC_F103VDHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VDHX_MAXSIZE 393216)
set(GENERIC_F103VDHX_MAXDATASIZE 65536)
set(GENERIC_F103VDHX_MCU cortex-m3)
set(GENERIC_F103VDHX_FPCONF "-")
add_library(GENERIC_F103VDHX INTERFACE)
target_compile_options(GENERIC_F103VDHX INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VDHX_MCU}
)
target_compile_definitions(GENERIC_F103VDHX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VDHX"
	"BOARD_NAME=\"GENERIC_F103VDHX\""
	"BOARD_ID=GENERIC_F103VDHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VDHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VDHX_VARIANT_PATH}
)

target_link_options(GENERIC_F103VDHX INTERFACE
  "LINKER:--default-script=${GENERIC_F103VDHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VDHX_MCU}
)

add_library(GENERIC_F103VDHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103VDHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VDHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103VDHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103VDHX_serial_none INTERFACE)
target_compile_options(GENERIC_F103VDHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103VDHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103VDHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103VDHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103VDHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103VDHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103VDHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103VDHX_usb_none INTERFACE)
target_compile_options(GENERIC_F103VDHX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VDHX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103VDHX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VDHX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103VDHX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103VDHX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103VDHX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103VDHX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103VDHX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VDHX_dfu2_MAXSIZE 393216)
set(GENERIC_F103VDHX_dfu2_MAXDATASIZE 65536)
set(GENERIC_F103VDHX_dfu2_MCU cortex-m3)
set(GENERIC_F103VDHX_dfu2_FPCONF "-")
add_library(GENERIC_F103VDHX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103VDHX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VDHX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103VDHX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VDHX"
	"BOARD_NAME=\"GENERIC_F103VDHX\""
	"BOARD_ID=GENERIC_F103VDHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VDHX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VDHX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103VDHX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103VDHX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VDHX_dfu2_MCU}
)


# GENERIC_F103VDHX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103VDHX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VDHX_dfuo_MAXSIZE 393216)
set(GENERIC_F103VDHX_dfuo_MAXDATASIZE 65536)
set(GENERIC_F103VDHX_dfuo_MCU cortex-m3)
set(GENERIC_F103VDHX_dfuo_FPCONF "-")
add_library(GENERIC_F103VDHX_dfuo INTERFACE)
target_compile_options(GENERIC_F103VDHX_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VDHX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103VDHX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VDHX"
	"BOARD_NAME=\"GENERIC_F103VDHX\""
	"BOARD_ID=GENERIC_F103VDHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VDHX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VDHX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103VDHX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103VDHX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VDHX_dfuo_MCU}
)


# GENERIC_F103VDHX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103VDHX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VDHX_hid_MAXSIZE 393216)
set(GENERIC_F103VDHX_hid_MAXDATASIZE 65536)
set(GENERIC_F103VDHX_hid_MCU cortex-m3)
set(GENERIC_F103VDHX_hid_FPCONF "-")
add_library(GENERIC_F103VDHX_hid INTERFACE)
target_compile_options(GENERIC_F103VDHX_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VDHX_hid_MCU}
)
target_compile_definitions(GENERIC_F103VDHX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VDHX"
	"BOARD_NAME=\"GENERIC_F103VDHX\""
	"BOARD_ID=GENERIC_F103VDHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VDHX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VDHX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103VDHX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103VDHX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VDHX_hid_MCU}
)


# GENERIC_F103VDTX
# -----------------------------------------------------------------------------

set(GENERIC_F103VDTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VDTX_MAXSIZE 393216)
set(GENERIC_F103VDTX_MAXDATASIZE 65536)
set(GENERIC_F103VDTX_MCU cortex-m3)
set(GENERIC_F103VDTX_FPCONF "-")
add_library(GENERIC_F103VDTX INTERFACE)
target_compile_options(GENERIC_F103VDTX INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VDTX_MCU}
)
target_compile_definitions(GENERIC_F103VDTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VDTX"
	"BOARD_NAME=\"GENERIC_F103VDTX\""
	"BOARD_ID=GENERIC_F103VDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VDTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VDTX_VARIANT_PATH}
)

target_link_options(GENERIC_F103VDTX INTERFACE
  "LINKER:--default-script=${GENERIC_F103VDTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VDTX_MCU}
)

add_library(GENERIC_F103VDTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103VDTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VDTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103VDTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103VDTX_serial_none INTERFACE)
target_compile_options(GENERIC_F103VDTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103VDTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103VDTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103VDTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103VDTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103VDTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103VDTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103VDTX_usb_none INTERFACE)
target_compile_options(GENERIC_F103VDTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VDTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103VDTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VDTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103VDTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103VDTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103VDTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103VDTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103VDTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VDTX_dfu2_MAXSIZE 393216)
set(GENERIC_F103VDTX_dfu2_MAXDATASIZE 65536)
set(GENERIC_F103VDTX_dfu2_MCU cortex-m3)
set(GENERIC_F103VDTX_dfu2_FPCONF "-")
add_library(GENERIC_F103VDTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103VDTX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VDTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103VDTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VDTX"
	"BOARD_NAME=\"GENERIC_F103VDTX\""
	"BOARD_ID=GENERIC_F103VDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VDTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VDTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103VDTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103VDTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VDTX_dfu2_MCU}
)


# GENERIC_F103VDTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103VDTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VDTX_dfuo_MAXSIZE 393216)
set(GENERIC_F103VDTX_dfuo_MAXDATASIZE 65536)
set(GENERIC_F103VDTX_dfuo_MCU cortex-m3)
set(GENERIC_F103VDTX_dfuo_FPCONF "-")
add_library(GENERIC_F103VDTX_dfuo INTERFACE)
target_compile_options(GENERIC_F103VDTX_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VDTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103VDTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VDTX"
	"BOARD_NAME=\"GENERIC_F103VDTX\""
	"BOARD_ID=GENERIC_F103VDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VDTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VDTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103VDTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103VDTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VDTX_dfuo_MCU}
)


# GENERIC_F103VDTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103VDTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VDTX_hid_MAXSIZE 393216)
set(GENERIC_F103VDTX_hid_MAXDATASIZE 65536)
set(GENERIC_F103VDTX_hid_MCU cortex-m3)
set(GENERIC_F103VDTX_hid_FPCONF "-")
add_library(GENERIC_F103VDTX_hid INTERFACE)
target_compile_options(GENERIC_F103VDTX_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VDTX_hid_MCU}
)
target_compile_definitions(GENERIC_F103VDTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VDTX"
	"BOARD_NAME=\"GENERIC_F103VDTX\""
	"BOARD_ID=GENERIC_F103VDTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VDTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VDTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103VDTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103VDTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=393216"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VDTX_hid_MCU}
)


# GENERIC_F103VEHX
# -----------------------------------------------------------------------------

set(GENERIC_F103VEHX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VEHX_MAXSIZE 524288)
set(GENERIC_F103VEHX_MAXDATASIZE 65536)
set(GENERIC_F103VEHX_MCU cortex-m3)
set(GENERIC_F103VEHX_FPCONF "-")
add_library(GENERIC_F103VEHX INTERFACE)
target_compile_options(GENERIC_F103VEHX INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VEHX_MCU}
)
target_compile_definitions(GENERIC_F103VEHX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VEHX"
	"BOARD_NAME=\"GENERIC_F103VEHX\""
	"BOARD_ID=GENERIC_F103VEHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VEHX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VEHX_VARIANT_PATH}
)

target_link_options(GENERIC_F103VEHX INTERFACE
  "LINKER:--default-script=${GENERIC_F103VEHX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VEHX_MCU}
)

add_library(GENERIC_F103VEHX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103VEHX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VEHX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103VEHX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103VEHX_serial_none INTERFACE)
target_compile_options(GENERIC_F103VEHX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103VEHX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103VEHX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103VEHX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103VEHX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103VEHX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103VEHX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103VEHX_usb_none INTERFACE)
target_compile_options(GENERIC_F103VEHX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VEHX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103VEHX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VEHX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103VEHX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103VEHX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103VEHX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103VEHX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103VEHX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VEHX_dfu2_MAXSIZE 524288)
set(GENERIC_F103VEHX_dfu2_MAXDATASIZE 65536)
set(GENERIC_F103VEHX_dfu2_MCU cortex-m3)
set(GENERIC_F103VEHX_dfu2_FPCONF "-")
add_library(GENERIC_F103VEHX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103VEHX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VEHX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103VEHX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VEHX"
	"BOARD_NAME=\"GENERIC_F103VEHX\""
	"BOARD_ID=GENERIC_F103VEHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VEHX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VEHX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103VEHX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103VEHX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VEHX_dfu2_MCU}
)


# GENERIC_F103VEHX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103VEHX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VEHX_dfuo_MAXSIZE 524288)
set(GENERIC_F103VEHX_dfuo_MAXDATASIZE 65536)
set(GENERIC_F103VEHX_dfuo_MCU cortex-m3)
set(GENERIC_F103VEHX_dfuo_FPCONF "-")
add_library(GENERIC_F103VEHX_dfuo INTERFACE)
target_compile_options(GENERIC_F103VEHX_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VEHX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103VEHX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VEHX"
	"BOARD_NAME=\"GENERIC_F103VEHX\""
	"BOARD_ID=GENERIC_F103VEHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VEHX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VEHX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103VEHX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103VEHX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VEHX_dfuo_MCU}
)


# GENERIC_F103VEHX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103VEHX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VEHX_hid_MAXSIZE 524288)
set(GENERIC_F103VEHX_hid_MAXDATASIZE 65536)
set(GENERIC_F103VEHX_hid_MCU cortex-m3)
set(GENERIC_F103VEHX_hid_FPCONF "-")
add_library(GENERIC_F103VEHX_hid INTERFACE)
target_compile_options(GENERIC_F103VEHX_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VEHX_hid_MCU}
)
target_compile_definitions(GENERIC_F103VEHX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VEHX"
	"BOARD_NAME=\"GENERIC_F103VEHX\""
	"BOARD_ID=GENERIC_F103VEHX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VEHX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VEHX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103VEHX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103VEHX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VEHX_hid_MCU}
)


# GENERIC_F103VETX
# -----------------------------------------------------------------------------

set(GENERIC_F103VETX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VETX_MAXSIZE 524288)
set(GENERIC_F103VETX_MAXDATASIZE 65536)
set(GENERIC_F103VETX_MCU cortex-m3)
set(GENERIC_F103VETX_FPCONF "-")
add_library(GENERIC_F103VETX INTERFACE)
target_compile_options(GENERIC_F103VETX INTERFACE
  "SHELL:-DSTM32F103xE   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VETX_MCU}
)
target_compile_definitions(GENERIC_F103VETX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VETX"
	"BOARD_NAME=\"GENERIC_F103VETX\""
	"BOARD_ID=GENERIC_F103VETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VETX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VETX_VARIANT_PATH}
)

target_link_options(GENERIC_F103VETX INTERFACE
  "LINKER:--default-script=${GENERIC_F103VETX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VETX_MCU}
)

add_library(GENERIC_F103VETX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103VETX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VETX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103VETX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103VETX_serial_none INTERFACE)
target_compile_options(GENERIC_F103VETX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103VETX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103VETX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103VETX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103VETX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103VETX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103VETX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103VETX_usb_none INTERFACE)
target_compile_options(GENERIC_F103VETX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VETX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103VETX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VETX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103VETX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103VETX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103VETX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103VETX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103VETX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VETX_dfu2_MAXSIZE 524288)
set(GENERIC_F103VETX_dfu2_MAXDATASIZE 65536)
set(GENERIC_F103VETX_dfu2_MCU cortex-m3)
set(GENERIC_F103VETX_dfu2_FPCONF "-")
add_library(GENERIC_F103VETX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103VETX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VETX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103VETX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VETX"
	"BOARD_NAME=\"GENERIC_F103VETX\""
	"BOARD_ID=GENERIC_F103VETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VETX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VETX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103VETX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103VETX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VETX_dfu2_MCU}
)


# GENERIC_F103VETX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103VETX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VETX_dfuo_MAXSIZE 524288)
set(GENERIC_F103VETX_dfuo_MAXDATASIZE 65536)
set(GENERIC_F103VETX_dfuo_MCU cortex-m3)
set(GENERIC_F103VETX_dfuo_FPCONF "-")
add_library(GENERIC_F103VETX_dfuo INTERFACE)
target_compile_options(GENERIC_F103VETX_dfuo INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VETX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103VETX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VETX"
	"BOARD_NAME=\"GENERIC_F103VETX\""
	"BOARD_ID=GENERIC_F103VETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VETX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VETX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103VETX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103VETX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VETX_dfuo_MCU}
)


# GENERIC_F103VETX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103VETX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(C-D-E)(H-T)")
set(GENERIC_F103VETX_hid_MAXSIZE 524288)
set(GENERIC_F103VETX_hid_MAXDATASIZE 65536)
set(GENERIC_F103VETX_hid_MCU cortex-m3)
set(GENERIC_F103VETX_hid_FPCONF "-")
add_library(GENERIC_F103VETX_hid INTERFACE)
target_compile_options(GENERIC_F103VETX_hid INTERFACE
  "SHELL:-DSTM32F103xE  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VETX_hid_MCU}
)
target_compile_definitions(GENERIC_F103VETX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VETX"
	"BOARD_NAME=\"GENERIC_F103VETX\""
	"BOARD_ID=GENERIC_F103VETX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VETX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VETX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103VETX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103VETX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=524288"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=65536"
  "SHELL: "
  -mcpu=${GENERIC_F103VETX_hid_MCU}
)


# GENERIC_F103VFTX
# -----------------------------------------------------------------------------

set(GENERIC_F103VFTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(F-G)T")
set(GENERIC_F103VFTX_MAXSIZE 786432)
set(GENERIC_F103VFTX_MAXDATASIZE 98304)
set(GENERIC_F103VFTX_MCU cortex-m3)
set(GENERIC_F103VFTX_FPCONF "-")
add_library(GENERIC_F103VFTX INTERFACE)
target_compile_options(GENERIC_F103VFTX INTERFACE
  "SHELL:-DSTM32F103xG   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VFTX_MCU}
)
target_compile_definitions(GENERIC_F103VFTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VFTX"
	"BOARD_NAME=\"GENERIC_F103VFTX\""
	"BOARD_ID=GENERIC_F103VFTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VFTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VFTX_VARIANT_PATH}
)

target_link_options(GENERIC_F103VFTX INTERFACE
  "LINKER:--default-script=${GENERIC_F103VFTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=786432"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103VFTX_MCU}
)

add_library(GENERIC_F103VFTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103VFTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VFTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103VFTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103VFTX_serial_none INTERFACE)
target_compile_options(GENERIC_F103VFTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103VFTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103VFTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103VFTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103VFTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103VFTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103VFTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103VFTX_usb_none INTERFACE)
target_compile_options(GENERIC_F103VFTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VFTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103VFTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VFTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103VFTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103VFTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103VFTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103VFTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103VFTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(F-G)T")
set(GENERIC_F103VFTX_dfu2_MAXSIZE 786432)
set(GENERIC_F103VFTX_dfu2_MAXDATASIZE 98304)
set(GENERIC_F103VFTX_dfu2_MCU cortex-m3)
set(GENERIC_F103VFTX_dfu2_FPCONF "-")
add_library(GENERIC_F103VFTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103VFTX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xG  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VFTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103VFTX_dfu2 INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VFTX"
	"BOARD_NAME=\"GENERIC_F103VFTX\""
	"BOARD_ID=GENERIC_F103VFTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VFTX_dfu2 INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VFTX_dfu2_VARIANT_PATH}
)

target_link_options(GENERIC_F103VFTX_dfu2 INTERFACE
  "LINKER:--default-script=${GENERIC_F103VFTX_dfu2_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x2000"
	"LINKER:--defsym=LD_MAX_SIZE=786432"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103VFTX_dfu2_MCU}
)


# GENERIC_F103VFTX_dfuo
# -----------------------------------------------------------------------------

set(GENERIC_F103VFTX_dfuo_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(F-G)T")
set(GENERIC_F103VFTX_dfuo_MAXSIZE 786432)
set(GENERIC_F103VFTX_dfuo_MAXDATASIZE 98304)
set(GENERIC_F103VFTX_dfuo_MCU cortex-m3)
set(GENERIC_F103VFTX_dfuo_FPCONF "-")
add_library(GENERIC_F103VFTX_dfuo INTERFACE)
target_compile_options(GENERIC_F103VFTX_dfuo INTERFACE
  "SHELL:-DSTM32F103xG  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VFTX_dfuo_MCU}
)
target_compile_definitions(GENERIC_F103VFTX_dfuo INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VFTX"
	"BOARD_NAME=\"GENERIC_F103VFTX\""
	"BOARD_ID=GENERIC_F103VFTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VFTX_dfuo INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VFTX_dfuo_VARIANT_PATH}
)

target_link_options(GENERIC_F103VFTX_dfuo INTERFACE
  "LINKER:--default-script=${GENERIC_F103VFTX_dfuo_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x5000"
	"LINKER:--defsym=LD_MAX_SIZE=786432"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103VFTX_dfuo_MCU}
)


# GENERIC_F103VFTX_hid
# -----------------------------------------------------------------------------

set(GENERIC_F103VFTX_hid_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(F-G)T")
set(GENERIC_F103VFTX_hid_MAXSIZE 786432)
set(GENERIC_F103VFTX_hid_MAXDATASIZE 98304)
set(GENERIC_F103VFTX_hid_MCU cortex-m3)
set(GENERIC_F103VFTX_hid_FPCONF "-")
add_library(GENERIC_F103VFTX_hid INTERFACE)
target_compile_options(GENERIC_F103VFTX_hid INTERFACE
  "SHELL:-DSTM32F103xG  -DHAL_UART_MODULE_ENABLED -DBL_HID"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VFTX_hid_MCU}
)
target_compile_definitions(GENERIC_F103VFTX_hid INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VFTX"
	"BOARD_NAME=\"GENERIC_F103VFTX\""
	"BOARD_ID=GENERIC_F103VFTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VFTX_hid INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VFTX_hid_VARIANT_PATH}
)

target_link_options(GENERIC_F103VFTX_hid INTERFACE
  "LINKER:--default-script=${GENERIC_F103VFTX_hid_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x800"
	"LINKER:--defsym=LD_MAX_SIZE=786432"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103VFTX_hid_MCU}
)


# GENERIC_F103VGTX
# -----------------------------------------------------------------------------

set(GENERIC_F103VGTX_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(F-G)T")
set(GENERIC_F103VGTX_MAXSIZE 1048576)
set(GENERIC_F103VGTX_MAXDATASIZE 98304)
set(GENERIC_F103VGTX_MCU cortex-m3)
set(GENERIC_F103VGTX_FPCONF "-")
add_library(GENERIC_F103VGTX INTERFACE)
target_compile_options(GENERIC_F103VGTX INTERFACE
  "SHELL:-DSTM32F103xG   "
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VGTX_MCU}
)
target_compile_definitions(GENERIC_F103VGTX INTERFACE
  "STM32F1xx"
	"ARDUINO_GENERIC_F103VGTX"
	"BOARD_NAME=\"GENERIC_F103VGTX\""
	"BOARD_ID=GENERIC_F103VGTX"
	"VARIANT_H=\"variant_generic.h\""
)
target_include_directories(GENERIC_F103VGTX INTERFACE
  ${CMAKE_CURRENT_LIST_DIR}/../system/STM32F1xx
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Inc
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/STM32F1xx_HAL_Driver/Src
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Include/
  ${CMAKE_CURRENT_LIST_DIR}/../system/Drivers/CMSIS/Device/ST/STM32F1xx/Source/Templates/gcc/
  ${GENERIC_F103VGTX_VARIANT_PATH}
)

target_link_options(GENERIC_F103VGTX INTERFACE
  "LINKER:--default-script=${GENERIC_F103VGTX_VARIANT_PATH}/ldscript.ld"
  "LINKER:--defsym=LD_FLASH_OFFSET=0x0"
	"LINKER:--defsym=LD_MAX_SIZE=1048576"
	"LINKER:--defsym=LD_MAX_DATA_SIZE=98304"
  "SHELL: "
  -mcpu=${GENERIC_F103VGTX_MCU}
)

add_library(GENERIC_F103VGTX_serial_disabled INTERFACE)
target_compile_options(GENERIC_F103VGTX_serial_disabled INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VGTX_serial_generic INTERFACE)
target_compile_options(GENERIC_F103VGTX_serial_generic INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED"
)
add_library(GENERIC_F103VGTX_serial_none INTERFACE)
target_compile_options(GENERIC_F103VGTX_serial_none INTERFACE
  "SHELL:-DHAL_UART_MODULE_ENABLED -DHWSERIAL_NONE"
)
add_library(GENERIC_F103VGTX_usb_CDC INTERFACE)
target_compile_options(GENERIC_F103VGTX_usb_CDC INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC -DDISABLE_GENERIC_SERIALUSB"
)
add_library(GENERIC_F103VGTX_usb_CDCgen INTERFACE)
target_compile_options(GENERIC_F103VGTX_usb_CDCgen INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_CDC"
)
add_library(GENERIC_F103VGTX_usb_HID INTERFACE)
target_compile_options(GENERIC_F103VGTX_usb_HID INTERFACE
  "SHELL:-DUSBCON  -DUSBD_VID=0 -DUSBD_PID=0 -DHAL_PCD_MODULE_ENABLED -DUSBD_USE_HID_COMPOSITE"
)
add_library(GENERIC_F103VGTX_usb_none INTERFACE)
target_compile_options(GENERIC_F103VGTX_usb_none INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VGTX_xusb_FS INTERFACE)
target_compile_options(GENERIC_F103VGTX_xusb_FS INTERFACE
  "SHELL:"
)
add_library(GENERIC_F103VGTX_xusb_HS INTERFACE)
target_compile_options(GENERIC_F103VGTX_xusb_HS INTERFACE
  "SHELL:-DUSE_USB_HS"
)
add_library(GENERIC_F103VGTX_xusb_HSFS INTERFACE)
target_compile_options(GENERIC_F103VGTX_xusb_HSFS INTERFACE
  "SHELL:-DUSE_USB_HS -DUSE_USB_HS_IN_FS"
)

# GENERIC_F103VGTX_dfu2
# -----------------------------------------------------------------------------

set(GENERIC_F103VGTX_dfu2_VARIANT_PATH "${CMAKE_CURRENT_LIST_DIR}/../variants/STM32F1xx/F103V(F-G)T")
set(GENERIC_F103VGTX_dfu2_MAXSIZE 1048576)
set(GENERIC_F103VGTX_dfu2_MAXDATASIZE 98304)
set(GENERIC_F103VGTX_dfu2_MCU cortex-m3)
set(GENERIC_F103VGTX_dfu2_FPCONF "-")
add_library(GENERIC_F103VGTX_dfu2 INTERFACE)
target_compile_options(GENERIC_F103VGTX_dfu2 INTERFACE
  "SHELL:-DSTM32F103xG  -DHAL_UART_MODULE_ENABLED -DBL_LEGACY_LEAF"
  "SHELL:"
  "SHELL:"
  "SHELL: "
  -mcpu=${GENERIC_F103VGTX_dfu2_MCU}
)
target_compile_definitions(GENERIC_F103VGTX_dfu2 INTERFACE
  "STM32