---
title: Greenplum Database Best Practices 
---

A best practice is a method or technique that has consistently shown results superior to those achieved with other means. Best practices are found through experience and are proven to reliably lead to a desired result. Best practices are a commitment to use any product correctly and optimally, by leveraging all the knowledge and expertise available to ensure success.

This document does not teach you how to use Greenplum Database features. Links are provided to other relevant parts of the Greenplum Database documentation for information on how to use and implement specific Greenplum Database features. This document addresses the most important best practices to follow when designing, implementing, and using Greenplum Database.

It is not the intent of this document to cover the entire product or compendium of features, but rather to provide a summary of *what matters most* in Greenplum Database. This document does not address *edge* use cases. While edge use cases can further leverage and benefit from Greenplum Database features, they require a proficient knowledge and expertise with these features, as well as a deep understanding of your environment, including SQL access, query execution, concurrency, workload, and other factors.

By following these best practices, you will increase the success of your Greenplum Database clusters in the areas of maintenance, support, performance, and scalability.

-   **[Best Practices Summary](summary.html)**  
A summary of best practices for Greenplum Database.
-   **[System Configuration](sysconfig.html)**  
Requirements and best practices for system administrators who are configuring Greenplum Database cluster hosts.
-   **[Schema Design](schema.html)**  
Best practices for designing Greenplum Database schemas.
-   **[Memory and Resource Management with Resource Groups](resgroups.html)**  
Managing Greenplum Database resources with resource groups.
-   **[Memory and Resource Management with Resource Queues](workloads.html)**  
Avoid memory errors and manage Greenplum Database resources.
-   **[System Monitoring and Maintenance](maintenance.html)**  
Best practices for regular maintenance that will ensure Greenplum Database high availability and optimal performance.
-   **[Loading Data](data_loading.html)**  
Description of the different ways to add data to Greenplum Database.
-   **[Security](security.html)**  
Best practices to ensure the highest level of system security. 
-   **[Encrypting Data and Database Connections](encryption.html)**  
Best practices for implementing encryption and managing keys.
-   **[Tuning SQL Queries](tuning_queries.html)**  
The Greenplum Database cost-based optimizer evaluates many strategies for running a query and chooses the least costly method.
-   **[High Availability](ha.html)**  
Greenplum Database supports highly available, fault-tolerant database services when you enable and properly configure Greenplum high availability features. To guarantee a required level of service, each component must have a standby ready to take its place if it should fail.

