---
title: Managing Spill Files Generated by Queries 
---

Greenplum Database creates spill files, also known as workfiles, on disk if it does not have sufficient memory to run an SQL query in memory.

The maximum number of spill files for a given query is governed by the [gp\_workfile\_limit\_files\_per\_query](../../../ref_guide/config_params/guc-list.html) server configuration parameter setting. The default value of 100,000 spill files is sufficient for the majority of queries.

If a query creates more than the configured number of spill files, Greenplum Database returns this error:

```
ERROR: number of workfiles per query limit exceeded
```

Greenplum Database may generate a large number of spill files when:

-   Data skew is present in the queried data. To check for data skew, see [Checking for Data Distribution Skew](../../managing/monitor.html).
-   The amount of memory allocated for the query is too low. You control the maximum amount of memory that can be used by a query with the Greenplum Database server configuration parameters [max\_statement\_mem](../../../ref_guide/config_params/guc-list.html) and [statement\_mem](../../../ref_guide/config_params/guc-list.html), or through resource group or resource queue configuration.

You might be able to run the query successfully by changing the query, changing the data distribution, or changing the system memory configuration. The `gp_toolkit` *gp\_workfile\_\** views display spill file usage information. You can use this information to troubleshoot and tune queries. The *gp\_workfile\_\** views are described in [Checking Query Disk Spill Space Usage](../../../ref_guide/gp_toolkit.html).

Additional documentation resources:

-   [Memory Consumption Parameters](../../../ref_guide/config_params/guc_category-list.html) identifies the memory-related spill file server configuration parameters.
-   [Using Resource Groups](../../workload_mgmt_resgroups.html) describes memory and spill considerations when resource group-based resource management is active.
-   [Using Resource Queues](../../workload_mgmt.html) describes memory and spill considerations when resource queue-based resource management is active.

**Parent topic:** [Querying Data](../../query/topics/query.html)

