---
title: Greenplum Database Administrator Guide 
---

Information about configuring, managing and monitoring Greenplum Database installations, and administering, monitoring, and working with databases. The guide also contains information about Greenplum Database architecture and concepts such as parallel processing.

-   **[Greenplum Database Concepts](intro/partI.html)**  
This section provides an overview of Greenplum Database components and features such as high availability, parallel data loading features, and management utilities.
-   **[Managing a Greenplum System](managing/partII.html)**  
This section describes basic system administration tasks performed by a Greenplum Database system administrator.
-   **[Managing Greenplum Database Access](partIII.html)**  
Securing Greenplum Database includes protecting access to the database through network configuration, database user authentication, and encryption.
-   **[Defining Database Objects](ddl/ddl.html)**  
This section covers data definition language \(DDL\) in Greenplum Database and how to create and manage database objects.
-   **[Distribution and Skew](distribution.html)**  
Greenplum Database relies on even distribution of data across segments.
-   **[Inserting, Updating, and Deleting Data](dml.html)**  
This section provides information about manipulating data and concurrent access in Greenplum Database.
-   **[Querying Data](query/topics/query.html)**  
This topic provides information about using SQL in Greenplum databases.
-   **[Working with External Data](external/g-working-with-file-based-ext-tables.html)**  
Both external and foreign tables provide access to data stored in data sources outside of Greenplum Database as if the data were stored in regular database tables. You can read data from and write data to external and foreign tables.
-   **[Loading and Unloading Data](load/topics/g-loading-and-unloading-data.html)**  
The topics in this section describe methods for loading and writing data into and out of a Greenplum Database, and how to format data files.
-   **[Managing Performance](partV.html)**  
The topics in this section cover Greenplum Database performance management, including how to monitor performance and how to configure workloads to prioritize resource utilization.

