---
title: Troubleshooting Connection Problems 
---

A number of things can prevent a client application from successfully connecting to Greenplum Database. This topic explains some of the common causes of connection problems and how to correct them.

| Problem | Solution |
| ------- | -------- |
| No `pg_hba.conf` entry for host or user | To enable Greenplum Database to accept remote client connections, you must configure your Greenplum Database coordinator instance so that connections are allowed from the client hosts and database users that will be connecting to Greenplum Database. This is done by adding the appropriate entries to the `pg_hba.conf` configuration file (located in the coordinator instance's data directory). For more detailed information, see [Allowing Connections to Greenplum Database](../../client_auth.html#topic2). |
| Greenplum Database is not running | If the Greenplum Database coordinator instance is down, users will not be able to connect. You can verify that the Greenplum Database system is up by running the `gpstate` utility on the Greenplum coordinator host. |
| Network problems<p class="p">Interconnect timeouts | If users connect to the Greenplum coordinator host from a remote client, network problems can prevent a connection (for example, DNS host name resolution problems, the host system is down, and so on.). To ensure that network problems are not the cause, connect to the Greenplum coordinator host from the remote client host. For example: `ping hostname`<br/><br/>If the system cannot resolve the host names and IP addresses of the hosts involved in Greenplum Database, queries and connections will fail. For some operations, connections to the Greenplum Database coordinator use `localhost` and others use the actual host name, so you must be able to resolve both. If you encounter this error, first make sure you can connect to each host in your Greenplum Database array from the coordinator host over the network. In the `/etc/hosts` file of the coordinator and all segments, make sure you have the correct host names and IP addresses for all hosts involved in the Greenplum Database array. The `127.0.0.1` IP must resolve to `localhost`. |
| Too many clients already | By default, Greenplum Database is configured to allow a maximum of 250 concurrent user connections on the coordinator and 750 on a segment. A connection attempt that causes that limit to be exceeded will be refused. This limit is controlled by the `max_connections` parameter in the `postgresql.conf` configuration file of the Greenplum Database coordinator. If you change this setting for the coordinator, you must also make appropriate changes at the segments. |
        
**Parent topic:** [Accessing the Database](../../access_db/topics/g-accessing-the-database.html)