# psql 

Interactive command-line interface for Greenplum Database

## <a id="section2"></a>Synopsis 

``` {#client_util_synopsis}
psql [<option> ...] [<dbname> [<username>]]
```

## <a id="section3"></a>Description 

`psql` is a terminal-based front-end to Greenplum Database. It enables you to type in queries interactively, issue them to Greenplum Database, and see the query results. Alternatively, input can be from a file. In addition, it provides a number of meta-commands and various shell-like features to facilitate writing scripts and automating a wide variety of tasks.

## <a id="section4"></a>Options 

-a \| --echo-all
:   Print all nonempty input lines to standard output as they are read. \(This does not apply to lines read interactively.\) This is equivalent to setting the variable ECHO to `all`.

-A \| --no-align
:   Switches to unaligned output mode. \(The default output mode is aligned.\)

-c 'command' \| --command='command'
:   Specifies that `psql` is to run the specified command string, and then exit. This is useful in shell scripts. command must be either a command string that is completely parseable by the server, or a single backslash command. Thus you cannot mix SQL and `psql` meta-commands with this option. To achieve that, you could pipe the string into `psql`, like this:

    ```
    echo '\x \\ SELECT * FROM foo;' | psql
    ```

:   \(`\\` is the separator meta-command.\)

:   If the command string contains multiple SQL commands, they are processed in a single transaction, unless there are explicit `BEGIN/COMMIT` commands included in the string to divide it into multiple transactions. This is different from the behavior when the same string is fed to `psql`'s standard input. Also, only the result of the last SQL command is returned.

-d dbname \| --dbname=dbname
:   Specifies the name of the database to connect to. This is equivalent to specifying dbname as the first non-option argument on the command line.

:   If this parameter contains an `=` sign or starts with a valid URI prefix \(`postgresql://` or `postgres://`\), it is treated as a `conninfo` string. See [Connection Strings](https://www.postgresql.org/docs/12/libpq-connect.html#LIBPQ-CONNSTRING) in the PostgreSQL documentation for more information.

-e \| --echo-queries
:   Copy all SQL commands sent to the server to standard output as well.

-E \| --echo-hidden
:   Echo the actual queries generated by `\d` and other backslash commands. You can use this to study `psql`'s internal operations. This is equivalent to setting the variable ECHO\_HIDDEN to `on`.

-f filename \| --file=filename
:   Use the file filename as the source of commands instead of reading commands interactively. After the file is processed, `psql` terminates. This is in many ways equivalent to the meta-command `\i`.

:   If filename is `-` \(hyphen\), then standard input is read until an EOF indication or `\q` meta-command. Note however that Readline is not used in this case \(much as if `-n` had been specified\).

:   Using this option is subtly different from writing `psql < <filename>`. In general, both will do what you expect, but using `-f` enables some nice features such as error messages with line numbers. There is also a slight chance that using this option will reduce the start-up overhead. On the other hand, the variant using the shell's input redirection is \(in theory\) guaranteed to yield exactly the same output you would have received had you entered everything by hand.

-F separator \| --field-separator=separator
:   Use the specified separator as the field separator for unaligned output.

-H \| --html
:   Turn on HTML tabular output.

-l \| --list
:   List all available databases, then exit. Other non-connection options are ignored.

-L filename \| --log-file=filename
:   Write all query output into the specified log file, in addition to the normal output destination.

-n \| --no-readline
:   Do not use Readline for line editing and do not use the command history. This can be useful to turn off tab expansion when cutting and pasting.

-o filename \| --output=filename
:   Put all query output into the specified file.

-P assignment \| --pset=assignment
:   Allows you to specify printing options in the style of `\pset` on the command line. Note that here you have to separate name and value with an equal sign instead of a space. Thus to set the output format to `LaTeX`, you could write `-P format=latex`.

-q \| --quiet
:   Specifies that `psql` should do its work quietly. By default, it prints welcome messages and various informational output. If this option is used, none of this happens. This is useful with the `-c` option. This is equivalent to setting the variable QUIET to `on`.

-R separator \| --record-separator=separator
:   Use separator as the record separator for unaligned output.

-s \| --single-step
:   Run in single-step mode. That means the user is prompted before each command is sent to the server, with the option to cancel execution as well. Use this to debug scripts.

-S \| --single-line
:   Runs in single-line mode where a new line terminates an SQL command, as a semicolon does.

-t \| --tuples-only
:   Turn off printing of column names and result row count footers, etc. This command is equivalent to `\pset tuples_only` and is provided for convenience.

-T table\_options \| --table-attr= table\_options
:   Allows you to specify options to be placed within the HTML table tag. See `\pset` for details.

-v assignment \| --set=assignment \| --variable= assignment
:   Perform a variable assignment, like the `\set` meta command. Note that you must separate name and value, if any, by an equal sign on the command line. To unset a variable, leave off the equal sign. To set a variable with an empty value, use the equal sign but leave off the value. These assignments are done during a very early stage of start-up, so variables reserved for internal purposes might get overwritten later.

-V \| --version
:   Print the `psql` version and exit.

-x \| --expanded
:   Turn on the expanded table formatting mode.

-X \| --no-psqlrc
:   Do not read the start-up file \(neither the system-wide `psqlrc` file nor the user's `~/.psqlrc` file\).

-z \| --field-separator-zero
:   Set the field separator for unaligned output to a zero byte.

-0 \| --record-separator-zero
:   Set the record separator for unaligned output to a zero byte. This is useful for interfacing, for example, with `xargs -0`.

-1 \| --single-transaction
:   When `psql` runs a script, adding this option wraps `BEGIN`/`COMMIT` around the script to run it as a single transaction. This ensures that either all the commands complete successfully, or no changes are applied.

:   If the script itself uses `BEGIN`, `COMMIT`, or `ROLLBACK`, this option will not have the desired effects. Also, if the script contains any command that cannot be run inside a transaction block, specifying this option will cause that command \(and hence the whole transaction\) to fail.

-? \| --help
:   Show help about `psql` command line arguments, and exit.

**Connection Options**

-h host \| --host=host
:   The host name of the machine on which the Greenplum coordinator database server is running. If not specified, reads from the environment variable `PGHOST` or defaults to localhost.

:   When starting `psql` on the coordinator host, if the host value begins with a slash, it is used as the directory for the UNIX-domain socket.

-p port \| --port=port
:   The TCP port on which the Greenplum coordinator database server is listening for connections. If not specified, reads from the environment variable `PGPORT` or defaults to 5432.

-U username \| --username=username
:   The database role name to connect as. If not specified, reads from the environment variable `PGUSER` or defaults to the current system role name.

-W \| --password
:   Force a password prompt. `psql` should automatically prompt for a password whenever the server requests password authentication. However, currently password request detection is not totally reliable, hence this option to force a prompt. If no password prompt is issued and the server requires password authentication, the connection attempt will fail.

-w --no-password
:   Never issue a password prompt. If the server requires password authentication and a password is not available by other means such as a .pgpass file, the connection attempt will fail. This option can be useful in batch jobs and scripts where no user is present to enter a password.

:   > **Note** This option remains set for the entire session, and so it affects uses of the meta-command `\connect` as well as the initial connection attempt.

## <a id="section6"></a>Exit Status 

`psql` returns 0 to the shell if it finished normally, 1 if a fatal error of its own \(out of memory, file not found\) occurs, 2 if the connection to the server went bad and the session was not interactive, and 3 if an error occurred in a script and the variable `ON_ERROR_STOP` was set.

## <a id="section7"></a>Usage 

**Connecting to a Database**

`psql` is a client application for Greenplum Database. In order to connect to a database you need to know the name of your target database, the host name and port number of the Greenplum coordinator server and what database user name you want to connect as. `psql` can be told about those parameters via command line options, namely `-d`, `-h`, `-p`, and `-U` respectively. If an argument is found that does not belong to any option it will be interpreted as the database name \(or the user name, if the database name is already given\). Not all of these options are required; there are useful defaults. If you omit the host name, `psql` will connect via a UNIX-domain socket to a coordinator server on the local host, or via TCP/IP to `localhost` on machines that do not have UNIX-domain sockets. The default coordinator port number is 5432. If you use a different port for the coordinator, you must specify the port. The default database user name is your operating-system user name, as is the default database name. Note that you cannot just connect to any database under any user name. Your database administrator should have informed you about your access rights.

When the defaults are not right, you can save yourself some typing by setting any or all of the environment variables `PGAPPNAME`, `PGDATABASE`, `PGHOST`, `PGPORT`, and `PGUSER` to appropriate values.

It is also convenient to have a `~/.pgpass` file to avoid regularly having to type in passwords. This file should reside in your home directory and contain lines of the following format:

```
<hostname>:<port>:<database>:<username>:<password>
```

The permissions on `.pgpass` must disallow any access to world or group \(for example: `chmod 0600 ~/.pgpass`\). If the permissions are less strict than this, the file will be ignored. \(The file permissions are not currently checked on Microsoft Windows clients, however.\)

An alternative way to specify connection parameters is in a `conninfo` string or a URI, which is used instead of a database name. This mechanism gives you very wide control over the connection. For example:

```
$ psql "service=myservice sslmode=require"
$ psql postgresql://gpcoordinator:5433/mydb?sslmode=require
```

This way you can also use LDAP for connection parameter lookup as described in [LDAP Lookup of Connection Parameters](https://www.postgresql.org/docs/12/libpq-ldap.html) in the PostgreSQL documentation. See [Parameter Keywords](https://www.postgresql.org/docs/12/libpq-connect.html#LIBPQ-PARAMKEYWORDS) in the PostgreSQL documentation for more information on all the available connection options.

If the connection could not be made for any reason \(insufficient privileges, server is not running, etc.\), `psql` will return an error and terminate.

If at least one of standard input or standard output are a terminal, then `psql` sets the client encoding to `auto`, which will detect the appropriate client encoding from the locale settings \(`LC_CTYPE` environment variable on Unix systems\). If this doesn't work out as expected, the client encoding can be overridden using the environment variable `PGCLIENTENCODING`.

**Entering SQL Commands**

In normal operation, `psql` provides a prompt with the name of the database to which `psql` is currently connected, followed by the string **=\>** for a regular user or **=\#** for a superuser. For example:

```
testdb=>
testdb=#
```

At the prompt, the user may type in SQL commands. Ordinarily, input lines are sent to the server when a command-terminating semicolon is reached. An end of line does not terminate a command. Thus commands can be spread over several lines for clarity. If the command was sent and run without error, the results of the command are displayed on the screen.

If untrusted users have access to a database that has not adopted a [secure schema usage pattern](https://www.postgresql.org/docs/12/ddl-schemas.html#DDL-SCHEMAS-PATTERNS), begin your session by removing publicly-writable schemas from search\_path. You can add `options=-csearch_path=` to the connection string or issue `SELECT pg_catalog.set_config('search_path', '', false)` before other SQL commands. This consideration is not specific to `psql`; it applies to every interface for running arbitrary SQL commands.

## <a id="section10"></a>Meta-Commands 

Anything you enter in `psql` that begins with an unquoted backslash is a `psql` meta-command that is processed by `psql` itself. These commands help make `psql` more useful for administration or scripting. Meta-commands are more commonly called slash or backslash commands.

The format of a `psql` command is the backslash, followed immediately by a command verb, then any arguments. The arguments are separated from the command verb and each other by any number of whitespace characters.

To include whitespace into an argument you may quote it with single quotes. To include a single quote into such an argument, write two single quotes within single-quoted text. Anything contained in single quotes is furthermore subject to C-like substitutions for `\n` \(new line\), `\t` \(tab\), `\b` \(backspace\), `\r` \(carriage return\), `\f` \(form feed\), `\digits` \(octal\), and `\xdigits` \(hexadecimal\). A backslash preceding any other character within single-quoted text quotes that single character, whatever it is.

Within an argument, text that is enclosed in backquotes \(```\) is taken as a command line that is passed to the shell. The output of the command \(with any trailing newline removed\) replaces the backquoted text.

If an unquoted colon \(`:`\) followed by a `psql` variable name appears within an argument, it is replaced by the variable's value, as described in [SQL Interpolation](#section14).

Some commands take an SQL identifier \(such as a table name\) as argument. These arguments follow the syntax rules of SQL: Unquoted letters are forced to lowercase, while double quotes \(`"`\) protect letters from case conversion and allow incorporation of whitespace into the identifier. Within double quotes, paired double quotes reduce to a single double quote in the resulting name. For example, `FOO"BAR"BAZ` is interpreted as `fooBARbaz`, and `"A weird"" name"` becomes `A weird" name`.

Parsing for arguments stops when another unquoted backslash occurs. This is taken as the beginning of a new meta-command. The special sequence `\\` \(two backslashes\) marks the end of arguments and continues parsing SQL commands, if any. That way SQL and `psql` commands can be freely mixed on a line. But in any case, the arguments of a meta-command cannot continue beyond the end of the line.

The following meta-commands are defined:

\\a
:   If the current table output format is unaligned, it is switched to aligned. If it is not unaligned, it is set to unaligned. This command is kept for backwards compatibility. See `\pset` for a more general solution.

\\c \| \\connect \[dbname \[username\] \[host\] \[port\]\] \| conninfo
:   Establishes a new Greenplum Database connection. The connection parameters to use can be specified either using a positional syntax, or using `conninfo` connection strings as detailed in [libpq Connection Strings](https://www.postgresql.org/docs/12/libpq-connect.html#LIBPQ-CONNSTRING).

:   Where the command omits database name, user, host, or port, the new connection can reuse values from the previous connection. By default, values from the previous connection are reused except when processing a `conninfo` string. Passing a first argument of `-reuse-previous=on` or `-reuse-previous=off` overrides that default. When the command neither specifies nor reuses a particular parameter, the `libpq` default is used. Specifying any of dbname, username, host or port as `-` is equivalent to omitting that parameter.

:   If the new connection is successfully made, the previous connection is closed. If the connection attempt failed, the previous connection will only be kept if `psql` is in interactive mode. When running a non-interactive script, processing will immediately stop with an error. This distinction was chosen as a user convenience against typos, and a safety mechanism that scripts are not accidentally acting on the wrong database.

:   Examples:

    ```
    => \c mydb myuser host.dom 6432
    => \c service=foo
    => \c "host=localhost port=5432 dbname=mydb connect_timeout=10 sslmode=disable"
    => \c postgresql://tom@localhost/mydb?application_name=myapp
    ```

\\C \[title\]
:   Sets the title of any tables being printed as the result of a query or unset any such title. This command is equivalent to `\pset title`.

\\cd \[directory\]
:   Changes the current working directory. Without argument, changes to the current user's home directory. To print your current working directory, use `\!pwd`.

\\conninfo
:   Displays information about the current connection including the database name, the user name, the type of connection \(UNIX domain socket, `TCP/IP`, etc.\), the host, and the port.

\\copy \{table \[\(column\_list\)\] \| \(query\)\} \{from \| to\} \{'filename' \| program 'command' \| stdin \| stdout \| pstdin \| pstdout\} \[with\] \(option \[, ...\]\) \]
:   Performs a frontend \(client\) copy. This is an operation that runs an SQL `[COPY](../../ref_guide/sql_commands/COPY.html)` command, but instead of the server reading or writing the specified file, `psql` reads or writes the file and routes the data between the server and the local file system. This means that file accessibility and privileges are those of the local user, not the server, and no SQL superuser privileges are required.

:   When `program` is specified, command is run by `psql` and the data from or to command is routed between the server and the client. This means that the execution privileges are those of the local user, not the server, and no SQL superuser privileges are required.

:   `\copy ... from stdin | to stdout` reads/writes based on the command input and output respectively. All rows are read from the same source that issued the command, continuing until `\.` is read or the stream reaches `EOF`. Output is sent to the same place as command output. To read/write from `psql`'s standard input or output, use `pstdin` or `pstdout`. This option is useful for populating tables in-line within a SQL script file.

:   The syntax of the command is similar to that of the SQL [COPY](../../ref_guide/sql_commands/COPY.html) command, and option must indicate one of the options of the SQL `COPY` command. Note that, because of this, special parsing rules apply to the `\copy` command. In particular, the variable substitution rules and backslash escapes do not apply.

:   This operation is not as efficient as the SQL `COPY` command because all data must pass through the client/server connection.

\\copyright
:   Shows the copyright and distribution terms of PostgreSQL on which Greenplum Database is based.

\\d \[relation\_pattern\]  \| \\d+ \[relation\_pattern\] \| \\dS \[relation\_pattern\]
:   For each relation \(table, external table, view, materialized view, index, sequence, or foreign table\) or composite type matching the relation pattern, show all columns, their types, the tablespace \(if not the default\) and any special attributes such as `NOT NULL` or defaults. Associated indexes, constraints, rules, and triggers are also shown. For foreign tables, the associated foreign server is shown as well.

    -   For some types of relation, `\d` shows additional information for each column: column values for sequences, indexed expressions for indexes, and foreign data wrapper options for foreign tables.
    -   The command form `\d+` is identical, except that more information is displayed: any comments associated with the columns of the table are shown, as is the presence of OIDs in the table, the view definition if the relation is a view.
        <br/><br/>For partitioned tables, the command `\d` or `\d+` specified with the root partitioned table or a child table displays information about the table including partition keys on the current level of the partitioned table. The command `\d+` also displays the immediate child partitions of the table and whether the partition is an external table or regular table.
        <br/><br/>For append-optimized tables and column-oriented tables, `\d+` displays the storage options for a table. For append-optimized tables, the options are displayed for the table. For column-oriented tables, storage options are displayed for each column.

    -   By default, only user-created objects are shown; supply a pattern or the `S` modifier to include system objects.
        <br/><br/>> **Note** If `\d` is used without a pattern argument, it is equivalent to `\dtvmsE` which will show a list of all visible tables, views, materialized views, sequences, and foreign tables.


\\da\[S\] \[aggregate\_pattern\]
:   Lists aggregate functions, together with the data types they operate on. If a pattern is specified, only aggregates whose names match the pattern are shown. By default, only user-created objects are shown; supply a pattern or the `S` modifier to include system objects.

\\db\[+\] \[tablespace\_pattern\]
:   Lists all available tablespaces and their corresponding paths. If pattern is specified, only tablespaces whose names match the pattern are shown. If + is appended to the command name, each object is listed with its associated permissions.

\\dc\[S+\] \[conversion\_pattern\]
:   Lists conversions between character-set encodings. If a pattern is specified, only conversions whose names match the pattern are listed. By default, only user-created objects are shown; supply a pattern or the `S` modifier to include system objects. If `+` is appended to the command name, each object is listed with its associated description.

\\dC\[+\] \[pattern\]
:   Lists type casts. If a pattern is specified, only casts whose source or target types match the pattern are listed. If `+` is appended to the command name, each object is listed with its associated description.

\\dd\[S\] \[pattern\]
:   Shows the descriptions of objects of type `constraint`, `operator class`, `operator family`, `rule`, and `trigger`. All other comments may be viewed by the respective backslash commands for those object types.

:   `\dd` displays descriptions for objects matching the pattern, or of visible objects of the appropriate type if no argument is given. But in either case, only objects that have a description are listed. By default, only user-created objects are shown; supply a pattern or the `S` modifier to include system objects.

:   Descriptions for objects can be created with the `COMMENT` SQL command.

\\ddp \[pattern\]
:   Lists default access privilege settings. An entry is shown for each role \(and schema, if applicable\) for which the default privilege settings have been changed from the built-in defaults. If pattern is specified, only entries whose role name or schema name matches the pattern are listed.

:   The [ALTER DEFAULT PRIVILEGES](../../ref_guide/sql_commands/ALTER_DEFAULT_PRIVILEGES.html) command is used to set default access privileges. The meaning of the privilege display is explained under [GRANT](../../ref_guide/sql_commands/GRANT.html).

\\dD\[S+\] \[domain\_pattern\]
:   Lists domains. If a pattern is specified, only domains whose names match the pattern are shown. By default, only user-created objects are shown; supply a pattern or the `S` modifier to include system objects. If `+` is appended to the command name, each object is listed with its associated permissions and description.

\\dEimstPv\[S+\] \[external\_table \| index \| materialized\_view \| sequence \| table \| parent table \| view\]
:   This is not the actual command name: the letters `E`, `i`, `m`, `s`, `t`, `P`, and `v` stand for external table, index, materialized view, sequence, table, parent table, and view, respectively. You can specify any or all of these letters, in any order, to obtain a listing of objects of these types. For example, `\dit` lists indexes and tables. If `+` is appended to the command name, each object is listed with its physical size on disk and its associated description, if any. If a pattern is specified, only objects whose names match the pattern are listed. By default, only user-created objects are shown; supply a pattern or the `S` modifier to include system objects.

\\des\[+\] \[foreign\_server\_pattern\]
:   Lists foreign servers. If a pattern is specified, only those servers whose name matches the pattern are listed. If the form `\des+` is used, a full description of each server is shown, including the server's ACL, type, version, options, and description.

\\det\[+\] \[foreign\_table\_pattern\]
:   Lists all foreign tables. If a pattern is specified, only entries whose table name or schema name matches the pattern are listed. If the form `\det+` is used, generic options and the foreign table description are also displayed.

\\deu\[+\] \[user\_mapping\_pattern\]
:   Lists user mappings. If a pattern is specified, only those mappings whose user names match the pattern are listed. If the form `\deu+` is used, additional information about each mapping is shown.

    > **Caution** `\deu+` might also display the user name and password of the remote user, so care should be taken not to disclose them.

\\dew\[+\] \[foreign\_data\_wrapper\_pattern\]
:   Lists foreign-data wrappers. If a pattern is specified, only those foriegn-data wrappers whose name matches the pattern are listed. If the form `\dew+` is used, the ACL, options, and description of the foreign-data wrapper are also shown.

\\df\[antwS+\] \[function\_pattern\]
:   Lists functions, together with their arguments, return types, and function types, which are classified as "agg" \(aggregate\), "normal", "trigger", or "window". To display only functions of a specific type\(s\), add the corresponding letters `a`, `n`, `t`, or `w`, to the command. If a pattern is specified, only functions whose names match the pattern are shown. If the form `\df+` is used, additional information about each function, including security, volatility, language, source code, and description, is shown. By default, only user-created objects are shown; supply a pattern or the `S` modifier to include system objects.

\\dF\[+\] \[pattern\]
:   Lists text search configurations. If a pattern is specified, only configurations whose names match the pattern are shown. If the form `\dF+` is used, a full description of each configuration is shown, including the underlying text search parser and the dictionary list for each parser token type.

\\dFd\[+\] \[pattern\]
:   Lists text search dictionaries. If a pattern is specified, only dictionaries whose names match the pattern are shown. If the form `\dFd+` is used, additional information is shown about each selected dictionary, including the underlying text search template and the option values.

\\dFp\[+\] \[pattern\]
:   Lists text search parsers. If a pattern is specified, only parsers whose names match the pattern are shown. If the form `\dFp+` is used, a full description of each parser is shown, including the underlying functions and the list of recognized token types.

\\dFt\[+\] \[pattern\]
:   Lists text search templates. If a pattern is specified, only templates whose names match the pattern are shown. If the form `\dFt+` is used, additional information is shown about each template, including the underlying function names.

\\dg\[+\] \[role\_pattern\]
:   Lists database roles. \(Since the concepts of "users" and "groups" have been unified into "roles", this command is now equivalent to `\du`.\) If a pattern is specified, only those roles whose names match the pattern are listed. If the form `\dg+` is used, additional information is shown about each role; currently this adds the comment for each role.

\\dl
:   This is an alias for `\lo_list`, which shows a list of large objects.
    <br/><br/>> **Note** Greenplum Database does not support the PostgreSQL [large object facility](https://www.postgresql.org/docs/12/largeobjects.html) for streaming user data that is stored in large-object structures.

\\dL\[S+\] \[pattern\]
:   Lists procedural languages. If a pattern is specified, only languages whose names match the pattern are listed. By default, only user-created languages are shown; supply the `S` modifier to include system objects. If `+` is appended to the command name, each language is listed with its call handler, validator, access privileges, and whether it is a system object.

\\dn\[S+\] \[schema\_pattern\]
:   Lists all available schemas \(namespaces\). If a pattern is specified, only schemas whose names match the pattern are listed. By default, only user- create objects are show; supply a pattern or the `S` modifier to include system objects. If `+` is appended to the command name, each object is listed with its associated permissions and description, if any.

\\do\[S\] \[operator\_pattern\]
:   Lists available operators with their operand and return types. If a pattern is specified, only operators whose names match the pattern are listed. By default, only user-created objects are shown; supply a pattern or the `S` modifier to include system objects.

\\dO\[S+\] \[pattern\]
:   Lists collations. If a pattern is specified, only collations whose names match the pattern are listed. By default, only user-created objects are shown; supply a pattern or the `S` modifier to include system objects. If `+` is appended to the command name, each collation is listed with its associated description, if any. Note that only collations usable with the current database's encoding are shown, so the results may vary in different databases of the same installation.

\\dp \[relation\_pattern\_to\_show\_privileges\]
:   Lists tables, views, and sequences with their associated access privileges. If a pattern is specified, only tables, views, and sequences whose names match the pattern are listed. The [GRANT](../../ref_guide/sql_commands/GRANT.html) and [REVOKE](../../ref_guide/sql_commands/REVOKE.html) commands are used to set access privileges. The meaning of the privilege display is explained under [GRANT](../../ref_guide/sql_commands/GRANT.html).

\\drds \[role-pattern \[database-pattern\]\]
:   Lists defined configuration settings. These settings can be role-specific, database-specific, or both. role-pattern and database-pattern are used to select specific roles and database to list, respectively. If omitted, or if `*` is specified, all settings are listed, including those not role-specific or database-specific, respectively.

:   The [ALTER ROLE](../../ref_guide/sql_commands/ALTER_ROLE.html) and [ALTER DATABASE](../../ref_guide/sql_commands/ALTER_DATABASE.html) commands are used to define per-role and per-database role configuration settings.

\\dT\[S+\] \[datatype\_pattern\]
:   Lists data types. If a pattern is specified, only types whose names match the pattern are listed. If `+` is appended to the command name, each type is listed with its internal name and size, its allowed values if it is an `enum` type, and its associated permissions. By default, only user-created objects are shown; supply a pattern or the `S` modifier to include system objects.

\\du\[+\] \[role\_pattern\]
:   Lists database roles. \(Since the concepts of "users" and "groups" have been unified into "roles", this command is now equivalent to `\dg`.\) If a pattern is specified, only those roles whose names match the pattern are listed. If the form `\du+` is used, additional information is shown about each role; currently this adds the comment for each role.

\\dx\[+\] \[extension\_pattern\]
:   Lists installed extensions. If a pattern is specified, only those extensions whose names match the pattern are listed. If the form `\dx+` is used, all of the objects belonging to each matching extension are listed.

\\dy\[+\] \[pattern\]
:   Lists event triggers. If a pattern is specified, only those triggers whose names match the pattern are listed. If `+` is appended to the command name, each object is listed with its associated description.

\\dy\[+\] \[pattern\]
:   Lists event triggers. If a pattern is specified, only those triggers whose names match the pattern are listed. If `+` is appended to the command name, each object is listed with its associated description.

    > **Note** Greenplum Database does not support user-defined triggers.

\\e \| \\edit \[filename\] \[line\_number\]
:   If filename is specified, the file is edited; after the editor exits, its content is copied back to the query buffer. If no filename is given, the current query buffer is copied to a temporary file which is then edited in the same fashion.

:   The new query buffer is then re-parsed according to the normal rules of `psql`, where the whole buffer is treated as a single line. \(Thus you cannot make scripts this way. Use `\i` for that.\) This means also that if the query ends with \(or rather contains\) a semicolon, it is immediately run. In other cases it will merely wait in the query buffer; type semicolon or `\g` to send it, or `\r` to cancel.

:   If a line number is specified, `psql` will position the cursor on the specified line of the file or query buffer. Note that if a single all-digits argument is given, `psql` assumes it is a line number, not a file name.

:   See [Environment](#section17) for information about configuring and customizing your editor.

\\echo text \[ ... \]
:   Prints the arguments to the standard output, separated by one space and followed by a newline. This can be useful to intersperse information in the output of scripts. If the first argument is an unquoted `-n`, the trailing newline is not written.

    > **Note** If you use the `\o` command to redirect your query output you might wish to use `\qecho` instead of this command.

\\ef \[function\_description \[line\_number\]\]
:   This command fetches and edits the definition of the named function, in the form of a `CREATE OR REPLACE FUNCTION` command. Editing is done in the same way as for `\edit`. After the editor exits, the updated command waits in the query buffer; type semicolon or `\g` to send it, or `\r` to cancel.

:   The target function can be specified by name alone, or by name and arguments, for example `foo(integer, text)`. The argument types must be given if there is more than one function with the same name.

:   If no function is specified, a blank `CREATE FUNCTION` template is presented for editing.

:   If a line number is specified, `psql` will position the cursor on the specified line of the function body. \(Note that the function body typically does not begin on the first line of the file.\)

:   See [Environment](#section17) for information about configuring and customizing your editor.

\\encoding \[encoding\]
:   Sets the client character set encoding. Without an argument, this command shows the current encoding.

\\f \[field\_separator\_string\]
:   Sets the field separator for unaligned query output. The default is the vertical bar \(`|`\). See also `\pset` for a generic way of setting output options.

\\g \[filename\]
\\g \[ `|` command \]
:   Sends the current query input buffer to the server, and optionally stores the query's output in filename or pipes the output to the shell command command. The file or command is written to only if the query successfully returns zero or more tuples, not if the query fails or is a non-data-returning SQL command.

:   A bare `\g` is essentially equivalent to a semi-colon. A `\g` with argument is a one-shot alternative to the `\o` command.

\\gset \[prefix\]
:   Sends the current query input buffer to the server and stores the query's output into `psql` variables. The query to be run must return exactly one row. Each column of the row is stored into a separate variable, named the same as the column. For example:

    ```
    => SELECT 'hello' AS var1, 10 AS var2;
    -> \gset
    => \echo :var1 :var2
    hello 10
    
    ```

:   If you specify a prefix, that string is prepended to the query's column names to create the variable names to use:

    ```
    => SELECT 'hello' AS var1, 10 AS var2;
    -> \gset result_
    => \echo :result_var1 :result_var2
    hello 10
    ```

:   If a column result is NULL, the corresponding variable is unset rather than being set.

:   If the query fails or does not return one row, no variables are changed.

\\h \| \\help \[sql\_command\]
:   Gives syntax help on the specified SQL command. If a command is not specified, then `psql` will list all the commands for which syntax help is available. If command is an asterisk \(`*`\) then syntax help on all SQL commands is shown. To simplify typing, commands that consist of several words do not have to be quoted.

\\H \| \\html
:   Turns on HTML query output format. If the HTML format is already on, it is switched back to the default aligned text format. This command is for compatibility and convenience, but see `\pset` about setting other output options.

\\i \| \\include filename
:   Reads input from the file filename and runs it as though it had been typed on the keyboard.

:   If filename is `-` \(hyphen\), then standard input is read until an EOF indication or `\q` meta-command. This can be used to intersperse interactive input with input from files. Note that Readline behavior will be used only if it is active at the outermost level.

:   If you want to see the lines on the screen as they are read you must set the variable `ECHO` to `all`.

\\ir \| \\include\_relative filename
:   The `\ir` command is similar to `\i`, but resolves relative file names differently. When running in interactive mode, the two commands behave identically. However, when invoked from a script, `\ir` interprets file names relative to the directory in which the script is located, rather than the current working directory.

\\l\[+\] \| \\list\[+\] \[pattern\]
:   List the databases in the server and show their names, owners, character set encodings, and access privileges. If a pattern is specified, only databases whose names match the pattern are listed. If `+` is appended to the command name, database sizes, default tablespaces, and descriptions are also displayed. \(Size information is only available for databases that the current user can connect to.\)

\\lo\_export loid filename
:   Reads the large object with OID loid from the database and writes it to filename. Note that this is subtly different from the server function `lo_export`, which acts with the permissions of the user that the database server runs as and on the server's file system. Use `\lo_list` to find out the large object's OID.

    > **Note** Greenplum Database does not support the PostgreSQL [large object facility](https://www.postgresql.org/docs/12/largeobjects.html) for streaming user data that is stored in large-object structures.

\\lo\_import large\_object\_filename \[comment\]
:   Stores the file into a large object. Optionally, it associates the given comment with the object. Example:

```
mydb=> \lo_import '/home/gpadmin/pictures/photo.xcf' 'a 
picture of me'
lo_import 152801
```

The response indicates that the large object received object ID 152801 which one ought to remember if one wants to access the object ever again. For that reason it is recommended to always associate a human-readable comment with every object. Those can then be seen with the `\lo_list` command. Note that this command is subtly different from the server-side `lo_import` because it acts as the local user on the local file system, rather than the server's user and file system.

> **Note** Greenplum Database does not support the PostgreSQL [large object facility](https://www.postgresql.org/docs/12/largeobjects.html) for streaming user data that is stored in large-object structures.

\\lo\_list
:   Shows a list of all large objects currently stored in the database, along with any comments provided for them.

    > **Note** Greenplum Database does not support the PostgreSQL [large object facility](https://www.postgresql.org/docs/12/largeobjects.html) for streaming user data that is stored in large-object structures.

\\lo\_unlink largeobject\_oid
:   Deletes the large object of the specified OID from the database. Use `\lo_list` to find out the large object's OID.

    > **Note** Greenplum Database does not support the PostgreSQL [large object facility](https://www.postgresql.org/docs/12/largeobjects.html) for streaming user data that is stored in large-object structures.

\\o \| \\out \[ filename \]
\\o \| \\out \[ `|` command \]
:   Saves future query results to the file filename or pipes future results to the shell command command. If no argument is specified, the query output is reset to the standard output. Query results include all tables, command responses, and notices obtained from the database server, as well as output of various backslash commands that query the database \(such as `\d`\), but not error messages. To intersperse text output in between query results, use `\qecho`.

\\p
:   Print the current query buffer to the standard output.

\\password \[username\]
:   Changes the password of the specified user \(by default, the current user\). This command prompts for the new password, encrypts it, and sends it to the server as an `ALTER ROLE` command. This makes sure that the new password does not appear in cleartext in the command history, the server log, or elsewhere.

\\prompt \[ text \] name
:   Prompts the user to supply text, which is assigned to the variable name. An optional prompt string, text, can be specified. \(For multiword prompts, surround the text with single quotes.\)

:   By default, `\prompt` uses the terminal for input and output. However, if the `-f` command line switch was used, `\prompt` uses standard input and standard output.

\\pset \[print\_option \[value\]\]
:   This command sets options affecting the output of query result tables. print\_option describes which option is to be set. The semantics of value vary depending on the selected option. For some options, omitting value causes the option to be toggled or unset, as described under the particular option. If no such behavior is mentioned, then omitting value just results in the current setting being displayed.

:   `\pset` without any arguments displays the current status of all printing options.

:   Adjustable printing options are:

    -   **`border`** – The value must be a number. In general, the higher the number the more borders and lines the tables will have, but this depends on the particular format. In HTML format, this will translate directly into the `border=...` attribute; in the other formats only values `0` \(no border\), `1` \(internal dividing lines\), and `2` \(table frame\) make sense. `latex` and `latex-longtable` also support a `border` value of 3 which adds a dividing line between each row.
    -   **`columns`** – Sets the target width for the `wrapped` format, and also the width limit for determining whether output is wide enough to require the pager or switch to the vertical display in expanded auto mode. The default is zero. Zero causes the target width to be controlled by the environment variable `COLUMNS`, or the detected screen width if `COLUMNS` is not set. In addition, if `columns` is zero then the wrapped format affects screen output only. If columns is nonzero then file and pipe output is wrapped to that width as well.
        <br/><br/>After setting the target width, use the command `\pset format wrapped` to enable the wrapped format.

    -   **`expanded`** \| **`x`** – If value is specified it must be either `on` or `off`, which will activate or deactivate expanded mode, or `auto`. If value is omitted the command toggles between the `on` and `off` settings. When expanded mode is enabled, query results are displayed in two columns, with the column name on the left and the data on the right. This mode is useful if the data wouldn't fit on the screen in the normal "horizontal" mode. In the `auto` setting, the expanded mode is used whenever the query output is wider than the screen, otherwise the regular mode is used. The `auto` setting is only effective in the aligned and wrapped formats. In other formats, it always behaves as if the expanded mode is `off`.
    -   **`fieldsep`** – Specifies the field separator to be used in unaligned output mode. That way one can create, for example, tab- or comma-separated output, which other programs might prefer. To set a tab as field separator, type `\pset fieldsep '\t'`. The default field separator is `'|'` \(a vertical bar\).
    -   **`fieldsep_zero`** - Sets the field separator to use in unaligned output format to a zero byte.
    -   **`footer`** – If value is specified it must be either `on` or `off` which will activate or deactivate display of the table footer \(the \(n rows\) count\). If value is omitted the command toggles footer display on or off.
    -   **`format`** – Sets the output format to one of `unaligned`, `aligned`, `html`, `latex` \(uses `tabular`\), `latex-longtable`, `troff-ms`, or `wrapped`. Unique abbreviations are allowed.
        **`unaligned`** format writes all columns of a row on one line, separated by the currently active field separator. This is useful for creating output that might be intended to be read in by other programs \(for example, tab-separated or comma-separated format\).
        <br/><br/>**`aligned`** format is the standard, human-readable, nicely formatted text output; this is the default.
        <br/><br/>The **`html`**, **`latex`**, **`latex-longtable`**, and **`troff-ms`** formats put out tables that are intended to be included in documents using the respective mark-up language. They are not complete documents! \(This might not be so dramatic in HTML, but in LaTeX you must have a complete document wrapper. `latex-longtable` also requires the LaTeX `longtable` and `booktabs` packages.\)
        <br/><br/>The **`wrapped`** format is like `aligned`, but wraps wide data values across lines to make the output fit in the target column width. The target width is determined as described under the `columns` option. Note that `psql` does not attempt to wrap column header titles; the `wrapped` format behaves the same as `aligned` if the total width needed for column headers exceeds the target.

    -   **`linestyle`** \[**`unicode`** \| **`ascii`** \| **`old-ascii`**\] – Sets the border line drawing style to one of unicode, ascii, or old-ascii. Unique abbreviations, including one letter, are allowed for the three styles. The default setting is `ascii`. This option only affects the `aligned` and `wrapped` output formats.
        <br/><br/>**`ascii`** – uses plain ASCII characters. Newlines in data are shown using a `+` symbol in the right-hand margin. When the wrapped format wraps data from one line to the next without a newline character, a dot \(`.`\) is shown in the right-hand margin of the first line, and again in the left-hand margin of the following line.
        <br/><br/>**`old-ascii`** – style uses plain ASCII characters, using the formatting style used in PostgreSQL 8.4 and earlier. Newlines in data are shown using a `:` symbol in place of the left-hand column separator. When the data is wrapped from one line to the next without a newline character, a `;` symbol is used in place of the left-hand column separator.
        <br/><br/>**`unicode`** – style uses Unicode box-drawing characters. Newlines in data are shown using a carriage return symbol in the right-hand margin. When the data is wrapped from one line to the next without a newline character, an ellipsis symbol is shown in the right-hand margin of the first line, and again in the left-hand margin of the following line.
        <br/><br/>When the `border` setting is greater than zero, this option also determines the characters with which the border lines are drawn. Plain ASCII characters work everywhere, but Unicode characters look nicer on displays that recognize them.

    -   **`null 'string'`** – The second argument is a string to print whenever a column is null. The default is to print nothing, which can easily be mistaken for an empty string. For example, one might prefer `\pset null '(null)'`.
    -   **`numericlocale`** – If value is specified it must be either `on` or `off` which will activate or deactivate display of a locale-specific character to separate groups of digits to the left of the decimal marker. If value is omitted the command toggles between regular and locale-specific numeric output.
    -   **`pager`** – Controls the use of a pager for query and `psql` help output. If the environment variable `PAGER` is set, the output is piped to the specified program. Otherwise a platform-dependent default \(such as `more`\) is used. When `off`, the pager program is not used. When `on`, the pager is used only when appropriate, i.e. when the output is to a terminal and will not fit on the screen. Pager can also be set to `always`, which causes the pager to be used for all terminal output regardless of whether it fits on the screen. `\pset pager` without a value toggles pager use on and off.
    -   **`recordsep`** – Specifies the record \(line\) separator to use in unaligned output mode. The default is a newline character.
    -   **`recordsep_zero`** - Sets the record separator to use in unaligned output format to a zero byte.
    -   **`tableattr`** \| **`T`** \[text\] – In HTML format, this specifies attributes to be placed inside the HTML `table` tag. This could for example be `cellpadding` or `bgcolor`. Note that you probably don't want to specify `border` here, as that is already taken care of by `\pset border`. If no value is given, the table attributes are unset.
        <br/><br/>In `latex-longtable` format, this controls the proportional width of each column containing a left-aligned data type. It is specified as a whitespace-separated list of values, e.g. `'0.2 0.2 0.6'`. Unspecified output columns use the last specified value.

    -   **`title`** \[text\] – Sets the table title for any subsequently printed tables. This can be used to give your output descriptive tags. If no value is given, the title is unset.
    -   **`tuples_only`** \| **`t`** \[novalue \| on \| off\] – If value is specified, it must be either `on` or `off` which will activate or deactivate tuples-only mode. If value is omitted the command toggles between regular and tuples-only output. Regular output includes extra information such as column headers, titles, and various footers. In tuples-only mode, only actual table data is shown. The `\t` command is equivalent to `\pset``tuples_only` and is provided for convenience.

    **Tip:**

    There are various shortcut commands for `\pset`. See `\a`, `\C`, `\f`, `\H`, `\t`, `\T`, and `\x`.

\\q \| \\quit
:   Quits the `psql` program. In a script file, only execution of that script is terminated.

\\qecho text \[ ... \]
:   This command is identical to `\echo` except that the output will be written to the query output channel, as set by `\o`.

\\r \| \\reset
:   Resets \(clears\) the query buffer.

\\s \[filename\]
:   Print `psql`'s command line history to `filename`. If `filename` is omitted, the history is written to the standard output \(using the pager if appropriate\). This command is not available if `psql` was built without `Readline` support.

\\set \[name \[value \[ ... \]\]\]
:   Sets the `psql` variable name to value, or if more than one value is given, to the concatenation of all of them. If only one argument is given, the variable is just set with an empty value. To unset a variable, use the `\unset` command.

:   `\set` without any arguments displays the names and values of all currently-set `psql` variables.

:   Valid variable names can contain characters, digits, and underscores. See "Variables" in [Advanced Features](#section12). Variable names are case-sensitive.

:   Although you are welcome to set any variable to anything you want, `psql` treats several variables as special. They are documented in the topic about variables.

:   This command is unrelated to the SQL command [SET](../../ref_guide/sql_commands/SET.html).

\\setenv name \[ value \]
:   Sets the environment variable name to value, or if the value is not supplied, unsets the environment variable. Example:

    ```
    testdb=> \setenv PAGER less
    testdb=> \setenv LESS -imx4F
    ```

\\sf\[+\] function\_description
:   This command fetches and shows the definition of the named function, in the form of a `CREATE OR REPLACE FUNCTION` command. The definition is printed to the current query output channel, as set by `\o`.

:   The target function can be specified by name alone, or by name and arguments, for example `foo(integer, text)`. The argument types must be given if there is more than one function of the same name.

:   If `+` is appended to the command name, then the output lines are numbered, with the first line of the function body being line 1.

\\t \[novalue \| on \| off\]
:   The `\t` command by itself toggles a display of output column name headings and row count footer. The values `on` and `off` set the tuples display, regardless of the current setting. This command is equivalent to `\pset tuples_only` and is provided for convenience.

\\T table\_options
:   Specifies attributes to be placed within the `table` tag in HTML output format. This command is equivalent to `\pset tableattr table_options`

\\timing \[novalue \| on \| off\]
:   Without a parameter, toggles a display of how long each SQL statement takes, in milliseconds. The values `on` and `off` set the time display, regardless of the current setting.

\\unset name
:   Unsets \(deletes\) the `psql` variable name.

\\w \| \\write filename
\\w \| \\write `|` command
:   Outputs the current query buffer to the file filename or pipes it to the shell command command.

\\watch \[seconds\]
:   Repeatedly runs the current query buffer \(like `\g`\) until interrupted or the query fails. Wait the specified number of seconds \(default 2\) between executions.

\\x \[ on \| off \| auto \]
:   Sets or toggles expanded table formatting mode. As such it is equivalent to `\pset expanded`.

\\z \[pattern\]
:   Lists tables, views, and sequences with their associated access privileges. If a pattern is specified, only tables, views and sequences whose names match the pattern are listed. This is an alias for `\dp`.

\\! \[command\]
:   Escapes to a separate shell or runs the shell command command. The arguments are not further interpreted; the shell will see them as-is. In particular, the variable substitution rules and backslash escapes do not apply.

\\?
:   Shows help information about the `psql` backslash commands.

## <a id="section11"></a>Patterns 

The various `\d` commands accept a pattern parameter to specify the object name\(s\) to be displayed. In the simplest case, a pattern is just the exact name of the object. The characters within a pattern are normally folded to lower case, just as in SQL names; for example, `\dt FOO` will display the table named `foo`. As in SQL names, placing double quotes around a pattern stops folding to lower case. Should you need to include an actual double quote character in a pattern, write it as a pair of double quotes within a double-quote sequence; again this is in accord with the rules for SQL quoted identifiers. For example, `\dt "FOO""BAR"` will display the table named `FOO"BAR` \(not `foo"bar`\). Unlike the normal rules for SQL names, you can put double quotes around just part of a pattern, for instance `\dt FOO"FOO"BAR` will display the table named `fooFOObar`.

Within a pattern, `*` matches any sequence of characters \(including no characters\) and `?` matches any single character. \(This notation is comparable to UNIX shell file name patterns.\) For example, `\dt int*` displays all tables whose names begin with `int`. But within double quotes, `*` and `?` lose these special meanings and are just matched literally.

A pattern that contains a dot \(`.`\) is interpreted as a schema name pattern followed by an object name pattern. For example, `\dt foo*.bar*` displays all tables whose table name starts with `bar` that are in schemas whose schema name starts with `foo`. When no dot appears, then the pattern matches only objects that are visible in the current schema search path. Again, a dot within double quotes loses its special meaning and is matched literally.

Advanced users can use regular-expression notations. All regular expression special characters work as specified in the [PostgreSQL documentation on regular expressions](https://www.postgresql.org/docs/12/functions-matching.html#FUNCTIONS-POSIX-REGEXP), except for `.` which is taken as a separator as mentioned above, `*` which is translated to the regular-expression notation `.*`, and `?` which is translated to `..` You can emulate these pattern characters at need by writing `?` for `.,``(R+|)` for `R*`, or `(R|)` for `R?`. Remember that the pattern must match the whole name, unlike the usual interpretation of regular expressions; write `*` at the beginning and/or end if you don't wish the pattern to be anchored. Note that within double quotes, all regular expression special characters lose their special meanings and are matched literally. Also, the regular expression special characters are matched literally in operator name patterns \(such as the argument of `\do`\).

Whenever the pattern parameter is omitted completely, the `\d` commands display all objects that are visible in the current schema search path – this is equivalent to using the pattern `*.` To see all objects in the database, use the pattern `*.*.`

## <a id="section12"></a>Advanced Features 

**Variables**

`psql` provides variable substitution features similar to common UNIX command shells. Variables are simply name/value pairs, where the value can be any string of any length. The name must consist of letters \(including non-Latin letters\), digits, and underscores.

To set a variable, use the psql meta-command `\set`. For example,

```
testdb=> \set foo bar
```

sets the variable `foo` to the value `bar`. To retrieve the content of the variable, precede the name with a colon, for example:

```
testdb=> \echo :foo
bar
```

This works in both regular SQL commands and meta-commands; there is more detail in [SQL Interpolation](#section14).

If you call `\set` without a second argument, the variable is set, with an empty string as value. To unset \(i.e., delete\) a variable, use the command `\unset`. To show the values of all variables, call `\set` without any argument.

> **Note** The arguments of `\set` are subject to the same substitution rules as with other commands. Thus you can construct interesting references such as `\set :foo 'something'` and get 'soft links' or 'variable variables' of Perl or PHP fame, respectively. Unfortunately, there is no way to do anything useful with these constructs. On the other hand, `\set bar :foo` is a perfectly valid way to copy a variable.

A number of these variables are treated specially by `psql`. They represent certain option settings that can be changed at run time by altering the value of the variable, or in some cases represent changeable state of `psql`. Although you can use these variables for other purposes, this is not recommended, as the program behavior might grow really strange really quickly. By convention, all specially treated variables' names consist of all upper-case ASCII letters \(and possibly digits and underscores\). To ensure maximum compatibility in the future, avoid using such variable names for your own purposes. A list of all specially treated variables follows.

AUTOCOMMIT
:   When on \(the default\), each SQL command is automatically committed upon successful completion. To postpone commit in this mode, you must enter a `BEGIN` or `START TRANSACTION` SQL command. When off or unset, SQL commands are not committed until you explicitly issue `COMMIT` or `END`. The autocommit-on mode works by issuing an implicit `BEGIN` for you, just before any command that is not already in a transaction block and is not itself a `BEGIN` or other transaction-control command, nor a command that cannot be run inside a transaction block \(such as `VACUUM`\).

:   In autocommit-off mode, you must explicitly abandon any failed transaction by entering `ABORT` or `ROLLBACK`. Also keep in mind that if you exit the session without committing, your work will be lost.

:   The autocommit-on mode is PostgreSQL's traditional behavior, but autocommit-off is closer to the SQL spec. If you prefer autocommit-off, you may wish to set it in your `~/.psqlrc` file.

COMP\_KEYWORD\_CASE
:   Determines which letter case to use when completing an SQL key word. If set to `lower` or `upper`, the completed word will be in lower or upper case, respectively. If set to `preserve-lower` or `preserve-upper` \(the default\), the completed word will be in the case of the word already entered, but words being completed without anything entered will be in lower or upper case, respectively.

DBNAME
:   The name of the database you are currently connected to. This is set every time you connect to a database \(including program start-up\), but can be unset.

ECHO
:   If set to `all`, all nonempty input lines are printed to standard output as they are read. \(This does not apply to lines read interactively.\) To select this behavior on program start-up, use the switch `-a`. If set to queries, `psql` prints each query to standard output as it is sent to the server. The switch for this is `-e`.

ECHO\_HIDDEN
:   When this variable is set to `on` and a backslash command queries the database, the query is first shown. This feature helps you to study Greenplum Database internals and provide similar functionality in your own programs. \(To select this behavior on program start-up, use the switch `-E`.\) If you set the variable to the value `noexec`, the queries are just shown but are not actually sent to the server and run.

ENCODING
:   The current client character set encoding.

FETCH\_COUNT
:   If this variable is set to an integer value \> 0, the results of `SELECT` queries are fetched and displayed in groups of that many rows, rather than the default behavior of collecting the entire result set before display. Therefore only a limited amount of memory is used, regardless of the size of the result set. Settings of 100 to 1000 are commonly used when enabling this feature. Keep in mind that when using this feature, a query may fail after having already displayed some rows.

:   Although you can use any output format with this feature, the default aligned format tends to look bad because each group of `FETCH_COUNT` rows will be formatted separately, leading to varying column widths across the row groups. The other output formats work better.

HISTCONTROL
:   If this variable is set to `ignorespace`, lines which begin with a space are not entered into the history list. If set to a value of `ignoredups`, lines matching the previous history line are not entered. A value of `ignoreboth` combines the two options. If unset, or if set to any other value than those above, all lines read in interactive mode are saved on the history list.

HISTFILE
:   The file name that will be used to store the history list. The default value is `~/.psql_history`. For example, putting

    ```
    \set HISTFILE ~/.psql_history- :DBNAME
    ```

:   in `~/.psqlrc` will cause `psql` to maintain a separate history for each database.

HISTSIZE
:   The number of commands to store in the command history. The default value is 500.

HOST
:   The database server host you are currently connected to. This is set every time you connect to a database \(including program start-up\), but can be unset.

IGNOREEOF
:   If unset, sending an `EOF` character \(usually `CTRL+D`\) to an interactive session of `psql` will terminate the application. If set to a numeric value, that many `EOF` characters are ignored before the application terminates. If the variable is set but has no numeric value, the default is `10`.

LASTOID
:   The value of the last affected OID, as returned from an `INSERT` or `lo_import` command. This variable is only guaranteed to be valid until after the result of the next SQL command has been displayed.

ON\_ERROR\_ROLLBACK
:   When set to `on`, if a statement in a transaction block generates an error, the error is ignored and the transaction continues. When set to `interactive`, such errors are only ignored in interactive sessions, and not when reading script files. When unset or set to `off`, a statement in a transaction block that generates an error cancels the entire transaction. The error rollback mode works by issuing an implicit `SAVEPOINT` for you, just before each command that is in a transaction block, and rolls back to the savepoint on error.

ON\_ERROR\_STOP
:   By default, command processing continues after an error. When this variable is set to `on`, processing will instead stop immediately. In interactive mode, `psql` will return to the command prompt; otherwise, `psql` will exit, returning error code 3 to distinguish this case from fatal error conditions, which are reported using error code 1. In either case, any currently running scripts \(the top-level script, if any, and any other scripts which it may have in invoked\) will be terminated immediately. If the top-level command string contained multiple SQL commands, processing will stop with the current command.

PORT
:   The database server port to which you are currently connected. This is set every time you connect to a database \(including program start-up\), but can be unset.

PROMPT1
PROMPT2
PROMPT3
:   These specify what the prompts `psql` issues should look like. See "Prompting".

QUIET
:   Setting this variable to `on` is equivalent to the command line option `-q`. It is not very useful in interactive mode.

SINGLELINE
:   This variable is equivalent to the command line option `-S`.

SINGLESTEP
:   Setting this variable to `on` is equivalent to the command line option `-s`.

USER
:   The database user you are currently connected as. This is set every time you connect to a database \(including program start-up\), but can be unset.

VERBOSITY
:   This variable can be set to the values `default`, `verbose`, or `terse` to control the verbosity of error reports.

**SQL Interpolation**

A key feature of `psql` variables is that you can substitute \("interpolate"\) them into regular SQL statements, as well as the arguments of meta-commands. Furthermore, `psql` provides facilities for ensuring that variable values used as SQL literals and identifiers are properly quoted. The syntax for interpolating a value without any quoting is to prepend the variable name with a colon \(`:`\). For example,

```
testdb=> \set foo 'my_table'
testdb=> SELECT * FROM :foo;
```

would query the table `my_table`. Note that this may be unsafe: the value of the variable is copied literally, so it can contain unbalanced quotes, or even backslash commands. You must make sure that it makes sense where you put it.

When a value is to be used as an SQL literal or identifier, it is safest to arrange for it to be quoted. To quote the value of a variable as an SQL literal, write a colon followed by the variable name in single quotes. To quote the value as an SQL identifier, write a colon followed by the variable name in double quotes. These constructs deal correctly with quotes and other special characters embedded within the variable value. The previous example would be more safely written this way:

```
testdb=> \set foo 'my_table'
testdb=> SELECT * FROM :"foo";
```

Variable interpolation will not be performed within quoted SQL literals and identifiers. Therefore, a construction such as `':foo'` doesn't work to produce a quoted literal from a variable's value \(and it would be unsafe if it did work, since it wouldn't correctly handle quotes embedded in the value\).

One example use of this mechanism is to copy the contents of a file into a table column. First load the file into a variable and then interpolate the variable's value as a quoted string:

```
testdb=> \set content `cat my_file.txt`
testdb=> INSERT INTO my_table VALUES (:'content');
```

\(Note that this still won't work if `my_file.txt` contains `NUL` bytes. `psql` does not support embedded `NUL` bytes in variable values.\)

Since colons can legally appear in SQL commands, an apparent attempt at interpolation \(that is, `:name`, `:'name'`, or `:"name"`\) is not replaced unless the named variable is currently set. In any case, you can escape a colon with a backslash to protect it from substitution.

The colon syntax for variables is standard SQL for embedded query languages, such as ECPG. The colon syntaxes for array slices and type casts are Greenplum Database extensions, which can sometimes conflict with the standard usage. The colon-quote syntax for escaping a variable's value as an SQL literal or identifier is a `psql` extension.

**Prompting**

The prompts `psql` issues can be customized to your preference. The three variables `PROMPT1`, `PROMPT2`, and `PROMPT3` contain strings and special escape sequences that describe the appearance of the prompt. Prompt 1 is the normal prompt that is issued when `psql` requests a new command. Prompt 2 is issued when more input is expected during command entry, for example because the command was not terminated with a semicolon or a quote was not closed. Prompt 3 is issued when you are running an SQL `COPY FROM STDIN` command and you need to type in a row value on the terminal.

The value of the selected prompt variable is printed literally, except where a percent sign \(`%`\) is encountered. Depending on the next character, certain other text is substituted instead. Defined substitutions are:

%M
:   The full host name \(with domain name\) of the database server, or `[local]` if the connection is over a UNIX domain socket, or `[local:/dir/name]`, if the UNIX domain socket is not at the compiled in default location.

%m
:   The host name of the database server, truncated at the first dot, or `[local]` if the connection is over a UNIX domain socket.

%\>
:   The port number at which the database server is listening.

%n
:   The database session user name. \(The expansion of this value might change during a database session as the result of the command `SET SESSION AUTHORIZATION`.\)

%/
:   The name of the current database.

%~
:   Like `%/`, but the output is `~` \(tilde\) if the database is your default database.

%\#
:   If the session user is a database superuser, then a **\#**, otherwise a **\>**. \(The expansion of this value might change during a database session as the result of the command `SET SESSION AUTHORIZATION`.\)

%R
:   In prompt 1 normally `=`, but `^` if in single-line mode, or `!` if the session is disconnected from the database \(which can happen if `\connect` fails\). In prompt 2 `%R` is replaced by a character that depends on why `psql` expects more input: `-` if the command simply wasn't terminated yet, but `*` if there is an unfinished `/* ... */` comment, a single quote if there is an unfinished quoted string, a double quote if there is an unfinished quoted identifier, a dollar sign if there is an unfinished dollar-quoted string, or `(` if there is an unmatched left parenthesis. In prompt 3 `%R` doesn't produce anything.

%x
:   Transaction status: an empty string when not in a transaction block, or **\*** when in a transaction block, or **!** when in a failed transaction block, or **?** when the transaction state is indeterminate \(for example, because there is no connection\).

%digits
:   The character with the indicated octal code is substituted.

%:name:
:   The value of the `psql` variable name. See "Variables" in [Advanced Features](#section12) for details.

%\`command\`
:   The output of command, similar to ordinary back-tick substitution.

%\[ ... %\]
:   Prompts may contain terminal control characters which, for example, change the color, background, or style of the prompt text, or change the title of the terminal window. In order for line editing to work properly, these non-printing control characters must be designated as invisible by surrounding them with `%[` and `%]`. Multiple pairs of these may occur within the prompt. For example,

    ```
    testdb=> \set PROMPT1 '%[%033[1;33;40m%]%n@%/%R%[%033[0m%]%#'
    ```

:   results in a boldfaced \(`1;`\) yellow-on-black \(`33;40`\) prompt on VT100-compatible, color-capable terminals. To insert a percent sign into your prompt, write `%%`. The default prompts are `'%/%R%# '` for prompts 1 and 2, and `'>> '` for prompt 3.

**Command-Line Editing**

`psql` uses the `readline` library for convenient line editing and retrieval. The command history is automatically saved when `psql` exits and is reloaded when `psql` starts up. Tab-completion is also supported, although the completion logic makes no claim to be an SQL parser. The queries generated by tab-completion can also interfere with other SQL commands, e.g. `SET TRANSACTION ISOLATION LEVEL`. If for some reason you do not like the tab completion, you can turn it off by putting this in a file named `.inputrc` in your home directory:

```
$if psql
set disable-completion on
$endif
```

## <a id="section17"></a>Environment 

COLUMNS
:   If `\pset columns` is zero, controls the width for the wrapped format and width for determining if wide output requires the pager or should be switched to the vertical format in expanded auto mode.

PAGER
:   If the query results do not fit on the screen, they are piped through this command. Typical values are `more` or `less`. The default is platform-dependent. The use of the pager can be deactivated by setting PAGER to empty, or by using pager-related options of the `\pset` command.

PGDATABASE
PGHOST
PGPORT
PGUSER
:   Default connection parameters.

PSQL\_EDITOR
EDITOR
VISUAL
:   Editor used by the `\e` and `\ef` commands. The variables are examined in the order listed; the first that is set is used.

:   The built-in default editors are `vi` on Unix systems and `notepad.exe` on Windows systems.

PSQL\_EDITOR\_LINENUMBER\_ARG
:   When `\e` or `\ef` is used with a line number argument, this variable specifies the command-line argument used to pass the starting line number to the user's editor. For editors such as Emacs or `vi`, this is a plus sign. Include a trailing space in the value of the variable if there needs to be space between the option name and the line number. Examples:

    ```
    PSQL_EDITOR_LINENUMBER_ARG='+'
    PSQL_EDITOR_LINENUMBER_ARG='--line '
    ```

:   The default is `+` on Unix systems \(corresponding to the default editor `vi`, and useful for many other common editors\); but there is no default on Windows systems.

PSQL\_HISTORY
:   Alternative location for the command history file. Tilde \(`~`\) expansion is performed.

PSQLRC
:   Alternative location of the user's `.psqlrc` file. Tilde \(`~`\) expansion is performed.

SHELL
:   Command run by the `\!` command.

TMPDIR
:   Directory for storing temporary files. The default is `/tmp`.

## <a id="section18"></a>Files 

psqlrc and ~/.psqlrc
:   Unless it is passed an `-X` or `-c` option, `psql` attempts to read and run commands from the system-wide startup file \(`psqlrc`\) and then the user's personal startup file \(`~/.psqlrc`\), after connecting to the database but before accepting normal commands. These files can be used to set up the client and/or the server to taste, typically with `\set` and `SET` commands.

:   The system-wide startup file is named `psqlrc` and is sought in the installation's "system configuration" directory, which is most reliably identified by running `pg_config --sysconfdir`. By default this directory will be`../etc/` relative to the directory containing the Greenplum Database executables. The name of this directory can be set explicitly via the `PGSYSCONFDIR` environment variable.

:   The user's personal startup file is named `.psqlrc` and is sought in the invoking user's home directory. On Windows, which lacks such a concept, the personal startup file is named `%APPDATA%\postgresql\psqlrc.conf`. The location of the user's startup file can be set explicitly via the `PSQLRC` environment variable.

:   Both the system-wide startup file and the user's personal startup file can be made psql-version-specific by appending a dash and the underlying PostgreSQL major or minor release number to the file name, for example `~/.psqlrc-9.4`. The most specific version-matching file will be read in preference to a non-version-specific file.

.psql\_history
:   The command-line history is stored in the file `~/.psql_history`, or`%APPDATA%\postgresql\psql_history` on Windows.

:   The location of the history file can be set explicitly via the `PSQL_HISTORY` environment variable.

## <a id="section19"></a>Notes 

`psql` works best with servers of the same or an older major version. Backslash commands are particularly likely to fail if the server is of a newer version than `psql` itself. However, backslash commands of the `\d` family should work with older server versions, though not necessarily with servers newer than `psql` itself. The general functionality of running SQL commands and displaying query results should also work with servers of a newer major version, but this cannot be guaranteed in all cases.

If you want to use `psql` to connect to several servers of different major versions, it is recommended that you use the newest version of `psql`. Alternatively, you can keep a copy of `psql` from each major version around and be sure to use the version that matches the respective server. But in practice, this additional complication should not be necessary.

## <a id="section20"></a>Notes for Windows Users 

`psql` is built as a console application. Since the Windows console windows use a different encoding than the rest of the system, you must take special care when using 8-bit characters within `psql`. If `psql` detects a problematic console code page, it will warn you at startup. To change the console code page, two things are necessary:

Set the code page by entering:

```
cmd.exe /c chcp 1252
```

`1252` is a character encoding of the Latin alphabet, used by Microsoft Windows for English and some other Western languages. If you are using Cygwin, you can put this command in `/etc/profile`.

Set the console font to Lucida Console, because the raster font does not work with the ANSI code page.

## <a id="section21"></a>Examples 

Start `psql` in interactive mode:

```
psql -p 54321 -U sally mydatabase
```

In `psql` interactive mode, spread a command over several lines of input. Notice the changing prompt:

```
testdb=> CREATE TABLE my_table (
testdb(>  first integer not null default 0,
testdb(>  second text)
testdb-> ;
CREATE TABLE
```

Look at the table definition:

```
testdb=> \d my_table
             Table "public.my_table"
 Column    |  Type   |      Modifiers
-----------+---------+--------------------
 first     | integer | not null default 0
 second    | text    |
Distributed by: (first)
```

Run `psql` in non-interactive mode by passing in a file containing SQL commands:

```
psql -f /home/gpadmin/test/myscript.sql
```

