---
title: Defining Database Objects 
---

This section covers data definition language \(DDL\) in Greenplum Database and how to create and manage database objects.

Creating objects in a Greenplum Database includes making up-front choices about data distribution, storage options, data loading, and other Greenplum features that will affect the ongoing performance of your database system. Understanding the options that are available and how the database will be used will help you make the right decisions.

Most of the advanced Greenplum features are enabled with extensions to the SQL `CREATE` DDL statements.

-   **[Creating and Managing Databases](../ddl/ddl-database.html)**  

-   **[Creating and Managing Tablespaces](../ddl/ddl-tablespace.html)**  

-   **[Creating and Managing Schemas](../ddl/ddl-schema.html)**  

-   **[About Table Definition Basics](../ddl/ddl-basics.html)**  

-   **[Creating and Managing Tables](../ddl/ddl-table.html)**  

-   **[Choosing the Table Storage Model](../ddl/ddl-storage.html)**  

-   **[About Changes to Table Partitioning in Greenplum 7](../ddl/about-part-changes.html)**  

-   **[Partitioning Large Tables](../ddl/ddl-partition.html)**  

-   **[Creating and Using Sequences](../ddl/ddl-sequence.html)**  

-   **[Using Indexes in Greenplum Database](../ddl/ddl-index.html)**  

-   **[Creating and Managing Views](../ddl/ddl-view.html)**  

-   **[Creating and Managing Materialized Views](../ddl/ddl-mat-view.html)**  


**Parent topic:** [Greenplum Database Administrator Guide](../admin_guide.html)

