/*
 * Copyright (c) 2021
 *      Nakata, Maho
 *      All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <mpblas.h>
#include <mplapack.h>

#include <fem.hpp> // Fortran EMulation library of fable module
using namespace fem::major_types;
using fem::common;

#include <mplapack_matgen.h>
#include <mplapack_lin.h>

#include <mplapack_debug.h>

void Rerrps(const char *path, INTEGER const nunit) {
    common cmn;
    common_write write(cmn);
    //
    //
    //  -- LAPACK test routine --
    //  -- LAPACK is a software package provided by Univ. of Tennessee,    --
    //  -- Univ. of California Berkeley, Univ. of Colorado Denver and NAG Ltd..--
    //
    //     .. Scalar Arguments ..
    //     ..
    //
    //  =====================================================================
    //
    //     .. Parameters ..
    //     ..
    //     .. Local Scalars ..
    //     ..
    //     .. Local Arrays ..
    //     ..
    //     .. External Subroutines ..
    //     ..
    //     .. Scalars in Common ..
    //     ..
    //     .. Common blocks ..
    //     ..
    //     .. Intrinsic Functions ..
    //     ..
    //     .. Executable Statements ..
    //
    nout = nunit;
    //
    //     Set the variables to innocuous values.
    //
    INTEGER j = 0;
    const INTEGER nmax = 4;
    INTEGER i = 0;
    REAL a[nmax * nmax];
    INTEGER lda = nmax;
    INTEGER piv[nmax];
    REAL work[2 * nmax];
    for (j = 1; j <= nmax; j = j + 1) {
        for (i = 1; i <= nmax; i = i + 1) {
            a[(i - 1) + (j - 1) * lda] = 1.0 / castREAL(i + j);
            //
        }
        piv[j - 1] = j;
        work[j - 1] = 0.0;
        work[(nmax + j) - 1] = 0.0;
        //
    }
    ok = true;
    //
    //        Test error exits of the routines that use the Cholesky
    //        decomposition of a symmetric positive semidefinite matrix.
    //
    //        Rpstrf
    //
    strncpy(srnamt, "Rpstrf", srnamt_len);
    infot = 1;
    INTEGER rank = 0;
    INTEGER info = 0;
    Rpstrf("/", 0, a, 1, piv, rank, -1.0, work, info);
    chkxer("Rpstrf", infot, nout, lerr, ok);
    infot = 2;
    Rpstrf("U", -1, a, 1, piv, rank, -1.0, work, info);
    chkxer("Rpstrf", infot, nout, lerr, ok);
    infot = 4;
    Rpstrf("U", 2, a, 1, piv, rank, -1.0, work, info);
    chkxer("Rpstrf", infot, nout, lerr, ok);
    //
    //        Rpstf2
    //
    strncpy(srnamt, "Rpstf2", srnamt_len);
    infot = 1;
    Rpstf2("/", 0, a, 1, piv, rank, -1.0, work, info);
    chkxer("Rpstf2", infot, nout, lerr, ok);
    infot = 2;
    Rpstf2("U", -1, a, 1, piv, rank, -1.0, work, info);
    chkxer("Rpstf2", infot, nout, lerr, ok);
    infot = 4;
    Rpstf2("U", 2, a, 1, piv, rank, -1.0, work, info);
    chkxer("Rpstf2", infot, nout, lerr, ok);
    //
    //     Print a summary line.
    //
    Alaesm(path, ok, nout);
    //
    //     End of Rerrps
    //
}
