/*
 * Copyright (c) 2021
 *      Nakata, Maho
 *      All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <mpblas.h>
#include <mplapack.h>

REAL Mmaxval(REAL *dx, INTEGER const start, INTEGER const end, INTEGER incx) {
    REAL dmax = 0.0;
    if (incx <= 0) {
        return dx[start];
    }
    INTEGER i = 0;
    INTEGER ix = 0;
    if (incx == 1) {
        //
        //        code for increment equal to 1
        //
        dmax = dx[start - 1];
        for (i = start + 1; i <= end; i = i + 1) {
            if (dx[i - 1] > dmax) {
                dmax = dx[i - 1];
            }
        }
    } else {
        //
        //        code for increment not equal to 1
        //
        ix = 1;
        dmax = dx[start - 1];
        ix += incx;
        for (i = start + 1; i <= end; i = i + 1) {
            if (dx[ix - 1] > dmax) {
                dmax = dx[ix - 1];
            }
            ix += incx;
        }
    }
    return dmax;
}
