/*
 * Copyright (c) 2008-2021
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_mpfr.h,v 1.5 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_MPFR_H_
#define _MPLAPACK_MPFR_H_

#include "mplapack_config.h"
#include "mpc_class.h"
#include "gmpxx.h"
#include "mpreal.h"
#include "mpcomplex.h"

using namespace mpfr;

bool Mlsamen_mpfr(mplapackint n, const char *a, const char *b);
bool Risnan(mpreal const din);
bool Rlaisnan(mpreal const din1, mpreal const din2);
mpcomplex Cladiv(mpcomplex const x, mpcomplex const y);
mplapackint Mmaxloc(mpreal *dx, mplapackint const start, mplapackint const end, mplapackint const incx);
mplapackint Rlaneg(mplapackint const n, mpreal *d, mpreal *lld, mpreal const sigma, mpreal const, mplapackint const r);
mplapackint iCmax1(mplapackint const n, mpcomplex *zx, mplapackint const incx);
mplapackint iMieeeck_mpfr(mplapackint const &ispec, mpreal const &zero, mpreal const &one);
mplapackint iMladiag(const char *diag);
mplapackint iMladlc(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda);
mplapackint iMladlr(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda);
mplapackint iMlaenv2stage_mpfr(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_mpfr(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaprec(const char *prec);
mplapackint iMlatrans(const char *trans);
mplapackint iMlauplo(const char *uplo);
mplapackint iMlazlc(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda);
mplapackint iMlazlr(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda);
mplapackint iMparam2stage_mpfr(mplapackint const ispec, const char *name, const char *opts, mplapackint const ni, mplapackint const nbi, mplapackint const ibi, mplapackint const nxi);
mplapackint iMparmq_mpfr(mplapackint const ispec, const char *name, const char *opts, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mplapackint const lwork);
mpreal Clangb(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, mpcomplex *ab, mplapackint const ldab, mpreal *work);
mpreal Clange(const char *norm, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *work);
mpreal Clangt(const char *norm, mplapackint const n, mpcomplex *dl, mpcomplex *d, mpcomplex *du);
mpreal Clanhb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, mpcomplex *ab, mplapackint const ldab, mpreal *work);
mpreal Clanhe(const char *norm, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *work);
mpreal Clanhf(const char *norm, const char *transr, const char *uplo, mplapackint const n, mpcomplex *a, mpreal *work);
mpreal Clanhp(const char *norm, const char *uplo, mplapackint const n, mpcomplex *ap, mpreal *work);
mpreal Clanhs(const char *norm, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *work);
mpreal Clanht(const char *norm, mplapackint const n, mpreal *d, mpcomplex *e);
mpreal Clansb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, mpcomplex *ab, mplapackint const ldab, mpreal *work);
mpreal Clansp(const char *norm, const char *uplo, mplapackint const n, mpcomplex *ap, mpreal *work);
mpreal Clansy(const char *norm, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *work);
mpreal Clantb(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const k, mpcomplex *ab, mplapackint const ldab, mpreal *work);
mpreal Clantp(const char *norm, const char *uplo, const char *diag, mplapackint const n, mpcomplex *ap, mpreal *work);
mpreal Clantr(const char *norm, const char *uplo, const char *diag, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *work);
mpreal Mmaxval(mpreal *dx, mplapackint const start, mplapackint const end, mplapackint incx);
mpreal RCsum1(mplapackint const n, mpcomplex *cx, mplapackint const incx);
mpreal Rla_gbrcond(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mpreal *ab, mplapackint const ldab, mpreal *afb, mplapackint const ldafb, mplapackint *ipiv, mplapackint const cmode, mpreal *c, mplapackint &info, mpreal *work, mplapackint *iwork);
mpreal Rla_gbrpvgrw(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const ncols, mpreal *ab, mplapackint const ldab, mpreal *afb, mplapackint const ldafb);
mpreal Rla_gercond(const char *trans, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *af, mplapackint const ldaf, mplapackint *ipiv, mplapackint const cmode, mpreal *c, mplapackint &info, mpreal *work, mplapackint *iwork);
mpreal Rla_gerpvgrw(mplapackint const n, mplapackint const ncols, mpreal *a, mplapackint const lda, mpreal *af, mplapackint const ldaf);
mpreal Rla_porcond(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *af, mplapackint const ldaf, mplapackint const cmode, mpreal *c, mplapackint &info, mpreal *work, mplapackint *iwork);
mpreal Rla_syrcond(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *af, mplapackint const ldaf, mplapackint *ipiv, mplapackint const cmode, mpreal *c, mplapackint &info, mpreal *work, mplapackint *iwork);
mpreal Rla_syrpvgrw(const char *uplo, mplapackint const n, mplapackint const info, mpreal *a, mplapackint const lda, mpreal *af, mplapackint const ldaf, mplapackint *ipiv, mpreal *work);
mpreal Rladiv2(mpreal const &a, mpreal const &b, mpreal const &c, mpreal const &d, mpreal const &r, mpreal const &t);
mpreal Rlamc3(mpreal a, mpreal b);
mpreal Rlamch_mpfr(const char *cmach);
mpreal Rlangb(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, mpreal *ab, mplapackint const ldab, mpreal *work);
mpreal Rlange(const char *norm, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *work);
mpreal Rlangt(const char *norm, mplapackint const n, mpreal *dl, mpreal *d, mpreal *du);
mpreal Rlanhs(const char *norm, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *work);
mpreal Rlansb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, mpreal *ab, mplapackint const ldab, mpreal *work);
mpreal Rlansf(const char *norm, const char *transr, const char *uplo, mplapackint const n, mpreal *a, mpreal *work);
mpreal Rlansp(const char *norm, const char *uplo, mplapackint const n, mpreal *ap, mpreal *work);
mpreal Rlanst(const char *norm, mplapackint const n, mpreal *d, mpreal *e);
mpreal Rlansy(const char *norm, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *work);
mpreal Rlantb(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const k, mpreal *ab, mplapackint const ldab, mpreal *work);
mpreal Rlantp(const char *norm, const char *uplo, const char *diag, mplapackint const n, mpreal *ap, mpreal *work);
mpreal Rlantr(const char *norm, const char *uplo, const char *diag, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *work);
mpreal Rlapy2(mpreal const x, mpreal const y);
mpreal Rlapy3(mpreal const x, mpreal const y, mpreal const z);
void CRrscl(mplapackint const n, mpreal const sa, mpcomplex *sx, mplapackint const incx);
void Cbbcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, mplapackint const m, mplapackint const p, mplapackint const q, mpreal *theta, mpreal *phi, mpcomplex *u1, mplapackint const ldu1, mpcomplex *u2, mplapackint const ldu2, mpcomplex *v1t, mplapackint const ldv1t, mpcomplex *v2t, mplapackint const ldv2t, mpreal *b11d, mpreal *b11e, mpreal *b12d, mpreal *b12e, mpreal *b21d, mpreal *b21e, mpreal *b22d, mpreal *b22e, mpreal *rwork, mplapackint const lrwork, mplapackint &info);
void Cbdsqr(const char *uplo, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, mpreal *d, mpreal *e, mpcomplex *vt, mplapackint const ldvt, mpcomplex *u, mplapackint const ldu, mpcomplex *c, mplapackint const ldc, mpreal *rwork, mplapackint &info);
void Cgbbrd(const char *vect, mplapackint const m, mplapackint const n, mplapackint const ncc, mplapackint const kl, mplapackint const ku, mpcomplex *ab, mplapackint const ldab, mpreal *d, mpreal *e, mpcomplex *q, mplapackint const ldq, mpcomplex *pt, mplapackint const ldpt, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cgbcon(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, mpcomplex *ab, mplapackint const ldab, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cgbequ(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpcomplex *ab, mplapackint const ldab, mpreal *r, mpreal *c, mpreal &rowcnd, mpreal &colcnd, mpreal &amax, mplapackint &info);
void Cgbequb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpcomplex *ab, mplapackint const ldab, mpreal *r, mpreal *c, mpreal &rowcnd, mpreal &colcnd, mpreal &amax, mplapackint &info);
void Cgbrfs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpcomplex *afb, mplapackint const ldafb, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cgbsv(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cgbsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpcomplex *afb, mplapackint const ldafb, mplapackint *ipiv, char *equed, mpreal *r, mpreal *c, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cgbtf2(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpcomplex *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Cgbtrf(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpcomplex *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Cgbtrs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cgebak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *scale, mplapackint const m, mpcomplex *v, mplapackint const ldv, mplapackint &info);
void Cgebal(const char *job, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint &ilo, mplapackint &ihi, mpreal *scale, mplapackint &info);
void Cgebd2(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *d, mpreal *e, mpcomplex *tauq, mpcomplex *taup, mpcomplex *work, mplapackint &info);
void Cgebrd(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *d, mpreal *e, mpcomplex *tauq, mpcomplex *taup, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgecon(const char *norm, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal const anorm, mpreal &rcond, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cgeequ(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *r, mpreal *c, mpreal &rowcnd, mpreal &colcnd, mpreal &amax, mplapackint &info);
void Cgeequb(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *r, mpreal *c, mpreal &rowcnd, mpreal &colcnd, mpreal &amax, mplapackint &info);
void Cgees(const char *jobvs, const char *sort, bool (*select)(mpcomplex), mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint &sdim, mpcomplex *w, mpcomplex *vs, mplapackint const ldvs, mpcomplex *work, mplapackint const lwork, mpreal *rwork, bool *bwork, mplapackint &info);
void Cgeesx(const char *jobvs, const char *sort, bool (*select)(mpcomplex), const char *sense, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint &sdim, mpcomplex *w, mpcomplex *vs, mplapackint const ldvs, mpreal &rconde, mpreal &rcondv, mpcomplex *work, mplapackint const lwork, mpreal *rwork, bool *bwork, mplapackint &info);
void Cgeev(const char *jobvl, const char *jobvr, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *w, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Cgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *w, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, mpreal *scale, mpreal &abnrm, mpreal *rconde, mpreal *rcondv, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Cgehd2(mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint &info);
void Cgehrd(mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgejsv(const char *joba, const char *jobu, const char *jobv, const char *jobr, const char *jobt, const char *jobp, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *sva, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mplapackint const ldv, mpcomplex *cwork, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cgelq(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const tsize, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgelq2(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint &info);
void Cgelqf(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgelqt(mplapackint const m, mplapackint const n, mplapackint const mb, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mpcomplex *work, mplapackint &info);
void Cgelqt3(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mplapackint &info);
void Cgels(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgelsd(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpreal *s, mpreal const rcond, mplapackint &rank, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, mplapackint &info);
void Cgelss(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpreal *s, mpreal const rcond, mplapackint &rank, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Cgelsy(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mplapackint *jpvt, mpreal const rcond, mplapackint &rank, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Cgemlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const tsize, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgemlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mpcomplex *v, mplapackint const ldv, mpcomplex *t, mplapackint const ldt, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint &info);
void Cgemqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const tsize, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgemqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const nb, mpcomplex *v, mplapackint const ldv, mpcomplex *t, mplapackint const ldt, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint &info);
void Cgeql2(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint &info);
void Cgeqlf(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgeqp3(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *jpvt, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Cgeqr(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const tsize, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgeqr2(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint &info);
void Cgeqr2p(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint &info);
void Cgeqrf(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgeqrfp(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgeqrt(mplapackint const m, mplapackint const n, mplapackint const nb, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mpcomplex *work, mplapackint &info);
void Cgeqrt2(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mplapackint &info);
void Cgeqrt3(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mplapackint &info);
void Cgerfs(const char *trans, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *af, mplapackint const ldaf, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cgerq2(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint &info);
void Cgerqf(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgesc2(mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *rhs, mplapackint *ipiv, mplapackint *jpiv, mpreal &scale);
void Cgesdd(const char *jobz, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *s, mpcomplex *u, mplapackint const ldu, mpcomplex *vt, mplapackint const ldvt, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, mplapackint &info);
void Cgesv(mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cgesvd(const char *jobu, const char *jobvt, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *s, mpcomplex *u, mplapackint const ldu, mpcomplex *vt, mplapackint const ldvt, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Cgesvdq(const char *joba, const char *jobp, const char *jobr, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *s, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mplapackint const ldv, mplapackint &numrank, mplapackint *iwork, mplapackint const liwork, mpcomplex *cwork, mplapackint const lcwork, mpreal *rwork, mplapackint const lrwork, mplapackint &info);
void Cgesvdx(const char *jobu, const char *jobvt, const char *range, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, mpreal *s, mpcomplex *u, mplapackint const ldu, mpcomplex *vt, mplapackint const ldvt, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, mplapackint &info);
void Cgesvj(const char *joba, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *sva, mplapackint const mv, mpcomplex *v, mplapackint const ldv, mpcomplex *cwork, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint &info);
void Cgesvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *af, mplapackint const ldaf, mplapackint *ipiv, char *equed, mpreal *r, mpreal *c, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cgetc2(mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mplapackint *jpiv, mplapackint &info);
void Cgetf2(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetrf(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetrf2(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetri(mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgetrs(const char *trans, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cgetsls(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgetsqrhrt(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cggbak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *lscale, mpreal *rscale, mplapackint const m, mpcomplex *v, mplapackint const ldv, mplapackint &info);
void Cggbal(const char *job, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mplapackint &ilo, mplapackint &ihi, mpreal *lscale, mpreal *rscale, mpreal *work, mplapackint &info);
void Cgges(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(mpcomplex, mpcomplex), mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mplapackint &sdim, mpcomplex *alpha, mpcomplex *beta, mpcomplex *vsl, mplapackint const ldvsl, mpcomplex *vsr, mplapackint const ldvsr, mpcomplex *work, mplapackint const lwork, mpreal *rwork, bool *bwork, mplapackint &info);
void Cgges3(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(mpcomplex, mpcomplex), mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mplapackint &sdim, mpcomplex *alpha, mpcomplex *beta, mpcomplex *vsl, mplapackint const ldvsl, mpcomplex *vsr, mplapackint const ldvsr, mpcomplex *work, mplapackint const lwork, mpreal *rwork, bool *bwork, mplapackint &info);
void Cggesx(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(mpcomplex, mpcomplex), const char *sense, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mplapackint &sdim, mpcomplex *alpha, mpcomplex *beta, mpcomplex *vsl, mplapackint const ldvsl, mpcomplex *vsr, mplapackint const ldvsr, mpreal *rconde, mpreal *rcondv, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cggev(const char *jobvl, const char *jobvr, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *alpha, mpcomplex *beta, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Cggev3(const char *jobvl, const char *jobvr, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *alpha, mpcomplex *beta, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Cggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *alpha, mpcomplex *beta, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mplapackint &ilo, mplapackint &ihi, mpreal *lscale, mpreal *rscale, mpreal &abnrm, mpreal &bbnrm, mpreal *rconde, mpreal *rcondv, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cggglm(mplapackint const n, mplapackint const m, mplapackint const p, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *d, mpcomplex *x, mpcomplex *y, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgghd3(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *q, mplapackint const ldq, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgghrd(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *q, mplapackint const ldq, mpcomplex *z, mplapackint const ldz, mplapackint &info);
void Cgglse(mplapackint const m, mplapackint const n, mplapackint const p, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *c, mpcomplex *d, mpcomplex *x, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cggqrf(mplapackint const n, mplapackint const m, mplapackint const p, mpcomplex *a, mplapackint const lda, mpcomplex *taua, mpcomplex *b, mplapackint const ldb, mpcomplex *taub, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cggrqf(mplapackint const m, mplapackint const p, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *taua, mpcomplex *b, mplapackint const ldb, mpcomplex *taub, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cggsvd3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const n, mplapackint const p, mplapackint &k, mplapackint &l, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpreal *alpha, mpreal *beta, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mplapackint const ldv, mpcomplex *q, mplapackint const ldq, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, mplapackint &info);
void Cggsvp3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpreal const tola, mpreal const tolb, mplapackint &k, mplapackint &l, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mplapackint const ldv, mpcomplex *q, mplapackint const ldq, mplapackint *iwork, mpreal *rwork, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgsvj0(const char *jobv, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *d, mpreal *sva, mplapackint const mv, mpcomplex *v, mplapackint const ldv, mpreal const eps, mpreal const sfmin, mpreal const tol, mplapackint const nsweep, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgsvj1(const char *jobv, mplapackint const m, mplapackint const n, mplapackint const n1, mpcomplex *a, mplapackint const lda, mpcomplex *d, mpreal *sva, mplapackint const mv, mpcomplex *v, mplapackint const ldv, mpreal const eps, mpreal const sfmin, mpreal const tol, mplapackint const nsweep, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgtcon(const char *norm, mplapackint const n, mpcomplex *dl, mpcomplex *d, mpcomplex *du, mpcomplex *du2, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpcomplex *work, mplapackint &info);
void Cgtrfs(const char *trans, mplapackint const n, mplapackint const nrhs, mpcomplex *dl, mpcomplex *d, mpcomplex *du, mpcomplex *dlf, mpcomplex *df, mpcomplex *duf, mpcomplex *du2, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cgtsv(mplapackint const n, mplapackint const nrhs, mpcomplex *dl, mpcomplex *d, mpcomplex *du, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cgtsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, mpcomplex *dl, mpcomplex *d, mpcomplex *du, mpcomplex *dlf, mpcomplex *df, mpcomplex *duf, mpcomplex *du2, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cgttrf(mplapackint const n, mpcomplex *dl, mpcomplex *d, mpcomplex *du, mpcomplex *du2, mplapackint *ipiv, mplapackint &info);
void Cgttrs(const char *trans, mplapackint const n, mplapackint const nrhs, mpcomplex *dl, mpcomplex *d, mpcomplex *du, mpcomplex *du2, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cgtts2(mplapackint const itrans, mplapackint const n, mplapackint const nrhs, mpcomplex *dl, mpcomplex *d, mpcomplex *du, mpcomplex *du2, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb);
void Chb2st_kernels(const char *uplo, bool const wantz, mplapackint const ttype, mplapackint const st, mplapackint const ed, mplapackint const sweep, mplapackint const n, mplapackint const nb, mplapackint const ib, mpcomplex *a, mplapackint const lda, mpcomplex *v, mpcomplex *tau, mplapackint const ldvt, mpcomplex *work);
void Chbev(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Chbev_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Chbevd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpcomplex *q, mplapackint const ldq, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpcomplex *q, mplapackint const ldq, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbgst(const char *vect, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpcomplex *ab, mplapackint const ldab, mpcomplex *bb, mplapackint const ldbb, mpcomplex *x, mplapackint const ldx, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Chbgv(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpcomplex *ab, mplapackint const ldab, mpcomplex *bb, mplapackint const ldbb, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Chbgvd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpcomplex *ab, mplapackint const ldab, mpcomplex *bb, mplapackint const ldbb, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbgvx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpcomplex *ab, mplapackint const ldab, mpcomplex *bb, mplapackint const ldbb, mpcomplex *q, mplapackint const ldq, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbtrd(const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpreal *d, mpreal *e, mpcomplex *q, mplapackint const ldq, mpcomplex *work, mplapackint &info);
void Checon(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpcomplex *work, mplapackint &info);
void Checon_3(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpcomplex *work, mplapackint &info);
void Checon_rook(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpcomplex *work, mplapackint &info);
void Cheequb(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *s, mpreal &scond, mpreal &amax, mpcomplex *work, mplapackint &info);
void Cheev(const char *jobz, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *w, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Cheev_2stage(const char *jobz, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *w, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Cheevd(const char *jobz, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *w, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *w, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevr(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpcomplex *z, mplapackint const ldz, mplapackint *isuppz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevr_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpcomplex *z, mplapackint const ldz, mplapackint *isuppz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cheevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chegs2(mplapackint const itype, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Chegst(mplapackint const itype, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Chegv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpreal *w, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Chegv_2stage(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpreal *w, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Chegvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpreal *w, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chegvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cherfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *af, mplapackint const ldaf, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Chesv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chesv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chesv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chesv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chesv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chesvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *af, mplapackint const ldaf, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Cheswapr(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Chetd2(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *d, mpreal *e, mpcomplex *tau, mplapackint &info);
void Chetf2(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Chetf2_rk(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mplapackint &info);
void Chetf2_rook(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Chetrd(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *d, mpreal *e, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chetrd_2stage(const char *vect, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *d, mpreal *e, mpcomplex *tau, mpcomplex *hous2, mplapackint const lhous2, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chetrd_hb2st(const char *stage1, const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpreal *d, mpreal *e, mpcomplex *hous, mplapackint const lhous, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chetrd_he2hb(const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *a, mplapackint const lda, mpcomplex *ab, mplapackint const ldab, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chetrf(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chetrf_aa(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chetrf_aa_2stage(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chetrf_rk(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chetrf_rook(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chetri(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint &info);
void Chetri2(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chetri2x(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint const nb, mplapackint &info);
void Chetri_3(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chetri_3x(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpcomplex *work, mplapackint const nb, mplapackint &info);
void Chetri_rook(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint &info);
void Chetrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Chetrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint &info);
void Chetrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Chetrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Chetrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Chetrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Chfrk(const char *transr, const char *uplo, const char *trans, mplapackint const n, mplapackint const k, mpreal const alpha, mpcomplex *a, mplapackint const lda, mpreal const beta, mpcomplex *c);
void Chgeqz(const char *job, const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpcomplex *h, mplapackint const ldh, mpcomplex *t, mplapackint const ldt, mpcomplex *alpha, mpcomplex *beta, mpcomplex *q, mplapackint const ldq, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Chpcon(const char *uplo, mplapackint const n, mpcomplex *ap, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpcomplex *work, mplapackint &info);
void Chpev(const char *jobz, const char *uplo, mplapackint const n, mpcomplex *ap, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Chpevd(const char *jobz, const char *uplo, mplapackint const n, mpcomplex *ap, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chpevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpcomplex *ap, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chpgst(mplapackint const itype, const char *uplo, mplapackint const n, mpcomplex *ap, mpcomplex *bp, mplapackint &info);
void Chpgv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpcomplex *ap, mpcomplex *bp, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Chpgvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpcomplex *ap, mpcomplex *bp, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chpgvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, mpcomplex *ap, mpcomplex *bp, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *afp, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Chpsv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Chpsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *afp, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Chptrd(const char *uplo, mplapackint const n, mpcomplex *ap, mpreal *d, mpreal *e, mpcomplex *tau, mplapackint &info);
void Chptrf(const char *uplo, mplapackint const n, mpcomplex *ap, mplapackint *ipiv, mplapackint &info);
void Chptri(const char *uplo, mplapackint const n, mpcomplex *ap, mplapackint *ipiv, mpcomplex *work, mplapackint &info);
void Chptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Chsein(const char *side, const char *eigsrc, const char *initv, bool *select, mplapackint const n, mpcomplex *h, mplapackint const ldh, mpcomplex *w, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpcomplex *work, mpreal *rwork, mplapackint *ifaill, mplapackint *ifailr, mplapackint &info);
void Chseqr(const char *job, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpcomplex *h, mplapackint const ldh, mpcomplex *w, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Clabrd(mplapackint const m, mplapackint const n, mplapackint const nb, mpcomplex *a, mplapackint const lda, mpreal *d, mpreal *e, mpcomplex *tauq, mpcomplex *taup, mpcomplex *x, mplapackint const ldx, mpcomplex *y, mplapackint const ldy);
void Clacgv(mplapackint const n, mpcomplex *x, mplapackint const incx);
void Clacn2(mplapackint const n, mpcomplex *v, mpcomplex *x, mpreal &est, mplapackint &kase, mplapackint *isave);
void Clacon(mplapackint const n, mpcomplex *v, mpcomplex *x, mpreal &est, mplapackint &kase);
void Clacp2(const char *uplo, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb);
void Clacpy(const char *uplo, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb);
void Clacrm(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpcomplex *c, mplapackint const ldc, mpreal *rwork);
void Clacrt(mplapackint const n, mpcomplex *cx, mplapackint const incx, mpcomplex *cy, mplapackint const incy, mpcomplex const c, mpcomplex const s);
void Claed0(mplapackint const qsiz, mplapackint const n, mpreal *d, mpreal *e, mpcomplex *q, mplapackint const ldq, mpcomplex *qstore, mplapackint const ldqs, mpreal *rwork, mplapackint *iwork, mplapackint &info);
void Claed7(mplapackint const n, mplapackint const cutpnt, mplapackint const qsiz, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, mpreal *d, mpcomplex *q, mplapackint const ldq, mpreal rho, mplapackint *indxq, mpreal *qstore, mplapackint *qptr, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, mpreal *givnum, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint &info);
void Claed8(mplapackint &k, mplapackint const n, mplapackint const qsiz, mpcomplex *q, mplapackint const ldq, mpreal *d, mpreal &rho, mplapackint const cutpnt, mpreal *z, mpreal *dlamda, mpcomplex *q2, mplapackint const ldq2, mpreal *w, mplapackint *indxp, mplapackint *indx, mplapackint *indxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mpreal *givnum, mplapackint &info);
void Claein(bool const rightv, bool const noinit, mplapackint const n, mpcomplex *h, mplapackint const ldh, mpcomplex const w, mpcomplex *v, mpcomplex *b, mplapackint const ldb, mpreal *rwork, mpreal const eps3, mpreal const smlnum, mplapackint &info);
void Claesy(mpcomplex const a, mpcomplex const b, mpcomplex const c, mpcomplex &rt1, mpcomplex &rt2, mpcomplex &evscal, mpcomplex &cs1, mpcomplex &sn1);
void Claev2(mpcomplex const a, mpcomplex const b, mpcomplex const c, mpreal &rt1, mpreal &rt2, mpreal &cs1, mpcomplex &sn1);
void Clags2(bool const upper, mpreal const a1, mpcomplex const a2, mpreal const a3, mpreal const b1, mpcomplex const b2, mpreal const b3, mpreal &csu, mpcomplex &snu, mpreal &csv, mpcomplex &snv, mpreal &csq, mpcomplex &snq);
void Clagtm(const char *trans, mplapackint const n, mplapackint const nrhs, mpreal const alpha, mpcomplex *dl, mpcomplex *d, mpcomplex *du, mpcomplex *x, mplapackint const ldx, mpreal const beta, mpcomplex *b, mplapackint const ldb);
void Clahef(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *w, mplapackint const ldw, mplapackint &info);
void Clahef_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *h, mplapackint const ldh, mpcomplex *work);
void Clahef_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpcomplex *w, mplapackint const ldw, mplapackint &info);
void Clahef_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *w, mplapackint const ldw, mplapackint &info);
void Clahqr(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpcomplex *h, mplapackint const ldh, mpcomplex *w, mplapackint const iloz, mplapackint const ihiz, mpcomplex *z, mplapackint const ldz, mplapackint &info);
void Clahr2(mplapackint const n, mplapackint const k, mplapackint const nb, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *t, mplapackint const ldt, mpcomplex *y, mplapackint const ldy);
void Claic1(mplapackint const job, mplapackint const j, mpcomplex *x, mpreal const sest, mpcomplex *w, mpcomplex const gamma, mpreal &sestpr, mpcomplex &s, mpcomplex &c);
void Clals0(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const nrhs, mpcomplex *b, mplapackint const ldb, mpcomplex *bx, mplapackint const ldbx, mplapackint *perm, mplapackint const givptr, mplapackint *givcol, mplapackint const ldgcol, mpreal *givnum, mplapackint const ldgnum, mpreal *poles, mpreal *difl, mpreal *difr, mpreal *z, mplapackint const k, mpreal const c, mpreal const s, mpreal *rwork, mplapackint &info);
void Clalsa(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, mpcomplex *b, mplapackint const ldb, mpcomplex *bx, mplapackint const ldbx, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint *k, mpreal *difl, mpreal *difr, mpreal *z, mpreal *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, mpreal *givnum, mpreal *c, mpreal *s, mpreal *rwork, mplapackint *iwork, mplapackint &info);
void Clalsd(const char *uplo, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, mpreal *d, mpreal *e, mpcomplex *b, mplapackint const ldb, mpreal const rcond, mplapackint &rank, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint &info);
void Clamswlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Clamtsqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Clapll(mplapackint const n, mpcomplex *x, mplapackint const incx, mpcomplex *y, mplapackint const incy, mpreal &ssmin);
void Clapmr(bool const forwrd, mplapackint const m, mplapackint const n, mpcomplex *x, mplapackint const ldx, mplapackint *k);
void Clapmt(bool const forwrd, mplapackint const m, mplapackint const n, mpcomplex *x, mplapackint const ldx, mplapackint *k);
void Claqgb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpcomplex *ab, mplapackint const ldab, mpreal *r, mpreal *c, mpreal const rowcnd, mpreal const colcnd, mpreal const amax, char *equed);
void Claqge(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *r, mpreal *c, mpreal const rowcnd, mpreal const colcnd, mpreal const amax, char *equed);
void Claqhb(const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpreal *s, mpreal const scond, mpreal const amax, char *equed);
void Claqhe(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *s, mpreal const scond, mpreal const amax, char *equed);
void Claqhp(const char *uplo, mplapackint const n, mpcomplex *ap, mpreal *s, mpreal const scond, mpreal const amax, char *equed);
void Claqp2(mplapackint const m, mplapackint const n, mplapackint const offset, mpcomplex *a, mplapackint const lda, mplapackint *jpvt, mpcomplex *tau, mpreal *vn1, mpreal *vn2, mpcomplex *work);
void Claqps(mplapackint const m, mplapackint const n, mplapackint const offset, mplapackint const nb, mplapackint &kb, mpcomplex *a, mplapackint const lda, mplapackint *jpvt, mpcomplex *tau, mpreal *vn1, mpreal *vn2, mpcomplex *auxv, mpcomplex *f, mplapackint const ldf);
void Claqr0(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpcomplex *h, mplapackint const ldh, mpcomplex *w, mplapackint const iloz, mplapackint const ihiz, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Claqr1(mplapackint const n, mpcomplex *h, mplapackint const ldh, mpcomplex const s1, mpcomplex const s2, mpcomplex *v);
void Claqr2(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, mpcomplex *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, mpcomplex *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, mpcomplex *sh, mpcomplex *v, mplapackint const ldv, mplapackint const nh, mpcomplex *t, mplapackint const ldt, mplapackint const nv, mpcomplex *wv, mplapackint const ldwv, mpcomplex *work, mplapackint const lwork);
void Claqr3(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, mpcomplex *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, mpcomplex *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, mpcomplex *sh, mpcomplex *v, mplapackint const ldv, mplapackint const nh, mpcomplex *t, mplapackint const ldt, mplapackint const nv, mpcomplex *wv, mplapackint const ldwv, mpcomplex *work, mplapackint const lwork);
void Claqr4(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpcomplex *h, mplapackint const ldh, mpcomplex *w, mplapackint const iloz, mplapackint const ihiz, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Claqr5(bool const wantt, bool const wantz, mplapackint const kacc22, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nshfts, mpcomplex *s, mpcomplex *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, mpcomplex *z, mplapackint const ldz, mpcomplex *v, mplapackint const ldv, mpcomplex *u, mplapackint const ldu, mplapackint const nv, mpcomplex *wv, mplapackint const ldwv, mplapackint const nh, mpcomplex *wh, mplapackint const ldwh);
void Claqsb(const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpreal *s, mpreal const scond, mpreal const amax, char *equed);
void Claqsp(const char *uplo, mplapackint const n, mpcomplex *ap, mpreal *s, mpreal const scond, mpreal const amax, char *equed);
void Claqsy(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *s, mpreal const scond, mpreal const amax, char *equed);
void Clar1v(mplapackint const n, mplapackint const b1, mplapackint const bn, mpreal const lambda, mpreal *d, mpreal *l, mpreal *ld, mpreal *lld, mpreal const pivmin, mpreal const gaptol, mpcomplex *z, bool const wantnc, mplapackint &negcnt, mpreal &ztz, mpreal &mingma, mplapackint &r, mplapackint *isuppz, mpreal &nrminv, mpreal &resid, mpreal &rqcorr, mpreal *work);
void Clar2v(mplapackint const n, mpcomplex *x, mpcomplex *y, mpcomplex *z, mplapackint const incx, mpreal *c, mpcomplex *s, mplapackint const incc);
void Clarcm(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *c, mplapackint const ldc, mpreal *rwork);
void Clarf(const char *side, mplapackint const m, mplapackint const n, mpcomplex *v, mplapackint const incv, mpcomplex const tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work);
void Clarfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *v, mplapackint const ldv, mpcomplex *t, mplapackint const ldt, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const ldwork);
void Clarfb_gett(const char *ident, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *t, mplapackint const ldt, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const ldwork);
void Clarfg(mplapackint const n, mpcomplex &alpha, mpcomplex *x, mplapackint const incx, mpcomplex &tau);
void Clarfgp(mplapackint const n, mpcomplex &alpha, mpcomplex *x, mplapackint const incx, mpcomplex &tau);
void Clarft(const char *direct, const char *storev, mplapackint const n, mplapackint const k, mpcomplex *v, mplapackint const ldv, mpcomplex *tau, mpcomplex *t, mplapackint const ldt);
void Clarfx(const char *side, mplapackint const m, mplapackint const n, mpcomplex *v, mpcomplex const tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work);
void Clarfy(const char *uplo, mplapackint const n, mpcomplex *v, mplapackint const incv, mpcomplex const tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work);
void Clargv(mplapackint const n, mpcomplex *x, mplapackint const incx, mpcomplex *y, mplapackint const incy, mpreal *c, mplapackint const incc);
void Clarnv(mplapackint const idist, mplapackint *iseed, mplapackint const n, mpcomplex *x);
void Clarrv(mplapackint const n, mpreal const vl, mpreal const, mpreal *d, mpreal *l, mpreal const pivmin, mplapackint *isplit, mplapackint const m, mplapackint const dol, mplapackint const dou, mpreal const minrgp, mpreal &rtol1, mpreal &rtol2, mpreal *w, mpreal *werr, mpreal *wgap, mplapackint *iblock, mplapackint *indexw, mpreal *gers, mpcomplex *z, mplapackint const ldz, mplapackint *isuppz, mpreal *work, mplapackint *iwork, mplapackint &info);
void Clarscl2(mplapackint const m, mplapackint const n, mpreal *d, mpcomplex *x, mplapackint const ldx);
void Clartg(mpcomplex const f, mpcomplex const g, mpreal &cs, mpcomplex &sn, mpcomplex &r);
void Clartv(mplapackint const n, mpcomplex *x, mplapackint const incx, mpcomplex *y, mplapackint const incy, mpreal *c, mpcomplex *s, mplapackint const incc);
void Clarz(const char *side, mplapackint const m, mplapackint const n, mplapackint const l, mpcomplex *v, mplapackint const incv, mpcomplex const tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work);
void Clarzb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpcomplex *v, mplapackint const ldv, mpcomplex *t, mplapackint const ldt, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const ldwork);
void Clarzt(const char *direct, const char *storev, mplapackint const n, mplapackint const k, mpcomplex *v, mplapackint const ldv, mpcomplex *tau, mpcomplex *t, mplapackint const ldt);
void Clascl(const char *type, mplapackint const kl, mplapackint const ku, mpreal const cfrom, mpreal const cto, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint &info);
void Clascl2(mplapackint const m, mplapackint const n, mpreal *d, mpcomplex *x, mplapackint const ldx);
void Claset(const char *uplo, mplapackint const m, mplapackint const n, mpcomplex const alpha, mpcomplex const beta, mpcomplex *a, mplapackint const lda);
void Clasr(const char *side, const char *pivot, const char *direct, mplapackint const m, mplapackint const n, mpreal *c, mpreal *s, mpcomplex *a, mplapackint const lda);
void Classq(mplapackint const n, mpcomplex *x, mplapackint const incx, mpreal &scale, mpreal &sumsq);
void Claswlq(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Claswp(mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint const k1, mplapackint const k2, mplapackint *ipiv, mplapackint const incx);
void Clasyf(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *w, mplapackint const ldw, mplapackint &info);
void Clasyf_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *h, mplapackint const ldh, mpcomplex *work);
void Clasyf_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpcomplex *w, mplapackint const ldw, mplapackint &info);
void Clasyf_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *w, mplapackint const ldw, mplapackint &info);
void Clatbs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpcomplex *x, mpreal &scale, mpreal *cnorm, mplapackint &info);
void Clatdf(mplapackint const ijob, mplapackint const n, mpcomplex *z, mplapackint const ldz, mpcomplex *rhs, mpreal &rdsum, mpreal &rdscal, mplapackint *ipiv, mplapackint *jpiv);
void Clatps(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mpcomplex *ap, mpcomplex *x, mpreal &scale, mpreal *cnorm, mplapackint &info);
void Clatrd(const char *uplo, mplapackint const n, mplapackint const nb, mpcomplex *a, mplapackint const lda, mpreal *e, mpcomplex *tau, mpcomplex *w, mplapackint const ldw);
void Clatrs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *x, mpreal &scale, mpreal *cnorm, mplapackint &info);
void Clatrz(mplapackint const m, mplapackint const n, mplapackint const l, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work);
void Clatsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Claunhr_col_getrfnp(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *d, mplapackint &info);
void Claunhr_col_getrfnp2(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *d, mplapackint &info);
void Clauu2(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint &info);
void Clauum(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint &info);
void Cpbcon(const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpreal const anorm, mpreal &rcond, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cpbequ(const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpreal *s, mpreal &scond, mpreal &amax, mplapackint &info);
void Cpbrfs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpcomplex *afb, mplapackint const ldafb, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cpbstf(const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mplapackint &info);
void Cpbsv(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cpbsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpcomplex *afb, mplapackint const ldafb, char *equed, mpreal *s, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cpbtf2(const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mplapackint &info);
void Cpbtrf(const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mplapackint &info);
void Cpbtrs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cpftrf(const char *transr, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint &info);
void Cpftri(const char *transr, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint &info);
void Cpftrs(const char *transr, const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cpocon(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal const anorm, mpreal &rcond, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cpoequ(mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *s, mpreal &scond, mpreal &amax, mplapackint &info);
void Cpoequb(mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *s, mpreal &scond, mpreal &amax, mplapackint &info);
void Cporfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *af, mplapackint const ldaf, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cposv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cposvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *af, mplapackint const ldaf, char *equed, mpreal *s, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cpotf2(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint &info);
void Cpotrf(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint &info);
void Cpotrf2(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint &info);
void Cpotri(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint &info);
void Cpotrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cppcon(const char *uplo, mplapackint const n, mpcomplex *ap, mpreal const anorm, mpreal &rcond, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cppequ(const char *uplo, mplapackint const n, mpcomplex *ap, mpreal *s, mpreal &scond, mpreal &amax, mplapackint &info);
void Cpprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *afp, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cppsv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cppsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *afp, char *equed, mpreal *s, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cpptrf(const char *uplo, mplapackint const n, mpcomplex *ap, mplapackint &info);
void Cpptri(const char *uplo, mplapackint const n, mpcomplex *ap, mplapackint &info);
void Cpptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cpstf2(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, mpreal const tol, mpreal *work, mplapackint &info);
void Cpstrf(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, mpreal const tol, mpreal *work, mplapackint &info);
void Cptcon(mplapackint const n, mpreal *d, mpcomplex *e, mpreal const anorm, mpreal &rcond, mpreal *rwork, mplapackint &info);
void Cpteqr(const char *compz, mplapackint const n, mpreal *d, mpreal *e, mpcomplex *z, mplapackint const ldz, mpreal *work, mplapackint &info);
void Cptrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *d, mpcomplex *e, mpreal *df, mpcomplex *ef, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cptsv(mplapackint const n, mplapackint const nrhs, mpreal *d, mpcomplex *e, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cptsvx(const char *fact, mplapackint const n, mplapackint const nrhs, mpreal *d, mpcomplex *e, mpreal *df, mpcomplex *ef, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cpttrf(mplapackint const n, mpreal *d, mpcomplex *e, mplapackint &info);
void Cpttrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *d, mpcomplex *e, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cptts2(mplapackint const iuplo, mplapackint const n, mplapackint const nrhs, mpreal *d, mpcomplex *e, mpcomplex *b, mplapackint const ldb);
void Crot(mplapackint const n, mpcomplex *cx, mplapackint const incx, mpcomplex *cy, mplapackint const incy, mpreal const c, mpcomplex const s);
void Cspcon(const char *uplo, mplapackint const n, mpcomplex *ap, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpcomplex *work, mplapackint &info);
void Cspmv(const char *uplo, mplapackint const n, mpcomplex const alpha, mpcomplex *ap, mpcomplex *x, mplapackint const incx, mpcomplex const beta, mpcomplex *y, mplapackint const incy);
void Cspr(const char *uplo, mplapackint const n, mpcomplex const alpha, mpcomplex *x, mplapackint const incx, mpcomplex *ap);
void Csprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *afp, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Cspsv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cspsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *afp, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Csptrf(const char *uplo, mplapackint const n, mpcomplex *ap, mplapackint *ipiv, mplapackint &info);
void Csptri(const char *uplo, mplapackint const n, mpcomplex *ap, mplapackint *ipiv, mpcomplex *work, mplapackint &info);
void Csptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Cstedc(const char *compz, mplapackint const n, mpreal *d, mpreal *e, mpcomplex *z, mplapackint const ldz, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cstein(mplapackint const n, mpreal *d, mpreal *e, mplapackint const m, mpreal *w, mplapackint *iblock, mplapackint *isplit, mpcomplex *z, mplapackint const ldz, mpreal *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cstemr(const char *jobz, const char *range, mplapackint const n, mpreal *d, mpreal *e, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mplapackint &m, mpreal *w, mpcomplex *z, mplapackint const ldz, mplapackint const nzc, mplapackint *isuppz, bool &tryrac, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Csteqr(const char *compz, mplapackint const n, mpreal *d, mpreal *e, mpcomplex *z, mplapackint const ldz, mpreal *work, mplapackint &info);
void Csycon(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpcomplex *work, mplapackint &info);
void Csycon_3(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpcomplex *work, mplapackint &info);
void Csycon_rook(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpcomplex *work, mplapackint &info);
void Csyconv(const char *uplo, const char *way, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *e, mplapackint &info);
void Csyconvf(const char *uplo, const char *way, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mplapackint &info);
void Csyconvf_rook(const char *uplo, const char *way, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mplapackint &info);
void Csyequb(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *s, mpreal &scond, mpreal &amax, mpcomplex *work, mplapackint &info);
void Csymv(const char *uplo, mplapackint const n, mpcomplex const alpha, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const incx, mpcomplex const beta, mpcomplex *y, mplapackint const incy);
void Csyr(const char *uplo, mplapackint const n, mpcomplex const alpha, mpcomplex *x, mplapackint const incx, mpcomplex *a, mplapackint const lda);
void Csyrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *af, mplapackint const ldaf, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Csysv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csysv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csysv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csysv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csysv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csysvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *af, mplapackint const ldaf, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Csyswapr(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Csytf2(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Csytf2_rk(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mplapackint &info);
void Csytf2_rook(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Csytrf(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csytrf_aa(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csytrf_aa_2stage(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csytrf_rk(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csytrf_rook(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csytri(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint &info);
void Csytri2(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csytri2x(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint const nb, mplapackint &info);
void Csytri_3(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csytri_3x(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpcomplex *work, mplapackint const nb, mplapackint &info);
void Csytri_rook(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *work, mplapackint &info);
void Csytrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Csytrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint &info);
void Csytrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Csytrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Csytrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Csytrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Ctbcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpreal &rcond, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Ctbrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Ctbtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Ctfsm(const char *transr, const char *side, const char *uplo, const char *trans, const char *diag, mplapackint const m, mplapackint const n, mpcomplex const alpha, mpcomplex *a, mpcomplex *b, mplapackint const ldb);
void Ctftri(const char *transr, const char *uplo, const char *diag, mplapackint const n, mpcomplex *a, mplapackint &info);
void Ctfttp(const char *transr, const char *uplo, mplapackint const n, mpcomplex *arf, mpcomplex *ap, mplapackint &info);
void Ctfttr(const char *transr, const char *uplo, mplapackint const n, mpcomplex *arf, mpcomplex *a, mplapackint const lda, mplapackint &info);
void Ctgevc(const char *side, const char *howmny, bool *select, mplapackint const n, mpcomplex *s, mplapackint const lds, mpcomplex *p, mplapackint const ldp, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Ctgex2(bool const wantq, bool const wantz, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *q, mplapackint const ldq, mpcomplex *z, mplapackint const ldz, mplapackint const j1, mplapackint &info);
void Ctgexc(bool const wantq, bool const wantz, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *q, mplapackint const ldq, mpcomplex *z, mplapackint const ldz, mplapackint const ifst, mplapackint &ilst, mplapackint &info);
void Ctgsen(mplapackint const ijob, bool const wantq, bool const wantz, bool *select, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *alpha, mpcomplex *beta, mpcomplex *q, mplapackint const ldq, mpcomplex *z, mplapackint const ldz, mplapackint &m, mpreal &pl, mpreal &pr, mpreal *dif, mpcomplex *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Ctgsja(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mplapackint const k, mplapackint const l, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpreal const tola, mpreal const tolb, mpreal *alpha, mpreal *beta, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mplapackint const ldv, mpcomplex *q, mplapackint const ldq, mpcomplex *work, mplapackint &ncycle, mplapackint &info);
void Ctgsna(const char *job, const char *howmny, bool *select, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mpreal *s, mpreal *dif, mplapackint const mm, mplapackint &m, mpcomplex *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Ctgsy2(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *c, mplapackint const ldc, mpcomplex *d, mplapackint const ldd, mpcomplex *e, mplapackint const lde, mpcomplex *f, mplapackint const ldf, mpreal &scale, mpreal &rdsum, mpreal &rdscal, mplapackint &info);
void Ctgsyl(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *c, mplapackint const ldc, mpcomplex *d, mplapackint const ldd, mpcomplex *e, mplapackint const lde, mpcomplex *f, mplapackint const ldf, mpreal &scale, mpreal &dif, mpcomplex *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Ctpcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mpcomplex *ap, mpreal &rcond, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Ctplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *t, mplapackint const ldt, mpcomplex *work, mplapackint &info);
void Ctplqt2(mplapackint const m, mplapackint const n, mplapackint const l, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *t, mplapackint const ldt, mplapackint &info);
void Ctpmlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const mb, mpcomplex *v, mplapackint const ldv, mpcomplex *t, mplapackint const ldt, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint &info);
void Ctpmqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const nb, mpcomplex *v, mplapackint const ldv, mpcomplex *t, mplapackint const ldt, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint &info);
void Ctpqrt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *t, mplapackint const ldt, mpcomplex *work, mplapackint &info);
void Ctpqrt2(mplapackint const m, mplapackint const n, mplapackint const l, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *t, mplapackint const ldt, mplapackint &info);
void Ctprfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpcomplex *v, mplapackint const ldv, mpcomplex *t, mplapackint const ldt, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const ldwork);
void Ctprfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Ctptri(const char *uplo, const char *diag, mplapackint const n, mpcomplex *ap, mplapackint &info);
void Ctptrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Ctpttf(const char *transr, const char *uplo, mplapackint const n, mpcomplex *ap, mpcomplex *arf, mplapackint &info);
void Ctpttr(const char *uplo, mplapackint const n, mpcomplex *ap, mpcomplex *a, mplapackint const lda, mplapackint &info);
void Ctrcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal &rcond, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Ctrevc(const char *side, const char *howmny, bool *select, mplapackint const n, mpcomplex *t, mplapackint const ldt, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Ctrevc3(const char *side, const char *howmny, bool *select, mplapackint const n, mpcomplex *t, mplapackint const ldt, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint &info);
void Ctrexc(const char *compq, mplapackint const n, mpcomplex *t, mplapackint const ldt, mpcomplex *q, mplapackint const ldq, mplapackint const ifst, mplapackint const ilst, mplapackint &info);
void Ctrrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Ctrsen(const char *job, const char *compq, bool *select, mplapackint const n, mpcomplex *t, mplapackint const ldt, mpcomplex *q, mplapackint const ldq, mpcomplex *w, mplapackint &m, mpreal &s, mpreal &sep, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Ctrsna(const char *job, const char *howmny, bool *select, mplapackint const n, mpcomplex *t, mplapackint const ldt, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mpreal *s, mpreal *sep, mplapackint const mm, mplapackint &m, mpcomplex *work, mplapackint const ldwork, mpreal *rwork, mplapackint &info);
void Ctrsyl(const char *trana, const char *tranb, mplapackint const isgn, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *c, mplapackint const ldc, mpreal &scale, mplapackint &info);
void Ctrti2(const char *uplo, const char *diag, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint &info);
void Ctrtri(const char *uplo, const char *diag, mplapackint const n, mpcomplex *a, mplapackint const lda, mplapackint &info);
void Ctrtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Ctrttf(const char *transr, const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *arf, mplapackint &info);
void Ctrttp(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *ap, mplapackint &info);
void Ctzrzf(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb(const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, mpcomplex *x11, mplapackint const ldx11, mpcomplex *x12, mplapackint const ldx12, mpcomplex *x21, mplapackint const ldx21, mpcomplex *x22, mplapackint const ldx22, mpreal *theta, mpreal *phi, mpcomplex *taup1, mpcomplex *taup2, mpcomplex *tauq1, mpcomplex *tauq2, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb1(mplapackint const m, mplapackint const p, mplapackint const q, mpcomplex *x11, mplapackint const ldx11, mpcomplex *x21, mplapackint const ldx21, mpreal *theta, mpreal *phi, mpcomplex *taup1, mpcomplex *taup2, mpcomplex *tauq1, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb2(mplapackint const m, mplapackint const p, mplapackint const q, mpcomplex *x11, mplapackint const ldx11, mpcomplex *x21, mplapackint const ldx21, mpreal *theta, mpreal *phi, mpcomplex *taup1, mpcomplex *taup2, mpcomplex *tauq1, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb3(mplapackint const m, mplapackint const p, mplapackint const q, mpcomplex *x11, mplapackint const ldx11, mpcomplex *x21, mplapackint const ldx21, mpreal *theta, mpreal *phi, mpcomplex *taup1, mpcomplex *taup2, mpcomplex *tauq1, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb4(mplapackint const m, mplapackint const p, mplapackint const q, mpcomplex *x11, mplapackint const ldx11, mpcomplex *x21, mplapackint const ldx21, mpreal *theta, mpreal *phi, mpcomplex *taup1, mpcomplex *taup2, mpcomplex *tauq1, mpcomplex *phantom, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb5(mplapackint const m1, mplapackint const m2, mplapackint const n, mpcomplex *x1, mplapackint const incx1, mpcomplex *x2, mplapackint const incx2, mpcomplex *q1, mplapackint const ldq1, mpcomplex *q2, mplapackint const ldq2, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb6(mplapackint const m1, mplapackint const m2, mplapackint const n, mpcomplex *x1, mplapackint const incx1, mpcomplex *x2, mplapackint const incx2, mpcomplex *q1, mplapackint const ldq1, mpcomplex *q2, mplapackint const ldq2, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cuncsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, mpcomplex *x11, mplapackint const ldx11, mpcomplex *x12, mplapackint const ldx12, mpcomplex *x21, mplapackint const ldx21, mpcomplex *x22, mplapackint const ldx22, mpreal *theta, mpcomplex *u1, mplapackint const ldu1, mpcomplex *u2, mplapackint const ldu2, mpcomplex *v1t, mplapackint const ldv1t, mpcomplex *v2t, mplapackint const ldv2t, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cuncsd2by1(const char *jobu1, const char *jobu2, const char *jobv1t, mplapackint const m, mplapackint const p, mplapackint const q, mpcomplex *x11, mplapackint const ldx11, mpcomplex *x21, mplapackint const ldx21, mpreal *theta, mpcomplex *u1, mplapackint const ldu1, mpcomplex *u2, mplapackint const ldu2, mpcomplex *v1t, mplapackint const ldv1t, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cung2l(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint &info);
void Cung2r(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint &info);
void Cungbr(const char *vect, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunghr(mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cungl2(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint &info);
void Cunglq(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cungql(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cungqr(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cungr2(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint &info);
void Cungrq(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cungtr(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cungtsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cungtsqr_row(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunhr_col(mplapackint const m, mplapackint const n, mplapackint const nb, mpcomplex *a, mplapackint const lda, mpcomplex *t, mplapackint const ldt, mpcomplex *d, mplapackint &info);
void Cunm22(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const n1, mplapackint const n2, mpcomplex *q, mplapackint const ldq, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunm2l(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint &info);
void Cunm2r(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint &info);
void Cunmbr(const char *vect, const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunmhr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunml2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint &info);
void Cunmlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunmql(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunmqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunmr2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint &info);
void Cunmr3(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint &info);
void Cunmrq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunmrz(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cunmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cupgtr(const char *uplo, mplapackint const n, mpcomplex *ap, mpcomplex *tau, mpcomplex *q, mplapackint const ldq, mpcomplex *work, mplapackint &info);
void Cupmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mpcomplex *ap, mpcomplex *tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work, mplapackint &info);
void Rbbcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, mplapackint const m, mplapackint const p, mplapackint const q, mpreal *theta, mpreal *phi, mpreal *u1, mplapackint const ldu1, mpreal *u2, mplapackint const ldu2, mpreal *v1t, mplapackint const ldv1t, mpreal *v2t, mplapackint const ldv2t, mpreal *b11d, mpreal *b11e, mpreal *b12d, mpreal *b12e, mpreal *b21d, mpreal *b21e, mpreal *b22d, mpreal *b22e, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rbdsdc(const char *uplo, const char *compq, mplapackint const n, mpreal *d, mpreal *e, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint const ldvt, mpreal *q, mplapackint *iq, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rbdsqr(const char *uplo, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, mpreal *d, mpreal *e, mpreal *vt, mplapackint const ldvt, mpreal *u, mplapackint const ldu, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint &info);
void Rbdsvdx(const char *uplo, const char *jobz, const char *range, mplapackint const n, mpreal *d, mpreal *e, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, mpreal *s, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rcombssq(mpreal *v1, mpreal *v2);
void Rdisna(const char *job, mplapackint const m, mplapackint const n, mpreal *d, mpreal *sep, mplapackint &info);
void Rgbbrd(const char *vect, mplapackint const m, mplapackint const n, mplapackint const ncc, mplapackint const kl, mplapackint const ku, mpreal *ab, mplapackint const ldab, mpreal *d, mpreal *e, mpreal *q, mplapackint const ldq, mpreal *pt, mplapackint const ldpt, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint &info);
void Rgbcon(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, mpreal *ab, mplapackint const ldab, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rgbequ(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpreal *ab, mplapackint const ldab, mpreal *r, mpreal *c, mpreal &rowcnd, mpreal &colcnd, mpreal &amax, mplapackint &info);
void Rgbequb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpreal *ab, mplapackint const ldab, mpreal *r, mpreal *c, mpreal &rowcnd, mpreal &colcnd, mpreal &amax, mplapackint &info);
void Rgbrfs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal *afb, mplapackint const ldafb, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rgbsv(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rgbsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal *afb, mplapackint const ldafb, mplapackint *ipiv, char *equed, mpreal *r, mpreal *c, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rgbtf2(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpreal *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Rgbtrf(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpreal *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Rgbtrs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rgebak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *scale, mplapackint const m, mpreal *v, mplapackint const ldv, mplapackint &info);
void Rgebal(const char *job, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint &ilo, mplapackint &ihi, mpreal *scale, mplapackint &info);
void Rgebd2(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *d, mpreal *e, mpreal *tauq, mpreal *taup, mpreal *work, mplapackint &info);
void Rgebrd(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *d, mpreal *e, mpreal *tauq, mpreal *taup, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgecon(const char *norm, mplapackint const n, mpreal *a, mplapackint const lda, mpreal const anorm, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rgeequ(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *r, mpreal *c, mpreal &rowcnd, mpreal &colcnd, mpreal &amax, mplapackint &info);
void Rgeequb(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *r, mpreal *c, mpreal &rowcnd, mpreal &colcnd, mpreal &amax, mplapackint &info);
void Rgees(const char *jobvs, const char *sort, bool (*select)(mpreal, mpreal), mplapackint const n, mpreal *a, mplapackint const lda, mplapackint &sdim, mpreal *wr, mpreal *wi, mpreal *vs, mplapackint const ldvs, mpreal *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rgeesx(const char *jobvs, const char *sort, bool (*select)(mpreal, mpreal), const char *sense, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint &sdim, mpreal *wr, mpreal *wi, mpreal *vs, mplapackint const ldvs, mpreal &rconde, mpreal &rcondv, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rgeev(const char *jobvl, const char *jobvr, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *wr, mpreal *wi, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *wr, mpreal *wi, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, mpreal *scale, mpreal &abnrm, mpreal *rconde, mpreal *rcondv, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgehd2(mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint &info);
void Rgehrd(mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgejsv(const char *joba, const char *jobu, const char *jobv, const char *jobr, const char *jobt, const char *jobp, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *sva, mpreal *u, mplapackint const ldu, mpreal *v, mplapackint const ldv, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgelq(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const tsize, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgelq2(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint &info);
void Rgelqf(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgelqt(mplapackint const m, mplapackint const n, mplapackint const mb, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const ldt, mpreal *work, mplapackint &info);
void Rgelqt3(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const ldt, mplapackint &info);
void Rgels(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgelsd(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *s, mpreal const rcond, mplapackint &rank, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgelss(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *s, mpreal const rcond, mplapackint &rank, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgelsy(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mplapackint *jpvt, mpreal const rcond, mplapackint &rank, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgemlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const tsize, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgemlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mpreal *v, mplapackint const ldv, mpreal *t, mplapackint const ldt, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint &info);
void Rgemqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const tsize, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgemqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const nb, mpreal *v, mplapackint const ldv, mpreal *t, mplapackint const ldt, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint &info);
void Rgeql2(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint &info);
void Rgeqlf(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgeqp3(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *jpvt, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgeqr(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const tsize, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgeqr2(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint &info);
void Rgeqr2p(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint &info);
void Rgeqrf(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgeqrfp(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgeqrt(mplapackint const m, mplapackint const n, mplapackint const nb, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const ldt, mpreal *work, mplapackint &info);
void Rgeqrt2(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const ldt, mplapackint &info);
void Rgeqrt3(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const ldt, mplapackint &info);
void Rgerfs(const char *trans, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *af, mplapackint const ldaf, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rgerq2(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint &info);
void Rgerqf(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgesc2(mplapackint const n, mpreal *a, mplapackint const lda, mpreal *rhs, mplapackint *ipiv, mplapackint *jpiv, mpreal &scale);
void Rgesdd(const char *jobz, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *s, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint const ldvt, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgesv(mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rgesvd(const char *jobu, const char *jobvt, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *s, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint const ldvt, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgesvdq(const char *joba, const char *jobp, const char *jobr, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *s, mpreal *u, mplapackint const ldu, mpreal *v, mplapackint const ldv, mplapackint &numrank, mplapackint *iwork, mplapackint const liwork, mpreal *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint &info);
void Rgesvdx(const char *jobu, const char *jobvt, const char *range, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, mpreal *s, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint const ldvt, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgesvj(const char *joba, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *sva, mplapackint const mv, mpreal *v, mplapackint const ldv, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgesvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *af, mplapackint const ldaf, mplapackint *ipiv, char *equed, mpreal *r, mpreal *c, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rgetc2(mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mplapackint *jpiv, mplapackint &info);
void Rgetf2(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetrf(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetrf2(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetri(mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgetrs(const char *trans, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rgetsls(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgetsqrhrt(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const ldt, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rggbak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *lscale, mpreal *rscale, mplapackint const m, mpreal *v, mplapackint const ldv, mplapackint &info);
void Rggbal(const char *job, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mplapackint &ilo, mplapackint &ihi, mpreal *lscale, mpreal *rscale, mpreal *work, mplapackint &info);
void Rgges(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(mpreal, mpreal, mpreal), mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mplapackint &sdim, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *vsl, mplapackint const ldvsl, mpreal *vsr, mplapackint const ldvsr, mpreal *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rgges3(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(mpreal, mpreal, mpreal), mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mplapackint &sdim, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *vsl, mplapackint const ldvsl, mpreal *vsr, mplapackint const ldvsr, mpreal *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rggesx(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(mpreal, mpreal, mpreal), const char *sense, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mplapackint &sdim, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *vsl, mplapackint const ldvsl, mpreal *vsr, mplapackint const ldvsr, mpreal *rconde, mpreal *rcondv, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rggev(const char *jobvl, const char *jobvr, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rggev3(const char *jobvl, const char *jobvr, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, mpreal *lscale, mpreal *rscale, mpreal &abnrm, mpreal &bbnrm, mpreal *rconde, mpreal *rcondv, mpreal *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rggglm(mplapackint const n, mplapackint const m, mplapackint const p, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *d, mpreal *x, mpreal *y, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgghd3(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *q, mplapackint const ldq, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgghrd(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *q, mplapackint const ldq, mpreal *z, mplapackint const ldz, mplapackint &info);
void Rgglse(mplapackint const m, mplapackint const n, mplapackint const p, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *c, mpreal *d, mpreal *x, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rggqrf(mplapackint const n, mplapackint const m, mplapackint const p, mpreal *a, mplapackint const lda, mpreal *taua, mpreal *b, mplapackint const ldb, mpreal *taub, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rggrqf(mplapackint const m, mplapackint const p, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *taua, mpreal *b, mplapackint const ldb, mpreal *taub, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rggsvd3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const n, mplapackint const p, mplapackint &k, mplapackint &l, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *alpha, mpreal *beta, mpreal *u, mplapackint const ldu, mpreal *v, mplapackint const ldv, mpreal *q, mplapackint const ldq, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rggsvp3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal const tola, mpreal const tolb, mplapackint &k, mplapackint &l, mpreal *u, mplapackint const ldu, mpreal *v, mplapackint const ldv, mpreal *q, mplapackint const ldq, mplapackint *iwork, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgsvj0(const char *jobv, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *d, mpreal *sva, mplapackint const mv, mpreal *v, mplapackint const ldv, mpreal const eps, mpreal const sfmin, mpreal const tol, mplapackint const nsweep, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgsvj1(const char *jobv, mplapackint const m, mplapackint const n, mplapackint const n1, mpreal *a, mplapackint const lda, mpreal *d, mpreal *sva, mplapackint const mv, mpreal *v, mplapackint const ldv, mpreal const eps, mpreal const sfmin, mpreal const tol, mplapackint const nsweep, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgtcon(const char *norm, mplapackint const n, mpreal *dl, mpreal *d, mpreal *du, mpreal *du2, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rgtrfs(const char *trans, mplapackint const n, mplapackint const nrhs, mpreal *dl, mpreal *d, mpreal *du, mpreal *dlf, mpreal *df, mpreal *duf, mpreal *du2, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rgtsv(mplapackint const n, mplapackint const nrhs, mpreal *dl, mpreal *d, mpreal *du, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rgtsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, mpreal *dl, mpreal *d, mpreal *du, mpreal *dlf, mpreal *df, mpreal *duf, mpreal *du2, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rgttrf(mplapackint const n, mpreal *dl, mpreal *d, mpreal *du, mpreal *du2, mplapackint *ipiv, mplapackint &info);
void Rgttrs(const char *trans, mplapackint const n, mplapackint const nrhs, mpreal *dl, mpreal *d, mpreal *du, mpreal *du2, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rgtts2(mplapackint const itrans, mplapackint const n, mplapackint const nrhs, mpreal *dl, mpreal *d, mpreal *du, mpreal *du2, mplapackint *ipiv, mpreal *b, mplapackint const ldb);
void Rhgeqz(const char *job, const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *h, mplapackint const ldh, mpreal *t, mplapackint const ldt, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *q, mplapackint const ldq, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rhsein(const char *side, const char *eigsrc, const char *initv, bool *select, mplapackint const n, mpreal *h, mplapackint const ldh, mpreal *wr, mpreal *wi, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpreal *work, mplapackint *ifaill, mplapackint *ifailr, mplapackint &info);
void Rhseqr(const char *job, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *h, mplapackint const ldh, mpreal *wr, mpreal *wi, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rla_gbamv(mplapackint const trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpreal const alpha, mpreal *ab, mplapackint const ldab, mpreal *x, mplapackint const incx, mpreal const beta, mpreal *y, mplapackint const incy);
void Rla_geamv(mplapackint const trans, mplapackint const m, mplapackint const n, mpreal const alpha, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const incx, mpreal const beta, mpreal *y, mplapackint const incy);
void Rla_syamv(mplapackint const uplo, mplapackint const n, mpreal const alpha, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const incx, mpreal const beta, mpreal *y, mplapackint const incy);
void Rla_wwaddw(mplapackint const n, mpreal *x, mpreal *y, mpreal *w);
void Rlabad(mpreal &small, mpreal &large);
void Rlabrd(mplapackint const m, mplapackint const n, mplapackint const nb, mpreal *a, mplapackint const lda, mpreal *d, mpreal *e, mpreal *tauq, mpreal *taup, mpreal *x, mplapackint const ldx, mpreal *y, mplapackint const ldy);
void Rlacn2(mplapackint const n, mpreal *v, mpreal *x, mplapackint *isgn, mpreal &est, mplapackint &kase, mplapackint *isave);
void Rlacon(mplapackint const n, mpreal *v, mpreal *x, mplapackint *isgn, mpreal &est, mplapackint &kase);
void Rlacpy(const char *uplo, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb);
void Rladiv(mpreal const &a, mpreal const &b, mpreal const &c, mpreal const &d, mpreal &p, mpreal &q);
void Rladiv1(mpreal &a, mpreal const &b, mpreal const &c, mpreal const &d, mpreal &p, mpreal &q);
void Rlae2(mpreal const a, mpreal const b, mpreal const c, mpreal &rt1, mpreal &rt2);
void Rlaebz(mplapackint const ijob, mplapackint const nitmax, mplapackint const n, mplapackint const mmax, mplapackint const minp, mplapackint const nbmin, mpreal const abstol, mpreal const reltol, mpreal const pivmin, mpreal *d, mpreal *e, mpreal *e2, mplapackint *nval, mpreal *ab, mpreal *c, mplapackint &mout, mplapackint *nab, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rlaed0(mplapackint const icompq, mplapackint const qsiz, mplapackint const n, mpreal *d, mpreal *e, mpreal *q, mplapackint const ldq, mpreal *qstore, mplapackint const ldqs, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rlaed1(mplapackint const n, mpreal *d, mpreal *q, mplapackint const ldq, mplapackint *indxq, mpreal rho, mplapackint const cutpnt, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rlaed2(mplapackint &k, mplapackint const n, mplapackint const n1, mpreal *d, mpreal *q, mplapackint const ldq, mplapackint *indxq, mpreal &rho, mpreal *z, mpreal *dlamda, mpreal *w, mpreal *q2, mplapackint *indx, mplapackint *indxc, mplapackint *indxp, mplapackint *coltyp, mplapackint &info);
void Rlaed3(mplapackint const k, mplapackint const n, mplapackint const n1, mpreal *d, mpreal *q, mplapackint const ldq, mpreal const rho, mpreal *dlamda, mpreal *q2, mplapackint *indx, mplapackint *ctot, mpreal *w, mpreal *s, mplapackint &info);
void Rlaed4(mplapackint const n, mplapackint const i, mpreal *d, mpreal *z, mpreal *delta, mpreal const rho, mpreal &dlam, mplapackint &info);
void Rlaed5(mplapackint const i, mpreal *d, mpreal *z, mpreal *delta, mpreal const rho, mpreal &dlam);
void Rlaed6(mplapackint const kniter, bool const orgati, mpreal const rho, mpreal *d, mpreal *z, mpreal const finit, mpreal &tau, mplapackint &info);
void Rlaed7(mplapackint const icompq, mplapackint const n, mplapackint const qsiz, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, mpreal *d, mpreal *q, mplapackint const ldq, mplapackint *indxq, mpreal rho, mplapackint const cutpnt, mpreal *qstore, mplapackint *qptr, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, mpreal *givnum, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rlaed8(mplapackint const icompq, mplapackint &k, mplapackint const n, mplapackint const qsiz, mpreal *d, mpreal *q, mplapackint const ldq, mplapackint *indxq, mpreal &rho, mplapackint const cutpnt, mpreal *z, mpreal *dlamda, mpreal *q2, mplapackint const ldq2, mpreal *w, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mpreal *givnum, mplapackint *indxp, mplapackint *indx, mplapackint &info);
void Rlaed9(mplapackint const k, mplapackint const kstart, mplapackint const kstop, mplapackint const n, mpreal *d, mpreal *q, mplapackint const ldq, mpreal const rho, mpreal *dlamda, mpreal *w, mpreal *s, mplapackint const lds, mplapackint &info);
void Rlaeda(mplapackint const n, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, mpreal *givnum, mpreal *q, mplapackint *qptr, mpreal *z, mpreal *ztemp, mplapackint &info);
void Rlaein(bool const rightv, bool const noinit, mplapackint const n, mpreal *h, mplapackint const ldh, mpreal const wr, mpreal const wi, mpreal *vr, mpreal *vi, mpreal *b, mplapackint const ldb, mpreal *work, mpreal const eps3, mpreal const smlnum, mpreal const bignum, mplapackint &info);
void Rlaev2(mpreal const a, mpreal const b, mpreal const c, mpreal &rt1, mpreal &rt2, mpreal &cs1, mpreal &sn1);
void Rlaexc(bool const wantq, mplapackint const n, mpreal *t, mplapackint const ldt, mpreal *q, mplapackint const ldq, mplapackint const j1, mplapackint const n1, mplapackint const n2, mpreal *work, mplapackint &info);
void Rlag2(mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal const safmin, mpreal &scale1, mpreal &scale2, mpreal &wr1, mpreal &wr2, mpreal &wi);
void Rlags2(bool const upper, mpreal const a1, mpreal const a2, mpreal const a3, mpreal const b1, mpreal const b2, mpreal const b3, mpreal &csu, mpreal &snu, mpreal &csv, mpreal &snv, mpreal &csq, mpreal &snq);
void Rlagtf(mplapackint const n, mpreal *a, mpreal const lambda, mpreal *b, mpreal *c, mpreal const tol, mpreal *d, mplapackint *in, mplapackint &info);
void Rlagtm(const char *trans, mplapackint const n, mplapackint const nrhs, mpreal const alpha, mpreal *dl, mpreal *d, mpreal *du, mpreal *x, mplapackint const ldx, mpreal const beta, mpreal *b, mplapackint const ldb);
void Rlagts(mplapackint const job, mplapackint const n, mpreal *a, mpreal *b, mpreal *c, mpreal *d, mplapackint *in, mpreal *y, mpreal &tol, mplapackint &info);
void Rlagv2(mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal &csl, mpreal &snl, mpreal &csr, mpreal &snr);
void Rlahqr(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *h, mplapackint const ldh, mpreal *wr, mpreal *wi, mplapackint const iloz, mplapackint const ihiz, mpreal *z, mplapackint const ldz, mplapackint &info);
void Rlahr2(mplapackint const n, mplapackint const k, mplapackint const nb, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *t, mplapackint const ldt, mpreal *y, mplapackint const ldy);
void Rlaic1(mplapackint const job, mplapackint const j, mpreal *x, mpreal const sest, mpreal *w, mpreal const gamma, mpreal &sestpr, mpreal &s, mpreal &c);
void Rlaln2(bool const ltrans, mplapackint const na, mplapackint const nw, mpreal const smin, mpreal const ca, mpreal *a, mplapackint const lda, mpreal const d1, mpreal const d2, mpreal *b, mplapackint const ldb, mpreal const wr, mpreal const wi, mpreal *x, mplapackint const ldx, mpreal &scale, mpreal &xnorm, mplapackint &info);
void Rlals0(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const nrhs, mpreal *b, mplapackint const ldb, mpreal *bx, mplapackint const ldbx, mplapackint *perm, mplapackint const givptr, mplapackint *givcol, mplapackint const ldgcol, mpreal *givnum, mplapackint const ldgnum, mpreal *poles, mpreal *difl, mpreal *difr, mpreal *z, mplapackint const k, mpreal const c, mpreal const s, mpreal *work, mplapackint &info);
void Rlalsa(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, mpreal *b, mplapackint const ldb, mpreal *bx, mplapackint const ldbx, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint *k, mpreal *difl, mpreal *difr, mpreal *z, mpreal *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, mpreal *givnum, mpreal *c, mpreal *s, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rlalsd(const char *uplo, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, mpreal *d, mpreal *e, mpreal *b, mplapackint const ldb, mpreal const rcond, mplapackint &rank, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rlamrg(mplapackint const n1, mplapackint const n2, mpreal *a, mplapackint const dtrd1, mplapackint const dtrd2, mplapackint *index);
void Rlamswlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const ldt, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rlamtsqr(const char *side, const char *trans, mplapackint const &m, mplapackint const &n, mplapackint const &k, mplapackint const &mb, mplapackint const &nb, mpreal *a, mplapackint const &lda, mpreal *t, mplapackint const &ldt, mpreal *c, mplapackint const &ldc, mpreal *work, mplapackint const &lwork, mplapackint &info);
void Rlanv2(mpreal &a, mpreal &b, mpreal &c, mpreal &d, mpreal &rt1r, mpreal &rt1i, mpreal &rt2r, mpreal &rt2i, mpreal &cs, mpreal &sn);
void Rlaorhr_col_getrfnp(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *d, mplapackint &info);
void Rlaorhr_col_getrfnp2(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *d, mplapackint &info);
void Rlapll(mplapackint const n, mpreal *x, mplapackint const incx, mpreal *y, mplapackint const incy, mpreal &ssmin);
void Rlapmr(bool const forwrd, mplapackint const m, mplapackint const n, mpreal *x, mplapackint const ldx, mplapackint *k);
void Rlapmt(bool const forwrd, mplapackint const m, mplapackint const n, mpreal *x, mplapackint const ldx, mplapackint *k);
void Rlaqgb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpreal *ab, mplapackint const ldab, mpreal *r, mpreal *c, mpreal const rowcnd, mpreal const colcnd, mpreal const amax, char *equed);
void Rlaqge(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *r, mpreal *c, mpreal const rowcnd, mpreal const colcnd, mpreal const amax, char *equed);
void Rlaqp2(mplapackint const m, mplapackint const n, mplapackint const offset, mpreal *a, mplapackint const lda, mplapackint *jpvt, mpreal *tau, mpreal *vn1, mpreal *vn2, mpreal *work);
void Rlaqps(mplapackint const m, mplapackint const n, mplapackint const offset, mplapackint const nb, mplapackint &kb, mpreal *a, mplapackint const lda, mplapackint *jpvt, mpreal *tau, mpreal *vn1, mpreal *vn2, mpreal *auxv, mpreal *f, mplapackint const ldf);
void Rlaqr0(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *h, mplapackint const ldh, mpreal *wr, mpreal *wi, mplapackint const iloz, mplapackint const ihiz, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rlaqr1(mplapackint const n, mpreal *h, mplapackint const ldh, mpreal const sr1, mpreal const si1, mpreal const sr2, mpreal const si2, mpreal *v);
void Rlaqr2(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, mpreal *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, mpreal *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, mpreal *sr, mpreal *si, mpreal *v, mplapackint const ldv, mplapackint const nh, mpreal *t, mplapackint const ldt, mplapackint const nv, mpreal *wv, mplapackint const ldwv, mpreal *work, mplapackint const lwork);
void Rlaqr3(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, mpreal *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, mpreal *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, mpreal *sr, mpreal *si, mpreal *v, mplapackint const ldv, mplapackint const nh, mpreal *t, mplapackint const ldt, mplapackint const nv, mpreal *wv, mplapackint const ldwv, mpreal *work, mplapackint const lwork);
void Rlaqr4(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *h, mplapackint const ldh, mpreal *wr, mpreal *wi, mplapackint const iloz, mplapackint const ihiz, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rlaqr5(bool const wantt, bool const wantz, mplapackint const kacc22, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nshfts, mpreal *sr, mpreal *si, mpreal *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, mpreal *z, mplapackint const ldz, mpreal *v, mplapackint const ldv, mpreal *u, mplapackint const ldu, mplapackint const nv, mpreal *wv, mplapackint const ldwv, mplapackint const nh, mpreal *wh, mplapackint const ldwh);
void Rlaqsb(const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *s, mpreal const scond, mpreal const amax, char *equed);
void Rlaqsp(const char *uplo, mplapackint const n, mpreal *ap, mpreal *s, mpreal const scond, mpreal const amax, char *equed);
void Rlaqsy(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *s, mpreal const scond, mpreal const amax, char *equed);
void Rlaqtr(bool const ltran, bool const lreal, mplapackint const n, mpreal *t, mplapackint const ldt, mpreal *b, mpreal const w, mpreal &scale, mpreal *x, mpreal *work, mplapackint &info);
void Rlar1v(mplapackint const n, mplapackint const b1, mplapackint const bn, mpreal const lambda, mpreal *d, mpreal *l, mpreal *ld, mpreal *lld, mpreal const pivmin, mpreal const gaptol, mpreal *z, bool const wantnc, mplapackint &negcnt, mpreal &ztz, mpreal &mingma, mplapackint &r, mplapackint *isuppz, mpreal &nrminv, mpreal &resid, mpreal &rqcorr, mpreal *work);
void Rlar2v(mplapackint const n, mpreal *x, mpreal *y, mpreal *z, mplapackint const incx, mpreal *c, mpreal *s, mplapackint const incc);
void Rlarf(const char *side, mplapackint const m, mplapackint const n, mpreal *v, mplapackint const incv, mpreal const tau, mpreal *c, mplapackint const ldc, mpreal *work);
void Rlarfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *v, mplapackint const ldv, mpreal *t, mplapackint const ldt, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const ldwork);
void Rlarfb_gett(const char *ident, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *t, mplapackint const ldt, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const ldwork);
void Rlarfg(mplapackint const n, mpreal &alpha, mpreal *x, mplapackint const incx, mpreal &tau);
void Rlarfgp(mplapackint const n, mpreal &alpha, mpreal *x, mplapackint const incx, mpreal &tau);
void Rlarft(const char *direct, const char *storev, mplapackint const n, mplapackint const k, mpreal *v, mplapackint const ldv, mpreal *tau, mpreal *t, mplapackint const ldt);
void Rlarfx(const char *side, mplapackint const m, mplapackint const n, mpreal *v, mpreal const tau, mpreal *c, mplapackint const ldc, mpreal *work);
void Rlarfy(const char *uplo, mplapackint const n, mpreal *v, mplapackint const incv, mpreal const tau, mpreal *c, mplapackint const ldc, mpreal *work);
void Rlargv(mplapackint const n, mpreal *x, mplapackint const incx, mpreal *y, mplapackint const incy, mpreal *c, mplapackint const incc);
void Rlarnv(mplapackint const idist, mplapackint *iseed, mplapackint const n, mpreal *x);
void Rlarra(mplapackint const n, mpreal *d, mpreal *e, mpreal *e2, mpreal const spltol, mpreal const tnrm, mplapackint &nsplit, mplapackint *isplit, mplapackint &info);
void Rlarrb(mplapackint const n, mpreal *d, mpreal *lld, mplapackint const ifirst, mplapackint const ilast, mpreal const rtol1, mpreal const rtol2, mplapackint const offset, mpreal *w, mpreal *wgap, mpreal *werr, mpreal *work, mplapackint *iwork, mpreal const pivmin, mpreal const spdiam, mplapackint const twist, mplapackint &info);
void Rlarrc(const char *jobt, mplapackint const n, mpreal const vl, mpreal const vu, mpreal *d, mpreal *e, mpreal const, mplapackint &eigcnt, mplapackint &lcnt, mplapackint &rcnt, mplapackint &info);
void Rlarrd(const char *range, const char *order, mplapackint const n, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal *gers, mpreal const reltol, mpreal *d, mpreal *e, mpreal *e2, mpreal const pivmin, mplapackint const nsplit, mplapackint *isplit, mplapackint &m, mpreal *w, mpreal *werr, mpreal &wl, mpreal &wu, mplapackint *iblock, mplapackint *indexw, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rlarre(const char *range, mplapackint const n, mpreal &vl, mpreal &vu, mplapackint const il, mplapackint const iu, mpreal *d, mpreal *e, mpreal *e2, mpreal const rtol1, mpreal const rtol2, mpreal const spltol, mplapackint nsplit, mplapackint *isplit, mplapackint &m, mpreal *w, mpreal *werr, mpreal *wgap, mplapackint *iblock, mplapackint *indexw, mpreal *gers, mpreal &pivmin, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rlarrf(mplapackint const n, mpreal *d, mpreal *l, mpreal *ld, mplapackint const clstrt, mplapackint const clend, mpreal *w, mpreal *wgap, mpreal *werr, mpreal const spdiam, mpreal const clgapl, mpreal const clgapr, mpreal const pivmin, mpreal &sigma, mpreal *dplus, mpreal *lplus, mpreal *work, mplapackint &info);
void Rlarrj(mplapackint const n, mpreal *d, mpreal *e2, mplapackint const ifirst, mplapackint const ilast, mpreal const rtol, mplapackint const offset, mpreal *w, mpreal *werr, mpreal *work, mplapackint *iwork, mpreal const pivmin, mpreal const spdiam, mplapackint &info);
void Rlarrk(mplapackint const n, mplapackint const iw, mpreal const gl, mpreal const gu, mpreal *d, mpreal *e2, mpreal const pivmin, mpreal const reltol, mpreal &w, mpreal &werr, mplapackint &info);
void Rlarrr(mplapackint const n, mpreal *d, mpreal *e, mplapackint &info);
void Rlarrv(mplapackint const n, mpreal const vl, mpreal const, mpreal *d, mpreal *l, mpreal const pivmin, mplapackint *isplit, mplapackint const m, mplapackint const dol, mplapackint const dou, mpreal const minrgp, mpreal &rtol1, mpreal &rtol2, mpreal *w, mpreal *werr, mpreal *wgap, mplapackint *iblock, mplapackint *indexw, mpreal *gers, mpreal *z, mplapackint const ldz, mplapackint *isuppz, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rlarscl2(mplapackint const m, mplapackint const n, mpreal *d, mpreal *x, mplapackint const ldx);
void Rlartg(mpreal const f, mpreal const g, mpreal &cs, mpreal &sn, mpreal &r);
void Rlartgp(mpreal const f, mpreal const g, mpreal &cs, mpreal &sn, mpreal &r);
void Rlartgs(mpreal const x, mpreal const y, mpreal const sigma, mpreal &cs, mpreal &sn);
void Rlartv(mplapackint const n, mpreal *x, mplapackint const incx, mpreal *y, mplapackint const incy, mpreal *c, mpreal *s, mplapackint const incc);
void Rlaruv(mplapackint *iseed, mplapackint const n, mpreal *x);
void Rlarz(const char *side, mplapackint const m, mplapackint const n, mplapackint const l, mpreal *v, mplapackint const incv, mpreal const tau, mpreal *c, mplapackint const ldc, mpreal *work);
void Rlarzb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpreal *v, mplapackint const ldv, mpreal *t, mplapackint const ldt, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const ldwork);
void Rlarzt(const char *direct, const char *storev, mplapackint const n, mplapackint const k, mpreal *v, mplapackint const ldv, mpreal *tau, mpreal *t, mplapackint const ldt);
void Rlas2(mpreal const f, mpreal const g, mpreal const h, mpreal &ssmin, mpreal &ssmax);
void Rlascl(const char *type, mplapackint const kl, mplapackint const ku, mpreal const cfrom, mpreal const cto, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint &info);
void Rlascl2(mplapackint const m, mplapackint const n, mpreal *d, mpreal *x, mplapackint const ldx);
void Rlasd0(mplapackint const n, mplapackint const sqre, mpreal *d, mpreal *e, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint const ldvt, mplapackint const smlsiz, mplapackint *iwork, mpreal *work, mplapackint &info);
void Rlasd1(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mpreal *d, mpreal &alpha, mpreal &beta, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint const ldvt, mplapackint *idxq, mplapackint *iwork, mpreal *work, mplapackint &info);
void Rlasd2(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint &k, mpreal *d, mpreal *z, mpreal const alpha, mpreal const beta, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint const ldvt, mpreal *dsigma, mpreal *u2, mplapackint const ldu2, mpreal *vt2, mplapackint const ldvt2, mplapackint *idxp, mplapackint *idx, mplapackint *idxc, mplapackint *idxq, mplapackint *coltyp, mplapackint &info);
void Rlasd3(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const k, mpreal *d, mpreal *q, mplapackint const ldq, mpreal *dsigma, mpreal *u, mplapackint const ldu, mpreal *u2, mplapackint const ldu2, mpreal *vt, mplapackint const ldvt, mpreal *vt2, mplapackint const ldvt2, mplapackint *idxc, mplapackint *ctot, mpreal *z, mplapackint &info);
void Rlasd4(mplapackint const n, mplapackint const i, mpreal *d, mpreal *z, mpreal *delta, mpreal const rho, mpreal &sigma, mpreal *work, mplapackint &info);
void Rlasd5(mplapackint const i, mpreal *d, mpreal *z, mpreal *delta, mpreal const rho, mpreal &dsigma, mpreal *work);
void Rlasd6(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mpreal *d, mpreal *vf, mpreal *vl, mpreal &alpha, mpreal &beta, mplapackint *idxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mplapackint const ldgcol, mpreal *givnum, mplapackint const ldgnum, mpreal *poles, mpreal *difl, mpreal *difr, mpreal *z, mplapackint &k, mpreal &c, mpreal &s, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rlasd7(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint &k, mpreal *d, mpreal *z, mpreal *zw, mpreal *vf, mpreal *vfw, mpreal *vl, mpreal *vlw, mpreal const alpha, mpreal const beta, mpreal *dsigma, mplapackint *idx, mplapackint *idxp, mplapackint *idxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mplapackint const ldgcol, mpreal *givnum, mplapackint const ldgnum, mpreal &c, mpreal &s, mplapackint &info);
void Rlasd8(mplapackint const icompq, mplapackint const k, mpreal *d, mpreal *z, mpreal *vf, mpreal *vl, mpreal *difl, mpreal *difr, mplapackint const lddifr, mpreal *dsigma, mpreal *work, mplapackint &info);
void Rlasda(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const sqre, mpreal *d, mpreal *e, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint *k, mpreal *difl, mpreal *difr, mpreal *z, mpreal *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, mpreal *givnum, mpreal *c, mpreal *s, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rlasdq(const char *uplo, mplapackint const sqre, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, mpreal *d, mpreal *e, mpreal *vt, mplapackint const ldvt, mpreal *u, mplapackint const ldu, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint &info);
void Rlasdt(mplapackint const n, mplapackint &lvl, mplapackint &nd, mplapackint *inode, mplapackint *ndiml, mplapackint *ndimr, mplapackint const msub);
void Rlaset(const char *uplo, mplapackint const m, mplapackint const n, mpreal const alpha, mpreal const beta, mpreal *a, mplapackint const lda);
void Rlasq1(mplapackint const n, mpreal *d, mpreal *e, mpreal *work, mplapackint &info);
void Rlasq2(mplapackint const n, mpreal *z, mplapackint &info);
void Rlasq3(mplapackint const i0, mplapackint &n0, mpreal *z, mplapackint &pp, mpreal &dmin, mpreal &sigma, mpreal &desig, mpreal &qmax, mplapackint &nfail, mplapackint &iter, mplapackint &ndiv, bool const ieee, mplapackint &ttype, mpreal dmin1, mpreal &dmin2, mpreal dn, mpreal dn1, mpreal dn2, mpreal g, mpreal &tau);
void Rlasq4(mplapackint const i0, mplapackint const n0, mpreal *z, mplapackint const pp, mplapackint const n0in, mpreal const dmin, mpreal const dmin1, mpreal const dmin2, mpreal const dn, mpreal const dn1, mpreal const dn2, mpreal &tau, mplapackint &ttype, mpreal &g);
void Rlasq5(mplapackint const i0, mplapackint const n0, mpreal *z, mplapackint const pp, mpreal &tau, mpreal const sigma, mpreal &dmin, mpreal &dmin1, mpreal &dmin2, mpreal &dn, mpreal &dnm1, mpreal &dnm2, bool const ieee, mpreal const eps);
void Rlasq6(mplapackint const i0, mplapackint const n0, mpreal *z, mplapackint const pp, mpreal &dmin, mpreal &dmin1, mpreal &dmin2, mpreal &dn, mpreal &dnm1, mpreal &dnm2);
void Rlasr(const char *side, const char *pivot, const char *direct, mplapackint const m, mplapackint const n, mpreal *c, mpreal *s, mpreal *a, mplapackint const lda);
void Rlasrt(const char *id, mplapackint const n, mpreal *d, mplapackint &info);
void Rlassq(mplapackint const n, mpreal *x, mplapackint const incx, mpreal &scale, mpreal &sumsq);
void Rlasv2(mpreal const f, mpreal const g, mpreal const h, mpreal &ssmin, mpreal &ssmax, mpreal &snr, mpreal &csr, mpreal &snl, mpreal &csl);
void Rlaswlq(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const ldt, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rlaswp(mplapackint const n, mpreal *a, mplapackint const lda, mplapackint const k1, mplapackint const k2, mplapackint *ipiv, mplapackint const incx);
void Rlasy2(bool const ltranl, bool const ltranr, mplapackint const isgn, mplapackint const n1, mplapackint const n2, mpreal *tl, mplapackint const ldtl, mpreal *tr, mplapackint const ldtr, mpreal *b, mplapackint const ldb, mpreal &scale, mpreal *x, mplapackint const ldx, mpreal &xnorm, mplapackint &info);
void Rlasyf(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *w, mplapackint const ldw, mplapackint &info);
void Rlasyf_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *h, mplapackint const ldh, mpreal *work);
void Rlasyf_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpreal *a, mplapackint const lda, mpreal *e, mplapackint *ipiv, mpreal *w, mplapackint const ldw, mplapackint &info);
void Rlasyf_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *w, mplapackint const ldw, mplapackint &info);
void Rlatbs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *x, mpreal &scale, mpreal *cnorm, mplapackint &info);
void Rlatdf(mplapackint const ijob, mplapackint const n, mpreal *z, mplapackint const ldz, mpreal *rhs, mpreal &rdsum, mpreal &rdscal, mplapackint *ipiv, mplapackint *jpiv);
void Rlatps(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mpreal *ap, mpreal *x, mpreal &scale, mpreal *cnorm, mplapackint &info);
void Rlatrd(const char *uplo, mplapackint const n, mplapackint const nb, mpreal *a, mplapackint const lda, mpreal *e, mpreal *tau, mpreal *w, mplapackint const ldw);
void Rlatrs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *x, mpreal &scale, mpreal *cnorm, mplapackint &info);
void Rlatrz(mplapackint const m, mplapackint const n, mplapackint const l, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work);
void Rlatsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const ldt, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rlauu2(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint &info);
void Rlauum(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint &info);
void Ropgtr(const char *uplo, mplapackint const n, mpreal *ap, mpreal *tau, mpreal *q, mplapackint const ldq, mpreal *work, mplapackint &info);
void Ropmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mpreal *ap, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint &info);
void Rorbdb(const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, mpreal *x11, mplapackint const ldx11, mpreal *x12, mplapackint const ldx12, mpreal *x21, mplapackint const ldx21, mpreal *x22, mplapackint const ldx22, mpreal *theta, mpreal *phi, mpreal *taup1, mpreal *taup2, mpreal *tauq1, mpreal *tauq2, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorbdb1(mplapackint const m, mplapackint const p, mplapackint const q, mpreal *x11, mplapackint const ldx11, mpreal *x21, mplapackint const ldx21, mpreal *theta, mpreal *phi, mpreal *taup1, mpreal *taup2, mpreal *tauq1, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorbdb2(mplapackint const m, mplapackint const p, mplapackint const q, mpreal *x11, mplapackint const ldx11, mpreal *x21, mplapackint const ldx21, mpreal *theta, mpreal *phi, mpreal *taup1, mpreal *taup2, mpreal *tauq1, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorbdb3(mplapackint const m, mplapackint const p, mplapackint const q, mpreal *x11, mplapackint const ldx11, mpreal *x21, mplapackint const ldx21, mpreal *theta, mpreal *phi, mpreal *taup1, mpreal *taup2, mpreal *tauq1, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorbdb4(mplapackint const m, mplapackint const p, mplapackint const q, mpreal *x11, mplapackint const ldx11, mpreal *x21, mplapackint const ldx21, mpreal *theta, mpreal *phi, mpreal *taup1, mpreal *taup2, mpreal *tauq1, mpreal *phantom, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorbdb5(mplapackint const m1, mplapackint const m2, mplapackint const n, mpreal *x1, mplapackint const incx1, mpreal *x2, mplapackint const incx2, mpreal *q1, mplapackint const ldq1, mpreal *q2, mplapackint const ldq2, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorbdb6(mplapackint const m1, mplapackint const m2, mplapackint const n, mpreal *x1, mplapackint const incx1, mpreal *x2, mplapackint const incx2, mpreal *q1, mplapackint const ldq1, mpreal *q2, mplapackint const ldq2, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, mpreal *x11, mplapackint const ldx11, mpreal *x12, mplapackint const ldx12, mpreal *x21, mplapackint const ldx21, mpreal *x22, mplapackint const ldx22, mpreal *theta, mpreal *u1, mplapackint const ldu1, mpreal *u2, mplapackint const ldu2, mpreal *v1t, mplapackint const ldv1t, mpreal *v2t, mplapackint const ldv2t, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rorcsd2by1(const char *jobu1, const char *jobu2, const char *jobv1t, mplapackint const m, mplapackint const p, mplapackint const q, mpreal *x11, mplapackint const ldx11, mpreal *x21, mplapackint const ldx21, mpreal *theta, mpreal *u1, mplapackint const ldu1, mpreal *u2, mplapackint const ldu2, mpreal *v1t, mplapackint const ldv1t, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rorg2l(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint &info);
void Rorg2r(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint &info);
void Rorgbr(const char *vect, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorghr(mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorgl2(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint &info);
void Rorglq(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorgql(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorgqr(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorgr2(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint &info);
void Rorgrq(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorgtr(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorgtsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const ldt, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorgtsqr_row(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const ldt, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorhr_col(mplapackint const m, mplapackint const n, mplapackint const nb, mpreal *a, mplapackint const lda, mpreal *t, mplapackint const ldt, mpreal *d, mplapackint &info);
void Rorm22(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const n1, mplapackint const n2, mpreal *q, mplapackint const ldq, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorm2l(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint &info);
void Rorm2r(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint &info);
void Rormbr(const char *vect, const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rormhr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rorml2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint &info);
void Rormlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rormql(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rormqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rormr2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint &info);
void Rormr3(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint &info);
void Rormrq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rormrz(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rormtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *c, mplapackint const ldc, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rpbcon(const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal const anorm, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rpbequ(const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *s, mpreal &scond, mpreal &amax, mplapackint &info);
void Rpbrfs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal *afb, mplapackint const ldafb, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rpbstf(const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mplapackint &info);
void Rpbsv(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rpbsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal *afb, mplapackint const ldafb, char *equed, mpreal *s, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rpbtf2(const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mplapackint &info);
void Rpbtrf(const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mplapackint &info);
void Rpbtrs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rpftrf(const char *transr, const char *uplo, mplapackint const n, mpreal *a, mplapackint &info);
void Rpftri(const char *transr, const char *uplo, mplapackint const n, mpreal *a, mplapackint &info);
void Rpftrs(const char *transr, const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rpocon(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal const anorm, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rpoequ(mplapackint const n, mpreal *a, mplapackint const lda, mpreal *s, mpreal &scond, mpreal &amax, mplapackint &info);
void Rpoequb(mplapackint const n, mpreal *a, mplapackint const lda, mpreal *s, mpreal &scond, mpreal &amax, mplapackint &info);
void Rporfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *af, mplapackint const ldaf, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rposv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rposvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *af, mplapackint const ldaf, char *equed, mpreal *s, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rpotf2(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint &info);
void Rpotrf(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint &info);
void Rpotrf2(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint &info);
void Rpotri(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint &info);
void Rpotrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rppcon(const char *uplo, mplapackint const n, mpreal *ap, mpreal const anorm, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rppequ(const char *uplo, mplapackint const n, mpreal *ap, mpreal *s, mpreal &scond, mpreal &amax, mplapackint &info);
void Rpprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *ap, mpreal *afp, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rppsv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *ap, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rppsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *ap, mpreal *afp, char *equed, mpreal *s, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rpptrf(const char *uplo, mplapackint const n, mpreal *ap, mplapackint &info);
void Rpptri(const char *uplo, mplapackint const n, mpreal *ap, mplapackint &info);
void Rpptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *ap, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rpstf2(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, mpreal const tol, mpreal *work, mplapackint &info);
void Rpstrf(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, mpreal const tol, mpreal *work, mplapackint &info);
void Rptcon(mplapackint const n, mpreal *d, mpreal *e, mpreal const anorm, mpreal &rcond, mpreal *work, mplapackint &info);
void Rpteqr(const char *compz, mplapackint const n, mpreal *d, mpreal *e, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint &info);
void Rptrfs(mplapackint const n, mplapackint const nrhs, mpreal *d, mpreal *e, mpreal *df, mpreal *ef, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint &info);
void Rptsv(mplapackint const n, mplapackint const nrhs, mpreal *d, mpreal *e, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rptsvx(const char *fact, mplapackint const n, mplapackint const nrhs, mpreal *d, mpreal *e, mpreal *df, mpreal *ef, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint &info);
void Rpttrf(mplapackint const n, mpreal *d, mpreal *e, mplapackint &info);
void Rpttrs(mplapackint const n, mplapackint const nrhs, mpreal *d, mpreal *e, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rptts2(mplapackint const n, mplapackint const nrhs, mpreal *d, mpreal *e, mpreal *b, mplapackint const ldb);
void Rrscl(mplapackint const n, mpreal const sa, mpreal *sx, mplapackint const incx);
void Rsb2st_kernels(const char *uplo, bool const wantz, mplapackint const ttype, mplapackint const st, mplapackint const ed, mplapackint const sweep, mplapackint const n, mplapackint const nb, mplapackint const ib, mpreal *a, mplapackint const lda, mpreal *v, mpreal *tau, mplapackint const ldvt, mpreal *work);
void Rsbev(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint &info);
void Rsbev_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsbevd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *q, mplapackint const ldq, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *q, mplapackint const ldq, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbgst(const char *vect, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpreal *ab, mplapackint const ldab, mpreal *bb, mplapackint const ldbb, mpreal *x, mplapackint const ldx, mpreal *work, mplapackint &info);
void Rsbgv(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpreal *ab, mplapackint const ldab, mpreal *bb, mplapackint const ldbb, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint &info);
void Rsbgvd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpreal *ab, mplapackint const ldab, mpreal *bb, mplapackint const ldbb, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbgvx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpreal *ab, mplapackint const ldab, mpreal *bb, mplapackint const ldbb, mpreal *q, mplapackint const ldq, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbtrd(const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *d, mpreal *e, mpreal *q, mplapackint const ldq, mpreal *work, mplapackint &info);
void Rsfrk(const char *transr, const char *uplo, const char *trans, mplapackint const n, mplapackint const k, mpreal const alpha, mpreal *a, mplapackint const lda, mpreal const beta, mpreal *c);
void Rspcon(const char *uplo, mplapackint const n, mpreal *ap, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rspev(const char *jobz, const char *uplo, mplapackint const n, mpreal *ap, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint &info);
void Rspevd(const char *jobz, const char *uplo, mplapackint const n, mpreal *ap, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rspevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpreal *ap, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rspgst(mplapackint const itype, const char *uplo, mplapackint const n, mpreal *ap, mpreal *bp, mplapackint &info);
void Rspgv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpreal *ap, mpreal *bp, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint &info);
void Rspgvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpreal *ap, mpreal *bp, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rspgvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, mpreal *ap, mpreal *bp, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *ap, mpreal *afp, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rspsv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *ap, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rspsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *ap, mpreal *afp, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rsptrd(const char *uplo, mplapackint const n, mpreal *ap, mpreal *d, mpreal *e, mpreal *tau, mplapackint &info);
void Rsptrf(const char *uplo, mplapackint const n, mpreal *ap, mplapackint *ipiv, mplapackint &info);
void Rsptri(const char *uplo, mplapackint const n, mpreal *ap, mplapackint *ipiv, mpreal *work, mplapackint &info);
void Rsptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *ap, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rstebz(const char *range, const char *order, mplapackint const n, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mpreal *d, mpreal *e, mplapackint &m, mplapackint &nsplit, mpreal *w, mplapackint *iblock, mplapackint *isplit, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rstedc(const char *compz, mplapackint const n, mpreal *d, mpreal *e, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstein(mplapackint const n, mpreal *d, mpreal *e, mplapackint const m, mpreal *w, mplapackint *iblock, mplapackint *isplit, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rstemr(const char *jobz, const char *range, mplapackint const n, mpreal *d, mpreal *e, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mplapackint const nzc, mplapackint *isuppz, bool &tryrac, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsteqr(const char *compz, mplapackint const n, mpreal *d, mpreal *e, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint &info);
void Rsterf(mplapackint const n, mpreal *d, mpreal *e, mplapackint &info);
void Rstev(const char *jobz, mplapackint const n, mpreal *d, mpreal *e, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint &info);
void Rstevd(const char *jobz, mplapackint const n, mpreal *d, mpreal *e, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstevr(const char *jobz, const char *range, mplapackint const n, mpreal *d, mpreal *e, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mplapackint *isuppz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstevx(const char *jobz, const char *range, mplapackint const n, mpreal *d, mpreal *e, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsycon(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rsycon_3(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *e, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rsycon_rook(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal const anorm, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rsyconv(const char *uplo, const char *way, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *e, mplapackint &info);
void Rsyconvf(const char *uplo, const char *way, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *e, mplapackint *ipiv, mplapackint &info);
void Rsyconvf_rook(const char *uplo, const char *way, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *e, mplapackint *ipiv, mplapackint &info);
void Rsyequb(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *s, mpreal &scond, mpreal &amax, mpreal *work, mplapackint &info);
void Rsyev(const char *jobz, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *w, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsyev_2stage(const char *jobz, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *w, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsyevd(const char *jobz, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *w, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *w, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevr(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mplapackint *isuppz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevr_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mplapackint *isuppz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsyevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsygs2(mplapackint const itype, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rsygst(mplapackint const itype, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rsygv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *w, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsygv_2stage(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *w, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsygvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *w, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsygvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal const vl, mpreal const vu, mplapackint const il, mplapackint const iu, mpreal const abstol, mplapackint &m, mpreal *w, mpreal *z, mplapackint const ldz, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsyrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *af, mplapackint const ldaf, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rsysv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsysv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsysv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsysv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *e, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsysv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsysvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *af, mplapackint const ldaf, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal &rcond, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rsyswapr(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Rsytd2(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *d, mpreal *e, mpreal *tau, mplapackint &info);
void Rsytf2(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rsytf2_rk(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *e, mplapackint *ipiv, mplapackint &info);
void Rsytf2_rook(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rsytrd(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *d, mpreal *e, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_2stage(const char *vect, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *d, mpreal *e, mpreal *tau, mpreal *hous2, mplapackint const lhous2, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_sb2st(const char *stage1, const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *d, mpreal *e, mpreal *hous, mplapackint const lhous, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_sy2sb(const char *uplo, mplapackint const n, mplapackint const kd, mpreal *a, mplapackint const lda, mpreal *ab, mplapackint const ldab, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsytrf(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_aa(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_aa_2stage(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_rk(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *e, mplapackint *ipiv, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_rook(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsytri(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *work, mplapackint &info);
void Rsytri2(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsytri2x(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *work, mplapackint const nb, mplapackint &info);
void Rsytri_3(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *e, mplapackint *ipiv, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsytri_3x(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *e, mplapackint *ipiv, mpreal *work, mplapackint const nb, mplapackint &info);
void Rsytri_rook(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *work, mplapackint &info);
void Rsytrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rsytrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint &info);
void Rsytrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *e, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rsytrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rsytrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rsytrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rtbcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rtbrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rtbtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rtfsm(const char *transr, const char *side, const char *uplo, const char *trans, const char *diag, mplapackint const m, mplapackint const n, mpreal const alpha, mpreal *a, mpreal *b, mplapackint const ldb);
void Rtftri(const char *transr, const char *uplo, const char *diag, mplapackint const n, mpreal *a, mplapackint &info);
void Rtfttp(const char *transr, const char *uplo, mplapackint const n, mpreal *arf, mpreal *ap, mplapackint &info);
void Rtfttr(const char *transr, const char *uplo, mplapackint const n, mpreal *arf, mpreal *a, mplapackint const lda, mplapackint &info);
void Rtgevc(const char *side, const char *howmny, bool *select, mplapackint const n, mpreal *s, mplapackint const lds, mpreal *p, mplapackint const ldp, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpreal *work, mplapackint &info);
void Rtgex2(bool const wantq, bool const wantz, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *q, mplapackint const ldq, mpreal *z, mplapackint const ldz, mplapackint const j1, mplapackint const n1, mplapackint const n2, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rtgexc(bool const wantq, bool const wantz, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *q, mplapackint const ldq, mpreal *z, mplapackint const ldz, mplapackint &ifst, mplapackint &ilst, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rtgsen(mplapackint const ijob, bool const wantq, bool const wantz, bool *select, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *q, mplapackint const ldq, mpreal *z, mplapackint const ldz, mplapackint &m, mpreal &pl, mpreal &pr, mpreal *dif, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rtgsja(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mplapackint const k, mplapackint const l, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal const tola, mpreal const tolb, mpreal *alpha, mpreal *beta, mpreal *u, mplapackint const ldu, mpreal *v, mplapackint const ldv, mpreal *q, mplapackint const ldq, mpreal *work, mplapackint &ncycle, mplapackint &info);
void Rtgsna(const char *job, const char *howmny, bool *select, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mpreal *s, mpreal *dif, mplapackint const mm, mplapackint &m, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rtgsy2(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *c, mplapackint const ldc, mpreal *d, mplapackint const ldd, mpreal *e, mplapackint const lde, mpreal *f, mplapackint const ldf, mpreal &scale, mpreal &rdsum, mpreal &rdscal, mplapackint *iwork, mplapackint &pq, mplapackint &info);
void Rtgsyl(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *c, mplapackint const ldc, mpreal *d, mplapackint const ldd, mpreal *e, mplapackint const lde, mpreal *f, mplapackint const ldf, mpreal &scale, mpreal &dif, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rtpcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mpreal *ap, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rtplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *t, mplapackint const ldt, mpreal *work, mplapackint &info);
void Rtplqt2(mplapackint const m, mplapackint const n, mplapackint const l, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *t, mplapackint const ldt, mplapackint &info);
void Rtpmlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const mb, mpreal *v, mplapackint const ldv, mpreal *t, mplapackint const ldt, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint &info);
void Rtpmqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const nb, mpreal *v, mplapackint const ldv, mpreal *t, mplapackint const ldt, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint &info);
void Rtpqrt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *t, mplapackint const ldt, mpreal *work, mplapackint &info);
void Rtpqrt2(mplapackint const m, mplapackint const n, mplapackint const l, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *t, mplapackint const ldt, mplapackint &info);
void Rtprfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpreal *v, mplapackint const ldv, mpreal *t, mplapackint const ldt, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const ldwork);
void Rtprfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *ap, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rtptri(const char *uplo, const char *diag, mplapackint const n, mpreal *ap, mplapackint &info);
void Rtptrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *ap, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rtpttf(const char *transr, const char *uplo, mplapackint const n, mpreal *ap, mpreal *arf, mplapackint &info);
void Rtpttr(const char *uplo, mplapackint const n, mpreal *ap, mpreal *a, mplapackint const lda, mplapackint &info);
void Rtrcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mpreal *a, mplapackint const lda, mpreal &rcond, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rtrevc(const char *side, const char *howmny, bool *select, mplapackint const n, mpreal *t, mplapackint const ldt, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpreal *work, mplapackint &info);
void Rtrevc3(const char *side, const char *howmny, bool *select, mplapackint const n, mpreal *t, mplapackint const ldt, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rtrexc(const char *compq, mplapackint const n, mpreal *t, mplapackint const ldt, mpreal *q, mplapackint const ldq, mplapackint &ifst, mplapackint &ilst, mpreal *work, mplapackint &info);
void Rtrrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *ferr, mpreal *berr, mpreal *work, mplapackint *iwork, mplapackint &info);
void Rtrsen(const char *job, const char *compq, bool *select, mplapackint const n, mpreal *t, mplapackint const ldt, mpreal *q, mplapackint const ldq, mpreal *wr, mpreal *wi, mplapackint &m, mpreal &s, mpreal &sep, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rtrsna(const char *job, const char *howmny, bool *select, mplapackint const n, mpreal *t, mplapackint const ldt, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mpreal *s, mpreal *sep, mplapackint const mm, mplapackint &m, mpreal *work, mplapackint const ldwork, mplapackint *iwork, mplapackint &info);
void Rtrsyl(const char *trana, const char *tranb, mplapackint const isgn, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *c, mplapackint const ldc, mpreal &scale, mplapackint &info);
void Rtrti2(const char *uplo, const char *diag, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint &info);
void Rtrtri(const char *uplo, const char *diag, mplapackint const n, mpreal *a, mplapackint const lda, mplapackint &info);
void Rtrtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rtrttf(const char *transr, const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *arf, mplapackint &info);
void Rtrttp(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *ap, mplapackint &info);
void Rtzrzf(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mplapackint &info);
void ___mplapack_mpfr_initialize(void);
void iMlaver_mpfr(mplapackint &mplapack_ver_major, mplapackint &mplapack_ver_minor, mplapackint &mplapack_ver_patch, mplapackint &lapack_ver_major, mplapackint &lapack_ver_minor, mplapackint &lapack_ver_patch);
void mplapack_mpfr_finalize(void);
#endif
