/*
 * Copyright (c) 2008-2021
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_mpfr.h,v 1.5 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_LIN_MPFR_H_
#define _MPLAPACK_LIN_MPFR_H_

#include "mplapack_config.h"
#include "mpc_class.h"
#include "gmpxx.h"
#include "mpreal.h"
#include "mpcomplex.h"

using namespace mpfr;

bool Cgennd(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda);
bool Rgennd(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda);
mplapackint iMlaenv2stage_mpfr(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_mpfr(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mpreal Cqpt01(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mpcomplex *af, mplapackint const lda, mpcomplex *tau, mplapackint *jpvt, mpcomplex *work, mplapackint const lwork);
mpreal Cqrt11(mplapackint const m, mplapackint const k, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork);
mpreal Cqrt12(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *s, mpcomplex *work, mplapackint const lwork, mpreal *rwork);
mpreal Cqrt14(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *work, mplapackint const lwork);
mpreal Cqrt17(const char *trans, mplapackint const iresid, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpcomplex *c, mpcomplex *work, mplapackint const lwork);
mpreal Crzt01(mplapackint const m, mplapackint const n, mpcomplex *a, mpcomplex *af, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork);
mpreal Crzt02(mplapackint const m, mplapackint const n, mpcomplex *af, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork);
mpreal Rget06(mpreal const rcond, mpreal const rcondc);
mpreal Rlamch_mpfr(const char *cmach);
mpreal Rqpt01(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mpreal *af, mplapackint const lda, mpreal *tau, mplapackint *jpvt, mpreal *work, mplapackint const lwork);
mpreal Rqrt11(mplapackint const m, mplapackint const k, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork);
mpreal Rqrt12(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *s, mpreal *work, mplapackint const lwork);
mpreal Rqrt14(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *work, mplapackint const lwork);
mpreal Rqrt17(const char *trans, mplapackint const iresid, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *c, mpreal *work, mplapackint const lwork);
mpreal Rrzt01(mplapackint const m, mplapackint const n, mpreal *a, mpreal *af, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork);
mpreal Rrzt02(mplapackint const m, mplapackint const n, mpreal *af, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork);
void Aladhd(mplapackint const iounit, const char *path);
void Alaerh(const char *path, const char *subnam, mplapackint const info, mplapackint const infoe, const char *opts, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const n5, mplapackint const imat, mplapackint const nfail, mplapackint &nerrs, mplapackint const nout);
void Alaesm(const char *path, bool const ok, mplapackint const nout);
void Alahd(mplapackint const iounit, const char *path);
void Alareq(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alasum(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasvm(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Cchkeq(mpreal const thresh, mplapackint const nout);
void Cchkgb(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mpcomplex *a, mplapackint const la, mpcomplex *afac, mplapackint const lafac, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkge(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mpcomplex *a, mpcomplex *af, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *e, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchklq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *af, mpcomplex *aq, mpcomplex *al, mpcomplex *ac, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *tau, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cchklqt(mpreal const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchklqtp(mpreal const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cchkpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cchkpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cchkps(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nrank, mplapackint *rankval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *perm, mplapackint *piv, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cchkpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mpcomplex *a, mpreal *d, mpcomplex *e, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cchkq3(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mpreal const thresh, mpcomplex *a, mpcomplex *copya, mpreal *s, mpcomplex *tau, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkql(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *af, mpcomplex *aq, mpcomplex *al, mpcomplex *ac, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *tau, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cchkqr(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *af, mpcomplex *aq, mpcomplex *ar, mpcomplex *ac, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *tau, mpcomplex *work, mpreal *rwork, mplapackint *, mplapackint const nout);
void Cchkqrt(mpreal const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkqrtp(mpreal const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkrq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *af, mpcomplex *aq, mpcomplex *ar, mpcomplex *ac, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *tau, mpcomplex *work, mpreal *rwork, mplapackint *, mplapackint const nout);
void Cchksp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *e, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cchktb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *ab, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cchktp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *ap, mpcomplex *ainvp, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cchktr(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cchktsqr(mpreal const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchktz(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mpreal const thresh, bool const tsterr, mpcomplex *a, mpcomplex *copya, mpreal *s, mpcomplex *tau, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cchkunhr_col(mpreal const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cdrvgb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mpcomplex *a, mplapackint const la, mpcomplex *afb, mplapackint const lafb, mpcomplex *asav, mpcomplex *b, mpcomplex *bsav, mpcomplex *x, mpcomplex *xact, mpreal *s, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvge(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *asav, mpcomplex *b, mpcomplex *bsav, mpcomplex *x, mpcomplex *xact, mpreal *s, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mpcomplex *a, mpcomplex *af, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *e, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvls(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mpreal const thresh, bool const tsterr, mpcomplex *a, mpcomplex *copya, mpcomplex *b, mpcomplex *copyb, mpcomplex *c, mpreal *s, mpreal *copys, mplapackint const nout);
void Cdrvpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *asav, mpcomplex *b, mpcomplex *bsav, mpcomplex *x, mpcomplex *xact, mpreal *s, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cdrvpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *asav, mpcomplex *b, mpcomplex *bsav, mpcomplex *x, mpcomplex *xact, mpreal *s, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cdrvpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *asav, mpcomplex *b, mpcomplex *bsav, mpcomplex *x, mpcomplex *xact, mpreal *s, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cdrvpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mpcomplex *a, mpreal *d, mpcomplex *e, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint const nout);
void Cdrvrf1(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpreal const thresh, mpcomplex *a, mplapackint const lda, mpcomplex *arf, mpreal *work);
void Cdrvrf2(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpcomplex *a, mplapackint const lda, mpcomplex *arf, mpcomplex *ap, mpcomplex *asav);
void Cdrvrf3(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpreal const thresh, mpcomplex *a, mplapackint const lda, mpcomplex *arf, mpcomplex *b1, mpcomplex *b2, mpreal *d_work_Clange, mpcomplex *z_work_Cgeqrf, mpcomplex *tau);
void Cdrvrf4(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpreal const thresh, mpcomplex *c1, mpcomplex *c2, mplapackint const ldc, mpcomplex *crf, mpcomplex *a, mplapackint const lda, mpreal *d_work_Clange);
void Cdrvrfp(mplapackint const nout, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnt, mplapackint *ntval, mpreal const thresh, mpcomplex *a, mpcomplex *asav, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *bsav, mpcomplex *xact, mpcomplex *x, mpcomplex *arf, mpcomplex *arfinv, mpcomplex *z_work_Clatms, mpcomplex *z_work_Cpot02, mpcomplex *z_work_Cpot03, mpreal *d_work_Clatms, mpreal *d_work_Clanhe, mpreal *d_work_Cpot01, mpreal *d_work_Cpot02, mpreal *d_work_Cpot03);
void Cdrvsp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *e, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpcomplex *a, mpcomplex *afac, mpcomplex *ainv, mpcomplex *b, mpcomplex *x, mpcomplex *xact, mpcomplex *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Cerrge(const char *path, mplapackint const nunit);
void Cerrgt(const char *path, mplapackint const nunit);
void Cerrhe(const char *path, mplapackint const nunit);
void Cerrlq(const char *path, mplapackint const nunit);
void Cerrlqt(const char *path, mplapackint const nunit);
void Cerrlqtp(const char *path, mplapackint const nunit);
void Cerrls(const char *path, mplapackint const nunit);
void Cerrpo(const char *path, mplapackint const nunit);
void Cerrps(const char *path, mplapackint const nunit);
void Cerrql(const char *path, mplapackint const nunit);
void Cerrqp(const char *path, mplapackint const nunit);
void Cerrqr(const char *path, mplapackint const nunit);
void Cerrqrt(const char *path, mplapackint const nunit);
void Cerrqrtp(const char *path, mplapackint const nunit);
void Cerrrfp(mplapackint const nunit);
void Cerrrq(const char *path, mplapackint const nunit);
void Cerrsy(const char *path, mplapackint const nunit);
void Cerrtr(const char *path, mplapackint const nunit);
void Cerrtsqr(const char *path, mplapackint const nunit);
void Cerrtz(const char *path, mplapackint const nunit);
void Cerrunhr_col(const char *path, mplapackint const nunit);
void Cerrvx(const char *path, mplapackint const nunit);
void Cgbt01(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mplapackint *ipiv, mpcomplex *work, mpreal &resid);
void Cgbt02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal &resid);
void Cgbt05(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpcomplex *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Cgelqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgeqls(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgeqrs(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cgerqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *tau, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mplapackint const lwork, mplapackint &info);
void Cget01(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mplapackint *ipiv, mpreal *rwork, mpreal &resid);
void Cget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Cget03(mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *ainv, mplapackint const ldainv, mpcomplex *work, mplapackint const ldwork, mpreal *rwork, mpreal &rcond, mpreal &resid);
void Cget04(mplapackint const n, mplapackint const nrhs, mpcomplex *x, mplapackint const ldx, mpcomplex *xact, mplapackint const ldxact, mpreal const rcond, mpreal &resid);
void Cget07(const char *trans, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpcomplex *xact, mplapackint const ldxact, mpreal *ferr, bool const chkferr, mpreal *berr, mpreal *reslts);
void Cget08(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Cgtt01(mplapackint const n, mpcomplex *dl, mpcomplex *d, mpcomplex *du, mpcomplex *dlf, mpcomplex *df, mpcomplex *duf, mpcomplex *du2, mplapackint *ipiv, mpcomplex *work, mplapackint const ldwork, mpreal *rwork, mpreal &resid);
void Cgtt02(const char *trans, mplapackint const n, mplapackint const nrhs, mpcomplex *dl, mpcomplex *d, mpcomplex *du, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal &resid);
void Cgtt05(const char *trans, mplapackint const n, mplapackint const nrhs, mpcomplex *dl, mpcomplex *d, mpcomplex *du, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpcomplex *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Chet01(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mplapackint *ipiv, mpcomplex *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Chet01_3(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mpcomplex *e, mplapackint *ipiv, mpcomplex *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Chet01_aa(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mplapackint *ipiv, mpcomplex *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Chet01_rook(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mplapackint *ipiv, mpcomplex *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Chpt01(const char *uplo, mplapackint const n, mpcomplex *a, mpcomplex *afac, mplapackint *ipiv, mpcomplex *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Clahilb(mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal *work, mplapackint &info, const char *path);
void Claipd(mplapackint const n, mpcomplex *a, mplapackint const inda, mplapackint const vinda);
void Claptm(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal const alpha, mpreal *d, mpcomplex *e, mpcomplex *x, mplapackint const ldx, mpreal const beta, mpcomplex *b, mplapackint const ldb);
void Clarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Clatb4(const char *path, mplapackint const imat, mplapackint const m, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, mpreal &anorm, mplapackint &mode, mpreal &cndnum, char *dist);
void Clatb5(const char *path, mplapackint const imat, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, mpreal &anorm, mplapackint &mode, mpreal &cndnum, char *dist);
void Clatsp(const char *uplo, mplapackint const n, mpcomplex *x, mplapackint *iseed);
void Clatsy(const char *uplo, mplapackint const n, mpcomplex *x, mplapackint const ldx, mplapackint *iseed);
void Clattb(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpcomplex *b, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Clattp(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mpcomplex *ap, mpcomplex *b, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Clattr(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mpcomplex *work, mpreal *rwork, mplapackint &info);
void Clavhe(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Clavhe_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Clavhp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Clavsp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Clavsy(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Clavsy_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mplapackint *ipiv, mpcomplex *b, mplapackint const ldb, mplapackint &info);
void Clqt01(mplapackint const m, mplapackint const n, mpcomplex *a, mpcomplex *af, mpcomplex *q, mpcomplex *l, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Clqt02(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mpcomplex *af, mpcomplex *q, mpcomplex *l, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Clqt03(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *af, mpcomplex *c, mpcomplex *cc, mpcomplex *q, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Clqt04(mplapackint const m, mplapackint const n, mplapackint const nb, mpreal *result);
void Clqt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, mpreal *result);
void Cpbt01(const char *uplo, mplapackint const n, mplapackint const kd, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mpreal *rwork, mpreal &resid);
void Cpbt02(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Cpbt05(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpcomplex *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Cpot01(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mpreal *rwork, mpreal &resid);
void Cpot02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Cpot03(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *ainv, mplapackint const ldainv, mpcomplex *work, mplapackint const ldwork, mpreal *rwork, mpreal &rcond, mpreal &resid);
void Cpot05(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpcomplex *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Cpot06(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Cppt01(const char *uplo, mplapackint const n, mpcomplex *a, mpcomplex *afac, mpreal *rwork, mpreal &resid);
void Cppt02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Cppt03(const char *uplo, mplapackint const n, mpcomplex *a, mpcomplex *ainv, mpcomplex *work, mplapackint const ldwork, mpreal *rwork, mpreal &rcond, mpreal &resid);
void Cppt05(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpcomplex *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Cpst01(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mpcomplex *perm, mplapackint const ldperm, mplapackint *piv, mpreal *rwork, mpreal &resid, mplapackint const rank);
void Cptt01(mplapackint const n, mpreal *d, mpcomplex *e, mpreal *df, mpcomplex *ef, mpcomplex *work, mpreal &resid);
void Cptt02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *d, mpcomplex *e, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal &resid);
void Cptt05(mplapackint const n, mplapackint const nrhs, mpreal *d, mpcomplex *e, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpcomplex *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Cqlt01(mplapackint const m, mplapackint const n, mpcomplex *a, mpcomplex *af, mpcomplex *q, mpcomplex *l, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Cqlt02(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mpcomplex *af, mpcomplex *q, mpcomplex *l, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Cqlt03(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *af, mpcomplex *c, mpcomplex *cc, mpcomplex *q, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Cqrt01(mplapackint const m, mplapackint const n, mpcomplex *a, mpcomplex *af, mpcomplex *q, mpcomplex *r, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Cqrt01p(mplapackint const m, mplapackint const n, mpcomplex *a, mpcomplex *af, mpcomplex *q, mpcomplex *r, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Cqrt02(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mpcomplex *af, mpcomplex *q, mpcomplex *r, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Cqrt03(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *af, mpcomplex *c, mpcomplex *cc, mpcomplex *q, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Cqrt04(mplapackint const m, mplapackint const n, mplapackint const nb, mpreal *result);
void Cqrt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, mpreal *result);
void Cqrt13(mplapackint const scale, mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal &norma, mplapackint *iseed);
void Cqrt15(mplapackint const scale, mplapackint const rksel, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpreal *s, mplapackint &rank, mpreal &norma, mpreal &normb, mplapackint *iseed, mpcomplex *work, mplapackint const lwork);
void Cqrt16(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Crqt01(mplapackint const m, mplapackint const n, mpcomplex *a, mpcomplex *af, mpcomplex *q, mpcomplex *r, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Crqt02(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *a, mpcomplex *af, mpcomplex *q, mpcomplex *r, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Crqt03(mplapackint const m, mplapackint const n, mplapackint const k, mpcomplex *af, mpcomplex *c, mpcomplex *cc, mpcomplex *q, mplapackint const lda, mpcomplex *tau, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Csbmv(const char *uplo, mplapackint const n, mplapackint const k, mpcomplex const alpha, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const incx, mpcomplex const beta, mpcomplex *y, mplapackint const incy);
void Cspt01(const char *uplo, mplapackint const n, mpcomplex *a, mpcomplex *afac, mplapackint *ipiv, mpcomplex *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Cspt02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Cspt03(const char *uplo, mplapackint const n, mpcomplex *a, mpcomplex *ainv, mpcomplex *work, mplapackint const ldw, mpreal *rwork, mpreal &rcond, mpreal &resid);
void Csyt01(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mplapackint *ipiv, mpcomplex *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Csyt01_3(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mpcomplex *e, mplapackint *ipiv, mpcomplex *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Csyt01_aa(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mplapackint *ipiv, mpcomplex *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Csyt01_rook(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *afac, mplapackint const ldafac, mplapackint *ipiv, mpcomplex *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Csyt02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Csyt03(const char *uplo, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *ainv, mplapackint const ldainv, mpcomplex *work, mplapackint const ldwork, mpreal *rwork, mpreal &rcond, mpreal &resid);
void Ctbt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mpreal *rwork, mpreal &resid);
void Ctbt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpreal const scale, mpreal *cnorm, mpreal const tscal, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mpreal &resid);
void Ctbt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpcomplex *ab, mplapackint const ldab, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpcomplex *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Ctbt06(mpreal const rcond, mpreal const rcondc, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, mpcomplex *ab, mplapackint const ldab, mpreal *rwork, mpreal &rat);
void Ctpt01(const char *uplo, const char *diag, mplapackint const n, mpcomplex *ap, mpcomplex *ainvp, mpreal &rcond, mpreal *rwork, mpreal &resid);
void Ctpt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mpreal *rwork, mpreal &resid);
void Ctpt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpreal const scale, mpreal *cnorm, mpreal const tscal, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mpreal &resid);
void Ctpt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *ap, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpcomplex *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Ctpt06(mpreal const rcond, mpreal const rcondc, const char *uplo, const char *diag, mplapackint const n, mpcomplex *ap, mpreal *rwork, mpreal &rat);
void Ctrt01(const char *uplo, const char *diag, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *ainv, mplapackint const ldainv, mpreal &rcond, mpreal *rwork, mpreal &resid);
void Ctrt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mpreal *rwork, mpreal &resid);
void Ctrt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpreal const scale, mpreal *cnorm, mpreal const tscal, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mpreal &resid);
void Ctrt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *x, mplapackint const ldx, mpcomplex *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Ctrt06(mpreal const rcond, mpreal const rcondc, const char *uplo, const char *diag, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *rwork, mpreal &rat);
void Ctsqr01(const char *tssw, mplapackint &m, mplapackint &n, mplapackint const mb, mplapackint const nb, mpreal *result);
void Cunhr_col01(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, mpreal *result);
void Cunhr_col02(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, mpreal *result);
void Mxerbla_mpfr(const char *srname, int info);
void Rchkeq(mpreal const thresh, mplapackint const nout);
void Rchkgb(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mpreal *a, mplapackint const la, mpreal *afac, mplapackint const lafac, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkge(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mpreal *a, mpreal *af, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchklq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *af, mpreal *aq, mpreal *al, mpreal *ac, mpreal *b, mpreal *x, mpreal *xact, mpreal *tau, mpreal *work, mpreal *rwork, mplapackint const nout);
void Rchklqt(mpreal const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchklqtp(mpreal const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkorhr_col(mpreal const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkps(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nrank, mplapackint *rankval, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *afac, mpreal *perm, mplapackint *piv, mpreal *work, mpreal *rwork, mplapackint const nout);
void Rchkpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mpreal *a, mpreal *d, mpreal *e, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint const nout);
void Rchkq3(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mpreal const thresh, mpreal *a, mpreal *copya, mpreal *s, mpreal *tau, mpreal *work, mplapackint *iwork, mplapackint const nout);
void Rchkql(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *af, mpreal *aq, mpreal *al, mpreal *ac, mpreal *b, mpreal *x, mpreal *xact, mpreal *tau, mpreal *work, mpreal *rwork, mplapackint const nout);
void Rchkqr(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *af, mpreal *aq, mpreal *ar, mpreal *ac, mpreal *b, mpreal *x, mpreal *xact, mpreal *tau, mpreal *work, mpreal *rwork, mplapackint *, mplapackint const nout);
void Rchkqrt(mpreal const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkqrtp(mpreal const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkrq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *af, mpreal *aq, mpreal *ar, mpreal *ac, mpreal *b, mpreal *x, mpreal *xact, mpreal *tau, mpreal *work, mpreal *rwork, mplapackint *, mplapackint const nout);
void Rchksp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *afac, mpreal *e, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *ab, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *ap, mpreal *ainvp, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktr(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktsqr(mpreal const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchktz(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mpreal const thresh, bool const tsterr, mpreal *a, mpreal *copya, mpreal *s, mpreal *tau, mpreal *work, mplapackint const nout);
void Rdrvgb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mpreal *a, mplapackint const la, mpreal *afb, mplapackint const lafb, mpreal *asav, mpreal *b, mpreal *bsav, mpreal *x, mpreal *xact, mpreal *s, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvge(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *afac, mpreal *asav, mpreal *b, mpreal *bsav, mpreal *x, mpreal *xact, mpreal *s, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mpreal *a, mpreal *af, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvls(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mpreal const thresh, bool const tsterr, mpreal *a, mpreal *copya, mpreal *b, mpreal *copyb, mpreal *c, mpreal *s, mpreal *copys, mplapackint const nout);
void Rdrvpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *afac, mpreal *asav, mpreal *b, mpreal *bsav, mpreal *x, mpreal *xact, mpreal *s, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *afac, mpreal *asav, mpreal *b, mpreal *bsav, mpreal *x, mpreal *xact, mpreal *s, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *afac, mpreal *asav, mpreal *b, mpreal *bsav, mpreal *x, mpreal *xact, mpreal *s, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mpreal *a, mpreal *d, mpreal *e, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint const nout);
void Rdrvrf1(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpreal const thresh, mpreal *a, mplapackint const lda, mpreal *arf, mpreal *work);
void Rdrvrf2(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpreal *a, mplapackint const lda, mpreal *arf, mpreal *ap, mpreal *asav);
void Rdrvrf3(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpreal const thresh, mpreal *a, mplapackint const lda, mpreal *arf, mpreal *b1, mpreal *b2, mpreal *d_work_Rlange, mpreal *d_work_Rgeqrf, mpreal *tau);
void Rdrvrf4(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpreal const thresh, mpreal *c1, mpreal *c2, mplapackint const ldc, mpreal *crf, mpreal *a, mplapackint const lda, mpreal *d_work_Rlange);
void Rdrvrfp(mplapackint const nout, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnt, mplapackint *ntval, mpreal const thresh, mpreal *a, mpreal *asav, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *bsav, mpreal *xact, mpreal *x, mpreal *arf, mpreal *arfinv, mpreal *d_work_Rlatms, mpreal *d_work_Rpot01, mpreal *d_temp_Rpot02, mpreal *d_temp_Rpot03, mpreal *d_work_Rlansy, mpreal *d_work_Rpot02, mpreal *d_work_Rpot03);
void Rdrvsp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *afac, mpreal *e, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpreal const thresh, bool const tsterr, mplapackint const nmax, mpreal *a, mpreal *afac, mpreal *ainv, mpreal *b, mpreal *x, mpreal *xact, mpreal *work, mpreal *rwork, mplapackint *iwork, mplapackint const nout);
void Rerrge(const char *path, mplapackint const nunit);
void Rerrgt(const char *path, mplapackint const nunit);
void Rerrlq(const char *path, mplapackint const nunit);
void Rerrlqt(const char *path, mplapackint const nunit);
void Rerrlqtp(const char *path, mplapackint const nunit);
void Rerrls(const char *path, mplapackint const nunit);
void Rerrorhr_col(const char *path, mplapackint const nunit);
void Rerrpo(const char *path, mplapackint const nunit);
void Rerrps(const char *path, mplapackint const nunit);
void Rerrql(const char *path, mplapackint const nunit);
void Rerrqp(const char *path, mplapackint const nunit);
void Rerrqr(const char *path, mplapackint const nunit);
void Rerrqrt(const char *path, mplapackint const nunit);
void Rerrqrtp(const char *path, mplapackint const nunit);
void Rerrrfp(mplapackint const nunit);
void Rerrrq(const char *path, mplapackint const nunit);
void Rerrsy(const char *path, mplapackint const nunit);
void Rerrtr(const char *path, mplapackint const nunit);
void Rerrtsqr(const char *path, mplapackint const nunit);
void Rerrtz(const char *path, mplapackint const nunit);
void Rerrvx(const char *path, mplapackint const nunit);
void Rgbt01(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpreal *a, mplapackint const lda, mpreal *afac, mplapackint const ldafac, mplapackint *ipiv, mpreal *work, mpreal &resid);
void Rgbt02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal &resid);
void Rgbt05(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Rgelqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgeqls(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgeqrs(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rgerqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *tau, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint const lwork, mplapackint &info);
void Rget01(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *afac, mplapackint const ldafac, mplapackint *ipiv, mpreal *rwork, mpreal &resid);
void Rget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Rget03(mplapackint const n, mpreal *a, mplapackint const lda, mpreal *ainv, mplapackint const ldainv, mpreal *work, mplapackint const ldwork, mpreal *rwork, mpreal &rcond, mpreal &resid);
void Rget04(mplapackint const n, mplapackint const nrhs, mpreal *x, mplapackint const ldx, mpreal *xact, mplapackint const ldxact, mpreal const rcond, mpreal &resid);
void Rget07(const char *trans, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *xact, mplapackint const ldxact, mpreal *ferr, bool const chkferr, mpreal *berr, mpreal *reslts);
void Rget08(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Rgtt01(mplapackint const n, mpreal *dl, mpreal *d, mpreal *du, mpreal *dlf, mpreal *df, mpreal *duf, mpreal *du2, mplapackint *ipiv, mpreal *work, mplapackint const ldwork, mpreal *rwork, mpreal &resid);
void Rgtt02(const char *trans, mplapackint const n, mplapackint const nrhs, mpreal *dl, mpreal *d, mpreal *du, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal &resid);
void Rgtt05(const char *trans, mplapackint const n, mplapackint const nrhs, mpreal *dl, mpreal *d, mpreal *du, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Rlahilb(mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *work, mplapackint &info);
void Rlaord(const char *job, mplapackint const n, mpreal *x, mplapackint const incx);
void Rlaptm(mplapackint const n, mplapackint const nrhs, mpreal const alpha, mpreal *d, mpreal *e, mpreal *x, mplapackint const ldx, mpreal const beta, mpreal *b, mplapackint const ldb);
void Rlarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Rlatb4(const char *path, mplapackint const imat, mplapackint const m, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, mpreal &anorm, mplapackint &mode, mpreal &cndnum, char *dist);
void Rlatb5(const char *path, mplapackint const imat, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, mpreal &anorm, mplapackint &mode, mpreal &cndnum, char *dist);
void Rlattb(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *b, mpreal *work, mplapackint &info);
void Rlattp(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mpreal *a, mpreal *b, mpreal *work, mplapackint &info);
void Rlattr(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mpreal *work, mplapackint &info);
void Rlavsp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rlavsy(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rlavsy_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mplapackint *ipiv, mpreal *b, mplapackint const ldb, mplapackint &info);
void Rlqt01(mplapackint const m, mplapackint const n, mpreal *a, mpreal *af, mpreal *q, mpreal *l, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rlqt02(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mpreal *af, mpreal *q, mpreal *l, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rlqt03(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *af, mpreal *c, mpreal *cc, mpreal *q, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rlqt04(mplapackint const m, mplapackint const n, mplapackint const nb, mpreal *result);
void Rlqt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, mpreal *result);
void Rorhr_col01(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, mpreal *result);
void Rorhr_col02(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, mpreal *result);
void Rpbt01(const char *uplo, mplapackint const n, mplapackint const kd, mpreal *a, mplapackint const lda, mpreal *afac, mplapackint const ldafac, mpreal *rwork, mpreal &resid);
void Rpbt02(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Rpbt05(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Rpot01(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *afac, mplapackint const ldafac, mpreal *rwork, mpreal &resid);
void Rpot02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Rpot03(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *ainv, mplapackint const ldainv, mpreal *work, mplapackint const ldwork, mpreal *rwork, mpreal &rcond, mpreal &resid);
void Rpot05(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Rpot06(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Rppt01(const char *uplo, mplapackint const n, mpreal *a, mpreal *afac, mpreal *rwork, mpreal &resid);
void Rppt02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *a, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Rppt03(const char *uplo, mplapackint const n, mpreal *a, mpreal *ainv, mpreal *work, mplapackint const ldwork, mpreal *rwork, mpreal &rcond, mpreal &resid);
void Rppt05(const char *uplo, mplapackint const n, mplapackint const nrhs, mpreal *ap, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Rpst01(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *afac, mplapackint const ldafac, mpreal *perm, mplapackint const ldperm, mplapackint *piv, mpreal *rwork, mpreal &resid, mplapackint const rank);
void Rptt01(mplapackint const n, mpreal *d, mpreal *e, mpreal *df, mpreal *ef, mpreal *work, mpreal &resid);
void Rptt02(mplapackint const n, mplapackint const nrhs, mpreal *d, mpreal *e, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal &resid);
void Rptt05(mplapackint const n, mplapackint const nrhs, mpreal *d, mpreal *e, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Rqlt01(mplapackint const m, mplapackint const n, mpreal *a, mpreal *af, mpreal *q, mpreal *l, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rqlt02(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mpreal *af, mpreal *q, mpreal *l, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rqlt03(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *af, mpreal *c, mpreal *cc, mpreal *q, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rqrt01(mplapackint const m, mplapackint const n, mpreal *a, mpreal *af, mpreal *q, mpreal *r, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rqrt01p(mplapackint const m, mplapackint const n, mpreal *a, mpreal *af, mpreal *q, mpreal *r, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rqrt02(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mpreal *af, mpreal *q, mpreal *r, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rqrt03(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *af, mpreal *c, mpreal *cc, mpreal *q, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rqrt04(mplapackint const m, mplapackint const n, mplapackint const nb, mpreal *result);
void Rqrt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, mpreal *result);
void Rqrt13(mplapackint const scale, mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal &norma, mplapackint *iseed);
void Rqrt15(mplapackint const scale, mplapackint const rksel, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *s, mplapackint &rank, mpreal &norma, mpreal &normb, mplapackint *iseed, mpreal *work, mplapackint const lwork);
void Rqrt16(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Rrqt01(mplapackint const m, mplapackint const n, mpreal *a, mpreal *af, mpreal *q, mpreal *r, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rrqt02(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *a, mpreal *af, mpreal *q, mpreal *r, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rrqt03(mplapackint const m, mplapackint const n, mplapackint const k, mpreal *af, mpreal *c, mpreal *cc, mpreal *q, mplapackint const lda, mpreal *tau, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rspt01(const char *uplo, mplapackint const n, mpreal *a, mpreal *afac, mplapackint *ipiv, mpreal *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Rsyt01(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *afac, mplapackint const ldafac, mplapackint *ipiv, mpreal *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Rsyt01_3(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *afac, mplapackint const ldafac, mpreal *e, mplapackint *ipiv, mpreal *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Rsyt01_aa(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *afac, mplapackint const ldafac, mplapackint *ipiv, mpreal *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Rsyt01_rook(const char *uplo, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *afac, mplapackint const ldafac, mplapackint *ipiv, mpreal *c, mplapackint const ldc, mpreal *rwork, mpreal &resid);
void Rtbt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *work, mpreal &resid);
void Rtbt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal const scale, mpreal *cnorm, mpreal const tscal, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *work, mpreal &resid);
void Rtbt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpreal *ab, mplapackint const ldab, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Rtbt06(mpreal const rcond, mpreal const rcondc, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, mpreal *ab, mplapackint const ldab, mpreal *work, mpreal &rat);
void Rtplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *t, mplapackint const ldt, mpreal *work, mplapackint &info);
void Rtpt01(const char *uplo, const char *diag, mplapackint const n, mpreal *ap, mpreal *ainvp, mpreal &rcond, mpreal *work, mpreal &resid);
void Rtpt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *ap, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *work, mpreal &resid);
void Rtpt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *ap, mpreal const scale, mpreal *cnorm, mpreal const tscal, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *work, mpreal &resid);
void Rtpt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *ap, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Rtpt06(mpreal const rcond, mpreal const rcondc, const char *uplo, const char *diag, mplapackint const n, mpreal *ap, mpreal *work, mpreal &rat);
void Rtrt01(const char *uplo, const char *diag, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *ainv, mplapackint const ldainv, mpreal &rcond, mpreal *work, mpreal &resid);
void Rtrt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *work, mpreal &resid);
void Rtrt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal const scale, mpreal *cnorm, mpreal const tscal, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *work, mpreal &resid);
void Rtrt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *x, mplapackint const ldx, mpreal *xact, mplapackint const ldxact, mpreal *ferr, mpreal *berr, mpreal *reslts);
void Rtrt06(mpreal const rcond, mpreal const rcondc, const char *uplo, const char *diag, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *work, mpreal &rat);
void Rtsqr01(const char *tssw, mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpreal *result);
void chkxer(const char *srnamt, mplapackint const &infot, mplapackint const &nout, bool &lerr, bool &ok);
void icopy(mplapackint const &n, mplapackint *sx, mplapackint const &incx, mplapackint *sy, mplapackint const &incy);
void xlaenv(mplapackint const &ispec, mplapackint const &nvalue);
#endif
