/*
 * Copyright (c) 2008-2021
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_gmp.h,v 1.34 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_GMP_H_
#define _MPLAPACK_GMP_H_

#include "mplapack_config.h"
#include "gmpxx.h"
#include "mpc_class.h"

bool Mlsamen_gmp(mplapackint n, const char *a, const char *b);
bool Risnan(mpf_class const din);
bool Rlaisnan(mpf_class const din1, mpf_class const din2);
mpc_class Cladiv(mpc_class const x, mpc_class const y);
mpf_class Clangb(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, mpc_class *ab, mplapackint const ldab, mpf_class *work);
mpf_class Clange(const char *norm, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *work);
mpf_class Clangt(const char *norm, mplapackint const n, mpc_class *dl, mpc_class *d, mpc_class *du);
mpf_class Clanhb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, mpc_class *ab, mplapackint const ldab, mpf_class *work);
mpf_class Clanhe(const char *norm, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *work);
mpf_class Clanhf(const char *norm, const char *transr, const char *uplo, mplapackint const n, mpc_class *a, mpf_class *work);
mpf_class Clanhp(const char *norm, const char *uplo, mplapackint const n, mpc_class *ap, mpf_class *work);
mpf_class Clanhs(const char *norm, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *work);
mpf_class Clanht(const char *norm, mplapackint const n, mpf_class *d, mpc_class *e);
mpf_class Clansb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, mpc_class *ab, mplapackint const ldab, mpf_class *work);
mpf_class Clansp(const char *norm, const char *uplo, mplapackint const n, mpc_class *ap, mpf_class *work);
mpf_class Clansy(const char *norm, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *work);
mpf_class Clantb(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const k, mpc_class *ab, mplapackint const ldab, mpf_class *work);
mpf_class Clantp(const char *norm, const char *uplo, const char *diag, mplapackint const n, mpc_class *ap, mpf_class *work);
mpf_class Clantr(const char *norm, const char *uplo, const char *diag, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *work);
mpf_class Mmaxval(mpf_class *dx, mplapackint const start, mplapackint const end, mplapackint incx);
mpf_class RCsum1(mplapackint const n, mpc_class *cx, mplapackint const incx);
mpf_class Rla_gbrcond(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mpf_class *ab, mplapackint const ldab, mpf_class *afb, mplapackint const ldafb, mplapackint *ipiv, mplapackint const cmode, mpf_class *c, mplapackint &info, mpf_class *work, mplapackint *iwork);
mpf_class Rla_gbrpvgrw(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const ncols, mpf_class *ab, mplapackint const ldab, mpf_class *afb, mplapackint const ldafb);
mpf_class Rla_gercond(const char *trans, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *af, mplapackint const ldaf, mplapackint *ipiv, mplapackint const cmode, mpf_class *c, mplapackint &info, mpf_class *work, mplapackint *iwork);
mpf_class Rla_gerpvgrw(mplapackint const n, mplapackint const ncols, mpf_class *a, mplapackint const lda, mpf_class *af, mplapackint const ldaf);
mpf_class Rla_porcond(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *af, mplapackint const ldaf, mplapackint const cmode, mpf_class *c, mplapackint &info, mpf_class *work, mplapackint *iwork);
mpf_class Rla_syrcond(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *af, mplapackint const ldaf, mplapackint *ipiv, mplapackint const cmode, mpf_class *c, mplapackint &info, mpf_class *work, mplapackint *iwork);
mpf_class Rla_syrpvgrw(const char *uplo, mplapackint const n, mplapackint const info, mpf_class *a, mplapackint const lda, mpf_class *af, mplapackint const ldaf, mplapackint *ipiv, mpf_class *work);
mpf_class Rladiv2(mpf_class const &a, mpf_class const &b, mpf_class const &c, mpf_class const &d, mpf_class const &r, mpf_class const &t);
mpf_class Rlamc3(mpf_class a, mpf_class b);
mpf_class Rlamch_gmp(const char *cmach);
mpf_class Rlangb(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, mpf_class *ab, mplapackint const ldab, mpf_class *work);
mpf_class Rlange(const char *norm, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *work);
mpf_class Rlangt(const char *norm, mplapackint const n, mpf_class *dl, mpf_class *d, mpf_class *du);
mpf_class Rlanhs(const char *norm, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *work);
mpf_class Rlansb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, mpf_class *ab, mplapackint const ldab, mpf_class *work);
mpf_class Rlansf(const char *norm, const char *transr, const char *uplo, mplapackint const n, mpf_class *a, mpf_class *work);
mpf_class Rlansp(const char *norm, const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *work);
mpf_class Rlanst(const char *norm, mplapackint const n, mpf_class *d, mpf_class *e);
mpf_class Rlansy(const char *norm, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *work);
mpf_class Rlantb(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const k, mpf_class *ab, mplapackint const ldab, mpf_class *work);
mpf_class Rlantp(const char *norm, const char *uplo, const char *diag, mplapackint const n, mpf_class *ap, mpf_class *work);
mpf_class Rlantr(const char *norm, const char *uplo, const char *diag, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *work);
mpf_class Rlapy2(mpf_class const x, mpf_class const y);
mpf_class Rlapy3(mpf_class const x, mpf_class const y, mpf_class const z);
mplapackint Mmaxloc(mpf_class *dx, mplapackint const start, mplapackint const end, mplapackint const incx);
mplapackint Rlaneg(mplapackint const n, mpf_class *d, mpf_class *lld, mpf_class const sigma, mpf_class const, mplapackint const r);
mplapackint iCmax1(mplapackint const n, mpc_class *zx, mplapackint const incx);
mplapackint iMieeeck_gmp(mplapackint const &ispec, mpf_class const &zero, mpf_class const &one);
mplapackint iMladiag(const char *diag);
mplapackint iMladlc(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda);
mplapackint iMladlr(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda);
mplapackint iMlaenv2stage_gmp(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_gmp(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaprec(const char *prec);
mplapackint iMlatrans(const char *trans);
mplapackint iMlauplo(const char *uplo);
mplapackint iMlazlc(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda);
mplapackint iMlazlr(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda);
mplapackint iMparam2stage_gmp(mplapackint const ispec, const char *name, const char *opts, mplapackint const ni, mplapackint const nbi, mplapackint const ibi, mplapackint const nxi);
mplapackint iMparmq_gmp(mplapackint const ispec, const char *name, const char *opts, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mplapackint const lwork);
void CRrscl(mplapackint const n, mpf_class const sa, mpc_class *sx, mplapackint const incx);
void Cbbcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, mplapackint const m, mplapackint const p, mplapackint const q, mpf_class *theta, mpf_class *phi, mpc_class *u1, mplapackint const ldu1, mpc_class *u2, mplapackint const ldu2, mpc_class *v1t, mplapackint const ldv1t, mpc_class *v2t, mplapackint const ldv2t, mpf_class *b11d, mpf_class *b11e, mpf_class *b12d, mpf_class *b12e, mpf_class *b21d, mpf_class *b21e, mpf_class *b22d, mpf_class *b22e, mpf_class *rwork, mplapackint const lrwork, mplapackint &info);
void Cbdsqr(const char *uplo, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, mpf_class *d, mpf_class *e, mpc_class *vt, mplapackint const ldvt, mpc_class *u, mplapackint const ldu, mpc_class *c, mplapackint const ldc, mpf_class *rwork, mplapackint &info);
void Cgbbrd(const char *vect, mplapackint const m, mplapackint const n, mplapackint const ncc, mplapackint const kl, mplapackint const ku, mpc_class *ab, mplapackint const ldab, mpf_class *d, mpf_class *e, mpc_class *q, mplapackint const ldq, mpc_class *pt, mplapackint const ldpt, mpc_class *c, mplapackint const ldc, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cgbcon(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, mpc_class *ab, mplapackint const ldab, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cgbequ(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpc_class *ab, mplapackint const ldab, mpf_class *r, mpf_class *c, mpf_class &rowcnd, mpf_class &colcnd, mpf_class &amax, mplapackint &info);
void Cgbequb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpc_class *ab, mplapackint const ldab, mpf_class *r, mpf_class *c, mpf_class &rowcnd, mpf_class &colcnd, mpf_class &amax, mplapackint &info);
void Cgbrfs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpc_class *afb, mplapackint const ldafb, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cgbsv(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cgbsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpc_class *afb, mplapackint const ldafb, mplapackint *ipiv, char *equed, mpf_class *r, mpf_class *c, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cgbtf2(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpc_class *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Cgbtrf(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpc_class *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Cgbtrs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cgebak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *scale, mplapackint const m, mpc_class *v, mplapackint const ldv, mplapackint &info);
void Cgebal(const char *job, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint &ilo, mplapackint &ihi, mpf_class *scale, mplapackint &info);
void Cgebd2(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpc_class *tauq, mpc_class *taup, mpc_class *work, mplapackint &info);
void Cgebrd(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpc_class *tauq, mpc_class *taup, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgecon(const char *norm, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cgeequ(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *r, mpf_class *c, mpf_class &rowcnd, mpf_class &colcnd, mpf_class &amax, mplapackint &info);
void Cgeequb(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *r, mpf_class *c, mpf_class &rowcnd, mpf_class &colcnd, mpf_class &amax, mplapackint &info);
void Cgees(const char *jobvs, const char *sort, bool (*select)(mpc_class), mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint &sdim, mpc_class *w, mpc_class *vs, mplapackint const ldvs, mpc_class *work, mplapackint const lwork, mpf_class *rwork, bool *bwork, mplapackint &info);
void Cgeesx(const char *jobvs, const char *sort, bool (*select)(mpc_class), const char *sense, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint &sdim, mpc_class *w, mpc_class *vs, mplapackint const ldvs, mpf_class &rconde, mpf_class &rcondv, mpc_class *work, mplapackint const lwork, mpf_class *rwork, bool *bwork, mplapackint &info);
void Cgeev(const char *jobvl, const char *jobvr, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *w, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Cgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *w, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, mpf_class *scale, mpf_class &abnrm, mpf_class *rconde, mpf_class *rcondv, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Cgehd2(mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint &info);
void Cgehrd(mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgejsv(const char *joba, const char *jobu, const char *jobv, const char *jobr, const char *jobt, const char *jobp, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *sva, mpc_class *u, mplapackint const ldu, mpc_class *v, mplapackint const ldv, mpc_class *cwork, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cgelq(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const tsize, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgelq2(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint &info);
void Cgelqf(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgelqt(mplapackint const m, mplapackint const n, mplapackint const mb, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mpc_class *work, mplapackint &info);
void Cgelqt3(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mplapackint &info);
void Cgels(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgelsd(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpf_class *s, mpf_class const rcond, mplapackint &rank, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, mplapackint &info);
void Cgelss(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpf_class *s, mpf_class const rcond, mplapackint &rank, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Cgelsy(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mplapackint *jpvt, mpf_class const rcond, mplapackint &rank, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Cgemlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const tsize, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgemlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mpc_class *v, mplapackint const ldv, mpc_class *t, mplapackint const ldt, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint &info);
void Cgemqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const tsize, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgemqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const nb, mpc_class *v, mplapackint const ldv, mpc_class *t, mplapackint const ldt, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint &info);
void Cgeql2(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint &info);
void Cgeqlf(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgeqp3(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *jpvt, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Cgeqr(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const tsize, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgeqr2(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint &info);
void Cgeqr2p(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint &info);
void Cgeqrf(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgeqrfp(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgeqrt(mplapackint const m, mplapackint const n, mplapackint const nb, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mpc_class *work, mplapackint &info);
void Cgeqrt2(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mplapackint &info);
void Cgeqrt3(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mplapackint &info);
void Cgerfs(const char *trans, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *af, mplapackint const ldaf, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cgerq2(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint &info);
void Cgerqf(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgesc2(mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *rhs, mplapackint *ipiv, mplapackint *jpiv, mpf_class &scale);
void Cgesdd(const char *jobz, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *s, mpc_class *u, mplapackint const ldu, mpc_class *vt, mplapackint const ldvt, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, mplapackint &info);
void Cgesv(mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cgesvd(const char *jobu, const char *jobvt, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *s, mpc_class *u, mplapackint const ldu, mpc_class *vt, mplapackint const ldvt, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Cgesvdq(const char *joba, const char *jobp, const char *jobr, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *s, mpc_class *u, mplapackint const ldu, mpc_class *v, mplapackint const ldv, mplapackint &numrank, mplapackint *iwork, mplapackint const liwork, mpc_class *cwork, mplapackint const lcwork, mpf_class *rwork, mplapackint const lrwork, mplapackint &info);
void Cgesvdx(const char *jobu, const char *jobvt, const char *range, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, mpf_class *s, mpc_class *u, mplapackint const ldu, mpc_class *vt, mplapackint const ldvt, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, mplapackint &info);
void Cgesvj(const char *joba, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *sva, mplapackint const mv, mpc_class *v, mplapackint const ldv, mpc_class *cwork, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint &info);
void Cgesvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *af, mplapackint const ldaf, mplapackint *ipiv, char *equed, mpf_class *r, mpf_class *c, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cgetc2(mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint *jpiv, mplapackint &info);
void Cgetf2(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetrf(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetrf2(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetri(mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgetrs(const char *trans, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cgetsls(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgetsqrhrt(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cggbak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *lscale, mpf_class *rscale, mplapackint const m, mpc_class *v, mplapackint const ldv, mplapackint &info);
void Cggbal(const char *job, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mplapackint &ilo, mplapackint &ihi, mpf_class *lscale, mpf_class *rscale, mpf_class *work, mplapackint &info);
void Cgges(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(mpc_class, mpc_class), mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mplapackint &sdim, mpc_class *alpha, mpc_class *beta, mpc_class *vsl, mplapackint const ldvsl, mpc_class *vsr, mplapackint const ldvsr, mpc_class *work, mplapackint const lwork, mpf_class *rwork, bool *bwork, mplapackint &info);
void Cgges3(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(mpc_class, mpc_class), mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mplapackint &sdim, mpc_class *alpha, mpc_class *beta, mpc_class *vsl, mplapackint const ldvsl, mpc_class *vsr, mplapackint const ldvsr, mpc_class *work, mplapackint const lwork, mpf_class *rwork, bool *bwork, mplapackint &info);
void Cggesx(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(mpc_class, mpc_class), const char *sense, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mplapackint &sdim, mpc_class *alpha, mpc_class *beta, mpc_class *vsl, mplapackint const ldvsl, mpc_class *vsr, mplapackint const ldvsr, mpf_class *rconde, mpf_class *rcondv, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cggev(const char *jobvl, const char *jobvr, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *alpha, mpc_class *beta, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Cggev3(const char *jobvl, const char *jobvr, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *alpha, mpc_class *beta, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Cggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *alpha, mpc_class *beta, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mplapackint &ilo, mplapackint &ihi, mpf_class *lscale, mpf_class *rscale, mpf_class &abnrm, mpf_class &bbnrm, mpf_class *rconde, mpf_class *rcondv, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cggglm(mplapackint const n, mplapackint const m, mplapackint const p, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *d, mpc_class *x, mpc_class *y, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgghd3(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *q, mplapackint const ldq, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgghrd(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *q, mplapackint const ldq, mpc_class *z, mplapackint const ldz, mplapackint &info);
void Cgglse(mplapackint const m, mplapackint const n, mplapackint const p, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *c, mpc_class *d, mpc_class *x, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cggqrf(mplapackint const n, mplapackint const m, mplapackint const p, mpc_class *a, mplapackint const lda, mpc_class *taua, mpc_class *b, mplapackint const ldb, mpc_class *taub, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cggrqf(mplapackint const m, mplapackint const p, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *taua, mpc_class *b, mplapackint const ldb, mpc_class *taub, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cggsvd3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const n, mplapackint const p, mplapackint &k, mplapackint &l, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpf_class *alpha, mpf_class *beta, mpc_class *u, mplapackint const ldu, mpc_class *v, mplapackint const ldv, mpc_class *q, mplapackint const ldq, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, mplapackint &info);
void Cggsvp3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpf_class const tola, mpf_class const tolb, mplapackint &k, mplapackint &l, mpc_class *u, mplapackint const ldu, mpc_class *v, mplapackint const ldv, mpc_class *q, mplapackint const ldq, mplapackint *iwork, mpf_class *rwork, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgsvj0(const char *jobv, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *d, mpf_class *sva, mplapackint const mv, mpc_class *v, mplapackint const ldv, mpf_class const eps, mpf_class const sfmin, mpf_class const tol, mplapackint const nsweep, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgsvj1(const char *jobv, mplapackint const m, mplapackint const n, mplapackint const n1, mpc_class *a, mplapackint const lda, mpc_class *d, mpf_class *sva, mplapackint const mv, mpc_class *v, mplapackint const ldv, mpf_class const eps, mpf_class const sfmin, mpf_class const tol, mplapackint const nsweep, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgtcon(const char *norm, mplapackint const n, mpc_class *dl, mpc_class *d, mpc_class *du, mpc_class *du2, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mplapackint &info);
void Cgtrfs(const char *trans, mplapackint const n, mplapackint const nrhs, mpc_class *dl, mpc_class *d, mpc_class *du, mpc_class *dlf, mpc_class *df, mpc_class *duf, mpc_class *du2, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cgtsv(mplapackint const n, mplapackint const nrhs, mpc_class *dl, mpc_class *d, mpc_class *du, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cgtsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, mpc_class *dl, mpc_class *d, mpc_class *du, mpc_class *dlf, mpc_class *df, mpc_class *duf, mpc_class *du2, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cgttrf(mplapackint const n, mpc_class *dl, mpc_class *d, mpc_class *du, mpc_class *du2, mplapackint *ipiv, mplapackint &info);
void Cgttrs(const char *trans, mplapackint const n, mplapackint const nrhs, mpc_class *dl, mpc_class *d, mpc_class *du, mpc_class *du2, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cgtts2(mplapackint const itrans, mplapackint const n, mplapackint const nrhs, mpc_class *dl, mpc_class *d, mpc_class *du, mpc_class *du2, mplapackint *ipiv, mpc_class *b, mplapackint const ldb);
void Chb2st_kernels(const char *uplo, bool const wantz, mplapackint const ttype, mplapackint const st, mplapackint const ed, mplapackint const sweep, mplapackint const n, mplapackint const nb, mplapackint const ib, mpc_class *a, mplapackint const lda, mpc_class *v, mpc_class *tau, mplapackint const ldvt, mpc_class *work);
void Chbev(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Chbev_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Chbevd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpc_class *q, mplapackint const ldq, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpc_class *q, mplapackint const ldq, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbgst(const char *vect, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpc_class *ab, mplapackint const ldab, mpc_class *bb, mplapackint const ldbb, mpc_class *x, mplapackint const ldx, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Chbgv(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpc_class *ab, mplapackint const ldab, mpc_class *bb, mplapackint const ldbb, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Chbgvd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpc_class *ab, mplapackint const ldab, mpc_class *bb, mplapackint const ldbb, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbgvx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpc_class *ab, mplapackint const ldab, mpc_class *bb, mplapackint const ldbb, mpc_class *q, mplapackint const ldq, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbtrd(const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpf_class *d, mpf_class *e, mpc_class *q, mplapackint const ldq, mpc_class *work, mplapackint &info);
void Checon(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mplapackint &info);
void Checon_3(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mplapackint &info);
void Checon_rook(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mplapackint &info);
void Cheequb(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *s, mpf_class &scond, mpf_class &amax, mpc_class *work, mplapackint &info);
void Cheev(const char *jobz, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *w, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Cheev_2stage(const char *jobz, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *w, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Cheevd(const char *jobz, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *w, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *w, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevr(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpc_class *z, mplapackint const ldz, mplapackint *isuppz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevr_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpc_class *z, mplapackint const ldz, mplapackint *isuppz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cheevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chegs2(mplapackint const itype, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Chegst(mplapackint const itype, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Chegv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpf_class *w, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Chegv_2stage(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpf_class *w, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Chegvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpf_class *w, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chegvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cherfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *af, mplapackint const ldaf, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Chesv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chesv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chesv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chesv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chesv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chesvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *af, mplapackint const ldaf, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Cheswapr(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Chetd2(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpc_class *tau, mplapackint &info);
void Chetf2(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Chetf2_rk(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mplapackint &info);
void Chetf2_rook(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Chetrd(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chetrd_2stage(const char *vect, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpc_class *tau, mpc_class *hous2, mplapackint const lhous2, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chetrd_hb2st(const char *stage1, const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpf_class *d, mpf_class *e, mpc_class *hous, mplapackint const lhous, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chetrd_he2hb(const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *a, mplapackint const lda, mpc_class *ab, mplapackint const ldab, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chetrf(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chetrf_aa(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chetrf_aa_2stage(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chetrf_rk(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chetrf_rook(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chetri(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint &info);
void Chetri2(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chetri2x(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint const nb, mplapackint &info);
void Chetri_3(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chetri_3x(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpc_class *work, mplapackint const nb, mplapackint &info);
void Chetri_rook(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint &info);
void Chetrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Chetrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint &info);
void Chetrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Chetrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Chetrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Chetrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Chfrk(const char *transr, const char *uplo, const char *trans, mplapackint const n, mplapackint const k, mpf_class const alpha, mpc_class *a, mplapackint const lda, mpf_class const beta, mpc_class *c);
void Chgeqz(const char *job, const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpc_class *h, mplapackint const ldh, mpc_class *t, mplapackint const ldt, mpc_class *alpha, mpc_class *beta, mpc_class *q, mplapackint const ldq, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Chpcon(const char *uplo, mplapackint const n, mpc_class *ap, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mplapackint &info);
void Chpev(const char *jobz, const char *uplo, mplapackint const n, mpc_class *ap, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Chpevd(const char *jobz, const char *uplo, mplapackint const n, mpc_class *ap, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chpevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpc_class *ap, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chpgst(mplapackint const itype, const char *uplo, mplapackint const n, mpc_class *ap, mpc_class *bp, mplapackint &info);
void Chpgv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpc_class *ap, mpc_class *bp, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Chpgvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpc_class *ap, mpc_class *bp, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chpgvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, mpc_class *ap, mpc_class *bp, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *afp, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Chpsv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Chpsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *afp, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Chptrd(const char *uplo, mplapackint const n, mpc_class *ap, mpf_class *d, mpf_class *e, mpc_class *tau, mplapackint &info);
void Chptrf(const char *uplo, mplapackint const n, mpc_class *ap, mplapackint *ipiv, mplapackint &info);
void Chptri(const char *uplo, mplapackint const n, mpc_class *ap, mplapackint *ipiv, mpc_class *work, mplapackint &info);
void Chptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Chsein(const char *side, const char *eigsrc, const char *initv, bool *select, mplapackint const n, mpc_class *h, mplapackint const ldh, mpc_class *w, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpc_class *work, mpf_class *rwork, mplapackint *ifaill, mplapackint *ifailr, mplapackint &info);
void Chseqr(const char *job, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpc_class *h, mplapackint const ldh, mpc_class *w, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Clabrd(mplapackint const m, mplapackint const n, mplapackint const nb, mpc_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpc_class *tauq, mpc_class *taup, mpc_class *x, mplapackint const ldx, mpc_class *y, mplapackint const ldy);
void Clacgv(mplapackint const n, mpc_class *x, mplapackint const incx);
void Clacn2(mplapackint const n, mpc_class *v, mpc_class *x, mpf_class &est, mplapackint &kase, mplapackint *isave);
void Clacon(mplapackint const n, mpc_class *v, mpc_class *x, mpf_class &est, mplapackint &kase);
void Clacp2(const char *uplo, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb);
void Clacpy(const char *uplo, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb);
void Clacrm(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpc_class *c, mplapackint const ldc, mpf_class *rwork);
void Clacrt(mplapackint const n, mpc_class *cx, mplapackint const incx, mpc_class *cy, mplapackint const incy, mpc_class const c, mpc_class const s);
void Claed0(mplapackint const qsiz, mplapackint const n, mpf_class *d, mpf_class *e, mpc_class *q, mplapackint const ldq, mpc_class *qstore, mplapackint const ldqs, mpf_class *rwork, mplapackint *iwork, mplapackint &info);
void Claed7(mplapackint const n, mplapackint const cutpnt, mplapackint const qsiz, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, mpf_class *d, mpc_class *q, mplapackint const ldq, mpf_class rho, mplapackint *indxq, mpf_class *qstore, mplapackint *qptr, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, mpf_class *givnum, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint &info);
void Claed8(mplapackint &k, mplapackint const n, mplapackint const qsiz, mpc_class *q, mplapackint const ldq, mpf_class *d, mpf_class &rho, mplapackint const cutpnt, mpf_class *z, mpf_class *dlamda, mpc_class *q2, mplapackint const ldq2, mpf_class *w, mplapackint *indxp, mplapackint *indx, mplapackint *indxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mpf_class *givnum, mplapackint &info);
void Claein(bool const rightv, bool const noinit, mplapackint const n, mpc_class *h, mplapackint const ldh, mpc_class const w, mpc_class *v, mpc_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class const eps3, mpf_class const smlnum, mplapackint &info);
void Claesy(mpc_class const a, mpc_class const b, mpc_class const c, mpc_class &rt1, mpc_class &rt2, mpc_class &evscal, mpc_class &cs1, mpc_class &sn1);
void Claev2(mpc_class const a, mpc_class const b, mpc_class const c, mpf_class &rt1, mpf_class &rt2, mpf_class &cs1, mpc_class &sn1);
void Clags2(bool const upper, mpf_class const a1, mpc_class const a2, mpf_class const a3, mpf_class const b1, mpc_class const b2, mpf_class const b3, mpf_class &csu, mpc_class &snu, mpf_class &csv, mpc_class &snv, mpf_class &csq, mpc_class &snq);
void Clagtm(const char *trans, mplapackint const n, mplapackint const nrhs, mpf_class const alpha, mpc_class *dl, mpc_class *d, mpc_class *du, mpc_class *x, mplapackint const ldx, mpf_class const beta, mpc_class *b, mplapackint const ldb);
void Clahef(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *w, mplapackint const ldw, mplapackint &info);
void Clahef_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *h, mplapackint const ldh, mpc_class *work);
void Clahef_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpc_class *w, mplapackint const ldw, mplapackint &info);
void Clahef_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *w, mplapackint const ldw, mplapackint &info);
void Clahqr(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpc_class *h, mplapackint const ldh, mpc_class *w, mplapackint const iloz, mplapackint const ihiz, mpc_class *z, mplapackint const ldz, mplapackint &info);
void Clahr2(mplapackint const n, mplapackint const k, mplapackint const nb, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *t, mplapackint const ldt, mpc_class *y, mplapackint const ldy);
void Claic1(mplapackint const job, mplapackint const j, mpc_class *x, mpf_class const sest, mpc_class *w, mpc_class const gamma, mpf_class &sestpr, mpc_class &s, mpc_class &c);
void Clals0(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const nrhs, mpc_class *b, mplapackint const ldb, mpc_class *bx, mplapackint const ldbx, mplapackint *perm, mplapackint const givptr, mplapackint *givcol, mplapackint const ldgcol, mpf_class *givnum, mplapackint const ldgnum, mpf_class *poles, mpf_class *difl, mpf_class *difr, mpf_class *z, mplapackint const k, mpf_class const c, mpf_class const s, mpf_class *rwork, mplapackint &info);
void Clalsa(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, mpc_class *b, mplapackint const ldb, mpc_class *bx, mplapackint const ldbx, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint *k, mpf_class *difl, mpf_class *difr, mpf_class *z, mpf_class *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, mpf_class *givnum, mpf_class *c, mpf_class *s, mpf_class *rwork, mplapackint *iwork, mplapackint &info);
void Clalsd(const char *uplo, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, mpf_class *d, mpf_class *e, mpc_class *b, mplapackint const ldb, mpf_class const rcond, mplapackint &rank, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint &info);
void Clamswlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Clamtsqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Clapll(mplapackint const n, mpc_class *x, mplapackint const incx, mpc_class *y, mplapackint const incy, mpf_class &ssmin);
void Clapmr(bool const forwrd, mplapackint const m, mplapackint const n, mpc_class *x, mplapackint const ldx, mplapackint *k);
void Clapmt(bool const forwrd, mplapackint const m, mplapackint const n, mpc_class *x, mplapackint const ldx, mplapackint *k);
void Claqgb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpc_class *ab, mplapackint const ldab, mpf_class *r, mpf_class *c, mpf_class const rowcnd, mpf_class const colcnd, mpf_class const amax, char *equed);
void Claqge(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *r, mpf_class *c, mpf_class const rowcnd, mpf_class const colcnd, mpf_class const amax, char *equed);
void Claqhb(const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpf_class *s, mpf_class const scond, mpf_class const amax, char *equed);
void Claqhe(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *s, mpf_class const scond, mpf_class const amax, char *equed);
void Claqhp(const char *uplo, mplapackint const n, mpc_class *ap, mpf_class *s, mpf_class const scond, mpf_class const amax, char *equed);
void Claqp2(mplapackint const m, mplapackint const n, mplapackint const offset, mpc_class *a, mplapackint const lda, mplapackint *jpvt, mpc_class *tau, mpf_class *vn1, mpf_class *vn2, mpc_class *work);
void Claqps(mplapackint const m, mplapackint const n, mplapackint const offset, mplapackint const nb, mplapackint &kb, mpc_class *a, mplapackint const lda, mplapackint *jpvt, mpc_class *tau, mpf_class *vn1, mpf_class *vn2, mpc_class *auxv, mpc_class *f, mplapackint const ldf);
void Claqr0(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpc_class *h, mplapackint const ldh, mpc_class *w, mplapackint const iloz, mplapackint const ihiz, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Claqr1(mplapackint const n, mpc_class *h, mplapackint const ldh, mpc_class const s1, mpc_class const s2, mpc_class *v);
void Claqr2(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, mpc_class *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, mpc_class *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, mpc_class *sh, mpc_class *v, mplapackint const ldv, mplapackint const nh, mpc_class *t, mplapackint const ldt, mplapackint const nv, mpc_class *wv, mplapackint const ldwv, mpc_class *work, mplapackint const lwork);
void Claqr3(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, mpc_class *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, mpc_class *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, mpc_class *sh, mpc_class *v, mplapackint const ldv, mplapackint const nh, mpc_class *t, mplapackint const ldt, mplapackint const nv, mpc_class *wv, mplapackint const ldwv, mpc_class *work, mplapackint const lwork);
void Claqr4(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpc_class *h, mplapackint const ldh, mpc_class *w, mplapackint const iloz, mplapackint const ihiz, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Claqr5(bool const wantt, bool const wantz, mplapackint const kacc22, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nshfts, mpc_class *s, mpc_class *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, mpc_class *z, mplapackint const ldz, mpc_class *v, mplapackint const ldv, mpc_class *u, mplapackint const ldu, mplapackint const nv, mpc_class *wv, mplapackint const ldwv, mplapackint const nh, mpc_class *wh, mplapackint const ldwh);
void Claqsb(const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpf_class *s, mpf_class const scond, mpf_class const amax, char *equed);
void Claqsp(const char *uplo, mplapackint const n, mpc_class *ap, mpf_class *s, mpf_class const scond, mpf_class const amax, char *equed);
void Claqsy(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *s, mpf_class const scond, mpf_class const amax, char *equed);
void Clar1v(mplapackint const n, mplapackint const b1, mplapackint const bn, mpf_class const lambda, mpf_class *d, mpf_class *l, mpf_class *ld, mpf_class *lld, mpf_class const pivmin, mpf_class const gaptol, mpc_class *z, bool const wantnc, mplapackint &negcnt, mpf_class &ztz, mpf_class &mingma, mplapackint &r, mplapackint *isuppz, mpf_class &nrminv, mpf_class &resid, mpf_class &rqcorr, mpf_class *work);
void Clar2v(mplapackint const n, mpc_class *x, mpc_class *y, mpc_class *z, mplapackint const incx, mpf_class *c, mpc_class *s, mplapackint const incc);
void Clarcm(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *c, mplapackint const ldc, mpf_class *rwork);
void Clarf(const char *side, mplapackint const m, mplapackint const n, mpc_class *v, mplapackint const incv, mpc_class const tau, mpc_class *c, mplapackint const ldc, mpc_class *work);
void Clarfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *v, mplapackint const ldv, mpc_class *t, mplapackint const ldt, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const ldwork);
void Clarfb_gett(const char *ident, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *t, mplapackint const ldt, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const ldwork);
void Clarfg(mplapackint const n, mpc_class &alpha, mpc_class *x, mplapackint const incx, mpc_class &tau);
void Clarfgp(mplapackint const n, mpc_class &alpha, mpc_class *x, mplapackint const incx, mpc_class &tau);
void Clarft(const char *direct, const char *storev, mplapackint const n, mplapackint const k, mpc_class *v, mplapackint const ldv, mpc_class *tau, mpc_class *t, mplapackint const ldt);
void Clarfx(const char *side, mplapackint const m, mplapackint const n, mpc_class *v, mpc_class const tau, mpc_class *c, mplapackint const ldc, mpc_class *work);
void Clarfy(const char *uplo, mplapackint const n, mpc_class *v, mplapackint const incv, mpc_class const tau, mpc_class *c, mplapackint const ldc, mpc_class *work);
void Clargv(mplapackint const n, mpc_class *x, mplapackint const incx, mpc_class *y, mplapackint const incy, mpf_class *c, mplapackint const incc);
void Clarnv(mplapackint const idist, mplapackint *iseed, mplapackint const n, mpc_class *x);
void Clarrv(mplapackint const n, mpf_class const vl, mpf_class const, mpf_class *d, mpf_class *l, mpf_class const pivmin, mplapackint *isplit, mplapackint const m, mplapackint const dol, mplapackint const dou, mpf_class const minrgp, mpf_class &rtol1, mpf_class &rtol2, mpf_class *w, mpf_class *werr, mpf_class *wgap, mplapackint *iblock, mplapackint *indexw, mpf_class *gers, mpc_class *z, mplapackint const ldz, mplapackint *isuppz, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Clarscl2(mplapackint const m, mplapackint const n, mpf_class *d, mpc_class *x, mplapackint const ldx);
void Clartg(mpc_class const f, mpc_class const g, mpf_class &cs, mpc_class &sn, mpc_class &r);
void Clartv(mplapackint const n, mpc_class *x, mplapackint const incx, mpc_class *y, mplapackint const incy, mpf_class *c, mpc_class *s, mplapackint const incc);
void Clarz(const char *side, mplapackint const m, mplapackint const n, mplapackint const l, mpc_class *v, mplapackint const incv, mpc_class const tau, mpc_class *c, mplapackint const ldc, mpc_class *work);
void Clarzb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpc_class *v, mplapackint const ldv, mpc_class *t, mplapackint const ldt, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const ldwork);
void Clarzt(const char *direct, const char *storev, mplapackint const n, mplapackint const k, mpc_class *v, mplapackint const ldv, mpc_class *tau, mpc_class *t, mplapackint const ldt);
void Clascl(const char *type, mplapackint const kl, mplapackint const ku, mpf_class const cfrom, mpf_class const cto, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint &info);
void Clascl2(mplapackint const m, mplapackint const n, mpf_class *d, mpc_class *x, mplapackint const ldx);
void Claset(const char *uplo, mplapackint const m, mplapackint const n, mpc_class const alpha, mpc_class const beta, mpc_class *a, mplapackint const lda);
void Clasr(const char *side, const char *pivot, const char *direct, mplapackint const m, mplapackint const n, mpf_class *c, mpf_class *s, mpc_class *a, mplapackint const lda);
void Classq(mplapackint const n, mpc_class *x, mplapackint const incx, mpf_class &scale, mpf_class &sumsq);
void Claswlq(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Claswp(mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint const k1, mplapackint const k2, mplapackint *ipiv, mplapackint const incx);
void Clasyf(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *w, mplapackint const ldw, mplapackint &info);
void Clasyf_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *h, mplapackint const ldh, mpc_class *work);
void Clasyf_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpc_class *w, mplapackint const ldw, mplapackint &info);
void Clasyf_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *w, mplapackint const ldw, mplapackint &info);
void Clatbs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpc_class *x, mpf_class &scale, mpf_class *cnorm, mplapackint &info);
void Clatdf(mplapackint const ijob, mplapackint const n, mpc_class *z, mplapackint const ldz, mpc_class *rhs, mpf_class &rdsum, mpf_class &rdscal, mplapackint *ipiv, mplapackint *jpiv);
void Clatps(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mpc_class *ap, mpc_class *x, mpf_class &scale, mpf_class *cnorm, mplapackint &info);
void Clatrd(const char *uplo, mplapackint const n, mplapackint const nb, mpc_class *a, mplapackint const lda, mpf_class *e, mpc_class *tau, mpc_class *w, mplapackint const ldw);
void Clatrs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *x, mpf_class &scale, mpf_class *cnorm, mplapackint &info);
void Clatrz(mplapackint const m, mplapackint const n, mplapackint const l, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work);
void Clatsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Claunhr_col_getrfnp(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *d, mplapackint &info);
void Claunhr_col_getrfnp2(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *d, mplapackint &info);
void Clauu2(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint &info);
void Clauum(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint &info);
void Cpbcon(const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cpbequ(const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpf_class *s, mpf_class &scond, mpf_class &amax, mplapackint &info);
void Cpbrfs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpc_class *afb, mplapackint const ldafb, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cpbstf(const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mplapackint &info);
void Cpbsv(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cpbsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpc_class *afb, mplapackint const ldafb, char *equed, mpf_class *s, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cpbtf2(const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mplapackint &info);
void Cpbtrf(const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mplapackint &info);
void Cpbtrs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cpftrf(const char *transr, const char *uplo, mplapackint const n, mpc_class *a, mplapackint &info);
void Cpftri(const char *transr, const char *uplo, mplapackint const n, mpc_class *a, mplapackint &info);
void Cpftrs(const char *transr, const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cpocon(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cpoequ(mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *s, mpf_class &scond, mpf_class &amax, mplapackint &info);
void Cpoequb(mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *s, mpf_class &scond, mpf_class &amax, mplapackint &info);
void Cporfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *af, mplapackint const ldaf, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cposv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cposvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *af, mplapackint const ldaf, char *equed, mpf_class *s, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cpotf2(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint &info);
void Cpotrf(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint &info);
void Cpotrf2(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint &info);
void Cpotri(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint &info);
void Cpotrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cppcon(const char *uplo, mplapackint const n, mpc_class *ap, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cppequ(const char *uplo, mplapackint const n, mpc_class *ap, mpf_class *s, mpf_class &scond, mpf_class &amax, mplapackint &info);
void Cpprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *afp, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cppsv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cppsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *afp, char *equed, mpf_class *s, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cpptrf(const char *uplo, mplapackint const n, mpc_class *ap, mplapackint &info);
void Cpptri(const char *uplo, mplapackint const n, mpc_class *ap, mplapackint &info);
void Cpptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cpstf2(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, mpf_class const tol, mpf_class *work, mplapackint &info);
void Cpstrf(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, mpf_class const tol, mpf_class *work, mplapackint &info);
void Cptcon(mplapackint const n, mpf_class *d, mpc_class *e, mpf_class const anorm, mpf_class &rcond, mpf_class *rwork, mplapackint &info);
void Cpteqr(const char *compz, mplapackint const n, mpf_class *d, mpf_class *e, mpc_class *z, mplapackint const ldz, mpf_class *work, mplapackint &info);
void Cptrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *d, mpc_class *e, mpf_class *df, mpc_class *ef, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cptsv(mplapackint const n, mplapackint const nrhs, mpf_class *d, mpc_class *e, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cptsvx(const char *fact, mplapackint const n, mplapackint const nrhs, mpf_class *d, mpc_class *e, mpf_class *df, mpc_class *ef, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cpttrf(mplapackint const n, mpf_class *d, mpc_class *e, mplapackint &info);
void Cpttrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *d, mpc_class *e, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cptts2(mplapackint const iuplo, mplapackint const n, mplapackint const nrhs, mpf_class *d, mpc_class *e, mpc_class *b, mplapackint const ldb);
void Crot(mplapackint const n, mpc_class *cx, mplapackint const incx, mpc_class *cy, mplapackint const incy, mpf_class const c, mpc_class const s);
void Cspcon(const char *uplo, mplapackint const n, mpc_class *ap, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mplapackint &info);
void Cspmv(const char *uplo, mplapackint const n, mpc_class const alpha, mpc_class *ap, mpc_class *x, mplapackint const incx, mpc_class const beta, mpc_class *y, mplapackint const incy);
void Cspr(const char *uplo, mplapackint const n, mpc_class const alpha, mpc_class *x, mplapackint const incx, mpc_class *ap);
void Csprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *afp, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Cspsv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cspsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *afp, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Csptrf(const char *uplo, mplapackint const n, mpc_class *ap, mplapackint *ipiv, mplapackint &info);
void Csptri(const char *uplo, mplapackint const n, mpc_class *ap, mplapackint *ipiv, mpc_class *work, mplapackint &info);
void Csptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Cstedc(const char *compz, mplapackint const n, mpf_class *d, mpf_class *e, mpc_class *z, mplapackint const ldz, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cstein(mplapackint const n, mpf_class *d, mpf_class *e, mplapackint const m, mpf_class *w, mplapackint *iblock, mplapackint *isplit, mpc_class *z, mplapackint const ldz, mpf_class *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cstemr(const char *jobz, const char *range, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mplapackint &m, mpf_class *w, mpc_class *z, mplapackint const ldz, mplapackint const nzc, mplapackint *isuppz, bool &tryrac, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Csteqr(const char *compz, mplapackint const n, mpf_class *d, mpf_class *e, mpc_class *z, mplapackint const ldz, mpf_class *work, mplapackint &info);
void Csycon(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mplapackint &info);
void Csycon_3(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mplapackint &info);
void Csycon_rook(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpc_class *work, mplapackint &info);
void Csyconv(const char *uplo, const char *way, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *e, mplapackint &info);
void Csyconvf(const char *uplo, const char *way, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mplapackint &info);
void Csyconvf_rook(const char *uplo, const char *way, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mplapackint &info);
void Csyequb(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *s, mpf_class &scond, mpf_class &amax, mpc_class *work, mplapackint &info);
void Csymv(const char *uplo, mplapackint const n, mpc_class const alpha, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const incx, mpc_class const beta, mpc_class *y, mplapackint const incy);
void Csyr(const char *uplo, mplapackint const n, mpc_class const alpha, mpc_class *x, mplapackint const incx, mpc_class *a, mplapackint const lda);
void Csyrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *af, mplapackint const ldaf, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Csysv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csysv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csysv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csysv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csysv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csysvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *af, mplapackint const ldaf, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Csyswapr(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Csytf2(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Csytf2_rk(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mplapackint &info);
void Csytf2_rook(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Csytrf(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csytrf_aa(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csytrf_aa_2stage(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csytrf_rk(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csytrf_rook(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csytri(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint &info);
void Csytri2(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csytri2x(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint const nb, mplapackint &info);
void Csytri_3(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csytri_3x(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpc_class *work, mplapackint const nb, mplapackint &info);
void Csytri_rook(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *work, mplapackint &info);
void Csytrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Csytrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint &info);
void Csytrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Csytrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Csytrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Csytrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Ctbcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpf_class &rcond, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Ctbrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Ctbtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Ctfsm(const char *transr, const char *side, const char *uplo, const char *trans, const char *diag, mplapackint const m, mplapackint const n, mpc_class const alpha, mpc_class *a, mpc_class *b, mplapackint const ldb);
void Ctftri(const char *transr, const char *uplo, const char *diag, mplapackint const n, mpc_class *a, mplapackint &info);
void Ctfttp(const char *transr, const char *uplo, mplapackint const n, mpc_class *arf, mpc_class *ap, mplapackint &info);
void Ctfttr(const char *transr, const char *uplo, mplapackint const n, mpc_class *arf, mpc_class *a, mplapackint const lda, mplapackint &info);
void Ctgevc(const char *side, const char *howmny, bool *select, mplapackint const n, mpc_class *s, mplapackint const lds, mpc_class *p, mplapackint const ldp, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Ctgex2(bool const wantq, bool const wantz, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *q, mplapackint const ldq, mpc_class *z, mplapackint const ldz, mplapackint const j1, mplapackint &info);
void Ctgexc(bool const wantq, bool const wantz, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *q, mplapackint const ldq, mpc_class *z, mplapackint const ldz, mplapackint const ifst, mplapackint &ilst, mplapackint &info);
void Ctgsen(mplapackint const ijob, bool const wantq, bool const wantz, bool *select, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *alpha, mpc_class *beta, mpc_class *q, mplapackint const ldq, mpc_class *z, mplapackint const ldz, mplapackint &m, mpf_class &pl, mpf_class &pr, mpf_class *dif, mpc_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Ctgsja(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mplapackint const k, mplapackint const l, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpf_class const tola, mpf_class const tolb, mpf_class *alpha, mpf_class *beta, mpc_class *u, mplapackint const ldu, mpc_class *v, mplapackint const ldv, mpc_class *q, mplapackint const ldq, mpc_class *work, mplapackint &ncycle, mplapackint &info);
void Ctgsna(const char *job, const char *howmny, bool *select, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mpf_class *s, mpf_class *dif, mplapackint const mm, mplapackint &m, mpc_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Ctgsy2(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *c, mplapackint const ldc, mpc_class *d, mplapackint const ldd, mpc_class *e, mplapackint const lde, mpc_class *f, mplapackint const ldf, mpf_class &scale, mpf_class &rdsum, mpf_class &rdscal, mplapackint &info);
void Ctgsyl(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *c, mplapackint const ldc, mpc_class *d, mplapackint const ldd, mpc_class *e, mplapackint const lde, mpc_class *f, mplapackint const ldf, mpf_class &scale, mpf_class &dif, mpc_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Ctpcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mpc_class *ap, mpf_class &rcond, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Ctplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *t, mplapackint const ldt, mpc_class *work, mplapackint &info);
void Ctplqt2(mplapackint const m, mplapackint const n, mplapackint const l, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *t, mplapackint const ldt, mplapackint &info);
void Ctpmlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const mb, mpc_class *v, mplapackint const ldv, mpc_class *t, mplapackint const ldt, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint &info);
void Ctpmqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const nb, mpc_class *v, mplapackint const ldv, mpc_class *t, mplapackint const ldt, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint &info);
void Ctpqrt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *t, mplapackint const ldt, mpc_class *work, mplapackint &info);
void Ctpqrt2(mplapackint const m, mplapackint const n, mplapackint const l, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *t, mplapackint const ldt, mplapackint &info);
void Ctprfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpc_class *v, mplapackint const ldv, mpc_class *t, mplapackint const ldt, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const ldwork);
void Ctprfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Ctptri(const char *uplo, const char *diag, mplapackint const n, mpc_class *ap, mplapackint &info);
void Ctptrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Ctpttf(const char *transr, const char *uplo, mplapackint const n, mpc_class *ap, mpc_class *arf, mplapackint &info);
void Ctpttr(const char *uplo, mplapackint const n, mpc_class *ap, mpc_class *a, mplapackint const lda, mplapackint &info);
void Ctrcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class &rcond, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Ctrevc(const char *side, const char *howmny, bool *select, mplapackint const n, mpc_class *t, mplapackint const ldt, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Ctrevc3(const char *side, const char *howmny, bool *select, mplapackint const n, mpc_class *t, mplapackint const ldt, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint &info);
void Ctrexc(const char *compq, mplapackint const n, mpc_class *t, mplapackint const ldt, mpc_class *q, mplapackint const ldq, mplapackint const ifst, mplapackint const ilst, mplapackint &info);
void Ctrrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Ctrsen(const char *job, const char *compq, bool *select, mplapackint const n, mpc_class *t, mplapackint const ldt, mpc_class *q, mplapackint const ldq, mpc_class *w, mplapackint &m, mpf_class &s, mpf_class &sep, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Ctrsna(const char *job, const char *howmny, bool *select, mplapackint const n, mpc_class *t, mplapackint const ldt, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mpf_class *s, mpf_class *sep, mplapackint const mm, mplapackint &m, mpc_class *work, mplapackint const ldwork, mpf_class *rwork, mplapackint &info);
void Ctrsyl(const char *trana, const char *tranb, mplapackint const isgn, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *c, mplapackint const ldc, mpf_class &scale, mplapackint &info);
void Ctrti2(const char *uplo, const char *diag, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint &info);
void Ctrtri(const char *uplo, const char *diag, mplapackint const n, mpc_class *a, mplapackint const lda, mplapackint &info);
void Ctrtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Ctrttf(const char *transr, const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *arf, mplapackint &info);
void Ctrttp(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *ap, mplapackint &info);
void Ctzrzf(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunbdb(const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, mpc_class *x11, mplapackint const ldx11, mpc_class *x12, mplapackint const ldx12, mpc_class *x21, mplapackint const ldx21, mpc_class *x22, mplapackint const ldx22, mpf_class *theta, mpf_class *phi, mpc_class *taup1, mpc_class *taup2, mpc_class *tauq1, mpc_class *tauq2, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunbdb1(mplapackint const m, mplapackint const p, mplapackint const q, mpc_class *x11, mplapackint const ldx11, mpc_class *x21, mplapackint const ldx21, mpf_class *theta, mpf_class *phi, mpc_class *taup1, mpc_class *taup2, mpc_class *tauq1, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunbdb2(mplapackint const m, mplapackint const p, mplapackint const q, mpc_class *x11, mplapackint const ldx11, mpc_class *x21, mplapackint const ldx21, mpf_class *theta, mpf_class *phi, mpc_class *taup1, mpc_class *taup2, mpc_class *tauq1, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunbdb3(mplapackint const m, mplapackint const p, mplapackint const q, mpc_class *x11, mplapackint const ldx11, mpc_class *x21, mplapackint const ldx21, mpf_class *theta, mpf_class *phi, mpc_class *taup1, mpc_class *taup2, mpc_class *tauq1, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunbdb4(mplapackint const m, mplapackint const p, mplapackint const q, mpc_class *x11, mplapackint const ldx11, mpc_class *x21, mplapackint const ldx21, mpf_class *theta, mpf_class *phi, mpc_class *taup1, mpc_class *taup2, mpc_class *tauq1, mpc_class *phantom, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunbdb5(mplapackint const m1, mplapackint const m2, mplapackint const n, mpc_class *x1, mplapackint const incx1, mpc_class *x2, mplapackint const incx2, mpc_class *q1, mplapackint const ldq1, mpc_class *q2, mplapackint const ldq2, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunbdb6(mplapackint const m1, mplapackint const m2, mplapackint const n, mpc_class *x1, mplapackint const incx1, mpc_class *x2, mplapackint const incx2, mpc_class *q1, mplapackint const ldq1, mpc_class *q2, mplapackint const ldq2, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cuncsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, mpc_class *x11, mplapackint const ldx11, mpc_class *x12, mplapackint const ldx12, mpc_class *x21, mplapackint const ldx21, mpc_class *x22, mplapackint const ldx22, mpf_class *theta, mpc_class *u1, mplapackint const ldu1, mpc_class *u2, mplapackint const ldu2, mpc_class *v1t, mplapackint const ldv1t, mpc_class *v2t, mplapackint const ldv2t, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cuncsd2by1(const char *jobu1, const char *jobu2, const char *jobv1t, mplapackint const m, mplapackint const p, mplapackint const q, mpc_class *x11, mplapackint const ldx11, mpc_class *x21, mplapackint const ldx21, mpf_class *theta, mpc_class *u1, mplapackint const ldu1, mpc_class *u2, mplapackint const ldu2, mpc_class *v1t, mplapackint const ldv1t, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cung2l(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint &info);
void Cung2r(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint &info);
void Cungbr(const char *vect, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunghr(mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cungl2(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint &info);
void Cunglq(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cungql(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cungqr(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cungr2(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint &info);
void Cungrq(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cungtr(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cungtsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cungtsqr_row(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunhr_col(mplapackint const m, mplapackint const n, mplapackint const nb, mpc_class *a, mplapackint const lda, mpc_class *t, mplapackint const ldt, mpc_class *d, mplapackint &info);
void Cunm22(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const n1, mplapackint const n2, mpc_class *q, mplapackint const ldq, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunm2l(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint &info);
void Cunm2r(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint &info);
void Cunmbr(const char *vect, const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunmhr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunml2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint &info);
void Cunmlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunmql(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunmqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunmr2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint &info);
void Cunmr3(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint &info);
void Cunmrq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunmrz(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cunmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cupgtr(const char *uplo, mplapackint const n, mpc_class *ap, mpc_class *tau, mpc_class *q, mplapackint const ldq, mpc_class *work, mplapackint &info);
void Cupmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mpc_class *ap, mpc_class *tau, mpc_class *c, mplapackint const ldc, mpc_class *work, mplapackint &info);
void Rbbcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, mplapackint const m, mplapackint const p, mplapackint const q, mpf_class *theta, mpf_class *phi, mpf_class *u1, mplapackint const ldu1, mpf_class *u2, mplapackint const ldu2, mpf_class *v1t, mplapackint const ldv1t, mpf_class *v2t, mplapackint const ldv2t, mpf_class *b11d, mpf_class *b11e, mpf_class *b12d, mpf_class *b12e, mpf_class *b21d, mpf_class *b21e, mpf_class *b22d, mpf_class *b22e, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rbdsdc(const char *uplo, const char *compq, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint const ldvt, mpf_class *q, mplapackint *iq, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rbdsqr(const char *uplo, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, mpf_class *d, mpf_class *e, mpf_class *vt, mplapackint const ldvt, mpf_class *u, mplapackint const ldu, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint &info);
void Rbdsvdx(const char *uplo, const char *jobz, const char *range, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, mpf_class *s, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rcombssq(mpf_class *v1, mpf_class *v2);
void Rdisna(const char *job, mplapackint const m, mplapackint const n, mpf_class *d, mpf_class *sep, mplapackint &info);
void Rgbbrd(const char *vect, mplapackint const m, mplapackint const n, mplapackint const ncc, mplapackint const kl, mplapackint const ku, mpf_class *ab, mplapackint const ldab, mpf_class *d, mpf_class *e, mpf_class *q, mplapackint const ldq, mpf_class *pt, mplapackint const ldpt, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint &info);
void Rgbcon(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, mpf_class *ab, mplapackint const ldab, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rgbequ(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpf_class *ab, mplapackint const ldab, mpf_class *r, mpf_class *c, mpf_class &rowcnd, mpf_class &colcnd, mpf_class &amax, mplapackint &info);
void Rgbequb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpf_class *ab, mplapackint const ldab, mpf_class *r, mpf_class *c, mpf_class &rowcnd, mpf_class &colcnd, mpf_class &amax, mplapackint &info);
void Rgbrfs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class *afb, mplapackint const ldafb, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rgbsv(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rgbsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class *afb, mplapackint const ldafb, mplapackint *ipiv, char *equed, mpf_class *r, mpf_class *c, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rgbtf2(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpf_class *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Rgbtrf(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpf_class *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Rgbtrs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rgebak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *scale, mplapackint const m, mpf_class *v, mplapackint const ldv, mplapackint &info);
void Rgebal(const char *job, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint &ilo, mplapackint &ihi, mpf_class *scale, mplapackint &info);
void Rgebd2(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpf_class *tauq, mpf_class *taup, mpf_class *work, mplapackint &info);
void Rgebrd(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpf_class *tauq, mpf_class *taup, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgecon(const char *norm, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class const anorm, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rgeequ(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *r, mpf_class *c, mpf_class &rowcnd, mpf_class &colcnd, mpf_class &amax, mplapackint &info);
void Rgeequb(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *r, mpf_class *c, mpf_class &rowcnd, mpf_class &colcnd, mpf_class &amax, mplapackint &info);
void Rgees(const char *jobvs, const char *sort, bool (*select)(mpf_class, mpf_class), mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint &sdim, mpf_class *wr, mpf_class *wi, mpf_class *vs, mplapackint const ldvs, mpf_class *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rgeesx(const char *jobvs, const char *sort, bool (*select)(mpf_class, mpf_class), const char *sense, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint &sdim, mpf_class *wr, mpf_class *wi, mpf_class *vs, mplapackint const ldvs, mpf_class &rconde, mpf_class &rcondv, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rgeev(const char *jobvl, const char *jobvr, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *wr, mpf_class *wi, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *wr, mpf_class *wi, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, mpf_class *scale, mpf_class &abnrm, mpf_class *rconde, mpf_class *rcondv, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgehd2(mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint &info);
void Rgehrd(mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgejsv(const char *joba, const char *jobu, const char *jobv, const char *jobr, const char *jobt, const char *jobp, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *sva, mpf_class *u, mplapackint const ldu, mpf_class *v, mplapackint const ldv, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgelq(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const tsize, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgelq2(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint &info);
void Rgelqf(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgelqt(mplapackint const m, mplapackint const n, mplapackint const mb, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const ldt, mpf_class *work, mplapackint &info);
void Rgelqt3(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const ldt, mplapackint &info);
void Rgels(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgelsd(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *s, mpf_class const rcond, mplapackint &rank, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgelss(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *s, mpf_class const rcond, mplapackint &rank, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgelsy(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mplapackint *jpvt, mpf_class const rcond, mplapackint &rank, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgemlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const tsize, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgemlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mpf_class *v, mplapackint const ldv, mpf_class *t, mplapackint const ldt, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint &info);
void Rgemqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const tsize, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgemqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const nb, mpf_class *v, mplapackint const ldv, mpf_class *t, mplapackint const ldt, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint &info);
void Rgeql2(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint &info);
void Rgeqlf(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgeqp3(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *jpvt, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgeqr(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const tsize, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgeqr2(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint &info);
void Rgeqr2p(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint &info);
void Rgeqrf(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgeqrfp(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgeqrt(mplapackint const m, mplapackint const n, mplapackint const nb, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const ldt, mpf_class *work, mplapackint &info);
void Rgeqrt2(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const ldt, mplapackint &info);
void Rgeqrt3(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const ldt, mplapackint &info);
void Rgerfs(const char *trans, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *af, mplapackint const ldaf, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rgerq2(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint &info);
void Rgerqf(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgesc2(mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *rhs, mplapackint *ipiv, mplapackint *jpiv, mpf_class &scale);
void Rgesdd(const char *jobz, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *s, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint const ldvt, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgesv(mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rgesvd(const char *jobu, const char *jobvt, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *s, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint const ldvt, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgesvdq(const char *joba, const char *jobp, const char *jobr, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *s, mpf_class *u, mplapackint const ldu, mpf_class *v, mplapackint const ldv, mplapackint &numrank, mplapackint *iwork, mplapackint const liwork, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint &info);
void Rgesvdx(const char *jobu, const char *jobvt, const char *range, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, mpf_class *s, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint const ldvt, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgesvj(const char *joba, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *sva, mplapackint const mv, mpf_class *v, mplapackint const ldv, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgesvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *af, mplapackint const ldaf, mplapackint *ipiv, char *equed, mpf_class *r, mpf_class *c, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rgetc2(mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint *jpiv, mplapackint &info);
void Rgetf2(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetrf(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetrf2(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetri(mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgetrs(const char *trans, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rgetsls(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgetsqrhrt(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const ldt, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rggbak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *lscale, mpf_class *rscale, mplapackint const m, mpf_class *v, mplapackint const ldv, mplapackint &info);
void Rggbal(const char *job, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mplapackint &ilo, mplapackint &ihi, mpf_class *lscale, mpf_class *rscale, mpf_class *work, mplapackint &info);
void Rgges(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(mpf_class, mpf_class, mpf_class), mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mplapackint &sdim, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *vsl, mplapackint const ldvsl, mpf_class *vsr, mplapackint const ldvsr, mpf_class *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rgges3(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(mpf_class, mpf_class, mpf_class), mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mplapackint &sdim, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *vsl, mplapackint const ldvsl, mpf_class *vsr, mplapackint const ldvsr, mpf_class *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rggesx(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(mpf_class, mpf_class, mpf_class), const char *sense, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mplapackint &sdim, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *vsl, mplapackint const ldvsl, mpf_class *vsr, mplapackint const ldvsr, mpf_class *rconde, mpf_class *rcondv, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rggev(const char *jobvl, const char *jobvr, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rggev3(const char *jobvl, const char *jobvr, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, mpf_class *lscale, mpf_class *rscale, mpf_class &abnrm, mpf_class &bbnrm, mpf_class *rconde, mpf_class *rcondv, mpf_class *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rggglm(mplapackint const n, mplapackint const m, mplapackint const p, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *d, mpf_class *x, mpf_class *y, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgghd3(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *q, mplapackint const ldq, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgghrd(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *q, mplapackint const ldq, mpf_class *z, mplapackint const ldz, mplapackint &info);
void Rgglse(mplapackint const m, mplapackint const n, mplapackint const p, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *c, mpf_class *d, mpf_class *x, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rggqrf(mplapackint const n, mplapackint const m, mplapackint const p, mpf_class *a, mplapackint const lda, mpf_class *taua, mpf_class *b, mplapackint const ldb, mpf_class *taub, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rggrqf(mplapackint const m, mplapackint const p, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *taua, mpf_class *b, mplapackint const ldb, mpf_class *taub, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rggsvd3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const n, mplapackint const p, mplapackint &k, mplapackint &l, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *alpha, mpf_class *beta, mpf_class *u, mplapackint const ldu, mpf_class *v, mplapackint const ldv, mpf_class *q, mplapackint const ldq, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rggsvp3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class const tola, mpf_class const tolb, mplapackint &k, mplapackint &l, mpf_class *u, mplapackint const ldu, mpf_class *v, mplapackint const ldv, mpf_class *q, mplapackint const ldq, mplapackint *iwork, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgsvj0(const char *jobv, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *d, mpf_class *sva, mplapackint const mv, mpf_class *v, mplapackint const ldv, mpf_class const eps, mpf_class const sfmin, mpf_class const tol, mplapackint const nsweep, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgsvj1(const char *jobv, mplapackint const m, mplapackint const n, mplapackint const n1, mpf_class *a, mplapackint const lda, mpf_class *d, mpf_class *sva, mplapackint const mv, mpf_class *v, mplapackint const ldv, mpf_class const eps, mpf_class const sfmin, mpf_class const tol, mplapackint const nsweep, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgtcon(const char *norm, mplapackint const n, mpf_class *dl, mpf_class *d, mpf_class *du, mpf_class *du2, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rgtrfs(const char *trans, mplapackint const n, mplapackint const nrhs, mpf_class *dl, mpf_class *d, mpf_class *du, mpf_class *dlf, mpf_class *df, mpf_class *duf, mpf_class *du2, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rgtsv(mplapackint const n, mplapackint const nrhs, mpf_class *dl, mpf_class *d, mpf_class *du, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rgtsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, mpf_class *dl, mpf_class *d, mpf_class *du, mpf_class *dlf, mpf_class *df, mpf_class *duf, mpf_class *du2, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rgttrf(mplapackint const n, mpf_class *dl, mpf_class *d, mpf_class *du, mpf_class *du2, mplapackint *ipiv, mplapackint &info);
void Rgttrs(const char *trans, mplapackint const n, mplapackint const nrhs, mpf_class *dl, mpf_class *d, mpf_class *du, mpf_class *du2, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rgtts2(mplapackint const itrans, mplapackint const n, mplapackint const nrhs, mpf_class *dl, mpf_class *d, mpf_class *du, mpf_class *du2, mplapackint *ipiv, mpf_class *b, mplapackint const ldb);
void Rhgeqz(const char *job, const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *h, mplapackint const ldh, mpf_class *t, mplapackint const ldt, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *q, mplapackint const ldq, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rhsein(const char *side, const char *eigsrc, const char *initv, bool *select, mplapackint const n, mpf_class *h, mplapackint const ldh, mpf_class *wr, mpf_class *wi, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpf_class *work, mplapackint *ifaill, mplapackint *ifailr, mplapackint &info);
void Rhseqr(const char *job, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *h, mplapackint const ldh, mpf_class *wr, mpf_class *wi, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rla_gbamv(mplapackint const trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpf_class const alpha, mpf_class *ab, mplapackint const ldab, mpf_class *x, mplapackint const incx, mpf_class const beta, mpf_class *y, mplapackint const incy);
void Rla_geamv(mplapackint const trans, mplapackint const m, mplapackint const n, mpf_class const alpha, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const incx, mpf_class const beta, mpf_class *y, mplapackint const incy);
void Rla_syamv(mplapackint const uplo, mplapackint const n, mpf_class const alpha, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const incx, mpf_class const beta, mpf_class *y, mplapackint const incy);
void Rla_wwaddw(mplapackint const n, mpf_class *x, mpf_class *y, mpf_class *w);
void Rlabad(mpf_class &small, mpf_class &large);
void Rlabrd(mplapackint const m, mplapackint const n, mplapackint const nb, mpf_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpf_class *tauq, mpf_class *taup, mpf_class *x, mplapackint const ldx, mpf_class *y, mplapackint const ldy);
void Rlacn2(mplapackint const n, mpf_class *v, mpf_class *x, mplapackint *isgn, mpf_class &est, mplapackint &kase, mplapackint *isave);
void Rlacon(mplapackint const n, mpf_class *v, mpf_class *x, mplapackint *isgn, mpf_class &est, mplapackint &kase);
void Rlacpy(const char *uplo, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb);
void Rladiv(mpf_class const &a, mpf_class const &b, mpf_class const &c, mpf_class const &d, mpf_class &p, mpf_class &q);
void Rladiv1(mpf_class &a, mpf_class const &b, mpf_class const &c, mpf_class const &d, mpf_class &p, mpf_class &q);
void Rlae2(mpf_class const a, mpf_class const b, mpf_class const c, mpf_class &rt1, mpf_class &rt2);
void Rlaebz(mplapackint const ijob, mplapackint const nitmax, mplapackint const n, mplapackint const mmax, mplapackint const minp, mplapackint const nbmin, mpf_class const abstol, mpf_class const reltol, mpf_class const pivmin, mpf_class *d, mpf_class *e, mpf_class *e2, mplapackint *nval, mpf_class *ab, mpf_class *c, mplapackint &mout, mplapackint *nab, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rlaed0(mplapackint const icompq, mplapackint const qsiz, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class *q, mplapackint const ldq, mpf_class *qstore, mplapackint const ldqs, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rlaed1(mplapackint const n, mpf_class *d, mpf_class *q, mplapackint const ldq, mplapackint *indxq, mpf_class rho, mplapackint const cutpnt, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rlaed2(mplapackint &k, mplapackint const n, mplapackint const n1, mpf_class *d, mpf_class *q, mplapackint const ldq, mplapackint *indxq, mpf_class &rho, mpf_class *z, mpf_class *dlamda, mpf_class *w, mpf_class *q2, mplapackint *indx, mplapackint *indxc, mplapackint *indxp, mplapackint *coltyp, mplapackint &info);
void Rlaed3(mplapackint const k, mplapackint const n, mplapackint const n1, mpf_class *d, mpf_class *q, mplapackint const ldq, mpf_class const rho, mpf_class *dlamda, mpf_class *q2, mplapackint *indx, mplapackint *ctot, mpf_class *w, mpf_class *s, mplapackint &info);
void Rlaed4(mplapackint const n, mplapackint const i, mpf_class *d, mpf_class *z, mpf_class *delta, mpf_class const rho, mpf_class &dlam, mplapackint &info);
void Rlaed5(mplapackint const i, mpf_class *d, mpf_class *z, mpf_class *delta, mpf_class const rho, mpf_class &dlam);
void Rlaed6(mplapackint const kniter, bool const orgati, mpf_class const rho, mpf_class *d, mpf_class *z, mpf_class const finit, mpf_class &tau, mplapackint &info);
void Rlaed7(mplapackint const icompq, mplapackint const n, mplapackint const qsiz, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, mpf_class *d, mpf_class *q, mplapackint const ldq, mplapackint *indxq, mpf_class rho, mplapackint const cutpnt, mpf_class *qstore, mplapackint *qptr, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, mpf_class *givnum, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rlaed8(mplapackint const icompq, mplapackint &k, mplapackint const n, mplapackint const qsiz, mpf_class *d, mpf_class *q, mplapackint const ldq, mplapackint *indxq, mpf_class &rho, mplapackint const cutpnt, mpf_class *z, mpf_class *dlamda, mpf_class *q2, mplapackint const ldq2, mpf_class *w, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mpf_class *givnum, mplapackint *indxp, mplapackint *indx, mplapackint &info);
void Rlaed9(mplapackint const k, mplapackint const kstart, mplapackint const kstop, mplapackint const n, mpf_class *d, mpf_class *q, mplapackint const ldq, mpf_class const rho, mpf_class *dlamda, mpf_class *w, mpf_class *s, mplapackint const lds, mplapackint &info);
void Rlaeda(mplapackint const n, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, mpf_class *givnum, mpf_class *q, mplapackint *qptr, mpf_class *z, mpf_class *ztemp, mplapackint &info);
void Rlaein(bool const rightv, bool const noinit, mplapackint const n, mpf_class *h, mplapackint const ldh, mpf_class const wr, mpf_class const wi, mpf_class *vr, mpf_class *vi, mpf_class *b, mplapackint const ldb, mpf_class *work, mpf_class const eps3, mpf_class const smlnum, mpf_class const bignum, mplapackint &info);
void Rlaev2(mpf_class const a, mpf_class const b, mpf_class const c, mpf_class &rt1, mpf_class &rt2, mpf_class &cs1, mpf_class &sn1);
void Rlaexc(bool const wantq, mplapackint const n, mpf_class *t, mplapackint const ldt, mpf_class *q, mplapackint const ldq, mplapackint const j1, mplapackint const n1, mplapackint const n2, mpf_class *work, mplapackint &info);
void Rlag2(mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class const safmin, mpf_class &scale1, mpf_class &scale2, mpf_class &wr1, mpf_class &wr2, mpf_class &wi);
void Rlags2(bool const upper, mpf_class const a1, mpf_class const a2, mpf_class const a3, mpf_class const b1, mpf_class const b2, mpf_class const b3, mpf_class &csu, mpf_class &snu, mpf_class &csv, mpf_class &snv, mpf_class &csq, mpf_class &snq);
void Rlagtf(mplapackint const n, mpf_class *a, mpf_class const lambda, mpf_class *b, mpf_class *c, mpf_class const tol, mpf_class *d, mplapackint *in, mplapackint &info);
void Rlagtm(const char *trans, mplapackint const n, mplapackint const nrhs, mpf_class const alpha, mpf_class *dl, mpf_class *d, mpf_class *du, mpf_class *x, mplapackint const ldx, mpf_class const beta, mpf_class *b, mplapackint const ldb);
void Rlagts(mplapackint const job, mplapackint const n, mpf_class *a, mpf_class *b, mpf_class *c, mpf_class *d, mplapackint *in, mpf_class *y, mpf_class &tol, mplapackint &info);
void Rlagv2(mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class &csl, mpf_class &snl, mpf_class &csr, mpf_class &snr);
void Rlahqr(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *h, mplapackint const ldh, mpf_class *wr, mpf_class *wi, mplapackint const iloz, mplapackint const ihiz, mpf_class *z, mplapackint const ldz, mplapackint &info);
void Rlahr2(mplapackint const n, mplapackint const k, mplapackint const nb, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *t, mplapackint const ldt, mpf_class *y, mplapackint const ldy);
void Rlaic1(mplapackint const job, mplapackint const j, mpf_class *x, mpf_class const sest, mpf_class *w, mpf_class const gamma, mpf_class &sestpr, mpf_class &s, mpf_class &c);
void Rlaln2(bool const ltrans, mplapackint const na, mplapackint const nw, mpf_class const smin, mpf_class const ca, mpf_class *a, mplapackint const lda, mpf_class const d1, mpf_class const d2, mpf_class *b, mplapackint const ldb, mpf_class const wr, mpf_class const wi, mpf_class *x, mplapackint const ldx, mpf_class &scale, mpf_class &xnorm, mplapackint &info);
void Rlals0(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const nrhs, mpf_class *b, mplapackint const ldb, mpf_class *bx, mplapackint const ldbx, mplapackint *perm, mplapackint const givptr, mplapackint *givcol, mplapackint const ldgcol, mpf_class *givnum, mplapackint const ldgnum, mpf_class *poles, mpf_class *difl, mpf_class *difr, mpf_class *z, mplapackint const k, mpf_class const c, mpf_class const s, mpf_class *work, mplapackint &info);
void Rlalsa(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, mpf_class *b, mplapackint const ldb, mpf_class *bx, mplapackint const ldbx, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint *k, mpf_class *difl, mpf_class *difr, mpf_class *z, mpf_class *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, mpf_class *givnum, mpf_class *c, mpf_class *s, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rlalsd(const char *uplo, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, mpf_class *d, mpf_class *e, mpf_class *b, mplapackint const ldb, mpf_class const rcond, mplapackint &rank, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rlamrg(mplapackint const n1, mplapackint const n2, mpf_class *a, mplapackint const dtrd1, mplapackint const dtrd2, mplapackint *index);
void Rlamswlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const ldt, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rlamtsqr(const char *side, const char *trans, mplapackint const &m, mplapackint const &n, mplapackint const &k, mplapackint const &mb, mplapackint const &nb, mpf_class *a, mplapackint const &lda, mpf_class *t, mplapackint const &ldt, mpf_class *c, mplapackint const &ldc, mpf_class *work, mplapackint const &lwork, mplapackint &info);
void Rlanv2(mpf_class &a, mpf_class &b, mpf_class &c, mpf_class &d, mpf_class &rt1r, mpf_class &rt1i, mpf_class &rt2r, mpf_class &rt2i, mpf_class &cs, mpf_class &sn);
void Rlaorhr_col_getrfnp(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *d, mplapackint &info);
void Rlaorhr_col_getrfnp2(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *d, mplapackint &info);
void Rlapll(mplapackint const n, mpf_class *x, mplapackint const incx, mpf_class *y, mplapackint const incy, mpf_class &ssmin);
void Rlapmr(bool const forwrd, mplapackint const m, mplapackint const n, mpf_class *x, mplapackint const ldx, mplapackint *k);
void Rlapmt(bool const forwrd, mplapackint const m, mplapackint const n, mpf_class *x, mplapackint const ldx, mplapackint *k);
void Rlaqgb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpf_class *ab, mplapackint const ldab, mpf_class *r, mpf_class *c, mpf_class const rowcnd, mpf_class const colcnd, mpf_class const amax, char *equed);
void Rlaqge(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *r, mpf_class *c, mpf_class const rowcnd, mpf_class const colcnd, mpf_class const amax, char *equed);
void Rlaqp2(mplapackint const m, mplapackint const n, mplapackint const offset, mpf_class *a, mplapackint const lda, mplapackint *jpvt, mpf_class *tau, mpf_class *vn1, mpf_class *vn2, mpf_class *work);
void Rlaqps(mplapackint const m, mplapackint const n, mplapackint const offset, mplapackint const nb, mplapackint &kb, mpf_class *a, mplapackint const lda, mplapackint *jpvt, mpf_class *tau, mpf_class *vn1, mpf_class *vn2, mpf_class *auxv, mpf_class *f, mplapackint const ldf);
void Rlaqr0(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *h, mplapackint const ldh, mpf_class *wr, mpf_class *wi, mplapackint const iloz, mplapackint const ihiz, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rlaqr1(mplapackint const n, mpf_class *h, mplapackint const ldh, mpf_class const sr1, mpf_class const si1, mpf_class const sr2, mpf_class const si2, mpf_class *v);
void Rlaqr2(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, mpf_class *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, mpf_class *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, mpf_class *sr, mpf_class *si, mpf_class *v, mplapackint const ldv, mplapackint const nh, mpf_class *t, mplapackint const ldt, mplapackint const nv, mpf_class *wv, mplapackint const ldwv, mpf_class *work, mplapackint const lwork);
void Rlaqr3(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, mpf_class *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, mpf_class *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, mpf_class *sr, mpf_class *si, mpf_class *v, mplapackint const ldv, mplapackint const nh, mpf_class *t, mplapackint const ldt, mplapackint const nv, mpf_class *wv, mplapackint const ldwv, mpf_class *work, mplapackint const lwork);
void Rlaqr4(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *h, mplapackint const ldh, mpf_class *wr, mpf_class *wi, mplapackint const iloz, mplapackint const ihiz, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rlaqr5(bool const wantt, bool const wantz, mplapackint const kacc22, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nshfts, mpf_class *sr, mpf_class *si, mpf_class *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, mpf_class *z, mplapackint const ldz, mpf_class *v, mplapackint const ldv, mpf_class *u, mplapackint const ldu, mplapackint const nv, mpf_class *wv, mplapackint const ldwv, mplapackint const nh, mpf_class *wh, mplapackint const ldwh);
void Rlaqsb(const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *s, mpf_class const scond, mpf_class const amax, char *equed);
void Rlaqsp(const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *s, mpf_class const scond, mpf_class const amax, char *equed);
void Rlaqsy(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *s, mpf_class const scond, mpf_class const amax, char *equed);
void Rlaqtr(bool const ltran, bool const lreal, mplapackint const n, mpf_class *t, mplapackint const ldt, mpf_class *b, mpf_class const w, mpf_class &scale, mpf_class *x, mpf_class *work, mplapackint &info);
void Rlar1v(mplapackint const n, mplapackint const b1, mplapackint const bn, mpf_class const lambda, mpf_class *d, mpf_class *l, mpf_class *ld, mpf_class *lld, mpf_class const pivmin, mpf_class const gaptol, mpf_class *z, bool const wantnc, mplapackint &negcnt, mpf_class &ztz, mpf_class &mingma, mplapackint &r, mplapackint *isuppz, mpf_class &nrminv, mpf_class &resid, mpf_class &rqcorr, mpf_class *work);
void Rlar2v(mplapackint const n, mpf_class *x, mpf_class *y, mpf_class *z, mplapackint const incx, mpf_class *c, mpf_class *s, mplapackint const incc);
void Rlarf(const char *side, mplapackint const m, mplapackint const n, mpf_class *v, mplapackint const incv, mpf_class const tau, mpf_class *c, mplapackint const ldc, mpf_class *work);
void Rlarfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *v, mplapackint const ldv, mpf_class *t, mplapackint const ldt, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const ldwork);
void Rlarfb_gett(const char *ident, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *t, mplapackint const ldt, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const ldwork);
void Rlarfg(mplapackint const n, mpf_class &alpha, mpf_class *x, mplapackint const incx, mpf_class &tau);
void Rlarfgp(mplapackint const n, mpf_class &alpha, mpf_class *x, mplapackint const incx, mpf_class &tau);
void Rlarft(const char *direct, const char *storev, mplapackint const n, mplapackint const k, mpf_class *v, mplapackint const ldv, mpf_class *tau, mpf_class *t, mplapackint const ldt);
void Rlarfx(const char *side, mplapackint const m, mplapackint const n, mpf_class *v, mpf_class const tau, mpf_class *c, mplapackint const ldc, mpf_class *work);
void Rlarfy(const char *uplo, mplapackint const n, mpf_class *v, mplapackint const incv, mpf_class const tau, mpf_class *c, mplapackint const ldc, mpf_class *work);
void Rlargv(mplapackint const n, mpf_class *x, mplapackint const incx, mpf_class *y, mplapackint const incy, mpf_class *c, mplapackint const incc);
void Rlarnv(mplapackint const idist, mplapackint *iseed, mplapackint const n, mpf_class *x);
void Rlarra(mplapackint const n, mpf_class *d, mpf_class *e, mpf_class *e2, mpf_class const spltol, mpf_class const tnrm, mplapackint &nsplit, mplapackint *isplit, mplapackint &info);
void Rlarrb(mplapackint const n, mpf_class *d, mpf_class *lld, mplapackint const ifirst, mplapackint const ilast, mpf_class const rtol1, mpf_class const rtol2, mplapackint const offset, mpf_class *w, mpf_class *wgap, mpf_class *werr, mpf_class *work, mplapackint *iwork, mpf_class const pivmin, mpf_class const spdiam, mplapackint const twist, mplapackint &info);
void Rlarrc(const char *jobt, mplapackint const n, mpf_class const vl, mpf_class const vu, mpf_class *d, mpf_class *e, mpf_class const, mplapackint &eigcnt, mplapackint &lcnt, mplapackint &rcnt, mplapackint &info);
void Rlarrd(const char *range, const char *order, mplapackint const n, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class *gers, mpf_class const reltol, mpf_class *d, mpf_class *e, mpf_class *e2, mpf_class const pivmin, mplapackint const nsplit, mplapackint *isplit, mplapackint &m, mpf_class *w, mpf_class *werr, mpf_class &wl, mpf_class &wu, mplapackint *iblock, mplapackint *indexw, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rlarre(const char *range, mplapackint const n, mpf_class &vl, mpf_class &vu, mplapackint const il, mplapackint const iu, mpf_class *d, mpf_class *e, mpf_class *e2, mpf_class const rtol1, mpf_class const rtol2, mpf_class const spltol, mplapackint nsplit, mplapackint *isplit, mplapackint &m, mpf_class *w, mpf_class *werr, mpf_class *wgap, mplapackint *iblock, mplapackint *indexw, mpf_class *gers, mpf_class &pivmin, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rlarrf(mplapackint const n, mpf_class *d, mpf_class *l, mpf_class *ld, mplapackint const clstrt, mplapackint const clend, mpf_class *w, mpf_class *wgap, mpf_class *werr, mpf_class const spdiam, mpf_class const clgapl, mpf_class const clgapr, mpf_class const pivmin, mpf_class &sigma, mpf_class *dplus, mpf_class *lplus, mpf_class *work, mplapackint &info);
void Rlarrj(mplapackint const n, mpf_class *d, mpf_class *e2, mplapackint const ifirst, mplapackint const ilast, mpf_class const rtol, mplapackint const offset, mpf_class *w, mpf_class *werr, mpf_class *work, mplapackint *iwork, mpf_class const pivmin, mpf_class const spdiam, mplapackint &info);
void Rlarrk(mplapackint const n, mplapackint const iw, mpf_class const gl, mpf_class const gu, mpf_class *d, mpf_class *e2, mpf_class const pivmin, mpf_class const reltol, mpf_class &w, mpf_class &werr, mplapackint &info);
void Rlarrr(mplapackint const n, mpf_class *d, mpf_class *e, mplapackint &info);
void Rlarrv(mplapackint const n, mpf_class const vl, mpf_class const, mpf_class *d, mpf_class *l, mpf_class const pivmin, mplapackint *isplit, mplapackint const m, mplapackint const dol, mplapackint const dou, mpf_class const minrgp, mpf_class &rtol1, mpf_class &rtol2, mpf_class *w, mpf_class *werr, mpf_class *wgap, mplapackint *iblock, mplapackint *indexw, mpf_class *gers, mpf_class *z, mplapackint const ldz, mplapackint *isuppz, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rlarscl2(mplapackint const m, mplapackint const n, mpf_class *d, mpf_class *x, mplapackint const ldx);
void Rlartg(mpf_class const f, mpf_class const g, mpf_class &cs, mpf_class &sn, mpf_class &r);
void Rlartgp(mpf_class const f, mpf_class const g, mpf_class &cs, mpf_class &sn, mpf_class &r);
void Rlartgs(mpf_class const x, mpf_class const y, mpf_class const sigma, mpf_class &cs, mpf_class &sn);
void Rlartv(mplapackint const n, mpf_class *x, mplapackint const incx, mpf_class *y, mplapackint const incy, mpf_class *c, mpf_class *s, mplapackint const incc);
void Rlaruv(mplapackint *iseed, mplapackint const n, mpf_class *x);
void Rlarz(const char *side, mplapackint const m, mplapackint const n, mplapackint const l, mpf_class *v, mplapackint const incv, mpf_class const tau, mpf_class *c, mplapackint const ldc, mpf_class *work);
void Rlarzb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpf_class *v, mplapackint const ldv, mpf_class *t, mplapackint const ldt, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const ldwork);
void Rlarzt(const char *direct, const char *storev, mplapackint const n, mplapackint const k, mpf_class *v, mplapackint const ldv, mpf_class *tau, mpf_class *t, mplapackint const ldt);
void Rlas2(mpf_class const f, mpf_class const g, mpf_class const h, mpf_class &ssmin, mpf_class &ssmax);
void Rlascl(const char *type, mplapackint const kl, mplapackint const ku, mpf_class const cfrom, mpf_class const cto, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint &info);
void Rlascl2(mplapackint const m, mplapackint const n, mpf_class *d, mpf_class *x, mplapackint const ldx);
void Rlasd0(mplapackint const n, mplapackint const sqre, mpf_class *d, mpf_class *e, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint const ldvt, mplapackint const smlsiz, mplapackint *iwork, mpf_class *work, mplapackint &info);
void Rlasd1(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mpf_class *d, mpf_class &alpha, mpf_class &beta, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint const ldvt, mplapackint *idxq, mplapackint *iwork, mpf_class *work, mplapackint &info);
void Rlasd2(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint &k, mpf_class *d, mpf_class *z, mpf_class const alpha, mpf_class const beta, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint const ldvt, mpf_class *dsigma, mpf_class *u2, mplapackint const ldu2, mpf_class *vt2, mplapackint const ldvt2, mplapackint *idxp, mplapackint *idx, mplapackint *idxc, mplapackint *idxq, mplapackint *coltyp, mplapackint &info);
void Rlasd3(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const k, mpf_class *d, mpf_class *q, mplapackint const ldq, mpf_class *dsigma, mpf_class *u, mplapackint const ldu, mpf_class *u2, mplapackint const ldu2, mpf_class *vt, mplapackint const ldvt, mpf_class *vt2, mplapackint const ldvt2, mplapackint *idxc, mplapackint *ctot, mpf_class *z, mplapackint &info);
void Rlasd4(mplapackint const n, mplapackint const i, mpf_class *d, mpf_class *z, mpf_class *delta, mpf_class const rho, mpf_class &sigma, mpf_class *work, mplapackint &info);
void Rlasd5(mplapackint const i, mpf_class *d, mpf_class *z, mpf_class *delta, mpf_class const rho, mpf_class &dsigma, mpf_class *work);
void Rlasd6(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mpf_class *d, mpf_class *vf, mpf_class *vl, mpf_class &alpha, mpf_class &beta, mplapackint *idxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mplapackint const ldgcol, mpf_class *givnum, mplapackint const ldgnum, mpf_class *poles, mpf_class *difl, mpf_class *difr, mpf_class *z, mplapackint &k, mpf_class &c, mpf_class &s, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rlasd7(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint &k, mpf_class *d, mpf_class *z, mpf_class *zw, mpf_class *vf, mpf_class *vfw, mpf_class *vl, mpf_class *vlw, mpf_class const alpha, mpf_class const beta, mpf_class *dsigma, mplapackint *idx, mplapackint *idxp, mplapackint *idxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mplapackint const ldgcol, mpf_class *givnum, mplapackint const ldgnum, mpf_class &c, mpf_class &s, mplapackint &info);
void Rlasd8(mplapackint const icompq, mplapackint const k, mpf_class *d, mpf_class *z, mpf_class *vf, mpf_class *vl, mpf_class *difl, mpf_class *difr, mplapackint const lddifr, mpf_class *dsigma, mpf_class *work, mplapackint &info);
void Rlasda(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const sqre, mpf_class *d, mpf_class *e, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint *k, mpf_class *difl, mpf_class *difr, mpf_class *z, mpf_class *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, mpf_class *givnum, mpf_class *c, mpf_class *s, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rlasdq(const char *uplo, mplapackint const sqre, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, mpf_class *d, mpf_class *e, mpf_class *vt, mplapackint const ldvt, mpf_class *u, mplapackint const ldu, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint &info);
void Rlasdt(mplapackint const n, mplapackint &lvl, mplapackint &nd, mplapackint *inode, mplapackint *ndiml, mplapackint *ndimr, mplapackint const msub);
void Rlaset(const char *uplo, mplapackint const m, mplapackint const n, mpf_class const alpha, mpf_class const beta, mpf_class *a, mplapackint const lda);
void Rlasq1(mplapackint const n, mpf_class *d, mpf_class *e, mpf_class *work, mplapackint &info);
void Rlasq2(mplapackint const n, mpf_class *z, mplapackint &info);
void Rlasq3(mplapackint const i0, mplapackint &n0, mpf_class *z, mplapackint &pp, mpf_class &dmin, mpf_class &sigma, mpf_class &desig, mpf_class &qmax, mplapackint &nfail, mplapackint &iter, mplapackint &ndiv, bool const ieee, mplapackint &ttype, mpf_class dmin1, mpf_class &dmin2, mpf_class dn, mpf_class dn1, mpf_class dn2, mpf_class g, mpf_class &tau);
void Rlasq4(mplapackint const i0, mplapackint const n0, mpf_class *z, mplapackint const pp, mplapackint const n0in, mpf_class const dmin, mpf_class const dmin1, mpf_class const dmin2, mpf_class const dn, mpf_class const dn1, mpf_class const dn2, mpf_class &tau, mplapackint &ttype, mpf_class &g);
void Rlasq5(mplapackint const i0, mplapackint const n0, mpf_class *z, mplapackint const pp, mpf_class &tau, mpf_class const sigma, mpf_class &dmin, mpf_class &dmin1, mpf_class &dmin2, mpf_class &dn, mpf_class &dnm1, mpf_class &dnm2, bool const ieee, mpf_class const eps);
void Rlasq6(mplapackint const i0, mplapackint const n0, mpf_class *z, mplapackint const pp, mpf_class &dmin, mpf_class &dmin1, mpf_class &dmin2, mpf_class &dn, mpf_class &dnm1, mpf_class &dnm2);
void Rlasr(const char *side, const char *pivot, const char *direct, mplapackint const m, mplapackint const n, mpf_class *c, mpf_class *s, mpf_class *a, mplapackint const lda);
void Rlasrt(const char *id, mplapackint const n, mpf_class *d, mplapackint &info);
void Rlassq(mplapackint const n, mpf_class *x, mplapackint const incx, mpf_class &scale, mpf_class &sumsq);
void Rlasv2(mpf_class const f, mpf_class const g, mpf_class const h, mpf_class &ssmin, mpf_class &ssmax, mpf_class &snr, mpf_class &csr, mpf_class &snl, mpf_class &csl);
void Rlaswlq(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const ldt, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rlaswp(mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint const k1, mplapackint const k2, mplapackint *ipiv, mplapackint const incx);
void Rlasy2(bool const ltranl, bool const ltranr, mplapackint const isgn, mplapackint const n1, mplapackint const n2, mpf_class *tl, mplapackint const ldtl, mpf_class *tr, mplapackint const ldtr, mpf_class *b, mplapackint const ldb, mpf_class &scale, mpf_class *x, mplapackint const ldx, mpf_class &xnorm, mplapackint &info);
void Rlasyf(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *w, mplapackint const ldw, mplapackint &info);
void Rlasyf_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *h, mplapackint const ldh, mpf_class *work);
void Rlasyf_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpf_class *a, mplapackint const lda, mpf_class *e, mplapackint *ipiv, mpf_class *w, mplapackint const ldw, mplapackint &info);
void Rlasyf_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *w, mplapackint const ldw, mplapackint &info);
void Rlatbs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *x, mpf_class &scale, mpf_class *cnorm, mplapackint &info);
void Rlatdf(mplapackint const ijob, mplapackint const n, mpf_class *z, mplapackint const ldz, mpf_class *rhs, mpf_class &rdsum, mpf_class &rdscal, mplapackint *ipiv, mplapackint *jpiv);
void Rlatps(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mpf_class *ap, mpf_class *x, mpf_class &scale, mpf_class *cnorm, mplapackint &info);
void Rlatrd(const char *uplo, mplapackint const n, mplapackint const nb, mpf_class *a, mplapackint const lda, mpf_class *e, mpf_class *tau, mpf_class *w, mplapackint const ldw);
void Rlatrs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *x, mpf_class &scale, mpf_class *cnorm, mplapackint &info);
void Rlatrz(mplapackint const m, mplapackint const n, mplapackint const l, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work);
void Rlatsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const ldt, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rlauu2(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint &info);
void Rlauum(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint &info);
void Ropgtr(const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *tau, mpf_class *q, mplapackint const ldq, mpf_class *work, mplapackint &info);
void Ropmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mpf_class *ap, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint &info);
void Rorbdb(const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, mpf_class *x11, mplapackint const ldx11, mpf_class *x12, mplapackint const ldx12, mpf_class *x21, mplapackint const ldx21, mpf_class *x22, mplapackint const ldx22, mpf_class *theta, mpf_class *phi, mpf_class *taup1, mpf_class *taup2, mpf_class *tauq1, mpf_class *tauq2, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorbdb1(mplapackint const m, mplapackint const p, mplapackint const q, mpf_class *x11, mplapackint const ldx11, mpf_class *x21, mplapackint const ldx21, mpf_class *theta, mpf_class *phi, mpf_class *taup1, mpf_class *taup2, mpf_class *tauq1, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorbdb2(mplapackint const m, mplapackint const p, mplapackint const q, mpf_class *x11, mplapackint const ldx11, mpf_class *x21, mplapackint const ldx21, mpf_class *theta, mpf_class *phi, mpf_class *taup1, mpf_class *taup2, mpf_class *tauq1, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorbdb3(mplapackint const m, mplapackint const p, mplapackint const q, mpf_class *x11, mplapackint const ldx11, mpf_class *x21, mplapackint const ldx21, mpf_class *theta, mpf_class *phi, mpf_class *taup1, mpf_class *taup2, mpf_class *tauq1, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorbdb4(mplapackint const m, mplapackint const p, mplapackint const q, mpf_class *x11, mplapackint const ldx11, mpf_class *x21, mplapackint const ldx21, mpf_class *theta, mpf_class *phi, mpf_class *taup1, mpf_class *taup2, mpf_class *tauq1, mpf_class *phantom, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorbdb5(mplapackint const m1, mplapackint const m2, mplapackint const n, mpf_class *x1, mplapackint const incx1, mpf_class *x2, mplapackint const incx2, mpf_class *q1, mplapackint const ldq1, mpf_class *q2, mplapackint const ldq2, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorbdb6(mplapackint const m1, mplapackint const m2, mplapackint const n, mpf_class *x1, mplapackint const incx1, mpf_class *x2, mplapackint const incx2, mpf_class *q1, mplapackint const ldq1, mpf_class *q2, mplapackint const ldq2, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, mpf_class *x11, mplapackint const ldx11, mpf_class *x12, mplapackint const ldx12, mpf_class *x21, mplapackint const ldx21, mpf_class *x22, mplapackint const ldx22, mpf_class *theta, mpf_class *u1, mplapackint const ldu1, mpf_class *u2, mplapackint const ldu2, mpf_class *v1t, mplapackint const ldv1t, mpf_class *v2t, mplapackint const ldv2t, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rorcsd2by1(const char *jobu1, const char *jobu2, const char *jobv1t, mplapackint const m, mplapackint const p, mplapackint const q, mpf_class *x11, mplapackint const ldx11, mpf_class *x21, mplapackint const ldx21, mpf_class *theta, mpf_class *u1, mplapackint const ldu1, mpf_class *u2, mplapackint const ldu2, mpf_class *v1t, mplapackint const ldv1t, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rorg2l(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint &info);
void Rorg2r(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint &info);
void Rorgbr(const char *vect, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorghr(mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorgl2(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint &info);
void Rorglq(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorgql(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorgqr(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorgr2(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint &info);
void Rorgrq(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorgtr(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorgtsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const ldt, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorgtsqr_row(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const ldt, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorhr_col(mplapackint const m, mplapackint const n, mplapackint const nb, mpf_class *a, mplapackint const lda, mpf_class *t, mplapackint const ldt, mpf_class *d, mplapackint &info);
void Rorm22(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const n1, mplapackint const n2, mpf_class *q, mplapackint const ldq, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorm2l(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint &info);
void Rorm2r(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint &info);
void Rormbr(const char *vect, const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rormhr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rorml2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint &info);
void Rormlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rormql(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rormqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rormr2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint &info);
void Rormr3(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint &info);
void Rormrq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rormrz(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rormtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *c, mplapackint const ldc, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rpbcon(const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class const anorm, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rpbequ(const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *s, mpf_class &scond, mpf_class &amax, mplapackint &info);
void Rpbrfs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class *afb, mplapackint const ldafb, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rpbstf(const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mplapackint &info);
void Rpbsv(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rpbsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class *afb, mplapackint const ldafb, char *equed, mpf_class *s, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rpbtf2(const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mplapackint &info);
void Rpbtrf(const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mplapackint &info);
void Rpbtrs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rpftrf(const char *transr, const char *uplo, mplapackint const n, mpf_class *a, mplapackint &info);
void Rpftri(const char *transr, const char *uplo, mplapackint const n, mpf_class *a, mplapackint &info);
void Rpftrs(const char *transr, const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rpocon(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class const anorm, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rpoequ(mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *s, mpf_class &scond, mpf_class &amax, mplapackint &info);
void Rpoequb(mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *s, mpf_class &scond, mpf_class &amax, mplapackint &info);
void Rporfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *af, mplapackint const ldaf, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rposv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rposvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *af, mplapackint const ldaf, char *equed, mpf_class *s, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rpotf2(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint &info);
void Rpotrf(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint &info);
void Rpotrf2(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint &info);
void Rpotri(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint &info);
void Rpotrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rppcon(const char *uplo, mplapackint const n, mpf_class *ap, mpf_class const anorm, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rppequ(const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *s, mpf_class &scond, mpf_class &amax, mplapackint &info);
void Rpprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mpf_class *afp, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rppsv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rppsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mpf_class *afp, char *equed, mpf_class *s, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rpptrf(const char *uplo, mplapackint const n, mpf_class *ap, mplapackint &info);
void Rpptri(const char *uplo, mplapackint const n, mpf_class *ap, mplapackint &info);
void Rpptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rpstf2(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, mpf_class const tol, mpf_class *work, mplapackint &info);
void Rpstrf(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, mpf_class const tol, mpf_class *work, mplapackint &info);
void Rptcon(mplapackint const n, mpf_class *d, mpf_class *e, mpf_class const anorm, mpf_class &rcond, mpf_class *work, mplapackint &info);
void Rpteqr(const char *compz, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint &info);
void Rptrfs(mplapackint const n, mplapackint const nrhs, mpf_class *d, mpf_class *e, mpf_class *df, mpf_class *ef, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint &info);
void Rptsv(mplapackint const n, mplapackint const nrhs, mpf_class *d, mpf_class *e, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rptsvx(const char *fact, mplapackint const n, mplapackint const nrhs, mpf_class *d, mpf_class *e, mpf_class *df, mpf_class *ef, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint &info);
void Rpttrf(mplapackint const n, mpf_class *d, mpf_class *e, mplapackint &info);
void Rpttrs(mplapackint const n, mplapackint const nrhs, mpf_class *d, mpf_class *e, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rptts2(mplapackint const n, mplapackint const nrhs, mpf_class *d, mpf_class *e, mpf_class *b, mplapackint const ldb);
void Rrscl(mplapackint const n, mpf_class const sa, mpf_class *sx, mplapackint const incx);
void Rsb2st_kernels(const char *uplo, bool const wantz, mplapackint const ttype, mplapackint const st, mplapackint const ed, mplapackint const sweep, mplapackint const n, mplapackint const nb, mplapackint const ib, mpf_class *a, mplapackint const lda, mpf_class *v, mpf_class *tau, mplapackint const ldvt, mpf_class *work);
void Rsbev(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint &info);
void Rsbev_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsbevd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *q, mplapackint const ldq, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *q, mplapackint const ldq, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbgst(const char *vect, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpf_class *ab, mplapackint const ldab, mpf_class *bb, mplapackint const ldbb, mpf_class *x, mplapackint const ldx, mpf_class *work, mplapackint &info);
void Rsbgv(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpf_class *ab, mplapackint const ldab, mpf_class *bb, mplapackint const ldbb, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint &info);
void Rsbgvd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpf_class *ab, mplapackint const ldab, mpf_class *bb, mplapackint const ldbb, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbgvx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, mpf_class *ab, mplapackint const ldab, mpf_class *bb, mplapackint const ldbb, mpf_class *q, mplapackint const ldq, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbtrd(const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *d, mpf_class *e, mpf_class *q, mplapackint const ldq, mpf_class *work, mplapackint &info);
void Rsfrk(const char *transr, const char *uplo, const char *trans, mplapackint const n, mplapackint const k, mpf_class const alpha, mpf_class *a, mplapackint const lda, mpf_class const beta, mpf_class *c);
void Rspcon(const char *uplo, mplapackint const n, mpf_class *ap, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rspev(const char *jobz, const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint &info);
void Rspevd(const char *jobz, const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rspevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpf_class *ap, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rspgst(mplapackint const itype, const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *bp, mplapackint &info);
void Rspgv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *bp, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint &info);
void Rspgvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *bp, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rspgvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *bp, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mpf_class *afp, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rspsv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rspsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mpf_class *afp, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rsptrd(const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *d, mpf_class *e, mpf_class *tau, mplapackint &info);
void Rsptrf(const char *uplo, mplapackint const n, mpf_class *ap, mplapackint *ipiv, mplapackint &info);
void Rsptri(const char *uplo, mplapackint const n, mpf_class *ap, mplapackint *ipiv, mpf_class *work, mplapackint &info);
void Rsptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rstebz(const char *range, const char *order, mplapackint const n, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mpf_class *d, mpf_class *e, mplapackint &m, mplapackint &nsplit, mpf_class *w, mplapackint *iblock, mplapackint *isplit, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rstedc(const char *compz, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstein(mplapackint const n, mpf_class *d, mpf_class *e, mplapackint const m, mpf_class *w, mplapackint *iblock, mplapackint *isplit, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rstemr(const char *jobz, const char *range, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mplapackint const nzc, mplapackint *isuppz, bool &tryrac, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsteqr(const char *compz, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint &info);
void Rsterf(mplapackint const n, mpf_class *d, mpf_class *e, mplapackint &info);
void Rstev(const char *jobz, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint &info);
void Rstevd(const char *jobz, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstevr(const char *jobz, const char *range, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mplapackint *isuppz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstevx(const char *jobz, const char *range, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsycon(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rsycon_3(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *e, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rsycon_rook(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class const anorm, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rsyconv(const char *uplo, const char *way, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *e, mplapackint &info);
void Rsyconvf(const char *uplo, const char *way, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *e, mplapackint *ipiv, mplapackint &info);
void Rsyconvf_rook(const char *uplo, const char *way, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *e, mplapackint *ipiv, mplapackint &info);
void Rsyequb(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *s, mpf_class &scond, mpf_class &amax, mpf_class *work, mplapackint &info);
void Rsyev(const char *jobz, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *w, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsyev_2stage(const char *jobz, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *w, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsyevd(const char *jobz, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *w, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *w, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevr(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mplapackint *isuppz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevr_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mplapackint *isuppz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsyevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsygs2(mplapackint const itype, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rsygst(mplapackint const itype, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rsygv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *w, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsygv_2stage(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *w, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsygvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *w, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsygvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class const vl, mpf_class const vu, mplapackint const il, mplapackint const iu, mpf_class const abstol, mplapackint &m, mpf_class *w, mpf_class *z, mplapackint const ldz, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsyrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *af, mplapackint const ldaf, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rsysv(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsysv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsysv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsysv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *e, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsysv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsysvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *af, mplapackint const ldaf, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class &rcond, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rsyswapr(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Rsytd2(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpf_class *tau, mplapackint &info);
void Rsytf2(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rsytf2_rk(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *e, mplapackint *ipiv, mplapackint &info);
void Rsytf2_rook(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rsytrd(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_2stage(const char *vect, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpf_class *tau, mpf_class *hous2, mplapackint const lhous2, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_sb2st(const char *stage1, const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *d, mpf_class *e, mpf_class *hous, mplapackint const lhous, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_sy2sb(const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *a, mplapackint const lda, mpf_class *ab, mplapackint const ldab, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsytrf(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_aa(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_aa_2stage(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_rk(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *e, mplapackint *ipiv, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_rook(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsytri(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *work, mplapackint &info);
void Rsytri2(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsytri2x(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *work, mplapackint const nb, mplapackint &info);
void Rsytri_3(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *e, mplapackint *ipiv, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsytri_3x(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *e, mplapackint *ipiv, mpf_class *work, mplapackint const nb, mplapackint &info);
void Rsytri_rook(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *work, mplapackint &info);
void Rsytrs(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rsytrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint &info);
void Rsytrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *e, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rsytrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rsytrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rsytrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rtbcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rtbrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rtbtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rtfsm(const char *transr, const char *side, const char *uplo, const char *trans, const char *diag, mplapackint const m, mplapackint const n, mpf_class const alpha, mpf_class *a, mpf_class *b, mplapackint const ldb);
void Rtftri(const char *transr, const char *uplo, const char *diag, mplapackint const n, mpf_class *a, mplapackint &info);
void Rtfttp(const char *transr, const char *uplo, mplapackint const n, mpf_class *arf, mpf_class *ap, mplapackint &info);
void Rtfttr(const char *transr, const char *uplo, mplapackint const n, mpf_class *arf, mpf_class *a, mplapackint const lda, mplapackint &info);
void Rtgevc(const char *side, const char *howmny, bool *select, mplapackint const n, mpf_class *s, mplapackint const lds, mpf_class *p, mplapackint const ldp, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpf_class *work, mplapackint &info);
void Rtgex2(bool const wantq, bool const wantz, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *q, mplapackint const ldq, mpf_class *z, mplapackint const ldz, mplapackint const j1, mplapackint const n1, mplapackint const n2, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rtgexc(bool const wantq, bool const wantz, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *q, mplapackint const ldq, mpf_class *z, mplapackint const ldz, mplapackint &ifst, mplapackint &ilst, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rtgsen(mplapackint const ijob, bool const wantq, bool const wantz, bool *select, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *q, mplapackint const ldq, mpf_class *z, mplapackint const ldz, mplapackint &m, mpf_class &pl, mpf_class &pr, mpf_class *dif, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rtgsja(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mplapackint const k, mplapackint const l, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class const tola, mpf_class const tolb, mpf_class *alpha, mpf_class *beta, mpf_class *u, mplapackint const ldu, mpf_class *v, mplapackint const ldv, mpf_class *q, mplapackint const ldq, mpf_class *work, mplapackint &ncycle, mplapackint &info);
void Rtgsna(const char *job, const char *howmny, bool *select, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mpf_class *s, mpf_class *dif, mplapackint const mm, mplapackint &m, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rtgsy2(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *c, mplapackint const ldc, mpf_class *d, mplapackint const ldd, mpf_class *e, mplapackint const lde, mpf_class *f, mplapackint const ldf, mpf_class &scale, mpf_class &rdsum, mpf_class &rdscal, mplapackint *iwork, mplapackint &pq, mplapackint &info);
void Rtgsyl(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *c, mplapackint const ldc, mpf_class *d, mplapackint const ldd, mpf_class *e, mplapackint const lde, mpf_class *f, mplapackint const ldf, mpf_class &scale, mpf_class &dif, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rtpcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mpf_class *ap, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rtplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *t, mplapackint const ldt, mpf_class *work, mplapackint &info);
void Rtplqt2(mplapackint const m, mplapackint const n, mplapackint const l, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *t, mplapackint const ldt, mplapackint &info);
void Rtpmlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const mb, mpf_class *v, mplapackint const ldv, mpf_class *t, mplapackint const ldt, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint &info);
void Rtpmqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const nb, mpf_class *v, mplapackint const ldv, mpf_class *t, mplapackint const ldt, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint &info);
void Rtpqrt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *t, mplapackint const ldt, mpf_class *work, mplapackint &info);
void Rtpqrt2(mplapackint const m, mplapackint const n, mplapackint const l, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *t, mplapackint const ldt, mplapackint &info);
void Rtprfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mpf_class *v, mplapackint const ldv, mpf_class *t, mplapackint const ldt, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const ldwork);
void Rtprfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rtptri(const char *uplo, const char *diag, mplapackint const n, mpf_class *ap, mplapackint &info);
void Rtptrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rtpttf(const char *transr, const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *arf, mplapackint &info);
void Rtpttr(const char *uplo, mplapackint const n, mpf_class *ap, mpf_class *a, mplapackint const lda, mplapackint &info);
void Rtrcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class &rcond, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rtrevc(const char *side, const char *howmny, bool *select, mplapackint const n, mpf_class *t, mplapackint const ldt, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpf_class *work, mplapackint &info);
void Rtrevc3(const char *side, const char *howmny, bool *select, mplapackint const n, mpf_class *t, mplapackint const ldt, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rtrexc(const char *compq, mplapackint const n, mpf_class *t, mplapackint const ldt, mpf_class *q, mplapackint const ldq, mplapackint &ifst, mplapackint &ilst, mpf_class *work, mplapackint &info);
void Rtrrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *ferr, mpf_class *berr, mpf_class *work, mplapackint *iwork, mplapackint &info);
void Rtrsen(const char *job, const char *compq, bool *select, mplapackint const n, mpf_class *t, mplapackint const ldt, mpf_class *q, mplapackint const ldq, mpf_class *wr, mpf_class *wi, mplapackint &m, mpf_class &s, mpf_class &sep, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rtrsna(const char *job, const char *howmny, bool *select, mplapackint const n, mpf_class *t, mplapackint const ldt, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mpf_class *s, mpf_class *sep, mplapackint const mm, mplapackint &m, mpf_class *work, mplapackint const ldwork, mplapackint *iwork, mplapackint &info);
void Rtrsyl(const char *trana, const char *tranb, mplapackint const isgn, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *c, mplapackint const ldc, mpf_class &scale, mplapackint &info);
void Rtrti2(const char *uplo, const char *diag, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint &info);
void Rtrtri(const char *uplo, const char *diag, mplapackint const n, mpf_class *a, mplapackint const lda, mplapackint &info);
void Rtrtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rtrttf(const char *transr, const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *arf, mplapackint &info);
void Rtrttp(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *ap, mplapackint &info);
void Rtzrzf(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mplapackint &info);
void iMlaver_gmp(mplapackint &mplapack_ver_major, mplapackint &mplapack_ver_minor, mplapackint &mplapack_ver_patch, mplapackint &lapack_ver_major, mplapackint &lapack_ver_minor, mplapackint &lapack_ver_patch);
void mplapack_gmp_initialize(void);
#endif
