/*
 * Copyright (c) 2008-2022
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_EIG_GMP_H_
#define _MPLAPACK_EIG_GMP_H_

#include "mplapack_config.h"
#include "gmpxx.h"
#include "mpc_class.h"

bool Clctes(mpc_class const z, mpc_class const d);
bool Clctsx(mpc_class const, mpc_class const);
bool Cslect(mpc_class const z);
bool Rlctes(mpf_class const zr, mpf_class const zi, mpf_class const d);
bool Rlctsx(mpf_class const, mpf_class const, mpf_class const);
bool Rslect(mpf_class const zr, mpf_class const zi);
mpf_class Rlamch_gmp(const char *cmach);
mpf_class Rsxt1(mplapackint const ijob, mpf_class *d1, mplapackint const n1, mpf_class *d2, mplapackint const n2, mpf_class const abstol, mpf_class const ulp, mpf_class const unfl);
mplapackint iMlaenv2stage_gmp(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_gmp(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
void Alahdg(mplapackint const iounit, const char *path);
void Alareq(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alarqg(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alasmg(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasum(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasvm(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Cbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, mpc_class *a, mplapackint const lda, mpc_class *q, mplapackint const ldq, mpf_class *d, mpf_class *e, mpc_class *pt, mplapackint const ldpt, mpc_class *work, mpf_class *rwork, mpf_class &resid);
void Cbdt02(mplapackint const m, mplapackint const n, mpc_class *b, mplapackint const ldb, mpc_class *c, mplapackint const ldc, mpc_class *u, mplapackint const ldu, mpc_class *work, mpf_class *rwork, mpf_class &resid);
void Cbdt03(const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *d, mpf_class *e, mpc_class *u, mplapackint const ldu, mpf_class *s, mpc_class *vt, mplapackint const ldvt, mpc_class *work, mpf_class &resid);
void Cbdt05(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *s, mplapackint const ns, mpc_class *u, mplapackint const ldu, mpc_class *vt, mplapackint const ldvt, mpc_class *work, mpf_class &resid);
void Cchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *ab, mplapackint const ldab, mpf_class *bd, mpf_class *be, mpc_class *q, mplapackint const ldq, mpc_class *p, mplapackint const ldp, mpc_class *c, mplapackint const ldc, mpc_class *cc, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result, mplapackint &info);
void Cchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, mpf_class const thresh, mpc_class *a, mplapackint const lda, mpf_class *bd, mpf_class *be, mpf_class *s1, mpf_class *s2, mpc_class *x, mplapackint const ldx, mpc_class *y, mpc_class *z, mpc_class *q, mplapackint const ldq, mpc_class *pt, mplapackint const ldpt, mpc_class *u, mpc_class *vt, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const nout, mplapackint &info);
void Cchkbk(mplapackint const nin, mplapackint const nout);
void Cchkbl(mplapackint const nin, mplapackint const nout);
void Cchkec(mpf_class const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Cchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, bool const tstdif, mpf_class const thrshn, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *b, mpc_class *h, mpc_class *t, mpc_class *s1, mpc_class *s2, mpc_class *p1, mpc_class *p2, mpc_class *u, mplapackint const ldu, mpc_class *v, mpc_class *q, mpc_class *z, mpc_class *alpha1, mpc_class *beta1, mpc_class *alpha3, mpc_class *beta3, mpc_class *evectl, mpc_class *evectr, mpc_class *work, mplapackint const lwork, mpf_class *rwork, bool *llwork, mpf_class *result, mplapackint &info);
void Cchkgk(mplapackint const nin, mplapackint const nout);
void Cchkgl(mplapackint const nin, mplapackint const nout);
void Cchkhb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpf_class *sd, mpf_class *se, mpc_class *u, mplapackint const ldu, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result, mplapackint &info);
void Cchkhb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpf_class *sd, mpf_class *se, mpf_class *d1, mpf_class *d2, mpf_class *d3, mpc_class *u, mplapackint const ldu, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result, mplapackint &info);
void Cchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *h, mpc_class *t1, mpc_class *t2, mpc_class *u, mplapackint const ldu, mpc_class *z, mpc_class *uz, mpc_class *w1, mpc_class *w3, mpc_class *evectl, mpc_class *evectr, mpc_class *evecty, mpc_class *evectx, mpc_class *uu, mpc_class *tau, mpc_class *work, mplapackint const nwork, mpf_class *rwork, mplapackint *iwork, bool *select, mpf_class *result, mplapackint &info);
void Cchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *ap, mpf_class *sd, mpf_class *se, mpf_class *d1, mpf_class *d2, mpf_class *d3, mpf_class *d4, mpf_class *d5, mpf_class *wa1, mpf_class *wa2, mpf_class *wa3, mpf_class *wr, mpc_class *u, mplapackint const ldu, mpc_class *v, mpc_class *vp, mpc_class *tau, mpc_class *z, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, mplapackint &info);
void Cchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *ap, mpf_class *sd, mpf_class *se, mpf_class *d1, mpf_class *d2, mpf_class *d3, mpf_class *d4, mpf_class *d5, mpf_class *wa1, mpf_class *wa2, mpf_class *wa3, mpf_class *wr, mpc_class *u, mplapackint const ldu, mpc_class *v, mpc_class *vp, mpc_class *tau, mpc_class *z, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, mplapackint &info);
void Cckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, mpf_class const thresh, mplapackint const mmax, mpc_class *x, mpc_class *xf, mpc_class *u1, mpc_class *u2, mpc_class *v1t, mpc_class *v2t, mpf_class *theta, mplapackint *iwork, mpc_class *work, mpf_class *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckglm(mplapackint const nn, mplapackint *nval, mplapackint *mval, mplapackint *pval, mplapackint const nmats, mplapackint *iseed, mpf_class const thresh, mplapackint const nmax, mpc_class *a, mpc_class *af, mpc_class *b, mpc_class *bf, mpc_class *x, mpc_class *work, mpf_class *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpf_class const thresh, mplapackint const nmax, mpc_class *a, mpc_class *af, mpc_class *aq, mpc_class *ar, mpc_class *taua, mpc_class *b, mpc_class *bf, mpc_class *bz, mpc_class *bt, mpc_class *bwk, mpc_class *taub, mpc_class *work, mpf_class *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpf_class const thresh, mplapackint const nmax, mpc_class *a, mpc_class *af, mpc_class *b, mpc_class *bf, mpc_class *u, mpc_class *v, mpc_class *q, mpf_class *alpha, mpf_class *beta, mpc_class *r, mplapackint *iwork, mpc_class *work, mpf_class *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpf_class const thresh, mplapackint const nmax, mpc_class *a, mpc_class *af, mpc_class *b, mpc_class *bf, mpc_class *x, mpc_class *work, mpf_class *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccsdts(mplapackint const m, mplapackint const p, mplapackint const q, mpc_class *x, mpc_class *xf, mplapackint const ldx, mpc_class *u1, mplapackint const ldu1, mpc_class *u2, mplapackint const ldu2, mpc_class *v1t, mplapackint const ldv1t, mpc_class *v2t, mplapackint const ldv2t, mpf_class *theta, mplapackint *iwork, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Cdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *b, mpc_class *s, mpc_class *t, mpc_class *q, mplapackint const ldq, mpc_class *z, mpc_class *alpha, mpc_class *beta, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result, bool *bwork, mplapackint &info);
void Cdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *b, mpc_class *s, mpc_class *t, mpc_class *q, mplapackint const ldq, mpc_class *z, mpc_class *alpha, mpc_class *beta, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result, bool *bwork, mplapackint &info);
void Cdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *b, mpc_class *s, mpc_class *t, mpc_class *q, mplapackint const ldq, mpc_class *z, mpc_class *qe, mplapackint const ldqe, mpc_class *alpha, mpc_class *beta, mpc_class *alpha1, mpc_class *beta1, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result, mplapackint &info);
void Cdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *b, mpc_class *s, mpc_class *t, mpc_class *q, mplapackint const ldq, mpc_class *z, mpc_class *qe, mplapackint const ldqe, mpc_class *alpha, mpc_class *beta, mpc_class *alpha1, mpc_class *beta1, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result, mplapackint &info);
void Cdrgsx(mplapackint const nsize, mplapackint const ncmax, mpf_class const thresh, mplapackint const nin, mplapackint const nout, mpc_class *a, mplapackint const lda, mpc_class *b, mpc_class *ai, mpc_class *bi, mpc_class *z, mpc_class *q, mpc_class *alpha, mpc_class *beta, mpc_class *c, mplapackint const ldc, mpf_class *s, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cdrgvx(mplapackint const nsize, mpf_class const thresh, mplapackint const nin, mplapackint const nout, mpc_class *a, mplapackint const lda, mpc_class *b, mpc_class *ai, mpc_class *bi, mpc_class *alpha, mpc_class *beta, mpc_class *vl, mpc_class *vr, mplapackint &ilo, mplapackint &ihi, mpf_class *lscale, mpf_class *rscale, mpf_class *s, mpf_class *dtru, mpf_class *dif, mpf_class *diftru, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, bool *bwork, mplapackint &info);
void Cdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mpc_class *a, mplapackint const lda, mpc_class *u, mplapackint const ldu, mpc_class *vt, mplapackint const ldvt, mpc_class *asav, mpc_class *usav, mpc_class *vtsav, mpf_class *s, mpf_class *ssav, mpf_class *e, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint *iwork, mplapackint const nounit, mplapackint &info);
void Cdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *h, mpc_class *ht, mpc_class *w, mpc_class *wt, mpc_class *vs, mplapackint const ldvs, mpf_class *result, mpc_class *work, mplapackint const nwork, mpf_class *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *h, mpc_class *w, mpc_class *w1, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mpc_class *lre, mplapackint const ldlre, mpf_class *result, mpc_class *work, mplapackint const nwork, mpf_class *rwork, mplapackint *iwork, mplapackint &info);
void Cdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpf_class *d, mpc_class *z, mplapackint const ldz, mpc_class *ab, mpc_class *bb, mpc_class *ap, mpc_class *bp, mpc_class *work, mplapackint const nwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, mplapackint &info);
void Cdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpf_class *d, mpf_class *d2, mpc_class *z, mplapackint const ldz, mpc_class *ab, mpc_class *bb, mpc_class *ap, mpc_class *bp, mpc_class *work, mplapackint const nwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, mplapackint &info);
void Cdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpf_class *d1, mpf_class *d2, mpf_class *d3, mpf_class *wa1, mpf_class *wa2, mpf_class *wa3, mpc_class *u, mplapackint const ldu, mpc_class *v, mpc_class *tau, mpc_class *z, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, mplapackint &info);
void Cdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpf_class *d1, mpf_class *d2, mpf_class *d3, mpf_class *wa1, mpf_class *wa2, mpf_class *wa3, mpc_class *u, mplapackint const ldu, mpc_class *v, mpc_class *tau, mpc_class *z, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, mplapackint &info);
void Cdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const niunit, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *h, mpc_class *ht, mpc_class *w, mpc_class *wt, mpc_class *wtmp, mpc_class *vs, mplapackint const ldvs, mpc_class *vs1, mpf_class *result, mpc_class *work, mplapackint const lwork, mpf_class *rwork, bool *bwork, mplapackint &info);
void Cdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const niunit, mplapackint const nounit, mpc_class *a, mplapackint const lda, mpc_class *h, mpc_class *w, mpc_class *w1, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mpc_class *lre, mplapackint const ldlre, mpf_class *rcondv, mpf_class *rcndv1, mpf_class *rcdvin, mpf_class *rconde, mpf_class *rcnde1, mpf_class *rcdein, mpf_class *scale, mpf_class *scale1, mpf_class *result, mpc_class *work, mplapackint const nwork, mpf_class *rwork, mplapackint &info);
void Cerrbd(const char *path, mplapackint const nunit);
void Cerrec(const char *path, mplapackint const nunit);
void Cerred(const char *path, mplapackint const nunit);
void Cerrgg(const char *path, mplapackint const nunit);
void Cerrhs(const char *path, mplapackint const nunit);
void Cerrst(const char *path, mplapackint const nunit);
void Cget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Cget10(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *work, mpf_class *rwork, mpf_class &result);
void Cget22(const char *transa, const char *transe, const char *transw, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *e, mplapackint const lde, mpc_class *w, mpc_class *work, mpf_class *rwork, mpf_class *result);
void Cget23(bool const comp, mplapackint const isrt, const char *balanc, mplapackint const jtype, mpf_class const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *h, mpc_class *w, mpc_class *w1, mpc_class *vl, mplapackint const ldvl, mpc_class *vr, mplapackint const ldvr, mpc_class *lre, mplapackint const ldlre, mpf_class *rcondv, mpf_class *rcndv1, mpf_class *rcdvin, mpf_class *rconde, mpf_class *rcnde1, mpf_class *rcdein, mpf_class *scale, mpf_class *scale1, mpf_class *result, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mplapackint &info);
void Cget24(bool const comp, mplapackint const jtype, mpf_class const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *h, mpc_class *ht, mpc_class *w, mpc_class *wt, mpc_class *wtmp, mpc_class *vs, mplapackint const ldvs, mpc_class *vs1, mpf_class const rcdein, mpf_class const rcdvin, mplapackint const nslct, mplapackint *islct, mplapackint const isrt, mpf_class *result, mpc_class *work, mplapackint const lwork, mpf_class *rwork, bool *bwork, mplapackint &info);
void Cget35(mpf_class &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget36(mpf_class &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget37(mpf_class *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget38(mpf_class *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget51(mplapackint const itype, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *u, mplapackint const ldu, mpc_class *v, mplapackint const ldv, mpc_class *work, mpf_class *rwork, mpf_class &result);
void Cget52(bool const left, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *e, mplapackint const lde, mpc_class *alpha, mpc_class *beta, mpc_class *work, mpf_class *rwork, mpf_class *result);
void Cget54(mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *s, mplapackint const lds, mpc_class *t, mplapackint const ldt, mpc_class *u, mplapackint const ldu, mpc_class *v, mplapackint const ldv, mpc_class *work, mpf_class &result);
void Cglmts(mplapackint const n, mplapackint const m, mplapackint const p, mpc_class *a, mpc_class *af, mplapackint const lda, mpc_class *b, mpc_class *bf, mplapackint const ldb, mpc_class *d, mpc_class *df, mpc_class *x, mpc_class *u, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class &result);
void Cgqrts(mplapackint const n, mplapackint const m, mplapackint const p, mpc_class *a, mpc_class *af, mpc_class *q, mpc_class *r, mplapackint const lda, mpc_class *taua, mpc_class *b, mpc_class *bf, mpc_class *z, mpc_class *t, mpc_class *bwk, mplapackint const ldb, mpc_class *taub, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Cgrqts(mplapackint const m, mplapackint const p, mplapackint const n, mpc_class *a, mpc_class *af, mpc_class *q, mpc_class *r, mplapackint const lda, mpc_class *taua, mpc_class *b, mpc_class *bf, mpc_class *z, mpc_class *t, mpc_class *bwk, mplapackint const ldb, mpc_class *taub, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Cgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, mpc_class *a, mpc_class *af, mplapackint const lda, mpc_class *b, mpc_class *bf, mplapackint const ldb, mpc_class *u, mplapackint const ldu, mpc_class *v, mplapackint const ldv, mpc_class *q, mplapackint const ldq, mpf_class *alpha, mpf_class *beta, mpc_class *r, mplapackint const ldr, mplapackint *iwork, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Chbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, mpc_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpc_class *u, mplapackint const ldu, mpc_class *work, mpf_class *rwork, mpf_class *result);
void Chet21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, mpc_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpc_class *u, mplapackint const ldu, mpc_class *v, mplapackint const ldv, mpc_class *tau, mpc_class *work, mpf_class *rwork, mpf_class *result);
void Chet22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, mpc_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpc_class *u, mplapackint const ldu, mpc_class *, mplapackint const ldv, mpc_class *, mpc_class *work, mpf_class *rwork, mpf_class *result);
void Chpt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, mpc_class *ap, mpf_class *d, mpf_class *e, mpc_class *u, mplapackint const ldu, mpc_class *vp, mpc_class *tau, mpc_class *work, mpf_class *rwork, mpf_class *result);
void Chst01(mplapackint const n, mplapackint const, mplapackint const, mpc_class *a, mplapackint const lda, mpc_class *h, mplapackint const ldh, mpc_class *q, mplapackint const ldq, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Clacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, mpf_class *theta, mplapackint *iseed, mpc_class *x, mplapackint const &ldx, mpc_class *work);
void Clarfy(const char *uplo, mplapackint const n, mpc_class *v, mplapackint const incv, mpc_class const tau, mpc_class *c, mplapackint const ldc, mpc_class *work);
void Clarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Clatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, bool const rsign, mpf_class const amagn, mpf_class const rcond, mpf_class const triang, mplapackint const idist, mplapackint *iseed, mpc_class *a, mplapackint const lda);
void Clsets(mplapackint const m, mplapackint const p, mplapackint const n, mpc_class *a, mpc_class *af, mplapackint const lda, mpc_class *b, mpc_class *bf, mplapackint const ldb, mpc_class *c, mpc_class *cf, mpc_class *d, mpc_class *df, mpc_class *x, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Csbmv(const char *uplo, mplapackint const n, mplapackint const k, mpc_class const alpha, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const incx, mpc_class const beta, mpc_class *y, mplapackint const incy);
void Csgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *z, mplapackint const ldz, mpf_class *d, mpc_class *work, mpf_class *rwork, mpf_class *result);
void Cstt21(mplapackint const n, mplapackint const kband, mpf_class *ad, mpf_class *ae, mpf_class *sd, mpf_class *se, mpc_class *u, mplapackint const ldu, mpc_class *work, mpf_class *rwork, mpf_class *result);
void Cstt22(mplapackint const n, mplapackint const m, mplapackint const kband, mpf_class *ad, mpf_class *ae, mpf_class *sd, mpf_class *se, mpc_class *u, mplapackint const ldu, mpc_class *work, mplapackint const ldwork, mpf_class *rwork, mpf_class *result);
void Cunt01(const char *rowcol, mplapackint const m, mplapackint const n, mpc_class *u, mplapackint const ldu, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class &resid);
void Cunt03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, mpc_class *u, mplapackint const ldu, mpc_class *v, mplapackint const ldv, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class &result, mplapackint &info);
void Mxerbla(const char *srname, int info);
void Rbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, mpf_class *a, mplapackint const lda, mpf_class *q, mplapackint const ldq, mpf_class *d, mpf_class *e, mpf_class *pt, mplapackint const ldpt, mpf_class *work, mpf_class &resid);
void Rbdt02(mplapackint const m, mplapackint const n, mpf_class *b, mplapackint const ldb, mpf_class *c, mplapackint const ldc, mpf_class *u, mplapackint const ldu, mpf_class *work, mpf_class &resid);
void Rbdt03(const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *d, mpf_class *e, mpf_class *u, mplapackint const ldu, mpf_class *s, mpf_class *vt, mplapackint const ldvt, mpf_class *work, mpf_class &resid);
void Rbdt04(const char *uplo, mplapackint const n, mpf_class *d, mpf_class *e, mpf_class *s, mplapackint const ns, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint const ldvt, mpf_class *work, mpf_class &resid);
void Rbdt05(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *s, mplapackint const ns, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint const ldvt, mpf_class *work, mpf_class &resid);
void Rchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *ab, mplapackint const ldab, mpf_class *bd, mpf_class *be, mpf_class *q, mplapackint const ldq, mpf_class *p, mplapackint const ldp, mpf_class *c, mplapackint const ldc, mpf_class *cc, mpf_class *work, mplapackint const lwork, mpf_class *result, mplapackint &info);
void Rchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, mpf_class const thresh, mpf_class *a, mplapackint const lda, mpf_class *bd, mpf_class *be, mpf_class *s1, mpf_class *s2, mpf_class *x, mplapackint const ldx, mpf_class *y, mpf_class *z, mpf_class *q, mplapackint const ldq, mpf_class *pt, mplapackint const ldpt, mpf_class *u, mpf_class *vt, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rchkbk(mplapackint const nin, mplapackint const nout);
void Rchkbl(mplapackint const nin, mplapackint const nout);
void Rchkec(mpf_class const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Rchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, bool const tstdif, mpf_class const thrshn, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *b, mpf_class *h, mpf_class *t, mpf_class *s1, mpf_class *s2, mpf_class *p1, mpf_class *p2, mpf_class *u, mplapackint const ldu, mpf_class *v, mpf_class *q, mpf_class *z, mpf_class *alphr1, mpf_class *alphi1, mpf_class *beta1, mpf_class *alphr3, mpf_class *alphi3, mpf_class *beta3, mpf_class *evectl, mpf_class *evectr, mpf_class *work, mplapackint const lwork, bool *llwork, mpf_class *result, mplapackint &info);
void Rchkgk(mplapackint const nin, mplapackint const nout);
void Rchkgl(mplapackint const nin, mplapackint const nout);
void Rchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *h, mpf_class *t1, mpf_class *t2, mpf_class *u, mplapackint const ldu, mpf_class *z, mpf_class *uz, mpf_class *wr1, mpf_class *wi1, mpf_class *wr2, mpf_class *wi2, mpf_class *wr3, mpf_class *wi3, mpf_class *evectl, mpf_class *evectr, mpf_class *evecty, mpf_class *evectx, mpf_class *uu, mpf_class *tau, mpf_class *work, mplapackint const nwork, mplapackint *iwork, bool *select, mpf_class *result, mplapackint &info);
void Rchksb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *sd, mpf_class *se, mpf_class *u, mplapackint const ldu, mpf_class *work, mplapackint const lwork, mpf_class *result, mplapackint &info);
void Rchksb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *sd, mpf_class *se, mpf_class *d1, mpf_class *d2, mpf_class *d3, mpf_class *u, mplapackint const ldu, mpf_class *work, mplapackint const lwork, mpf_class *result, mplapackint &info);
void Rchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *ap, mpf_class *sd, mpf_class *se, mpf_class *d1, mpf_class *d2, mpf_class *d3, mpf_class *d4, mpf_class *d5, mpf_class *wa1, mpf_class *wa2, mpf_class *wa3, mpf_class *wr, mpf_class *u, mplapackint const ldu, mpf_class *v, mpf_class *vp, mpf_class *tau, mpf_class *z, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, mplapackint &info);
void Rchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *ap, mpf_class *sd, mpf_class *se, mpf_class *d1, mpf_class *d2, mpf_class *d3, mpf_class *d4, mpf_class *d5, mpf_class *wa1, mpf_class *wa2, mpf_class *wa3, mpf_class *wr, mpf_class *u, mplapackint const ldu, mpf_class *v, mpf_class *vp, mpf_class *tau, mpf_class *z, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, mplapackint &info);
void Rckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, mpf_class const thresh, mplapackint const mmax, mpf_class *x, mpf_class *xf, mpf_class *u1, mpf_class *u2, mpf_class *v1t, mpf_class *v2t, mpf_class *theta, mplapackint *iwork, mpf_class *work, mpf_class *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckglm(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpf_class const thresh, mplapackint const nmax, mpf_class *a, mpf_class *af, mpf_class *b, mpf_class *bf, mpf_class *x, mpf_class *work, mpf_class *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpf_class const thresh, mplapackint const nmax, mpf_class *a, mpf_class *af, mpf_class *aq, mpf_class *ar, mpf_class *taua, mpf_class *b, mpf_class *bf, mpf_class *bz, mpf_class *bt, mpf_class *bwk, mpf_class *taub, mpf_class *work, mpf_class *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpf_class const thresh, mplapackint const nmax, mpf_class *a, mpf_class *af, mpf_class *b, mpf_class *bf, mpf_class *u, mpf_class *v, mpf_class *q, mpf_class *alpha, mpf_class *beta, mpf_class *r, mplapackint *iwork, mpf_class *work, mpf_class *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpf_class const thresh, mplapackint const nmax, mpf_class *a, mpf_class *af, mpf_class *b, mpf_class *bf, mpf_class *x, mpf_class *work, mpf_class *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcsdts(mplapackint const m, mplapackint const p, mplapackint const q, mpf_class *x, mpf_class *xf, mplapackint const ldx, mpf_class *u1, mplapackint const ldu1, mpf_class *u2, mplapackint const ldu2, mpf_class *v1t, mplapackint const ldv1t, mpf_class *v2t, mplapackint const ldv2t, mpf_class *theta, mplapackint *iwork, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *b, mpf_class *s, mpf_class *t, mpf_class *q, mplapackint const ldq, mpf_class *z, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *work, mplapackint const lwork, mpf_class *result, bool *bwork, mplapackint &info);
void Rdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *b, mpf_class *s, mpf_class *t, mpf_class *q, mplapackint const ldq, mpf_class *z, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *work, mplapackint const lwork, mpf_class *result, bool *bwork, mplapackint &info);
void Rdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *b, mpf_class *s, mpf_class *t, mpf_class *q, mplapackint const ldq, mpf_class *z, mpf_class *qe, mplapackint const ldqe, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *alphr1, mpf_class *alphi1, mpf_class *beta1, mpf_class *work, mplapackint const lwork, mpf_class *result, mplapackint &info);
void Rdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *b, mpf_class *s, mpf_class *t, mpf_class *q, mplapackint const ldq, mpf_class *z, mpf_class *qe, mplapackint const ldqe, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *alphr1, mpf_class *alphi1, mpf_class *beta1, mpf_class *work, mplapackint const lwork, mpf_class *result, mplapackint &info);
void Rdrgsx(mplapackint const nsize, mplapackint const ncmax, mpf_class const thresh, mplapackint const nin, mplapackint const nout, mpf_class *a, mplapackint const lda, mpf_class *b, mpf_class *ai, mpf_class *bi, mpf_class *z, mpf_class *q, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *c, mplapackint const ldc, mpf_class *s, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rdrgvx(mplapackint const nsize, mpf_class const thresh, mplapackint const nin, mplapackint const nout, mpf_class *a, mplapackint const lda, mpf_class *b, mpf_class *ai, mpf_class *bi, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *vl, mpf_class *vr, mplapackint const ilo, mplapackint const ihi, mpf_class *lscale, mpf_class *rscale, mpf_class *s, mpf_class *dtru, mpf_class *dif, mpf_class *diftru, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, bool *bwork, mplapackint &info);
void Rdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mpf_class *a, mplapackint const lda, mpf_class *u, mplapackint const ldu, mpf_class *vt, mplapackint const ldvt, mpf_class *asav, mpf_class *usav, mpf_class *vtsav, mpf_class *s, mpf_class *ssav, mpf_class *e, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *h, mpf_class *ht, mpf_class *wr, mpf_class *wi, mpf_class *wrt, mpf_class *wit, mpf_class *vs, mplapackint const ldvs, mpf_class *result, mpf_class *work, mplapackint const nwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *h, mpf_class *wr, mpf_class *wi, mpf_class *wr1, mpf_class *wi1, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mpf_class *lre, mplapackint const ldlre, mpf_class *result, mpf_class *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *d, mpf_class *z, mplapackint const ldz, mpf_class *ab, mpf_class *bb, mpf_class *ap, mpf_class *bp, mpf_class *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, mplapackint &info);
void Rdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *d, mpf_class *d2, mpf_class *z, mplapackint const ldz, mpf_class *ab, mpf_class *bb, mpf_class *ap, mpf_class *bp, mpf_class *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, mplapackint &info);
void Rdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *d1, mpf_class *d2, mpf_class *d3, mpf_class *d4, mpf_class *eveigs, mpf_class *wa1, mpf_class *wa2, mpf_class *wa3, mpf_class *u, mplapackint const ldu, mpf_class *v, mpf_class *tau, mpf_class *z, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, mplapackint &info);
void Rdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *d1, mpf_class *d2, mpf_class *d3, mpf_class *d4, mpf_class *eveigs, mpf_class *wa1, mpf_class *wa2, mpf_class *wa3, mpf_class *u, mplapackint const ldu, mpf_class *v, mpf_class *tau, mpf_class *z, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mpf_class *result, mplapackint &info);
void Rdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const niunit, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *h, mpf_class *ht, mpf_class *wr, mpf_class *wi, mpf_class *wrt, mpf_class *wit, mpf_class *wrtmp, mpf_class *witmp, mpf_class *vs, mplapackint const ldvs, mpf_class *vs1, mpf_class *result, mpf_class *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpf_class const thresh, mplapackint const niunit, mplapackint const nounit, mpf_class *a, mplapackint const lda, mpf_class *h, mpf_class *wr, mpf_class *wi, mpf_class *wr1, mpf_class *wi1, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mpf_class *lre, mplapackint const ldlre, mpf_class *rcondv, mpf_class *rcndv1, mpf_class *rcdvin, mpf_class *rconde, mpf_class *rcnde1, mpf_class *rcdein, mpf_class *scale, mpf_class *scale1, mpf_class *result, mpf_class *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rerrbd(const char *path, mplapackint const nunit);
void Rerrec(const char *path, mplapackint const nunit);
void Rerred(const char *path, mplapackint const nunit);
void Rerrgg(const char *path, mplapackint const nunit);
void Rerrhs(const char *path, mplapackint const nunit);
void Rerrst(const char *path, mplapackint const nunit);
void Rget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Rget10(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *work, mpf_class &result);
void Rget22(const char *transa, const char *transe, const char *transw, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *e, mplapackint const lde, mpf_class *wr, mpf_class *wi, mpf_class *work, mpf_class *result);
void Rget23(bool const comp, const char *balanc, mplapackint const jtype, mpf_class const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *h, mpf_class *wr, mpf_class *wi, mpf_class *wr1, mpf_class *wi1, mpf_class *vl, mplapackint const ldvl, mpf_class *vr, mplapackint const ldvr, mpf_class *lre, mplapackint const ldlre, mpf_class *rcondv, mpf_class *rcndv1, mpf_class *rcdvin, mpf_class *rconde, mpf_class *rcnde1, mpf_class *rcdein, mpf_class *scale, mpf_class *scale1, mpf_class *result, mpf_class *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rget24(bool const comp, mplapackint const jtype, mpf_class const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *h, mpf_class *ht, mpf_class *wr, mpf_class *wi, mpf_class *wrt, mpf_class *wit, mpf_class *wrtmp, mpf_class *witmp, mpf_class *vs, mplapackint const ldvs, mpf_class *vs1, mpf_class const rcdein, mpf_class const rcdvin, mplapackint const nslct, mplapackint *islct, mpf_class *result, mpf_class *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rget31(mpf_class &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget32(mpf_class &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget33(mpf_class &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget34(mpf_class &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget35(mpf_class &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget36(mpf_class &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget37(mpf_class *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget38(mpf_class *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget39(mpf_class &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget40(mpf_class &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget51(mplapackint const itype, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *u, mplapackint const ldu, mpf_class *v, mplapackint const ldv, mpf_class *work, mpf_class &result);
void Rget52(bool const left, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *e, mplapackint const lde, mpf_class *alphar, mpf_class *alphai, mpf_class *beta, mpf_class *work, mpf_class *result);
void Rget53(mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class const scale, mpf_class const wr, mpf_class const wi, mpf_class &result, mplapackint &info);
void Rget54(mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *s, mplapackint const lds, mpf_class *t, mplapackint const ldt, mpf_class *u, mplapackint const ldu, mpf_class *v, mplapackint const ldv, mpf_class *work, mpf_class &result);
void Rglmts(mplapackint const n, mplapackint const m, mplapackint const p, mpf_class *a, mpf_class *af, mplapackint const lda, mpf_class *b, mpf_class *bf, mplapackint const ldb, mpf_class *d, mpf_class *df, mpf_class *x, mpf_class *u, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class &result);
void Rgqrts(mplapackint const n, mplapackint const m, mplapackint const p, mpf_class *a, mpf_class *af, mpf_class *q, mpf_class *r, mplapackint const lda, mpf_class *taua, mpf_class *b, mpf_class *bf, mpf_class *z, mpf_class *t, mpf_class *bwk, mplapackint const ldb, mpf_class *taub, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rgrqts(mplapackint const m, mplapackint const p, mplapackint const n, mpf_class *a, mpf_class *af, mpf_class *q, mpf_class *r, mplapackint const lda, mpf_class *taua, mpf_class *b, mpf_class *bf, mpf_class *z, mpf_class *t, mpf_class *bwk, mplapackint const ldb, mpf_class *taub, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, mpf_class *a, mpf_class *af, mplapackint const lda, mpf_class *b, mpf_class *bf, mplapackint const ldb, mpf_class *u, mplapackint const ldu, mpf_class *v, mplapackint const ldv, mpf_class *q, mplapackint const ldq, mpf_class *alpha, mpf_class *beta, mpf_class *r, mplapackint const ldr, mplapackint *iwork, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rhst01(mplapackint const n, mplapackint const, mplapackint const, mpf_class *a, mplapackint const lda, mpf_class *h, mplapackint const ldh, mpf_class *q, mplapackint const ldq, mpf_class *work, mplapackint const lwork, mpf_class *result);
void Rlacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, mpf_class *theta, mplapackint *iseed, mpf_class *x, mplapackint const &ldx, mpf_class *work);
void Rlafts(const char *type, mplapackint const m, mplapackint const n, mplapackint const imat, mplapackint const ntests, mpf_class *result, mplapackint *iseed, mpf_class const thresh, mplapackint const iounit, mplapackint &ie);
void Rlahd2(mplapackint const iounit, const char *path);
void Rlarfy(const char *uplo, mplapackint const n, mpf_class *v, mplapackint const incv, mpf_class const tau, mpf_class *c, mplapackint const ldc, mpf_class *work);
void Rlarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Rlasum(const char *type, mplapackint const iounit, mplapackint const ie, mplapackint const nrun);
void Rlatb9(const char *path, mplapackint const imat, mplapackint const m, mplapackint const p, mplapackint const n, char *type, mplapackint &kla, mplapackint &kua, mplapackint &klb, mplapackint &kub, mpf_class &anorm, mpf_class &bnorm, mplapackint &modea, mplapackint &modeb, mpf_class &cndnma, mpf_class &cndnmb, char *dista, char *distb);
void Rlatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, mplapackint const isign, mpf_class const amagn, mpf_class const rcond, mpf_class const triang, mplapackint const idist, mplapackint *iseed, mpf_class *a, mplapackint const lda);
void Rlsets(mplapackint const m, mplapackint const p, mplapackint const n, mpf_class *a, mpf_class *af, mplapackint const lda, mpf_class *b, mpf_class *bf, mplapackint const ldb, mpf_class *c, mpf_class *cf, mpf_class *d, mpf_class *df, mpf_class *x, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rort01(const char *rowcol, mplapackint const m, mplapackint const n, mpf_class *u, mplapackint const ldu, mpf_class *work, mplapackint const lwork, mpf_class &resid);
void Rort03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, mpf_class *u, mplapackint const ldu, mpf_class *v, mplapackint const ldv, mpf_class *work, mplapackint const lwork, mpf_class &result, mplapackint &info);
void Rsbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, mpf_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpf_class *u, mplapackint const ldu, mpf_class *work, mpf_class *result);
void Rsgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *z, mplapackint const ldz, mpf_class *d, mpf_class *work, mpf_class *result);
void Rspt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, mpf_class *ap, mpf_class *d, mpf_class *e, mpf_class *u, mplapackint const ldu, mpf_class *vp, mpf_class *tau, mpf_class *work, mpf_class *result);
void Rstech(mplapackint const n, mpf_class *a, mpf_class *b, mpf_class *eig, mpf_class const tol, mpf_class *work, mplapackint &info);
void Rstect(mplapackint const n, mpf_class *a, mpf_class *b, mpf_class const shift, mplapackint &num);
void Rstt21(mplapackint const n, mplapackint const kband, mpf_class *ad, mpf_class *ae, mpf_class *sd, mpf_class *se, mpf_class *u, mplapackint const ldu, mpf_class *work, mpf_class *result);
void Rstt22(mplapackint const n, mplapackint const m, mplapackint const kband, mpf_class *ad, mpf_class *ae, mpf_class *sd, mpf_class *se, mpf_class *u, mplapackint const ldu, mpf_class *work, mplapackint const ldwork, mpf_class *result);
void Rsvdch(mplapackint const n, mpf_class *s, mpf_class *e, mpf_class *svd, mpf_class const tol, mplapackint &info);
void Rsvdct(mplapackint const n, mpf_class *s, mpf_class *e, mpf_class const shift, mplapackint &num);
void Rsyt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, mpf_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpf_class *u, mplapackint const ldu, mpf_class *v, mplapackint const ldv, mpf_class *tau, mpf_class *work, mpf_class *result);
void Rsyt22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, mpf_class *a, mplapackint const lda, mpf_class *d, mpf_class *e, mpf_class *u, mplapackint const ldu, mpf_class *, mplapackint const ldv, mpf_class *, mpf_class *work, mpf_class *result);
void chkxer(const char *srnamt, mplapackint const &infot, mplapackint const &nout, bool &lerr, bool &ok);
void xlaenv(mplapackint const &ispec, mplapackint const &nvalue);
#endif
