/*
 * Copyright (c) 2008-2022
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_EIG_DD_H_
#define _MPLAPACK_EIG_DD_H_

#include "mplapack_config.h"
#include "qd/dd_real.h"
#include "dd_complex.h"

bool Clctes(dd_complex const z, dd_complex const d);
bool Clctsx(dd_complex const, dd_complex const);
bool Cslect(dd_complex const z);
bool Rlctes(dd_real const zr, dd_real const zi, dd_real const d);
bool Rlctsx(dd_real const, dd_real const, dd_real const);
bool Rslect(dd_real const zr, dd_real const zi);
dd_real Rlamch_dd(const char *cmach);
dd_real Rsxt1(mplapackint const ijob, dd_real *d1, mplapackint const n1, dd_real *d2, mplapackint const n2, dd_real const abstol, dd_real const ulp, dd_real const unfl);
mplapackint iMlaenv2stage_dd(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_dd(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
void Alahdg(mplapackint const iounit, const char *path);
void Alareq(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alarqg(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alasmg(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasum(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasvm(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Cbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, dd_complex *a, mplapackint const lda, dd_complex *q, mplapackint const ldq, dd_real *d, dd_real *e, dd_complex *pt, mplapackint const ldpt, dd_complex *work, dd_real *rwork, dd_real &resid);
void Cbdt02(mplapackint const m, mplapackint const n, dd_complex *b, mplapackint const ldb, dd_complex *c, mplapackint const ldc, dd_complex *u, mplapackint const ldu, dd_complex *work, dd_real *rwork, dd_real &resid);
void Cbdt03(const char *uplo, mplapackint const n, mplapackint const kd, dd_real *d, dd_real *e, dd_complex *u, mplapackint const ldu, dd_real *s, dd_complex *vt, mplapackint const ldvt, dd_complex *work, dd_real &resid);
void Cbdt05(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *s, mplapackint const ns, dd_complex *u, mplapackint const ldu, dd_complex *vt, mplapackint const ldvt, dd_complex *work, dd_real &resid);
void Cchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *ab, mplapackint const ldab, dd_real *bd, dd_real *be, dd_complex *q, mplapackint const ldq, dd_complex *p, mplapackint const ldp, dd_complex *c, mplapackint const ldc, dd_complex *cc, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result, mplapackint &info);
void Cchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, dd_real const thresh, dd_complex *a, mplapackint const lda, dd_real *bd, dd_real *be, dd_real *s1, dd_real *s2, dd_complex *x, mplapackint const ldx, dd_complex *y, dd_complex *z, dd_complex *q, mplapackint const ldq, dd_complex *pt, mplapackint const ldpt, dd_complex *u, dd_complex *vt, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const nout, mplapackint &info);
void Cchkbk(mplapackint const nin, mplapackint const nout);
void Cchkbl(mplapackint const nin, mplapackint const nout);
void Cchkec(dd_real const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Cchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, bool const tstdif, dd_real const thrshn, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *b, dd_complex *h, dd_complex *t, dd_complex *s1, dd_complex *s2, dd_complex *p1, dd_complex *p2, dd_complex *u, mplapackint const ldu, dd_complex *v, dd_complex *q, dd_complex *z, dd_complex *alpha1, dd_complex *beta1, dd_complex *alpha3, dd_complex *beta3, dd_complex *evectl, dd_complex *evectr, dd_complex *work, mplapackint const lwork, dd_real *rwork, bool *llwork, dd_real *result, mplapackint &info);
void Cchkgk(mplapackint const nin, mplapackint const nout);
void Cchkgl(mplapackint const nin, mplapackint const nout);
void Cchkhb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_real *sd, dd_real *se, dd_complex *u, mplapackint const ldu, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result, mplapackint &info);
void Cchkhb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_real *sd, dd_real *se, dd_real *d1, dd_real *d2, dd_real *d3, dd_complex *u, mplapackint const ldu, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result, mplapackint &info);
void Cchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *h, dd_complex *t1, dd_complex *t2, dd_complex *u, mplapackint const ldu, dd_complex *z, dd_complex *uz, dd_complex *w1, dd_complex *w3, dd_complex *evectl, dd_complex *evectr, dd_complex *evecty, dd_complex *evectx, dd_complex *uu, dd_complex *tau, dd_complex *work, mplapackint const nwork, dd_real *rwork, mplapackint *iwork, bool *select, dd_real *result, mplapackint &info);
void Cchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *ap, dd_real *sd, dd_real *se, dd_real *d1, dd_real *d2, dd_real *d3, dd_real *d4, dd_real *d5, dd_real *wa1, dd_real *wa2, dd_real *wa3, dd_real *wr, dd_complex *u, mplapackint const ldu, dd_complex *v, dd_complex *vp, dd_complex *tau, dd_complex *z, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, mplapackint &info);
void Cchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *ap, dd_real *sd, dd_real *se, dd_real *d1, dd_real *d2, dd_real *d3, dd_real *d4, dd_real *d5, dd_real *wa1, dd_real *wa2, dd_real *wa3, dd_real *wr, dd_complex *u, mplapackint const ldu, dd_complex *v, dd_complex *vp, dd_complex *tau, dd_complex *z, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, mplapackint &info);
void Cckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, dd_real const thresh, mplapackint const mmax, dd_complex *x, dd_complex *xf, dd_complex *u1, dd_complex *u2, dd_complex *v1t, dd_complex *v2t, dd_real *theta, mplapackint *iwork, dd_complex *work, dd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckglm(mplapackint const nn, mplapackint *nval, mplapackint *mval, mplapackint *pval, mplapackint const nmats, mplapackint *iseed, dd_real const thresh, mplapackint const nmax, dd_complex *a, dd_complex *af, dd_complex *b, dd_complex *bf, dd_complex *x, dd_complex *work, dd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, dd_real const thresh, mplapackint const nmax, dd_complex *a, dd_complex *af, dd_complex *aq, dd_complex *ar, dd_complex *taua, dd_complex *b, dd_complex *bf, dd_complex *bz, dd_complex *bt, dd_complex *bwk, dd_complex *taub, dd_complex *work, dd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, dd_real const thresh, mplapackint const nmax, dd_complex *a, dd_complex *af, dd_complex *b, dd_complex *bf, dd_complex *u, dd_complex *v, dd_complex *q, dd_real *alpha, dd_real *beta, dd_complex *r, mplapackint *iwork, dd_complex *work, dd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, dd_real const thresh, mplapackint const nmax, dd_complex *a, dd_complex *af, dd_complex *b, dd_complex *bf, dd_complex *x, dd_complex *work, dd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccsdts(mplapackint const m, mplapackint const p, mplapackint const q, dd_complex *x, dd_complex *xf, mplapackint const ldx, dd_complex *u1, mplapackint const ldu1, dd_complex *u2, mplapackint const ldu2, dd_complex *v1t, mplapackint const ldv1t, dd_complex *v2t, mplapackint const ldv2t, dd_real *theta, mplapackint *iwork, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result);
void Cdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *b, dd_complex *s, dd_complex *t, dd_complex *q, mplapackint const ldq, dd_complex *z, dd_complex *alpha, dd_complex *beta, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result, bool *bwork, mplapackint &info);
void Cdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *b, dd_complex *s, dd_complex *t, dd_complex *q, mplapackint const ldq, dd_complex *z, dd_complex *alpha, dd_complex *beta, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result, bool *bwork, mplapackint &info);
void Cdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *b, dd_complex *s, dd_complex *t, dd_complex *q, mplapackint const ldq, dd_complex *z, dd_complex *qe, mplapackint const ldqe, dd_complex *alpha, dd_complex *beta, dd_complex *alpha1, dd_complex *beta1, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result, mplapackint &info);
void Cdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *b, dd_complex *s, dd_complex *t, dd_complex *q, mplapackint const ldq, dd_complex *z, dd_complex *qe, mplapackint const ldqe, dd_complex *alpha, dd_complex *beta, dd_complex *alpha1, dd_complex *beta1, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result, mplapackint &info);
void Cdrgsx(mplapackint const nsize, mplapackint const ncmax, dd_real const thresh, mplapackint const nin, mplapackint const nout, dd_complex *a, mplapackint const lda, dd_complex *b, dd_complex *ai, dd_complex *bi, dd_complex *z, dd_complex *q, dd_complex *alpha, dd_complex *beta, dd_complex *c, mplapackint const ldc, dd_real *s, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cdrgvx(mplapackint const nsize, dd_real const thresh, mplapackint const nin, mplapackint const nout, dd_complex *a, mplapackint const lda, dd_complex *b, dd_complex *ai, dd_complex *bi, dd_complex *alpha, dd_complex *beta, dd_complex *vl, dd_complex *vr, mplapackint &ilo, mplapackint &ihi, dd_real *lscale, dd_real *rscale, dd_real *s, dd_real *dtru, dd_real *dif, dd_real *diftru, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, bool *bwork, mplapackint &info);
void Cdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, dd_complex *a, mplapackint const lda, dd_complex *u, mplapackint const ldu, dd_complex *vt, mplapackint const ldvt, dd_complex *asav, dd_complex *usav, dd_complex *vtsav, dd_real *s, dd_real *ssav, dd_real *e, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, mplapackint const nounit, mplapackint &info);
void Cdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *h, dd_complex *ht, dd_complex *w, dd_complex *wt, dd_complex *vs, mplapackint const ldvs, dd_real *result, dd_complex *work, mplapackint const nwork, dd_real *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *h, dd_complex *w, dd_complex *w1, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, dd_complex *lre, mplapackint const ldlre, dd_real *result, dd_complex *work, mplapackint const nwork, dd_real *rwork, mplapackint *iwork, mplapackint &info);
void Cdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_real *d, dd_complex *z, mplapackint const ldz, dd_complex *ab, dd_complex *bb, dd_complex *ap, dd_complex *bp, dd_complex *work, mplapackint const nwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, mplapackint &info);
void Cdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_real *d, dd_real *d2, dd_complex *z, mplapackint const ldz, dd_complex *ab, dd_complex *bb, dd_complex *ap, dd_complex *bp, dd_complex *work, mplapackint const nwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, mplapackint &info);
void Cdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_real *d1, dd_real *d2, dd_real *d3, dd_real *wa1, dd_real *wa2, dd_real *wa3, dd_complex *u, mplapackint const ldu, dd_complex *v, dd_complex *tau, dd_complex *z, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, mplapackint &info);
void Cdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_real *d1, dd_real *d2, dd_real *d3, dd_real *wa1, dd_real *wa2, dd_real *wa3, dd_complex *u, mplapackint const ldu, dd_complex *v, dd_complex *tau, dd_complex *z, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, mplapackint &info);
void Cdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const niunit, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *h, dd_complex *ht, dd_complex *w, dd_complex *wt, dd_complex *wtmp, dd_complex *vs, mplapackint const ldvs, dd_complex *vs1, dd_real *result, dd_complex *work, mplapackint const lwork, dd_real *rwork, bool *bwork, mplapackint &info);
void Cdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const niunit, mplapackint const nounit, dd_complex *a, mplapackint const lda, dd_complex *h, dd_complex *w, dd_complex *w1, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, dd_complex *lre, mplapackint const ldlre, dd_real *rcondv, dd_real *rcndv1, dd_real *rcdvin, dd_real *rconde, dd_real *rcnde1, dd_real *rcdein, dd_real *scale, dd_real *scale1, dd_real *result, dd_complex *work, mplapackint const nwork, dd_real *rwork, mplapackint &info);
void Cerrbd(const char *path, mplapackint const nunit);
void Cerrec(const char *path, mplapackint const nunit);
void Cerred(const char *path, mplapackint const nunit);
void Cerrgg(const char *path, mplapackint const nunit);
void Cerrhs(const char *path, mplapackint const nunit);
void Cerrst(const char *path, mplapackint const nunit);
void Cget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *x, mplapackint const ldx, dd_complex *b, mplapackint const ldb, dd_real *rwork, dd_real &resid);
void Cget10(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *work, dd_real *rwork, dd_real &result);
void Cget22(const char *transa, const char *transe, const char *transw, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint const lde, dd_complex *w, dd_complex *work, dd_real *rwork, dd_real *result);
void Cget23(bool const comp, mplapackint const isrt, const char *balanc, mplapackint const jtype, dd_real const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *h, dd_complex *w, dd_complex *w1, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, dd_complex *lre, mplapackint const ldlre, dd_real *rcondv, dd_real *rcndv1, dd_real *rcdvin, dd_real *rconde, dd_real *rcnde1, dd_real *rcdein, dd_real *scale, dd_real *scale1, dd_real *result, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Cget24(bool const comp, mplapackint const jtype, dd_real const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *h, dd_complex *ht, dd_complex *w, dd_complex *wt, dd_complex *wtmp, dd_complex *vs, mplapackint const ldvs, dd_complex *vs1, dd_real const rcdein, dd_real const rcdvin, mplapackint const nslct, mplapackint *islct, mplapackint const isrt, dd_real *result, dd_complex *work, mplapackint const lwork, dd_real *rwork, bool *bwork, mplapackint &info);
void Cget35(dd_real &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget36(dd_real &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget37(dd_real *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget38(dd_real *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget51(mplapackint const itype, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *u, mplapackint const ldu, dd_complex *v, mplapackint const ldv, dd_complex *work, dd_real *rwork, dd_real &result);
void Cget52(bool const left, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *e, mplapackint const lde, dd_complex *alpha, dd_complex *beta, dd_complex *work, dd_real *rwork, dd_real *result);
void Cget54(mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *s, mplapackint const lds, dd_complex *t, mplapackint const ldt, dd_complex *u, mplapackint const ldu, dd_complex *v, mplapackint const ldv, dd_complex *work, dd_real &result);
void Cglmts(mplapackint const n, mplapackint const m, mplapackint const p, dd_complex *a, dd_complex *af, mplapackint const lda, dd_complex *b, dd_complex *bf, mplapackint const ldb, dd_complex *d, dd_complex *df, dd_complex *x, dd_complex *u, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real &result);
void Cgqrts(mplapackint const n, mplapackint const m, mplapackint const p, dd_complex *a, dd_complex *af, dd_complex *q, dd_complex *r, mplapackint const lda, dd_complex *taua, dd_complex *b, dd_complex *bf, dd_complex *z, dd_complex *t, dd_complex *bwk, mplapackint const ldb, dd_complex *taub, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result);
void Cgrqts(mplapackint const m, mplapackint const p, mplapackint const n, dd_complex *a, dd_complex *af, dd_complex *q, dd_complex *r, mplapackint const lda, dd_complex *taua, dd_complex *b, dd_complex *bf, dd_complex *z, dd_complex *t, dd_complex *bwk, mplapackint const ldb, dd_complex *taub, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result);
void Cgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, dd_complex *a, dd_complex *af, mplapackint const lda, dd_complex *b, dd_complex *bf, mplapackint const ldb, dd_complex *u, mplapackint const ldu, dd_complex *v, mplapackint const ldv, dd_complex *q, mplapackint const ldq, dd_real *alpha, dd_real *beta, dd_complex *r, mplapackint const ldr, mplapackint *iwork, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result);
void Chbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, dd_complex *a, mplapackint const lda, dd_real *d, dd_real *e, dd_complex *u, mplapackint const ldu, dd_complex *work, dd_real *rwork, dd_real *result);
void Chet21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, dd_complex *a, mplapackint const lda, dd_real *d, dd_real *e, dd_complex *u, mplapackint const ldu, dd_complex *v, mplapackint const ldv, dd_complex *tau, dd_complex *work, dd_real *rwork, dd_real *result);
void Chet22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, dd_complex *a, mplapackint const lda, dd_real *d, dd_real *e, dd_complex *u, mplapackint const ldu, dd_complex *, mplapackint const ldv, dd_complex *, dd_complex *work, dd_real *rwork, dd_real *result);
void Chpt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, dd_complex *ap, dd_real *d, dd_real *e, dd_complex *u, mplapackint const ldu, dd_complex *vp, dd_complex *tau, dd_complex *work, dd_real *rwork, dd_real *result);
void Chst01(mplapackint const n, mplapackint const, mplapackint const, dd_complex *a, mplapackint const lda, dd_complex *h, mplapackint const ldh, dd_complex *q, mplapackint const ldq, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result);
void Clacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, dd_real *theta, mplapackint *iseed, dd_complex *x, mplapackint const &ldx, dd_complex *work);
void Clarfy(const char *uplo, mplapackint const n, dd_complex *v, mplapackint const incv, dd_complex const tau, dd_complex *c, mplapackint const ldc, dd_complex *work);
void Clarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *x, mplapackint const ldx, dd_complex *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Clatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, bool const rsign, dd_real const amagn, dd_real const rcond, dd_real const triang, mplapackint const idist, mplapackint *iseed, dd_complex *a, mplapackint const lda);
void Clsets(mplapackint const m, mplapackint const p, mplapackint const n, dd_complex *a, dd_complex *af, mplapackint const lda, dd_complex *b, dd_complex *bf, mplapackint const ldb, dd_complex *c, dd_complex *cf, dd_complex *d, dd_complex *df, dd_complex *x, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real *result);
void Csbmv(const char *uplo, mplapackint const n, mplapackint const k, dd_complex const alpha, dd_complex *a, mplapackint const lda, dd_complex *x, mplapackint const incx, dd_complex const beta, dd_complex *y, mplapackint const incy);
void Csgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *z, mplapackint const ldz, dd_real *d, dd_complex *work, dd_real *rwork, dd_real *result);
void Cstt21(mplapackint const n, mplapackint const kband, dd_real *ad, dd_real *ae, dd_real *sd, dd_real *se, dd_complex *u, mplapackint const ldu, dd_complex *work, dd_real *rwork, dd_real *result);
void Cstt22(mplapackint const n, mplapackint const m, mplapackint const kband, dd_real *ad, dd_real *ae, dd_real *sd, dd_real *se, dd_complex *u, mplapackint const ldu, dd_complex *work, mplapackint const ldwork, dd_real *rwork, dd_real *result);
void Cunt01(const char *rowcol, mplapackint const m, mplapackint const n, dd_complex *u, mplapackint const ldu, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real &resid);
void Cunt03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, dd_complex *u, mplapackint const ldu, dd_complex *v, mplapackint const ldv, dd_complex *work, mplapackint const lwork, dd_real *rwork, dd_real &result, mplapackint &info);
void Mxerbla_dd(const char *srname, int info);
void Rbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, dd_real *a, mplapackint const lda, dd_real *q, mplapackint const ldq, dd_real *d, dd_real *e, dd_real *pt, mplapackint const ldpt, dd_real *work, dd_real &resid);
void Rbdt02(mplapackint const m, mplapackint const n, dd_real *b, mplapackint const ldb, dd_real *c, mplapackint const ldc, dd_real *u, mplapackint const ldu, dd_real *work, dd_real &resid);
void Rbdt03(const char *uplo, mplapackint const n, mplapackint const kd, dd_real *d, dd_real *e, dd_real *u, mplapackint const ldu, dd_real *s, dd_real *vt, mplapackint const ldvt, dd_real *work, dd_real &resid);
void Rbdt04(const char *uplo, mplapackint const n, dd_real *d, dd_real *e, dd_real *s, mplapackint const ns, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint const ldvt, dd_real *work, dd_real &resid);
void Rbdt05(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *s, mplapackint const ns, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint const ldvt, dd_real *work, dd_real &resid);
void Rchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *ab, mplapackint const ldab, dd_real *bd, dd_real *be, dd_real *q, mplapackint const ldq, dd_real *p, mplapackint const ldp, dd_real *c, mplapackint const ldc, dd_real *cc, dd_real *work, mplapackint const lwork, dd_real *result, mplapackint &info);
void Rchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, dd_real const thresh, dd_real *a, mplapackint const lda, dd_real *bd, dd_real *be, dd_real *s1, dd_real *s2, dd_real *x, mplapackint const ldx, dd_real *y, dd_real *z, dd_real *q, mplapackint const ldq, dd_real *pt, mplapackint const ldpt, dd_real *u, dd_real *vt, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rchkbk(mplapackint const nin, mplapackint const nout);
void Rchkbl(mplapackint const nin, mplapackint const nout);
void Rchkec(dd_real const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Rchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, bool const tstdif, dd_real const thrshn, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *b, dd_real *h, dd_real *t, dd_real *s1, dd_real *s2, dd_real *p1, dd_real *p2, dd_real *u, mplapackint const ldu, dd_real *v, dd_real *q, dd_real *z, dd_real *alphr1, dd_real *alphi1, dd_real *beta1, dd_real *alphr3, dd_real *alphi3, dd_real *beta3, dd_real *evectl, dd_real *evectr, dd_real *work, mplapackint const lwork, bool *llwork, dd_real *result, mplapackint &info);
void Rchkgk(mplapackint const nin, mplapackint const nout);
void Rchkgl(mplapackint const nin, mplapackint const nout);
void Rchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *h, dd_real *t1, dd_real *t2, dd_real *u, mplapackint const ldu, dd_real *z, dd_real *uz, dd_real *wr1, dd_real *wi1, dd_real *wr2, dd_real *wi2, dd_real *wr3, dd_real *wi3, dd_real *evectl, dd_real *evectr, dd_real *evecty, dd_real *evectx, dd_real *uu, dd_real *tau, dd_real *work, mplapackint const nwork, mplapackint *iwork, bool *select, dd_real *result, mplapackint &info);
void Rchksb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *sd, dd_real *se, dd_real *u, mplapackint const ldu, dd_real *work, mplapackint const lwork, dd_real *result, mplapackint &info);
void Rchksb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *sd, dd_real *se, dd_real *d1, dd_real *d2, dd_real *d3, dd_real *u, mplapackint const ldu, dd_real *work, mplapackint const lwork, dd_real *result, mplapackint &info);
void Rchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *ap, dd_real *sd, dd_real *se, dd_real *d1, dd_real *d2, dd_real *d3, dd_real *d4, dd_real *d5, dd_real *wa1, dd_real *wa2, dd_real *wa3, dd_real *wr, dd_real *u, mplapackint const ldu, dd_real *v, dd_real *vp, dd_real *tau, dd_real *z, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, mplapackint &info);
void Rchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *ap, dd_real *sd, dd_real *se, dd_real *d1, dd_real *d2, dd_real *d3, dd_real *d4, dd_real *d5, dd_real *wa1, dd_real *wa2, dd_real *wa3, dd_real *wr, dd_real *u, mplapackint const ldu, dd_real *v, dd_real *vp, dd_real *tau, dd_real *z, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, mplapackint &info);
void Rckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, dd_real const thresh, mplapackint const mmax, dd_real *x, dd_real *xf, dd_real *u1, dd_real *u2, dd_real *v1t, dd_real *v2t, dd_real *theta, mplapackint *iwork, dd_real *work, dd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckglm(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, dd_real const thresh, mplapackint const nmax, dd_real *a, dd_real *af, dd_real *b, dd_real *bf, dd_real *x, dd_real *work, dd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, dd_real const thresh, mplapackint const nmax, dd_real *a, dd_real *af, dd_real *aq, dd_real *ar, dd_real *taua, dd_real *b, dd_real *bf, dd_real *bz, dd_real *bt, dd_real *bwk, dd_real *taub, dd_real *work, dd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, dd_real const thresh, mplapackint const nmax, dd_real *a, dd_real *af, dd_real *b, dd_real *bf, dd_real *u, dd_real *v, dd_real *q, dd_real *alpha, dd_real *beta, dd_real *r, mplapackint *iwork, dd_real *work, dd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, dd_real const thresh, mplapackint const nmax, dd_real *a, dd_real *af, dd_real *b, dd_real *bf, dd_real *x, dd_real *work, dd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcsdts(mplapackint const m, mplapackint const p, mplapackint const q, dd_real *x, dd_real *xf, mplapackint const ldx, dd_real *u1, mplapackint const ldu1, dd_real *u2, mplapackint const ldu2, dd_real *v1t, mplapackint const ldv1t, dd_real *v2t, mplapackint const ldv2t, dd_real *theta, mplapackint *iwork, dd_real *work, mplapackint const lwork, dd_real *rwork, dd_real *result);
void Rdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *b, dd_real *s, dd_real *t, dd_real *q, mplapackint const ldq, dd_real *z, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *work, mplapackint const lwork, dd_real *result, bool *bwork, mplapackint &info);
void Rdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *b, dd_real *s, dd_real *t, dd_real *q, mplapackint const ldq, dd_real *z, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *work, mplapackint const lwork, dd_real *result, bool *bwork, mplapackint &info);
void Rdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *b, dd_real *s, dd_real *t, dd_real *q, mplapackint const ldq, dd_real *z, dd_real *qe, mplapackint const ldqe, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *alphr1, dd_real *alphi1, dd_real *beta1, dd_real *work, mplapackint const lwork, dd_real *result, mplapackint &info);
void Rdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *b, dd_real *s, dd_real *t, dd_real *q, mplapackint const ldq, dd_real *z, dd_real *qe, mplapackint const ldqe, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *alphr1, dd_real *alphi1, dd_real *beta1, dd_real *work, mplapackint const lwork, dd_real *result, mplapackint &info);
void Rdrgsx(mplapackint const nsize, mplapackint const ncmax, dd_real const thresh, mplapackint const nin, mplapackint const nout, dd_real *a, mplapackint const lda, dd_real *b, dd_real *ai, dd_real *bi, dd_real *z, dd_real *q, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *c, mplapackint const ldc, dd_real *s, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rdrgvx(mplapackint const nsize, dd_real const thresh, mplapackint const nin, mplapackint const nout, dd_real *a, mplapackint const lda, dd_real *b, dd_real *ai, dd_real *bi, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *vl, dd_real *vr, mplapackint const ilo, mplapackint const ihi, dd_real *lscale, dd_real *rscale, dd_real *s, dd_real *dtru, dd_real *dif, dd_real *diftru, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, bool *bwork, mplapackint &info);
void Rdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, dd_real *a, mplapackint const lda, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint const ldvt, dd_real *asav, dd_real *usav, dd_real *vtsav, dd_real *s, dd_real *ssav, dd_real *e, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *h, dd_real *ht, dd_real *wr, dd_real *wi, dd_real *wrt, dd_real *wit, dd_real *vs, mplapackint const ldvs, dd_real *result, dd_real *work, mplapackint const nwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *h, dd_real *wr, dd_real *wi, dd_real *wr1, dd_real *wi1, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, dd_real *lre, mplapackint const ldlre, dd_real *result, dd_real *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *d, dd_real *z, mplapackint const ldz, dd_real *ab, dd_real *bb, dd_real *ap, dd_real *bp, dd_real *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, mplapackint &info);
void Rdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *d, dd_real *d2, dd_real *z, mplapackint const ldz, dd_real *ab, dd_real *bb, dd_real *ap, dd_real *bp, dd_real *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, mplapackint &info);
void Rdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *d1, dd_real *d2, dd_real *d3, dd_real *d4, dd_real *eveigs, dd_real *wa1, dd_real *wa2, dd_real *wa3, dd_real *u, mplapackint const ldu, dd_real *v, dd_real *tau, dd_real *z, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, mplapackint &info);
void Rdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *d1, dd_real *d2, dd_real *d3, dd_real *d4, dd_real *eveigs, dd_real *wa1, dd_real *wa2, dd_real *wa3, dd_real *u, mplapackint const ldu, dd_real *v, dd_real *tau, dd_real *z, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, dd_real *result, mplapackint &info);
void Rdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const niunit, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *h, dd_real *ht, dd_real *wr, dd_real *wi, dd_real *wrt, dd_real *wit, dd_real *wrtmp, dd_real *witmp, dd_real *vs, mplapackint const ldvs, dd_real *vs1, dd_real *result, dd_real *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, dd_real const thresh, mplapackint const niunit, mplapackint const nounit, dd_real *a, mplapackint const lda, dd_real *h, dd_real *wr, dd_real *wi, dd_real *wr1, dd_real *wi1, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, dd_real *lre, mplapackint const ldlre, dd_real *rcondv, dd_real *rcndv1, dd_real *rcdvin, dd_real *rconde, dd_real *rcnde1, dd_real *rcdein, dd_real *scale, dd_real *scale1, dd_real *result, dd_real *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rerrbd(const char *path, mplapackint const nunit);
void Rerrec(const char *path, mplapackint const nunit);
void Rerred(const char *path, mplapackint const nunit);
void Rerrgg(const char *path, mplapackint const nunit);
void Rerrhs(const char *path, mplapackint const nunit);
void Rerrst(const char *path, mplapackint const nunit);
void Rget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *x, mplapackint const ldx, dd_real *b, mplapackint const ldb, dd_real *rwork, dd_real &resid);
void Rget10(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *work, dd_real &result);
void Rget22(const char *transa, const char *transe, const char *transw, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *e, mplapackint const lde, dd_real *wr, dd_real *wi, dd_real *work, dd_real *result);
void Rget23(bool const comp, const char *balanc, mplapackint const jtype, dd_real const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *h, dd_real *wr, dd_real *wi, dd_real *wr1, dd_real *wi1, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, dd_real *lre, mplapackint const ldlre, dd_real *rcondv, dd_real *rcndv1, dd_real *rcdvin, dd_real *rconde, dd_real *rcnde1, dd_real *rcdein, dd_real *scale, dd_real *scale1, dd_real *result, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rget24(bool const comp, mplapackint const jtype, dd_real const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *h, dd_real *ht, dd_real *wr, dd_real *wi, dd_real *wrt, dd_real *wit, dd_real *wrtmp, dd_real *witmp, dd_real *vs, mplapackint const ldvs, dd_real *vs1, dd_real const rcdein, dd_real const rcdvin, mplapackint const nslct, mplapackint *islct, dd_real *result, dd_real *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rget31(dd_real &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget32(dd_real &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget33(dd_real &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget34(dd_real &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget35(dd_real &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget36(dd_real &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget37(dd_real *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget38(dd_real *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget39(dd_real &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget40(dd_real &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget51(mplapackint const itype, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *u, mplapackint const ldu, dd_real *v, mplapackint const ldv, dd_real *work, dd_real &result);
void Rget52(bool const left, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *e, mplapackint const lde, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *work, dd_real *result);
void Rget53(dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real const scale, dd_real const wr, dd_real const wi, dd_real &result, mplapackint &info);
void Rget54(mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *s, mplapackint const lds, dd_real *t, mplapackint const ldt, dd_real *u, mplapackint const ldu, dd_real *v, mplapackint const ldv, dd_real *work, dd_real &result);
void Rglmts(mplapackint const n, mplapackint const m, mplapackint const p, dd_real *a, dd_real *af, mplapackint const lda, dd_real *b, dd_real *bf, mplapackint const ldb, dd_real *d, dd_real *df, dd_real *x, dd_real *u, dd_real *work, mplapackint const lwork, dd_real *rwork, dd_real &result);
void Rgqrts(mplapackint const n, mplapackint const m, mplapackint const p, dd_real *a, dd_real *af, dd_real *q, dd_real *r, mplapackint const lda, dd_real *taua, dd_real *b, dd_real *bf, dd_real *z, dd_real *t, dd_real *bwk, mplapackint const ldb, dd_real *taub, dd_real *work, mplapackint const lwork, dd_real *rwork, dd_real *result);
void Rgrqts(mplapackint const m, mplapackint const p, mplapackint const n, dd_real *a, dd_real *af, dd_real *q, dd_real *r, mplapackint const lda, dd_real *taua, dd_real *b, dd_real *bf, dd_real *z, dd_real *t, dd_real *bwk, mplapackint const ldb, dd_real *taub, dd_real *work, mplapackint const lwork, dd_real *rwork, dd_real *result);
void Rgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, dd_real *a, dd_real *af, mplapackint const lda, dd_real *b, dd_real *bf, mplapackint const ldb, dd_real *u, mplapackint const ldu, dd_real *v, mplapackint const ldv, dd_real *q, mplapackint const ldq, dd_real *alpha, dd_real *beta, dd_real *r, mplapackint const ldr, mplapackint *iwork, dd_real *work, mplapackint const lwork, dd_real *rwork, dd_real *result);
void Rhst01(mplapackint const n, mplapackint const, mplapackint const, dd_real *a, mplapackint const lda, dd_real *h, mplapackint const ldh, dd_real *q, mplapackint const ldq, dd_real *work, mplapackint const lwork, dd_real *result);
void Rlacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, dd_real *theta, mplapackint *iseed, dd_real *x, mplapackint const &ldx, dd_real *work);
void Rlafts(const char *type, mplapackint const m, mplapackint const n, mplapackint const imat, mplapackint const ntests, dd_real *result, mplapackint *iseed, dd_real const thresh, mplapackint const iounit, mplapackint &ie);
void Rlahd2(mplapackint const iounit, const char *path);
void Rlarfy(const char *uplo, mplapackint const n, dd_real *v, mplapackint const incv, dd_real const tau, dd_real *c, mplapackint const ldc, dd_real *work);
void Rlarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *x, mplapackint const ldx, dd_real *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Rlasum(const char *type, mplapackint const iounit, mplapackint const ie, mplapackint const nrun);
void Rlatb9(const char *path, mplapackint const imat, mplapackint const m, mplapackint const p, mplapackint const n, char *type, mplapackint &kla, mplapackint &kua, mplapackint &klb, mplapackint &kub, dd_real &anorm, dd_real &bnorm, mplapackint &modea, mplapackint &modeb, dd_real &cndnma, dd_real &cndnmb, char *dista, char *distb);
void Rlatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, mplapackint const isign, dd_real const amagn, dd_real const rcond, dd_real const triang, mplapackint const idist, mplapackint *iseed, dd_real *a, mplapackint const lda);
void Rlsets(mplapackint const m, mplapackint const p, mplapackint const n, dd_real *a, dd_real *af, mplapackint const lda, dd_real *b, dd_real *bf, mplapackint const ldb, dd_real *c, dd_real *cf, dd_real *d, dd_real *df, dd_real *x, dd_real *work, mplapackint const lwork, dd_real *rwork, dd_real *result);
void Rort01(const char *rowcol, mplapackint const m, mplapackint const n, dd_real *u, mplapackint const ldu, dd_real *work, mplapackint const lwork, dd_real &resid);
void Rort03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, dd_real *u, mplapackint const ldu, dd_real *v, mplapackint const ldv, dd_real *work, mplapackint const lwork, dd_real &result, mplapackint &info);
void Rsbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, dd_real *a, mplapackint const lda, dd_real *d, dd_real *e, dd_real *u, mplapackint const ldu, dd_real *work, dd_real *result);
void Rsgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *z, mplapackint const ldz, dd_real *d, dd_real *work, dd_real *result);
void Rspt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, dd_real *ap, dd_real *d, dd_real *e, dd_real *u, mplapackint const ldu, dd_real *vp, dd_real *tau, dd_real *work, dd_real *result);
void Rstech(mplapackint const n, dd_real *a, dd_real *b, dd_real *eig, dd_real const tol, dd_real *work, mplapackint &info);
void Rstect(mplapackint const n, dd_real *a, dd_real *b, dd_real const shift, mplapackint &num);
void Rstt21(mplapackint const n, mplapackint const kband, dd_real *ad, dd_real *ae, dd_real *sd, dd_real *se, dd_real *u, mplapackint const ldu, dd_real *work, dd_real *result);
void Rstt22(mplapackint const n, mplapackint const m, mplapackint const kband, dd_real *ad, dd_real *ae, dd_real *sd, dd_real *se, dd_real *u, mplapackint const ldu, dd_real *work, mplapackint const ldwork, dd_real *result);
void Rsvdch(mplapackint const n, dd_real *s, dd_real *e, dd_real *svd, dd_real const tol, mplapackint &info);
void Rsvdct(mplapackint const n, dd_real *s, dd_real *e, dd_real const shift, mplapackint &num);
void Rsyt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, dd_real *a, mplapackint const lda, dd_real *d, dd_real *e, dd_real *u, mplapackint const ldu, dd_real *v, mplapackint const ldv, dd_real *tau, dd_real *work, dd_real *result);
void Rsyt22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, dd_real *a, mplapackint const lda, dd_real *d, dd_real *e, dd_real *u, mplapackint const ldu, dd_real *, mplapackint const ldv, dd_real *, dd_real *work, dd_real *result);
void chkxer(const char *srnamt, mplapackint const &infot, mplapackint const &nout, bool &lerr, bool &ok);
void xlaenv(mplapackint const &ispec, mplapackint const &nvalue);
#endif
