/*
 * Copyright (c) 2021-2022
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_EIG__FLOAT128_H_
#define _MPLAPACK_EIG__FLOAT128_H_

#include "mplapack_config.h"

_Float128 Rlamch__Float128(const char *cmach);
_Float128 Rsxt1(mplapackint const ijob, _Float128 *d1, mplapackint const n1, _Float128 *d2, mplapackint const n2, _Float128 const abstol, _Float128 const ulp, _Float128 const unfl);
bool Clctes(std::complex<_Float128> const z, std::complex<_Float128> const d);
bool Clctsx(std::complex<_Float128> const, std::complex<_Float128> const);
bool Cslect(std::complex<_Float128> const z);
bool Rlctes(_Float128 const zr, _Float128 const zi, _Float128 const d);
bool Rlctsx(_Float128 const, _Float128 const, _Float128 const);
bool Rslect(_Float128 const zr, _Float128 const zi);
mplapackint iMlaenv2stage__Float128(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv__Float128(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
void Alahdg(mplapackint const iounit, const char *path);
void Alareq(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alarqg(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alasmg(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasum(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasvm(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Cbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *q, mplapackint const ldq, _Float128 *d, _Float128 *e, std::complex<_Float128> *pt, mplapackint const ldpt, std::complex<_Float128> *work, _Float128 *rwork, _Float128 &resid);
void Cbdt02(mplapackint const m, mplapackint const n, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *work, _Float128 *rwork, _Float128 &resid);
void Cbdt03(const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *d, _Float128 *e, std::complex<_Float128> *u, mplapackint const ldu, _Float128 *s, std::complex<_Float128> *vt, mplapackint const ldvt, std::complex<_Float128> *work, _Float128 &resid);
void Cbdt05(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *s, mplapackint const ns, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *vt, mplapackint const ldvt, std::complex<_Float128> *work, _Float128 &resid);
void Cchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *bd, _Float128 *be, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *p, mplapackint const ldp, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *cc, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result, mplapackint &info);
void Cchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, _Float128 const thresh, std::complex<_Float128> *a, mplapackint const lda, _Float128 *bd, _Float128 *be, _Float128 *s1, _Float128 *s2, std::complex<_Float128> *x, mplapackint const ldx, std::complex<_Float128> *y, std::complex<_Float128> *z, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *pt, mplapackint const ldpt, std::complex<_Float128> *u, std::complex<_Float128> *vt, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const nout, mplapackint &info);
void Cchkbk(mplapackint const nin, mplapackint const nout);
void Cchkbl(mplapackint const nin, mplapackint const nout);
void Cchkec(_Float128 const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Cchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, bool const tstdif, _Float128 const thrshn, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, std::complex<_Float128> *h, std::complex<_Float128> *t, std::complex<_Float128> *s1, std::complex<_Float128> *s2, std::complex<_Float128> *p1, std::complex<_Float128> *p2, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, std::complex<_Float128> *q, std::complex<_Float128> *z, std::complex<_Float128> *alpha1, std::complex<_Float128> *beta1, std::complex<_Float128> *alpha3, std::complex<_Float128> *beta3, std::complex<_Float128> *evectl, std::complex<_Float128> *evectr, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, bool *llwork, _Float128 *result, mplapackint &info);
void Cchkgk(mplapackint const nin, mplapackint const nout);
void Cchkgl(mplapackint const nin, mplapackint const nout);
void Cchkhb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, _Float128 *sd, _Float128 *se, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result, mplapackint &info);
void Cchkhb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, _Float128 *sd, _Float128 *se, _Float128 *d1, _Float128 *d2, _Float128 *d3, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result, mplapackint &info);
void Cchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *h, std::complex<_Float128> *t1, std::complex<_Float128> *t2, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *z, std::complex<_Float128> *uz, std::complex<_Float128> *w1, std::complex<_Float128> *w3, std::complex<_Float128> *evectl, std::complex<_Float128> *evectr, std::complex<_Float128> *evecty, std::complex<_Float128> *evectx, std::complex<_Float128> *uu, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const nwork, _Float128 *rwork, mplapackint *iwork, bool *select, _Float128 *result, mplapackint &info);
void Cchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *ap, _Float128 *sd, _Float128 *se, _Float128 *d1, _Float128 *d2, _Float128 *d3, _Float128 *d4, _Float128 *d5, _Float128 *wa1, _Float128 *wa2, _Float128 *wa3, _Float128 *wr, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, std::complex<_Float128> *vp, std::complex<_Float128> *tau, std::complex<_Float128> *z, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, mplapackint &info);
void Cchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *ap, _Float128 *sd, _Float128 *se, _Float128 *d1, _Float128 *d2, _Float128 *d3, _Float128 *d4, _Float128 *d5, _Float128 *wa1, _Float128 *wa2, _Float128 *wa3, _Float128 *wr, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, std::complex<_Float128> *vp, std::complex<_Float128> *tau, std::complex<_Float128> *z, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, mplapackint &info);
void Cckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, _Float128 const thresh, mplapackint const mmax, std::complex<_Float128> *x, std::complex<_Float128> *xf, std::complex<_Float128> *u1, std::complex<_Float128> *u2, std::complex<_Float128> *v1t, std::complex<_Float128> *v2t, _Float128 *theta, mplapackint *iwork, std::complex<_Float128> *work, _Float128 *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckglm(mplapackint const nn, mplapackint *nval, mplapackint *mval, mplapackint *pval, mplapackint const nmats, mplapackint *iseed, _Float128 const thresh, mplapackint const nmax, std::complex<_Float128> *a, std::complex<_Float128> *af, std::complex<_Float128> *b, std::complex<_Float128> *bf, std::complex<_Float128> *x, std::complex<_Float128> *work, _Float128 *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float128 const thresh, mplapackint const nmax, std::complex<_Float128> *a, std::complex<_Float128> *af, std::complex<_Float128> *aq, std::complex<_Float128> *ar, std::complex<_Float128> *taua, std::complex<_Float128> *b, std::complex<_Float128> *bf, std::complex<_Float128> *bz, std::complex<_Float128> *bt, std::complex<_Float128> *bwk, std::complex<_Float128> *taub, std::complex<_Float128> *work, _Float128 *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float128 const thresh, mplapackint const nmax, std::complex<_Float128> *a, std::complex<_Float128> *af, std::complex<_Float128> *b, std::complex<_Float128> *bf, std::complex<_Float128> *u, std::complex<_Float128> *v, std::complex<_Float128> *q, _Float128 *alpha, _Float128 *beta, std::complex<_Float128> *r, mplapackint *iwork, std::complex<_Float128> *work, _Float128 *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float128 const thresh, mplapackint const nmax, std::complex<_Float128> *a, std::complex<_Float128> *af, std::complex<_Float128> *b, std::complex<_Float128> *bf, std::complex<_Float128> *x, std::complex<_Float128> *work, _Float128 *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccsdts(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float128> *x, std::complex<_Float128> *xf, mplapackint const ldx, std::complex<_Float128> *u1, mplapackint const ldu1, std::complex<_Float128> *u2, mplapackint const ldu2, std::complex<_Float128> *v1t, mplapackint const ldv1t, std::complex<_Float128> *v2t, mplapackint const ldv2t, _Float128 *theta, mplapackint *iwork, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result);
void Cdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, std::complex<_Float128> *s, std::complex<_Float128> *t, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *z, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result, bool *bwork, mplapackint &info);
void Cdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, std::complex<_Float128> *s, std::complex<_Float128> *t, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *z, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result, bool *bwork, mplapackint &info);
void Cdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, std::complex<_Float128> *s, std::complex<_Float128> *t, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *z, std::complex<_Float128> *qe, mplapackint const ldqe, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *alpha1, std::complex<_Float128> *beta1, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result, mplapackint &info);
void Cdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, std::complex<_Float128> *s, std::complex<_Float128> *t, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *z, std::complex<_Float128> *qe, mplapackint const ldqe, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *alpha1, std::complex<_Float128> *beta1, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result, mplapackint &info);
void Cdrgsx(mplapackint const nsize, mplapackint const ncmax, _Float128 const thresh, mplapackint const nin, mplapackint const nout, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, std::complex<_Float128> *ai, std::complex<_Float128> *bi, std::complex<_Float128> *z, std::complex<_Float128> *q, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *c, mplapackint const ldc, _Float128 *s, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cdrgvx(mplapackint const nsize, _Float128 const thresh, mplapackint const nin, mplapackint const nout, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, std::complex<_Float128> *ai, std::complex<_Float128> *bi, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *vl, std::complex<_Float128> *vr, mplapackint &ilo, mplapackint &ihi, _Float128 *lscale, _Float128 *rscale, _Float128 *s, _Float128 *dtru, _Float128 *dif, _Float128 *diftru, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, bool *bwork, mplapackint &info);
void Cdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *vt, mplapackint const ldvt, std::complex<_Float128> *asav, std::complex<_Float128> *usav, std::complex<_Float128> *vtsav, _Float128 *s, _Float128 *ssav, _Float128 *e, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, mplapackint const nounit, mplapackint &info);
void Cdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *h, std::complex<_Float128> *ht, std::complex<_Float128> *w, std::complex<_Float128> *wt, std::complex<_Float128> *vs, mplapackint const ldvs, _Float128 *result, std::complex<_Float128> *work, mplapackint const nwork, _Float128 *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *h, std::complex<_Float128> *w, std::complex<_Float128> *w1, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, std::complex<_Float128> *lre, mplapackint const ldlre, _Float128 *result, std::complex<_Float128> *work, mplapackint const nwork, _Float128 *rwork, mplapackint *iwork, mplapackint &info);
void Cdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, _Float128 *d, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *ab, std::complex<_Float128> *bb, std::complex<_Float128> *ap, std::complex<_Float128> *bp, std::complex<_Float128> *work, mplapackint const nwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, mplapackint &info);
void Cdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, _Float128 *d, _Float128 *d2, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *ab, std::complex<_Float128> *bb, std::complex<_Float128> *ap, std::complex<_Float128> *bp, std::complex<_Float128> *work, mplapackint const nwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, mplapackint &info);
void Cdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, _Float128 *d1, _Float128 *d2, _Float128 *d3, _Float128 *wa1, _Float128 *wa2, _Float128 *wa3, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, std::complex<_Float128> *tau, std::complex<_Float128> *z, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, mplapackint &info);
void Cdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, _Float128 *d1, _Float128 *d2, _Float128 *d3, _Float128 *wa1, _Float128 *wa2, _Float128 *wa3, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, std::complex<_Float128> *tau, std::complex<_Float128> *z, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, mplapackint &info);
void Cdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const niunit, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *h, std::complex<_Float128> *ht, std::complex<_Float128> *w, std::complex<_Float128> *wt, std::complex<_Float128> *wtmp, std::complex<_Float128> *vs, mplapackint const ldvs, std::complex<_Float128> *vs1, _Float128 *result, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, bool *bwork, mplapackint &info);
void Cdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const niunit, mplapackint const nounit, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *h, std::complex<_Float128> *w, std::complex<_Float128> *w1, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, std::complex<_Float128> *lre, mplapackint const ldlre, _Float128 *rcondv, _Float128 *rcndv1, _Float128 *rcdvin, _Float128 *rconde, _Float128 *rcnde1, _Float128 *rcdein, _Float128 *scale, _Float128 *scale1, _Float128 *result, std::complex<_Float128> *work, mplapackint const nwork, _Float128 *rwork, mplapackint &info);
void Cerrbd(const char *path, mplapackint const nunit);
void Cerrec(const char *path, mplapackint const nunit);
void Cerred(const char *path, mplapackint const nunit);
void Cerrgg(const char *path, mplapackint const nunit);
void Cerrhs(const char *path, mplapackint const nunit);
void Cerrst(const char *path, mplapackint const nunit);
void Cget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *x, mplapackint const ldx, std::complex<_Float128> *b, mplapackint const ldb, _Float128 *rwork, _Float128 &resid);
void Cget10(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, _Float128 *rwork, _Float128 &result);
void Cget22(const char *transa, const char *transe, const char *transw, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint const lde, std::complex<_Float128> *w, std::complex<_Float128> *work, _Float128 *rwork, _Float128 *result);
void Cget23(bool const comp, mplapackint const isrt, const char *balanc, mplapackint const jtype, _Float128 const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *h, std::complex<_Float128> *w, std::complex<_Float128> *w1, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, std::complex<_Float128> *lre, mplapackint const ldlre, _Float128 *rcondv, _Float128 *rcndv1, _Float128 *rcdvin, _Float128 *rconde, _Float128 *rcnde1, _Float128 *rcdein, _Float128 *scale, _Float128 *scale1, _Float128 *result, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Cget24(bool const comp, mplapackint const jtype, _Float128 const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *h, std::complex<_Float128> *ht, std::complex<_Float128> *w, std::complex<_Float128> *wt, std::complex<_Float128> *wtmp, std::complex<_Float128> *vs, mplapackint const ldvs, std::complex<_Float128> *vs1, _Float128 const rcdein, _Float128 const rcdvin, mplapackint const nslct, mplapackint *islct, mplapackint const isrt, _Float128 *result, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, bool *bwork, mplapackint &info);
void Cget35(_Float128 &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget36(_Float128 &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget37(_Float128 *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget38(_Float128 *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget51(mplapackint const itype, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *work, _Float128 *rwork, _Float128 &result);
void Cget52(bool const left, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *e, mplapackint const lde, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *work, _Float128 *rwork, _Float128 *result);
void Cget54(mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *s, mplapackint const lds, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *work, _Float128 &result);
void Cglmts(mplapackint const n, mplapackint const m, mplapackint const p, std::complex<_Float128> *a, std::complex<_Float128> *af, mplapackint const lda, std::complex<_Float128> *b, std::complex<_Float128> *bf, mplapackint const ldb, std::complex<_Float128> *d, std::complex<_Float128> *df, std::complex<_Float128> *x, std::complex<_Float128> *u, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 &result);
void Cgqrts(mplapackint const n, mplapackint const m, mplapackint const p, std::complex<_Float128> *a, std::complex<_Float128> *af, std::complex<_Float128> *q, std::complex<_Float128> *r, mplapackint const lda, std::complex<_Float128> *taua, std::complex<_Float128> *b, std::complex<_Float128> *bf, std::complex<_Float128> *z, std::complex<_Float128> *t, std::complex<_Float128> *bwk, mplapackint const ldb, std::complex<_Float128> *taub, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result);
void Cgrqts(mplapackint const m, mplapackint const p, mplapackint const n, std::complex<_Float128> *a, std::complex<_Float128> *af, std::complex<_Float128> *q, std::complex<_Float128> *r, mplapackint const lda, std::complex<_Float128> *taua, std::complex<_Float128> *b, std::complex<_Float128> *bf, std::complex<_Float128> *z, std::complex<_Float128> *t, std::complex<_Float128> *bwk, mplapackint const ldb, std::complex<_Float128> *taub, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result);
void Cgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, std::complex<_Float128> *a, std::complex<_Float128> *af, mplapackint const lda, std::complex<_Float128> *b, std::complex<_Float128> *bf, mplapackint const ldb, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *q, mplapackint const ldq, _Float128 *alpha, _Float128 *beta, std::complex<_Float128> *r, mplapackint const ldr, mplapackint *iwork, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result);
void Chbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, std::complex<_Float128> *a, mplapackint const lda, _Float128 *d, _Float128 *e, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *work, _Float128 *rwork, _Float128 *result);
void Chet21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, std::complex<_Float128> *a, mplapackint const lda, _Float128 *d, _Float128 *e, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *tau, std::complex<_Float128> *work, _Float128 *rwork, _Float128 *result);
void Chet22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, std::complex<_Float128> *a, mplapackint const lda, _Float128 *d, _Float128 *e, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *, mplapackint const ldv, std::complex<_Float128> *, std::complex<_Float128> *work, _Float128 *rwork, _Float128 *result);
void Chpt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, std::complex<_Float128> *ap, _Float128 *d, _Float128 *e, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *vp, std::complex<_Float128> *tau, std::complex<_Float128> *work, _Float128 *rwork, _Float128 *result);
void Chst01(mplapackint const n, mplapackint const, mplapackint const, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *h, mplapackint const ldh, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result);
void Clacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, _Float128 *theta, mplapackint *iseed, std::complex<_Float128> *x, mplapackint const &ldx, std::complex<_Float128> *work);
void Clarfy(const char *uplo, mplapackint const n, std::complex<_Float128> *v, mplapackint const incv, std::complex<_Float128> const tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work);
void Clarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *x, mplapackint const ldx, std::complex<_Float128> *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Clatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, bool const rsign, _Float128 const amagn, _Float128 const rcond, _Float128 const triang, mplapackint const idist, mplapackint *iseed, std::complex<_Float128> *a, mplapackint const lda);
void Clsets(mplapackint const m, mplapackint const p, mplapackint const n, std::complex<_Float128> *a, std::complex<_Float128> *af, mplapackint const lda, std::complex<_Float128> *b, std::complex<_Float128> *bf, mplapackint const ldb, std::complex<_Float128> *c, std::complex<_Float128> *cf, std::complex<_Float128> *d, std::complex<_Float128> *df, std::complex<_Float128> *x, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result);
void Csbmv(const char *uplo, mplapackint const n, mplapackint const k, std::complex<_Float128> const alpha, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *x, mplapackint const incx, std::complex<_Float128> const beta, std::complex<_Float128> *y, mplapackint const incy);
void Csgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *z, mplapackint const ldz, _Float128 *d, std::complex<_Float128> *work, _Float128 *rwork, _Float128 *result);
void Cstt21(mplapackint const n, mplapackint const kband, _Float128 *ad, _Float128 *ae, _Float128 *sd, _Float128 *se, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *work, _Float128 *rwork, _Float128 *result);
void Cstt22(mplapackint const n, mplapackint const m, mplapackint const kband, _Float128 *ad, _Float128 *ae, _Float128 *sd, _Float128 *se, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *work, mplapackint const ldwork, _Float128 *rwork, _Float128 *result);
void Cunt01(const char *rowcol, mplapackint const m, mplapackint const n, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 &resid);
void Cunt03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, _Float128 &result, mplapackint &info);
void Mxerbla__Float128(const char *srname, int info);
void Rbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, _Float128 *a, mplapackint const lda, _Float128 *q, mplapackint const ldq, _Float128 *d, _Float128 *e, _Float128 *pt, mplapackint const ldpt, _Float128 *work, _Float128 &resid);
void Rbdt02(mplapackint const m, mplapackint const n, _Float128 *b, mplapackint const ldb, _Float128 *c, mplapackint const ldc, _Float128 *u, mplapackint const ldu, _Float128 *work, _Float128 &resid);
void Rbdt03(const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *d, _Float128 *e, _Float128 *u, mplapackint const ldu, _Float128 *s, _Float128 *vt, mplapackint const ldvt, _Float128 *work, _Float128 &resid);
void Rbdt04(const char *uplo, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 *s, mplapackint const ns, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint const ldvt, _Float128 *work, _Float128 &resid);
void Rbdt05(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *s, mplapackint const ns, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint const ldvt, _Float128 *work, _Float128 &resid);
void Rchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *ab, mplapackint const ldab, _Float128 *bd, _Float128 *be, _Float128 *q, mplapackint const ldq, _Float128 *p, mplapackint const ldp, _Float128 *c, mplapackint const ldc, _Float128 *cc, _Float128 *work, mplapackint const lwork, _Float128 *result, mplapackint &info);
void Rchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, _Float128 const thresh, _Float128 *a, mplapackint const lda, _Float128 *bd, _Float128 *be, _Float128 *s1, _Float128 *s2, _Float128 *x, mplapackint const ldx, _Float128 *y, _Float128 *z, _Float128 *q, mplapackint const ldq, _Float128 *pt, mplapackint const ldpt, _Float128 *u, _Float128 *vt, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rchkbk(mplapackint const nin, mplapackint const nout);
void Rchkbl(mplapackint const nin, mplapackint const nout);
void Rchkec(_Float128 const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Rchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, bool const tstdif, _Float128 const thrshn, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *b, _Float128 *h, _Float128 *t, _Float128 *s1, _Float128 *s2, _Float128 *p1, _Float128 *p2, _Float128 *u, mplapackint const ldu, _Float128 *v, _Float128 *q, _Float128 *z, _Float128 *alphr1, _Float128 *alphi1, _Float128 *beta1, _Float128 *alphr3, _Float128 *alphi3, _Float128 *beta3, _Float128 *evectl, _Float128 *evectr, _Float128 *work, mplapackint const lwork, bool *llwork, _Float128 *result, mplapackint &info);
void Rchkgk(mplapackint const nin, mplapackint const nout);
void Rchkgl(mplapackint const nin, mplapackint const nout);
void Rchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *h, _Float128 *t1, _Float128 *t2, _Float128 *u, mplapackint const ldu, _Float128 *z, _Float128 *uz, _Float128 *wr1, _Float128 *wi1, _Float128 *wr2, _Float128 *wi2, _Float128 *wr3, _Float128 *wi3, _Float128 *evectl, _Float128 *evectr, _Float128 *evecty, _Float128 *evectx, _Float128 *uu, _Float128 *tau, _Float128 *work, mplapackint const nwork, mplapackint *iwork, bool *select, _Float128 *result, mplapackint &info);
void Rchksb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *sd, _Float128 *se, _Float128 *u, mplapackint const ldu, _Float128 *work, mplapackint const lwork, _Float128 *result, mplapackint &info);
void Rchksb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *sd, _Float128 *se, _Float128 *d1, _Float128 *d2, _Float128 *d3, _Float128 *u, mplapackint const ldu, _Float128 *work, mplapackint const lwork, _Float128 *result, mplapackint &info);
void Rchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *ap, _Float128 *sd, _Float128 *se, _Float128 *d1, _Float128 *d2, _Float128 *d3, _Float128 *d4, _Float128 *d5, _Float128 *wa1, _Float128 *wa2, _Float128 *wa3, _Float128 *wr, _Float128 *u, mplapackint const ldu, _Float128 *v, _Float128 *vp, _Float128 *tau, _Float128 *z, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, mplapackint &info);
void Rchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *ap, _Float128 *sd, _Float128 *se, _Float128 *d1, _Float128 *d2, _Float128 *d3, _Float128 *d4, _Float128 *d5, _Float128 *wa1, _Float128 *wa2, _Float128 *wa3, _Float128 *wr, _Float128 *u, mplapackint const ldu, _Float128 *v, _Float128 *vp, _Float128 *tau, _Float128 *z, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, mplapackint &info);
void Rckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, _Float128 const thresh, mplapackint const mmax, _Float128 *x, _Float128 *xf, _Float128 *u1, _Float128 *u2, _Float128 *v1t, _Float128 *v2t, _Float128 *theta, mplapackint *iwork, _Float128 *work, _Float128 *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckglm(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float128 const thresh, mplapackint const nmax, _Float128 *a, _Float128 *af, _Float128 *b, _Float128 *bf, _Float128 *x, _Float128 *work, _Float128 *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float128 const thresh, mplapackint const nmax, _Float128 *a, _Float128 *af, _Float128 *aq, _Float128 *ar, _Float128 *taua, _Float128 *b, _Float128 *bf, _Float128 *bz, _Float128 *bt, _Float128 *bwk, _Float128 *taub, _Float128 *work, _Float128 *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float128 const thresh, mplapackint const nmax, _Float128 *a, _Float128 *af, _Float128 *b, _Float128 *bf, _Float128 *u, _Float128 *v, _Float128 *q, _Float128 *alpha, _Float128 *beta, _Float128 *r, mplapackint *iwork, _Float128 *work, _Float128 *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float128 const thresh, mplapackint const nmax, _Float128 *a, _Float128 *af, _Float128 *b, _Float128 *bf, _Float128 *x, _Float128 *work, _Float128 *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcsdts(mplapackint const m, mplapackint const p, mplapackint const q, _Float128 *x, _Float128 *xf, mplapackint const ldx, _Float128 *u1, mplapackint const ldu1, _Float128 *u2, mplapackint const ldu2, _Float128 *v1t, mplapackint const ldv1t, _Float128 *v2t, mplapackint const ldv2t, _Float128 *theta, mplapackint *iwork, _Float128 *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result);
void Rdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *b, _Float128 *s, _Float128 *t, _Float128 *q, mplapackint const ldq, _Float128 *z, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *work, mplapackint const lwork, _Float128 *result, bool *bwork, mplapackint &info);
void Rdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *b, _Float128 *s, _Float128 *t, _Float128 *q, mplapackint const ldq, _Float128 *z, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *work, mplapackint const lwork, _Float128 *result, bool *bwork, mplapackint &info);
void Rdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *b, _Float128 *s, _Float128 *t, _Float128 *q, mplapackint const ldq, _Float128 *z, _Float128 *qe, mplapackint const ldqe, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *alphr1, _Float128 *alphi1, _Float128 *beta1, _Float128 *work, mplapackint const lwork, _Float128 *result, mplapackint &info);
void Rdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *b, _Float128 *s, _Float128 *t, _Float128 *q, mplapackint const ldq, _Float128 *z, _Float128 *qe, mplapackint const ldqe, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *alphr1, _Float128 *alphi1, _Float128 *beta1, _Float128 *work, mplapackint const lwork, _Float128 *result, mplapackint &info);
void Rdrgsx(mplapackint const nsize, mplapackint const ncmax, _Float128 const thresh, mplapackint const nin, mplapackint const nout, _Float128 *a, mplapackint const lda, _Float128 *b, _Float128 *ai, _Float128 *bi, _Float128 *z, _Float128 *q, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *c, mplapackint const ldc, _Float128 *s, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rdrgvx(mplapackint const nsize, _Float128 const thresh, mplapackint const nin, mplapackint const nout, _Float128 *a, mplapackint const lda, _Float128 *b, _Float128 *ai, _Float128 *bi, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *vl, _Float128 *vr, mplapackint const ilo, mplapackint const ihi, _Float128 *lscale, _Float128 *rscale, _Float128 *s, _Float128 *dtru, _Float128 *dif, _Float128 *diftru, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, bool *bwork, mplapackint &info);
void Rdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, _Float128 *a, mplapackint const lda, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint const ldvt, _Float128 *asav, _Float128 *usav, _Float128 *vtsav, _Float128 *s, _Float128 *ssav, _Float128 *e, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *h, _Float128 *ht, _Float128 *wr, _Float128 *wi, _Float128 *wrt, _Float128 *wit, _Float128 *vs, mplapackint const ldvs, _Float128 *result, _Float128 *work, mplapackint const nwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *h, _Float128 *wr, _Float128 *wi, _Float128 *wr1, _Float128 *wi1, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, _Float128 *lre, mplapackint const ldlre, _Float128 *result, _Float128 *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *d, _Float128 *z, mplapackint const ldz, _Float128 *ab, _Float128 *bb, _Float128 *ap, _Float128 *bp, _Float128 *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, mplapackint &info);
void Rdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *d, _Float128 *d2, _Float128 *z, mplapackint const ldz, _Float128 *ab, _Float128 *bb, _Float128 *ap, _Float128 *bp, _Float128 *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, mplapackint &info);
void Rdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *d1, _Float128 *d2, _Float128 *d3, _Float128 *d4, _Float128 *eveigs, _Float128 *wa1, _Float128 *wa2, _Float128 *wa3, _Float128 *u, mplapackint const ldu, _Float128 *v, _Float128 *tau, _Float128 *z, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, mplapackint &info);
void Rdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *d1, _Float128 *d2, _Float128 *d3, _Float128 *d4, _Float128 *eveigs, _Float128 *wa1, _Float128 *wa2, _Float128 *wa3, _Float128 *u, mplapackint const ldu, _Float128 *v, _Float128 *tau, _Float128 *z, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, _Float128 *result, mplapackint &info);
void Rdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const niunit, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *h, _Float128 *ht, _Float128 *wr, _Float128 *wi, _Float128 *wrt, _Float128 *wit, _Float128 *wrtmp, _Float128 *witmp, _Float128 *vs, mplapackint const ldvs, _Float128 *vs1, _Float128 *result, _Float128 *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float128 const thresh, mplapackint const niunit, mplapackint const nounit, _Float128 *a, mplapackint const lda, _Float128 *h, _Float128 *wr, _Float128 *wi, _Float128 *wr1, _Float128 *wi1, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, _Float128 *lre, mplapackint const ldlre, _Float128 *rcondv, _Float128 *rcndv1, _Float128 *rcdvin, _Float128 *rconde, _Float128 *rcnde1, _Float128 *rcdein, _Float128 *scale, _Float128 *scale1, _Float128 *result, _Float128 *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rerrbd(const char *path, mplapackint const nunit);
void Rerrec(const char *path, mplapackint const nunit);
void Rerred(const char *path, mplapackint const nunit);
void Rerrgg(const char *path, mplapackint const nunit);
void Rerrhs(const char *path, mplapackint const nunit);
void Rerrst(const char *path, mplapackint const nunit);
void Rget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *x, mplapackint const ldx, _Float128 *b, mplapackint const ldb, _Float128 *rwork, _Float128 &resid);
void Rget10(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *work, _Float128 &result);
void Rget22(const char *transa, const char *transe, const char *transw, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *e, mplapackint const lde, _Float128 *wr, _Float128 *wi, _Float128 *work, _Float128 *result);
void Rget23(bool const comp, const char *balanc, mplapackint const jtype, _Float128 const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *h, _Float128 *wr, _Float128 *wi, _Float128 *wr1, _Float128 *wi1, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, _Float128 *lre, mplapackint const ldlre, _Float128 *rcondv, _Float128 *rcndv1, _Float128 *rcdvin, _Float128 *rconde, _Float128 *rcnde1, _Float128 *rcdein, _Float128 *scale, _Float128 *scale1, _Float128 *result, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rget24(bool const comp, mplapackint const jtype, _Float128 const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *h, _Float128 *ht, _Float128 *wr, _Float128 *wi, _Float128 *wrt, _Float128 *wit, _Float128 *wrtmp, _Float128 *witmp, _Float128 *vs, mplapackint const ldvs, _Float128 *vs1, _Float128 const rcdein, _Float128 const rcdvin, mplapackint const nslct, mplapackint *islct, _Float128 *result, _Float128 *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rget31(_Float128 &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget32(_Float128 &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget33(_Float128 &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget34(_Float128 &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget35(_Float128 &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget36(_Float128 &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget37(_Float128 *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget38(_Float128 *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget39(_Float128 &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget40(_Float128 &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget51(mplapackint const itype, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *u, mplapackint const ldu, _Float128 *v, mplapackint const ldv, _Float128 *work, _Float128 &result);
void Rget52(bool const left, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *e, mplapackint const lde, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *work, _Float128 *result);
void Rget53(_Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 const scale, _Float128 const wr, _Float128 const wi, _Float128 &result, mplapackint &info);
void Rget54(mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *s, mplapackint const lds, _Float128 *t, mplapackint const ldt, _Float128 *u, mplapackint const ldu, _Float128 *v, mplapackint const ldv, _Float128 *work, _Float128 &result);
void Rglmts(mplapackint const n, mplapackint const m, mplapackint const p, _Float128 *a, _Float128 *af, mplapackint const lda, _Float128 *b, _Float128 *bf, mplapackint const ldb, _Float128 *d, _Float128 *df, _Float128 *x, _Float128 *u, _Float128 *work, mplapackint const lwork, _Float128 *rwork, _Float128 &result);
void Rgqrts(mplapackint const n, mplapackint const m, mplapackint const p, _Float128 *a, _Float128 *af, _Float128 *q, _Float128 *r, mplapackint const lda, _Float128 *taua, _Float128 *b, _Float128 *bf, _Float128 *z, _Float128 *t, _Float128 *bwk, mplapackint const ldb, _Float128 *taub, _Float128 *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result);
void Rgrqts(mplapackint const m, mplapackint const p, mplapackint const n, _Float128 *a, _Float128 *af, _Float128 *q, _Float128 *r, mplapackint const lda, _Float128 *taua, _Float128 *b, _Float128 *bf, _Float128 *z, _Float128 *t, _Float128 *bwk, mplapackint const ldb, _Float128 *taub, _Float128 *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result);
void Rgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, _Float128 *a, _Float128 *af, mplapackint const lda, _Float128 *b, _Float128 *bf, mplapackint const ldb, _Float128 *u, mplapackint const ldu, _Float128 *v, mplapackint const ldv, _Float128 *q, mplapackint const ldq, _Float128 *alpha, _Float128 *beta, _Float128 *r, mplapackint const ldr, mplapackint *iwork, _Float128 *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result);
void Rhst01(mplapackint const n, mplapackint const, mplapackint const, _Float128 *a, mplapackint const lda, _Float128 *h, mplapackint const ldh, _Float128 *q, mplapackint const ldq, _Float128 *work, mplapackint const lwork, _Float128 *result);
void Rlacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, _Float128 *theta, mplapackint *iseed, _Float128 *x, mplapackint const &ldx, _Float128 *work);
void Rlafts(const char *type, mplapackint const m, mplapackint const n, mplapackint const imat, mplapackint const ntests, _Float128 *result, mplapackint *iseed, _Float128 const thresh, mplapackint const iounit, mplapackint &ie);
void Rlahd2(mplapackint const iounit, const char *path);
void Rlarfy(const char *uplo, mplapackint const n, _Float128 *v, mplapackint const incv, _Float128 const tau, _Float128 *c, mplapackint const ldc, _Float128 *work);
void Rlarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *x, mplapackint const ldx, _Float128 *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Rlasum(const char *type, mplapackint const iounit, mplapackint const ie, mplapackint const nrun);
void Rlatb9(const char *path, mplapackint const imat, mplapackint const m, mplapackint const p, mplapackint const n, char *type, mplapackint &kla, mplapackint &kua, mplapackint &klb, mplapackint &kub, _Float128 &anorm, _Float128 &bnorm, mplapackint &modea, mplapackint &modeb, _Float128 &cndnma, _Float128 &cndnmb, char *dista, char *distb);
void Rlatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, mplapackint const isign, _Float128 const amagn, _Float128 const rcond, _Float128 const triang, mplapackint const idist, mplapackint *iseed, _Float128 *a, mplapackint const lda);
void Rlsets(mplapackint const m, mplapackint const p, mplapackint const n, _Float128 *a, _Float128 *af, mplapackint const lda, _Float128 *b, _Float128 *bf, mplapackint const ldb, _Float128 *c, _Float128 *cf, _Float128 *d, _Float128 *df, _Float128 *x, _Float128 *work, mplapackint const lwork, _Float128 *rwork, _Float128 *result);
void Rort01(const char *rowcol, mplapackint const m, mplapackint const n, _Float128 *u, mplapackint const ldu, _Float128 *work, mplapackint const lwork, _Float128 &resid);
void Rort03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, _Float128 *u, mplapackint const ldu, _Float128 *v, mplapackint const ldv, _Float128 *work, mplapackint const lwork, _Float128 &result, mplapackint &info);
void Rsbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, _Float128 *a, mplapackint const lda, _Float128 *d, _Float128 *e, _Float128 *u, mplapackint const ldu, _Float128 *work, _Float128 *result);
void Rsgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *z, mplapackint const ldz, _Float128 *d, _Float128 *work, _Float128 *result);
void Rspt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, _Float128 *ap, _Float128 *d, _Float128 *e, _Float128 *u, mplapackint const ldu, _Float128 *vp, _Float128 *tau, _Float128 *work, _Float128 *result);
void Rstech(mplapackint const n, _Float128 *a, _Float128 *b, _Float128 *eig, _Float128 const tol, _Float128 *work, mplapackint &info);
void Rstect(mplapackint const n, _Float128 *a, _Float128 *b, _Float128 const shift, mplapackint &num);
void Rstt21(mplapackint const n, mplapackint const kband, _Float128 *ad, _Float128 *ae, _Float128 *sd, _Float128 *se, _Float128 *u, mplapackint const ldu, _Float128 *work, _Float128 *result);
void Rstt22(mplapackint const n, mplapackint const m, mplapackint const kband, _Float128 *ad, _Float128 *ae, _Float128 *sd, _Float128 *se, _Float128 *u, mplapackint const ldu, _Float128 *work, mplapackint const ldwork, _Float128 *result);
void Rsvdch(mplapackint const n, _Float128 *s, _Float128 *e, _Float128 *svd, _Float128 const tol, mplapackint &info);
void Rsvdct(mplapackint const n, _Float128 *s, _Float128 *e, _Float128 const shift, mplapackint &num);
void Rsyt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, _Float128 *a, mplapackint const lda, _Float128 *d, _Float128 *e, _Float128 *u, mplapackint const ldu, _Float128 *v, mplapackint const ldv, _Float128 *tau, _Float128 *work, _Float128 *result);
void Rsyt22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, _Float128 *a, mplapackint const lda, _Float128 *d, _Float128 *e, _Float128 *u, mplapackint const ldu, _Float128 *, mplapackint const ldv, _Float128 *, _Float128 *work, _Float128 *result);
void chkxer(const char *srnamt, mplapackint const &infot, mplapackint const &nout, bool &lerr, bool &ok);
void xlaenv(mplapackint const &ispec, mplapackint const &nvalue);
#endif
