/*
 * Copyright (c) 2012
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_double.h,v 1.4 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK__FLOAT64X_H_
#define _MPLAPACK__FLOAT64X_H_

#include "mplapack_config.h"

_Float64x Clangb(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *work);
_Float64x Clange(const char *norm, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *work);
_Float64x Clangt(const char *norm, mplapackint const n, std::complex<_Float64x> *dl, std::complex<_Float64x> *d, std::complex<_Float64x> *du);
_Float64x Clanhb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *work);
_Float64x Clanhe(const char *norm, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *work);
_Float64x Clanhf(const char *norm, const char *transr, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, _Float64x *work);
_Float64x Clanhp(const char *norm, const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, _Float64x *work);
_Float64x Clanhs(const char *norm, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *work);
_Float64x Clanht(const char *norm, mplapackint const n, _Float64x *d, std::complex<_Float64x> *e);
_Float64x Clansb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *work);
_Float64x Clansp(const char *norm, const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, _Float64x *work);
_Float64x Clansy(const char *norm, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *work);
_Float64x Clantb(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const k, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *work);
_Float64x Clantp(const char *norm, const char *uplo, const char *diag, mplapackint const n, std::complex<_Float64x> *ap, _Float64x *work);
_Float64x Clantr(const char *norm, const char *uplo, const char *diag, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *work);
_Float64x Mmaxval(_Float64x *dx, mplapackint const start, mplapackint const end, mplapackint incx);
_Float64x RCsum1(mplapackint const n, std::complex<_Float64x> *cx, mplapackint const incx);
_Float64x Rla_gbrcond(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float64x *ab, mplapackint const ldab, _Float64x *afb, mplapackint const ldafb, mplapackint *ipiv, mplapackint const cmode, _Float64x *c, mplapackint &info, _Float64x *work, mplapackint *iwork);
_Float64x Rla_gbrpvgrw(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const ncols, _Float64x *ab, mplapackint const ldab, _Float64x *afb, mplapackint const ldafb);
_Float64x Rla_gercond(const char *trans, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *af, mplapackint const ldaf, mplapackint *ipiv, mplapackint const cmode, _Float64x *c, mplapackint &info, _Float64x *work, mplapackint *iwork);
_Float64x Rla_gerpvgrw(mplapackint const n, mplapackint const ncols, _Float64x *a, mplapackint const lda, _Float64x *af, mplapackint const ldaf);
_Float64x Rla_porcond(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *af, mplapackint const ldaf, mplapackint const cmode, _Float64x *c, mplapackint &info, _Float64x *work, mplapackint *iwork);
_Float64x Rla_syrcond(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *af, mplapackint const ldaf, mplapackint *ipiv, mplapackint const cmode, _Float64x *c, mplapackint &info, _Float64x *work, mplapackint *iwork);
_Float64x Rla_syrpvgrw(const char *uplo, mplapackint const n, mplapackint const info, _Float64x *a, mplapackint const lda, _Float64x *af, mplapackint const ldaf, mplapackint *ipiv, _Float64x *work);
_Float64x Rladiv2(_Float64x const &a, _Float64x const &b, _Float64x const &c, _Float64x const &d, _Float64x const &r, _Float64x const &t);
_Float64x Rlamc3(_Float64x a, _Float64x b);
_Float64x Rlamch__Float64x(const char *cmach);
_Float64x Rlangb(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float64x *ab, mplapackint const ldab, _Float64x *work);
_Float64x Rlange(const char *norm, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *work);
_Float64x Rlangt(const char *norm, mplapackint const n, _Float64x *dl, _Float64x *d, _Float64x *du);
_Float64x Rlanhs(const char *norm, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *work);
_Float64x Rlansb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, _Float64x *ab, mplapackint const ldab, _Float64x *work);
_Float64x Rlansf(const char *norm, const char *transr, const char *uplo, mplapackint const n, _Float64x *a, _Float64x *work);
_Float64x Rlansp(const char *norm, const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *work);
_Float64x Rlanst(const char *norm, mplapackint const n, _Float64x *d, _Float64x *e);
_Float64x Rlansy(const char *norm, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *work);
_Float64x Rlantb(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const k, _Float64x *ab, mplapackint const ldab, _Float64x *work);
_Float64x Rlantp(const char *norm, const char *uplo, const char *diag, mplapackint const n, _Float64x *ap, _Float64x *work);
_Float64x Rlantr(const char *norm, const char *uplo, const char *diag, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *work);
_Float64x Rlapy2(_Float64x const x, _Float64x const y);
_Float64x Rlapy3(_Float64x const x, _Float64x const y, _Float64x const z);
bool Mlsamen__Float64x(mplapackint n, const char *a, const char *b);
bool Risnan(_Float64x const din);
bool Rlaisnan(_Float64x const din1, _Float64x const din2);
mplapackint Mmaxloc(_Float64x *dx, mplapackint const start, mplapackint const end, mplapackint const incx);
mplapackint Rlaneg(mplapackint const n, _Float64x *d, _Float64x *lld, _Float64x const sigma, _Float64x const, mplapackint const r);
mplapackint iCmax1(mplapackint const n, std::complex<_Float64x> *zx, mplapackint const incx);
mplapackint iMieeeck__Float64x(mplapackint const &ispec, _Float64x const &zero, _Float64x const &one);
mplapackint iMladiag(const char *diag);
mplapackint iMladlc(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda);
mplapackint iMladlr(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda);
mplapackint iMlaenv2stage__Float64x(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv__Float64x(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaprec(const char *prec);
mplapackint iMlatrans(const char *trans);
mplapackint iMlauplo(const char *uplo);
mplapackint iMlazlc(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda);
mplapackint iMlazlr(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda);
mplapackint iMparam2stage__Float64x(mplapackint const ispec, const char *name, const char *opts, mplapackint const ni, mplapackint const nbi, mplapackint const ibi, mplapackint const nxi);
mplapackint iMparmq__Float64x(mplapackint const ispec, const char *name, const char *opts, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mplapackint const lwork);
std::complex<_Float64x> Cladiv(std::complex<_Float64x> const x, std::complex<_Float64x> const y);
void CRrscl(mplapackint const n, _Float64x const sa, std::complex<_Float64x> *sx, mplapackint const incx);
void Cbbcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, mplapackint const m, mplapackint const p, mplapackint const q, _Float64x *theta, _Float64x *phi, std::complex<_Float64x> *u1, mplapackint const ldu1, std::complex<_Float64x> *u2, mplapackint const ldu2, std::complex<_Float64x> *v1t, mplapackint const ldv1t, std::complex<_Float64x> *v2t, mplapackint const ldv2t, _Float64x *b11d, _Float64x *b11e, _Float64x *b12d, _Float64x *b12e, _Float64x *b21d, _Float64x *b21e, _Float64x *b22d, _Float64x *b22e, _Float64x *rwork, mplapackint const lrwork, mplapackint &info);
void Cbdsqr(const char *uplo, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, _Float64x *d, _Float64x *e, std::complex<_Float64x> *vt, mplapackint const ldvt, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork, mplapackint &info);
void Cgbbrd(const char *vect, mplapackint const m, mplapackint const n, mplapackint const ncc, mplapackint const kl, mplapackint const ku, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *d, _Float64x *e, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *pt, mplapackint const ldpt, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cgbcon(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float64x> *ab, mplapackint const ldab, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cgbequ(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *r, _Float64x *c, _Float64x &rowcnd, _Float64x &colcnd, _Float64x &amax, mplapackint &info);
void Cgbequb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *r, _Float64x *c, _Float64x &rowcnd, _Float64x &colcnd, _Float64x &amax, mplapackint &info);
void Cgbrfs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *afb, mplapackint const ldafb, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cgbsv(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cgbsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *afb, mplapackint const ldafb, mplapackint *ipiv, char *equed, _Float64x *r, _Float64x *c, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cgbtf2(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float64x> *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Cgbtrf(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float64x> *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Cgbtrs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cgebak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *scale, mplapackint const m, std::complex<_Float64x> *v, mplapackint const ldv, mplapackint &info);
void Cgebal(const char *job, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &ilo, mplapackint &ihi, _Float64x *scale, mplapackint &info);
void Cgebd2(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *d, _Float64x *e, std::complex<_Float64x> *tauq, std::complex<_Float64x> *taup, std::complex<_Float64x> *work, mplapackint &info);
void Cgebrd(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *d, _Float64x *e, std::complex<_Float64x> *tauq, std::complex<_Float64x> *taup, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgecon(const char *norm, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cgeequ(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *r, _Float64x *c, _Float64x &rowcnd, _Float64x &colcnd, _Float64x &amax, mplapackint &info);
void Cgeequb(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *r, _Float64x *c, _Float64x &rowcnd, _Float64x &colcnd, _Float64x &amax, mplapackint &info);
void Cgees(const char *jobvs, const char *sort, bool (*select)(std::complex<_Float64x>), mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &sdim, std::complex<_Float64x> *w, std::complex<_Float64x> *vs, mplapackint const ldvs, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, bool *bwork, mplapackint &info);
void Cgeesx(const char *jobvs, const char *sort, bool (*select)(std::complex<_Float64x>), const char *sense, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &sdim, std::complex<_Float64x> *w, std::complex<_Float64x> *vs, mplapackint const ldvs, _Float64x &rconde, _Float64x &rcondv, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, bool *bwork, mplapackint &info);
void Cgeev(const char *jobvl, const char *jobvr, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *w, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Cgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *w, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, _Float64x *scale, _Float64x &abnrm, _Float64x *rconde, _Float64x *rcondv, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Cgehd2(mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint &info);
void Cgehrd(mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgejsv(const char *joba, const char *jobu, const char *jobv, const char *jobr, const char *jobt, const char *jobp, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *sva, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *cwork, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cgelq(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const tsize, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgelq2(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint &info);
void Cgelqf(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgelqt(mplapackint const m, mplapackint const n, mplapackint const mb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *work, mplapackint &info);
void Cgelqt3(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, mplapackint &info);
void Cgels(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgelsd(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *s, _Float64x const rcond, mplapackint &rank, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, mplapackint &info);
void Cgelss(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *s, _Float64x const rcond, mplapackint &rank, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Cgelsy(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint *jpvt, _Float64x const rcond, mplapackint &rank, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Cgemlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const tsize, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgemlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint &info);
void Cgemqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const tsize, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgemqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const nb, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint &info);
void Cgeql2(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint &info);
void Cgeqlf(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgeqp3(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *jpvt, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Cgeqr(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const tsize, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgeqr2(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint &info);
void Cgeqr2p(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint &info);
void Cgeqrf(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgeqrfp(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgeqrt(mplapackint const m, mplapackint const n, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *work, mplapackint &info);
void Cgeqrt2(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, mplapackint &info);
void Cgeqrt3(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, mplapackint &info);
void Cgerfs(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cgerq2(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint &info);
void Cgerqf(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgesc2(mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *rhs, mplapackint *ipiv, mplapackint *jpiv, _Float64x &scale);
void Cgesdd(const char *jobz, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *s, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *vt, mplapackint const ldvt, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, mplapackint &info);
void Cgesv(mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cgesvd(const char *jobu, const char *jobvt, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *s, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *vt, mplapackint const ldvt, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Cgesvdq(const char *joba, const char *jobp, const char *jobr, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *s, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, mplapackint const ldv, mplapackint &numrank, mplapackint *iwork, mplapackint const liwork, std::complex<_Float64x> *cwork, mplapackint const lcwork, _Float64x *rwork, mplapackint const lrwork, mplapackint &info);
void Cgesvdx(const char *jobu, const char *jobvt, const char *range, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, _Float64x *s, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *vt, mplapackint const ldvt, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, mplapackint &info);
void Cgesvj(const char *joba, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *sva, mplapackint const mv, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *cwork, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint &info);
void Cgesvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *af, mplapackint const ldaf, mplapackint *ipiv, char *equed, _Float64x *r, _Float64x *c, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cgetc2(mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, mplapackint *jpiv, mplapackint &info);
void Cgetf2(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetrf(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetrf2(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetri(mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgetrs(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cgetsls(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgetsqrhrt(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cggbak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *lscale, _Float64x *rscale, mplapackint const m, std::complex<_Float64x> *v, mplapackint const ldv, mplapackint &info);
void Cggbal(const char *job, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &ilo, mplapackint &ihi, _Float64x *lscale, _Float64x *rscale, _Float64x *work, mplapackint &info);
void Cgges(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(std::complex<_Float64x>, std::complex<_Float64x>), mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &sdim, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *vsl, mplapackint const ldvsl, std::complex<_Float64x> *vsr, mplapackint const ldvsr, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, bool *bwork, mplapackint &info);
void Cgges3(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(std::complex<_Float64x>, std::complex<_Float64x>), mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &sdim, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *vsl, mplapackint const ldvsl, std::complex<_Float64x> *vsr, mplapackint const ldvsr, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, bool *bwork, mplapackint &info);
void Cggesx(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(std::complex<_Float64x>, std::complex<_Float64x>), const char *sense, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &sdim, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *vsl, mplapackint const ldvsl, std::complex<_Float64x> *vsr, mplapackint const ldvsr, _Float64x *rconde, _Float64x *rcondv, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cggev(const char *jobvl, const char *jobvr, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Cggev3(const char *jobvl, const char *jobvr, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Cggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, mplapackint &ilo, mplapackint &ihi, _Float64x *lscale, _Float64x *rscale, _Float64x &abnrm, _Float64x &bbnrm, _Float64x *rconde, _Float64x *rcondv, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cggglm(mplapackint const n, mplapackint const m, mplapackint const p, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *d, std::complex<_Float64x> *x, std::complex<_Float64x> *y, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgghd3(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgghrd(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *z, mplapackint const ldz, mplapackint &info);
void Cgglse(mplapackint const m, mplapackint const n, mplapackint const p, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *c, std::complex<_Float64x> *d, std::complex<_Float64x> *x, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cggqrf(mplapackint const n, mplapackint const m, mplapackint const p, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *taua, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *taub, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cggrqf(mplapackint const m, mplapackint const p, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *taua, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *taub, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cggsvd3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const n, mplapackint const p, mplapackint &k, mplapackint &l, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *alpha, _Float64x *beta, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, mplapackint &info);
void Cggsvp3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x const tola, _Float64x const tolb, mplapackint &k, mplapackint &l, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *q, mplapackint const ldq, mplapackint *iwork, _Float64x *rwork, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgsvj0(const char *jobv, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *d, _Float64x *sva, mplapackint const mv, std::complex<_Float64x> *v, mplapackint const ldv, _Float64x const eps, _Float64x const sfmin, _Float64x const tol, mplapackint const nsweep, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgsvj1(const char *jobv, mplapackint const m, mplapackint const n, mplapackint const n1, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *d, _Float64x *sva, mplapackint const mv, std::complex<_Float64x> *v, mplapackint const ldv, _Float64x const eps, _Float64x const sfmin, _Float64x const tol, mplapackint const nsweep, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgtcon(const char *norm, mplapackint const n, std::complex<_Float64x> *dl, std::complex<_Float64x> *d, std::complex<_Float64x> *du, std::complex<_Float64x> *du2, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, mplapackint &info);
void Cgtrfs(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *dl, std::complex<_Float64x> *d, std::complex<_Float64x> *du, std::complex<_Float64x> *dlf, std::complex<_Float64x> *df, std::complex<_Float64x> *duf, std::complex<_Float64x> *du2, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cgtsv(mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *dl, std::complex<_Float64x> *d, std::complex<_Float64x> *du, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cgtsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *dl, std::complex<_Float64x> *d, std::complex<_Float64x> *du, std::complex<_Float64x> *dlf, std::complex<_Float64x> *df, std::complex<_Float64x> *duf, std::complex<_Float64x> *du2, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cgttrf(mplapackint const n, std::complex<_Float64x> *dl, std::complex<_Float64x> *d, std::complex<_Float64x> *du, std::complex<_Float64x> *du2, mplapackint *ipiv, mplapackint &info);
void Cgttrs(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *dl, std::complex<_Float64x> *d, std::complex<_Float64x> *du, std::complex<_Float64x> *du2, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cgtts2(mplapackint const itrans, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *dl, std::complex<_Float64x> *d, std::complex<_Float64x> *du, std::complex<_Float64x> *du2, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb);
void Chb2st_kernels(const char *uplo, bool const wantz, mplapackint const ttype, mplapackint const st, mplapackint const ed, mplapackint const sweep, mplapackint const n, mplapackint const nb, mplapackint const ib, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *v, std::complex<_Float64x> *tau, mplapackint const ldvt, std::complex<_Float64x> *work);
void Chbev(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Chbev_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Chbevd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *q, mplapackint const ldq, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *q, mplapackint const ldq, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbgst(const char *vect, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *bb, mplapackint const ldbb, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Chbgv(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *bb, mplapackint const ldbb, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Chbgvd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *bb, mplapackint const ldbb, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbgvx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *bb, mplapackint const ldbb, std::complex<_Float64x> *q, mplapackint const ldq, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbtrd(const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *d, _Float64x *e, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *work, mplapackint &info);
void Checon(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, mplapackint &info);
void Checon_3(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, mplapackint &info);
void Checon_rook(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, mplapackint &info);
void Cheequb(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *s, _Float64x &scond, _Float64x &amax, std::complex<_Float64x> *work, mplapackint &info);
void Cheev(const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *w, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Cheev_2stage(const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *w, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Cheevd(const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *w, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevd_2stage(const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *w, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevr(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, mplapackint *isuppz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevr_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, mplapackint *isuppz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cheevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chegs2(mplapackint const itype, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Chegst(mplapackint const itype, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Chegv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *w, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Chegv_2stage(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *w, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Chegvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *w, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chegvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cherfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Chesv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chesv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chesv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chesv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chesv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chesvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Cheswapr(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Chetd2(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *d, _Float64x *e, std::complex<_Float64x> *tau, mplapackint &info);
void Chetf2(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Chetf2_rk(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, mplapackint &info);
void Chetf2_rook(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Chetrd(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *d, _Float64x *e, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chetrd_2stage(const char *vect, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *d, _Float64x *e, std::complex<_Float64x> *tau, std::complex<_Float64x> *hous2, mplapackint const lhous2, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chetrd_hb2st(const char *stage1, const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *d, _Float64x *e, std::complex<_Float64x> *hous, mplapackint const lhous, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chetrd_he2hb(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chetrf(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chetrf_aa(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chetrf_aa_2stage(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chetrf_rk(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chetrf_rook(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chetri(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint &info);
void Chetri2(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chetri2x(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const nb, mplapackint &info);
void Chetri_3(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chetri_3x(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const nb, mplapackint &info);
void Chetri_rook(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint &info);
void Chetrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Chetrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint &info);
void Chetrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Chetrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Chetrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Chetrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Chfrk(const char *transr, const char *uplo, const char *trans, mplapackint const n, mplapackint const k, _Float64x const alpha, std::complex<_Float64x> *a, mplapackint const lda, _Float64x const beta, std::complex<_Float64x> *c);
void Chgeqz(const char *job, const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float64x> *h, mplapackint const ldh, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Chpcon(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, mplapackint &info);
void Chpev(const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Chpevd(const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chpevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chpgst(mplapackint const itype, const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, std::complex<_Float64x> *bp, mplapackint &info);
void Chpgv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, std::complex<_Float64x> *bp, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Chpgvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, std::complex<_Float64x> *bp, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chpgvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, std::complex<_Float64x> *bp, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *afp, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Chpsv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Chpsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *afp, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Chptrd(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, _Float64x *d, _Float64x *e, std::complex<_Float64x> *tau, mplapackint &info);
void Chptrf(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, mplapackint *ipiv, mplapackint &info);
void Chptri(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint &info);
void Chptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Chsein(const char *side, const char *eigsrc, const char *initv, bool *select, mplapackint const n, std::complex<_Float64x> *h, mplapackint const ldh, std::complex<_Float64x> *w, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *ifaill, mplapackint *ifailr, mplapackint &info);
void Chseqr(const char *job, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float64x> *h, mplapackint const ldh, std::complex<_Float64x> *w, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Clabrd(mplapackint const m, mplapackint const n, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *d, _Float64x *e, std::complex<_Float64x> *tauq, std::complex<_Float64x> *taup, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *y, mplapackint const ldy);
void Clacgv(mplapackint const n, std::complex<_Float64x> *x, mplapackint const incx);
void Clacn2(mplapackint const n, std::complex<_Float64x> *v, std::complex<_Float64x> *x, _Float64x &est, mplapackint &kase, mplapackint *isave);
void Clacon(mplapackint const n, std::complex<_Float64x> *v, std::complex<_Float64x> *x, _Float64x &est, mplapackint &kase);
void Clacp2(const char *uplo, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb);
void Clacpy(const char *uplo, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb);
void Clacrm(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork);
void Clacrt(mplapackint const n, std::complex<_Float64x> *cx, mplapackint const incx, std::complex<_Float64x> *cy, mplapackint const incy, std::complex<_Float64x> const c, std::complex<_Float64x> const s);
void Claed0(mplapackint const qsiz, mplapackint const n, _Float64x *d, _Float64x *e, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *qstore, mplapackint const ldqs, _Float64x *rwork, mplapackint *iwork, mplapackint &info);
void Claed7(mplapackint const n, mplapackint const cutpnt, mplapackint const qsiz, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, _Float64x *d, std::complex<_Float64x> *q, mplapackint const ldq, _Float64x rho, mplapackint *indxq, _Float64x *qstore, mplapackint *qptr, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, _Float64x *givnum, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint &info);
void Claed8(mplapackint &k, mplapackint const n, mplapackint const qsiz, std::complex<_Float64x> *q, mplapackint const ldq, _Float64x *d, _Float64x &rho, mplapackint const cutpnt, _Float64x *z, _Float64x *dlamda, std::complex<_Float64x> *q2, mplapackint const ldq2, _Float64x *w, mplapackint *indxp, mplapackint *indx, mplapackint *indxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, _Float64x *givnum, mplapackint &info);
void Claein(bool const rightv, bool const noinit, mplapackint const n, std::complex<_Float64x> *h, mplapackint const ldh, std::complex<_Float64x> const w, std::complex<_Float64x> *v, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *rwork, _Float64x const eps3, _Float64x const smlnum, mplapackint &info);
void Claesy(std::complex<_Float64x> const a, std::complex<_Float64x> const b, std::complex<_Float64x> const c, std::complex<_Float64x> &rt1, std::complex<_Float64x> &rt2, std::complex<_Float64x> &evscal, std::complex<_Float64x> &cs1, std::complex<_Float64x> &sn1);
void Claev2(std::complex<_Float64x> const a, std::complex<_Float64x> const b, std::complex<_Float64x> const c, _Float64x &rt1, _Float64x &rt2, _Float64x &cs1, std::complex<_Float64x> &sn1);
void Clags2(bool const upper, _Float64x const a1, std::complex<_Float64x> const a2, _Float64x const a3, _Float64x const b1, std::complex<_Float64x> const b2, _Float64x const b3, _Float64x &csu, std::complex<_Float64x> &snu, _Float64x &csv, std::complex<_Float64x> &snv, _Float64x &csq, std::complex<_Float64x> &snq);
void Clagtm(const char *trans, mplapackint const n, mplapackint const nrhs, _Float64x const alpha, std::complex<_Float64x> *dl, std::complex<_Float64x> *d, std::complex<_Float64x> *du, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x const beta, std::complex<_Float64x> *b, mplapackint const ldb);
void Clahef(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *w, mplapackint const ldw, mplapackint &info);
void Clahef_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *h, mplapackint const ldh, std::complex<_Float64x> *work);
void Clahef_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *w, mplapackint const ldw, mplapackint &info);
void Clahef_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *w, mplapackint const ldw, mplapackint &info);
void Clahqr(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float64x> *h, mplapackint const ldh, std::complex<_Float64x> *w, mplapackint const iloz, mplapackint const ihiz, std::complex<_Float64x> *z, mplapackint const ldz, mplapackint &info);
void Clahr2(mplapackint const n, mplapackint const k, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *y, mplapackint const ldy);
void Claic1(mplapackint const job, mplapackint const j, std::complex<_Float64x> *x, _Float64x const sest, std::complex<_Float64x> *w, std::complex<_Float64x> const gamma, _Float64x &sestpr, std::complex<_Float64x> &s, std::complex<_Float64x> &c);
void Clals0(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const nrhs, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *bx, mplapackint const ldbx, mplapackint *perm, mplapackint const givptr, mplapackint *givcol, mplapackint const ldgcol, _Float64x *givnum, mplapackint const ldgnum, _Float64x *poles, _Float64x *difl, _Float64x *difr, _Float64x *z, mplapackint const k, _Float64x const c, _Float64x const s, _Float64x *rwork, mplapackint &info);
void Clalsa(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *bx, mplapackint const ldbx, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint *k, _Float64x *difl, _Float64x *difr, _Float64x *z, _Float64x *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, _Float64x *givnum, _Float64x *c, _Float64x *s, _Float64x *rwork, mplapackint *iwork, mplapackint &info);
void Clalsd(const char *uplo, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, _Float64x *d, _Float64x *e, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x const rcond, mplapackint &rank, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint &info);
void Clamswlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Clamtsqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Clapll(mplapackint const n, std::complex<_Float64x> *x, mplapackint const incx, std::complex<_Float64x> *y, mplapackint const incy, _Float64x &ssmin);
void Clapmr(bool const forwrd, mplapackint const m, mplapackint const n, std::complex<_Float64x> *x, mplapackint const ldx, mplapackint *k);
void Clapmt(bool const forwrd, mplapackint const m, mplapackint const n, std::complex<_Float64x> *x, mplapackint const ldx, mplapackint *k);
void Claqgb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *r, _Float64x *c, _Float64x const rowcnd, _Float64x const colcnd, _Float64x const amax, char *equed);
void Claqge(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *r, _Float64x *c, _Float64x const rowcnd, _Float64x const colcnd, _Float64x const amax, char *equed);
void Claqhb(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *s, _Float64x const scond, _Float64x const amax, char *equed);
void Claqhe(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *s, _Float64x const scond, _Float64x const amax, char *equed);
void Claqhp(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, _Float64x *s, _Float64x const scond, _Float64x const amax, char *equed);
void Claqp2(mplapackint const m, mplapackint const n, mplapackint const offset, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *jpvt, std::complex<_Float64x> *tau, _Float64x *vn1, _Float64x *vn2, std::complex<_Float64x> *work);
void Claqps(mplapackint const m, mplapackint const n, mplapackint const offset, mplapackint const nb, mplapackint &kb, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *jpvt, std::complex<_Float64x> *tau, _Float64x *vn1, _Float64x *vn2, std::complex<_Float64x> *auxv, std::complex<_Float64x> *f, mplapackint const ldf);
void Claqr0(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float64x> *h, mplapackint const ldh, std::complex<_Float64x> *w, mplapackint const iloz, mplapackint const ihiz, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Claqr1(mplapackint const n, std::complex<_Float64x> *h, mplapackint const ldh, std::complex<_Float64x> const s1, std::complex<_Float64x> const s2, std::complex<_Float64x> *v);
void Claqr2(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, std::complex<_Float64x> *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, std::complex<_Float64x> *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, std::complex<_Float64x> *sh, std::complex<_Float64x> *v, mplapackint const ldv, mplapackint const nh, std::complex<_Float64x> *t, mplapackint const ldt, mplapackint const nv, std::complex<_Float64x> *wv, mplapackint const ldwv, std::complex<_Float64x> *work, mplapackint const lwork);
void Claqr3(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, std::complex<_Float64x> *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, std::complex<_Float64x> *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, std::complex<_Float64x> *sh, std::complex<_Float64x> *v, mplapackint const ldv, mplapackint const nh, std::complex<_Float64x> *t, mplapackint const ldt, mplapackint const nv, std::complex<_Float64x> *wv, mplapackint const ldwv, std::complex<_Float64x> *work, mplapackint const lwork);
void Claqr4(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float64x> *h, mplapackint const ldh, std::complex<_Float64x> *w, mplapackint const iloz, mplapackint const ihiz, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Claqr5(bool const wantt, bool const wantz, mplapackint const kacc22, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nshfts, std::complex<_Float64x> *s, std::complex<_Float64x> *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *u, mplapackint const ldu, mplapackint const nv, std::complex<_Float64x> *wv, mplapackint const ldwv, mplapackint const nh, std::complex<_Float64x> *wh, mplapackint const ldwh);
void Claqsb(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *s, _Float64x const scond, _Float64x const amax, char *equed);
void Claqsp(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, _Float64x *s, _Float64x const scond, _Float64x const amax, char *equed);
void Claqsy(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *s, _Float64x const scond, _Float64x const amax, char *equed);
void Clar1v(mplapackint const n, mplapackint const b1, mplapackint const bn, _Float64x const lambda, _Float64x *d, _Float64x *l, _Float64x *ld, _Float64x *lld, _Float64x const pivmin, _Float64x const gaptol, std::complex<_Float64x> *z, bool const wantnc, mplapackint &negcnt, _Float64x &ztz, _Float64x &mingma, mplapackint &r, mplapackint *isuppz, _Float64x &nrminv, _Float64x &resid, _Float64x &rqcorr, _Float64x *work);
void Clar2v(mplapackint const n, std::complex<_Float64x> *x, std::complex<_Float64x> *y, std::complex<_Float64x> *z, mplapackint const incx, _Float64x *c, std::complex<_Float64x> *s, mplapackint const incc);
void Clarcm(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork);
void Clarf(const char *side, mplapackint const m, mplapackint const n, std::complex<_Float64x> *v, mplapackint const incv, std::complex<_Float64x> const tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work);
void Clarfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const ldwork);
void Clarfb_gett(const char *ident, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const ldwork);
void Clarfg(mplapackint const n, std::complex<_Float64x> &alpha, std::complex<_Float64x> *x, mplapackint const incx, std::complex<_Float64x> &tau);
void Clarfgp(mplapackint const n, std::complex<_Float64x> &alpha, std::complex<_Float64x> *x, mplapackint const incx, std::complex<_Float64x> &tau);
void Clarft(const char *direct, const char *storev, mplapackint const n, mplapackint const k, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *tau, std::complex<_Float64x> *t, mplapackint const ldt);
void Clarfx(const char *side, mplapackint const m, mplapackint const n, std::complex<_Float64x> *v, std::complex<_Float64x> const tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work);
void Clarfy(const char *uplo, mplapackint const n, std::complex<_Float64x> *v, mplapackint const incv, std::complex<_Float64x> const tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work);
void Clargv(mplapackint const n, std::complex<_Float64x> *x, mplapackint const incx, std::complex<_Float64x> *y, mplapackint const incy, _Float64x *c, mplapackint const incc);
void Clarnv(mplapackint const idist, mplapackint *iseed, mplapackint const n, std::complex<_Float64x> *x);
void Clarrv(mplapackint const n, _Float64x const vl, _Float64x const, _Float64x *d, _Float64x *l, _Float64x const pivmin, mplapackint *isplit, mplapackint const m, mplapackint const dol, mplapackint const dou, _Float64x const minrgp, _Float64x &rtol1, _Float64x &rtol2, _Float64x *w, _Float64x *werr, _Float64x *wgap, mplapackint *iblock, mplapackint *indexw, _Float64x *gers, std::complex<_Float64x> *z, mplapackint const ldz, mplapackint *isuppz, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Clarscl2(mplapackint const m, mplapackint const n, _Float64x *d, std::complex<_Float64x> *x, mplapackint const ldx);
void Clartg(std::complex<_Float64x> const f, std::complex<_Float64x> const g, _Float64x &cs, std::complex<_Float64x> &sn, std::complex<_Float64x> &r);
void Clartv(mplapackint const n, std::complex<_Float64x> *x, mplapackint const incx, std::complex<_Float64x> *y, mplapackint const incy, _Float64x *c, std::complex<_Float64x> *s, mplapackint const incc);
void Clarz(const char *side, mplapackint const m, mplapackint const n, mplapackint const l, std::complex<_Float64x> *v, mplapackint const incv, std::complex<_Float64x> const tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work);
void Clarzb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const ldwork);
void Clarzt(const char *direct, const char *storev, mplapackint const n, mplapackint const k, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *tau, std::complex<_Float64x> *t, mplapackint const ldt);
void Clascl(const char *type, mplapackint const kl, mplapackint const ku, _Float64x const cfrom, _Float64x const cto, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &info);
void Clascl2(mplapackint const m, mplapackint const n, _Float64x *d, std::complex<_Float64x> *x, mplapackint const ldx);
void Claset(const char *uplo, mplapackint const m, mplapackint const n, std::complex<_Float64x> const alpha, std::complex<_Float64x> const beta, std::complex<_Float64x> *a, mplapackint const lda);
void Clasr(const char *side, const char *pivot, const char *direct, mplapackint const m, mplapackint const n, _Float64x *c, _Float64x *s, std::complex<_Float64x> *a, mplapackint const lda);
void Classq(mplapackint const n, std::complex<_Float64x> *x, mplapackint const incx, _Float64x &scale, _Float64x &sumsq);
void Claswlq(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Claswp(mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint const k1, mplapackint const k2, mplapackint *ipiv, mplapackint const incx);
void Clasyf(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *w, mplapackint const ldw, mplapackint &info);
void Clasyf_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *h, mplapackint const ldh, std::complex<_Float64x> *work);
void Clasyf_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *w, mplapackint const ldw, mplapackint &info);
void Clasyf_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *w, mplapackint const ldw, mplapackint &info);
void Clatbs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *x, _Float64x &scale, _Float64x *cnorm, mplapackint &info);
void Clatdf(mplapackint const ijob, mplapackint const n, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *rhs, _Float64x &rdsum, _Float64x &rdscal, mplapackint *ipiv, mplapackint *jpiv);
void Clatps(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, std::complex<_Float64x> *ap, std::complex<_Float64x> *x, _Float64x &scale, _Float64x *cnorm, mplapackint &info);
void Clatrd(const char *uplo, mplapackint const n, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *e, std::complex<_Float64x> *tau, std::complex<_Float64x> *w, mplapackint const ldw);
void Clatrs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, _Float64x &scale, _Float64x *cnorm, mplapackint &info);
void Clatrz(mplapackint const m, mplapackint const n, mplapackint const l, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work);
void Clatsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Claunhr_col_getrfnp(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *d, mplapackint &info);
void Claunhr_col_getrfnp2(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *d, mplapackint &info);
void Clauu2(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &info);
void Clauum(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &info);
void Cpbcon(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cpbequ(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *s, _Float64x &scond, _Float64x &amax, mplapackint &info);
void Cpbrfs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *afb, mplapackint const ldafb, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cpbstf(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, mplapackint &info);
void Cpbsv(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cpbsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *afb, mplapackint const ldafb, char *equed, _Float64x *s, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cpbtf2(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, mplapackint &info);
void Cpbtrf(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, mplapackint &info);
void Cpbtrs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cpftrf(const char *transr, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint &info);
void Cpftri(const char *transr, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint &info);
void Cpftrs(const char *transr, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cpocon(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cpoequ(mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *s, _Float64x &scond, _Float64x &amax, mplapackint &info);
void Cpoequb(mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *s, _Float64x &scond, _Float64x &amax, mplapackint &info);
void Cporfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *af, mplapackint const ldaf, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cposv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cposvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *af, mplapackint const ldaf, char *equed, _Float64x *s, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cpotf2(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &info);
void Cpotrf(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &info);
void Cpotrf2(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &info);
void Cpotri(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &info);
void Cpotrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cppcon(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cppequ(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, _Float64x *s, _Float64x &scond, _Float64x &amax, mplapackint &info);
void Cpprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *afp, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cppsv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cppsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *afp, char *equed, _Float64x *s, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cpptrf(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, mplapackint &info);
void Cpptri(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, mplapackint &info);
void Cpptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cpstf2(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, _Float64x const tol, _Float64x *work, mplapackint &info);
void Cpstrf(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, _Float64x const tol, _Float64x *work, mplapackint &info);
void Cptcon(mplapackint const n, _Float64x *d, std::complex<_Float64x> *e, _Float64x const anorm, _Float64x &rcond, _Float64x *rwork, mplapackint &info);
void Cpteqr(const char *compz, mplapackint const n, _Float64x *d, _Float64x *e, std::complex<_Float64x> *z, mplapackint const ldz, _Float64x *work, mplapackint &info);
void Cptrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *d, std::complex<_Float64x> *e, _Float64x *df, std::complex<_Float64x> *ef, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cptsv(mplapackint const n, mplapackint const nrhs, _Float64x *d, std::complex<_Float64x> *e, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cptsvx(const char *fact, mplapackint const n, mplapackint const nrhs, _Float64x *d, std::complex<_Float64x> *e, _Float64x *df, std::complex<_Float64x> *ef, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cpttrf(mplapackint const n, _Float64x *d, std::complex<_Float64x> *e, mplapackint &info);
void Cpttrs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *d, std::complex<_Float64x> *e, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cptts2(mplapackint const iuplo, mplapackint const n, mplapackint const nrhs, _Float64x *d, std::complex<_Float64x> *e, std::complex<_Float64x> *b, mplapackint const ldb);
void Crot(mplapackint const n, std::complex<_Float64x> *cx, mplapackint const incx, std::complex<_Float64x> *cy, mplapackint const incy, _Float64x const c, std::complex<_Float64x> const s);
void Cspcon(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, mplapackint &info);
void Cspmv(const char *uplo, mplapackint const n, std::complex<_Float64x> const alpha, std::complex<_Float64x> *ap, std::complex<_Float64x> *x, mplapackint const incx, std::complex<_Float64x> const beta, std::complex<_Float64x> *y, mplapackint const incy);
void Cspr(const char *uplo, mplapackint const n, std::complex<_Float64x> const alpha, std::complex<_Float64x> *x, mplapackint const incx, std::complex<_Float64x> *ap);
void Csprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *afp, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Cspsv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cspsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *afp, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Csptrf(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, mplapackint *ipiv, mplapackint &info);
void Csptri(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint &info);
void Csptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Cstedc(const char *compz, mplapackint const n, _Float64x *d, _Float64x *e, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cstein(mplapackint const n, _Float64x *d, _Float64x *e, mplapackint const m, _Float64x *w, mplapackint *iblock, mplapackint *isplit, std::complex<_Float64x> *z, mplapackint const ldz, _Float64x *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cstemr(const char *jobz, const char *range, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, mplapackint &m, _Float64x *w, std::complex<_Float64x> *z, mplapackint const ldz, mplapackint const nzc, mplapackint *isuppz, bool &tryrac, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Csteqr(const char *compz, mplapackint const n, _Float64x *d, _Float64x *e, std::complex<_Float64x> *z, mplapackint const ldz, _Float64x *work, mplapackint &info);
void Csycon(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, mplapackint &info);
void Csycon_3(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, mplapackint &info);
void Csycon_rook(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, std::complex<_Float64x> *work, mplapackint &info);
void Csyconv(const char *uplo, const char *way, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *e, mplapackint &info);
void Csyconvf(const char *uplo, const char *way, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, mplapackint &info);
void Csyconvf_rook(const char *uplo, const char *way, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, mplapackint &info);
void Csyequb(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *s, _Float64x &scond, _Float64x &amax, std::complex<_Float64x> *work, mplapackint &info);
void Csymv(const char *uplo, mplapackint const n, std::complex<_Float64x> const alpha, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const incx, std::complex<_Float64x> const beta, std::complex<_Float64x> *y, mplapackint const incy);
void Csyr(const char *uplo, mplapackint const n, std::complex<_Float64x> const alpha, std::complex<_Float64x> *x, mplapackint const incx, std::complex<_Float64x> *a, mplapackint const lda);
void Csyrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Csysv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csysv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csysv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csysv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csysv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csysvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Csyswapr(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Csytf2(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Csytf2_rk(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, mplapackint &info);
void Csytf2_rook(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Csytrf(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csytrf_aa(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csytrf_aa_2stage(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csytrf_rk(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csytrf_rook(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csytri(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint &info);
void Csytri2(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csytri2x(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const nb, mplapackint &info);
void Csytri_3(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csytri_3x(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const nb, mplapackint &info);
void Csytri_rook(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint &info);
void Csytrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Csytrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint &info);
void Csytrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Csytrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Csytrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Csytrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Ctbcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x &rcond, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Ctbrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Ctbtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Ctfsm(const char *transr, const char *side, const char *uplo, const char *trans, const char *diag, mplapackint const m, mplapackint const n, std::complex<_Float64x> const alpha, std::complex<_Float64x> *a, std::complex<_Float64x> *b, mplapackint const ldb);
void Ctftri(const char *transr, const char *uplo, const char *diag, mplapackint const n, std::complex<_Float64x> *a, mplapackint &info);
void Ctfttp(const char *transr, const char *uplo, mplapackint const n, std::complex<_Float64x> *arf, std::complex<_Float64x> *ap, mplapackint &info);
void Ctfttr(const char *transr, const char *uplo, mplapackint const n, std::complex<_Float64x> *arf, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &info);
void Ctgevc(const char *side, const char *howmny, bool *select, mplapackint const n, std::complex<_Float64x> *s, mplapackint const lds, std::complex<_Float64x> *p, mplapackint const ldp, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Ctgex2(bool const wantq, bool const wantz, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *z, mplapackint const ldz, mplapackint const j1, mplapackint &info);
void Ctgexc(bool const wantq, bool const wantz, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *z, mplapackint const ldz, mplapackint const ifst, mplapackint &ilst, mplapackint &info);
void Ctgsen(mplapackint const ijob, bool const wantq, bool const wantz, bool *select, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *z, mplapackint const ldz, mplapackint &m, _Float64x &pl, _Float64x &pr, _Float64x *dif, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Ctgsja(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x const tola, _Float64x const tolb, _Float64x *alpha, _Float64x *beta, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *work, mplapackint &ncycle, mplapackint &info);
void Ctgsna(const char *job, const char *howmny, bool *select, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, _Float64x *s, _Float64x *dif, mplapackint const mm, mplapackint &m, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Ctgsy2(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *d, mplapackint const ldd, std::complex<_Float64x> *e, mplapackint const lde, std::complex<_Float64x> *f, mplapackint const ldf, _Float64x &scale, _Float64x &rdsum, _Float64x &rdscal, mplapackint &info);
void Ctgsyl(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *d, mplapackint const ldd, std::complex<_Float64x> *e, mplapackint const lde, std::complex<_Float64x> *f, mplapackint const ldf, _Float64x &scale, _Float64x &dif, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Ctpcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, std::complex<_Float64x> *ap, _Float64x &rcond, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Ctplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *work, mplapackint &info);
void Ctplqt2(mplapackint const m, mplapackint const n, mplapackint const l, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *t, mplapackint const ldt, mplapackint &info);
void Ctpmlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const mb, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint &info);
void Ctpmqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const nb, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint &info);
void Ctpqrt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *work, mplapackint &info);
void Ctpqrt2(mplapackint const m, mplapackint const n, mplapackint const l, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *t, mplapackint const ldt, mplapackint &info);
void Ctprfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const ldwork);
void Ctprfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Ctptri(const char *uplo, const char *diag, mplapackint const n, std::complex<_Float64x> *ap, mplapackint &info);
void Ctptrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Ctpttf(const char *transr, const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, std::complex<_Float64x> *arf, mplapackint &info);
void Ctpttr(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &info);
void Ctrcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x &rcond, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Ctrevc(const char *side, const char *howmny, bool *select, mplapackint const n, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Ctrevc3(const char *side, const char *howmny, bool *select, mplapackint const n, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint &info);
void Ctrexc(const char *compq, mplapackint const n, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *q, mplapackint const ldq, mplapackint const ifst, mplapackint const ilst, mplapackint &info);
void Ctrrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Ctrsen(const char *job, const char *compq, bool *select, mplapackint const n, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *w, mplapackint &m, _Float64x &s, _Float64x &sep, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Ctrsna(const char *job, const char *howmny, bool *select, mplapackint const n, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, _Float64x *s, _Float64x *sep, mplapackint const mm, mplapackint &m, std::complex<_Float64x> *work, mplapackint const ldwork, _Float64x *rwork, mplapackint &info);
void Ctrsyl(const char *trana, const char *tranb, mplapackint const isgn, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x &scale, mplapackint &info);
void Ctrti2(const char *uplo, const char *diag, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &info);
void Ctrtri(const char *uplo, const char *diag, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, mplapackint &info);
void Ctrtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Ctrttf(const char *transr, const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *arf, mplapackint &info);
void Ctrttp(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *ap, mplapackint &info);
void Ctzrzf(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb(const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float64x> *x11, mplapackint const ldx11, std::complex<_Float64x> *x12, mplapackint const ldx12, std::complex<_Float64x> *x21, mplapackint const ldx21, std::complex<_Float64x> *x22, mplapackint const ldx22, _Float64x *theta, _Float64x *phi, std::complex<_Float64x> *taup1, std::complex<_Float64x> *taup2, std::complex<_Float64x> *tauq1, std::complex<_Float64x> *tauq2, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb1(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float64x> *x11, mplapackint const ldx11, std::complex<_Float64x> *x21, mplapackint const ldx21, _Float64x *theta, _Float64x *phi, std::complex<_Float64x> *taup1, std::complex<_Float64x> *taup2, std::complex<_Float64x> *tauq1, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb2(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float64x> *x11, mplapackint const ldx11, std::complex<_Float64x> *x21, mplapackint const ldx21, _Float64x *theta, _Float64x *phi, std::complex<_Float64x> *taup1, std::complex<_Float64x> *taup2, std::complex<_Float64x> *tauq1, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb3(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float64x> *x11, mplapackint const ldx11, std::complex<_Float64x> *x21, mplapackint const ldx21, _Float64x *theta, _Float64x *phi, std::complex<_Float64x> *taup1, std::complex<_Float64x> *taup2, std::complex<_Float64x> *tauq1, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb4(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float64x> *x11, mplapackint const ldx11, std::complex<_Float64x> *x21, mplapackint const ldx21, _Float64x *theta, _Float64x *phi, std::complex<_Float64x> *taup1, std::complex<_Float64x> *taup2, std::complex<_Float64x> *tauq1, std::complex<_Float64x> *phantom, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb5(mplapackint const m1, mplapackint const m2, mplapackint const n, std::complex<_Float64x> *x1, mplapackint const incx1, std::complex<_Float64x> *x2, mplapackint const incx2, std::complex<_Float64x> *q1, mplapackint const ldq1, std::complex<_Float64x> *q2, mplapackint const ldq2, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb6(mplapackint const m1, mplapackint const m2, mplapackint const n, std::complex<_Float64x> *x1, mplapackint const incx1, std::complex<_Float64x> *x2, mplapackint const incx2, std::complex<_Float64x> *q1, mplapackint const ldq1, std::complex<_Float64x> *q2, mplapackint const ldq2, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cuncsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float64x> *x11, mplapackint const ldx11, std::complex<_Float64x> *x12, mplapackint const ldx12, std::complex<_Float64x> *x21, mplapackint const ldx21, std::complex<_Float64x> *x22, mplapackint const ldx22, _Float64x *theta, std::complex<_Float64x> *u1, mplapackint const ldu1, std::complex<_Float64x> *u2, mplapackint const ldu2, std::complex<_Float64x> *v1t, mplapackint const ldv1t, std::complex<_Float64x> *v2t, mplapackint const ldv2t, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cuncsd2by1(const char *jobu1, const char *jobu2, const char *jobv1t, mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float64x> *x11, mplapackint const ldx11, std::complex<_Float64x> *x21, mplapackint const ldx21, _Float64x *theta, std::complex<_Float64x> *u1, mplapackint const ldu1, std::complex<_Float64x> *u2, mplapackint const ldu2, std::complex<_Float64x> *v1t, mplapackint const ldv1t, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cung2l(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint &info);
void Cung2r(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint &info);
void Cungbr(const char *vect, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunghr(mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cungl2(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint &info);
void Cunglq(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cungql(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cungqr(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cungr2(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint &info);
void Cungrq(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cungtr(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cungtsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cungtsqr_row(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunhr_col(mplapackint const m, mplapackint const n, mplapackint const nb, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *d, mplapackint &info);
void Cunm22(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const n1, mplapackint const n2, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunm2l(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint &info);
void Cunm2r(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint &info);
void Cunmbr(const char *vect, const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunmhr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunml2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint &info);
void Cunmlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunmql(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunmqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunmr2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint &info);
void Cunmr3(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint &info);
void Cunmrq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunmrz(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cunmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cupgtr(const char *uplo, mplapackint const n, std::complex<_Float64x> *ap, std::complex<_Float64x> *tau, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *work, mplapackint &info);
void Cupmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, std::complex<_Float64x> *ap, std::complex<_Float64x> *tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work, mplapackint &info);
void Rbbcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, mplapackint const m, mplapackint const p, mplapackint const q, _Float64x *theta, _Float64x *phi, _Float64x *u1, mplapackint const ldu1, _Float64x *u2, mplapackint const ldu2, _Float64x *v1t, mplapackint const ldv1t, _Float64x *v2t, mplapackint const ldv2t, _Float64x *b11d, _Float64x *b11e, _Float64x *b12d, _Float64x *b12e, _Float64x *b21d, _Float64x *b21e, _Float64x *b22d, _Float64x *b22e, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rbdsdc(const char *uplo, const char *compq, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint const ldvt, _Float64x *q, mplapackint *iq, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rbdsqr(const char *uplo, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, _Float64x *d, _Float64x *e, _Float64x *vt, mplapackint const ldvt, _Float64x *u, mplapackint const ldu, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint &info);
void Rbdsvdx(const char *uplo, const char *jobz, const char *range, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, _Float64x *s, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rcombssq(_Float64x *v1, _Float64x *v2);
void Rdisna(const char *job, mplapackint const m, mplapackint const n, _Float64x *d, _Float64x *sep, mplapackint &info);
void Rgbbrd(const char *vect, mplapackint const m, mplapackint const n, mplapackint const ncc, mplapackint const kl, mplapackint const ku, _Float64x *ab, mplapackint const ldab, _Float64x *d, _Float64x *e, _Float64x *q, mplapackint const ldq, _Float64x *pt, mplapackint const ldpt, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint &info);
void Rgbcon(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float64x *ab, mplapackint const ldab, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rgbequ(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float64x *ab, mplapackint const ldab, _Float64x *r, _Float64x *c, _Float64x &rowcnd, _Float64x &colcnd, _Float64x &amax, mplapackint &info);
void Rgbequb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float64x *ab, mplapackint const ldab, _Float64x *r, _Float64x *c, _Float64x &rowcnd, _Float64x &colcnd, _Float64x &amax, mplapackint &info);
void Rgbrfs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x *afb, mplapackint const ldafb, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rgbsv(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rgbsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x *afb, mplapackint const ldafb, mplapackint *ipiv, char *equed, _Float64x *r, _Float64x *c, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rgbtf2(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float64x *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Rgbtrf(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float64x *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Rgbtrs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rgebak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *scale, mplapackint const m, _Float64x *v, mplapackint const ldv, mplapackint &info);
void Rgebal(const char *job, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint &ilo, mplapackint &ihi, _Float64x *scale, mplapackint &info);
void Rgebd2(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *d, _Float64x *e, _Float64x *tauq, _Float64x *taup, _Float64x *work, mplapackint &info);
void Rgebrd(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *d, _Float64x *e, _Float64x *tauq, _Float64x *taup, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgecon(const char *norm, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x const anorm, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rgeequ(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *r, _Float64x *c, _Float64x &rowcnd, _Float64x &colcnd, _Float64x &amax, mplapackint &info);
void Rgeequb(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *r, _Float64x *c, _Float64x &rowcnd, _Float64x &colcnd, _Float64x &amax, mplapackint &info);
void Rgees(const char *jobvs, const char *sort, bool (*select)(_Float64x, _Float64x), mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint &sdim, _Float64x *wr, _Float64x *wi, _Float64x *vs, mplapackint const ldvs, _Float64x *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rgeesx(const char *jobvs, const char *sort, bool (*select)(_Float64x, _Float64x), const char *sense, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint &sdim, _Float64x *wr, _Float64x *wi, _Float64x *vs, mplapackint const ldvs, _Float64x &rconde, _Float64x &rcondv, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rgeev(const char *jobvl, const char *jobvr, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *wr, _Float64x *wi, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *wr, _Float64x *wi, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, _Float64x *scale, _Float64x &abnrm, _Float64x *rconde, _Float64x *rcondv, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgehd2(mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint &info);
void Rgehrd(mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgejsv(const char *joba, const char *jobu, const char *jobv, const char *jobr, const char *jobt, const char *jobp, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *sva, _Float64x *u, mplapackint const ldu, _Float64x *v, mplapackint const ldv, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgelq(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const tsize, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgelq2(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint &info);
void Rgelqf(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgelqt(mplapackint const m, mplapackint const n, mplapackint const mb, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const ldt, _Float64x *work, mplapackint &info);
void Rgelqt3(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const ldt, mplapackint &info);
void Rgels(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgelsd(mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *s, _Float64x const rcond, mplapackint &rank, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgelss(mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *s, _Float64x const rcond, mplapackint &rank, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgelsy(mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, mplapackint *jpvt, _Float64x const rcond, mplapackint &rank, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgemlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const tsize, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgemlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, _Float64x *v, mplapackint const ldv, _Float64x *t, mplapackint const ldt, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint &info);
void Rgemqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const tsize, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgemqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const nb, _Float64x *v, mplapackint const ldv, _Float64x *t, mplapackint const ldt, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint &info);
void Rgeql2(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint &info);
void Rgeqlf(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgeqp3(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *jpvt, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgeqr(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const tsize, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgeqr2(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint &info);
void Rgeqr2p(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint &info);
void Rgeqrf(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgeqrfp(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgeqrt(mplapackint const m, mplapackint const n, mplapackint const nb, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const ldt, _Float64x *work, mplapackint &info);
void Rgeqrt2(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const ldt, mplapackint &info);
void Rgeqrt3(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const ldt, mplapackint &info);
void Rgerfs(const char *trans, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *af, mplapackint const ldaf, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rgerq2(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint &info);
void Rgerqf(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgesc2(mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *rhs, mplapackint *ipiv, mplapackint *jpiv, _Float64x &scale);
void Rgesdd(const char *jobz, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *s, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint const ldvt, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgesv(mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rgesvd(const char *jobu, const char *jobvt, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *s, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint const ldvt, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgesvdq(const char *joba, const char *jobp, const char *jobr, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *s, _Float64x *u, mplapackint const ldu, _Float64x *v, mplapackint const ldv, mplapackint &numrank, mplapackint *iwork, mplapackint const liwork, _Float64x *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint &info);
void Rgesvdx(const char *jobu, const char *jobvt, const char *range, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, _Float64x *s, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint const ldvt, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgesvj(const char *joba, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *sva, mplapackint const mv, _Float64x *v, mplapackint const ldv, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgesvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *af, mplapackint const ldaf, mplapackint *ipiv, char *equed, _Float64x *r, _Float64x *c, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rgetc2(mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, mplapackint *jpiv, mplapackint &info);
void Rgetf2(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetrf(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetrf2(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetri(mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgetrs(const char *trans, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rgetsls(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgetsqrhrt(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const ldt, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rggbak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *lscale, _Float64x *rscale, mplapackint const m, _Float64x *v, mplapackint const ldv, mplapackint &info);
void Rggbal(const char *job, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, mplapackint &ilo, mplapackint &ihi, _Float64x *lscale, _Float64x *rscale, _Float64x *work, mplapackint &info);
void Rgges(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(_Float64x, _Float64x, _Float64x), mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, mplapackint &sdim, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *vsl, mplapackint const ldvsl, _Float64x *vsr, mplapackint const ldvsr, _Float64x *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rgges3(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(_Float64x, _Float64x, _Float64x), mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, mplapackint &sdim, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *vsl, mplapackint const ldvsl, _Float64x *vsr, mplapackint const ldvsr, _Float64x *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rggesx(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(_Float64x, _Float64x, _Float64x), const char *sense, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, mplapackint &sdim, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *vsl, mplapackint const ldvsl, _Float64x *vsr, mplapackint const ldvsr, _Float64x *rconde, _Float64x *rcondv, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rggev(const char *jobvl, const char *jobvr, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rggev3(const char *jobvl, const char *jobvr, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, _Float64x *lscale, _Float64x *rscale, _Float64x &abnrm, _Float64x &bbnrm, _Float64x *rconde, _Float64x *rcondv, _Float64x *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rggglm(mplapackint const n, mplapackint const m, mplapackint const p, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *d, _Float64x *x, _Float64x *y, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgghd3(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *q, mplapackint const ldq, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgghrd(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *q, mplapackint const ldq, _Float64x *z, mplapackint const ldz, mplapackint &info);
void Rgglse(mplapackint const m, mplapackint const n, mplapackint const p, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *c, _Float64x *d, _Float64x *x, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rggqrf(mplapackint const n, mplapackint const m, mplapackint const p, _Float64x *a, mplapackint const lda, _Float64x *taua, _Float64x *b, mplapackint const ldb, _Float64x *taub, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rggrqf(mplapackint const m, mplapackint const p, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *taua, _Float64x *b, mplapackint const ldb, _Float64x *taub, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rggsvd3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const n, mplapackint const p, mplapackint &k, mplapackint &l, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *alpha, _Float64x *beta, _Float64x *u, mplapackint const ldu, _Float64x *v, mplapackint const ldv, _Float64x *q, mplapackint const ldq, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rggsvp3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x const tola, _Float64x const tolb, mplapackint &k, mplapackint &l, _Float64x *u, mplapackint const ldu, _Float64x *v, mplapackint const ldv, _Float64x *q, mplapackint const ldq, mplapackint *iwork, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgsvj0(const char *jobv, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *d, _Float64x *sva, mplapackint const mv, _Float64x *v, mplapackint const ldv, _Float64x const eps, _Float64x const sfmin, _Float64x const tol, mplapackint const nsweep, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgsvj1(const char *jobv, mplapackint const m, mplapackint const n, mplapackint const n1, _Float64x *a, mplapackint const lda, _Float64x *d, _Float64x *sva, mplapackint const mv, _Float64x *v, mplapackint const ldv, _Float64x const eps, _Float64x const sfmin, _Float64x const tol, mplapackint const nsweep, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgtcon(const char *norm, mplapackint const n, _Float64x *dl, _Float64x *d, _Float64x *du, _Float64x *du2, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rgtrfs(const char *trans, mplapackint const n, mplapackint const nrhs, _Float64x *dl, _Float64x *d, _Float64x *du, _Float64x *dlf, _Float64x *df, _Float64x *duf, _Float64x *du2, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rgtsv(mplapackint const n, mplapackint const nrhs, _Float64x *dl, _Float64x *d, _Float64x *du, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rgtsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, _Float64x *dl, _Float64x *d, _Float64x *du, _Float64x *dlf, _Float64x *df, _Float64x *duf, _Float64x *du2, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rgttrf(mplapackint const n, _Float64x *dl, _Float64x *d, _Float64x *du, _Float64x *du2, mplapackint *ipiv, mplapackint &info);
void Rgttrs(const char *trans, mplapackint const n, mplapackint const nrhs, _Float64x *dl, _Float64x *d, _Float64x *du, _Float64x *du2, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rgtts2(mplapackint const itrans, mplapackint const n, mplapackint const nrhs, _Float64x *dl, _Float64x *d, _Float64x *du, _Float64x *du2, mplapackint *ipiv, _Float64x *b, mplapackint const ldb);
void Rhgeqz(const char *job, const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *h, mplapackint const ldh, _Float64x *t, mplapackint const ldt, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *q, mplapackint const ldq, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rhsein(const char *side, const char *eigsrc, const char *initv, bool *select, mplapackint const n, _Float64x *h, mplapackint const ldh, _Float64x *wr, _Float64x *wi, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, _Float64x *work, mplapackint *ifaill, mplapackint *ifailr, mplapackint &info);
void Rhseqr(const char *job, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *h, mplapackint const ldh, _Float64x *wr, _Float64x *wi, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rla_gbamv(mplapackint const trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float64x const alpha, _Float64x *ab, mplapackint const ldab, _Float64x *x, mplapackint const incx, _Float64x const beta, _Float64x *y, mplapackint const incy);
void Rla_geamv(mplapackint const trans, mplapackint const m, mplapackint const n, _Float64x const alpha, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const incx, _Float64x const beta, _Float64x *y, mplapackint const incy);
void Rla_syamv(mplapackint const uplo, mplapackint const n, _Float64x const alpha, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const incx, _Float64x const beta, _Float64x *y, mplapackint const incy);
void Rla_wwaddw(mplapackint const n, _Float64x *x, _Float64x *y, _Float64x *w);
void Rlabad(_Float64x &small, _Float64x &large);
void Rlabrd(mplapackint const m, mplapackint const n, mplapackint const nb, _Float64x *a, mplapackint const lda, _Float64x *d, _Float64x *e, _Float64x *tauq, _Float64x *taup, _Float64x *x, mplapackint const ldx, _Float64x *y, mplapackint const ldy);
void Rlacn2(mplapackint const n, _Float64x *v, _Float64x *x, mplapackint *isgn, _Float64x &est, mplapackint &kase, mplapackint *isave);
void Rlacon(mplapackint const n, _Float64x *v, _Float64x *x, mplapackint *isgn, _Float64x &est, mplapackint &kase);
void Rlacpy(const char *uplo, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb);
void Rladiv(_Float64x const &a, _Float64x const &b, _Float64x const &c, _Float64x const &d, _Float64x &p, _Float64x &q);
void Rladiv1(_Float64x &a, _Float64x const &b, _Float64x const &c, _Float64x const &d, _Float64x &p, _Float64x &q);
void Rlae2(_Float64x const a, _Float64x const b, _Float64x const c, _Float64x &rt1, _Float64x &rt2);
void Rlaebz(mplapackint const ijob, mplapackint const nitmax, mplapackint const n, mplapackint const mmax, mplapackint const minp, mplapackint const nbmin, _Float64x const abstol, _Float64x const reltol, _Float64x const pivmin, _Float64x *d, _Float64x *e, _Float64x *e2, mplapackint *nval, _Float64x *ab, _Float64x *c, mplapackint &mout, mplapackint *nab, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rlaed0(mplapackint const icompq, mplapackint const qsiz, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x *q, mplapackint const ldq, _Float64x *qstore, mplapackint const ldqs, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rlaed1(mplapackint const n, _Float64x *d, _Float64x *q, mplapackint const ldq, mplapackint *indxq, _Float64x rho, mplapackint const cutpnt, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rlaed2(mplapackint &k, mplapackint const n, mplapackint const n1, _Float64x *d, _Float64x *q, mplapackint const ldq, mplapackint *indxq, _Float64x &rho, _Float64x *z, _Float64x *dlamda, _Float64x *w, _Float64x *q2, mplapackint *indx, mplapackint *indxc, mplapackint *indxp, mplapackint *coltyp, mplapackint &info);
void Rlaed3(mplapackint const k, mplapackint const n, mplapackint const n1, _Float64x *d, _Float64x *q, mplapackint const ldq, _Float64x const rho, _Float64x *dlamda, _Float64x *q2, mplapackint *indx, mplapackint *ctot, _Float64x *w, _Float64x *s, mplapackint &info);
void Rlaed4(mplapackint const n, mplapackint const i, _Float64x *d, _Float64x *z, _Float64x *delta, _Float64x const rho, _Float64x &dlam, mplapackint &info);
void Rlaed5(mplapackint const i, _Float64x *d, _Float64x *z, _Float64x *delta, _Float64x const rho, _Float64x &dlam);
void Rlaed6(mplapackint const kniter, bool const orgati, _Float64x const rho, _Float64x *d, _Float64x *z, _Float64x const finit, _Float64x &tau, mplapackint &info);
void Rlaed7(mplapackint const icompq, mplapackint const n, mplapackint const qsiz, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, _Float64x *d, _Float64x *q, mplapackint const ldq, mplapackint *indxq, _Float64x rho, mplapackint const cutpnt, _Float64x *qstore, mplapackint *qptr, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, _Float64x *givnum, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rlaed8(mplapackint const icompq, mplapackint &k, mplapackint const n, mplapackint const qsiz, _Float64x *d, _Float64x *q, mplapackint const ldq, mplapackint *indxq, _Float64x &rho, mplapackint const cutpnt, _Float64x *z, _Float64x *dlamda, _Float64x *q2, mplapackint const ldq2, _Float64x *w, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, _Float64x *givnum, mplapackint *indxp, mplapackint *indx, mplapackint &info);
void Rlaed9(mplapackint const k, mplapackint const kstart, mplapackint const kstop, mplapackint const n, _Float64x *d, _Float64x *q, mplapackint const ldq, _Float64x const rho, _Float64x *dlamda, _Float64x *w, _Float64x *s, mplapackint const lds, mplapackint &info);
void Rlaeda(mplapackint const n, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, _Float64x *givnum, _Float64x *q, mplapackint *qptr, _Float64x *z, _Float64x *ztemp, mplapackint &info);
void Rlaein(bool const rightv, bool const noinit, mplapackint const n, _Float64x *h, mplapackint const ldh, _Float64x const wr, _Float64x const wi, _Float64x *vr, _Float64x *vi, _Float64x *b, mplapackint const ldb, _Float64x *work, _Float64x const eps3, _Float64x const smlnum, _Float64x const bignum, mplapackint &info);
void Rlaev2(_Float64x const a, _Float64x const b, _Float64x const c, _Float64x &rt1, _Float64x &rt2, _Float64x &cs1, _Float64x &sn1);
void Rlaexc(bool const wantq, mplapackint const n, _Float64x *t, mplapackint const ldt, _Float64x *q, mplapackint const ldq, mplapackint const j1, mplapackint const n1, mplapackint const n2, _Float64x *work, mplapackint &info);
void Rlag2(_Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x const safmin, _Float64x &scale1, _Float64x &scale2, _Float64x &wr1, _Float64x &wr2, _Float64x &wi);
void Rlags2(bool const upper, _Float64x const a1, _Float64x const a2, _Float64x const a3, _Float64x const b1, _Float64x const b2, _Float64x const b3, _Float64x &csu, _Float64x &snu, _Float64x &csv, _Float64x &snv, _Float64x &csq, _Float64x &snq);
void Rlagtf(mplapackint const n, _Float64x *a, _Float64x const lambda, _Float64x *b, _Float64x *c, _Float64x const tol, _Float64x *d, mplapackint *in, mplapackint &info);
void Rlagtm(const char *trans, mplapackint const n, mplapackint const nrhs, _Float64x const alpha, _Float64x *dl, _Float64x *d, _Float64x *du, _Float64x *x, mplapackint const ldx, _Float64x const beta, _Float64x *b, mplapackint const ldb);
void Rlagts(mplapackint const job, mplapackint const n, _Float64x *a, _Float64x *b, _Float64x *c, _Float64x *d, mplapackint *in, _Float64x *y, _Float64x &tol, mplapackint &info);
void Rlagv2(_Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x &csl, _Float64x &snl, _Float64x &csr, _Float64x &snr);
void Rlahqr(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *h, mplapackint const ldh, _Float64x *wr, _Float64x *wi, mplapackint const iloz, mplapackint const ihiz, _Float64x *z, mplapackint const ldz, mplapackint &info);
void Rlahr2(mplapackint const n, mplapackint const k, mplapackint const nb, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *t, mplapackint const ldt, _Float64x *y, mplapackint const ldy);
void Rlaic1(mplapackint const job, mplapackint const j, _Float64x *x, _Float64x const sest, _Float64x *w, _Float64x const gamma, _Float64x &sestpr, _Float64x &s, _Float64x &c);
void Rlaln2(bool const ltrans, mplapackint const na, mplapackint const nw, _Float64x const smin, _Float64x const ca, _Float64x *a, mplapackint const lda, _Float64x const d1, _Float64x const d2, _Float64x *b, mplapackint const ldb, _Float64x const wr, _Float64x const wi, _Float64x *x, mplapackint const ldx, _Float64x &scale, _Float64x &xnorm, mplapackint &info);
void Rlals0(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const nrhs, _Float64x *b, mplapackint const ldb, _Float64x *bx, mplapackint const ldbx, mplapackint *perm, mplapackint const givptr, mplapackint *givcol, mplapackint const ldgcol, _Float64x *givnum, mplapackint const ldgnum, _Float64x *poles, _Float64x *difl, _Float64x *difr, _Float64x *z, mplapackint const k, _Float64x const c, _Float64x const s, _Float64x *work, mplapackint &info);
void Rlalsa(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, _Float64x *b, mplapackint const ldb, _Float64x *bx, mplapackint const ldbx, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint *k, _Float64x *difl, _Float64x *difr, _Float64x *z, _Float64x *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, _Float64x *givnum, _Float64x *c, _Float64x *s, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rlalsd(const char *uplo, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, _Float64x *d, _Float64x *e, _Float64x *b, mplapackint const ldb, _Float64x const rcond, mplapackint &rank, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rlamrg(mplapackint const n1, mplapackint const n2, _Float64x *a, mplapackint const dtrd1, mplapackint const dtrd2, mplapackint *index);
void Rlamswlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const ldt, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rlamtsqr(const char *side, const char *trans, mplapackint const &m, mplapackint const &n, mplapackint const &k, mplapackint const &mb, mplapackint const &nb, _Float64x *a, mplapackint const &lda, _Float64x *t, mplapackint const &ldt, _Float64x *c, mplapackint const &ldc, _Float64x *work, mplapackint const &lwork, mplapackint &info);
void Rlanv2(_Float64x &a, _Float64x &b, _Float64x &c, _Float64x &d, _Float64x &rt1r, _Float64x &rt1i, _Float64x &rt2r, _Float64x &rt2i, _Float64x &cs, _Float64x &sn);
void Rlaorhr_col_getrfnp(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *d, mplapackint &info);
void Rlaorhr_col_getrfnp2(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *d, mplapackint &info);
void Rlapll(mplapackint const n, _Float64x *x, mplapackint const incx, _Float64x *y, mplapackint const incy, _Float64x &ssmin);
void Rlapmr(bool const forwrd, mplapackint const m, mplapackint const n, _Float64x *x, mplapackint const ldx, mplapackint *k);
void Rlapmt(bool const forwrd, mplapackint const m, mplapackint const n, _Float64x *x, mplapackint const ldx, mplapackint *k);
void Rlaqgb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float64x *ab, mplapackint const ldab, _Float64x *r, _Float64x *c, _Float64x const rowcnd, _Float64x const colcnd, _Float64x const amax, char *equed);
void Rlaqge(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *r, _Float64x *c, _Float64x const rowcnd, _Float64x const colcnd, _Float64x const amax, char *equed);
void Rlaqp2(mplapackint const m, mplapackint const n, mplapackint const offset, _Float64x *a, mplapackint const lda, mplapackint *jpvt, _Float64x *tau, _Float64x *vn1, _Float64x *vn2, _Float64x *work);
void Rlaqps(mplapackint const m, mplapackint const n, mplapackint const offset, mplapackint const nb, mplapackint &kb, _Float64x *a, mplapackint const lda, mplapackint *jpvt, _Float64x *tau, _Float64x *vn1, _Float64x *vn2, _Float64x *auxv, _Float64x *f, mplapackint const ldf);
void Rlaqr0(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *h, mplapackint const ldh, _Float64x *wr, _Float64x *wi, mplapackint const iloz, mplapackint const ihiz, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rlaqr1(mplapackint const n, _Float64x *h, mplapackint const ldh, _Float64x const sr1, _Float64x const si1, _Float64x const sr2, _Float64x const si2, _Float64x *v);
void Rlaqr2(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, _Float64x *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, _Float64x *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, _Float64x *sr, _Float64x *si, _Float64x *v, mplapackint const ldv, mplapackint const nh, _Float64x *t, mplapackint const ldt, mplapackint const nv, _Float64x *wv, mplapackint const ldwv, _Float64x *work, mplapackint const lwork);
void Rlaqr3(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, _Float64x *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, _Float64x *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, _Float64x *sr, _Float64x *si, _Float64x *v, mplapackint const ldv, mplapackint const nh, _Float64x *t, mplapackint const ldt, mplapackint const nv, _Float64x *wv, mplapackint const ldwv, _Float64x *work, mplapackint const lwork);
void Rlaqr4(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *h, mplapackint const ldh, _Float64x *wr, _Float64x *wi, mplapackint const iloz, mplapackint const ihiz, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rlaqr5(bool const wantt, bool const wantz, mplapackint const kacc22, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nshfts, _Float64x *sr, _Float64x *si, _Float64x *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, _Float64x *z, mplapackint const ldz, _Float64x *v, mplapackint const ldv, _Float64x *u, mplapackint const ldu, mplapackint const nv, _Float64x *wv, mplapackint const ldwv, mplapackint const nh, _Float64x *wh, mplapackint const ldwh);
void Rlaqsb(const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *s, _Float64x const scond, _Float64x const amax, char *equed);
void Rlaqsp(const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *s, _Float64x const scond, _Float64x const amax, char *equed);
void Rlaqsy(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *s, _Float64x const scond, _Float64x const amax, char *equed);
void Rlaqtr(bool const ltran, bool const lreal, mplapackint const n, _Float64x *t, mplapackint const ldt, _Float64x *b, _Float64x const w, _Float64x &scale, _Float64x *x, _Float64x *work, mplapackint &info);
void Rlar1v(mplapackint const n, mplapackint const b1, mplapackint const bn, _Float64x const lambda, _Float64x *d, _Float64x *l, _Float64x *ld, _Float64x *lld, _Float64x const pivmin, _Float64x const gaptol, _Float64x *z, bool const wantnc, mplapackint &negcnt, _Float64x &ztz, _Float64x &mingma, mplapackint &r, mplapackint *isuppz, _Float64x &nrminv, _Float64x &resid, _Float64x &rqcorr, _Float64x *work);
void Rlar2v(mplapackint const n, _Float64x *x, _Float64x *y, _Float64x *z, mplapackint const incx, _Float64x *c, _Float64x *s, mplapackint const incc);
void Rlarf(const char *side, mplapackint const m, mplapackint const n, _Float64x *v, mplapackint const incv, _Float64x const tau, _Float64x *c, mplapackint const ldc, _Float64x *work);
void Rlarfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *v, mplapackint const ldv, _Float64x *t, mplapackint const ldt, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const ldwork);
void Rlarfb_gett(const char *ident, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *t, mplapackint const ldt, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const ldwork);
void Rlarfg(mplapackint const n, _Float64x &alpha, _Float64x *x, mplapackint const incx, _Float64x &tau);
void Rlarfgp(mplapackint const n, _Float64x &alpha, _Float64x *x, mplapackint const incx, _Float64x &tau);
void Rlarft(const char *direct, const char *storev, mplapackint const n, mplapackint const k, _Float64x *v, mplapackint const ldv, _Float64x *tau, _Float64x *t, mplapackint const ldt);
void Rlarfx(const char *side, mplapackint const m, mplapackint const n, _Float64x *v, _Float64x const tau, _Float64x *c, mplapackint const ldc, _Float64x *work);
void Rlarfy(const char *uplo, mplapackint const n, _Float64x *v, mplapackint const incv, _Float64x const tau, _Float64x *c, mplapackint const ldc, _Float64x *work);
void Rlargv(mplapackint const n, _Float64x *x, mplapackint const incx, _Float64x *y, mplapackint const incy, _Float64x *c, mplapackint const incc);
void Rlarnv(mplapackint const idist, mplapackint *iseed, mplapackint const n, _Float64x *x);
void Rlarra(mplapackint const n, _Float64x *d, _Float64x *e, _Float64x *e2, _Float64x const spltol, _Float64x const tnrm, mplapackint &nsplit, mplapackint *isplit, mplapackint &info);
void Rlarrb(mplapackint const n, _Float64x *d, _Float64x *lld, mplapackint const ifirst, mplapackint const ilast, _Float64x const rtol1, _Float64x const rtol2, mplapackint const offset, _Float64x *w, _Float64x *wgap, _Float64x *werr, _Float64x *work, mplapackint *iwork, _Float64x const pivmin, _Float64x const spdiam, mplapackint const twist, mplapackint &info);
void Rlarrc(const char *jobt, mplapackint const n, _Float64x const vl, _Float64x const vu, _Float64x *d, _Float64x *e, _Float64x const, mplapackint &eigcnt, mplapackint &lcnt, mplapackint &rcnt, mplapackint &info);
void Rlarrd(const char *range, const char *order, mplapackint const n, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x *gers, _Float64x const reltol, _Float64x *d, _Float64x *e, _Float64x *e2, _Float64x const pivmin, mplapackint const nsplit, mplapackint *isplit, mplapackint &m, _Float64x *w, _Float64x *werr, _Float64x &wl, _Float64x &wu, mplapackint *iblock, mplapackint *indexw, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rlarre(const char *range, mplapackint const n, _Float64x &vl, _Float64x &vu, mplapackint const il, mplapackint const iu, _Float64x *d, _Float64x *e, _Float64x *e2, _Float64x const rtol1, _Float64x const rtol2, _Float64x const spltol, mplapackint nsplit, mplapackint *isplit, mplapackint &m, _Float64x *w, _Float64x *werr, _Float64x *wgap, mplapackint *iblock, mplapackint *indexw, _Float64x *gers, _Float64x &pivmin, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rlarrf(mplapackint const n, _Float64x *d, _Float64x *l, _Float64x *ld, mplapackint const clstrt, mplapackint const clend, _Float64x *w, _Float64x *wgap, _Float64x *werr, _Float64x const spdiam, _Float64x const clgapl, _Float64x const clgapr, _Float64x const pivmin, _Float64x &sigma, _Float64x *dplus, _Float64x *lplus, _Float64x *work, mplapackint &info);
void Rlarrj(mplapackint const n, _Float64x *d, _Float64x *e2, mplapackint const ifirst, mplapackint const ilast, _Float64x const rtol, mplapackint const offset, _Float64x *w, _Float64x *werr, _Float64x *work, mplapackint *iwork, _Float64x const pivmin, _Float64x const spdiam, mplapackint &info);
void Rlarrk(mplapackint const n, mplapackint const iw, _Float64x const gl, _Float64x const gu, _Float64x *d, _Float64x *e2, _Float64x const pivmin, _Float64x const reltol, _Float64x &w, _Float64x &werr, mplapackint &info);
void Rlarrr(mplapackint const n, _Float64x *d, _Float64x *e, mplapackint &info);
void Rlarrv(mplapackint const n, _Float64x const vl, _Float64x const, _Float64x *d, _Float64x *l, _Float64x const pivmin, mplapackint *isplit, mplapackint const m, mplapackint const dol, mplapackint const dou, _Float64x const minrgp, _Float64x &rtol1, _Float64x &rtol2, _Float64x *w, _Float64x *werr, _Float64x *wgap, mplapackint *iblock, mplapackint *indexw, _Float64x *gers, _Float64x *z, mplapackint const ldz, mplapackint *isuppz, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rlarscl2(mplapackint const m, mplapackint const n, _Float64x *d, _Float64x *x, mplapackint const ldx);
void Rlartg(_Float64x const f, _Float64x const g, _Float64x &cs, _Float64x &sn, _Float64x &r);
void Rlartgp(_Float64x const f, _Float64x const g, _Float64x &cs, _Float64x &sn, _Float64x &r);
void Rlartgs(_Float64x const x, _Float64x const y, _Float64x const sigma, _Float64x &cs, _Float64x &sn);
void Rlartv(mplapackint const n, _Float64x *x, mplapackint const incx, _Float64x *y, mplapackint const incy, _Float64x *c, _Float64x *s, mplapackint const incc);
void Rlaruv(mplapackint *iseed, mplapackint const n, _Float64x *x);
void Rlarz(const char *side, mplapackint const m, mplapackint const n, mplapackint const l, _Float64x *v, mplapackint const incv, _Float64x const tau, _Float64x *c, mplapackint const ldc, _Float64x *work);
void Rlarzb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, _Float64x *v, mplapackint const ldv, _Float64x *t, mplapackint const ldt, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const ldwork);
void Rlarzt(const char *direct, const char *storev, mplapackint const n, mplapackint const k, _Float64x *v, mplapackint const ldv, _Float64x *tau, _Float64x *t, mplapackint const ldt);
void Rlas2(_Float64x const f, _Float64x const g, _Float64x const h, _Float64x &ssmin, _Float64x &ssmax);
void Rlascl(const char *type, mplapackint const kl, mplapackint const ku, _Float64x const cfrom, _Float64x const cto, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint &info);
void Rlascl2(mplapackint const m, mplapackint const n, _Float64x *d, _Float64x *x, mplapackint const ldx);
void Rlasd0(mplapackint const n, mplapackint const sqre, _Float64x *d, _Float64x *e, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint const ldvt, mplapackint const smlsiz, mplapackint *iwork, _Float64x *work, mplapackint &info);
void Rlasd1(mplapackint const nl, mplapackint const nr, mplapackint const sqre, _Float64x *d, _Float64x &alpha, _Float64x &beta, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint const ldvt, mplapackint *idxq, mplapackint *iwork, _Float64x *work, mplapackint &info);
void Rlasd2(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint &k, _Float64x *d, _Float64x *z, _Float64x const alpha, _Float64x const beta, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint const ldvt, _Float64x *dsigma, _Float64x *u2, mplapackint const ldu2, _Float64x *vt2, mplapackint const ldvt2, mplapackint *idxp, mplapackint *idx, mplapackint *idxc, mplapackint *idxq, mplapackint *coltyp, mplapackint &info);
void Rlasd3(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const k, _Float64x *d, _Float64x *q, mplapackint const ldq, _Float64x *dsigma, _Float64x *u, mplapackint const ldu, _Float64x *u2, mplapackint const ldu2, _Float64x *vt, mplapackint const ldvt, _Float64x *vt2, mplapackint const ldvt2, mplapackint *idxc, mplapackint *ctot, _Float64x *z, mplapackint &info);
void Rlasd4(mplapackint const n, mplapackint const i, _Float64x *d, _Float64x *z, _Float64x *delta, _Float64x const rho, _Float64x &sigma, _Float64x *work, mplapackint &info);
void Rlasd5(mplapackint const i, _Float64x *d, _Float64x *z, _Float64x *delta, _Float64x const rho, _Float64x &dsigma, _Float64x *work);
void Rlasd6(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, _Float64x *d, _Float64x *vf, _Float64x *vl, _Float64x &alpha, _Float64x &beta, mplapackint *idxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mplapackint const ldgcol, _Float64x *givnum, mplapackint const ldgnum, _Float64x *poles, _Float64x *difl, _Float64x *difr, _Float64x *z, mplapackint &k, _Float64x &c, _Float64x &s, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rlasd7(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint &k, _Float64x *d, _Float64x *z, _Float64x *zw, _Float64x *vf, _Float64x *vfw, _Float64x *vl, _Float64x *vlw, _Float64x const alpha, _Float64x const beta, _Float64x *dsigma, mplapackint *idx, mplapackint *idxp, mplapackint *idxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mplapackint const ldgcol, _Float64x *givnum, mplapackint const ldgnum, _Float64x &c, _Float64x &s, mplapackint &info);
void Rlasd8(mplapackint const icompq, mplapackint const k, _Float64x *d, _Float64x *z, _Float64x *vf, _Float64x *vl, _Float64x *difl, _Float64x *difr, mplapackint const lddifr, _Float64x *dsigma, _Float64x *work, mplapackint &info);
void Rlasda(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const sqre, _Float64x *d, _Float64x *e, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint *k, _Float64x *difl, _Float64x *difr, _Float64x *z, _Float64x *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, _Float64x *givnum, _Float64x *c, _Float64x *s, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rlasdq(const char *uplo, mplapackint const sqre, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, _Float64x *d, _Float64x *e, _Float64x *vt, mplapackint const ldvt, _Float64x *u, mplapackint const ldu, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint &info);
void Rlasdt(mplapackint const n, mplapackint &lvl, mplapackint &nd, mplapackint *inode, mplapackint *ndiml, mplapackint *ndimr, mplapackint const msub);
void Rlaset(const char *uplo, mplapackint const m, mplapackint const n, _Float64x const alpha, _Float64x const beta, _Float64x *a, mplapackint const lda);
void Rlasq1(mplapackint const n, _Float64x *d, _Float64x *e, _Float64x *work, mplapackint &info);
void Rlasq2(mplapackint const n, _Float64x *z, mplapackint &info);
void Rlasq3(mplapackint const i0, mplapackint &n0, _Float64x *z, mplapackint &pp, _Float64x &dmin, _Float64x &sigma, _Float64x &desig, _Float64x &qmax, mplapackint &nfail, mplapackint &iter, mplapackint &ndiv, bool const ieee, mplapackint &ttype, _Float64x dmin1, _Float64x &dmin2, _Float64x dn, _Float64x dn1, _Float64x dn2, _Float64x g, _Float64x &tau);
void Rlasq4(mplapackint const i0, mplapackint const n0, _Float64x *z, mplapackint const pp, mplapackint const n0in, _Float64x const dmin, _Float64x const dmin1, _Float64x const dmin2, _Float64x const dn, _Float64x const dn1, _Float64x const dn2, _Float64x &tau, mplapackint &ttype, _Float64x &g);
void Rlasq5(mplapackint const i0, mplapackint const n0, _Float64x *z, mplapackint const pp, _Float64x &tau, _Float64x const sigma, _Float64x &dmin, _Float64x &dmin1, _Float64x &dmin2, _Float64x &dn, _Float64x &dnm1, _Float64x &dnm2, bool const ieee, _Float64x const eps);
void Rlasq6(mplapackint const i0, mplapackint const n0, _Float64x *z, mplapackint const pp, _Float64x &dmin, _Float64x &dmin1, _Float64x &dmin2, _Float64x &dn, _Float64x &dnm1, _Float64x &dnm2);
void Rlasr(const char *side, const char *pivot, const char *direct, mplapackint const m, mplapackint const n, _Float64x *c, _Float64x *s, _Float64x *a, mplapackint const lda);
void Rlasrt(const char *id, mplapackint const n, _Float64x *d, mplapackint &info);
void Rlassq(mplapackint const n, _Float64x *x, mplapackint const incx, _Float64x &scale, _Float64x &sumsq);
void Rlasv2(_Float64x const f, _Float64x const g, _Float64x const h, _Float64x &ssmin, _Float64x &ssmax, _Float64x &snr, _Float64x &csr, _Float64x &snl, _Float64x &csl);
void Rlaswlq(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const ldt, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rlaswp(mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint const k1, mplapackint const k2, mplapackint *ipiv, mplapackint const incx);
void Rlasy2(bool const ltranl, bool const ltranr, mplapackint const isgn, mplapackint const n1, mplapackint const n2, _Float64x *tl, mplapackint const ldtl, _Float64x *tr, mplapackint const ldtr, _Float64x *b, mplapackint const ldb, _Float64x &scale, _Float64x *x, mplapackint const ldx, _Float64x &xnorm, mplapackint &info);
void Rlasyf(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *w, mplapackint const ldw, mplapackint &info);
void Rlasyf_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *h, mplapackint const ldh, _Float64x *work);
void Rlasyf_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, _Float64x *a, mplapackint const lda, _Float64x *e, mplapackint *ipiv, _Float64x *w, mplapackint const ldw, mplapackint &info);
void Rlasyf_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *w, mplapackint const ldw, mplapackint &info);
void Rlatbs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *x, _Float64x &scale, _Float64x *cnorm, mplapackint &info);
void Rlatdf(mplapackint const ijob, mplapackint const n, _Float64x *z, mplapackint const ldz, _Float64x *rhs, _Float64x &rdsum, _Float64x &rdscal, mplapackint *ipiv, mplapackint *jpiv);
void Rlatps(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, _Float64x *ap, _Float64x *x, _Float64x &scale, _Float64x *cnorm, mplapackint &info);
void Rlatrd(const char *uplo, mplapackint const n, mplapackint const nb, _Float64x *a, mplapackint const lda, _Float64x *e, _Float64x *tau, _Float64x *w, mplapackint const ldw);
void Rlatrs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *x, _Float64x &scale, _Float64x *cnorm, mplapackint &info);
void Rlatrz(mplapackint const m, mplapackint const n, mplapackint const l, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work);
void Rlatsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const ldt, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rlauu2(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint &info);
void Rlauum(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint &info);
void Ropgtr(const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *tau, _Float64x *q, mplapackint const ldq, _Float64x *work, mplapackint &info);
void Ropmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, _Float64x *ap, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint &info);
void Rorbdb(const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, _Float64x *x11, mplapackint const ldx11, _Float64x *x12, mplapackint const ldx12, _Float64x *x21, mplapackint const ldx21, _Float64x *x22, mplapackint const ldx22, _Float64x *theta, _Float64x *phi, _Float64x *taup1, _Float64x *taup2, _Float64x *tauq1, _Float64x *tauq2, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorbdb1(mplapackint const m, mplapackint const p, mplapackint const q, _Float64x *x11, mplapackint const ldx11, _Float64x *x21, mplapackint const ldx21, _Float64x *theta, _Float64x *phi, _Float64x *taup1, _Float64x *taup2, _Float64x *tauq1, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorbdb2(mplapackint const m, mplapackint const p, mplapackint const q, _Float64x *x11, mplapackint const ldx11, _Float64x *x21, mplapackint const ldx21, _Float64x *theta, _Float64x *phi, _Float64x *taup1, _Float64x *taup2, _Float64x *tauq1, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorbdb3(mplapackint const m, mplapackint const p, mplapackint const q, _Float64x *x11, mplapackint const ldx11, _Float64x *x21, mplapackint const ldx21, _Float64x *theta, _Float64x *phi, _Float64x *taup1, _Float64x *taup2, _Float64x *tauq1, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorbdb4(mplapackint const m, mplapackint const p, mplapackint const q, _Float64x *x11, mplapackint const ldx11, _Float64x *x21, mplapackint const ldx21, _Float64x *theta, _Float64x *phi, _Float64x *taup1, _Float64x *taup2, _Float64x *tauq1, _Float64x *phantom, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorbdb5(mplapackint const m1, mplapackint const m2, mplapackint const n, _Float64x *x1, mplapackint const incx1, _Float64x *x2, mplapackint const incx2, _Float64x *q1, mplapackint const ldq1, _Float64x *q2, mplapackint const ldq2, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorbdb6(mplapackint const m1, mplapackint const m2, mplapackint const n, _Float64x *x1, mplapackint const incx1, _Float64x *x2, mplapackint const incx2, _Float64x *q1, mplapackint const ldq1, _Float64x *q2, mplapackint const ldq2, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, _Float64x *x11, mplapackint const ldx11, _Float64x *x12, mplapackint const ldx12, _Float64x *x21, mplapackint const ldx21, _Float64x *x22, mplapackint const ldx22, _Float64x *theta, _Float64x *u1, mplapackint const ldu1, _Float64x *u2, mplapackint const ldu2, _Float64x *v1t, mplapackint const ldv1t, _Float64x *v2t, mplapackint const ldv2t, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rorcsd2by1(const char *jobu1, const char *jobu2, const char *jobv1t, mplapackint const m, mplapackint const p, mplapackint const q, _Float64x *x11, mplapackint const ldx11, _Float64x *x21, mplapackint const ldx21, _Float64x *theta, _Float64x *u1, mplapackint const ldu1, _Float64x *u2, mplapackint const ldu2, _Float64x *v1t, mplapackint const ldv1t, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rorg2l(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint &info);
void Rorg2r(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint &info);
void Rorgbr(const char *vect, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorghr(mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorgl2(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint &info);
void Rorglq(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorgql(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorgqr(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorgr2(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint &info);
void Rorgrq(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorgtr(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorgtsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const ldt, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorgtsqr_row(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const ldt, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorhr_col(mplapackint const m, mplapackint const n, mplapackint const nb, _Float64x *a, mplapackint const lda, _Float64x *t, mplapackint const ldt, _Float64x *d, mplapackint &info);
void Rorm22(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const n1, mplapackint const n2, _Float64x *q, mplapackint const ldq, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorm2l(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint &info);
void Rorm2r(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint &info);
void Rormbr(const char *vect, const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rormhr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rorml2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint &info);
void Rormlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rormql(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rormqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rormr2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint &info);
void Rormr3(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint &info);
void Rormrq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rormrz(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rormtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *c, mplapackint const ldc, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rpbcon(const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x const anorm, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rpbequ(const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *s, _Float64x &scond, _Float64x &amax, mplapackint &info);
void Rpbrfs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x *afb, mplapackint const ldafb, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rpbstf(const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, mplapackint &info);
void Rpbsv(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rpbsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x *afb, mplapackint const ldafb, char *equed, _Float64x *s, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rpbtf2(const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, mplapackint &info);
void Rpbtrf(const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, mplapackint &info);
void Rpbtrs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rpftrf(const char *transr, const char *uplo, mplapackint const n, _Float64x *a, mplapackint &info);
void Rpftri(const char *transr, const char *uplo, mplapackint const n, _Float64x *a, mplapackint &info);
void Rpftrs(const char *transr, const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rpocon(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x const anorm, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rpoequ(mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *s, _Float64x &scond, _Float64x &amax, mplapackint &info);
void Rpoequb(mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *s, _Float64x &scond, _Float64x &amax, mplapackint &info);
void Rporfs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *af, mplapackint const ldaf, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rposv(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rposvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *af, mplapackint const ldaf, char *equed, _Float64x *s, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rpotf2(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint &info);
void Rpotrf(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint &info);
void Rpotrf2(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint &info);
void Rpotri(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint &info);
void Rpotrs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rppcon(const char *uplo, mplapackint const n, _Float64x *ap, _Float64x const anorm, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rppequ(const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *s, _Float64x &scond, _Float64x &amax, mplapackint &info);
void Rpprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *ap, _Float64x *afp, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rppsv(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *ap, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rppsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *ap, _Float64x *afp, char *equed, _Float64x *s, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rpptrf(const char *uplo, mplapackint const n, _Float64x *ap, mplapackint &info);
void Rpptri(const char *uplo, mplapackint const n, _Float64x *ap, mplapackint &info);
void Rpptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *ap, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rpstf2(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, _Float64x const tol, _Float64x *work, mplapackint &info);
void Rpstrf(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, _Float64x const tol, _Float64x *work, mplapackint &info);
void Rptcon(mplapackint const n, _Float64x *d, _Float64x *e, _Float64x const anorm, _Float64x &rcond, _Float64x *work, mplapackint &info);
void Rpteqr(const char *compz, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint &info);
void Rptrfs(mplapackint const n, mplapackint const nrhs, _Float64x *d, _Float64x *e, _Float64x *df, _Float64x *ef, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint &info);
void Rptsv(mplapackint const n, mplapackint const nrhs, _Float64x *d, _Float64x *e, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rptsvx(const char *fact, mplapackint const n, mplapackint const nrhs, _Float64x *d, _Float64x *e, _Float64x *df, _Float64x *ef, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint &info);
void Rpttrf(mplapackint const n, _Float64x *d, _Float64x *e, mplapackint &info);
void Rpttrs(mplapackint const n, mplapackint const nrhs, _Float64x *d, _Float64x *e, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rptts2(mplapackint const n, mplapackint const nrhs, _Float64x *d, _Float64x *e, _Float64x *b, mplapackint const ldb);
void Rrscl(mplapackint const n, _Float64x const sa, _Float64x *sx, mplapackint const incx);
void Rsb2st_kernels(const char *uplo, bool const wantz, mplapackint const ttype, mplapackint const st, mplapackint const ed, mplapackint const sweep, mplapackint const n, mplapackint const nb, mplapackint const ib, _Float64x *a, mplapackint const lda, _Float64x *v, _Float64x *tau, mplapackint const ldvt, _Float64x *work);
void Rsbev(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint &info);
void Rsbev_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsbevd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *q, mplapackint const ldq, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *q, mplapackint const ldq, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbgst(const char *vect, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, _Float64x *ab, mplapackint const ldab, _Float64x *bb, mplapackint const ldbb, _Float64x *x, mplapackint const ldx, _Float64x *work, mplapackint &info);
void Rsbgv(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, _Float64x *ab, mplapackint const ldab, _Float64x *bb, mplapackint const ldbb, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint &info);
void Rsbgvd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, _Float64x *ab, mplapackint const ldab, _Float64x *bb, mplapackint const ldbb, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbgvx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, _Float64x *ab, mplapackint const ldab, _Float64x *bb, mplapackint const ldbb, _Float64x *q, mplapackint const ldq, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbtrd(const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *d, _Float64x *e, _Float64x *q, mplapackint const ldq, _Float64x *work, mplapackint &info);
void Rsfrk(const char *transr, const char *uplo, const char *trans, mplapackint const n, mplapackint const k, _Float64x const alpha, _Float64x *a, mplapackint const lda, _Float64x const beta, _Float64x *c);
void Rspcon(const char *uplo, mplapackint const n, _Float64x *ap, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rspev(const char *jobz, const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint &info);
void Rspevd(const char *jobz, const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rspevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float64x *ap, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rspgst(mplapackint const itype, const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *bp, mplapackint &info);
void Rspgv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *bp, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint &info);
void Rspgvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *bp, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rspgvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *bp, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *ap, _Float64x *afp, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rspsv(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *ap, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rspsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *ap, _Float64x *afp, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rsptrd(const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *d, _Float64x *e, _Float64x *tau, mplapackint &info);
void Rsptrf(const char *uplo, mplapackint const n, _Float64x *ap, mplapackint *ipiv, mplapackint &info);
void Rsptri(const char *uplo, mplapackint const n, _Float64x *ap, mplapackint *ipiv, _Float64x *work, mplapackint &info);
void Rsptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *ap, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rstebz(const char *range, const char *order, mplapackint const n, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, _Float64x *d, _Float64x *e, mplapackint &m, mplapackint &nsplit, _Float64x *w, mplapackint *iblock, mplapackint *isplit, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rstedc(const char *compz, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstein(mplapackint const n, _Float64x *d, _Float64x *e, mplapackint const m, _Float64x *w, mplapackint *iblock, mplapackint *isplit, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rstemr(const char *jobz, const char *range, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, mplapackint const nzc, mplapackint *isuppz, bool &tryrac, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsteqr(const char *compz, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint &info);
void Rsterf(mplapackint const n, _Float64x *d, _Float64x *e, mplapackint &info);
void Rstev(const char *jobz, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint &info);
void Rstevd(const char *jobz, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstevr(const char *jobz, const char *range, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, mplapackint *isuppz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstevx(const char *jobz, const char *range, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsycon(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rsycon_3(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *e, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rsycon_rook(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x const anorm, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rsyconv(const char *uplo, const char *way, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *e, mplapackint &info);
void Rsyconvf(const char *uplo, const char *way, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *e, mplapackint *ipiv, mplapackint &info);
void Rsyconvf_rook(const char *uplo, const char *way, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *e, mplapackint *ipiv, mplapackint &info);
void Rsyequb(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *s, _Float64x &scond, _Float64x &amax, _Float64x *work, mplapackint &info);
void Rsyev(const char *jobz, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *w, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsyev_2stage(const char *jobz, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *w, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsyevd(const char *jobz, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *w, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevd_2stage(const char *jobz, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *w, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevr(const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, mplapackint *isuppz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevr_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, mplapackint *isuppz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsyevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsygs2(mplapackint const itype, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rsygst(mplapackint const itype, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rsygv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *w, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsygv_2stage(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *w, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsygvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *w, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsygvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x const vl, _Float64x const vu, mplapackint const il, mplapackint const iu, _Float64x const abstol, mplapackint &m, _Float64x *w, _Float64x *z, mplapackint const ldz, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsyrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *af, mplapackint const ldaf, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rsysv(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsysv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsysv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsysv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *e, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsysv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsysvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *af, mplapackint const ldaf, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x &rcond, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rsyswapr(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Rsytd2(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *d, _Float64x *e, _Float64x *tau, mplapackint &info);
void Rsytf2(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rsytf2_rk(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *e, mplapackint *ipiv, mplapackint &info);
void Rsytf2_rook(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rsytrd(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *d, _Float64x *e, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_2stage(const char *vect, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *d, _Float64x *e, _Float64x *tau, _Float64x *hous2, mplapackint const lhous2, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_sb2st(const char *stage1, const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *d, _Float64x *e, _Float64x *hous, mplapackint const lhous, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_sy2sb(const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *a, mplapackint const lda, _Float64x *ab, mplapackint const ldab, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsytrf(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_aa(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_aa_2stage(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_rk(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *e, mplapackint *ipiv, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_rook(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsytri(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *work, mplapackint &info);
void Rsytri2(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsytri2x(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *work, mplapackint const nb, mplapackint &info);
void Rsytri_3(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *e, mplapackint *ipiv, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsytri_3x(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *e, mplapackint *ipiv, _Float64x *work, mplapackint const nb, mplapackint &info);
void Rsytri_rook(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *work, mplapackint &info);
void Rsytrs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rsytrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint &info);
void Rsytrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *e, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rsytrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rsytrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rsytrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rtbcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rtbrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rtbtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rtfsm(const char *transr, const char *side, const char *uplo, const char *trans, const char *diag, mplapackint const m, mplapackint const n, _Float64x const alpha, _Float64x *a, _Float64x *b, mplapackint const ldb);
void Rtftri(const char *transr, const char *uplo, const char *diag, mplapackint const n, _Float64x *a, mplapackint &info);
void Rtfttp(const char *transr, const char *uplo, mplapackint const n, _Float64x *arf, _Float64x *ap, mplapackint &info);
void Rtfttr(const char *transr, const char *uplo, mplapackint const n, _Float64x *arf, _Float64x *a, mplapackint const lda, mplapackint &info);
void Rtgevc(const char *side, const char *howmny, bool *select, mplapackint const n, _Float64x *s, mplapackint const lds, _Float64x *p, mplapackint const ldp, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, _Float64x *work, mplapackint &info);
void Rtgex2(bool const wantq, bool const wantz, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *q, mplapackint const ldq, _Float64x *z, mplapackint const ldz, mplapackint const j1, mplapackint const n1, mplapackint const n2, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rtgexc(bool const wantq, bool const wantz, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *q, mplapackint const ldq, _Float64x *z, mplapackint const ldz, mplapackint &ifst, mplapackint &ilst, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rtgsen(mplapackint const ijob, bool const wantq, bool const wantz, bool *select, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *q, mplapackint const ldq, _Float64x *z, mplapackint const ldz, mplapackint &m, _Float64x &pl, _Float64x &pr, _Float64x *dif, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rtgsja(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mplapackint const k, mplapackint const l, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x const tola, _Float64x const tolb, _Float64x *alpha, _Float64x *beta, _Float64x *u, mplapackint const ldu, _Float64x *v, mplapackint const ldv, _Float64x *q, mplapackint const ldq, _Float64x *work, mplapackint &ncycle, mplapackint &info);
void Rtgsna(const char *job, const char *howmny, bool *select, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, _Float64x *s, _Float64x *dif, mplapackint const mm, mplapackint &m, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rtgsy2(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *c, mplapackint const ldc, _Float64x *d, mplapackint const ldd, _Float64x *e, mplapackint const lde, _Float64x *f, mplapackint const ldf, _Float64x &scale, _Float64x &rdsum, _Float64x &rdscal, mplapackint *iwork, mplapackint &pq, mplapackint &info);
void Rtgsyl(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *c, mplapackint const ldc, _Float64x *d, mplapackint const ldd, _Float64x *e, mplapackint const lde, _Float64x *f, mplapackint const ldf, _Float64x &scale, _Float64x &dif, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rtpcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, _Float64x *ap, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rtplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *t, mplapackint const ldt, _Float64x *work, mplapackint &info);
void Rtplqt2(mplapackint const m, mplapackint const n, mplapackint const l, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *t, mplapackint const ldt, mplapackint &info);
void Rtpmlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const mb, _Float64x *v, mplapackint const ldv, _Float64x *t, mplapackint const ldt, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint &info);
void Rtpmqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const nb, _Float64x *v, mplapackint const ldv, _Float64x *t, mplapackint const ldt, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint &info);
void Rtpqrt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *t, mplapackint const ldt, _Float64x *work, mplapackint &info);
void Rtpqrt2(mplapackint const m, mplapackint const n, mplapackint const l, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *t, mplapackint const ldt, mplapackint &info);
void Rtprfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, _Float64x *v, mplapackint const ldv, _Float64x *t, mplapackint const ldt, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const ldwork);
void Rtprfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *ap, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rtptri(const char *uplo, const char *diag, mplapackint const n, _Float64x *ap, mplapackint &info);
void Rtptrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *ap, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rtpttf(const char *transr, const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *arf, mplapackint &info);
void Rtpttr(const char *uplo, mplapackint const n, _Float64x *ap, _Float64x *a, mplapackint const lda, mplapackint &info);
void Rtrcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x &rcond, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rtrevc(const char *side, const char *howmny, bool *select, mplapackint const n, _Float64x *t, mplapackint const ldt, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, _Float64x *work, mplapackint &info);
void Rtrevc3(const char *side, const char *howmny, bool *select, mplapackint const n, _Float64x *t, mplapackint const ldt, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rtrexc(const char *compq, mplapackint const n, _Float64x *t, mplapackint const ldt, _Float64x *q, mplapackint const ldq, mplapackint &ifst, mplapackint &ilst, _Float64x *work, mplapackint &info);
void Rtrrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *ferr, _Float64x *berr, _Float64x *work, mplapackint *iwork, mplapackint &info);
void Rtrsen(const char *job, const char *compq, bool *select, mplapackint const n, _Float64x *t, mplapackint const ldt, _Float64x *q, mplapackint const ldq, _Float64x *wr, _Float64x *wi, mplapackint &m, _Float64x &s, _Float64x &sep, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rtrsna(const char *job, const char *howmny, bool *select, mplapackint const n, _Float64x *t, mplapackint const ldt, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, _Float64x *s, _Float64x *sep, mplapackint const mm, mplapackint &m, _Float64x *work, mplapackint const ldwork, mplapackint *iwork, mplapackint &info);
void Rtrsyl(const char *trana, const char *tranb, mplapackint const isgn, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *c, mplapackint const ldc, _Float64x &scale, mplapackint &info);
void Rtrti2(const char *uplo, const char *diag, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint &info);
void Rtrtri(const char *uplo, const char *diag, mplapackint const n, _Float64x *a, mplapackint const lda, mplapackint &info);
void Rtrtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rtrttf(const char *transr, const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *arf, mplapackint &info);
void Rtrttp(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *ap, mplapackint &info);
void Rtzrzf(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, mplapackint &info);
void iMlaver__Float64x(mplapackint &mplapack_ver_major, mplapackint &mplapack_ver_minor, mplapackint &mplapack_ver_patch, mplapackint &lapack_ver_major, mplapackint &lapack_ver_minor, mplapackint &lapack_ver_patch);
#endif
