/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.util.rewrites;

import appeng.api.storage.data.IAEItemStack;
import gregtech.api.util.GTUtility;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.Nullable;

public class TST_ItemID
extends GTUtility.ItemId {
    private Item item;
    private int metaData;
    private NBTTagCompound nbt;
    public static final TST_ItemID NULL = new TST_ItemID();

    public TST_ItemID(Item item, int metaData, NBTTagCompound nbt) {
        this.item = item;
        this.metaData = metaData;
        this.nbt = nbt;
    }

    public TST_ItemID(Item item, int metaData) {
        this.item = item;
        this.metaData = metaData;
    }

    public TST_ItemID(Item item) {
        this.item = item;
        this.metaData = 0;
    }

    public TST_ItemID() {
    }

    public static TST_ItemID create(ItemStack itemStack) {
        if (null == itemStack) {
            return NULL;
        }
        return new TST_ItemID(itemStack.func_77973_b(), itemStack.func_77960_j(), itemStack.func_77978_p());
    }

    public static TST_ItemID createNoNBT(ItemStack itemStack) {
        if (null == itemStack) {
            return NULL;
        }
        return new TST_ItemID(itemStack.func_77973_b(), itemStack.func_77960_j());
    }

    public static TST_ItemID createAsWildcard(ItemStack itemStack) {
        if (null == itemStack) {
            return NULL;
        }
        return new TST_ItemID(itemStack.func_77973_b(), Short.MAX_VALUE);
    }

    public static TST_ItemID create(IAEItemStack aeStack) {
        return TST_ItemID.create(aeStack.getItemStack());
    }

    public static TST_ItemID[] create(ItemStack ... itemStacks) {
        TST_ItemID[] out = new TST_ItemID[itemStacks.length];
        for (int i = 0; i < itemStacks.length; ++i) {
            out[i] = TST_ItemID.create(itemStacks[i]);
        }
        return out;
    }

    public ItemStack getItemStack() {
        ItemStack r = new ItemStack(this.item, 1, this.metaData);
        if (this.nbt != null) {
            r.func_77982_d(this.nbt);
        }
        return r;
    }

    public ItemStack getItemStack(int amount) {
        ItemStack r = new ItemStack(this.item, amount, this.metaData);
        if (this.nbt != null) {
            r.func_77982_d(this.nbt);
        }
        return r;
    }

    public ItemStack getItemStackWithNBT() {
        ItemStack itemStack = new ItemStack(this.item, 1, this.metaData);
        itemStack.func_77982_d(this.nbt);
        return itemStack;
    }

    public ItemStack getItemStackWithNBT(int amount) {
        ItemStack itemStack = new ItemStack(this.item, amount, this.metaData);
        itemStack.func_77982_d(this.nbt);
        return itemStack;
    }

    public ItemStack getItemStackWithoutNBT() {
        return new ItemStack(this.item, 1, this.metaData);
    }

    public ItemStack getItemStackWithoutNBT(int amount) {
        return new ItemStack(this.item, amount, this.metaData);
    }

    public boolean isWildcard() {
        return this.metaData == Short.MAX_VALUE;
    }

    public TST_ItemID setItem(Item item) {
        this.item = item;
        return this;
    }

    public TST_ItemID setMetaData(int metaData) {
        this.metaData = metaData;
        return this;
    }

    public TST_ItemID setNbt(NBTTagCompound nbt) {
        this.nbt = nbt;
        return this;
    }

    protected Item item() {
        return this.item;
    }

    protected int metaData() {
        return this.metaData;
    }

    @Nullable
    protected NBTTagCompound nbt() {
        return this.nbt;
    }

    @Nullable
    protected Integer stackSize() {
        return null;
    }

    @Nullable
    protected NBTTagCompound getNBT() {
        return this.nbt;
    }

    protected Item getItem() {
        return this.item;
    }

    protected int getMetaData() {
        return this.metaData;
    }

    public boolean equalItemStack(ItemStack itemStack) {
        if (this.isWildcard()) {
            return this.equals((Object)TST_ItemID.createAsWildcard(itemStack));
        }
        if (this.nbt != null) {
            return this.equals((Object)TST_ItemID.create(itemStack));
        }
        return this.equals((Object)TST_ItemID.createNoNBT(itemStack));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TST_ItemID)) {
            return false;
        }
        TST_ItemID tstItemID = (TST_ItemID)((Object)o);
        return this.metaData == tstItemID.metaData && Objects.equals(this.item, tstItemID.item) && Objects.equals(this.nbt, tstItemID.nbt);
    }

    public int hashCode() {
        return Objects.hash(this.item, this.metaData, this.nbt);
    }
}

