/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.util;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.util.GTUtility;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TstUtils {
    public static final double LOG2 = Math.log(2.0);
    public static final double LOG4 = Math.log(4.0);
    public static final BigInteger NEGATIVE_ONE = BigInteger.valueOf(-1L);
    public static final BigInteger INTEGER_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);

    public static ItemStack newItemWithMeta(Item item, int meta) {
        return new ItemStack(item, 1, meta);
    }

    public static ItemStack newItemWithMeta(Block block, int meta) {
        return new ItemStack(block, 1, meta);
    }

    public static ItemStack newItemStack(Item item, int meta) {
        return TstUtils.newItemStack(item, meta, 1);
    }

    public static ItemStack newItemStack(Block block, int meta) {
        return TstUtils.newItemStack(block, meta, 1);
    }

    public static ItemStack newItemStack(String fqrn, int meta) {
        return TstUtils.newItemStack(fqrn, meta, 1);
    }

    public static ItemStack newItemStack(Item item, int meta, int count) {
        return new ItemStack(item, count, meta);
    }

    public static ItemStack newItemStack(Block block, int meta, int count) {
        return new ItemStack(block, count, meta);
    }

    public static ItemStack newItemStack(String fqrn, int meta, int count) {
        String[] lookupInfo = TstUtils.parseItemFqn(fqrn);
        Item item = GameRegistry.findItem((String)lookupInfo[0], (String)lookupInfo[1]);
        if (item == null) {
            return null;
        }
        return new ItemStack(item, count, meta);
    }

    public static ItemStack newPlaceholderItemStack(String message) {
        ItemStack stack = new ItemStack((Block)Blocks.field_150480_ab);
        stack.func_151001_c("Placeholder: " + message);
        return stack;
    }

    private static String[] parseItemFqn(String fqn) {
        ResourceLocation rl = new ResourceLocation(fqn);
        return new String[]{rl.func_110624_b(), rl.func_110623_a()};
    }

    public static String tr(String key, Object ... format) {
        return StatCollector.func_74837_a((String)key, (Object[])format);
    }

    public static String tr(String key) {
        return StatCollector.func_74838_a((String)key);
    }

    public static String[] buildInfoData(Consumer<ArrayList<@NotNull String>> builder) {
        return TstUtils.buildInfoData(null, builder);
    }

    public static String[] buildInfoData(@NotNull String @Nullable [] superInfoData, Consumer<ArrayList<@NotNull String>> builder) {
        ArrayList ret = superInfoData != null ? Lists.newArrayList((Object[])superInfoData) : new ArrayList();
        builder.accept(ret);
        return ret.toArray(new String[0]);
    }

    public static long getMachineTotalPower(@NotNull MTEExtendedPowerMultiBlockBase<?> machine) {
        return machine.getMaxInputEu();
    }

    public static int getMachineTotalPowerTier(@NotNull MTEExtendedPowerMultiBlockBase<?> machine) {
        return (int)Math.ceil(TstUtils.calculateVoltageTier(TstUtils.getMachineTotalPower(machine)));
    }

    public static String getPowerTierName(int tier) {
        if (tier < 0) {
            throw new IllegalArgumentException("Voltage tier should not be small than 0.");
        }
        if (tier > 14) {
            return GTValues.VN[15];
        }
        return GTValues.VN[tier];
    }

    public static void registerTexture(int page, int index, ITexture texture) {
        GTUtility.addTexturePage((byte)((byte)page));
        Textures.BlockIcons.setCasingTexture((byte)((byte)page), (byte)((byte)index), (ITexture)texture);
    }

    public static int getTextureIndex(int page, int index) {
        return 128 * page + index;
    }

    public static int getVoltageForCoil(HeatingCoilLevel coilLevel) {
        return coilLevel.getTier() + 1;
    }

    @Deprecated
    public static int multiBuildPiece(int ... buildPieces) {
        int out = Integer.MIN_VALUE;
        for (int v : buildPieces) {
            out &= v & Integer.MIN_VALUE | Integer.MAX_VALUE;
            if (v == -1) continue;
            out += v;
        }
        return out < 0 ? -1 : out;
    }

    public static int getBuiltBlockCount(int ... builtBlockCountEachPart) {
        int count = Arrays.stream(builtBlockCountEachPart).filter(x -> x > 0).sum();
        return count <= 0 ? -1 : count;
    }

    public static boolean areItemsValid(ItemStack ... stacks) {
        if (stacks == null || stacks.length < 1) {
            return false;
        }
        return Arrays.stream(stacks).allMatch(GTUtility::isStackValid);
    }

    public static <T> List<T> toNonNullList(@Nullable T @NotNull [] array) {
        return Arrays.stream(array).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> T[] toNonNullArray(@Nullable T @NotNull [] array, Class<T> tClass) {
        return Arrays.stream(array).filter(Objects::nonNull).toArray(size -> (Object[])Array.newInstance(tClass, size));
    }

    @Contract(value="null -> null; !null -> !null")
    public static ItemStack[] toNonNullItemStackArray(@Nullable @Nullable ItemStack @Nullable [] array) {
        return array != null ? TstUtils.toNonNullArray(array, ItemStack.class) : null;
    }

    @Contract(value="null -> null; !null -> !null")
    public static FluidStack[] toNonNullFluidStackArray(@Nullable @Nullable FluidStack @Nullable [] array) {
        return array != null ? TstUtils.toNonNullArray(array, FluidStack.class) : null;
    }

    public static double calculateVoltageTier(double voltage) {
        return 1.0 + Math.max(0.0, Math.log(voltage) / LOG2 - 5.0) / 2.0;
    }

    public static ItemStack setStackSize(@NotNull ItemStack itemStack, int size) {
        itemStack.field_77994_a = size;
        return itemStack;
    }

    public static FluidStack setStackSize(@NotNull FluidStack fluidStack, int size) {
        fluidStack.amount = size;
        return fluidStack;
    }

    public static ItemStack copyAmount(int amount, ItemStack itemStack) {
        return GTUtility.copyAmountUnsafe((int)amount, (ItemStack)itemStack);
    }

    public static ItemStack copyAmount(ItemStack itemStack, int amount) {
        return GTUtility.copyAmountUnsafe((int)amount, (ItemStack)itemStack);
    }

    public static FluidStack copyAmount(int amount, FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        FluidStack rStack = fluidStack.copy();
        rStack.amount = amount;
        return rStack;
    }

    public static FluidStack copyAmount(FluidStack fluidStack, int amount) {
        return TstUtils.copyAmount(amount, fluidStack);
    }

    public static boolean addStacksToList(@NotNull Collection<ItemStack> list, @NotNull ItemStack itemStack, long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Code is trying to set item stack size a negative number.");
        }
        if (amount <= Integer.MAX_VALUE) {
            return list.add(TstUtils.copyAmount((int)amount, itemStack));
        }
        long toAdd = amount;
        while (toAdd > Integer.MAX_VALUE) {
            list.add(TstUtils.copyAmount(Integer.MAX_VALUE, itemStack));
            toAdd -= Integer.MAX_VALUE;
        }
        return list.add(TstUtils.copyAmount((int)toAdd, itemStack));
    }

    public static boolean addStacksToList(@NotNull Collection<FluidStack> list, @NotNull FluidStack fluidStackStack, long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Code is trying to set item stack size a negative number.");
        }
        if (amount <= Integer.MAX_VALUE) {
            return list.add(TstUtils.copyAmount((int)amount, fluidStackStack));
        }
        long toAdd = amount;
        while (toAdd > Integer.MAX_VALUE) {
            list.add(TstUtils.copyAmount(Integer.MAX_VALUE, fluidStackStack));
            toAdd -= Integer.MAX_VALUE;
        }
        return list.add(TstUtils.copyAmount((int)toAdd, fluidStackStack));
    }

    public static ItemStack[] removeIntegratedCircuitFromStacks(ItemStack @Nullable [] itemStacks) {
        if (itemStacks == null) {
            return new ItemStack[0];
        }
        ArrayList<ItemStack> newStack = new ArrayList<ItemStack>();
        for (ItemStack itemStack : itemStacks) {
            if (itemStack == null || itemStack.func_77973_b() == ItemList.Circuit_Integrated.getItem()) continue;
            newStack.add(itemStack);
        }
        return newStack.toArray(new ItemStack[0]);
    }

    public static void setStringBlockXZ(IGregTechTileEntity aBaseMetaTileEntity, int OffSetX, int OffSetY, int OffSetZ, String[][] StructureString, boolean isStructureFlipped, String TargetString, Block TargetBlock, int TargetMeta) {
        int mDirectionX = aBaseMetaTileEntity.getFrontFacing().offsetX;
        int mDirectionZ = aBaseMetaTileEntity.getFrontFacing().offsetZ;
        int xDir = 0;
        int zDir = 0;
        if (mDirectionX == 1) {
            xDir = 1;
            zDir = 1;
        } else if (mDirectionX == -1) {
            xDir = -1;
            zDir = -1;
        }
        if (mDirectionZ == 1) {
            xDir = -1;
            zDir = 1;
        } else if (mDirectionZ == -1) {
            xDir = 1;
            zDir = -1;
        }
        int LengthX = StructureString[0][0].length();
        int LengthY = StructureString.length;
        int LengthZ = StructureString[0].length;
        for (int x = 0; x < LengthX; ++x) {
            for (int z = 0; z < LengthZ; ++z) {
                for (int y = 0; y < LengthY; ++y) {
                    String ListStr = String.valueOf(StructureString[y][z].charAt(x));
                    if (!Objects.equals(ListStr, TargetString)) continue;
                    int aX = (OffSetX - x) * xDir;
                    int aY = OffSetY - y;
                    int aZ = (OffSetZ - z) * zDir;
                    if (mDirectionX == 1 || mDirectionX == -1) {
                        int temp = aX;
                        aX = aZ;
                        aZ = temp;
                    }
                    if (isStructureFlipped) {
                        if (mDirectionX == 1 || mDirectionX == -1) {
                            aZ = -aZ;
                        } else {
                            aX = -aX;
                        }
                    }
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getXCoord() + aX, aBaseMetaTileEntity.getYCoord() + aY, aBaseMetaTileEntity.getZCoord() + aZ, TargetBlock, TargetMeta, 3);
                }
            }
        }
    }

    public static void setStringBlockXZ(IGregTechTileEntity aBaseMetaTileEntity, int OffSetX, int OffSetY, int OffSetZ, String[][] StructureString, boolean isStructureFlipped, String TargetString, Block TargetBlock) {
        TstUtils.setStringBlockXZ(aBaseMetaTileEntity, OffSetX, OffSetY, OffSetZ, StructureString, isStructureFlipped, TargetString, TargetBlock, 0);
    }

    @Nullable
    public static String getOreNameByOreList(ArrayList<ItemStack> oreList) {
        for (String oreName : OreDictionary.getOreNames()) {
            if (OreDictionary.getOres((String)oreName) != oreList) continue;
            return oreName;
        }
        return null;
    }

    public static void sendMessageKeyToPlayer(EntityPlayer player, String messageKey) {
        if (player instanceof EntityPlayerMP && messageKey != null) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation(messageKey, new Object[0]));
        }
    }

    public static void sendMessageKeyToPlayer(EntityPlayer player, String messageKey, Object ... formatArgs) {
        if (player instanceof EntityPlayerMP && messageKey != null) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation(messageKey, formatArgs));
        }
    }
}

