/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.util;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.structure.adders.IBlockAdder;
import com.gtnewhorizon.structurelib.structure.adders.ITileAdder;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TSTStructureUtility {
    private TSTStructureUtility() {
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> StructureDefinition.Builder<T> StructureDefinitionBuilder(Class<T> typeToken) {
        return StructureDefinition.builder();
    }

    @NotNull
    public static <T> IStructureElement<T> ofBlockStrict(Block block, int meta) {
        return TSTStructureUtility.ofBlockStrict(block, meta, block, meta);
    }

    @NotNull
    public static <T> IStructureElement<T> ofBlockStrict(final Block block, final int meta, final Block hintBlock, final int hintMeta) {
        if (block == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                return meta == world.func_72805_g(x, y, z) && block == world.func_147439_a(x, y, z);
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)hintBlock, (int)hintMeta);
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, block, meta, 2);
                if (this.check(t, world, x, y, z)) {
                    return true;
                }
                return world.func_147468_f(x, y, z);
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)block, (int)meta);
            }
        };
    }

    @NotNull
    public static <T> IStructureElement<T> ofBlockStrictExt(Block block, int meta, Block specialBlock, int specialItemMeta) {
        return TSTStructureUtility.ofBlockStrictExt(block, meta, TstUtils.newItemWithMeta(specialBlock, specialItemMeta), block, meta);
    }

    @NotNull
    public static <T> IStructureElement<T> ofBlockStrictExt(final Block block, final int meta, final ItemStack specialItemStack, final Block hintBlock, final int hintMeta) {
        if (block == null || hintBlock == null || specialItemStack == null) {
            throw new IllegalArgumentException();
        }
        if (specialItemStack.field_77994_a != 1) {
            throw new IllegalArgumentException("Wrong size of ItemStack.");
        }
        return new IStructureElement<T>(){
            private final ItemStack blockStack;
            {
                this.blockStack = TstUtils.newItemWithMeta(block, meta);
            }

            public boolean check(T t, World world, int x, int y, int z) {
                return meta == world.func_72805_g(x, y, z) && block == world.func_147439_a(x, y, z);
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)hintBlock, (int)hintMeta);
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, block, meta, 2);
                if (this.check(t, world, x, y, z)) {
                    return true;
                }
                return world.func_147468_f(x, y, z);
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)block, (int)meta);
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World w, int x, int y, int z, ItemStack trigger, IItemSource source, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                if (this.check(t, w, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return this.survivalPlaceBlock(t, w, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)source, (EntityPlayer)actor, chatter));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World w, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(t, w, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return TSTStructureUtility.survivalPlaceBlockWithSpecialItemStack(this, t, w, x, y, z, env, this.blockStack, specialItemStack);
            }
        };
    }

    @NotNull
    public static <T> IStructureElement<T> ofAccurateBlockAdder(final IBlockAdder<T> iBlockAdder, final Block block, final int meta) {
        if (iBlockAdder == null || block == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                return iBlockAdder.apply(t, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)block, (int)meta);
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, block, meta, 2);
                if (this.check(t, world, x, y, z)) {
                    return true;
                }
                return world.func_147468_f(x, y, z);
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)block, (int)meta);
            }
        };
    }

    @NotNull
    public static <T> IStructureElement<T> ofVariableBlock(final @Nullable String channel, final Block specificBlock, final int specificMeta, final List<ItemStack> variableStacks) {
        if (specificBlock == null || variableStacks == null) {
            throw new IllegalArgumentException();
        }
        if (variableStacks.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (channel != null && (channel.isEmpty() || !channel.toLowerCase(Locale.ROOT).equals(channel))) {
            throw new IllegalArgumentException();
        }
        final ItemStack blockStack = TstUtils.newItemWithMeta(specificBlock, specificMeta);
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                return specificMeta == world.func_72805_g(x, y, z) && specificBlock == world.func_147439_a(x, y, z);
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)specificBlock, (int)specificMeta);
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, specificBlock, specificMeta, 2);
                if (this.check(t, world, x, y, z)) {
                    return true;
                }
                return world.func_147468_f(x, y, z);
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((ItemStack[])variableStacks.toArray(new ItemStack[0]));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World w, int x, int y, int z, ItemStack trigger, IItemSource source, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                if (this.check(t, w, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return this.survivalPlaceBlock(t, w, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)source, (EntityPlayer)actor, chatter));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World w, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(t, w, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                IItemSource source = env.getSource();
                Consumer chatter = env.getChatter();
                if (source.takeOne(blockStack, true)) {
                    return StructureUtility.survivalPlaceBlock((ItemStack)blockStack, (ItemStackPredicate.NBTMode)ItemStackPredicate.NBTMode.EXACT, null, (boolean)true, (World)w, (int)x, (int)y, (int)z, (IItemSource)source, (EntityPlayer)env.getActor(), (Consumer)chatter);
                }
                if (channel == null || ChannelDataAccessor.hasSubChannel((ItemStack)trigger, (String)channel)) {
                    for (ItemStack stack : variableStacks) {
                        if (!source.takeOne(stack, true)) continue;
                        return TSTStructureUtility.survivalPlaceBlockWithSpecialItemStack(this, t, w, x, y, z, env, blockStack, stack);
                    }
                }
                if (chatter != null) {
                    chatter.accept(new ChatComponentTranslation("structurelib.autoplace.error.no_item_stack", new Object[]{blockStack.func_151000_E()}));
                }
                return IStructureElement.PlaceResult.REJECT;
            }
        };
    }

    @NotNull
    public static <T, E> IStructureElement<T> ofAccurateTile(Class<E> tileClass, Block tileBlock, int tileBlockMeta) {
        return TSTStructureUtility.ofAccurateTile(tileClass, tileBlock, tileBlockMeta, tileBlock, tileBlockMeta);
    }

    @NotNull
    public static <T, E> IStructureElement<T> ofAccurateTile(Class<E> tileClass, Block tileBlock, int tileBlockMeta, Block hintBlock, int hintMeta) {
        if (tileClass == null) {
            throw new IllegalArgumentException();
        }
        return TSTStructureUtility.ofAccurateTileAdder((a, b) -> tileClass.isInstance(b), tileBlock, tileBlockMeta, hintBlock, hintMeta);
    }

    @NotNull
    public static <T> IStructureElement<T> ofAccurateTileAdder(ITileAdder<T> iTileAdder, Block tileBlock, int tileBlockMeta) {
        return TSTStructureUtility.ofAccurateTileAdder(iTileAdder, tileBlock, tileBlockMeta, tileBlock, tileBlockMeta);
    }

    @NotNull
    public static <T> IStructureElement<T> ofAccurateTileAdder(final ITileAdder<T> iTileAdder, final Block tileBlock, final int tileBlockMeta, final Block hintBlock, final int hintMeta) {
        if (iTileAdder == null || tileBlock == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        if (!(Item.func_150898_a((Block)tileBlock) instanceof ItemBlock)) {
            throw new IllegalArgumentException("WrongType of tileBlock, must be an itemBlock.");
        }
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                return iTileAdder.apply(t, tileEntity);
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)hintBlock, (int)hintMeta);
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, tileBlock, tileBlockMeta, 2);
                return this.check(t, world, x, y, z);
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)tileBlock, (int)tileBlockMeta);
            }
        };
    }

    @NotNull
    public static <T, E> IStructureElement<T> ofAccurateTileExt(Class<E> tileClass, Block tileBlock, int tileBlockMeta, Item specialItem, int specialItemMeta) {
        if (tileClass == null) {
            throw new IllegalArgumentException();
        }
        return TSTStructureUtility.ofAccurateTileExt(tileClass, tileBlock, tileBlockMeta, TstUtils.newItemWithMeta(specialItem, specialItemMeta));
    }

    @NotNull
    public static <T, E> IStructureElement<T> ofAccurateTileExt(Class<E> tileClass, Block tileBlock, int tileBlockMeta, ItemStack specialItemStack) {
        if (tileClass == null) {
            throw new IllegalArgumentException();
        }
        return TSTStructureUtility.ofAccurateTileAdderExt((a, b) -> tileClass.isInstance(b), tileBlock, tileBlockMeta, specialItemStack, tileBlock, tileBlockMeta);
    }

    @NotNull
    public static <T> IStructureElement<T> ofAccurateTileAdderExt(final ITileAdder<T> iTileAdder, final Block tileBlock, final int tileBlockMeta, final ItemStack specialItemStack, final Block hintBlock, final int hintMeta) {
        if (iTileAdder == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        if (tileBlock == null || specialItemStack == null) {
            throw new NullPointerException();
        }
        if (specialItemStack.field_77994_a != 1) {
            throw new IllegalArgumentException("Wrong size of ItemStack.");
        }
        if (!(Item.func_150898_a((Block)tileBlock) instanceof ItemBlock)) {
            throw new IllegalArgumentException("WrongType of tileBlock, must be an itemBlock.");
        }
        return new IStructureElement<T>(){
            private final ItemStack blockStack;
            {
                this.blockStack = new ItemStack(tileBlock, 1, tileBlockMeta);
            }

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                return iTileAdder.apply(t, tileEntity);
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)hintBlock, (int)hintMeta);
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, tileBlock, tileBlockMeta, 2);
                return this.check(t, world, x, y, z);
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((ItemStack)this.blockStack);
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World w, int x, int y, int z, ItemStack trigger, IItemSource source, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                if (this.check(t, w, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return this.survivalPlaceBlock(t, w, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)source, (EntityPlayer)actor, chatter));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World w, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(t, w, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return TSTStructureUtility.survivalPlaceBlockWithSpecialItemStack(this, t, w, x, y, z, env, this.blockStack, specialItemStack);
            }
        };
    }

    protected static <T> IStructureElement.PlaceResult survivalPlaceBlockWithSpecialItemStack(IStructureElement<T> iStructureElement, T t, World world, int x, int y, int z, AutoPlaceEnvironment env, ItemStack blockStack, ItemStack specialItemStack) {
        EntityPlayer actor = env.getActor();
        IItemSource source = env.getSource();
        Consumer chatter = env.getChatter();
        if (!StructureLibAPI.isBlockTriviallyReplaceable((World)world, (int)x, (int)y, (int)z, (EntityPlayer)actor)) {
            return IStructureElement.PlaceResult.REJECT;
        }
        if (!source.takeOne(specialItemStack, true)) {
            if (chatter != null) {
                chatter.accept(new ChatComponentTranslation("structurelib.autoplace.error.no_item_stack", new Object[]{specialItemStack.func_151000_E()}));
            }
            return IStructureElement.PlaceResult.REJECT;
        }
        if (!blockStack.func_77946_l().func_77943_a(actor, world, x, y, z, ForgeDirection.UP.ordinal(), 0.5f, 0.5f, 0.5f)) {
            return IStructureElement.PlaceResult.REJECT;
        }
        if (!iStructureElement.check(t, world, x, y, z)) {
            return IStructureElement.PlaceResult.REJECT;
        }
        if (!source.takeOne(specialItemStack, false)) {
            world.func_147468_f(x, y, z);
            TwistSpaceTechnology.LOG.error("An error occurred with a placed block, specialItemStack: {}", new Object[]{specialItemStack});
            return IStructureElement.PlaceResult.REJECT;
        }
        return IStructureElement.PlaceResult.ACCEPT;
    }
}

