/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.util;

import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.items.ActivationCrystal;
import WayofTime.alchemicalWizardry.common.items.BloodShard;
import com.Nxer.TwistSpaceTechnology.config.Config;
import fox.spiteful.avaritia.items.LudicrousItems;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class BloodMagicHelper {
    public static boolean isCreativeOrb(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() == LudicrousItems.armok_orb && Config.Enable_BloodHatch_Armok_InfiniteDrain;
    }

    @Nullable
    public static String getOrbOwnerName(@Nullable ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof IBloodOrb)) {
            return null;
        }
        NBTTagCompound nbtTag = stack.func_77978_p();
        if (nbtTag == null) {
            return null;
        }
        String ownerName = nbtTag.func_74779_i("ownerName");
        return ownerName.isEmpty() ? null : ownerName;
    }

    public static int getOrbCapacity(@Nullable ItemStack stack) {
        Item item;
        if (stack != null && (item = stack.func_77973_b()) instanceof IBloodOrb) {
            IBloodOrb orb = (IBloodOrb)item;
            return SoulNetworkHandler.getMaximumForOrbTier((int)orb.getOrbLevel());
        }
        return -1;
    }

    public static int getBloodOrbTier(@Nullable ItemStack stack) {
        Item item;
        if (stack != null && (item = stack.func_77973_b()) instanceof IBloodOrb) {
            IBloodOrb orb = (IBloodOrb)item;
            return orb.getOrbLevel();
        }
        return 0;
    }

    public static int getOrbOwnerLpAmount(@Nullable ItemStack stack) {
        String ownerName = BloodMagicHelper.getOrbOwnerName(stack);
        if (ownerName != null) {
            return SoulNetworkHandler.getCurrentEssence((String)ownerName);
        }
        return 0;
    }

    public static int getBloodShardTier(@Nullable ItemStack stack) {
        Item item;
        if (stack != null && (item = stack.func_77973_b()) instanceof BloodShard) {
            BloodShard shard = (BloodShard)item;
            return shard.getBloodShardLevel();
        }
        return 0;
    }

    public static int getActivationCrystalTier(@Nullable ItemStack stack) {
        Item item;
        if (stack != null && (item = stack.func_77973_b()) instanceof ActivationCrystal) {
            ActivationCrystal crystal = (ActivationCrystal)item;
            return crystal.getCrystalLevel(stack);
        }
        return 0;
    }

    @Nullable
    public static FluidStack getLifeEssence(int amount) {
        return FluidUtils.getFluidStack((String)"lifeessence", (int)amount);
    }

    public static int addBloodToNetwork(String ownerName, int lpAmount) {
        int maxOrb = SoulNetworkHandler.getMaximumForOrbTier((int)SoulNetworkHandler.getCurrentMaxOrb((String)ownerName));
        return SoulNetworkHandler.addCurrentEssenceToMaximum((String)ownerName, (int)lpAmount, (int)maxOrb);
    }

    public static int addBloodToNetwork(ItemStack orbStack, int lpAmount) {
        String ownerName = BloodMagicHelper.getOrbOwnerName(orbStack);
        if (ownerName != null) {
            return BloodMagicHelper.addBloodToNetwork(ownerName, lpAmount);
        }
        return 0;
    }
}

