/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.ExtremeCrafting;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.api.OreDictItem;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.recipeMapFrontends.TST_GeneralFrontend;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.system.ExtremeCrafting.ExtremeCraftRecipe;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import fox.spiteful.avaritia.crafting.ExtremeCraftingManager;
import fox.spiteful.avaritia.crafting.ExtremeShapedOreRecipe;
import fox.spiteful.avaritia.crafting.ExtremeShapedRecipe;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapBuilder;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ExtremeCraftRecipeHandler {
    public static final RecipeMap<RecipeMapBackend> visualExtremeCraftRecipes = RecipeMapBuilder.of((String)"gtcm.recipe.visualExtremeCraftRecipes").maxIO(16, 1, 0, 0).progressBar(GTUITextures.PROGRESSBAR_ARROW_MULTIPLE).frontend(TST_GeneralFrontend::new).neiHandlerInfo(builder -> builder.setDisplayStack(GTCMItemList.ExtremeCraftCenter.get(1, new Object[0])).setMaxRecipesPerPage(1)).build();
    public static final Collection<ExtremeCraftRecipe> extremeCraftRecipes = new ArrayList<ExtremeCraftRecipe>();
    public static final Map<TST_ItemID, Collection<ExtremeCraftRecipe>> extremeCraftRecipesMap = new HashMap<TST_ItemID, Collection<ExtremeCraftRecipe>>();

    public static ItemStack mergeStackSize(ItemStack a, ItemStack b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        a.field_77994_a += b.field_77994_a;
        return a;
    }

    protected ItemStack[] sortOutInputs(ItemStack ... in) {
        LinkedHashMap<TST_ItemID, ItemStack> inputsMap = new LinkedHashMap<TST_ItemID, ItemStack>();
        for (ItemStack is : in) {
            if (is == null || is.field_77994_a < 1) continue;
            TST_ItemID itemID = TST_ItemID.create(is);
            inputsMap.merge(itemID, is.func_77946_l(), ExtremeCraftRecipeHandler::mergeStackSize);
        }
        return inputsMap.values().toArray(new ItemStack[0]);
    }

    protected Object[] sortOutInputs(Object ... in) {
        LinkedHashMap<Object, Integer> inputsMap = new LinkedHashMap<Object, Integer>();
        for (Object o : in) {
            if (o == null) continue;
            inputsMap.merge(o, 1, Integer::sum);
        }
        ArrayList<Object> sorted = new ArrayList<Object>();
        for (Map.Entry pair : inputsMap.entrySet()) {
            Object ingredient = pair.getKey();
            if (ingredient instanceof ItemStack) {
                ItemStack i = (ItemStack)ingredient;
                sorted.add(GTUtility.copyAmountUnsafe((int)((Integer)pair.getValue()), (ItemStack)i));
                continue;
            }
            if (ingredient instanceof ArrayList) {
                ArrayList list = (ArrayList)ingredient;
                ArrayList itemList = list;
                String oreName = TstUtils.getOreNameByOreList(itemList);
                if (oreName != null) {
                    sorted.add(new Object[]{oreName, pair.getValue()});
                    continue;
                }
                ItemStack firstValidItem = itemList.stream().filter(GTUtility::isStackValid).findFirst().orElse(null);
                if (firstValidItem == null) {
                    throw new IllegalArgumentException();
                }
                ItemStack unifiedItem = GTOreDictUnificator.get((boolean)false, (ItemStack)firstValidItem, (boolean)true);
                sorted.add(GTUtility.copyAmountUnsafe((int)((Integer)pair.getValue()), (ItemStack)unifiedItem));
                continue;
            }
            TwistSpaceTechnology.LOG.info("ERROR ExtremeCraftRecipeHandler.sortOutInputs catch unknown type");
        }
        return sorted.toArray(new Object[0]);
    }

    ItemStack createItemStack(String aModID, String aItem, long aAmount, int aMeta, String aNBTString) {
        ItemStack s = GTModHandler.getModItem((String)aModID, (String)aItem, (long)aAmount, (int)aMeta);
        try {
            s.field_77990_d = (NBTTagCompound)JsonToNBT.func_150315_a((String)aNBTString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return s;
    }

    public void initECRecipe() {
        List originRecipes = ExtremeCraftingManager.getInstance().getRecipeList();
        TwistSpaceTechnology.LOG.info("start init extreme craft table recipe :" + originRecipes.size());
        OreDictItem odi = new OreDictItem("cropSpace");
        OreDictItem.UsedOreDictItems.put("cropSpace", odi);
        OreDictItem.UsedOreDictItems.put("cropTcetiESeaweed", odi);
        for (IRecipe Recipe : originRecipes) {
            Object[] inputs = null;
            ItemStack output = null;
            if (Recipe instanceof ExtremeShapedRecipe) {
                ExtremeShapedRecipe recipe = (ExtremeShapedRecipe)Recipe;
                inputs = this.sortOutInputs(recipe.recipeItems);
                output = recipe.func_77571_b();
            } else if (Recipe instanceof ExtremeShapedOreRecipe) {
                ExtremeShapedOreRecipe recipe = (ExtremeShapedOreRecipe)Recipe;
                inputs = this.sortOutInputs(recipe.getInput());
                output = recipe.func_77571_b();
            } else if (Recipe instanceof ShapelessOreRecipe) {
                ShapelessOreRecipe recipe = (ShapelessOreRecipe)Recipe;
                inputs = this.sortOutInputs(recipe.getInput().toArray());
                output = recipe.func_77571_b();
            }
            if (inputs != null && output != null) {
                GTRecipeBuilder builder = GTValues.RA.stdBuilder().ignoreCollision().itemInputs(inputs).itemOutputs(new ItemStack[]{output}).eut(0).duration(Config.TickEveryProcess_MegaCraftingCenter);
                Optional oRecipe = builder.buildWithAlt();
                if (oRecipe.isPresent()) {
                    visualExtremeCraftRecipes.add((GTRecipe)oRecipe.get());
                } else {
                    builder.addTo(visualExtremeCraftRecipes);
                }
                ExtremeCraftRecipe ecr = new ExtremeCraftRecipe().itemInputs(inputs).itemOutputs(output);
                extremeCraftRecipes.add(ecr);
                TST_ItemID oi = TST_ItemID.create(output);
                if (extremeCraftRecipesMap.containsKey((Object)oi)) {
                    extremeCraftRecipesMap.get((Object)oi).add(ecr);
                    continue;
                }
                HashSet<ExtremeCraftRecipe> s = new HashSet<ExtremeCraftRecipe>();
                s.add(ecr);
                extremeCraftRecipesMap.put(oi, s);
                continue;
            }
            TwistSpaceTechnology.LOG.info("ExtremeCraftRecipeHandler get a null recipe.");
        }
        TwistSpaceTechnology.LOG.info("complete init extreme craft table recipe :" + extremeCraftRecipes.size());
    }
}

