/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic_t;

import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic_t.Galaxy;
import net.minecraft.nbt.NBTTagCompound;

public class DysonSphereSystem {
    public static final DysonSphereSystem Unknown = new DysonSphereSystem();
    public static final int solarSailPowerPoint = 1000;
    private static final String Tag_owner = "owner";
    private static final String Tag_NodeCount = "nodes";
    private static final String Tag_SailCount = "sails";
    private static final String Tag_GalaxyName = "galaxy";
    private final Galaxy galaxy;
    private String ownedTeam;
    private long solarSailCount;
    private long nodeCount;
    private long usedPowerPoints = 0L;
    private long maxPowerPoints = 0L;
    private boolean hasChanged = true;

    private DysonSphereSystem() {
        this.galaxy = Galaxy.Unknown;
        this.ownedTeam = "null";
        this.solarSailCount = 0L;
        this.nodeCount = 0L;
    }

    public DysonSphereSystem(String owner, Galaxy galaxy) {
        this(owner, galaxy, 0L, 0L);
    }

    public DysonSphereSystem(String owner, Galaxy galaxy, long solarSails, long nodes) {
        this.galaxy = galaxy;
        this.ownedTeam = owner;
        this.solarSailCount = solarSails;
        this.nodeCount = nodes;
        galaxy.addSystem(this);
    }

    public static DysonSphereSystem readFromNBT(NBTTagCompound compound) {
        Galaxy in = Galaxy.getGalaxyFromName(compound.func_74779_i(Tag_GalaxyName));
        if (in == Galaxy.Unknown) {
            return Unknown;
        }
        return new DysonSphereSystem(compound.func_74779_i(Tag_owner), in, compound.func_74763_f(Tag_SailCount), compound.func_74763_f(Tag_NodeCount));
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74772_a(Tag_SailCount, this.solarSailCount);
        compound.func_74772_a(Tag_NodeCount, this.nodeCount);
        compound.func_74778_a(Tag_GalaxyName, this.galaxy.name);
        compound.func_74778_a(Tag_owner, this.ownedTeam);
        return compound;
    }

    public boolean tryReleasePoints(long amount) {
        if (this.usedPowerPoints < amount) {
            return false;
        }
        this.usedPowerPoints -= amount;
        return true;
    }

    public boolean tryOccupyPoints(long amount) {
        if (amount > this.getSparePoints()) {
            return false;
        }
        this.usedPowerPoints += amount;
        return true;
    }

    public void forceReleasePoints(long amount) {
        this.usedPowerPoints = Math.max(0L, this.usedPowerPoints - amount);
    }

    public void setUsedPoints(long points) {
        this.usedPowerPoints = points;
    }

    public void addNode(long amount) {
        this.nodeCount += amount;
        this.hasChanged = true;
    }

    public DysonSphereSystem addSail(long amount) {
        this.solarSailCount += amount;
        this.hasChanged = true;
        return this;
    }

    public String toString() {
        return "DSP_DataCell{ ownerName:" + this.ownedTeam + " , galaxy:" + this.galaxy + " , amountDSPSolarSail:" + this.solarSailCount + " , amountDSPNode:" + this.nodeCount + " , maxDSPPowerPoint:" + this.getMaxPoints() + " , usedDSPPowerPoint:" + this.usedPowerPoints + " , PowerPointCanUse: " + this.getSparePoints() + " }";
    }

    private void refreshMaxPoints() {
        this.maxPowerPoints = (long)((double)(1000L * this.solarSailCount) * Math.sqrt(this.nodeCount + 1L));
        this.hasChanged = false;
    }

    public long getMaxPoints() {
        if (this.hasChanged) {
            this.refreshMaxPoints();
        }
        return this.maxPowerPoints;
    }

    public long getSparePoints() {
        return this.getMaxPoints() - this.usedPowerPoints;
    }

    public String getOwnerTeam() {
        return this.ownedTeam;
    }

    public void setOwner(String teamName) {
        this.ownedTeam = teamName;
    }

    public Galaxy getGalaxyIn() {
        return this.galaxy;
    }

    public long countNodes() {
        return this.nodeCount;
    }

    public DysonSphereSystem setNodes(long nodeCount) {
        this.nodeCount = nodeCount;
        return this;
    }

    public long countSolarSail() {
        return this.solarSailCount;
    }

    public DysonSphereSystem setSolarSails(long solarSailCount) {
        this.solarSailCount = solarSailCount;
        return this;
    }

    public void doUpdate() {
    }
}

