/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_DataCell;
import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_DataStorageMaps;
import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_Galaxy;
import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_Planet;
import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_WorldSavedData;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import java.util.HashMap;

public interface IDSP_IO {
    default public void joinUserTeam(String userUUID, String userUUIDTeam) {
        DSP_DataStorageMaps.DSP_TeamName.put(userUUID, this.getOrInitTeamName(userUUIDTeam));
    }

    default public DSP_DataCell getOrInitDSPData(String userName, int dimID) {
        HashMap<DSP_Galaxy, DSP_DataCell> currentDysonSphereMap;
        String teamName = this.getOrInitTeamName(userName);
        DSP_Galaxy currentGalaxy = DSP_Galaxy.getGalaxyFromDimID(dimID);
        if (!DSP_DataStorageMaps.DysonSpheres.containsKey(teamName)) {
            HashMap DysonSphereMap = new HashMap();
            DSP_DataStorageMaps.DysonSpheres.put(teamName, DysonSphereMap);
            this.dataMarkDirty();
        }
        if (!(currentDysonSphereMap = DSP_DataStorageMaps.DysonSpheres.get(teamName)).containsKey(currentGalaxy)) {
            DSP_DataCell dataCell = new DSP_DataCell(teamName, currentGalaxy);
            currentDysonSphereMap.put(currentGalaxy, dataCell);
            this.dataMarkDirty();
        }
        return currentDysonSphereMap.get(currentGalaxy);
    }

    default public DSP_DataCell getDSPDataCellWithoutCheck(String teamName, int dimID) {
        return DSP_DataStorageMaps.DysonSpheres.get(teamName).get(DSP_Planet.getPlanetFromDimID((int)dimID).dependentGalaxy);
    }

    default public DSP_DataCell setDSPSolarSail(long amountSolarSail, String teamName, int dimID) {
        return this.getDSPDataCellWithoutCheck(teamName, dimID).setDSPSolarSail(amountSolarSail);
    }

    default public DSP_DataCell setDSPSolarSail(long amountSolarSail, DSP_DataCell dataCell) {
        return dataCell.setDSPSolarSail(amountSolarSail);
    }

    default public DSP_DataCell setDSPNode(long amountNode, String teamName, int dimID) {
        return this.getDSPDataCellWithoutCheck(teamName, dimID).setDSPNode(amountNode);
    }

    default public DSP_DataCell setDSPNode(long amountNode, DSP_DataCell dataCell) {
        return dataCell.setDSPNode(amountNode);
    }

    default public DSP_DataCell addDSPSolarSail(long amountSolarSail, String teamName, int dimID) {
        return this.getDSPDataCellWithoutCheck(teamName, dimID).addDSPSolarSail(amountSolarSail);
    }

    default public int getDimID(IHasWorldObjectAndCoords aBaseMetaTileEntity) {
        return aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g;
    }

    default public String getOwnerNameAndInitMachine(IGregTechTileEntity aBaseMetaTileEntity) {
        String ownerName = aBaseMetaTileEntity.getOwnerName();
        String ownerUUID = aBaseMetaTileEntity.getOwnerUuid().toString();
        if (DSP_DataStorageMaps.UUID_Name.isEmpty() || !DSP_DataStorageMaps.UUID_Name.containsKey(ownerName) || !DSP_DataStorageMaps.UUID_Name.containsKey(ownerUUID)) {
            DSP_DataStorageMaps.UUID_Name.put(ownerName, ownerUUID);
            DSP_DataStorageMaps.UUID_Name.put(ownerUUID, ownerName);
            this.dataMarkDirty();
        }
        return ownerName;
    }

    default public String getOrInitTeamName(String aUserName) {
        if (DSP_DataStorageMaps.DSP_TeamName.containsKey(aUserName)) {
            return DSP_DataStorageMaps.DSP_TeamName.get(aUserName);
        }
        DSP_DataStorageMaps.DSP_TeamName.put(aUserName, aUserName);
        this.dataMarkDirty();
        return aUserName;
    }

    default public void dataMarkDirty() {
        try {
            DSP_WorldSavedData.INSTANCE.func_76185_a();
        }
        catch (Exception e) {
            TwistSpaceTechnology.LOG.info("try DSP_WorldSavedData.INSTANCE.markDirty() FAILED!");
            e.printStackTrace();
        }
    }
}

