/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_Galaxy;
import java.io.Serializable;

public enum DSP_Planet implements Serializable
{
    OverWorld(0, 1.0, DSP_Galaxy.SolarSystem),
    TheEnd(1, 1.07, DSP_Galaxy.SolarSystem),
    Miranda(86, 0.45, DSP_Galaxy.SolarSystem),
    Haumea(83, 0.18, DSP_Galaxy.SolarSystem),
    Pluto(49, 0.2, DSP_Galaxy.SolarSystem),
    Triton(48, 0.35, DSP_Galaxy.SolarSystem),
    Proteus(47, 0.33, DSP_Galaxy.SolarSystem),
    Oberon(46, 0.44, DSP_Galaxy.SolarSystem),
    Callisto(45, 0.67, DSP_Galaxy.SolarSystem),
    Titan(44, 0.56, DSP_Galaxy.SolarSystem),
    Ganymede(43, 0.66, DSP_Galaxy.SolarSystem),
    Ceres(42, 0.7, DSP_Galaxy.SolarSystem),
    Enceladus(41, 0.55, DSP_Galaxy.SolarSystem),
    Deimos(40, 1.01, DSP_Galaxy.SolarSystem),
    Venus(39, 1.6, DSP_Galaxy.SolarSystem),
    Phobos(38, 1.01, DSP_Galaxy.SolarSystem),
    Mercury(37, 2.3, DSP_Galaxy.SolarSystem),
    Io(36, 0.66, DSP_Galaxy.SolarSystem),
    Europa(35, 0.66, DSP_Galaxy.SolarSystem),
    KuiperBelt(33, 0.1, DSP_Galaxy.SolarSystem),
    Asteroids(30, 0.7, DSP_Galaxy.SolarSystem),
    Mars(29, 1.01, DSP_Galaxy.SolarSystem),
    Moon(28, 1.3, DSP_Galaxy.SolarSystem),
    Makemake(25, 0.09, DSP_Galaxy.SolarSystem),
    TwilightForest(7, 1.0, DSP_Galaxy.SolarSystem),
    Ross128b(64, 1.0, DSP_Galaxy.Ross128),
    Ross128ba(63, 1.3, DSP_Galaxy.Ross128),
    BarnardaF(82, 0.8, DSP_Galaxy.Barnarda),
    BarnardaE(81, 0.9, DSP_Galaxy.Barnarda),
    BarnardaC(32, 1.5, DSP_Galaxy.Barnarda),
    VegaB(84, 2.6, DSP_Galaxy.Vega),
    TCetiE(85, 1.1, DSP_Galaxy.TCeti),
    CentauriBb(31, 2.2, DSP_Galaxy.CentauriB),
    Seth(94, 0.79, DSP_Galaxy.AmunRa),
    Horus(93, 2.9, DSP_Galaxy.AmunRa),
    Anubis(92, 0.66, DSP_Galaxy.AmunRa),
    Maahes(91, 0.77, DSP_Galaxy.AmunRa),
    Neper(90, 1.15, DSP_Galaxy.AmunRa),
    MehenBelt(95, 0.8, DSP_Galaxy.AmunRa),
    DSP_Planet_NULL(-114, 0.0, DSP_Galaxy.DSP_Galaxy_NULL);

    public int dimensionID;
    public final double planetaryCoefficient;
    public final DSP_Galaxy dependentGalaxy;

    private DSP_Planet(int dimID, double planetaryCoefficient, DSP_Galaxy dependentGalaxy) {
        this.dimensionID = dimID;
        this.planetaryCoefficient = planetaryCoefficient;
        this.dependentGalaxy = dependentGalaxy;
    }

    public DSP_Planet setDimensionID(int dimID) {
        this.dimensionID = dimID;
        return this;
    }

    public static double getPlanetaryCoefficientWithDimID(int dimID) {
        if (dimID >= 180 && dimID != 227) {
            return DSP_Planet.OverWorld.planetaryCoefficient;
        }
        for (DSP_Planet planet : DSP_Planet.values()) {
            if (planet.dimensionID != dimID) continue;
            return planet.planetaryCoefficient;
        }
        return 0.0;
    }

    public static DSP_Planet getPlanetFromDimID(int dimID) {
        if (dimID >= 180 && dimID != 227) {
            return OverWorld;
        }
        for (DSP_Planet planet : DSP_Planet.values()) {
            if (planet.dimensionID != dimID) continue;
            return planet;
        }
        return DSP_Planet_NULL;
    }

    public static DSP_Galaxy getGalaxyFromDimID(int dimID) {
        TwistSpaceTechnology.LOG.info((Object)DSP_Planet.getPlanetFromDimID((int)dimID).dependentGalaxy);
        return DSP_Planet.getPlanetFromDimID((int)dimID).dependentGalaxy;
    }

    public static void readDimIDFromGSCfg() {
    }
}

