/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic;

import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_Planet;
import java.io.Serializable;

public enum DSP_Galaxy implements Serializable
{
    SolarSystem(1.0, DSP_Planet.OverWorld, DSP_Planet.TheEnd, DSP_Planet.Miranda, DSP_Planet.Haumea, DSP_Planet.Pluto, DSP_Planet.Triton, DSP_Planet.Proteus, DSP_Planet.Oberon, DSP_Planet.Callisto, DSP_Planet.Titan, DSP_Planet.Ganymede, DSP_Planet.Ceres, DSP_Planet.Enceladus, DSP_Planet.Deimos, DSP_Planet.Venus, DSP_Planet.Phobos, DSP_Planet.Mercury, DSP_Planet.Io, DSP_Planet.Europa, DSP_Planet.KuiperBelt, DSP_Planet.Asteroids, DSP_Planet.Mars, DSP_Planet.Moon, DSP_Planet.Makemake, DSP_Planet.TwilightForest),
    Ross128(0.4, DSP_Planet.Ross128b, DSP_Planet.Ross128ba),
    Barnarda(0.851, DSP_Planet.BarnardaC, DSP_Planet.BarnardaE, DSP_Planet.BarnardaF),
    Vega(2.98, DSP_Planet.VegaB),
    TCeti(1.9, DSP_Planet.TCetiE),
    CentauriB(2.3, DSP_Planet.CentauriBb),
    AmunRa(0.9, DSP_Planet.Seth, DSP_Planet.Horus, DSP_Planet.Anubis, DSP_Planet.Maahes, DSP_Planet.Neper, DSP_Planet.MehenBelt),
    DSP_Galaxy_NULL(0.0, DSP_Planet.DSP_Planet_NULL);

    public final DSP_Planet[] containedPlanets;
    public final double stellarCoefficient;

    private DSP_Galaxy(double stellarCoefficient, DSP_Planet ... containedPlanets) {
        this.stellarCoefficient = stellarCoefficient;
        this.containedPlanets = containedPlanets;
    }

    private DSP_Galaxy() {
        this.containedPlanets = new DSP_Planet[]{DSP_Planet.OverWorld};
        this.stellarCoefficient = 0.0;
    }

    public DSP_Planet[] getContainedDimensions() {
        return this.containedPlanets;
    }

    public boolean isContainedDim(int dimID) {
        for (DSP_Planet dim : this.containedPlanets) {
            if (dim.dimensionID != dimID) continue;
            return true;
        }
        return false;
    }

    public static DSP_Galaxy getGalaxyFromDimID(int dimID) {
        if (dimID >= 180 && dimID != 227) {
            return SolarSystem;
        }
        for (DSP_Galaxy galaxy : DSP_Galaxy.values()) {
            if (!galaxy.isContainedDim(dimID)) continue;
            return galaxy;
        }
        return DSP_Galaxy_NULL;
    }
}

