/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_Galaxy;
import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_Values;
import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_WorldSavedData;
import gregtech.api.util.GTUtility;
import java.io.Serializable;
import java.math.BigInteger;
import net.minecraft.util.EnumChatFormatting;

public class DSP_DataCell
implements Serializable {
    private String ownerName;
    private DSP_Galaxy galaxy;
    private long amountDSPSolarSail;
    private long amountDSPNode;
    private boolean dirty;
    private long maxDSPPowerPoint;
    private long usedDSPPowerPoint;
    private byte dataSyncFlag = 0;
    private boolean useBigInteger = false;
    private BigInteger maxDSPPowerPoint_BigInteger = BigInteger.valueOf(0L);
    private BigInteger usedDSPPowerPoint_BigInteger = BigInteger.valueOf(0L);
    public static final BigInteger LongMaxValue_BigInteger = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger NEGATIVE_ONE = BigInteger.valueOf(-1L);

    public DSP_DataCell(String ownerName, DSP_Galaxy galaxy) {
        this.ownerName = ownerName;
        this.galaxy = galaxy;
        this.amountDSPSolarSail = 0L;
        this.amountDSPNode = 0L;
        this.dirty = true;
        this.maxDSPPowerPoint = 0L;
        this.usedDSPPowerPoint = 0L;
    }

    public DSP_DataCell() {
        this.ownerName = "defaultPlayerWithErrorInformation";
        this.galaxy = DSP_Galaxy.DSP_Galaxy_NULL;
        this.amountDSPNode = 0L;
        this.amountDSPSolarSail = 0L;
        this.dirty = true;
        this.maxDSPPowerPoint = 0L;
        this.usedDSPPowerPoint = 0L;
    }

    public long getSolarSailToDelete() {
        return Math.max(0L, this.amountDSPSolarSail - this.amountDSPNode * DSP_Values.solarSailCanHoldPerNode - DSP_Values.solarSailCanHoldDefault);
    }

    public long getDSPPowerPointCanUse() {
        if (this.useBigInteger) {
            BigInteger canUse = this.getDSPPowerPointCanUseBigInteger();
            if (canUse.compareTo(LongMaxValue_BigInteger) >= 0) {
                return Long.MAX_VALUE;
            }
            return canUse.longValue();
        }
        return this.getMaxDSPPowerPoint() - this.usedDSPPowerPoint;
    }

    public BigInteger getDSPPowerPointCanUseBigInteger() {
        return this.maxDSPPowerPoint_BigInteger.add(BigInteger.valueOf(-1L).multiply(this.usedDSPPowerPoint_BigInteger));
    }

    public boolean tryDecreaseUsedPowerPoint(long amount) {
        if (this.useBigInteger) {
            BigInteger amountBig = BigInteger.valueOf(amount);
            if (this.usedDSPPowerPoint_BigInteger.compareTo(amountBig) >= 0) {
                this.markDirty();
                DSP_WorldSavedData.markDataDirty();
                this.usedDSPPowerPoint_BigInteger = this.usedDSPPowerPoint_BigInteger.add(amountBig.multiply(NEGATIVE_ONE));
                return true;
            }
            TwistSpaceTechnology.LOG.info("Error ! Trying decrease an amount larger than used DSP Power Point !");
            TwistSpaceTechnology.LOG.info("Trying amount: " + amount + " ; Used point: " + this.usedDSPPowerPoint_BigInteger.toString() + " ;");
            TwistSpaceTechnology.LOG.info("Please check your Dyson Sphere Program information use command: /tst dsp_check ");
            return false;
        }
        if (this.usedDSPPowerPoint >= amount) {
            this.markDirty().usedDSPPowerPoint -= amount;
            DSP_WorldSavedData.markDataDirty();
            return true;
        }
        TwistSpaceTechnology.LOG.info("Error ! Trying decrease an amount larger than used DSP Power Point !");
        TwistSpaceTechnology.LOG.info("Trying amount: " + amount + " ; Used point: " + this.usedDSPPowerPoint + " ;");
        TwistSpaceTechnology.LOG.info("Please check your Dyson Sphere Program information use command: /tst dsp_check ");
        return false;
    }

    public boolean tryUsePowerPoint(long amount) {
        if (this.canUsePowerPoint(amount)) {
            DSP_WorldSavedData.markDataDirty();
            this.markDirty();
            if (this.useBigInteger) {
                this.usedDSPPowerPoint_BigInteger = this.usedDSPPowerPoint_BigInteger.add(BigInteger.valueOf(amount));
            } else {
                this.usedDSPPowerPoint += amount;
            }
            return true;
        }
        return false;
    }

    public boolean canUsePowerPoint(long amount) {
        return amount <= this.getDSPPowerPointCanUse();
    }

    public boolean decreaseUsedPowerPointUnsafely(long amount) {
        DSP_WorldSavedData.markDataDirty();
        if (this.tryDecreaseUsedPowerPoint(amount)) {
            return true;
        }
        this.markDirty().usedDSPPowerPoint -= amount;
        return false;
    }

    public DSP_DataCell setUsedPowerPointUnsafely(long amount) {
        this.markDirty().usedDSPPowerPoint = amount;
        DSP_WorldSavedData.markDataDirty();
        TwistSpaceTechnology.LOG.info("Set 0 to UsedPowerPoint Unsafely at: " + this);
        return this;
    }

    public DSP_DataCell setUsedPowerPointUnsafely(BigInteger amount) {
        this.markDirty().usedDSPPowerPoint_BigInteger = amount;
        DSP_WorldSavedData.markDataDirty();
        TwistSpaceTechnology.LOG.info("Set 0 to UsedPowerPoint Unsafely at: " + this);
        return this;
    }

    public DSP_DataCell flushMaxDSPPowerPoint() {
        this.markDirty().cancelDirty();
        if (this.useBigInteger) {
            this.flushMaxDSPPowerPointBigInteger();
        } else if (this.shouldUseBigInteger()) {
            this.turnToBigIntegerMode();
        } else {
            this.flushMaxDSPPowerPointNormal();
        }
        return this;
    }

    public DSP_DataCell turnToBigIntegerMode() {
        this.useBigInteger = true;
        this.flushMaxDSPPowerPointBigInteger();
        this.usedDSPPowerPoint_BigInteger = BigInteger.valueOf(this.usedDSPPowerPoint);
        return this;
    }

    public DSP_DataCell flushMaxDSPPowerPointNormal() {
        this.setMaxDSPPowerPoint((long)((double)(DSP_Values.solarSailPowerPoint * this.amountDSPSolarSail) * Math.pow(this.amountDSPNode + 1L, 0.8)));
        return this;
    }

    public DSP_DataCell flushMaxDSPPowerPointBigInteger() {
        this.setMaxDSPPowerPoint(BigInteger.valueOf(this.amountDSPSolarSail).multiply(Config.solarSailPowerPoint_BigInteger).multiply(BigInteger.valueOf((long)Math.ceil(Math.pow(this.amountDSPNode + 1L, 0.8)))));
        return this;
    }

    public boolean shouldUseBigInteger() {
        if (this.amountDSPSolarSail < 1L || this.amountDSPNode < 1L) {
            return false;
        }
        return (double)(Long.MAX_VALUE / DSP_Values.solarSailPowerPoint / this.amountDSPSolarSail - 1L) <= Math.pow(this.amountDSPNode + 1L, 0.8);
    }

    public long getMaxDSPPowerPoint() {
        if (this.dirty) {
            this.flushMaxDSPPowerPoint();
        }
        if (this.useBigInteger) {
            if (this.maxDSPPowerPoint_BigInteger.compareTo(LongMaxValue_BigInteger) >= 0) {
                return Long.MAX_VALUE;
            }
            return this.maxDSPPowerPoint_BigInteger.longValue();
        }
        return this.maxDSPPowerPoint;
    }

    public DSP_DataCell addDSPSolarSail(long amount) {
        this.amountDSPSolarSail += amount;
        this.markDirty().flushMaxDSPPowerPoint();
        DSP_WorldSavedData.markDataDirty();
        return this;
    }

    public DSP_DataCell addDSPNode(long amount) {
        this.amountDSPNode += amount;
        this.markDirty().flushMaxDSPPowerPoint();
        DSP_WorldSavedData.markDataDirty();
        return this;
    }

    public DSP_DataCell setMaxDSPPowerPoint(long amount) {
        this.markDirty().maxDSPPowerPoint = amount;
        DSP_WorldSavedData.markDataDirty();
        return this;
    }

    public DSP_DataCell setMaxDSPPowerPoint(BigInteger amount) {
        this.markDirty().maxDSPPowerPoint_BigInteger = amount;
        DSP_WorldSavedData.markDataDirty();
        return this;
    }

    public DSP_DataCell markDirty() {
        this.dirty = true;
        this.dataSyncFlag = (byte)(this.dataSyncFlag + 1);
        if (this.dataSyncFlag > 64) {
            this.dataSyncFlag = 1;
        }
        return this;
    }

    public DSP_DataCell cancelDirty() {
        this.dirty = false;
        return this;
    }

    public byte getDataSyncFlag() {
        return this.dataSyncFlag;
    }

    public String toString() {
        return "DSP_DataCell{ ownerName:" + this.ownerName + " , galaxy:" + this.galaxy + " , amountDSPSolarSail:" + this.amountDSPSolarSail + " , amountDSPNode:" + this.amountDSPNode + " , maxDSPPowerPoint:" + (this.useBigInteger ? GTUtility.formatNumbers((BigInteger)this.maxDSPPowerPoint_BigInteger) : Long.valueOf(this.maxDSPPowerPoint)) + " , usedDSPPowerPoint:" + (this.useBigInteger ? GTUtility.formatNumbers((BigInteger)this.usedDSPPowerPoint_BigInteger) : Long.valueOf(this.usedDSPPowerPoint)) + " , PowerPointCanUse: " + (this.useBigInteger ? GTUtility.formatNumbers((BigInteger)this.getDSPPowerPointCanUseBigInteger()) : Long.valueOf(this.getDSPPowerPointCanUse())) + (this.useBigInteger ? " , " + EnumChatFormatting.RED + "Using Big Integer Calculation" + EnumChatFormatting.RESET : "") + " }";
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public DSP_DataCell setOwnerName(String ownerName) {
        this.ownerName = ownerName;
        DSP_WorldSavedData.markDataDirty();
        return this;
    }

    public DSP_Galaxy getGalaxy() {
        return this.galaxy;
    }

    public DSP_DataCell setGalaxy(DSP_Galaxy galaxy) {
        this.galaxy = galaxy;
        DSP_WorldSavedData.markDataDirty();
        return this;
    }

    public long getDSPSolarSail() {
        return this.amountDSPSolarSail;
    }

    public DSP_DataCell setDSPSolarSail(long amountDSPSolarSail) {
        this.amountDSPSolarSail = amountDSPSolarSail;
        this.flushMaxDSPPowerPoint();
        DSP_WorldSavedData.markDataDirty();
        return this;
    }

    public long getDSPNode() {
        return this.amountDSPNode;
    }

    public DSP_DataCell setDSPNode(long amountDSPNode) {
        this.amountDSPNode = amountDSPNode;
        this.flushMaxDSPPowerPoint();
        DSP_WorldSavedData.markDataDirty();
        return this;
    }
}

