/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.OverclockControllers;

import com.Nxer.TwistSpaceTechnology.common.misc.OverclockType;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.OverclockControllers.StaticOverclockControllerBase;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import net.minecraft.client.renderer.texture.IIconRegister;

public class StaticOverclockController
extends StaticOverclockControllerBase {
    protected final OverclockType overclockType;
    protected String[] description;
    protected static Textures.BlockIcons.CustomIcon ActiveFaceLowSpeed;
    protected static Textures.BlockIcons.CustomIcon ActiveFacePerfect;
    protected static Textures.BlockIcons.CustomIcon ActiveFaceSingularity;
    protected ITexture overlay;

    public StaticOverclockController(int aID, String aName, String aNameRegional, int aTier, int timeReduction, int powerIncrease) {
        super(aID, aName, aNameRegional, aTier);
        this.overclockType = OverclockType.checkOverclockType(timeReduction, powerIncrease);
    }

    public StaticOverclockController(String aName, int aTier, OverclockType overclockType, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.overclockType = overclockType;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new StaticOverclockController(this.mName, (int)this.mTier, this.overclockType, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public OverclockType getOverclockType() {
        return this.overclockType;
    }

    public String[] getDescription() {
        if (this.description == null || this.description.length == 0) {
            this.description = new String[]{TextEnums.tr("Tooltips.StaticOverclockController.01"), this.getOverclockType().getDescription(), TextEnums.tr("Tooltips.StaticOverclockController.03"), TextEnums.AddByTwistSpaceTechnology.getText(), TextEnums.ModularizedMachineSystem.getText()};
        }
        return this.description;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ActiveFaceLowSpeed = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:ModularHatchOverlay/OVERLAY_OverClockController_Pri");
        ActiveFacePerfect = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:ModularHatchOverlay/OVERLAY_OverClockController_Adv");
        ActiveFaceSingularity = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:ModularHatchOverlay/OVERLAY_OverClockController_Per");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        if (null == this.overlay) {
            ITexture iTexture;
            switch (this.overclockType) {
                case PerfectOverclock: {
                    iTexture = TextureFactory.of((IIconContainer)ActiveFacePerfect);
                    break;
                }
                case SingularityPerfectOverclock: {
                    iTexture = TextureFactory.of((IIconContainer)ActiveFaceSingularity);
                    break;
                }
                default: {
                    iTexture = TextureFactory.of((IIconContainer)ActiveFaceLowSpeed);
                }
            }
            this.overlay = iTexture;
        }
        return new ITexture[]{aBaseTexture, this.overlay};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return this.getTexturesActive(aBaseTexture);
    }
}

