/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic;

import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.IModularizedMachine;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularHatchTypes;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.IDynamicModularHatch;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.IModularHatch;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.IStaticModularHatch;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.ModularHatchBase;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class ModularizedMachineBase<T extends ModularizedMachineBase<T>>
extends GTCM_MultiMachineBase<T>
implements IModularizedMachine {
    protected Map<ModularHatchTypes, Collection<IModularHatch>> modularHatches = new HashMap<ModularHatchTypes, Collection<IModularHatch>>();
    protected Map<ModularHatchTypes, Collection<IStaticModularHatch>> staticModularHatches = new HashMap<ModularHatchTypes, Collection<IStaticModularHatch>>();
    protected Map<ModularHatchTypes, Collection<IDynamicModularHatch>> dynamicModularHatches = new HashMap<ModularHatchTypes, Collection<IDynamicModularHatch>>();
    protected Collection<IModularHatch> allModularHatches = new ArrayList<IModularHatch>();

    public ModularizedMachineBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public ModularizedMachineBase(String aName) {
        super(aName);
    }

    public Map<ModularHatchTypes, Collection<IModularHatch>> getModularHatchMap() {
        return this.modularHatches;
    }

    public Map<ModularHatchTypes, Collection<IStaticModularHatch>> getStaticModularHatchMap() {
        return this.staticModularHatches;
    }

    public Map<ModularHatchTypes, Collection<IDynamicModularHatch>> getDynamicModularHatchMap() {
        return this.dynamicModularHatches;
    }

    @Override
    public Collection<IModularHatch> getAllModularHatches() {
        return this.allModularHatches;
    }

    @Override
    public void resetModularHatchCollections() {
        this.modularHatches.forEach((k, v) -> v.clear());
        this.staticModularHatches.forEach((k, v) -> v.clear());
        this.dynamicModularHatches.forEach((k, v) -> v.clear());
        this.allModularHatches.clear();
    }

    @Override
    public void applyModularStaticSettings() {
        for (Collection<IStaticModularHatch> c : this.getStaticModularHatchMap().values()) {
            for (IStaticModularHatch d : c) {
                d.onCheckMachine(this);
            }
        }
    }

    @Override
    public void applyModularDynamicParameters() {
        for (Collection<IDynamicModularHatch> c : this.getDynamicModularHatchMap().values()) {
            for (IDynamicModularHatch d : c) {
                d.onCheckProcessing(this);
            }
        }
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || this.addModularHatchToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addNormalHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return super.addToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addModularHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addAnyModularHatchToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addAnyModularHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof ModularHatchBase) {
            ModularHatchBase modularHatchBase = (ModularHatchBase)aMetaTileEntity;
            ModularHatchTypes hatchTypes = modularHatchBase.getType();
            Collection supportedModularHatchTypes = this.getSupportedModularHatchTypes();
            if (!supportedModularHatchTypes.contains((Object)ModularHatchTypes.ALL) && !supportedModularHatchTypes.contains((Object)hatchTypes)) {
                return false;
            }
            modularHatchBase.updateTexture(aBaseCasingIndex);
            modularHatchBase.updateCraftingIcon(this.getMachineCraftingIcon());
            if (!this.modularHatches.containsKey((Object)hatchTypes) || this.modularHatches.get((Object)hatchTypes) == null) {
                this.modularHatches.put(hatchTypes, new ArrayList());
            }
            this.modularHatches.get((Object)hatchTypes).add(modularHatchBase);
            this.allModularHatches.add(modularHatchBase);
            if (modularHatchBase instanceof IDynamicModularHatch) {
                IDynamicModularHatch dynamicModularHatch = (IDynamicModularHatch)((Object)modularHatchBase);
                if (!this.dynamicModularHatches.containsKey((Object)hatchTypes) || this.dynamicModularHatches.get((Object)hatchTypes) == null) {
                    this.dynamicModularHatches.put(hatchTypes, new ArrayList());
                }
                return this.dynamicModularHatches.get((Object)hatchTypes).add(dynamicModularHatch);
            }
            if (modularHatchBase instanceof IStaticModularHatch) {
                IStaticModularHatch staticModularHatch = (IStaticModularHatch)((Object)modularHatchBase);
                if (!this.staticModularHatches.containsKey((Object)hatchTypes) || this.staticModularHatches.get((Object)hatchTypes) == null) {
                    this.staticModularHatches.put(hatchTypes, new ArrayList());
                }
                return this.staticModularHatches.get((Object)hatchTypes).add(staticModularHatch);
            }
        }
        return false;
    }

    protected boolean addSpecialModularHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex, ModularHatchTypes hatchType) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof ModularHatchBase) {
            ModularHatchBase modularHatchBase = (ModularHatchBase)aMetaTileEntity;
            if (modularHatchBase.getType() != hatchType) {
                return false;
            }
            if (!this.getSupportedModularHatchTypes().contains((Object)hatchType)) {
                return false;
            }
            modularHatchBase.updateTexture(aBaseCasingIndex);
            modularHatchBase.updateCraftingIcon(this.getMachineCraftingIcon());
            if (!this.modularHatches.containsKey((Object)hatchType) || this.modularHatches.get((Object)hatchType) == null) {
                this.modularHatches.put(hatchType, new ArrayList());
            }
            this.modularHatches.get((Object)hatchType).add(modularHatchBase);
            this.allModularHatches.add(modularHatchBase);
            if (modularHatchBase instanceof IDynamicModularHatch) {
                IDynamicModularHatch dynamicModularHatch = (IDynamicModularHatch)((Object)modularHatchBase);
                if (!this.dynamicModularHatches.containsKey((Object)hatchType) || this.dynamicModularHatches.get((Object)hatchType) == null) {
                    this.dynamicModularHatches.put(hatchType, new ArrayList());
                }
                return this.dynamicModularHatches.get((Object)hatchType).add(dynamicModularHatch);
            }
            if (modularHatchBase instanceof IStaticModularHatch) {
                IStaticModularHatch staticModularHatch = (IStaticModularHatch)((Object)modularHatchBase);
                if (!this.staticModularHatches.containsKey((Object)hatchType) || this.staticModularHatches.get((Object)hatchType) == null) {
                    this.staticModularHatches.put(hatchType, new ArrayList());
                }
                return this.staticModularHatches.get((Object)hatchType).add(staticModularHatch);
            }
        }
        return false;
    }

    public boolean addExecutionCoreToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addSpecialModularHatchToMachineList(aTileEntity, aBaseCasingIndex, ModularHatchTypes.EXECUTION_CORE);
    }

    public boolean addParallelControllerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addSpecialModularHatchToMachineList(aTileEntity, aBaseCasingIndex, ModularHatchTypes.PARALLEL_CONTROLLER);
    }

    public boolean addSpeedControllerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addSpecialModularHatchToMachineList(aTileEntity, aBaseCasingIndex, ModularHatchTypes.SPEED_CONTROLLER);
    }

    public boolean addPowerConsumptionControllerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addSpecialModularHatchToMachineList(aTileEntity, aBaseCasingIndex, ModularHatchTypes.POWER_CONSUMPTION_CONTROLLER);
    }

    public boolean addOverclockControllerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addSpecialModularHatchToMachineList(aTileEntity, aBaseCasingIndex, ModularHatchTypes.OVERCLOCK_CONTROLLER);
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        this.checkModularDynamicParameters();
        return this.checkProcessingMM();
    }

    public CheckRecipeResult checkProcessingMM() {
        if (this.processingLogic == null) {
            return this.checkRecipe(this.mInventory[1]) ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.setupProcessingLogic(this.processingLogic);
        CheckRecipeResult result = this.doCheckRecipe();
        result = this.postCheckRecipe(result, this.processingLogic);
        this.updateSlots();
        if (!result.wasSuccessful()) {
            return result;
        }
        this.mEfficiency = 10000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = this.processingLogic.getDuration();
        this.setEnergyUsage(this.processingLogic);
        this.mOutputItems = this.processingLogic.getOutputItems();
        this.mOutputFluids = this.processingLogic.getOutputFluids();
        return result;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.resetModularHatchCollections();
        if (!this.checkMachineMM(aBaseMetaTileEntity, aStack)) {
            return false;
        }
        if (!this.canMultiplyModularHatchType() && !this.checkSingleModularHatch()) {
            return false;
        }
        this.checkModularStaticSettings();
        return true;
    }

    protected boolean checkSingleModularHatch() {
        if (this.modularHatches.containsKey((Object)ModularHatchTypes.OVERCLOCK_CONTROLLER) && this.modularHatches.get((Object)ModularHatchTypes.OVERCLOCK_CONTROLLER).size() > 1) {
            return false;
        }
        if (this.modularHatches.containsKey((Object)ModularHatchTypes.PARALLEL_CONTROLLER) && this.modularHatches.get((Object)ModularHatchTypes.PARALLEL_CONTROLLER).size() > 1) {
            return false;
        }
        if (this.modularHatches.containsKey((Object)ModularHatchTypes.SPEED_CONTROLLER) && this.modularHatches.get((Object)ModularHatchTypes.SPEED_CONTROLLER).size() > 1) {
            return false;
        }
        return !this.modularHatches.containsKey((Object)ModularHatchTypes.POWER_CONSUMPTION_CONTROLLER) || this.modularHatches.get((Object)ModularHatchTypes.POWER_CONSUMPTION_CONTROLLER).size() <= 1;
    }

    protected abstract boolean canMultiplyModularHatchType();

    public abstract boolean checkMachineMM(IGregTechTileEntity var1, ItemStack var2);
}

