/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic;

import com.Nxer.TwistSpaceTechnology.common.misc.OverclockType;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularBlockTypes;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularHatchTypes;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.ExecutionCores.IExecutionCore;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.IModularHatch;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public interface IModularizedMachine {
    public Collection<ModularHatchTypes> getSupportedModularHatchTypes();

    public Collection<ModularBlockTypes> getSupportedModularBlockTypes();

    public void resetModularStaticSettings();

    public void applyModularStaticSettings();

    default public void checkModularStaticSettings() {
        this.resetModularStaticSettings();
        this.applyModularStaticSettings();
    }

    public void resetModularDynamicParameters();

    public void applyModularDynamicParameters();

    default public void checkModularDynamicParameters() {
        this.resetModularDynamicParameters();
        this.applyModularDynamicParameters();
    }

    public Collection<IModularHatch> getAllModularHatches();

    public void resetModularHatchCollections();

    public static interface ISupportAllModularHatches
    extends ISupportParallelController,
    ISupportSpeedController,
    ISupportPowerConsumptionController,
    ISupportOverclockController {
    }

    public static interface ISupportExecutionCore
    extends IModularizedMachine {
        public Collection<IExecutionCore> getIdleNormalExecutionCores();

        public Collection<IExecutionCore> getIdleAdvancedExecutionCores();

        public Collection<IExecutionCore> getIdlePerfectExecutionCores();

        public Collection<IExecutionCore> getAllWorkingExecutionCoresToBoost();

        public int getParallelOfEveryNormalExecutionCore();

        public void mergeOutputItems(ItemStack ... var1);

        public void mergeOutputFluids(FluidStack ... var1);

        public boolean tryUseEut(long var1);

        public boolean tryDecreaseUsedEut(long var1);

        public void forceCheckProcessing();
    }

    public static interface ISupportOverclockController
    extends IModularizedMachine {
        public void setOverclockType(OverclockType var1);
    }

    public static interface ISupportPowerConsumptionController
    extends IModularizedMachine {
        public float getStaticPowerConsumptionParameterValue();

        public void setStaticPowerConsumptionParameterValue(float var1);
    }

    public static interface ISupportSpeedController
    extends IModularizedMachine {
        public float getStaticSpeedParameterValue();

        public void setStaticSpeedParameterValue(float var1);

        public float getDynamicSpeedParameterValue();

        public void setDynamicSpeedParameterValue(float var1);
    }

    public static interface ISupportParallelController
    extends IModularizedMachine {
        public int getStaticParallelParameterValue();

        public void setStaticParallelParameter(int var1);

        public int getDynamicParallelParameterValue();

        public void setDynamicParallelParameter(int var1);
    }
}

