/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.modularizedMachine;

import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularizedHatchElement;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularizedMachineBase;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.MultiExecutionCoreMachineSupportAllModuleBase;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.MultiExecutionProcessingLogic;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.ExecutionCores.IExecutionCore;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.ParallelHelper;
import gregtech.api.util.shutdown.ShutDownReason;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.thing.block.BlockQuantumGlass;
import tectech.thing.casing.TTCasingsContainer;

public class MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2
extends MultiExecutionCoreMachineSupportAllModuleBase<MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2> {
    protected static final double max_efficiency_time_in_ticks = 1728000.0;
    protected static final double maximum_discount = Config.MaxFuelDiscount_DTMPFP;
    protected static final double maximum_decrease = 1.0 - Config.MaxFuelDiscount_DTMPFP;
    protected static final long tick_decrease_per_tick = 24L;
    protected static final FluidStack[] valid_fuels = new FluidStack[]{MaterialsUEVplus.ExcitedDTEC.getFluid(1L), MaterialsUEVplus.ExcitedDTRC.getFluid(1L), MaterialsUEVplus.ExcitedDTPC.getFluid(1L), MaterialsUEVplus.ExcitedDTCC.getFluid(1L), MaterialsUEVplus.ExcitedDTSC.getFluid(1L)};
    private HeatingCoilLevel coilLevel = HeatingCoilLevel.None;
    protected int coilHeat;
    private long runningTime = 0L;
    protected double fuelCostMultiplier = 1.0;
    private static final int horizontalOffSet = 32;
    private static final int verticalOffSet = 39;
    private static final int depthOffSet = 30;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static IStructureDefinition<MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2> STRUCTURE_DEFINITION = null;
    private static MultiblockTooltipBuilder tooltip;

    public MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("coilHeat", this.coilHeat);
        aNBT.func_74772_a("runningTime", this.runningTime);
        aNBT.func_74780_a("fuelCostMultiplier", this.fuelCostMultiplier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.coilHeat = aNBT.func_74762_e("coilHeat");
        this.runningTime = aNBT.func_74763_f("runningTime");
        this.fuelCostMultiplier = aNBT.func_74769_h("fuelCostMultiplier");
    }

    public void resetDiscount(int tickDecrease) {
        if (this.runningTime == 0L) {
            return;
        }
        if (this.runningTime < 0L) {
            this.runningTime = 0L;
            return;
        }
        if ((double)this.runningTime > 1728000.0) {
            this.runningTime = 1728000L;
            return;
        }
        long tickToDecrease = (long)tickDecrease * 24L;
        this.runningTime = this.runningTime > tickToDecrease ? (this.runningTime -= tickToDecrease) : 0L;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick % 512L == 0L && !aBaseMetaTileEntity.isAllowedToWork()) {
            this.resetDiscount(512);
        }
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        boolean r = super.onRunningTick(aStack);
        if (!r) {
            this.resetDiscount(1);
            return false;
        }
        if (this.isWorkingThisTick()) {
            ++this.runningTime;
        } else {
            this.resetDiscount(1);
        }
        return true;
    }

    @Override
    public void stopMachine(@NotNull ShutDownReason reason) {
        this.runningTime = 0L;
        this.fuelCostMultiplier = 1.0;
        super.stopMachine(reason);
    }

    public void setCoilLevel(HeatingCoilLevel coilLevel) {
        this.coilLevel = coilLevel;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.coilLevel;
    }

    @Override
    protected boolean canMultiplyModularHatchType() {
        return false;
    }

    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.plasmaForgeRecipes;
    }

    protected boolean isWorkingThisTick() {
        if (this.isWorking()) {
            return true;
        }
        for (IExecutionCore c : this.executionCores) {
            if (!c.isWorking()) continue;
            return true;
        }
        for (IExecutionCore c : this.advExecutionCores) {
            if (!c.isWorking()) continue;
            return true;
        }
        for (IExecutionCore c : this.perfectExecutionCores) {
            if (!c.isWorking()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new MultiExecutionProcessingLogic(){

            @Override
            @NotNull
            protected ParallelHelper createParallelHelper(@NotNull GTRecipe recipe) {
                return super.createParallelHelper(MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2.this.recipeAfterDiscount(recipe));
            }

            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                return recipe.mSpecialValue <= MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2.this.coilHeat ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.insufficientHeat((int)recipe.mSpecialValue);
            }

            @NotNull
            public CheckRecipeResult process() {
                this.setEuModifier(MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2.this.getEuModifier());
                this.setSpeedBonus(MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2.this.getSpeedBonus());
                this.setOverclock(((MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2)MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2.this).getOverclockType().timeReduction, ((MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2)MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2.this).getOverclockType().powerIncrease);
                return super.process();
            }

            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                if (MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2.this.isNoOverclockCalculator) {
                    return OverclockCalculator.ofNoOverclock((GTRecipe)recipe);
                }
                return super.createOverclockCalculator(recipe);
            }
        };
    }

    @Nonnull
    protected GTRecipe recipeAfterDiscount(@Nonnull GTRecipe recipe) {
        GTRecipe tRecipe = recipe.copy();
        for (int i = 0; i < recipe.mFluidInputs.length; ++i) {
            for (FluidStack fuel : valid_fuels) {
                if (!tRecipe.mFluidInputs[i].isFluidEqual(fuel)) continue;
                if ((double)this.runningTime > 1728000.0) {
                    this.fuelCostMultiplier = maximum_discount;
                } else {
                    double time_percentage = Math.min((double)this.runningTime / 1728000.0, 1.0);
                    this.fuelCostMultiplier = Math.max(maximum_discount, 1.0 - time_percentage * maximum_decrease);
                }
                tRecipe.mFluidInputs[i].amount = (int)Math.round((double)tRecipe.mFluidInputs[i].amount * this.fuelCostMultiplier);
                return tRecipe;
            }
        }
        return tRecipe;
    }

    @Override
    public boolean checkMachineMM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.coilLevel = HeatingCoilLevel.None;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 32, 39, 30)) {
            return false;
        }
        this.coilHeat = (int)this.coilLevel.getHeat();
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 32, 39, 30);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 32, 39, 30, elementBudget, env, false, true);
    }

    public IStructureDefinition<MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"   D D                         D D                         D D   ", "  DCDCD                       DCDCD                       DCDCD  ", " DBBBBBD    D     D     D    DBBBBBD    D     D     D    DBBBBBD ", "DCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCD", " DBBBBBDBBBBDBBBBBDBBBBBDBBBBDBBBBBDBBBBDBBBBBDBBBBBDBBBBDBBBBBD ", "DCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCD", " DBBBBBD    D     D     D    DBBBBBD    D     D     D    DBBBBBD ", "  DCDCD     D     D     D     DCDCD     D     D     D     DCDCD  ", "   DBD      D     D     D      DBD      D     D     D      DBD   ", "   DBD      D     D     D      DBD      D     D     D      DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD    DBBBD DBBBD DBBBD    DBD    DBBBD DBBBD DBBBD    DBD   ", "  DCDCDDDDDBBBD DBBBD DBBBDDDDDCDCDDDDDBBBD DBBBD DBBBDDDDDCDCD  ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD       D   D D   D       DBD       D   D D   D       DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "  DCDCDDDDDBBBD DBBBD DBBBDDDDDCDCDDDDDBBBD DBBBD DBBBDDDDDCDCD  ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD       D   D D   D       DBD       D   D D   D       DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "  DCDCDDDDDBBBD DBBBD DBBBDDDDDCDCDDDDDBBBD DBBBD DBBBDDDDDCDCD  ", "   DBD    DBBBD DBBBD DBBBD    DBD    DBBBD DBBBD DBBBD    DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD      D     D     D      DBD      D     D     D      DBD   ", "   DBD      D     D     D      DBD      D     D     D      DBD   ", "  DCDCD     D     D     D     DCDCD     D     D     D     DCDCD  ", " DBBBBBD    D     D     D    DBBBBBD    D     D     D    DBBBBBD ", "DCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCD", " DBBBBBDBBBBDBBBBBDBBBBBDBBBBDBBBBBDBBBBDBBBBBDBBBBBDBBBBDBBBBBD ", "DCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCD", " DBBBBBD    D     D     D    DBBBBBD    D     D     D    DBBBBBD ", "  DCDCD     D     D     D     DCDCD     D     D     D     DCDCD  ", "   DBD      D     D     D      DBD      D     D     D      DBD   ", "   DBD      D     D     D      DBD      D     D     D      DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD    DBBBD DBBBD DBBBD    DBD    DBBBD DBBBD DBBBD    DBD   ", "  DCDCDDDDDBBBD DBBBD DBBBDDDDDCDCDDDDDBBBD DBBBD DBBBDDDDDCDCD  ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD       D   D D   D       DBD       D   D D   D       DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "  DCDCDDDDDBBBD DBBBD DBBBDDDDDCDCDDDDDBBBD DBBBD DBBBDDDDDCDCD  ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD       D   D D   D       DBD       D   D D   D       DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "  DCDCDDDDDBBBD DBBBD DBBBDDDDDCDCDDDDDBBBD DBBBD DBBBDDDDDCDCD  ", "   DBD    DBBBD DBBBD DBBBD    DBD    DBBBD DBBBD DBBBD    DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD      D     D     D      DBD      D     D     D      DBD   ", "   DBD      D     D     D      DBD      D     D     D      DBD   ", "  DCDCD     D     D     D     DCDCD     D     D     D     DCDCD  ", " DBBBBBD    D     D     D    DBBBBBD    D     D     D    DBBBBBD ", "DCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCD", " DBBBBBDBBBBDBBBBBDBBBBBDBBBBDBBBBBDBBBBDBBBBBDBBBBBDBBBBDBBBBBD ", "DCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCD", " DBBBBBD    D     D     D    DBBBBBD    D     D     D    DBBBBBD ", "  DCDCD                       DCDCD                       DCDCD  ", "   D D                         D D                         D D   "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            C     C     C               C     C     C            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            C     C     C               C     C     C            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            C     C     C               C     C     C            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            C     C     C               C     C     C            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            C     C     C               C     C     C            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            C     C     C               C     C     C            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "                                                                 ", "                                                                 ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "                                                                 ", "                                                                 ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "                                                                 ", "                                                                 ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "                                                                 ", "                                                                 ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "       BAAADDD  DDDDD  DDDAAAB     BAAADDD  DDDDD  DDDAAAB       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D    DD   DDD   DD    D     D    DD   DDD   DD    D       ", "             D   D D   D                 D   D D   D             ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "             D   D D   D                 D   D D   D             ", "       D    DD   DDD   DD    D     D    DD   DDD   DD    D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       BAAADDD  DDDDD  DDDAAAB     BAAADDD  DDDDD  DDDAAAB       ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "       BAAADDD  DDDDD  DDDAAAB     BAAADDD  DDDDD  DDDAAAB       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D    DD   DDD   DD    D     D    DD   DDD   DD    D       ", "             D   D D   D                 D   D D   D             ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "             D   D D   D                 D   D D   D             ", "       D    DD   DDD   DD    D     D    DD   DDD   DD    D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       BAAADDD  DDDDD  DDDAAAB     BAAADDD  DDDDD  DDDAAAB       ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "            C     C     C               C     C     C            ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "      CBBBBBC     C     CBBBBBC   CBBBBBC     C     CBBBBBC      ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       D   D             D   D     D   D             D   D       ", "                                                                 ", "       D   D             D   D     D   D             D   D       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "      CBBBBBC     D     CBBBBBC   CBBBBBC     D     CBBBBBC      ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       D   D             D   D     D   D             D   D       ", "                                                                 ", "       D   D             D   D     D   D             D   D       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "      CBBBBBC     C     CBBBBBC   CBBBBBC     C     CBBBBBC      ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "            C     C     C               C     C     C            ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "            C     C     C               C     C     C            ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "      CBBBBBC     C     CBBBBBC   CBBBBBC     C     CBBBBBC      ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       D   D             D   D     D   D             D   D       ", "                                                                 ", "       D   D             D   D     D   D             D   D       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "      CBBBBBC     D     CBBBBBC   CBBBBBC     D     CBBBBBC      ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       D   D             D   D     D   D             D   D       ", "                                                                 ", "       D   D             D   D     D   D             D   D       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "      CBBBBBC     C     CBBBBBC   CBBBBBC     C     CBBBBBC      ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "            C     C     C               C     C     C            ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB      D      BAAAB     BAAAB      D      BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB      D      BAAAB     BAAAB      D      BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "       D   D             D   D     D   D             D   D       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       D   D      D      D   D     D   D      D      D   D       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       D   D             D   D     D   D             D   D       ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "       D   D             D   D     D   D             D   D       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       D   D      D      D   D     D   D      D      D   D       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       D   D             D   D     D   D             D   D       ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "             D   D D   D                 D   D D   D             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             D   D D   D                 D   D D   D             ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "                 C C                         C C                 ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "             D   D D   D                 D   D D   D             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             D   D D   D                 D   D D   D             ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "             D   D D   D                 D   D D   D             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             D   D D   D                 D   D D   D             ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "                 C C                         C C                 ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "             D   D D   D                 D   D D   D             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             D   D D   D                 D   D D   D             ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "       D   D             D   D     D   D             D   D       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       D   D     C C     D   D     D   D     C C     D   D       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       D   D             D   D     D   D             D   D       ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "       D   D             D   D     D   D             D   D       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       D   D     C C     D   D     D   D     C C     D   D       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       D   D             D   D     D   D             D   D       ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB   CC   CC   BAAAB     BAAAB   CC   CC   BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB   CC   CC   BAAAB     BAAAB   CC   CC   BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "            C     C     C               C     C     C            ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "      CBBBBBC     D     CBBBBBC   CBBBBBC     D     CBBBBBC      ", "       BAAAB      D      BAAAB     BAAAB      D      BAAAB       ", "       D   D      D      D   D     D   D      D      D   D       ", "                 C C                         C C                 ", "       D   D     C C     D   D     D   D     C C     D   D       ", "       BAAAB   CC   CC   BAAAB     BAAAB   CC   CC   BAAAB       ", "      CBBBBBDDD       DDDBBBBBC   CBBBBBDDD       DDDBBBBBC      ", "       BAAAB   CC   CC   BAAAB     BAAAB   CC   CC   BAAAB       ", "       D   D     C C     D   D     D   D     C C     D   D       ", "                 C C                         C C                 ", "       D   D      D      D   D     D   D      D      D   D       ", "       BAAAB      D      BAAAB     BAAAB      D      BAAAB       ", "      CBBBBBC     D     CBBBBBC   CBBBBBC     D     CBBBBBC      ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "            C     C     C               C     C     C            ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "            C     C     C               C     C     C            ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "      CBBBBBC     D     CBBBBBC   CBBBBBC     D     CBBBBBC      ", "       BAAAB      D      BAAAB     BAAAB      D      BAAAB       ", "       D   D      D      D   D     D   D      D      D   D       ", "                 C C                         C C                 ", "       D   D     C C     D   D     D   D     C C     D   D       ", "       BAAAB   CC   CC   BAAAB     BAAAB   CC   CC   BAAAB       ", "      CBBBBBDDD       DDDBBBBBC   CBBBBBDDD       DDDBBBBBC      ", "       BAAAB   CC   CC   BAAAB     BAAAB   CC   CC   BAAAB       ", "       D   D     C C     D   D     D   D     C C     D   D       ", "                 C C                         C C                 ", "       D   D      D      D   D     D   D      D      D   D       ", "       BAAAB      D      BAAAB     BAAAB      D      BAAAB       ", "      CBBBBBC     D     CBBBBBC   CBBBBBC     D     CBBBBBC      ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "            C     C     C               C     C     C            ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB   CC   CC   BAAAB     BAAAB   CC   CC   BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB   CC   CC   BAAAB     BAAAB   CC   CC   BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "       D   D             D   D     D   D             D   D       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       D   D     C C     D   D     D   D     C C     D   D       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       D   D             D   D     D   D             D   D       ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "       D   D             D   D     D   D             D   D       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "       D   D     C C     D   D     D   D     C C     D   D       ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       D   D             D   D     D   D             D   D       ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "             D   D D   D                 D   D D   D             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             D   D D   D                 D   D D   D             ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "                 C C                         C C                 ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "             D   D D   D                 D   D D   D             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             D   D D   D                 D   D D   D             ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "             D   D D   D                 D   D D   D             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             D   D D   D                 D   D D   D             ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "                 C C                         C C                 ", "       DAAAD      C      DAAAD     DAAAD      C      DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "             D   D D   D                 D   D D   D             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             D   D D   D                 D   D D   D             ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "       D   D             D   D     D   D             D   D       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       D   D      D      D   D     D   D      D      D   D       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       D   D             D   D     D   D             D   D       ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "       D   D             D   D     D   D             D   D       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       D   D      D      D   D     D   D      D      D   D       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "                                                                 ", "                                                                 ", "                                                                 ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       D   D             D   D     D   D             D   D       ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB      D      BAAAB     BAAAB      D      BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB      D      BAAAB     BAAAB      D      BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       DAAAD             DAAAD     DAAAD             DAAAD       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "            C     C     C               C     C     C            ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "      CBBBBBC     C     CBBBBBC   CBBBBBC     C     CBBBBBC      ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       D   D             D   D     D   D             D   D       ", "                                                                 ", "       D   D             D   D     D   D             D   D       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "      CBBBBBC     D     CBBBBBC   CBBBBBC     D     CBBBBBC      ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       D   D             D   D     D   D             D   D       ", "                                                                 ", "       D   D             D   D     D   D             D   D       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "      CBBBBBC     C     CBBBBBC   CBBBBBC     C     CBBBBBC      ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "            C     C     C               C     C     C            ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "            C     C     C               C     C     C            ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "      CBBBBBC     C     CBBBBBC   CBBBBBC     C     CBBBBBC      ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       D   D             D   D     D   D             D   D       ", "                                                                 ", "       D   D             D   D     D   D             D   D       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "      CBBBBBC     D     CBBBBBC   CBBBBBC     D     CBBBBBC      ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "       D   D             D   D     D   D             D   D       ", "                                                                 ", "       D   D             D   D     D   D             D   D       ", "       BAAAB             BAAAB     BAAAB             BAAAB       ", "      CBBBBBC     C     CBBBBBC   CBBBBBC     C     CBBBBBC      ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "            C     C     C               C     C     C            ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "       BAAADDD  DDDDD  DDDAAAB     BAAADDD  DDDDD  DDDAAAB       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D    DD   DDD   DD    D     D    DD   DDD   DD    D       ", "             D   D D   D                 D   D D   D             ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "             D   D D   D                 D   D D   D             ", "       D    DD   DDD   DD    D     D    DD   DDD   DD    D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       BAAADDD  DDDDD  DDDAAAB     BAAADDD  DDDDD  DDDAAAB       ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "       BAAADDD  DDDDD  DDDAAAB     BAAADDD  DDDDD  DDDAAAB       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D    DD   DDD   DD    D     D    DD   DDD   DD    D       ", "             D   D D   D                 D   D D   D             ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       D   DDD   DDD   DDD   D     D   DDD   DDD   DDD   D       ", "             D   D D   D                 D   D D   D             ", "       D    DD   DDD   DD    D     D    DD   DDD   DD    D       ", "       BAAADBBDDDBBBDDDBBDAAAB     BAAADBBDDDBBBDDDBBDAAAB       ", "       BAAADBBD DBBBD DBBDAAAB     BAAADBBD DBBBD DBBDAAAB       ", "       BAAADDD  DDDDD  DDDAAAB     BAAADDD  DDDDD  DDDAAAB       ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "                                                                 ", "                                                                 ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "                                                                 ", "                                                                 ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "                                                                 ", "                                                                 ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "       D   AAAAAAAAAAAAAAA   D     D   AAAAAAAAAAAAAAA   D       ", "       D   ABA   ABA   ABA   D     D   ABA   ABA   ABA   D       ", "       D   AAA   AAA   AAA   D     D   AAA   AAA   AAA   D       ", "                                                                 ", "                                                                 ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            C     C     C               C     C     C            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            C     C     C               C     C     C            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            C     C     C               C     C     C            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            C     C     C               C     C     C            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            C     C     C               C     C     C            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            C     C     C               C     C     C            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    C                           C                           C    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                               FFF                               ", "    E                         FCECF                         E    ", "   EBE                        FEBEF                        EBE   ", "    E                         FCECF                         E    ", "                               FFF                               ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "            D     D     D               D     D     D            ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "            D     D     D               D     D     D            ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "                                                                 ", "                                                                 ", "                               FFF                               ", "    E                         FCECF                         E    ", "   EBE                        FEBEF                        EBE   ", "    E                         FCECF                         E    ", "                               FFF                               ", "                                                                 ", "                                                                 ", "                                                                 ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "             D   D D   D                 D   D D   D             ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "          DBBBDDDBBBDDDBBBD           DBBBDDDBBBDDDBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "          DBBBD DBBBD DBBBD           DBBBD DBBBD DBBBD          ", "           DDD   DDD   DDD             DDD   DDD   DDD           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                               F~F                               ", "    E                         FCECF                         E    ", "   EBE                        FEBEF                        EBE   ", "    E                         FCECF                         E    ", "                               FFF                               ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                               FFF                               ", "    E                         FCECF                         E    ", "   EBE                        FEBEF                        EBE   ", "    E                         FCECF                         E    ", "                               FFF                               ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    E                           E                           E    ", "   EBE                         EBE                         EBE   ", "    E                           E                           E    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                               FFF                               ", "    D                         FCDCF                         D    ", "   DDD                        FDDDF                        DDD   ", "    D                         FCDCF                         D    ", "                               FFF                               ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "             A   A A   A                 A   A A   A             ", "           AAAAAAAAAAAAAAA             AAAAAAAAAAAAAAA           ", "           ABA   ABA   ABA             ABA   ABA   ABA           ", "           AAA   AAA   AAA             AAA   AAA   AAA           ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "                                                                 ", "    D                           D                           D    ", "   DDD                         DDD                         DDD   ", "    D                           D                           D    ", "                                                                 ", "                                                                 ", "                                                                 "}, {"   D D                         D D                         D D   ", "  DCDCD                       DCDCD                       DCDCD  ", " DBBBBBD    D     D     D    DBBBBBD    D     D     D    DBBBBBD ", "DCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCD", " DBBBBBDBBBBDBBBBBDBBBBBDBBBBDBBBBBDBBBBDBBBBBDBBBBBDBBBBDBBBBBD ", "DCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCD", " DBBBBBD    D     D     D    DBBBBBD    D     D     D    DBBBBBD ", "  DCDCD     D     D     D     DCDCD     D     D     D     DCDCD  ", "   DBD      D     D     D      DBD      D     D     D      DBD   ", "   DBD      D     D     D      DBD      D     D     D      DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD    DBBBD DBBBD DBBBD    DBD    DBBBD DBBBD DBBBD    DBD   ", "  DCDCDDDDDBBBD DBBBD DBBBDDDDDCDCDDDDDBBBD DBBBD DBBBDDDDDCDCD  ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD       D   D D   D       DBD       D   D D   D       DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "  DCDCDDDDDBBBD DBBBD DBBBDDDDDCDCDDDDDBBBD DBBBD DBBBDDDDDCDCD  ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD       D   D D   D       DBD       D   D D   D       DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "  DCDCDDDDDBBBD DBBBD DBBBDDDDDCDCDDDDDBBBD DBBBD DBBBDDDDDCDCD  ", "   DBD    DBBBD DBBBD DBBBDBBBBDBDBBBBDBBBD DBBBD DBBBD    DBD   ", "   DBD     DDD   DDD   DDDBBBBBDBDBBBBBDDD   DDD   DDD     DBD   ", "   DBD      D     D     DBBBBBBDBDBBBBBBD     D     D      DBD   ", "   DBD      D     D     DBBBBBBDBDBBBBBBD     D     D      DBD   ", "  DCDCD     D     D     DBBBBBDCDCDBBBBBD     D     D     DCDCD  ", " DBBBBBD    D     D     DBBBBDBBBBBDBBBBD     D     D    DBBBBBD ", "DCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCD", " DBBBBBDBBBBDBBBBBDBBBBBDBBBBDBBBBBDBBBBDBBBBBDBBBBBDBBBBDBBBBBD ", "DCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCD", " DBBBBBD    D     D     DBBBBDBBBBBDBBBBD     D     D    DBBBBBD ", "  DCDCD     D     D     DBBBBBDCDCDBBBBBD     D     D     DCDCD  ", "   DBD      D     D     DBBBBBBDBDBBBBBBD     D     D      DBD   ", "   DBD      D     D     DBBBBBBDBDBBBBBBD     D     D      DBD   ", "   DBD     DDD   DDD   DDDBBBBBDBDBBBBBDDD   DDD   DDD     DBD   ", "   DBD    DBBBD DBBBD DBBBDBBBBDBDBBBBDBBBD DBBBD DBBBD    DBD   ", "  DCDCDDDDDBBBD DBBBD DBBBDDDDDCDCDDDDDBBBD DBBBD DBBBDDDDDCDCD  ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD       D   D D   D       DBD       D   D D   D       DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "  DCDCDDDDDBBBD DBBBD DBBBDDDDDCDCDDDDDBBBD DBBBD DBBBDDDDDCDCD  ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD       D   D D   D       DBD       D   D D   D       DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD    DBBBDDDBBBDDDBBBD    DBD    DBBBDDDBBBDDDBBBD    DBD   ", "  DCDCDDDDDBBBD DBBBD DBBBDDDDDCDCDDDDDBBBD DBBBD DBBBDDDDDCDCD  ", "   DBD    DBBBD DBBBD DBBBD    DBD    DBBBD DBBBD DBBBD    DBD   ", "   DBD     DDD   DDD   DDD     DBD     DDD   DDD   DDD     DBD   ", "   DBD      D     D     D      DBD      D     D     D      DBD   ", "   DBD      D     D     D      DBD      D     D     D      DBD   ", "  DCDCD     D     D     D     DCDCD     D     D     D     DCDCD  ", " DBBBBBD    D     D     D    DBBBBBD    D     D     D    DBBBBBD ", "DCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCD", " DBBBBBDBBBBDBBBBBDBBBBBDBBBBDBBBBBDBBBBDBBBBBDBBBBBDBBBBDBBBBBD ", "DCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCDDDDCDDDDDCDDDDDCDDDDCBBBBBCD", " DBBBBBD    D     D     D    DBBBBBD    D     D     D    DBBBBBD ", "  DCDCD                       DCDCD                       DCDCD  ", "   D D                         D D                         D D   "}})).addElement('A', GTStructureUtility.ofCoil(MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2::setCoilLevel, MM_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2::getCoilLevel)).addElement('B', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).adder(ModularizedMachineBase::addNormalHatchToMachineList).dot(1).casingIndex(1024).buildAndChain(TTCasingsContainer.sBlockCasingsBA0, 12)).addElement('C', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)10)).addElement('D', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)12)).addElement('E', StructureUtility.ofBlock((Block)BlockQuantumGlass.INSTANCE, (int)0)).addElement('F', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{ModularizedHatchElement.AllModule}).adder(ModularizedMachineBase::addModularHatchToMachineList).dot(2).casingIndex(1036).buildAndChain(TTCasingsContainer.sBlockCasingsTT, 12)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    @Override
    public String[] getInfoData() {
        String[] origin = super.getInfoData();
        String[] ret = new String[origin.length + 2];
        System.arraycopy(origin, 0, ret, 0, origin.length);
        ret[origin.length] = TextEnums.tr("DTMPFP.getInfoData.01") + ": " + EnumChatFormatting.YELLOW + this.runningTime;
        ret[origin.length + 1] = TextEnums.tr("DTMPFP.getInfoData.02") + ": " + EnumChatFormatting.YELLOW + this.fuelCostMultiplier;
        return ret;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        if (tooltip == null) {
            tooltip = new MultiblockTooltipBuilder();
            tooltip.addMachineType(TextEnums.tr("Tooltip_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2_MachineType")).addInfo(TextEnums.tr("Tooltip_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2_01")).addInfo(TextEnums.tr("Tooltip_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2_02")).addInfo(TextEnums.tr("Tooltip_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2_03")).addInfo(TextEnums.tr("Tooltip_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2_04")).addInfo(TextEnums.tr("Tooltip_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2_05")).addInfo(TextEnums.tr("Tooltip_DimensionallyTranscendentMatterPlasmaForgePrototypeMK2_06")).addInfo(TextEnums.InstallingModuleNearControllerImproveMachine.getText()).addInfo(TextEnums.ModularizedMachineSystem.getText()).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addStructureInfo(TextEnums.ModularizedMachineSystem.getText()).addStructureInfo(TextEnums.ModularizedMachineSystemDescription01.getText()).addStructureInfo(TextEnums.ModularizedMachineSystemDescription02.getText()).addStructureInfo(TextEnums.OverclockControllerDescription.getText()).addStructureInfo(TextEnums.ParallelControllerDescription.getText()).addStructureInfo(TextEnums.PowerConsumptionControllerDescription.getText()).addStructureInfo(TextEnums.SpeedControllerDescription.getText()).addStructureInfo(TextEnums.ExecutionCoreDescription.getText()).addStructureInfo(TextEnums.NotMultiplyInstallSameTypeModule.getText()).addStructureInfo(TextLocalization.Text_SeparatingLine).beginStructureBlock(65, 43, 65, false).addInputHatch(TextLocalization.textUseBlueprint, new int[]{1}).addOutputHatch(TextLocalization.textUseBlueprint, new int[]{1}).addInputBus(TextLocalization.textUseBlueprint, new int[]{1}).addOutputBus(TextLocalization.textUseBlueprint, new int[]{1}).addEnergyHatch(TextLocalization.textUseBlueprint, new int[]{1}).addStructureInfo("  " + (Object)((Object)TextEnums.ModularHatch) + ": " + TextLocalization.textUseBlueprint).addStructureHint(TextEnums.ModularHatch.getKey(), new int[]{2}).toolTipFinisher(new String[]{"Twist Space Technology"});
        }
        return tooltip;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][14], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_DTPF_ON).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FUSION1_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][14], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_DTPF_OFF).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][14]};
    }
}

