/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.misc;

public final class TSTMath {
    public static final double SQRT2PI = Math.sqrt(Math.PI * 2);

    private TSTMath() {
    }

    public static double powInt(double base, int exp) {
        if (exp > 0) {
            return TSTMath.powBySquaring(base, exp);
        }
        if (exp < 0) {
            return 1.0 / TSTMath.powBySquaring(base, -exp);
        }
        return 1.0;
    }

    public static double powBySquaring(double base, int exp) {
        if (base == 2.0 && exp < 64) {
            return 1L << exp;
        }
        if (base == 4.0 && exp < 32) {
            return 1L << 2 * exp;
        }
        double result = 1.0;
        while (exp > 0) {
            if ((exp & 1) == 1) {
                result *= base;
            }
            base *= base;
            exp >>= 1;
        }
        return result;
    }

    public static double stdNormDistr(double x) {
        return Math.exp(-0.5 * (x * x)) / SQRT2PI;
    }

    public static double getWeightedDropChance(double x, double chance) {
        return (double)Math.max(0L, Math.round(x * chance * 0.6827 + chance)) * TSTMath.stdNormDistr(x);
    }
}

