/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch;

import bartworks.system.material.CircuitGeneration.BWMetaItems;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TST_CircuitImprintHatch
extends MTEHatch
implements IAddUIWidgets {
    private int timeout = 4;
    public HashSet<NBTTagCompound> circuitType = new HashSet();

    public TST_CircuitImprintHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, aTier > 5 ? 16 : 4, new String[]{TextEnums.tr("Tooltips.CircuitImprintHatch.01"), TextEnums.tr("Tooltips.CircuitImprintHatch.02") + (aTier > 5 ? 16 : 4) + TextEnums.tr("Tooltips.CircuitImprintHatch.03"), TextLocalization.ModNameDesc}, new ITexture[0]);
    }

    public TST_CircuitImprintHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aTier > 5 ? 16 : 4, aDescription, aTextures);
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_DATA_ACCESS)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_DATA_ACCESS)};
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_CircuitImprintHatch(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GTUIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.mTier >= 8 && !aBaseMetaTileEntity.isActive();
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.mTier >= 8 && !aBaseMetaTileEntity.isActive();
    }

    public int func_70297_j_() {
        return 1;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isActive()) {
            --this.timeout;
            if (this.timeout <= 0) {
                aBaseMetaTileEntity.setActive(false);
            }
        }
    }

    public void setActive(boolean mActive) {
        this.getBaseMetaTileEntity().setActive(mActive);
        this.timeout = mActive ? 4 : 0;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74771_c("mCircuitUpdated") != 1) {
            this.refreshImprint();
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mCircuitUpdated", (byte)1);
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        super.func_70299_a(aIndex, aStack);
        this.refreshImprint();
    }

    public HashSet<NBTTagCompound> getStoredCircuitImprints() {
        return this.circuitType;
    }

    public void refreshImprint() {
        this.circuitType = new HashSet();
        IGregTechTileEntity te = this.getBaseMetaTileEntity();
        for (int i = 0; i < te.func_70302_i_(); ++i) {
            ItemStack slot = te.func_70301_a(i);
            if (slot == null || !slot.func_77969_a(BWMetaItems.getCircuitParts().getStack(0, 0))) continue;
            this.circuitType.add(slot.field_77990_d);
        }
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.mTier > 5) {
            this.getBaseMetaTileEntity().add4by4Slots(builder, new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_CIRCUIT});
        } else {
            this.getBaseMetaTileEntity().add2by2Slots(builder, new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_CIRCUIT});
        }
    }
}

