/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch;

import com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch.GT_MetaTileEntity_Pipe_EnergySmart;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.render.TextureFactory;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.pipe.IConnectsToEnergyTunnel;
import tectech.thing.metaTileEntity.Textures;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoTunnel;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyTunnel;
import tectech.thing.metaTileEntity.pipe.MTEPipeLaser;
import tectech.thing.metaTileEntity.pipe.MTEPipeLaserMirror;
import tectech.util.CommonValues;

public class GT_MetaTileEntity_Pipe_EnergySmart_Focusing
extends MTETieredMachineBlock
implements IConnectsToEnergyTunnel {
    public long Voltage = 0L;
    public long Amperes = 0L;
    public long actualInputAmperes = 0L;
    public long actualOutputAmperes = 0L;
    public long tempActualInputAmpres = 0L;
    public long lastStoredEU = 0L;
    private static Textures.BlockIcons.CustomIcon EMCandyActive;
    private static Textures.BlockIcons.CustomIcon EMpipe;

    public GT_MetaTileEntity_Pipe_EnergySmart_Focusing(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 10, 0, (String)null, new ITexture[0]);
    }

    public GT_MetaTileEntity_Pipe_EnergySmart_Focusing(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        EMCandyActive = new Textures.BlockIcons.CustomIcon("iconsets/EM_CANDY_ACTIVE");
        EMpipe = new Textures.BlockIcons.CustomIcon("iconsets/EM_LASER");
        super.registerIcons(aBlockIconRegister);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity tile) {
        return new GT_MetaTileEntity_Pipe_EnergySmart_Focusing(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public void saveNBTData(NBTTagCompound tag) {
        tag.func_74772_a("Voltage", this.Voltage);
        tag.func_74772_a("Amperes", this.Amperes);
    }

    public void loadNBTData(NBTTagCompound tag) {
        this.Voltage = tag.func_74763_f("Voltage");
        this.Amperes = tag.func_74763_f("Amperes");
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, TextEnums.tr("LaserFocusedSmartNode.description.01"), TextEnums.tr("LaserFocusedSmartNode.description.02"), TextEnums.tr("LaserFocusedSmartNode.description.03"), TextEnums.tr("LaserFocusedSmartNode.description.04"), TextEnums.tr("LaserFocusedSmartNode.description.05"), TextEnums.AddByTwistSpaceTechnology.getText()};
    }

    public ITexture[] getTexture(IGregTechTileEntity te, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstone) {
        ITexture pipe = TextureFactory.of((IIconContainer)EMpipe);
        ITexture overlay = TextureFactory.of((IIconContainer)EMCandyActive, (short[])Dyes.getModulation((int)colorIndex, (short[])Dyes.MACHINE_METAL.getRGBA()));
        if (side == facing) {
            return new ITexture[]{pipe, Textures.OVERLAYS_ENERGY_OUT_LASER_TT[this.mTier], overlay};
        }
        return new ITexture[]{pipe, overlay};
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    public long maxEUInput() {
        return this.Voltage;
    }

    public long maxEUOutput() {
        return this.Voltage;
    }

    public long maxEUStore() {
        return 24L * this.Voltage * this.Amperes;
    }

    public long maxAmperesOut() {
        return this.Amperes;
    }

    public long maxAmperesIn() {
        return this.Amperes;
    }

    public long getMinimumStoredEU() {
        return this.Voltage;
    }

    public boolean isAccessAllowed(EntityPlayer p) {
        return true;
    }

    public boolean isFacingValid(ForgeDirection f) {
        return true;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public void doExplosion(long power) {
    }

    public void setEUVar(long newEU) {
        long deltaEU = newEU - this.lastStoredEU;
        if (deltaEU > 0L) {
            this.actualInputAmperes += deltaEU / (this.Voltage * 20L);
        } else if (deltaEU < 0L) {
            this.actualOutputAmperes += -deltaEU / (this.Voltage * 20L);
        }
        this.lastStoredEU = newEU;
        super.setEUVar(newEU);
    }

    public void onPostTick(IGregTechTileEntity base, long tick) {
        if (base.isServerSide() && tick % 20L == 0L) {
            this.actualInputAmperes = 0L;
            this.actualOutputAmperes = 0L;
            byte color = base.getColorization();
            if (color < 0) {
                return;
            }
            ArrayList<MetaTileEntity> inputs = new ArrayList<MetaTileEntity>();
            MetaTileEntity output = null;
            long maxVoltage = 0L;
            ForgeDirection front = base.getFrontFacing();
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                IMetaTileEntity found;
                if (dir == front) {
                    found = this.findMTE(base, color, dir, false);
                    if (!(found instanceof MTEHatchEnergyTunnel) && !(found instanceof GT_MetaTileEntity_Pipe_EnergySmart_Focusing) && !(found instanceof GT_MetaTileEntity_Pipe_EnergySmart)) continue;
                    output = (MetaTileEntity)found;
                    continue;
                }
                found = this.findMTE(base, color, dir, true);
                if (!(found instanceof MTEHatchDynamoTunnel) && !(found instanceof GT_MetaTileEntity_Pipe_EnergySmart_Focusing) && !(found instanceof GT_MetaTileEntity_Pipe_EnergySmart)) continue;
                MetaTileEntity input = (MetaTileEntity)found;
                inputs.add(input);
                maxVoltage = Math.max(maxVoltage, input.maxEUOutput());
            }
            this.Voltage = maxVoltage;
            this.Amperes = 0L;
            for (MetaTileEntity input : inputs) {
                if (input.maxEUOutput() != this.Voltage) continue;
                this.Amperes += input.maxAmperesOut();
            }
            if (this.maxEUStore() > this.getBaseMetaTileEntity().getStoredEU()) {
                for (MetaTileEntity input : inputs) {
                    if (input.maxEUOutput() != this.Voltage || !(input instanceof MTEHatchDynamoTunnel)) continue;
                    this.moveEnergy(input, (MetaTileEntity)this);
                }
            }
            if (output != null) {
                this.moveEnergy((MetaTileEntity)this, output);
            }
        }
        this.tempActualInputAmpres = this.actualInputAmperes;
    }

    private void moveEnergy(MetaTileEntity source, MetaTileEntity target) {
        long targetVoltage;
        long sourceVoltage = source.maxEUOutput();
        if (sourceVoltage > (targetVoltage = target.maxEUInput())) {
            target.doExplosion(sourceVoltage);
            return;
        }
        if (sourceVoltage < targetVoltage) {
            return;
        }
        long voltage = Math.min(sourceVoltage, targetVoltage);
        long amperes = Math.min(source.maxAmperesOut(), target.maxAmperesIn());
        if (voltage <= 0L || amperes <= 0L) {
            return;
        }
        long maxTransfer = voltage * amperes * 20L;
        long actualTransfer = Math.min(maxTransfer, Math.min(source.getBaseMetaTileEntity().getStoredEU(), target.maxEUStore() - target.getBaseMetaTileEntity().getStoredEU()));
        if (actualTransfer > 0L) {
            source.setEUVar(source.getBaseMetaTileEntity().getStoredEU() - actualTransfer);
            target.setEUVar(target.getBaseMetaTileEntity().getStoredEU() + actualTransfer);
        }
    }

    private IMetaTileEntity findMTE(IGregTechTileEntity base, byte color, ForgeDirection travel, boolean findProvider) {
        IMetaTileEntity mte;
        IGregTechTileEntity target;
        ForgeDirection facingSide = travel.getOpposite();
        for (int dist = 1; dist < 1000 && (target = base.getIGregTechTileEntityAtSideAndDistance(travel, dist)) != null && target.getColorization() == color && (mte = target.getMetaTileEntity()) != null; dist = (int)((short)(dist + 1))) {
            if (mte instanceof MTEPipeLaserMirror) {
                MTEPipeLaserMirror mirror = (MTEPipeLaserMirror)mte;
                ForgeDirection nextTravel = mirror.getBendDirection(facingSide);
                return this.findMTE(mirror.getBaseMetaTileEntity(), color, nextTravel, findProvider);
            }
            if (findProvider) {
                if (mte instanceof MTEHatchDynamoTunnel && facingSide == target.getFrontFacing()) {
                    return mte;
                }
                if (mte instanceof GT_MetaTileEntity_Pipe_EnergySmart_Focusing && facingSide == target.getFrontFacing()) {
                    return mte;
                }
                if (mte instanceof GT_MetaTileEntity_Pipe_EnergySmart && facingSide != target.getFrontFacing()) {
                    return mte;
                }
            } else {
                if (mte instanceof MTEHatchEnergyTunnel && facingSide == target.getFrontFacing()) {
                    return mte;
                }
                if (mte instanceof GT_MetaTileEntity_Pipe_EnergySmart_Focusing && facingSide != target.getFrontFacing()) {
                    return mte;
                }
                if (mte instanceof GT_MetaTileEntity_Pipe_EnergySmart && facingSide == target.getFrontFacing()) {
                    return mte;
                }
            }
            if (!(mte instanceof MTEPipeLaser)) break;
            MTEPipeLaser pipe = (MTEPipeLaser)mte;
            if (pipe.connectionCount < 2) break;
            pipe.markUsed();
        }
        return null;
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74772_a("wailaVoltage", this.Voltage);
        tag.func_74772_a("wailaAmperes", this.Amperes);
        tag.func_74772_a("wailaActualInputAmperes", this.actualInputAmperes);
        tag.func_74772_a("wailaActualOutputAmperes", this.actualOutputAmperes);
        tag.func_74772_a("wailaMaxEuStore", this.maxEUStore());
        tag.func_74772_a("wailaGetStoredEU", this.getBaseMetaTileEntity().getStoredEU());
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(EnumChatFormatting.AQUA + "Voltage: " + EnumChatFormatting.GOLD + tag.func_74763_f("wailaVoltage"));
        currentTip.add(EnumChatFormatting.AQUA + "Amperes: " + EnumChatFormatting.GOLD + tag.func_74763_f("wailaAmperes"));
        currentTip.add(EnumChatFormatting.AQUA + "Actual Input Amperes: " + EnumChatFormatting.GOLD + tag.func_74763_f("wailaActualInputAmperes"));
        currentTip.add(EnumChatFormatting.AQUA + "Actual Output Amperes: " + EnumChatFormatting.GOLD + tag.func_74763_f("wailaActualOutputAmperes"));
        currentTip.add(EnumChatFormatting.AQUA + "MaxEuStore: " + EnumChatFormatting.GOLD + tag.func_74763_f("wailaMaxEuStore"));
        currentTip.add(EnumChatFormatting.AQUA + "NowEuStore: " + EnumChatFormatting.GOLD + tag.func_74763_f("wailaGetStoredEU"));
    }

    public boolean allowPullStack(IGregTechTileEntity te, int i, ForgeDirection d, ItemStack s) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity te, int i, ForgeDirection d, ItemStack s) {
        return false;
    }

    public boolean canConnect(ForgeDirection side) {
        return true;
    }
}

