/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch;

import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.reflect.FieldUtils;
import tectech.TecTech;
import tectech.thing.gui.TecTechUITextures;
import tectech.util.TTUtility;

public class GT_Hatch_RackComputationMonitor
extends MTEHatch
implements IAddGregtechLogo,
IAddUIWidgets {
    private static Textures.BlockIcons.CustomIcon EM_R;
    private static Textures.BlockIcons.CustomIcon EM_R_ACTIVE;
    public int heat = 0;
    private float overClock = 1.0f;
    private float overVolt = 1.0f;
    private boolean isMeanHatch = false;
    public static final Map<String, RackComponent> componentBinds;
    private String clientLocale = "en_US";

    public GT_Hatch_RackComputationMonitor(int aID, String aName, String aNameRegional, int aTier, boolean isMeanHatch) {
        super(aID, aName, aNameRegional, aTier, 64, new String[]{TextLocalization.Mark_TwistSpaceTechnology_TecTech, StatCollector.func_74838_a((String)"tst.computationhatchmonitor.desc1"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tst.computationhatchmonitor.desc2")}, new ITexture[0]);
        TTUtility.setTier((int)aTier, (Object)((Object)this));
        this.isMeanHatch = isMeanHatch;
    }

    public GT_Hatch_RackComputationMonitor(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, boolean isMeanHatch) {
        super(aName, aTier, 64, aDescription, aTextures);
        this.isMeanHatch = isMeanHatch;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (!this.isMeanHatch) {
            return;
        }
        aNBT.func_74768_a("eHeat", this.heat);
        aNBT.func_74776_a("eOverClock", this.overClock);
        aNBT.func_74776_a("eOverVolt", this.overVolt);
    }

    public boolean isMeanHatch() {
        return this.isMeanHatch;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (!this.isMeanHatch) {
            return;
        }
        this.heat = aNBT.func_74762_e("eHeat");
        this.overClock = aNBT.func_74760_g("eOverClock");
        this.overVolt = aNBT.func_74760_g("eOverVolt");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        EM_R_ACTIVE = new Textures.BlockIcons.CustomIcon("iconsets/EM_RACK_ACTIVE");
        EM_R = new Textures.BlockIcons.CustomIcon("iconsets/EM_RACK");
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)EM_R_ACTIVE)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)EM_R)};
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_Hatch_RackComputationMonitor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures, this.isMeanHatch);
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return facing.offsetY == 0;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return this.isMeanHatch;
    }

    public boolean isValidSlot(int aIndex) {
        return this.isMeanHatch;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (!this.isMeanHatch || aBaseMetaTileEntity.isActive() || this.heat > 500) {
            return false;
        }
        return side == aBaseMetaTileEntity.getFrontFacing();
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (!this.isMeanHatch || aBaseMetaTileEntity.isActive() || this.heat > 500) {
            return false;
        }
        return side == aBaseMetaTileEntity.getFrontFacing();
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (!this.isMeanHatch) {
            return true;
        }
        try {
            EntityPlayerMP player = (EntityPlayerMP)aPlayer;
            this.clientLocale = (String)FieldUtils.readField((Object)player, (String)"translator", (boolean)true);
        }
        catch (Exception e) {
            this.clientLocale = "en_US";
        }
        GTUIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    private int getComputationPower(float overclock, float overvolt, boolean tickingComponents) {
        if (!this.isMeanHatch) {
            return 0;
        }
        float computation = 0.0f;
        float heat = 0.0f;
        for (int i = 0; i < this.mInventory.length; ++i) {
            RackComponent comp;
            if (this.mInventory[i] == null || (comp = componentBinds.get(TTUtility.getUniqueIdentifier((ItemStack)this.mInventory[i]))) == null) continue;
            if (tickingComponents && comp.subZero || this.heat >= 0) {
                heat += (1.0f + comp.coEff * (float)this.heat / 10000.0f) * (float)this.mInventory[i].field_77994_a * (comp.heat > 0.0f ? comp.heat * overclock * overclock * overvolt : comp.heat);
                if (!(overvolt * 10.0f > 7.0f + TecTech.RANDOM.nextFloat())) continue;
                computation += (float)((double)comp.computation * Math.max(0.0, Math.min(Math.min((double)overclock, (double)(overvolt + overvolt) - 0.25), (double)(1.0f + TecTech.RANDOM.nextFloat() + (overvolt - 1.0f) - (overclock - 1.0f) / 2.0f)))) * (float)this.mInventory[i].field_77994_a;
                continue;
            }
            computation += comp.computation * overclock * (float)this.mInventory[i].field_77994_a;
        }
        if (tickingComponents) {
            this.heat += (int)Math.ceil(heat);
        }
        return (int)Math.floor(computation);
    }

    public void postProcessAfterCoolant() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            RackComponent comp;
            if (this.mInventory[i] == null || (comp = componentBinds.get(TTUtility.getUniqueIdentifier((ItemStack)this.mInventory[i]))) == null || !((float)this.heat > comp.maxHeat * 64.0f * 64.0f)) continue;
            this.mInventory[i] = null;
        }
    }

    public int func_70297_j_() {
        if (!this.isMeanHatch) {
            return 0;
        }
        return 64;
    }

    public int tickComponents(float oc, float ov) {
        if (!this.isMeanHatch) {
            return 0;
        }
        if (oc > 1000.0f + TecTech.RANDOM.nextFloat() || ov > 1000.0f + TecTech.RANDOM.nextFloat()) {
            this.getBaseMetaTileEntity().setToFire();
        }
        this.overClock = oc;
        this.overVolt = ov;
        return this.getComputationPower(this.overClock, this.overVolt, true);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (!this.isMeanHatch) {
                return;
            }
            if (aTick % 20L == 12L) {
                if (this.heat > 0) {
                    --this.heat;
                } else if (this.heat < 0) {
                    this.heat -= -1;
                }
                if (this.heat > 40960000) {
                    aBaseMetaTileEntity.setToFire();
                } else if (this.heat < -10000) {
                    this.heat = -10000;
                }
                if (this.heat > 0) {
                    float heatC = 0.0f;
                    for (int i = 0; i < this.mInventory.length; ++i) {
                        RackComponent comp;
                        if (this.mInventory[i] == null || (comp = componentBinds.get(TTUtility.getUniqueIdentifier((ItemStack)this.mInventory[i]))) == null) continue;
                        if ((float)this.heat > comp.maxHeat * 64.0f * 64.0f) {
                            this.mInventory[i] = null;
                            continue;
                        }
                        if (!(comp.heat < 0.0f)) continue;
                        heatC += comp.heat * (float)this.mInventory[i].field_77994_a * ((float)this.heat / 10000.0f);
                    }
                    this.heat += (int)Math.max((double)(-this.heat), Math.ceil(heatC));
                }
            }
        }
    }

    public int func_70302_i_() {
        if (!this.isMeanHatch) {
            return 0;
        }
        return this.heat > 500 || this.getBaseMetaTileEntity().isActive() ? 0 : this.mInventory.length;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        if (!this.isMeanHatch) {
            return new String[]{StatCollector.func_74837_a((String)"tst.computationhatchmonitor.desc3", (Object[])new Object[0])};
        }
        return new String[]{StatCollector.func_74837_a((String)"tt.keyphrase.Base_computation", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.AQUA + this.getComputationPower(1.0f, 0.0f, false), StatCollector.func_74837_a((String)"tt.keyphrase.After_overclocking", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.AQUA + this.getComputationPower(this.overClock, 0.0f, false), StatCollector.func_74837_a((String)"tt.keyphrase.Heat_Accumulated", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.RED + (this.heat + 99) / 100 + EnumChatFormatting.RESET + " %"};
    }

    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PICTURE_TECTECH_LOGO).setSize(18, 18).setPos(181, 63));
    }

    public boolean doesBindPlayerInventory() {
        return false;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (!this.isMeanHatch) {
            return;
        }
        builder.setSize(206, 270);
        builder.bindPlayerInventory(buildContext.getPlayer(), new Pos2d(8, 181), (IDrawable)this.getGUITextureSet().getItemSlot());
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                Pos2d position = new Pos2d(8 + 22 * x, 5 + 22 * y);
                int i = 8 * x + y;
                builder.widget(new SlotWidget(new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, i){

                    public int func_75219_a() {
                        return 64;
                    }

                    public boolean isEnabled() {
                        return !GT_Hatch_RackComputationMonitor.this.getBaseMetaTileEntity().isActive() && GT_Hatch_RackComputationMonitor.this.heat <= 0;
                    }
                }).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), TecTechUITextures.OVERLAY_SLOT_RACK}).setPos(position));
            }
        }
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.BUTTON_STANDARD_LIGHT_16x16).setPos(181, 24).setSize(16, 16))).widget(new DrawableWidget().setDrawable(() -> this.getBaseMetaTileEntity().isActive() ? TecTechUITextures.OVERLAY_BUTTON_POWER_SWITCH_ON : TecTechUITextures.OVERLAY_BUTTON_POWER_SWITCH_DISABLED).setPos(181, 24).setSize(16, 16))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive(val.booleanValue())));
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.BUTTON_STANDARD_LIGHT_16x16).setPos(181, 41).setSize(16, 16))).widget(new DrawableWidget().setDrawable(() -> this.heat > 0 ? TecTechUITextures.OVERLAY_BUTTON_HEAT_ON : TecTechUITextures.OVERLAY_BUTTON_HEAT_OFF).setPos(181, 41).setSize(16, 16))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.heat, val -> {
            this.heat = val;
        }));
    }

    public static void run() {
        new RackComponent(ItemList.Circuit_Primitive.get(1L, new Object[0]), 1.0f, 4.0f, 0.0f, 500.0f, true);
        new RackComponent(ItemList.Circuit_Basic.get(1L, new Object[0]), 4.0f, 8.0f, 0.0f, 1000.0f, true);
        new RackComponent(ItemList.Circuit_Microprocessor.get(1L, new Object[0]), 6.0f, 8.0f, 0.0f, 1250.0f, true);
        new RackComponent(ItemList.Circuit_Good.get(1L, new Object[0]), 6.0f, 9.0f, -0.05f, 1500.0f, true);
        new RackComponent(ItemList.Circuit_Integrated_Good.get(1L, new Object[0]), 7.0f, 9.0f, -0.075f, 1750.0f, true);
        new RackComponent(ItemList.Circuit_Processor.get(1L, new Object[0]), 8.0f, 9.0f, -0.07f, 1800.0f, true);
        new RackComponent(ItemList.Circuit_Parts_Advanced.get(1L, new Object[0]), 1.0f, 2.0f, -0.05f, 2000.0f, true);
        new RackComponent(ItemList.Circuit_Nanoprocessor.get(1L, new Object[0]), 8.0f, 10.0f, -0.09f, 2250.0f, true);
        new RackComponent(ItemList.Circuit_Advanced.get(1L, new Object[0]), 8.0f, 10.0f, -0.1f, 2500.0f, true);
        new RackComponent(ItemList.Circuit_Data.get(1L, new Object[0]), 9.0f, 1.0f, -0.1f, 3000.0f, true);
        new RackComponent(ItemList.Circuit_Nanocomputer.get(1L, new Object[0]), 11.0f, 10.0f, -0.125f, 3300.0f, true);
        new RackComponent(ItemList.Circuit_Quantumprocessor.get(1L, new Object[0]), 13.0f, 10.0f, -0.15f, 3600.0f, true);
        new RackComponent(ItemList.Circuit_Elite.get(1L, new Object[0]), 12.0f, 10.0f, -0.15f, 3500.0f, true);
        new RackComponent(ItemList.Circuit_Elitenanocomputer.get(1L, new Object[0]), 14.0f, 10.0f, -0.15f, 4000.0f, true);
        new RackComponent(ItemList.Circuit_Quantumcomputer.get(1L, new Object[0]), 16.0f, 10.0f, -0.15f, 4500.0f, true);
        new RackComponent(ItemList.Circuit_Crystalprocessor.get(1L, new Object[0]), 18.0f, 10.0f, -0.15f, 5000.0f, true);
        new RackComponent(ItemList.Circuit_Master.get(1L, new Object[0]), 16.0f, 12.0f, -0.2f, 5000.0f, true);
        new RackComponent(ItemList.Circuit_Masterquantumcomputer.get(1L, new Object[0]), 16.0f, 13.0f, -0.2f, 5100.0f, true);
        new RackComponent(ItemList.Circuit_Crystalcomputer.get(1L, new Object[0]), 20.0f, 14.0f, -0.25f, 5200.0f, true);
        new RackComponent(ItemList.Circuit_Neuroprocessor.get(1L, new Object[0]), 24.0f, 15.0f, -0.3f, 5300.0f, true);
        new RackComponent(ItemList.Circuit_Quantummainframe.get(1L, new Object[0]), 22.0f, 14.0f, -0.3f, 5200.0f, true);
        new RackComponent(ItemList.Circuit_Ultimatecrystalcomputer.get(1L, new Object[0]), 26.0f, 16.0f, -0.3f, 5400.0f, true);
        new RackComponent(ItemList.Circuit_Wetwarecomputer.get(1L, new Object[0]), 30.0f, 18.0f, -0.3f, 5600.0f, true);
        new RackComponent(ItemList.Circuit_Crystalmainframe.get(1L, new Object[0]), 30.0f, 18.0f, -0.35f, 5500.0f, true);
        new RackComponent(ItemList.Circuit_Wetwaresupercomputer.get(1L, new Object[0]), 35.0f, 22.0f, -0.3f, 5700.0f, true);
        new RackComponent(ItemList.Circuit_Wetwaremainframe.get(1L, new Object[0]), 38.0f, 25.0f, -0.4f, 6000.0f, true);
        new RackComponent("IC2:ic2.reactorVent", 0.0f, -1.0f, 10.0f, 1000.0f, false);
        new RackComponent("IC2:ic2.reactorVentCore", 0.0f, -1.0f, 20.0f, 2500.0f, false);
        new RackComponent("IC2:ic2.reactorVentGold", 0.0f, -1.0f, 40.0f, 5000.0f, false);
        new RackComponent("IC2:ic2.reactorVentDiamond", 0.0f, -1.0f, 80.0f, 10000.0f, false);
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            new RackComponent(ItemList.NandChip.get(1L, new Object[0]), 2.0f, 6.0f, 0.0f, 750.0f, true);
            new RackComponent(ItemList.Circuit_Biowarecomputer.get(1L, new Object[0]), 40.0f, 26.0f, -0.35f, 5900.0f, true);
            new RackComponent(ItemList.Circuit_Biowaresupercomputer.get(1L, new Object[0]), 42.0f, 30.0f, -0.4f, 6200.0f, true);
            new RackComponent(ItemList.Circuit_Biomainframe.get(1L, new Object[0]), 44.0f, 28.0f, -0.4f, 6000.0f, true);
            new RackComponent(ItemList.Circuit_Bioprocessor.get(1L, new Object[0]), 34.0f, 20.0f, -0.35f, 5800.0f, true);
            new RackComponent("dreamcraft:item.HighEnergyCircuitParts", 3.0f, 2.0f, -0.1f, 9001.0f, true);
            new RackComponent("dreamcraft:item.HighEnergyFlowCircuit", 24.0f, 16.0f, -0.25f, 10000.0f, true);
            new RackComponent("dreamcraft:item.NanoCircuit", 50.0f, 35.0f, -0.45f, 8000.0f, true);
            new RackComponent("dreamcraft:item.PikoCircuit", 64.0f, 40.0f, -0.5f, 8500.0f, true);
            new RackComponent("dreamcraft:item.QuantumCircuit", 128.0f, 48.0f, -0.6f, 9000.0f, true);
        }
        if (Mods.OpenComputers.isModLoaded()) {
            new RackComponent("OpenComputers:item.oc.Transistor", 0.0f, 1.0f, 0.0f, 100.0f, true);
            new RackComponent("OpenComputers:item.oc.Microchip0", 7.0f, 12.0f, -0.05f, 1500.0f, true);
            new RackComponent("OpenComputers:item.oc.Microchip1", 18.0f, 20.0f, -0.1f, 3000.0f, true);
            new RackComponent("OpenComputers:item.oc.Microchip2", 25.0f, 22.0f, -0.15f, 4500.0f, true);
            new RackComponent("OpenComputers:item.oc.ALU", 10.0f, 15.0f, -0.05f, 3000.0f, true);
            new RackComponent("OpenComputers:item.oc.ControlUnit", 25.0f, 18.0f, -0.05f, 1500.0f, true);
            new RackComponent("OpenComputers:item.oc.ComponentBus0", 42.0f, 30.0f, -0.05f, 1500.0f, true);
            new RackComponent("OpenComputers:item.oc.ComponentBus1", 70.0f, 50.0f, -0.1f, 3000.0f, true);
            new RackComponent("OpenComputers:item.oc.ComponentBus2", 105.0f, 72.0f, -0.15f, 4500.0f, true);
            new RackComponent("OpenComputers:item.oc.CPU0", 106.0f, 73.0f, -0.1f, 1500.0f, true);
            new RackComponent("OpenComputers:item.oc.CPU1", 226.0f, 153.0f, -0.15f, 3000.0f, true);
            new RackComponent("OpenComputers:item.oc.CPU2", 374.0f, 241.0f, -0.2f, 4500.0f, true);
            new RackComponent("OpenComputers:item.oc.GraphicsCard0", 20.0f, 27.0f, -0.1f, 1500.0f, true);
            new RackComponent("OpenComputers:item.oc.GraphicsCard1", 62.0f, 67.0f, -0.2f, 3000.0f, true);
            new RackComponent("OpenComputers:item.oc.GraphicsCard2", 130.0f, 111.0f, -0.3f, 4500.0f, true);
            new RackComponent("OpenComputers:item.oc.APU0", 350.0f, 234.0f, -0.1f, 1500.0f, true);
            new RackComponent("OpenComputers:item.oc.APU1", 606.0f, 398.0f, -0.2f, 4500.0f, true);
            new RackComponent("OpenComputers:item.oc.APU2", 1590.0f, 1006.0f, -0.3f, 9000.0f, true);
        }
    }

    static {
        componentBinds = new HashMap<String, RackComponent>();
    }

    public static class RackComponent
    implements Comparable<RackComponent> {
        private final String unlocalizedName;
        private final float heat;
        private final float coEff;
        private final float computation;
        private final float maxHeat;
        private final boolean subZero;

        RackComponent(ItemStack is, float computation, float heat, float coEff, float maxHeat, boolean subZero) {
            this(TTUtility.getUniqueIdentifier((ItemStack)is), computation, heat, coEff, maxHeat, subZero);
        }

        RackComponent(String is, float computation, float heat, float coEff, float maxHeat, boolean subZero) {
            this.unlocalizedName = is;
            this.heat = heat;
            this.coEff = coEff;
            this.computation = computation;
            this.maxHeat = maxHeat;
            this.subZero = subZero;
            componentBinds.put(this.unlocalizedName, this);
            if (StructureLib.DEBUG_MODE) {
                TecTech.LOGGER.info((Object)("Component registered: " + this.unlocalizedName));
            }
        }

        @Override
        public int compareTo(RackComponent o) {
            return this.unlocalizedName.compareTo(o.unlocalizedName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof RackComponent) {
                return this.compareTo((RackComponent)obj) == 0;
            }
            return false;
        }
    }
}

