/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch;

import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_Hatch_BufferedEnergyHatch
extends MTEHatchEnergy {
    public boolean mCharge = false;
    public boolean mDecharge = false;
    public int mBatteryCount = 0;
    public int mChargeableCount = 0;
    private long count = 0L;
    private long mStored = 0L;
    private long mMax = 0L;

    public GT_Hatch_BufferedEnergyHatch(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, new String[]{TstUtils.tr("BufferedEnergyHatch.Tooltips.01"), TstUtils.tr("BufferedEnergyHatch.Tooltips.02"), TextLocalization.ModNameDesc});
    }

    public GT_Hatch_BufferedEnergyHatch(String aName, int aTier, int inventorySize, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, inventorySize, aDescription, aTextures);
    }

    public String[] getDescription() {
        String[] desc = new String[this.mDescriptionArray.length + 1];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        desc[this.mDescriptionArray.length] = this.mInventory.length + " " + TstUtils.tr("Slots");
        return desc;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public boolean isEnetOutput() {
        return true;
    }

    public boolean isTeleporterCompatible() {
        return false;
    }

    public long getMinimumStoredEU() {
        return GTValues.V[this.mTier] * 16L * (long)this.mInventory.length;
    }

    public long maxEUStore() {
        return GTValues.V[this.mTier] * 64L * (long)this.mInventory.length;
    }

    public long maxEUOutput() {
        return GTValues.V[this.mTier];
    }

    public long maxAmperesOut() {
        return 2L;
    }

    public int rechargerSlotCount() {
        return this.mCharge ? this.mInventory.length : 0;
    }

    public int dechargerSlotCount() {
        return this.mDecharge ? this.mInventory.length : 0;
    }

    public int getProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyStored();
    }

    public int maxProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyCapacity();
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GTUIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mCharge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mDecharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mBatteryCount = 0;
            this.mChargeableCount = 0;
            for (ItemStack tStack : this.mInventory) {
                if (!GTModHandler.isElectricItem((ItemStack)tStack, (byte)this.mTier)) continue;
                if (GTModHandler.isChargerItem((ItemStack)tStack)) {
                    ++this.mBatteryCount;
                }
                ++this.mChargeableCount;
            }
        }
        ++this.count;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        String name;
        if (GTModHandler.isElectricItem((ItemStack)aStack) && aStack.func_77977_a().startsWith("gt.metaitem.01.") && ((name = aStack.func_77977_a()).equals("gt.metaitem.01.32510") || name.equals("gt.metaitem.01.32511") || name.equals("gt.metaitem.01.32520") || name.equals("gt.metaitem.01.32521") || name.equals("gt.metaitem.01.32530") || name.equals("gt.metaitem.01.32531"))) {
            return ElectricItem.manager.getCharge(aStack) == 0.0;
        }
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (!GTUtility.isStackValid((ItemStack)aStack)) {
            return false;
        }
        return this.mInventory[aIndex] == null && GTModHandler.isElectricItem((ItemStack)aStack, (byte)this.mTier);
    }

    public int func_70297_j_() {
        return 1;
    }

    public long[] getStoredEnergy() {
        boolean scaleOverflow = false;
        boolean storedOverflow = false;
        long tScale = this.getBaseMetaTileEntity().getEUCapacity();
        long tStored = this.getBaseMetaTileEntity().getStoredEU();
        long tStep = 0L;
        if (this.mInventory != null) {
            for (ItemStack aStack : this.mInventory) {
                if (!GTModHandler.isElectricItem((ItemStack)aStack)) continue;
                if (aStack.func_77973_b() instanceof MetaBaseItem) {
                    Long[] stats = ((MetaBaseItem)aStack.func_77973_b()).getElectricStats(aStack);
                    if (stats == null) continue;
                    if (stats[0] > 0x3FFFFFFFFFFFFFFFL) {
                        scaleOverflow = true;
                    }
                    tScale += stats[0].longValue();
                    tStep = ((MetaBaseItem)aStack.func_77973_b()).getRealCharge(aStack);
                    if (tStep > 0x3FFFFFFFFFFFFFFFL) {
                        storedOverflow = true;
                    }
                    tStored += tStep;
                    continue;
                }
                if (!(aStack.func_77973_b() instanceof IElectricItem)) continue;
                tStored += (long)ElectricItem.manager.getCharge(aStack);
                tScale += (long)((IElectricItem)aStack.func_77973_b()).getMaxCharge(aStack);
            }
        }
        if (scaleOverflow) {
            tScale = Long.MAX_VALUE;
        }
        if (storedOverflow) {
            tStored = Long.MAX_VALUE;
        }
        return new long[]{tStored, tScale};
    }

    public String[] getInfoData() {
        this.updateStorageInfo();
        return new String[]{EnumChatFormatting.BLUE + this.getLocalName() + EnumChatFormatting.RESET, "Stored Items:", EnumChatFormatting.GREEN + GTUtility.formatNumbers((long)this.mStored) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)this.mMax) + EnumChatFormatting.RESET + " EU", "Average input:", GTUtility.formatNumbers((long)this.getBaseMetaTileEntity().getAverageElectricInput()) + " EU/t", "Average output:", GTUtility.formatNumbers((long)this.getBaseMetaTileEntity().getAverageElectricOutput()) + " EU/t"};
    }

    private void updateStorageInfo() {
        if (this.mMax == 0L || this.count > 20L) {
            long[] tmp = this.getStoredEnergy();
            this.mStored = tmp[0];
            this.mMax = tmp[1];
            this.count = 0L;
        }
    }

    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.stored", (Object[])new Object[]{GTUtility.formatNumbers((long)tag.func_74763_f("mStored")), GTUtility.formatNumbers((long)tag.func_74763_f("mMax"))}));
        long avgIn = tag.func_74763_f("AvgIn");
        long avgOut = tag.func_74763_f("AvgOut");
        currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.avg_in_with_amperage", (Object[])new Object[]{GTUtility.formatNumbers((long)avgIn), GTUtility.getAmperageForTier((long)avgIn, (byte)((byte)this.getInputTier())), GTUtility.getColoredTierNameFromTier((byte)((byte)this.getInputTier()))}));
        currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.avg_out_with_amperage", (Object[])new Object[]{GTUtility.formatNumbers((long)avgOut), GTUtility.getAmperageForTier((long)avgOut, (byte)((byte)this.getOutputTier())), GTUtility.getColoredTierNameFromTier((byte)((byte)this.getOutputTier()))}));
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        this.updateStorageInfo();
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74772_a("mStored", this.mStored);
        tag.func_74772_a("mMax", this.mMax);
        tag.func_74772_a("AvgIn", this.getBaseMetaTileEntity().getAverageElectricInput());
        tag.func_74772_a("AvgOut", this.getBaseMetaTileEntity().getAverageElectricOutput());
    }

    public boolean isGivingInformation() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        switch (this.mInventory.length) {
            case 4: {
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)2).startFromSlot(0).endAtSlot(3).slotCreator(index -> new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, (int)index){

                    public int func_75219_a() {
                        return 1;
                    }
                }).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(70, 25));
                break;
            }
            case 9: {
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)3).startFromSlot(0).endAtSlot(8).slotCreator(index -> new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, (int)index){

                    public int func_75219_a() {
                        return 1;
                    }
                }).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(61, 16));
                break;
            }
            case 16: {
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)4).startFromSlot(0).endAtSlot(15).slotCreator(index -> new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, (int)index){

                    public int func_75219_a() {
                        return 1;
                    }
                }).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(52, 7));
                break;
            }
            default: {
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)1).startFromSlot(0).endAtSlot(0).slotCreator(index -> new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, (int)index){

                    public int func_75219_a() {
                        return 1;
                    }
                }).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(79, 34));
            }
        }
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_Hatch_BufferedEnergyHatch(this.mName, this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }
}

