/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses;

import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.processingLogics.TstProcessingLogic;
import com.Nxer.TwistSpaceTechnology.common.misc.OverclockType;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public abstract class WirelessEnergyMultiMachineBase<T extends WirelessEnergyMultiMachineBase<T>>
extends GTCM_MultiMachineBase<T> {
    public static final String ZERO_STRING = "0";
    protected UUID ownerUUID;
    protected boolean isRecipeProcessing = false;
    protected boolean wirelessMode = this.getDefaultWirelessMode();
    protected BigInteger costingEU = BigInteger.ZERO;
    protected String costingEUText = "0";
    protected int cycleNum = Config.DefaultCycleNum_WirelessEnergyMultiMachineBase;

    public WirelessEnergyMultiMachineBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public WirelessEnergyMultiMachineBase(String aName) {
        super(aName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("wirelessMode", this.wirelessMode);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.wirelessMode = aNBT.func_74767_n("wirelessMode");
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.ownerUUID = aBaseMetaTileEntity.getOwnerUuid();
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("wirelessMode")) {
            currentTip.add(EnumChatFormatting.LIGHT_PURPLE + TextLocalization.Waila_WirelessMode);
            currentTip.add(EnumChatFormatting.AQUA + TextLocalization.Waila_CurrentEuCost + EnumChatFormatting.RESET + ": " + EnumChatFormatting.GOLD + tag.func_74779_i("costingEUText") + EnumChatFormatting.RESET + " EU");
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        IGregTechTileEntity tileEntity = this.getBaseMetaTileEntity();
        if (tileEntity != null) {
            tag.func_74757_a("wirelessMode", this.wirelessMode);
            if (this.wirelessMode) {
                tag.func_74778_a("costingEUText", this.costingEUText);
            }
        }
    }

    public void startRecipeProcessing() {
        this.isRecipeProcessing = true;
        super.startRecipeProcessing();
    }

    public void endRecipeProcessing() {
        super.endRecipeProcessing();
        this.isRecipeProcessing = false;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new TstProcessingLogic(){

            @NotNull
            public CheckRecipeResult process() {
                this.setEuModifier(WirelessEnergyMultiMachineBase.this.getEuModifier());
                this.setSpeedBonus(WirelessEnergyMultiMachineBase.this.getSpeedBonus());
                this.setOverclockType(WirelessEnergyMultiMachineBase.this.isEnablePerfectOverclock() ? OverclockType.PerfectOverclock : OverclockType.NormalOverclock);
                return super.process();
            }

            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return WirelessEnergyMultiMachineBase.this.wirelessMode ? OverclockCalculator.ofNoOverclock((GTRecipe)recipe) : super.createOverclockCalculator(recipe);
            }
        }.setMaxParallelSupplier(this::getLimitedMaxParallel);
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        this.costingEU = BigInteger.ZERO;
        this.costingEUText = ZERO_STRING;
        this.prepareProcessing();
        if (!this.wirelessMode) {
            return super.checkProcessing();
        }
        boolean succeeded = false;
        CheckRecipeResult finalResult = CheckRecipeResultRegistry.SUCCESSFUL;
        for (int i = 0; i < this.cycleNum; ++i) {
            CheckRecipeResult r = this.wirelessModeProcessOnce();
            if (!r.wasSuccessful()) {
                finalResult = r;
                break;
            }
            succeeded = true;
        }
        this.updateSlots();
        if (!succeeded) {
            return finalResult;
        }
        this.costingEUText = GTUtility.formatNumbers((BigInteger)this.costingEU);
        this.mEfficiency = 10000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = this.getWirelessModeProcessingTime();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    public CheckRecipeResult wirelessModeProcessOnce() {
        if (!this.isRecipeProcessing) {
            this.startRecipeProcessing();
        }
        this.setupProcessingLogic(this.processingLogic);
        this.setupWirelessProcessingPowerLogic(this.processingLogic);
        CheckRecipeResult result = this.doCheckRecipe();
        if (!result.wasSuccessful()) {
            return result;
        }
        BigInteger costEU = BigInteger.valueOf(this.processingLogic.getCalculatedEut()).multiply(BigInteger.valueOf(this.processingLogic.getDuration()));
        int m = this.getExtraEUCostMultiplier();
        if (m > 1) {
            costEU = costEU.multiply(BigInteger.valueOf(m));
        }
        if (!WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)this.ownerUUID, (BigInteger)costEU.multiply(TstUtils.NEGATIVE_ONE))) {
            return CheckRecipeResultRegistry.insufficientPower((long)costEU.longValue());
        }
        this.costingEU = this.costingEU.add(costEU);
        this.mOutputItems = (ItemStack[])ArrayUtils.addAll((Object[])this.mOutputItems, (Object[])this.processingLogic.getOutputItems());
        this.mOutputFluids = (FluidStack[])ArrayUtils.addAll((Object[])this.mOutputFluids, (Object[])this.processingLogic.getOutputFluids());
        this.endRecipeProcessing();
        return result;
    }

    protected void prepareProcessing() {
    }

    protected void setupWirelessProcessingPowerLogic(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(1L);
        logic.setAmperageOC(false);
    }

    public int getExtraEUCostMultiplier() {
        return 1;
    }

    public abstract int getWirelessModeProcessingTime();

    public boolean getDefaultWirelessMode() {
        return false;
    }
}

