/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import bartworks.API.BorosilicateGlass;
import bwcrossmod.galacticgreg.VoidMinerUtility;
import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.common.machine.ValueEnum;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.misc.WirelessNetworkManager;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.thing.casing.TTCasingsContainer;

public class TST_StarcoreMiner
extends GTCM_MultiMachineBase<TST_StarcoreMiner> {
    private static final int horizontalOffSetMain = 10;
    private static final int verticalOffSetMain = 22;
    private static final int depthOffSetMain = 1;
    private static final int horizontalOffSetMiddle = 4;
    private static final int verticalOffSetMiddle = -4;
    private static final int depthOffSetMiddle = -15;
    private static final int horizontalOffSetEnd = 0;
    private static final int depthOffSetEnd = -19;
    private static final String STRUCTURE_PIECE_MAIN = "mainStarcoreMiner";
    private static final String STRUCTURE_PIECE_MIDDLE = "middleStarcoreMiner";
    private static final String STRUCTURE_PIECE_END = "endStarcoreMiner";
    private static IStructureDefinition<TST_StarcoreMiner> STRUCTURE_DEFINITION;
    protected VoidMinerUtility.DropMap dropMap = null;
    protected VoidMinerUtility.DropMap extraDropMap = null;
    protected float totalWeight = 0.0f;
    protected boolean isWirelessMode = false;
    protected UUID ownerUUID;

    public TST_StarcoreMiner(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_StarcoreMiner(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_StarcoreMiner(this.mName);
    }

    public IStructureDefinition<TST_StarcoreMiner> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"        GGGGG        ", "       GGGGGGG       ", "      GGGGGGGGG      ", "      GGGGGGGGG      ", "      GGGGGGGGG      ", "      GGGGGGGGG      ", "      GGGGGGGGG      ", "       GGGGGGG       ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "        GGGGG        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HGIGH        ", "        GGIGG        ", "         AIA         ", "         AIA         ", "         AIA         ", "         AIA         ", "         AIA         ", "         AIA         ", "         AIA         ", "         AIA         ", "         AIA         ", "         AIA         ", "         AIA         ", "         AIA         ", "         CCC         ", "         CIC         ", "         CCC         ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDGDH        ", "        GDGDG        ", "         DGD         ", "         DGD         ", "         DGD         ", "         DGD         ", "         DGD         ", "         DGD         ", "         DGD         ", "         DGD         ", "         DGD         ", "         DGD         ", "         DGD         ", "         DGD         ", "         CCC         ", "         CIC         ", "         CCC         ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "         GGG         ", "         GIG         ", "         GGG         ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "          K          ", "         KIK         ", "          K          ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "                     ", "        BBBBB        ", "      BBBBBBBBB      ", "     BBB     BBB     ", "    BBB       BBB    ", "    BB         BB    ", "   BB           BB   ", "   BB     K     BB   ", "   BB    KIK    BB   ", "   BB     K     BB   ", "   BB           BB   ", "    BB         BB    ", "    BBB       BBB    ", "     BBB     BBB     ", "      BBBBBBBBB      ", "        BBBBB        ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "        G   G        ", "        HHAHH        ", "         GIG         ", "        HDADH        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "                     ", "        EEEEE        ", "      EEEEEEEEE      ", "    EEEEEEEEEEEEE    ", "    EEEEEEEEEEEEE    ", "   EEEEEFFFFFEEEEE   ", "   EEEEFF   FFEEEE   ", "  EEEEFF     FFEEEE  ", "  EEEEF   K   FEEEE  ", "  EEEEF  KIK  FEEEE  ", "  EEEEF   K   FEEEE  ", "  EEEEFF     FFEEEE  ", "   EEEEFF   FFEEEE   ", "   EEEEEFFFFFEEEEE   ", "    EEEEEEEEEEEEE    ", "    EEEEEEEEEEEEE    ", "      EEEEEEEEE      ", "        EEEEE        ", "                     ", "                     "}, {"                     ", "         LLL         ", "        GGGGG        ", "       HHGGGHH       ", "         GIG         ", "       HHGGGHH       ", "        GLLLG        ", "        G   G        ", "                     ", "                     ", "                     ", "                     ", "        EEEEE        ", "      EEEEEEEEE      ", "    EEEEEEEEEEEEE    ", "    EEEEEEEEEEEEE    ", "   EEEEEFFFFFEEEEE   ", "   EEEEFFFFFFFEEEE   ", "  EEEEFFF   FFFEEEE  ", "  EEEEFF  K  FFEEEE  ", "  EEEEFF KIK FFEEEE  ", "  EEEEFF  K  FFEEEE  ", "  EEEEFFF   FFFEEEE  ", "   EEEEFFFFFFFEEEE   ", "   EEEEEFFFFFEEEEE   ", "    EEEEEEEEEEEEE    ", "    EEEEEEEEEEEEE    ", "      EEEEEEEEE      ", "        EEEEE        ", "                     ", "                     "}, {"                     ", "         L~L         ", "        GGIGG        ", "      HHHGIGHHH      ", "         GIG         ", "      HHHGGGHHH      ", "        GLLLG        ", "        G   G        ", "        G   G        ", "                     ", "                     ", "                     ", "        EEEEE        ", "      EEEEEEEEE      ", "    EEEEEEEEEEEEE    ", "    EEEEEEEEEEEEE    ", "   EEEEEFFFFFEEEEE   ", "   EEEEFFFFFFFEEEE   ", "  EEEEFFF   FFFEEEE  ", "  EEEEFF  K  FFEEEE  ", "  EEEEFF KIK FFEEEE  ", "  EEEEFF  K  FFEEEE  ", "  EEEEFFF   FFFEEEE  ", "   EEEEFFFFFFFEEEE   ", "   EEEEEFFFFFEEEEE   ", "    EEEEEEEEEEEEE    ", "    EEEEEEEEEEEEE    ", "      EEEEEEEEE      ", "        EEEEE        ", "                     ", "                     "}, {"                     ", "         LLL         ", "        GGGGG        ", "     HHHHGGGHHHH     ", "         GGG         ", "     HHHHGGGHHHH     ", "        GLLLG        ", "        G   G        ", "        G   G        ", "        G   G        ", "                     ", "                     ", "        EEEEE        ", "      EEEEEEEEE      ", "    EEEEEEEEEEEEE    ", "    EEEEEEEEEEEEE    ", "   EEEEEFFFFFEEEEE   ", "   EEEEFFFFFFFEEEE   ", "  EEEEFFF   FFFEEEE  ", "  EEEEFF  K  FFEEEE  ", "  EEEEFF KIK FFEEEE  ", "  EEEEFF  K  FFEEEE  ", "  EEEEFFF   FFFEEEE  ", "   EEEEFFFFFFFEEEE   ", "   EEEEEFFFFFEEEEE   ", "    EEEEEEEEEEEEE    ", "    EEEEEEEEEEEEE    ", "      EEEEEEEEE      ", "        EEEEE        ", "                     ", "                     "}, {"                     ", "       JJLLLJJ       ", "      JJJJJJJJJ      ", "     HHHHJJJHHHH     ", "      JJJJJJJJJ      ", "     HHHHJJJHHHH     ", "      JJJJJJJJJ      ", "      JJJJJJJJJ      ", "      JJJJJJJJJ      ", "      JJJJJJJJJ      ", "      JJJJJJJJJ      ", "      JJJJJJJJJ      ", "    JJJJJJJJJJJJJ    ", "   JJJJJJJJJJJJJJJ   ", "  JJJJJJJJJJJJJJJJJ  ", "  JJJJJJJJJJJJJJJJJ  ", " JJJJJJJFFFFFJJJJJJJ ", " JJJJJJFFFFFFFJJJJJJ ", "JJJJJJFFF   FFFJJJJJJ", "JJJJJJFF  K  FFJJJJJJ", "JJJJJJFF KIK FFJJJJJJ", "JJJJJJFF  K  FFJJJJJJ", "JJJJJJFFF   FFFJJJJJJ", " JJJJJJFFFFFFFJJJJJJ ", " JJJJJJJFFFFFJJJJJJJ ", "  JJJJJJJJJJJJJJJJJ  ", "  JJJJJJJJJJJJJJJJJ  ", "   JJJJJJJJJJJJJJJ   ", "    JJJJJJJJJJJJJ    ", "      JJJJJJJJJ      ", "        JJJJJ        "}, {"                     ", "       JJLLLJJ       ", "      JJJJJJJJJ      ", "     HHHHJJJHHHH     ", "      JJJJJJJJJ      ", "     HHHHJJJHHHH     ", "      JJJJJJJJJ      ", "      JJJJJJJJJ      ", "      JJJJJJJJJ      ", "      JJJJJJJJJ      ", "      JJJJJJJJJ      ", "      JJJJJJJJJ      ", "    JJJJJJJJJJJJJ    ", "   JJJJJJJJJJJJJJJ   ", "  JJJJJJJJJJJJJJJJJ  ", "  JJJJJJJJJJJJJJJJJ  ", " JJJJJJJFFFFFJJJJJJJ ", " JJJJJJFFFFFFFJJJJJJ ", "JJJJJJFFF   FFFJJJJJJ", "JJJJJJFF  K  FFJJJJJJ", "JJJJJJFF KIK FFJJJJJJ", "JJJJJJFF  K  FFJJJJJJ", "JJJJJJFFF   FFFJJJJJJ", " JJJJJJFFFFFFFJJJJJJ ", " JJJJJJJFFFFFJJJJJJJ ", "  JJJJJJJJJJJJJJJJJ  ", "  JJJJJJJJJJJJJJJJJ  ", "   JJJJJJJJJJJJJJJ   ", "    JJJJJJJJJJJJJ    ", "      JJJJJJJJJ      ", "        JJJJJ        "}})).addShape(STRUCTURE_PIECE_MIDDLE, StructureUtility.transpose((String[][])new String[][]{{"  FFFFF  ", " FFFFFFF ", "FFF   FFF", "FF  K  FF", "FF KIK FF", "FF  K  FF", "FFF   FFF", " FFFFFFF ", "  FFFFF  "}})).addShape(STRUCTURE_PIECE_END, (String[][])new String[][]{{"Z"}}).addElement('A', BorosilicateGlass.ofBoroGlassAnyTier()).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)14)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)15)).addElement('E', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)7)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)10)).addElement('G', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSE, (int)0)).addElement('H', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSE, (int)1)).addElement('I', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)8)).addElement('J', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsDyson, (int)9)).addElement('K', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{BorosilicateGlass.ofBoroGlassAnyTier(), GTStructureUtility.ofFrame((Materials)Materials.NaquadahAlloy), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)10)})).addElement('L', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).adder(GTCM_MultiMachineBase::addToMachineList).dot(1).casingIndex(4096).buildAndChain(GregTechAPI.sBlockCasingsSE, 0)).addElement('Z', StructureUtility.ofBlock((Block)Blocks.field_150357_h, (int)0)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 10, 22, 1);
        int piece = stackSize.field_77994_a;
        for (int i = 0; i < piece; ++i) {
            this.buildPiece(STRUCTURE_PIECE_MIDDLE, stackSize, hintsOnly, 4, -4 - i, -15);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int builtMain = this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 10, 22, 1, elementBudget, env, false, true);
        int piece = stackSize.field_77994_a - 1;
        int builtMiddle = 0;
        int builtMiddleCurrent = 0;
        boolean triedBuiltMiddle = false;
        if (piece > 0) {
            for (int i = 0; i < piece; ++i) {
                builtMiddleCurrent = this.survivialBuildPiece(STRUCTURE_PIECE_MIDDLE, stackSize, 4, -4 - i, -15, elementBudget, env, false, true);
                if (builtMiddleCurrent == -1) continue;
                builtMiddle += builtMiddleCurrent;
                triedBuiltMiddle = true;
            }
        }
        if (builtMiddle == 0 && !triedBuiltMiddle) {
            builtMiddle = -1;
        }
        if (builtMain == -1 && builtMiddle == -1) {
            return -1;
        }
        if (builtMain == -1 && builtMiddle >= 0) {
            return builtMiddle;
        }
        if (builtMiddle == -1 && builtMain >= 0) {
            return builtMain;
        }
        return builtMain + builtMiddle;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        IGregTechTileEntity b;
        short y_value;
        this.repairMachine();
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 10, 22, 1)) {
            IGregTechTileEntity b2 = this.getBaseMetaTileEntity();
            TwistSpaceTechnology.LOG.info("TST: Starcore Miner check main structure failed at x=" + b2.getXCoord() + " y=" + b2.getYCoord() + " z=" + b2.getZCoord());
            return false;
        }
        if (Config.CheckMiningPipeStructure_StarcoreMiner && (y_value = (b = this.getBaseMetaTileEntity()).getYCoord()) > ValueEnum.HeightValueLimit_StarcoreMiner) {
            int needPiece = y_value - ValueEnum.HeightValueLimit_StarcoreMiner;
            for (int p = 0; p < needPiece; ++p) {
                if (this.checkPiece(STRUCTURE_PIECE_MIDDLE, 4, -4 - p, -15)) continue;
                if (this.checkPiece(STRUCTURE_PIECE_END, 0, -4 - p, -19)) break;
                TwistSpaceTechnology.LOG.info("TST: Starcore Miner check main structure failed at x=" + b.getXCoord() + " y=" + b.getYCoord() + " z=" + b.getZCoord() + " p=" + p);
                return false;
            }
        }
        this.isWirelessMode = this.mEnergyHatches.isEmpty() && this.mExoticEnergyHatches.isEmpty();
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isWirelessMode", this.isWirelessMode);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isWirelessMode = aNBT.func_74767_n("isWirelessMode");
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (this.dropMap == null || this.totalWeight == 0.0f) {
            TwistSpaceTechnology.LOG.info("WARNING! Starcore Miner dropmap = null when checkProcessing ! Dim = " + this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
            TwistSpaceTechnology.LOG.info("In dimension : " + this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
            TwistSpaceTechnology.LOG.info("dropMap : " + this.dropMap);
            TwistSpaceTechnology.LOG.info("totalWeight : " + this.totalWeight);
            TwistSpaceTechnology.LOG.info("extraDropMap : " + this.extraDropMap);
            if (Config.DebugMode_StarcoreMiner) {
                TwistSpaceTechnology.LOG.info("Trying to re-generate drop map.");
            }
        }
        if (this.totalWeight != 0.0f) {
            if (this.isWirelessMode) {
                this.lEUt = 0L;
                if (!WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)this.ownerUUID, (long)(-1L * (long)ValueEnum.DurationPerMining_StarcoreMiner * (long)ValueEnum.Eut_StarcoreMiner))) {
                    this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
                    return CheckRecipeResultRegistry.insufficientPower((long)((long)ValueEnum.DurationPerMining_StarcoreMiner * (long)ValueEnum.Eut_StarcoreMiner));
                }
            } else {
                this.lEUt = -ValueEnum.Eut_StarcoreMiner;
            }
            this.mOutputItems = new ItemStack[ValueEnum.AmountOfOreStackPerMining_StarcoreMiner];
            for (int i = 0; i < ValueEnum.AmountOfOreStackPerMining_StarcoreMiner; ++i) {
                this.mOutputItems[i] = this.generateOneStackOre();
            }
            this.updateSlots();
            this.mMaxProgresstime = ValueEnum.DurationPerMining_StarcoreMiner;
            this.mEfficiency = 10000;
            this.mEfficiencyIncrease = 10000;
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        this.stopMachine(ShutDownReasonRegistry.CRITICAL_NONE);
        return CheckRecipeResultRegistry.NO_RECIPE;
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.ownerUUID = aBaseMetaTileEntity.getOwnerUuid();
        if (aBaseMetaTileEntity.isServerSide()) {
            this.initDropMap();
        }
    }

    protected void initDropMap() {
        this.dropMap = new VoidMinerUtility.DropMap();
        this.extraDropMap = new VoidMinerUtility.DropMap();
        int id = this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g;
        this.handleModDimDef(id);
        this.handleExtraDrops(id);
        this.totalWeight = this.dropMap.getTotalWeight() + this.extraDropMap.getTotalWeight();
    }

    private void handleModDimDef(int id) {
        if (VoidMinerUtility.dropMapsByDimId.containsKey(id)) {
            this.dropMap = (VoidMinerUtility.DropMap)VoidMinerUtility.dropMapsByDimId.get(id);
        } else {
            String chunkProviderName = ((ChunkProviderServer)this.getBaseMetaTileEntity().getWorld().func_72863_F()).field_73246_d.getClass().getName();
            if (VoidMinerUtility.dropMapsByChunkProviderName.containsKey(chunkProviderName)) {
                this.dropMap = (VoidMinerUtility.DropMap)VoidMinerUtility.dropMapsByChunkProviderName.get(chunkProviderName);
            }
        }
    }

    private void handleExtraDrops(int id) {
        if (VoidMinerUtility.extraDropsDimMap.containsKey(id)) {
            this.extraDropMap = (VoidMinerUtility.DropMap)VoidMinerUtility.extraDropsDimMap.get(id);
        }
    }

    private ItemStack generateOneStackOre() {
        ItemStack nextOre = this.nextOre();
        nextOre.field_77994_a = ValueEnum.StackSizeOfEveryOreItemStackWhenMining_StarcoreMiner;
        return nextOre;
    }

    private ItemStack nextOre() {
        Map.Entry entry2;
        float currentWeight = 0.0f;
        block0: while (true) {
            float randomNumber = XSTR.XSTR_INSTANCE.nextFloat() * this.totalWeight;
            for (Map.Entry entry2 : this.dropMap.getInternalMap().entrySet()) {
                if (!(randomNumber < (currentWeight += ((Float)entry2.getValue()).floatValue()))) continue;
                return ((GTUtility.ItemId)entry2.getKey()).getItemStack();
            }
            Iterator iterator = this.extraDropMap.getInternalMap().entrySet().iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while (!(randomNumber < (currentWeight += ((Float)(entry2 = iterator.next()).getValue()).floatValue())));
            break;
        }
        return ((GTUtility.ItemId)entry2.getKey()).getItemStack();
    }

    public boolean isRotationChangeAllowed() {
        return false;
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return false;
    }

    @Override
    protected float getSpeedBonus() {
        return 1.0f;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return false;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public boolean supportsInputSeparation() {
        return false;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextEnums.tr("VoidMiner")).addInfo(" ").addInfo(TextEnums.tr("Tooltip_Starcore_01")).addInfo(TextEnums.tr("Tooltip_Starcore_02")).addInfo(TextEnums.tr("Tooltip_Starcore_03")).addInfo(TextEnums.tr("Tooltip_Starcore_04")).addInfo(TextEnums.tr("Tooltip_Starcore_05")).addInfo(TextEnums.tr("Tooltip_Starcore_06")).addInfo(TextEnums.tr("Tooltip_Starcore_07")).addInfo(TextEnums.tr("Tooltip_Starcore_08")).addInfo(TextLocalization.Tooltips_JoinWirelessNetWithoutEnergyHatch).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addOutputBus(TextLocalization.textUseBlueprint, new int[]{1}).addEnergyHatch(TextLocalization.textUseBlueprint, new int[]{1}).addStructureInfo(TextLocalization.Tooltip_DoNotNeedMaintenance).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_DTPF_ON).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FUSION1_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_DTPF_OFF).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096)};
    }
}

