/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.TT_MultiMachineBase_EM;
import com.Nxer.TwistSpaceTechnology.util.TstSharedLocalization;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jetbrains.annotations.NotNull;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.hatch.MTEHatchRack;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;
import tectech.util.CommonValues;

public class TST_ResearchCenter
extends TT_MultiMachineBase_EM
implements ISurvivalConstructable {
    public static final String machine = "EM Machinery";
    public static final String crafter = "EM Crafting";
    private final ArrayList<MTEHatchRack> eHolders = new ArrayList();
    private boolean Training;
    private static final String assembly = "Assembly line";
    private ItemStack holdItem;
    private long computationRemaining;
    private long computationRequired;
    private static final String[] description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.hint.1")};
    private String clientLocale = "en_US";
    private static final IStructureDefinition<TST_ResearchCenter> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"   ", " A ", " A ", "AAA", "AAA", "AAA", "AAA"}, {"AAA", "ACA", "ACA", "ACA", "BCB", "BCB", "BBB"}, {"   ", " C ", "   ", "   ", "ACA", "CCC", "DDD"}, {"   ", " E ", "   ", "   ", "A~A", "CCC", "DDD"}, {"   ", " C ", "   ", "   ", "ACA", "CCC", "DDD"}, {"AAA", "ACA", "ACA", "ACA", "BCB", "BCB", "BBB"}, {"   ", " A ", " A ", "AAA", "AAA", "AAA", "AAA"}})).addElement('A', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)1)).addElement('B', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)2)).addElement('C', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)3)).addElement('D', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_ResearchCenter.class).atLeast(new IHatchElement[]{HatchElement.Energy.or((IHatchElement)TTMultiblockBase.HatchElement.EnergyMulti), HatchElement.Maintenance, TTMultiblockBase.HatchElement.InputData}).casingIndex(1025).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)1)})).addElement('E', HolderHatchElement.INSTANCE.newAny(1027, 2)).build();

    public TST_ResearchCenter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_ResearchCenter(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_ResearchCenter(this.mName);
    }

    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        for (MTEHatchRack rack : (ArrayList)GTUtility.filterValidMTEs(this.eHolders)) {
            rack.getBaseMetaTileEntity().setActive(false);
        }
        this.eHolders.clear();
        if (!this.structureCheck_EM("main", 1, 3, 4)) {
            return false;
        }
        for (MTEHatchRack rack : (ArrayList)GTUtility.filterValidMTEs(this.eHolders)) {
            rack.getBaseMetaTileEntity().setActive(iGregTechTileEntity.isActive());
        }
        return this.eHolders.size() == 1;
    }

    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        ItemStack controllerStack = this.getControllerSlot();
        if (!this.eHolders.isEmpty() && this.eHolders.get((int)0).mInventory[0] != null) {
            this.holdItem = this.eHolders.get((int)0).mInventory[0].func_77946_l();
            if (ItemList.Tool_DataOrb.isStackEqual((Object)controllerStack, false, true)) {
                this.computationRemaining = 200000000L;
                this.computationRequired = 200000000L;
                this.mMaxProgresstime = 20;
                this.mEfficiencyIncrease = 10000;
                this.eRequiredData = 1919810L;
                this.eAmpereFlow = (short)(this.eRequiredData & 0xFFFFL);
                this.lEUt = -33554432L;
                this.eHolders.get(0).getBaseMetaTileEntity().setActive(true);
                return SimpleCheckRecipeResult.ofSuccess((String)"Training");
            }
            return CheckRecipeResultRegistry.NO_DATA_STICKS;
        }
        this.holdItem = null;
        this.computationRemaining = 0L;
        this.computationRequired = 0L;
        for (MTEHatchRack r : this.eHolders) {
            r.getBaseMetaTileEntity().setActive(false);
        }
        return SimpleCheckRecipeResult.ofFailure((String)"no_research_item");
    }

    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.name")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.desc.0")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.desc.1")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.desc.2")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.desc.3")).addInfo(TstSharedLocalization.MachineTooltip.tooComplex()).addSeparator().beginStructureBlock(3, 7, 7, false).addOtherStructurePart(StatCollector.func_74838_a((String)"gt.blockmachines.hatch.holder.tier.09.name"), StatCollector.func_74838_a((String)"tt.keyword.Structure.CenterPillar"), new int[]{2}).addOtherStructurePart(StatCollector.func_74838_a((String)"tt.keyword.Structure.DataConnector"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingBackMain"), new int[]{1}).addEnergyHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingBackMain"), new int[]{1}).addMaintenanceHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingBackMain"), new int[]{1}).toolTipFinisher(new String[]{CommonValues.TEC_MARK_EM});
        return tt;
    }

    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchEnergy tHatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mEnergyHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        for (MTEHatchEnergy tHatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.eEnergyMulti)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74837_a((String)"tt.keyphrase.Energy_Hatches", (Object[])new Object[]{this.clientLocale}) + ":", EnumChatFormatting.GREEN + GTUtility.formatNumbers((long)storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)maxEnergy) + EnumChatFormatting.RESET + " EU", (this.mEUt <= 0 ? StatCollector.func_74837_a((String)"tt.keyphrase.Probably_uses", (Object[])new Object[]{this.clientLocale}) + ": " : StatCollector.func_74837_a((String)"tt.keyphrase.Probably_makes", (Object[])new Object[]{this.clientLocale}) + ": ") + EnumChatFormatting.RED + GTUtility.formatNumbers((long)Math.abs(this.mEUt)) + EnumChatFormatting.RESET + " EU/t " + StatCollector.func_74837_a((String)"tt.keyword.at", (Object[])new Object[]{this.clientLocale}) + " " + EnumChatFormatting.RED + GTUtility.formatNumbers((long)this.eAmpereFlow) + EnumChatFormatting.RESET + " A", StatCollector.func_74837_a((String)"tt.keyphrase.Tier_Rating", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.YELLOW + GTValues.VN[this.getMaxEnergyInputTier_EM()] + EnumChatFormatting.RESET + " / " + EnumChatFormatting.GREEN + GTValues.VN[this.getMinEnergyInputTier_EM()] + EnumChatFormatting.RESET + " " + StatCollector.func_74837_a((String)"tt.keyphrase.Amp_Rating", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers((long)this.eMaxAmpereFlow) + EnumChatFormatting.RESET + " A", StatCollector.func_74837_a((String)"tt.keyword.Problems", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74837_a((String)"tt.keyword.Efficiency", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74837_a((String)"tt.keyword.PowerPass", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.BLUE + this.ePowerPass + EnumChatFormatting.RESET + " " + StatCollector.func_74837_a((String)"tt.keyword.SafeVoid", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.BLUE + this.eSafeVoid, StatCollector.func_74837_a((String)"tt.keyphrase.Computation_Available", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers((long)this.eAvailableData) + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)this.eRequiredData) + EnumChatFormatting.RESET, StatCollector.func_74837_a((String)"tt.keyphrase.Computation_Remaining", (Object[])new Object[]{this.clientLocale}) + ":", EnumChatFormatting.GREEN + GTUtility.formatNumbers((long)(this.computationRemaining / 20L)) + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)(this.computationRequired / 20L))};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3], new TTRenderedExtendedFacingTexture((IIconContainer)(aActive ? TTMultiblockBase.ScreenON : TTMultiblockBase.ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3]};
    }

    public void onRemoval() {
        super.onRemoval();
        for (MTEHatchRack r : this.eHolders) {
            r.getBaseMetaTileEntity().setActive(false);
        }
    }

    protected void extraExplosions_EM() {
        for (MetaTileEntity metaTileEntity : this.eHolders) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GTValues.V[9]);
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("eComputationRemaining", this.computationRemaining);
        aNBT.func_74772_a("eComputationRequired", this.computationRequired);
        if (this.holdItem != null) {
            aNBT.func_74782_a("eHold", (NBTBase)this.holdItem.func_77955_b(new NBTTagCompound()));
        } else {
            aNBT.func_82580_o("eHold");
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.computationRemaining = aNBT.func_74763_f("eComputationRemaining");
        this.computationRequired = aNBT.func_74763_f("eComputationRequired");
        this.holdItem = aNBT.func_74764_b("eHold") ? ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("eHold")) : null;
    }

    public void stopMachine() {
        super.stopMachine();
        for (MTEHatchRack r : this.eHolders) {
            r.getBaseMetaTileEntity().setActive(false);
        }
        this.computationRemaining = 0L;
        this.computationRequired = 0L;
        this.holdItem = null;
    }

    public void onFirstTick_EM(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.computationRemaining > 0L) {
                if (this.holdItem != null && ItemList.Tool_DataOrb.isStackEqual((Object)this.mInventory[1], false, true)) {
                    this.Training = true;
                }
                if (!this.Training) {
                    this.holdItem = null;
                    this.computationRemaining = 0L;
                    this.computationRequired = 0L;
                    this.mMaxProgresstime = 0;
                    this.mEfficiencyIncrease = 0;
                    for (MTEHatchRack r : this.eHolders) {
                        r.getBaseMetaTileEntity().setActive(false);
                    }
                }
            } else {
                this.Training = false;
            }
        }
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.computationRemaining <= 0L) {
            this.computationRemaining = 0L;
            this.mProgresstime = this.mMaxProgresstime;
            this.Training = false;
            return true;
        }
        this.computationRemaining -= this.eAvailableData;
        this.mProgresstime = 1;
        return super.onRunningTick(aStack);
    }

    public final boolean addHolderToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchRack) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eHolders.add((MTEHatchRack)aMetaTileEntity);
        }
        return false;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        super.onRightclick(aBaseMetaTileEntity, aPlayer);
        if (!aBaseMetaTileEntity.isClientSide() && aPlayer instanceof EntityPlayerMP) {
            try {
                EntityPlayerMP player = (EntityPlayerMP)aPlayer;
                this.clientLocale = (String)FieldUtils.readField((Object)player, (String)"translator", (boolean)true);
            }
            catch (Exception e) {
                this.clientLocale = "en_US";
            }
        } else {
            return true;
        }
        return true;
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        tag.func_74757_a("hasProblems", this.getIdealStatus() - this.getRepairStatus() > 0);
        tag.func_74776_a("efficiency", (float)this.mEfficiency / 100.0f);
        tag.func_74757_a("incompleteStructure", (this.getErrorDisplayID() & 0x40) != 0);
        tag.func_74772_a("computation", (this.computationRequired - this.computationRemaining) / 20L);
        tag.func_74772_a("computationRequired", this.computationRequired / 20L);
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("incompleteStructure")) {
            currentTip.add(SpecialChars.RED + "** INCOMPLETE STRUCTURE **" + SpecialChars.RESET);
        }
        currentTip.add((tag.func_74767_n("hasProblems") ? SpecialChars.RED + "** HAS PROBLEMS **" : SpecialChars.GREEN + "Running Fine") + SpecialChars.RESET + "  Efficiency: " + tag.func_74760_g("efficiency") + "%");
        currentTip.add(String.format("Computation: %,d / %,d", tag.func_74762_e("computation"), tag.func_74762_e("computationRequired")));
    }

    public int func_70297_j_() {
        return 1;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM("main", 1, 3, 4, stackSize, hintsOnly);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece("main", stackSize, 1, 3, 4, elementBudget, env, false, true);
    }

    public IStructureDefinition<TST_ResearchCenter> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    private static enum HolderHatchElement implements IHatchElement<TST_ResearchCenter>
    {
        INSTANCE;


        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(MTEHatchRack.class);
        }

        public IGTHatchAdder<? super TST_ResearchCenter> adder() {
            return TST_ResearchCenter::addHolderToMachineList;
        }

        public long count(TST_ResearchCenter t) {
            return t.eHolders.size();
        }
    }
}

